﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/dms/DatabaseMigrationService_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/dms/model/ReplicationTaskIndividualAssessment.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace DatabaseMigrationService
{
namespace Model
{
  /**
   * <p/><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessmentsResponse">AWS
   * API Reference</a></p>
   */
  class DescribeReplicationTaskIndividualAssessmentsResult
  {
  public:
    AWS_DATABASEMIGRATIONSERVICE_API DescribeReplicationTaskIndividualAssessmentsResult();
    AWS_DATABASEMIGRATIONSERVICE_API DescribeReplicationTaskIndividualAssessmentsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_DATABASEMIGRATIONSERVICE_API DescribeReplicationTaskIndividualAssessmentsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A pagination token returned for you to pass to a subsequent request. If you
     * pass this token as the <code>Marker</code> value in a subsequent request, the
     * response includes only records beyond the marker, up to the value specified in
     * the request by <code>MaxRecords</code>.</p>
     */
    inline const Aws::String& GetMarker() const{ return m_marker; }
    inline void SetMarker(const Aws::String& value) { m_marker = value; }
    inline void SetMarker(Aws::String&& value) { m_marker = std::move(value); }
    inline void SetMarker(const char* value) { m_marker.assign(value); }
    inline DescribeReplicationTaskIndividualAssessmentsResult& WithMarker(const Aws::String& value) { SetMarker(value); return *this;}
    inline DescribeReplicationTaskIndividualAssessmentsResult& WithMarker(Aws::String&& value) { SetMarker(std::move(value)); return *this;}
    inline DescribeReplicationTaskIndividualAssessmentsResult& WithMarker(const char* value) { SetMarker(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>One or more individual assessments as specified by <code>Filters</code>.</p>
     */
    inline const Aws::Vector<ReplicationTaskIndividualAssessment>& GetReplicationTaskIndividualAssessments() const{ return m_replicationTaskIndividualAssessments; }
    inline void SetReplicationTaskIndividualAssessments(const Aws::Vector<ReplicationTaskIndividualAssessment>& value) { m_replicationTaskIndividualAssessments = value; }
    inline void SetReplicationTaskIndividualAssessments(Aws::Vector<ReplicationTaskIndividualAssessment>&& value) { m_replicationTaskIndividualAssessments = std::move(value); }
    inline DescribeReplicationTaskIndividualAssessmentsResult& WithReplicationTaskIndividualAssessments(const Aws::Vector<ReplicationTaskIndividualAssessment>& value) { SetReplicationTaskIndividualAssessments(value); return *this;}
    inline DescribeReplicationTaskIndividualAssessmentsResult& WithReplicationTaskIndividualAssessments(Aws::Vector<ReplicationTaskIndividualAssessment>&& value) { SetReplicationTaskIndividualAssessments(std::move(value)); return *this;}
    inline DescribeReplicationTaskIndividualAssessmentsResult& AddReplicationTaskIndividualAssessments(const ReplicationTaskIndividualAssessment& value) { m_replicationTaskIndividualAssessments.push_back(value); return *this; }
    inline DescribeReplicationTaskIndividualAssessmentsResult& AddReplicationTaskIndividualAssessments(ReplicationTaskIndividualAssessment&& value) { m_replicationTaskIndividualAssessments.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline DescribeReplicationTaskIndividualAssessmentsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline DescribeReplicationTaskIndividualAssessmentsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline DescribeReplicationTaskIndividualAssessmentsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_marker;

    Aws::Vector<ReplicationTaskIndividualAssessment> m_replicationTaskIndividualAssessments;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace DatabaseMigrationService
} // namespace Aws
