﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/EC2Request.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/model/Filter.h>
#include <utility>

namespace Aws
{
namespace EC2
{
namespace Model
{

  /**
   * <p>Contains the parameters for
   * DescribeReservedInstancesModifications.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesModificationsRequest">AWS
   * API Reference</a></p>
   */
  class DescribeReservedInstancesModificationsRequest : public EC2Request
  {
  public:
    AWS_EC2_API DescribeReservedInstancesModificationsRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "DescribeReservedInstancesModifications"; }

    AWS_EC2_API Aws::String SerializePayload() const override;

  protected:
    AWS_EC2_API void DumpBodyToUrl(Aws::Http::URI& uri ) const override;

  public:

    ///@{
    /**
     * <p>One or more filters.</p> <ul> <li> <p> <code>client-token</code> - The
     * idempotency token for the modification request.</p> </li> <li> <p>
     * <code>create-date</code> - The time when the modification request was
     * created.</p> </li> <li> <p> <code>effective-date</code> - The time when the
     * modification becomes effective.</p> </li> <li> <p>
     * <code>modification-result.reserved-instances-id</code> - The ID for the Reserved
     * Instances created as part of the modification request. This ID is only available
     * when the status of the modification is <code>fulfilled</code>.</p> </li> <li>
     * <p> <code>modification-result.target-configuration.availability-zone</code> -
     * The Availability Zone for the new Reserved Instances.</p> </li> <li> <p>
     * <code>modification-result.target-configuration.instance-count </code> - The
     * number of new Reserved Instances.</p> </li> <li> <p>
     * <code>modification-result.target-configuration.instance-type</code> - The
     * instance type of the new Reserved Instances.</p> </li> <li> <p>
     * <code>reserved-instances-id</code> - The ID of the Reserved Instances
     * modified.</p> </li> <li> <p> <code>reserved-instances-modification-id</code> -
     * The ID of the modification request.</p> </li> <li> <p> <code>status</code> - The
     * status of the Reserved Instances modification request (<code>processing</code> |
     * <code>fulfilled</code> | <code>failed</code>).</p> </li> <li> <p>
     * <code>status-message</code> - The reason for the status.</p> </li> <li> <p>
     * <code>update-date</code> - The time when the modification request was last
     * updated.</p> </li> </ul>
     */
    inline const Aws::Vector<Filter>& GetFilters() const{ return m_filters; }
    inline bool FiltersHasBeenSet() const { return m_filtersHasBeenSet; }
    inline void SetFilters(const Aws::Vector<Filter>& value) { m_filtersHasBeenSet = true; m_filters = value; }
    inline void SetFilters(Aws::Vector<Filter>&& value) { m_filtersHasBeenSet = true; m_filters = std::move(value); }
    inline DescribeReservedInstancesModificationsRequest& WithFilters(const Aws::Vector<Filter>& value) { SetFilters(value); return *this;}
    inline DescribeReservedInstancesModificationsRequest& WithFilters(Aws::Vector<Filter>&& value) { SetFilters(std::move(value)); return *this;}
    inline DescribeReservedInstancesModificationsRequest& AddFilters(const Filter& value) { m_filtersHasBeenSet = true; m_filters.push_back(value); return *this; }
    inline DescribeReservedInstancesModificationsRequest& AddFilters(Filter&& value) { m_filtersHasBeenSet = true; m_filters.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>IDs for the submitted modification request.</p>
     */
    inline const Aws::Vector<Aws::String>& GetReservedInstancesModificationIds() const{ return m_reservedInstancesModificationIds; }
    inline bool ReservedInstancesModificationIdsHasBeenSet() const { return m_reservedInstancesModificationIdsHasBeenSet; }
    inline void SetReservedInstancesModificationIds(const Aws::Vector<Aws::String>& value) { m_reservedInstancesModificationIdsHasBeenSet = true; m_reservedInstancesModificationIds = value; }
    inline void SetReservedInstancesModificationIds(Aws::Vector<Aws::String>&& value) { m_reservedInstancesModificationIdsHasBeenSet = true; m_reservedInstancesModificationIds = std::move(value); }
    inline DescribeReservedInstancesModificationsRequest& WithReservedInstancesModificationIds(const Aws::Vector<Aws::String>& value) { SetReservedInstancesModificationIds(value); return *this;}
    inline DescribeReservedInstancesModificationsRequest& WithReservedInstancesModificationIds(Aws::Vector<Aws::String>&& value) { SetReservedInstancesModificationIds(std::move(value)); return *this;}
    inline DescribeReservedInstancesModificationsRequest& AddReservedInstancesModificationIds(const Aws::String& value) { m_reservedInstancesModificationIdsHasBeenSet = true; m_reservedInstancesModificationIds.push_back(value); return *this; }
    inline DescribeReservedInstancesModificationsRequest& AddReservedInstancesModificationIds(Aws::String&& value) { m_reservedInstancesModificationIdsHasBeenSet = true; m_reservedInstancesModificationIds.push_back(std::move(value)); return *this; }
    inline DescribeReservedInstancesModificationsRequest& AddReservedInstancesModificationIds(const char* value) { m_reservedInstancesModificationIdsHasBeenSet = true; m_reservedInstancesModificationIds.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The token to retrieve the next page of results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
    inline void SetNextToken(const Aws::String& value) { m_nextTokenHasBeenSet = true; m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextTokenHasBeenSet = true; m_nextToken.assign(value); }
    inline DescribeReservedInstancesModificationsRequest& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline DescribeReservedInstancesModificationsRequest& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline DescribeReservedInstancesModificationsRequest& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}
  private:

    Aws::Vector<Filter> m_filters;
    bool m_filtersHasBeenSet = false;

    Aws::Vector<Aws::String> m_reservedInstancesModificationIds;
    bool m_reservedInstancesModificationIdsHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;
  };

} // namespace Model
} // namespace EC2
} // namespace Aws
