﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/appflow/model/DataTransferApi.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Appflow
{
namespace Model
{

DataTransferApi::DataTransferApi() : 
    m_nameHasBeenSet(false),
    m_type(DataTransferApiType::NOT_SET),
    m_typeHasBeenSet(false)
{
}

DataTransferApi::DataTransferApi(JsonView jsonValue)
  : DataTransferApi()
{
  *this = jsonValue;
}

DataTransferApi& DataTransferApi::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Name"))
  {
    m_name = jsonValue.GetString("Name");

    m_nameHasBeenSet = true;
  }

  if(jsonValue.ValueExists("Type"))
  {
    m_type = DataTransferApiTypeMapper::GetDataTransferApiTypeForName(jsonValue.GetString("Type"));

    m_typeHasBeenSet = true;
  }

  return *this;
}

JsonValue DataTransferApi::Jsonize() const
{
  JsonValue payload;

  if(m_nameHasBeenSet)
  {
   payload.WithString("Name", m_name);

  }

  if(m_typeHasBeenSet)
  {
   payload.WithString("Type", DataTransferApiTypeMapper::GetNameForDataTransferApiType(m_type));
  }

  return payload;
}

} // namespace Model
} // namespace Appflow
} // namespace Aws
