﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-runtime/model/GuardrailConverseContentBlock.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace BedrockRuntime
{
namespace Model
{

GuardrailConverseContentBlock::GuardrailConverseContentBlock() : 
    m_textHasBeenSet(false)
{
}

GuardrailConverseContentBlock::GuardrailConverseContentBlock(JsonView jsonValue)
  : GuardrailConverseContentBlock()
{
  *this = jsonValue;
}

GuardrailConverseContentBlock& GuardrailConverseContentBlock::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("text"))
  {
    m_text = jsonValue.GetObject("text");

    m_textHasBeenSet = true;
  }

  return *this;
}

JsonValue GuardrailConverseContentBlock::Jsonize() const
{
  JsonValue payload;

  if(m_textHasBeenSet)
  {
   payload.WithObject("text", m_text.Jsonize());

  }

  return payload;
}

} // namespace Model
} // namespace BedrockRuntime
} // namespace Aws
