from logging import Logger
from typing import ClassVar, Final

from authlib.jose.rfc7519.claims import JWTClaims
from authlib.oauth2.rfc6749 import BaseGrant, TokenEndpointMixin

log: Logger
JWT_BEARER_GRANT_TYPE: Final[str]

class JWTBearerGrant(BaseGrant, TokenEndpointMixin):
    GRANT_TYPE = JWT_BEARER_GRANT_TYPE
    CLAIMS_OPTIONS: ClassVar[dict[str, dict[str, bool]]]
    LEEWAY: ClassVar[int]
    @staticmethod
    def sign(key, issuer, audience, subject=None, issued_at=None, expires_at=None, claims=None, **kwargs): ...
    def process_assertion_claims(self, assertion) -> JWTClaims: ...
    def resolve_public_key(self, headers, payload): ...
    def validate_token_request(self) -> None: ...
    def create_token_response(self): ...
    def resolve_issuer_client(self, issuer): ...
    def resolve_client_key(self, client, headers, payload): ...
    def authenticate_user(self, subject): ...
    def has_granted_permission(self, client, user) -> bool: ...
