import time
from logging import Logger
from typing import Final

from .models.entity import Entity
from .models.segment import Segment
from .models.subsegment import Subsegment

log: Logger
MISSING_SEGMENT_MSG: Final[str]
SUPPORTED_CONTEXT_MISSING: Final = ("RUNTIME_ERROR", "LOG_ERROR", "IGNORE_ERROR")
CXT_MISSING_STRATEGY_KEY: Final = "AWS_XRAY_CONTEXT_MISSING"

class Context:
    def __init__(self, context_missing: str = "LOG_ERROR") -> None: ...
    def put_segment(self, segment: Segment) -> None: ...
    def end_segment(self, end_time: time.struct_time | None = None) -> None: ...
    def put_subsegment(self, subsegment: Subsegment) -> None: ...
    def end_subsegment(self, end_time: time.struct_time | None = None) -> bool: ...
    def get_trace_entity(self) -> Entity: ...
    def set_trace_entity(self, trace_entity: Entity) -> None: ...
    def clear_trace_entities(self) -> None: ...
    def handle_context_missing(self) -> None: ...
    @property
    def context_missing(self) -> str: ...
    @context_missing.setter
    def context_missing(self, value: str) -> None: ...
