;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.

;; RUN: env BINARYEN_PRINT_FULL=1 wasm-opt %s --merge-blocks -S -o - | filecheck %s

;; The optimization below will replace the local.set with the block it contains
;; (i.e. it reorders them). While doing so we should keep the debug info of the
;; local.set.

(module
  ;; CHECK:      (func $test
  ;; CHECK-NEXT:  (local $temp i32)
  ;; CHECK-NEXT:  [none] ;;@ src.cpp:200:2
  ;; CHECK-NEXT:  [none](block
  ;; CHECK-NEXT:   [none] ;;@ src.cpp:200:2
  ;; CHECK-NEXT:   (call $test)
  ;; CHECK-NEXT:   [none] ;;@ src.cpp:200:2
  ;; CHECK-NEXT:   (local.set $temp
  ;; CHECK-NEXT:    [i32] ;;@ src.cpp:200:2
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  ) ;; end block
  ;; CHECK-NEXT: )
  (func $test
    (local $temp i32)

    ;; Everything here should stay with 200 as their debug info, while we
    ;; optimize (we can remove the inner block, move the call up to before
    ;; the local.set, and merge the outer blocks).

    ;;@ src.cpp:200:2
    (block
      (local.set $temp
        (block (result i32)
          (call $test)
          (i32.const 1)
        )
      )
    )
  )

  ;; CHECK:      (func $test-no-trample
  ;; CHECK-NEXT:  (local $temp i32)
  ;; CHECK-NEXT:  [none] ;;@ src.cpp:300:3
  ;; CHECK-NEXT:  [none](block
  ;; CHECK-NEXT:   [none] ;;@ src.cpp:400:4
  ;; CHECK-NEXT:   (call $test)
  ;; CHECK-NEXT:   [none] ;;@ src.cpp:200:2
  ;; CHECK-NEXT:   (local.set $temp
  ;; CHECK-NEXT:    [i32] ;;@ src.cpp:500:5
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  ) ;; end block
  ;; CHECK-NEXT:  ;;@ src.cpp:200:2
  ;; CHECK-NEXT: )
  (func $test-no-trample
    (local $temp i32)

    ;; As above, but now the inner block has debug info (300), which should not
    ;; be trampled as it is moved outside.

    ;;@ src.cpp:200:2
    (local.set $temp
      ;;@ src.cpp:300:3
      (block (result i32)
        ;;@ src.cpp:400:4
        (call $test)
        ;;@ src.cpp:500:5
        (i32.const 1)
      )
    )
  )
)
