/* SPDX-FileCopyrightText: 2023 Blender Authors
 *
 * SPDX-License-Identifier: GPL-2.0-or-later */

#include "infos/eevee_lightprobe_volume_info.hh"

VERTEX_SHADER_CREATE_INFO(eevee_debug_irradiance_grid)

#include "draw_view_lib.glsl"
#include "eevee_lightprobe_lib.glsl"

void main()
{
  ivec3 grid_resolution = textureSize(debug_data_tx, 0);
  ivec3 grid_sample;
  int sample_id = 0;
  if (debug_mode == DEBUG_IRRADIANCE_CACHE_VALIDITY) {
    /* Points. */
    sample_id = gl_VertexID;
  }
  else if (debug_mode == DEBUG_IRRADIANCE_CACHE_VIRTUAL_OFFSET) {
    /* Lines. */
    sample_id = gl_VertexID / 2;
  }

  grid_sample.x = (sample_id % grid_resolution.x);
  grid_sample.y = (sample_id / grid_resolution.x) % grid_resolution.y;
  grid_sample.z = (sample_id / (grid_resolution.x * grid_resolution.y));

  vec3 P = lightprobe_volume_grid_sample_position(grid_mat, grid_resolution, grid_sample);

  vec4 debug_data = texelFetch(debug_data_tx, grid_sample, 0);
  if (debug_mode == DEBUG_IRRADIANCE_CACHE_VALIDITY) {
    interp_color = vec4(1.0 - debug_data.r, debug_data.r, 0.0, 0.0);
    gl_PointSize = 3.0;
    if (debug_data.r > debug_value) {
      /* Only render points that are below threshold. */
      gl_Position = vec4(0.0);
      gl_PointSize = 0.0;
      return;
    }
  }
  else if (debug_mode == DEBUG_IRRADIANCE_CACHE_VIRTUAL_OFFSET) {
    if (is_zero(debug_data.xyz)) {
      /* Only render points that have offset. */
      gl_Position = vec4(0.0);
      gl_PointSize = 0.0;
      return;
    }

    if ((gl_VertexID & 1) == 1) {
      P += debug_data.xyz;
    }
  }

  gl_Position = drw_point_world_to_homogenous(P);
  gl_Position.z -= 2.5e-5;
  gl_PointSize = 3.0;
}
