//
// Copyright (c) 2019-2024 Ruben Perez Hidalgo (rubenperez038 at gmail dot com)
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//

#ifndef BOOST_MYSQL_MYSQL_COLLATIONS_HPP
#define BOOST_MYSQL_MYSQL_COLLATIONS_HPP

// This header was generated by collations.py - do not edit directly

#include <boost/config.hpp>

#include <cstdint>

namespace boost {
namespace mysql {
namespace mysql_collations {

// Identifies the big5_chinese_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t big5_chinese_ci = 1;

// Identifies the latin2_czech_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin2_czech_cs = 2;

// Identifies the dec8_swedish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t dec8_swedish_ci = 3;

// Identifies the cp850_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp850_general_ci = 4;

// Identifies the latin1_german1_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin1_german1_ci = 5;

// Identifies the hp8_english_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t hp8_english_ci = 6;

// Identifies the koi8r_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t koi8r_general_ci = 7;

// Identifies the latin1_swedish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin1_swedish_ci = 8;

// Identifies the latin2_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin2_general_ci = 9;

// Identifies the swe7_swedish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t swe7_swedish_ci = 10;

// Identifies the ascii_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ascii_general_ci = 11;

// Identifies the ujis_japanese_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ujis_japanese_ci = 12;

// Identifies the sjis_japanese_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t sjis_japanese_ci = 13;

// Identifies the cp1251_bulgarian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1251_bulgarian_ci = 14;

// Identifies the latin1_danish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin1_danish_ci = 15;

// Identifies the hebrew_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t hebrew_general_ci = 16;

// Identifies the tis620_thai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t tis620_thai_ci = 18;

// Identifies the euckr_korean_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t euckr_korean_ci = 19;

// Identifies the latin7_estonian_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin7_estonian_cs = 20;

// Identifies the latin2_hungarian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin2_hungarian_ci = 21;

// Identifies the koi8u_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t koi8u_general_ci = 22;

// Identifies the cp1251_ukrainian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1251_ukrainian_ci = 23;

// Identifies the gb2312_chinese_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t gb2312_chinese_ci = 24;

// Identifies the greek_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t greek_general_ci = 25;

// Identifies the cp1250_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1250_general_ci = 26;

// Identifies the latin2_croatian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin2_croatian_ci = 27;

// Identifies the gbk_chinese_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t gbk_chinese_ci = 28;

// Identifies the cp1257_lithuanian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1257_lithuanian_ci = 29;

// Identifies the latin5_turkish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin5_turkish_ci = 30;

// Identifies the latin1_german2_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin1_german2_ci = 31;

// Identifies the armscii8_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t armscii8_general_ci = 32;

// Identifies the utf8_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_general_ci = 33;

// Identifies the cp1250_czech_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1250_czech_cs = 34;

// Identifies the ucs2_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_general_ci = 35;

// Identifies the cp866_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp866_general_ci = 36;

// Identifies the keybcs2_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t keybcs2_general_ci = 37;

// Identifies the macce_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t macce_general_ci = 38;

// Identifies the macroman_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t macroman_general_ci = 39;

// Identifies the cp852_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp852_general_ci = 40;

// Identifies the latin7_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin7_general_ci = 41;

// Identifies the latin7_general_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin7_general_cs = 42;

// Identifies the macce_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t macce_bin = 43;

// Identifies the cp1250_croatian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1250_croatian_ci = 44;

// Identifies the utf8mb4_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_general_ci = 45;

// Identifies the utf8mb4_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_bin = 46;

// Identifies the latin1_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin1_bin = 47;

// Identifies the latin1_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin1_general_ci = 48;

// Identifies the latin1_general_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin1_general_cs = 49;

// Identifies the cp1251_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1251_bin = 50;

// Identifies the cp1251_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1251_general_ci = 51;

// Identifies the cp1251_general_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1251_general_cs = 52;

// Identifies the macroman_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t macroman_bin = 53;

// Identifies the utf16_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_general_ci = 54;

// Identifies the utf16_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_bin = 55;

// Identifies the utf16le_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16le_general_ci = 56;

// Identifies the cp1256_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1256_general_ci = 57;

// Identifies the cp1257_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1257_bin = 58;

// Identifies the cp1257_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1257_general_ci = 59;

// Identifies the utf32_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_general_ci = 60;

// Identifies the utf32_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_bin = 61;

// Identifies the utf16le_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16le_bin = 62;

// Identifies the binary collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t binary = 63;

// Identifies the armscii8_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t armscii8_bin = 64;

// Identifies the ascii_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ascii_bin = 65;

// Identifies the cp1250_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1250_bin = 66;

// Identifies the cp1256_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1256_bin = 67;

// Identifies the cp866_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp866_bin = 68;

// Identifies the dec8_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t dec8_bin = 69;

// Identifies the greek_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t greek_bin = 70;

// Identifies the hebrew_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t hebrew_bin = 71;

// Identifies the hp8_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t hp8_bin = 72;

// Identifies the keybcs2_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t keybcs2_bin = 73;

// Identifies the koi8r_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t koi8r_bin = 74;

// Identifies the koi8u_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t koi8u_bin = 75;

// Identifies the utf8_tolower_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_tolower_ci = 76;

// Identifies the latin2_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin2_bin = 77;

// Identifies the latin5_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin5_bin = 78;

// Identifies the latin7_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin7_bin = 79;

// Identifies the cp850_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp850_bin = 80;

// Identifies the cp852_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp852_bin = 81;

// Identifies the swe7_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t swe7_bin = 82;

// Identifies the utf8_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_bin = 83;

// Identifies the big5_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t big5_bin = 84;

// Identifies the euckr_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t euckr_bin = 85;

// Identifies the gb2312_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t gb2312_bin = 86;

// Identifies the gbk_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t gbk_bin = 87;

// Identifies the sjis_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t sjis_bin = 88;

// Identifies the tis620_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t tis620_bin = 89;

// Identifies the ucs2_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_bin = 90;

// Identifies the ujis_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ujis_bin = 91;

// Identifies the geostd8_general_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t geostd8_general_ci = 92;

// Identifies the geostd8_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t geostd8_bin = 93;

// Identifies the latin1_spanish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t latin1_spanish_ci = 94;

// Identifies the cp932_japanese_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp932_japanese_ci = 95;

// Identifies the cp932_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp932_bin = 96;

// Identifies the eucjpms_japanese_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t eucjpms_japanese_ci = 97;

// Identifies the eucjpms_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t eucjpms_bin = 98;

// Identifies the cp1250_polish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t cp1250_polish_ci = 99;

// Identifies the utf16_unicode_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_unicode_ci = 101;

// Identifies the utf16_icelandic_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_icelandic_ci = 102;

// Identifies the utf16_latvian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_latvian_ci = 103;

// Identifies the utf16_romanian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_romanian_ci = 104;

// Identifies the utf16_slovenian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_slovenian_ci = 105;

// Identifies the utf16_polish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_polish_ci = 106;

// Identifies the utf16_estonian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_estonian_ci = 107;

// Identifies the utf16_spanish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_spanish_ci = 108;

// Identifies the utf16_swedish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_swedish_ci = 109;

// Identifies the utf16_turkish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_turkish_ci = 110;

// Identifies the utf16_czech_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_czech_ci = 111;

// Identifies the utf16_danish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_danish_ci = 112;

// Identifies the utf16_lithuanian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_lithuanian_ci = 113;

// Identifies the utf16_slovak_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_slovak_ci = 114;

// Identifies the utf16_spanish2_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_spanish2_ci = 115;

// Identifies the utf16_roman_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_roman_ci = 116;

// Identifies the utf16_persian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_persian_ci = 117;

// Identifies the utf16_esperanto_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_esperanto_ci = 118;

// Identifies the utf16_hungarian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_hungarian_ci = 119;

// Identifies the utf16_sinhala_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_sinhala_ci = 120;

// Identifies the utf16_german2_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_german2_ci = 121;

// Identifies the utf16_croatian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_croatian_ci = 122;

// Identifies the utf16_unicode_520_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_unicode_520_ci = 123;

// Identifies the utf16_vietnamese_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf16_vietnamese_ci = 124;

// Identifies the ucs2_unicode_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_unicode_ci = 128;

// Identifies the ucs2_icelandic_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_icelandic_ci = 129;

// Identifies the ucs2_latvian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_latvian_ci = 130;

// Identifies the ucs2_romanian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_romanian_ci = 131;

// Identifies the ucs2_slovenian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_slovenian_ci = 132;

// Identifies the ucs2_polish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_polish_ci = 133;

// Identifies the ucs2_estonian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_estonian_ci = 134;

// Identifies the ucs2_spanish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_spanish_ci = 135;

// Identifies the ucs2_swedish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_swedish_ci = 136;

// Identifies the ucs2_turkish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_turkish_ci = 137;

// Identifies the ucs2_czech_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_czech_ci = 138;

// Identifies the ucs2_danish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_danish_ci = 139;

// Identifies the ucs2_lithuanian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_lithuanian_ci = 140;

// Identifies the ucs2_slovak_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_slovak_ci = 141;

// Identifies the ucs2_spanish2_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_spanish2_ci = 142;

// Identifies the ucs2_roman_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_roman_ci = 143;

// Identifies the ucs2_persian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_persian_ci = 144;

// Identifies the ucs2_esperanto_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_esperanto_ci = 145;

// Identifies the ucs2_hungarian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_hungarian_ci = 146;

// Identifies the ucs2_sinhala_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_sinhala_ci = 147;

// Identifies the ucs2_german2_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_german2_ci = 148;

// Identifies the ucs2_croatian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_croatian_ci = 149;

// Identifies the ucs2_unicode_520_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_unicode_520_ci = 150;

// Identifies the ucs2_vietnamese_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_vietnamese_ci = 151;

// Identifies the ucs2_general_mysql500_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t ucs2_general_mysql500_ci = 159;

// Identifies the utf32_unicode_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_unicode_ci = 160;

// Identifies the utf32_icelandic_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_icelandic_ci = 161;

// Identifies the utf32_latvian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_latvian_ci = 162;

// Identifies the utf32_romanian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_romanian_ci = 163;

// Identifies the utf32_slovenian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_slovenian_ci = 164;

// Identifies the utf32_polish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_polish_ci = 165;

// Identifies the utf32_estonian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_estonian_ci = 166;

// Identifies the utf32_spanish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_spanish_ci = 167;

// Identifies the utf32_swedish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_swedish_ci = 168;

// Identifies the utf32_turkish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_turkish_ci = 169;

// Identifies the utf32_czech_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_czech_ci = 170;

// Identifies the utf32_danish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_danish_ci = 171;

// Identifies the utf32_lithuanian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_lithuanian_ci = 172;

// Identifies the utf32_slovak_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_slovak_ci = 173;

// Identifies the utf32_spanish2_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_spanish2_ci = 174;

// Identifies the utf32_roman_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_roman_ci = 175;

// Identifies the utf32_persian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_persian_ci = 176;

// Identifies the utf32_esperanto_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_esperanto_ci = 177;

// Identifies the utf32_hungarian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_hungarian_ci = 178;

// Identifies the utf32_sinhala_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_sinhala_ci = 179;

// Identifies the utf32_german2_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_german2_ci = 180;

// Identifies the utf32_croatian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_croatian_ci = 181;

// Identifies the utf32_unicode_520_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_unicode_520_ci = 182;

// Identifies the utf32_vietnamese_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf32_vietnamese_ci = 183;

// Identifies the utf8_unicode_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_unicode_ci = 192;

// Identifies the utf8_icelandic_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_icelandic_ci = 193;

// Identifies the utf8_latvian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_latvian_ci = 194;

// Identifies the utf8_romanian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_romanian_ci = 195;

// Identifies the utf8_slovenian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_slovenian_ci = 196;

// Identifies the utf8_polish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_polish_ci = 197;

// Identifies the utf8_estonian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_estonian_ci = 198;

// Identifies the utf8_spanish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_spanish_ci = 199;

// Identifies the utf8_swedish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_swedish_ci = 200;

// Identifies the utf8_turkish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_turkish_ci = 201;

// Identifies the utf8_czech_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_czech_ci = 202;

// Identifies the utf8_danish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_danish_ci = 203;

// Identifies the utf8_lithuanian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_lithuanian_ci = 204;

// Identifies the utf8_slovak_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_slovak_ci = 205;

// Identifies the utf8_spanish2_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_spanish2_ci = 206;

// Identifies the utf8_roman_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_roman_ci = 207;

// Identifies the utf8_persian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_persian_ci = 208;

// Identifies the utf8_esperanto_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_esperanto_ci = 209;

// Identifies the utf8_hungarian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_hungarian_ci = 210;

// Identifies the utf8_sinhala_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_sinhala_ci = 211;

// Identifies the utf8_german2_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_german2_ci = 212;

// Identifies the utf8_croatian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_croatian_ci = 213;

// Identifies the utf8_unicode_520_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_unicode_520_ci = 214;

// Identifies the utf8_vietnamese_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_vietnamese_ci = 215;

// Identifies the utf8_general_mysql500_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8_general_mysql500_ci = 223;

// Identifies the utf8mb4_unicode_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_unicode_ci = 224;

// Identifies the utf8mb4_icelandic_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_icelandic_ci = 225;

// Identifies the utf8mb4_latvian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_latvian_ci = 226;

// Identifies the utf8mb4_romanian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_romanian_ci = 227;

// Identifies the utf8mb4_slovenian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_slovenian_ci = 228;

// Identifies the utf8mb4_polish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_polish_ci = 229;

// Identifies the utf8mb4_estonian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_estonian_ci = 230;

// Identifies the utf8mb4_spanish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_spanish_ci = 231;

// Identifies the utf8mb4_swedish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_swedish_ci = 232;

// Identifies the utf8mb4_turkish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_turkish_ci = 233;

// Identifies the utf8mb4_czech_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_czech_ci = 234;

// Identifies the utf8mb4_danish_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_danish_ci = 235;

// Identifies the utf8mb4_lithuanian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_lithuanian_ci = 236;

// Identifies the utf8mb4_slovak_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_slovak_ci = 237;

// Identifies the utf8mb4_spanish2_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_spanish2_ci = 238;

// Identifies the utf8mb4_roman_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_roman_ci = 239;

// Identifies the utf8mb4_persian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_persian_ci = 240;

// Identifies the utf8mb4_esperanto_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_esperanto_ci = 241;

// Identifies the utf8mb4_hungarian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_hungarian_ci = 242;

// Identifies the utf8mb4_sinhala_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_sinhala_ci = 243;

// Identifies the utf8mb4_german2_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_german2_ci = 244;

// Identifies the utf8mb4_croatian_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_croatian_ci = 245;

// Identifies the utf8mb4_unicode_520_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_unicode_520_ci = 246;

// Identifies the utf8mb4_vietnamese_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_vietnamese_ci = 247;

// Identifies the gb18030_chinese_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t gb18030_chinese_ci = 248;

// Identifies the gb18030_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t gb18030_bin = 249;

// Identifies the gb18030_unicode_520_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t gb18030_unicode_520_ci = 250;

// Identifies the utf8mb4_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_0900_ai_ci = 255;

// Identifies the utf8mb4_de_pb_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_de_pb_0900_ai_ci = 256;

// Identifies the utf8mb4_is_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_is_0900_ai_ci = 257;

// Identifies the utf8mb4_lv_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_lv_0900_ai_ci = 258;

// Identifies the utf8mb4_ro_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_ro_0900_ai_ci = 259;

// Identifies the utf8mb4_sl_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_sl_0900_ai_ci = 260;

// Identifies the utf8mb4_pl_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_pl_0900_ai_ci = 261;

// Identifies the utf8mb4_et_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_et_0900_ai_ci = 262;

// Identifies the utf8mb4_es_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_es_0900_ai_ci = 263;

// Identifies the utf8mb4_sv_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_sv_0900_ai_ci = 264;

// Identifies the utf8mb4_tr_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_tr_0900_ai_ci = 265;

// Identifies the utf8mb4_cs_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_cs_0900_ai_ci = 266;

// Identifies the utf8mb4_da_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_da_0900_ai_ci = 267;

// Identifies the utf8mb4_lt_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_lt_0900_ai_ci = 268;

// Identifies the utf8mb4_sk_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_sk_0900_ai_ci = 269;

// Identifies the utf8mb4_es_trad_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_es_trad_0900_ai_ci = 270;

// Identifies the utf8mb4_la_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_la_0900_ai_ci = 271;

// Identifies the utf8mb4_eo_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_eo_0900_ai_ci = 273;

// Identifies the utf8mb4_hu_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_hu_0900_ai_ci = 274;

// Identifies the utf8mb4_hr_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_hr_0900_ai_ci = 275;

// Identifies the utf8mb4_vi_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_vi_0900_ai_ci = 277;

// Identifies the utf8mb4_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_0900_as_cs = 278;

// Identifies the utf8mb4_de_pb_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_de_pb_0900_as_cs = 279;

// Identifies the utf8mb4_is_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_is_0900_as_cs = 280;

// Identifies the utf8mb4_lv_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_lv_0900_as_cs = 281;

// Identifies the utf8mb4_ro_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_ro_0900_as_cs = 282;

// Identifies the utf8mb4_sl_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_sl_0900_as_cs = 283;

// Identifies the utf8mb4_pl_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_pl_0900_as_cs = 284;

// Identifies the utf8mb4_et_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_et_0900_as_cs = 285;

// Identifies the utf8mb4_es_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_es_0900_as_cs = 286;

// Identifies the utf8mb4_sv_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_sv_0900_as_cs = 287;

// Identifies the utf8mb4_tr_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_tr_0900_as_cs = 288;

// Identifies the utf8mb4_cs_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_cs_0900_as_cs = 289;

// Identifies the utf8mb4_da_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_da_0900_as_cs = 290;

// Identifies the utf8mb4_lt_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_lt_0900_as_cs = 291;

// Identifies the utf8mb4_sk_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_sk_0900_as_cs = 292;

// Identifies the utf8mb4_es_trad_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_es_trad_0900_as_cs = 293;

// Identifies the utf8mb4_la_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_la_0900_as_cs = 294;

// Identifies the utf8mb4_eo_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_eo_0900_as_cs = 296;

// Identifies the utf8mb4_hu_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_hu_0900_as_cs = 297;

// Identifies the utf8mb4_hr_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_hr_0900_as_cs = 298;

// Identifies the utf8mb4_vi_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_vi_0900_as_cs = 300;

// Identifies the utf8mb4_ja_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_ja_0900_as_cs = 303;

// Identifies the utf8mb4_ja_0900_as_cs_ks collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_ja_0900_as_cs_ks = 304;

// Identifies the utf8mb4_0900_as_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_0900_as_ci = 305;

// Identifies the utf8mb4_ru_0900_ai_ci collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_ru_0900_ai_ci = 306;

// Identifies the utf8mb4_ru_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_ru_0900_as_cs = 307;

// Identifies the utf8mb4_zh_0900_as_cs collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_zh_0900_as_cs = 308;

// Identifies the utf8mb4_0900_bin collation in mysql servers.
BOOST_INLINE_CONSTEXPR std::uint16_t utf8mb4_0900_bin = 309;

}  // namespace mysql_collations
}  // namespace mysql
}  // namespace boost

#endif
