; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx900 --denormal-fp-math=preserve-sign < %s | FileCheck -check-prefix=GFX9-FAST-DENORM %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx1010 --denormal-fp-math=preserve-sign < %s | FileCheck -check-prefix=GFX10-FAST-DENORM %s

; fold (fadd fast (fpext (fmul fast x, y)), z) -> (fma (fpext x), (fpext y), z)
; fold (fadd fast x, (fpext (fmul fast y, z))) -> (fma (fpext y), (fpext z), x)

define amdgpu_vs float @test_f16_f32_add_ext_mul(half inreg %x, half inreg %y, float inreg %z) {
; GFX9-FAST-DENORM-LABEL: test_f16_f32_add_ext_mul:
; GFX9-FAST-DENORM:       ; %bb.0: ; %.entry
; GFX9-FAST-DENORM-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-FAST-DENORM-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-FAST-DENORM-NEXT:    v_mad_mix_f32 v0, s0, v0, v1 op_sel_hi:[1,1,0]
; GFX9-FAST-DENORM-NEXT:    ; return to shader part epilog
;
; GFX10-FAST-DENORM-LABEL: test_f16_f32_add_ext_mul:
; GFX10-FAST-DENORM:       ; %bb.0: ; %.entry
; GFX10-FAST-DENORM-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-FAST-DENORM-NEXT:    v_fma_mix_f32 v0, s0, s1, v0 op_sel_hi:[1,1,0]
; GFX10-FAST-DENORM-NEXT:    ; return to shader part epilog
.entry:
    %a = fmul fast half %x, %y
    %b = fpext half %a to float
    %c = fadd fast float %b, %z
    ret float %c
}

define amdgpu_vs float @test_f16_f32_add_ext_mul_rhs(half inreg %x, half inreg %y, float inreg %z) {
; GFX9-FAST-DENORM-LABEL: test_f16_f32_add_ext_mul_rhs:
; GFX9-FAST-DENORM:       ; %bb.0: ; %.entry
; GFX9-FAST-DENORM-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-FAST-DENORM-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-FAST-DENORM-NEXT:    v_mad_mix_f32 v0, s0, v0, v1 op_sel_hi:[1,1,0]
; GFX9-FAST-DENORM-NEXT:    ; return to shader part epilog
;
; GFX10-FAST-DENORM-LABEL: test_f16_f32_add_ext_mul_rhs:
; GFX10-FAST-DENORM:       ; %bb.0: ; %.entry
; GFX10-FAST-DENORM-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-FAST-DENORM-NEXT:    v_fma_mix_f32 v0, s0, s1, v0 op_sel_hi:[1,1,0]
; GFX10-FAST-DENORM-NEXT:    ; return to shader part epilog
.entry:
    %a = fmul fast half %x, %y
    %b = fpext half %a to float
    %c = fadd fast float %z, %b
    ret float %c
}

define amdgpu_vs <5 x float> @test_5xf16_5xf32_add_ext_mul(<5 x half> inreg %x, <5 x half> inreg %y, <5 x float> inreg %z) {
; GFX9-FAST-DENORM-LABEL: test_5xf16_5xf32_add_ext_mul:
; GFX9-FAST-DENORM:       ; %bb.0: ; %.entry
; GFX9-FAST-DENORM-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-FAST-DENORM-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-FAST-DENORM-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-FAST-DENORM-NEXT:    v_pk_mul_f16 v0, s0, v0
; GFX9-FAST-DENORM-NEXT:    v_pk_mul_f16 v1, s1, v1
; GFX9-FAST-DENORM-NEXT:    v_pk_mul_f16 v2, s2, v2
; GFX9-FAST-DENORM-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX9-FAST-DENORM-NEXT:    v_cvt_f32_f16_sdwa v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-FAST-DENORM-NEXT:    v_cvt_f32_f16_e32 v5, v1
; GFX9-FAST-DENORM-NEXT:    v_cvt_f32_f16_sdwa v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-FAST-DENORM-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX9-FAST-DENORM-NEXT:    v_add_f32_e32 v0, s6, v3
; GFX9-FAST-DENORM-NEXT:    v_add_f32_e32 v1, s7, v4
; GFX9-FAST-DENORM-NEXT:    v_add_f32_e32 v2, s8, v5
; GFX9-FAST-DENORM-NEXT:    v_add_f32_e32 v3, s9, v6
; GFX9-FAST-DENORM-NEXT:    v_add_f32_e32 v4, s10, v7
; GFX9-FAST-DENORM-NEXT:    ; return to shader part epilog
;
; GFX10-FAST-DENORM-LABEL: test_5xf16_5xf32_add_ext_mul:
; GFX10-FAST-DENORM:       ; %bb.0: ; %.entry
; GFX10-FAST-DENORM-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-FAST-DENORM-NEXT:    v_mov_b32_e32 v1, s7
; GFX10-FAST-DENORM-NEXT:    v_mov_b32_e32 v2, s8
; GFX10-FAST-DENORM-NEXT:    v_mov_b32_e32 v3, s9
; GFX10-FAST-DENORM-NEXT:    v_mov_b32_e32 v4, s10
; GFX10-FAST-DENORM-NEXT:    v_fma_mix_f32 v0, s0, s3, v0 op_sel_hi:[1,1,0]
; GFX10-FAST-DENORM-NEXT:    v_fma_mix_f32 v1, s0, s3, v1 op_sel:[1,1,0] op_sel_hi:[1,1,0]
; GFX10-FAST-DENORM-NEXT:    v_fma_mix_f32 v2, s1, s4, v2 op_sel_hi:[1,1,0]
; GFX10-FAST-DENORM-NEXT:    v_fma_mix_f32 v3, s1, s4, v3 op_sel:[1,1,0] op_sel_hi:[1,1,0]
; GFX10-FAST-DENORM-NEXT:    v_fma_mix_f32 v4, s2, s5, v4 op_sel_hi:[1,1,0]
; GFX10-FAST-DENORM-NEXT:    ; return to shader part epilog
.entry:
    %a = fmul fast <5 x half> %x, %y
    %b = fpext <5 x half> %a to <5 x float>
    %c = fadd fast <5 x float> %b, %z
    ret <5 x float> %c
}

define amdgpu_vs <6 x float> @test_6xf16_6xf32_add_ext_mul_rhs(<6 x half> inreg %x, <6 x half> inreg %y, <6 x float> inreg %z) {
; GFX9-FAST-DENORM-LABEL: test_6xf16_6xf32_add_ext_mul_rhs:
; GFX9-FAST-DENORM:       ; %bb.0: ; %.entry
; GFX9-FAST-DENORM-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-FAST-DENORM-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-FAST-DENORM-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-FAST-DENORM-NEXT:    v_pk_mul_f16 v0, s0, v0
; GFX9-FAST-DENORM-NEXT:    v_pk_mul_f16 v1, s1, v1
; GFX9-FAST-DENORM-NEXT:    v_pk_mul_f16 v2, s2, v2
; GFX9-FAST-DENORM-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX9-FAST-DENORM-NEXT:    v_cvt_f32_f16_sdwa v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-FAST-DENORM-NEXT:    v_cvt_f32_f16_e32 v5, v1
; GFX9-FAST-DENORM-NEXT:    v_cvt_f32_f16_sdwa v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-FAST-DENORM-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX9-FAST-DENORM-NEXT:    v_cvt_f32_f16_sdwa v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-FAST-DENORM-NEXT:    v_add_f32_e32 v0, s6, v3
; GFX9-FAST-DENORM-NEXT:    v_add_f32_e32 v1, s7, v4
; GFX9-FAST-DENORM-NEXT:    v_add_f32_e32 v2, s8, v5
; GFX9-FAST-DENORM-NEXT:    v_add_f32_e32 v3, s9, v6
; GFX9-FAST-DENORM-NEXT:    v_add_f32_e32 v4, s10, v7
; GFX9-FAST-DENORM-NEXT:    v_add_f32_e32 v5, s11, v8
; GFX9-FAST-DENORM-NEXT:    ; return to shader part epilog
;
; GFX10-FAST-DENORM-LABEL: test_6xf16_6xf32_add_ext_mul_rhs:
; GFX10-FAST-DENORM:       ; %bb.0: ; %.entry
; GFX10-FAST-DENORM-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-FAST-DENORM-NEXT:    v_mov_b32_e32 v1, s7
; GFX10-FAST-DENORM-NEXT:    v_mov_b32_e32 v2, s8
; GFX10-FAST-DENORM-NEXT:    v_mov_b32_e32 v3, s9
; GFX10-FAST-DENORM-NEXT:    v_mov_b32_e32 v4, s10
; GFX10-FAST-DENORM-NEXT:    v_mov_b32_e32 v5, s11
; GFX10-FAST-DENORM-NEXT:    v_fma_mix_f32 v0, s0, s3, v0 op_sel_hi:[1,1,0]
; GFX10-FAST-DENORM-NEXT:    v_fma_mix_f32 v1, s0, s3, v1 op_sel:[1,1,0] op_sel_hi:[1,1,0]
; GFX10-FAST-DENORM-NEXT:    v_fma_mix_f32 v2, s1, s4, v2 op_sel_hi:[1,1,0]
; GFX10-FAST-DENORM-NEXT:    v_fma_mix_f32 v3, s1, s4, v3 op_sel:[1,1,0] op_sel_hi:[1,1,0]
; GFX10-FAST-DENORM-NEXT:    v_fma_mix_f32 v4, s2, s5, v4 op_sel_hi:[1,1,0]
; GFX10-FAST-DENORM-NEXT:    v_fma_mix_f32 v5, s2, s5, v5 op_sel:[1,1,0] op_sel_hi:[1,1,0]
; GFX10-FAST-DENORM-NEXT:    ; return to shader part epilog
.entry:
    %a = fmul fast <6 x half> %x, %y
    %b = fpext <6 x half> %a to <6 x float>
    %c = fadd fast <6 x float> %z, %b
    ret <6 x float> %c
}
