; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=amdgcn -mcpu=verde -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX6 %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX8 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12 %s

define amdgpu_kernel void @s_add_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX6-LABEL: s_add_i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_add_i32 s4, s4, s5
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: s_add_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_i32 s0, s2, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: s_add_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_add_i32 s2, s2, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: s_add_i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_i32 s2, s2, s3
; GFX10-NEXT:    v_mov_b32_e32 v1, s2
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_add_i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_i32 s2, s2, s3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: s_add_i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_add_co_i32 s2, s2, s3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %b_ptr = getelementptr i32, ptr addrspace(1) %in, i32 1
  %a = load i32, ptr addrspace(1) %in
  %b = load i32, ptr addrspace(1) %b_ptr
  %result = add i32 %a, %b
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_add_v2i32(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GFX6-LABEL: s_add_v2i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_add_i32 s5, s5, s7
; GFX6-NEXT:    s_add_i32 s4, s4, s6
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: s_add_v2i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_i32 s0, s5, s7
; GFX8-NEXT:    s_add_i32 s1, s4, s6
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: s_add_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_add_i32 s2, s5, s7
; GFX9-NEXT:    s_add_i32 s3, s4, s6
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: s_add_v2i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_i32 s2, s4, s6
; GFX10-NEXT:    s_add_i32 s3, s5, s7
; GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-NEXT:    v_mov_b32_e32 v1, s3
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_add_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_i32 s2, s4, s6
; GFX11-NEXT:    s_add_i32 s3, s5, s7
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: s_add_v2i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_add_co_i32 s2, s4, s6
; GFX12-NEXT:    s_add_co_i32 s3, s5, s7
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %b_ptr = getelementptr <2 x i32>, ptr addrspace(1) %in, i32 1
  %a = load <2 x i32>, ptr addrspace(1) %in
  %b = load <2 x i32>, ptr addrspace(1) %b_ptr
  %result = add <2 x i32> %a, %b
  store <2 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_add_v4i32(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GFX6-LABEL: s_add_v4i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX6-NEXT:    s_mov_b32 s11, 0xf000
; GFX6-NEXT:    s_mov_b32 s10, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_add_i32 s3, s3, s7
; GFX6-NEXT:    s_add_i32 s2, s2, s6
; GFX6-NEXT:    s_add_i32 s1, s1, s5
; GFX6-NEXT:    s_add_i32 s0, s0, s4
; GFX6-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    v_mov_b32_e32 v2, s2
; GFX6-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: s_add_v4i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_i32 s3, s3, s7
; GFX8-NEXT:    s_add_i32 s2, s2, s6
; GFX8-NEXT:    s_add_i32 s1, s1, s5
; GFX8-NEXT:    s_add_i32 s0, s0, s4
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: s_add_v4i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_add_i32 s3, s3, s7
; GFX9-NEXT:    s_add_i32 s2, s2, s6
; GFX9-NEXT:    s_add_i32 s1, s1, s5
; GFX9-NEXT:    s_add_i32 s0, s0, s4
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[8:9]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: s_add_v4i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_i32 s3, s3, s7
; GFX10-NEXT:    s_add_i32 s2, s2, s6
; GFX10-NEXT:    s_add_i32 s0, s0, s4
; GFX10-NEXT:    s_add_i32 s1, s1, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    global_store_dwordx4 v4, v[0:3], s[8:9]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_add_v4i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[8:11], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b256 s[0:7], s[10:11], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_i32 s3, s3, s7
; GFX11-NEXT:    s_add_i32 s2, s2, s6
; GFX11-NEXT:    s_add_i32 s0, s0, s4
; GFX11-NEXT:    s_add_i32 s1, s1, s5
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    global_store_b128 v4, v[0:3], s[8:9]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: s_add_v4i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[8:11], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b256 s[0:7], s[10:11], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_add_co_i32 s3, s3, s7
; GFX12-NEXT:    s_add_co_i32 s2, s2, s6
; GFX12-NEXT:    s_add_co_i32 s0, s0, s4
; GFX12-NEXT:    s_add_co_i32 s1, s1, s5
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    v_mov_b32_e32 v2, s2
; GFX12-NEXT:    global_store_b128 v4, v[0:3], s[8:9]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %b_ptr = getelementptr <4 x i32>, ptr addrspace(1) %in, i32 1
  %a = load <4 x i32>, ptr addrspace(1) %in
  %b = load <4 x i32>, ptr addrspace(1) %b_ptr
  %result = add <4 x i32> %a, %b
  store <4 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_add_v8i32(ptr addrspace(1) %out, <8 x i32> %a, <8 x i32> %b) {
; GFX6-LABEL: s_add_v8i32:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dwordx16 s[4:19], s[0:1], 0x11
; GFX6-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_add_i32 s11, s11, s19
; GFX6-NEXT:    s_add_i32 s10, s10, s18
; GFX6-NEXT:    s_add_i32 s9, s9, s17
; GFX6-NEXT:    s_add_i32 s8, s8, s16
; GFX6-NEXT:    s_add_i32 s7, s7, s15
; GFX6-NEXT:    s_add_i32 s6, s6, s14
; GFX6-NEXT:    s_add_i32 s5, s5, s13
; GFX6-NEXT:    s_add_i32 s4, s4, s12
; GFX6-NEXT:    v_mov_b32_e32 v0, s8
; GFX6-NEXT:    v_mov_b32_e32 v1, s9
; GFX6-NEXT:    v_mov_b32_e32 v2, s10
; GFX6-NEXT:    v_mov_b32_e32 v3, s11
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NEXT:    v_mov_b32_e32 v3, s7
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: s_add_v8i32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx16 s[4:19], s[0:1], 0x44
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_i32 s7, s7, s15
; GFX8-NEXT:    s_add_i32 s6, s6, s14
; GFX8-NEXT:    s_add_i32 s5, s5, s13
; GFX8-NEXT:    s_add_i32 s4, s4, s12
; GFX8-NEXT:    s_add_i32 s2, s11, s19
; GFX8-NEXT:    s_add_i32 s3, s10, s18
; GFX8-NEXT:    s_add_i32 s9, s9, s17
; GFX8-NEXT:    s_add_i32 s8, s8, s16
; GFX8-NEXT:    v_mov_b32_e32 v3, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: s_add_v8i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx16 s[4:19], s[0:1], 0x44
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_add_i32 s2, s7, s15
; GFX9-NEXT:    s_add_i32 s3, s6, s14
; GFX9-NEXT:    s_add_i32 s6, s11, s19
; GFX9-NEXT:    s_add_i32 s7, s10, s18
; GFX9-NEXT:    s_add_i32 s9, s9, s17
; GFX9-NEXT:    s_add_i32 s8, s8, s16
; GFX9-NEXT:    s_add_i32 s5, s5, s13
; GFX9-NEXT:    s_add_i32 s4, s4, s12
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-NEXT:    v_mov_b32_e32 v3, s6
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-NEXT:    v_mov_b32_e32 v3, s2
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: s_add_v8i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx16 s[4:19], s[0:1], 0x44
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_i32 s2, s7, s15
; GFX10-NEXT:    s_add_i32 s3, s6, s14
; GFX10-NEXT:    s_add_i32 s6, s11, s19
; GFX10-NEXT:    s_add_i32 s7, s10, s18
; GFX10-NEXT:    s_add_i32 s8, s8, s16
; GFX10-NEXT:    s_add_i32 s9, s9, s17
; GFX10-NEXT:    s_add_i32 s5, s5, s13
; GFX10-NEXT:    s_add_i32 s4, s4, s12
; GFX10-NEXT:    v_mov_b32_e32 v0, s8
; GFX10-NEXT:    v_mov_b32_e32 v1, s9
; GFX10-NEXT:    v_mov_b32_e32 v2, s7
; GFX10-NEXT:    v_mov_b32_e32 v3, s6
; GFX10-NEXT:    v_mov_b32_e32 v4, s4
; GFX10-NEXT:    v_mov_b32_e32 v5, s5
; GFX10-NEXT:    v_mov_b32_e32 v6, s3
; GFX10-NEXT:    v_mov_b32_e32 v7, s2
; GFX10-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] offset:16
; GFX10-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_add_v8i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b512 s[4:19], s[0:1], 0x44
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_i32 s2, s7, s15
; GFX11-NEXT:    s_add_i32 s3, s6, s14
; GFX11-NEXT:    s_add_i32 s6, s11, s19
; GFX11-NEXT:    s_add_i32 s7, s10, s18
; GFX11-NEXT:    s_add_i32 s8, s8, s16
; GFX11-NEXT:    s_add_i32 s9, s9, s17
; GFX11-NEXT:    s_add_i32 s5, s5, s13
; GFX11-NEXT:    s_add_i32 s4, s4, s12
; GFX11-NEXT:    v_dual_mov_b32 v8, 0 :: v_dual_mov_b32 v1, s9
; GFX11-NEXT:    v_dual_mov_b32 v0, s8 :: v_dual_mov_b32 v3, s6
; GFX11-NEXT:    v_dual_mov_b32 v2, s7 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v7, s2
; GFX11-NEXT:    v_mov_b32_e32 v6, s3
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b128 v8, v[0:3], s[0:1] offset:16
; GFX11-NEXT:    global_store_b128 v8, v[4:7], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: s_add_v8i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b512 s[4:19], s[0:1], 0x44
; GFX12-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_add_co_i32 s2, s7, s15
; GFX12-NEXT:    s_add_co_i32 s3, s6, s14
; GFX12-NEXT:    s_add_co_i32 s6, s11, s19
; GFX12-NEXT:    s_add_co_i32 s7, s10, s18
; GFX12-NEXT:    s_add_co_i32 s8, s8, s16
; GFX12-NEXT:    s_add_co_i32 s9, s9, s17
; GFX12-NEXT:    s_add_co_i32 s5, s5, s13
; GFX12-NEXT:    s_add_co_i32 s4, s4, s12
; GFX12-NEXT:    v_dual_mov_b32 v8, 0 :: v_dual_mov_b32 v1, s9
; GFX12-NEXT:    v_dual_mov_b32 v0, s8 :: v_dual_mov_b32 v3, s6
; GFX12-NEXT:    v_dual_mov_b32 v2, s7 :: v_dual_mov_b32 v5, s5
; GFX12-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v7, s2
; GFX12-NEXT:    v_mov_b32_e32 v6, s3
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v8, v[0:3], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v8, v[4:7], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %0 = add <8 x i32> %a, %b
  store <8 x i32> %0, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_add_v16i32(ptr addrspace(1) %out, <16 x i32> %a, <16 x i32> %b) {
; GFX6-LABEL: s_add_v16i32:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dwordx16 s[4:19], s[0:1], 0x19
; GFX6-NEXT:    s_load_dwordx16 s[36:51], s[0:1], 0x29
; GFX6-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_add_i32 s19, s19, s51
; GFX6-NEXT:    s_add_i32 s18, s18, s50
; GFX6-NEXT:    s_add_i32 s17, s17, s49
; GFX6-NEXT:    s_add_i32 s16, s16, s48
; GFX6-NEXT:    s_add_i32 s15, s15, s47
; GFX6-NEXT:    s_add_i32 s14, s14, s46
; GFX6-NEXT:    s_add_i32 s13, s13, s45
; GFX6-NEXT:    s_add_i32 s12, s12, s44
; GFX6-NEXT:    v_mov_b32_e32 v0, s16
; GFX6-NEXT:    v_mov_b32_e32 v1, s17
; GFX6-NEXT:    v_mov_b32_e32 v2, s18
; GFX6-NEXT:    v_mov_b32_e32 v3, s19
; GFX6-NEXT:    s_add_i32 s11, s11, s43
; GFX6-NEXT:    s_add_i32 s10, s10, s42
; GFX6-NEXT:    s_add_i32 s9, s9, s41
; GFX6-NEXT:    s_add_i32 s8, s8, s40
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:48
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s12
; GFX6-NEXT:    v_mov_b32_e32 v1, s13
; GFX6-NEXT:    v_mov_b32_e32 v2, s14
; GFX6-NEXT:    v_mov_b32_e32 v3, s15
; GFX6-NEXT:    s_add_i32 s7, s7, s39
; GFX6-NEXT:    s_add_i32 s6, s6, s38
; GFX6-NEXT:    s_add_i32 s5, s5, s37
; GFX6-NEXT:    s_add_i32 s4, s4, s36
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:32
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s8
; GFX6-NEXT:    v_mov_b32_e32 v1, s9
; GFX6-NEXT:    v_mov_b32_e32 v2, s10
; GFX6-NEXT:    v_mov_b32_e32 v3, s11
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NEXT:    v_mov_b32_e32 v3, s7
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: s_add_v16i32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx16 s[4:19], s[0:1], 0x64
; GFX8-NEXT:    s_load_dwordx16 s[36:51], s[0:1], 0xa4
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_i32 s7, s7, s39
; GFX8-NEXT:    s_add_i32 s6, s6, s38
; GFX8-NEXT:    s_add_i32 s5, s5, s37
; GFX8-NEXT:    s_add_i32 s4, s4, s36
; GFX8-NEXT:    s_add_i32 s11, s11, s43
; GFX8-NEXT:    s_add_i32 s10, s10, s42
; GFX8-NEXT:    s_add_i32 s9, s9, s41
; GFX8-NEXT:    s_add_i32 s8, s8, s40
; GFX8-NEXT:    s_add_i32 s15, s15, s47
; GFX8-NEXT:    s_add_i32 s14, s14, s46
; GFX8-NEXT:    s_add_i32 s13, s13, s45
; GFX8-NEXT:    s_add_i32 s12, s12, s44
; GFX8-NEXT:    s_add_i32 s2, s19, s51
; GFX8-NEXT:    s_add_i32 s3, s18, s50
; GFX8-NEXT:    s_add_i32 s17, s17, s49
; GFX8-NEXT:    s_add_i32 s16, s16, s48
; GFX8-NEXT:    v_mov_b32_e32 v3, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 48
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 32
; GFX8-NEXT:    v_mov_b32_e32 v0, s16
; GFX8-NEXT:    v_mov_b32_e32 v1, s17
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NEXT:    v_mov_b32_e32 v0, s12
; GFX8-NEXT:    v_mov_b32_e32 v1, s13
; GFX8-NEXT:    v_mov_b32_e32 v2, s14
; GFX8-NEXT:    v_mov_b32_e32 v3, s15
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NEXT:    v_mov_b32_e32 v2, s10
; GFX8-NEXT:    v_mov_b32_e32 v3, s11
; GFX8-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: s_add_v16i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx16 s[4:19], s[0:1], 0x64
; GFX9-NEXT:    s_load_dwordx16 s[36:51], s[0:1], 0xa4
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_add_i32 s2, s7, s39
; GFX9-NEXT:    s_add_i32 s3, s6, s38
; GFX9-NEXT:    s_add_i32 s6, s11, s43
; GFX9-NEXT:    s_add_i32 s7, s10, s42
; GFX9-NEXT:    s_add_i32 s10, s15, s47
; GFX9-NEXT:    s_add_i32 s11, s14, s46
; GFX9-NEXT:    s_add_i32 s14, s19, s51
; GFX9-NEXT:    s_add_i32 s15, s18, s50
; GFX9-NEXT:    s_add_i32 s17, s17, s49
; GFX9-NEXT:    s_add_i32 s16, s16, s48
; GFX9-NEXT:    s_add_i32 s13, s13, s45
; GFX9-NEXT:    s_add_i32 s12, s12, s44
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s15
; GFX9-NEXT:    v_mov_b32_e32 v3, s14
; GFX9-NEXT:    s_add_i32 s9, s9, s41
; GFX9-NEXT:    s_add_i32 s8, s8, s40
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:48
; GFX9-NEXT:    s_add_i32 s5, s5, s37
; GFX9-NEXT:    v_mov_b32_e32 v0, s12
; GFX9-NEXT:    v_mov_b32_e32 v1, s13
; GFX9-NEXT:    v_mov_b32_e32 v2, s11
; GFX9-NEXT:    v_mov_b32_e32 v3, s10
; GFX9-NEXT:    s_add_i32 s4, s4, s36
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:32
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-NEXT:    v_mov_b32_e32 v3, s6
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-NEXT:    v_mov_b32_e32 v3, s2
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: s_add_v16i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx16 s[4:19], s[0:1], 0x64
; GFX10-NEXT:    s_load_dwordx16 s[36:51], s[0:1], 0xa4
; GFX10-NEXT:    v_mov_b32_e32 v16, 0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_i32 s2, s7, s39
; GFX10-NEXT:    s_add_i32 s3, s6, s38
; GFX10-NEXT:    s_add_i32 s6, s11, s43
; GFX10-NEXT:    s_add_i32 s7, s10, s42
; GFX10-NEXT:    s_add_i32 s10, s15, s47
; GFX10-NEXT:    s_add_i32 s11, s14, s46
; GFX10-NEXT:    s_add_i32 s14, s19, s51
; GFX10-NEXT:    s_add_i32 s15, s18, s50
; GFX10-NEXT:    s_add_i32 s16, s16, s48
; GFX10-NEXT:    s_add_i32 s17, s17, s49
; GFX10-NEXT:    s_add_i32 s13, s13, s45
; GFX10-NEXT:    s_add_i32 s12, s12, s44
; GFX10-NEXT:    s_add_i32 s9, s9, s41
; GFX10-NEXT:    s_add_i32 s8, s8, s40
; GFX10-NEXT:    v_mov_b32_e32 v0, s16
; GFX10-NEXT:    v_mov_b32_e32 v1, s17
; GFX10-NEXT:    v_mov_b32_e32 v2, s15
; GFX10-NEXT:    v_mov_b32_e32 v3, s14
; GFX10-NEXT:    s_add_i32 s5, s5, s37
; GFX10-NEXT:    s_add_i32 s4, s4, s36
; GFX10-NEXT:    v_mov_b32_e32 v4, s12
; GFX10-NEXT:    v_mov_b32_e32 v5, s13
; GFX10-NEXT:    v_mov_b32_e32 v6, s11
; GFX10-NEXT:    v_mov_b32_e32 v7, s10
; GFX10-NEXT:    v_mov_b32_e32 v8, s8
; GFX10-NEXT:    v_mov_b32_e32 v9, s9
; GFX10-NEXT:    v_mov_b32_e32 v10, s7
; GFX10-NEXT:    v_mov_b32_e32 v11, s6
; GFX10-NEXT:    v_mov_b32_e32 v12, s4
; GFX10-NEXT:    v_mov_b32_e32 v13, s5
; GFX10-NEXT:    v_mov_b32_e32 v14, s3
; GFX10-NEXT:    v_mov_b32_e32 v15, s2
; GFX10-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1] offset:48
; GFX10-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1] offset:32
; GFX10-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1] offset:16
; GFX10-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_add_v16i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    s_load_b512 s[4:19], s[0:1], 0x64
; GFX11-NEXT:    s_load_b512 s[36:51], s[0:1], 0xa4
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_i32 s2, s7, s39
; GFX11-NEXT:    s_add_i32 s3, s6, s38
; GFX11-NEXT:    s_add_i32 s6, s11, s43
; GFX11-NEXT:    s_add_i32 s7, s10, s42
; GFX11-NEXT:    s_add_i32 s10, s15, s47
; GFX11-NEXT:    s_add_i32 s11, s14, s46
; GFX11-NEXT:    s_add_i32 s14, s19, s51
; GFX11-NEXT:    s_add_i32 s15, s18, s50
; GFX11-NEXT:    s_add_i32 s16, s16, s48
; GFX11-NEXT:    s_add_i32 s17, s17, s49
; GFX11-NEXT:    s_add_i32 s13, s13, s45
; GFX11-NEXT:    s_add_i32 s12, s12, s44
; GFX11-NEXT:    v_dual_mov_b32 v16, 0 :: v_dual_mov_b32 v1, s17
; GFX11-NEXT:    s_add_i32 s9, s9, s41
; GFX11-NEXT:    s_add_i32 s8, s8, s40
; GFX11-NEXT:    v_dual_mov_b32 v0, s16 :: v_dual_mov_b32 v3, s14
; GFX11-NEXT:    v_dual_mov_b32 v2, s15 :: v_dual_mov_b32 v5, s13
; GFX11-NEXT:    s_add_i32 s5, s5, s37
; GFX11-NEXT:    s_add_i32 s4, s4, s36
; GFX11-NEXT:    v_dual_mov_b32 v4, s12 :: v_dual_mov_b32 v7, s10
; GFX11-NEXT:    v_dual_mov_b32 v6, s11 :: v_dual_mov_b32 v9, s9
; GFX11-NEXT:    v_dual_mov_b32 v8, s8 :: v_dual_mov_b32 v11, s6
; GFX11-NEXT:    v_dual_mov_b32 v10, s7 :: v_dual_mov_b32 v13, s5
; GFX11-NEXT:    v_dual_mov_b32 v12, s4 :: v_dual_mov_b32 v15, s2
; GFX11-NEXT:    v_mov_b32_e32 v14, s3
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    global_store_b128 v16, v[0:3], s[0:1] offset:48
; GFX11-NEXT:    global_store_b128 v16, v[4:7], s[0:1] offset:32
; GFX11-NEXT:    global_store_b128 v16, v[8:11], s[0:1] offset:16
; GFX11-NEXT:    global_store_b128 v16, v[12:15], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: s_add_v16i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x2
; GFX12-NEXT:    s_load_b512 s[4:19], s[0:1], 0x64
; GFX12-NEXT:    s_load_b512 s[36:51], s[0:1], 0xa4
; GFX12-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_add_co_i32 s2, s7, s39
; GFX12-NEXT:    s_add_co_i32 s3, s6, s38
; GFX12-NEXT:    s_add_co_i32 s6, s11, s43
; GFX12-NEXT:    s_add_co_i32 s7, s10, s42
; GFX12-NEXT:    s_add_co_i32 s10, s15, s47
; GFX12-NEXT:    s_add_co_i32 s11, s14, s46
; GFX12-NEXT:    s_add_co_i32 s14, s19, s51
; GFX12-NEXT:    s_add_co_i32 s15, s18, s50
; GFX12-NEXT:    s_add_co_i32 s16, s16, s48
; GFX12-NEXT:    s_add_co_i32 s17, s17, s49
; GFX12-NEXT:    s_add_co_i32 s13, s13, s45
; GFX12-NEXT:    s_add_co_i32 s12, s12, s44
; GFX12-NEXT:    v_dual_mov_b32 v16, 0 :: v_dual_mov_b32 v1, s17
; GFX12-NEXT:    s_add_co_i32 s9, s9, s41
; GFX12-NEXT:    s_add_co_i32 s8, s8, s40
; GFX12-NEXT:    v_dual_mov_b32 v0, s16 :: v_dual_mov_b32 v3, s14
; GFX12-NEXT:    v_dual_mov_b32 v2, s15 :: v_dual_mov_b32 v5, s13
; GFX12-NEXT:    s_add_co_i32 s5, s5, s37
; GFX12-NEXT:    s_add_co_i32 s4, s4, s36
; GFX12-NEXT:    v_dual_mov_b32 v4, s12 :: v_dual_mov_b32 v7, s10
; GFX12-NEXT:    v_dual_mov_b32 v6, s11 :: v_dual_mov_b32 v9, s9
; GFX12-NEXT:    v_dual_mov_b32 v8, s8 :: v_dual_mov_b32 v11, s6
; GFX12-NEXT:    v_dual_mov_b32 v10, s7 :: v_dual_mov_b32 v13, s5
; GFX12-NEXT:    v_dual_mov_b32 v12, s4 :: v_dual_mov_b32 v15, s2
; GFX12-NEXT:    v_mov_b32_e32 v14, s3
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    global_store_b128 v16, v[0:3], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v16, v[4:7], s[0:1] offset:32
; GFX12-NEXT:    global_store_b128 v16, v[8:11], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v16, v[12:15], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %0 = add <16 x i32> %a, %b
  store <16 x i32> %0, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_add_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX6-LABEL: v_add_i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s10, 0
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64 offset:4 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX6-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: v_add_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, 4, v0
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_load_dword v2, v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, v4, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: v_add_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_load_dword v2, v0, s[2:3] offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_add_u32_e32 v1, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_add_i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_load_dword v2, v0, s[2:3] offset:4 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_add_i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3] glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3] offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v0, v1, v0
; GFX11-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_add_i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v1, v0, s[2:3] scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_load_b32 v0, v0, s[2:3] offset:4 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_nc_u32_e32 v0, v1, v0
; GFX12-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr inbounds i32, ptr addrspace(1) %in, i32 %tid
  %b_ptr = getelementptr i32, ptr addrspace(1) %gep, i32 1
  %a = load volatile i32, ptr addrspace(1) %gep
  %b = load volatile i32, ptr addrspace(1) %b_ptr
  %result = add i32 %a, %b
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_add_imm_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX6-LABEL: v_add_imm_i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s10, 0
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0x7b, v0
; GFX6-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: v_add_imm_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, 0x7b, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: v_add_imm_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[2:3] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, 0x7b, v0
; GFX9-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_add_imm_i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 0x7b, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_add_imm_i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3] glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 0x7b, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_add_imm_i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v0, v0, s[2:3] scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_nc_u32_e32 v0, 0x7b, v0
; GFX12-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr inbounds i32, ptr addrspace(1) %in, i32 %tid
  %b_ptr = getelementptr i32, ptr addrspace(1) %gep, i32 1
  %a = load volatile i32, ptr addrspace(1) %gep
  %result = add i32 %a, 123
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add64(ptr addrspace(1) %out, i64 %a, i64 %b) {
; GFX6-LABEL: add64:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX6-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s0, s4
; GFX6-NEXT:    s_add_u32 s4, s6, s8
; GFX6-NEXT:    s_mov_b32 s1, s5
; GFX6-NEXT:    s_addc_u32 s5, s7, s9
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: add64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    s_add_u32 s0, s6, s0
; GFX8-NEXT:    s_addc_u32 s1, s7, s1
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_add_u32 s0, s6, s2
; GFX9-NEXT:    s_addc_u32 s1, s7, s3
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: add64:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s6, s2
; GFX10-NEXT:    s_addc_u32 s1, s7, s3
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: add64:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_u32 s0, s6, s0
; GFX11-NEXT:    s_addc_u32 s1, s7, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: add64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[6:7], s[0:1]
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[4:5]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %add = add i64 %a, %b
  store i64 %add, ptr addrspace(1) %out
  ret void
}

; The v_addc_u32 and v_add_i32 instruction can't read SGPRs, because they
; use VCC.  The test is designed so that %a will be stored in an SGPR and
; %0 will be stored in a VGPR, so the comiler will be forced to copy %a
; to a VGPR before doing the add.
define amdgpu_kernel void @add64_sgpr_vgpr(ptr addrspace(1) %out, i64 %a, ptr addrspace(1) %in) {
; GFX6-LABEL: add64_sgpr_vgpr:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xd
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_add_u32 s0, s2, s8
; GFX6-NEXT:    s_addc_u32 s1, s3, s9
; GFX6-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: add64_sgpr_vgpr:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s2, s4
; GFX8-NEXT:    s_addc_u32 s1, s3, s5
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add64_sgpr_vgpr:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_add_u32 s0, s6, s0
; GFX9-NEXT:    s_addc_u32 s1, s7, s1
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: add64_sgpr_vgpr:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s6, s0
; GFX10-NEXT:    s_addc_u32 s1, s7, s1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: add64_sgpr_vgpr:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[4:5], s[0:1], 0x34
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b64 s[4:5], s[4:5], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_u32 s2, s2, s4
; GFX11-NEXT:    s_addc_u32 s3, s3, s5
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: add64_sgpr_vgpr:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[0:1], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_add_nc_u64 s[2:3], s[2:3], s[4:5]
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %0 = load i64, ptr addrspace(1) %in
  %1 = add i64 %a, %0
  store i64 %1, ptr addrspace(1) %out
  ret void
}

; Test i64 add inside a branch.
define amdgpu_kernel void @add64_in_branch(ptr addrspace(1) %out, ptr addrspace(1) %in, i64 %a, i64 %b, i64 %c) {
; GFX6-LABEL: add64_in_branch:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_ne_u64_e64 s[10:11], s[4:5], 0
; GFX6-NEXT:    s_and_b64 vcc, exec, s[10:11]
; GFX6-NEXT:    s_cbranch_vccz .LBB9_4
; GFX6-NEXT:  ; %bb.1: ; %else
; GFX6-NEXT:    s_add_u32 s4, s4, s6
; GFX6-NEXT:    s_addc_u32 s5, s5, s7
; GFX6-NEXT:    s_andn2_b64 vcc, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_vccnz .LBB9_3
; GFX6-NEXT:  .LBB9_2: ; %if
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x0
; GFX6-NEXT:  .LBB9_3: ; %endif
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
; GFX6-NEXT:  .LBB9_4:
; GFX6-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX6-NEXT:    s_branch .LBB9_2
;
; GFX8-LABEL: add64_in_branch:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b64 s[8:9], 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX8-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX8-NEXT:  ; %bb.1: ; %else
; GFX8-NEXT:    s_add_u32 s4, s4, s6
; GFX8-NEXT:    s_addc_u32 s5, s5, s7
; GFX8-NEXT:    s_andn2_b64 vcc, exec, s[8:9]
; GFX8-NEXT:    s_cbranch_vccnz .LBB9_3
; GFX8-NEXT:  .LBB9_2: ; %if
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x0
; GFX8-NEXT:  .LBB9_3: ; %endif
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NEXT:    s_endpgm
; GFX8-NEXT:  .LBB9_4:
; GFX8-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX8-NEXT:    s_branch .LBB9_2
;
; GFX9-LABEL: add64_in_branch:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[8:9], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX9-NEXT:  ; %bb.1: ; %else
; GFX9-NEXT:    s_add_u32 s4, s4, s6
; GFX9-NEXT:    s_addc_u32 s5, s5, s7
; GFX9-NEXT:    s_andn2_b64 vcc, exec, s[8:9]
; GFX9-NEXT:    s_cbranch_vccnz .LBB9_3
; GFX9-NEXT:  .LBB9_2: ; %if
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x0
; GFX9-NEXT:  .LBB9_3: ; %endif
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
; GFX9-NEXT:  .LBB9_4:
; GFX9-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-NEXT:    s_branch .LBB9_2
;
; GFX10-LABEL: add64_in_branch:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX10-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX10-NEXT:  ; %bb.1: ; %else
; GFX10-NEXT:    s_add_u32 s4, s4, s6
; GFX10-NEXT:    s_addc_u32 s5, s5, s7
; GFX10-NEXT:    s_mov_b32 s6, 0
; GFX10-NEXT:    s_cbranch_execnz .LBB9_3
; GFX10-NEXT:  .LBB9_2: ; %if
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x0
; GFX10-NEXT:  .LBB9_3: ; %endif
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
; GFX10-NEXT:  .LBB9_4:
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX10-NEXT:    s_branch .LBB9_2
;
; GFX11-LABEL: add64_in_branch:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX11-NEXT:  ; %bb.1: ; %else
; GFX11-NEXT:    s_add_u32 s4, s4, s6
; GFX11-NEXT:    s_addc_u32 s5, s5, s7
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_execnz .LBB9_3
; GFX11-NEXT:  .LBB9_2: ; %if
; GFX11-NEXT:    s_load_b64 s[4:5], s[2:3], 0x0
; GFX11-NEXT:  .LBB9_3: ; %endif
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, s4
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
; GFX11-NEXT:  .LBB9_4:
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX11-NEXT:    s_branch .LBB9_2
;
; GFX12-LABEL: add64_in_branch:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX12-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX12-NEXT:  ; %bb.1: ; %else
; GFX12-NEXT:    s_add_nc_u64 s[4:5], s[4:5], s[6:7]
; GFX12-NEXT:    s_mov_b32 s6, 0
; GFX12-NEXT:    s_cbranch_execnz .LBB9_3
; GFX12-NEXT:  .LBB9_2: ; %if
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x0
; GFX12-NEXT:  .LBB9_3: ; %endif
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
; GFX12-NEXT:  .LBB9_4:
; GFX12-NEXT:    s_mov_b32 s6, -1
; GFX12-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX12-NEXT:    s_branch .LBB9_2
entry:
  %0 = icmp eq i64 %a, 0
  br i1 %0, label %if, label %else

if:
  %1 = load i64, ptr addrspace(1) %in
  br label %endif

else:
  %2 = add i64 %a, %b
  br label %endif

endif:
  %3 = phi i64 [%1, %if], [%2, %else]
  store i64 %3, ptr addrspace(1) %out
  ret void
}

; Make sure the VOP3 form of add is initially selected. Otherwise pair
; of opies from/to VCC would be necessary
define amdgpu_ps void @add_select_vop3(i32 inreg %s, i32 %v) {
; GFX6-LABEL: add_select_vop3:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_add_i32_e64 v0, s[0:1], s0, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ;;#ASMSTART
; GFX6-NEXT:    ; def vcc
; GFX6-NEXT:    ;;#ASMEND
; GFX6-NEXT:    ds_write_b32 v0, v0
; GFX6-NEXT:    ;;#ASMSTART
; GFX6-NEXT:    ; use vcc
; GFX6-NEXT:    ;;#ASMEND
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: add_select_vop3:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_add_u32_e64 v0, s[0:1], s0, v0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; def vcc
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    ds_write_b32 v0, v0
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use vcc
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_select_vop3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def vcc
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    ds_write_b32 v0, v0
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use vcc
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: add_select_vop3:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX10-NEXT:    ;;#ASMSTART
; GFX10-NEXT:    ; def vcc
; GFX10-NEXT:    ;;#ASMEND
; GFX10-NEXT:    ds_write_b32 v0, v0
; GFX10-NEXT:    ;;#ASMSTART
; GFX10-NEXT:    ; use vcc
; GFX10-NEXT:    ;;#ASMEND
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: add_select_vop3:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; def vcc
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    ds_store_b32 v0, v0
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; use vcc
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: add_select_vop3:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-NEXT:    ;;#ASMSTART
; GFX12-NEXT:    ; def vcc
; GFX12-NEXT:    ;;#ASMEND
; GFX12-NEXT:    ds_store_b32 v0, v0
; GFX12-NEXT:    ;;#ASMSTART
; GFX12-NEXT:    ; use vcc
; GFX12-NEXT:    ;;#ASMEND
; GFX12-NEXT:    s_endpgm
  %vcc = call i64 asm sideeffect "; def vcc", "={vcc}"()
  %sub = add i32 %v, %s
  store i32 %sub, ptr addrspace(3) undef
  call void asm sideeffect "; use vcc", "{vcc}"(i64 %vcc)
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone speculatable }
