; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=powerpc64le-linux-gnu -mcpu=pwr8 -verify-machineinstrs \
; RUN:   < %s | FileCheck %s
; RUN: llc -mtriple=powerpc-aix- -mcpu=pwr7 -verify-machineinstrs \
; RUN:   < %s | FileCheck %s --check-prefix=AIX32
; ModuleID = '../clang/test/CodeGen/Atomics.c'

@sc = dso_local global i8 0, align 1
@uc = dso_local global i8 0, align 1
@ss = dso_local global i16 0, align 2
@us = dso_local global i16 0, align 2
@si = dso_local global i32 0, align 4
@ui = dso_local global i32 0, align 4
@sll = dso_local global i64 0, align 8
@ull = dso_local global i64 0, align 8
@u128 = dso_local global i128 0, align 16
@s128 = dso_local global i128 0, align 16

define dso_local void @test_op_ignore() local_unnamed_addr #0 {
; CHECK-LABEL: test_op_ignore:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, sc@toc@ha
; CHECK-NEXT:    std 26, -48(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 27, -40(1) # 8-byte Folded Spill
; CHECK-NEXT:    addi 4, 3, sc@toc@l
; CHECK-NEXT:    std 28, -32(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 29, -24(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 30, -16(1) # 8-byte Folded Spill
; CHECK-NEXT:    sync
; CHECK-NEXT:    li 3, 1
; CHECK-NEXT:  .LBB0_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 5, 0, 4
; CHECK-NEXT:    addi 5, 5, 1
; CHECK-NEXT:    stbcx. 5, 0, 4
; CHECK-NEXT:    bne 0, .LBB0_1
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    addis 5, 2, uc@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 5, 5, uc@toc@l
; CHECK-NEXT:  .LBB0_3: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 6, 0, 5
; CHECK-NEXT:    addi 6, 6, 1
; CHECK-NEXT:    stbcx. 6, 0, 5
; CHECK-NEXT:    bne 0, .LBB0_3
; CHECK-NEXT:  # %bb.4: # %entry
; CHECK-NEXT:    addis 6, 2, ss@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 6, 6, ss@toc@l
; CHECK-NEXT:  .LBB0_5: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 7, 0, 6
; CHECK-NEXT:    addi 7, 7, 1
; CHECK-NEXT:    sthcx. 7, 0, 6
; CHECK-NEXT:    bne 0, .LBB0_5
; CHECK-NEXT:  # %bb.6: # %entry
; CHECK-NEXT:    addis 7, 2, us@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 8, 7, us@toc@l
; CHECK-NEXT:  .LBB0_7: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 7, 0, 8
; CHECK-NEXT:    addi 7, 7, 1
; CHECK-NEXT:    sthcx. 7, 0, 8
; CHECK-NEXT:    bne 0, .LBB0_7
; CHECK-NEXT:  # %bb.8: # %entry
; CHECK-NEXT:    addis 7, 2, si@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 9, 7, si@toc@l
; CHECK-NEXT:  .LBB0_9: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 7, 0, 9
; CHECK-NEXT:    addi 7, 7, 1
; CHECK-NEXT:    stwcx. 7, 0, 9
; CHECK-NEXT:    bne 0, .LBB0_9
; CHECK-NEXT:  # %bb.10: # %entry
; CHECK-NEXT:    addis 7, 2, ui@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 10, 7, ui@toc@l
; CHECK-NEXT:  .LBB0_11: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 7, 0, 10
; CHECK-NEXT:    addi 7, 7, 1
; CHECK-NEXT:    stwcx. 7, 0, 10
; CHECK-NEXT:    bne 0, .LBB0_11
; CHECK-NEXT:  # %bb.12: # %entry
; CHECK-NEXT:    addis 7, 2, sll@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 11, 7, sll@toc@l
; CHECK-NEXT:    li 7, 1
; CHECK-NEXT:  .LBB0_13: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 12, 0, 11
; CHECK-NEXT:    addi 12, 12, 1
; CHECK-NEXT:    stdcx. 12, 0, 11
; CHECK-NEXT:    bne 0, .LBB0_13
; CHECK-NEXT:  # %bb.14: # %entry
; CHECK-NEXT:    addis 12, 2, ull@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 12, 12, ull@toc@l
; CHECK-NEXT:  .LBB0_15: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 30, 0, 12
; CHECK-NEXT:    addi 0, 30, 1
; CHECK-NEXT:    stdcx. 0, 0, 12
; CHECK-NEXT:    bne 0, .LBB0_15
; CHECK-NEXT:  # %bb.16: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_17: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 0, 0, 4
; CHECK-NEXT:    sub 0, 0, 3
; CHECK-NEXT:    stbcx. 0, 0, 4
; CHECK-NEXT:    bne 0, .LBB0_17
; CHECK-NEXT:  # %bb.18: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_19: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 0, 0, 5
; CHECK-NEXT:    sub 0, 0, 3
; CHECK-NEXT:    stbcx. 0, 0, 5
; CHECK-NEXT:    bne 0, .LBB0_19
; CHECK-NEXT:  # %bb.20: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_21: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 0, 0, 6
; CHECK-NEXT:    sub 0, 0, 3
; CHECK-NEXT:    sthcx. 0, 0, 6
; CHECK-NEXT:    bne 0, .LBB0_21
; CHECK-NEXT:  # %bb.22: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_23: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 0, 0, 8
; CHECK-NEXT:    sub 0, 0, 3
; CHECK-NEXT:    sthcx. 0, 0, 8
; CHECK-NEXT:    bne 0, .LBB0_23
; CHECK-NEXT:  # %bb.24: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_25: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 0, 0, 9
; CHECK-NEXT:    sub 0, 0, 3
; CHECK-NEXT:    stwcx. 0, 0, 9
; CHECK-NEXT:    bne 0, .LBB0_25
; CHECK-NEXT:  # %bb.26: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_27: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 0, 0, 10
; CHECK-NEXT:    sub 0, 0, 3
; CHECK-NEXT:    stwcx. 0, 0, 10
; CHECK-NEXT:    bne 0, .LBB0_27
; CHECK-NEXT:  # %bb.28: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_29: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 0, 0, 11
; CHECK-NEXT:    sub 0, 0, 7
; CHECK-NEXT:    stdcx. 0, 0, 11
; CHECK-NEXT:    bne 0, .LBB0_29
; CHECK-NEXT:  # %bb.30: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_31: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 0, 0, 12
; CHECK-NEXT:    sub 0, 0, 7
; CHECK-NEXT:    stdcx. 0, 0, 12
; CHECK-NEXT:    bne 0, .LBB0_31
; CHECK-NEXT:  # %bb.32: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_33: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 0, 0, 4
; CHECK-NEXT:    ori 0, 0, 1
; CHECK-NEXT:    stbcx. 0, 0, 4
; CHECK-NEXT:    bne 0, .LBB0_33
; CHECK-NEXT:  # %bb.34: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_35: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 0, 0, 5
; CHECK-NEXT:    ori 0, 0, 1
; CHECK-NEXT:    stbcx. 0, 0, 5
; CHECK-NEXT:    bne 0, .LBB0_35
; CHECK-NEXT:  # %bb.36: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_37: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 0, 0, 6
; CHECK-NEXT:    ori 0, 0, 1
; CHECK-NEXT:    sthcx. 0, 0, 6
; CHECK-NEXT:    bne 0, .LBB0_37
; CHECK-NEXT:  # %bb.38: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_39: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 0, 0, 8
; CHECK-NEXT:    ori 0, 0, 1
; CHECK-NEXT:    sthcx. 0, 0, 8
; CHECK-NEXT:    bne 0, .LBB0_39
; CHECK-NEXT:  # %bb.40: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_41: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 0, 0, 9
; CHECK-NEXT:    ori 0, 0, 1
; CHECK-NEXT:    stwcx. 0, 0, 9
; CHECK-NEXT:    bne 0, .LBB0_41
; CHECK-NEXT:  # %bb.42: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_43: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 0, 0, 10
; CHECK-NEXT:    ori 0, 0, 1
; CHECK-NEXT:    stwcx. 0, 0, 10
; CHECK-NEXT:    bne 0, .LBB0_43
; CHECK-NEXT:  # %bb.44: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_45: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 0, 0, 11
; CHECK-NEXT:    ori 0, 0, 1
; CHECK-NEXT:    stdcx. 0, 0, 11
; CHECK-NEXT:    bne 0, .LBB0_45
; CHECK-NEXT:  # %bb.46: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_47: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 0, 0, 12
; CHECK-NEXT:    ori 0, 0, 1
; CHECK-NEXT:    stdcx. 0, 0, 12
; CHECK-NEXT:    bne 0, .LBB0_47
; CHECK-NEXT:  # %bb.48: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_49: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 0, 0, 4
; CHECK-NEXT:    xori 0, 0, 1
; CHECK-NEXT:    stbcx. 0, 0, 4
; CHECK-NEXT:    bne 0, .LBB0_49
; CHECK-NEXT:  # %bb.50: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_51: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 0, 0, 5
; CHECK-NEXT:    xori 0, 0, 1
; CHECK-NEXT:    stbcx. 0, 0, 5
; CHECK-NEXT:    bne 0, .LBB0_51
; CHECK-NEXT:  # %bb.52: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_53: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 0, 0, 6
; CHECK-NEXT:    xori 0, 0, 1
; CHECK-NEXT:    sthcx. 0, 0, 6
; CHECK-NEXT:    bne 0, .LBB0_53
; CHECK-NEXT:  # %bb.54: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_55: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 0, 0, 8
; CHECK-NEXT:    xori 0, 0, 1
; CHECK-NEXT:    sthcx. 0, 0, 8
; CHECK-NEXT:    bne 0, .LBB0_55
; CHECK-NEXT:  # %bb.56: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_57: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 0, 0, 9
; CHECK-NEXT:    xori 0, 0, 1
; CHECK-NEXT:    stwcx. 0, 0, 9
; CHECK-NEXT:    bne 0, .LBB0_57
; CHECK-NEXT:  # %bb.58: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_59: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 0, 0, 10
; CHECK-NEXT:    xori 0, 0, 1
; CHECK-NEXT:    stwcx. 0, 0, 10
; CHECK-NEXT:    bne 0, .LBB0_59
; CHECK-NEXT:  # %bb.60: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_61: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 0, 0, 11
; CHECK-NEXT:    xori 0, 0, 1
; CHECK-NEXT:    stdcx. 0, 0, 11
; CHECK-NEXT:    bne 0, .LBB0_61
; CHECK-NEXT:  # %bb.62: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_63: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 0, 0, 12
; CHECK-NEXT:    xori 0, 0, 1
; CHECK-NEXT:    stdcx. 0, 0, 12
; CHECK-NEXT:    bne 0, .LBB0_63
; CHECK-NEXT:  # %bb.64: # %entry
; CHECK-NEXT:    addis 30, 2, u128@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 0, 30, u128@toc@l
; CHECK-NEXT:    li 30, 0
; CHECK-NEXT:  .LBB0_65: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lqarx 28, 0, 0
; CHECK-NEXT:    xor 27, 7, 29
; CHECK-NEXT:    xor 26, 30, 28
; CHECK-NEXT:    stqcx. 26, 0, 0
; CHECK-NEXT:    bne 0, .LBB0_65
; CHECK-NEXT:  # %bb.66: # %entry
; CHECK-NEXT:    addis 29, 2, s128@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    addi 0, 29, s128@toc@l
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_67: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lqarx 28, 0, 0
; CHECK-NEXT:    xor 27, 7, 29
; CHECK-NEXT:    xor 26, 30, 28
; CHECK-NEXT:    stqcx. 26, 0, 0
; CHECK-NEXT:    bne 0, .LBB0_67
; CHECK-NEXT:  # %bb.68: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_69: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 0, 0, 4
; CHECK-NEXT:    nand 0, 3, 0
; CHECK-NEXT:    stbcx. 0, 0, 4
; CHECK-NEXT:    bne 0, .LBB0_69
; CHECK-NEXT:  # %bb.70: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_71: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 0, 0, 5
; CHECK-NEXT:    nand 0, 3, 0
; CHECK-NEXT:    stbcx. 0, 0, 5
; CHECK-NEXT:    bne 0, .LBB0_71
; CHECK-NEXT:  # %bb.72: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_73: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 0, 0, 6
; CHECK-NEXT:    nand 0, 3, 0
; CHECK-NEXT:    sthcx. 0, 0, 6
; CHECK-NEXT:    bne 0, .LBB0_73
; CHECK-NEXT:  # %bb.74: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_75: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 0, 0, 8
; CHECK-NEXT:    nand 0, 3, 0
; CHECK-NEXT:    sthcx. 0, 0, 8
; CHECK-NEXT:    bne 0, .LBB0_75
; CHECK-NEXT:  # %bb.76: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_77: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 0, 0, 9
; CHECK-NEXT:    nand 0, 3, 0
; CHECK-NEXT:    stwcx. 0, 0, 9
; CHECK-NEXT:    bne 0, .LBB0_77
; CHECK-NEXT:  # %bb.78: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_79: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 0, 0, 10
; CHECK-NEXT:    nand 0, 3, 0
; CHECK-NEXT:    stwcx. 0, 0, 10
; CHECK-NEXT:    bne 0, .LBB0_79
; CHECK-NEXT:  # %bb.80: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_81: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 0, 0, 11
; CHECK-NEXT:    nand 0, 7, 0
; CHECK-NEXT:    stdcx. 0, 0, 11
; CHECK-NEXT:    bne 0, .LBB0_81
; CHECK-NEXT:  # %bb.82: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_83: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 0, 0, 12
; CHECK-NEXT:    nand 0, 7, 0
; CHECK-NEXT:    stdcx. 0, 0, 12
; CHECK-NEXT:    bne 0, .LBB0_83
; CHECK-NEXT:  # %bb.84: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_85: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 0, 0, 4
; CHECK-NEXT:    and 0, 3, 0
; CHECK-NEXT:    stbcx. 0, 0, 4
; CHECK-NEXT:    bne 0, .LBB0_85
; CHECK-NEXT:  # %bb.86: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_87: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 4, 0, 5
; CHECK-NEXT:    and 4, 3, 4
; CHECK-NEXT:    stbcx. 4, 0, 5
; CHECK-NEXT:    bne 0, .LBB0_87
; CHECK-NEXT:  # %bb.88: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_89: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 4, 0, 6
; CHECK-NEXT:    and 4, 3, 4
; CHECK-NEXT:    sthcx. 4, 0, 6
; CHECK-NEXT:    bne 0, .LBB0_89
; CHECK-NEXT:  # %bb.90: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_91: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 4, 0, 8
; CHECK-NEXT:    and 4, 3, 4
; CHECK-NEXT:    sthcx. 4, 0, 8
; CHECK-NEXT:    bne 0, .LBB0_91
; CHECK-NEXT:  # %bb.92: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_93: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 4, 0, 9
; CHECK-NEXT:    and 4, 3, 4
; CHECK-NEXT:    stwcx. 4, 0, 9
; CHECK-NEXT:    bne 0, .LBB0_93
; CHECK-NEXT:  # %bb.94: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_95: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 4, 0, 10
; CHECK-NEXT:    and 4, 3, 4
; CHECK-NEXT:    stwcx. 4, 0, 10
; CHECK-NEXT:    bne 0, .LBB0_95
; CHECK-NEXT:  # %bb.96: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_97: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 3, 0, 11
; CHECK-NEXT:    and 3, 7, 3
; CHECK-NEXT:    stdcx. 3, 0, 11
; CHECK-NEXT:    bne 0, .LBB0_97
; CHECK-NEXT:  # %bb.98: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB0_99: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 3, 0, 12
; CHECK-NEXT:    and 3, 7, 3
; CHECK-NEXT:    stdcx. 3, 0, 12
; CHECK-NEXT:    bne 0, .LBB0_99
; CHECK-NEXT:  # %bb.100: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    ld 30, -16(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 29, -24(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 28, -32(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 27, -40(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 26, -48(1) # 8-byte Folded Reload
; CHECK-NEXT:    blr
;
; AIX32-LABEL: test_op_ignore:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    mflr 0
; AIX32-NEXT:    stwu 1, -160(1)
; AIX32-NEXT:    lwz 3, L..C0(2) # @sc
; AIX32-NEXT:    stw 0, 168(1)
; AIX32-NEXT:    rlwinm 4, 3, 3, 27, 28
; AIX32-NEXT:    stw 15, 92(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 26, 136(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 28, 144(1) # 4-byte Folded Spill
; AIX32-NEXT:    li 15, 1
; AIX32-NEXT:    rlwinm 28, 3, 0, 0, 29
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    xori 26, 4, 24
; AIX32-NEXT:    stw 16, 96(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 17, 100(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 18, 104(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 19, 108(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 20, 112(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 21, 116(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 22, 120(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 23, 124(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 24, 128(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 25, 132(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 27, 140(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 29, 148(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 30, 152(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 31, 156(1) # 4-byte Folded Spill
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 29, 15, 26
; AIX32-NEXT:    slw 3, 3, 26
; AIX32-NEXT:  L..BB0_1: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 28
; AIX32-NEXT:    add 5, 29, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 28
; AIX32-NEXT:    bne 0, L..BB0_1
; AIX32-NEXT:  # %bb.2: # %entry
; AIX32-NEXT:    lwz 3, L..C1(2) # @uc
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    rlwinm 4, 3, 3, 27, 28
; AIX32-NEXT:    rlwinm 27, 3, 0, 0, 29
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    xori 24, 4, 24
; AIX32-NEXT:    slw 18, 15, 24
; AIX32-NEXT:    slw 3, 3, 24
; AIX32-NEXT:  L..BB0_3: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 27
; AIX32-NEXT:    add 5, 18, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 27
; AIX32-NEXT:    bne 0, L..BB0_3
; AIX32-NEXT:  # %bb.4: # %entry
; AIX32-NEXT:    lwz 3, L..C2(2) # @ss
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    rlwinm 4, 3, 3, 27, 27
; AIX32-NEXT:    rlwinm 25, 3, 0, 0, 29
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    xori 22, 4, 16
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 17, 15, 22
; AIX32-NEXT:    slw 3, 3, 22
; AIX32-NEXT:  L..BB0_5: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    add 5, 17, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 25
; AIX32-NEXT:    bne 0, L..BB0_5
; AIX32-NEXT:  # %bb.6: # %entry
; AIX32-NEXT:    lwz 3, L..C3(2) # @us
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    rlwinm 4, 3, 3, 27, 27
; AIX32-NEXT:    rlwinm 23, 3, 0, 0, 29
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    xori 21, 4, 16
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 16, 15, 21
; AIX32-NEXT:    slw 3, 3, 21
; AIX32-NEXT:  L..BB0_7: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 23
; AIX32-NEXT:    add 5, 16, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 23
; AIX32-NEXT:    bne 0, L..BB0_7
; AIX32-NEXT:  # %bb.8: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lwz 20, L..C4(2) # @si
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB0_9: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 20
; AIX32-NEXT:    addi 3, 3, 1
; AIX32-NEXT:    stwcx. 3, 0, 20
; AIX32-NEXT:    bne 0, L..BB0_9
; AIX32-NEXT:  # %bb.10: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lwz 19, L..C5(2) # @ui
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB0_11: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 19
; AIX32-NEXT:    addi 3, 3, 1
; AIX32-NEXT:    stwcx. 3, 0, 19
; AIX32-NEXT:    bne 0, L..BB0_11
; AIX32-NEXT:  # %bb.12: # %entry
; AIX32-NEXT:    lwz 31, L..C6(2) # @sll
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    bl .__atomic_fetch_add_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 30, L..C7(2) # @ull
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    bl .__atomic_fetch_add_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 26
; AIX32-NEXT:  L..BB0_13: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 28
; AIX32-NEXT:    sub 5, 4, 29
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 28
; AIX32-NEXT:    bne 0, L..BB0_13
; AIX32-NEXT:  # %bb.14: # %entry
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 24
; AIX32-NEXT:  L..BB0_15: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 27
; AIX32-NEXT:    sub 5, 4, 18
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 27
; AIX32-NEXT:    bne 0, L..BB0_15
; AIX32-NEXT:  # %bb.16: # %entry
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 22
; AIX32-NEXT:  L..BB0_17: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    sub 5, 4, 17
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 25
; AIX32-NEXT:    bne 0, L..BB0_17
; AIX32-NEXT:  # %bb.18: # %entry
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 21
; AIX32-NEXT:  L..BB0_19: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 23
; AIX32-NEXT:    sub 5, 4, 16
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 23
; AIX32-NEXT:    bne 0, L..BB0_19
; AIX32-NEXT:  # %bb.20: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB0_21: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 20
; AIX32-NEXT:    sub 3, 3, 15
; AIX32-NEXT:    stwcx. 3, 0, 20
; AIX32-NEXT:    bne 0, L..BB0_21
; AIX32-NEXT:  # %bb.22: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB0_23: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 19
; AIX32-NEXT:    sub 3, 3, 15
; AIX32-NEXT:    stwcx. 3, 0, 19
; AIX32-NEXT:    bne 0, L..BB0_23
; AIX32-NEXT:  # %bb.24: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    bl .__atomic_fetch_sub_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    bl .__atomic_fetch_sub_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 26
; AIX32-NEXT:  L..BB0_25: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 28
; AIX32-NEXT:    or 5, 29, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 28
; AIX32-NEXT:    bne 0, L..BB0_25
; AIX32-NEXT:  # %bb.26: # %entry
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 24
; AIX32-NEXT:  L..BB0_27: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 27
; AIX32-NEXT:    or 5, 18, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 27
; AIX32-NEXT:    bne 0, L..BB0_27
; AIX32-NEXT:  # %bb.28: # %entry
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 22
; AIX32-NEXT:  L..BB0_29: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    or 5, 17, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 25
; AIX32-NEXT:    bne 0, L..BB0_29
; AIX32-NEXT:  # %bb.30: # %entry
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 21
; AIX32-NEXT:  L..BB0_31: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 23
; AIX32-NEXT:    or 5, 16, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 23
; AIX32-NEXT:    bne 0, L..BB0_31
; AIX32-NEXT:  # %bb.32: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB0_33: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 20
; AIX32-NEXT:    ori 3, 3, 1
; AIX32-NEXT:    stwcx. 3, 0, 20
; AIX32-NEXT:    bne 0, L..BB0_33
; AIX32-NEXT:  # %bb.34: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB0_35: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 19
; AIX32-NEXT:    ori 3, 3, 1
; AIX32-NEXT:    stwcx. 3, 0, 19
; AIX32-NEXT:    bne 0, L..BB0_35
; AIX32-NEXT:  # %bb.36: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    bl .__atomic_fetch_or_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    bl .__atomic_fetch_or_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 26
; AIX32-NEXT:  L..BB0_37: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 28
; AIX32-NEXT:    xor 5, 29, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 28
; AIX32-NEXT:    bne 0, L..BB0_37
; AIX32-NEXT:  # %bb.38: # %entry
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 24
; AIX32-NEXT:  L..BB0_39: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 27
; AIX32-NEXT:    xor 5, 18, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 27
; AIX32-NEXT:    bne 0, L..BB0_39
; AIX32-NEXT:  # %bb.40: # %entry
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 22
; AIX32-NEXT:  L..BB0_41: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    xor 5, 17, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 25
; AIX32-NEXT:    bne 0, L..BB0_41
; AIX32-NEXT:  # %bb.42: # %entry
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 21
; AIX32-NEXT:  L..BB0_43: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 23
; AIX32-NEXT:    xor 5, 16, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 23
; AIX32-NEXT:    bne 0, L..BB0_43
; AIX32-NEXT:  # %bb.44: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB0_45: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 20
; AIX32-NEXT:    xori 3, 3, 1
; AIX32-NEXT:    stwcx. 3, 0, 20
; AIX32-NEXT:    bne 0, L..BB0_45
; AIX32-NEXT:  # %bb.46: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB0_47: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 19
; AIX32-NEXT:    xori 3, 3, 1
; AIX32-NEXT:    stwcx. 3, 0, 19
; AIX32-NEXT:    bne 0, L..BB0_47
; AIX32-NEXT:  # %bb.48: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    bl .__atomic_fetch_xor_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    bl .__atomic_fetch_xor_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 31, L..C8(2) # @u128
; AIX32-NEXT:    addi 30, 1, 72
; AIX32-NEXT:    addi 29, 1, 56
; AIX32-NEXT:    lwz 5, 12(31)
; AIX32-NEXT:    lwz 4, 8(31)
; AIX32-NEXT:    lwz 6, 4(31)
; AIX32-NEXT:    lwz 7, 0(31)
; AIX32-NEXT:    .align 4
; AIX32-NEXT:  L..BB0_49: # %atomicrmw.start
; AIX32-NEXT:    #
; AIX32-NEXT:    xori 3, 5, 1
; AIX32-NEXT:    stw 7, 72(1)
; AIX32-NEXT:    stw 7, 56(1)
; AIX32-NEXT:    li 7, 5
; AIX32-NEXT:    stw 3, 68(1)
; AIX32-NEXT:    li 3, 16
; AIX32-NEXT:    li 8, 5
; AIX32-NEXT:    stw 6, 76(1)
; AIX32-NEXT:    stw 4, 80(1)
; AIX32-NEXT:    stw 5, 84(1)
; AIX32-NEXT:    stw 4, 64(1)
; AIX32-NEXT:    stw 6, 60(1)
; AIX32-NEXT:    mr 4, 31
; AIX32-NEXT:    mr 5, 30
; AIX32-NEXT:    mr 6, 29
; AIX32-NEXT:    bl .__atomic_compare_exchange[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 5, 84(1)
; AIX32-NEXT:    lwz 4, 80(1)
; AIX32-NEXT:    lwz 6, 76(1)
; AIX32-NEXT:    lwz 7, 72(1)
; AIX32-NEXT:    cmplwi 3, 0
; AIX32-NEXT:    beq 0, L..BB0_49
; AIX32-NEXT:  # %bb.50: # %atomicrmw.end
; AIX32-NEXT:    lwz 31, L..C9(2) # @s128
; AIX32-NEXT:    addi 30, 1, 72
; AIX32-NEXT:    addi 29, 1, 56
; AIX32-NEXT:    lwz 5, 12(31)
; AIX32-NEXT:    lwz 4, 8(31)
; AIX32-NEXT:    lwz 6, 4(31)
; AIX32-NEXT:    lwz 7, 0(31)
; AIX32-NEXT:    .align 4
; AIX32-NEXT:  L..BB0_51: # %atomicrmw.start2
; AIX32-NEXT:    #
; AIX32-NEXT:    xori 3, 5, 1
; AIX32-NEXT:    stw 7, 72(1)
; AIX32-NEXT:    stw 7, 56(1)
; AIX32-NEXT:    li 7, 5
; AIX32-NEXT:    stw 3, 68(1)
; AIX32-NEXT:    li 3, 16
; AIX32-NEXT:    li 8, 5
; AIX32-NEXT:    stw 6, 76(1)
; AIX32-NEXT:    stw 4, 80(1)
; AIX32-NEXT:    stw 5, 84(1)
; AIX32-NEXT:    stw 4, 64(1)
; AIX32-NEXT:    stw 6, 60(1)
; AIX32-NEXT:    mr 4, 31
; AIX32-NEXT:    mr 5, 30
; AIX32-NEXT:    mr 6, 29
; AIX32-NEXT:    bl .__atomic_compare_exchange[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 5, 84(1)
; AIX32-NEXT:    lwz 4, 80(1)
; AIX32-NEXT:    lwz 6, 76(1)
; AIX32-NEXT:    lwz 7, 72(1)
; AIX32-NEXT:    cmplwi 3, 0
; AIX32-NEXT:    beq 0, L..BB0_51
; AIX32-NEXT:  # %bb.52: # %atomicrmw.end1
; AIX32-NEXT:    li 29, 1
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 18, 29, 26
; AIX32-NEXT:    slw 3, 3, 26
; AIX32-NEXT:  L..BB0_53: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 28
; AIX32-NEXT:    nand 5, 18, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 28
; AIX32-NEXT:    bne 0, L..BB0_53
; AIX32-NEXT:  # %bb.54: # %atomicrmw.end1
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    slw 17, 29, 24
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 24
; AIX32-NEXT:  L..BB0_55: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 27
; AIX32-NEXT:    nand 5, 17, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 27
; AIX32-NEXT:    bne 0, L..BB0_55
; AIX32-NEXT:  # %bb.56: # %atomicrmw.end1
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    slw 16, 29, 22
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 22
; AIX32-NEXT:  L..BB0_57: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    nand 5, 16, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 25
; AIX32-NEXT:    bne 0, L..BB0_57
; AIX32-NEXT:  # %bb.58: # %atomicrmw.end1
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    slw 15, 29, 21
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 21
; AIX32-NEXT:  L..BB0_59: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 23
; AIX32-NEXT:    nand 5, 15, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 23
; AIX32-NEXT:    bne 0, L..BB0_59
; AIX32-NEXT:  # %bb.60: # %atomicrmw.end1
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB0_61: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 20
; AIX32-NEXT:    nand 3, 29, 3
; AIX32-NEXT:    stwcx. 3, 0, 20
; AIX32-NEXT:    bne 0, L..BB0_61
; AIX32-NEXT:  # %bb.62: # %atomicrmw.end1
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB0_63: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 19
; AIX32-NEXT:    nand 3, 29, 3
; AIX32-NEXT:    stwcx. 3, 0, 19
; AIX32-NEXT:    bne 0, L..BB0_63
; AIX32-NEXT:  # %bb.64: # %atomicrmw.end1
; AIX32-NEXT:    lwz 31, L..C6(2) # @sll
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    bl .__atomic_fetch_nand_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 30, L..C7(2) # @ull
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    bl .__atomic_fetch_nand_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 26
; AIX32-NEXT:  L..BB0_65: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 28
; AIX32-NEXT:    and 5, 18, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 28
; AIX32-NEXT:    bne 0, L..BB0_65
; AIX32-NEXT:  # %bb.66: # %atomicrmw.end1
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 24
; AIX32-NEXT:  L..BB0_67: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 27
; AIX32-NEXT:    and 5, 17, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 27
; AIX32-NEXT:    bne 0, L..BB0_67
; AIX32-NEXT:  # %bb.68: # %atomicrmw.end1
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 22
; AIX32-NEXT:  L..BB0_69: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    and 5, 16, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 25
; AIX32-NEXT:    bne 0, L..BB0_69
; AIX32-NEXT:  # %bb.70: # %atomicrmw.end1
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 21
; AIX32-NEXT:  L..BB0_71: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 23
; AIX32-NEXT:    and 5, 15, 4
; AIX32-NEXT:    andc 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 4, 5, 4
; AIX32-NEXT:    stwcx. 4, 0, 23
; AIX32-NEXT:    bne 0, L..BB0_71
; AIX32-NEXT:  # %bb.72: # %atomicrmw.end1
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB0_73: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 20
; AIX32-NEXT:    and 3, 29, 3
; AIX32-NEXT:    stwcx. 3, 0, 20
; AIX32-NEXT:    bne 0, L..BB0_73
; AIX32-NEXT:  # %bb.74: # %atomicrmw.end1
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB0_75: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 19
; AIX32-NEXT:    and 3, 29, 3
; AIX32-NEXT:    stwcx. 3, 0, 19
; AIX32-NEXT:    bne 0, L..BB0_75
; AIX32-NEXT:  # %bb.76: # %atomicrmw.end1
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    bl .__atomic_fetch_and_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    bl .__atomic_fetch_and_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 31, 156(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 30, 152(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 29, 148(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 28, 144(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 27, 140(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 26, 136(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 25, 132(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 24, 128(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 23, 124(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 22, 120(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 21, 116(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 20, 112(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 19, 108(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 18, 104(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 17, 100(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 16, 96(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 15, 92(1) # 4-byte Folded Reload
; AIX32-NEXT:    addi 1, 1, 160
; AIX32-NEXT:    lwz 0, 8(1)
; AIX32-NEXT:    mtlr 0
; AIX32-NEXT:    blr
entry:
  %0 = atomicrmw add ptr @sc, i8 1 seq_cst, align 1
  %1 = atomicrmw add ptr @uc, i8 1 seq_cst, align 1
  %2 = atomicrmw add ptr @ss, i16 1 seq_cst, align 2
  %3 = atomicrmw add ptr @us, i16 1 seq_cst, align 2
  %4 = atomicrmw add ptr @si, i32 1 seq_cst, align 4
  %5 = atomicrmw add ptr @ui, i32 1 seq_cst, align 4
  %6 = atomicrmw add ptr @sll, i64 1 seq_cst, align 8
  %7 = atomicrmw add ptr @ull, i64 1 seq_cst, align 8
  %8 = atomicrmw sub ptr @sc, i8 1 seq_cst, align 1
  %9 = atomicrmw sub ptr @uc, i8 1 seq_cst, align 1
  %10 = atomicrmw sub ptr @ss, i16 1 seq_cst, align 2
  %11 = atomicrmw sub ptr @us, i16 1 seq_cst, align 2
  %12 = atomicrmw sub ptr @si, i32 1 seq_cst, align 4
  %13 = atomicrmw sub ptr @ui, i32 1 seq_cst, align 4
  %14 = atomicrmw sub ptr @sll, i64 1 seq_cst, align 8
  %15 = atomicrmw sub ptr @ull, i64 1 seq_cst, align 8
  %16 = atomicrmw or ptr @sc, i8 1 seq_cst, align 1
  %17 = atomicrmw or ptr @uc, i8 1 seq_cst, align 1
  %18 = atomicrmw or ptr @ss, i16 1 seq_cst, align 2
  %19 = atomicrmw or ptr @us, i16 1 seq_cst, align 2
  %20 = atomicrmw or ptr @si, i32 1 seq_cst, align 4
  %21 = atomicrmw or ptr @ui, i32 1 seq_cst, align 4
  %22 = atomicrmw or ptr @sll, i64 1 seq_cst, align 8
  %23 = atomicrmw or ptr @ull, i64 1 seq_cst, align 8
  %24 = atomicrmw xor ptr @sc, i8 1 seq_cst, align 1
  %25 = atomicrmw xor ptr @uc, i8 1 seq_cst, align 1
  %26 = atomicrmw xor ptr @ss, i16 1 seq_cst, align 2
  %27 = atomicrmw xor ptr @us, i16 1 seq_cst, align 2
  %28 = atomicrmw xor ptr @si, i32 1 seq_cst, align 4
  %29 = atomicrmw xor ptr @ui, i32 1 seq_cst, align 4
  %30 = atomicrmw xor ptr @sll, i64 1 seq_cst, align 8
  %31 = atomicrmw xor ptr @ull, i64 1 seq_cst, align 8
  %32 = atomicrmw xor ptr @u128, i128 1 seq_cst, align 16
  %33 = atomicrmw xor ptr @s128, i128 1 seq_cst, align 16
  %34 = atomicrmw nand ptr @sc, i8 1 seq_cst, align 1
  %35 = atomicrmw nand ptr @uc, i8 1 seq_cst, align 1
  %36 = atomicrmw nand ptr @ss, i16 1 seq_cst, align 2
  %37 = atomicrmw nand ptr @us, i16 1 seq_cst, align 2
  %38 = atomicrmw nand ptr @si, i32 1 seq_cst, align 4
  %39 = atomicrmw nand ptr @ui, i32 1 seq_cst, align 4
  %40 = atomicrmw nand ptr @sll, i64 1 seq_cst, align 8
  %41 = atomicrmw nand ptr @ull, i64 1 seq_cst, align 8
  %42 = atomicrmw and ptr @sc, i8 1 seq_cst, align 1
  %43 = atomicrmw and ptr @uc, i8 1 seq_cst, align 1
  %44 = atomicrmw and ptr @ss, i16 1 seq_cst, align 2
  %45 = atomicrmw and ptr @us, i16 1 seq_cst, align 2
  %46 = atomicrmw and ptr @si, i32 1 seq_cst, align 4
  %47 = atomicrmw and ptr @ui, i32 1 seq_cst, align 4
  %48 = atomicrmw and ptr @sll, i64 1 seq_cst, align 8
  %49 = atomicrmw and ptr @ull, i64 1 seq_cst, align 8
  ret void
}

define dso_local void @test_fetch_and_op() local_unnamed_addr #0 {
; CHECK-LABEL: test_fetch_and_op:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 4, 2, sc@toc@ha
; CHECK-NEXT:    std 22, -80(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 23, -72(1) # 8-byte Folded Spill
; CHECK-NEXT:    li 3, 11
; CHECK-NEXT:    std 24, -64(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 25, -56(1) # 8-byte Folded Spill
; CHECK-NEXT:    addi 6, 4, sc@toc@l
; CHECK-NEXT:    std 26, -48(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 27, -40(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 28, -32(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 29, -24(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 30, -16(1) # 8-byte Folded Spill
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 5, 0, 6
; CHECK-NEXT:    addi 7, 5, 11
; CHECK-NEXT:    stbcx. 7, 0, 6
; CHECK-NEXT:    bne 0, .LBB1_1
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 5, sc@toc@l(4)
; CHECK-NEXT:    addis 5, 2, uc@toc@ha
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 8, 5, uc@toc@l
; CHECK-NEXT:  .LBB1_3: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 7, 0, 8
; CHECK-NEXT:    addi 9, 7, 11
; CHECK-NEXT:    stbcx. 9, 0, 8
; CHECK-NEXT:    bne 0, .LBB1_3
; CHECK-NEXT:  # %bb.4: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 7, uc@toc@l(5)
; CHECK-NEXT:    addis 7, 2, ss@toc@ha
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 10, 7, ss@toc@l
; CHECK-NEXT:  .LBB1_5: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 9, 0, 10
; CHECK-NEXT:    addi 11, 9, 11
; CHECK-NEXT:    sthcx. 11, 0, 10
; CHECK-NEXT:    bne 0, .LBB1_5
; CHECK-NEXT:  # %bb.6: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 9, ss@toc@l(7)
; CHECK-NEXT:    addis 9, 2, us@toc@ha
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 0, 9, us@toc@l
; CHECK-NEXT:  .LBB1_7: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 11, 0, 0
; CHECK-NEXT:    addi 12, 11, 11
; CHECK-NEXT:    sthcx. 12, 0, 0
; CHECK-NEXT:    bne 0, .LBB1_7
; CHECK-NEXT:  # %bb.8: # %entry
; CHECK-NEXT:    addis 12, 2, si@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 11, us@toc@l(9)
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 29, 12, si@toc@l
; CHECK-NEXT:  .LBB1_9: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 11, 0, 29
; CHECK-NEXT:    addi 30, 11, 11
; CHECK-NEXT:    stwcx. 30, 0, 29
; CHECK-NEXT:    bne 0, .LBB1_9
; CHECK-NEXT:  # %bb.10: # %entry
; CHECK-NEXT:    addis 30, 2, ui@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 11, si@toc@l(12)
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 27, 30, ui@toc@l
; CHECK-NEXT:  .LBB1_11: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 11, 0, 27
; CHECK-NEXT:    addi 28, 11, 11
; CHECK-NEXT:    stwcx. 28, 0, 27
; CHECK-NEXT:    bne 0, .LBB1_11
; CHECK-NEXT:  # %bb.12: # %entry
; CHECK-NEXT:    addis 28, 2, sll@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 11, ui@toc@l(30)
; CHECK-NEXT:    li 11, 11
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 25, 28, sll@toc@l
; CHECK-NEXT:  .LBB1_13: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 26, 0, 25
; CHECK-NEXT:    addi 24, 26, 11
; CHECK-NEXT:    stdcx. 24, 0, 25
; CHECK-NEXT:    bne 0, .LBB1_13
; CHECK-NEXT:  # %bb.14: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 26, sll@toc@l(28)
; CHECK-NEXT:    addis 26, 2, ull@toc@ha
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 24, 26, ull@toc@l
; CHECK-NEXT:  .LBB1_15: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 23, 0, 24
; CHECK-NEXT:    addi 22, 23, 11
; CHECK-NEXT:    stdcx. 22, 0, 24
; CHECK-NEXT:    bne 0, .LBB1_15
; CHECK-NEXT:  # %bb.16: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 23, ull@toc@l(26)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_17: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 23, 0, 6
; CHECK-NEXT:    sub 22, 23, 3
; CHECK-NEXT:    stbcx. 22, 0, 6
; CHECK-NEXT:    bne 0, .LBB1_17
; CHECK-NEXT:  # %bb.18: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 23, sc@toc@l(4)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_19: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 23, 0, 8
; CHECK-NEXT:    sub 22, 23, 3
; CHECK-NEXT:    stbcx. 22, 0, 8
; CHECK-NEXT:    bne 0, .LBB1_19
; CHECK-NEXT:  # %bb.20: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 23, uc@toc@l(5)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_21: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 23, 0, 10
; CHECK-NEXT:    sub 22, 23, 3
; CHECK-NEXT:    sthcx. 22, 0, 10
; CHECK-NEXT:    bne 0, .LBB1_21
; CHECK-NEXT:  # %bb.22: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 23, ss@toc@l(7)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_23: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 23, 0, 0
; CHECK-NEXT:    sub 22, 23, 3
; CHECK-NEXT:    sthcx. 22, 0, 0
; CHECK-NEXT:    bne 0, .LBB1_23
; CHECK-NEXT:  # %bb.24: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 23, us@toc@l(9)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_25: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 23, 0, 29
; CHECK-NEXT:    sub 22, 23, 3
; CHECK-NEXT:    stwcx. 22, 0, 29
; CHECK-NEXT:    bne 0, .LBB1_25
; CHECK-NEXT:  # %bb.26: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 23, si@toc@l(12)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_27: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 23, 0, 27
; CHECK-NEXT:    sub 22, 23, 3
; CHECK-NEXT:    stwcx. 22, 0, 27
; CHECK-NEXT:    bne 0, .LBB1_27
; CHECK-NEXT:  # %bb.28: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 23, ui@toc@l(30)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_29: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 23, 0, 25
; CHECK-NEXT:    sub 22, 23, 11
; CHECK-NEXT:    stdcx. 22, 0, 25
; CHECK-NEXT:    bne 0, .LBB1_29
; CHECK-NEXT:  # %bb.30: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 23, sll@toc@l(28)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_31: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 23, 0, 24
; CHECK-NEXT:    sub 22, 23, 11
; CHECK-NEXT:    stdcx. 22, 0, 24
; CHECK-NEXT:    bne 0, .LBB1_31
; CHECK-NEXT:  # %bb.32: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 23, ull@toc@l(26)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_33: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 23, 0, 6
; CHECK-NEXT:    ori 22, 23, 11
; CHECK-NEXT:    stbcx. 22, 0, 6
; CHECK-NEXT:    bne 0, .LBB1_33
; CHECK-NEXT:  # %bb.34: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 23, sc@toc@l(4)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_35: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 23, 0, 8
; CHECK-NEXT:    ori 22, 23, 11
; CHECK-NEXT:    stbcx. 22, 0, 8
; CHECK-NEXT:    bne 0, .LBB1_35
; CHECK-NEXT:  # %bb.36: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 23, uc@toc@l(5)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_37: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 23, 0, 10
; CHECK-NEXT:    ori 22, 23, 11
; CHECK-NEXT:    sthcx. 22, 0, 10
; CHECK-NEXT:    bne 0, .LBB1_37
; CHECK-NEXT:  # %bb.38: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 23, ss@toc@l(7)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_39: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 23, 0, 0
; CHECK-NEXT:    ori 22, 23, 11
; CHECK-NEXT:    sthcx. 22, 0, 0
; CHECK-NEXT:    bne 0, .LBB1_39
; CHECK-NEXT:  # %bb.40: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 23, us@toc@l(9)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_41: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 23, 0, 29
; CHECK-NEXT:    ori 22, 23, 11
; CHECK-NEXT:    stwcx. 22, 0, 29
; CHECK-NEXT:    bne 0, .LBB1_41
; CHECK-NEXT:  # %bb.42: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 23, si@toc@l(12)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_43: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 23, 0, 27
; CHECK-NEXT:    ori 22, 23, 11
; CHECK-NEXT:    stwcx. 22, 0, 27
; CHECK-NEXT:    bne 0, .LBB1_43
; CHECK-NEXT:  # %bb.44: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 23, ui@toc@l(30)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_45: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 23, 0, 25
; CHECK-NEXT:    ori 22, 23, 11
; CHECK-NEXT:    stdcx. 22, 0, 25
; CHECK-NEXT:    bne 0, .LBB1_45
; CHECK-NEXT:  # %bb.46: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 23, sll@toc@l(28)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_47: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 23, 0, 24
; CHECK-NEXT:    ori 22, 23, 11
; CHECK-NEXT:    stdcx. 22, 0, 24
; CHECK-NEXT:    bne 0, .LBB1_47
; CHECK-NEXT:  # %bb.48: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 23, ull@toc@l(26)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_49: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 23, 0, 6
; CHECK-NEXT:    xori 22, 23, 11
; CHECK-NEXT:    stbcx. 22, 0, 6
; CHECK-NEXT:    bne 0, .LBB1_49
; CHECK-NEXT:  # %bb.50: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 23, sc@toc@l(4)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_51: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 23, 0, 8
; CHECK-NEXT:    xori 22, 23, 11
; CHECK-NEXT:    stbcx. 22, 0, 8
; CHECK-NEXT:    bne 0, .LBB1_51
; CHECK-NEXT:  # %bb.52: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 23, uc@toc@l(5)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_53: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 23, 0, 10
; CHECK-NEXT:    xori 22, 23, 11
; CHECK-NEXT:    sthcx. 22, 0, 10
; CHECK-NEXT:    bne 0, .LBB1_53
; CHECK-NEXT:  # %bb.54: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 23, ss@toc@l(7)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_55: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 23, 0, 0
; CHECK-NEXT:    xori 22, 23, 11
; CHECK-NEXT:    sthcx. 22, 0, 0
; CHECK-NEXT:    bne 0, .LBB1_55
; CHECK-NEXT:  # %bb.56: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 23, us@toc@l(9)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_57: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 23, 0, 29
; CHECK-NEXT:    xori 22, 23, 11
; CHECK-NEXT:    stwcx. 22, 0, 29
; CHECK-NEXT:    bne 0, .LBB1_57
; CHECK-NEXT:  # %bb.58: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 23, si@toc@l(12)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_59: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 23, 0, 27
; CHECK-NEXT:    xori 22, 23, 11
; CHECK-NEXT:    stwcx. 22, 0, 27
; CHECK-NEXT:    bne 0, .LBB1_59
; CHECK-NEXT:  # %bb.60: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 23, ui@toc@l(30)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_61: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 23, 0, 25
; CHECK-NEXT:    xori 22, 23, 11
; CHECK-NEXT:    stdcx. 22, 0, 25
; CHECK-NEXT:    bne 0, .LBB1_61
; CHECK-NEXT:  # %bb.62: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 23, sll@toc@l(28)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_63: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 23, 0, 24
; CHECK-NEXT:    xori 22, 23, 11
; CHECK-NEXT:    stdcx. 22, 0, 24
; CHECK-NEXT:    bne 0, .LBB1_63
; CHECK-NEXT:  # %bb.64: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 23, ull@toc@l(26)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_65: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 23, 0, 6
; CHECK-NEXT:    nand 22, 3, 23
; CHECK-NEXT:    stbcx. 22, 0, 6
; CHECK-NEXT:    bne 0, .LBB1_65
; CHECK-NEXT:  # %bb.66: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 23, sc@toc@l(4)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_67: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 23, 0, 8
; CHECK-NEXT:    nand 22, 3, 23
; CHECK-NEXT:    stbcx. 22, 0, 8
; CHECK-NEXT:    bne 0, .LBB1_67
; CHECK-NEXT:  # %bb.68: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 23, uc@toc@l(5)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_69: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 23, 0, 10
; CHECK-NEXT:    nand 22, 3, 23
; CHECK-NEXT:    sthcx. 22, 0, 10
; CHECK-NEXT:    bne 0, .LBB1_69
; CHECK-NEXT:  # %bb.70: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 23, ss@toc@l(7)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_71: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 23, 0, 0
; CHECK-NEXT:    nand 22, 3, 23
; CHECK-NEXT:    sthcx. 22, 0, 0
; CHECK-NEXT:    bne 0, .LBB1_71
; CHECK-NEXT:  # %bb.72: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 23, us@toc@l(9)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_73: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 23, 0, 29
; CHECK-NEXT:    nand 22, 3, 23
; CHECK-NEXT:    stwcx. 22, 0, 29
; CHECK-NEXT:    bne 0, .LBB1_73
; CHECK-NEXT:  # %bb.74: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 23, si@toc@l(12)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_75: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 23, 0, 27
; CHECK-NEXT:    nand 22, 3, 23
; CHECK-NEXT:    stwcx. 22, 0, 27
; CHECK-NEXT:    bne 0, .LBB1_75
; CHECK-NEXT:  # %bb.76: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 23, ui@toc@l(30)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_77: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 23, 0, 25
; CHECK-NEXT:    nand 22, 11, 23
; CHECK-NEXT:    stdcx. 22, 0, 25
; CHECK-NEXT:    bne 0, .LBB1_77
; CHECK-NEXT:  # %bb.78: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 23, sll@toc@l(28)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_79: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 23, 0, 24
; CHECK-NEXT:    nand 22, 11, 23
; CHECK-NEXT:    stdcx. 22, 0, 24
; CHECK-NEXT:    bne 0, .LBB1_79
; CHECK-NEXT:  # %bb.80: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 23, ull@toc@l(26)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_81: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 23, 0, 6
; CHECK-NEXT:    and 22, 3, 23
; CHECK-NEXT:    stbcx. 22, 0, 6
; CHECK-NEXT:    bne 0, .LBB1_81
; CHECK-NEXT:  # %bb.82: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 23, sc@toc@l(4)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_83: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 4, 0, 8
; CHECK-NEXT:    and 6, 3, 4
; CHECK-NEXT:    stbcx. 6, 0, 8
; CHECK-NEXT:    bne 0, .LBB1_83
; CHECK-NEXT:  # %bb.84: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 4, uc@toc@l(5)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_85: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 4, 0, 10
; CHECK-NEXT:    and 5, 3, 4
; CHECK-NEXT:    sthcx. 5, 0, 10
; CHECK-NEXT:    bne 0, .LBB1_85
; CHECK-NEXT:  # %bb.86: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 4, ss@toc@l(7)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_87: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 4, 0, 0
; CHECK-NEXT:    and 5, 3, 4
; CHECK-NEXT:    sthcx. 5, 0, 0
; CHECK-NEXT:    bne 0, .LBB1_87
; CHECK-NEXT:  # %bb.88: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 4, us@toc@l(9)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_89: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 4, 0, 29
; CHECK-NEXT:    and 5, 3, 4
; CHECK-NEXT:    stwcx. 5, 0, 29
; CHECK-NEXT:    bne 0, .LBB1_89
; CHECK-NEXT:  # %bb.90: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 4, si@toc@l(12)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_91: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 4, 0, 27
; CHECK-NEXT:    and 5, 3, 4
; CHECK-NEXT:    stwcx. 5, 0, 27
; CHECK-NEXT:    bne 0, .LBB1_91
; CHECK-NEXT:  # %bb.92: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 4, ui@toc@l(30)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_93: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 3, 0, 25
; CHECK-NEXT:    and 4, 11, 3
; CHECK-NEXT:    stdcx. 4, 0, 25
; CHECK-NEXT:    bne 0, .LBB1_93
; CHECK-NEXT:  # %bb.94: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 3, sll@toc@l(28)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB1_95: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 3, 0, 24
; CHECK-NEXT:    and 4, 11, 3
; CHECK-NEXT:    stdcx. 4, 0, 24
; CHECK-NEXT:    bne 0, .LBB1_95
; CHECK-NEXT:  # %bb.96: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 3, ull@toc@l(26)
; CHECK-NEXT:    ld 30, -16(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 29, -24(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 28, -32(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 27, -40(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 26, -48(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 25, -56(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 24, -64(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 23, -72(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 22, -80(1) # 8-byte Folded Reload
; CHECK-NEXT:    blr
;
; AIX32-LABEL: test_fetch_and_op:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    mflr 0
; AIX32-NEXT:    stwu 1, -144(1)
; AIX32-NEXT:    lwz 4, L..C0(2) # @sc
; AIX32-NEXT:    stw 0, 152(1)
; AIX32-NEXT:    li 7, 11
; AIX32-NEXT:    stw 26, 120(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 13, 68(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 14, 72(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 15, 76(1) # 4-byte Folded Spill
; AIX32-NEXT:    rlwinm 3, 4, 3, 27, 28
; AIX32-NEXT:    stw 16, 80(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 17, 84(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 18, 88(1) # 4-byte Folded Spill
; AIX32-NEXT:    xori 26, 3, 24
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    slw 3, 3, 26
; AIX32-NEXT:    stw 19, 92(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 20, 96(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 21, 100(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 22, 104(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 23, 108(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 24, 112(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 25, 116(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 27, 124(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 28, 128(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 29, 132(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 30, 136(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 31, 140(1) # 4-byte Folded Spill
; AIX32-NEXT:    sync
; AIX32-NEXT:    rlwinm 25, 4, 0, 0, 29
; AIX32-NEXT:    slw 24, 7, 26
; AIX32-NEXT:    stw 4, 64(1) # 4-byte Folded Spill
; AIX32-NEXT:  L..BB1_1: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    add 5, 24, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 25
; AIX32-NEXT:    bne 0, L..BB1_1
; AIX32-NEXT:  # %bb.2: # %entry
; AIX32-NEXT:    srw 3, 4, 26
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lwz 27, L..C1(2) # @uc
; AIX32-NEXT:    lwz 4, 64(1) # 4-byte Folded Reload
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    rlwinm 21, 27, 0, 0, 29
; AIX32-NEXT:    stb 3, 0(4)
; AIX32-NEXT:    rlwinm 3, 27, 3, 27, 28
; AIX32-NEXT:    sync
; AIX32-NEXT:    xori 22, 3, 24
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    slw 20, 7, 22
; AIX32-NEXT:    slw 3, 3, 22
; AIX32-NEXT:  L..BB1_3: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 21
; AIX32-NEXT:    add 5, 20, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 21
; AIX32-NEXT:    bne 0, L..BB1_3
; AIX32-NEXT:  # %bb.4: # %entry
; AIX32-NEXT:    srw 3, 4, 22
; AIX32-NEXT:    lwz 23, L..C2(2) # @ss
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    rlwinm 17, 23, 0, 0, 29
; AIX32-NEXT:    stb 3, 0(27)
; AIX32-NEXT:    sync
; AIX32-NEXT:    rlwinm 3, 23, 3, 27, 27
; AIX32-NEXT:    xori 18, 3, 16
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 16, 7, 18
; AIX32-NEXT:    slw 3, 3, 18
; AIX32-NEXT:  L..BB1_5: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 17
; AIX32-NEXT:    add 5, 16, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 17
; AIX32-NEXT:    bne 0, L..BB1_5
; AIX32-NEXT:  # %bb.6: # %entry
; AIX32-NEXT:    srw 3, 4, 18
; AIX32-NEXT:    lwz 19, L..C3(2) # @us
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 16
; AIX32-NEXT:    rlwinm 14, 19, 0, 0, 29
; AIX32-NEXT:    sth 3, 0(23)
; AIX32-NEXT:    sync
; AIX32-NEXT:    rlwinm 3, 19, 3, 27, 27
; AIX32-NEXT:    xori 15, 3, 16
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 13, 7, 15
; AIX32-NEXT:    slw 3, 3, 15
; AIX32-NEXT:  L..BB1_7: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 14
; AIX32-NEXT:    add 5, 13, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 14
; AIX32-NEXT:    bne 0, L..BB1_7
; AIX32-NEXT:  # %bb.8: # %entry
; AIX32-NEXT:    srw 3, 4, 15
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lwz 29, L..C4(2) # @si
; AIX32-NEXT:    clrlwi 3, 3, 16
; AIX32-NEXT:    sth 3, 0(19)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB1_9: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 29
; AIX32-NEXT:    addi 4, 3, 11
; AIX32-NEXT:    stwcx. 4, 0, 29
; AIX32-NEXT:    bne 0, L..BB1_9
; AIX32-NEXT:  # %bb.10: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 3, 0(29)
; AIX32-NEXT:    lwz 28, L..C5(2) # @ui
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB1_11: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 28
; AIX32-NEXT:    addi 4, 3, 11
; AIX32-NEXT:    stwcx. 4, 0, 28
; AIX32-NEXT:    bne 0, L..BB1_11
; AIX32-NEXT:  # %bb.12: # %entry
; AIX32-NEXT:    lwz 31, L..C6(2) # @sll
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 11
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 0(28)
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    bl .__atomic_fetch_add_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 30, L..C7(2) # @ull
; AIX32-NEXT:    stw 4, 4(31)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 11
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 0(31)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    bl .__atomic_fetch_add_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 3, 0(30)
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    stw 4, 4(30)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 26
; AIX32-NEXT:  L..BB1_13: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    sub 5, 4, 24
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 25
; AIX32-NEXT:    bne 0, L..BB1_13
; AIX32-NEXT:  # %bb.14: # %entry
; AIX32-NEXT:    srw 3, 4, 26
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lwz 4, 64(1) # 4-byte Folded Reload
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    stb 3, 0(4)
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 22
; AIX32-NEXT:  L..BB1_15: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 21
; AIX32-NEXT:    sub 5, 4, 20
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 21
; AIX32-NEXT:    bne 0, L..BB1_15
; AIX32-NEXT:  # %bb.16: # %entry
; AIX32-NEXT:    srw 3, 4, 22
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 7, 11
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    stb 3, 0(27)
; AIX32-NEXT:    sync
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 18
; AIX32-NEXT:  L..BB1_17: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 17
; AIX32-NEXT:    sub 5, 4, 16
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 17
; AIX32-NEXT:    bne 0, L..BB1_17
; AIX32-NEXT:  # %bb.18: # %entry
; AIX32-NEXT:    srw 3, 4, 18
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 16
; AIX32-NEXT:    sth 3, 0(23)
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 15
; AIX32-NEXT:  L..BB1_19: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 14
; AIX32-NEXT:    sub 5, 4, 13
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 14
; AIX32-NEXT:    bne 0, L..BB1_19
; AIX32-NEXT:  # %bb.20: # %entry
; AIX32-NEXT:    srw 3, 4, 15
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 16
; AIX32-NEXT:    sth 3, 0(19)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB1_21: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 29
; AIX32-NEXT:    sub 4, 3, 7
; AIX32-NEXT:    stwcx. 4, 0, 29
; AIX32-NEXT:    bne 0, L..BB1_21
; AIX32-NEXT:  # %bb.22: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 3, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB1_23: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 28
; AIX32-NEXT:    sub 4, 3, 7
; AIX32-NEXT:    stwcx. 4, 0, 28
; AIX32-NEXT:    bne 0, L..BB1_23
; AIX32-NEXT:  # %bb.24: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 11
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 0(28)
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    bl .__atomic_fetch_sub_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 4, 4(31)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 11
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 0(31)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    bl .__atomic_fetch_sub_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 3, 0(30)
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    stw 4, 4(30)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 26
; AIX32-NEXT:  L..BB1_25: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    or 5, 24, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 25
; AIX32-NEXT:    bne 0, L..BB1_25
; AIX32-NEXT:  # %bb.26: # %entry
; AIX32-NEXT:    srw 3, 4, 26
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lwz 4, 64(1) # 4-byte Folded Reload
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    stb 3, 0(4)
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 22
; AIX32-NEXT:  L..BB1_27: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 21
; AIX32-NEXT:    or 5, 20, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 21
; AIX32-NEXT:    bne 0, L..BB1_27
; AIX32-NEXT:  # %bb.28: # %entry
; AIX32-NEXT:    srw 3, 4, 22
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    stb 3, 0(27)
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 18
; AIX32-NEXT:  L..BB1_29: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 17
; AIX32-NEXT:    or 5, 16, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 17
; AIX32-NEXT:    bne 0, L..BB1_29
; AIX32-NEXT:  # %bb.30: # %entry
; AIX32-NEXT:    srw 3, 4, 18
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 16
; AIX32-NEXT:    sth 3, 0(23)
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 15
; AIX32-NEXT:  L..BB1_31: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 14
; AIX32-NEXT:    or 5, 13, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 14
; AIX32-NEXT:    bne 0, L..BB1_31
; AIX32-NEXT:  # %bb.32: # %entry
; AIX32-NEXT:    srw 3, 4, 15
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 16
; AIX32-NEXT:    sth 3, 0(19)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB1_33: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 29
; AIX32-NEXT:    ori 4, 3, 11
; AIX32-NEXT:    stwcx. 4, 0, 29
; AIX32-NEXT:    bne 0, L..BB1_33
; AIX32-NEXT:  # %bb.34: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 3, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB1_35: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 28
; AIX32-NEXT:    ori 4, 3, 11
; AIX32-NEXT:    stwcx. 4, 0, 28
; AIX32-NEXT:    bne 0, L..BB1_35
; AIX32-NEXT:  # %bb.36: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 11
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 0(28)
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    bl .__atomic_fetch_or_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 4, 4(31)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 11
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 0(31)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    bl .__atomic_fetch_or_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 3, 0(30)
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    stw 4, 4(30)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 26
; AIX32-NEXT:  L..BB1_37: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    xor 5, 24, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 25
; AIX32-NEXT:    bne 0, L..BB1_37
; AIX32-NEXT:  # %bb.38: # %entry
; AIX32-NEXT:    srw 3, 4, 26
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lwz 4, 64(1) # 4-byte Folded Reload
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    stb 3, 0(4)
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 22
; AIX32-NEXT:  L..BB1_39: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 21
; AIX32-NEXT:    xor 5, 20, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 21
; AIX32-NEXT:    bne 0, L..BB1_39
; AIX32-NEXT:  # %bb.40: # %entry
; AIX32-NEXT:    srw 3, 4, 22
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    stb 3, 0(27)
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 18
; AIX32-NEXT:  L..BB1_41: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 17
; AIX32-NEXT:    xor 5, 16, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 17
; AIX32-NEXT:    bne 0, L..BB1_41
; AIX32-NEXT:  # %bb.42: # %entry
; AIX32-NEXT:    srw 3, 4, 18
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 16
; AIX32-NEXT:    sth 3, 0(23)
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 15
; AIX32-NEXT:  L..BB1_43: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 14
; AIX32-NEXT:    xor 5, 13, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 14
; AIX32-NEXT:    bne 0, L..BB1_43
; AIX32-NEXT:  # %bb.44: # %entry
; AIX32-NEXT:    srw 3, 4, 15
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 16
; AIX32-NEXT:    sth 3, 0(19)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB1_45: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 29
; AIX32-NEXT:    xori 4, 3, 11
; AIX32-NEXT:    stwcx. 4, 0, 29
; AIX32-NEXT:    bne 0, L..BB1_45
; AIX32-NEXT:  # %bb.46: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 3, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB1_47: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 28
; AIX32-NEXT:    xori 4, 3, 11
; AIX32-NEXT:    stwcx. 4, 0, 28
; AIX32-NEXT:    bne 0, L..BB1_47
; AIX32-NEXT:  # %bb.48: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 11
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 0(28)
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    bl .__atomic_fetch_xor_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 4, 4(31)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 11
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 0(31)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    bl .__atomic_fetch_xor_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 3, 0(30)
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    stw 4, 4(30)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 26
; AIX32-NEXT:  L..BB1_49: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    nand 5, 24, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 25
; AIX32-NEXT:    bne 0, L..BB1_49
; AIX32-NEXT:  # %bb.50: # %entry
; AIX32-NEXT:    srw 3, 4, 26
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 7, 11
; AIX32-NEXT:    lwz 4, 64(1) # 4-byte Folded Reload
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    stb 3, 0(4)
; AIX32-NEXT:    sync
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    slw 3, 3, 22
; AIX32-NEXT:  L..BB1_51: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 21
; AIX32-NEXT:    nand 5, 20, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 21
; AIX32-NEXT:    bne 0, L..BB1_51
; AIX32-NEXT:  # %bb.52: # %entry
; AIX32-NEXT:    srw 3, 4, 22
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    stb 3, 0(27)
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 18
; AIX32-NEXT:  L..BB1_53: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 17
; AIX32-NEXT:    nand 5, 16, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 17
; AIX32-NEXT:    bne 0, L..BB1_53
; AIX32-NEXT:  # %bb.54: # %entry
; AIX32-NEXT:    srw 3, 4, 18
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 16
; AIX32-NEXT:    sth 3, 0(23)
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 15
; AIX32-NEXT:  L..BB1_55: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 14
; AIX32-NEXT:    nand 5, 13, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 14
; AIX32-NEXT:    bne 0, L..BB1_55
; AIX32-NEXT:  # %bb.56: # %entry
; AIX32-NEXT:    srw 3, 4, 15
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 16
; AIX32-NEXT:    sth 3, 0(19)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB1_57: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 29
; AIX32-NEXT:    nand 4, 7, 3
; AIX32-NEXT:    stwcx. 4, 0, 29
; AIX32-NEXT:    bne 0, L..BB1_57
; AIX32-NEXT:  # %bb.58: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 3, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB1_59: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 28
; AIX32-NEXT:    nand 4, 7, 3
; AIX32-NEXT:    stwcx. 4, 0, 28
; AIX32-NEXT:    bne 0, L..BB1_59
; AIX32-NEXT:  # %bb.60: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 11
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 0(28)
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    bl .__atomic_fetch_nand_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 4, 4(31)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 11
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 0(31)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    bl .__atomic_fetch_nand_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 3, 0(30)
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    stw 4, 4(30)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 26
; AIX32-NEXT:  L..BB1_61: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    and 5, 24, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 25
; AIX32-NEXT:    bne 0, L..BB1_61
; AIX32-NEXT:  # %bb.62: # %entry
; AIX32-NEXT:    srw 3, 4, 26
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lwz 4, 64(1) # 4-byte Folded Reload
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    stb 3, 0(4)
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 3, 3, 22
; AIX32-NEXT:  L..BB1_63: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 21
; AIX32-NEXT:    and 5, 20, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 21
; AIX32-NEXT:    bne 0, L..BB1_63
; AIX32-NEXT:  # %bb.64: # %entry
; AIX32-NEXT:    srw 3, 4, 22
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 7, 11
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    stb 3, 0(27)
; AIX32-NEXT:    sync
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 18
; AIX32-NEXT:  L..BB1_65: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 17
; AIX32-NEXT:    and 5, 16, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 17
; AIX32-NEXT:    bne 0, L..BB1_65
; AIX32-NEXT:  # %bb.66: # %entry
; AIX32-NEXT:    srw 3, 4, 18
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 16
; AIX32-NEXT:    sth 3, 0(23)
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    sync
; AIX32-NEXT:    ori 3, 3, 65535
; AIX32-NEXT:    slw 3, 3, 15
; AIX32-NEXT:  L..BB1_67: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 14
; AIX32-NEXT:    and 5, 13, 4
; AIX32-NEXT:    andc 6, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:    or 5, 5, 6
; AIX32-NEXT:    stwcx. 5, 0, 14
; AIX32-NEXT:    bne 0, L..BB1_67
; AIX32-NEXT:  # %bb.68: # %entry
; AIX32-NEXT:    srw 3, 4, 15
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 16
; AIX32-NEXT:    sth 3, 0(19)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB1_69: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 29
; AIX32-NEXT:    and 4, 7, 3
; AIX32-NEXT:    stwcx. 4, 0, 29
; AIX32-NEXT:    bne 0, L..BB1_69
; AIX32-NEXT:  # %bb.70: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 3, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB1_71: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 3, 0, 28
; AIX32-NEXT:    and 4, 7, 3
; AIX32-NEXT:    stwcx. 4, 0, 28
; AIX32-NEXT:    bne 0, L..BB1_71
; AIX32-NEXT:  # %bb.72: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 11
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 0(28)
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    bl .__atomic_fetch_and_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 4, 4(31)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 11
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 0(31)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    bl .__atomic_fetch_and_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 4, 4(30)
; AIX32-NEXT:    stw 3, 0(30)
; AIX32-NEXT:    lwz 31, 140(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 30, 136(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 29, 132(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 28, 128(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 27, 124(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 26, 120(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 25, 116(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 24, 112(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 23, 108(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 22, 104(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 21, 100(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 20, 96(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 19, 92(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 18, 88(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 17, 84(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 16, 80(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 15, 76(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 14, 72(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 13, 68(1) # 4-byte Folded Reload
; AIX32-NEXT:    addi 1, 1, 144
; AIX32-NEXT:    lwz 0, 8(1)
; AIX32-NEXT:    mtlr 0
; AIX32-NEXT:    blr
entry:
  %0 = atomicrmw add ptr @sc, i8 11 seq_cst, align 1
  store i8 %0, ptr @sc, align 1
  %1 = atomicrmw add ptr @uc, i8 11 seq_cst, align 1
  store i8 %1, ptr @uc, align 1
  %2 = atomicrmw add ptr @ss, i16 11 seq_cst, align 2
  store i16 %2, ptr @ss, align 2
  %3 = atomicrmw add ptr @us, i16 11 seq_cst, align 2
  store i16 %3, ptr @us, align 2
  %4 = atomicrmw add ptr @si, i32 11 seq_cst, align 4
  store i32 %4, ptr @si, align 4
  %5 = atomicrmw add ptr @ui, i32 11 seq_cst, align 4
  store i32 %5, ptr @ui, align 4
  %6 = atomicrmw add ptr @sll, i64 11 seq_cst, align 8
  store i64 %6, ptr @sll, align 8
  %7 = atomicrmw add ptr @ull, i64 11 seq_cst, align 8
  store i64 %7, ptr @ull, align 8
  %8 = atomicrmw sub ptr @sc, i8 11 seq_cst, align 1
  store i8 %8, ptr @sc, align 1
  %9 = atomicrmw sub ptr @uc, i8 11 seq_cst, align 1
  store i8 %9, ptr @uc, align 1
  %10 = atomicrmw sub ptr @ss, i16 11 seq_cst, align 2
  store i16 %10, ptr @ss, align 2
  %11 = atomicrmw sub ptr @us, i16 11 seq_cst, align 2
  store i16 %11, ptr @us, align 2
  %12 = atomicrmw sub ptr @si, i32 11 seq_cst, align 4
  store i32 %12, ptr @si, align 4
  %13 = atomicrmw sub ptr @ui, i32 11 seq_cst, align 4
  store i32 %13, ptr @ui, align 4
  %14 = atomicrmw sub ptr @sll, i64 11 seq_cst, align 8
  store i64 %14, ptr @sll, align 8
  %15 = atomicrmw sub ptr @ull, i64 11 seq_cst, align 8
  store i64 %15, ptr @ull, align 8
  %16 = atomicrmw or ptr @sc, i8 11 seq_cst, align 1
  store i8 %16, ptr @sc, align 1
  %17 = atomicrmw or ptr @uc, i8 11 seq_cst, align 1
  store i8 %17, ptr @uc, align 1
  %18 = atomicrmw or ptr @ss, i16 11 seq_cst, align 2
  store i16 %18, ptr @ss, align 2
  %19 = atomicrmw or ptr @us, i16 11 seq_cst, align 2
  store i16 %19, ptr @us, align 2
  %20 = atomicrmw or ptr @si, i32 11 seq_cst, align 4
  store i32 %20, ptr @si, align 4
  %21 = atomicrmw or ptr @ui, i32 11 seq_cst, align 4
  store i32 %21, ptr @ui, align 4
  %22 = atomicrmw or ptr @sll, i64 11 seq_cst, align 8
  store i64 %22, ptr @sll, align 8
  %23 = atomicrmw or ptr @ull, i64 11 seq_cst, align 8
  store i64 %23, ptr @ull, align 8
  %24 = atomicrmw xor ptr @sc, i8 11 seq_cst, align 1
  store i8 %24, ptr @sc, align 1
  %25 = atomicrmw xor ptr @uc, i8 11 seq_cst, align 1
  store i8 %25, ptr @uc, align 1
  %26 = atomicrmw xor ptr @ss, i16 11 seq_cst, align 2
  store i16 %26, ptr @ss, align 2
  %27 = atomicrmw xor ptr @us, i16 11 seq_cst, align 2
  store i16 %27, ptr @us, align 2
  %28 = atomicrmw xor ptr @si, i32 11 seq_cst, align 4
  store i32 %28, ptr @si, align 4
  %29 = atomicrmw xor ptr @ui, i32 11 seq_cst, align 4
  store i32 %29, ptr @ui, align 4
  %30 = atomicrmw xor ptr @sll, i64 11 seq_cst, align 8
  store i64 %30, ptr @sll, align 8
  %31 = atomicrmw xor ptr @ull, i64 11 seq_cst, align 8
  store i64 %31, ptr @ull, align 8
  %32 = atomicrmw nand ptr @sc, i8 11 seq_cst, align 1
  store i8 %32, ptr @sc, align 1
  %33 = atomicrmw nand ptr @uc, i8 11 seq_cst, align 1
  store i8 %33, ptr @uc, align 1
  %34 = atomicrmw nand ptr @ss, i16 11 seq_cst, align 2
  store i16 %34, ptr @ss, align 2
  %35 = atomicrmw nand ptr @us, i16 11 seq_cst, align 2
  store i16 %35, ptr @us, align 2
  %36 = atomicrmw nand ptr @si, i32 11 seq_cst, align 4
  store i32 %36, ptr @si, align 4
  %37 = atomicrmw nand ptr @ui, i32 11 seq_cst, align 4
  store i32 %37, ptr @ui, align 4
  %38 = atomicrmw nand ptr @sll, i64 11 seq_cst, align 8
  store i64 %38, ptr @sll, align 8
  %39 = atomicrmw nand ptr @ull, i64 11 seq_cst, align 8
  store i64 %39, ptr @ull, align 8
  %40 = atomicrmw and ptr @sc, i8 11 seq_cst, align 1
  store i8 %40, ptr @sc, align 1
  %41 = atomicrmw and ptr @uc, i8 11 seq_cst, align 1
  store i8 %41, ptr @uc, align 1
  %42 = atomicrmw and ptr @ss, i16 11 seq_cst, align 2
  store i16 %42, ptr @ss, align 2
  %43 = atomicrmw and ptr @us, i16 11 seq_cst, align 2
  store i16 %43, ptr @us, align 2
  %44 = atomicrmw and ptr @si, i32 11 seq_cst, align 4
  store i32 %44, ptr @si, align 4
  %45 = atomicrmw and ptr @ui, i32 11 seq_cst, align 4
  store i32 %45, ptr @ui, align 4
  %46 = atomicrmw and ptr @sll, i64 11 seq_cst, align 8
  store i64 %46, ptr @sll, align 8
  %47 = atomicrmw and ptr @ull, i64 11 seq_cst, align 8
  store i64 %47, ptr @ull, align 8
  ret void
}

define dso_local void @test_op_and_fetch() local_unnamed_addr #0 {
; CHECK-LABEL: test_op_and_fetch:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, uc@toc@ha
; CHECK-NEXT:    addis 5, 2, sc@toc@ha
; CHECK-NEXT:    std 16, -128(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 17, -120(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 18, -112(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 19, -104(1) # 8-byte Folded Spill
; CHECK-NEXT:    lbz 6, uc@toc@l(3)
; CHECK-NEXT:    std 20, -96(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 21, -88(1) # 8-byte Folded Spill
; CHECK-NEXT:    addi 4, 3, uc@toc@l
; CHECK-NEXT:    addi 7, 5, sc@toc@l
; CHECK-NEXT:    std 22, -80(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 23, -72(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 24, -64(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 25, -56(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 26, -48(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 27, -40(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 28, -32(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 29, -24(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 30, -16(1) # 8-byte Folded Spill
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 8, 0, 7
; CHECK-NEXT:    add 8, 6, 8
; CHECK-NEXT:    stbcx. 8, 0, 7
; CHECK-NEXT:    bne 0, .LBB2_1
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 8, sc@toc@l(5)
; CHECK-NEXT:    lbz 6, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_3: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 8, 0, 4
; CHECK-NEXT:    add 8, 6, 8
; CHECK-NEXT:    stbcx. 8, 0, 4
; CHECK-NEXT:    bne 0, .LBB2_3
; CHECK-NEXT:  # %bb.4: # %entry
; CHECK-NEXT:    addis 6, 2, ss@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 8, uc@toc@l(3)
; CHECK-NEXT:    clrlwi 8, 8, 24
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 9, 6, ss@toc@l
; CHECK-NEXT:  .LBB2_5: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 10, 0, 9
; CHECK-NEXT:    add 10, 8, 10
; CHECK-NEXT:    sthcx. 10, 0, 9
; CHECK-NEXT:    bne 0, .LBB2_5
; CHECK-NEXT:  # %bb.6: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    addis 8, 2, us@toc@ha
; CHECK-NEXT:    sth 10, ss@toc@l(6)
; CHECK-NEXT:    lbz 10, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 11, 8, us@toc@l
; CHECK-NEXT:  .LBB2_7: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 12, 0, 11
; CHECK-NEXT:    add 12, 10, 12
; CHECK-NEXT:    sthcx. 12, 0, 11
; CHECK-NEXT:    bne 0, .LBB2_7
; CHECK-NEXT:  # %bb.8: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    addis 10, 2, si@toc@ha
; CHECK-NEXT:    sth 12, us@toc@l(8)
; CHECK-NEXT:    lbz 12, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 0, 10, si@toc@l
; CHECK-NEXT:  .LBB2_9: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 30, 0, 0
; CHECK-NEXT:    add 30, 12, 30
; CHECK-NEXT:    stwcx. 30, 0, 0
; CHECK-NEXT:    bne 0, .LBB2_9
; CHECK-NEXT:  # %bb.10: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    addis 12, 2, ui@toc@ha
; CHECK-NEXT:    stw 30, si@toc@l(10)
; CHECK-NEXT:    lbz 30, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 29, 12, ui@toc@l
; CHECK-NEXT:  .LBB2_11: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 28, 0, 29
; CHECK-NEXT:    add 28, 30, 28
; CHECK-NEXT:    stwcx. 28, 0, 29
; CHECK-NEXT:    bne 0, .LBB2_11
; CHECK-NEXT:  # %bb.12: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    addis 30, 2, sll@toc@ha
; CHECK-NEXT:    stw 28, ui@toc@l(12)
; CHECK-NEXT:    lbz 28, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 27, 30, sll@toc@l
; CHECK-NEXT:  .LBB2_13: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 26, 0, 27
; CHECK-NEXT:    add 26, 28, 26
; CHECK-NEXT:    stdcx. 26, 0, 27
; CHECK-NEXT:    bne 0, .LBB2_13
; CHECK-NEXT:  # %bb.14: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    addis 28, 2, ull@toc@ha
; CHECK-NEXT:    std 26, sll@toc@l(30)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 26, 28, ull@toc@l
; CHECK-NEXT:  .LBB2_15: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 24, 0, 26
; CHECK-NEXT:    add 24, 25, 24
; CHECK-NEXT:    stdcx. 24, 0, 26
; CHECK-NEXT:    bne 0, .LBB2_15
; CHECK-NEXT:  # %bb.16: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 24, ull@toc@l(28)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_17: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 24, 0, 7
; CHECK-NEXT:    sub 24, 24, 25
; CHECK-NEXT:    stbcx. 24, 0, 7
; CHECK-NEXT:    bne 0, .LBB2_17
; CHECK-NEXT:  # %bb.18: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 24, sc@toc@l(5)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_19: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 24, 0, 4
; CHECK-NEXT:    sub 24, 24, 25
; CHECK-NEXT:    stbcx. 24, 0, 4
; CHECK-NEXT:    bne 0, .LBB2_19
; CHECK-NEXT:  # %bb.20: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 24, uc@toc@l(3)
; CHECK-NEXT:    clrlwi 25, 24, 24
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_21: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 24, 0, 9
; CHECK-NEXT:    sub 24, 24, 25
; CHECK-NEXT:    sthcx. 24, 0, 9
; CHECK-NEXT:    bne 0, .LBB2_21
; CHECK-NEXT:  # %bb.22: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 24, ss@toc@l(6)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_23: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 24, 0, 11
; CHECK-NEXT:    sub 24, 24, 25
; CHECK-NEXT:    sthcx. 24, 0, 11
; CHECK-NEXT:    bne 0, .LBB2_23
; CHECK-NEXT:  # %bb.24: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 24, us@toc@l(8)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_25: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 24, 0, 0
; CHECK-NEXT:    sub 24, 24, 25
; CHECK-NEXT:    stwcx. 24, 0, 0
; CHECK-NEXT:    bne 0, .LBB2_25
; CHECK-NEXT:  # %bb.26: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 24, si@toc@l(10)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_27: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 24, 0, 29
; CHECK-NEXT:    sub 24, 24, 25
; CHECK-NEXT:    stwcx. 24, 0, 29
; CHECK-NEXT:    bne 0, .LBB2_27
; CHECK-NEXT:  # %bb.28: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 24, ui@toc@l(12)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_29: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 24, 0, 27
; CHECK-NEXT:    sub 24, 24, 25
; CHECK-NEXT:    stdcx. 24, 0, 27
; CHECK-NEXT:    bne 0, .LBB2_29
; CHECK-NEXT:  # %bb.30: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 24, sll@toc@l(30)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_31: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 24, 0, 26
; CHECK-NEXT:    sub 24, 24, 25
; CHECK-NEXT:    stdcx. 24, 0, 26
; CHECK-NEXT:    bne 0, .LBB2_31
; CHECK-NEXT:  # %bb.32: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 24, ull@toc@l(28)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_33: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 24, 0, 7
; CHECK-NEXT:    or 24, 25, 24
; CHECK-NEXT:    stbcx. 24, 0, 7
; CHECK-NEXT:    bne 0, .LBB2_33
; CHECK-NEXT:  # %bb.34: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 24, sc@toc@l(5)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_35: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 24, 0, 4
; CHECK-NEXT:    or 24, 25, 24
; CHECK-NEXT:    stbcx. 24, 0, 4
; CHECK-NEXT:    bne 0, .LBB2_35
; CHECK-NEXT:  # %bb.36: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 24, uc@toc@l(3)
; CHECK-NEXT:    clrlwi 25, 24, 24
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_37: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 24, 0, 9
; CHECK-NEXT:    or 24, 25, 24
; CHECK-NEXT:    sthcx. 24, 0, 9
; CHECK-NEXT:    bne 0, .LBB2_37
; CHECK-NEXT:  # %bb.38: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 24, ss@toc@l(6)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_39: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 24, 0, 11
; CHECK-NEXT:    or 24, 25, 24
; CHECK-NEXT:    sthcx. 24, 0, 11
; CHECK-NEXT:    bne 0, .LBB2_39
; CHECK-NEXT:  # %bb.40: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 24, us@toc@l(8)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_41: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 24, 0, 0
; CHECK-NEXT:    or 24, 25, 24
; CHECK-NEXT:    stwcx. 24, 0, 0
; CHECK-NEXT:    bne 0, .LBB2_41
; CHECK-NEXT:  # %bb.42: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 24, si@toc@l(10)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_43: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 24, 0, 29
; CHECK-NEXT:    or 24, 25, 24
; CHECK-NEXT:    stwcx. 24, 0, 29
; CHECK-NEXT:    bne 0, .LBB2_43
; CHECK-NEXT:  # %bb.44: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 24, ui@toc@l(12)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_45: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 24, 0, 27
; CHECK-NEXT:    or 24, 25, 24
; CHECK-NEXT:    stdcx. 24, 0, 27
; CHECK-NEXT:    bne 0, .LBB2_45
; CHECK-NEXT:  # %bb.46: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 24, sll@toc@l(30)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_47: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 24, 0, 26
; CHECK-NEXT:    or 24, 25, 24
; CHECK-NEXT:    stdcx. 24, 0, 26
; CHECK-NEXT:    bne 0, .LBB2_47
; CHECK-NEXT:  # %bb.48: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 24, ull@toc@l(28)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_49: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 24, 0, 7
; CHECK-NEXT:    xor 24, 25, 24
; CHECK-NEXT:    stbcx. 24, 0, 7
; CHECK-NEXT:    bne 0, .LBB2_49
; CHECK-NEXT:  # %bb.50: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 24, sc@toc@l(5)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_51: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 24, 0, 4
; CHECK-NEXT:    xor 24, 25, 24
; CHECK-NEXT:    stbcx. 24, 0, 4
; CHECK-NEXT:    bne 0, .LBB2_51
; CHECK-NEXT:  # %bb.52: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 24, uc@toc@l(3)
; CHECK-NEXT:    clrlwi 25, 24, 24
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_53: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 24, 0, 9
; CHECK-NEXT:    xor 24, 25, 24
; CHECK-NEXT:    sthcx. 24, 0, 9
; CHECK-NEXT:    bne 0, .LBB2_53
; CHECK-NEXT:  # %bb.54: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 24, ss@toc@l(6)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_55: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 24, 0, 11
; CHECK-NEXT:    xor 24, 25, 24
; CHECK-NEXT:    sthcx. 24, 0, 11
; CHECK-NEXT:    bne 0, .LBB2_55
; CHECK-NEXT:  # %bb.56: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 24, us@toc@l(8)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_57: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 24, 0, 0
; CHECK-NEXT:    xor 24, 25, 24
; CHECK-NEXT:    stwcx. 24, 0, 0
; CHECK-NEXT:    bne 0, .LBB2_57
; CHECK-NEXT:  # %bb.58: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 24, si@toc@l(10)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_59: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 24, 0, 29
; CHECK-NEXT:    xor 24, 25, 24
; CHECK-NEXT:    stwcx. 24, 0, 29
; CHECK-NEXT:    bne 0, .LBB2_59
; CHECK-NEXT:  # %bb.60: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 24, ui@toc@l(12)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_61: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 24, 0, 27
; CHECK-NEXT:    xor 24, 25, 24
; CHECK-NEXT:    stdcx. 24, 0, 27
; CHECK-NEXT:    bne 0, .LBB2_61
; CHECK-NEXT:  # %bb.62: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 24, sll@toc@l(30)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_63: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 24, 0, 26
; CHECK-NEXT:    xor 24, 25, 24
; CHECK-NEXT:    stdcx. 24, 0, 26
; CHECK-NEXT:    bne 0, .LBB2_63
; CHECK-NEXT:  # %bb.64: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 24, ull@toc@l(28)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_65: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 24, 0, 7
; CHECK-NEXT:    nand 24, 25, 24
; CHECK-NEXT:    stbcx. 24, 0, 7
; CHECK-NEXT:    bne 0, .LBB2_65
; CHECK-NEXT:  # %bb.66: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 24, sc@toc@l(5)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_67: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 24, 0, 4
; CHECK-NEXT:    nand 24, 25, 24
; CHECK-NEXT:    stbcx. 24, 0, 4
; CHECK-NEXT:    bne 0, .LBB2_67
; CHECK-NEXT:  # %bb.68: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 24, uc@toc@l(3)
; CHECK-NEXT:    clrlwi 25, 24, 24
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_69: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 24, 0, 9
; CHECK-NEXT:    nand 24, 25, 24
; CHECK-NEXT:    sthcx. 24, 0, 9
; CHECK-NEXT:    bne 0, .LBB2_69
; CHECK-NEXT:  # %bb.70: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 24, ss@toc@l(6)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_71: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 24, 0, 11
; CHECK-NEXT:    nand 24, 25, 24
; CHECK-NEXT:    sthcx. 24, 0, 11
; CHECK-NEXT:    bne 0, .LBB2_71
; CHECK-NEXT:  # %bb.72: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 24, us@toc@l(8)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_73: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 24, 0, 0
; CHECK-NEXT:    nand 24, 25, 24
; CHECK-NEXT:    stwcx. 24, 0, 0
; CHECK-NEXT:    bne 0, .LBB2_73
; CHECK-NEXT:  # %bb.74: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 24, si@toc@l(10)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_75: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 24, 0, 29
; CHECK-NEXT:    nand 24, 25, 24
; CHECK-NEXT:    stwcx. 24, 0, 29
; CHECK-NEXT:    bne 0, .LBB2_75
; CHECK-NEXT:  # %bb.76: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 24, ui@toc@l(12)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_77: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 24, 0, 27
; CHECK-NEXT:    nand 24, 25, 24
; CHECK-NEXT:    stdcx. 24, 0, 27
; CHECK-NEXT:    bne 0, .LBB2_77
; CHECK-NEXT:  # %bb.78: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 24, sll@toc@l(30)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_79: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 24, 0, 26
; CHECK-NEXT:    nand 24, 25, 24
; CHECK-NEXT:    stdcx. 24, 0, 26
; CHECK-NEXT:    bne 0, .LBB2_79
; CHECK-NEXT:  # %bb.80: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 24, ull@toc@l(28)
; CHECK-NEXT:    addis 24, 2, u128@toc@ha
; CHECK-NEXT:    li 22, 0
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 23, 24, u128@toc@l
; CHECK-NEXT:  .LBB2_81: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lqarx 20, 0, 23
; CHECK-NEXT:    nand 19, 25, 21
; CHECK-NEXT:    nand 18, 22, 20
; CHECK-NEXT:    stqcx. 18, 0, 23
; CHECK-NEXT:    bne 0, .LBB2_81
; CHECK-NEXT:  # %bb.82: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    nand 25, 21, 25
; CHECK-NEXT:    li 21, -1
; CHECK-NEXT:    std 25, u128@toc@l(24)
; CHECK-NEXT:    addis 24, 2, s128@toc@ha
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    std 21, 8(23)
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 23, 24, s128@toc@l
; CHECK-NEXT:  .LBB2_83: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lqarx 18, 0, 23
; CHECK-NEXT:    nand 17, 25, 19
; CHECK-NEXT:    nand 16, 22, 18
; CHECK-NEXT:    stqcx. 16, 0, 23
; CHECK-NEXT:    bne 0, .LBB2_83
; CHECK-NEXT:  # %bb.84: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 21, 8(23)
; CHECK-NEXT:    nand 25, 19, 25
; CHECK-NEXT:    std 25, s128@toc@l(24)
; CHECK-NEXT:    lbz 25, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_85: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 24, 0, 7
; CHECK-NEXT:    and 24, 25, 24
; CHECK-NEXT:    stbcx. 24, 0, 7
; CHECK-NEXT:    bne 0, .LBB2_85
; CHECK-NEXT:  # %bb.86: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 24, sc@toc@l(5)
; CHECK-NEXT:    lbz 7, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_87: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 5, 0, 4
; CHECK-NEXT:    and 5, 7, 5
; CHECK-NEXT:    stbcx. 5, 0, 4
; CHECK-NEXT:    bne 0, .LBB2_87
; CHECK-NEXT:  # %bb.88: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 5, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_89: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 4, 0, 9
; CHECK-NEXT:    and 4, 5, 4
; CHECK-NEXT:    sthcx. 4, 0, 9
; CHECK-NEXT:    bne 0, .LBB2_89
; CHECK-NEXT:  # %bb.90: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 4, ss@toc@l(6)
; CHECK-NEXT:    lbz 4, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_91: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 5, 0, 11
; CHECK-NEXT:    and 5, 4, 5
; CHECK-NEXT:    sthcx. 5, 0, 11
; CHECK-NEXT:    bne 0, .LBB2_91
; CHECK-NEXT:  # %bb.92: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 5, us@toc@l(8)
; CHECK-NEXT:    lbz 4, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_93: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 5, 0, 0
; CHECK-NEXT:    and 5, 4, 5
; CHECK-NEXT:    stwcx. 5, 0, 0
; CHECK-NEXT:    bne 0, .LBB2_93
; CHECK-NEXT:  # %bb.94: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 5, si@toc@l(10)
; CHECK-NEXT:    lbz 4, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_95: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 5, 0, 29
; CHECK-NEXT:    and 5, 4, 5
; CHECK-NEXT:    stwcx. 5, 0, 29
; CHECK-NEXT:    bne 0, .LBB2_95
; CHECK-NEXT:  # %bb.96: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 5, ui@toc@l(12)
; CHECK-NEXT:    lbz 4, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_97: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 5, 0, 27
; CHECK-NEXT:    and 5, 4, 5
; CHECK-NEXT:    stdcx. 5, 0, 27
; CHECK-NEXT:    bne 0, .LBB2_97
; CHECK-NEXT:  # %bb.98: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 5, sll@toc@l(30)
; CHECK-NEXT:    lbz 3, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB2_99: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 4, 0, 26
; CHECK-NEXT:    and 4, 3, 4
; CHECK-NEXT:    stdcx. 4, 0, 26
; CHECK-NEXT:    bne 0, .LBB2_99
; CHECK-NEXT:  # %bb.100: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 4, ull@toc@l(28)
; CHECK-NEXT:    ld 30, -16(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 29, -24(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 28, -32(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 27, -40(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 26, -48(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 25, -56(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 24, -64(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 23, -72(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 22, -80(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 21, -88(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 20, -96(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 19, -104(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 18, -112(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 17, -120(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 16, -128(1) # 8-byte Folded Reload
; CHECK-NEXT:    blr
;
; AIX32-LABEL: test_op_and_fetch:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    mflr 0
; AIX32-NEXT:    stwu 1, -176(1)
; AIX32-NEXT:    stw 0, 184(1)
; AIX32-NEXT:    stw 27, 156(1) # 4-byte Folded Spill
; AIX32-NEXT:    lwz 27, L..C0(2) # @sc
; AIX32-NEXT:    stw 26, 152(1) # 4-byte Folded Spill
; AIX32-NEXT:    lwz 26, L..C1(2) # @uc
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    rlwinm 4, 27, 3, 27, 28
; AIX32-NEXT:    stw 24, 144(1) # 4-byte Folded Spill
; AIX32-NEXT:    li 5, 255
; AIX32-NEXT:    stw 13, 100(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 14, 104(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 15, 108(1) # 4-byte Folded Spill
; AIX32-NEXT:    xori 24, 4, 24
; AIX32-NEXT:    stw 16, 112(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 17, 116(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 18, 120(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 19, 124(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 20, 128(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 21, 132(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 22, 136(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 23, 140(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 25, 148(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 28, 160(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 29, 164(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 30, 168(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 31, 172(1) # 4-byte Folded Spill
; AIX32-NEXT:    li 17, -1
; AIX32-NEXT:    sync
; AIX32-NEXT:    rlwinm 22, 27, 0, 0, 29
; AIX32-NEXT:    slw 4, 3, 24
; AIX32-NEXT:    slw 5, 5, 24
; AIX32-NEXT:  L..BB2_1: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 22
; AIX32-NEXT:    add 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 22
; AIX32-NEXT:    bne 0, L..BB2_1
; AIX32-NEXT:  # %bb.2: # %entry
; AIX32-NEXT:    srw 4, 6, 24
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 5, 255
; AIX32-NEXT:    rlwinm 19, 26, 0, 0, 29
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    add 3, 4, 3
; AIX32-NEXT:    rlwinm 4, 26, 3, 27, 28
; AIX32-NEXT:    stb 3, 0(27)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    xori 21, 4, 24
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 5, 5, 21
; AIX32-NEXT:    slw 4, 3, 21
; AIX32-NEXT:  L..BB2_3: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 19
; AIX32-NEXT:    add 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 19
; AIX32-NEXT:    bne 0, L..BB2_3
; AIX32-NEXT:  # %bb.4: # %entry
; AIX32-NEXT:    srw 4, 6, 21
; AIX32-NEXT:    lwz 23, L..C2(2) # @ss
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    rlwinm 16, 23, 0, 0, 29
; AIX32-NEXT:    add 3, 4, 3
; AIX32-NEXT:    rlwinm 4, 23, 3, 27, 27
; AIX32-NEXT:    xori 18, 4, 16
; AIX32-NEXT:    stb 3, 0(26)
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 18
; AIX32-NEXT:    slw 5, 5, 18
; AIX32-NEXT:  L..BB2_5: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 16
; AIX32-NEXT:    add 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 16
; AIX32-NEXT:    bne 0, L..BB2_5
; AIX32-NEXT:  # %bb.6: # %entry
; AIX32-NEXT:    srw 4, 6, 18
; AIX32-NEXT:    lwz 20, L..C3(2) # @us
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    rlwinm 14, 20, 0, 0, 29
; AIX32-NEXT:    add 3, 4, 3
; AIX32-NEXT:    rlwinm 4, 20, 3, 27, 27
; AIX32-NEXT:    xori 15, 4, 16
; AIX32-NEXT:    sth 3, 0(23)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 5, 5, 15
; AIX32-NEXT:    slw 4, 3, 15
; AIX32-NEXT:  L..BB2_7: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 14
; AIX32-NEXT:    add 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 14
; AIX32-NEXT:    bne 0, L..BB2_7
; AIX32-NEXT:  # %bb.8: # %entry
; AIX32-NEXT:    srw 4, 6, 15
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lwz 13, L..C4(2) # @si
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    add 3, 4, 3
; AIX32-NEXT:    sth 3, 0(20)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB2_9: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 13
; AIX32-NEXT:    add 4, 3, 4
; AIX32-NEXT:    stwcx. 4, 0, 13
; AIX32-NEXT:    bne 0, L..BB2_9
; AIX32-NEXT:  # %bb.10: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 4, 0(13)
; AIX32-NEXT:    lwz 25, L..C5(2) # @ui
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB2_11: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    add 4, 3, 4
; AIX32-NEXT:    stwcx. 4, 0, 25
; AIX32-NEXT:    bne 0, L..BB2_11
; AIX32-NEXT:  # %bb.12: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lwz 31, L..C6(2) # @sll
; AIX32-NEXT:    stw 4, 0(25)
; AIX32-NEXT:    lbz 30, 0(26)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    li 28, 0
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    mr 5, 30
; AIX32-NEXT:    bl .__atomic_fetch_add_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    addc 4, 4, 30
; AIX32-NEXT:    lbz 29, 0(26)
; AIX32-NEXT:    lwz 30, L..C7(2) # @ull
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    addze 3, 3
; AIX32-NEXT:    stw 4, 4(31)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    stw 3, 0(31)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    mr 5, 29
; AIX32-NEXT:    bl .__atomic_fetch_add_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    addc 4, 4, 29
; AIX32-NEXT:    li 5, 255
; AIX32-NEXT:    addze 3, 3
; AIX32-NEXT:    stw 3, 0(30)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    slw 5, 5, 24
; AIX32-NEXT:    stw 4, 4(30)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 24
; AIX32-NEXT:  L..BB2_13: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 22
; AIX32-NEXT:    sub 7, 6, 4
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 22
; AIX32-NEXT:    bne 0, L..BB2_13
; AIX32-NEXT:  # %bb.14: # %entry
; AIX32-NEXT:    srw 4, 6, 24
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 5, 255
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    slw 5, 5, 21
; AIX32-NEXT:    sub 3, 4, 3
; AIX32-NEXT:    stb 3, 0(27)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 21
; AIX32-NEXT:  L..BB2_15: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 19
; AIX32-NEXT:    sub 7, 6, 4
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 19
; AIX32-NEXT:    bne 0, L..BB2_15
; AIX32-NEXT:  # %bb.16: # %entry
; AIX32-NEXT:    srw 4, 6, 21
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    sub 3, 4, 3
; AIX32-NEXT:    slw 5, 5, 18
; AIX32-NEXT:    stb 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    slw 4, 3, 18
; AIX32-NEXT:  L..BB2_17: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 16
; AIX32-NEXT:    sub 7, 6, 4
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 16
; AIX32-NEXT:    bne 0, L..BB2_17
; AIX32-NEXT:  # %bb.18: # %entry
; AIX32-NEXT:    srw 4, 6, 18
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    sub 3, 4, 3
; AIX32-NEXT:    slw 5, 5, 15
; AIX32-NEXT:    sth 3, 0(23)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 15
; AIX32-NEXT:  L..BB2_19: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 14
; AIX32-NEXT:    sub 7, 6, 4
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 14
; AIX32-NEXT:    bne 0, L..BB2_19
; AIX32-NEXT:  # %bb.20: # %entry
; AIX32-NEXT:    srw 4, 6, 15
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    sub 3, 4, 3
; AIX32-NEXT:    sth 3, 0(20)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB2_21: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 13
; AIX32-NEXT:    sub 4, 4, 3
; AIX32-NEXT:    stwcx. 4, 0, 13
; AIX32-NEXT:    bne 0, L..BB2_21
; AIX32-NEXT:  # %bb.22: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 4, 0(13)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB2_23: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    sub 4, 4, 3
; AIX32-NEXT:    stwcx. 4, 0, 25
; AIX32-NEXT:    bne 0, L..BB2_23
; AIX32-NEXT:  # %bb.24: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 4, 0(25)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    lbz 29, 0(26)
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    mr 5, 29
; AIX32-NEXT:    bl .__atomic_fetch_sub_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    subc 4, 4, 29
; AIX32-NEXT:    lbz 29, 0(26)
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    mr 5, 29
; AIX32-NEXT:    subfe 3, 28, 3
; AIX32-NEXT:    stw 4, 4(31)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    stw 3, 0(31)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    bl .__atomic_fetch_sub_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    subc 4, 4, 29
; AIX32-NEXT:    li 5, 255
; AIX32-NEXT:    subfe 3, 28, 3
; AIX32-NEXT:    stw 4, 4(30)
; AIX32-NEXT:    slw 5, 5, 24
; AIX32-NEXT:    stw 3, 0(30)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 24
; AIX32-NEXT:  L..BB2_25: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 22
; AIX32-NEXT:    or 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 22
; AIX32-NEXT:    bne 0, L..BB2_25
; AIX32-NEXT:  # %bb.26: # %entry
; AIX32-NEXT:    srw 4, 6, 24
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 5, 255
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    slw 5, 5, 21
; AIX32-NEXT:    or 3, 4, 3
; AIX32-NEXT:    stb 3, 0(27)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 21
; AIX32-NEXT:  L..BB2_27: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 19
; AIX32-NEXT:    or 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 19
; AIX32-NEXT:    bne 0, L..BB2_27
; AIX32-NEXT:  # %bb.28: # %entry
; AIX32-NEXT:    srw 4, 6, 21
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    or 3, 4, 3
; AIX32-NEXT:    slw 5, 5, 18
; AIX32-NEXT:    stb 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    slw 4, 3, 18
; AIX32-NEXT:  L..BB2_29: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 16
; AIX32-NEXT:    or 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 16
; AIX32-NEXT:    bne 0, L..BB2_29
; AIX32-NEXT:  # %bb.30: # %entry
; AIX32-NEXT:    srw 4, 6, 18
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    or 3, 4, 3
; AIX32-NEXT:    slw 5, 5, 15
; AIX32-NEXT:    sth 3, 0(23)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 15
; AIX32-NEXT:  L..BB2_31: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 14
; AIX32-NEXT:    or 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 14
; AIX32-NEXT:    bne 0, L..BB2_31
; AIX32-NEXT:  # %bb.32: # %entry
; AIX32-NEXT:    srw 4, 6, 15
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    or 3, 4, 3
; AIX32-NEXT:    sth 3, 0(20)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB2_33: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 13
; AIX32-NEXT:    or 4, 3, 4
; AIX32-NEXT:    stwcx. 4, 0, 13
; AIX32-NEXT:    bne 0, L..BB2_33
; AIX32-NEXT:  # %bb.34: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 4, 0(13)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB2_35: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    or 4, 3, 4
; AIX32-NEXT:    stwcx. 4, 0, 25
; AIX32-NEXT:    bne 0, L..BB2_35
; AIX32-NEXT:  # %bb.36: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 4, 0(25)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    lbz 29, 0(26)
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    mr 5, 29
; AIX32-NEXT:    bl .__atomic_fetch_or_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    or 4, 4, 29
; AIX32-NEXT:    lbz 29, 0(26)
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    mr 5, 29
; AIX32-NEXT:    stw 4, 4(31)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    stw 3, 0(31)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    bl .__atomic_fetch_or_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 3, 0(30)
; AIX32-NEXT:    or 3, 4, 29
; AIX32-NEXT:    li 5, 255
; AIX32-NEXT:    stw 3, 4(30)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 5, 5, 24
; AIX32-NEXT:    slw 4, 3, 24
; AIX32-NEXT:  L..BB2_37: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 22
; AIX32-NEXT:    xor 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 22
; AIX32-NEXT:    bne 0, L..BB2_37
; AIX32-NEXT:  # %bb.38: # %entry
; AIX32-NEXT:    srw 4, 6, 24
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 5, 255
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    slw 5, 5, 21
; AIX32-NEXT:    xor 3, 4, 3
; AIX32-NEXT:    stb 3, 0(27)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 21
; AIX32-NEXT:  L..BB2_39: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 19
; AIX32-NEXT:    xor 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 19
; AIX32-NEXT:    bne 0, L..BB2_39
; AIX32-NEXT:  # %bb.40: # %entry
; AIX32-NEXT:    srw 4, 6, 21
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    xor 3, 4, 3
; AIX32-NEXT:    slw 5, 5, 18
; AIX32-NEXT:    stb 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    slw 4, 3, 18
; AIX32-NEXT:  L..BB2_41: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 16
; AIX32-NEXT:    xor 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 16
; AIX32-NEXT:    bne 0, L..BB2_41
; AIX32-NEXT:  # %bb.42: # %entry
; AIX32-NEXT:    srw 4, 6, 18
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    xor 3, 4, 3
; AIX32-NEXT:    slw 5, 5, 15
; AIX32-NEXT:    sth 3, 0(23)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 15
; AIX32-NEXT:  L..BB2_43: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 14
; AIX32-NEXT:    xor 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 14
; AIX32-NEXT:    bne 0, L..BB2_43
; AIX32-NEXT:  # %bb.44: # %entry
; AIX32-NEXT:    srw 4, 6, 15
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    xor 3, 4, 3
; AIX32-NEXT:    sth 3, 0(20)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB2_45: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 13
; AIX32-NEXT:    xor 4, 3, 4
; AIX32-NEXT:    stwcx. 4, 0, 13
; AIX32-NEXT:    bne 0, L..BB2_45
; AIX32-NEXT:  # %bb.46: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 4, 0(13)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB2_47: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    xor 4, 3, 4
; AIX32-NEXT:    stwcx. 4, 0, 25
; AIX32-NEXT:    bne 0, L..BB2_47
; AIX32-NEXT:  # %bb.48: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 4, 0(25)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    lbz 29, 0(26)
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    mr 5, 29
; AIX32-NEXT:    bl .__atomic_fetch_xor_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    xor 4, 4, 29
; AIX32-NEXT:    lbz 29, 0(26)
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    mr 5, 29
; AIX32-NEXT:    stw 4, 4(31)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    stw 3, 0(31)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    bl .__atomic_fetch_xor_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    xor 4, 4, 29
; AIX32-NEXT:    stw 3, 0(30)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    li 5, 255
; AIX32-NEXT:    stw 4, 4(30)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 24
; AIX32-NEXT:    slw 5, 5, 24
; AIX32-NEXT:  L..BB2_49: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 22
; AIX32-NEXT:    nand 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 22
; AIX32-NEXT:    bne 0, L..BB2_49
; AIX32-NEXT:  # %bb.50: # %entry
; AIX32-NEXT:    srw 4, 6, 24
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 5, 255
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    slw 5, 5, 21
; AIX32-NEXT:    nand 3, 4, 3
; AIX32-NEXT:    stb 3, 0(27)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 21
; AIX32-NEXT:  L..BB2_51: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 19
; AIX32-NEXT:    nand 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 19
; AIX32-NEXT:    bne 0, L..BB2_51
; AIX32-NEXT:  # %bb.52: # %entry
; AIX32-NEXT:    srw 4, 6, 21
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    nand 3, 4, 3
; AIX32-NEXT:    slw 5, 5, 18
; AIX32-NEXT:    stb 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    slw 4, 3, 18
; AIX32-NEXT:  L..BB2_53: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 16
; AIX32-NEXT:    nand 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 16
; AIX32-NEXT:    bne 0, L..BB2_53
; AIX32-NEXT:  # %bb.54: # %entry
; AIX32-NEXT:    srw 4, 6, 18
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    nand 3, 4, 3
; AIX32-NEXT:    slw 5, 5, 15
; AIX32-NEXT:    sth 3, 0(23)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 15
; AIX32-NEXT:  L..BB2_55: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 14
; AIX32-NEXT:    nand 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 14
; AIX32-NEXT:    bne 0, L..BB2_55
; AIX32-NEXT:  # %bb.56: # %entry
; AIX32-NEXT:    srw 4, 6, 15
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    nand 3, 4, 3
; AIX32-NEXT:    sth 3, 0(20)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB2_57: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 13
; AIX32-NEXT:    nand 4, 3, 4
; AIX32-NEXT:    stwcx. 4, 0, 13
; AIX32-NEXT:    bne 0, L..BB2_57
; AIX32-NEXT:  # %bb.58: # %entry
; AIX32-NEXT:    stw 23, 56(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 27, 60(1) # 4-byte Folded Spill
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 4, 0(13)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB2_59: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    nand 4, 3, 4
; AIX32-NEXT:    stwcx. 4, 0, 25
; AIX32-NEXT:    bne 0, L..BB2_59
; AIX32-NEXT:  # %bb.60: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 4, 0(25)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    lbz 29, 0(26)
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    mr 5, 29
; AIX32-NEXT:    bl .__atomic_fetch_nand_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    nand 3, 4, 29
; AIX32-NEXT:    lbz 29, 0(26)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    mr 5, 29
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 4(31)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    stw 17, 0(31)
; AIX32-NEXT:    bl .__atomic_fetch_nand_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    nand 3, 4, 29
; AIX32-NEXT:    lwz 29, L..C8(2) # @u128
; AIX32-NEXT:    lbz 23, 0(26)
; AIX32-NEXT:    addi 28, 1, 80
; AIX32-NEXT:    addi 27, 1, 64
; AIX32-NEXT:    stw 17, 0(30)
; AIX32-NEXT:    lwz 4, 12(29)
; AIX32-NEXT:    lwz 5, 8(29)
; AIX32-NEXT:    lwz 6, 4(29)
; AIX32-NEXT:    lwz 7, 0(29)
; AIX32-NEXT:    stw 3, 4(30)
; AIX32-NEXT:    .align 4
; AIX32-NEXT:  L..BB2_61: # %atomicrmw.start
; AIX32-NEXT:    #
; AIX32-NEXT:    and 3, 4, 23
; AIX32-NEXT:    stw 7, 80(1)
; AIX32-NEXT:    li 7, 5
; AIX32-NEXT:    li 8, 5
; AIX32-NEXT:    xor 3, 3, 17
; AIX32-NEXT:    stw 6, 84(1)
; AIX32-NEXT:    stw 5, 88(1)
; AIX32-NEXT:    stw 4, 92(1)
; AIX32-NEXT:    mr 4, 29
; AIX32-NEXT:    mr 5, 28
; AIX32-NEXT:    mr 6, 27
; AIX32-NEXT:    stw 3, 76(1)
; AIX32-NEXT:    li 3, 16
; AIX32-NEXT:    stw 17, 72(1)
; AIX32-NEXT:    stw 17, 68(1)
; AIX32-NEXT:    stw 17, 64(1)
; AIX32-NEXT:    bl .__atomic_compare_exchange[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 4, 92(1)
; AIX32-NEXT:    lwz 5, 88(1)
; AIX32-NEXT:    lwz 6, 84(1)
; AIX32-NEXT:    lwz 7, 80(1)
; AIX32-NEXT:    cmplwi 3, 0
; AIX32-NEXT:    beq 0, L..BB2_61
; AIX32-NEXT:  # %bb.62: # %atomicrmw.end
; AIX32-NEXT:    and 3, 4, 23
; AIX32-NEXT:    stw 17, 0(29)
; AIX32-NEXT:    lbz 23, 0(26)
; AIX32-NEXT:    stw 17, 4(29)
; AIX32-NEXT:    stw 17, 8(29)
; AIX32-NEXT:    xor 3, 3, 17
; AIX32-NEXT:    addi 28, 1, 80
; AIX32-NEXT:    addi 27, 1, 64
; AIX32-NEXT:    stw 3, 12(29)
; AIX32-NEXT:    lwz 29, L..C9(2) # @s128
; AIX32-NEXT:    lwz 4, 12(29)
; AIX32-NEXT:    lwz 5, 8(29)
; AIX32-NEXT:    lwz 6, 4(29)
; AIX32-NEXT:    lwz 7, 0(29)
; AIX32-NEXT:    .align 4
; AIX32-NEXT:  L..BB2_63: # %atomicrmw.start2
; AIX32-NEXT:    #
; AIX32-NEXT:    and 3, 4, 23
; AIX32-NEXT:    stw 7, 80(1)
; AIX32-NEXT:    li 7, 5
; AIX32-NEXT:    li 8, 5
; AIX32-NEXT:    xor 3, 3, 17
; AIX32-NEXT:    stw 6, 84(1)
; AIX32-NEXT:    stw 5, 88(1)
; AIX32-NEXT:    stw 4, 92(1)
; AIX32-NEXT:    mr 4, 29
; AIX32-NEXT:    mr 5, 28
; AIX32-NEXT:    mr 6, 27
; AIX32-NEXT:    stw 3, 76(1)
; AIX32-NEXT:    li 3, 16
; AIX32-NEXT:    stw 17, 72(1)
; AIX32-NEXT:    stw 17, 68(1)
; AIX32-NEXT:    stw 17, 64(1)
; AIX32-NEXT:    bl .__atomic_compare_exchange[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 4, 92(1)
; AIX32-NEXT:    lwz 5, 88(1)
; AIX32-NEXT:    lwz 6, 84(1)
; AIX32-NEXT:    lwz 7, 80(1)
; AIX32-NEXT:    cmplwi 3, 0
; AIX32-NEXT:    beq 0, L..BB2_63
; AIX32-NEXT:  # %bb.64: # %atomicrmw.end1
; AIX32-NEXT:    and 3, 4, 23
; AIX32-NEXT:    li 5, 255
; AIX32-NEXT:    xor 3, 3, 17
; AIX32-NEXT:    stw 17, 0(29)
; AIX32-NEXT:    stw 17, 4(29)
; AIX32-NEXT:    stw 17, 8(29)
; AIX32-NEXT:    slw 5, 5, 24
; AIX32-NEXT:    stw 3, 12(29)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 24
; AIX32-NEXT:  L..BB2_65: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 22
; AIX32-NEXT:    and 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 22
; AIX32-NEXT:    bne 0, L..BB2_65
; AIX32-NEXT:  # %bb.66: # %atomicrmw.end1
; AIX32-NEXT:    srw 4, 6, 24
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 5, 255
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    slw 5, 5, 21
; AIX32-NEXT:    and 3, 4, 3
; AIX32-NEXT:    lwz 4, 60(1) # 4-byte Folded Reload
; AIX32-NEXT:    stb 3, 0(4)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    lwz 9, 56(1) # 4-byte Folded Reload
; AIX32-NEXT:    slw 4, 3, 21
; AIX32-NEXT:  L..BB2_67: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 19
; AIX32-NEXT:    and 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 19
; AIX32-NEXT:    bne 0, L..BB2_67
; AIX32-NEXT:  # %bb.68: # %atomicrmw.end1
; AIX32-NEXT:    srw 4, 6, 21
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    and 3, 4, 3
; AIX32-NEXT:    slw 5, 5, 18
; AIX32-NEXT:    stb 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 18
; AIX32-NEXT:  L..BB2_69: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 16
; AIX32-NEXT:    and 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 16
; AIX32-NEXT:    bne 0, L..BB2_69
; AIX32-NEXT:  # %bb.70: # %atomicrmw.end1
; AIX32-NEXT:    srw 4, 6, 18
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    and 3, 4, 3
; AIX32-NEXT:    slw 5, 5, 15
; AIX32-NEXT:    sth 3, 0(9)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 4, 3, 15
; AIX32-NEXT:  L..BB2_71: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 14
; AIX32-NEXT:    and 7, 4, 6
; AIX32-NEXT:    andc 8, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:    or 7, 7, 8
; AIX32-NEXT:    stwcx. 7, 0, 14
; AIX32-NEXT:    bne 0, L..BB2_71
; AIX32-NEXT:  # %bb.72: # %atomicrmw.end1
; AIX32-NEXT:    srw 4, 6, 15
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    and 3, 4, 3
; AIX32-NEXT:    sth 3, 0(20)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB2_73: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 13
; AIX32-NEXT:    and 4, 3, 4
; AIX32-NEXT:    stwcx. 4, 0, 13
; AIX32-NEXT:    bne 0, L..BB2_73
; AIX32-NEXT:  # %bb.74: # %atomicrmw.end1
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 4, 0(13)
; AIX32-NEXT:    lbz 3, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB2_75: # %atomicrmw.end1
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    and 4, 3, 4
; AIX32-NEXT:    stwcx. 4, 0, 25
; AIX32-NEXT:    bne 0, L..BB2_75
; AIX32-NEXT:  # %bb.76: # %atomicrmw.end1
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 4, 0(25)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    lbz 29, 0(26)
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    li 28, 0
; AIX32-NEXT:    mr 5, 29
; AIX32-NEXT:    bl .__atomic_fetch_and_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    and 3, 4, 29
; AIX32-NEXT:    stw 28, 0(31)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 4(31)
; AIX32-NEXT:    lbz 31, 0(26)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    mr 5, 31
; AIX32-NEXT:    bl .__atomic_fetch_and_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    and 3, 4, 31
; AIX32-NEXT:    stw 28, 0(30)
; AIX32-NEXT:    lwz 31, 172(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 29, 164(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 28, 160(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 27, 156(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 26, 152(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 25, 148(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 24, 144(1) # 4-byte Folded Reload
; AIX32-NEXT:    stw 3, 4(30)
; AIX32-NEXT:    lwz 30, 168(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 23, 140(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 22, 136(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 21, 132(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 20, 128(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 19, 124(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 18, 120(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 17, 116(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 16, 112(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 15, 108(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 14, 104(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 13, 100(1) # 4-byte Folded Reload
; AIX32-NEXT:    addi 1, 1, 176
; AIX32-NEXT:    lwz 0, 8(1)
; AIX32-NEXT:    mtlr 0
; AIX32-NEXT:    blr
entry:
  %0 = load i8, ptr @uc, align 1
  %1 = atomicrmw add ptr @sc, i8 %0 seq_cst, align 1
  %2 = add i8 %1, %0
  store i8 %2, ptr @sc, align 1
  %3 = load i8, ptr @uc, align 1
  %4 = atomicrmw add ptr @uc, i8 %3 seq_cst, align 1
  %5 = add i8 %4, %3
  store i8 %5, ptr @uc, align 1
  %conv = zext i8 %5 to i16
  %6 = atomicrmw add ptr @ss, i16 %conv seq_cst, align 2
  %7 = add i16 %6, %conv
  store i16 %7, ptr @ss, align 2
  %8 = load i8, ptr @uc, align 1
  %conv1 = zext i8 %8 to i16
  %9 = atomicrmw add ptr @us, i16 %conv1 seq_cst, align 2
  %10 = add i16 %9, %conv1
  store i16 %10, ptr @us, align 2
  %11 = load i8, ptr @uc, align 1
  %conv2 = zext i8 %11 to i32
  %12 = atomicrmw add ptr @si, i32 %conv2 seq_cst, align 4
  %13 = add i32 %12, %conv2
  store i32 %13, ptr @si, align 4
  %14 = load i8, ptr @uc, align 1
  %conv3 = zext i8 %14 to i32
  %15 = atomicrmw add ptr @ui, i32 %conv3 seq_cst, align 4
  %16 = add i32 %15, %conv3
  store i32 %16, ptr @ui, align 4
  %17 = load i8, ptr @uc, align 1
  %conv4 = zext i8 %17 to i64
  %18 = atomicrmw add ptr @sll, i64 %conv4 seq_cst, align 8
  %19 = add i64 %18, %conv4
  store i64 %19, ptr @sll, align 8
  %20 = load i8, ptr @uc, align 1
  %conv5 = zext i8 %20 to i64
  %21 = atomicrmw add ptr @ull, i64 %conv5 seq_cst, align 8
  %22 = add i64 %21, %conv5
  store i64 %22, ptr @ull, align 8
  %23 = load i8, ptr @uc, align 1
  %24 = atomicrmw sub ptr @sc, i8 %23 seq_cst, align 1
  %25 = sub i8 %24, %23
  store i8 %25, ptr @sc, align 1
  %26 = load i8, ptr @uc, align 1
  %27 = atomicrmw sub ptr @uc, i8 %26 seq_cst, align 1
  %28 = sub i8 %27, %26
  store i8 %28, ptr @uc, align 1
  %conv6 = zext i8 %28 to i16
  %29 = atomicrmw sub ptr @ss, i16 %conv6 seq_cst, align 2
  %30 = sub i16 %29, %conv6
  store i16 %30, ptr @ss, align 2
  %31 = load i8, ptr @uc, align 1
  %conv7 = zext i8 %31 to i16
  %32 = atomicrmw sub ptr @us, i16 %conv7 seq_cst, align 2
  %33 = sub i16 %32, %conv7
  store i16 %33, ptr @us, align 2
  %34 = load i8, ptr @uc, align 1
  %conv8 = zext i8 %34 to i32
  %35 = atomicrmw sub ptr @si, i32 %conv8 seq_cst, align 4
  %36 = sub i32 %35, %conv8
  store i32 %36, ptr @si, align 4
  %37 = load i8, ptr @uc, align 1
  %conv9 = zext i8 %37 to i32
  %38 = atomicrmw sub ptr @ui, i32 %conv9 seq_cst, align 4
  %39 = sub i32 %38, %conv9
  store i32 %39, ptr @ui, align 4
  %40 = load i8, ptr @uc, align 1
  %conv10 = zext i8 %40 to i64
  %41 = atomicrmw sub ptr @sll, i64 %conv10 seq_cst, align 8
  %42 = sub i64 %41, %conv10
  store i64 %42, ptr @sll, align 8
  %43 = load i8, ptr @uc, align 1
  %conv11 = zext i8 %43 to i64
  %44 = atomicrmw sub ptr @ull, i64 %conv11 seq_cst, align 8
  %45 = sub i64 %44, %conv11
  store i64 %45, ptr @ull, align 8
  %46 = load i8, ptr @uc, align 1
  %47 = atomicrmw or ptr @sc, i8 %46 seq_cst, align 1
  %48 = or i8 %47, %46
  store i8 %48, ptr @sc, align 1
  %49 = load i8, ptr @uc, align 1
  %50 = atomicrmw or ptr @uc, i8 %49 seq_cst, align 1
  %51 = or i8 %50, %49
  store i8 %51, ptr @uc, align 1
  %conv12 = zext i8 %51 to i16
  %52 = atomicrmw or ptr @ss, i16 %conv12 seq_cst, align 2
  %53 = or i16 %52, %conv12
  store i16 %53, ptr @ss, align 2
  %54 = load i8, ptr @uc, align 1
  %conv13 = zext i8 %54 to i16
  %55 = atomicrmw or ptr @us, i16 %conv13 seq_cst, align 2
  %56 = or i16 %55, %conv13
  store i16 %56, ptr @us, align 2
  %57 = load i8, ptr @uc, align 1
  %conv14 = zext i8 %57 to i32
  %58 = atomicrmw or ptr @si, i32 %conv14 seq_cst, align 4
  %59 = or i32 %58, %conv14
  store i32 %59, ptr @si, align 4
  %60 = load i8, ptr @uc, align 1
  %conv15 = zext i8 %60 to i32
  %61 = atomicrmw or ptr @ui, i32 %conv15 seq_cst, align 4
  %62 = or i32 %61, %conv15
  store i32 %62, ptr @ui, align 4
  %63 = load i8, ptr @uc, align 1
  %conv16 = zext i8 %63 to i64
  %64 = atomicrmw or ptr @sll, i64 %conv16 seq_cst, align 8
  %65 = or i64 %64, %conv16
  store i64 %65, ptr @sll, align 8
  %66 = load i8, ptr @uc, align 1
  %conv17 = zext i8 %66 to i64
  %67 = atomicrmw or ptr @ull, i64 %conv17 seq_cst, align 8
  %68 = or i64 %67, %conv17
  store i64 %68, ptr @ull, align 8
  %69 = load i8, ptr @uc, align 1
  %70 = atomicrmw xor ptr @sc, i8 %69 seq_cst, align 1
  %71 = xor i8 %70, %69
  store i8 %71, ptr @sc, align 1
  %72 = load i8, ptr @uc, align 1
  %73 = atomicrmw xor ptr @uc, i8 %72 seq_cst, align 1
  %74 = xor i8 %73, %72
  store i8 %74, ptr @uc, align 1
  %conv18 = zext i8 %74 to i16
  %75 = atomicrmw xor ptr @ss, i16 %conv18 seq_cst, align 2
  %76 = xor i16 %75, %conv18
  store i16 %76, ptr @ss, align 2
  %77 = load i8, ptr @uc, align 1
  %conv19 = zext i8 %77 to i16
  %78 = atomicrmw xor ptr @us, i16 %conv19 seq_cst, align 2
  %79 = xor i16 %78, %conv19
  store i16 %79, ptr @us, align 2
  %80 = load i8, ptr @uc, align 1
  %conv20 = zext i8 %80 to i32
  %81 = atomicrmw xor ptr @si, i32 %conv20 seq_cst, align 4
  %82 = xor i32 %81, %conv20
  store i32 %82, ptr @si, align 4
  %83 = load i8, ptr @uc, align 1
  %conv21 = zext i8 %83 to i32
  %84 = atomicrmw xor ptr @ui, i32 %conv21 seq_cst, align 4
  %85 = xor i32 %84, %conv21
  store i32 %85, ptr @ui, align 4
  %86 = load i8, ptr @uc, align 1
  %conv22 = zext i8 %86 to i64
  %87 = atomicrmw xor ptr @sll, i64 %conv22 seq_cst, align 8
  %88 = xor i64 %87, %conv22
  store i64 %88, ptr @sll, align 8
  %89 = load i8, ptr @uc, align 1
  %conv23 = zext i8 %89 to i64
  %90 = atomicrmw xor ptr @ull, i64 %conv23 seq_cst, align 8
  %91 = xor i64 %90, %conv23
  store i64 %91, ptr @ull, align 8
  %92 = load i8, ptr @uc, align 1
  %93 = atomicrmw nand ptr @sc, i8 %92 seq_cst, align 1
  %94 = and i8 %93, %92
  %95 = xor i8 %94, -1
  store i8 %95, ptr @sc, align 1
  %96 = load i8, ptr @uc, align 1
  %97 = atomicrmw nand ptr @uc, i8 %96 seq_cst, align 1
  %98 = and i8 %97, %96
  %99 = xor i8 %98, -1
  store i8 %99, ptr @uc, align 1
  %conv24 = zext i8 %99 to i16
  %100 = atomicrmw nand ptr @ss, i16 %conv24 seq_cst, align 2
  %101 = and i16 %100, %conv24
  %102 = xor i16 %101, -1
  store i16 %102, ptr @ss, align 2
  %103 = load i8, ptr @uc, align 1
  %conv25 = zext i8 %103 to i16
  %104 = atomicrmw nand ptr @us, i16 %conv25 seq_cst, align 2
  %105 = and i16 %104, %conv25
  %106 = xor i16 %105, -1
  store i16 %106, ptr @us, align 2
  %107 = load i8, ptr @uc, align 1
  %conv26 = zext i8 %107 to i32
  %108 = atomicrmw nand ptr @si, i32 %conv26 seq_cst, align 4
  %109 = and i32 %108, %conv26
  %110 = xor i32 %109, -1
  store i32 %110, ptr @si, align 4
  %111 = load i8, ptr @uc, align 1
  %conv27 = zext i8 %111 to i32
  %112 = atomicrmw nand ptr @ui, i32 %conv27 seq_cst, align 4
  %113 = and i32 %112, %conv27
  %114 = xor i32 %113, -1
  store i32 %114, ptr @ui, align 4
  %115 = load i8, ptr @uc, align 1
  %conv28 = zext i8 %115 to i64
  %116 = atomicrmw nand ptr @sll, i64 %conv28 seq_cst, align 8
  %117 = and i64 %116, %conv28
  %118 = xor i64 %117, -1
  store i64 %118, ptr @sll, align 8
  %119 = load i8, ptr @uc, align 1
  %conv29 = zext i8 %119 to i64
  %120 = atomicrmw nand ptr @ull, i64 %conv29 seq_cst, align 8
  %121 = and i64 %120, %conv29
  %122 = xor i64 %121, -1
  store i64 %122, ptr @ull, align 8
  %123 = load i8, ptr @uc, align 1
  %conv30 = zext i8 %123 to i128
  %124 = atomicrmw nand ptr @u128, i128 %conv30 seq_cst, align 16
  %125 = and i128 %124, %conv30
  %126 = xor i128 %125, -1
  store i128 %126, ptr @u128, align 16
  %127 = load i8, ptr @uc, align 1
  %conv31 = zext i8 %127 to i128
  %128 = atomicrmw nand ptr @s128, i128 %conv31 seq_cst, align 16
  %129 = and i128 %128, %conv31
  %130 = xor i128 %129, -1
  store i128 %130, ptr @s128, align 16
  %131 = load i8, ptr @uc, align 1
  %132 = atomicrmw and ptr @sc, i8 %131 seq_cst, align 1
  %133 = and i8 %132, %131
  store i8 %133, ptr @sc, align 1
  %134 = load i8, ptr @uc, align 1
  %135 = atomicrmw and ptr @uc, i8 %134 seq_cst, align 1
  %136 = and i8 %135, %134
  store i8 %136, ptr @uc, align 1
  %conv32 = zext i8 %136 to i16
  %137 = atomicrmw and ptr @ss, i16 %conv32 seq_cst, align 2
  %138 = and i16 %137, %conv32
  store i16 %138, ptr @ss, align 2
  %139 = load i8, ptr @uc, align 1
  %conv33 = zext i8 %139 to i16
  %140 = atomicrmw and ptr @us, i16 %conv33 seq_cst, align 2
  %141 = and i16 %140, %conv33
  store i16 %141, ptr @us, align 2
  %142 = load i8, ptr @uc, align 1
  %conv34 = zext i8 %142 to i32
  %143 = atomicrmw and ptr @si, i32 %conv34 seq_cst, align 4
  %144 = and i32 %143, %conv34
  store i32 %144, ptr @si, align 4
  %145 = load i8, ptr @uc, align 1
  %conv35 = zext i8 %145 to i32
  %146 = atomicrmw and ptr @ui, i32 %conv35 seq_cst, align 4
  %147 = and i32 %146, %conv35
  store i32 %147, ptr @ui, align 4
  %148 = load i8, ptr @uc, align 1
  %conv36 = zext i8 %148 to i64
  %149 = atomicrmw and ptr @sll, i64 %conv36 seq_cst, align 8
  %150 = and i64 %149, %conv36
  store i64 %150, ptr @sll, align 8
  %151 = load i8, ptr @uc, align 1
  %conv37 = zext i8 %151 to i64
  %152 = atomicrmw and ptr @ull, i64 %conv37 seq_cst, align 8
  %153 = and i64 %152, %conv37
  store i64 %153, ptr @ull, align 8
  ret void
}

define dso_local void @test_compare_and_swap() local_unnamed_addr #0 {
; CHECK-LABEL: test_compare_and_swap:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, uc@toc@ha
; CHECK-NEXT:    addis 4, 2, sc@toc@ha
; CHECK-NEXT:    std 27, -40(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 28, -32(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 29, -24(1) # 8-byte Folded Spill
; CHECK-NEXT:    std 30, -16(1) # 8-byte Folded Spill
; CHECK-NEXT:    lbz 5, uc@toc@l(3)
; CHECK-NEXT:    lbz 8, sc@toc@l(4)
; CHECK-NEXT:    addi 6, 3, uc@toc@l
; CHECK-NEXT:    addi 0, 4, sc@toc@l
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB3_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 7, 0, 0
; CHECK-NEXT:    cmpw 7, 5
; CHECK-NEXT:    bne 0, .LBB3_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stbcx. 8, 0, 0
; CHECK-NEXT:    bne 0, .LBB3_1
; CHECK-NEXT:  .LBB3_3: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 7, sc@toc@l(4)
; CHECK-NEXT:    lbz 8, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB3_4: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 5, 0, 6
; CHECK-NEXT:    cmpw 5, 8
; CHECK-NEXT:    bne 0, .LBB3_6
; CHECK-NEXT:  # %bb.5: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stbcx. 7, 0, 6
; CHECK-NEXT:    bne 0, .LBB3_4
; CHECK-NEXT:  .LBB3_6: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 5, uc@toc@l(3)
; CHECK-NEXT:    lbz 7, sc@toc@l(4)
; CHECK-NEXT:    sync
; CHECK-NEXT:    extsb 8, 7
; CHECK-NEXT:    addis 7, 2, ss@toc@ha
; CHECK-NEXT:    addi 12, 7, ss@toc@l
; CHECK-NEXT:  .LBB3_7: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 9, 0, 12
; CHECK-NEXT:    cmpw 9, 5
; CHECK-NEXT:    bne 0, .LBB3_9
; CHECK-NEXT:  # %bb.8: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    sthcx. 8, 0, 12
; CHECK-NEXT:    bne 0, .LBB3_7
; CHECK-NEXT:  .LBB3_9: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 9, ss@toc@l(7)
; CHECK-NEXT:    lbz 7, sc@toc@l(4)
; CHECK-NEXT:    lbz 5, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:    extsb 8, 7
; CHECK-NEXT:    addis 7, 2, us@toc@ha
; CHECK-NEXT:    addi 11, 7, us@toc@l
; CHECK-NEXT:  .LBB3_10: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 9, 0, 11
; CHECK-NEXT:    cmpw 9, 5
; CHECK-NEXT:    bne 0, .LBB3_12
; CHECK-NEXT:  # %bb.11: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    sthcx. 8, 0, 11
; CHECK-NEXT:    bne 0, .LBB3_10
; CHECK-NEXT:  .LBB3_12: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 9, us@toc@l(7)
; CHECK-NEXT:    lbz 7, sc@toc@l(4)
; CHECK-NEXT:    lbz 5, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:    extsb 8, 7
; CHECK-NEXT:    addis 7, 2, si@toc@ha
; CHECK-NEXT:    addi 10, 7, si@toc@l
; CHECK-NEXT:  .LBB3_13: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 9, 0, 10
; CHECK-NEXT:    cmpw 9, 5
; CHECK-NEXT:    bne 0, .LBB3_15
; CHECK-NEXT:  # %bb.14: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 8, 0, 10
; CHECK-NEXT:    bne 0, .LBB3_13
; CHECK-NEXT:  .LBB3_15: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 9, si@toc@l(7)
; CHECK-NEXT:    lbz 5, sc@toc@l(4)
; CHECK-NEXT:    lbz 7, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:    extsb 8, 5
; CHECK-NEXT:    addis 5, 2, ui@toc@ha
; CHECK-NEXT:    addi 9, 5, ui@toc@l
; CHECK-NEXT:  .LBB3_16: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 30, 0, 9
; CHECK-NEXT:    cmpw 30, 7
; CHECK-NEXT:    bne 0, .LBB3_18
; CHECK-NEXT:  # %bb.17: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 8, 0, 9
; CHECK-NEXT:    bne 0, .LBB3_16
; CHECK-NEXT:  .LBB3_18: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 30, ui@toc@l(5)
; CHECK-NEXT:    addis 30, 2, sll@toc@ha
; CHECK-NEXT:    lbz 8, sc@toc@l(4)
; CHECK-NEXT:    lbz 7, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:    extsb 29, 8
; CHECK-NEXT:    addi 8, 30, sll@toc@l
; CHECK-NEXT:  .LBB3_19: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 28, 0, 8
; CHECK-NEXT:    cmpd 28, 7
; CHECK-NEXT:    bne 0, .LBB3_21
; CHECK-NEXT:  # %bb.20: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stdcx. 29, 0, 8
; CHECK-NEXT:    bne 0, .LBB3_19
; CHECK-NEXT:  .LBB3_21: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    addis 29, 2, ull@toc@ha
; CHECK-NEXT:    std 28, sll@toc@l(30)
; CHECK-NEXT:    lbz 7, sc@toc@l(4)
; CHECK-NEXT:    lbz 30, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:    extsb 28, 7
; CHECK-NEXT:    addi 7, 29, ull@toc@l
; CHECK-NEXT:  .LBB3_22: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 27, 0, 7
; CHECK-NEXT:    cmpd 27, 30
; CHECK-NEXT:    bne 0, .LBB3_24
; CHECK-NEXT:  # %bb.23: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stdcx. 28, 0, 7
; CHECK-NEXT:    bne 0, .LBB3_22
; CHECK-NEXT:  .LBB3_24: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 27, ull@toc@l(29)
; CHECK-NEXT:    lbz 30, uc@toc@l(3)
; CHECK-NEXT:    lbz 29, sc@toc@l(4)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB3_25: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 28, 0, 0
; CHECK-NEXT:    cmpw 28, 30
; CHECK-NEXT:    bne 0, .LBB3_27
; CHECK-NEXT:  # %bb.26: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stbcx. 29, 0, 0
; CHECK-NEXT:    bne 0, .LBB3_25
; CHECK-NEXT:  .LBB3_27: # %entry
; CHECK-NEXT:    xor 0, 28, 30
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    lbz 30, sc@toc@l(4)
; CHECK-NEXT:    cntlzw 0, 0
; CHECK-NEXT:    srwi 0, 0, 5
; CHECK-NEXT:    stw 0, ui@toc@l(5)
; CHECK-NEXT:    lbz 0, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB3_28: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 29, 0, 6
; CHECK-NEXT:    cmpw 29, 0
; CHECK-NEXT:    bne 0, .LBB3_30
; CHECK-NEXT:  # %bb.29: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stbcx. 30, 0, 6
; CHECK-NEXT:    bne 0, .LBB3_28
; CHECK-NEXT:  .LBB3_30: # %entry
; CHECK-NEXT:    xor 6, 29, 0
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    lbz 0, sc@toc@l(4)
; CHECK-NEXT:    cntlzw 6, 6
; CHECK-NEXT:    extsb 0, 0
; CHECK-NEXT:    srwi 6, 6, 5
; CHECK-NEXT:    stw 6, ui@toc@l(5)
; CHECK-NEXT:    lbz 6, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB3_31: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 30, 0, 12
; CHECK-NEXT:    cmpw 30, 6
; CHECK-NEXT:    bne 0, .LBB3_33
; CHECK-NEXT:  # %bb.32: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    sthcx. 0, 0, 12
; CHECK-NEXT:    bne 0, .LBB3_31
; CHECK-NEXT:  .LBB3_33: # %entry
; CHECK-NEXT:    xor 6, 30, 6
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    lbz 12, sc@toc@l(4)
; CHECK-NEXT:    cntlzw 6, 6
; CHECK-NEXT:    extsb 12, 12
; CHECK-NEXT:    srwi 6, 6, 5
; CHECK-NEXT:    stw 6, ui@toc@l(5)
; CHECK-NEXT:    lbz 6, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB3_34: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 0, 0, 11
; CHECK-NEXT:    cmpw 0, 6
; CHECK-NEXT:    bne 0, .LBB3_36
; CHECK-NEXT:  # %bb.35: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    sthcx. 12, 0, 11
; CHECK-NEXT:    bne 0, .LBB3_34
; CHECK-NEXT:  .LBB3_36: # %entry
; CHECK-NEXT:    xor 6, 0, 6
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    lbz 11, sc@toc@l(4)
; CHECK-NEXT:    cntlzw 6, 6
; CHECK-NEXT:    extsb 11, 11
; CHECK-NEXT:    srwi 6, 6, 5
; CHECK-NEXT:    stw 6, ui@toc@l(5)
; CHECK-NEXT:    lbz 6, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB3_37: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 12, 0, 10
; CHECK-NEXT:    cmpw 12, 6
; CHECK-NEXT:    bne 0, .LBB3_39
; CHECK-NEXT:  # %bb.38: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 11, 0, 10
; CHECK-NEXT:    bne 0, .LBB3_37
; CHECK-NEXT:  .LBB3_39: # %entry
; CHECK-NEXT:    xor 6, 12, 6
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    lbz 10, sc@toc@l(4)
; CHECK-NEXT:    cntlzw 6, 6
; CHECK-NEXT:    extsb 10, 10
; CHECK-NEXT:    srwi 6, 6, 5
; CHECK-NEXT:    stw 6, ui@toc@l(5)
; CHECK-NEXT:    lbz 6, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB3_40: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 11, 0, 9
; CHECK-NEXT:    cmpw 11, 6
; CHECK-NEXT:    bne 0, .LBB3_42
; CHECK-NEXT:  # %bb.41: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 10, 0, 9
; CHECK-NEXT:    bne 0, .LBB3_40
; CHECK-NEXT:  .LBB3_42: # %entry
; CHECK-NEXT:    xor 6, 11, 6
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    lbz 9, sc@toc@l(4)
; CHECK-NEXT:    cntlzw 6, 6
; CHECK-NEXT:    extsb 9, 9
; CHECK-NEXT:    srwi 6, 6, 5
; CHECK-NEXT:    stw 6, ui@toc@l(5)
; CHECK-NEXT:    lbz 6, uc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB3_43: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 10, 0, 8
; CHECK-NEXT:    cmpd 10, 6
; CHECK-NEXT:    bne 0, .LBB3_45
; CHECK-NEXT:  # %bb.44: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stdcx. 9, 0, 8
; CHECK-NEXT:    bne 0, .LBB3_43
; CHECK-NEXT:  .LBB3_45: # %entry
; CHECK-NEXT:    xor 6, 10, 6
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    lbz 4, sc@toc@l(4)
; CHECK-NEXT:    lbz 3, uc@toc@l(3)
; CHECK-NEXT:    cntlzd 6, 6
; CHECK-NEXT:    extsb 4, 4
; CHECK-NEXT:    rldicl 6, 6, 58, 63
; CHECK-NEXT:    stw 6, ui@toc@l(5)
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB3_46: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 6, 0, 7
; CHECK-NEXT:    cmpd 6, 3
; CHECK-NEXT:    bne 0, .LBB3_48
; CHECK-NEXT:  # %bb.47: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stdcx. 4, 0, 7
; CHECK-NEXT:    bne 0, .LBB3_46
; CHECK-NEXT:  .LBB3_48: # %entry
; CHECK-NEXT:    xor 3, 6, 3
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    ld 30, -16(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 29, -24(1) # 8-byte Folded Reload
; CHECK-NEXT:    cntlzd 3, 3
; CHECK-NEXT:    ld 28, -32(1) # 8-byte Folded Reload
; CHECK-NEXT:    ld 27, -40(1) # 8-byte Folded Reload
; CHECK-NEXT:    rldicl 3, 3, 58, 63
; CHECK-NEXT:    stw 3, ui@toc@l(5)
; CHECK-NEXT:    blr
;
; AIX32-LABEL: test_compare_and_swap:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    mflr 0
; AIX32-NEXT:    stwu 1, -128(1)
; AIX32-NEXT:    stw 0, 136(1)
; AIX32-NEXT:    stw 28, 112(1) # 4-byte Folded Spill
; AIX32-NEXT:    lwz 28, L..C0(2) # @sc
; AIX32-NEXT:    stw 29, 116(1) # 4-byte Folded Spill
; AIX32-NEXT:    lwz 29, L..C1(2) # @uc
; AIX32-NEXT:    lbz 3, 0(29)
; AIX32-NEXT:    rlwinm 5, 28, 3, 27, 28
; AIX32-NEXT:    stw 21, 84(1) # 4-byte Folded Spill
; AIX32-NEXT:    lbz 4, 0(28)
; AIX32-NEXT:    stw 17, 68(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 18, 72(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 19, 76(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 20, 80(1) # 4-byte Folded Spill
; AIX32-NEXT:    xori 21, 5, 24
; AIX32-NEXT:    stw 22, 88(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 23, 92(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 24, 96(1) # 4-byte Folded Spill
; AIX32-NEXT:    slw 5, 3, 21
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    slw 4, 4, 21
; AIX32-NEXT:    stw 25, 100(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 26, 104(1) # 4-byte Folded Spill
; AIX32-NEXT:    slw 3, 3, 21
; AIX32-NEXT:    stw 27, 108(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 30, 120(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 31, 124(1) # 4-byte Folded Spill
; AIX32-NEXT:    sync
; AIX32-NEXT:    rlwinm 18, 28, 0, 0, 29
; AIX32-NEXT:    and 4, 4, 3
; AIX32-NEXT:    and 5, 5, 3
; AIX32-NEXT:  L..BB3_1: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 7, 0, 18
; AIX32-NEXT:    and 6, 7, 3
; AIX32-NEXT:    cmpw 6, 5
; AIX32-NEXT:    bne 0, L..BB3_3
; AIX32-NEXT:  # %bb.2: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    andc 7, 7, 3
; AIX32-NEXT:    or 7, 7, 4
; AIX32-NEXT:    stwcx. 7, 0, 18
; AIX32-NEXT:    bne 0, L..BB3_1
; AIX32-NEXT:  L..BB3_3: # %entry
; AIX32-NEXT:    rlwinm 5, 29, 3, 27, 28
; AIX32-NEXT:    srw 3, 6, 21
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lbz 4, 0(29)
; AIX32-NEXT:    rlwinm 20, 29, 0, 0, 29
; AIX32-NEXT:    xori 25, 5, 24
; AIX32-NEXT:    slw 5, 3, 25
; AIX32-NEXT:    stb 3, 0(28)
; AIX32-NEXT:    li 3, 255
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 6, 4, 25
; AIX32-NEXT:    slw 3, 3, 25
; AIX32-NEXT:    and 4, 5, 3
; AIX32-NEXT:    and 5, 6, 3
; AIX32-NEXT:  L..BB3_4: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 7, 0, 20
; AIX32-NEXT:    and 6, 7, 3
; AIX32-NEXT:    cmpw 6, 5
; AIX32-NEXT:    bne 0, L..BB3_6
; AIX32-NEXT:  # %bb.5: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    andc 7, 7, 3
; AIX32-NEXT:    or 7, 7, 4
; AIX32-NEXT:    stwcx. 7, 0, 20
; AIX32-NEXT:    bne 0, L..BB3_4
; AIX32-NEXT:  L..BB3_6: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    srw 4, 6, 25
; AIX32-NEXT:    lbz 3, 0(28)
; AIX32-NEXT:    extsb 5, 3
; AIX32-NEXT:    lwz 3, L..C2(2) # @ss
; AIX32-NEXT:    stb 4, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:    rlwinm 6, 3, 3, 27, 27
; AIX32-NEXT:    rlwinm 22, 3, 0, 0, 29
; AIX32-NEXT:    xori 26, 6, 16
; AIX32-NEXT:    slw 6, 4, 26
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    slw 5, 5, 26
; AIX32-NEXT:    ori 4, 4, 65535
; AIX32-NEXT:    slw 4, 4, 26
; AIX32-NEXT:    and 5, 5, 4
; AIX32-NEXT:    and 6, 6, 4
; AIX32-NEXT:  L..BB3_7: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 8, 0, 22
; AIX32-NEXT:    and 7, 8, 4
; AIX32-NEXT:    cmpw 7, 6
; AIX32-NEXT:    bne 0, L..BB3_9
; AIX32-NEXT:  # %bb.8: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    andc 8, 8, 4
; AIX32-NEXT:    or 8, 8, 5
; AIX32-NEXT:    stwcx. 8, 0, 22
; AIX32-NEXT:    bne 0, L..BB3_7
; AIX32-NEXT:  L..BB3_9: # %entry
; AIX32-NEXT:    srw 4, 7, 26
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sth 4, 0(3)
; AIX32-NEXT:    lbz 3, 0(28)
; AIX32-NEXT:    lbz 4, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:    extsb 5, 3
; AIX32-NEXT:    lwz 3, L..C3(2) # @us
; AIX32-NEXT:    rlwinm 6, 3, 3, 27, 27
; AIX32-NEXT:    rlwinm 19, 3, 0, 0, 29
; AIX32-NEXT:    xori 24, 6, 16
; AIX32-NEXT:    slw 6, 4, 24
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    slw 5, 5, 24
; AIX32-NEXT:    ori 4, 4, 65535
; AIX32-NEXT:    slw 4, 4, 24
; AIX32-NEXT:    and 5, 5, 4
; AIX32-NEXT:    and 6, 6, 4
; AIX32-NEXT:  L..BB3_10: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 8, 0, 19
; AIX32-NEXT:    and 7, 8, 4
; AIX32-NEXT:    cmpw 7, 6
; AIX32-NEXT:    bne 0, L..BB3_12
; AIX32-NEXT:  # %bb.11: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    andc 8, 8, 4
; AIX32-NEXT:    or 8, 8, 5
; AIX32-NEXT:    stwcx. 8, 0, 19
; AIX32-NEXT:    bne 0, L..BB3_10
; AIX32-NEXT:  L..BB3_12: # %entry
; AIX32-NEXT:    srw 4, 7, 24
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lwz 17, L..C4(2) # @si
; AIX32-NEXT:    sth 4, 0(3)
; AIX32-NEXT:    lbz 4, 0(28)
; AIX32-NEXT:    lbz 3, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:    extsb 4, 4
; AIX32-NEXT:  L..BB3_13: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 5, 0, 17
; AIX32-NEXT:    cmpw 5, 3
; AIX32-NEXT:    bne 0, L..BB3_15
; AIX32-NEXT:  # %bb.14: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    stwcx. 4, 0, 17
; AIX32-NEXT:    bne 0, L..BB3_13
; AIX32-NEXT:  L..BB3_15: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 5, 0(17)
; AIX32-NEXT:    lwz 27, L..C5(2) # @ui
; AIX32-NEXT:    lbz 4, 0(28)
; AIX32-NEXT:    lbz 3, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:    extsb 4, 4
; AIX32-NEXT:  L..BB3_16: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 5, 0, 27
; AIX32-NEXT:    cmpw 5, 3
; AIX32-NEXT:    bne 0, L..BB3_18
; AIX32-NEXT:  # %bb.17: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    stwcx. 4, 0, 27
; AIX32-NEXT:    bne 0, L..BB3_16
; AIX32-NEXT:  L..BB3_18: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lwz 31, L..C6(2) # @sll
; AIX32-NEXT:    stw 5, 0(27)
; AIX32-NEXT:    lbz 3, 0(28)
; AIX32-NEXT:    li 23, 0
; AIX32-NEXT:    addi 4, 1, 56
; AIX32-NEXT:    li 7, 5
; AIX32-NEXT:    li 8, 5
; AIX32-NEXT:    stw 23, 56(1)
; AIX32-NEXT:    extsb 6, 3
; AIX32-NEXT:    lbz 3, 0(29)
; AIX32-NEXT:    srawi 5, 6, 31
; AIX32-NEXT:    stw 3, 60(1)
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    bl .__atomic_compare_exchange_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 3, 60(1)
; AIX32-NEXT:    lbz 4, 0(28)
; AIX32-NEXT:    lwz 30, L..C7(2) # @ull
; AIX32-NEXT:    li 7, 5
; AIX32-NEXT:    li 8, 5
; AIX32-NEXT:    stw 3, 4(31)
; AIX32-NEXT:    lwz 3, 56(1)
; AIX32-NEXT:    extsb 6, 4
; AIX32-NEXT:    addi 4, 1, 56
; AIX32-NEXT:    srawi 5, 6, 31
; AIX32-NEXT:    stw 23, 56(1)
; AIX32-NEXT:    stw 3, 0(31)
; AIX32-NEXT:    lbz 3, 0(29)
; AIX32-NEXT:    stw 3, 60(1)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    bl .__atomic_compare_exchange_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 4, 60(1)
; AIX32-NEXT:    lwz 3, 56(1)
; AIX32-NEXT:    stw 4, 4(30)
; AIX32-NEXT:    lbz 4, 0(28)
; AIX32-NEXT:    stw 3, 0(30)
; AIX32-NEXT:    lbz 3, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 5, 4, 21
; AIX32-NEXT:    li 4, 255
; AIX32-NEXT:    slw 6, 3, 21
; AIX32-NEXT:    slw 4, 4, 21
; AIX32-NEXT:    and 5, 5, 4
; AIX32-NEXT:    and 6, 6, 4
; AIX32-NEXT:  L..BB3_19: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 8, 0, 18
; AIX32-NEXT:    and 7, 8, 4
; AIX32-NEXT:    cmpw 7, 6
; AIX32-NEXT:    bne 0, L..BB3_21
; AIX32-NEXT:  # %bb.20: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    andc 8, 8, 4
; AIX32-NEXT:    or 8, 8, 5
; AIX32-NEXT:    stwcx. 8, 0, 18
; AIX32-NEXT:    bne 0, L..BB3_19
; AIX32-NEXT:  L..BB3_21: # %entry
; AIX32-NEXT:    srw 4, 7, 21
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lbz 5, 0(28)
; AIX32-NEXT:    cmpw 4, 3
; AIX32-NEXT:    li 3, 1
; AIX32-NEXT:    iseleq 4, 3, 23
; AIX32-NEXT:    slw 6, 5, 25
; AIX32-NEXT:    li 5, 255
; AIX32-NEXT:    stw 4, 0(27)
; AIX32-NEXT:    lbz 4, 0(29)
; AIX32-NEXT:    slw 5, 5, 25
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 7, 4, 25
; AIX32-NEXT:    and 6, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:  L..BB3_22: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 9, 0, 20
; AIX32-NEXT:    and 8, 9, 5
; AIX32-NEXT:    cmpw 8, 7
; AIX32-NEXT:    bne 0, L..BB3_24
; AIX32-NEXT:  # %bb.23: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    andc 9, 9, 5
; AIX32-NEXT:    or 9, 9, 6
; AIX32-NEXT:    stwcx. 9, 0, 20
; AIX32-NEXT:    bne 0, L..BB3_22
; AIX32-NEXT:  L..BB3_24: # %entry
; AIX32-NEXT:    srw 5, 8, 25
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    cmpw 5, 4
; AIX32-NEXT:    lbz 5, 0(28)
; AIX32-NEXT:    iseleq 4, 3, 23
; AIX32-NEXT:    extsb 5, 5
; AIX32-NEXT:    stw 4, 0(27)
; AIX32-NEXT:    lbz 4, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 6, 5, 26
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    slw 7, 4, 26
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    slw 5, 5, 26
; AIX32-NEXT:    and 6, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:  L..BB3_25: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 9, 0, 22
; AIX32-NEXT:    and 8, 9, 5
; AIX32-NEXT:    cmpw 8, 7
; AIX32-NEXT:    bne 0, L..BB3_27
; AIX32-NEXT:  # %bb.26: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    andc 9, 9, 5
; AIX32-NEXT:    or 9, 9, 6
; AIX32-NEXT:    stwcx. 9, 0, 22
; AIX32-NEXT:    bne 0, L..BB3_25
; AIX32-NEXT:  L..BB3_27: # %entry
; AIX32-NEXT:    srw 5, 8, 26
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    cmpw 5, 4
; AIX32-NEXT:    lbz 5, 0(28)
; AIX32-NEXT:    iseleq 4, 3, 23
; AIX32-NEXT:    extsb 5, 5
; AIX32-NEXT:    stw 4, 0(27)
; AIX32-NEXT:    lbz 4, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:    slw 6, 5, 24
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    slw 7, 4, 24
; AIX32-NEXT:    ori 5, 5, 65535
; AIX32-NEXT:    slw 5, 5, 24
; AIX32-NEXT:    and 6, 6, 5
; AIX32-NEXT:    and 7, 7, 5
; AIX32-NEXT:  L..BB3_28: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 9, 0, 19
; AIX32-NEXT:    and 8, 9, 5
; AIX32-NEXT:    cmpw 8, 7
; AIX32-NEXT:    bne 0, L..BB3_30
; AIX32-NEXT:  # %bb.29: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    andc 9, 9, 5
; AIX32-NEXT:    or 9, 9, 6
; AIX32-NEXT:    stwcx. 9, 0, 19
; AIX32-NEXT:    bne 0, L..BB3_28
; AIX32-NEXT:  L..BB3_30: # %entry
; AIX32-NEXT:    srw 5, 8, 24
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    cmpw 5, 4
; AIX32-NEXT:    lbz 5, 0(28)
; AIX32-NEXT:    iseleq 4, 3, 23
; AIX32-NEXT:    stw 4, 0(27)
; AIX32-NEXT:    lbz 4, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:    extsb 5, 5
; AIX32-NEXT:  L..BB3_31: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 17
; AIX32-NEXT:    cmpw 1, 6, 4
; AIX32-NEXT:    bne 1, L..BB3_33
; AIX32-NEXT:  # %bb.32: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    stwcx. 5, 0, 17
; AIX32-NEXT:    bne 0, L..BB3_31
; AIX32-NEXT:  L..BB3_33: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    isel 4, 3, 23, 6
; AIX32-NEXT:    lbz 5, 0(28)
; AIX32-NEXT:    stw 4, 0(27)
; AIX32-NEXT:    lbz 4, 0(29)
; AIX32-NEXT:    sync
; AIX32-NEXT:    extsb 5, 5
; AIX32-NEXT:  L..BB3_34: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 27
; AIX32-NEXT:    cmpw 1, 6, 4
; AIX32-NEXT:    bne 1, L..BB3_36
; AIX32-NEXT:  # %bb.35: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    stwcx. 5, 0, 27
; AIX32-NEXT:    bne 0, L..BB3_34
; AIX32-NEXT:  L..BB3_36: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    isel 3, 3, 23, 6
; AIX32-NEXT:    li 7, 5
; AIX32-NEXT:    li 8, 5
; AIX32-NEXT:    lbz 4, 0(28)
; AIX32-NEXT:    stw 3, 0(27)
; AIX32-NEXT:    lbz 3, 0(29)
; AIX32-NEXT:    stw 23, 56(1)
; AIX32-NEXT:    extsb 6, 4
; AIX32-NEXT:    addi 4, 1, 56
; AIX32-NEXT:    stw 3, 60(1)
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    srawi 5, 6, 31
; AIX32-NEXT:    bl .__atomic_compare_exchange_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lbz 4, 0(28)
; AIX32-NEXT:    stw 3, 0(27)
; AIX32-NEXT:    lbz 3, 0(29)
; AIX32-NEXT:    li 7, 5
; AIX32-NEXT:    li 8, 5
; AIX32-NEXT:    extsb 6, 4
; AIX32-NEXT:    addi 4, 1, 56
; AIX32-NEXT:    stw 3, 60(1)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    stw 23, 56(1)
; AIX32-NEXT:    srawi 5, 6, 31
; AIX32-NEXT:    bl .__atomic_compare_exchange_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 3, 0(27)
; AIX32-NEXT:    lwz 31, 124(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 30, 120(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 29, 116(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 28, 112(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 27, 108(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 26, 104(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 25, 100(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 24, 96(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 23, 92(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 22, 88(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 21, 84(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 20, 80(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 19, 76(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 18, 72(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 17, 68(1) # 4-byte Folded Reload
; AIX32-NEXT:    addi 1, 1, 128
; AIX32-NEXT:    lwz 0, 8(1)
; AIX32-NEXT:    mtlr 0
; AIX32-NEXT:    blr
entry:
  %0 = load i8, ptr @uc, align 1
  %1 = load i8, ptr @sc, align 1
  %2 = cmpxchg ptr @sc, i8 %0, i8 %1 seq_cst seq_cst, align 1
  %3 = extractvalue { i8, i1 } %2, 0
  store i8 %3, ptr @sc, align 1
  %4 = load i8, ptr @uc, align 1
  %5 = cmpxchg ptr @uc, i8 %4, i8 %3 seq_cst seq_cst, align 1
  %6 = extractvalue { i8, i1 } %5, 0
  store i8 %6, ptr @uc, align 1
  %conv = zext i8 %6 to i16
  %7 = load i8, ptr @sc, align 1
  %conv1 = sext i8 %7 to i16
  %8 = cmpxchg ptr @ss, i16 %conv, i16 %conv1 seq_cst seq_cst, align 2
  %9 = extractvalue { i16, i1 } %8, 0
  store i16 %9, ptr @ss, align 2
  %10 = load i8, ptr @uc, align 1
  %conv2 = zext i8 %10 to i16
  %11 = load i8, ptr @sc, align 1
  %conv3 = sext i8 %11 to i16
  %12 = cmpxchg ptr @us, i16 %conv2, i16 %conv3 seq_cst seq_cst, align 2
  %13 = extractvalue { i16, i1 } %12, 0
  store i16 %13, ptr @us, align 2
  %14 = load i8, ptr @uc, align 1
  %conv4 = zext i8 %14 to i32
  %15 = load i8, ptr @sc, align 1
  %conv5 = sext i8 %15 to i32
  %16 = cmpxchg ptr @si, i32 %conv4, i32 %conv5 seq_cst seq_cst, align 4
  %17 = extractvalue { i32, i1 } %16, 0
  store i32 %17, ptr @si, align 4
  %18 = load i8, ptr @uc, align 1
  %conv6 = zext i8 %18 to i32
  %19 = load i8, ptr @sc, align 1
  %conv7 = sext i8 %19 to i32
  %20 = cmpxchg ptr @ui, i32 %conv6, i32 %conv7 seq_cst seq_cst, align 4
  %21 = extractvalue { i32, i1 } %20, 0
  store i32 %21, ptr @ui, align 4
  %22 = load i8, ptr @uc, align 1
  %conv8 = zext i8 %22 to i64
  %23 = load i8, ptr @sc, align 1
  %conv9 = sext i8 %23 to i64
  %24 = cmpxchg ptr @sll, i64 %conv8, i64 %conv9 seq_cst seq_cst, align 8
  %25 = extractvalue { i64, i1 } %24, 0
  store i64 %25, ptr @sll, align 8
  %26 = load i8, ptr @uc, align 1
  %conv10 = zext i8 %26 to i64
  %27 = load i8, ptr @sc, align 1
  %conv11 = sext i8 %27 to i64
  %28 = cmpxchg ptr @ull, i64 %conv10, i64 %conv11 seq_cst seq_cst, align 8
  %29 = extractvalue { i64, i1 } %28, 0
  store i64 %29, ptr @ull, align 8
  %30 = load i8, ptr @uc, align 1
  %31 = load i8, ptr @sc, align 1
  %32 = cmpxchg ptr @sc, i8 %30, i8 %31 seq_cst seq_cst, align 1
  %33 = extractvalue { i8, i1 } %32, 1
  %conv12 = zext i1 %33 to i32
  store i32 %conv12, ptr @ui, align 4
  %34 = load i8, ptr @uc, align 1
  %35 = load i8, ptr @sc, align 1
  %36 = cmpxchg ptr @uc, i8 %34, i8 %35 seq_cst seq_cst, align 1
  %37 = extractvalue { i8, i1 } %36, 1
  %conv13 = zext i1 %37 to i32
  store i32 %conv13, ptr @ui, align 4
  %38 = load i8, ptr @uc, align 1
  %conv14 = zext i8 %38 to i16
  %39 = load i8, ptr @sc, align 1
  %conv15 = sext i8 %39 to i16
  %40 = cmpxchg ptr @ss, i16 %conv14, i16 %conv15 seq_cst seq_cst, align 2
  %41 = extractvalue { i16, i1 } %40, 1
  %conv16 = zext i1 %41 to i32
  store i32 %conv16, ptr @ui, align 4
  %42 = load i8, ptr @uc, align 1
  %conv17 = zext i8 %42 to i16
  %43 = load i8, ptr @sc, align 1
  %conv18 = sext i8 %43 to i16
  %44 = cmpxchg ptr @us, i16 %conv17, i16 %conv18 seq_cst seq_cst, align 2
  %45 = extractvalue { i16, i1 } %44, 1
  %conv19 = zext i1 %45 to i32
  store i32 %conv19, ptr @ui, align 4
  %46 = load i8, ptr @uc, align 1
  %conv20 = zext i8 %46 to i32
  %47 = load i8, ptr @sc, align 1
  %conv21 = sext i8 %47 to i32
  %48 = cmpxchg ptr @si, i32 %conv20, i32 %conv21 seq_cst seq_cst, align 4
  %49 = extractvalue { i32, i1 } %48, 1
  %conv22 = zext i1 %49 to i32
  store i32 %conv22, ptr @ui, align 4
  %50 = load i8, ptr @uc, align 1
  %conv23 = zext i8 %50 to i32
  %51 = load i8, ptr @sc, align 1
  %conv24 = sext i8 %51 to i32
  %52 = cmpxchg ptr @ui, i32 %conv23, i32 %conv24 seq_cst seq_cst, align 4
  %53 = extractvalue { i32, i1 } %52, 1
  %conv25 = zext i1 %53 to i32
  store i32 %conv25, ptr @ui, align 4
  %54 = load i8, ptr @uc, align 1
  %conv26 = zext i8 %54 to i64
  %55 = load i8, ptr @sc, align 1
  %conv27 = sext i8 %55 to i64
  %56 = cmpxchg ptr @sll, i64 %conv26, i64 %conv27 seq_cst seq_cst, align 8
  %57 = extractvalue { i64, i1 } %56, 1
  %conv28 = zext i1 %57 to i32
  store i32 %conv28, ptr @ui, align 4
  %58 = load i8, ptr @uc, align 1
  %conv29 = zext i8 %58 to i64
  %59 = load i8, ptr @sc, align 1
  %conv30 = sext i8 %59 to i64
  %60 = cmpxchg ptr @ull, i64 %conv29, i64 %conv30 seq_cst seq_cst, align 8
  %61 = extractvalue { i64, i1 } %60, 1
  %conv31 = zext i1 %61 to i32
  store i32 %conv31, ptr @ui, align 4
  ret void
}

define dso_local void @test_lock() local_unnamed_addr #0 {
; CHECK-LABEL: test_lock:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, sc@toc@ha
; CHECK-NEXT:    sync
; CHECK-NEXT:    li 7, 1
; CHECK-NEXT:    addi 4, 3, sc@toc@l
; CHECK-NEXT:  .LBB4_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 5, 0, 4
; CHECK-NEXT:    stbcx. 7, 0, 4
; CHECK-NEXT:    bne 0, .LBB4_1
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    addis 4, 2, uc@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 5, sc@toc@l(3)
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 6, 4, uc@toc@l
; CHECK-NEXT:  .LBB4_3: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 5, 0, 6
; CHECK-NEXT:    stbcx. 7, 0, 6
; CHECK-NEXT:    bne 0, .LBB4_3
; CHECK-NEXT:  # %bb.4: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 5, uc@toc@l(4)
; CHECK-NEXT:    addis 5, 2, ss@toc@ha
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 8, 5, ss@toc@l
; CHECK-NEXT:  .LBB4_5: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 6, 0, 8
; CHECK-NEXT:    sthcx. 7, 0, 8
; CHECK-NEXT:    bne 0, .LBB4_5
; CHECK-NEXT:  # %bb.6: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 6, ss@toc@l(5)
; CHECK-NEXT:    addis 6, 2, us@toc@ha
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 9, 6, us@toc@l
; CHECK-NEXT:  .LBB4_7: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 8, 0, 9
; CHECK-NEXT:    sthcx. 7, 0, 9
; CHECK-NEXT:    bne 0, .LBB4_7
; CHECK-NEXT:  # %bb.8: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 8, us@toc@l(6)
; CHECK-NEXT:    addis 8, 2, si@toc@ha
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 10, 8, si@toc@l
; CHECK-NEXT:  .LBB4_9: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 9, 0, 10
; CHECK-NEXT:    stwcx. 7, 0, 10
; CHECK-NEXT:    bne 0, .LBB4_9
; CHECK-NEXT:  # %bb.10: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 9, si@toc@l(8)
; CHECK-NEXT:    addis 9, 2, ui@toc@ha
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 11, 9, ui@toc@l
; CHECK-NEXT:  .LBB4_11: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 10, 0, 11
; CHECK-NEXT:    stwcx. 7, 0, 11
; CHECK-NEXT:    bne 0, .LBB4_11
; CHECK-NEXT:  # %bb.12: # %entry
; CHECK-NEXT:    addis 7, 2, sll@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 10, ui@toc@l(9)
; CHECK-NEXT:    li 11, 1
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 10, 7, sll@toc@l
; CHECK-NEXT:  .LBB4_13: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 12, 0, 10
; CHECK-NEXT:    stdcx. 11, 0, 10
; CHECK-NEXT:    bne 0, .LBB4_13
; CHECK-NEXT:  # %bb.14: # %entry
; CHECK-NEXT:    addis 10, 2, ull@toc@ha
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 12, sll@toc@l(7)
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 0, 10, ull@toc@l
; CHECK-NEXT:  .LBB4_15: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 12, 0, 0
; CHECK-NEXT:    stdcx. 11, 0, 0
; CHECK-NEXT:    bne 0, .LBB4_15
; CHECK-NEXT:  # %bb.16: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 12, ull@toc@l(10)
; CHECK-NEXT:    li 11, 0
; CHECK-NEXT:    sync
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 11, sc@toc@l(3)
; CHECK-NEXT:    li 3, 0
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stb 11, uc@toc@l(4)
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 11, ss@toc@l(5)
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    sth 11, us@toc@l(6)
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 11, si@toc@l(8)
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 11, ui@toc@l(9)
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 3, sll@toc@l(7)
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    std 3, ull@toc@l(10)
; CHECK-NEXT:    blr
;
; AIX32-LABEL: test_lock:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    mflr 0
; AIX32-NEXT:    stwu 1, -96(1)
; AIX32-NEXT:    stw 0, 104(1)
; AIX32-NEXT:    stw 29, 84(1) # 4-byte Folded Spill
; AIX32-NEXT:    lwz 29, L..C0(2) # @sc
; AIX32-NEXT:    li 3, 1
; AIX32-NEXT:    li 6, 255
; AIX32-NEXT:    stw 23, 60(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 24, 64(1) # 4-byte Folded Spill
; AIX32-NEXT:    rlwinm 4, 29, 3, 27, 28
; AIX32-NEXT:    stw 25, 68(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 26, 72(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 27, 76(1) # 4-byte Folded Spill
; AIX32-NEXT:    xori 4, 4, 24
; AIX32-NEXT:    stw 28, 80(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 30, 88(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 31, 92(1) # 4-byte Folded Spill
; AIX32-NEXT:    slw 7, 3, 4
; AIX32-NEXT:    slw 6, 6, 4
; AIX32-NEXT:    sync
; AIX32-NEXT:    rlwinm 5, 29, 0, 0, 29
; AIX32-NEXT:    and 7, 7, 6
; AIX32-NEXT:  L..BB4_1: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 8, 0, 5
; AIX32-NEXT:    andc 9, 8, 6
; AIX32-NEXT:    or 9, 7, 9
; AIX32-NEXT:    stwcx. 9, 0, 5
; AIX32-NEXT:    bne 0, L..BB4_1
; AIX32-NEXT:  # %bb.2: # %entry
; AIX32-NEXT:    srw 4, 8, 4
; AIX32-NEXT:    lwz 28, L..C1(2) # @uc
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 6, 255
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    rlwinm 5, 28, 0, 0, 29
; AIX32-NEXT:    stb 4, 0(29)
; AIX32-NEXT:    rlwinm 4, 28, 3, 27, 28
; AIX32-NEXT:    sync
; AIX32-NEXT:    xori 4, 4, 24
; AIX32-NEXT:    slw 7, 3, 4
; AIX32-NEXT:    slw 6, 6, 4
; AIX32-NEXT:    and 7, 7, 6
; AIX32-NEXT:  L..BB4_3: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 8, 0, 5
; AIX32-NEXT:    andc 9, 8, 6
; AIX32-NEXT:    or 9, 7, 9
; AIX32-NEXT:    stwcx. 9, 0, 5
; AIX32-NEXT:    bne 0, L..BB4_3
; AIX32-NEXT:  # %bb.4: # %entry
; AIX32-NEXT:    srw 4, 8, 4
; AIX32-NEXT:    lwz 27, L..C2(2) # @ss
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 6, 0
; AIX32-NEXT:    clrlwi 4, 4, 24
; AIX32-NEXT:    ori 6, 6, 65535
; AIX32-NEXT:    rlwinm 5, 27, 0, 0, 29
; AIX32-NEXT:    stb 4, 0(28)
; AIX32-NEXT:    rlwinm 4, 27, 3, 27, 27
; AIX32-NEXT:    sync
; AIX32-NEXT:    xori 4, 4, 16
; AIX32-NEXT:    slw 7, 3, 4
; AIX32-NEXT:    slw 6, 6, 4
; AIX32-NEXT:    and 7, 7, 6
; AIX32-NEXT:  L..BB4_5: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 8, 0, 5
; AIX32-NEXT:    andc 9, 8, 6
; AIX32-NEXT:    or 9, 7, 9
; AIX32-NEXT:    stwcx. 9, 0, 5
; AIX32-NEXT:    bne 0, L..BB4_5
; AIX32-NEXT:  # %bb.6: # %entry
; AIX32-NEXT:    srw 4, 8, 4
; AIX32-NEXT:    lwz 26, L..C3(2) # @us
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    li 6, 0
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    ori 6, 6, 65535
; AIX32-NEXT:    rlwinm 5, 26, 0, 0, 29
; AIX32-NEXT:    sth 4, 0(27)
; AIX32-NEXT:    rlwinm 4, 26, 3, 27, 27
; AIX32-NEXT:    sync
; AIX32-NEXT:    xori 4, 4, 16
; AIX32-NEXT:    slw 7, 3, 4
; AIX32-NEXT:    slw 6, 6, 4
; AIX32-NEXT:    and 7, 7, 6
; AIX32-NEXT:  L..BB4_7: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 8, 0, 5
; AIX32-NEXT:    andc 9, 8, 6
; AIX32-NEXT:    or 9, 7, 9
; AIX32-NEXT:    stwcx. 9, 0, 5
; AIX32-NEXT:    bne 0, L..BB4_7
; AIX32-NEXT:  # %bb.8: # %entry
; AIX32-NEXT:    srw 4, 8, 4
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    lwz 25, L..C4(2) # @si
; AIX32-NEXT:    clrlwi 4, 4, 16
; AIX32-NEXT:    sth 4, 0(26)
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB4_9: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 25
; AIX32-NEXT:    stwcx. 3, 0, 25
; AIX32-NEXT:    bne 0, L..BB4_9
; AIX32-NEXT:  # %bb.10: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 4, 0(25)
; AIX32-NEXT:    lwz 24, L..C5(2) # @ui
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB4_11: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 24
; AIX32-NEXT:    stwcx. 3, 0, 24
; AIX32-NEXT:    bne 0, L..BB4_11
; AIX32-NEXT:  # %bb.12: # %entry
; AIX32-NEXT:    lwz 31, L..C6(2) # @sll
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 4, 0(24)
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    li 23, 0
; AIX32-NEXT:    bl .__atomic_exchange_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 30, L..C7(2) # @ull
; AIX32-NEXT:    stw 4, 4(31)
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 1
; AIX32-NEXT:    li 6, 5
; AIX32-NEXT:    stw 3, 0(31)
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    bl .__atomic_exchange_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    stw 4, 4(30)
; AIX32-NEXT:    stw 3, 0(30)
; AIX32-NEXT:    sync
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    mr 3, 31
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stb 23, 0(29)
; AIX32-NEXT:    li 6, 3
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stb 23, 0(28)
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sth 23, 0(27)
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    sth 23, 0(26)
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 23, 0(25)
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 23, 0(24)
; AIX32-NEXT:    bl .__atomic_store_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    li 4, 0
; AIX32-NEXT:    li 5, 0
; AIX32-NEXT:    mr 3, 30
; AIX32-NEXT:    li 6, 3
; AIX32-NEXT:    bl .__atomic_store_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 31, 92(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 30, 88(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 29, 84(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 28, 80(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 27, 76(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 26, 72(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 25, 68(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 24, 64(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 23, 60(1) # 4-byte Folded Reload
; AIX32-NEXT:    addi 1, 1, 96
; AIX32-NEXT:    lwz 0, 8(1)
; AIX32-NEXT:    mtlr 0
; AIX32-NEXT:    blr
entry:
  %0 = atomicrmw xchg ptr @sc, i8 1 seq_cst, align 1
  store i8 %0, ptr @sc, align 1
  %1 = atomicrmw xchg ptr @uc, i8 1 seq_cst, align 1
  store i8 %1, ptr @uc, align 1
  %2 = atomicrmw xchg ptr @ss, i16 1 seq_cst, align 2
  store i16 %2, ptr @ss, align 2
  %3 = atomicrmw xchg ptr @us, i16 1 seq_cst, align 2
  store i16 %3, ptr @us, align 2
  %4 = atomicrmw xchg ptr @si, i32 1 seq_cst, align 4
  store i32 %4, ptr @si, align 4
  %5 = atomicrmw xchg ptr @ui, i32 1 seq_cst, align 4
  store i32 %5, ptr @ui, align 4
  %6 = atomicrmw xchg ptr @sll, i64 1 seq_cst, align 8
  store i64 %6, ptr @sll, align 8
  %7 = atomicrmw xchg ptr @ull, i64 1 seq_cst, align 8
  store i64 %7, ptr @ull, align 8
  fence seq_cst
  store atomic i8 0, ptr @sc release, align 1
  store atomic i8 0, ptr @uc release, align 1
  store atomic i16 0, ptr @ss release, align 2
  store atomic i16 0, ptr @us release, align 2
  store atomic i32 0, ptr @si release, align 4
  store atomic i32 0, ptr @ui release, align 4
  store atomic i64 0, ptr @sll release, align 8
  store atomic i64 0, ptr @ull release, align 8
  ret void
}

define dso_local void @test_atomic() local_unnamed_addr #0 {
; CHECK-LABEL: test_atomic:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 4, 2, ui@toc@ha
; CHECK-NEXT:    li 3, 5
; CHECK-NEXT:    addi 6, 4, ui@toc@l
; CHECK-NEXT:  .LBB5_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 5, 0, 6
; CHECK-NEXT:    cmplwi 5, 5
; CHECK-NEXT:    blt 0, .LBB5_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 3, 0, 6
; CHECK-NEXT:    bne 0, .LBB5_1
; CHECK-NEXT:  .LBB5_3: # %entry
; CHECK-NEXT:    stw 5, ui@toc@l(4)
; CHECK-NEXT:    addis 5, 2, si@toc@ha
; CHECK-NEXT:    sync
; CHECK-NEXT:    addi 7, 5, si@toc@l
; CHECK-NEXT:  .LBB5_4: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 8, 0, 7
; CHECK-NEXT:    cmpwi 8, 5
; CHECK-NEXT:    blt 0, .LBB5_6
; CHECK-NEXT:  # %bb.5: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 3, 0, 7
; CHECK-NEXT:    bne 0, .LBB5_4
; CHECK-NEXT:  .LBB5_6: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 8, si@toc@l(5)
; CHECK-NEXT:  .LBB5_7: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 8, 0, 6
; CHECK-NEXT:    cmplwi 8, 5
; CHECK-NEXT:    bgt 0, .LBB5_9
; CHECK-NEXT:  # %bb.8: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 3, 0, 6
; CHECK-NEXT:    bne 0, .LBB5_7
; CHECK-NEXT:  .LBB5_9: # %entry
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    stw 8, ui@toc@l(4)
; CHECK-NEXT:    lwsync
; CHECK-NEXT:  .LBB5_10: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 4, 0, 7
; CHECK-NEXT:    cmpwi 4, 5
; CHECK-NEXT:    bgt 0, .LBB5_12
; CHECK-NEXT:  # %bb.11: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 3, 0, 7
; CHECK-NEXT:    bne 0, .LBB5_10
; CHECK-NEXT:  .LBB5_12: # %entry
; CHECK-NEXT:    stw 4, si@toc@l(5)
; CHECK-NEXT:    blr
;
; AIX32-LABEL: test_atomic:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    lwz 4, L..C5(2) # @ui
; AIX32-NEXT:    li 3, 5
; AIX32-NEXT:  L..BB5_1: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 5, 0, 4
; AIX32-NEXT:    cmplwi 5, 5
; AIX32-NEXT:    blt 0, L..BB5_3
; AIX32-NEXT:  # %bb.2: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    stwcx. 3, 0, 4
; AIX32-NEXT:    bne 0, L..BB5_1
; AIX32-NEXT:  L..BB5_3: # %entry
; AIX32-NEXT:    stw 5, 0(4)
; AIX32-NEXT:    lwz 5, L..C4(2) # @si
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB5_4: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 5
; AIX32-NEXT:    cmpwi 6, 5
; AIX32-NEXT:    blt 0, L..BB5_6
; AIX32-NEXT:  # %bb.5: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    stwcx. 3, 0, 5
; AIX32-NEXT:    bne 0, L..BB5_4
; AIX32-NEXT:  L..BB5_6: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 6, 0(5)
; AIX32-NEXT:  L..BB5_7: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 6, 0, 4
; AIX32-NEXT:    cmplwi 6, 5
; AIX32-NEXT:    bgt 0, L..BB5_9
; AIX32-NEXT:  # %bb.8: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    stwcx. 3, 0, 4
; AIX32-NEXT:    bne 0, L..BB5_7
; AIX32-NEXT:  L..BB5_9: # %entry
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    stw 6, 0(4)
; AIX32-NEXT:    lwsync
; AIX32-NEXT:  L..BB5_10: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 4, 0, 5
; AIX32-NEXT:    cmpwi 4, 5
; AIX32-NEXT:    bgt 0, L..BB5_12
; AIX32-NEXT:  # %bb.11: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    stwcx. 3, 0, 5
; AIX32-NEXT:    bne 0, L..BB5_10
; AIX32-NEXT:  L..BB5_12: # %entry
; AIX32-NEXT:    stw 4, 0(5)
; AIX32-NEXT:    blr
entry:
  %0 = atomicrmw umin ptr @ui, i32 5 monotonic, align 4
  store i32 %0, ptr @ui, align 4
  %1 = atomicrmw min ptr @si, i32 5 seq_cst, align 4
  store i32 %1, ptr @si, align 4
  %2 = atomicrmw umax ptr @ui, i32 5 acquire, align 4
  store i32 %2, ptr @ui, align 4
  %3 = atomicrmw max ptr @si, i32 5 release, align 4
  store i32 %3, ptr @si, align 4
  ret void
}

define dso_local i64 @cmpswplp(ptr noundef %ptr, ptr nocapture noundef readnone %oldval, i64 noundef %newval) local_unnamed_addr #0 {
; CHECK-LABEL: cmpswplp:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 4, 5, 1
; CHECK-NEXT:  .LBB6_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 6, 0, 3
; CHECK-NEXT:    cmpd 1, 6, 5
; CHECK-NEXT:    bne 1, .LBB6_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stdcx. 4, 0, 3
; CHECK-NEXT:    bne 0, .LBB6_1
; CHECK-NEXT:  .LBB6_3: # %entry
; CHECK-NEXT:    li 3, 66
; CHECK-NEXT:    li 4, 55
; CHECK-NEXT:    isel 3, 4, 3, 6
; CHECK-NEXT:    blr
;
; AIX32-LABEL: cmpswplp:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    mflr 0
; AIX32-NEXT:    stwu 1, -64(1)
; AIX32-NEXT:    addic 7, 6, 1
; AIX32-NEXT:    stw 0, 72(1)
; AIX32-NEXT:    addze 8, 5
; AIX32-NEXT:    stw 6, 60(1)
; AIX32-NEXT:    stw 5, 56(1)
; AIX32-NEXT:    addi 4, 1, 56
; AIX32-NEXT:    mr 5, 8
; AIX32-NEXT:    mr 6, 7
; AIX32-NEXT:    li 7, 0
; AIX32-NEXT:    li 8, 0
; AIX32-NEXT:    bl .__atomic_compare_exchange_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    andi. 3, 3, 1
; AIX32-NEXT:    li 3, 66
; AIX32-NEXT:    li 4, 55
; AIX32-NEXT:    iselgt 4, 4, 3
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    addi 1, 1, 64
; AIX32-NEXT:    lwz 0, 8(1)
; AIX32-NEXT:    mtlr 0
; AIX32-NEXT:    blr
entry:
  %add = add nsw i64 %newval, 1
  %0 = cmpxchg weak volatile ptr %ptr, i64 %newval, i64 %add monotonic monotonic, align 8
  %1 = extractvalue { i64, i1 } %0, 1
  %conv = select i1 %1, i64 55, i64 66
  ret i64 %conv
}

define dso_local i64 @atommax8(ptr nocapture noundef %ptr, i64 noundef %val) local_unnamed_addr #0 {
; CHECK-LABEL: atommax8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB7_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    ldarx 5, 0, 3
; CHECK-NEXT:    cmpd 1, 5, 4
; CHECK-NEXT:    bgt 1, .LBB7_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stdcx. 4, 0, 3
; CHECK-NEXT:    bne 0, .LBB7_1
; CHECK-NEXT:  .LBB7_3: # %entry
; CHECK-NEXT:    li 3, 55
; CHECK-NEXT:    li 4, 66
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    isel 3, 4, 3, 5
; CHECK-NEXT:    blr
;
; AIX32-LABEL: atommax8:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    mflr 0
; AIX32-NEXT:    stwu 1, -80(1)
; AIX32-NEXT:    stw 0, 88(1)
; AIX32-NEXT:    stw 30, 72(1) # 4-byte Folded Spill
; AIX32-NEXT:    stw 31, 76(1) # 4-byte Folded Spill
; AIX32-NEXT:    mr 31, 5
; AIX32-NEXT:    mr 30, 4
; AIX32-NEXT:    lwz 4, 4(3)
; AIX32-NEXT:    lwz 5, 0(3)
; AIX32-NEXT:    stw 28, 64(1) # 4-byte Folded Spill
; AIX32-NEXT:    addi 28, 1, 56
; AIX32-NEXT:    stw 29, 68(1) # 4-byte Folded Spill
; AIX32-NEXT:    mr 29, 3
; AIX32-NEXT:    .align 4
; AIX32-NEXT:  L..BB7_1: # %atomicrmw.start
; AIX32-NEXT:    #
; AIX32-NEXT:    cmplw 5, 30
; AIX32-NEXT:    cmpw 1, 5, 30
; AIX32-NEXT:    li 7, 5
; AIX32-NEXT:    li 8, 5
; AIX32-NEXT:    stw 5, 56(1)
; AIX32-NEXT:    mr 3, 29
; AIX32-NEXT:    crandc 20, 5, 2
; AIX32-NEXT:    cmplw 1, 4, 31
; AIX32-NEXT:    crand 21, 2, 5
; AIX32-NEXT:    stw 4, 60(1)
; AIX32-NEXT:    cror 20, 21, 20
; AIX32-NEXT:    isel 5, 5, 30, 20
; AIX32-NEXT:    isel 6, 4, 31, 20
; AIX32-NEXT:    mr 4, 28
; AIX32-NEXT:    bl .__atomic_compare_exchange_8[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 4, 60(1)
; AIX32-NEXT:    lwz 5, 56(1)
; AIX32-NEXT:    cmplwi 3, 0
; AIX32-NEXT:    beq 0, L..BB7_1
; AIX32-NEXT:  # %bb.2: # %atomicrmw.end
; AIX32-NEXT:    cmplw 5, 30
; AIX32-NEXT:    cmpw 1, 5, 30
; AIX32-NEXT:    li 3, 55
; AIX32-NEXT:    lwz 30, 72(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 29, 68(1) # 4-byte Folded Reload
; AIX32-NEXT:    lwz 28, 64(1) # 4-byte Folded Reload
; AIX32-NEXT:    crandc 20, 5, 2
; AIX32-NEXT:    cmplw 1, 4, 31
; AIX32-NEXT:    li 4, 66
; AIX32-NEXT:    lwz 31, 76(1) # 4-byte Folded Reload
; AIX32-NEXT:    crand 21, 2, 5
; AIX32-NEXT:    cror 20, 21, 20
; AIX32-NEXT:    isel 4, 4, 3, 20
; AIX32-NEXT:    li 3, 0
; AIX32-NEXT:    addi 1, 1, 80
; AIX32-NEXT:    lwz 0, 8(1)
; AIX32-NEXT:    mtlr 0
; AIX32-NEXT:    blr
entry:
  %0 = atomicrmw max ptr %ptr, i64 %val seq_cst, align 8
  %cmp.not = icmp sgt i64 %0, %val
  %conv = select i1 %cmp.not, i64 66, i64 55
  ret i64 %conv
}

define dso_local signext i32 @atommax4(ptr nocapture noundef %ptr, i32 noundef signext %val) local_unnamed_addr #0 {
; CHECK-LABEL: atommax4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB8_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lwarx 5, 0, 3
; CHECK-NEXT:    cmpw 1, 5, 4
; CHECK-NEXT:    bgt 1, .LBB8_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 4, 0, 3
; CHECK-NEXT:    bne 0, .LBB8_1
; CHECK-NEXT:  .LBB8_3: # %entry
; CHECK-NEXT:    li 3, 55
; CHECK-NEXT:    li 4, 66
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    isel 3, 4, 3, 5
; CHECK-NEXT:    blr
;
; AIX32-LABEL: atommax4:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    sync
; AIX32-NEXT:  L..BB8_1: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 5, 0, 3
; AIX32-NEXT:    cmpw 1, 5, 4
; AIX32-NEXT:    bgt 1, L..BB8_3
; AIX32-NEXT:  # %bb.2: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    stwcx. 4, 0, 3
; AIX32-NEXT:    bne 0, L..BB8_1
; AIX32-NEXT:  L..BB8_3: # %entry
; AIX32-NEXT:    li 3, 55
; AIX32-NEXT:    li 4, 66
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    isel 3, 4, 3, 5
; AIX32-NEXT:    blr
entry:
  %0 = atomicrmw max ptr %ptr, i32 %val seq_cst, align 4
  %cmp.not = icmp sgt i32 %0, %val
  %cond = select i1 %cmp.not, i32 66, i32 55
  ret i32 %cond
}

define dso_local signext i16 @atommax2(ptr nocapture noundef %ptr, i16 noundef signext %val) local_unnamed_addr #0 {
; CHECK-LABEL: atommax2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB9_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lharx 5, 0, 3
; CHECK-NEXT:    extsh 5, 5
; CHECK-NEXT:    cmpw 1, 5, 4
; CHECK-NEXT:    bgt 1, .LBB9_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    sthcx. 4, 0, 3
; CHECK-NEXT:    bne 0, .LBB9_1
; CHECK-NEXT:  .LBB9_3: # %entry
; CHECK-NEXT:    li 3, 55
; CHECK-NEXT:    li 4, 66
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    isel 3, 4, 3, 5
; CHECK-NEXT:    blr
;
; AIX32-LABEL: atommax2:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    rlwinm 6, 3, 3, 27, 27
; AIX32-NEXT:    li 7, 0
; AIX32-NEXT:    sync
; AIX32-NEXT:    extsh 5, 4
; AIX32-NEXT:    rlwinm 3, 3, 0, 0, 29
; AIX32-NEXT:    xori 6, 6, 16
; AIX32-NEXT:    ori 7, 7, 65535
; AIX32-NEXT:    slw 8, 5, 6
; AIX32-NEXT:    slw 7, 7, 6
; AIX32-NEXT:    and 8, 8, 7
; AIX32-NEXT:  L..BB9_1: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 9, 0, 3
; AIX32-NEXT:    and 10, 9, 7
; AIX32-NEXT:    srw 10, 10, 6
; AIX32-NEXT:    extsh 10, 10
; AIX32-NEXT:    cmpw 10, 5
; AIX32-NEXT:    bgt 0, L..BB9_3
; AIX32-NEXT:  # %bb.2: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    andc 10, 9, 7
; AIX32-NEXT:    or 10, 8, 10
; AIX32-NEXT:    stwcx. 10, 0, 3
; AIX32-NEXT:    bne 0, L..BB9_1
; AIX32-NEXT:  L..BB9_3: # %entry
; AIX32-NEXT:    srw 3, 9, 6
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 16
; AIX32-NEXT:    extsh 3, 3
; AIX32-NEXT:    cmpw 3, 4
; AIX32-NEXT:    li 3, 55
; AIX32-NEXT:    li 4, 66
; AIX32-NEXT:    iselgt 3, 4, 3
; AIX32-NEXT:    blr
entry:
  %0 = atomicrmw max ptr %ptr, i16 %val seq_cst, align 2
  %cmp.not = icmp sgt i16 %0, %val
  %conv3 = select i1 %cmp.not, i16 66, i16 55
  ret i16 %conv3
}

define dso_local zeroext i8 @atommax1(ptr nocapture noundef %ptr, i8 noundef zeroext %val) local_unnamed_addr #0 {
; CHECK-LABEL: atommax1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sync
; CHECK-NEXT:  .LBB10_1: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    lbarx 5, 0, 3
; CHECK-NEXT:    cmplw 1, 5, 4
; CHECK-NEXT:    bgt 1, .LBB10_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    #
; CHECK-NEXT:    stbcx. 4, 0, 3
; CHECK-NEXT:    bne 0, .LBB10_1
; CHECK-NEXT:  .LBB10_3: # %entry
; CHECK-NEXT:    li 3, 55
; CHECK-NEXT:    li 4, 66
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    isel 3, 4, 3, 5
; CHECK-NEXT:    blr
;
; AIX32-LABEL: atommax1:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    rlwinm 5, 3, 3, 27, 28
; AIX32-NEXT:    li 7, 255
; AIX32-NEXT:    sync
; AIX32-NEXT:    rlwinm 3, 3, 0, 0, 29
; AIX32-NEXT:    xori 5, 5, 24
; AIX32-NEXT:    slw 6, 4, 5
; AIX32-NEXT:    slw 7, 7, 5
; AIX32-NEXT:    and 8, 6, 7
; AIX32-NEXT:  L..BB10_1: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    lwarx 9, 0, 3
; AIX32-NEXT:    and 10, 9, 7
; AIX32-NEXT:    cmplw 10, 6
; AIX32-NEXT:    bgt 0, L..BB10_3
; AIX32-NEXT:  # %bb.2: # %entry
; AIX32-NEXT:    #
; AIX32-NEXT:    andc 10, 9, 7
; AIX32-NEXT:    or 10, 8, 10
; AIX32-NEXT:    stwcx. 10, 0, 3
; AIX32-NEXT:    bne 0, L..BB10_1
; AIX32-NEXT:  L..BB10_3: # %entry
; AIX32-NEXT:    srw 3, 9, 5
; AIX32-NEXT:    lwsync
; AIX32-NEXT:    clrlwi 3, 3, 24
; AIX32-NEXT:    cmplw 3, 4
; AIX32-NEXT:    li 3, 55
; AIX32-NEXT:    li 4, 66
; AIX32-NEXT:    iselgt 3, 4, 3
; AIX32-NEXT:    blr
entry:
  %0 = atomicrmw umax ptr %ptr, i8 %val seq_cst, align 1
  %cmp.not = icmp ugt i8 %0, %val
  %conv3 = select i1 %cmp.not, i8 66, i8 55
  ret i8 %conv3
}
