// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv32 -target-feature +zbc -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s  -check-prefix=RV32ZBC
// RUN: %clang_cc1 -triple riscv64 -target-feature +zbc -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s  -check-prefix=RV64ZBC

#include <riscv_bitmanip.h>

#if __riscv_xlen == 64
// RV64ZBC-LABEL: @clmul_64(
// RV64ZBC-NEXT:  entry:
// RV64ZBC-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.clmul.i64(i64 [[A:%.*]], i64 [[B:%.*]])
// RV64ZBC-NEXT:    ret i64 [[TMP0]]
//
uint64_t clmul_64(uint64_t a, uint64_t b) {
  return __riscv_clmul_64(a, b);
}

// RV64ZBC-LABEL: @clmulh_64(
// RV64ZBC-NEXT:  entry:
// RV64ZBC-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.clmulh.i64(i64 [[A:%.*]], i64 [[B:%.*]])
// RV64ZBC-NEXT:    ret i64 [[TMP0]]
//
uint64_t clmulh_64(uint64_t a, uint64_t b) {
  return __riscv_clmulh_64(a, b);
}

// RV64ZBC-LABEL: @clmulr_64(
// RV64ZBC-NEXT:  entry:
// RV64ZBC-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.clmulr.i64(i64 [[A:%.*]], i64 [[B:%.*]])
// RV64ZBC-NEXT:    ret i64 [[TMP0]]
//
uint64_t clmulr_64(uint64_t a, uint64_t b) {
  return __riscv_clmulr_64(a, b);
}
#endif

// RV32ZBC-LABEL: @clmul_32(
// RV32ZBC-NEXT:  entry:
// RV32ZBC-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.clmul.i32(i32 [[A:%.*]], i32 [[B:%.*]])
// RV32ZBC-NEXT:    ret i32 [[TMP0]]
//
// RV64ZBC-LABEL: @clmul_32(
// RV64ZBC-NEXT:  entry:
// RV64ZBC-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.clmul.i32(i32 [[A:%.*]], i32 [[B:%.*]])
// RV64ZBC-NEXT:    ret i32 [[TMP0]]
//
uint32_t clmul_32(uint32_t a, uint32_t b) {
  return __riscv_clmul_32(a, b);
}

#if __riscv_xlen == 32
// RV32ZBC-LABEL: @clmulh_32(
// RV32ZBC-NEXT:  entry:
// RV32ZBC-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.clmulh.i32(i32 [[A:%.*]], i32 [[B:%.*]])
// RV32ZBC-NEXT:    ret i32 [[TMP0]]
//
uint32_t clmulh_32(uint32_t a, uint32_t b) {
  return __riscv_clmulh_32(a, b);
}

// RV32ZBC-LABEL: @clmulr_32(
// RV32ZBC-NEXT:  entry:
// RV32ZBC-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.clmulr.i32(i32 [[A:%.*]], i32 [[B:%.*]])
// RV32ZBC-NEXT:    ret i32 [[TMP0]]
//
uint32_t clmulr_32(uint32_t a, uint32_t b) {
  return __riscv_clmulr_32(a, b);
}
#endif
