Bug reports, feature requests or code contributions are always very welcome.
To make things easier, here are a few tips:

Reporting bugs, requesting features
-----------------------------------

-   Best way to report bugs and request new features is to use GitHub
    [Issues](https://github.com/mosra/corrade/issues), but you can contact the
    team also any other way — see the [README](README.md) for details.

Code contribution
-----------------

-   Best way to contribute is using GitHub [Pull Requests](https://github.com/mosra/corrade/pulls)
    — fork the repository and make a pull request from a feature branch. You
    can also send patches via e-mail or contact the team in any other way — see
    the [README](README.md) for details.
-   Follow the project coding guidelines. In short — try to match style of the
    surrounding code and avoid any trailing whitespace. When in doubt, consult
    [Coding Style](https://doc.magnum.graphics/corrade/corrade-coding-style.html)
    guidelines.
-   There's a [Developers Guide](https://doc.magnum.graphics/corrade/corrade-developers.html)
    providing step-by-step checklists for almost every development aspect. It's
    not strictly required to follow it to the point, but doing so will save the
    maintainers a lot of time during review and merging.
-   All your code will be released under the project license (see the
    [COPYING](COPYING) file for details), so make sure you and your
    collaborators (or employers) have no problems with it.
