We're proud to announce the new corrective release of darktable, 4.8.1!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-4.8.1](https://github.com/darktable-org/darktable/releases/tag/release-4.8.1).

As always, please don't use the autogenerated tarball provided by
github, but only our tar.xz file. The checksums are:

```
$ sha256sum darktable-4.8.1.tar.xz
???  darktable-4.8.1.tar.xz
$ sha256sum darktable-4.8.1-x86_64.dmg (macOS 13.5)
???  darktable-4.8.1-x86_64.dmg
$ sha256sum darktable-4.8.1-arm64.dmg (macOS 14.0)
???  darktable-4.8.1-arm64.dmg
$ sha256sum darktable-4.8.1-win64.exe
???  darktable-4.8.1-win64.exe
```

When updating from the stable 4.6 series, please bear in
mind that your edits will be preserved during this process, but the new
library and configuration will no longer be usable with 4.6.

You are strongly advised to take a backup first.

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

Since darktable 4.8.0:

- 93 commits to darktable+rawspeed
- 26 pull requests handled
- 1 issues closed


_Please note that the darktable documentation is not currently complete for release 4.8
and contributions are greatly appreciated. Please see the
[project documentation](https://github.com/darktable-org/dtdocs#contributing)
for more information on how to contribute._

## The Big Ones

The following is a summary of the main features added to darktable
4.8. Please see the user manual for more details of the individual
changes (where available).

- n/a

## Performance Improvements

- n/a

## Other Changes

- n/a

## Bug Fixes

- Fixed export without high quality sampling but with up-scaling
  activated.

- Fixed support for all vectorscope modes when using CMYK profiles as
  for softproofing.

- Fixed empty lighttable when importing from command-line. Now
  darktable opens lighttable on first filmroll when importing from
  command-line.

- Fixed color picker area resizing using corners when heavy distorting
  is applied into image.

- Fixed wrong cropping in rotate and perspective module with strong
  rotation and automatic cropping set to "original format".

- Fixed possible color shift (pink) when using the Retouch module with
  the embedded lens correction module.

- Fixed histogram display when using a color picker area on a rotated
  or flipped image.

- Fixed a crash while using the -d imageio option.

- Fixed large image exports due to a bug in finalscale module.

- Fixed failure to load valid JPEG2000 files with unspecified color
  space.

- Fixed image jump if collection is empty.

## Lua

### API Version

- API version is now 9.3.0

### Bug Fixes

### Add action support for Lua

### Other Lua changes

- n/a

## Notes

- Exporting with up-scaling and whithout using the high quality option
  will result in corrupt images.

- When exporting to AVIF, EXR, JPEG XL, or XCF, selecting specific
  metadata (e.g. geo-tag or creator) is not currently possible. For
  AVIF, EXR, JPEG XL, and XCF formats, darktable will not include any
  metadata fields unless the user selects all of the checkboxes in the
  export module's preference options.

- In order to support the correct display of numbers in darktable, the
  minimum supported Gtk version has had to be increased to
  3.24.15. For people who need to build darktable with an older
  version, this can be achieved by removing line 241 of the
  `darktable.css` file on your system. See
  https://github.com/darktable-org/darktable/issues/13166.

- Release 4.8 drops support for macOS versions older than 13.5.

## Changed Dependencies

### Mandatory

- Minimum libpng version 1.5.x is now required
- Bump Exiv2 requirement to 0.27.2
- Minimum pugixml version 1.5 is now required
- Minimum libcurl version 7.56 is now required

### Optional

- n/a

## RawSpeed changes

- Fujifilm X-Trans 4 based and newer cameras now use the vendor supplied crop

## Camera support, compared to 4.6

### Base Support

- Canon EOS R100 (requires LibRaw 202403 and later)
- Canon EOS R50 (requires LibRaw 202403 and later)
- Canon EOS R6 Mark II (requires LibRaw 202403 and later)
- Canon EOS R8 (requires LibRaw 202403 and later)
- Canon EOS Ra (requires LibRaw 202403 and later)
- Fujifilm FinePix S9600fd
- Fujifilm X100VI (compressed)
- GoPro FUSION (DNG)
- Leica SL3 (DNG)
- OM System OM-1 Mark II
- Panasonic DC-TZ95D (4:3)
- Panasonic DMC-FX150 (4:3, 3:2, 16:9)
- Panasonic DMC-FZ28 (3:2)
- Phase One P25+
- Phase One P45+
- Ricoh GR III HDF (DNG)
- Ricoh GR IIIx HDF (DNG)
- Sony ILCE-9M3
- Sony UMC-R10C

### White Balance Presets

- Canon EOS R6 Mark II (requires LibRaw 202403 and later)
- Fujifilm X-H2
- OM System OM-1 Mark II
- OM System OM-5

### Noise Profiles

- Canon EOS R6 Mark II (requires LibRaw 202403 and later)
- Fujifilm GFX 50R
- OM System OM-1 Mark II
- OM System OM-5
- Phase One IQ180
- Sony ILCE-9M3
- Sony ZV-1

### Missing Compression Mode Support

- Apple ProRAW DNGs
- CinemaDNG lossless (Blackmagic, some DJI, etc.) and lossy (Blackmagic)
- DNG 1.7 using JPEG XL (Adobe enhanced, Samsung Expert RAW)
- Fujifilm lossy RAFs
- Nikon high efficiency NEFs
- OM System 14-bit high resolution ORFs
- Sony downsized lossless ARWs ("M" for full-frame, "S" for full-frame & APS-C)

### Suspended Support

Support for the following cameras is suspended because no samples are available on https://raw.pixls.us:

- Creo/Leaf Aptus 22(LF3779)/Hasselblad H1
- Fujifilm IS-1
- Kodak EasyShare Z980
- Leaf Aptus-II 5(LI300059)/Mamiya 645 AFD
- Leaf Credo 60
- Leaf Credo 80
- Minolta DiMAGE 5
- Olympus SP320
- Phase One IQ250
- Sinar Hy6/ Sinarback eXact
- ST Micro STV680

## Translations

- Czech
- German
- European Spanish
- Finnish
- French
- Hungarian
- Italian
- Japanese
- Dutch
- Polish
- Brazilian Portuguese
- Russian
- Slovenian
- Albanian
- Ukrainian
- Chinese (Simplified)
- Chinese (Traditional)
