# 0.81.0 release notes

**Release date:** 2024-02-14

## Summary

Hey DOS enthusiasts! We are proud to present DOSBox Staging 0.81.0 to you, a
rather substantial release containing a large number of exciting new features
and improvements!

For the first time in history, DOSBox comes with built-in authentic CRT
monitor emulation that just works out-of-the-box without any manual
configuration required. The VGA code has been overhauled, shortcuts and
simplifications have been removed, and now we're defaulting to accurate
per-scanline emulation and double scanning in all VGA, SVGA, and VESA modes.
Integer scaling options have been added, it's now possible to stretch the
image to fullscreen, force any arbitrary aspect ratio, or even emulate
the horizontal and vertical stretch controls of CRT monitors in real-time.
Screenshots have been made aspect ratio correct by default, and image
capturing has become multi-threaded, so it no longer causes audio hiccups and
micro-pauses. Video capturing has been made about three times more performant.
Oh, almost forgot: we've also added 3dfx Voodoo 1 support for the fans of those
late 90s 3D DOS games! :sunglasses: :metal:

Well, that's just the video side of things. We've added support for the
ultra-rare IBM Music Feature Card, dealing with Roland MT-32 ROMs has become
much easier, plus we've made numerous MIDI-related improvements as well. Not
to mention all the mouse and joystick enhancements and fixes, the addition of
a few missing DOS commands, improved filesystem integration, fixing some
long-standing annoying shortcomings of the FPU emulation in non-x86 builds,
taking localisation support to the next level, and the list just goes on and
on...

Read on to learn more!


## How to upgrade

Start by downloading the latest version, then make sure to upgrade your
primary configuration as described below.

### Downloads

<div class="compact" markdown>

- [Windows](../windows.md)
- [macOS](../macos.md)
- [Linux](../linux.md)

</div>


### Upgrading your primary configuration

Since config settings might be renamed, altered, or deprecated between
releases, it's best to let DOSBox Staging write the new default primary config
on the first launch, then reapply your old settings manually.

Start by backing up your existing primary config. This is where to find
it on each platform:

<div class="compact" markdown>

| <!-- --> | <!-- -->
|----------|----------
| **Windows**  | `C:\Users\%USERNAME%\AppData\Local\DOSBox\dosbox-staging.conf`
| **macOS**    | `~/Library/Preferences/DOSBox/dosbox-staging.conf`
| **Linux**    | `~/.config/dosbox/dosbox-staging.conf`

</div>

You can also execute DOSBox Staging with the `--printconf` option to have the
location of the primary config printed to your console.

After backing up the existing primary config, simply start the new version---a
new `dosbox-staging.conf` will be written containing the new defaults and
updated setting descriptions.

!!! note "Portable mode notes"

    In portable mode, `dosbox-staging.conf` resides in the same folder as your
    DOSBox Staging executable. The migration steps for portable mode users are
    as follows:

      - Unpack the new version into a _new_ folder (this is important).
      - Create a new _empty_ `dosbox-staging.conf` file in the new folder to
        enable portable mode.
      - Launch the new version.

    DOSBox Staging will write the new defaults to the empty
    `dosbox-staging.conf` file. After this, you carry over your settings from
    the old primary config manually.

### After upgrading

Look out for deprecation warnings in the logs (in yellow/orange colour) and
update your configs accordingly.


## New Getting Started guide

Due to popular demand, we've added a new [Getting Started
guide](../../getting-started/introduction.md) to the front page. The guide
will teach you how to set up your own DOSBox Staging environment from scratch
through easy-to-follow instructions with lots of pretty pictures. It adopts a
learn-by-doing approach to ensure you'll have fun while setting up famous
classic DOS games.

Although it's primarily intended for beginners, we guarantee even our most
experienced long-time users will learn a few tricks from it!


## Graphics

### Authentic adaptive CRT emulation

We are happy to announce that we've removed all CRT shaders previously bundled
with our releases.

Every single one of them.

_What the @^$*%#!!!?? Have these guys gone mad??!_

The reason for removing them is that they got replaced with something far
better: a set of no less than **24 CRT shaders** tweaked to perfection to
emulate the glorious CRT monitors of the past, including authentic
recreations of Hercules, CGA, monochrome CGA, composite CGA, EGA, and VGA
monitors.

24 new CRT shaders sound a lot---how will someone not intimately familiar with
CRT monitor technology and PC history know which is the best for a particular
game? Well, the good news is you don't need to know---DOSBox Staging will
automatically pick the most appropriate shader based on the current DOS video
mode and viewport resolution. High-DPI and displays from 720p to 4K
resolutions are fully supported, and absolutely no manual configuration is
required!

The following magic `glshader` options have been introduced:

- `crt-auto` — This is the new default---an adaptive CRT shader that
  prioritises developer intent and how people experienced the game at the
  time of release. This means VGA games will be double-scanned, like on a real
  VGA monitor, EGA games will appear single-scanned with "fat scanlines", and
  so on, regardless of the `machine` setting.

- `crt-auto-machine` — This one emulates a fixed CRT monitor
  based on your `machine` setting. So CGA and EGA modes on a VGA machine will
  always appear double-scanned with big chunky pixels, just like on a real VGA
  adapter and monitor.

- `crt-auto-arcade` — This fantasy option does not exist in real life, but it
  can be a lot of fun! It emulates a 15 kHz arcade or home computer monitor
  with thick scanlines in low-resolution modes. Perfect for playing DOS VGA
  ports of Amiga and Atari ST games to experience them with MT-32 or SC-55
  sound from a strange parallel universe! 😎

Adaptive CRT shaders work in tandem with the [new integer scaling
feature](#new-integer-scaling-modes) to achieve the most optimal results. The
default `auto` setting for `integer_scaling` auto-enables vertical integer
scaling for the adaptive CRT shaders; this avoids unwanted interference
patterns that can result from non-integer vertical scaling ratios.

Here are the shaders in action at 4K resolution (make sure to click on the
zoomed-in images if the cursor turns into a magnifying glass to view them at
100% magnification):

<div class="image-grid" markdown>

<figure markdown>
  <a class="glightbox" href="https://archive.org/download/dosbox-staging-v0.81.0-gods/gods.jpg" >
    ![Gods --- 320&times;200 VGA](https://archive.org/download/dosbox-staging-v0.81.0-gods/gods-small.jpg){ loading="lazy" .skip-lightbox }
  </a>

  <figcaption markdown>
  Gods --- 320&times;200 VGA
  </figcaption>
</figure>
<figure markdown>
  <a class="glightbox" href="https://archive.org/download/dosbox-staging-v0.81.0-ultima-underworld/ultima-underworld.jpg" >
    ![Ultima Underworld: The Stygian Abyss -- 320&times;200 VGA](https://archive.org/download/dosbox-staging-v0.81.0-ultima-underworld/ultima-underworld-small.jpg){ loading=lazy .skip-lightbox }
  </a>

  <figcaption markdown>
  Ultima Underworld: The Stygian Abyss ---<br>320&times;200 VGA
  </figcaption>
</figure>

</div>
<div class="image-grid" markdown>

<figure markdown>
  <a class="glightbox" href="https://archive.org/download/dosbox-staging-v0.81.0-celtic-tales/celtic-tales.jpg" >
    ![Celtic Tales: Balor of the Evil Eye -- 640&times;480 VGA](https://archive.org/download/dosbox-staging-v0.81.0-celtic-tales/celtic-tales-small.jpg){ loading=lazy .skip-lightbox }
  </a>

  <figcaption markdown>
  Celtic Tales: Balor of the Evil Eye --- 640&times;480 VGA
  </figcaption>
</figure>
<figure markdown>
  <a class="glightbox" href="https://archive.org/download/dosbox-staging-v0.81.0-dark-seed/dark-seed.jpg" >
    ![Dark Seed --640&times;350 EGA](https://archive.org/download/dosbox-staging-v0.81.0-dark-seed/dark-seed-small.jpg){ loading=lazy .skip-lightbox }
  </a>

  <figcaption markdown>
  Dark Seed --- 640&times;350 EGA
  </figcaption>
</figure>

</div>
<div class="image-grid" markdown>

<figure markdown>
  <a class="glightbox" href="https://archive.org/download/dosbox-staging-v0.81.0-monkey-island/monkey-island.jpg" >
    ![The Secret of Monkey Island -- 320&times;200 EGA](https://archive.org/download/dosbox-staging-v0.81.0-monkey-island/monkey-island-small.jpg){ loading=lazy .skip-lightbox }
  </a>

  <figcaption markdown>
  The Secret of Monkey Island --- 320&times;200 EGA
  </figcaption>
</figure>
<figure markdown>
  <a class="glightbox" href="https://archive.org/download/dosbox-staging-v0.81.0-space-quest-iii/space-quest-iii.jpg" >
    ![Space Quest III: The Pirates of Pestulon -- 320&times;200 EGA](https://archive.org/download/dosbox-staging-v0.81.0-space-quest-iii/space-quest-iii-small.jpg){ loading=lazy .skip-lightbox }
  </a>

  <figcaption markdown>
  Space Quest III: The Pirates of Pestulon --- 320&times;200 EGA
  </figcaption>
</figure>

</div>
<div class="image-grid" markdown>

<figure markdown>
  <a class="glightbox" href="https://archive.org/download/dosbox-staging-v0.81.0-wizardry/wizardry.jpg" >
    ![Wizardry: Proving Grounds of the Mad Overlord -- 320&times;200 CGA](https://archive.org/download/dosbox-staging-v0.81.0-wizardry/wizardry-small.jpg){ loading=lazy .skip-lightbox }
  </a>

  <figcaption markdown>
  Wizardry: Proving Grounds of the Mad Overlord --- 320&times;200 CGA
  </figcaption>
</figure>
<figure markdown>
  <a class="glightbox" href="https://archive.org/download/dosbox-staging-v0.81.0-smoker-by-fairfax/smoker.jpg" >
    ![Smoker by Fairfax --320&times;200 15kHz "arcade" shader](https://archive.org/download/dosbox-staging-v0.81.0-smoker-by-fairfax/smoker-small.jpg){ loading=lazy .skip-lightbox }
  </a>

  <figcaption markdown>
  Smoker by Fairfax ---<br>320&times;200 15kHz "arcade" shader
  </figcaption>
</figure>

</div>
<div class="image-grid" markdown>

<figure markdown>
  <a class="glightbox" href="https://archive.org/download/dosbox-staging-v0.81.0-zak-mckracken/zak.jpg" >
    ![Zak McKracken and the Alien Mindbenders -- 320&times;200 CGA composite](https://archive.org/download/dosbox-staging-v0.81.0-zak-mckracken/zak-small.jpg){ loading=lazy .skip-lightbox }
  </a>

  <figcaption markdown>
  Zak McKracken and the Alien Mindbenders ---<br>320&times;200 CGA composite
  </figcaption>
</figure>
<figure markdown>
  <a class="glightbox" href="https://archive.org/download/dosbox-staging-v0.81.0-starblade/starblade.jpg" >
    ![Starblade -- 720&times;348 Hercules](https://archive.org/download/dosbox-staging-v0.81.0-starblade/starblade-small.jpg){ loading=lazy .skip-lightbox }
  </a>

  <figcaption markdown>
  Starblade --- 720&times;348 Hercules
  </figcaption>
</figure>

</div>


If you don't like CRT shaders, no problem---simply set `glshader` to `sharp`
in your config to regain your sharp little rectangles back. Naturally, you can
continue to use regular GLSL shaders like before. The deprecated CRT shaders
are still available as a [separate download](https://archive.org/download/dosbox-staging-legacy-svn-shaders/svn-shaders.zip), should you ever need them.

The adaptive shaders are largely based on one of Hyllian's excellent CRT
shaders, so big thanks to him for laying a solid foundation for this feature.

!!! note "Why were the old CRT shaders  removed?"

    One problem with the previously bundled CRT shaders was that they lacked
    proper documentation, so it wasn't clear which shader was meant for what
    monitor resolution (some were tuned for 1080p, some for 4K, etc.)
    Moreover, most were designed to emulate arcade monitors or TV sets from
    the 80s and early 90s; these displays had very different characteristics
    than the much higher quality PC monitors. Because of all this, many people
    were rather unimpressed by them and gave up on CRT shaders altogether as a
    result.


### Accurate VGA emulation

Previously, DOSBox rendered the emulated VGA output without double scanning,
and only in quarter-frame chunks. These optimisation steps were necessary 20
years ago, but now we're doing proper double scanning and accurate
per-scanline rendering in all VGA, SVGA, and VESA video modes. It turns out
this only causes a ~7% performance drop on modern hardware in benchmarks,
which is not much for such a significant improvement.

Double scanning and per-scanline rendering were available via the special
`vgaonly` machine type before, but that was incompatible with VESA modes and
it truncated the 18-bit VGA DAC colour output to 16-bits only, causing banding
in certain scenes. We no longer do that either---VGA output is now always
rendered at full 18-bit precision.

We use 9&times;16 fonts on all emulated VGA adapters now which is how most
people remember VGA text modes. You can still force 8&times;16 fonts on VGA by
enabling the new `vga_8dot_font` setting.

These improvements absorb the benefits of `vgaonly` into the base VGA
emulation, making the `vgaonly` machine type unnecessary, so it has been
deprecated (it's still recognised as an alias for `svga_paradise` for backward
compatibility).

Additionally, all CGA, PCjr, and Tandy text modes are now properly
single-scanned when using their respective machine types. A few CGA, PCjr, and
Tandy graphics modes appeared with the incorrect aspect ratio before;
these have all been fixed up.

The logging of video modes has become a lot more accurate; now we're
consistently logging the video standard the mode first appeared in (e.g., CGA
modes are always logged as CGA, regardless of the emulated display adapter in
use), and the logged pixel aspect ratios are now always correct.


### 3dfx Voodoo 1 emulation

Aaron Giles' 3dfx Voodoo emulation originally written for the MAME project has
finally found its way into Staging. During its journey, it has picked up a few
enhancements, namely a few changes by **kekko** for the DOSBox integration,
plus some multi-threading improvements by Bernhard Schelling (also
known as **psyraven**).

We've added support for emulating a Voodoo 1 board with either a 2 MB Frame
Buffer Interface (FBI) and one 2 MB Texture Mapping Unit (TMU), or a 4 MB FBI
+ dual 2x4 MB TMU configuration.

The default refresh rate for the Voodoo is 60 Hz, but it's possible to force
any custom refresh rate via `dos_rate`.

Please refer to the new `[voodoo]` config section to learn more.

!!! note "Low vs high-level emulation"

    Note this is purely software-based _low-level emulation_; we're emulating
    the 3dfx Voodoo 1 hardware accurately in software, which requires a beefy
    host CPU. We don't support _high-level emulation_ where the Glide API
    calls are transformed and passed through to modern 3D APIs for the actual
    rendering (e.g., OpenGL, Vulkan, Direct3D, etc.)


### New integer scaling modes

A new `integer_scaling` setting has been introduced to constrain the
horizontal or vertical scaling factor to integer values when upscaling the
image to fit it into the viewport. For example, you can enable vertical
integer scaling now with the following config:

```ini
[render]
integer_scaling = vertical
```

The correct aspect ratio will always be maintained, so in this case, the
horizontal scaling factor might become fractional. With the `sharp` shader
this is not a problem as the "interpolation band" can only be up to 1 pixel
wide at the two sides of the pixels---still plenty sharp, especially on 1440p
or 4K. Then with the CRT shaders, non-integer horizontal scaling matters even
less; it's practically a non-issue.

`integer_scaling` is set to `auto` by default which only enables vertical
integer scaling for the adaptive CRT emulation, otherwise, it's disabled.

This replaces the so-called "pixel-perfect mode" (`openglpp` and `texturepp`
output modes) which prioritised 100% sharp pixels at the expense of aspect
ratio correctness. That feature had been the source of endless confusion even
among experienced users as most of the time it could only _approximate_ the correct
aspect ratio, and even that varied semi-randomly based on the current viewport
size and monitor resolution. Our reasons for removing it are documented in detail
[here](https://github.com/dosbox-staging/dosbox-staging/issues/2448).


### Aspect ratio correct image captures

Previously, even if you had aspect ratio correction enabled, the captured
screenshots always contained the raw, non-corrected image. This has been
flipped around: the new default is capturing images in the same aspect
ratio that you see on your screen.

Taking raw and rendered (post-shader) screenshots continues to be an option,
of course. The following three image capture formats have been introduced:

- `upscaled` — The image is captured in the same aspect ratio you see on
  the screen. Upscaled captures always use sharp pixels, regardless of the
  shader in use.

- `rendered` — Capture the post-rendered, post-shader image---an exact
  pixel-by-pixel replica of what you see on the screen.

- `raw` — Capture the raw image; this always results in square pixels. So
  for 320&times;200 VGA or EGA content, you'll always get a 320&times;200 PNG
  file, no matter what.

You can configure the capture formats of the default screenshot action with
the following setting:

```ini
[capture]
default_image_capture_formats = upscaled raw
```

With this setting, two PNG files will be written in raw and upscaled formats
whenever you press the ++ctrl+f5++ image capture hotkey (++cmd+f5++ on macOS).

Keybindings for taking single screenshots in specific formats are also
available.

!!! note "Interpolation in upscaled mode"

    The image is integer or bilinear-sharp upscaled to around 1200 pixels of
    vertical resolution in the new `upscaled` capture mode.  For example:

    - 320x200 content is upscaled to 1600x1200 (5:6 integer scaling)
    - 640x480 to 1920x1440 (3:3 integer scaling)
    - 640x350 to 1400x1050 (3x vertical and 2.1875x horizontal scaling)

    The resulting PNG files are only about 30% bigger than raw screenshots on
    average. This is a rather small price to pay for aspect ratio correctness.


!!! info "Aspect ratio correctness, 2023 edition"

    Fact: most 320&times;200 and similar low-resolution DOS games _absolutely
    need_ aspect ratio correction enabled to appear correctly. While _some_
    games benefit from forcing square pixels, these only account for about
    1-2% of the total DOS gaming catalogue. That's the reason why DOSBox
    Staging performs aspect ratio correction out-of-the-box.

    The sad reality of the situation today is that the vast majority of
    320&times;200 DOS games are displayed in the wrong aspect ratio with
    square pixels on various websites and video-sharing services. Emulators
    that don't default to aspect ratio correct output and screen captures have
    undoubtedly contributed to this widespread problem. Aspect ratio correct
    screen captures by default is our attempt to play our part in remedying
    the situation, and hopefully reversing it with time.


!!! warning "Raw capture breaking changes"

    Previously, raw image captures width or height doubled certain DOS video
    modes. There wasn't much rhyme or reason to it. Now raw captures always
    contain the actual emulated DOS framebuffer-level image (e.g.,
    320&times;200 modes get captured as 320&times;200 PNG files, regardless of
    any other settings).

    The only exceptions are the composite CGA, PCjr, and Tandy modes. These
    modes are a bit special as internally they're rendered width-doubled to
    have enough horizontal resolution for representing composite artifacts.
    Therefore, we write raw image captures of composite modes width-doubled to
    retain all rendered information (e.g., the 640&times;200 composite CGA
    mode will result in a 1280&times;200 raw image, which might be surprising
    at first, but it's intended and correct behaviour).



### Supercharged image and video capturing

The optimised _zlib-ng_ library has been added to mitigate the video capturing
performance hit incurred by our new more accurate VGA emulation approach
compared to 0.80.1. In fact, _zlib-ng_ not only makes up the difference but
speeds video capturing up by another **factor of three (!)** versus 0.80.1!
This makes a huge difference on older CPUs, but even on fast modern machines,
you can now capture videos at higher resolutions without glitches.

Additionally, image capturing is now being performed in multiple background
threads. This eliminates emulation micro-pauses and sound glitches even when
rapidly spamming the screenshot hotkey. This was a problem even on fast
machines with rendered post-shader captures at 4K resolution.


### Aspect ratio and viewport enhancements

Stretching the image to completely fill the screen has been an often requested
feature (e.g., to play text adventures without black bars on the sides). Now
we're giving you not only that but an entirely new mechanism to apply
arbitrary aspect ratios, zoom into the DOS content, and even emulate the
horizontal and vertical stretch controls of CRT monitors of yore! :sunglasses:

The key element of the feature is the new `aspect = stretch` mode which
stretches the image to the extents of the viewport. For example, to make a
game completely fill the screen, use the following config:

```ini
[sdl]
fullscreen = on

[render]
aspect = stretch
viewport = fit
integer_scaling = off
```

The second piece of the puzzle is the new `relative` mode added to the
`viewport` setting (`viewport_resolution` has been renamed to `viewport` and
moved to the `[render]` section). In relative mode, the viewport is a 4:3
aspect ratio rectangle fit into the window or screen as the starting point,
which is then scaled by the specified horizontal and vertical stretch factors.
The resulting viewport is allowed to extend beyond the edges of the window or
the screen, so this can be used to "zoom" into the image while forcing
arbitrary aspect ratios.

For example, you can aspect ratio correct lazy Hercules conversions that just
reused the EGA/VGA assets and make them fill the screen better by zooming in a
little. The following example illustrates this in Prince of Persia in Hercules
mode:

```ini
[render]
aspect = stretch
viewport = relative 112% 173%
integer_scaling = off
```

You can use the _Stretch Axis_, _Inc Stretch_, and _Dec Stretch_ hotkey
actions to set the stretching in real-time (unbound by default). The current
viewport setting is logged, so you can simply copy it to your config.



<div class="image-grid" markdown>

<figure markdown>
  ![Price of Persia (default)](https://archive.org/download/dosbox-staging-v0.81.0-prince-of-persia/pop-hercules.png){ loading=lazy }

  <figcaption markdown>
  Prince of Persia without any custom stretching
  </figcaption>
</figure>

<figure markdown>
  ![Price of Persia (aspect ratio corrected )](https://archive.org/download/dosbox-staging-v0.81.0-prince-of-persia/pop-hercules-aspect-corrected.jpg){ loading=lazy }

  <figcaption markdown>
  Prince of Persia with `aspect = stretch` and `viewport = relative 112% 173%`
  </figcaption>
</figure>

</div>


### Fix "black vertical bars" video corruption issue

This is a fix for the "black vertical bars" video corruption issue seen on a
few late 90s games and demos that require Pentium CPUs. Due to some fairly
intricate technical details to do with 80-bit x87 FPU emulation, the issue
does not manifest in Intel builds, but it does in all non-Intel builds when
using the non-dynamic cores.

A non-exhaustive list of affected programs:

**Games**

<div class="compact" markdown>
- [Carmageddon (1997)](https://www.mobygames.com/game/367/carmageddon/)
- [Motor Mash (1997)](https://www.mobygames.com/game/57275/motor-mash/)
- [Peter Sampras Tennis (1997)](https://www.mobygames.com/game/7250/pete-sampras-tennis-97/)
</div>

**Demos**

<div class="compact" markdown>
- [Sunflower by Pulse (1997)](https://www.pouet.net/prod.php?which=85)
- [Multikolor by kolor (1997)](https://www.pouet.net/prod.php?which=861)
- [toontown by kolor (1997)](https://m.pouet.net/prod.php?which=315)
</div>

<div class="image-grid" markdown>

<figure markdown>
  ![Multikolor by kolor --- Black vertical bars issue](https://archive.org/download/dosbox-staging-v0.81.0-multikolor/multikolor-buggy.png){ loading=lazy }

  <figcaption markdown>
  Multikolor by kolor --- Black vertical bars issue
  </figcaption>
</figure>

<figure markdown>
  ![Multikolor by kolor --- After the fix)](https://archive.org/download/dosbox-staging-v0.81.0-multikolor/multikolor-fixed.png){ loading=lazy }

  <figcaption markdown>
  Multikolor by kolor --- After the fix
  </figcaption>
</figure>

</div>



### New deinterlacing shader for FMV games

Schlocky 90s FMV titles are the guilty pleasure of every true retro-gamer
(we're no different, so zero judging!) Unfortunately, many of these games are
plagued by a weird trick: the video footage is often displayed with
alternating black "interlace lines". This just doesn't look very good on
modern ultra-sharp flat screens, and upscaling such content with non-integer
scaling ratios often causes very ugly interpolation artifacts.

To restore cosmic balance, we've introduced a pair of "deinterlacing" shaders,
building upon the work of Ove Kaaven:

- `misc/fixvideo` --- This intelligently doubles scanlines that have a black
  line beneath them. Works well with non-integer scaling ratios.

- `misc/fixvideo-scanlines` --- Similar to the first one, but this retains a
  subtle scanline look to improve the "perceptual resolution" of the video
  footage. This one absolutely needs vertical integer scaling enabled!

Now you can enjoy your 90s FMV shlock in its full gory glory! :sunglasses:

<div class="image-grid" markdown>

<figure markdown>
  ![Angel Devoid: Face of the Enemy --- raw output](https://archive.org/download/dosbox-staging-v0.81.0-fmv-deinterlacing/angel-devoid-raw.png){ loading=lazy }

  <figcaption markdown>
  Angel Devoid: Face of the Enemy --- Raw output
  </figcaption>
</figure>
<figure markdown>
  ![Angel Devoid: Face of the Enemy --- raw output](https://archive.org/download/dosbox-staging-v0.81.0-fmv-deinterlacing/angel-devoid-fixvideo.png){ loading=lazy }

  <figcaption markdown>
  With the `misc/fixvideo` shader
  </figcaption>
</figure>
<figure markdown>
  ![Gods -- 320&times;200 VGA](https://archive.org/download/dosbox-staging-v0.81.0-fmv-deinterlacing/angel-devoid-fixvideo-scanline.png){ loading=lazy }

  <figcaption markdown>
  With the `misc/fixvideo-scanline` shader
  </figcaption>
</figure>

</div>

### Other graphics-related changes

- OpenGL Pixel Buffer Object (PBO) support was dropped to enhance performance
  and efficiency. This will result in reduced energy use, reduced thermal
  load, and significantly improved performance on single-board computers,
  Intel HD Graphics, and AMD APUs.

- The keymapper now supports high DPI screens.

- We've added support for disabling the screen via the clocking mode register.
  This fixes some visual glitches in **Alien Carnage**.

- A new `interpolation/catmull-rom` shader has been added. This implements an
  upscaling method that looks better than the bilinear interpolation option
  you get with the `none` shader.

- Various monochrome mode fixes & improvements affecting Hercules and
  monochrome CGA emulation have been made. Most notably, the manual "bright
  mode" hotkey to toggle between the two monochrome palette variants has been
  removed. Now the appropriate palette is auto-selected based on whether we're
  in a text or graphics mode.

- A corner case delayed display regression was fixed in VFR presentation mode.
  The presentation mode auto-selection criteria have also been refined to
  achieve optimal results with a wider range of monitor, driver, and operating
  system combinations.

- The legacy `surface` output mode has been removed. The new fallback option
  is the `texture` output mode that automatically selects the best
  available rendering backend via SDL (a purely CPU-based non-accelerated
  backend is available too). The preferred and recommended output mode is
  still OpenGL, as it always has been.

- Fixed a regression where some colours had a very subtle greenish tint on
  emulated VGA adapters. In practice, this was only noticeable on dark neutral
  grey colours.

- Reloading shaders at runtime via the hotkey action now works a lot more
  reliably.

- Nearest-neighbour output modes aren't treated any differently anymore when
  determining the default window size.

- sRGB GLSL pragmas now work correctly. Somewhat embarrassingly, the `sharp`
  shader was advertised to be gamma-correct more than a year ago, but sadly
  that was never the case---until this fix.

- Introduction of the `use_npot_texture` GLSL pragma to request non-power-of-two-texture.

- Introduction of the `force_single_scan` and `force_no_pixel_doubling` GLSL
  pragmas to force no line doubling and no pixel doubling in VGA modes,
  respectively. This might come in handy for certain shaders that need to work
  on the "raw" pixel data, such as upscalers.

- We've changed the VESA BIOS branding to _DOSBox Staging_ (because we can
  :sunglasses:)


??? note "Full PR list of graphics-related changes"

    - (S)VGA/VESA square pixel mode fix/cleanup (#2583)
    - Adaptive CRT shader compatibility fixes for really old GPUs (#3172)
    - Adaptive shader fixes (#2866)
    - Add `crt-auto-arcade-sharp` adaptive CRT shader (#3083)
    - Add `misc/fixvideo.glsl` OpenGL shader (#2442)
    - Add crt/aperture.mono shader variant (#2393)
    - Add deinterlacing shader variants (#3200)
    - Add new glshader/misc dir to the Meson build (#2443)
    - Add support for disabling screen via the clocking mode register, fixes #2838 (#2842)
    - Always log OpenGL shader and program info logs if they're non-empty (#3121)
    - Aspect ratio and viewport improvements (#3124)
    - Authentic adaptive CRT shaders (#2777)
    - Auto-disable the integer scaling feature if the image is smaller than… (#2588)
    - Capture modularisation/cleanup (#2451)
    - Change VESA BIOS branding to 'DOSBox Staging' (#2712)
    - Clean up OpenGL attribute init (#3111)
    - De-SDL voodoo threading (#2568)
    - Deprecate machine type `vgaonly` (#2398)
    - Disable framebuffer acceleration for debugger (#2477)
    - Don't auto-disable OpenGL for debugger-enabled builds on Linux (#2480)
    - Don't restrict text video modes to the VFR presentation mode (#2286)
    - Double-scanning support for VESA modes, accurate mode change logging, `vga_draw.cpp` rework & many other improvements (#2654)
    - Drop OpenGL PBO support (#3099)
    - Enable vsync by default (#2373)
    - Fix "-fullscreen" argument on Wayland (#2688)
    - Fix CGA composite regression (#2662)
    - Fix Tandy support for Ninja (1986) (#2225)
    - Fix VESA 256 / 8-bit in Windows 3.1 (#2569)
    - Fix a couple aspect ratios (#2612)
    - Fix a couple issues from the `vgaonly` PR (#2424)
    - Fix a crash when using `glshader = crt-auto-machine` (#3077)
    - Fix a window size regression on macOS (#2374)
    - Fix altered shader pragmas not taking an effect when reloading the shader (#2736)
    - Fix comment describing BGRX8888 PixelFormat (#2766)
    - Fix compilation failures on *BSD and colour rendering on big-endian platforms (#3155)
    - Fix const issue writing a png with png12 (#2740)
    - Fix double-scanning & pixel-doubling handling in `openglnb` output mode (#3092)
    - Fix fallback shader scaling for adaptive CRT shaders (#2840)
    - Fix flicker in some games due to mouse driver breaking double buffering (#2867)
    - Fix image capture indices always starting from 1 (#2656)
    - Fix incorrect pixel aspect ratio calculation for all text modes (#2570)
    - Fix infinite recursion problem at startup on Pop OS 22.04 and SDL 2.0.20 (#3209)
    - Fix invalid default config value for voodoo_memsize (#2744)
    - Fix mapper screen for high dpi (#2708)
    - Fix raw image & video capture for 160x200 16-colour Tandy/PCjr modes  (#3185)
    - Fix raw video capture so it always writes non-double-scanned raw output (#3177)
    - Fix regression in Build Engine games (3Dfx mode) (#2432)
    - Fix regression in VGA draw's wrapped line case (#2441)
    - Fix regression in palettized VGA line draw function (#2491)
    - Fix regressions in some video modes' aspect and line-counts (#2445)
    - Fix sRGB GLSL pragmas (#2665)
    - Fix spelling mistakes in 'voodoo_*' config descriptions (#2859)
    - Fix the aspect ratio of 40-column 00h and 01h BIOS text modes (#2852)
    - Fix the calculation of vga.draw.lines_scaled when double scanning (#2806)
    - Fix vertical bars due to FILD/FIST memcpy trick (#3151)
    - Fixes and cleanup of PCI BIOS (#2731)
    - Force OpenGL renderer backend for keymapper (#2768)
    - Give Voodoo a gentle push to get it passing CI (#2710)
    - Ignore extensions when finding highest capture index (#2946)
    - Image capture enhancements mega-PR — Godzilla Edition©®™ 🦖 (#2503)
    - Implement Voodoo usability fixes (#3103)
    - Implement integer viewport scaling (#2456)
    - Improve the "mode 1" deinterlace method (#3192)
    - Include low width resolution in VGA scanning citeria (#2582)
    - Introduce PixelFormat enum (#2735)
    - Let the VESA 8-bit mode draw lines from the DAC palette (#2494)
    - Limit consecutive duplicate frames in VFR presentation mode (#3004)
    - Make triangle_worker members threadsafe (#2434)
    - Minor voodoo performance tweaks (#2435)
    - Monochrome mode fixes & improvements (#2769)
    - Only capture the visible image in rendered image capture mode (#3194)
    - Perform console cursor and text calls via interrupt (#3113)
    - Port Voodoo support with multi-threaded software backend (#2410)
    - Present VFR duplicate frames on a tempo (#2379)
    - Refine when `presentation mode = auto` uses throttled mode (#2818)
    - Reload shader fixes (#2730)
    - Remove scan and pixel doubling config settings (#2728)
    - Rename PixelFormat enum members BGR555 and BGR565 to RGB555 and RGB565 (#2823)
    - Rendering related refactorings (#2739)
    - Replace busy-wait atomic bool goto logic (#2545)
    - Resize VGA within half the current frame-time (#2510) (#2528)
    - Restore authentic text mode pixel aspect ratio calculation (#2625)
    - Rework "EGA mode with VGA palette" CRT shader auto-switching (#3354)
    - Retire surface output (#2780)
    - Simplify and improve `presentation_mode` handling (#2690)
    - Simplify double-scan criteria and let users `'force_vga_single_scan'` w/ conf option (#2428)
    - Update Catmull-Rom shader (#2786)
    - Use zlib-ng in local builds and CI releases (#3202)
    - Video related refactorings (#2808)
    - Window sizing improvements & aspect ratio related cleanup (#2749)
    - `crt-auto` should auto-switch to VGA shaders in EGA modes with 18-bit VGA palettes (#2819)
    - `sdlmain` improvements (#3123)


## Sound

### IBM Music Feature Card support

The **IBM Music Feature Card** is a rare and expensive sound card from the late 1980s.
It is mainly supported by early Sierra SCI games and a few others, like
Silpheed. Thanks to Loris Chiocca for authoring this originally! See the
`[imfc]` section for further details.

We highly recommend checking out [this excellent blog post](https://nerdlypleasures.blogspot.com/2015/02/the-ibm-music-feature-card-overpriced.html)
to learn more about the interesting history of the card.


<div class="compact" markdown>

| Game                                          | Audio example                                                                                                                 |
| --------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------- |
| Quest for Glory: So You Want to Be a Hero   | <audio controls src="https://archive.org/download/dosbox-staging-v0.81.0-imfc/imfc-quest-for-glory.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| The Colonel's Bequest -- Intro 1   | <audio controls src="https://archive.org/download/dosbox-staging-v0.81.0-imfc/imfc-colonels-bequest-1.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| The Colonel's Bequest -- Intro 2   | <audio controls src="https://archive.org/download/dosbox-staging-v0.81.0-imfc/imfc-colonels-bequest-2.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| The Colonel's Bequest -- Intro 3   | <audio controls src="https://archive.org/download/dosbox-staging-v0.81.0-imfc/imfc-colonels-bequest-3.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |

</div>


### Roland MT-32 ROM handling improvements

We have moved from the fiddly and error-prone filename-based Roland
MT-32/CM-32L ROM lookup mechanism to checksum-based detection. It's no longer
necessary to get the ROM filenames right; you can chuck all of them into your
`mt32-roms` folder---DOSBox Staging will do the rest! Valid ROMs are
identified by their checksums (hashes) at runtime. Both interleaved (mt32pi
style) and non-interleaved (MAME style) ROM files are supported.

As a result, the old "versioned" vs "unversioned" ROM differentiation doesn't
make sense anymore. The `mt32` and `cm32l` model types now behave differently:
`mt32` now selects the first available MT-32 ROM, and `cm32l` the first
available CM-32L ROM (in priority order). Similarly, the `mt32_old` and
`mt32_new` aliases are not tied to specific version numbers anymore but pick
the best available ROMs.

The revised ROM selection method should be backward compatible with the most
common use cases---in fact, the new method should generally result in better
matches, assuming the same ROM set.

Support for the rare 2.06 and 2.07 MT-32 ROMs and the CM-32LN 1.00 has also
been added.

Lastly, we've improved the output of the `MIXER /LISTMIDI` command to make the
display of available ROMs and the active ROM much clearer.

<figure markdown>
  ![Output of the improved MIXER /LISTMIDI command](https://archive.org/download/dosbox-staging-v0.81.0-improved-mixer-command/mixer-listmidi.png){ loading=lazy }

  <figcaption markdown>
  Output of the improved `MIXER /LISTMIDI` command
  </figcaption>
</figure>


### FluidSynth fixes

The Roland SC-55 and FluidSynth handle MIDI portamento messages (pitch glides
between consecutive notes) very differently. As the rather unique Roland SC-55
portamento cannot be emulated with FluidSynth, music written for the SC-55
that uses it might sound weirdly out of tune on FluidSynth (e.g., the
level 8 music of **Descent**).

All in all, it's best not to send MIDI portamento messages to FluidSynth at
all to avoid the problem completely. The resulting sound is a lot closer to
the Roland SC-55's output.

Additionally, a rather strange sound stage issue has also been fixed by
upgrading to the latest FluidSynth library. The panning of some instruments was
off-centre, slightly leaning to the left. The problem could be fairly subtle
or quite apparent depending on the SoundFont in use, the musical score, and
the instruments being played. You can hear it to varying degrees in the
"buggy" audio recording below recorded using the previous 0.80.1 DOSBox
Staging version.

<div class="compact" markdown>

| &nbsp;                                         | &nbsp;
| --------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------- |
| Descent -- Level 8 (SC-55) ¹  | <audio controls src="https://archive.org/download/dosbox-staging-v0.81.0-fluidsynth-fixes/descent-level-8-scva.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| Descent -- Level 8 (FluidSynth buggy) ² | <audio controls src="https://archive.org/download/dosbox-staging-v0.81.0-fluidsynth-fixes/descent-level-8-fluidsynth-bug-0.80.1.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| Descent -- Level 8 (FluidSynth fixed) ³  | <audio controls src="https://archive.org/download/dosbox-staging-v0.81.0-fluidsynth-fixes/descent-level-8-fluidsynth-fixed.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |

</div>

<small>

¹ Roland Sound Canvas VA in SC-55 mode was used for the recording<br>
² DOSBox Staging v0.80.1 (previous version) with the [GeneralUser GS SoundFont](https://schristiancollins.com/generaluser.php)<br>
³ Current DOSBox Staging version with the GeneralUser GS SoundFont

</small>



### Improved MIXER command

The `MIXER` command has been recreated from the ground up to make it a lot
more robust and less confusing to use. The main highlights are as follows:

- The `MIXER` command no longer accepts slightly incorrect input; command
  parsing is now strict and we're displaying error messages for invalid
  commands. These messages try to guide the users to correct their mistakes.

- `MIXER` command handling is now "transactional"—if there is a single error
  in a list of multiple commands, no command is executed but an error for
  the first problem is raised. This leads to less confusing and more
  deterministic overall behaviour.

- Mixer channels now retain their settings when a channel gets deleted and
  then re-created later (e.g., by setting `sbtype none` followed by `sbtype
  sbpro1`).

- The `CMS` mixer channel is no longer renamed to `GAMEBLASTER` when `sbtype`
  is set to `gb`.


### MIDI muting improvements

Previously, when muting the audio, all MIDI devices were sent _Note Off_
messages, which was problematic with long-held notes in musical scores. You'd get
missing notes after unmuting, and the slower the tempo, the more annoying this
problem would become.

Muting has been 100% fixed both for the internal Roland MT-32 and FluidSynth
MIDI synthesisers and also for external MIDI devices. Technically, we keep
feeding external devices with MIDI events in the muted state, but we set all
channel volumes to zero when muting, and then restore the volumes when
unmuting.

Also, we're now correctly muting the MIDI output when `mute_when_inactive` or
`pause_when_inactive` is enabled.


### Sanitise MIDI output & Roland RA-50 compatibility

The MIDI drivers of many games don't fully conform to the MIDI standard,
which makes editing the MIDI recordings of these games very error-prone and
cumbersome in MIDI sequencers, often resulting in hanging or missing notes.

Now DOSBox Staging corrects the MIDI output of such games by default. This
results in no audible difference; it only affects the representation of the
MIDI data. Specifically, we're emitting _Note Off_ messages for all active
notes when an _All Notes Off_ message is encountered (this is mandated by the
MIDI specification, but many games ignore that). There are other _Channel Mode
Messages_ that result in an implicit _All Notes Off_ message; these are
handled correctly as well.

This incidentally also fixes the infamous hanging notes issue with the **Roland
RA-50** external MIDI module (the module does not implement the _All Notes Off_
MIDI message).

A new `raw_midi_output` setting has been introduced to disable this
"sanitisation" of MIDI data. That might come in handy if you need to leave the
raw MIDI stream unaltered (e.g., when working with music applications, or when
debugging MIDI issues).


### Optionally fade out hanging notes on Tandy & OPL

Some games like **Bard's Tale Construction Set** and **California Games II**
suffer from hanging note issues where the notes are not always properly
terminated at the end of a musical piece. We've introduced an option to fade
out the OPL or Tandy sound output after the last IO port write to these audio
devices to remedy the situation. See the documentation of the `opl_fadeout`
and `tandy_fadeout` settings for further details.


### CD Audio support on Linux for physical CD-ROMs

CD Audio is now supported on Linux too via `ioctls` when using physical
CD-ROMs. The audio is routed through the DOSBox mixer, each drive having its
dedicated mixer channel (`CDAUDIO_0` for the first drive, `CDAUDIO_1` for
the second, and so on).

With this addition, we now support CD Audio on both Windows and Linux for
physical media (but on Windows, the CD audio still goes through the OS-level
mixer).


### Other sound-related changes

- It's no longer possible to create DMA conflicts by configuring multiple
  sound devices to use the same DMA channel. In case of a conflict, the last
  configured or enabled device takes precedence and the other device gets
  deactivated automatically. The three sound devices that use DMA are the
  Sound Blaster, the Tandy DAC (the Tandy PSG doesn't need it), and the Gravis
  Ultrasound.

- The `crossfeed` config setting has been revised; now it works the same way
  as the `chorus` setting (it has `light`, `normal`, and `strong` presets;
  `on` defaults to `normal`).

- Fixed a regression that made the sound effects sound crackly in **Duke Nukem
  3D** when using 44 kHz sample rate on the Gravis Ultrasound.

- Fixed a Gravis Ultrasound regression where 16-bit samples sounded noisy in
  some games (e.g., **Star Control II** and **Star Trek: The Next Generation –
  A Final Unity**).

- Un-deprecate the per-SoundFont volume scaling as it is useful to reign in
  overly loud SoundFonts.

- Ignore speaker-output enable/disable commands on the Sound Blaster 16 (this
  is how the hardware works). This increases compatibility with some badly
  coded games, e.g., the digital audio in **Monkey Island 2: LeChuck's
  Revenge Ultimate Talkie Edition** was muted before this fix.

- CD-ROM seek delays are now emulated to fix the CD audio in a few games. For
  example, **Chasm: The Rift** stopped playing the music after about 20
  minutes of gameplay without this fix.

- Fixed a regression where the Sound Blaster 16's maximum sample rate was
  erroneously clamped to 45&thinsp;000 Hz (it can go up to 45&thinsp;454 Hz on
  real hardware). This caused the sound to be slightly out of tune in programs
  that use the maximum sample rate.

- Fixed a regression that prevented Tandy Sound from being re-configurable at
  runtime.


??? note "Full PR list of sound-related changes"

    - Accumulate GUS frames accross each voice instead of per-sample (#2696) (#2698)
    - Add Loris Chiocca's IBM Music Feature Card (IMFC) patch  (#2367)
    - Add `iir` to the set of MSYS2 packages (#2242)
    - Add a fade-to-sleep-after-last-port-write feature to the mixer (#3058)
    - Always clamp 'frames_needed' to the allowed mix/max range in the mixer (#2843)
    - Always clamp `frames_needed` to the allowed mix/max range in the mixer (#3217)
    - Clamp the max Sound Blaster 16 sample rate to 45454 Hz, not 45000 Hz (#2676)
    - Cleanup the GUS and SB DMA channels on close (#2585)
    - Consistently cast and wrap the mixer's position (#2745)
    - Do not send portamento messages (MIDI CC 5, 65 & 84) to FluidSynth (#2705)
    - Don't rename the CMS mixer channel to GAMEBLASTER when `sbtype` is `gb` (#2228)
    - Drop volatile members in IMFC and reSIDfp (#2380)
    - Extract MIXER command into its own file (#2839)
    - Fix MIDI capture (#2707)
    - Fix Sound Blaster DMA ADPCM frame count assertion error (#2277)
    - Fix a Coverity warning in SDL Sound (#3000)
    - Fix a GUS regression when interpolating 16-bit samples (#2576)
    - Fix a couple regressions in `main` relating to MIDI refactoring (#2541)
    - Fix description of the `imfc_filter` setting (#3205)
    - Fix duplicate SoundFont listing in mixer /listmidi (#3074)
    - Fix spurious directory separators in `mixer /listmidi` output (#2383)
    - Fix state handling of the BIOS's Tandy DAC callbacks (#3148)
    - Fix the priority of the "set decibel volume" MIXER command (#3068)
    - Ignore speaker-output enable/disable commands on the SB16 (#3105)
    - Implement CD Audio using Linux ioctls (#2675)
    - Improve MIDI buffer underrun logging (#2227)
    - Let derived CDROM devices asynchronously lag their calls (#2622)
    - Let only one device reserve a DMA channel at a time (#2593)
    - Link mt32emu statically in the MSYS2 CI release (#2711)
    - Load MT-32 ROMs from `romdir` using hash matches  (#2591)
    - Lookup MT-32 ROMs using std::filesystem paths (#2387)
    - MIDI mute improvements (#2318)
    - MIXER command improvements & general mixer enhancements + fixes (#2868)
    - Minor string fixes in MIXER command (#3072)
    - Mixer refactoring & cleanup (#2787)
    - Only process MT-32 debug messages in debug builds (#3100)
    - Re-add the SDL Sound assert (third time's a charm?) (#3006)
    - Re-initialize the BIOS DAC callbacks on SB and Tandy changes (#3142)
    - Refill the SB audio channel when DMA reaches terminal count (#233) (#2614)
    - Rework the MT-32/CM-32L ROM lookup and `MIXER /LISTMIDI` improvements (#3011)
    - Sanitise raw MIDI output by default & add `raw_midi_output` config option (#2308)
    - Setup the BIOS Tandy DAC only after critical BIOS features are setup first (#3199)
    - Sync Nuked-OPL3 with upstream (#3015)
    - Sync YM1728B_emu with upstream (#3021)
    - Sync fluidsynth, glib, gtest, libjpeg-turbo, and mt32emu wraps (#2991)
    - Sync reSIDfp with upstream (#3067)
    - Sync residfp with 2.4.2 (#2259)
    - Try again to fix Coverity warning in SDL Sound (#3005)
    - Tune the IBM Music Feature card's 0-dB level and default filter  (#3048)
    - Un-deprecate the per-SoundFont volume scaling (#2677)


## Input

### Virtual joystick fixes

Virtual joysticks can now be created without a physical joystick being plugged
in. This fixes a regression introduced early in DOSBox Staging development,
which now allows mapping keyboard events to joystick events. The deactivation
logic of the pressed key now detects when the key is not being pressed
anymore---this improves joystick support in 74 games.


### Support for mapping mouse buttons to keys

Some games like **Settlers I** (also known as **Serf City: Life is Feudal**)
require the player to push both mouse buttons at the same time to perform
certain actions. This is impossible to perform on some input devices such as
the Apple MacBook trackpad or the ChesterMouse. This has now been fixed by
allowing mouse buttons to be mapped to the keys of the keyboard as a
workaround.


### VirtualBox mouse driver support

DOSBox Staging has had experimental support for the VMware mouse protocol for
quite some time now, and in this version, we have added support for the
VirtualBox mouse protocol. The primary motivation is to enable seamless mouse
operation in Windows 3.x.

Just install [Javis Pedro's Windows 3.x
driver](https://git.javispedro.com/cgit/vbmouse.git/about/) and enjoy the
seamless Windows 3.x experience!


### Multi-monitor-aware mouse capture support

DOSBox Staging now has fully multi-monitor-aware mouse capture and seamless
mouse behaviour. Essentially, if DOSBox is in fullscreen mode on multi-monitor
systems, mouse capture and seamless mode work as if you were still in
windowed mode, allowing you to move the mouse cursor freely between the
monitors.

The feature is enabled by default but it's only active on systems with
multiple displays. Of course, you can always disable it by setting
`mouse_multi_display_aware` to `off` in your config.


### Other mouse improvements

- The PS/2 mouse port is now emulated at the register level, and more PS/2
  protocol commands are supported. This allows the emulation of fairly complex
  input devices like the Microsoft IntelliMouse Explorer with 5 buttons and a
  mouse wheel on Windows 95.
- It is now possible to disable the built-in emulated mouse driver and use your
  favourite real DOS driver.
- Fixed problems with the internal mouse driver and text modes with more than
  80 columns.
- Fixed mouse support in MS Word 5.5 for DOS.


### macOS function key support

macOS users can now force the Touch Bar or media keys to operate as function
keys in DOSBox Staging (this will not affect other apps or the OS).
Please refer to [our wiki article](https://github.com/dosbox-staging/dosbox-staging/wiki/Tips-&-tricks#force-touch-bar-or-media-keys-to-operate-as-function-keys-when-using-dosbox-staging-on-macos) for the setup instructions.


### Brazilian ABNT2 keyboard support

The mapper, keyboard, and BIOS tables have been expanded to handle the OEM102
and ABNT1 keys found on Brazilian ABNT2 keyboards. The left and right Windows
keys have been assigned to their correct scan codes too.


??? note "Full PR list of input-related changes"

    - Add extra hotkey button row in the mapper (#3147)
    - Add mouse button mapping community patch (#3078)
    - Add multi-monitor awareness mode for mouse capture (#2377)
    - Create and update joy binds even when physical joysticks aren't present (#2516)
    - DOS mouse driver fixes (#2601)
    - Fix compatibility problems with VBADOS (VBMOUSE.EXE) mouse driver (#2742)
    - Fix deactivation of queued joystick axis movement (#2713)
    - Fix joysticks breaking after a config -set (#2694)
    - Fix memory access in VirtualBox device, enable VirtualBox mouse protocol (#3089)
    - Fix mouse centering on high DPI displays with scaling enabled (#2611)
    - Fix mouse movement limitation regression in some games (#2648)
    - Fix mouse problem with windowed mode and viewport_resolution setting (#2333)
    - Fix problem with some software (like MSD.EXE) displaying garbage mouse driver info (#2538)
    - Fix register-level PS/2 mouse access when DOS mouse driver is disabled (#3120)
    - Fix the scan code sequence for the `pause` key (#2498)
    - Handle OEM102 and ABNT1 keyboard scancodes (#2209)
    - Implement DOS mouse driver function 0x32 (#2508)
    - Implement i8042 diagnostic dump (#2298)
    - Improve `mouse_sensitivity` behavior (#3138)
    - Improve i8042 emulation, fix KEYB.COM (#2293)
    - Improve text mode detection in DOS mouse driver (#2658)
    - Keyboard rework and PS/2 mouse register-level access support (#2287)
    - Minor cleanups in mouse and keyboard emulation code (#2230)
    - Only unmute / unpause when Window focus is gained (#2254)
    - Pause fixes (#2323)
    - Port keymapper to SDL renderer (#2763)
    - Prefer evdev mouse API over xinput on Linux (#2529)
    - Release mouse if `config -set mouse_capture=nomouse` is executed (#3129)
    - Reset DOS mouse driver position granularity on every mode change (#2608)
    - Reworked virtual machine mouse support (#2755)
    - Workaround for keyboard problem in Ultima VIII: Pagan (#3109)


## DOS integration

### New FOR command

The missing `FOR` command has been added, resulting in better software
compatibility with batch files that contain loops. The behaviour mirrors the
behaviour of the MS-DOS 6.22 `FOR` command.


### Various DOS command additions and improvements

- The missing `MOVE`, `TREE`, `SETVER`, and `VOL` commands have been added.
- The `CLS` command now does not reset the screen mode to 80&times;25.
- The verbosity of the `DELETE` command has been improved.
- The wildcard handling of the `IMGMOUNT` command has been improved.
- The `LS` command now accepts multiple paths or patterns and ignores hidden
  or system files unless the `/A` switch is specified.
- The `MEM` command now supports XMS memory capacities over 64 MB and has a
  critical bug fixed where it consumed all upper memory blocks after
  invocation.
- The `MORE` command is now extended with features from modern Windows.


### Persistent command history

The emulated DOS shell now retains a 500-line history of your previous
commands. The history is remembered across multiple sessions, just like you
would expect it from a Linux shell.

If you'd like to disable the shell history, set the new `shell_history_file`
setting to an empty value.


### Support for all DOS file & directory attributes

All DOS file and directory attributes are now supported.

On Windows, the attributes are stored as standard filesystem attributes.

On macOS and Linux, they're stored as a mixture of standard attributes (for
the read-only flag) and extended `xattr` attributes. The extended attributes
follow the Samba 3 format which is compatible with WINE and DOSEmu2.


### Autoexec improvements

Several long-standing autoexec issues have been fixed:

- The `[autoexec]` section in config files is now fully UTF-8 aware and its
  contents are now converted to the internally set code page on the fly.
- The size limitations of the `[autoexec]` section have been lifted.
- The generated `Z:\AUTOEXEC.BAT` is now prettier due to the added extra
  comments.
- The `CONFIG -wc` command does not eat away empty lines from the `[autoexec]`
  section anymore.


### Optional shell config shortcuts

We've supported config shortcuts for a long time now (e.g., instead of `CONFIG
-set sbtype sb16` you can simply use the `sbtype sb16` shortcut). The feature
is enabled by default, but this can cause some confusion when a shortcut
conflicts with a DOS executable having the same name.

Now config shortcuts can be disabled by setting `shell_config_shortcuts` to
`off`.


??? note "Full PR list of DOS integration related changes"

    -  Cleanup AUTOEXEC.BAT generation (#2609)
    - Add FOR Command (#3094)
    - Add full file path printing for file related debugger commands (#2472)
    - Add short prompts for MORE commands for 40 column screen modes (#2953)
    - Auto enable shell variable expansion for DOS >=7 (#2378)
    - Autoexec fixes (#3007)
    - Disable writing command line history if entry is empty (#2635)
    - Do not discard empty lines in `[autoexec]` section (#2415)
    - Do not write SETVER table back to file if secure mode is engaged (#2623)
    - Don't block r/w file opens on r/o FAT images (#2280)
    - Don't save command history to current working directory (#2630)
    - Enable large disk image support (#2301)
    - Exclude COMMAND.COM's help arguments when part of sub-command (#2263) (#2264)
    - FAT image mounting fixes (#2278)
    - FCB argument regression fix (#2524)
    - File attribute support improvements (#2961)
    - Filesystem fixes (#2288)
    - Fix MSCDEX regression in game "Fascination (1991)" (#3163)
    - Fix alignment of file size column in the DIR command's output (#2799)
    - Fix batch file 'goto' for previous labels (#2384)
    - Fix bug where DTA can be modified by DELETE command (#2653)
    - Fix drive automounts (#3038)
    - Fix file creation regression on case sensitive file systems (#2971)
    - Fix for DOS error code being wrongly set on creating files (#2989)
    - Fix lockup involving specific mount order (#2310)
    - Fix mounting directory with space in its name, passed as an argument (#2626)
    - Fix read checks in shell file reader (#3076)
    - Fix unneeded empty lines in 'TREE | MORE' display (#2944)
    - Fixes for shell_misc.cpp regressions (#2517)
    - Ignore trailing colon in shell redirection (#2240) (#2446)
    - Implement DOS file/directory attributes support (#2951)
    - Implement MOVE shell command (#2660)
    - Implement SETVER.EXE command (#2464)
    - Implement TREE.COM command (#2366)
    - Implement persistent command line history (#2615)
    - Implemented VOL shell command (#2638)
    - Improve the help and output of the `CONFIG` command (#2672)
    - Improve the online help of the MORE command (#2947)
    - Improve verbosity of DELETE command (#2274)
    - Improve wildcard handling for `imgmount` file arguments (#2270)
    - Make MOVE and SUBST external commands (#2691)
    - Make shell configuration shortcuts optional/configurable (#2807)
    - Omit blank lines from command history (#2673)
    - Re-write CLS command to not change screen mode (#3024)
    - Re-write DOS_Shell::CMD_RENAME (#3126)
    - Rename command_history to shell_history, for consistency (#2640)
    - Rework and improve `LS.COM` command (#3034)
    - Skip processing of hidden host files (#2240)
    - Tab completion fixes for / and . (#2555)
    - Track and free allocations in MEM program (#2534)


## General

### Revised CPU cycles handling

Some legacy CPU cycles optimisations aimed at improving multi-tasking
performance on single-core computers have finally been removed. These features
probably made sense 20 years ago, but they no longer serve any useful purpose
in a world where minimum quad-cores are the norm:

- Previously, the `cycles = max 100%` setting resulted in only 90% CPU core
  utilisation and the `max 105%` "magic value" expanded this to about 95%. Now
  100% means 100%, and the weird 105% special case has been removed. As a
  beneficial side effect, `cycles = max 100%` can now make the CPU emulation
  thread go into oversubscription at times (over 100% capacity), resulting in
  a faster and more aggressive boost clock ramp-up.

- CPU emulation is no longer silently throttled to half the configured cycles
  setting (!) when the DOSBox Staging window is unfocused. Such behaviour can
  cause audio glitches when listening to music in the background, and severely
  degrade performance when running computation-intensive tasks in DOSBox (such
  as compiling programs or rendering 3D images) while doing something else on
  your computer.

- The rate for cycle guessing has been increased from 4 to 10 times per second,
  allowing emulation to reach optimal speeds much quicker.

- We've also added compensation for delays caused by the system graphics
  driver, such as vsync, which were adversely affecting the cycle guessing
  performance.

- The DOSBox Staging window's title bar now shows the current `cycles`
  setting more accurately; specifically, the `limit` option is now also
  shown, if configured.


### Pause improvements

The pause feature now operates on the same principle as the mute function: you
press the pause hotkey to pause, then press it again to unpause. ++alt+pause++
remains the hotkey on Windows and Linux, and on macOS you can use the newly
introduced ++cmd+p++ hotkey.

Additionally, we've restored the pause indicator in the window's title bar
too.

Various edge-case scenarios with the `pause_when_inactive` setting have also
been fixed.

!!! warning "Pause gotchas"

    All input is disabled in the paused state---the only thing you can do is
    press the pause hotkey again to unpause the emulator.

    Remapping the pause hotkey is not supported (technically, you can do it in
    the mapper, but that will break the pause feature).


### Config improvements

- Previously, the primary config was only written if it did not exist and no
  local config was present. This was rather confusing and inconsistent. The
  new behaviour is to always write the primary config with the default
  settings if the file is missing or if it's empty.

- You can now enable portable mode by putting an empty `dosbox-staging.conf`
  file into your DOSBox Staging executable folder. DOSBox will write the
  default settings to this empty file on the first launch.

- For config settings that toggle an option (booleans), you can now use `on`,
  `enabled`, `yes`, `true` or `1` for _enabling_ the feature, and
  `off`, `disabled`, `no`, `false` or `0` for _disabling_ it.

- Now the config descriptions list the defaults for all settings in a
  consistent manner.

- Deprecated settings are handled better by the `CONFIG` command now, e.g.,
  when listing all settings in a section, the deprecated settings are filtered
  out.

- The `CONFIG` command has been generally revised to make working with configs
  simpler and more intuitive.


### Revised capture naming scheme

The naming scheme of the captured files has been revised. Previously, the name
of the running DOS executable was used as the basename to which a running
number was appended. This rarely added any value because DOS programs tend to
have short nonsensical names such as `GAME.EXE`, `START.EXE`, `SCIV.EXE`, etc.
If anything, this only created confusion when capturing the output from
multiple differently named programs during a single DOSBox session because all
basenames effectively had their own independent counters. In such a scenario,
the only way to view the captured images in a timeline order was to sort them
by creation date which was cumbersome.

Technically, this change was necessary to keep the counter values in sync when
taking screenshots in multiple formats with the default screenshot action, but
it makes a lot of sense in general too.

Captured images are now named as follows (the `0001` part is a running counter):

<div class="compact" markdown>

- Raw capture: `image0001-raw.png`
- Upscaled capture: `image0001.png` (no postfix)
- Rendered capture: `image0001-rendered.png`

</div>

The other capture types have the following naming scheme:

<div class="compact" markdown>

- Audio: `audio0001.wav`
- Video: `video0001.avi`
- MIDI: `midi0001.mid`
- Raw OPL: `rawopl0001.dro`
- OPL instruments: `oplinstr0001.rad`
- Serial log: `serial0001.serlog`

</div>

Note that the last counter value in the capture folder per capture type is
only looked up at startup or after changing the `capture_dir` setting.


### Command-line user experience improvements

We listened to our users and improved the command-line user experience. Every
option has been looked at critically; text descriptions have been rewritten,
and some old options have been removed that do not apply to the current state
of the software. All behaviour is still backward compatible to ensure smooth
operation with old batch files and shell scripts.

Most notably, some long options were prefixed with a single dash (e.g.,
`-machine`, `-lang`) and some with two dashes (e.g., `--list-glshaders`,
`--printconf`). Now all options conform to GNU conventions, so all long
options start with two dashes (e.g., `--machines`). The legacy single-dash
variants are still silently recognised for backward compatibility.


### Normalise Windows Explorer context menus

If you're using the installer version on Windows, now starting DOSBox Stating
via the right-click context menu in Windows Explorer is more consistent.
Regardless of whether you click  on a folder or the empty space inside a
folder, DOSBox Staging will start with the working directory set to that
folder.

The previous ability to execute `.EXE`, `.COM` and `.BAT` files directly using
the right-click menu has been removed as that feature was inconsistent,
confusing, and had limited applicability.

The ability to execute a `.conf` file using the context menu has been
retained.


### Log window support on macOS

Previously, macOS users couldn't view the logs when starting DOSBox Staging
from the Finder. We've fixed that by adding a new special shortcut to the DMG
installer to start Staging with a log window open.

**How to use it**

Follow the steps indicated in the DMG package, as shown:

<figure markdown>
  ![New run with log window macOS shortcut](https://archive.org/download/dosbox-staging-v0.81.0-macos-logging-shortcut/macos-logging-shortcut.png){ width=85% loading=lazy }
</figure>

Simply copy the included `Start DOSBox Staging (logging).command` to a folder
then open it in Finder. DOSBox Staging will act as if started from that
folder, it will pick up the local config, and it will also open a terminal
window that shows the logs.
 
!!! note

    You might be asked to give DOSBox Staging access to the containing folder
    on the first launch---just click OK if that dialog comes up.


### Modernised application icons

The new icons are compliant with modern OS interface guidelines and improve
legibility at small icon sizes. A custom icon with a rounded rectangle design
has been added for macOS that conforms to the Apple Human Interface
Guidelines.

Linux users downloading the release from the website should run the included
`install-icons.sh` script to see the new icons.

### Maximum memory space increased to 3 GB

The maximum XMS memory size has been increased from 63 MB to 3 GB. Windows
3.1x now allows more than 64 MB of RAM to be allocated.


### Modem improvements

The modem speed and port baud rate now match by default. This simplifies
things as there isn't a possibility for the modem and port speeds to mismatch
with the defaults anymore. Modem speed is now reported in _bps_ (bits per
second) to differentiate it from _port speed_. This fixes v1.2 of **Doom** as
that game mandates a modem speed of 9&thinsp;600 bps.


### x87 FPU emulation improvements

- DOSBox Staging no longer quits when an x87 FPU stack overflow occurs. Real
  DOS allows the system to continue in such cases, so this mimics real
  hardware behaviour. This improves compatibility with some misbehaving
  programs such as the demo [kkowboy by blasphemy](https://www.pouet.net/prod.php?which=87).

- Rounding floating point numbers very close to integers has been fixed on
  non-x86 platforms. This fixes some obscure issues like not being able to
  increase the view size above 99 in **Quake** on ARM CPUs.

- Fix "black vertical bars" video corruption issue due to FILD/FIST memcpy
  trick in some late 90s Pentium games and demos. This was caused by a trick these
  programs do to perform a fast memory copy of 64-bit integer values by
  misusing the FILD/FIST FPU instructions (also see
  [here](#fix-black-vertical-bars-video-corruption-issue)).

- The _Intel Floating Point Conformance Test for IEEE 754-1985_
  (`MCPDIAG.exe`) passes with zero failures on x86 hosts with `core = normal`
  too now in our official releases. 80-bit extended precision floating point
  numbers are truncated to 64-bit double precision on non-x86 hosts due to
  performance reasons; it's not recommended to use DOSBox Staging on such
  hosts for any engineering or financial calculations. The current state of
  x87 FPU emulation is as follows:

    - 100% conformance in all Intel x86 (32-bit) and x64 (64-bit) Windows,
      macOS and Linux builds on all cores.
    - Every other build, host, and core combination is non-conformant (but
      working at reduced 64-bit precision).

- Builds that only support reduced 64-bit double precision floating-point
  emulation instead of full 80-bit extended precision now log a warning about
  this at startup.


### Debugger improvements

- Linux debugger-enabled builds now have OpenGL enabled (previously, this was
  disabled due to the OpenGL code paths not being compatible with the
  debugger on Linux).

- A `C_HEAVY_DEBUG` compile-time feature has been added to allow breaking on
  memory reads in the integrated debugger. Similarly to most of the debugger
  features, this only works reliably when using `core = normal` with real mode
  programs.


### Improved Linux man page

The Linux man page has been outdated for quite some time now. This has been
rectified; the man page now contains an accurate description of the new and
revised command-line interface of DOSBox Staging.


### FreeBSD, OpenBSD & PPC support

DOSBox Staging can now be compiled on FreeBSD and OpenBSD. The PPC dynarec
core has been broken for a while now; this has been fixed, and various
endianness issues have been rectified so now you can run Staging on big-endian
PPC processors without problems.


??? note "Full PR list of miscellaneous enhancements"

    - Always write the primary config if it doesn't exist (#2966)
    - Don't throttle emulation speed when window becomes unfocused (#3085)
    - Enable loguru stack traces (#2652)
    - Fix FROUND Issues (#3161)
    - Fix rounding when very close to an integer (#3149)
    - Import FPU scale fix for x86 normal core (#2297)
    - Improve handling of deprecated settings and other setting related improvements (#3118)
    - Increase maximum memory size to 384 MB (256 MB+128 MB) (#2289)
    - Logging & config description improvements (#2668)
    - Never hard-exit DOSBox when an x87 FPU stack overflow is detected (#2564)
    - Normalise warnings messages (#3143)
    - Regenerate primary config file if it is empty (#3139)
    - Restore pause on macOS & pause indicator in the window's title bar (#3140)
    - Restore sane `max N%` cycles behaviour where 100% means 100% (#3141)
    - Skip compiler if error instead of aborting in compile_commits.sh (#3130)
    - Skip hidden dot files when wildcard pattern is first (#2492)
    - Turn down loguru verbosity when started with following arugments (#2722)
    - Update Tracy to 0.10 (#3022)
    - Update increaseticks sleep strategy (#2655)
    - Updated modem CONNECT response behavior (#3023)
    - Use C++11 `std::nearbyint()` for nearest FPU round (#2296)
    - Use dynamic SDL version checking for logging (#2689)


??? note "Full PR list of miscellaneous fixes"

    - Adapt to setup function additions (#2563)
    - Add missing mutex lock to RWQueue (#2773)
    - Allow FROUND fix on x64 (#3216)
    - Always write the default config if the primary config file is missing (#3117)
    - Change drive macros to return boolean values (#3020)
    - Close file descriptor in cdrom ioctl class (#2685)
    - Copy only the available command line chars (#2542)
    - Display 'max limit' cycles setting properly in the title bar (#3214)
    - Do not assert if mapperfile parameter is empty (#2995)
    - Don't emulate CDROM lag for stationary calls (#2624)
    - Don't sign extend 16-bit immediates to 32-bit in ppc64le dynrec, fixes #2846 (#2850)
    - Fix 'auto' presentation mode on macOS in fullscreen (#3219)
    - Fix `pause_when_inactive` mouse behavior for macOS and Linux (#2262)
    - Fix completion index assertion error (#2531)
    - Fix incorrect version reporting in Virtualbox LOG_WARNING. (#3002)
    - Fix macOS debugger crash (#2495)
    - Fix mistake in a comment (#2299)
    - Fix mouse pointer for MS Word 5.5, based on DOSBox-X implementation (#2504)
    - Fix no function names in Loguru stack traces on Linux (#2682)
    - Fix null pointer de-reference in dyncache on Windows (#2863)
    - Fix ppc64le backend and 64K page size support (#2828)
    - Gracefully quit stdin loops on program termination (#2392)
    - Handle exiting when `pause_when_inactive = true` (#3079)
    - Make conf path handling more robust (#2241)
    - Prevent duplicate SDL Window creation when using OpenGL (#2822)
    - Replace invalid vector.end dereference with raw pointer access (#2471)
    - Set the icon on window regeneration (#3081)
    - Store envelope channel_name as std::string (#2670)
    - Track previously added userdata when deleting the SDL resize watch (#2802)
    - Use int64_t consistently for tick durations (#2596)
    - Zero initalize memory allocation in GrowWriteMask in dyn_cache (#2986)


??? note "Full PR list of documentation-related changes"

    - Add Instructions to Build on Nix (#2326)
    - Add game mode support for macOS Sonoma or newer (#3016)
    - Add missing defaults to all config settings that still don't have them (#3207)
    - Add v0.80.1 release notes (#2203)
    - Fix a few bad links in README. (#2320)
    - Fix or simplify some descriptions (#3062)
    - Fix the formatting of some config descriptions (#2560)
    - Harmonize some help strings (#2686)
    - Improve some config setting descriptions (#2578)
    - Minor configuration file cleanups (#2634)
    - Modify deploy website workflow to deploy to the GitHub Pages org repo (#2202)
    - Move Wiki link to the top navbar from the footer (#2206)
    - Normalise config descriptions and add default values to most of them (#2221)
    - README.md typo Vorbis (#2791)
    - Remove opencaptures (#2970)
    - Rename 'cdda' to 'cdaudio' in the MIXER help examples (#2725)
    - Revise the README template & include link to the new Getting Started … (#2360)
    - Snip truism note from MIXER long help text (#3066)
    - String fixes in CONFIG command (#2723)
    - Update DOCUMENTATION.md (#2827)
    - Update docs with supported versions of Windows, macOS, and Linux (#2258) (#2276)
    - Update the Linux `man` page (#2837)
    - Update translation guide (#3213)
    - Various config setting description improvements (#2729)
    - [DRAFT] Our man page is currently unmaintained - do not install it (#2820)


??? note "Full PR list of project maintenance related changes"

    - Add "Start DOSBox Staging (logging)" command to the macOS DMG image (#2352)
    - Add a memory read breakpoint feature to the builtin debugger (#3191)
    - Add a script to compile all commits on the current branch (#2642)
    - Add higher res icons to meson install script (#3179)
    - Add several warnings to the GCC build (#2661)
    - Add support for FreeBSD and OpenBSD (#2338)
    - Add warning log if message is missing (#2566)
    - Add wrap for SDL2 to support static macos builds (#2239)
    - Adjust ticksDone with render time (#3136)
    - Another batch of PVS Studio fixes (#2776)
    - Another batch of PVS Studio fixes (#2756)
    - Boolean config param handling improvements & cleanup (#2354)
    - Bound and pin dependency versions (#2217)
    - Change sdl.opengl.shader_source from std::string_view to std::string (#2753)
    - Check and log *nix `ioctl` return-code errors (#2721)
    - Clean up VESA_GetSVGAInformation() & get rid of warnings (#2715)
    - Cleanup a Coverity null-deference reloading the shader (#2633)
    - Cleanup a couple unhandled switch cases when OpenGL isn't available (#3197)
    - Cleanup a handful of PVS Studio warnings (#2627)
    - Cleanup a handful of unchecked return-code issues flagged by Coverity (#3180)
    - Cleanup a handul of new Coverity issues  (#2639)
    - Cleanup among PCI/Memory constants (#2733)
    - Cleanup in cross.cpp (#2447)
    - Cleanup new CI warnings due to host-side updates (#2836)
    - Cleanup two ASAN initialization order issues (#2330)
    - Compile debug builds with GCC and Clang library check flags (#2553)
    - Convert SDLOSXCAGuard files to UTF-8 (#2982)
    - core_dyn_x86: Initialise rettype to avoid compiler warning (#2365)
    - De-unionise X86PageEntry (#2994)
    - Debug/trace logging improvements (#2832)
    - Differentiate CLI arguments from markup tags with escapes (#2349)
    - Do not set icon at runtime (#3171)
    - Drop Visual Studio 2019-specific accomodations in `.clang-format`  (#2489)
    - Encapsulate the Cache's write mask functions as members (#2990)
    - Fix OpenGL symbol type mismatch warning at link time (#3098)
    - Fix Visual Studio project & filter definitions for src/hardware (#2459)
    - Fix `format-commit.sh`, Stop reformatting `#include`s (#2388)
    - Fix a couple Coverity warnings involved unchecked return values (#2631)
    - Fix a couple recent Coverity warnings (#2368)
    - Fix compilation error on `misc_util.h`  (#2329)
    - Fix coverity sign extension warning (#3001)
    - Fix flipped ANSI colour intensity flag bug and use canonical CGA colour tag names (#2979)
    - Fix for spelling mistake on NixOS.txt (#2363)
    - Fix minor data read access issues flagged by TSAN (#2328)
    - Fix nullptr compiler warnings (#2709)
    - Fix several static analysis warnings (#2750)
    - Fix small typos on `build-nix.md`  (#2341)
    - Fixing missing header file for select() syscall when building on MacO… (#2968)
    - Harmonize ManyMouse support message in the build system (#3050)
    - Hopefully make MSYS2 build pass (#2692)
    - Improve DOSBox Staging application icons (#3157)
    - Improve XMS emulation, based on code from DOSBox-X (#2386)
    - Improve compile commits script (#2760)
    - Increase max memory size to 3072 MB, minor cleanup (#2334)
    - Let Meson use a system call to detect the page size (#3174)
    - Let `DriveManager` own all filesystem and image mount objects (#2306)
    - Make BatchFile Testable (#2618)
    - Make the DOS module depend on SDL2 net (#2358)
    - Make the RWQueue more usable for complex types (#2522)
    - Mark all core run functions with `noexcept` (#2251)
    - Move `bit_view` value assignment to a general function (#2290)
    - Move dynamic FPU synchronization inside preprocessor defines (#2252)
    - Normalise Windows context menus created by the installer (#2355)
    - Notify all when RWQueue stops (#2775)
    - PVS Studio fixes (#3088)
    - PVS Studio warning fixes (#3070)
    - Packaging improvements for icons on Linux (#3193)
    - Perform safe left-shift of signed values in dynrec operators (#2535)
    - Refactor Prop_path to use std_fs::path (#2700)
    - Refactor Property->Get_string to return a std::string (#3009)
    - Refactor WriteOut functions in program.cpp (#2309)
    - Refactor command line arguments (#2703)
    - Refactor shell_batch.cpp (#2342)
    - Refactor shell_misc.cpp (#2482)
    - Remove fontstash library (#3013)
    - Remove obsolete APIs from 'dos_system.h' (#2976)
    - Restore files required by the Linux Flatpak build (#2213)
    - Revert increaseticks sleep to 1ms (#2792)
    - Revert use of pinned vcpkg versions (#2222)
    - Show backtraces in debug builds using Loguru's assert (#2650)
    - Suppress excessively verbose `sprintf` warnings on macos + clang (#2307)
    - Sync GHC std::filesystem with v1.5.14 (#2613)
    - Sync Meson wraps with upstream (#2427)
    - Sync decoders with upstream versions (#2718)
    - Sync enet with upstream version 2.3.6 (#3012)
    - Sync flatpak metadata up to `0.81.0-alpha` (#2216)
    - Sync whereami with upstream (#3017)
    - Typo fixed in setup.cpp (#3063)
    - Update Linux AppData description (#2732)
    - Update Linux and macOS debug CI workflows  (#2628)
    - Update RPM spec file (#2659)
    - Update macOS build instructions (#3044)
    - Use safe_strcpy and safe_strcat (#3003)
    - Use safer calls in dynrec and operators (#2350)
    - Use std math functions in `compressor.cpp` (#3203)


??? note "Full PR list of other changes"

    - Add docker image and CI job for ppc64le architecture (#2834)
    - Add package download URL to issue template (#2473)
    - Add pull request template (#2845)
    - Avoid checked-STL false positives in Coverity build (#2561)
    - Bundle all license texts with binary packages (#2420)
    - Contribute an SDL audio test tool (#2317)
    - Disable FluidSynth's own unit tests under MSYS2 CI (#2357)
    - Drop Ubuntu 18.04 from the CI workflows (#2292)
    - Improve caching of subpackages (#2269)
    - Let MacOS homebrew overwrite conflicting junk files in CI (#2716)
    - Reinstate MSVC CI workflow (#2573)
    - Revisit our approach to categorising items in the release notes (#3196)
    - Support the right control key on MacOS. (#2314)
    - Suppress ALSA API macros PVS Studio warnings (#2783)
    - Update Coverity to version 2023.6.2 (#3175)
    - Update Windows SSL certificate authority in MSYS2 workflow (#2245)
    - Update packages/*.txt files to include ffmpeg and conan (#2805)
    - Update templates (#2830)
    - Use versioned action/upload key names in CI workflows (#3215)



## Localisation

### Support for modern and historic locales

It is now possible to select between modern and historic (DOS era) locale
styles via the new `locale_period` setting. Historic settings (if available
for the given country) try to mimic old DOS behaviour when displaying
information such as dates, times, or numbers; modern ones follow practices
more consistent with typical current-day host systems.

Also, a lot more locale definitions not present in the original MS-DOS have
been added from OS/2 Warp 4.52.


### Translation updates

- Updates to Polish, Dutch, and Italian translations.
- The command-line help text is now translatable and correctly outputs UTF-8
  text on Windows.
- The translation workflow has been simplified.
- A batch file for converting translations made on Windows to Unix carriage
  return format has been added.

### Script to convert GOG CP473 config files to UTF-8

GOG ship their DOS games with `dosbox.conf` files that assume the CP437 DOS
codepage (also known as OEM-US or DOS Latin US). Some of their games display
fancy startup menus via commands in the `[autoexec]` section, and these often
use extended ASCII table drawing characters. This, however, conflicts with our
revised UTF8-aware config handling, which results in the table drawing
characters not being displayed correctly.

The fix is to convert such config files from CP473 to UTF-8 encoding. One of
our contributors created a script that can convert such config files, even
recursively in all subdirectories to fix up all your GOG games. You can
download it from [here](https://github.com/dosbox-staging/dosbox-staging/blob/main/contrib/scripts/GOGconf-cp437-to-UTF8.bat).
Make sure to install the required dependencies as described in the
[readme](https://github.com/dosbox-staging/dosbox-staging/blob/main/contrib/scripts/tools/readme-gog437.txt).


??? note "Full PR list of localisation-related changes"

    - Add batch file (Windows) to convert GOG cp437 config files to UTF-8 (#3031)
    - Add countries and historic locales from OS/2 Warp 4.52 (#3182)
    - Add legacy codepage to UTF-8 script (#3029)
    - Add more definitions to Unicode engine (#3084)
    - Add translation batch file for Windows (#2303)
    - Country codes cleanup, fix incorrect country set in some cases (#3134)
    - Country support improvements (#3164)
    - Fix UTF8 to DOS conversion by mistake applied twice in autoexec code (#2645)
    - Fix extended ASCII codes not being rendered in batch files (#3028)
    - Fix few English strings, update Polish (pl) translation (#2295)
    - Fix problem with loading Unicode data files in some situations (#2641)
    - Fix some mistakes in code page character to Unicode mappings (#2490)
    - Group together shell error strings (#2343)
    - Handle host code pages when running `dosbox.exe --help` on Windows (#3064)
    - Improve Arabic support in Unicode engine (#2458)
    - Improve Unicode character fallback rules (#2594)
    - Improve batch file to convert GOG cp437 config files to UTF-8 (#3042)
    - Let the command line `--help` text be translatable (#3052)
    - Make `--list-glshaders` output translatable (#3178)
    - Minor Unicode definitions improvements (#3153)
    - Minor country and help fixes (#3186)
    - Rework AUTOEXEC.BAT support, make it UTF-8 aware (#2425)
    - Simplify translation workflow (#2954)
    - Two trivial fixes (#2423)
    - Unicode (and [autoexec]) improvements (#2422)
    - Unicode engine improvements (#2548)
    - Unicode mapping for CYRILLIC LETTER I WITH GRAVE, RUBLE, BG (#2621)
    - Update Dutch (nl) translation (#3187)
    - Update Dutch (nl) translation (#3069)
    - Update Dutch (nl) translation (#2974)
    - Update Dutch (nl) translation (#2824)
    - Update Dutch (nl) translation (#2680)
    - Update Dutch (nl) translation (#2657)
    - Update Dutch (nl) translation (#2372)
    - Update Italian (it-IT) translation (#2385)
    - Update Italian (it-IT) translation (#2327)
    - Update Italian (it-IT) translation (improved some strings) (#2419)
    - Update Italian (it-it)  translation (#2302)
    - Update Italian (it-it) translation (#3137)
    - Update Italian (it-it) translation (#3065)
    - Update Italian (it-it) translation (#2980)
    - Update Italian (it-it) translation (#2815)
    - Update Italian (it-it) translation (#2737)
    - Update Italian (it-it) translation (#2702)
    - Update Italian (it-it) translation (#2643)
    - Update Italian (it-it) translation (#2584)
    - Update Italian (it-it) translation (#2497)
    - Update Italian (it-it) translation (#2476)
    - Update Italian (it-it) translation (#2226)
    - Update Polish (pl) translation (#3190)
    - Update Polish (pl) translation (#3176)
    - Update Polish (pl) translation (#3071)
    - Update Polish (pl) translation (#3033)
    - Update Polish (pl) translation (#2810)
    - Update Polish (pl) translation (#2493)
    - Update Polish (pl) translation (#2381)
    - Update Polish (pl) translation (#2337)
    - Update Polish (pl) translation (#2300)
    - Update Polish (pl) translation, fix one more English string (#2724)
    - Update Polish (pl) translation, trivial fix to one help string (#2644)


## Contributors

The following commit authors, sponsors, supporters, and backers all invested
their time or funds into the 0.81 release effort. Thank you!

Contributors are listed in alphabetic order.

Thank you for considering supporting our work through a donation on
[GitHub Sponsors](https://github.com/sponsors/dosbox-staging) or
[Open Collective](https://opencollective.com/dosbox-staging). Your
contribution helps us purchase the necessary hardware and licenses to keep our
project going.


### 0.81 commit authors

Complete list of commit authors who have contributed code, documentation, or
translation changes:

<div class="compact" markdown>

- Burrito78
- classilla
- d10sfan
- dreamer
- farsil
- FeralChild64
- flakesl
- ftortoriello
- GranMinigun
- Grounded0
- h3xx
- johnnovak
- Kappa971
- kcgen
- keenanweaver
- khalid586
- kklobe
- LowLevelMahn
- MaddTheSane
- MeAreJeenius
- NicknineTheEagle
- Nopey
- rderooy
- runlevel5
- shermp
- signed-log
- sulix
- thaewrapt
- ThomasEricB
- Torinde
- weirddan455

</div>


### 0.81 sponsors

Sponsors who have donated **100 USD** or more per month:

<div class="compact" markdown>

- Antti Peltola

</div>

### 0.81 supporters

Supporters who have donated **25 USD** or more per month:

<div class="compact" markdown>

- Wengier Wu

</div>


### 0.81 backers

Backers who have donated **5 USD** or more per month:

<div class="compact" markdown>

- BenBudr
- Burrito78
- flakesl
- Florent Wagner
- Hannu Hartikainen
- Hugo Lucorcio
- MagnusPerotinus
- Robin Mattheussen
- Thomas Eric

</div>


## Thank you

We are grateful for all community contributions as well as the original DOSBox
project, upon which DOSBox Staging is based.

