///////////////////////////////////////////////////////////////////////////////
//                                                         
// FirstHash.cc
// ------------
// Dragon first hash implementation
// 
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2007 by Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: FirstHash
// 
// Description: access to dragon termianal information 
//
///////////////////////////////////////////////////////////////////////////////

#include "FirstHash.h"

///////////// FirstHash ////////////////

FirstHash::FirstHash()
{
}

FirstHash::FirstHash(const Chain& prodName, const SetT<Chain>& firstSet)
{
    _prodName = prodName;
    _firstSet = firstSet;
}

FirstHash::FirstHash(const Chain& prodName)
{
    _prodName = prodName;
}

FirstHash::~FirstHash()
{
}

SetT<Chain>& FirstHash::getFirstSet()
{
    return _firstSet;
}

FirstHash& FirstHash::operator = (const FirstHash& s)
{
    _prodName = s._prodName;
    _firstSet = s._firstSet;
    return (*this);
}

bool FirstHash::operator == (const FirstHash& s)
{
  return (_prodName == s._prodName);
}
