;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; Check that we take exactness into account correctly depending on the
;; features. It differentiates shapes only when custom descriptors is enabled.

;; RUN: wasm-opt %s -all                              --minimize-rec-groups -S -o - | filecheck %s
;; RUN: wasm-opt %s -all --disable-custom-descriptors --minimize-rec-groups -S -o - | filecheck %s --check-prefix=NO_CD

(module
  (rec
    (type $foo (struct))

    ;; This SCC has only one distinct permutation.
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $b-inexact (struct (field (ref $a-inexact))))

    ;; CHECK:       (type $a-inexact (struct (field (ref $b-inexact))))
    ;; NO_CD:      (rec
    ;; NO_CD-NEXT:  (type $b-inexact (struct (field (ref $a-inexact))))

    ;; NO_CD:       (type $a-inexact (struct (field (ref $b-inexact))))
    (type $a-inexact (struct (field (ref $b-inexact))))
    (type $b-inexact (struct (field (ref $a-inexact))))

    ;; This SCC is only different because of exactness. It needs a brand only if
    ;; custom descriptors is disabled.
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $b-exact (struct (field (ref (exact $a-exact)))))

    ;; CHECK:       (type $a-exact (struct (field (ref (exact $b-exact)))))
    ;; NO_CD:      (rec
    ;; NO_CD-NEXT:  (type $2 (struct))

    ;; NO_CD:       (type $b-exact (struct (field (ref (exact $a-exact)))))

    ;; NO_CD:       (type $a-exact (struct (field (ref (exact $b-exact)))))
    (type $a-exact (struct (field (ref (exact $b-exact)))))
    (type $b-exact (struct (field (ref (exact $a-exact)))))
  )

  ;; CHECK:      (global $a-inexact (ref null $a-inexact) (ref.null none))
  ;; NO_CD:      (global $a-inexact (ref null $a-inexact) (ref.null none))
  (global $a-inexact (ref null $a-inexact) (ref.null none))
  ;; CHECK:      (global $b-inexact (ref null $b-inexact) (ref.null none))
  ;; NO_CD:      (global $b-inexact (ref null $b-inexact) (ref.null none))
  (global $b-inexact (ref null $b-inexact) (ref.null none))
  ;; CHECK:      (global $a-exact (ref null $a-exact) (ref.null none))
  ;; NO_CD:      (global $a-exact (ref null $a-exact) (ref.null none))
  (global $a-exact (ref null $a-exact) (ref.null none))
  ;; CHECK:      (global $b-exact (ref null $b-exact) (ref.null none))
  ;; NO_CD:      (global $b-exact (ref null $b-exact) (ref.null none))
  (global $b-exact (ref null $b-exact) (ref.null none))
)
