;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: env BINARYEN_PRINT_FULL=1 foreach %s %t wasm-opt --gsi -all --closed-world -S -o - | filecheck %s

;; Test that debug info is copied to the values we replace a struct.get with.
;; We use BINARYEN_PRINT_FULL=1 here because the select that contains the
;; values also gets that debug info, and normally we omit debug info of children
;; when it matches the parent (so we could not tell without
;; BINARYEN_PRINT_FULL=1 whether the children had the debug info or not).
;; (Another way to test this would be to run a followup optimization to remove
;; the select, but that would be more complex.)

(module
  ;; CHECK:      (type $struct (struct (field i32)))
  (type $struct (struct i32))

  ;; CHECK:      (type $1 (func (param (ref null $struct))))

  ;; CHECK:      (global $global1 (ref $struct) (struct.new $struct
  ;; CHECK-NEXT:  (i32.const 42) (; i32 ;)
  ;; CHECK-NEXT: ))
  (global $global1 (ref $struct) (struct.new $struct
    (i32.const 42)
  ))

  ;; CHECK:      (global $global2 (ref $struct) (struct.new $struct
  ;; CHECK-NEXT:  (i32.const 1337) (; i32 ;)
  ;; CHECK-NEXT: ))
  (global $global2 (ref $struct) (struct.new $struct
    (i32.const 1337)
  ))

  ;; A non-reference global does not confuse us.
  ;; CHECK:      (global $global-other i32 (i32.const 123456))
  (global $global-other i32 (i32.const 123456))

  ;; CHECK:      (func $test (type $1) (; (ref (exact $func.0)) ;) (param $struct (ref null $struct))
  ;; CHECK-NEXT:  ;;@ drop.c:10:1
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   ;;@ struct.c:20:2
  ;; CHECK-NEXT:   (select
  ;; CHECK-NEXT:    ;;@ struct.c:20:2
  ;; CHECK-NEXT:    (i32.const 42) (; i32 ;)
  ;; CHECK-NEXT:    ;;@ struct.c:20:2
  ;; CHECK-NEXT:    (i32.const 1337) (; i32 ;)
  ;; CHECK-NEXT:    ;;@
  ;; CHECK-NEXT:    (ref.eq
  ;; CHECK-NEXT:     ;;@
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      ;;@ local.c:30:3
  ;; CHECK-NEXT:      (local.get $struct) (; (ref null $struct) ;)
  ;; CHECK-NEXT:     ) (; (ref $struct) ;)
  ;; CHECK-NEXT:     ;;@
  ;; CHECK-NEXT:     (global.get $global1) (; (ref $struct) ;)
  ;; CHECK-NEXT:    ) (; i32 ;)
  ;; CHECK-NEXT:   ) (; i32 ;)
  ;; CHECK-NEXT:  ) (; none ;)
  ;; CHECK-NEXT: )
  (func $test (param $struct (ref null $struct))
    ;; We can infer that this get can reference either $global1 or $global2,
    ;; and nothing else (aside from a null), and can emit a select between
    ;; those values. While doing so we copy the debug info as well to the
    ;; values in the select.
    ;;@ drop.c:10:1
    (drop
      ;;@ struct.c:20:2
      (struct.get $struct 0
        ;;@ local.c:30:3
        (local.get $struct)
      )
    )
  )
)

