;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: foreach %s %t wasm-opt --signature-refining --closed-world -all -S -o - | filecheck %s
;; RUN: foreach %s %t wasm-opt --signature-refining                -all -S -o - | filecheck %s --check-prefix OPEN_WORLD

;; Test that configureAll is respected: referred functions are not refined.
;; This is so even in closed world.

(module
  ;; CHECK:      (type $externs (array (mut externref)))
  ;; OPEN_WORLD:      (type $externs (array (mut externref)))
  (type $externs (array (mut externref)))

  ;; CHECK:      (type $funcs (array (mut funcref)))
  ;; OPEN_WORLD:      (type $funcs (array (mut funcref)))
  (type $funcs (array (mut funcref)))

  ;; CHECK:      (type $bytes (array (mut i8)))
  ;; OPEN_WORLD:      (type $bytes (array (mut i8)))
  (type $bytes (array (mut i8)))

  ;; CHECK:      (rec
  ;; CHECK-NEXT:  (type $ret-any-2 (func (result (ref (exact $struct)))))

  ;; CHECK:       (type $struct (struct))

  ;; CHECK:       (type $5 (func))

  ;; CHECK:      (type $configureAll (func (param (ref null $externs) (ref null $funcs) (ref null $bytes) externref)))
  ;; OPEN_WORLD:      (rec
  ;; OPEN_WORLD-NEXT:  (type $ret-any-2 (func (result (ref (exact $struct)))))

  ;; OPEN_WORLD:       (type $struct (struct))

  ;; OPEN_WORLD:       (type $5 (func))

  ;; OPEN_WORLD:      (type $configureAll (func (param (ref null $externs) (ref null $funcs) (ref null $bytes) externref)))
  (type $configureAll (func (param (ref null $externs)) (param (ref null $funcs)) (param (ref null $bytes)) (param externref)))

  (type $struct (struct))

  (rec
    ;; CHECK:      (type $7 (func (result i32)))

    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $ret-any-1 (func (result anyref)))
    ;; OPEN_WORLD:      (type $7 (func (result i32)))

    ;; OPEN_WORLD:      (rec
    ;; OPEN_WORLD-NEXT:  (type $ret-any-1 (func (result anyref)))
    (type $ret-any-1 (func (result anyref)))

    ;; use brands to allow $ret-any-1/2 to be optimized separately.
    ;; CHECK:       (type $brand1 (struct))
    ;; OPEN_WORLD:       (type $brand1 (struct))
    (type $brand1 (struct))
  )

  (rec
    (type $ret-any-2 (func (result anyref)))

    (type $brand2 (struct))
    (type $brand3 (struct))
  )

  ;; CHECK:      (import "wasm:js-prototypes" "configureAll" (func $configureAll (type $configureAll) (param (ref null $externs) (ref null $funcs) (ref null $bytes) externref)))
  ;; OPEN_WORLD:      (import "wasm:js-prototypes" "configureAll" (func $configureAll (type $configureAll) (param (ref null $externs) (ref null $funcs) (ref null $bytes) externref)))
  (import "wasm:js-prototypes" "configureAll" (func $configureAll (type $configureAll)))

  ;; CHECK:      (data $bytes "12345678")

  ;; CHECK:      (elem $externs externref (item (ref.null noextern)))
  ;; OPEN_WORLD:      (data $bytes "12345678")

  ;; OPEN_WORLD:      (elem $externs externref (item (ref.null noextern)))
  (elem $externs externref
    (ref.null extern)
  )

  ;; CHECK:      (elem $funcs func $foo $bar)
  ;; OPEN_WORLD:      (elem $funcs func $foo $bar)
  (elem $funcs funcref
    (ref.func $foo)
    (ref.func $bar)
  )

  (data $bytes "12345678")

  ;; CHECK:      (start $start)
  ;; OPEN_WORLD:      (start $start)
  (start $start)

  ;; CHECK:      (func $start (type $5)
  ;; CHECK-NEXT:  (call $configureAll
  ;; CHECK-NEXT:   (array.new_elem $externs $externs
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (array.new_elem $funcs $funcs
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (array.new_data $bytes $bytes
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 8)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (ref.null noextern)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; OPEN_WORLD:      (func $start (type $5)
  ;; OPEN_WORLD-NEXT:  (call $configureAll
  ;; OPEN_WORLD-NEXT:   (array.new_elem $externs $externs
  ;; OPEN_WORLD-NEXT:    (i32.const 0)
  ;; OPEN_WORLD-NEXT:    (i32.const 1)
  ;; OPEN_WORLD-NEXT:   )
  ;; OPEN_WORLD-NEXT:   (array.new_elem $funcs $funcs
  ;; OPEN_WORLD-NEXT:    (i32.const 0)
  ;; OPEN_WORLD-NEXT:    (i32.const 2)
  ;; OPEN_WORLD-NEXT:   )
  ;; OPEN_WORLD-NEXT:   (array.new_data $bytes $bytes
  ;; OPEN_WORLD-NEXT:    (i32.const 0)
  ;; OPEN_WORLD-NEXT:    (i32.const 8)
  ;; OPEN_WORLD-NEXT:   )
  ;; OPEN_WORLD-NEXT:   (ref.null noextern)
  ;; OPEN_WORLD-NEXT:  )
  ;; OPEN_WORLD-NEXT: )
  (func $start
    (call $configureAll
      (array.new_elem $externs $externs
        (i32.const 0) (i32.const 1))
      (array.new_elem $funcs $funcs
        (i32.const 0) (i32.const 2))
      (array.new_data $bytes $bytes
        (i32.const 0) (i32.const 8))
      (ref.null extern)
    )
  )

  ;; CHECK:      (func $foo (type $7) (result i32)
  ;; CHECK-NEXT:  (i32.const 42)
  ;; CHECK-NEXT: )
  ;; OPEN_WORLD:      (func $foo (type $7) (result i32)
  ;; OPEN_WORLD-NEXT:  (i32.const 42)
  ;; OPEN_WORLD-NEXT: )
  (func $foo (result i32)
    ;; Nothing to do here anyhow, but do not error.
    (i32.const 42)
  )

  ;; CHECK:      (func $bar (type $ret-any-1) (result anyref)
  ;; CHECK-NEXT:  (struct.new_default $struct)
  ;; CHECK-NEXT: )
  ;; OPEN_WORLD:      (func $bar (type $ret-any-1) (result anyref)
  ;; OPEN_WORLD-NEXT:  (struct.new_default $struct)
  ;; OPEN_WORLD-NEXT: )
  (func $bar (type $ret-any-1) (result anyref)
    ;; This will not be refined due to configureAll.
    (struct.new $struct)
  )

  ;; CHECK:      (func $unconfigured (type $ret-any-2) (result (ref (exact $struct)))
  ;; CHECK-NEXT:  (struct.new_default $struct)
  ;; CHECK-NEXT: )
  ;; OPEN_WORLD:      (func $unconfigured (type $ret-any-2) (result (ref (exact $struct)))
  ;; OPEN_WORLD-NEXT:  (struct.new_default $struct)
  ;; OPEN_WORLD-NEXT: )
  (func $unconfigured (type $ret-any-2) (result anyref)
    ;; This is not referred to by configureAll, and can be refined.
    (struct.new $struct)
  )
)
