# Documentation

## Getting Started
- [FAQ](FAQ.md)
- [Quickstart](Quickstart.md)
- [Flecs Script Tutorial](FlecsScriptTutorial.md)
- [Designing with Flecs](DesignWithFlecs.md)
- [Getting Started with Unreal Engine](https://github.com/PreyK/Unreal-Minimum-Viable-Flecs)

## Manuals
- [Manual](Manual.md)
- [Query Manual](Queries.md)
- [Systems Manual](Systems.md)
- [Relationships Manual](Relationships.md)
- [JSON Format Manual](JsonFormat.md)
- [REST API Manual](RestApi.md)

## API reference
 - [C API](@ref c)
 - [C++ API](@ref cpp)

## Examples
- [C examples](https://github.com/SanderMertens/flecs/tree/master/examples/c)
- [C++ examples](https://github.com/SanderMertens/flecs/tree/master/examples/cpp)

## Demos
- [Tower Defense (C++)](https://github.com/SanderMertens/tower_defense)
- [City (C)](https://github.com/flecs-hub/city)

## Articles
- [Where are my entities and components](https://ajmmertens.medium.com/building-an-ecs-1-where-are-my-entities-and-components-63d07c7da742)
- [Archetypes and vectorization](https://ajmmertens.medium.com/building-an-ecs-2-archetypes-and-vectorization-fe21690805f9)
- [Making the most of entity identifiers](https://ajmmertens.medium.com/doing-a-lot-with-a-little-ecs-identifiers-25a72bd2647)
- [Building games in ECS with entity relationships](https://ajmmertens.medium.com/building-games-in-ecs-with-entity-relationships-657275ba2c6c)
- [Why storing state machines in ECS is a bad idea](https://ajmmertens.medium.com/why-storing-state-machines-in-ecs-is-a-bad-idea-742de7a18e59)
- [Why vanilla ECS is not enough](https://ajmmertens.medium.com/why-vanilla-ecs-is-not-enough-d7ed4e3bebe5)
- [ECS: From tool to paradigm](https://ajmmertens.medium.com/ecs-from-tool-to-paradigm-350587cdf216)
