/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpfontselect_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpfontselect
 * @title: gimpfontselect
 * @short_description: Methods of a font chooser dialog.
 *
 * A font chooser dialog shows installed fonts.
 * The dialog is non-modal with its owning dialog,
 * which is usually a plugin procedure's dialog.
 * When a user selects a font,
 * the dialog calls back but the dialog remains open.
 * The chosen font is only a choice for the owning widget
 * and does not select the font for the context.
 * The user can close but not cancel the dialog.
 * The owning dialog can close the font chooser dialog
 * when the user closes or cancels the owning dialog.
 **/


/**
 * gimp_fonts_popup:
 * @font_callback: The callback PDB proc to call when user chooses a font.
 * @popup_title: Title of the font selection dialog.
 * @initial_font: The name of the initial font choice.
 * @parent_window: An optional parent window handle for the popup to be set transient to.
 *
 * Invokes the Gimp font selection dialog.
 *
 * Opens a dialog letting a user choose a font.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_fonts_popup (const gchar *font_callback,
                  const gchar *popup_title,
                  GimpFont    *initial_font,
                  GBytes      *parent_window)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, font_callback,
                                          G_TYPE_STRING, popup_title,
                                          GIMP_TYPE_FONT, initial_font,
                                          G_TYPE_BYTES, parent_window,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-fonts-popup",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_fonts_close_popup:
 * @font_callback: The name of the callback registered in the PDB for this dialog.
 *
 * Close the font selection dialog.
 *
 * Closes an open font selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_fonts_close_popup (const gchar *font_callback)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, font_callback,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-fonts-close-popup",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_fonts_set_popup:
 * @font_callback: The name of the callback registered in the PDB for the dialog.
 * @font: The font to set as selected.
 *
 * Sets the current font in a font selection dialog.
 *
 * Sets the current font in a font selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_fonts_set_popup (const gchar *font_callback,
                      GimpFont    *font)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, font_callback,
                                          GIMP_TYPE_FONT, font,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-fonts-set-popup",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
