// Generated by gmmproc 2.82.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <giomm/bufferedinputstream.h>
#include <giomm/private/bufferedinputstream_p.h>


/* Copyright (C) 2008 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gio/gio.h>
#include <glibmm/error.h>
#include <giomm/slot_async.h>

namespace Gio
{
Glib::RefPtr<BufferedInputStream>
BufferedInputStream::create_sized(const Glib::RefPtr<InputStream>& base_stream, gsize buffer_size)
{
  return Glib::make_refptr_for_instance<Gio::BufferedInputStream>(new BufferedInputStream(base_stream, buffer_size));
}

void
BufferedInputStream::fill_async(const SlotAsyncReady& slot, gssize count,
  const Glib::RefPtr<Cancellable>& cancellable, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  auto slot_copy = new SlotAsyncReady(slot);

  g_buffered_input_stream_fill_async(
    gobj(), count, io_priority, Glib::unwrap(cancellable), &giomm_SignalProxy_async_callback, slot_copy);
}

void
BufferedInputStream::fill_async(const SlotAsyncReady& slot, gssize count, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  auto slot_copy = new SlotAsyncReady(slot);

  g_buffered_input_stream_fill_async(
    gobj(), count, io_priority, nullptr, &giomm_SignalProxy_async_callback, slot_copy);
}

} // namespace Gio

namespace
{
using BufferedInputStream_fill_vfunc_functype = gssize (*)(GBufferedInputStream* self, gssize count, GCancellable* cancellable, GError** error);
BufferedInputStream_fill_vfunc_functype BufferedInputStream_fill_vfunc_funcptr;
extern "C" {
static gssize BufferedInputStream_fill_vfunc_c_callback(GBufferedInputStream* self, gssize count, GCancellable* cancellable, GError** error)
{
  return BufferedInputStream_fill_vfunc_funcptr( self, count, cancellable, error);
}
} // extern "C"
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::BufferedInputStream> wrap(GBufferedInputStream* object, bool take_copy)
{
  return Glib::make_refptr_for_instance<Gio::BufferedInputStream>( dynamic_cast<Gio::BufferedInputStream*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& BufferedInputStream_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &BufferedInputStream_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_buffered_input_stream_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Seekable::add_interface(get_type());

  }

  return *this;
}


void BufferedInputStream_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->fill = &BufferedInputStream_fill_vfunc_c_callback;
  BufferedInputStream_fill_vfunc_funcptr = &fill_vfunc_callback;

}

gssize BufferedInputStream_Class::fill_vfunc_callback(GBufferedInputStream* self, gssize count, GCancellable* cancellable, GError** error)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return obj->fill_vfunc(count, Glib::wrap(cancellable, true)
);
      }
      catch(Glib::Error& errormm)
      {
        errormm.propagate(error);
        return -1;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->fill)
    return (*base->fill)(self, count, cancellable, error);

  using RType = gssize;
  return RType();
}


Glib::ObjectBase* BufferedInputStream_Class::wrap_new(GObject* object)
{
  return new BufferedInputStream((GBufferedInputStream*)object);
}


/* The implementation: */

GBufferedInputStream* BufferedInputStream::gobj_copy()
{
  reference();
  return gobj();
}

BufferedInputStream::BufferedInputStream(const Glib::ConstructParams& construct_params)
:
  Gio::FilterInputStream(construct_params)
{

}

BufferedInputStream::BufferedInputStream(GBufferedInputStream* castitem)
:
  Gio::FilterInputStream((GFilterInputStream*)(castitem))
{}


BufferedInputStream::BufferedInputStream(BufferedInputStream&& src) noexcept
: Gio::FilterInputStream(std::move(src))
  , Seekable(std::move(src))
{}

BufferedInputStream& BufferedInputStream::operator=(BufferedInputStream&& src) noexcept
{
  Gio::FilterInputStream::operator=(std::move(src));
  Seekable::operator=(std::move(src));
  return *this;
}


BufferedInputStream::~BufferedInputStream() noexcept
{}


BufferedInputStream::CppClassType BufferedInputStream::bufferedinputstream_class_; // initialize static member

GType BufferedInputStream::get_type()
{
  return bufferedinputstream_class_.init().get_type();
}


GType BufferedInputStream::get_base_type()
{
  return g_buffered_input_stream_get_type();
}


BufferedInputStream::BufferedInputStream(const Glib::RefPtr<InputStream>& base_stream)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gio::FilterInputStream(Glib::ConstructParams(bufferedinputstream_class_.init(), "base_stream", const_cast<GInputStream*>(Glib::unwrap(base_stream)), nullptr))
{
  

}

BufferedInputStream::BufferedInputStream(const Glib::RefPtr<InputStream>& base_stream, gsize buffer_size)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gio::FilterInputStream(Glib::ConstructParams(bufferedinputstream_class_.init(), "base_stream", const_cast<GInputStream*>(Glib::unwrap(base_stream)), "buffer_size", buffer_size, nullptr))
{
  

}

Glib::RefPtr<BufferedInputStream> BufferedInputStream::create(const Glib::RefPtr<InputStream>& base_stream)
{
  return Glib::make_refptr_for_instance<BufferedInputStream>( new BufferedInputStream(base_stream) );
}

gsize BufferedInputStream::get_buffer_size() const
{
  return g_buffered_input_stream_get_buffer_size(const_cast<GBufferedInputStream*>(gobj()));
}

void BufferedInputStream::set_buffer_size(gsize size)
{
  g_buffered_input_stream_set_buffer_size(gobj(), size);
}

gsize BufferedInputStream::get_available() const
{
  return g_buffered_input_stream_get_available(const_cast<GBufferedInputStream*>(gobj()));
}

gsize BufferedInputStream::peek(void* buffer, gsize offset, gsize count) const
{
  return g_buffered_input_stream_peek(const_cast<GBufferedInputStream*>(gobj()), buffer, offset, count);
}

const void* BufferedInputStream::peek_buffer(gsize& count) const
{
  return g_buffered_input_stream_peek_buffer(const_cast<GBufferedInputStream*>(gobj()), &(count));
}

gssize BufferedInputStream::fill(gssize count, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  auto retvalue = g_buffered_input_stream_fill(gobj(), count, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

gssize BufferedInputStream::fill(gssize count)
{
  GError* gerror = nullptr;
  auto retvalue = g_buffered_input_stream_fill(gobj(), count, nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

gssize BufferedInputStream::fill_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  auto retvalue = g_buffered_input_stream_fill_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

int BufferedInputStream::read_byte(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  auto retvalue = g_buffered_input_stream_read_byte(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

int BufferedInputStream::read_byte()
{
  GError* gerror = nullptr;
  auto retvalue = g_buffered_input_stream_read_byte(gobj(), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}


Glib::PropertyProxy< guint > BufferedInputStream::property_buffer_size() 
{
  return Glib::PropertyProxy< guint >(this, "buffer-size");
}

Glib::PropertyProxy_ReadOnly< guint > BufferedInputStream::property_buffer_size() const
{
  return Glib::PropertyProxy_ReadOnly< guint >(this, "buffer-size");
}


gssize Gio::BufferedInputStream::fill_vfunc(gssize count, const Glib::RefPtr<Cancellable>& cancellable) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->fill)
  {
    GError* gerror = nullptr;
    gssize retval((*base->fill)(gobj(),count,const_cast<GCancellable*>(Glib::unwrap(cancellable)),&(gerror)));
    if(gerror)
      ::Glib::Error::throw_exception(gerror);
    return retval;
  }

  using RType = gssize;
  return RType();
}


} // namespace Gio


