// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#include "test/cpp/microbenchmarks/huffman_geometries/decode_huff_10_7_13.h"

#include <grpc/support/port_platform.h>
namespace grpc_core {
namespace geometry_10_7_13 {
const uint8_t HuffDecoderCommon::table2_0_emit_[10] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74};
const uint8_t HuffDecoderCommon::table2_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table3_0_emit_[36] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20, 0x25,
    0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3d, 0x41,
    0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70, 0x72, 0x75};
const uint8_t HuffDecoderCommon::table3_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x29, 0x2d,
    0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59,
    0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85,
    0x89, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table4_0_emit_[22] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20,
    0x25, 0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table4_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00,
    0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x25, 0x00, 0x29, 0x00, 0x2d,
    0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41, 0x00,
    0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table4_1_emit_[46] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70,
    0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a,
    0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
    0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table4_1_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49,
    0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75,
    0x79, 0x7d, 0x81, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1,
    0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table4_emit_[2] = {
    table4_0_emit_,
    table4_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table4_ops_[2] = {
    table4_0_ops_,
    table4_1_ops_,
};
const uint8_t HuffDecoderCommon::table5_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29,
    0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35,
    0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x41,
    0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4d,
    0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table5_1_emit_[52] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e,
    0x70, 0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78,
    0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint8_t HuffDecoderCommon::table5_1_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d,
    0x00, 0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55,
    0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x00, 0x65, 0x00, 0x69, 0x00, 0x6d,
    0x00, 0x71, 0x00, 0x75, 0x00, 0x79, 0x00, 0x7d, 0x00, 0x81, 0x00, 0x85,
    0x00, 0x89, 0x00, 0x8d, 0x00, 0x91, 0x00, 0x95, 0x00, 0x99, 0x00, 0x9d,
    0x00, 0xa1, 0x00, 0xa5, 0x00, 0xa9, 0x00, 0xad, 0x00, 0xb1, 0x00, 0xb5,
    0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table5_emit_[2] = {
    table4_0_emit_,
    table5_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table5_ops_[2] = {
    table5_0_ops_,
    table5_1_ops_,
};
const uint8_t HuffDecoderCommon::table6_0_emit_[2] = {0x30, 0x31};
const uint8_t HuffDecoderCommon::table6_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05};
const uint8_t HuffDecoderCommon::table6_1_emit_[2] = {0x32, 0x61};
const uint8_t HuffDecoderCommon::table6_2_emit_[2] = {0x63, 0x65};
const uint8_t HuffDecoderCommon::table6_3_emit_[2] = {0x69, 0x6f};
const uint8_t HuffDecoderCommon::table6_4_emit_[2] = {0x73, 0x74};
const uint8_t HuffDecoderCommon::table6_5_emit_[4] = {0x20, 0x25, 0x2d, 0x2e};
const uint8_t HuffDecoderCommon::table6_5_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d};
const uint8_t HuffDecoderCommon::table6_6_emit_[4] = {0x2f, 0x33, 0x34, 0x35};
const uint8_t HuffDecoderCommon::table6_7_emit_[4] = {0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table6_8_emit_[4] = {0x3d, 0x41, 0x5f, 0x62};
const uint8_t HuffDecoderCommon::table6_9_emit_[4] = {0x64, 0x66, 0x67, 0x68};
const uint8_t HuffDecoderCommon::table6_10_emit_[4] = {0x6c, 0x6d, 0x6e, 0x70};
const uint8_t HuffDecoderCommon::table6_11_emit_[6] = {0x72, 0x75, 0x3a,
                                                       0x42, 0x43, 0x44};
const uint8_t HuffDecoderCommon::table6_11_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
    0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15};
const uint8_t HuffDecoderCommon::table6_12_emit_[8] = {0x45, 0x46, 0x47, 0x48,
                                                       0x49, 0x4a, 0x4b, 0x4c};
const uint8_t HuffDecoderCommon::table6_12_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d};
const uint8_t HuffDecoderCommon::table6_13_emit_[8] = {0x4d, 0x4e, 0x4f, 0x50,
                                                       0x51, 0x52, 0x53, 0x54};
const uint8_t HuffDecoderCommon::table6_14_emit_[8] = {0x55, 0x56, 0x57, 0x59,
                                                       0x6a, 0x6b, 0x71, 0x76};
const uint8_t HuffDecoderCommon::table6_15_emit_[10] = {
    0x77, 0x78, 0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint8_t HuffDecoderCommon::table6_15_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x11, 0x00, 0x15, 0x00, 0x19,
    0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table6_emit_[16] = {
    table6_0_emit_,  table6_1_emit_,  table6_2_emit_,  table6_3_emit_,
    table6_4_emit_,  table6_5_emit_,  table6_6_emit_,  table6_7_emit_,
    table6_8_emit_,  table6_9_emit_,  table6_10_emit_, table6_11_emit_,
    table6_12_emit_, table6_13_emit_, table6_14_emit_, table6_15_emit_,
};
const uint8_t* const HuffDecoderCommon::table6_ops_[16] = {
    table6_0_ops_,  table6_0_ops_,  table6_0_ops_,  table6_0_ops_,
    table6_0_ops_,  table6_5_ops_,  table6_5_ops_,  table6_5_ops_,
    table6_5_ops_,  table6_5_ops_,  table6_5_ops_,  table6_11_ops_,
    table6_12_ops_, table6_12_ops_, table6_12_ops_, table6_15_ops_,
};
const uint8_t HuffDecoderCommon::table1_0_emit_[36] = {
    0x30, 0x30, 0x31, 0x30, 0x32, 0x30, 0x61, 0x30, 0x63, 0x30, 0x65, 0x30,
    0x69, 0x30, 0x6f, 0x30, 0x73, 0x30, 0x74, 0x31, 0x31, 0x32, 0x31, 0x61,
    0x31, 0x63, 0x31, 0x65, 0x31, 0x69, 0x31, 0x6f, 0x31, 0x73, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table1_0_inner_[22] = {
    0x000a, 0x008a, 0x018a, 0x028a, 0x038a, 0x048a, 0x058a, 0x068a,
    0x078a, 0x088a, 0x0015, 0x010a, 0x098a, 0x0a0a, 0x0b0a, 0x0c0a,
    0x0d0a, 0x0e0a, 0x0f0a, 0x100a, 0x110a, 0x0115};
const uint8_t HuffDecoderCommon::table1_0_outer_[64] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 21, 21, 21, 21, 21,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21};
const uint8_t HuffDecoderCommon::table1_1_emit_[36] = {
    0x32, 0x30, 0x32, 0x31, 0x32, 0x32, 0x61, 0x32, 0x63, 0x32, 0x65, 0x32,
    0x69, 0x32, 0x6f, 0x32, 0x73, 0x32, 0x74, 0x61, 0x30, 0x61, 0x31, 0x61,
    0x61, 0x63, 0x61, 0x65, 0x61, 0x69, 0x61, 0x6f, 0x61, 0x73, 0x61, 0x74};
const uint16_t HuffDecoderCommon::table1_1_inner_[22] = {
    0x000a, 0x010a, 0x020a, 0x028a, 0x038a, 0x048a, 0x058a, 0x068a,
    0x078a, 0x088a, 0x0015, 0x098a, 0x0a8a, 0x030a, 0x0b8a, 0x0c0a,
    0x0d0a, 0x0e0a, 0x0f0a, 0x100a, 0x110a, 0x0315};
const uint8_t HuffDecoderCommon::table1_2_emit_[36] = {
    0x63, 0x30, 0x63, 0x31, 0x63, 0x32, 0x63, 0x61, 0x63, 0x63, 0x65, 0x63,
    0x69, 0x63, 0x6f, 0x63, 0x73, 0x63, 0x74, 0x65, 0x30, 0x65, 0x31, 0x65,
    0x32, 0x65, 0x61, 0x65, 0x65, 0x69, 0x65, 0x6f, 0x65, 0x73, 0x65, 0x74};
const uint16_t HuffDecoderCommon::table1_2_inner_[22] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x048a, 0x058a, 0x068a,
    0x078a, 0x088a, 0x0015, 0x098a, 0x0a8a, 0x0b8a, 0x0c8a, 0x050a,
    0x0d8a, 0x0e0a, 0x0f0a, 0x100a, 0x110a, 0x0515};
const uint8_t HuffDecoderCommon::table1_3_emit_[36] = {
    0x69, 0x30, 0x69, 0x31, 0x69, 0x32, 0x69, 0x61, 0x69, 0x63, 0x69, 0x65,
    0x69, 0x69, 0x6f, 0x69, 0x73, 0x69, 0x74, 0x6f, 0x30, 0x6f, 0x31, 0x6f,
    0x32, 0x6f, 0x61, 0x6f, 0x63, 0x6f, 0x65, 0x6f, 0x6f, 0x73, 0x6f, 0x74};
const uint16_t HuffDecoderCommon::table1_3_inner_[22] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x050a, 0x060a, 0x068a,
    0x078a, 0x088a, 0x0015, 0x098a, 0x0a8a, 0x0b8a, 0x0c8a, 0x0d8a,
    0x0e8a, 0x070a, 0x0f8a, 0x100a, 0x110a, 0x0715};
const uint8_t HuffDecoderCommon::table1_4_emit_[38] = {
    0x73, 0x30, 0x73, 0x31, 0x73, 0x32, 0x73, 0x61, 0x73, 0x63,
    0x73, 0x65, 0x73, 0x69, 0x73, 0x6f, 0x73, 0x73, 0x74, 0x30,
    0x74, 0x31, 0x74, 0x32, 0x74, 0x61, 0x74, 0x63, 0x74, 0x65,
    0x74, 0x69, 0x74, 0x6f, 0x74, 0x73, 0x74, 0x74};
const uint16_t HuffDecoderCommon::table1_4_inner_[22] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x050a, 0x060a, 0x070a,
    0x080a, 0x088a, 0x0015, 0x090a, 0x0a0a, 0x0b0a, 0x0c0a, 0x0d0a,
    0x0e0a, 0x0f0a, 0x100a, 0x110a, 0x120a, 0x0915};
const uint16_t HuffDecoderCommon::table1_5_inner_[4] = {0x0016, 0x0096, 0x0116,
                                                        0x0196};
const uint8_t HuffDecoderCommon::table1_5_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
const uint16_t HuffDecoderCommon::table1_11_inner_[6] = {
    0x0016, 0x0096, 0x0117, 0x0197, 0x0217, 0x0297};
const uint8_t HuffDecoderCommon::table1_11_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3,
    3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5};
const uint16_t HuffDecoderCommon::table1_12_inner_[8] = {
    0x0017, 0x0097, 0x0117, 0x0197, 0x0217, 0x0297, 0x0317, 0x0397};
const uint8_t HuffDecoderCommon::table1_12_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
    2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5,
    5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7};
const uint8_t HuffDecoderCommon::table1_15_emit_[15] = {
    0x77, 0x78, 0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b,
    0x58, 0x5a, 0x21, 0x22, 0x28, 0x29, 0x3f};
const uint16_t HuffDecoderCommon::table1_15_inner_[18] = {
    0x0017, 0x0097, 0x0117, 0x0197, 0x0218, 0x0298, 0x0318, 0x0398, 0x0418,
    0x0498, 0x051a, 0x059a, 0x061a, 0x069a, 0x071a, 0x002a, 0x003a, 0x004a};
const uint8_t HuffDecoderCommon::table1_15_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,  1,  1,  1,  2,  2,  2,  2, 2, 2,
    2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4,  4,  5,  5,  5,  5,  6,  6, 6, 6,
    7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 11, 12, 13, 14, 15, 16, 17};
const uint8_t* const HuffDecoderCommon::table1_emit_[16] = {
    table1_0_emit_,  table1_1_emit_,  table1_2_emit_,  table1_3_emit_,
    table1_4_emit_,  table6_5_emit_,  table6_6_emit_,  table6_7_emit_,
    table6_8_emit_,  table6_9_emit_,  table6_10_emit_, table6_11_emit_,
    table6_12_emit_, table6_13_emit_, table6_14_emit_, table1_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table1_inner_[16] = {
    table1_0_inner_,  table1_1_inner_,  table1_2_inner_,  table1_3_inner_,
    table1_4_inner_,  table1_5_inner_,  table1_5_inner_,  table1_5_inner_,
    table1_5_inner_,  table1_5_inner_,  table1_5_inner_,  table1_11_inner_,
    table1_12_inner_, table1_12_inner_, table1_12_inner_, table1_15_inner_,
};
const uint8_t* const HuffDecoderCommon::table1_outer_[16] = {
    table1_0_outer_,  table1_0_outer_,  table1_0_outer_,  table1_0_outer_,
    table1_0_outer_,  table1_5_outer_,  table1_5_outer_,  table1_5_outer_,
    table1_5_outer_,  table1_5_outer_,  table1_5_outer_,  table1_11_outer_,
    table1_12_outer_, table1_12_outer_, table1_12_outer_, table1_15_outer_,
};
const uint8_t HuffDecoderCommon::table9_0_emit_[6] = {0x00, 0x24, 0x40,
                                                      0x5b, 0x5d, 0x7e};
const uint8_t HuffDecoderCommon::table9_0_inner_[8] = {0x00, 0x04, 0x08, 0x0c,
                                                       0x10, 0x14, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table10_0_emit_[8] = {0x00, 0x24, 0x40, 0x5b,
                                                       0x5d, 0x7e, 0x5e, 0x7d};
const uint8_t HuffDecoderCommon::table10_0_inner_[10] = {
    0x00, 0x01, 0x05, 0x09, 0x0d, 0x11, 0x15, 0x19, 0x1d, 0x02};
const uint8_t HuffDecoderCommon::table10_0_outer_[16] = {
    0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 7, 8, 0, 9};
const uint8_t HuffDecoderCommon::table11_0_emit_[11] = {
    0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e, 0x5e, 0x7d, 0x3c, 0x60, 0x7b};
const uint8_t HuffDecoderCommon::table11_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x19, 0x00, 0x1d, 0x21, 0x25, 0x29, 0x02};
const uint8_t HuffDecoderCommon::table12_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00,
    0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table8_0_emit_[2] = {0x00, 0x24};
const uint16_t HuffDecoderCommon::table8_0_ops_[32] = {
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043,
    0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043};
const uint8_t HuffDecoderCommon::table8_1_emit_[2] = {0x40, 0x5b};
const uint8_t HuffDecoderCommon::table8_2_emit_[2] = {0x5d, 0x7e};
const uint8_t HuffDecoderCommon::table8_3_emit_[5] = {0x5e, 0x7d, 0x3c, 0x60,
                                                      0x7b};
const uint16_t HuffDecoderCommon::table8_3_ops_[32] = {
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
    0x0085, 0x0085, 0x0085, 0x0085, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
    0x0105, 0x0105, 0x0105, 0x0105, 0x000f, 0x0017, 0x001f, 0x0027};
const uint8_t* const HuffDecoderCommon::table8_emit_[4] = {
    table8_0_emit_,
    table8_1_emit_,
    table8_2_emit_,
    table8_3_emit_,
};
const uint16_t* const HuffDecoderCommon::table8_ops_[4] = {
    table8_0_ops_,
    table8_0_ops_,
    table8_0_ops_,
    table8_3_ops_,
};
const uint8_t HuffDecoderCommon::table13_0_emit_[5] = {0x5c, 0xc3, 0xd0, 0x80,
                                                       0x82};
const uint8_t HuffDecoderCommon::table13_0_inner_[5] = {0x02, 0x06, 0x0a, 0x0f,
                                                        0x13};
const uint8_t HuffDecoderCommon::table16_0_emit_[6] = {0x83, 0xa2, 0xb8,
                                                       0xc2, 0xe0, 0xe2};
const uint8_t HuffDecoderCommon::table16_0_inner_[7] = {0x00, 0x02, 0x04, 0x06,
                                                        0x08, 0x0a, 0x01};
const uint8_t HuffDecoderCommon::table15_0_emit_[10] = {
    0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2, 0x99, 0xa1, 0xa7, 0xac};
const uint8_t HuffDecoderCommon::table15_0_inner_[10] = {
    0x03, 0x0b, 0x13, 0x1b, 0x23, 0x2b, 0x34, 0x3c, 0x44, 0x4c};
const uint8_t HuffDecoderCommon::table18_0_emit_[9] = {
    0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6};
const uint8_t HuffDecoderCommon::table18_0_inner_[10] = {
    0x00, 0x02, 0x04, 0x06, 0x08, 0x0a, 0x0c, 0x0e, 0x10, 0x01};
const uint8_t HuffDecoderCommon::table17_0_emit_[23] = {
    0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84, 0x85,
    0x86, 0x88, 0x92, 0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa, 0xad};
const uint8_t HuffDecoderCommon::table17_0_ops_[32] = {
    0x04, 0x04, 0x0c, 0x0c, 0x14, 0x14, 0x1c, 0x1c, 0x24, 0x24, 0x2c,
    0x2c, 0x34, 0x34, 0x3c, 0x3c, 0x44, 0x44, 0x4d, 0x55, 0x5d, 0x65,
    0x6d, 0x75, 0x7d, 0x85, 0x8d, 0x95, 0x9d, 0xa5, 0xad, 0xb5};
const uint8_t HuffDecoderCommon::table20_0_emit_[12] = {
    0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8, 0xe9};
const uint8_t HuffDecoderCommon::table20_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x28,
    0x2c, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table21_0_emit_[41] = {
    0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8,
    0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f, 0x93, 0x95,
    0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8, 0xae, 0xaf,
    0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef};
const uint8_t HuffDecoderCommon::table21_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51,
    0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d,
    0x81, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table22_0_emit_[53] = {
    0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8,
    0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f, 0x93, 0x95,
    0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8, 0xae, 0xaf,
    0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90,
    0x91, 0x94, 0x9f, 0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed};
const uint8_t HuffDecoderCommon::table22_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41, 0x00, 0x45,
    0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55, 0x00, 0x59, 0x00, 0x5d,
    0x00, 0x61, 0x00, 0x65, 0x00, 0x69, 0x00, 0x6d, 0x00, 0x71, 0x00, 0x75,
    0x00, 0x79, 0x00, 0x7d, 0x00, 0x81, 0x00, 0x85, 0x00, 0x89, 0x00, 0x8d,
    0x00, 0x91, 0x00, 0x95, 0x00, 0x99, 0x00, 0x9d, 0x00, 0xa1, 0xa5, 0xa9,
    0xad, 0xb1, 0xb5, 0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0xd1, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table23_0_emit_[57] = {
    0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8, 0xe9,
    0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f, 0x93, 0x95, 0x96, 0x97,
    0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8, 0xae, 0xaf, 0xb4, 0xb6, 0xb7,
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f, 0xab,
    0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb};
const uint8_t HuffDecoderCommon::table23_0_ops_[256] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x39,
    0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x45,
    0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x51,
    0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x59, 0x00, 0x00, 0x00, 0x5d,
    0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x00, 0x69,
    0x00, 0x00, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x71, 0x00, 0x00, 0x00, 0x75,
    0x00, 0x00, 0x00, 0x79, 0x00, 0x00, 0x00, 0x7d, 0x00, 0x00, 0x00, 0x81,
    0x00, 0x00, 0x00, 0x85, 0x00, 0x00, 0x00, 0x89, 0x00, 0x00, 0x00, 0x8d,
    0x00, 0x00, 0x00, 0x91, 0x00, 0x00, 0x00, 0x95, 0x00, 0x00, 0x00, 0x99,
    0x00, 0x00, 0x00, 0x9d, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa5, 0x00, 0xa9,
    0x00, 0xad, 0x00, 0xb1, 0x00, 0xb5, 0x00, 0xb9, 0x00, 0xbd, 0x00, 0xc1,
    0x00, 0xc5, 0x00, 0xc9, 0x00, 0xcd, 0x00, 0xd1, 0xd5, 0xd9, 0xdd, 0xe1,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table24_0_emit_[4] = {0xb2, 0xb5, 0xb9, 0xba};
const uint8_t HuffDecoderCommon::table24_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d};
const uint8_t HuffDecoderCommon::table24_1_emit_[4] = {0xbb, 0xbd, 0xbe, 0xc4};
const uint8_t HuffDecoderCommon::table24_2_emit_[4] = {0xc6, 0xe4, 0xe8, 0xe9};
const uint8_t HuffDecoderCommon::table24_3_emit_[8] = {0x01, 0x87, 0x89, 0x8a,
                                                       0x8b, 0x8c, 0x8d, 0x8f};
const uint8_t HuffDecoderCommon::table24_3_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d};
const uint8_t HuffDecoderCommon::table24_4_emit_[8] = {0x93, 0x95, 0x96, 0x97,
                                                       0x98, 0x9b, 0x9d, 0x9e};
const uint8_t HuffDecoderCommon::table24_5_emit_[8] = {0xa5, 0xa6, 0xa8, 0xae,
                                                       0xaf, 0xb4, 0xb6, 0xb7};
const uint8_t HuffDecoderCommon::table24_6_emit_[11] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f};
const uint8_t HuffDecoderCommon::table24_6_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00,
    0x21, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29};
const uint8_t HuffDecoderCommon::table24_7_emit_[25] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea,
    0xeb, 0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5,
    0xda, 0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff};
const uint8_t HuffDecoderCommon::table24_7_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x29,
    0x2d, 0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55,
    0x59, 0x5d, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table24_emit_[8] = {
    table24_0_emit_, table24_1_emit_, table24_2_emit_, table24_3_emit_,
    table24_4_emit_, table24_5_emit_, table24_6_emit_, table24_7_emit_,
};
const uint8_t* const HuffDecoderCommon::table24_ops_[8] = {
    table24_0_ops_, table24_0_ops_, table24_0_ops_, table24_3_ops_,
    table24_3_ops_, table24_3_ops_, table24_6_ops_, table24_7_ops_,
};
const uint8_t HuffDecoderCommon::table25_0_emit_[40] = {
    0xb2, 0x30, 0xb2, 0x31, 0xb2, 0x32, 0xb2, 0x61, 0xb2, 0x63,
    0xb2, 0x65, 0xb2, 0x69, 0xb2, 0x6f, 0xb2, 0x73, 0xb2, 0x74,
    0xb5, 0x30, 0xb5, 0x31, 0xb5, 0x32, 0xb5, 0x61, 0xb5, 0x63,
    0xb5, 0x65, 0xb5, 0x69, 0xb5, 0x6f, 0xb5, 0x73, 0xb5, 0x74};
const uint8_t HuffDecoderCommon::table25_0_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x50,
    0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x90, 0x98, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52};
const uint8_t HuffDecoderCommon::table25_1_emit_[40] = {
    0xb9, 0x30, 0xb9, 0x31, 0xb9, 0x32, 0xb9, 0x61, 0xb9, 0x63,
    0xb9, 0x65, 0xb9, 0x69, 0xb9, 0x6f, 0xb9, 0x73, 0xb9, 0x74,
    0xba, 0x30, 0xba, 0x31, 0xba, 0x32, 0xba, 0x61, 0xba, 0x63,
    0xba, 0x65, 0xba, 0x69, 0xba, 0x6f, 0xba, 0x73, 0xba, 0x74};
const uint8_t HuffDecoderCommon::table25_2_emit_[40] = {
    0xbb, 0x30, 0xbb, 0x31, 0xbb, 0x32, 0xbb, 0x61, 0xbb, 0x63,
    0xbb, 0x65, 0xbb, 0x69, 0xbb, 0x6f, 0xbb, 0x73, 0xbb, 0x74,
    0xbd, 0x30, 0xbd, 0x31, 0xbd, 0x32, 0xbd, 0x61, 0xbd, 0x63,
    0xbd, 0x65, 0xbd, 0x69, 0xbd, 0x6f, 0xbd, 0x73, 0xbd, 0x74};
const uint8_t HuffDecoderCommon::table25_3_emit_[40] = {
    0xbe, 0x30, 0xbe, 0x31, 0xbe, 0x32, 0xbe, 0x61, 0xbe, 0x63,
    0xbe, 0x65, 0xbe, 0x69, 0xbe, 0x6f, 0xbe, 0x73, 0xbe, 0x74,
    0xc4, 0x30, 0xc4, 0x31, 0xc4, 0x32, 0xc4, 0x61, 0xc4, 0x63,
    0xc4, 0x65, 0xc4, 0x69, 0xc4, 0x6f, 0xc4, 0x73, 0xc4, 0x74};
const uint8_t HuffDecoderCommon::table25_4_emit_[40] = {
    0xc6, 0x30, 0xc6, 0x31, 0xc6, 0x32, 0xc6, 0x61, 0xc6, 0x63,
    0xc6, 0x65, 0xc6, 0x69, 0xc6, 0x6f, 0xc6, 0x73, 0xc6, 0x74,
    0xe4, 0x30, 0xe4, 0x31, 0xe4, 0x32, 0xe4, 0x61, 0xe4, 0x63,
    0xe4, 0x65, 0xe4, 0x69, 0xe4, 0x6f, 0xe4, 0x73, 0xe4, 0x74};
const uint8_t HuffDecoderCommon::table25_5_emit_[40] = {
    0xe8, 0x30, 0xe8, 0x31, 0xe8, 0x32, 0xe8, 0x61, 0xe8, 0x63,
    0xe8, 0x65, 0xe8, 0x69, 0xe8, 0x6f, 0xe8, 0x73, 0xe8, 0x74,
    0xe9, 0x30, 0xe9, 0x31, 0xe9, 0x32, 0xe9, 0x61, 0xe9, 0x63,
    0xe9, 0x65, 0xe9, 0x69, 0xe9, 0x6f, 0xe9, 0x73, 0xe9, 0x74};
const uint8_t HuffDecoderCommon::table25_6_emit_[4] = {0x01, 0x87, 0x89, 0x8a};
const uint8_t HuffDecoderCommon::table25_6_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e};
const uint8_t HuffDecoderCommon::table25_7_emit_[4] = {0x8b, 0x8c, 0x8d, 0x8f};
const uint8_t HuffDecoderCommon::table25_8_emit_[4] = {0x93, 0x95, 0x96, 0x97};
const uint8_t HuffDecoderCommon::table25_9_emit_[4] = {0x98, 0x9b, 0x9d, 0x9e};
const uint8_t HuffDecoderCommon::table25_10_emit_[4] = {0xa5, 0xa6, 0xa8, 0xae};
const uint8_t HuffDecoderCommon::table25_11_emit_[4] = {0xaf, 0xb4, 0xb6, 0xb7};
const uint8_t HuffDecoderCommon::table25_12_emit_[4] = {0xbc, 0xbf, 0xc5, 0xe7};
const uint8_t HuffDecoderCommon::table25_13_emit_[7] = {0xef, 0x09, 0x8e, 0x90,
                                                        0x91, 0x94, 0x9f};
const uint8_t HuffDecoderCommon::table25_13_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0a, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a};
const uint8_t HuffDecoderCommon::table25_14_emit_[10] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb};
const uint8_t HuffDecoderCommon::table25_14_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x16, 0x01, 0x01, 0x01, 0x1a, 0x01, 0x01, 0x01,
    0x1e, 0x01, 0x01, 0x01, 0x22, 0x01, 0x01, 0x01, 0x26};
const uint8_t HuffDecoderCommon::table25_15_emit_[34] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee, 0xf0,
    0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf, 0xf1,
    0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe};
const uint8_t HuffDecoderCommon::table25_15_ops_[64] = {
    0x01, 0x02, 0x01, 0x06, 0x01, 0x0a, 0x01, 0x0e, 0x01, 0x12, 0x01,
    0x16, 0x01, 0x1a, 0x01, 0x1e, 0x01, 0x22, 0x01, 0x26, 0x01, 0x2a,
    0x01, 0x2e, 0x01, 0x32, 0x01, 0x36, 0x01, 0x3a, 0x3e, 0x42, 0x46,
    0x4a, 0x4e, 0x52, 0x56, 0x5a, 0x5e, 0x62, 0x66, 0x6a, 0x6e, 0x72,
    0x76, 0x7a, 0x7e, 0x82, 0x86, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03};
const uint8_t* const HuffDecoderCommon::table25_emit_[16] = {
    table25_0_emit_,  table25_1_emit_,  table25_2_emit_,  table25_3_emit_,
    table25_4_emit_,  table25_5_emit_,  table25_6_emit_,  table25_7_emit_,
    table25_8_emit_,  table25_9_emit_,  table25_10_emit_, table25_11_emit_,
    table25_12_emit_, table25_13_emit_, table25_14_emit_, table25_15_emit_,
};
const uint8_t* const HuffDecoderCommon::table25_ops_[16] = {
    table25_0_ops_, table25_0_ops_,  table25_0_ops_,  table25_0_ops_,
    table25_0_ops_, table25_0_ops_,  table25_6_ops_,  table25_6_ops_,
    table25_6_ops_, table25_6_ops_,  table25_6_ops_,  table25_6_ops_,
    table25_6_ops_, table25_13_ops_, table25_14_ops_, table25_15_ops_,
};
const uint8_t HuffDecoderCommon::table26_0_emit_[144] = {
    0xb2, 0x30, 0xb2, 0x31, 0xb2, 0x32, 0xb2, 0x61, 0xb2, 0x63, 0xb2, 0x65,
    0xb2, 0x69, 0xb2, 0x6f, 0xb2, 0x73, 0xb2, 0x74, 0xb2, 0x20, 0xb2, 0x25,
    0xb2, 0x2d, 0xb2, 0x2e, 0xb2, 0x2f, 0xb2, 0x33, 0xb2, 0x34, 0xb2, 0x35,
    0xb2, 0x36, 0xb2, 0x37, 0xb2, 0x38, 0xb2, 0x39, 0xb2, 0x3d, 0xb2, 0x41,
    0xb2, 0x5f, 0xb2, 0x62, 0xb2, 0x64, 0xb2, 0x66, 0xb2, 0x67, 0xb2, 0x68,
    0xb2, 0x6c, 0xb2, 0x6d, 0xb2, 0x6e, 0xb2, 0x70, 0xb2, 0x72, 0xb2, 0x75,
    0xb5, 0x30, 0xb5, 0x31, 0xb5, 0x32, 0xb5, 0x61, 0xb5, 0x63, 0xb5, 0x65,
    0xb5, 0x69, 0xb5, 0x6f, 0xb5, 0x73, 0xb5, 0x74, 0xb5, 0x20, 0xb5, 0x25,
    0xb5, 0x2d, 0xb5, 0x2e, 0xb5, 0x2f, 0xb5, 0x33, 0xb5, 0x34, 0xb5, 0x35,
    0xb5, 0x36, 0xb5, 0x37, 0xb5, 0x38, 0xb5, 0x39, 0xb5, 0x3d, 0xb5, 0x41,
    0xb5, 0x5f, 0xb5, 0x62, 0xb5, 0x64, 0xb5, 0x66, 0xb5, 0x67, 0xb5, 0x68,
    0xb5, 0x6c, 0xb5, 0x6d, 0xb5, 0x6e, 0xb5, 0x70, 0xb5, 0x72, 0xb5, 0x75};
const uint16_t HuffDecoderCommon::table26_0_ops_[128] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019, 0x0000,
    0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039, 0x0000, 0x0041,
    0x0000, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071, 0x0079, 0x0081,
    0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9,
    0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109, 0x0111,
    0x0119, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0002, 0x0000, 0x0121, 0x0000, 0x0129, 0x0000, 0x0131, 0x0000, 0x0139,
    0x0000, 0x0141, 0x0000, 0x0149, 0x0000, 0x0151, 0x0000, 0x0159, 0x0000,
    0x0161, 0x0000, 0x0169, 0x0171, 0x0179, 0x0181, 0x0189, 0x0191, 0x0199,
    0x01a1, 0x01a9, 0x01b1, 0x01b9, 0x01c1, 0x01c9, 0x01d1, 0x01d9, 0x01e1,
    0x01e9, 0x01f1, 0x01f9, 0x0201, 0x0209, 0x0211, 0x0219, 0x0221, 0x0229,
    0x0231, 0x0239, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0122};
const uint8_t HuffDecoderCommon::table26_1_emit_[144] = {
    0xb9, 0x30, 0xb9, 0x31, 0xb9, 0x32, 0xb9, 0x61, 0xb9, 0x63, 0xb9, 0x65,
    0xb9, 0x69, 0xb9, 0x6f, 0xb9, 0x73, 0xb9, 0x74, 0xb9, 0x20, 0xb9, 0x25,
    0xb9, 0x2d, 0xb9, 0x2e, 0xb9, 0x2f, 0xb9, 0x33, 0xb9, 0x34, 0xb9, 0x35,
    0xb9, 0x36, 0xb9, 0x37, 0xb9, 0x38, 0xb9, 0x39, 0xb9, 0x3d, 0xb9, 0x41,
    0xb9, 0x5f, 0xb9, 0x62, 0xb9, 0x64, 0xb9, 0x66, 0xb9, 0x67, 0xb9, 0x68,
    0xb9, 0x6c, 0xb9, 0x6d, 0xb9, 0x6e, 0xb9, 0x70, 0xb9, 0x72, 0xb9, 0x75,
    0xba, 0x30, 0xba, 0x31, 0xba, 0x32, 0xba, 0x61, 0xba, 0x63, 0xba, 0x65,
    0xba, 0x69, 0xba, 0x6f, 0xba, 0x73, 0xba, 0x74, 0xba, 0x20, 0xba, 0x25,
    0xba, 0x2d, 0xba, 0x2e, 0xba, 0x2f, 0xba, 0x33, 0xba, 0x34, 0xba, 0x35,
    0xba, 0x36, 0xba, 0x37, 0xba, 0x38, 0xba, 0x39, 0xba, 0x3d, 0xba, 0x41,
    0xba, 0x5f, 0xba, 0x62, 0xba, 0x64, 0xba, 0x66, 0xba, 0x67, 0xba, 0x68,
    0xba, 0x6c, 0xba, 0x6d, 0xba, 0x6e, 0xba, 0x70, 0xba, 0x72, 0xba, 0x75};
const uint8_t HuffDecoderCommon::table26_2_emit_[144] = {
    0xbb, 0x30, 0xbb, 0x31, 0xbb, 0x32, 0xbb, 0x61, 0xbb, 0x63, 0xbb, 0x65,
    0xbb, 0x69, 0xbb, 0x6f, 0xbb, 0x73, 0xbb, 0x74, 0xbb, 0x20, 0xbb, 0x25,
    0xbb, 0x2d, 0xbb, 0x2e, 0xbb, 0x2f, 0xbb, 0x33, 0xbb, 0x34, 0xbb, 0x35,
    0xbb, 0x36, 0xbb, 0x37, 0xbb, 0x38, 0xbb, 0x39, 0xbb, 0x3d, 0xbb, 0x41,
    0xbb, 0x5f, 0xbb, 0x62, 0xbb, 0x64, 0xbb, 0x66, 0xbb, 0x67, 0xbb, 0x68,
    0xbb, 0x6c, 0xbb, 0x6d, 0xbb, 0x6e, 0xbb, 0x70, 0xbb, 0x72, 0xbb, 0x75,
    0xbd, 0x30, 0xbd, 0x31, 0xbd, 0x32, 0xbd, 0x61, 0xbd, 0x63, 0xbd, 0x65,
    0xbd, 0x69, 0xbd, 0x6f, 0xbd, 0x73, 0xbd, 0x74, 0xbd, 0x20, 0xbd, 0x25,
    0xbd, 0x2d, 0xbd, 0x2e, 0xbd, 0x2f, 0xbd, 0x33, 0xbd, 0x34, 0xbd, 0x35,
    0xbd, 0x36, 0xbd, 0x37, 0xbd, 0x38, 0xbd, 0x39, 0xbd, 0x3d, 0xbd, 0x41,
    0xbd, 0x5f, 0xbd, 0x62, 0xbd, 0x64, 0xbd, 0x66, 0xbd, 0x67, 0xbd, 0x68,
    0xbd, 0x6c, 0xbd, 0x6d, 0xbd, 0x6e, 0xbd, 0x70, 0xbd, 0x72, 0xbd, 0x75};
const uint8_t HuffDecoderCommon::table26_3_emit_[144] = {
    0xbe, 0x30, 0xbe, 0x31, 0xbe, 0x32, 0xbe, 0x61, 0xbe, 0x63, 0xbe, 0x65,
    0xbe, 0x69, 0xbe, 0x6f, 0xbe, 0x73, 0xbe, 0x74, 0xbe, 0x20, 0xbe, 0x25,
    0xbe, 0x2d, 0xbe, 0x2e, 0xbe, 0x2f, 0xbe, 0x33, 0xbe, 0x34, 0xbe, 0x35,
    0xbe, 0x36, 0xbe, 0x37, 0xbe, 0x38, 0xbe, 0x39, 0xbe, 0x3d, 0xbe, 0x41,
    0xbe, 0x5f, 0xbe, 0x62, 0xbe, 0x64, 0xbe, 0x66, 0xbe, 0x67, 0xbe, 0x68,
    0xbe, 0x6c, 0xbe, 0x6d, 0xbe, 0x6e, 0xbe, 0x70, 0xbe, 0x72, 0xbe, 0x75,
    0xc4, 0x30, 0xc4, 0x31, 0xc4, 0x32, 0xc4, 0x61, 0xc4, 0x63, 0xc4, 0x65,
    0xc4, 0x69, 0xc4, 0x6f, 0xc4, 0x73, 0xc4, 0x74, 0xc4, 0x20, 0xc4, 0x25,
    0xc4, 0x2d, 0xc4, 0x2e, 0xc4, 0x2f, 0xc4, 0x33, 0xc4, 0x34, 0xc4, 0x35,
    0xc4, 0x36, 0xc4, 0x37, 0xc4, 0x38, 0xc4, 0x39, 0xc4, 0x3d, 0xc4, 0x41,
    0xc4, 0x5f, 0xc4, 0x62, 0xc4, 0x64, 0xc4, 0x66, 0xc4, 0x67, 0xc4, 0x68,
    0xc4, 0x6c, 0xc4, 0x6d, 0xc4, 0x6e, 0xc4, 0x70, 0xc4, 0x72, 0xc4, 0x75};
const uint8_t HuffDecoderCommon::table26_4_emit_[144] = {
    0xc6, 0x30, 0xc6, 0x31, 0xc6, 0x32, 0xc6, 0x61, 0xc6, 0x63, 0xc6, 0x65,
    0xc6, 0x69, 0xc6, 0x6f, 0xc6, 0x73, 0xc6, 0x74, 0xc6, 0x20, 0xc6, 0x25,
    0xc6, 0x2d, 0xc6, 0x2e, 0xc6, 0x2f, 0xc6, 0x33, 0xc6, 0x34, 0xc6, 0x35,
    0xc6, 0x36, 0xc6, 0x37, 0xc6, 0x38, 0xc6, 0x39, 0xc6, 0x3d, 0xc6, 0x41,
    0xc6, 0x5f, 0xc6, 0x62, 0xc6, 0x64, 0xc6, 0x66, 0xc6, 0x67, 0xc6, 0x68,
    0xc6, 0x6c, 0xc6, 0x6d, 0xc6, 0x6e, 0xc6, 0x70, 0xc6, 0x72, 0xc6, 0x75,
    0xe4, 0x30, 0xe4, 0x31, 0xe4, 0x32, 0xe4, 0x61, 0xe4, 0x63, 0xe4, 0x65,
    0xe4, 0x69, 0xe4, 0x6f, 0xe4, 0x73, 0xe4, 0x74, 0xe4, 0x20, 0xe4, 0x25,
    0xe4, 0x2d, 0xe4, 0x2e, 0xe4, 0x2f, 0xe4, 0x33, 0xe4, 0x34, 0xe4, 0x35,
    0xe4, 0x36, 0xe4, 0x37, 0xe4, 0x38, 0xe4, 0x39, 0xe4, 0x3d, 0xe4, 0x41,
    0xe4, 0x5f, 0xe4, 0x62, 0xe4, 0x64, 0xe4, 0x66, 0xe4, 0x67, 0xe4, 0x68,
    0xe4, 0x6c, 0xe4, 0x6d, 0xe4, 0x6e, 0xe4, 0x70, 0xe4, 0x72, 0xe4, 0x75};
const uint8_t HuffDecoderCommon::table26_5_emit_[144] = {
    0xe8, 0x30, 0xe8, 0x31, 0xe8, 0x32, 0xe8, 0x61, 0xe8, 0x63, 0xe8, 0x65,
    0xe8, 0x69, 0xe8, 0x6f, 0xe8, 0x73, 0xe8, 0x74, 0xe8, 0x20, 0xe8, 0x25,
    0xe8, 0x2d, 0xe8, 0x2e, 0xe8, 0x2f, 0xe8, 0x33, 0xe8, 0x34, 0xe8, 0x35,
    0xe8, 0x36, 0xe8, 0x37, 0xe8, 0x38, 0xe8, 0x39, 0xe8, 0x3d, 0xe8, 0x41,
    0xe8, 0x5f, 0xe8, 0x62, 0xe8, 0x64, 0xe8, 0x66, 0xe8, 0x67, 0xe8, 0x68,
    0xe8, 0x6c, 0xe8, 0x6d, 0xe8, 0x6e, 0xe8, 0x70, 0xe8, 0x72, 0xe8, 0x75,
    0xe9, 0x30, 0xe9, 0x31, 0xe9, 0x32, 0xe9, 0x61, 0xe9, 0x63, 0xe9, 0x65,
    0xe9, 0x69, 0xe9, 0x6f, 0xe9, 0x73, 0xe9, 0x74, 0xe9, 0x20, 0xe9, 0x25,
    0xe9, 0x2d, 0xe9, 0x2e, 0xe9, 0x2f, 0xe9, 0x33, 0xe9, 0x34, 0xe9, 0x35,
    0xe9, 0x36, 0xe9, 0x37, 0xe9, 0x38, 0xe9, 0x39, 0xe9, 0x3d, 0xe9, 0x41,
    0xe9, 0x5f, 0xe9, 0x62, 0xe9, 0x64, 0xe9, 0x66, 0xe9, 0x67, 0xe9, 0x68,
    0xe9, 0x6c, 0xe9, 0x6d, 0xe9, 0x6e, 0xe9, 0x70, 0xe9, 0x72, 0xe9, 0x75};
const uint8_t HuffDecoderCommon::table26_6_emit_[80] = {
    0x01, 0x30, 0x01, 0x31, 0x01, 0x32, 0x01, 0x61, 0x01, 0x63, 0x01, 0x65,
    0x01, 0x69, 0x01, 0x6f, 0x01, 0x73, 0x01, 0x74, 0x87, 0x30, 0x87, 0x31,
    0x87, 0x32, 0x87, 0x61, 0x87, 0x63, 0x87, 0x65, 0x87, 0x69, 0x87, 0x6f,
    0x87, 0x73, 0x87, 0x74, 0x89, 0x30, 0x89, 0x31, 0x89, 0x32, 0x89, 0x61,
    0x89, 0x63, 0x89, 0x65, 0x89, 0x69, 0x89, 0x6f, 0x89, 0x73, 0x89, 0x74,
    0x8a, 0x30, 0x8a, 0x31, 0x8a, 0x32, 0x8a, 0x61, 0x8a, 0x63, 0x8a, 0x65,
    0x8a, 0x69, 0x8a, 0x6f, 0x8a, 0x73, 0x8a, 0x74};
const uint16_t HuffDecoderCommon::table26_6_ops_[128] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039, 0x0041,
    0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0052, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9,
    0x00e1, 0x00e9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00a2, 0x00f1, 0x00f9, 0x0101,
    0x0109, 0x0111, 0x0119, 0x0121, 0x0129, 0x0131, 0x0139, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x00f2};
const uint8_t HuffDecoderCommon::table26_7_emit_[80] = {
    0x8b, 0x30, 0x8b, 0x31, 0x8b, 0x32, 0x8b, 0x61, 0x8b, 0x63, 0x8b, 0x65,
    0x8b, 0x69, 0x8b, 0x6f, 0x8b, 0x73, 0x8b, 0x74, 0x8c, 0x30, 0x8c, 0x31,
    0x8c, 0x32, 0x8c, 0x61, 0x8c, 0x63, 0x8c, 0x65, 0x8c, 0x69, 0x8c, 0x6f,
    0x8c, 0x73, 0x8c, 0x74, 0x8d, 0x30, 0x8d, 0x31, 0x8d, 0x32, 0x8d, 0x61,
    0x8d, 0x63, 0x8d, 0x65, 0x8d, 0x69, 0x8d, 0x6f, 0x8d, 0x73, 0x8d, 0x74,
    0x8f, 0x30, 0x8f, 0x31, 0x8f, 0x32, 0x8f, 0x61, 0x8f, 0x63, 0x8f, 0x65,
    0x8f, 0x69, 0x8f, 0x6f, 0x8f, 0x73, 0x8f, 0x74};
const uint8_t HuffDecoderCommon::table26_8_emit_[80] = {
    0x93, 0x30, 0x93, 0x31, 0x93, 0x32, 0x93, 0x61, 0x93, 0x63, 0x93, 0x65,
    0x93, 0x69, 0x93, 0x6f, 0x93, 0x73, 0x93, 0x74, 0x95, 0x30, 0x95, 0x31,
    0x95, 0x32, 0x95, 0x61, 0x95, 0x63, 0x95, 0x65, 0x95, 0x69, 0x95, 0x6f,
    0x95, 0x73, 0x95, 0x74, 0x96, 0x30, 0x96, 0x31, 0x96, 0x32, 0x96, 0x61,
    0x96, 0x63, 0x96, 0x65, 0x96, 0x69, 0x96, 0x6f, 0x96, 0x73, 0x96, 0x74,
    0x97, 0x30, 0x97, 0x31, 0x97, 0x32, 0x97, 0x61, 0x97, 0x63, 0x97, 0x65,
    0x97, 0x69, 0x97, 0x6f, 0x97, 0x73, 0x97, 0x74};
const uint8_t HuffDecoderCommon::table26_9_emit_[80] = {
    0x98, 0x30, 0x98, 0x31, 0x98, 0x32, 0x98, 0x61, 0x98, 0x63, 0x98, 0x65,
    0x98, 0x69, 0x98, 0x6f, 0x98, 0x73, 0x98, 0x74, 0x9b, 0x30, 0x9b, 0x31,
    0x9b, 0x32, 0x9b, 0x61, 0x9b, 0x63, 0x9b, 0x65, 0x9b, 0x69, 0x9b, 0x6f,
    0x9b, 0x73, 0x9b, 0x74, 0x9d, 0x30, 0x9d, 0x31, 0x9d, 0x32, 0x9d, 0x61,
    0x9d, 0x63, 0x9d, 0x65, 0x9d, 0x69, 0x9d, 0x6f, 0x9d, 0x73, 0x9d, 0x74,
    0x9e, 0x30, 0x9e, 0x31, 0x9e, 0x32, 0x9e, 0x61, 0x9e, 0x63, 0x9e, 0x65,
    0x9e, 0x69, 0x9e, 0x6f, 0x9e, 0x73, 0x9e, 0x74};
const uint8_t HuffDecoderCommon::table26_10_emit_[80] = {
    0xa5, 0x30, 0xa5, 0x31, 0xa5, 0x32, 0xa5, 0x61, 0xa5, 0x63, 0xa5, 0x65,
    0xa5, 0x69, 0xa5, 0x6f, 0xa5, 0x73, 0xa5, 0x74, 0xa6, 0x30, 0xa6, 0x31,
    0xa6, 0x32, 0xa6, 0x61, 0xa6, 0x63, 0xa6, 0x65, 0xa6, 0x69, 0xa6, 0x6f,
    0xa6, 0x73, 0xa6, 0x74, 0xa8, 0x30, 0xa8, 0x31, 0xa8, 0x32, 0xa8, 0x61,
    0xa8, 0x63, 0xa8, 0x65, 0xa8, 0x69, 0xa8, 0x6f, 0xa8, 0x73, 0xa8, 0x74,
    0xae, 0x30, 0xae, 0x31, 0xae, 0x32, 0xae, 0x61, 0xae, 0x63, 0xae, 0x65,
    0xae, 0x69, 0xae, 0x6f, 0xae, 0x73, 0xae, 0x74};
const uint8_t HuffDecoderCommon::table26_11_emit_[80] = {
    0xaf, 0x30, 0xaf, 0x31, 0xaf, 0x32, 0xaf, 0x61, 0xaf, 0x63, 0xaf, 0x65,
    0xaf, 0x69, 0xaf, 0x6f, 0xaf, 0x73, 0xaf, 0x74, 0xb4, 0x30, 0xb4, 0x31,
    0xb4, 0x32, 0xb4, 0x61, 0xb4, 0x63, 0xb4, 0x65, 0xb4, 0x69, 0xb4, 0x6f,
    0xb4, 0x73, 0xb4, 0x74, 0xb6, 0x30, 0xb6, 0x31, 0xb6, 0x32, 0xb6, 0x61,
    0xb6, 0x63, 0xb6, 0x65, 0xb6, 0x69, 0xb6, 0x6f, 0xb6, 0x73, 0xb6, 0x74,
    0xb7, 0x30, 0xb7, 0x31, 0xb7, 0x32, 0xb7, 0x61, 0xb7, 0x63, 0xb7, 0x65,
    0xb7, 0x69, 0xb7, 0x6f, 0xb7, 0x73, 0xb7, 0x74};
const uint8_t HuffDecoderCommon::table26_12_emit_[80] = {
    0xbc, 0x30, 0xbc, 0x31, 0xbc, 0x32, 0xbc, 0x61, 0xbc, 0x63, 0xbc, 0x65,
    0xbc, 0x69, 0xbc, 0x6f, 0xbc, 0x73, 0xbc, 0x74, 0xbf, 0x30, 0xbf, 0x31,
    0xbf, 0x32, 0xbf, 0x61, 0xbf, 0x63, 0xbf, 0x65, 0xbf, 0x69, 0xbf, 0x6f,
    0xbf, 0x73, 0xbf, 0x74, 0xc5, 0x30, 0xc5, 0x31, 0xc5, 0x32, 0xc5, 0x61,
    0xc5, 0x63, 0xc5, 0x65, 0xc5, 0x69, 0xc5, 0x6f, 0xc5, 0x73, 0xc5, 0x74,
    0xe7, 0x30, 0xe7, 0x31, 0xe7, 0x32, 0xe7, 0x61, 0xe7, 0x63, 0xe7, 0x65,
    0xe7, 0x69, 0xe7, 0x6f, 0xe7, 0x73, 0xe7, 0x74};
const uint8_t HuffDecoderCommon::table26_13_emit_[26] = {
    0xef, 0x30, 0xef, 0x31, 0xef, 0x32, 0xef, 0x61, 0xef,
    0x63, 0xef, 0x65, 0xef, 0x69, 0xef, 0x6f, 0xef, 0x73,
    0xef, 0x74, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f};
const uint16_t HuffDecoderCommon::table26_13_ops_[128] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039, 0x0041,
    0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x005a, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x005e, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0066};
const uint16_t HuffDecoderCommon::table26_14_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x000e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0016, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x001a, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0026};
const uint8_t HuffDecoderCommon::table26_15_emit_[63] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee,
    0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde,
    0xdf, 0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd,
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0b, 0x0c, 0x0e,
    0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18, 0x19, 0x1a,
    0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint16_t HuffDecoderCommon::table26_15_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0006, 0x0000,
    0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x000e, 0x0000, 0x0000,
    0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0016, 0x0000, 0x0000, 0x0000,
    0x001a, 0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0026, 0x0000, 0x0000, 0x0000, 0x002a, 0x0000,
    0x0000, 0x0000, 0x002e, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000,
    0x0000, 0x0036, 0x0000, 0x0000, 0x0000, 0x003a, 0x0000, 0x003e, 0x0000,
    0x0042, 0x0000, 0x0046, 0x0000, 0x004a, 0x0000, 0x004e, 0x0000, 0x0052,
    0x0000, 0x0056, 0x0000, 0x005a, 0x0000, 0x005e, 0x0000, 0x0062, 0x0000,
    0x0066, 0x0000, 0x006a, 0x0000, 0x006e, 0x0000, 0x0072, 0x0000, 0x0076,
    0x0000, 0x007a, 0x0000, 0x007e, 0x0000, 0x0082, 0x0000, 0x0086, 0x008a,
    0x008e, 0x0092, 0x0096, 0x009a, 0x009e, 0x00a2, 0x00a6, 0x00aa, 0x00ae,
    0x00b2, 0x00b6, 0x00ba, 0x00be, 0x00c2, 0x00c6, 0x00ca, 0x00ce, 0x00d2,
    0x00d6, 0x00da, 0x00de, 0x00e2, 0x00e6, 0x00ea, 0x00ee, 0x00f2, 0x00f6,
    0x00fa, 0x0003};
const uint8_t* const HuffDecoderCommon::table26_emit_[16] = {
    table26_0_emit_,  table26_1_emit_,  table26_2_emit_,  table26_3_emit_,
    table26_4_emit_,  table26_5_emit_,  table26_6_emit_,  table26_7_emit_,
    table26_8_emit_,  table26_9_emit_,  table26_10_emit_, table26_11_emit_,
    table26_12_emit_, table26_13_emit_, table25_14_emit_, table26_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table26_ops_[16] = {
    table26_0_ops_, table26_0_ops_,  table26_0_ops_,  table26_0_ops_,
    table26_0_ops_, table26_0_ops_,  table26_6_ops_,  table26_6_ops_,
    table26_6_ops_, table26_6_ops_,  table26_6_ops_,  table26_6_ops_,
    table26_6_ops_, table26_13_ops_, table26_14_ops_, table26_15_ops_,
};
const uint8_t HuffDecoderCommon::table27_0_emit_[136] = {
    0xb2, 0x30, 0xb2, 0x31, 0xb2, 0x32, 0xb2, 0x61, 0xb2, 0x63, 0xb2, 0x65,
    0xb2, 0x69, 0xb2, 0x6f, 0xb2, 0x73, 0xb2, 0x74, 0xb2, 0x20, 0xb2, 0x25,
    0xb2, 0x2d, 0xb2, 0x2e, 0xb2, 0x2f, 0xb2, 0x33, 0xb2, 0x34, 0xb2, 0x35,
    0xb2, 0x36, 0xb2, 0x37, 0xb2, 0x38, 0xb2, 0x39, 0xb2, 0x3d, 0xb2, 0x41,
    0xb2, 0x5f, 0xb2, 0x62, 0xb2, 0x64, 0xb2, 0x66, 0xb2, 0x67, 0xb2, 0x68,
    0xb2, 0x6c, 0xb2, 0x6d, 0xb2, 0x6e, 0xb2, 0x70, 0xb2, 0x72, 0xb2, 0x75,
    0xb2, 0x3a, 0xb2, 0x42, 0xb2, 0x43, 0xb2, 0x44, 0xb2, 0x45, 0xb2, 0x46,
    0xb2, 0x47, 0xb2, 0x48, 0xb2, 0x49, 0xb2, 0x4a, 0xb2, 0x4b, 0xb2, 0x4c,
    0xb2, 0x4d, 0xb2, 0x4e, 0xb2, 0x4f, 0xb2, 0x50, 0xb2, 0x51, 0xb2, 0x52,
    0xb2, 0x53, 0xb2, 0x54, 0xb2, 0x55, 0xb2, 0x56, 0xb2, 0x57, 0xb2, 0x59,
    0xb2, 0x6a, 0xb2, 0x6b, 0xb2, 0x71, 0xb2, 0x76, 0xb2, 0x77, 0xb2, 0x78,
    0xb2, 0x79, 0xb2, 0x7a};
const uint16_t HuffDecoderCommon::table27_0_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000,
    0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000,
    0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000,
    0x0031, 0x0000, 0x0000, 0x0000, 0x0039, 0x0000, 0x0000, 0x0000, 0x0041,
    0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059, 0x0000,
    0x0061, 0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081,
    0x0000, 0x0089, 0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000,
    0x00a9, 0x0000, 0x00b1, 0x0000, 0x00b9, 0x0000, 0x00c1, 0x0000, 0x00c9,
    0x0000, 0x00d1, 0x0000, 0x00d9, 0x0000, 0x00e1, 0x0000, 0x00e9, 0x0000,
    0x00f1, 0x0000, 0x00f9, 0x0000, 0x0101, 0x0000, 0x0109, 0x0000, 0x0111,
    0x0000, 0x0119, 0x0121, 0x0129, 0x0131, 0x0139, 0x0141, 0x0149, 0x0151,
    0x0159, 0x0161, 0x0169, 0x0171, 0x0179, 0x0181, 0x0189, 0x0191, 0x0199,
    0x01a1, 0x01a9, 0x01b1, 0x01b9, 0x01c1, 0x01c9, 0x01d1, 0x01d9, 0x01e1,
    0x01e9, 0x01f1, 0x01f9, 0x0201, 0x0209, 0x0211, 0x0219, 0x0000, 0x0000,
    0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table27_1_emit_[136] = {
    0xb5, 0x30, 0xb5, 0x31, 0xb5, 0x32, 0xb5, 0x61, 0xb5, 0x63, 0xb5, 0x65,
    0xb5, 0x69, 0xb5, 0x6f, 0xb5, 0x73, 0xb5, 0x74, 0xb5, 0x20, 0xb5, 0x25,
    0xb5, 0x2d, 0xb5, 0x2e, 0xb5, 0x2f, 0xb5, 0x33, 0xb5, 0x34, 0xb5, 0x35,
    0xb5, 0x36, 0xb5, 0x37, 0xb5, 0x38, 0xb5, 0x39, 0xb5, 0x3d, 0xb5, 0x41,
    0xb5, 0x5f, 0xb5, 0x62, 0xb5, 0x64, 0xb5, 0x66, 0xb5, 0x67, 0xb5, 0x68,
    0xb5, 0x6c, 0xb5, 0x6d, 0xb5, 0x6e, 0xb5, 0x70, 0xb5, 0x72, 0xb5, 0x75,
    0xb5, 0x3a, 0xb5, 0x42, 0xb5, 0x43, 0xb5, 0x44, 0xb5, 0x45, 0xb5, 0x46,
    0xb5, 0x47, 0xb5, 0x48, 0xb5, 0x49, 0xb5, 0x4a, 0xb5, 0x4b, 0xb5, 0x4c,
    0xb5, 0x4d, 0xb5, 0x4e, 0xb5, 0x4f, 0xb5, 0x50, 0xb5, 0x51, 0xb5, 0x52,
    0xb5, 0x53, 0xb5, 0x54, 0xb5, 0x55, 0xb5, 0x56, 0xb5, 0x57, 0xb5, 0x59,
    0xb5, 0x6a, 0xb5, 0x6b, 0xb5, 0x71, 0xb5, 0x76, 0xb5, 0x77, 0xb5, 0x78,
    0xb5, 0x79, 0xb5, 0x7a};
const uint8_t HuffDecoderCommon::table27_2_emit_[136] = {
    0xb9, 0x30, 0xb9, 0x31, 0xb9, 0x32, 0xb9, 0x61, 0xb9, 0x63, 0xb9, 0x65,
    0xb9, 0x69, 0xb9, 0x6f, 0xb9, 0x73, 0xb9, 0x74, 0xb9, 0x20, 0xb9, 0x25,
    0xb9, 0x2d, 0xb9, 0x2e, 0xb9, 0x2f, 0xb9, 0x33, 0xb9, 0x34, 0xb9, 0x35,
    0xb9, 0x36, 0xb9, 0x37, 0xb9, 0x38, 0xb9, 0x39, 0xb9, 0x3d, 0xb9, 0x41,
    0xb9, 0x5f, 0xb9, 0x62, 0xb9, 0x64, 0xb9, 0x66, 0xb9, 0x67, 0xb9, 0x68,
    0xb9, 0x6c, 0xb9, 0x6d, 0xb9, 0x6e, 0xb9, 0x70, 0xb9, 0x72, 0xb9, 0x75,
    0xb9, 0x3a, 0xb9, 0x42, 0xb9, 0x43, 0xb9, 0x44, 0xb9, 0x45, 0xb9, 0x46,
    0xb9, 0x47, 0xb9, 0x48, 0xb9, 0x49, 0xb9, 0x4a, 0xb9, 0x4b, 0xb9, 0x4c,
    0xb9, 0x4d, 0xb9, 0x4e, 0xb9, 0x4f, 0xb9, 0x50, 0xb9, 0x51, 0xb9, 0x52,
    0xb9, 0x53, 0xb9, 0x54, 0xb9, 0x55, 0xb9, 0x56, 0xb9, 0x57, 0xb9, 0x59,
    0xb9, 0x6a, 0xb9, 0x6b, 0xb9, 0x71, 0xb9, 0x76, 0xb9, 0x77, 0xb9, 0x78,
    0xb9, 0x79, 0xb9, 0x7a};
const uint8_t HuffDecoderCommon::table27_3_emit_[136] = {
    0xba, 0x30, 0xba, 0x31, 0xba, 0x32, 0xba, 0x61, 0xba, 0x63, 0xba, 0x65,
    0xba, 0x69, 0xba, 0x6f, 0xba, 0x73, 0xba, 0x74, 0xba, 0x20, 0xba, 0x25,
    0xba, 0x2d, 0xba, 0x2e, 0xba, 0x2f, 0xba, 0x33, 0xba, 0x34, 0xba, 0x35,
    0xba, 0x36, 0xba, 0x37, 0xba, 0x38, 0xba, 0x39, 0xba, 0x3d, 0xba, 0x41,
    0xba, 0x5f, 0xba, 0x62, 0xba, 0x64, 0xba, 0x66, 0xba, 0x67, 0xba, 0x68,
    0xba, 0x6c, 0xba, 0x6d, 0xba, 0x6e, 0xba, 0x70, 0xba, 0x72, 0xba, 0x75,
    0xba, 0x3a, 0xba, 0x42, 0xba, 0x43, 0xba, 0x44, 0xba, 0x45, 0xba, 0x46,
    0xba, 0x47, 0xba, 0x48, 0xba, 0x49, 0xba, 0x4a, 0xba, 0x4b, 0xba, 0x4c,
    0xba, 0x4d, 0xba, 0x4e, 0xba, 0x4f, 0xba, 0x50, 0xba, 0x51, 0xba, 0x52,
    0xba, 0x53, 0xba, 0x54, 0xba, 0x55, 0xba, 0x56, 0xba, 0x57, 0xba, 0x59,
    0xba, 0x6a, 0xba, 0x6b, 0xba, 0x71, 0xba, 0x76, 0xba, 0x77, 0xba, 0x78,
    0xba, 0x79, 0xba, 0x7a};
const uint8_t HuffDecoderCommon::table27_4_emit_[136] = {
    0xbb, 0x30, 0xbb, 0x31, 0xbb, 0x32, 0xbb, 0x61, 0xbb, 0x63, 0xbb, 0x65,
    0xbb, 0x69, 0xbb, 0x6f, 0xbb, 0x73, 0xbb, 0x74, 0xbb, 0x20, 0xbb, 0x25,
    0xbb, 0x2d, 0xbb, 0x2e, 0xbb, 0x2f, 0xbb, 0x33, 0xbb, 0x34, 0xbb, 0x35,
    0xbb, 0x36, 0xbb, 0x37, 0xbb, 0x38, 0xbb, 0x39, 0xbb, 0x3d, 0xbb, 0x41,
    0xbb, 0x5f, 0xbb, 0x62, 0xbb, 0x64, 0xbb, 0x66, 0xbb, 0x67, 0xbb, 0x68,
    0xbb, 0x6c, 0xbb, 0x6d, 0xbb, 0x6e, 0xbb, 0x70, 0xbb, 0x72, 0xbb, 0x75,
    0xbb, 0x3a, 0xbb, 0x42, 0xbb, 0x43, 0xbb, 0x44, 0xbb, 0x45, 0xbb, 0x46,
    0xbb, 0x47, 0xbb, 0x48, 0xbb, 0x49, 0xbb, 0x4a, 0xbb, 0x4b, 0xbb, 0x4c,
    0xbb, 0x4d, 0xbb, 0x4e, 0xbb, 0x4f, 0xbb, 0x50, 0xbb, 0x51, 0xbb, 0x52,
    0xbb, 0x53, 0xbb, 0x54, 0xbb, 0x55, 0xbb, 0x56, 0xbb, 0x57, 0xbb, 0x59,
    0xbb, 0x6a, 0xbb, 0x6b, 0xbb, 0x71, 0xbb, 0x76, 0xbb, 0x77, 0xbb, 0x78,
    0xbb, 0x79, 0xbb, 0x7a};
const uint8_t HuffDecoderCommon::table27_5_emit_[136] = {
    0xbd, 0x30, 0xbd, 0x31, 0xbd, 0x32, 0xbd, 0x61, 0xbd, 0x63, 0xbd, 0x65,
    0xbd, 0x69, 0xbd, 0x6f, 0xbd, 0x73, 0xbd, 0x74, 0xbd, 0x20, 0xbd, 0x25,
    0xbd, 0x2d, 0xbd, 0x2e, 0xbd, 0x2f, 0xbd, 0x33, 0xbd, 0x34, 0xbd, 0x35,
    0xbd, 0x36, 0xbd, 0x37, 0xbd, 0x38, 0xbd, 0x39, 0xbd, 0x3d, 0xbd, 0x41,
    0xbd, 0x5f, 0xbd, 0x62, 0xbd, 0x64, 0xbd, 0x66, 0xbd, 0x67, 0xbd, 0x68,
    0xbd, 0x6c, 0xbd, 0x6d, 0xbd, 0x6e, 0xbd, 0x70, 0xbd, 0x72, 0xbd, 0x75,
    0xbd, 0x3a, 0xbd, 0x42, 0xbd, 0x43, 0xbd, 0x44, 0xbd, 0x45, 0xbd, 0x46,
    0xbd, 0x47, 0xbd, 0x48, 0xbd, 0x49, 0xbd, 0x4a, 0xbd, 0x4b, 0xbd, 0x4c,
    0xbd, 0x4d, 0xbd, 0x4e, 0xbd, 0x4f, 0xbd, 0x50, 0xbd, 0x51, 0xbd, 0x52,
    0xbd, 0x53, 0xbd, 0x54, 0xbd, 0x55, 0xbd, 0x56, 0xbd, 0x57, 0xbd, 0x59,
    0xbd, 0x6a, 0xbd, 0x6b, 0xbd, 0x71, 0xbd, 0x76, 0xbd, 0x77, 0xbd, 0x78,
    0xbd, 0x79, 0xbd, 0x7a};
const uint8_t HuffDecoderCommon::table27_6_emit_[136] = {
    0xbe, 0x30, 0xbe, 0x31, 0xbe, 0x32, 0xbe, 0x61, 0xbe, 0x63, 0xbe, 0x65,
    0xbe, 0x69, 0xbe, 0x6f, 0xbe, 0x73, 0xbe, 0x74, 0xbe, 0x20, 0xbe, 0x25,
    0xbe, 0x2d, 0xbe, 0x2e, 0xbe, 0x2f, 0xbe, 0x33, 0xbe, 0x34, 0xbe, 0x35,
    0xbe, 0x36, 0xbe, 0x37, 0xbe, 0x38, 0xbe, 0x39, 0xbe, 0x3d, 0xbe, 0x41,
    0xbe, 0x5f, 0xbe, 0x62, 0xbe, 0x64, 0xbe, 0x66, 0xbe, 0x67, 0xbe, 0x68,
    0xbe, 0x6c, 0xbe, 0x6d, 0xbe, 0x6e, 0xbe, 0x70, 0xbe, 0x72, 0xbe, 0x75,
    0xbe, 0x3a, 0xbe, 0x42, 0xbe, 0x43, 0xbe, 0x44, 0xbe, 0x45, 0xbe, 0x46,
    0xbe, 0x47, 0xbe, 0x48, 0xbe, 0x49, 0xbe, 0x4a, 0xbe, 0x4b, 0xbe, 0x4c,
    0xbe, 0x4d, 0xbe, 0x4e, 0xbe, 0x4f, 0xbe, 0x50, 0xbe, 0x51, 0xbe, 0x52,
    0xbe, 0x53, 0xbe, 0x54, 0xbe, 0x55, 0xbe, 0x56, 0xbe, 0x57, 0xbe, 0x59,
    0xbe, 0x6a, 0xbe, 0x6b, 0xbe, 0x71, 0xbe, 0x76, 0xbe, 0x77, 0xbe, 0x78,
    0xbe, 0x79, 0xbe, 0x7a};
const uint8_t HuffDecoderCommon::table27_7_emit_[136] = {
    0xc4, 0x30, 0xc4, 0x31, 0xc4, 0x32, 0xc4, 0x61, 0xc4, 0x63, 0xc4, 0x65,
    0xc4, 0x69, 0xc4, 0x6f, 0xc4, 0x73, 0xc4, 0x74, 0xc4, 0x20, 0xc4, 0x25,
    0xc4, 0x2d, 0xc4, 0x2e, 0xc4, 0x2f, 0xc4, 0x33, 0xc4, 0x34, 0xc4, 0x35,
    0xc4, 0x36, 0xc4, 0x37, 0xc4, 0x38, 0xc4, 0x39, 0xc4, 0x3d, 0xc4, 0x41,
    0xc4, 0x5f, 0xc4, 0x62, 0xc4, 0x64, 0xc4, 0x66, 0xc4, 0x67, 0xc4, 0x68,
    0xc4, 0x6c, 0xc4, 0x6d, 0xc4, 0x6e, 0xc4, 0x70, 0xc4, 0x72, 0xc4, 0x75,
    0xc4, 0x3a, 0xc4, 0x42, 0xc4, 0x43, 0xc4, 0x44, 0xc4, 0x45, 0xc4, 0x46,
    0xc4, 0x47, 0xc4, 0x48, 0xc4, 0x49, 0xc4, 0x4a, 0xc4, 0x4b, 0xc4, 0x4c,
    0xc4, 0x4d, 0xc4, 0x4e, 0xc4, 0x4f, 0xc4, 0x50, 0xc4, 0x51, 0xc4, 0x52,
    0xc4, 0x53, 0xc4, 0x54, 0xc4, 0x55, 0xc4, 0x56, 0xc4, 0x57, 0xc4, 0x59,
    0xc4, 0x6a, 0xc4, 0x6b, 0xc4, 0x71, 0xc4, 0x76, 0xc4, 0x77, 0xc4, 0x78,
    0xc4, 0x79, 0xc4, 0x7a};
const uint8_t HuffDecoderCommon::table27_8_emit_[136] = {
    0xc6, 0x30, 0xc6, 0x31, 0xc6, 0x32, 0xc6, 0x61, 0xc6, 0x63, 0xc6, 0x65,
    0xc6, 0x69, 0xc6, 0x6f, 0xc6, 0x73, 0xc6, 0x74, 0xc6, 0x20, 0xc6, 0x25,
    0xc6, 0x2d, 0xc6, 0x2e, 0xc6, 0x2f, 0xc6, 0x33, 0xc6, 0x34, 0xc6, 0x35,
    0xc6, 0x36, 0xc6, 0x37, 0xc6, 0x38, 0xc6, 0x39, 0xc6, 0x3d, 0xc6, 0x41,
    0xc6, 0x5f, 0xc6, 0x62, 0xc6, 0x64, 0xc6, 0x66, 0xc6, 0x67, 0xc6, 0x68,
    0xc6, 0x6c, 0xc6, 0x6d, 0xc6, 0x6e, 0xc6, 0x70, 0xc6, 0x72, 0xc6, 0x75,
    0xc6, 0x3a, 0xc6, 0x42, 0xc6, 0x43, 0xc6, 0x44, 0xc6, 0x45, 0xc6, 0x46,
    0xc6, 0x47, 0xc6, 0x48, 0xc6, 0x49, 0xc6, 0x4a, 0xc6, 0x4b, 0xc6, 0x4c,
    0xc6, 0x4d, 0xc6, 0x4e, 0xc6, 0x4f, 0xc6, 0x50, 0xc6, 0x51, 0xc6, 0x52,
    0xc6, 0x53, 0xc6, 0x54, 0xc6, 0x55, 0xc6, 0x56, 0xc6, 0x57, 0xc6, 0x59,
    0xc6, 0x6a, 0xc6, 0x6b, 0xc6, 0x71, 0xc6, 0x76, 0xc6, 0x77, 0xc6, 0x78,
    0xc6, 0x79, 0xc6, 0x7a};
const uint8_t HuffDecoderCommon::table27_9_emit_[136] = {
    0xe4, 0x30, 0xe4, 0x31, 0xe4, 0x32, 0xe4, 0x61, 0xe4, 0x63, 0xe4, 0x65,
    0xe4, 0x69, 0xe4, 0x6f, 0xe4, 0x73, 0xe4, 0x74, 0xe4, 0x20, 0xe4, 0x25,
    0xe4, 0x2d, 0xe4, 0x2e, 0xe4, 0x2f, 0xe4, 0x33, 0xe4, 0x34, 0xe4, 0x35,
    0xe4, 0x36, 0xe4, 0x37, 0xe4, 0x38, 0xe4, 0x39, 0xe4, 0x3d, 0xe4, 0x41,
    0xe4, 0x5f, 0xe4, 0x62, 0xe4, 0x64, 0xe4, 0x66, 0xe4, 0x67, 0xe4, 0x68,
    0xe4, 0x6c, 0xe4, 0x6d, 0xe4, 0x6e, 0xe4, 0x70, 0xe4, 0x72, 0xe4, 0x75,
    0xe4, 0x3a, 0xe4, 0x42, 0xe4, 0x43, 0xe4, 0x44, 0xe4, 0x45, 0xe4, 0x46,
    0xe4, 0x47, 0xe4, 0x48, 0xe4, 0x49, 0xe4, 0x4a, 0xe4, 0x4b, 0xe4, 0x4c,
    0xe4, 0x4d, 0xe4, 0x4e, 0xe4, 0x4f, 0xe4, 0x50, 0xe4, 0x51, 0xe4, 0x52,
    0xe4, 0x53, 0xe4, 0x54, 0xe4, 0x55, 0xe4, 0x56, 0xe4, 0x57, 0xe4, 0x59,
    0xe4, 0x6a, 0xe4, 0x6b, 0xe4, 0x71, 0xe4, 0x76, 0xe4, 0x77, 0xe4, 0x78,
    0xe4, 0x79, 0xe4, 0x7a};
const uint8_t HuffDecoderCommon::table27_10_emit_[136] = {
    0xe8, 0x30, 0xe8, 0x31, 0xe8, 0x32, 0xe8, 0x61, 0xe8, 0x63, 0xe8, 0x65,
    0xe8, 0x69, 0xe8, 0x6f, 0xe8, 0x73, 0xe8, 0x74, 0xe8, 0x20, 0xe8, 0x25,
    0xe8, 0x2d, 0xe8, 0x2e, 0xe8, 0x2f, 0xe8, 0x33, 0xe8, 0x34, 0xe8, 0x35,
    0xe8, 0x36, 0xe8, 0x37, 0xe8, 0x38, 0xe8, 0x39, 0xe8, 0x3d, 0xe8, 0x41,
    0xe8, 0x5f, 0xe8, 0x62, 0xe8, 0x64, 0xe8, 0x66, 0xe8, 0x67, 0xe8, 0x68,
    0xe8, 0x6c, 0xe8, 0x6d, 0xe8, 0x6e, 0xe8, 0x70, 0xe8, 0x72, 0xe8, 0x75,
    0xe8, 0x3a, 0xe8, 0x42, 0xe8, 0x43, 0xe8, 0x44, 0xe8, 0x45, 0xe8, 0x46,
    0xe8, 0x47, 0xe8, 0x48, 0xe8, 0x49, 0xe8, 0x4a, 0xe8, 0x4b, 0xe8, 0x4c,
    0xe8, 0x4d, 0xe8, 0x4e, 0xe8, 0x4f, 0xe8, 0x50, 0xe8, 0x51, 0xe8, 0x52,
    0xe8, 0x53, 0xe8, 0x54, 0xe8, 0x55, 0xe8, 0x56, 0xe8, 0x57, 0xe8, 0x59,
    0xe8, 0x6a, 0xe8, 0x6b, 0xe8, 0x71, 0xe8, 0x76, 0xe8, 0x77, 0xe8, 0x78,
    0xe8, 0x79, 0xe8, 0x7a};
const uint8_t HuffDecoderCommon::table27_11_emit_[136] = {
    0xe9, 0x30, 0xe9, 0x31, 0xe9, 0x32, 0xe9, 0x61, 0xe9, 0x63, 0xe9, 0x65,
    0xe9, 0x69, 0xe9, 0x6f, 0xe9, 0x73, 0xe9, 0x74, 0xe9, 0x20, 0xe9, 0x25,
    0xe9, 0x2d, 0xe9, 0x2e, 0xe9, 0x2f, 0xe9, 0x33, 0xe9, 0x34, 0xe9, 0x35,
    0xe9, 0x36, 0xe9, 0x37, 0xe9, 0x38, 0xe9, 0x39, 0xe9, 0x3d, 0xe9, 0x41,
    0xe9, 0x5f, 0xe9, 0x62, 0xe9, 0x64, 0xe9, 0x66, 0xe9, 0x67, 0xe9, 0x68,
    0xe9, 0x6c, 0xe9, 0x6d, 0xe9, 0x6e, 0xe9, 0x70, 0xe9, 0x72, 0xe9, 0x75,
    0xe9, 0x3a, 0xe9, 0x42, 0xe9, 0x43, 0xe9, 0x44, 0xe9, 0x45, 0xe9, 0x46,
    0xe9, 0x47, 0xe9, 0x48, 0xe9, 0x49, 0xe9, 0x4a, 0xe9, 0x4b, 0xe9, 0x4c,
    0xe9, 0x4d, 0xe9, 0x4e, 0xe9, 0x4f, 0xe9, 0x50, 0xe9, 0x51, 0xe9, 0x52,
    0xe9, 0x53, 0xe9, 0x54, 0xe9, 0x55, 0xe9, 0x56, 0xe9, 0x57, 0xe9, 0x59,
    0xe9, 0x6a, 0xe9, 0x6b, 0xe9, 0x71, 0xe9, 0x76, 0xe9, 0x77, 0xe9, 0x78,
    0xe9, 0x79, 0xe9, 0x7a};
const uint8_t HuffDecoderCommon::table27_12_emit_[144] = {
    0x01, 0x30, 0x01, 0x31, 0x01, 0x32, 0x01, 0x61, 0x01, 0x63, 0x01, 0x65,
    0x01, 0x69, 0x01, 0x6f, 0x01, 0x73, 0x01, 0x74, 0x01, 0x20, 0x01, 0x25,
    0x01, 0x2d, 0x01, 0x2e, 0x01, 0x2f, 0x01, 0x33, 0x01, 0x34, 0x01, 0x35,
    0x01, 0x36, 0x01, 0x37, 0x01, 0x38, 0x01, 0x39, 0x01, 0x3d, 0x01, 0x41,
    0x01, 0x5f, 0x01, 0x62, 0x01, 0x64, 0x01, 0x66, 0x01, 0x67, 0x01, 0x68,
    0x01, 0x6c, 0x01, 0x6d, 0x01, 0x6e, 0x01, 0x70, 0x01, 0x72, 0x01, 0x75,
    0x87, 0x30, 0x87, 0x31, 0x87, 0x32, 0x87, 0x61, 0x87, 0x63, 0x87, 0x65,
    0x87, 0x69, 0x87, 0x6f, 0x87, 0x73, 0x87, 0x74, 0x87, 0x20, 0x87, 0x25,
    0x87, 0x2d, 0x87, 0x2e, 0x87, 0x2f, 0x87, 0x33, 0x87, 0x34, 0x87, 0x35,
    0x87, 0x36, 0x87, 0x37, 0x87, 0x38, 0x87, 0x39, 0x87, 0x3d, 0x87, 0x41,
    0x87, 0x5f, 0x87, 0x62, 0x87, 0x64, 0x87, 0x66, 0x87, 0x67, 0x87, 0x68,
    0x87, 0x6c, 0x87, 0x6d, 0x87, 0x6e, 0x87, 0x70, 0x87, 0x72, 0x87, 0x75};
const uint8_t HuffDecoderCommon::table27_13_emit_[144] = {
    0x89, 0x30, 0x89, 0x31, 0x89, 0x32, 0x89, 0x61, 0x89, 0x63, 0x89, 0x65,
    0x89, 0x69, 0x89, 0x6f, 0x89, 0x73, 0x89, 0x74, 0x89, 0x20, 0x89, 0x25,
    0x89, 0x2d, 0x89, 0x2e, 0x89, 0x2f, 0x89, 0x33, 0x89, 0x34, 0x89, 0x35,
    0x89, 0x36, 0x89, 0x37, 0x89, 0x38, 0x89, 0x39, 0x89, 0x3d, 0x89, 0x41,
    0x89, 0x5f, 0x89, 0x62, 0x89, 0x64, 0x89, 0x66, 0x89, 0x67, 0x89, 0x68,
    0x89, 0x6c, 0x89, 0x6d, 0x89, 0x6e, 0x89, 0x70, 0x89, 0x72, 0x89, 0x75,
    0x8a, 0x30, 0x8a, 0x31, 0x8a, 0x32, 0x8a, 0x61, 0x8a, 0x63, 0x8a, 0x65,
    0x8a, 0x69, 0x8a, 0x6f, 0x8a, 0x73, 0x8a, 0x74, 0x8a, 0x20, 0x8a, 0x25,
    0x8a, 0x2d, 0x8a, 0x2e, 0x8a, 0x2f, 0x8a, 0x33, 0x8a, 0x34, 0x8a, 0x35,
    0x8a, 0x36, 0x8a, 0x37, 0x8a, 0x38, 0x8a, 0x39, 0x8a, 0x3d, 0x8a, 0x41,
    0x8a, 0x5f, 0x8a, 0x62, 0x8a, 0x64, 0x8a, 0x66, 0x8a, 0x67, 0x8a, 0x68,
    0x8a, 0x6c, 0x8a, 0x6d, 0x8a, 0x6e, 0x8a, 0x70, 0x8a, 0x72, 0x8a, 0x75};
const uint8_t HuffDecoderCommon::table27_14_emit_[144] = {
    0x8b, 0x30, 0x8b, 0x31, 0x8b, 0x32, 0x8b, 0x61, 0x8b, 0x63, 0x8b, 0x65,
    0x8b, 0x69, 0x8b, 0x6f, 0x8b, 0x73, 0x8b, 0x74, 0x8b, 0x20, 0x8b, 0x25,
    0x8b, 0x2d, 0x8b, 0x2e, 0x8b, 0x2f, 0x8b, 0x33, 0x8b, 0x34, 0x8b, 0x35,
    0x8b, 0x36, 0x8b, 0x37, 0x8b, 0x38, 0x8b, 0x39, 0x8b, 0x3d, 0x8b, 0x41,
    0x8b, 0x5f, 0x8b, 0x62, 0x8b, 0x64, 0x8b, 0x66, 0x8b, 0x67, 0x8b, 0x68,
    0x8b, 0x6c, 0x8b, 0x6d, 0x8b, 0x6e, 0x8b, 0x70, 0x8b, 0x72, 0x8b, 0x75,
    0x8c, 0x30, 0x8c, 0x31, 0x8c, 0x32, 0x8c, 0x61, 0x8c, 0x63, 0x8c, 0x65,
    0x8c, 0x69, 0x8c, 0x6f, 0x8c, 0x73, 0x8c, 0x74, 0x8c, 0x20, 0x8c, 0x25,
    0x8c, 0x2d, 0x8c, 0x2e, 0x8c, 0x2f, 0x8c, 0x33, 0x8c, 0x34, 0x8c, 0x35,
    0x8c, 0x36, 0x8c, 0x37, 0x8c, 0x38, 0x8c, 0x39, 0x8c, 0x3d, 0x8c, 0x41,
    0x8c, 0x5f, 0x8c, 0x62, 0x8c, 0x64, 0x8c, 0x66, 0x8c, 0x67, 0x8c, 0x68,
    0x8c, 0x6c, 0x8c, 0x6d, 0x8c, 0x6e, 0x8c, 0x70, 0x8c, 0x72, 0x8c, 0x75};
const uint8_t HuffDecoderCommon::table27_15_emit_[144] = {
    0x8d, 0x30, 0x8d, 0x31, 0x8d, 0x32, 0x8d, 0x61, 0x8d, 0x63, 0x8d, 0x65,
    0x8d, 0x69, 0x8d, 0x6f, 0x8d, 0x73, 0x8d, 0x74, 0x8d, 0x20, 0x8d, 0x25,
    0x8d, 0x2d, 0x8d, 0x2e, 0x8d, 0x2f, 0x8d, 0x33, 0x8d, 0x34, 0x8d, 0x35,
    0x8d, 0x36, 0x8d, 0x37, 0x8d, 0x38, 0x8d, 0x39, 0x8d, 0x3d, 0x8d, 0x41,
    0x8d, 0x5f, 0x8d, 0x62, 0x8d, 0x64, 0x8d, 0x66, 0x8d, 0x67, 0x8d, 0x68,
    0x8d, 0x6c, 0x8d, 0x6d, 0x8d, 0x6e, 0x8d, 0x70, 0x8d, 0x72, 0x8d, 0x75,
    0x8f, 0x30, 0x8f, 0x31, 0x8f, 0x32, 0x8f, 0x61, 0x8f, 0x63, 0x8f, 0x65,
    0x8f, 0x69, 0x8f, 0x6f, 0x8f, 0x73, 0x8f, 0x74, 0x8f, 0x20, 0x8f, 0x25,
    0x8f, 0x2d, 0x8f, 0x2e, 0x8f, 0x2f, 0x8f, 0x33, 0x8f, 0x34, 0x8f, 0x35,
    0x8f, 0x36, 0x8f, 0x37, 0x8f, 0x38, 0x8f, 0x39, 0x8f, 0x3d, 0x8f, 0x41,
    0x8f, 0x5f, 0x8f, 0x62, 0x8f, 0x64, 0x8f, 0x66, 0x8f, 0x67, 0x8f, 0x68,
    0x8f, 0x6c, 0x8f, 0x6d, 0x8f, 0x6e, 0x8f, 0x70, 0x8f, 0x72, 0x8f, 0x75};
const uint8_t HuffDecoderCommon::table27_16_emit_[144] = {
    0x93, 0x30, 0x93, 0x31, 0x93, 0x32, 0x93, 0x61, 0x93, 0x63, 0x93, 0x65,
    0x93, 0x69, 0x93, 0x6f, 0x93, 0x73, 0x93, 0x74, 0x93, 0x20, 0x93, 0x25,
    0x93, 0x2d, 0x93, 0x2e, 0x93, 0x2f, 0x93, 0x33, 0x93, 0x34, 0x93, 0x35,
    0x93, 0x36, 0x93, 0x37, 0x93, 0x38, 0x93, 0x39, 0x93, 0x3d, 0x93, 0x41,
    0x93, 0x5f, 0x93, 0x62, 0x93, 0x64, 0x93, 0x66, 0x93, 0x67, 0x93, 0x68,
    0x93, 0x6c, 0x93, 0x6d, 0x93, 0x6e, 0x93, 0x70, 0x93, 0x72, 0x93, 0x75,
    0x95, 0x30, 0x95, 0x31, 0x95, 0x32, 0x95, 0x61, 0x95, 0x63, 0x95, 0x65,
    0x95, 0x69, 0x95, 0x6f, 0x95, 0x73, 0x95, 0x74, 0x95, 0x20, 0x95, 0x25,
    0x95, 0x2d, 0x95, 0x2e, 0x95, 0x2f, 0x95, 0x33, 0x95, 0x34, 0x95, 0x35,
    0x95, 0x36, 0x95, 0x37, 0x95, 0x38, 0x95, 0x39, 0x95, 0x3d, 0x95, 0x41,
    0x95, 0x5f, 0x95, 0x62, 0x95, 0x64, 0x95, 0x66, 0x95, 0x67, 0x95, 0x68,
    0x95, 0x6c, 0x95, 0x6d, 0x95, 0x6e, 0x95, 0x70, 0x95, 0x72, 0x95, 0x75};
const uint8_t HuffDecoderCommon::table27_17_emit_[144] = {
    0x96, 0x30, 0x96, 0x31, 0x96, 0x32, 0x96, 0x61, 0x96, 0x63, 0x96, 0x65,
    0x96, 0x69, 0x96, 0x6f, 0x96, 0x73, 0x96, 0x74, 0x96, 0x20, 0x96, 0x25,
    0x96, 0x2d, 0x96, 0x2e, 0x96, 0x2f, 0x96, 0x33, 0x96, 0x34, 0x96, 0x35,
    0x96, 0x36, 0x96, 0x37, 0x96, 0x38, 0x96, 0x39, 0x96, 0x3d, 0x96, 0x41,
    0x96, 0x5f, 0x96, 0x62, 0x96, 0x64, 0x96, 0x66, 0x96, 0x67, 0x96, 0x68,
    0x96, 0x6c, 0x96, 0x6d, 0x96, 0x6e, 0x96, 0x70, 0x96, 0x72, 0x96, 0x75,
    0x97, 0x30, 0x97, 0x31, 0x97, 0x32, 0x97, 0x61, 0x97, 0x63, 0x97, 0x65,
    0x97, 0x69, 0x97, 0x6f, 0x97, 0x73, 0x97, 0x74, 0x97, 0x20, 0x97, 0x25,
    0x97, 0x2d, 0x97, 0x2e, 0x97, 0x2f, 0x97, 0x33, 0x97, 0x34, 0x97, 0x35,
    0x97, 0x36, 0x97, 0x37, 0x97, 0x38, 0x97, 0x39, 0x97, 0x3d, 0x97, 0x41,
    0x97, 0x5f, 0x97, 0x62, 0x97, 0x64, 0x97, 0x66, 0x97, 0x67, 0x97, 0x68,
    0x97, 0x6c, 0x97, 0x6d, 0x97, 0x6e, 0x97, 0x70, 0x97, 0x72, 0x97, 0x75};
const uint8_t HuffDecoderCommon::table27_18_emit_[144] = {
    0x98, 0x30, 0x98, 0x31, 0x98, 0x32, 0x98, 0x61, 0x98, 0x63, 0x98, 0x65,
    0x98, 0x69, 0x98, 0x6f, 0x98, 0x73, 0x98, 0x74, 0x98, 0x20, 0x98, 0x25,
    0x98, 0x2d, 0x98, 0x2e, 0x98, 0x2f, 0x98, 0x33, 0x98, 0x34, 0x98, 0x35,
    0x98, 0x36, 0x98, 0x37, 0x98, 0x38, 0x98, 0x39, 0x98, 0x3d, 0x98, 0x41,
    0x98, 0x5f, 0x98, 0x62, 0x98, 0x64, 0x98, 0x66, 0x98, 0x67, 0x98, 0x68,
    0x98, 0x6c, 0x98, 0x6d, 0x98, 0x6e, 0x98, 0x70, 0x98, 0x72, 0x98, 0x75,
    0x9b, 0x30, 0x9b, 0x31, 0x9b, 0x32, 0x9b, 0x61, 0x9b, 0x63, 0x9b, 0x65,
    0x9b, 0x69, 0x9b, 0x6f, 0x9b, 0x73, 0x9b, 0x74, 0x9b, 0x20, 0x9b, 0x25,
    0x9b, 0x2d, 0x9b, 0x2e, 0x9b, 0x2f, 0x9b, 0x33, 0x9b, 0x34, 0x9b, 0x35,
    0x9b, 0x36, 0x9b, 0x37, 0x9b, 0x38, 0x9b, 0x39, 0x9b, 0x3d, 0x9b, 0x41,
    0x9b, 0x5f, 0x9b, 0x62, 0x9b, 0x64, 0x9b, 0x66, 0x9b, 0x67, 0x9b, 0x68,
    0x9b, 0x6c, 0x9b, 0x6d, 0x9b, 0x6e, 0x9b, 0x70, 0x9b, 0x72, 0x9b, 0x75};
const uint8_t HuffDecoderCommon::table27_19_emit_[144] = {
    0x9d, 0x30, 0x9d, 0x31, 0x9d, 0x32, 0x9d, 0x61, 0x9d, 0x63, 0x9d, 0x65,
    0x9d, 0x69, 0x9d, 0x6f, 0x9d, 0x73, 0x9d, 0x74, 0x9d, 0x20, 0x9d, 0x25,
    0x9d, 0x2d, 0x9d, 0x2e, 0x9d, 0x2f, 0x9d, 0x33, 0x9d, 0x34, 0x9d, 0x35,
    0x9d, 0x36, 0x9d, 0x37, 0x9d, 0x38, 0x9d, 0x39, 0x9d, 0x3d, 0x9d, 0x41,
    0x9d, 0x5f, 0x9d, 0x62, 0x9d, 0x64, 0x9d, 0x66, 0x9d, 0x67, 0x9d, 0x68,
    0x9d, 0x6c, 0x9d, 0x6d, 0x9d, 0x6e, 0x9d, 0x70, 0x9d, 0x72, 0x9d, 0x75,
    0x9e, 0x30, 0x9e, 0x31, 0x9e, 0x32, 0x9e, 0x61, 0x9e, 0x63, 0x9e, 0x65,
    0x9e, 0x69, 0x9e, 0x6f, 0x9e, 0x73, 0x9e, 0x74, 0x9e, 0x20, 0x9e, 0x25,
    0x9e, 0x2d, 0x9e, 0x2e, 0x9e, 0x2f, 0x9e, 0x33, 0x9e, 0x34, 0x9e, 0x35,
    0x9e, 0x36, 0x9e, 0x37, 0x9e, 0x38, 0x9e, 0x39, 0x9e, 0x3d, 0x9e, 0x41,
    0x9e, 0x5f, 0x9e, 0x62, 0x9e, 0x64, 0x9e, 0x66, 0x9e, 0x67, 0x9e, 0x68,
    0x9e, 0x6c, 0x9e, 0x6d, 0x9e, 0x6e, 0x9e, 0x70, 0x9e, 0x72, 0x9e, 0x75};
const uint8_t HuffDecoderCommon::table27_20_emit_[144] = {
    0xa5, 0x30, 0xa5, 0x31, 0xa5, 0x32, 0xa5, 0x61, 0xa5, 0x63, 0xa5, 0x65,
    0xa5, 0x69, 0xa5, 0x6f, 0xa5, 0x73, 0xa5, 0x74, 0xa5, 0x20, 0xa5, 0x25,
    0xa5, 0x2d, 0xa5, 0x2e, 0xa5, 0x2f, 0xa5, 0x33, 0xa5, 0x34, 0xa5, 0x35,
    0xa5, 0x36, 0xa5, 0x37, 0xa5, 0x38, 0xa5, 0x39, 0xa5, 0x3d, 0xa5, 0x41,
    0xa5, 0x5f, 0xa5, 0x62, 0xa5, 0x64, 0xa5, 0x66, 0xa5, 0x67, 0xa5, 0x68,
    0xa5, 0x6c, 0xa5, 0x6d, 0xa5, 0x6e, 0xa5, 0x70, 0xa5, 0x72, 0xa5, 0x75,
    0xa6, 0x30, 0xa6, 0x31, 0xa6, 0x32, 0xa6, 0x61, 0xa6, 0x63, 0xa6, 0x65,
    0xa6, 0x69, 0xa6, 0x6f, 0xa6, 0x73, 0xa6, 0x74, 0xa6, 0x20, 0xa6, 0x25,
    0xa6, 0x2d, 0xa6, 0x2e, 0xa6, 0x2f, 0xa6, 0x33, 0xa6, 0x34, 0xa6, 0x35,
    0xa6, 0x36, 0xa6, 0x37, 0xa6, 0x38, 0xa6, 0x39, 0xa6, 0x3d, 0xa6, 0x41,
    0xa6, 0x5f, 0xa6, 0x62, 0xa6, 0x64, 0xa6, 0x66, 0xa6, 0x67, 0xa6, 0x68,
    0xa6, 0x6c, 0xa6, 0x6d, 0xa6, 0x6e, 0xa6, 0x70, 0xa6, 0x72, 0xa6, 0x75};
const uint8_t HuffDecoderCommon::table27_21_emit_[144] = {
    0xa8, 0x30, 0xa8, 0x31, 0xa8, 0x32, 0xa8, 0x61, 0xa8, 0x63, 0xa8, 0x65,
    0xa8, 0x69, 0xa8, 0x6f, 0xa8, 0x73, 0xa8, 0x74, 0xa8, 0x20, 0xa8, 0x25,
    0xa8, 0x2d, 0xa8, 0x2e, 0xa8, 0x2f, 0xa8, 0x33, 0xa8, 0x34, 0xa8, 0x35,
    0xa8, 0x36, 0xa8, 0x37, 0xa8, 0x38, 0xa8, 0x39, 0xa8, 0x3d, 0xa8, 0x41,
    0xa8, 0x5f, 0xa8, 0x62, 0xa8, 0x64, 0xa8, 0x66, 0xa8, 0x67, 0xa8, 0x68,
    0xa8, 0x6c, 0xa8, 0x6d, 0xa8, 0x6e, 0xa8, 0x70, 0xa8, 0x72, 0xa8, 0x75,
    0xae, 0x30, 0xae, 0x31, 0xae, 0x32, 0xae, 0x61, 0xae, 0x63, 0xae, 0x65,
    0xae, 0x69, 0xae, 0x6f, 0xae, 0x73, 0xae, 0x74, 0xae, 0x20, 0xae, 0x25,
    0xae, 0x2d, 0xae, 0x2e, 0xae, 0x2f, 0xae, 0x33, 0xae, 0x34, 0xae, 0x35,
    0xae, 0x36, 0xae, 0x37, 0xae, 0x38, 0xae, 0x39, 0xae, 0x3d, 0xae, 0x41,
    0xae, 0x5f, 0xae, 0x62, 0xae, 0x64, 0xae, 0x66, 0xae, 0x67, 0xae, 0x68,
    0xae, 0x6c, 0xae, 0x6d, 0xae, 0x6e, 0xae, 0x70, 0xae, 0x72, 0xae, 0x75};
const uint8_t HuffDecoderCommon::table27_22_emit_[144] = {
    0xaf, 0x30, 0xaf, 0x31, 0xaf, 0x32, 0xaf, 0x61, 0xaf, 0x63, 0xaf, 0x65,
    0xaf, 0x69, 0xaf, 0x6f, 0xaf, 0x73, 0xaf, 0x74, 0xaf, 0x20, 0xaf, 0x25,
    0xaf, 0x2d, 0xaf, 0x2e, 0xaf, 0x2f, 0xaf, 0x33, 0xaf, 0x34, 0xaf, 0x35,
    0xaf, 0x36, 0xaf, 0x37, 0xaf, 0x38, 0xaf, 0x39, 0xaf, 0x3d, 0xaf, 0x41,
    0xaf, 0x5f, 0xaf, 0x62, 0xaf, 0x64, 0xaf, 0x66, 0xaf, 0x67, 0xaf, 0x68,
    0xaf, 0x6c, 0xaf, 0x6d, 0xaf, 0x6e, 0xaf, 0x70, 0xaf, 0x72, 0xaf, 0x75,
    0xb4, 0x30, 0xb4, 0x31, 0xb4, 0x32, 0xb4, 0x61, 0xb4, 0x63, 0xb4, 0x65,
    0xb4, 0x69, 0xb4, 0x6f, 0xb4, 0x73, 0xb4, 0x74, 0xb4, 0x20, 0xb4, 0x25,
    0xb4, 0x2d, 0xb4, 0x2e, 0xb4, 0x2f, 0xb4, 0x33, 0xb4, 0x34, 0xb4, 0x35,
    0xb4, 0x36, 0xb4, 0x37, 0xb4, 0x38, 0xb4, 0x39, 0xb4, 0x3d, 0xb4, 0x41,
    0xb4, 0x5f, 0xb4, 0x62, 0xb4, 0x64, 0xb4, 0x66, 0xb4, 0x67, 0xb4, 0x68,
    0xb4, 0x6c, 0xb4, 0x6d, 0xb4, 0x6e, 0xb4, 0x70, 0xb4, 0x72, 0xb4, 0x75};
const uint8_t HuffDecoderCommon::table27_23_emit_[144] = {
    0xb6, 0x30, 0xb6, 0x31, 0xb6, 0x32, 0xb6, 0x61, 0xb6, 0x63, 0xb6, 0x65,
    0xb6, 0x69, 0xb6, 0x6f, 0xb6, 0x73, 0xb6, 0x74, 0xb6, 0x20, 0xb6, 0x25,
    0xb6, 0x2d, 0xb6, 0x2e, 0xb6, 0x2f, 0xb6, 0x33, 0xb6, 0x34, 0xb6, 0x35,
    0xb6, 0x36, 0xb6, 0x37, 0xb6, 0x38, 0xb6, 0x39, 0xb6, 0x3d, 0xb6, 0x41,
    0xb6, 0x5f, 0xb6, 0x62, 0xb6, 0x64, 0xb6, 0x66, 0xb6, 0x67, 0xb6, 0x68,
    0xb6, 0x6c, 0xb6, 0x6d, 0xb6, 0x6e, 0xb6, 0x70, 0xb6, 0x72, 0xb6, 0x75,
    0xb7, 0x30, 0xb7, 0x31, 0xb7, 0x32, 0xb7, 0x61, 0xb7, 0x63, 0xb7, 0x65,
    0xb7, 0x69, 0xb7, 0x6f, 0xb7, 0x73, 0xb7, 0x74, 0xb7, 0x20, 0xb7, 0x25,
    0xb7, 0x2d, 0xb7, 0x2e, 0xb7, 0x2f, 0xb7, 0x33, 0xb7, 0x34, 0xb7, 0x35,
    0xb7, 0x36, 0xb7, 0x37, 0xb7, 0x38, 0xb7, 0x39, 0xb7, 0x3d, 0xb7, 0x41,
    0xb7, 0x5f, 0xb7, 0x62, 0xb7, 0x64, 0xb7, 0x66, 0xb7, 0x67, 0xb7, 0x68,
    0xb7, 0x6c, 0xb7, 0x6d, 0xb7, 0x6e, 0xb7, 0x70, 0xb7, 0x72, 0xb7, 0x75};
const uint8_t HuffDecoderCommon::table27_24_emit_[144] = {
    0xbc, 0x30, 0xbc, 0x31, 0xbc, 0x32, 0xbc, 0x61, 0xbc, 0x63, 0xbc, 0x65,
    0xbc, 0x69, 0xbc, 0x6f, 0xbc, 0x73, 0xbc, 0x74, 0xbc, 0x20, 0xbc, 0x25,
    0xbc, 0x2d, 0xbc, 0x2e, 0xbc, 0x2f, 0xbc, 0x33, 0xbc, 0x34, 0xbc, 0x35,
    0xbc, 0x36, 0xbc, 0x37, 0xbc, 0x38, 0xbc, 0x39, 0xbc, 0x3d, 0xbc, 0x41,
    0xbc, 0x5f, 0xbc, 0x62, 0xbc, 0x64, 0xbc, 0x66, 0xbc, 0x67, 0xbc, 0x68,
    0xbc, 0x6c, 0xbc, 0x6d, 0xbc, 0x6e, 0xbc, 0x70, 0xbc, 0x72, 0xbc, 0x75,
    0xbf, 0x30, 0xbf, 0x31, 0xbf, 0x32, 0xbf, 0x61, 0xbf, 0x63, 0xbf, 0x65,
    0xbf, 0x69, 0xbf, 0x6f, 0xbf, 0x73, 0xbf, 0x74, 0xbf, 0x20, 0xbf, 0x25,
    0xbf, 0x2d, 0xbf, 0x2e, 0xbf, 0x2f, 0xbf, 0x33, 0xbf, 0x34, 0xbf, 0x35,
    0xbf, 0x36, 0xbf, 0x37, 0xbf, 0x38, 0xbf, 0x39, 0xbf, 0x3d, 0xbf, 0x41,
    0xbf, 0x5f, 0xbf, 0x62, 0xbf, 0x64, 0xbf, 0x66, 0xbf, 0x67, 0xbf, 0x68,
    0xbf, 0x6c, 0xbf, 0x6d, 0xbf, 0x6e, 0xbf, 0x70, 0xbf, 0x72, 0xbf, 0x75};
const uint8_t HuffDecoderCommon::table27_25_emit_[144] = {
    0xc5, 0x30, 0xc5, 0x31, 0xc5, 0x32, 0xc5, 0x61, 0xc5, 0x63, 0xc5, 0x65,
    0xc5, 0x69, 0xc5, 0x6f, 0xc5, 0x73, 0xc5, 0x74, 0xc5, 0x20, 0xc5, 0x25,
    0xc5, 0x2d, 0xc5, 0x2e, 0xc5, 0x2f, 0xc5, 0x33, 0xc5, 0x34, 0xc5, 0x35,
    0xc5, 0x36, 0xc5, 0x37, 0xc5, 0x38, 0xc5, 0x39, 0xc5, 0x3d, 0xc5, 0x41,
    0xc5, 0x5f, 0xc5, 0x62, 0xc5, 0x64, 0xc5, 0x66, 0xc5, 0x67, 0xc5, 0x68,
    0xc5, 0x6c, 0xc5, 0x6d, 0xc5, 0x6e, 0xc5, 0x70, 0xc5, 0x72, 0xc5, 0x75,
    0xe7, 0x30, 0xe7, 0x31, 0xe7, 0x32, 0xe7, 0x61, 0xe7, 0x63, 0xe7, 0x65,
    0xe7, 0x69, 0xe7, 0x6f, 0xe7, 0x73, 0xe7, 0x74, 0xe7, 0x20, 0xe7, 0x25,
    0xe7, 0x2d, 0xe7, 0x2e, 0xe7, 0x2f, 0xe7, 0x33, 0xe7, 0x34, 0xe7, 0x35,
    0xe7, 0x36, 0xe7, 0x37, 0xe7, 0x38, 0xe7, 0x39, 0xe7, 0x3d, 0xe7, 0x41,
    0xe7, 0x5f, 0xe7, 0x62, 0xe7, 0x64, 0xe7, 0x66, 0xe7, 0x67, 0xe7, 0x68,
    0xe7, 0x6c, 0xe7, 0x6d, 0xe7, 0x6e, 0xe7, 0x70, 0xe7, 0x72, 0xe7, 0x75};
const uint8_t HuffDecoderCommon::table27_26_emit_[112] = {
    0xef, 0x30, 0xef, 0x31, 0xef, 0x32, 0xef, 0x61, 0xef, 0x63, 0xef, 0x65,
    0xef, 0x69, 0xef, 0x6f, 0xef, 0x73, 0xef, 0x74, 0xef, 0x20, 0xef, 0x25,
    0xef, 0x2d, 0xef, 0x2e, 0xef, 0x2f, 0xef, 0x33, 0xef, 0x34, 0xef, 0x35,
    0xef, 0x36, 0xef, 0x37, 0xef, 0x38, 0xef, 0x39, 0xef, 0x3d, 0xef, 0x41,
    0xef, 0x5f, 0xef, 0x62, 0xef, 0x64, 0xef, 0x66, 0xef, 0x67, 0xef, 0x68,
    0xef, 0x6c, 0xef, 0x6d, 0xef, 0x6e, 0xef, 0x70, 0xef, 0x72, 0xef, 0x75,
    0x09, 0x30, 0x09, 0x31, 0x09, 0x32, 0x09, 0x61, 0x09, 0x63, 0x09, 0x65,
    0x09, 0x69, 0x09, 0x6f, 0x09, 0x73, 0x09, 0x74, 0x8e, 0x30, 0x8e, 0x31,
    0x8e, 0x32, 0x8e, 0x61, 0x8e, 0x63, 0x8e, 0x65, 0x8e, 0x69, 0x8e, 0x6f,
    0x8e, 0x73, 0x8e, 0x74};
const uint16_t HuffDecoderCommon::table27_26_ops_[128] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019, 0x0000,
    0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039, 0x0000, 0x0041,
    0x0000, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071, 0x0079, 0x0081,
    0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9,
    0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109, 0x0111,
    0x0119, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0002, 0x0121, 0x0129, 0x0131, 0x0139, 0x0141, 0x0149, 0x0151, 0x0159,
    0x0161, 0x0169, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0122, 0x0171, 0x0179, 0x0181,
    0x0189, 0x0191, 0x0199, 0x01a1, 0x01a9, 0x01b1, 0x01b9, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0172};
const uint8_t HuffDecoderCommon::table27_27_emit_[80] = {
    0x90, 0x30, 0x90, 0x31, 0x90, 0x32, 0x90, 0x61, 0x90, 0x63, 0x90, 0x65,
    0x90, 0x69, 0x90, 0x6f, 0x90, 0x73, 0x90, 0x74, 0x91, 0x30, 0x91, 0x31,
    0x91, 0x32, 0x91, 0x61, 0x91, 0x63, 0x91, 0x65, 0x91, 0x69, 0x91, 0x6f,
    0x91, 0x73, 0x91, 0x74, 0x94, 0x30, 0x94, 0x31, 0x94, 0x32, 0x94, 0x61,
    0x94, 0x63, 0x94, 0x65, 0x94, 0x69, 0x94, 0x6f, 0x94, 0x73, 0x94, 0x74,
    0x9f, 0x30, 0x9f, 0x31, 0x9f, 0x32, 0x9f, 0x61, 0x9f, 0x63, 0x9f, 0x65,
    0x9f, 0x69, 0x9f, 0x6f, 0x9f, 0x73, 0x9f, 0x74};
const uint8_t HuffDecoderCommon::table27_28_emit_[80] = {
    0xab, 0x30, 0xab, 0x31, 0xab, 0x32, 0xab, 0x61, 0xab, 0x63, 0xab, 0x65,
    0xab, 0x69, 0xab, 0x6f, 0xab, 0x73, 0xab, 0x74, 0xce, 0x30, 0xce, 0x31,
    0xce, 0x32, 0xce, 0x61, 0xce, 0x63, 0xce, 0x65, 0xce, 0x69, 0xce, 0x6f,
    0xce, 0x73, 0xce, 0x74, 0xd7, 0x30, 0xd7, 0x31, 0xd7, 0x32, 0xd7, 0x61,
    0xd7, 0x63, 0xd7, 0x65, 0xd7, 0x69, 0xd7, 0x6f, 0xd7, 0x73, 0xd7, 0x74,
    0xe1, 0x30, 0xe1, 0x31, 0xe1, 0x32, 0xe1, 0x61, 0xe1, 0x63, 0xe1, 0x65,
    0xe1, 0x69, 0xe1, 0x6f, 0xe1, 0x73, 0xe1, 0x74};
const uint8_t HuffDecoderCommon::table27_29_emit_[44] = {
    0xec, 0x30, 0xec, 0x31, 0xec, 0x32, 0xec, 0x61, 0xec, 0x63, 0xec,
    0x65, 0xec, 0x69, 0xec, 0x6f, 0xec, 0x73, 0xec, 0x74, 0xed, 0x30,
    0xed, 0x31, 0xed, 0x32, 0xed, 0x61, 0xed, 0x63, 0xed, 0x65, 0xed,
    0x69, 0xed, 0x6f, 0xed, 0x73, 0xed, 0x74, 0xc7, 0xcf, 0xea, 0xeb};
const uint16_t HuffDecoderCommon::table27_29_ops_[128] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039, 0x0041,
    0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00a6, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x00aa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x00ae};
const uint8_t HuffDecoderCommon::table27_30_emit_[17] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda,
    0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc};
const uint16_t HuffDecoderCommon::table27_30_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0016, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x001a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x001e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0026, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x002a, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x002e, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0036, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x003a, 0x0000, 0x0000, 0x0000, 0x003e, 0x0000, 0x0000,
    0x0000, 0x0042};
const uint8_t HuffDecoderCommon::table27_31_emit_[46] = {
    0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf, 0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
    0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0x0b, 0x0c, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18,
    0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint16_t HuffDecoderCommon::table27_31_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0006, 0x0000,
    0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x000e, 0x0000, 0x0000,
    0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0016, 0x0000, 0x0000, 0x0000,
    0x001a, 0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0026, 0x0000, 0x0000, 0x0000, 0x002a, 0x0000,
    0x0000, 0x0000, 0x002e, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000,
    0x0000, 0x0036, 0x0000, 0x0000, 0x0000, 0x003a, 0x0000, 0x0000, 0x0000,
    0x003e, 0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0046, 0x0000, 0x004a,
    0x0000, 0x004e, 0x0000, 0x0052, 0x0000, 0x0056, 0x0000, 0x005a, 0x0000,
    0x005e, 0x0000, 0x0062, 0x0000, 0x0066, 0x0000, 0x006a, 0x0000, 0x006e,
    0x0000, 0x0072, 0x0000, 0x0076, 0x0000, 0x007a, 0x0000, 0x007e, 0x0000,
    0x0082, 0x0000, 0x0086, 0x0000, 0x008a, 0x0000, 0x008e, 0x0000, 0x0092,
    0x0000, 0x0096, 0x0000, 0x009a, 0x0000, 0x009e, 0x0000, 0x00a2, 0x0000,
    0x00a6, 0x0000, 0x00aa, 0x0000, 0x00ae, 0x0000, 0x00b2, 0x0000, 0x00b6,
    0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table27_emit_[32] = {
    table27_0_emit_,  table27_1_emit_,  table27_2_emit_,  table27_3_emit_,
    table27_4_emit_,  table27_5_emit_,  table27_6_emit_,  table27_7_emit_,
    table27_8_emit_,  table27_9_emit_,  table27_10_emit_, table27_11_emit_,
    table27_12_emit_, table27_13_emit_, table27_14_emit_, table27_15_emit_,
    table27_16_emit_, table27_17_emit_, table27_18_emit_, table27_19_emit_,
    table27_20_emit_, table27_21_emit_, table27_22_emit_, table27_23_emit_,
    table27_24_emit_, table27_25_emit_, table27_26_emit_, table27_27_emit_,
    table27_28_emit_, table27_29_emit_, table27_30_emit_, table27_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table27_ops_[32] = {
    table27_0_ops_, table27_0_ops_,  table27_0_ops_,  table27_0_ops_,
    table27_0_ops_, table27_0_ops_,  table27_0_ops_,  table27_0_ops_,
    table27_0_ops_, table27_0_ops_,  table27_0_ops_,  table27_0_ops_,
    table26_0_ops_, table26_0_ops_,  table26_0_ops_,  table26_0_ops_,
    table26_0_ops_, table26_0_ops_,  table26_0_ops_,  table26_0_ops_,
    table26_0_ops_, table26_0_ops_,  table26_0_ops_,  table26_0_ops_,
    table26_0_ops_, table26_0_ops_,  table27_26_ops_, table26_6_ops_,
    table26_6_ops_, table27_29_ops_, table27_30_ops_, table27_31_ops_,
};
const uint8_t HuffDecoderCommon::table19_0_emit_[1] = {0xb2};
const uint16_t HuffDecoderCommon::table19_0_ops_[128] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005};
const uint8_t HuffDecoderCommon::table19_2_emit_[1] = {0xb5};
const uint8_t HuffDecoderCommon::table19_4_emit_[1] = {0xb9};
const uint8_t HuffDecoderCommon::table19_6_emit_[1] = {0xba};
const uint8_t HuffDecoderCommon::table19_8_emit_[1] = {0xbb};
const uint8_t HuffDecoderCommon::table19_10_emit_[1] = {0xbd};
const uint8_t HuffDecoderCommon::table19_12_emit_[1] = {0xbe};
const uint8_t HuffDecoderCommon::table19_14_emit_[1] = {0xc4};
const uint8_t HuffDecoderCommon::table19_16_emit_[1] = {0xc6};
const uint8_t HuffDecoderCommon::table19_18_emit_[1] = {0xe4};
const uint8_t HuffDecoderCommon::table19_20_emit_[1] = {0xe8};
const uint8_t HuffDecoderCommon::table19_22_emit_[1] = {0xe9};
const uint8_t HuffDecoderCommon::table19_24_emit_[1] = {0x01};
const uint16_t HuffDecoderCommon::table19_24_ops_[128] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006};
const uint8_t HuffDecoderCommon::table19_25_emit_[1] = {0x87};
const uint8_t HuffDecoderCommon::table19_26_emit_[1] = {0x89};
const uint8_t HuffDecoderCommon::table19_27_emit_[1] = {0x8a};
const uint8_t HuffDecoderCommon::table19_28_emit_[1] = {0x8b};
const uint8_t HuffDecoderCommon::table19_29_emit_[1] = {0x8c};
const uint8_t HuffDecoderCommon::table19_30_emit_[1] = {0x8d};
const uint8_t HuffDecoderCommon::table19_31_emit_[1] = {0x8f};
const uint8_t HuffDecoderCommon::table19_32_emit_[1] = {0x93};
const uint8_t HuffDecoderCommon::table19_33_emit_[1] = {0x95};
const uint8_t HuffDecoderCommon::table19_34_emit_[1] = {0x96};
const uint8_t HuffDecoderCommon::table19_35_emit_[1] = {0x97};
const uint8_t HuffDecoderCommon::table19_36_emit_[1] = {0x98};
const uint8_t HuffDecoderCommon::table19_37_emit_[1] = {0x9b};
const uint8_t HuffDecoderCommon::table19_38_emit_[1] = {0x9d};
const uint8_t HuffDecoderCommon::table19_39_emit_[1] = {0x9e};
const uint8_t HuffDecoderCommon::table19_40_emit_[1] = {0xa5};
const uint8_t HuffDecoderCommon::table19_41_emit_[1] = {0xa6};
const uint8_t HuffDecoderCommon::table19_42_emit_[1] = {0xa8};
const uint8_t HuffDecoderCommon::table19_43_emit_[1] = {0xae};
const uint8_t HuffDecoderCommon::table19_44_emit_[1] = {0xaf};
const uint8_t HuffDecoderCommon::table19_45_emit_[1] = {0xb4};
const uint8_t HuffDecoderCommon::table19_46_emit_[1] = {0xb6};
const uint8_t HuffDecoderCommon::table19_47_emit_[1] = {0xb7};
const uint8_t HuffDecoderCommon::table19_48_emit_[1] = {0xbc};
const uint8_t HuffDecoderCommon::table19_49_emit_[1] = {0xbf};
const uint8_t HuffDecoderCommon::table19_50_emit_[1] = {0xc5};
const uint8_t HuffDecoderCommon::table19_51_emit_[1] = {0xe7};
const uint8_t HuffDecoderCommon::table19_52_emit_[1] = {0xef};
const uint8_t HuffDecoderCommon::table19_53_emit_[2] = {0x09, 0x8e};
const uint16_t HuffDecoderCommon::table19_53_ops_[128] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027};
const uint8_t HuffDecoderCommon::table19_54_emit_[2] = {0x90, 0x91};
const uint8_t HuffDecoderCommon::table19_55_emit_[2] = {0x94, 0x9f};
const uint8_t HuffDecoderCommon::table19_56_emit_[2] = {0xab, 0xce};
const uint8_t HuffDecoderCommon::table19_57_emit_[2] = {0xd7, 0xe1};
const uint8_t HuffDecoderCommon::table19_58_emit_[2] = {0xec, 0xed};
const uint8_t HuffDecoderCommon::table19_59_emit_[4] = {0xc7, 0xcf, 0xea, 0xeb};
const uint16_t HuffDecoderCommon::table19_59_ops_[128] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0068, 0x0068, 0x0068,
    0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068,
    0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068,
    0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068,
    0x0068, 0x0068};
const uint8_t HuffDecoderCommon::table19_60_emit_[8] = {0xc0, 0xc1, 0xc8, 0xc9,
                                                        0xca, 0xcd, 0xd2, 0xd5};
const uint16_t HuffDecoderCommon::table19_60_ops_[128] = {
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x00a9,
    0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
    0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00e9, 0x00e9, 0x00e9, 0x00e9, 0x00e9,
    0x00e9, 0x00e9, 0x00e9, 0x00e9, 0x00e9, 0x00e9, 0x00e9, 0x00e9, 0x00e9,
    0x00e9, 0x00e9};
const uint8_t HuffDecoderCommon::table19_61_emit_[9] = {
    0xda, 0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc};
const uint16_t HuffDecoderCommon::table19_61_ops_[128] = {
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x00a9,
    0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
    0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
    0x00ea, 0x00ea, 0x00ea, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a};
const uint8_t HuffDecoderCommon::table19_62_emit_[16] = {
    0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf, 0xf1, 0xf4,
    0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd};
const uint16_t HuffDecoderCommon::table19_62_ops_[128] = {
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x006a, 0x006a, 0x006a,
    0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
    0x00aa, 0x00aa, 0x00aa, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
    0x00ea, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x012a, 0x012a, 0x012a, 0x012a, 0x012a, 0x012a, 0x012a, 0x012a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x016a, 0x016a,
    0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x018a, 0x018a, 0x018a,
    0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x01aa, 0x01aa, 0x01aa, 0x01aa,
    0x01aa, 0x01aa, 0x01aa, 0x01aa, 0x01ca, 0x01ca, 0x01ca, 0x01ca, 0x01ca,
    0x01ca, 0x01ca, 0x01ca, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01ea,
    0x01ea, 0x01ea};
const uint8_t HuffDecoderCommon::table19_63_emit_[33] = {
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0b, 0x0c, 0x0e,
    0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18, 0x19, 0x1a,
    0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9, 0x0a, 0x0d, 0x16};
const uint16_t HuffDecoderCommon::table19_63_ops_[128] = {
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x002b,
    0x002b, 0x002b, 0x002b, 0x004b, 0x004b, 0x004b, 0x004b, 0x006b, 0x006b,
    0x006b, 0x006b, 0x008b, 0x008b, 0x008b, 0x008b, 0x00ab, 0x00ab, 0x00ab,
    0x00ab, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00eb, 0x00eb, 0x00eb, 0x00eb,
    0x010b, 0x010b, 0x010b, 0x010b, 0x012b, 0x012b, 0x012b, 0x012b, 0x014b,
    0x014b, 0x014b, 0x014b, 0x016b, 0x016b, 0x016b, 0x016b, 0x018b, 0x018b,
    0x018b, 0x018b, 0x01ab, 0x01ab, 0x01ab, 0x01ab, 0x01cb, 0x01cb, 0x01cb,
    0x01cb, 0x01eb, 0x01eb, 0x01eb, 0x01eb, 0x020b, 0x020b, 0x020b, 0x020b,
    0x022b, 0x022b, 0x022b, 0x022b, 0x024b, 0x024b, 0x024b, 0x024b, 0x026b,
    0x026b, 0x026b, 0x026b, 0x028b, 0x028b, 0x028b, 0x028b, 0x02ab, 0x02ab,
    0x02ab, 0x02ab, 0x02cb, 0x02cb, 0x02cb, 0x02cb, 0x02eb, 0x02eb, 0x02eb,
    0x02eb, 0x030b, 0x030b, 0x030b, 0x030b, 0x032b, 0x032b, 0x032b, 0x032b,
    0x034b, 0x034b, 0x034b, 0x034b, 0x036b, 0x036b, 0x036b, 0x036b, 0x038b,
    0x038b, 0x038b, 0x038b, 0x03ab, 0x03ab, 0x03ab, 0x03ab, 0x03cd, 0x03ed,
    0x040d, 0x001d};
const uint8_t* const HuffDecoderCommon::table19_emit_[64] = {
    table19_0_emit_,  table19_0_emit_,  table19_2_emit_,  table19_2_emit_,
    table19_4_emit_,  table19_4_emit_,  table19_6_emit_,  table19_6_emit_,
    table19_8_emit_,  table19_8_emit_,  table19_10_emit_, table19_10_emit_,
    table19_12_emit_, table19_12_emit_, table19_14_emit_, table19_14_emit_,
    table19_16_emit_, table19_16_emit_, table19_18_emit_, table19_18_emit_,
    table19_20_emit_, table19_20_emit_, table19_22_emit_, table19_22_emit_,
    table19_24_emit_, table19_25_emit_, table19_26_emit_, table19_27_emit_,
    table19_28_emit_, table19_29_emit_, table19_30_emit_, table19_31_emit_,
    table19_32_emit_, table19_33_emit_, table19_34_emit_, table19_35_emit_,
    table19_36_emit_, table19_37_emit_, table19_38_emit_, table19_39_emit_,
    table19_40_emit_, table19_41_emit_, table19_42_emit_, table19_43_emit_,
    table19_44_emit_, table19_45_emit_, table19_46_emit_, table19_47_emit_,
    table19_48_emit_, table19_49_emit_, table19_50_emit_, table19_51_emit_,
    table19_52_emit_, table19_53_emit_, table19_54_emit_, table19_55_emit_,
    table19_56_emit_, table19_57_emit_, table19_58_emit_, table19_59_emit_,
    table19_60_emit_, table19_61_emit_, table19_62_emit_, table19_63_emit_,
};
const uint16_t* const HuffDecoderCommon::table19_ops_[64] = {
    table19_0_ops_,  table19_0_ops_,  table19_0_ops_,  table19_0_ops_,
    table19_0_ops_,  table19_0_ops_,  table19_0_ops_,  table19_0_ops_,
    table19_0_ops_,  table19_0_ops_,  table19_0_ops_,  table19_0_ops_,
    table19_0_ops_,  table19_0_ops_,  table19_0_ops_,  table19_0_ops_,
    table19_0_ops_,  table19_0_ops_,  table19_0_ops_,  table19_0_ops_,
    table19_0_ops_,  table19_0_ops_,  table19_0_ops_,  table19_0_ops_,
    table19_24_ops_, table19_24_ops_, table19_24_ops_, table19_24_ops_,
    table19_24_ops_, table19_24_ops_, table19_24_ops_, table19_24_ops_,
    table19_24_ops_, table19_24_ops_, table19_24_ops_, table19_24_ops_,
    table19_24_ops_, table19_24_ops_, table19_24_ops_, table19_24_ops_,
    table19_24_ops_, table19_24_ops_, table19_24_ops_, table19_24_ops_,
    table19_24_ops_, table19_24_ops_, table19_24_ops_, table19_24_ops_,
    table19_24_ops_, table19_24_ops_, table19_24_ops_, table19_24_ops_,
    table19_24_ops_, table19_53_ops_, table19_53_ops_, table19_53_ops_,
    table19_53_ops_, table19_53_ops_, table19_53_ops_, table19_59_ops_,
    table19_60_ops_, table19_61_ops_, table19_62_ops_, table19_63_ops_,
};
}  // namespace geometry_10_7_13
}  // namespace grpc_core
