// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#include "test/cpp/microbenchmarks/huffman_geometries/decode_huff_11_13_6.h"

#include <grpc/support/port_platform.h>
namespace grpc_core {
namespace geometry_11_13_6 {
const uint8_t HuffDecoderCommon::table2_0_emit_[10] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74};
const uint8_t HuffDecoderCommon::table2_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table3_0_emit_[36] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20, 0x25,
    0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3d, 0x41,
    0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70, 0x72, 0x75};
const uint8_t HuffDecoderCommon::table3_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x29, 0x2d,
    0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59,
    0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85,
    0x89, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table4_0_emit_[22] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20,
    0x25, 0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table4_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00,
    0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x25, 0x00, 0x29, 0x00, 0x2d,
    0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41, 0x00,
    0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table4_1_emit_[46] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70,
    0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a,
    0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
    0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table4_1_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49,
    0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75,
    0x79, 0x7d, 0x81, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1,
    0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table4_emit_[2] = {
    table4_0_emit_,
    table4_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table4_ops_[2] = {
    table4_0_ops_,
    table4_1_ops_,
};
const uint8_t HuffDecoderCommon::table5_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29,
    0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35,
    0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x41,
    0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4d,
    0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table5_1_emit_[52] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e,
    0x70, 0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78,
    0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint8_t HuffDecoderCommon::table5_1_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d,
    0x00, 0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55,
    0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x00, 0x65, 0x00, 0x69, 0x00, 0x6d,
    0x00, 0x71, 0x00, 0x75, 0x00, 0x79, 0x00, 0x7d, 0x00, 0x81, 0x00, 0x85,
    0x00, 0x89, 0x00, 0x8d, 0x00, 0x91, 0x00, 0x95, 0x00, 0x99, 0x00, 0x9d,
    0x00, 0xa1, 0x00, 0xa5, 0x00, 0xa9, 0x00, 0xad, 0x00, 0xb1, 0x00, 0xb5,
    0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table5_emit_[2] = {
    table4_0_emit_,
    table5_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table5_ops_[2] = {
    table5_0_ops_,
    table5_1_ops_,
};
const uint8_t HuffDecoderCommon::table6_0_emit_[2] = {0x30, 0x31};
const uint8_t HuffDecoderCommon::table6_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05};
const uint8_t HuffDecoderCommon::table6_1_emit_[2] = {0x32, 0x61};
const uint8_t HuffDecoderCommon::table6_2_emit_[2] = {0x63, 0x65};
const uint8_t HuffDecoderCommon::table6_3_emit_[2] = {0x69, 0x6f};
const uint8_t HuffDecoderCommon::table6_4_emit_[2] = {0x73, 0x74};
const uint8_t HuffDecoderCommon::table6_5_emit_[4] = {0x20, 0x25, 0x2d, 0x2e};
const uint8_t HuffDecoderCommon::table6_5_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d};
const uint8_t HuffDecoderCommon::table6_6_emit_[4] = {0x2f, 0x33, 0x34, 0x35};
const uint8_t HuffDecoderCommon::table6_7_emit_[4] = {0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table6_8_emit_[4] = {0x3d, 0x41, 0x5f, 0x62};
const uint8_t HuffDecoderCommon::table6_9_emit_[4] = {0x64, 0x66, 0x67, 0x68};
const uint8_t HuffDecoderCommon::table6_10_emit_[4] = {0x6c, 0x6d, 0x6e, 0x70};
const uint8_t HuffDecoderCommon::table6_11_emit_[6] = {0x72, 0x75, 0x3a,
                                                       0x42, 0x43, 0x44};
const uint8_t HuffDecoderCommon::table6_11_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
    0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15};
const uint8_t HuffDecoderCommon::table6_12_emit_[8] = {0x45, 0x46, 0x47, 0x48,
                                                       0x49, 0x4a, 0x4b, 0x4c};
const uint8_t HuffDecoderCommon::table6_12_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d};
const uint8_t HuffDecoderCommon::table6_13_emit_[8] = {0x4d, 0x4e, 0x4f, 0x50,
                                                       0x51, 0x52, 0x53, 0x54};
const uint8_t HuffDecoderCommon::table6_14_emit_[8] = {0x55, 0x56, 0x57, 0x59,
                                                       0x6a, 0x6b, 0x71, 0x76};
const uint8_t HuffDecoderCommon::table6_15_emit_[10] = {
    0x77, 0x78, 0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint8_t HuffDecoderCommon::table6_15_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x11, 0x00, 0x15, 0x00, 0x19,
    0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table6_emit_[16] = {
    table6_0_emit_,  table6_1_emit_,  table6_2_emit_,  table6_3_emit_,
    table6_4_emit_,  table6_5_emit_,  table6_6_emit_,  table6_7_emit_,
    table6_8_emit_,  table6_9_emit_,  table6_10_emit_, table6_11_emit_,
    table6_12_emit_, table6_13_emit_, table6_14_emit_, table6_15_emit_,
};
const uint8_t* const HuffDecoderCommon::table6_ops_[16] = {
    table6_0_ops_,  table6_0_ops_,  table6_0_ops_,  table6_0_ops_,
    table6_0_ops_,  table6_5_ops_,  table6_5_ops_,  table6_5_ops_,
    table6_5_ops_,  table6_5_ops_,  table6_5_ops_,  table6_11_ops_,
    table6_12_ops_, table6_12_ops_, table6_12_ops_, table6_15_ops_,
};
const uint8_t HuffDecoderCommon::table7_0_emit_[36] = {
    0x30, 0x30, 0x31, 0x30, 0x32, 0x30, 0x61, 0x30, 0x63, 0x30, 0x65, 0x30,
    0x69, 0x30, 0x6f, 0x30, 0x73, 0x30, 0x74, 0x31, 0x31, 0x32, 0x31, 0x61,
    0x31, 0x63, 0x31, 0x65, 0x31, 0x69, 0x31, 0x6f, 0x31, 0x73, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table7_0_ops_[64] = {
    0x00, 0x04, 0x0c, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x08,
    0x4c, 0x50, 0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0a};
const uint8_t HuffDecoderCommon::table7_1_emit_[36] = {
    0x32, 0x30, 0x32, 0x31, 0x32, 0x32, 0x61, 0x32, 0x63, 0x32, 0x65, 0x32,
    0x69, 0x32, 0x6f, 0x32, 0x73, 0x32, 0x74, 0x61, 0x30, 0x61, 0x31, 0x61,
    0x61, 0x63, 0x61, 0x65, 0x61, 0x69, 0x61, 0x6f, 0x61, 0x73, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table7_1_ops_[64] = {
    0x00, 0x08, 0x10, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x4c,
    0x54, 0x18, 0x5c, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a};
const uint8_t HuffDecoderCommon::table7_2_emit_[36] = {
    0x63, 0x30, 0x63, 0x31, 0x63, 0x32, 0x63, 0x61, 0x63, 0x63, 0x65, 0x63,
    0x69, 0x63, 0x6f, 0x63, 0x73, 0x63, 0x74, 0x65, 0x30, 0x65, 0x31, 0x65,
    0x32, 0x65, 0x61, 0x65, 0x65, 0x69, 0x65, 0x6f, 0x65, 0x73, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table7_2_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x24, 0x2c, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x4c,
    0x54, 0x5c, 0x64, 0x28, 0x6c, 0x70, 0x78, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2a};
const uint8_t HuffDecoderCommon::table7_3_emit_[36] = {
    0x69, 0x30, 0x69, 0x31, 0x69, 0x32, 0x69, 0x61, 0x69, 0x63, 0x69, 0x65,
    0x69, 0x69, 0x6f, 0x69, 0x73, 0x69, 0x74, 0x6f, 0x30, 0x6f, 0x31, 0x6f,
    0x32, 0x6f, 0x61, 0x6f, 0x63, 0x6f, 0x65, 0x6f, 0x6f, 0x73, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table7_3_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x4c,
    0x54, 0x5c, 0x64, 0x6c, 0x74, 0x38, 0x7c, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3a};
const uint8_t HuffDecoderCommon::table7_4_emit_[38] = {
    0x73, 0x30, 0x73, 0x31, 0x73, 0x32, 0x73, 0x61, 0x73, 0x63,
    0x73, 0x65, 0x73, 0x69, 0x73, 0x6f, 0x73, 0x73, 0x74, 0x30,
    0x74, 0x31, 0x74, 0x32, 0x74, 0x61, 0x74, 0x63, 0x74, 0x65,
    0x74, 0x69, 0x74, 0x6f, 0x74, 0x73, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table7_4_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x48,
    0x50, 0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x90, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4a};
const uint8_t HuffDecoderCommon::table7_5_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e};
const uint8_t HuffDecoderCommon::table7_11_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0a, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x0e, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16};
const uint8_t HuffDecoderCommon::table7_12_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x1a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1e};
const uint8_t HuffDecoderCommon::table7_15_emit_[15] = {
    0x77, 0x78, 0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b,
    0x58, 0x5a, 0x21, 0x22, 0x28, 0x29, 0x3f};
const uint8_t HuffDecoderCommon::table7_15_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01,
    0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x16, 0x01, 0x01, 0x01, 0x1a,
    0x01, 0x01, 0x01, 0x1e, 0x01, 0x01, 0x01, 0x22, 0x01, 0x01, 0x01,
    0x26, 0x2a, 0x2e, 0x32, 0x36, 0x3a, 0x01, 0x01, 0x03};
const uint8_t* const HuffDecoderCommon::table7_emit_[16] = {
    table7_0_emit_,  table7_1_emit_,  table7_2_emit_,  table7_3_emit_,
    table7_4_emit_,  table6_5_emit_,  table6_6_emit_,  table6_7_emit_,
    table6_8_emit_,  table6_9_emit_,  table6_10_emit_, table6_11_emit_,
    table6_12_emit_, table6_13_emit_, table6_14_emit_, table7_15_emit_,
};
const uint8_t* const HuffDecoderCommon::table7_ops_[16] = {
    table7_0_ops_,  table7_1_ops_,  table7_2_ops_,  table7_3_ops_,
    table7_4_ops_,  table7_5_ops_,  table7_5_ops_,  table7_5_ops_,
    table7_5_ops_,  table7_5_ops_,  table7_5_ops_,  table7_11_ops_,
    table7_12_ops_, table7_12_ops_, table7_12_ops_, table7_15_ops_,
};
const uint8_t HuffDecoderCommon::table1_0_emit_[71] = {
    0x30, 0x30, 0x31, 0x30, 0x32, 0x30, 0x61, 0x30, 0x63, 0x30, 0x65, 0x30,
    0x69, 0x30, 0x6f, 0x30, 0x73, 0x30, 0x74, 0x30, 0x20, 0x30, 0x25, 0x30,
    0x2d, 0x30, 0x2e, 0x30, 0x2f, 0x30, 0x33, 0x30, 0x34, 0x30, 0x35, 0x30,
    0x36, 0x30, 0x37, 0x30, 0x38, 0x30, 0x39, 0x30, 0x3d, 0x30, 0x41, 0x30,
    0x5f, 0x30, 0x62, 0x30, 0x64, 0x30, 0x66, 0x30, 0x67, 0x30, 0x68, 0x30,
    0x6c, 0x30, 0x6d, 0x30, 0x6e, 0x30, 0x70, 0x30, 0x72, 0x30, 0x75};
const uint16_t HuffDecoderCommon::table1_0_inner_[37] = {
    0x000a, 0x008a, 0x018a, 0x028a, 0x038a, 0x048a, 0x058a, 0x068a,
    0x078a, 0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b,
    0x0f8b, 0x108b, 0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b,
    0x178b, 0x188b, 0x198b, 0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b,
    0x1f8b, 0x208b, 0x218b, 0x228b, 0x0015};
const uint8_t HuffDecoderCommon::table1_0_outer_[64] = {
    0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
    8,  8,  9,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
    22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36};
const uint8_t HuffDecoderCommon::table1_1_emit_[71] = {
    0x31, 0x30, 0x31, 0x31, 0x32, 0x31, 0x61, 0x31, 0x63, 0x31, 0x65, 0x31,
    0x69, 0x31, 0x6f, 0x31, 0x73, 0x31, 0x74, 0x31, 0x20, 0x31, 0x25, 0x31,
    0x2d, 0x31, 0x2e, 0x31, 0x2f, 0x31, 0x33, 0x31, 0x34, 0x31, 0x35, 0x31,
    0x36, 0x31, 0x37, 0x31, 0x38, 0x31, 0x39, 0x31, 0x3d, 0x31, 0x41, 0x31,
    0x5f, 0x31, 0x62, 0x31, 0x64, 0x31, 0x66, 0x31, 0x67, 0x31, 0x68, 0x31,
    0x6c, 0x31, 0x6d, 0x31, 0x6e, 0x31, 0x70, 0x31, 0x72, 0x31, 0x75};
const uint16_t HuffDecoderCommon::table1_1_inner_[37] = {
    0x000a, 0x010a, 0x018a, 0x028a, 0x038a, 0x048a, 0x058a, 0x068a,
    0x078a, 0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b,
    0x0f8b, 0x108b, 0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b,
    0x178b, 0x188b, 0x198b, 0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b,
    0x1f8b, 0x208b, 0x218b, 0x228b, 0x0015};
const uint8_t HuffDecoderCommon::table1_2_emit_[71] = {
    0x32, 0x30, 0x32, 0x31, 0x32, 0x32, 0x61, 0x32, 0x63, 0x32, 0x65, 0x32,
    0x69, 0x32, 0x6f, 0x32, 0x73, 0x32, 0x74, 0x32, 0x20, 0x32, 0x25, 0x32,
    0x2d, 0x32, 0x2e, 0x32, 0x2f, 0x32, 0x33, 0x32, 0x34, 0x32, 0x35, 0x32,
    0x36, 0x32, 0x37, 0x32, 0x38, 0x32, 0x39, 0x32, 0x3d, 0x32, 0x41, 0x32,
    0x5f, 0x32, 0x62, 0x32, 0x64, 0x32, 0x66, 0x32, 0x67, 0x32, 0x68, 0x32,
    0x6c, 0x32, 0x6d, 0x32, 0x6e, 0x32, 0x70, 0x32, 0x72, 0x32, 0x75};
const uint16_t HuffDecoderCommon::table1_2_inner_[37] = {
    0x000a, 0x010a, 0x020a, 0x028a, 0x038a, 0x048a, 0x058a, 0x068a,
    0x078a, 0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b,
    0x0f8b, 0x108b, 0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b,
    0x178b, 0x188b, 0x198b, 0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b,
    0x1f8b, 0x208b, 0x218b, 0x228b, 0x0015};
const uint8_t HuffDecoderCommon::table1_3_emit_[71] = {
    0x61, 0x30, 0x61, 0x31, 0x61, 0x32, 0x61, 0x61, 0x63, 0x61, 0x65, 0x61,
    0x69, 0x61, 0x6f, 0x61, 0x73, 0x61, 0x74, 0x61, 0x20, 0x61, 0x25, 0x61,
    0x2d, 0x61, 0x2e, 0x61, 0x2f, 0x61, 0x33, 0x61, 0x34, 0x61, 0x35, 0x61,
    0x36, 0x61, 0x37, 0x61, 0x38, 0x61, 0x39, 0x61, 0x3d, 0x61, 0x41, 0x61,
    0x5f, 0x61, 0x62, 0x61, 0x64, 0x61, 0x66, 0x61, 0x67, 0x61, 0x68, 0x61,
    0x6c, 0x61, 0x6d, 0x61, 0x6e, 0x61, 0x70, 0x61, 0x72, 0x61, 0x75};
const uint16_t HuffDecoderCommon::table1_3_inner_[37] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x038a, 0x048a, 0x058a, 0x068a,
    0x078a, 0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b,
    0x0f8b, 0x108b, 0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b,
    0x178b, 0x188b, 0x198b, 0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b,
    0x1f8b, 0x208b, 0x218b, 0x228b, 0x0015};
const uint8_t HuffDecoderCommon::table1_4_emit_[71] = {
    0x63, 0x30, 0x63, 0x31, 0x63, 0x32, 0x63, 0x61, 0x63, 0x63, 0x65, 0x63,
    0x69, 0x63, 0x6f, 0x63, 0x73, 0x63, 0x74, 0x63, 0x20, 0x63, 0x25, 0x63,
    0x2d, 0x63, 0x2e, 0x63, 0x2f, 0x63, 0x33, 0x63, 0x34, 0x63, 0x35, 0x63,
    0x36, 0x63, 0x37, 0x63, 0x38, 0x63, 0x39, 0x63, 0x3d, 0x63, 0x41, 0x63,
    0x5f, 0x63, 0x62, 0x63, 0x64, 0x63, 0x66, 0x63, 0x67, 0x63, 0x68, 0x63,
    0x6c, 0x63, 0x6d, 0x63, 0x6e, 0x63, 0x70, 0x63, 0x72, 0x63, 0x75};
const uint16_t HuffDecoderCommon::table1_4_inner_[37] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x048a, 0x058a, 0x068a,
    0x078a, 0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b,
    0x0f8b, 0x108b, 0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b,
    0x178b, 0x188b, 0x198b, 0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b,
    0x1f8b, 0x208b, 0x218b, 0x228b, 0x0015};
const uint8_t HuffDecoderCommon::table1_5_emit_[71] = {
    0x65, 0x30, 0x65, 0x31, 0x65, 0x32, 0x65, 0x61, 0x65, 0x63, 0x65, 0x65,
    0x69, 0x65, 0x6f, 0x65, 0x73, 0x65, 0x74, 0x65, 0x20, 0x65, 0x25, 0x65,
    0x2d, 0x65, 0x2e, 0x65, 0x2f, 0x65, 0x33, 0x65, 0x34, 0x65, 0x35, 0x65,
    0x36, 0x65, 0x37, 0x65, 0x38, 0x65, 0x39, 0x65, 0x3d, 0x65, 0x41, 0x65,
    0x5f, 0x65, 0x62, 0x65, 0x64, 0x65, 0x66, 0x65, 0x67, 0x65, 0x68, 0x65,
    0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x65, 0x70, 0x65, 0x72, 0x65, 0x75};
const uint16_t HuffDecoderCommon::table1_5_inner_[37] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x050a, 0x058a, 0x068a,
    0x078a, 0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b,
    0x0f8b, 0x108b, 0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b,
    0x178b, 0x188b, 0x198b, 0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b,
    0x1f8b, 0x208b, 0x218b, 0x228b, 0x0015};
const uint8_t HuffDecoderCommon::table1_6_emit_[71] = {
    0x69, 0x30, 0x69, 0x31, 0x69, 0x32, 0x69, 0x61, 0x69, 0x63, 0x69, 0x65,
    0x69, 0x69, 0x6f, 0x69, 0x73, 0x69, 0x74, 0x69, 0x20, 0x69, 0x25, 0x69,
    0x2d, 0x69, 0x2e, 0x69, 0x2f, 0x69, 0x33, 0x69, 0x34, 0x69, 0x35, 0x69,
    0x36, 0x69, 0x37, 0x69, 0x38, 0x69, 0x39, 0x69, 0x3d, 0x69, 0x41, 0x69,
    0x5f, 0x69, 0x62, 0x69, 0x64, 0x69, 0x66, 0x69, 0x67, 0x69, 0x68, 0x69,
    0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x69, 0x70, 0x69, 0x72, 0x69, 0x75};
const uint16_t HuffDecoderCommon::table1_6_inner_[37] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x050a, 0x060a, 0x068a,
    0x078a, 0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b,
    0x0f8b, 0x108b, 0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b,
    0x178b, 0x188b, 0x198b, 0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b,
    0x1f8b, 0x208b, 0x218b, 0x228b, 0x0015};
const uint8_t HuffDecoderCommon::table1_7_emit_[71] = {
    0x6f, 0x30, 0x6f, 0x31, 0x6f, 0x32, 0x6f, 0x61, 0x6f, 0x63, 0x6f, 0x65,
    0x6f, 0x69, 0x6f, 0x6f, 0x73, 0x6f, 0x74, 0x6f, 0x20, 0x6f, 0x25, 0x6f,
    0x2d, 0x6f, 0x2e, 0x6f, 0x2f, 0x6f, 0x33, 0x6f, 0x34, 0x6f, 0x35, 0x6f,
    0x36, 0x6f, 0x37, 0x6f, 0x38, 0x6f, 0x39, 0x6f, 0x3d, 0x6f, 0x41, 0x6f,
    0x5f, 0x6f, 0x62, 0x6f, 0x64, 0x6f, 0x66, 0x6f, 0x67, 0x6f, 0x68, 0x6f,
    0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x6f, 0x70, 0x6f, 0x72, 0x6f, 0x75};
const uint16_t HuffDecoderCommon::table1_7_inner_[37] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x050a, 0x060a, 0x070a,
    0x078a, 0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b,
    0x0f8b, 0x108b, 0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b,
    0x178b, 0x188b, 0x198b, 0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b,
    0x1f8b, 0x208b, 0x218b, 0x228b, 0x0015};
const uint8_t HuffDecoderCommon::table1_8_emit_[71] = {
    0x73, 0x30, 0x73, 0x31, 0x73, 0x32, 0x73, 0x61, 0x73, 0x63, 0x73, 0x65,
    0x73, 0x69, 0x73, 0x6f, 0x73, 0x73, 0x74, 0x73, 0x20, 0x73, 0x25, 0x73,
    0x2d, 0x73, 0x2e, 0x73, 0x2f, 0x73, 0x33, 0x73, 0x34, 0x73, 0x35, 0x73,
    0x36, 0x73, 0x37, 0x73, 0x38, 0x73, 0x39, 0x73, 0x3d, 0x73, 0x41, 0x73,
    0x5f, 0x73, 0x62, 0x73, 0x64, 0x73, 0x66, 0x73, 0x67, 0x73, 0x68, 0x73,
    0x6c, 0x73, 0x6d, 0x73, 0x6e, 0x73, 0x70, 0x73, 0x72, 0x73, 0x75};
const uint16_t HuffDecoderCommon::table1_8_inner_[37] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x050a, 0x060a, 0x070a,
    0x080a, 0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b,
    0x0f8b, 0x108b, 0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b,
    0x178b, 0x188b, 0x198b, 0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b,
    0x1f8b, 0x208b, 0x218b, 0x228b, 0x0015};
const uint8_t HuffDecoderCommon::table1_9_emit_[71] = {
    0x74, 0x30, 0x74, 0x31, 0x74, 0x32, 0x74, 0x61, 0x74, 0x63, 0x74, 0x65,
    0x74, 0x69, 0x74, 0x6f, 0x74, 0x73, 0x74, 0x74, 0x20, 0x74, 0x25, 0x74,
    0x2d, 0x74, 0x2e, 0x74, 0x2f, 0x74, 0x33, 0x74, 0x34, 0x74, 0x35, 0x74,
    0x36, 0x74, 0x37, 0x74, 0x38, 0x74, 0x39, 0x74, 0x3d, 0x74, 0x41, 0x74,
    0x5f, 0x74, 0x62, 0x74, 0x64, 0x74, 0x66, 0x74, 0x67, 0x74, 0x68, 0x74,
    0x6c, 0x74, 0x6d, 0x74, 0x6e, 0x74, 0x70, 0x74, 0x72, 0x74, 0x75};
const uint16_t HuffDecoderCommon::table1_9_inner_[37] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x050a, 0x060a, 0x070a,
    0x080a, 0x090a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b,
    0x0f8b, 0x108b, 0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b,
    0x178b, 0x188b, 0x198b, 0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b,
    0x1f8b, 0x208b, 0x218b, 0x228b, 0x0015};
const uint8_t HuffDecoderCommon::table1_10_emit_[40] = {
    0x20, 0x30, 0x20, 0x31, 0x20, 0x32, 0x20, 0x61, 0x20, 0x63,
    0x20, 0x65, 0x20, 0x69, 0x20, 0x6f, 0x20, 0x73, 0x20, 0x74,
    0x25, 0x30, 0x25, 0x31, 0x25, 0x32, 0x25, 0x61, 0x25, 0x63,
    0x25, 0x65, 0x25, 0x69, 0x25, 0x6f, 0x25, 0x73, 0x25, 0x74};
const uint16_t HuffDecoderCommon::table1_10_inner_[22] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b,
    0x080b, 0x090b, 0x0016, 0x0a0b, 0x0b0b, 0x0c0b, 0x0d0b, 0x0e0b,
    0x0f0b, 0x100b, 0x110b, 0x120b, 0x130b, 0x0a16};
const uint8_t HuffDecoderCommon::table1_10_outer_[64] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 21, 21, 21, 21, 21,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21};
const uint8_t HuffDecoderCommon::table1_11_emit_[40] = {
    0x2d, 0x30, 0x2d, 0x31, 0x2d, 0x32, 0x2d, 0x61, 0x2d, 0x63,
    0x2d, 0x65, 0x2d, 0x69, 0x2d, 0x6f, 0x2d, 0x73, 0x2d, 0x74,
    0x2e, 0x30, 0x2e, 0x31, 0x2e, 0x32, 0x2e, 0x61, 0x2e, 0x63,
    0x2e, 0x65, 0x2e, 0x69, 0x2e, 0x6f, 0x2e, 0x73, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table1_12_emit_[40] = {
    0x2f, 0x30, 0x2f, 0x31, 0x2f, 0x32, 0x2f, 0x61, 0x2f, 0x63,
    0x2f, 0x65, 0x2f, 0x69, 0x2f, 0x6f, 0x2f, 0x73, 0x2f, 0x74,
    0x33, 0x30, 0x33, 0x31, 0x33, 0x32, 0x33, 0x61, 0x33, 0x63,
    0x33, 0x65, 0x33, 0x69, 0x33, 0x6f, 0x33, 0x73, 0x33, 0x74};
const uint8_t HuffDecoderCommon::table1_13_emit_[40] = {
    0x34, 0x30, 0x34, 0x31, 0x34, 0x32, 0x34, 0x61, 0x34, 0x63,
    0x34, 0x65, 0x34, 0x69, 0x34, 0x6f, 0x34, 0x73, 0x34, 0x74,
    0x35, 0x30, 0x35, 0x31, 0x35, 0x32, 0x35, 0x61, 0x35, 0x63,
    0x35, 0x65, 0x35, 0x69, 0x35, 0x6f, 0x35, 0x73, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table1_14_emit_[40] = {
    0x36, 0x30, 0x36, 0x31, 0x36, 0x32, 0x36, 0x61, 0x36, 0x63,
    0x36, 0x65, 0x36, 0x69, 0x36, 0x6f, 0x36, 0x73, 0x36, 0x74,
    0x37, 0x30, 0x37, 0x31, 0x37, 0x32, 0x37, 0x61, 0x37, 0x63,
    0x37, 0x65, 0x37, 0x69, 0x37, 0x6f, 0x37, 0x73, 0x37, 0x74};
const uint8_t HuffDecoderCommon::table1_15_emit_[40] = {
    0x38, 0x30, 0x38, 0x31, 0x38, 0x32, 0x38, 0x61, 0x38, 0x63,
    0x38, 0x65, 0x38, 0x69, 0x38, 0x6f, 0x38, 0x73, 0x38, 0x74,
    0x39, 0x30, 0x39, 0x31, 0x39, 0x32, 0x39, 0x61, 0x39, 0x63,
    0x39, 0x65, 0x39, 0x69, 0x39, 0x6f, 0x39, 0x73, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table1_16_emit_[40] = {
    0x3d, 0x30, 0x3d, 0x31, 0x3d, 0x32, 0x3d, 0x61, 0x3d, 0x63,
    0x3d, 0x65, 0x3d, 0x69, 0x3d, 0x6f, 0x3d, 0x73, 0x3d, 0x74,
    0x41, 0x30, 0x41, 0x31, 0x41, 0x32, 0x41, 0x61, 0x41, 0x63,
    0x41, 0x65, 0x41, 0x69, 0x41, 0x6f, 0x41, 0x73, 0x41, 0x74};
const uint8_t HuffDecoderCommon::table1_17_emit_[40] = {
    0x5f, 0x30, 0x5f, 0x31, 0x5f, 0x32, 0x5f, 0x61, 0x5f, 0x63,
    0x5f, 0x65, 0x5f, 0x69, 0x5f, 0x6f, 0x5f, 0x73, 0x5f, 0x74,
    0x62, 0x30, 0x62, 0x31, 0x62, 0x32, 0x62, 0x61, 0x62, 0x63,
    0x62, 0x65, 0x62, 0x69, 0x62, 0x6f, 0x62, 0x73, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table1_18_emit_[40] = {
    0x64, 0x30, 0x64, 0x31, 0x64, 0x32, 0x64, 0x61, 0x64, 0x63,
    0x64, 0x65, 0x64, 0x69, 0x64, 0x6f, 0x64, 0x73, 0x64, 0x74,
    0x66, 0x30, 0x66, 0x31, 0x66, 0x32, 0x66, 0x61, 0x66, 0x63,
    0x66, 0x65, 0x66, 0x69, 0x66, 0x6f, 0x66, 0x73, 0x66, 0x74};
const uint8_t HuffDecoderCommon::table1_19_emit_[40] = {
    0x67, 0x30, 0x67, 0x31, 0x67, 0x32, 0x67, 0x61, 0x67, 0x63,
    0x67, 0x65, 0x67, 0x69, 0x67, 0x6f, 0x67, 0x73, 0x67, 0x74,
    0x68, 0x30, 0x68, 0x31, 0x68, 0x32, 0x68, 0x61, 0x68, 0x63,
    0x68, 0x65, 0x68, 0x69, 0x68, 0x6f, 0x68, 0x73, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table1_20_emit_[40] = {
    0x6c, 0x30, 0x6c, 0x31, 0x6c, 0x32, 0x6c, 0x61, 0x6c, 0x63,
    0x6c, 0x65, 0x6c, 0x69, 0x6c, 0x6f, 0x6c, 0x73, 0x6c, 0x74,
    0x6d, 0x30, 0x6d, 0x31, 0x6d, 0x32, 0x6d, 0x61, 0x6d, 0x63,
    0x6d, 0x65, 0x6d, 0x69, 0x6d, 0x6f, 0x6d, 0x73, 0x6d, 0x74};
const uint8_t HuffDecoderCommon::table1_21_emit_[40] = {
    0x6e, 0x30, 0x6e, 0x31, 0x6e, 0x32, 0x6e, 0x61, 0x6e, 0x63,
    0x6e, 0x65, 0x6e, 0x69, 0x6e, 0x6f, 0x6e, 0x73, 0x6e, 0x74,
    0x70, 0x30, 0x70, 0x31, 0x70, 0x32, 0x70, 0x61, 0x70, 0x63,
    0x70, 0x65, 0x70, 0x69, 0x70, 0x6f, 0x70, 0x73, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table1_22_emit_[40] = {
    0x72, 0x30, 0x72, 0x31, 0x72, 0x32, 0x72, 0x61, 0x72, 0x63,
    0x72, 0x65, 0x72, 0x69, 0x72, 0x6f, 0x72, 0x73, 0x72, 0x74,
    0x75, 0x30, 0x75, 0x31, 0x75, 0x32, 0x75, 0x61, 0x75, 0x63,
    0x75, 0x65, 0x75, 0x69, 0x75, 0x6f, 0x75, 0x73, 0x75, 0x74};
const uint8_t HuffDecoderCommon::table1_23_emit_[4] = {0x3a, 0x42, 0x43, 0x44};
const uint16_t HuffDecoderCommon::table1_23_inner_[4] = {0x0017, 0x0097, 0x0117,
                                                         0x0197};
const uint8_t HuffDecoderCommon::table1_23_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
const uint8_t HuffDecoderCommon::table1_24_emit_[4] = {0x45, 0x46, 0x47, 0x48};
const uint8_t HuffDecoderCommon::table1_25_emit_[4] = {0x49, 0x4a, 0x4b, 0x4c};
const uint8_t HuffDecoderCommon::table1_26_emit_[4] = {0x4d, 0x4e, 0x4f, 0x50};
const uint8_t HuffDecoderCommon::table1_27_emit_[4] = {0x51, 0x52, 0x53, 0x54};
const uint8_t HuffDecoderCommon::table1_28_emit_[4] = {0x55, 0x56, 0x57, 0x59};
const uint8_t HuffDecoderCommon::table1_29_emit_[4] = {0x6a, 0x6b, 0x71, 0x76};
const uint8_t HuffDecoderCommon::table1_30_emit_[4] = {0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table1_31_emit_[14] = {
    0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a, 0x21,
    0x22, 0x28, 0x29, 0x3f, 0x27, 0x2b, 0x7c};
const uint16_t HuffDecoderCommon::table1_31_inner_[17] = {
    0x0018, 0x0098, 0x0118, 0x0198, 0x0218, 0x0298, 0x031a, 0x039a, 0x041a,
    0x049a, 0x051a, 0x059b, 0x061b, 0x069b, 0x002b, 0x003b, 0x004b};
const uint8_t HuffDecoderCommon::table1_31_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,  1,  1,  1,  2,  2,  2,  2, 2, 2,
    2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4,  4,  4,  4,  4,  4,  5,  5, 5, 5,
    5, 5, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 13, 14, 15, 16};
const uint8_t* const HuffDecoderCommon::table1_emit_[32] = {
    table1_0_emit_,  table1_1_emit_,  table1_2_emit_,  table1_3_emit_,
    table1_4_emit_,  table1_5_emit_,  table1_6_emit_,  table1_7_emit_,
    table1_8_emit_,  table1_9_emit_,  table1_10_emit_, table1_11_emit_,
    table1_12_emit_, table1_13_emit_, table1_14_emit_, table1_15_emit_,
    table1_16_emit_, table1_17_emit_, table1_18_emit_, table1_19_emit_,
    table1_20_emit_, table1_21_emit_, table1_22_emit_, table1_23_emit_,
    table1_24_emit_, table1_25_emit_, table1_26_emit_, table1_27_emit_,
    table1_28_emit_, table1_29_emit_, table1_30_emit_, table1_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table1_inner_[32] = {
    table1_0_inner_,  table1_1_inner_,  table1_2_inner_,  table1_3_inner_,
    table1_4_inner_,  table1_5_inner_,  table1_6_inner_,  table1_7_inner_,
    table1_8_inner_,  table1_9_inner_,  table1_10_inner_, table1_10_inner_,
    table1_10_inner_, table1_10_inner_, table1_10_inner_, table1_10_inner_,
    table1_10_inner_, table1_10_inner_, table1_10_inner_, table1_10_inner_,
    table1_10_inner_, table1_10_inner_, table1_10_inner_, table1_23_inner_,
    table1_23_inner_, table1_23_inner_, table1_23_inner_, table1_23_inner_,
    table1_23_inner_, table1_23_inner_, table1_23_inner_, table1_31_inner_,
};
const uint8_t* const HuffDecoderCommon::table1_outer_[32] = {
    table1_0_outer_,  table1_0_outer_,  table1_0_outer_,  table1_0_outer_,
    table1_0_outer_,  table1_0_outer_,  table1_0_outer_,  table1_0_outer_,
    table1_0_outer_,  table1_0_outer_,  table1_10_outer_, table1_10_outer_,
    table1_10_outer_, table1_10_outer_, table1_10_outer_, table1_10_outer_,
    table1_10_outer_, table1_10_outer_, table1_10_outer_, table1_10_outer_,
    table1_10_outer_, table1_10_outer_, table1_10_outer_, table1_23_outer_,
    table1_23_outer_, table1_23_outer_, table1_23_outer_, table1_23_outer_,
    table1_23_outer_, table1_23_outer_, table1_23_outer_, table1_31_outer_,
};
const uint8_t HuffDecoderCommon::table12_0_inner_[6] = {0x00, 0x01, 0x05,
                                                        0x09, 0x0d, 0x02};
const uint8_t HuffDecoderCommon::table12_0_outer_[8] = {0, 1, 0, 2, 3, 4, 0, 5};
const uint8_t HuffDecoderCommon::table13_0_emit_[7] = {0x5d, 0x7e, 0x5e, 0x7d,
                                                       0x3c, 0x60, 0x7b};
const uint8_t HuffDecoderCommon::table13_0_inner_[9] = {
    0x00, 0x01, 0x05, 0x09, 0x0d, 0x11, 0x15, 0x19, 0x02};
const uint8_t HuffDecoderCommon::table13_0_outer_[16] = {
    0, 0, 0, 1, 0, 0, 0, 2, 0, 3, 0, 4, 5, 6, 7, 8};
const uint8_t HuffDecoderCommon::table14_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
    0x00, 0x0d, 0x00, 0x11, 0x00, 0x15, 0x00, 0x19, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table15_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
    0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table16_0_emit_[45] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63, 0x5d, 0x65,
    0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74, 0x7e, 0x30, 0x7e, 0x31,
    0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63, 0x7e, 0x65, 0x7e, 0x69, 0x7e, 0x6f,
    0x7e, 0x73, 0x7e, 0x74, 0x5e, 0x7d, 0x3c, 0x60, 0x7b};
const uint8_t HuffDecoderCommon::table16_0_ops_[128] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x50, 0x58, 0x60, 0x68,
    0x70, 0x78, 0x80, 0x88, 0x90, 0x98, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x52, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xa2, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xa6,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xaa, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0xae, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xb2,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03};
const uint8_t HuffDecoderCommon::table17_0_emit_[72] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63, 0x5d, 0x65,
    0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74, 0x5d, 0x20, 0x5d, 0x25,
    0x5d, 0x2d, 0x5d, 0x2e, 0x5d, 0x2f, 0x5d, 0x33, 0x5d, 0x34, 0x5d, 0x35,
    0x5d, 0x36, 0x5d, 0x37, 0x5d, 0x38, 0x5d, 0x39, 0x5d, 0x3d, 0x5d, 0x41,
    0x5d, 0x5f, 0x5d, 0x62, 0x5d, 0x64, 0x5d, 0x66, 0x5d, 0x67, 0x5d, 0x68,
    0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70, 0x5d, 0x72, 0x5d, 0x75};
const uint16_t HuffDecoderCommon::table17_0_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9,
    0x00b1, 0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9,
    0x00f1, 0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table17_1_emit_[72] = {
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63, 0x7e, 0x65,
    0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74, 0x7e, 0x20, 0x7e, 0x25,
    0x7e, 0x2d, 0x7e, 0x2e, 0x7e, 0x2f, 0x7e, 0x33, 0x7e, 0x34, 0x7e, 0x35,
    0x7e, 0x36, 0x7e, 0x37, 0x7e, 0x38, 0x7e, 0x39, 0x7e, 0x3d, 0x7e, 0x41,
    0x7e, 0x5f, 0x7e, 0x62, 0x7e, 0x64, 0x7e, 0x66, 0x7e, 0x67, 0x7e, 0x68,
    0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70, 0x7e, 0x72, 0x7e, 0x75};
const uint8_t HuffDecoderCommon::table17_2_emit_[40] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61, 0x5e, 0x63,
    0x5e, 0x65, 0x5e, 0x69, 0x5e, 0x6f, 0x5e, 0x73, 0x5e, 0x74,
    0x7d, 0x30, 0x7d, 0x31, 0x7d, 0x32, 0x7d, 0x61, 0x7d, 0x63,
    0x7d, 0x65, 0x7d, 0x69, 0x7d, 0x6f, 0x7d, 0x73, 0x7d, 0x74};
const uint16_t HuffDecoderCommon::table17_2_ops_[64] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0051, 0x0059, 0x0061, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052};
const uint8_t HuffDecoderCommon::table17_3_emit_[6] = {0x3c, 0x60, 0x7b,
                                                       0x5c, 0xc3, 0xd0};
const uint16_t HuffDecoderCommon::table17_3_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x000e, 0x0012, 0x0016, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table17_emit_[4] = {
    table17_0_emit_,
    table17_1_emit_,
    table17_2_emit_,
    table17_3_emit_,
};
const uint16_t* const HuffDecoderCommon::table17_ops_[4] = {
    table17_0_ops_,
    table17_0_ops_,
    table17_2_ops_,
    table17_3_ops_,
};
const uint8_t HuffDecoderCommon::table18_0_emit_[44] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63, 0x5d,
    0x65, 0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74, 0x5d, 0x20,
    0x5d, 0x25, 0x5d, 0x2d, 0x5d, 0x2e, 0x5d, 0x2f, 0x5d, 0x33, 0x5d,
    0x34, 0x5d, 0x35, 0x5d, 0x36, 0x5d, 0x37, 0x5d, 0x38, 0x5d, 0x39};
const uint16_t HuffDecoderCommon::table18_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0051, 0x0000, 0x0059, 0x0000, 0x0061, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089,
    0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000, 0x00a9};
const uint8_t HuffDecoderCommon::table18_1_emit_[92] = {
    0x5d, 0x3d, 0x5d, 0x41, 0x5d, 0x5f, 0x5d, 0x62, 0x5d, 0x64, 0x5d, 0x66,
    0x5d, 0x67, 0x5d, 0x68, 0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70,
    0x5d, 0x72, 0x5d, 0x75, 0x5d, 0x3a, 0x5d, 0x42, 0x5d, 0x43, 0x5d, 0x44,
    0x5d, 0x45, 0x5d, 0x46, 0x5d, 0x47, 0x5d, 0x48, 0x5d, 0x49, 0x5d, 0x4a,
    0x5d, 0x4b, 0x5d, 0x4c, 0x5d, 0x4d, 0x5d, 0x4e, 0x5d, 0x4f, 0x5d, 0x50,
    0x5d, 0x51, 0x5d, 0x52, 0x5d, 0x53, 0x5d, 0x54, 0x5d, 0x55, 0x5d, 0x56,
    0x5d, 0x57, 0x5d, 0x59, 0x5d, 0x6a, 0x5d, 0x6b, 0x5d, 0x71, 0x5d, 0x76,
    0x5d, 0x77, 0x5d, 0x78, 0x5d, 0x79, 0x5d, 0x7a};
const uint16_t HuffDecoderCommon::table18_1_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9,
    0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109,
    0x0111, 0x0119, 0x0121, 0x0129, 0x0131, 0x0139, 0x0141, 0x0149,
    0x0151, 0x0159, 0x0161, 0x0169, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table18_2_emit_[44] = {
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63, 0x7e,
    0x65, 0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74, 0x7e, 0x20,
    0x7e, 0x25, 0x7e, 0x2d, 0x7e, 0x2e, 0x7e, 0x2f, 0x7e, 0x33, 0x7e,
    0x34, 0x7e, 0x35, 0x7e, 0x36, 0x7e, 0x37, 0x7e, 0x38, 0x7e, 0x39};
const uint8_t HuffDecoderCommon::table18_3_emit_[92] = {
    0x7e, 0x3d, 0x7e, 0x41, 0x7e, 0x5f, 0x7e, 0x62, 0x7e, 0x64, 0x7e, 0x66,
    0x7e, 0x67, 0x7e, 0x68, 0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70,
    0x7e, 0x72, 0x7e, 0x75, 0x7e, 0x3a, 0x7e, 0x42, 0x7e, 0x43, 0x7e, 0x44,
    0x7e, 0x45, 0x7e, 0x46, 0x7e, 0x47, 0x7e, 0x48, 0x7e, 0x49, 0x7e, 0x4a,
    0x7e, 0x4b, 0x7e, 0x4c, 0x7e, 0x4d, 0x7e, 0x4e, 0x7e, 0x4f, 0x7e, 0x50,
    0x7e, 0x51, 0x7e, 0x52, 0x7e, 0x53, 0x7e, 0x54, 0x7e, 0x55, 0x7e, 0x56,
    0x7e, 0x57, 0x7e, 0x59, 0x7e, 0x6a, 0x7e, 0x6b, 0x7e, 0x71, 0x7e, 0x76,
    0x7e, 0x77, 0x7e, 0x78, 0x7e, 0x79, 0x7e, 0x7a};
const uint8_t HuffDecoderCommon::table18_4_emit_[72] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61, 0x5e, 0x63, 0x5e, 0x65,
    0x5e, 0x69, 0x5e, 0x6f, 0x5e, 0x73, 0x5e, 0x74, 0x5e, 0x20, 0x5e, 0x25,
    0x5e, 0x2d, 0x5e, 0x2e, 0x5e, 0x2f, 0x5e, 0x33, 0x5e, 0x34, 0x5e, 0x35,
    0x5e, 0x36, 0x5e, 0x37, 0x5e, 0x38, 0x5e, 0x39, 0x5e, 0x3d, 0x5e, 0x41,
    0x5e, 0x5f, 0x5e, 0x62, 0x5e, 0x64, 0x5e, 0x66, 0x5e, 0x67, 0x5e, 0x68,
    0x5e, 0x6c, 0x5e, 0x6d, 0x5e, 0x6e, 0x5e, 0x70, 0x5e, 0x72, 0x5e, 0x75};
const uint8_t HuffDecoderCommon::table18_5_emit_[72] = {
    0x7d, 0x30, 0x7d, 0x31, 0x7d, 0x32, 0x7d, 0x61, 0x7d, 0x63, 0x7d, 0x65,
    0x7d, 0x69, 0x7d, 0x6f, 0x7d, 0x73, 0x7d, 0x74, 0x7d, 0x20, 0x7d, 0x25,
    0x7d, 0x2d, 0x7d, 0x2e, 0x7d, 0x2f, 0x7d, 0x33, 0x7d, 0x34, 0x7d, 0x35,
    0x7d, 0x36, 0x7d, 0x37, 0x7d, 0x38, 0x7d, 0x39, 0x7d, 0x3d, 0x7d, 0x41,
    0x7d, 0x5f, 0x7d, 0x62, 0x7d, 0x64, 0x7d, 0x66, 0x7d, 0x67, 0x7d, 0x68,
    0x7d, 0x6c, 0x7d, 0x6d, 0x7d, 0x6e, 0x7d, 0x70, 0x7d, 0x72, 0x7d, 0x75};
const uint8_t HuffDecoderCommon::table18_6_emit_[40] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63,
    0x3c, 0x65, 0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74,
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63,
    0x60, 0x65, 0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74};
const uint8_t HuffDecoderCommon::table18_7_emit_[31] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b,
    0x65, 0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x5c, 0xc3,
    0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2};
const uint16_t HuffDecoderCommon::table18_7_ops_[64] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0052, 0x0000, 0x0056, 0x0000, 0x005a, 0x005e, 0x0062,
    0x0066, 0x006a, 0x006e, 0x0072, 0x0076, 0x007a, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table18_emit_[8] = {
    table18_0_emit_, table18_1_emit_, table18_2_emit_, table18_3_emit_,
    table18_4_emit_, table18_5_emit_, table18_6_emit_, table18_7_emit_,
};
const uint16_t* const HuffDecoderCommon::table18_ops_[8] = {
    table18_0_ops_, table18_1_ops_, table18_0_ops_, table18_1_ops_,
    table17_0_ops_, table17_0_ops_, table17_2_ops_, table18_7_ops_,
};
const uint8_t HuffDecoderCommon::table19_0_emit_[16] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61,
    0x5d, 0x63, 0x5d, 0x65, 0x5d, 0x69, 0x5d, 0x6f};
const uint16_t HuffDecoderCommon::table19_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0031,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0039};
const uint8_t HuffDecoderCommon::table19_1_emit_[28] = {
    0x5d, 0x73, 0x5d, 0x74, 0x5d, 0x20, 0x5d, 0x25, 0x5d, 0x2d,
    0x5d, 0x2e, 0x5d, 0x2f, 0x5d, 0x33, 0x5d, 0x34, 0x5d, 0x35,
    0x5d, 0x36, 0x5d, 0x37, 0x5d, 0x38, 0x5d, 0x39};
const uint16_t HuffDecoderCommon::table19_1_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069};
const uint8_t HuffDecoderCommon::table19_2_emit_[36] = {
    0x5d, 0x3d, 0x5d, 0x41, 0x5d, 0x5f, 0x5d, 0x62, 0x5d, 0x64, 0x5d, 0x66,
    0x5d, 0x67, 0x5d, 0x68, 0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70,
    0x5d, 0x72, 0x5d, 0x75, 0x5d, 0x3a, 0x5d, 0x42, 0x5d, 0x43, 0x5d, 0x44};
const uint16_t HuffDecoderCommon::table19_2_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089};
const uint8_t HuffDecoderCommon::table19_3_emit_[68] = {
    0x5d, 0x45, 0x5d, 0x46, 0x5d, 0x47, 0x5d, 0x48, 0x5d, 0x49, 0x5d, 0x4a,
    0x5d, 0x4b, 0x5d, 0x4c, 0x5d, 0x4d, 0x5d, 0x4e, 0x5d, 0x4f, 0x5d, 0x50,
    0x5d, 0x51, 0x5d, 0x52, 0x5d, 0x53, 0x5d, 0x54, 0x5d, 0x55, 0x5d, 0x56,
    0x5d, 0x57, 0x5d, 0x59, 0x5d, 0x6a, 0x5d, 0x6b, 0x5d, 0x71, 0x5d, 0x76,
    0x5d, 0x77, 0x5d, 0x78, 0x5d, 0x79, 0x5d, 0x7a, 0x5d, 0x26, 0x5d, 0x2a,
    0x5d, 0x2c, 0x5d, 0x3b, 0x5d, 0x58, 0x5d, 0x5a};
const uint16_t HuffDecoderCommon::table19_3_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079,
    0x0000, 0x0081, 0x0000, 0x0089, 0x0000, 0x0091, 0x0000, 0x0099,
    0x0000, 0x00a1, 0x0000, 0x00a9, 0x0000, 0x00b1, 0x0000, 0x00b9,
    0x0000, 0x00c1, 0x0000, 0x00c9, 0x0000, 0x00d1, 0x0000, 0x00d9,
    0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table19_4_emit_[16] = {
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61,
    0x7e, 0x63, 0x7e, 0x65, 0x7e, 0x69, 0x7e, 0x6f};
const uint8_t HuffDecoderCommon::table19_5_emit_[28] = {
    0x7e, 0x73, 0x7e, 0x74, 0x7e, 0x20, 0x7e, 0x25, 0x7e, 0x2d,
    0x7e, 0x2e, 0x7e, 0x2f, 0x7e, 0x33, 0x7e, 0x34, 0x7e, 0x35,
    0x7e, 0x36, 0x7e, 0x37, 0x7e, 0x38, 0x7e, 0x39};
const uint8_t HuffDecoderCommon::table19_6_emit_[36] = {
    0x7e, 0x3d, 0x7e, 0x41, 0x7e, 0x5f, 0x7e, 0x62, 0x7e, 0x64, 0x7e, 0x66,
    0x7e, 0x67, 0x7e, 0x68, 0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70,
    0x7e, 0x72, 0x7e, 0x75, 0x7e, 0x3a, 0x7e, 0x42, 0x7e, 0x43, 0x7e, 0x44};
const uint8_t HuffDecoderCommon::table19_7_emit_[68] = {
    0x7e, 0x45, 0x7e, 0x46, 0x7e, 0x47, 0x7e, 0x48, 0x7e, 0x49, 0x7e, 0x4a,
    0x7e, 0x4b, 0x7e, 0x4c, 0x7e, 0x4d, 0x7e, 0x4e, 0x7e, 0x4f, 0x7e, 0x50,
    0x7e, 0x51, 0x7e, 0x52, 0x7e, 0x53, 0x7e, 0x54, 0x7e, 0x55, 0x7e, 0x56,
    0x7e, 0x57, 0x7e, 0x59, 0x7e, 0x6a, 0x7e, 0x6b, 0x7e, 0x71, 0x7e, 0x76,
    0x7e, 0x77, 0x7e, 0x78, 0x7e, 0x79, 0x7e, 0x7a, 0x7e, 0x26, 0x7e, 0x2a,
    0x7e, 0x2c, 0x7e, 0x3b, 0x7e, 0x58, 0x7e, 0x5a};
const uint8_t HuffDecoderCommon::table19_8_emit_[44] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61, 0x5e, 0x63, 0x5e,
    0x65, 0x5e, 0x69, 0x5e, 0x6f, 0x5e, 0x73, 0x5e, 0x74, 0x5e, 0x20,
    0x5e, 0x25, 0x5e, 0x2d, 0x5e, 0x2e, 0x5e, 0x2f, 0x5e, 0x33, 0x5e,
    0x34, 0x5e, 0x35, 0x5e, 0x36, 0x5e, 0x37, 0x5e, 0x38, 0x5e, 0x39};
const uint8_t HuffDecoderCommon::table19_9_emit_[92] = {
    0x5e, 0x3d, 0x5e, 0x41, 0x5e, 0x5f, 0x5e, 0x62, 0x5e, 0x64, 0x5e, 0x66,
    0x5e, 0x67, 0x5e, 0x68, 0x5e, 0x6c, 0x5e, 0x6d, 0x5e, 0x6e, 0x5e, 0x70,
    0x5e, 0x72, 0x5e, 0x75, 0x5e, 0x3a, 0x5e, 0x42, 0x5e, 0x43, 0x5e, 0x44,
    0x5e, 0x45, 0x5e, 0x46, 0x5e, 0x47, 0x5e, 0x48, 0x5e, 0x49, 0x5e, 0x4a,
    0x5e, 0x4b, 0x5e, 0x4c, 0x5e, 0x4d, 0x5e, 0x4e, 0x5e, 0x4f, 0x5e, 0x50,
    0x5e, 0x51, 0x5e, 0x52, 0x5e, 0x53, 0x5e, 0x54, 0x5e, 0x55, 0x5e, 0x56,
    0x5e, 0x57, 0x5e, 0x59, 0x5e, 0x6a, 0x5e, 0x6b, 0x5e, 0x71, 0x5e, 0x76,
    0x5e, 0x77, 0x5e, 0x78, 0x5e, 0x79, 0x5e, 0x7a};
const uint8_t HuffDecoderCommon::table19_10_emit_[44] = {
    0x7d, 0x30, 0x7d, 0x31, 0x7d, 0x32, 0x7d, 0x61, 0x7d, 0x63, 0x7d,
    0x65, 0x7d, 0x69, 0x7d, 0x6f, 0x7d, 0x73, 0x7d, 0x74, 0x7d, 0x20,
    0x7d, 0x25, 0x7d, 0x2d, 0x7d, 0x2e, 0x7d, 0x2f, 0x7d, 0x33, 0x7d,
    0x34, 0x7d, 0x35, 0x7d, 0x36, 0x7d, 0x37, 0x7d, 0x38, 0x7d, 0x39};
const uint8_t HuffDecoderCommon::table19_11_emit_[92] = {
    0x7d, 0x3d, 0x7d, 0x41, 0x7d, 0x5f, 0x7d, 0x62, 0x7d, 0x64, 0x7d, 0x66,
    0x7d, 0x67, 0x7d, 0x68, 0x7d, 0x6c, 0x7d, 0x6d, 0x7d, 0x6e, 0x7d, 0x70,
    0x7d, 0x72, 0x7d, 0x75, 0x7d, 0x3a, 0x7d, 0x42, 0x7d, 0x43, 0x7d, 0x44,
    0x7d, 0x45, 0x7d, 0x46, 0x7d, 0x47, 0x7d, 0x48, 0x7d, 0x49, 0x7d, 0x4a,
    0x7d, 0x4b, 0x7d, 0x4c, 0x7d, 0x4d, 0x7d, 0x4e, 0x7d, 0x4f, 0x7d, 0x50,
    0x7d, 0x51, 0x7d, 0x52, 0x7d, 0x53, 0x7d, 0x54, 0x7d, 0x55, 0x7d, 0x56,
    0x7d, 0x57, 0x7d, 0x59, 0x7d, 0x6a, 0x7d, 0x6b, 0x7d, 0x71, 0x7d, 0x76,
    0x7d, 0x77, 0x7d, 0x78, 0x7d, 0x79, 0x7d, 0x7a};
const uint8_t HuffDecoderCommon::table19_12_emit_[72] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63, 0x3c, 0x65,
    0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74, 0x3c, 0x20, 0x3c, 0x25,
    0x3c, 0x2d, 0x3c, 0x2e, 0x3c, 0x2f, 0x3c, 0x33, 0x3c, 0x34, 0x3c, 0x35,
    0x3c, 0x36, 0x3c, 0x37, 0x3c, 0x38, 0x3c, 0x39, 0x3c, 0x3d, 0x3c, 0x41,
    0x3c, 0x5f, 0x3c, 0x62, 0x3c, 0x64, 0x3c, 0x66, 0x3c, 0x67, 0x3c, 0x68,
    0x3c, 0x6c, 0x3c, 0x6d, 0x3c, 0x6e, 0x3c, 0x70, 0x3c, 0x72, 0x3c, 0x75};
const uint8_t HuffDecoderCommon::table19_13_emit_[72] = {
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63, 0x60, 0x65,
    0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74, 0x60, 0x20, 0x60, 0x25,
    0x60, 0x2d, 0x60, 0x2e, 0x60, 0x2f, 0x60, 0x33, 0x60, 0x34, 0x60, 0x35,
    0x60, 0x36, 0x60, 0x37, 0x60, 0x38, 0x60, 0x39, 0x60, 0x3d, 0x60, 0x41,
    0x60, 0x5f, 0x60, 0x62, 0x60, 0x64, 0x60, 0x66, 0x60, 0x67, 0x60, 0x68,
    0x60, 0x6c, 0x60, 0x6d, 0x60, 0x6e, 0x60, 0x70, 0x60, 0x72, 0x60, 0x75};
const uint8_t HuffDecoderCommon::table19_14_emit_[72] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b, 0x65,
    0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x7b, 0x20, 0x7b, 0x25,
    0x7b, 0x2d, 0x7b, 0x2e, 0x7b, 0x2f, 0x7b, 0x33, 0x7b, 0x34, 0x7b, 0x35,
    0x7b, 0x36, 0x7b, 0x37, 0x7b, 0x38, 0x7b, 0x39, 0x7b, 0x3d, 0x7b, 0x41,
    0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64, 0x7b, 0x66, 0x7b, 0x67, 0x7b, 0x68,
    0x7b, 0x6c, 0x7b, 0x6d, 0x7b, 0x6e, 0x7b, 0x70, 0x7b, 0x72, 0x7b, 0x75};
const uint8_t HuffDecoderCommon::table19_15_emit_[24] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2, 0x99,
    0xa1, 0xa7, 0xac, 0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6};
const uint16_t HuffDecoderCommon::table19_15_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x000a, 0x0000, 0x000e, 0x0000, 0x0012,
    0x0000, 0x0016, 0x0000, 0x001a, 0x0000, 0x001e, 0x0000, 0x0022,
    0x0000, 0x0026, 0x0000, 0x002a, 0x002e, 0x0032, 0x0036, 0x003a,
    0x003e, 0x0042, 0x0046, 0x004a, 0x004e, 0x0052, 0x0056, 0x005a,
    0x005e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table19_emit_[16] = {
    table19_0_emit_,  table19_1_emit_,  table19_2_emit_,  table19_3_emit_,
    table19_4_emit_,  table19_5_emit_,  table19_6_emit_,  table19_7_emit_,
    table19_8_emit_,  table19_9_emit_,  table19_10_emit_, table19_11_emit_,
    table19_12_emit_, table19_13_emit_, table19_14_emit_, table19_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table19_ops_[16] = {
    table19_0_ops_, table19_1_ops_, table19_2_ops_, table19_3_ops_,
    table19_0_ops_, table19_1_ops_, table19_2_ops_, table19_3_ops_,
    table18_0_ops_, table18_1_ops_, table18_0_ops_, table18_1_ops_,
    table17_0_ops_, table17_0_ops_, table17_0_ops_, table19_15_ops_,
};
const uint8_t HuffDecoderCommon::table20_0_emit_[8] = {0x5d, 0x30, 0x5d, 0x31,
                                                       0x5d, 0x32, 0x5d, 0x61};
const uint16_t HuffDecoderCommon::table20_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019};
const uint8_t HuffDecoderCommon::table20_1_emit_[8] = {0x5d, 0x63, 0x5d, 0x65,
                                                       0x5d, 0x69, 0x5d, 0x6f};
const uint8_t HuffDecoderCommon::table20_2_emit_[12] = {
    0x5d, 0x73, 0x5d, 0x74, 0x5d, 0x20, 0x5d, 0x25, 0x5d, 0x2d, 0x5d, 0x2e};
const uint16_t HuffDecoderCommon::table20_2_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029};
const uint8_t HuffDecoderCommon::table20_3_emit_[16] = {
    0x5d, 0x2f, 0x5d, 0x33, 0x5d, 0x34, 0x5d, 0x35,
    0x5d, 0x36, 0x5d, 0x37, 0x5d, 0x38, 0x5d, 0x39};
const uint8_t HuffDecoderCommon::table20_4_emit_[16] = {
    0x5d, 0x3d, 0x5d, 0x41, 0x5d, 0x5f, 0x5d, 0x62,
    0x5d, 0x64, 0x5d, 0x66, 0x5d, 0x67, 0x5d, 0x68};
const uint8_t HuffDecoderCommon::table20_5_emit_[20] = {
    0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70, 0x5d, 0x72,
    0x5d, 0x75, 0x5d, 0x3a, 0x5d, 0x42, 0x5d, 0x43, 0x5d, 0x44};
const uint16_t HuffDecoderCommon::table20_5_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049};
const uint8_t HuffDecoderCommon::table20_6_emit_[32] = {
    0x5d, 0x45, 0x5d, 0x46, 0x5d, 0x47, 0x5d, 0x48, 0x5d, 0x49, 0x5d,
    0x4a, 0x5d, 0x4b, 0x5d, 0x4c, 0x5d, 0x4d, 0x5d, 0x4e, 0x5d, 0x4f,
    0x5d, 0x50, 0x5d, 0x51, 0x5d, 0x52, 0x5d, 0x53, 0x5d, 0x54};
const uint16_t HuffDecoderCommon::table20_6_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069,
    0x0000, 0x0000, 0x0000, 0x0071, 0x0000, 0x0000, 0x0000, 0x0079};
const uint8_t HuffDecoderCommon::table20_7_emit_[36] = {
    0x5d, 0x55, 0x5d, 0x56, 0x5d, 0x57, 0x5d, 0x59, 0x5d, 0x6a, 0x5d, 0x6b,
    0x5d, 0x71, 0x5d, 0x76, 0x5d, 0x77, 0x5d, 0x78, 0x5d, 0x79, 0x5d, 0x7a,
    0x5d, 0x26, 0x5d, 0x2a, 0x5d, 0x2c, 0x5d, 0x3b, 0x5d, 0x58, 0x5d, 0x5a};
const uint16_t HuffDecoderCommon::table20_7_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079,
    0x0000, 0x0081, 0x0000, 0x0089, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table20_8_emit_[8] = {0x7e, 0x30, 0x7e, 0x31,
                                                       0x7e, 0x32, 0x7e, 0x61};
const uint8_t HuffDecoderCommon::table20_9_emit_[8] = {0x7e, 0x63, 0x7e, 0x65,
                                                       0x7e, 0x69, 0x7e, 0x6f};
const uint8_t HuffDecoderCommon::table20_10_emit_[12] = {
    0x7e, 0x73, 0x7e, 0x74, 0x7e, 0x20, 0x7e, 0x25, 0x7e, 0x2d, 0x7e, 0x2e};
const uint8_t HuffDecoderCommon::table20_11_emit_[16] = {
    0x7e, 0x2f, 0x7e, 0x33, 0x7e, 0x34, 0x7e, 0x35,
    0x7e, 0x36, 0x7e, 0x37, 0x7e, 0x38, 0x7e, 0x39};
const uint8_t HuffDecoderCommon::table20_12_emit_[16] = {
    0x7e, 0x3d, 0x7e, 0x41, 0x7e, 0x5f, 0x7e, 0x62,
    0x7e, 0x64, 0x7e, 0x66, 0x7e, 0x67, 0x7e, 0x68};
const uint8_t HuffDecoderCommon::table20_13_emit_[20] = {
    0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70, 0x7e, 0x72,
    0x7e, 0x75, 0x7e, 0x3a, 0x7e, 0x42, 0x7e, 0x43, 0x7e, 0x44};
const uint8_t HuffDecoderCommon::table20_14_emit_[32] = {
    0x7e, 0x45, 0x7e, 0x46, 0x7e, 0x47, 0x7e, 0x48, 0x7e, 0x49, 0x7e,
    0x4a, 0x7e, 0x4b, 0x7e, 0x4c, 0x7e, 0x4d, 0x7e, 0x4e, 0x7e, 0x4f,
    0x7e, 0x50, 0x7e, 0x51, 0x7e, 0x52, 0x7e, 0x53, 0x7e, 0x54};
const uint8_t HuffDecoderCommon::table20_15_emit_[36] = {
    0x7e, 0x55, 0x7e, 0x56, 0x7e, 0x57, 0x7e, 0x59, 0x7e, 0x6a, 0x7e, 0x6b,
    0x7e, 0x71, 0x7e, 0x76, 0x7e, 0x77, 0x7e, 0x78, 0x7e, 0x79, 0x7e, 0x7a,
    0x7e, 0x26, 0x7e, 0x2a, 0x7e, 0x2c, 0x7e, 0x3b, 0x7e, 0x58, 0x7e, 0x5a};
const uint8_t HuffDecoderCommon::table20_16_emit_[16] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61,
    0x5e, 0x63, 0x5e, 0x65, 0x5e, 0x69, 0x5e, 0x6f};
const uint8_t HuffDecoderCommon::table20_17_emit_[28] = {
    0x5e, 0x73, 0x5e, 0x74, 0x5e, 0x20, 0x5e, 0x25, 0x5e, 0x2d,
    0x5e, 0x2e, 0x5e, 0x2f, 0x5e, 0x33, 0x5e, 0x34, 0x5e, 0x35,
    0x5e, 0x36, 0x5e, 0x37, 0x5e, 0x38, 0x5e, 0x39};
const uint8_t HuffDecoderCommon::table20_18_emit_[36] = {
    0x5e, 0x3d, 0x5e, 0x41, 0x5e, 0x5f, 0x5e, 0x62, 0x5e, 0x64, 0x5e, 0x66,
    0x5e, 0x67, 0x5e, 0x68, 0x5e, 0x6c, 0x5e, 0x6d, 0x5e, 0x6e, 0x5e, 0x70,
    0x5e, 0x72, 0x5e, 0x75, 0x5e, 0x3a, 0x5e, 0x42, 0x5e, 0x43, 0x5e, 0x44};
const uint8_t HuffDecoderCommon::table20_19_emit_[68] = {
    0x5e, 0x45, 0x5e, 0x46, 0x5e, 0x47, 0x5e, 0x48, 0x5e, 0x49, 0x5e, 0x4a,
    0x5e, 0x4b, 0x5e, 0x4c, 0x5e, 0x4d, 0x5e, 0x4e, 0x5e, 0x4f, 0x5e, 0x50,
    0x5e, 0x51, 0x5e, 0x52, 0x5e, 0x53, 0x5e, 0x54, 0x5e, 0x55, 0x5e, 0x56,
    0x5e, 0x57, 0x5e, 0x59, 0x5e, 0x6a, 0x5e, 0x6b, 0x5e, 0x71, 0x5e, 0x76,
    0x5e, 0x77, 0x5e, 0x78, 0x5e, 0x79, 0x5e, 0x7a, 0x5e, 0x26, 0x5e, 0x2a,
    0x5e, 0x2c, 0x5e, 0x3b, 0x5e, 0x58, 0x5e, 0x5a};
const uint8_t HuffDecoderCommon::table20_20_emit_[16] = {
    0x7d, 0x30, 0x7d, 0x31, 0x7d, 0x32, 0x7d, 0x61,
    0x7d, 0x63, 0x7d, 0x65, 0x7d, 0x69, 0x7d, 0x6f};
const uint8_t HuffDecoderCommon::table20_21_emit_[28] = {
    0x7d, 0x73, 0x7d, 0x74, 0x7d, 0x20, 0x7d, 0x25, 0x7d, 0x2d,
    0x7d, 0x2e, 0x7d, 0x2f, 0x7d, 0x33, 0x7d, 0x34, 0x7d, 0x35,
    0x7d, 0x36, 0x7d, 0x37, 0x7d, 0x38, 0x7d, 0x39};
const uint8_t HuffDecoderCommon::table20_22_emit_[36] = {
    0x7d, 0x3d, 0x7d, 0x41, 0x7d, 0x5f, 0x7d, 0x62, 0x7d, 0x64, 0x7d, 0x66,
    0x7d, 0x67, 0x7d, 0x68, 0x7d, 0x6c, 0x7d, 0x6d, 0x7d, 0x6e, 0x7d, 0x70,
    0x7d, 0x72, 0x7d, 0x75, 0x7d, 0x3a, 0x7d, 0x42, 0x7d, 0x43, 0x7d, 0x44};
const uint8_t HuffDecoderCommon::table20_23_emit_[68] = {
    0x7d, 0x45, 0x7d, 0x46, 0x7d, 0x47, 0x7d, 0x48, 0x7d, 0x49, 0x7d, 0x4a,
    0x7d, 0x4b, 0x7d, 0x4c, 0x7d, 0x4d, 0x7d, 0x4e, 0x7d, 0x4f, 0x7d, 0x50,
    0x7d, 0x51, 0x7d, 0x52, 0x7d, 0x53, 0x7d, 0x54, 0x7d, 0x55, 0x7d, 0x56,
    0x7d, 0x57, 0x7d, 0x59, 0x7d, 0x6a, 0x7d, 0x6b, 0x7d, 0x71, 0x7d, 0x76,
    0x7d, 0x77, 0x7d, 0x78, 0x7d, 0x79, 0x7d, 0x7a, 0x7d, 0x26, 0x7d, 0x2a,
    0x7d, 0x2c, 0x7d, 0x3b, 0x7d, 0x58, 0x7d, 0x5a};
const uint8_t HuffDecoderCommon::table20_24_emit_[44] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63, 0x3c,
    0x65, 0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74, 0x3c, 0x20,
    0x3c, 0x25, 0x3c, 0x2d, 0x3c, 0x2e, 0x3c, 0x2f, 0x3c, 0x33, 0x3c,
    0x34, 0x3c, 0x35, 0x3c, 0x36, 0x3c, 0x37, 0x3c, 0x38, 0x3c, 0x39};
const uint8_t HuffDecoderCommon::table20_25_emit_[92] = {
    0x3c, 0x3d, 0x3c, 0x41, 0x3c, 0x5f, 0x3c, 0x62, 0x3c, 0x64, 0x3c, 0x66,
    0x3c, 0x67, 0x3c, 0x68, 0x3c, 0x6c, 0x3c, 0x6d, 0x3c, 0x6e, 0x3c, 0x70,
    0x3c, 0x72, 0x3c, 0x75, 0x3c, 0x3a, 0x3c, 0x42, 0x3c, 0x43, 0x3c, 0x44,
    0x3c, 0x45, 0x3c, 0x46, 0x3c, 0x47, 0x3c, 0x48, 0x3c, 0x49, 0x3c, 0x4a,
    0x3c, 0x4b, 0x3c, 0x4c, 0x3c, 0x4d, 0x3c, 0x4e, 0x3c, 0x4f, 0x3c, 0x50,
    0x3c, 0x51, 0x3c, 0x52, 0x3c, 0x53, 0x3c, 0x54, 0x3c, 0x55, 0x3c, 0x56,
    0x3c, 0x57, 0x3c, 0x59, 0x3c, 0x6a, 0x3c, 0x6b, 0x3c, 0x71, 0x3c, 0x76,
    0x3c, 0x77, 0x3c, 0x78, 0x3c, 0x79, 0x3c, 0x7a};
const uint8_t HuffDecoderCommon::table20_26_emit_[44] = {
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63, 0x60,
    0x65, 0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74, 0x60, 0x20,
    0x60, 0x25, 0x60, 0x2d, 0x60, 0x2e, 0x60, 0x2f, 0x60, 0x33, 0x60,
    0x34, 0x60, 0x35, 0x60, 0x36, 0x60, 0x37, 0x60, 0x38, 0x60, 0x39};
const uint8_t HuffDecoderCommon::table20_27_emit_[92] = {
    0x60, 0x3d, 0x60, 0x41, 0x60, 0x5f, 0x60, 0x62, 0x60, 0x64, 0x60, 0x66,
    0x60, 0x67, 0x60, 0x68, 0x60, 0x6c, 0x60, 0x6d, 0x60, 0x6e, 0x60, 0x70,
    0x60, 0x72, 0x60, 0x75, 0x60, 0x3a, 0x60, 0x42, 0x60, 0x43, 0x60, 0x44,
    0x60, 0x45, 0x60, 0x46, 0x60, 0x47, 0x60, 0x48, 0x60, 0x49, 0x60, 0x4a,
    0x60, 0x4b, 0x60, 0x4c, 0x60, 0x4d, 0x60, 0x4e, 0x60, 0x4f, 0x60, 0x50,
    0x60, 0x51, 0x60, 0x52, 0x60, 0x53, 0x60, 0x54, 0x60, 0x55, 0x60, 0x56,
    0x60, 0x57, 0x60, 0x59, 0x60, 0x6a, 0x60, 0x6b, 0x60, 0x71, 0x60, 0x76,
    0x60, 0x77, 0x60, 0x78, 0x60, 0x79, 0x60, 0x7a};
const uint8_t HuffDecoderCommon::table20_28_emit_[44] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b,
    0x65, 0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x7b, 0x20,
    0x7b, 0x25, 0x7b, 0x2d, 0x7b, 0x2e, 0x7b, 0x2f, 0x7b, 0x33, 0x7b,
    0x34, 0x7b, 0x35, 0x7b, 0x36, 0x7b, 0x37, 0x7b, 0x38, 0x7b, 0x39};
const uint8_t HuffDecoderCommon::table20_29_emit_[92] = {
    0x7b, 0x3d, 0x7b, 0x41, 0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64, 0x7b, 0x66,
    0x7b, 0x67, 0x7b, 0x68, 0x7b, 0x6c, 0x7b, 0x6d, 0x7b, 0x6e, 0x7b, 0x70,
    0x7b, 0x72, 0x7b, 0x75, 0x7b, 0x3a, 0x7b, 0x42, 0x7b, 0x43, 0x7b, 0x44,
    0x7b, 0x45, 0x7b, 0x46, 0x7b, 0x47, 0x7b, 0x48, 0x7b, 0x49, 0x7b, 0x4a,
    0x7b, 0x4b, 0x7b, 0x4c, 0x7b, 0x4d, 0x7b, 0x4e, 0x7b, 0x4f, 0x7b, 0x50,
    0x7b, 0x51, 0x7b, 0x52, 0x7b, 0x53, 0x7b, 0x54, 0x7b, 0x55, 0x7b, 0x56,
    0x7b, 0x57, 0x7b, 0x59, 0x7b, 0x6a, 0x7b, 0x6b, 0x7b, 0x71, 0x7b, 0x76,
    0x7b, 0x77, 0x7b, 0x78, 0x7b, 0x79, 0x7b, 0x7a};
const uint8_t HuffDecoderCommon::table20_30_emit_[15] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8,
    0xc2, 0xe0, 0xe2, 0x99, 0xa1, 0xa7, 0xac};
const uint16_t HuffDecoderCommon::table20_30_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0016, 0x0000, 0x0000, 0x0000, 0x001a,
    0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0026, 0x0000, 0x0000, 0x0000, 0x002a,
    0x0000, 0x002e, 0x0000, 0x0032, 0x0000, 0x0036, 0x0000, 0x003a};
const uint8_t HuffDecoderCommon::table20_31_emit_[35] = {
    0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84, 0x85,
    0x86, 0x88, 0x92, 0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa, 0xad, 0xb2,
    0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8, 0xe9};
const uint16_t HuffDecoderCommon::table20_31_ops_[64] = {
    0x0000, 0x0002, 0x0000, 0x0006, 0x0000, 0x000a, 0x0000, 0x000e,
    0x0000, 0x0012, 0x0000, 0x0016, 0x0000, 0x001a, 0x0000, 0x001e,
    0x0000, 0x0022, 0x0026, 0x002a, 0x002e, 0x0032, 0x0036, 0x003a,
    0x003e, 0x0042, 0x0046, 0x004a, 0x004e, 0x0052, 0x0056, 0x005a,
    0x005e, 0x0062, 0x0066, 0x006a, 0x006e, 0x0072, 0x0076, 0x007a,
    0x007e, 0x0082, 0x0086, 0x008a, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table20_emit_[32] = {
    table20_0_emit_,  table20_1_emit_,  table20_2_emit_,  table20_3_emit_,
    table20_4_emit_,  table20_5_emit_,  table20_6_emit_,  table20_7_emit_,
    table20_8_emit_,  table20_9_emit_,  table20_10_emit_, table20_11_emit_,
    table20_12_emit_, table20_13_emit_, table20_14_emit_, table20_15_emit_,
    table20_16_emit_, table20_17_emit_, table20_18_emit_, table20_19_emit_,
    table20_20_emit_, table20_21_emit_, table20_22_emit_, table20_23_emit_,
    table20_24_emit_, table20_25_emit_, table20_26_emit_, table20_27_emit_,
    table20_28_emit_, table20_29_emit_, table20_30_emit_, table20_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table20_ops_[32] = {
    table20_0_ops_, table20_0_ops_, table20_2_ops_,  table19_0_ops_,
    table19_0_ops_, table20_5_ops_, table20_6_ops_,  table20_7_ops_,
    table20_0_ops_, table20_0_ops_, table20_2_ops_,  table19_0_ops_,
    table19_0_ops_, table20_5_ops_, table20_6_ops_,  table20_7_ops_,
    table19_0_ops_, table19_1_ops_, table19_2_ops_,  table19_3_ops_,
    table19_0_ops_, table19_1_ops_, table19_2_ops_,  table19_3_ops_,
    table18_0_ops_, table18_1_ops_, table18_0_ops_,  table18_1_ops_,
    table18_0_ops_, table18_1_ops_, table20_30_ops_, table20_31_ops_,
};
const uint8_t HuffDecoderCommon::table21_0_emit_[60] = {
    0x5d, 0x30, 0x30, 0x5d, 0x30, 0x31, 0x5d, 0x30, 0x32, 0x5d, 0x30, 0x61,
    0x5d, 0x30, 0x63, 0x5d, 0x30, 0x65, 0x5d, 0x30, 0x69, 0x5d, 0x30, 0x6f,
    0x5d, 0x30, 0x73, 0x5d, 0x30, 0x74, 0x5d, 0x31, 0x30, 0x5d, 0x31, 0x31,
    0x5d, 0x31, 0x32, 0x5d, 0x31, 0x61, 0x5d, 0x31, 0x63, 0x5d, 0x31, 0x65,
    0x5d, 0x31, 0x69, 0x5d, 0x31, 0x6f, 0x5d, 0x31, 0x73, 0x5d, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table21_0_ops_[64] = {
    0x0000, 0x0018, 0x0030, 0x0048, 0x0060, 0x0078, 0x0090, 0x00a8,
    0x00c0, 0x00d8, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x00f0, 0x0108, 0x0120, 0x0138, 0x0150, 0x0168, 0x0180, 0x0198,
    0x01b0, 0x01c8, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x00f2};
const uint8_t HuffDecoderCommon::table21_1_emit_[60] = {
    0x5d, 0x32, 0x30, 0x5d, 0x32, 0x31, 0x5d, 0x32, 0x32, 0x5d, 0x32, 0x61,
    0x5d, 0x32, 0x63, 0x5d, 0x32, 0x65, 0x5d, 0x32, 0x69, 0x5d, 0x32, 0x6f,
    0x5d, 0x32, 0x73, 0x5d, 0x32, 0x74, 0x5d, 0x61, 0x30, 0x5d, 0x61, 0x31,
    0x5d, 0x61, 0x32, 0x5d, 0x61, 0x61, 0x5d, 0x61, 0x63, 0x5d, 0x61, 0x65,
    0x5d, 0x61, 0x69, 0x5d, 0x61, 0x6f, 0x5d, 0x61, 0x73, 0x5d, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table21_2_emit_[60] = {
    0x5d, 0x63, 0x30, 0x5d, 0x63, 0x31, 0x5d, 0x63, 0x32, 0x5d, 0x63, 0x61,
    0x5d, 0x63, 0x63, 0x5d, 0x63, 0x65, 0x5d, 0x63, 0x69, 0x5d, 0x63, 0x6f,
    0x5d, 0x63, 0x73, 0x5d, 0x63, 0x74, 0x5d, 0x65, 0x30, 0x5d, 0x65, 0x31,
    0x5d, 0x65, 0x32, 0x5d, 0x65, 0x61, 0x5d, 0x65, 0x63, 0x5d, 0x65, 0x65,
    0x5d, 0x65, 0x69, 0x5d, 0x65, 0x6f, 0x5d, 0x65, 0x73, 0x5d, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table21_3_emit_[60] = {
    0x5d, 0x69, 0x30, 0x5d, 0x69, 0x31, 0x5d, 0x69, 0x32, 0x5d, 0x69, 0x61,
    0x5d, 0x69, 0x63, 0x5d, 0x69, 0x65, 0x5d, 0x69, 0x69, 0x5d, 0x69, 0x6f,
    0x5d, 0x69, 0x73, 0x5d, 0x69, 0x74, 0x5d, 0x6f, 0x30, 0x5d, 0x6f, 0x31,
    0x5d, 0x6f, 0x32, 0x5d, 0x6f, 0x61, 0x5d, 0x6f, 0x63, 0x5d, 0x6f, 0x65,
    0x5d, 0x6f, 0x69, 0x5d, 0x6f, 0x6f, 0x5d, 0x6f, 0x73, 0x5d, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table21_4_emit_[60] = {
    0x5d, 0x73, 0x30, 0x5d, 0x73, 0x31, 0x5d, 0x73, 0x32, 0x5d, 0x73, 0x61,
    0x5d, 0x73, 0x63, 0x5d, 0x73, 0x65, 0x5d, 0x73, 0x69, 0x5d, 0x73, 0x6f,
    0x5d, 0x73, 0x73, 0x5d, 0x73, 0x74, 0x5d, 0x74, 0x30, 0x5d, 0x74, 0x31,
    0x5d, 0x74, 0x32, 0x5d, 0x74, 0x61, 0x5d, 0x74, 0x63, 0x5d, 0x74, 0x65,
    0x5d, 0x74, 0x69, 0x5d, 0x74, 0x6f, 0x5d, 0x74, 0x73, 0x5d, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table21_5_emit_[8] = {0x5d, 0x20, 0x5d, 0x25,
                                                       0x5d, 0x2d, 0x5d, 0x2e};
const uint16_t HuffDecoderCommon::table21_5_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032};
const uint8_t HuffDecoderCommon::table21_6_emit_[8] = {0x5d, 0x2f, 0x5d, 0x33,
                                                       0x5d, 0x34, 0x5d, 0x35};
const uint8_t HuffDecoderCommon::table21_7_emit_[8] = {0x5d, 0x36, 0x5d, 0x37,
                                                       0x5d, 0x38, 0x5d, 0x39};
const uint8_t HuffDecoderCommon::table21_8_emit_[8] = {0x5d, 0x3d, 0x5d, 0x41,
                                                       0x5d, 0x5f, 0x5d, 0x62};
const uint8_t HuffDecoderCommon::table21_9_emit_[8] = {0x5d, 0x64, 0x5d, 0x66,
                                                       0x5d, 0x67, 0x5d, 0x68};
const uint8_t HuffDecoderCommon::table21_10_emit_[8] = {0x5d, 0x6c, 0x5d, 0x6d,
                                                        0x5d, 0x6e, 0x5d, 0x70};
const uint8_t HuffDecoderCommon::table21_11_emit_[12] = {
    0x5d, 0x72, 0x5d, 0x75, 0x5d, 0x3a, 0x5d, 0x42, 0x5d, 0x43, 0x5d, 0x44};
const uint16_t HuffDecoderCommon::table21_11_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0042,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0052};
const uint8_t HuffDecoderCommon::table21_12_emit_[16] = {
    0x5d, 0x45, 0x5d, 0x46, 0x5d, 0x47, 0x5d, 0x48,
    0x5d, 0x49, 0x5d, 0x4a, 0x5d, 0x4b, 0x5d, 0x4c};
const uint16_t HuffDecoderCommon::table21_12_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0042,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0062,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0072};
const uint8_t HuffDecoderCommon::table21_13_emit_[16] = {
    0x5d, 0x4d, 0x5d, 0x4e, 0x5d, 0x4f, 0x5d, 0x50,
    0x5d, 0x51, 0x5d, 0x52, 0x5d, 0x53, 0x5d, 0x54};
const uint8_t HuffDecoderCommon::table21_14_emit_[16] = {
    0x5d, 0x55, 0x5d, 0x56, 0x5d, 0x57, 0x5d, 0x59,
    0x5d, 0x6a, 0x5d, 0x6b, 0x5d, 0x71, 0x5d, 0x76};
const uint8_t HuffDecoderCommon::table21_15_emit_[30] = {
    0x5d, 0x77, 0x5d, 0x78, 0x5d, 0x79, 0x5d, 0x7a, 0x5d, 0x26,
    0x5d, 0x2a, 0x5d, 0x2c, 0x5d, 0x3b, 0x5d, 0x58, 0x5d, 0x5a,
    0x5d, 0x21, 0x5d, 0x22, 0x5d, 0x28, 0x5d, 0x29, 0x5d, 0x3f};
const uint16_t HuffDecoderCommon::table21_15_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table21_16_emit_[60] = {
    0x7e, 0x30, 0x30, 0x7e, 0x30, 0x31, 0x7e, 0x30, 0x32, 0x7e, 0x30, 0x61,
    0x7e, 0x30, 0x63, 0x7e, 0x30, 0x65, 0x7e, 0x30, 0x69, 0x7e, 0x30, 0x6f,
    0x7e, 0x30, 0x73, 0x7e, 0x30, 0x74, 0x7e, 0x31, 0x30, 0x7e, 0x31, 0x31,
    0x7e, 0x31, 0x32, 0x7e, 0x31, 0x61, 0x7e, 0x31, 0x63, 0x7e, 0x31, 0x65,
    0x7e, 0x31, 0x69, 0x7e, 0x31, 0x6f, 0x7e, 0x31, 0x73, 0x7e, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table21_17_emit_[60] = {
    0x7e, 0x32, 0x30, 0x7e, 0x32, 0x31, 0x7e, 0x32, 0x32, 0x7e, 0x32, 0x61,
    0x7e, 0x32, 0x63, 0x7e, 0x32, 0x65, 0x7e, 0x32, 0x69, 0x7e, 0x32, 0x6f,
    0x7e, 0x32, 0x73, 0x7e, 0x32, 0x74, 0x7e, 0x61, 0x30, 0x7e, 0x61, 0x31,
    0x7e, 0x61, 0x32, 0x7e, 0x61, 0x61, 0x7e, 0x61, 0x63, 0x7e, 0x61, 0x65,
    0x7e, 0x61, 0x69, 0x7e, 0x61, 0x6f, 0x7e, 0x61, 0x73, 0x7e, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table21_18_emit_[60] = {
    0x7e, 0x63, 0x30, 0x7e, 0x63, 0x31, 0x7e, 0x63, 0x32, 0x7e, 0x63, 0x61,
    0x7e, 0x63, 0x63, 0x7e, 0x63, 0x65, 0x7e, 0x63, 0x69, 0x7e, 0x63, 0x6f,
    0x7e, 0x63, 0x73, 0x7e, 0x63, 0x74, 0x7e, 0x65, 0x30, 0x7e, 0x65, 0x31,
    0x7e, 0x65, 0x32, 0x7e, 0x65, 0x61, 0x7e, 0x65, 0x63, 0x7e, 0x65, 0x65,
    0x7e, 0x65, 0x69, 0x7e, 0x65, 0x6f, 0x7e, 0x65, 0x73, 0x7e, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table21_19_emit_[60] = {
    0x7e, 0x69, 0x30, 0x7e, 0x69, 0x31, 0x7e, 0x69, 0x32, 0x7e, 0x69, 0x61,
    0x7e, 0x69, 0x63, 0x7e, 0x69, 0x65, 0x7e, 0x69, 0x69, 0x7e, 0x69, 0x6f,
    0x7e, 0x69, 0x73, 0x7e, 0x69, 0x74, 0x7e, 0x6f, 0x30, 0x7e, 0x6f, 0x31,
    0x7e, 0x6f, 0x32, 0x7e, 0x6f, 0x61, 0x7e, 0x6f, 0x63, 0x7e, 0x6f, 0x65,
    0x7e, 0x6f, 0x69, 0x7e, 0x6f, 0x6f, 0x7e, 0x6f, 0x73, 0x7e, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table21_20_emit_[60] = {
    0x7e, 0x73, 0x30, 0x7e, 0x73, 0x31, 0x7e, 0x73, 0x32, 0x7e, 0x73, 0x61,
    0x7e, 0x73, 0x63, 0x7e, 0x73, 0x65, 0x7e, 0x73, 0x69, 0x7e, 0x73, 0x6f,
    0x7e, 0x73, 0x73, 0x7e, 0x73, 0x74, 0x7e, 0x74, 0x30, 0x7e, 0x74, 0x31,
    0x7e, 0x74, 0x32, 0x7e, 0x74, 0x61, 0x7e, 0x74, 0x63, 0x7e, 0x74, 0x65,
    0x7e, 0x74, 0x69, 0x7e, 0x74, 0x6f, 0x7e, 0x74, 0x73, 0x7e, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table21_21_emit_[8] = {0x7e, 0x20, 0x7e, 0x25,
                                                        0x7e, 0x2d, 0x7e, 0x2e};
const uint8_t HuffDecoderCommon::table21_22_emit_[8] = {0x7e, 0x2f, 0x7e, 0x33,
                                                        0x7e, 0x34, 0x7e, 0x35};
const uint8_t HuffDecoderCommon::table21_23_emit_[8] = {0x7e, 0x36, 0x7e, 0x37,
                                                        0x7e, 0x38, 0x7e, 0x39};
const uint8_t HuffDecoderCommon::table21_24_emit_[8] = {0x7e, 0x3d, 0x7e, 0x41,
                                                        0x7e, 0x5f, 0x7e, 0x62};
const uint8_t HuffDecoderCommon::table21_25_emit_[8] = {0x7e, 0x64, 0x7e, 0x66,
                                                        0x7e, 0x67, 0x7e, 0x68};
const uint8_t HuffDecoderCommon::table21_26_emit_[8] = {0x7e, 0x6c, 0x7e, 0x6d,
                                                        0x7e, 0x6e, 0x7e, 0x70};
const uint8_t HuffDecoderCommon::table21_27_emit_[12] = {
    0x7e, 0x72, 0x7e, 0x75, 0x7e, 0x3a, 0x7e, 0x42, 0x7e, 0x43, 0x7e, 0x44};
const uint8_t HuffDecoderCommon::table21_28_emit_[16] = {
    0x7e, 0x45, 0x7e, 0x46, 0x7e, 0x47, 0x7e, 0x48,
    0x7e, 0x49, 0x7e, 0x4a, 0x7e, 0x4b, 0x7e, 0x4c};
const uint8_t HuffDecoderCommon::table21_29_emit_[16] = {
    0x7e, 0x4d, 0x7e, 0x4e, 0x7e, 0x4f, 0x7e, 0x50,
    0x7e, 0x51, 0x7e, 0x52, 0x7e, 0x53, 0x7e, 0x54};
const uint8_t HuffDecoderCommon::table21_30_emit_[16] = {
    0x7e, 0x55, 0x7e, 0x56, 0x7e, 0x57, 0x7e, 0x59,
    0x7e, 0x6a, 0x7e, 0x6b, 0x7e, 0x71, 0x7e, 0x76};
const uint8_t HuffDecoderCommon::table21_31_emit_[30] = {
    0x7e, 0x77, 0x7e, 0x78, 0x7e, 0x79, 0x7e, 0x7a, 0x7e, 0x26,
    0x7e, 0x2a, 0x7e, 0x2c, 0x7e, 0x3b, 0x7e, 0x58, 0x7e, 0x5a,
    0x7e, 0x21, 0x7e, 0x22, 0x7e, 0x28, 0x7e, 0x29, 0x7e, 0x3f};
const uint8_t HuffDecoderCommon::table21_32_emit_[8] = {0x5e, 0x30, 0x5e, 0x31,
                                                        0x5e, 0x32, 0x5e, 0x61};
const uint8_t HuffDecoderCommon::table21_33_emit_[8] = {0x5e, 0x63, 0x5e, 0x65,
                                                        0x5e, 0x69, 0x5e, 0x6f};
const uint8_t HuffDecoderCommon::table21_34_emit_[12] = {
    0x5e, 0x73, 0x5e, 0x74, 0x5e, 0x20, 0x5e, 0x25, 0x5e, 0x2d, 0x5e, 0x2e};
const uint8_t HuffDecoderCommon::table21_35_emit_[16] = {
    0x5e, 0x2f, 0x5e, 0x33, 0x5e, 0x34, 0x5e, 0x35,
    0x5e, 0x36, 0x5e, 0x37, 0x5e, 0x38, 0x5e, 0x39};
const uint8_t HuffDecoderCommon::table21_36_emit_[16] = {
    0x5e, 0x3d, 0x5e, 0x41, 0x5e, 0x5f, 0x5e, 0x62,
    0x5e, 0x64, 0x5e, 0x66, 0x5e, 0x67, 0x5e, 0x68};
const uint8_t HuffDecoderCommon::table21_37_emit_[20] = {
    0x5e, 0x6c, 0x5e, 0x6d, 0x5e, 0x6e, 0x5e, 0x70, 0x5e, 0x72,
    0x5e, 0x75, 0x5e, 0x3a, 0x5e, 0x42, 0x5e, 0x43, 0x5e, 0x44};
const uint16_t HuffDecoderCommon::table21_37_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0042,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092};
const uint8_t HuffDecoderCommon::table21_38_emit_[32] = {
    0x5e, 0x45, 0x5e, 0x46, 0x5e, 0x47, 0x5e, 0x48, 0x5e, 0x49, 0x5e,
    0x4a, 0x5e, 0x4b, 0x5e, 0x4c, 0x5e, 0x4d, 0x5e, 0x4e, 0x5e, 0x4f,
    0x5e, 0x50, 0x5e, 0x51, 0x5e, 0x52, 0x5e, 0x53, 0x5e, 0x54};
const uint16_t HuffDecoderCommon::table21_38_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x0001, 0x0001, 0x00a2, 0x0001, 0x0001, 0x0001, 0x00b2,
    0x0001, 0x0001, 0x0001, 0x00c2, 0x0001, 0x0001, 0x0001, 0x00d2,
    0x0001, 0x0001, 0x0001, 0x00e2, 0x0001, 0x0001, 0x0001, 0x00f2};
const uint8_t HuffDecoderCommon::table21_39_emit_[36] = {
    0x5e, 0x55, 0x5e, 0x56, 0x5e, 0x57, 0x5e, 0x59, 0x5e, 0x6a, 0x5e, 0x6b,
    0x5e, 0x71, 0x5e, 0x76, 0x5e, 0x77, 0x5e, 0x78, 0x5e, 0x79, 0x5e, 0x7a,
    0x5e, 0x26, 0x5e, 0x2a, 0x5e, 0x2c, 0x5e, 0x3b, 0x5e, 0x58, 0x5e, 0x5a};
const uint16_t HuffDecoderCommon::table21_39_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x0001, 0x0001, 0x00a2, 0x0001, 0x0001, 0x0001, 0x00b2,
    0x0001, 0x00c2, 0x0001, 0x00d2, 0x0001, 0x00e2, 0x0001, 0x00f2,
    0x0001, 0x0102, 0x0001, 0x0112, 0x0001, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table21_40_emit_[8] = {0x7d, 0x30, 0x7d, 0x31,
                                                        0x7d, 0x32, 0x7d, 0x61};
const uint8_t HuffDecoderCommon::table21_41_emit_[8] = {0x7d, 0x63, 0x7d, 0x65,
                                                        0x7d, 0x69, 0x7d, 0x6f};
const uint8_t HuffDecoderCommon::table21_42_emit_[12] = {
    0x7d, 0x73, 0x7d, 0x74, 0x7d, 0x20, 0x7d, 0x25, 0x7d, 0x2d, 0x7d, 0x2e};
const uint8_t HuffDecoderCommon::table21_43_emit_[16] = {
    0x7d, 0x2f, 0x7d, 0x33, 0x7d, 0x34, 0x7d, 0x35,
    0x7d, 0x36, 0x7d, 0x37, 0x7d, 0x38, 0x7d, 0x39};
const uint8_t HuffDecoderCommon::table21_44_emit_[16] = {
    0x7d, 0x3d, 0x7d, 0x41, 0x7d, 0x5f, 0x7d, 0x62,
    0x7d, 0x64, 0x7d, 0x66, 0x7d, 0x67, 0x7d, 0x68};
const uint8_t HuffDecoderCommon::table21_45_emit_[20] = {
    0x7d, 0x6c, 0x7d, 0x6d, 0x7d, 0x6e, 0x7d, 0x70, 0x7d, 0x72,
    0x7d, 0x75, 0x7d, 0x3a, 0x7d, 0x42, 0x7d, 0x43, 0x7d, 0x44};
const uint8_t HuffDecoderCommon::table21_46_emit_[32] = {
    0x7d, 0x45, 0x7d, 0x46, 0x7d, 0x47, 0x7d, 0x48, 0x7d, 0x49, 0x7d,
    0x4a, 0x7d, 0x4b, 0x7d, 0x4c, 0x7d, 0x4d, 0x7d, 0x4e, 0x7d, 0x4f,
    0x7d, 0x50, 0x7d, 0x51, 0x7d, 0x52, 0x7d, 0x53, 0x7d, 0x54};
const uint8_t HuffDecoderCommon::table21_47_emit_[36] = {
    0x7d, 0x55, 0x7d, 0x56, 0x7d, 0x57, 0x7d, 0x59, 0x7d, 0x6a, 0x7d, 0x6b,
    0x7d, 0x71, 0x7d, 0x76, 0x7d, 0x77, 0x7d, 0x78, 0x7d, 0x79, 0x7d, 0x7a,
    0x7d, 0x26, 0x7d, 0x2a, 0x7d, 0x2c, 0x7d, 0x3b, 0x7d, 0x58, 0x7d, 0x5a};
const uint8_t HuffDecoderCommon::table21_48_emit_[16] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61,
    0x3c, 0x63, 0x3c, 0x65, 0x3c, 0x69, 0x3c, 0x6f};
const uint8_t HuffDecoderCommon::table21_49_emit_[28] = {
    0x3c, 0x73, 0x3c, 0x74, 0x3c, 0x20, 0x3c, 0x25, 0x3c, 0x2d,
    0x3c, 0x2e, 0x3c, 0x2f, 0x3c, 0x33, 0x3c, 0x34, 0x3c, 0x35,
    0x3c, 0x36, 0x3c, 0x37, 0x3c, 0x38, 0x3c, 0x39};
const uint16_t HuffDecoderCommon::table21_49_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x0001, 0x0001, 0x00a2, 0x0001, 0x0001, 0x0001, 0x00b2,
    0x0001, 0x0001, 0x0001, 0x00c2, 0x0001, 0x0001, 0x0001, 0x00d2};
const uint8_t HuffDecoderCommon::table21_50_emit_[36] = {
    0x3c, 0x3d, 0x3c, 0x41, 0x3c, 0x5f, 0x3c, 0x62, 0x3c, 0x64, 0x3c, 0x66,
    0x3c, 0x67, 0x3c, 0x68, 0x3c, 0x6c, 0x3c, 0x6d, 0x3c, 0x6e, 0x3c, 0x70,
    0x3c, 0x72, 0x3c, 0x75, 0x3c, 0x3a, 0x3c, 0x42, 0x3c, 0x43, 0x3c, 0x44};
const uint16_t HuffDecoderCommon::table21_50_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x0001, 0x0001, 0x00a2, 0x0001, 0x0001, 0x0001, 0x00b2,
    0x0001, 0x0001, 0x0001, 0x00c2, 0x0001, 0x0001, 0x0001, 0x00d2,
    0x0001, 0x00e2, 0x0001, 0x00f2, 0x0001, 0x0102, 0x0001, 0x0112};
const uint8_t HuffDecoderCommon::table21_51_emit_[68] = {
    0x3c, 0x45, 0x3c, 0x46, 0x3c, 0x47, 0x3c, 0x48, 0x3c, 0x49, 0x3c, 0x4a,
    0x3c, 0x4b, 0x3c, 0x4c, 0x3c, 0x4d, 0x3c, 0x4e, 0x3c, 0x4f, 0x3c, 0x50,
    0x3c, 0x51, 0x3c, 0x52, 0x3c, 0x53, 0x3c, 0x54, 0x3c, 0x55, 0x3c, 0x56,
    0x3c, 0x57, 0x3c, 0x59, 0x3c, 0x6a, 0x3c, 0x6b, 0x3c, 0x71, 0x3c, 0x76,
    0x3c, 0x77, 0x3c, 0x78, 0x3c, 0x79, 0x3c, 0x7a, 0x3c, 0x26, 0x3c, 0x2a,
    0x3c, 0x2c, 0x3c, 0x3b, 0x3c, 0x58, 0x3c, 0x5a};
const uint16_t HuffDecoderCommon::table21_51_ops_[64] = {
    0x0001, 0x0002, 0x0001, 0x0012, 0x0001, 0x0022, 0x0001, 0x0032,
    0x0001, 0x0042, 0x0001, 0x0052, 0x0001, 0x0062, 0x0001, 0x0072,
    0x0001, 0x0082, 0x0001, 0x0092, 0x0001, 0x00a2, 0x0001, 0x00b2,
    0x0001, 0x00c2, 0x0001, 0x00d2, 0x0001, 0x00e2, 0x0001, 0x00f2,
    0x0001, 0x0102, 0x0001, 0x0112, 0x0001, 0x0122, 0x0001, 0x0132,
    0x0001, 0x0142, 0x0001, 0x0152, 0x0001, 0x0162, 0x0001, 0x0172,
    0x0001, 0x0182, 0x0001, 0x0192, 0x0001, 0x01a2, 0x0001, 0x01b2,
    0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table21_52_emit_[16] = {
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61,
    0x60, 0x63, 0x60, 0x65, 0x60, 0x69, 0x60, 0x6f};
const uint8_t HuffDecoderCommon::table21_53_emit_[28] = {
    0x60, 0x73, 0x60, 0x74, 0x60, 0x20, 0x60, 0x25, 0x60, 0x2d,
    0x60, 0x2e, 0x60, 0x2f, 0x60, 0x33, 0x60, 0x34, 0x60, 0x35,
    0x60, 0x36, 0x60, 0x37, 0x60, 0x38, 0x60, 0x39};
const uint8_t HuffDecoderCommon::table21_54_emit_[36] = {
    0x60, 0x3d, 0x60, 0x41, 0x60, 0x5f, 0x60, 0x62, 0x60, 0x64, 0x60, 0x66,
    0x60, 0x67, 0x60, 0x68, 0x60, 0x6c, 0x60, 0x6d, 0x60, 0x6e, 0x60, 0x70,
    0x60, 0x72, 0x60, 0x75, 0x60, 0x3a, 0x60, 0x42, 0x60, 0x43, 0x60, 0x44};
const uint8_t HuffDecoderCommon::table21_55_emit_[68] = {
    0x60, 0x45, 0x60, 0x46, 0x60, 0x47, 0x60, 0x48, 0x60, 0x49, 0x60, 0x4a,
    0x60, 0x4b, 0x60, 0x4c, 0x60, 0x4d, 0x60, 0x4e, 0x60, 0x4f, 0x60, 0x50,
    0x60, 0x51, 0x60, 0x52, 0x60, 0x53, 0x60, 0x54, 0x60, 0x55, 0x60, 0x56,
    0x60, 0x57, 0x60, 0x59, 0x60, 0x6a, 0x60, 0x6b, 0x60, 0x71, 0x60, 0x76,
    0x60, 0x77, 0x60, 0x78, 0x60, 0x79, 0x60, 0x7a, 0x60, 0x26, 0x60, 0x2a,
    0x60, 0x2c, 0x60, 0x3b, 0x60, 0x58, 0x60, 0x5a};
const uint8_t HuffDecoderCommon::table21_56_emit_[16] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61,
    0x7b, 0x63, 0x7b, 0x65, 0x7b, 0x69, 0x7b, 0x6f};
const uint8_t HuffDecoderCommon::table21_57_emit_[28] = {
    0x7b, 0x73, 0x7b, 0x74, 0x7b, 0x20, 0x7b, 0x25, 0x7b, 0x2d,
    0x7b, 0x2e, 0x7b, 0x2f, 0x7b, 0x33, 0x7b, 0x34, 0x7b, 0x35,
    0x7b, 0x36, 0x7b, 0x37, 0x7b, 0x38, 0x7b, 0x39};
const uint8_t HuffDecoderCommon::table21_58_emit_[36] = {
    0x7b, 0x3d, 0x7b, 0x41, 0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64, 0x7b, 0x66,
    0x7b, 0x67, 0x7b, 0x68, 0x7b, 0x6c, 0x7b, 0x6d, 0x7b, 0x6e, 0x7b, 0x70,
    0x7b, 0x72, 0x7b, 0x75, 0x7b, 0x3a, 0x7b, 0x42, 0x7b, 0x43, 0x7b, 0x44};
const uint8_t HuffDecoderCommon::table21_59_emit_[68] = {
    0x7b, 0x45, 0x7b, 0x46, 0x7b, 0x47, 0x7b, 0x48, 0x7b, 0x49, 0x7b, 0x4a,
    0x7b, 0x4b, 0x7b, 0x4c, 0x7b, 0x4d, 0x7b, 0x4e, 0x7b, 0x4f, 0x7b, 0x50,
    0x7b, 0x51, 0x7b, 0x52, 0x7b, 0x53, 0x7b, 0x54, 0x7b, 0x55, 0x7b, 0x56,
    0x7b, 0x57, 0x7b, 0x59, 0x7b, 0x6a, 0x7b, 0x6b, 0x7b, 0x71, 0x7b, 0x76,
    0x7b, 0x77, 0x7b, 0x78, 0x7b, 0x79, 0x7b, 0x7a, 0x7b, 0x26, 0x7b, 0x2a,
    0x7b, 0x2c, 0x7b, 0x3b, 0x7b, 0x58, 0x7b, 0x5a};
const uint8_t HuffDecoderCommon::table21_60_emit_[5] = {0x5c, 0xc3, 0xd0, 0x80,
                                                        0x82};
const uint16_t HuffDecoderCommon::table21_60_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0013,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x001b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0023};
const uint8_t HuffDecoderCommon::table21_61_emit_[10] = {
    0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2, 0x99, 0xa1, 0xa7, 0xac};
const uint16_t HuffDecoderCommon::table21_61_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0013,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x001b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0023,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x002b,
    0x0001, 0x0001, 0x0001, 0x0033, 0x0001, 0x0001, 0x0001, 0x003b,
    0x0001, 0x0001, 0x0001, 0x0043, 0x0001, 0x0001, 0x0001, 0x004b};
const uint8_t HuffDecoderCommon::table21_62_emit_[23] = {
    0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84, 0x85,
    0x86, 0x88, 0x92, 0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa, 0xad};
const uint16_t HuffDecoderCommon::table21_62_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0003, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0013, 0x0001, 0x0001, 0x0001, 0x001b,
    0x0001, 0x0001, 0x0001, 0x0023, 0x0001, 0x0001, 0x0001, 0x002b,
    0x0001, 0x0001, 0x0001, 0x0033, 0x0001, 0x0001, 0x0001, 0x003b,
    0x0001, 0x0001, 0x0001, 0x0043, 0x0001, 0x004b, 0x0001, 0x0053,
    0x0001, 0x005b, 0x0001, 0x0063, 0x0001, 0x006b, 0x0001, 0x0073,
    0x0001, 0x007b, 0x0001, 0x0083, 0x0001, 0x008b, 0x0001, 0x0093,
    0x0001, 0x009b, 0x0001, 0x00a3, 0x0001, 0x00ab, 0x0001, 0x00b3};
const uint8_t HuffDecoderCommon::table21_63_emit_[41] = {
    0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8,
    0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f, 0x93, 0x95,
    0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8, 0xae, 0xaf,
    0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef};
const uint16_t HuffDecoderCommon::table21_63_ops_[64] = {
    0x0001, 0x0003, 0x0001, 0x000b, 0x0001, 0x0013, 0x0001, 0x001b,
    0x0001, 0x0023, 0x0001, 0x002b, 0x0001, 0x0033, 0x0001, 0x003b,
    0x0001, 0x0043, 0x0001, 0x004b, 0x0001, 0x0053, 0x0001, 0x005b,
    0x0063, 0x006b, 0x0073, 0x007b, 0x0083, 0x008b, 0x0093, 0x009b,
    0x00a3, 0x00ab, 0x00b3, 0x00bb, 0x00c3, 0x00cb, 0x00d3, 0x00db,
    0x00e3, 0x00eb, 0x00f3, 0x00fb, 0x0103, 0x010b, 0x0113, 0x011b,
    0x0123, 0x012b, 0x0133, 0x013b, 0x0143, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0004};
const uint8_t* const HuffDecoderCommon::table21_emit_[64] = {
    table21_0_emit_,  table21_1_emit_,  table21_2_emit_,  table21_3_emit_,
    table21_4_emit_,  table21_5_emit_,  table21_6_emit_,  table21_7_emit_,
    table21_8_emit_,  table21_9_emit_,  table21_10_emit_, table21_11_emit_,
    table21_12_emit_, table21_13_emit_, table21_14_emit_, table21_15_emit_,
    table21_16_emit_, table21_17_emit_, table21_18_emit_, table21_19_emit_,
    table21_20_emit_, table21_21_emit_, table21_22_emit_, table21_23_emit_,
    table21_24_emit_, table21_25_emit_, table21_26_emit_, table21_27_emit_,
    table21_28_emit_, table21_29_emit_, table21_30_emit_, table21_31_emit_,
    table21_32_emit_, table21_33_emit_, table21_34_emit_, table21_35_emit_,
    table21_36_emit_, table21_37_emit_, table21_38_emit_, table21_39_emit_,
    table21_40_emit_, table21_41_emit_, table21_42_emit_, table21_43_emit_,
    table21_44_emit_, table21_45_emit_, table21_46_emit_, table21_47_emit_,
    table21_48_emit_, table21_49_emit_, table21_50_emit_, table21_51_emit_,
    table21_52_emit_, table21_53_emit_, table21_54_emit_, table21_55_emit_,
    table21_56_emit_, table21_57_emit_, table21_58_emit_, table21_59_emit_,
    table21_60_emit_, table21_61_emit_, table21_62_emit_, table21_63_emit_,
};
const uint16_t* const HuffDecoderCommon::table21_ops_[64] = {
    table21_0_ops_,  table21_0_ops_,  table21_0_ops_,  table21_0_ops_,
    table21_0_ops_,  table21_5_ops_,  table21_5_ops_,  table21_5_ops_,
    table21_5_ops_,  table21_5_ops_,  table21_5_ops_,  table21_11_ops_,
    table21_12_ops_, table21_12_ops_, table21_12_ops_, table21_15_ops_,
    table21_0_ops_,  table21_0_ops_,  table21_0_ops_,  table21_0_ops_,
    table21_0_ops_,  table21_5_ops_,  table21_5_ops_,  table21_5_ops_,
    table21_5_ops_,  table21_5_ops_,  table21_5_ops_,  table21_11_ops_,
    table21_12_ops_, table21_12_ops_, table21_12_ops_, table21_15_ops_,
    table21_5_ops_,  table21_5_ops_,  table21_11_ops_, table21_12_ops_,
    table21_12_ops_, table21_37_ops_, table21_38_ops_, table21_39_ops_,
    table21_5_ops_,  table21_5_ops_,  table21_11_ops_, table21_12_ops_,
    table21_12_ops_, table21_37_ops_, table21_38_ops_, table21_39_ops_,
    table21_12_ops_, table21_49_ops_, table21_50_ops_, table21_51_ops_,
    table21_12_ops_, table21_49_ops_, table21_50_ops_, table21_51_ops_,
    table21_12_ops_, table21_49_ops_, table21_50_ops_, table21_51_ops_,
    table21_60_ops_, table21_61_ops_, table21_62_ops_, table21_63_ops_,
};
const uint8_t HuffDecoderCommon::table10_0_emit_[1] = {0x5d};
const uint16_t HuffDecoderCommon::table10_0_ops_[256] = {
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002};
const uint8_t HuffDecoderCommon::table10_8_emit_[1] = {0x7e};
const uint8_t HuffDecoderCommon::table10_16_emit_[1] = {0x5e};
const uint16_t HuffDecoderCommon::table10_16_ops_[256] = {
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003};
const uint8_t HuffDecoderCommon::table10_20_emit_[1] = {0x7d};
const uint8_t HuffDecoderCommon::table10_24_emit_[1] = {0x3c};
const uint16_t HuffDecoderCommon::table10_24_ops_[256] = {
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004};
const uint8_t HuffDecoderCommon::table10_26_emit_[1] = {0x60};
const uint8_t HuffDecoderCommon::table10_28_emit_[1] = {0x7b};
const uint16_t HuffDecoderCommon::table10_30_ops_[256] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0108, 0x0108, 0x0108, 0x0108,
    0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108,
    0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108,
    0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108,
    0x0108, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0309, 0x0309, 0x0309,
    0x0309, 0x0309, 0x0309, 0x0309, 0x0309, 0x0309, 0x0309, 0x0309, 0x0309,
    0x0309, 0x0309, 0x0309, 0x0309, 0x0409, 0x0409, 0x0409, 0x0409, 0x0409,
    0x0409, 0x0409, 0x0409, 0x0409, 0x0409, 0x0409, 0x0409, 0x0409, 0x0409,
    0x0409, 0x0409, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
    0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
    0x0609, 0x0609, 0x0609, 0x0609, 0x0609, 0x0609, 0x0609, 0x0609, 0x0609,
    0x0609, 0x0609, 0x0609, 0x0609, 0x0609, 0x0609, 0x0609, 0x0709, 0x0709,
    0x0709, 0x0709, 0x0709, 0x0709, 0x0709, 0x0709, 0x0709, 0x0709, 0x0709,
    0x0709, 0x0709, 0x0709, 0x0709, 0x0709, 0x0809, 0x0809, 0x0809, 0x0809,
    0x0809, 0x0809, 0x0809, 0x0809, 0x0809, 0x0809, 0x0809, 0x0809, 0x0809,
    0x0809, 0x0809, 0x0809, 0x0909, 0x0909, 0x0909, 0x0909, 0x0909, 0x0909,
    0x0909, 0x0909, 0x0909, 0x0909, 0x0909, 0x0909, 0x0909, 0x0909, 0x0909,
    0x0909, 0x0a09, 0x0a09, 0x0a09, 0x0a09, 0x0a09, 0x0a09, 0x0a09, 0x0a09,
    0x0a09, 0x0a09, 0x0a09, 0x0a09, 0x0a09, 0x0a09, 0x0a09, 0x0a09, 0x0b0a,
    0x0b0a, 0x0b0a, 0x0b0a, 0x0b0a, 0x0b0a, 0x0b0a, 0x0b0a, 0x0c0a, 0x0c0a,
    0x0c0a, 0x0c0a, 0x0c0a, 0x0c0a, 0x0c0a, 0x0c0a, 0x0d0a, 0x0d0a, 0x0d0a,
    0x0d0a, 0x0d0a, 0x0d0a, 0x0d0a, 0x0d0a, 0x0e0a, 0x0e0a, 0x0e0a, 0x0e0a,
    0x0e0a, 0x0e0a, 0x0e0a, 0x0e0a};
const uint8_t HuffDecoderCommon::table10_31_emit_[76] = {
    0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84,
    0x85, 0x86, 0x88, 0x92, 0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa,
    0xad, 0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4,
    0xe8, 0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f, 0x93,
    0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8, 0xae,
    0xaf, 0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e,
    0x90, 0x91, 0x94, 0x9f, 0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed};
const uint16_t HuffDecoderCommon::table10_31_ops_[256] = {
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x020a, 0x020a,
    0x020a, 0x020a, 0x020a, 0x020a, 0x020a, 0x020a, 0x030a, 0x030a, 0x030a,
    0x030a, 0x030a, 0x030a, 0x030a, 0x030a, 0x040a, 0x040a, 0x040a, 0x040a,
    0x040a, 0x040a, 0x040a, 0x040a, 0x050a, 0x050a, 0x050a, 0x050a, 0x050a,
    0x050a, 0x050a, 0x050a, 0x060a, 0x060a, 0x060a, 0x060a, 0x060a, 0x060a,
    0x060a, 0x060a, 0x070a, 0x070a, 0x070a, 0x070a, 0x070a, 0x070a, 0x070a,
    0x070a, 0x080a, 0x080a, 0x080a, 0x080a, 0x080a, 0x080a, 0x080a, 0x080a,
    0x090b, 0x090b, 0x090b, 0x090b, 0x0a0b, 0x0a0b, 0x0a0b, 0x0a0b, 0x0b0b,
    0x0b0b, 0x0b0b, 0x0b0b, 0x0c0b, 0x0c0b, 0x0c0b, 0x0c0b, 0x0d0b, 0x0d0b,
    0x0d0b, 0x0d0b, 0x0e0b, 0x0e0b, 0x0e0b, 0x0e0b, 0x0f0b, 0x0f0b, 0x0f0b,
    0x0f0b, 0x100b, 0x100b, 0x100b, 0x100b, 0x110b, 0x110b, 0x110b, 0x110b,
    0x120b, 0x120b, 0x120b, 0x120b, 0x130b, 0x130b, 0x130b, 0x130b, 0x140b,
    0x140b, 0x140b, 0x140b, 0x150b, 0x150b, 0x150b, 0x150b, 0x160b, 0x160b,
    0x160b, 0x160b, 0x170b, 0x170b, 0x170b, 0x170b, 0x180b, 0x180b, 0x180b,
    0x180b, 0x190b, 0x190b, 0x190b, 0x190b, 0x1a0b, 0x1a0b, 0x1a0b, 0x1a0b,
    0x1b0b, 0x1b0b, 0x1b0b, 0x1b0b, 0x1c0b, 0x1c0b, 0x1c0b, 0x1c0b, 0x1d0b,
    0x1d0b, 0x1d0b, 0x1d0b, 0x1e0b, 0x1e0b, 0x1e0b, 0x1e0b, 0x1f0b, 0x1f0b,
    0x1f0b, 0x1f0b, 0x200b, 0x200b, 0x200b, 0x200b, 0x210b, 0x210b, 0x210b,
    0x210b, 0x220b, 0x220b, 0x220b, 0x220b, 0x230c, 0x230c, 0x240c, 0x240c,
    0x250c, 0x250c, 0x260c, 0x260c, 0x270c, 0x270c, 0x280c, 0x280c, 0x290c,
    0x290c, 0x2a0c, 0x2a0c, 0x2b0c, 0x2b0c, 0x2c0c, 0x2c0c, 0x2d0c, 0x2d0c,
    0x2e0c, 0x2e0c, 0x2f0c, 0x2f0c, 0x300c, 0x300c, 0x310c, 0x310c, 0x320c,
    0x320c, 0x330c, 0x330c, 0x340c, 0x340c, 0x350c, 0x350c, 0x360c, 0x360c,
    0x370c, 0x370c, 0x380c, 0x380c, 0x390c, 0x390c, 0x3a0c, 0x3a0c, 0x3b0c,
    0x3b0c, 0x3c0c, 0x3c0c, 0x3d0c, 0x3d0c, 0x3e0c, 0x3e0c, 0x3f0c, 0x3f0c,
    0x400d, 0x410d, 0x420d, 0x430d, 0x440d, 0x450d, 0x460d, 0x470d, 0x480d,
    0x490d, 0x4a0d, 0x4b0d, 0x001d, 0x002d, 0x003d, 0x004d, 0x005d, 0x006d,
    0x007d, 0x008d, 0x009d, 0x00ad};
const uint8_t* const HuffDecoderCommon::table10_emit_[32] = {
    table10_0_emit_,  table10_0_emit_,  table10_0_emit_,  table10_0_emit_,
    table10_0_emit_,  table10_0_emit_,  table10_0_emit_,  table10_0_emit_,
    table10_8_emit_,  table10_8_emit_,  table10_8_emit_,  table10_8_emit_,
    table10_8_emit_,  table10_8_emit_,  table10_8_emit_,  table10_8_emit_,
    table10_16_emit_, table10_16_emit_, table10_16_emit_, table10_16_emit_,
    table10_20_emit_, table10_20_emit_, table10_20_emit_, table10_20_emit_,
    table10_24_emit_, table10_24_emit_, table10_26_emit_, table10_26_emit_,
    table10_28_emit_, table10_28_emit_, table20_30_emit_, table10_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table10_ops_[32] = {
    table10_0_ops_,  table10_0_ops_,  table10_0_ops_,  table10_0_ops_,
    table10_0_ops_,  table10_0_ops_,  table10_0_ops_,  table10_0_ops_,
    table10_0_ops_,  table10_0_ops_,  table10_0_ops_,  table10_0_ops_,
    table10_0_ops_,  table10_0_ops_,  table10_0_ops_,  table10_0_ops_,
    table10_16_ops_, table10_16_ops_, table10_16_ops_, table10_16_ops_,
    table10_16_ops_, table10_16_ops_, table10_16_ops_, table10_16_ops_,
    table10_24_ops_, table10_24_ops_, table10_24_ops_, table10_24_ops_,
    table10_24_ops_, table10_24_ops_, table10_30_ops_, table10_31_ops_,
};
const uint8_t HuffDecoderCommon::table27_0_emit_[8] = {0xd3, 0xd4, 0xd6, 0xdd,
                                                       0xde, 0xdf, 0xf1, 0xf4};
const uint8_t HuffDecoderCommon::table27_0_inner_[8] = {0x03, 0x07, 0x0b, 0x0f,
                                                        0x13, 0x17, 0x1b, 0x1f};
const uint8_t HuffDecoderCommon::table29_0_emit_[15] = {
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0x0b, 0x0c, 0x0e, 0x0f, 0x10, 0x11, 0x12};
const uint8_t HuffDecoderCommon::table29_0_inner_[15] = {
    0x03, 0x0c, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c,
    0x44, 0x4c, 0x54, 0x5c, 0x64, 0x6c, 0x74};
const uint8_t HuffDecoderCommon::table31_0_emit_[5] = {0xf2, 0xf3, 0xff, 0xcb,
                                                       0xcc};
const uint8_t HuffDecoderCommon::table31_0_inner_[5] = {0x02, 0x06, 0x0a, 0x0f,
                                                        0x13};
const uint8_t HuffDecoderCommon::table34_0_emit_[15] = {
    0x13, 0x14, 0x15, 0x17, 0x18, 0x19, 0x1a, 0x1b,
    0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint8_t HuffDecoderCommon::table34_0_inner_[16] = {
    0x00, 0x02, 0x04, 0x06, 0x08, 0x0a, 0x0c, 0x0e,
    0x10, 0x12, 0x14, 0x16, 0x18, 0x1a, 0x1c, 0x01};
const uint8_t HuffDecoderCommon::table35_0_ops_[32] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table33_0_emit_[8] = {0x13, 0x14, 0x15, 0x17,
                                                       0x18, 0x19, 0x1a, 0x1b};
const uint8_t HuffDecoderCommon::table33_0_ops_[32] = {
    0x04, 0x04, 0x04, 0x04, 0x14, 0x14, 0x14, 0x14, 0x24, 0x24, 0x24,
    0x24, 0x34, 0x34, 0x34, 0x34, 0x44, 0x44, 0x44, 0x44, 0x54, 0x54,
    0x54, 0x54, 0x64, 0x64, 0x64, 0x64, 0x74, 0x74, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table33_1_emit_[10] = {
    0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9, 0x0a, 0x0d, 0x16};
const uint8_t HuffDecoderCommon::table33_1_ops_[32] = {
    0x04, 0x04, 0x04, 0x04, 0x14, 0x14, 0x14, 0x14, 0x24, 0x24, 0x24,
    0x24, 0x34, 0x34, 0x34, 0x34, 0x44, 0x44, 0x44, 0x44, 0x54, 0x54,
    0x54, 0x54, 0x64, 0x64, 0x64, 0x64, 0x76, 0x86, 0x96, 0x0e};
const uint8_t* const HuffDecoderCommon::table33_emit_[2] = {
    table33_0_emit_,
    table33_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table33_ops_[2] = {
    table33_0_ops_,
    table33_1_ops_,
};
}  // namespace geometry_11_13_6
}  // namespace grpc_core
