// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#ifndef GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_14_10_6_H
#define GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_14_10_6_H
#include <cstddef>
#include <cstdint>

#include <grpc/support/port_platform.h>
namespace grpc_core {
namespace geometry_14_10_6 {
class HuffDecoderCommon {
 protected:
  static inline uint64_t GetOp2(size_t i) { return table2_0_ops_[i]; }
  static inline uint64_t GetEmit2(size_t, size_t emit) {
    return table2_0_emit_[emit];
  }
  static inline uint64_t GetOp3(size_t i) { return table3_0_ops_[i]; }
  static inline uint64_t GetEmit3(size_t, size_t emit) {
    return table3_0_emit_[emit];
  }
  static inline uint64_t GetOp4(size_t i) {
    return table4_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit4(size_t i, size_t emit) {
    return table4_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp5(size_t i) {
    return table5_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit5(size_t i, size_t emit) {
    return table5_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp6(size_t i) {
    return table6_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit6(size_t i, size_t emit) {
    return table6_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp7(size_t i) {
    return table7_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit7(size_t i, size_t emit) {
    return table7_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp8(size_t i) {
    return table8_inner_[i >> 6][table8_outer_[i >> 6][i & 0x3f]];
  }
  static inline uint64_t GetEmit8(size_t i, size_t emit) {
    return table8_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp9(size_t i) {
    return table9_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit9(size_t i, size_t emit) {
    return table9_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp10(size_t i) {
    return table10_inner_[i >> 6][table10_outer_[i >> 6][i & 0x3f]];
  }
  static inline uint64_t GetEmit10(size_t i, size_t emit) {
    return table10_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp1(size_t i) {
    return table1_inner_[i >> 6][table1_outer_[i >> 6][i & 0x3f]];
  }
  static inline uint64_t GetEmit1(size_t i, size_t emit) {
    return table1_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp11(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit11(size_t, size_t emit) {
    return emit ? 96 : 60;
  }
  static inline uint64_t GetOp13(size_t i) { return i; }
  static inline uint64_t GetEmit13(size_t, size_t emit) {
    return ((void)emit, 123);
  }
  static inline uint64_t GetOp14(size_t i) {
    return (i < 2 ? (i) : ((i - 2) ? 2 : 0));
  }
  static inline uint64_t GetEmit14(size_t, size_t emit) {
    return ((void)emit, 123);
  }
  static inline uint64_t GetOp15(size_t i) { return table15_0_outer_[i]; }
  static inline uint64_t GetEmit15(size_t, size_t emit) {
    return ((void)emit, 123);
  }
  static inline uint64_t GetOp16(size_t i) { return table16_0_outer_[i]; }
  static inline uint64_t GetEmit16(size_t, size_t emit) {
    return ((void)emit, 123);
  }
  static inline uint64_t GetOp17(size_t i) { return table17_0_ops_[i]; }
  static inline uint64_t GetEmit17(size_t, size_t emit) {
    return (emit < 2 ? (emit ? 92 : 123) : ((emit - 2) ? 208 : 195));
  }
  static inline uint64_t GetOp18(size_t i) { return table18_0_ops_[i]; }
  static inline uint64_t GetEmit18(size_t, size_t emit) {
    return table18_0_emit_[emit];
  }
  static inline uint64_t GetOp19(size_t i) {
    return table19_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit19(size_t i, size_t emit) {
    return table19_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp20(size_t i) {
    return table20_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit20(size_t i, size_t emit) {
    return table20_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp21(size_t i) {
    return table21_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit21(size_t i, size_t emit) {
    return table21_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp12(size_t i) {
    return table12_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit12(size_t i, size_t emit) {
    return table12_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp22(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit22(size_t, size_t emit) {
    return emit ? 207 : 199;
  }
  static inline uint64_t GetOp23(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit23(size_t, size_t emit) { return emit + 234; }
  static inline uint64_t GetOp24(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit24(size_t, size_t emit) {
    return (emit < 2 ? (emit + 192) : ((emit - 2) + 200));
  }
  static inline uint64_t GetOp25(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit25(size_t, size_t emit) {
    return (emit < 2 ? (emit ? 205 : 202) : ((emit - 2) ? 213 : 210));
  }
  static inline uint64_t GetOp26(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit26(size_t, size_t emit) {
    return (emit < 2 ? (emit + 218) : ((emit - 2) ? 240 : 238));
  }
  static inline uint64_t GetOp27(size_t i) { return table27_0_inner_[i]; }
  static inline uint64_t GetEmit27(size_t, size_t emit) {
    return table27_0_emit_[emit];
  }
  static inline uint64_t GetOp28(size_t i) { return table27_0_inner_[i]; }
  static inline uint64_t GetEmit28(size_t, size_t emit) {
    return (emit < 4 ? (emit + 245) : ((emit - 4) + 250));
  }
  static inline uint64_t GetOp30(size_t i) {
    return (i < 1 ? (((void)i, 0)) : (((void)(i - 1), 1)));
  }
  static inline uint64_t GetEmit30(size_t, size_t emit) {
    return ((void)emit, 254);
  }
  static inline uint64_t GetOp29(size_t i) {
    return table29_0_inner_[(i < 1 ? (((void)i, 0)) : ((i - 1)))];
  }
  static inline uint64_t GetEmit29(size_t, size_t emit) {
    return table29_0_emit_[emit];
  }
  static inline uint64_t GetOp32(size_t i) {
    return (i < 2 ? (i ? 2 : 0) : ((i - 2) ? 1 : 4));
  }
  static inline uint64_t GetEmit32(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 242)) : ((emit - 1) ? 255 : 243));
  }
  static inline uint64_t GetOp31(size_t i) {
    return table31_0_inner_[(i < 5 ? (i / 2 + 0) : ((i - 5) + 2))];
  }
  static inline uint64_t GetEmit31(size_t, size_t emit) {
    return table31_0_emit_[emit];
  }
  static inline uint64_t GetOp34(size_t i) { return table34_0_inner_[i]; }
  static inline uint64_t GetEmit34(size_t, size_t emit) {
    return table34_0_emit_[emit];
  }
  static inline uint64_t GetOp35(size_t i) { return table35_0_ops_[i]; }
  static inline uint64_t GetEmit35(size_t, size_t emit) {
    return table34_0_emit_[emit];
  }
  static inline uint64_t GetOp33(size_t i) {
    return table33_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit33(size_t i, size_t emit) {
    return table33_emit_[i >> 5][emit];
  }

 private:
  static const uint8_t table2_0_emit_[10];
  static const uint8_t table2_0_ops_[32];
  static const uint8_t table3_0_emit_[36];
  static const uint8_t table3_0_ops_[64];
  static const uint8_t table4_0_emit_[22];
  static const uint8_t table4_0_ops_[64];
  static const uint8_t table4_1_emit_[46];
  static const uint8_t table4_1_ops_[64];
  static const uint8_t* const table4_emit_[2];
  static const uint8_t* const table4_ops_[2];
  static const uint8_t table5_0_ops_[128];
  static const uint8_t table5_1_emit_[52];
  static const uint8_t table5_1_ops_[128];
  static const uint8_t* const table5_emit_[2];
  static const uint8_t* const table5_ops_[2];
  static const uint8_t table6_0_emit_[2];
  static const uint8_t table6_0_ops_[32];
  static const uint8_t table6_1_emit_[2];
  static const uint8_t table6_2_emit_[2];
  static const uint8_t table6_3_emit_[2];
  static const uint8_t table6_4_emit_[2];
  static const uint8_t table6_5_emit_[4];
  static const uint8_t table6_5_ops_[32];
  static const uint8_t table6_6_emit_[4];
  static const uint8_t table6_7_emit_[4];
  static const uint8_t table6_8_emit_[4];
  static const uint8_t table6_9_emit_[4];
  static const uint8_t table6_10_emit_[4];
  static const uint8_t table6_11_emit_[6];
  static const uint8_t table6_11_ops_[32];
  static const uint8_t table6_12_emit_[8];
  static const uint8_t table6_12_ops_[32];
  static const uint8_t table6_13_emit_[8];
  static const uint8_t table6_14_emit_[8];
  static const uint8_t table6_15_emit_[10];
  static const uint8_t table6_15_ops_[32];
  static const uint8_t* const table6_emit_[16];
  static const uint8_t* const table6_ops_[16];
  static const uint8_t table7_0_emit_[36];
  static const uint8_t table7_0_ops_[64];
  static const uint8_t table7_1_emit_[36];
  static const uint8_t table7_1_ops_[64];
  static const uint8_t table7_2_emit_[36];
  static const uint8_t table7_2_ops_[64];
  static const uint8_t table7_3_emit_[36];
  static const uint8_t table7_3_ops_[64];
  static const uint8_t table7_4_emit_[38];
  static const uint8_t table7_4_ops_[64];
  static const uint8_t table7_5_ops_[64];
  static const uint8_t table7_11_ops_[64];
  static const uint8_t table7_12_ops_[64];
  static const uint8_t table7_15_emit_[15];
  static const uint8_t table7_15_ops_[64];
  static const uint8_t* const table7_emit_[16];
  static const uint8_t* const table7_ops_[16];
  static const uint8_t table8_0_emit_[71];
  static const uint16_t table8_0_inner_[38];
  static const uint8_t table8_0_outer_[64];
  static const uint8_t table8_1_emit_[71];
  static const uint16_t table8_1_inner_[38];
  static const uint8_t table8_2_emit_[71];
  static const uint16_t table8_2_inner_[38];
  static const uint8_t table8_3_emit_[71];
  static const uint16_t table8_3_inner_[38];
  static const uint8_t table8_4_emit_[71];
  static const uint16_t table8_4_inner_[38];
  static const uint8_t table8_5_emit_[71];
  static const uint16_t table8_5_inner_[38];
  static const uint8_t table8_6_emit_[71];
  static const uint16_t table8_6_inner_[38];
  static const uint8_t table8_7_emit_[71];
  static const uint16_t table8_7_inner_[38];
  static const uint8_t table8_8_emit_[71];
  static const uint16_t table8_8_inner_[38];
  static const uint8_t table8_9_emit_[71];
  static const uint16_t table8_9_inner_[38];
  static const uint8_t table8_10_emit_[40];
  static const uint16_t table8_10_inner_[23];
  static const uint8_t table8_10_outer_[64];
  static const uint8_t table8_11_emit_[40];
  static const uint8_t table8_12_emit_[40];
  static const uint8_t table8_13_emit_[40];
  static const uint8_t table8_14_emit_[40];
  static const uint8_t table8_15_emit_[40];
  static const uint8_t table8_16_emit_[40];
  static const uint8_t table8_17_emit_[40];
  static const uint8_t table8_18_emit_[40];
  static const uint8_t table8_19_emit_[40];
  static const uint8_t table8_20_emit_[40];
  static const uint8_t table8_21_emit_[40];
  static const uint8_t table8_22_emit_[40];
  static const uint8_t table8_23_emit_[4];
  static const uint16_t table8_23_inner_[5];
  static const uint8_t table8_23_outer_[64];
  static const uint8_t table8_24_emit_[4];
  static const uint8_t table8_25_emit_[4];
  static const uint8_t table8_26_emit_[4];
  static const uint8_t table8_27_emit_[4];
  static const uint8_t table8_28_emit_[4];
  static const uint8_t table8_29_emit_[4];
  static const uint8_t table8_30_emit_[4];
  static const uint8_t table8_31_emit_[14];
  static const uint16_t table8_31_inner_[16];
  static const uint8_t table8_31_outer_[64];
  static const uint8_t* const table8_emit_[32];
  static const uint16_t* const table8_inner_[32];
  static const uint8_t* const table8_outer_[32];
  static const uint8_t table9_0_emit_[15];
  static const uint8_t table9_0_ops_[32];
  static const uint8_t table9_1_emit_[28];
  static const uint8_t table9_1_ops_[32];
  static const uint8_t table9_2_emit_[36];
  static const uint8_t table9_2_ops_[32];
  static const uint8_t table9_3_emit_[56];
  static const uint8_t table9_3_ops_[32];
  static const uint8_t table9_4_emit_[15];
  static const uint8_t table9_4_ops_[32];
  static const uint8_t table9_5_emit_[28];
  static const uint8_t table9_6_emit_[36];
  static const uint8_t table9_7_emit_[56];
  static const uint8_t table9_8_emit_[15];
  static const uint8_t table9_8_ops_[32];
  static const uint8_t table9_9_emit_[28];
  static const uint8_t table9_10_emit_[36];
  static const uint8_t table9_11_emit_[56];
  static const uint8_t table9_12_emit_[15];
  static const uint8_t table9_12_ops_[32];
  static const uint8_t table9_13_emit_[28];
  static const uint8_t table9_14_emit_[36];
  static const uint8_t table9_15_emit_[56];
  static const uint8_t table9_16_emit_[15];
  static const uint8_t table9_16_ops_[32];
  static const uint8_t table9_17_emit_[28];
  static const uint8_t table9_18_emit_[36];
  static const uint8_t table9_19_emit_[56];
  static const uint8_t table9_20_emit_[15];
  static const uint8_t table9_20_ops_[32];
  static const uint8_t table9_21_emit_[28];
  static const uint8_t table9_22_emit_[36];
  static const uint8_t table9_23_emit_[56];
  static const uint8_t table9_24_emit_[15];
  static const uint8_t table9_24_ops_[32];
  static const uint8_t table9_25_emit_[28];
  static const uint8_t table9_26_emit_[36];
  static const uint8_t table9_27_emit_[56];
  static const uint8_t table9_28_emit_[16];
  static const uint8_t table9_28_ops_[32];
  static const uint8_t table9_29_emit_[28];
  static const uint8_t table9_30_emit_[36];
  static const uint8_t table9_31_emit_[56];
  static const uint8_t table9_32_emit_[16];
  static const uint8_t table9_33_emit_[27];
  static const uint8_t table9_33_ops_[32];
  static const uint8_t table9_34_emit_[36];
  static const uint8_t table9_35_emit_[56];
  static const uint8_t table9_36_emit_[16];
  static const uint8_t table9_37_emit_[27];
  static const uint8_t table9_37_ops_[32];
  static const uint8_t table9_38_emit_[36];
  static const uint8_t table9_39_emit_[56];
  static const uint8_t table9_40_emit_[43];
  static const uint8_t table9_40_ops_[32];
  static const uint8_t table9_41_emit_[28];
  static const uint8_t table9_41_ops_[32];
  static const uint8_t table9_42_emit_[43];
  static const uint8_t table9_42_ops_[32];
  static const uint8_t table9_43_emit_[28];
  static const uint8_t table9_44_emit_[43];
  static const uint8_t table9_44_ops_[32];
  static const uint8_t table9_45_emit_[28];
  static const uint8_t table9_46_emit_[43];
  static const uint8_t table9_46_ops_[32];
  static const uint8_t table9_47_emit_[28];
  static const uint8_t table9_48_emit_[43];
  static const uint8_t table9_48_ops_[32];
  static const uint8_t table9_49_emit_[28];
  static const uint8_t table9_50_emit_[43];
  static const uint8_t table9_50_ops_[32];
  static const uint8_t table9_51_emit_[28];
  static const uint8_t table9_52_emit_[43];
  static const uint8_t table9_52_ops_[32];
  static const uint8_t table9_53_emit_[28];
  static const uint8_t table9_54_emit_[43];
  static const uint8_t table9_54_ops_[32];
  static const uint8_t table9_55_emit_[28];
  static const uint8_t table9_56_emit_[43];
  static const uint8_t table9_56_ops_[32];
  static const uint8_t table9_57_emit_[28];
  static const uint8_t table9_58_emit_[43];
  static const uint8_t table9_58_ops_[32];
  static const uint8_t table9_59_emit_[28];
  static const uint8_t table9_60_emit_[43];
  static const uint8_t table9_60_ops_[32];
  static const uint8_t table9_61_emit_[28];
  static const uint8_t table9_62_emit_[44];
  static const uint8_t table9_62_ops_[32];
  static const uint8_t table9_63_emit_[28];
  static const uint8_t table9_64_emit_[44];
  static const uint8_t table9_65_emit_[27];
  static const uint8_t table9_65_ops_[32];
  static const uint8_t table9_66_emit_[44];
  static const uint8_t table9_67_emit_[27];
  static const uint8_t table9_67_ops_[32];
  static const uint8_t table9_68_emit_[44];
  static const uint8_t table9_69_emit_[27];
  static const uint8_t table9_69_ops_[32];
  static const uint8_t table9_70_emit_[44];
  static const uint8_t table9_71_emit_[27];
  static const uint8_t table9_71_ops_[32];
  static const uint8_t table9_72_emit_[44];
  static const uint8_t table9_73_emit_[27];
  static const uint8_t table9_73_ops_[32];
  static const uint8_t table9_74_emit_[44];
  static const uint8_t table9_75_emit_[27];
  static const uint8_t table9_75_ops_[32];
  static const uint8_t table9_76_emit_[44];
  static const uint8_t table9_77_emit_[27];
  static const uint8_t table9_77_ops_[32];
  static const uint8_t table9_78_emit_[44];
  static const uint8_t table9_79_emit_[27];
  static const uint8_t table9_79_ops_[32];
  static const uint8_t table9_80_emit_[44];
  static const uint8_t table9_81_emit_[27];
  static const uint8_t table9_81_ops_[32];
  static const uint8_t table9_82_emit_[44];
  static const uint8_t table9_83_emit_[27];
  static const uint8_t table9_83_ops_[32];
  static const uint8_t table9_84_emit_[44];
  static const uint8_t table9_85_emit_[27];
  static const uint8_t table9_85_ops_[32];
  static const uint8_t table9_86_emit_[44];
  static const uint8_t table9_87_emit_[27];
  static const uint8_t table9_87_ops_[32];
  static const uint8_t table9_88_emit_[44];
  static const uint8_t table9_89_emit_[27];
  static const uint8_t table9_89_ops_[32];
  static const uint8_t table9_90_emit_[44];
  static const uint8_t table9_91_emit_[28];
  static const uint8_t table9_92_emit_[20];
  static const uint8_t table9_92_ops_[32];
  static const uint8_t table9_93_emit_[20];
  static const uint8_t table9_94_emit_[20];
  static const uint8_t table9_95_emit_[20];
  static const uint8_t table9_96_emit_[20];
  static const uint8_t table9_97_emit_[20];
  static const uint8_t table9_98_emit_[20];
  static const uint8_t table9_99_emit_[20];
  static const uint8_t table9_100_emit_[20];
  static const uint8_t table9_101_emit_[20];
  static const uint8_t table9_102_emit_[20];
  static const uint8_t table9_103_emit_[20];
  static const uint8_t table9_104_emit_[20];
  static const uint8_t table9_105_emit_[20];
  static const uint8_t table9_106_emit_[20];
  static const uint8_t table9_107_emit_[20];
  static const uint8_t table9_108_emit_[20];
  static const uint8_t table9_109_emit_[20];
  static const uint8_t table9_110_emit_[20];
  static const uint8_t table9_111_emit_[20];
  static const uint8_t table9_112_emit_[20];
  static const uint8_t table9_113_emit_[20];
  static const uint8_t table9_114_emit_[20];
  static const uint8_t table9_115_emit_[20];
  static const uint8_t table9_116_emit_[20];
  static const uint8_t table9_117_emit_[20];
  static const uint8_t table9_118_emit_[20];
  static const uint8_t table9_119_emit_[20];
  static const uint8_t table9_120_emit_[20];
  static const uint8_t table9_121_emit_[20];
  static const uint8_t table9_122_emit_[20];
  static const uint8_t table9_123_emit_[20];
  static const uint8_t table9_124_emit_[2];
  static const uint8_t table9_124_ops_[32];
  static const uint8_t table9_125_emit_[2];
  static const uint8_t table9_126_emit_[2];
  static const uint8_t table9_127_emit_[10];
  static const uint8_t table9_127_ops_[32];
  static const uint8_t* const table9_emit_[128];
  static const uint8_t* const table9_ops_[128];
  static const uint16_t table10_0_inner_[9];
  static const uint8_t table10_0_outer_[64];
  static const uint16_t table10_1_inner_[15];
  static const uint8_t table10_1_outer_[64];
  static const uint16_t table10_2_inner_[19];
  static const uint8_t table10_2_outer_[64];
  static const uint8_t table10_3_emit_[68];
  static const uint16_t table10_3_inner_[36];
  static const uint8_t table10_3_outer_[64];
  static const uint16_t table10_4_inner_[9];
  static const uint8_t table10_7_emit_[68];
  static const uint16_t table10_8_inner_[9];
  static const uint8_t table10_11_emit_[68];
  static const uint16_t table10_12_inner_[9];
  static const uint8_t table10_15_emit_[68];
  static const uint16_t table10_16_inner_[9];
  static const uint8_t table10_19_emit_[68];
  static const uint16_t table10_20_inner_[9];
  static const uint8_t table10_23_emit_[68];
  static const uint16_t table10_24_inner_[9];
  static const uint8_t table10_27_emit_[68];
  static const uint16_t table10_28_inner_[9];
  static const uint8_t table10_31_emit_[68];
  static const uint16_t table10_33_inner_[15];
  static const uint8_t table10_35_emit_[68];
  static const uint16_t table10_37_inner_[15];
  static const uint8_t table10_39_emit_[68];
  static const uint16_t table10_40_inner_[23];
  static const uint8_t table10_40_outer_[64];
  static const uint8_t table10_41_emit_[92];
  static const uint16_t table10_41_inner_[48];
  static const uint8_t table10_41_outer_[64];
  static const uint16_t table10_42_inner_[23];
  static const uint8_t table10_43_emit_[92];
  static const uint16_t table10_44_inner_[23];
  static const uint8_t table10_45_emit_[92];
  static const uint16_t table10_46_inner_[23];
  static const uint8_t table10_47_emit_[92];
  static const uint16_t table10_48_inner_[23];
  static const uint8_t table10_49_emit_[92];
  static const uint16_t table10_50_inner_[23];
  static const uint8_t table10_51_emit_[92];
  static const uint16_t table10_52_inner_[23];
  static const uint8_t table10_53_emit_[92];
  static const uint16_t table10_54_inner_[23];
  static const uint8_t table10_55_emit_[92];
  static const uint16_t table10_56_inner_[23];
  static const uint8_t table10_57_emit_[92];
  static const uint16_t table10_58_inner_[23];
  static const uint8_t table10_59_emit_[92];
  static const uint16_t table10_60_inner_[23];
  static const uint8_t table10_61_emit_[92];
  static const uint16_t table10_62_inner_[23];
  static const uint8_t table10_63_emit_[92];
  static const uint8_t table10_65_emit_[91];
  static const uint16_t table10_65_inner_[48];
  static const uint8_t table10_67_emit_[91];
  static const uint16_t table10_67_inner_[48];
  static const uint8_t table10_69_emit_[91];
  static const uint16_t table10_69_inner_[48];
  static const uint8_t table10_71_emit_[91];
  static const uint16_t table10_71_inner_[48];
  static const uint8_t table10_73_emit_[91];
  static const uint16_t table10_73_inner_[48];
  static const uint8_t table10_75_emit_[91];
  static const uint16_t table10_75_inner_[48];
  static const uint8_t table10_77_emit_[91];
  static const uint16_t table10_77_inner_[48];
  static const uint8_t table10_79_emit_[91];
  static const uint16_t table10_79_inner_[48];
  static const uint8_t table10_81_emit_[91];
  static const uint16_t table10_81_inner_[48];
  static const uint8_t table10_83_emit_[91];
  static const uint16_t table10_83_inner_[48];
  static const uint8_t table10_85_emit_[91];
  static const uint16_t table10_85_inner_[48];
  static const uint8_t table10_87_emit_[91];
  static const uint16_t table10_87_inner_[48];
  static const uint8_t table10_89_emit_[91];
  static const uint16_t table10_89_inner_[48];
  static const uint8_t table10_91_emit_[91];
  static const uint16_t table10_91_inner_[48];
  static const uint8_t table10_92_emit_[72];
  static const uint16_t table10_92_inner_[38];
  static const uint8_t table10_93_emit_[72];
  static const uint8_t table10_94_emit_[72];
  static const uint8_t table10_95_emit_[72];
  static const uint8_t table10_96_emit_[72];
  static const uint8_t table10_97_emit_[72];
  static const uint8_t table10_98_emit_[72];
  static const uint8_t table10_99_emit_[72];
  static const uint8_t table10_100_emit_[72];
  static const uint8_t table10_101_emit_[72];
  static const uint8_t table10_102_emit_[72];
  static const uint8_t table10_103_emit_[72];
  static const uint8_t table10_104_emit_[72];
  static const uint8_t table10_105_emit_[72];
  static const uint8_t table10_106_emit_[72];
  static const uint8_t table10_107_emit_[72];
  static const uint8_t table10_108_emit_[72];
  static const uint8_t table10_109_emit_[72];
  static const uint8_t table10_110_emit_[72];
  static const uint8_t table10_111_emit_[72];
  static const uint8_t table10_112_emit_[72];
  static const uint8_t table10_113_emit_[72];
  static const uint8_t table10_114_emit_[72];
  static const uint8_t table10_115_emit_[72];
  static const uint8_t table10_116_emit_[72];
  static const uint8_t table10_117_emit_[72];
  static const uint8_t table10_118_emit_[72];
  static const uint8_t table10_119_emit_[72];
  static const uint8_t table10_120_emit_[72];
  static const uint8_t table10_121_emit_[72];
  static const uint8_t table10_122_emit_[72];
  static const uint8_t table10_123_emit_[72];
  static const uint8_t table10_124_emit_[40];
  static const uint8_t table10_125_emit_[40];
  static const uint8_t table10_126_emit_[40];
  static const uint8_t table10_127_emit_[16];
  static const uint16_t table10_127_inner_[18];
  static const uint8_t table10_127_outer_[64];
  static const uint8_t* const table10_emit_[128];
  static const uint16_t* const table10_inner_[128];
  static const uint8_t* const table10_outer_[128];
  static const uint8_t table1_0_emit_[7];
  static const uint16_t table1_0_inner_[4];
  static const uint8_t table1_0_outer_[64];
  static const uint8_t table1_1_emit_[8];
  static const uint16_t table1_1_inner_[4];
  static const uint8_t table1_2_emit_[12];
  static const uint16_t table1_2_inner_[6];
  static const uint8_t table1_2_outer_[64];
  static const uint8_t table1_3_emit_[16];
  static const uint16_t table1_3_inner_[8];
  static const uint8_t table1_3_outer_[64];
  static const uint8_t table1_4_emit_[16];
  static const uint8_t table1_5_emit_[20];
  static const uint16_t table1_5_inner_[10];
  static const uint8_t table1_5_outer_[64];
  static const uint8_t table1_6_emit_[32];
  static const uint16_t table1_6_inner_[16];
  static const uint8_t table1_6_outer_[64];
  static const uint8_t table1_7_emit_[36];
  static const uint16_t table1_7_inner_[19];
  static const uint8_t table1_7_outer_[64];
  static const uint8_t table1_8_emit_[7];
  static const uint16_t table1_8_inner_[4];
  static const uint8_t table1_9_emit_[8];
  static const uint8_t table1_10_emit_[12];
  static const uint8_t table1_11_emit_[16];
  static const uint8_t table1_12_emit_[16];
  static const uint8_t table1_13_emit_[20];
  static const uint8_t table1_14_emit_[32];
  static const uint8_t table1_15_emit_[36];
  static const uint8_t table1_16_emit_[7];
  static const uint16_t table1_16_inner_[4];
  static const uint8_t table1_17_emit_[8];
  static const uint8_t table1_18_emit_[12];
  static const uint8_t table1_19_emit_[16];
  static const uint8_t table1_20_emit_[16];
  static const uint8_t table1_21_emit_[20];
  static const uint8_t table1_22_emit_[32];
  static const uint8_t table1_23_emit_[36];
  static const uint8_t table1_24_emit_[8];
  static const uint8_t table1_25_emit_[8];
  static const uint8_t table1_26_emit_[12];
  static const uint8_t table1_27_emit_[16];
  static const uint8_t table1_28_emit_[16];
  static const uint8_t table1_29_emit_[20];
  static const uint8_t table1_30_emit_[32];
  static const uint8_t table1_31_emit_[36];
  static const uint8_t table1_32_emit_[8];
  static const uint8_t table1_33_emit_[7];
  static const uint8_t table1_34_emit_[12];
  static const uint8_t table1_35_emit_[16];
  static const uint8_t table1_36_emit_[16];
  static const uint8_t table1_37_emit_[20];
  static const uint8_t table1_38_emit_[32];
  static const uint8_t table1_39_emit_[36];
  static const uint8_t table1_40_emit_[8];
  static const uint8_t table1_41_emit_[7];
  static const uint8_t table1_42_emit_[12];
  static const uint8_t table1_43_emit_[16];
  static const uint8_t table1_44_emit_[16];
  static const uint8_t table1_45_emit_[20];
  static const uint8_t table1_46_emit_[32];
  static const uint8_t table1_47_emit_[36];
  static const uint8_t table1_48_emit_[8];
  static const uint8_t table1_49_emit_[7];
  static const uint8_t table1_50_emit_[12];
  static const uint8_t table1_51_emit_[16];
  static const uint8_t table1_52_emit_[16];
  static const uint8_t table1_53_emit_[20];
  static const uint8_t table1_54_emit_[32];
  static const uint8_t table1_55_emit_[36];
  static const uint8_t table1_56_emit_[8];
  static const uint8_t table1_57_emit_[8];
  static const uint8_t table1_58_emit_[12];
  static const uint8_t table1_59_emit_[16];
  static const uint8_t table1_60_emit_[16];
  static const uint8_t table1_61_emit_[20];
  static const uint8_t table1_62_emit_[32];
  static const uint8_t table1_63_emit_[36];
  static const uint8_t table1_64_emit_[8];
  static const uint8_t table1_65_emit_[8];
  static const uint8_t table1_66_emit_[11];
  static const uint16_t table1_66_inner_[6];
  static const uint8_t table1_67_emit_[16];
  static const uint8_t table1_68_emit_[16];
  static const uint8_t table1_69_emit_[20];
  static const uint8_t table1_70_emit_[32];
  static const uint8_t table1_71_emit_[36];
  static const uint8_t table1_72_emit_[8];
  static const uint8_t table1_73_emit_[8];
  static const uint8_t table1_74_emit_[11];
  static const uint16_t table1_74_inner_[6];
  static const uint8_t table1_75_emit_[16];
  static const uint8_t table1_76_emit_[16];
  static const uint8_t table1_77_emit_[20];
  static const uint8_t table1_78_emit_[32];
  static const uint8_t table1_79_emit_[36];
  static const uint8_t table1_80_emit_[16];
  static const uint8_t table1_81_emit_[27];
  static const uint16_t table1_81_inner_[14];
  static const uint8_t table1_81_outer_[64];
  static const uint8_t table1_82_emit_[36];
  static const uint16_t table1_82_inner_[18];
  static const uint8_t table1_82_outer_[64];
  static const uint8_t table1_83_emit_[68];
  static const uint16_t table1_83_inner_[35];
  static const uint8_t table1_83_outer_[64];
  static const uint8_t table1_84_emit_[16];
  static const uint8_t table1_85_emit_[27];
  static const uint16_t table1_85_inner_[14];
  static const uint8_t table1_86_emit_[36];
  static const uint8_t table1_87_emit_[68];
  static const uint8_t table1_88_emit_[16];
  static const uint8_t table1_89_emit_[27];
  static const uint16_t table1_89_inner_[14];
  static const uint8_t table1_90_emit_[36];
  static const uint8_t table1_91_emit_[68];
  static const uint8_t table1_92_emit_[16];
  static const uint8_t table1_93_emit_[27];
  static const uint16_t table1_93_inner_[14];
  static const uint8_t table1_94_emit_[36];
  static const uint8_t table1_95_emit_[68];
  static const uint8_t table1_96_emit_[16];
  static const uint8_t table1_97_emit_[27];
  static const uint16_t table1_97_inner_[14];
  static const uint8_t table1_98_emit_[36];
  static const uint8_t table1_99_emit_[68];
  static const uint8_t table1_100_emit_[16];
  static const uint8_t table1_101_emit_[27];
  static const uint16_t table1_101_inner_[14];
  static const uint8_t table1_102_emit_[36];
  static const uint8_t table1_103_emit_[68];
  static const uint8_t table1_104_emit_[16];
  static const uint8_t table1_105_emit_[27];
  static const uint16_t table1_105_inner_[14];
  static const uint8_t table1_106_emit_[36];
  static const uint8_t table1_107_emit_[68];
  static const uint8_t table1_108_emit_[16];
  static const uint8_t table1_109_emit_[27];
  static const uint16_t table1_109_inner_[14];
  static const uint8_t table1_110_emit_[36];
  static const uint8_t table1_111_emit_[68];
  static const uint8_t table1_112_emit_[16];
  static const uint8_t table1_113_emit_[27];
  static const uint16_t table1_113_inner_[14];
  static const uint8_t table1_114_emit_[36];
  static const uint8_t table1_115_emit_[68];
  static const uint8_t table1_116_emit_[16];
  static const uint8_t table1_117_emit_[27];
  static const uint16_t table1_117_inner_[14];
  static const uint8_t table1_118_emit_[36];
  static const uint8_t table1_119_emit_[68];
  static const uint8_t table1_120_emit_[16];
  static const uint8_t table1_121_emit_[27];
  static const uint16_t table1_121_inner_[14];
  static const uint8_t table1_122_emit_[36];
  static const uint8_t table1_123_emit_[68];
  static const uint8_t table1_124_emit_[16];
  static const uint8_t table1_125_emit_[28];
  static const uint16_t table1_125_inner_[14];
  static const uint8_t table1_126_emit_[36];
  static const uint8_t table1_127_emit_[68];
  static const uint8_t table1_128_emit_[16];
  static const uint8_t table1_129_emit_[28];
  static const uint8_t table1_130_emit_[35];
  static const uint16_t table1_130_inner_[18];
  static const uint8_t table1_131_emit_[68];
  static const uint8_t table1_132_emit_[16];
  static const uint8_t table1_133_emit_[28];
  static const uint8_t table1_134_emit_[35];
  static const uint16_t table1_134_inner_[18];
  static const uint8_t table1_135_emit_[68];
  static const uint8_t table1_136_emit_[16];
  static const uint8_t table1_137_emit_[28];
  static const uint8_t table1_138_emit_[35];
  static const uint16_t table1_138_inner_[18];
  static const uint8_t table1_139_emit_[68];
  static const uint8_t table1_140_emit_[16];
  static const uint8_t table1_141_emit_[28];
  static const uint8_t table1_142_emit_[35];
  static const uint16_t table1_142_inner_[18];
  static const uint8_t table1_143_emit_[68];
  static const uint8_t table1_144_emit_[16];
  static const uint8_t table1_145_emit_[28];
  static const uint8_t table1_146_emit_[35];
  static const uint16_t table1_146_inner_[18];
  static const uint8_t table1_147_emit_[68];
  static const uint8_t table1_148_emit_[16];
  static const uint8_t table1_149_emit_[28];
  static const uint8_t table1_150_emit_[35];
  static const uint16_t table1_150_inner_[18];
  static const uint8_t table1_151_emit_[68];
  static const uint8_t table1_152_emit_[16];
  static const uint8_t table1_153_emit_[28];
  static const uint8_t table1_154_emit_[35];
  static const uint16_t table1_154_inner_[18];
  static const uint8_t table1_155_emit_[68];
  static const uint8_t table1_156_emit_[16];
  static const uint8_t table1_157_emit_[28];
  static const uint8_t table1_158_emit_[35];
  static const uint16_t table1_158_inner_[18];
  static const uint8_t table1_159_emit_[68];
  static const uint8_t table1_160_emit_[16];
  static const uint8_t table1_161_emit_[28];
  static const uint8_t table1_162_emit_[35];
  static const uint16_t table1_162_inner_[18];
  static const uint8_t table1_163_emit_[68];
  static const uint8_t table1_164_emit_[16];
  static const uint8_t table1_165_emit_[28];
  static const uint8_t table1_166_emit_[35];
  static const uint16_t table1_166_inner_[18];
  static const uint8_t table1_167_emit_[68];
  static const uint8_t table1_168_emit_[16];
  static const uint8_t table1_169_emit_[28];
  static const uint8_t table1_170_emit_[35];
  static const uint16_t table1_170_inner_[18];
  static const uint8_t table1_171_emit_[68];
  static const uint8_t table1_172_emit_[16];
  static const uint8_t table1_173_emit_[28];
  static const uint8_t table1_174_emit_[35];
  static const uint16_t table1_174_inner_[18];
  static const uint8_t table1_175_emit_[68];
  static const uint8_t table1_176_emit_[16];
  static const uint8_t table1_177_emit_[28];
  static const uint8_t table1_178_emit_[35];
  static const uint16_t table1_178_inner_[18];
  static const uint8_t table1_179_emit_[68];
  static const uint8_t table1_180_emit_[16];
  static const uint8_t table1_181_emit_[28];
  static const uint8_t table1_182_emit_[35];
  static const uint16_t table1_182_inner_[18];
  static const uint8_t table1_183_emit_[68];
  static const uint8_t table1_184_emit_[44];
  static const uint16_t table1_184_inner_[22];
  static const uint8_t table1_184_outer_[64];
  static const uint8_t table1_185_emit_[91];
  static const uint16_t table1_185_inner_[47];
  static const uint8_t table1_185_outer_[64];
  static const uint8_t table1_186_emit_[44];
  static const uint8_t table1_187_emit_[91];
  static const uint16_t table1_187_inner_[47];
  static const uint8_t table1_188_emit_[44];
  static const uint8_t table1_189_emit_[91];
  static const uint16_t table1_189_inner_[47];
  static const uint8_t table1_190_emit_[44];
  static const uint8_t table1_191_emit_[91];
  static const uint16_t table1_191_inner_[47];
  static const uint8_t table1_192_emit_[44];
  static const uint8_t table1_193_emit_[91];
  static const uint16_t table1_193_inner_[47];
  static const uint8_t table1_194_emit_[44];
  static const uint8_t table1_195_emit_[91];
  static const uint16_t table1_195_inner_[47];
  static const uint8_t table1_196_emit_[44];
  static const uint8_t table1_197_emit_[91];
  static const uint16_t table1_197_inner_[47];
  static const uint8_t table1_198_emit_[44];
  static const uint8_t table1_199_emit_[91];
  static const uint16_t table1_199_inner_[47];
  static const uint8_t table1_200_emit_[44];
  static const uint8_t table1_201_emit_[91];
  static const uint16_t table1_201_inner_[47];
  static const uint8_t table1_202_emit_[44];
  static const uint8_t table1_203_emit_[91];
  static const uint16_t table1_203_inner_[47];
  static const uint8_t table1_204_emit_[44];
  static const uint8_t table1_205_emit_[91];
  static const uint16_t table1_205_inner_[47];
  static const uint8_t table1_206_emit_[44];
  static const uint8_t table1_207_emit_[91];
  static const uint16_t table1_207_inner_[47];
  static const uint8_t table1_208_emit_[44];
  static const uint8_t table1_209_emit_[91];
  static const uint16_t table1_209_inner_[47];
  static const uint8_t table1_210_emit_[44];
  static const uint8_t table1_211_emit_[91];
  static const uint16_t table1_211_inner_[47];
  static const uint8_t table1_212_emit_[44];
  static const uint8_t table1_213_emit_[91];
  static const uint16_t table1_213_inner_[47];
  static const uint8_t table1_214_emit_[44];
  static const uint8_t table1_215_emit_[91];
  static const uint16_t table1_215_inner_[47];
  static const uint8_t table1_216_emit_[44];
  static const uint8_t table1_217_emit_[91];
  static const uint16_t table1_217_inner_[47];
  static const uint8_t table1_218_emit_[44];
  static const uint8_t table1_219_emit_[91];
  static const uint16_t table1_219_inner_[47];
  static const uint8_t table1_220_emit_[44];
  static const uint8_t table1_221_emit_[91];
  static const uint16_t table1_221_inner_[47];
  static const uint8_t table1_222_emit_[44];
  static const uint8_t table1_223_emit_[91];
  static const uint16_t table1_223_inner_[47];
  static const uint8_t table1_224_emit_[44];
  static const uint8_t table1_225_emit_[91];
  static const uint16_t table1_225_inner_[47];
  static const uint8_t table1_226_emit_[44];
  static const uint8_t table1_227_emit_[91];
  static const uint16_t table1_227_inner_[47];
  static const uint8_t table1_228_emit_[44];
  static const uint8_t table1_229_emit_[91];
  static const uint16_t table1_229_inner_[47];
  static const uint8_t table1_230_emit_[44];
  static const uint8_t table1_231_emit_[91];
  static const uint16_t table1_231_inner_[47];
  static const uint8_t table1_232_emit_[44];
  static const uint8_t table1_233_emit_[91];
  static const uint16_t table1_233_inner_[47];
  static const uint8_t table1_234_emit_[44];
  static const uint8_t table1_235_emit_[91];
  static const uint16_t table1_235_inner_[47];
  static const uint8_t table1_236_emit_[44];
  static const uint8_t table1_237_emit_[91];
  static const uint16_t table1_237_inner_[47];
  static const uint8_t table1_238_emit_[44];
  static const uint8_t table1_239_emit_[91];
  static const uint16_t table1_239_inner_[47];
  static const uint8_t table1_240_emit_[44];
  static const uint8_t table1_241_emit_[91];
  static const uint16_t table1_241_inner_[47];
  static const uint8_t table1_242_emit_[44];
  static const uint8_t table1_243_emit_[91];
  static const uint16_t table1_243_inner_[47];
  static const uint8_t table1_244_emit_[44];
  static const uint8_t table1_245_emit_[91];
  static const uint16_t table1_245_inner_[47];
  static const uint8_t table1_246_emit_[44];
  static const uint8_t table1_247_emit_[92];
  static const uint16_t table1_247_inner_[47];
  static const uint8_t table1_248_emit_[72];
  static const uint16_t table1_248_inner_[37];
  static const uint8_t table1_248_outer_[64];
  static const uint8_t table1_249_emit_[72];
  static const uint8_t table1_250_emit_[72];
  static const uint8_t table1_251_emit_[72];
  static const uint8_t table1_252_emit_[72];
  static const uint8_t table1_253_emit_[72];
  static const uint8_t table1_254_emit_[4];
  static const uint16_t table1_254_inner_[4];
  static const uint8_t table1_255_emit_[14];
  static const uint16_t table1_255_inner_[16];
  static const uint8_t table1_255_outer_[64];
  static const uint8_t* const table1_emit_[256];
  static const uint16_t* const table1_inner_[256];
  static const uint8_t* const table1_outer_[256];
  static const uint8_t table15_0_outer_[8];
  static const uint8_t table16_0_outer_[16];
  static const uint8_t table17_0_ops_[32];
  static const uint8_t table18_0_emit_[31];
  static const uint8_t table18_0_ops_[64];
  static const uint8_t table19_0_emit_[44];
  static const uint8_t table19_1_emit_[28];
  static const uint8_t table19_2_emit_[15];
  static const uint8_t table19_2_ops_[32];
  static const uint8_t table19_3_emit_[9];
  static const uint8_t table19_3_ops_[32];
  static const uint8_t* const table19_emit_[4];
  static const uint8_t* const table19_ops_[4];
  static const uint16_t table20_0_ops_[64];
  static const uint8_t table20_1_emit_[92];
  static const uint16_t table20_1_ops_[64];
  static const uint16_t table20_2_ops_[64];
  static const uint8_t table20_3_emit_[35];
  static const uint16_t table20_3_ops_[64];
  static const uint8_t* const table20_emit_[4];
  static const uint16_t* const table20_ops_[4];
  static const uint16_t table21_0_ops_[128];
  static const uint8_t table21_1_emit_[104];
  static const uint16_t table21_1_ops_[128];
  static const uint16_t table21_2_ops_[128];
  static const uint8_t table21_3_emit_[64];
  static const uint16_t table21_3_ops_[128];
  static const uint8_t* const table21_emit_[4];
  static const uint16_t* const table21_ops_[4];
  static const uint8_t table12_0_emit_[1];
  static const uint16_t table12_0_ops_[32];
  static const uint8_t table12_16_emit_[1];
  static const uint16_t table12_16_ops_[32];
  static const uint8_t table12_17_emit_[1];
  static const uint8_t table12_18_emit_[1];
  static const uint8_t table12_19_emit_[2];
  static const uint16_t table12_19_ops_[32];
  static const uint8_t table12_20_emit_[2];
  static const uint8_t table12_21_emit_[2];
  static const uint8_t table12_22_emit_[2];
  static const uint8_t table12_23_emit_[4];
  static const uint16_t table12_23_ops_[32];
  static const uint8_t table12_24_emit_[4];
  static const uint8_t table12_25_emit_[4];
  static const uint8_t table12_26_emit_[7];
  static const uint16_t table12_26_ops_[32];
  static const uint8_t table12_27_emit_[8];
  static const uint16_t table12_27_ops_[32];
  static const uint8_t table12_28_emit_[8];
  static const uint8_t table12_29_emit_[12];
  static const uint16_t table12_29_ops_[32];
  static const uint8_t table12_30_emit_[16];
  static const uint16_t table12_30_ops_[32];
  static const uint8_t table12_31_emit_[17];
  static const uint16_t table12_31_ops_[32];
  static const uint8_t* const table12_emit_[32];
  static const uint16_t* const table12_ops_[32];
  static const uint8_t table27_0_emit_[8];
  static const uint8_t table27_0_inner_[8];
  static const uint8_t table29_0_emit_[15];
  static const uint8_t table29_0_inner_[15];
  static const uint8_t table31_0_emit_[5];
  static const uint8_t table31_0_inner_[5];
  static const uint8_t table34_0_emit_[15];
  static const uint8_t table34_0_inner_[16];
  static const uint8_t table35_0_ops_[32];
  static const uint8_t table33_0_emit_[8];
  static const uint8_t table33_0_ops_[32];
  static const uint8_t table33_1_emit_[10];
  static const uint8_t table33_1_ops_[32];
  static const uint8_t* const table33_emit_[2];
  static const uint8_t* const table33_ops_[2];
};
template <typename F>
class HuffDecoder : public HuffDecoderCommon {
 public:
  HuffDecoder(F sink, const uint8_t* begin, const uint8_t* end)
      : sink_(sink), begin_(begin), end_(end) {}
  bool Run() {
    while (!done_) {
      if (!RefillTo14()) {
        Done0();
        break;
      }
      const auto index = (buffer_ >> (buffer_len_ - 14)) & 0x3fff;
      const auto op = GetOp1(index);
      const int consumed = op & 15;
      buffer_len_ -= consumed;
      const auto emit_ofs = op >> 6;
      switch ((op >> 4) & 3) {
        case 0: {
          sink_(GetEmit1(index, emit_ofs + 0));
          sink_(GetEmit1(index, emit_ofs + 1));
          break;
        }
        case 1: {
          sink_(GetEmit1(index, emit_ofs + 0));
          break;
        }
        case 2: {
          DecodeStep0();
          break;
        }
        case 3: {
          DecodeStep1();
          break;
        }
      }
    }
    return ok_;
  }

 private:
  bool RefillTo14() {
    switch (buffer_len_) {
      case 0: {
        return Read2to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5: {
        return Read2to7Bytes();
      }
      case 6:
      case 7:
      case 8: {
        return Read1to7Bytes();
      }
      case 9:
      case 10:
      case 11:
      case 12:
      case 13: {
        return Read1to6Bytes();
      }
    }
    return true;
  }
  bool Read2to8Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Fill2() {
    buffer_ = (buffer_ << 16) | (static_cast<uint64_t>(begin_[0]) << 8) |
              (static_cast<uint64_t>(begin_[1]) << 0);
    begin_ += 2;
    buffer_len_ += 16;
  }
  void Fill3() {
    buffer_ = (buffer_ << 24) | (static_cast<uint64_t>(begin_[0]) << 16) |
              (static_cast<uint64_t>(begin_[1]) << 8) |
              (static_cast<uint64_t>(begin_[2]) << 0);
    begin_ += 3;
    buffer_len_ += 24;
  }
  void Fill4() {
    buffer_ = (buffer_ << 32) | (static_cast<uint64_t>(begin_[0]) << 24) |
              (static_cast<uint64_t>(begin_[1]) << 16) |
              (static_cast<uint64_t>(begin_[2]) << 8) |
              (static_cast<uint64_t>(begin_[3]) << 0);
    begin_ += 4;
    buffer_len_ += 32;
  }
  void Fill5() {
    buffer_ = (buffer_ << 40) | (static_cast<uint64_t>(begin_[0]) << 32) |
              (static_cast<uint64_t>(begin_[1]) << 24) |
              (static_cast<uint64_t>(begin_[2]) << 16) |
              (static_cast<uint64_t>(begin_[3]) << 8) |
              (static_cast<uint64_t>(begin_[4]) << 0);
    begin_ += 5;
    buffer_len_ += 40;
  }
  void Fill6() {
    buffer_ = (buffer_ << 48) | (static_cast<uint64_t>(begin_[0]) << 40) |
              (static_cast<uint64_t>(begin_[1]) << 32) |
              (static_cast<uint64_t>(begin_[2]) << 24) |
              (static_cast<uint64_t>(begin_[3]) << 16) |
              (static_cast<uint64_t>(begin_[4]) << 8) |
              (static_cast<uint64_t>(begin_[5]) << 0);
    begin_ += 6;
    buffer_len_ += 48;
  }
  void Fill7() {
    buffer_ = (buffer_ << 56) | (static_cast<uint64_t>(begin_[0]) << 48) |
              (static_cast<uint64_t>(begin_[1]) << 40) |
              (static_cast<uint64_t>(begin_[2]) << 32) |
              (static_cast<uint64_t>(begin_[3]) << 24) |
              (static_cast<uint64_t>(begin_[4]) << 16) |
              (static_cast<uint64_t>(begin_[5]) << 8) |
              (static_cast<uint64_t>(begin_[6]) << 0);
    begin_ += 7;
    buffer_len_ += 56;
  }
  void Fill8() {
    buffer_ = 0 | (static_cast<uint64_t>(begin_[0]) << 56) |
              (static_cast<uint64_t>(begin_[1]) << 48) |
              (static_cast<uint64_t>(begin_[2]) << 40) |
              (static_cast<uint64_t>(begin_[3]) << 32) |
              (static_cast<uint64_t>(begin_[4]) << 24) |
              (static_cast<uint64_t>(begin_[5]) << 16) |
              (static_cast<uint64_t>(begin_[6]) << 8) |
              (static_cast<uint64_t>(begin_[7]) << 0);
    begin_ += 8;
    buffer_len_ += 64;
  }
  bool Read2to7Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  bool Read1to7Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  void Fill1() {
    buffer_ = (buffer_ << 8) | (static_cast<uint64_t>(begin_[0]) << 0);
    begin_ += 1;
    buffer_len_ += 8;
  }
  bool Read1to6Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      default: {
        Fill6();
        return true;
      }
    }
  }
  void Done0() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3:
      case 4: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp2(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit2(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp3(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit3(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp4(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit4(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp5(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit5(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp6(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit6(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 10: {
        const auto index = buffer_ & 1023;
        const auto op = GetOp7(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit7(index, (op >> 2) + 0));
            sink_(GetEmit7(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit7(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 11: {
        const auto index = buffer_ & 2047;
        const auto op = GetOp8(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit8(index, (op >> 2) + 0));
            sink_(GetEmit8(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit8(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 12: {
        const auto index = buffer_ & 4095;
        const auto op = GetOp9(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit9(index, (op >> 2) + 0));
            sink_(GetEmit9(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit9(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 13: {
        const auto index = buffer_ & 8191;
        const auto op = GetOp10(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit10(index, (op >> 2) + 0));
            sink_(GetEmit10(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit10(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep0() {
    if (!RefillTo1()) {
      Done1();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp11(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit11(index, emit_ofs + 0));
  }
  bool RefillTo1() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
    }
    return true;
  }
  bool Read1to8Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Done1() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep1() {
    if (!RefillTo10()) {
      Done2();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 10)) & 0x3ff;
    const auto op = GetOp12(index);
    const int consumed = op & 15;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 8;
    switch ((op >> 4) & 15) {
      case 0: {
        sink_(GetEmit12(index, emit_ofs + 0));
        break;
      }
      case 1: {
        DecodeStep2();
        break;
      }
      case 2: {
        DecodeStep3();
        break;
      }
      case 3: {
        DecodeStep4();
        break;
      }
      case 4: {
        DecodeStep5();
        break;
      }
      case 5: {
        DecodeStep6();
        break;
      }
      case 6: {
        DecodeStep10();
        break;
      }
      case 7: {
        DecodeStep7();
        break;
      }
      case 8: {
        DecodeStep8();
        break;
      }
      case 9: {
        DecodeStep9();
        break;
      }
      case 10: {
        DecodeStep11();
        break;
      }
    }
  }
  bool RefillTo10() {
    switch (buffer_len_) {
      case 0: {
        return Read2to8Bytes();
      }
      case 1: {
        return Read2to7Bytes();
      }
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8: {
        return Read1to7Bytes();
      }
      case 9: {
        return Read1to6Bytes();
      }
    }
    return true;
  }
  void Done2() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1: {
        const auto index = buffer_ & 1;
        const auto op = GetOp13(index);
        switch (op & 1) {
          case 0: {
            sink_(GetEmit13(index, (op >> 1) + 0));
            break;
          }
        }
        return;
      }
      case 2: {
        const auto index = buffer_ & 3;
        const auto op = GetOp14(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit14(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 3: {
        const auto index = buffer_ & 7;
        const auto op = GetOp15(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit15(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp16(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit16(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp17(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit17(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp18(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit18(index, (op >> 2) + 0));
            sink_(GetEmit18(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit18(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp19(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit19(index, (op >> 2) + 0));
            sink_(GetEmit19(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit19(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp20(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit20(index, (op >> 2) + 0));
            sink_(GetEmit20(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit20(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp21(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit21(index, (op >> 2) + 0));
            sink_(GetEmit21(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit21(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep2() {
    if (!RefillTo1()) {
      Done3();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp22(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit22(index, emit_ofs + 0));
  }
  void Done3() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep3() {
    if (!RefillTo1()) {
      Done4();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp23(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit23(index, emit_ofs + 0));
  }
  void Done4() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep4() {
    if (!RefillTo2()) {
      Done5();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp24(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit24(index, emit_ofs + 0));
  }
  bool RefillTo2() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done5() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep5() {
    if (!RefillTo2()) {
      Done6();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp25(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit25(index, emit_ofs + 0));
  }
  void Done6() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep6() {
    if (!RefillTo2()) {
      Done7();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp26(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit26(index, emit_ofs + 0));
  }
  void Done7() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep7() {
    if (!RefillTo3()) {
      Done8();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 3)) & 0x7;
    const auto op = GetOp27(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit27(index, emit_ofs + 0));
  }
  bool RefillTo3() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done8() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 2:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep8() {
    if (!RefillTo3()) {
      Done9();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 3)) & 0x7;
    const auto op = GetOp28(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit28(index, emit_ofs + 0));
  }
  void Done9() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 2:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep9() {
    if (!RefillTo4()) {
      Done10();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 4)) & 0xf;
    const auto op = GetOp29(index);
    const int consumed = op & 7;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 3;
    sink_(GetEmit29(index, emit_ofs + 0));
  }
  bool RefillTo4() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2:
      case 3: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done10() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 2:
      case 0: {
        ok_ = false;
        return;
      }
      case 3: {
        const auto index = buffer_ & 7;
        const auto op = GetOp30(index);
        switch (op & 1) {
          case 0: {
            sink_(GetEmit30(index, (op >> 1) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
    }
  }
  void DecodeStep10() {
    if (!RefillTo3()) {
      Done11();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 3)) & 0x7;
    const auto op = GetOp31(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit31(index, emit_ofs + 0));
  }
  void Done11() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
      case 2: {
        const auto index = buffer_ & 3;
        const auto op = GetOp32(index);
        switch (op & 1) {
          case 0: {
            sink_(GetEmit32(index, (op >> 1) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
    }
  }
  void DecodeStep11() {
    if (!RefillTo6()) {
      Done12();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 6)) & 0x3f;
    const auto op = GetOp33(index);
    const int consumed = op & 7;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 4;
    switch ((op >> 3) & 1) {
      case 0: {
        sink_(GetEmit33(index, emit_ofs + 0));
        break;
      }
      case 1: {
        begin_ = end_;
        buffer_len_ = 0;
        break;
      }
    }
  }
  bool RefillTo6() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done12() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp34(index);
        switch (op & 1) {
          case 0: {
            sink_(GetEmit34(index, (op >> 1) + 0));
            break;
          }
        }
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp35(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit35(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  F sink_;
  const uint8_t* begin_;
  const uint8_t* const end_;
  uint64_t buffer_ = 0;
  int buffer_len_ = 0;
  bool ok_ = true;
  bool done_ = false;
};
}  // namespace geometry_14_10_6
}  // namespace grpc_core
#endif  // GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_14_10_6_H
