// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#ifndef GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_13_15_H
#define GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_13_15_H
#include <cstddef>
#include <cstdint>

#include <grpc/support/port_platform.h>
namespace grpc_core {
namespace geometry_13_15 {
class HuffDecoderCommon {
 protected:
  static inline uint64_t GetOp2(size_t i) { return table2_0_ops_[i]; }
  static inline uint64_t GetEmit2(size_t, size_t emit) {
    return table2_0_emit_[emit];
  }
  static inline uint64_t GetOp3(size_t i) { return table3_0_ops_[i]; }
  static inline uint64_t GetEmit3(size_t, size_t emit) {
    return table3_0_emit_[emit];
  }
  static inline uint64_t GetOp4(size_t i) {
    return table4_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit4(size_t i, size_t emit) {
    return table4_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp5(size_t i) {
    return table5_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit5(size_t i, size_t emit) {
    return table5_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp6(size_t i) {
    return table6_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit6(size_t i, size_t emit) {
    return table6_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp7(size_t i) {
    return table7_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit7(size_t i, size_t emit) {
    return table7_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp8(size_t i) {
    return table8_inner_[i >> 6][table8_outer_[i >> 6][i & 0x3f]];
  }
  static inline uint64_t GetEmit8(size_t i, size_t emit) {
    return table8_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp9(size_t i) {
    return table9_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit9(size_t i, size_t emit) {
    return table9_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp1(size_t i) {
    return table1_inner_[i >> 6][table1_outer_[i >> 6][i & 0x3f]];
  }
  static inline uint64_t GetEmit1(size_t i, size_t emit) {
    return table1_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp10(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit10(size_t, size_t emit) {
    return emit ? 125 : 94;
  }
  static inline uint64_t GetOp12(size_t i) {
    return (i < 2 ? (i ? 2 : 0) : ((i - 2) ? 1 : 4));
  }
  static inline uint64_t GetEmit12(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 60)) : ((emit - 1) ? 123 : 96));
  }
  static inline uint64_t GetOp13(size_t i) {
    return table13_0_inner_[table13_0_outer_[i]];
  }
  static inline uint64_t GetEmit13(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 60)) : ((emit - 1) ? 123 : 96));
  }
  static inline uint64_t GetOp14(size_t i) {
    return table13_0_inner_[table14_0_outer_[i]];
  }
  static inline uint64_t GetEmit14(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 60)) : ((emit - 1) ? 123 : 96));
  }
  static inline uint64_t GetOp15(size_t i) { return table15_0_ops_[i]; }
  static inline uint64_t GetEmit15(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 60)) : ((emit - 1) ? 123 : 96));
  }
  static inline uint64_t GetOp16(size_t i) { return table16_0_ops_[i]; }
  static inline uint64_t GetEmit16(size_t, size_t emit) {
    return table16_0_emit_[emit];
  }
  static inline uint64_t GetOp17(size_t i) {
    return table17_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit17(size_t i, size_t emit) {
    return table17_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp18(size_t i) {
    return table18_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit18(size_t i, size_t emit) {
    return table18_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp19(size_t i) {
    return table19_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit19(size_t i, size_t emit) {
    return table19_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp20(size_t i) {
    return table20_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit20(size_t i, size_t emit) {
    return table20_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp21(size_t i) {
    return table21_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit21(size_t i, size_t emit) {
    return table21_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp22(size_t i) {
    return table22_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit22(size_t i, size_t emit) {
    return table22_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp23(size_t i) {
    return table23_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit23(size_t i, size_t emit) {
    return table23_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp24(size_t i) {
    return table24_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit24(size_t i, size_t emit) {
    return table24_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp11(size_t i) {
    return table11_ops_[i >> 8][i & 0xff];
  }
  static inline uint64_t GetEmit11(size_t i, size_t emit) {
    return table11_emit_[i >> 8][emit];
  }
  static inline uint64_t GetOp25(size_t i) {
    return (i < 2 ? (i ? 10 : 2) : ((i - 2) ? 6 : 18));
  }
  static inline uint64_t GetEmit25(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 10)) : ((emit - 1) ? 22 : 13));
  }

 private:
  static const uint8_t table2_0_emit_[10];
  static const uint8_t table2_0_ops_[32];
  static const uint8_t table3_0_emit_[36];
  static const uint8_t table3_0_ops_[64];
  static const uint8_t table4_0_emit_[22];
  static const uint8_t table4_0_ops_[64];
  static const uint8_t table4_1_emit_[46];
  static const uint8_t table4_1_ops_[64];
  static const uint8_t* const table4_emit_[2];
  static const uint8_t* const table4_ops_[2];
  static const uint8_t table5_0_ops_[128];
  static const uint8_t table5_1_emit_[52];
  static const uint8_t table5_1_ops_[128];
  static const uint8_t* const table5_emit_[2];
  static const uint8_t* const table5_ops_[2];
  static const uint8_t table6_0_emit_[2];
  static const uint8_t table6_0_ops_[32];
  static const uint8_t table6_1_emit_[2];
  static const uint8_t table6_2_emit_[2];
  static const uint8_t table6_3_emit_[2];
  static const uint8_t table6_4_emit_[2];
  static const uint8_t table6_5_emit_[4];
  static const uint8_t table6_5_ops_[32];
  static const uint8_t table6_6_emit_[4];
  static const uint8_t table6_7_emit_[4];
  static const uint8_t table6_8_emit_[4];
  static const uint8_t table6_9_emit_[4];
  static const uint8_t table6_10_emit_[4];
  static const uint8_t table6_11_emit_[6];
  static const uint8_t table6_11_ops_[32];
  static const uint8_t table6_12_emit_[8];
  static const uint8_t table6_12_ops_[32];
  static const uint8_t table6_13_emit_[8];
  static const uint8_t table6_14_emit_[8];
  static const uint8_t table6_15_emit_[10];
  static const uint8_t table6_15_ops_[32];
  static const uint8_t* const table6_emit_[16];
  static const uint8_t* const table6_ops_[16];
  static const uint8_t table7_0_emit_[36];
  static const uint8_t table7_0_ops_[64];
  static const uint8_t table7_1_emit_[36];
  static const uint8_t table7_1_ops_[64];
  static const uint8_t table7_2_emit_[36];
  static const uint8_t table7_2_ops_[64];
  static const uint8_t table7_3_emit_[36];
  static const uint8_t table7_3_ops_[64];
  static const uint8_t table7_4_emit_[38];
  static const uint8_t table7_4_ops_[64];
  static const uint8_t table7_5_ops_[64];
  static const uint8_t table7_11_ops_[64];
  static const uint8_t table7_12_ops_[64];
  static const uint8_t table7_15_emit_[15];
  static const uint8_t table7_15_ops_[64];
  static const uint8_t* const table7_emit_[16];
  static const uint8_t* const table7_ops_[16];
  static const uint8_t table8_0_emit_[71];
  static const uint16_t table8_0_inner_[38];
  static const uint8_t table8_0_outer_[64];
  static const uint8_t table8_1_emit_[71];
  static const uint16_t table8_1_inner_[38];
  static const uint8_t table8_2_emit_[71];
  static const uint16_t table8_2_inner_[38];
  static const uint8_t table8_3_emit_[71];
  static const uint16_t table8_3_inner_[38];
  static const uint8_t table8_4_emit_[71];
  static const uint16_t table8_4_inner_[38];
  static const uint8_t table8_5_emit_[71];
  static const uint16_t table8_5_inner_[38];
  static const uint8_t table8_6_emit_[71];
  static const uint16_t table8_6_inner_[38];
  static const uint8_t table8_7_emit_[71];
  static const uint16_t table8_7_inner_[38];
  static const uint8_t table8_8_emit_[71];
  static const uint16_t table8_8_inner_[38];
  static const uint8_t table8_9_emit_[71];
  static const uint16_t table8_9_inner_[38];
  static const uint8_t table8_10_emit_[40];
  static const uint16_t table8_10_inner_[23];
  static const uint8_t table8_10_outer_[64];
  static const uint8_t table8_11_emit_[40];
  static const uint8_t table8_12_emit_[40];
  static const uint8_t table8_13_emit_[40];
  static const uint8_t table8_14_emit_[40];
  static const uint8_t table8_15_emit_[40];
  static const uint8_t table8_16_emit_[40];
  static const uint8_t table8_17_emit_[40];
  static const uint8_t table8_18_emit_[40];
  static const uint8_t table8_19_emit_[40];
  static const uint8_t table8_20_emit_[40];
  static const uint8_t table8_21_emit_[40];
  static const uint8_t table8_22_emit_[40];
  static const uint8_t table8_23_emit_[4];
  static const uint16_t table8_23_inner_[5];
  static const uint8_t table8_23_outer_[64];
  static const uint8_t table8_24_emit_[4];
  static const uint8_t table8_25_emit_[4];
  static const uint8_t table8_26_emit_[4];
  static const uint8_t table8_27_emit_[4];
  static const uint8_t table8_28_emit_[4];
  static const uint8_t table8_29_emit_[4];
  static const uint8_t table8_30_emit_[4];
  static const uint8_t table8_31_emit_[14];
  static const uint16_t table8_31_inner_[16];
  static const uint8_t table8_31_outer_[64];
  static const uint8_t* const table8_emit_[32];
  static const uint16_t* const table8_inner_[32];
  static const uint8_t* const table8_outer_[32];
  static const uint8_t table9_0_emit_[15];
  static const uint8_t table9_0_ops_[32];
  static const uint8_t table9_1_emit_[28];
  static const uint8_t table9_1_ops_[32];
  static const uint8_t table9_2_emit_[36];
  static const uint8_t table9_2_ops_[32];
  static const uint8_t table9_3_emit_[56];
  static const uint8_t table9_3_ops_[32];
  static const uint8_t table9_4_emit_[15];
  static const uint8_t table9_4_ops_[32];
  static const uint8_t table9_5_emit_[28];
  static const uint8_t table9_6_emit_[36];
  static const uint8_t table9_7_emit_[56];
  static const uint8_t table9_8_emit_[15];
  static const uint8_t table9_8_ops_[32];
  static const uint8_t table9_9_emit_[28];
  static const uint8_t table9_10_emit_[36];
  static const uint8_t table9_11_emit_[56];
  static const uint8_t table9_12_emit_[15];
  static const uint8_t table9_12_ops_[32];
  static const uint8_t table9_13_emit_[28];
  static const uint8_t table9_14_emit_[36];
  static const uint8_t table9_15_emit_[56];
  static const uint8_t table9_16_emit_[15];
  static const uint8_t table9_16_ops_[32];
  static const uint8_t table9_17_emit_[28];
  static const uint8_t table9_18_emit_[36];
  static const uint8_t table9_19_emit_[56];
  static const uint8_t table9_20_emit_[15];
  static const uint8_t table9_20_ops_[32];
  static const uint8_t table9_21_emit_[28];
  static const uint8_t table9_22_emit_[36];
  static const uint8_t table9_23_emit_[56];
  static const uint8_t table9_24_emit_[15];
  static const uint8_t table9_24_ops_[32];
  static const uint8_t table9_25_emit_[28];
  static const uint8_t table9_26_emit_[36];
  static const uint8_t table9_27_emit_[56];
  static const uint8_t table9_28_emit_[16];
  static const uint8_t table9_28_ops_[32];
  static const uint8_t table9_29_emit_[28];
  static const uint8_t table9_30_emit_[36];
  static const uint8_t table9_31_emit_[56];
  static const uint8_t table9_32_emit_[16];
  static const uint8_t table9_33_emit_[27];
  static const uint8_t table9_33_ops_[32];
  static const uint8_t table9_34_emit_[36];
  static const uint8_t table9_35_emit_[56];
  static const uint8_t table9_36_emit_[16];
  static const uint8_t table9_37_emit_[27];
  static const uint8_t table9_37_ops_[32];
  static const uint8_t table9_38_emit_[36];
  static const uint8_t table9_39_emit_[56];
  static const uint8_t table9_40_emit_[43];
  static const uint8_t table9_40_ops_[32];
  static const uint8_t table9_41_emit_[28];
  static const uint8_t table9_41_ops_[32];
  static const uint8_t table9_42_emit_[43];
  static const uint8_t table9_42_ops_[32];
  static const uint8_t table9_43_emit_[28];
  static const uint8_t table9_44_emit_[43];
  static const uint8_t table9_44_ops_[32];
  static const uint8_t table9_45_emit_[28];
  static const uint8_t table9_46_emit_[43];
  static const uint8_t table9_46_ops_[32];
  static const uint8_t table9_47_emit_[28];
  static const uint8_t table9_48_emit_[43];
  static const uint8_t table9_48_ops_[32];
  static const uint8_t table9_49_emit_[28];
  static const uint8_t table9_50_emit_[43];
  static const uint8_t table9_50_ops_[32];
  static const uint8_t table9_51_emit_[28];
  static const uint8_t table9_52_emit_[43];
  static const uint8_t table9_52_ops_[32];
  static const uint8_t table9_53_emit_[28];
  static const uint8_t table9_54_emit_[43];
  static const uint8_t table9_54_ops_[32];
  static const uint8_t table9_55_emit_[28];
  static const uint8_t table9_56_emit_[43];
  static const uint8_t table9_56_ops_[32];
  static const uint8_t table9_57_emit_[28];
  static const uint8_t table9_58_emit_[43];
  static const uint8_t table9_58_ops_[32];
  static const uint8_t table9_59_emit_[28];
  static const uint8_t table9_60_emit_[43];
  static const uint8_t table9_60_ops_[32];
  static const uint8_t table9_61_emit_[28];
  static const uint8_t table9_62_emit_[44];
  static const uint8_t table9_62_ops_[32];
  static const uint8_t table9_63_emit_[28];
  static const uint8_t table9_64_emit_[44];
  static const uint8_t table9_65_emit_[27];
  static const uint8_t table9_65_ops_[32];
  static const uint8_t table9_66_emit_[44];
  static const uint8_t table9_67_emit_[27];
  static const uint8_t table9_67_ops_[32];
  static const uint8_t table9_68_emit_[44];
  static const uint8_t table9_69_emit_[27];
  static const uint8_t table9_69_ops_[32];
  static const uint8_t table9_70_emit_[44];
  static const uint8_t table9_71_emit_[27];
  static const uint8_t table9_71_ops_[32];
  static const uint8_t table9_72_emit_[44];
  static const uint8_t table9_73_emit_[27];
  static const uint8_t table9_73_ops_[32];
  static const uint8_t table9_74_emit_[44];
  static const uint8_t table9_75_emit_[27];
  static const uint8_t table9_75_ops_[32];
  static const uint8_t table9_76_emit_[44];
  static const uint8_t table9_77_emit_[27];
  static const uint8_t table9_77_ops_[32];
  static const uint8_t table9_78_emit_[44];
  static const uint8_t table9_79_emit_[27];
  static const uint8_t table9_79_ops_[32];
  static const uint8_t table9_80_emit_[44];
  static const uint8_t table9_81_emit_[27];
  static const uint8_t table9_81_ops_[32];
  static const uint8_t table9_82_emit_[44];
  static const uint8_t table9_83_emit_[27];
  static const uint8_t table9_83_ops_[32];
  static const uint8_t table9_84_emit_[44];
  static const uint8_t table9_85_emit_[27];
  static const uint8_t table9_85_ops_[32];
  static const uint8_t table9_86_emit_[44];
  static const uint8_t table9_87_emit_[27];
  static const uint8_t table9_87_ops_[32];
  static const uint8_t table9_88_emit_[44];
  static const uint8_t table9_89_emit_[27];
  static const uint8_t table9_89_ops_[32];
  static const uint8_t table9_90_emit_[44];
  static const uint8_t table9_91_emit_[28];
  static const uint8_t table9_92_emit_[20];
  static const uint8_t table9_92_ops_[32];
  static const uint8_t table9_93_emit_[20];
  static const uint8_t table9_94_emit_[20];
  static const uint8_t table9_95_emit_[20];
  static const uint8_t table9_96_emit_[20];
  static const uint8_t table9_97_emit_[20];
  static const uint8_t table9_98_emit_[20];
  static const uint8_t table9_99_emit_[20];
  static const uint8_t table9_100_emit_[20];
  static const uint8_t table9_101_emit_[20];
  static const uint8_t table9_102_emit_[20];
  static const uint8_t table9_103_emit_[20];
  static const uint8_t table9_104_emit_[20];
  static const uint8_t table9_105_emit_[20];
  static const uint8_t table9_106_emit_[20];
  static const uint8_t table9_107_emit_[20];
  static const uint8_t table9_108_emit_[20];
  static const uint8_t table9_109_emit_[20];
  static const uint8_t table9_110_emit_[20];
  static const uint8_t table9_111_emit_[20];
  static const uint8_t table9_112_emit_[20];
  static const uint8_t table9_113_emit_[20];
  static const uint8_t table9_114_emit_[20];
  static const uint8_t table9_115_emit_[20];
  static const uint8_t table9_116_emit_[20];
  static const uint8_t table9_117_emit_[20];
  static const uint8_t table9_118_emit_[20];
  static const uint8_t table9_119_emit_[20];
  static const uint8_t table9_120_emit_[20];
  static const uint8_t table9_121_emit_[20];
  static const uint8_t table9_122_emit_[20];
  static const uint8_t table9_123_emit_[20];
  static const uint8_t table9_124_emit_[2];
  static const uint8_t table9_124_ops_[32];
  static const uint8_t table9_125_emit_[2];
  static const uint8_t table9_126_emit_[2];
  static const uint8_t table9_127_emit_[10];
  static const uint8_t table9_127_ops_[32];
  static const uint8_t* const table9_emit_[128];
  static const uint8_t* const table9_ops_[128];
  static const uint16_t table1_0_inner_[8];
  static const uint8_t table1_0_outer_[64];
  static const uint16_t table1_1_inner_[14];
  static const uint8_t table1_1_outer_[64];
  static const uint16_t table1_2_inner_[18];
  static const uint8_t table1_2_outer_[64];
  static const uint8_t table1_3_emit_[68];
  static const uint16_t table1_3_inner_[35];
  static const uint8_t table1_3_outer_[64];
  static const uint16_t table1_4_inner_[8];
  static const uint8_t table1_7_emit_[68];
  static const uint16_t table1_8_inner_[8];
  static const uint8_t table1_11_emit_[68];
  static const uint16_t table1_12_inner_[8];
  static const uint8_t table1_15_emit_[68];
  static const uint16_t table1_16_inner_[8];
  static const uint8_t table1_19_emit_[68];
  static const uint16_t table1_20_inner_[8];
  static const uint8_t table1_23_emit_[68];
  static const uint16_t table1_24_inner_[8];
  static const uint8_t table1_27_emit_[68];
  static const uint16_t table1_28_inner_[8];
  static const uint8_t table1_31_emit_[68];
  static const uint16_t table1_33_inner_[14];
  static const uint8_t table1_35_emit_[68];
  static const uint16_t table1_37_inner_[14];
  static const uint8_t table1_39_emit_[68];
  static const uint16_t table1_40_inner_[22];
  static const uint8_t table1_40_outer_[64];
  static const uint8_t table1_41_emit_[92];
  static const uint16_t table1_41_inner_[47];
  static const uint8_t table1_41_outer_[64];
  static const uint16_t table1_42_inner_[22];
  static const uint8_t table1_43_emit_[92];
  static const uint16_t table1_44_inner_[22];
  static const uint8_t table1_45_emit_[92];
  static const uint16_t table1_46_inner_[22];
  static const uint8_t table1_47_emit_[92];
  static const uint16_t table1_48_inner_[22];
  static const uint8_t table1_49_emit_[92];
  static const uint16_t table1_50_inner_[22];
  static const uint8_t table1_51_emit_[92];
  static const uint16_t table1_52_inner_[22];
  static const uint8_t table1_53_emit_[92];
  static const uint16_t table1_54_inner_[22];
  static const uint8_t table1_55_emit_[92];
  static const uint16_t table1_56_inner_[22];
  static const uint8_t table1_57_emit_[92];
  static const uint16_t table1_58_inner_[22];
  static const uint8_t table1_59_emit_[92];
  static const uint16_t table1_60_inner_[22];
  static const uint8_t table1_61_emit_[92];
  static const uint16_t table1_62_inner_[22];
  static const uint8_t table1_63_emit_[92];
  static const uint8_t table1_65_emit_[91];
  static const uint16_t table1_65_inner_[47];
  static const uint8_t table1_67_emit_[91];
  static const uint16_t table1_67_inner_[47];
  static const uint8_t table1_69_emit_[91];
  static const uint16_t table1_69_inner_[47];
  static const uint8_t table1_71_emit_[91];
  static const uint16_t table1_71_inner_[47];
  static const uint8_t table1_73_emit_[91];
  static const uint16_t table1_73_inner_[47];
  static const uint8_t table1_75_emit_[91];
  static const uint16_t table1_75_inner_[47];
  static const uint8_t table1_77_emit_[91];
  static const uint16_t table1_77_inner_[47];
  static const uint8_t table1_79_emit_[91];
  static const uint16_t table1_79_inner_[47];
  static const uint8_t table1_81_emit_[91];
  static const uint16_t table1_81_inner_[47];
  static const uint8_t table1_83_emit_[91];
  static const uint16_t table1_83_inner_[47];
  static const uint8_t table1_85_emit_[91];
  static const uint16_t table1_85_inner_[47];
  static const uint8_t table1_87_emit_[91];
  static const uint16_t table1_87_inner_[47];
  static const uint8_t table1_89_emit_[91];
  static const uint16_t table1_89_inner_[47];
  static const uint8_t table1_91_emit_[91];
  static const uint16_t table1_91_inner_[47];
  static const uint8_t table1_92_emit_[72];
  static const uint16_t table1_92_inner_[37];
  static const uint8_t table1_92_outer_[64];
  static const uint8_t table1_93_emit_[72];
  static const uint8_t table1_94_emit_[72];
  static const uint8_t table1_95_emit_[72];
  static const uint8_t table1_96_emit_[72];
  static const uint8_t table1_97_emit_[72];
  static const uint8_t table1_98_emit_[72];
  static const uint8_t table1_99_emit_[72];
  static const uint8_t table1_100_emit_[72];
  static const uint8_t table1_101_emit_[72];
  static const uint8_t table1_102_emit_[72];
  static const uint8_t table1_103_emit_[72];
  static const uint8_t table1_104_emit_[72];
  static const uint8_t table1_105_emit_[72];
  static const uint8_t table1_106_emit_[72];
  static const uint8_t table1_107_emit_[72];
  static const uint8_t table1_108_emit_[72];
  static const uint8_t table1_109_emit_[72];
  static const uint8_t table1_110_emit_[72];
  static const uint8_t table1_111_emit_[72];
  static const uint8_t table1_112_emit_[72];
  static const uint8_t table1_113_emit_[72];
  static const uint8_t table1_114_emit_[72];
  static const uint8_t table1_115_emit_[72];
  static const uint8_t table1_116_emit_[72];
  static const uint8_t table1_117_emit_[72];
  static const uint8_t table1_118_emit_[72];
  static const uint8_t table1_119_emit_[72];
  static const uint8_t table1_120_emit_[72];
  static const uint8_t table1_121_emit_[72];
  static const uint8_t table1_122_emit_[72];
  static const uint8_t table1_123_emit_[72];
  static const uint8_t table1_124_emit_[40];
  static const uint16_t table1_124_inner_[22];
  static const uint8_t table1_124_outer_[64];
  static const uint8_t table1_125_emit_[40];
  static const uint8_t table1_126_emit_[40];
  static const uint8_t table1_127_emit_[16];
  static const uint16_t table1_127_inner_[18];
  static const uint8_t table1_127_outer_[64];
  static const uint8_t* const table1_emit_[128];
  static const uint16_t* const table1_inner_[128];
  static const uint8_t* const table1_outer_[128];
  static const uint8_t table13_0_inner_[5];
  static const uint8_t table13_0_outer_[8];
  static const uint8_t table14_0_outer_[16];
  static const uint8_t table15_0_ops_[32];
  static const uint8_t table16_0_emit_[6];
  static const uint8_t table16_0_ops_[64];
  static const uint8_t table17_0_emit_[20];
  static const uint8_t table17_0_ops_[32];
  static const uint8_t table17_1_emit_[20];
  static const uint8_t table17_2_emit_[20];
  static const uint8_t table17_3_emit_[11];
  static const uint8_t table17_3_ops_[32];
  static const uint8_t* const table17_emit_[4];
  static const uint8_t* const table17_ops_[4];
  static const uint8_t table18_0_emit_[72];
  static const uint16_t table18_0_ops_[64];
  static const uint8_t table18_1_emit_[72];
  static const uint8_t table18_2_emit_[72];
  static const uint8_t table18_3_emit_[24];
  static const uint16_t table18_3_ops_[64];
  static const uint8_t* const table18_emit_[4];
  static const uint16_t* const table18_ops_[4];
  static const uint8_t table19_0_emit_[136];
  static const uint16_t table19_0_ops_[128];
  static const uint8_t table19_1_emit_[136];
  static const uint8_t table19_2_emit_[136];
  static const uint8_t table19_3_emit_[50];
  static const uint16_t table19_3_ops_[128];
  static const uint8_t* const table19_emit_[4];
  static const uint16_t* const table19_ops_[4];
  static const uint8_t table20_0_emit_[44];
  static const uint16_t table20_0_ops_[128];
  static const uint8_t table20_1_emit_[104];
  static const uint16_t table20_1_ops_[128];
  static const uint8_t table20_2_emit_[44];
  static const uint8_t table20_3_emit_[104];
  static const uint8_t table20_4_emit_[44];
  static const uint8_t table20_5_emit_[104];
  static const uint8_t table20_6_emit_[15];
  static const uint16_t table20_6_ops_[128];
  static const uint8_t table20_7_emit_[64];
  static const uint16_t table20_7_ops_[128];
  static const uint8_t* const table20_emit_[8];
  static const uint16_t* const table20_ops_[8];
  static const uint8_t table21_0_emit_[16];
  static const uint16_t table21_0_ops_[128];
  static const uint8_t table21_1_emit_[28];
  static const uint16_t table21_1_ops_[128];
  static const uint8_t table21_2_emit_[36];
  static const uint16_t table21_2_ops_[128];
  static const uint8_t table21_3_emit_[68];
  static const uint16_t table21_3_ops_[128];
  static const uint8_t table21_4_emit_[16];
  static const uint8_t table21_5_emit_[28];
  static const uint8_t table21_6_emit_[36];
  static const uint8_t table21_7_emit_[68];
  static const uint8_t table21_8_emit_[16];
  static const uint8_t table21_9_emit_[28];
  static const uint8_t table21_10_emit_[36];
  static const uint8_t table21_11_emit_[68];
  static const uint8_t table21_12_emit_[62];
  static const uint16_t table21_12_ops_[128];
  static const uint8_t table21_13_emit_[10];
  static const uint16_t table21_13_ops_[128];
  static const uint8_t table21_14_emit_[23];
  static const uint16_t table21_14_ops_[128];
  static const uint8_t table21_15_emit_[53];
  static const uint16_t table21_15_ops_[128];
  static const uint8_t* const table21_emit_[16];
  static const uint16_t* const table21_ops_[16];
  static const uint8_t table22_0_emit_[60];
  static const uint16_t table22_0_ops_[64];
  static const uint8_t table22_1_emit_[60];
  static const uint8_t table22_2_emit_[60];
  static const uint8_t table22_3_emit_[60];
  static const uint8_t table22_4_emit_[60];
  static const uint8_t table22_5_emit_[8];
  static const uint16_t table22_5_ops_[64];
  static const uint8_t table22_6_emit_[8];
  static const uint8_t table22_7_emit_[8];
  static const uint8_t table22_8_emit_[8];
  static const uint8_t table22_9_emit_[8];
  static const uint8_t table22_10_emit_[8];
  static const uint8_t table22_11_emit_[12];
  static const uint16_t table22_11_ops_[64];
  static const uint8_t table22_12_emit_[16];
  static const uint16_t table22_12_ops_[64];
  static const uint8_t table22_13_emit_[16];
  static const uint8_t table22_14_emit_[16];
  static const uint8_t table22_15_emit_[30];
  static const uint16_t table22_15_ops_[64];
  static const uint8_t table22_16_emit_[60];
  static const uint8_t table22_17_emit_[60];
  static const uint8_t table22_18_emit_[60];
  static const uint8_t table22_19_emit_[60];
  static const uint8_t table22_20_emit_[60];
  static const uint8_t table22_21_emit_[8];
  static const uint8_t table22_22_emit_[8];
  static const uint8_t table22_23_emit_[8];
  static const uint8_t table22_24_emit_[8];
  static const uint8_t table22_25_emit_[8];
  static const uint8_t table22_26_emit_[8];
  static const uint8_t table22_27_emit_[12];
  static const uint8_t table22_28_emit_[16];
  static const uint8_t table22_29_emit_[16];
  static const uint8_t table22_30_emit_[16];
  static const uint8_t table22_31_emit_[30];
  static const uint8_t table22_32_emit_[60];
  static const uint8_t table22_33_emit_[60];
  static const uint8_t table22_34_emit_[60];
  static const uint8_t table22_35_emit_[60];
  static const uint8_t table22_36_emit_[60];
  static const uint8_t table22_37_emit_[8];
  static const uint8_t table22_38_emit_[8];
  static const uint8_t table22_39_emit_[8];
  static const uint8_t table22_40_emit_[8];
  static const uint8_t table22_41_emit_[8];
  static const uint8_t table22_42_emit_[8];
  static const uint8_t table22_43_emit_[12];
  static const uint8_t table22_44_emit_[16];
  static const uint8_t table22_45_emit_[16];
  static const uint8_t table22_46_emit_[16];
  static const uint8_t table22_47_emit_[30];
  static const uint8_t table22_48_emit_[72];
  static const uint16_t table22_48_ops_[64];
  static const uint8_t table22_49_emit_[72];
  static const uint8_t table22_50_emit_[72];
  static const uint8_t table22_51_emit_[40];
  static const uint16_t table22_51_ops_[64];
  static const uint8_t table22_52_emit_[40];
  static const uint8_t table22_53_emit_[40];
  static const uint8_t table22_54_emit_[40];
  static const uint8_t table22_55_emit_[4];
  static const uint16_t table22_55_ops_[64];
  static const uint8_t table22_56_emit_[4];
  static const uint8_t table22_57_emit_[4];
  static const uint8_t table22_58_emit_[7];
  static const uint16_t table22_58_ops_[64];
  static const uint8_t table22_59_emit_[8];
  static const uint16_t table22_59_ops_[64];
  static const uint8_t table22_60_emit_[8];
  static const uint8_t table22_61_emit_[12];
  static const uint16_t table22_61_ops_[64];
  static const uint8_t table22_62_emit_[16];
  static const uint16_t table22_62_ops_[64];
  static const uint8_t table22_63_emit_[21];
  static const uint16_t table22_63_ops_[64];
  static const uint8_t* const table22_emit_[64];
  static const uint16_t* const table22_ops_[64];
  static const uint8_t table23_0_emit_[216];
  static const uint16_t table23_0_ops_[128];
  static const uint8_t table23_1_emit_[216];
  static const uint8_t table23_2_emit_[216];
  static const uint8_t table23_3_emit_[216];
  static const uint8_t table23_4_emit_[216];
  static const uint8_t table23_5_emit_[120];
  static const uint16_t table23_5_ops_[128];
  static const uint8_t table23_6_emit_[120];
  static const uint8_t table23_7_emit_[120];
  static const uint8_t table23_8_emit_[120];
  static const uint8_t table23_9_emit_[120];
  static const uint8_t table23_10_emit_[120];
  static const uint8_t table23_11_emit_[68];
  static const uint16_t table23_11_ops_[128];
  static const uint16_t table23_12_ops_[128];
  static const uint8_t table23_15_emit_[36];
  static const uint16_t table23_15_ops_[128];
  static const uint8_t table23_16_emit_[216];
  static const uint8_t table23_17_emit_[216];
  static const uint8_t table23_18_emit_[216];
  static const uint8_t table23_19_emit_[216];
  static const uint8_t table23_20_emit_[216];
  static const uint8_t table23_21_emit_[120];
  static const uint8_t table23_22_emit_[120];
  static const uint8_t table23_23_emit_[120];
  static const uint8_t table23_24_emit_[120];
  static const uint8_t table23_25_emit_[120];
  static const uint8_t table23_26_emit_[120];
  static const uint8_t table23_27_emit_[68];
  static const uint8_t table23_31_emit_[36];
  static const uint8_t table23_32_emit_[216];
  static const uint8_t table23_33_emit_[216];
  static const uint8_t table23_34_emit_[216];
  static const uint8_t table23_35_emit_[216];
  static const uint8_t table23_36_emit_[216];
  static const uint8_t table23_37_emit_[120];
  static const uint8_t table23_38_emit_[120];
  static const uint8_t table23_39_emit_[120];
  static const uint8_t table23_40_emit_[120];
  static const uint8_t table23_41_emit_[120];
  static const uint8_t table23_42_emit_[120];
  static const uint8_t table23_43_emit_[68];
  static const uint8_t table23_47_emit_[36];
  static const uint8_t table23_48_emit_[136];
  static const uint16_t table23_48_ops_[128];
  static const uint8_t table23_49_emit_[136];
  static const uint8_t table23_50_emit_[136];
  static const uint8_t table23_51_emit_[144];
  static const uint16_t table23_51_ops_[128];
  static const uint8_t table23_52_emit_[144];
  static const uint8_t table23_53_emit_[144];
  static const uint8_t table23_54_emit_[144];
  static const uint8_t table23_55_emit_[80];
  static const uint16_t table23_55_ops_[128];
  static const uint8_t table23_56_emit_[80];
  static const uint8_t table23_57_emit_[80];
  static const uint8_t table23_58_emit_[26];
  static const uint16_t table23_58_ops_[128];
  static const uint16_t table23_59_ops_[128];
  static const uint16_t table23_61_ops_[128];
  static const uint16_t table23_62_ops_[128];
  static const uint8_t table23_63_emit_[36];
  static const uint16_t table23_63_ops_[128];
  static const uint8_t* const table23_emit_[64];
  static const uint16_t* const table23_ops_[64];
  static const uint8_t table24_0_emit_[204];
  static const uint16_t table24_0_ops_[128];
  static const uint8_t table24_1_emit_[204];
  static const uint8_t table24_2_emit_[204];
  static const uint8_t table24_3_emit_[204];
  static const uint8_t table24_4_emit_[204];
  static const uint8_t table24_5_emit_[204];
  static const uint8_t table24_6_emit_[204];
  static const uint8_t table24_7_emit_[204];
  static const uint8_t table24_8_emit_[204];
  static const uint8_t table24_9_emit_[204];
  static const uint8_t table24_10_emit_[216];
  static const uint8_t table24_11_emit_[216];
  static const uint8_t table24_12_emit_[216];
  static const uint8_t table24_13_emit_[216];
  static const uint8_t table24_14_emit_[216];
  static const uint8_t table24_15_emit_[216];
  static const uint8_t table24_16_emit_[216];
  static const uint8_t table24_17_emit_[216];
  static const uint8_t table24_18_emit_[216];
  static const uint8_t table24_19_emit_[216];
  static const uint8_t table24_20_emit_[216];
  static const uint8_t table24_21_emit_[216];
  static const uint8_t table24_22_emit_[216];
  static const uint8_t table24_23_emit_[120];
  static const uint8_t table24_24_emit_[120];
  static const uint8_t table24_25_emit_[120];
  static const uint8_t table24_26_emit_[120];
  static const uint8_t table24_27_emit_[120];
  static const uint8_t table24_28_emit_[120];
  static const uint8_t table24_29_emit_[120];
  static const uint8_t table24_30_emit_[120];
  static const uint8_t table24_31_emit_[32];
  static const uint16_t table24_31_ops_[128];
  static const uint8_t table24_32_emit_[204];
  static const uint8_t table24_33_emit_[204];
  static const uint8_t table24_34_emit_[204];
  static const uint8_t table24_35_emit_[204];
  static const uint8_t table24_36_emit_[204];
  static const uint8_t table24_37_emit_[204];
  static const uint8_t table24_38_emit_[204];
  static const uint8_t table24_39_emit_[204];
  static const uint8_t table24_40_emit_[204];
  static const uint8_t table24_41_emit_[204];
  static const uint8_t table24_42_emit_[216];
  static const uint8_t table24_43_emit_[216];
  static const uint8_t table24_44_emit_[216];
  static const uint8_t table24_45_emit_[216];
  static const uint8_t table24_46_emit_[216];
  static const uint8_t table24_47_emit_[216];
  static const uint8_t table24_48_emit_[216];
  static const uint8_t table24_49_emit_[216];
  static const uint8_t table24_50_emit_[216];
  static const uint8_t table24_51_emit_[216];
  static const uint8_t table24_52_emit_[216];
  static const uint8_t table24_53_emit_[216];
  static const uint8_t table24_54_emit_[216];
  static const uint8_t table24_55_emit_[120];
  static const uint8_t table24_56_emit_[120];
  static const uint8_t table24_57_emit_[120];
  static const uint8_t table24_58_emit_[120];
  static const uint8_t table24_59_emit_[120];
  static const uint8_t table24_60_emit_[120];
  static const uint8_t table24_61_emit_[120];
  static const uint8_t table24_62_emit_[120];
  static const uint8_t table24_63_emit_[32];
  static const uint8_t table24_64_emit_[204];
  static const uint8_t table24_65_emit_[204];
  static const uint8_t table24_66_emit_[204];
  static const uint8_t table24_67_emit_[204];
  static const uint8_t table24_68_emit_[204];
  static const uint8_t table24_69_emit_[204];
  static const uint8_t table24_70_emit_[204];
  static const uint8_t table24_71_emit_[204];
  static const uint8_t table24_72_emit_[204];
  static const uint8_t table24_73_emit_[204];
  static const uint8_t table24_74_emit_[216];
  static const uint8_t table24_75_emit_[216];
  static const uint8_t table24_76_emit_[216];
  static const uint8_t table24_77_emit_[216];
  static const uint8_t table24_78_emit_[216];
  static const uint8_t table24_79_emit_[216];
  static const uint8_t table24_80_emit_[216];
  static const uint8_t table24_81_emit_[216];
  static const uint8_t table24_82_emit_[216];
  static const uint8_t table24_83_emit_[216];
  static const uint8_t table24_84_emit_[216];
  static const uint8_t table24_85_emit_[216];
  static const uint8_t table24_86_emit_[216];
  static const uint8_t table24_87_emit_[120];
  static const uint8_t table24_88_emit_[120];
  static const uint8_t table24_89_emit_[120];
  static const uint8_t table24_90_emit_[120];
  static const uint8_t table24_91_emit_[120];
  static const uint8_t table24_92_emit_[120];
  static const uint8_t table24_93_emit_[120];
  static const uint8_t table24_94_emit_[120];
  static const uint8_t table24_95_emit_[32];
  static const uint8_t table24_96_emit_[44];
  static const uint16_t table24_96_ops_[128];
  static const uint8_t table24_97_emit_[104];
  static const uint16_t table24_97_ops_[128];
  static const uint8_t table24_98_emit_[44];
  static const uint8_t table24_99_emit_[104];
  static const uint8_t table24_100_emit_[44];
  static const uint8_t table24_101_emit_[104];
  static const uint8_t table24_102_emit_[136];
  static const uint8_t table24_103_emit_[136];
  static const uint8_t table24_104_emit_[136];
  static const uint8_t table24_105_emit_[136];
  static const uint8_t table24_106_emit_[136];
  static const uint8_t table24_107_emit_[136];
  static const uint8_t table24_108_emit_[136];
  static const uint8_t table24_109_emit_[136];
  static const uint8_t table24_110_emit_[144];
  static const uint8_t table24_111_emit_[144];
  static const uint8_t table24_112_emit_[144];
  static const uint8_t table24_113_emit_[144];
  static const uint8_t table24_114_emit_[144];
  static const uint8_t table24_115_emit_[144];
  static const uint8_t table24_116_emit_[112];
  static const uint16_t table24_116_ops_[128];
  static const uint8_t table24_117_emit_[80];
  static const uint8_t table24_118_emit_[80];
  static const uint8_t table24_119_emit_[80];
  static const uint8_t table24_120_emit_[80];
  static const uint8_t table24_121_emit_[80];
  static const uint8_t table24_122_emit_[80];
  static const uint8_t table24_123_emit_[8];
  static const uint8_t table24_124_emit_[8];
  static const uint8_t table24_125_emit_[8];
  static const uint8_t table24_126_emit_[11];
  static const uint16_t table24_126_ops_[128];
  static const uint8_t table24_127_emit_[44];
  static const uint16_t table24_127_ops_[128];
  static const uint8_t* const table24_emit_[128];
  static const uint16_t* const table24_ops_[128];
  static const uint8_t table11_0_emit_[1];
  static const uint16_t table11_0_ops_[256];
  static const uint8_t table11_32_emit_[1];
  static const uint8_t table11_64_emit_[1];
  static const uint8_t table11_96_emit_[1];
  static const uint16_t table11_96_ops_[256];
  static const uint8_t table11_98_emit_[1];
  static const uint8_t table11_100_emit_[1];
  static const uint8_t table11_102_emit_[1];
  static const uint16_t table11_102_ops_[256];
  static const uint8_t table11_103_emit_[1];
  static const uint8_t table11_104_emit_[1];
  static const uint8_t table11_105_emit_[1];
  static const uint8_t table11_106_emit_[1];
  static const uint8_t table11_107_emit_[1];
  static const uint8_t table11_108_emit_[1];
  static const uint8_t table11_109_emit_[1];
  static const uint8_t table11_110_emit_[2];
  static const uint16_t table11_110_ops_[256];
  static const uint8_t table11_111_emit_[2];
  static const uint8_t table11_112_emit_[2];
  static const uint8_t table11_113_emit_[2];
  static const uint8_t table11_114_emit_[2];
  static const uint8_t table11_115_emit_[2];
  static const uint8_t table11_116_emit_[3];
  static const uint16_t table11_116_ops_[256];
  static const uint8_t table11_117_emit_[4];
  static const uint16_t table11_117_ops_[256];
  static const uint8_t table11_118_emit_[4];
  static const uint8_t table11_119_emit_[4];
  static const uint8_t table11_120_emit_[4];
  static const uint8_t table11_121_emit_[4];
  static const uint8_t table11_122_emit_[4];
  static const uint16_t table11_123_ops_[256];
  static const uint16_t table11_126_ops_[256];
  static const uint8_t table11_127_emit_[73];
  static const uint16_t table11_127_ops_[256];
  static const uint8_t* const table11_emit_[128];
  static const uint16_t* const table11_ops_[128];
};
template <typename F>
class HuffDecoder : public HuffDecoderCommon {
 public:
  HuffDecoder(F sink, const uint8_t* begin, const uint8_t* end)
      : sink_(sink), begin_(begin), end_(end) {}
  bool Run() {
    while (!done_) {
      if (!RefillTo13()) {
        Done0();
        break;
      }
      const auto index = (buffer_ >> (buffer_len_ - 13)) & 0x1fff;
      const auto op = GetOp1(index);
      const int consumed = op & 15;
      buffer_len_ -= consumed;
      const auto emit_ofs = op >> 6;
      switch ((op >> 4) & 3) {
        case 0: {
          sink_(GetEmit1(index, emit_ofs + 0));
          sink_(GetEmit1(index, emit_ofs + 1));
          break;
        }
        case 1: {
          sink_(GetEmit1(index, emit_ofs + 0));
          break;
        }
        case 2: {
          DecodeStep0();
          break;
        }
        case 3: {
          DecodeStep1();
          break;
        }
      }
    }
    return ok_;
  }

 private:
  bool RefillTo13() {
    switch (buffer_len_) {
      case 0: {
        return Read2to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4: {
        return Read2to7Bytes();
      }
      case 5:
      case 6:
      case 7:
      case 8: {
        return Read1to7Bytes();
      }
      case 9:
      case 10:
      case 11:
      case 12: {
        return Read1to6Bytes();
      }
    }
    return true;
  }
  bool Read2to8Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Fill2() {
    buffer_ = (buffer_ << 16) | (static_cast<uint64_t>(begin_[0]) << 8) |
              (static_cast<uint64_t>(begin_[1]) << 0);
    begin_ += 2;
    buffer_len_ += 16;
  }
  void Fill3() {
    buffer_ = (buffer_ << 24) | (static_cast<uint64_t>(begin_[0]) << 16) |
              (static_cast<uint64_t>(begin_[1]) << 8) |
              (static_cast<uint64_t>(begin_[2]) << 0);
    begin_ += 3;
    buffer_len_ += 24;
  }
  void Fill4() {
    buffer_ = (buffer_ << 32) | (static_cast<uint64_t>(begin_[0]) << 24) |
              (static_cast<uint64_t>(begin_[1]) << 16) |
              (static_cast<uint64_t>(begin_[2]) << 8) |
              (static_cast<uint64_t>(begin_[3]) << 0);
    begin_ += 4;
    buffer_len_ += 32;
  }
  void Fill5() {
    buffer_ = (buffer_ << 40) | (static_cast<uint64_t>(begin_[0]) << 32) |
              (static_cast<uint64_t>(begin_[1]) << 24) |
              (static_cast<uint64_t>(begin_[2]) << 16) |
              (static_cast<uint64_t>(begin_[3]) << 8) |
              (static_cast<uint64_t>(begin_[4]) << 0);
    begin_ += 5;
    buffer_len_ += 40;
  }
  void Fill6() {
    buffer_ = (buffer_ << 48) | (static_cast<uint64_t>(begin_[0]) << 40) |
              (static_cast<uint64_t>(begin_[1]) << 32) |
              (static_cast<uint64_t>(begin_[2]) << 24) |
              (static_cast<uint64_t>(begin_[3]) << 16) |
              (static_cast<uint64_t>(begin_[4]) << 8) |
              (static_cast<uint64_t>(begin_[5]) << 0);
    begin_ += 6;
    buffer_len_ += 48;
  }
  void Fill7() {
    buffer_ = (buffer_ << 56) | (static_cast<uint64_t>(begin_[0]) << 48) |
              (static_cast<uint64_t>(begin_[1]) << 40) |
              (static_cast<uint64_t>(begin_[2]) << 32) |
              (static_cast<uint64_t>(begin_[3]) << 24) |
              (static_cast<uint64_t>(begin_[4]) << 16) |
              (static_cast<uint64_t>(begin_[5]) << 8) |
              (static_cast<uint64_t>(begin_[6]) << 0);
    begin_ += 7;
    buffer_len_ += 56;
  }
  void Fill8() {
    buffer_ = 0 | (static_cast<uint64_t>(begin_[0]) << 56) |
              (static_cast<uint64_t>(begin_[1]) << 48) |
              (static_cast<uint64_t>(begin_[2]) << 40) |
              (static_cast<uint64_t>(begin_[3]) << 32) |
              (static_cast<uint64_t>(begin_[4]) << 24) |
              (static_cast<uint64_t>(begin_[5]) << 16) |
              (static_cast<uint64_t>(begin_[6]) << 8) |
              (static_cast<uint64_t>(begin_[7]) << 0);
    begin_ += 8;
    buffer_len_ += 64;
  }
  bool Read2to7Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  bool Read1to7Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  void Fill1() {
    buffer_ = (buffer_ << 8) | (static_cast<uint64_t>(begin_[0]) << 0);
    begin_ += 1;
    buffer_len_ += 8;
  }
  bool Read1to6Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      default: {
        Fill6();
        return true;
      }
    }
  }
  void Done0() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3:
      case 4: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp2(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit2(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp3(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit3(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp4(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit4(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp5(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit5(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp6(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit6(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 10: {
        const auto index = buffer_ & 1023;
        const auto op = GetOp7(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit7(index, (op >> 2) + 0));
            sink_(GetEmit7(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit7(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 11: {
        const auto index = buffer_ & 2047;
        const auto op = GetOp8(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit8(index, (op >> 2) + 0));
            sink_(GetEmit8(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit8(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 12: {
        const auto index = buffer_ & 4095;
        const auto op = GetOp9(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit9(index, (op >> 2) + 0));
            sink_(GetEmit9(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit9(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep0() {
    if (!RefillTo1()) {
      Done1();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp10(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit10(index, emit_ofs + 0));
  }
  bool RefillTo1() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
    }
    return true;
  }
  bool Read1to8Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Done1() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep1() {
    if (!RefillTo15()) {
      Done2();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 15)) & 0x7fff;
    const auto op = GetOp11(index);
    const int consumed = op & 15;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 5;
    switch ((op >> 4) & 1) {
      case 0: {
        sink_(GetEmit11(index, emit_ofs + 0));
        break;
      }
      case 1: {
        DecodeStep2();
        break;
      }
    }
  }
  bool RefillTo15() {
    switch (buffer_len_) {
      case 0: {
        return Read2to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6: {
        return Read2to7Bytes();
      }
      case 7:
      case 8: {
        return Read1to7Bytes();
      }
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14: {
        return Read1to6Bytes();
      }
    }
    return true;
  }
  void Done2() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 2: {
        const auto index = buffer_ & 3;
        const auto op = GetOp12(index);
        switch (op & 1) {
          case 0: {
            sink_(GetEmit12(index, (op >> 1) + 0));
            break;
          }
        }
        return;
      }
      case 3: {
        const auto index = buffer_ & 7;
        const auto op = GetOp13(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit13(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp14(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit14(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp15(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit15(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp16(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit16(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp17(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit17(index, (op >> 2) + 0));
            sink_(GetEmit17(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit17(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp18(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit18(index, (op >> 2) + 0));
            sink_(GetEmit18(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit18(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp19(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit19(index, (op >> 2) + 0));
            sink_(GetEmit19(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit19(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 10: {
        const auto index = buffer_ & 1023;
        const auto op = GetOp20(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit20(index, (op >> 2) + 0));
            sink_(GetEmit20(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit20(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 11: {
        const auto index = buffer_ & 2047;
        const auto op = GetOp21(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit21(index, (op >> 2) + 0));
            sink_(GetEmit21(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit21(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 12: {
        const auto index = buffer_ & 4095;
        const auto op = GetOp22(index);
        switch (op & 7) {
          case 0: {
            sink_(GetEmit22(index, (op >> 3) + 0));
            sink_(GetEmit22(index, (op >> 3) + 1));
            sink_(GetEmit22(index, (op >> 3) + 2));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit22(index, (op >> 3) + 0));
            sink_(GetEmit22(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit22(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 13: {
        const auto index = buffer_ & 8191;
        const auto op = GetOp23(index);
        switch (op & 7) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit23(index, (op >> 3) + 0));
            sink_(GetEmit23(index, (op >> 3) + 1));
            sink_(GetEmit23(index, (op >> 3) + 2));
            break;
          }
          case 2: {
            sink_(GetEmit23(index, (op >> 3) + 0));
            sink_(GetEmit23(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit23(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 14: {
        const auto index = buffer_ & 16383;
        const auto op = GetOp24(index);
        switch (op & 7) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit24(index, (op >> 3) + 0));
            sink_(GetEmit24(index, (op >> 3) + 1));
            sink_(GetEmit24(index, (op >> 3) + 2));
            break;
          }
          case 2: {
            sink_(GetEmit24(index, (op >> 3) + 0));
            sink_(GetEmit24(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit24(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep2() {
    if (!RefillTo2()) {
      Done3();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp25(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 3;
    switch ((op >> 2) & 1) {
      case 0: {
        sink_(GetEmit25(index, emit_ofs + 0));
        break;
      }
      case 1: {
        begin_ = end_;
        buffer_len_ = 0;
        break;
      }
    }
  }
  bool RefillTo2() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done3() {
    done_ = true;
    switch (buffer_len_) {
      case 1: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 0: {
        return;
      }
    }
  }
  F sink_;
  const uint8_t* begin_;
  const uint8_t* const end_;
  uint64_t buffer_ = 0;
  int buffer_len_ = 0;
  bool ok_ = true;
  bool done_ = false;
};
}  // namespace geometry_13_15
}  // namespace grpc_core
#endif  // GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_13_15_H
