// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#include "test/cpp/microbenchmarks/huffman_geometries/decode_huff_13_15.h"

#include <grpc/support/port_platform.h>
namespace grpc_core {
namespace geometry_13_15 {
const uint8_t HuffDecoderCommon::table2_0_emit_[10] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74};
const uint8_t HuffDecoderCommon::table2_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table3_0_emit_[36] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20, 0x25,
    0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3d, 0x41,
    0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70, 0x72, 0x75};
const uint8_t HuffDecoderCommon::table3_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x29, 0x2d,
    0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59,
    0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85,
    0x89, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table4_0_emit_[22] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20,
    0x25, 0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table4_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00,
    0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x25, 0x00, 0x29, 0x00, 0x2d,
    0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41, 0x00,
    0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table4_1_emit_[46] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70,
    0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a,
    0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
    0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table4_1_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49,
    0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75,
    0x79, 0x7d, 0x81, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1,
    0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table4_emit_[2] = {
    table4_0_emit_,
    table4_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table4_ops_[2] = {
    table4_0_ops_,
    table4_1_ops_,
};
const uint8_t HuffDecoderCommon::table5_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29,
    0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35,
    0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x41,
    0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4d,
    0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table5_1_emit_[52] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e,
    0x70, 0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78,
    0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint8_t HuffDecoderCommon::table5_1_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d,
    0x00, 0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55,
    0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x00, 0x65, 0x00, 0x69, 0x00, 0x6d,
    0x00, 0x71, 0x00, 0x75, 0x00, 0x79, 0x00, 0x7d, 0x00, 0x81, 0x00, 0x85,
    0x00, 0x89, 0x00, 0x8d, 0x00, 0x91, 0x00, 0x95, 0x00, 0x99, 0x00, 0x9d,
    0x00, 0xa1, 0x00, 0xa5, 0x00, 0xa9, 0x00, 0xad, 0x00, 0xb1, 0x00, 0xb5,
    0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table5_emit_[2] = {
    table4_0_emit_,
    table5_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table5_ops_[2] = {
    table5_0_ops_,
    table5_1_ops_,
};
const uint8_t HuffDecoderCommon::table6_0_emit_[2] = {0x30, 0x31};
const uint8_t HuffDecoderCommon::table6_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05};
const uint8_t HuffDecoderCommon::table6_1_emit_[2] = {0x32, 0x61};
const uint8_t HuffDecoderCommon::table6_2_emit_[2] = {0x63, 0x65};
const uint8_t HuffDecoderCommon::table6_3_emit_[2] = {0x69, 0x6f};
const uint8_t HuffDecoderCommon::table6_4_emit_[2] = {0x73, 0x74};
const uint8_t HuffDecoderCommon::table6_5_emit_[4] = {0x20, 0x25, 0x2d, 0x2e};
const uint8_t HuffDecoderCommon::table6_5_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d};
const uint8_t HuffDecoderCommon::table6_6_emit_[4] = {0x2f, 0x33, 0x34, 0x35};
const uint8_t HuffDecoderCommon::table6_7_emit_[4] = {0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table6_8_emit_[4] = {0x3d, 0x41, 0x5f, 0x62};
const uint8_t HuffDecoderCommon::table6_9_emit_[4] = {0x64, 0x66, 0x67, 0x68};
const uint8_t HuffDecoderCommon::table6_10_emit_[4] = {0x6c, 0x6d, 0x6e, 0x70};
const uint8_t HuffDecoderCommon::table6_11_emit_[6] = {0x72, 0x75, 0x3a,
                                                       0x42, 0x43, 0x44};
const uint8_t HuffDecoderCommon::table6_11_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
    0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15};
const uint8_t HuffDecoderCommon::table6_12_emit_[8] = {0x45, 0x46, 0x47, 0x48,
                                                       0x49, 0x4a, 0x4b, 0x4c};
const uint8_t HuffDecoderCommon::table6_12_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d};
const uint8_t HuffDecoderCommon::table6_13_emit_[8] = {0x4d, 0x4e, 0x4f, 0x50,
                                                       0x51, 0x52, 0x53, 0x54};
const uint8_t HuffDecoderCommon::table6_14_emit_[8] = {0x55, 0x56, 0x57, 0x59,
                                                       0x6a, 0x6b, 0x71, 0x76};
const uint8_t HuffDecoderCommon::table6_15_emit_[10] = {
    0x77, 0x78, 0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint8_t HuffDecoderCommon::table6_15_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x11, 0x00, 0x15, 0x00, 0x19,
    0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table6_emit_[16] = {
    table6_0_emit_,  table6_1_emit_,  table6_2_emit_,  table6_3_emit_,
    table6_4_emit_,  table6_5_emit_,  table6_6_emit_,  table6_7_emit_,
    table6_8_emit_,  table6_9_emit_,  table6_10_emit_, table6_11_emit_,
    table6_12_emit_, table6_13_emit_, table6_14_emit_, table6_15_emit_,
};
const uint8_t* const HuffDecoderCommon::table6_ops_[16] = {
    table6_0_ops_,  table6_0_ops_,  table6_0_ops_,  table6_0_ops_,
    table6_0_ops_,  table6_5_ops_,  table6_5_ops_,  table6_5_ops_,
    table6_5_ops_,  table6_5_ops_,  table6_5_ops_,  table6_11_ops_,
    table6_12_ops_, table6_12_ops_, table6_12_ops_, table6_15_ops_,
};
const uint8_t HuffDecoderCommon::table7_0_emit_[36] = {
    0x30, 0x30, 0x31, 0x30, 0x32, 0x30, 0x61, 0x30, 0x63, 0x30, 0x65, 0x30,
    0x69, 0x30, 0x6f, 0x30, 0x73, 0x30, 0x74, 0x31, 0x31, 0x32, 0x31, 0x61,
    0x31, 0x63, 0x31, 0x65, 0x31, 0x69, 0x31, 0x6f, 0x31, 0x73, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table7_0_ops_[64] = {
    0x00, 0x04, 0x0c, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x08,
    0x4c, 0x50, 0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0a};
const uint8_t HuffDecoderCommon::table7_1_emit_[36] = {
    0x32, 0x30, 0x32, 0x31, 0x32, 0x32, 0x61, 0x32, 0x63, 0x32, 0x65, 0x32,
    0x69, 0x32, 0x6f, 0x32, 0x73, 0x32, 0x74, 0x61, 0x30, 0x61, 0x31, 0x61,
    0x61, 0x63, 0x61, 0x65, 0x61, 0x69, 0x61, 0x6f, 0x61, 0x73, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table7_1_ops_[64] = {
    0x00, 0x08, 0x10, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x4c,
    0x54, 0x18, 0x5c, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a};
const uint8_t HuffDecoderCommon::table7_2_emit_[36] = {
    0x63, 0x30, 0x63, 0x31, 0x63, 0x32, 0x63, 0x61, 0x63, 0x63, 0x65, 0x63,
    0x69, 0x63, 0x6f, 0x63, 0x73, 0x63, 0x74, 0x65, 0x30, 0x65, 0x31, 0x65,
    0x32, 0x65, 0x61, 0x65, 0x65, 0x69, 0x65, 0x6f, 0x65, 0x73, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table7_2_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x24, 0x2c, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x4c,
    0x54, 0x5c, 0x64, 0x28, 0x6c, 0x70, 0x78, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2a};
const uint8_t HuffDecoderCommon::table7_3_emit_[36] = {
    0x69, 0x30, 0x69, 0x31, 0x69, 0x32, 0x69, 0x61, 0x69, 0x63, 0x69, 0x65,
    0x69, 0x69, 0x6f, 0x69, 0x73, 0x69, 0x74, 0x6f, 0x30, 0x6f, 0x31, 0x6f,
    0x32, 0x6f, 0x61, 0x6f, 0x63, 0x6f, 0x65, 0x6f, 0x6f, 0x73, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table7_3_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x4c,
    0x54, 0x5c, 0x64, 0x6c, 0x74, 0x38, 0x7c, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3a};
const uint8_t HuffDecoderCommon::table7_4_emit_[38] = {
    0x73, 0x30, 0x73, 0x31, 0x73, 0x32, 0x73, 0x61, 0x73, 0x63,
    0x73, 0x65, 0x73, 0x69, 0x73, 0x6f, 0x73, 0x73, 0x74, 0x30,
    0x74, 0x31, 0x74, 0x32, 0x74, 0x61, 0x74, 0x63, 0x74, 0x65,
    0x74, 0x69, 0x74, 0x6f, 0x74, 0x73, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table7_4_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x48,
    0x50, 0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x90, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4a};
const uint8_t HuffDecoderCommon::table7_5_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e};
const uint8_t HuffDecoderCommon::table7_11_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0a, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x0e, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16};
const uint8_t HuffDecoderCommon::table7_12_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x1a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1e};
const uint8_t HuffDecoderCommon::table7_15_emit_[15] = {
    0x77, 0x78, 0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b,
    0x58, 0x5a, 0x21, 0x22, 0x28, 0x29, 0x3f};
const uint8_t HuffDecoderCommon::table7_15_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01,
    0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x16, 0x01, 0x01, 0x01, 0x1a,
    0x01, 0x01, 0x01, 0x1e, 0x01, 0x01, 0x01, 0x22, 0x01, 0x01, 0x01,
    0x26, 0x2a, 0x2e, 0x32, 0x36, 0x3a, 0x01, 0x01, 0x03};
const uint8_t* const HuffDecoderCommon::table7_emit_[16] = {
    table7_0_emit_,  table7_1_emit_,  table7_2_emit_,  table7_3_emit_,
    table7_4_emit_,  table6_5_emit_,  table6_6_emit_,  table6_7_emit_,
    table6_8_emit_,  table6_9_emit_,  table6_10_emit_, table6_11_emit_,
    table6_12_emit_, table6_13_emit_, table6_14_emit_, table7_15_emit_,
};
const uint8_t* const HuffDecoderCommon::table7_ops_[16] = {
    table7_0_ops_,  table7_1_ops_,  table7_2_ops_,  table7_3_ops_,
    table7_4_ops_,  table7_5_ops_,  table7_5_ops_,  table7_5_ops_,
    table7_5_ops_,  table7_5_ops_,  table7_5_ops_,  table7_11_ops_,
    table7_12_ops_, table7_12_ops_, table7_12_ops_, table7_15_ops_,
};
const uint8_t HuffDecoderCommon::table8_0_emit_[71] = {
    0x30, 0x30, 0x31, 0x30, 0x32, 0x30, 0x61, 0x30, 0x63, 0x30, 0x65, 0x30,
    0x69, 0x30, 0x6f, 0x30, 0x73, 0x30, 0x74, 0x30, 0x20, 0x30, 0x25, 0x30,
    0x2d, 0x30, 0x2e, 0x30, 0x2f, 0x30, 0x33, 0x30, 0x34, 0x30, 0x35, 0x30,
    0x36, 0x30, 0x37, 0x30, 0x38, 0x30, 0x39, 0x30, 0x3d, 0x30, 0x41, 0x30,
    0x5f, 0x30, 0x62, 0x30, 0x64, 0x30, 0x66, 0x30, 0x67, 0x30, 0x68, 0x30,
    0x6c, 0x30, 0x6d, 0x30, 0x6e, 0x30, 0x70, 0x30, 0x72, 0x30, 0x75};
const uint16_t HuffDecoderCommon::table8_0_inner_[38] = {
    0x0000, 0x0001, 0x0005, 0x000d, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_0_outer_[64] = {
    0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,  0,  7,  0,  8,
    0,  9,  0,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
    23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  37};
const uint8_t HuffDecoderCommon::table8_1_emit_[71] = {
    0x31, 0x30, 0x31, 0x31, 0x32, 0x31, 0x61, 0x31, 0x63, 0x31, 0x65, 0x31,
    0x69, 0x31, 0x6f, 0x31, 0x73, 0x31, 0x74, 0x31, 0x20, 0x31, 0x25, 0x31,
    0x2d, 0x31, 0x2e, 0x31, 0x2f, 0x31, 0x33, 0x31, 0x34, 0x31, 0x35, 0x31,
    0x36, 0x31, 0x37, 0x31, 0x38, 0x31, 0x39, 0x31, 0x3d, 0x31, 0x41, 0x31,
    0x5f, 0x31, 0x62, 0x31, 0x64, 0x31, 0x66, 0x31, 0x67, 0x31, 0x68, 0x31,
    0x6c, 0x31, 0x6d, 0x31, 0x6e, 0x31, 0x70, 0x31, 0x72, 0x31, 0x75};
const uint16_t HuffDecoderCommon::table8_1_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x000d, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_2_emit_[71] = {
    0x32, 0x30, 0x32, 0x31, 0x32, 0x32, 0x61, 0x32, 0x63, 0x32, 0x65, 0x32,
    0x69, 0x32, 0x6f, 0x32, 0x73, 0x32, 0x74, 0x32, 0x20, 0x32, 0x25, 0x32,
    0x2d, 0x32, 0x2e, 0x32, 0x2f, 0x32, 0x33, 0x32, 0x34, 0x32, 0x35, 0x32,
    0x36, 0x32, 0x37, 0x32, 0x38, 0x32, 0x39, 0x32, 0x3d, 0x32, 0x41, 0x32,
    0x5f, 0x32, 0x62, 0x32, 0x64, 0x32, 0x66, 0x32, 0x67, 0x32, 0x68, 0x32,
    0x6c, 0x32, 0x6d, 0x32, 0x6e, 0x32, 0x70, 0x32, 0x72, 0x32, 0x75};
const uint16_t HuffDecoderCommon::table8_2_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_3_emit_[71] = {
    0x61, 0x30, 0x61, 0x31, 0x61, 0x32, 0x61, 0x61, 0x63, 0x61, 0x65, 0x61,
    0x69, 0x61, 0x6f, 0x61, 0x73, 0x61, 0x74, 0x61, 0x20, 0x61, 0x25, 0x61,
    0x2d, 0x61, 0x2e, 0x61, 0x2f, 0x61, 0x33, 0x61, 0x34, 0x61, 0x35, 0x61,
    0x36, 0x61, 0x37, 0x61, 0x38, 0x61, 0x39, 0x61, 0x3d, 0x61, 0x41, 0x61,
    0x5f, 0x61, 0x62, 0x61, 0x64, 0x61, 0x66, 0x61, 0x67, 0x61, 0x68, 0x61,
    0x6c, 0x61, 0x6d, 0x61, 0x6e, 0x61, 0x70, 0x61, 0x72, 0x61, 0x75};
const uint16_t HuffDecoderCommon::table8_3_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_4_emit_[71] = {
    0x63, 0x30, 0x63, 0x31, 0x63, 0x32, 0x63, 0x61, 0x63, 0x63, 0x65, 0x63,
    0x69, 0x63, 0x6f, 0x63, 0x73, 0x63, 0x74, 0x63, 0x20, 0x63, 0x25, 0x63,
    0x2d, 0x63, 0x2e, 0x63, 0x2f, 0x63, 0x33, 0x63, 0x34, 0x63, 0x35, 0x63,
    0x36, 0x63, 0x37, 0x63, 0x38, 0x63, 0x39, 0x63, 0x3d, 0x63, 0x41, 0x63,
    0x5f, 0x63, 0x62, 0x63, 0x64, 0x63, 0x66, 0x63, 0x67, 0x63, 0x68, 0x63,
    0x6c, 0x63, 0x6d, 0x63, 0x6e, 0x63, 0x70, 0x63, 0x72, 0x63, 0x75};
const uint16_t HuffDecoderCommon::table8_4_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_5_emit_[71] = {
    0x65, 0x30, 0x65, 0x31, 0x65, 0x32, 0x65, 0x61, 0x65, 0x63, 0x65, 0x65,
    0x69, 0x65, 0x6f, 0x65, 0x73, 0x65, 0x74, 0x65, 0x20, 0x65, 0x25, 0x65,
    0x2d, 0x65, 0x2e, 0x65, 0x2f, 0x65, 0x33, 0x65, 0x34, 0x65, 0x35, 0x65,
    0x36, 0x65, 0x37, 0x65, 0x38, 0x65, 0x39, 0x65, 0x3d, 0x65, 0x41, 0x65,
    0x5f, 0x65, 0x62, 0x65, 0x64, 0x65, 0x66, 0x65, 0x67, 0x65, 0x68, 0x65,
    0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x65, 0x70, 0x65, 0x72, 0x65, 0x75};
const uint16_t HuffDecoderCommon::table8_5_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_6_emit_[71] = {
    0x69, 0x30, 0x69, 0x31, 0x69, 0x32, 0x69, 0x61, 0x69, 0x63, 0x69, 0x65,
    0x69, 0x69, 0x6f, 0x69, 0x73, 0x69, 0x74, 0x69, 0x20, 0x69, 0x25, 0x69,
    0x2d, 0x69, 0x2e, 0x69, 0x2f, 0x69, 0x33, 0x69, 0x34, 0x69, 0x35, 0x69,
    0x36, 0x69, 0x37, 0x69, 0x38, 0x69, 0x39, 0x69, 0x3d, 0x69, 0x41, 0x69,
    0x5f, 0x69, 0x62, 0x69, 0x64, 0x69, 0x66, 0x69, 0x67, 0x69, 0x68, 0x69,
    0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x69, 0x70, 0x69, 0x72, 0x69, 0x75};
const uint16_t HuffDecoderCommon::table8_6_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_7_emit_[71] = {
    0x6f, 0x30, 0x6f, 0x31, 0x6f, 0x32, 0x6f, 0x61, 0x6f, 0x63, 0x6f, 0x65,
    0x6f, 0x69, 0x6f, 0x6f, 0x73, 0x6f, 0x74, 0x6f, 0x20, 0x6f, 0x25, 0x6f,
    0x2d, 0x6f, 0x2e, 0x6f, 0x2f, 0x6f, 0x33, 0x6f, 0x34, 0x6f, 0x35, 0x6f,
    0x36, 0x6f, 0x37, 0x6f, 0x38, 0x6f, 0x39, 0x6f, 0x3d, 0x6f, 0x41, 0x6f,
    0x5f, 0x6f, 0x62, 0x6f, 0x64, 0x6f, 0x66, 0x6f, 0x67, 0x6f, 0x68, 0x6f,
    0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x6f, 0x70, 0x6f, 0x72, 0x6f, 0x75};
const uint16_t HuffDecoderCommon::table8_7_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_8_emit_[71] = {
    0x73, 0x30, 0x73, 0x31, 0x73, 0x32, 0x73, 0x61, 0x73, 0x63, 0x73, 0x65,
    0x73, 0x69, 0x73, 0x6f, 0x73, 0x73, 0x74, 0x73, 0x20, 0x73, 0x25, 0x73,
    0x2d, 0x73, 0x2e, 0x73, 0x2f, 0x73, 0x33, 0x73, 0x34, 0x73, 0x35, 0x73,
    0x36, 0x73, 0x37, 0x73, 0x38, 0x73, 0x39, 0x73, 0x3d, 0x73, 0x41, 0x73,
    0x5f, 0x73, 0x62, 0x73, 0x64, 0x73, 0x66, 0x73, 0x67, 0x73, 0x68, 0x73,
    0x6c, 0x73, 0x6d, 0x73, 0x6e, 0x73, 0x70, 0x73, 0x72, 0x73, 0x75};
const uint16_t HuffDecoderCommon::table8_8_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_9_emit_[71] = {
    0x74, 0x30, 0x74, 0x31, 0x74, 0x32, 0x74, 0x61, 0x74, 0x63, 0x74, 0x65,
    0x74, 0x69, 0x74, 0x6f, 0x74, 0x73, 0x74, 0x74, 0x20, 0x74, 0x25, 0x74,
    0x2d, 0x74, 0x2e, 0x74, 0x2f, 0x74, 0x33, 0x74, 0x34, 0x74, 0x35, 0x74,
    0x36, 0x74, 0x37, 0x74, 0x38, 0x74, 0x39, 0x74, 0x3d, 0x74, 0x41, 0x74,
    0x5f, 0x74, 0x62, 0x74, 0x64, 0x74, 0x66, 0x74, 0x67, 0x74, 0x68, 0x74,
    0x6c, 0x74, 0x6d, 0x74, 0x6e, 0x74, 0x70, 0x74, 0x72, 0x74, 0x75};
const uint16_t HuffDecoderCommon::table8_9_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_10_emit_[40] = {
    0x20, 0x30, 0x20, 0x31, 0x20, 0x32, 0x20, 0x61, 0x20, 0x63,
    0x20, 0x65, 0x20, 0x69, 0x20, 0x6f, 0x20, 0x73, 0x20, 0x74,
    0x25, 0x30, 0x25, 0x31, 0x25, 0x32, 0x25, 0x61, 0x25, 0x63,
    0x25, 0x65, 0x25, 0x69, 0x25, 0x6f, 0x25, 0x73, 0x25, 0x74};
const uint16_t HuffDecoderCommon::table8_10_inner_[23] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0002, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x0052};
const uint8_t HuffDecoderCommon::table8_10_outer_[64] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11,
    12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 22};
const uint8_t HuffDecoderCommon::table8_11_emit_[40] = {
    0x2d, 0x30, 0x2d, 0x31, 0x2d, 0x32, 0x2d, 0x61, 0x2d, 0x63,
    0x2d, 0x65, 0x2d, 0x69, 0x2d, 0x6f, 0x2d, 0x73, 0x2d, 0x74,
    0x2e, 0x30, 0x2e, 0x31, 0x2e, 0x32, 0x2e, 0x61, 0x2e, 0x63,
    0x2e, 0x65, 0x2e, 0x69, 0x2e, 0x6f, 0x2e, 0x73, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table8_12_emit_[40] = {
    0x2f, 0x30, 0x2f, 0x31, 0x2f, 0x32, 0x2f, 0x61, 0x2f, 0x63,
    0x2f, 0x65, 0x2f, 0x69, 0x2f, 0x6f, 0x2f, 0x73, 0x2f, 0x74,
    0x33, 0x30, 0x33, 0x31, 0x33, 0x32, 0x33, 0x61, 0x33, 0x63,
    0x33, 0x65, 0x33, 0x69, 0x33, 0x6f, 0x33, 0x73, 0x33, 0x74};
const uint8_t HuffDecoderCommon::table8_13_emit_[40] = {
    0x34, 0x30, 0x34, 0x31, 0x34, 0x32, 0x34, 0x61, 0x34, 0x63,
    0x34, 0x65, 0x34, 0x69, 0x34, 0x6f, 0x34, 0x73, 0x34, 0x74,
    0x35, 0x30, 0x35, 0x31, 0x35, 0x32, 0x35, 0x61, 0x35, 0x63,
    0x35, 0x65, 0x35, 0x69, 0x35, 0x6f, 0x35, 0x73, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table8_14_emit_[40] = {
    0x36, 0x30, 0x36, 0x31, 0x36, 0x32, 0x36, 0x61, 0x36, 0x63,
    0x36, 0x65, 0x36, 0x69, 0x36, 0x6f, 0x36, 0x73, 0x36, 0x74,
    0x37, 0x30, 0x37, 0x31, 0x37, 0x32, 0x37, 0x61, 0x37, 0x63,
    0x37, 0x65, 0x37, 0x69, 0x37, 0x6f, 0x37, 0x73, 0x37, 0x74};
const uint8_t HuffDecoderCommon::table8_15_emit_[40] = {
    0x38, 0x30, 0x38, 0x31, 0x38, 0x32, 0x38, 0x61, 0x38, 0x63,
    0x38, 0x65, 0x38, 0x69, 0x38, 0x6f, 0x38, 0x73, 0x38, 0x74,
    0x39, 0x30, 0x39, 0x31, 0x39, 0x32, 0x39, 0x61, 0x39, 0x63,
    0x39, 0x65, 0x39, 0x69, 0x39, 0x6f, 0x39, 0x73, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table8_16_emit_[40] = {
    0x3d, 0x30, 0x3d, 0x31, 0x3d, 0x32, 0x3d, 0x61, 0x3d, 0x63,
    0x3d, 0x65, 0x3d, 0x69, 0x3d, 0x6f, 0x3d, 0x73, 0x3d, 0x74,
    0x41, 0x30, 0x41, 0x31, 0x41, 0x32, 0x41, 0x61, 0x41, 0x63,
    0x41, 0x65, 0x41, 0x69, 0x41, 0x6f, 0x41, 0x73, 0x41, 0x74};
const uint8_t HuffDecoderCommon::table8_17_emit_[40] = {
    0x5f, 0x30, 0x5f, 0x31, 0x5f, 0x32, 0x5f, 0x61, 0x5f, 0x63,
    0x5f, 0x65, 0x5f, 0x69, 0x5f, 0x6f, 0x5f, 0x73, 0x5f, 0x74,
    0x62, 0x30, 0x62, 0x31, 0x62, 0x32, 0x62, 0x61, 0x62, 0x63,
    0x62, 0x65, 0x62, 0x69, 0x62, 0x6f, 0x62, 0x73, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table8_18_emit_[40] = {
    0x64, 0x30, 0x64, 0x31, 0x64, 0x32, 0x64, 0x61, 0x64, 0x63,
    0x64, 0x65, 0x64, 0x69, 0x64, 0x6f, 0x64, 0x73, 0x64, 0x74,
    0x66, 0x30, 0x66, 0x31, 0x66, 0x32, 0x66, 0x61, 0x66, 0x63,
    0x66, 0x65, 0x66, 0x69, 0x66, 0x6f, 0x66, 0x73, 0x66, 0x74};
const uint8_t HuffDecoderCommon::table8_19_emit_[40] = {
    0x67, 0x30, 0x67, 0x31, 0x67, 0x32, 0x67, 0x61, 0x67, 0x63,
    0x67, 0x65, 0x67, 0x69, 0x67, 0x6f, 0x67, 0x73, 0x67, 0x74,
    0x68, 0x30, 0x68, 0x31, 0x68, 0x32, 0x68, 0x61, 0x68, 0x63,
    0x68, 0x65, 0x68, 0x69, 0x68, 0x6f, 0x68, 0x73, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table8_20_emit_[40] = {
    0x6c, 0x30, 0x6c, 0x31, 0x6c, 0x32, 0x6c, 0x61, 0x6c, 0x63,
    0x6c, 0x65, 0x6c, 0x69, 0x6c, 0x6f, 0x6c, 0x73, 0x6c, 0x74,
    0x6d, 0x30, 0x6d, 0x31, 0x6d, 0x32, 0x6d, 0x61, 0x6d, 0x63,
    0x6d, 0x65, 0x6d, 0x69, 0x6d, 0x6f, 0x6d, 0x73, 0x6d, 0x74};
const uint8_t HuffDecoderCommon::table8_21_emit_[40] = {
    0x6e, 0x30, 0x6e, 0x31, 0x6e, 0x32, 0x6e, 0x61, 0x6e, 0x63,
    0x6e, 0x65, 0x6e, 0x69, 0x6e, 0x6f, 0x6e, 0x73, 0x6e, 0x74,
    0x70, 0x30, 0x70, 0x31, 0x70, 0x32, 0x70, 0x61, 0x70, 0x63,
    0x70, 0x65, 0x70, 0x69, 0x70, 0x6f, 0x70, 0x73, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table8_22_emit_[40] = {
    0x72, 0x30, 0x72, 0x31, 0x72, 0x32, 0x72, 0x61, 0x72, 0x63,
    0x72, 0x65, 0x72, 0x69, 0x72, 0x6f, 0x72, 0x73, 0x72, 0x74,
    0x75, 0x30, 0x75, 0x31, 0x75, 0x32, 0x75, 0x61, 0x75, 0x63,
    0x75, 0x65, 0x75, 0x69, 0x75, 0x6f, 0x75, 0x73, 0x75, 0x74};
const uint8_t HuffDecoderCommon::table8_23_emit_[4] = {0x3a, 0x42, 0x43, 0x44};
const uint16_t HuffDecoderCommon::table8_23_inner_[5] = {0x0000, 0x0002, 0x0006,
                                                         0x000a, 0x000e};
const uint8_t HuffDecoderCommon::table8_23_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4};
const uint8_t HuffDecoderCommon::table8_24_emit_[4] = {0x45, 0x46, 0x47, 0x48};
const uint8_t HuffDecoderCommon::table8_25_emit_[4] = {0x49, 0x4a, 0x4b, 0x4c};
const uint8_t HuffDecoderCommon::table8_26_emit_[4] = {0x4d, 0x4e, 0x4f, 0x50};
const uint8_t HuffDecoderCommon::table8_27_emit_[4] = {0x51, 0x52, 0x53, 0x54};
const uint8_t HuffDecoderCommon::table8_28_emit_[4] = {0x55, 0x56, 0x57, 0x59};
const uint8_t HuffDecoderCommon::table8_29_emit_[4] = {0x6a, 0x6b, 0x71, 0x76};
const uint8_t HuffDecoderCommon::table8_30_emit_[4] = {0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table8_31_emit_[14] = {
    0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a, 0x21,
    0x22, 0x28, 0x29, 0x3f, 0x27, 0x2b, 0x7c};
const uint16_t HuffDecoderCommon::table8_31_inner_[16] = {
    0x0000, 0x0002, 0x0006, 0x000a, 0x000e, 0x0012, 0x0016, 0x001a,
    0x001e, 0x0022, 0x0026, 0x002a, 0x002e, 0x0032, 0x0036, 0x0003};
const uint8_t HuffDecoderCommon::table8_31_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,  0, 0,  0,  2,  0,  0, 0, 0, 0, 0,
    0, 3, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0,  0, 0,  0,  0,  0,  5, 0, 0, 0, 0,
    0, 0, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 12, 13, 14, 0, 0, 15};
const uint8_t* const HuffDecoderCommon::table8_emit_[32] = {
    table8_0_emit_,  table8_1_emit_,  table8_2_emit_,  table8_3_emit_,
    table8_4_emit_,  table8_5_emit_,  table8_6_emit_,  table8_7_emit_,
    table8_8_emit_,  table8_9_emit_,  table8_10_emit_, table8_11_emit_,
    table8_12_emit_, table8_13_emit_, table8_14_emit_, table8_15_emit_,
    table8_16_emit_, table8_17_emit_, table8_18_emit_, table8_19_emit_,
    table8_20_emit_, table8_21_emit_, table8_22_emit_, table8_23_emit_,
    table8_24_emit_, table8_25_emit_, table8_26_emit_, table8_27_emit_,
    table8_28_emit_, table8_29_emit_, table8_30_emit_, table8_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table8_inner_[32] = {
    table8_0_inner_,  table8_1_inner_,  table8_2_inner_,  table8_3_inner_,
    table8_4_inner_,  table8_5_inner_,  table8_6_inner_,  table8_7_inner_,
    table8_8_inner_,  table8_9_inner_,  table8_10_inner_, table8_10_inner_,
    table8_10_inner_, table8_10_inner_, table8_10_inner_, table8_10_inner_,
    table8_10_inner_, table8_10_inner_, table8_10_inner_, table8_10_inner_,
    table8_10_inner_, table8_10_inner_, table8_10_inner_, table8_23_inner_,
    table8_23_inner_, table8_23_inner_, table8_23_inner_, table8_23_inner_,
    table8_23_inner_, table8_23_inner_, table8_23_inner_, table8_31_inner_,
};
const uint8_t* const HuffDecoderCommon::table8_outer_[32] = {
    table8_0_outer_,  table8_0_outer_,  table8_0_outer_,  table8_0_outer_,
    table8_0_outer_,  table8_0_outer_,  table8_0_outer_,  table8_0_outer_,
    table8_0_outer_,  table8_0_outer_,  table8_10_outer_, table8_10_outer_,
    table8_10_outer_, table8_10_outer_, table8_10_outer_, table8_10_outer_,
    table8_10_outer_, table8_10_outer_, table8_10_outer_, table8_10_outer_,
    table8_10_outer_, table8_10_outer_, table8_10_outer_, table8_23_outer_,
    table8_23_outer_, table8_23_outer_, table8_23_outer_, table8_23_outer_,
    table8_23_outer_, table8_23_outer_, table8_23_outer_, table8_31_outer_,
};
const uint8_t HuffDecoderCommon::table9_0_emit_[15] = {
    0x30, 0x30, 0x31, 0x30, 0x32, 0x30, 0x61, 0x30,
    0x63, 0x30, 0x65, 0x30, 0x69, 0x30, 0x6f};
const uint8_t HuffDecoderCommon::table9_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x0d, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00,
    0x00, 0x25, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_1_emit_[28] = {
    0x30, 0x73, 0x30, 0x74, 0x30, 0x20, 0x30, 0x25, 0x30, 0x2d,
    0x30, 0x2e, 0x30, 0x2f, 0x30, 0x33, 0x30, 0x34, 0x30, 0x35,
    0x30, 0x36, 0x30, 0x37, 0x30, 0x38, 0x30, 0x39};
const uint8_t HuffDecoderCommon::table9_1_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x11, 0x00,
    0x19, 0x00, 0x21, 0x00, 0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41,
    0x00, 0x49, 0x00, 0x51, 0x00, 0x59, 0x00, 0x61, 0x00, 0x69};
const uint8_t HuffDecoderCommon::table9_2_emit_[36] = {
    0x30, 0x3d, 0x30, 0x41, 0x30, 0x5f, 0x30, 0x62, 0x30, 0x64, 0x30, 0x66,
    0x30, 0x67, 0x30, 0x68, 0x30, 0x6c, 0x30, 0x6d, 0x30, 0x6e, 0x30, 0x70,
    0x30, 0x72, 0x30, 0x75, 0x30, 0x3a, 0x30, 0x42, 0x30, 0x43, 0x30, 0x44};
const uint8_t HuffDecoderCommon::table9_2_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x00, 0x51,
    0x00, 0x59, 0x00, 0x61, 0x00, 0x69, 0x71, 0x79, 0x81, 0x89};
const uint8_t HuffDecoderCommon::table9_3_emit_[56] = {
    0x30, 0x45, 0x30, 0x46, 0x30, 0x47, 0x30, 0x48, 0x30, 0x49, 0x30, 0x4a,
    0x30, 0x4b, 0x30, 0x4c, 0x30, 0x4d, 0x30, 0x4e, 0x30, 0x4f, 0x30, 0x50,
    0x30, 0x51, 0x30, 0x52, 0x30, 0x53, 0x30, 0x54, 0x30, 0x55, 0x30, 0x56,
    0x30, 0x57, 0x30, 0x59, 0x30, 0x6a, 0x30, 0x6b, 0x30, 0x71, 0x30, 0x76,
    0x30, 0x77, 0x30, 0x78, 0x30, 0x79, 0x30, 0x7a};
const uint8_t HuffDecoderCommon::table9_3_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0xa1, 0xa9,
    0xb1, 0xb9, 0xc1, 0xc9, 0xd1, 0xd9, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_4_emit_[15] = {
    0x31, 0x30, 0x31, 0x31, 0x32, 0x31, 0x61, 0x31,
    0x63, 0x31, 0x65, 0x31, 0x69, 0x31, 0x6f};
const uint8_t HuffDecoderCommon::table9_4_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x0d, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00,
    0x00, 0x25, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_5_emit_[28] = {
    0x31, 0x73, 0x31, 0x74, 0x31, 0x20, 0x31, 0x25, 0x31, 0x2d,
    0x31, 0x2e, 0x31, 0x2f, 0x31, 0x33, 0x31, 0x34, 0x31, 0x35,
    0x31, 0x36, 0x31, 0x37, 0x31, 0x38, 0x31, 0x39};
const uint8_t HuffDecoderCommon::table9_6_emit_[36] = {
    0x31, 0x3d, 0x31, 0x41, 0x31, 0x5f, 0x31, 0x62, 0x31, 0x64, 0x31, 0x66,
    0x31, 0x67, 0x31, 0x68, 0x31, 0x6c, 0x31, 0x6d, 0x31, 0x6e, 0x31, 0x70,
    0x31, 0x72, 0x31, 0x75, 0x31, 0x3a, 0x31, 0x42, 0x31, 0x43, 0x31, 0x44};
const uint8_t HuffDecoderCommon::table9_7_emit_[56] = {
    0x31, 0x45, 0x31, 0x46, 0x31, 0x47, 0x31, 0x48, 0x31, 0x49, 0x31, 0x4a,
    0x31, 0x4b, 0x31, 0x4c, 0x31, 0x4d, 0x31, 0x4e, 0x31, 0x4f, 0x31, 0x50,
    0x31, 0x51, 0x31, 0x52, 0x31, 0x53, 0x31, 0x54, 0x31, 0x55, 0x31, 0x56,
    0x31, 0x57, 0x31, 0x59, 0x31, 0x6a, 0x31, 0x6b, 0x31, 0x71, 0x31, 0x76,
    0x31, 0x77, 0x31, 0x78, 0x31, 0x79, 0x31, 0x7a};
const uint8_t HuffDecoderCommon::table9_8_emit_[15] = {
    0x32, 0x30, 0x32, 0x31, 0x32, 0x32, 0x61, 0x32,
    0x63, 0x32, 0x65, 0x32, 0x69, 0x32, 0x6f};
const uint8_t HuffDecoderCommon::table9_8_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00,
    0x00, 0x25, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_9_emit_[28] = {
    0x32, 0x73, 0x32, 0x74, 0x32, 0x20, 0x32, 0x25, 0x32, 0x2d,
    0x32, 0x2e, 0x32, 0x2f, 0x32, 0x33, 0x32, 0x34, 0x32, 0x35,
    0x32, 0x36, 0x32, 0x37, 0x32, 0x38, 0x32, 0x39};
const uint8_t HuffDecoderCommon::table9_10_emit_[36] = {
    0x32, 0x3d, 0x32, 0x41, 0x32, 0x5f, 0x32, 0x62, 0x32, 0x64, 0x32, 0x66,
    0x32, 0x67, 0x32, 0x68, 0x32, 0x6c, 0x32, 0x6d, 0x32, 0x6e, 0x32, 0x70,
    0x32, 0x72, 0x32, 0x75, 0x32, 0x3a, 0x32, 0x42, 0x32, 0x43, 0x32, 0x44};
const uint8_t HuffDecoderCommon::table9_11_emit_[56] = {
    0x32, 0x45, 0x32, 0x46, 0x32, 0x47, 0x32, 0x48, 0x32, 0x49, 0x32, 0x4a,
    0x32, 0x4b, 0x32, 0x4c, 0x32, 0x4d, 0x32, 0x4e, 0x32, 0x4f, 0x32, 0x50,
    0x32, 0x51, 0x32, 0x52, 0x32, 0x53, 0x32, 0x54, 0x32, 0x55, 0x32, 0x56,
    0x32, 0x57, 0x32, 0x59, 0x32, 0x6a, 0x32, 0x6b, 0x32, 0x71, 0x32, 0x76,
    0x32, 0x77, 0x32, 0x78, 0x32, 0x79, 0x32, 0x7a};
const uint8_t HuffDecoderCommon::table9_12_emit_[15] = {
    0x61, 0x30, 0x61, 0x31, 0x61, 0x32, 0x61, 0x61,
    0x63, 0x61, 0x65, 0x61, 0x69, 0x61, 0x6f};
const uint8_t HuffDecoderCommon::table9_12_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00,
    0x00, 0x25, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_13_emit_[28] = {
    0x61, 0x73, 0x61, 0x74, 0x61, 0x20, 0x61, 0x25, 0x61, 0x2d,
    0x61, 0x2e, 0x61, 0x2f, 0x61, 0x33, 0x61, 0x34, 0x61, 0x35,
    0x61, 0x36, 0x61, 0x37, 0x61, 0x38, 0x61, 0x39};
const uint8_t HuffDecoderCommon::table9_14_emit_[36] = {
    0x61, 0x3d, 0x61, 0x41, 0x61, 0x5f, 0x61, 0x62, 0x61, 0x64, 0x61, 0x66,
    0x61, 0x67, 0x61, 0x68, 0x61, 0x6c, 0x61, 0x6d, 0x61, 0x6e, 0x61, 0x70,
    0x61, 0x72, 0x61, 0x75, 0x61, 0x3a, 0x61, 0x42, 0x61, 0x43, 0x61, 0x44};
const uint8_t HuffDecoderCommon::table9_15_emit_[56] = {
    0x61, 0x45, 0x61, 0x46, 0x61, 0x47, 0x61, 0x48, 0x61, 0x49, 0x61, 0x4a,
    0x61, 0x4b, 0x61, 0x4c, 0x61, 0x4d, 0x61, 0x4e, 0x61, 0x4f, 0x61, 0x50,
    0x61, 0x51, 0x61, 0x52, 0x61, 0x53, 0x61, 0x54, 0x61, 0x55, 0x61, 0x56,
    0x61, 0x57, 0x61, 0x59, 0x61, 0x6a, 0x61, 0x6b, 0x61, 0x71, 0x61, 0x76,
    0x61, 0x77, 0x61, 0x78, 0x61, 0x79, 0x61, 0x7a};
const uint8_t HuffDecoderCommon::table9_16_emit_[15] = {
    0x63, 0x30, 0x63, 0x31, 0x63, 0x32, 0x63, 0x61,
    0x63, 0x63, 0x65, 0x63, 0x69, 0x63, 0x6f};
const uint8_t HuffDecoderCommon::table9_16_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00,
    0x00, 0x25, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_17_emit_[28] = {
    0x63, 0x73, 0x63, 0x74, 0x63, 0x20, 0x63, 0x25, 0x63, 0x2d,
    0x63, 0x2e, 0x63, 0x2f, 0x63, 0x33, 0x63, 0x34, 0x63, 0x35,
    0x63, 0x36, 0x63, 0x37, 0x63, 0x38, 0x63, 0x39};
const uint8_t HuffDecoderCommon::table9_18_emit_[36] = {
    0x63, 0x3d, 0x63, 0x41, 0x63, 0x5f, 0x63, 0x62, 0x63, 0x64, 0x63, 0x66,
    0x63, 0x67, 0x63, 0x68, 0x63, 0x6c, 0x63, 0x6d, 0x63, 0x6e, 0x63, 0x70,
    0x63, 0x72, 0x63, 0x75, 0x63, 0x3a, 0x63, 0x42, 0x63, 0x43, 0x63, 0x44};
const uint8_t HuffDecoderCommon::table9_19_emit_[56] = {
    0x63, 0x45, 0x63, 0x46, 0x63, 0x47, 0x63, 0x48, 0x63, 0x49, 0x63, 0x4a,
    0x63, 0x4b, 0x63, 0x4c, 0x63, 0x4d, 0x63, 0x4e, 0x63, 0x4f, 0x63, 0x50,
    0x63, 0x51, 0x63, 0x52, 0x63, 0x53, 0x63, 0x54, 0x63, 0x55, 0x63, 0x56,
    0x63, 0x57, 0x63, 0x59, 0x63, 0x6a, 0x63, 0x6b, 0x63, 0x71, 0x63, 0x76,
    0x63, 0x77, 0x63, 0x78, 0x63, 0x79, 0x63, 0x7a};
const uint8_t HuffDecoderCommon::table9_20_emit_[15] = {
    0x65, 0x30, 0x65, 0x31, 0x65, 0x32, 0x65, 0x61,
    0x65, 0x63, 0x65, 0x65, 0x69, 0x65, 0x6f};
const uint8_t HuffDecoderCommon::table9_20_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00,
    0x00, 0x29, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_21_emit_[28] = {
    0x65, 0x73, 0x65, 0x74, 0x65, 0x20, 0x65, 0x25, 0x65, 0x2d,
    0x65, 0x2e, 0x65, 0x2f, 0x65, 0x33, 0x65, 0x34, 0x65, 0x35,
    0x65, 0x36, 0x65, 0x37, 0x65, 0x38, 0x65, 0x39};
const uint8_t HuffDecoderCommon::table9_22_emit_[36] = {
    0x65, 0x3d, 0x65, 0x41, 0x65, 0x5f, 0x65, 0x62, 0x65, 0x64, 0x65, 0x66,
    0x65, 0x67, 0x65, 0x68, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x65, 0x70,
    0x65, 0x72, 0x65, 0x75, 0x65, 0x3a, 0x65, 0x42, 0x65, 0x43, 0x65, 0x44};
const uint8_t HuffDecoderCommon::table9_23_emit_[56] = {
    0x65, 0x45, 0x65, 0x46, 0x65, 0x47, 0x65, 0x48, 0x65, 0x49, 0x65, 0x4a,
    0x65, 0x4b, 0x65, 0x4c, 0x65, 0x4d, 0x65, 0x4e, 0x65, 0x4f, 0x65, 0x50,
    0x65, 0x51, 0x65, 0x52, 0x65, 0x53, 0x65, 0x54, 0x65, 0x55, 0x65, 0x56,
    0x65, 0x57, 0x65, 0x59, 0x65, 0x6a, 0x65, 0x6b, 0x65, 0x71, 0x65, 0x76,
    0x65, 0x77, 0x65, 0x78, 0x65, 0x79, 0x65, 0x7a};
const uint8_t HuffDecoderCommon::table9_24_emit_[15] = {
    0x69, 0x30, 0x69, 0x31, 0x69, 0x32, 0x69, 0x61,
    0x69, 0x63, 0x69, 0x65, 0x69, 0x69, 0x6f};
const uint8_t HuffDecoderCommon::table9_24_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00,
    0x00, 0x29, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_25_emit_[28] = {
    0x69, 0x73, 0x69, 0x74, 0x69, 0x20, 0x69, 0x25, 0x69, 0x2d,
    0x69, 0x2e, 0x69, 0x2f, 0x69, 0x33, 0x69, 0x34, 0x69, 0x35,
    0x69, 0x36, 0x69, 0x37, 0x69, 0x38, 0x69, 0x39};
const uint8_t HuffDecoderCommon::table9_26_emit_[36] = {
    0x69, 0x3d, 0x69, 0x41, 0x69, 0x5f, 0x69, 0x62, 0x69, 0x64, 0x69, 0x66,
    0x69, 0x67, 0x69, 0x68, 0x69, 0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x69, 0x70,
    0x69, 0x72, 0x69, 0x75, 0x69, 0x3a, 0x69, 0x42, 0x69, 0x43, 0x69, 0x44};
const uint8_t HuffDecoderCommon::table9_27_emit_[56] = {
    0x69, 0x45, 0x69, 0x46, 0x69, 0x47, 0x69, 0x48, 0x69, 0x49, 0x69, 0x4a,
    0x69, 0x4b, 0x69, 0x4c, 0x69, 0x4d, 0x69, 0x4e, 0x69, 0x4f, 0x69, 0x50,
    0x69, 0x51, 0x69, 0x52, 0x69, 0x53, 0x69, 0x54, 0x69, 0x55, 0x69, 0x56,
    0x69, 0x57, 0x69, 0x59, 0x69, 0x6a, 0x69, 0x6b, 0x69, 0x71, 0x69, 0x76,
    0x69, 0x77, 0x69, 0x78, 0x69, 0x79, 0x69, 0x7a};
const uint8_t HuffDecoderCommon::table9_28_emit_[16] = {
    0x6f, 0x30, 0x6f, 0x31, 0x6f, 0x32, 0x6f, 0x61,
    0x6f, 0x63, 0x6f, 0x65, 0x6f, 0x69, 0x6f, 0x6f};
const uint8_t HuffDecoderCommon::table9_28_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00,
    0x00, 0x29, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x39};
const uint8_t HuffDecoderCommon::table9_29_emit_[28] = {
    0x6f, 0x73, 0x6f, 0x74, 0x6f, 0x20, 0x6f, 0x25, 0x6f, 0x2d,
    0x6f, 0x2e, 0x6f, 0x2f, 0x6f, 0x33, 0x6f, 0x34, 0x6f, 0x35,
    0x6f, 0x36, 0x6f, 0x37, 0x6f, 0x38, 0x6f, 0x39};
const uint8_t HuffDecoderCommon::table9_30_emit_[36] = {
    0x6f, 0x3d, 0x6f, 0x41, 0x6f, 0x5f, 0x6f, 0x62, 0x6f, 0x64, 0x6f, 0x66,
    0x6f, 0x67, 0x6f, 0x68, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x6f, 0x70,
    0x6f, 0x72, 0x6f, 0x75, 0x6f, 0x3a, 0x6f, 0x42, 0x6f, 0x43, 0x6f, 0x44};
const uint8_t HuffDecoderCommon::table9_31_emit_[56] = {
    0x6f, 0x45, 0x6f, 0x46, 0x6f, 0x47, 0x6f, 0x48, 0x6f, 0x49, 0x6f, 0x4a,
    0x6f, 0x4b, 0x6f, 0x4c, 0x6f, 0x4d, 0x6f, 0x4e, 0x6f, 0x4f, 0x6f, 0x50,
    0x6f, 0x51, 0x6f, 0x52, 0x6f, 0x53, 0x6f, 0x54, 0x6f, 0x55, 0x6f, 0x56,
    0x6f, 0x57, 0x6f, 0x59, 0x6f, 0x6a, 0x6f, 0x6b, 0x6f, 0x71, 0x6f, 0x76,
    0x6f, 0x77, 0x6f, 0x78, 0x6f, 0x79, 0x6f, 0x7a};
const uint8_t HuffDecoderCommon::table9_32_emit_[16] = {
    0x73, 0x30, 0x73, 0x31, 0x73, 0x32, 0x73, 0x61,
    0x73, 0x63, 0x73, 0x65, 0x73, 0x69, 0x73, 0x6f};
const uint8_t HuffDecoderCommon::table9_33_emit_[27] = {
    0x73, 0x73, 0x74, 0x73, 0x20, 0x73, 0x25, 0x73, 0x2d,
    0x73, 0x2e, 0x73, 0x2f, 0x73, 0x33, 0x73, 0x34, 0x73,
    0x35, 0x73, 0x36, 0x73, 0x37, 0x73, 0x38, 0x73, 0x39};
const uint8_t HuffDecoderCommon::table9_33_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x0d, 0x00,
    0x15, 0x00, 0x1d, 0x00, 0x25, 0x00, 0x2d, 0x00, 0x35, 0x00, 0x3d,
    0x00, 0x45, 0x00, 0x4d, 0x00, 0x55, 0x00, 0x5d, 0x00, 0x65};
const uint8_t HuffDecoderCommon::table9_34_emit_[36] = {
    0x73, 0x3d, 0x73, 0x41, 0x73, 0x5f, 0x73, 0x62, 0x73, 0x64, 0x73, 0x66,
    0x73, 0x67, 0x73, 0x68, 0x73, 0x6c, 0x73, 0x6d, 0x73, 0x6e, 0x73, 0x70,
    0x73, 0x72, 0x73, 0x75, 0x73, 0x3a, 0x73, 0x42, 0x73, 0x43, 0x73, 0x44};
const uint8_t HuffDecoderCommon::table9_35_emit_[56] = {
    0x73, 0x45, 0x73, 0x46, 0x73, 0x47, 0x73, 0x48, 0x73, 0x49, 0x73, 0x4a,
    0x73, 0x4b, 0x73, 0x4c, 0x73, 0x4d, 0x73, 0x4e, 0x73, 0x4f, 0x73, 0x50,
    0x73, 0x51, 0x73, 0x52, 0x73, 0x53, 0x73, 0x54, 0x73, 0x55, 0x73, 0x56,
    0x73, 0x57, 0x73, 0x59, 0x73, 0x6a, 0x73, 0x6b, 0x73, 0x71, 0x73, 0x76,
    0x73, 0x77, 0x73, 0x78, 0x73, 0x79, 0x73, 0x7a};
const uint8_t HuffDecoderCommon::table9_36_emit_[16] = {
    0x74, 0x30, 0x74, 0x31, 0x74, 0x32, 0x74, 0x61,
    0x74, 0x63, 0x74, 0x65, 0x74, 0x69, 0x74, 0x6f};
const uint8_t HuffDecoderCommon::table9_37_emit_[27] = {
    0x74, 0x73, 0x74, 0x74, 0x20, 0x74, 0x25, 0x74, 0x2d,
    0x74, 0x2e, 0x74, 0x2f, 0x74, 0x33, 0x74, 0x34, 0x74,
    0x35, 0x74, 0x36, 0x74, 0x37, 0x74, 0x38, 0x74, 0x39};
const uint8_t HuffDecoderCommon::table9_37_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x0d, 0x00,
    0x15, 0x00, 0x1d, 0x00, 0x25, 0x00, 0x2d, 0x00, 0x35, 0x00, 0x3d,
    0x00, 0x45, 0x00, 0x4d, 0x00, 0x55, 0x00, 0x5d, 0x00, 0x65};
const uint8_t HuffDecoderCommon::table9_38_emit_[36] = {
    0x74, 0x3d, 0x74, 0x41, 0x74, 0x5f, 0x74, 0x62, 0x74, 0x64, 0x74, 0x66,
    0x74, 0x67, 0x74, 0x68, 0x74, 0x6c, 0x74, 0x6d, 0x74, 0x6e, 0x74, 0x70,
    0x74, 0x72, 0x74, 0x75, 0x74, 0x3a, 0x74, 0x42, 0x74, 0x43, 0x74, 0x44};
const uint8_t HuffDecoderCommon::table9_39_emit_[56] = {
    0x74, 0x45, 0x74, 0x46, 0x74, 0x47, 0x74, 0x48, 0x74, 0x49, 0x74, 0x4a,
    0x74, 0x4b, 0x74, 0x4c, 0x74, 0x4d, 0x74, 0x4e, 0x74, 0x4f, 0x74, 0x50,
    0x74, 0x51, 0x74, 0x52, 0x74, 0x53, 0x74, 0x54, 0x74, 0x55, 0x74, 0x56,
    0x74, 0x57, 0x74, 0x59, 0x74, 0x6a, 0x74, 0x6b, 0x74, 0x71, 0x74, 0x76,
    0x74, 0x77, 0x74, 0x78, 0x74, 0x79, 0x74, 0x7a};
const uint8_t HuffDecoderCommon::table9_40_emit_[43] = {
    0x20, 0x30, 0x20, 0x31, 0x20, 0x32, 0x20, 0x61, 0x20, 0x63, 0x20,
    0x65, 0x20, 0x69, 0x20, 0x6f, 0x20, 0x73, 0x20, 0x74, 0x20, 0x20,
    0x25, 0x20, 0x2d, 0x20, 0x2e, 0x20, 0x2f, 0x20, 0x33, 0x20, 0x34,
    0x20, 0x35, 0x20, 0x36, 0x20, 0x37, 0x20, 0x38, 0x20, 0x39};
const uint8_t HuffDecoderCommon::table9_40_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x55,
    0x5d, 0x65, 0x6d, 0x75, 0x7d, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_41_emit_[28] = {
    0x20, 0x3d, 0x20, 0x41, 0x20, 0x5f, 0x20, 0x62, 0x20, 0x64,
    0x20, 0x66, 0x20, 0x67, 0x20, 0x68, 0x20, 0x6c, 0x20, 0x6d,
    0x20, 0x6e, 0x20, 0x70, 0x20, 0x72, 0x20, 0x75};
const uint8_t HuffDecoderCommon::table9_41_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x61, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_42_emit_[43] = {
    0x25, 0x30, 0x25, 0x31, 0x25, 0x32, 0x25, 0x61, 0x25, 0x63, 0x25,
    0x65, 0x25, 0x69, 0x25, 0x6f, 0x25, 0x73, 0x25, 0x74, 0x25, 0x20,
    0x25, 0x25, 0x2d, 0x25, 0x2e, 0x25, 0x2f, 0x25, 0x33, 0x25, 0x34,
    0x25, 0x35, 0x25, 0x36, 0x25, 0x37, 0x25, 0x38, 0x25, 0x39};
const uint8_t HuffDecoderCommon::table9_42_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x5d, 0x65, 0x6d, 0x75, 0x7d, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_43_emit_[28] = {
    0x25, 0x3d, 0x25, 0x41, 0x25, 0x5f, 0x25, 0x62, 0x25, 0x64,
    0x25, 0x66, 0x25, 0x67, 0x25, 0x68, 0x25, 0x6c, 0x25, 0x6d,
    0x25, 0x6e, 0x25, 0x70, 0x25, 0x72, 0x25, 0x75};
const uint8_t HuffDecoderCommon::table9_44_emit_[43] = {
    0x2d, 0x30, 0x2d, 0x31, 0x2d, 0x32, 0x2d, 0x61, 0x2d, 0x63, 0x2d,
    0x65, 0x2d, 0x69, 0x2d, 0x6f, 0x2d, 0x73, 0x2d, 0x74, 0x2d, 0x20,
    0x2d, 0x25, 0x2d, 0x2d, 0x2e, 0x2d, 0x2f, 0x2d, 0x33, 0x2d, 0x34,
    0x2d, 0x35, 0x2d, 0x36, 0x2d, 0x37, 0x2d, 0x38, 0x2d, 0x39};
const uint8_t HuffDecoderCommon::table9_44_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x65, 0x6d, 0x75, 0x7d, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_45_emit_[28] = {
    0x2d, 0x3d, 0x2d, 0x41, 0x2d, 0x5f, 0x2d, 0x62, 0x2d, 0x64,
    0x2d, 0x66, 0x2d, 0x67, 0x2d, 0x68, 0x2d, 0x6c, 0x2d, 0x6d,
    0x2d, 0x6e, 0x2d, 0x70, 0x2d, 0x72, 0x2d, 0x75};
const uint8_t HuffDecoderCommon::table9_46_emit_[43] = {
    0x2e, 0x30, 0x2e, 0x31, 0x2e, 0x32, 0x2e, 0x61, 0x2e, 0x63, 0x2e,
    0x65, 0x2e, 0x69, 0x2e, 0x6f, 0x2e, 0x73, 0x2e, 0x74, 0x2e, 0x20,
    0x2e, 0x25, 0x2e, 0x2d, 0x2e, 0x2e, 0x2f, 0x2e, 0x33, 0x2e, 0x34,
    0x2e, 0x35, 0x2e, 0x36, 0x2e, 0x37, 0x2e, 0x38, 0x2e, 0x39};
const uint8_t HuffDecoderCommon::table9_46_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x6d, 0x75, 0x7d, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_47_emit_[28] = {
    0x2e, 0x3d, 0x2e, 0x41, 0x2e, 0x5f, 0x2e, 0x62, 0x2e, 0x64,
    0x2e, 0x66, 0x2e, 0x67, 0x2e, 0x68, 0x2e, 0x6c, 0x2e, 0x6d,
    0x2e, 0x6e, 0x2e, 0x70, 0x2e, 0x72, 0x2e, 0x75};
const uint8_t HuffDecoderCommon::table9_48_emit_[43] = {
    0x2f, 0x30, 0x2f, 0x31, 0x2f, 0x32, 0x2f, 0x61, 0x2f, 0x63, 0x2f,
    0x65, 0x2f, 0x69, 0x2f, 0x6f, 0x2f, 0x73, 0x2f, 0x74, 0x2f, 0x20,
    0x2f, 0x25, 0x2f, 0x2d, 0x2f, 0x2e, 0x2f, 0x2f, 0x33, 0x2f, 0x34,
    0x2f, 0x35, 0x2f, 0x36, 0x2f, 0x37, 0x2f, 0x38, 0x2f, 0x39};
const uint8_t HuffDecoderCommon::table9_48_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x75, 0x7d, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_49_emit_[28] = {
    0x2f, 0x3d, 0x2f, 0x41, 0x2f, 0x5f, 0x2f, 0x62, 0x2f, 0x64,
    0x2f, 0x66, 0x2f, 0x67, 0x2f, 0x68, 0x2f, 0x6c, 0x2f, 0x6d,
    0x2f, 0x6e, 0x2f, 0x70, 0x2f, 0x72, 0x2f, 0x75};
const uint8_t HuffDecoderCommon::table9_50_emit_[43] = {
    0x33, 0x30, 0x33, 0x31, 0x33, 0x32, 0x33, 0x61, 0x33, 0x63, 0x33,
    0x65, 0x33, 0x69, 0x33, 0x6f, 0x33, 0x73, 0x33, 0x74, 0x33, 0x20,
    0x33, 0x25, 0x33, 0x2d, 0x33, 0x2e, 0x33, 0x2f, 0x33, 0x33, 0x34,
    0x33, 0x35, 0x33, 0x36, 0x33, 0x37, 0x33, 0x38, 0x33, 0x39};
const uint8_t HuffDecoderCommon::table9_50_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x7d, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_51_emit_[28] = {
    0x33, 0x3d, 0x33, 0x41, 0x33, 0x5f, 0x33, 0x62, 0x33, 0x64,
    0x33, 0x66, 0x33, 0x67, 0x33, 0x68, 0x33, 0x6c, 0x33, 0x6d,
    0x33, 0x6e, 0x33, 0x70, 0x33, 0x72, 0x33, 0x75};
const uint8_t HuffDecoderCommon::table9_52_emit_[43] = {
    0x34, 0x30, 0x34, 0x31, 0x34, 0x32, 0x34, 0x61, 0x34, 0x63, 0x34,
    0x65, 0x34, 0x69, 0x34, 0x6f, 0x34, 0x73, 0x34, 0x74, 0x34, 0x20,
    0x34, 0x25, 0x34, 0x2d, 0x34, 0x2e, 0x34, 0x2f, 0x34, 0x33, 0x34,
    0x34, 0x35, 0x34, 0x36, 0x34, 0x37, 0x34, 0x38, 0x34, 0x39};
const uint8_t HuffDecoderCommon::table9_52_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_53_emit_[28] = {
    0x34, 0x3d, 0x34, 0x41, 0x34, 0x5f, 0x34, 0x62, 0x34, 0x64,
    0x34, 0x66, 0x34, 0x67, 0x34, 0x68, 0x34, 0x6c, 0x34, 0x6d,
    0x34, 0x6e, 0x34, 0x70, 0x34, 0x72, 0x34, 0x75};
const uint8_t HuffDecoderCommon::table9_54_emit_[43] = {
    0x35, 0x30, 0x35, 0x31, 0x35, 0x32, 0x35, 0x61, 0x35, 0x63, 0x35,
    0x65, 0x35, 0x69, 0x35, 0x6f, 0x35, 0x73, 0x35, 0x74, 0x35, 0x20,
    0x35, 0x25, 0x35, 0x2d, 0x35, 0x2e, 0x35, 0x2f, 0x35, 0x33, 0x35,
    0x34, 0x35, 0x35, 0x36, 0x35, 0x37, 0x35, 0x38, 0x35, 0x39};
const uint8_t HuffDecoderCommon::table9_54_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_55_emit_[28] = {
    0x35, 0x3d, 0x35, 0x41, 0x35, 0x5f, 0x35, 0x62, 0x35, 0x64,
    0x35, 0x66, 0x35, 0x67, 0x35, 0x68, 0x35, 0x6c, 0x35, 0x6d,
    0x35, 0x6e, 0x35, 0x70, 0x35, 0x72, 0x35, 0x75};
const uint8_t HuffDecoderCommon::table9_56_emit_[43] = {
    0x36, 0x30, 0x36, 0x31, 0x36, 0x32, 0x36, 0x61, 0x36, 0x63, 0x36,
    0x65, 0x36, 0x69, 0x36, 0x6f, 0x36, 0x73, 0x36, 0x74, 0x36, 0x20,
    0x36, 0x25, 0x36, 0x2d, 0x36, 0x2e, 0x36, 0x2f, 0x36, 0x33, 0x36,
    0x34, 0x36, 0x35, 0x36, 0x36, 0x37, 0x36, 0x38, 0x36, 0x39};
const uint8_t HuffDecoderCommon::table9_56_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_57_emit_[28] = {
    0x36, 0x3d, 0x36, 0x41, 0x36, 0x5f, 0x36, 0x62, 0x36, 0x64,
    0x36, 0x66, 0x36, 0x67, 0x36, 0x68, 0x36, 0x6c, 0x36, 0x6d,
    0x36, 0x6e, 0x36, 0x70, 0x36, 0x72, 0x36, 0x75};
const uint8_t HuffDecoderCommon::table9_58_emit_[43] = {
    0x37, 0x30, 0x37, 0x31, 0x37, 0x32, 0x37, 0x61, 0x37, 0x63, 0x37,
    0x65, 0x37, 0x69, 0x37, 0x6f, 0x37, 0x73, 0x37, 0x74, 0x37, 0x20,
    0x37, 0x25, 0x37, 0x2d, 0x37, 0x2e, 0x37, 0x2f, 0x37, 0x33, 0x37,
    0x34, 0x37, 0x35, 0x37, 0x36, 0x37, 0x37, 0x38, 0x37, 0x39};
const uint8_t HuffDecoderCommon::table9_58_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_59_emit_[28] = {
    0x37, 0x3d, 0x37, 0x41, 0x37, 0x5f, 0x37, 0x62, 0x37, 0x64,
    0x37, 0x66, 0x37, 0x67, 0x37, 0x68, 0x37, 0x6c, 0x37, 0x6d,
    0x37, 0x6e, 0x37, 0x70, 0x37, 0x72, 0x37, 0x75};
const uint8_t HuffDecoderCommon::table9_60_emit_[43] = {
    0x38, 0x30, 0x38, 0x31, 0x38, 0x32, 0x38, 0x61, 0x38, 0x63, 0x38,
    0x65, 0x38, 0x69, 0x38, 0x6f, 0x38, 0x73, 0x38, 0x74, 0x38, 0x20,
    0x38, 0x25, 0x38, 0x2d, 0x38, 0x2e, 0x38, 0x2f, 0x38, 0x33, 0x38,
    0x34, 0x38, 0x35, 0x38, 0x36, 0x38, 0x37, 0x38, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table9_60_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0xa1, 0xa5};
const uint8_t HuffDecoderCommon::table9_61_emit_[28] = {
    0x38, 0x3d, 0x38, 0x41, 0x38, 0x5f, 0x38, 0x62, 0x38, 0x64,
    0x38, 0x66, 0x38, 0x67, 0x38, 0x68, 0x38, 0x6c, 0x38, 0x6d,
    0x38, 0x6e, 0x38, 0x70, 0x38, 0x72, 0x38, 0x75};
const uint8_t HuffDecoderCommon::table9_62_emit_[44] = {
    0x39, 0x30, 0x39, 0x31, 0x39, 0x32, 0x39, 0x61, 0x39, 0x63, 0x39,
    0x65, 0x39, 0x69, 0x39, 0x6f, 0x39, 0x73, 0x39, 0x74, 0x39, 0x20,
    0x39, 0x25, 0x39, 0x2d, 0x39, 0x2e, 0x39, 0x2f, 0x39, 0x33, 0x39,
    0x34, 0x39, 0x35, 0x39, 0x36, 0x39, 0x37, 0x39, 0x38, 0x39, 0x39};
const uint8_t HuffDecoderCommon::table9_62_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0xa1, 0xa9};
const uint8_t HuffDecoderCommon::table9_63_emit_[28] = {
    0x39, 0x3d, 0x39, 0x41, 0x39, 0x5f, 0x39, 0x62, 0x39, 0x64,
    0x39, 0x66, 0x39, 0x67, 0x39, 0x68, 0x39, 0x6c, 0x39, 0x6d,
    0x39, 0x6e, 0x39, 0x70, 0x39, 0x72, 0x39, 0x75};
const uint8_t HuffDecoderCommon::table9_64_emit_[44] = {
    0x3d, 0x30, 0x3d, 0x31, 0x3d, 0x32, 0x3d, 0x61, 0x3d, 0x63, 0x3d,
    0x65, 0x3d, 0x69, 0x3d, 0x6f, 0x3d, 0x73, 0x3d, 0x74, 0x3d, 0x20,
    0x3d, 0x25, 0x3d, 0x2d, 0x3d, 0x2e, 0x3d, 0x2f, 0x3d, 0x33, 0x3d,
    0x34, 0x3d, 0x35, 0x3d, 0x36, 0x3d, 0x37, 0x3d, 0x38, 0x3d, 0x39};
const uint8_t HuffDecoderCommon::table9_65_emit_[27] = {
    0x3d, 0x3d, 0x41, 0x3d, 0x5f, 0x3d, 0x62, 0x3d, 0x64,
    0x3d, 0x66, 0x3d, 0x67, 0x3d, 0x68, 0x3d, 0x6c, 0x3d,
    0x6d, 0x3d, 0x6e, 0x3d, 0x70, 0x3d, 0x72, 0x3d, 0x75};
const uint8_t HuffDecoderCommon::table9_65_ops_[32] = {
    0x01, 0x05, 0x0d, 0x15, 0x1d, 0x25, 0x2d, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_66_emit_[44] = {
    0x41, 0x30, 0x41, 0x31, 0x41, 0x32, 0x41, 0x61, 0x41, 0x63, 0x41,
    0x65, 0x41, 0x69, 0x41, 0x6f, 0x41, 0x73, 0x41, 0x74, 0x41, 0x20,
    0x41, 0x25, 0x41, 0x2d, 0x41, 0x2e, 0x41, 0x2f, 0x41, 0x33, 0x41,
    0x34, 0x41, 0x35, 0x41, 0x36, 0x41, 0x37, 0x41, 0x38, 0x41, 0x39};
const uint8_t HuffDecoderCommon::table9_67_emit_[27] = {
    0x41, 0x3d, 0x41, 0x41, 0x5f, 0x41, 0x62, 0x41, 0x64,
    0x41, 0x66, 0x41, 0x67, 0x41, 0x68, 0x41, 0x6c, 0x41,
    0x6d, 0x41, 0x6e, 0x41, 0x70, 0x41, 0x72, 0x41, 0x75};
const uint8_t HuffDecoderCommon::table9_67_ops_[32] = {
    0x01, 0x09, 0x0d, 0x15, 0x1d, 0x25, 0x2d, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_68_emit_[44] = {
    0x5f, 0x30, 0x5f, 0x31, 0x5f, 0x32, 0x5f, 0x61, 0x5f, 0x63, 0x5f,
    0x65, 0x5f, 0x69, 0x5f, 0x6f, 0x5f, 0x73, 0x5f, 0x74, 0x5f, 0x20,
    0x5f, 0x25, 0x5f, 0x2d, 0x5f, 0x2e, 0x5f, 0x2f, 0x5f, 0x33, 0x5f,
    0x34, 0x5f, 0x35, 0x5f, 0x36, 0x5f, 0x37, 0x5f, 0x38, 0x5f, 0x39};
const uint8_t HuffDecoderCommon::table9_69_emit_[27] = {
    0x5f, 0x3d, 0x5f, 0x41, 0x5f, 0x5f, 0x62, 0x5f, 0x64,
    0x5f, 0x66, 0x5f, 0x67, 0x5f, 0x68, 0x5f, 0x6c, 0x5f,
    0x6d, 0x5f, 0x6e, 0x5f, 0x70, 0x5f, 0x72, 0x5f, 0x75};
const uint8_t HuffDecoderCommon::table9_69_ops_[32] = {
    0x01, 0x09, 0x11, 0x15, 0x1d, 0x25, 0x2d, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_70_emit_[44] = {
    0x62, 0x30, 0x62, 0x31, 0x62, 0x32, 0x62, 0x61, 0x62, 0x63, 0x62,
    0x65, 0x62, 0x69, 0x62, 0x6f, 0x62, 0x73, 0x62, 0x74, 0x62, 0x20,
    0x62, 0x25, 0x62, 0x2d, 0x62, 0x2e, 0x62, 0x2f, 0x62, 0x33, 0x62,
    0x34, 0x62, 0x35, 0x62, 0x36, 0x62, 0x37, 0x62, 0x38, 0x62, 0x39};
const uint8_t HuffDecoderCommon::table9_71_emit_[27] = {
    0x62, 0x3d, 0x62, 0x41, 0x62, 0x5f, 0x62, 0x62, 0x64,
    0x62, 0x66, 0x62, 0x67, 0x62, 0x68, 0x62, 0x6c, 0x62,
    0x6d, 0x62, 0x6e, 0x62, 0x70, 0x62, 0x72, 0x62, 0x75};
const uint8_t HuffDecoderCommon::table9_71_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x1d, 0x25, 0x2d, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_72_emit_[44] = {
    0x64, 0x30, 0x64, 0x31, 0x64, 0x32, 0x64, 0x61, 0x64, 0x63, 0x64,
    0x65, 0x64, 0x69, 0x64, 0x6f, 0x64, 0x73, 0x64, 0x74, 0x64, 0x20,
    0x64, 0x25, 0x64, 0x2d, 0x64, 0x2e, 0x64, 0x2f, 0x64, 0x33, 0x64,
    0x34, 0x64, 0x35, 0x64, 0x36, 0x64, 0x37, 0x64, 0x38, 0x64, 0x39};
const uint8_t HuffDecoderCommon::table9_73_emit_[27] = {
    0x64, 0x3d, 0x64, 0x41, 0x64, 0x5f, 0x64, 0x62, 0x64,
    0x64, 0x66, 0x64, 0x67, 0x64, 0x68, 0x64, 0x6c, 0x64,
    0x6d, 0x64, 0x6e, 0x64, 0x70, 0x64, 0x72, 0x64, 0x75};
const uint8_t HuffDecoderCommon::table9_73_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x25, 0x2d, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_74_emit_[44] = {
    0x66, 0x30, 0x66, 0x31, 0x66, 0x32, 0x66, 0x61, 0x66, 0x63, 0x66,
    0x65, 0x66, 0x69, 0x66, 0x6f, 0x66, 0x73, 0x66, 0x74, 0x66, 0x20,
    0x66, 0x25, 0x66, 0x2d, 0x66, 0x2e, 0x66, 0x2f, 0x66, 0x33, 0x66,
    0x34, 0x66, 0x35, 0x66, 0x36, 0x66, 0x37, 0x66, 0x38, 0x66, 0x39};
const uint8_t HuffDecoderCommon::table9_75_emit_[27] = {
    0x66, 0x3d, 0x66, 0x41, 0x66, 0x5f, 0x66, 0x62, 0x66,
    0x64, 0x66, 0x66, 0x67, 0x66, 0x68, 0x66, 0x6c, 0x66,
    0x6d, 0x66, 0x6e, 0x66, 0x70, 0x66, 0x72, 0x66, 0x75};
const uint8_t HuffDecoderCommon::table9_75_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x2d, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_76_emit_[44] = {
    0x67, 0x30, 0x67, 0x31, 0x67, 0x32, 0x67, 0x61, 0x67, 0x63, 0x67,
    0x65, 0x67, 0x69, 0x67, 0x6f, 0x67, 0x73, 0x67, 0x74, 0x67, 0x20,
    0x67, 0x25, 0x67, 0x2d, 0x67, 0x2e, 0x67, 0x2f, 0x67, 0x33, 0x67,
    0x34, 0x67, 0x35, 0x67, 0x36, 0x67, 0x37, 0x67, 0x38, 0x67, 0x39};
const uint8_t HuffDecoderCommon::table9_77_emit_[27] = {
    0x67, 0x3d, 0x67, 0x41, 0x67, 0x5f, 0x67, 0x62, 0x67,
    0x64, 0x67, 0x66, 0x67, 0x67, 0x68, 0x67, 0x6c, 0x67,
    0x6d, 0x67, 0x6e, 0x67, 0x70, 0x67, 0x72, 0x67, 0x75};
const uint8_t HuffDecoderCommon::table9_77_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_78_emit_[44] = {
    0x68, 0x30, 0x68, 0x31, 0x68, 0x32, 0x68, 0x61, 0x68, 0x63, 0x68,
    0x65, 0x68, 0x69, 0x68, 0x6f, 0x68, 0x73, 0x68, 0x74, 0x68, 0x20,
    0x68, 0x25, 0x68, 0x2d, 0x68, 0x2e, 0x68, 0x2f, 0x68, 0x33, 0x68,
    0x34, 0x68, 0x35, 0x68, 0x36, 0x68, 0x37, 0x68, 0x38, 0x68, 0x39};
const uint8_t HuffDecoderCommon::table9_79_emit_[27] = {
    0x68, 0x3d, 0x68, 0x41, 0x68, 0x5f, 0x68, 0x62, 0x68,
    0x64, 0x68, 0x66, 0x68, 0x67, 0x68, 0x68, 0x6c, 0x68,
    0x6d, 0x68, 0x6e, 0x68, 0x70, 0x68, 0x72, 0x68, 0x75};
const uint8_t HuffDecoderCommon::table9_79_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_80_emit_[44] = {
    0x6c, 0x30, 0x6c, 0x31, 0x6c, 0x32, 0x6c, 0x61, 0x6c, 0x63, 0x6c,
    0x65, 0x6c, 0x69, 0x6c, 0x6f, 0x6c, 0x73, 0x6c, 0x74, 0x6c, 0x20,
    0x6c, 0x25, 0x6c, 0x2d, 0x6c, 0x2e, 0x6c, 0x2f, 0x6c, 0x33, 0x6c,
    0x34, 0x6c, 0x35, 0x6c, 0x36, 0x6c, 0x37, 0x6c, 0x38, 0x6c, 0x39};
const uint8_t HuffDecoderCommon::table9_81_emit_[27] = {
    0x6c, 0x3d, 0x6c, 0x41, 0x6c, 0x5f, 0x6c, 0x62, 0x6c,
    0x64, 0x6c, 0x66, 0x6c, 0x67, 0x6c, 0x68, 0x6c, 0x6c,
    0x6d, 0x6c, 0x6e, 0x6c, 0x70, 0x6c, 0x72, 0x6c, 0x75};
const uint8_t HuffDecoderCommon::table9_81_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_82_emit_[44] = {
    0x6d, 0x30, 0x6d, 0x31, 0x6d, 0x32, 0x6d, 0x61, 0x6d, 0x63, 0x6d,
    0x65, 0x6d, 0x69, 0x6d, 0x6f, 0x6d, 0x73, 0x6d, 0x74, 0x6d, 0x20,
    0x6d, 0x25, 0x6d, 0x2d, 0x6d, 0x2e, 0x6d, 0x2f, 0x6d, 0x33, 0x6d,
    0x34, 0x6d, 0x35, 0x6d, 0x36, 0x6d, 0x37, 0x6d, 0x38, 0x6d, 0x39};
const uint8_t HuffDecoderCommon::table9_83_emit_[27] = {
    0x6d, 0x3d, 0x6d, 0x41, 0x6d, 0x5f, 0x6d, 0x62, 0x6d,
    0x64, 0x6d, 0x66, 0x6d, 0x67, 0x6d, 0x68, 0x6d, 0x6c,
    0x6d, 0x6d, 0x6e, 0x6d, 0x70, 0x6d, 0x72, 0x6d, 0x75};
const uint8_t HuffDecoderCommon::table9_83_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_84_emit_[44] = {
    0x6e, 0x30, 0x6e, 0x31, 0x6e, 0x32, 0x6e, 0x61, 0x6e, 0x63, 0x6e,
    0x65, 0x6e, 0x69, 0x6e, 0x6f, 0x6e, 0x73, 0x6e, 0x74, 0x6e, 0x20,
    0x6e, 0x25, 0x6e, 0x2d, 0x6e, 0x2e, 0x6e, 0x2f, 0x6e, 0x33, 0x6e,
    0x34, 0x6e, 0x35, 0x6e, 0x36, 0x6e, 0x37, 0x6e, 0x38, 0x6e, 0x39};
const uint8_t HuffDecoderCommon::table9_85_emit_[27] = {
    0x6e, 0x3d, 0x6e, 0x41, 0x6e, 0x5f, 0x6e, 0x62, 0x6e,
    0x64, 0x6e, 0x66, 0x6e, 0x67, 0x6e, 0x68, 0x6e, 0x6c,
    0x6e, 0x6d, 0x6e, 0x6e, 0x70, 0x6e, 0x72, 0x6e, 0x75};
const uint8_t HuffDecoderCommon::table9_85_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_86_emit_[44] = {
    0x70, 0x30, 0x70, 0x31, 0x70, 0x32, 0x70, 0x61, 0x70, 0x63, 0x70,
    0x65, 0x70, 0x69, 0x70, 0x6f, 0x70, 0x73, 0x70, 0x74, 0x70, 0x20,
    0x70, 0x25, 0x70, 0x2d, 0x70, 0x2e, 0x70, 0x2f, 0x70, 0x33, 0x70,
    0x34, 0x70, 0x35, 0x70, 0x36, 0x70, 0x37, 0x70, 0x38, 0x70, 0x39};
const uint8_t HuffDecoderCommon::table9_87_emit_[27] = {
    0x70, 0x3d, 0x70, 0x41, 0x70, 0x5f, 0x70, 0x62, 0x70,
    0x64, 0x70, 0x66, 0x70, 0x67, 0x70, 0x68, 0x70, 0x6c,
    0x70, 0x6d, 0x70, 0x6e, 0x70, 0x70, 0x72, 0x70, 0x75};
const uint8_t HuffDecoderCommon::table9_87_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_88_emit_[44] = {
    0x72, 0x30, 0x72, 0x31, 0x72, 0x32, 0x72, 0x61, 0x72, 0x63, 0x72,
    0x65, 0x72, 0x69, 0x72, 0x6f, 0x72, 0x73, 0x72, 0x74, 0x72, 0x20,
    0x72, 0x25, 0x72, 0x2d, 0x72, 0x2e, 0x72, 0x2f, 0x72, 0x33, 0x72,
    0x34, 0x72, 0x35, 0x72, 0x36, 0x72, 0x37, 0x72, 0x38, 0x72, 0x39};
const uint8_t HuffDecoderCommon::table9_89_emit_[27] = {
    0x72, 0x3d, 0x72, 0x41, 0x72, 0x5f, 0x72, 0x62, 0x72,
    0x64, 0x72, 0x66, 0x72, 0x67, 0x72, 0x68, 0x72, 0x6c,
    0x72, 0x6d, 0x72, 0x6e, 0x72, 0x70, 0x72, 0x72, 0x75};
const uint8_t HuffDecoderCommon::table9_89_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x61, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_90_emit_[44] = {
    0x75, 0x30, 0x75, 0x31, 0x75, 0x32, 0x75, 0x61, 0x75, 0x63, 0x75,
    0x65, 0x75, 0x69, 0x75, 0x6f, 0x75, 0x73, 0x75, 0x74, 0x75, 0x20,
    0x75, 0x25, 0x75, 0x2d, 0x75, 0x2e, 0x75, 0x2f, 0x75, 0x33, 0x75,
    0x34, 0x75, 0x35, 0x75, 0x36, 0x75, 0x37, 0x75, 0x38, 0x75, 0x39};
const uint8_t HuffDecoderCommon::table9_91_emit_[28] = {
    0x75, 0x3d, 0x75, 0x41, 0x75, 0x5f, 0x75, 0x62, 0x75, 0x64,
    0x75, 0x66, 0x75, 0x67, 0x75, 0x68, 0x75, 0x6c, 0x75, 0x6d,
    0x75, 0x6e, 0x75, 0x70, 0x75, 0x72, 0x75, 0x75};
const uint8_t HuffDecoderCommon::table9_92_emit_[20] = {
    0x3a, 0x30, 0x3a, 0x31, 0x3a, 0x32, 0x3a, 0x61, 0x3a, 0x63,
    0x3a, 0x65, 0x3a, 0x69, 0x3a, 0x6f, 0x3a, 0x73, 0x3a, 0x74};
const uint8_t HuffDecoderCommon::table9_92_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_93_emit_[20] = {
    0x42, 0x30, 0x42, 0x31, 0x42, 0x32, 0x42, 0x61, 0x42, 0x63,
    0x42, 0x65, 0x42, 0x69, 0x42, 0x6f, 0x42, 0x73, 0x42, 0x74};
const uint8_t HuffDecoderCommon::table9_94_emit_[20] = {
    0x43, 0x30, 0x43, 0x31, 0x43, 0x32, 0x43, 0x61, 0x43, 0x63,
    0x43, 0x65, 0x43, 0x69, 0x43, 0x6f, 0x43, 0x73, 0x43, 0x74};
const uint8_t HuffDecoderCommon::table9_95_emit_[20] = {
    0x44, 0x30, 0x44, 0x31, 0x44, 0x32, 0x44, 0x61, 0x44, 0x63,
    0x44, 0x65, 0x44, 0x69, 0x44, 0x6f, 0x44, 0x73, 0x44, 0x74};
const uint8_t HuffDecoderCommon::table9_96_emit_[20] = {
    0x45, 0x30, 0x45, 0x31, 0x45, 0x32, 0x45, 0x61, 0x45, 0x63,
    0x45, 0x65, 0x45, 0x69, 0x45, 0x6f, 0x45, 0x73, 0x45, 0x74};
const uint8_t HuffDecoderCommon::table9_97_emit_[20] = {
    0x46, 0x30, 0x46, 0x31, 0x46, 0x32, 0x46, 0x61, 0x46, 0x63,
    0x46, 0x65, 0x46, 0x69, 0x46, 0x6f, 0x46, 0x73, 0x46, 0x74};
const uint8_t HuffDecoderCommon::table9_98_emit_[20] = {
    0x47, 0x30, 0x47, 0x31, 0x47, 0x32, 0x47, 0x61, 0x47, 0x63,
    0x47, 0x65, 0x47, 0x69, 0x47, 0x6f, 0x47, 0x73, 0x47, 0x74};
const uint8_t HuffDecoderCommon::table9_99_emit_[20] = {
    0x48, 0x30, 0x48, 0x31, 0x48, 0x32, 0x48, 0x61, 0x48, 0x63,
    0x48, 0x65, 0x48, 0x69, 0x48, 0x6f, 0x48, 0x73, 0x48, 0x74};
const uint8_t HuffDecoderCommon::table9_100_emit_[20] = {
    0x49, 0x30, 0x49, 0x31, 0x49, 0x32, 0x49, 0x61, 0x49, 0x63,
    0x49, 0x65, 0x49, 0x69, 0x49, 0x6f, 0x49, 0x73, 0x49, 0x74};
const uint8_t HuffDecoderCommon::table9_101_emit_[20] = {
    0x4a, 0x30, 0x4a, 0x31, 0x4a, 0x32, 0x4a, 0x61, 0x4a, 0x63,
    0x4a, 0x65, 0x4a, 0x69, 0x4a, 0x6f, 0x4a, 0x73, 0x4a, 0x74};
const uint8_t HuffDecoderCommon::table9_102_emit_[20] = {
    0x4b, 0x30, 0x4b, 0x31, 0x4b, 0x32, 0x4b, 0x61, 0x4b, 0x63,
    0x4b, 0x65, 0x4b, 0x69, 0x4b, 0x6f, 0x4b, 0x73, 0x4b, 0x74};
const uint8_t HuffDecoderCommon::table9_103_emit_[20] = {
    0x4c, 0x30, 0x4c, 0x31, 0x4c, 0x32, 0x4c, 0x61, 0x4c, 0x63,
    0x4c, 0x65, 0x4c, 0x69, 0x4c, 0x6f, 0x4c, 0x73, 0x4c, 0x74};
const uint8_t HuffDecoderCommon::table9_104_emit_[20] = {
    0x4d, 0x30, 0x4d, 0x31, 0x4d, 0x32, 0x4d, 0x61, 0x4d, 0x63,
    0x4d, 0x65, 0x4d, 0x69, 0x4d, 0x6f, 0x4d, 0x73, 0x4d, 0x74};
const uint8_t HuffDecoderCommon::table9_105_emit_[20] = {
    0x4e, 0x30, 0x4e, 0x31, 0x4e, 0x32, 0x4e, 0x61, 0x4e, 0x63,
    0x4e, 0x65, 0x4e, 0x69, 0x4e, 0x6f, 0x4e, 0x73, 0x4e, 0x74};
const uint8_t HuffDecoderCommon::table9_106_emit_[20] = {
    0x4f, 0x30, 0x4f, 0x31, 0x4f, 0x32, 0x4f, 0x61, 0x4f, 0x63,
    0x4f, 0x65, 0x4f, 0x69, 0x4f, 0x6f, 0x4f, 0x73, 0x4f, 0x74};
const uint8_t HuffDecoderCommon::table9_107_emit_[20] = {
    0x50, 0x30, 0x50, 0x31, 0x50, 0x32, 0x50, 0x61, 0x50, 0x63,
    0x50, 0x65, 0x50, 0x69, 0x50, 0x6f, 0x50, 0x73, 0x50, 0x74};
const uint8_t HuffDecoderCommon::table9_108_emit_[20] = {
    0x51, 0x30, 0x51, 0x31, 0x51, 0x32, 0x51, 0x61, 0x51, 0x63,
    0x51, 0x65, 0x51, 0x69, 0x51, 0x6f, 0x51, 0x73, 0x51, 0x74};
const uint8_t HuffDecoderCommon::table9_109_emit_[20] = {
    0x52, 0x30, 0x52, 0x31, 0x52, 0x32, 0x52, 0x61, 0x52, 0x63,
    0x52, 0x65, 0x52, 0x69, 0x52, 0x6f, 0x52, 0x73, 0x52, 0x74};
const uint8_t HuffDecoderCommon::table9_110_emit_[20] = {
    0x53, 0x30, 0x53, 0x31, 0x53, 0x32, 0x53, 0x61, 0x53, 0x63,
    0x53, 0x65, 0x53, 0x69, 0x53, 0x6f, 0x53, 0x73, 0x53, 0x74};
const uint8_t HuffDecoderCommon::table9_111_emit_[20] = {
    0x54, 0x30, 0x54, 0x31, 0x54, 0x32, 0x54, 0x61, 0x54, 0x63,
    0x54, 0x65, 0x54, 0x69, 0x54, 0x6f, 0x54, 0x73, 0x54, 0x74};
const uint8_t HuffDecoderCommon::table9_112_emit_[20] = {
    0x55, 0x30, 0x55, 0x31, 0x55, 0x32, 0x55, 0x61, 0x55, 0x63,
    0x55, 0x65, 0x55, 0x69, 0x55, 0x6f, 0x55, 0x73, 0x55, 0x74};
const uint8_t HuffDecoderCommon::table9_113_emit_[20] = {
    0x56, 0x30, 0x56, 0x31, 0x56, 0x32, 0x56, 0x61, 0x56, 0x63,
    0x56, 0x65, 0x56, 0x69, 0x56, 0x6f, 0x56, 0x73, 0x56, 0x74};
const uint8_t HuffDecoderCommon::table9_114_emit_[20] = {
    0x57, 0x30, 0x57, 0x31, 0x57, 0x32, 0x57, 0x61, 0x57, 0x63,
    0x57, 0x65, 0x57, 0x69, 0x57, 0x6f, 0x57, 0x73, 0x57, 0x74};
const uint8_t HuffDecoderCommon::table9_115_emit_[20] = {
    0x59, 0x30, 0x59, 0x31, 0x59, 0x32, 0x59, 0x61, 0x59, 0x63,
    0x59, 0x65, 0x59, 0x69, 0x59, 0x6f, 0x59, 0x73, 0x59, 0x74};
const uint8_t HuffDecoderCommon::table9_116_emit_[20] = {
    0x6a, 0x30, 0x6a, 0x31, 0x6a, 0x32, 0x6a, 0x61, 0x6a, 0x63,
    0x6a, 0x65, 0x6a, 0x69, 0x6a, 0x6f, 0x6a, 0x73, 0x6a, 0x74};
const uint8_t HuffDecoderCommon::table9_117_emit_[20] = {
    0x6b, 0x30, 0x6b, 0x31, 0x6b, 0x32, 0x6b, 0x61, 0x6b, 0x63,
    0x6b, 0x65, 0x6b, 0x69, 0x6b, 0x6f, 0x6b, 0x73, 0x6b, 0x74};
const uint8_t HuffDecoderCommon::table9_118_emit_[20] = {
    0x71, 0x30, 0x71, 0x31, 0x71, 0x32, 0x71, 0x61, 0x71, 0x63,
    0x71, 0x65, 0x71, 0x69, 0x71, 0x6f, 0x71, 0x73, 0x71, 0x74};
const uint8_t HuffDecoderCommon::table9_119_emit_[20] = {
    0x76, 0x30, 0x76, 0x31, 0x76, 0x32, 0x76, 0x61, 0x76, 0x63,
    0x76, 0x65, 0x76, 0x69, 0x76, 0x6f, 0x76, 0x73, 0x76, 0x74};
const uint8_t HuffDecoderCommon::table9_120_emit_[20] = {
    0x77, 0x30, 0x77, 0x31, 0x77, 0x32, 0x77, 0x61, 0x77, 0x63,
    0x77, 0x65, 0x77, 0x69, 0x77, 0x6f, 0x77, 0x73, 0x77, 0x74};
const uint8_t HuffDecoderCommon::table9_121_emit_[20] = {
    0x78, 0x30, 0x78, 0x31, 0x78, 0x32, 0x78, 0x61, 0x78, 0x63,
    0x78, 0x65, 0x78, 0x69, 0x78, 0x6f, 0x78, 0x73, 0x78, 0x74};
const uint8_t HuffDecoderCommon::table9_122_emit_[20] = {
    0x79, 0x30, 0x79, 0x31, 0x79, 0x32, 0x79, 0x61, 0x79, 0x63,
    0x79, 0x65, 0x79, 0x69, 0x79, 0x6f, 0x79, 0x73, 0x79, 0x74};
const uint8_t HuffDecoderCommon::table9_123_emit_[20] = {
    0x7a, 0x30, 0x7a, 0x31, 0x7a, 0x32, 0x7a, 0x61, 0x7a, 0x63,
    0x7a, 0x65, 0x7a, 0x69, 0x7a, 0x6f, 0x7a, 0x73, 0x7a, 0x74};
const uint8_t HuffDecoderCommon::table9_124_emit_[2] = {0x26, 0x2a};
const uint8_t HuffDecoderCommon::table9_124_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06};
const uint8_t HuffDecoderCommon::table9_125_emit_[2] = {0x2c, 0x3b};
const uint8_t HuffDecoderCommon::table9_126_emit_[2] = {0x58, 0x5a};
const uint8_t HuffDecoderCommon::table9_127_emit_[10] = {
    0x21, 0x22, 0x28, 0x29, 0x3f, 0x27, 0x2b, 0x7c, 0x23, 0x3e};
const uint8_t HuffDecoderCommon::table9_127_ops_[32] = {
    0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x0a, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x12, 0x00, 0x16,
    0x00, 0x1a, 0x00, 0x1e, 0x22, 0x26, 0x00, 0x00, 0x00, 0x03};
const uint8_t* const HuffDecoderCommon::table9_emit_[128] = {
    table9_0_emit_,   table9_1_emit_,   table9_2_emit_,   table9_3_emit_,
    table9_4_emit_,   table9_5_emit_,   table9_6_emit_,   table9_7_emit_,
    table9_8_emit_,   table9_9_emit_,   table9_10_emit_,  table9_11_emit_,
    table9_12_emit_,  table9_13_emit_,  table9_14_emit_,  table9_15_emit_,
    table9_16_emit_,  table9_17_emit_,  table9_18_emit_,  table9_19_emit_,
    table9_20_emit_,  table9_21_emit_,  table9_22_emit_,  table9_23_emit_,
    table9_24_emit_,  table9_25_emit_,  table9_26_emit_,  table9_27_emit_,
    table9_28_emit_,  table9_29_emit_,  table9_30_emit_,  table9_31_emit_,
    table9_32_emit_,  table9_33_emit_,  table9_34_emit_,  table9_35_emit_,
    table9_36_emit_,  table9_37_emit_,  table9_38_emit_,  table9_39_emit_,
    table9_40_emit_,  table9_41_emit_,  table9_42_emit_,  table9_43_emit_,
    table9_44_emit_,  table9_45_emit_,  table9_46_emit_,  table9_47_emit_,
    table9_48_emit_,  table9_49_emit_,  table9_50_emit_,  table9_51_emit_,
    table9_52_emit_,  table9_53_emit_,  table9_54_emit_,  table9_55_emit_,
    table9_56_emit_,  table9_57_emit_,  table9_58_emit_,  table9_59_emit_,
    table9_60_emit_,  table9_61_emit_,  table9_62_emit_,  table9_63_emit_,
    table9_64_emit_,  table9_65_emit_,  table9_66_emit_,  table9_67_emit_,
    table9_68_emit_,  table9_69_emit_,  table9_70_emit_,  table9_71_emit_,
    table9_72_emit_,  table9_73_emit_,  table9_74_emit_,  table9_75_emit_,
    table9_76_emit_,  table9_77_emit_,  table9_78_emit_,  table9_79_emit_,
    table9_80_emit_,  table9_81_emit_,  table9_82_emit_,  table9_83_emit_,
    table9_84_emit_,  table9_85_emit_,  table9_86_emit_,  table9_87_emit_,
    table9_88_emit_,  table9_89_emit_,  table9_90_emit_,  table9_91_emit_,
    table9_92_emit_,  table9_93_emit_,  table9_94_emit_,  table9_95_emit_,
    table9_96_emit_,  table9_97_emit_,  table9_98_emit_,  table9_99_emit_,
    table9_100_emit_, table9_101_emit_, table9_102_emit_, table9_103_emit_,
    table9_104_emit_, table9_105_emit_, table9_106_emit_, table9_107_emit_,
    table9_108_emit_, table9_109_emit_, table9_110_emit_, table9_111_emit_,
    table9_112_emit_, table9_113_emit_, table9_114_emit_, table9_115_emit_,
    table9_116_emit_, table9_117_emit_, table9_118_emit_, table9_119_emit_,
    table9_120_emit_, table9_121_emit_, table9_122_emit_, table9_123_emit_,
    table9_124_emit_, table9_125_emit_, table9_126_emit_, table9_127_emit_,
};
const uint8_t* const HuffDecoderCommon::table9_ops_[128] = {
    table9_0_ops_,   table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_4_ops_,   table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_8_ops_,   table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_12_ops_,  table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_16_ops_,  table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_20_ops_,  table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_24_ops_,  table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_28_ops_,  table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_28_ops_,  table9_33_ops_,  table9_2_ops_,   table9_3_ops_,
    table9_28_ops_,  table9_37_ops_,  table9_2_ops_,   table9_3_ops_,
    table9_40_ops_,  table9_41_ops_,  table9_42_ops_,  table9_41_ops_,
    table9_44_ops_,  table9_41_ops_,  table9_46_ops_,  table9_41_ops_,
    table9_48_ops_,  table9_41_ops_,  table9_50_ops_,  table9_41_ops_,
    table9_52_ops_,  table9_41_ops_,  table9_54_ops_,  table9_41_ops_,
    table9_56_ops_,  table9_41_ops_,  table9_58_ops_,  table9_41_ops_,
    table9_60_ops_,  table9_41_ops_,  table9_62_ops_,  table9_41_ops_,
    table9_62_ops_,  table9_65_ops_,  table9_62_ops_,  table9_67_ops_,
    table9_62_ops_,  table9_69_ops_,  table9_62_ops_,  table9_71_ops_,
    table9_62_ops_,  table9_73_ops_,  table9_62_ops_,  table9_75_ops_,
    table9_62_ops_,  table9_77_ops_,  table9_62_ops_,  table9_79_ops_,
    table9_62_ops_,  table9_81_ops_,  table9_62_ops_,  table9_83_ops_,
    table9_62_ops_,  table9_85_ops_,  table9_62_ops_,  table9_87_ops_,
    table9_62_ops_,  table9_89_ops_,  table9_62_ops_,  table9_41_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_124_ops_, table9_124_ops_, table9_124_ops_, table9_127_ops_,
};
const uint16_t HuffDecoderCommon::table1_0_inner_[8] = {
    0x000a, 0x004a, 0x00ca, 0x014a, 0x01ca, 0x024a, 0x02ca, 0x034a};
const uint8_t HuffDecoderCommon::table1_0_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
    2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5,
    5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7};
const uint16_t HuffDecoderCommon::table1_1_inner_[14] = {
    0x000a, 0x008a, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b,
    0x038b, 0x040b, 0x048b, 0x050b, 0x058b, 0x060b, 0x068b};
const uint8_t HuffDecoderCommon::table1_1_outer_[64] = {
    0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,
    2,  2,  2,  2,  3,  3,  3,  3,  4,  4,  4,  4,  5,  5,  5,  5,
    6,  6,  6,  6,  7,  7,  7,  7,  8,  8,  8,  8,  9,  9,  9,  9,
    10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13};
const uint16_t HuffDecoderCommon::table1_2_inner_[18] = {
    0x000b, 0x008b, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b, 0x038b, 0x040b,
    0x048b, 0x050b, 0x058b, 0x060b, 0x068b, 0x070c, 0x078c, 0x080c, 0x088c};
const uint8_t HuffDecoderCommon::table1_2_outer_[64] = {
    0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  2,  3,  3,  3,  3,
    4,  4,  4,  4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,
    8,  8,  8,  8,  9,  9,  9,  9,  10, 10, 10, 10, 11, 11, 11, 11,
    12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17};
const uint8_t HuffDecoderCommon::table1_3_emit_[68] = {
    0x30, 0x45, 0x30, 0x46, 0x30, 0x47, 0x30, 0x48, 0x30, 0x49, 0x30, 0x4a,
    0x30, 0x4b, 0x30, 0x4c, 0x30, 0x4d, 0x30, 0x4e, 0x30, 0x4f, 0x30, 0x50,
    0x30, 0x51, 0x30, 0x52, 0x30, 0x53, 0x30, 0x54, 0x30, 0x55, 0x30, 0x56,
    0x30, 0x57, 0x30, 0x59, 0x30, 0x6a, 0x30, 0x6b, 0x30, 0x71, 0x30, 0x76,
    0x30, 0x77, 0x30, 0x78, 0x30, 0x79, 0x30, 0x7a, 0x30, 0x26, 0x30, 0x2a,
    0x30, 0x2c, 0x30, 0x3b, 0x30, 0x58, 0x30, 0x5a};
const uint16_t HuffDecoderCommon::table1_3_inner_[35] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x020c, 0x028c, 0x030c, 0x038c, 0x040c,
    0x048c, 0x050c, 0x058c, 0x060c, 0x068c, 0x070c, 0x078c, 0x080c, 0x088c,
    0x090c, 0x098c, 0x0a0c, 0x0a8c, 0x0b0c, 0x0b8c, 0x0c0c, 0x0c8c, 0x0d0c,
    0x0d8c, 0x0e0d, 0x0e8d, 0x0f0d, 0x0f8d, 0x100d, 0x108d, 0x0015};
const uint8_t HuffDecoderCommon::table1_3_outer_[64] = {
    0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
    8,  8,  9,  9,  10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15,
    16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23,
    24, 24, 25, 25, 26, 26, 27, 27, 28, 29, 30, 31, 32, 33, 34, 34};
const uint16_t HuffDecoderCommon::table1_4_inner_[8] = {
    0x000a, 0x008a, 0x00ca, 0x014a, 0x01ca, 0x024a, 0x02ca, 0x034a};
const uint8_t HuffDecoderCommon::table1_7_emit_[68] = {
    0x31, 0x45, 0x31, 0x46, 0x31, 0x47, 0x31, 0x48, 0x31, 0x49, 0x31, 0x4a,
    0x31, 0x4b, 0x31, 0x4c, 0x31, 0x4d, 0x31, 0x4e, 0x31, 0x4f, 0x31, 0x50,
    0x31, 0x51, 0x31, 0x52, 0x31, 0x53, 0x31, 0x54, 0x31, 0x55, 0x31, 0x56,
    0x31, 0x57, 0x31, 0x59, 0x31, 0x6a, 0x31, 0x6b, 0x31, 0x71, 0x31, 0x76,
    0x31, 0x77, 0x31, 0x78, 0x31, 0x79, 0x31, 0x7a, 0x31, 0x26, 0x31, 0x2a,
    0x31, 0x2c, 0x31, 0x3b, 0x31, 0x58, 0x31, 0x5a};
const uint16_t HuffDecoderCommon::table1_8_inner_[8] = {
    0x000a, 0x008a, 0x010a, 0x014a, 0x01ca, 0x024a, 0x02ca, 0x034a};
const uint8_t HuffDecoderCommon::table1_11_emit_[68] = {
    0x32, 0x45, 0x32, 0x46, 0x32, 0x47, 0x32, 0x48, 0x32, 0x49, 0x32, 0x4a,
    0x32, 0x4b, 0x32, 0x4c, 0x32, 0x4d, 0x32, 0x4e, 0x32, 0x4f, 0x32, 0x50,
    0x32, 0x51, 0x32, 0x52, 0x32, 0x53, 0x32, 0x54, 0x32, 0x55, 0x32, 0x56,
    0x32, 0x57, 0x32, 0x59, 0x32, 0x6a, 0x32, 0x6b, 0x32, 0x71, 0x32, 0x76,
    0x32, 0x77, 0x32, 0x78, 0x32, 0x79, 0x32, 0x7a, 0x32, 0x26, 0x32, 0x2a,
    0x32, 0x2c, 0x32, 0x3b, 0x32, 0x58, 0x32, 0x5a};
const uint16_t HuffDecoderCommon::table1_12_inner_[8] = {
    0x000a, 0x008a, 0x010a, 0x018a, 0x01ca, 0x024a, 0x02ca, 0x034a};
const uint8_t HuffDecoderCommon::table1_15_emit_[68] = {
    0x61, 0x45, 0x61, 0x46, 0x61, 0x47, 0x61, 0x48, 0x61, 0x49, 0x61, 0x4a,
    0x61, 0x4b, 0x61, 0x4c, 0x61, 0x4d, 0x61, 0x4e, 0x61, 0x4f, 0x61, 0x50,
    0x61, 0x51, 0x61, 0x52, 0x61, 0x53, 0x61, 0x54, 0x61, 0x55, 0x61, 0x56,
    0x61, 0x57, 0x61, 0x59, 0x61, 0x6a, 0x61, 0x6b, 0x61, 0x71, 0x61, 0x76,
    0x61, 0x77, 0x61, 0x78, 0x61, 0x79, 0x61, 0x7a, 0x61, 0x26, 0x61, 0x2a,
    0x61, 0x2c, 0x61, 0x3b, 0x61, 0x58, 0x61, 0x5a};
const uint16_t HuffDecoderCommon::table1_16_inner_[8] = {
    0x000a, 0x008a, 0x010a, 0x018a, 0x020a, 0x024a, 0x02ca, 0x034a};
const uint8_t HuffDecoderCommon::table1_19_emit_[68] = {
    0x63, 0x45, 0x63, 0x46, 0x63, 0x47, 0x63, 0x48, 0x63, 0x49, 0x63, 0x4a,
    0x63, 0x4b, 0x63, 0x4c, 0x63, 0x4d, 0x63, 0x4e, 0x63, 0x4f, 0x63, 0x50,
    0x63, 0x51, 0x63, 0x52, 0x63, 0x53, 0x63, 0x54, 0x63, 0x55, 0x63, 0x56,
    0x63, 0x57, 0x63, 0x59, 0x63, 0x6a, 0x63, 0x6b, 0x63, 0x71, 0x63, 0x76,
    0x63, 0x77, 0x63, 0x78, 0x63, 0x79, 0x63, 0x7a, 0x63, 0x26, 0x63, 0x2a,
    0x63, 0x2c, 0x63, 0x3b, 0x63, 0x58, 0x63, 0x5a};
const uint16_t HuffDecoderCommon::table1_20_inner_[8] = {
    0x000a, 0x008a, 0x010a, 0x018a, 0x020a, 0x028a, 0x02ca, 0x034a};
const uint8_t HuffDecoderCommon::table1_23_emit_[68] = {
    0x65, 0x45, 0x65, 0x46, 0x65, 0x47, 0x65, 0x48, 0x65, 0x49, 0x65, 0x4a,
    0x65, 0x4b, 0x65, 0x4c, 0x65, 0x4d, 0x65, 0x4e, 0x65, 0x4f, 0x65, 0x50,
    0x65, 0x51, 0x65, 0x52, 0x65, 0x53, 0x65, 0x54, 0x65, 0x55, 0x65, 0x56,
    0x65, 0x57, 0x65, 0x59, 0x65, 0x6a, 0x65, 0x6b, 0x65, 0x71, 0x65, 0x76,
    0x65, 0x77, 0x65, 0x78, 0x65, 0x79, 0x65, 0x7a, 0x65, 0x26, 0x65, 0x2a,
    0x65, 0x2c, 0x65, 0x3b, 0x65, 0x58, 0x65, 0x5a};
const uint16_t HuffDecoderCommon::table1_24_inner_[8] = {
    0x000a, 0x008a, 0x010a, 0x018a, 0x020a, 0x028a, 0x030a, 0x034a};
const uint8_t HuffDecoderCommon::table1_27_emit_[68] = {
    0x69, 0x45, 0x69, 0x46, 0x69, 0x47, 0x69, 0x48, 0x69, 0x49, 0x69, 0x4a,
    0x69, 0x4b, 0x69, 0x4c, 0x69, 0x4d, 0x69, 0x4e, 0x69, 0x4f, 0x69, 0x50,
    0x69, 0x51, 0x69, 0x52, 0x69, 0x53, 0x69, 0x54, 0x69, 0x55, 0x69, 0x56,
    0x69, 0x57, 0x69, 0x59, 0x69, 0x6a, 0x69, 0x6b, 0x69, 0x71, 0x69, 0x76,
    0x69, 0x77, 0x69, 0x78, 0x69, 0x79, 0x69, 0x7a, 0x69, 0x26, 0x69, 0x2a,
    0x69, 0x2c, 0x69, 0x3b, 0x69, 0x58, 0x69, 0x5a};
const uint16_t HuffDecoderCommon::table1_28_inner_[8] = {
    0x000a, 0x008a, 0x010a, 0x018a, 0x020a, 0x028a, 0x030a, 0x038a};
const uint8_t HuffDecoderCommon::table1_31_emit_[68] = {
    0x6f, 0x45, 0x6f, 0x46, 0x6f, 0x47, 0x6f, 0x48, 0x6f, 0x49, 0x6f, 0x4a,
    0x6f, 0x4b, 0x6f, 0x4c, 0x6f, 0x4d, 0x6f, 0x4e, 0x6f, 0x4f, 0x6f, 0x50,
    0x6f, 0x51, 0x6f, 0x52, 0x6f, 0x53, 0x6f, 0x54, 0x6f, 0x55, 0x6f, 0x56,
    0x6f, 0x57, 0x6f, 0x59, 0x6f, 0x6a, 0x6f, 0x6b, 0x6f, 0x71, 0x6f, 0x76,
    0x6f, 0x77, 0x6f, 0x78, 0x6f, 0x79, 0x6f, 0x7a, 0x6f, 0x26, 0x6f, 0x2a,
    0x6f, 0x2c, 0x6f, 0x3b, 0x6f, 0x58, 0x6f, 0x5a};
const uint16_t HuffDecoderCommon::table1_33_inner_[14] = {
    0x000a, 0x004a, 0x00cb, 0x014b, 0x01cb, 0x024b, 0x02cb,
    0x034b, 0x03cb, 0x044b, 0x04cb, 0x054b, 0x05cb, 0x064b};
const uint8_t HuffDecoderCommon::table1_35_emit_[68] = {
    0x73, 0x45, 0x73, 0x46, 0x73, 0x47, 0x73, 0x48, 0x73, 0x49, 0x73, 0x4a,
    0x73, 0x4b, 0x73, 0x4c, 0x73, 0x4d, 0x73, 0x4e, 0x73, 0x4f, 0x73, 0x50,
    0x73, 0x51, 0x73, 0x52, 0x73, 0x53, 0x73, 0x54, 0x73, 0x55, 0x73, 0x56,
    0x73, 0x57, 0x73, 0x59, 0x73, 0x6a, 0x73, 0x6b, 0x73, 0x71, 0x73, 0x76,
    0x73, 0x77, 0x73, 0x78, 0x73, 0x79, 0x73, 0x7a, 0x73, 0x26, 0x73, 0x2a,
    0x73, 0x2c, 0x73, 0x3b, 0x73, 0x58, 0x73, 0x5a};
const uint16_t HuffDecoderCommon::table1_37_inner_[14] = {
    0x000a, 0x008a, 0x00cb, 0x014b, 0x01cb, 0x024b, 0x02cb,
    0x034b, 0x03cb, 0x044b, 0x04cb, 0x054b, 0x05cb, 0x064b};
const uint8_t HuffDecoderCommon::table1_39_emit_[68] = {
    0x74, 0x45, 0x74, 0x46, 0x74, 0x47, 0x74, 0x48, 0x74, 0x49, 0x74, 0x4a,
    0x74, 0x4b, 0x74, 0x4c, 0x74, 0x4d, 0x74, 0x4e, 0x74, 0x4f, 0x74, 0x50,
    0x74, 0x51, 0x74, 0x52, 0x74, 0x53, 0x74, 0x54, 0x74, 0x55, 0x74, 0x56,
    0x74, 0x57, 0x74, 0x59, 0x74, 0x6a, 0x74, 0x6b, 0x74, 0x71, 0x74, 0x76,
    0x74, 0x77, 0x74, 0x78, 0x74, 0x79, 0x74, 0x7a, 0x74, 0x26, 0x74, 0x2a,
    0x74, 0x2c, 0x74, 0x3b, 0x74, 0x58, 0x74, 0x5a};
const uint16_t HuffDecoderCommon::table1_40_inner_[22] = {
    0x000b, 0x008b, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b, 0x038b,
    0x040b, 0x048b, 0x050c, 0x054c, 0x05cc, 0x064c, 0x06cc, 0x074c,
    0x07cc, 0x084c, 0x08cc, 0x094c, 0x09cc, 0x0a4c};
const uint8_t HuffDecoderCommon::table1_40_outer_[64] = {
    0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  2,  3,  3,  3,  3,
    4,  4,  4,  4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,
    8,  8,  8,  8,  9,  9,  9,  9,  10, 10, 11, 11, 12, 12, 13, 13,
    14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21};
const uint8_t HuffDecoderCommon::table1_41_emit_[92] = {
    0x20, 0x3d, 0x20, 0x41, 0x20, 0x5f, 0x20, 0x62, 0x20, 0x64, 0x20, 0x66,
    0x20, 0x67, 0x20, 0x68, 0x20, 0x6c, 0x20, 0x6d, 0x20, 0x6e, 0x20, 0x70,
    0x20, 0x72, 0x20, 0x75, 0x20, 0x3a, 0x20, 0x42, 0x20, 0x43, 0x20, 0x44,
    0x20, 0x45, 0x20, 0x46, 0x20, 0x47, 0x20, 0x48, 0x20, 0x49, 0x20, 0x4a,
    0x20, 0x4b, 0x20, 0x4c, 0x20, 0x4d, 0x20, 0x4e, 0x20, 0x4f, 0x20, 0x50,
    0x20, 0x51, 0x20, 0x52, 0x20, 0x53, 0x20, 0x54, 0x20, 0x55, 0x20, 0x56,
    0x20, 0x57, 0x20, 0x59, 0x20, 0x6a, 0x20, 0x6b, 0x20, 0x71, 0x20, 0x76,
    0x20, 0x77, 0x20, 0x78, 0x20, 0x79, 0x20, 0x7a};
const uint16_t HuffDecoderCommon::table1_41_inner_[47] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x020c, 0x028c, 0x030c, 0x038c,
    0x040c, 0x048c, 0x050c, 0x058c, 0x060c, 0x068c, 0x070d, 0x078d,
    0x080d, 0x088d, 0x090d, 0x098d, 0x0a0d, 0x0a8d, 0x0b0d, 0x0b8d,
    0x0c0d, 0x0c8d, 0x0d0d, 0x0d8d, 0x0e0d, 0x0e8d, 0x0f0d, 0x0f8d,
    0x100d, 0x108d, 0x110d, 0x118d, 0x120d, 0x128d, 0x130d, 0x138d,
    0x140d, 0x148d, 0x150d, 0x158d, 0x160d, 0x168d, 0x0016};
const uint8_t HuffDecoderCommon::table1_41_outer_[64] = {
    0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
    8,  8,  9,  9,  10, 10, 11, 11, 12, 12, 13, 13, 14, 15, 16, 17,
    18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
    34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 46, 46, 46};
const uint16_t HuffDecoderCommon::table1_42_inner_[22] = {
    0x000b, 0x008b, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b, 0x038b,
    0x040b, 0x048b, 0x050c, 0x058c, 0x05cc, 0x064c, 0x06cc, 0x074c,
    0x07cc, 0x084c, 0x08cc, 0x094c, 0x09cc, 0x0a4c};
const uint8_t HuffDecoderCommon::table1_43_emit_[92] = {
    0x25, 0x3d, 0x25, 0x41, 0x25, 0x5f, 0x25, 0x62, 0x25, 0x64, 0x25, 0x66,
    0x25, 0x67, 0x25, 0x68, 0x25, 0x6c, 0x25, 0x6d, 0x25, 0x6e, 0x25, 0x70,
    0x25, 0x72, 0x25, 0x75, 0x25, 0x3a, 0x25, 0x42, 0x25, 0x43, 0x25, 0x44,
    0x25, 0x45, 0x25, 0x46, 0x25, 0x47, 0x25, 0x48, 0x25, 0x49, 0x25, 0x4a,
    0x25, 0x4b, 0x25, 0x4c, 0x25, 0x4d, 0x25, 0x4e, 0x25, 0x4f, 0x25, 0x50,
    0x25, 0x51, 0x25, 0x52, 0x25, 0x53, 0x25, 0x54, 0x25, 0x55, 0x25, 0x56,
    0x25, 0x57, 0x25, 0x59, 0x25, 0x6a, 0x25, 0x6b, 0x25, 0x71, 0x25, 0x76,
    0x25, 0x77, 0x25, 0x78, 0x25, 0x79, 0x25, 0x7a};
const uint16_t HuffDecoderCommon::table1_44_inner_[22] = {
    0x000b, 0x008b, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b, 0x038b,
    0x040b, 0x048b, 0x050c, 0x058c, 0x060c, 0x064c, 0x06cc, 0x074c,
    0x07cc, 0x084c, 0x08cc, 0x094c, 0x09cc, 0x0a4c};
const uint8_t HuffDecoderCommon::table1_45_emit_[92] = {
    0x2d, 0x3d, 0x2d, 0x41, 0x2d, 0x5f, 0x2d, 0x62, 0x2d, 0x64, 0x2d, 0x66,
    0x2d, 0x67, 0x2d, 0x68, 0x2d, 0x6c, 0x2d, 0x6d, 0x2d, 0x6e, 0x2d, 0x70,
    0x2d, 0x72, 0x2d, 0x75, 0x2d, 0x3a, 0x2d, 0x42, 0x2d, 0x43, 0x2d, 0x44,
    0x2d, 0x45, 0x2d, 0x46, 0x2d, 0x47, 0x2d, 0x48, 0x2d, 0x49, 0x2d, 0x4a,
    0x2d, 0x4b, 0x2d, 0x4c, 0x2d, 0x4d, 0x2d, 0x4e, 0x2d, 0x4f, 0x2d, 0x50,
    0x2d, 0x51, 0x2d, 0x52, 0x2d, 0x53, 0x2d, 0x54, 0x2d, 0x55, 0x2d, 0x56,
    0x2d, 0x57, 0x2d, 0x59, 0x2d, 0x6a, 0x2d, 0x6b, 0x2d, 0x71, 0x2d, 0x76,
    0x2d, 0x77, 0x2d, 0x78, 0x2d, 0x79, 0x2d, 0x7a};
const uint16_t HuffDecoderCommon::table1_46_inner_[22] = {
    0x000b, 0x008b, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b, 0x038b,
    0x040b, 0x048b, 0x050c, 0x058c, 0x060c, 0x068c, 0x06cc, 0x074c,
    0x07cc, 0x084c, 0x08cc, 0x094c, 0x09cc, 0x0a4c};
const uint8_t HuffDecoderCommon::table1_47_emit_[92] = {
    0x2e, 0x3d, 0x2e, 0x41, 0x2e, 0x5f, 0x2e, 0x62, 0x2e, 0x64, 0x2e, 0x66,
    0x2e, 0x67, 0x2e, 0x68, 0x2e, 0x6c, 0x2e, 0x6d, 0x2e, 0x6e, 0x2e, 0x70,
    0x2e, 0x72, 0x2e, 0x75, 0x2e, 0x3a, 0x2e, 0x42, 0x2e, 0x43, 0x2e, 0x44,
    0x2e, 0x45, 0x2e, 0x46, 0x2e, 0x47, 0x2e, 0x48, 0x2e, 0x49, 0x2e, 0x4a,
    0x2e, 0x4b, 0x2e, 0x4c, 0x2e, 0x4d, 0x2e, 0x4e, 0x2e, 0x4f, 0x2e, 0x50,
    0x2e, 0x51, 0x2e, 0x52, 0x2e, 0x53, 0x2e, 0x54, 0x2e, 0x55, 0x2e, 0x56,
    0x2e, 0x57, 0x2e, 0x59, 0x2e, 0x6a, 0x2e, 0x6b, 0x2e, 0x71, 0x2e, 0x76,
    0x2e, 0x77, 0x2e, 0x78, 0x2e, 0x79, 0x2e, 0x7a};
const uint16_t HuffDecoderCommon::table1_48_inner_[22] = {
    0x000b, 0x008b, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b, 0x038b,
    0x040b, 0x048b, 0x050c, 0x058c, 0x060c, 0x068c, 0x070c, 0x074c,
    0x07cc, 0x084c, 0x08cc, 0x094c, 0x09cc, 0x0a4c};
const uint8_t HuffDecoderCommon::table1_49_emit_[92] = {
    0x2f, 0x3d, 0x2f, 0x41, 0x2f, 0x5f, 0x2f, 0x62, 0x2f, 0x64, 0x2f, 0x66,
    0x2f, 0x67, 0x2f, 0x68, 0x2f, 0x6c, 0x2f, 0x6d, 0x2f, 0x6e, 0x2f, 0x70,
    0x2f, 0x72, 0x2f, 0x75, 0x2f, 0x3a, 0x2f, 0x42, 0x2f, 0x43, 0x2f, 0x44,
    0x2f, 0x45, 0x2f, 0x46, 0x2f, 0x47, 0x2f, 0x48, 0x2f, 0x49, 0x2f, 0x4a,
    0x2f, 0x4b, 0x2f, 0x4c, 0x2f, 0x4d, 0x2f, 0x4e, 0x2f, 0x4f, 0x2f, 0x50,
    0x2f, 0x51, 0x2f, 0x52, 0x2f, 0x53, 0x2f, 0x54, 0x2f, 0x55, 0x2f, 0x56,
    0x2f, 0x57, 0x2f, 0x59, 0x2f, 0x6a, 0x2f, 0x6b, 0x2f, 0x71, 0x2f, 0x76,
    0x2f, 0x77, 0x2f, 0x78, 0x2f, 0x79, 0x2f, 0x7a};
const uint16_t HuffDecoderCommon::table1_50_inner_[22] = {
    0x000b, 0x008b, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b, 0x038b,
    0x040b, 0x048b, 0x050c, 0x058c, 0x060c, 0x068c, 0x070c, 0x078c,
    0x07cc, 0x084c, 0x08cc, 0x094c, 0x09cc, 0x0a4c};
const uint8_t HuffDecoderCommon::table1_51_emit_[92] = {
    0x33, 0x3d, 0x33, 0x41, 0x33, 0x5f, 0x33, 0x62, 0x33, 0x64, 0x33, 0x66,
    0x33, 0x67, 0x33, 0x68, 0x33, 0x6c, 0x33, 0x6d, 0x33, 0x6e, 0x33, 0x70,
    0x33, 0x72, 0x33, 0x75, 0x33, 0x3a, 0x33, 0x42, 0x33, 0x43, 0x33, 0x44,
    0x33, 0x45, 0x33, 0x46, 0x33, 0x47, 0x33, 0x48, 0x33, 0x49, 0x33, 0x4a,
    0x33, 0x4b, 0x33, 0x4c, 0x33, 0x4d, 0x33, 0x4e, 0x33, 0x4f, 0x33, 0x50,
    0x33, 0x51, 0x33, 0x52, 0x33, 0x53, 0x33, 0x54, 0x33, 0x55, 0x33, 0x56,
    0x33, 0x57, 0x33, 0x59, 0x33, 0x6a, 0x33, 0x6b, 0x33, 0x71, 0x33, 0x76,
    0x33, 0x77, 0x33, 0x78, 0x33, 0x79, 0x33, 0x7a};
const uint16_t HuffDecoderCommon::table1_52_inner_[22] = {
    0x000b, 0x008b, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b, 0x038b,
    0x040b, 0x048b, 0x050c, 0x058c, 0x060c, 0x068c, 0x070c, 0x078c,
    0x080c, 0x084c, 0x08cc, 0x094c, 0x09cc, 0x0a4c};
const uint8_t HuffDecoderCommon::table1_53_emit_[92] = {
    0x34, 0x3d, 0x34, 0x41, 0x34, 0x5f, 0x34, 0x62, 0x34, 0x64, 0x34, 0x66,
    0x34, 0x67, 0x34, 0x68, 0x34, 0x6c, 0x34, 0x6d, 0x34, 0x6e, 0x34, 0x70,
    0x34, 0x72, 0x34, 0x75, 0x34, 0x3a, 0x34, 0x42, 0x34, 0x43, 0x34, 0x44,
    0x34, 0x45, 0x34, 0x46, 0x34, 0x47, 0x34, 0x48, 0x34, 0x49, 0x34, 0x4a,
    0x34, 0x4b, 0x34, 0x4c, 0x34, 0x4d, 0x34, 0x4e, 0x34, 0x4f, 0x34, 0x50,
    0x34, 0x51, 0x34, 0x52, 0x34, 0x53, 0x34, 0x54, 0x34, 0x55, 0x34, 0x56,
    0x34, 0x57, 0x34, 0x59, 0x34, 0x6a, 0x34, 0x6b, 0x34, 0x71, 0x34, 0x76,
    0x34, 0x77, 0x34, 0x78, 0x34, 0x79, 0x34, 0x7a};
const uint16_t HuffDecoderCommon::table1_54_inner_[22] = {
    0x000b, 0x008b, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b, 0x038b,
    0x040b, 0x048b, 0x050c, 0x058c, 0x060c, 0x068c, 0x070c, 0x078c,
    0x080c, 0x088c, 0x08cc, 0x094c, 0x09cc, 0x0a4c};
const uint8_t HuffDecoderCommon::table1_55_emit_[92] = {
    0x35, 0x3d, 0x35, 0x41, 0x35, 0x5f, 0x35, 0x62, 0x35, 0x64, 0x35, 0x66,
    0x35, 0x67, 0x35, 0x68, 0x35, 0x6c, 0x35, 0x6d, 0x35, 0x6e, 0x35, 0x70,
    0x35, 0x72, 0x35, 0x75, 0x35, 0x3a, 0x35, 0x42, 0x35, 0x43, 0x35, 0x44,
    0x35, 0x45, 0x35, 0x46, 0x35, 0x47, 0x35, 0x48, 0x35, 0x49, 0x35, 0x4a,
    0x35, 0x4b, 0x35, 0x4c, 0x35, 0x4d, 0x35, 0x4e, 0x35, 0x4f, 0x35, 0x50,
    0x35, 0x51, 0x35, 0x52, 0x35, 0x53, 0x35, 0x54, 0x35, 0x55, 0x35, 0x56,
    0x35, 0x57, 0x35, 0x59, 0x35, 0x6a, 0x35, 0x6b, 0x35, 0x71, 0x35, 0x76,
    0x35, 0x77, 0x35, 0x78, 0x35, 0x79, 0x35, 0x7a};
const uint16_t HuffDecoderCommon::table1_56_inner_[22] = {
    0x000b, 0x008b, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b, 0x038b,
    0x040b, 0x048b, 0x050c, 0x058c, 0x060c, 0x068c, 0x070c, 0x078c,
    0x080c, 0x088c, 0x090c, 0x094c, 0x09cc, 0x0a4c};
const uint8_t HuffDecoderCommon::table1_57_emit_[92] = {
    0x36, 0x3d, 0x36, 0x41, 0x36, 0x5f, 0x36, 0x62, 0x36, 0x64, 0x36, 0x66,
    0x36, 0x67, 0x36, 0x68, 0x36, 0x6c, 0x36, 0x6d, 0x36, 0x6e, 0x36, 0x70,
    0x36, 0x72, 0x36, 0x75, 0x36, 0x3a, 0x36, 0x42, 0x36, 0x43, 0x36, 0x44,
    0x36, 0x45, 0x36, 0x46, 0x36, 0x47, 0x36, 0x48, 0x36, 0x49, 0x36, 0x4a,
    0x36, 0x4b, 0x36, 0x4c, 0x36, 0x4d, 0x36, 0x4e, 0x36, 0x4f, 0x36, 0x50,
    0x36, 0x51, 0x36, 0x52, 0x36, 0x53, 0x36, 0x54, 0x36, 0x55, 0x36, 0x56,
    0x36, 0x57, 0x36, 0x59, 0x36, 0x6a, 0x36, 0x6b, 0x36, 0x71, 0x36, 0x76,
    0x36, 0x77, 0x36, 0x78, 0x36, 0x79, 0x36, 0x7a};
const uint16_t HuffDecoderCommon::table1_58_inner_[22] = {
    0x000b, 0x008b, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b, 0x038b,
    0x040b, 0x048b, 0x050c, 0x058c, 0x060c, 0x068c, 0x070c, 0x078c,
    0x080c, 0x088c, 0x090c, 0x098c, 0x09cc, 0x0a4c};
const uint8_t HuffDecoderCommon::table1_59_emit_[92] = {
    0x37, 0x3d, 0x37, 0x41, 0x37, 0x5f, 0x37, 0x62, 0x37, 0x64, 0x37, 0x66,
    0x37, 0x67, 0x37, 0x68, 0x37, 0x6c, 0x37, 0x6d, 0x37, 0x6e, 0x37, 0x70,
    0x37, 0x72, 0x37, 0x75, 0x37, 0x3a, 0x37, 0x42, 0x37, 0x43, 0x37, 0x44,
    0x37, 0x45, 0x37, 0x46, 0x37, 0x47, 0x37, 0x48, 0x37, 0x49, 0x37, 0x4a,
    0x37, 0x4b, 0x37, 0x4c, 0x37, 0x4d, 0x37, 0x4e, 0x37, 0x4f, 0x37, 0x50,
    0x37, 0x51, 0x37, 0x52, 0x37, 0x53, 0x37, 0x54, 0x37, 0x55, 0x37, 0x56,
    0x37, 0x57, 0x37, 0x59, 0x37, 0x6a, 0x37, 0x6b, 0x37, 0x71, 0x37, 0x76,
    0x37, 0x77, 0x37, 0x78, 0x37, 0x79, 0x37, 0x7a};
const uint16_t HuffDecoderCommon::table1_60_inner_[22] = {
    0x000b, 0x008b, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b, 0x038b,
    0x040b, 0x048b, 0x050c, 0x058c, 0x060c, 0x068c, 0x070c, 0x078c,
    0x080c, 0x088c, 0x090c, 0x098c, 0x0a0c, 0x0a4c};
const uint8_t HuffDecoderCommon::table1_61_emit_[92] = {
    0x38, 0x3d, 0x38, 0x41, 0x38, 0x5f, 0x38, 0x62, 0x38, 0x64, 0x38, 0x66,
    0x38, 0x67, 0x38, 0x68, 0x38, 0x6c, 0x38, 0x6d, 0x38, 0x6e, 0x38, 0x70,
    0x38, 0x72, 0x38, 0x75, 0x38, 0x3a, 0x38, 0x42, 0x38, 0x43, 0x38, 0x44,
    0x38, 0x45, 0x38, 0x46, 0x38, 0x47, 0x38, 0x48, 0x38, 0x49, 0x38, 0x4a,
    0x38, 0x4b, 0x38, 0x4c, 0x38, 0x4d, 0x38, 0x4e, 0x38, 0x4f, 0x38, 0x50,
    0x38, 0x51, 0x38, 0x52, 0x38, 0x53, 0x38, 0x54, 0x38, 0x55, 0x38, 0x56,
    0x38, 0x57, 0x38, 0x59, 0x38, 0x6a, 0x38, 0x6b, 0x38, 0x71, 0x38, 0x76,
    0x38, 0x77, 0x38, 0x78, 0x38, 0x79, 0x38, 0x7a};
const uint16_t HuffDecoderCommon::table1_62_inner_[22] = {
    0x000b, 0x008b, 0x010b, 0x018b, 0x020b, 0x028b, 0x030b, 0x038b,
    0x040b, 0x048b, 0x050c, 0x058c, 0x060c, 0x068c, 0x070c, 0x078c,
    0x080c, 0x088c, 0x090c, 0x098c, 0x0a0c, 0x0a8c};
const uint8_t HuffDecoderCommon::table1_63_emit_[92] = {
    0x39, 0x3d, 0x39, 0x41, 0x39, 0x5f, 0x39, 0x62, 0x39, 0x64, 0x39, 0x66,
    0x39, 0x67, 0x39, 0x68, 0x39, 0x6c, 0x39, 0x6d, 0x39, 0x6e, 0x39, 0x70,
    0x39, 0x72, 0x39, 0x75, 0x39, 0x3a, 0x39, 0x42, 0x39, 0x43, 0x39, 0x44,
    0x39, 0x45, 0x39, 0x46, 0x39, 0x47, 0x39, 0x48, 0x39, 0x49, 0x39, 0x4a,
    0x39, 0x4b, 0x39, 0x4c, 0x39, 0x4d, 0x39, 0x4e, 0x39, 0x4f, 0x39, 0x50,
    0x39, 0x51, 0x39, 0x52, 0x39, 0x53, 0x39, 0x54, 0x39, 0x55, 0x39, 0x56,
    0x39, 0x57, 0x39, 0x59, 0x39, 0x6a, 0x39, 0x6b, 0x39, 0x71, 0x39, 0x76,
    0x39, 0x77, 0x39, 0x78, 0x39, 0x79, 0x39, 0x7a};
const uint8_t HuffDecoderCommon::table1_65_emit_[91] = {
    0x3d, 0x3d, 0x41, 0x3d, 0x5f, 0x3d, 0x62, 0x3d, 0x64, 0x3d, 0x66, 0x3d,
    0x67, 0x3d, 0x68, 0x3d, 0x6c, 0x3d, 0x6d, 0x3d, 0x6e, 0x3d, 0x70, 0x3d,
    0x72, 0x3d, 0x75, 0x3d, 0x3a, 0x3d, 0x42, 0x3d, 0x43, 0x3d, 0x44, 0x3d,
    0x45, 0x3d, 0x46, 0x3d, 0x47, 0x3d, 0x48, 0x3d, 0x49, 0x3d, 0x4a, 0x3d,
    0x4b, 0x3d, 0x4c, 0x3d, 0x4d, 0x3d, 0x4e, 0x3d, 0x4f, 0x3d, 0x50, 0x3d,
    0x51, 0x3d, 0x52, 0x3d, 0x53, 0x3d, 0x54, 0x3d, 0x55, 0x3d, 0x56, 0x3d,
    0x57, 0x3d, 0x59, 0x3d, 0x6a, 0x3d, 0x6b, 0x3d, 0x71, 0x3d, 0x76, 0x3d,
    0x77, 0x3d, 0x78, 0x3d, 0x79, 0x3d, 0x7a};
const uint16_t HuffDecoderCommon::table1_65_inner_[47] = {
    0x000c, 0x004c, 0x00cc, 0x014c, 0x01cc, 0x024c, 0x02cc, 0x034c,
    0x03cc, 0x044c, 0x04cc, 0x054c, 0x05cc, 0x064c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_67_emit_[91] = {
    0x41, 0x3d, 0x41, 0x41, 0x5f, 0x41, 0x62, 0x41, 0x64, 0x41, 0x66, 0x41,
    0x67, 0x41, 0x68, 0x41, 0x6c, 0x41, 0x6d, 0x41, 0x6e, 0x41, 0x70, 0x41,
    0x72, 0x41, 0x75, 0x41, 0x3a, 0x41, 0x42, 0x41, 0x43, 0x41, 0x44, 0x41,
    0x45, 0x41, 0x46, 0x41, 0x47, 0x41, 0x48, 0x41, 0x49, 0x41, 0x4a, 0x41,
    0x4b, 0x41, 0x4c, 0x41, 0x4d, 0x41, 0x4e, 0x41, 0x4f, 0x41, 0x50, 0x41,
    0x51, 0x41, 0x52, 0x41, 0x53, 0x41, 0x54, 0x41, 0x55, 0x41, 0x56, 0x41,
    0x57, 0x41, 0x59, 0x41, 0x6a, 0x41, 0x6b, 0x41, 0x71, 0x41, 0x76, 0x41,
    0x77, 0x41, 0x78, 0x41, 0x79, 0x41, 0x7a};
const uint16_t HuffDecoderCommon::table1_67_inner_[47] = {
    0x000c, 0x008c, 0x00cc, 0x014c, 0x01cc, 0x024c, 0x02cc, 0x034c,
    0x03cc, 0x044c, 0x04cc, 0x054c, 0x05cc, 0x064c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_69_emit_[91] = {
    0x5f, 0x3d, 0x5f, 0x41, 0x5f, 0x5f, 0x62, 0x5f, 0x64, 0x5f, 0x66, 0x5f,
    0x67, 0x5f, 0x68, 0x5f, 0x6c, 0x5f, 0x6d, 0x5f, 0x6e, 0x5f, 0x70, 0x5f,
    0x72, 0x5f, 0x75, 0x5f, 0x3a, 0x5f, 0x42, 0x5f, 0x43, 0x5f, 0x44, 0x5f,
    0x45, 0x5f, 0x46, 0x5f, 0x47, 0x5f, 0x48, 0x5f, 0x49, 0x5f, 0x4a, 0x5f,
    0x4b, 0x5f, 0x4c, 0x5f, 0x4d, 0x5f, 0x4e, 0x5f, 0x4f, 0x5f, 0x50, 0x5f,
    0x51, 0x5f, 0x52, 0x5f, 0x53, 0x5f, 0x54, 0x5f, 0x55, 0x5f, 0x56, 0x5f,
    0x57, 0x5f, 0x59, 0x5f, 0x6a, 0x5f, 0x6b, 0x5f, 0x71, 0x5f, 0x76, 0x5f,
    0x77, 0x5f, 0x78, 0x5f, 0x79, 0x5f, 0x7a};
const uint16_t HuffDecoderCommon::table1_69_inner_[47] = {
    0x000c, 0x008c, 0x010c, 0x014c, 0x01cc, 0x024c, 0x02cc, 0x034c,
    0x03cc, 0x044c, 0x04cc, 0x054c, 0x05cc, 0x064c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_71_emit_[91] = {
    0x62, 0x3d, 0x62, 0x41, 0x62, 0x5f, 0x62, 0x62, 0x64, 0x62, 0x66, 0x62,
    0x67, 0x62, 0x68, 0x62, 0x6c, 0x62, 0x6d, 0x62, 0x6e, 0x62, 0x70, 0x62,
    0x72, 0x62, 0x75, 0x62, 0x3a, 0x62, 0x42, 0x62, 0x43, 0x62, 0x44, 0x62,
    0x45, 0x62, 0x46, 0x62, 0x47, 0x62, 0x48, 0x62, 0x49, 0x62, 0x4a, 0x62,
    0x4b, 0x62, 0x4c, 0x62, 0x4d, 0x62, 0x4e, 0x62, 0x4f, 0x62, 0x50, 0x62,
    0x51, 0x62, 0x52, 0x62, 0x53, 0x62, 0x54, 0x62, 0x55, 0x62, 0x56, 0x62,
    0x57, 0x62, 0x59, 0x62, 0x6a, 0x62, 0x6b, 0x62, 0x71, 0x62, 0x76, 0x62,
    0x77, 0x62, 0x78, 0x62, 0x79, 0x62, 0x7a};
const uint16_t HuffDecoderCommon::table1_71_inner_[47] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x01cc, 0x024c, 0x02cc, 0x034c,
    0x03cc, 0x044c, 0x04cc, 0x054c, 0x05cc, 0x064c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_73_emit_[91] = {
    0x64, 0x3d, 0x64, 0x41, 0x64, 0x5f, 0x64, 0x62, 0x64, 0x64, 0x66, 0x64,
    0x67, 0x64, 0x68, 0x64, 0x6c, 0x64, 0x6d, 0x64, 0x6e, 0x64, 0x70, 0x64,
    0x72, 0x64, 0x75, 0x64, 0x3a, 0x64, 0x42, 0x64, 0x43, 0x64, 0x44, 0x64,
    0x45, 0x64, 0x46, 0x64, 0x47, 0x64, 0x48, 0x64, 0x49, 0x64, 0x4a, 0x64,
    0x4b, 0x64, 0x4c, 0x64, 0x4d, 0x64, 0x4e, 0x64, 0x4f, 0x64, 0x50, 0x64,
    0x51, 0x64, 0x52, 0x64, 0x53, 0x64, 0x54, 0x64, 0x55, 0x64, 0x56, 0x64,
    0x57, 0x64, 0x59, 0x64, 0x6a, 0x64, 0x6b, 0x64, 0x71, 0x64, 0x76, 0x64,
    0x77, 0x64, 0x78, 0x64, 0x79, 0x64, 0x7a};
const uint16_t HuffDecoderCommon::table1_73_inner_[47] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x020c, 0x024c, 0x02cc, 0x034c,
    0x03cc, 0x044c, 0x04cc, 0x054c, 0x05cc, 0x064c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_75_emit_[91] = {
    0x66, 0x3d, 0x66, 0x41, 0x66, 0x5f, 0x66, 0x62, 0x66, 0x64, 0x66, 0x66,
    0x67, 0x66, 0x68, 0x66, 0x6c, 0x66, 0x6d, 0x66, 0x6e, 0x66, 0x70, 0x66,
    0x72, 0x66, 0x75, 0x66, 0x3a, 0x66, 0x42, 0x66, 0x43, 0x66, 0x44, 0x66,
    0x45, 0x66, 0x46, 0x66, 0x47, 0x66, 0x48, 0x66, 0x49, 0x66, 0x4a, 0x66,
    0x4b, 0x66, 0x4c, 0x66, 0x4d, 0x66, 0x4e, 0x66, 0x4f, 0x66, 0x50, 0x66,
    0x51, 0x66, 0x52, 0x66, 0x53, 0x66, 0x54, 0x66, 0x55, 0x66, 0x56, 0x66,
    0x57, 0x66, 0x59, 0x66, 0x6a, 0x66, 0x6b, 0x66, 0x71, 0x66, 0x76, 0x66,
    0x77, 0x66, 0x78, 0x66, 0x79, 0x66, 0x7a};
const uint16_t HuffDecoderCommon::table1_75_inner_[47] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x020c, 0x028c, 0x02cc, 0x034c,
    0x03cc, 0x044c, 0x04cc, 0x054c, 0x05cc, 0x064c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_77_emit_[91] = {
    0x67, 0x3d, 0x67, 0x41, 0x67, 0x5f, 0x67, 0x62, 0x67, 0x64, 0x67, 0x66,
    0x67, 0x67, 0x68, 0x67, 0x6c, 0x67, 0x6d, 0x67, 0x6e, 0x67, 0x70, 0x67,
    0x72, 0x67, 0x75, 0x67, 0x3a, 0x67, 0x42, 0x67, 0x43, 0x67, 0x44, 0x67,
    0x45, 0x67, 0x46, 0x67, 0x47, 0x67, 0x48, 0x67, 0x49, 0x67, 0x4a, 0x67,
    0x4b, 0x67, 0x4c, 0x67, 0x4d, 0x67, 0x4e, 0x67, 0x4f, 0x67, 0x50, 0x67,
    0x51, 0x67, 0x52, 0x67, 0x53, 0x67, 0x54, 0x67, 0x55, 0x67, 0x56, 0x67,
    0x57, 0x67, 0x59, 0x67, 0x6a, 0x67, 0x6b, 0x67, 0x71, 0x67, 0x76, 0x67,
    0x77, 0x67, 0x78, 0x67, 0x79, 0x67, 0x7a};
const uint16_t HuffDecoderCommon::table1_77_inner_[47] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x020c, 0x028c, 0x030c, 0x034c,
    0x03cc, 0x044c, 0x04cc, 0x054c, 0x05cc, 0x064c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_79_emit_[91] = {
    0x68, 0x3d, 0x68, 0x41, 0x68, 0x5f, 0x68, 0x62, 0x68, 0x64, 0x68, 0x66,
    0x68, 0x67, 0x68, 0x68, 0x6c, 0x68, 0x6d, 0x68, 0x6e, 0x68, 0x70, 0x68,
    0x72, 0x68, 0x75, 0x68, 0x3a, 0x68, 0x42, 0x68, 0x43, 0x68, 0x44, 0x68,
    0x45, 0x68, 0x46, 0x68, 0x47, 0x68, 0x48, 0x68, 0x49, 0x68, 0x4a, 0x68,
    0x4b, 0x68, 0x4c, 0x68, 0x4d, 0x68, 0x4e, 0x68, 0x4f, 0x68, 0x50, 0x68,
    0x51, 0x68, 0x52, 0x68, 0x53, 0x68, 0x54, 0x68, 0x55, 0x68, 0x56, 0x68,
    0x57, 0x68, 0x59, 0x68, 0x6a, 0x68, 0x6b, 0x68, 0x71, 0x68, 0x76, 0x68,
    0x77, 0x68, 0x78, 0x68, 0x79, 0x68, 0x7a};
const uint16_t HuffDecoderCommon::table1_79_inner_[47] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x020c, 0x028c, 0x030c, 0x038c,
    0x03cc, 0x044c, 0x04cc, 0x054c, 0x05cc, 0x064c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_81_emit_[91] = {
    0x6c, 0x3d, 0x6c, 0x41, 0x6c, 0x5f, 0x6c, 0x62, 0x6c, 0x64, 0x6c, 0x66,
    0x6c, 0x67, 0x6c, 0x68, 0x6c, 0x6c, 0x6d, 0x6c, 0x6e, 0x6c, 0x70, 0x6c,
    0x72, 0x6c, 0x75, 0x6c, 0x3a, 0x6c, 0x42, 0x6c, 0x43, 0x6c, 0x44, 0x6c,
    0x45, 0x6c, 0x46, 0x6c, 0x47, 0x6c, 0x48, 0x6c, 0x49, 0x6c, 0x4a, 0x6c,
    0x4b, 0x6c, 0x4c, 0x6c, 0x4d, 0x6c, 0x4e, 0x6c, 0x4f, 0x6c, 0x50, 0x6c,
    0x51, 0x6c, 0x52, 0x6c, 0x53, 0x6c, 0x54, 0x6c, 0x55, 0x6c, 0x56, 0x6c,
    0x57, 0x6c, 0x59, 0x6c, 0x6a, 0x6c, 0x6b, 0x6c, 0x71, 0x6c, 0x76, 0x6c,
    0x77, 0x6c, 0x78, 0x6c, 0x79, 0x6c, 0x7a};
const uint16_t HuffDecoderCommon::table1_81_inner_[47] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x020c, 0x028c, 0x030c, 0x038c,
    0x040c, 0x044c, 0x04cc, 0x054c, 0x05cc, 0x064c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_83_emit_[91] = {
    0x6d, 0x3d, 0x6d, 0x41, 0x6d, 0x5f, 0x6d, 0x62, 0x6d, 0x64, 0x6d, 0x66,
    0x6d, 0x67, 0x6d, 0x68, 0x6d, 0x6c, 0x6d, 0x6d, 0x6e, 0x6d, 0x70, 0x6d,
    0x72, 0x6d, 0x75, 0x6d, 0x3a, 0x6d, 0x42, 0x6d, 0x43, 0x6d, 0x44, 0x6d,
    0x45, 0x6d, 0x46, 0x6d, 0x47, 0x6d, 0x48, 0x6d, 0x49, 0x6d, 0x4a, 0x6d,
    0x4b, 0x6d, 0x4c, 0x6d, 0x4d, 0x6d, 0x4e, 0x6d, 0x4f, 0x6d, 0x50, 0x6d,
    0x51, 0x6d, 0x52, 0x6d, 0x53, 0x6d, 0x54, 0x6d, 0x55, 0x6d, 0x56, 0x6d,
    0x57, 0x6d, 0x59, 0x6d, 0x6a, 0x6d, 0x6b, 0x6d, 0x71, 0x6d, 0x76, 0x6d,
    0x77, 0x6d, 0x78, 0x6d, 0x79, 0x6d, 0x7a};
const uint16_t HuffDecoderCommon::table1_83_inner_[47] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x020c, 0x028c, 0x030c, 0x038c,
    0x040c, 0x048c, 0x04cc, 0x054c, 0x05cc, 0x064c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_85_emit_[91] = {
    0x6e, 0x3d, 0x6e, 0x41, 0x6e, 0x5f, 0x6e, 0x62, 0x6e, 0x64, 0x6e, 0x66,
    0x6e, 0x67, 0x6e, 0x68, 0x6e, 0x6c, 0x6e, 0x6d, 0x6e, 0x6e, 0x70, 0x6e,
    0x72, 0x6e, 0x75, 0x6e, 0x3a, 0x6e, 0x42, 0x6e, 0x43, 0x6e, 0x44, 0x6e,
    0x45, 0x6e, 0x46, 0x6e, 0x47, 0x6e, 0x48, 0x6e, 0x49, 0x6e, 0x4a, 0x6e,
    0x4b, 0x6e, 0x4c, 0x6e, 0x4d, 0x6e, 0x4e, 0x6e, 0x4f, 0x6e, 0x50, 0x6e,
    0x51, 0x6e, 0x52, 0x6e, 0x53, 0x6e, 0x54, 0x6e, 0x55, 0x6e, 0x56, 0x6e,
    0x57, 0x6e, 0x59, 0x6e, 0x6a, 0x6e, 0x6b, 0x6e, 0x71, 0x6e, 0x76, 0x6e,
    0x77, 0x6e, 0x78, 0x6e, 0x79, 0x6e, 0x7a};
const uint16_t HuffDecoderCommon::table1_85_inner_[47] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x020c, 0x028c, 0x030c, 0x038c,
    0x040c, 0x048c, 0x050c, 0x054c, 0x05cc, 0x064c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_87_emit_[91] = {
    0x70, 0x3d, 0x70, 0x41, 0x70, 0x5f, 0x70, 0x62, 0x70, 0x64, 0x70, 0x66,
    0x70, 0x67, 0x70, 0x68, 0x70, 0x6c, 0x70, 0x6d, 0x70, 0x6e, 0x70, 0x70,
    0x72, 0x70, 0x75, 0x70, 0x3a, 0x70, 0x42, 0x70, 0x43, 0x70, 0x44, 0x70,
    0x45, 0x70, 0x46, 0x70, 0x47, 0x70, 0x48, 0x70, 0x49, 0x70, 0x4a, 0x70,
    0x4b, 0x70, 0x4c, 0x70, 0x4d, 0x70, 0x4e, 0x70, 0x4f, 0x70, 0x50, 0x70,
    0x51, 0x70, 0x52, 0x70, 0x53, 0x70, 0x54, 0x70, 0x55, 0x70, 0x56, 0x70,
    0x57, 0x70, 0x59, 0x70, 0x6a, 0x70, 0x6b, 0x70, 0x71, 0x70, 0x76, 0x70,
    0x77, 0x70, 0x78, 0x70, 0x79, 0x70, 0x7a};
const uint16_t HuffDecoderCommon::table1_87_inner_[47] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x020c, 0x028c, 0x030c, 0x038c,
    0x040c, 0x048c, 0x050c, 0x058c, 0x05cc, 0x064c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_89_emit_[91] = {
    0x72, 0x3d, 0x72, 0x41, 0x72, 0x5f, 0x72, 0x62, 0x72, 0x64, 0x72, 0x66,
    0x72, 0x67, 0x72, 0x68, 0x72, 0x6c, 0x72, 0x6d, 0x72, 0x6e, 0x72, 0x70,
    0x72, 0x72, 0x75, 0x72, 0x3a, 0x72, 0x42, 0x72, 0x43, 0x72, 0x44, 0x72,
    0x45, 0x72, 0x46, 0x72, 0x47, 0x72, 0x48, 0x72, 0x49, 0x72, 0x4a, 0x72,
    0x4b, 0x72, 0x4c, 0x72, 0x4d, 0x72, 0x4e, 0x72, 0x4f, 0x72, 0x50, 0x72,
    0x51, 0x72, 0x52, 0x72, 0x53, 0x72, 0x54, 0x72, 0x55, 0x72, 0x56, 0x72,
    0x57, 0x72, 0x59, 0x72, 0x6a, 0x72, 0x6b, 0x72, 0x71, 0x72, 0x76, 0x72,
    0x77, 0x72, 0x78, 0x72, 0x79, 0x72, 0x7a};
const uint16_t HuffDecoderCommon::table1_89_inner_[47] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x020c, 0x028c, 0x030c, 0x038c,
    0x040c, 0x048c, 0x050c, 0x058c, 0x060c, 0x064c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_91_emit_[91] = {
    0x75, 0x3d, 0x75, 0x41, 0x75, 0x5f, 0x75, 0x62, 0x75, 0x64, 0x75, 0x66,
    0x75, 0x67, 0x75, 0x68, 0x75, 0x6c, 0x75, 0x6d, 0x75, 0x6e, 0x75, 0x70,
    0x75, 0x72, 0x75, 0x75, 0x3a, 0x75, 0x42, 0x75, 0x43, 0x75, 0x44, 0x75,
    0x45, 0x75, 0x46, 0x75, 0x47, 0x75, 0x48, 0x75, 0x49, 0x75, 0x4a, 0x75,
    0x4b, 0x75, 0x4c, 0x75, 0x4d, 0x75, 0x4e, 0x75, 0x4f, 0x75, 0x50, 0x75,
    0x51, 0x75, 0x52, 0x75, 0x53, 0x75, 0x54, 0x75, 0x55, 0x75, 0x56, 0x75,
    0x57, 0x75, 0x59, 0x75, 0x6a, 0x75, 0x6b, 0x75, 0x71, 0x75, 0x76, 0x75,
    0x77, 0x75, 0x78, 0x75, 0x79, 0x75, 0x7a};
const uint16_t HuffDecoderCommon::table1_91_inner_[47] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x020c, 0x028c, 0x030c, 0x038c,
    0x040c, 0x048c, 0x050c, 0x058c, 0x060c, 0x068c, 0x06cd, 0x074d,
    0x07cd, 0x084d, 0x08cd, 0x094d, 0x09cd, 0x0a4d, 0x0acd, 0x0b4d,
    0x0bcd, 0x0c4d, 0x0ccd, 0x0d4d, 0x0dcd, 0x0e4d, 0x0ecd, 0x0f4d,
    0x0fcd, 0x104d, 0x10cd, 0x114d, 0x11cd, 0x124d, 0x12cd, 0x134d,
    0x13cd, 0x144d, 0x14cd, 0x154d, 0x15cd, 0x164d, 0x0016};
const uint8_t HuffDecoderCommon::table1_92_emit_[72] = {
    0x3a, 0x30, 0x3a, 0x31, 0x3a, 0x32, 0x3a, 0x61, 0x3a, 0x63, 0x3a, 0x65,
    0x3a, 0x69, 0x3a, 0x6f, 0x3a, 0x73, 0x3a, 0x74, 0x3a, 0x20, 0x3a, 0x25,
    0x3a, 0x2d, 0x3a, 0x2e, 0x3a, 0x2f, 0x3a, 0x33, 0x3a, 0x34, 0x3a, 0x35,
    0x3a, 0x36, 0x3a, 0x37, 0x3a, 0x38, 0x3a, 0x39, 0x3a, 0x3d, 0x3a, 0x41,
    0x3a, 0x5f, 0x3a, 0x62, 0x3a, 0x64, 0x3a, 0x66, 0x3a, 0x67, 0x3a, 0x68,
    0x3a, 0x6c, 0x3a, 0x6d, 0x3a, 0x6e, 0x3a, 0x70, 0x3a, 0x72, 0x3a, 0x75};
const uint16_t HuffDecoderCommon::table1_92_inner_[37] = {
    0x000c, 0x008c, 0x010c, 0x018c, 0x020c, 0x028c, 0x030c, 0x038c,
    0x040c, 0x048c, 0x050d, 0x058d, 0x060d, 0x068d, 0x070d, 0x078d,
    0x080d, 0x088d, 0x090d, 0x098d, 0x0a0d, 0x0a8d, 0x0b0d, 0x0b8d,
    0x0c0d, 0x0c8d, 0x0d0d, 0x0d8d, 0x0e0d, 0x0e8d, 0x0f0d, 0x0f8d,
    0x100d, 0x108d, 0x110d, 0x118d, 0x0017};
const uint8_t HuffDecoderCommon::table1_92_outer_[64] = {
    0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
    8,  8,  9,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
    22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36};
const uint8_t HuffDecoderCommon::table1_93_emit_[72] = {
    0x42, 0x30, 0x42, 0x31, 0x42, 0x32, 0x42, 0x61, 0x42, 0x63, 0x42, 0x65,
    0x42, 0x69, 0x42, 0x6f, 0x42, 0x73, 0x42, 0x74, 0x42, 0x20, 0x42, 0x25,
    0x42, 0x2d, 0x42, 0x2e, 0x42, 0x2f, 0x42, 0x33, 0x42, 0x34, 0x42, 0x35,
    0x42, 0x36, 0x42, 0x37, 0x42, 0x38, 0x42, 0x39, 0x42, 0x3d, 0x42, 0x41,
    0x42, 0x5f, 0x42, 0x62, 0x42, 0x64, 0x42, 0x66, 0x42, 0x67, 0x42, 0x68,
    0x42, 0x6c, 0x42, 0x6d, 0x42, 0x6e, 0x42, 0x70, 0x42, 0x72, 0x42, 0x75};
const uint8_t HuffDecoderCommon::table1_94_emit_[72] = {
    0x43, 0x30, 0x43, 0x31, 0x43, 0x32, 0x43, 0x61, 0x43, 0x63, 0x43, 0x65,
    0x43, 0x69, 0x43, 0x6f, 0x43, 0x73, 0x43, 0x74, 0x43, 0x20, 0x43, 0x25,
    0x43, 0x2d, 0x43, 0x2e, 0x43, 0x2f, 0x43, 0x33, 0x43, 0x34, 0x43, 0x35,
    0x43, 0x36, 0x43, 0x37, 0x43, 0x38, 0x43, 0x39, 0x43, 0x3d, 0x43, 0x41,
    0x43, 0x5f, 0x43, 0x62, 0x43, 0x64, 0x43, 0x66, 0x43, 0x67, 0x43, 0x68,
    0x43, 0x6c, 0x43, 0x6d, 0x43, 0x6e, 0x43, 0x70, 0x43, 0x72, 0x43, 0x75};
const uint8_t HuffDecoderCommon::table1_95_emit_[72] = {
    0x44, 0x30, 0x44, 0x31, 0x44, 0x32, 0x44, 0x61, 0x44, 0x63, 0x44, 0x65,
    0x44, 0x69, 0x44, 0x6f, 0x44, 0x73, 0x44, 0x74, 0x44, 0x20, 0x44, 0x25,
    0x44, 0x2d, 0x44, 0x2e, 0x44, 0x2f, 0x44, 0x33, 0x44, 0x34, 0x44, 0x35,
    0x44, 0x36, 0x44, 0x37, 0x44, 0x38, 0x44, 0x39, 0x44, 0x3d, 0x44, 0x41,
    0x44, 0x5f, 0x44, 0x62, 0x44, 0x64, 0x44, 0x66, 0x44, 0x67, 0x44, 0x68,
    0x44, 0x6c, 0x44, 0x6d, 0x44, 0x6e, 0x44, 0x70, 0x44, 0x72, 0x44, 0x75};
const uint8_t HuffDecoderCommon::table1_96_emit_[72] = {
    0x45, 0x30, 0x45, 0x31, 0x45, 0x32, 0x45, 0x61, 0x45, 0x63, 0x45, 0x65,
    0x45, 0x69, 0x45, 0x6f, 0x45, 0x73, 0x45, 0x74, 0x45, 0x20, 0x45, 0x25,
    0x45, 0x2d, 0x45, 0x2e, 0x45, 0x2f, 0x45, 0x33, 0x45, 0x34, 0x45, 0x35,
    0x45, 0x36, 0x45, 0x37, 0x45, 0x38, 0x45, 0x39, 0x45, 0x3d, 0x45, 0x41,
    0x45, 0x5f, 0x45, 0x62, 0x45, 0x64, 0x45, 0x66, 0x45, 0x67, 0x45, 0x68,
    0x45, 0x6c, 0x45, 0x6d, 0x45, 0x6e, 0x45, 0x70, 0x45, 0x72, 0x45, 0x75};
const uint8_t HuffDecoderCommon::table1_97_emit_[72] = {
    0x46, 0x30, 0x46, 0x31, 0x46, 0x32, 0x46, 0x61, 0x46, 0x63, 0x46, 0x65,
    0x46, 0x69, 0x46, 0x6f, 0x46, 0x73, 0x46, 0x74, 0x46, 0x20, 0x46, 0x25,
    0x46, 0x2d, 0x46, 0x2e, 0x46, 0x2f, 0x46, 0x33, 0x46, 0x34, 0x46, 0x35,
    0x46, 0x36, 0x46, 0x37, 0x46, 0x38, 0x46, 0x39, 0x46, 0x3d, 0x46, 0x41,
    0x46, 0x5f, 0x46, 0x62, 0x46, 0x64, 0x46, 0x66, 0x46, 0x67, 0x46, 0x68,
    0x46, 0x6c, 0x46, 0x6d, 0x46, 0x6e, 0x46, 0x70, 0x46, 0x72, 0x46, 0x75};
const uint8_t HuffDecoderCommon::table1_98_emit_[72] = {
    0x47, 0x30, 0x47, 0x31, 0x47, 0x32, 0x47, 0x61, 0x47, 0x63, 0x47, 0x65,
    0x47, 0x69, 0x47, 0x6f, 0x47, 0x73, 0x47, 0x74, 0x47, 0x20, 0x47, 0x25,
    0x47, 0x2d, 0x47, 0x2e, 0x47, 0x2f, 0x47, 0x33, 0x47, 0x34, 0x47, 0x35,
    0x47, 0x36, 0x47, 0x37, 0x47, 0x38, 0x47, 0x39, 0x47, 0x3d, 0x47, 0x41,
    0x47, 0x5f, 0x47, 0x62, 0x47, 0x64, 0x47, 0x66, 0x47, 0x67, 0x47, 0x68,
    0x47, 0x6c, 0x47, 0x6d, 0x47, 0x6e, 0x47, 0x70, 0x47, 0x72, 0x47, 0x75};
const uint8_t HuffDecoderCommon::table1_99_emit_[72] = {
    0x48, 0x30, 0x48, 0x31, 0x48, 0x32, 0x48, 0x61, 0x48, 0x63, 0x48, 0x65,
    0x48, 0x69, 0x48, 0x6f, 0x48, 0x73, 0x48, 0x74, 0x48, 0x20, 0x48, 0x25,
    0x48, 0x2d, 0x48, 0x2e, 0x48, 0x2f, 0x48, 0x33, 0x48, 0x34, 0x48, 0x35,
    0x48, 0x36, 0x48, 0x37, 0x48, 0x38, 0x48, 0x39, 0x48, 0x3d, 0x48, 0x41,
    0x48, 0x5f, 0x48, 0x62, 0x48, 0x64, 0x48, 0x66, 0x48, 0x67, 0x48, 0x68,
    0x48, 0x6c, 0x48, 0x6d, 0x48, 0x6e, 0x48, 0x70, 0x48, 0x72, 0x48, 0x75};
const uint8_t HuffDecoderCommon::table1_100_emit_[72] = {
    0x49, 0x30, 0x49, 0x31, 0x49, 0x32, 0x49, 0x61, 0x49, 0x63, 0x49, 0x65,
    0x49, 0x69, 0x49, 0x6f, 0x49, 0x73, 0x49, 0x74, 0x49, 0x20, 0x49, 0x25,
    0x49, 0x2d, 0x49, 0x2e, 0x49, 0x2f, 0x49, 0x33, 0x49, 0x34, 0x49, 0x35,
    0x49, 0x36, 0x49, 0x37, 0x49, 0x38, 0x49, 0x39, 0x49, 0x3d, 0x49, 0x41,
    0x49, 0x5f, 0x49, 0x62, 0x49, 0x64, 0x49, 0x66, 0x49, 0x67, 0x49, 0x68,
    0x49, 0x6c, 0x49, 0x6d, 0x49, 0x6e, 0x49, 0x70, 0x49, 0x72, 0x49, 0x75};
const uint8_t HuffDecoderCommon::table1_101_emit_[72] = {
    0x4a, 0x30, 0x4a, 0x31, 0x4a, 0x32, 0x4a, 0x61, 0x4a, 0x63, 0x4a, 0x65,
    0x4a, 0x69, 0x4a, 0x6f, 0x4a, 0x73, 0x4a, 0x74, 0x4a, 0x20, 0x4a, 0x25,
    0x4a, 0x2d, 0x4a, 0x2e, 0x4a, 0x2f, 0x4a, 0x33, 0x4a, 0x34, 0x4a, 0x35,
    0x4a, 0x36, 0x4a, 0x37, 0x4a, 0x38, 0x4a, 0x39, 0x4a, 0x3d, 0x4a, 0x41,
    0x4a, 0x5f, 0x4a, 0x62, 0x4a, 0x64, 0x4a, 0x66, 0x4a, 0x67, 0x4a, 0x68,
    0x4a, 0x6c, 0x4a, 0x6d, 0x4a, 0x6e, 0x4a, 0x70, 0x4a, 0x72, 0x4a, 0x75};
const uint8_t HuffDecoderCommon::table1_102_emit_[72] = {
    0x4b, 0x30, 0x4b, 0x31, 0x4b, 0x32, 0x4b, 0x61, 0x4b, 0x63, 0x4b, 0x65,
    0x4b, 0x69, 0x4b, 0x6f, 0x4b, 0x73, 0x4b, 0x74, 0x4b, 0x20, 0x4b, 0x25,
    0x4b, 0x2d, 0x4b, 0x2e, 0x4b, 0x2f, 0x4b, 0x33, 0x4b, 0x34, 0x4b, 0x35,
    0x4b, 0x36, 0x4b, 0x37, 0x4b, 0x38, 0x4b, 0x39, 0x4b, 0x3d, 0x4b, 0x41,
    0x4b, 0x5f, 0x4b, 0x62, 0x4b, 0x64, 0x4b, 0x66, 0x4b, 0x67, 0x4b, 0x68,
    0x4b, 0x6c, 0x4b, 0x6d, 0x4b, 0x6e, 0x4b, 0x70, 0x4b, 0x72, 0x4b, 0x75};
const uint8_t HuffDecoderCommon::table1_103_emit_[72] = {
    0x4c, 0x30, 0x4c, 0x31, 0x4c, 0x32, 0x4c, 0x61, 0x4c, 0x63, 0x4c, 0x65,
    0x4c, 0x69, 0x4c, 0x6f, 0x4c, 0x73, 0x4c, 0x74, 0x4c, 0x20, 0x4c, 0x25,
    0x4c, 0x2d, 0x4c, 0x2e, 0x4c, 0x2f, 0x4c, 0x33, 0x4c, 0x34, 0x4c, 0x35,
    0x4c, 0x36, 0x4c, 0x37, 0x4c, 0x38, 0x4c, 0x39, 0x4c, 0x3d, 0x4c, 0x41,
    0x4c, 0x5f, 0x4c, 0x62, 0x4c, 0x64, 0x4c, 0x66, 0x4c, 0x67, 0x4c, 0x68,
    0x4c, 0x6c, 0x4c, 0x6d, 0x4c, 0x6e, 0x4c, 0x70, 0x4c, 0x72, 0x4c, 0x75};
const uint8_t HuffDecoderCommon::table1_104_emit_[72] = {
    0x4d, 0x30, 0x4d, 0x31, 0x4d, 0x32, 0x4d, 0x61, 0x4d, 0x63, 0x4d, 0x65,
    0x4d, 0x69, 0x4d, 0x6f, 0x4d, 0x73, 0x4d, 0x74, 0x4d, 0x20, 0x4d, 0x25,
    0x4d, 0x2d, 0x4d, 0x2e, 0x4d, 0x2f, 0x4d, 0x33, 0x4d, 0x34, 0x4d, 0x35,
    0x4d, 0x36, 0x4d, 0x37, 0x4d, 0x38, 0x4d, 0x39, 0x4d, 0x3d, 0x4d, 0x41,
    0x4d, 0x5f, 0x4d, 0x62, 0x4d, 0x64, 0x4d, 0x66, 0x4d, 0x67, 0x4d, 0x68,
    0x4d, 0x6c, 0x4d, 0x6d, 0x4d, 0x6e, 0x4d, 0x70, 0x4d, 0x72, 0x4d, 0x75};
const uint8_t HuffDecoderCommon::table1_105_emit_[72] = {
    0x4e, 0x30, 0x4e, 0x31, 0x4e, 0x32, 0x4e, 0x61, 0x4e, 0x63, 0x4e, 0x65,
    0x4e, 0x69, 0x4e, 0x6f, 0x4e, 0x73, 0x4e, 0x74, 0x4e, 0x20, 0x4e, 0x25,
    0x4e, 0x2d, 0x4e, 0x2e, 0x4e, 0x2f, 0x4e, 0x33, 0x4e, 0x34, 0x4e, 0x35,
    0x4e, 0x36, 0x4e, 0x37, 0x4e, 0x38, 0x4e, 0x39, 0x4e, 0x3d, 0x4e, 0x41,
    0x4e, 0x5f, 0x4e, 0x62, 0x4e, 0x64, 0x4e, 0x66, 0x4e, 0x67, 0x4e, 0x68,
    0x4e, 0x6c, 0x4e, 0x6d, 0x4e, 0x6e, 0x4e, 0x70, 0x4e, 0x72, 0x4e, 0x75};
const uint8_t HuffDecoderCommon::table1_106_emit_[72] = {
    0x4f, 0x30, 0x4f, 0x31, 0x4f, 0x32, 0x4f, 0x61, 0x4f, 0x63, 0x4f, 0x65,
    0x4f, 0x69, 0x4f, 0x6f, 0x4f, 0x73, 0x4f, 0x74, 0x4f, 0x20, 0x4f, 0x25,
    0x4f, 0x2d, 0x4f, 0x2e, 0x4f, 0x2f, 0x4f, 0x33, 0x4f, 0x34, 0x4f, 0x35,
    0x4f, 0x36, 0x4f, 0x37, 0x4f, 0x38, 0x4f, 0x39, 0x4f, 0x3d, 0x4f, 0x41,
    0x4f, 0x5f, 0x4f, 0x62, 0x4f, 0x64, 0x4f, 0x66, 0x4f, 0x67, 0x4f, 0x68,
    0x4f, 0x6c, 0x4f, 0x6d, 0x4f, 0x6e, 0x4f, 0x70, 0x4f, 0x72, 0x4f, 0x75};
const uint8_t HuffDecoderCommon::table1_107_emit_[72] = {
    0x50, 0x30, 0x50, 0x31, 0x50, 0x32, 0x50, 0x61, 0x50, 0x63, 0x50, 0x65,
    0x50, 0x69, 0x50, 0x6f, 0x50, 0x73, 0x50, 0x74, 0x50, 0x20, 0x50, 0x25,
    0x50, 0x2d, 0x50, 0x2e, 0x50, 0x2f, 0x50, 0x33, 0x50, 0x34, 0x50, 0x35,
    0x50, 0x36, 0x50, 0x37, 0x50, 0x38, 0x50, 0x39, 0x50, 0x3d, 0x50, 0x41,
    0x50, 0x5f, 0x50, 0x62, 0x50, 0x64, 0x50, 0x66, 0x50, 0x67, 0x50, 0x68,
    0x50, 0x6c, 0x50, 0x6d, 0x50, 0x6e, 0x50, 0x70, 0x50, 0x72, 0x50, 0x75};
const uint8_t HuffDecoderCommon::table1_108_emit_[72] = {
    0x51, 0x30, 0x51, 0x31, 0x51, 0x32, 0x51, 0x61, 0x51, 0x63, 0x51, 0x65,
    0x51, 0x69, 0x51, 0x6f, 0x51, 0x73, 0x51, 0x74, 0x51, 0x20, 0x51, 0x25,
    0x51, 0x2d, 0x51, 0x2e, 0x51, 0x2f, 0x51, 0x33, 0x51, 0x34, 0x51, 0x35,
    0x51, 0x36, 0x51, 0x37, 0x51, 0x38, 0x51, 0x39, 0x51, 0x3d, 0x51, 0x41,
    0x51, 0x5f, 0x51, 0x62, 0x51, 0x64, 0x51, 0x66, 0x51, 0x67, 0x51, 0x68,
    0x51, 0x6c, 0x51, 0x6d, 0x51, 0x6e, 0x51, 0x70, 0x51, 0x72, 0x51, 0x75};
const uint8_t HuffDecoderCommon::table1_109_emit_[72] = {
    0x52, 0x30, 0x52, 0x31, 0x52, 0x32, 0x52, 0x61, 0x52, 0x63, 0x52, 0x65,
    0x52, 0x69, 0x52, 0x6f, 0x52, 0x73, 0x52, 0x74, 0x52, 0x20, 0x52, 0x25,
    0x52, 0x2d, 0x52, 0x2e, 0x52, 0x2f, 0x52, 0x33, 0x52, 0x34, 0x52, 0x35,
    0x52, 0x36, 0x52, 0x37, 0x52, 0x38, 0x52, 0x39, 0x52, 0x3d, 0x52, 0x41,
    0x52, 0x5f, 0x52, 0x62, 0x52, 0x64, 0x52, 0x66, 0x52, 0x67, 0x52, 0x68,
    0x52, 0x6c, 0x52, 0x6d, 0x52, 0x6e, 0x52, 0x70, 0x52, 0x72, 0x52, 0x75};
const uint8_t HuffDecoderCommon::table1_110_emit_[72] = {
    0x53, 0x30, 0x53, 0x31, 0x53, 0x32, 0x53, 0x61, 0x53, 0x63, 0x53, 0x65,
    0x53, 0x69, 0x53, 0x6f, 0x53, 0x73, 0x53, 0x74, 0x53, 0x20, 0x53, 0x25,
    0x53, 0x2d, 0x53, 0x2e, 0x53, 0x2f, 0x53, 0x33, 0x53, 0x34, 0x53, 0x35,
    0x53, 0x36, 0x53, 0x37, 0x53, 0x38, 0x53, 0x39, 0x53, 0x3d, 0x53, 0x41,
    0x53, 0x5f, 0x53, 0x62, 0x53, 0x64, 0x53, 0x66, 0x53, 0x67, 0x53, 0x68,
    0x53, 0x6c, 0x53, 0x6d, 0x53, 0x6e, 0x53, 0x70, 0x53, 0x72, 0x53, 0x75};
const uint8_t HuffDecoderCommon::table1_111_emit_[72] = {
    0x54, 0x30, 0x54, 0x31, 0x54, 0x32, 0x54, 0x61, 0x54, 0x63, 0x54, 0x65,
    0x54, 0x69, 0x54, 0x6f, 0x54, 0x73, 0x54, 0x74, 0x54, 0x20, 0x54, 0x25,
    0x54, 0x2d, 0x54, 0x2e, 0x54, 0x2f, 0x54, 0x33, 0x54, 0x34, 0x54, 0x35,
    0x54, 0x36, 0x54, 0x37, 0x54, 0x38, 0x54, 0x39, 0x54, 0x3d, 0x54, 0x41,
    0x54, 0x5f, 0x54, 0x62, 0x54, 0x64, 0x54, 0x66, 0x54, 0x67, 0x54, 0x68,
    0x54, 0x6c, 0x54, 0x6d, 0x54, 0x6e, 0x54, 0x70, 0x54, 0x72, 0x54, 0x75};
const uint8_t HuffDecoderCommon::table1_112_emit_[72] = {
    0x55, 0x30, 0x55, 0x31, 0x55, 0x32, 0x55, 0x61, 0x55, 0x63, 0x55, 0x65,
    0x55, 0x69, 0x55, 0x6f, 0x55, 0x73, 0x55, 0x74, 0x55, 0x20, 0x55, 0x25,
    0x55, 0x2d, 0x55, 0x2e, 0x55, 0x2f, 0x55, 0x33, 0x55, 0x34, 0x55, 0x35,
    0x55, 0x36, 0x55, 0x37, 0x55, 0x38, 0x55, 0x39, 0x55, 0x3d, 0x55, 0x41,
    0x55, 0x5f, 0x55, 0x62, 0x55, 0x64, 0x55, 0x66, 0x55, 0x67, 0x55, 0x68,
    0x55, 0x6c, 0x55, 0x6d, 0x55, 0x6e, 0x55, 0x70, 0x55, 0x72, 0x55, 0x75};
const uint8_t HuffDecoderCommon::table1_113_emit_[72] = {
    0x56, 0x30, 0x56, 0x31, 0x56, 0x32, 0x56, 0x61, 0x56, 0x63, 0x56, 0x65,
    0x56, 0x69, 0x56, 0x6f, 0x56, 0x73, 0x56, 0x74, 0x56, 0x20, 0x56, 0x25,
    0x56, 0x2d, 0x56, 0x2e, 0x56, 0x2f, 0x56, 0x33, 0x56, 0x34, 0x56, 0x35,
    0x56, 0x36, 0x56, 0x37, 0x56, 0x38, 0x56, 0x39, 0x56, 0x3d, 0x56, 0x41,
    0x56, 0x5f, 0x56, 0x62, 0x56, 0x64, 0x56, 0x66, 0x56, 0x67, 0x56, 0x68,
    0x56, 0x6c, 0x56, 0x6d, 0x56, 0x6e, 0x56, 0x70, 0x56, 0x72, 0x56, 0x75};
const uint8_t HuffDecoderCommon::table1_114_emit_[72] = {
    0x57, 0x30, 0x57, 0x31, 0x57, 0x32, 0x57, 0x61, 0x57, 0x63, 0x57, 0x65,
    0x57, 0x69, 0x57, 0x6f, 0x57, 0x73, 0x57, 0x74, 0x57, 0x20, 0x57, 0x25,
    0x57, 0x2d, 0x57, 0x2e, 0x57, 0x2f, 0x57, 0x33, 0x57, 0x34, 0x57, 0x35,
    0x57, 0x36, 0x57, 0x37, 0x57, 0x38, 0x57, 0x39, 0x57, 0x3d, 0x57, 0x41,
    0x57, 0x5f, 0x57, 0x62, 0x57, 0x64, 0x57, 0x66, 0x57, 0x67, 0x57, 0x68,
    0x57, 0x6c, 0x57, 0x6d, 0x57, 0x6e, 0x57, 0x70, 0x57, 0x72, 0x57, 0x75};
const uint8_t HuffDecoderCommon::table1_115_emit_[72] = {
    0x59, 0x30, 0x59, 0x31, 0x59, 0x32, 0x59, 0x61, 0x59, 0x63, 0x59, 0x65,
    0x59, 0x69, 0x59, 0x6f, 0x59, 0x73, 0x59, 0x74, 0x59, 0x20, 0x59, 0x25,
    0x59, 0x2d, 0x59, 0x2e, 0x59, 0x2f, 0x59, 0x33, 0x59, 0x34, 0x59, 0x35,
    0x59, 0x36, 0x59, 0x37, 0x59, 0x38, 0x59, 0x39, 0x59, 0x3d, 0x59, 0x41,
    0x59, 0x5f, 0x59, 0x62, 0x59, 0x64, 0x59, 0x66, 0x59, 0x67, 0x59, 0x68,
    0x59, 0x6c, 0x59, 0x6d, 0x59, 0x6e, 0x59, 0x70, 0x59, 0x72, 0x59, 0x75};
const uint8_t HuffDecoderCommon::table1_116_emit_[72] = {
    0x6a, 0x30, 0x6a, 0x31, 0x6a, 0x32, 0x6a, 0x61, 0x6a, 0x63, 0x6a, 0x65,
    0x6a, 0x69, 0x6a, 0x6f, 0x6a, 0x73, 0x6a, 0x74, 0x6a, 0x20, 0x6a, 0x25,
    0x6a, 0x2d, 0x6a, 0x2e, 0x6a, 0x2f, 0x6a, 0x33, 0x6a, 0x34, 0x6a, 0x35,
    0x6a, 0x36, 0x6a, 0x37, 0x6a, 0x38, 0x6a, 0x39, 0x6a, 0x3d, 0x6a, 0x41,
    0x6a, 0x5f, 0x6a, 0x62, 0x6a, 0x64, 0x6a, 0x66, 0x6a, 0x67, 0x6a, 0x68,
    0x6a, 0x6c, 0x6a, 0x6d, 0x6a, 0x6e, 0x6a, 0x70, 0x6a, 0x72, 0x6a, 0x75};
const uint8_t HuffDecoderCommon::table1_117_emit_[72] = {
    0x6b, 0x30, 0x6b, 0x31, 0x6b, 0x32, 0x6b, 0x61, 0x6b, 0x63, 0x6b, 0x65,
    0x6b, 0x69, 0x6b, 0x6f, 0x6b, 0x73, 0x6b, 0x74, 0x6b, 0x20, 0x6b, 0x25,
    0x6b, 0x2d, 0x6b, 0x2e, 0x6b, 0x2f, 0x6b, 0x33, 0x6b, 0x34, 0x6b, 0x35,
    0x6b, 0x36, 0x6b, 0x37, 0x6b, 0x38, 0x6b, 0x39, 0x6b, 0x3d, 0x6b, 0x41,
    0x6b, 0x5f, 0x6b, 0x62, 0x6b, 0x64, 0x6b, 0x66, 0x6b, 0x67, 0x6b, 0x68,
    0x6b, 0x6c, 0x6b, 0x6d, 0x6b, 0x6e, 0x6b, 0x70, 0x6b, 0x72, 0x6b, 0x75};
const uint8_t HuffDecoderCommon::table1_118_emit_[72] = {
    0x71, 0x30, 0x71, 0x31, 0x71, 0x32, 0x71, 0x61, 0x71, 0x63, 0x71, 0x65,
    0x71, 0x69, 0x71, 0x6f, 0x71, 0x73, 0x71, 0x74, 0x71, 0x20, 0x71, 0x25,
    0x71, 0x2d, 0x71, 0x2e, 0x71, 0x2f, 0x71, 0x33, 0x71, 0x34, 0x71, 0x35,
    0x71, 0x36, 0x71, 0x37, 0x71, 0x38, 0x71, 0x39, 0x71, 0x3d, 0x71, 0x41,
    0x71, 0x5f, 0x71, 0x62, 0x71, 0x64, 0x71, 0x66, 0x71, 0x67, 0x71, 0x68,
    0x71, 0x6c, 0x71, 0x6d, 0x71, 0x6e, 0x71, 0x70, 0x71, 0x72, 0x71, 0x75};
const uint8_t HuffDecoderCommon::table1_119_emit_[72] = {
    0x76, 0x30, 0x76, 0x31, 0x76, 0x32, 0x76, 0x61, 0x76, 0x63, 0x76, 0x65,
    0x76, 0x69, 0x76, 0x6f, 0x76, 0x73, 0x76, 0x74, 0x76, 0x20, 0x76, 0x25,
    0x76, 0x2d, 0x76, 0x2e, 0x76, 0x2f, 0x76, 0x33, 0x76, 0x34, 0x76, 0x35,
    0x76, 0x36, 0x76, 0x37, 0x76, 0x38, 0x76, 0x39, 0x76, 0x3d, 0x76, 0x41,
    0x76, 0x5f, 0x76, 0x62, 0x76, 0x64, 0x76, 0x66, 0x76, 0x67, 0x76, 0x68,
    0x76, 0x6c, 0x76, 0x6d, 0x76, 0x6e, 0x76, 0x70, 0x76, 0x72, 0x76, 0x75};
const uint8_t HuffDecoderCommon::table1_120_emit_[72] = {
    0x77, 0x30, 0x77, 0x31, 0x77, 0x32, 0x77, 0x61, 0x77, 0x63, 0x77, 0x65,
    0x77, 0x69, 0x77, 0x6f, 0x77, 0x73, 0x77, 0x74, 0x77, 0x20, 0x77, 0x25,
    0x77, 0x2d, 0x77, 0x2e, 0x77, 0x2f, 0x77, 0x33, 0x77, 0x34, 0x77, 0x35,
    0x77, 0x36, 0x77, 0x37, 0x77, 0x38, 0x77, 0x39, 0x77, 0x3d, 0x77, 0x41,
    0x77, 0x5f, 0x77, 0x62, 0x77, 0x64, 0x77, 0x66, 0x77, 0x67, 0x77, 0x68,
    0x77, 0x6c, 0x77, 0x6d, 0x77, 0x6e, 0x77, 0x70, 0x77, 0x72, 0x77, 0x75};
const uint8_t HuffDecoderCommon::table1_121_emit_[72] = {
    0x78, 0x30, 0x78, 0x31, 0x78, 0x32, 0x78, 0x61, 0x78, 0x63, 0x78, 0x65,
    0x78, 0x69, 0x78, 0x6f, 0x78, 0x73, 0x78, 0x74, 0x78, 0x20, 0x78, 0x25,
    0x78, 0x2d, 0x78, 0x2e, 0x78, 0x2f, 0x78, 0x33, 0x78, 0x34, 0x78, 0x35,
    0x78, 0x36, 0x78, 0x37, 0x78, 0x38, 0x78, 0x39, 0x78, 0x3d, 0x78, 0x41,
    0x78, 0x5f, 0x78, 0x62, 0x78, 0x64, 0x78, 0x66, 0x78, 0x67, 0x78, 0x68,
    0x78, 0x6c, 0x78, 0x6d, 0x78, 0x6e, 0x78, 0x70, 0x78, 0x72, 0x78, 0x75};
const uint8_t HuffDecoderCommon::table1_122_emit_[72] = {
    0x79, 0x30, 0x79, 0x31, 0x79, 0x32, 0x79, 0x61, 0x79, 0x63, 0x79, 0x65,
    0x79, 0x69, 0x79, 0x6f, 0x79, 0x73, 0x79, 0x74, 0x79, 0x20, 0x79, 0x25,
    0x79, 0x2d, 0x79, 0x2e, 0x79, 0x2f, 0x79, 0x33, 0x79, 0x34, 0x79, 0x35,
    0x79, 0x36, 0x79, 0x37, 0x79, 0x38, 0x79, 0x39, 0x79, 0x3d, 0x79, 0x41,
    0x79, 0x5f, 0x79, 0x62, 0x79, 0x64, 0x79, 0x66, 0x79, 0x67, 0x79, 0x68,
    0x79, 0x6c, 0x79, 0x6d, 0x79, 0x6e, 0x79, 0x70, 0x79, 0x72, 0x79, 0x75};
const uint8_t HuffDecoderCommon::table1_123_emit_[72] = {
    0x7a, 0x30, 0x7a, 0x31, 0x7a, 0x32, 0x7a, 0x61, 0x7a, 0x63, 0x7a, 0x65,
    0x7a, 0x69, 0x7a, 0x6f, 0x7a, 0x73, 0x7a, 0x74, 0x7a, 0x20, 0x7a, 0x25,
    0x7a, 0x2d, 0x7a, 0x2e, 0x7a, 0x2f, 0x7a, 0x33, 0x7a, 0x34, 0x7a, 0x35,
    0x7a, 0x36, 0x7a, 0x37, 0x7a, 0x38, 0x7a, 0x39, 0x7a, 0x3d, 0x7a, 0x41,
    0x7a, 0x5f, 0x7a, 0x62, 0x7a, 0x64, 0x7a, 0x66, 0x7a, 0x67, 0x7a, 0x68,
    0x7a, 0x6c, 0x7a, 0x6d, 0x7a, 0x6e, 0x7a, 0x70, 0x7a, 0x72, 0x7a, 0x75};
const uint8_t HuffDecoderCommon::table1_124_emit_[40] = {
    0x26, 0x30, 0x26, 0x31, 0x26, 0x32, 0x26, 0x61, 0x26, 0x63,
    0x26, 0x65, 0x26, 0x69, 0x26, 0x6f, 0x26, 0x73, 0x26, 0x74,
    0x2a, 0x30, 0x2a, 0x31, 0x2a, 0x32, 0x2a, 0x61, 0x2a, 0x63,
    0x2a, 0x65, 0x2a, 0x69, 0x2a, 0x6f, 0x2a, 0x73, 0x2a, 0x74};
const uint16_t HuffDecoderCommon::table1_124_inner_[22] = {
    0x000d, 0x008d, 0x010d, 0x018d, 0x020d, 0x028d, 0x030d, 0x038d,
    0x040d, 0x048d, 0x0018, 0x050d, 0x058d, 0x060d, 0x068d, 0x070d,
    0x078d, 0x080d, 0x088d, 0x090d, 0x098d, 0x0518};
const uint8_t HuffDecoderCommon::table1_124_outer_[64] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 21, 21, 21, 21, 21,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21};
const uint8_t HuffDecoderCommon::table1_125_emit_[40] = {
    0x2c, 0x30, 0x2c, 0x31, 0x2c, 0x32, 0x2c, 0x61, 0x2c, 0x63,
    0x2c, 0x65, 0x2c, 0x69, 0x2c, 0x6f, 0x2c, 0x73, 0x2c, 0x74,
    0x3b, 0x30, 0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x61, 0x3b, 0x63,
    0x3b, 0x65, 0x3b, 0x69, 0x3b, 0x6f, 0x3b, 0x73, 0x3b, 0x74};
const uint8_t HuffDecoderCommon::table1_126_emit_[40] = {
    0x58, 0x30, 0x58, 0x31, 0x58, 0x32, 0x58, 0x61, 0x58, 0x63,
    0x58, 0x65, 0x58, 0x69, 0x58, 0x6f, 0x58, 0x73, 0x58, 0x74,
    0x5a, 0x30, 0x5a, 0x31, 0x5a, 0x32, 0x5a, 0x61, 0x5a, 0x63,
    0x5a, 0x65, 0x5a, 0x69, 0x5a, 0x6f, 0x5a, 0x73, 0x5a, 0x74};
const uint8_t HuffDecoderCommon::table1_127_emit_[16] = {
    0x21, 0x22, 0x28, 0x29, 0x3f, 0x27, 0x2b, 0x7c,
    0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e};
const uint16_t HuffDecoderCommon::table1_127_inner_[18] = {
    0x001a, 0x005a, 0x009a, 0x00da, 0x011a, 0x015b, 0x019b, 0x01db, 0x021c,
    0x025c, 0x029d, 0x02dd, 0x031d, 0x035d, 0x039d, 0x03dd, 0x002d, 0x003d};
const uint8_t HuffDecoderCommon::table1_127_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,  1,  1,  1,  2,  2,  2,  2, 2, 2,
    2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4,  4,  4,  4,  4,  4,  5,  5, 5, 5,
    6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 9, 9, 10, 11, 12, 13, 14, 15, 16, 17};
const uint8_t* const HuffDecoderCommon::table1_emit_[128] = {
    table9_0_emit_,   table9_1_emit_,   table9_2_emit_,   table1_3_emit_,
    table9_4_emit_,   table9_5_emit_,   table9_6_emit_,   table1_7_emit_,
    table9_8_emit_,   table9_9_emit_,   table9_10_emit_,  table1_11_emit_,
    table9_12_emit_,  table9_13_emit_,  table9_14_emit_,  table1_15_emit_,
    table9_16_emit_,  table9_17_emit_,  table9_18_emit_,  table1_19_emit_,
    table9_20_emit_,  table9_21_emit_,  table9_22_emit_,  table1_23_emit_,
    table9_24_emit_,  table9_25_emit_,  table9_26_emit_,  table1_27_emit_,
    table9_28_emit_,  table9_29_emit_,  table9_30_emit_,  table1_31_emit_,
    table9_32_emit_,  table9_33_emit_,  table9_34_emit_,  table1_35_emit_,
    table9_36_emit_,  table9_37_emit_,  table9_38_emit_,  table1_39_emit_,
    table9_40_emit_,  table1_41_emit_,  table9_42_emit_,  table1_43_emit_,
    table9_44_emit_,  table1_45_emit_,  table9_46_emit_,  table1_47_emit_,
    table9_48_emit_,  table1_49_emit_,  table9_50_emit_,  table1_51_emit_,
    table9_52_emit_,  table1_53_emit_,  table9_54_emit_,  table1_55_emit_,
    table9_56_emit_,  table1_57_emit_,  table9_58_emit_,  table1_59_emit_,
    table9_60_emit_,  table1_61_emit_,  table9_62_emit_,  table1_63_emit_,
    table9_64_emit_,  table1_65_emit_,  table9_66_emit_,  table1_67_emit_,
    table9_68_emit_,  table1_69_emit_,  table9_70_emit_,  table1_71_emit_,
    table9_72_emit_,  table1_73_emit_,  table9_74_emit_,  table1_75_emit_,
    table9_76_emit_,  table1_77_emit_,  table9_78_emit_,  table1_79_emit_,
    table9_80_emit_,  table1_81_emit_,  table9_82_emit_,  table1_83_emit_,
    table9_84_emit_,  table1_85_emit_,  table9_86_emit_,  table1_87_emit_,
    table9_88_emit_,  table1_89_emit_,  table9_90_emit_,  table1_91_emit_,
    table1_92_emit_,  table1_93_emit_,  table1_94_emit_,  table1_95_emit_,
    table1_96_emit_,  table1_97_emit_,  table1_98_emit_,  table1_99_emit_,
    table1_100_emit_, table1_101_emit_, table1_102_emit_, table1_103_emit_,
    table1_104_emit_, table1_105_emit_, table1_106_emit_, table1_107_emit_,
    table1_108_emit_, table1_109_emit_, table1_110_emit_, table1_111_emit_,
    table1_112_emit_, table1_113_emit_, table1_114_emit_, table1_115_emit_,
    table1_116_emit_, table1_117_emit_, table1_118_emit_, table1_119_emit_,
    table1_120_emit_, table1_121_emit_, table1_122_emit_, table1_123_emit_,
    table1_124_emit_, table1_125_emit_, table1_126_emit_, table1_127_emit_,
};
const uint16_t* const HuffDecoderCommon::table1_inner_[128] = {
    table1_0_inner_,   table1_1_inner_,   table1_2_inner_,   table1_3_inner_,
    table1_4_inner_,   table1_1_inner_,   table1_2_inner_,   table1_3_inner_,
    table1_8_inner_,   table1_1_inner_,   table1_2_inner_,   table1_3_inner_,
    table1_12_inner_,  table1_1_inner_,   table1_2_inner_,   table1_3_inner_,
    table1_16_inner_,  table1_1_inner_,   table1_2_inner_,   table1_3_inner_,
    table1_20_inner_,  table1_1_inner_,   table1_2_inner_,   table1_3_inner_,
    table1_24_inner_,  table1_1_inner_,   table1_2_inner_,   table1_3_inner_,
    table1_28_inner_,  table1_1_inner_,   table1_2_inner_,   table1_3_inner_,
    table1_28_inner_,  table1_33_inner_,  table1_2_inner_,   table1_3_inner_,
    table1_28_inner_,  table1_37_inner_,  table1_2_inner_,   table1_3_inner_,
    table1_40_inner_,  table1_41_inner_,  table1_42_inner_,  table1_41_inner_,
    table1_44_inner_,  table1_41_inner_,  table1_46_inner_,  table1_41_inner_,
    table1_48_inner_,  table1_41_inner_,  table1_50_inner_,  table1_41_inner_,
    table1_52_inner_,  table1_41_inner_,  table1_54_inner_,  table1_41_inner_,
    table1_56_inner_,  table1_41_inner_,  table1_58_inner_,  table1_41_inner_,
    table1_60_inner_,  table1_41_inner_,  table1_62_inner_,  table1_41_inner_,
    table1_62_inner_,  table1_65_inner_,  table1_62_inner_,  table1_67_inner_,
    table1_62_inner_,  table1_69_inner_,  table1_62_inner_,  table1_71_inner_,
    table1_62_inner_,  table1_73_inner_,  table1_62_inner_,  table1_75_inner_,
    table1_62_inner_,  table1_77_inner_,  table1_62_inner_,  table1_79_inner_,
    table1_62_inner_,  table1_81_inner_,  table1_62_inner_,  table1_83_inner_,
    table1_62_inner_,  table1_85_inner_,  table1_62_inner_,  table1_87_inner_,
    table1_62_inner_,  table1_89_inner_,  table1_62_inner_,  table1_91_inner_,
    table1_92_inner_,  table1_92_inner_,  table1_92_inner_,  table1_92_inner_,
    table1_92_inner_,  table1_92_inner_,  table1_92_inner_,  table1_92_inner_,
    table1_92_inner_,  table1_92_inner_,  table1_92_inner_,  table1_92_inner_,
    table1_92_inner_,  table1_92_inner_,  table1_92_inner_,  table1_92_inner_,
    table1_92_inner_,  table1_92_inner_,  table1_92_inner_,  table1_92_inner_,
    table1_92_inner_,  table1_92_inner_,  table1_92_inner_,  table1_92_inner_,
    table1_92_inner_,  table1_92_inner_,  table1_92_inner_,  table1_92_inner_,
    table1_92_inner_,  table1_92_inner_,  table1_92_inner_,  table1_92_inner_,
    table1_124_inner_, table1_124_inner_, table1_124_inner_, table1_127_inner_,
};
const uint8_t* const HuffDecoderCommon::table1_outer_[128] = {
    table1_0_outer_,   table1_1_outer_,   table1_2_outer_,   table1_3_outer_,
    table1_0_outer_,   table1_1_outer_,   table1_2_outer_,   table1_3_outer_,
    table1_0_outer_,   table1_1_outer_,   table1_2_outer_,   table1_3_outer_,
    table1_0_outer_,   table1_1_outer_,   table1_2_outer_,   table1_3_outer_,
    table1_0_outer_,   table1_1_outer_,   table1_2_outer_,   table1_3_outer_,
    table1_0_outer_,   table1_1_outer_,   table1_2_outer_,   table1_3_outer_,
    table1_0_outer_,   table1_1_outer_,   table1_2_outer_,   table1_3_outer_,
    table1_0_outer_,   table1_1_outer_,   table1_2_outer_,   table1_3_outer_,
    table1_0_outer_,   table1_1_outer_,   table1_2_outer_,   table1_3_outer_,
    table1_0_outer_,   table1_1_outer_,   table1_2_outer_,   table1_3_outer_,
    table1_40_outer_,  table1_41_outer_,  table1_40_outer_,  table1_41_outer_,
    table1_40_outer_,  table1_41_outer_,  table1_40_outer_,  table1_41_outer_,
    table1_40_outer_,  table1_41_outer_,  table1_40_outer_,  table1_41_outer_,
    table1_40_outer_,  table1_41_outer_,  table1_40_outer_,  table1_41_outer_,
    table1_40_outer_,  table1_41_outer_,  table1_40_outer_,  table1_41_outer_,
    table1_40_outer_,  table1_41_outer_,  table1_40_outer_,  table1_41_outer_,
    table1_40_outer_,  table1_41_outer_,  table1_40_outer_,  table1_41_outer_,
    table1_40_outer_,  table1_41_outer_,  table1_40_outer_,  table1_41_outer_,
    table1_40_outer_,  table1_41_outer_,  table1_40_outer_,  table1_41_outer_,
    table1_40_outer_,  table1_41_outer_,  table1_40_outer_,  table1_41_outer_,
    table1_40_outer_,  table1_41_outer_,  table1_40_outer_,  table1_41_outer_,
    table1_40_outer_,  table1_41_outer_,  table1_40_outer_,  table1_41_outer_,
    table1_40_outer_,  table1_41_outer_,  table1_40_outer_,  table1_41_outer_,
    table1_92_outer_,  table1_92_outer_,  table1_92_outer_,  table1_92_outer_,
    table1_92_outer_,  table1_92_outer_,  table1_92_outer_,  table1_92_outer_,
    table1_92_outer_,  table1_92_outer_,  table1_92_outer_,  table1_92_outer_,
    table1_92_outer_,  table1_92_outer_,  table1_92_outer_,  table1_92_outer_,
    table1_92_outer_,  table1_92_outer_,  table1_92_outer_,  table1_92_outer_,
    table1_92_outer_,  table1_92_outer_,  table1_92_outer_,  table1_92_outer_,
    table1_92_outer_,  table1_92_outer_,  table1_92_outer_,  table1_92_outer_,
    table1_92_outer_,  table1_92_outer_,  table1_92_outer_,  table1_92_outer_,
    table1_124_outer_, table1_124_outer_, table1_124_outer_, table1_127_outer_,
};
const uint8_t HuffDecoderCommon::table13_0_inner_[5] = {0x00, 0x01, 0x05, 0x09,
                                                        0x02};
const uint8_t HuffDecoderCommon::table13_0_outer_[8] = {0, 1, 0, 2, 0, 3, 0, 4};
const uint8_t HuffDecoderCommon::table14_0_outer_[16] = {
    0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 4};
const uint8_t HuffDecoderCommon::table15_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table16_0_emit_[6] = {0x3c, 0x60, 0x7b,
                                                       0x5c, 0xc3, 0xd0};
const uint8_t HuffDecoderCommon::table16_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x09, 0x0d, 0x11, 0x15, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table17_0_emit_[20] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63,
    0x3c, 0x65, 0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74};
const uint8_t HuffDecoderCommon::table17_0_ops_[32] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table17_1_emit_[20] = {
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63,
    0x60, 0x65, 0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74};
const uint8_t HuffDecoderCommon::table17_2_emit_[20] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63,
    0x7b, 0x65, 0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74};
const uint8_t HuffDecoderCommon::table17_3_emit_[11] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2};
const uint8_t HuffDecoderCommon::table17_3_ops_[32] = {
    0x01, 0x02, 0x01, 0x06, 0x01, 0x0a, 0x0e, 0x12, 0x16, 0x1a, 0x1e,
    0x22, 0x26, 0x2a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03};
const uint8_t* const HuffDecoderCommon::table17_emit_[4] = {
    table17_0_emit_,
    table17_1_emit_,
    table17_2_emit_,
    table17_3_emit_,
};
const uint8_t* const HuffDecoderCommon::table17_ops_[4] = {
    table17_0_ops_,
    table17_0_ops_,
    table17_0_ops_,
    table17_3_ops_,
};
const uint8_t HuffDecoderCommon::table18_0_emit_[72] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63, 0x3c, 0x65,
    0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74, 0x3c, 0x20, 0x3c, 0x25,
    0x3c, 0x2d, 0x3c, 0x2e, 0x3c, 0x2f, 0x3c, 0x33, 0x3c, 0x34, 0x3c, 0x35,
    0x3c, 0x36, 0x3c, 0x37, 0x3c, 0x38, 0x3c, 0x39, 0x3c, 0x3d, 0x3c, 0x41,
    0x3c, 0x5f, 0x3c, 0x62, 0x3c, 0x64, 0x3c, 0x66, 0x3c, 0x67, 0x3c, 0x68,
    0x3c, 0x6c, 0x3c, 0x6d, 0x3c, 0x6e, 0x3c, 0x70, 0x3c, 0x72, 0x3c, 0x75};
const uint16_t HuffDecoderCommon::table18_0_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9,
    0x00b1, 0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9,
    0x00f1, 0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table18_1_emit_[72] = {
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63, 0x60, 0x65,
    0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74, 0x60, 0x20, 0x60, 0x25,
    0x60, 0x2d, 0x60, 0x2e, 0x60, 0x2f, 0x60, 0x33, 0x60, 0x34, 0x60, 0x35,
    0x60, 0x36, 0x60, 0x37, 0x60, 0x38, 0x60, 0x39, 0x60, 0x3d, 0x60, 0x41,
    0x60, 0x5f, 0x60, 0x62, 0x60, 0x64, 0x60, 0x66, 0x60, 0x67, 0x60, 0x68,
    0x60, 0x6c, 0x60, 0x6d, 0x60, 0x6e, 0x60, 0x70, 0x60, 0x72, 0x60, 0x75};
const uint8_t HuffDecoderCommon::table18_2_emit_[72] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b, 0x65,
    0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x7b, 0x20, 0x7b, 0x25,
    0x7b, 0x2d, 0x7b, 0x2e, 0x7b, 0x2f, 0x7b, 0x33, 0x7b, 0x34, 0x7b, 0x35,
    0x7b, 0x36, 0x7b, 0x37, 0x7b, 0x38, 0x7b, 0x39, 0x7b, 0x3d, 0x7b, 0x41,
    0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64, 0x7b, 0x66, 0x7b, 0x67, 0x7b, 0x68,
    0x7b, 0x6c, 0x7b, 0x6d, 0x7b, 0x6e, 0x7b, 0x70, 0x7b, 0x72, 0x7b, 0x75};
const uint8_t HuffDecoderCommon::table18_3_emit_[24] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2, 0x99,
    0xa1, 0xa7, 0xac, 0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6};
const uint16_t HuffDecoderCommon::table18_3_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x000a, 0x0000, 0x000e, 0x0000, 0x0012,
    0x0000, 0x0016, 0x0000, 0x001a, 0x0000, 0x001e, 0x0000, 0x0022,
    0x0000, 0x0026, 0x0000, 0x002a, 0x002e, 0x0032, 0x0036, 0x003a,
    0x003e, 0x0042, 0x0046, 0x004a, 0x004e, 0x0052, 0x0056, 0x005a,
    0x005e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table18_emit_[4] = {
    table18_0_emit_,
    table18_1_emit_,
    table18_2_emit_,
    table18_3_emit_,
};
const uint16_t* const HuffDecoderCommon::table18_ops_[4] = {
    table18_0_ops_,
    table18_0_ops_,
    table18_0_ops_,
    table18_3_ops_,
};
const uint8_t HuffDecoderCommon::table19_0_emit_[136] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63, 0x3c, 0x65,
    0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74, 0x3c, 0x20, 0x3c, 0x25,
    0x3c, 0x2d, 0x3c, 0x2e, 0x3c, 0x2f, 0x3c, 0x33, 0x3c, 0x34, 0x3c, 0x35,
    0x3c, 0x36, 0x3c, 0x37, 0x3c, 0x38, 0x3c, 0x39, 0x3c, 0x3d, 0x3c, 0x41,
    0x3c, 0x5f, 0x3c, 0x62, 0x3c, 0x64, 0x3c, 0x66, 0x3c, 0x67, 0x3c, 0x68,
    0x3c, 0x6c, 0x3c, 0x6d, 0x3c, 0x6e, 0x3c, 0x70, 0x3c, 0x72, 0x3c, 0x75,
    0x3c, 0x3a, 0x3c, 0x42, 0x3c, 0x43, 0x3c, 0x44, 0x3c, 0x45, 0x3c, 0x46,
    0x3c, 0x47, 0x3c, 0x48, 0x3c, 0x49, 0x3c, 0x4a, 0x3c, 0x4b, 0x3c, 0x4c,
    0x3c, 0x4d, 0x3c, 0x4e, 0x3c, 0x4f, 0x3c, 0x50, 0x3c, 0x51, 0x3c, 0x52,
    0x3c, 0x53, 0x3c, 0x54, 0x3c, 0x55, 0x3c, 0x56, 0x3c, 0x57, 0x3c, 0x59,
    0x3c, 0x6a, 0x3c, 0x6b, 0x3c, 0x71, 0x3c, 0x76, 0x3c, 0x77, 0x3c, 0x78,
    0x3c, 0x79, 0x3c, 0x7a};
const uint16_t HuffDecoderCommon::table19_0_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000,
    0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000,
    0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000,
    0x0031, 0x0000, 0x0000, 0x0000, 0x0039, 0x0000, 0x0000, 0x0000, 0x0041,
    0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059, 0x0000,
    0x0061, 0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081,
    0x0000, 0x0089, 0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000,
    0x00a9, 0x0000, 0x00b1, 0x0000, 0x00b9, 0x0000, 0x00c1, 0x0000, 0x00c9,
    0x0000, 0x00d1, 0x0000, 0x00d9, 0x0000, 0x00e1, 0x0000, 0x00e9, 0x0000,
    0x00f1, 0x0000, 0x00f9, 0x0000, 0x0101, 0x0000, 0x0109, 0x0000, 0x0111,
    0x0000, 0x0119, 0x0121, 0x0129, 0x0131, 0x0139, 0x0141, 0x0149, 0x0151,
    0x0159, 0x0161, 0x0169, 0x0171, 0x0179, 0x0181, 0x0189, 0x0191, 0x0199,
    0x01a1, 0x01a9, 0x01b1, 0x01b9, 0x01c1, 0x01c9, 0x01d1, 0x01d9, 0x01e1,
    0x01e9, 0x01f1, 0x01f9, 0x0201, 0x0209, 0x0211, 0x0219, 0x0000, 0x0000,
    0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table19_1_emit_[136] = {
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63, 0x60, 0x65,
    0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74, 0x60, 0x20, 0x60, 0x25,
    0x60, 0x2d, 0x60, 0x2e, 0x60, 0x2f, 0x60, 0x33, 0x60, 0x34, 0x60, 0x35,
    0x60, 0x36, 0x60, 0x37, 0x60, 0x38, 0x60, 0x39, 0x60, 0x3d, 0x60, 0x41,
    0x60, 0x5f, 0x60, 0x62, 0x60, 0x64, 0x60, 0x66, 0x60, 0x67, 0x60, 0x68,
    0x60, 0x6c, 0x60, 0x6d, 0x60, 0x6e, 0x60, 0x70, 0x60, 0x72, 0x60, 0x75,
    0x60, 0x3a, 0x60, 0x42, 0x60, 0x43, 0x60, 0x44, 0x60, 0x45, 0x60, 0x46,
    0x60, 0x47, 0x60, 0x48, 0x60, 0x49, 0x60, 0x4a, 0x60, 0x4b, 0x60, 0x4c,
    0x60, 0x4d, 0x60, 0x4e, 0x60, 0x4f, 0x60, 0x50, 0x60, 0x51, 0x60, 0x52,
    0x60, 0x53, 0x60, 0x54, 0x60, 0x55, 0x60, 0x56, 0x60, 0x57, 0x60, 0x59,
    0x60, 0x6a, 0x60, 0x6b, 0x60, 0x71, 0x60, 0x76, 0x60, 0x77, 0x60, 0x78,
    0x60, 0x79, 0x60, 0x7a};
const uint8_t HuffDecoderCommon::table19_2_emit_[136] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b, 0x65,
    0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x7b, 0x20, 0x7b, 0x25,
    0x7b, 0x2d, 0x7b, 0x2e, 0x7b, 0x2f, 0x7b, 0x33, 0x7b, 0x34, 0x7b, 0x35,
    0x7b, 0x36, 0x7b, 0x37, 0x7b, 0x38, 0x7b, 0x39, 0x7b, 0x3d, 0x7b, 0x41,
    0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64, 0x7b, 0x66, 0x7b, 0x67, 0x7b, 0x68,
    0x7b, 0x6c, 0x7b, 0x6d, 0x7b, 0x6e, 0x7b, 0x70, 0x7b, 0x72, 0x7b, 0x75,
    0x7b, 0x3a, 0x7b, 0x42, 0x7b, 0x43, 0x7b, 0x44, 0x7b, 0x45, 0x7b, 0x46,
    0x7b, 0x47, 0x7b, 0x48, 0x7b, 0x49, 0x7b, 0x4a, 0x7b, 0x4b, 0x7b, 0x4c,
    0x7b, 0x4d, 0x7b, 0x4e, 0x7b, 0x4f, 0x7b, 0x50, 0x7b, 0x51, 0x7b, 0x52,
    0x7b, 0x53, 0x7b, 0x54, 0x7b, 0x55, 0x7b, 0x56, 0x7b, 0x57, 0x7b, 0x59,
    0x7b, 0x6a, 0x7b, 0x6b, 0x7b, 0x71, 0x7b, 0x76, 0x7b, 0x77, 0x7b, 0x78,
    0x7b, 0x79, 0x7b, 0x7a};
const uint8_t HuffDecoderCommon::table19_3_emit_[50] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0,
    0xe2, 0x99, 0xa1, 0xa7, 0xac, 0xb0, 0xb1, 0xb3, 0xd1, 0xd8,
    0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84, 0x85, 0x86, 0x88, 0x92,
    0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa, 0xad, 0xb2, 0xb5,
    0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8, 0xe9};
const uint16_t HuffDecoderCommon::table19_3_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000,
    0x000e, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x001a, 0x0000, 0x0000, 0x0000, 0x001e, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0026, 0x0000, 0x0000,
    0x0000, 0x002a, 0x0000, 0x002e, 0x0000, 0x0032, 0x0000, 0x0036, 0x0000,
    0x003a, 0x0000, 0x003e, 0x0000, 0x0042, 0x0000, 0x0046, 0x0000, 0x004a,
    0x0000, 0x004e, 0x0000, 0x0052, 0x0000, 0x0056, 0x0000, 0x005a, 0x0000,
    0x005e, 0x0062, 0x0066, 0x006a, 0x006e, 0x0072, 0x0076, 0x007a, 0x007e,
    0x0082, 0x0086, 0x008a, 0x008e, 0x0092, 0x0096, 0x009a, 0x009e, 0x00a2,
    0x00a6, 0x00aa, 0x00ae, 0x00b2, 0x00b6, 0x00ba, 0x00be, 0x00c2, 0x00c6,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table19_emit_[4] = {
    table19_0_emit_,
    table19_1_emit_,
    table19_2_emit_,
    table19_3_emit_,
};
const uint16_t* const HuffDecoderCommon::table19_ops_[4] = {
    table19_0_ops_,
    table19_0_ops_,
    table19_0_ops_,
    table19_3_ops_,
};
const uint8_t HuffDecoderCommon::table20_0_emit_[44] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63, 0x3c,
    0x65, 0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74, 0x3c, 0x20,
    0x3c, 0x25, 0x3c, 0x2d, 0x3c, 0x2e, 0x3c, 0x2f, 0x3c, 0x33, 0x3c,
    0x34, 0x3c, 0x35, 0x3c, 0x36, 0x3c, 0x37, 0x3c, 0x38, 0x3c, 0x39};
const uint16_t HuffDecoderCommon::table20_0_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0041,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0049, 0x0000,
    0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059, 0x0000, 0x0000,
    0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069, 0x0000, 0x0000, 0x0000,
    0x0071, 0x0000, 0x0000, 0x0000, 0x0079, 0x0000, 0x0000, 0x0000, 0x0081,
    0x0000, 0x0000, 0x0000, 0x0089, 0x0000, 0x0000, 0x0000, 0x0091, 0x0000,
    0x0000, 0x0000, 0x0099, 0x0000, 0x0000, 0x0000, 0x00a1, 0x0000, 0x0000,
    0x0000, 0x00a9};
const uint8_t HuffDecoderCommon::table20_1_emit_[104] = {
    0x3c, 0x3d, 0x3c, 0x41, 0x3c, 0x5f, 0x3c, 0x62, 0x3c, 0x64, 0x3c, 0x66,
    0x3c, 0x67, 0x3c, 0x68, 0x3c, 0x6c, 0x3c, 0x6d, 0x3c, 0x6e, 0x3c, 0x70,
    0x3c, 0x72, 0x3c, 0x75, 0x3c, 0x3a, 0x3c, 0x42, 0x3c, 0x43, 0x3c, 0x44,
    0x3c, 0x45, 0x3c, 0x46, 0x3c, 0x47, 0x3c, 0x48, 0x3c, 0x49, 0x3c, 0x4a,
    0x3c, 0x4b, 0x3c, 0x4c, 0x3c, 0x4d, 0x3c, 0x4e, 0x3c, 0x4f, 0x3c, 0x50,
    0x3c, 0x51, 0x3c, 0x52, 0x3c, 0x53, 0x3c, 0x54, 0x3c, 0x55, 0x3c, 0x56,
    0x3c, 0x57, 0x3c, 0x59, 0x3c, 0x6a, 0x3c, 0x6b, 0x3c, 0x71, 0x3c, 0x76,
    0x3c, 0x77, 0x3c, 0x78, 0x3c, 0x79, 0x3c, 0x7a, 0x3c, 0x26, 0x3c, 0x2a,
    0x3c, 0x2c, 0x3c, 0x3b, 0x3c, 0x58, 0x3c, 0x5a};
const uint16_t HuffDecoderCommon::table20_1_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000,
    0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000,
    0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000,
    0x0031, 0x0000, 0x0000, 0x0000, 0x0039, 0x0000, 0x0000, 0x0000, 0x0041,
    0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0000, 0x0000, 0x0051, 0x0000,
    0x0000, 0x0000, 0x0059, 0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000,
    0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000,
    0x0089, 0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000, 0x00a9,
    0x0000, 0x00b1, 0x0000, 0x00b9, 0x0000, 0x00c1, 0x0000, 0x00c9, 0x0000,
    0x00d1, 0x0000, 0x00d9, 0x0000, 0x00e1, 0x0000, 0x00e9, 0x0000, 0x00f1,
    0x0000, 0x00f9, 0x0000, 0x0101, 0x0000, 0x0109, 0x0000, 0x0111, 0x0000,
    0x0119, 0x0000, 0x0121, 0x0000, 0x0129, 0x0000, 0x0131, 0x0000, 0x0139,
    0x0000, 0x0141, 0x0000, 0x0149, 0x0000, 0x0151, 0x0000, 0x0159, 0x0000,
    0x0161, 0x0000, 0x0169, 0x0171, 0x0179, 0x0181, 0x0189, 0x0191, 0x0199,
    0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table20_2_emit_[44] = {
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63, 0x60,
    0x65, 0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74, 0x60, 0x20,
    0x60, 0x25, 0x60, 0x2d, 0x60, 0x2e, 0x60, 0x2f, 0x60, 0x33, 0x60,
    0x34, 0x60, 0x35, 0x60, 0x36, 0x60, 0x37, 0x60, 0x38, 0x60, 0x39};
const uint8_t HuffDecoderCommon::table20_3_emit_[104] = {
    0x60, 0x3d, 0x60, 0x41, 0x60, 0x5f, 0x60, 0x62, 0x60, 0x64, 0x60, 0x66,
    0x60, 0x67, 0x60, 0x68, 0x60, 0x6c, 0x60, 0x6d, 0x60, 0x6e, 0x60, 0x70,
    0x60, 0x72, 0x60, 0x75, 0x60, 0x3a, 0x60, 0x42, 0x60, 0x43, 0x60, 0x44,
    0x60, 0x45, 0x60, 0x46, 0x60, 0x47, 0x60, 0x48, 0x60, 0x49, 0x60, 0x4a,
    0x60, 0x4b, 0x60, 0x4c, 0x60, 0x4d, 0x60, 0x4e, 0x60, 0x4f, 0x60, 0x50,
    0x60, 0x51, 0x60, 0x52, 0x60, 0x53, 0x60, 0x54, 0x60, 0x55, 0x60, 0x56,
    0x60, 0x57, 0x60, 0x59, 0x60, 0x6a, 0x60, 0x6b, 0x60, 0x71, 0x60, 0x76,
    0x60, 0x77, 0x60, 0x78, 0x60, 0x79, 0x60, 0x7a, 0x60, 0x26, 0x60, 0x2a,
    0x60, 0x2c, 0x60, 0x3b, 0x60, 0x58, 0x60, 0x5a};
const uint8_t HuffDecoderCommon::table20_4_emit_[44] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b,
    0x65, 0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x7b, 0x20,
    0x7b, 0x25, 0x7b, 0x2d, 0x7b, 0x2e, 0x7b, 0x2f, 0x7b, 0x33, 0x7b,
    0x34, 0x7b, 0x35, 0x7b, 0x36, 0x7b, 0x37, 0x7b, 0x38, 0x7b, 0x39};
const uint8_t HuffDecoderCommon::table20_5_emit_[104] = {
    0x7b, 0x3d, 0x7b, 0x41, 0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64, 0x7b, 0x66,
    0x7b, 0x67, 0x7b, 0x68, 0x7b, 0x6c, 0x7b, 0x6d, 0x7b, 0x6e, 0x7b, 0x70,
    0x7b, 0x72, 0x7b, 0x75, 0x7b, 0x3a, 0x7b, 0x42, 0x7b, 0x43, 0x7b, 0x44,
    0x7b, 0x45, 0x7b, 0x46, 0x7b, 0x47, 0x7b, 0x48, 0x7b, 0x49, 0x7b, 0x4a,
    0x7b, 0x4b, 0x7b, 0x4c, 0x7b, 0x4d, 0x7b, 0x4e, 0x7b, 0x4f, 0x7b, 0x50,
    0x7b, 0x51, 0x7b, 0x52, 0x7b, 0x53, 0x7b, 0x54, 0x7b, 0x55, 0x7b, 0x56,
    0x7b, 0x57, 0x7b, 0x59, 0x7b, 0x6a, 0x7b, 0x6b, 0x7b, 0x71, 0x7b, 0x76,
    0x7b, 0x77, 0x7b, 0x78, 0x7b, 0x79, 0x7b, 0x7a, 0x7b, 0x26, 0x7b, 0x2a,
    0x7b, 0x2c, 0x7b, 0x3b, 0x7b, 0x58, 0x7b, 0x5a};
const uint8_t HuffDecoderCommon::table20_6_emit_[15] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8,
    0xc2, 0xe0, 0xe2, 0x99, 0xa1, 0xa7, 0xac};
const uint16_t HuffDecoderCommon::table20_6_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0012, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001a, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0026, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x002a, 0x0000, 0x0000, 0x0000, 0x002e, 0x0000,
    0x0000, 0x0000, 0x0032, 0x0000, 0x0000, 0x0000, 0x0036, 0x0000, 0x0000,
    0x0000, 0x003a};
const uint8_t HuffDecoderCommon::table20_7_emit_[64] = {
    0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84,
    0x85, 0x86, 0x88, 0x92, 0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa,
    0xad, 0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4,
    0xe8, 0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f, 0x93,
    0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8, 0xae,
    0xaf, 0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef};
const uint16_t HuffDecoderCommon::table20_7_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0006, 0x0000,
    0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x000e, 0x0000, 0x0000,
    0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0016, 0x0000, 0x0000, 0x0000,
    0x001a, 0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0026, 0x0000, 0x002a, 0x0000, 0x002e, 0x0000, 0x0032, 0x0000,
    0x0036, 0x0000, 0x003a, 0x0000, 0x003e, 0x0000, 0x0042, 0x0000, 0x0046,
    0x0000, 0x004a, 0x0000, 0x004e, 0x0000, 0x0052, 0x0000, 0x0056, 0x0000,
    0x005a, 0x0000, 0x005e, 0x0000, 0x0062, 0x0000, 0x0066, 0x0000, 0x006a,
    0x0000, 0x006e, 0x0000, 0x0072, 0x0000, 0x0076, 0x0000, 0x007a, 0x0000,
    0x007e, 0x0000, 0x0082, 0x0000, 0x0086, 0x0000, 0x008a, 0x008e, 0x0092,
    0x0096, 0x009a, 0x009e, 0x00a2, 0x00a6, 0x00aa, 0x00ae, 0x00b2, 0x00b6,
    0x00ba, 0x00be, 0x00c2, 0x00c6, 0x00ca, 0x00ce, 0x00d2, 0x00d6, 0x00da,
    0x00de, 0x00e2, 0x00e6, 0x00ea, 0x00ee, 0x00f2, 0x00f6, 0x00fa, 0x00fe,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table20_emit_[8] = {
    table20_0_emit_, table20_1_emit_, table20_2_emit_, table20_3_emit_,
    table20_4_emit_, table20_5_emit_, table20_6_emit_, table20_7_emit_,
};
const uint16_t* const HuffDecoderCommon::table20_ops_[8] = {
    table20_0_ops_, table20_1_ops_, table20_0_ops_, table20_1_ops_,
    table20_0_ops_, table20_1_ops_, table20_6_ops_, table20_7_ops_,
};
const uint8_t HuffDecoderCommon::table21_0_emit_[16] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61,
    0x3c, 0x63, 0x3c, 0x65, 0x3c, 0x69, 0x3c, 0x6f};
const uint16_t HuffDecoderCommon::table21_0_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0019, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0039};
const uint8_t HuffDecoderCommon::table21_1_emit_[28] = {
    0x3c, 0x73, 0x3c, 0x74, 0x3c, 0x20, 0x3c, 0x25, 0x3c, 0x2d,
    0x3c, 0x2e, 0x3c, 0x2f, 0x3c, 0x33, 0x3c, 0x34, 0x3c, 0x35,
    0x3c, 0x36, 0x3c, 0x37, 0x3c, 0x38, 0x3c, 0x39};
const uint16_t HuffDecoderCommon::table21_1_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0019, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0029, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0031,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0039, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0069};
const uint8_t HuffDecoderCommon::table21_2_emit_[36] = {
    0x3c, 0x3d, 0x3c, 0x41, 0x3c, 0x5f, 0x3c, 0x62, 0x3c, 0x64, 0x3c, 0x66,
    0x3c, 0x67, 0x3c, 0x68, 0x3c, 0x6c, 0x3c, 0x6d, 0x3c, 0x6e, 0x3c, 0x70,
    0x3c, 0x72, 0x3c, 0x75, 0x3c, 0x3a, 0x3c, 0x42, 0x3c, 0x43, 0x3c, 0x44};
const uint16_t HuffDecoderCommon::table21_2_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0041,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0049, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0059, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0069, 0x0000, 0x0000, 0x0000, 0x0071, 0x0000,
    0x0000, 0x0000, 0x0079, 0x0000, 0x0000, 0x0000, 0x0081, 0x0000, 0x0000,
    0x0000, 0x0089};
const uint8_t HuffDecoderCommon::table21_3_emit_[68] = {
    0x3c, 0x45, 0x3c, 0x46, 0x3c, 0x47, 0x3c, 0x48, 0x3c, 0x49, 0x3c, 0x4a,
    0x3c, 0x4b, 0x3c, 0x4c, 0x3c, 0x4d, 0x3c, 0x4e, 0x3c, 0x4f, 0x3c, 0x50,
    0x3c, 0x51, 0x3c, 0x52, 0x3c, 0x53, 0x3c, 0x54, 0x3c, 0x55, 0x3c, 0x56,
    0x3c, 0x57, 0x3c, 0x59, 0x3c, 0x6a, 0x3c, 0x6b, 0x3c, 0x71, 0x3c, 0x76,
    0x3c, 0x77, 0x3c, 0x78, 0x3c, 0x79, 0x3c, 0x7a, 0x3c, 0x26, 0x3c, 0x2a,
    0x3c, 0x2c, 0x3c, 0x3b, 0x3c, 0x58, 0x3c, 0x5a};
const uint16_t HuffDecoderCommon::table21_3_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000,
    0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000,
    0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000,
    0x0031, 0x0000, 0x0000, 0x0000, 0x0039, 0x0000, 0x0000, 0x0000, 0x0041,
    0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0000, 0x0000, 0x0051, 0x0000,
    0x0000, 0x0000, 0x0059, 0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000,
    0x0000, 0x0069, 0x0000, 0x0000, 0x0000, 0x0071, 0x0000, 0x0000, 0x0000,
    0x0079, 0x0000, 0x0000, 0x0000, 0x0081, 0x0000, 0x0000, 0x0000, 0x0089,
    0x0000, 0x0000, 0x0000, 0x0091, 0x0000, 0x0000, 0x0000, 0x0099, 0x0000,
    0x0000, 0x0000, 0x00a1, 0x0000, 0x0000, 0x0000, 0x00a9, 0x0000, 0x0000,
    0x0000, 0x00b1, 0x0000, 0x0000, 0x0000, 0x00b9, 0x0000, 0x0000, 0x0000,
    0x00c1, 0x0000, 0x0000, 0x0000, 0x00c9, 0x0000, 0x0000, 0x0000, 0x00d1,
    0x0000, 0x0000, 0x0000, 0x00d9, 0x0000, 0x00e1, 0x0000, 0x00e9, 0x0000,
    0x00f1, 0x0000, 0x00f9, 0x0000, 0x0101, 0x0000, 0x0109, 0x0000, 0x0000,
    0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table21_4_emit_[16] = {
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61,
    0x60, 0x63, 0x60, 0x65, 0x60, 0x69, 0x60, 0x6f};
const uint8_t HuffDecoderCommon::table21_5_emit_[28] = {
    0x60, 0x73, 0x60, 0x74, 0x60, 0x20, 0x60, 0x25, 0x60, 0x2d,
    0x60, 0x2e, 0x60, 0x2f, 0x60, 0x33, 0x60, 0x34, 0x60, 0x35,
    0x60, 0x36, 0x60, 0x37, 0x60, 0x38, 0x60, 0x39};
const uint8_t HuffDecoderCommon::table21_6_emit_[36] = {
    0x60, 0x3d, 0x60, 0x41, 0x60, 0x5f, 0x60, 0x62, 0x60, 0x64, 0x60, 0x66,
    0x60, 0x67, 0x60, 0x68, 0x60, 0x6c, 0x60, 0x6d, 0x60, 0x6e, 0x60, 0x70,
    0x60, 0x72, 0x60, 0x75, 0x60, 0x3a, 0x60, 0x42, 0x60, 0x43, 0x60, 0x44};
const uint8_t HuffDecoderCommon::table21_7_emit_[68] = {
    0x60, 0x45, 0x60, 0x46, 0x60, 0x47, 0x60, 0x48, 0x60, 0x49, 0x60, 0x4a,
    0x60, 0x4b, 0x60, 0x4c, 0x60, 0x4d, 0x60, 0x4e, 0x60, 0x4f, 0x60, 0x50,
    0x60, 0x51, 0x60, 0x52, 0x60, 0x53, 0x60, 0x54, 0x60, 0x55, 0x60, 0x56,
    0x60, 0x57, 0x60, 0x59, 0x60, 0x6a, 0x60, 0x6b, 0x60, 0x71, 0x60, 0x76,
    0x60, 0x77, 0x60, 0x78, 0x60, 0x79, 0x60, 0x7a, 0x60, 0x26, 0x60, 0x2a,
    0x60, 0x2c, 0x60, 0x3b, 0x60, 0x58, 0x60, 0x5a};
const uint8_t HuffDecoderCommon::table21_8_emit_[16] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61,
    0x7b, 0x63, 0x7b, 0x65, 0x7b, 0x69, 0x7b, 0x6f};
const uint8_t HuffDecoderCommon::table21_9_emit_[28] = {
    0x7b, 0x73, 0x7b, 0x74, 0x7b, 0x20, 0x7b, 0x25, 0x7b, 0x2d,
    0x7b, 0x2e, 0x7b, 0x2f, 0x7b, 0x33, 0x7b, 0x34, 0x7b, 0x35,
    0x7b, 0x36, 0x7b, 0x37, 0x7b, 0x38, 0x7b, 0x39};
const uint8_t HuffDecoderCommon::table21_10_emit_[36] = {
    0x7b, 0x3d, 0x7b, 0x41, 0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64, 0x7b, 0x66,
    0x7b, 0x67, 0x7b, 0x68, 0x7b, 0x6c, 0x7b, 0x6d, 0x7b, 0x6e, 0x7b, 0x70,
    0x7b, 0x72, 0x7b, 0x75, 0x7b, 0x3a, 0x7b, 0x42, 0x7b, 0x43, 0x7b, 0x44};
const uint8_t HuffDecoderCommon::table21_11_emit_[68] = {
    0x7b, 0x45, 0x7b, 0x46, 0x7b, 0x47, 0x7b, 0x48, 0x7b, 0x49, 0x7b, 0x4a,
    0x7b, 0x4b, 0x7b, 0x4c, 0x7b, 0x4d, 0x7b, 0x4e, 0x7b, 0x4f, 0x7b, 0x50,
    0x7b, 0x51, 0x7b, 0x52, 0x7b, 0x53, 0x7b, 0x54, 0x7b, 0x55, 0x7b, 0x56,
    0x7b, 0x57, 0x7b, 0x59, 0x7b, 0x6a, 0x7b, 0x6b, 0x7b, 0x71, 0x7b, 0x76,
    0x7b, 0x77, 0x7b, 0x78, 0x7b, 0x79, 0x7b, 0x7a, 0x7b, 0x26, 0x7b, 0x2a,
    0x7b, 0x2c, 0x7b, 0x3b, 0x7b, 0x58, 0x7b, 0x5a};
const uint8_t HuffDecoderCommon::table21_12_emit_[62] = {
    0x5c, 0x30, 0x5c, 0x31, 0x5c, 0x32, 0x5c, 0x61, 0x5c, 0x63, 0x5c,
    0x65, 0x5c, 0x69, 0x5c, 0x6f, 0x5c, 0x73, 0x5c, 0x74, 0xc3, 0x30,
    0xc3, 0x31, 0xc3, 0x32, 0xc3, 0x61, 0xc3, 0x63, 0xc3, 0x65, 0xc3,
    0x69, 0xc3, 0x6f, 0xc3, 0x73, 0xc3, 0x74, 0xd0, 0x30, 0xd0, 0x31,
    0xd0, 0x32, 0xd0, 0x61, 0xd0, 0x63, 0xd0, 0x65, 0xd0, 0x69, 0xd0,
    0x6f, 0xd0, 0x73, 0xd0, 0x74, 0x80, 0x82};
const uint16_t HuffDecoderCommon::table21_12_ops_[128] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039, 0x0041,
    0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0052, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9,
    0x00e1, 0x00e9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x00f2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x00f6};
const uint8_t HuffDecoderCommon::table21_13_emit_[10] = {
    0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2, 0x99, 0xa1, 0xa7, 0xac};
const uint16_t HuffDecoderCommon::table21_13_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x000e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0016, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x001a, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0026};
const uint8_t HuffDecoderCommon::table21_14_emit_[23] = {
    0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84, 0x85,
    0x86, 0x88, 0x92, 0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa, 0xad};
const uint16_t HuffDecoderCommon::table21_14_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0016, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x001a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x001e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0026, 0x0000, 0x0000, 0x0000, 0x002a, 0x0000,
    0x0000, 0x0000, 0x002e, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000,
    0x0000, 0x0036, 0x0000, 0x0000, 0x0000, 0x003a, 0x0000, 0x0000, 0x0000,
    0x003e, 0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0046,
    0x0000, 0x0000, 0x0000, 0x004a, 0x0000, 0x0000, 0x0000, 0x004e, 0x0000,
    0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000, 0x0056, 0x0000, 0x0000,
    0x0000, 0x005a};
const uint8_t HuffDecoderCommon::table21_15_emit_[53] = {
    0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8,
    0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f, 0x93, 0x95,
    0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8, 0xae, 0xaf,
    0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90,
    0x91, 0x94, 0x9f, 0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed};
const uint16_t HuffDecoderCommon::table21_15_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0006, 0x0000,
    0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x000e, 0x0000, 0x0000,
    0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0016, 0x0000, 0x0000, 0x0000,
    0x001a, 0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0026, 0x0000, 0x0000, 0x0000, 0x002a, 0x0000,
    0x0000, 0x0000, 0x002e, 0x0000, 0x0032, 0x0000, 0x0036, 0x0000, 0x003a,
    0x0000, 0x003e, 0x0000, 0x0042, 0x0000, 0x0046, 0x0000, 0x004a, 0x0000,
    0x004e, 0x0000, 0x0052, 0x0000, 0x0056, 0x0000, 0x005a, 0x0000, 0x005e,
    0x0000, 0x0062, 0x0000, 0x0066, 0x0000, 0x006a, 0x0000, 0x006e, 0x0000,
    0x0072, 0x0000, 0x0076, 0x0000, 0x007a, 0x0000, 0x007e, 0x0000, 0x0082,
    0x0000, 0x0086, 0x0000, 0x008a, 0x0000, 0x008e, 0x0000, 0x0092, 0x0000,
    0x0096, 0x0000, 0x009a, 0x0000, 0x009e, 0x0000, 0x00a2, 0x00a6, 0x00aa,
    0x00ae, 0x00b2, 0x00b6, 0x00ba, 0x00be, 0x00c2, 0x00c6, 0x00ca, 0x00ce,
    0x00d2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table21_emit_[16] = {
    table21_0_emit_,  table21_1_emit_,  table21_2_emit_,  table21_3_emit_,
    table21_4_emit_,  table21_5_emit_,  table21_6_emit_,  table21_7_emit_,
    table21_8_emit_,  table21_9_emit_,  table21_10_emit_, table21_11_emit_,
    table21_12_emit_, table21_13_emit_, table21_14_emit_, table21_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table21_ops_[16] = {
    table21_0_ops_,  table21_1_ops_,  table21_2_ops_,  table21_3_ops_,
    table21_0_ops_,  table21_1_ops_,  table21_2_ops_,  table21_3_ops_,
    table21_0_ops_,  table21_1_ops_,  table21_2_ops_,  table21_3_ops_,
    table21_12_ops_, table21_13_ops_, table21_14_ops_, table21_15_ops_,
};
const uint8_t HuffDecoderCommon::table22_0_emit_[60] = {
    0x3c, 0x30, 0x30, 0x3c, 0x30, 0x31, 0x3c, 0x30, 0x32, 0x3c, 0x30, 0x61,
    0x3c, 0x30, 0x63, 0x3c, 0x30, 0x65, 0x3c, 0x30, 0x69, 0x3c, 0x30, 0x6f,
    0x3c, 0x30, 0x73, 0x3c, 0x30, 0x74, 0x3c, 0x31, 0x30, 0x3c, 0x31, 0x31,
    0x3c, 0x31, 0x32, 0x3c, 0x31, 0x61, 0x3c, 0x31, 0x63, 0x3c, 0x31, 0x65,
    0x3c, 0x31, 0x69, 0x3c, 0x31, 0x6f, 0x3c, 0x31, 0x73, 0x3c, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table22_0_ops_[64] = {
    0x0000, 0x0018, 0x0030, 0x0048, 0x0060, 0x0078, 0x0090, 0x00a8,
    0x00c0, 0x00d8, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x00f0, 0x0108, 0x0120, 0x0138, 0x0150, 0x0168, 0x0180, 0x0198,
    0x01b0, 0x01c8, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x00f2};
const uint8_t HuffDecoderCommon::table22_1_emit_[60] = {
    0x3c, 0x32, 0x30, 0x3c, 0x32, 0x31, 0x3c, 0x32, 0x32, 0x3c, 0x32, 0x61,
    0x3c, 0x32, 0x63, 0x3c, 0x32, 0x65, 0x3c, 0x32, 0x69, 0x3c, 0x32, 0x6f,
    0x3c, 0x32, 0x73, 0x3c, 0x32, 0x74, 0x3c, 0x61, 0x30, 0x3c, 0x61, 0x31,
    0x3c, 0x61, 0x32, 0x3c, 0x61, 0x61, 0x3c, 0x61, 0x63, 0x3c, 0x61, 0x65,
    0x3c, 0x61, 0x69, 0x3c, 0x61, 0x6f, 0x3c, 0x61, 0x73, 0x3c, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table22_2_emit_[60] = {
    0x3c, 0x63, 0x30, 0x3c, 0x63, 0x31, 0x3c, 0x63, 0x32, 0x3c, 0x63, 0x61,
    0x3c, 0x63, 0x63, 0x3c, 0x63, 0x65, 0x3c, 0x63, 0x69, 0x3c, 0x63, 0x6f,
    0x3c, 0x63, 0x73, 0x3c, 0x63, 0x74, 0x3c, 0x65, 0x30, 0x3c, 0x65, 0x31,
    0x3c, 0x65, 0x32, 0x3c, 0x65, 0x61, 0x3c, 0x65, 0x63, 0x3c, 0x65, 0x65,
    0x3c, 0x65, 0x69, 0x3c, 0x65, 0x6f, 0x3c, 0x65, 0x73, 0x3c, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table22_3_emit_[60] = {
    0x3c, 0x69, 0x30, 0x3c, 0x69, 0x31, 0x3c, 0x69, 0x32, 0x3c, 0x69, 0x61,
    0x3c, 0x69, 0x63, 0x3c, 0x69, 0x65, 0x3c, 0x69, 0x69, 0x3c, 0x69, 0x6f,
    0x3c, 0x69, 0x73, 0x3c, 0x69, 0x74, 0x3c, 0x6f, 0x30, 0x3c, 0x6f, 0x31,
    0x3c, 0x6f, 0x32, 0x3c, 0x6f, 0x61, 0x3c, 0x6f, 0x63, 0x3c, 0x6f, 0x65,
    0x3c, 0x6f, 0x69, 0x3c, 0x6f, 0x6f, 0x3c, 0x6f, 0x73, 0x3c, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table22_4_emit_[60] = {
    0x3c, 0x73, 0x30, 0x3c, 0x73, 0x31, 0x3c, 0x73, 0x32, 0x3c, 0x73, 0x61,
    0x3c, 0x73, 0x63, 0x3c, 0x73, 0x65, 0x3c, 0x73, 0x69, 0x3c, 0x73, 0x6f,
    0x3c, 0x73, 0x73, 0x3c, 0x73, 0x74, 0x3c, 0x74, 0x30, 0x3c, 0x74, 0x31,
    0x3c, 0x74, 0x32, 0x3c, 0x74, 0x61, 0x3c, 0x74, 0x63, 0x3c, 0x74, 0x65,
    0x3c, 0x74, 0x69, 0x3c, 0x74, 0x6f, 0x3c, 0x74, 0x73, 0x3c, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table22_5_emit_[8] = {0x3c, 0x20, 0x3c, 0x25,
                                                       0x3c, 0x2d, 0x3c, 0x2e};
const uint16_t HuffDecoderCommon::table22_5_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032};
const uint8_t HuffDecoderCommon::table22_6_emit_[8] = {0x3c, 0x2f, 0x3c, 0x33,
                                                       0x3c, 0x34, 0x3c, 0x35};
const uint8_t HuffDecoderCommon::table22_7_emit_[8] = {0x3c, 0x36, 0x3c, 0x37,
                                                       0x3c, 0x38, 0x3c, 0x39};
const uint8_t HuffDecoderCommon::table22_8_emit_[8] = {0x3c, 0x3d, 0x3c, 0x41,
                                                       0x3c, 0x5f, 0x3c, 0x62};
const uint8_t HuffDecoderCommon::table22_9_emit_[8] = {0x3c, 0x64, 0x3c, 0x66,
                                                       0x3c, 0x67, 0x3c, 0x68};
const uint8_t HuffDecoderCommon::table22_10_emit_[8] = {0x3c, 0x6c, 0x3c, 0x6d,
                                                        0x3c, 0x6e, 0x3c, 0x70};
const uint8_t HuffDecoderCommon::table22_11_emit_[12] = {
    0x3c, 0x72, 0x3c, 0x75, 0x3c, 0x3a, 0x3c, 0x42, 0x3c, 0x43, 0x3c, 0x44};
const uint16_t HuffDecoderCommon::table22_11_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0042,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0052};
const uint8_t HuffDecoderCommon::table22_12_emit_[16] = {
    0x3c, 0x45, 0x3c, 0x46, 0x3c, 0x47, 0x3c, 0x48,
    0x3c, 0x49, 0x3c, 0x4a, 0x3c, 0x4b, 0x3c, 0x4c};
const uint16_t HuffDecoderCommon::table22_12_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0042,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0062,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0072};
const uint8_t HuffDecoderCommon::table22_13_emit_[16] = {
    0x3c, 0x4d, 0x3c, 0x4e, 0x3c, 0x4f, 0x3c, 0x50,
    0x3c, 0x51, 0x3c, 0x52, 0x3c, 0x53, 0x3c, 0x54};
const uint8_t HuffDecoderCommon::table22_14_emit_[16] = {
    0x3c, 0x55, 0x3c, 0x56, 0x3c, 0x57, 0x3c, 0x59,
    0x3c, 0x6a, 0x3c, 0x6b, 0x3c, 0x71, 0x3c, 0x76};
const uint8_t HuffDecoderCommon::table22_15_emit_[30] = {
    0x3c, 0x77, 0x3c, 0x78, 0x3c, 0x79, 0x3c, 0x7a, 0x3c, 0x26,
    0x3c, 0x2a, 0x3c, 0x2c, 0x3c, 0x3b, 0x3c, 0x58, 0x3c, 0x5a,
    0x3c, 0x21, 0x3c, 0x22, 0x3c, 0x28, 0x3c, 0x29, 0x3c, 0x3f};
const uint16_t HuffDecoderCommon::table22_15_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table22_16_emit_[60] = {
    0x60, 0x30, 0x30, 0x60, 0x30, 0x31, 0x60, 0x30, 0x32, 0x60, 0x30, 0x61,
    0x60, 0x30, 0x63, 0x60, 0x30, 0x65, 0x60, 0x30, 0x69, 0x60, 0x30, 0x6f,
    0x60, 0x30, 0x73, 0x60, 0x30, 0x74, 0x60, 0x31, 0x30, 0x60, 0x31, 0x31,
    0x60, 0x31, 0x32, 0x60, 0x31, 0x61, 0x60, 0x31, 0x63, 0x60, 0x31, 0x65,
    0x60, 0x31, 0x69, 0x60, 0x31, 0x6f, 0x60, 0x31, 0x73, 0x60, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table22_17_emit_[60] = {
    0x60, 0x32, 0x30, 0x60, 0x32, 0x31, 0x60, 0x32, 0x32, 0x60, 0x32, 0x61,
    0x60, 0x32, 0x63, 0x60, 0x32, 0x65, 0x60, 0x32, 0x69, 0x60, 0x32, 0x6f,
    0x60, 0x32, 0x73, 0x60, 0x32, 0x74, 0x60, 0x61, 0x30, 0x60, 0x61, 0x31,
    0x60, 0x61, 0x32, 0x60, 0x61, 0x61, 0x60, 0x61, 0x63, 0x60, 0x61, 0x65,
    0x60, 0x61, 0x69, 0x60, 0x61, 0x6f, 0x60, 0x61, 0x73, 0x60, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table22_18_emit_[60] = {
    0x60, 0x63, 0x30, 0x60, 0x63, 0x31, 0x60, 0x63, 0x32, 0x60, 0x63, 0x61,
    0x60, 0x63, 0x63, 0x60, 0x63, 0x65, 0x60, 0x63, 0x69, 0x60, 0x63, 0x6f,
    0x60, 0x63, 0x73, 0x60, 0x63, 0x74, 0x60, 0x65, 0x30, 0x60, 0x65, 0x31,
    0x60, 0x65, 0x32, 0x60, 0x65, 0x61, 0x60, 0x65, 0x63, 0x60, 0x65, 0x65,
    0x60, 0x65, 0x69, 0x60, 0x65, 0x6f, 0x60, 0x65, 0x73, 0x60, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table22_19_emit_[60] = {
    0x60, 0x69, 0x30, 0x60, 0x69, 0x31, 0x60, 0x69, 0x32, 0x60, 0x69, 0x61,
    0x60, 0x69, 0x63, 0x60, 0x69, 0x65, 0x60, 0x69, 0x69, 0x60, 0x69, 0x6f,
    0x60, 0x69, 0x73, 0x60, 0x69, 0x74, 0x60, 0x6f, 0x30, 0x60, 0x6f, 0x31,
    0x60, 0x6f, 0x32, 0x60, 0x6f, 0x61, 0x60, 0x6f, 0x63, 0x60, 0x6f, 0x65,
    0x60, 0x6f, 0x69, 0x60, 0x6f, 0x6f, 0x60, 0x6f, 0x73, 0x60, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table22_20_emit_[60] = {
    0x60, 0x73, 0x30, 0x60, 0x73, 0x31, 0x60, 0x73, 0x32, 0x60, 0x73, 0x61,
    0x60, 0x73, 0x63, 0x60, 0x73, 0x65, 0x60, 0x73, 0x69, 0x60, 0x73, 0x6f,
    0x60, 0x73, 0x73, 0x60, 0x73, 0x74, 0x60, 0x74, 0x30, 0x60, 0x74, 0x31,
    0x60, 0x74, 0x32, 0x60, 0x74, 0x61, 0x60, 0x74, 0x63, 0x60, 0x74, 0x65,
    0x60, 0x74, 0x69, 0x60, 0x74, 0x6f, 0x60, 0x74, 0x73, 0x60, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table22_21_emit_[8] = {0x60, 0x20, 0x60, 0x25,
                                                        0x60, 0x2d, 0x60, 0x2e};
const uint8_t HuffDecoderCommon::table22_22_emit_[8] = {0x60, 0x2f, 0x60, 0x33,
                                                        0x60, 0x34, 0x60, 0x35};
const uint8_t HuffDecoderCommon::table22_23_emit_[8] = {0x60, 0x36, 0x60, 0x37,
                                                        0x60, 0x38, 0x60, 0x39};
const uint8_t HuffDecoderCommon::table22_24_emit_[8] = {0x60, 0x3d, 0x60, 0x41,
                                                        0x60, 0x5f, 0x60, 0x62};
const uint8_t HuffDecoderCommon::table22_25_emit_[8] = {0x60, 0x64, 0x60, 0x66,
                                                        0x60, 0x67, 0x60, 0x68};
const uint8_t HuffDecoderCommon::table22_26_emit_[8] = {0x60, 0x6c, 0x60, 0x6d,
                                                        0x60, 0x6e, 0x60, 0x70};
const uint8_t HuffDecoderCommon::table22_27_emit_[12] = {
    0x60, 0x72, 0x60, 0x75, 0x60, 0x3a, 0x60, 0x42, 0x60, 0x43, 0x60, 0x44};
const uint8_t HuffDecoderCommon::table22_28_emit_[16] = {
    0x60, 0x45, 0x60, 0x46, 0x60, 0x47, 0x60, 0x48,
    0x60, 0x49, 0x60, 0x4a, 0x60, 0x4b, 0x60, 0x4c};
const uint8_t HuffDecoderCommon::table22_29_emit_[16] = {
    0x60, 0x4d, 0x60, 0x4e, 0x60, 0x4f, 0x60, 0x50,
    0x60, 0x51, 0x60, 0x52, 0x60, 0x53, 0x60, 0x54};
const uint8_t HuffDecoderCommon::table22_30_emit_[16] = {
    0x60, 0x55, 0x60, 0x56, 0x60, 0x57, 0x60, 0x59,
    0x60, 0x6a, 0x60, 0x6b, 0x60, 0x71, 0x60, 0x76};
const uint8_t HuffDecoderCommon::table22_31_emit_[30] = {
    0x60, 0x77, 0x60, 0x78, 0x60, 0x79, 0x60, 0x7a, 0x60, 0x26,
    0x60, 0x2a, 0x60, 0x2c, 0x60, 0x3b, 0x60, 0x58, 0x60, 0x5a,
    0x60, 0x21, 0x60, 0x22, 0x60, 0x28, 0x60, 0x29, 0x60, 0x3f};
const uint8_t HuffDecoderCommon::table22_32_emit_[60] = {
    0x7b, 0x30, 0x30, 0x7b, 0x30, 0x31, 0x7b, 0x30, 0x32, 0x7b, 0x30, 0x61,
    0x7b, 0x30, 0x63, 0x7b, 0x30, 0x65, 0x7b, 0x30, 0x69, 0x7b, 0x30, 0x6f,
    0x7b, 0x30, 0x73, 0x7b, 0x30, 0x74, 0x7b, 0x31, 0x30, 0x7b, 0x31, 0x31,
    0x7b, 0x31, 0x32, 0x7b, 0x31, 0x61, 0x7b, 0x31, 0x63, 0x7b, 0x31, 0x65,
    0x7b, 0x31, 0x69, 0x7b, 0x31, 0x6f, 0x7b, 0x31, 0x73, 0x7b, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table22_33_emit_[60] = {
    0x7b, 0x32, 0x30, 0x7b, 0x32, 0x31, 0x7b, 0x32, 0x32, 0x7b, 0x32, 0x61,
    0x7b, 0x32, 0x63, 0x7b, 0x32, 0x65, 0x7b, 0x32, 0x69, 0x7b, 0x32, 0x6f,
    0x7b, 0x32, 0x73, 0x7b, 0x32, 0x74, 0x7b, 0x61, 0x30, 0x7b, 0x61, 0x31,
    0x7b, 0x61, 0x32, 0x7b, 0x61, 0x61, 0x7b, 0x61, 0x63, 0x7b, 0x61, 0x65,
    0x7b, 0x61, 0x69, 0x7b, 0x61, 0x6f, 0x7b, 0x61, 0x73, 0x7b, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table22_34_emit_[60] = {
    0x7b, 0x63, 0x30, 0x7b, 0x63, 0x31, 0x7b, 0x63, 0x32, 0x7b, 0x63, 0x61,
    0x7b, 0x63, 0x63, 0x7b, 0x63, 0x65, 0x7b, 0x63, 0x69, 0x7b, 0x63, 0x6f,
    0x7b, 0x63, 0x73, 0x7b, 0x63, 0x74, 0x7b, 0x65, 0x30, 0x7b, 0x65, 0x31,
    0x7b, 0x65, 0x32, 0x7b, 0x65, 0x61, 0x7b, 0x65, 0x63, 0x7b, 0x65, 0x65,
    0x7b, 0x65, 0x69, 0x7b, 0x65, 0x6f, 0x7b, 0x65, 0x73, 0x7b, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table22_35_emit_[60] = {
    0x7b, 0x69, 0x30, 0x7b, 0x69, 0x31, 0x7b, 0x69, 0x32, 0x7b, 0x69, 0x61,
    0x7b, 0x69, 0x63, 0x7b, 0x69, 0x65, 0x7b, 0x69, 0x69, 0x7b, 0x69, 0x6f,
    0x7b, 0x69, 0x73, 0x7b, 0x69, 0x74, 0x7b, 0x6f, 0x30, 0x7b, 0x6f, 0x31,
    0x7b, 0x6f, 0x32, 0x7b, 0x6f, 0x61, 0x7b, 0x6f, 0x63, 0x7b, 0x6f, 0x65,
    0x7b, 0x6f, 0x69, 0x7b, 0x6f, 0x6f, 0x7b, 0x6f, 0x73, 0x7b, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table22_36_emit_[60] = {
    0x7b, 0x73, 0x30, 0x7b, 0x73, 0x31, 0x7b, 0x73, 0x32, 0x7b, 0x73, 0x61,
    0x7b, 0x73, 0x63, 0x7b, 0x73, 0x65, 0x7b, 0x73, 0x69, 0x7b, 0x73, 0x6f,
    0x7b, 0x73, 0x73, 0x7b, 0x73, 0x74, 0x7b, 0x74, 0x30, 0x7b, 0x74, 0x31,
    0x7b, 0x74, 0x32, 0x7b, 0x74, 0x61, 0x7b, 0x74, 0x63, 0x7b, 0x74, 0x65,
    0x7b, 0x74, 0x69, 0x7b, 0x74, 0x6f, 0x7b, 0x74, 0x73, 0x7b, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table22_37_emit_[8] = {0x7b, 0x20, 0x7b, 0x25,
                                                        0x7b, 0x2d, 0x7b, 0x2e};
const uint8_t HuffDecoderCommon::table22_38_emit_[8] = {0x7b, 0x2f, 0x7b, 0x33,
                                                        0x7b, 0x34, 0x7b, 0x35};
const uint8_t HuffDecoderCommon::table22_39_emit_[8] = {0x7b, 0x36, 0x7b, 0x37,
                                                        0x7b, 0x38, 0x7b, 0x39};
const uint8_t HuffDecoderCommon::table22_40_emit_[8] = {0x7b, 0x3d, 0x7b, 0x41,
                                                        0x7b, 0x5f, 0x7b, 0x62};
const uint8_t HuffDecoderCommon::table22_41_emit_[8] = {0x7b, 0x64, 0x7b, 0x66,
                                                        0x7b, 0x67, 0x7b, 0x68};
const uint8_t HuffDecoderCommon::table22_42_emit_[8] = {0x7b, 0x6c, 0x7b, 0x6d,
                                                        0x7b, 0x6e, 0x7b, 0x70};
const uint8_t HuffDecoderCommon::table22_43_emit_[12] = {
    0x7b, 0x72, 0x7b, 0x75, 0x7b, 0x3a, 0x7b, 0x42, 0x7b, 0x43, 0x7b, 0x44};
const uint8_t HuffDecoderCommon::table22_44_emit_[16] = {
    0x7b, 0x45, 0x7b, 0x46, 0x7b, 0x47, 0x7b, 0x48,
    0x7b, 0x49, 0x7b, 0x4a, 0x7b, 0x4b, 0x7b, 0x4c};
const uint8_t HuffDecoderCommon::table22_45_emit_[16] = {
    0x7b, 0x4d, 0x7b, 0x4e, 0x7b, 0x4f, 0x7b, 0x50,
    0x7b, 0x51, 0x7b, 0x52, 0x7b, 0x53, 0x7b, 0x54};
const uint8_t HuffDecoderCommon::table22_46_emit_[16] = {
    0x7b, 0x55, 0x7b, 0x56, 0x7b, 0x57, 0x7b, 0x59,
    0x7b, 0x6a, 0x7b, 0x6b, 0x7b, 0x71, 0x7b, 0x76};
const uint8_t HuffDecoderCommon::table22_47_emit_[30] = {
    0x7b, 0x77, 0x7b, 0x78, 0x7b, 0x79, 0x7b, 0x7a, 0x7b, 0x26,
    0x7b, 0x2a, 0x7b, 0x2c, 0x7b, 0x3b, 0x7b, 0x58, 0x7b, 0x5a,
    0x7b, 0x21, 0x7b, 0x22, 0x7b, 0x28, 0x7b, 0x29, 0x7b, 0x3f};
const uint8_t HuffDecoderCommon::table22_48_emit_[72] = {
    0x5c, 0x30, 0x5c, 0x31, 0x5c, 0x32, 0x5c, 0x61, 0x5c, 0x63, 0x5c, 0x65,
    0x5c, 0x69, 0x5c, 0x6f, 0x5c, 0x73, 0x5c, 0x74, 0x5c, 0x20, 0x5c, 0x25,
    0x5c, 0x2d, 0x5c, 0x2e, 0x5c, 0x2f, 0x5c, 0x33, 0x5c, 0x34, 0x5c, 0x35,
    0x5c, 0x36, 0x5c, 0x37, 0x5c, 0x38, 0x5c, 0x39, 0x5c, 0x3d, 0x5c, 0x41,
    0x5c, 0x5f, 0x5c, 0x62, 0x5c, 0x64, 0x5c, 0x66, 0x5c, 0x67, 0x5c, 0x68,
    0x5c, 0x6c, 0x5c, 0x6d, 0x5c, 0x6e, 0x5c, 0x70, 0x5c, 0x72, 0x5c, 0x75};
const uint16_t HuffDecoderCommon::table22_48_ops_[64] = {
    0x0001, 0x0002, 0x0001, 0x0012, 0x0001, 0x0022, 0x0001, 0x0032,
    0x0001, 0x0042, 0x0001, 0x0052, 0x0001, 0x0062, 0x0001, 0x0072,
    0x0001, 0x0082, 0x0001, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2,
    0x00e2, 0x00f2, 0x0102, 0x0112, 0x0122, 0x0132, 0x0142, 0x0152,
    0x0162, 0x0172, 0x0182, 0x0192, 0x01a2, 0x01b2, 0x01c2, 0x01d2,
    0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222, 0x0232, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table22_49_emit_[72] = {
    0xc3, 0x30, 0xc3, 0x31, 0xc3, 0x32, 0xc3, 0x61, 0xc3, 0x63, 0xc3, 0x65,
    0xc3, 0x69, 0xc3, 0x6f, 0xc3, 0x73, 0xc3, 0x74, 0xc3, 0x20, 0xc3, 0x25,
    0xc3, 0x2d, 0xc3, 0x2e, 0xc3, 0x2f, 0xc3, 0x33, 0xc3, 0x34, 0xc3, 0x35,
    0xc3, 0x36, 0xc3, 0x37, 0xc3, 0x38, 0xc3, 0x39, 0xc3, 0x3d, 0xc3, 0x41,
    0xc3, 0x5f, 0xc3, 0x62, 0xc3, 0x64, 0xc3, 0x66, 0xc3, 0x67, 0xc3, 0x68,
    0xc3, 0x6c, 0xc3, 0x6d, 0xc3, 0x6e, 0xc3, 0x70, 0xc3, 0x72, 0xc3, 0x75};
const uint8_t HuffDecoderCommon::table22_50_emit_[72] = {
    0xd0, 0x30, 0xd0, 0x31, 0xd0, 0x32, 0xd0, 0x61, 0xd0, 0x63, 0xd0, 0x65,
    0xd0, 0x69, 0xd0, 0x6f, 0xd0, 0x73, 0xd0, 0x74, 0xd0, 0x20, 0xd0, 0x25,
    0xd0, 0x2d, 0xd0, 0x2e, 0xd0, 0x2f, 0xd0, 0x33, 0xd0, 0x34, 0xd0, 0x35,
    0xd0, 0x36, 0xd0, 0x37, 0xd0, 0x38, 0xd0, 0x39, 0xd0, 0x3d, 0xd0, 0x41,
    0xd0, 0x5f, 0xd0, 0x62, 0xd0, 0x64, 0xd0, 0x66, 0xd0, 0x67, 0xd0, 0x68,
    0xd0, 0x6c, 0xd0, 0x6d, 0xd0, 0x6e, 0xd0, 0x70, 0xd0, 0x72, 0xd0, 0x75};
const uint8_t HuffDecoderCommon::table22_51_emit_[40] = {
    0x80, 0x30, 0x80, 0x31, 0x80, 0x32, 0x80, 0x61, 0x80, 0x63,
    0x80, 0x65, 0x80, 0x69, 0x80, 0x6f, 0x80, 0x73, 0x80, 0x74,
    0x82, 0x30, 0x82, 0x31, 0x82, 0x32, 0x82, 0x61, 0x82, 0x63,
    0x82, 0x65, 0x82, 0x69, 0x82, 0x6f, 0x82, 0x73, 0x82, 0x74};
const uint16_t HuffDecoderCommon::table22_51_ops_[64] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102, 0x0112,
    0x0122, 0x0132, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x00a3};
const uint8_t HuffDecoderCommon::table22_52_emit_[40] = {
    0x83, 0x30, 0x83, 0x31, 0x83, 0x32, 0x83, 0x61, 0x83, 0x63,
    0x83, 0x65, 0x83, 0x69, 0x83, 0x6f, 0x83, 0x73, 0x83, 0x74,
    0xa2, 0x30, 0xa2, 0x31, 0xa2, 0x32, 0xa2, 0x61, 0xa2, 0x63,
    0xa2, 0x65, 0xa2, 0x69, 0xa2, 0x6f, 0xa2, 0x73, 0xa2, 0x74};
const uint8_t HuffDecoderCommon::table22_53_emit_[40] = {
    0xb8, 0x30, 0xb8, 0x31, 0xb8, 0x32, 0xb8, 0x61, 0xb8, 0x63,
    0xb8, 0x65, 0xb8, 0x69, 0xb8, 0x6f, 0xb8, 0x73, 0xb8, 0x74,
    0xc2, 0x30, 0xc2, 0x31, 0xc2, 0x32, 0xc2, 0x61, 0xc2, 0x63,
    0xc2, 0x65, 0xc2, 0x69, 0xc2, 0x6f, 0xc2, 0x73, 0xc2, 0x74};
const uint8_t HuffDecoderCommon::table22_54_emit_[40] = {
    0xe0, 0x30, 0xe0, 0x31, 0xe0, 0x32, 0xe0, 0x61, 0xe0, 0x63,
    0xe0, 0x65, 0xe0, 0x69, 0xe0, 0x6f, 0xe0, 0x73, 0xe0, 0x74,
    0xe2, 0x30, 0xe2, 0x31, 0xe2, 0x32, 0xe2, 0x61, 0xe2, 0x63,
    0xe2, 0x65, 0xe2, 0x69, 0xe2, 0x6f, 0xe2, 0x73, 0xe2, 0x74};
const uint8_t HuffDecoderCommon::table22_55_emit_[4] = {0x99, 0xa1, 0xa7, 0xac};
const uint16_t HuffDecoderCommon::table22_55_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0013,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x001b};
const uint8_t HuffDecoderCommon::table22_56_emit_[4] = {0xb0, 0xb1, 0xb3, 0xd1};
const uint8_t HuffDecoderCommon::table22_57_emit_[4] = {0xd8, 0xd9, 0xe3, 0xe5};
const uint8_t HuffDecoderCommon::table22_58_emit_[7] = {0xe6, 0x81, 0x84, 0x85,
                                                        0x86, 0x88, 0x92};
const uint16_t HuffDecoderCommon::table22_58_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0013,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x001b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0023,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x002b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0033};
const uint8_t HuffDecoderCommon::table22_59_emit_[8] = {0x9a, 0x9c, 0xa0, 0xa3,
                                                        0xa4, 0xa9, 0xaa, 0xad};
const uint16_t HuffDecoderCommon::table22_59_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0013,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x001b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0023,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x002b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0033,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x003b};
const uint8_t HuffDecoderCommon::table22_60_emit_[8] = {0xb2, 0xb5, 0xb9, 0xba,
                                                        0xbb, 0xbd, 0xbe, 0xc4};
const uint8_t HuffDecoderCommon::table22_61_emit_[12] = {
    0xc6, 0xe4, 0xe8, 0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f};
const uint16_t HuffDecoderCommon::table22_61_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0013,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x001b,
    0x0001, 0x0001, 0x0001, 0x0023, 0x0001, 0x0001, 0x0001, 0x002b,
    0x0001, 0x0001, 0x0001, 0x0033, 0x0001, 0x0001, 0x0001, 0x003b,
    0x0001, 0x0001, 0x0001, 0x0043, 0x0001, 0x0001, 0x0001, 0x004b,
    0x0001, 0x0001, 0x0001, 0x0053, 0x0001, 0x0001, 0x0001, 0x005b};
const uint8_t HuffDecoderCommon::table22_62_emit_[16] = {
    0x93, 0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e,
    0xa5, 0xa6, 0xa8, 0xae, 0xaf, 0xb4, 0xb6, 0xb7};
const uint16_t HuffDecoderCommon::table22_62_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0003, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0013, 0x0001, 0x0001, 0x0001, 0x001b,
    0x0001, 0x0001, 0x0001, 0x0023, 0x0001, 0x0001, 0x0001, 0x002b,
    0x0001, 0x0001, 0x0001, 0x0033, 0x0001, 0x0001, 0x0001, 0x003b,
    0x0001, 0x0001, 0x0001, 0x0043, 0x0001, 0x0001, 0x0001, 0x004b,
    0x0001, 0x0001, 0x0001, 0x0053, 0x0001, 0x0001, 0x0001, 0x005b,
    0x0001, 0x0001, 0x0001, 0x0063, 0x0001, 0x0001, 0x0001, 0x006b,
    0x0001, 0x0001, 0x0001, 0x0073, 0x0001, 0x0001, 0x0001, 0x007b};
const uint8_t HuffDecoderCommon::table22_63_emit_[21] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f,
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb};
const uint16_t HuffDecoderCommon::table22_63_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0003, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0013, 0x0001, 0x0001, 0x0001, 0x001b,
    0x0001, 0x0001, 0x0001, 0x0023, 0x0001, 0x002b, 0x0001, 0x0033,
    0x0001, 0x003b, 0x0001, 0x0043, 0x0001, 0x004b, 0x0001, 0x0053,
    0x0001, 0x005b, 0x0001, 0x0063, 0x0001, 0x006b, 0x0001, 0x0073,
    0x0001, 0x007b, 0x0001, 0x0083, 0x008b, 0x0093, 0x009b, 0x00a3,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0004};
const uint8_t* const HuffDecoderCommon::table22_emit_[64] = {
    table22_0_emit_,  table22_1_emit_,  table22_2_emit_,  table22_3_emit_,
    table22_4_emit_,  table22_5_emit_,  table22_6_emit_,  table22_7_emit_,
    table22_8_emit_,  table22_9_emit_,  table22_10_emit_, table22_11_emit_,
    table22_12_emit_, table22_13_emit_, table22_14_emit_, table22_15_emit_,
    table22_16_emit_, table22_17_emit_, table22_18_emit_, table22_19_emit_,
    table22_20_emit_, table22_21_emit_, table22_22_emit_, table22_23_emit_,
    table22_24_emit_, table22_25_emit_, table22_26_emit_, table22_27_emit_,
    table22_28_emit_, table22_29_emit_, table22_30_emit_, table22_31_emit_,
    table22_32_emit_, table22_33_emit_, table22_34_emit_, table22_35_emit_,
    table22_36_emit_, table22_37_emit_, table22_38_emit_, table22_39_emit_,
    table22_40_emit_, table22_41_emit_, table22_42_emit_, table22_43_emit_,
    table22_44_emit_, table22_45_emit_, table22_46_emit_, table22_47_emit_,
    table22_48_emit_, table22_49_emit_, table22_50_emit_, table22_51_emit_,
    table22_52_emit_, table22_53_emit_, table22_54_emit_, table22_55_emit_,
    table22_56_emit_, table22_57_emit_, table22_58_emit_, table22_59_emit_,
    table22_60_emit_, table22_61_emit_, table22_62_emit_, table22_63_emit_,
};
const uint16_t* const HuffDecoderCommon::table22_ops_[64] = {
    table22_0_ops_,  table22_0_ops_,  table22_0_ops_,  table22_0_ops_,
    table22_0_ops_,  table22_5_ops_,  table22_5_ops_,  table22_5_ops_,
    table22_5_ops_,  table22_5_ops_,  table22_5_ops_,  table22_11_ops_,
    table22_12_ops_, table22_12_ops_, table22_12_ops_, table22_15_ops_,
    table22_0_ops_,  table22_0_ops_,  table22_0_ops_,  table22_0_ops_,
    table22_0_ops_,  table22_5_ops_,  table22_5_ops_,  table22_5_ops_,
    table22_5_ops_,  table22_5_ops_,  table22_5_ops_,  table22_11_ops_,
    table22_12_ops_, table22_12_ops_, table22_12_ops_, table22_15_ops_,
    table22_0_ops_,  table22_0_ops_,  table22_0_ops_,  table22_0_ops_,
    table22_0_ops_,  table22_5_ops_,  table22_5_ops_,  table22_5_ops_,
    table22_5_ops_,  table22_5_ops_,  table22_5_ops_,  table22_11_ops_,
    table22_12_ops_, table22_12_ops_, table22_12_ops_, table22_15_ops_,
    table22_48_ops_, table22_48_ops_, table22_48_ops_, table22_51_ops_,
    table22_51_ops_, table22_51_ops_, table22_51_ops_, table22_55_ops_,
    table22_55_ops_, table22_55_ops_, table22_58_ops_, table22_59_ops_,
    table22_59_ops_, table22_61_ops_, table22_62_ops_, table22_63_ops_,
};
const uint8_t HuffDecoderCommon::table23_0_emit_[216] = {
    0x3c, 0x30, 0x30, 0x3c, 0x30, 0x31, 0x3c, 0x30, 0x32, 0x3c, 0x30, 0x61,
    0x3c, 0x30, 0x63, 0x3c, 0x30, 0x65, 0x3c, 0x30, 0x69, 0x3c, 0x30, 0x6f,
    0x3c, 0x30, 0x73, 0x3c, 0x30, 0x74, 0x3c, 0x30, 0x20, 0x3c, 0x30, 0x25,
    0x3c, 0x30, 0x2d, 0x3c, 0x30, 0x2e, 0x3c, 0x30, 0x2f, 0x3c, 0x30, 0x33,
    0x3c, 0x30, 0x34, 0x3c, 0x30, 0x35, 0x3c, 0x30, 0x36, 0x3c, 0x30, 0x37,
    0x3c, 0x30, 0x38, 0x3c, 0x30, 0x39, 0x3c, 0x30, 0x3d, 0x3c, 0x30, 0x41,
    0x3c, 0x30, 0x5f, 0x3c, 0x30, 0x62, 0x3c, 0x30, 0x64, 0x3c, 0x30, 0x66,
    0x3c, 0x30, 0x67, 0x3c, 0x30, 0x68, 0x3c, 0x30, 0x6c, 0x3c, 0x30, 0x6d,
    0x3c, 0x30, 0x6e, 0x3c, 0x30, 0x70, 0x3c, 0x30, 0x72, 0x3c, 0x30, 0x75,
    0x3c, 0x31, 0x30, 0x3c, 0x31, 0x31, 0x3c, 0x31, 0x32, 0x3c, 0x31, 0x61,
    0x3c, 0x31, 0x63, 0x3c, 0x31, 0x65, 0x3c, 0x31, 0x69, 0x3c, 0x31, 0x6f,
    0x3c, 0x31, 0x73, 0x3c, 0x31, 0x74, 0x3c, 0x31, 0x20, 0x3c, 0x31, 0x25,
    0x3c, 0x31, 0x2d, 0x3c, 0x31, 0x2e, 0x3c, 0x31, 0x2f, 0x3c, 0x31, 0x33,
    0x3c, 0x31, 0x34, 0x3c, 0x31, 0x35, 0x3c, 0x31, 0x36, 0x3c, 0x31, 0x37,
    0x3c, 0x31, 0x38, 0x3c, 0x31, 0x39, 0x3c, 0x31, 0x3d, 0x3c, 0x31, 0x41,
    0x3c, 0x31, 0x5f, 0x3c, 0x31, 0x62, 0x3c, 0x31, 0x64, 0x3c, 0x31, 0x66,
    0x3c, 0x31, 0x67, 0x3c, 0x31, 0x68, 0x3c, 0x31, 0x6c, 0x3c, 0x31, 0x6d,
    0x3c, 0x31, 0x6e, 0x3c, 0x31, 0x70, 0x3c, 0x31, 0x72, 0x3c, 0x31, 0x75};
const uint16_t HuffDecoderCommon::table23_0_ops_[128] = {
    0x0000, 0x0001, 0x0000, 0x0019, 0x0000, 0x0031, 0x0000, 0x0049, 0x0000,
    0x0061, 0x0000, 0x0079, 0x0000, 0x0091, 0x0000, 0x00a9, 0x0000, 0x00c1,
    0x0000, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169, 0x0181,
    0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259,
    0x0271, 0x0289, 0x02a1, 0x02b9, 0x02d1, 0x02e9, 0x0301, 0x0319, 0x0331,
    0x0349, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0002, 0x0000, 0x0361, 0x0000, 0x0379, 0x0000, 0x0391, 0x0000, 0x03a9,
    0x0000, 0x03c1, 0x0000, 0x03d9, 0x0000, 0x03f1, 0x0000, 0x0409, 0x0000,
    0x0421, 0x0000, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9,
    0x04e1, 0x04f9, 0x0511, 0x0529, 0x0541, 0x0559, 0x0571, 0x0589, 0x05a1,
    0x05b9, 0x05d1, 0x05e9, 0x0601, 0x0619, 0x0631, 0x0649, 0x0661, 0x0679,
    0x0691, 0x06a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0362};
const uint8_t HuffDecoderCommon::table23_1_emit_[216] = {
    0x3c, 0x32, 0x30, 0x3c, 0x32, 0x31, 0x3c, 0x32, 0x32, 0x3c, 0x32, 0x61,
    0x3c, 0x32, 0x63, 0x3c, 0x32, 0x65, 0x3c, 0x32, 0x69, 0x3c, 0x32, 0x6f,
    0x3c, 0x32, 0x73, 0x3c, 0x32, 0x74, 0x3c, 0x32, 0x20, 0x3c, 0x32, 0x25,
    0x3c, 0x32, 0x2d, 0x3c, 0x32, 0x2e, 0x3c, 0x32, 0x2f, 0x3c, 0x32, 0x33,
    0x3c, 0x32, 0x34, 0x3c, 0x32, 0x35, 0x3c, 0x32, 0x36, 0x3c, 0x32, 0x37,
    0x3c, 0x32, 0x38, 0x3c, 0x32, 0x39, 0x3c, 0x32, 0x3d, 0x3c, 0x32, 0x41,
    0x3c, 0x32, 0x5f, 0x3c, 0x32, 0x62, 0x3c, 0x32, 0x64, 0x3c, 0x32, 0x66,
    0x3c, 0x32, 0x67, 0x3c, 0x32, 0x68, 0x3c, 0x32, 0x6c, 0x3c, 0x32, 0x6d,
    0x3c, 0x32, 0x6e, 0x3c, 0x32, 0x70, 0x3c, 0x32, 0x72, 0x3c, 0x32, 0x75,
    0x3c, 0x61, 0x30, 0x3c, 0x61, 0x31, 0x3c, 0x61, 0x32, 0x3c, 0x61, 0x61,
    0x3c, 0x61, 0x63, 0x3c, 0x61, 0x65, 0x3c, 0x61, 0x69, 0x3c, 0x61, 0x6f,
    0x3c, 0x61, 0x73, 0x3c, 0x61, 0x74, 0x3c, 0x61, 0x20, 0x3c, 0x61, 0x25,
    0x3c, 0x61, 0x2d, 0x3c, 0x61, 0x2e, 0x3c, 0x61, 0x2f, 0x3c, 0x61, 0x33,
    0x3c, 0x61, 0x34, 0x3c, 0x61, 0x35, 0x3c, 0x61, 0x36, 0x3c, 0x61, 0x37,
    0x3c, 0x61, 0x38, 0x3c, 0x61, 0x39, 0x3c, 0x61, 0x3d, 0x3c, 0x61, 0x41,
    0x3c, 0x61, 0x5f, 0x3c, 0x61, 0x62, 0x3c, 0x61, 0x64, 0x3c, 0x61, 0x66,
    0x3c, 0x61, 0x67, 0x3c, 0x61, 0x68, 0x3c, 0x61, 0x6c, 0x3c, 0x61, 0x6d,
    0x3c, 0x61, 0x6e, 0x3c, 0x61, 0x70, 0x3c, 0x61, 0x72, 0x3c, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table23_2_emit_[216] = {
    0x3c, 0x63, 0x30, 0x3c, 0x63, 0x31, 0x3c, 0x63, 0x32, 0x3c, 0x63, 0x61,
    0x3c, 0x63, 0x63, 0x3c, 0x63, 0x65, 0x3c, 0x63, 0x69, 0x3c, 0x63, 0x6f,
    0x3c, 0x63, 0x73, 0x3c, 0x63, 0x74, 0x3c, 0x63, 0x20, 0x3c, 0x63, 0x25,
    0x3c, 0x63, 0x2d, 0x3c, 0x63, 0x2e, 0x3c, 0x63, 0x2f, 0x3c, 0x63, 0x33,
    0x3c, 0x63, 0x34, 0x3c, 0x63, 0x35, 0x3c, 0x63, 0x36, 0x3c, 0x63, 0x37,
    0x3c, 0x63, 0x38, 0x3c, 0x63, 0x39, 0x3c, 0x63, 0x3d, 0x3c, 0x63, 0x41,
    0x3c, 0x63, 0x5f, 0x3c, 0x63, 0x62, 0x3c, 0x63, 0x64, 0x3c, 0x63, 0x66,
    0x3c, 0x63, 0x67, 0x3c, 0x63, 0x68, 0x3c, 0x63, 0x6c, 0x3c, 0x63, 0x6d,
    0x3c, 0x63, 0x6e, 0x3c, 0x63, 0x70, 0x3c, 0x63, 0x72, 0x3c, 0x63, 0x75,
    0x3c, 0x65, 0x30, 0x3c, 0x65, 0x31, 0x3c, 0x65, 0x32, 0x3c, 0x65, 0x61,
    0x3c, 0x65, 0x63, 0x3c, 0x65, 0x65, 0x3c, 0x65, 0x69, 0x3c, 0x65, 0x6f,
    0x3c, 0x65, 0x73, 0x3c, 0x65, 0x74, 0x3c, 0x65, 0x20, 0x3c, 0x65, 0x25,
    0x3c, 0x65, 0x2d, 0x3c, 0x65, 0x2e, 0x3c, 0x65, 0x2f, 0x3c, 0x65, 0x33,
    0x3c, 0x65, 0x34, 0x3c, 0x65, 0x35, 0x3c, 0x65, 0x36, 0x3c, 0x65, 0x37,
    0x3c, 0x65, 0x38, 0x3c, 0x65, 0x39, 0x3c, 0x65, 0x3d, 0x3c, 0x65, 0x41,
    0x3c, 0x65, 0x5f, 0x3c, 0x65, 0x62, 0x3c, 0x65, 0x64, 0x3c, 0x65, 0x66,
    0x3c, 0x65, 0x67, 0x3c, 0x65, 0x68, 0x3c, 0x65, 0x6c, 0x3c, 0x65, 0x6d,
    0x3c, 0x65, 0x6e, 0x3c, 0x65, 0x70, 0x3c, 0x65, 0x72, 0x3c, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table23_3_emit_[216] = {
    0x3c, 0x69, 0x30, 0x3c, 0x69, 0x31, 0x3c, 0x69, 0x32, 0x3c, 0x69, 0x61,
    0x3c, 0x69, 0x63, 0x3c, 0x69, 0x65, 0x3c, 0x69, 0x69, 0x3c, 0x69, 0x6f,
    0x3c, 0x69, 0x73, 0x3c, 0x69, 0x74, 0x3c, 0x69, 0x20, 0x3c, 0x69, 0x25,
    0x3c, 0x69, 0x2d, 0x3c, 0x69, 0x2e, 0x3c, 0x69, 0x2f, 0x3c, 0x69, 0x33,
    0x3c, 0x69, 0x34, 0x3c, 0x69, 0x35, 0x3c, 0x69, 0x36, 0x3c, 0x69, 0x37,
    0x3c, 0x69, 0x38, 0x3c, 0x69, 0x39, 0x3c, 0x69, 0x3d, 0x3c, 0x69, 0x41,
    0x3c, 0x69, 0x5f, 0x3c, 0x69, 0x62, 0x3c, 0x69, 0x64, 0x3c, 0x69, 0x66,
    0x3c, 0x69, 0x67, 0x3c, 0x69, 0x68, 0x3c, 0x69, 0x6c, 0x3c, 0x69, 0x6d,
    0x3c, 0x69, 0x6e, 0x3c, 0x69, 0x70, 0x3c, 0x69, 0x72, 0x3c, 0x69, 0x75,
    0x3c, 0x6f, 0x30, 0x3c, 0x6f, 0x31, 0x3c, 0x6f, 0x32, 0x3c, 0x6f, 0x61,
    0x3c, 0x6f, 0x63, 0x3c, 0x6f, 0x65, 0x3c, 0x6f, 0x69, 0x3c, 0x6f, 0x6f,
    0x3c, 0x6f, 0x73, 0x3c, 0x6f, 0x74, 0x3c, 0x6f, 0x20, 0x3c, 0x6f, 0x25,
    0x3c, 0x6f, 0x2d, 0x3c, 0x6f, 0x2e, 0x3c, 0x6f, 0x2f, 0x3c, 0x6f, 0x33,
    0x3c, 0x6f, 0x34, 0x3c, 0x6f, 0x35, 0x3c, 0x6f, 0x36, 0x3c, 0x6f, 0x37,
    0x3c, 0x6f, 0x38, 0x3c, 0x6f, 0x39, 0x3c, 0x6f, 0x3d, 0x3c, 0x6f, 0x41,
    0x3c, 0x6f, 0x5f, 0x3c, 0x6f, 0x62, 0x3c, 0x6f, 0x64, 0x3c, 0x6f, 0x66,
    0x3c, 0x6f, 0x67, 0x3c, 0x6f, 0x68, 0x3c, 0x6f, 0x6c, 0x3c, 0x6f, 0x6d,
    0x3c, 0x6f, 0x6e, 0x3c, 0x6f, 0x70, 0x3c, 0x6f, 0x72, 0x3c, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table23_4_emit_[216] = {
    0x3c, 0x73, 0x30, 0x3c, 0x73, 0x31, 0x3c, 0x73, 0x32, 0x3c, 0x73, 0x61,
    0x3c, 0x73, 0x63, 0x3c, 0x73, 0x65, 0x3c, 0x73, 0x69, 0x3c, 0x73, 0x6f,
    0x3c, 0x73, 0x73, 0x3c, 0x73, 0x74, 0x3c, 0x73, 0x20, 0x3c, 0x73, 0x25,
    0x3c, 0x73, 0x2d, 0x3c, 0x73, 0x2e, 0x3c, 0x73, 0x2f, 0x3c, 0x73, 0x33,
    0x3c, 0x73, 0x34, 0x3c, 0x73, 0x35, 0x3c, 0x73, 0x36, 0x3c, 0x73, 0x37,
    0x3c, 0x73, 0x38, 0x3c, 0x73, 0x39, 0x3c, 0x73, 0x3d, 0x3c, 0x73, 0x41,
    0x3c, 0x73, 0x5f, 0x3c, 0x73, 0x62, 0x3c, 0x73, 0x64, 0x3c, 0x73, 0x66,
    0x3c, 0x73, 0x67, 0x3c, 0x73, 0x68, 0x3c, 0x73, 0x6c, 0x3c, 0x73, 0x6d,
    0x3c, 0x73, 0x6e, 0x3c, 0x73, 0x70, 0x3c, 0x73, 0x72, 0x3c, 0x73, 0x75,
    0x3c, 0x74, 0x30, 0x3c, 0x74, 0x31, 0x3c, 0x74, 0x32, 0x3c, 0x74, 0x61,
    0x3c, 0x74, 0x63, 0x3c, 0x74, 0x65, 0x3c, 0x74, 0x69, 0x3c, 0x74, 0x6f,
    0x3c, 0x74, 0x73, 0x3c, 0x74, 0x74, 0x3c, 0x74, 0x20, 0x3c, 0x74, 0x25,
    0x3c, 0x74, 0x2d, 0x3c, 0x74, 0x2e, 0x3c, 0x74, 0x2f, 0x3c, 0x74, 0x33,
    0x3c, 0x74, 0x34, 0x3c, 0x74, 0x35, 0x3c, 0x74, 0x36, 0x3c, 0x74, 0x37,
    0x3c, 0x74, 0x38, 0x3c, 0x74, 0x39, 0x3c, 0x74, 0x3d, 0x3c, 0x74, 0x41,
    0x3c, 0x74, 0x5f, 0x3c, 0x74, 0x62, 0x3c, 0x74, 0x64, 0x3c, 0x74, 0x66,
    0x3c, 0x74, 0x67, 0x3c, 0x74, 0x68, 0x3c, 0x74, 0x6c, 0x3c, 0x74, 0x6d,
    0x3c, 0x74, 0x6e, 0x3c, 0x74, 0x70, 0x3c, 0x74, 0x72, 0x3c, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table23_5_emit_[120] = {
    0x3c, 0x20, 0x30, 0x3c, 0x20, 0x31, 0x3c, 0x20, 0x32, 0x3c, 0x20, 0x61,
    0x3c, 0x20, 0x63, 0x3c, 0x20, 0x65, 0x3c, 0x20, 0x69, 0x3c, 0x20, 0x6f,
    0x3c, 0x20, 0x73, 0x3c, 0x20, 0x74, 0x3c, 0x25, 0x30, 0x3c, 0x25, 0x31,
    0x3c, 0x25, 0x32, 0x3c, 0x25, 0x61, 0x3c, 0x25, 0x63, 0x3c, 0x25, 0x65,
    0x3c, 0x25, 0x69, 0x3c, 0x25, 0x6f, 0x3c, 0x25, 0x73, 0x3c, 0x25, 0x74,
    0x3c, 0x2d, 0x30, 0x3c, 0x2d, 0x31, 0x3c, 0x2d, 0x32, 0x3c, 0x2d, 0x61,
    0x3c, 0x2d, 0x63, 0x3c, 0x2d, 0x65, 0x3c, 0x2d, 0x69, 0x3c, 0x2d, 0x6f,
    0x3c, 0x2d, 0x73, 0x3c, 0x2d, 0x74, 0x3c, 0x2e, 0x30, 0x3c, 0x2e, 0x31,
    0x3c, 0x2e, 0x32, 0x3c, 0x2e, 0x61, 0x3c, 0x2e, 0x63, 0x3c, 0x2e, 0x65,
    0x3c, 0x2e, 0x69, 0x3c, 0x2e, 0x6f, 0x3c, 0x2e, 0x73, 0x3c, 0x2e, 0x74};
const uint16_t HuffDecoderCommon::table23_5_ops_[128] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9, 0x00c1,
    0x00d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x00f1, 0x0109, 0x0121, 0x0139,
    0x0151, 0x0169, 0x0181, 0x0199, 0x01b1, 0x01c9, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x00f2, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259, 0x0271, 0x0289,
    0x02a1, 0x02b9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01e2, 0x02d1, 0x02e9, 0x0301,
    0x0319, 0x0331, 0x0349, 0x0361, 0x0379, 0x0391, 0x03a9, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x02d2};
const uint8_t HuffDecoderCommon::table23_6_emit_[120] = {
    0x3c, 0x2f, 0x30, 0x3c, 0x2f, 0x31, 0x3c, 0x2f, 0x32, 0x3c, 0x2f, 0x61,
    0x3c, 0x2f, 0x63, 0x3c, 0x2f, 0x65, 0x3c, 0x2f, 0x69, 0x3c, 0x2f, 0x6f,
    0x3c, 0x2f, 0x73, 0x3c, 0x2f, 0x74, 0x3c, 0x33, 0x30, 0x3c, 0x33, 0x31,
    0x3c, 0x33, 0x32, 0x3c, 0x33, 0x61, 0x3c, 0x33, 0x63, 0x3c, 0x33, 0x65,
    0x3c, 0x33, 0x69, 0x3c, 0x33, 0x6f, 0x3c, 0x33, 0x73, 0x3c, 0x33, 0x74,
    0x3c, 0x34, 0x30, 0x3c, 0x34, 0x31, 0x3c, 0x34, 0x32, 0x3c, 0x34, 0x61,
    0x3c, 0x34, 0x63, 0x3c, 0x34, 0x65, 0x3c, 0x34, 0x69, 0x3c, 0x34, 0x6f,
    0x3c, 0x34, 0x73, 0x3c, 0x34, 0x74, 0x3c, 0x35, 0x30, 0x3c, 0x35, 0x31,
    0x3c, 0x35, 0x32, 0x3c, 0x35, 0x61, 0x3c, 0x35, 0x63, 0x3c, 0x35, 0x65,
    0x3c, 0x35, 0x69, 0x3c, 0x35, 0x6f, 0x3c, 0x35, 0x73, 0x3c, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table23_7_emit_[120] = {
    0x3c, 0x36, 0x30, 0x3c, 0x36, 0x31, 0x3c, 0x36, 0x32, 0x3c, 0x36, 0x61,
    0x3c, 0x36, 0x63, 0x3c, 0x36, 0x65, 0x3c, 0x36, 0x69, 0x3c, 0x36, 0x6f,
    0x3c, 0x36, 0x73, 0x3c, 0x36, 0x74, 0x3c, 0x37, 0x30, 0x3c, 0x37, 0x31,
    0x3c, 0x37, 0x32, 0x3c, 0x37, 0x61, 0x3c, 0x37, 0x63, 0x3c, 0x37, 0x65,
    0x3c, 0x37, 0x69, 0x3c, 0x37, 0x6f, 0x3c, 0x37, 0x73, 0x3c, 0x37, 0x74,
    0x3c, 0x38, 0x30, 0x3c, 0x38, 0x31, 0x3c, 0x38, 0x32, 0x3c, 0x38, 0x61,
    0x3c, 0x38, 0x63, 0x3c, 0x38, 0x65, 0x3c, 0x38, 0x69, 0x3c, 0x38, 0x6f,
    0x3c, 0x38, 0x73, 0x3c, 0x38, 0x74, 0x3c, 0x39, 0x30, 0x3c, 0x39, 0x31,
    0x3c, 0x39, 0x32, 0x3c, 0x39, 0x61, 0x3c, 0x39, 0x63, 0x3c, 0x39, 0x65,
    0x3c, 0x39, 0x69, 0x3c, 0x39, 0x6f, 0x3c, 0x39, 0x73, 0x3c, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table23_8_emit_[120] = {
    0x3c, 0x3d, 0x30, 0x3c, 0x3d, 0x31, 0x3c, 0x3d, 0x32, 0x3c, 0x3d, 0x61,
    0x3c, 0x3d, 0x63, 0x3c, 0x3d, 0x65, 0x3c, 0x3d, 0x69, 0x3c, 0x3d, 0x6f,
    0x3c, 0x3d, 0x73, 0x3c, 0x3d, 0x74, 0x3c, 0x41, 0x30, 0x3c, 0x41, 0x31,
    0x3c, 0x41, 0x32, 0x3c, 0x41, 0x61, 0x3c, 0x41, 0x63, 0x3c, 0x41, 0x65,
    0x3c, 0x41, 0x69, 0x3c, 0x41, 0x6f, 0x3c, 0x41, 0x73, 0x3c, 0x41, 0x74,
    0x3c, 0x5f, 0x30, 0x3c, 0x5f, 0x31, 0x3c, 0x5f, 0x32, 0x3c, 0x5f, 0x61,
    0x3c, 0x5f, 0x63, 0x3c, 0x5f, 0x65, 0x3c, 0x5f, 0x69, 0x3c, 0x5f, 0x6f,
    0x3c, 0x5f, 0x73, 0x3c, 0x5f, 0x74, 0x3c, 0x62, 0x30, 0x3c, 0x62, 0x31,
    0x3c, 0x62, 0x32, 0x3c, 0x62, 0x61, 0x3c, 0x62, 0x63, 0x3c, 0x62, 0x65,
    0x3c, 0x62, 0x69, 0x3c, 0x62, 0x6f, 0x3c, 0x62, 0x73, 0x3c, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table23_9_emit_[120] = {
    0x3c, 0x64, 0x30, 0x3c, 0x64, 0x31, 0x3c, 0x64, 0x32, 0x3c, 0x64, 0x61,
    0x3c, 0x64, 0x63, 0x3c, 0x64, 0x65, 0x3c, 0x64, 0x69, 0x3c, 0x64, 0x6f,
    0x3c, 0x64, 0x73, 0x3c, 0x64, 0x74, 0x3c, 0x66, 0x30, 0x3c, 0x66, 0x31,
    0x3c, 0x66, 0x32, 0x3c, 0x66, 0x61, 0x3c, 0x66, 0x63, 0x3c, 0x66, 0x65,
    0x3c, 0x66, 0x69, 0x3c, 0x66, 0x6f, 0x3c, 0x66, 0x73, 0x3c, 0x66, 0x74,
    0x3c, 0x67, 0x30, 0x3c, 0x67, 0x31, 0x3c, 0x67, 0x32, 0x3c, 0x67, 0x61,
    0x3c, 0x67, 0x63, 0x3c, 0x67, 0x65, 0x3c, 0x67, 0x69, 0x3c, 0x67, 0x6f,
    0x3c, 0x67, 0x73, 0x3c, 0x67, 0x74, 0x3c, 0x68, 0x30, 0x3c, 0x68, 0x31,
    0x3c, 0x68, 0x32, 0x3c, 0x68, 0x61, 0x3c, 0x68, 0x63, 0x3c, 0x68, 0x65,
    0x3c, 0x68, 0x69, 0x3c, 0x68, 0x6f, 0x3c, 0x68, 0x73, 0x3c, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table23_10_emit_[120] = {
    0x3c, 0x6c, 0x30, 0x3c, 0x6c, 0x31, 0x3c, 0x6c, 0x32, 0x3c, 0x6c, 0x61,
    0x3c, 0x6c, 0x63, 0x3c, 0x6c, 0x65, 0x3c, 0x6c, 0x69, 0x3c, 0x6c, 0x6f,
    0x3c, 0x6c, 0x73, 0x3c, 0x6c, 0x74, 0x3c, 0x6d, 0x30, 0x3c, 0x6d, 0x31,
    0x3c, 0x6d, 0x32, 0x3c, 0x6d, 0x61, 0x3c, 0x6d, 0x63, 0x3c, 0x6d, 0x65,
    0x3c, 0x6d, 0x69, 0x3c, 0x6d, 0x6f, 0x3c, 0x6d, 0x73, 0x3c, 0x6d, 0x74,
    0x3c, 0x6e, 0x30, 0x3c, 0x6e, 0x31, 0x3c, 0x6e, 0x32, 0x3c, 0x6e, 0x61,
    0x3c, 0x6e, 0x63, 0x3c, 0x6e, 0x65, 0x3c, 0x6e, 0x69, 0x3c, 0x6e, 0x6f,
    0x3c, 0x6e, 0x73, 0x3c, 0x6e, 0x74, 0x3c, 0x70, 0x30, 0x3c, 0x70, 0x31,
    0x3c, 0x70, 0x32, 0x3c, 0x70, 0x61, 0x3c, 0x70, 0x63, 0x3c, 0x70, 0x65,
    0x3c, 0x70, 0x69, 0x3c, 0x70, 0x6f, 0x3c, 0x70, 0x73, 0x3c, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table23_11_emit_[68] = {
    0x3c, 0x72, 0x30, 0x3c, 0x72, 0x31, 0x3c, 0x72, 0x32, 0x3c, 0x72, 0x61,
    0x3c, 0x72, 0x63, 0x3c, 0x72, 0x65, 0x3c, 0x72, 0x69, 0x3c, 0x72, 0x6f,
    0x3c, 0x72, 0x73, 0x3c, 0x72, 0x74, 0x3c, 0x75, 0x30, 0x3c, 0x75, 0x31,
    0x3c, 0x75, 0x32, 0x3c, 0x75, 0x61, 0x3c, 0x75, 0x63, 0x3c, 0x75, 0x65,
    0x3c, 0x75, 0x69, 0x3c, 0x75, 0x6f, 0x3c, 0x75, 0x73, 0x3c, 0x75, 0x74,
    0x3c, 0x3a, 0x3c, 0x42, 0x3c, 0x43, 0x3c, 0x44};
const uint16_t HuffDecoderCommon::table23_11_ops_[128] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9, 0x00c1,
    0x00d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x00f1, 0x0109, 0x0121, 0x0139,
    0x0151, 0x0169, 0x0181, 0x0199, 0x01b1, 0x01c9, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x00f2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01e2, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f2, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0202, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0212};
const uint16_t HuffDecoderCommon::table23_12_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0072};
const uint8_t HuffDecoderCommon::table23_15_emit_[36] = {
    0x3c, 0x77, 0x3c, 0x78, 0x3c, 0x79, 0x3c, 0x7a, 0x3c, 0x26, 0x3c, 0x2a,
    0x3c, 0x2c, 0x3c, 0x3b, 0x3c, 0x58, 0x3c, 0x5a, 0x3c, 0x21, 0x3c, 0x22,
    0x3c, 0x28, 0x3c, 0x29, 0x3c, 0x3f, 0x3c, 0x27, 0x3c, 0x2b, 0x3c, 0x7c};
const uint16_t HuffDecoderCommon::table23_15_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x00a2, 0x0000, 0x00b2, 0x0000,
    0x00c2, 0x0000, 0x00d2, 0x0000, 0x00e2, 0x00f2, 0x0102, 0x0112, 0x0000,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table23_16_emit_[216] = {
    0x60, 0x30, 0x30, 0x60, 0x30, 0x31, 0x60, 0x30, 0x32, 0x60, 0x30, 0x61,
    0x60, 0x30, 0x63, 0x60, 0x30, 0x65, 0x60, 0x30, 0x69, 0x60, 0x30, 0x6f,
    0x60, 0x30, 0x73, 0x60, 0x30, 0x74, 0x60, 0x30, 0x20, 0x60, 0x30, 0x25,
    0x60, 0x30, 0x2d, 0x60, 0x30, 0x2e, 0x60, 0x30, 0x2f, 0x60, 0x30, 0x33,
    0x60, 0x30, 0x34, 0x60, 0x30, 0x35, 0x60, 0x30, 0x36, 0x60, 0x30, 0x37,
    0x60, 0x30, 0x38, 0x60, 0x30, 0x39, 0x60, 0x30, 0x3d, 0x60, 0x30, 0x41,
    0x60, 0x30, 0x5f, 0x60, 0x30, 0x62, 0x60, 0x30, 0x64, 0x60, 0x30, 0x66,
    0x60, 0x30, 0x67, 0x60, 0x30, 0x68, 0x60, 0x30, 0x6c, 0x60, 0x30, 0x6d,
    0x60, 0x30, 0x6e, 0x60, 0x30, 0x70, 0x60, 0x30, 0x72, 0x60, 0x30, 0x75,
    0x60, 0x31, 0x30, 0x60, 0x31, 0x31, 0x60, 0x31, 0x32, 0x60, 0x31, 0x61,
    0x60, 0x31, 0x63, 0x60, 0x31, 0x65, 0x60, 0x31, 0x69, 0x60, 0x31, 0x6f,
    0x60, 0x31, 0x73, 0x60, 0x31, 0x74, 0x60, 0x31, 0x20, 0x60, 0x31, 0x25,
    0x60, 0x31, 0x2d, 0x60, 0x31, 0x2e, 0x60, 0x31, 0x2f, 0x60, 0x31, 0x33,
    0x60, 0x31, 0x34, 0x60, 0x31, 0x35, 0x60, 0x31, 0x36, 0x60, 0x31, 0x37,
    0x60, 0x31, 0x38, 0x60, 0x31, 0x39, 0x60, 0x31, 0x3d, 0x60, 0x31, 0x41,
    0x60, 0x31, 0x5f, 0x60, 0x31, 0x62, 0x60, 0x31, 0x64, 0x60, 0x31, 0x66,
    0x60, 0x31, 0x67, 0x60, 0x31, 0x68, 0x60, 0x31, 0x6c, 0x60, 0x31, 0x6d,
    0x60, 0x31, 0x6e, 0x60, 0x31, 0x70, 0x60, 0x31, 0x72, 0x60, 0x31, 0x75};
const uint8_t HuffDecoderCommon::table23_17_emit_[216] = {
    0x60, 0x32, 0x30, 0x60, 0x32, 0x31, 0x60, 0x32, 0x32, 0x60, 0x32, 0x61,
    0x60, 0x32, 0x63, 0x60, 0x32, 0x65, 0x60, 0x32, 0x69, 0x60, 0x32, 0x6f,
    0x60, 0x32, 0x73, 0x60, 0x32, 0x74, 0x60, 0x32, 0x20, 0x60, 0x32, 0x25,
    0x60, 0x32, 0x2d, 0x60, 0x32, 0x2e, 0x60, 0x32, 0x2f, 0x60, 0x32, 0x33,
    0x60, 0x32, 0x34, 0x60, 0x32, 0x35, 0x60, 0x32, 0x36, 0x60, 0x32, 0x37,
    0x60, 0x32, 0x38, 0x60, 0x32, 0x39, 0x60, 0x32, 0x3d, 0x60, 0x32, 0x41,
    0x60, 0x32, 0x5f, 0x60, 0x32, 0x62, 0x60, 0x32, 0x64, 0x60, 0x32, 0x66,
    0x60, 0x32, 0x67, 0x60, 0x32, 0x68, 0x60, 0x32, 0x6c, 0x60, 0x32, 0x6d,
    0x60, 0x32, 0x6e, 0x60, 0x32, 0x70, 0x60, 0x32, 0x72, 0x60, 0x32, 0x75,
    0x60, 0x61, 0x30, 0x60, 0x61, 0x31, 0x60, 0x61, 0x32, 0x60, 0x61, 0x61,
    0x60, 0x61, 0x63, 0x60, 0x61, 0x65, 0x60, 0x61, 0x69, 0x60, 0x61, 0x6f,
    0x60, 0x61, 0x73, 0x60, 0x61, 0x74, 0x60, 0x61, 0x20, 0x60, 0x61, 0x25,
    0x60, 0x61, 0x2d, 0x60, 0x61, 0x2e, 0x60, 0x61, 0x2f, 0x60, 0x61, 0x33,
    0x60, 0x61, 0x34, 0x60, 0x61, 0x35, 0x60, 0x61, 0x36, 0x60, 0x61, 0x37,
    0x60, 0x61, 0x38, 0x60, 0x61, 0x39, 0x60, 0x61, 0x3d, 0x60, 0x61, 0x41,
    0x60, 0x61, 0x5f, 0x60, 0x61, 0x62, 0x60, 0x61, 0x64, 0x60, 0x61, 0x66,
    0x60, 0x61, 0x67, 0x60, 0x61, 0x68, 0x60, 0x61, 0x6c, 0x60, 0x61, 0x6d,
    0x60, 0x61, 0x6e, 0x60, 0x61, 0x70, 0x60, 0x61, 0x72, 0x60, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table23_18_emit_[216] = {
    0x60, 0x63, 0x30, 0x60, 0x63, 0x31, 0x60, 0x63, 0x32, 0x60, 0x63, 0x61,
    0x60, 0x63, 0x63, 0x60, 0x63, 0x65, 0x60, 0x63, 0x69, 0x60, 0x63, 0x6f,
    0x60, 0x63, 0x73, 0x60, 0x63, 0x74, 0x60, 0x63, 0x20, 0x60, 0x63, 0x25,
    0x60, 0x63, 0x2d, 0x60, 0x63, 0x2e, 0x60, 0x63, 0x2f, 0x60, 0x63, 0x33,
    0x60, 0x63, 0x34, 0x60, 0x63, 0x35, 0x60, 0x63, 0x36, 0x60, 0x63, 0x37,
    0x60, 0x63, 0x38, 0x60, 0x63, 0x39, 0x60, 0x63, 0x3d, 0x60, 0x63, 0x41,
    0x60, 0x63, 0x5f, 0x60, 0x63, 0x62, 0x60, 0x63, 0x64, 0x60, 0x63, 0x66,
    0x60, 0x63, 0x67, 0x60, 0x63, 0x68, 0x60, 0x63, 0x6c, 0x60, 0x63, 0x6d,
    0x60, 0x63, 0x6e, 0x60, 0x63, 0x70, 0x60, 0x63, 0x72, 0x60, 0x63, 0x75,
    0x60, 0x65, 0x30, 0x60, 0x65, 0x31, 0x60, 0x65, 0x32, 0x60, 0x65, 0x61,
    0x60, 0x65, 0x63, 0x60, 0x65, 0x65, 0x60, 0x65, 0x69, 0x60, 0x65, 0x6f,
    0x60, 0x65, 0x73, 0x60, 0x65, 0x74, 0x60, 0x65, 0x20, 0x60, 0x65, 0x25,
    0x60, 0x65, 0x2d, 0x60, 0x65, 0x2e, 0x60, 0x65, 0x2f, 0x60, 0x65, 0x33,
    0x60, 0x65, 0x34, 0x60, 0x65, 0x35, 0x60, 0x65, 0x36, 0x60, 0x65, 0x37,
    0x60, 0x65, 0x38, 0x60, 0x65, 0x39, 0x60, 0x65, 0x3d, 0x60, 0x65, 0x41,
    0x60, 0x65, 0x5f, 0x60, 0x65, 0x62, 0x60, 0x65, 0x64, 0x60, 0x65, 0x66,
    0x60, 0x65, 0x67, 0x60, 0x65, 0x68, 0x60, 0x65, 0x6c, 0x60, 0x65, 0x6d,
    0x60, 0x65, 0x6e, 0x60, 0x65, 0x70, 0x60, 0x65, 0x72, 0x60, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table23_19_emit_[216] = {
    0x60, 0x69, 0x30, 0x60, 0x69, 0x31, 0x60, 0x69, 0x32, 0x60, 0x69, 0x61,
    0x60, 0x69, 0x63, 0x60, 0x69, 0x65, 0x60, 0x69, 0x69, 0x60, 0x69, 0x6f,
    0x60, 0x69, 0x73, 0x60, 0x69, 0x74, 0x60, 0x69, 0x20, 0x60, 0x69, 0x25,
    0x60, 0x69, 0x2d, 0x60, 0x69, 0x2e, 0x60, 0x69, 0x2f, 0x60, 0x69, 0x33,
    0x60, 0x69, 0x34, 0x60, 0x69, 0x35, 0x60, 0x69, 0x36, 0x60, 0x69, 0x37,
    0x60, 0x69, 0x38, 0x60, 0x69, 0x39, 0x60, 0x69, 0x3d, 0x60, 0x69, 0x41,
    0x60, 0x69, 0x5f, 0x60, 0x69, 0x62, 0x60, 0x69, 0x64, 0x60, 0x69, 0x66,
    0x60, 0x69, 0x67, 0x60, 0x69, 0x68, 0x60, 0x69, 0x6c, 0x60, 0x69, 0x6d,
    0x60, 0x69, 0x6e, 0x60, 0x69, 0x70, 0x60, 0x69, 0x72, 0x60, 0x69, 0x75,
    0x60, 0x6f, 0x30, 0x60, 0x6f, 0x31, 0x60, 0x6f, 0x32, 0x60, 0x6f, 0x61,
    0x60, 0x6f, 0x63, 0x60, 0x6f, 0x65, 0x60, 0x6f, 0x69, 0x60, 0x6f, 0x6f,
    0x60, 0x6f, 0x73, 0x60, 0x6f, 0x74, 0x60, 0x6f, 0x20, 0x60, 0x6f, 0x25,
    0x60, 0x6f, 0x2d, 0x60, 0x6f, 0x2e, 0x60, 0x6f, 0x2f, 0x60, 0x6f, 0x33,
    0x60, 0x6f, 0x34, 0x60, 0x6f, 0x35, 0x60, 0x6f, 0x36, 0x60, 0x6f, 0x37,
    0x60, 0x6f, 0x38, 0x60, 0x6f, 0x39, 0x60, 0x6f, 0x3d, 0x60, 0x6f, 0x41,
    0x60, 0x6f, 0x5f, 0x60, 0x6f, 0x62, 0x60, 0x6f, 0x64, 0x60, 0x6f, 0x66,
    0x60, 0x6f, 0x67, 0x60, 0x6f, 0x68, 0x60, 0x6f, 0x6c, 0x60, 0x6f, 0x6d,
    0x60, 0x6f, 0x6e, 0x60, 0x6f, 0x70, 0x60, 0x6f, 0x72, 0x60, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table23_20_emit_[216] = {
    0x60, 0x73, 0x30, 0x60, 0x73, 0x31, 0x60, 0x73, 0x32, 0x60, 0x73, 0x61,
    0x60, 0x73, 0x63, 0x60, 0x73, 0x65, 0x60, 0x73, 0x69, 0x60, 0x73, 0x6f,
    0x60, 0x73, 0x73, 0x60, 0x73, 0x74, 0x60, 0x73, 0x20, 0x60, 0x73, 0x25,
    0x60, 0x73, 0x2d, 0x60, 0x73, 0x2e, 0x60, 0x73, 0x2f, 0x60, 0x73, 0x33,
    0x60, 0x73, 0x34, 0x60, 0x73, 0x35, 0x60, 0x73, 0x36, 0x60, 0x73, 0x37,
    0x60, 0x73, 0x38, 0x60, 0x73, 0x39, 0x60, 0x73, 0x3d, 0x60, 0x73, 0x41,
    0x60, 0x73, 0x5f, 0x60, 0x73, 0x62, 0x60, 0x73, 0x64, 0x60, 0x73, 0x66,
    0x60, 0x73, 0x67, 0x60, 0x73, 0x68, 0x60, 0x73, 0x6c, 0x60, 0x73, 0x6d,
    0x60, 0x73, 0x6e, 0x60, 0x73, 0x70, 0x60, 0x73, 0x72, 0x60, 0x73, 0x75,
    0x60, 0x74, 0x30, 0x60, 0x74, 0x31, 0x60, 0x74, 0x32, 0x60, 0x74, 0x61,
    0x60, 0x74, 0x63, 0x60, 0x74, 0x65, 0x60, 0x74, 0x69, 0x60, 0x74, 0x6f,
    0x60, 0x74, 0x73, 0x60, 0x74, 0x74, 0x60, 0x74, 0x20, 0x60, 0x74, 0x25,
    0x60, 0x74, 0x2d, 0x60, 0x74, 0x2e, 0x60, 0x74, 0x2f, 0x60, 0x74, 0x33,
    0x60, 0x74, 0x34, 0x60, 0x74, 0x35, 0x60, 0x74, 0x36, 0x60, 0x74, 0x37,
    0x60, 0x74, 0x38, 0x60, 0x74, 0x39, 0x60, 0x74, 0x3d, 0x60, 0x74, 0x41,
    0x60, 0x74, 0x5f, 0x60, 0x74, 0x62, 0x60, 0x74, 0x64, 0x60, 0x74, 0x66,
    0x60, 0x74, 0x67, 0x60, 0x74, 0x68, 0x60, 0x74, 0x6c, 0x60, 0x74, 0x6d,
    0x60, 0x74, 0x6e, 0x60, 0x74, 0x70, 0x60, 0x74, 0x72, 0x60, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table23_21_emit_[120] = {
    0x60, 0x20, 0x30, 0x60, 0x20, 0x31, 0x60, 0x20, 0x32, 0x60, 0x20, 0x61,
    0x60, 0x20, 0x63, 0x60, 0x20, 0x65, 0x60, 0x20, 0x69, 0x60, 0x20, 0x6f,
    0x60, 0x20, 0x73, 0x60, 0x20, 0x74, 0x60, 0x25, 0x30, 0x60, 0x25, 0x31,
    0x60, 0x25, 0x32, 0x60, 0x25, 0x61, 0x60, 0x25, 0x63, 0x60, 0x25, 0x65,
    0x60, 0x25, 0x69, 0x60, 0x25, 0x6f, 0x60, 0x25, 0x73, 0x60, 0x25, 0x74,
    0x60, 0x2d, 0x30, 0x60, 0x2d, 0x31, 0x60, 0x2d, 0x32, 0x60, 0x2d, 0x61,
    0x60, 0x2d, 0x63, 0x60, 0x2d, 0x65, 0x60, 0x2d, 0x69, 0x60, 0x2d, 0x6f,
    0x60, 0x2d, 0x73, 0x60, 0x2d, 0x74, 0x60, 0x2e, 0x30, 0x60, 0x2e, 0x31,
    0x60, 0x2e, 0x32, 0x60, 0x2e, 0x61, 0x60, 0x2e, 0x63, 0x60, 0x2e, 0x65,
    0x60, 0x2e, 0x69, 0x60, 0x2e, 0x6f, 0x60, 0x2e, 0x73, 0x60, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table23_22_emit_[120] = {
    0x60, 0x2f, 0x30, 0x60, 0x2f, 0x31, 0x60, 0x2f, 0x32, 0x60, 0x2f, 0x61,
    0x60, 0x2f, 0x63, 0x60, 0x2f, 0x65, 0x60, 0x2f, 0x69, 0x60, 0x2f, 0x6f,
    0x60, 0x2f, 0x73, 0x60, 0x2f, 0x74, 0x60, 0x33, 0x30, 0x60, 0x33, 0x31,
    0x60, 0x33, 0x32, 0x60, 0x33, 0x61, 0x60, 0x33, 0x63, 0x60, 0x33, 0x65,
    0x60, 0x33, 0x69, 0x60, 0x33, 0x6f, 0x60, 0x33, 0x73, 0x60, 0x33, 0x74,
    0x60, 0x34, 0x30, 0x60, 0x34, 0x31, 0x60, 0x34, 0x32, 0x60, 0x34, 0x61,
    0x60, 0x34, 0x63, 0x60, 0x34, 0x65, 0x60, 0x34, 0x69, 0x60, 0x34, 0x6f,
    0x60, 0x34, 0x73, 0x60, 0x34, 0x74, 0x60, 0x35, 0x30, 0x60, 0x35, 0x31,
    0x60, 0x35, 0x32, 0x60, 0x35, 0x61, 0x60, 0x35, 0x63, 0x60, 0x35, 0x65,
    0x60, 0x35, 0x69, 0x60, 0x35, 0x6f, 0x60, 0x35, 0x73, 0x60, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table23_23_emit_[120] = {
    0x60, 0x36, 0x30, 0x60, 0x36, 0x31, 0x60, 0x36, 0x32, 0x60, 0x36, 0x61,
    0x60, 0x36, 0x63, 0x60, 0x36, 0x65, 0x60, 0x36, 0x69, 0x60, 0x36, 0x6f,
    0x60, 0x36, 0x73, 0x60, 0x36, 0x74, 0x60, 0x37, 0x30, 0x60, 0x37, 0x31,
    0x60, 0x37, 0x32, 0x60, 0x37, 0x61, 0x60, 0x37, 0x63, 0x60, 0x37, 0x65,
    0x60, 0x37, 0x69, 0x60, 0x37, 0x6f, 0x60, 0x37, 0x73, 0x60, 0x37, 0x74,
    0x60, 0x38, 0x30, 0x60, 0x38, 0x31, 0x60, 0x38, 0x32, 0x60, 0x38, 0x61,
    0x60, 0x38, 0x63, 0x60, 0x38, 0x65, 0x60, 0x38, 0x69, 0x60, 0x38, 0x6f,
    0x60, 0x38, 0x73, 0x60, 0x38, 0x74, 0x60, 0x39, 0x30, 0x60, 0x39, 0x31,
    0x60, 0x39, 0x32, 0x60, 0x39, 0x61, 0x60, 0x39, 0x63, 0x60, 0x39, 0x65,
    0x60, 0x39, 0x69, 0x60, 0x39, 0x6f, 0x60, 0x39, 0x73, 0x60, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table23_24_emit_[120] = {
    0x60, 0x3d, 0x30, 0x60, 0x3d, 0x31, 0x60, 0x3d, 0x32, 0x60, 0x3d, 0x61,
    0x60, 0x3d, 0x63, 0x60, 0x3d, 0x65, 0x60, 0x3d, 0x69, 0x60, 0x3d, 0x6f,
    0x60, 0x3d, 0x73, 0x60, 0x3d, 0x74, 0x60, 0x41, 0x30, 0x60, 0x41, 0x31,
    0x60, 0x41, 0x32, 0x60, 0x41, 0x61, 0x60, 0x41, 0x63, 0x60, 0x41, 0x65,
    0x60, 0x41, 0x69, 0x60, 0x41, 0x6f, 0x60, 0x41, 0x73, 0x60, 0x41, 0x74,
    0x60, 0x5f, 0x30, 0x60, 0x5f, 0x31, 0x60, 0x5f, 0x32, 0x60, 0x5f, 0x61,
    0x60, 0x5f, 0x63, 0x60, 0x5f, 0x65, 0x60, 0x5f, 0x69, 0x60, 0x5f, 0x6f,
    0x60, 0x5f, 0x73, 0x60, 0x5f, 0x74, 0x60, 0x62, 0x30, 0x60, 0x62, 0x31,
    0x60, 0x62, 0x32, 0x60, 0x62, 0x61, 0x60, 0x62, 0x63, 0x60, 0x62, 0x65,
    0x60, 0x62, 0x69, 0x60, 0x62, 0x6f, 0x60, 0x62, 0x73, 0x60, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table23_25_emit_[120] = {
    0x60, 0x64, 0x30, 0x60, 0x64, 0x31, 0x60, 0x64, 0x32, 0x60, 0x64, 0x61,
    0x60, 0x64, 0x63, 0x60, 0x64, 0x65, 0x60, 0x64, 0x69, 0x60, 0x64, 0x6f,
    0x60, 0x64, 0x73, 0x60, 0x64, 0x74, 0x60, 0x66, 0x30, 0x60, 0x66, 0x31,
    0x60, 0x66, 0x32, 0x60, 0x66, 0x61, 0x60, 0x66, 0x63, 0x60, 0x66, 0x65,
    0x60, 0x66, 0x69, 0x60, 0x66, 0x6f, 0x60, 0x66, 0x73, 0x60, 0x66, 0x74,
    0x60, 0x67, 0x30, 0x60, 0x67, 0x31, 0x60, 0x67, 0x32, 0x60, 0x67, 0x61,
    0x60, 0x67, 0x63, 0x60, 0x67, 0x65, 0x60, 0x67, 0x69, 0x60, 0x67, 0x6f,
    0x60, 0x67, 0x73, 0x60, 0x67, 0x74, 0x60, 0x68, 0x30, 0x60, 0x68, 0x31,
    0x60, 0x68, 0x32, 0x60, 0x68, 0x61, 0x60, 0x68, 0x63, 0x60, 0x68, 0x65,
    0x60, 0x68, 0x69, 0x60, 0x68, 0x6f, 0x60, 0x68, 0x73, 0x60, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table23_26_emit_[120] = {
    0x60, 0x6c, 0x30, 0x60, 0x6c, 0x31, 0x60, 0x6c, 0x32, 0x60, 0x6c, 0x61,
    0x60, 0x6c, 0x63, 0x60, 0x6c, 0x65, 0x60, 0x6c, 0x69, 0x60, 0x6c, 0x6f,
    0x60, 0x6c, 0x73, 0x60, 0x6c, 0x74, 0x60, 0x6d, 0x30, 0x60, 0x6d, 0x31,
    0x60, 0x6d, 0x32, 0x60, 0x6d, 0x61, 0x60, 0x6d, 0x63, 0x60, 0x6d, 0x65,
    0x60, 0x6d, 0x69, 0x60, 0x6d, 0x6f, 0x60, 0x6d, 0x73, 0x60, 0x6d, 0x74,
    0x60, 0x6e, 0x30, 0x60, 0x6e, 0x31, 0x60, 0x6e, 0x32, 0x60, 0x6e, 0x61,
    0x60, 0x6e, 0x63, 0x60, 0x6e, 0x65, 0x60, 0x6e, 0x69, 0x60, 0x6e, 0x6f,
    0x60, 0x6e, 0x73, 0x60, 0x6e, 0x74, 0x60, 0x70, 0x30, 0x60, 0x70, 0x31,
    0x60, 0x70, 0x32, 0x60, 0x70, 0x61, 0x60, 0x70, 0x63, 0x60, 0x70, 0x65,
    0x60, 0x70, 0x69, 0x60, 0x70, 0x6f, 0x60, 0x70, 0x73, 0x60, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table23_27_emit_[68] = {
    0x60, 0x72, 0x30, 0x60, 0x72, 0x31, 0x60, 0x72, 0x32, 0x60, 0x72, 0x61,
    0x60, 0x72, 0x63, 0x60, 0x72, 0x65, 0x60, 0x72, 0x69, 0x60, 0x72, 0x6f,
    0x60, 0x72, 0x73, 0x60, 0x72, 0x74, 0x60, 0x75, 0x30, 0x60, 0x75, 0x31,
    0x60, 0x75, 0x32, 0x60, 0x75, 0x61, 0x60, 0x75, 0x63, 0x60, 0x75, 0x65,
    0x60, 0x75, 0x69, 0x60, 0x75, 0x6f, 0x60, 0x75, 0x73, 0x60, 0x75, 0x74,
    0x60, 0x3a, 0x60, 0x42, 0x60, 0x43, 0x60, 0x44};
const uint8_t HuffDecoderCommon::table23_31_emit_[36] = {
    0x60, 0x77, 0x60, 0x78, 0x60, 0x79, 0x60, 0x7a, 0x60, 0x26, 0x60, 0x2a,
    0x60, 0x2c, 0x60, 0x3b, 0x60, 0x58, 0x60, 0x5a, 0x60, 0x21, 0x60, 0x22,
    0x60, 0x28, 0x60, 0x29, 0x60, 0x3f, 0x60, 0x27, 0x60, 0x2b, 0x60, 0x7c};
const uint8_t HuffDecoderCommon::table23_32_emit_[216] = {
    0x7b, 0x30, 0x30, 0x7b, 0x30, 0x31, 0x7b, 0x30, 0x32, 0x7b, 0x30, 0x61,
    0x7b, 0x30, 0x63, 0x7b, 0x30, 0x65, 0x7b, 0x30, 0x69, 0x7b, 0x30, 0x6f,
    0x7b, 0x30, 0x73, 0x7b, 0x30, 0x74, 0x7b, 0x30, 0x20, 0x7b, 0x30, 0x25,
    0x7b, 0x30, 0x2d, 0x7b, 0x30, 0x2e, 0x7b, 0x30, 0x2f, 0x7b, 0x30, 0x33,
    0x7b, 0x30, 0x34, 0x7b, 0x30, 0x35, 0x7b, 0x30, 0x36, 0x7b, 0x30, 0x37,
    0x7b, 0x30, 0x38, 0x7b, 0x30, 0x39, 0x7b, 0x30, 0x3d, 0x7b, 0x30, 0x41,
    0x7b, 0x30, 0x5f, 0x7b, 0x30, 0x62, 0x7b, 0x30, 0x64, 0x7b, 0x30, 0x66,
    0x7b, 0x30, 0x67, 0x7b, 0x30, 0x68, 0x7b, 0x30, 0x6c, 0x7b, 0x30, 0x6d,
    0x7b, 0x30, 0x6e, 0x7b, 0x30, 0x70, 0x7b, 0x30, 0x72, 0x7b, 0x30, 0x75,
    0x7b, 0x31, 0x30, 0x7b, 0x31, 0x31, 0x7b, 0x31, 0x32, 0x7b, 0x31, 0x61,
    0x7b, 0x31, 0x63, 0x7b, 0x31, 0x65, 0x7b, 0x31, 0x69, 0x7b, 0x31, 0x6f,
    0x7b, 0x31, 0x73, 0x7b, 0x31, 0x74, 0x7b, 0x31, 0x20, 0x7b, 0x31, 0x25,
    0x7b, 0x31, 0x2d, 0x7b, 0x31, 0x2e, 0x7b, 0x31, 0x2f, 0x7b, 0x31, 0x33,
    0x7b, 0x31, 0x34, 0x7b, 0x31, 0x35, 0x7b, 0x31, 0x36, 0x7b, 0x31, 0x37,
    0x7b, 0x31, 0x38, 0x7b, 0x31, 0x39, 0x7b, 0x31, 0x3d, 0x7b, 0x31, 0x41,
    0x7b, 0x31, 0x5f, 0x7b, 0x31, 0x62, 0x7b, 0x31, 0x64, 0x7b, 0x31, 0x66,
    0x7b, 0x31, 0x67, 0x7b, 0x31, 0x68, 0x7b, 0x31, 0x6c, 0x7b, 0x31, 0x6d,
    0x7b, 0x31, 0x6e, 0x7b, 0x31, 0x70, 0x7b, 0x31, 0x72, 0x7b, 0x31, 0x75};
const uint8_t HuffDecoderCommon::table23_33_emit_[216] = {
    0x7b, 0x32, 0x30, 0x7b, 0x32, 0x31, 0x7b, 0x32, 0x32, 0x7b, 0x32, 0x61,
    0x7b, 0x32, 0x63, 0x7b, 0x32, 0x65, 0x7b, 0x32, 0x69, 0x7b, 0x32, 0x6f,
    0x7b, 0x32, 0x73, 0x7b, 0x32, 0x74, 0x7b, 0x32, 0x20, 0x7b, 0x32, 0x25,
    0x7b, 0x32, 0x2d, 0x7b, 0x32, 0x2e, 0x7b, 0x32, 0x2f, 0x7b, 0x32, 0x33,
    0x7b, 0x32, 0x34, 0x7b, 0x32, 0x35, 0x7b, 0x32, 0x36, 0x7b, 0x32, 0x37,
    0x7b, 0x32, 0x38, 0x7b, 0x32, 0x39, 0x7b, 0x32, 0x3d, 0x7b, 0x32, 0x41,
    0x7b, 0x32, 0x5f, 0x7b, 0x32, 0x62, 0x7b, 0x32, 0x64, 0x7b, 0x32, 0x66,
    0x7b, 0x32, 0x67, 0x7b, 0x32, 0x68, 0x7b, 0x32, 0x6c, 0x7b, 0x32, 0x6d,
    0x7b, 0x32, 0x6e, 0x7b, 0x32, 0x70, 0x7b, 0x32, 0x72, 0x7b, 0x32, 0x75,
    0x7b, 0x61, 0x30, 0x7b, 0x61, 0x31, 0x7b, 0x61, 0x32, 0x7b, 0x61, 0x61,
    0x7b, 0x61, 0x63, 0x7b, 0x61, 0x65, 0x7b, 0x61, 0x69, 0x7b, 0x61, 0x6f,
    0x7b, 0x61, 0x73, 0x7b, 0x61, 0x74, 0x7b, 0x61, 0x20, 0x7b, 0x61, 0x25,
    0x7b, 0x61, 0x2d, 0x7b, 0x61, 0x2e, 0x7b, 0x61, 0x2f, 0x7b, 0x61, 0x33,
    0x7b, 0x61, 0x34, 0x7b, 0x61, 0x35, 0x7b, 0x61, 0x36, 0x7b, 0x61, 0x37,
    0x7b, 0x61, 0x38, 0x7b, 0x61, 0x39, 0x7b, 0x61, 0x3d, 0x7b, 0x61, 0x41,
    0x7b, 0x61, 0x5f, 0x7b, 0x61, 0x62, 0x7b, 0x61, 0x64, 0x7b, 0x61, 0x66,
    0x7b, 0x61, 0x67, 0x7b, 0x61, 0x68, 0x7b, 0x61, 0x6c, 0x7b, 0x61, 0x6d,
    0x7b, 0x61, 0x6e, 0x7b, 0x61, 0x70, 0x7b, 0x61, 0x72, 0x7b, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table23_34_emit_[216] = {
    0x7b, 0x63, 0x30, 0x7b, 0x63, 0x31, 0x7b, 0x63, 0x32, 0x7b, 0x63, 0x61,
    0x7b, 0x63, 0x63, 0x7b, 0x63, 0x65, 0x7b, 0x63, 0x69, 0x7b, 0x63, 0x6f,
    0x7b, 0x63, 0x73, 0x7b, 0x63, 0x74, 0x7b, 0x63, 0x20, 0x7b, 0x63, 0x25,
    0x7b, 0x63, 0x2d, 0x7b, 0x63, 0x2e, 0x7b, 0x63, 0x2f, 0x7b, 0x63, 0x33,
    0x7b, 0x63, 0x34, 0x7b, 0x63, 0x35, 0x7b, 0x63, 0x36, 0x7b, 0x63, 0x37,
    0x7b, 0x63, 0x38, 0x7b, 0x63, 0x39, 0x7b, 0x63, 0x3d, 0x7b, 0x63, 0x41,
    0x7b, 0x63, 0x5f, 0x7b, 0x63, 0x62, 0x7b, 0x63, 0x64, 0x7b, 0x63, 0x66,
    0x7b, 0x63, 0x67, 0x7b, 0x63, 0x68, 0x7b, 0x63, 0x6c, 0x7b, 0x63, 0x6d,
    0x7b, 0x63, 0x6e, 0x7b, 0x63, 0x70, 0x7b, 0x63, 0x72, 0x7b, 0x63, 0x75,
    0x7b, 0x65, 0x30, 0x7b, 0x65, 0x31, 0x7b, 0x65, 0x32, 0x7b, 0x65, 0x61,
    0x7b, 0x65, 0x63, 0x7b, 0x65, 0x65, 0x7b, 0x65, 0x69, 0x7b, 0x65, 0x6f,
    0x7b, 0x65, 0x73, 0x7b, 0x65, 0x74, 0x7b, 0x65, 0x20, 0x7b, 0x65, 0x25,
    0x7b, 0x65, 0x2d, 0x7b, 0x65, 0x2e, 0x7b, 0x65, 0x2f, 0x7b, 0x65, 0x33,
    0x7b, 0x65, 0x34, 0x7b, 0x65, 0x35, 0x7b, 0x65, 0x36, 0x7b, 0x65, 0x37,
    0x7b, 0x65, 0x38, 0x7b, 0x65, 0x39, 0x7b, 0x65, 0x3d, 0x7b, 0x65, 0x41,
    0x7b, 0x65, 0x5f, 0x7b, 0x65, 0x62, 0x7b, 0x65, 0x64, 0x7b, 0x65, 0x66,
    0x7b, 0x65, 0x67, 0x7b, 0x65, 0x68, 0x7b, 0x65, 0x6c, 0x7b, 0x65, 0x6d,
    0x7b, 0x65, 0x6e, 0x7b, 0x65, 0x70, 0x7b, 0x65, 0x72, 0x7b, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table23_35_emit_[216] = {
    0x7b, 0x69, 0x30, 0x7b, 0x69, 0x31, 0x7b, 0x69, 0x32, 0x7b, 0x69, 0x61,
    0x7b, 0x69, 0x63, 0x7b, 0x69, 0x65, 0x7b, 0x69, 0x69, 0x7b, 0x69, 0x6f,
    0x7b, 0x69, 0x73, 0x7b, 0x69, 0x74, 0x7b, 0x69, 0x20, 0x7b, 0x69, 0x25,
    0x7b, 0x69, 0x2d, 0x7b, 0x69, 0x2e, 0x7b, 0x69, 0x2f, 0x7b, 0x69, 0x33,
    0x7b, 0x69, 0x34, 0x7b, 0x69, 0x35, 0x7b, 0x69, 0x36, 0x7b, 0x69, 0x37,
    0x7b, 0x69, 0x38, 0x7b, 0x69, 0x39, 0x7b, 0x69, 0x3d, 0x7b, 0x69, 0x41,
    0x7b, 0x69, 0x5f, 0x7b, 0x69, 0x62, 0x7b, 0x69, 0x64, 0x7b, 0x69, 0x66,
    0x7b, 0x69, 0x67, 0x7b, 0x69, 0x68, 0x7b, 0x69, 0x6c, 0x7b, 0x69, 0x6d,
    0x7b, 0x69, 0x6e, 0x7b, 0x69, 0x70, 0x7b, 0x69, 0x72, 0x7b, 0x69, 0x75,
    0x7b, 0x6f, 0x30, 0x7b, 0x6f, 0x31, 0x7b, 0x6f, 0x32, 0x7b, 0x6f, 0x61,
    0x7b, 0x6f, 0x63, 0x7b, 0x6f, 0x65, 0x7b, 0x6f, 0x69, 0x7b, 0x6f, 0x6f,
    0x7b, 0x6f, 0x73, 0x7b, 0x6f, 0x74, 0x7b, 0x6f, 0x20, 0x7b, 0x6f, 0x25,
    0x7b, 0x6f, 0x2d, 0x7b, 0x6f, 0x2e, 0x7b, 0x6f, 0x2f, 0x7b, 0x6f, 0x33,
    0x7b, 0x6f, 0x34, 0x7b, 0x6f, 0x35, 0x7b, 0x6f, 0x36, 0x7b, 0x6f, 0x37,
    0x7b, 0x6f, 0x38, 0x7b, 0x6f, 0x39, 0x7b, 0x6f, 0x3d, 0x7b, 0x6f, 0x41,
    0x7b, 0x6f, 0x5f, 0x7b, 0x6f, 0x62, 0x7b, 0x6f, 0x64, 0x7b, 0x6f, 0x66,
    0x7b, 0x6f, 0x67, 0x7b, 0x6f, 0x68, 0x7b, 0x6f, 0x6c, 0x7b, 0x6f, 0x6d,
    0x7b, 0x6f, 0x6e, 0x7b, 0x6f, 0x70, 0x7b, 0x6f, 0x72, 0x7b, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table23_36_emit_[216] = {
    0x7b, 0x73, 0x30, 0x7b, 0x73, 0x31, 0x7b, 0x73, 0x32, 0x7b, 0x73, 0x61,
    0x7b, 0x73, 0x63, 0x7b, 0x73, 0x65, 0x7b, 0x73, 0x69, 0x7b, 0x73, 0x6f,
    0x7b, 0x73, 0x73, 0x7b, 0x73, 0x74, 0x7b, 0x73, 0x20, 0x7b, 0x73, 0x25,
    0x7b, 0x73, 0x2d, 0x7b, 0x73, 0x2e, 0x7b, 0x73, 0x2f, 0x7b, 0x73, 0x33,
    0x7b, 0x73, 0x34, 0x7b, 0x73, 0x35, 0x7b, 0x73, 0x36, 0x7b, 0x73, 0x37,
    0x7b, 0x73, 0x38, 0x7b, 0x73, 0x39, 0x7b, 0x73, 0x3d, 0x7b, 0x73, 0x41,
    0x7b, 0x73, 0x5f, 0x7b, 0x73, 0x62, 0x7b, 0x73, 0x64, 0x7b, 0x73, 0x66,
    0x7b, 0x73, 0x67, 0x7b, 0x73, 0x68, 0x7b, 0x73, 0x6c, 0x7b, 0x73, 0x6d,
    0x7b, 0x73, 0x6e, 0x7b, 0x73, 0x70, 0x7b, 0x73, 0x72, 0x7b, 0x73, 0x75,
    0x7b, 0x74, 0x30, 0x7b, 0x74, 0x31, 0x7b, 0x74, 0x32, 0x7b, 0x74, 0x61,
    0x7b, 0x74, 0x63, 0x7b, 0x74, 0x65, 0x7b, 0x74, 0x69, 0x7b, 0x74, 0x6f,
    0x7b, 0x74, 0x73, 0x7b, 0x74, 0x74, 0x7b, 0x74, 0x20, 0x7b, 0x74, 0x25,
    0x7b, 0x74, 0x2d, 0x7b, 0x74, 0x2e, 0x7b, 0x74, 0x2f, 0x7b, 0x74, 0x33,
    0x7b, 0x74, 0x34, 0x7b, 0x74, 0x35, 0x7b, 0x74, 0x36, 0x7b, 0x74, 0x37,
    0x7b, 0x74, 0x38, 0x7b, 0x74, 0x39, 0x7b, 0x74, 0x3d, 0x7b, 0x74, 0x41,
    0x7b, 0x74, 0x5f, 0x7b, 0x74, 0x62, 0x7b, 0x74, 0x64, 0x7b, 0x74, 0x66,
    0x7b, 0x74, 0x67, 0x7b, 0x74, 0x68, 0x7b, 0x74, 0x6c, 0x7b, 0x74, 0x6d,
    0x7b, 0x74, 0x6e, 0x7b, 0x74, 0x70, 0x7b, 0x74, 0x72, 0x7b, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table23_37_emit_[120] = {
    0x7b, 0x20, 0x30, 0x7b, 0x20, 0x31, 0x7b, 0x20, 0x32, 0x7b, 0x20, 0x61,
    0x7b, 0x20, 0x63, 0x7b, 0x20, 0x65, 0x7b, 0x20, 0x69, 0x7b, 0x20, 0x6f,
    0x7b, 0x20, 0x73, 0x7b, 0x20, 0x74, 0x7b, 0x25, 0x30, 0x7b, 0x25, 0x31,
    0x7b, 0x25, 0x32, 0x7b, 0x25, 0x61, 0x7b, 0x25, 0x63, 0x7b, 0x25, 0x65,
    0x7b, 0x25, 0x69, 0x7b, 0x25, 0x6f, 0x7b, 0x25, 0x73, 0x7b, 0x25, 0x74,
    0x7b, 0x2d, 0x30, 0x7b, 0x2d, 0x31, 0x7b, 0x2d, 0x32, 0x7b, 0x2d, 0x61,
    0x7b, 0x2d, 0x63, 0x7b, 0x2d, 0x65, 0x7b, 0x2d, 0x69, 0x7b, 0x2d, 0x6f,
    0x7b, 0x2d, 0x73, 0x7b, 0x2d, 0x74, 0x7b, 0x2e, 0x30, 0x7b, 0x2e, 0x31,
    0x7b, 0x2e, 0x32, 0x7b, 0x2e, 0x61, 0x7b, 0x2e, 0x63, 0x7b, 0x2e, 0x65,
    0x7b, 0x2e, 0x69, 0x7b, 0x2e, 0x6f, 0x7b, 0x2e, 0x73, 0x7b, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table23_38_emit_[120] = {
    0x7b, 0x2f, 0x30, 0x7b, 0x2f, 0x31, 0x7b, 0x2f, 0x32, 0x7b, 0x2f, 0x61,
    0x7b, 0x2f, 0x63, 0x7b, 0x2f, 0x65, 0x7b, 0x2f, 0x69, 0x7b, 0x2f, 0x6f,
    0x7b, 0x2f, 0x73, 0x7b, 0x2f, 0x74, 0x7b, 0x33, 0x30, 0x7b, 0x33, 0x31,
    0x7b, 0x33, 0x32, 0x7b, 0x33, 0x61, 0x7b, 0x33, 0x63, 0x7b, 0x33, 0x65,
    0x7b, 0x33, 0x69, 0x7b, 0x33, 0x6f, 0x7b, 0x33, 0x73, 0x7b, 0x33, 0x74,
    0x7b, 0x34, 0x30, 0x7b, 0x34, 0x31, 0x7b, 0x34, 0x32, 0x7b, 0x34, 0x61,
    0x7b, 0x34, 0x63, 0x7b, 0x34, 0x65, 0x7b, 0x34, 0x69, 0x7b, 0x34, 0x6f,
    0x7b, 0x34, 0x73, 0x7b, 0x34, 0x74, 0x7b, 0x35, 0x30, 0x7b, 0x35, 0x31,
    0x7b, 0x35, 0x32, 0x7b, 0x35, 0x61, 0x7b, 0x35, 0x63, 0x7b, 0x35, 0x65,
    0x7b, 0x35, 0x69, 0x7b, 0x35, 0x6f, 0x7b, 0x35, 0x73, 0x7b, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table23_39_emit_[120] = {
    0x7b, 0x36, 0x30, 0x7b, 0x36, 0x31, 0x7b, 0x36, 0x32, 0x7b, 0x36, 0x61,
    0x7b, 0x36, 0x63, 0x7b, 0x36, 0x65, 0x7b, 0x36, 0x69, 0x7b, 0x36, 0x6f,
    0x7b, 0x36, 0x73, 0x7b, 0x36, 0x74, 0x7b, 0x37, 0x30, 0x7b, 0x37, 0x31,
    0x7b, 0x37, 0x32, 0x7b, 0x37, 0x61, 0x7b, 0x37, 0x63, 0x7b, 0x37, 0x65,
    0x7b, 0x37, 0x69, 0x7b, 0x37, 0x6f, 0x7b, 0x37, 0x73, 0x7b, 0x37, 0x74,
    0x7b, 0x38, 0x30, 0x7b, 0x38, 0x31, 0x7b, 0x38, 0x32, 0x7b, 0x38, 0x61,
    0x7b, 0x38, 0x63, 0x7b, 0x38, 0x65, 0x7b, 0x38, 0x69, 0x7b, 0x38, 0x6f,
    0x7b, 0x38, 0x73, 0x7b, 0x38, 0x74, 0x7b, 0x39, 0x30, 0x7b, 0x39, 0x31,
    0x7b, 0x39, 0x32, 0x7b, 0x39, 0x61, 0x7b, 0x39, 0x63, 0x7b, 0x39, 0x65,
    0x7b, 0x39, 0x69, 0x7b, 0x39, 0x6f, 0x7b, 0x39, 0x73, 0x7b, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table23_40_emit_[120] = {
    0x7b, 0x3d, 0x30, 0x7b, 0x3d, 0x31, 0x7b, 0x3d, 0x32, 0x7b, 0x3d, 0x61,
    0x7b, 0x3d, 0x63, 0x7b, 0x3d, 0x65, 0x7b, 0x3d, 0x69, 0x7b, 0x3d, 0x6f,
    0x7b, 0x3d, 0x73, 0x7b, 0x3d, 0x74, 0x7b, 0x41, 0x30, 0x7b, 0x41, 0x31,
    0x7b, 0x41, 0x32, 0x7b, 0x41, 0x61, 0x7b, 0x41, 0x63, 0x7b, 0x41, 0x65,
    0x7b, 0x41, 0x69, 0x7b, 0x41, 0x6f, 0x7b, 0x41, 0x73, 0x7b, 0x41, 0x74,
    0x7b, 0x5f, 0x30, 0x7b, 0x5f, 0x31, 0x7b, 0x5f, 0x32, 0x7b, 0x5f, 0x61,
    0x7b, 0x5f, 0x63, 0x7b, 0x5f, 0x65, 0x7b, 0x5f, 0x69, 0x7b, 0x5f, 0x6f,
    0x7b, 0x5f, 0x73, 0x7b, 0x5f, 0x74, 0x7b, 0x62, 0x30, 0x7b, 0x62, 0x31,
    0x7b, 0x62, 0x32, 0x7b, 0x62, 0x61, 0x7b, 0x62, 0x63, 0x7b, 0x62, 0x65,
    0x7b, 0x62, 0x69, 0x7b, 0x62, 0x6f, 0x7b, 0x62, 0x73, 0x7b, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table23_41_emit_[120] = {
    0x7b, 0x64, 0x30, 0x7b, 0x64, 0x31, 0x7b, 0x64, 0x32, 0x7b, 0x64, 0x61,
    0x7b, 0x64, 0x63, 0x7b, 0x64, 0x65, 0x7b, 0x64, 0x69, 0x7b, 0x64, 0x6f,
    0x7b, 0x64, 0x73, 0x7b, 0x64, 0x74, 0x7b, 0x66, 0x30, 0x7b, 0x66, 0x31,
    0x7b, 0x66, 0x32, 0x7b, 0x66, 0x61, 0x7b, 0x66, 0x63, 0x7b, 0x66, 0x65,
    0x7b, 0x66, 0x69, 0x7b, 0x66, 0x6f, 0x7b, 0x66, 0x73, 0x7b, 0x66, 0x74,
    0x7b, 0x67, 0x30, 0x7b, 0x67, 0x31, 0x7b, 0x67, 0x32, 0x7b, 0x67, 0x61,
    0x7b, 0x67, 0x63, 0x7b, 0x67, 0x65, 0x7b, 0x67, 0x69, 0x7b, 0x67, 0x6f,
    0x7b, 0x67, 0x73, 0x7b, 0x67, 0x74, 0x7b, 0x68, 0x30, 0x7b, 0x68, 0x31,
    0x7b, 0x68, 0x32, 0x7b, 0x68, 0x61, 0x7b, 0x68, 0x63, 0x7b, 0x68, 0x65,
    0x7b, 0x68, 0x69, 0x7b, 0x68, 0x6f, 0x7b, 0x68, 0x73, 0x7b, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table23_42_emit_[120] = {
    0x7b, 0x6c, 0x30, 0x7b, 0x6c, 0x31, 0x7b, 0x6c, 0x32, 0x7b, 0x6c, 0x61,
    0x7b, 0x6c, 0x63, 0x7b, 0x6c, 0x65, 0x7b, 0x6c, 0x69, 0x7b, 0x6c, 0x6f,
    0x7b, 0x6c, 0x73, 0x7b, 0x6c, 0x74, 0x7b, 0x6d, 0x30, 0x7b, 0x6d, 0x31,
    0x7b, 0x6d, 0x32, 0x7b, 0x6d, 0x61, 0x7b, 0x6d, 0x63, 0x7b, 0x6d, 0x65,
    0x7b, 0x6d, 0x69, 0x7b, 0x6d, 0x6f, 0x7b, 0x6d, 0x73, 0x7b, 0x6d, 0x74,
    0x7b, 0x6e, 0x30, 0x7b, 0x6e, 0x31, 0x7b, 0x6e, 0x32, 0x7b, 0x6e, 0x61,
    0x7b, 0x6e, 0x63, 0x7b, 0x6e, 0x65, 0x7b, 0x6e, 0x69, 0x7b, 0x6e, 0x6f,
    0x7b, 0x6e, 0x73, 0x7b, 0x6e, 0x74, 0x7b, 0x70, 0x30, 0x7b, 0x70, 0x31,
    0x7b, 0x70, 0x32, 0x7b, 0x70, 0x61, 0x7b, 0x70, 0x63, 0x7b, 0x70, 0x65,
    0x7b, 0x70, 0x69, 0x7b, 0x70, 0x6f, 0x7b, 0x70, 0x73, 0x7b, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table23_43_emit_[68] = {
    0x7b, 0x72, 0x30, 0x7b, 0x72, 0x31, 0x7b, 0x72, 0x32, 0x7b, 0x72, 0x61,
    0x7b, 0x72, 0x63, 0x7b, 0x72, 0x65, 0x7b, 0x72, 0x69, 0x7b, 0x72, 0x6f,
    0x7b, 0x72, 0x73, 0x7b, 0x72, 0x74, 0x7b, 0x75, 0x30, 0x7b, 0x75, 0x31,
    0x7b, 0x75, 0x32, 0x7b, 0x75, 0x61, 0x7b, 0x75, 0x63, 0x7b, 0x75, 0x65,
    0x7b, 0x75, 0x69, 0x7b, 0x75, 0x6f, 0x7b, 0x75, 0x73, 0x7b, 0x75, 0x74,
    0x7b, 0x3a, 0x7b, 0x42, 0x7b, 0x43, 0x7b, 0x44};
const uint8_t HuffDecoderCommon::table23_47_emit_[36] = {
    0x7b, 0x77, 0x7b, 0x78, 0x7b, 0x79, 0x7b, 0x7a, 0x7b, 0x26, 0x7b, 0x2a,
    0x7b, 0x2c, 0x7b, 0x3b, 0x7b, 0x58, 0x7b, 0x5a, 0x7b, 0x21, 0x7b, 0x22,
    0x7b, 0x28, 0x7b, 0x29, 0x7b, 0x3f, 0x7b, 0x27, 0x7b, 0x2b, 0x7b, 0x7c};
const uint8_t HuffDecoderCommon::table23_48_emit_[136] = {
    0x5c, 0x30, 0x5c, 0x31, 0x5c, 0x32, 0x5c, 0x61, 0x5c, 0x63, 0x5c, 0x65,
    0x5c, 0x69, 0x5c, 0x6f, 0x5c, 0x73, 0x5c, 0x74, 0x5c, 0x20, 0x5c, 0x25,
    0x5c, 0x2d, 0x5c, 0x2e, 0x5c, 0x2f, 0x5c, 0x33, 0x5c, 0x34, 0x5c, 0x35,
    0x5c, 0x36, 0x5c, 0x37, 0x5c, 0x38, 0x5c, 0x39, 0x5c, 0x3d, 0x5c, 0x41,
    0x5c, 0x5f, 0x5c, 0x62, 0x5c, 0x64, 0x5c, 0x66, 0x5c, 0x67, 0x5c, 0x68,
    0x5c, 0x6c, 0x5c, 0x6d, 0x5c, 0x6e, 0x5c, 0x70, 0x5c, 0x72, 0x5c, 0x75,
    0x5c, 0x3a, 0x5c, 0x42, 0x5c, 0x43, 0x5c, 0x44, 0x5c, 0x45, 0x5c, 0x46,
    0x5c, 0x47, 0x5c, 0x48, 0x5c, 0x49, 0x5c, 0x4a, 0x5c, 0x4b, 0x5c, 0x4c,
    0x5c, 0x4d, 0x5c, 0x4e, 0x5c, 0x4f, 0x5c, 0x50, 0x5c, 0x51, 0x5c, 0x52,
    0x5c, 0x53, 0x5c, 0x54, 0x5c, 0x55, 0x5c, 0x56, 0x5c, 0x57, 0x5c, 0x59,
    0x5c, 0x6a, 0x5c, 0x6b, 0x5c, 0x71, 0x5c, 0x76, 0x5c, 0x77, 0x5c, 0x78,
    0x5c, 0x79, 0x5c, 0x7a};
const uint16_t HuffDecoderCommon::table23_48_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000,
    0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0062, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x00a2, 0x0000, 0x00b2, 0x0000,
    0x00c2, 0x0000, 0x00d2, 0x0000, 0x00e2, 0x0000, 0x00f2, 0x0000, 0x0102,
    0x0000, 0x0112, 0x0000, 0x0122, 0x0000, 0x0132, 0x0000, 0x0142, 0x0000,
    0x0152, 0x0000, 0x0162, 0x0000, 0x0172, 0x0000, 0x0182, 0x0000, 0x0192,
    0x0000, 0x01a2, 0x0000, 0x01b2, 0x0000, 0x01c2, 0x0000, 0x01d2, 0x0000,
    0x01e2, 0x0000, 0x01f2, 0x0000, 0x0202, 0x0000, 0x0212, 0x0000, 0x0222,
    0x0000, 0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2,
    0x02b2, 0x02c2, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332,
    0x0342, 0x0352, 0x0362, 0x0372, 0x0382, 0x0392, 0x03a2, 0x03b2, 0x03c2,
    0x03d2, 0x03e2, 0x03f2, 0x0402, 0x0412, 0x0422, 0x0432, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table23_49_emit_[136] = {
    0xc3, 0x30, 0xc3, 0x31, 0xc3, 0x32, 0xc3, 0x61, 0xc3, 0x63, 0xc3, 0x65,
    0xc3, 0x69, 0xc3, 0x6f, 0xc3, 0x73, 0xc3, 0x74, 0xc3, 0x20, 0xc3, 0x25,
    0xc3, 0x2d, 0xc3, 0x2e, 0xc3, 0x2f, 0xc3, 0x33, 0xc3, 0x34, 0xc3, 0x35,
    0xc3, 0x36, 0xc3, 0x37, 0xc3, 0x38, 0xc3, 0x39, 0xc3, 0x3d, 0xc3, 0x41,
    0xc3, 0x5f, 0xc3, 0x62, 0xc3, 0x64, 0xc3, 0x66, 0xc3, 0x67, 0xc3, 0x68,
    0xc3, 0x6c, 0xc3, 0x6d, 0xc3, 0x6e, 0xc3, 0x70, 0xc3, 0x72, 0xc3, 0x75,
    0xc3, 0x3a, 0xc3, 0x42, 0xc3, 0x43, 0xc3, 0x44, 0xc3, 0x45, 0xc3, 0x46,
    0xc3, 0x47, 0xc3, 0x48, 0xc3, 0x49, 0xc3, 0x4a, 0xc3, 0x4b, 0xc3, 0x4c,
    0xc3, 0x4d, 0xc3, 0x4e, 0xc3, 0x4f, 0xc3, 0x50, 0xc3, 0x51, 0xc3, 0x52,
    0xc3, 0x53, 0xc3, 0x54, 0xc3, 0x55, 0xc3, 0x56, 0xc3, 0x57, 0xc3, 0x59,
    0xc3, 0x6a, 0xc3, 0x6b, 0xc3, 0x71, 0xc3, 0x76, 0xc3, 0x77, 0xc3, 0x78,
    0xc3, 0x79, 0xc3, 0x7a};
const uint8_t HuffDecoderCommon::table23_50_emit_[136] = {
    0xd0, 0x30, 0xd0, 0x31, 0xd0, 0x32, 0xd0, 0x61, 0xd0, 0x63, 0xd0, 0x65,
    0xd0, 0x69, 0xd0, 0x6f, 0xd0, 0x73, 0xd0, 0x74, 0xd0, 0x20, 0xd0, 0x25,
    0xd0, 0x2d, 0xd0, 0x2e, 0xd0, 0x2f, 0xd0, 0x33, 0xd0, 0x34, 0xd0, 0x35,
    0xd0, 0x36, 0xd0, 0x37, 0xd0, 0x38, 0xd0, 0x39, 0xd0, 0x3d, 0xd0, 0x41,
    0xd0, 0x5f, 0xd0, 0x62, 0xd0, 0x64, 0xd0, 0x66, 0xd0, 0x67, 0xd0, 0x68,
    0xd0, 0x6c, 0xd0, 0x6d, 0xd0, 0x6e, 0xd0, 0x70, 0xd0, 0x72, 0xd0, 0x75,
    0xd0, 0x3a, 0xd0, 0x42, 0xd0, 0x43, 0xd0, 0x44, 0xd0, 0x45, 0xd0, 0x46,
    0xd0, 0x47, 0xd0, 0x48, 0xd0, 0x49, 0xd0, 0x4a, 0xd0, 0x4b, 0xd0, 0x4c,
    0xd0, 0x4d, 0xd0, 0x4e, 0xd0, 0x4f, 0xd0, 0x50, 0xd0, 0x51, 0xd0, 0x52,
    0xd0, 0x53, 0xd0, 0x54, 0xd0, 0x55, 0xd0, 0x56, 0xd0, 0x57, 0xd0, 0x59,
    0xd0, 0x6a, 0xd0, 0x6b, 0xd0, 0x71, 0xd0, 0x76, 0xd0, 0x77, 0xd0, 0x78,
    0xd0, 0x79, 0xd0, 0x7a};
const uint8_t HuffDecoderCommon::table23_51_emit_[144] = {
    0x80, 0x30, 0x80, 0x31, 0x80, 0x32, 0x80, 0x61, 0x80, 0x63, 0x80, 0x65,
    0x80, 0x69, 0x80, 0x6f, 0x80, 0x73, 0x80, 0x74, 0x80, 0x20, 0x80, 0x25,
    0x80, 0x2d, 0x80, 0x2e, 0x80, 0x2f, 0x80, 0x33, 0x80, 0x34, 0x80, 0x35,
    0x80, 0x36, 0x80, 0x37, 0x80, 0x38, 0x80, 0x39, 0x80, 0x3d, 0x80, 0x41,
    0x80, 0x5f, 0x80, 0x62, 0x80, 0x64, 0x80, 0x66, 0x80, 0x67, 0x80, 0x68,
    0x80, 0x6c, 0x80, 0x6d, 0x80, 0x6e, 0x80, 0x70, 0x80, 0x72, 0x80, 0x75,
    0x82, 0x30, 0x82, 0x31, 0x82, 0x32, 0x82, 0x61, 0x82, 0x63, 0x82, 0x65,
    0x82, 0x69, 0x82, 0x6f, 0x82, 0x73, 0x82, 0x74, 0x82, 0x20, 0x82, 0x25,
    0x82, 0x2d, 0x82, 0x2e, 0x82, 0x2f, 0x82, 0x33, 0x82, 0x34, 0x82, 0x35,
    0x82, 0x36, 0x82, 0x37, 0x82, 0x38, 0x82, 0x39, 0x82, 0x3d, 0x82, 0x41,
    0x82, 0x5f, 0x82, 0x62, 0x82, 0x64, 0x82, 0x66, 0x82, 0x67, 0x82, 0x68,
    0x82, 0x6c, 0x82, 0x6d, 0x82, 0x6e, 0x82, 0x70, 0x82, 0x72, 0x82, 0x75};
const uint16_t HuffDecoderCommon::table23_51_ops_[128] = {
    0x0000, 0x0002, 0x0000, 0x0012, 0x0000, 0x0022, 0x0000, 0x0032, 0x0000,
    0x0042, 0x0000, 0x0052, 0x0000, 0x0062, 0x0000, 0x0072, 0x0000, 0x0082,
    0x0000, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0003, 0x0000, 0x0242, 0x0000, 0x0252, 0x0000, 0x0262, 0x0000, 0x0272,
    0x0000, 0x0282, 0x0000, 0x0292, 0x0000, 0x02a2, 0x0000, 0x02b2, 0x0000,
    0x02c2, 0x0000, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332,
    0x0342, 0x0352, 0x0362, 0x0372, 0x0382, 0x0392, 0x03a2, 0x03b2, 0x03c2,
    0x03d2, 0x03e2, 0x03f2, 0x0402, 0x0412, 0x0422, 0x0432, 0x0442, 0x0452,
    0x0462, 0x0472, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0243};
const uint8_t HuffDecoderCommon::table23_52_emit_[144] = {
    0x83, 0x30, 0x83, 0x31, 0x83, 0x32, 0x83, 0x61, 0x83, 0x63, 0x83, 0x65,
    0x83, 0x69, 0x83, 0x6f, 0x83, 0x73, 0x83, 0x74, 0x83, 0x20, 0x83, 0x25,
    0x83, 0x2d, 0x83, 0x2e, 0x83, 0x2f, 0x83, 0x33, 0x83, 0x34, 0x83, 0x35,
    0x83, 0x36, 0x83, 0x37, 0x83, 0x38, 0x83, 0x39, 0x83, 0x3d, 0x83, 0x41,
    0x83, 0x5f, 0x83, 0x62, 0x83, 0x64, 0x83, 0x66, 0x83, 0x67, 0x83, 0x68,
    0x83, 0x6c, 0x83, 0x6d, 0x83, 0x6e, 0x83, 0x70, 0x83, 0x72, 0x83, 0x75,
    0xa2, 0x30, 0xa2, 0x31, 0xa2, 0x32, 0xa2, 0x61, 0xa2, 0x63, 0xa2, 0x65,
    0xa2, 0x69, 0xa2, 0x6f, 0xa2, 0x73, 0xa2, 0x74, 0xa2, 0x20, 0xa2, 0x25,
    0xa2, 0x2d, 0xa2, 0x2e, 0xa2, 0x2f, 0xa2, 0x33, 0xa2, 0x34, 0xa2, 0x35,
    0xa2, 0x36, 0xa2, 0x37, 0xa2, 0x38, 0xa2, 0x39, 0xa2, 0x3d, 0xa2, 0x41,
    0xa2, 0x5f, 0xa2, 0x62, 0xa2, 0x64, 0xa2, 0x66, 0xa2, 0x67, 0xa2, 0x68,
    0xa2, 0x6c, 0xa2, 0x6d, 0xa2, 0x6e, 0xa2, 0x70, 0xa2, 0x72, 0xa2, 0x75};
const uint8_t HuffDecoderCommon::table23_53_emit_[144] = {
    0xb8, 0x30, 0xb8, 0x31, 0xb8, 0x32, 0xb8, 0x61, 0xb8, 0x63, 0xb8, 0x65,
    0xb8, 0x69, 0xb8, 0x6f, 0xb8, 0x73, 0xb8, 0x74, 0xb8, 0x20, 0xb8, 0x25,
    0xb8, 0x2d, 0xb8, 0x2e, 0xb8, 0x2f, 0xb8, 0x33, 0xb8, 0x34, 0xb8, 0x35,
    0xb8, 0x36, 0xb8, 0x37, 0xb8, 0x38, 0xb8, 0x39, 0xb8, 0x3d, 0xb8, 0x41,
    0xb8, 0x5f, 0xb8, 0x62, 0xb8, 0x64, 0xb8, 0x66, 0xb8, 0x67, 0xb8, 0x68,
    0xb8, 0x6c, 0xb8, 0x6d, 0xb8, 0x6e, 0xb8, 0x70, 0xb8, 0x72, 0xb8, 0x75,
    0xc2, 0x30, 0xc2, 0x31, 0xc2, 0x32, 0xc2, 0x61, 0xc2, 0x63, 0xc2, 0x65,
    0xc2, 0x69, 0xc2, 0x6f, 0xc2, 0x73, 0xc2, 0x74, 0xc2, 0x20, 0xc2, 0x25,
    0xc2, 0x2d, 0xc2, 0x2e, 0xc2, 0x2f, 0xc2, 0x33, 0xc2, 0x34, 0xc2, 0x35,
    0xc2, 0x36, 0xc2, 0x37, 0xc2, 0x38, 0xc2, 0x39, 0xc2, 0x3d, 0xc2, 0x41,
    0xc2, 0x5f, 0xc2, 0x62, 0xc2, 0x64, 0xc2, 0x66, 0xc2, 0x67, 0xc2, 0x68,
    0xc2, 0x6c, 0xc2, 0x6d, 0xc2, 0x6e, 0xc2, 0x70, 0xc2, 0x72, 0xc2, 0x75};
const uint8_t HuffDecoderCommon::table23_54_emit_[144] = {
    0xe0, 0x30, 0xe0, 0x31, 0xe0, 0x32, 0xe0, 0x61, 0xe0, 0x63, 0xe0, 0x65,
    0xe0, 0x69, 0xe0, 0x6f, 0xe0, 0x73, 0xe0, 0x74, 0xe0, 0x20, 0xe0, 0x25,
    0xe0, 0x2d, 0xe0, 0x2e, 0xe0, 0x2f, 0xe0, 0x33, 0xe0, 0x34, 0xe0, 0x35,
    0xe0, 0x36, 0xe0, 0x37, 0xe0, 0x38, 0xe0, 0x39, 0xe0, 0x3d, 0xe0, 0x41,
    0xe0, 0x5f, 0xe0, 0x62, 0xe0, 0x64, 0xe0, 0x66, 0xe0, 0x67, 0xe0, 0x68,
    0xe0, 0x6c, 0xe0, 0x6d, 0xe0, 0x6e, 0xe0, 0x70, 0xe0, 0x72, 0xe0, 0x75,
    0xe2, 0x30, 0xe2, 0x31, 0xe2, 0x32, 0xe2, 0x61, 0xe2, 0x63, 0xe2, 0x65,
    0xe2, 0x69, 0xe2, 0x6f, 0xe2, 0x73, 0xe2, 0x74, 0xe2, 0x20, 0xe2, 0x25,
    0xe2, 0x2d, 0xe2, 0x2e, 0xe2, 0x2f, 0xe2, 0x33, 0xe2, 0x34, 0xe2, 0x35,
    0xe2, 0x36, 0xe2, 0x37, 0xe2, 0x38, 0xe2, 0x39, 0xe2, 0x3d, 0xe2, 0x41,
    0xe2, 0x5f, 0xe2, 0x62, 0xe2, 0x64, 0xe2, 0x66, 0xe2, 0x67, 0xe2, 0x68,
    0xe2, 0x6c, 0xe2, 0x6d, 0xe2, 0x6e, 0xe2, 0x70, 0xe2, 0x72, 0xe2, 0x75};
const uint8_t HuffDecoderCommon::table23_55_emit_[80] = {
    0x99, 0x30, 0x99, 0x31, 0x99, 0x32, 0x99, 0x61, 0x99, 0x63, 0x99, 0x65,
    0x99, 0x69, 0x99, 0x6f, 0x99, 0x73, 0x99, 0x74, 0xa1, 0x30, 0xa1, 0x31,
    0xa1, 0x32, 0xa1, 0x61, 0xa1, 0x63, 0xa1, 0x65, 0xa1, 0x69, 0xa1, 0x6f,
    0xa1, 0x73, 0xa1, 0x74, 0xa7, 0x30, 0xa7, 0x31, 0xa7, 0x32, 0xa7, 0x61,
    0xa7, 0x63, 0xa7, 0x65, 0xa7, 0x69, 0xa7, 0x6f, 0xa7, 0x73, 0xa7, 0x74,
    0xac, 0x30, 0xac, 0x31, 0xac, 0x32, 0xac, 0x61, 0xac, 0x63, 0xac, 0x65,
    0xac, 0x69, 0xac, 0x6f, 0xac, 0x73, 0xac, 0x74};
const uint16_t HuffDecoderCommon::table23_55_ops_[128] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072, 0x0082,
    0x0092, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x00a2, 0x00b2, 0x00c2, 0x00d2,
    0x00e2, 0x00f2, 0x0102, 0x0112, 0x0122, 0x0132, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x00a3, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192, 0x01a2, 0x01b2,
    0x01c2, 0x01d2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0143, 0x01e2, 0x01f2, 0x0202,
    0x0212, 0x0222, 0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x01e3};
const uint8_t HuffDecoderCommon::table23_56_emit_[80] = {
    0xb0, 0x30, 0xb0, 0x31, 0xb0, 0x32, 0xb0, 0x61, 0xb0, 0x63, 0xb0, 0x65,
    0xb0, 0x69, 0xb0, 0x6f, 0xb0, 0x73, 0xb0, 0x74, 0xb1, 0x30, 0xb1, 0x31,
    0xb1, 0x32, 0xb1, 0x61, 0xb1, 0x63, 0xb1, 0x65, 0xb1, 0x69, 0xb1, 0x6f,
    0xb1, 0x73, 0xb1, 0x74, 0xb3, 0x30, 0xb3, 0x31, 0xb3, 0x32, 0xb3, 0x61,
    0xb3, 0x63, 0xb3, 0x65, 0xb3, 0x69, 0xb3, 0x6f, 0xb3, 0x73, 0xb3, 0x74,
    0xd1, 0x30, 0xd1, 0x31, 0xd1, 0x32, 0xd1, 0x61, 0xd1, 0x63, 0xd1, 0x65,
    0xd1, 0x69, 0xd1, 0x6f, 0xd1, 0x73, 0xd1, 0x74};
const uint8_t HuffDecoderCommon::table23_57_emit_[80] = {
    0xd8, 0x30, 0xd8, 0x31, 0xd8, 0x32, 0xd8, 0x61, 0xd8, 0x63, 0xd8, 0x65,
    0xd8, 0x69, 0xd8, 0x6f, 0xd8, 0x73, 0xd8, 0x74, 0xd9, 0x30, 0xd9, 0x31,
    0xd9, 0x32, 0xd9, 0x61, 0xd9, 0x63, 0xd9, 0x65, 0xd9, 0x69, 0xd9, 0x6f,
    0xd9, 0x73, 0xd9, 0x74, 0xe3, 0x30, 0xe3, 0x31, 0xe3, 0x32, 0xe3, 0x61,
    0xe3, 0x63, 0xe3, 0x65, 0xe3, 0x69, 0xe3, 0x6f, 0xe3, 0x73, 0xe3, 0x74,
    0xe5, 0x30, 0xe5, 0x31, 0xe5, 0x32, 0xe5, 0x61, 0xe5, 0x63, 0xe5, 0x65,
    0xe5, 0x69, 0xe5, 0x6f, 0xe5, 0x73, 0xe5, 0x74};
const uint8_t HuffDecoderCommon::table23_58_emit_[26] = {
    0xe6, 0x30, 0xe6, 0x31, 0xe6, 0x32, 0xe6, 0x61, 0xe6,
    0x63, 0xe6, 0x65, 0xe6, 0x69, 0xe6, 0x6f, 0xe6, 0x73,
    0xe6, 0x74, 0x81, 0x84, 0x85, 0x86, 0x88, 0x92};
const uint16_t HuffDecoderCommon::table23_58_ops_[128] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072, 0x0082,
    0x0092, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x00a3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x00ab, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00b3, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00bb, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x00c3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x00cb};
const uint16_t HuffDecoderCommon::table23_59_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x001b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0023, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x002b, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x003b};
const uint16_t HuffDecoderCommon::table23_61_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x001b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0023,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x002b, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0033, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x003b, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0043, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x004b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x005b};
const uint16_t HuffDecoderCommon::table23_62_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0013, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x001b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0023, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x002b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x003b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0043,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x004b, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0053, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x005b, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0063, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x006b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x007b};
const uint8_t HuffDecoderCommon::table23_63_emit_[36] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f, 0xab,
    0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb, 0xc0, 0xc1, 0xc8,
    0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff};
const uint16_t HuffDecoderCommon::table23_63_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0013, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x001b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0023, 0x0000, 0x0000, 0x0000, 0x002b, 0x0000,
    0x0000, 0x0000, 0x0033, 0x0000, 0x0000, 0x0000, 0x003b, 0x0000, 0x0000,
    0x0000, 0x0043, 0x0000, 0x0000, 0x0000, 0x004b, 0x0000, 0x0000, 0x0000,
    0x0053, 0x0000, 0x0000, 0x0000, 0x005b, 0x0000, 0x0000, 0x0000, 0x0063,
    0x0000, 0x0000, 0x0000, 0x006b, 0x0000, 0x0000, 0x0000, 0x0073, 0x0000,
    0x0000, 0x0000, 0x007b, 0x0000, 0x0000, 0x0000, 0x0083, 0x0000, 0x008b,
    0x0000, 0x0093, 0x0000, 0x009b, 0x0000, 0x00a3, 0x00ab, 0x00b3, 0x00bb,
    0x00c3, 0x00cb, 0x00d3, 0x00db, 0x00e3, 0x00eb, 0x00f3, 0x00fb, 0x0103,
    0x010b, 0x0113, 0x011b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0004};
const uint8_t* const HuffDecoderCommon::table23_emit_[64] = {
    table23_0_emit_,  table23_1_emit_,  table23_2_emit_,  table23_3_emit_,
    table23_4_emit_,  table23_5_emit_,  table23_6_emit_,  table23_7_emit_,
    table23_8_emit_,  table23_9_emit_,  table23_10_emit_, table23_11_emit_,
    table22_12_emit_, table22_13_emit_, table22_14_emit_, table23_15_emit_,
    table23_16_emit_, table23_17_emit_, table23_18_emit_, table23_19_emit_,
    table23_20_emit_, table23_21_emit_, table23_22_emit_, table23_23_emit_,
    table23_24_emit_, table23_25_emit_, table23_26_emit_, table23_27_emit_,
    table22_28_emit_, table22_29_emit_, table22_30_emit_, table23_31_emit_,
    table23_32_emit_, table23_33_emit_, table23_34_emit_, table23_35_emit_,
    table23_36_emit_, table23_37_emit_, table23_38_emit_, table23_39_emit_,
    table23_40_emit_, table23_41_emit_, table23_42_emit_, table23_43_emit_,
    table22_44_emit_, table22_45_emit_, table22_46_emit_, table23_47_emit_,
    table23_48_emit_, table23_49_emit_, table23_50_emit_, table23_51_emit_,
    table23_52_emit_, table23_53_emit_, table23_54_emit_, table23_55_emit_,
    table23_56_emit_, table23_57_emit_, table23_58_emit_, table22_59_emit_,
    table22_60_emit_, table22_61_emit_, table22_62_emit_, table23_63_emit_,
};
const uint16_t* const HuffDecoderCommon::table23_ops_[64] = {
    table23_0_ops_,  table23_0_ops_,  table23_0_ops_,  table23_0_ops_,
    table23_0_ops_,  table23_5_ops_,  table23_5_ops_,  table23_5_ops_,
    table23_5_ops_,  table23_5_ops_,  table23_5_ops_,  table23_11_ops_,
    table23_12_ops_, table23_12_ops_, table23_12_ops_, table23_15_ops_,
    table23_0_ops_,  table23_0_ops_,  table23_0_ops_,  table23_0_ops_,
    table23_0_ops_,  table23_5_ops_,  table23_5_ops_,  table23_5_ops_,
    table23_5_ops_,  table23_5_ops_,  table23_5_ops_,  table23_11_ops_,
    table23_12_ops_, table23_12_ops_, table23_12_ops_, table23_15_ops_,
    table23_0_ops_,  table23_0_ops_,  table23_0_ops_,  table23_0_ops_,
    table23_0_ops_,  table23_5_ops_,  table23_5_ops_,  table23_5_ops_,
    table23_5_ops_,  table23_5_ops_,  table23_5_ops_,  table23_11_ops_,
    table23_12_ops_, table23_12_ops_, table23_12_ops_, table23_15_ops_,
    table23_48_ops_, table23_48_ops_, table23_48_ops_, table23_51_ops_,
    table23_51_ops_, table23_51_ops_, table23_51_ops_, table23_55_ops_,
    table23_55_ops_, table23_55_ops_, table23_58_ops_, table23_59_ops_,
    table23_59_ops_, table23_61_ops_, table23_62_ops_, table23_63_ops_,
};
const uint8_t HuffDecoderCommon::table24_0_emit_[204] = {
    0x3c, 0x30, 0x30, 0x3c, 0x30, 0x31, 0x3c, 0x30, 0x32, 0x3c, 0x30, 0x61,
    0x3c, 0x30, 0x63, 0x3c, 0x30, 0x65, 0x3c, 0x30, 0x69, 0x3c, 0x30, 0x6f,
    0x3c, 0x30, 0x73, 0x3c, 0x30, 0x74, 0x3c, 0x30, 0x20, 0x3c, 0x30, 0x25,
    0x3c, 0x30, 0x2d, 0x3c, 0x30, 0x2e, 0x3c, 0x30, 0x2f, 0x3c, 0x30, 0x33,
    0x3c, 0x30, 0x34, 0x3c, 0x30, 0x35, 0x3c, 0x30, 0x36, 0x3c, 0x30, 0x37,
    0x3c, 0x30, 0x38, 0x3c, 0x30, 0x39, 0x3c, 0x30, 0x3d, 0x3c, 0x30, 0x41,
    0x3c, 0x30, 0x5f, 0x3c, 0x30, 0x62, 0x3c, 0x30, 0x64, 0x3c, 0x30, 0x66,
    0x3c, 0x30, 0x67, 0x3c, 0x30, 0x68, 0x3c, 0x30, 0x6c, 0x3c, 0x30, 0x6d,
    0x3c, 0x30, 0x6e, 0x3c, 0x30, 0x70, 0x3c, 0x30, 0x72, 0x3c, 0x30, 0x75,
    0x3c, 0x30, 0x3a, 0x3c, 0x30, 0x42, 0x3c, 0x30, 0x43, 0x3c, 0x30, 0x44,
    0x3c, 0x30, 0x45, 0x3c, 0x30, 0x46, 0x3c, 0x30, 0x47, 0x3c, 0x30, 0x48,
    0x3c, 0x30, 0x49, 0x3c, 0x30, 0x4a, 0x3c, 0x30, 0x4b, 0x3c, 0x30, 0x4c,
    0x3c, 0x30, 0x4d, 0x3c, 0x30, 0x4e, 0x3c, 0x30, 0x4f, 0x3c, 0x30, 0x50,
    0x3c, 0x30, 0x51, 0x3c, 0x30, 0x52, 0x3c, 0x30, 0x53, 0x3c, 0x30, 0x54,
    0x3c, 0x30, 0x55, 0x3c, 0x30, 0x56, 0x3c, 0x30, 0x57, 0x3c, 0x30, 0x59,
    0x3c, 0x30, 0x6a, 0x3c, 0x30, 0x6b, 0x3c, 0x30, 0x71, 0x3c, 0x30, 0x76,
    0x3c, 0x30, 0x77, 0x3c, 0x30, 0x78, 0x3c, 0x30, 0x79, 0x3c, 0x30, 0x7a};
const uint16_t HuffDecoderCommon::table24_0_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000,
    0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0000,
    0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0079, 0x0000, 0x0000, 0x0000,
    0x0091, 0x0000, 0x0000, 0x0000, 0x00a9, 0x0000, 0x0000, 0x0000, 0x00c1,
    0x0000, 0x0000, 0x0000, 0x00d9, 0x0000, 0x00f1, 0x0000, 0x0109, 0x0000,
    0x0121, 0x0000, 0x0139, 0x0000, 0x0151, 0x0000, 0x0169, 0x0000, 0x0181,
    0x0000, 0x0199, 0x0000, 0x01b1, 0x0000, 0x01c9, 0x0000, 0x01e1, 0x0000,
    0x01f9, 0x0000, 0x0211, 0x0000, 0x0229, 0x0000, 0x0241, 0x0000, 0x0259,
    0x0000, 0x0271, 0x0000, 0x0289, 0x0000, 0x02a1, 0x0000, 0x02b9, 0x0000,
    0x02d1, 0x0000, 0x02e9, 0x0000, 0x0301, 0x0000, 0x0319, 0x0000, 0x0331,
    0x0000, 0x0349, 0x0361, 0x0379, 0x0391, 0x03a9, 0x03c1, 0x03d9, 0x03f1,
    0x0409, 0x0421, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9,
    0x04e1, 0x04f9, 0x0511, 0x0529, 0x0541, 0x0559, 0x0571, 0x0589, 0x05a1,
    0x05b9, 0x05d1, 0x05e9, 0x0601, 0x0619, 0x0631, 0x0649, 0x0000, 0x0000,
    0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table24_1_emit_[204] = {
    0x3c, 0x31, 0x30, 0x3c, 0x31, 0x31, 0x3c, 0x31, 0x32, 0x3c, 0x31, 0x61,
    0x3c, 0x31, 0x63, 0x3c, 0x31, 0x65, 0x3c, 0x31, 0x69, 0x3c, 0x31, 0x6f,
    0x3c, 0x31, 0x73, 0x3c, 0x31, 0x74, 0x3c, 0x31, 0x20, 0x3c, 0x31, 0x25,
    0x3c, 0x31, 0x2d, 0x3c, 0x31, 0x2e, 0x3c, 0x31, 0x2f, 0x3c, 0x31, 0x33,
    0x3c, 0x31, 0x34, 0x3c, 0x31, 0x35, 0x3c, 0x31, 0x36, 0x3c, 0x31, 0x37,
    0x3c, 0x31, 0x38, 0x3c, 0x31, 0x39, 0x3c, 0x31, 0x3d, 0x3c, 0x31, 0x41,
    0x3c, 0x31, 0x5f, 0x3c, 0x31, 0x62, 0x3c, 0x31, 0x64, 0x3c, 0x31, 0x66,
    0x3c, 0x31, 0x67, 0x3c, 0x31, 0x68, 0x3c, 0x31, 0x6c, 0x3c, 0x31, 0x6d,
    0x3c, 0x31, 0x6e, 0x3c, 0x31, 0x70, 0x3c, 0x31, 0x72, 0x3c, 0x31, 0x75,
    0x3c, 0x31, 0x3a, 0x3c, 0x31, 0x42, 0x3c, 0x31, 0x43, 0x3c, 0x31, 0x44,
    0x3c, 0x31, 0x45, 0x3c, 0x31, 0x46, 0x3c, 0x31, 0x47, 0x3c, 0x31, 0x48,
    0x3c, 0x31, 0x49, 0x3c, 0x31, 0x4a, 0x3c, 0x31, 0x4b, 0x3c, 0x31, 0x4c,
    0x3c, 0x31, 0x4d, 0x3c, 0x31, 0x4e, 0x3c, 0x31, 0x4f, 0x3c, 0x31, 0x50,
    0x3c, 0x31, 0x51, 0x3c, 0x31, 0x52, 0x3c, 0x31, 0x53, 0x3c, 0x31, 0x54,
    0x3c, 0x31, 0x55, 0x3c, 0x31, 0x56, 0x3c, 0x31, 0x57, 0x3c, 0x31, 0x59,
    0x3c, 0x31, 0x6a, 0x3c, 0x31, 0x6b, 0x3c, 0x31, 0x71, 0x3c, 0x31, 0x76,
    0x3c, 0x31, 0x77, 0x3c, 0x31, 0x78, 0x3c, 0x31, 0x79, 0x3c, 0x31, 0x7a};
const uint8_t HuffDecoderCommon::table24_2_emit_[204] = {
    0x3c, 0x32, 0x30, 0x3c, 0x32, 0x31, 0x3c, 0x32, 0x32, 0x3c, 0x32, 0x61,
    0x3c, 0x32, 0x63, 0x3c, 0x32, 0x65, 0x3c, 0x32, 0x69, 0x3c, 0x32, 0x6f,
    0x3c, 0x32, 0x73, 0x3c, 0x32, 0x74, 0x3c, 0x32, 0x20, 0x3c, 0x32, 0x25,
    0x3c, 0x32, 0x2d, 0x3c, 0x32, 0x2e, 0x3c, 0x32, 0x2f, 0x3c, 0x32, 0x33,
    0x3c, 0x32, 0x34, 0x3c, 0x32, 0x35, 0x3c, 0x32, 0x36, 0x3c, 0x32, 0x37,
    0x3c, 0x32, 0x38, 0x3c, 0x32, 0x39, 0x3c, 0x32, 0x3d, 0x3c, 0x32, 0x41,
    0x3c, 0x32, 0x5f, 0x3c, 0x32, 0x62, 0x3c, 0x32, 0x64, 0x3c, 0x32, 0x66,
    0x3c, 0x32, 0x67, 0x3c, 0x32, 0x68, 0x3c, 0x32, 0x6c, 0x3c, 0x32, 0x6d,
    0x3c, 0x32, 0x6e, 0x3c, 0x32, 0x70, 0x3c, 0x32, 0x72, 0x3c, 0x32, 0x75,
    0x3c, 0x32, 0x3a, 0x3c, 0x32, 0x42, 0x3c, 0x32, 0x43, 0x3c, 0x32, 0x44,
    0x3c, 0x32, 0x45, 0x3c, 0x32, 0x46, 0x3c, 0x32, 0x47, 0x3c, 0x32, 0x48,
    0x3c, 0x32, 0x49, 0x3c, 0x32, 0x4a, 0x3c, 0x32, 0x4b, 0x3c, 0x32, 0x4c,
    0x3c, 0x32, 0x4d, 0x3c, 0x32, 0x4e, 0x3c, 0x32, 0x4f, 0x3c, 0x32, 0x50,
    0x3c, 0x32, 0x51, 0x3c, 0x32, 0x52, 0x3c, 0x32, 0x53, 0x3c, 0x32, 0x54,
    0x3c, 0x32, 0x55, 0x3c, 0x32, 0x56, 0x3c, 0x32, 0x57, 0x3c, 0x32, 0x59,
    0x3c, 0x32, 0x6a, 0x3c, 0x32, 0x6b, 0x3c, 0x32, 0x71, 0x3c, 0x32, 0x76,
    0x3c, 0x32, 0x77, 0x3c, 0x32, 0x78, 0x3c, 0x32, 0x79, 0x3c, 0x32, 0x7a};
const uint8_t HuffDecoderCommon::table24_3_emit_[204] = {
    0x3c, 0x61, 0x30, 0x3c, 0x61, 0x31, 0x3c, 0x61, 0x32, 0x3c, 0x61, 0x61,
    0x3c, 0x61, 0x63, 0x3c, 0x61, 0x65, 0x3c, 0x61, 0x69, 0x3c, 0x61, 0x6f,
    0x3c, 0x61, 0x73, 0x3c, 0x61, 0x74, 0x3c, 0x61, 0x20, 0x3c, 0x61, 0x25,
    0x3c, 0x61, 0x2d, 0x3c, 0x61, 0x2e, 0x3c, 0x61, 0x2f, 0x3c, 0x61, 0x33,
    0x3c, 0x61, 0x34, 0x3c, 0x61, 0x35, 0x3c, 0x61, 0x36, 0x3c, 0x61, 0x37,
    0x3c, 0x61, 0x38, 0x3c, 0x61, 0x39, 0x3c, 0x61, 0x3d, 0x3c, 0x61, 0x41,
    0x3c, 0x61, 0x5f, 0x3c, 0x61, 0x62, 0x3c, 0x61, 0x64, 0x3c, 0x61, 0x66,
    0x3c, 0x61, 0x67, 0x3c, 0x61, 0x68, 0x3c, 0x61, 0x6c, 0x3c, 0x61, 0x6d,
    0x3c, 0x61, 0x6e, 0x3c, 0x61, 0x70, 0x3c, 0x61, 0x72, 0x3c, 0x61, 0x75,
    0x3c, 0x61, 0x3a, 0x3c, 0x61, 0x42, 0x3c, 0x61, 0x43, 0x3c, 0x61, 0x44,
    0x3c, 0x61, 0x45, 0x3c, 0x61, 0x46, 0x3c, 0x61, 0x47, 0x3c, 0x61, 0x48,
    0x3c, 0x61, 0x49, 0x3c, 0x61, 0x4a, 0x3c, 0x61, 0x4b, 0x3c, 0x61, 0x4c,
    0x3c, 0x61, 0x4d, 0x3c, 0x61, 0x4e, 0x3c, 0x61, 0x4f, 0x3c, 0x61, 0x50,
    0x3c, 0x61, 0x51, 0x3c, 0x61, 0x52, 0x3c, 0x61, 0x53, 0x3c, 0x61, 0x54,
    0x3c, 0x61, 0x55, 0x3c, 0x61, 0x56, 0x3c, 0x61, 0x57, 0x3c, 0x61, 0x59,
    0x3c, 0x61, 0x6a, 0x3c, 0x61, 0x6b, 0x3c, 0x61, 0x71, 0x3c, 0x61, 0x76,
    0x3c, 0x61, 0x77, 0x3c, 0x61, 0x78, 0x3c, 0x61, 0x79, 0x3c, 0x61, 0x7a};
const uint8_t HuffDecoderCommon::table24_4_emit_[204] = {
    0x3c, 0x63, 0x30, 0x3c, 0x63, 0x31, 0x3c, 0x63, 0x32, 0x3c, 0x63, 0x61,
    0x3c, 0x63, 0x63, 0x3c, 0x63, 0x65, 0x3c, 0x63, 0x69, 0x3c, 0x63, 0x6f,
    0x3c, 0x63, 0x73, 0x3c, 0x63, 0x74, 0x3c, 0x63, 0x20, 0x3c, 0x63, 0x25,
    0x3c, 0x63, 0x2d, 0x3c, 0x63, 0x2e, 0x3c, 0x63, 0x2f, 0x3c, 0x63, 0x33,
    0x3c, 0x63, 0x34, 0x3c, 0x63, 0x35, 0x3c, 0x63, 0x36, 0x3c, 0x63, 0x37,
    0x3c, 0x63, 0x38, 0x3c, 0x63, 0x39, 0x3c, 0x63, 0x3d, 0x3c, 0x63, 0x41,
    0x3c, 0x63, 0x5f, 0x3c, 0x63, 0x62, 0x3c, 0x63, 0x64, 0x3c, 0x63, 0x66,
    0x3c, 0x63, 0x67, 0x3c, 0x63, 0x68, 0x3c, 0x63, 0x6c, 0x3c, 0x63, 0x6d,
    0x3c, 0x63, 0x6e, 0x3c, 0x63, 0x70, 0x3c, 0x63, 0x72, 0x3c, 0x63, 0x75,
    0x3c, 0x63, 0x3a, 0x3c, 0x63, 0x42, 0x3c, 0x63, 0x43, 0x3c, 0x63, 0x44,
    0x3c, 0x63, 0x45, 0x3c, 0x63, 0x46, 0x3c, 0x63, 0x47, 0x3c, 0x63, 0x48,
    0x3c, 0x63, 0x49, 0x3c, 0x63, 0x4a, 0x3c, 0x63, 0x4b, 0x3c, 0x63, 0x4c,
    0x3c, 0x63, 0x4d, 0x3c, 0x63, 0x4e, 0x3c, 0x63, 0x4f, 0x3c, 0x63, 0x50,
    0x3c, 0x63, 0x51, 0x3c, 0x63, 0x52, 0x3c, 0x63, 0x53, 0x3c, 0x63, 0x54,
    0x3c, 0x63, 0x55, 0x3c, 0x63, 0x56, 0x3c, 0x63, 0x57, 0x3c, 0x63, 0x59,
    0x3c, 0x63, 0x6a, 0x3c, 0x63, 0x6b, 0x3c, 0x63, 0x71, 0x3c, 0x63, 0x76,
    0x3c, 0x63, 0x77, 0x3c, 0x63, 0x78, 0x3c, 0x63, 0x79, 0x3c, 0x63, 0x7a};
const uint8_t HuffDecoderCommon::table24_5_emit_[204] = {
    0x3c, 0x65, 0x30, 0x3c, 0x65, 0x31, 0x3c, 0x65, 0x32, 0x3c, 0x65, 0x61,
    0x3c, 0x65, 0x63, 0x3c, 0x65, 0x65, 0x3c, 0x65, 0x69, 0x3c, 0x65, 0x6f,
    0x3c, 0x65, 0x73, 0x3c, 0x65, 0x74, 0x3c, 0x65, 0x20, 0x3c, 0x65, 0x25,
    0x3c, 0x65, 0x2d, 0x3c, 0x65, 0x2e, 0x3c, 0x65, 0x2f, 0x3c, 0x65, 0x33,
    0x3c, 0x65, 0x34, 0x3c, 0x65, 0x35, 0x3c, 0x65, 0x36, 0x3c, 0x65, 0x37,
    0x3c, 0x65, 0x38, 0x3c, 0x65, 0x39, 0x3c, 0x65, 0x3d, 0x3c, 0x65, 0x41,
    0x3c, 0x65, 0x5f, 0x3c, 0x65, 0x62, 0x3c, 0x65, 0x64, 0x3c, 0x65, 0x66,
    0x3c, 0x65, 0x67, 0x3c, 0x65, 0x68, 0x3c, 0x65, 0x6c, 0x3c, 0x65, 0x6d,
    0x3c, 0x65, 0x6e, 0x3c, 0x65, 0x70, 0x3c, 0x65, 0x72, 0x3c, 0x65, 0x75,
    0x3c, 0x65, 0x3a, 0x3c, 0x65, 0x42, 0x3c, 0x65, 0x43, 0x3c, 0x65, 0x44,
    0x3c, 0x65, 0x45, 0x3c, 0x65, 0x46, 0x3c, 0x65, 0x47, 0x3c, 0x65, 0x48,
    0x3c, 0x65, 0x49, 0x3c, 0x65, 0x4a, 0x3c, 0x65, 0x4b, 0x3c, 0x65, 0x4c,
    0x3c, 0x65, 0x4d, 0x3c, 0x65, 0x4e, 0x3c, 0x65, 0x4f, 0x3c, 0x65, 0x50,
    0x3c, 0x65, 0x51, 0x3c, 0x65, 0x52, 0x3c, 0x65, 0x53, 0x3c, 0x65, 0x54,
    0x3c, 0x65, 0x55, 0x3c, 0x65, 0x56, 0x3c, 0x65, 0x57, 0x3c, 0x65, 0x59,
    0x3c, 0x65, 0x6a, 0x3c, 0x65, 0x6b, 0x3c, 0x65, 0x71, 0x3c, 0x65, 0x76,
    0x3c, 0x65, 0x77, 0x3c, 0x65, 0x78, 0x3c, 0x65, 0x79, 0x3c, 0x65, 0x7a};
const uint8_t HuffDecoderCommon::table24_6_emit_[204] = {
    0x3c, 0x69, 0x30, 0x3c, 0x69, 0x31, 0x3c, 0x69, 0x32, 0x3c, 0x69, 0x61,
    0x3c, 0x69, 0x63, 0x3c, 0x69, 0x65, 0x3c, 0x69, 0x69, 0x3c, 0x69, 0x6f,
    0x3c, 0x69, 0x73, 0x3c, 0x69, 0x74, 0x3c, 0x69, 0x20, 0x3c, 0x69, 0x25,
    0x3c, 0x69, 0x2d, 0x3c, 0x69, 0x2e, 0x3c, 0x69, 0x2f, 0x3c, 0x69, 0x33,
    0x3c, 0x69, 0x34, 0x3c, 0x69, 0x35, 0x3c, 0x69, 0x36, 0x3c, 0x69, 0x37,
    0x3c, 0x69, 0x38, 0x3c, 0x69, 0x39, 0x3c, 0x69, 0x3d, 0x3c, 0x69, 0x41,
    0x3c, 0x69, 0x5f, 0x3c, 0x69, 0x62, 0x3c, 0x69, 0x64, 0x3c, 0x69, 0x66,
    0x3c, 0x69, 0x67, 0x3c, 0x69, 0x68, 0x3c, 0x69, 0x6c, 0x3c, 0x69, 0x6d,
    0x3c, 0x69, 0x6e, 0x3c, 0x69, 0x70, 0x3c, 0x69, 0x72, 0x3c, 0x69, 0x75,
    0x3c, 0x69, 0x3a, 0x3c, 0x69, 0x42, 0x3c, 0x69, 0x43, 0x3c, 0x69, 0x44,
    0x3c, 0x69, 0x45, 0x3c, 0x69, 0x46, 0x3c, 0x69, 0x47, 0x3c, 0x69, 0x48,
    0x3c, 0x69, 0x49, 0x3c, 0x69, 0x4a, 0x3c, 0x69, 0x4b, 0x3c, 0x69, 0x4c,
    0x3c, 0x69, 0x4d, 0x3c, 0x69, 0x4e, 0x3c, 0x69, 0x4f, 0x3c, 0x69, 0x50,
    0x3c, 0x69, 0x51, 0x3c, 0x69, 0x52, 0x3c, 0x69, 0x53, 0x3c, 0x69, 0x54,
    0x3c, 0x69, 0x55, 0x3c, 0x69, 0x56, 0x3c, 0x69, 0x57, 0x3c, 0x69, 0x59,
    0x3c, 0x69, 0x6a, 0x3c, 0x69, 0x6b, 0x3c, 0x69, 0x71, 0x3c, 0x69, 0x76,
    0x3c, 0x69, 0x77, 0x3c, 0x69, 0x78, 0x3c, 0x69, 0x79, 0x3c, 0x69, 0x7a};
const uint8_t HuffDecoderCommon::table24_7_emit_[204] = {
    0x3c, 0x6f, 0x30, 0x3c, 0x6f, 0x31, 0x3c, 0x6f, 0x32, 0x3c, 0x6f, 0x61,
    0x3c, 0x6f, 0x63, 0x3c, 0x6f, 0x65, 0x3c, 0x6f, 0x69, 0x3c, 0x6f, 0x6f,
    0x3c, 0x6f, 0x73, 0x3c, 0x6f, 0x74, 0x3c, 0x6f, 0x20, 0x3c, 0x6f, 0x25,
    0x3c, 0x6f, 0x2d, 0x3c, 0x6f, 0x2e, 0x3c, 0x6f, 0x2f, 0x3c, 0x6f, 0x33,
    0x3c, 0x6f, 0x34, 0x3c, 0x6f, 0x35, 0x3c, 0x6f, 0x36, 0x3c, 0x6f, 0x37,
    0x3c, 0x6f, 0x38, 0x3c, 0x6f, 0x39, 0x3c, 0x6f, 0x3d, 0x3c, 0x6f, 0x41,
    0x3c, 0x6f, 0x5f, 0x3c, 0x6f, 0x62, 0x3c, 0x6f, 0x64, 0x3c, 0x6f, 0x66,
    0x3c, 0x6f, 0x67, 0x3c, 0x6f, 0x68, 0x3c, 0x6f, 0x6c, 0x3c, 0x6f, 0x6d,
    0x3c, 0x6f, 0x6e, 0x3c, 0x6f, 0x70, 0x3c, 0x6f, 0x72, 0x3c, 0x6f, 0x75,
    0x3c, 0x6f, 0x3a, 0x3c, 0x6f, 0x42, 0x3c, 0x6f, 0x43, 0x3c, 0x6f, 0x44,
    0x3c, 0x6f, 0x45, 0x3c, 0x6f, 0x46, 0x3c, 0x6f, 0x47, 0x3c, 0x6f, 0x48,
    0x3c, 0x6f, 0x49, 0x3c, 0x6f, 0x4a, 0x3c, 0x6f, 0x4b, 0x3c, 0x6f, 0x4c,
    0x3c, 0x6f, 0x4d, 0x3c, 0x6f, 0x4e, 0x3c, 0x6f, 0x4f, 0x3c, 0x6f, 0x50,
    0x3c, 0x6f, 0x51, 0x3c, 0x6f, 0x52, 0x3c, 0x6f, 0x53, 0x3c, 0x6f, 0x54,
    0x3c, 0x6f, 0x55, 0x3c, 0x6f, 0x56, 0x3c, 0x6f, 0x57, 0x3c, 0x6f, 0x59,
    0x3c, 0x6f, 0x6a, 0x3c, 0x6f, 0x6b, 0x3c, 0x6f, 0x71, 0x3c, 0x6f, 0x76,
    0x3c, 0x6f, 0x77, 0x3c, 0x6f, 0x78, 0x3c, 0x6f, 0x79, 0x3c, 0x6f, 0x7a};
const uint8_t HuffDecoderCommon::table24_8_emit_[204] = {
    0x3c, 0x73, 0x30, 0x3c, 0x73, 0x31, 0x3c, 0x73, 0x32, 0x3c, 0x73, 0x61,
    0x3c, 0x73, 0x63, 0x3c, 0x73, 0x65, 0x3c, 0x73, 0x69, 0x3c, 0x73, 0x6f,
    0x3c, 0x73, 0x73, 0x3c, 0x73, 0x74, 0x3c, 0x73, 0x20, 0x3c, 0x73, 0x25,
    0x3c, 0x73, 0x2d, 0x3c, 0x73, 0x2e, 0x3c, 0x73, 0x2f, 0x3c, 0x73, 0x33,
    0x3c, 0x73, 0x34, 0x3c, 0x73, 0x35, 0x3c, 0x73, 0x36, 0x3c, 0x73, 0x37,
    0x3c, 0x73, 0x38, 0x3c, 0x73, 0x39, 0x3c, 0x73, 0x3d, 0x3c, 0x73, 0x41,
    0x3c, 0x73, 0x5f, 0x3c, 0x73, 0x62, 0x3c, 0x73, 0x64, 0x3c, 0x73, 0x66,
    0x3c, 0x73, 0x67, 0x3c, 0x73, 0x68, 0x3c, 0x73, 0x6c, 0x3c, 0x73, 0x6d,
    0x3c, 0x73, 0x6e, 0x3c, 0x73, 0x70, 0x3c, 0x73, 0x72, 0x3c, 0x73, 0x75,
    0x3c, 0x73, 0x3a, 0x3c, 0x73, 0x42, 0x3c, 0x73, 0x43, 0x3c, 0x73, 0x44,
    0x3c, 0x73, 0x45, 0x3c, 0x73, 0x46, 0x3c, 0x73, 0x47, 0x3c, 0x73, 0x48,
    0x3c, 0x73, 0x49, 0x3c, 0x73, 0x4a, 0x3c, 0x73, 0x4b, 0x3c, 0x73, 0x4c,
    0x3c, 0x73, 0x4d, 0x3c, 0x73, 0x4e, 0x3c, 0x73, 0x4f, 0x3c, 0x73, 0x50,
    0x3c, 0x73, 0x51, 0x3c, 0x73, 0x52, 0x3c, 0x73, 0x53, 0x3c, 0x73, 0x54,
    0x3c, 0x73, 0x55, 0x3c, 0x73, 0x56, 0x3c, 0x73, 0x57, 0x3c, 0x73, 0x59,
    0x3c, 0x73, 0x6a, 0x3c, 0x73, 0x6b, 0x3c, 0x73, 0x71, 0x3c, 0x73, 0x76,
    0x3c, 0x73, 0x77, 0x3c, 0x73, 0x78, 0x3c, 0x73, 0x79, 0x3c, 0x73, 0x7a};
const uint8_t HuffDecoderCommon::table24_9_emit_[204] = {
    0x3c, 0x74, 0x30, 0x3c, 0x74, 0x31, 0x3c, 0x74, 0x32, 0x3c, 0x74, 0x61,
    0x3c, 0x74, 0x63, 0x3c, 0x74, 0x65, 0x3c, 0x74, 0x69, 0x3c, 0x74, 0x6f,
    0x3c, 0x74, 0x73, 0x3c, 0x74, 0x74, 0x3c, 0x74, 0x20, 0x3c, 0x74, 0x25,
    0x3c, 0x74, 0x2d, 0x3c, 0x74, 0x2e, 0x3c, 0x74, 0x2f, 0x3c, 0x74, 0x33,
    0x3c, 0x74, 0x34, 0x3c, 0x74, 0x35, 0x3c, 0x74, 0x36, 0x3c, 0x74, 0x37,
    0x3c, 0x74, 0x38, 0x3c, 0x74, 0x39, 0x3c, 0x74, 0x3d, 0x3c, 0x74, 0x41,
    0x3c, 0x74, 0x5f, 0x3c, 0x74, 0x62, 0x3c, 0x74, 0x64, 0x3c, 0x74, 0x66,
    0x3c, 0x74, 0x67, 0x3c, 0x74, 0x68, 0x3c, 0x74, 0x6c, 0x3c, 0x74, 0x6d,
    0x3c, 0x74, 0x6e, 0x3c, 0x74, 0x70, 0x3c, 0x74, 0x72, 0x3c, 0x74, 0x75,
    0x3c, 0x74, 0x3a, 0x3c, 0x74, 0x42, 0x3c, 0x74, 0x43, 0x3c, 0x74, 0x44,
    0x3c, 0x74, 0x45, 0x3c, 0x74, 0x46, 0x3c, 0x74, 0x47, 0x3c, 0x74, 0x48,
    0x3c, 0x74, 0x49, 0x3c, 0x74, 0x4a, 0x3c, 0x74, 0x4b, 0x3c, 0x74, 0x4c,
    0x3c, 0x74, 0x4d, 0x3c, 0x74, 0x4e, 0x3c, 0x74, 0x4f, 0x3c, 0x74, 0x50,
    0x3c, 0x74, 0x51, 0x3c, 0x74, 0x52, 0x3c, 0x74, 0x53, 0x3c, 0x74, 0x54,
    0x3c, 0x74, 0x55, 0x3c, 0x74, 0x56, 0x3c, 0x74, 0x57, 0x3c, 0x74, 0x59,
    0x3c, 0x74, 0x6a, 0x3c, 0x74, 0x6b, 0x3c, 0x74, 0x71, 0x3c, 0x74, 0x76,
    0x3c, 0x74, 0x77, 0x3c, 0x74, 0x78, 0x3c, 0x74, 0x79, 0x3c, 0x74, 0x7a};
const uint8_t HuffDecoderCommon::table24_10_emit_[216] = {
    0x3c, 0x20, 0x30, 0x3c, 0x20, 0x31, 0x3c, 0x20, 0x32, 0x3c, 0x20, 0x61,
    0x3c, 0x20, 0x63, 0x3c, 0x20, 0x65, 0x3c, 0x20, 0x69, 0x3c, 0x20, 0x6f,
    0x3c, 0x20, 0x73, 0x3c, 0x20, 0x74, 0x3c, 0x20, 0x20, 0x3c, 0x20, 0x25,
    0x3c, 0x20, 0x2d, 0x3c, 0x20, 0x2e, 0x3c, 0x20, 0x2f, 0x3c, 0x20, 0x33,
    0x3c, 0x20, 0x34, 0x3c, 0x20, 0x35, 0x3c, 0x20, 0x36, 0x3c, 0x20, 0x37,
    0x3c, 0x20, 0x38, 0x3c, 0x20, 0x39, 0x3c, 0x20, 0x3d, 0x3c, 0x20, 0x41,
    0x3c, 0x20, 0x5f, 0x3c, 0x20, 0x62, 0x3c, 0x20, 0x64, 0x3c, 0x20, 0x66,
    0x3c, 0x20, 0x67, 0x3c, 0x20, 0x68, 0x3c, 0x20, 0x6c, 0x3c, 0x20, 0x6d,
    0x3c, 0x20, 0x6e, 0x3c, 0x20, 0x70, 0x3c, 0x20, 0x72, 0x3c, 0x20, 0x75,
    0x3c, 0x25, 0x30, 0x3c, 0x25, 0x31, 0x3c, 0x25, 0x32, 0x3c, 0x25, 0x61,
    0x3c, 0x25, 0x63, 0x3c, 0x25, 0x65, 0x3c, 0x25, 0x69, 0x3c, 0x25, 0x6f,
    0x3c, 0x25, 0x73, 0x3c, 0x25, 0x74, 0x3c, 0x25, 0x20, 0x3c, 0x25, 0x25,
    0x3c, 0x25, 0x2d, 0x3c, 0x25, 0x2e, 0x3c, 0x25, 0x2f, 0x3c, 0x25, 0x33,
    0x3c, 0x25, 0x34, 0x3c, 0x25, 0x35, 0x3c, 0x25, 0x36, 0x3c, 0x25, 0x37,
    0x3c, 0x25, 0x38, 0x3c, 0x25, 0x39, 0x3c, 0x25, 0x3d, 0x3c, 0x25, 0x41,
    0x3c, 0x25, 0x5f, 0x3c, 0x25, 0x62, 0x3c, 0x25, 0x64, 0x3c, 0x25, 0x66,
    0x3c, 0x25, 0x67, 0x3c, 0x25, 0x68, 0x3c, 0x25, 0x6c, 0x3c, 0x25, 0x6d,
    0x3c, 0x25, 0x6e, 0x3c, 0x25, 0x70, 0x3c, 0x25, 0x72, 0x3c, 0x25, 0x75};
const uint8_t HuffDecoderCommon::table24_11_emit_[216] = {
    0x3c, 0x2d, 0x30, 0x3c, 0x2d, 0x31, 0x3c, 0x2d, 0x32, 0x3c, 0x2d, 0x61,
    0x3c, 0x2d, 0x63, 0x3c, 0x2d, 0x65, 0x3c, 0x2d, 0x69, 0x3c, 0x2d, 0x6f,
    0x3c, 0x2d, 0x73, 0x3c, 0x2d, 0x74, 0x3c, 0x2d, 0x20, 0x3c, 0x2d, 0x25,
    0x3c, 0x2d, 0x2d, 0x3c, 0x2d, 0x2e, 0x3c, 0x2d, 0x2f, 0x3c, 0x2d, 0x33,
    0x3c, 0x2d, 0x34, 0x3c, 0x2d, 0x35, 0x3c, 0x2d, 0x36, 0x3c, 0x2d, 0x37,
    0x3c, 0x2d, 0x38, 0x3c, 0x2d, 0x39, 0x3c, 0x2d, 0x3d, 0x3c, 0x2d, 0x41,
    0x3c, 0x2d, 0x5f, 0x3c, 0x2d, 0x62, 0x3c, 0x2d, 0x64, 0x3c, 0x2d, 0x66,
    0x3c, 0x2d, 0x67, 0x3c, 0x2d, 0x68, 0x3c, 0x2d, 0x6c, 0x3c, 0x2d, 0x6d,
    0x3c, 0x2d, 0x6e, 0x3c, 0x2d, 0x70, 0x3c, 0x2d, 0x72, 0x3c, 0x2d, 0x75,
    0x3c, 0x2e, 0x30, 0x3c, 0x2e, 0x31, 0x3c, 0x2e, 0x32, 0x3c, 0x2e, 0x61,
    0x3c, 0x2e, 0x63, 0x3c, 0x2e, 0x65, 0x3c, 0x2e, 0x69, 0x3c, 0x2e, 0x6f,
    0x3c, 0x2e, 0x73, 0x3c, 0x2e, 0x74, 0x3c, 0x2e, 0x20, 0x3c, 0x2e, 0x25,
    0x3c, 0x2e, 0x2d, 0x3c, 0x2e, 0x2e, 0x3c, 0x2e, 0x2f, 0x3c, 0x2e, 0x33,
    0x3c, 0x2e, 0x34, 0x3c, 0x2e, 0x35, 0x3c, 0x2e, 0x36, 0x3c, 0x2e, 0x37,
    0x3c, 0x2e, 0x38, 0x3c, 0x2e, 0x39, 0x3c, 0x2e, 0x3d, 0x3c, 0x2e, 0x41,
    0x3c, 0x2e, 0x5f, 0x3c, 0x2e, 0x62, 0x3c, 0x2e, 0x64, 0x3c, 0x2e, 0x66,
    0x3c, 0x2e, 0x67, 0x3c, 0x2e, 0x68, 0x3c, 0x2e, 0x6c, 0x3c, 0x2e, 0x6d,
    0x3c, 0x2e, 0x6e, 0x3c, 0x2e, 0x70, 0x3c, 0x2e, 0x72, 0x3c, 0x2e, 0x75};
const uint8_t HuffDecoderCommon::table24_12_emit_[216] = {
    0x3c, 0x2f, 0x30, 0x3c, 0x2f, 0x31, 0x3c, 0x2f, 0x32, 0x3c, 0x2f, 0x61,
    0x3c, 0x2f, 0x63, 0x3c, 0x2f, 0x65, 0x3c, 0x2f, 0x69, 0x3c, 0x2f, 0x6f,
    0x3c, 0x2f, 0x73, 0x3c, 0x2f, 0x74, 0x3c, 0x2f, 0x20, 0x3c, 0x2f, 0x25,
    0x3c, 0x2f, 0x2d, 0x3c, 0x2f, 0x2e, 0x3c, 0x2f, 0x2f, 0x3c, 0x2f, 0x33,
    0x3c, 0x2f, 0x34, 0x3c, 0x2f, 0x35, 0x3c, 0x2f, 0x36, 0x3c, 0x2f, 0x37,
    0x3c, 0x2f, 0x38, 0x3c, 0x2f, 0x39, 0x3c, 0x2f, 0x3d, 0x3c, 0x2f, 0x41,
    0x3c, 0x2f, 0x5f, 0x3c, 0x2f, 0x62, 0x3c, 0x2f, 0x64, 0x3c, 0x2f, 0x66,
    0x3c, 0x2f, 0x67, 0x3c, 0x2f, 0x68, 0x3c, 0x2f, 0x6c, 0x3c, 0x2f, 0x6d,
    0x3c, 0x2f, 0x6e, 0x3c, 0x2f, 0x70, 0x3c, 0x2f, 0x72, 0x3c, 0x2f, 0x75,
    0x3c, 0x33, 0x30, 0x3c, 0x33, 0x31, 0x3c, 0x33, 0x32, 0x3c, 0x33, 0x61,
    0x3c, 0x33, 0x63, 0x3c, 0x33, 0x65, 0x3c, 0x33, 0x69, 0x3c, 0x33, 0x6f,
    0x3c, 0x33, 0x73, 0x3c, 0x33, 0x74, 0x3c, 0x33, 0x20, 0x3c, 0x33, 0x25,
    0x3c, 0x33, 0x2d, 0x3c, 0x33, 0x2e, 0x3c, 0x33, 0x2f, 0x3c, 0x33, 0x33,
    0x3c, 0x33, 0x34, 0x3c, 0x33, 0x35, 0x3c, 0x33, 0x36, 0x3c, 0x33, 0x37,
    0x3c, 0x33, 0x38, 0x3c, 0x33, 0x39, 0x3c, 0x33, 0x3d, 0x3c, 0x33, 0x41,
    0x3c, 0x33, 0x5f, 0x3c, 0x33, 0x62, 0x3c, 0x33, 0x64, 0x3c, 0x33, 0x66,
    0x3c, 0x33, 0x67, 0x3c, 0x33, 0x68, 0x3c, 0x33, 0x6c, 0x3c, 0x33, 0x6d,
    0x3c, 0x33, 0x6e, 0x3c, 0x33, 0x70, 0x3c, 0x33, 0x72, 0x3c, 0x33, 0x75};
const uint8_t HuffDecoderCommon::table24_13_emit_[216] = {
    0x3c, 0x34, 0x30, 0x3c, 0x34, 0x31, 0x3c, 0x34, 0x32, 0x3c, 0x34, 0x61,
    0x3c, 0x34, 0x63, 0x3c, 0x34, 0x65, 0x3c, 0x34, 0x69, 0x3c, 0x34, 0x6f,
    0x3c, 0x34, 0x73, 0x3c, 0x34, 0x74, 0x3c, 0x34, 0x20, 0x3c, 0x34, 0x25,
    0x3c, 0x34, 0x2d, 0x3c, 0x34, 0x2e, 0x3c, 0x34, 0x2f, 0x3c, 0x34, 0x33,
    0x3c, 0x34, 0x34, 0x3c, 0x34, 0x35, 0x3c, 0x34, 0x36, 0x3c, 0x34, 0x37,
    0x3c, 0x34, 0x38, 0x3c, 0x34, 0x39, 0x3c, 0x34, 0x3d, 0x3c, 0x34, 0x41,
    0x3c, 0x34, 0x5f, 0x3c, 0x34, 0x62, 0x3c, 0x34, 0x64, 0x3c, 0x34, 0x66,
    0x3c, 0x34, 0x67, 0x3c, 0x34, 0x68, 0x3c, 0x34, 0x6c, 0x3c, 0x34, 0x6d,
    0x3c, 0x34, 0x6e, 0x3c, 0x34, 0x70, 0x3c, 0x34, 0x72, 0x3c, 0x34, 0x75,
    0x3c, 0x35, 0x30, 0x3c, 0x35, 0x31, 0x3c, 0x35, 0x32, 0x3c, 0x35, 0x61,
    0x3c, 0x35, 0x63, 0x3c, 0x35, 0x65, 0x3c, 0x35, 0x69, 0x3c, 0x35, 0x6f,
    0x3c, 0x35, 0x73, 0x3c, 0x35, 0x74, 0x3c, 0x35, 0x20, 0x3c, 0x35, 0x25,
    0x3c, 0x35, 0x2d, 0x3c, 0x35, 0x2e, 0x3c, 0x35, 0x2f, 0x3c, 0x35, 0x33,
    0x3c, 0x35, 0x34, 0x3c, 0x35, 0x35, 0x3c, 0x35, 0x36, 0x3c, 0x35, 0x37,
    0x3c, 0x35, 0x38, 0x3c, 0x35, 0x39, 0x3c, 0x35, 0x3d, 0x3c, 0x35, 0x41,
    0x3c, 0x35, 0x5f, 0x3c, 0x35, 0x62, 0x3c, 0x35, 0x64, 0x3c, 0x35, 0x66,
    0x3c, 0x35, 0x67, 0x3c, 0x35, 0x68, 0x3c, 0x35, 0x6c, 0x3c, 0x35, 0x6d,
    0x3c, 0x35, 0x6e, 0x3c, 0x35, 0x70, 0x3c, 0x35, 0x72, 0x3c, 0x35, 0x75};
const uint8_t HuffDecoderCommon::table24_14_emit_[216] = {
    0x3c, 0x36, 0x30, 0x3c, 0x36, 0x31, 0x3c, 0x36, 0x32, 0x3c, 0x36, 0x61,
    0x3c, 0x36, 0x63, 0x3c, 0x36, 0x65, 0x3c, 0x36, 0x69, 0x3c, 0x36, 0x6f,
    0x3c, 0x36, 0x73, 0x3c, 0x36, 0x74, 0x3c, 0x36, 0x20, 0x3c, 0x36, 0x25,
    0x3c, 0x36, 0x2d, 0x3c, 0x36, 0x2e, 0x3c, 0x36, 0x2f, 0x3c, 0x36, 0x33,
    0x3c, 0x36, 0x34, 0x3c, 0x36, 0x35, 0x3c, 0x36, 0x36, 0x3c, 0x36, 0x37,
    0x3c, 0x36, 0x38, 0x3c, 0x36, 0x39, 0x3c, 0x36, 0x3d, 0x3c, 0x36, 0x41,
    0x3c, 0x36, 0x5f, 0x3c, 0x36, 0x62, 0x3c, 0x36, 0x64, 0x3c, 0x36, 0x66,
    0x3c, 0x36, 0x67, 0x3c, 0x36, 0x68, 0x3c, 0x36, 0x6c, 0x3c, 0x36, 0x6d,
    0x3c, 0x36, 0x6e, 0x3c, 0x36, 0x70, 0x3c, 0x36, 0x72, 0x3c, 0x36, 0x75,
    0x3c, 0x37, 0x30, 0x3c, 0x37, 0x31, 0x3c, 0x37, 0x32, 0x3c, 0x37, 0x61,
    0x3c, 0x37, 0x63, 0x3c, 0x37, 0x65, 0x3c, 0x37, 0x69, 0x3c, 0x37, 0x6f,
    0x3c, 0x37, 0x73, 0x3c, 0x37, 0x74, 0x3c, 0x37, 0x20, 0x3c, 0x37, 0x25,
    0x3c, 0x37, 0x2d, 0x3c, 0x37, 0x2e, 0x3c, 0x37, 0x2f, 0x3c, 0x37, 0x33,
    0x3c, 0x37, 0x34, 0x3c, 0x37, 0x35, 0x3c, 0x37, 0x36, 0x3c, 0x37, 0x37,
    0x3c, 0x37, 0x38, 0x3c, 0x37, 0x39, 0x3c, 0x37, 0x3d, 0x3c, 0x37, 0x41,
    0x3c, 0x37, 0x5f, 0x3c, 0x37, 0x62, 0x3c, 0x37, 0x64, 0x3c, 0x37, 0x66,
    0x3c, 0x37, 0x67, 0x3c, 0x37, 0x68, 0x3c, 0x37, 0x6c, 0x3c, 0x37, 0x6d,
    0x3c, 0x37, 0x6e, 0x3c, 0x37, 0x70, 0x3c, 0x37, 0x72, 0x3c, 0x37, 0x75};
const uint8_t HuffDecoderCommon::table24_15_emit_[216] = {
    0x3c, 0x38, 0x30, 0x3c, 0x38, 0x31, 0x3c, 0x38, 0x32, 0x3c, 0x38, 0x61,
    0x3c, 0x38, 0x63, 0x3c, 0x38, 0x65, 0x3c, 0x38, 0x69, 0x3c, 0x38, 0x6f,
    0x3c, 0x38, 0x73, 0x3c, 0x38, 0x74, 0x3c, 0x38, 0x20, 0x3c, 0x38, 0x25,
    0x3c, 0x38, 0x2d, 0x3c, 0x38, 0x2e, 0x3c, 0x38, 0x2f, 0x3c, 0x38, 0x33,
    0x3c, 0x38, 0x34, 0x3c, 0x38, 0x35, 0x3c, 0x38, 0x36, 0x3c, 0x38, 0x37,
    0x3c, 0x38, 0x38, 0x3c, 0x38, 0x39, 0x3c, 0x38, 0x3d, 0x3c, 0x38, 0x41,
    0x3c, 0x38, 0x5f, 0x3c, 0x38, 0x62, 0x3c, 0x38, 0x64, 0x3c, 0x38, 0x66,
    0x3c, 0x38, 0x67, 0x3c, 0x38, 0x68, 0x3c, 0x38, 0x6c, 0x3c, 0x38, 0x6d,
    0x3c, 0x38, 0x6e, 0x3c, 0x38, 0x70, 0x3c, 0x38, 0x72, 0x3c, 0x38, 0x75,
    0x3c, 0x39, 0x30, 0x3c, 0x39, 0x31, 0x3c, 0x39, 0x32, 0x3c, 0x39, 0x61,
    0x3c, 0x39, 0x63, 0x3c, 0x39, 0x65, 0x3c, 0x39, 0x69, 0x3c, 0x39, 0x6f,
    0x3c, 0x39, 0x73, 0x3c, 0x39, 0x74, 0x3c, 0x39, 0x20, 0x3c, 0x39, 0x25,
    0x3c, 0x39, 0x2d, 0x3c, 0x39, 0x2e, 0x3c, 0x39, 0x2f, 0x3c, 0x39, 0x33,
    0x3c, 0x39, 0x34, 0x3c, 0x39, 0x35, 0x3c, 0x39, 0x36, 0x3c, 0x39, 0x37,
    0x3c, 0x39, 0x38, 0x3c, 0x39, 0x39, 0x3c, 0x39, 0x3d, 0x3c, 0x39, 0x41,
    0x3c, 0x39, 0x5f, 0x3c, 0x39, 0x62, 0x3c, 0x39, 0x64, 0x3c, 0x39, 0x66,
    0x3c, 0x39, 0x67, 0x3c, 0x39, 0x68, 0x3c, 0x39, 0x6c, 0x3c, 0x39, 0x6d,
    0x3c, 0x39, 0x6e, 0x3c, 0x39, 0x70, 0x3c, 0x39, 0x72, 0x3c, 0x39, 0x75};
const uint8_t HuffDecoderCommon::table24_16_emit_[216] = {
    0x3c, 0x3d, 0x30, 0x3c, 0x3d, 0x31, 0x3c, 0x3d, 0x32, 0x3c, 0x3d, 0x61,
    0x3c, 0x3d, 0x63, 0x3c, 0x3d, 0x65, 0x3c, 0x3d, 0x69, 0x3c, 0x3d, 0x6f,
    0x3c, 0x3d, 0x73, 0x3c, 0x3d, 0x74, 0x3c, 0x3d, 0x20, 0x3c, 0x3d, 0x25,
    0x3c, 0x3d, 0x2d, 0x3c, 0x3d, 0x2e, 0x3c, 0x3d, 0x2f, 0x3c, 0x3d, 0x33,
    0x3c, 0x3d, 0x34, 0x3c, 0x3d, 0x35, 0x3c, 0x3d, 0x36, 0x3c, 0x3d, 0x37,
    0x3c, 0x3d, 0x38, 0x3c, 0x3d, 0x39, 0x3c, 0x3d, 0x3d, 0x3c, 0x3d, 0x41,
    0x3c, 0x3d, 0x5f, 0x3c, 0x3d, 0x62, 0x3c, 0x3d, 0x64, 0x3c, 0x3d, 0x66,
    0x3c, 0x3d, 0x67, 0x3c, 0x3d, 0x68, 0x3c, 0x3d, 0x6c, 0x3c, 0x3d, 0x6d,
    0x3c, 0x3d, 0x6e, 0x3c, 0x3d, 0x70, 0x3c, 0x3d, 0x72, 0x3c, 0x3d, 0x75,
    0x3c, 0x41, 0x30, 0x3c, 0x41, 0x31, 0x3c, 0x41, 0x32, 0x3c, 0x41, 0x61,
    0x3c, 0x41, 0x63, 0x3c, 0x41, 0x65, 0x3c, 0x41, 0x69, 0x3c, 0x41, 0x6f,
    0x3c, 0x41, 0x73, 0x3c, 0x41, 0x74, 0x3c, 0x41, 0x20, 0x3c, 0x41, 0x25,
    0x3c, 0x41, 0x2d, 0x3c, 0x41, 0x2e, 0x3c, 0x41, 0x2f, 0x3c, 0x41, 0x33,
    0x3c, 0x41, 0x34, 0x3c, 0x41, 0x35, 0x3c, 0x41, 0x36, 0x3c, 0x41, 0x37,
    0x3c, 0x41, 0x38, 0x3c, 0x41, 0x39, 0x3c, 0x41, 0x3d, 0x3c, 0x41, 0x41,
    0x3c, 0x41, 0x5f, 0x3c, 0x41, 0x62, 0x3c, 0x41, 0x64, 0x3c, 0x41, 0x66,
    0x3c, 0x41, 0x67, 0x3c, 0x41, 0x68, 0x3c, 0x41, 0x6c, 0x3c, 0x41, 0x6d,
    0x3c, 0x41, 0x6e, 0x3c, 0x41, 0x70, 0x3c, 0x41, 0x72, 0x3c, 0x41, 0x75};
const uint8_t HuffDecoderCommon::table24_17_emit_[216] = {
    0x3c, 0x5f, 0x30, 0x3c, 0x5f, 0x31, 0x3c, 0x5f, 0x32, 0x3c, 0x5f, 0x61,
    0x3c, 0x5f, 0x63, 0x3c, 0x5f, 0x65, 0x3c, 0x5f, 0x69, 0x3c, 0x5f, 0x6f,
    0x3c, 0x5f, 0x73, 0x3c, 0x5f, 0x74, 0x3c, 0x5f, 0x20, 0x3c, 0x5f, 0x25,
    0x3c, 0x5f, 0x2d, 0x3c, 0x5f, 0x2e, 0x3c, 0x5f, 0x2f, 0x3c, 0x5f, 0x33,
    0x3c, 0x5f, 0x34, 0x3c, 0x5f, 0x35, 0x3c, 0x5f, 0x36, 0x3c, 0x5f, 0x37,
    0x3c, 0x5f, 0x38, 0x3c, 0x5f, 0x39, 0x3c, 0x5f, 0x3d, 0x3c, 0x5f, 0x41,
    0x3c, 0x5f, 0x5f, 0x3c, 0x5f, 0x62, 0x3c, 0x5f, 0x64, 0x3c, 0x5f, 0x66,
    0x3c, 0x5f, 0x67, 0x3c, 0x5f, 0x68, 0x3c, 0x5f, 0x6c, 0x3c, 0x5f, 0x6d,
    0x3c, 0x5f, 0x6e, 0x3c, 0x5f, 0x70, 0x3c, 0x5f, 0x72, 0x3c, 0x5f, 0x75,
    0x3c, 0x62, 0x30, 0x3c, 0x62, 0x31, 0x3c, 0x62, 0x32, 0x3c, 0x62, 0x61,
    0x3c, 0x62, 0x63, 0x3c, 0x62, 0x65, 0x3c, 0x62, 0x69, 0x3c, 0x62, 0x6f,
    0x3c, 0x62, 0x73, 0x3c, 0x62, 0x74, 0x3c, 0x62, 0x20, 0x3c, 0x62, 0x25,
    0x3c, 0x62, 0x2d, 0x3c, 0x62, 0x2e, 0x3c, 0x62, 0x2f, 0x3c, 0x62, 0x33,
    0x3c, 0x62, 0x34, 0x3c, 0x62, 0x35, 0x3c, 0x62, 0x36, 0x3c, 0x62, 0x37,
    0x3c, 0x62, 0x38, 0x3c, 0x62, 0x39, 0x3c, 0x62, 0x3d, 0x3c, 0x62, 0x41,
    0x3c, 0x62, 0x5f, 0x3c, 0x62, 0x62, 0x3c, 0x62, 0x64, 0x3c, 0x62, 0x66,
    0x3c, 0x62, 0x67, 0x3c, 0x62, 0x68, 0x3c, 0x62, 0x6c, 0x3c, 0x62, 0x6d,
    0x3c, 0x62, 0x6e, 0x3c, 0x62, 0x70, 0x3c, 0x62, 0x72, 0x3c, 0x62, 0x75};
const uint8_t HuffDecoderCommon::table24_18_emit_[216] = {
    0x3c, 0x64, 0x30, 0x3c, 0x64, 0x31, 0x3c, 0x64, 0x32, 0x3c, 0x64, 0x61,
    0x3c, 0x64, 0x63, 0x3c, 0x64, 0x65, 0x3c, 0x64, 0x69, 0x3c, 0x64, 0x6f,
    0x3c, 0x64, 0x73, 0x3c, 0x64, 0x74, 0x3c, 0x64, 0x20, 0x3c, 0x64, 0x25,
    0x3c, 0x64, 0x2d, 0x3c, 0x64, 0x2e, 0x3c, 0x64, 0x2f, 0x3c, 0x64, 0x33,
    0x3c, 0x64, 0x34, 0x3c, 0x64, 0x35, 0x3c, 0x64, 0x36, 0x3c, 0x64, 0x37,
    0x3c, 0x64, 0x38, 0x3c, 0x64, 0x39, 0x3c, 0x64, 0x3d, 0x3c, 0x64, 0x41,
    0x3c, 0x64, 0x5f, 0x3c, 0x64, 0x62, 0x3c, 0x64, 0x64, 0x3c, 0x64, 0x66,
    0x3c, 0x64, 0x67, 0x3c, 0x64, 0x68, 0x3c, 0x64, 0x6c, 0x3c, 0x64, 0x6d,
    0x3c, 0x64, 0x6e, 0x3c, 0x64, 0x70, 0x3c, 0x64, 0x72, 0x3c, 0x64, 0x75,
    0x3c, 0x66, 0x30, 0x3c, 0x66, 0x31, 0x3c, 0x66, 0x32, 0x3c, 0x66, 0x61,
    0x3c, 0x66, 0x63, 0x3c, 0x66, 0x65, 0x3c, 0x66, 0x69, 0x3c, 0x66, 0x6f,
    0x3c, 0x66, 0x73, 0x3c, 0x66, 0x74, 0x3c, 0x66, 0x20, 0x3c, 0x66, 0x25,
    0x3c, 0x66, 0x2d, 0x3c, 0x66, 0x2e, 0x3c, 0x66, 0x2f, 0x3c, 0x66, 0x33,
    0x3c, 0x66, 0x34, 0x3c, 0x66, 0x35, 0x3c, 0x66, 0x36, 0x3c, 0x66, 0x37,
    0x3c, 0x66, 0x38, 0x3c, 0x66, 0x39, 0x3c, 0x66, 0x3d, 0x3c, 0x66, 0x41,
    0x3c, 0x66, 0x5f, 0x3c, 0x66, 0x62, 0x3c, 0x66, 0x64, 0x3c, 0x66, 0x66,
    0x3c, 0x66, 0x67, 0x3c, 0x66, 0x68, 0x3c, 0x66, 0x6c, 0x3c, 0x66, 0x6d,
    0x3c, 0x66, 0x6e, 0x3c, 0x66, 0x70, 0x3c, 0x66, 0x72, 0x3c, 0x66, 0x75};
const uint8_t HuffDecoderCommon::table24_19_emit_[216] = {
    0x3c, 0x67, 0x30, 0x3c, 0x67, 0x31, 0x3c, 0x67, 0x32, 0x3c, 0x67, 0x61,
    0x3c, 0x67, 0x63, 0x3c, 0x67, 0x65, 0x3c, 0x67, 0x69, 0x3c, 0x67, 0x6f,
    0x3c, 0x67, 0x73, 0x3c, 0x67, 0x74, 0x3c, 0x67, 0x20, 0x3c, 0x67, 0x25,
    0x3c, 0x67, 0x2d, 0x3c, 0x67, 0x2e, 0x3c, 0x67, 0x2f, 0x3c, 0x67, 0x33,
    0x3c, 0x67, 0x34, 0x3c, 0x67, 0x35, 0x3c, 0x67, 0x36, 0x3c, 0x67, 0x37,
    0x3c, 0x67, 0x38, 0x3c, 0x67, 0x39, 0x3c, 0x67, 0x3d, 0x3c, 0x67, 0x41,
    0x3c, 0x67, 0x5f, 0x3c, 0x67, 0x62, 0x3c, 0x67, 0x64, 0x3c, 0x67, 0x66,
    0x3c, 0x67, 0x67, 0x3c, 0x67, 0x68, 0x3c, 0x67, 0x6c, 0x3c, 0x67, 0x6d,
    0x3c, 0x67, 0x6e, 0x3c, 0x67, 0x70, 0x3c, 0x67, 0x72, 0x3c, 0x67, 0x75,
    0x3c, 0x68, 0x30, 0x3c, 0x68, 0x31, 0x3c, 0x68, 0x32, 0x3c, 0x68, 0x61,
    0x3c, 0x68, 0x63, 0x3c, 0x68, 0x65, 0x3c, 0x68, 0x69, 0x3c, 0x68, 0x6f,
    0x3c, 0x68, 0x73, 0x3c, 0x68, 0x74, 0x3c, 0x68, 0x20, 0x3c, 0x68, 0x25,
    0x3c, 0x68, 0x2d, 0x3c, 0x68, 0x2e, 0x3c, 0x68, 0x2f, 0x3c, 0x68, 0x33,
    0x3c, 0x68, 0x34, 0x3c, 0x68, 0x35, 0x3c, 0x68, 0x36, 0x3c, 0x68, 0x37,
    0x3c, 0x68, 0x38, 0x3c, 0x68, 0x39, 0x3c, 0x68, 0x3d, 0x3c, 0x68, 0x41,
    0x3c, 0x68, 0x5f, 0x3c, 0x68, 0x62, 0x3c, 0x68, 0x64, 0x3c, 0x68, 0x66,
    0x3c, 0x68, 0x67, 0x3c, 0x68, 0x68, 0x3c, 0x68, 0x6c, 0x3c, 0x68, 0x6d,
    0x3c, 0x68, 0x6e, 0x3c, 0x68, 0x70, 0x3c, 0x68, 0x72, 0x3c, 0x68, 0x75};
const uint8_t HuffDecoderCommon::table24_20_emit_[216] = {
    0x3c, 0x6c, 0x30, 0x3c, 0x6c, 0x31, 0x3c, 0x6c, 0x32, 0x3c, 0x6c, 0x61,
    0x3c, 0x6c, 0x63, 0x3c, 0x6c, 0x65, 0x3c, 0x6c, 0x69, 0x3c, 0x6c, 0x6f,
    0x3c, 0x6c, 0x73, 0x3c, 0x6c, 0x74, 0x3c, 0x6c, 0x20, 0x3c, 0x6c, 0x25,
    0x3c, 0x6c, 0x2d, 0x3c, 0x6c, 0x2e, 0x3c, 0x6c, 0x2f, 0x3c, 0x6c, 0x33,
    0x3c, 0x6c, 0x34, 0x3c, 0x6c, 0x35, 0x3c, 0x6c, 0x36, 0x3c, 0x6c, 0x37,
    0x3c, 0x6c, 0x38, 0x3c, 0x6c, 0x39, 0x3c, 0x6c, 0x3d, 0x3c, 0x6c, 0x41,
    0x3c, 0x6c, 0x5f, 0x3c, 0x6c, 0x62, 0x3c, 0x6c, 0x64, 0x3c, 0x6c, 0x66,
    0x3c, 0x6c, 0x67, 0x3c, 0x6c, 0x68, 0x3c, 0x6c, 0x6c, 0x3c, 0x6c, 0x6d,
    0x3c, 0x6c, 0x6e, 0x3c, 0x6c, 0x70, 0x3c, 0x6c, 0x72, 0x3c, 0x6c, 0x75,
    0x3c, 0x6d, 0x30, 0x3c, 0x6d, 0x31, 0x3c, 0x6d, 0x32, 0x3c, 0x6d, 0x61,
    0x3c, 0x6d, 0x63, 0x3c, 0x6d, 0x65, 0x3c, 0x6d, 0x69, 0x3c, 0x6d, 0x6f,
    0x3c, 0x6d, 0x73, 0x3c, 0x6d, 0x74, 0x3c, 0x6d, 0x20, 0x3c, 0x6d, 0x25,
    0x3c, 0x6d, 0x2d, 0x3c, 0x6d, 0x2e, 0x3c, 0x6d, 0x2f, 0x3c, 0x6d, 0x33,
    0x3c, 0x6d, 0x34, 0x3c, 0x6d, 0x35, 0x3c, 0x6d, 0x36, 0x3c, 0x6d, 0x37,
    0x3c, 0x6d, 0x38, 0x3c, 0x6d, 0x39, 0x3c, 0x6d, 0x3d, 0x3c, 0x6d, 0x41,
    0x3c, 0x6d, 0x5f, 0x3c, 0x6d, 0x62, 0x3c, 0x6d, 0x64, 0x3c, 0x6d, 0x66,
    0x3c, 0x6d, 0x67, 0x3c, 0x6d, 0x68, 0x3c, 0x6d, 0x6c, 0x3c, 0x6d, 0x6d,
    0x3c, 0x6d, 0x6e, 0x3c, 0x6d, 0x70, 0x3c, 0x6d, 0x72, 0x3c, 0x6d, 0x75};
const uint8_t HuffDecoderCommon::table24_21_emit_[216] = {
    0x3c, 0x6e, 0x30, 0x3c, 0x6e, 0x31, 0x3c, 0x6e, 0x32, 0x3c, 0x6e, 0x61,
    0x3c, 0x6e, 0x63, 0x3c, 0x6e, 0x65, 0x3c, 0x6e, 0x69, 0x3c, 0x6e, 0x6f,
    0x3c, 0x6e, 0x73, 0x3c, 0x6e, 0x74, 0x3c, 0x6e, 0x20, 0x3c, 0x6e, 0x25,
    0x3c, 0x6e, 0x2d, 0x3c, 0x6e, 0x2e, 0x3c, 0x6e, 0x2f, 0x3c, 0x6e, 0x33,
    0x3c, 0x6e, 0x34, 0x3c, 0x6e, 0x35, 0x3c, 0x6e, 0x36, 0x3c, 0x6e, 0x37,
    0x3c, 0x6e, 0x38, 0x3c, 0x6e, 0x39, 0x3c, 0x6e, 0x3d, 0x3c, 0x6e, 0x41,
    0x3c, 0x6e, 0x5f, 0x3c, 0x6e, 0x62, 0x3c, 0x6e, 0x64, 0x3c, 0x6e, 0x66,
    0x3c, 0x6e, 0x67, 0x3c, 0x6e, 0x68, 0x3c, 0x6e, 0x6c, 0x3c, 0x6e, 0x6d,
    0x3c, 0x6e, 0x6e, 0x3c, 0x6e, 0x70, 0x3c, 0x6e, 0x72, 0x3c, 0x6e, 0x75,
    0x3c, 0x70, 0x30, 0x3c, 0x70, 0x31, 0x3c, 0x70, 0x32, 0x3c, 0x70, 0x61,
    0x3c, 0x70, 0x63, 0x3c, 0x70, 0x65, 0x3c, 0x70, 0x69, 0x3c, 0x70, 0x6f,
    0x3c, 0x70, 0x73, 0x3c, 0x70, 0x74, 0x3c, 0x70, 0x20, 0x3c, 0x70, 0x25,
    0x3c, 0x70, 0x2d, 0x3c, 0x70, 0x2e, 0x3c, 0x70, 0x2f, 0x3c, 0x70, 0x33,
    0x3c, 0x70, 0x34, 0x3c, 0x70, 0x35, 0x3c, 0x70, 0x36, 0x3c, 0x70, 0x37,
    0x3c, 0x70, 0x38, 0x3c, 0x70, 0x39, 0x3c, 0x70, 0x3d, 0x3c, 0x70, 0x41,
    0x3c, 0x70, 0x5f, 0x3c, 0x70, 0x62, 0x3c, 0x70, 0x64, 0x3c, 0x70, 0x66,
    0x3c, 0x70, 0x67, 0x3c, 0x70, 0x68, 0x3c, 0x70, 0x6c, 0x3c, 0x70, 0x6d,
    0x3c, 0x70, 0x6e, 0x3c, 0x70, 0x70, 0x3c, 0x70, 0x72, 0x3c, 0x70, 0x75};
const uint8_t HuffDecoderCommon::table24_22_emit_[216] = {
    0x3c, 0x72, 0x30, 0x3c, 0x72, 0x31, 0x3c, 0x72, 0x32, 0x3c, 0x72, 0x61,
    0x3c, 0x72, 0x63, 0x3c, 0x72, 0x65, 0x3c, 0x72, 0x69, 0x3c, 0x72, 0x6f,
    0x3c, 0x72, 0x73, 0x3c, 0x72, 0x74, 0x3c, 0x72, 0x20, 0x3c, 0x72, 0x25,
    0x3c, 0x72, 0x2d, 0x3c, 0x72, 0x2e, 0x3c, 0x72, 0x2f, 0x3c, 0x72, 0x33,
    0x3c, 0x72, 0x34, 0x3c, 0x72, 0x35, 0x3c, 0x72, 0x36, 0x3c, 0x72, 0x37,
    0x3c, 0x72, 0x38, 0x3c, 0x72, 0x39, 0x3c, 0x72, 0x3d, 0x3c, 0x72, 0x41,
    0x3c, 0x72, 0x5f, 0x3c, 0x72, 0x62, 0x3c, 0x72, 0x64, 0x3c, 0x72, 0x66,
    0x3c, 0x72, 0x67, 0x3c, 0x72, 0x68, 0x3c, 0x72, 0x6c, 0x3c, 0x72, 0x6d,
    0x3c, 0x72, 0x6e, 0x3c, 0x72, 0x70, 0x3c, 0x72, 0x72, 0x3c, 0x72, 0x75,
    0x3c, 0x75, 0x30, 0x3c, 0x75, 0x31, 0x3c, 0x75, 0x32, 0x3c, 0x75, 0x61,
    0x3c, 0x75, 0x63, 0x3c, 0x75, 0x65, 0x3c, 0x75, 0x69, 0x3c, 0x75, 0x6f,
    0x3c, 0x75, 0x73, 0x3c, 0x75, 0x74, 0x3c, 0x75, 0x20, 0x3c, 0x75, 0x25,
    0x3c, 0x75, 0x2d, 0x3c, 0x75, 0x2e, 0x3c, 0x75, 0x2f, 0x3c, 0x75, 0x33,
    0x3c, 0x75, 0x34, 0x3c, 0x75, 0x35, 0x3c, 0x75, 0x36, 0x3c, 0x75, 0x37,
    0x3c, 0x75, 0x38, 0x3c, 0x75, 0x39, 0x3c, 0x75, 0x3d, 0x3c, 0x75, 0x41,
    0x3c, 0x75, 0x5f, 0x3c, 0x75, 0x62, 0x3c, 0x75, 0x64, 0x3c, 0x75, 0x66,
    0x3c, 0x75, 0x67, 0x3c, 0x75, 0x68, 0x3c, 0x75, 0x6c, 0x3c, 0x75, 0x6d,
    0x3c, 0x75, 0x6e, 0x3c, 0x75, 0x70, 0x3c, 0x75, 0x72, 0x3c, 0x75, 0x75};
const uint8_t HuffDecoderCommon::table24_23_emit_[120] = {
    0x3c, 0x3a, 0x30, 0x3c, 0x3a, 0x31, 0x3c, 0x3a, 0x32, 0x3c, 0x3a, 0x61,
    0x3c, 0x3a, 0x63, 0x3c, 0x3a, 0x65, 0x3c, 0x3a, 0x69, 0x3c, 0x3a, 0x6f,
    0x3c, 0x3a, 0x73, 0x3c, 0x3a, 0x74, 0x3c, 0x42, 0x30, 0x3c, 0x42, 0x31,
    0x3c, 0x42, 0x32, 0x3c, 0x42, 0x61, 0x3c, 0x42, 0x63, 0x3c, 0x42, 0x65,
    0x3c, 0x42, 0x69, 0x3c, 0x42, 0x6f, 0x3c, 0x42, 0x73, 0x3c, 0x42, 0x74,
    0x3c, 0x43, 0x30, 0x3c, 0x43, 0x31, 0x3c, 0x43, 0x32, 0x3c, 0x43, 0x61,
    0x3c, 0x43, 0x63, 0x3c, 0x43, 0x65, 0x3c, 0x43, 0x69, 0x3c, 0x43, 0x6f,
    0x3c, 0x43, 0x73, 0x3c, 0x43, 0x74, 0x3c, 0x44, 0x30, 0x3c, 0x44, 0x31,
    0x3c, 0x44, 0x32, 0x3c, 0x44, 0x61, 0x3c, 0x44, 0x63, 0x3c, 0x44, 0x65,
    0x3c, 0x44, 0x69, 0x3c, 0x44, 0x6f, 0x3c, 0x44, 0x73, 0x3c, 0x44, 0x74};
const uint8_t HuffDecoderCommon::table24_24_emit_[120] = {
    0x3c, 0x45, 0x30, 0x3c, 0x45, 0x31, 0x3c, 0x45, 0x32, 0x3c, 0x45, 0x61,
    0x3c, 0x45, 0x63, 0x3c, 0x45, 0x65, 0x3c, 0x45, 0x69, 0x3c, 0x45, 0x6f,
    0x3c, 0x45, 0x73, 0x3c, 0x45, 0x74, 0x3c, 0x46, 0x30, 0x3c, 0x46, 0x31,
    0x3c, 0x46, 0x32, 0x3c, 0x46, 0x61, 0x3c, 0x46, 0x63, 0x3c, 0x46, 0x65,
    0x3c, 0x46, 0x69, 0x3c, 0x46, 0x6f, 0x3c, 0x46, 0x73, 0x3c, 0x46, 0x74,
    0x3c, 0x47, 0x30, 0x3c, 0x47, 0x31, 0x3c, 0x47, 0x32, 0x3c, 0x47, 0x61,
    0x3c, 0x47, 0x63, 0x3c, 0x47, 0x65, 0x3c, 0x47, 0x69, 0x3c, 0x47, 0x6f,
    0x3c, 0x47, 0x73, 0x3c, 0x47, 0x74, 0x3c, 0x48, 0x30, 0x3c, 0x48, 0x31,
    0x3c, 0x48, 0x32, 0x3c, 0x48, 0x61, 0x3c, 0x48, 0x63, 0x3c, 0x48, 0x65,
    0x3c, 0x48, 0x69, 0x3c, 0x48, 0x6f, 0x3c, 0x48, 0x73, 0x3c, 0x48, 0x74};
const uint8_t HuffDecoderCommon::table24_25_emit_[120] = {
    0x3c, 0x49, 0x30, 0x3c, 0x49, 0x31, 0x3c, 0x49, 0x32, 0x3c, 0x49, 0x61,
    0x3c, 0x49, 0x63, 0x3c, 0x49, 0x65, 0x3c, 0x49, 0x69, 0x3c, 0x49, 0x6f,
    0x3c, 0x49, 0x73, 0x3c, 0x49, 0x74, 0x3c, 0x4a, 0x30, 0x3c, 0x4a, 0x31,
    0x3c, 0x4a, 0x32, 0x3c, 0x4a, 0x61, 0x3c, 0x4a, 0x63, 0x3c, 0x4a, 0x65,
    0x3c, 0x4a, 0x69, 0x3c, 0x4a, 0x6f, 0x3c, 0x4a, 0x73, 0x3c, 0x4a, 0x74,
    0x3c, 0x4b, 0x30, 0x3c, 0x4b, 0x31, 0x3c, 0x4b, 0x32, 0x3c, 0x4b, 0x61,
    0x3c, 0x4b, 0x63, 0x3c, 0x4b, 0x65, 0x3c, 0x4b, 0x69, 0x3c, 0x4b, 0x6f,
    0x3c, 0x4b, 0x73, 0x3c, 0x4b, 0x74, 0x3c, 0x4c, 0x30, 0x3c, 0x4c, 0x31,
    0x3c, 0x4c, 0x32, 0x3c, 0x4c, 0x61, 0x3c, 0x4c, 0x63, 0x3c, 0x4c, 0x65,
    0x3c, 0x4c, 0x69, 0x3c, 0x4c, 0x6f, 0x3c, 0x4c, 0x73, 0x3c, 0x4c, 0x74};
const uint8_t HuffDecoderCommon::table24_26_emit_[120] = {
    0x3c, 0x4d, 0x30, 0x3c, 0x4d, 0x31, 0x3c, 0x4d, 0x32, 0x3c, 0x4d, 0x61,
    0x3c, 0x4d, 0x63, 0x3c, 0x4d, 0x65, 0x3c, 0x4d, 0x69, 0x3c, 0x4d, 0x6f,
    0x3c, 0x4d, 0x73, 0x3c, 0x4d, 0x74, 0x3c, 0x4e, 0x30, 0x3c, 0x4e, 0x31,
    0x3c, 0x4e, 0x32, 0x3c, 0x4e, 0x61, 0x3c, 0x4e, 0x63, 0x3c, 0x4e, 0x65,
    0x3c, 0x4e, 0x69, 0x3c, 0x4e, 0x6f, 0x3c, 0x4e, 0x73, 0x3c, 0x4e, 0x74,
    0x3c, 0x4f, 0x30, 0x3c, 0x4f, 0x31, 0x3c, 0x4f, 0x32, 0x3c, 0x4f, 0x61,
    0x3c, 0x4f, 0x63, 0x3c, 0x4f, 0x65, 0x3c, 0x4f, 0x69, 0x3c, 0x4f, 0x6f,
    0x3c, 0x4f, 0x73, 0x3c, 0x4f, 0x74, 0x3c, 0x50, 0x30, 0x3c, 0x50, 0x31,
    0x3c, 0x50, 0x32, 0x3c, 0x50, 0x61, 0x3c, 0x50, 0x63, 0x3c, 0x50, 0x65,
    0x3c, 0x50, 0x69, 0x3c, 0x50, 0x6f, 0x3c, 0x50, 0x73, 0x3c, 0x50, 0x74};
const uint8_t HuffDecoderCommon::table24_27_emit_[120] = {
    0x3c, 0x51, 0x30, 0x3c, 0x51, 0x31, 0x3c, 0x51, 0x32, 0x3c, 0x51, 0x61,
    0x3c, 0x51, 0x63, 0x3c, 0x51, 0x65, 0x3c, 0x51, 0x69, 0x3c, 0x51, 0x6f,
    0x3c, 0x51, 0x73, 0x3c, 0x51, 0x74, 0x3c, 0x52, 0x30, 0x3c, 0x52, 0x31,
    0x3c, 0x52, 0x32, 0x3c, 0x52, 0x61, 0x3c, 0x52, 0x63, 0x3c, 0x52, 0x65,
    0x3c, 0x52, 0x69, 0x3c, 0x52, 0x6f, 0x3c, 0x52, 0x73, 0x3c, 0x52, 0x74,
    0x3c, 0x53, 0x30, 0x3c, 0x53, 0x31, 0x3c, 0x53, 0x32, 0x3c, 0x53, 0x61,
    0x3c, 0x53, 0x63, 0x3c, 0x53, 0x65, 0x3c, 0x53, 0x69, 0x3c, 0x53, 0x6f,
    0x3c, 0x53, 0x73, 0x3c, 0x53, 0x74, 0x3c, 0x54, 0x30, 0x3c, 0x54, 0x31,
    0x3c, 0x54, 0x32, 0x3c, 0x54, 0x61, 0x3c, 0x54, 0x63, 0x3c, 0x54, 0x65,
    0x3c, 0x54, 0x69, 0x3c, 0x54, 0x6f, 0x3c, 0x54, 0x73, 0x3c, 0x54, 0x74};
const uint8_t HuffDecoderCommon::table24_28_emit_[120] = {
    0x3c, 0x55, 0x30, 0x3c, 0x55, 0x31, 0x3c, 0x55, 0x32, 0x3c, 0x55, 0x61,
    0x3c, 0x55, 0x63, 0x3c, 0x55, 0x65, 0x3c, 0x55, 0x69, 0x3c, 0x55, 0x6f,
    0x3c, 0x55, 0x73, 0x3c, 0x55, 0x74, 0x3c, 0x56, 0x30, 0x3c, 0x56, 0x31,
    0x3c, 0x56, 0x32, 0x3c, 0x56, 0x61, 0x3c, 0x56, 0x63, 0x3c, 0x56, 0x65,
    0x3c, 0x56, 0x69, 0x3c, 0x56, 0x6f, 0x3c, 0x56, 0x73, 0x3c, 0x56, 0x74,
    0x3c, 0x57, 0x30, 0x3c, 0x57, 0x31, 0x3c, 0x57, 0x32, 0x3c, 0x57, 0x61,
    0x3c, 0x57, 0x63, 0x3c, 0x57, 0x65, 0x3c, 0x57, 0x69, 0x3c, 0x57, 0x6f,
    0x3c, 0x57, 0x73, 0x3c, 0x57, 0x74, 0x3c, 0x59, 0x30, 0x3c, 0x59, 0x31,
    0x3c, 0x59, 0x32, 0x3c, 0x59, 0x61, 0x3c, 0x59, 0x63, 0x3c, 0x59, 0x65,
    0x3c, 0x59, 0x69, 0x3c, 0x59, 0x6f, 0x3c, 0x59, 0x73, 0x3c, 0x59, 0x74};
const uint8_t HuffDecoderCommon::table24_29_emit_[120] = {
    0x3c, 0x6a, 0x30, 0x3c, 0x6a, 0x31, 0x3c, 0x6a, 0x32, 0x3c, 0x6a, 0x61,
    0x3c, 0x6a, 0x63, 0x3c, 0x6a, 0x65, 0x3c, 0x6a, 0x69, 0x3c, 0x6a, 0x6f,
    0x3c, 0x6a, 0x73, 0x3c, 0x6a, 0x74, 0x3c, 0x6b, 0x30, 0x3c, 0x6b, 0x31,
    0x3c, 0x6b, 0x32, 0x3c, 0x6b, 0x61, 0x3c, 0x6b, 0x63, 0x3c, 0x6b, 0x65,
    0x3c, 0x6b, 0x69, 0x3c, 0x6b, 0x6f, 0x3c, 0x6b, 0x73, 0x3c, 0x6b, 0x74,
    0x3c, 0x71, 0x30, 0x3c, 0x71, 0x31, 0x3c, 0x71, 0x32, 0x3c, 0x71, 0x61,
    0x3c, 0x71, 0x63, 0x3c, 0x71, 0x65, 0x3c, 0x71, 0x69, 0x3c, 0x71, 0x6f,
    0x3c, 0x71, 0x73, 0x3c, 0x71, 0x74, 0x3c, 0x76, 0x30, 0x3c, 0x76, 0x31,
    0x3c, 0x76, 0x32, 0x3c, 0x76, 0x61, 0x3c, 0x76, 0x63, 0x3c, 0x76, 0x65,
    0x3c, 0x76, 0x69, 0x3c, 0x76, 0x6f, 0x3c, 0x76, 0x73, 0x3c, 0x76, 0x74};
const uint8_t HuffDecoderCommon::table24_30_emit_[120] = {
    0x3c, 0x77, 0x30, 0x3c, 0x77, 0x31, 0x3c, 0x77, 0x32, 0x3c, 0x77, 0x61,
    0x3c, 0x77, 0x63, 0x3c, 0x77, 0x65, 0x3c, 0x77, 0x69, 0x3c, 0x77, 0x6f,
    0x3c, 0x77, 0x73, 0x3c, 0x77, 0x74, 0x3c, 0x78, 0x30, 0x3c, 0x78, 0x31,
    0x3c, 0x78, 0x32, 0x3c, 0x78, 0x61, 0x3c, 0x78, 0x63, 0x3c, 0x78, 0x65,
    0x3c, 0x78, 0x69, 0x3c, 0x78, 0x6f, 0x3c, 0x78, 0x73, 0x3c, 0x78, 0x74,
    0x3c, 0x79, 0x30, 0x3c, 0x79, 0x31, 0x3c, 0x79, 0x32, 0x3c, 0x79, 0x61,
    0x3c, 0x79, 0x63, 0x3c, 0x79, 0x65, 0x3c, 0x79, 0x69, 0x3c, 0x79, 0x6f,
    0x3c, 0x79, 0x73, 0x3c, 0x79, 0x74, 0x3c, 0x7a, 0x30, 0x3c, 0x7a, 0x31,
    0x3c, 0x7a, 0x32, 0x3c, 0x7a, 0x61, 0x3c, 0x7a, 0x63, 0x3c, 0x7a, 0x65,
    0x3c, 0x7a, 0x69, 0x3c, 0x7a, 0x6f, 0x3c, 0x7a, 0x73, 0x3c, 0x7a, 0x74};
const uint8_t HuffDecoderCommon::table24_31_emit_[32] = {
    0x3c, 0x26, 0x3c, 0x2a, 0x3c, 0x2c, 0x3c, 0x3b, 0x3c, 0x58, 0x3c,
    0x5a, 0x3c, 0x21, 0x3c, 0x22, 0x3c, 0x28, 0x3c, 0x29, 0x3c, 0x3f,
    0x3c, 0x27, 0x3c, 0x2b, 0x3c, 0x7c, 0x3c, 0x23, 0x3c, 0x3e};
const uint16_t HuffDecoderCommon::table24_31_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0062, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000,
    0x00b2, 0x0000, 0x00c2, 0x0000, 0x00d2, 0x00e2, 0x00f2, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table24_32_emit_[204] = {
    0x60, 0x30, 0x30, 0x60, 0x30, 0x31, 0x60, 0x30, 0x32, 0x60, 0x30, 0x61,
    0x60, 0x30, 0x63, 0x60, 0x30, 0x65, 0x60, 0x30, 0x69, 0x60, 0x30, 0x6f,
    0x60, 0x30, 0x73, 0x60, 0x30, 0x74, 0x60, 0x30, 0x20, 0x60, 0x30, 0x25,
    0x60, 0x30, 0x2d, 0x60, 0x30, 0x2e, 0x60, 0x30, 0x2f, 0x60, 0x30, 0x33,
    0x60, 0x30, 0x34, 0x60, 0x30, 0x35, 0x60, 0x30, 0x36, 0x60, 0x30, 0x37,
    0x60, 0x30, 0x38, 0x60, 0x30, 0x39, 0x60, 0x30, 0x3d, 0x60, 0x30, 0x41,
    0x60, 0x30, 0x5f, 0x60, 0x30, 0x62, 0x60, 0x30, 0x64, 0x60, 0x30, 0x66,
    0x60, 0x30, 0x67, 0x60, 0x30, 0x68, 0x60, 0x30, 0x6c, 0x60, 0x30, 0x6d,
    0x60, 0x30, 0x6e, 0x60, 0x30, 0x70, 0x60, 0x30, 0x72, 0x60, 0x30, 0x75,
    0x60, 0x30, 0x3a, 0x60, 0x30, 0x42, 0x60, 0x30, 0x43, 0x60, 0x30, 0x44,
    0x60, 0x30, 0x45, 0x60, 0x30, 0x46, 0x60, 0x30, 0x47, 0x60, 0x30, 0x48,
    0x60, 0x30, 0x49, 0x60, 0x30, 0x4a, 0x60, 0x30, 0x4b, 0x60, 0x30, 0x4c,
    0x60, 0x30, 0x4d, 0x60, 0x30, 0x4e, 0x60, 0x30, 0x4f, 0x60, 0x30, 0x50,
    0x60, 0x30, 0x51, 0x60, 0x30, 0x52, 0x60, 0x30, 0x53, 0x60, 0x30, 0x54,
    0x60, 0x30, 0x55, 0x60, 0x30, 0x56, 0x60, 0x30, 0x57, 0x60, 0x30, 0x59,
    0x60, 0x30, 0x6a, 0x60, 0x30, 0x6b, 0x60, 0x30, 0x71, 0x60, 0x30, 0x76,
    0x60, 0x30, 0x77, 0x60, 0x30, 0x78, 0x60, 0x30, 0x79, 0x60, 0x30, 0x7a};
const uint8_t HuffDecoderCommon::table24_33_emit_[204] = {
    0x60, 0x31, 0x30, 0x60, 0x31, 0x31, 0x60, 0x31, 0x32, 0x60, 0x31, 0x61,
    0x60, 0x31, 0x63, 0x60, 0x31, 0x65, 0x60, 0x31, 0x69, 0x60, 0x31, 0x6f,
    0x60, 0x31, 0x73, 0x60, 0x31, 0x74, 0x60, 0x31, 0x20, 0x60, 0x31, 0x25,
    0x60, 0x31, 0x2d, 0x60, 0x31, 0x2e, 0x60, 0x31, 0x2f, 0x60, 0x31, 0x33,
    0x60, 0x31, 0x34, 0x60, 0x31, 0x35, 0x60, 0x31, 0x36, 0x60, 0x31, 0x37,
    0x60, 0x31, 0x38, 0x60, 0x31, 0x39, 0x60, 0x31, 0x3d, 0x60, 0x31, 0x41,
    0x60, 0x31, 0x5f, 0x60, 0x31, 0x62, 0x60, 0x31, 0x64, 0x60, 0x31, 0x66,
    0x60, 0x31, 0x67, 0x60, 0x31, 0x68, 0x60, 0x31, 0x6c, 0x60, 0x31, 0x6d,
    0x60, 0x31, 0x6e, 0x60, 0x31, 0x70, 0x60, 0x31, 0x72, 0x60, 0x31, 0x75,
    0x60, 0x31, 0x3a, 0x60, 0x31, 0x42, 0x60, 0x31, 0x43, 0x60, 0x31, 0x44,
    0x60, 0x31, 0x45, 0x60, 0x31, 0x46, 0x60, 0x31, 0x47, 0x60, 0x31, 0x48,
    0x60, 0x31, 0x49, 0x60, 0x31, 0x4a, 0x60, 0x31, 0x4b, 0x60, 0x31, 0x4c,
    0x60, 0x31, 0x4d, 0x60, 0x31, 0x4e, 0x60, 0x31, 0x4f, 0x60, 0x31, 0x50,
    0x60, 0x31, 0x51, 0x60, 0x31, 0x52, 0x60, 0x31, 0x53, 0x60, 0x31, 0x54,
    0x60, 0x31, 0x55, 0x60, 0x31, 0x56, 0x60, 0x31, 0x57, 0x60, 0x31, 0x59,
    0x60, 0x31, 0x6a, 0x60, 0x31, 0x6b, 0x60, 0x31, 0x71, 0x60, 0x31, 0x76,
    0x60, 0x31, 0x77, 0x60, 0x31, 0x78, 0x60, 0x31, 0x79, 0x60, 0x31, 0x7a};
const uint8_t HuffDecoderCommon::table24_34_emit_[204] = {
    0x60, 0x32, 0x30, 0x60, 0x32, 0x31, 0x60, 0x32, 0x32, 0x60, 0x32, 0x61,
    0x60, 0x32, 0x63, 0x60, 0x32, 0x65, 0x60, 0x32, 0x69, 0x60, 0x32, 0x6f,
    0x60, 0x32, 0x73, 0x60, 0x32, 0x74, 0x60, 0x32, 0x20, 0x60, 0x32, 0x25,
    0x60, 0x32, 0x2d, 0x60, 0x32, 0x2e, 0x60, 0x32, 0x2f, 0x60, 0x32, 0x33,
    0x60, 0x32, 0x34, 0x60, 0x32, 0x35, 0x60, 0x32, 0x36, 0x60, 0x32, 0x37,
    0x60, 0x32, 0x38, 0x60, 0x32, 0x39, 0x60, 0x32, 0x3d, 0x60, 0x32, 0x41,
    0x60, 0x32, 0x5f, 0x60, 0x32, 0x62, 0x60, 0x32, 0x64, 0x60, 0x32, 0x66,
    0x60, 0x32, 0x67, 0x60, 0x32, 0x68, 0x60, 0x32, 0x6c, 0x60, 0x32, 0x6d,
    0x60, 0x32, 0x6e, 0x60, 0x32, 0x70, 0x60, 0x32, 0x72, 0x60, 0x32, 0x75,
    0x60, 0x32, 0x3a, 0x60, 0x32, 0x42, 0x60, 0x32, 0x43, 0x60, 0x32, 0x44,
    0x60, 0x32, 0x45, 0x60, 0x32, 0x46, 0x60, 0x32, 0x47, 0x60, 0x32, 0x48,
    0x60, 0x32, 0x49, 0x60, 0x32, 0x4a, 0x60, 0x32, 0x4b, 0x60, 0x32, 0x4c,
    0x60, 0x32, 0x4d, 0x60, 0x32, 0x4e, 0x60, 0x32, 0x4f, 0x60, 0x32, 0x50,
    0x60, 0x32, 0x51, 0x60, 0x32, 0x52, 0x60, 0x32, 0x53, 0x60, 0x32, 0x54,
    0x60, 0x32, 0x55, 0x60, 0x32, 0x56, 0x60, 0x32, 0x57, 0x60, 0x32, 0x59,
    0x60, 0x32, 0x6a, 0x60, 0x32, 0x6b, 0x60, 0x32, 0x71, 0x60, 0x32, 0x76,
    0x60, 0x32, 0x77, 0x60, 0x32, 0x78, 0x60, 0x32, 0x79, 0x60, 0x32, 0x7a};
const uint8_t HuffDecoderCommon::table24_35_emit_[204] = {
    0x60, 0x61, 0x30, 0x60, 0x61, 0x31, 0x60, 0x61, 0x32, 0x60, 0x61, 0x61,
    0x60, 0x61, 0x63, 0x60, 0x61, 0x65, 0x60, 0x61, 0x69, 0x60, 0x61, 0x6f,
    0x60, 0x61, 0x73, 0x60, 0x61, 0x74, 0x60, 0x61, 0x20, 0x60, 0x61, 0x25,
    0x60, 0x61, 0x2d, 0x60, 0x61, 0x2e, 0x60, 0x61, 0x2f, 0x60, 0x61, 0x33,
    0x60, 0x61, 0x34, 0x60, 0x61, 0x35, 0x60, 0x61, 0x36, 0x60, 0x61, 0x37,
    0x60, 0x61, 0x38, 0x60, 0x61, 0x39, 0x60, 0x61, 0x3d, 0x60, 0x61, 0x41,
    0x60, 0x61, 0x5f, 0x60, 0x61, 0x62, 0x60, 0x61, 0x64, 0x60, 0x61, 0x66,
    0x60, 0x61, 0x67, 0x60, 0x61, 0x68, 0x60, 0x61, 0x6c, 0x60, 0x61, 0x6d,
    0x60, 0x61, 0x6e, 0x60, 0x61, 0x70, 0x60, 0x61, 0x72, 0x60, 0x61, 0x75,
    0x60, 0x61, 0x3a, 0x60, 0x61, 0x42, 0x60, 0x61, 0x43, 0x60, 0x61, 0x44,
    0x60, 0x61, 0x45, 0x60, 0x61, 0x46, 0x60, 0x61, 0x47, 0x60, 0x61, 0x48,
    0x60, 0x61, 0x49, 0x60, 0x61, 0x4a, 0x60, 0x61, 0x4b, 0x60, 0x61, 0x4c,
    0x60, 0x61, 0x4d, 0x60, 0x61, 0x4e, 0x60, 0x61, 0x4f, 0x60, 0x61, 0x50,
    0x60, 0x61, 0x51, 0x60, 0x61, 0x52, 0x60, 0x61, 0x53, 0x60, 0x61, 0x54,
    0x60, 0x61, 0x55, 0x60, 0x61, 0x56, 0x60, 0x61, 0x57, 0x60, 0x61, 0x59,
    0x60, 0x61, 0x6a, 0x60, 0x61, 0x6b, 0x60, 0x61, 0x71, 0x60, 0x61, 0x76,
    0x60, 0x61, 0x77, 0x60, 0x61, 0x78, 0x60, 0x61, 0x79, 0x60, 0x61, 0x7a};
const uint8_t HuffDecoderCommon::table24_36_emit_[204] = {
    0x60, 0x63, 0x30, 0x60, 0x63, 0x31, 0x60, 0x63, 0x32, 0x60, 0x63, 0x61,
    0x60, 0x63, 0x63, 0x60, 0x63, 0x65, 0x60, 0x63, 0x69, 0x60, 0x63, 0x6f,
    0x60, 0x63, 0x73, 0x60, 0x63, 0x74, 0x60, 0x63, 0x20, 0x60, 0x63, 0x25,
    0x60, 0x63, 0x2d, 0x60, 0x63, 0x2e, 0x60, 0x63, 0x2f, 0x60, 0x63, 0x33,
    0x60, 0x63, 0x34, 0x60, 0x63, 0x35, 0x60, 0x63, 0x36, 0x60, 0x63, 0x37,
    0x60, 0x63, 0x38, 0x60, 0x63, 0x39, 0x60, 0x63, 0x3d, 0x60, 0x63, 0x41,
    0x60, 0x63, 0x5f, 0x60, 0x63, 0x62, 0x60, 0x63, 0x64, 0x60, 0x63, 0x66,
    0x60, 0x63, 0x67, 0x60, 0x63, 0x68, 0x60, 0x63, 0x6c, 0x60, 0x63, 0x6d,
    0x60, 0x63, 0x6e, 0x60, 0x63, 0x70, 0x60, 0x63, 0x72, 0x60, 0x63, 0x75,
    0x60, 0x63, 0x3a, 0x60, 0x63, 0x42, 0x60, 0x63, 0x43, 0x60, 0x63, 0x44,
    0x60, 0x63, 0x45, 0x60, 0x63, 0x46, 0x60, 0x63, 0x47, 0x60, 0x63, 0x48,
    0x60, 0x63, 0x49, 0x60, 0x63, 0x4a, 0x60, 0x63, 0x4b, 0x60, 0x63, 0x4c,
    0x60, 0x63, 0x4d, 0x60, 0x63, 0x4e, 0x60, 0x63, 0x4f, 0x60, 0x63, 0x50,
    0x60, 0x63, 0x51, 0x60, 0x63, 0x52, 0x60, 0x63, 0x53, 0x60, 0x63, 0x54,
    0x60, 0x63, 0x55, 0x60, 0x63, 0x56, 0x60, 0x63, 0x57, 0x60, 0x63, 0x59,
    0x60, 0x63, 0x6a, 0x60, 0x63, 0x6b, 0x60, 0x63, 0x71, 0x60, 0x63, 0x76,
    0x60, 0x63, 0x77, 0x60, 0x63, 0x78, 0x60, 0x63, 0x79, 0x60, 0x63, 0x7a};
const uint8_t HuffDecoderCommon::table24_37_emit_[204] = {
    0x60, 0x65, 0x30, 0x60, 0x65, 0x31, 0x60, 0x65, 0x32, 0x60, 0x65, 0x61,
    0x60, 0x65, 0x63, 0x60, 0x65, 0x65, 0x60, 0x65, 0x69, 0x60, 0x65, 0x6f,
    0x60, 0x65, 0x73, 0x60, 0x65, 0x74, 0x60, 0x65, 0x20, 0x60, 0x65, 0x25,
    0x60, 0x65, 0x2d, 0x60, 0x65, 0x2e, 0x60, 0x65, 0x2f, 0x60, 0x65, 0x33,
    0x60, 0x65, 0x34, 0x60, 0x65, 0x35, 0x60, 0x65, 0x36, 0x60, 0x65, 0x37,
    0x60, 0x65, 0x38, 0x60, 0x65, 0x39, 0x60, 0x65, 0x3d, 0x60, 0x65, 0x41,
    0x60, 0x65, 0x5f, 0x60, 0x65, 0x62, 0x60, 0x65, 0x64, 0x60, 0x65, 0x66,
    0x60, 0x65, 0x67, 0x60, 0x65, 0x68, 0x60, 0x65, 0x6c, 0x60, 0x65, 0x6d,
    0x60, 0x65, 0x6e, 0x60, 0x65, 0x70, 0x60, 0x65, 0x72, 0x60, 0x65, 0x75,
    0x60, 0x65, 0x3a, 0x60, 0x65, 0x42, 0x60, 0x65, 0x43, 0x60, 0x65, 0x44,
    0x60, 0x65, 0x45, 0x60, 0x65, 0x46, 0x60, 0x65, 0x47, 0x60, 0x65, 0x48,
    0x60, 0x65, 0x49, 0x60, 0x65, 0x4a, 0x60, 0x65, 0x4b, 0x60, 0x65, 0x4c,
    0x60, 0x65, 0x4d, 0x60, 0x65, 0x4e, 0x60, 0x65, 0x4f, 0x60, 0x65, 0x50,
    0x60, 0x65, 0x51, 0x60, 0x65, 0x52, 0x60, 0x65, 0x53, 0x60, 0x65, 0x54,
    0x60, 0x65, 0x55, 0x60, 0x65, 0x56, 0x60, 0x65, 0x57, 0x60, 0x65, 0x59,
    0x60, 0x65, 0x6a, 0x60, 0x65, 0x6b, 0x60, 0x65, 0x71, 0x60, 0x65, 0x76,
    0x60, 0x65, 0x77, 0x60, 0x65, 0x78, 0x60, 0x65, 0x79, 0x60, 0x65, 0x7a};
const uint8_t HuffDecoderCommon::table24_38_emit_[204] = {
    0x60, 0x69, 0x30, 0x60, 0x69, 0x31, 0x60, 0x69, 0x32, 0x60, 0x69, 0x61,
    0x60, 0x69, 0x63, 0x60, 0x69, 0x65, 0x60, 0x69, 0x69, 0x60, 0x69, 0x6f,
    0x60, 0x69, 0x73, 0x60, 0x69, 0x74, 0x60, 0x69, 0x20, 0x60, 0x69, 0x25,
    0x60, 0x69, 0x2d, 0x60, 0x69, 0x2e, 0x60, 0x69, 0x2f, 0x60, 0x69, 0x33,
    0x60, 0x69, 0x34, 0x60, 0x69, 0x35, 0x60, 0x69, 0x36, 0x60, 0x69, 0x37,
    0x60, 0x69, 0x38, 0x60, 0x69, 0x39, 0x60, 0x69, 0x3d, 0x60, 0x69, 0x41,
    0x60, 0x69, 0x5f, 0x60, 0x69, 0x62, 0x60, 0x69, 0x64, 0x60, 0x69, 0x66,
    0x60, 0x69, 0x67, 0x60, 0x69, 0x68, 0x60, 0x69, 0x6c, 0x60, 0x69, 0x6d,
    0x60, 0x69, 0x6e, 0x60, 0x69, 0x70, 0x60, 0x69, 0x72, 0x60, 0x69, 0x75,
    0x60, 0x69, 0x3a, 0x60, 0x69, 0x42, 0x60, 0x69, 0x43, 0x60, 0x69, 0x44,
    0x60, 0x69, 0x45, 0x60, 0x69, 0x46, 0x60, 0x69, 0x47, 0x60, 0x69, 0x48,
    0x60, 0x69, 0x49, 0x60, 0x69, 0x4a, 0x60, 0x69, 0x4b, 0x60, 0x69, 0x4c,
    0x60, 0x69, 0x4d, 0x60, 0x69, 0x4e, 0x60, 0x69, 0x4f, 0x60, 0x69, 0x50,
    0x60, 0x69, 0x51, 0x60, 0x69, 0x52, 0x60, 0x69, 0x53, 0x60, 0x69, 0x54,
    0x60, 0x69, 0x55, 0x60, 0x69, 0x56, 0x60, 0x69, 0x57, 0x60, 0x69, 0x59,
    0x60, 0x69, 0x6a, 0x60, 0x69, 0x6b, 0x60, 0x69, 0x71, 0x60, 0x69, 0x76,
    0x60, 0x69, 0x77, 0x60, 0x69, 0x78, 0x60, 0x69, 0x79, 0x60, 0x69, 0x7a};
const uint8_t HuffDecoderCommon::table24_39_emit_[204] = {
    0x60, 0x6f, 0x30, 0x60, 0x6f, 0x31, 0x60, 0x6f, 0x32, 0x60, 0x6f, 0x61,
    0x60, 0x6f, 0x63, 0x60, 0x6f, 0x65, 0x60, 0x6f, 0x69, 0x60, 0x6f, 0x6f,
    0x60, 0x6f, 0x73, 0x60, 0x6f, 0x74, 0x60, 0x6f, 0x20, 0x60, 0x6f, 0x25,
    0x60, 0x6f, 0x2d, 0x60, 0x6f, 0x2e, 0x60, 0x6f, 0x2f, 0x60, 0x6f, 0x33,
    0x60, 0x6f, 0x34, 0x60, 0x6f, 0x35, 0x60, 0x6f, 0x36, 0x60, 0x6f, 0x37,
    0x60, 0x6f, 0x38, 0x60, 0x6f, 0x39, 0x60, 0x6f, 0x3d, 0x60, 0x6f, 0x41,
    0x60, 0x6f, 0x5f, 0x60, 0x6f, 0x62, 0x60, 0x6f, 0x64, 0x60, 0x6f, 0x66,
    0x60, 0x6f, 0x67, 0x60, 0x6f, 0x68, 0x60, 0x6f, 0x6c, 0x60, 0x6f, 0x6d,
    0x60, 0x6f, 0x6e, 0x60, 0x6f, 0x70, 0x60, 0x6f, 0x72, 0x60, 0x6f, 0x75,
    0x60, 0x6f, 0x3a, 0x60, 0x6f, 0x42, 0x60, 0x6f, 0x43, 0x60, 0x6f, 0x44,
    0x60, 0x6f, 0x45, 0x60, 0x6f, 0x46, 0x60, 0x6f, 0x47, 0x60, 0x6f, 0x48,
    0x60, 0x6f, 0x49, 0x60, 0x6f, 0x4a, 0x60, 0x6f, 0x4b, 0x60, 0x6f, 0x4c,
    0x60, 0x6f, 0x4d, 0x60, 0x6f, 0x4e, 0x60, 0x6f, 0x4f, 0x60, 0x6f, 0x50,
    0x60, 0x6f, 0x51, 0x60, 0x6f, 0x52, 0x60, 0x6f, 0x53, 0x60, 0x6f, 0x54,
    0x60, 0x6f, 0x55, 0x60, 0x6f, 0x56, 0x60, 0x6f, 0x57, 0x60, 0x6f, 0x59,
    0x60, 0x6f, 0x6a, 0x60, 0x6f, 0x6b, 0x60, 0x6f, 0x71, 0x60, 0x6f, 0x76,
    0x60, 0x6f, 0x77, 0x60, 0x6f, 0x78, 0x60, 0x6f, 0x79, 0x60, 0x6f, 0x7a};
const uint8_t HuffDecoderCommon::table24_40_emit_[204] = {
    0x60, 0x73, 0x30, 0x60, 0x73, 0x31, 0x60, 0x73, 0x32, 0x60, 0x73, 0x61,
    0x60, 0x73, 0x63, 0x60, 0x73, 0x65, 0x60, 0x73, 0x69, 0x60, 0x73, 0x6f,
    0x60, 0x73, 0x73, 0x60, 0x73, 0x74, 0x60, 0x73, 0x20, 0x60, 0x73, 0x25,
    0x60, 0x73, 0x2d, 0x60, 0x73, 0x2e, 0x60, 0x73, 0x2f, 0x60, 0x73, 0x33,
    0x60, 0x73, 0x34, 0x60, 0x73, 0x35, 0x60, 0x73, 0x36, 0x60, 0x73, 0x37,
    0x60, 0x73, 0x38, 0x60, 0x73, 0x39, 0x60, 0x73, 0x3d, 0x60, 0x73, 0x41,
    0x60, 0x73, 0x5f, 0x60, 0x73, 0x62, 0x60, 0x73, 0x64, 0x60, 0x73, 0x66,
    0x60, 0x73, 0x67, 0x60, 0x73, 0x68, 0x60, 0x73, 0x6c, 0x60, 0x73, 0x6d,
    0x60, 0x73, 0x6e, 0x60, 0x73, 0x70, 0x60, 0x73, 0x72, 0x60, 0x73, 0x75,
    0x60, 0x73, 0x3a, 0x60, 0x73, 0x42, 0x60, 0x73, 0x43, 0x60, 0x73, 0x44,
    0x60, 0x73, 0x45, 0x60, 0x73, 0x46, 0x60, 0x73, 0x47, 0x60, 0x73, 0x48,
    0x60, 0x73, 0x49, 0x60, 0x73, 0x4a, 0x60, 0x73, 0x4b, 0x60, 0x73, 0x4c,
    0x60, 0x73, 0x4d, 0x60, 0x73, 0x4e, 0x60, 0x73, 0x4f, 0x60, 0x73, 0x50,
    0x60, 0x73, 0x51, 0x60, 0x73, 0x52, 0x60, 0x73, 0x53, 0x60, 0x73, 0x54,
    0x60, 0x73, 0x55, 0x60, 0x73, 0x56, 0x60, 0x73, 0x57, 0x60, 0x73, 0x59,
    0x60, 0x73, 0x6a, 0x60, 0x73, 0x6b, 0x60, 0x73, 0x71, 0x60, 0x73, 0x76,
    0x60, 0x73, 0x77, 0x60, 0x73, 0x78, 0x60, 0x73, 0x79, 0x60, 0x73, 0x7a};
const uint8_t HuffDecoderCommon::table24_41_emit_[204] = {
    0x60, 0x74, 0x30, 0x60, 0x74, 0x31, 0x60, 0x74, 0x32, 0x60, 0x74, 0x61,
    0x60, 0x74, 0x63, 0x60, 0x74, 0x65, 0x60, 0x74, 0x69, 0x60, 0x74, 0x6f,
    0x60, 0x74, 0x73, 0x60, 0x74, 0x74, 0x60, 0x74, 0x20, 0x60, 0x74, 0x25,
    0x60, 0x74, 0x2d, 0x60, 0x74, 0x2e, 0x60, 0x74, 0x2f, 0x60, 0x74, 0x33,
    0x60, 0x74, 0x34, 0x60, 0x74, 0x35, 0x60, 0x74, 0x36, 0x60, 0x74, 0x37,
    0x60, 0x74, 0x38, 0x60, 0x74, 0x39, 0x60, 0x74, 0x3d, 0x60, 0x74, 0x41,
    0x60, 0x74, 0x5f, 0x60, 0x74, 0x62, 0x60, 0x74, 0x64, 0x60, 0x74, 0x66,
    0x60, 0x74, 0x67, 0x60, 0x74, 0x68, 0x60, 0x74, 0x6c, 0x60, 0x74, 0x6d,
    0x60, 0x74, 0x6e, 0x60, 0x74, 0x70, 0x60, 0x74, 0x72, 0x60, 0x74, 0x75,
    0x60, 0x74, 0x3a, 0x60, 0x74, 0x42, 0x60, 0x74, 0x43, 0x60, 0x74, 0x44,
    0x60, 0x74, 0x45, 0x60, 0x74, 0x46, 0x60, 0x74, 0x47, 0x60, 0x74, 0x48,
    0x60, 0x74, 0x49, 0x60, 0x74, 0x4a, 0x60, 0x74, 0x4b, 0x60, 0x74, 0x4c,
    0x60, 0x74, 0x4d, 0x60, 0x74, 0x4e, 0x60, 0x74, 0x4f, 0x60, 0x74, 0x50,
    0x60, 0x74, 0x51, 0x60, 0x74, 0x52, 0x60, 0x74, 0x53, 0x60, 0x74, 0x54,
    0x60, 0x74, 0x55, 0x60, 0x74, 0x56, 0x60, 0x74, 0x57, 0x60, 0x74, 0x59,
    0x60, 0x74, 0x6a, 0x60, 0x74, 0x6b, 0x60, 0x74, 0x71, 0x60, 0x74, 0x76,
    0x60, 0x74, 0x77, 0x60, 0x74, 0x78, 0x60, 0x74, 0x79, 0x60, 0x74, 0x7a};
const uint8_t HuffDecoderCommon::table24_42_emit_[216] = {
    0x60, 0x20, 0x30, 0x60, 0x20, 0x31, 0x60, 0x20, 0x32, 0x60, 0x20, 0x61,
    0x60, 0x20, 0x63, 0x60, 0x20, 0x65, 0x60, 0x20, 0x69, 0x60, 0x20, 0x6f,
    0x60, 0x20, 0x73, 0x60, 0x20, 0x74, 0x60, 0x20, 0x20, 0x60, 0x20, 0x25,
    0x60, 0x20, 0x2d, 0x60, 0x20, 0x2e, 0x60, 0x20, 0x2f, 0x60, 0x20, 0x33,
    0x60, 0x20, 0x34, 0x60, 0x20, 0x35, 0x60, 0x20, 0x36, 0x60, 0x20, 0x37,
    0x60, 0x20, 0x38, 0x60, 0x20, 0x39, 0x60, 0x20, 0x3d, 0x60, 0x20, 0x41,
    0x60, 0x20, 0x5f, 0x60, 0x20, 0x62, 0x60, 0x20, 0x64, 0x60, 0x20, 0x66,
    0x60, 0x20, 0x67, 0x60, 0x20, 0x68, 0x60, 0x20, 0x6c, 0x60, 0x20, 0x6d,
    0x60, 0x20, 0x6e, 0x60, 0x20, 0x70, 0x60, 0x20, 0x72, 0x60, 0x20, 0x75,
    0x60, 0x25, 0x30, 0x60, 0x25, 0x31, 0x60, 0x25, 0x32, 0x60, 0x25, 0x61,
    0x60, 0x25, 0x63, 0x60, 0x25, 0x65, 0x60, 0x25, 0x69, 0x60, 0x25, 0x6f,
    0x60, 0x25, 0x73, 0x60, 0x25, 0x74, 0x60, 0x25, 0x20, 0x60, 0x25, 0x25,
    0x60, 0x25, 0x2d, 0x60, 0x25, 0x2e, 0x60, 0x25, 0x2f, 0x60, 0x25, 0x33,
    0x60, 0x25, 0x34, 0x60, 0x25, 0x35, 0x60, 0x25, 0x36, 0x60, 0x25, 0x37,
    0x60, 0x25, 0x38, 0x60, 0x25, 0x39, 0x60, 0x25, 0x3d, 0x60, 0x25, 0x41,
    0x60, 0x25, 0x5f, 0x60, 0x25, 0x62, 0x60, 0x25, 0x64, 0x60, 0x25, 0x66,
    0x60, 0x25, 0x67, 0x60, 0x25, 0x68, 0x60, 0x25, 0x6c, 0x60, 0x25, 0x6d,
    0x60, 0x25, 0x6e, 0x60, 0x25, 0x70, 0x60, 0x25, 0x72, 0x60, 0x25, 0x75};
const uint8_t HuffDecoderCommon::table24_43_emit_[216] = {
    0x60, 0x2d, 0x30, 0x60, 0x2d, 0x31, 0x60, 0x2d, 0x32, 0x60, 0x2d, 0x61,
    0x60, 0x2d, 0x63, 0x60, 0x2d, 0x65, 0x60, 0x2d, 0x69, 0x60, 0x2d, 0x6f,
    0x60, 0x2d, 0x73, 0x60, 0x2d, 0x74, 0x60, 0x2d, 0x20, 0x60, 0x2d, 0x25,
    0x60, 0x2d, 0x2d, 0x60, 0x2d, 0x2e, 0x60, 0x2d, 0x2f, 0x60, 0x2d, 0x33,
    0x60, 0x2d, 0x34, 0x60, 0x2d, 0x35, 0x60, 0x2d, 0x36, 0x60, 0x2d, 0x37,
    0x60, 0x2d, 0x38, 0x60, 0x2d, 0x39, 0x60, 0x2d, 0x3d, 0x60, 0x2d, 0x41,
    0x60, 0x2d, 0x5f, 0x60, 0x2d, 0x62, 0x60, 0x2d, 0x64, 0x60, 0x2d, 0x66,
    0x60, 0x2d, 0x67, 0x60, 0x2d, 0x68, 0x60, 0x2d, 0x6c, 0x60, 0x2d, 0x6d,
    0x60, 0x2d, 0x6e, 0x60, 0x2d, 0x70, 0x60, 0x2d, 0x72, 0x60, 0x2d, 0x75,
    0x60, 0x2e, 0x30, 0x60, 0x2e, 0x31, 0x60, 0x2e, 0x32, 0x60, 0x2e, 0x61,
    0x60, 0x2e, 0x63, 0x60, 0x2e, 0x65, 0x60, 0x2e, 0x69, 0x60, 0x2e, 0x6f,
    0x60, 0x2e, 0x73, 0x60, 0x2e, 0x74, 0x60, 0x2e, 0x20, 0x60, 0x2e, 0x25,
    0x60, 0x2e, 0x2d, 0x60, 0x2e, 0x2e, 0x60, 0x2e, 0x2f, 0x60, 0x2e, 0x33,
    0x60, 0x2e, 0x34, 0x60, 0x2e, 0x35, 0x60, 0x2e, 0x36, 0x60, 0x2e, 0x37,
    0x60, 0x2e, 0x38, 0x60, 0x2e, 0x39, 0x60, 0x2e, 0x3d, 0x60, 0x2e, 0x41,
    0x60, 0x2e, 0x5f, 0x60, 0x2e, 0x62, 0x60, 0x2e, 0x64, 0x60, 0x2e, 0x66,
    0x60, 0x2e, 0x67, 0x60, 0x2e, 0x68, 0x60, 0x2e, 0x6c, 0x60, 0x2e, 0x6d,
    0x60, 0x2e, 0x6e, 0x60, 0x2e, 0x70, 0x60, 0x2e, 0x72, 0x60, 0x2e, 0x75};
const uint8_t HuffDecoderCommon::table24_44_emit_[216] = {
    0x60, 0x2f, 0x30, 0x60, 0x2f, 0x31, 0x60, 0x2f, 0x32, 0x60, 0x2f, 0x61,
    0x60, 0x2f, 0x63, 0x60, 0x2f, 0x65, 0x60, 0x2f, 0x69, 0x60, 0x2f, 0x6f,
    0x60, 0x2f, 0x73, 0x60, 0x2f, 0x74, 0x60, 0x2f, 0x20, 0x60, 0x2f, 0x25,
    0x60, 0x2f, 0x2d, 0x60, 0x2f, 0x2e, 0x60, 0x2f, 0x2f, 0x60, 0x2f, 0x33,
    0x60, 0x2f, 0x34, 0x60, 0x2f, 0x35, 0x60, 0x2f, 0x36, 0x60, 0x2f, 0x37,
    0x60, 0x2f, 0x38, 0x60, 0x2f, 0x39, 0x60, 0x2f, 0x3d, 0x60, 0x2f, 0x41,
    0x60, 0x2f, 0x5f, 0x60, 0x2f, 0x62, 0x60, 0x2f, 0x64, 0x60, 0x2f, 0x66,
    0x60, 0x2f, 0x67, 0x60, 0x2f, 0x68, 0x60, 0x2f, 0x6c, 0x60, 0x2f, 0x6d,
    0x60, 0x2f, 0x6e, 0x60, 0x2f, 0x70, 0x60, 0x2f, 0x72, 0x60, 0x2f, 0x75,
    0x60, 0x33, 0x30, 0x60, 0x33, 0x31, 0x60, 0x33, 0x32, 0x60, 0x33, 0x61,
    0x60, 0x33, 0x63, 0x60, 0x33, 0x65, 0x60, 0x33, 0x69, 0x60, 0x33, 0x6f,
    0x60, 0x33, 0x73, 0x60, 0x33, 0x74, 0x60, 0x33, 0x20, 0x60, 0x33, 0x25,
    0x60, 0x33, 0x2d, 0x60, 0x33, 0x2e, 0x60, 0x33, 0x2f, 0x60, 0x33, 0x33,
    0x60, 0x33, 0x34, 0x60, 0x33, 0x35, 0x60, 0x33, 0x36, 0x60, 0x33, 0x37,
    0x60, 0x33, 0x38, 0x60, 0x33, 0x39, 0x60, 0x33, 0x3d, 0x60, 0x33, 0x41,
    0x60, 0x33, 0x5f, 0x60, 0x33, 0x62, 0x60, 0x33, 0x64, 0x60, 0x33, 0x66,
    0x60, 0x33, 0x67, 0x60, 0x33, 0x68, 0x60, 0x33, 0x6c, 0x60, 0x33, 0x6d,
    0x60, 0x33, 0x6e, 0x60, 0x33, 0x70, 0x60, 0x33, 0x72, 0x60, 0x33, 0x75};
const uint8_t HuffDecoderCommon::table24_45_emit_[216] = {
    0x60, 0x34, 0x30, 0x60, 0x34, 0x31, 0x60, 0x34, 0x32, 0x60, 0x34, 0x61,
    0x60, 0x34, 0x63, 0x60, 0x34, 0x65, 0x60, 0x34, 0x69, 0x60, 0x34, 0x6f,
    0x60, 0x34, 0x73, 0x60, 0x34, 0x74, 0x60, 0x34, 0x20, 0x60, 0x34, 0x25,
    0x60, 0x34, 0x2d, 0x60, 0x34, 0x2e, 0x60, 0x34, 0x2f, 0x60, 0x34, 0x33,
    0x60, 0x34, 0x34, 0x60, 0x34, 0x35, 0x60, 0x34, 0x36, 0x60, 0x34, 0x37,
    0x60, 0x34, 0x38, 0x60, 0x34, 0x39, 0x60, 0x34, 0x3d, 0x60, 0x34, 0x41,
    0x60, 0x34, 0x5f, 0x60, 0x34, 0x62, 0x60, 0x34, 0x64, 0x60, 0x34, 0x66,
    0x60, 0x34, 0x67, 0x60, 0x34, 0x68, 0x60, 0x34, 0x6c, 0x60, 0x34, 0x6d,
    0x60, 0x34, 0x6e, 0x60, 0x34, 0x70, 0x60, 0x34, 0x72, 0x60, 0x34, 0x75,
    0x60, 0x35, 0x30, 0x60, 0x35, 0x31, 0x60, 0x35, 0x32, 0x60, 0x35, 0x61,
    0x60, 0x35, 0x63, 0x60, 0x35, 0x65, 0x60, 0x35, 0x69, 0x60, 0x35, 0x6f,
    0x60, 0x35, 0x73, 0x60, 0x35, 0x74, 0x60, 0x35, 0x20, 0x60, 0x35, 0x25,
    0x60, 0x35, 0x2d, 0x60, 0x35, 0x2e, 0x60, 0x35, 0x2f, 0x60, 0x35, 0x33,
    0x60, 0x35, 0x34, 0x60, 0x35, 0x35, 0x60, 0x35, 0x36, 0x60, 0x35, 0x37,
    0x60, 0x35, 0x38, 0x60, 0x35, 0x39, 0x60, 0x35, 0x3d, 0x60, 0x35, 0x41,
    0x60, 0x35, 0x5f, 0x60, 0x35, 0x62, 0x60, 0x35, 0x64, 0x60, 0x35, 0x66,
    0x60, 0x35, 0x67, 0x60, 0x35, 0x68, 0x60, 0x35, 0x6c, 0x60, 0x35, 0x6d,
    0x60, 0x35, 0x6e, 0x60, 0x35, 0x70, 0x60, 0x35, 0x72, 0x60, 0x35, 0x75};
const uint8_t HuffDecoderCommon::table24_46_emit_[216] = {
    0x60, 0x36, 0x30, 0x60, 0x36, 0x31, 0x60, 0x36, 0x32, 0x60, 0x36, 0x61,
    0x60, 0x36, 0x63, 0x60, 0x36, 0x65, 0x60, 0x36, 0x69, 0x60, 0x36, 0x6f,
    0x60, 0x36, 0x73, 0x60, 0x36, 0x74, 0x60, 0x36, 0x20, 0x60, 0x36, 0x25,
    0x60, 0x36, 0x2d, 0x60, 0x36, 0x2e, 0x60, 0x36, 0x2f, 0x60, 0x36, 0x33,
    0x60, 0x36, 0x34, 0x60, 0x36, 0x35, 0x60, 0x36, 0x36, 0x60, 0x36, 0x37,
    0x60, 0x36, 0x38, 0x60, 0x36, 0x39, 0x60, 0x36, 0x3d, 0x60, 0x36, 0x41,
    0x60, 0x36, 0x5f, 0x60, 0x36, 0x62, 0x60, 0x36, 0x64, 0x60, 0x36, 0x66,
    0x60, 0x36, 0x67, 0x60, 0x36, 0x68, 0x60, 0x36, 0x6c, 0x60, 0x36, 0x6d,
    0x60, 0x36, 0x6e, 0x60, 0x36, 0x70, 0x60, 0x36, 0x72, 0x60, 0x36, 0x75,
    0x60, 0x37, 0x30, 0x60, 0x37, 0x31, 0x60, 0x37, 0x32, 0x60, 0x37, 0x61,
    0x60, 0x37, 0x63, 0x60, 0x37, 0x65, 0x60, 0x37, 0x69, 0x60, 0x37, 0x6f,
    0x60, 0x37, 0x73, 0x60, 0x37, 0x74, 0x60, 0x37, 0x20, 0x60, 0x37, 0x25,
    0x60, 0x37, 0x2d, 0x60, 0x37, 0x2e, 0x60, 0x37, 0x2f, 0x60, 0x37, 0x33,
    0x60, 0x37, 0x34, 0x60, 0x37, 0x35, 0x60, 0x37, 0x36, 0x60, 0x37, 0x37,
    0x60, 0x37, 0x38, 0x60, 0x37, 0x39, 0x60, 0x37, 0x3d, 0x60, 0x37, 0x41,
    0x60, 0x37, 0x5f, 0x60, 0x37, 0x62, 0x60, 0x37, 0x64, 0x60, 0x37, 0x66,
    0x60, 0x37, 0x67, 0x60, 0x37, 0x68, 0x60, 0x37, 0x6c, 0x60, 0x37, 0x6d,
    0x60, 0x37, 0x6e, 0x60, 0x37, 0x70, 0x60, 0x37, 0x72, 0x60, 0x37, 0x75};
const uint8_t HuffDecoderCommon::table24_47_emit_[216] = {
    0x60, 0x38, 0x30, 0x60, 0x38, 0x31, 0x60, 0x38, 0x32, 0x60, 0x38, 0x61,
    0x60, 0x38, 0x63, 0x60, 0x38, 0x65, 0x60, 0x38, 0x69, 0x60, 0x38, 0x6f,
    0x60, 0x38, 0x73, 0x60, 0x38, 0x74, 0x60, 0x38, 0x20, 0x60, 0x38, 0x25,
    0x60, 0x38, 0x2d, 0x60, 0x38, 0x2e, 0x60, 0x38, 0x2f, 0x60, 0x38, 0x33,
    0x60, 0x38, 0x34, 0x60, 0x38, 0x35, 0x60, 0x38, 0x36, 0x60, 0x38, 0x37,
    0x60, 0x38, 0x38, 0x60, 0x38, 0x39, 0x60, 0x38, 0x3d, 0x60, 0x38, 0x41,
    0x60, 0x38, 0x5f, 0x60, 0x38, 0x62, 0x60, 0x38, 0x64, 0x60, 0x38, 0x66,
    0x60, 0x38, 0x67, 0x60, 0x38, 0x68, 0x60, 0x38, 0x6c, 0x60, 0x38, 0x6d,
    0x60, 0x38, 0x6e, 0x60, 0x38, 0x70, 0x60, 0x38, 0x72, 0x60, 0x38, 0x75,
    0x60, 0x39, 0x30, 0x60, 0x39, 0x31, 0x60, 0x39, 0x32, 0x60, 0x39, 0x61,
    0x60, 0x39, 0x63, 0x60, 0x39, 0x65, 0x60, 0x39, 0x69, 0x60, 0x39, 0x6f,
    0x60, 0x39, 0x73, 0x60, 0x39, 0x74, 0x60, 0x39, 0x20, 0x60, 0x39, 0x25,
    0x60, 0x39, 0x2d, 0x60, 0x39, 0x2e, 0x60, 0x39, 0x2f, 0x60, 0x39, 0x33,
    0x60, 0x39, 0x34, 0x60, 0x39, 0x35, 0x60, 0x39, 0x36, 0x60, 0x39, 0x37,
    0x60, 0x39, 0x38, 0x60, 0x39, 0x39, 0x60, 0x39, 0x3d, 0x60, 0x39, 0x41,
    0x60, 0x39, 0x5f, 0x60, 0x39, 0x62, 0x60, 0x39, 0x64, 0x60, 0x39, 0x66,
    0x60, 0x39, 0x67, 0x60, 0x39, 0x68, 0x60, 0x39, 0x6c, 0x60, 0x39, 0x6d,
    0x60, 0x39, 0x6e, 0x60, 0x39, 0x70, 0x60, 0x39, 0x72, 0x60, 0x39, 0x75};
const uint8_t HuffDecoderCommon::table24_48_emit_[216] = {
    0x60, 0x3d, 0x30, 0x60, 0x3d, 0x31, 0x60, 0x3d, 0x32, 0x60, 0x3d, 0x61,
    0x60, 0x3d, 0x63, 0x60, 0x3d, 0x65, 0x60, 0x3d, 0x69, 0x60, 0x3d, 0x6f,
    0x60, 0x3d, 0x73, 0x60, 0x3d, 0x74, 0x60, 0x3d, 0x20, 0x60, 0x3d, 0x25,
    0x60, 0x3d, 0x2d, 0x60, 0x3d, 0x2e, 0x60, 0x3d, 0x2f, 0x60, 0x3d, 0x33,
    0x60, 0x3d, 0x34, 0x60, 0x3d, 0x35, 0x60, 0x3d, 0x36, 0x60, 0x3d, 0x37,
    0x60, 0x3d, 0x38, 0x60, 0x3d, 0x39, 0x60, 0x3d, 0x3d, 0x60, 0x3d, 0x41,
    0x60, 0x3d, 0x5f, 0x60, 0x3d, 0x62, 0x60, 0x3d, 0x64, 0x60, 0x3d, 0x66,
    0x60, 0x3d, 0x67, 0x60, 0x3d, 0x68, 0x60, 0x3d, 0x6c, 0x60, 0x3d, 0x6d,
    0x60, 0x3d, 0x6e, 0x60, 0x3d, 0x70, 0x60, 0x3d, 0x72, 0x60, 0x3d, 0x75,
    0x60, 0x41, 0x30, 0x60, 0x41, 0x31, 0x60, 0x41, 0x32, 0x60, 0x41, 0x61,
    0x60, 0x41, 0x63, 0x60, 0x41, 0x65, 0x60, 0x41, 0x69, 0x60, 0x41, 0x6f,
    0x60, 0x41, 0x73, 0x60, 0x41, 0x74, 0x60, 0x41, 0x20, 0x60, 0x41, 0x25,
    0x60, 0x41, 0x2d, 0x60, 0x41, 0x2e, 0x60, 0x41, 0x2f, 0x60, 0x41, 0x33,
    0x60, 0x41, 0x34, 0x60, 0x41, 0x35, 0x60, 0x41, 0x36, 0x60, 0x41, 0x37,
    0x60, 0x41, 0x38, 0x60, 0x41, 0x39, 0x60, 0x41, 0x3d, 0x60, 0x41, 0x41,
    0x60, 0x41, 0x5f, 0x60, 0x41, 0x62, 0x60, 0x41, 0x64, 0x60, 0x41, 0x66,
    0x60, 0x41, 0x67, 0x60, 0x41, 0x68, 0x60, 0x41, 0x6c, 0x60, 0x41, 0x6d,
    0x60, 0x41, 0x6e, 0x60, 0x41, 0x70, 0x60, 0x41, 0x72, 0x60, 0x41, 0x75};
const uint8_t HuffDecoderCommon::table24_49_emit_[216] = {
    0x60, 0x5f, 0x30, 0x60, 0x5f, 0x31, 0x60, 0x5f, 0x32, 0x60, 0x5f, 0x61,
    0x60, 0x5f, 0x63, 0x60, 0x5f, 0x65, 0x60, 0x5f, 0x69, 0x60, 0x5f, 0x6f,
    0x60, 0x5f, 0x73, 0x60, 0x5f, 0x74, 0x60, 0x5f, 0x20, 0x60, 0x5f, 0x25,
    0x60, 0x5f, 0x2d, 0x60, 0x5f, 0x2e, 0x60, 0x5f, 0x2f, 0x60, 0x5f, 0x33,
    0x60, 0x5f, 0x34, 0x60, 0x5f, 0x35, 0x60, 0x5f, 0x36, 0x60, 0x5f, 0x37,
    0x60, 0x5f, 0x38, 0x60, 0x5f, 0x39, 0x60, 0x5f, 0x3d, 0x60, 0x5f, 0x41,
    0x60, 0x5f, 0x5f, 0x60, 0x5f, 0x62, 0x60, 0x5f, 0x64, 0x60, 0x5f, 0x66,
    0x60, 0x5f, 0x67, 0x60, 0x5f, 0x68, 0x60, 0x5f, 0x6c, 0x60, 0x5f, 0x6d,
    0x60, 0x5f, 0x6e, 0x60, 0x5f, 0x70, 0x60, 0x5f, 0x72, 0x60, 0x5f, 0x75,
    0x60, 0x62, 0x30, 0x60, 0x62, 0x31, 0x60, 0x62, 0x32, 0x60, 0x62, 0x61,
    0x60, 0x62, 0x63, 0x60, 0x62, 0x65, 0x60, 0x62, 0x69, 0x60, 0x62, 0x6f,
    0x60, 0x62, 0x73, 0x60, 0x62, 0x74, 0x60, 0x62, 0x20, 0x60, 0x62, 0x25,
    0x60, 0x62, 0x2d, 0x60, 0x62, 0x2e, 0x60, 0x62, 0x2f, 0x60, 0x62, 0x33,
    0x60, 0x62, 0x34, 0x60, 0x62, 0x35, 0x60, 0x62, 0x36, 0x60, 0x62, 0x37,
    0x60, 0x62, 0x38, 0x60, 0x62, 0x39, 0x60, 0x62, 0x3d, 0x60, 0x62, 0x41,
    0x60, 0x62, 0x5f, 0x60, 0x62, 0x62, 0x60, 0x62, 0x64, 0x60, 0x62, 0x66,
    0x60, 0x62, 0x67, 0x60, 0x62, 0x68, 0x60, 0x62, 0x6c, 0x60, 0x62, 0x6d,
    0x60, 0x62, 0x6e, 0x60, 0x62, 0x70, 0x60, 0x62, 0x72, 0x60, 0x62, 0x75};
const uint8_t HuffDecoderCommon::table24_50_emit_[216] = {
    0x60, 0x64, 0x30, 0x60, 0x64, 0x31, 0x60, 0x64, 0x32, 0x60, 0x64, 0x61,
    0x60, 0x64, 0x63, 0x60, 0x64, 0x65, 0x60, 0x64, 0x69, 0x60, 0x64, 0x6f,
    0x60, 0x64, 0x73, 0x60, 0x64, 0x74, 0x60, 0x64, 0x20, 0x60, 0x64, 0x25,
    0x60, 0x64, 0x2d, 0x60, 0x64, 0x2e, 0x60, 0x64, 0x2f, 0x60, 0x64, 0x33,
    0x60, 0x64, 0x34, 0x60, 0x64, 0x35, 0x60, 0x64, 0x36, 0x60, 0x64, 0x37,
    0x60, 0x64, 0x38, 0x60, 0x64, 0x39, 0x60, 0x64, 0x3d, 0x60, 0x64, 0x41,
    0x60, 0x64, 0x5f, 0x60, 0x64, 0x62, 0x60, 0x64, 0x64, 0x60, 0x64, 0x66,
    0x60, 0x64, 0x67, 0x60, 0x64, 0x68, 0x60, 0x64, 0x6c, 0x60, 0x64, 0x6d,
    0x60, 0x64, 0x6e, 0x60, 0x64, 0x70, 0x60, 0x64, 0x72, 0x60, 0x64, 0x75,
    0x60, 0x66, 0x30, 0x60, 0x66, 0x31, 0x60, 0x66, 0x32, 0x60, 0x66, 0x61,
    0x60, 0x66, 0x63, 0x60, 0x66, 0x65, 0x60, 0x66, 0x69, 0x60, 0x66, 0x6f,
    0x60, 0x66, 0x73, 0x60, 0x66, 0x74, 0x60, 0x66, 0x20, 0x60, 0x66, 0x25,
    0x60, 0x66, 0x2d, 0x60, 0x66, 0x2e, 0x60, 0x66, 0x2f, 0x60, 0x66, 0x33,
    0x60, 0x66, 0x34, 0x60, 0x66, 0x35, 0x60, 0x66, 0x36, 0x60, 0x66, 0x37,
    0x60, 0x66, 0x38, 0x60, 0x66, 0x39, 0x60, 0x66, 0x3d, 0x60, 0x66, 0x41,
    0x60, 0x66, 0x5f, 0x60, 0x66, 0x62, 0x60, 0x66, 0x64, 0x60, 0x66, 0x66,
    0x60, 0x66, 0x67, 0x60, 0x66, 0x68, 0x60, 0x66, 0x6c, 0x60, 0x66, 0x6d,
    0x60, 0x66, 0x6e, 0x60, 0x66, 0x70, 0x60, 0x66, 0x72, 0x60, 0x66, 0x75};
const uint8_t HuffDecoderCommon::table24_51_emit_[216] = {
    0x60, 0x67, 0x30, 0x60, 0x67, 0x31, 0x60, 0x67, 0x32, 0x60, 0x67, 0x61,
    0x60, 0x67, 0x63, 0x60, 0x67, 0x65, 0x60, 0x67, 0x69, 0x60, 0x67, 0x6f,
    0x60, 0x67, 0x73, 0x60, 0x67, 0x74, 0x60, 0x67, 0x20, 0x60, 0x67, 0x25,
    0x60, 0x67, 0x2d, 0x60, 0x67, 0x2e, 0x60, 0x67, 0x2f, 0x60, 0x67, 0x33,
    0x60, 0x67, 0x34, 0x60, 0x67, 0x35, 0x60, 0x67, 0x36, 0x60, 0x67, 0x37,
    0x60, 0x67, 0x38, 0x60, 0x67, 0x39, 0x60, 0x67, 0x3d, 0x60, 0x67, 0x41,
    0x60, 0x67, 0x5f, 0x60, 0x67, 0x62, 0x60, 0x67, 0x64, 0x60, 0x67, 0x66,
    0x60, 0x67, 0x67, 0x60, 0x67, 0x68, 0x60, 0x67, 0x6c, 0x60, 0x67, 0x6d,
    0x60, 0x67, 0x6e, 0x60, 0x67, 0x70, 0x60, 0x67, 0x72, 0x60, 0x67, 0x75,
    0x60, 0x68, 0x30, 0x60, 0x68, 0x31, 0x60, 0x68, 0x32, 0x60, 0x68, 0x61,
    0x60, 0x68, 0x63, 0x60, 0x68, 0x65, 0x60, 0x68, 0x69, 0x60, 0x68, 0x6f,
    0x60, 0x68, 0x73, 0x60, 0x68, 0x74, 0x60, 0x68, 0x20, 0x60, 0x68, 0x25,
    0x60, 0x68, 0x2d, 0x60, 0x68, 0x2e, 0x60, 0x68, 0x2f, 0x60, 0x68, 0x33,
    0x60, 0x68, 0x34, 0x60, 0x68, 0x35, 0x60, 0x68, 0x36, 0x60, 0x68, 0x37,
    0x60, 0x68, 0x38, 0x60, 0x68, 0x39, 0x60, 0x68, 0x3d, 0x60, 0x68, 0x41,
    0x60, 0x68, 0x5f, 0x60, 0x68, 0x62, 0x60, 0x68, 0x64, 0x60, 0x68, 0x66,
    0x60, 0x68, 0x67, 0x60, 0x68, 0x68, 0x60, 0x68, 0x6c, 0x60, 0x68, 0x6d,
    0x60, 0x68, 0x6e, 0x60, 0x68, 0x70, 0x60, 0x68, 0x72, 0x60, 0x68, 0x75};
const uint8_t HuffDecoderCommon::table24_52_emit_[216] = {
    0x60, 0x6c, 0x30, 0x60, 0x6c, 0x31, 0x60, 0x6c, 0x32, 0x60, 0x6c, 0x61,
    0x60, 0x6c, 0x63, 0x60, 0x6c, 0x65, 0x60, 0x6c, 0x69, 0x60, 0x6c, 0x6f,
    0x60, 0x6c, 0x73, 0x60, 0x6c, 0x74, 0x60, 0x6c, 0x20, 0x60, 0x6c, 0x25,
    0x60, 0x6c, 0x2d, 0x60, 0x6c, 0x2e, 0x60, 0x6c, 0x2f, 0x60, 0x6c, 0x33,
    0x60, 0x6c, 0x34, 0x60, 0x6c, 0x35, 0x60, 0x6c, 0x36, 0x60, 0x6c, 0x37,
    0x60, 0x6c, 0x38, 0x60, 0x6c, 0x39, 0x60, 0x6c, 0x3d, 0x60, 0x6c, 0x41,
    0x60, 0x6c, 0x5f, 0x60, 0x6c, 0x62, 0x60, 0x6c, 0x64, 0x60, 0x6c, 0x66,
    0x60, 0x6c, 0x67, 0x60, 0x6c, 0x68, 0x60, 0x6c, 0x6c, 0x60, 0x6c, 0x6d,
    0x60, 0x6c, 0x6e, 0x60, 0x6c, 0x70, 0x60, 0x6c, 0x72, 0x60, 0x6c, 0x75,
    0x60, 0x6d, 0x30, 0x60, 0x6d, 0x31, 0x60, 0x6d, 0x32, 0x60, 0x6d, 0x61,
    0x60, 0x6d, 0x63, 0x60, 0x6d, 0x65, 0x60, 0x6d, 0x69, 0x60, 0x6d, 0x6f,
    0x60, 0x6d, 0x73, 0x60, 0x6d, 0x74, 0x60, 0x6d, 0x20, 0x60, 0x6d, 0x25,
    0x60, 0x6d, 0x2d, 0x60, 0x6d, 0x2e, 0x60, 0x6d, 0x2f, 0x60, 0x6d, 0x33,
    0x60, 0x6d, 0x34, 0x60, 0x6d, 0x35, 0x60, 0x6d, 0x36, 0x60, 0x6d, 0x37,
    0x60, 0x6d, 0x38, 0x60, 0x6d, 0x39, 0x60, 0x6d, 0x3d, 0x60, 0x6d, 0x41,
    0x60, 0x6d, 0x5f, 0x60, 0x6d, 0x62, 0x60, 0x6d, 0x64, 0x60, 0x6d, 0x66,
    0x60, 0x6d, 0x67, 0x60, 0x6d, 0x68, 0x60, 0x6d, 0x6c, 0x60, 0x6d, 0x6d,
    0x60, 0x6d, 0x6e, 0x60, 0x6d, 0x70, 0x60, 0x6d, 0x72, 0x60, 0x6d, 0x75};
const uint8_t HuffDecoderCommon::table24_53_emit_[216] = {
    0x60, 0x6e, 0x30, 0x60, 0x6e, 0x31, 0x60, 0x6e, 0x32, 0x60, 0x6e, 0x61,
    0x60, 0x6e, 0x63, 0x60, 0x6e, 0x65, 0x60, 0x6e, 0x69, 0x60, 0x6e, 0x6f,
    0x60, 0x6e, 0x73, 0x60, 0x6e, 0x74, 0x60, 0x6e, 0x20, 0x60, 0x6e, 0x25,
    0x60, 0x6e, 0x2d, 0x60, 0x6e, 0x2e, 0x60, 0x6e, 0x2f, 0x60, 0x6e, 0x33,
    0x60, 0x6e, 0x34, 0x60, 0x6e, 0x35, 0x60, 0x6e, 0x36, 0x60, 0x6e, 0x37,
    0x60, 0x6e, 0x38, 0x60, 0x6e, 0x39, 0x60, 0x6e, 0x3d, 0x60, 0x6e, 0x41,
    0x60, 0x6e, 0x5f, 0x60, 0x6e, 0x62, 0x60, 0x6e, 0x64, 0x60, 0x6e, 0x66,
    0x60, 0x6e, 0x67, 0x60, 0x6e, 0x68, 0x60, 0x6e, 0x6c, 0x60, 0x6e, 0x6d,
    0x60, 0x6e, 0x6e, 0x60, 0x6e, 0x70, 0x60, 0x6e, 0x72, 0x60, 0x6e, 0x75,
    0x60, 0x70, 0x30, 0x60, 0x70, 0x31, 0x60, 0x70, 0x32, 0x60, 0x70, 0x61,
    0x60, 0x70, 0x63, 0x60, 0x70, 0x65, 0x60, 0x70, 0x69, 0x60, 0x70, 0x6f,
    0x60, 0x70, 0x73, 0x60, 0x70, 0x74, 0x60, 0x70, 0x20, 0x60, 0x70, 0x25,
    0x60, 0x70, 0x2d, 0x60, 0x70, 0x2e, 0x60, 0x70, 0x2f, 0x60, 0x70, 0x33,
    0x60, 0x70, 0x34, 0x60, 0x70, 0x35, 0x60, 0x70, 0x36, 0x60, 0x70, 0x37,
    0x60, 0x70, 0x38, 0x60, 0x70, 0x39, 0x60, 0x70, 0x3d, 0x60, 0x70, 0x41,
    0x60, 0x70, 0x5f, 0x60, 0x70, 0x62, 0x60, 0x70, 0x64, 0x60, 0x70, 0x66,
    0x60, 0x70, 0x67, 0x60, 0x70, 0x68, 0x60, 0x70, 0x6c, 0x60, 0x70, 0x6d,
    0x60, 0x70, 0x6e, 0x60, 0x70, 0x70, 0x60, 0x70, 0x72, 0x60, 0x70, 0x75};
const uint8_t HuffDecoderCommon::table24_54_emit_[216] = {
    0x60, 0x72, 0x30, 0x60, 0x72, 0x31, 0x60, 0x72, 0x32, 0x60, 0x72, 0x61,
    0x60, 0x72, 0x63, 0x60, 0x72, 0x65, 0x60, 0x72, 0x69, 0x60, 0x72, 0x6f,
    0x60, 0x72, 0x73, 0x60, 0x72, 0x74, 0x60, 0x72, 0x20, 0x60, 0x72, 0x25,
    0x60, 0x72, 0x2d, 0x60, 0x72, 0x2e, 0x60, 0x72, 0x2f, 0x60, 0x72, 0x33,
    0x60, 0x72, 0x34, 0x60, 0x72, 0x35, 0x60, 0x72, 0x36, 0x60, 0x72, 0x37,
    0x60, 0x72, 0x38, 0x60, 0x72, 0x39, 0x60, 0x72, 0x3d, 0x60, 0x72, 0x41,
    0x60, 0x72, 0x5f, 0x60, 0x72, 0x62, 0x60, 0x72, 0x64, 0x60, 0x72, 0x66,
    0x60, 0x72, 0x67, 0x60, 0x72, 0x68, 0x60, 0x72, 0x6c, 0x60, 0x72, 0x6d,
    0x60, 0x72, 0x6e, 0x60, 0x72, 0x70, 0x60, 0x72, 0x72, 0x60, 0x72, 0x75,
    0x60, 0x75, 0x30, 0x60, 0x75, 0x31, 0x60, 0x75, 0x32, 0x60, 0x75, 0x61,
    0x60, 0x75, 0x63, 0x60, 0x75, 0x65, 0x60, 0x75, 0x69, 0x60, 0x75, 0x6f,
    0x60, 0x75, 0x73, 0x60, 0x75, 0x74, 0x60, 0x75, 0x20, 0x60, 0x75, 0x25,
    0x60, 0x75, 0x2d, 0x60, 0x75, 0x2e, 0x60, 0x75, 0x2f, 0x60, 0x75, 0x33,
    0x60, 0x75, 0x34, 0x60, 0x75, 0x35, 0x60, 0x75, 0x36, 0x60, 0x75, 0x37,
    0x60, 0x75, 0x38, 0x60, 0x75, 0x39, 0x60, 0x75, 0x3d, 0x60, 0x75, 0x41,
    0x60, 0x75, 0x5f, 0x60, 0x75, 0x62, 0x60, 0x75, 0x64, 0x60, 0x75, 0x66,
    0x60, 0x75, 0x67, 0x60, 0x75, 0x68, 0x60, 0x75, 0x6c, 0x60, 0x75, 0x6d,
    0x60, 0x75, 0x6e, 0x60, 0x75, 0x70, 0x60, 0x75, 0x72, 0x60, 0x75, 0x75};
const uint8_t HuffDecoderCommon::table24_55_emit_[120] = {
    0x60, 0x3a, 0x30, 0x60, 0x3a, 0x31, 0x60, 0x3a, 0x32, 0x60, 0x3a, 0x61,
    0x60, 0x3a, 0x63, 0x60, 0x3a, 0x65, 0x60, 0x3a, 0x69, 0x60, 0x3a, 0x6f,
    0x60, 0x3a, 0x73, 0x60, 0x3a, 0x74, 0x60, 0x42, 0x30, 0x60, 0x42, 0x31,
    0x60, 0x42, 0x32, 0x60, 0x42, 0x61, 0x60, 0x42, 0x63, 0x60, 0x42, 0x65,
    0x60, 0x42, 0x69, 0x60, 0x42, 0x6f, 0x60, 0x42, 0x73, 0x60, 0x42, 0x74,
    0x60, 0x43, 0x30, 0x60, 0x43, 0x31, 0x60, 0x43, 0x32, 0x60, 0x43, 0x61,
    0x60, 0x43, 0x63, 0x60, 0x43, 0x65, 0x60, 0x43, 0x69, 0x60, 0x43, 0x6f,
    0x60, 0x43, 0x73, 0x60, 0x43, 0x74, 0x60, 0x44, 0x30, 0x60, 0x44, 0x31,
    0x60, 0x44, 0x32, 0x60, 0x44, 0x61, 0x60, 0x44, 0x63, 0x60, 0x44, 0x65,
    0x60, 0x44, 0x69, 0x60, 0x44, 0x6f, 0x60, 0x44, 0x73, 0x60, 0x44, 0x74};
const uint8_t HuffDecoderCommon::table24_56_emit_[120] = {
    0x60, 0x45, 0x30, 0x60, 0x45, 0x31, 0x60, 0x45, 0x32, 0x60, 0x45, 0x61,
    0x60, 0x45, 0x63, 0x60, 0x45, 0x65, 0x60, 0x45, 0x69, 0x60, 0x45, 0x6f,
    0x60, 0x45, 0x73, 0x60, 0x45, 0x74, 0x60, 0x46, 0x30, 0x60, 0x46, 0x31,
    0x60, 0x46, 0x32, 0x60, 0x46, 0x61, 0x60, 0x46, 0x63, 0x60, 0x46, 0x65,
    0x60, 0x46, 0x69, 0x60, 0x46, 0x6f, 0x60, 0x46, 0x73, 0x60, 0x46, 0x74,
    0x60, 0x47, 0x30, 0x60, 0x47, 0x31, 0x60, 0x47, 0x32, 0x60, 0x47, 0x61,
    0x60, 0x47, 0x63, 0x60, 0x47, 0x65, 0x60, 0x47, 0x69, 0x60, 0x47, 0x6f,
    0x60, 0x47, 0x73, 0x60, 0x47, 0x74, 0x60, 0x48, 0x30, 0x60, 0x48, 0x31,
    0x60, 0x48, 0x32, 0x60, 0x48, 0x61, 0x60, 0x48, 0x63, 0x60, 0x48, 0x65,
    0x60, 0x48, 0x69, 0x60, 0x48, 0x6f, 0x60, 0x48, 0x73, 0x60, 0x48, 0x74};
const uint8_t HuffDecoderCommon::table24_57_emit_[120] = {
    0x60, 0x49, 0x30, 0x60, 0x49, 0x31, 0x60, 0x49, 0x32, 0x60, 0x49, 0x61,
    0x60, 0x49, 0x63, 0x60, 0x49, 0x65, 0x60, 0x49, 0x69, 0x60, 0x49, 0x6f,
    0x60, 0x49, 0x73, 0x60, 0x49, 0x74, 0x60, 0x4a, 0x30, 0x60, 0x4a, 0x31,
    0x60, 0x4a, 0x32, 0x60, 0x4a, 0x61, 0x60, 0x4a, 0x63, 0x60, 0x4a, 0x65,
    0x60, 0x4a, 0x69, 0x60, 0x4a, 0x6f, 0x60, 0x4a, 0x73, 0x60, 0x4a, 0x74,
    0x60, 0x4b, 0x30, 0x60, 0x4b, 0x31, 0x60, 0x4b, 0x32, 0x60, 0x4b, 0x61,
    0x60, 0x4b, 0x63, 0x60, 0x4b, 0x65, 0x60, 0x4b, 0x69, 0x60, 0x4b, 0x6f,
    0x60, 0x4b, 0x73, 0x60, 0x4b, 0x74, 0x60, 0x4c, 0x30, 0x60, 0x4c, 0x31,
    0x60, 0x4c, 0x32, 0x60, 0x4c, 0x61, 0x60, 0x4c, 0x63, 0x60, 0x4c, 0x65,
    0x60, 0x4c, 0x69, 0x60, 0x4c, 0x6f, 0x60, 0x4c, 0x73, 0x60, 0x4c, 0x74};
const uint8_t HuffDecoderCommon::table24_58_emit_[120] = {
    0x60, 0x4d, 0x30, 0x60, 0x4d, 0x31, 0x60, 0x4d, 0x32, 0x60, 0x4d, 0x61,
    0x60, 0x4d, 0x63, 0x60, 0x4d, 0x65, 0x60, 0x4d, 0x69, 0x60, 0x4d, 0x6f,
    0x60, 0x4d, 0x73, 0x60, 0x4d, 0x74, 0x60, 0x4e, 0x30, 0x60, 0x4e, 0x31,
    0x60, 0x4e, 0x32, 0x60, 0x4e, 0x61, 0x60, 0x4e, 0x63, 0x60, 0x4e, 0x65,
    0x60, 0x4e, 0x69, 0x60, 0x4e, 0x6f, 0x60, 0x4e, 0x73, 0x60, 0x4e, 0x74,
    0x60, 0x4f, 0x30, 0x60, 0x4f, 0x31, 0x60, 0x4f, 0x32, 0x60, 0x4f, 0x61,
    0x60, 0x4f, 0x63, 0x60, 0x4f, 0x65, 0x60, 0x4f, 0x69, 0x60, 0x4f, 0x6f,
    0x60, 0x4f, 0x73, 0x60, 0x4f, 0x74, 0x60, 0x50, 0x30, 0x60, 0x50, 0x31,
    0x60, 0x50, 0x32, 0x60, 0x50, 0x61, 0x60, 0x50, 0x63, 0x60, 0x50, 0x65,
    0x60, 0x50, 0x69, 0x60, 0x50, 0x6f, 0x60, 0x50, 0x73, 0x60, 0x50, 0x74};
const uint8_t HuffDecoderCommon::table24_59_emit_[120] = {
    0x60, 0x51, 0x30, 0x60, 0x51, 0x31, 0x60, 0x51, 0x32, 0x60, 0x51, 0x61,
    0x60, 0x51, 0x63, 0x60, 0x51, 0x65, 0x60, 0x51, 0x69, 0x60, 0x51, 0x6f,
    0x60, 0x51, 0x73, 0x60, 0x51, 0x74, 0x60, 0x52, 0x30, 0x60, 0x52, 0x31,
    0x60, 0x52, 0x32, 0x60, 0x52, 0x61, 0x60, 0x52, 0x63, 0x60, 0x52, 0x65,
    0x60, 0x52, 0x69, 0x60, 0x52, 0x6f, 0x60, 0x52, 0x73, 0x60, 0x52, 0x74,
    0x60, 0x53, 0x30, 0x60, 0x53, 0x31, 0x60, 0x53, 0x32, 0x60, 0x53, 0x61,
    0x60, 0x53, 0x63, 0x60, 0x53, 0x65, 0x60, 0x53, 0x69, 0x60, 0x53, 0x6f,
    0x60, 0x53, 0x73, 0x60, 0x53, 0x74, 0x60, 0x54, 0x30, 0x60, 0x54, 0x31,
    0x60, 0x54, 0x32, 0x60, 0x54, 0x61, 0x60, 0x54, 0x63, 0x60, 0x54, 0x65,
    0x60, 0x54, 0x69, 0x60, 0x54, 0x6f, 0x60, 0x54, 0x73, 0x60, 0x54, 0x74};
const uint8_t HuffDecoderCommon::table24_60_emit_[120] = {
    0x60, 0x55, 0x30, 0x60, 0x55, 0x31, 0x60, 0x55, 0x32, 0x60, 0x55, 0x61,
    0x60, 0x55, 0x63, 0x60, 0x55, 0x65, 0x60, 0x55, 0x69, 0x60, 0x55, 0x6f,
    0x60, 0x55, 0x73, 0x60, 0x55, 0x74, 0x60, 0x56, 0x30, 0x60, 0x56, 0x31,
    0x60, 0x56, 0x32, 0x60, 0x56, 0x61, 0x60, 0x56, 0x63, 0x60, 0x56, 0x65,
    0x60, 0x56, 0x69, 0x60, 0x56, 0x6f, 0x60, 0x56, 0x73, 0x60, 0x56, 0x74,
    0x60, 0x57, 0x30, 0x60, 0x57, 0x31, 0x60, 0x57, 0x32, 0x60, 0x57, 0x61,
    0x60, 0x57, 0x63, 0x60, 0x57, 0x65, 0x60, 0x57, 0x69, 0x60, 0x57, 0x6f,
    0x60, 0x57, 0x73, 0x60, 0x57, 0x74, 0x60, 0x59, 0x30, 0x60, 0x59, 0x31,
    0x60, 0x59, 0x32, 0x60, 0x59, 0x61, 0x60, 0x59, 0x63, 0x60, 0x59, 0x65,
    0x60, 0x59, 0x69, 0x60, 0x59, 0x6f, 0x60, 0x59, 0x73, 0x60, 0x59, 0x74};
const uint8_t HuffDecoderCommon::table24_61_emit_[120] = {
    0x60, 0x6a, 0x30, 0x60, 0x6a, 0x31, 0x60, 0x6a, 0x32, 0x60, 0x6a, 0x61,
    0x60, 0x6a, 0x63, 0x60, 0x6a, 0x65, 0x60, 0x6a, 0x69, 0x60, 0x6a, 0x6f,
    0x60, 0x6a, 0x73, 0x60, 0x6a, 0x74, 0x60, 0x6b, 0x30, 0x60, 0x6b, 0x31,
    0x60, 0x6b, 0x32, 0x60, 0x6b, 0x61, 0x60, 0x6b, 0x63, 0x60, 0x6b, 0x65,
    0x60, 0x6b, 0x69, 0x60, 0x6b, 0x6f, 0x60, 0x6b, 0x73, 0x60, 0x6b, 0x74,
    0x60, 0x71, 0x30, 0x60, 0x71, 0x31, 0x60, 0x71, 0x32, 0x60, 0x71, 0x61,
    0x60, 0x71, 0x63, 0x60, 0x71, 0x65, 0x60, 0x71, 0x69, 0x60, 0x71, 0x6f,
    0x60, 0x71, 0x73, 0x60, 0x71, 0x74, 0x60, 0x76, 0x30, 0x60, 0x76, 0x31,
    0x60, 0x76, 0x32, 0x60, 0x76, 0x61, 0x60, 0x76, 0x63, 0x60, 0x76, 0x65,
    0x60, 0x76, 0x69, 0x60, 0x76, 0x6f, 0x60, 0x76, 0x73, 0x60, 0x76, 0x74};
const uint8_t HuffDecoderCommon::table24_62_emit_[120] = {
    0x60, 0x77, 0x30, 0x60, 0x77, 0x31, 0x60, 0x77, 0x32, 0x60, 0x77, 0x61,
    0x60, 0x77, 0x63, 0x60, 0x77, 0x65, 0x60, 0x77, 0x69, 0x60, 0x77, 0x6f,
    0x60, 0x77, 0x73, 0x60, 0x77, 0x74, 0x60, 0x78, 0x30, 0x60, 0x78, 0x31,
    0x60, 0x78, 0x32, 0x60, 0x78, 0x61, 0x60, 0x78, 0x63, 0x60, 0x78, 0x65,
    0x60, 0x78, 0x69, 0x60, 0x78, 0x6f, 0x60, 0x78, 0x73, 0x60, 0x78, 0x74,
    0x60, 0x79, 0x30, 0x60, 0x79, 0x31, 0x60, 0x79, 0x32, 0x60, 0x79, 0x61,
    0x60, 0x79, 0x63, 0x60, 0x79, 0x65, 0x60, 0x79, 0x69, 0x60, 0x79, 0x6f,
    0x60, 0x79, 0x73, 0x60, 0x79, 0x74, 0x60, 0x7a, 0x30, 0x60, 0x7a, 0x31,
    0x60, 0x7a, 0x32, 0x60, 0x7a, 0x61, 0x60, 0x7a, 0x63, 0x60, 0x7a, 0x65,
    0x60, 0x7a, 0x69, 0x60, 0x7a, 0x6f, 0x60, 0x7a, 0x73, 0x60, 0x7a, 0x74};
const uint8_t HuffDecoderCommon::table24_63_emit_[32] = {
    0x60, 0x26, 0x60, 0x2a, 0x60, 0x2c, 0x60, 0x3b, 0x60, 0x58, 0x60,
    0x5a, 0x60, 0x21, 0x60, 0x22, 0x60, 0x28, 0x60, 0x29, 0x60, 0x3f,
    0x60, 0x27, 0x60, 0x2b, 0x60, 0x7c, 0x60, 0x23, 0x60, 0x3e};
const uint8_t HuffDecoderCommon::table24_64_emit_[204] = {
    0x7b, 0x30, 0x30, 0x7b, 0x30, 0x31, 0x7b, 0x30, 0x32, 0x7b, 0x30, 0x61,
    0x7b, 0x30, 0x63, 0x7b, 0x30, 0x65, 0x7b, 0x30, 0x69, 0x7b, 0x30, 0x6f,
    0x7b, 0x30, 0x73, 0x7b, 0x30, 0x74, 0x7b, 0x30, 0x20, 0x7b, 0x30, 0x25,
    0x7b, 0x30, 0x2d, 0x7b, 0x30, 0x2e, 0x7b, 0x30, 0x2f, 0x7b, 0x30, 0x33,
    0x7b, 0x30, 0x34, 0x7b, 0x30, 0x35, 0x7b, 0x30, 0x36, 0x7b, 0x30, 0x37,
    0x7b, 0x30, 0x38, 0x7b, 0x30, 0x39, 0x7b, 0x30, 0x3d, 0x7b, 0x30, 0x41,
    0x7b, 0x30, 0x5f, 0x7b, 0x30, 0x62, 0x7b, 0x30, 0x64, 0x7b, 0x30, 0x66,
    0x7b, 0x30, 0x67, 0x7b, 0x30, 0x68, 0x7b, 0x30, 0x6c, 0x7b, 0x30, 0x6d,
    0x7b, 0x30, 0x6e, 0x7b, 0x30, 0x70, 0x7b, 0x30, 0x72, 0x7b, 0x30, 0x75,
    0x7b, 0x30, 0x3a, 0x7b, 0x30, 0x42, 0x7b, 0x30, 0x43, 0x7b, 0x30, 0x44,
    0x7b, 0x30, 0x45, 0x7b, 0x30, 0x46, 0x7b, 0x30, 0x47, 0x7b, 0x30, 0x48,
    0x7b, 0x30, 0x49, 0x7b, 0x30, 0x4a, 0x7b, 0x30, 0x4b, 0x7b, 0x30, 0x4c,
    0x7b, 0x30, 0x4d, 0x7b, 0x30, 0x4e, 0x7b, 0x30, 0x4f, 0x7b, 0x30, 0x50,
    0x7b, 0x30, 0x51, 0x7b, 0x30, 0x52, 0x7b, 0x30, 0x53, 0x7b, 0x30, 0x54,
    0x7b, 0x30, 0x55, 0x7b, 0x30, 0x56, 0x7b, 0x30, 0x57, 0x7b, 0x30, 0x59,
    0x7b, 0x30, 0x6a, 0x7b, 0x30, 0x6b, 0x7b, 0x30, 0x71, 0x7b, 0x30, 0x76,
    0x7b, 0x30, 0x77, 0x7b, 0x30, 0x78, 0x7b, 0x30, 0x79, 0x7b, 0x30, 0x7a};
const uint8_t HuffDecoderCommon::table24_65_emit_[204] = {
    0x7b, 0x31, 0x30, 0x7b, 0x31, 0x31, 0x7b, 0x31, 0x32, 0x7b, 0x31, 0x61,
    0x7b, 0x31, 0x63, 0x7b, 0x31, 0x65, 0x7b, 0x31, 0x69, 0x7b, 0x31, 0x6f,
    0x7b, 0x31, 0x73, 0x7b, 0x31, 0x74, 0x7b, 0x31, 0x20, 0x7b, 0x31, 0x25,
    0x7b, 0x31, 0x2d, 0x7b, 0x31, 0x2e, 0x7b, 0x31, 0x2f, 0x7b, 0x31, 0x33,
    0x7b, 0x31, 0x34, 0x7b, 0x31, 0x35, 0x7b, 0x31, 0x36, 0x7b, 0x31, 0x37,
    0x7b, 0x31, 0x38, 0x7b, 0x31, 0x39, 0x7b, 0x31, 0x3d, 0x7b, 0x31, 0x41,
    0x7b, 0x31, 0x5f, 0x7b, 0x31, 0x62, 0x7b, 0x31, 0x64, 0x7b, 0x31, 0x66,
    0x7b, 0x31, 0x67, 0x7b, 0x31, 0x68, 0x7b, 0x31, 0x6c, 0x7b, 0x31, 0x6d,
    0x7b, 0x31, 0x6e, 0x7b, 0x31, 0x70, 0x7b, 0x31, 0x72, 0x7b, 0x31, 0x75,
    0x7b, 0x31, 0x3a, 0x7b, 0x31, 0x42, 0x7b, 0x31, 0x43, 0x7b, 0x31, 0x44,
    0x7b, 0x31, 0x45, 0x7b, 0x31, 0x46, 0x7b, 0x31, 0x47, 0x7b, 0x31, 0x48,
    0x7b, 0x31, 0x49, 0x7b, 0x31, 0x4a, 0x7b, 0x31, 0x4b, 0x7b, 0x31, 0x4c,
    0x7b, 0x31, 0x4d, 0x7b, 0x31, 0x4e, 0x7b, 0x31, 0x4f, 0x7b, 0x31, 0x50,
    0x7b, 0x31, 0x51, 0x7b, 0x31, 0x52, 0x7b, 0x31, 0x53, 0x7b, 0x31, 0x54,
    0x7b, 0x31, 0x55, 0x7b, 0x31, 0x56, 0x7b, 0x31, 0x57, 0x7b, 0x31, 0x59,
    0x7b, 0x31, 0x6a, 0x7b, 0x31, 0x6b, 0x7b, 0x31, 0x71, 0x7b, 0x31, 0x76,
    0x7b, 0x31, 0x77, 0x7b, 0x31, 0x78, 0x7b, 0x31, 0x79, 0x7b, 0x31, 0x7a};
const uint8_t HuffDecoderCommon::table24_66_emit_[204] = {
    0x7b, 0x32, 0x30, 0x7b, 0x32, 0x31, 0x7b, 0x32, 0x32, 0x7b, 0x32, 0x61,
    0x7b, 0x32, 0x63, 0x7b, 0x32, 0x65, 0x7b, 0x32, 0x69, 0x7b, 0x32, 0x6f,
    0x7b, 0x32, 0x73, 0x7b, 0x32, 0x74, 0x7b, 0x32, 0x20, 0x7b, 0x32, 0x25,
    0x7b, 0x32, 0x2d, 0x7b, 0x32, 0x2e, 0x7b, 0x32, 0x2f, 0x7b, 0x32, 0x33,
    0x7b, 0x32, 0x34, 0x7b, 0x32, 0x35, 0x7b, 0x32, 0x36, 0x7b, 0x32, 0x37,
    0x7b, 0x32, 0x38, 0x7b, 0x32, 0x39, 0x7b, 0x32, 0x3d, 0x7b, 0x32, 0x41,
    0x7b, 0x32, 0x5f, 0x7b, 0x32, 0x62, 0x7b, 0x32, 0x64, 0x7b, 0x32, 0x66,
    0x7b, 0x32, 0x67, 0x7b, 0x32, 0x68, 0x7b, 0x32, 0x6c, 0x7b, 0x32, 0x6d,
    0x7b, 0x32, 0x6e, 0x7b, 0x32, 0x70, 0x7b, 0x32, 0x72, 0x7b, 0x32, 0x75,
    0x7b, 0x32, 0x3a, 0x7b, 0x32, 0x42, 0x7b, 0x32, 0x43, 0x7b, 0x32, 0x44,
    0x7b, 0x32, 0x45, 0x7b, 0x32, 0x46, 0x7b, 0x32, 0x47, 0x7b, 0x32, 0x48,
    0x7b, 0x32, 0x49, 0x7b, 0x32, 0x4a, 0x7b, 0x32, 0x4b, 0x7b, 0x32, 0x4c,
    0x7b, 0x32, 0x4d, 0x7b, 0x32, 0x4e, 0x7b, 0x32, 0x4f, 0x7b, 0x32, 0x50,
    0x7b, 0x32, 0x51, 0x7b, 0x32, 0x52, 0x7b, 0x32, 0x53, 0x7b, 0x32, 0x54,
    0x7b, 0x32, 0x55, 0x7b, 0x32, 0x56, 0x7b, 0x32, 0x57, 0x7b, 0x32, 0x59,
    0x7b, 0x32, 0x6a, 0x7b, 0x32, 0x6b, 0x7b, 0x32, 0x71, 0x7b, 0x32, 0x76,
    0x7b, 0x32, 0x77, 0x7b, 0x32, 0x78, 0x7b, 0x32, 0x79, 0x7b, 0x32, 0x7a};
const uint8_t HuffDecoderCommon::table24_67_emit_[204] = {
    0x7b, 0x61, 0x30, 0x7b, 0x61, 0x31, 0x7b, 0x61, 0x32, 0x7b, 0x61, 0x61,
    0x7b, 0x61, 0x63, 0x7b, 0x61, 0x65, 0x7b, 0x61, 0x69, 0x7b, 0x61, 0x6f,
    0x7b, 0x61, 0x73, 0x7b, 0x61, 0x74, 0x7b, 0x61, 0x20, 0x7b, 0x61, 0x25,
    0x7b, 0x61, 0x2d, 0x7b, 0x61, 0x2e, 0x7b, 0x61, 0x2f, 0x7b, 0x61, 0x33,
    0x7b, 0x61, 0x34, 0x7b, 0x61, 0x35, 0x7b, 0x61, 0x36, 0x7b, 0x61, 0x37,
    0x7b, 0x61, 0x38, 0x7b, 0x61, 0x39, 0x7b, 0x61, 0x3d, 0x7b, 0x61, 0x41,
    0x7b, 0x61, 0x5f, 0x7b, 0x61, 0x62, 0x7b, 0x61, 0x64, 0x7b, 0x61, 0x66,
    0x7b, 0x61, 0x67, 0x7b, 0x61, 0x68, 0x7b, 0x61, 0x6c, 0x7b, 0x61, 0x6d,
    0x7b, 0x61, 0x6e, 0x7b, 0x61, 0x70, 0x7b, 0x61, 0x72, 0x7b, 0x61, 0x75,
    0x7b, 0x61, 0x3a, 0x7b, 0x61, 0x42, 0x7b, 0x61, 0x43, 0x7b, 0x61, 0x44,
    0x7b, 0x61, 0x45, 0x7b, 0x61, 0x46, 0x7b, 0x61, 0x47, 0x7b, 0x61, 0x48,
    0x7b, 0x61, 0x49, 0x7b, 0x61, 0x4a, 0x7b, 0x61, 0x4b, 0x7b, 0x61, 0x4c,
    0x7b, 0x61, 0x4d, 0x7b, 0x61, 0x4e, 0x7b, 0x61, 0x4f, 0x7b, 0x61, 0x50,
    0x7b, 0x61, 0x51, 0x7b, 0x61, 0x52, 0x7b, 0x61, 0x53, 0x7b, 0x61, 0x54,
    0x7b, 0x61, 0x55, 0x7b, 0x61, 0x56, 0x7b, 0x61, 0x57, 0x7b, 0x61, 0x59,
    0x7b, 0x61, 0x6a, 0x7b, 0x61, 0x6b, 0x7b, 0x61, 0x71, 0x7b, 0x61, 0x76,
    0x7b, 0x61, 0x77, 0x7b, 0x61, 0x78, 0x7b, 0x61, 0x79, 0x7b, 0x61, 0x7a};
const uint8_t HuffDecoderCommon::table24_68_emit_[204] = {
    0x7b, 0x63, 0x30, 0x7b, 0x63, 0x31, 0x7b, 0x63, 0x32, 0x7b, 0x63, 0x61,
    0x7b, 0x63, 0x63, 0x7b, 0x63, 0x65, 0x7b, 0x63, 0x69, 0x7b, 0x63, 0x6f,
    0x7b, 0x63, 0x73, 0x7b, 0x63, 0x74, 0x7b, 0x63, 0x20, 0x7b, 0x63, 0x25,
    0x7b, 0x63, 0x2d, 0x7b, 0x63, 0x2e, 0x7b, 0x63, 0x2f, 0x7b, 0x63, 0x33,
    0x7b, 0x63, 0x34, 0x7b, 0x63, 0x35, 0x7b, 0x63, 0x36, 0x7b, 0x63, 0x37,
    0x7b, 0x63, 0x38, 0x7b, 0x63, 0x39, 0x7b, 0x63, 0x3d, 0x7b, 0x63, 0x41,
    0x7b, 0x63, 0x5f, 0x7b, 0x63, 0x62, 0x7b, 0x63, 0x64, 0x7b, 0x63, 0x66,
    0x7b, 0x63, 0x67, 0x7b, 0x63, 0x68, 0x7b, 0x63, 0x6c, 0x7b, 0x63, 0x6d,
    0x7b, 0x63, 0x6e, 0x7b, 0x63, 0x70, 0x7b, 0x63, 0x72, 0x7b, 0x63, 0x75,
    0x7b, 0x63, 0x3a, 0x7b, 0x63, 0x42, 0x7b, 0x63, 0x43, 0x7b, 0x63, 0x44,
    0x7b, 0x63, 0x45, 0x7b, 0x63, 0x46, 0x7b, 0x63, 0x47, 0x7b, 0x63, 0x48,
    0x7b, 0x63, 0x49, 0x7b, 0x63, 0x4a, 0x7b, 0x63, 0x4b, 0x7b, 0x63, 0x4c,
    0x7b, 0x63, 0x4d, 0x7b, 0x63, 0x4e, 0x7b, 0x63, 0x4f, 0x7b, 0x63, 0x50,
    0x7b, 0x63, 0x51, 0x7b, 0x63, 0x52, 0x7b, 0x63, 0x53, 0x7b, 0x63, 0x54,
    0x7b, 0x63, 0x55, 0x7b, 0x63, 0x56, 0x7b, 0x63, 0x57, 0x7b, 0x63, 0x59,
    0x7b, 0x63, 0x6a, 0x7b, 0x63, 0x6b, 0x7b, 0x63, 0x71, 0x7b, 0x63, 0x76,
    0x7b, 0x63, 0x77, 0x7b, 0x63, 0x78, 0x7b, 0x63, 0x79, 0x7b, 0x63, 0x7a};
const uint8_t HuffDecoderCommon::table24_69_emit_[204] = {
    0x7b, 0x65, 0x30, 0x7b, 0x65, 0x31, 0x7b, 0x65, 0x32, 0x7b, 0x65, 0x61,
    0x7b, 0x65, 0x63, 0x7b, 0x65, 0x65, 0x7b, 0x65, 0x69, 0x7b, 0x65, 0x6f,
    0x7b, 0x65, 0x73, 0x7b, 0x65, 0x74, 0x7b, 0x65, 0x20, 0x7b, 0x65, 0x25,
    0x7b, 0x65, 0x2d, 0x7b, 0x65, 0x2e, 0x7b, 0x65, 0x2f, 0x7b, 0x65, 0x33,
    0x7b, 0x65, 0x34, 0x7b, 0x65, 0x35, 0x7b, 0x65, 0x36, 0x7b, 0x65, 0x37,
    0x7b, 0x65, 0x38, 0x7b, 0x65, 0x39, 0x7b, 0x65, 0x3d, 0x7b, 0x65, 0x41,
    0x7b, 0x65, 0x5f, 0x7b, 0x65, 0x62, 0x7b, 0x65, 0x64, 0x7b, 0x65, 0x66,
    0x7b, 0x65, 0x67, 0x7b, 0x65, 0x68, 0x7b, 0x65, 0x6c, 0x7b, 0x65, 0x6d,
    0x7b, 0x65, 0x6e, 0x7b, 0x65, 0x70, 0x7b, 0x65, 0x72, 0x7b, 0x65, 0x75,
    0x7b, 0x65, 0x3a, 0x7b, 0x65, 0x42, 0x7b, 0x65, 0x43, 0x7b, 0x65, 0x44,
    0x7b, 0x65, 0x45, 0x7b, 0x65, 0x46, 0x7b, 0x65, 0x47, 0x7b, 0x65, 0x48,
    0x7b, 0x65, 0x49, 0x7b, 0x65, 0x4a, 0x7b, 0x65, 0x4b, 0x7b, 0x65, 0x4c,
    0x7b, 0x65, 0x4d, 0x7b, 0x65, 0x4e, 0x7b, 0x65, 0x4f, 0x7b, 0x65, 0x50,
    0x7b, 0x65, 0x51, 0x7b, 0x65, 0x52, 0x7b, 0x65, 0x53, 0x7b, 0x65, 0x54,
    0x7b, 0x65, 0x55, 0x7b, 0x65, 0x56, 0x7b, 0x65, 0x57, 0x7b, 0x65, 0x59,
    0x7b, 0x65, 0x6a, 0x7b, 0x65, 0x6b, 0x7b, 0x65, 0x71, 0x7b, 0x65, 0x76,
    0x7b, 0x65, 0x77, 0x7b, 0x65, 0x78, 0x7b, 0x65, 0x79, 0x7b, 0x65, 0x7a};
const uint8_t HuffDecoderCommon::table24_70_emit_[204] = {
    0x7b, 0x69, 0x30, 0x7b, 0x69, 0x31, 0x7b, 0x69, 0x32, 0x7b, 0x69, 0x61,
    0x7b, 0x69, 0x63, 0x7b, 0x69, 0x65, 0x7b, 0x69, 0x69, 0x7b, 0x69, 0x6f,
    0x7b, 0x69, 0x73, 0x7b, 0x69, 0x74, 0x7b, 0x69, 0x20, 0x7b, 0x69, 0x25,
    0x7b, 0x69, 0x2d, 0x7b, 0x69, 0x2e, 0x7b, 0x69, 0x2f, 0x7b, 0x69, 0x33,
    0x7b, 0x69, 0x34, 0x7b, 0x69, 0x35, 0x7b, 0x69, 0x36, 0x7b, 0x69, 0x37,
    0x7b, 0x69, 0x38, 0x7b, 0x69, 0x39, 0x7b, 0x69, 0x3d, 0x7b, 0x69, 0x41,
    0x7b, 0x69, 0x5f, 0x7b, 0x69, 0x62, 0x7b, 0x69, 0x64, 0x7b, 0x69, 0x66,
    0x7b, 0x69, 0x67, 0x7b, 0x69, 0x68, 0x7b, 0x69, 0x6c, 0x7b, 0x69, 0x6d,
    0x7b, 0x69, 0x6e, 0x7b, 0x69, 0x70, 0x7b, 0x69, 0x72, 0x7b, 0x69, 0x75,
    0x7b, 0x69, 0x3a, 0x7b, 0x69, 0x42, 0x7b, 0x69, 0x43, 0x7b, 0x69, 0x44,
    0x7b, 0x69, 0x45, 0x7b, 0x69, 0x46, 0x7b, 0x69, 0x47, 0x7b, 0x69, 0x48,
    0x7b, 0x69, 0x49, 0x7b, 0x69, 0x4a, 0x7b, 0x69, 0x4b, 0x7b, 0x69, 0x4c,
    0x7b, 0x69, 0x4d, 0x7b, 0x69, 0x4e, 0x7b, 0x69, 0x4f, 0x7b, 0x69, 0x50,
    0x7b, 0x69, 0x51, 0x7b, 0x69, 0x52, 0x7b, 0x69, 0x53, 0x7b, 0x69, 0x54,
    0x7b, 0x69, 0x55, 0x7b, 0x69, 0x56, 0x7b, 0x69, 0x57, 0x7b, 0x69, 0x59,
    0x7b, 0x69, 0x6a, 0x7b, 0x69, 0x6b, 0x7b, 0x69, 0x71, 0x7b, 0x69, 0x76,
    0x7b, 0x69, 0x77, 0x7b, 0x69, 0x78, 0x7b, 0x69, 0x79, 0x7b, 0x69, 0x7a};
const uint8_t HuffDecoderCommon::table24_71_emit_[204] = {
    0x7b, 0x6f, 0x30, 0x7b, 0x6f, 0x31, 0x7b, 0x6f, 0x32, 0x7b, 0x6f, 0x61,
    0x7b, 0x6f, 0x63, 0x7b, 0x6f, 0x65, 0x7b, 0x6f, 0x69, 0x7b, 0x6f, 0x6f,
    0x7b, 0x6f, 0x73, 0x7b, 0x6f, 0x74, 0x7b, 0x6f, 0x20, 0x7b, 0x6f, 0x25,
    0x7b, 0x6f, 0x2d, 0x7b, 0x6f, 0x2e, 0x7b, 0x6f, 0x2f, 0x7b, 0x6f, 0x33,
    0x7b, 0x6f, 0x34, 0x7b, 0x6f, 0x35, 0x7b, 0x6f, 0x36, 0x7b, 0x6f, 0x37,
    0x7b, 0x6f, 0x38, 0x7b, 0x6f, 0x39, 0x7b, 0x6f, 0x3d, 0x7b, 0x6f, 0x41,
    0x7b, 0x6f, 0x5f, 0x7b, 0x6f, 0x62, 0x7b, 0x6f, 0x64, 0x7b, 0x6f, 0x66,
    0x7b, 0x6f, 0x67, 0x7b, 0x6f, 0x68, 0x7b, 0x6f, 0x6c, 0x7b, 0x6f, 0x6d,
    0x7b, 0x6f, 0x6e, 0x7b, 0x6f, 0x70, 0x7b, 0x6f, 0x72, 0x7b, 0x6f, 0x75,
    0x7b, 0x6f, 0x3a, 0x7b, 0x6f, 0x42, 0x7b, 0x6f, 0x43, 0x7b, 0x6f, 0x44,
    0x7b, 0x6f, 0x45, 0x7b, 0x6f, 0x46, 0x7b, 0x6f, 0x47, 0x7b, 0x6f, 0x48,
    0x7b, 0x6f, 0x49, 0x7b, 0x6f, 0x4a, 0x7b, 0x6f, 0x4b, 0x7b, 0x6f, 0x4c,
    0x7b, 0x6f, 0x4d, 0x7b, 0x6f, 0x4e, 0x7b, 0x6f, 0x4f, 0x7b, 0x6f, 0x50,
    0x7b, 0x6f, 0x51, 0x7b, 0x6f, 0x52, 0x7b, 0x6f, 0x53, 0x7b, 0x6f, 0x54,
    0x7b, 0x6f, 0x55, 0x7b, 0x6f, 0x56, 0x7b, 0x6f, 0x57, 0x7b, 0x6f, 0x59,
    0x7b, 0x6f, 0x6a, 0x7b, 0x6f, 0x6b, 0x7b, 0x6f, 0x71, 0x7b, 0x6f, 0x76,
    0x7b, 0x6f, 0x77, 0x7b, 0x6f, 0x78, 0x7b, 0x6f, 0x79, 0x7b, 0x6f, 0x7a};
const uint8_t HuffDecoderCommon::table24_72_emit_[204] = {
    0x7b, 0x73, 0x30, 0x7b, 0x73, 0x31, 0x7b, 0x73, 0x32, 0x7b, 0x73, 0x61,
    0x7b, 0x73, 0x63, 0x7b, 0x73, 0x65, 0x7b, 0x73, 0x69, 0x7b, 0x73, 0x6f,
    0x7b, 0x73, 0x73, 0x7b, 0x73, 0x74, 0x7b, 0x73, 0x20, 0x7b, 0x73, 0x25,
    0x7b, 0x73, 0x2d, 0x7b, 0x73, 0x2e, 0x7b, 0x73, 0x2f, 0x7b, 0x73, 0x33,
    0x7b, 0x73, 0x34, 0x7b, 0x73, 0x35, 0x7b, 0x73, 0x36, 0x7b, 0x73, 0x37,
    0x7b, 0x73, 0x38, 0x7b, 0x73, 0x39, 0x7b, 0x73, 0x3d, 0x7b, 0x73, 0x41,
    0x7b, 0x73, 0x5f, 0x7b, 0x73, 0x62, 0x7b, 0x73, 0x64, 0x7b, 0x73, 0x66,
    0x7b, 0x73, 0x67, 0x7b, 0x73, 0x68, 0x7b, 0x73, 0x6c, 0x7b, 0x73, 0x6d,
    0x7b, 0x73, 0x6e, 0x7b, 0x73, 0x70, 0x7b, 0x73, 0x72, 0x7b, 0x73, 0x75,
    0x7b, 0x73, 0x3a, 0x7b, 0x73, 0x42, 0x7b, 0x73, 0x43, 0x7b, 0x73, 0x44,
    0x7b, 0x73, 0x45, 0x7b, 0x73, 0x46, 0x7b, 0x73, 0x47, 0x7b, 0x73, 0x48,
    0x7b, 0x73, 0x49, 0x7b, 0x73, 0x4a, 0x7b, 0x73, 0x4b, 0x7b, 0x73, 0x4c,
    0x7b, 0x73, 0x4d, 0x7b, 0x73, 0x4e, 0x7b, 0x73, 0x4f, 0x7b, 0x73, 0x50,
    0x7b, 0x73, 0x51, 0x7b, 0x73, 0x52, 0x7b, 0x73, 0x53, 0x7b, 0x73, 0x54,
    0x7b, 0x73, 0x55, 0x7b, 0x73, 0x56, 0x7b, 0x73, 0x57, 0x7b, 0x73, 0x59,
    0x7b, 0x73, 0x6a, 0x7b, 0x73, 0x6b, 0x7b, 0x73, 0x71, 0x7b, 0x73, 0x76,
    0x7b, 0x73, 0x77, 0x7b, 0x73, 0x78, 0x7b, 0x73, 0x79, 0x7b, 0x73, 0x7a};
const uint8_t HuffDecoderCommon::table24_73_emit_[204] = {
    0x7b, 0x74, 0x30, 0x7b, 0x74, 0x31, 0x7b, 0x74, 0x32, 0x7b, 0x74, 0x61,
    0x7b, 0x74, 0x63, 0x7b, 0x74, 0x65, 0x7b, 0x74, 0x69, 0x7b, 0x74, 0x6f,
    0x7b, 0x74, 0x73, 0x7b, 0x74, 0x74, 0x7b, 0x74, 0x20, 0x7b, 0x74, 0x25,
    0x7b, 0x74, 0x2d, 0x7b, 0x74, 0x2e, 0x7b, 0x74, 0x2f, 0x7b, 0x74, 0x33,
    0x7b, 0x74, 0x34, 0x7b, 0x74, 0x35, 0x7b, 0x74, 0x36, 0x7b, 0x74, 0x37,
    0x7b, 0x74, 0x38, 0x7b, 0x74, 0x39, 0x7b, 0x74, 0x3d, 0x7b, 0x74, 0x41,
    0x7b, 0x74, 0x5f, 0x7b, 0x74, 0x62, 0x7b, 0x74, 0x64, 0x7b, 0x74, 0x66,
    0x7b, 0x74, 0x67, 0x7b, 0x74, 0x68, 0x7b, 0x74, 0x6c, 0x7b, 0x74, 0x6d,
    0x7b, 0x74, 0x6e, 0x7b, 0x74, 0x70, 0x7b, 0x74, 0x72, 0x7b, 0x74, 0x75,
    0x7b, 0x74, 0x3a, 0x7b, 0x74, 0x42, 0x7b, 0x74, 0x43, 0x7b, 0x74, 0x44,
    0x7b, 0x74, 0x45, 0x7b, 0x74, 0x46, 0x7b, 0x74, 0x47, 0x7b, 0x74, 0x48,
    0x7b, 0x74, 0x49, 0x7b, 0x74, 0x4a, 0x7b, 0x74, 0x4b, 0x7b, 0x74, 0x4c,
    0x7b, 0x74, 0x4d, 0x7b, 0x74, 0x4e, 0x7b, 0x74, 0x4f, 0x7b, 0x74, 0x50,
    0x7b, 0x74, 0x51, 0x7b, 0x74, 0x52, 0x7b, 0x74, 0x53, 0x7b, 0x74, 0x54,
    0x7b, 0x74, 0x55, 0x7b, 0x74, 0x56, 0x7b, 0x74, 0x57, 0x7b, 0x74, 0x59,
    0x7b, 0x74, 0x6a, 0x7b, 0x74, 0x6b, 0x7b, 0x74, 0x71, 0x7b, 0x74, 0x76,
    0x7b, 0x74, 0x77, 0x7b, 0x74, 0x78, 0x7b, 0x74, 0x79, 0x7b, 0x74, 0x7a};
const uint8_t HuffDecoderCommon::table24_74_emit_[216] = {
    0x7b, 0x20, 0x30, 0x7b, 0x20, 0x31, 0x7b, 0x20, 0x32, 0x7b, 0x20, 0x61,
    0x7b, 0x20, 0x63, 0x7b, 0x20, 0x65, 0x7b, 0x20, 0x69, 0x7b, 0x20, 0x6f,
    0x7b, 0x20, 0x73, 0x7b, 0x20, 0x74, 0x7b, 0x20, 0x20, 0x7b, 0x20, 0x25,
    0x7b, 0x20, 0x2d, 0x7b, 0x20, 0x2e, 0x7b, 0x20, 0x2f, 0x7b, 0x20, 0x33,
    0x7b, 0x20, 0x34, 0x7b, 0x20, 0x35, 0x7b, 0x20, 0x36, 0x7b, 0x20, 0x37,
    0x7b, 0x20, 0x38, 0x7b, 0x20, 0x39, 0x7b, 0x20, 0x3d, 0x7b, 0x20, 0x41,
    0x7b, 0x20, 0x5f, 0x7b, 0x20, 0x62, 0x7b, 0x20, 0x64, 0x7b, 0x20, 0x66,
    0x7b, 0x20, 0x67, 0x7b, 0x20, 0x68, 0x7b, 0x20, 0x6c, 0x7b, 0x20, 0x6d,
    0x7b, 0x20, 0x6e, 0x7b, 0x20, 0x70, 0x7b, 0x20, 0x72, 0x7b, 0x20, 0x75,
    0x7b, 0x25, 0x30, 0x7b, 0x25, 0x31, 0x7b, 0x25, 0x32, 0x7b, 0x25, 0x61,
    0x7b, 0x25, 0x63, 0x7b, 0x25, 0x65, 0x7b, 0x25, 0x69, 0x7b, 0x25, 0x6f,
    0x7b, 0x25, 0x73, 0x7b, 0x25, 0x74, 0x7b, 0x25, 0x20, 0x7b, 0x25, 0x25,
    0x7b, 0x25, 0x2d, 0x7b, 0x25, 0x2e, 0x7b, 0x25, 0x2f, 0x7b, 0x25, 0x33,
    0x7b, 0x25, 0x34, 0x7b, 0x25, 0x35, 0x7b, 0x25, 0x36, 0x7b, 0x25, 0x37,
    0x7b, 0x25, 0x38, 0x7b, 0x25, 0x39, 0x7b, 0x25, 0x3d, 0x7b, 0x25, 0x41,
    0x7b, 0x25, 0x5f, 0x7b, 0x25, 0x62, 0x7b, 0x25, 0x64, 0x7b, 0x25, 0x66,
    0x7b, 0x25, 0x67, 0x7b, 0x25, 0x68, 0x7b, 0x25, 0x6c, 0x7b, 0x25, 0x6d,
    0x7b, 0x25, 0x6e, 0x7b, 0x25, 0x70, 0x7b, 0x25, 0x72, 0x7b, 0x25, 0x75};
const uint8_t HuffDecoderCommon::table24_75_emit_[216] = {
    0x7b, 0x2d, 0x30, 0x7b, 0x2d, 0x31, 0x7b, 0x2d, 0x32, 0x7b, 0x2d, 0x61,
    0x7b, 0x2d, 0x63, 0x7b, 0x2d, 0x65, 0x7b, 0x2d, 0x69, 0x7b, 0x2d, 0x6f,
    0x7b, 0x2d, 0x73, 0x7b, 0x2d, 0x74, 0x7b, 0x2d, 0x20, 0x7b, 0x2d, 0x25,
    0x7b, 0x2d, 0x2d, 0x7b, 0x2d, 0x2e, 0x7b, 0x2d, 0x2f, 0x7b, 0x2d, 0x33,
    0x7b, 0x2d, 0x34, 0x7b, 0x2d, 0x35, 0x7b, 0x2d, 0x36, 0x7b, 0x2d, 0x37,
    0x7b, 0x2d, 0x38, 0x7b, 0x2d, 0x39, 0x7b, 0x2d, 0x3d, 0x7b, 0x2d, 0x41,
    0x7b, 0x2d, 0x5f, 0x7b, 0x2d, 0x62, 0x7b, 0x2d, 0x64, 0x7b, 0x2d, 0x66,
    0x7b, 0x2d, 0x67, 0x7b, 0x2d, 0x68, 0x7b, 0x2d, 0x6c, 0x7b, 0x2d, 0x6d,
    0x7b, 0x2d, 0x6e, 0x7b, 0x2d, 0x70, 0x7b, 0x2d, 0x72, 0x7b, 0x2d, 0x75,
    0x7b, 0x2e, 0x30, 0x7b, 0x2e, 0x31, 0x7b, 0x2e, 0x32, 0x7b, 0x2e, 0x61,
    0x7b, 0x2e, 0x63, 0x7b, 0x2e, 0x65, 0x7b, 0x2e, 0x69, 0x7b, 0x2e, 0x6f,
    0x7b, 0x2e, 0x73, 0x7b, 0x2e, 0x74, 0x7b, 0x2e, 0x20, 0x7b, 0x2e, 0x25,
    0x7b, 0x2e, 0x2d, 0x7b, 0x2e, 0x2e, 0x7b, 0x2e, 0x2f, 0x7b, 0x2e, 0x33,
    0x7b, 0x2e, 0x34, 0x7b, 0x2e, 0x35, 0x7b, 0x2e, 0x36, 0x7b, 0x2e, 0x37,
    0x7b, 0x2e, 0x38, 0x7b, 0x2e, 0x39, 0x7b, 0x2e, 0x3d, 0x7b, 0x2e, 0x41,
    0x7b, 0x2e, 0x5f, 0x7b, 0x2e, 0x62, 0x7b, 0x2e, 0x64, 0x7b, 0x2e, 0x66,
    0x7b, 0x2e, 0x67, 0x7b, 0x2e, 0x68, 0x7b, 0x2e, 0x6c, 0x7b, 0x2e, 0x6d,
    0x7b, 0x2e, 0x6e, 0x7b, 0x2e, 0x70, 0x7b, 0x2e, 0x72, 0x7b, 0x2e, 0x75};
const uint8_t HuffDecoderCommon::table24_76_emit_[216] = {
    0x7b, 0x2f, 0x30, 0x7b, 0x2f, 0x31, 0x7b, 0x2f, 0x32, 0x7b, 0x2f, 0x61,
    0x7b, 0x2f, 0x63, 0x7b, 0x2f, 0x65, 0x7b, 0x2f, 0x69, 0x7b, 0x2f, 0x6f,
    0x7b, 0x2f, 0x73, 0x7b, 0x2f, 0x74, 0x7b, 0x2f, 0x20, 0x7b, 0x2f, 0x25,
    0x7b, 0x2f, 0x2d, 0x7b, 0x2f, 0x2e, 0x7b, 0x2f, 0x2f, 0x7b, 0x2f, 0x33,
    0x7b, 0x2f, 0x34, 0x7b, 0x2f, 0x35, 0x7b, 0x2f, 0x36, 0x7b, 0x2f, 0x37,
    0x7b, 0x2f, 0x38, 0x7b, 0x2f, 0x39, 0x7b, 0x2f, 0x3d, 0x7b, 0x2f, 0x41,
    0x7b, 0x2f, 0x5f, 0x7b, 0x2f, 0x62, 0x7b, 0x2f, 0x64, 0x7b, 0x2f, 0x66,
    0x7b, 0x2f, 0x67, 0x7b, 0x2f, 0x68, 0x7b, 0x2f, 0x6c, 0x7b, 0x2f, 0x6d,
    0x7b, 0x2f, 0x6e, 0x7b, 0x2f, 0x70, 0x7b, 0x2f, 0x72, 0x7b, 0x2f, 0x75,
    0x7b, 0x33, 0x30, 0x7b, 0x33, 0x31, 0x7b, 0x33, 0x32, 0x7b, 0x33, 0x61,
    0x7b, 0x33, 0x63, 0x7b, 0x33, 0x65, 0x7b, 0x33, 0x69, 0x7b, 0x33, 0x6f,
    0x7b, 0x33, 0x73, 0x7b, 0x33, 0x74, 0x7b, 0x33, 0x20, 0x7b, 0x33, 0x25,
    0x7b, 0x33, 0x2d, 0x7b, 0x33, 0x2e, 0x7b, 0x33, 0x2f, 0x7b, 0x33, 0x33,
    0x7b, 0x33, 0x34, 0x7b, 0x33, 0x35, 0x7b, 0x33, 0x36, 0x7b, 0x33, 0x37,
    0x7b, 0x33, 0x38, 0x7b, 0x33, 0x39, 0x7b, 0x33, 0x3d, 0x7b, 0x33, 0x41,
    0x7b, 0x33, 0x5f, 0x7b, 0x33, 0x62, 0x7b, 0x33, 0x64, 0x7b, 0x33, 0x66,
    0x7b, 0x33, 0x67, 0x7b, 0x33, 0x68, 0x7b, 0x33, 0x6c, 0x7b, 0x33, 0x6d,
    0x7b, 0x33, 0x6e, 0x7b, 0x33, 0x70, 0x7b, 0x33, 0x72, 0x7b, 0x33, 0x75};
const uint8_t HuffDecoderCommon::table24_77_emit_[216] = {
    0x7b, 0x34, 0x30, 0x7b, 0x34, 0x31, 0x7b, 0x34, 0x32, 0x7b, 0x34, 0x61,
    0x7b, 0x34, 0x63, 0x7b, 0x34, 0x65, 0x7b, 0x34, 0x69, 0x7b, 0x34, 0x6f,
    0x7b, 0x34, 0x73, 0x7b, 0x34, 0x74, 0x7b, 0x34, 0x20, 0x7b, 0x34, 0x25,
    0x7b, 0x34, 0x2d, 0x7b, 0x34, 0x2e, 0x7b, 0x34, 0x2f, 0x7b, 0x34, 0x33,
    0x7b, 0x34, 0x34, 0x7b, 0x34, 0x35, 0x7b, 0x34, 0x36, 0x7b, 0x34, 0x37,
    0x7b, 0x34, 0x38, 0x7b, 0x34, 0x39, 0x7b, 0x34, 0x3d, 0x7b, 0x34, 0x41,
    0x7b, 0x34, 0x5f, 0x7b, 0x34, 0x62, 0x7b, 0x34, 0x64, 0x7b, 0x34, 0x66,
    0x7b, 0x34, 0x67, 0x7b, 0x34, 0x68, 0x7b, 0x34, 0x6c, 0x7b, 0x34, 0x6d,
    0x7b, 0x34, 0x6e, 0x7b, 0x34, 0x70, 0x7b, 0x34, 0x72, 0x7b, 0x34, 0x75,
    0x7b, 0x35, 0x30, 0x7b, 0x35, 0x31, 0x7b, 0x35, 0x32, 0x7b, 0x35, 0x61,
    0x7b, 0x35, 0x63, 0x7b, 0x35, 0x65, 0x7b, 0x35, 0x69, 0x7b, 0x35, 0x6f,
    0x7b, 0x35, 0x73, 0x7b, 0x35, 0x74, 0x7b, 0x35, 0x20, 0x7b, 0x35, 0x25,
    0x7b, 0x35, 0x2d, 0x7b, 0x35, 0x2e, 0x7b, 0x35, 0x2f, 0x7b, 0x35, 0x33,
    0x7b, 0x35, 0x34, 0x7b, 0x35, 0x35, 0x7b, 0x35, 0x36, 0x7b, 0x35, 0x37,
    0x7b, 0x35, 0x38, 0x7b, 0x35, 0x39, 0x7b, 0x35, 0x3d, 0x7b, 0x35, 0x41,
    0x7b, 0x35, 0x5f, 0x7b, 0x35, 0x62, 0x7b, 0x35, 0x64, 0x7b, 0x35, 0x66,
    0x7b, 0x35, 0x67, 0x7b, 0x35, 0x68, 0x7b, 0x35, 0x6c, 0x7b, 0x35, 0x6d,
    0x7b, 0x35, 0x6e, 0x7b, 0x35, 0x70, 0x7b, 0x35, 0x72, 0x7b, 0x35, 0x75};
const uint8_t HuffDecoderCommon::table24_78_emit_[216] = {
    0x7b, 0x36, 0x30, 0x7b, 0x36, 0x31, 0x7b, 0x36, 0x32, 0x7b, 0x36, 0x61,
    0x7b, 0x36, 0x63, 0x7b, 0x36, 0x65, 0x7b, 0x36, 0x69, 0x7b, 0x36, 0x6f,
    0x7b, 0x36, 0x73, 0x7b, 0x36, 0x74, 0x7b, 0x36, 0x20, 0x7b, 0x36, 0x25,
    0x7b, 0x36, 0x2d, 0x7b, 0x36, 0x2e, 0x7b, 0x36, 0x2f, 0x7b, 0x36, 0x33,
    0x7b, 0x36, 0x34, 0x7b, 0x36, 0x35, 0x7b, 0x36, 0x36, 0x7b, 0x36, 0x37,
    0x7b, 0x36, 0x38, 0x7b, 0x36, 0x39, 0x7b, 0x36, 0x3d, 0x7b, 0x36, 0x41,
    0x7b, 0x36, 0x5f, 0x7b, 0x36, 0x62, 0x7b, 0x36, 0x64, 0x7b, 0x36, 0x66,
    0x7b, 0x36, 0x67, 0x7b, 0x36, 0x68, 0x7b, 0x36, 0x6c, 0x7b, 0x36, 0x6d,
    0x7b, 0x36, 0x6e, 0x7b, 0x36, 0x70, 0x7b, 0x36, 0x72, 0x7b, 0x36, 0x75,
    0x7b, 0x37, 0x30, 0x7b, 0x37, 0x31, 0x7b, 0x37, 0x32, 0x7b, 0x37, 0x61,
    0x7b, 0x37, 0x63, 0x7b, 0x37, 0x65, 0x7b, 0x37, 0x69, 0x7b, 0x37, 0x6f,
    0x7b, 0x37, 0x73, 0x7b, 0x37, 0x74, 0x7b, 0x37, 0x20, 0x7b, 0x37, 0x25,
    0x7b, 0x37, 0x2d, 0x7b, 0x37, 0x2e, 0x7b, 0x37, 0x2f, 0x7b, 0x37, 0x33,
    0x7b, 0x37, 0x34, 0x7b, 0x37, 0x35, 0x7b, 0x37, 0x36, 0x7b, 0x37, 0x37,
    0x7b, 0x37, 0x38, 0x7b, 0x37, 0x39, 0x7b, 0x37, 0x3d, 0x7b, 0x37, 0x41,
    0x7b, 0x37, 0x5f, 0x7b, 0x37, 0x62, 0x7b, 0x37, 0x64, 0x7b, 0x37, 0x66,
    0x7b, 0x37, 0x67, 0x7b, 0x37, 0x68, 0x7b, 0x37, 0x6c, 0x7b, 0x37, 0x6d,
    0x7b, 0x37, 0x6e, 0x7b, 0x37, 0x70, 0x7b, 0x37, 0x72, 0x7b, 0x37, 0x75};
const uint8_t HuffDecoderCommon::table24_79_emit_[216] = {
    0x7b, 0x38, 0x30, 0x7b, 0x38, 0x31, 0x7b, 0x38, 0x32, 0x7b, 0x38, 0x61,
    0x7b, 0x38, 0x63, 0x7b, 0x38, 0x65, 0x7b, 0x38, 0x69, 0x7b, 0x38, 0x6f,
    0x7b, 0x38, 0x73, 0x7b, 0x38, 0x74, 0x7b, 0x38, 0x20, 0x7b, 0x38, 0x25,
    0x7b, 0x38, 0x2d, 0x7b, 0x38, 0x2e, 0x7b, 0x38, 0x2f, 0x7b, 0x38, 0x33,
    0x7b, 0x38, 0x34, 0x7b, 0x38, 0x35, 0x7b, 0x38, 0x36, 0x7b, 0x38, 0x37,
    0x7b, 0x38, 0x38, 0x7b, 0x38, 0x39, 0x7b, 0x38, 0x3d, 0x7b, 0x38, 0x41,
    0x7b, 0x38, 0x5f, 0x7b, 0x38, 0x62, 0x7b, 0x38, 0x64, 0x7b, 0x38, 0x66,
    0x7b, 0x38, 0x67, 0x7b, 0x38, 0x68, 0x7b, 0x38, 0x6c, 0x7b, 0x38, 0x6d,
    0x7b, 0x38, 0x6e, 0x7b, 0x38, 0x70, 0x7b, 0x38, 0x72, 0x7b, 0x38, 0x75,
    0x7b, 0x39, 0x30, 0x7b, 0x39, 0x31, 0x7b, 0x39, 0x32, 0x7b, 0x39, 0x61,
    0x7b, 0x39, 0x63, 0x7b, 0x39, 0x65, 0x7b, 0x39, 0x69, 0x7b, 0x39, 0x6f,
    0x7b, 0x39, 0x73, 0x7b, 0x39, 0x74, 0x7b, 0x39, 0x20, 0x7b, 0x39, 0x25,
    0x7b, 0x39, 0x2d, 0x7b, 0x39, 0x2e, 0x7b, 0x39, 0x2f, 0x7b, 0x39, 0x33,
    0x7b, 0x39, 0x34, 0x7b, 0x39, 0x35, 0x7b, 0x39, 0x36, 0x7b, 0x39, 0x37,
    0x7b, 0x39, 0x38, 0x7b, 0x39, 0x39, 0x7b, 0x39, 0x3d, 0x7b, 0x39, 0x41,
    0x7b, 0x39, 0x5f, 0x7b, 0x39, 0x62, 0x7b, 0x39, 0x64, 0x7b, 0x39, 0x66,
    0x7b, 0x39, 0x67, 0x7b, 0x39, 0x68, 0x7b, 0x39, 0x6c, 0x7b, 0x39, 0x6d,
    0x7b, 0x39, 0x6e, 0x7b, 0x39, 0x70, 0x7b, 0x39, 0x72, 0x7b, 0x39, 0x75};
const uint8_t HuffDecoderCommon::table24_80_emit_[216] = {
    0x7b, 0x3d, 0x30, 0x7b, 0x3d, 0x31, 0x7b, 0x3d, 0x32, 0x7b, 0x3d, 0x61,
    0x7b, 0x3d, 0x63, 0x7b, 0x3d, 0x65, 0x7b, 0x3d, 0x69, 0x7b, 0x3d, 0x6f,
    0x7b, 0x3d, 0x73, 0x7b, 0x3d, 0x74, 0x7b, 0x3d, 0x20, 0x7b, 0x3d, 0x25,
    0x7b, 0x3d, 0x2d, 0x7b, 0x3d, 0x2e, 0x7b, 0x3d, 0x2f, 0x7b, 0x3d, 0x33,
    0x7b, 0x3d, 0x34, 0x7b, 0x3d, 0x35, 0x7b, 0x3d, 0x36, 0x7b, 0x3d, 0x37,
    0x7b, 0x3d, 0x38, 0x7b, 0x3d, 0x39, 0x7b, 0x3d, 0x3d, 0x7b, 0x3d, 0x41,
    0x7b, 0x3d, 0x5f, 0x7b, 0x3d, 0x62, 0x7b, 0x3d, 0x64, 0x7b, 0x3d, 0x66,
    0x7b, 0x3d, 0x67, 0x7b, 0x3d, 0x68, 0x7b, 0x3d, 0x6c, 0x7b, 0x3d, 0x6d,
    0x7b, 0x3d, 0x6e, 0x7b, 0x3d, 0x70, 0x7b, 0x3d, 0x72, 0x7b, 0x3d, 0x75,
    0x7b, 0x41, 0x30, 0x7b, 0x41, 0x31, 0x7b, 0x41, 0x32, 0x7b, 0x41, 0x61,
    0x7b, 0x41, 0x63, 0x7b, 0x41, 0x65, 0x7b, 0x41, 0x69, 0x7b, 0x41, 0x6f,
    0x7b, 0x41, 0x73, 0x7b, 0x41, 0x74, 0x7b, 0x41, 0x20, 0x7b, 0x41, 0x25,
    0x7b, 0x41, 0x2d, 0x7b, 0x41, 0x2e, 0x7b, 0x41, 0x2f, 0x7b, 0x41, 0x33,
    0x7b, 0x41, 0x34, 0x7b, 0x41, 0x35, 0x7b, 0x41, 0x36, 0x7b, 0x41, 0x37,
    0x7b, 0x41, 0x38, 0x7b, 0x41, 0x39, 0x7b, 0x41, 0x3d, 0x7b, 0x41, 0x41,
    0x7b, 0x41, 0x5f, 0x7b, 0x41, 0x62, 0x7b, 0x41, 0x64, 0x7b, 0x41, 0x66,
    0x7b, 0x41, 0x67, 0x7b, 0x41, 0x68, 0x7b, 0x41, 0x6c, 0x7b, 0x41, 0x6d,
    0x7b, 0x41, 0x6e, 0x7b, 0x41, 0x70, 0x7b, 0x41, 0x72, 0x7b, 0x41, 0x75};
const uint8_t HuffDecoderCommon::table24_81_emit_[216] = {
    0x7b, 0x5f, 0x30, 0x7b, 0x5f, 0x31, 0x7b, 0x5f, 0x32, 0x7b, 0x5f, 0x61,
    0x7b, 0x5f, 0x63, 0x7b, 0x5f, 0x65, 0x7b, 0x5f, 0x69, 0x7b, 0x5f, 0x6f,
    0x7b, 0x5f, 0x73, 0x7b, 0x5f, 0x74, 0x7b, 0x5f, 0x20, 0x7b, 0x5f, 0x25,
    0x7b, 0x5f, 0x2d, 0x7b, 0x5f, 0x2e, 0x7b, 0x5f, 0x2f, 0x7b, 0x5f, 0x33,
    0x7b, 0x5f, 0x34, 0x7b, 0x5f, 0x35, 0x7b, 0x5f, 0x36, 0x7b, 0x5f, 0x37,
    0x7b, 0x5f, 0x38, 0x7b, 0x5f, 0x39, 0x7b, 0x5f, 0x3d, 0x7b, 0x5f, 0x41,
    0x7b, 0x5f, 0x5f, 0x7b, 0x5f, 0x62, 0x7b, 0x5f, 0x64, 0x7b, 0x5f, 0x66,
    0x7b, 0x5f, 0x67, 0x7b, 0x5f, 0x68, 0x7b, 0x5f, 0x6c, 0x7b, 0x5f, 0x6d,
    0x7b, 0x5f, 0x6e, 0x7b, 0x5f, 0x70, 0x7b, 0x5f, 0x72, 0x7b, 0x5f, 0x75,
    0x7b, 0x62, 0x30, 0x7b, 0x62, 0x31, 0x7b, 0x62, 0x32, 0x7b, 0x62, 0x61,
    0x7b, 0x62, 0x63, 0x7b, 0x62, 0x65, 0x7b, 0x62, 0x69, 0x7b, 0x62, 0x6f,
    0x7b, 0x62, 0x73, 0x7b, 0x62, 0x74, 0x7b, 0x62, 0x20, 0x7b, 0x62, 0x25,
    0x7b, 0x62, 0x2d, 0x7b, 0x62, 0x2e, 0x7b, 0x62, 0x2f, 0x7b, 0x62, 0x33,
    0x7b, 0x62, 0x34, 0x7b, 0x62, 0x35, 0x7b, 0x62, 0x36, 0x7b, 0x62, 0x37,
    0x7b, 0x62, 0x38, 0x7b, 0x62, 0x39, 0x7b, 0x62, 0x3d, 0x7b, 0x62, 0x41,
    0x7b, 0x62, 0x5f, 0x7b, 0x62, 0x62, 0x7b, 0x62, 0x64, 0x7b, 0x62, 0x66,
    0x7b, 0x62, 0x67, 0x7b, 0x62, 0x68, 0x7b, 0x62, 0x6c, 0x7b, 0x62, 0x6d,
    0x7b, 0x62, 0x6e, 0x7b, 0x62, 0x70, 0x7b, 0x62, 0x72, 0x7b, 0x62, 0x75};
const uint8_t HuffDecoderCommon::table24_82_emit_[216] = {
    0x7b, 0x64, 0x30, 0x7b, 0x64, 0x31, 0x7b, 0x64, 0x32, 0x7b, 0x64, 0x61,
    0x7b, 0x64, 0x63, 0x7b, 0x64, 0x65, 0x7b, 0x64, 0x69, 0x7b, 0x64, 0x6f,
    0x7b, 0x64, 0x73, 0x7b, 0x64, 0x74, 0x7b, 0x64, 0x20, 0x7b, 0x64, 0x25,
    0x7b, 0x64, 0x2d, 0x7b, 0x64, 0x2e, 0x7b, 0x64, 0x2f, 0x7b, 0x64, 0x33,
    0x7b, 0x64, 0x34, 0x7b, 0x64, 0x35, 0x7b, 0x64, 0x36, 0x7b, 0x64, 0x37,
    0x7b, 0x64, 0x38, 0x7b, 0x64, 0x39, 0x7b, 0x64, 0x3d, 0x7b, 0x64, 0x41,
    0x7b, 0x64, 0x5f, 0x7b, 0x64, 0x62, 0x7b, 0x64, 0x64, 0x7b, 0x64, 0x66,
    0x7b, 0x64, 0x67, 0x7b, 0x64, 0x68, 0x7b, 0x64, 0x6c, 0x7b, 0x64, 0x6d,
    0x7b, 0x64, 0x6e, 0x7b, 0x64, 0x70, 0x7b, 0x64, 0x72, 0x7b, 0x64, 0x75,
    0x7b, 0x66, 0x30, 0x7b, 0x66, 0x31, 0x7b, 0x66, 0x32, 0x7b, 0x66, 0x61,
    0x7b, 0x66, 0x63, 0x7b, 0x66, 0x65, 0x7b, 0x66, 0x69, 0x7b, 0x66, 0x6f,
    0x7b, 0x66, 0x73, 0x7b, 0x66, 0x74, 0x7b, 0x66, 0x20, 0x7b, 0x66, 0x25,
    0x7b, 0x66, 0x2d, 0x7b, 0x66, 0x2e, 0x7b, 0x66, 0x2f, 0x7b, 0x66, 0x33,
    0x7b, 0x66, 0x34, 0x7b, 0x66, 0x35, 0x7b, 0x66, 0x36, 0x7b, 0x66, 0x37,
    0x7b, 0x66, 0x38, 0x7b, 0x66, 0x39, 0x7b, 0x66, 0x3d, 0x7b, 0x66, 0x41,
    0x7b, 0x66, 0x5f, 0x7b, 0x66, 0x62, 0x7b, 0x66, 0x64, 0x7b, 0x66, 0x66,
    0x7b, 0x66, 0x67, 0x7b, 0x66, 0x68, 0x7b, 0x66, 0x6c, 0x7b, 0x66, 0x6d,
    0x7b, 0x66, 0x6e, 0x7b, 0x66, 0x70, 0x7b, 0x66, 0x72, 0x7b, 0x66, 0x75};
const uint8_t HuffDecoderCommon::table24_83_emit_[216] = {
    0x7b, 0x67, 0x30, 0x7b, 0x67, 0x31, 0x7b, 0x67, 0x32, 0x7b, 0x67, 0x61,
    0x7b, 0x67, 0x63, 0x7b, 0x67, 0x65, 0x7b, 0x67, 0x69, 0x7b, 0x67, 0x6f,
    0x7b, 0x67, 0x73, 0x7b, 0x67, 0x74, 0x7b, 0x67, 0x20, 0x7b, 0x67, 0x25,
    0x7b, 0x67, 0x2d, 0x7b, 0x67, 0x2e, 0x7b, 0x67, 0x2f, 0x7b, 0x67, 0x33,
    0x7b, 0x67, 0x34, 0x7b, 0x67, 0x35, 0x7b, 0x67, 0x36, 0x7b, 0x67, 0x37,
    0x7b, 0x67, 0x38, 0x7b, 0x67, 0x39, 0x7b, 0x67, 0x3d, 0x7b, 0x67, 0x41,
    0x7b, 0x67, 0x5f, 0x7b, 0x67, 0x62, 0x7b, 0x67, 0x64, 0x7b, 0x67, 0x66,
    0x7b, 0x67, 0x67, 0x7b, 0x67, 0x68, 0x7b, 0x67, 0x6c, 0x7b, 0x67, 0x6d,
    0x7b, 0x67, 0x6e, 0x7b, 0x67, 0x70, 0x7b, 0x67, 0x72, 0x7b, 0x67, 0x75,
    0x7b, 0x68, 0x30, 0x7b, 0x68, 0x31, 0x7b, 0x68, 0x32, 0x7b, 0x68, 0x61,
    0x7b, 0x68, 0x63, 0x7b, 0x68, 0x65, 0x7b, 0x68, 0x69, 0x7b, 0x68, 0x6f,
    0x7b, 0x68, 0x73, 0x7b, 0x68, 0x74, 0x7b, 0x68, 0x20, 0x7b, 0x68, 0x25,
    0x7b, 0x68, 0x2d, 0x7b, 0x68, 0x2e, 0x7b, 0x68, 0x2f, 0x7b, 0x68, 0x33,
    0x7b, 0x68, 0x34, 0x7b, 0x68, 0x35, 0x7b, 0x68, 0x36, 0x7b, 0x68, 0x37,
    0x7b, 0x68, 0x38, 0x7b, 0x68, 0x39, 0x7b, 0x68, 0x3d, 0x7b, 0x68, 0x41,
    0x7b, 0x68, 0x5f, 0x7b, 0x68, 0x62, 0x7b, 0x68, 0x64, 0x7b, 0x68, 0x66,
    0x7b, 0x68, 0x67, 0x7b, 0x68, 0x68, 0x7b, 0x68, 0x6c, 0x7b, 0x68, 0x6d,
    0x7b, 0x68, 0x6e, 0x7b, 0x68, 0x70, 0x7b, 0x68, 0x72, 0x7b, 0x68, 0x75};
const uint8_t HuffDecoderCommon::table24_84_emit_[216] = {
    0x7b, 0x6c, 0x30, 0x7b, 0x6c, 0x31, 0x7b, 0x6c, 0x32, 0x7b, 0x6c, 0x61,
    0x7b, 0x6c, 0x63, 0x7b, 0x6c, 0x65, 0x7b, 0x6c, 0x69, 0x7b, 0x6c, 0x6f,
    0x7b, 0x6c, 0x73, 0x7b, 0x6c, 0x74, 0x7b, 0x6c, 0x20, 0x7b, 0x6c, 0x25,
    0x7b, 0x6c, 0x2d, 0x7b, 0x6c, 0x2e, 0x7b, 0x6c, 0x2f, 0x7b, 0x6c, 0x33,
    0x7b, 0x6c, 0x34, 0x7b, 0x6c, 0x35, 0x7b, 0x6c, 0x36, 0x7b, 0x6c, 0x37,
    0x7b, 0x6c, 0x38, 0x7b, 0x6c, 0x39, 0x7b, 0x6c, 0x3d, 0x7b, 0x6c, 0x41,
    0x7b, 0x6c, 0x5f, 0x7b, 0x6c, 0x62, 0x7b, 0x6c, 0x64, 0x7b, 0x6c, 0x66,
    0x7b, 0x6c, 0x67, 0x7b, 0x6c, 0x68, 0x7b, 0x6c, 0x6c, 0x7b, 0x6c, 0x6d,
    0x7b, 0x6c, 0x6e, 0x7b, 0x6c, 0x70, 0x7b, 0x6c, 0x72, 0x7b, 0x6c, 0x75,
    0x7b, 0x6d, 0x30, 0x7b, 0x6d, 0x31, 0x7b, 0x6d, 0x32, 0x7b, 0x6d, 0x61,
    0x7b, 0x6d, 0x63, 0x7b, 0x6d, 0x65, 0x7b, 0x6d, 0x69, 0x7b, 0x6d, 0x6f,
    0x7b, 0x6d, 0x73, 0x7b, 0x6d, 0x74, 0x7b, 0x6d, 0x20, 0x7b, 0x6d, 0x25,
    0x7b, 0x6d, 0x2d, 0x7b, 0x6d, 0x2e, 0x7b, 0x6d, 0x2f, 0x7b, 0x6d, 0x33,
    0x7b, 0x6d, 0x34, 0x7b, 0x6d, 0x35, 0x7b, 0x6d, 0x36, 0x7b, 0x6d, 0x37,
    0x7b, 0x6d, 0x38, 0x7b, 0x6d, 0x39, 0x7b, 0x6d, 0x3d, 0x7b, 0x6d, 0x41,
    0x7b, 0x6d, 0x5f, 0x7b, 0x6d, 0x62, 0x7b, 0x6d, 0x64, 0x7b, 0x6d, 0x66,
    0x7b, 0x6d, 0x67, 0x7b, 0x6d, 0x68, 0x7b, 0x6d, 0x6c, 0x7b, 0x6d, 0x6d,
    0x7b, 0x6d, 0x6e, 0x7b, 0x6d, 0x70, 0x7b, 0x6d, 0x72, 0x7b, 0x6d, 0x75};
const uint8_t HuffDecoderCommon::table24_85_emit_[216] = {
    0x7b, 0x6e, 0x30, 0x7b, 0x6e, 0x31, 0x7b, 0x6e, 0x32, 0x7b, 0x6e, 0x61,
    0x7b, 0x6e, 0x63, 0x7b, 0x6e, 0x65, 0x7b, 0x6e, 0x69, 0x7b, 0x6e, 0x6f,
    0x7b, 0x6e, 0x73, 0x7b, 0x6e, 0x74, 0x7b, 0x6e, 0x20, 0x7b, 0x6e, 0x25,
    0x7b, 0x6e, 0x2d, 0x7b, 0x6e, 0x2e, 0x7b, 0x6e, 0x2f, 0x7b, 0x6e, 0x33,
    0x7b, 0x6e, 0x34, 0x7b, 0x6e, 0x35, 0x7b, 0x6e, 0x36, 0x7b, 0x6e, 0x37,
    0x7b, 0x6e, 0x38, 0x7b, 0x6e, 0x39, 0x7b, 0x6e, 0x3d, 0x7b, 0x6e, 0x41,
    0x7b, 0x6e, 0x5f, 0x7b, 0x6e, 0x62, 0x7b, 0x6e, 0x64, 0x7b, 0x6e, 0x66,
    0x7b, 0x6e, 0x67, 0x7b, 0x6e, 0x68, 0x7b, 0x6e, 0x6c, 0x7b, 0x6e, 0x6d,
    0x7b, 0x6e, 0x6e, 0x7b, 0x6e, 0x70, 0x7b, 0x6e, 0x72, 0x7b, 0x6e, 0x75,
    0x7b, 0x70, 0x30, 0x7b, 0x70, 0x31, 0x7b, 0x70, 0x32, 0x7b, 0x70, 0x61,
    0x7b, 0x70, 0x63, 0x7b, 0x70, 0x65, 0x7b, 0x70, 0x69, 0x7b, 0x70, 0x6f,
    0x7b, 0x70, 0x73, 0x7b, 0x70, 0x74, 0x7b, 0x70, 0x20, 0x7b, 0x70, 0x25,
    0x7b, 0x70, 0x2d, 0x7b, 0x70, 0x2e, 0x7b, 0x70, 0x2f, 0x7b, 0x70, 0x33,
    0x7b, 0x70, 0x34, 0x7b, 0x70, 0x35, 0x7b, 0x70, 0x36, 0x7b, 0x70, 0x37,
    0x7b, 0x70, 0x38, 0x7b, 0x70, 0x39, 0x7b, 0x70, 0x3d, 0x7b, 0x70, 0x41,
    0x7b, 0x70, 0x5f, 0x7b, 0x70, 0x62, 0x7b, 0x70, 0x64, 0x7b, 0x70, 0x66,
    0x7b, 0x70, 0x67, 0x7b, 0x70, 0x68, 0x7b, 0x70, 0x6c, 0x7b, 0x70, 0x6d,
    0x7b, 0x70, 0x6e, 0x7b, 0x70, 0x70, 0x7b, 0x70, 0x72, 0x7b, 0x70, 0x75};
const uint8_t HuffDecoderCommon::table24_86_emit_[216] = {
    0x7b, 0x72, 0x30, 0x7b, 0x72, 0x31, 0x7b, 0x72, 0x32, 0x7b, 0x72, 0x61,
    0x7b, 0x72, 0x63, 0x7b, 0x72, 0x65, 0x7b, 0x72, 0x69, 0x7b, 0x72, 0x6f,
    0x7b, 0x72, 0x73, 0x7b, 0x72, 0x74, 0x7b, 0x72, 0x20, 0x7b, 0x72, 0x25,
    0x7b, 0x72, 0x2d, 0x7b, 0x72, 0x2e, 0x7b, 0x72, 0x2f, 0x7b, 0x72, 0x33,
    0x7b, 0x72, 0x34, 0x7b, 0x72, 0x35, 0x7b, 0x72, 0x36, 0x7b, 0x72, 0x37,
    0x7b, 0x72, 0x38, 0x7b, 0x72, 0x39, 0x7b, 0x72, 0x3d, 0x7b, 0x72, 0x41,
    0x7b, 0x72, 0x5f, 0x7b, 0x72, 0x62, 0x7b, 0x72, 0x64, 0x7b, 0x72, 0x66,
    0x7b, 0x72, 0x67, 0x7b, 0x72, 0x68, 0x7b, 0x72, 0x6c, 0x7b, 0x72, 0x6d,
    0x7b, 0x72, 0x6e, 0x7b, 0x72, 0x70, 0x7b, 0x72, 0x72, 0x7b, 0x72, 0x75,
    0x7b, 0x75, 0x30, 0x7b, 0x75, 0x31, 0x7b, 0x75, 0x32, 0x7b, 0x75, 0x61,
    0x7b, 0x75, 0x63, 0x7b, 0x75, 0x65, 0x7b, 0x75, 0x69, 0x7b, 0x75, 0x6f,
    0x7b, 0x75, 0x73, 0x7b, 0x75, 0x74, 0x7b, 0x75, 0x20, 0x7b, 0x75, 0x25,
    0x7b, 0x75, 0x2d, 0x7b, 0x75, 0x2e, 0x7b, 0x75, 0x2f, 0x7b, 0x75, 0x33,
    0x7b, 0x75, 0x34, 0x7b, 0x75, 0x35, 0x7b, 0x75, 0x36, 0x7b, 0x75, 0x37,
    0x7b, 0x75, 0x38, 0x7b, 0x75, 0x39, 0x7b, 0x75, 0x3d, 0x7b, 0x75, 0x41,
    0x7b, 0x75, 0x5f, 0x7b, 0x75, 0x62, 0x7b, 0x75, 0x64, 0x7b, 0x75, 0x66,
    0x7b, 0x75, 0x67, 0x7b, 0x75, 0x68, 0x7b, 0x75, 0x6c, 0x7b, 0x75, 0x6d,
    0x7b, 0x75, 0x6e, 0x7b, 0x75, 0x70, 0x7b, 0x75, 0x72, 0x7b, 0x75, 0x75};
const uint8_t HuffDecoderCommon::table24_87_emit_[120] = {
    0x7b, 0x3a, 0x30, 0x7b, 0x3a, 0x31, 0x7b, 0x3a, 0x32, 0x7b, 0x3a, 0x61,
    0x7b, 0x3a, 0x63, 0x7b, 0x3a, 0x65, 0x7b, 0x3a, 0x69, 0x7b, 0x3a, 0x6f,
    0x7b, 0x3a, 0x73, 0x7b, 0x3a, 0x74, 0x7b, 0x42, 0x30, 0x7b, 0x42, 0x31,
    0x7b, 0x42, 0x32, 0x7b, 0x42, 0x61, 0x7b, 0x42, 0x63, 0x7b, 0x42, 0x65,
    0x7b, 0x42, 0x69, 0x7b, 0x42, 0x6f, 0x7b, 0x42, 0x73, 0x7b, 0x42, 0x74,
    0x7b, 0x43, 0x30, 0x7b, 0x43, 0x31, 0x7b, 0x43, 0x32, 0x7b, 0x43, 0x61,
    0x7b, 0x43, 0x63, 0x7b, 0x43, 0x65, 0x7b, 0x43, 0x69, 0x7b, 0x43, 0x6f,
    0x7b, 0x43, 0x73, 0x7b, 0x43, 0x74, 0x7b, 0x44, 0x30, 0x7b, 0x44, 0x31,
    0x7b, 0x44, 0x32, 0x7b, 0x44, 0x61, 0x7b, 0x44, 0x63, 0x7b, 0x44, 0x65,
    0x7b, 0x44, 0x69, 0x7b, 0x44, 0x6f, 0x7b, 0x44, 0x73, 0x7b, 0x44, 0x74};
const uint8_t HuffDecoderCommon::table24_88_emit_[120] = {
    0x7b, 0x45, 0x30, 0x7b, 0x45, 0x31, 0x7b, 0x45, 0x32, 0x7b, 0x45, 0x61,
    0x7b, 0x45, 0x63, 0x7b, 0x45, 0x65, 0x7b, 0x45, 0x69, 0x7b, 0x45, 0x6f,
    0x7b, 0x45, 0x73, 0x7b, 0x45, 0x74, 0x7b, 0x46, 0x30, 0x7b, 0x46, 0x31,
    0x7b, 0x46, 0x32, 0x7b, 0x46, 0x61, 0x7b, 0x46, 0x63, 0x7b, 0x46, 0x65,
    0x7b, 0x46, 0x69, 0x7b, 0x46, 0x6f, 0x7b, 0x46, 0x73, 0x7b, 0x46, 0x74,
    0x7b, 0x47, 0x30, 0x7b, 0x47, 0x31, 0x7b, 0x47, 0x32, 0x7b, 0x47, 0x61,
    0x7b, 0x47, 0x63, 0x7b, 0x47, 0x65, 0x7b, 0x47, 0x69, 0x7b, 0x47, 0x6f,
    0x7b, 0x47, 0x73, 0x7b, 0x47, 0x74, 0x7b, 0x48, 0x30, 0x7b, 0x48, 0x31,
    0x7b, 0x48, 0x32, 0x7b, 0x48, 0x61, 0x7b, 0x48, 0x63, 0x7b, 0x48, 0x65,
    0x7b, 0x48, 0x69, 0x7b, 0x48, 0x6f, 0x7b, 0x48, 0x73, 0x7b, 0x48, 0x74};
const uint8_t HuffDecoderCommon::table24_89_emit_[120] = {
    0x7b, 0x49, 0x30, 0x7b, 0x49, 0x31, 0x7b, 0x49, 0x32, 0x7b, 0x49, 0x61,
    0x7b, 0x49, 0x63, 0x7b, 0x49, 0x65, 0x7b, 0x49, 0x69, 0x7b, 0x49, 0x6f,
    0x7b, 0x49, 0x73, 0x7b, 0x49, 0x74, 0x7b, 0x4a, 0x30, 0x7b, 0x4a, 0x31,
    0x7b, 0x4a, 0x32, 0x7b, 0x4a, 0x61, 0x7b, 0x4a, 0x63, 0x7b, 0x4a, 0x65,
    0x7b, 0x4a, 0x69, 0x7b, 0x4a, 0x6f, 0x7b, 0x4a, 0x73, 0x7b, 0x4a, 0x74,
    0x7b, 0x4b, 0x30, 0x7b, 0x4b, 0x31, 0x7b, 0x4b, 0x32, 0x7b, 0x4b, 0x61,
    0x7b, 0x4b, 0x63, 0x7b, 0x4b, 0x65, 0x7b, 0x4b, 0x69, 0x7b, 0x4b, 0x6f,
    0x7b, 0x4b, 0x73, 0x7b, 0x4b, 0x74, 0x7b, 0x4c, 0x30, 0x7b, 0x4c, 0x31,
    0x7b, 0x4c, 0x32, 0x7b, 0x4c, 0x61, 0x7b, 0x4c, 0x63, 0x7b, 0x4c, 0x65,
    0x7b, 0x4c, 0x69, 0x7b, 0x4c, 0x6f, 0x7b, 0x4c, 0x73, 0x7b, 0x4c, 0x74};
const uint8_t HuffDecoderCommon::table24_90_emit_[120] = {
    0x7b, 0x4d, 0x30, 0x7b, 0x4d, 0x31, 0x7b, 0x4d, 0x32, 0x7b, 0x4d, 0x61,
    0x7b, 0x4d, 0x63, 0x7b, 0x4d, 0x65, 0x7b, 0x4d, 0x69, 0x7b, 0x4d, 0x6f,
    0x7b, 0x4d, 0x73, 0x7b, 0x4d, 0x74, 0x7b, 0x4e, 0x30, 0x7b, 0x4e, 0x31,
    0x7b, 0x4e, 0x32, 0x7b, 0x4e, 0x61, 0x7b, 0x4e, 0x63, 0x7b, 0x4e, 0x65,
    0x7b, 0x4e, 0x69, 0x7b, 0x4e, 0x6f, 0x7b, 0x4e, 0x73, 0x7b, 0x4e, 0x74,
    0x7b, 0x4f, 0x30, 0x7b, 0x4f, 0x31, 0x7b, 0x4f, 0x32, 0x7b, 0x4f, 0x61,
    0x7b, 0x4f, 0x63, 0x7b, 0x4f, 0x65, 0x7b, 0x4f, 0x69, 0x7b, 0x4f, 0x6f,
    0x7b, 0x4f, 0x73, 0x7b, 0x4f, 0x74, 0x7b, 0x50, 0x30, 0x7b, 0x50, 0x31,
    0x7b, 0x50, 0x32, 0x7b, 0x50, 0x61, 0x7b, 0x50, 0x63, 0x7b, 0x50, 0x65,
    0x7b, 0x50, 0x69, 0x7b, 0x50, 0x6f, 0x7b, 0x50, 0x73, 0x7b, 0x50, 0x74};
const uint8_t HuffDecoderCommon::table24_91_emit_[120] = {
    0x7b, 0x51, 0x30, 0x7b, 0x51, 0x31, 0x7b, 0x51, 0x32, 0x7b, 0x51, 0x61,
    0x7b, 0x51, 0x63, 0x7b, 0x51, 0x65, 0x7b, 0x51, 0x69, 0x7b, 0x51, 0x6f,
    0x7b, 0x51, 0x73, 0x7b, 0x51, 0x74, 0x7b, 0x52, 0x30, 0x7b, 0x52, 0x31,
    0x7b, 0x52, 0x32, 0x7b, 0x52, 0x61, 0x7b, 0x52, 0x63, 0x7b, 0x52, 0x65,
    0x7b, 0x52, 0x69, 0x7b, 0x52, 0x6f, 0x7b, 0x52, 0x73, 0x7b, 0x52, 0x74,
    0x7b, 0x53, 0x30, 0x7b, 0x53, 0x31, 0x7b, 0x53, 0x32, 0x7b, 0x53, 0x61,
    0x7b, 0x53, 0x63, 0x7b, 0x53, 0x65, 0x7b, 0x53, 0x69, 0x7b, 0x53, 0x6f,
    0x7b, 0x53, 0x73, 0x7b, 0x53, 0x74, 0x7b, 0x54, 0x30, 0x7b, 0x54, 0x31,
    0x7b, 0x54, 0x32, 0x7b, 0x54, 0x61, 0x7b, 0x54, 0x63, 0x7b, 0x54, 0x65,
    0x7b, 0x54, 0x69, 0x7b, 0x54, 0x6f, 0x7b, 0x54, 0x73, 0x7b, 0x54, 0x74};
const uint8_t HuffDecoderCommon::table24_92_emit_[120] = {
    0x7b, 0x55, 0x30, 0x7b, 0x55, 0x31, 0x7b, 0x55, 0x32, 0x7b, 0x55, 0x61,
    0x7b, 0x55, 0x63, 0x7b, 0x55, 0x65, 0x7b, 0x55, 0x69, 0x7b, 0x55, 0x6f,
    0x7b, 0x55, 0x73, 0x7b, 0x55, 0x74, 0x7b, 0x56, 0x30, 0x7b, 0x56, 0x31,
    0x7b, 0x56, 0x32, 0x7b, 0x56, 0x61, 0x7b, 0x56, 0x63, 0x7b, 0x56, 0x65,
    0x7b, 0x56, 0x69, 0x7b, 0x56, 0x6f, 0x7b, 0x56, 0x73, 0x7b, 0x56, 0x74,
    0x7b, 0x57, 0x30, 0x7b, 0x57, 0x31, 0x7b, 0x57, 0x32, 0x7b, 0x57, 0x61,
    0x7b, 0x57, 0x63, 0x7b, 0x57, 0x65, 0x7b, 0x57, 0x69, 0x7b, 0x57, 0x6f,
    0x7b, 0x57, 0x73, 0x7b, 0x57, 0x74, 0x7b, 0x59, 0x30, 0x7b, 0x59, 0x31,
    0x7b, 0x59, 0x32, 0x7b, 0x59, 0x61, 0x7b, 0x59, 0x63, 0x7b, 0x59, 0x65,
    0x7b, 0x59, 0x69, 0x7b, 0x59, 0x6f, 0x7b, 0x59, 0x73, 0x7b, 0x59, 0x74};
const uint8_t HuffDecoderCommon::table24_93_emit_[120] = {
    0x7b, 0x6a, 0x30, 0x7b, 0x6a, 0x31, 0x7b, 0x6a, 0x32, 0x7b, 0x6a, 0x61,
    0x7b, 0x6a, 0x63, 0x7b, 0x6a, 0x65, 0x7b, 0x6a, 0x69, 0x7b, 0x6a, 0x6f,
    0x7b, 0x6a, 0x73, 0x7b, 0x6a, 0x74, 0x7b, 0x6b, 0x30, 0x7b, 0x6b, 0x31,
    0x7b, 0x6b, 0x32, 0x7b, 0x6b, 0x61, 0x7b, 0x6b, 0x63, 0x7b, 0x6b, 0x65,
    0x7b, 0x6b, 0x69, 0x7b, 0x6b, 0x6f, 0x7b, 0x6b, 0x73, 0x7b, 0x6b, 0x74,
    0x7b, 0x71, 0x30, 0x7b, 0x71, 0x31, 0x7b, 0x71, 0x32, 0x7b, 0x71, 0x61,
    0x7b, 0x71, 0x63, 0x7b, 0x71, 0x65, 0x7b, 0x71, 0x69, 0x7b, 0x71, 0x6f,
    0x7b, 0x71, 0x73, 0x7b, 0x71, 0x74, 0x7b, 0x76, 0x30, 0x7b, 0x76, 0x31,
    0x7b, 0x76, 0x32, 0x7b, 0x76, 0x61, 0x7b, 0x76, 0x63, 0x7b, 0x76, 0x65,
    0x7b, 0x76, 0x69, 0x7b, 0x76, 0x6f, 0x7b, 0x76, 0x73, 0x7b, 0x76, 0x74};
const uint8_t HuffDecoderCommon::table24_94_emit_[120] = {
    0x7b, 0x77, 0x30, 0x7b, 0x77, 0x31, 0x7b, 0x77, 0x32, 0x7b, 0x77, 0x61,
    0x7b, 0x77, 0x63, 0x7b, 0x77, 0x65, 0x7b, 0x77, 0x69, 0x7b, 0x77, 0x6f,
    0x7b, 0x77, 0x73, 0x7b, 0x77, 0x74, 0x7b, 0x78, 0x30, 0x7b, 0x78, 0x31,
    0x7b, 0x78, 0x32, 0x7b, 0x78, 0x61, 0x7b, 0x78, 0x63, 0x7b, 0x78, 0x65,
    0x7b, 0x78, 0x69, 0x7b, 0x78, 0x6f, 0x7b, 0x78, 0x73, 0x7b, 0x78, 0x74,
    0x7b, 0x79, 0x30, 0x7b, 0x79, 0x31, 0x7b, 0x79, 0x32, 0x7b, 0x79, 0x61,
    0x7b, 0x79, 0x63, 0x7b, 0x79, 0x65, 0x7b, 0x79, 0x69, 0x7b, 0x79, 0x6f,
    0x7b, 0x79, 0x73, 0x7b, 0x79, 0x74, 0x7b, 0x7a, 0x30, 0x7b, 0x7a, 0x31,
    0x7b, 0x7a, 0x32, 0x7b, 0x7a, 0x61, 0x7b, 0x7a, 0x63, 0x7b, 0x7a, 0x65,
    0x7b, 0x7a, 0x69, 0x7b, 0x7a, 0x6f, 0x7b, 0x7a, 0x73, 0x7b, 0x7a, 0x74};
const uint8_t HuffDecoderCommon::table24_95_emit_[32] = {
    0x7b, 0x26, 0x7b, 0x2a, 0x7b, 0x2c, 0x7b, 0x3b, 0x7b, 0x58, 0x7b,
    0x5a, 0x7b, 0x21, 0x7b, 0x22, 0x7b, 0x28, 0x7b, 0x29, 0x7b, 0x3f,
    0x7b, 0x27, 0x7b, 0x2b, 0x7b, 0x7c, 0x7b, 0x23, 0x7b, 0x3e};
const uint8_t HuffDecoderCommon::table24_96_emit_[44] = {
    0x5c, 0x30, 0x5c, 0x31, 0x5c, 0x32, 0x5c, 0x61, 0x5c, 0x63, 0x5c,
    0x65, 0x5c, 0x69, 0x5c, 0x6f, 0x5c, 0x73, 0x5c, 0x74, 0x5c, 0x20,
    0x5c, 0x25, 0x5c, 0x2d, 0x5c, 0x2e, 0x5c, 0x2f, 0x5c, 0x33, 0x5c,
    0x34, 0x5c, 0x35, 0x5c, 0x36, 0x5c, 0x37, 0x5c, 0x38, 0x5c, 0x39};
const uint16_t HuffDecoderCommon::table24_96_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0092, 0x0000,
    0x0000, 0x0000, 0x00a2, 0x0000, 0x0000, 0x0000, 0x00b2, 0x0000, 0x0000,
    0x0000, 0x00c2, 0x0000, 0x0000, 0x0000, 0x00d2, 0x0000, 0x0000, 0x0000,
    0x00e2, 0x0000, 0x0000, 0x0000, 0x00f2, 0x0000, 0x0000, 0x0000, 0x0102,
    0x0000, 0x0000, 0x0000, 0x0112, 0x0000, 0x0000, 0x0000, 0x0122, 0x0000,
    0x0000, 0x0000, 0x0132, 0x0000, 0x0000, 0x0000, 0x0142, 0x0000, 0x0000,
    0x0000, 0x0152};
const uint8_t HuffDecoderCommon::table24_97_emit_[104] = {
    0x5c, 0x3d, 0x5c, 0x41, 0x5c, 0x5f, 0x5c, 0x62, 0x5c, 0x64, 0x5c, 0x66,
    0x5c, 0x67, 0x5c, 0x68, 0x5c, 0x6c, 0x5c, 0x6d, 0x5c, 0x6e, 0x5c, 0x70,
    0x5c, 0x72, 0x5c, 0x75, 0x5c, 0x3a, 0x5c, 0x42, 0x5c, 0x43, 0x5c, 0x44,
    0x5c, 0x45, 0x5c, 0x46, 0x5c, 0x47, 0x5c, 0x48, 0x5c, 0x49, 0x5c, 0x4a,
    0x5c, 0x4b, 0x5c, 0x4c, 0x5c, 0x4d, 0x5c, 0x4e, 0x5c, 0x4f, 0x5c, 0x50,
    0x5c, 0x51, 0x5c, 0x52, 0x5c, 0x53, 0x5c, 0x54, 0x5c, 0x55, 0x5c, 0x56,
    0x5c, 0x57, 0x5c, 0x59, 0x5c, 0x6a, 0x5c, 0x6b, 0x5c, 0x71, 0x5c, 0x76,
    0x5c, 0x77, 0x5c, 0x78, 0x5c, 0x79, 0x5c, 0x7a, 0x5c, 0x26, 0x5c, 0x2a,
    0x5c, 0x2c, 0x5c, 0x3b, 0x5c, 0x58, 0x5c, 0x5a};
const uint16_t HuffDecoderCommon::table24_97_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000,
    0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0062, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000,
    0x0000, 0x0000, 0x00b2, 0x0000, 0x0000, 0x0000, 0x00c2, 0x0000, 0x0000,
    0x0000, 0x00d2, 0x0000, 0x00e2, 0x0000, 0x00f2, 0x0000, 0x0102, 0x0000,
    0x0112, 0x0000, 0x0122, 0x0000, 0x0132, 0x0000, 0x0142, 0x0000, 0x0152,
    0x0000, 0x0162, 0x0000, 0x0172, 0x0000, 0x0182, 0x0000, 0x0192, 0x0000,
    0x01a2, 0x0000, 0x01b2, 0x0000, 0x01c2, 0x0000, 0x01d2, 0x0000, 0x01e2,
    0x0000, 0x01f2, 0x0000, 0x0202, 0x0000, 0x0212, 0x0000, 0x0222, 0x0000,
    0x0232, 0x0000, 0x0242, 0x0000, 0x0252, 0x0000, 0x0262, 0x0000, 0x0272,
    0x0000, 0x0282, 0x0000, 0x0292, 0x0000, 0x02a2, 0x0000, 0x02b2, 0x0000,
    0x02c2, 0x0000, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table24_98_emit_[44] = {
    0xc3, 0x30, 0xc3, 0x31, 0xc3, 0x32, 0xc3, 0x61, 0xc3, 0x63, 0xc3,
    0x65, 0xc3, 0x69, 0xc3, 0x6f, 0xc3, 0x73, 0xc3, 0x74, 0xc3, 0x20,
    0xc3, 0x25, 0xc3, 0x2d, 0xc3, 0x2e, 0xc3, 0x2f, 0xc3, 0x33, 0xc3,
    0x34, 0xc3, 0x35, 0xc3, 0x36, 0xc3, 0x37, 0xc3, 0x38, 0xc3, 0x39};
const uint8_t HuffDecoderCommon::table24_99_emit_[104] = {
    0xc3, 0x3d, 0xc3, 0x41, 0xc3, 0x5f, 0xc3, 0x62, 0xc3, 0x64, 0xc3, 0x66,
    0xc3, 0x67, 0xc3, 0x68, 0xc3, 0x6c, 0xc3, 0x6d, 0xc3, 0x6e, 0xc3, 0x70,
    0xc3, 0x72, 0xc3, 0x75, 0xc3, 0x3a, 0xc3, 0x42, 0xc3, 0x43, 0xc3, 0x44,
    0xc3, 0x45, 0xc3, 0x46, 0xc3, 0x47, 0xc3, 0x48, 0xc3, 0x49, 0xc3, 0x4a,
    0xc3, 0x4b, 0xc3, 0x4c, 0xc3, 0x4d, 0xc3, 0x4e, 0xc3, 0x4f, 0xc3, 0x50,
    0xc3, 0x51, 0xc3, 0x52, 0xc3, 0x53, 0xc3, 0x54, 0xc3, 0x55, 0xc3, 0x56,
    0xc3, 0x57, 0xc3, 0x59, 0xc3, 0x6a, 0xc3, 0x6b, 0xc3, 0x71, 0xc3, 0x76,
    0xc3, 0x77, 0xc3, 0x78, 0xc3, 0x79, 0xc3, 0x7a, 0xc3, 0x26, 0xc3, 0x2a,
    0xc3, 0x2c, 0xc3, 0x3b, 0xc3, 0x58, 0xc3, 0x5a};
const uint8_t HuffDecoderCommon::table24_100_emit_[44] = {
    0xd0, 0x30, 0xd0, 0x31, 0xd0, 0x32, 0xd0, 0x61, 0xd0, 0x63, 0xd0,
    0x65, 0xd0, 0x69, 0xd0, 0x6f, 0xd0, 0x73, 0xd0, 0x74, 0xd0, 0x20,
    0xd0, 0x25, 0xd0, 0x2d, 0xd0, 0x2e, 0xd0, 0x2f, 0xd0, 0x33, 0xd0,
    0x34, 0xd0, 0x35, 0xd0, 0x36, 0xd0, 0x37, 0xd0, 0x38, 0xd0, 0x39};
const uint8_t HuffDecoderCommon::table24_101_emit_[104] = {
    0xd0, 0x3d, 0xd0, 0x41, 0xd0, 0x5f, 0xd0, 0x62, 0xd0, 0x64, 0xd0, 0x66,
    0xd0, 0x67, 0xd0, 0x68, 0xd0, 0x6c, 0xd0, 0x6d, 0xd0, 0x6e, 0xd0, 0x70,
    0xd0, 0x72, 0xd0, 0x75, 0xd0, 0x3a, 0xd0, 0x42, 0xd0, 0x43, 0xd0, 0x44,
    0xd0, 0x45, 0xd0, 0x46, 0xd0, 0x47, 0xd0, 0x48, 0xd0, 0x49, 0xd0, 0x4a,
    0xd0, 0x4b, 0xd0, 0x4c, 0xd0, 0x4d, 0xd0, 0x4e, 0xd0, 0x4f, 0xd0, 0x50,
    0xd0, 0x51, 0xd0, 0x52, 0xd0, 0x53, 0xd0, 0x54, 0xd0, 0x55, 0xd0, 0x56,
    0xd0, 0x57, 0xd0, 0x59, 0xd0, 0x6a, 0xd0, 0x6b, 0xd0, 0x71, 0xd0, 0x76,
    0xd0, 0x77, 0xd0, 0x78, 0xd0, 0x79, 0xd0, 0x7a, 0xd0, 0x26, 0xd0, 0x2a,
    0xd0, 0x2c, 0xd0, 0x3b, 0xd0, 0x58, 0xd0, 0x5a};
const uint8_t HuffDecoderCommon::table24_102_emit_[136] = {
    0x80, 0x30, 0x80, 0x31, 0x80, 0x32, 0x80, 0x61, 0x80, 0x63, 0x80, 0x65,
    0x80, 0x69, 0x80, 0x6f, 0x80, 0x73, 0x80, 0x74, 0x80, 0x20, 0x80, 0x25,
    0x80, 0x2d, 0x80, 0x2e, 0x80, 0x2f, 0x80, 0x33, 0x80, 0x34, 0x80, 0x35,
    0x80, 0x36, 0x80, 0x37, 0x80, 0x38, 0x80, 0x39, 0x80, 0x3d, 0x80, 0x41,
    0x80, 0x5f, 0x80, 0x62, 0x80, 0x64, 0x80, 0x66, 0x80, 0x67, 0x80, 0x68,
    0x80, 0x6c, 0x80, 0x6d, 0x80, 0x6e, 0x80, 0x70, 0x80, 0x72, 0x80, 0x75,
    0x80, 0x3a, 0x80, 0x42, 0x80, 0x43, 0x80, 0x44, 0x80, 0x45, 0x80, 0x46,
    0x80, 0x47, 0x80, 0x48, 0x80, 0x49, 0x80, 0x4a, 0x80, 0x4b, 0x80, 0x4c,
    0x80, 0x4d, 0x80, 0x4e, 0x80, 0x4f, 0x80, 0x50, 0x80, 0x51, 0x80, 0x52,
    0x80, 0x53, 0x80, 0x54, 0x80, 0x55, 0x80, 0x56, 0x80, 0x57, 0x80, 0x59,
    0x80, 0x6a, 0x80, 0x6b, 0x80, 0x71, 0x80, 0x76, 0x80, 0x77, 0x80, 0x78,
    0x80, 0x79, 0x80, 0x7a};
const uint8_t HuffDecoderCommon::table24_103_emit_[136] = {
    0x82, 0x30, 0x82, 0x31, 0x82, 0x32, 0x82, 0x61, 0x82, 0x63, 0x82, 0x65,
    0x82, 0x69, 0x82, 0x6f, 0x82, 0x73, 0x82, 0x74, 0x82, 0x20, 0x82, 0x25,
    0x82, 0x2d, 0x82, 0x2e, 0x82, 0x2f, 0x82, 0x33, 0x82, 0x34, 0x82, 0x35,
    0x82, 0x36, 0x82, 0x37, 0x82, 0x38, 0x82, 0x39, 0x82, 0x3d, 0x82, 0x41,
    0x82, 0x5f, 0x82, 0x62, 0x82, 0x64, 0x82, 0x66, 0x82, 0x67, 0x82, 0x68,
    0x82, 0x6c, 0x82, 0x6d, 0x82, 0x6e, 0x82, 0x70, 0x82, 0x72, 0x82, 0x75,
    0x82, 0x3a, 0x82, 0x42, 0x82, 0x43, 0x82, 0x44, 0x82, 0x45, 0x82, 0x46,
    0x82, 0x47, 0x82, 0x48, 0x82, 0x49, 0x82, 0x4a, 0x82, 0x4b, 0x82, 0x4c,
    0x82, 0x4d, 0x82, 0x4e, 0x82, 0x4f, 0x82, 0x50, 0x82, 0x51, 0x82, 0x52,
    0x82, 0x53, 0x82, 0x54, 0x82, 0x55, 0x82, 0x56, 0x82, 0x57, 0x82, 0x59,
    0x82, 0x6a, 0x82, 0x6b, 0x82, 0x71, 0x82, 0x76, 0x82, 0x77, 0x82, 0x78,
    0x82, 0x79, 0x82, 0x7a};
const uint8_t HuffDecoderCommon::table24_104_emit_[136] = {
    0x83, 0x30, 0x83, 0x31, 0x83, 0x32, 0x83, 0x61, 0x83, 0x63, 0x83, 0x65,
    0x83, 0x69, 0x83, 0x6f, 0x83, 0x73, 0x83, 0x74, 0x83, 0x20, 0x83, 0x25,
    0x83, 0x2d, 0x83, 0x2e, 0x83, 0x2f, 0x83, 0x33, 0x83, 0x34, 0x83, 0x35,
    0x83, 0x36, 0x83, 0x37, 0x83, 0x38, 0x83, 0x39, 0x83, 0x3d, 0x83, 0x41,
    0x83, 0x5f, 0x83, 0x62, 0x83, 0x64, 0x83, 0x66, 0x83, 0x67, 0x83, 0x68,
    0x83, 0x6c, 0x83, 0x6d, 0x83, 0x6e, 0x83, 0x70, 0x83, 0x72, 0x83, 0x75,
    0x83, 0x3a, 0x83, 0x42, 0x83, 0x43, 0x83, 0x44, 0x83, 0x45, 0x83, 0x46,
    0x83, 0x47, 0x83, 0x48, 0x83, 0x49, 0x83, 0x4a, 0x83, 0x4b, 0x83, 0x4c,
    0x83, 0x4d, 0x83, 0x4e, 0x83, 0x4f, 0x83, 0x50, 0x83, 0x51, 0x83, 0x52,
    0x83, 0x53, 0x83, 0x54, 0x83, 0x55, 0x83, 0x56, 0x83, 0x57, 0x83, 0x59,
    0x83, 0x6a, 0x83, 0x6b, 0x83, 0x71, 0x83, 0x76, 0x83, 0x77, 0x83, 0x78,
    0x83, 0x79, 0x83, 0x7a};
const uint8_t HuffDecoderCommon::table24_105_emit_[136] = {
    0xa2, 0x30, 0xa2, 0x31, 0xa2, 0x32, 0xa2, 0x61, 0xa2, 0x63, 0xa2, 0x65,
    0xa2, 0x69, 0xa2, 0x6f, 0xa2, 0x73, 0xa2, 0x74, 0xa2, 0x20, 0xa2, 0x25,
    0xa2, 0x2d, 0xa2, 0x2e, 0xa2, 0x2f, 0xa2, 0x33, 0xa2, 0x34, 0xa2, 0x35,
    0xa2, 0x36, 0xa2, 0x37, 0xa2, 0x38, 0xa2, 0x39, 0xa2, 0x3d, 0xa2, 0x41,
    0xa2, 0x5f, 0xa2, 0x62, 0xa2, 0x64, 0xa2, 0x66, 0xa2, 0x67, 0xa2, 0x68,
    0xa2, 0x6c, 0xa2, 0x6d, 0xa2, 0x6e, 0xa2, 0x70, 0xa2, 0x72, 0xa2, 0x75,
    0xa2, 0x3a, 0xa2, 0x42, 0xa2, 0x43, 0xa2, 0x44, 0xa2, 0x45, 0xa2, 0x46,
    0xa2, 0x47, 0xa2, 0x48, 0xa2, 0x49, 0xa2, 0x4a, 0xa2, 0x4b, 0xa2, 0x4c,
    0xa2, 0x4d, 0xa2, 0x4e, 0xa2, 0x4f, 0xa2, 0x50, 0xa2, 0x51, 0xa2, 0x52,
    0xa2, 0x53, 0xa2, 0x54, 0xa2, 0x55, 0xa2, 0x56, 0xa2, 0x57, 0xa2, 0x59,
    0xa2, 0x6a, 0xa2, 0x6b, 0xa2, 0x71, 0xa2, 0x76, 0xa2, 0x77, 0xa2, 0x78,
    0xa2, 0x79, 0xa2, 0x7a};
const uint8_t HuffDecoderCommon::table24_106_emit_[136] = {
    0xb8, 0x30, 0xb8, 0x31, 0xb8, 0x32, 0xb8, 0x61, 0xb8, 0x63, 0xb8, 0x65,
    0xb8, 0x69, 0xb8, 0x6f, 0xb8, 0x73, 0xb8, 0x74, 0xb8, 0x20, 0xb8, 0x25,
    0xb8, 0x2d, 0xb8, 0x2e, 0xb8, 0x2f, 0xb8, 0x33, 0xb8, 0x34, 0xb8, 0x35,
    0xb8, 0x36, 0xb8, 0x37, 0xb8, 0x38, 0xb8, 0x39, 0xb8, 0x3d, 0xb8, 0x41,
    0xb8, 0x5f, 0xb8, 0x62, 0xb8, 0x64, 0xb8, 0x66, 0xb8, 0x67, 0xb8, 0x68,
    0xb8, 0x6c, 0xb8, 0x6d, 0xb8, 0x6e, 0xb8, 0x70, 0xb8, 0x72, 0xb8, 0x75,
    0xb8, 0x3a, 0xb8, 0x42, 0xb8, 0x43, 0xb8, 0x44, 0xb8, 0x45, 0xb8, 0x46,
    0xb8, 0x47, 0xb8, 0x48, 0xb8, 0x49, 0xb8, 0x4a, 0xb8, 0x4b, 0xb8, 0x4c,
    0xb8, 0x4d, 0xb8, 0x4e, 0xb8, 0x4f, 0xb8, 0x50, 0xb8, 0x51, 0xb8, 0x52,
    0xb8, 0x53, 0xb8, 0x54, 0xb8, 0x55, 0xb8, 0x56, 0xb8, 0x57, 0xb8, 0x59,
    0xb8, 0x6a, 0xb8, 0x6b, 0xb8, 0x71, 0xb8, 0x76, 0xb8, 0x77, 0xb8, 0x78,
    0xb8, 0x79, 0xb8, 0x7a};
const uint8_t HuffDecoderCommon::table24_107_emit_[136] = {
    0xc2, 0x30, 0xc2, 0x31, 0xc2, 0x32, 0xc2, 0x61, 0xc2, 0x63, 0xc2, 0x65,
    0xc2, 0x69, 0xc2, 0x6f, 0xc2, 0x73, 0xc2, 0x74, 0xc2, 0x20, 0xc2, 0x25,
    0xc2, 0x2d, 0xc2, 0x2e, 0xc2, 0x2f, 0xc2, 0x33, 0xc2, 0x34, 0xc2, 0x35,
    0xc2, 0x36, 0xc2, 0x37, 0xc2, 0x38, 0xc2, 0x39, 0xc2, 0x3d, 0xc2, 0x41,
    0xc2, 0x5f, 0xc2, 0x62, 0xc2, 0x64, 0xc2, 0x66, 0xc2, 0x67, 0xc2, 0x68,
    0xc2, 0x6c, 0xc2, 0x6d, 0xc2, 0x6e, 0xc2, 0x70, 0xc2, 0x72, 0xc2, 0x75,
    0xc2, 0x3a, 0xc2, 0x42, 0xc2, 0x43, 0xc2, 0x44, 0xc2, 0x45, 0xc2, 0x46,
    0xc2, 0x47, 0xc2, 0x48, 0xc2, 0x49, 0xc2, 0x4a, 0xc2, 0x4b, 0xc2, 0x4c,
    0xc2, 0x4d, 0xc2, 0x4e, 0xc2, 0x4f, 0xc2, 0x50, 0xc2, 0x51, 0xc2, 0x52,
    0xc2, 0x53, 0xc2, 0x54, 0xc2, 0x55, 0xc2, 0x56, 0xc2, 0x57, 0xc2, 0x59,
    0xc2, 0x6a, 0xc2, 0x6b, 0xc2, 0x71, 0xc2, 0x76, 0xc2, 0x77, 0xc2, 0x78,
    0xc2, 0x79, 0xc2, 0x7a};
const uint8_t HuffDecoderCommon::table24_108_emit_[136] = {
    0xe0, 0x30, 0xe0, 0x31, 0xe0, 0x32, 0xe0, 0x61, 0xe0, 0x63, 0xe0, 0x65,
    0xe0, 0x69, 0xe0, 0x6f, 0xe0, 0x73, 0xe0, 0x74, 0xe0, 0x20, 0xe0, 0x25,
    0xe0, 0x2d, 0xe0, 0x2e, 0xe0, 0x2f, 0xe0, 0x33, 0xe0, 0x34, 0xe0, 0x35,
    0xe0, 0x36, 0xe0, 0x37, 0xe0, 0x38, 0xe0, 0x39, 0xe0, 0x3d, 0xe0, 0x41,
    0xe0, 0x5f, 0xe0, 0x62, 0xe0, 0x64, 0xe0, 0x66, 0xe0, 0x67, 0xe0, 0x68,
    0xe0, 0x6c, 0xe0, 0x6d, 0xe0, 0x6e, 0xe0, 0x70, 0xe0, 0x72, 0xe0, 0x75,
    0xe0, 0x3a, 0xe0, 0x42, 0xe0, 0x43, 0xe0, 0x44, 0xe0, 0x45, 0xe0, 0x46,
    0xe0, 0x47, 0xe0, 0x48, 0xe0, 0x49, 0xe0, 0x4a, 0xe0, 0x4b, 0xe0, 0x4c,
    0xe0, 0x4d, 0xe0, 0x4e, 0xe0, 0x4f, 0xe0, 0x50, 0xe0, 0x51, 0xe0, 0x52,
    0xe0, 0x53, 0xe0, 0x54, 0xe0, 0x55, 0xe0, 0x56, 0xe0, 0x57, 0xe0, 0x59,
    0xe0, 0x6a, 0xe0, 0x6b, 0xe0, 0x71, 0xe0, 0x76, 0xe0, 0x77, 0xe0, 0x78,
    0xe0, 0x79, 0xe0, 0x7a};
const uint8_t HuffDecoderCommon::table24_109_emit_[136] = {
    0xe2, 0x30, 0xe2, 0x31, 0xe2, 0x32, 0xe2, 0x61, 0xe2, 0x63, 0xe2, 0x65,
    0xe2, 0x69, 0xe2, 0x6f, 0xe2, 0x73, 0xe2, 0x74, 0xe2, 0x20, 0xe2, 0x25,
    0xe2, 0x2d, 0xe2, 0x2e, 0xe2, 0x2f, 0xe2, 0x33, 0xe2, 0x34, 0xe2, 0x35,
    0xe2, 0x36, 0xe2, 0x37, 0xe2, 0x38, 0xe2, 0x39, 0xe2, 0x3d, 0xe2, 0x41,
    0xe2, 0x5f, 0xe2, 0x62, 0xe2, 0x64, 0xe2, 0x66, 0xe2, 0x67, 0xe2, 0x68,
    0xe2, 0x6c, 0xe2, 0x6d, 0xe2, 0x6e, 0xe2, 0x70, 0xe2, 0x72, 0xe2, 0x75,
    0xe2, 0x3a, 0xe2, 0x42, 0xe2, 0x43, 0xe2, 0x44, 0xe2, 0x45, 0xe2, 0x46,
    0xe2, 0x47, 0xe2, 0x48, 0xe2, 0x49, 0xe2, 0x4a, 0xe2, 0x4b, 0xe2, 0x4c,
    0xe2, 0x4d, 0xe2, 0x4e, 0xe2, 0x4f, 0xe2, 0x50, 0xe2, 0x51, 0xe2, 0x52,
    0xe2, 0x53, 0xe2, 0x54, 0xe2, 0x55, 0xe2, 0x56, 0xe2, 0x57, 0xe2, 0x59,
    0xe2, 0x6a, 0xe2, 0x6b, 0xe2, 0x71, 0xe2, 0x76, 0xe2, 0x77, 0xe2, 0x78,
    0xe2, 0x79, 0xe2, 0x7a};
const uint8_t HuffDecoderCommon::table24_110_emit_[144] = {
    0x99, 0x30, 0x99, 0x31, 0x99, 0x32, 0x99, 0x61, 0x99, 0x63, 0x99, 0x65,
    0x99, 0x69, 0x99, 0x6f, 0x99, 0x73, 0x99, 0x74, 0x99, 0x20, 0x99, 0x25,
    0x99, 0x2d, 0x99, 0x2e, 0x99, 0x2f, 0x99, 0x33, 0x99, 0x34, 0x99, 0x35,
    0x99, 0x36, 0x99, 0x37, 0x99, 0x38, 0x99, 0x39, 0x99, 0x3d, 0x99, 0x41,
    0x99, 0x5f, 0x99, 0x62, 0x99, 0x64, 0x99, 0x66, 0x99, 0x67, 0x99, 0x68,
    0x99, 0x6c, 0x99, 0x6d, 0x99, 0x6e, 0x99, 0x70, 0x99, 0x72, 0x99, 0x75,
    0xa1, 0x30, 0xa1, 0x31, 0xa1, 0x32, 0xa1, 0x61, 0xa1, 0x63, 0xa1, 0x65,
    0xa1, 0x69, 0xa1, 0x6f, 0xa1, 0x73, 0xa1, 0x74, 0xa1, 0x20, 0xa1, 0x25,
    0xa1, 0x2d, 0xa1, 0x2e, 0xa1, 0x2f, 0xa1, 0x33, 0xa1, 0x34, 0xa1, 0x35,
    0xa1, 0x36, 0xa1, 0x37, 0xa1, 0x38, 0xa1, 0x39, 0xa1, 0x3d, 0xa1, 0x41,
    0xa1, 0x5f, 0xa1, 0x62, 0xa1, 0x64, 0xa1, 0x66, 0xa1, 0x67, 0xa1, 0x68,
    0xa1, 0x6c, 0xa1, 0x6d, 0xa1, 0x6e, 0xa1, 0x70, 0xa1, 0x72, 0xa1, 0x75};
const uint8_t HuffDecoderCommon::table24_111_emit_[144] = {
    0xa7, 0x30, 0xa7, 0x31, 0xa7, 0x32, 0xa7, 0x61, 0xa7, 0x63, 0xa7, 0x65,
    0xa7, 0x69, 0xa7, 0x6f, 0xa7, 0x73, 0xa7, 0x74, 0xa7, 0x20, 0xa7, 0x25,
    0xa7, 0x2d, 0xa7, 0x2e, 0xa7, 0x2f, 0xa7, 0x33, 0xa7, 0x34, 0xa7, 0x35,
    0xa7, 0x36, 0xa7, 0x37, 0xa7, 0x38, 0xa7, 0x39, 0xa7, 0x3d, 0xa7, 0x41,
    0xa7, 0x5f, 0xa7, 0x62, 0xa7, 0x64, 0xa7, 0x66, 0xa7, 0x67, 0xa7, 0x68,
    0xa7, 0x6c, 0xa7, 0x6d, 0xa7, 0x6e, 0xa7, 0x70, 0xa7, 0x72, 0xa7, 0x75,
    0xac, 0x30, 0xac, 0x31, 0xac, 0x32, 0xac, 0x61, 0xac, 0x63, 0xac, 0x65,
    0xac, 0x69, 0xac, 0x6f, 0xac, 0x73, 0xac, 0x74, 0xac, 0x20, 0xac, 0x25,
    0xac, 0x2d, 0xac, 0x2e, 0xac, 0x2f, 0xac, 0x33, 0xac, 0x34, 0xac, 0x35,
    0xac, 0x36, 0xac, 0x37, 0xac, 0x38, 0xac, 0x39, 0xac, 0x3d, 0xac, 0x41,
    0xac, 0x5f, 0xac, 0x62, 0xac, 0x64, 0xac, 0x66, 0xac, 0x67, 0xac, 0x68,
    0xac, 0x6c, 0xac, 0x6d, 0xac, 0x6e, 0xac, 0x70, 0xac, 0x72, 0xac, 0x75};
const uint8_t HuffDecoderCommon::table24_112_emit_[144] = {
    0xb0, 0x30, 0xb0, 0x31, 0xb0, 0x32, 0xb0, 0x61, 0xb0, 0x63, 0xb0, 0x65,
    0xb0, 0x69, 0xb0, 0x6f, 0xb0, 0x73, 0xb0, 0x74, 0xb0, 0x20, 0xb0, 0x25,
    0xb0, 0x2d, 0xb0, 0x2e, 0xb0, 0x2f, 0xb0, 0x33, 0xb0, 0x34, 0xb0, 0x35,
    0xb0, 0x36, 0xb0, 0x37, 0xb0, 0x38, 0xb0, 0x39, 0xb0, 0x3d, 0xb0, 0x41,
    0xb0, 0x5f, 0xb0, 0x62, 0xb0, 0x64, 0xb0, 0x66, 0xb0, 0x67, 0xb0, 0x68,
    0xb0, 0x6c, 0xb0, 0x6d, 0xb0, 0x6e, 0xb0, 0x70, 0xb0, 0x72, 0xb0, 0x75,
    0xb1, 0x30, 0xb1, 0x31, 0xb1, 0x32, 0xb1, 0x61, 0xb1, 0x63, 0xb1, 0x65,
    0xb1, 0x69, 0xb1, 0x6f, 0xb1, 0x73, 0xb1, 0x74, 0xb1, 0x20, 0xb1, 0x25,
    0xb1, 0x2d, 0xb1, 0x2e, 0xb1, 0x2f, 0xb1, 0x33, 0xb1, 0x34, 0xb1, 0x35,
    0xb1, 0x36, 0xb1, 0x37, 0xb1, 0x38, 0xb1, 0x39, 0xb1, 0x3d, 0xb1, 0x41,
    0xb1, 0x5f, 0xb1, 0x62, 0xb1, 0x64, 0xb1, 0x66, 0xb1, 0x67, 0xb1, 0x68,
    0xb1, 0x6c, 0xb1, 0x6d, 0xb1, 0x6e, 0xb1, 0x70, 0xb1, 0x72, 0xb1, 0x75};
const uint8_t HuffDecoderCommon::table24_113_emit_[144] = {
    0xb3, 0x30, 0xb3, 0x31, 0xb3, 0x32, 0xb3, 0x61, 0xb3, 0x63, 0xb3, 0x65,
    0xb3, 0x69, 0xb3, 0x6f, 0xb3, 0x73, 0xb3, 0x74, 0xb3, 0x20, 0xb3, 0x25,
    0xb3, 0x2d, 0xb3, 0x2e, 0xb3, 0x2f, 0xb3, 0x33, 0xb3, 0x34, 0xb3, 0x35,
    0xb3, 0x36, 0xb3, 0x37, 0xb3, 0x38, 0xb3, 0x39, 0xb3, 0x3d, 0xb3, 0x41,
    0xb3, 0x5f, 0xb3, 0x62, 0xb3, 0x64, 0xb3, 0x66, 0xb3, 0x67, 0xb3, 0x68,
    0xb3, 0x6c, 0xb3, 0x6d, 0xb3, 0x6e, 0xb3, 0x70, 0xb3, 0x72, 0xb3, 0x75,
    0xd1, 0x30, 0xd1, 0x31, 0xd1, 0x32, 0xd1, 0x61, 0xd1, 0x63, 0xd1, 0x65,
    0xd1, 0x69, 0xd1, 0x6f, 0xd1, 0x73, 0xd1, 0x74, 0xd1, 0x20, 0xd1, 0x25,
    0xd1, 0x2d, 0xd1, 0x2e, 0xd1, 0x2f, 0xd1, 0x33, 0xd1, 0x34, 0xd1, 0x35,
    0xd1, 0x36, 0xd1, 0x37, 0xd1, 0x38, 0xd1, 0x39, 0xd1, 0x3d, 0xd1, 0x41,
    0xd1, 0x5f, 0xd1, 0x62, 0xd1, 0x64, 0xd1, 0x66, 0xd1, 0x67, 0xd1, 0x68,
    0xd1, 0x6c, 0xd1, 0x6d, 0xd1, 0x6e, 0xd1, 0x70, 0xd1, 0x72, 0xd1, 0x75};
const uint8_t HuffDecoderCommon::table24_114_emit_[144] = {
    0xd8, 0x30, 0xd8, 0x31, 0xd8, 0x32, 0xd8, 0x61, 0xd8, 0x63, 0xd8, 0x65,
    0xd8, 0x69, 0xd8, 0x6f, 0xd8, 0x73, 0xd8, 0x74, 0xd8, 0x20, 0xd8, 0x25,
    0xd8, 0x2d, 0xd8, 0x2e, 0xd8, 0x2f, 0xd8, 0x33, 0xd8, 0x34, 0xd8, 0x35,
    0xd8, 0x36, 0xd8, 0x37, 0xd8, 0x38, 0xd8, 0x39, 0xd8, 0x3d, 0xd8, 0x41,
    0xd8, 0x5f, 0xd8, 0x62, 0xd8, 0x64, 0xd8, 0x66, 0xd8, 0x67, 0xd8, 0x68,
    0xd8, 0x6c, 0xd8, 0x6d, 0xd8, 0x6e, 0xd8, 0x70, 0xd8, 0x72, 0xd8, 0x75,
    0xd9, 0x30, 0xd9, 0x31, 0xd9, 0x32, 0xd9, 0x61, 0xd9, 0x63, 0xd9, 0x65,
    0xd9, 0x69, 0xd9, 0x6f, 0xd9, 0x73, 0xd9, 0x74, 0xd9, 0x20, 0xd9, 0x25,
    0xd9, 0x2d, 0xd9, 0x2e, 0xd9, 0x2f, 0xd9, 0x33, 0xd9, 0x34, 0xd9, 0x35,
    0xd9, 0x36, 0xd9, 0x37, 0xd9, 0x38, 0xd9, 0x39, 0xd9, 0x3d, 0xd9, 0x41,
    0xd9, 0x5f, 0xd9, 0x62, 0xd9, 0x64, 0xd9, 0x66, 0xd9, 0x67, 0xd9, 0x68,
    0xd9, 0x6c, 0xd9, 0x6d, 0xd9, 0x6e, 0xd9, 0x70, 0xd9, 0x72, 0xd9, 0x75};
const uint8_t HuffDecoderCommon::table24_115_emit_[144] = {
    0xe3, 0x30, 0xe3, 0x31, 0xe3, 0x32, 0xe3, 0x61, 0xe3, 0x63, 0xe3, 0x65,
    0xe3, 0x69, 0xe3, 0x6f, 0xe3, 0x73, 0xe3, 0x74, 0xe3, 0x20, 0xe3, 0x25,
    0xe3, 0x2d, 0xe3, 0x2e, 0xe3, 0x2f, 0xe3, 0x33, 0xe3, 0x34, 0xe3, 0x35,
    0xe3, 0x36, 0xe3, 0x37, 0xe3, 0x38, 0xe3, 0x39, 0xe3, 0x3d, 0xe3, 0x41,
    0xe3, 0x5f, 0xe3, 0x62, 0xe3, 0x64, 0xe3, 0x66, 0xe3, 0x67, 0xe3, 0x68,
    0xe3, 0x6c, 0xe3, 0x6d, 0xe3, 0x6e, 0xe3, 0x70, 0xe3, 0x72, 0xe3, 0x75,
    0xe5, 0x30, 0xe5, 0x31, 0xe5, 0x32, 0xe5, 0x61, 0xe5, 0x63, 0xe5, 0x65,
    0xe5, 0x69, 0xe5, 0x6f, 0xe5, 0x73, 0xe5, 0x74, 0xe5, 0x20, 0xe5, 0x25,
    0xe5, 0x2d, 0xe5, 0x2e, 0xe5, 0x2f, 0xe5, 0x33, 0xe5, 0x34, 0xe5, 0x35,
    0xe5, 0x36, 0xe5, 0x37, 0xe5, 0x38, 0xe5, 0x39, 0xe5, 0x3d, 0xe5, 0x41,
    0xe5, 0x5f, 0xe5, 0x62, 0xe5, 0x64, 0xe5, 0x66, 0xe5, 0x67, 0xe5, 0x68,
    0xe5, 0x6c, 0xe5, 0x6d, 0xe5, 0x6e, 0xe5, 0x70, 0xe5, 0x72, 0xe5, 0x75};
const uint8_t HuffDecoderCommon::table24_116_emit_[112] = {
    0xe6, 0x30, 0xe6, 0x31, 0xe6, 0x32, 0xe6, 0x61, 0xe6, 0x63, 0xe6, 0x65,
    0xe6, 0x69, 0xe6, 0x6f, 0xe6, 0x73, 0xe6, 0x74, 0xe6, 0x20, 0xe6, 0x25,
    0xe6, 0x2d, 0xe6, 0x2e, 0xe6, 0x2f, 0xe6, 0x33, 0xe6, 0x34, 0xe6, 0x35,
    0xe6, 0x36, 0xe6, 0x37, 0xe6, 0x38, 0xe6, 0x39, 0xe6, 0x3d, 0xe6, 0x41,
    0xe6, 0x5f, 0xe6, 0x62, 0xe6, 0x64, 0xe6, 0x66, 0xe6, 0x67, 0xe6, 0x68,
    0xe6, 0x6c, 0xe6, 0x6d, 0xe6, 0x6e, 0xe6, 0x70, 0xe6, 0x72, 0xe6, 0x75,
    0x81, 0x30, 0x81, 0x31, 0x81, 0x32, 0x81, 0x61, 0x81, 0x63, 0x81, 0x65,
    0x81, 0x69, 0x81, 0x6f, 0x81, 0x73, 0x81, 0x74, 0x84, 0x30, 0x84, 0x31,
    0x84, 0x32, 0x84, 0x61, 0x84, 0x63, 0x84, 0x65, 0x84, 0x69, 0x84, 0x6f,
    0x84, 0x73, 0x84, 0x74};
const uint16_t HuffDecoderCommon::table24_116_ops_[128] = {
    0x0000, 0x0002, 0x0000, 0x0012, 0x0000, 0x0022, 0x0000, 0x0032, 0x0000,
    0x0042, 0x0000, 0x0052, 0x0000, 0x0062, 0x0000, 0x0072, 0x0000, 0x0082,
    0x0000, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0003, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2, 0x02b2,
    0x02c2, 0x02d2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0243, 0x02e2, 0x02f2, 0x0302,
    0x0312, 0x0322, 0x0332, 0x0342, 0x0352, 0x0362, 0x0372, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x02e3};
const uint8_t HuffDecoderCommon::table24_117_emit_[80] = {
    0x85, 0x30, 0x85, 0x31, 0x85, 0x32, 0x85, 0x61, 0x85, 0x63, 0x85, 0x65,
    0x85, 0x69, 0x85, 0x6f, 0x85, 0x73, 0x85, 0x74, 0x86, 0x30, 0x86, 0x31,
    0x86, 0x32, 0x86, 0x61, 0x86, 0x63, 0x86, 0x65, 0x86, 0x69, 0x86, 0x6f,
    0x86, 0x73, 0x86, 0x74, 0x88, 0x30, 0x88, 0x31, 0x88, 0x32, 0x88, 0x61,
    0x88, 0x63, 0x88, 0x65, 0x88, 0x69, 0x88, 0x6f, 0x88, 0x73, 0x88, 0x74,
    0x92, 0x30, 0x92, 0x31, 0x92, 0x32, 0x92, 0x61, 0x92, 0x63, 0x92, 0x65,
    0x92, 0x69, 0x92, 0x6f, 0x92, 0x73, 0x92, 0x74};
const uint8_t HuffDecoderCommon::table24_118_emit_[80] = {
    0x9a, 0x30, 0x9a, 0x31, 0x9a, 0x32, 0x9a, 0x61, 0x9a, 0x63, 0x9a, 0x65,
    0x9a, 0x69, 0x9a, 0x6f, 0x9a, 0x73, 0x9a, 0x74, 0x9c, 0x30, 0x9c, 0x31,
    0x9c, 0x32, 0x9c, 0x61, 0x9c, 0x63, 0x9c, 0x65, 0x9c, 0x69, 0x9c, 0x6f,
    0x9c, 0x73, 0x9c, 0x74, 0xa0, 0x30, 0xa0, 0x31, 0xa0, 0x32, 0xa0, 0x61,
    0xa0, 0x63, 0xa0, 0x65, 0xa0, 0x69, 0xa0, 0x6f, 0xa0, 0x73, 0xa0, 0x74,
    0xa3, 0x30, 0xa3, 0x31, 0xa3, 0x32, 0xa3, 0x61, 0xa3, 0x63, 0xa3, 0x65,
    0xa3, 0x69, 0xa3, 0x6f, 0xa3, 0x73, 0xa3, 0x74};
const uint8_t HuffDecoderCommon::table24_119_emit_[80] = {
    0xa4, 0x30, 0xa4, 0x31, 0xa4, 0x32, 0xa4, 0x61, 0xa4, 0x63, 0xa4, 0x65,
    0xa4, 0x69, 0xa4, 0x6f, 0xa4, 0x73, 0xa4, 0x74, 0xa9, 0x30, 0xa9, 0x31,
    0xa9, 0x32, 0xa9, 0x61, 0xa9, 0x63, 0xa9, 0x65, 0xa9, 0x69, 0xa9, 0x6f,
    0xa9, 0x73, 0xa9, 0x74, 0xaa, 0x30, 0xaa, 0x31, 0xaa, 0x32, 0xaa, 0x61,
    0xaa, 0x63, 0xaa, 0x65, 0xaa, 0x69, 0xaa, 0x6f, 0xaa, 0x73, 0xaa, 0x74,
    0xad, 0x30, 0xad, 0x31, 0xad, 0x32, 0xad, 0x61, 0xad, 0x63, 0xad, 0x65,
    0xad, 0x69, 0xad, 0x6f, 0xad, 0x73, 0xad, 0x74};
const uint8_t HuffDecoderCommon::table24_120_emit_[80] = {
    0xb2, 0x30, 0xb2, 0x31, 0xb2, 0x32, 0xb2, 0x61, 0xb2, 0x63, 0xb2, 0x65,
    0xb2, 0x69, 0xb2, 0x6f, 0xb2, 0x73, 0xb2, 0x74, 0xb5, 0x30, 0xb5, 0x31,
    0xb5, 0x32, 0xb5, 0x61, 0xb5, 0x63, 0xb5, 0x65, 0xb5, 0x69, 0xb5, 0x6f,
    0xb5, 0x73, 0xb5, 0x74, 0xb9, 0x30, 0xb9, 0x31, 0xb9, 0x32, 0xb9, 0x61,
    0xb9, 0x63, 0xb9, 0x65, 0xb9, 0x69, 0xb9, 0x6f, 0xb9, 0x73, 0xb9, 0x74,
    0xba, 0x30, 0xba, 0x31, 0xba, 0x32, 0xba, 0x61, 0xba, 0x63, 0xba, 0x65,
    0xba, 0x69, 0xba, 0x6f, 0xba, 0x73, 0xba, 0x74};
const uint8_t HuffDecoderCommon::table24_121_emit_[80] = {
    0xbb, 0x30, 0xbb, 0x31, 0xbb, 0x32, 0xbb, 0x61, 0xbb, 0x63, 0xbb, 0x65,
    0xbb, 0x69, 0xbb, 0x6f, 0xbb, 0x73, 0xbb, 0x74, 0xbd, 0x30, 0xbd, 0x31,
    0xbd, 0x32, 0xbd, 0x61, 0xbd, 0x63, 0xbd, 0x65, 0xbd, 0x69, 0xbd, 0x6f,
    0xbd, 0x73, 0xbd, 0x74, 0xbe, 0x30, 0xbe, 0x31, 0xbe, 0x32, 0xbe, 0x61,
    0xbe, 0x63, 0xbe, 0x65, 0xbe, 0x69, 0xbe, 0x6f, 0xbe, 0x73, 0xbe, 0x74,
    0xc4, 0x30, 0xc4, 0x31, 0xc4, 0x32, 0xc4, 0x61, 0xc4, 0x63, 0xc4, 0x65,
    0xc4, 0x69, 0xc4, 0x6f, 0xc4, 0x73, 0xc4, 0x74};
const uint8_t HuffDecoderCommon::table24_122_emit_[80] = {
    0xc6, 0x30, 0xc6, 0x31, 0xc6, 0x32, 0xc6, 0x61, 0xc6, 0x63, 0xc6, 0x65,
    0xc6, 0x69, 0xc6, 0x6f, 0xc6, 0x73, 0xc6, 0x74, 0xe4, 0x30, 0xe4, 0x31,
    0xe4, 0x32, 0xe4, 0x61, 0xe4, 0x63, 0xe4, 0x65, 0xe4, 0x69, 0xe4, 0x6f,
    0xe4, 0x73, 0xe4, 0x74, 0xe8, 0x30, 0xe8, 0x31, 0xe8, 0x32, 0xe8, 0x61,
    0xe8, 0x63, 0xe8, 0x65, 0xe8, 0x69, 0xe8, 0x6f, 0xe8, 0x73, 0xe8, 0x74,
    0xe9, 0x30, 0xe9, 0x31, 0xe9, 0x32, 0xe9, 0x61, 0xe9, 0x63, 0xe9, 0x65,
    0xe9, 0x69, 0xe9, 0x6f, 0xe9, 0x73, 0xe9, 0x74};
const uint8_t HuffDecoderCommon::table24_123_emit_[8] = {
    0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f};
const uint8_t HuffDecoderCommon::table24_124_emit_[8] = {
    0x93, 0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e};
const uint8_t HuffDecoderCommon::table24_125_emit_[8] = {
    0xa5, 0xa6, 0xa8, 0xae, 0xaf, 0xb4, 0xb6, 0xb7};
const uint8_t HuffDecoderCommon::table24_126_emit_[11] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f};
const uint16_t HuffDecoderCommon::table24_126_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x001b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0023, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x002b, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0033, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x003b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x004b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0053};
const uint8_t HuffDecoderCommon::table24_127_emit_[44] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb, 0xc0,
    0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee, 0xf0,
    0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf,
    0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe};
const uint16_t HuffDecoderCommon::table24_127_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0013, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x001b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0023, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x002b, 0x0000, 0x0000, 0x0000, 0x0033, 0x0000, 0x0000,
    0x0000, 0x003b, 0x0000, 0x0000, 0x0000, 0x0043, 0x0000, 0x0000, 0x0000,
    0x004b, 0x0000, 0x0053, 0x0000, 0x005b, 0x0000, 0x0063, 0x0000, 0x006b,
    0x0000, 0x0073, 0x0000, 0x007b, 0x0000, 0x0083, 0x0000, 0x008b, 0x0000,
    0x0093, 0x0000, 0x009b, 0x0000, 0x00a3, 0x0000, 0x00ab, 0x0000, 0x00b3,
    0x0000, 0x00bb, 0x0000, 0x00c3, 0x00cb, 0x00d3, 0x00db, 0x00e3, 0x00eb,
    0x00f3, 0x00fb, 0x0103, 0x010b, 0x0113, 0x011b, 0x0123, 0x012b, 0x0133,
    0x013b, 0x0143, 0x014b, 0x0153, 0x015b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0004};
const uint8_t* const HuffDecoderCommon::table24_emit_[128] = {
    table24_0_emit_,   table24_1_emit_,   table24_2_emit_,   table24_3_emit_,
    table24_4_emit_,   table24_5_emit_,   table24_6_emit_,   table24_7_emit_,
    table24_8_emit_,   table24_9_emit_,   table24_10_emit_,  table24_11_emit_,
    table24_12_emit_,  table24_13_emit_,  table24_14_emit_,  table24_15_emit_,
    table24_16_emit_,  table24_17_emit_,  table24_18_emit_,  table24_19_emit_,
    table24_20_emit_,  table24_21_emit_,  table24_22_emit_,  table24_23_emit_,
    table24_24_emit_,  table24_25_emit_,  table24_26_emit_,  table24_27_emit_,
    table24_28_emit_,  table24_29_emit_,  table24_30_emit_,  table24_31_emit_,
    table24_32_emit_,  table24_33_emit_,  table24_34_emit_,  table24_35_emit_,
    table24_36_emit_,  table24_37_emit_,  table24_38_emit_,  table24_39_emit_,
    table24_40_emit_,  table24_41_emit_,  table24_42_emit_,  table24_43_emit_,
    table24_44_emit_,  table24_45_emit_,  table24_46_emit_,  table24_47_emit_,
    table24_48_emit_,  table24_49_emit_,  table24_50_emit_,  table24_51_emit_,
    table24_52_emit_,  table24_53_emit_,  table24_54_emit_,  table24_55_emit_,
    table24_56_emit_,  table24_57_emit_,  table24_58_emit_,  table24_59_emit_,
    table24_60_emit_,  table24_61_emit_,  table24_62_emit_,  table24_63_emit_,
    table24_64_emit_,  table24_65_emit_,  table24_66_emit_,  table24_67_emit_,
    table24_68_emit_,  table24_69_emit_,  table24_70_emit_,  table24_71_emit_,
    table24_72_emit_,  table24_73_emit_,  table24_74_emit_,  table24_75_emit_,
    table24_76_emit_,  table24_77_emit_,  table24_78_emit_,  table24_79_emit_,
    table24_80_emit_,  table24_81_emit_,  table24_82_emit_,  table24_83_emit_,
    table24_84_emit_,  table24_85_emit_,  table24_86_emit_,  table24_87_emit_,
    table24_88_emit_,  table24_89_emit_,  table24_90_emit_,  table24_91_emit_,
    table24_92_emit_,  table24_93_emit_,  table24_94_emit_,  table24_95_emit_,
    table24_96_emit_,  table24_97_emit_,  table24_98_emit_,  table24_99_emit_,
    table24_100_emit_, table24_101_emit_, table24_102_emit_, table24_103_emit_,
    table24_104_emit_, table24_105_emit_, table24_106_emit_, table24_107_emit_,
    table24_108_emit_, table24_109_emit_, table24_110_emit_, table24_111_emit_,
    table24_112_emit_, table24_113_emit_, table24_114_emit_, table24_115_emit_,
    table24_116_emit_, table24_117_emit_, table24_118_emit_, table24_119_emit_,
    table24_120_emit_, table24_121_emit_, table24_122_emit_, table24_123_emit_,
    table24_124_emit_, table24_125_emit_, table24_126_emit_, table24_127_emit_,
};
const uint16_t* const HuffDecoderCommon::table24_ops_[128] = {
    table24_0_ops_,   table24_0_ops_,  table24_0_ops_,   table24_0_ops_,
    table24_0_ops_,   table24_0_ops_,  table24_0_ops_,   table24_0_ops_,
    table24_0_ops_,   table24_0_ops_,  table23_0_ops_,   table23_0_ops_,
    table23_0_ops_,   table23_0_ops_,  table23_0_ops_,   table23_0_ops_,
    table23_0_ops_,   table23_0_ops_,  table23_0_ops_,   table23_0_ops_,
    table23_0_ops_,   table23_0_ops_,  table23_0_ops_,   table23_5_ops_,
    table23_5_ops_,   table23_5_ops_,  table23_5_ops_,   table23_5_ops_,
    table23_5_ops_,   table23_5_ops_,  table23_5_ops_,   table24_31_ops_,
    table24_0_ops_,   table24_0_ops_,  table24_0_ops_,   table24_0_ops_,
    table24_0_ops_,   table24_0_ops_,  table24_0_ops_,   table24_0_ops_,
    table24_0_ops_,   table24_0_ops_,  table23_0_ops_,   table23_0_ops_,
    table23_0_ops_,   table23_0_ops_,  table23_0_ops_,   table23_0_ops_,
    table23_0_ops_,   table23_0_ops_,  table23_0_ops_,   table23_0_ops_,
    table23_0_ops_,   table23_0_ops_,  table23_0_ops_,   table23_5_ops_,
    table23_5_ops_,   table23_5_ops_,  table23_5_ops_,   table23_5_ops_,
    table23_5_ops_,   table23_5_ops_,  table23_5_ops_,   table24_31_ops_,
    table24_0_ops_,   table24_0_ops_,  table24_0_ops_,   table24_0_ops_,
    table24_0_ops_,   table24_0_ops_,  table24_0_ops_,   table24_0_ops_,
    table24_0_ops_,   table24_0_ops_,  table23_0_ops_,   table23_0_ops_,
    table23_0_ops_,   table23_0_ops_,  table23_0_ops_,   table23_0_ops_,
    table23_0_ops_,   table23_0_ops_,  table23_0_ops_,   table23_0_ops_,
    table23_0_ops_,   table23_0_ops_,  table23_0_ops_,   table23_5_ops_,
    table23_5_ops_,   table23_5_ops_,  table23_5_ops_,   table23_5_ops_,
    table23_5_ops_,   table23_5_ops_,  table23_5_ops_,   table24_31_ops_,
    table24_96_ops_,  table24_97_ops_, table24_96_ops_,  table24_97_ops_,
    table24_96_ops_,  table24_97_ops_, table23_48_ops_,  table23_48_ops_,
    table23_48_ops_,  table23_48_ops_, table23_48_ops_,  table23_48_ops_,
    table23_48_ops_,  table23_48_ops_, table23_51_ops_,  table23_51_ops_,
    table23_51_ops_,  table23_51_ops_, table23_51_ops_,  table23_51_ops_,
    table24_116_ops_, table23_55_ops_, table23_55_ops_,  table23_55_ops_,
    table23_55_ops_,  table23_55_ops_, table23_55_ops_,  table23_59_ops_,
    table23_59_ops_,  table23_59_ops_, table24_126_ops_, table24_127_ops_,
};
const uint8_t HuffDecoderCommon::table11_0_emit_[1] = {0x3c};
const uint16_t HuffDecoderCommon::table11_0_ops_[256] = {
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002};
const uint8_t HuffDecoderCommon::table11_32_emit_[1] = {0x60};
const uint8_t HuffDecoderCommon::table11_64_emit_[1] = {0x7b};
const uint8_t HuffDecoderCommon::table11_96_emit_[1] = {0x5c};
const uint16_t HuffDecoderCommon::table11_96_ops_[256] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006};
const uint8_t HuffDecoderCommon::table11_98_emit_[1] = {0xc3};
const uint8_t HuffDecoderCommon::table11_100_emit_[1] = {0xd0};
const uint8_t HuffDecoderCommon::table11_102_emit_[1] = {0x80};
const uint16_t HuffDecoderCommon::table11_102_ops_[256] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007};
const uint8_t HuffDecoderCommon::table11_103_emit_[1] = {0x82};
const uint8_t HuffDecoderCommon::table11_104_emit_[1] = {0x83};
const uint8_t HuffDecoderCommon::table11_105_emit_[1] = {0xa2};
const uint8_t HuffDecoderCommon::table11_106_emit_[1] = {0xb8};
const uint8_t HuffDecoderCommon::table11_107_emit_[1] = {0xc2};
const uint8_t HuffDecoderCommon::table11_108_emit_[1] = {0xe0};
const uint8_t HuffDecoderCommon::table11_109_emit_[1] = {0xe2};
const uint8_t HuffDecoderCommon::table11_110_emit_[2] = {0x99, 0xa1};
const uint16_t HuffDecoderCommon::table11_110_ops_[256] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028};
const uint8_t HuffDecoderCommon::table11_111_emit_[2] = {0xa7, 0xac};
const uint8_t HuffDecoderCommon::table11_112_emit_[2] = {0xb0, 0xb1};
const uint8_t HuffDecoderCommon::table11_113_emit_[2] = {0xb3, 0xd1};
const uint8_t HuffDecoderCommon::table11_114_emit_[2] = {0xd8, 0xd9};
const uint8_t HuffDecoderCommon::table11_115_emit_[2] = {0xe3, 0xe5};
const uint8_t HuffDecoderCommon::table11_116_emit_[3] = {0xe6, 0x81, 0x84};
const uint16_t HuffDecoderCommon::table11_116_ops_[256] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049};
const uint8_t HuffDecoderCommon::table11_117_emit_[4] = {0x85, 0x86, 0x88,
                                                         0x92};
const uint16_t HuffDecoderCommon::table11_117_ops_[256] = {
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0069, 0x0069, 0x0069};
const uint8_t HuffDecoderCommon::table11_118_emit_[4] = {0x9a, 0x9c, 0xa0,
                                                         0xa3};
const uint8_t HuffDecoderCommon::table11_119_emit_[4] = {0xa4, 0xa9, 0xaa,
                                                         0xad};
const uint8_t HuffDecoderCommon::table11_120_emit_[4] = {0xb2, 0xb5, 0xb9,
                                                         0xba};
const uint8_t HuffDecoderCommon::table11_121_emit_[4] = {0xbb, 0xbd, 0xbe,
                                                         0xc4};
const uint8_t HuffDecoderCommon::table11_122_emit_[4] = {0xc6, 0xe4, 0xe8,
                                                         0xe9};
const uint16_t HuffDecoderCommon::table11_123_ops_[256] = {
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x006a, 0x006a, 0x006a,
    0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a,
    0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a,
    0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a,
    0x006a, 0x006a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x00aa, 0x00aa,
    0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
    0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
    0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
    0x00aa, 0x00aa, 0x00aa, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ea,
    0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
    0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
    0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
    0x00ea, 0x00ea, 0x00ea, 0x00ea};
const uint16_t HuffDecoderCommon::table11_126_ops_[256] = {
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x006a, 0x006a, 0x006a,
    0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a,
    0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a,
    0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a,
    0x006a, 0x006a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x00ab, 0x00ab,
    0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab,
    0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
    0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
    0x00cb, 0x00cb, 0x00cb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb,
    0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb,
    0x00eb, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b,
    0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x012b,
    0x012b, 0x012b, 0x012b, 0x012b, 0x012b, 0x012b, 0x012b, 0x012b, 0x012b,
    0x012b, 0x012b, 0x012b, 0x012b, 0x012b, 0x012b, 0x014b, 0x014b, 0x014b,
    0x014b, 0x014b, 0x014b, 0x014b, 0x014b, 0x014b, 0x014b, 0x014b, 0x014b,
    0x014b, 0x014b, 0x014b, 0x014b};
const uint8_t HuffDecoderCommon::table11_127_emit_[73] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb, 0xc0,
    0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee, 0xf0,
    0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf,
    0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe,
    0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0b, 0x0c, 0x0e, 0x0f,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18, 0x19, 0x1a, 0x1b,
    0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint16_t HuffDecoderCommon::table11_127_ops_[256] = {
    0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b,
    0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x002b, 0x002b,
    0x002b, 0x002b, 0x002b, 0x002b, 0x002b, 0x002b, 0x002b, 0x002b, 0x002b,
    0x002b, 0x002b, 0x002b, 0x002b, 0x002b, 0x004b, 0x004b, 0x004b, 0x004b,
    0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x004b,
    0x004b, 0x004b, 0x004b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b,
    0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b,
    0x006b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b,
    0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x00ab,
    0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab,
    0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00cc, 0x00cc, 0x00cc,
    0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00ec, 0x00ec, 0x00ec, 0x00ec,
    0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x010c, 0x010c, 0x010c, 0x010c, 0x010c,
    0x010c, 0x010c, 0x010c, 0x012c, 0x012c, 0x012c, 0x012c, 0x012c, 0x012c,
    0x012c, 0x012c, 0x014d, 0x014d, 0x014d, 0x014d, 0x016d, 0x016d, 0x016d,
    0x016d, 0x018d, 0x018d, 0x018d, 0x018d, 0x01ad, 0x01ad, 0x01ad, 0x01ad,
    0x01cd, 0x01cd, 0x01cd, 0x01cd, 0x01ed, 0x01ed, 0x01ed, 0x01ed, 0x020d,
    0x020d, 0x020d, 0x020d, 0x022d, 0x022d, 0x022d, 0x022d, 0x024d, 0x024d,
    0x024d, 0x024d, 0x026d, 0x026d, 0x026d, 0x026d, 0x028d, 0x028d, 0x028d,
    0x028d, 0x02ad, 0x02ad, 0x02ad, 0x02ad, 0x02cd, 0x02cd, 0x02cd, 0x02cd,
    0x02ed, 0x02ed, 0x02ed, 0x02ed, 0x030d, 0x030d, 0x030d, 0x030d, 0x032e,
    0x032e, 0x034e, 0x034e, 0x036e, 0x036e, 0x038e, 0x038e, 0x03ae, 0x03ae,
    0x03ce, 0x03ce, 0x03ee, 0x03ee, 0x040e, 0x040e, 0x042e, 0x042e, 0x044e,
    0x044e, 0x046e, 0x046e, 0x048e, 0x048e, 0x04ae, 0x04ae, 0x04ce, 0x04ce,
    0x04ee, 0x04ee, 0x050e, 0x050e, 0x052e, 0x052e, 0x054e, 0x054e, 0x056e,
    0x056e, 0x058f, 0x05af, 0x05cf, 0x05ef, 0x060f, 0x062f, 0x064f, 0x066f,
    0x068f, 0x06af, 0x06cf, 0x06ef, 0x070f, 0x072f, 0x074f, 0x076f, 0x078f,
    0x07af, 0x07cf, 0x07ef, 0x080f, 0x082f, 0x084f, 0x086f, 0x088f, 0x08af,
    0x08cf, 0x08ef, 0x090f, 0x001f};
const uint8_t* const HuffDecoderCommon::table11_emit_[128] = {
    table11_0_emit_,   table11_0_emit_,   table11_0_emit_,   table11_0_emit_,
    table11_0_emit_,   table11_0_emit_,   table11_0_emit_,   table11_0_emit_,
    table11_0_emit_,   table11_0_emit_,   table11_0_emit_,   table11_0_emit_,
    table11_0_emit_,   table11_0_emit_,   table11_0_emit_,   table11_0_emit_,
    table11_0_emit_,   table11_0_emit_,   table11_0_emit_,   table11_0_emit_,
    table11_0_emit_,   table11_0_emit_,   table11_0_emit_,   table11_0_emit_,
    table11_0_emit_,   table11_0_emit_,   table11_0_emit_,   table11_0_emit_,
    table11_0_emit_,   table11_0_emit_,   table11_0_emit_,   table11_0_emit_,
    table11_32_emit_,  table11_32_emit_,  table11_32_emit_,  table11_32_emit_,
    table11_32_emit_,  table11_32_emit_,  table11_32_emit_,  table11_32_emit_,
    table11_32_emit_,  table11_32_emit_,  table11_32_emit_,  table11_32_emit_,
    table11_32_emit_,  table11_32_emit_,  table11_32_emit_,  table11_32_emit_,
    table11_32_emit_,  table11_32_emit_,  table11_32_emit_,  table11_32_emit_,
    table11_32_emit_,  table11_32_emit_,  table11_32_emit_,  table11_32_emit_,
    table11_32_emit_,  table11_32_emit_,  table11_32_emit_,  table11_32_emit_,
    table11_32_emit_,  table11_32_emit_,  table11_32_emit_,  table11_32_emit_,
    table11_64_emit_,  table11_64_emit_,  table11_64_emit_,  table11_64_emit_,
    table11_64_emit_,  table11_64_emit_,  table11_64_emit_,  table11_64_emit_,
    table11_64_emit_,  table11_64_emit_,  table11_64_emit_,  table11_64_emit_,
    table11_64_emit_,  table11_64_emit_,  table11_64_emit_,  table11_64_emit_,
    table11_64_emit_,  table11_64_emit_,  table11_64_emit_,  table11_64_emit_,
    table11_64_emit_,  table11_64_emit_,  table11_64_emit_,  table11_64_emit_,
    table11_64_emit_,  table11_64_emit_,  table11_64_emit_,  table11_64_emit_,
    table11_64_emit_,  table11_64_emit_,  table11_64_emit_,  table11_64_emit_,
    table11_96_emit_,  table11_96_emit_,  table11_98_emit_,  table11_98_emit_,
    table11_100_emit_, table11_100_emit_, table11_102_emit_, table11_103_emit_,
    table11_104_emit_, table11_105_emit_, table11_106_emit_, table11_107_emit_,
    table11_108_emit_, table11_109_emit_, table11_110_emit_, table11_111_emit_,
    table11_112_emit_, table11_113_emit_, table11_114_emit_, table11_115_emit_,
    table11_116_emit_, table11_117_emit_, table11_118_emit_, table11_119_emit_,
    table11_120_emit_, table11_121_emit_, table11_122_emit_, table24_123_emit_,
    table24_124_emit_, table24_125_emit_, table24_126_emit_, table11_127_emit_,
};
const uint16_t* const HuffDecoderCommon::table11_ops_[128] = {
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_0_ops_,   table11_0_ops_,   table11_0_ops_,   table11_0_ops_,
    table11_96_ops_,  table11_96_ops_,  table11_96_ops_,  table11_96_ops_,
    table11_96_ops_,  table11_96_ops_,  table11_102_ops_, table11_102_ops_,
    table11_102_ops_, table11_102_ops_, table11_102_ops_, table11_102_ops_,
    table11_102_ops_, table11_102_ops_, table11_110_ops_, table11_110_ops_,
    table11_110_ops_, table11_110_ops_, table11_110_ops_, table11_110_ops_,
    table11_116_ops_, table11_117_ops_, table11_117_ops_, table11_117_ops_,
    table11_117_ops_, table11_117_ops_, table11_117_ops_, table11_123_ops_,
    table11_123_ops_, table11_123_ops_, table11_126_ops_, table11_127_ops_,
};
}  // namespace geometry_13_15
}  // namespace grpc_core
