// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#include "test/cpp/microbenchmarks/huffman_geometries/decode_huff_8_16_6.h"

#include <grpc/support/port_platform.h>
namespace grpc_core {
namespace geometry_8_16_6 {
const uint8_t HuffDecoderCommon::table2_0_emit_[10] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74};
const uint8_t HuffDecoderCommon::table2_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table3_0_emit_[36] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20, 0x25,
    0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3d, 0x41,
    0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70, 0x72, 0x75};
const uint8_t HuffDecoderCommon::table3_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x29, 0x2d,
    0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59,
    0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85,
    0x89, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table4_0_emit_[22] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20,
    0x25, 0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table4_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00,
    0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x25, 0x00, 0x29, 0x00, 0x2d,
    0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41, 0x00,
    0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table4_1_emit_[46] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70,
    0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a,
    0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
    0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table4_1_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49,
    0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75,
    0x79, 0x7d, 0x81, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1,
    0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table4_emit_[2] = {
    table4_0_emit_,
    table4_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table4_ops_[2] = {
    table4_0_ops_,
    table4_1_ops_,
};
const uint8_t HuffDecoderCommon::table1_0_emit_[74] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20,
    0x25, 0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e,
    0x70, 0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78,
    0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint16_t HuffDecoderCommon::table1_0_inner_[76] = {
    0x0005, 0x0045, 0x0085, 0x00c5, 0x0105, 0x0145, 0x0185, 0x01c5, 0x0205,
    0x0245, 0x0286, 0x02c6, 0x0306, 0x0346, 0x0386, 0x03c6, 0x0406, 0x0446,
    0x0486, 0x04c6, 0x0506, 0x0546, 0x0586, 0x05c6, 0x0606, 0x0646, 0x0686,
    0x06c6, 0x0706, 0x0746, 0x0786, 0x07c6, 0x0806, 0x0846, 0x0886, 0x08c6,
    0x0907, 0x0947, 0x0987, 0x09c7, 0x0a07, 0x0a47, 0x0a87, 0x0ac7, 0x0b07,
    0x0b47, 0x0b87, 0x0bc7, 0x0c07, 0x0c47, 0x0c87, 0x0cc7, 0x0d07, 0x0d47,
    0x0d87, 0x0dc7, 0x0e07, 0x0e47, 0x0e87, 0x0ec7, 0x0f07, 0x0f47, 0x0f87,
    0x0fc7, 0x1007, 0x1047, 0x1087, 0x10c7, 0x1108, 0x1148, 0x1188, 0x11c8,
    0x1208, 0x1248, 0x0018, 0x0028};
const uint8_t HuffDecoderCommon::table1_0_outer_[256] = {
    0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,
    2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  4,  4,  4,  4,  4,  4,
    4,  4,  5,  5,  5,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  6,  6,  6,  7,
    7,  7,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  9,  9,  9,  9,
    9,  9,  9,  9,  10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13,
    13, 14, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18,
    18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 22, 23,
    23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 27,
    28, 28, 28, 28, 29, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31, 31, 32, 32, 32,
    32, 33, 33, 33, 33, 34, 34, 34, 34, 35, 35, 35, 35, 36, 36, 37, 37, 38, 38,
    39, 39, 40, 40, 41, 41, 42, 42, 43, 43, 44, 44, 45, 45, 46, 46, 47, 47, 48,
    48, 49, 49, 50, 50, 51, 51, 52, 52, 53, 53, 54, 54, 55, 55, 56, 56, 57, 57,
    58, 58, 59, 59, 60, 60, 61, 61, 62, 62, 63, 63, 64, 64, 65, 65, 66, 66, 67,
    67, 68, 69, 70, 71, 72, 73, 74, 75};
const uint8_t HuffDecoderCommon::table8_0_inner_[6] = {0x00, 0x01, 0x05,
                                                       0x09, 0x0d, 0x02};
const uint8_t HuffDecoderCommon::table8_0_outer_[8] = {0, 1, 2, 3, 4, 0, 0, 5};
const uint8_t HuffDecoderCommon::table9_0_emit_[6] = {0x3f, 0x27, 0x2b,
                                                      0x7c, 0x23, 0x3e};
const uint8_t HuffDecoderCommon::table9_0_inner_[8] = {0x00, 0x01, 0x05, 0x09,
                                                       0x0d, 0x11, 0x15, 0x02};
const uint8_t HuffDecoderCommon::table9_0_outer_[16] = {0, 0, 0, 1, 0, 2, 0, 3,
                                                        0, 4, 5, 6, 0, 0, 0, 7};
const uint8_t HuffDecoderCommon::table10_0_emit_[12] = {
    0x3f, 0x27, 0x2b, 0x7c, 0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e};
const uint8_t HuffDecoderCommon::table10_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x05, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x11,
    0x00, 0x15, 0x19, 0x1d, 0x21, 0x25, 0x29, 0x2d, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table11_0_emit_[14] = {
    0x3f, 0x27, 0x2b, 0x7c, 0x23, 0x3e, 0x00,
    0x24, 0x40, 0x5b, 0x5d, 0x7e, 0x5e, 0x7d};
const uint8_t HuffDecoderCommon::table11_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11,
    0x00, 0x00, 0x00, 0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00,
    0x25, 0x00, 0x29, 0x00, 0x2d, 0x31, 0x35, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table12_0_emit_[36] = {
    0x3f, 0x30, 0x3f, 0x31, 0x3f, 0x32, 0x3f, 0x61, 0x3f, 0x63, 0x3f, 0x65,
    0x3f, 0x69, 0x3f, 0x6f, 0x3f, 0x73, 0x3f, 0x74, 0x27, 0x2b, 0x7c, 0x23,
    0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e, 0x5e, 0x7d, 0x3c, 0x60, 0x7b};
const uint8_t HuffDecoderCommon::table12_0_ops_[128] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x56, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5a, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x5e, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x62,
    0x01, 0x01, 0x01, 0x66, 0x01, 0x01, 0x01, 0x6a, 0x01, 0x01, 0x01, 0x6e,
    0x01, 0x01, 0x01, 0x72, 0x01, 0x01, 0x01, 0x76, 0x01, 0x01, 0x01, 0x7a,
    0x01, 0x7e, 0x01, 0x82, 0x86, 0x8a, 0x8e, 0x03};
const uint8_t HuffDecoderCommon::table13_0_emit_[44] = {
    0x3f, 0x30, 0x3f, 0x31, 0x3f, 0x32, 0x3f, 0x61, 0x3f, 0x63, 0x3f,
    0x65, 0x3f, 0x69, 0x3f, 0x6f, 0x3f, 0x73, 0x3f, 0x74, 0x3f, 0x20,
    0x3f, 0x25, 0x3f, 0x2d, 0x3f, 0x2e, 0x3f, 0x2f, 0x3f, 0x33, 0x3f,
    0x34, 0x3f, 0x35, 0x3f, 0x36, 0x3f, 0x37, 0x3f, 0x38, 0x3f, 0x39};
const uint8_t HuffDecoderCommon::table13_0_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0xa1, 0xa9};
const uint8_t HuffDecoderCommon::table13_1_emit_[28] = {
    0x3f, 0x3d, 0x3f, 0x41, 0x3f, 0x5f, 0x3f, 0x62, 0x3f, 0x64,
    0x3f, 0x66, 0x3f, 0x67, 0x3f, 0x68, 0x3f, 0x6c, 0x3f, 0x6d,
    0x3f, 0x6e, 0x3f, 0x70, 0x3f, 0x72, 0x3f, 0x75};
const uint8_t HuffDecoderCommon::table13_1_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x61, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table13_2_emit_[20] = {
    0x27, 0x30, 0x27, 0x31, 0x27, 0x32, 0x27, 0x61, 0x27, 0x63,
    0x27, 0x65, 0x27, 0x69, 0x27, 0x6f, 0x27, 0x73, 0x27, 0x74};
const uint8_t HuffDecoderCommon::table13_2_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table13_3_emit_[20] = {
    0x2b, 0x30, 0x2b, 0x31, 0x2b, 0x32, 0x2b, 0x61, 0x2b, 0x63,
    0x2b, 0x65, 0x2b, 0x69, 0x2b, 0x6f, 0x2b, 0x73, 0x2b, 0x74};
const uint8_t HuffDecoderCommon::table13_4_emit_[20] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61, 0x7c, 0x63,
    0x7c, 0x65, 0x7c, 0x69, 0x7c, 0x6f, 0x7c, 0x73, 0x7c, 0x74};
const uint8_t HuffDecoderCommon::table13_5_emit_[2] = {0x23, 0x3e};
const uint8_t HuffDecoderCommon::table13_5_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06};
const uint8_t HuffDecoderCommon::table13_6_emit_[4] = {0x00, 0x24, 0x40, 0x5b};
const uint8_t HuffDecoderCommon::table13_6_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e};
const uint8_t HuffDecoderCommon::table13_7_emit_[7] = {0x5d, 0x7e, 0x5e, 0x7d,
                                                       0x3c, 0x60, 0x7b};
const uint8_t HuffDecoderCommon::table13_7_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00,
    0x00, 0x0e, 0x00, 0x12, 0x00, 0x16, 0x00, 0x1a, 0x00, 0x03};
const uint8_t* const HuffDecoderCommon::table13_emit_[8] = {
    table13_0_emit_, table13_1_emit_, table13_2_emit_, table13_3_emit_,
    table13_4_emit_, table13_5_emit_, table13_6_emit_, table13_7_emit_,
};
const uint8_t* const HuffDecoderCommon::table13_ops_[8] = {
    table13_0_ops_, table13_1_ops_, table13_2_ops_, table13_2_ops_,
    table13_2_ops_, table13_5_ops_, table13_6_ops_, table13_7_ops_,
};
const uint8_t HuffDecoderCommon::table14_0_emit_[16] = {
    0x3f, 0x30, 0x3f, 0x31, 0x3f, 0x32, 0x3f, 0x61,
    0x3f, 0x63, 0x3f, 0x65, 0x3f, 0x69, 0x3f, 0x6f};
const uint8_t HuffDecoderCommon::table14_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00,
    0x00, 0x29, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x39};
const uint8_t HuffDecoderCommon::table14_1_emit_[28] = {
    0x3f, 0x73, 0x3f, 0x74, 0x3f, 0x20, 0x3f, 0x25, 0x3f, 0x2d,
    0x3f, 0x2e, 0x3f, 0x2f, 0x3f, 0x33, 0x3f, 0x34, 0x3f, 0x35,
    0x3f, 0x36, 0x3f, 0x37, 0x3f, 0x38, 0x3f, 0x39};
const uint8_t HuffDecoderCommon::table14_1_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x11, 0x00,
    0x19, 0x00, 0x21, 0x00, 0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41,
    0x00, 0x49, 0x00, 0x51, 0x00, 0x59, 0x00, 0x61, 0x00, 0x69};
const uint8_t HuffDecoderCommon::table14_2_emit_[36] = {
    0x3f, 0x3d, 0x3f, 0x41, 0x3f, 0x5f, 0x3f, 0x62, 0x3f, 0x64, 0x3f, 0x66,
    0x3f, 0x67, 0x3f, 0x68, 0x3f, 0x6c, 0x3f, 0x6d, 0x3f, 0x6e, 0x3f, 0x70,
    0x3f, 0x72, 0x3f, 0x75, 0x3f, 0x3a, 0x3f, 0x42, 0x3f, 0x43, 0x3f, 0x44};
const uint8_t HuffDecoderCommon::table14_2_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x00, 0x51,
    0x00, 0x59, 0x00, 0x61, 0x00, 0x69, 0x71, 0x79, 0x81, 0x89};
const uint8_t HuffDecoderCommon::table14_3_emit_[56] = {
    0x3f, 0x45, 0x3f, 0x46, 0x3f, 0x47, 0x3f, 0x48, 0x3f, 0x49, 0x3f, 0x4a,
    0x3f, 0x4b, 0x3f, 0x4c, 0x3f, 0x4d, 0x3f, 0x4e, 0x3f, 0x4f, 0x3f, 0x50,
    0x3f, 0x51, 0x3f, 0x52, 0x3f, 0x53, 0x3f, 0x54, 0x3f, 0x55, 0x3f, 0x56,
    0x3f, 0x57, 0x3f, 0x59, 0x3f, 0x6a, 0x3f, 0x6b, 0x3f, 0x71, 0x3f, 0x76,
    0x3f, 0x77, 0x3f, 0x78, 0x3f, 0x79, 0x3f, 0x7a};
const uint8_t HuffDecoderCommon::table14_3_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0xa1, 0xa9,
    0xb1, 0xb9, 0xc1, 0xc9, 0xd1, 0xd9, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table14_4_emit_[44] = {
    0x27, 0x30, 0x27, 0x31, 0x27, 0x32, 0x27, 0x61, 0x27, 0x63, 0x27,
    0x65, 0x27, 0x69, 0x27, 0x6f, 0x27, 0x73, 0x27, 0x74, 0x27, 0x20,
    0x27, 0x25, 0x27, 0x2d, 0x27, 0x2e, 0x27, 0x2f, 0x27, 0x33, 0x27,
    0x34, 0x27, 0x35, 0x27, 0x36, 0x27, 0x37, 0x27, 0x38, 0x27, 0x39};
const uint8_t HuffDecoderCommon::table14_5_emit_[28] = {
    0x27, 0x3d, 0x27, 0x41, 0x27, 0x5f, 0x27, 0x62, 0x27, 0x64,
    0x27, 0x66, 0x27, 0x67, 0x27, 0x68, 0x27, 0x6c, 0x27, 0x6d,
    0x27, 0x6e, 0x27, 0x70, 0x27, 0x72, 0x27, 0x75};
const uint8_t HuffDecoderCommon::table14_6_emit_[44] = {
    0x2b, 0x30, 0x2b, 0x31, 0x2b, 0x32, 0x2b, 0x61, 0x2b, 0x63, 0x2b,
    0x65, 0x2b, 0x69, 0x2b, 0x6f, 0x2b, 0x73, 0x2b, 0x74, 0x2b, 0x20,
    0x2b, 0x25, 0x2b, 0x2d, 0x2b, 0x2e, 0x2b, 0x2f, 0x2b, 0x33, 0x2b,
    0x34, 0x2b, 0x35, 0x2b, 0x36, 0x2b, 0x37, 0x2b, 0x38, 0x2b, 0x39};
const uint8_t HuffDecoderCommon::table14_7_emit_[28] = {
    0x2b, 0x3d, 0x2b, 0x41, 0x2b, 0x5f, 0x2b, 0x62, 0x2b, 0x64,
    0x2b, 0x66, 0x2b, 0x67, 0x2b, 0x68, 0x2b, 0x6c, 0x2b, 0x6d,
    0x2b, 0x6e, 0x2b, 0x70, 0x2b, 0x72, 0x2b, 0x75};
const uint8_t HuffDecoderCommon::table14_8_emit_[44] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61, 0x7c, 0x63, 0x7c,
    0x65, 0x7c, 0x69, 0x7c, 0x6f, 0x7c, 0x73, 0x7c, 0x74, 0x7c, 0x20,
    0x7c, 0x25, 0x7c, 0x2d, 0x7c, 0x2e, 0x7c, 0x2f, 0x7c, 0x33, 0x7c,
    0x34, 0x7c, 0x35, 0x7c, 0x36, 0x7c, 0x37, 0x7c, 0x38, 0x7c, 0x39};
const uint8_t HuffDecoderCommon::table14_9_emit_[28] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64,
    0x7c, 0x66, 0x7c, 0x67, 0x7c, 0x68, 0x7c, 0x6c, 0x7c, 0x6d,
    0x7c, 0x6e, 0x7c, 0x70, 0x7c, 0x72, 0x7c, 0x75};
const uint8_t HuffDecoderCommon::table14_10_emit_[20] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63,
    0x23, 0x65, 0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74};
const uint8_t HuffDecoderCommon::table14_11_emit_[20] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63,
    0x3e, 0x65, 0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74};
const uint8_t HuffDecoderCommon::table14_12_emit_[2] = {0x00, 0x24};
const uint8_t HuffDecoderCommon::table14_13_emit_[2] = {0x40, 0x5b};
const uint8_t HuffDecoderCommon::table14_14_emit_[2] = {0x5d, 0x7e};
const uint8_t HuffDecoderCommon::table14_15_emit_[5] = {0x5e, 0x7d, 0x3c, 0x60,
                                                        0x7b};
const uint8_t HuffDecoderCommon::table14_15_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00,
    0x00, 0x0e, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x03};
const uint8_t* const HuffDecoderCommon::table14_emit_[16] = {
    table14_0_emit_,  table14_1_emit_,  table14_2_emit_,  table14_3_emit_,
    table14_4_emit_,  table14_5_emit_,  table14_6_emit_,  table14_7_emit_,
    table14_8_emit_,  table14_9_emit_,  table14_10_emit_, table14_11_emit_,
    table14_12_emit_, table14_13_emit_, table14_14_emit_, table14_15_emit_,
};
const uint8_t* const HuffDecoderCommon::table14_ops_[16] = {
    table14_0_ops_, table14_1_ops_, table14_2_ops_, table14_3_ops_,
    table13_0_ops_, table13_1_ops_, table13_0_ops_, table13_1_ops_,
    table13_0_ops_, table13_1_ops_, table13_2_ops_, table13_2_ops_,
    table13_5_ops_, table13_5_ops_, table13_5_ops_, table14_15_ops_,
};
const uint16_t HuffDecoderCommon::table15_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0031,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0039};
const uint16_t HuffDecoderCommon::table15_1_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069};
const uint16_t HuffDecoderCommon::table15_2_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089};
const uint8_t HuffDecoderCommon::table15_3_emit_[68] = {
    0x3f, 0x45, 0x3f, 0x46, 0x3f, 0x47, 0x3f, 0x48, 0x3f, 0x49, 0x3f, 0x4a,
    0x3f, 0x4b, 0x3f, 0x4c, 0x3f, 0x4d, 0x3f, 0x4e, 0x3f, 0x4f, 0x3f, 0x50,
    0x3f, 0x51, 0x3f, 0x52, 0x3f, 0x53, 0x3f, 0x54, 0x3f, 0x55, 0x3f, 0x56,
    0x3f, 0x57, 0x3f, 0x59, 0x3f, 0x6a, 0x3f, 0x6b, 0x3f, 0x71, 0x3f, 0x76,
    0x3f, 0x77, 0x3f, 0x78, 0x3f, 0x79, 0x3f, 0x7a, 0x3f, 0x26, 0x3f, 0x2a,
    0x3f, 0x2c, 0x3f, 0x3b, 0x3f, 0x58, 0x3f, 0x5a};
const uint16_t HuffDecoderCommon::table15_3_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079,
    0x0000, 0x0081, 0x0000, 0x0089, 0x0000, 0x0091, 0x0000, 0x0099,
    0x0000, 0x00a1, 0x0000, 0x00a9, 0x0000, 0x00b1, 0x0000, 0x00b9,
    0x0000, 0x00c1, 0x0000, 0x00c9, 0x0000, 0x00d1, 0x0000, 0x00d9,
    0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109, 0x0000, 0x0002};
const uint16_t HuffDecoderCommon::table15_4_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0051, 0x0000, 0x0059, 0x0000, 0x0061, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089,
    0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000, 0x00a9};
const uint8_t HuffDecoderCommon::table15_5_emit_[92] = {
    0x27, 0x3d, 0x27, 0x41, 0x27, 0x5f, 0x27, 0x62, 0x27, 0x64, 0x27, 0x66,
    0x27, 0x67, 0x27, 0x68, 0x27, 0x6c, 0x27, 0x6d, 0x27, 0x6e, 0x27, 0x70,
    0x27, 0x72, 0x27, 0x75, 0x27, 0x3a, 0x27, 0x42, 0x27, 0x43, 0x27, 0x44,
    0x27, 0x45, 0x27, 0x46, 0x27, 0x47, 0x27, 0x48, 0x27, 0x49, 0x27, 0x4a,
    0x27, 0x4b, 0x27, 0x4c, 0x27, 0x4d, 0x27, 0x4e, 0x27, 0x4f, 0x27, 0x50,
    0x27, 0x51, 0x27, 0x52, 0x27, 0x53, 0x27, 0x54, 0x27, 0x55, 0x27, 0x56,
    0x27, 0x57, 0x27, 0x59, 0x27, 0x6a, 0x27, 0x6b, 0x27, 0x71, 0x27, 0x76,
    0x27, 0x77, 0x27, 0x78, 0x27, 0x79, 0x27, 0x7a};
const uint16_t HuffDecoderCommon::table15_5_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9,
    0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109,
    0x0111, 0x0119, 0x0121, 0x0129, 0x0131, 0x0139, 0x0141, 0x0149,
    0x0151, 0x0159, 0x0161, 0x0169, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table15_7_emit_[92] = {
    0x2b, 0x3d, 0x2b, 0x41, 0x2b, 0x5f, 0x2b, 0x62, 0x2b, 0x64, 0x2b, 0x66,
    0x2b, 0x67, 0x2b, 0x68, 0x2b, 0x6c, 0x2b, 0x6d, 0x2b, 0x6e, 0x2b, 0x70,
    0x2b, 0x72, 0x2b, 0x75, 0x2b, 0x3a, 0x2b, 0x42, 0x2b, 0x43, 0x2b, 0x44,
    0x2b, 0x45, 0x2b, 0x46, 0x2b, 0x47, 0x2b, 0x48, 0x2b, 0x49, 0x2b, 0x4a,
    0x2b, 0x4b, 0x2b, 0x4c, 0x2b, 0x4d, 0x2b, 0x4e, 0x2b, 0x4f, 0x2b, 0x50,
    0x2b, 0x51, 0x2b, 0x52, 0x2b, 0x53, 0x2b, 0x54, 0x2b, 0x55, 0x2b, 0x56,
    0x2b, 0x57, 0x2b, 0x59, 0x2b, 0x6a, 0x2b, 0x6b, 0x2b, 0x71, 0x2b, 0x76,
    0x2b, 0x77, 0x2b, 0x78, 0x2b, 0x79, 0x2b, 0x7a};
const uint8_t HuffDecoderCommon::table15_9_emit_[92] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64, 0x7c, 0x66,
    0x7c, 0x67, 0x7c, 0x68, 0x7c, 0x6c, 0x7c, 0x6d, 0x7c, 0x6e, 0x7c, 0x70,
    0x7c, 0x72, 0x7c, 0x75, 0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44,
    0x7c, 0x45, 0x7c, 0x46, 0x7c, 0x47, 0x7c, 0x48, 0x7c, 0x49, 0x7c, 0x4a,
    0x7c, 0x4b, 0x7c, 0x4c, 0x7c, 0x4d, 0x7c, 0x4e, 0x7c, 0x4f, 0x7c, 0x50,
    0x7c, 0x51, 0x7c, 0x52, 0x7c, 0x53, 0x7c, 0x54, 0x7c, 0x55, 0x7c, 0x56,
    0x7c, 0x57, 0x7c, 0x59, 0x7c, 0x6a, 0x7c, 0x6b, 0x7c, 0x71, 0x7c, 0x76,
    0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a};
const uint8_t HuffDecoderCommon::table15_10_emit_[72] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63, 0x23, 0x65,
    0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74, 0x23, 0x20, 0x23, 0x25,
    0x23, 0x2d, 0x23, 0x2e, 0x23, 0x2f, 0x23, 0x33, 0x23, 0x34, 0x23, 0x35,
    0x23, 0x36, 0x23, 0x37, 0x23, 0x38, 0x23, 0x39, 0x23, 0x3d, 0x23, 0x41,
    0x23, 0x5f, 0x23, 0x62, 0x23, 0x64, 0x23, 0x66, 0x23, 0x67, 0x23, 0x68,
    0x23, 0x6c, 0x23, 0x6d, 0x23, 0x6e, 0x23, 0x70, 0x23, 0x72, 0x23, 0x75};
const uint16_t HuffDecoderCommon::table15_10_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9,
    0x00b1, 0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9,
    0x00f1, 0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table15_11_emit_[72] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63, 0x3e, 0x65,
    0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74, 0x3e, 0x20, 0x3e, 0x25,
    0x3e, 0x2d, 0x3e, 0x2e, 0x3e, 0x2f, 0x3e, 0x33, 0x3e, 0x34, 0x3e, 0x35,
    0x3e, 0x36, 0x3e, 0x37, 0x3e, 0x38, 0x3e, 0x39, 0x3e, 0x3d, 0x3e, 0x41,
    0x3e, 0x5f, 0x3e, 0x62, 0x3e, 0x64, 0x3e, 0x66, 0x3e, 0x67, 0x3e, 0x68,
    0x3e, 0x6c, 0x3e, 0x6d, 0x3e, 0x6e, 0x3e, 0x70, 0x3e, 0x72, 0x3e, 0x75};
const uint8_t HuffDecoderCommon::table15_12_emit_[40] = {
    0x00, 0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x61, 0x00, 0x63,
    0x00, 0x65, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x74,
    0x24, 0x30, 0x24, 0x31, 0x24, 0x32, 0x24, 0x61, 0x24, 0x63,
    0x24, 0x65, 0x24, 0x69, 0x24, 0x6f, 0x24, 0x73, 0x24, 0x74};
const uint16_t HuffDecoderCommon::table15_12_ops_[64] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0051, 0x0059, 0x0061, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052};
const uint8_t HuffDecoderCommon::table15_13_emit_[40] = {
    0x40, 0x30, 0x40, 0x31, 0x40, 0x32, 0x40, 0x61, 0x40, 0x63,
    0x40, 0x65, 0x40, 0x69, 0x40, 0x6f, 0x40, 0x73, 0x40, 0x74,
    0x5b, 0x30, 0x5b, 0x31, 0x5b, 0x32, 0x5b, 0x61, 0x5b, 0x63,
    0x5b, 0x65, 0x5b, 0x69, 0x5b, 0x6f, 0x5b, 0x73, 0x5b, 0x74};
const uint8_t HuffDecoderCommon::table15_14_emit_[40] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63,
    0x5d, 0x65, 0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74,
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63,
    0x7e, 0x65, 0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74};
const uint16_t HuffDecoderCommon::table15_15_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table15_emit_[16] = {
    table14_0_emit_,  table14_1_emit_,  table14_2_emit_,  table15_3_emit_,
    table14_4_emit_,  table15_5_emit_,  table14_6_emit_,  table15_7_emit_,
    table14_8_emit_,  table15_9_emit_,  table15_10_emit_, table15_11_emit_,
    table15_12_emit_, table15_13_emit_, table15_14_emit_, table14_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table15_ops_[16] = {
    table15_0_ops_,  table15_1_ops_,  table15_2_ops_,  table15_3_ops_,
    table15_4_ops_,  table15_5_ops_,  table15_4_ops_,  table15_5_ops_,
    table15_4_ops_,  table15_5_ops_,  table15_10_ops_, table15_10_ops_,
    table15_12_ops_, table15_12_ops_, table15_12_ops_, table15_15_ops_,
};
const uint8_t HuffDecoderCommon::table16_0_emit_[8] = {0x3f, 0x30, 0x3f, 0x31,
                                                       0x3f, 0x32, 0x3f, 0x61};
const uint16_t HuffDecoderCommon::table16_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019};
const uint8_t HuffDecoderCommon::table16_1_emit_[8] = {0x3f, 0x63, 0x3f, 0x65,
                                                       0x3f, 0x69, 0x3f, 0x6f};
const uint8_t HuffDecoderCommon::table16_2_emit_[12] = {
    0x3f, 0x73, 0x3f, 0x74, 0x3f, 0x20, 0x3f, 0x25, 0x3f, 0x2d, 0x3f, 0x2e};
const uint16_t HuffDecoderCommon::table16_2_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029};
const uint8_t HuffDecoderCommon::table16_3_emit_[16] = {
    0x3f, 0x2f, 0x3f, 0x33, 0x3f, 0x34, 0x3f, 0x35,
    0x3f, 0x36, 0x3f, 0x37, 0x3f, 0x38, 0x3f, 0x39};
const uint8_t HuffDecoderCommon::table16_4_emit_[16] = {
    0x3f, 0x3d, 0x3f, 0x41, 0x3f, 0x5f, 0x3f, 0x62,
    0x3f, 0x64, 0x3f, 0x66, 0x3f, 0x67, 0x3f, 0x68};
const uint8_t HuffDecoderCommon::table16_5_emit_[20] = {
    0x3f, 0x6c, 0x3f, 0x6d, 0x3f, 0x6e, 0x3f, 0x70, 0x3f, 0x72,
    0x3f, 0x75, 0x3f, 0x3a, 0x3f, 0x42, 0x3f, 0x43, 0x3f, 0x44};
const uint16_t HuffDecoderCommon::table16_5_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049};
const uint8_t HuffDecoderCommon::table16_6_emit_[32] = {
    0x3f, 0x45, 0x3f, 0x46, 0x3f, 0x47, 0x3f, 0x48, 0x3f, 0x49, 0x3f,
    0x4a, 0x3f, 0x4b, 0x3f, 0x4c, 0x3f, 0x4d, 0x3f, 0x4e, 0x3f, 0x4f,
    0x3f, 0x50, 0x3f, 0x51, 0x3f, 0x52, 0x3f, 0x53, 0x3f, 0x54};
const uint16_t HuffDecoderCommon::table16_6_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069,
    0x0000, 0x0000, 0x0000, 0x0071, 0x0000, 0x0000, 0x0000, 0x0079};
const uint8_t HuffDecoderCommon::table16_7_emit_[36] = {
    0x3f, 0x55, 0x3f, 0x56, 0x3f, 0x57, 0x3f, 0x59, 0x3f, 0x6a, 0x3f, 0x6b,
    0x3f, 0x71, 0x3f, 0x76, 0x3f, 0x77, 0x3f, 0x78, 0x3f, 0x79, 0x3f, 0x7a,
    0x3f, 0x26, 0x3f, 0x2a, 0x3f, 0x2c, 0x3f, 0x3b, 0x3f, 0x58, 0x3f, 0x5a};
const uint16_t HuffDecoderCommon::table16_7_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079,
    0x0000, 0x0081, 0x0000, 0x0089, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table16_8_emit_[16] = {
    0x27, 0x30, 0x27, 0x31, 0x27, 0x32, 0x27, 0x61,
    0x27, 0x63, 0x27, 0x65, 0x27, 0x69, 0x27, 0x6f};
const uint8_t HuffDecoderCommon::table16_9_emit_[28] = {
    0x27, 0x73, 0x27, 0x74, 0x27, 0x20, 0x27, 0x25, 0x27, 0x2d,
    0x27, 0x2e, 0x27, 0x2f, 0x27, 0x33, 0x27, 0x34, 0x27, 0x35,
    0x27, 0x36, 0x27, 0x37, 0x27, 0x38, 0x27, 0x39};
const uint8_t HuffDecoderCommon::table16_10_emit_[36] = {
    0x27, 0x3d, 0x27, 0x41, 0x27, 0x5f, 0x27, 0x62, 0x27, 0x64, 0x27, 0x66,
    0x27, 0x67, 0x27, 0x68, 0x27, 0x6c, 0x27, 0x6d, 0x27, 0x6e, 0x27, 0x70,
    0x27, 0x72, 0x27, 0x75, 0x27, 0x3a, 0x27, 0x42, 0x27, 0x43, 0x27, 0x44};
const uint8_t HuffDecoderCommon::table16_11_emit_[68] = {
    0x27, 0x45, 0x27, 0x46, 0x27, 0x47, 0x27, 0x48, 0x27, 0x49, 0x27, 0x4a,
    0x27, 0x4b, 0x27, 0x4c, 0x27, 0x4d, 0x27, 0x4e, 0x27, 0x4f, 0x27, 0x50,
    0x27, 0x51, 0x27, 0x52, 0x27, 0x53, 0x27, 0x54, 0x27, 0x55, 0x27, 0x56,
    0x27, 0x57, 0x27, 0x59, 0x27, 0x6a, 0x27, 0x6b, 0x27, 0x71, 0x27, 0x76,
    0x27, 0x77, 0x27, 0x78, 0x27, 0x79, 0x27, 0x7a, 0x27, 0x26, 0x27, 0x2a,
    0x27, 0x2c, 0x27, 0x3b, 0x27, 0x58, 0x27, 0x5a};
const uint8_t HuffDecoderCommon::table16_12_emit_[16] = {
    0x2b, 0x30, 0x2b, 0x31, 0x2b, 0x32, 0x2b, 0x61,
    0x2b, 0x63, 0x2b, 0x65, 0x2b, 0x69, 0x2b, 0x6f};
const uint8_t HuffDecoderCommon::table16_13_emit_[28] = {
    0x2b, 0x73, 0x2b, 0x74, 0x2b, 0x20, 0x2b, 0x25, 0x2b, 0x2d,
    0x2b, 0x2e, 0x2b, 0x2f, 0x2b, 0x33, 0x2b, 0x34, 0x2b, 0x35,
    0x2b, 0x36, 0x2b, 0x37, 0x2b, 0x38, 0x2b, 0x39};
const uint8_t HuffDecoderCommon::table16_14_emit_[36] = {
    0x2b, 0x3d, 0x2b, 0x41, 0x2b, 0x5f, 0x2b, 0x62, 0x2b, 0x64, 0x2b, 0x66,
    0x2b, 0x67, 0x2b, 0x68, 0x2b, 0x6c, 0x2b, 0x6d, 0x2b, 0x6e, 0x2b, 0x70,
    0x2b, 0x72, 0x2b, 0x75, 0x2b, 0x3a, 0x2b, 0x42, 0x2b, 0x43, 0x2b, 0x44};
const uint8_t HuffDecoderCommon::table16_15_emit_[68] = {
    0x2b, 0x45, 0x2b, 0x46, 0x2b, 0x47, 0x2b, 0x48, 0x2b, 0x49, 0x2b, 0x4a,
    0x2b, 0x4b, 0x2b, 0x4c, 0x2b, 0x4d, 0x2b, 0x4e, 0x2b, 0x4f, 0x2b, 0x50,
    0x2b, 0x51, 0x2b, 0x52, 0x2b, 0x53, 0x2b, 0x54, 0x2b, 0x55, 0x2b, 0x56,
    0x2b, 0x57, 0x2b, 0x59, 0x2b, 0x6a, 0x2b, 0x6b, 0x2b, 0x71, 0x2b, 0x76,
    0x2b, 0x77, 0x2b, 0x78, 0x2b, 0x79, 0x2b, 0x7a, 0x2b, 0x26, 0x2b, 0x2a,
    0x2b, 0x2c, 0x2b, 0x3b, 0x2b, 0x58, 0x2b, 0x5a};
const uint8_t HuffDecoderCommon::table16_16_emit_[16] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61,
    0x7c, 0x63, 0x7c, 0x65, 0x7c, 0x69, 0x7c, 0x6f};
const uint8_t HuffDecoderCommon::table16_17_emit_[28] = {
    0x7c, 0x73, 0x7c, 0x74, 0x7c, 0x20, 0x7c, 0x25, 0x7c, 0x2d,
    0x7c, 0x2e, 0x7c, 0x2f, 0x7c, 0x33, 0x7c, 0x34, 0x7c, 0x35,
    0x7c, 0x36, 0x7c, 0x37, 0x7c, 0x38, 0x7c, 0x39};
const uint8_t HuffDecoderCommon::table16_18_emit_[36] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64, 0x7c, 0x66,
    0x7c, 0x67, 0x7c, 0x68, 0x7c, 0x6c, 0x7c, 0x6d, 0x7c, 0x6e, 0x7c, 0x70,
    0x7c, 0x72, 0x7c, 0x75, 0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44};
const uint8_t HuffDecoderCommon::table16_19_emit_[68] = {
    0x7c, 0x45, 0x7c, 0x46, 0x7c, 0x47, 0x7c, 0x48, 0x7c, 0x49, 0x7c, 0x4a,
    0x7c, 0x4b, 0x7c, 0x4c, 0x7c, 0x4d, 0x7c, 0x4e, 0x7c, 0x4f, 0x7c, 0x50,
    0x7c, 0x51, 0x7c, 0x52, 0x7c, 0x53, 0x7c, 0x54, 0x7c, 0x55, 0x7c, 0x56,
    0x7c, 0x57, 0x7c, 0x59, 0x7c, 0x6a, 0x7c, 0x6b, 0x7c, 0x71, 0x7c, 0x76,
    0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a, 0x7c, 0x26, 0x7c, 0x2a,
    0x7c, 0x2c, 0x7c, 0x3b, 0x7c, 0x58, 0x7c, 0x5a};
const uint8_t HuffDecoderCommon::table16_20_emit_[44] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63, 0x23,
    0x65, 0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74, 0x23, 0x20,
    0x23, 0x25, 0x23, 0x2d, 0x23, 0x2e, 0x23, 0x2f, 0x23, 0x33, 0x23,
    0x34, 0x23, 0x35, 0x23, 0x36, 0x23, 0x37, 0x23, 0x38, 0x23, 0x39};
const uint8_t HuffDecoderCommon::table16_21_emit_[92] = {
    0x23, 0x3d, 0x23, 0x41, 0x23, 0x5f, 0x23, 0x62, 0x23, 0x64, 0x23, 0x66,
    0x23, 0x67, 0x23, 0x68, 0x23, 0x6c, 0x23, 0x6d, 0x23, 0x6e, 0x23, 0x70,
    0x23, 0x72, 0x23, 0x75, 0x23, 0x3a, 0x23, 0x42, 0x23, 0x43, 0x23, 0x44,
    0x23, 0x45, 0x23, 0x46, 0x23, 0x47, 0x23, 0x48, 0x23, 0x49, 0x23, 0x4a,
    0x23, 0x4b, 0x23, 0x4c, 0x23, 0x4d, 0x23, 0x4e, 0x23, 0x4f, 0x23, 0x50,
    0x23, 0x51, 0x23, 0x52, 0x23, 0x53, 0x23, 0x54, 0x23, 0x55, 0x23, 0x56,
    0x23, 0x57, 0x23, 0x59, 0x23, 0x6a, 0x23, 0x6b, 0x23, 0x71, 0x23, 0x76,
    0x23, 0x77, 0x23, 0x78, 0x23, 0x79, 0x23, 0x7a};
const uint8_t HuffDecoderCommon::table16_22_emit_[44] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63, 0x3e,
    0x65, 0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74, 0x3e, 0x20,
    0x3e, 0x25, 0x3e, 0x2d, 0x3e, 0x2e, 0x3e, 0x2f, 0x3e, 0x33, 0x3e,
    0x34, 0x3e, 0x35, 0x3e, 0x36, 0x3e, 0x37, 0x3e, 0x38, 0x3e, 0x39};
const uint8_t HuffDecoderCommon::table16_23_emit_[92] = {
    0x3e, 0x3d, 0x3e, 0x41, 0x3e, 0x5f, 0x3e, 0x62, 0x3e, 0x64, 0x3e, 0x66,
    0x3e, 0x67, 0x3e, 0x68, 0x3e, 0x6c, 0x3e, 0x6d, 0x3e, 0x6e, 0x3e, 0x70,
    0x3e, 0x72, 0x3e, 0x75, 0x3e, 0x3a, 0x3e, 0x42, 0x3e, 0x43, 0x3e, 0x44,
    0x3e, 0x45, 0x3e, 0x46, 0x3e, 0x47, 0x3e, 0x48, 0x3e, 0x49, 0x3e, 0x4a,
    0x3e, 0x4b, 0x3e, 0x4c, 0x3e, 0x4d, 0x3e, 0x4e, 0x3e, 0x4f, 0x3e, 0x50,
    0x3e, 0x51, 0x3e, 0x52, 0x3e, 0x53, 0x3e, 0x54, 0x3e, 0x55, 0x3e, 0x56,
    0x3e, 0x57, 0x3e, 0x59, 0x3e, 0x6a, 0x3e, 0x6b, 0x3e, 0x71, 0x3e, 0x76,
    0x3e, 0x77, 0x3e, 0x78, 0x3e, 0x79, 0x3e, 0x7a};
const uint8_t HuffDecoderCommon::table16_24_emit_[72] = {
    0x00, 0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x61, 0x00, 0x63, 0x00, 0x65,
    0x00, 0x69, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x74, 0x00, 0x20, 0x00, 0x25,
    0x00, 0x2d, 0x00, 0x2e, 0x00, 0x2f, 0x00, 0x33, 0x00, 0x34, 0x00, 0x35,
    0x00, 0x36, 0x00, 0x37, 0x00, 0x38, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41,
    0x00, 0x5f, 0x00, 0x62, 0x00, 0x64, 0x00, 0x66, 0x00, 0x67, 0x00, 0x68,
    0x00, 0x6c, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x70, 0x00, 0x72, 0x00, 0x75};
const uint8_t HuffDecoderCommon::table16_25_emit_[72] = {
    0x24, 0x30, 0x24, 0x31, 0x24, 0x32, 0x24, 0x61, 0x24, 0x63, 0x24, 0x65,
    0x24, 0x69, 0x24, 0x6f, 0x24, 0x73, 0x24, 0x74, 0x24, 0x20, 0x24, 0x25,
    0x24, 0x2d, 0x24, 0x2e, 0x24, 0x2f, 0x24, 0x33, 0x24, 0x34, 0x24, 0x35,
    0x24, 0x36, 0x24, 0x37, 0x24, 0x38, 0x24, 0x39, 0x24, 0x3d, 0x24, 0x41,
    0x24, 0x5f, 0x24, 0x62, 0x24, 0x64, 0x24, 0x66, 0x24, 0x67, 0x24, 0x68,
    0x24, 0x6c, 0x24, 0x6d, 0x24, 0x6e, 0x24, 0x70, 0x24, 0x72, 0x24, 0x75};
const uint8_t HuffDecoderCommon::table16_26_emit_[72] = {
    0x40, 0x30, 0x40, 0x31, 0x40, 0x32, 0x40, 0x61, 0x40, 0x63, 0x40, 0x65,
    0x40, 0x69, 0x40, 0x6f, 0x40, 0x73, 0x40, 0x74, 0x40, 0x20, 0x40, 0x25,
    0x40, 0x2d, 0x40, 0x2e, 0x40, 0x2f, 0x40, 0x33, 0x40, 0x34, 0x40, 0x35,
    0x40, 0x36, 0x40, 0x37, 0x40, 0x38, 0x40, 0x39, 0x40, 0x3d, 0x40, 0x41,
    0x40, 0x5f, 0x40, 0x62, 0x40, 0x64, 0x40, 0x66, 0x40, 0x67, 0x40, 0x68,
    0x40, 0x6c, 0x40, 0x6d, 0x40, 0x6e, 0x40, 0x70, 0x40, 0x72, 0x40, 0x75};
const uint8_t HuffDecoderCommon::table16_27_emit_[72] = {
    0x5b, 0x30, 0x5b, 0x31, 0x5b, 0x32, 0x5b, 0x61, 0x5b, 0x63, 0x5b, 0x65,
    0x5b, 0x69, 0x5b, 0x6f, 0x5b, 0x73, 0x5b, 0x74, 0x5b, 0x20, 0x5b, 0x25,
    0x5b, 0x2d, 0x5b, 0x2e, 0x5b, 0x2f, 0x5b, 0x33, 0x5b, 0x34, 0x5b, 0x35,
    0x5b, 0x36, 0x5b, 0x37, 0x5b, 0x38, 0x5b, 0x39, 0x5b, 0x3d, 0x5b, 0x41,
    0x5b, 0x5f, 0x5b, 0x62, 0x5b, 0x64, 0x5b, 0x66, 0x5b, 0x67, 0x5b, 0x68,
    0x5b, 0x6c, 0x5b, 0x6d, 0x5b, 0x6e, 0x5b, 0x70, 0x5b, 0x72, 0x5b, 0x75};
const uint8_t HuffDecoderCommon::table16_28_emit_[72] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63, 0x5d, 0x65,
    0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74, 0x5d, 0x20, 0x5d, 0x25,
    0x5d, 0x2d, 0x5d, 0x2e, 0x5d, 0x2f, 0x5d, 0x33, 0x5d, 0x34, 0x5d, 0x35,
    0x5d, 0x36, 0x5d, 0x37, 0x5d, 0x38, 0x5d, 0x39, 0x5d, 0x3d, 0x5d, 0x41,
    0x5d, 0x5f, 0x5d, 0x62, 0x5d, 0x64, 0x5d, 0x66, 0x5d, 0x67, 0x5d, 0x68,
    0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70, 0x5d, 0x72, 0x5d, 0x75};
const uint8_t HuffDecoderCommon::table16_29_emit_[72] = {
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63, 0x7e, 0x65,
    0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74, 0x7e, 0x20, 0x7e, 0x25,
    0x7e, 0x2d, 0x7e, 0x2e, 0x7e, 0x2f, 0x7e, 0x33, 0x7e, 0x34, 0x7e, 0x35,
    0x7e, 0x36, 0x7e, 0x37, 0x7e, 0x38, 0x7e, 0x39, 0x7e, 0x3d, 0x7e, 0x41,
    0x7e, 0x5f, 0x7e, 0x62, 0x7e, 0x64, 0x7e, 0x66, 0x7e, 0x67, 0x7e, 0x68,
    0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70, 0x7e, 0x72, 0x7e, 0x75};
const uint8_t HuffDecoderCommon::table16_30_emit_[40] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61, 0x5e, 0x63,
    0x5e, 0x65, 0x5e, 0x69, 0x5e, 0x6f, 0x5e, 0x73, 0x5e, 0x74,
    0x7d, 0x30, 0x7d, 0x31, 0x7d, 0x32, 0x7d, 0x61, 0x7d, 0x63,
    0x7d, 0x65, 0x7d, 0x69, 0x7d, 0x6f, 0x7d, 0x73, 0x7d, 0x74};
const uint8_t HuffDecoderCommon::table16_31_emit_[6] = {0x3c, 0x60, 0x7b,
                                                        0x5c, 0xc3, 0xd0};
const uint16_t HuffDecoderCommon::table16_31_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x000e, 0x0012, 0x0016, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table16_emit_[32] = {
    table16_0_emit_,  table16_1_emit_,  table16_2_emit_,  table16_3_emit_,
    table16_4_emit_,  table16_5_emit_,  table16_6_emit_,  table16_7_emit_,
    table16_8_emit_,  table16_9_emit_,  table16_10_emit_, table16_11_emit_,
    table16_12_emit_, table16_13_emit_, table16_14_emit_, table16_15_emit_,
    table16_16_emit_, table16_17_emit_, table16_18_emit_, table16_19_emit_,
    table16_20_emit_, table16_21_emit_, table16_22_emit_, table16_23_emit_,
    table16_24_emit_, table16_25_emit_, table16_26_emit_, table16_27_emit_,
    table16_28_emit_, table16_29_emit_, table16_30_emit_, table16_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table16_ops_[32] = {
    table16_0_ops_,  table16_0_ops_,  table16_2_ops_,  table15_0_ops_,
    table15_0_ops_,  table16_5_ops_,  table16_6_ops_,  table16_7_ops_,
    table15_0_ops_,  table15_1_ops_,  table15_2_ops_,  table15_3_ops_,
    table15_0_ops_,  table15_1_ops_,  table15_2_ops_,  table15_3_ops_,
    table15_0_ops_,  table15_1_ops_,  table15_2_ops_,  table15_3_ops_,
    table15_4_ops_,  table15_5_ops_,  table15_4_ops_,  table15_5_ops_,
    table15_10_ops_, table15_10_ops_, table15_10_ops_, table15_10_ops_,
    table15_10_ops_, table15_10_ops_, table15_12_ops_, table16_31_ops_,
};
const uint8_t HuffDecoderCommon::table17_0_emit_[60] = {
    0x3f, 0x30, 0x30, 0x3f, 0x30, 0x31, 0x3f, 0x30, 0x32, 0x3f, 0x30, 0x61,
    0x3f, 0x30, 0x63, 0x3f, 0x30, 0x65, 0x3f, 0x30, 0x69, 0x3f, 0x30, 0x6f,
    0x3f, 0x30, 0x73, 0x3f, 0x30, 0x74, 0x3f, 0x31, 0x30, 0x3f, 0x31, 0x31,
    0x3f, 0x31, 0x32, 0x3f, 0x31, 0x61, 0x3f, 0x31, 0x63, 0x3f, 0x31, 0x65,
    0x3f, 0x31, 0x69, 0x3f, 0x31, 0x6f, 0x3f, 0x31, 0x73, 0x3f, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table17_0_ops_[64] = {
    0x0000, 0x0018, 0x0030, 0x0048, 0x0060, 0x0078, 0x0090, 0x00a8,
    0x00c0, 0x00d8, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x00f0, 0x0108, 0x0120, 0x0138, 0x0150, 0x0168, 0x0180, 0x0198,
    0x01b0, 0x01c8, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x00f2};
const uint8_t HuffDecoderCommon::table17_1_emit_[60] = {
    0x3f, 0x32, 0x30, 0x3f, 0x32, 0x31, 0x3f, 0x32, 0x32, 0x3f, 0x32, 0x61,
    0x3f, 0x32, 0x63, 0x3f, 0x32, 0x65, 0x3f, 0x32, 0x69, 0x3f, 0x32, 0x6f,
    0x3f, 0x32, 0x73, 0x3f, 0x32, 0x74, 0x3f, 0x61, 0x30, 0x3f, 0x61, 0x31,
    0x3f, 0x61, 0x32, 0x3f, 0x61, 0x61, 0x3f, 0x61, 0x63, 0x3f, 0x61, 0x65,
    0x3f, 0x61, 0x69, 0x3f, 0x61, 0x6f, 0x3f, 0x61, 0x73, 0x3f, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table17_2_emit_[60] = {
    0x3f, 0x63, 0x30, 0x3f, 0x63, 0x31, 0x3f, 0x63, 0x32, 0x3f, 0x63, 0x61,
    0x3f, 0x63, 0x63, 0x3f, 0x63, 0x65, 0x3f, 0x63, 0x69, 0x3f, 0x63, 0x6f,
    0x3f, 0x63, 0x73, 0x3f, 0x63, 0x74, 0x3f, 0x65, 0x30, 0x3f, 0x65, 0x31,
    0x3f, 0x65, 0x32, 0x3f, 0x65, 0x61, 0x3f, 0x65, 0x63, 0x3f, 0x65, 0x65,
    0x3f, 0x65, 0x69, 0x3f, 0x65, 0x6f, 0x3f, 0x65, 0x73, 0x3f, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table17_3_emit_[60] = {
    0x3f, 0x69, 0x30, 0x3f, 0x69, 0x31, 0x3f, 0x69, 0x32, 0x3f, 0x69, 0x61,
    0x3f, 0x69, 0x63, 0x3f, 0x69, 0x65, 0x3f, 0x69, 0x69, 0x3f, 0x69, 0x6f,
    0x3f, 0x69, 0x73, 0x3f, 0x69, 0x74, 0x3f, 0x6f, 0x30, 0x3f, 0x6f, 0x31,
    0x3f, 0x6f, 0x32, 0x3f, 0x6f, 0x61, 0x3f, 0x6f, 0x63, 0x3f, 0x6f, 0x65,
    0x3f, 0x6f, 0x69, 0x3f, 0x6f, 0x6f, 0x3f, 0x6f, 0x73, 0x3f, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table17_4_emit_[60] = {
    0x3f, 0x73, 0x30, 0x3f, 0x73, 0x31, 0x3f, 0x73, 0x32, 0x3f, 0x73, 0x61,
    0x3f, 0x73, 0x63, 0x3f, 0x73, 0x65, 0x3f, 0x73, 0x69, 0x3f, 0x73, 0x6f,
    0x3f, 0x73, 0x73, 0x3f, 0x73, 0x74, 0x3f, 0x74, 0x30, 0x3f, 0x74, 0x31,
    0x3f, 0x74, 0x32, 0x3f, 0x74, 0x61, 0x3f, 0x74, 0x63, 0x3f, 0x74, 0x65,
    0x3f, 0x74, 0x69, 0x3f, 0x74, 0x6f, 0x3f, 0x74, 0x73, 0x3f, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table17_5_emit_[8] = {0x3f, 0x20, 0x3f, 0x25,
                                                       0x3f, 0x2d, 0x3f, 0x2e};
const uint16_t HuffDecoderCommon::table17_5_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032};
const uint8_t HuffDecoderCommon::table17_6_emit_[8] = {0x3f, 0x2f, 0x3f, 0x33,
                                                       0x3f, 0x34, 0x3f, 0x35};
const uint8_t HuffDecoderCommon::table17_7_emit_[8] = {0x3f, 0x36, 0x3f, 0x37,
                                                       0x3f, 0x38, 0x3f, 0x39};
const uint8_t HuffDecoderCommon::table17_8_emit_[8] = {0x3f, 0x3d, 0x3f, 0x41,
                                                       0x3f, 0x5f, 0x3f, 0x62};
const uint8_t HuffDecoderCommon::table17_9_emit_[8] = {0x3f, 0x64, 0x3f, 0x66,
                                                       0x3f, 0x67, 0x3f, 0x68};
const uint8_t HuffDecoderCommon::table17_10_emit_[8] = {0x3f, 0x6c, 0x3f, 0x6d,
                                                        0x3f, 0x6e, 0x3f, 0x70};
const uint8_t HuffDecoderCommon::table17_11_emit_[12] = {
    0x3f, 0x72, 0x3f, 0x75, 0x3f, 0x3a, 0x3f, 0x42, 0x3f, 0x43, 0x3f, 0x44};
const uint16_t HuffDecoderCommon::table17_11_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0042,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0052};
const uint8_t HuffDecoderCommon::table17_12_emit_[16] = {
    0x3f, 0x45, 0x3f, 0x46, 0x3f, 0x47, 0x3f, 0x48,
    0x3f, 0x49, 0x3f, 0x4a, 0x3f, 0x4b, 0x3f, 0x4c};
const uint16_t HuffDecoderCommon::table17_12_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0042,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0062,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0072};
const uint8_t HuffDecoderCommon::table17_13_emit_[16] = {
    0x3f, 0x4d, 0x3f, 0x4e, 0x3f, 0x4f, 0x3f, 0x50,
    0x3f, 0x51, 0x3f, 0x52, 0x3f, 0x53, 0x3f, 0x54};
const uint8_t HuffDecoderCommon::table17_14_emit_[16] = {
    0x3f, 0x55, 0x3f, 0x56, 0x3f, 0x57, 0x3f, 0x59,
    0x3f, 0x6a, 0x3f, 0x6b, 0x3f, 0x71, 0x3f, 0x76};
const uint8_t HuffDecoderCommon::table17_15_emit_[30] = {
    0x3f, 0x77, 0x3f, 0x78, 0x3f, 0x79, 0x3f, 0x7a, 0x3f, 0x26,
    0x3f, 0x2a, 0x3f, 0x2c, 0x3f, 0x3b, 0x3f, 0x58, 0x3f, 0x5a,
    0x3f, 0x21, 0x3f, 0x22, 0x3f, 0x28, 0x3f, 0x29, 0x3f, 0x3f};
const uint16_t HuffDecoderCommon::table17_15_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table17_16_emit_[8] = {0x27, 0x30, 0x27, 0x31,
                                                        0x27, 0x32, 0x27, 0x61};
const uint8_t HuffDecoderCommon::table17_17_emit_[8] = {0x27, 0x63, 0x27, 0x65,
                                                        0x27, 0x69, 0x27, 0x6f};
const uint8_t HuffDecoderCommon::table17_18_emit_[12] = {
    0x27, 0x73, 0x27, 0x74, 0x27, 0x20, 0x27, 0x25, 0x27, 0x2d, 0x27, 0x2e};
const uint8_t HuffDecoderCommon::table17_19_emit_[16] = {
    0x27, 0x2f, 0x27, 0x33, 0x27, 0x34, 0x27, 0x35,
    0x27, 0x36, 0x27, 0x37, 0x27, 0x38, 0x27, 0x39};
const uint8_t HuffDecoderCommon::table17_20_emit_[16] = {
    0x27, 0x3d, 0x27, 0x41, 0x27, 0x5f, 0x27, 0x62,
    0x27, 0x64, 0x27, 0x66, 0x27, 0x67, 0x27, 0x68};
const uint8_t HuffDecoderCommon::table17_21_emit_[20] = {
    0x27, 0x6c, 0x27, 0x6d, 0x27, 0x6e, 0x27, 0x70, 0x27, 0x72,
    0x27, 0x75, 0x27, 0x3a, 0x27, 0x42, 0x27, 0x43, 0x27, 0x44};
const uint16_t HuffDecoderCommon::table17_21_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0042,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092};
const uint8_t HuffDecoderCommon::table17_22_emit_[32] = {
    0x27, 0x45, 0x27, 0x46, 0x27, 0x47, 0x27, 0x48, 0x27, 0x49, 0x27,
    0x4a, 0x27, 0x4b, 0x27, 0x4c, 0x27, 0x4d, 0x27, 0x4e, 0x27, 0x4f,
    0x27, 0x50, 0x27, 0x51, 0x27, 0x52, 0x27, 0x53, 0x27, 0x54};
const uint16_t HuffDecoderCommon::table17_22_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x0001, 0x0001, 0x00a2, 0x0001, 0x0001, 0x0001, 0x00b2,
    0x0001, 0x0001, 0x0001, 0x00c2, 0x0001, 0x0001, 0x0001, 0x00d2,
    0x0001, 0x0001, 0x0001, 0x00e2, 0x0001, 0x0001, 0x0001, 0x00f2};
const uint8_t HuffDecoderCommon::table17_23_emit_[36] = {
    0x27, 0x55, 0x27, 0x56, 0x27, 0x57, 0x27, 0x59, 0x27, 0x6a, 0x27, 0x6b,
    0x27, 0x71, 0x27, 0x76, 0x27, 0x77, 0x27, 0x78, 0x27, 0x79, 0x27, 0x7a,
    0x27, 0x26, 0x27, 0x2a, 0x27, 0x2c, 0x27, 0x3b, 0x27, 0x58, 0x27, 0x5a};
const uint16_t HuffDecoderCommon::table17_23_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x0001, 0x0001, 0x00a2, 0x0001, 0x0001, 0x0001, 0x00b2,
    0x0001, 0x00c2, 0x0001, 0x00d2, 0x0001, 0x00e2, 0x0001, 0x00f2,
    0x0001, 0x0102, 0x0001, 0x0112, 0x0001, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table17_24_emit_[8] = {0x2b, 0x30, 0x2b, 0x31,
                                                        0x2b, 0x32, 0x2b, 0x61};
const uint8_t HuffDecoderCommon::table17_25_emit_[8] = {0x2b, 0x63, 0x2b, 0x65,
                                                        0x2b, 0x69, 0x2b, 0x6f};
const uint8_t HuffDecoderCommon::table17_26_emit_[12] = {
    0x2b, 0x73, 0x2b, 0x74, 0x2b, 0x20, 0x2b, 0x25, 0x2b, 0x2d, 0x2b, 0x2e};
const uint8_t HuffDecoderCommon::table17_27_emit_[16] = {
    0x2b, 0x2f, 0x2b, 0x33, 0x2b, 0x34, 0x2b, 0x35,
    0x2b, 0x36, 0x2b, 0x37, 0x2b, 0x38, 0x2b, 0x39};
const uint8_t HuffDecoderCommon::table17_28_emit_[16] = {
    0x2b, 0x3d, 0x2b, 0x41, 0x2b, 0x5f, 0x2b, 0x62,
    0x2b, 0x64, 0x2b, 0x66, 0x2b, 0x67, 0x2b, 0x68};
const uint8_t HuffDecoderCommon::table17_29_emit_[20] = {
    0x2b, 0x6c, 0x2b, 0x6d, 0x2b, 0x6e, 0x2b, 0x70, 0x2b, 0x72,
    0x2b, 0x75, 0x2b, 0x3a, 0x2b, 0x42, 0x2b, 0x43, 0x2b, 0x44};
const uint8_t HuffDecoderCommon::table17_30_emit_[32] = {
    0x2b, 0x45, 0x2b, 0x46, 0x2b, 0x47, 0x2b, 0x48, 0x2b, 0x49, 0x2b,
    0x4a, 0x2b, 0x4b, 0x2b, 0x4c, 0x2b, 0x4d, 0x2b, 0x4e, 0x2b, 0x4f,
    0x2b, 0x50, 0x2b, 0x51, 0x2b, 0x52, 0x2b, 0x53, 0x2b, 0x54};
const uint8_t HuffDecoderCommon::table17_31_emit_[36] = {
    0x2b, 0x55, 0x2b, 0x56, 0x2b, 0x57, 0x2b, 0x59, 0x2b, 0x6a, 0x2b, 0x6b,
    0x2b, 0x71, 0x2b, 0x76, 0x2b, 0x77, 0x2b, 0x78, 0x2b, 0x79, 0x2b, 0x7a,
    0x2b, 0x26, 0x2b, 0x2a, 0x2b, 0x2c, 0x2b, 0x3b, 0x2b, 0x58, 0x2b, 0x5a};
const uint8_t HuffDecoderCommon::table17_32_emit_[8] = {0x7c, 0x30, 0x7c, 0x31,
                                                        0x7c, 0x32, 0x7c, 0x61};
const uint8_t HuffDecoderCommon::table17_33_emit_[8] = {0x7c, 0x63, 0x7c, 0x65,
                                                        0x7c, 0x69, 0x7c, 0x6f};
const uint8_t HuffDecoderCommon::table17_34_emit_[12] = {
    0x7c, 0x73, 0x7c, 0x74, 0x7c, 0x20, 0x7c, 0x25, 0x7c, 0x2d, 0x7c, 0x2e};
const uint8_t HuffDecoderCommon::table17_35_emit_[16] = {
    0x7c, 0x2f, 0x7c, 0x33, 0x7c, 0x34, 0x7c, 0x35,
    0x7c, 0x36, 0x7c, 0x37, 0x7c, 0x38, 0x7c, 0x39};
const uint8_t HuffDecoderCommon::table17_36_emit_[16] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62,
    0x7c, 0x64, 0x7c, 0x66, 0x7c, 0x67, 0x7c, 0x68};
const uint8_t HuffDecoderCommon::table17_37_emit_[20] = {
    0x7c, 0x6c, 0x7c, 0x6d, 0x7c, 0x6e, 0x7c, 0x70, 0x7c, 0x72,
    0x7c, 0x75, 0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44};
const uint8_t HuffDecoderCommon::table17_38_emit_[32] = {
    0x7c, 0x45, 0x7c, 0x46, 0x7c, 0x47, 0x7c, 0x48, 0x7c, 0x49, 0x7c,
    0x4a, 0x7c, 0x4b, 0x7c, 0x4c, 0x7c, 0x4d, 0x7c, 0x4e, 0x7c, 0x4f,
    0x7c, 0x50, 0x7c, 0x51, 0x7c, 0x52, 0x7c, 0x53, 0x7c, 0x54};
const uint8_t HuffDecoderCommon::table17_39_emit_[36] = {
    0x7c, 0x55, 0x7c, 0x56, 0x7c, 0x57, 0x7c, 0x59, 0x7c, 0x6a, 0x7c, 0x6b,
    0x7c, 0x71, 0x7c, 0x76, 0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a,
    0x7c, 0x26, 0x7c, 0x2a, 0x7c, 0x2c, 0x7c, 0x3b, 0x7c, 0x58, 0x7c, 0x5a};
const uint8_t HuffDecoderCommon::table17_40_emit_[16] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61,
    0x23, 0x63, 0x23, 0x65, 0x23, 0x69, 0x23, 0x6f};
const uint8_t HuffDecoderCommon::table17_41_emit_[28] = {
    0x23, 0x73, 0x23, 0x74, 0x23, 0x20, 0x23, 0x25, 0x23, 0x2d,
    0x23, 0x2e, 0x23, 0x2f, 0x23, 0x33, 0x23, 0x34, 0x23, 0x35,
    0x23, 0x36, 0x23, 0x37, 0x23, 0x38, 0x23, 0x39};
const uint16_t HuffDecoderCommon::table17_41_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x0001, 0x0001, 0x00a2, 0x0001, 0x0001, 0x0001, 0x00b2,
    0x0001, 0x0001, 0x0001, 0x00c2, 0x0001, 0x0001, 0x0001, 0x00d2};
const uint8_t HuffDecoderCommon::table17_42_emit_[36] = {
    0x23, 0x3d, 0x23, 0x41, 0x23, 0x5f, 0x23, 0x62, 0x23, 0x64, 0x23, 0x66,
    0x23, 0x67, 0x23, 0x68, 0x23, 0x6c, 0x23, 0x6d, 0x23, 0x6e, 0x23, 0x70,
    0x23, 0x72, 0x23, 0x75, 0x23, 0x3a, 0x23, 0x42, 0x23, 0x43, 0x23, 0x44};
const uint16_t HuffDecoderCommon::table17_42_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x0001, 0x0001, 0x00a2, 0x0001, 0x0001, 0x0001, 0x00b2,
    0x0001, 0x0001, 0x0001, 0x00c2, 0x0001, 0x0001, 0x0001, 0x00d2,
    0x0001, 0x00e2, 0x0001, 0x00f2, 0x0001, 0x0102, 0x0001, 0x0112};
const uint8_t HuffDecoderCommon::table17_43_emit_[68] = {
    0x23, 0x45, 0x23, 0x46, 0x23, 0x47, 0x23, 0x48, 0x23, 0x49, 0x23, 0x4a,
    0x23, 0x4b, 0x23, 0x4c, 0x23, 0x4d, 0x23, 0x4e, 0x23, 0x4f, 0x23, 0x50,
    0x23, 0x51, 0x23, 0x52, 0x23, 0x53, 0x23, 0x54, 0x23, 0x55, 0x23, 0x56,
    0x23, 0x57, 0x23, 0x59, 0x23, 0x6a, 0x23, 0x6b, 0x23, 0x71, 0x23, 0x76,
    0x23, 0x77, 0x23, 0x78, 0x23, 0x79, 0x23, 0x7a, 0x23, 0x26, 0x23, 0x2a,
    0x23, 0x2c, 0x23, 0x3b, 0x23, 0x58, 0x23, 0x5a};
const uint16_t HuffDecoderCommon::table17_43_ops_[64] = {
    0x0001, 0x0002, 0x0001, 0x0012, 0x0001, 0x0022, 0x0001, 0x0032,
    0x0001, 0x0042, 0x0001, 0x0052, 0x0001, 0x0062, 0x0001, 0x0072,
    0x0001, 0x0082, 0x0001, 0x0092, 0x0001, 0x00a2, 0x0001, 0x00b2,
    0x0001, 0x00c2, 0x0001, 0x00d2, 0x0001, 0x00e2, 0x0001, 0x00f2,
    0x0001, 0x0102, 0x0001, 0x0112, 0x0001, 0x0122, 0x0001, 0x0132,
    0x0001, 0x0142, 0x0001, 0x0152, 0x0001, 0x0162, 0x0001, 0x0172,
    0x0001, 0x0182, 0x0001, 0x0192, 0x0001, 0x01a2, 0x0001, 0x01b2,
    0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table17_44_emit_[16] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61,
    0x3e, 0x63, 0x3e, 0x65, 0x3e, 0x69, 0x3e, 0x6f};
const uint8_t HuffDecoderCommon::table17_45_emit_[28] = {
    0x3e, 0x73, 0x3e, 0x74, 0x3e, 0x20, 0x3e, 0x25, 0x3e, 0x2d,
    0x3e, 0x2e, 0x3e, 0x2f, 0x3e, 0x33, 0x3e, 0x34, 0x3e, 0x35,
    0x3e, 0x36, 0x3e, 0x37, 0x3e, 0x38, 0x3e, 0x39};
const uint8_t HuffDecoderCommon::table17_46_emit_[36] = {
    0x3e, 0x3d, 0x3e, 0x41, 0x3e, 0x5f, 0x3e, 0x62, 0x3e, 0x64, 0x3e, 0x66,
    0x3e, 0x67, 0x3e, 0x68, 0x3e, 0x6c, 0x3e, 0x6d, 0x3e, 0x6e, 0x3e, 0x70,
    0x3e, 0x72, 0x3e, 0x75, 0x3e, 0x3a, 0x3e, 0x42, 0x3e, 0x43, 0x3e, 0x44};
const uint8_t HuffDecoderCommon::table17_47_emit_[68] = {
    0x3e, 0x45, 0x3e, 0x46, 0x3e, 0x47, 0x3e, 0x48, 0x3e, 0x49, 0x3e, 0x4a,
    0x3e, 0x4b, 0x3e, 0x4c, 0x3e, 0x4d, 0x3e, 0x4e, 0x3e, 0x4f, 0x3e, 0x50,
    0x3e, 0x51, 0x3e, 0x52, 0x3e, 0x53, 0x3e, 0x54, 0x3e, 0x55, 0x3e, 0x56,
    0x3e, 0x57, 0x3e, 0x59, 0x3e, 0x6a, 0x3e, 0x6b, 0x3e, 0x71, 0x3e, 0x76,
    0x3e, 0x77, 0x3e, 0x78, 0x3e, 0x79, 0x3e, 0x7a, 0x3e, 0x26, 0x3e, 0x2a,
    0x3e, 0x2c, 0x3e, 0x3b, 0x3e, 0x58, 0x3e, 0x5a};
const uint8_t HuffDecoderCommon::table17_48_emit_[44] = {
    0x00, 0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x61, 0x00, 0x63, 0x00,
    0x65, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x74, 0x00, 0x20,
    0x00, 0x25, 0x00, 0x2d, 0x00, 0x2e, 0x00, 0x2f, 0x00, 0x33, 0x00,
    0x34, 0x00, 0x35, 0x00, 0x36, 0x00, 0x37, 0x00, 0x38, 0x00, 0x39};
const uint16_t HuffDecoderCommon::table17_48_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x00a2, 0x0001, 0x00b2, 0x0001, 0x00c2, 0x0001, 0x00d2,
    0x0001, 0x00e2, 0x0001, 0x00f2, 0x0001, 0x0102, 0x0001, 0x0112,
    0x0001, 0x0122, 0x0001, 0x0132, 0x0001, 0x0142, 0x0001, 0x0152};
const uint8_t HuffDecoderCommon::table17_49_emit_[92] = {
    0x00, 0x3d, 0x00, 0x41, 0x00, 0x5f, 0x00, 0x62, 0x00, 0x64, 0x00, 0x66,
    0x00, 0x67, 0x00, 0x68, 0x00, 0x6c, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x70,
    0x00, 0x72, 0x00, 0x75, 0x00, 0x3a, 0x00, 0x42, 0x00, 0x43, 0x00, 0x44,
    0x00, 0x45, 0x00, 0x46, 0x00, 0x47, 0x00, 0x48, 0x00, 0x49, 0x00, 0x4a,
    0x00, 0x4b, 0x00, 0x4c, 0x00, 0x4d, 0x00, 0x4e, 0x00, 0x4f, 0x00, 0x50,
    0x00, 0x51, 0x00, 0x52, 0x00, 0x53, 0x00, 0x54, 0x00, 0x55, 0x00, 0x56,
    0x00, 0x57, 0x00, 0x59, 0x00, 0x6a, 0x00, 0x6b, 0x00, 0x71, 0x00, 0x76,
    0x00, 0x77, 0x00, 0x78, 0x00, 0x79, 0x00, 0x7a};
const uint16_t HuffDecoderCommon::table17_49_ops_[64] = {
    0x0001, 0x0002, 0x0001, 0x0012, 0x0001, 0x0022, 0x0001, 0x0032,
    0x0001, 0x0042, 0x0001, 0x0052, 0x0001, 0x0062, 0x0001, 0x0072,
    0x0001, 0x0082, 0x0001, 0x0092, 0x0001, 0x00a2, 0x0001, 0x00b2,
    0x0001, 0x00c2, 0x0001, 0x00d2, 0x00e2, 0x00f2, 0x0102, 0x0112,
    0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212,
    0x0222, 0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292,
    0x02a2, 0x02b2, 0x02c2, 0x02d2, 0x0001, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table17_50_emit_[44] = {
    0x24, 0x30, 0x24, 0x31, 0x24, 0x32, 0x24, 0x61, 0x24, 0x63, 0x24,
    0x65, 0x24, 0x69, 0x24, 0x6f, 0x24, 0x73, 0x24, 0x74, 0x24, 0x20,
    0x24, 0x25, 0x24, 0x2d, 0x24, 0x2e, 0x24, 0x2f, 0x24, 0x33, 0x24,
    0x34, 0x24, 0x35, 0x24, 0x36, 0x24, 0x37, 0x24, 0x38, 0x24, 0x39};
const uint8_t HuffDecoderCommon::table17_51_emit_[92] = {
    0x24, 0x3d, 0x24, 0x41, 0x24, 0x5f, 0x24, 0x62, 0x24, 0x64, 0x24, 0x66,
    0x24, 0x67, 0x24, 0x68, 0x24, 0x6c, 0x24, 0x6d, 0x24, 0x6e, 0x24, 0x70,
    0x24, 0x72, 0x24, 0x75, 0x24, 0x3a, 0x24, 0x42, 0x24, 0x43, 0x24, 0x44,
    0x24, 0x45, 0x24, 0x46, 0x24, 0x47, 0x24, 0x48, 0x24, 0x49, 0x24, 0x4a,
    0x24, 0x4b, 0x24, 0x4c, 0x24, 0x4d, 0x24, 0x4e, 0x24, 0x4f, 0x24, 0x50,
    0x24, 0x51, 0x24, 0x52, 0x24, 0x53, 0x24, 0x54, 0x24, 0x55, 0x24, 0x56,
    0x24, 0x57, 0x24, 0x59, 0x24, 0x6a, 0x24, 0x6b, 0x24, 0x71, 0x24, 0x76,
    0x24, 0x77, 0x24, 0x78, 0x24, 0x79, 0x24, 0x7a};
const uint8_t HuffDecoderCommon::table17_52_emit_[44] = {
    0x40, 0x30, 0x40, 0x31, 0x40, 0x32, 0x40, 0x61, 0x40, 0x63, 0x40,
    0x65, 0x40, 0x69, 0x40, 0x6f, 0x40, 0x73, 0x40, 0x74, 0x40, 0x20,
    0x40, 0x25, 0x40, 0x2d, 0x40, 0x2e, 0x40, 0x2f, 0x40, 0x33, 0x40,
    0x34, 0x40, 0x35, 0x40, 0x36, 0x40, 0x37, 0x40, 0x38, 0x40, 0x39};
const uint8_t HuffDecoderCommon::table17_53_emit_[92] = {
    0x40, 0x3d, 0x40, 0x41, 0x40, 0x5f, 0x40, 0x62, 0x40, 0x64, 0x40, 0x66,
    0x40, 0x67, 0x40, 0x68, 0x40, 0x6c, 0x40, 0x6d, 0x40, 0x6e, 0x40, 0x70,
    0x40, 0x72, 0x40, 0x75, 0x40, 0x3a, 0x40, 0x42, 0x40, 0x43, 0x40, 0x44,
    0x40, 0x45, 0x40, 0x46, 0x40, 0x47, 0x40, 0x48, 0x40, 0x49, 0x40, 0x4a,
    0x40, 0x4b, 0x40, 0x4c, 0x40, 0x4d, 0x40, 0x4e, 0x40, 0x4f, 0x40, 0x50,
    0x40, 0x51, 0x40, 0x52, 0x40, 0x53, 0x40, 0x54, 0x40, 0x55, 0x40, 0x56,
    0x40, 0x57, 0x40, 0x59, 0x40, 0x6a, 0x40, 0x6b, 0x40, 0x71, 0x40, 0x76,
    0x40, 0x77, 0x40, 0x78, 0x40, 0x79, 0x40, 0x7a};
const uint8_t HuffDecoderCommon::table17_54_emit_[44] = {
    0x5b, 0x30, 0x5b, 0x31, 0x5b, 0x32, 0x5b, 0x61, 0x5b, 0x63, 0x5b,
    0x65, 0x5b, 0x69, 0x5b, 0x6f, 0x5b, 0x73, 0x5b, 0x74, 0x5b, 0x20,
    0x5b, 0x25, 0x5b, 0x2d, 0x5b, 0x2e, 0x5b, 0x2f, 0x5b, 0x33, 0x5b,
    0x34, 0x5b, 0x35, 0x5b, 0x36, 0x5b, 0x37, 0x5b, 0x38, 0x5b, 0x39};
const uint8_t HuffDecoderCommon::table17_55_emit_[92] = {
    0x5b, 0x3d, 0x5b, 0x41, 0x5b, 0x5f, 0x5b, 0x62, 0x5b, 0x64, 0x5b, 0x66,
    0x5b, 0x67, 0x5b, 0x68, 0x5b, 0x6c, 0x5b, 0x6d, 0x5b, 0x6e, 0x5b, 0x70,
    0x5b, 0x72, 0x5b, 0x75, 0x5b, 0x3a, 0x5b, 0x42, 0x5b, 0x43, 0x5b, 0x44,
    0x5b, 0x45, 0x5b, 0x46, 0x5b, 0x47, 0x5b, 0x48, 0x5b, 0x49, 0x5b, 0x4a,
    0x5b, 0x4b, 0x5b, 0x4c, 0x5b, 0x4d, 0x5b, 0x4e, 0x5b, 0x4f, 0x5b, 0x50,
    0x5b, 0x51, 0x5b, 0x52, 0x5b, 0x53, 0x5b, 0x54, 0x5b, 0x55, 0x5b, 0x56,
    0x5b, 0x57, 0x5b, 0x59, 0x5b, 0x6a, 0x5b, 0x6b, 0x5b, 0x71, 0x5b, 0x76,
    0x5b, 0x77, 0x5b, 0x78, 0x5b, 0x79, 0x5b, 0x7a};
const uint8_t HuffDecoderCommon::table17_56_emit_[44] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63, 0x5d,
    0x65, 0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74, 0x5d, 0x20,
    0x5d, 0x25, 0x5d, 0x2d, 0x5d, 0x2e, 0x5d, 0x2f, 0x5d, 0x33, 0x5d,
    0x34, 0x5d, 0x35, 0x5d, 0x36, 0x5d, 0x37, 0x5d, 0x38, 0x5d, 0x39};
const uint8_t HuffDecoderCommon::table17_57_emit_[92] = {
    0x5d, 0x3d, 0x5d, 0x41, 0x5d, 0x5f, 0x5d, 0x62, 0x5d, 0x64, 0x5d, 0x66,
    0x5d, 0x67, 0x5d, 0x68, 0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70,
    0x5d, 0x72, 0x5d, 0x75, 0x5d, 0x3a, 0x5d, 0x42, 0x5d, 0x43, 0x5d, 0x44,
    0x5d, 0x45, 0x5d, 0x46, 0x5d, 0x47, 0x5d, 0x48, 0x5d, 0x49, 0x5d, 0x4a,
    0x5d, 0x4b, 0x5d, 0x4c, 0x5d, 0x4d, 0x5d, 0x4e, 0x5d, 0x4f, 0x5d, 0x50,
    0x5d, 0x51, 0x5d, 0x52, 0x5d, 0x53, 0x5d, 0x54, 0x5d, 0x55, 0x5d, 0x56,
    0x5d, 0x57, 0x5d, 0x59, 0x5d, 0x6a, 0x5d, 0x6b, 0x5d, 0x71, 0x5d, 0x76,
    0x5d, 0x77, 0x5d, 0x78, 0x5d, 0x79, 0x5d, 0x7a};
const uint8_t HuffDecoderCommon::table17_58_emit_[44] = {
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63, 0x7e,
    0x65, 0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74, 0x7e, 0x20,
    0x7e, 0x25, 0x7e, 0x2d, 0x7e, 0x2e, 0x7e, 0x2f, 0x7e, 0x33, 0x7e,
    0x34, 0x7e, 0x35, 0x7e, 0x36, 0x7e, 0x37, 0x7e, 0x38, 0x7e, 0x39};
const uint8_t HuffDecoderCommon::table17_59_emit_[92] = {
    0x7e, 0x3d, 0x7e, 0x41, 0x7e, 0x5f, 0x7e, 0x62, 0x7e, 0x64, 0x7e, 0x66,
    0x7e, 0x67, 0x7e, 0x68, 0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70,
    0x7e, 0x72, 0x7e, 0x75, 0x7e, 0x3a, 0x7e, 0x42, 0x7e, 0x43, 0x7e, 0x44,
    0x7e, 0x45, 0x7e, 0x46, 0x7e, 0x47, 0x7e, 0x48, 0x7e, 0x49, 0x7e, 0x4a,
    0x7e, 0x4b, 0x7e, 0x4c, 0x7e, 0x4d, 0x7e, 0x4e, 0x7e, 0x4f, 0x7e, 0x50,
    0x7e, 0x51, 0x7e, 0x52, 0x7e, 0x53, 0x7e, 0x54, 0x7e, 0x55, 0x7e, 0x56,
    0x7e, 0x57, 0x7e, 0x59, 0x7e, 0x6a, 0x7e, 0x6b, 0x7e, 0x71, 0x7e, 0x76,
    0x7e, 0x77, 0x7e, 0x78, 0x7e, 0x79, 0x7e, 0x7a};
const uint8_t HuffDecoderCommon::table17_60_emit_[72] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61, 0x5e, 0x63, 0x5e, 0x65,
    0x5e, 0x69, 0x5e, 0x6f, 0x5e, 0x73, 0x5e, 0x74, 0x5e, 0x20, 0x5e, 0x25,
    0x5e, 0x2d, 0x5e, 0x2e, 0x5e, 0x2f, 0x5e, 0x33, 0x5e, 0x34, 0x5e, 0x35,
    0x5e, 0x36, 0x5e, 0x37, 0x5e, 0x38, 0x5e, 0x39, 0x5e, 0x3d, 0x5e, 0x41,
    0x5e, 0x5f, 0x5e, 0x62, 0x5e, 0x64, 0x5e, 0x66, 0x5e, 0x67, 0x5e, 0x68,
    0x5e, 0x6c, 0x5e, 0x6d, 0x5e, 0x6e, 0x5e, 0x70, 0x5e, 0x72, 0x5e, 0x75};
const uint16_t HuffDecoderCommon::table17_60_ops_[64] = {
    0x0001, 0x0002, 0x0001, 0x0012, 0x0001, 0x0022, 0x0001, 0x0032,
    0x0001, 0x0042, 0x0001, 0x0052, 0x0001, 0x0062, 0x0001, 0x0072,
    0x0001, 0x0082, 0x0001, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2,
    0x00e2, 0x00f2, 0x0102, 0x0112, 0x0122, 0x0132, 0x0142, 0x0152,
    0x0162, 0x0172, 0x0182, 0x0192, 0x01a2, 0x01b2, 0x01c2, 0x01d2,
    0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222, 0x0232, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table17_61_emit_[72] = {
    0x7d, 0x30, 0x7d, 0x31, 0x7d, 0x32, 0x7d, 0x61, 0x7d, 0x63, 0x7d, 0x65,
    0x7d, 0x69, 0x7d, 0x6f, 0x7d, 0x73, 0x7d, 0x74, 0x7d, 0x20, 0x7d, 0x25,
    0x7d, 0x2d, 0x7d, 0x2e, 0x7d, 0x2f, 0x7d, 0x33, 0x7d, 0x34, 0x7d, 0x35,
    0x7d, 0x36, 0x7d, 0x37, 0x7d, 0x38, 0x7d, 0x39, 0x7d, 0x3d, 0x7d, 0x41,
    0x7d, 0x5f, 0x7d, 0x62, 0x7d, 0x64, 0x7d, 0x66, 0x7d, 0x67, 0x7d, 0x68,
    0x7d, 0x6c, 0x7d, 0x6d, 0x7d, 0x6e, 0x7d, 0x70, 0x7d, 0x72, 0x7d, 0x75};
const uint8_t HuffDecoderCommon::table17_62_emit_[40] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63,
    0x3c, 0x65, 0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74,
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63,
    0x60, 0x65, 0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74};
const uint16_t HuffDecoderCommon::table17_62_ops_[64] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102, 0x0112,
    0x0122, 0x0132, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x00a3};
const uint8_t HuffDecoderCommon::table17_63_emit_[31] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b,
    0x65, 0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x5c, 0xc3,
    0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2};
const uint16_t HuffDecoderCommon::table17_63_ops_[64] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x0001, 0x00a3, 0x0001, 0x00ab, 0x0001, 0x00b3, 0x00bb, 0x00c3,
    0x00cb, 0x00d3, 0x00db, 0x00e3, 0x00eb, 0x00f3, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0004};
const uint8_t* const HuffDecoderCommon::table17_emit_[64] = {
    table17_0_emit_,  table17_1_emit_,  table17_2_emit_,  table17_3_emit_,
    table17_4_emit_,  table17_5_emit_,  table17_6_emit_,  table17_7_emit_,
    table17_8_emit_,  table17_9_emit_,  table17_10_emit_, table17_11_emit_,
    table17_12_emit_, table17_13_emit_, table17_14_emit_, table17_15_emit_,
    table17_16_emit_, table17_17_emit_, table17_18_emit_, table17_19_emit_,
    table17_20_emit_, table17_21_emit_, table17_22_emit_, table17_23_emit_,
    table17_24_emit_, table17_25_emit_, table17_26_emit_, table17_27_emit_,
    table17_28_emit_, table17_29_emit_, table17_30_emit_, table17_31_emit_,
    table17_32_emit_, table17_33_emit_, table17_34_emit_, table17_35_emit_,
    table17_36_emit_, table17_37_emit_, table17_38_emit_, table17_39_emit_,
    table17_40_emit_, table17_41_emit_, table17_42_emit_, table17_43_emit_,
    table17_44_emit_, table17_45_emit_, table17_46_emit_, table17_47_emit_,
    table17_48_emit_, table17_49_emit_, table17_50_emit_, table17_51_emit_,
    table17_52_emit_, table17_53_emit_, table17_54_emit_, table17_55_emit_,
    table17_56_emit_, table17_57_emit_, table17_58_emit_, table17_59_emit_,
    table17_60_emit_, table17_61_emit_, table17_62_emit_, table17_63_emit_,
};
const uint16_t* const HuffDecoderCommon::table17_ops_[64] = {
    table17_0_ops_,  table17_0_ops_,  table17_0_ops_,  table17_0_ops_,
    table17_0_ops_,  table17_5_ops_,  table17_5_ops_,  table17_5_ops_,
    table17_5_ops_,  table17_5_ops_,  table17_5_ops_,  table17_11_ops_,
    table17_12_ops_, table17_12_ops_, table17_12_ops_, table17_15_ops_,
    table17_5_ops_,  table17_5_ops_,  table17_11_ops_, table17_12_ops_,
    table17_12_ops_, table17_21_ops_, table17_22_ops_, table17_23_ops_,
    table17_5_ops_,  table17_5_ops_,  table17_11_ops_, table17_12_ops_,
    table17_12_ops_, table17_21_ops_, table17_22_ops_, table17_23_ops_,
    table17_5_ops_,  table17_5_ops_,  table17_11_ops_, table17_12_ops_,
    table17_12_ops_, table17_21_ops_, table17_22_ops_, table17_23_ops_,
    table17_12_ops_, table17_41_ops_, table17_42_ops_, table17_43_ops_,
    table17_12_ops_, table17_41_ops_, table17_42_ops_, table17_43_ops_,
    table17_48_ops_, table17_49_ops_, table17_48_ops_, table17_49_ops_,
    table17_48_ops_, table17_49_ops_, table17_48_ops_, table17_49_ops_,
    table17_48_ops_, table17_49_ops_, table17_48_ops_, table17_49_ops_,
    table17_60_ops_, table17_60_ops_, table17_62_ops_, table17_63_ops_,
};
const uint8_t HuffDecoderCommon::table18_0_emit_[108] = {
    0x3f, 0x30, 0x30, 0x3f, 0x30, 0x31, 0x3f, 0x30, 0x32, 0x3f, 0x30, 0x61,
    0x3f, 0x30, 0x63, 0x3f, 0x30, 0x65, 0x3f, 0x30, 0x69, 0x3f, 0x30, 0x6f,
    0x3f, 0x30, 0x73, 0x3f, 0x30, 0x74, 0x3f, 0x30, 0x20, 0x3f, 0x30, 0x25,
    0x3f, 0x30, 0x2d, 0x3f, 0x30, 0x2e, 0x3f, 0x30, 0x2f, 0x3f, 0x30, 0x33,
    0x3f, 0x30, 0x34, 0x3f, 0x30, 0x35, 0x3f, 0x30, 0x36, 0x3f, 0x30, 0x37,
    0x3f, 0x30, 0x38, 0x3f, 0x30, 0x39, 0x3f, 0x30, 0x3d, 0x3f, 0x30, 0x41,
    0x3f, 0x30, 0x5f, 0x3f, 0x30, 0x62, 0x3f, 0x30, 0x64, 0x3f, 0x30, 0x66,
    0x3f, 0x30, 0x67, 0x3f, 0x30, 0x68, 0x3f, 0x30, 0x6c, 0x3f, 0x30, 0x6d,
    0x3f, 0x30, 0x6e, 0x3f, 0x30, 0x70, 0x3f, 0x30, 0x72, 0x3f, 0x30, 0x75};
const uint16_t HuffDecoderCommon::table18_0_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0019, 0x0000, 0x0031, 0x0000, 0x0049,
    0x0000, 0x0061, 0x0000, 0x0079, 0x0000, 0x0091, 0x0000, 0x00a9,
    0x0000, 0x00c1, 0x0000, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139,
    0x0151, 0x0169, 0x0181, 0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9,
    0x0211, 0x0229, 0x0241, 0x0259, 0x0271, 0x0289, 0x02a1, 0x02b9,
    0x02d1, 0x02e9, 0x0301, 0x0319, 0x0331, 0x0349, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table18_1_emit_[108] = {
    0x3f, 0x31, 0x30, 0x3f, 0x31, 0x31, 0x3f, 0x31, 0x32, 0x3f, 0x31, 0x61,
    0x3f, 0x31, 0x63, 0x3f, 0x31, 0x65, 0x3f, 0x31, 0x69, 0x3f, 0x31, 0x6f,
    0x3f, 0x31, 0x73, 0x3f, 0x31, 0x74, 0x3f, 0x31, 0x20, 0x3f, 0x31, 0x25,
    0x3f, 0x31, 0x2d, 0x3f, 0x31, 0x2e, 0x3f, 0x31, 0x2f, 0x3f, 0x31, 0x33,
    0x3f, 0x31, 0x34, 0x3f, 0x31, 0x35, 0x3f, 0x31, 0x36, 0x3f, 0x31, 0x37,
    0x3f, 0x31, 0x38, 0x3f, 0x31, 0x39, 0x3f, 0x31, 0x3d, 0x3f, 0x31, 0x41,
    0x3f, 0x31, 0x5f, 0x3f, 0x31, 0x62, 0x3f, 0x31, 0x64, 0x3f, 0x31, 0x66,
    0x3f, 0x31, 0x67, 0x3f, 0x31, 0x68, 0x3f, 0x31, 0x6c, 0x3f, 0x31, 0x6d,
    0x3f, 0x31, 0x6e, 0x3f, 0x31, 0x70, 0x3f, 0x31, 0x72, 0x3f, 0x31, 0x75};
const uint8_t HuffDecoderCommon::table18_2_emit_[108] = {
    0x3f, 0x32, 0x30, 0x3f, 0x32, 0x31, 0x3f, 0x32, 0x32, 0x3f, 0x32, 0x61,
    0x3f, 0x32, 0x63, 0x3f, 0x32, 0x65, 0x3f, 0x32, 0x69, 0x3f, 0x32, 0x6f,
    0x3f, 0x32, 0x73, 0x3f, 0x32, 0x74, 0x3f, 0x32, 0x20, 0x3f, 0x32, 0x25,
    0x3f, 0x32, 0x2d, 0x3f, 0x32, 0x2e, 0x3f, 0x32, 0x2f, 0x3f, 0x32, 0x33,
    0x3f, 0x32, 0x34, 0x3f, 0x32, 0x35, 0x3f, 0x32, 0x36, 0x3f, 0x32, 0x37,
    0x3f, 0x32, 0x38, 0x3f, 0x32, 0x39, 0x3f, 0x32, 0x3d, 0x3f, 0x32, 0x41,
    0x3f, 0x32, 0x5f, 0x3f, 0x32, 0x62, 0x3f, 0x32, 0x64, 0x3f, 0x32, 0x66,
    0x3f, 0x32, 0x67, 0x3f, 0x32, 0x68, 0x3f, 0x32, 0x6c, 0x3f, 0x32, 0x6d,
    0x3f, 0x32, 0x6e, 0x3f, 0x32, 0x70, 0x3f, 0x32, 0x72, 0x3f, 0x32, 0x75};
const uint8_t HuffDecoderCommon::table18_3_emit_[108] = {
    0x3f, 0x61, 0x30, 0x3f, 0x61, 0x31, 0x3f, 0x61, 0x32, 0x3f, 0x61, 0x61,
    0x3f, 0x61, 0x63, 0x3f, 0x61, 0x65, 0x3f, 0x61, 0x69, 0x3f, 0x61, 0x6f,
    0x3f, 0x61, 0x73, 0x3f, 0x61, 0x74, 0x3f, 0x61, 0x20, 0x3f, 0x61, 0x25,
    0x3f, 0x61, 0x2d, 0x3f, 0x61, 0x2e, 0x3f, 0x61, 0x2f, 0x3f, 0x61, 0x33,
    0x3f, 0x61, 0x34, 0x3f, 0x61, 0x35, 0x3f, 0x61, 0x36, 0x3f, 0x61, 0x37,
    0x3f, 0x61, 0x38, 0x3f, 0x61, 0x39, 0x3f, 0x61, 0x3d, 0x3f, 0x61, 0x41,
    0x3f, 0x61, 0x5f, 0x3f, 0x61, 0x62, 0x3f, 0x61, 0x64, 0x3f, 0x61, 0x66,
    0x3f, 0x61, 0x67, 0x3f, 0x61, 0x68, 0x3f, 0x61, 0x6c, 0x3f, 0x61, 0x6d,
    0x3f, 0x61, 0x6e, 0x3f, 0x61, 0x70, 0x3f, 0x61, 0x72, 0x3f, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table18_4_emit_[108] = {
    0x3f, 0x63, 0x30, 0x3f, 0x63, 0x31, 0x3f, 0x63, 0x32, 0x3f, 0x63, 0x61,
    0x3f, 0x63, 0x63, 0x3f, 0x63, 0x65, 0x3f, 0x63, 0x69, 0x3f, 0x63, 0x6f,
    0x3f, 0x63, 0x73, 0x3f, 0x63, 0x74, 0x3f, 0x63, 0x20, 0x3f, 0x63, 0x25,
    0x3f, 0x63, 0x2d, 0x3f, 0x63, 0x2e, 0x3f, 0x63, 0x2f, 0x3f, 0x63, 0x33,
    0x3f, 0x63, 0x34, 0x3f, 0x63, 0x35, 0x3f, 0x63, 0x36, 0x3f, 0x63, 0x37,
    0x3f, 0x63, 0x38, 0x3f, 0x63, 0x39, 0x3f, 0x63, 0x3d, 0x3f, 0x63, 0x41,
    0x3f, 0x63, 0x5f, 0x3f, 0x63, 0x62, 0x3f, 0x63, 0x64, 0x3f, 0x63, 0x66,
    0x3f, 0x63, 0x67, 0x3f, 0x63, 0x68, 0x3f, 0x63, 0x6c, 0x3f, 0x63, 0x6d,
    0x3f, 0x63, 0x6e, 0x3f, 0x63, 0x70, 0x3f, 0x63, 0x72, 0x3f, 0x63, 0x75};
const uint8_t HuffDecoderCommon::table18_5_emit_[108] = {
    0x3f, 0x65, 0x30, 0x3f, 0x65, 0x31, 0x3f, 0x65, 0x32, 0x3f, 0x65, 0x61,
    0x3f, 0x65, 0x63, 0x3f, 0x65, 0x65, 0x3f, 0x65, 0x69, 0x3f, 0x65, 0x6f,
    0x3f, 0x65, 0x73, 0x3f, 0x65, 0x74, 0x3f, 0x65, 0x20, 0x3f, 0x65, 0x25,
    0x3f, 0x65, 0x2d, 0x3f, 0x65, 0x2e, 0x3f, 0x65, 0x2f, 0x3f, 0x65, 0x33,
    0x3f, 0x65, 0x34, 0x3f, 0x65, 0x35, 0x3f, 0x65, 0x36, 0x3f, 0x65, 0x37,
    0x3f, 0x65, 0x38, 0x3f, 0x65, 0x39, 0x3f, 0x65, 0x3d, 0x3f, 0x65, 0x41,
    0x3f, 0x65, 0x5f, 0x3f, 0x65, 0x62, 0x3f, 0x65, 0x64, 0x3f, 0x65, 0x66,
    0x3f, 0x65, 0x67, 0x3f, 0x65, 0x68, 0x3f, 0x65, 0x6c, 0x3f, 0x65, 0x6d,
    0x3f, 0x65, 0x6e, 0x3f, 0x65, 0x70, 0x3f, 0x65, 0x72, 0x3f, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table18_6_emit_[108] = {
    0x3f, 0x69, 0x30, 0x3f, 0x69, 0x31, 0x3f, 0x69, 0x32, 0x3f, 0x69, 0x61,
    0x3f, 0x69, 0x63, 0x3f, 0x69, 0x65, 0x3f, 0x69, 0x69, 0x3f, 0x69, 0x6f,
    0x3f, 0x69, 0x73, 0x3f, 0x69, 0x74, 0x3f, 0x69, 0x20, 0x3f, 0x69, 0x25,
    0x3f, 0x69, 0x2d, 0x3f, 0x69, 0x2e, 0x3f, 0x69, 0x2f, 0x3f, 0x69, 0x33,
    0x3f, 0x69, 0x34, 0x3f, 0x69, 0x35, 0x3f, 0x69, 0x36, 0x3f, 0x69, 0x37,
    0x3f, 0x69, 0x38, 0x3f, 0x69, 0x39, 0x3f, 0x69, 0x3d, 0x3f, 0x69, 0x41,
    0x3f, 0x69, 0x5f, 0x3f, 0x69, 0x62, 0x3f, 0x69, 0x64, 0x3f, 0x69, 0x66,
    0x3f, 0x69, 0x67, 0x3f, 0x69, 0x68, 0x3f, 0x69, 0x6c, 0x3f, 0x69, 0x6d,
    0x3f, 0x69, 0x6e, 0x3f, 0x69, 0x70, 0x3f, 0x69, 0x72, 0x3f, 0x69, 0x75};
const uint8_t HuffDecoderCommon::table18_7_emit_[108] = {
    0x3f, 0x6f, 0x30, 0x3f, 0x6f, 0x31, 0x3f, 0x6f, 0x32, 0x3f, 0x6f, 0x61,
    0x3f, 0x6f, 0x63, 0x3f, 0x6f, 0x65, 0x3f, 0x6f, 0x69, 0x3f, 0x6f, 0x6f,
    0x3f, 0x6f, 0x73, 0x3f, 0x6f, 0x74, 0x3f, 0x6f, 0x20, 0x3f, 0x6f, 0x25,
    0x3f, 0x6f, 0x2d, 0x3f, 0x6f, 0x2e, 0x3f, 0x6f, 0x2f, 0x3f, 0x6f, 0x33,
    0x3f, 0x6f, 0x34, 0x3f, 0x6f, 0x35, 0x3f, 0x6f, 0x36, 0x3f, 0x6f, 0x37,
    0x3f, 0x6f, 0x38, 0x3f, 0x6f, 0x39, 0x3f, 0x6f, 0x3d, 0x3f, 0x6f, 0x41,
    0x3f, 0x6f, 0x5f, 0x3f, 0x6f, 0x62, 0x3f, 0x6f, 0x64, 0x3f, 0x6f, 0x66,
    0x3f, 0x6f, 0x67, 0x3f, 0x6f, 0x68, 0x3f, 0x6f, 0x6c, 0x3f, 0x6f, 0x6d,
    0x3f, 0x6f, 0x6e, 0x3f, 0x6f, 0x70, 0x3f, 0x6f, 0x72, 0x3f, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table18_8_emit_[108] = {
    0x3f, 0x73, 0x30, 0x3f, 0x73, 0x31, 0x3f, 0x73, 0x32, 0x3f, 0x73, 0x61,
    0x3f, 0x73, 0x63, 0x3f, 0x73, 0x65, 0x3f, 0x73, 0x69, 0x3f, 0x73, 0x6f,
    0x3f, 0x73, 0x73, 0x3f, 0x73, 0x74, 0x3f, 0x73, 0x20, 0x3f, 0x73, 0x25,
    0x3f, 0x73, 0x2d, 0x3f, 0x73, 0x2e, 0x3f, 0x73, 0x2f, 0x3f, 0x73, 0x33,
    0x3f, 0x73, 0x34, 0x3f, 0x73, 0x35, 0x3f, 0x73, 0x36, 0x3f, 0x73, 0x37,
    0x3f, 0x73, 0x38, 0x3f, 0x73, 0x39, 0x3f, 0x73, 0x3d, 0x3f, 0x73, 0x41,
    0x3f, 0x73, 0x5f, 0x3f, 0x73, 0x62, 0x3f, 0x73, 0x64, 0x3f, 0x73, 0x66,
    0x3f, 0x73, 0x67, 0x3f, 0x73, 0x68, 0x3f, 0x73, 0x6c, 0x3f, 0x73, 0x6d,
    0x3f, 0x73, 0x6e, 0x3f, 0x73, 0x70, 0x3f, 0x73, 0x72, 0x3f, 0x73, 0x75};
const uint8_t HuffDecoderCommon::table18_9_emit_[108] = {
    0x3f, 0x74, 0x30, 0x3f, 0x74, 0x31, 0x3f, 0x74, 0x32, 0x3f, 0x74, 0x61,
    0x3f, 0x74, 0x63, 0x3f, 0x74, 0x65, 0x3f, 0x74, 0x69, 0x3f, 0x74, 0x6f,
    0x3f, 0x74, 0x73, 0x3f, 0x74, 0x74, 0x3f, 0x74, 0x20, 0x3f, 0x74, 0x25,
    0x3f, 0x74, 0x2d, 0x3f, 0x74, 0x2e, 0x3f, 0x74, 0x2f, 0x3f, 0x74, 0x33,
    0x3f, 0x74, 0x34, 0x3f, 0x74, 0x35, 0x3f, 0x74, 0x36, 0x3f, 0x74, 0x37,
    0x3f, 0x74, 0x38, 0x3f, 0x74, 0x39, 0x3f, 0x74, 0x3d, 0x3f, 0x74, 0x41,
    0x3f, 0x74, 0x5f, 0x3f, 0x74, 0x62, 0x3f, 0x74, 0x64, 0x3f, 0x74, 0x66,
    0x3f, 0x74, 0x67, 0x3f, 0x74, 0x68, 0x3f, 0x74, 0x6c, 0x3f, 0x74, 0x6d,
    0x3f, 0x74, 0x6e, 0x3f, 0x74, 0x70, 0x3f, 0x74, 0x72, 0x3f, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table18_10_emit_[60] = {
    0x3f, 0x20, 0x30, 0x3f, 0x20, 0x31, 0x3f, 0x20, 0x32, 0x3f, 0x20, 0x61,
    0x3f, 0x20, 0x63, 0x3f, 0x20, 0x65, 0x3f, 0x20, 0x69, 0x3f, 0x20, 0x6f,
    0x3f, 0x20, 0x73, 0x3f, 0x20, 0x74, 0x3f, 0x25, 0x30, 0x3f, 0x25, 0x31,
    0x3f, 0x25, 0x32, 0x3f, 0x25, 0x61, 0x3f, 0x25, 0x63, 0x3f, 0x25, 0x65,
    0x3f, 0x25, 0x69, 0x3f, 0x25, 0x6f, 0x3f, 0x25, 0x73, 0x3f, 0x25, 0x74};
const uint16_t HuffDecoderCommon::table18_10_ops_[64] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9,
    0x00c1, 0x00d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169, 0x0181, 0x0199,
    0x01b1, 0x01c9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f2};
const uint8_t HuffDecoderCommon::table18_11_emit_[60] = {
    0x3f, 0x2d, 0x30, 0x3f, 0x2d, 0x31, 0x3f, 0x2d, 0x32, 0x3f, 0x2d, 0x61,
    0x3f, 0x2d, 0x63, 0x3f, 0x2d, 0x65, 0x3f, 0x2d, 0x69, 0x3f, 0x2d, 0x6f,
    0x3f, 0x2d, 0x73, 0x3f, 0x2d, 0x74, 0x3f, 0x2e, 0x30, 0x3f, 0x2e, 0x31,
    0x3f, 0x2e, 0x32, 0x3f, 0x2e, 0x61, 0x3f, 0x2e, 0x63, 0x3f, 0x2e, 0x65,
    0x3f, 0x2e, 0x69, 0x3f, 0x2e, 0x6f, 0x3f, 0x2e, 0x73, 0x3f, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table18_12_emit_[60] = {
    0x3f, 0x2f, 0x30, 0x3f, 0x2f, 0x31, 0x3f, 0x2f, 0x32, 0x3f, 0x2f, 0x61,
    0x3f, 0x2f, 0x63, 0x3f, 0x2f, 0x65, 0x3f, 0x2f, 0x69, 0x3f, 0x2f, 0x6f,
    0x3f, 0x2f, 0x73, 0x3f, 0x2f, 0x74, 0x3f, 0x33, 0x30, 0x3f, 0x33, 0x31,
    0x3f, 0x33, 0x32, 0x3f, 0x33, 0x61, 0x3f, 0x33, 0x63, 0x3f, 0x33, 0x65,
    0x3f, 0x33, 0x69, 0x3f, 0x33, 0x6f, 0x3f, 0x33, 0x73, 0x3f, 0x33, 0x74};
const uint8_t HuffDecoderCommon::table18_13_emit_[60] = {
    0x3f, 0x34, 0x30, 0x3f, 0x34, 0x31, 0x3f, 0x34, 0x32, 0x3f, 0x34, 0x61,
    0x3f, 0x34, 0x63, 0x3f, 0x34, 0x65, 0x3f, 0x34, 0x69, 0x3f, 0x34, 0x6f,
    0x3f, 0x34, 0x73, 0x3f, 0x34, 0x74, 0x3f, 0x35, 0x30, 0x3f, 0x35, 0x31,
    0x3f, 0x35, 0x32, 0x3f, 0x35, 0x61, 0x3f, 0x35, 0x63, 0x3f, 0x35, 0x65,
    0x3f, 0x35, 0x69, 0x3f, 0x35, 0x6f, 0x3f, 0x35, 0x73, 0x3f, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table18_14_emit_[60] = {
    0x3f, 0x36, 0x30, 0x3f, 0x36, 0x31, 0x3f, 0x36, 0x32, 0x3f, 0x36, 0x61,
    0x3f, 0x36, 0x63, 0x3f, 0x36, 0x65, 0x3f, 0x36, 0x69, 0x3f, 0x36, 0x6f,
    0x3f, 0x36, 0x73, 0x3f, 0x36, 0x74, 0x3f, 0x37, 0x30, 0x3f, 0x37, 0x31,
    0x3f, 0x37, 0x32, 0x3f, 0x37, 0x61, 0x3f, 0x37, 0x63, 0x3f, 0x37, 0x65,
    0x3f, 0x37, 0x69, 0x3f, 0x37, 0x6f, 0x3f, 0x37, 0x73, 0x3f, 0x37, 0x74};
const uint8_t HuffDecoderCommon::table18_15_emit_[60] = {
    0x3f, 0x38, 0x30, 0x3f, 0x38, 0x31, 0x3f, 0x38, 0x32, 0x3f, 0x38, 0x61,
    0x3f, 0x38, 0x63, 0x3f, 0x38, 0x65, 0x3f, 0x38, 0x69, 0x3f, 0x38, 0x6f,
    0x3f, 0x38, 0x73, 0x3f, 0x38, 0x74, 0x3f, 0x39, 0x30, 0x3f, 0x39, 0x31,
    0x3f, 0x39, 0x32, 0x3f, 0x39, 0x61, 0x3f, 0x39, 0x63, 0x3f, 0x39, 0x65,
    0x3f, 0x39, 0x69, 0x3f, 0x39, 0x6f, 0x3f, 0x39, 0x73, 0x3f, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table18_16_emit_[60] = {
    0x3f, 0x3d, 0x30, 0x3f, 0x3d, 0x31, 0x3f, 0x3d, 0x32, 0x3f, 0x3d, 0x61,
    0x3f, 0x3d, 0x63, 0x3f, 0x3d, 0x65, 0x3f, 0x3d, 0x69, 0x3f, 0x3d, 0x6f,
    0x3f, 0x3d, 0x73, 0x3f, 0x3d, 0x74, 0x3f, 0x41, 0x30, 0x3f, 0x41, 0x31,
    0x3f, 0x41, 0x32, 0x3f, 0x41, 0x61, 0x3f, 0x41, 0x63, 0x3f, 0x41, 0x65,
    0x3f, 0x41, 0x69, 0x3f, 0x41, 0x6f, 0x3f, 0x41, 0x73, 0x3f, 0x41, 0x74};
const uint8_t HuffDecoderCommon::table18_17_emit_[60] = {
    0x3f, 0x5f, 0x30, 0x3f, 0x5f, 0x31, 0x3f, 0x5f, 0x32, 0x3f, 0x5f, 0x61,
    0x3f, 0x5f, 0x63, 0x3f, 0x5f, 0x65, 0x3f, 0x5f, 0x69, 0x3f, 0x5f, 0x6f,
    0x3f, 0x5f, 0x73, 0x3f, 0x5f, 0x74, 0x3f, 0x62, 0x30, 0x3f, 0x62, 0x31,
    0x3f, 0x62, 0x32, 0x3f, 0x62, 0x61, 0x3f, 0x62, 0x63, 0x3f, 0x62, 0x65,
    0x3f, 0x62, 0x69, 0x3f, 0x62, 0x6f, 0x3f, 0x62, 0x73, 0x3f, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table18_18_emit_[60] = {
    0x3f, 0x64, 0x30, 0x3f, 0x64, 0x31, 0x3f, 0x64, 0x32, 0x3f, 0x64, 0x61,
    0x3f, 0x64, 0x63, 0x3f, 0x64, 0x65, 0x3f, 0x64, 0x69, 0x3f, 0x64, 0x6f,
    0x3f, 0x64, 0x73, 0x3f, 0x64, 0x74, 0x3f, 0x66, 0x30, 0x3f, 0x66, 0x31,
    0x3f, 0x66, 0x32, 0x3f, 0x66, 0x61, 0x3f, 0x66, 0x63, 0x3f, 0x66, 0x65,
    0x3f, 0x66, 0x69, 0x3f, 0x66, 0x6f, 0x3f, 0x66, 0x73, 0x3f, 0x66, 0x74};
const uint8_t HuffDecoderCommon::table18_19_emit_[60] = {
    0x3f, 0x67, 0x30, 0x3f, 0x67, 0x31, 0x3f, 0x67, 0x32, 0x3f, 0x67, 0x61,
    0x3f, 0x67, 0x63, 0x3f, 0x67, 0x65, 0x3f, 0x67, 0x69, 0x3f, 0x67, 0x6f,
    0x3f, 0x67, 0x73, 0x3f, 0x67, 0x74, 0x3f, 0x68, 0x30, 0x3f, 0x68, 0x31,
    0x3f, 0x68, 0x32, 0x3f, 0x68, 0x61, 0x3f, 0x68, 0x63, 0x3f, 0x68, 0x65,
    0x3f, 0x68, 0x69, 0x3f, 0x68, 0x6f, 0x3f, 0x68, 0x73, 0x3f, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table18_20_emit_[60] = {
    0x3f, 0x6c, 0x30, 0x3f, 0x6c, 0x31, 0x3f, 0x6c, 0x32, 0x3f, 0x6c, 0x61,
    0x3f, 0x6c, 0x63, 0x3f, 0x6c, 0x65, 0x3f, 0x6c, 0x69, 0x3f, 0x6c, 0x6f,
    0x3f, 0x6c, 0x73, 0x3f, 0x6c, 0x74, 0x3f, 0x6d, 0x30, 0x3f, 0x6d, 0x31,
    0x3f, 0x6d, 0x32, 0x3f, 0x6d, 0x61, 0x3f, 0x6d, 0x63, 0x3f, 0x6d, 0x65,
    0x3f, 0x6d, 0x69, 0x3f, 0x6d, 0x6f, 0x3f, 0x6d, 0x73, 0x3f, 0x6d, 0x74};
const uint8_t HuffDecoderCommon::table18_21_emit_[60] = {
    0x3f, 0x6e, 0x30, 0x3f, 0x6e, 0x31, 0x3f, 0x6e, 0x32, 0x3f, 0x6e, 0x61,
    0x3f, 0x6e, 0x63, 0x3f, 0x6e, 0x65, 0x3f, 0x6e, 0x69, 0x3f, 0x6e, 0x6f,
    0x3f, 0x6e, 0x73, 0x3f, 0x6e, 0x74, 0x3f, 0x70, 0x30, 0x3f, 0x70, 0x31,
    0x3f, 0x70, 0x32, 0x3f, 0x70, 0x61, 0x3f, 0x70, 0x63, 0x3f, 0x70, 0x65,
    0x3f, 0x70, 0x69, 0x3f, 0x70, 0x6f, 0x3f, 0x70, 0x73, 0x3f, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table18_22_emit_[60] = {
    0x3f, 0x72, 0x30, 0x3f, 0x72, 0x31, 0x3f, 0x72, 0x32, 0x3f, 0x72, 0x61,
    0x3f, 0x72, 0x63, 0x3f, 0x72, 0x65, 0x3f, 0x72, 0x69, 0x3f, 0x72, 0x6f,
    0x3f, 0x72, 0x73, 0x3f, 0x72, 0x74, 0x3f, 0x75, 0x30, 0x3f, 0x75, 0x31,
    0x3f, 0x75, 0x32, 0x3f, 0x75, 0x61, 0x3f, 0x75, 0x63, 0x3f, 0x75, 0x65,
    0x3f, 0x75, 0x69, 0x3f, 0x75, 0x6f, 0x3f, 0x75, 0x73, 0x3f, 0x75, 0x74};
const uint8_t HuffDecoderCommon::table18_23_emit_[8] = {0x3f, 0x3a, 0x3f, 0x42,
                                                        0x3f, 0x43, 0x3f, 0x44};
const uint16_t HuffDecoderCommon::table18_23_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0032};
const uint8_t HuffDecoderCommon::table18_24_emit_[8] = {0x3f, 0x45, 0x3f, 0x46,
                                                        0x3f, 0x47, 0x3f, 0x48};
const uint8_t HuffDecoderCommon::table18_25_emit_[8] = {0x3f, 0x49, 0x3f, 0x4a,
                                                        0x3f, 0x4b, 0x3f, 0x4c};
const uint8_t HuffDecoderCommon::table18_26_emit_[8] = {0x3f, 0x4d, 0x3f, 0x4e,
                                                        0x3f, 0x4f, 0x3f, 0x50};
const uint8_t HuffDecoderCommon::table18_27_emit_[8] = {0x3f, 0x51, 0x3f, 0x52,
                                                        0x3f, 0x53, 0x3f, 0x54};
const uint8_t HuffDecoderCommon::table18_28_emit_[8] = {0x3f, 0x55, 0x3f, 0x56,
                                                        0x3f, 0x57, 0x3f, 0x59};
const uint8_t HuffDecoderCommon::table18_29_emit_[8] = {0x3f, 0x6a, 0x3f, 0x6b,
                                                        0x3f, 0x71, 0x3f, 0x76};
const uint8_t HuffDecoderCommon::table18_30_emit_[8] = {0x3f, 0x77, 0x3f, 0x78,
                                                        0x3f, 0x79, 0x3f, 0x7a};
const uint8_t HuffDecoderCommon::table18_31_emit_[27] = {
    0x3f, 0x26, 0x3f, 0x2a, 0x3f, 0x2c, 0x3f, 0x3b, 0x3f,
    0x58, 0x3f, 0x5a, 0x3f, 0x21, 0x3f, 0x22, 0x3f, 0x28,
    0x3f, 0x29, 0x3f, 0x3f, 0x27, 0x3f, 0x2b, 0x3f, 0x7c};
const uint16_t HuffDecoderCommon::table18_31_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0032,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052,
    0x0000, 0x0062, 0x0000, 0x0072, 0x0000, 0x0082, 0x0000, 0x0092,
    0x0000, 0x00a2, 0x00aa, 0x00ba, 0x00ca, 0x0000, 0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table18_32_emit_[60] = {
    0x27, 0x30, 0x30, 0x27, 0x30, 0x31, 0x27, 0x30, 0x32, 0x27, 0x30, 0x61,
    0x27, 0x30, 0x63, 0x27, 0x30, 0x65, 0x27, 0x30, 0x69, 0x27, 0x30, 0x6f,
    0x27, 0x30, 0x73, 0x27, 0x30, 0x74, 0x27, 0x31, 0x30, 0x27, 0x31, 0x31,
    0x27, 0x31, 0x32, 0x27, 0x31, 0x61, 0x27, 0x31, 0x63, 0x27, 0x31, 0x65,
    0x27, 0x31, 0x69, 0x27, 0x31, 0x6f, 0x27, 0x31, 0x73, 0x27, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table18_33_emit_[60] = {
    0x27, 0x32, 0x30, 0x27, 0x32, 0x31, 0x27, 0x32, 0x32, 0x27, 0x32, 0x61,
    0x27, 0x32, 0x63, 0x27, 0x32, 0x65, 0x27, 0x32, 0x69, 0x27, 0x32, 0x6f,
    0x27, 0x32, 0x73, 0x27, 0x32, 0x74, 0x27, 0x61, 0x30, 0x27, 0x61, 0x31,
    0x27, 0x61, 0x32, 0x27, 0x61, 0x61, 0x27, 0x61, 0x63, 0x27, 0x61, 0x65,
    0x27, 0x61, 0x69, 0x27, 0x61, 0x6f, 0x27, 0x61, 0x73, 0x27, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table18_34_emit_[60] = {
    0x27, 0x63, 0x30, 0x27, 0x63, 0x31, 0x27, 0x63, 0x32, 0x27, 0x63, 0x61,
    0x27, 0x63, 0x63, 0x27, 0x63, 0x65, 0x27, 0x63, 0x69, 0x27, 0x63, 0x6f,
    0x27, 0x63, 0x73, 0x27, 0x63, 0x74, 0x27, 0x65, 0x30, 0x27, 0x65, 0x31,
    0x27, 0x65, 0x32, 0x27, 0x65, 0x61, 0x27, 0x65, 0x63, 0x27, 0x65, 0x65,
    0x27, 0x65, 0x69, 0x27, 0x65, 0x6f, 0x27, 0x65, 0x73, 0x27, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table18_35_emit_[60] = {
    0x27, 0x69, 0x30, 0x27, 0x69, 0x31, 0x27, 0x69, 0x32, 0x27, 0x69, 0x61,
    0x27, 0x69, 0x63, 0x27, 0x69, 0x65, 0x27, 0x69, 0x69, 0x27, 0x69, 0x6f,
    0x27, 0x69, 0x73, 0x27, 0x69, 0x74, 0x27, 0x6f, 0x30, 0x27, 0x6f, 0x31,
    0x27, 0x6f, 0x32, 0x27, 0x6f, 0x61, 0x27, 0x6f, 0x63, 0x27, 0x6f, 0x65,
    0x27, 0x6f, 0x69, 0x27, 0x6f, 0x6f, 0x27, 0x6f, 0x73, 0x27, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table18_36_emit_[60] = {
    0x27, 0x73, 0x30, 0x27, 0x73, 0x31, 0x27, 0x73, 0x32, 0x27, 0x73, 0x61,
    0x27, 0x73, 0x63, 0x27, 0x73, 0x65, 0x27, 0x73, 0x69, 0x27, 0x73, 0x6f,
    0x27, 0x73, 0x73, 0x27, 0x73, 0x74, 0x27, 0x74, 0x30, 0x27, 0x74, 0x31,
    0x27, 0x74, 0x32, 0x27, 0x74, 0x61, 0x27, 0x74, 0x63, 0x27, 0x74, 0x65,
    0x27, 0x74, 0x69, 0x27, 0x74, 0x6f, 0x27, 0x74, 0x73, 0x27, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table18_37_emit_[8] = {0x27, 0x20, 0x27, 0x25,
                                                        0x27, 0x2d, 0x27, 0x2e};
const uint8_t HuffDecoderCommon::table18_38_emit_[8] = {0x27, 0x2f, 0x27, 0x33,
                                                        0x27, 0x34, 0x27, 0x35};
const uint8_t HuffDecoderCommon::table18_39_emit_[8] = {0x27, 0x36, 0x27, 0x37,
                                                        0x27, 0x38, 0x27, 0x39};
const uint8_t HuffDecoderCommon::table18_40_emit_[8] = {0x27, 0x3d, 0x27, 0x41,
                                                        0x27, 0x5f, 0x27, 0x62};
const uint8_t HuffDecoderCommon::table18_41_emit_[8] = {0x27, 0x64, 0x27, 0x66,
                                                        0x27, 0x67, 0x27, 0x68};
const uint8_t HuffDecoderCommon::table18_42_emit_[8] = {0x27, 0x6c, 0x27, 0x6d,
                                                        0x27, 0x6e, 0x27, 0x70};
const uint8_t HuffDecoderCommon::table18_43_emit_[12] = {
    0x27, 0x72, 0x27, 0x75, 0x27, 0x3a, 0x27, 0x42, 0x27, 0x43, 0x27, 0x44};
const uint16_t HuffDecoderCommon::table18_43_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0032,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052};
const uint8_t HuffDecoderCommon::table18_44_emit_[16] = {
    0x27, 0x45, 0x27, 0x46, 0x27, 0x47, 0x27, 0x48,
    0x27, 0x49, 0x27, 0x4a, 0x27, 0x4b, 0x27, 0x4c};
const uint16_t HuffDecoderCommon::table18_44_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0032,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0062,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0072};
const uint8_t HuffDecoderCommon::table18_45_emit_[16] = {
    0x27, 0x4d, 0x27, 0x4e, 0x27, 0x4f, 0x27, 0x50,
    0x27, 0x51, 0x27, 0x52, 0x27, 0x53, 0x27, 0x54};
const uint8_t HuffDecoderCommon::table18_46_emit_[16] = {
    0x27, 0x55, 0x27, 0x56, 0x27, 0x57, 0x27, 0x59,
    0x27, 0x6a, 0x27, 0x6b, 0x27, 0x71, 0x27, 0x76};
const uint8_t HuffDecoderCommon::table18_47_emit_[30] = {
    0x27, 0x77, 0x27, 0x78, 0x27, 0x79, 0x27, 0x7a, 0x27, 0x26,
    0x27, 0x2a, 0x27, 0x2c, 0x27, 0x3b, 0x27, 0x58, 0x27, 0x5a,
    0x27, 0x21, 0x27, 0x22, 0x27, 0x28, 0x27, 0x29, 0x27, 0x3f};
const uint16_t HuffDecoderCommon::table18_47_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0032,
    0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052,
    0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0072,
    0x0000, 0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0092,
    0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x0000, 0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table18_48_emit_[60] = {
    0x2b, 0x30, 0x30, 0x2b, 0x30, 0x31, 0x2b, 0x30, 0x32, 0x2b, 0x30, 0x61,
    0x2b, 0x30, 0x63, 0x2b, 0x30, 0x65, 0x2b, 0x30, 0x69, 0x2b, 0x30, 0x6f,
    0x2b, 0x30, 0x73, 0x2b, 0x30, 0x74, 0x2b, 0x31, 0x30, 0x2b, 0x31, 0x31,
    0x2b, 0x31, 0x32, 0x2b, 0x31, 0x61, 0x2b, 0x31, 0x63, 0x2b, 0x31, 0x65,
    0x2b, 0x31, 0x69, 0x2b, 0x31, 0x6f, 0x2b, 0x31, 0x73, 0x2b, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table18_49_emit_[60] = {
    0x2b, 0x32, 0x30, 0x2b, 0x32, 0x31, 0x2b, 0x32, 0x32, 0x2b, 0x32, 0x61,
    0x2b, 0x32, 0x63, 0x2b, 0x32, 0x65, 0x2b, 0x32, 0x69, 0x2b, 0x32, 0x6f,
    0x2b, 0x32, 0x73, 0x2b, 0x32, 0x74, 0x2b, 0x61, 0x30, 0x2b, 0x61, 0x31,
    0x2b, 0x61, 0x32, 0x2b, 0x61, 0x61, 0x2b, 0x61, 0x63, 0x2b, 0x61, 0x65,
    0x2b, 0x61, 0x69, 0x2b, 0x61, 0x6f, 0x2b, 0x61, 0x73, 0x2b, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table18_50_emit_[60] = {
    0x2b, 0x63, 0x30, 0x2b, 0x63, 0x31, 0x2b, 0x63, 0x32, 0x2b, 0x63, 0x61,
    0x2b, 0x63, 0x63, 0x2b, 0x63, 0x65, 0x2b, 0x63, 0x69, 0x2b, 0x63, 0x6f,
    0x2b, 0x63, 0x73, 0x2b, 0x63, 0x74, 0x2b, 0x65, 0x30, 0x2b, 0x65, 0x31,
    0x2b, 0x65, 0x32, 0x2b, 0x65, 0x61, 0x2b, 0x65, 0x63, 0x2b, 0x65, 0x65,
    0x2b, 0x65, 0x69, 0x2b, 0x65, 0x6f, 0x2b, 0x65, 0x73, 0x2b, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table18_51_emit_[60] = {
    0x2b, 0x69, 0x30, 0x2b, 0x69, 0x31, 0x2b, 0x69, 0x32, 0x2b, 0x69, 0x61,
    0x2b, 0x69, 0x63, 0x2b, 0x69, 0x65, 0x2b, 0x69, 0x69, 0x2b, 0x69, 0x6f,
    0x2b, 0x69, 0x73, 0x2b, 0x69, 0x74, 0x2b, 0x6f, 0x30, 0x2b, 0x6f, 0x31,
    0x2b, 0x6f, 0x32, 0x2b, 0x6f, 0x61, 0x2b, 0x6f, 0x63, 0x2b, 0x6f, 0x65,
    0x2b, 0x6f, 0x69, 0x2b, 0x6f, 0x6f, 0x2b, 0x6f, 0x73, 0x2b, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table18_52_emit_[60] = {
    0x2b, 0x73, 0x30, 0x2b, 0x73, 0x31, 0x2b, 0x73, 0x32, 0x2b, 0x73, 0x61,
    0x2b, 0x73, 0x63, 0x2b, 0x73, 0x65, 0x2b, 0x73, 0x69, 0x2b, 0x73, 0x6f,
    0x2b, 0x73, 0x73, 0x2b, 0x73, 0x74, 0x2b, 0x74, 0x30, 0x2b, 0x74, 0x31,
    0x2b, 0x74, 0x32, 0x2b, 0x74, 0x61, 0x2b, 0x74, 0x63, 0x2b, 0x74, 0x65,
    0x2b, 0x74, 0x69, 0x2b, 0x74, 0x6f, 0x2b, 0x74, 0x73, 0x2b, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table18_53_emit_[8] = {0x2b, 0x20, 0x2b, 0x25,
                                                        0x2b, 0x2d, 0x2b, 0x2e};
const uint8_t HuffDecoderCommon::table18_54_emit_[8] = {0x2b, 0x2f, 0x2b, 0x33,
                                                        0x2b, 0x34, 0x2b, 0x35};
const uint8_t HuffDecoderCommon::table18_55_emit_[8] = {0x2b, 0x36, 0x2b, 0x37,
                                                        0x2b, 0x38, 0x2b, 0x39};
const uint8_t HuffDecoderCommon::table18_56_emit_[8] = {0x2b, 0x3d, 0x2b, 0x41,
                                                        0x2b, 0x5f, 0x2b, 0x62};
const uint8_t HuffDecoderCommon::table18_57_emit_[8] = {0x2b, 0x64, 0x2b, 0x66,
                                                        0x2b, 0x67, 0x2b, 0x68};
const uint8_t HuffDecoderCommon::table18_58_emit_[8] = {0x2b, 0x6c, 0x2b, 0x6d,
                                                        0x2b, 0x6e, 0x2b, 0x70};
const uint8_t HuffDecoderCommon::table18_59_emit_[12] = {
    0x2b, 0x72, 0x2b, 0x75, 0x2b, 0x3a, 0x2b, 0x42, 0x2b, 0x43, 0x2b, 0x44};
const uint8_t HuffDecoderCommon::table18_60_emit_[16] = {
    0x2b, 0x45, 0x2b, 0x46, 0x2b, 0x47, 0x2b, 0x48,
    0x2b, 0x49, 0x2b, 0x4a, 0x2b, 0x4b, 0x2b, 0x4c};
const uint8_t HuffDecoderCommon::table18_61_emit_[16] = {
    0x2b, 0x4d, 0x2b, 0x4e, 0x2b, 0x4f, 0x2b, 0x50,
    0x2b, 0x51, 0x2b, 0x52, 0x2b, 0x53, 0x2b, 0x54};
const uint8_t HuffDecoderCommon::table18_62_emit_[16] = {
    0x2b, 0x55, 0x2b, 0x56, 0x2b, 0x57, 0x2b, 0x59,
    0x2b, 0x6a, 0x2b, 0x6b, 0x2b, 0x71, 0x2b, 0x76};
const uint8_t HuffDecoderCommon::table18_63_emit_[30] = {
    0x2b, 0x77, 0x2b, 0x78, 0x2b, 0x79, 0x2b, 0x7a, 0x2b, 0x26,
    0x2b, 0x2a, 0x2b, 0x2c, 0x2b, 0x3b, 0x2b, 0x58, 0x2b, 0x5a,
    0x2b, 0x21, 0x2b, 0x22, 0x2b, 0x28, 0x2b, 0x29, 0x2b, 0x3f};
const uint8_t HuffDecoderCommon::table18_64_emit_[60] = {
    0x7c, 0x30, 0x30, 0x7c, 0x30, 0x31, 0x7c, 0x30, 0x32, 0x7c, 0x30, 0x61,
    0x7c, 0x30, 0x63, 0x7c, 0x30, 0x65, 0x7c, 0x30, 0x69, 0x7c, 0x30, 0x6f,
    0x7c, 0x30, 0x73, 0x7c, 0x30, 0x74, 0x7c, 0x31, 0x30, 0x7c, 0x31, 0x31,
    0x7c, 0x31, 0x32, 0x7c, 0x31, 0x61, 0x7c, 0x31, 0x63, 0x7c, 0x31, 0x65,
    0x7c, 0x31, 0x69, 0x7c, 0x31, 0x6f, 0x7c, 0x31, 0x73, 0x7c, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table18_65_emit_[60] = {
    0x7c, 0x32, 0x30, 0x7c, 0x32, 0x31, 0x7c, 0x32, 0x32, 0x7c, 0x32, 0x61,
    0x7c, 0x32, 0x63, 0x7c, 0x32, 0x65, 0x7c, 0x32, 0x69, 0x7c, 0x32, 0x6f,
    0x7c, 0x32, 0x73, 0x7c, 0x32, 0x74, 0x7c, 0x61, 0x30, 0x7c, 0x61, 0x31,
    0x7c, 0x61, 0x32, 0x7c, 0x61, 0x61, 0x7c, 0x61, 0x63, 0x7c, 0x61, 0x65,
    0x7c, 0x61, 0x69, 0x7c, 0x61, 0x6f, 0x7c, 0x61, 0x73, 0x7c, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table18_66_emit_[60] = {
    0x7c, 0x63, 0x30, 0x7c, 0x63, 0x31, 0x7c, 0x63, 0x32, 0x7c, 0x63, 0x61,
    0x7c, 0x63, 0x63, 0x7c, 0x63, 0x65, 0x7c, 0x63, 0x69, 0x7c, 0x63, 0x6f,
    0x7c, 0x63, 0x73, 0x7c, 0x63, 0x74, 0x7c, 0x65, 0x30, 0x7c, 0x65, 0x31,
    0x7c, 0x65, 0x32, 0x7c, 0x65, 0x61, 0x7c, 0x65, 0x63, 0x7c, 0x65, 0x65,
    0x7c, 0x65, 0x69, 0x7c, 0x65, 0x6f, 0x7c, 0x65, 0x73, 0x7c, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table18_67_emit_[60] = {
    0x7c, 0x69, 0x30, 0x7c, 0x69, 0x31, 0x7c, 0x69, 0x32, 0x7c, 0x69, 0x61,
    0x7c, 0x69, 0x63, 0x7c, 0x69, 0x65, 0x7c, 0x69, 0x69, 0x7c, 0x69, 0x6f,
    0x7c, 0x69, 0x73, 0x7c, 0x69, 0x74, 0x7c, 0x6f, 0x30, 0x7c, 0x6f, 0x31,
    0x7c, 0x6f, 0x32, 0x7c, 0x6f, 0x61, 0x7c, 0x6f, 0x63, 0x7c, 0x6f, 0x65,
    0x7c, 0x6f, 0x69, 0x7c, 0x6f, 0x6f, 0x7c, 0x6f, 0x73, 0x7c, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table18_68_emit_[60] = {
    0x7c, 0x73, 0x30, 0x7c, 0x73, 0x31, 0x7c, 0x73, 0x32, 0x7c, 0x73, 0x61,
    0x7c, 0x73, 0x63, 0x7c, 0x73, 0x65, 0x7c, 0x73, 0x69, 0x7c, 0x73, 0x6f,
    0x7c, 0x73, 0x73, 0x7c, 0x73, 0x74, 0x7c, 0x74, 0x30, 0x7c, 0x74, 0x31,
    0x7c, 0x74, 0x32, 0x7c, 0x74, 0x61, 0x7c, 0x74, 0x63, 0x7c, 0x74, 0x65,
    0x7c, 0x74, 0x69, 0x7c, 0x74, 0x6f, 0x7c, 0x74, 0x73, 0x7c, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table18_69_emit_[8] = {0x7c, 0x20, 0x7c, 0x25,
                                                        0x7c, 0x2d, 0x7c, 0x2e};
const uint8_t HuffDecoderCommon::table18_70_emit_[8] = {0x7c, 0x2f, 0x7c, 0x33,
                                                        0x7c, 0x34, 0x7c, 0x35};
const uint8_t HuffDecoderCommon::table18_71_emit_[8] = {0x7c, 0x36, 0x7c, 0x37,
                                                        0x7c, 0x38, 0x7c, 0x39};
const uint8_t HuffDecoderCommon::table18_72_emit_[8] = {0x7c, 0x3d, 0x7c, 0x41,
                                                        0x7c, 0x5f, 0x7c, 0x62};
const uint8_t HuffDecoderCommon::table18_73_emit_[8] = {0x7c, 0x64, 0x7c, 0x66,
                                                        0x7c, 0x67, 0x7c, 0x68};
const uint8_t HuffDecoderCommon::table18_74_emit_[8] = {0x7c, 0x6c, 0x7c, 0x6d,
                                                        0x7c, 0x6e, 0x7c, 0x70};
const uint8_t HuffDecoderCommon::table18_75_emit_[12] = {
    0x7c, 0x72, 0x7c, 0x75, 0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44};
const uint8_t HuffDecoderCommon::table18_76_emit_[16] = {
    0x7c, 0x45, 0x7c, 0x46, 0x7c, 0x47, 0x7c, 0x48,
    0x7c, 0x49, 0x7c, 0x4a, 0x7c, 0x4b, 0x7c, 0x4c};
const uint8_t HuffDecoderCommon::table18_77_emit_[16] = {
    0x7c, 0x4d, 0x7c, 0x4e, 0x7c, 0x4f, 0x7c, 0x50,
    0x7c, 0x51, 0x7c, 0x52, 0x7c, 0x53, 0x7c, 0x54};
const uint8_t HuffDecoderCommon::table18_78_emit_[16] = {
    0x7c, 0x55, 0x7c, 0x56, 0x7c, 0x57, 0x7c, 0x59,
    0x7c, 0x6a, 0x7c, 0x6b, 0x7c, 0x71, 0x7c, 0x76};
const uint8_t HuffDecoderCommon::table18_79_emit_[30] = {
    0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a, 0x7c, 0x26,
    0x7c, 0x2a, 0x7c, 0x2c, 0x7c, 0x3b, 0x7c, 0x58, 0x7c, 0x5a,
    0x7c, 0x21, 0x7c, 0x22, 0x7c, 0x28, 0x7c, 0x29, 0x7c, 0x3f};
const uint8_t HuffDecoderCommon::table18_80_emit_[8] = {0x23, 0x30, 0x23, 0x31,
                                                        0x23, 0x32, 0x23, 0x61};
const uint8_t HuffDecoderCommon::table18_81_emit_[8] = {0x23, 0x63, 0x23, 0x65,
                                                        0x23, 0x69, 0x23, 0x6f};
const uint8_t HuffDecoderCommon::table18_82_emit_[12] = {
    0x23, 0x73, 0x23, 0x74, 0x23, 0x20, 0x23, 0x25, 0x23, 0x2d, 0x23, 0x2e};
const uint8_t HuffDecoderCommon::table18_83_emit_[16] = {
    0x23, 0x2f, 0x23, 0x33, 0x23, 0x34, 0x23, 0x35,
    0x23, 0x36, 0x23, 0x37, 0x23, 0x38, 0x23, 0x39};
const uint8_t HuffDecoderCommon::table18_84_emit_[16] = {
    0x23, 0x3d, 0x23, 0x41, 0x23, 0x5f, 0x23, 0x62,
    0x23, 0x64, 0x23, 0x66, 0x23, 0x67, 0x23, 0x68};
const uint8_t HuffDecoderCommon::table18_85_emit_[20] = {
    0x23, 0x6c, 0x23, 0x6d, 0x23, 0x6e, 0x23, 0x70, 0x23, 0x72,
    0x23, 0x75, 0x23, 0x3a, 0x23, 0x42, 0x23, 0x43, 0x23, 0x44};
const uint16_t HuffDecoderCommon::table18_85_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0032,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052,
    0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0072,
    0x0000, 0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0092};
const uint8_t HuffDecoderCommon::table18_86_emit_[32] = {
    0x23, 0x45, 0x23, 0x46, 0x23, 0x47, 0x23, 0x48, 0x23, 0x49, 0x23,
    0x4a, 0x23, 0x4b, 0x23, 0x4c, 0x23, 0x4d, 0x23, 0x4e, 0x23, 0x4f,
    0x23, 0x50, 0x23, 0x51, 0x23, 0x52, 0x23, 0x53, 0x23, 0x54};
const uint16_t HuffDecoderCommon::table18_86_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0032,
    0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052,
    0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0072,
    0x0000, 0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0092,
    0x0000, 0x0000, 0x0000, 0x00a2, 0x0000, 0x0000, 0x0000, 0x00b2,
    0x0000, 0x0000, 0x0000, 0x00c2, 0x0000, 0x0000, 0x0000, 0x00d2,
    0x0000, 0x0000, 0x0000, 0x00e2, 0x0000, 0x0000, 0x0000, 0x00f2};
const uint8_t HuffDecoderCommon::table18_87_emit_[36] = {
    0x23, 0x55, 0x23, 0x56, 0x23, 0x57, 0x23, 0x59, 0x23, 0x6a, 0x23, 0x6b,
    0x23, 0x71, 0x23, 0x76, 0x23, 0x77, 0x23, 0x78, 0x23, 0x79, 0x23, 0x7a,
    0x23, 0x26, 0x23, 0x2a, 0x23, 0x2c, 0x23, 0x3b, 0x23, 0x58, 0x23, 0x5a};
const uint16_t HuffDecoderCommon::table18_87_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0032,
    0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052,
    0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0072,
    0x0000, 0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0092,
    0x0000, 0x0000, 0x0000, 0x00a2, 0x0000, 0x0000, 0x0000, 0x00b2,
    0x0000, 0x00c2, 0x0000, 0x00d2, 0x0000, 0x00e2, 0x0000, 0x00f2,
    0x0000, 0x0102, 0x0000, 0x0112, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table18_88_emit_[8] = {0x3e, 0x30, 0x3e, 0x31,
                                                        0x3e, 0x32, 0x3e, 0x61};
const uint8_t HuffDecoderCommon::table18_89_emit_[8] = {0x3e, 0x63, 0x3e, 0x65,
                                                        0x3e, 0x69, 0x3e, 0x6f};
const uint8_t HuffDecoderCommon::table18_90_emit_[12] = {
    0x3e, 0x73, 0x3e, 0x74, 0x3e, 0x20, 0x3e, 0x25, 0x3e, 0x2d, 0x3e, 0x2e};
const uint8_t HuffDecoderCommon::table18_91_emit_[16] = {
    0x3e, 0x2f, 0x3e, 0x33, 0x3e, 0x34, 0x3e, 0x35,
    0x3e, 0x36, 0x3e, 0x37, 0x3e, 0x38, 0x3e, 0x39};
const uint8_t HuffDecoderCommon::table18_92_emit_[16] = {
    0x3e, 0x3d, 0x3e, 0x41, 0x3e, 0x5f, 0x3e, 0x62,
    0x3e, 0x64, 0x3e, 0x66, 0x3e, 0x67, 0x3e, 0x68};
const uint8_t HuffDecoderCommon::table18_93_emit_[20] = {
    0x3e, 0x6c, 0x3e, 0x6d, 0x3e, 0x6e, 0x3e, 0x70, 0x3e, 0x72,
    0x3e, 0x75, 0x3e, 0x3a, 0x3e, 0x42, 0x3e, 0x43, 0x3e, 0x44};
const uint8_t HuffDecoderCommon::table18_94_emit_[32] = {
    0x3e, 0x45, 0x3e, 0x46, 0x3e, 0x47, 0x3e, 0x48, 0x3e, 0x49, 0x3e,
    0x4a, 0x3e, 0x4b, 0x3e, 0x4c, 0x3e, 0x4d, 0x3e, 0x4e, 0x3e, 0x4f,
    0x3e, 0x50, 0x3e, 0x51, 0x3e, 0x52, 0x3e, 0x53, 0x3e, 0x54};
const uint8_t HuffDecoderCommon::table18_95_emit_[36] = {
    0x3e, 0x55, 0x3e, 0x56, 0x3e, 0x57, 0x3e, 0x59, 0x3e, 0x6a, 0x3e, 0x6b,
    0x3e, 0x71, 0x3e, 0x76, 0x3e, 0x77, 0x3e, 0x78, 0x3e, 0x79, 0x3e, 0x7a,
    0x3e, 0x26, 0x3e, 0x2a, 0x3e, 0x2c, 0x3e, 0x3b, 0x3e, 0x58, 0x3e, 0x5a};
const uint8_t HuffDecoderCommon::table18_96_emit_[16] = {
    0x00, 0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x61,
    0x00, 0x63, 0x00, 0x65, 0x00, 0x69, 0x00, 0x6f};
const uint8_t HuffDecoderCommon::table18_97_emit_[28] = {
    0x00, 0x73, 0x00, 0x74, 0x00, 0x20, 0x00, 0x25, 0x00, 0x2d,
    0x00, 0x2e, 0x00, 0x2f, 0x00, 0x33, 0x00, 0x34, 0x00, 0x35,
    0x00, 0x36, 0x00, 0x37, 0x00, 0x38, 0x00, 0x39};
const uint16_t HuffDecoderCommon::table18_97_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0032,
    0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052,
    0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0072,
    0x0000, 0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0092,
    0x0000, 0x0000, 0x0000, 0x00a2, 0x0000, 0x0000, 0x0000, 0x00b2,
    0x0000, 0x0000, 0x0000, 0x00c2, 0x0000, 0x0000, 0x0000, 0x00d2};
const uint8_t HuffDecoderCommon::table18_98_emit_[36] = {
    0x00, 0x3d, 0x00, 0x41, 0x00, 0x5f, 0x00, 0x62, 0x00, 0x64, 0x00, 0x66,
    0x00, 0x67, 0x00, 0x68, 0x00, 0x6c, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x70,
    0x00, 0x72, 0x00, 0x75, 0x00, 0x3a, 0x00, 0x42, 0x00, 0x43, 0x00, 0x44};
const uint16_t HuffDecoderCommon::table18_98_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0032,
    0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052,
    0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0072,
    0x0000, 0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0092,
    0x0000, 0x0000, 0x0000, 0x00a2, 0x0000, 0x0000, 0x0000, 0x00b2,
    0x0000, 0x0000, 0x0000, 0x00c2, 0x0000, 0x0000, 0x0000, 0x00d2,
    0x0000, 0x00e2, 0x0000, 0x00f2, 0x0000, 0x0102, 0x0000, 0x0112};
const uint8_t HuffDecoderCommon::table18_99_emit_[68] = {
    0x00, 0x45, 0x00, 0x46, 0x00, 0x47, 0x00, 0x48, 0x00, 0x49, 0x00, 0x4a,
    0x00, 0x4b, 0x00, 0x4c, 0x00, 0x4d, 0x00, 0x4e, 0x00, 0x4f, 0x00, 0x50,
    0x00, 0x51, 0x00, 0x52, 0x00, 0x53, 0x00, 0x54, 0x00, 0x55, 0x00, 0x56,
    0x00, 0x57, 0x00, 0x59, 0x00, 0x6a, 0x00, 0x6b, 0x00, 0x71, 0x00, 0x76,
    0x00, 0x77, 0x00, 0x78, 0x00, 0x79, 0x00, 0x7a, 0x00, 0x26, 0x00, 0x2a,
    0x00, 0x2c, 0x00, 0x3b, 0x00, 0x58, 0x00, 0x5a};
const uint16_t HuffDecoderCommon::table18_99_ops_[64] = {
    0x0000, 0x0002, 0x0000, 0x0012, 0x0000, 0x0022, 0x0000, 0x0032,
    0x0000, 0x0042, 0x0000, 0x0052, 0x0000, 0x0062, 0x0000, 0x0072,
    0x0000, 0x0082, 0x0000, 0x0092, 0x0000, 0x00a2, 0x0000, 0x00b2,
    0x0000, 0x00c2, 0x0000, 0x00d2, 0x0000, 0x00e2, 0x0000, 0x00f2,
    0x0000, 0x0102, 0x0000, 0x0112, 0x0000, 0x0122, 0x0000, 0x0132,
    0x0000, 0x0142, 0x0000, 0x0152, 0x0000, 0x0162, 0x0000, 0x0172,
    0x0000, 0x0182, 0x0000, 0x0192, 0x0000, 0x01a2, 0x0000, 0x01b2,
    0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table18_100_emit_[16] = {
    0x24, 0x30, 0x24, 0x31, 0x24, 0x32, 0x24, 0x61,
    0x24, 0x63, 0x24, 0x65, 0x24, 0x69, 0x24, 0x6f};
const uint8_t HuffDecoderCommon::table18_101_emit_[28] = {
    0x24, 0x73, 0x24, 0x74, 0x24, 0x20, 0x24, 0x25, 0x24, 0x2d,
    0x24, 0x2e, 0x24, 0x2f, 0x24, 0x33, 0x24, 0x34, 0x24, 0x35,
    0x24, 0x36, 0x24, 0x37, 0x24, 0x38, 0x24, 0x39};
const uint8_t HuffDecoderCommon::table18_102_emit_[36] = {
    0x24, 0x3d, 0x24, 0x41, 0x24, 0x5f, 0x24, 0x62, 0x24, 0x64, 0x24, 0x66,
    0x24, 0x67, 0x24, 0x68, 0x24, 0x6c, 0x24, 0x6d, 0x24, 0x6e, 0x24, 0x70,
    0x24, 0x72, 0x24, 0x75, 0x24, 0x3a, 0x24, 0x42, 0x24, 0x43, 0x24, 0x44};
const uint8_t HuffDecoderCommon::table18_103_emit_[68] = {
    0x24, 0x45, 0x24, 0x46, 0x24, 0x47, 0x24, 0x48, 0x24, 0x49, 0x24, 0x4a,
    0x24, 0x4b, 0x24, 0x4c, 0x24, 0x4d, 0x24, 0x4e, 0x24, 0x4f, 0x24, 0x50,
    0x24, 0x51, 0x24, 0x52, 0x24, 0x53, 0x24, 0x54, 0x24, 0x55, 0x24, 0x56,
    0x24, 0x57, 0x24, 0x59, 0x24, 0x6a, 0x24, 0x6b, 0x24, 0x71, 0x24, 0x76,
    0x24, 0x77, 0x24, 0x78, 0x24, 0x79, 0x24, 0x7a, 0x24, 0x26, 0x24, 0x2a,
    0x24, 0x2c, 0x24, 0x3b, 0x24, 0x58, 0x24, 0x5a};
const uint8_t HuffDecoderCommon::table18_104_emit_[16] = {
    0x40, 0x30, 0x40, 0x31, 0x40, 0x32, 0x40, 0x61,
    0x40, 0x63, 0x40, 0x65, 0x40, 0x69, 0x40, 0x6f};
const uint8_t HuffDecoderCommon::table18_105_emit_[28] = {
    0x40, 0x73, 0x40, 0x74, 0x40, 0x20, 0x40, 0x25, 0x40, 0x2d,
    0x40, 0x2e, 0x40, 0x2f, 0x40, 0x33, 0x40, 0x34, 0x40, 0x35,
    0x40, 0x36, 0x40, 0x37, 0x40, 0x38, 0x40, 0x39};
const uint8_t HuffDecoderCommon::table18_106_emit_[36] = {
    0x40, 0x3d, 0x40, 0x41, 0x40, 0x5f, 0x40, 0x62, 0x40, 0x64, 0x40, 0x66,
    0x40, 0x67, 0x40, 0x68, 0x40, 0x6c, 0x40, 0x6d, 0x40, 0x6e, 0x40, 0x70,
    0x40, 0x72, 0x40, 0x75, 0x40, 0x3a, 0x40, 0x42, 0x40, 0x43, 0x40, 0x44};
const uint8_t HuffDecoderCommon::table18_107_emit_[68] = {
    0x40, 0x45, 0x40, 0x46, 0x40, 0x47, 0x40, 0x48, 0x40, 0x49, 0x40, 0x4a,
    0x40, 0x4b, 0x40, 0x4c, 0x40, 0x4d, 0x40, 0x4e, 0x40, 0x4f, 0x40, 0x50,
    0x40, 0x51, 0x40, 0x52, 0x40, 0x53, 0x40, 0x54, 0x40, 0x55, 0x40, 0x56,
    0x40, 0x57, 0x40, 0x59, 0x40, 0x6a, 0x40, 0x6b, 0x40, 0x71, 0x40, 0x76,
    0x40, 0x77, 0x40, 0x78, 0x40, 0x79, 0x40, 0x7a, 0x40, 0x26, 0x40, 0x2a,
    0x40, 0x2c, 0x40, 0x3b, 0x40, 0x58, 0x40, 0x5a};
const uint8_t HuffDecoderCommon::table18_108_emit_[16] = {
    0x5b, 0x30, 0x5b, 0x31, 0x5b, 0x32, 0x5b, 0x61,
    0x5b, 0x63, 0x5b, 0x65, 0x5b, 0x69, 0x5b, 0x6f};
const uint8_t HuffDecoderCommon::table18_109_emit_[28] = {
    0x5b, 0x73, 0x5b, 0x74, 0x5b, 0x20, 0x5b, 0x25, 0x5b, 0x2d,
    0x5b, 0x2e, 0x5b, 0x2f, 0x5b, 0x33, 0x5b, 0x34, 0x5b, 0x35,
    0x5b, 0x36, 0x5b, 0x37, 0x5b, 0x38, 0x5b, 0x39};
const uint8_t HuffDecoderCommon::table18_110_emit_[36] = {
    0x5b, 0x3d, 0x5b, 0x41, 0x5b, 0x5f, 0x5b, 0x62, 0x5b, 0x64, 0x5b, 0x66,
    0x5b, 0x67, 0x5b, 0x68, 0x5b, 0x6c, 0x5b, 0x6d, 0x5b, 0x6e, 0x5b, 0x70,
    0x5b, 0x72, 0x5b, 0x75, 0x5b, 0x3a, 0x5b, 0x42, 0x5b, 0x43, 0x5b, 0x44};
const uint8_t HuffDecoderCommon::table18_111_emit_[68] = {
    0x5b, 0x45, 0x5b, 0x46, 0x5b, 0x47, 0x5b, 0x48, 0x5b, 0x49, 0x5b, 0x4a,
    0x5b, 0x4b, 0x5b, 0x4c, 0x5b, 0x4d, 0x5b, 0x4e, 0x5b, 0x4f, 0x5b, 0x50,
    0x5b, 0x51, 0x5b, 0x52, 0x5b, 0x53, 0x5b, 0x54, 0x5b, 0x55, 0x5b, 0x56,
    0x5b, 0x57, 0x5b, 0x59, 0x5b, 0x6a, 0x5b, 0x6b, 0x5b, 0x71, 0x5b, 0x76,
    0x5b, 0x77, 0x5b, 0x78, 0x5b, 0x79, 0x5b, 0x7a, 0x5b, 0x26, 0x5b, 0x2a,
    0x5b, 0x2c, 0x5b, 0x3b, 0x5b, 0x58, 0x5b, 0x5a};
const uint8_t HuffDecoderCommon::table18_112_emit_[16] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61,
    0x5d, 0x63, 0x5d, 0x65, 0x5d, 0x69, 0x5d, 0x6f};
const uint8_t HuffDecoderCommon::table18_113_emit_[28] = {
    0x5d, 0x73, 0x5d, 0x74, 0x5d, 0x20, 0x5d, 0x25, 0x5d, 0x2d,
    0x5d, 0x2e, 0x5d, 0x2f, 0x5d, 0x33, 0x5d, 0x34, 0x5d, 0x35,
    0x5d, 0x36, 0x5d, 0x37, 0x5d, 0x38, 0x5d, 0x39};
const uint8_t HuffDecoderCommon::table18_114_emit_[36] = {
    0x5d, 0x3d, 0x5d, 0x41, 0x5d, 0x5f, 0x5d, 0x62, 0x5d, 0x64, 0x5d, 0x66,
    0x5d, 0x67, 0x5d, 0x68, 0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70,
    0x5d, 0x72, 0x5d, 0x75, 0x5d, 0x3a, 0x5d, 0x42, 0x5d, 0x43, 0x5d, 0x44};
const uint8_t HuffDecoderCommon::table18_115_emit_[68] = {
    0x5d, 0x45, 0x5d, 0x46, 0x5d, 0x47, 0x5d, 0x48, 0x5d, 0x49, 0x5d, 0x4a,
    0x5d, 0x4b, 0x5d, 0x4c, 0x5d, 0x4d, 0x5d, 0x4e, 0x5d, 0x4f, 0x5d, 0x50,
    0x5d, 0x51, 0x5d, 0x52, 0x5d, 0x53, 0x5d, 0x54, 0x5d, 0x55, 0x5d, 0x56,
    0x5d, 0x57, 0x5d, 0x59, 0x5d, 0x6a, 0x5d, 0x6b, 0x5d, 0x71, 0x5d, 0x76,
    0x5d, 0x77, 0x5d, 0x78, 0x5d, 0x79, 0x5d, 0x7a, 0x5d, 0x26, 0x5d, 0x2a,
    0x5d, 0x2c, 0x5d, 0x3b, 0x5d, 0x58, 0x5d, 0x5a};
const uint8_t HuffDecoderCommon::table18_116_emit_[16] = {
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61,
    0x7e, 0x63, 0x7e, 0x65, 0x7e, 0x69, 0x7e, 0x6f};
const uint8_t HuffDecoderCommon::table18_117_emit_[28] = {
    0x7e, 0x73, 0x7e, 0x74, 0x7e, 0x20, 0x7e, 0x25, 0x7e, 0x2d,
    0x7e, 0x2e, 0x7e, 0x2f, 0x7e, 0x33, 0x7e, 0x34, 0x7e, 0x35,
    0x7e, 0x36, 0x7e, 0x37, 0x7e, 0x38, 0x7e, 0x39};
const uint8_t HuffDecoderCommon::table18_118_emit_[36] = {
    0x7e, 0x3d, 0x7e, 0x41, 0x7e, 0x5f, 0x7e, 0x62, 0x7e, 0x64, 0x7e, 0x66,
    0x7e, 0x67, 0x7e, 0x68, 0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70,
    0x7e, 0x72, 0x7e, 0x75, 0x7e, 0x3a, 0x7e, 0x42, 0x7e, 0x43, 0x7e, 0x44};
const uint8_t HuffDecoderCommon::table18_119_emit_[68] = {
    0x7e, 0x45, 0x7e, 0x46, 0x7e, 0x47, 0x7e, 0x48, 0x7e, 0x49, 0x7e, 0x4a,
    0x7e, 0x4b, 0x7e, 0x4c, 0x7e, 0x4d, 0x7e, 0x4e, 0x7e, 0x4f, 0x7e, 0x50,
    0x7e, 0x51, 0x7e, 0x52, 0x7e, 0x53, 0x7e, 0x54, 0x7e, 0x55, 0x7e, 0x56,
    0x7e, 0x57, 0x7e, 0x59, 0x7e, 0x6a, 0x7e, 0x6b, 0x7e, 0x71, 0x7e, 0x76,
    0x7e, 0x77, 0x7e, 0x78, 0x7e, 0x79, 0x7e, 0x7a, 0x7e, 0x26, 0x7e, 0x2a,
    0x7e, 0x2c, 0x7e, 0x3b, 0x7e, 0x58, 0x7e, 0x5a};
const uint8_t HuffDecoderCommon::table18_120_emit_[44] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61, 0x5e, 0x63, 0x5e,
    0x65, 0x5e, 0x69, 0x5e, 0x6f, 0x5e, 0x73, 0x5e, 0x74, 0x5e, 0x20,
    0x5e, 0x25, 0x5e, 0x2d, 0x5e, 0x2e, 0x5e, 0x2f, 0x5e, 0x33, 0x5e,
    0x34, 0x5e, 0x35, 0x5e, 0x36, 0x5e, 0x37, 0x5e, 0x38, 0x5e, 0x39};
const uint16_t HuffDecoderCommon::table18_120_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0032,
    0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052,
    0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0072,
    0x0000, 0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0092,
    0x0000, 0x00a2, 0x0000, 0x00b2, 0x0000, 0x00c2, 0x0000, 0x00d2,
    0x0000, 0x00e2, 0x0000, 0x00f2, 0x0000, 0x0102, 0x0000, 0x0112,
    0x0000, 0x0122, 0x0000, 0x0132, 0x0000, 0x0142, 0x0000, 0x0152};
const uint8_t HuffDecoderCommon::table18_121_emit_[92] = {
    0x5e, 0x3d, 0x5e, 0x41, 0x5e, 0x5f, 0x5e, 0x62, 0x5e, 0x64, 0x5e, 0x66,
    0x5e, 0x67, 0x5e, 0x68, 0x5e, 0x6c, 0x5e, 0x6d, 0x5e, 0x6e, 0x5e, 0x70,
    0x5e, 0x72, 0x5e, 0x75, 0x5e, 0x3a, 0x5e, 0x42, 0x5e, 0x43, 0x5e, 0x44,
    0x5e, 0x45, 0x5e, 0x46, 0x5e, 0x47, 0x5e, 0x48, 0x5e, 0x49, 0x5e, 0x4a,
    0x5e, 0x4b, 0x5e, 0x4c, 0x5e, 0x4d, 0x5e, 0x4e, 0x5e, 0x4f, 0x5e, 0x50,
    0x5e, 0x51, 0x5e, 0x52, 0x5e, 0x53, 0x5e, 0x54, 0x5e, 0x55, 0x5e, 0x56,
    0x5e, 0x57, 0x5e, 0x59, 0x5e, 0x6a, 0x5e, 0x6b, 0x5e, 0x71, 0x5e, 0x76,
    0x5e, 0x77, 0x5e, 0x78, 0x5e, 0x79, 0x5e, 0x7a};
const uint16_t HuffDecoderCommon::table18_121_ops_[64] = {
    0x0000, 0x0002, 0x0000, 0x0012, 0x0000, 0x0022, 0x0000, 0x0032,
    0x0000, 0x0042, 0x0000, 0x0052, 0x0000, 0x0062, 0x0000, 0x0072,
    0x0000, 0x0082, 0x0000, 0x0092, 0x0000, 0x00a2, 0x0000, 0x00b2,
    0x0000, 0x00c2, 0x0000, 0x00d2, 0x00e2, 0x00f2, 0x0102, 0x0112,
    0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212,
    0x0222, 0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292,
    0x02a2, 0x02b2, 0x02c2, 0x02d2, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table18_122_emit_[44] = {
    0x7d, 0x30, 0x7d, 0x31, 0x7d, 0x32, 0x7d, 0x61, 0x7d, 0x63, 0x7d,
    0x65, 0x7d, 0x69, 0x7d, 0x6f, 0x7d, 0x73, 0x7d, 0x74, 0x7d, 0x20,
    0x7d, 0x25, 0x7d, 0x2d, 0x7d, 0x2e, 0x7d, 0x2f, 0x7d, 0x33, 0x7d,
    0x34, 0x7d, 0x35, 0x7d, 0x36, 0x7d, 0x37, 0x7d, 0x38, 0x7d, 0x39};
const uint8_t HuffDecoderCommon::table18_123_emit_[92] = {
    0x7d, 0x3d, 0x7d, 0x41, 0x7d, 0x5f, 0x7d, 0x62, 0x7d, 0x64, 0x7d, 0x66,
    0x7d, 0x67, 0x7d, 0x68, 0x7d, 0x6c, 0x7d, 0x6d, 0x7d, 0x6e, 0x7d, 0x70,
    0x7d, 0x72, 0x7d, 0x75, 0x7d, 0x3a, 0x7d, 0x42, 0x7d, 0x43, 0x7d, 0x44,
    0x7d, 0x45, 0x7d, 0x46, 0x7d, 0x47, 0x7d, 0x48, 0x7d, 0x49, 0x7d, 0x4a,
    0x7d, 0x4b, 0x7d, 0x4c, 0x7d, 0x4d, 0x7d, 0x4e, 0x7d, 0x4f, 0x7d, 0x50,
    0x7d, 0x51, 0x7d, 0x52, 0x7d, 0x53, 0x7d, 0x54, 0x7d, 0x55, 0x7d, 0x56,
    0x7d, 0x57, 0x7d, 0x59, 0x7d, 0x6a, 0x7d, 0x6b, 0x7d, 0x71, 0x7d, 0x76,
    0x7d, 0x77, 0x7d, 0x78, 0x7d, 0x79, 0x7d, 0x7a};
const uint8_t HuffDecoderCommon::table18_124_emit_[72] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63, 0x3c, 0x65,
    0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74, 0x3c, 0x20, 0x3c, 0x25,
    0x3c, 0x2d, 0x3c, 0x2e, 0x3c, 0x2f, 0x3c, 0x33, 0x3c, 0x34, 0x3c, 0x35,
    0x3c, 0x36, 0x3c, 0x37, 0x3c, 0x38, 0x3c, 0x39, 0x3c, 0x3d, 0x3c, 0x41,
    0x3c, 0x5f, 0x3c, 0x62, 0x3c, 0x64, 0x3c, 0x66, 0x3c, 0x67, 0x3c, 0x68,
    0x3c, 0x6c, 0x3c, 0x6d, 0x3c, 0x6e, 0x3c, 0x70, 0x3c, 0x72, 0x3c, 0x75};
const uint16_t HuffDecoderCommon::table18_124_ops_[64] = {
    0x0000, 0x0002, 0x0000, 0x0012, 0x0000, 0x0022, 0x0000, 0x0032,
    0x0000, 0x0042, 0x0000, 0x0052, 0x0000, 0x0062, 0x0000, 0x0072,
    0x0000, 0x0082, 0x0000, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2,
    0x00e2, 0x00f2, 0x0102, 0x0112, 0x0122, 0x0132, 0x0142, 0x0152,
    0x0162, 0x0172, 0x0182, 0x0192, 0x01a2, 0x01b2, 0x01c2, 0x01d2,
    0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222, 0x0232, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table18_125_emit_[72] = {
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63, 0x60, 0x65,
    0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74, 0x60, 0x20, 0x60, 0x25,
    0x60, 0x2d, 0x60, 0x2e, 0x60, 0x2f, 0x60, 0x33, 0x60, 0x34, 0x60, 0x35,
    0x60, 0x36, 0x60, 0x37, 0x60, 0x38, 0x60, 0x39, 0x60, 0x3d, 0x60, 0x41,
    0x60, 0x5f, 0x60, 0x62, 0x60, 0x64, 0x60, 0x66, 0x60, 0x67, 0x60, 0x68,
    0x60, 0x6c, 0x60, 0x6d, 0x60, 0x6e, 0x60, 0x70, 0x60, 0x72, 0x60, 0x75};
const uint8_t HuffDecoderCommon::table18_126_emit_[72] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b, 0x65,
    0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x7b, 0x20, 0x7b, 0x25,
    0x7b, 0x2d, 0x7b, 0x2e, 0x7b, 0x2f, 0x7b, 0x33, 0x7b, 0x34, 0x7b, 0x35,
    0x7b, 0x36, 0x7b, 0x37, 0x7b, 0x38, 0x7b, 0x39, 0x7b, 0x3d, 0x7b, 0x41,
    0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64, 0x7b, 0x66, 0x7b, 0x67, 0x7b, 0x68,
    0x7b, 0x6c, 0x7b, 0x6d, 0x7b, 0x6e, 0x7b, 0x70, 0x7b, 0x72, 0x7b, 0x75};
const uint8_t HuffDecoderCommon::table18_127_emit_[24] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2, 0x99,
    0xa1, 0xa7, 0xac, 0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6};
const uint16_t HuffDecoderCommon::table18_127_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0003, 0x0000, 0x0000, 0x0000, 0x000b,
    0x0000, 0x0000, 0x0000, 0x0013, 0x0000, 0x001b, 0x0000, 0x0023,
    0x0000, 0x002b, 0x0000, 0x0033, 0x0000, 0x003b, 0x0000, 0x0043,
    0x0000, 0x004b, 0x0000, 0x0053, 0x005b, 0x0063, 0x006b, 0x0073,
    0x007b, 0x0083, 0x008b, 0x0093, 0x009b, 0x00a3, 0x00ab, 0x00b3,
    0x00bb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004};
const uint8_t* const HuffDecoderCommon::table18_emit_[128] = {
    table18_0_emit_,   table18_1_emit_,   table18_2_emit_,   table18_3_emit_,
    table18_4_emit_,   table18_5_emit_,   table18_6_emit_,   table18_7_emit_,
    table18_8_emit_,   table18_9_emit_,   table18_10_emit_,  table18_11_emit_,
    table18_12_emit_,  table18_13_emit_,  table18_14_emit_,  table18_15_emit_,
    table18_16_emit_,  table18_17_emit_,  table18_18_emit_,  table18_19_emit_,
    table18_20_emit_,  table18_21_emit_,  table18_22_emit_,  table18_23_emit_,
    table18_24_emit_,  table18_25_emit_,  table18_26_emit_,  table18_27_emit_,
    table18_28_emit_,  table18_29_emit_,  table18_30_emit_,  table18_31_emit_,
    table18_32_emit_,  table18_33_emit_,  table18_34_emit_,  table18_35_emit_,
    table18_36_emit_,  table18_37_emit_,  table18_38_emit_,  table18_39_emit_,
    table18_40_emit_,  table18_41_emit_,  table18_42_emit_,  table18_43_emit_,
    table18_44_emit_,  table18_45_emit_,  table18_46_emit_,  table18_47_emit_,
    table18_48_emit_,  table18_49_emit_,  table18_50_emit_,  table18_51_emit_,
    table18_52_emit_,  table18_53_emit_,  table18_54_emit_,  table18_55_emit_,
    table18_56_emit_,  table18_57_emit_,  table18_58_emit_,  table18_59_emit_,
    table18_60_emit_,  table18_61_emit_,  table18_62_emit_,  table18_63_emit_,
    table18_64_emit_,  table18_65_emit_,  table18_66_emit_,  table18_67_emit_,
    table18_68_emit_,  table18_69_emit_,  table18_70_emit_,  table18_71_emit_,
    table18_72_emit_,  table18_73_emit_,  table18_74_emit_,  table18_75_emit_,
    table18_76_emit_,  table18_77_emit_,  table18_78_emit_,  table18_79_emit_,
    table18_80_emit_,  table18_81_emit_,  table18_82_emit_,  table18_83_emit_,
    table18_84_emit_,  table18_85_emit_,  table18_86_emit_,  table18_87_emit_,
    table18_88_emit_,  table18_89_emit_,  table18_90_emit_,  table18_91_emit_,
    table18_92_emit_,  table18_93_emit_,  table18_94_emit_,  table18_95_emit_,
    table18_96_emit_,  table18_97_emit_,  table18_98_emit_,  table18_99_emit_,
    table18_100_emit_, table18_101_emit_, table18_102_emit_, table18_103_emit_,
    table18_104_emit_, table18_105_emit_, table18_106_emit_, table18_107_emit_,
    table18_108_emit_, table18_109_emit_, table18_110_emit_, table18_111_emit_,
    table18_112_emit_, table18_113_emit_, table18_114_emit_, table18_115_emit_,
    table18_116_emit_, table18_117_emit_, table18_118_emit_, table18_119_emit_,
    table18_120_emit_, table18_121_emit_, table18_122_emit_, table18_123_emit_,
    table18_124_emit_, table18_125_emit_, table18_126_emit_, table18_127_emit_,
};
const uint16_t* const HuffDecoderCommon::table18_ops_[128] = {
    table18_0_ops_,   table18_0_ops_,   table18_0_ops_,   table18_0_ops_,
    table18_0_ops_,   table18_0_ops_,   table18_0_ops_,   table18_0_ops_,
    table18_0_ops_,   table18_0_ops_,   table18_10_ops_,  table18_10_ops_,
    table18_10_ops_,  table18_10_ops_,  table18_10_ops_,  table18_10_ops_,
    table18_10_ops_,  table18_10_ops_,  table18_10_ops_,  table18_10_ops_,
    table18_10_ops_,  table18_10_ops_,  table18_10_ops_,  table18_23_ops_,
    table18_23_ops_,  table18_23_ops_,  table18_23_ops_,  table18_23_ops_,
    table18_23_ops_,  table18_23_ops_,  table18_23_ops_,  table18_31_ops_,
    table18_10_ops_,  table18_10_ops_,  table18_10_ops_,  table18_10_ops_,
    table18_10_ops_,  table18_23_ops_,  table18_23_ops_,  table18_23_ops_,
    table18_23_ops_,  table18_23_ops_,  table18_23_ops_,  table18_43_ops_,
    table18_44_ops_,  table18_44_ops_,  table18_44_ops_,  table18_47_ops_,
    table18_10_ops_,  table18_10_ops_,  table18_10_ops_,  table18_10_ops_,
    table18_10_ops_,  table18_23_ops_,  table18_23_ops_,  table18_23_ops_,
    table18_23_ops_,  table18_23_ops_,  table18_23_ops_,  table18_43_ops_,
    table18_44_ops_,  table18_44_ops_,  table18_44_ops_,  table18_47_ops_,
    table18_10_ops_,  table18_10_ops_,  table18_10_ops_,  table18_10_ops_,
    table18_10_ops_,  table18_23_ops_,  table18_23_ops_,  table18_23_ops_,
    table18_23_ops_,  table18_23_ops_,  table18_23_ops_,  table18_43_ops_,
    table18_44_ops_,  table18_44_ops_,  table18_44_ops_,  table18_47_ops_,
    table18_23_ops_,  table18_23_ops_,  table18_43_ops_,  table18_44_ops_,
    table18_44_ops_,  table18_85_ops_,  table18_86_ops_,  table18_87_ops_,
    table18_23_ops_,  table18_23_ops_,  table18_43_ops_,  table18_44_ops_,
    table18_44_ops_,  table18_85_ops_,  table18_86_ops_,  table18_87_ops_,
    table18_44_ops_,  table18_97_ops_,  table18_98_ops_,  table18_99_ops_,
    table18_44_ops_,  table18_97_ops_,  table18_98_ops_,  table18_99_ops_,
    table18_44_ops_,  table18_97_ops_,  table18_98_ops_,  table18_99_ops_,
    table18_44_ops_,  table18_97_ops_,  table18_98_ops_,  table18_99_ops_,
    table18_44_ops_,  table18_97_ops_,  table18_98_ops_,  table18_99_ops_,
    table18_44_ops_,  table18_97_ops_,  table18_98_ops_,  table18_99_ops_,
    table18_120_ops_, table18_121_ops_, table18_120_ops_, table18_121_ops_,
    table18_124_ops_, table18_124_ops_, table18_124_ops_, table18_127_ops_,
};
const uint8_t HuffDecoderCommon::table19_0_emit_[204] = {
    0x3f, 0x30, 0x30, 0x3f, 0x30, 0x31, 0x3f, 0x30, 0x32, 0x3f, 0x30, 0x61,
    0x3f, 0x30, 0x63, 0x3f, 0x30, 0x65, 0x3f, 0x30, 0x69, 0x3f, 0x30, 0x6f,
    0x3f, 0x30, 0x73, 0x3f, 0x30, 0x74, 0x3f, 0x30, 0x20, 0x3f, 0x30, 0x25,
    0x3f, 0x30, 0x2d, 0x3f, 0x30, 0x2e, 0x3f, 0x30, 0x2f, 0x3f, 0x30, 0x33,
    0x3f, 0x30, 0x34, 0x3f, 0x30, 0x35, 0x3f, 0x30, 0x36, 0x3f, 0x30, 0x37,
    0x3f, 0x30, 0x38, 0x3f, 0x30, 0x39, 0x3f, 0x30, 0x3d, 0x3f, 0x30, 0x41,
    0x3f, 0x30, 0x5f, 0x3f, 0x30, 0x62, 0x3f, 0x30, 0x64, 0x3f, 0x30, 0x66,
    0x3f, 0x30, 0x67, 0x3f, 0x30, 0x68, 0x3f, 0x30, 0x6c, 0x3f, 0x30, 0x6d,
    0x3f, 0x30, 0x6e, 0x3f, 0x30, 0x70, 0x3f, 0x30, 0x72, 0x3f, 0x30, 0x75,
    0x3f, 0x30, 0x3a, 0x3f, 0x30, 0x42, 0x3f, 0x30, 0x43, 0x3f, 0x30, 0x44,
    0x3f, 0x30, 0x45, 0x3f, 0x30, 0x46, 0x3f, 0x30, 0x47, 0x3f, 0x30, 0x48,
    0x3f, 0x30, 0x49, 0x3f, 0x30, 0x4a, 0x3f, 0x30, 0x4b, 0x3f, 0x30, 0x4c,
    0x3f, 0x30, 0x4d, 0x3f, 0x30, 0x4e, 0x3f, 0x30, 0x4f, 0x3f, 0x30, 0x50,
    0x3f, 0x30, 0x51, 0x3f, 0x30, 0x52, 0x3f, 0x30, 0x53, 0x3f, 0x30, 0x54,
    0x3f, 0x30, 0x55, 0x3f, 0x30, 0x56, 0x3f, 0x30, 0x57, 0x3f, 0x30, 0x59,
    0x3f, 0x30, 0x6a, 0x3f, 0x30, 0x6b, 0x3f, 0x30, 0x71, 0x3f, 0x30, 0x76,
    0x3f, 0x30, 0x77, 0x3f, 0x30, 0x78, 0x3f, 0x30, 0x79, 0x3f, 0x30, 0x7a};
const uint16_t HuffDecoderCommon::table19_0_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000,
    0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0000,
    0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0079, 0x0000, 0x0000, 0x0000,
    0x0091, 0x0000, 0x0000, 0x0000, 0x00a9, 0x0000, 0x0000, 0x0000, 0x00c1,
    0x0000, 0x0000, 0x0000, 0x00d9, 0x0000, 0x00f1, 0x0000, 0x0109, 0x0000,
    0x0121, 0x0000, 0x0139, 0x0000, 0x0151, 0x0000, 0x0169, 0x0000, 0x0181,
    0x0000, 0x0199, 0x0000, 0x01b1, 0x0000, 0x01c9, 0x0000, 0x01e1, 0x0000,
    0x01f9, 0x0000, 0x0211, 0x0000, 0x0229, 0x0000, 0x0241, 0x0000, 0x0259,
    0x0000, 0x0271, 0x0000, 0x0289, 0x0000, 0x02a1, 0x0000, 0x02b9, 0x0000,
    0x02d1, 0x0000, 0x02e9, 0x0000, 0x0301, 0x0000, 0x0319, 0x0000, 0x0331,
    0x0000, 0x0349, 0x0361, 0x0379, 0x0391, 0x03a9, 0x03c1, 0x03d9, 0x03f1,
    0x0409, 0x0421, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9,
    0x04e1, 0x04f9, 0x0511, 0x0529, 0x0541, 0x0559, 0x0571, 0x0589, 0x05a1,
    0x05b9, 0x05d1, 0x05e9, 0x0601, 0x0619, 0x0631, 0x0649, 0x0000, 0x0000,
    0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table19_1_emit_[204] = {
    0x3f, 0x31, 0x30, 0x3f, 0x31, 0x31, 0x3f, 0x31, 0x32, 0x3f, 0x31, 0x61,
    0x3f, 0x31, 0x63, 0x3f, 0x31, 0x65, 0x3f, 0x31, 0x69, 0x3f, 0x31, 0x6f,
    0x3f, 0x31, 0x73, 0x3f, 0x31, 0x74, 0x3f, 0x31, 0x20, 0x3f, 0x31, 0x25,
    0x3f, 0x31, 0x2d, 0x3f, 0x31, 0x2e, 0x3f, 0x31, 0x2f, 0x3f, 0x31, 0x33,
    0x3f, 0x31, 0x34, 0x3f, 0x31, 0x35, 0x3f, 0x31, 0x36, 0x3f, 0x31, 0x37,
    0x3f, 0x31, 0x38, 0x3f, 0x31, 0x39, 0x3f, 0x31, 0x3d, 0x3f, 0x31, 0x41,
    0x3f, 0x31, 0x5f, 0x3f, 0x31, 0x62, 0x3f, 0x31, 0x64, 0x3f, 0x31, 0x66,
    0x3f, 0x31, 0x67, 0x3f, 0x31, 0x68, 0x3f, 0x31, 0x6c, 0x3f, 0x31, 0x6d,
    0x3f, 0x31, 0x6e, 0x3f, 0x31, 0x70, 0x3f, 0x31, 0x72, 0x3f, 0x31, 0x75,
    0x3f, 0x31, 0x3a, 0x3f, 0x31, 0x42, 0x3f, 0x31, 0x43, 0x3f, 0x31, 0x44,
    0x3f, 0x31, 0x45, 0x3f, 0x31, 0x46, 0x3f, 0x31, 0x47, 0x3f, 0x31, 0x48,
    0x3f, 0x31, 0x49, 0x3f, 0x31, 0x4a, 0x3f, 0x31, 0x4b, 0x3f, 0x31, 0x4c,
    0x3f, 0x31, 0x4d, 0x3f, 0x31, 0x4e, 0x3f, 0x31, 0x4f, 0x3f, 0x31, 0x50,
    0x3f, 0x31, 0x51, 0x3f, 0x31, 0x52, 0x3f, 0x31, 0x53, 0x3f, 0x31, 0x54,
    0x3f, 0x31, 0x55, 0x3f, 0x31, 0x56, 0x3f, 0x31, 0x57, 0x3f, 0x31, 0x59,
    0x3f, 0x31, 0x6a, 0x3f, 0x31, 0x6b, 0x3f, 0x31, 0x71, 0x3f, 0x31, 0x76,
    0x3f, 0x31, 0x77, 0x3f, 0x31, 0x78, 0x3f, 0x31, 0x79, 0x3f, 0x31, 0x7a};
const uint8_t HuffDecoderCommon::table19_2_emit_[204] = {
    0x3f, 0x32, 0x30, 0x3f, 0x32, 0x31, 0x3f, 0x32, 0x32, 0x3f, 0x32, 0x61,
    0x3f, 0x32, 0x63, 0x3f, 0x32, 0x65, 0x3f, 0x32, 0x69, 0x3f, 0x32, 0x6f,
    0x3f, 0x32, 0x73, 0x3f, 0x32, 0x74, 0x3f, 0x32, 0x20, 0x3f, 0x32, 0x25,
    0x3f, 0x32, 0x2d, 0x3f, 0x32, 0x2e, 0x3f, 0x32, 0x2f, 0x3f, 0x32, 0x33,
    0x3f, 0x32, 0x34, 0x3f, 0x32, 0x35, 0x3f, 0x32, 0x36, 0x3f, 0x32, 0x37,
    0x3f, 0x32, 0x38, 0x3f, 0x32, 0x39, 0x3f, 0x32, 0x3d, 0x3f, 0x32, 0x41,
    0x3f, 0x32, 0x5f, 0x3f, 0x32, 0x62, 0x3f, 0x32, 0x64, 0x3f, 0x32, 0x66,
    0x3f, 0x32, 0x67, 0x3f, 0x32, 0x68, 0x3f, 0x32, 0x6c, 0x3f, 0x32, 0x6d,
    0x3f, 0x32, 0x6e, 0x3f, 0x32, 0x70, 0x3f, 0x32, 0x72, 0x3f, 0x32, 0x75,
    0x3f, 0x32, 0x3a, 0x3f, 0x32, 0x42, 0x3f, 0x32, 0x43, 0x3f, 0x32, 0x44,
    0x3f, 0x32, 0x45, 0x3f, 0x32, 0x46, 0x3f, 0x32, 0x47, 0x3f, 0x32, 0x48,
    0x3f, 0x32, 0x49, 0x3f, 0x32, 0x4a, 0x3f, 0x32, 0x4b, 0x3f, 0x32, 0x4c,
    0x3f, 0x32, 0x4d, 0x3f, 0x32, 0x4e, 0x3f, 0x32, 0x4f, 0x3f, 0x32, 0x50,
    0x3f, 0x32, 0x51, 0x3f, 0x32, 0x52, 0x3f, 0x32, 0x53, 0x3f, 0x32, 0x54,
    0x3f, 0x32, 0x55, 0x3f, 0x32, 0x56, 0x3f, 0x32, 0x57, 0x3f, 0x32, 0x59,
    0x3f, 0x32, 0x6a, 0x3f, 0x32, 0x6b, 0x3f, 0x32, 0x71, 0x3f, 0x32, 0x76,
    0x3f, 0x32, 0x77, 0x3f, 0x32, 0x78, 0x3f, 0x32, 0x79, 0x3f, 0x32, 0x7a};
const uint8_t HuffDecoderCommon::table19_3_emit_[204] = {
    0x3f, 0x61, 0x30, 0x3f, 0x61, 0x31, 0x3f, 0x61, 0x32, 0x3f, 0x61, 0x61,
    0x3f, 0x61, 0x63, 0x3f, 0x61, 0x65, 0x3f, 0x61, 0x69, 0x3f, 0x61, 0x6f,
    0x3f, 0x61, 0x73, 0x3f, 0x61, 0x74, 0x3f, 0x61, 0x20, 0x3f, 0x61, 0x25,
    0x3f, 0x61, 0x2d, 0x3f, 0x61, 0x2e, 0x3f, 0x61, 0x2f, 0x3f, 0x61, 0x33,
    0x3f, 0x61, 0x34, 0x3f, 0x61, 0x35, 0x3f, 0x61, 0x36, 0x3f, 0x61, 0x37,
    0x3f, 0x61, 0x38, 0x3f, 0x61, 0x39, 0x3f, 0x61, 0x3d, 0x3f, 0x61, 0x41,
    0x3f, 0x61, 0x5f, 0x3f, 0x61, 0x62, 0x3f, 0x61, 0x64, 0x3f, 0x61, 0x66,
    0x3f, 0x61, 0x67, 0x3f, 0x61, 0x68, 0x3f, 0x61, 0x6c, 0x3f, 0x61, 0x6d,
    0x3f, 0x61, 0x6e, 0x3f, 0x61, 0x70, 0x3f, 0x61, 0x72, 0x3f, 0x61, 0x75,
    0x3f, 0x61, 0x3a, 0x3f, 0x61, 0x42, 0x3f, 0x61, 0x43, 0x3f, 0x61, 0x44,
    0x3f, 0x61, 0x45, 0x3f, 0x61, 0x46, 0x3f, 0x61, 0x47, 0x3f, 0x61, 0x48,
    0x3f, 0x61, 0x49, 0x3f, 0x61, 0x4a, 0x3f, 0x61, 0x4b, 0x3f, 0x61, 0x4c,
    0x3f, 0x61, 0x4d, 0x3f, 0x61, 0x4e, 0x3f, 0x61, 0x4f, 0x3f, 0x61, 0x50,
    0x3f, 0x61, 0x51, 0x3f, 0x61, 0x52, 0x3f, 0x61, 0x53, 0x3f, 0x61, 0x54,
    0x3f, 0x61, 0x55, 0x3f, 0x61, 0x56, 0x3f, 0x61, 0x57, 0x3f, 0x61, 0x59,
    0x3f, 0x61, 0x6a, 0x3f, 0x61, 0x6b, 0x3f, 0x61, 0x71, 0x3f, 0x61, 0x76,
    0x3f, 0x61, 0x77, 0x3f, 0x61, 0x78, 0x3f, 0x61, 0x79, 0x3f, 0x61, 0x7a};
const uint8_t HuffDecoderCommon::table19_4_emit_[204] = {
    0x3f, 0x63, 0x30, 0x3f, 0x63, 0x31, 0x3f, 0x63, 0x32, 0x3f, 0x63, 0x61,
    0x3f, 0x63, 0x63, 0x3f, 0x63, 0x65, 0x3f, 0x63, 0x69, 0x3f, 0x63, 0x6f,
    0x3f, 0x63, 0x73, 0x3f, 0x63, 0x74, 0x3f, 0x63, 0x20, 0x3f, 0x63, 0x25,
    0x3f, 0x63, 0x2d, 0x3f, 0x63, 0x2e, 0x3f, 0x63, 0x2f, 0x3f, 0x63, 0x33,
    0x3f, 0x63, 0x34, 0x3f, 0x63, 0x35, 0x3f, 0x63, 0x36, 0x3f, 0x63, 0x37,
    0x3f, 0x63, 0x38, 0x3f, 0x63, 0x39, 0x3f, 0x63, 0x3d, 0x3f, 0x63, 0x41,
    0x3f, 0x63, 0x5f, 0x3f, 0x63, 0x62, 0x3f, 0x63, 0x64, 0x3f, 0x63, 0x66,
    0x3f, 0x63, 0x67, 0x3f, 0x63, 0x68, 0x3f, 0x63, 0x6c, 0x3f, 0x63, 0x6d,
    0x3f, 0x63, 0x6e, 0x3f, 0x63, 0x70, 0x3f, 0x63, 0x72, 0x3f, 0x63, 0x75,
    0x3f, 0x63, 0x3a, 0x3f, 0x63, 0x42, 0x3f, 0x63, 0x43, 0x3f, 0x63, 0x44,
    0x3f, 0x63, 0x45, 0x3f, 0x63, 0x46, 0x3f, 0x63, 0x47, 0x3f, 0x63, 0x48,
    0x3f, 0x63, 0x49, 0x3f, 0x63, 0x4a, 0x3f, 0x63, 0x4b, 0x3f, 0x63, 0x4c,
    0x3f, 0x63, 0x4d, 0x3f, 0x63, 0x4e, 0x3f, 0x63, 0x4f, 0x3f, 0x63, 0x50,
    0x3f, 0x63, 0x51, 0x3f, 0x63, 0x52, 0x3f, 0x63, 0x53, 0x3f, 0x63, 0x54,
    0x3f, 0x63, 0x55, 0x3f, 0x63, 0x56, 0x3f, 0x63, 0x57, 0x3f, 0x63, 0x59,
    0x3f, 0x63, 0x6a, 0x3f, 0x63, 0x6b, 0x3f, 0x63, 0x71, 0x3f, 0x63, 0x76,
    0x3f, 0x63, 0x77, 0x3f, 0x63, 0x78, 0x3f, 0x63, 0x79, 0x3f, 0x63, 0x7a};
const uint8_t HuffDecoderCommon::table19_5_emit_[204] = {
    0x3f, 0x65, 0x30, 0x3f, 0x65, 0x31, 0x3f, 0x65, 0x32, 0x3f, 0x65, 0x61,
    0x3f, 0x65, 0x63, 0x3f, 0x65, 0x65, 0x3f, 0x65, 0x69, 0x3f, 0x65, 0x6f,
    0x3f, 0x65, 0x73, 0x3f, 0x65, 0x74, 0x3f, 0x65, 0x20, 0x3f, 0x65, 0x25,
    0x3f, 0x65, 0x2d, 0x3f, 0x65, 0x2e, 0x3f, 0x65, 0x2f, 0x3f, 0x65, 0x33,
    0x3f, 0x65, 0x34, 0x3f, 0x65, 0x35, 0x3f, 0x65, 0x36, 0x3f, 0x65, 0x37,
    0x3f, 0x65, 0x38, 0x3f, 0x65, 0x39, 0x3f, 0x65, 0x3d, 0x3f, 0x65, 0x41,
    0x3f, 0x65, 0x5f, 0x3f, 0x65, 0x62, 0x3f, 0x65, 0x64, 0x3f, 0x65, 0x66,
    0x3f, 0x65, 0x67, 0x3f, 0x65, 0x68, 0x3f, 0x65, 0x6c, 0x3f, 0x65, 0x6d,
    0x3f, 0x65, 0x6e, 0x3f, 0x65, 0x70, 0x3f, 0x65, 0x72, 0x3f, 0x65, 0x75,
    0x3f, 0x65, 0x3a, 0x3f, 0x65, 0x42, 0x3f, 0x65, 0x43, 0x3f, 0x65, 0x44,
    0x3f, 0x65, 0x45, 0x3f, 0x65, 0x46, 0x3f, 0x65, 0x47, 0x3f, 0x65, 0x48,
    0x3f, 0x65, 0x49, 0x3f, 0x65, 0x4a, 0x3f, 0x65, 0x4b, 0x3f, 0x65, 0x4c,
    0x3f, 0x65, 0x4d, 0x3f, 0x65, 0x4e, 0x3f, 0x65, 0x4f, 0x3f, 0x65, 0x50,
    0x3f, 0x65, 0x51, 0x3f, 0x65, 0x52, 0x3f, 0x65, 0x53, 0x3f, 0x65, 0x54,
    0x3f, 0x65, 0x55, 0x3f, 0x65, 0x56, 0x3f, 0x65, 0x57, 0x3f, 0x65, 0x59,
    0x3f, 0x65, 0x6a, 0x3f, 0x65, 0x6b, 0x3f, 0x65, 0x71, 0x3f, 0x65, 0x76,
    0x3f, 0x65, 0x77, 0x3f, 0x65, 0x78, 0x3f, 0x65, 0x79, 0x3f, 0x65, 0x7a};
const uint8_t HuffDecoderCommon::table19_6_emit_[204] = {
    0x3f, 0x69, 0x30, 0x3f, 0x69, 0x31, 0x3f, 0x69, 0x32, 0x3f, 0x69, 0x61,
    0x3f, 0x69, 0x63, 0x3f, 0x69, 0x65, 0x3f, 0x69, 0x69, 0x3f, 0x69, 0x6f,
    0x3f, 0x69, 0x73, 0x3f, 0x69, 0x74, 0x3f, 0x69, 0x20, 0x3f, 0x69, 0x25,
    0x3f, 0x69, 0x2d, 0x3f, 0x69, 0x2e, 0x3f, 0x69, 0x2f, 0x3f, 0x69, 0x33,
    0x3f, 0x69, 0x34, 0x3f, 0x69, 0x35, 0x3f, 0x69, 0x36, 0x3f, 0x69, 0x37,
    0x3f, 0x69, 0x38, 0x3f, 0x69, 0x39, 0x3f, 0x69, 0x3d, 0x3f, 0x69, 0x41,
    0x3f, 0x69, 0x5f, 0x3f, 0x69, 0x62, 0x3f, 0x69, 0x64, 0x3f, 0x69, 0x66,
    0x3f, 0x69, 0x67, 0x3f, 0x69, 0x68, 0x3f, 0x69, 0x6c, 0x3f, 0x69, 0x6d,
    0x3f, 0x69, 0x6e, 0x3f, 0x69, 0x70, 0x3f, 0x69, 0x72, 0x3f, 0x69, 0x75,
    0x3f, 0x69, 0x3a, 0x3f, 0x69, 0x42, 0x3f, 0x69, 0x43, 0x3f, 0x69, 0x44,
    0x3f, 0x69, 0x45, 0x3f, 0x69, 0x46, 0x3f, 0x69, 0x47, 0x3f, 0x69, 0x48,
    0x3f, 0x69, 0x49, 0x3f, 0x69, 0x4a, 0x3f, 0x69, 0x4b, 0x3f, 0x69, 0x4c,
    0x3f, 0x69, 0x4d, 0x3f, 0x69, 0x4e, 0x3f, 0x69, 0x4f, 0x3f, 0x69, 0x50,
    0x3f, 0x69, 0x51, 0x3f, 0x69, 0x52, 0x3f, 0x69, 0x53, 0x3f, 0x69, 0x54,
    0x3f, 0x69, 0x55, 0x3f, 0x69, 0x56, 0x3f, 0x69, 0x57, 0x3f, 0x69, 0x59,
    0x3f, 0x69, 0x6a, 0x3f, 0x69, 0x6b, 0x3f, 0x69, 0x71, 0x3f, 0x69, 0x76,
    0x3f, 0x69, 0x77, 0x3f, 0x69, 0x78, 0x3f, 0x69, 0x79, 0x3f, 0x69, 0x7a};
const uint8_t HuffDecoderCommon::table19_7_emit_[204] = {
    0x3f, 0x6f, 0x30, 0x3f, 0x6f, 0x31, 0x3f, 0x6f, 0x32, 0x3f, 0x6f, 0x61,
    0x3f, 0x6f, 0x63, 0x3f, 0x6f, 0x65, 0x3f, 0x6f, 0x69, 0x3f, 0x6f, 0x6f,
    0x3f, 0x6f, 0x73, 0x3f, 0x6f, 0x74, 0x3f, 0x6f, 0x20, 0x3f, 0x6f, 0x25,
    0x3f, 0x6f, 0x2d, 0x3f, 0x6f, 0x2e, 0x3f, 0x6f, 0x2f, 0x3f, 0x6f, 0x33,
    0x3f, 0x6f, 0x34, 0x3f, 0x6f, 0x35, 0x3f, 0x6f, 0x36, 0x3f, 0x6f, 0x37,
    0x3f, 0x6f, 0x38, 0x3f, 0x6f, 0x39, 0x3f, 0x6f, 0x3d, 0x3f, 0x6f, 0x41,
    0x3f, 0x6f, 0x5f, 0x3f, 0x6f, 0x62, 0x3f, 0x6f, 0x64, 0x3f, 0x6f, 0x66,
    0x3f, 0x6f, 0x67, 0x3f, 0x6f, 0x68, 0x3f, 0x6f, 0x6c, 0x3f, 0x6f, 0x6d,
    0x3f, 0x6f, 0x6e, 0x3f, 0x6f, 0x70, 0x3f, 0x6f, 0x72, 0x3f, 0x6f, 0x75,
    0x3f, 0x6f, 0x3a, 0x3f, 0x6f, 0x42, 0x3f, 0x6f, 0x43, 0x3f, 0x6f, 0x44,
    0x3f, 0x6f, 0x45, 0x3f, 0x6f, 0x46, 0x3f, 0x6f, 0x47, 0x3f, 0x6f, 0x48,
    0x3f, 0x6f, 0x49, 0x3f, 0x6f, 0x4a, 0x3f, 0x6f, 0x4b, 0x3f, 0x6f, 0x4c,
    0x3f, 0x6f, 0x4d, 0x3f, 0x6f, 0x4e, 0x3f, 0x6f, 0x4f, 0x3f, 0x6f, 0x50,
    0x3f, 0x6f, 0x51, 0x3f, 0x6f, 0x52, 0x3f, 0x6f, 0x53, 0x3f, 0x6f, 0x54,
    0x3f, 0x6f, 0x55, 0x3f, 0x6f, 0x56, 0x3f, 0x6f, 0x57, 0x3f, 0x6f, 0x59,
    0x3f, 0x6f, 0x6a, 0x3f, 0x6f, 0x6b, 0x3f, 0x6f, 0x71, 0x3f, 0x6f, 0x76,
    0x3f, 0x6f, 0x77, 0x3f, 0x6f, 0x78, 0x3f, 0x6f, 0x79, 0x3f, 0x6f, 0x7a};
const uint8_t HuffDecoderCommon::table19_8_emit_[204] = {
    0x3f, 0x73, 0x30, 0x3f, 0x73, 0x31, 0x3f, 0x73, 0x32, 0x3f, 0x73, 0x61,
    0x3f, 0x73, 0x63, 0x3f, 0x73, 0x65, 0x3f, 0x73, 0x69, 0x3f, 0x73, 0x6f,
    0x3f, 0x73, 0x73, 0x3f, 0x73, 0x74, 0x3f, 0x73, 0x20, 0x3f, 0x73, 0x25,
    0x3f, 0x73, 0x2d, 0x3f, 0x73, 0x2e, 0x3f, 0x73, 0x2f, 0x3f, 0x73, 0x33,
    0x3f, 0x73, 0x34, 0x3f, 0x73, 0x35, 0x3f, 0x73, 0x36, 0x3f, 0x73, 0x37,
    0x3f, 0x73, 0x38, 0x3f, 0x73, 0x39, 0x3f, 0x73, 0x3d, 0x3f, 0x73, 0x41,
    0x3f, 0x73, 0x5f, 0x3f, 0x73, 0x62, 0x3f, 0x73, 0x64, 0x3f, 0x73, 0x66,
    0x3f, 0x73, 0x67, 0x3f, 0x73, 0x68, 0x3f, 0x73, 0x6c, 0x3f, 0x73, 0x6d,
    0x3f, 0x73, 0x6e, 0x3f, 0x73, 0x70, 0x3f, 0x73, 0x72, 0x3f, 0x73, 0x75,
    0x3f, 0x73, 0x3a, 0x3f, 0x73, 0x42, 0x3f, 0x73, 0x43, 0x3f, 0x73, 0x44,
    0x3f, 0x73, 0x45, 0x3f, 0x73, 0x46, 0x3f, 0x73, 0x47, 0x3f, 0x73, 0x48,
    0x3f, 0x73, 0x49, 0x3f, 0x73, 0x4a, 0x3f, 0x73, 0x4b, 0x3f, 0x73, 0x4c,
    0x3f, 0x73, 0x4d, 0x3f, 0x73, 0x4e, 0x3f, 0x73, 0x4f, 0x3f, 0x73, 0x50,
    0x3f, 0x73, 0x51, 0x3f, 0x73, 0x52, 0x3f, 0x73, 0x53, 0x3f, 0x73, 0x54,
    0x3f, 0x73, 0x55, 0x3f, 0x73, 0x56, 0x3f, 0x73, 0x57, 0x3f, 0x73, 0x59,
    0x3f, 0x73, 0x6a, 0x3f, 0x73, 0x6b, 0x3f, 0x73, 0x71, 0x3f, 0x73, 0x76,
    0x3f, 0x73, 0x77, 0x3f, 0x73, 0x78, 0x3f, 0x73, 0x79, 0x3f, 0x73, 0x7a};
const uint8_t HuffDecoderCommon::table19_9_emit_[204] = {
    0x3f, 0x74, 0x30, 0x3f, 0x74, 0x31, 0x3f, 0x74, 0x32, 0x3f, 0x74, 0x61,
    0x3f, 0x74, 0x63, 0x3f, 0x74, 0x65, 0x3f, 0x74, 0x69, 0x3f, 0x74, 0x6f,
    0x3f, 0x74, 0x73, 0x3f, 0x74, 0x74, 0x3f, 0x74, 0x20, 0x3f, 0x74, 0x25,
    0x3f, 0x74, 0x2d, 0x3f, 0x74, 0x2e, 0x3f, 0x74, 0x2f, 0x3f, 0x74, 0x33,
    0x3f, 0x74, 0x34, 0x3f, 0x74, 0x35, 0x3f, 0x74, 0x36, 0x3f, 0x74, 0x37,
    0x3f, 0x74, 0x38, 0x3f, 0x74, 0x39, 0x3f, 0x74, 0x3d, 0x3f, 0x74, 0x41,
    0x3f, 0x74, 0x5f, 0x3f, 0x74, 0x62, 0x3f, 0x74, 0x64, 0x3f, 0x74, 0x66,
    0x3f, 0x74, 0x67, 0x3f, 0x74, 0x68, 0x3f, 0x74, 0x6c, 0x3f, 0x74, 0x6d,
    0x3f, 0x74, 0x6e, 0x3f, 0x74, 0x70, 0x3f, 0x74, 0x72, 0x3f, 0x74, 0x75,
    0x3f, 0x74, 0x3a, 0x3f, 0x74, 0x42, 0x3f, 0x74, 0x43, 0x3f, 0x74, 0x44,
    0x3f, 0x74, 0x45, 0x3f, 0x74, 0x46, 0x3f, 0x74, 0x47, 0x3f, 0x74, 0x48,
    0x3f, 0x74, 0x49, 0x3f, 0x74, 0x4a, 0x3f, 0x74, 0x4b, 0x3f, 0x74, 0x4c,
    0x3f, 0x74, 0x4d, 0x3f, 0x74, 0x4e, 0x3f, 0x74, 0x4f, 0x3f, 0x74, 0x50,
    0x3f, 0x74, 0x51, 0x3f, 0x74, 0x52, 0x3f, 0x74, 0x53, 0x3f, 0x74, 0x54,
    0x3f, 0x74, 0x55, 0x3f, 0x74, 0x56, 0x3f, 0x74, 0x57, 0x3f, 0x74, 0x59,
    0x3f, 0x74, 0x6a, 0x3f, 0x74, 0x6b, 0x3f, 0x74, 0x71, 0x3f, 0x74, 0x76,
    0x3f, 0x74, 0x77, 0x3f, 0x74, 0x78, 0x3f, 0x74, 0x79, 0x3f, 0x74, 0x7a};
const uint8_t HuffDecoderCommon::table19_10_emit_[216] = {
    0x3f, 0x20, 0x30, 0x3f, 0x20, 0x31, 0x3f, 0x20, 0x32, 0x3f, 0x20, 0x61,
    0x3f, 0x20, 0x63, 0x3f, 0x20, 0x65, 0x3f, 0x20, 0x69, 0x3f, 0x20, 0x6f,
    0x3f, 0x20, 0x73, 0x3f, 0x20, 0x74, 0x3f, 0x20, 0x20, 0x3f, 0x20, 0x25,
    0x3f, 0x20, 0x2d, 0x3f, 0x20, 0x2e, 0x3f, 0x20, 0x2f, 0x3f, 0x20, 0x33,
    0x3f, 0x20, 0x34, 0x3f, 0x20, 0x35, 0x3f, 0x20, 0x36, 0x3f, 0x20, 0x37,
    0x3f, 0x20, 0x38, 0x3f, 0x20, 0x39, 0x3f, 0x20, 0x3d, 0x3f, 0x20, 0x41,
    0x3f, 0x20, 0x5f, 0x3f, 0x20, 0x62, 0x3f, 0x20, 0x64, 0x3f, 0x20, 0x66,
    0x3f, 0x20, 0x67, 0x3f, 0x20, 0x68, 0x3f, 0x20, 0x6c, 0x3f, 0x20, 0x6d,
    0x3f, 0x20, 0x6e, 0x3f, 0x20, 0x70, 0x3f, 0x20, 0x72, 0x3f, 0x20, 0x75,
    0x3f, 0x25, 0x30, 0x3f, 0x25, 0x31, 0x3f, 0x25, 0x32, 0x3f, 0x25, 0x61,
    0x3f, 0x25, 0x63, 0x3f, 0x25, 0x65, 0x3f, 0x25, 0x69, 0x3f, 0x25, 0x6f,
    0x3f, 0x25, 0x73, 0x3f, 0x25, 0x74, 0x3f, 0x25, 0x20, 0x3f, 0x25, 0x25,
    0x3f, 0x25, 0x2d, 0x3f, 0x25, 0x2e, 0x3f, 0x25, 0x2f, 0x3f, 0x25, 0x33,
    0x3f, 0x25, 0x34, 0x3f, 0x25, 0x35, 0x3f, 0x25, 0x36, 0x3f, 0x25, 0x37,
    0x3f, 0x25, 0x38, 0x3f, 0x25, 0x39, 0x3f, 0x25, 0x3d, 0x3f, 0x25, 0x41,
    0x3f, 0x25, 0x5f, 0x3f, 0x25, 0x62, 0x3f, 0x25, 0x64, 0x3f, 0x25, 0x66,
    0x3f, 0x25, 0x67, 0x3f, 0x25, 0x68, 0x3f, 0x25, 0x6c, 0x3f, 0x25, 0x6d,
    0x3f, 0x25, 0x6e, 0x3f, 0x25, 0x70, 0x3f, 0x25, 0x72, 0x3f, 0x25, 0x75};
const uint16_t HuffDecoderCommon::table19_10_ops_[128] = {
    0x0000, 0x0001, 0x0000, 0x0019, 0x0000, 0x0031, 0x0000, 0x0049, 0x0000,
    0x0061, 0x0000, 0x0079, 0x0000, 0x0091, 0x0000, 0x00a9, 0x0000, 0x00c1,
    0x0000, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169, 0x0181,
    0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259,
    0x0271, 0x0289, 0x02a1, 0x02b9, 0x02d1, 0x02e9, 0x0301, 0x0319, 0x0331,
    0x0349, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0002, 0x0000, 0x0361, 0x0000, 0x0379, 0x0000, 0x0391, 0x0000, 0x03a9,
    0x0000, 0x03c1, 0x0000, 0x03d9, 0x0000, 0x03f1, 0x0000, 0x0409, 0x0000,
    0x0421, 0x0000, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9,
    0x04e1, 0x04f9, 0x0511, 0x0529, 0x0541, 0x0559, 0x0571, 0x0589, 0x05a1,
    0x05b9, 0x05d1, 0x05e9, 0x0601, 0x0619, 0x0631, 0x0649, 0x0661, 0x0679,
    0x0691, 0x06a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0362};
const uint8_t HuffDecoderCommon::table19_11_emit_[216] = {
    0x3f, 0x2d, 0x30, 0x3f, 0x2d, 0x31, 0x3f, 0x2d, 0x32, 0x3f, 0x2d, 0x61,
    0x3f, 0x2d, 0x63, 0x3f, 0x2d, 0x65, 0x3f, 0x2d, 0x69, 0x3f, 0x2d, 0x6f,
    0x3f, 0x2d, 0x73, 0x3f, 0x2d, 0x74, 0x3f, 0x2d, 0x20, 0x3f, 0x2d, 0x25,
    0x3f, 0x2d, 0x2d, 0x3f, 0x2d, 0x2e, 0x3f, 0x2d, 0x2f, 0x3f, 0x2d, 0x33,
    0x3f, 0x2d, 0x34, 0x3f, 0x2d, 0x35, 0x3f, 0x2d, 0x36, 0x3f, 0x2d, 0x37,
    0x3f, 0x2d, 0x38, 0x3f, 0x2d, 0x39, 0x3f, 0x2d, 0x3d, 0x3f, 0x2d, 0x41,
    0x3f, 0x2d, 0x5f, 0x3f, 0x2d, 0x62, 0x3f, 0x2d, 0x64, 0x3f, 0x2d, 0x66,
    0x3f, 0x2d, 0x67, 0x3f, 0x2d, 0x68, 0x3f, 0x2d, 0x6c, 0x3f, 0x2d, 0x6d,
    0x3f, 0x2d, 0x6e, 0x3f, 0x2d, 0x70, 0x3f, 0x2d, 0x72, 0x3f, 0x2d, 0x75,
    0x3f, 0x2e, 0x30, 0x3f, 0x2e, 0x31, 0x3f, 0x2e, 0x32, 0x3f, 0x2e, 0x61,
    0x3f, 0x2e, 0x63, 0x3f, 0x2e, 0x65, 0x3f, 0x2e, 0x69, 0x3f, 0x2e, 0x6f,
    0x3f, 0x2e, 0x73, 0x3f, 0x2e, 0x74, 0x3f, 0x2e, 0x20, 0x3f, 0x2e, 0x25,
    0x3f, 0x2e, 0x2d, 0x3f, 0x2e, 0x2e, 0x3f, 0x2e, 0x2f, 0x3f, 0x2e, 0x33,
    0x3f, 0x2e, 0x34, 0x3f, 0x2e, 0x35, 0x3f, 0x2e, 0x36, 0x3f, 0x2e, 0x37,
    0x3f, 0x2e, 0x38, 0x3f, 0x2e, 0x39, 0x3f, 0x2e, 0x3d, 0x3f, 0x2e, 0x41,
    0x3f, 0x2e, 0x5f, 0x3f, 0x2e, 0x62, 0x3f, 0x2e, 0x64, 0x3f, 0x2e, 0x66,
    0x3f, 0x2e, 0x67, 0x3f, 0x2e, 0x68, 0x3f, 0x2e, 0x6c, 0x3f, 0x2e, 0x6d,
    0x3f, 0x2e, 0x6e, 0x3f, 0x2e, 0x70, 0x3f, 0x2e, 0x72, 0x3f, 0x2e, 0x75};
const uint8_t HuffDecoderCommon::table19_12_emit_[216] = {
    0x3f, 0x2f, 0x30, 0x3f, 0x2f, 0x31, 0x3f, 0x2f, 0x32, 0x3f, 0x2f, 0x61,
    0x3f, 0x2f, 0x63, 0x3f, 0x2f, 0x65, 0x3f, 0x2f, 0x69, 0x3f, 0x2f, 0x6f,
    0x3f, 0x2f, 0x73, 0x3f, 0x2f, 0x74, 0x3f, 0x2f, 0x20, 0x3f, 0x2f, 0x25,
    0x3f, 0x2f, 0x2d, 0x3f, 0x2f, 0x2e, 0x3f, 0x2f, 0x2f, 0x3f, 0x2f, 0x33,
    0x3f, 0x2f, 0x34, 0x3f, 0x2f, 0x35, 0x3f, 0x2f, 0x36, 0x3f, 0x2f, 0x37,
    0x3f, 0x2f, 0x38, 0x3f, 0x2f, 0x39, 0x3f, 0x2f, 0x3d, 0x3f, 0x2f, 0x41,
    0x3f, 0x2f, 0x5f, 0x3f, 0x2f, 0x62, 0x3f, 0x2f, 0x64, 0x3f, 0x2f, 0x66,
    0x3f, 0x2f, 0x67, 0x3f, 0x2f, 0x68, 0x3f, 0x2f, 0x6c, 0x3f, 0x2f, 0x6d,
    0x3f, 0x2f, 0x6e, 0x3f, 0x2f, 0x70, 0x3f, 0x2f, 0x72, 0x3f, 0x2f, 0x75,
    0x3f, 0x33, 0x30, 0x3f, 0x33, 0x31, 0x3f, 0x33, 0x32, 0x3f, 0x33, 0x61,
    0x3f, 0x33, 0x63, 0x3f, 0x33, 0x65, 0x3f, 0x33, 0x69, 0x3f, 0x33, 0x6f,
    0x3f, 0x33, 0x73, 0x3f, 0x33, 0x74, 0x3f, 0x33, 0x20, 0x3f, 0x33, 0x25,
    0x3f, 0x33, 0x2d, 0x3f, 0x33, 0x2e, 0x3f, 0x33, 0x2f, 0x3f, 0x33, 0x33,
    0x3f, 0x33, 0x34, 0x3f, 0x33, 0x35, 0x3f, 0x33, 0x36, 0x3f, 0x33, 0x37,
    0x3f, 0x33, 0x38, 0x3f, 0x33, 0x39, 0x3f, 0x33, 0x3d, 0x3f, 0x33, 0x41,
    0x3f, 0x33, 0x5f, 0x3f, 0x33, 0x62, 0x3f, 0x33, 0x64, 0x3f, 0x33, 0x66,
    0x3f, 0x33, 0x67, 0x3f, 0x33, 0x68, 0x3f, 0x33, 0x6c, 0x3f, 0x33, 0x6d,
    0x3f, 0x33, 0x6e, 0x3f, 0x33, 0x70, 0x3f, 0x33, 0x72, 0x3f, 0x33, 0x75};
const uint8_t HuffDecoderCommon::table19_13_emit_[216] = {
    0x3f, 0x34, 0x30, 0x3f, 0x34, 0x31, 0x3f, 0x34, 0x32, 0x3f, 0x34, 0x61,
    0x3f, 0x34, 0x63, 0x3f, 0x34, 0x65, 0x3f, 0x34, 0x69, 0x3f, 0x34, 0x6f,
    0x3f, 0x34, 0x73, 0x3f, 0x34, 0x74, 0x3f, 0x34, 0x20, 0x3f, 0x34, 0x25,
    0x3f, 0x34, 0x2d, 0x3f, 0x34, 0x2e, 0x3f, 0x34, 0x2f, 0x3f, 0x34, 0x33,
    0x3f, 0x34, 0x34, 0x3f, 0x34, 0x35, 0x3f, 0x34, 0x36, 0x3f, 0x34, 0x37,
    0x3f, 0x34, 0x38, 0x3f, 0x34, 0x39, 0x3f, 0x34, 0x3d, 0x3f, 0x34, 0x41,
    0x3f, 0x34, 0x5f, 0x3f, 0x34, 0x62, 0x3f, 0x34, 0x64, 0x3f, 0x34, 0x66,
    0x3f, 0x34, 0x67, 0x3f, 0x34, 0x68, 0x3f, 0x34, 0x6c, 0x3f, 0x34, 0x6d,
    0x3f, 0x34, 0x6e, 0x3f, 0x34, 0x70, 0x3f, 0x34, 0x72, 0x3f, 0x34, 0x75,
    0x3f, 0x35, 0x30, 0x3f, 0x35, 0x31, 0x3f, 0x35, 0x32, 0x3f, 0x35, 0x61,
    0x3f, 0x35, 0x63, 0x3f, 0x35, 0x65, 0x3f, 0x35, 0x69, 0x3f, 0x35, 0x6f,
    0x3f, 0x35, 0x73, 0x3f, 0x35, 0x74, 0x3f, 0x35, 0x20, 0x3f, 0x35, 0x25,
    0x3f, 0x35, 0x2d, 0x3f, 0x35, 0x2e, 0x3f, 0x35, 0x2f, 0x3f, 0x35, 0x33,
    0x3f, 0x35, 0x34, 0x3f, 0x35, 0x35, 0x3f, 0x35, 0x36, 0x3f, 0x35, 0x37,
    0x3f, 0x35, 0x38, 0x3f, 0x35, 0x39, 0x3f, 0x35, 0x3d, 0x3f, 0x35, 0x41,
    0x3f, 0x35, 0x5f, 0x3f, 0x35, 0x62, 0x3f, 0x35, 0x64, 0x3f, 0x35, 0x66,
    0x3f, 0x35, 0x67, 0x3f, 0x35, 0x68, 0x3f, 0x35, 0x6c, 0x3f, 0x35, 0x6d,
    0x3f, 0x35, 0x6e, 0x3f, 0x35, 0x70, 0x3f, 0x35, 0x72, 0x3f, 0x35, 0x75};
const uint8_t HuffDecoderCommon::table19_14_emit_[216] = {
    0x3f, 0x36, 0x30, 0x3f, 0x36, 0x31, 0x3f, 0x36, 0x32, 0x3f, 0x36, 0x61,
    0x3f, 0x36, 0x63, 0x3f, 0x36, 0x65, 0x3f, 0x36, 0x69, 0x3f, 0x36, 0x6f,
    0x3f, 0x36, 0x73, 0x3f, 0x36, 0x74, 0x3f, 0x36, 0x20, 0x3f, 0x36, 0x25,
    0x3f, 0x36, 0x2d, 0x3f, 0x36, 0x2e, 0x3f, 0x36, 0x2f, 0x3f, 0x36, 0x33,
    0x3f, 0x36, 0x34, 0x3f, 0x36, 0x35, 0x3f, 0x36, 0x36, 0x3f, 0x36, 0x37,
    0x3f, 0x36, 0x38, 0x3f, 0x36, 0x39, 0x3f, 0x36, 0x3d, 0x3f, 0x36, 0x41,
    0x3f, 0x36, 0x5f, 0x3f, 0x36, 0x62, 0x3f, 0x36, 0x64, 0x3f, 0x36, 0x66,
    0x3f, 0x36, 0x67, 0x3f, 0x36, 0x68, 0x3f, 0x36, 0x6c, 0x3f, 0x36, 0x6d,
    0x3f, 0x36, 0x6e, 0x3f, 0x36, 0x70, 0x3f, 0x36, 0x72, 0x3f, 0x36, 0x75,
    0x3f, 0x37, 0x30, 0x3f, 0x37, 0x31, 0x3f, 0x37, 0x32, 0x3f, 0x37, 0x61,
    0x3f, 0x37, 0x63, 0x3f, 0x37, 0x65, 0x3f, 0x37, 0x69, 0x3f, 0x37, 0x6f,
    0x3f, 0x37, 0x73, 0x3f, 0x37, 0x74, 0x3f, 0x37, 0x20, 0x3f, 0x37, 0x25,
    0x3f, 0x37, 0x2d, 0x3f, 0x37, 0x2e, 0x3f, 0x37, 0x2f, 0x3f, 0x37, 0x33,
    0x3f, 0x37, 0x34, 0x3f, 0x37, 0x35, 0x3f, 0x37, 0x36, 0x3f, 0x37, 0x37,
    0x3f, 0x37, 0x38, 0x3f, 0x37, 0x39, 0x3f, 0x37, 0x3d, 0x3f, 0x37, 0x41,
    0x3f, 0x37, 0x5f, 0x3f, 0x37, 0x62, 0x3f, 0x37, 0x64, 0x3f, 0x37, 0x66,
    0x3f, 0x37, 0x67, 0x3f, 0x37, 0x68, 0x3f, 0x37, 0x6c, 0x3f, 0x37, 0x6d,
    0x3f, 0x37, 0x6e, 0x3f, 0x37, 0x70, 0x3f, 0x37, 0x72, 0x3f, 0x37, 0x75};
const uint8_t HuffDecoderCommon::table19_15_emit_[216] = {
    0x3f, 0x38, 0x30, 0x3f, 0x38, 0x31, 0x3f, 0x38, 0x32, 0x3f, 0x38, 0x61,
    0x3f, 0x38, 0x63, 0x3f, 0x38, 0x65, 0x3f, 0x38, 0x69, 0x3f, 0x38, 0x6f,
    0x3f, 0x38, 0x73, 0x3f, 0x38, 0x74, 0x3f, 0x38, 0x20, 0x3f, 0x38, 0x25,
    0x3f, 0x38, 0x2d, 0x3f, 0x38, 0x2e, 0x3f, 0x38, 0x2f, 0x3f, 0x38, 0x33,
    0x3f, 0x38, 0x34, 0x3f, 0x38, 0x35, 0x3f, 0x38, 0x36, 0x3f, 0x38, 0x37,
    0x3f, 0x38, 0x38, 0x3f, 0x38, 0x39, 0x3f, 0x38, 0x3d, 0x3f, 0x38, 0x41,
    0x3f, 0x38, 0x5f, 0x3f, 0x38, 0x62, 0x3f, 0x38, 0x64, 0x3f, 0x38, 0x66,
    0x3f, 0x38, 0x67, 0x3f, 0x38, 0x68, 0x3f, 0x38, 0x6c, 0x3f, 0x38, 0x6d,
    0x3f, 0x38, 0x6e, 0x3f, 0x38, 0x70, 0x3f, 0x38, 0x72, 0x3f, 0x38, 0x75,
    0x3f, 0x39, 0x30, 0x3f, 0x39, 0x31, 0x3f, 0x39, 0x32, 0x3f, 0x39, 0x61,
    0x3f, 0x39, 0x63, 0x3f, 0x39, 0x65, 0x3f, 0x39, 0x69, 0x3f, 0x39, 0x6f,
    0x3f, 0x39, 0x73, 0x3f, 0x39, 0x74, 0x3f, 0x39, 0x20, 0x3f, 0x39, 0x25,
    0x3f, 0x39, 0x2d, 0x3f, 0x39, 0x2e, 0x3f, 0x39, 0x2f, 0x3f, 0x39, 0x33,
    0x3f, 0x39, 0x34, 0x3f, 0x39, 0x35, 0x3f, 0x39, 0x36, 0x3f, 0x39, 0x37,
    0x3f, 0x39, 0x38, 0x3f, 0x39, 0x39, 0x3f, 0x39, 0x3d, 0x3f, 0x39, 0x41,
    0x3f, 0x39, 0x5f, 0x3f, 0x39, 0x62, 0x3f, 0x39, 0x64, 0x3f, 0x39, 0x66,
    0x3f, 0x39, 0x67, 0x3f, 0x39, 0x68, 0x3f, 0x39, 0x6c, 0x3f, 0x39, 0x6d,
    0x3f, 0x39, 0x6e, 0x3f, 0x39, 0x70, 0x3f, 0x39, 0x72, 0x3f, 0x39, 0x75};
const uint8_t HuffDecoderCommon::table19_16_emit_[216] = {
    0x3f, 0x3d, 0x30, 0x3f, 0x3d, 0x31, 0x3f, 0x3d, 0x32, 0x3f, 0x3d, 0x61,
    0x3f, 0x3d, 0x63, 0x3f, 0x3d, 0x65, 0x3f, 0x3d, 0x69, 0x3f, 0x3d, 0x6f,
    0x3f, 0x3d, 0x73, 0x3f, 0x3d, 0x74, 0x3f, 0x3d, 0x20, 0x3f, 0x3d, 0x25,
    0x3f, 0x3d, 0x2d, 0x3f, 0x3d, 0x2e, 0x3f, 0x3d, 0x2f, 0x3f, 0x3d, 0x33,
    0x3f, 0x3d, 0x34, 0x3f, 0x3d, 0x35, 0x3f, 0x3d, 0x36, 0x3f, 0x3d, 0x37,
    0x3f, 0x3d, 0x38, 0x3f, 0x3d, 0x39, 0x3f, 0x3d, 0x3d, 0x3f, 0x3d, 0x41,
    0x3f, 0x3d, 0x5f, 0x3f, 0x3d, 0x62, 0x3f, 0x3d, 0x64, 0x3f, 0x3d, 0x66,
    0x3f, 0x3d, 0x67, 0x3f, 0x3d, 0x68, 0x3f, 0x3d, 0x6c, 0x3f, 0x3d, 0x6d,
    0x3f, 0x3d, 0x6e, 0x3f, 0x3d, 0x70, 0x3f, 0x3d, 0x72, 0x3f, 0x3d, 0x75,
    0x3f, 0x41, 0x30, 0x3f, 0x41, 0x31, 0x3f, 0x41, 0x32, 0x3f, 0x41, 0x61,
    0x3f, 0x41, 0x63, 0x3f, 0x41, 0x65, 0x3f, 0x41, 0x69, 0x3f, 0x41, 0x6f,
    0x3f, 0x41, 0x73, 0x3f, 0x41, 0x74, 0x3f, 0x41, 0x20, 0x3f, 0x41, 0x25,
    0x3f, 0x41, 0x2d, 0x3f, 0x41, 0x2e, 0x3f, 0x41, 0x2f, 0x3f, 0x41, 0x33,
    0x3f, 0x41, 0x34, 0x3f, 0x41, 0x35, 0x3f, 0x41, 0x36, 0x3f, 0x41, 0x37,
    0x3f, 0x41, 0x38, 0x3f, 0x41, 0x39, 0x3f, 0x41, 0x3d, 0x3f, 0x41, 0x41,
    0x3f, 0x41, 0x5f, 0x3f, 0x41, 0x62, 0x3f, 0x41, 0x64, 0x3f, 0x41, 0x66,
    0x3f, 0x41, 0x67, 0x3f, 0x41, 0x68, 0x3f, 0x41, 0x6c, 0x3f, 0x41, 0x6d,
    0x3f, 0x41, 0x6e, 0x3f, 0x41, 0x70, 0x3f, 0x41, 0x72, 0x3f, 0x41, 0x75};
const uint8_t HuffDecoderCommon::table19_17_emit_[216] = {
    0x3f, 0x5f, 0x30, 0x3f, 0x5f, 0x31, 0x3f, 0x5f, 0x32, 0x3f, 0x5f, 0x61,
    0x3f, 0x5f, 0x63, 0x3f, 0x5f, 0x65, 0x3f, 0x5f, 0x69, 0x3f, 0x5f, 0x6f,
    0x3f, 0x5f, 0x73, 0x3f, 0x5f, 0x74, 0x3f, 0x5f, 0x20, 0x3f, 0x5f, 0x25,
    0x3f, 0x5f, 0x2d, 0x3f, 0x5f, 0x2e, 0x3f, 0x5f, 0x2f, 0x3f, 0x5f, 0x33,
    0x3f, 0x5f, 0x34, 0x3f, 0x5f, 0x35, 0x3f, 0x5f, 0x36, 0x3f, 0x5f, 0x37,
    0x3f, 0x5f, 0x38, 0x3f, 0x5f, 0x39, 0x3f, 0x5f, 0x3d, 0x3f, 0x5f, 0x41,
    0x3f, 0x5f, 0x5f, 0x3f, 0x5f, 0x62, 0x3f, 0x5f, 0x64, 0x3f, 0x5f, 0x66,
    0x3f, 0x5f, 0x67, 0x3f, 0x5f, 0x68, 0x3f, 0x5f, 0x6c, 0x3f, 0x5f, 0x6d,
    0x3f, 0x5f, 0x6e, 0x3f, 0x5f, 0x70, 0x3f, 0x5f, 0x72, 0x3f, 0x5f, 0x75,
    0x3f, 0x62, 0x30, 0x3f, 0x62, 0x31, 0x3f, 0x62, 0x32, 0x3f, 0x62, 0x61,
    0x3f, 0x62, 0x63, 0x3f, 0x62, 0x65, 0x3f, 0x62, 0x69, 0x3f, 0x62, 0x6f,
    0x3f, 0x62, 0x73, 0x3f, 0x62, 0x74, 0x3f, 0x62, 0x20, 0x3f, 0x62, 0x25,
    0x3f, 0x62, 0x2d, 0x3f, 0x62, 0x2e, 0x3f, 0x62, 0x2f, 0x3f, 0x62, 0x33,
    0x3f, 0x62, 0x34, 0x3f, 0x62, 0x35, 0x3f, 0x62, 0x36, 0x3f, 0x62, 0x37,
    0x3f, 0x62, 0x38, 0x3f, 0x62, 0x39, 0x3f, 0x62, 0x3d, 0x3f, 0x62, 0x41,
    0x3f, 0x62, 0x5f, 0x3f, 0x62, 0x62, 0x3f, 0x62, 0x64, 0x3f, 0x62, 0x66,
    0x3f, 0x62, 0x67, 0x3f, 0x62, 0x68, 0x3f, 0x62, 0x6c, 0x3f, 0x62, 0x6d,
    0x3f, 0x62, 0x6e, 0x3f, 0x62, 0x70, 0x3f, 0x62, 0x72, 0x3f, 0x62, 0x75};
const uint8_t HuffDecoderCommon::table19_18_emit_[216] = {
    0x3f, 0x64, 0x30, 0x3f, 0x64, 0x31, 0x3f, 0x64, 0x32, 0x3f, 0x64, 0x61,
    0x3f, 0x64, 0x63, 0x3f, 0x64, 0x65, 0x3f, 0x64, 0x69, 0x3f, 0x64, 0x6f,
    0x3f, 0x64, 0x73, 0x3f, 0x64, 0x74, 0x3f, 0x64, 0x20, 0x3f, 0x64, 0x25,
    0x3f, 0x64, 0x2d, 0x3f, 0x64, 0x2e, 0x3f, 0x64, 0x2f, 0x3f, 0x64, 0x33,
    0x3f, 0x64, 0x34, 0x3f, 0x64, 0x35, 0x3f, 0x64, 0x36, 0x3f, 0x64, 0x37,
    0x3f, 0x64, 0x38, 0x3f, 0x64, 0x39, 0x3f, 0x64, 0x3d, 0x3f, 0x64, 0x41,
    0x3f, 0x64, 0x5f, 0x3f, 0x64, 0x62, 0x3f, 0x64, 0x64, 0x3f, 0x64, 0x66,
    0x3f, 0x64, 0x67, 0x3f, 0x64, 0x68, 0x3f, 0x64, 0x6c, 0x3f, 0x64, 0x6d,
    0x3f, 0x64, 0x6e, 0x3f, 0x64, 0x70, 0x3f, 0x64, 0x72, 0x3f, 0x64, 0x75,
    0x3f, 0x66, 0x30, 0x3f, 0x66, 0x31, 0x3f, 0x66, 0x32, 0x3f, 0x66, 0x61,
    0x3f, 0x66, 0x63, 0x3f, 0x66, 0x65, 0x3f, 0x66, 0x69, 0x3f, 0x66, 0x6f,
    0x3f, 0x66, 0x73, 0x3f, 0x66, 0x74, 0x3f, 0x66, 0x20, 0x3f, 0x66, 0x25,
    0x3f, 0x66, 0x2d, 0x3f, 0x66, 0x2e, 0x3f, 0x66, 0x2f, 0x3f, 0x66, 0x33,
    0x3f, 0x66, 0x34, 0x3f, 0x66, 0x35, 0x3f, 0x66, 0x36, 0x3f, 0x66, 0x37,
    0x3f, 0x66, 0x38, 0x3f, 0x66, 0x39, 0x3f, 0x66, 0x3d, 0x3f, 0x66, 0x41,
    0x3f, 0x66, 0x5f, 0x3f, 0x66, 0x62, 0x3f, 0x66, 0x64, 0x3f, 0x66, 0x66,
    0x3f, 0x66, 0x67, 0x3f, 0x66, 0x68, 0x3f, 0x66, 0x6c, 0x3f, 0x66, 0x6d,
    0x3f, 0x66, 0x6e, 0x3f, 0x66, 0x70, 0x3f, 0x66, 0x72, 0x3f, 0x66, 0x75};
const uint8_t HuffDecoderCommon::table19_19_emit_[216] = {
    0x3f, 0x67, 0x30, 0x3f, 0x67, 0x31, 0x3f, 0x67, 0x32, 0x3f, 0x67, 0x61,
    0x3f, 0x67, 0x63, 0x3f, 0x67, 0x65, 0x3f, 0x67, 0x69, 0x3f, 0x67, 0x6f,
    0x3f, 0x67, 0x73, 0x3f, 0x67, 0x74, 0x3f, 0x67, 0x20, 0x3f, 0x67, 0x25,
    0x3f, 0x67, 0x2d, 0x3f, 0x67, 0x2e, 0x3f, 0x67, 0x2f, 0x3f, 0x67, 0x33,
    0x3f, 0x67, 0x34, 0x3f, 0x67, 0x35, 0x3f, 0x67, 0x36, 0x3f, 0x67, 0x37,
    0x3f, 0x67, 0x38, 0x3f, 0x67, 0x39, 0x3f, 0x67, 0x3d, 0x3f, 0x67, 0x41,
    0x3f, 0x67, 0x5f, 0x3f, 0x67, 0x62, 0x3f, 0x67, 0x64, 0x3f, 0x67, 0x66,
    0x3f, 0x67, 0x67, 0x3f, 0x67, 0x68, 0x3f, 0x67, 0x6c, 0x3f, 0x67, 0x6d,
    0x3f, 0x67, 0x6e, 0x3f, 0x67, 0x70, 0x3f, 0x67, 0x72, 0x3f, 0x67, 0x75,
    0x3f, 0x68, 0x30, 0x3f, 0x68, 0x31, 0x3f, 0x68, 0x32, 0x3f, 0x68, 0x61,
    0x3f, 0x68, 0x63, 0x3f, 0x68, 0x65, 0x3f, 0x68, 0x69, 0x3f, 0x68, 0x6f,
    0x3f, 0x68, 0x73, 0x3f, 0x68, 0x74, 0x3f, 0x68, 0x20, 0x3f, 0x68, 0x25,
    0x3f, 0x68, 0x2d, 0x3f, 0x68, 0x2e, 0x3f, 0x68, 0x2f, 0x3f, 0x68, 0x33,
    0x3f, 0x68, 0x34, 0x3f, 0x68, 0x35, 0x3f, 0x68, 0x36, 0x3f, 0x68, 0x37,
    0x3f, 0x68, 0x38, 0x3f, 0x68, 0x39, 0x3f, 0x68, 0x3d, 0x3f, 0x68, 0x41,
    0x3f, 0x68, 0x5f, 0x3f, 0x68, 0x62, 0x3f, 0x68, 0x64, 0x3f, 0x68, 0x66,
    0x3f, 0x68, 0x67, 0x3f, 0x68, 0x68, 0x3f, 0x68, 0x6c, 0x3f, 0x68, 0x6d,
    0x3f, 0x68, 0x6e, 0x3f, 0x68, 0x70, 0x3f, 0x68, 0x72, 0x3f, 0x68, 0x75};
const uint8_t HuffDecoderCommon::table19_20_emit_[216] = {
    0x3f, 0x6c, 0x30, 0x3f, 0x6c, 0x31, 0x3f, 0x6c, 0x32, 0x3f, 0x6c, 0x61,
    0x3f, 0x6c, 0x63, 0x3f, 0x6c, 0x65, 0x3f, 0x6c, 0x69, 0x3f, 0x6c, 0x6f,
    0x3f, 0x6c, 0x73, 0x3f, 0x6c, 0x74, 0x3f, 0x6c, 0x20, 0x3f, 0x6c, 0x25,
    0x3f, 0x6c, 0x2d, 0x3f, 0x6c, 0x2e, 0x3f, 0x6c, 0x2f, 0x3f, 0x6c, 0x33,
    0x3f, 0x6c, 0x34, 0x3f, 0x6c, 0x35, 0x3f, 0x6c, 0x36, 0x3f, 0x6c, 0x37,
    0x3f, 0x6c, 0x38, 0x3f, 0x6c, 0x39, 0x3f, 0x6c, 0x3d, 0x3f, 0x6c, 0x41,
    0x3f, 0x6c, 0x5f, 0x3f, 0x6c, 0x62, 0x3f, 0x6c, 0x64, 0x3f, 0x6c, 0x66,
    0x3f, 0x6c, 0x67, 0x3f, 0x6c, 0x68, 0x3f, 0x6c, 0x6c, 0x3f, 0x6c, 0x6d,
    0x3f, 0x6c, 0x6e, 0x3f, 0x6c, 0x70, 0x3f, 0x6c, 0x72, 0x3f, 0x6c, 0x75,
    0x3f, 0x6d, 0x30, 0x3f, 0x6d, 0x31, 0x3f, 0x6d, 0x32, 0x3f, 0x6d, 0x61,
    0x3f, 0x6d, 0x63, 0x3f, 0x6d, 0x65, 0x3f, 0x6d, 0x69, 0x3f, 0x6d, 0x6f,
    0x3f, 0x6d, 0x73, 0x3f, 0x6d, 0x74, 0x3f, 0x6d, 0x20, 0x3f, 0x6d, 0x25,
    0x3f, 0x6d, 0x2d, 0x3f, 0x6d, 0x2e, 0x3f, 0x6d, 0x2f, 0x3f, 0x6d, 0x33,
    0x3f, 0x6d, 0x34, 0x3f, 0x6d, 0x35, 0x3f, 0x6d, 0x36, 0x3f, 0x6d, 0x37,
    0x3f, 0x6d, 0x38, 0x3f, 0x6d, 0x39, 0x3f, 0x6d, 0x3d, 0x3f, 0x6d, 0x41,
    0x3f, 0x6d, 0x5f, 0x3f, 0x6d, 0x62, 0x3f, 0x6d, 0x64, 0x3f, 0x6d, 0x66,
    0x3f, 0x6d, 0x67, 0x3f, 0x6d, 0x68, 0x3f, 0x6d, 0x6c, 0x3f, 0x6d, 0x6d,
    0x3f, 0x6d, 0x6e, 0x3f, 0x6d, 0x70, 0x3f, 0x6d, 0x72, 0x3f, 0x6d, 0x75};
const uint8_t HuffDecoderCommon::table19_21_emit_[216] = {
    0x3f, 0x6e, 0x30, 0x3f, 0x6e, 0x31, 0x3f, 0x6e, 0x32, 0x3f, 0x6e, 0x61,
    0x3f, 0x6e, 0x63, 0x3f, 0x6e, 0x65, 0x3f, 0x6e, 0x69, 0x3f, 0x6e, 0x6f,
    0x3f, 0x6e, 0x73, 0x3f, 0x6e, 0x74, 0x3f, 0x6e, 0x20, 0x3f, 0x6e, 0x25,
    0x3f, 0x6e, 0x2d, 0x3f, 0x6e, 0x2e, 0x3f, 0x6e, 0x2f, 0x3f, 0x6e, 0x33,
    0x3f, 0x6e, 0x34, 0x3f, 0x6e, 0x35, 0x3f, 0x6e, 0x36, 0x3f, 0x6e, 0x37,
    0x3f, 0x6e, 0x38, 0x3f, 0x6e, 0x39, 0x3f, 0x6e, 0x3d, 0x3f, 0x6e, 0x41,
    0x3f, 0x6e, 0x5f, 0x3f, 0x6e, 0x62, 0x3f, 0x6e, 0x64, 0x3f, 0x6e, 0x66,
    0x3f, 0x6e, 0x67, 0x3f, 0x6e, 0x68, 0x3f, 0x6e, 0x6c, 0x3f, 0x6e, 0x6d,
    0x3f, 0x6e, 0x6e, 0x3f, 0x6e, 0x70, 0x3f, 0x6e, 0x72, 0x3f, 0x6e, 0x75,
    0x3f, 0x70, 0x30, 0x3f, 0x70, 0x31, 0x3f, 0x70, 0x32, 0x3f, 0x70, 0x61,
    0x3f, 0x70, 0x63, 0x3f, 0x70, 0x65, 0x3f, 0x70, 0x69, 0x3f, 0x70, 0x6f,
    0x3f, 0x70, 0x73, 0x3f, 0x70, 0x74, 0x3f, 0x70, 0x20, 0x3f, 0x70, 0x25,
    0x3f, 0x70, 0x2d, 0x3f, 0x70, 0x2e, 0x3f, 0x70, 0x2f, 0x3f, 0x70, 0x33,
    0x3f, 0x70, 0x34, 0x3f, 0x70, 0x35, 0x3f, 0x70, 0x36, 0x3f, 0x70, 0x37,
    0x3f, 0x70, 0x38, 0x3f, 0x70, 0x39, 0x3f, 0x70, 0x3d, 0x3f, 0x70, 0x41,
    0x3f, 0x70, 0x5f, 0x3f, 0x70, 0x62, 0x3f, 0x70, 0x64, 0x3f, 0x70, 0x66,
    0x3f, 0x70, 0x67, 0x3f, 0x70, 0x68, 0x3f, 0x70, 0x6c, 0x3f, 0x70, 0x6d,
    0x3f, 0x70, 0x6e, 0x3f, 0x70, 0x70, 0x3f, 0x70, 0x72, 0x3f, 0x70, 0x75};
const uint8_t HuffDecoderCommon::table19_22_emit_[216] = {
    0x3f, 0x72, 0x30, 0x3f, 0x72, 0x31, 0x3f, 0x72, 0x32, 0x3f, 0x72, 0x61,
    0x3f, 0x72, 0x63, 0x3f, 0x72, 0x65, 0x3f, 0x72, 0x69, 0x3f, 0x72, 0x6f,
    0x3f, 0x72, 0x73, 0x3f, 0x72, 0x74, 0x3f, 0x72, 0x20, 0x3f, 0x72, 0x25,
    0x3f, 0x72, 0x2d, 0x3f, 0x72, 0x2e, 0x3f, 0x72, 0x2f, 0x3f, 0x72, 0x33,
    0x3f, 0x72, 0x34, 0x3f, 0x72, 0x35, 0x3f, 0x72, 0x36, 0x3f, 0x72, 0x37,
    0x3f, 0x72, 0x38, 0x3f, 0x72, 0x39, 0x3f, 0x72, 0x3d, 0x3f, 0x72, 0x41,
    0x3f, 0x72, 0x5f, 0x3f, 0x72, 0x62, 0x3f, 0x72, 0x64, 0x3f, 0x72, 0x66,
    0x3f, 0x72, 0x67, 0x3f, 0x72, 0x68, 0x3f, 0x72, 0x6c, 0x3f, 0x72, 0x6d,
    0x3f, 0x72, 0x6e, 0x3f, 0x72, 0x70, 0x3f, 0x72, 0x72, 0x3f, 0x72, 0x75,
    0x3f, 0x75, 0x30, 0x3f, 0x75, 0x31, 0x3f, 0x75, 0x32, 0x3f, 0x75, 0x61,
    0x3f, 0x75, 0x63, 0x3f, 0x75, 0x65, 0x3f, 0x75, 0x69, 0x3f, 0x75, 0x6f,
    0x3f, 0x75, 0x73, 0x3f, 0x75, 0x74, 0x3f, 0x75, 0x20, 0x3f, 0x75, 0x25,
    0x3f, 0x75, 0x2d, 0x3f, 0x75, 0x2e, 0x3f, 0x75, 0x2f, 0x3f, 0x75, 0x33,
    0x3f, 0x75, 0x34, 0x3f, 0x75, 0x35, 0x3f, 0x75, 0x36, 0x3f, 0x75, 0x37,
    0x3f, 0x75, 0x38, 0x3f, 0x75, 0x39, 0x3f, 0x75, 0x3d, 0x3f, 0x75, 0x41,
    0x3f, 0x75, 0x5f, 0x3f, 0x75, 0x62, 0x3f, 0x75, 0x64, 0x3f, 0x75, 0x66,
    0x3f, 0x75, 0x67, 0x3f, 0x75, 0x68, 0x3f, 0x75, 0x6c, 0x3f, 0x75, 0x6d,
    0x3f, 0x75, 0x6e, 0x3f, 0x75, 0x70, 0x3f, 0x75, 0x72, 0x3f, 0x75, 0x75};
const uint8_t HuffDecoderCommon::table19_23_emit_[120] = {
    0x3f, 0x3a, 0x30, 0x3f, 0x3a, 0x31, 0x3f, 0x3a, 0x32, 0x3f, 0x3a, 0x61,
    0x3f, 0x3a, 0x63, 0x3f, 0x3a, 0x65, 0x3f, 0x3a, 0x69, 0x3f, 0x3a, 0x6f,
    0x3f, 0x3a, 0x73, 0x3f, 0x3a, 0x74, 0x3f, 0x42, 0x30, 0x3f, 0x42, 0x31,
    0x3f, 0x42, 0x32, 0x3f, 0x42, 0x61, 0x3f, 0x42, 0x63, 0x3f, 0x42, 0x65,
    0x3f, 0x42, 0x69, 0x3f, 0x42, 0x6f, 0x3f, 0x42, 0x73, 0x3f, 0x42, 0x74,
    0x3f, 0x43, 0x30, 0x3f, 0x43, 0x31, 0x3f, 0x43, 0x32, 0x3f, 0x43, 0x61,
    0x3f, 0x43, 0x63, 0x3f, 0x43, 0x65, 0x3f, 0x43, 0x69, 0x3f, 0x43, 0x6f,
    0x3f, 0x43, 0x73, 0x3f, 0x43, 0x74, 0x3f, 0x44, 0x30, 0x3f, 0x44, 0x31,
    0x3f, 0x44, 0x32, 0x3f, 0x44, 0x61, 0x3f, 0x44, 0x63, 0x3f, 0x44, 0x65,
    0x3f, 0x44, 0x69, 0x3f, 0x44, 0x6f, 0x3f, 0x44, 0x73, 0x3f, 0x44, 0x74};
const uint16_t HuffDecoderCommon::table19_23_ops_[128] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9, 0x00c1,
    0x00d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x00f1, 0x0109, 0x0121, 0x0139,
    0x0151, 0x0169, 0x0181, 0x0199, 0x01b1, 0x01c9, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x00f2, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259, 0x0271, 0x0289,
    0x02a1, 0x02b9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01e2, 0x02d1, 0x02e9, 0x0301,
    0x0319, 0x0331, 0x0349, 0x0361, 0x0379, 0x0391, 0x03a9, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x02d2};
const uint8_t HuffDecoderCommon::table19_24_emit_[120] = {
    0x3f, 0x45, 0x30, 0x3f, 0x45, 0x31, 0x3f, 0x45, 0x32, 0x3f, 0x45, 0x61,
    0x3f, 0x45, 0x63, 0x3f, 0x45, 0x65, 0x3f, 0x45, 0x69, 0x3f, 0x45, 0x6f,
    0x3f, 0x45, 0x73, 0x3f, 0x45, 0x74, 0x3f, 0x46, 0x30, 0x3f, 0x46, 0x31,
    0x3f, 0x46, 0x32, 0x3f, 0x46, 0x61, 0x3f, 0x46, 0x63, 0x3f, 0x46, 0x65,
    0x3f, 0x46, 0x69, 0x3f, 0x46, 0x6f, 0x3f, 0x46, 0x73, 0x3f, 0x46, 0x74,
    0x3f, 0x47, 0x30, 0x3f, 0x47, 0x31, 0x3f, 0x47, 0x32, 0x3f, 0x47, 0x61,
    0x3f, 0x47, 0x63, 0x3f, 0x47, 0x65, 0x3f, 0x47, 0x69, 0x3f, 0x47, 0x6f,
    0x3f, 0x47, 0x73, 0x3f, 0x47, 0x74, 0x3f, 0x48, 0x30, 0x3f, 0x48, 0x31,
    0x3f, 0x48, 0x32, 0x3f, 0x48, 0x61, 0x3f, 0x48, 0x63, 0x3f, 0x48, 0x65,
    0x3f, 0x48, 0x69, 0x3f, 0x48, 0x6f, 0x3f, 0x48, 0x73, 0x3f, 0x48, 0x74};
const uint8_t HuffDecoderCommon::table19_25_emit_[120] = {
    0x3f, 0x49, 0x30, 0x3f, 0x49, 0x31, 0x3f, 0x49, 0x32, 0x3f, 0x49, 0x61,
    0x3f, 0x49, 0x63, 0x3f, 0x49, 0x65, 0x3f, 0x49, 0x69, 0x3f, 0x49, 0x6f,
    0x3f, 0x49, 0x73, 0x3f, 0x49, 0x74, 0x3f, 0x4a, 0x30, 0x3f, 0x4a, 0x31,
    0x3f, 0x4a, 0x32, 0x3f, 0x4a, 0x61, 0x3f, 0x4a, 0x63, 0x3f, 0x4a, 0x65,
    0x3f, 0x4a, 0x69, 0x3f, 0x4a, 0x6f, 0x3f, 0x4a, 0x73, 0x3f, 0x4a, 0x74,
    0x3f, 0x4b, 0x30, 0x3f, 0x4b, 0x31, 0x3f, 0x4b, 0x32, 0x3f, 0x4b, 0x61,
    0x3f, 0x4b, 0x63, 0x3f, 0x4b, 0x65, 0x3f, 0x4b, 0x69, 0x3f, 0x4b, 0x6f,
    0x3f, 0x4b, 0x73, 0x3f, 0x4b, 0x74, 0x3f, 0x4c, 0x30, 0x3f, 0x4c, 0x31,
    0x3f, 0x4c, 0x32, 0x3f, 0x4c, 0x61, 0x3f, 0x4c, 0x63, 0x3f, 0x4c, 0x65,
    0x3f, 0x4c, 0x69, 0x3f, 0x4c, 0x6f, 0x3f, 0x4c, 0x73, 0x3f, 0x4c, 0x74};
const uint8_t HuffDecoderCommon::table19_26_emit_[120] = {
    0x3f, 0x4d, 0x30, 0x3f, 0x4d, 0x31, 0x3f, 0x4d, 0x32, 0x3f, 0x4d, 0x61,
    0x3f, 0x4d, 0x63, 0x3f, 0x4d, 0x65, 0x3f, 0x4d, 0x69, 0x3f, 0x4d, 0x6f,
    0x3f, 0x4d, 0x73, 0x3f, 0x4d, 0x74, 0x3f, 0x4e, 0x30, 0x3f, 0x4e, 0x31,
    0x3f, 0x4e, 0x32, 0x3f, 0x4e, 0x61, 0x3f, 0x4e, 0x63, 0x3f, 0x4e, 0x65,
    0x3f, 0x4e, 0x69, 0x3f, 0x4e, 0x6f, 0x3f, 0x4e, 0x73, 0x3f, 0x4e, 0x74,
    0x3f, 0x4f, 0x30, 0x3f, 0x4f, 0x31, 0x3f, 0x4f, 0x32, 0x3f, 0x4f, 0x61,
    0x3f, 0x4f, 0x63, 0x3f, 0x4f, 0x65, 0x3f, 0x4f, 0x69, 0x3f, 0x4f, 0x6f,
    0x3f, 0x4f, 0x73, 0x3f, 0x4f, 0x74, 0x3f, 0x50, 0x30, 0x3f, 0x50, 0x31,
    0x3f, 0x50, 0x32, 0x3f, 0x50, 0x61, 0x3f, 0x50, 0x63, 0x3f, 0x50, 0x65,
    0x3f, 0x50, 0x69, 0x3f, 0x50, 0x6f, 0x3f, 0x50, 0x73, 0x3f, 0x50, 0x74};
const uint8_t HuffDecoderCommon::table19_27_emit_[120] = {
    0x3f, 0x51, 0x30, 0x3f, 0x51, 0x31, 0x3f, 0x51, 0x32, 0x3f, 0x51, 0x61,
    0x3f, 0x51, 0x63, 0x3f, 0x51, 0x65, 0x3f, 0x51, 0x69, 0x3f, 0x51, 0x6f,
    0x3f, 0x51, 0x73, 0x3f, 0x51, 0x74, 0x3f, 0x52, 0x30, 0x3f, 0x52, 0x31,
    0x3f, 0x52, 0x32, 0x3f, 0x52, 0x61, 0x3f, 0x52, 0x63, 0x3f, 0x52, 0x65,
    0x3f, 0x52, 0x69, 0x3f, 0x52, 0x6f, 0x3f, 0x52, 0x73, 0x3f, 0x52, 0x74,
    0x3f, 0x53, 0x30, 0x3f, 0x53, 0x31, 0x3f, 0x53, 0x32, 0x3f, 0x53, 0x61,
    0x3f, 0x53, 0x63, 0x3f, 0x53, 0x65, 0x3f, 0x53, 0x69, 0x3f, 0x53, 0x6f,
    0x3f, 0x53, 0x73, 0x3f, 0x53, 0x74, 0x3f, 0x54, 0x30, 0x3f, 0x54, 0x31,
    0x3f, 0x54, 0x32, 0x3f, 0x54, 0x61, 0x3f, 0x54, 0x63, 0x3f, 0x54, 0x65,
    0x3f, 0x54, 0x69, 0x3f, 0x54, 0x6f, 0x3f, 0x54, 0x73, 0x3f, 0x54, 0x74};
const uint8_t HuffDecoderCommon::table19_28_emit_[120] = {
    0x3f, 0x55, 0x30, 0x3f, 0x55, 0x31, 0x3f, 0x55, 0x32, 0x3f, 0x55, 0x61,
    0x3f, 0x55, 0x63, 0x3f, 0x55, 0x65, 0x3f, 0x55, 0x69, 0x3f, 0x55, 0x6f,
    0x3f, 0x55, 0x73, 0x3f, 0x55, 0x74, 0x3f, 0x56, 0x30, 0x3f, 0x56, 0x31,
    0x3f, 0x56, 0x32, 0x3f, 0x56, 0x61, 0x3f, 0x56, 0x63, 0x3f, 0x56, 0x65,
    0x3f, 0x56, 0x69, 0x3f, 0x56, 0x6f, 0x3f, 0x56, 0x73, 0x3f, 0x56, 0x74,
    0x3f, 0x57, 0x30, 0x3f, 0x57, 0x31, 0x3f, 0x57, 0x32, 0x3f, 0x57, 0x61,
    0x3f, 0x57, 0x63, 0x3f, 0x57, 0x65, 0x3f, 0x57, 0x69, 0x3f, 0x57, 0x6f,
    0x3f, 0x57, 0x73, 0x3f, 0x57, 0x74, 0x3f, 0x59, 0x30, 0x3f, 0x59, 0x31,
    0x3f, 0x59, 0x32, 0x3f, 0x59, 0x61, 0x3f, 0x59, 0x63, 0x3f, 0x59, 0x65,
    0x3f, 0x59, 0x69, 0x3f, 0x59, 0x6f, 0x3f, 0x59, 0x73, 0x3f, 0x59, 0x74};
const uint8_t HuffDecoderCommon::table19_29_emit_[120] = {
    0x3f, 0x6a, 0x30, 0x3f, 0x6a, 0x31, 0x3f, 0x6a, 0x32, 0x3f, 0x6a, 0x61,
    0x3f, 0x6a, 0x63, 0x3f, 0x6a, 0x65, 0x3f, 0x6a, 0x69, 0x3f, 0x6a, 0x6f,
    0x3f, 0x6a, 0x73, 0x3f, 0x6a, 0x74, 0x3f, 0x6b, 0x30, 0x3f, 0x6b, 0x31,
    0x3f, 0x6b, 0x32, 0x3f, 0x6b, 0x61, 0x3f, 0x6b, 0x63, 0x3f, 0x6b, 0x65,
    0x3f, 0x6b, 0x69, 0x3f, 0x6b, 0x6f, 0x3f, 0x6b, 0x73, 0x3f, 0x6b, 0x74,
    0x3f, 0x71, 0x30, 0x3f, 0x71, 0x31, 0x3f, 0x71, 0x32, 0x3f, 0x71, 0x61,
    0x3f, 0x71, 0x63, 0x3f, 0x71, 0x65, 0x3f, 0x71, 0x69, 0x3f, 0x71, 0x6f,
    0x3f, 0x71, 0x73, 0x3f, 0x71, 0x74, 0x3f, 0x76, 0x30, 0x3f, 0x76, 0x31,
    0x3f, 0x76, 0x32, 0x3f, 0x76, 0x61, 0x3f, 0x76, 0x63, 0x3f, 0x76, 0x65,
    0x3f, 0x76, 0x69, 0x3f, 0x76, 0x6f, 0x3f, 0x76, 0x73, 0x3f, 0x76, 0x74};
const uint8_t HuffDecoderCommon::table19_30_emit_[120] = {
    0x3f, 0x77, 0x30, 0x3f, 0x77, 0x31, 0x3f, 0x77, 0x32, 0x3f, 0x77, 0x61,
    0x3f, 0x77, 0x63, 0x3f, 0x77, 0x65, 0x3f, 0x77, 0x69, 0x3f, 0x77, 0x6f,
    0x3f, 0x77, 0x73, 0x3f, 0x77, 0x74, 0x3f, 0x78, 0x30, 0x3f, 0x78, 0x31,
    0x3f, 0x78, 0x32, 0x3f, 0x78, 0x61, 0x3f, 0x78, 0x63, 0x3f, 0x78, 0x65,
    0x3f, 0x78, 0x69, 0x3f, 0x78, 0x6f, 0x3f, 0x78, 0x73, 0x3f, 0x78, 0x74,
    0x3f, 0x79, 0x30, 0x3f, 0x79, 0x31, 0x3f, 0x79, 0x32, 0x3f, 0x79, 0x61,
    0x3f, 0x79, 0x63, 0x3f, 0x79, 0x65, 0x3f, 0x79, 0x69, 0x3f, 0x79, 0x6f,
    0x3f, 0x79, 0x73, 0x3f, 0x79, 0x74, 0x3f, 0x7a, 0x30, 0x3f, 0x7a, 0x31,
    0x3f, 0x7a, 0x32, 0x3f, 0x7a, 0x61, 0x3f, 0x7a, 0x63, 0x3f, 0x7a, 0x65,
    0x3f, 0x7a, 0x69, 0x3f, 0x7a, 0x6f, 0x3f, 0x7a, 0x73, 0x3f, 0x7a, 0x74};
const uint8_t HuffDecoderCommon::table19_31_emit_[31] = {
    0x3f, 0x26, 0x3f, 0x2a, 0x3f, 0x2c, 0x3f, 0x3b, 0x3f, 0x58, 0x3f,
    0x5a, 0x3f, 0x21, 0x3f, 0x22, 0x3f, 0x28, 0x3f, 0x29, 0x3f, 0x3f,
    0x27, 0x3f, 0x2b, 0x3f, 0x7c, 0x3f, 0x23, 0x3f, 0x3e};
const uint16_t HuffDecoderCommon::table19_31_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0062, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000,
    0x00aa, 0x0000, 0x00ba, 0x0000, 0x00ca, 0x00da, 0x00ea, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table19_32_emit_[216] = {
    0x27, 0x30, 0x30, 0x27, 0x30, 0x31, 0x27, 0x30, 0x32, 0x27, 0x30, 0x61,
    0x27, 0x30, 0x63, 0x27, 0x30, 0x65, 0x27, 0x30, 0x69, 0x27, 0x30, 0x6f,
    0x27, 0x30, 0x73, 0x27, 0x30, 0x74, 0x27, 0x30, 0x20, 0x27, 0x30, 0x25,
    0x27, 0x30, 0x2d, 0x27, 0x30, 0x2e, 0x27, 0x30, 0x2f, 0x27, 0x30, 0x33,
    0x27, 0x30, 0x34, 0x27, 0x30, 0x35, 0x27, 0x30, 0x36, 0x27, 0x30, 0x37,
    0x27, 0x30, 0x38, 0x27, 0x30, 0x39, 0x27, 0x30, 0x3d, 0x27, 0x30, 0x41,
    0x27, 0x30, 0x5f, 0x27, 0x30, 0x62, 0x27, 0x30, 0x64, 0x27, 0x30, 0x66,
    0x27, 0x30, 0x67, 0x27, 0x30, 0x68, 0x27, 0x30, 0x6c, 0x27, 0x30, 0x6d,
    0x27, 0x30, 0x6e, 0x27, 0x30, 0x70, 0x27, 0x30, 0x72, 0x27, 0x30, 0x75,
    0x27, 0x31, 0x30, 0x27, 0x31, 0x31, 0x27, 0x31, 0x32, 0x27, 0x31, 0x61,
    0x27, 0x31, 0x63, 0x27, 0x31, 0x65, 0x27, 0x31, 0x69, 0x27, 0x31, 0x6f,
    0x27, 0x31, 0x73, 0x27, 0x31, 0x74, 0x27, 0x31, 0x20, 0x27, 0x31, 0x25,
    0x27, 0x31, 0x2d, 0x27, 0x31, 0x2e, 0x27, 0x31, 0x2f, 0x27, 0x31, 0x33,
    0x27, 0x31, 0x34, 0x27, 0x31, 0x35, 0x27, 0x31, 0x36, 0x27, 0x31, 0x37,
    0x27, 0x31, 0x38, 0x27, 0x31, 0x39, 0x27, 0x31, 0x3d, 0x27, 0x31, 0x41,
    0x27, 0x31, 0x5f, 0x27, 0x31, 0x62, 0x27, 0x31, 0x64, 0x27, 0x31, 0x66,
    0x27, 0x31, 0x67, 0x27, 0x31, 0x68, 0x27, 0x31, 0x6c, 0x27, 0x31, 0x6d,
    0x27, 0x31, 0x6e, 0x27, 0x31, 0x70, 0x27, 0x31, 0x72, 0x27, 0x31, 0x75};
const uint8_t HuffDecoderCommon::table19_33_emit_[216] = {
    0x27, 0x32, 0x30, 0x27, 0x32, 0x31, 0x27, 0x32, 0x32, 0x27, 0x32, 0x61,
    0x27, 0x32, 0x63, 0x27, 0x32, 0x65, 0x27, 0x32, 0x69, 0x27, 0x32, 0x6f,
    0x27, 0x32, 0x73, 0x27, 0x32, 0x74, 0x27, 0x32, 0x20, 0x27, 0x32, 0x25,
    0x27, 0x32, 0x2d, 0x27, 0x32, 0x2e, 0x27, 0x32, 0x2f, 0x27, 0x32, 0x33,
    0x27, 0x32, 0x34, 0x27, 0x32, 0x35, 0x27, 0x32, 0x36, 0x27, 0x32, 0x37,
    0x27, 0x32, 0x38, 0x27, 0x32, 0x39, 0x27, 0x32, 0x3d, 0x27, 0x32, 0x41,
    0x27, 0x32, 0x5f, 0x27, 0x32, 0x62, 0x27, 0x32, 0x64, 0x27, 0x32, 0x66,
    0x27, 0x32, 0x67, 0x27, 0x32, 0x68, 0x27, 0x32, 0x6c, 0x27, 0x32, 0x6d,
    0x27, 0x32, 0x6e, 0x27, 0x32, 0x70, 0x27, 0x32, 0x72, 0x27, 0x32, 0x75,
    0x27, 0x61, 0x30, 0x27, 0x61, 0x31, 0x27, 0x61, 0x32, 0x27, 0x61, 0x61,
    0x27, 0x61, 0x63, 0x27, 0x61, 0x65, 0x27, 0x61, 0x69, 0x27, 0x61, 0x6f,
    0x27, 0x61, 0x73, 0x27, 0x61, 0x74, 0x27, 0x61, 0x20, 0x27, 0x61, 0x25,
    0x27, 0x61, 0x2d, 0x27, 0x61, 0x2e, 0x27, 0x61, 0x2f, 0x27, 0x61, 0x33,
    0x27, 0x61, 0x34, 0x27, 0x61, 0x35, 0x27, 0x61, 0x36, 0x27, 0x61, 0x37,
    0x27, 0x61, 0x38, 0x27, 0x61, 0x39, 0x27, 0x61, 0x3d, 0x27, 0x61, 0x41,
    0x27, 0x61, 0x5f, 0x27, 0x61, 0x62, 0x27, 0x61, 0x64, 0x27, 0x61, 0x66,
    0x27, 0x61, 0x67, 0x27, 0x61, 0x68, 0x27, 0x61, 0x6c, 0x27, 0x61, 0x6d,
    0x27, 0x61, 0x6e, 0x27, 0x61, 0x70, 0x27, 0x61, 0x72, 0x27, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table19_34_emit_[216] = {
    0x27, 0x63, 0x30, 0x27, 0x63, 0x31, 0x27, 0x63, 0x32, 0x27, 0x63, 0x61,
    0x27, 0x63, 0x63, 0x27, 0x63, 0x65, 0x27, 0x63, 0x69, 0x27, 0x63, 0x6f,
    0x27, 0x63, 0x73, 0x27, 0x63, 0x74, 0x27, 0x63, 0x20, 0x27, 0x63, 0x25,
    0x27, 0x63, 0x2d, 0x27, 0x63, 0x2e, 0x27, 0x63, 0x2f, 0x27, 0x63, 0x33,
    0x27, 0x63, 0x34, 0x27, 0x63, 0x35, 0x27, 0x63, 0x36, 0x27, 0x63, 0x37,
    0x27, 0x63, 0x38, 0x27, 0x63, 0x39, 0x27, 0x63, 0x3d, 0x27, 0x63, 0x41,
    0x27, 0x63, 0x5f, 0x27, 0x63, 0x62, 0x27, 0x63, 0x64, 0x27, 0x63, 0x66,
    0x27, 0x63, 0x67, 0x27, 0x63, 0x68, 0x27, 0x63, 0x6c, 0x27, 0x63, 0x6d,
    0x27, 0x63, 0x6e, 0x27, 0x63, 0x70, 0x27, 0x63, 0x72, 0x27, 0x63, 0x75,
    0x27, 0x65, 0x30, 0x27, 0x65, 0x31, 0x27, 0x65, 0x32, 0x27, 0x65, 0x61,
    0x27, 0x65, 0x63, 0x27, 0x65, 0x65, 0x27, 0x65, 0x69, 0x27, 0x65, 0x6f,
    0x27, 0x65, 0x73, 0x27, 0x65, 0x74, 0x27, 0x65, 0x20, 0x27, 0x65, 0x25,
    0x27, 0x65, 0x2d, 0x27, 0x65, 0x2e, 0x27, 0x65, 0x2f, 0x27, 0x65, 0x33,
    0x27, 0x65, 0x34, 0x27, 0x65, 0x35, 0x27, 0x65, 0x36, 0x27, 0x65, 0x37,
    0x27, 0x65, 0x38, 0x27, 0x65, 0x39, 0x27, 0x65, 0x3d, 0x27, 0x65, 0x41,
    0x27, 0x65, 0x5f, 0x27, 0x65, 0x62, 0x27, 0x65, 0x64, 0x27, 0x65, 0x66,
    0x27, 0x65, 0x67, 0x27, 0x65, 0x68, 0x27, 0x65, 0x6c, 0x27, 0x65, 0x6d,
    0x27, 0x65, 0x6e, 0x27, 0x65, 0x70, 0x27, 0x65, 0x72, 0x27, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table19_35_emit_[216] = {
    0x27, 0x69, 0x30, 0x27, 0x69, 0x31, 0x27, 0x69, 0x32, 0x27, 0x69, 0x61,
    0x27, 0x69, 0x63, 0x27, 0x69, 0x65, 0x27, 0x69, 0x69, 0x27, 0x69, 0x6f,
    0x27, 0x69, 0x73, 0x27, 0x69, 0x74, 0x27, 0x69, 0x20, 0x27, 0x69, 0x25,
    0x27, 0x69, 0x2d, 0x27, 0x69, 0x2e, 0x27, 0x69, 0x2f, 0x27, 0x69, 0x33,
    0x27, 0x69, 0x34, 0x27, 0x69, 0x35, 0x27, 0x69, 0x36, 0x27, 0x69, 0x37,
    0x27, 0x69, 0x38, 0x27, 0x69, 0x39, 0x27, 0x69, 0x3d, 0x27, 0x69, 0x41,
    0x27, 0x69, 0x5f, 0x27, 0x69, 0x62, 0x27, 0x69, 0x64, 0x27, 0x69, 0x66,
    0x27, 0x69, 0x67, 0x27, 0x69, 0x68, 0x27, 0x69, 0x6c, 0x27, 0x69, 0x6d,
    0x27, 0x69, 0x6e, 0x27, 0x69, 0x70, 0x27, 0x69, 0x72, 0x27, 0x69, 0x75,
    0x27, 0x6f, 0x30, 0x27, 0x6f, 0x31, 0x27, 0x6f, 0x32, 0x27, 0x6f, 0x61,
    0x27, 0x6f, 0x63, 0x27, 0x6f, 0x65, 0x27, 0x6f, 0x69, 0x27, 0x6f, 0x6f,
    0x27, 0x6f, 0x73, 0x27, 0x6f, 0x74, 0x27, 0x6f, 0x20, 0x27, 0x6f, 0x25,
    0x27, 0x6f, 0x2d, 0x27, 0x6f, 0x2e, 0x27, 0x6f, 0x2f, 0x27, 0x6f, 0x33,
    0x27, 0x6f, 0x34, 0x27, 0x6f, 0x35, 0x27, 0x6f, 0x36, 0x27, 0x6f, 0x37,
    0x27, 0x6f, 0x38, 0x27, 0x6f, 0x39, 0x27, 0x6f, 0x3d, 0x27, 0x6f, 0x41,
    0x27, 0x6f, 0x5f, 0x27, 0x6f, 0x62, 0x27, 0x6f, 0x64, 0x27, 0x6f, 0x66,
    0x27, 0x6f, 0x67, 0x27, 0x6f, 0x68, 0x27, 0x6f, 0x6c, 0x27, 0x6f, 0x6d,
    0x27, 0x6f, 0x6e, 0x27, 0x6f, 0x70, 0x27, 0x6f, 0x72, 0x27, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table19_36_emit_[216] = {
    0x27, 0x73, 0x30, 0x27, 0x73, 0x31, 0x27, 0x73, 0x32, 0x27, 0x73, 0x61,
    0x27, 0x73, 0x63, 0x27, 0x73, 0x65, 0x27, 0x73, 0x69, 0x27, 0x73, 0x6f,
    0x27, 0x73, 0x73, 0x27, 0x73, 0x74, 0x27, 0x73, 0x20, 0x27, 0x73, 0x25,
    0x27, 0x73, 0x2d, 0x27, 0x73, 0x2e, 0x27, 0x73, 0x2f, 0x27, 0x73, 0x33,
    0x27, 0x73, 0x34, 0x27, 0x73, 0x35, 0x27, 0x73, 0x36, 0x27, 0x73, 0x37,
    0x27, 0x73, 0x38, 0x27, 0x73, 0x39, 0x27, 0x73, 0x3d, 0x27, 0x73, 0x41,
    0x27, 0x73, 0x5f, 0x27, 0x73, 0x62, 0x27, 0x73, 0x64, 0x27, 0x73, 0x66,
    0x27, 0x73, 0x67, 0x27, 0x73, 0x68, 0x27, 0x73, 0x6c, 0x27, 0x73, 0x6d,
    0x27, 0x73, 0x6e, 0x27, 0x73, 0x70, 0x27, 0x73, 0x72, 0x27, 0x73, 0x75,
    0x27, 0x74, 0x30, 0x27, 0x74, 0x31, 0x27, 0x74, 0x32, 0x27, 0x74, 0x61,
    0x27, 0x74, 0x63, 0x27, 0x74, 0x65, 0x27, 0x74, 0x69, 0x27, 0x74, 0x6f,
    0x27, 0x74, 0x73, 0x27, 0x74, 0x74, 0x27, 0x74, 0x20, 0x27, 0x74, 0x25,
    0x27, 0x74, 0x2d, 0x27, 0x74, 0x2e, 0x27, 0x74, 0x2f, 0x27, 0x74, 0x33,
    0x27, 0x74, 0x34, 0x27, 0x74, 0x35, 0x27, 0x74, 0x36, 0x27, 0x74, 0x37,
    0x27, 0x74, 0x38, 0x27, 0x74, 0x39, 0x27, 0x74, 0x3d, 0x27, 0x74, 0x41,
    0x27, 0x74, 0x5f, 0x27, 0x74, 0x62, 0x27, 0x74, 0x64, 0x27, 0x74, 0x66,
    0x27, 0x74, 0x67, 0x27, 0x74, 0x68, 0x27, 0x74, 0x6c, 0x27, 0x74, 0x6d,
    0x27, 0x74, 0x6e, 0x27, 0x74, 0x70, 0x27, 0x74, 0x72, 0x27, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table19_37_emit_[120] = {
    0x27, 0x20, 0x30, 0x27, 0x20, 0x31, 0x27, 0x20, 0x32, 0x27, 0x20, 0x61,
    0x27, 0x20, 0x63, 0x27, 0x20, 0x65, 0x27, 0x20, 0x69, 0x27, 0x20, 0x6f,
    0x27, 0x20, 0x73, 0x27, 0x20, 0x74, 0x27, 0x25, 0x30, 0x27, 0x25, 0x31,
    0x27, 0x25, 0x32, 0x27, 0x25, 0x61, 0x27, 0x25, 0x63, 0x27, 0x25, 0x65,
    0x27, 0x25, 0x69, 0x27, 0x25, 0x6f, 0x27, 0x25, 0x73, 0x27, 0x25, 0x74,
    0x27, 0x2d, 0x30, 0x27, 0x2d, 0x31, 0x27, 0x2d, 0x32, 0x27, 0x2d, 0x61,
    0x27, 0x2d, 0x63, 0x27, 0x2d, 0x65, 0x27, 0x2d, 0x69, 0x27, 0x2d, 0x6f,
    0x27, 0x2d, 0x73, 0x27, 0x2d, 0x74, 0x27, 0x2e, 0x30, 0x27, 0x2e, 0x31,
    0x27, 0x2e, 0x32, 0x27, 0x2e, 0x61, 0x27, 0x2e, 0x63, 0x27, 0x2e, 0x65,
    0x27, 0x2e, 0x69, 0x27, 0x2e, 0x6f, 0x27, 0x2e, 0x73, 0x27, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table19_38_emit_[120] = {
    0x27, 0x2f, 0x30, 0x27, 0x2f, 0x31, 0x27, 0x2f, 0x32, 0x27, 0x2f, 0x61,
    0x27, 0x2f, 0x63, 0x27, 0x2f, 0x65, 0x27, 0x2f, 0x69, 0x27, 0x2f, 0x6f,
    0x27, 0x2f, 0x73, 0x27, 0x2f, 0x74, 0x27, 0x33, 0x30, 0x27, 0x33, 0x31,
    0x27, 0x33, 0x32, 0x27, 0x33, 0x61, 0x27, 0x33, 0x63, 0x27, 0x33, 0x65,
    0x27, 0x33, 0x69, 0x27, 0x33, 0x6f, 0x27, 0x33, 0x73, 0x27, 0x33, 0x74,
    0x27, 0x34, 0x30, 0x27, 0x34, 0x31, 0x27, 0x34, 0x32, 0x27, 0x34, 0x61,
    0x27, 0x34, 0x63, 0x27, 0x34, 0x65, 0x27, 0x34, 0x69, 0x27, 0x34, 0x6f,
    0x27, 0x34, 0x73, 0x27, 0x34, 0x74, 0x27, 0x35, 0x30, 0x27, 0x35, 0x31,
    0x27, 0x35, 0x32, 0x27, 0x35, 0x61, 0x27, 0x35, 0x63, 0x27, 0x35, 0x65,
    0x27, 0x35, 0x69, 0x27, 0x35, 0x6f, 0x27, 0x35, 0x73, 0x27, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table19_39_emit_[120] = {
    0x27, 0x36, 0x30, 0x27, 0x36, 0x31, 0x27, 0x36, 0x32, 0x27, 0x36, 0x61,
    0x27, 0x36, 0x63, 0x27, 0x36, 0x65, 0x27, 0x36, 0x69, 0x27, 0x36, 0x6f,
    0x27, 0x36, 0x73, 0x27, 0x36, 0x74, 0x27, 0x37, 0x30, 0x27, 0x37, 0x31,
    0x27, 0x37, 0x32, 0x27, 0x37, 0x61, 0x27, 0x37, 0x63, 0x27, 0x37, 0x65,
    0x27, 0x37, 0x69, 0x27, 0x37, 0x6f, 0x27, 0x37, 0x73, 0x27, 0x37, 0x74,
    0x27, 0x38, 0x30, 0x27, 0x38, 0x31, 0x27, 0x38, 0x32, 0x27, 0x38, 0x61,
    0x27, 0x38, 0x63, 0x27, 0x38, 0x65, 0x27, 0x38, 0x69, 0x27, 0x38, 0x6f,
    0x27, 0x38, 0x73, 0x27, 0x38, 0x74, 0x27, 0x39, 0x30, 0x27, 0x39, 0x31,
    0x27, 0x39, 0x32, 0x27, 0x39, 0x61, 0x27, 0x39, 0x63, 0x27, 0x39, 0x65,
    0x27, 0x39, 0x69, 0x27, 0x39, 0x6f, 0x27, 0x39, 0x73, 0x27, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table19_40_emit_[120] = {
    0x27, 0x3d, 0x30, 0x27, 0x3d, 0x31, 0x27, 0x3d, 0x32, 0x27, 0x3d, 0x61,
    0x27, 0x3d, 0x63, 0x27, 0x3d, 0x65, 0x27, 0x3d, 0x69, 0x27, 0x3d, 0x6f,
    0x27, 0x3d, 0x73, 0x27, 0x3d, 0x74, 0x27, 0x41, 0x30, 0x27, 0x41, 0x31,
    0x27, 0x41, 0x32, 0x27, 0x41, 0x61, 0x27, 0x41, 0x63, 0x27, 0x41, 0x65,
    0x27, 0x41, 0x69, 0x27, 0x41, 0x6f, 0x27, 0x41, 0x73, 0x27, 0x41, 0x74,
    0x27, 0x5f, 0x30, 0x27, 0x5f, 0x31, 0x27, 0x5f, 0x32, 0x27, 0x5f, 0x61,
    0x27, 0x5f, 0x63, 0x27, 0x5f, 0x65, 0x27, 0x5f, 0x69, 0x27, 0x5f, 0x6f,
    0x27, 0x5f, 0x73, 0x27, 0x5f, 0x74, 0x27, 0x62, 0x30, 0x27, 0x62, 0x31,
    0x27, 0x62, 0x32, 0x27, 0x62, 0x61, 0x27, 0x62, 0x63, 0x27, 0x62, 0x65,
    0x27, 0x62, 0x69, 0x27, 0x62, 0x6f, 0x27, 0x62, 0x73, 0x27, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table19_41_emit_[120] = {
    0x27, 0x64, 0x30, 0x27, 0x64, 0x31, 0x27, 0x64, 0x32, 0x27, 0x64, 0x61,
    0x27, 0x64, 0x63, 0x27, 0x64, 0x65, 0x27, 0x64, 0x69, 0x27, 0x64, 0x6f,
    0x27, 0x64, 0x73, 0x27, 0x64, 0x74, 0x27, 0x66, 0x30, 0x27, 0x66, 0x31,
    0x27, 0x66, 0x32, 0x27, 0x66, 0x61, 0x27, 0x66, 0x63, 0x27, 0x66, 0x65,
    0x27, 0x66, 0x69, 0x27, 0x66, 0x6f, 0x27, 0x66, 0x73, 0x27, 0x66, 0x74,
    0x27, 0x67, 0x30, 0x27, 0x67, 0x31, 0x27, 0x67, 0x32, 0x27, 0x67, 0x61,
    0x27, 0x67, 0x63, 0x27, 0x67, 0x65, 0x27, 0x67, 0x69, 0x27, 0x67, 0x6f,
    0x27, 0x67, 0x73, 0x27, 0x67, 0x74, 0x27, 0x68, 0x30, 0x27, 0x68, 0x31,
    0x27, 0x68, 0x32, 0x27, 0x68, 0x61, 0x27, 0x68, 0x63, 0x27, 0x68, 0x65,
    0x27, 0x68, 0x69, 0x27, 0x68, 0x6f, 0x27, 0x68, 0x73, 0x27, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table19_42_emit_[120] = {
    0x27, 0x6c, 0x30, 0x27, 0x6c, 0x31, 0x27, 0x6c, 0x32, 0x27, 0x6c, 0x61,
    0x27, 0x6c, 0x63, 0x27, 0x6c, 0x65, 0x27, 0x6c, 0x69, 0x27, 0x6c, 0x6f,
    0x27, 0x6c, 0x73, 0x27, 0x6c, 0x74, 0x27, 0x6d, 0x30, 0x27, 0x6d, 0x31,
    0x27, 0x6d, 0x32, 0x27, 0x6d, 0x61, 0x27, 0x6d, 0x63, 0x27, 0x6d, 0x65,
    0x27, 0x6d, 0x69, 0x27, 0x6d, 0x6f, 0x27, 0x6d, 0x73, 0x27, 0x6d, 0x74,
    0x27, 0x6e, 0x30, 0x27, 0x6e, 0x31, 0x27, 0x6e, 0x32, 0x27, 0x6e, 0x61,
    0x27, 0x6e, 0x63, 0x27, 0x6e, 0x65, 0x27, 0x6e, 0x69, 0x27, 0x6e, 0x6f,
    0x27, 0x6e, 0x73, 0x27, 0x6e, 0x74, 0x27, 0x70, 0x30, 0x27, 0x70, 0x31,
    0x27, 0x70, 0x32, 0x27, 0x70, 0x61, 0x27, 0x70, 0x63, 0x27, 0x70, 0x65,
    0x27, 0x70, 0x69, 0x27, 0x70, 0x6f, 0x27, 0x70, 0x73, 0x27, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table19_43_emit_[68] = {
    0x27, 0x72, 0x30, 0x27, 0x72, 0x31, 0x27, 0x72, 0x32, 0x27, 0x72, 0x61,
    0x27, 0x72, 0x63, 0x27, 0x72, 0x65, 0x27, 0x72, 0x69, 0x27, 0x72, 0x6f,
    0x27, 0x72, 0x73, 0x27, 0x72, 0x74, 0x27, 0x75, 0x30, 0x27, 0x75, 0x31,
    0x27, 0x75, 0x32, 0x27, 0x75, 0x61, 0x27, 0x75, 0x63, 0x27, 0x75, 0x65,
    0x27, 0x75, 0x69, 0x27, 0x75, 0x6f, 0x27, 0x75, 0x73, 0x27, 0x75, 0x74,
    0x27, 0x3a, 0x27, 0x42, 0x27, 0x43, 0x27, 0x44};
const uint16_t HuffDecoderCommon::table19_43_ops_[128] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9, 0x00c1,
    0x00d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x00f1, 0x0109, 0x0121, 0x0139,
    0x0151, 0x0169, 0x0181, 0x0199, 0x01b1, 0x01c9, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x00f2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01e2, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f2, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0202, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0212};
const uint16_t HuffDecoderCommon::table19_44_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0072};
const uint8_t HuffDecoderCommon::table19_47_emit_[35] = {
    0x27, 0x77, 0x27, 0x78, 0x27, 0x79, 0x27, 0x7a, 0x27, 0x26, 0x27, 0x2a,
    0x27, 0x2c, 0x27, 0x3b, 0x27, 0x58, 0x27, 0x5a, 0x27, 0x21, 0x27, 0x22,
    0x27, 0x28, 0x27, 0x29, 0x27, 0x3f, 0x27, 0x27, 0x2b, 0x27, 0x7c};
const uint16_t HuffDecoderCommon::table19_47_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x00a2, 0x0000, 0x00b2, 0x0000,
    0x00c2, 0x0000, 0x00d2, 0x0000, 0x00e2, 0x00f2, 0x00fa, 0x010a, 0x0000,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table19_48_emit_[216] = {
    0x2b, 0x30, 0x30, 0x2b, 0x30, 0x31, 0x2b, 0x30, 0x32, 0x2b, 0x30, 0x61,
    0x2b, 0x30, 0x63, 0x2b, 0x30, 0x65, 0x2b, 0x30, 0x69, 0x2b, 0x30, 0x6f,
    0x2b, 0x30, 0x73, 0x2b, 0x30, 0x74, 0x2b, 0x30, 0x20, 0x2b, 0x30, 0x25,
    0x2b, 0x30, 0x2d, 0x2b, 0x30, 0x2e, 0x2b, 0x30, 0x2f, 0x2b, 0x30, 0x33,
    0x2b, 0x30, 0x34, 0x2b, 0x30, 0x35, 0x2b, 0x30, 0x36, 0x2b, 0x30, 0x37,
    0x2b, 0x30, 0x38, 0x2b, 0x30, 0x39, 0x2b, 0x30, 0x3d, 0x2b, 0x30, 0x41,
    0x2b, 0x30, 0x5f, 0x2b, 0x30, 0x62, 0x2b, 0x30, 0x64, 0x2b, 0x30, 0x66,
    0x2b, 0x30, 0x67, 0x2b, 0x30, 0x68, 0x2b, 0x30, 0x6c, 0x2b, 0x30, 0x6d,
    0x2b, 0x30, 0x6e, 0x2b, 0x30, 0x70, 0x2b, 0x30, 0x72, 0x2b, 0x30, 0x75,
    0x2b, 0x31, 0x30, 0x2b, 0x31, 0x31, 0x2b, 0x31, 0x32, 0x2b, 0x31, 0x61,
    0x2b, 0x31, 0x63, 0x2b, 0x31, 0x65, 0x2b, 0x31, 0x69, 0x2b, 0x31, 0x6f,
    0x2b, 0x31, 0x73, 0x2b, 0x31, 0x74, 0x2b, 0x31, 0x20, 0x2b, 0x31, 0x25,
    0x2b, 0x31, 0x2d, 0x2b, 0x31, 0x2e, 0x2b, 0x31, 0x2f, 0x2b, 0x31, 0x33,
    0x2b, 0x31, 0x34, 0x2b, 0x31, 0x35, 0x2b, 0x31, 0x36, 0x2b, 0x31, 0x37,
    0x2b, 0x31, 0x38, 0x2b, 0x31, 0x39, 0x2b, 0x31, 0x3d, 0x2b, 0x31, 0x41,
    0x2b, 0x31, 0x5f, 0x2b, 0x31, 0x62, 0x2b, 0x31, 0x64, 0x2b, 0x31, 0x66,
    0x2b, 0x31, 0x67, 0x2b, 0x31, 0x68, 0x2b, 0x31, 0x6c, 0x2b, 0x31, 0x6d,
    0x2b, 0x31, 0x6e, 0x2b, 0x31, 0x70, 0x2b, 0x31, 0x72, 0x2b, 0x31, 0x75};
const uint8_t HuffDecoderCommon::table19_49_emit_[216] = {
    0x2b, 0x32, 0x30, 0x2b, 0x32, 0x31, 0x2b, 0x32, 0x32, 0x2b, 0x32, 0x61,
    0x2b, 0x32, 0x63, 0x2b, 0x32, 0x65, 0x2b, 0x32, 0x69, 0x2b, 0x32, 0x6f,
    0x2b, 0x32, 0x73, 0x2b, 0x32, 0x74, 0x2b, 0x32, 0x20, 0x2b, 0x32, 0x25,
    0x2b, 0x32, 0x2d, 0x2b, 0x32, 0x2e, 0x2b, 0x32, 0x2f, 0x2b, 0x32, 0x33,
    0x2b, 0x32, 0x34, 0x2b, 0x32, 0x35, 0x2b, 0x32, 0x36, 0x2b, 0x32, 0x37,
    0x2b, 0x32, 0x38, 0x2b, 0x32, 0x39, 0x2b, 0x32, 0x3d, 0x2b, 0x32, 0x41,
    0x2b, 0x32, 0x5f, 0x2b, 0x32, 0x62, 0x2b, 0x32, 0x64, 0x2b, 0x32, 0x66,
    0x2b, 0x32, 0x67, 0x2b, 0x32, 0x68, 0x2b, 0x32, 0x6c, 0x2b, 0x32, 0x6d,
    0x2b, 0x32, 0x6e, 0x2b, 0x32, 0x70, 0x2b, 0x32, 0x72, 0x2b, 0x32, 0x75,
    0x2b, 0x61, 0x30, 0x2b, 0x61, 0x31, 0x2b, 0x61, 0x32, 0x2b, 0x61, 0x61,
    0x2b, 0x61, 0x63, 0x2b, 0x61, 0x65, 0x2b, 0x61, 0x69, 0x2b, 0x61, 0x6f,
    0x2b, 0x61, 0x73, 0x2b, 0x61, 0x74, 0x2b, 0x61, 0x20, 0x2b, 0x61, 0x25,
    0x2b, 0x61, 0x2d, 0x2b, 0x61, 0x2e, 0x2b, 0x61, 0x2f, 0x2b, 0x61, 0x33,
    0x2b, 0x61, 0x34, 0x2b, 0x61, 0x35, 0x2b, 0x61, 0x36, 0x2b, 0x61, 0x37,
    0x2b, 0x61, 0x38, 0x2b, 0x61, 0x39, 0x2b, 0x61, 0x3d, 0x2b, 0x61, 0x41,
    0x2b, 0x61, 0x5f, 0x2b, 0x61, 0x62, 0x2b, 0x61, 0x64, 0x2b, 0x61, 0x66,
    0x2b, 0x61, 0x67, 0x2b, 0x61, 0x68, 0x2b, 0x61, 0x6c, 0x2b, 0x61, 0x6d,
    0x2b, 0x61, 0x6e, 0x2b, 0x61, 0x70, 0x2b, 0x61, 0x72, 0x2b, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table19_50_emit_[216] = {
    0x2b, 0x63, 0x30, 0x2b, 0x63, 0x31, 0x2b, 0x63, 0x32, 0x2b, 0x63, 0x61,
    0x2b, 0x63, 0x63, 0x2b, 0x63, 0x65, 0x2b, 0x63, 0x69, 0x2b, 0x63, 0x6f,
    0x2b, 0x63, 0x73, 0x2b, 0x63, 0x74, 0x2b, 0x63, 0x20, 0x2b, 0x63, 0x25,
    0x2b, 0x63, 0x2d, 0x2b, 0x63, 0x2e, 0x2b, 0x63, 0x2f, 0x2b, 0x63, 0x33,
    0x2b, 0x63, 0x34, 0x2b, 0x63, 0x35, 0x2b, 0x63, 0x36, 0x2b, 0x63, 0x37,
    0x2b, 0x63, 0x38, 0x2b, 0x63, 0x39, 0x2b, 0x63, 0x3d, 0x2b, 0x63, 0x41,
    0x2b, 0x63, 0x5f, 0x2b, 0x63, 0x62, 0x2b, 0x63, 0x64, 0x2b, 0x63, 0x66,
    0x2b, 0x63, 0x67, 0x2b, 0x63, 0x68, 0x2b, 0x63, 0x6c, 0x2b, 0x63, 0x6d,
    0x2b, 0x63, 0x6e, 0x2b, 0x63, 0x70, 0x2b, 0x63, 0x72, 0x2b, 0x63, 0x75,
    0x2b, 0x65, 0x30, 0x2b, 0x65, 0x31, 0x2b, 0x65, 0x32, 0x2b, 0x65, 0x61,
    0x2b, 0x65, 0x63, 0x2b, 0x65, 0x65, 0x2b, 0x65, 0x69, 0x2b, 0x65, 0x6f,
    0x2b, 0x65, 0x73, 0x2b, 0x65, 0x74, 0x2b, 0x65, 0x20, 0x2b, 0x65, 0x25,
    0x2b, 0x65, 0x2d, 0x2b, 0x65, 0x2e, 0x2b, 0x65, 0x2f, 0x2b, 0x65, 0x33,
    0x2b, 0x65, 0x34, 0x2b, 0x65, 0x35, 0x2b, 0x65, 0x36, 0x2b, 0x65, 0x37,
    0x2b, 0x65, 0x38, 0x2b, 0x65, 0x39, 0x2b, 0x65, 0x3d, 0x2b, 0x65, 0x41,
    0x2b, 0x65, 0x5f, 0x2b, 0x65, 0x62, 0x2b, 0x65, 0x64, 0x2b, 0x65, 0x66,
    0x2b, 0x65, 0x67, 0x2b, 0x65, 0x68, 0x2b, 0x65, 0x6c, 0x2b, 0x65, 0x6d,
    0x2b, 0x65, 0x6e, 0x2b, 0x65, 0x70, 0x2b, 0x65, 0x72, 0x2b, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table19_51_emit_[216] = {
    0x2b, 0x69, 0x30, 0x2b, 0x69, 0x31, 0x2b, 0x69, 0x32, 0x2b, 0x69, 0x61,
    0x2b, 0x69, 0x63, 0x2b, 0x69, 0x65, 0x2b, 0x69, 0x69, 0x2b, 0x69, 0x6f,
    0x2b, 0x69, 0x73, 0x2b, 0x69, 0x74, 0x2b, 0x69, 0x20, 0x2b, 0x69, 0x25,
    0x2b, 0x69, 0x2d, 0x2b, 0x69, 0x2e, 0x2b, 0x69, 0x2f, 0x2b, 0x69, 0x33,
    0x2b, 0x69, 0x34, 0x2b, 0x69, 0x35, 0x2b, 0x69, 0x36, 0x2b, 0x69, 0x37,
    0x2b, 0x69, 0x38, 0x2b, 0x69, 0x39, 0x2b, 0x69, 0x3d, 0x2b, 0x69, 0x41,
    0x2b, 0x69, 0x5f, 0x2b, 0x69, 0x62, 0x2b, 0x69, 0x64, 0x2b, 0x69, 0x66,
    0x2b, 0x69, 0x67, 0x2b, 0x69, 0x68, 0x2b, 0x69, 0x6c, 0x2b, 0x69, 0x6d,
    0x2b, 0x69, 0x6e, 0x2b, 0x69, 0x70, 0x2b, 0x69, 0x72, 0x2b, 0x69, 0x75,
    0x2b, 0x6f, 0x30, 0x2b, 0x6f, 0x31, 0x2b, 0x6f, 0x32, 0x2b, 0x6f, 0x61,
    0x2b, 0x6f, 0x63, 0x2b, 0x6f, 0x65, 0x2b, 0x6f, 0x69, 0x2b, 0x6f, 0x6f,
    0x2b, 0x6f, 0x73, 0x2b, 0x6f, 0x74, 0x2b, 0x6f, 0x20, 0x2b, 0x6f, 0x25,
    0x2b, 0x6f, 0x2d, 0x2b, 0x6f, 0x2e, 0x2b, 0x6f, 0x2f, 0x2b, 0x6f, 0x33,
    0x2b, 0x6f, 0x34, 0x2b, 0x6f, 0x35, 0x2b, 0x6f, 0x36, 0x2b, 0x6f, 0x37,
    0x2b, 0x6f, 0x38, 0x2b, 0x6f, 0x39, 0x2b, 0x6f, 0x3d, 0x2b, 0x6f, 0x41,
    0x2b, 0x6f, 0x5f, 0x2b, 0x6f, 0x62, 0x2b, 0x6f, 0x64, 0x2b, 0x6f, 0x66,
    0x2b, 0x6f, 0x67, 0x2b, 0x6f, 0x68, 0x2b, 0x6f, 0x6c, 0x2b, 0x6f, 0x6d,
    0x2b, 0x6f, 0x6e, 0x2b, 0x6f, 0x70, 0x2b, 0x6f, 0x72, 0x2b, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table19_52_emit_[216] = {
    0x2b, 0x73, 0x30, 0x2b, 0x73, 0x31, 0x2b, 0x73, 0x32, 0x2b, 0x73, 0x61,
    0x2b, 0x73, 0x63, 0x2b, 0x73, 0x65, 0x2b, 0x73, 0x69, 0x2b, 0x73, 0x6f,
    0x2b, 0x73, 0x73, 0x2b, 0x73, 0x74, 0x2b, 0x73, 0x20, 0x2b, 0x73, 0x25,
    0x2b, 0x73, 0x2d, 0x2b, 0x73, 0x2e, 0x2b, 0x73, 0x2f, 0x2b, 0x73, 0x33,
    0x2b, 0x73, 0x34, 0x2b, 0x73, 0x35, 0x2b, 0x73, 0x36, 0x2b, 0x73, 0x37,
    0x2b, 0x73, 0x38, 0x2b, 0x73, 0x39, 0x2b, 0x73, 0x3d, 0x2b, 0x73, 0x41,
    0x2b, 0x73, 0x5f, 0x2b, 0x73, 0x62, 0x2b, 0x73, 0x64, 0x2b, 0x73, 0x66,
    0x2b, 0x73, 0x67, 0x2b, 0x73, 0x68, 0x2b, 0x73, 0x6c, 0x2b, 0x73, 0x6d,
    0x2b, 0x73, 0x6e, 0x2b, 0x73, 0x70, 0x2b, 0x73, 0x72, 0x2b, 0x73, 0x75,
    0x2b, 0x74, 0x30, 0x2b, 0x74, 0x31, 0x2b, 0x74, 0x32, 0x2b, 0x74, 0x61,
    0x2b, 0x74, 0x63, 0x2b, 0x74, 0x65, 0x2b, 0x74, 0x69, 0x2b, 0x74, 0x6f,
    0x2b, 0x74, 0x73, 0x2b, 0x74, 0x74, 0x2b, 0x74, 0x20, 0x2b, 0x74, 0x25,
    0x2b, 0x74, 0x2d, 0x2b, 0x74, 0x2e, 0x2b, 0x74, 0x2f, 0x2b, 0x74, 0x33,
    0x2b, 0x74, 0x34, 0x2b, 0x74, 0x35, 0x2b, 0x74, 0x36, 0x2b, 0x74, 0x37,
    0x2b, 0x74, 0x38, 0x2b, 0x74, 0x39, 0x2b, 0x74, 0x3d, 0x2b, 0x74, 0x41,
    0x2b, 0x74, 0x5f, 0x2b, 0x74, 0x62, 0x2b, 0x74, 0x64, 0x2b, 0x74, 0x66,
    0x2b, 0x74, 0x67, 0x2b, 0x74, 0x68, 0x2b, 0x74, 0x6c, 0x2b, 0x74, 0x6d,
    0x2b, 0x74, 0x6e, 0x2b, 0x74, 0x70, 0x2b, 0x74, 0x72, 0x2b, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table19_53_emit_[120] = {
    0x2b, 0x20, 0x30, 0x2b, 0x20, 0x31, 0x2b, 0x20, 0x32, 0x2b, 0x20, 0x61,
    0x2b, 0x20, 0x63, 0x2b, 0x20, 0x65, 0x2b, 0x20, 0x69, 0x2b, 0x20, 0x6f,
    0x2b, 0x20, 0x73, 0x2b, 0x20, 0x74, 0x2b, 0x25, 0x30, 0x2b, 0x25, 0x31,
    0x2b, 0x25, 0x32, 0x2b, 0x25, 0x61, 0x2b, 0x25, 0x63, 0x2b, 0x25, 0x65,
    0x2b, 0x25, 0x69, 0x2b, 0x25, 0x6f, 0x2b, 0x25, 0x73, 0x2b, 0x25, 0x74,
    0x2b, 0x2d, 0x30, 0x2b, 0x2d, 0x31, 0x2b, 0x2d, 0x32, 0x2b, 0x2d, 0x61,
    0x2b, 0x2d, 0x63, 0x2b, 0x2d, 0x65, 0x2b, 0x2d, 0x69, 0x2b, 0x2d, 0x6f,
    0x2b, 0x2d, 0x73, 0x2b, 0x2d, 0x74, 0x2b, 0x2e, 0x30, 0x2b, 0x2e, 0x31,
    0x2b, 0x2e, 0x32, 0x2b, 0x2e, 0x61, 0x2b, 0x2e, 0x63, 0x2b, 0x2e, 0x65,
    0x2b, 0x2e, 0x69, 0x2b, 0x2e, 0x6f, 0x2b, 0x2e, 0x73, 0x2b, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table19_54_emit_[120] = {
    0x2b, 0x2f, 0x30, 0x2b, 0x2f, 0x31, 0x2b, 0x2f, 0x32, 0x2b, 0x2f, 0x61,
    0x2b, 0x2f, 0x63, 0x2b, 0x2f, 0x65, 0x2b, 0x2f, 0x69, 0x2b, 0x2f, 0x6f,
    0x2b, 0x2f, 0x73, 0x2b, 0x2f, 0x74, 0x2b, 0x33, 0x30, 0x2b, 0x33, 0x31,
    0x2b, 0x33, 0x32, 0x2b, 0x33, 0x61, 0x2b, 0x33, 0x63, 0x2b, 0x33, 0x65,
    0x2b, 0x33, 0x69, 0x2b, 0x33, 0x6f, 0x2b, 0x33, 0x73, 0x2b, 0x33, 0x74,
    0x2b, 0x34, 0x30, 0x2b, 0x34, 0x31, 0x2b, 0x34, 0x32, 0x2b, 0x34, 0x61,
    0x2b, 0x34, 0x63, 0x2b, 0x34, 0x65, 0x2b, 0x34, 0x69, 0x2b, 0x34, 0x6f,
    0x2b, 0x34, 0x73, 0x2b, 0x34, 0x74, 0x2b, 0x35, 0x30, 0x2b, 0x35, 0x31,
    0x2b, 0x35, 0x32, 0x2b, 0x35, 0x61, 0x2b, 0x35, 0x63, 0x2b, 0x35, 0x65,
    0x2b, 0x35, 0x69, 0x2b, 0x35, 0x6f, 0x2b, 0x35, 0x73, 0x2b, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table19_55_emit_[120] = {
    0x2b, 0x36, 0x30, 0x2b, 0x36, 0x31, 0x2b, 0x36, 0x32, 0x2b, 0x36, 0x61,
    0x2b, 0x36, 0x63, 0x2b, 0x36, 0x65, 0x2b, 0x36, 0x69, 0x2b, 0x36, 0x6f,
    0x2b, 0x36, 0x73, 0x2b, 0x36, 0x74, 0x2b, 0x37, 0x30, 0x2b, 0x37, 0x31,
    0x2b, 0x37, 0x32, 0x2b, 0x37, 0x61, 0x2b, 0x37, 0x63, 0x2b, 0x37, 0x65,
    0x2b, 0x37, 0x69, 0x2b, 0x37, 0x6f, 0x2b, 0x37, 0x73, 0x2b, 0x37, 0x74,
    0x2b, 0x38, 0x30, 0x2b, 0x38, 0x31, 0x2b, 0x38, 0x32, 0x2b, 0x38, 0x61,
    0x2b, 0x38, 0x63, 0x2b, 0x38, 0x65, 0x2b, 0x38, 0x69, 0x2b, 0x38, 0x6f,
    0x2b, 0x38, 0x73, 0x2b, 0x38, 0x74, 0x2b, 0x39, 0x30, 0x2b, 0x39, 0x31,
    0x2b, 0x39, 0x32, 0x2b, 0x39, 0x61, 0x2b, 0x39, 0x63, 0x2b, 0x39, 0x65,
    0x2b, 0x39, 0x69, 0x2b, 0x39, 0x6f, 0x2b, 0x39, 0x73, 0x2b, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table19_56_emit_[120] = {
    0x2b, 0x3d, 0x30, 0x2b, 0x3d, 0x31, 0x2b, 0x3d, 0x32, 0x2b, 0x3d, 0x61,
    0x2b, 0x3d, 0x63, 0x2b, 0x3d, 0x65, 0x2b, 0x3d, 0x69, 0x2b, 0x3d, 0x6f,
    0x2b, 0x3d, 0x73, 0x2b, 0x3d, 0x74, 0x2b, 0x41, 0x30, 0x2b, 0x41, 0x31,
    0x2b, 0x41, 0x32, 0x2b, 0x41, 0x61, 0x2b, 0x41, 0x63, 0x2b, 0x41, 0x65,
    0x2b, 0x41, 0x69, 0x2b, 0x41, 0x6f, 0x2b, 0x41, 0x73, 0x2b, 0x41, 0x74,
    0x2b, 0x5f, 0x30, 0x2b, 0x5f, 0x31, 0x2b, 0x5f, 0x32, 0x2b, 0x5f, 0x61,
    0x2b, 0x5f, 0x63, 0x2b, 0x5f, 0x65, 0x2b, 0x5f, 0x69, 0x2b, 0x5f, 0x6f,
    0x2b, 0x5f, 0x73, 0x2b, 0x5f, 0x74, 0x2b, 0x62, 0x30, 0x2b, 0x62, 0x31,
    0x2b, 0x62, 0x32, 0x2b, 0x62, 0x61, 0x2b, 0x62, 0x63, 0x2b, 0x62, 0x65,
    0x2b, 0x62, 0x69, 0x2b, 0x62, 0x6f, 0x2b, 0x62, 0x73, 0x2b, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table19_57_emit_[120] = {
    0x2b, 0x64, 0x30, 0x2b, 0x64, 0x31, 0x2b, 0x64, 0x32, 0x2b, 0x64, 0x61,
    0x2b, 0x64, 0x63, 0x2b, 0x64, 0x65, 0x2b, 0x64, 0x69, 0x2b, 0x64, 0x6f,
    0x2b, 0x64, 0x73, 0x2b, 0x64, 0x74, 0x2b, 0x66, 0x30, 0x2b, 0x66, 0x31,
    0x2b, 0x66, 0x32, 0x2b, 0x66, 0x61, 0x2b, 0x66, 0x63, 0x2b, 0x66, 0x65,
    0x2b, 0x66, 0x69, 0x2b, 0x66, 0x6f, 0x2b, 0x66, 0x73, 0x2b, 0x66, 0x74,
    0x2b, 0x67, 0x30, 0x2b, 0x67, 0x31, 0x2b, 0x67, 0x32, 0x2b, 0x67, 0x61,
    0x2b, 0x67, 0x63, 0x2b, 0x67, 0x65, 0x2b, 0x67, 0x69, 0x2b, 0x67, 0x6f,
    0x2b, 0x67, 0x73, 0x2b, 0x67, 0x74, 0x2b, 0x68, 0x30, 0x2b, 0x68, 0x31,
    0x2b, 0x68, 0x32, 0x2b, 0x68, 0x61, 0x2b, 0x68, 0x63, 0x2b, 0x68, 0x65,
    0x2b, 0x68, 0x69, 0x2b, 0x68, 0x6f, 0x2b, 0x68, 0x73, 0x2b, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table19_58_emit_[120] = {
    0x2b, 0x6c, 0x30, 0x2b, 0x6c, 0x31, 0x2b, 0x6c, 0x32, 0x2b, 0x6c, 0x61,
    0x2b, 0x6c, 0x63, 0x2b, 0x6c, 0x65, 0x2b, 0x6c, 0x69, 0x2b, 0x6c, 0x6f,
    0x2b, 0x6c, 0x73, 0x2b, 0x6c, 0x74, 0x2b, 0x6d, 0x30, 0x2b, 0x6d, 0x31,
    0x2b, 0x6d, 0x32, 0x2b, 0x6d, 0x61, 0x2b, 0x6d, 0x63, 0x2b, 0x6d, 0x65,
    0x2b, 0x6d, 0x69, 0x2b, 0x6d, 0x6f, 0x2b, 0x6d, 0x73, 0x2b, 0x6d, 0x74,
    0x2b, 0x6e, 0x30, 0x2b, 0x6e, 0x31, 0x2b, 0x6e, 0x32, 0x2b, 0x6e, 0x61,
    0x2b, 0x6e, 0x63, 0x2b, 0x6e, 0x65, 0x2b, 0x6e, 0x69, 0x2b, 0x6e, 0x6f,
    0x2b, 0x6e, 0x73, 0x2b, 0x6e, 0x74, 0x2b, 0x70, 0x30, 0x2b, 0x70, 0x31,
    0x2b, 0x70, 0x32, 0x2b, 0x70, 0x61, 0x2b, 0x70, 0x63, 0x2b, 0x70, 0x65,
    0x2b, 0x70, 0x69, 0x2b, 0x70, 0x6f, 0x2b, 0x70, 0x73, 0x2b, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table19_59_emit_[68] = {
    0x2b, 0x72, 0x30, 0x2b, 0x72, 0x31, 0x2b, 0x72, 0x32, 0x2b, 0x72, 0x61,
    0x2b, 0x72, 0x63, 0x2b, 0x72, 0x65, 0x2b, 0x72, 0x69, 0x2b, 0x72, 0x6f,
    0x2b, 0x72, 0x73, 0x2b, 0x72, 0x74, 0x2b, 0x75, 0x30, 0x2b, 0x75, 0x31,
    0x2b, 0x75, 0x32, 0x2b, 0x75, 0x61, 0x2b, 0x75, 0x63, 0x2b, 0x75, 0x65,
    0x2b, 0x75, 0x69, 0x2b, 0x75, 0x6f, 0x2b, 0x75, 0x73, 0x2b, 0x75, 0x74,
    0x2b, 0x3a, 0x2b, 0x42, 0x2b, 0x43, 0x2b, 0x44};
const uint8_t HuffDecoderCommon::table19_63_emit_[35] = {
    0x2b, 0x77, 0x2b, 0x78, 0x2b, 0x79, 0x2b, 0x7a, 0x2b, 0x26, 0x2b, 0x2a,
    0x2b, 0x2c, 0x2b, 0x3b, 0x2b, 0x58, 0x2b, 0x5a, 0x2b, 0x21, 0x2b, 0x22,
    0x2b, 0x28, 0x2b, 0x29, 0x2b, 0x3f, 0x2b, 0x27, 0x2b, 0x2b, 0x7c};
const uint16_t HuffDecoderCommon::table19_63_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x00a2, 0x0000, 0x00b2, 0x0000,
    0x00c2, 0x0000, 0x00d2, 0x0000, 0x00e2, 0x00f2, 0x0102, 0x010a, 0x0000,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table19_64_emit_[216] = {
    0x7c, 0x30, 0x30, 0x7c, 0x30, 0x31, 0x7c, 0x30, 0x32, 0x7c, 0x30, 0x61,
    0x7c, 0x30, 0x63, 0x7c, 0x30, 0x65, 0x7c, 0x30, 0x69, 0x7c, 0x30, 0x6f,
    0x7c, 0x30, 0x73, 0x7c, 0x30, 0x74, 0x7c, 0x30, 0x20, 0x7c, 0x30, 0x25,
    0x7c, 0x30, 0x2d, 0x7c, 0x30, 0x2e, 0x7c, 0x30, 0x2f, 0x7c, 0x30, 0x33,
    0x7c, 0x30, 0x34, 0x7c, 0x30, 0x35, 0x7c, 0x30, 0x36, 0x7c, 0x30, 0x37,
    0x7c, 0x30, 0x38, 0x7c, 0x30, 0x39, 0x7c, 0x30, 0x3d, 0x7c, 0x30, 0x41,
    0x7c, 0x30, 0x5f, 0x7c, 0x30, 0x62, 0x7c, 0x30, 0x64, 0x7c, 0x30, 0x66,
    0x7c, 0x30, 0x67, 0x7c, 0x30, 0x68, 0x7c, 0x30, 0x6c, 0x7c, 0x30, 0x6d,
    0x7c, 0x30, 0x6e, 0x7c, 0x30, 0x70, 0x7c, 0x30, 0x72, 0x7c, 0x30, 0x75,
    0x7c, 0x31, 0x30, 0x7c, 0x31, 0x31, 0x7c, 0x31, 0x32, 0x7c, 0x31, 0x61,
    0x7c, 0x31, 0x63, 0x7c, 0x31, 0x65, 0x7c, 0x31, 0x69, 0x7c, 0x31, 0x6f,
    0x7c, 0x31, 0x73, 0x7c, 0x31, 0x74, 0x7c, 0x31, 0x20, 0x7c, 0x31, 0x25,
    0x7c, 0x31, 0x2d, 0x7c, 0x31, 0x2e, 0x7c, 0x31, 0x2f, 0x7c, 0x31, 0x33,
    0x7c, 0x31, 0x34, 0x7c, 0x31, 0x35, 0x7c, 0x31, 0x36, 0x7c, 0x31, 0x37,
    0x7c, 0x31, 0x38, 0x7c, 0x31, 0x39, 0x7c, 0x31, 0x3d, 0x7c, 0x31, 0x41,
    0x7c, 0x31, 0x5f, 0x7c, 0x31, 0x62, 0x7c, 0x31, 0x64, 0x7c, 0x31, 0x66,
    0x7c, 0x31, 0x67, 0x7c, 0x31, 0x68, 0x7c, 0x31, 0x6c, 0x7c, 0x31, 0x6d,
    0x7c, 0x31, 0x6e, 0x7c, 0x31, 0x70, 0x7c, 0x31, 0x72, 0x7c, 0x31, 0x75};
const uint8_t HuffDecoderCommon::table19_65_emit_[216] = {
    0x7c, 0x32, 0x30, 0x7c, 0x32, 0x31, 0x7c, 0x32, 0x32, 0x7c, 0x32, 0x61,
    0x7c, 0x32, 0x63, 0x7c, 0x32, 0x65, 0x7c, 0x32, 0x69, 0x7c, 0x32, 0x6f,
    0x7c, 0x32, 0x73, 0x7c, 0x32, 0x74, 0x7c, 0x32, 0x20, 0x7c, 0x32, 0x25,
    0x7c, 0x32, 0x2d, 0x7c, 0x32, 0x2e, 0x7c, 0x32, 0x2f, 0x7c, 0x32, 0x33,
    0x7c, 0x32, 0x34, 0x7c, 0x32, 0x35, 0x7c, 0x32, 0x36, 0x7c, 0x32, 0x37,
    0x7c, 0x32, 0x38, 0x7c, 0x32, 0x39, 0x7c, 0x32, 0x3d, 0x7c, 0x32, 0x41,
    0x7c, 0x32, 0x5f, 0x7c, 0x32, 0x62, 0x7c, 0x32, 0x64, 0x7c, 0x32, 0x66,
    0x7c, 0x32, 0x67, 0x7c, 0x32, 0x68, 0x7c, 0x32, 0x6c, 0x7c, 0x32, 0x6d,
    0x7c, 0x32, 0x6e, 0x7c, 0x32, 0x70, 0x7c, 0x32, 0x72, 0x7c, 0x32, 0x75,
    0x7c, 0x61, 0x30, 0x7c, 0x61, 0x31, 0x7c, 0x61, 0x32, 0x7c, 0x61, 0x61,
    0x7c, 0x61, 0x63, 0x7c, 0x61, 0x65, 0x7c, 0x61, 0x69, 0x7c, 0x61, 0x6f,
    0x7c, 0x61, 0x73, 0x7c, 0x61, 0x74, 0x7c, 0x61, 0x20, 0x7c, 0x61, 0x25,
    0x7c, 0x61, 0x2d, 0x7c, 0x61, 0x2e, 0x7c, 0x61, 0x2f, 0x7c, 0x61, 0x33,
    0x7c, 0x61, 0x34, 0x7c, 0x61, 0x35, 0x7c, 0x61, 0x36, 0x7c, 0x61, 0x37,
    0x7c, 0x61, 0x38, 0x7c, 0x61, 0x39, 0x7c, 0x61, 0x3d, 0x7c, 0x61, 0x41,
    0x7c, 0x61, 0x5f, 0x7c, 0x61, 0x62, 0x7c, 0x61, 0x64, 0x7c, 0x61, 0x66,
    0x7c, 0x61, 0x67, 0x7c, 0x61, 0x68, 0x7c, 0x61, 0x6c, 0x7c, 0x61, 0x6d,
    0x7c, 0x61, 0x6e, 0x7c, 0x61, 0x70, 0x7c, 0x61, 0x72, 0x7c, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table19_66_emit_[216] = {
    0x7c, 0x63, 0x30, 0x7c, 0x63, 0x31, 0x7c, 0x63, 0x32, 0x7c, 0x63, 0x61,
    0x7c, 0x63, 0x63, 0x7c, 0x63, 0x65, 0x7c, 0x63, 0x69, 0x7c, 0x63, 0x6f,
    0x7c, 0x63, 0x73, 0x7c, 0x63, 0x74, 0x7c, 0x63, 0x20, 0x7c, 0x63, 0x25,
    0x7c, 0x63, 0x2d, 0x7c, 0x63, 0x2e, 0x7c, 0x63, 0x2f, 0x7c, 0x63, 0x33,
    0x7c, 0x63, 0x34, 0x7c, 0x63, 0x35, 0x7c, 0x63, 0x36, 0x7c, 0x63, 0x37,
    0x7c, 0x63, 0x38, 0x7c, 0x63, 0x39, 0x7c, 0x63, 0x3d, 0x7c, 0x63, 0x41,
    0x7c, 0x63, 0x5f, 0x7c, 0x63, 0x62, 0x7c, 0x63, 0x64, 0x7c, 0x63, 0x66,
    0x7c, 0x63, 0x67, 0x7c, 0x63, 0x68, 0x7c, 0x63, 0x6c, 0x7c, 0x63, 0x6d,
    0x7c, 0x63, 0x6e, 0x7c, 0x63, 0x70, 0x7c, 0x63, 0x72, 0x7c, 0x63, 0x75,
    0x7c, 0x65, 0x30, 0x7c, 0x65, 0x31, 0x7c, 0x65, 0x32, 0x7c, 0x65, 0x61,
    0x7c, 0x65, 0x63, 0x7c, 0x65, 0x65, 0x7c, 0x65, 0x69, 0x7c, 0x65, 0x6f,
    0x7c, 0x65, 0x73, 0x7c, 0x65, 0x74, 0x7c, 0x65, 0x20, 0x7c, 0x65, 0x25,
    0x7c, 0x65, 0x2d, 0x7c, 0x65, 0x2e, 0x7c, 0x65, 0x2f, 0x7c, 0x65, 0x33,
    0x7c, 0x65, 0x34, 0x7c, 0x65, 0x35, 0x7c, 0x65, 0x36, 0x7c, 0x65, 0x37,
    0x7c, 0x65, 0x38, 0x7c, 0x65, 0x39, 0x7c, 0x65, 0x3d, 0x7c, 0x65, 0x41,
    0x7c, 0x65, 0x5f, 0x7c, 0x65, 0x62, 0x7c, 0x65, 0x64, 0x7c, 0x65, 0x66,
    0x7c, 0x65, 0x67, 0x7c, 0x65, 0x68, 0x7c, 0x65, 0x6c, 0x7c, 0x65, 0x6d,
    0x7c, 0x65, 0x6e, 0x7c, 0x65, 0x70, 0x7c, 0x65, 0x72, 0x7c, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table19_67_emit_[216] = {
    0x7c, 0x69, 0x30, 0x7c, 0x69, 0x31, 0x7c, 0x69, 0x32, 0x7c, 0x69, 0x61,
    0x7c, 0x69, 0x63, 0x7c, 0x69, 0x65, 0x7c, 0x69, 0x69, 0x7c, 0x69, 0x6f,
    0x7c, 0x69, 0x73, 0x7c, 0x69, 0x74, 0x7c, 0x69, 0x20, 0x7c, 0x69, 0x25,
    0x7c, 0x69, 0x2d, 0x7c, 0x69, 0x2e, 0x7c, 0x69, 0x2f, 0x7c, 0x69, 0x33,
    0x7c, 0x69, 0x34, 0x7c, 0x69, 0x35, 0x7c, 0x69, 0x36, 0x7c, 0x69, 0x37,
    0x7c, 0x69, 0x38, 0x7c, 0x69, 0x39, 0x7c, 0x69, 0x3d, 0x7c, 0x69, 0x41,
    0x7c, 0x69, 0x5f, 0x7c, 0x69, 0x62, 0x7c, 0x69, 0x64, 0x7c, 0x69, 0x66,
    0x7c, 0x69, 0x67, 0x7c, 0x69, 0x68, 0x7c, 0x69, 0x6c, 0x7c, 0x69, 0x6d,
    0x7c, 0x69, 0x6e, 0x7c, 0x69, 0x70, 0x7c, 0x69, 0x72, 0x7c, 0x69, 0x75,
    0x7c, 0x6f, 0x30, 0x7c, 0x6f, 0x31, 0x7c, 0x6f, 0x32, 0x7c, 0x6f, 0x61,
    0x7c, 0x6f, 0x63, 0x7c, 0x6f, 0x65, 0x7c, 0x6f, 0x69, 0x7c, 0x6f, 0x6f,
    0x7c, 0x6f, 0x73, 0x7c, 0x6f, 0x74, 0x7c, 0x6f, 0x20, 0x7c, 0x6f, 0x25,
    0x7c, 0x6f, 0x2d, 0x7c, 0x6f, 0x2e, 0x7c, 0x6f, 0x2f, 0x7c, 0x6f, 0x33,
    0x7c, 0x6f, 0x34, 0x7c, 0x6f, 0x35, 0x7c, 0x6f, 0x36, 0x7c, 0x6f, 0x37,
    0x7c, 0x6f, 0x38, 0x7c, 0x6f, 0x39, 0x7c, 0x6f, 0x3d, 0x7c, 0x6f, 0x41,
    0x7c, 0x6f, 0x5f, 0x7c, 0x6f, 0x62, 0x7c, 0x6f, 0x64, 0x7c, 0x6f, 0x66,
    0x7c, 0x6f, 0x67, 0x7c, 0x6f, 0x68, 0x7c, 0x6f, 0x6c, 0x7c, 0x6f, 0x6d,
    0x7c, 0x6f, 0x6e, 0x7c, 0x6f, 0x70, 0x7c, 0x6f, 0x72, 0x7c, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table19_68_emit_[216] = {
    0x7c, 0x73, 0x30, 0x7c, 0x73, 0x31, 0x7c, 0x73, 0x32, 0x7c, 0x73, 0x61,
    0x7c, 0x73, 0x63, 0x7c, 0x73, 0x65, 0x7c, 0x73, 0x69, 0x7c, 0x73, 0x6f,
    0x7c, 0x73, 0x73, 0x7c, 0x73, 0x74, 0x7c, 0x73, 0x20, 0x7c, 0x73, 0x25,
    0x7c, 0x73, 0x2d, 0x7c, 0x73, 0x2e, 0x7c, 0x73, 0x2f, 0x7c, 0x73, 0x33,
    0x7c, 0x73, 0x34, 0x7c, 0x73, 0x35, 0x7c, 0x73, 0x36, 0x7c, 0x73, 0x37,
    0x7c, 0x73, 0x38, 0x7c, 0x73, 0x39, 0x7c, 0x73, 0x3d, 0x7c, 0x73, 0x41,
    0x7c, 0x73, 0x5f, 0x7c, 0x73, 0x62, 0x7c, 0x73, 0x64, 0x7c, 0x73, 0x66,
    0x7c, 0x73, 0x67, 0x7c, 0x73, 0x68, 0x7c, 0x73, 0x6c, 0x7c, 0x73, 0x6d,
    0x7c, 0x73, 0x6e, 0x7c, 0x73, 0x70, 0x7c, 0x73, 0x72, 0x7c, 0x73, 0x75,
    0x7c, 0x74, 0x30, 0x7c, 0x74, 0x31, 0x7c, 0x74, 0x32, 0x7c, 0x74, 0x61,
    0x7c, 0x74, 0x63, 0x7c, 0x74, 0x65, 0x7c, 0x74, 0x69, 0x7c, 0x74, 0x6f,
    0x7c, 0x74, 0x73, 0x7c, 0x74, 0x74, 0x7c, 0x74, 0x20, 0x7c, 0x74, 0x25,
    0x7c, 0x74, 0x2d, 0x7c, 0x74, 0x2e, 0x7c, 0x74, 0x2f, 0x7c, 0x74, 0x33,
    0x7c, 0x74, 0x34, 0x7c, 0x74, 0x35, 0x7c, 0x74, 0x36, 0x7c, 0x74, 0x37,
    0x7c, 0x74, 0x38, 0x7c, 0x74, 0x39, 0x7c, 0x74, 0x3d, 0x7c, 0x74, 0x41,
    0x7c, 0x74, 0x5f, 0x7c, 0x74, 0x62, 0x7c, 0x74, 0x64, 0x7c, 0x74, 0x66,
    0x7c, 0x74, 0x67, 0x7c, 0x74, 0x68, 0x7c, 0x74, 0x6c, 0x7c, 0x74, 0x6d,
    0x7c, 0x74, 0x6e, 0x7c, 0x74, 0x70, 0x7c, 0x74, 0x72, 0x7c, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table19_69_emit_[120] = {
    0x7c, 0x20, 0x30, 0x7c, 0x20, 0x31, 0x7c, 0x20, 0x32, 0x7c, 0x20, 0x61,
    0x7c, 0x20, 0x63, 0x7c, 0x20, 0x65, 0x7c, 0x20, 0x69, 0x7c, 0x20, 0x6f,
    0x7c, 0x20, 0x73, 0x7c, 0x20, 0x74, 0x7c, 0x25, 0x30, 0x7c, 0x25, 0x31,
    0x7c, 0x25, 0x32, 0x7c, 0x25, 0x61, 0x7c, 0x25, 0x63, 0x7c, 0x25, 0x65,
    0x7c, 0x25, 0x69, 0x7c, 0x25, 0x6f, 0x7c, 0x25, 0x73, 0x7c, 0x25, 0x74,
    0x7c, 0x2d, 0x30, 0x7c, 0x2d, 0x31, 0x7c, 0x2d, 0x32, 0x7c, 0x2d, 0x61,
    0x7c, 0x2d, 0x63, 0x7c, 0x2d, 0x65, 0x7c, 0x2d, 0x69, 0x7c, 0x2d, 0x6f,
    0x7c, 0x2d, 0x73, 0x7c, 0x2d, 0x74, 0x7c, 0x2e, 0x30, 0x7c, 0x2e, 0x31,
    0x7c, 0x2e, 0x32, 0x7c, 0x2e, 0x61, 0x7c, 0x2e, 0x63, 0x7c, 0x2e, 0x65,
    0x7c, 0x2e, 0x69, 0x7c, 0x2e, 0x6f, 0x7c, 0x2e, 0x73, 0x7c, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table19_70_emit_[120] = {
    0x7c, 0x2f, 0x30, 0x7c, 0x2f, 0x31, 0x7c, 0x2f, 0x32, 0x7c, 0x2f, 0x61,
    0x7c, 0x2f, 0x63, 0x7c, 0x2f, 0x65, 0x7c, 0x2f, 0x69, 0x7c, 0x2f, 0x6f,
    0x7c, 0x2f, 0x73, 0x7c, 0x2f, 0x74, 0x7c, 0x33, 0x30, 0x7c, 0x33, 0x31,
    0x7c, 0x33, 0x32, 0x7c, 0x33, 0x61, 0x7c, 0x33, 0x63, 0x7c, 0x33, 0x65,
    0x7c, 0x33, 0x69, 0x7c, 0x33, 0x6f, 0x7c, 0x33, 0x73, 0x7c, 0x33, 0x74,
    0x7c, 0x34, 0x30, 0x7c, 0x34, 0x31, 0x7c, 0x34, 0x32, 0x7c, 0x34, 0x61,
    0x7c, 0x34, 0x63, 0x7c, 0x34, 0x65, 0x7c, 0x34, 0x69, 0x7c, 0x34, 0x6f,
    0x7c, 0x34, 0x73, 0x7c, 0x34, 0x74, 0x7c, 0x35, 0x30, 0x7c, 0x35, 0x31,
    0x7c, 0x35, 0x32, 0x7c, 0x35, 0x61, 0x7c, 0x35, 0x63, 0x7c, 0x35, 0x65,
    0x7c, 0x35, 0x69, 0x7c, 0x35, 0x6f, 0x7c, 0x35, 0x73, 0x7c, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table19_71_emit_[120] = {
    0x7c, 0x36, 0x30, 0x7c, 0x36, 0x31, 0x7c, 0x36, 0x32, 0x7c, 0x36, 0x61,
    0x7c, 0x36, 0x63, 0x7c, 0x36, 0x65, 0x7c, 0x36, 0x69, 0x7c, 0x36, 0x6f,
    0x7c, 0x36, 0x73, 0x7c, 0x36, 0x74, 0x7c, 0x37, 0x30, 0x7c, 0x37, 0x31,
    0x7c, 0x37, 0x32, 0x7c, 0x37, 0x61, 0x7c, 0x37, 0x63, 0x7c, 0x37, 0x65,
    0x7c, 0x37, 0x69, 0x7c, 0x37, 0x6f, 0x7c, 0x37, 0x73, 0x7c, 0x37, 0x74,
    0x7c, 0x38, 0x30, 0x7c, 0x38, 0x31, 0x7c, 0x38, 0x32, 0x7c, 0x38, 0x61,
    0x7c, 0x38, 0x63, 0x7c, 0x38, 0x65, 0x7c, 0x38, 0x69, 0x7c, 0x38, 0x6f,
    0x7c, 0x38, 0x73, 0x7c, 0x38, 0x74, 0x7c, 0x39, 0x30, 0x7c, 0x39, 0x31,
    0x7c, 0x39, 0x32, 0x7c, 0x39, 0x61, 0x7c, 0x39, 0x63, 0x7c, 0x39, 0x65,
    0x7c, 0x39, 0x69, 0x7c, 0x39, 0x6f, 0x7c, 0x39, 0x73, 0x7c, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table19_72_emit_[120] = {
    0x7c, 0x3d, 0x30, 0x7c, 0x3d, 0x31, 0x7c, 0x3d, 0x32, 0x7c, 0x3d, 0x61,
    0x7c, 0x3d, 0x63, 0x7c, 0x3d, 0x65, 0x7c, 0x3d, 0x69, 0x7c, 0x3d, 0x6f,
    0x7c, 0x3d, 0x73, 0x7c, 0x3d, 0x74, 0x7c, 0x41, 0x30, 0x7c, 0x41, 0x31,
    0x7c, 0x41, 0x32, 0x7c, 0x41, 0x61, 0x7c, 0x41, 0x63, 0x7c, 0x41, 0x65,
    0x7c, 0x41, 0x69, 0x7c, 0x41, 0x6f, 0x7c, 0x41, 0x73, 0x7c, 0x41, 0x74,
    0x7c, 0x5f, 0x30, 0x7c, 0x5f, 0x31, 0x7c, 0x5f, 0x32, 0x7c, 0x5f, 0x61,
    0x7c, 0x5f, 0x63, 0x7c, 0x5f, 0x65, 0x7c, 0x5f, 0x69, 0x7c, 0x5f, 0x6f,
    0x7c, 0x5f, 0x73, 0x7c, 0x5f, 0x74, 0x7c, 0x62, 0x30, 0x7c, 0x62, 0x31,
    0x7c, 0x62, 0x32, 0x7c, 0x62, 0x61, 0x7c, 0x62, 0x63, 0x7c, 0x62, 0x65,
    0x7c, 0x62, 0x69, 0x7c, 0x62, 0x6f, 0x7c, 0x62, 0x73, 0x7c, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table19_73_emit_[120] = {
    0x7c, 0x64, 0x30, 0x7c, 0x64, 0x31, 0x7c, 0x64, 0x32, 0x7c, 0x64, 0x61,
    0x7c, 0x64, 0x63, 0x7c, 0x64, 0x65, 0x7c, 0x64, 0x69, 0x7c, 0x64, 0x6f,
    0x7c, 0x64, 0x73, 0x7c, 0x64, 0x74, 0x7c, 0x66, 0x30, 0x7c, 0x66, 0x31,
    0x7c, 0x66, 0x32, 0x7c, 0x66, 0x61, 0x7c, 0x66, 0x63, 0x7c, 0x66, 0x65,
    0x7c, 0x66, 0x69, 0x7c, 0x66, 0x6f, 0x7c, 0x66, 0x73, 0x7c, 0x66, 0x74,
    0x7c, 0x67, 0x30, 0x7c, 0x67, 0x31, 0x7c, 0x67, 0x32, 0x7c, 0x67, 0x61,
    0x7c, 0x67, 0x63, 0x7c, 0x67, 0x65, 0x7c, 0x67, 0x69, 0x7c, 0x67, 0x6f,
    0x7c, 0x67, 0x73, 0x7c, 0x67, 0x74, 0x7c, 0x68, 0x30, 0x7c, 0x68, 0x31,
    0x7c, 0x68, 0x32, 0x7c, 0x68, 0x61, 0x7c, 0x68, 0x63, 0x7c, 0x68, 0x65,
    0x7c, 0x68, 0x69, 0x7c, 0x68, 0x6f, 0x7c, 0x68, 0x73, 0x7c, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table19_74_emit_[120] = {
    0x7c, 0x6c, 0x30, 0x7c, 0x6c, 0x31, 0x7c, 0x6c, 0x32, 0x7c, 0x6c, 0x61,
    0x7c, 0x6c, 0x63, 0x7c, 0x6c, 0x65, 0x7c, 0x6c, 0x69, 0x7c, 0x6c, 0x6f,
    0x7c, 0x6c, 0x73, 0x7c, 0x6c, 0x74, 0x7c, 0x6d, 0x30, 0x7c, 0x6d, 0x31,
    0x7c, 0x6d, 0x32, 0x7c, 0x6d, 0x61, 0x7c, 0x6d, 0x63, 0x7c, 0x6d, 0x65,
    0x7c, 0x6d, 0x69, 0x7c, 0x6d, 0x6f, 0x7c, 0x6d, 0x73, 0x7c, 0x6d, 0x74,
    0x7c, 0x6e, 0x30, 0x7c, 0x6e, 0x31, 0x7c, 0x6e, 0x32, 0x7c, 0x6e, 0x61,
    0x7c, 0x6e, 0x63, 0x7c, 0x6e, 0x65, 0x7c, 0x6e, 0x69, 0x7c, 0x6e, 0x6f,
    0x7c, 0x6e, 0x73, 0x7c, 0x6e, 0x74, 0x7c, 0x70, 0x30, 0x7c, 0x70, 0x31,
    0x7c, 0x70, 0x32, 0x7c, 0x70, 0x61, 0x7c, 0x70, 0x63, 0x7c, 0x70, 0x65,
    0x7c, 0x70, 0x69, 0x7c, 0x70, 0x6f, 0x7c, 0x70, 0x73, 0x7c, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table19_75_emit_[68] = {
    0x7c, 0x72, 0x30, 0x7c, 0x72, 0x31, 0x7c, 0x72, 0x32, 0x7c, 0x72, 0x61,
    0x7c, 0x72, 0x63, 0x7c, 0x72, 0x65, 0x7c, 0x72, 0x69, 0x7c, 0x72, 0x6f,
    0x7c, 0x72, 0x73, 0x7c, 0x72, 0x74, 0x7c, 0x75, 0x30, 0x7c, 0x75, 0x31,
    0x7c, 0x75, 0x32, 0x7c, 0x75, 0x61, 0x7c, 0x75, 0x63, 0x7c, 0x75, 0x65,
    0x7c, 0x75, 0x69, 0x7c, 0x75, 0x6f, 0x7c, 0x75, 0x73, 0x7c, 0x75, 0x74,
    0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44};
const uint8_t HuffDecoderCommon::table19_79_emit_[36] = {
    0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a, 0x7c, 0x26, 0x7c, 0x2a,
    0x7c, 0x2c, 0x7c, 0x3b, 0x7c, 0x58, 0x7c, 0x5a, 0x7c, 0x21, 0x7c, 0x22,
    0x7c, 0x28, 0x7c, 0x29, 0x7c, 0x3f, 0x7c, 0x27, 0x7c, 0x2b, 0x7c, 0x7c};
const uint16_t HuffDecoderCommon::table19_79_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x00a2, 0x0000, 0x00b2, 0x0000,
    0x00c2, 0x0000, 0x00d2, 0x0000, 0x00e2, 0x00f2, 0x0102, 0x0112, 0x0000,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table19_80_emit_[120] = {
    0x23, 0x30, 0x30, 0x23, 0x30, 0x31, 0x23, 0x30, 0x32, 0x23, 0x30, 0x61,
    0x23, 0x30, 0x63, 0x23, 0x30, 0x65, 0x23, 0x30, 0x69, 0x23, 0x30, 0x6f,
    0x23, 0x30, 0x73, 0x23, 0x30, 0x74, 0x23, 0x31, 0x30, 0x23, 0x31, 0x31,
    0x23, 0x31, 0x32, 0x23, 0x31, 0x61, 0x23, 0x31, 0x63, 0x23, 0x31, 0x65,
    0x23, 0x31, 0x69, 0x23, 0x31, 0x6f, 0x23, 0x31, 0x73, 0x23, 0x31, 0x74,
    0x23, 0x32, 0x30, 0x23, 0x32, 0x31, 0x23, 0x32, 0x32, 0x23, 0x32, 0x61,
    0x23, 0x32, 0x63, 0x23, 0x32, 0x65, 0x23, 0x32, 0x69, 0x23, 0x32, 0x6f,
    0x23, 0x32, 0x73, 0x23, 0x32, 0x74, 0x23, 0x61, 0x30, 0x23, 0x61, 0x31,
    0x23, 0x61, 0x32, 0x23, 0x61, 0x61, 0x23, 0x61, 0x63, 0x23, 0x61, 0x65,
    0x23, 0x61, 0x69, 0x23, 0x61, 0x6f, 0x23, 0x61, 0x73, 0x23, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table19_81_emit_[120] = {
    0x23, 0x63, 0x30, 0x23, 0x63, 0x31, 0x23, 0x63, 0x32, 0x23, 0x63, 0x61,
    0x23, 0x63, 0x63, 0x23, 0x63, 0x65, 0x23, 0x63, 0x69, 0x23, 0x63, 0x6f,
    0x23, 0x63, 0x73, 0x23, 0x63, 0x74, 0x23, 0x65, 0x30, 0x23, 0x65, 0x31,
    0x23, 0x65, 0x32, 0x23, 0x65, 0x61, 0x23, 0x65, 0x63, 0x23, 0x65, 0x65,
    0x23, 0x65, 0x69, 0x23, 0x65, 0x6f, 0x23, 0x65, 0x73, 0x23, 0x65, 0x74,
    0x23, 0x69, 0x30, 0x23, 0x69, 0x31, 0x23, 0x69, 0x32, 0x23, 0x69, 0x61,
    0x23, 0x69, 0x63, 0x23, 0x69, 0x65, 0x23, 0x69, 0x69, 0x23, 0x69, 0x6f,
    0x23, 0x69, 0x73, 0x23, 0x69, 0x74, 0x23, 0x6f, 0x30, 0x23, 0x6f, 0x31,
    0x23, 0x6f, 0x32, 0x23, 0x6f, 0x61, 0x23, 0x6f, 0x63, 0x23, 0x6f, 0x65,
    0x23, 0x6f, 0x69, 0x23, 0x6f, 0x6f, 0x23, 0x6f, 0x73, 0x23, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table19_82_emit_[68] = {
    0x23, 0x73, 0x30, 0x23, 0x73, 0x31, 0x23, 0x73, 0x32, 0x23, 0x73, 0x61,
    0x23, 0x73, 0x63, 0x23, 0x73, 0x65, 0x23, 0x73, 0x69, 0x23, 0x73, 0x6f,
    0x23, 0x73, 0x73, 0x23, 0x73, 0x74, 0x23, 0x74, 0x30, 0x23, 0x74, 0x31,
    0x23, 0x74, 0x32, 0x23, 0x74, 0x61, 0x23, 0x74, 0x63, 0x23, 0x74, 0x65,
    0x23, 0x74, 0x69, 0x23, 0x74, 0x6f, 0x23, 0x74, 0x73, 0x23, 0x74, 0x74,
    0x23, 0x20, 0x23, 0x25, 0x23, 0x2d, 0x23, 0x2e};
const uint16_t HuffDecoderCommon::table19_85_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0092};
const uint16_t HuffDecoderCommon::table19_86_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0092, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00b2, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x00c2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x00d2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x00e2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x00f2};
const uint8_t HuffDecoderCommon::table19_87_emit_[46] = {
    0x23, 0x55, 0x23, 0x56, 0x23, 0x57, 0x23, 0x59, 0x23, 0x6a, 0x23, 0x6b,
    0x23, 0x71, 0x23, 0x76, 0x23, 0x77, 0x23, 0x78, 0x23, 0x79, 0x23, 0x7a,
    0x23, 0x26, 0x23, 0x2a, 0x23, 0x2c, 0x23, 0x3b, 0x23, 0x58, 0x23, 0x5a,
    0x23, 0x21, 0x23, 0x22, 0x23, 0x28, 0x23, 0x29, 0x23, 0x3f};
const uint16_t HuffDecoderCommon::table19_87_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0092, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00b2, 0x0000, 0x0000, 0x0000,
    0x00c2, 0x0000, 0x0000, 0x0000, 0x00d2, 0x0000, 0x0000, 0x0000, 0x00e2,
    0x0000, 0x0000, 0x0000, 0x00f2, 0x0000, 0x0000, 0x0000, 0x0102, 0x0000,
    0x0000, 0x0000, 0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0000,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table19_88_emit_[120] = {
    0x3e, 0x30, 0x30, 0x3e, 0x30, 0x31, 0x3e, 0x30, 0x32, 0x3e, 0x30, 0x61,
    0x3e, 0x30, 0x63, 0x3e, 0x30, 0x65, 0x3e, 0x30, 0x69, 0x3e, 0x30, 0x6f,
    0x3e, 0x30, 0x73, 0x3e, 0x30, 0x74, 0x3e, 0x31, 0x30, 0x3e, 0x31, 0x31,
    0x3e, 0x31, 0x32, 0x3e, 0x31, 0x61, 0x3e, 0x31, 0x63, 0x3e, 0x31, 0x65,
    0x3e, 0x31, 0x69, 0x3e, 0x31, 0x6f, 0x3e, 0x31, 0x73, 0x3e, 0x31, 0x74,
    0x3e, 0x32, 0x30, 0x3e, 0x32, 0x31, 0x3e, 0x32, 0x32, 0x3e, 0x32, 0x61,
    0x3e, 0x32, 0x63, 0x3e, 0x32, 0x65, 0x3e, 0x32, 0x69, 0x3e, 0x32, 0x6f,
    0x3e, 0x32, 0x73, 0x3e, 0x32, 0x74, 0x3e, 0x61, 0x30, 0x3e, 0x61, 0x31,
    0x3e, 0x61, 0x32, 0x3e, 0x61, 0x61, 0x3e, 0x61, 0x63, 0x3e, 0x61, 0x65,
    0x3e, 0x61, 0x69, 0x3e, 0x61, 0x6f, 0x3e, 0x61, 0x73, 0x3e, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table19_89_emit_[120] = {
    0x3e, 0x63, 0x30, 0x3e, 0x63, 0x31, 0x3e, 0x63, 0x32, 0x3e, 0x63, 0x61,
    0x3e, 0x63, 0x63, 0x3e, 0x63, 0x65, 0x3e, 0x63, 0x69, 0x3e, 0x63, 0x6f,
    0x3e, 0x63, 0x73, 0x3e, 0x63, 0x74, 0x3e, 0x65, 0x30, 0x3e, 0x65, 0x31,
    0x3e, 0x65, 0x32, 0x3e, 0x65, 0x61, 0x3e, 0x65, 0x63, 0x3e, 0x65, 0x65,
    0x3e, 0x65, 0x69, 0x3e, 0x65, 0x6f, 0x3e, 0x65, 0x73, 0x3e, 0x65, 0x74,
    0x3e, 0x69, 0x30, 0x3e, 0x69, 0x31, 0x3e, 0x69, 0x32, 0x3e, 0x69, 0x61,
    0x3e, 0x69, 0x63, 0x3e, 0x69, 0x65, 0x3e, 0x69, 0x69, 0x3e, 0x69, 0x6f,
    0x3e, 0x69, 0x73, 0x3e, 0x69, 0x74, 0x3e, 0x6f, 0x30, 0x3e, 0x6f, 0x31,
    0x3e, 0x6f, 0x32, 0x3e, 0x6f, 0x61, 0x3e, 0x6f, 0x63, 0x3e, 0x6f, 0x65,
    0x3e, 0x6f, 0x69, 0x3e, 0x6f, 0x6f, 0x3e, 0x6f, 0x73, 0x3e, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table19_90_emit_[68] = {
    0x3e, 0x73, 0x30, 0x3e, 0x73, 0x31, 0x3e, 0x73, 0x32, 0x3e, 0x73, 0x61,
    0x3e, 0x73, 0x63, 0x3e, 0x73, 0x65, 0x3e, 0x73, 0x69, 0x3e, 0x73, 0x6f,
    0x3e, 0x73, 0x73, 0x3e, 0x73, 0x74, 0x3e, 0x74, 0x30, 0x3e, 0x74, 0x31,
    0x3e, 0x74, 0x32, 0x3e, 0x74, 0x61, 0x3e, 0x74, 0x63, 0x3e, 0x74, 0x65,
    0x3e, 0x74, 0x69, 0x3e, 0x74, 0x6f, 0x3e, 0x74, 0x73, 0x3e, 0x74, 0x74,
    0x3e, 0x20, 0x3e, 0x25, 0x3e, 0x2d, 0x3e, 0x2e};
const uint8_t HuffDecoderCommon::table19_95_emit_[46] = {
    0x3e, 0x55, 0x3e, 0x56, 0x3e, 0x57, 0x3e, 0x59, 0x3e, 0x6a, 0x3e, 0x6b,
    0x3e, 0x71, 0x3e, 0x76, 0x3e, 0x77, 0x3e, 0x78, 0x3e, 0x79, 0x3e, 0x7a,
    0x3e, 0x26, 0x3e, 0x2a, 0x3e, 0x2c, 0x3e, 0x3b, 0x3e, 0x58, 0x3e, 0x5a,
    0x3e, 0x21, 0x3e, 0x22, 0x3e, 0x28, 0x3e, 0x29, 0x3e, 0x3f};
const uint16_t HuffDecoderCommon::table19_97_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0062,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0082, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x00b2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x00c2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x00d2};
const uint16_t HuffDecoderCommon::table19_98_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0092, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00b2, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x00c2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x00d2, 0x0000, 0x0000, 0x0000, 0x00e2, 0x0000,
    0x0000, 0x0000, 0x00f2, 0x0000, 0x0000, 0x0000, 0x0102, 0x0000, 0x0000,
    0x0000, 0x0112};
const uint16_t HuffDecoderCommon::table19_99_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000,
    0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0062, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000,
    0x0000, 0x0000, 0x00b2, 0x0000, 0x0000, 0x0000, 0x00c2, 0x0000, 0x0000,
    0x0000, 0x00d2, 0x0000, 0x0000, 0x0000, 0x00e2, 0x0000, 0x0000, 0x0000,
    0x00f2, 0x0000, 0x0000, 0x0000, 0x0102, 0x0000, 0x0000, 0x0000, 0x0112,
    0x0000, 0x0000, 0x0000, 0x0122, 0x0000, 0x0000, 0x0000, 0x0132, 0x0000,
    0x0000, 0x0000, 0x0142, 0x0000, 0x0000, 0x0000, 0x0152, 0x0000, 0x0000,
    0x0000, 0x0162, 0x0000, 0x0000, 0x0000, 0x0172, 0x0000, 0x0000, 0x0000,
    0x0182, 0x0000, 0x0000, 0x0000, 0x0192, 0x0000, 0x0000, 0x0000, 0x01a2,
    0x0000, 0x0000, 0x0000, 0x01b2, 0x0000, 0x01c2, 0x0000, 0x01d2, 0x0000,
    0x01e2, 0x0000, 0x01f2, 0x0000, 0x0202, 0x0000, 0x0212, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint16_t HuffDecoderCommon::table19_120_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0092, 0x0000,
    0x0000, 0x0000, 0x00a2, 0x0000, 0x0000, 0x0000, 0x00b2, 0x0000, 0x0000,
    0x0000, 0x00c2, 0x0000, 0x0000, 0x0000, 0x00d2, 0x0000, 0x0000, 0x0000,
    0x00e2, 0x0000, 0x0000, 0x0000, 0x00f2, 0x0000, 0x0000, 0x0000, 0x0102,
    0x0000, 0x0000, 0x0000, 0x0112, 0x0000, 0x0000, 0x0000, 0x0122, 0x0000,
    0x0000, 0x0000, 0x0132, 0x0000, 0x0000, 0x0000, 0x0142, 0x0000, 0x0000,
    0x0000, 0x0152};
const uint8_t HuffDecoderCommon::table19_121_emit_[104] = {
    0x5e, 0x3d, 0x5e, 0x41, 0x5e, 0x5f, 0x5e, 0x62, 0x5e, 0x64, 0x5e, 0x66,
    0x5e, 0x67, 0x5e, 0x68, 0x5e, 0x6c, 0x5e, 0x6d, 0x5e, 0x6e, 0x5e, 0x70,
    0x5e, 0x72, 0x5e, 0x75, 0x5e, 0x3a, 0x5e, 0x42, 0x5e, 0x43, 0x5e, 0x44,
    0x5e, 0x45, 0x5e, 0x46, 0x5e, 0x47, 0x5e, 0x48, 0x5e, 0x49, 0x5e, 0x4a,
    0x5e, 0x4b, 0x5e, 0x4c, 0x5e, 0x4d, 0x5e, 0x4e, 0x5e, 0x4f, 0x5e, 0x50,
    0x5e, 0x51, 0x5e, 0x52, 0x5e, 0x53, 0x5e, 0x54, 0x5e, 0x55, 0x5e, 0x56,
    0x5e, 0x57, 0x5e, 0x59, 0x5e, 0x6a, 0x5e, 0x6b, 0x5e, 0x71, 0x5e, 0x76,
    0x5e, 0x77, 0x5e, 0x78, 0x5e, 0x79, 0x5e, 0x7a, 0x5e, 0x26, 0x5e, 0x2a,
    0x5e, 0x2c, 0x5e, 0x3b, 0x5e, 0x58, 0x5e, 0x5a};
const uint16_t HuffDecoderCommon::table19_121_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000,
    0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0062, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000,
    0x0000, 0x0000, 0x00b2, 0x0000, 0x0000, 0x0000, 0x00c2, 0x0000, 0x0000,
    0x0000, 0x00d2, 0x0000, 0x00e2, 0x0000, 0x00f2, 0x0000, 0x0102, 0x0000,
    0x0112, 0x0000, 0x0122, 0x0000, 0x0132, 0x0000, 0x0142, 0x0000, 0x0152,
    0x0000, 0x0162, 0x0000, 0x0172, 0x0000, 0x0182, 0x0000, 0x0192, 0x0000,
    0x01a2, 0x0000, 0x01b2, 0x0000, 0x01c2, 0x0000, 0x01d2, 0x0000, 0x01e2,
    0x0000, 0x01f2, 0x0000, 0x0202, 0x0000, 0x0212, 0x0000, 0x0222, 0x0000,
    0x0232, 0x0000, 0x0242, 0x0000, 0x0252, 0x0000, 0x0262, 0x0000, 0x0272,
    0x0000, 0x0282, 0x0000, 0x0292, 0x0000, 0x02a2, 0x0000, 0x02b2, 0x0000,
    0x02c2, 0x0000, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table19_123_emit_[104] = {
    0x7d, 0x3d, 0x7d, 0x41, 0x7d, 0x5f, 0x7d, 0x62, 0x7d, 0x64, 0x7d, 0x66,
    0x7d, 0x67, 0x7d, 0x68, 0x7d, 0x6c, 0x7d, 0x6d, 0x7d, 0x6e, 0x7d, 0x70,
    0x7d, 0x72, 0x7d, 0x75, 0x7d, 0x3a, 0x7d, 0x42, 0x7d, 0x43, 0x7d, 0x44,
    0x7d, 0x45, 0x7d, 0x46, 0x7d, 0x47, 0x7d, 0x48, 0x7d, 0x49, 0x7d, 0x4a,
    0x7d, 0x4b, 0x7d, 0x4c, 0x7d, 0x4d, 0x7d, 0x4e, 0x7d, 0x4f, 0x7d, 0x50,
    0x7d, 0x51, 0x7d, 0x52, 0x7d, 0x53, 0x7d, 0x54, 0x7d, 0x55, 0x7d, 0x56,
    0x7d, 0x57, 0x7d, 0x59, 0x7d, 0x6a, 0x7d, 0x6b, 0x7d, 0x71, 0x7d, 0x76,
    0x7d, 0x77, 0x7d, 0x78, 0x7d, 0x79, 0x7d, 0x7a, 0x7d, 0x26, 0x7d, 0x2a,
    0x7d, 0x2c, 0x7d, 0x3b, 0x7d, 0x58, 0x7d, 0x5a};
const uint8_t HuffDecoderCommon::table19_124_emit_[136] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63, 0x3c, 0x65,
    0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74, 0x3c, 0x20, 0x3c, 0x25,
    0x3c, 0x2d, 0x3c, 0x2e, 0x3c, 0x2f, 0x3c, 0x33, 0x3c, 0x34, 0x3c, 0x35,
    0x3c, 0x36, 0x3c, 0x37, 0x3c, 0x38, 0x3c, 0x39, 0x3c, 0x3d, 0x3c, 0x41,
    0x3c, 0x5f, 0x3c, 0x62, 0x3c, 0x64, 0x3c, 0x66, 0x3c, 0x67, 0x3c, 0x68,
    0x3c, 0x6c, 0x3c, 0x6d, 0x3c, 0x6e, 0x3c, 0x70, 0x3c, 0x72, 0x3c, 0x75,
    0x3c, 0x3a, 0x3c, 0x42, 0x3c, 0x43, 0x3c, 0x44, 0x3c, 0x45, 0x3c, 0x46,
    0x3c, 0x47, 0x3c, 0x48, 0x3c, 0x49, 0x3c, 0x4a, 0x3c, 0x4b, 0x3c, 0x4c,
    0x3c, 0x4d, 0x3c, 0x4e, 0x3c, 0x4f, 0x3c, 0x50, 0x3c, 0x51, 0x3c, 0x52,
    0x3c, 0x53, 0x3c, 0x54, 0x3c, 0x55, 0x3c, 0x56, 0x3c, 0x57, 0x3c, 0x59,
    0x3c, 0x6a, 0x3c, 0x6b, 0x3c, 0x71, 0x3c, 0x76, 0x3c, 0x77, 0x3c, 0x78,
    0x3c, 0x79, 0x3c, 0x7a};
const uint16_t HuffDecoderCommon::table19_124_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000,
    0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0062, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x00a2, 0x0000, 0x00b2, 0x0000,
    0x00c2, 0x0000, 0x00d2, 0x0000, 0x00e2, 0x0000, 0x00f2, 0x0000, 0x0102,
    0x0000, 0x0112, 0x0000, 0x0122, 0x0000, 0x0132, 0x0000, 0x0142, 0x0000,
    0x0152, 0x0000, 0x0162, 0x0000, 0x0172, 0x0000, 0x0182, 0x0000, 0x0192,
    0x0000, 0x01a2, 0x0000, 0x01b2, 0x0000, 0x01c2, 0x0000, 0x01d2, 0x0000,
    0x01e2, 0x0000, 0x01f2, 0x0000, 0x0202, 0x0000, 0x0212, 0x0000, 0x0222,
    0x0000, 0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2,
    0x02b2, 0x02c2, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332,
    0x0342, 0x0352, 0x0362, 0x0372, 0x0382, 0x0392, 0x03a2, 0x03b2, 0x03c2,
    0x03d2, 0x03e2, 0x03f2, 0x0402, 0x0412, 0x0422, 0x0432, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table19_125_emit_[136] = {
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63, 0x60, 0x65,
    0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74, 0x60, 0x20, 0x60, 0x25,
    0x60, 0x2d, 0x60, 0x2e, 0x60, 0x2f, 0x60, 0x33, 0x60, 0x34, 0x60, 0x35,
    0x60, 0x36, 0x60, 0x37, 0x60, 0x38, 0x60, 0x39, 0x60, 0x3d, 0x60, 0x41,
    0x60, 0x5f, 0x60, 0x62, 0x60, 0x64, 0x60, 0x66, 0x60, 0x67, 0x60, 0x68,
    0x60, 0x6c, 0x60, 0x6d, 0x60, 0x6e, 0x60, 0x70, 0x60, 0x72, 0x60, 0x75,
    0x60, 0x3a, 0x60, 0x42, 0x60, 0x43, 0x60, 0x44, 0x60, 0x45, 0x60, 0x46,
    0x60, 0x47, 0x60, 0x48, 0x60, 0x49, 0x60, 0x4a, 0x60, 0x4b, 0x60, 0x4c,
    0x60, 0x4d, 0x60, 0x4e, 0x60, 0x4f, 0x60, 0x50, 0x60, 0x51, 0x60, 0x52,
    0x60, 0x53, 0x60, 0x54, 0x60, 0x55, 0x60, 0x56, 0x60, 0x57, 0x60, 0x59,
    0x60, 0x6a, 0x60, 0x6b, 0x60, 0x71, 0x60, 0x76, 0x60, 0x77, 0x60, 0x78,
    0x60, 0x79, 0x60, 0x7a};
const uint8_t HuffDecoderCommon::table19_126_emit_[136] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b, 0x65,
    0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x7b, 0x20, 0x7b, 0x25,
    0x7b, 0x2d, 0x7b, 0x2e, 0x7b, 0x2f, 0x7b, 0x33, 0x7b, 0x34, 0x7b, 0x35,
    0x7b, 0x36, 0x7b, 0x37, 0x7b, 0x38, 0x7b, 0x39, 0x7b, 0x3d, 0x7b, 0x41,
    0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64, 0x7b, 0x66, 0x7b, 0x67, 0x7b, 0x68,
    0x7b, 0x6c, 0x7b, 0x6d, 0x7b, 0x6e, 0x7b, 0x70, 0x7b, 0x72, 0x7b, 0x75,
    0x7b, 0x3a, 0x7b, 0x42, 0x7b, 0x43, 0x7b, 0x44, 0x7b, 0x45, 0x7b, 0x46,
    0x7b, 0x47, 0x7b, 0x48, 0x7b, 0x49, 0x7b, 0x4a, 0x7b, 0x4b, 0x7b, 0x4c,
    0x7b, 0x4d, 0x7b, 0x4e, 0x7b, 0x4f, 0x7b, 0x50, 0x7b, 0x51, 0x7b, 0x52,
    0x7b, 0x53, 0x7b, 0x54, 0x7b, 0x55, 0x7b, 0x56, 0x7b, 0x57, 0x7b, 0x59,
    0x7b, 0x6a, 0x7b, 0x6b, 0x7b, 0x71, 0x7b, 0x76, 0x7b, 0x77, 0x7b, 0x78,
    0x7b, 0x79, 0x7b, 0x7a};
const uint8_t HuffDecoderCommon::table19_127_emit_[50] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0,
    0xe2, 0x99, 0xa1, 0xa7, 0xac, 0xb0, 0xb1, 0xb3, 0xd1, 0xd8,
    0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84, 0x85, 0x86, 0x88, 0x92,
    0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa, 0xad, 0xb2, 0xb5,
    0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8, 0xe9};
const uint16_t HuffDecoderCommon::table19_127_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0013, 0x0000, 0x0000, 0x0000,
    0x001b, 0x0000, 0x0000, 0x0000, 0x0023, 0x0000, 0x0000, 0x0000, 0x002b,
    0x0000, 0x0000, 0x0000, 0x0033, 0x0000, 0x0000, 0x0000, 0x003b, 0x0000,
    0x0000, 0x0000, 0x0043, 0x0000, 0x0000, 0x0000, 0x004b, 0x0000, 0x0000,
    0x0000, 0x0053, 0x0000, 0x005b, 0x0000, 0x0063, 0x0000, 0x006b, 0x0000,
    0x0073, 0x0000, 0x007b, 0x0000, 0x0083, 0x0000, 0x008b, 0x0000, 0x0093,
    0x0000, 0x009b, 0x0000, 0x00a3, 0x0000, 0x00ab, 0x0000, 0x00b3, 0x0000,
    0x00bb, 0x00c3, 0x00cb, 0x00d3, 0x00db, 0x00e3, 0x00eb, 0x00f3, 0x00fb,
    0x0103, 0x010b, 0x0113, 0x011b, 0x0123, 0x012b, 0x0133, 0x013b, 0x0143,
    0x014b, 0x0153, 0x015b, 0x0163, 0x016b, 0x0173, 0x017b, 0x0183, 0x018b,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0004};
const uint8_t* const HuffDecoderCommon::table19_emit_[128] = {
    table19_0_emit_,   table19_1_emit_,   table19_2_emit_,   table19_3_emit_,
    table19_4_emit_,   table19_5_emit_,   table19_6_emit_,   table19_7_emit_,
    table19_8_emit_,   table19_9_emit_,   table19_10_emit_,  table19_11_emit_,
    table19_12_emit_,  table19_13_emit_,  table19_14_emit_,  table19_15_emit_,
    table19_16_emit_,  table19_17_emit_,  table19_18_emit_,  table19_19_emit_,
    table19_20_emit_,  table19_21_emit_,  table19_22_emit_,  table19_23_emit_,
    table19_24_emit_,  table19_25_emit_,  table19_26_emit_,  table19_27_emit_,
    table19_28_emit_,  table19_29_emit_,  table19_30_emit_,  table19_31_emit_,
    table19_32_emit_,  table19_33_emit_,  table19_34_emit_,  table19_35_emit_,
    table19_36_emit_,  table19_37_emit_,  table19_38_emit_,  table19_39_emit_,
    table19_40_emit_,  table19_41_emit_,  table19_42_emit_,  table19_43_emit_,
    table18_44_emit_,  table18_45_emit_,  table18_46_emit_,  table19_47_emit_,
    table19_48_emit_,  table19_49_emit_,  table19_50_emit_,  table19_51_emit_,
    table19_52_emit_,  table19_53_emit_,  table19_54_emit_,  table19_55_emit_,
    table19_56_emit_,  table19_57_emit_,  table19_58_emit_,  table19_59_emit_,
    table18_60_emit_,  table18_61_emit_,  table18_62_emit_,  table19_63_emit_,
    table19_64_emit_,  table19_65_emit_,  table19_66_emit_,  table19_67_emit_,
    table19_68_emit_,  table19_69_emit_,  table19_70_emit_,  table19_71_emit_,
    table19_72_emit_,  table19_73_emit_,  table19_74_emit_,  table19_75_emit_,
    table18_76_emit_,  table18_77_emit_,  table18_78_emit_,  table19_79_emit_,
    table19_80_emit_,  table19_81_emit_,  table19_82_emit_,  table18_83_emit_,
    table18_84_emit_,  table18_85_emit_,  table18_86_emit_,  table19_87_emit_,
    table19_88_emit_,  table19_89_emit_,  table19_90_emit_,  table18_91_emit_,
    table18_92_emit_,  table18_93_emit_,  table18_94_emit_,  table19_95_emit_,
    table18_96_emit_,  table18_97_emit_,  table18_98_emit_,  table18_99_emit_,
    table18_100_emit_, table18_101_emit_, table18_102_emit_, table18_103_emit_,
    table18_104_emit_, table18_105_emit_, table18_106_emit_, table18_107_emit_,
    table18_108_emit_, table18_109_emit_, table18_110_emit_, table18_111_emit_,
    table18_112_emit_, table18_113_emit_, table18_114_emit_, table18_115_emit_,
    table18_116_emit_, table18_117_emit_, table18_118_emit_, table18_119_emit_,
    table18_120_emit_, table19_121_emit_, table18_122_emit_, table19_123_emit_,
    table19_124_emit_, table19_125_emit_, table19_126_emit_, table19_127_emit_,
};
const uint16_t* const HuffDecoderCommon::table19_ops_[128] = {
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_23_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_23_ops_,  table19_23_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_23_ops_,  table19_31_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_23_ops_,  table19_23_ops_,  table19_23_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_23_ops_,  table19_43_ops_,
    table19_44_ops_,  table19_44_ops_,  table19_44_ops_,  table19_47_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_23_ops_,  table19_23_ops_,  table19_23_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_23_ops_,  table19_43_ops_,
    table19_44_ops_,  table19_44_ops_,  table19_44_ops_,  table19_63_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_23_ops_,  table19_23_ops_,  table19_23_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_23_ops_,  table19_43_ops_,
    table19_44_ops_,  table19_44_ops_,  table19_44_ops_,  table19_79_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_43_ops_,  table19_44_ops_,
    table19_44_ops_,  table19_85_ops_,  table19_86_ops_,  table19_87_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_43_ops_,  table19_44_ops_,
    table19_44_ops_,  table19_85_ops_,  table19_86_ops_,  table19_87_ops_,
    table19_44_ops_,  table19_97_ops_,  table19_98_ops_,  table19_99_ops_,
    table19_44_ops_,  table19_97_ops_,  table19_98_ops_,  table19_99_ops_,
    table19_44_ops_,  table19_97_ops_,  table19_98_ops_,  table19_99_ops_,
    table19_44_ops_,  table19_97_ops_,  table19_98_ops_,  table19_99_ops_,
    table19_44_ops_,  table19_97_ops_,  table19_98_ops_,  table19_99_ops_,
    table19_44_ops_,  table19_97_ops_,  table19_98_ops_,  table19_99_ops_,
    table19_120_ops_, table19_121_ops_, table19_120_ops_, table19_121_ops_,
    table19_124_ops_, table19_124_ops_, table19_124_ops_, table19_127_ops_,
};
const uint8_t HuffDecoderCommon::table20_0_emit_[66] = {
    0x3f, 0x30, 0x30, 0x3f, 0x30, 0x31, 0x3f, 0x30, 0x32, 0x3f, 0x30,
    0x61, 0x3f, 0x30, 0x63, 0x3f, 0x30, 0x65, 0x3f, 0x30, 0x69, 0x3f,
    0x30, 0x6f, 0x3f, 0x30, 0x73, 0x3f, 0x30, 0x74, 0x3f, 0x30, 0x20,
    0x3f, 0x30, 0x25, 0x3f, 0x30, 0x2d, 0x3f, 0x30, 0x2e, 0x3f, 0x30,
    0x2f, 0x3f, 0x30, 0x33, 0x3f, 0x30, 0x34, 0x3f, 0x30, 0x35, 0x3f,
    0x30, 0x36, 0x3f, 0x30, 0x37, 0x3f, 0x30, 0x38, 0x3f, 0x30, 0x39};
const uint16_t HuffDecoderCommon::table20_0_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0091, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x00a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c1,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00d9, 0x0000,
    0x0000, 0x0000, 0x00f1, 0x0000, 0x0000, 0x0000, 0x0109, 0x0000, 0x0000,
    0x0000, 0x0121, 0x0000, 0x0000, 0x0000, 0x0139, 0x0000, 0x0000, 0x0000,
    0x0151, 0x0000, 0x0000, 0x0000, 0x0169, 0x0000, 0x0000, 0x0000, 0x0181,
    0x0000, 0x0000, 0x0000, 0x0199, 0x0000, 0x0000, 0x0000, 0x01b1, 0x0000,
    0x0000, 0x0000, 0x01c9, 0x0000, 0x0000, 0x0000, 0x01e1, 0x0000, 0x0000,
    0x0000, 0x01f9};
const uint8_t HuffDecoderCommon::table20_1_emit_[156] = {
    0x3f, 0x30, 0x3d, 0x3f, 0x30, 0x41, 0x3f, 0x30, 0x5f, 0x3f, 0x30, 0x62,
    0x3f, 0x30, 0x64, 0x3f, 0x30, 0x66, 0x3f, 0x30, 0x67, 0x3f, 0x30, 0x68,
    0x3f, 0x30, 0x6c, 0x3f, 0x30, 0x6d, 0x3f, 0x30, 0x6e, 0x3f, 0x30, 0x70,
    0x3f, 0x30, 0x72, 0x3f, 0x30, 0x75, 0x3f, 0x30, 0x3a, 0x3f, 0x30, 0x42,
    0x3f, 0x30, 0x43, 0x3f, 0x30, 0x44, 0x3f, 0x30, 0x45, 0x3f, 0x30, 0x46,
    0x3f, 0x30, 0x47, 0x3f, 0x30, 0x48, 0x3f, 0x30, 0x49, 0x3f, 0x30, 0x4a,
    0x3f, 0x30, 0x4b, 0x3f, 0x30, 0x4c, 0x3f, 0x30, 0x4d, 0x3f, 0x30, 0x4e,
    0x3f, 0x30, 0x4f, 0x3f, 0x30, 0x50, 0x3f, 0x30, 0x51, 0x3f, 0x30, 0x52,
    0x3f, 0x30, 0x53, 0x3f, 0x30, 0x54, 0x3f, 0x30, 0x55, 0x3f, 0x30, 0x56,
    0x3f, 0x30, 0x57, 0x3f, 0x30, 0x59, 0x3f, 0x30, 0x6a, 0x3f, 0x30, 0x6b,
    0x3f, 0x30, 0x71, 0x3f, 0x30, 0x76, 0x3f, 0x30, 0x77, 0x3f, 0x30, 0x78,
    0x3f, 0x30, 0x79, 0x3f, 0x30, 0x7a, 0x3f, 0x30, 0x26, 0x3f, 0x30, 0x2a,
    0x3f, 0x30, 0x2c, 0x3f, 0x30, 0x3b, 0x3f, 0x30, 0x58, 0x3f, 0x30, 0x5a};
const uint16_t HuffDecoderCommon::table20_1_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000,
    0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0000,
    0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0079, 0x0000, 0x0000, 0x0000,
    0x0091, 0x0000, 0x0000, 0x0000, 0x00a9, 0x0000, 0x0000, 0x0000, 0x00c1,
    0x0000, 0x0000, 0x0000, 0x00d9, 0x0000, 0x0000, 0x0000, 0x00f1, 0x0000,
    0x0000, 0x0000, 0x0109, 0x0000, 0x0000, 0x0000, 0x0121, 0x0000, 0x0000,
    0x0000, 0x0139, 0x0000, 0x0151, 0x0000, 0x0169, 0x0000, 0x0181, 0x0000,
    0x0199, 0x0000, 0x01b1, 0x0000, 0x01c9, 0x0000, 0x01e1, 0x0000, 0x01f9,
    0x0000, 0x0211, 0x0000, 0x0229, 0x0000, 0x0241, 0x0000, 0x0259, 0x0000,
    0x0271, 0x0000, 0x0289, 0x0000, 0x02a1, 0x0000, 0x02b9, 0x0000, 0x02d1,
    0x0000, 0x02e9, 0x0000, 0x0301, 0x0000, 0x0319, 0x0000, 0x0331, 0x0000,
    0x0349, 0x0000, 0x0361, 0x0000, 0x0379, 0x0000, 0x0391, 0x0000, 0x03a9,
    0x0000, 0x03c1, 0x0000, 0x03d9, 0x0000, 0x03f1, 0x0000, 0x0409, 0x0000,
    0x0421, 0x0000, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9,
    0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table20_2_emit_[66] = {
    0x3f, 0x31, 0x30, 0x3f, 0x31, 0x31, 0x3f, 0x31, 0x32, 0x3f, 0x31,
    0x61, 0x3f, 0x31, 0x63, 0x3f, 0x31, 0x65, 0x3f, 0x31, 0x69, 0x3f,
    0x31, 0x6f, 0x3f, 0x31, 0x73, 0x3f, 0x31, 0x74, 0x3f, 0x31, 0x20,
    0x3f, 0x31, 0x25, 0x3f, 0x31, 0x2d, 0x3f, 0x31, 0x2e, 0x3f, 0x31,
    0x2f, 0x3f, 0x31, 0x33, 0x3f, 0x31, 0x34, 0x3f, 0x31, 0x35, 0x3f,
    0x31, 0x36, 0x3f, 0x31, 0x37, 0x3f, 0x31, 0x38, 0x3f, 0x31, 0x39};
const uint8_t HuffDecoderCommon::table20_3_emit_[156] = {
    0x3f, 0x31, 0x3d, 0x3f, 0x31, 0x41, 0x3f, 0x31, 0x5f, 0x3f, 0x31, 0x62,
    0x3f, 0x31, 0x64, 0x3f, 0x31, 0x66, 0x3f, 0x31, 0x67, 0x3f, 0x31, 0x68,
    0x3f, 0x31, 0x6c, 0x3f, 0x31, 0x6d, 0x3f, 0x31, 0x6e, 0x3f, 0x31, 0x70,
    0x3f, 0x31, 0x72, 0x3f, 0x31, 0x75, 0x3f, 0x31, 0x3a, 0x3f, 0x31, 0x42,
    0x3f, 0x31, 0x43, 0x3f, 0x31, 0x44, 0x3f, 0x31, 0x45, 0x3f, 0x31, 0x46,
    0x3f, 0x31, 0x47, 0x3f, 0x31, 0x48, 0x3f, 0x31, 0x49, 0x3f, 0x31, 0x4a,
    0x3f, 0x31, 0x4b, 0x3f, 0x31, 0x4c, 0x3f, 0x31, 0x4d, 0x3f, 0x31, 0x4e,
    0x3f, 0x31, 0x4f, 0x3f, 0x31, 0x50, 0x3f, 0x31, 0x51, 0x3f, 0x31, 0x52,
    0x3f, 0x31, 0x53, 0x3f, 0x31, 0x54, 0x3f, 0x31, 0x55, 0x3f, 0x31, 0x56,
    0x3f, 0x31, 0x57, 0x3f, 0x31, 0x59, 0x3f, 0x31, 0x6a, 0x3f, 0x31, 0x6b,
    0x3f, 0x31, 0x71, 0x3f, 0x31, 0x76, 0x3f, 0x31, 0x77, 0x3f, 0x31, 0x78,
    0x3f, 0x31, 0x79, 0x3f, 0x31, 0x7a, 0x3f, 0x31, 0x26, 0x3f, 0x31, 0x2a,
    0x3f, 0x31, 0x2c, 0x3f, 0x31, 0x3b, 0x3f, 0x31, 0x58, 0x3f, 0x31, 0x5a};
const uint8_t HuffDecoderCommon::table20_4_emit_[66] = {
    0x3f, 0x32, 0x30, 0x3f, 0x32, 0x31, 0x3f, 0x32, 0x32, 0x3f, 0x32,
    0x61, 0x3f, 0x32, 0x63, 0x3f, 0x32, 0x65, 0x3f, 0x32, 0x69, 0x3f,
    0x32, 0x6f, 0x3f, 0x32, 0x73, 0x3f, 0x32, 0x74, 0x3f, 0x32, 0x20,
    0x3f, 0x32, 0x25, 0x3f, 0x32, 0x2d, 0x3f, 0x32, 0x2e, 0x3f, 0x32,
    0x2f, 0x3f, 0x32, 0x33, 0x3f, 0x32, 0x34, 0x3f, 0x32, 0x35, 0x3f,
    0x32, 0x36, 0x3f, 0x32, 0x37, 0x3f, 0x32, 0x38, 0x3f, 0x32, 0x39};
const uint8_t HuffDecoderCommon::table20_5_emit_[156] = {
    0x3f, 0x32, 0x3d, 0x3f, 0x32, 0x41, 0x3f, 0x32, 0x5f, 0x3f, 0x32, 0x62,
    0x3f, 0x32, 0x64, 0x3f, 0x32, 0x66, 0x3f, 0x32, 0x67, 0x3f, 0x32, 0x68,
    0x3f, 0x32, 0x6c, 0x3f, 0x32, 0x6d, 0x3f, 0x32, 0x6e, 0x3f, 0x32, 0x70,
    0x3f, 0x32, 0x72, 0x3f, 0x32, 0x75, 0x3f, 0x32, 0x3a, 0x3f, 0x32, 0x42,
    0x3f, 0x32, 0x43, 0x3f, 0x32, 0x44, 0x3f, 0x32, 0x45, 0x3f, 0x32, 0x46,
    0x3f, 0x32, 0x47, 0x3f, 0x32, 0x48, 0x3f, 0x32, 0x49, 0x3f, 0x32, 0x4a,
    0x3f, 0x32, 0x4b, 0x3f, 0x32, 0x4c, 0x3f, 0x32, 0x4d, 0x3f, 0x32, 0x4e,
    0x3f, 0x32, 0x4f, 0x3f, 0x32, 0x50, 0x3f, 0x32, 0x51, 0x3f, 0x32, 0x52,
    0x3f, 0x32, 0x53, 0x3f, 0x32, 0x54, 0x3f, 0x32, 0x55, 0x3f, 0x32, 0x56,
    0x3f, 0x32, 0x57, 0x3f, 0x32, 0x59, 0x3f, 0x32, 0x6a, 0x3f, 0x32, 0x6b,
    0x3f, 0x32, 0x71, 0x3f, 0x32, 0x76, 0x3f, 0x32, 0x77, 0x3f, 0x32, 0x78,
    0x3f, 0x32, 0x79, 0x3f, 0x32, 0x7a, 0x3f, 0x32, 0x26, 0x3f, 0x32, 0x2a,
    0x3f, 0x32, 0x2c, 0x3f, 0x32, 0x3b, 0x3f, 0x32, 0x58, 0x3f, 0x32, 0x5a};
const uint8_t HuffDecoderCommon::table20_6_emit_[66] = {
    0x3f, 0x61, 0x30, 0x3f, 0x61, 0x31, 0x3f, 0x61, 0x32, 0x3f, 0x61,
    0x61, 0x3f, 0x61, 0x63, 0x3f, 0x61, 0x65, 0x3f, 0x61, 0x69, 0x3f,
    0x61, 0x6f, 0x3f, 0x61, 0x73, 0x3f, 0x61, 0x74, 0x3f, 0x61, 0x20,
    0x3f, 0x61, 0x25, 0x3f, 0x61, 0x2d, 0x3f, 0x61, 0x2e, 0x3f, 0x61,
    0x2f, 0x3f, 0x61, 0x33, 0x3f, 0x61, 0x34, 0x3f, 0x61, 0x35, 0x3f,
    0x61, 0x36, 0x3f, 0x61, 0x37, 0x3f, 0x61, 0x38, 0x3f, 0x61, 0x39};
const uint8_t HuffDecoderCommon::table20_7_emit_[156] = {
    0x3f, 0x61, 0x3d, 0x3f, 0x61, 0x41, 0x3f, 0x61, 0x5f, 0x3f, 0x61, 0x62,
    0x3f, 0x61, 0x64, 0x3f, 0x61, 0x66, 0x3f, 0x61, 0x67, 0x3f, 0x61, 0x68,
    0x3f, 0x61, 0x6c, 0x3f, 0x61, 0x6d, 0x3f, 0x61, 0x6e, 0x3f, 0x61, 0x70,
    0x3f, 0x61, 0x72, 0x3f, 0x61, 0x75, 0x3f, 0x61, 0x3a, 0x3f, 0x61, 0x42,
    0x3f, 0x61, 0x43, 0x3f, 0x61, 0x44, 0x3f, 0x61, 0x45, 0x3f, 0x61, 0x46,
    0x3f, 0x61, 0x47, 0x3f, 0x61, 0x48, 0x3f, 0x61, 0x49, 0x3f, 0x61, 0x4a,
    0x3f, 0x61, 0x4b, 0x3f, 0x61, 0x4c, 0x3f, 0x61, 0x4d, 0x3f, 0x61, 0x4e,
    0x3f, 0x61, 0x4f, 0x3f, 0x61, 0x50, 0x3f, 0x61, 0x51, 0x3f, 0x61, 0x52,
    0x3f, 0x61, 0x53, 0x3f, 0x61, 0x54, 0x3f, 0x61, 0x55, 0x3f, 0x61, 0x56,
    0x3f, 0x61, 0x57, 0x3f, 0x61, 0x59, 0x3f, 0x61, 0x6a, 0x3f, 0x61, 0x6b,
    0x3f, 0x61, 0x71, 0x3f, 0x61, 0x76, 0x3f, 0x61, 0x77, 0x3f, 0x61, 0x78,
    0x3f, 0x61, 0x79, 0x3f, 0x61, 0x7a, 0x3f, 0x61, 0x26, 0x3f, 0x61, 0x2a,
    0x3f, 0x61, 0x2c, 0x3f, 0x61, 0x3b, 0x3f, 0x61, 0x58, 0x3f, 0x61, 0x5a};
const uint8_t HuffDecoderCommon::table20_8_emit_[66] = {
    0x3f, 0x63, 0x30, 0x3f, 0x63, 0x31, 0x3f, 0x63, 0x32, 0x3f, 0x63,
    0x61, 0x3f, 0x63, 0x63, 0x3f, 0x63, 0x65, 0x3f, 0x63, 0x69, 0x3f,
    0x63, 0x6f, 0x3f, 0x63, 0x73, 0x3f, 0x63, 0x74, 0x3f, 0x63, 0x20,
    0x3f, 0x63, 0x25, 0x3f, 0x63, 0x2d, 0x3f, 0x63, 0x2e, 0x3f, 0x63,
    0x2f, 0x3f, 0x63, 0x33, 0x3f, 0x63, 0x34, 0x3f, 0x63, 0x35, 0x3f,
    0x63, 0x36, 0x3f, 0x63, 0x37, 0x3f, 0x63, 0x38, 0x3f, 0x63, 0x39};
const uint8_t HuffDecoderCommon::table20_9_emit_[156] = {
    0x3f, 0x63, 0x3d, 0x3f, 0x63, 0x41, 0x3f, 0x63, 0x5f, 0x3f, 0x63, 0x62,
    0x3f, 0x63, 0x64, 0x3f, 0x63, 0x66, 0x3f, 0x63, 0x67, 0x3f, 0x63, 0x68,
    0x3f, 0x63, 0x6c, 0x3f, 0x63, 0x6d, 0x3f, 0x63, 0x6e, 0x3f, 0x63, 0x70,
    0x3f, 0x63, 0x72, 0x3f, 0x63, 0x75, 0x3f, 0x63, 0x3a, 0x3f, 0x63, 0x42,
    0x3f, 0x63, 0x43, 0x3f, 0x63, 0x44, 0x3f, 0x63, 0x45, 0x3f, 0x63, 0x46,
    0x3f, 0x63, 0x47, 0x3f, 0x63, 0x48, 0x3f, 0x63, 0x49, 0x3f, 0x63, 0x4a,
    0x3f, 0x63, 0x4b, 0x3f, 0x63, 0x4c, 0x3f, 0x63, 0x4d, 0x3f, 0x63, 0x4e,
    0x3f, 0x63, 0x4f, 0x3f, 0x63, 0x50, 0x3f, 0x63, 0x51, 0x3f, 0x63, 0x52,
    0x3f, 0x63, 0x53, 0x3f, 0x63, 0x54, 0x3f, 0x63, 0x55, 0x3f, 0x63, 0x56,
    0x3f, 0x63, 0x57, 0x3f, 0x63, 0x59, 0x3f, 0x63, 0x6a, 0x3f, 0x63, 0x6b,
    0x3f, 0x63, 0x71, 0x3f, 0x63, 0x76, 0x3f, 0x63, 0x77, 0x3f, 0x63, 0x78,
    0x3f, 0x63, 0x79, 0x3f, 0x63, 0x7a, 0x3f, 0x63, 0x26, 0x3f, 0x63, 0x2a,
    0x3f, 0x63, 0x2c, 0x3f, 0x63, 0x3b, 0x3f, 0x63, 0x58, 0x3f, 0x63, 0x5a};
const uint8_t HuffDecoderCommon::table20_10_emit_[66] = {
    0x3f, 0x65, 0x30, 0x3f, 0x65, 0x31, 0x3f, 0x65, 0x32, 0x3f, 0x65,
    0x61, 0x3f, 0x65, 0x63, 0x3f, 0x65, 0x65, 0x3f, 0x65, 0x69, 0x3f,
    0x65, 0x6f, 0x3f, 0x65, 0x73, 0x3f, 0x65, 0x74, 0x3f, 0x65, 0x20,
    0x3f, 0x65, 0x25, 0x3f, 0x65, 0x2d, 0x3f, 0x65, 0x2e, 0x3f, 0x65,
    0x2f, 0x3f, 0x65, 0x33, 0x3f, 0x65, 0x34, 0x3f, 0x65, 0x35, 0x3f,
    0x65, 0x36, 0x3f, 0x65, 0x37, 0x3f, 0x65, 0x38, 0x3f, 0x65, 0x39};
const uint8_t HuffDecoderCommon::table20_11_emit_[156] = {
    0x3f, 0x65, 0x3d, 0x3f, 0x65, 0x41, 0x3f, 0x65, 0x5f, 0x3f, 0x65, 0x62,
    0x3f, 0x65, 0x64, 0x3f, 0x65, 0x66, 0x3f, 0x65, 0x67, 0x3f, 0x65, 0x68,
    0x3f, 0x65, 0x6c, 0x3f, 0x65, 0x6d, 0x3f, 0x65, 0x6e, 0x3f, 0x65, 0x70,
    0x3f, 0x65, 0x72, 0x3f, 0x65, 0x75, 0x3f, 0x65, 0x3a, 0x3f, 0x65, 0x42,
    0x3f, 0x65, 0x43, 0x3f, 0x65, 0x44, 0x3f, 0x65, 0x45, 0x3f, 0x65, 0x46,
    0x3f, 0x65, 0x47, 0x3f, 0x65, 0x48, 0x3f, 0x65, 0x49, 0x3f, 0x65, 0x4a,
    0x3f, 0x65, 0x4b, 0x3f, 0x65, 0x4c, 0x3f, 0x65, 0x4d, 0x3f, 0x65, 0x4e,
    0x3f, 0x65, 0x4f, 0x3f, 0x65, 0x50, 0x3f, 0x65, 0x51, 0x3f, 0x65, 0x52,
    0x3f, 0x65, 0x53, 0x3f, 0x65, 0x54, 0x3f, 0x65, 0x55, 0x3f, 0x65, 0x56,
    0x3f, 0x65, 0x57, 0x3f, 0x65, 0x59, 0x3f, 0x65, 0x6a, 0x3f, 0x65, 0x6b,
    0x3f, 0x65, 0x71, 0x3f, 0x65, 0x76, 0x3f, 0x65, 0x77, 0x3f, 0x65, 0x78,
    0x3f, 0x65, 0x79, 0x3f, 0x65, 0x7a, 0x3f, 0x65, 0x26, 0x3f, 0x65, 0x2a,
    0x3f, 0x65, 0x2c, 0x3f, 0x65, 0x3b, 0x3f, 0x65, 0x58, 0x3f, 0x65, 0x5a};
const uint8_t HuffDecoderCommon::table20_12_emit_[66] = {
    0x3f, 0x69, 0x30, 0x3f, 0x69, 0x31, 0x3f, 0x69, 0x32, 0x3f, 0x69,
    0x61, 0x3f, 0x69, 0x63, 0x3f, 0x69, 0x65, 0x3f, 0x69, 0x69, 0x3f,
    0x69, 0x6f, 0x3f, 0x69, 0x73, 0x3f, 0x69, 0x74, 0x3f, 0x69, 0x20,
    0x3f, 0x69, 0x25, 0x3f, 0x69, 0x2d, 0x3f, 0x69, 0x2e, 0x3f, 0x69,
    0x2f, 0x3f, 0x69, 0x33, 0x3f, 0x69, 0x34, 0x3f, 0x69, 0x35, 0x3f,
    0x69, 0x36, 0x3f, 0x69, 0x37, 0x3f, 0x69, 0x38, 0x3f, 0x69, 0x39};
const uint8_t HuffDecoderCommon::table20_13_emit_[156] = {
    0x3f, 0x69, 0x3d, 0x3f, 0x69, 0x41, 0x3f, 0x69, 0x5f, 0x3f, 0x69, 0x62,
    0x3f, 0x69, 0x64, 0x3f, 0x69, 0x66, 0x3f, 0x69, 0x67, 0x3f, 0x69, 0x68,
    0x3f, 0x69, 0x6c, 0x3f, 0x69, 0x6d, 0x3f, 0x69, 0x6e, 0x3f, 0x69, 0x70,
    0x3f, 0x69, 0x72, 0x3f, 0x69, 0x75, 0x3f, 0x69, 0x3a, 0x3f, 0x69, 0x42,
    0x3f, 0x69, 0x43, 0x3f, 0x69, 0x44, 0x3f, 0x69, 0x45, 0x3f, 0x69, 0x46,
    0x3f, 0x69, 0x47, 0x3f, 0x69, 0x48, 0x3f, 0x69, 0x49, 0x3f, 0x69, 0x4a,
    0x3f, 0x69, 0x4b, 0x3f, 0x69, 0x4c, 0x3f, 0x69, 0x4d, 0x3f, 0x69, 0x4e,
    0x3f, 0x69, 0x4f, 0x3f, 0x69, 0x50, 0x3f, 0x69, 0x51, 0x3f, 0x69, 0x52,
    0x3f, 0x69, 0x53, 0x3f, 0x69, 0x54, 0x3f, 0x69, 0x55, 0x3f, 0x69, 0x56,
    0x3f, 0x69, 0x57, 0x3f, 0x69, 0x59, 0x3f, 0x69, 0x6a, 0x3f, 0x69, 0x6b,
    0x3f, 0x69, 0x71, 0x3f, 0x69, 0x76, 0x3f, 0x69, 0x77, 0x3f, 0x69, 0x78,
    0x3f, 0x69, 0x79, 0x3f, 0x69, 0x7a, 0x3f, 0x69, 0x26, 0x3f, 0x69, 0x2a,
    0x3f, 0x69, 0x2c, 0x3f, 0x69, 0x3b, 0x3f, 0x69, 0x58, 0x3f, 0x69, 0x5a};
const uint8_t HuffDecoderCommon::table20_14_emit_[66] = {
    0x3f, 0x6f, 0x30, 0x3f, 0x6f, 0x31, 0x3f, 0x6f, 0x32, 0x3f, 0x6f,
    0x61, 0x3f, 0x6f, 0x63, 0x3f, 0x6f, 0x65, 0x3f, 0x6f, 0x69, 0x3f,
    0x6f, 0x6f, 0x3f, 0x6f, 0x73, 0x3f, 0x6f, 0x74, 0x3f, 0x6f, 0x20,
    0x3f, 0x6f, 0x25, 0x3f, 0x6f, 0x2d, 0x3f, 0x6f, 0x2e, 0x3f, 0x6f,
    0x2f, 0x3f, 0x6f, 0x33, 0x3f, 0x6f, 0x34, 0x3f, 0x6f, 0x35, 0x3f,
    0x6f, 0x36, 0x3f, 0x6f, 0x37, 0x3f, 0x6f, 0x38, 0x3f, 0x6f, 0x39};
const uint8_t HuffDecoderCommon::table20_15_emit_[156] = {
    0x3f, 0x6f, 0x3d, 0x3f, 0x6f, 0x41, 0x3f, 0x6f, 0x5f, 0x3f, 0x6f, 0x62,
    0x3f, 0x6f, 0x64, 0x3f, 0x6f, 0x66, 0x3f, 0x6f, 0x67, 0x3f, 0x6f, 0x68,
    0x3f, 0x6f, 0x6c, 0x3f, 0x6f, 0x6d, 0x3f, 0x6f, 0x6e, 0x3f, 0x6f, 0x70,
    0x3f, 0x6f, 0x72, 0x3f, 0x6f, 0x75, 0x3f, 0x6f, 0x3a, 0x3f, 0x6f, 0x42,
    0x3f, 0x6f, 0x43, 0x3f, 0x6f, 0x44, 0x3f, 0x6f, 0x45, 0x3f, 0x6f, 0x46,
    0x3f, 0x6f, 0x47, 0x3f, 0x6f, 0x48, 0x3f, 0x6f, 0x49, 0x3f, 0x6f, 0x4a,
    0x3f, 0x6f, 0x4b, 0x3f, 0x6f, 0x4c, 0x3f, 0x6f, 0x4d, 0x3f, 0x6f, 0x4e,
    0x3f, 0x6f, 0x4f, 0x3f, 0x6f, 0x50, 0x3f, 0x6f, 0x51, 0x3f, 0x6f, 0x52,
    0x3f, 0x6f, 0x53, 0x3f, 0x6f, 0x54, 0x3f, 0x6f, 0x55, 0x3f, 0x6f, 0x56,
    0x3f, 0x6f, 0x57, 0x3f, 0x6f, 0x59, 0x3f, 0x6f, 0x6a, 0x3f, 0x6f, 0x6b,
    0x3f, 0x6f, 0x71, 0x3f, 0x6f, 0x76, 0x3f, 0x6f, 0x77, 0x3f, 0x6f, 0x78,
    0x3f, 0x6f, 0x79, 0x3f, 0x6f, 0x7a, 0x3f, 0x6f, 0x26, 0x3f, 0x6f, 0x2a,
    0x3f, 0x6f, 0x2c, 0x3f, 0x6f, 0x3b, 0x3f, 0x6f, 0x58, 0x3f, 0x6f, 0x5a};
const uint8_t HuffDecoderCommon::table20_16_emit_[66] = {
    0x3f, 0x73, 0x30, 0x3f, 0x73, 0x31, 0x3f, 0x73, 0x32, 0x3f, 0x73,
    0x61, 0x3f, 0x73, 0x63, 0x3f, 0x73, 0x65, 0x3f, 0x73, 0x69, 0x3f,
    0x73, 0x6f, 0x3f, 0x73, 0x73, 0x3f, 0x73, 0x74, 0x3f, 0x73, 0x20,
    0x3f, 0x73, 0x25, 0x3f, 0x73, 0x2d, 0x3f, 0x73, 0x2e, 0x3f, 0x73,
    0x2f, 0x3f, 0x73, 0x33, 0x3f, 0x73, 0x34, 0x3f, 0x73, 0x35, 0x3f,
    0x73, 0x36, 0x3f, 0x73, 0x37, 0x3f, 0x73, 0x38, 0x3f, 0x73, 0x39};
const uint8_t HuffDecoderCommon::table20_17_emit_[156] = {
    0x3f, 0x73, 0x3d, 0x3f, 0x73, 0x41, 0x3f, 0x73, 0x5f, 0x3f, 0x73, 0x62,
    0x3f, 0x73, 0x64, 0x3f, 0x73, 0x66, 0x3f, 0x73, 0x67, 0x3f, 0x73, 0x68,
    0x3f, 0x73, 0x6c, 0x3f, 0x73, 0x6d, 0x3f, 0x73, 0x6e, 0x3f, 0x73, 0x70,
    0x3f, 0x73, 0x72, 0x3f, 0x73, 0x75, 0x3f, 0x73, 0x3a, 0x3f, 0x73, 0x42,
    0x3f, 0x73, 0x43, 0x3f, 0x73, 0x44, 0x3f, 0x73, 0x45, 0x3f, 0x73, 0x46,
    0x3f, 0x73, 0x47, 0x3f, 0x73, 0x48, 0x3f, 0x73, 0x49, 0x3f, 0x73, 0x4a,
    0x3f, 0x73, 0x4b, 0x3f, 0x73, 0x4c, 0x3f, 0x73, 0x4d, 0x3f, 0x73, 0x4e,
    0x3f, 0x73, 0x4f, 0x3f, 0x73, 0x50, 0x3f, 0x73, 0x51, 0x3f, 0x73, 0x52,
    0x3f, 0x73, 0x53, 0x3f, 0x73, 0x54, 0x3f, 0x73, 0x55, 0x3f, 0x73, 0x56,
    0x3f, 0x73, 0x57, 0x3f, 0x73, 0x59, 0x3f, 0x73, 0x6a, 0x3f, 0x73, 0x6b,
    0x3f, 0x73, 0x71, 0x3f, 0x73, 0x76, 0x3f, 0x73, 0x77, 0x3f, 0x73, 0x78,
    0x3f, 0x73, 0x79, 0x3f, 0x73, 0x7a, 0x3f, 0x73, 0x26, 0x3f, 0x73, 0x2a,
    0x3f, 0x73, 0x2c, 0x3f, 0x73, 0x3b, 0x3f, 0x73, 0x58, 0x3f, 0x73, 0x5a};
const uint8_t HuffDecoderCommon::table20_18_emit_[66] = {
    0x3f, 0x74, 0x30, 0x3f, 0x74, 0x31, 0x3f, 0x74, 0x32, 0x3f, 0x74,
    0x61, 0x3f, 0x74, 0x63, 0x3f, 0x74, 0x65, 0x3f, 0x74, 0x69, 0x3f,
    0x74, 0x6f, 0x3f, 0x74, 0x73, 0x3f, 0x74, 0x74, 0x3f, 0x74, 0x20,
    0x3f, 0x74, 0x25, 0x3f, 0x74, 0x2d, 0x3f, 0x74, 0x2e, 0x3f, 0x74,
    0x2f, 0x3f, 0x74, 0x33, 0x3f, 0x74, 0x34, 0x3f, 0x74, 0x35, 0x3f,
    0x74, 0x36, 0x3f, 0x74, 0x37, 0x3f, 0x74, 0x38, 0x3f, 0x74, 0x39};
const uint8_t HuffDecoderCommon::table20_19_emit_[156] = {
    0x3f, 0x74, 0x3d, 0x3f, 0x74, 0x41, 0x3f, 0x74, 0x5f, 0x3f, 0x74, 0x62,
    0x3f, 0x74, 0x64, 0x3f, 0x74, 0x66, 0x3f, 0x74, 0x67, 0x3f, 0x74, 0x68,
    0x3f, 0x74, 0x6c, 0x3f, 0x74, 0x6d, 0x3f, 0x74, 0x6e, 0x3f, 0x74, 0x70,
    0x3f, 0x74, 0x72, 0x3f, 0x74, 0x75, 0x3f, 0x74, 0x3a, 0x3f, 0x74, 0x42,
    0x3f, 0x74, 0x43, 0x3f, 0x74, 0x44, 0x3f, 0x74, 0x45, 0x3f, 0x74, 0x46,
    0x3f, 0x74, 0x47, 0x3f, 0x74, 0x48, 0x3f, 0x74, 0x49, 0x3f, 0x74, 0x4a,
    0x3f, 0x74, 0x4b, 0x3f, 0x74, 0x4c, 0x3f, 0x74, 0x4d, 0x3f, 0x74, 0x4e,
    0x3f, 0x74, 0x4f, 0x3f, 0x74, 0x50, 0x3f, 0x74, 0x51, 0x3f, 0x74, 0x52,
    0x3f, 0x74, 0x53, 0x3f, 0x74, 0x54, 0x3f, 0x74, 0x55, 0x3f, 0x74, 0x56,
    0x3f, 0x74, 0x57, 0x3f, 0x74, 0x59, 0x3f, 0x74, 0x6a, 0x3f, 0x74, 0x6b,
    0x3f, 0x74, 0x71, 0x3f, 0x74, 0x76, 0x3f, 0x74, 0x77, 0x3f, 0x74, 0x78,
    0x3f, 0x74, 0x79, 0x3f, 0x74, 0x7a, 0x3f, 0x74, 0x26, 0x3f, 0x74, 0x2a,
    0x3f, 0x74, 0x2c, 0x3f, 0x74, 0x3b, 0x3f, 0x74, 0x58, 0x3f, 0x74, 0x5a};
const uint8_t HuffDecoderCommon::table20_20_emit_[204] = {
    0x3f, 0x20, 0x30, 0x3f, 0x20, 0x31, 0x3f, 0x20, 0x32, 0x3f, 0x20, 0x61,
    0x3f, 0x20, 0x63, 0x3f, 0x20, 0x65, 0x3f, 0x20, 0x69, 0x3f, 0x20, 0x6f,
    0x3f, 0x20, 0x73, 0x3f, 0x20, 0x74, 0x3f, 0x20, 0x20, 0x3f, 0x20, 0x25,
    0x3f, 0x20, 0x2d, 0x3f, 0x20, 0x2e, 0x3f, 0x20, 0x2f, 0x3f, 0x20, 0x33,
    0x3f, 0x20, 0x34, 0x3f, 0x20, 0x35, 0x3f, 0x20, 0x36, 0x3f, 0x20, 0x37,
    0x3f, 0x20, 0x38, 0x3f, 0x20, 0x39, 0x3f, 0x20, 0x3d, 0x3f, 0x20, 0x41,
    0x3f, 0x20, 0x5f, 0x3f, 0x20, 0x62, 0x3f, 0x20, 0x64, 0x3f, 0x20, 0x66,
    0x3f, 0x20, 0x67, 0x3f, 0x20, 0x68, 0x3f, 0x20, 0x6c, 0x3f, 0x20, 0x6d,
    0x3f, 0x20, 0x6e, 0x3f, 0x20, 0x70, 0x3f, 0x20, 0x72, 0x3f, 0x20, 0x75,
    0x3f, 0x20, 0x3a, 0x3f, 0x20, 0x42, 0x3f, 0x20, 0x43, 0x3f, 0x20, 0x44,
    0x3f, 0x20, 0x45, 0x3f, 0x20, 0x46, 0x3f, 0x20, 0x47, 0x3f, 0x20, 0x48,
    0x3f, 0x20, 0x49, 0x3f, 0x20, 0x4a, 0x3f, 0x20, 0x4b, 0x3f, 0x20, 0x4c,
    0x3f, 0x20, 0x4d, 0x3f, 0x20, 0x4e, 0x3f, 0x20, 0x4f, 0x3f, 0x20, 0x50,
    0x3f, 0x20, 0x51, 0x3f, 0x20, 0x52, 0x3f, 0x20, 0x53, 0x3f, 0x20, 0x54,
    0x3f, 0x20, 0x55, 0x3f, 0x20, 0x56, 0x3f, 0x20, 0x57, 0x3f, 0x20, 0x59,
    0x3f, 0x20, 0x6a, 0x3f, 0x20, 0x6b, 0x3f, 0x20, 0x71, 0x3f, 0x20, 0x76,
    0x3f, 0x20, 0x77, 0x3f, 0x20, 0x78, 0x3f, 0x20, 0x79, 0x3f, 0x20, 0x7a};
const uint8_t HuffDecoderCommon::table20_21_emit_[204] = {
    0x3f, 0x25, 0x30, 0x3f, 0x25, 0x31, 0x3f, 0x25, 0x32, 0x3f, 0x25, 0x61,
    0x3f, 0x25, 0x63, 0x3f, 0x25, 0x65, 0x3f, 0x25, 0x69, 0x3f, 0x25, 0x6f,
    0x3f, 0x25, 0x73, 0x3f, 0x25, 0x74, 0x3f, 0x25, 0x20, 0x3f, 0x25, 0x25,
    0x3f, 0x25, 0x2d, 0x3f, 0x25, 0x2e, 0x3f, 0x25, 0x2f, 0x3f, 0x25, 0x33,
    0x3f, 0x25, 0x34, 0x3f, 0x25, 0x35, 0x3f, 0x25, 0x36, 0x3f, 0x25, 0x37,
    0x3f, 0x25, 0x38, 0x3f, 0x25, 0x39, 0x3f, 0x25, 0x3d, 0x3f, 0x25, 0x41,
    0x3f, 0x25, 0x5f, 0x3f, 0x25, 0x62, 0x3f, 0x25, 0x64, 0x3f, 0x25, 0x66,
    0x3f, 0x25, 0x67, 0x3f, 0x25, 0x68, 0x3f, 0x25, 0x6c, 0x3f, 0x25, 0x6d,
    0x3f, 0x25, 0x6e, 0x3f, 0x25, 0x70, 0x3f, 0x25, 0x72, 0x3f, 0x25, 0x75,
    0x3f, 0x25, 0x3a, 0x3f, 0x25, 0x42, 0x3f, 0x25, 0x43, 0x3f, 0x25, 0x44,
    0x3f, 0x25, 0x45, 0x3f, 0x25, 0x46, 0x3f, 0x25, 0x47, 0x3f, 0x25, 0x48,
    0x3f, 0x25, 0x49, 0x3f, 0x25, 0x4a, 0x3f, 0x25, 0x4b, 0x3f, 0x25, 0x4c,
    0x3f, 0x25, 0x4d, 0x3f, 0x25, 0x4e, 0x3f, 0x25, 0x4f, 0x3f, 0x25, 0x50,
    0x3f, 0x25, 0x51, 0x3f, 0x25, 0x52, 0x3f, 0x25, 0x53, 0x3f, 0x25, 0x54,
    0x3f, 0x25, 0x55, 0x3f, 0x25, 0x56, 0x3f, 0x25, 0x57, 0x3f, 0x25, 0x59,
    0x3f, 0x25, 0x6a, 0x3f, 0x25, 0x6b, 0x3f, 0x25, 0x71, 0x3f, 0x25, 0x76,
    0x3f, 0x25, 0x77, 0x3f, 0x25, 0x78, 0x3f, 0x25, 0x79, 0x3f, 0x25, 0x7a};
const uint8_t HuffDecoderCommon::table20_22_emit_[204] = {
    0x3f, 0x2d, 0x30, 0x3f, 0x2d, 0x31, 0x3f, 0x2d, 0x32, 0x3f, 0x2d, 0x61,
    0x3f, 0x2d, 0x63, 0x3f, 0x2d, 0x65, 0x3f, 0x2d, 0x69, 0x3f, 0x2d, 0x6f,
    0x3f, 0x2d, 0x73, 0x3f, 0x2d, 0x74, 0x3f, 0x2d, 0x20, 0x3f, 0x2d, 0x25,
    0x3f, 0x2d, 0x2d, 0x3f, 0x2d, 0x2e, 0x3f, 0x2d, 0x2f, 0x3f, 0x2d, 0x33,
    0x3f, 0x2d, 0x34, 0x3f, 0x2d, 0x35, 0x3f, 0x2d, 0x36, 0x3f, 0x2d, 0x37,
    0x3f, 0x2d, 0x38, 0x3f, 0x2d, 0x39, 0x3f, 0x2d, 0x3d, 0x3f, 0x2d, 0x41,
    0x3f, 0x2d, 0x5f, 0x3f, 0x2d, 0x62, 0x3f, 0x2d, 0x64, 0x3f, 0x2d, 0x66,
    0x3f, 0x2d, 0x67, 0x3f, 0x2d, 0x68, 0x3f, 0x2d, 0x6c, 0x3f, 0x2d, 0x6d,
    0x3f, 0x2d, 0x6e, 0x3f, 0x2d, 0x70, 0x3f, 0x2d, 0x72, 0x3f, 0x2d, 0x75,
    0x3f, 0x2d, 0x3a, 0x3f, 0x2d, 0x42, 0x3f, 0x2d, 0x43, 0x3f, 0x2d, 0x44,
    0x3f, 0x2d, 0x45, 0x3f, 0x2d, 0x46, 0x3f, 0x2d, 0x47, 0x3f, 0x2d, 0x48,
    0x3f, 0x2d, 0x49, 0x3f, 0x2d, 0x4a, 0x3f, 0x2d, 0x4b, 0x3f, 0x2d, 0x4c,
    0x3f, 0x2d, 0x4d, 0x3f, 0x2d, 0x4e, 0x3f, 0x2d, 0x4f, 0x3f, 0x2d, 0x50,
    0x3f, 0x2d, 0x51, 0x3f, 0x2d, 0x52, 0x3f, 0x2d, 0x53, 0x3f, 0x2d, 0x54,
    0x3f, 0x2d, 0x55, 0x3f, 0x2d, 0x56, 0x3f, 0x2d, 0x57, 0x3f, 0x2d, 0x59,
    0x3f, 0x2d, 0x6a, 0x3f, 0x2d, 0x6b, 0x3f, 0x2d, 0x71, 0x3f, 0x2d, 0x76,
    0x3f, 0x2d, 0x77, 0x3f, 0x2d, 0x78, 0x3f, 0x2d, 0x79, 0x3f, 0x2d, 0x7a};
const uint8_t HuffDecoderCommon::table20_23_emit_[204] = {
    0x3f, 0x2e, 0x30, 0x3f, 0x2e, 0x31, 0x3f, 0x2e, 0x32, 0x3f, 0x2e, 0x61,
    0x3f, 0x2e, 0x63, 0x3f, 0x2e, 0x65, 0x3f, 0x2e, 0x69, 0x3f, 0x2e, 0x6f,
    0x3f, 0x2e, 0x73, 0x3f, 0x2e, 0x74, 0x3f, 0x2e, 0x20, 0x3f, 0x2e, 0x25,
    0x3f, 0x2e, 0x2d, 0x3f, 0x2e, 0x2e, 0x3f, 0x2e, 0x2f, 0x3f, 0x2e, 0x33,
    0x3f, 0x2e, 0x34, 0x3f, 0x2e, 0x35, 0x3f, 0x2e, 0x36, 0x3f, 0x2e, 0x37,
    0x3f, 0x2e, 0x38, 0x3f, 0x2e, 0x39, 0x3f, 0x2e, 0x3d, 0x3f, 0x2e, 0x41,
    0x3f, 0x2e, 0x5f, 0x3f, 0x2e, 0x62, 0x3f, 0x2e, 0x64, 0x3f, 0x2e, 0x66,
    0x3f, 0x2e, 0x67, 0x3f, 0x2e, 0x68, 0x3f, 0x2e, 0x6c, 0x3f, 0x2e, 0x6d,
    0x3f, 0x2e, 0x6e, 0x3f, 0x2e, 0x70, 0x3f, 0x2e, 0x72, 0x3f, 0x2e, 0x75,
    0x3f, 0x2e, 0x3a, 0x3f, 0x2e, 0x42, 0x3f, 0x2e, 0x43, 0x3f, 0x2e, 0x44,
    0x3f, 0x2e, 0x45, 0x3f, 0x2e, 0x46, 0x3f, 0x2e, 0x47, 0x3f, 0x2e, 0x48,
    0x3f, 0x2e, 0x49, 0x3f, 0x2e, 0x4a, 0x3f, 0x2e, 0x4b, 0x3f, 0x2e, 0x4c,
    0x3f, 0x2e, 0x4d, 0x3f, 0x2e, 0x4e, 0x3f, 0x2e, 0x4f, 0x3f, 0x2e, 0x50,
    0x3f, 0x2e, 0x51, 0x3f, 0x2e, 0x52, 0x3f, 0x2e, 0x53, 0x3f, 0x2e, 0x54,
    0x3f, 0x2e, 0x55, 0x3f, 0x2e, 0x56, 0x3f, 0x2e, 0x57, 0x3f, 0x2e, 0x59,
    0x3f, 0x2e, 0x6a, 0x3f, 0x2e, 0x6b, 0x3f, 0x2e, 0x71, 0x3f, 0x2e, 0x76,
    0x3f, 0x2e, 0x77, 0x3f, 0x2e, 0x78, 0x3f, 0x2e, 0x79, 0x3f, 0x2e, 0x7a};
const uint8_t HuffDecoderCommon::table20_24_emit_[204] = {
    0x3f, 0x2f, 0x30, 0x3f, 0x2f, 0x31, 0x3f, 0x2f, 0x32, 0x3f, 0x2f, 0x61,
    0x3f, 0x2f, 0x63, 0x3f, 0x2f, 0x65, 0x3f, 0x2f, 0x69, 0x3f, 0x2f, 0x6f,
    0x3f, 0x2f, 0x73, 0x3f, 0x2f, 0x74, 0x3f, 0x2f, 0x20, 0x3f, 0x2f, 0x25,
    0x3f, 0x2f, 0x2d, 0x3f, 0x2f, 0x2e, 0x3f, 0x2f, 0x2f, 0x3f, 0x2f, 0x33,
    0x3f, 0x2f, 0x34, 0x3f, 0x2f, 0x35, 0x3f, 0x2f, 0x36, 0x3f, 0x2f, 0x37,
    0x3f, 0x2f, 0x38, 0x3f, 0x2f, 0x39, 0x3f, 0x2f, 0x3d, 0x3f, 0x2f, 0x41,
    0x3f, 0x2f, 0x5f, 0x3f, 0x2f, 0x62, 0x3f, 0x2f, 0x64, 0x3f, 0x2f, 0x66,
    0x3f, 0x2f, 0x67, 0x3f, 0x2f, 0x68, 0x3f, 0x2f, 0x6c, 0x3f, 0x2f, 0x6d,
    0x3f, 0x2f, 0x6e, 0x3f, 0x2f, 0x70, 0x3f, 0x2f, 0x72, 0x3f, 0x2f, 0x75,
    0x3f, 0x2f, 0x3a, 0x3f, 0x2f, 0x42, 0x3f, 0x2f, 0x43, 0x3f, 0x2f, 0x44,
    0x3f, 0x2f, 0x45, 0x3f, 0x2f, 0x46, 0x3f, 0x2f, 0x47, 0x3f, 0x2f, 0x48,
    0x3f, 0x2f, 0x49, 0x3f, 0x2f, 0x4a, 0x3f, 0x2f, 0x4b, 0x3f, 0x2f, 0x4c,
    0x3f, 0x2f, 0x4d, 0x3f, 0x2f, 0x4e, 0x3f, 0x2f, 0x4f, 0x3f, 0x2f, 0x50,
    0x3f, 0x2f, 0x51, 0x3f, 0x2f, 0x52, 0x3f, 0x2f, 0x53, 0x3f, 0x2f, 0x54,
    0x3f, 0x2f, 0x55, 0x3f, 0x2f, 0x56, 0x3f, 0x2f, 0x57, 0x3f, 0x2f, 0x59,
    0x3f, 0x2f, 0x6a, 0x3f, 0x2f, 0x6b, 0x3f, 0x2f, 0x71, 0x3f, 0x2f, 0x76,
    0x3f, 0x2f, 0x77, 0x3f, 0x2f, 0x78, 0x3f, 0x2f, 0x79, 0x3f, 0x2f, 0x7a};
const uint8_t HuffDecoderCommon::table20_25_emit_[204] = {
    0x3f, 0x33, 0x30, 0x3f, 0x33, 0x31, 0x3f, 0x33, 0x32, 0x3f, 0x33, 0x61,
    0x3f, 0x33, 0x63, 0x3f, 0x33, 0x65, 0x3f, 0x33, 0x69, 0x3f, 0x33, 0x6f,
    0x3f, 0x33, 0x73, 0x3f, 0x33, 0x74, 0x3f, 0x33, 0x20, 0x3f, 0x33, 0x25,
    0x3f, 0x33, 0x2d, 0x3f, 0x33, 0x2e, 0x3f, 0x33, 0x2f, 0x3f, 0x33, 0x33,
    0x3f, 0x33, 0x34, 0x3f, 0x33, 0x35, 0x3f, 0x33, 0x36, 0x3f, 0x33, 0x37,
    0x3f, 0x33, 0x38, 0x3f, 0x33, 0x39, 0x3f, 0x33, 0x3d, 0x3f, 0x33, 0x41,
    0x3f, 0x33, 0x5f, 0x3f, 0x33, 0x62, 0x3f, 0x33, 0x64, 0x3f, 0x33, 0x66,
    0x3f, 0x33, 0x67, 0x3f, 0x33, 0x68, 0x3f, 0x33, 0x6c, 0x3f, 0x33, 0x6d,
    0x3f, 0x33, 0x6e, 0x3f, 0x33, 0x70, 0x3f, 0x33, 0x72, 0x3f, 0x33, 0x75,
    0x3f, 0x33, 0x3a, 0x3f, 0x33, 0x42, 0x3f, 0x33, 0x43, 0x3f, 0x33, 0x44,
    0x3f, 0x33, 0x45, 0x3f, 0x33, 0x46, 0x3f, 0x33, 0x47, 0x3f, 0x33, 0x48,
    0x3f, 0x33, 0x49, 0x3f, 0x33, 0x4a, 0x3f, 0x33, 0x4b, 0x3f, 0x33, 0x4c,
    0x3f, 0x33, 0x4d, 0x3f, 0x33, 0x4e, 0x3f, 0x33, 0x4f, 0x3f, 0x33, 0x50,
    0x3f, 0x33, 0x51, 0x3f, 0x33, 0x52, 0x3f, 0x33, 0x53, 0x3f, 0x33, 0x54,
    0x3f, 0x33, 0x55, 0x3f, 0x33, 0x56, 0x3f, 0x33, 0x57, 0x3f, 0x33, 0x59,
    0x3f, 0x33, 0x6a, 0x3f, 0x33, 0x6b, 0x3f, 0x33, 0x71, 0x3f, 0x33, 0x76,
    0x3f, 0x33, 0x77, 0x3f, 0x33, 0x78, 0x3f, 0x33, 0x79, 0x3f, 0x33, 0x7a};
const uint8_t HuffDecoderCommon::table20_26_emit_[204] = {
    0x3f, 0x34, 0x30, 0x3f, 0x34, 0x31, 0x3f, 0x34, 0x32, 0x3f, 0x34, 0x61,
    0x3f, 0x34, 0x63, 0x3f, 0x34, 0x65, 0x3f, 0x34, 0x69, 0x3f, 0x34, 0x6f,
    0x3f, 0x34, 0x73, 0x3f, 0x34, 0x74, 0x3f, 0x34, 0x20, 0x3f, 0x34, 0x25,
    0x3f, 0x34, 0x2d, 0x3f, 0x34, 0x2e, 0x3f, 0x34, 0x2f, 0x3f, 0x34, 0x33,
    0x3f, 0x34, 0x34, 0x3f, 0x34, 0x35, 0x3f, 0x34, 0x36, 0x3f, 0x34, 0x37,
    0x3f, 0x34, 0x38, 0x3f, 0x34, 0x39, 0x3f, 0x34, 0x3d, 0x3f, 0x34, 0x41,
    0x3f, 0x34, 0x5f, 0x3f, 0x34, 0x62, 0x3f, 0x34, 0x64, 0x3f, 0x34, 0x66,
    0x3f, 0x34, 0x67, 0x3f, 0x34, 0x68, 0x3f, 0x34, 0x6c, 0x3f, 0x34, 0x6d,
    0x3f, 0x34, 0x6e, 0x3f, 0x34, 0x70, 0x3f, 0x34, 0x72, 0x3f, 0x34, 0x75,
    0x3f, 0x34, 0x3a, 0x3f, 0x34, 0x42, 0x3f, 0x34, 0x43, 0x3f, 0x34, 0x44,
    0x3f, 0x34, 0x45, 0x3f, 0x34, 0x46, 0x3f, 0x34, 0x47, 0x3f, 0x34, 0x48,
    0x3f, 0x34, 0x49, 0x3f, 0x34, 0x4a, 0x3f, 0x34, 0x4b, 0x3f, 0x34, 0x4c,
    0x3f, 0x34, 0x4d, 0x3f, 0x34, 0x4e, 0x3f, 0x34, 0x4f, 0x3f, 0x34, 0x50,
    0x3f, 0x34, 0x51, 0x3f, 0x34, 0x52, 0x3f, 0x34, 0x53, 0x3f, 0x34, 0x54,
    0x3f, 0x34, 0x55, 0x3f, 0x34, 0x56, 0x3f, 0x34, 0x57, 0x3f, 0x34, 0x59,
    0x3f, 0x34, 0x6a, 0x3f, 0x34, 0x6b, 0x3f, 0x34, 0x71, 0x3f, 0x34, 0x76,
    0x3f, 0x34, 0x77, 0x3f, 0x34, 0x78, 0x3f, 0x34, 0x79, 0x3f, 0x34, 0x7a};
const uint8_t HuffDecoderCommon::table20_27_emit_[204] = {
    0x3f, 0x35, 0x30, 0x3f, 0x35, 0x31, 0x3f, 0x35, 0x32, 0x3f, 0x35, 0x61,
    0x3f, 0x35, 0x63, 0x3f, 0x35, 0x65, 0x3f, 0x35, 0x69, 0x3f, 0x35, 0x6f,
    0x3f, 0x35, 0x73, 0x3f, 0x35, 0x74, 0x3f, 0x35, 0x20, 0x3f, 0x35, 0x25,
    0x3f, 0x35, 0x2d, 0x3f, 0x35, 0x2e, 0x3f, 0x35, 0x2f, 0x3f, 0x35, 0x33,
    0x3f, 0x35, 0x34, 0x3f, 0x35, 0x35, 0x3f, 0x35, 0x36, 0x3f, 0x35, 0x37,
    0x3f, 0x35, 0x38, 0x3f, 0x35, 0x39, 0x3f, 0x35, 0x3d, 0x3f, 0x35, 0x41,
    0x3f, 0x35, 0x5f, 0x3f, 0x35, 0x62, 0x3f, 0x35, 0x64, 0x3f, 0x35, 0x66,
    0x3f, 0x35, 0x67, 0x3f, 0x35, 0x68, 0x3f, 0x35, 0x6c, 0x3f, 0x35, 0x6d,
    0x3f, 0x35, 0x6e, 0x3f, 0x35, 0x70, 0x3f, 0x35, 0x72, 0x3f, 0x35, 0x75,
    0x3f, 0x35, 0x3a, 0x3f, 0x35, 0x42, 0x3f, 0x35, 0x43, 0x3f, 0x35, 0x44,
    0x3f, 0x35, 0x45, 0x3f, 0x35, 0x46, 0x3f, 0x35, 0x47, 0x3f, 0x35, 0x48,
    0x3f, 0x35, 0x49, 0x3f, 0x35, 0x4a, 0x3f, 0x35, 0x4b, 0x3f, 0x35, 0x4c,
    0x3f, 0x35, 0x4d, 0x3f, 0x35, 0x4e, 0x3f, 0x35, 0x4f, 0x3f, 0x35, 0x50,
    0x3f, 0x35, 0x51, 0x3f, 0x35, 0x52, 0x3f, 0x35, 0x53, 0x3f, 0x35, 0x54,
    0x3f, 0x35, 0x55, 0x3f, 0x35, 0x56, 0x3f, 0x35, 0x57, 0x3f, 0x35, 0x59,
    0x3f, 0x35, 0x6a, 0x3f, 0x35, 0x6b, 0x3f, 0x35, 0x71, 0x3f, 0x35, 0x76,
    0x3f, 0x35, 0x77, 0x3f, 0x35, 0x78, 0x3f, 0x35, 0x79, 0x3f, 0x35, 0x7a};
const uint8_t HuffDecoderCommon::table20_28_emit_[204] = {
    0x3f, 0x36, 0x30, 0x3f, 0x36, 0x31, 0x3f, 0x36, 0x32, 0x3f, 0x36, 0x61,
    0x3f, 0x36, 0x63, 0x3f, 0x36, 0x65, 0x3f, 0x36, 0x69, 0x3f, 0x36, 0x6f,
    0x3f, 0x36, 0x73, 0x3f, 0x36, 0x74, 0x3f, 0x36, 0x20, 0x3f, 0x36, 0x25,
    0x3f, 0x36, 0x2d, 0x3f, 0x36, 0x2e, 0x3f, 0x36, 0x2f, 0x3f, 0x36, 0x33,
    0x3f, 0x36, 0x34, 0x3f, 0x36, 0x35, 0x3f, 0x36, 0x36, 0x3f, 0x36, 0x37,
    0x3f, 0x36, 0x38, 0x3f, 0x36, 0x39, 0x3f, 0x36, 0x3d, 0x3f, 0x36, 0x41,
    0x3f, 0x36, 0x5f, 0x3f, 0x36, 0x62, 0x3f, 0x36, 0x64, 0x3f, 0x36, 0x66,
    0x3f, 0x36, 0x67, 0x3f, 0x36, 0x68, 0x3f, 0x36, 0x6c, 0x3f, 0x36, 0x6d,
    0x3f, 0x36, 0x6e, 0x3f, 0x36, 0x70, 0x3f, 0x36, 0x72, 0x3f, 0x36, 0x75,
    0x3f, 0x36, 0x3a, 0x3f, 0x36, 0x42, 0x3f, 0x36, 0x43, 0x3f, 0x36, 0x44,
    0x3f, 0x36, 0x45, 0x3f, 0x36, 0x46, 0x3f, 0x36, 0x47, 0x3f, 0x36, 0x48,
    0x3f, 0x36, 0x49, 0x3f, 0x36, 0x4a, 0x3f, 0x36, 0x4b, 0x3f, 0x36, 0x4c,
    0x3f, 0x36, 0x4d, 0x3f, 0x36, 0x4e, 0x3f, 0x36, 0x4f, 0x3f, 0x36, 0x50,
    0x3f, 0x36, 0x51, 0x3f, 0x36, 0x52, 0x3f, 0x36, 0x53, 0x3f, 0x36, 0x54,
    0x3f, 0x36, 0x55, 0x3f, 0x36, 0x56, 0x3f, 0x36, 0x57, 0x3f, 0x36, 0x59,
    0x3f, 0x36, 0x6a, 0x3f, 0x36, 0x6b, 0x3f, 0x36, 0x71, 0x3f, 0x36, 0x76,
    0x3f, 0x36, 0x77, 0x3f, 0x36, 0x78, 0x3f, 0x36, 0x79, 0x3f, 0x36, 0x7a};
const uint8_t HuffDecoderCommon::table20_29_emit_[204] = {
    0x3f, 0x37, 0x30, 0x3f, 0x37, 0x31, 0x3f, 0x37, 0x32, 0x3f, 0x37, 0x61,
    0x3f, 0x37, 0x63, 0x3f, 0x37, 0x65, 0x3f, 0x37, 0x69, 0x3f, 0x37, 0x6f,
    0x3f, 0x37, 0x73, 0x3f, 0x37, 0x74, 0x3f, 0x37, 0x20, 0x3f, 0x37, 0x25,
    0x3f, 0x37, 0x2d, 0x3f, 0x37, 0x2e, 0x3f, 0x37, 0x2f, 0x3f, 0x37, 0x33,
    0x3f, 0x37, 0x34, 0x3f, 0x37, 0x35, 0x3f, 0x37, 0x36, 0x3f, 0x37, 0x37,
    0x3f, 0x37, 0x38, 0x3f, 0x37, 0x39, 0x3f, 0x37, 0x3d, 0x3f, 0x37, 0x41,
    0x3f, 0x37, 0x5f, 0x3f, 0x37, 0x62, 0x3f, 0x37, 0x64, 0x3f, 0x37, 0x66,
    0x3f, 0x37, 0x67, 0x3f, 0x37, 0x68, 0x3f, 0x37, 0x6c, 0x3f, 0x37, 0x6d,
    0x3f, 0x37, 0x6e, 0x3f, 0x37, 0x70, 0x3f, 0x37, 0x72, 0x3f, 0x37, 0x75,
    0x3f, 0x37, 0x3a, 0x3f, 0x37, 0x42, 0x3f, 0x37, 0x43, 0x3f, 0x37, 0x44,
    0x3f, 0x37, 0x45, 0x3f, 0x37, 0x46, 0x3f, 0x37, 0x47, 0x3f, 0x37, 0x48,
    0x3f, 0x37, 0x49, 0x3f, 0x37, 0x4a, 0x3f, 0x37, 0x4b, 0x3f, 0x37, 0x4c,
    0x3f, 0x37, 0x4d, 0x3f, 0x37, 0x4e, 0x3f, 0x37, 0x4f, 0x3f, 0x37, 0x50,
    0x3f, 0x37, 0x51, 0x3f, 0x37, 0x52, 0x3f, 0x37, 0x53, 0x3f, 0x37, 0x54,
    0x3f, 0x37, 0x55, 0x3f, 0x37, 0x56, 0x3f, 0x37, 0x57, 0x3f, 0x37, 0x59,
    0x3f, 0x37, 0x6a, 0x3f, 0x37, 0x6b, 0x3f, 0x37, 0x71, 0x3f, 0x37, 0x76,
    0x3f, 0x37, 0x77, 0x3f, 0x37, 0x78, 0x3f, 0x37, 0x79, 0x3f, 0x37, 0x7a};
const uint8_t HuffDecoderCommon::table20_30_emit_[204] = {
    0x3f, 0x38, 0x30, 0x3f, 0x38, 0x31, 0x3f, 0x38, 0x32, 0x3f, 0x38, 0x61,
    0x3f, 0x38, 0x63, 0x3f, 0x38, 0x65, 0x3f, 0x38, 0x69, 0x3f, 0x38, 0x6f,
    0x3f, 0x38, 0x73, 0x3f, 0x38, 0x74, 0x3f, 0x38, 0x20, 0x3f, 0x38, 0x25,
    0x3f, 0x38, 0x2d, 0x3f, 0x38, 0x2e, 0x3f, 0x38, 0x2f, 0x3f, 0x38, 0x33,
    0x3f, 0x38, 0x34, 0x3f, 0x38, 0x35, 0x3f, 0x38, 0x36, 0x3f, 0x38, 0x37,
    0x3f, 0x38, 0x38, 0x3f, 0x38, 0x39, 0x3f, 0x38, 0x3d, 0x3f, 0x38, 0x41,
    0x3f, 0x38, 0x5f, 0x3f, 0x38, 0x62, 0x3f, 0x38, 0x64, 0x3f, 0x38, 0x66,
    0x3f, 0x38, 0x67, 0x3f, 0x38, 0x68, 0x3f, 0x38, 0x6c, 0x3f, 0x38, 0x6d,
    0x3f, 0x38, 0x6e, 0x3f, 0x38, 0x70, 0x3f, 0x38, 0x72, 0x3f, 0x38, 0x75,
    0x3f, 0x38, 0x3a, 0x3f, 0x38, 0x42, 0x3f, 0x38, 0x43, 0x3f, 0x38, 0x44,
    0x3f, 0x38, 0x45, 0x3f, 0x38, 0x46, 0x3f, 0x38, 0x47, 0x3f, 0x38, 0x48,
    0x3f, 0x38, 0x49, 0x3f, 0x38, 0x4a, 0x3f, 0x38, 0x4b, 0x3f, 0x38, 0x4c,
    0x3f, 0x38, 0x4d, 0x3f, 0x38, 0x4e, 0x3f, 0x38, 0x4f, 0x3f, 0x38, 0x50,
    0x3f, 0x38, 0x51, 0x3f, 0x38, 0x52, 0x3f, 0x38, 0x53, 0x3f, 0x38, 0x54,
    0x3f, 0x38, 0x55, 0x3f, 0x38, 0x56, 0x3f, 0x38, 0x57, 0x3f, 0x38, 0x59,
    0x3f, 0x38, 0x6a, 0x3f, 0x38, 0x6b, 0x3f, 0x38, 0x71, 0x3f, 0x38, 0x76,
    0x3f, 0x38, 0x77, 0x3f, 0x38, 0x78, 0x3f, 0x38, 0x79, 0x3f, 0x38, 0x7a};
const uint8_t HuffDecoderCommon::table20_31_emit_[204] = {
    0x3f, 0x39, 0x30, 0x3f, 0x39, 0x31, 0x3f, 0x39, 0x32, 0x3f, 0x39, 0x61,
    0x3f, 0x39, 0x63, 0x3f, 0x39, 0x65, 0x3f, 0x39, 0x69, 0x3f, 0x39, 0x6f,
    0x3f, 0x39, 0x73, 0x3f, 0x39, 0x74, 0x3f, 0x39, 0x20, 0x3f, 0x39, 0x25,
    0x3f, 0x39, 0x2d, 0x3f, 0x39, 0x2e, 0x3f, 0x39, 0x2f, 0x3f, 0x39, 0x33,
    0x3f, 0x39, 0x34, 0x3f, 0x39, 0x35, 0x3f, 0x39, 0x36, 0x3f, 0x39, 0x37,
    0x3f, 0x39, 0x38, 0x3f, 0x39, 0x39, 0x3f, 0x39, 0x3d, 0x3f, 0x39, 0x41,
    0x3f, 0x39, 0x5f, 0x3f, 0x39, 0x62, 0x3f, 0x39, 0x64, 0x3f, 0x39, 0x66,
    0x3f, 0x39, 0x67, 0x3f, 0x39, 0x68, 0x3f, 0x39, 0x6c, 0x3f, 0x39, 0x6d,
    0x3f, 0x39, 0x6e, 0x3f, 0x39, 0x70, 0x3f, 0x39, 0x72, 0x3f, 0x39, 0x75,
    0x3f, 0x39, 0x3a, 0x3f, 0x39, 0x42, 0x3f, 0x39, 0x43, 0x3f, 0x39, 0x44,
    0x3f, 0x39, 0x45, 0x3f, 0x39, 0x46, 0x3f, 0x39, 0x47, 0x3f, 0x39, 0x48,
    0x3f, 0x39, 0x49, 0x3f, 0x39, 0x4a, 0x3f, 0x39, 0x4b, 0x3f, 0x39, 0x4c,
    0x3f, 0x39, 0x4d, 0x3f, 0x39, 0x4e, 0x3f, 0x39, 0x4f, 0x3f, 0x39, 0x50,
    0x3f, 0x39, 0x51, 0x3f, 0x39, 0x52, 0x3f, 0x39, 0x53, 0x3f, 0x39, 0x54,
    0x3f, 0x39, 0x55, 0x3f, 0x39, 0x56, 0x3f, 0x39, 0x57, 0x3f, 0x39, 0x59,
    0x3f, 0x39, 0x6a, 0x3f, 0x39, 0x6b, 0x3f, 0x39, 0x71, 0x3f, 0x39, 0x76,
    0x3f, 0x39, 0x77, 0x3f, 0x39, 0x78, 0x3f, 0x39, 0x79, 0x3f, 0x39, 0x7a};
const uint8_t HuffDecoderCommon::table20_32_emit_[204] = {
    0x3f, 0x3d, 0x30, 0x3f, 0x3d, 0x31, 0x3f, 0x3d, 0x32, 0x3f, 0x3d, 0x61,
    0x3f, 0x3d, 0x63, 0x3f, 0x3d, 0x65, 0x3f, 0x3d, 0x69, 0x3f, 0x3d, 0x6f,
    0x3f, 0x3d, 0x73, 0x3f, 0x3d, 0x74, 0x3f, 0x3d, 0x20, 0x3f, 0x3d, 0x25,
    0x3f, 0x3d, 0x2d, 0x3f, 0x3d, 0x2e, 0x3f, 0x3d, 0x2f, 0x3f, 0x3d, 0x33,
    0x3f, 0x3d, 0x34, 0x3f, 0x3d, 0x35, 0x3f, 0x3d, 0x36, 0x3f, 0x3d, 0x37,
    0x3f, 0x3d, 0x38, 0x3f, 0x3d, 0x39, 0x3f, 0x3d, 0x3d, 0x3f, 0x3d, 0x41,
    0x3f, 0x3d, 0x5f, 0x3f, 0x3d, 0x62, 0x3f, 0x3d, 0x64, 0x3f, 0x3d, 0x66,
    0x3f, 0x3d, 0x67, 0x3f, 0x3d, 0x68, 0x3f, 0x3d, 0x6c, 0x3f, 0x3d, 0x6d,
    0x3f, 0x3d, 0x6e, 0x3f, 0x3d, 0x70, 0x3f, 0x3d, 0x72, 0x3f, 0x3d, 0x75,
    0x3f, 0x3d, 0x3a, 0x3f, 0x3d, 0x42, 0x3f, 0x3d, 0x43, 0x3f, 0x3d, 0x44,
    0x3f, 0x3d, 0x45, 0x3f, 0x3d, 0x46, 0x3f, 0x3d, 0x47, 0x3f, 0x3d, 0x48,
    0x3f, 0x3d, 0x49, 0x3f, 0x3d, 0x4a, 0x3f, 0x3d, 0x4b, 0x3f, 0x3d, 0x4c,
    0x3f, 0x3d, 0x4d, 0x3f, 0x3d, 0x4e, 0x3f, 0x3d, 0x4f, 0x3f, 0x3d, 0x50,
    0x3f, 0x3d, 0x51, 0x3f, 0x3d, 0x52, 0x3f, 0x3d, 0x53, 0x3f, 0x3d, 0x54,
    0x3f, 0x3d, 0x55, 0x3f, 0x3d, 0x56, 0x3f, 0x3d, 0x57, 0x3f, 0x3d, 0x59,
    0x3f, 0x3d, 0x6a, 0x3f, 0x3d, 0x6b, 0x3f, 0x3d, 0x71, 0x3f, 0x3d, 0x76,
    0x3f, 0x3d, 0x77, 0x3f, 0x3d, 0x78, 0x3f, 0x3d, 0x79, 0x3f, 0x3d, 0x7a};
const uint8_t HuffDecoderCommon::table20_33_emit_[204] = {
    0x3f, 0x41, 0x30, 0x3f, 0x41, 0x31, 0x3f, 0x41, 0x32, 0x3f, 0x41, 0x61,
    0x3f, 0x41, 0x63, 0x3f, 0x41, 0x65, 0x3f, 0x41, 0x69, 0x3f, 0x41, 0x6f,
    0x3f, 0x41, 0x73, 0x3f, 0x41, 0x74, 0x3f, 0x41, 0x20, 0x3f, 0x41, 0x25,
    0x3f, 0x41, 0x2d, 0x3f, 0x41, 0x2e, 0x3f, 0x41, 0x2f, 0x3f, 0x41, 0x33,
    0x3f, 0x41, 0x34, 0x3f, 0x41, 0x35, 0x3f, 0x41, 0x36, 0x3f, 0x41, 0x37,
    0x3f, 0x41, 0x38, 0x3f, 0x41, 0x39, 0x3f, 0x41, 0x3d, 0x3f, 0x41, 0x41,
    0x3f, 0x41, 0x5f, 0x3f, 0x41, 0x62, 0x3f, 0x41, 0x64, 0x3f, 0x41, 0x66,
    0x3f, 0x41, 0x67, 0x3f, 0x41, 0x68, 0x3f, 0x41, 0x6c, 0x3f, 0x41, 0x6d,
    0x3f, 0x41, 0x6e, 0x3f, 0x41, 0x70, 0x3f, 0x41, 0x72, 0x3f, 0x41, 0x75,
    0x3f, 0x41, 0x3a, 0x3f, 0x41, 0x42, 0x3f, 0x41, 0x43, 0x3f, 0x41, 0x44,
    0x3f, 0x41, 0x45, 0x3f, 0x41, 0x46, 0x3f, 0x41, 0x47, 0x3f, 0x41, 0x48,
    0x3f, 0x41, 0x49, 0x3f, 0x41, 0x4a, 0x3f, 0x41, 0x4b, 0x3f, 0x41, 0x4c,
    0x3f, 0x41, 0x4d, 0x3f, 0x41, 0x4e, 0x3f, 0x41, 0x4f, 0x3f, 0x41, 0x50,
    0x3f, 0x41, 0x51, 0x3f, 0x41, 0x52, 0x3f, 0x41, 0x53, 0x3f, 0x41, 0x54,
    0x3f, 0x41, 0x55, 0x3f, 0x41, 0x56, 0x3f, 0x41, 0x57, 0x3f, 0x41, 0x59,
    0x3f, 0x41, 0x6a, 0x3f, 0x41, 0x6b, 0x3f, 0x41, 0x71, 0x3f, 0x41, 0x76,
    0x3f, 0x41, 0x77, 0x3f, 0x41, 0x78, 0x3f, 0x41, 0x79, 0x3f, 0x41, 0x7a};
const uint8_t HuffDecoderCommon::table20_34_emit_[204] = {
    0x3f, 0x5f, 0x30, 0x3f, 0x5f, 0x31, 0x3f, 0x5f, 0x32, 0x3f, 0x5f, 0x61,
    0x3f, 0x5f, 0x63, 0x3f, 0x5f, 0x65, 0x3f, 0x5f, 0x69, 0x3f, 0x5f, 0x6f,
    0x3f, 0x5f, 0x73, 0x3f, 0x5f, 0x74, 0x3f, 0x5f, 0x20, 0x3f, 0x5f, 0x25,
    0x3f, 0x5f, 0x2d, 0x3f, 0x5f, 0x2e, 0x3f, 0x5f, 0x2f, 0x3f, 0x5f, 0x33,
    0x3f, 0x5f, 0x34, 0x3f, 0x5f, 0x35, 0x3f, 0x5f, 0x36, 0x3f, 0x5f, 0x37,
    0x3f, 0x5f, 0x38, 0x3f, 0x5f, 0x39, 0x3f, 0x5f, 0x3d, 0x3f, 0x5f, 0x41,
    0x3f, 0x5f, 0x5f, 0x3f, 0x5f, 0x62, 0x3f, 0x5f, 0x64, 0x3f, 0x5f, 0x66,
    0x3f, 0x5f, 0x67, 0x3f, 0x5f, 0x68, 0x3f, 0x5f, 0x6c, 0x3f, 0x5f, 0x6d,
    0x3f, 0x5f, 0x6e, 0x3f, 0x5f, 0x70, 0x3f, 0x5f, 0x72, 0x3f, 0x5f, 0x75,
    0x3f, 0x5f, 0x3a, 0x3f, 0x5f, 0x42, 0x3f, 0x5f, 0x43, 0x3f, 0x5f, 0x44,
    0x3f, 0x5f, 0x45, 0x3f, 0x5f, 0x46, 0x3f, 0x5f, 0x47, 0x3f, 0x5f, 0x48,
    0x3f, 0x5f, 0x49, 0x3f, 0x5f, 0x4a, 0x3f, 0x5f, 0x4b, 0x3f, 0x5f, 0x4c,
    0x3f, 0x5f, 0x4d, 0x3f, 0x5f, 0x4e, 0x3f, 0x5f, 0x4f, 0x3f, 0x5f, 0x50,
    0x3f, 0x5f, 0x51, 0x3f, 0x5f, 0x52, 0x3f, 0x5f, 0x53, 0x3f, 0x5f, 0x54,
    0x3f, 0x5f, 0x55, 0x3f, 0x5f, 0x56, 0x3f, 0x5f, 0x57, 0x3f, 0x5f, 0x59,
    0x3f, 0x5f, 0x6a, 0x3f, 0x5f, 0x6b, 0x3f, 0x5f, 0x71, 0x3f, 0x5f, 0x76,
    0x3f, 0x5f, 0x77, 0x3f, 0x5f, 0x78, 0x3f, 0x5f, 0x79, 0x3f, 0x5f, 0x7a};
const uint8_t HuffDecoderCommon::table20_35_emit_[204] = {
    0x3f, 0x62, 0x30, 0x3f, 0x62, 0x31, 0x3f, 0x62, 0x32, 0x3f, 0x62, 0x61,
    0x3f, 0x62, 0x63, 0x3f, 0x62, 0x65, 0x3f, 0x62, 0x69, 0x3f, 0x62, 0x6f,
    0x3f, 0x62, 0x73, 0x3f, 0x62, 0x74, 0x3f, 0x62, 0x20, 0x3f, 0x62, 0x25,
    0x3f, 0x62, 0x2d, 0x3f, 0x62, 0x2e, 0x3f, 0x62, 0x2f, 0x3f, 0x62, 0x33,
    0x3f, 0x62, 0x34, 0x3f, 0x62, 0x35, 0x3f, 0x62, 0x36, 0x3f, 0x62, 0x37,
    0x3f, 0x62, 0x38, 0x3f, 0x62, 0x39, 0x3f, 0x62, 0x3d, 0x3f, 0x62, 0x41,
    0x3f, 0x62, 0x5f, 0x3f, 0x62, 0x62, 0x3f, 0x62, 0x64, 0x3f, 0x62, 0x66,
    0x3f, 0x62, 0x67, 0x3f, 0x62, 0x68, 0x3f, 0x62, 0x6c, 0x3f, 0x62, 0x6d,
    0x3f, 0x62, 0x6e, 0x3f, 0x62, 0x70, 0x3f, 0x62, 0x72, 0x3f, 0x62, 0x75,
    0x3f, 0x62, 0x3a, 0x3f, 0x62, 0x42, 0x3f, 0x62, 0x43, 0x3f, 0x62, 0x44,
    0x3f, 0x62, 0x45, 0x3f, 0x62, 0x46, 0x3f, 0x62, 0x47, 0x3f, 0x62, 0x48,
    0x3f, 0x62, 0x49, 0x3f, 0x62, 0x4a, 0x3f, 0x62, 0x4b, 0x3f, 0x62, 0x4c,
    0x3f, 0x62, 0x4d, 0x3f, 0x62, 0x4e, 0x3f, 0x62, 0x4f, 0x3f, 0x62, 0x50,
    0x3f, 0x62, 0x51, 0x3f, 0x62, 0x52, 0x3f, 0x62, 0x53, 0x3f, 0x62, 0x54,
    0x3f, 0x62, 0x55, 0x3f, 0x62, 0x56, 0x3f, 0x62, 0x57, 0x3f, 0x62, 0x59,
    0x3f, 0x62, 0x6a, 0x3f, 0x62, 0x6b, 0x3f, 0x62, 0x71, 0x3f, 0x62, 0x76,
    0x3f, 0x62, 0x77, 0x3f, 0x62, 0x78, 0x3f, 0x62, 0x79, 0x3f, 0x62, 0x7a};
const uint8_t HuffDecoderCommon::table20_36_emit_[204] = {
    0x3f, 0x64, 0x30, 0x3f, 0x64, 0x31, 0x3f, 0x64, 0x32, 0x3f, 0x64, 0x61,
    0x3f, 0x64, 0x63, 0x3f, 0x64, 0x65, 0x3f, 0x64, 0x69, 0x3f, 0x64, 0x6f,
    0x3f, 0x64, 0x73, 0x3f, 0x64, 0x74, 0x3f, 0x64, 0x20, 0x3f, 0x64, 0x25,
    0x3f, 0x64, 0x2d, 0x3f, 0x64, 0x2e, 0x3f, 0x64, 0x2f, 0x3f, 0x64, 0x33,
    0x3f, 0x64, 0x34, 0x3f, 0x64, 0x35, 0x3f, 0x64, 0x36, 0x3f, 0x64, 0x37,
    0x3f, 0x64, 0x38, 0x3f, 0x64, 0x39, 0x3f, 0x64, 0x3d, 0x3f, 0x64, 0x41,
    0x3f, 0x64, 0x5f, 0x3f, 0x64, 0x62, 0x3f, 0x64, 0x64, 0x3f, 0x64, 0x66,
    0x3f, 0x64, 0x67, 0x3f, 0x64, 0x68, 0x3f, 0x64, 0x6c, 0x3f, 0x64, 0x6d,
    0x3f, 0x64, 0x6e, 0x3f, 0x64, 0x70, 0x3f, 0x64, 0x72, 0x3f, 0x64, 0x75,
    0x3f, 0x64, 0x3a, 0x3f, 0x64, 0x42, 0x3f, 0x64, 0x43, 0x3f, 0x64, 0x44,
    0x3f, 0x64, 0x45, 0x3f, 0x64, 0x46, 0x3f, 0x64, 0x47, 0x3f, 0x64, 0x48,
    0x3f, 0x64, 0x49, 0x3f, 0x64, 0x4a, 0x3f, 0x64, 0x4b, 0x3f, 0x64, 0x4c,
    0x3f, 0x64, 0x4d, 0x3f, 0x64, 0x4e, 0x3f, 0x64, 0x4f, 0x3f, 0x64, 0x50,
    0x3f, 0x64, 0x51, 0x3f, 0x64, 0x52, 0x3f, 0x64, 0x53, 0x3f, 0x64, 0x54,
    0x3f, 0x64, 0x55, 0x3f, 0x64, 0x56, 0x3f, 0x64, 0x57, 0x3f, 0x64, 0x59,
    0x3f, 0x64, 0x6a, 0x3f, 0x64, 0x6b, 0x3f, 0x64, 0x71, 0x3f, 0x64, 0x76,
    0x3f, 0x64, 0x77, 0x3f, 0x64, 0x78, 0x3f, 0x64, 0x79, 0x3f, 0x64, 0x7a};
const uint8_t HuffDecoderCommon::table20_37_emit_[204] = {
    0x3f, 0x66, 0x30, 0x3f, 0x66, 0x31, 0x3f, 0x66, 0x32, 0x3f, 0x66, 0x61,
    0x3f, 0x66, 0x63, 0x3f, 0x66, 0x65, 0x3f, 0x66, 0x69, 0x3f, 0x66, 0x6f,
    0x3f, 0x66, 0x73, 0x3f, 0x66, 0x74, 0x3f, 0x66, 0x20, 0x3f, 0x66, 0x25,
    0x3f, 0x66, 0x2d, 0x3f, 0x66, 0x2e, 0x3f, 0x66, 0x2f, 0x3f, 0x66, 0x33,
    0x3f, 0x66, 0x34, 0x3f, 0x66, 0x35, 0x3f, 0x66, 0x36, 0x3f, 0x66, 0x37,
    0x3f, 0x66, 0x38, 0x3f, 0x66, 0x39, 0x3f, 0x66, 0x3d, 0x3f, 0x66, 0x41,
    0x3f, 0x66, 0x5f, 0x3f, 0x66, 0x62, 0x3f, 0x66, 0x64, 0x3f, 0x66, 0x66,
    0x3f, 0x66, 0x67, 0x3f, 0x66, 0x68, 0x3f, 0x66, 0x6c, 0x3f, 0x66, 0x6d,
    0x3f, 0x66, 0x6e, 0x3f, 0x66, 0x70, 0x3f, 0x66, 0x72, 0x3f, 0x66, 0x75,
    0x3f, 0x66, 0x3a, 0x3f, 0x66, 0x42, 0x3f, 0x66, 0x43, 0x3f, 0x66, 0x44,
    0x3f, 0x66, 0x45, 0x3f, 0x66, 0x46, 0x3f, 0x66, 0x47, 0x3f, 0x66, 0x48,
    0x3f, 0x66, 0x49, 0x3f, 0x66, 0x4a, 0x3f, 0x66, 0x4b, 0x3f, 0x66, 0x4c,
    0x3f, 0x66, 0x4d, 0x3f, 0x66, 0x4e, 0x3f, 0x66, 0x4f, 0x3f, 0x66, 0x50,
    0x3f, 0x66, 0x51, 0x3f, 0x66, 0x52, 0x3f, 0x66, 0x53, 0x3f, 0x66, 0x54,
    0x3f, 0x66, 0x55, 0x3f, 0x66, 0x56, 0x3f, 0x66, 0x57, 0x3f, 0x66, 0x59,
    0x3f, 0x66, 0x6a, 0x3f, 0x66, 0x6b, 0x3f, 0x66, 0x71, 0x3f, 0x66, 0x76,
    0x3f, 0x66, 0x77, 0x3f, 0x66, 0x78, 0x3f, 0x66, 0x79, 0x3f, 0x66, 0x7a};
const uint8_t HuffDecoderCommon::table20_38_emit_[204] = {
    0x3f, 0x67, 0x30, 0x3f, 0x67, 0x31, 0x3f, 0x67, 0x32, 0x3f, 0x67, 0x61,
    0x3f, 0x67, 0x63, 0x3f, 0x67, 0x65, 0x3f, 0x67, 0x69, 0x3f, 0x67, 0x6f,
    0x3f, 0x67, 0x73, 0x3f, 0x67, 0x74, 0x3f, 0x67, 0x20, 0x3f, 0x67, 0x25,
    0x3f, 0x67, 0x2d, 0x3f, 0x67, 0x2e, 0x3f, 0x67, 0x2f, 0x3f, 0x67, 0x33,
    0x3f, 0x67, 0x34, 0x3f, 0x67, 0x35, 0x3f, 0x67, 0x36, 0x3f, 0x67, 0x37,
    0x3f, 0x67, 0x38, 0x3f, 0x67, 0x39, 0x3f, 0x67, 0x3d, 0x3f, 0x67, 0x41,
    0x3f, 0x67, 0x5f, 0x3f, 0x67, 0x62, 0x3f, 0x67, 0x64, 0x3f, 0x67, 0x66,
    0x3f, 0x67, 0x67, 0x3f, 0x67, 0x68, 0x3f, 0x67, 0x6c, 0x3f, 0x67, 0x6d,
    0x3f, 0x67, 0x6e, 0x3f, 0x67, 0x70, 0x3f, 0x67, 0x72, 0x3f, 0x67, 0x75,
    0x3f, 0x67, 0x3a, 0x3f, 0x67, 0x42, 0x3f, 0x67, 0x43, 0x3f, 0x67, 0x44,
    0x3f, 0x67, 0x45, 0x3f, 0x67, 0x46, 0x3f, 0x67, 0x47, 0x3f, 0x67, 0x48,
    0x3f, 0x67, 0x49, 0x3f, 0x67, 0x4a, 0x3f, 0x67, 0x4b, 0x3f, 0x67, 0x4c,
    0x3f, 0x67, 0x4d, 0x3f, 0x67, 0x4e, 0x3f, 0x67, 0x4f, 0x3f, 0x67, 0x50,
    0x3f, 0x67, 0x51, 0x3f, 0x67, 0x52, 0x3f, 0x67, 0x53, 0x3f, 0x67, 0x54,
    0x3f, 0x67, 0x55, 0x3f, 0x67, 0x56, 0x3f, 0x67, 0x57, 0x3f, 0x67, 0x59,
    0x3f, 0x67, 0x6a, 0x3f, 0x67, 0x6b, 0x3f, 0x67, 0x71, 0x3f, 0x67, 0x76,
    0x3f, 0x67, 0x77, 0x3f, 0x67, 0x78, 0x3f, 0x67, 0x79, 0x3f, 0x67, 0x7a};
const uint8_t HuffDecoderCommon::table20_39_emit_[204] = {
    0x3f, 0x68, 0x30, 0x3f, 0x68, 0x31, 0x3f, 0x68, 0x32, 0x3f, 0x68, 0x61,
    0x3f, 0x68, 0x63, 0x3f, 0x68, 0x65, 0x3f, 0x68, 0x69, 0x3f, 0x68, 0x6f,
    0x3f, 0x68, 0x73, 0x3f, 0x68, 0x74, 0x3f, 0x68, 0x20, 0x3f, 0x68, 0x25,
    0x3f, 0x68, 0x2d, 0x3f, 0x68, 0x2e, 0x3f, 0x68, 0x2f, 0x3f, 0x68, 0x33,
    0x3f, 0x68, 0x34, 0x3f, 0x68, 0x35, 0x3f, 0x68, 0x36, 0x3f, 0x68, 0x37,
    0x3f, 0x68, 0x38, 0x3f, 0x68, 0x39, 0x3f, 0x68, 0x3d, 0x3f, 0x68, 0x41,
    0x3f, 0x68, 0x5f, 0x3f, 0x68, 0x62, 0x3f, 0x68, 0x64, 0x3f, 0x68, 0x66,
    0x3f, 0x68, 0x67, 0x3f, 0x68, 0x68, 0x3f, 0x68, 0x6c, 0x3f, 0x68, 0x6d,
    0x3f, 0x68, 0x6e, 0x3f, 0x68, 0x70, 0x3f, 0x68, 0x72, 0x3f, 0x68, 0x75,
    0x3f, 0x68, 0x3a, 0x3f, 0x68, 0x42, 0x3f, 0x68, 0x43, 0x3f, 0x68, 0x44,
    0x3f, 0x68, 0x45, 0x3f, 0x68, 0x46, 0x3f, 0x68, 0x47, 0x3f, 0x68, 0x48,
    0x3f, 0x68, 0x49, 0x3f, 0x68, 0x4a, 0x3f, 0x68, 0x4b, 0x3f, 0x68, 0x4c,
    0x3f, 0x68, 0x4d, 0x3f, 0x68, 0x4e, 0x3f, 0x68, 0x4f, 0x3f, 0x68, 0x50,
    0x3f, 0x68, 0x51, 0x3f, 0x68, 0x52, 0x3f, 0x68, 0x53, 0x3f, 0x68, 0x54,
    0x3f, 0x68, 0x55, 0x3f, 0x68, 0x56, 0x3f, 0x68, 0x57, 0x3f, 0x68, 0x59,
    0x3f, 0x68, 0x6a, 0x3f, 0x68, 0x6b, 0x3f, 0x68, 0x71, 0x3f, 0x68, 0x76,
    0x3f, 0x68, 0x77, 0x3f, 0x68, 0x78, 0x3f, 0x68, 0x79, 0x3f, 0x68, 0x7a};
const uint8_t HuffDecoderCommon::table20_40_emit_[204] = {
    0x3f, 0x6c, 0x30, 0x3f, 0x6c, 0x31, 0x3f, 0x6c, 0x32, 0x3f, 0x6c, 0x61,
    0x3f, 0x6c, 0x63, 0x3f, 0x6c, 0x65, 0x3f, 0x6c, 0x69, 0x3f, 0x6c, 0x6f,
    0x3f, 0x6c, 0x73, 0x3f, 0x6c, 0x74, 0x3f, 0x6c, 0x20, 0x3f, 0x6c, 0x25,
    0x3f, 0x6c, 0x2d, 0x3f, 0x6c, 0x2e, 0x3f, 0x6c, 0x2f, 0x3f, 0x6c, 0x33,
    0x3f, 0x6c, 0x34, 0x3f, 0x6c, 0x35, 0x3f, 0x6c, 0x36, 0x3f, 0x6c, 0x37,
    0x3f, 0x6c, 0x38, 0x3f, 0x6c, 0x39, 0x3f, 0x6c, 0x3d, 0x3f, 0x6c, 0x41,
    0x3f, 0x6c, 0x5f, 0x3f, 0x6c, 0x62, 0x3f, 0x6c, 0x64, 0x3f, 0x6c, 0x66,
    0x3f, 0x6c, 0x67, 0x3f, 0x6c, 0x68, 0x3f, 0x6c, 0x6c, 0x3f, 0x6c, 0x6d,
    0x3f, 0x6c, 0x6e, 0x3f, 0x6c, 0x70, 0x3f, 0x6c, 0x72, 0x3f, 0x6c, 0x75,
    0x3f, 0x6c, 0x3a, 0x3f, 0x6c, 0x42, 0x3f, 0x6c, 0x43, 0x3f, 0x6c, 0x44,
    0x3f, 0x6c, 0x45, 0x3f, 0x6c, 0x46, 0x3f, 0x6c, 0x47, 0x3f, 0x6c, 0x48,
    0x3f, 0x6c, 0x49, 0x3f, 0x6c, 0x4a, 0x3f, 0x6c, 0x4b, 0x3f, 0x6c, 0x4c,
    0x3f, 0x6c, 0x4d, 0x3f, 0x6c, 0x4e, 0x3f, 0x6c, 0x4f, 0x3f, 0x6c, 0x50,
    0x3f, 0x6c, 0x51, 0x3f, 0x6c, 0x52, 0x3f, 0x6c, 0x53, 0x3f, 0x6c, 0x54,
    0x3f, 0x6c, 0x55, 0x3f, 0x6c, 0x56, 0x3f, 0x6c, 0x57, 0x3f, 0x6c, 0x59,
    0x3f, 0x6c, 0x6a, 0x3f, 0x6c, 0x6b, 0x3f, 0x6c, 0x71, 0x3f, 0x6c, 0x76,
    0x3f, 0x6c, 0x77, 0x3f, 0x6c, 0x78, 0x3f, 0x6c, 0x79, 0x3f, 0x6c, 0x7a};
const uint8_t HuffDecoderCommon::table20_41_emit_[204] = {
    0x3f, 0x6d, 0x30, 0x3f, 0x6d, 0x31, 0x3f, 0x6d, 0x32, 0x3f, 0x6d, 0x61,
    0x3f, 0x6d, 0x63, 0x3f, 0x6d, 0x65, 0x3f, 0x6d, 0x69, 0x3f, 0x6d, 0x6f,
    0x3f, 0x6d, 0x73, 0x3f, 0x6d, 0x74, 0x3f, 0x6d, 0x20, 0x3f, 0x6d, 0x25,
    0x3f, 0x6d, 0x2d, 0x3f, 0x6d, 0x2e, 0x3f, 0x6d, 0x2f, 0x3f, 0x6d, 0x33,
    0x3f, 0x6d, 0x34, 0x3f, 0x6d, 0x35, 0x3f, 0x6d, 0x36, 0x3f, 0x6d, 0x37,
    0x3f, 0x6d, 0x38, 0x3f, 0x6d, 0x39, 0x3f, 0x6d, 0x3d, 0x3f, 0x6d, 0x41,
    0x3f, 0x6d, 0x5f, 0x3f, 0x6d, 0x62, 0x3f, 0x6d, 0x64, 0x3f, 0x6d, 0x66,
    0x3f, 0x6d, 0x67, 0x3f, 0x6d, 0x68, 0x3f, 0x6d, 0x6c, 0x3f, 0x6d, 0x6d,
    0x3f, 0x6d, 0x6e, 0x3f, 0x6d, 0x70, 0x3f, 0x6d, 0x72, 0x3f, 0x6d, 0x75,
    0x3f, 0x6d, 0x3a, 0x3f, 0x6d, 0x42, 0x3f, 0x6d, 0x43, 0x3f, 0x6d, 0x44,
    0x3f, 0x6d, 0x45, 0x3f, 0x6d, 0x46, 0x3f, 0x6d, 0x47, 0x3f, 0x6d, 0x48,
    0x3f, 0x6d, 0x49, 0x3f, 0x6d, 0x4a, 0x3f, 0x6d, 0x4b, 0x3f, 0x6d, 0x4c,
    0x3f, 0x6d, 0x4d, 0x3f, 0x6d, 0x4e, 0x3f, 0x6d, 0x4f, 0x3f, 0x6d, 0x50,
    0x3f, 0x6d, 0x51, 0x3f, 0x6d, 0x52, 0x3f, 0x6d, 0x53, 0x3f, 0x6d, 0x54,
    0x3f, 0x6d, 0x55, 0x3f, 0x6d, 0x56, 0x3f, 0x6d, 0x57, 0x3f, 0x6d, 0x59,
    0x3f, 0x6d, 0x6a, 0x3f, 0x6d, 0x6b, 0x3f, 0x6d, 0x71, 0x3f, 0x6d, 0x76,
    0x3f, 0x6d, 0x77, 0x3f, 0x6d, 0x78, 0x3f, 0x6d, 0x79, 0x3f, 0x6d, 0x7a};
const uint8_t HuffDecoderCommon::table20_42_emit_[204] = {
    0x3f, 0x6e, 0x30, 0x3f, 0x6e, 0x31, 0x3f, 0x6e, 0x32, 0x3f, 0x6e, 0x61,
    0x3f, 0x6e, 0x63, 0x3f, 0x6e, 0x65, 0x3f, 0x6e, 0x69, 0x3f, 0x6e, 0x6f,
    0x3f, 0x6e, 0x73, 0x3f, 0x6e, 0x74, 0x3f, 0x6e, 0x20, 0x3f, 0x6e, 0x25,
    0x3f, 0x6e, 0x2d, 0x3f, 0x6e, 0x2e, 0x3f, 0x6e, 0x2f, 0x3f, 0x6e, 0x33,
    0x3f, 0x6e, 0x34, 0x3f, 0x6e, 0x35, 0x3f, 0x6e, 0x36, 0x3f, 0x6e, 0x37,
    0x3f, 0x6e, 0x38, 0x3f, 0x6e, 0x39, 0x3f, 0x6e, 0x3d, 0x3f, 0x6e, 0x41,
    0x3f, 0x6e, 0x5f, 0x3f, 0x6e, 0x62, 0x3f, 0x6e, 0x64, 0x3f, 0x6e, 0x66,
    0x3f, 0x6e, 0x67, 0x3f, 0x6e, 0x68, 0x3f, 0x6e, 0x6c, 0x3f, 0x6e, 0x6d,
    0x3f, 0x6e, 0x6e, 0x3f, 0x6e, 0x70, 0x3f, 0x6e, 0x72, 0x3f, 0x6e, 0x75,
    0x3f, 0x6e, 0x3a, 0x3f, 0x6e, 0x42, 0x3f, 0x6e, 0x43, 0x3f, 0x6e, 0x44,
    0x3f, 0x6e, 0x45, 0x3f, 0x6e, 0x46, 0x3f, 0x6e, 0x47, 0x3f, 0x6e, 0x48,
    0x3f, 0x6e, 0x49, 0x3f, 0x6e, 0x4a, 0x3f, 0x6e, 0x4b, 0x3f, 0x6e, 0x4c,
    0x3f, 0x6e, 0x4d, 0x3f, 0x6e, 0x4e, 0x3f, 0x6e, 0x4f, 0x3f, 0x6e, 0x50,
    0x3f, 0x6e, 0x51, 0x3f, 0x6e, 0x52, 0x3f, 0x6e, 0x53, 0x3f, 0x6e, 0x54,
    0x3f, 0x6e, 0x55, 0x3f, 0x6e, 0x56, 0x3f, 0x6e, 0x57, 0x3f, 0x6e, 0x59,
    0x3f, 0x6e, 0x6a, 0x3f, 0x6e, 0x6b, 0x3f, 0x6e, 0x71, 0x3f, 0x6e, 0x76,
    0x3f, 0x6e, 0x77, 0x3f, 0x6e, 0x78, 0x3f, 0x6e, 0x79, 0x3f, 0x6e, 0x7a};
const uint8_t HuffDecoderCommon::table20_43_emit_[204] = {
    0x3f, 0x70, 0x30, 0x3f, 0x70, 0x31, 0x3f, 0x70, 0x32, 0x3f, 0x70, 0x61,
    0x3f, 0x70, 0x63, 0x3f, 0x70, 0x65, 0x3f, 0x70, 0x69, 0x3f, 0x70, 0x6f,
    0x3f, 0x70, 0x73, 0x3f, 0x70, 0x74, 0x3f, 0x70, 0x20, 0x3f, 0x70, 0x25,
    0x3f, 0x70, 0x2d, 0x3f, 0x70, 0x2e, 0x3f, 0x70, 0x2f, 0x3f, 0x70, 0x33,
    0x3f, 0x70, 0x34, 0x3f, 0x70, 0x35, 0x3f, 0x70, 0x36, 0x3f, 0x70, 0x37,
    0x3f, 0x70, 0x38, 0x3f, 0x70, 0x39, 0x3f, 0x70, 0x3d, 0x3f, 0x70, 0x41,
    0x3f, 0x70, 0x5f, 0x3f, 0x70, 0x62, 0x3f, 0x70, 0x64, 0x3f, 0x70, 0x66,
    0x3f, 0x70, 0x67, 0x3f, 0x70, 0x68, 0x3f, 0x70, 0x6c, 0x3f, 0x70, 0x6d,
    0x3f, 0x70, 0x6e, 0x3f, 0x70, 0x70, 0x3f, 0x70, 0x72, 0x3f, 0x70, 0x75,
    0x3f, 0x70, 0x3a, 0x3f, 0x70, 0x42, 0x3f, 0x70, 0x43, 0x3f, 0x70, 0x44,
    0x3f, 0x70, 0x45, 0x3f, 0x70, 0x46, 0x3f, 0x70, 0x47, 0x3f, 0x70, 0x48,
    0x3f, 0x70, 0x49, 0x3f, 0x70, 0x4a, 0x3f, 0x70, 0x4b, 0x3f, 0x70, 0x4c,
    0x3f, 0x70, 0x4d, 0x3f, 0x70, 0x4e, 0x3f, 0x70, 0x4f, 0x3f, 0x70, 0x50,
    0x3f, 0x70, 0x51, 0x3f, 0x70, 0x52, 0x3f, 0x70, 0x53, 0x3f, 0x70, 0x54,
    0x3f, 0x70, 0x55, 0x3f, 0x70, 0x56, 0x3f, 0x70, 0x57, 0x3f, 0x70, 0x59,
    0x3f, 0x70, 0x6a, 0x3f, 0x70, 0x6b, 0x3f, 0x70, 0x71, 0x3f, 0x70, 0x76,
    0x3f, 0x70, 0x77, 0x3f, 0x70, 0x78, 0x3f, 0x70, 0x79, 0x3f, 0x70, 0x7a};
const uint8_t HuffDecoderCommon::table20_44_emit_[204] = {
    0x3f, 0x72, 0x30, 0x3f, 0x72, 0x31, 0x3f, 0x72, 0x32, 0x3f, 0x72, 0x61,
    0x3f, 0x72, 0x63, 0x3f, 0x72, 0x65, 0x3f, 0x72, 0x69, 0x3f, 0x72, 0x6f,
    0x3f, 0x72, 0x73, 0x3f, 0x72, 0x74, 0x3f, 0x72, 0x20, 0x3f, 0x72, 0x25,
    0x3f, 0x72, 0x2d, 0x3f, 0x72, 0x2e, 0x3f, 0x72, 0x2f, 0x3f, 0x72, 0x33,
    0x3f, 0x72, 0x34, 0x3f, 0x72, 0x35, 0x3f, 0x72, 0x36, 0x3f, 0x72, 0x37,
    0x3f, 0x72, 0x38, 0x3f, 0x72, 0x39, 0x3f, 0x72, 0x3d, 0x3f, 0x72, 0x41,
    0x3f, 0x72, 0x5f, 0x3f, 0x72, 0x62, 0x3f, 0x72, 0x64, 0x3f, 0x72, 0x66,
    0x3f, 0x72, 0x67, 0x3f, 0x72, 0x68, 0x3f, 0x72, 0x6c, 0x3f, 0x72, 0x6d,
    0x3f, 0x72, 0x6e, 0x3f, 0x72, 0x70, 0x3f, 0x72, 0x72, 0x3f, 0x72, 0x75,
    0x3f, 0x72, 0x3a, 0x3f, 0x72, 0x42, 0x3f, 0x72, 0x43, 0x3f, 0x72, 0x44,
    0x3f, 0x72, 0x45, 0x3f, 0x72, 0x46, 0x3f, 0x72, 0x47, 0x3f, 0x72, 0x48,
    0x3f, 0x72, 0x49, 0x3f, 0x72, 0x4a, 0x3f, 0x72, 0x4b, 0x3f, 0x72, 0x4c,
    0x3f, 0x72, 0x4d, 0x3f, 0x72, 0x4e, 0x3f, 0x72, 0x4f, 0x3f, 0x72, 0x50,
    0x3f, 0x72, 0x51, 0x3f, 0x72, 0x52, 0x3f, 0x72, 0x53, 0x3f, 0x72, 0x54,
    0x3f, 0x72, 0x55, 0x3f, 0x72, 0x56, 0x3f, 0x72, 0x57, 0x3f, 0x72, 0x59,
    0x3f, 0x72, 0x6a, 0x3f, 0x72, 0x6b, 0x3f, 0x72, 0x71, 0x3f, 0x72, 0x76,
    0x3f, 0x72, 0x77, 0x3f, 0x72, 0x78, 0x3f, 0x72, 0x79, 0x3f, 0x72, 0x7a};
const uint8_t HuffDecoderCommon::table20_45_emit_[204] = {
    0x3f, 0x75, 0x30, 0x3f, 0x75, 0x31, 0x3f, 0x75, 0x32, 0x3f, 0x75, 0x61,
    0x3f, 0x75, 0x63, 0x3f, 0x75, 0x65, 0x3f, 0x75, 0x69, 0x3f, 0x75, 0x6f,
    0x3f, 0x75, 0x73, 0x3f, 0x75, 0x74, 0x3f, 0x75, 0x20, 0x3f, 0x75, 0x25,
    0x3f, 0x75, 0x2d, 0x3f, 0x75, 0x2e, 0x3f, 0x75, 0x2f, 0x3f, 0x75, 0x33,
    0x3f, 0x75, 0x34, 0x3f, 0x75, 0x35, 0x3f, 0x75, 0x36, 0x3f, 0x75, 0x37,
    0x3f, 0x75, 0x38, 0x3f, 0x75, 0x39, 0x3f, 0x75, 0x3d, 0x3f, 0x75, 0x41,
    0x3f, 0x75, 0x5f, 0x3f, 0x75, 0x62, 0x3f, 0x75, 0x64, 0x3f, 0x75, 0x66,
    0x3f, 0x75, 0x67, 0x3f, 0x75, 0x68, 0x3f, 0x75, 0x6c, 0x3f, 0x75, 0x6d,
    0x3f, 0x75, 0x6e, 0x3f, 0x75, 0x70, 0x3f, 0x75, 0x72, 0x3f, 0x75, 0x75,
    0x3f, 0x75, 0x3a, 0x3f, 0x75, 0x42, 0x3f, 0x75, 0x43, 0x3f, 0x75, 0x44,
    0x3f, 0x75, 0x45, 0x3f, 0x75, 0x46, 0x3f, 0x75, 0x47, 0x3f, 0x75, 0x48,
    0x3f, 0x75, 0x49, 0x3f, 0x75, 0x4a, 0x3f, 0x75, 0x4b, 0x3f, 0x75, 0x4c,
    0x3f, 0x75, 0x4d, 0x3f, 0x75, 0x4e, 0x3f, 0x75, 0x4f, 0x3f, 0x75, 0x50,
    0x3f, 0x75, 0x51, 0x3f, 0x75, 0x52, 0x3f, 0x75, 0x53, 0x3f, 0x75, 0x54,
    0x3f, 0x75, 0x55, 0x3f, 0x75, 0x56, 0x3f, 0x75, 0x57, 0x3f, 0x75, 0x59,
    0x3f, 0x75, 0x6a, 0x3f, 0x75, 0x6b, 0x3f, 0x75, 0x71, 0x3f, 0x75, 0x76,
    0x3f, 0x75, 0x77, 0x3f, 0x75, 0x78, 0x3f, 0x75, 0x79, 0x3f, 0x75, 0x7a};
const uint8_t HuffDecoderCommon::table20_46_emit_[216] = {
    0x3f, 0x3a, 0x30, 0x3f, 0x3a, 0x31, 0x3f, 0x3a, 0x32, 0x3f, 0x3a, 0x61,
    0x3f, 0x3a, 0x63, 0x3f, 0x3a, 0x65, 0x3f, 0x3a, 0x69, 0x3f, 0x3a, 0x6f,
    0x3f, 0x3a, 0x73, 0x3f, 0x3a, 0x74, 0x3f, 0x3a, 0x20, 0x3f, 0x3a, 0x25,
    0x3f, 0x3a, 0x2d, 0x3f, 0x3a, 0x2e, 0x3f, 0x3a, 0x2f, 0x3f, 0x3a, 0x33,
    0x3f, 0x3a, 0x34, 0x3f, 0x3a, 0x35, 0x3f, 0x3a, 0x36, 0x3f, 0x3a, 0x37,
    0x3f, 0x3a, 0x38, 0x3f, 0x3a, 0x39, 0x3f, 0x3a, 0x3d, 0x3f, 0x3a, 0x41,
    0x3f, 0x3a, 0x5f, 0x3f, 0x3a, 0x62, 0x3f, 0x3a, 0x64, 0x3f, 0x3a, 0x66,
    0x3f, 0x3a, 0x67, 0x3f, 0x3a, 0x68, 0x3f, 0x3a, 0x6c, 0x3f, 0x3a, 0x6d,
    0x3f, 0x3a, 0x6e, 0x3f, 0x3a, 0x70, 0x3f, 0x3a, 0x72, 0x3f, 0x3a, 0x75,
    0x3f, 0x42, 0x30, 0x3f, 0x42, 0x31, 0x3f, 0x42, 0x32, 0x3f, 0x42, 0x61,
    0x3f, 0x42, 0x63, 0x3f, 0x42, 0x65, 0x3f, 0x42, 0x69, 0x3f, 0x42, 0x6f,
    0x3f, 0x42, 0x73, 0x3f, 0x42, 0x74, 0x3f, 0x42, 0x20, 0x3f, 0x42, 0x25,
    0x3f, 0x42, 0x2d, 0x3f, 0x42, 0x2e, 0x3f, 0x42, 0x2f, 0x3f, 0x42, 0x33,
    0x3f, 0x42, 0x34, 0x3f, 0x42, 0x35, 0x3f, 0x42, 0x36, 0x3f, 0x42, 0x37,
    0x3f, 0x42, 0x38, 0x3f, 0x42, 0x39, 0x3f, 0x42, 0x3d, 0x3f, 0x42, 0x41,
    0x3f, 0x42, 0x5f, 0x3f, 0x42, 0x62, 0x3f, 0x42, 0x64, 0x3f, 0x42, 0x66,
    0x3f, 0x42, 0x67, 0x3f, 0x42, 0x68, 0x3f, 0x42, 0x6c, 0x3f, 0x42, 0x6d,
    0x3f, 0x42, 0x6e, 0x3f, 0x42, 0x70, 0x3f, 0x42, 0x72, 0x3f, 0x42, 0x75};
const uint8_t HuffDecoderCommon::table20_47_emit_[216] = {
    0x3f, 0x43, 0x30, 0x3f, 0x43, 0x31, 0x3f, 0x43, 0x32, 0x3f, 0x43, 0x61,
    0x3f, 0x43, 0x63, 0x3f, 0x43, 0x65, 0x3f, 0x43, 0x69, 0x3f, 0x43, 0x6f,
    0x3f, 0x43, 0x73, 0x3f, 0x43, 0x74, 0x3f, 0x43, 0x20, 0x3f, 0x43, 0x25,
    0x3f, 0x43, 0x2d, 0x3f, 0x43, 0x2e, 0x3f, 0x43, 0x2f, 0x3f, 0x43, 0x33,
    0x3f, 0x43, 0x34, 0x3f, 0x43, 0x35, 0x3f, 0x43, 0x36, 0x3f, 0x43, 0x37,
    0x3f, 0x43, 0x38, 0x3f, 0x43, 0x39, 0x3f, 0x43, 0x3d, 0x3f, 0x43, 0x41,
    0x3f, 0x43, 0x5f, 0x3f, 0x43, 0x62, 0x3f, 0x43, 0x64, 0x3f, 0x43, 0x66,
    0x3f, 0x43, 0x67, 0x3f, 0x43, 0x68, 0x3f, 0x43, 0x6c, 0x3f, 0x43, 0x6d,
    0x3f, 0x43, 0x6e, 0x3f, 0x43, 0x70, 0x3f, 0x43, 0x72, 0x3f, 0x43, 0x75,
    0x3f, 0x44, 0x30, 0x3f, 0x44, 0x31, 0x3f, 0x44, 0x32, 0x3f, 0x44, 0x61,
    0x3f, 0x44, 0x63, 0x3f, 0x44, 0x65, 0x3f, 0x44, 0x69, 0x3f, 0x44, 0x6f,
    0x3f, 0x44, 0x73, 0x3f, 0x44, 0x74, 0x3f, 0x44, 0x20, 0x3f, 0x44, 0x25,
    0x3f, 0x44, 0x2d, 0x3f, 0x44, 0x2e, 0x3f, 0x44, 0x2f, 0x3f, 0x44, 0x33,
    0x3f, 0x44, 0x34, 0x3f, 0x44, 0x35, 0x3f, 0x44, 0x36, 0x3f, 0x44, 0x37,
    0x3f, 0x44, 0x38, 0x3f, 0x44, 0x39, 0x3f, 0x44, 0x3d, 0x3f, 0x44, 0x41,
    0x3f, 0x44, 0x5f, 0x3f, 0x44, 0x62, 0x3f, 0x44, 0x64, 0x3f, 0x44, 0x66,
    0x3f, 0x44, 0x67, 0x3f, 0x44, 0x68, 0x3f, 0x44, 0x6c, 0x3f, 0x44, 0x6d,
    0x3f, 0x44, 0x6e, 0x3f, 0x44, 0x70, 0x3f, 0x44, 0x72, 0x3f, 0x44, 0x75};
const uint8_t HuffDecoderCommon::table20_48_emit_[216] = {
    0x3f, 0x45, 0x30, 0x3f, 0x45, 0x31, 0x3f, 0x45, 0x32, 0x3f, 0x45, 0x61,
    0x3f, 0x45, 0x63, 0x3f, 0x45, 0x65, 0x3f, 0x45, 0x69, 0x3f, 0x45, 0x6f,
    0x3f, 0x45, 0x73, 0x3f, 0x45, 0x74, 0x3f, 0x45, 0x20, 0x3f, 0x45, 0x25,
    0x3f, 0x45, 0x2d, 0x3f, 0x45, 0x2e, 0x3f, 0x45, 0x2f, 0x3f, 0x45, 0x33,
    0x3f, 0x45, 0x34, 0x3f, 0x45, 0x35, 0x3f, 0x45, 0x36, 0x3f, 0x45, 0x37,
    0x3f, 0x45, 0x38, 0x3f, 0x45, 0x39, 0x3f, 0x45, 0x3d, 0x3f, 0x45, 0x41,
    0x3f, 0x45, 0x5f, 0x3f, 0x45, 0x62, 0x3f, 0x45, 0x64, 0x3f, 0x45, 0x66,
    0x3f, 0x45, 0x67, 0x3f, 0x45, 0x68, 0x3f, 0x45, 0x6c, 0x3f, 0x45, 0x6d,
    0x3f, 0x45, 0x6e, 0x3f, 0x45, 0x70, 0x3f, 0x45, 0x72, 0x3f, 0x45, 0x75,
    0x3f, 0x46, 0x30, 0x3f, 0x46, 0x31, 0x3f, 0x46, 0x32, 0x3f, 0x46, 0x61,
    0x3f, 0x46, 0x63, 0x3f, 0x46, 0x65, 0x3f, 0x46, 0x69, 0x3f, 0x46, 0x6f,
    0x3f, 0x46, 0x73, 0x3f, 0x46, 0x74, 0x3f, 0x46, 0x20, 0x3f, 0x46, 0x25,
    0x3f, 0x46, 0x2d, 0x3f, 0x46, 0x2e, 0x3f, 0x46, 0x2f, 0x3f, 0x46, 0x33,
    0x3f, 0x46, 0x34, 0x3f, 0x46, 0x35, 0x3f, 0x46, 0x36, 0x3f, 0x46, 0x37,
    0x3f, 0x46, 0x38, 0x3f, 0x46, 0x39, 0x3f, 0x46, 0x3d, 0x3f, 0x46, 0x41,
    0x3f, 0x46, 0x5f, 0x3f, 0x46, 0x62, 0x3f, 0x46, 0x64, 0x3f, 0x46, 0x66,
    0x3f, 0x46, 0x67, 0x3f, 0x46, 0x68, 0x3f, 0x46, 0x6c, 0x3f, 0x46, 0x6d,
    0x3f, 0x46, 0x6e, 0x3f, 0x46, 0x70, 0x3f, 0x46, 0x72, 0x3f, 0x46, 0x75};
const uint8_t HuffDecoderCommon::table20_49_emit_[216] = {
    0x3f, 0x47, 0x30, 0x3f, 0x47, 0x31, 0x3f, 0x47, 0x32, 0x3f, 0x47, 0x61,
    0x3f, 0x47, 0x63, 0x3f, 0x47, 0x65, 0x3f, 0x47, 0x69, 0x3f, 0x47, 0x6f,
    0x3f, 0x47, 0x73, 0x3f, 0x47, 0x74, 0x3f, 0x47, 0x20, 0x3f, 0x47, 0x25,
    0x3f, 0x47, 0x2d, 0x3f, 0x47, 0x2e, 0x3f, 0x47, 0x2f, 0x3f, 0x47, 0x33,
    0x3f, 0x47, 0x34, 0x3f, 0x47, 0x35, 0x3f, 0x47, 0x36, 0x3f, 0x47, 0x37,
    0x3f, 0x47, 0x38, 0x3f, 0x47, 0x39, 0x3f, 0x47, 0x3d, 0x3f, 0x47, 0x41,
    0x3f, 0x47, 0x5f, 0x3f, 0x47, 0x62, 0x3f, 0x47, 0x64, 0x3f, 0x47, 0x66,
    0x3f, 0x47, 0x67, 0x3f, 0x47, 0x68, 0x3f, 0x47, 0x6c, 0x3f, 0x47, 0x6d,
    0x3f, 0x47, 0x6e, 0x3f, 0x47, 0x70, 0x3f, 0x47, 0x72, 0x3f, 0x47, 0x75,
    0x3f, 0x48, 0x30, 0x3f, 0x48, 0x31, 0x3f, 0x48, 0x32, 0x3f, 0x48, 0x61,
    0x3f, 0x48, 0x63, 0x3f, 0x48, 0x65, 0x3f, 0x48, 0x69, 0x3f, 0x48, 0x6f,
    0x3f, 0x48, 0x73, 0x3f, 0x48, 0x74, 0x3f, 0x48, 0x20, 0x3f, 0x48, 0x25,
    0x3f, 0x48, 0x2d, 0x3f, 0x48, 0x2e, 0x3f, 0x48, 0x2f, 0x3f, 0x48, 0x33,
    0x3f, 0x48, 0x34, 0x3f, 0x48, 0x35, 0x3f, 0x48, 0x36, 0x3f, 0x48, 0x37,
    0x3f, 0x48, 0x38, 0x3f, 0x48, 0x39, 0x3f, 0x48, 0x3d, 0x3f, 0x48, 0x41,
    0x3f, 0x48, 0x5f, 0x3f, 0x48, 0x62, 0x3f, 0x48, 0x64, 0x3f, 0x48, 0x66,
    0x3f, 0x48, 0x67, 0x3f, 0x48, 0x68, 0x3f, 0x48, 0x6c, 0x3f, 0x48, 0x6d,
    0x3f, 0x48, 0x6e, 0x3f, 0x48, 0x70, 0x3f, 0x48, 0x72, 0x3f, 0x48, 0x75};
const uint8_t HuffDecoderCommon::table20_50_emit_[216] = {
    0x3f, 0x49, 0x30, 0x3f, 0x49, 0x31, 0x3f, 0x49, 0x32, 0x3f, 0x49, 0x61,
    0x3f, 0x49, 0x63, 0x3f, 0x49, 0x65, 0x3f, 0x49, 0x69, 0x3f, 0x49, 0x6f,
    0x3f, 0x49, 0x73, 0x3f, 0x49, 0x74, 0x3f, 0x49, 0x20, 0x3f, 0x49, 0x25,
    0x3f, 0x49, 0x2d, 0x3f, 0x49, 0x2e, 0x3f, 0x49, 0x2f, 0x3f, 0x49, 0x33,
    0x3f, 0x49, 0x34, 0x3f, 0x49, 0x35, 0x3f, 0x49, 0x36, 0x3f, 0x49, 0x37,
    0x3f, 0x49, 0x38, 0x3f, 0x49, 0x39, 0x3f, 0x49, 0x3d, 0x3f, 0x49, 0x41,
    0x3f, 0x49, 0x5f, 0x3f, 0x49, 0x62, 0x3f, 0x49, 0x64, 0x3f, 0x49, 0x66,
    0x3f, 0x49, 0x67, 0x3f, 0x49, 0x68, 0x3f, 0x49, 0x6c, 0x3f, 0x49, 0x6d,
    0x3f, 0x49, 0x6e, 0x3f, 0x49, 0x70, 0x3f, 0x49, 0x72, 0x3f, 0x49, 0x75,
    0x3f, 0x4a, 0x30, 0x3f, 0x4a, 0x31, 0x3f, 0x4a, 0x32, 0x3f, 0x4a, 0x61,
    0x3f, 0x4a, 0x63, 0x3f, 0x4a, 0x65, 0x3f, 0x4a, 0x69, 0x3f, 0x4a, 0x6f,
    0x3f, 0x4a, 0x73, 0x3f, 0x4a, 0x74, 0x3f, 0x4a, 0x20, 0x3f, 0x4a, 0x25,
    0x3f, 0x4a, 0x2d, 0x3f, 0x4a, 0x2e, 0x3f, 0x4a, 0x2f, 0x3f, 0x4a, 0x33,
    0x3f, 0x4a, 0x34, 0x3f, 0x4a, 0x35, 0x3f, 0x4a, 0x36, 0x3f, 0x4a, 0x37,
    0x3f, 0x4a, 0x38, 0x3f, 0x4a, 0x39, 0x3f, 0x4a, 0x3d, 0x3f, 0x4a, 0x41,
    0x3f, 0x4a, 0x5f, 0x3f, 0x4a, 0x62, 0x3f, 0x4a, 0x64, 0x3f, 0x4a, 0x66,
    0x3f, 0x4a, 0x67, 0x3f, 0x4a, 0x68, 0x3f, 0x4a, 0x6c, 0x3f, 0x4a, 0x6d,
    0x3f, 0x4a, 0x6e, 0x3f, 0x4a, 0x70, 0x3f, 0x4a, 0x72, 0x3f, 0x4a, 0x75};
const uint8_t HuffDecoderCommon::table20_51_emit_[216] = {
    0x3f, 0x4b, 0x30, 0x3f, 0x4b, 0x31, 0x3f, 0x4b, 0x32, 0x3f, 0x4b, 0x61,
    0x3f, 0x4b, 0x63, 0x3f, 0x4b, 0x65, 0x3f, 0x4b, 0x69, 0x3f, 0x4b, 0x6f,
    0x3f, 0x4b, 0x73, 0x3f, 0x4b, 0x74, 0x3f, 0x4b, 0x20, 0x3f, 0x4b, 0x25,
    0x3f, 0x4b, 0x2d, 0x3f, 0x4b, 0x2e, 0x3f, 0x4b, 0x2f, 0x3f, 0x4b, 0x33,
    0x3f, 0x4b, 0x34, 0x3f, 0x4b, 0x35, 0x3f, 0x4b, 0x36, 0x3f, 0x4b, 0x37,
    0x3f, 0x4b, 0x38, 0x3f, 0x4b, 0x39, 0x3f, 0x4b, 0x3d, 0x3f, 0x4b, 0x41,
    0x3f, 0x4b, 0x5f, 0x3f, 0x4b, 0x62, 0x3f, 0x4b, 0x64, 0x3f, 0x4b, 0x66,
    0x3f, 0x4b, 0x67, 0x3f, 0x4b, 0x68, 0x3f, 0x4b, 0x6c, 0x3f, 0x4b, 0x6d,
    0x3f, 0x4b, 0x6e, 0x3f, 0x4b, 0x70, 0x3f, 0x4b, 0x72, 0x3f, 0x4b, 0x75,
    0x3f, 0x4c, 0x30, 0x3f, 0x4c, 0x31, 0x3f, 0x4c, 0x32, 0x3f, 0x4c, 0x61,
    0x3f, 0x4c, 0x63, 0x3f, 0x4c, 0x65, 0x3f, 0x4c, 0x69, 0x3f, 0x4c, 0x6f,
    0x3f, 0x4c, 0x73, 0x3f, 0x4c, 0x74, 0x3f, 0x4c, 0x20, 0x3f, 0x4c, 0x25,
    0x3f, 0x4c, 0x2d, 0x3f, 0x4c, 0x2e, 0x3f, 0x4c, 0x2f, 0x3f, 0x4c, 0x33,
    0x3f, 0x4c, 0x34, 0x3f, 0x4c, 0x35, 0x3f, 0x4c, 0x36, 0x3f, 0x4c, 0x37,
    0x3f, 0x4c, 0x38, 0x3f, 0x4c, 0x39, 0x3f, 0x4c, 0x3d, 0x3f, 0x4c, 0x41,
    0x3f, 0x4c, 0x5f, 0x3f, 0x4c, 0x62, 0x3f, 0x4c, 0x64, 0x3f, 0x4c, 0x66,
    0x3f, 0x4c, 0x67, 0x3f, 0x4c, 0x68, 0x3f, 0x4c, 0x6c, 0x3f, 0x4c, 0x6d,
    0x3f, 0x4c, 0x6e, 0x3f, 0x4c, 0x70, 0x3f, 0x4c, 0x72, 0x3f, 0x4c, 0x75};
const uint8_t HuffDecoderCommon::table20_52_emit_[216] = {
    0x3f, 0x4d, 0x30, 0x3f, 0x4d, 0x31, 0x3f, 0x4d, 0x32, 0x3f, 0x4d, 0x61,
    0x3f, 0x4d, 0x63, 0x3f, 0x4d, 0x65, 0x3f, 0x4d, 0x69, 0x3f, 0x4d, 0x6f,
    0x3f, 0x4d, 0x73, 0x3f, 0x4d, 0x74, 0x3f, 0x4d, 0x20, 0x3f, 0x4d, 0x25,
    0x3f, 0x4d, 0x2d, 0x3f, 0x4d, 0x2e, 0x3f, 0x4d, 0x2f, 0x3f, 0x4d, 0x33,
    0x3f, 0x4d, 0x34, 0x3f, 0x4d, 0x35, 0x3f, 0x4d, 0x36, 0x3f, 0x4d, 0x37,
    0x3f, 0x4d, 0x38, 0x3f, 0x4d, 0x39, 0x3f, 0x4d, 0x3d, 0x3f, 0x4d, 0x41,
    0x3f, 0x4d, 0x5f, 0x3f, 0x4d, 0x62, 0x3f, 0x4d, 0x64, 0x3f, 0x4d, 0x66,
    0x3f, 0x4d, 0x67, 0x3f, 0x4d, 0x68, 0x3f, 0x4d, 0x6c, 0x3f, 0x4d, 0x6d,
    0x3f, 0x4d, 0x6e, 0x3f, 0x4d, 0x70, 0x3f, 0x4d, 0x72, 0x3f, 0x4d, 0x75,
    0x3f, 0x4e, 0x30, 0x3f, 0x4e, 0x31, 0x3f, 0x4e, 0x32, 0x3f, 0x4e, 0x61,
    0x3f, 0x4e, 0x63, 0x3f, 0x4e, 0x65, 0x3f, 0x4e, 0x69, 0x3f, 0x4e, 0x6f,
    0x3f, 0x4e, 0x73, 0x3f, 0x4e, 0x74, 0x3f, 0x4e, 0x20, 0x3f, 0x4e, 0x25,
    0x3f, 0x4e, 0x2d, 0x3f, 0x4e, 0x2e, 0x3f, 0x4e, 0x2f, 0x3f, 0x4e, 0x33,
    0x3f, 0x4e, 0x34, 0x3f, 0x4e, 0x35, 0x3f, 0x4e, 0x36, 0x3f, 0x4e, 0x37,
    0x3f, 0x4e, 0x38, 0x3f, 0x4e, 0x39, 0x3f, 0x4e, 0x3d, 0x3f, 0x4e, 0x41,
    0x3f, 0x4e, 0x5f, 0x3f, 0x4e, 0x62, 0x3f, 0x4e, 0x64, 0x3f, 0x4e, 0x66,
    0x3f, 0x4e, 0x67, 0x3f, 0x4e, 0x68, 0x3f, 0x4e, 0x6c, 0x3f, 0x4e, 0x6d,
    0x3f, 0x4e, 0x6e, 0x3f, 0x4e, 0x70, 0x3f, 0x4e, 0x72, 0x3f, 0x4e, 0x75};
const uint8_t HuffDecoderCommon::table20_53_emit_[216] = {
    0x3f, 0x4f, 0x30, 0x3f, 0x4f, 0x31, 0x3f, 0x4f, 0x32, 0x3f, 0x4f, 0x61,
    0x3f, 0x4f, 0x63, 0x3f, 0x4f, 0x65, 0x3f, 0x4f, 0x69, 0x3f, 0x4f, 0x6f,
    0x3f, 0x4f, 0x73, 0x3f, 0x4f, 0x74, 0x3f, 0x4f, 0x20, 0x3f, 0x4f, 0x25,
    0x3f, 0x4f, 0x2d, 0x3f, 0x4f, 0x2e, 0x3f, 0x4f, 0x2f, 0x3f, 0x4f, 0x33,
    0x3f, 0x4f, 0x34, 0x3f, 0x4f, 0x35, 0x3f, 0x4f, 0x36, 0x3f, 0x4f, 0x37,
    0x3f, 0x4f, 0x38, 0x3f, 0x4f, 0x39, 0x3f, 0x4f, 0x3d, 0x3f, 0x4f, 0x41,
    0x3f, 0x4f, 0x5f, 0x3f, 0x4f, 0x62, 0x3f, 0x4f, 0x64, 0x3f, 0x4f, 0x66,
    0x3f, 0x4f, 0x67, 0x3f, 0x4f, 0x68, 0x3f, 0x4f, 0x6c, 0x3f, 0x4f, 0x6d,
    0x3f, 0x4f, 0x6e, 0x3f, 0x4f, 0x70, 0x3f, 0x4f, 0x72, 0x3f, 0x4f, 0x75,
    0x3f, 0x50, 0x30, 0x3f, 0x50, 0x31, 0x3f, 0x50, 0x32, 0x3f, 0x50, 0x61,
    0x3f, 0x50, 0x63, 0x3f, 0x50, 0x65, 0x3f, 0x50, 0x69, 0x3f, 0x50, 0x6f,
    0x3f, 0x50, 0x73, 0x3f, 0x50, 0x74, 0x3f, 0x50, 0x20, 0x3f, 0x50, 0x25,
    0x3f, 0x50, 0x2d, 0x3f, 0x50, 0x2e, 0x3f, 0x50, 0x2f, 0x3f, 0x50, 0x33,
    0x3f, 0x50, 0x34, 0x3f, 0x50, 0x35, 0x3f, 0x50, 0x36, 0x3f, 0x50, 0x37,
    0x3f, 0x50, 0x38, 0x3f, 0x50, 0x39, 0x3f, 0x50, 0x3d, 0x3f, 0x50, 0x41,
    0x3f, 0x50, 0x5f, 0x3f, 0x50, 0x62, 0x3f, 0x50, 0x64, 0x3f, 0x50, 0x66,
    0x3f, 0x50, 0x67, 0x3f, 0x50, 0x68, 0x3f, 0x50, 0x6c, 0x3f, 0x50, 0x6d,
    0x3f, 0x50, 0x6e, 0x3f, 0x50, 0x70, 0x3f, 0x50, 0x72, 0x3f, 0x50, 0x75};
const uint8_t HuffDecoderCommon::table20_54_emit_[216] = {
    0x3f, 0x51, 0x30, 0x3f, 0x51, 0x31, 0x3f, 0x51, 0x32, 0x3f, 0x51, 0x61,
    0x3f, 0x51, 0x63, 0x3f, 0x51, 0x65, 0x3f, 0x51, 0x69, 0x3f, 0x51, 0x6f,
    0x3f, 0x51, 0x73, 0x3f, 0x51, 0x74, 0x3f, 0x51, 0x20, 0x3f, 0x51, 0x25,
    0x3f, 0x51, 0x2d, 0x3f, 0x51, 0x2e, 0x3f, 0x51, 0x2f, 0x3f, 0x51, 0x33,
    0x3f, 0x51, 0x34, 0x3f, 0x51, 0x35, 0x3f, 0x51, 0x36, 0x3f, 0x51, 0x37,
    0x3f, 0x51, 0x38, 0x3f, 0x51, 0x39, 0x3f, 0x51, 0x3d, 0x3f, 0x51, 0x41,
    0x3f, 0x51, 0x5f, 0x3f, 0x51, 0x62, 0x3f, 0x51, 0x64, 0x3f, 0x51, 0x66,
    0x3f, 0x51, 0x67, 0x3f, 0x51, 0x68, 0x3f, 0x51, 0x6c, 0x3f, 0x51, 0x6d,
    0x3f, 0x51, 0x6e, 0x3f, 0x51, 0x70, 0x3f, 0x51, 0x72, 0x3f, 0x51, 0x75,
    0x3f, 0x52, 0x30, 0x3f, 0x52, 0x31, 0x3f, 0x52, 0x32, 0x3f, 0x52, 0x61,
    0x3f, 0x52, 0x63, 0x3f, 0x52, 0x65, 0x3f, 0x52, 0x69, 0x3f, 0x52, 0x6f,
    0x3f, 0x52, 0x73, 0x3f, 0x52, 0x74, 0x3f, 0x52, 0x20, 0x3f, 0x52, 0x25,
    0x3f, 0x52, 0x2d, 0x3f, 0x52, 0x2e, 0x3f, 0x52, 0x2f, 0x3f, 0x52, 0x33,
    0x3f, 0x52, 0x34, 0x3f, 0x52, 0x35, 0x3f, 0x52, 0x36, 0x3f, 0x52, 0x37,
    0x3f, 0x52, 0x38, 0x3f, 0x52, 0x39, 0x3f, 0x52, 0x3d, 0x3f, 0x52, 0x41,
    0x3f, 0x52, 0x5f, 0x3f, 0x52, 0x62, 0x3f, 0x52, 0x64, 0x3f, 0x52, 0x66,
    0x3f, 0x52, 0x67, 0x3f, 0x52, 0x68, 0x3f, 0x52, 0x6c, 0x3f, 0x52, 0x6d,
    0x3f, 0x52, 0x6e, 0x3f, 0x52, 0x70, 0x3f, 0x52, 0x72, 0x3f, 0x52, 0x75};
const uint8_t HuffDecoderCommon::table20_55_emit_[216] = {
    0x3f, 0x53, 0x30, 0x3f, 0x53, 0x31, 0x3f, 0x53, 0x32, 0x3f, 0x53, 0x61,
    0x3f, 0x53, 0x63, 0x3f, 0x53, 0x65, 0x3f, 0x53, 0x69, 0x3f, 0x53, 0x6f,
    0x3f, 0x53, 0x73, 0x3f, 0x53, 0x74, 0x3f, 0x53, 0x20, 0x3f, 0x53, 0x25,
    0x3f, 0x53, 0x2d, 0x3f, 0x53, 0x2e, 0x3f, 0x53, 0x2f, 0x3f, 0x53, 0x33,
    0x3f, 0x53, 0x34, 0x3f, 0x53, 0x35, 0x3f, 0x53, 0x36, 0x3f, 0x53, 0x37,
    0x3f, 0x53, 0x38, 0x3f, 0x53, 0x39, 0x3f, 0x53, 0x3d, 0x3f, 0x53, 0x41,
    0x3f, 0x53, 0x5f, 0x3f, 0x53, 0x62, 0x3f, 0x53, 0x64, 0x3f, 0x53, 0x66,
    0x3f, 0x53, 0x67, 0x3f, 0x53, 0x68, 0x3f, 0x53, 0x6c, 0x3f, 0x53, 0x6d,
    0x3f, 0x53, 0x6e, 0x3f, 0x53, 0x70, 0x3f, 0x53, 0x72, 0x3f, 0x53, 0x75,
    0x3f, 0x54, 0x30, 0x3f, 0x54, 0x31, 0x3f, 0x54, 0x32, 0x3f, 0x54, 0x61,
    0x3f, 0x54, 0x63, 0x3f, 0x54, 0x65, 0x3f, 0x54, 0x69, 0x3f, 0x54, 0x6f,
    0x3f, 0x54, 0x73, 0x3f, 0x54, 0x74, 0x3f, 0x54, 0x20, 0x3f, 0x54, 0x25,
    0x3f, 0x54, 0x2d, 0x3f, 0x54, 0x2e, 0x3f, 0x54, 0x2f, 0x3f, 0x54, 0x33,
    0x3f, 0x54, 0x34, 0x3f, 0x54, 0x35, 0x3f, 0x54, 0x36, 0x3f, 0x54, 0x37,
    0x3f, 0x54, 0x38, 0x3f, 0x54, 0x39, 0x3f, 0x54, 0x3d, 0x3f, 0x54, 0x41,
    0x3f, 0x54, 0x5f, 0x3f, 0x54, 0x62, 0x3f, 0x54, 0x64, 0x3f, 0x54, 0x66,
    0x3f, 0x54, 0x67, 0x3f, 0x54, 0x68, 0x3f, 0x54, 0x6c, 0x3f, 0x54, 0x6d,
    0x3f, 0x54, 0x6e, 0x3f, 0x54, 0x70, 0x3f, 0x54, 0x72, 0x3f, 0x54, 0x75};
const uint8_t HuffDecoderCommon::table20_56_emit_[216] = {
    0x3f, 0x55, 0x30, 0x3f, 0x55, 0x31, 0x3f, 0x55, 0x32, 0x3f, 0x55, 0x61,
    0x3f, 0x55, 0x63, 0x3f, 0x55, 0x65, 0x3f, 0x55, 0x69, 0x3f, 0x55, 0x6f,
    0x3f, 0x55, 0x73, 0x3f, 0x55, 0x74, 0x3f, 0x55, 0x20, 0x3f, 0x55, 0x25,
    0x3f, 0x55, 0x2d, 0x3f, 0x55, 0x2e, 0x3f, 0x55, 0x2f, 0x3f, 0x55, 0x33,
    0x3f, 0x55, 0x34, 0x3f, 0x55, 0x35, 0x3f, 0x55, 0x36, 0x3f, 0x55, 0x37,
    0x3f, 0x55, 0x38, 0x3f, 0x55, 0x39, 0x3f, 0x55, 0x3d, 0x3f, 0x55, 0x41,
    0x3f, 0x55, 0x5f, 0x3f, 0x55, 0x62, 0x3f, 0x55, 0x64, 0x3f, 0x55, 0x66,
    0x3f, 0x55, 0x67, 0x3f, 0x55, 0x68, 0x3f, 0x55, 0x6c, 0x3f, 0x55, 0x6d,
    0x3f, 0x55, 0x6e, 0x3f, 0x55, 0x70, 0x3f, 0x55, 0x72, 0x3f, 0x55, 0x75,
    0x3f, 0x56, 0x30, 0x3f, 0x56, 0x31, 0x3f, 0x56, 0x32, 0x3f, 0x56, 0x61,
    0x3f, 0x56, 0x63, 0x3f, 0x56, 0x65, 0x3f, 0x56, 0x69, 0x3f, 0x56, 0x6f,
    0x3f, 0x56, 0x73, 0x3f, 0x56, 0x74, 0x3f, 0x56, 0x20, 0x3f, 0x56, 0x25,
    0x3f, 0x56, 0x2d, 0x3f, 0x56, 0x2e, 0x3f, 0x56, 0x2f, 0x3f, 0x56, 0x33,
    0x3f, 0x56, 0x34, 0x3f, 0x56, 0x35, 0x3f, 0x56, 0x36, 0x3f, 0x56, 0x37,
    0x3f, 0x56, 0x38, 0x3f, 0x56, 0x39, 0x3f, 0x56, 0x3d, 0x3f, 0x56, 0x41,
    0x3f, 0x56, 0x5f, 0x3f, 0x56, 0x62, 0x3f, 0x56, 0x64, 0x3f, 0x56, 0x66,
    0x3f, 0x56, 0x67, 0x3f, 0x56, 0x68, 0x3f, 0x56, 0x6c, 0x3f, 0x56, 0x6d,
    0x3f, 0x56, 0x6e, 0x3f, 0x56, 0x70, 0x3f, 0x56, 0x72, 0x3f, 0x56, 0x75};
const uint8_t HuffDecoderCommon::table20_57_emit_[216] = {
    0x3f, 0x57, 0x30, 0x3f, 0x57, 0x31, 0x3f, 0x57, 0x32, 0x3f, 0x57, 0x61,
    0x3f, 0x57, 0x63, 0x3f, 0x57, 0x65, 0x3f, 0x57, 0x69, 0x3f, 0x57, 0x6f,
    0x3f, 0x57, 0x73, 0x3f, 0x57, 0x74, 0x3f, 0x57, 0x20, 0x3f, 0x57, 0x25,
    0x3f, 0x57, 0x2d, 0x3f, 0x57, 0x2e, 0x3f, 0x57, 0x2f, 0x3f, 0x57, 0x33,
    0x3f, 0x57, 0x34, 0x3f, 0x57, 0x35, 0x3f, 0x57, 0x36, 0x3f, 0x57, 0x37,
    0x3f, 0x57, 0x38, 0x3f, 0x57, 0x39, 0x3f, 0x57, 0x3d, 0x3f, 0x57, 0x41,
    0x3f, 0x57, 0x5f, 0x3f, 0x57, 0x62, 0x3f, 0x57, 0x64, 0x3f, 0x57, 0x66,
    0x3f, 0x57, 0x67, 0x3f, 0x57, 0x68, 0x3f, 0x57, 0x6c, 0x3f, 0x57, 0x6d,
    0x3f, 0x57, 0x6e, 0x3f, 0x57, 0x70, 0x3f, 0x57, 0x72, 0x3f, 0x57, 0x75,
    0x3f, 0x59, 0x30, 0x3f, 0x59, 0x31, 0x3f, 0x59, 0x32, 0x3f, 0x59, 0x61,
    0x3f, 0x59, 0x63, 0x3f, 0x59, 0x65, 0x3f, 0x59, 0x69, 0x3f, 0x59, 0x6f,
    0x3f, 0x59, 0x73, 0x3f, 0x59, 0x74, 0x3f, 0x59, 0x20, 0x3f, 0x59, 0x25,
    0x3f, 0x59, 0x2d, 0x3f, 0x59, 0x2e, 0x3f, 0x59, 0x2f, 0x3f, 0x59, 0x33,
    0x3f, 0x59, 0x34, 0x3f, 0x59, 0x35, 0x3f, 0x59, 0x36, 0x3f, 0x59, 0x37,
    0x3f, 0x59, 0x38, 0x3f, 0x59, 0x39, 0x3f, 0x59, 0x3d, 0x3f, 0x59, 0x41,
    0x3f, 0x59, 0x5f, 0x3f, 0x59, 0x62, 0x3f, 0x59, 0x64, 0x3f, 0x59, 0x66,
    0x3f, 0x59, 0x67, 0x3f, 0x59, 0x68, 0x3f, 0x59, 0x6c, 0x3f, 0x59, 0x6d,
    0x3f, 0x59, 0x6e, 0x3f, 0x59, 0x70, 0x3f, 0x59, 0x72, 0x3f, 0x59, 0x75};
const uint8_t HuffDecoderCommon::table20_58_emit_[216] = {
    0x3f, 0x6a, 0x30, 0x3f, 0x6a, 0x31, 0x3f, 0x6a, 0x32, 0x3f, 0x6a, 0x61,
    0x3f, 0x6a, 0x63, 0x3f, 0x6a, 0x65, 0x3f, 0x6a, 0x69, 0x3f, 0x6a, 0x6f,
    0x3f, 0x6a, 0x73, 0x3f, 0x6a, 0x74, 0x3f, 0x6a, 0x20, 0x3f, 0x6a, 0x25,
    0x3f, 0x6a, 0x2d, 0x3f, 0x6a, 0x2e, 0x3f, 0x6a, 0x2f, 0x3f, 0x6a, 0x33,
    0x3f, 0x6a, 0x34, 0x3f, 0x6a, 0x35, 0x3f, 0x6a, 0x36, 0x3f, 0x6a, 0x37,
    0x3f, 0x6a, 0x38, 0x3f, 0x6a, 0x39, 0x3f, 0x6a, 0x3d, 0x3f, 0x6a, 0x41,
    0x3f, 0x6a, 0x5f, 0x3f, 0x6a, 0x62, 0x3f, 0x6a, 0x64, 0x3f, 0x6a, 0x66,
    0x3f, 0x6a, 0x67, 0x3f, 0x6a, 0x68, 0x3f, 0x6a, 0x6c, 0x3f, 0x6a, 0x6d,
    0x3f, 0x6a, 0x6e, 0x3f, 0x6a, 0x70, 0x3f, 0x6a, 0x72, 0x3f, 0x6a, 0x75,
    0x3f, 0x6b, 0x30, 0x3f, 0x6b, 0x31, 0x3f, 0x6b, 0x32, 0x3f, 0x6b, 0x61,
    0x3f, 0x6b, 0x63, 0x3f, 0x6b, 0x65, 0x3f, 0x6b, 0x69, 0x3f, 0x6b, 0x6f,
    0x3f, 0x6b, 0x73, 0x3f, 0x6b, 0x74, 0x3f, 0x6b, 0x20, 0x3f, 0x6b, 0x25,
    0x3f, 0x6b, 0x2d, 0x3f, 0x6b, 0x2e, 0x3f, 0x6b, 0x2f, 0x3f, 0x6b, 0x33,
    0x3f, 0x6b, 0x34, 0x3f, 0x6b, 0x35, 0x3f, 0x6b, 0x36, 0x3f, 0x6b, 0x37,
    0x3f, 0x6b, 0x38, 0x3f, 0x6b, 0x39, 0x3f, 0x6b, 0x3d, 0x3f, 0x6b, 0x41,
    0x3f, 0x6b, 0x5f, 0x3f, 0x6b, 0x62, 0x3f, 0x6b, 0x64, 0x3f, 0x6b, 0x66,
    0x3f, 0x6b, 0x67, 0x3f, 0x6b, 0x68, 0x3f, 0x6b, 0x6c, 0x3f, 0x6b, 0x6d,
    0x3f, 0x6b, 0x6e, 0x3f, 0x6b, 0x70, 0x3f, 0x6b, 0x72, 0x3f, 0x6b, 0x75};
const uint8_t HuffDecoderCommon::table20_59_emit_[216] = {
    0x3f, 0x71, 0x30, 0x3f, 0x71, 0x31, 0x3f, 0x71, 0x32, 0x3f, 0x71, 0x61,
    0x3f, 0x71, 0x63, 0x3f, 0x71, 0x65, 0x3f, 0x71, 0x69, 0x3f, 0x71, 0x6f,
    0x3f, 0x71, 0x73, 0x3f, 0x71, 0x74, 0x3f, 0x71, 0x20, 0x3f, 0x71, 0x25,
    0x3f, 0x71, 0x2d, 0x3f, 0x71, 0x2e, 0x3f, 0x71, 0x2f, 0x3f, 0x71, 0x33,
    0x3f, 0x71, 0x34, 0x3f, 0x71, 0x35, 0x3f, 0x71, 0x36, 0x3f, 0x71, 0x37,
    0x3f, 0x71, 0x38, 0x3f, 0x71, 0x39, 0x3f, 0x71, 0x3d, 0x3f, 0x71, 0x41,
    0x3f, 0x71, 0x5f, 0x3f, 0x71, 0x62, 0x3f, 0x71, 0x64, 0x3f, 0x71, 0x66,
    0x3f, 0x71, 0x67, 0x3f, 0x71, 0x68, 0x3f, 0x71, 0x6c, 0x3f, 0x71, 0x6d,
    0x3f, 0x71, 0x6e, 0x3f, 0x71, 0x70, 0x3f, 0x71, 0x72, 0x3f, 0x71, 0x75,
    0x3f, 0x76, 0x30, 0x3f, 0x76, 0x31, 0x3f, 0x76, 0x32, 0x3f, 0x76, 0x61,
    0x3f, 0x76, 0x63, 0x3f, 0x76, 0x65, 0x3f, 0x76, 0x69, 0x3f, 0x76, 0x6f,
    0x3f, 0x76, 0x73, 0x3f, 0x76, 0x74, 0x3f, 0x76, 0x20, 0x3f, 0x76, 0x25,
    0x3f, 0x76, 0x2d, 0x3f, 0x76, 0x2e, 0x3f, 0x76, 0x2f, 0x3f, 0x76, 0x33,
    0x3f, 0x76, 0x34, 0x3f, 0x76, 0x35, 0x3f, 0x76, 0x36, 0x3f, 0x76, 0x37,
    0x3f, 0x76, 0x38, 0x3f, 0x76, 0x39, 0x3f, 0x76, 0x3d, 0x3f, 0x76, 0x41,
    0x3f, 0x76, 0x5f, 0x3f, 0x76, 0x62, 0x3f, 0x76, 0x64, 0x3f, 0x76, 0x66,
    0x3f, 0x76, 0x67, 0x3f, 0x76, 0x68, 0x3f, 0x76, 0x6c, 0x3f, 0x76, 0x6d,
    0x3f, 0x76, 0x6e, 0x3f, 0x76, 0x70, 0x3f, 0x76, 0x72, 0x3f, 0x76, 0x75};
const uint8_t HuffDecoderCommon::table20_60_emit_[216] = {
    0x3f, 0x77, 0x30, 0x3f, 0x77, 0x31, 0x3f, 0x77, 0x32, 0x3f, 0x77, 0x61,
    0x3f, 0x77, 0x63, 0x3f, 0x77, 0x65, 0x3f, 0x77, 0x69, 0x3f, 0x77, 0x6f,
    0x3f, 0x77, 0x73, 0x3f, 0x77, 0x74, 0x3f, 0x77, 0x20, 0x3f, 0x77, 0x25,
    0x3f, 0x77, 0x2d, 0x3f, 0x77, 0x2e, 0x3f, 0x77, 0x2f, 0x3f, 0x77, 0x33,
    0x3f, 0x77, 0x34, 0x3f, 0x77, 0x35, 0x3f, 0x77, 0x36, 0x3f, 0x77, 0x37,
    0x3f, 0x77, 0x38, 0x3f, 0x77, 0x39, 0x3f, 0x77, 0x3d, 0x3f, 0x77, 0x41,
    0x3f, 0x77, 0x5f, 0x3f, 0x77, 0x62, 0x3f, 0x77, 0x64, 0x3f, 0x77, 0x66,
    0x3f, 0x77, 0x67, 0x3f, 0x77, 0x68, 0x3f, 0x77, 0x6c, 0x3f, 0x77, 0x6d,
    0x3f, 0x77, 0x6e, 0x3f, 0x77, 0x70, 0x3f, 0x77, 0x72, 0x3f, 0x77, 0x75,
    0x3f, 0x78, 0x30, 0x3f, 0x78, 0x31, 0x3f, 0x78, 0x32, 0x3f, 0x78, 0x61,
    0x3f, 0x78, 0x63, 0x3f, 0x78, 0x65, 0x3f, 0x78, 0x69, 0x3f, 0x78, 0x6f,
    0x3f, 0x78, 0x73, 0x3f, 0x78, 0x74, 0x3f, 0x78, 0x20, 0x3f, 0x78, 0x25,
    0x3f, 0x78, 0x2d, 0x3f, 0x78, 0x2e, 0x3f, 0x78, 0x2f, 0x3f, 0x78, 0x33,
    0x3f, 0x78, 0x34, 0x3f, 0x78, 0x35, 0x3f, 0x78, 0x36, 0x3f, 0x78, 0x37,
    0x3f, 0x78, 0x38, 0x3f, 0x78, 0x39, 0x3f, 0x78, 0x3d, 0x3f, 0x78, 0x41,
    0x3f, 0x78, 0x5f, 0x3f, 0x78, 0x62, 0x3f, 0x78, 0x64, 0x3f, 0x78, 0x66,
    0x3f, 0x78, 0x67, 0x3f, 0x78, 0x68, 0x3f, 0x78, 0x6c, 0x3f, 0x78, 0x6d,
    0x3f, 0x78, 0x6e, 0x3f, 0x78, 0x70, 0x3f, 0x78, 0x72, 0x3f, 0x78, 0x75};
const uint8_t HuffDecoderCommon::table20_61_emit_[216] = {
    0x3f, 0x79, 0x30, 0x3f, 0x79, 0x31, 0x3f, 0x79, 0x32, 0x3f, 0x79, 0x61,
    0x3f, 0x79, 0x63, 0x3f, 0x79, 0x65, 0x3f, 0x79, 0x69, 0x3f, 0x79, 0x6f,
    0x3f, 0x79, 0x73, 0x3f, 0x79, 0x74, 0x3f, 0x79, 0x20, 0x3f, 0x79, 0x25,
    0x3f, 0x79, 0x2d, 0x3f, 0x79, 0x2e, 0x3f, 0x79, 0x2f, 0x3f, 0x79, 0x33,
    0x3f, 0x79, 0x34, 0x3f, 0x79, 0x35, 0x3f, 0x79, 0x36, 0x3f, 0x79, 0x37,
    0x3f, 0x79, 0x38, 0x3f, 0x79, 0x39, 0x3f, 0x79, 0x3d, 0x3f, 0x79, 0x41,
    0x3f, 0x79, 0x5f, 0x3f, 0x79, 0x62, 0x3f, 0x79, 0x64, 0x3f, 0x79, 0x66,
    0x3f, 0x79, 0x67, 0x3f, 0x79, 0x68, 0x3f, 0x79, 0x6c, 0x3f, 0x79, 0x6d,
    0x3f, 0x79, 0x6e, 0x3f, 0x79, 0x70, 0x3f, 0x79, 0x72, 0x3f, 0x79, 0x75,
    0x3f, 0x7a, 0x30, 0x3f, 0x7a, 0x31, 0x3f, 0x7a, 0x32, 0x3f, 0x7a, 0x61,
    0x3f, 0x7a, 0x63, 0x3f, 0x7a, 0x65, 0x3f, 0x7a, 0x69, 0x3f, 0x7a, 0x6f,
    0x3f, 0x7a, 0x73, 0x3f, 0x7a, 0x74, 0x3f, 0x7a, 0x20, 0x3f, 0x7a, 0x25,
    0x3f, 0x7a, 0x2d, 0x3f, 0x7a, 0x2e, 0x3f, 0x7a, 0x2f, 0x3f, 0x7a, 0x33,
    0x3f, 0x7a, 0x34, 0x3f, 0x7a, 0x35, 0x3f, 0x7a, 0x36, 0x3f, 0x7a, 0x37,
    0x3f, 0x7a, 0x38, 0x3f, 0x7a, 0x39, 0x3f, 0x7a, 0x3d, 0x3f, 0x7a, 0x41,
    0x3f, 0x7a, 0x5f, 0x3f, 0x7a, 0x62, 0x3f, 0x7a, 0x64, 0x3f, 0x7a, 0x66,
    0x3f, 0x7a, 0x67, 0x3f, 0x7a, 0x68, 0x3f, 0x7a, 0x6c, 0x3f, 0x7a, 0x6d,
    0x3f, 0x7a, 0x6e, 0x3f, 0x7a, 0x70, 0x3f, 0x7a, 0x72, 0x3f, 0x7a, 0x75};
const uint8_t HuffDecoderCommon::table20_62_emit_[120] = {
    0x3f, 0x26, 0x30, 0x3f, 0x26, 0x31, 0x3f, 0x26, 0x32, 0x3f, 0x26, 0x61,
    0x3f, 0x26, 0x63, 0x3f, 0x26, 0x65, 0x3f, 0x26, 0x69, 0x3f, 0x26, 0x6f,
    0x3f, 0x26, 0x73, 0x3f, 0x26, 0x74, 0x3f, 0x2a, 0x30, 0x3f, 0x2a, 0x31,
    0x3f, 0x2a, 0x32, 0x3f, 0x2a, 0x61, 0x3f, 0x2a, 0x63, 0x3f, 0x2a, 0x65,
    0x3f, 0x2a, 0x69, 0x3f, 0x2a, 0x6f, 0x3f, 0x2a, 0x73, 0x3f, 0x2a, 0x74,
    0x3f, 0x2c, 0x30, 0x3f, 0x2c, 0x31, 0x3f, 0x2c, 0x32, 0x3f, 0x2c, 0x61,
    0x3f, 0x2c, 0x63, 0x3f, 0x2c, 0x65, 0x3f, 0x2c, 0x69, 0x3f, 0x2c, 0x6f,
    0x3f, 0x2c, 0x73, 0x3f, 0x2c, 0x74, 0x3f, 0x3b, 0x30, 0x3f, 0x3b, 0x31,
    0x3f, 0x3b, 0x32, 0x3f, 0x3b, 0x61, 0x3f, 0x3b, 0x63, 0x3f, 0x3b, 0x65,
    0x3f, 0x3b, 0x69, 0x3f, 0x3b, 0x6f, 0x3f, 0x3b, 0x73, 0x3f, 0x3b, 0x74};
const uint8_t HuffDecoderCommon::table20_63_emit_[91] = {
    0x3f, 0x58, 0x30, 0x3f, 0x58, 0x31, 0x3f, 0x58, 0x32, 0x3f, 0x58, 0x61,
    0x3f, 0x58, 0x63, 0x3f, 0x58, 0x65, 0x3f, 0x58, 0x69, 0x3f, 0x58, 0x6f,
    0x3f, 0x58, 0x73, 0x3f, 0x58, 0x74, 0x3f, 0x5a, 0x30, 0x3f, 0x5a, 0x31,
    0x3f, 0x5a, 0x32, 0x3f, 0x5a, 0x61, 0x3f, 0x5a, 0x63, 0x3f, 0x5a, 0x65,
    0x3f, 0x5a, 0x69, 0x3f, 0x5a, 0x6f, 0x3f, 0x5a, 0x73, 0x3f, 0x5a, 0x74,
    0x3f, 0x21, 0x3f, 0x22, 0x3f, 0x28, 0x3f, 0x29, 0x3f, 0x3f, 0x27, 0x3f,
    0x2b, 0x3f, 0x7c, 0x3f, 0x23, 0x3f, 0x3e, 0x3f, 0x00, 0x3f, 0x24, 0x3f,
    0x40, 0x3f, 0x5b, 0x3f, 0x5d, 0x3f, 0x7e};
const uint16_t HuffDecoderCommon::table20_63_ops_[128] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9, 0x00c1,
    0x00d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x00f1, 0x0109, 0x0121, 0x0139,
    0x0151, 0x0169, 0x0181, 0x0199, 0x01b1, 0x01c9, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x00f2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01e2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f2, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0202, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0212, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0222, 0x0000, 0x0000, 0x0000, 0x022a,
    0x0000, 0x0000, 0x0000, 0x023a, 0x0000, 0x0000, 0x0000, 0x024a, 0x0000,
    0x025a, 0x0000, 0x026a, 0x027a, 0x028a, 0x029a, 0x02aa, 0x02ba, 0x02ca,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table20_64_emit_[204] = {
    0x27, 0x30, 0x30, 0x27, 0x30, 0x31, 0x27, 0x30, 0x32, 0x27, 0x30, 0x61,
    0x27, 0x30, 0x63, 0x27, 0x30, 0x65, 0x27, 0x30, 0x69, 0x27, 0x30, 0x6f,
    0x27, 0x30, 0x73, 0x27, 0x30, 0x74, 0x27, 0x30, 0x20, 0x27, 0x30, 0x25,
    0x27, 0x30, 0x2d, 0x27, 0x30, 0x2e, 0x27, 0x30, 0x2f, 0x27, 0x30, 0x33,
    0x27, 0x30, 0x34, 0x27, 0x30, 0x35, 0x27, 0x30, 0x36, 0x27, 0x30, 0x37,
    0x27, 0x30, 0x38, 0x27, 0x30, 0x39, 0x27, 0x30, 0x3d, 0x27, 0x30, 0x41,
    0x27, 0x30, 0x5f, 0x27, 0x30, 0x62, 0x27, 0x30, 0x64, 0x27, 0x30, 0x66,
    0x27, 0x30, 0x67, 0x27, 0x30, 0x68, 0x27, 0x30, 0x6c, 0x27, 0x30, 0x6d,
    0x27, 0x30, 0x6e, 0x27, 0x30, 0x70, 0x27, 0x30, 0x72, 0x27, 0x30, 0x75,
    0x27, 0x30, 0x3a, 0x27, 0x30, 0x42, 0x27, 0x30, 0x43, 0x27, 0x30, 0x44,
    0x27, 0x30, 0x45, 0x27, 0x30, 0x46, 0x27, 0x30, 0x47, 0x27, 0x30, 0x48,
    0x27, 0x30, 0x49, 0x27, 0x30, 0x4a, 0x27, 0x30, 0x4b, 0x27, 0x30, 0x4c,
    0x27, 0x30, 0x4d, 0x27, 0x30, 0x4e, 0x27, 0x30, 0x4f, 0x27, 0x30, 0x50,
    0x27, 0x30, 0x51, 0x27, 0x30, 0x52, 0x27, 0x30, 0x53, 0x27, 0x30, 0x54,
    0x27, 0x30, 0x55, 0x27, 0x30, 0x56, 0x27, 0x30, 0x57, 0x27, 0x30, 0x59,
    0x27, 0x30, 0x6a, 0x27, 0x30, 0x6b, 0x27, 0x30, 0x71, 0x27, 0x30, 0x76,
    0x27, 0x30, 0x77, 0x27, 0x30, 0x78, 0x27, 0x30, 0x79, 0x27, 0x30, 0x7a};
const uint8_t HuffDecoderCommon::table20_65_emit_[204] = {
    0x27, 0x31, 0x30, 0x27, 0x31, 0x31, 0x27, 0x31, 0x32, 0x27, 0x31, 0x61,
    0x27, 0x31, 0x63, 0x27, 0x31, 0x65, 0x27, 0x31, 0x69, 0x27, 0x31, 0x6f,
    0x27, 0x31, 0x73, 0x27, 0x31, 0x74, 0x27, 0x31, 0x20, 0x27, 0x31, 0x25,
    0x27, 0x31, 0x2d, 0x27, 0x31, 0x2e, 0x27, 0x31, 0x2f, 0x27, 0x31, 0x33,
    0x27, 0x31, 0x34, 0x27, 0x31, 0x35, 0x27, 0x31, 0x36, 0x27, 0x31, 0x37,
    0x27, 0x31, 0x38, 0x27, 0x31, 0x39, 0x27, 0x31, 0x3d, 0x27, 0x31, 0x41,
    0x27, 0x31, 0x5f, 0x27, 0x31, 0x62, 0x27, 0x31, 0x64, 0x27, 0x31, 0x66,
    0x27, 0x31, 0x67, 0x27, 0x31, 0x68, 0x27, 0x31, 0x6c, 0x27, 0x31, 0x6d,
    0x27, 0x31, 0x6e, 0x27, 0x31, 0x70, 0x27, 0x31, 0x72, 0x27, 0x31, 0x75,
    0x27, 0x31, 0x3a, 0x27, 0x31, 0x42, 0x27, 0x31, 0x43, 0x27, 0x31, 0x44,
    0x27, 0x31, 0x45, 0x27, 0x31, 0x46, 0x27, 0x31, 0x47, 0x27, 0x31, 0x48,
    0x27, 0x31, 0x49, 0x27, 0x31, 0x4a, 0x27, 0x31, 0x4b, 0x27, 0x31, 0x4c,
    0x27, 0x31, 0x4d, 0x27, 0x31, 0x4e, 0x27, 0x31, 0x4f, 0x27, 0x31, 0x50,
    0x27, 0x31, 0x51, 0x27, 0x31, 0x52, 0x27, 0x31, 0x53, 0x27, 0x31, 0x54,
    0x27, 0x31, 0x55, 0x27, 0x31, 0x56, 0x27, 0x31, 0x57, 0x27, 0x31, 0x59,
    0x27, 0x31, 0x6a, 0x27, 0x31, 0x6b, 0x27, 0x31, 0x71, 0x27, 0x31, 0x76,
    0x27, 0x31, 0x77, 0x27, 0x31, 0x78, 0x27, 0x31, 0x79, 0x27, 0x31, 0x7a};
const uint8_t HuffDecoderCommon::table20_66_emit_[204] = {
    0x27, 0x32, 0x30, 0x27, 0x32, 0x31, 0x27, 0x32, 0x32, 0x27, 0x32, 0x61,
    0x27, 0x32, 0x63, 0x27, 0x32, 0x65, 0x27, 0x32, 0x69, 0x27, 0x32, 0x6f,
    0x27, 0x32, 0x73, 0x27, 0x32, 0x74, 0x27, 0x32, 0x20, 0x27, 0x32, 0x25,
    0x27, 0x32, 0x2d, 0x27, 0x32, 0x2e, 0x27, 0x32, 0x2f, 0x27, 0x32, 0x33,
    0x27, 0x32, 0x34, 0x27, 0x32, 0x35, 0x27, 0x32, 0x36, 0x27, 0x32, 0x37,
    0x27, 0x32, 0x38, 0x27, 0x32, 0x39, 0x27, 0x32, 0x3d, 0x27, 0x32, 0x41,
    0x27, 0x32, 0x5f, 0x27, 0x32, 0x62, 0x27, 0x32, 0x64, 0x27, 0x32, 0x66,
    0x27, 0x32, 0x67, 0x27, 0x32, 0x68, 0x27, 0x32, 0x6c, 0x27, 0x32, 0x6d,
    0x27, 0x32, 0x6e, 0x27, 0x32, 0x70, 0x27, 0x32, 0x72, 0x27, 0x32, 0x75,
    0x27, 0x32, 0x3a, 0x27, 0x32, 0x42, 0x27, 0x32, 0x43, 0x27, 0x32, 0x44,
    0x27, 0x32, 0x45, 0x27, 0x32, 0x46, 0x27, 0x32, 0x47, 0x27, 0x32, 0x48,
    0x27, 0x32, 0x49, 0x27, 0x32, 0x4a, 0x27, 0x32, 0x4b, 0x27, 0x32, 0x4c,
    0x27, 0x32, 0x4d, 0x27, 0x32, 0x4e, 0x27, 0x32, 0x4f, 0x27, 0x32, 0x50,
    0x27, 0x32, 0x51, 0x27, 0x32, 0x52, 0x27, 0x32, 0x53, 0x27, 0x32, 0x54,
    0x27, 0x32, 0x55, 0x27, 0x32, 0x56, 0x27, 0x32, 0x57, 0x27, 0x32, 0x59,
    0x27, 0x32, 0x6a, 0x27, 0x32, 0x6b, 0x27, 0x32, 0x71, 0x27, 0x32, 0x76,
    0x27, 0x32, 0x77, 0x27, 0x32, 0x78, 0x27, 0x32, 0x79, 0x27, 0x32, 0x7a};
const uint8_t HuffDecoderCommon::table20_67_emit_[204] = {
    0x27, 0x61, 0x30, 0x27, 0x61, 0x31, 0x27, 0x61, 0x32, 0x27, 0x61, 0x61,
    0x27, 0x61, 0x63, 0x27, 0x61, 0x65, 0x27, 0x61, 0x69, 0x27, 0x61, 0x6f,
    0x27, 0x61, 0x73, 0x27, 0x61, 0x74, 0x27, 0x61, 0x20, 0x27, 0x61, 0x25,
    0x27, 0x61, 0x2d, 0x27, 0x61, 0x2e, 0x27, 0x61, 0x2f, 0x27, 0x61, 0x33,
    0x27, 0x61, 0x34, 0x27, 0x61, 0x35, 0x27, 0x61, 0x36, 0x27, 0x61, 0x37,
    0x27, 0x61, 0x38, 0x27, 0x61, 0x39, 0x27, 0x61, 0x3d, 0x27, 0x61, 0x41,
    0x27, 0x61, 0x5f, 0x27, 0x61, 0x62, 0x27, 0x61, 0x64, 0x27, 0x61, 0x66,
    0x27, 0x61, 0x67, 0x27, 0x61, 0x68, 0x27, 0x61, 0x6c, 0x27, 0x61, 0x6d,
    0x27, 0x61, 0x6e, 0x27, 0x61, 0x70, 0x27, 0x61, 0x72, 0x27, 0x61, 0x75,
    0x27, 0x61, 0x3a, 0x27, 0x61, 0x42, 0x27, 0x61, 0x43, 0x27, 0x61, 0x44,
    0x27, 0x61, 0x45, 0x27, 0x61, 0x46, 0x27, 0x61, 0x47, 0x27, 0x61, 0x48,
    0x27, 0x61, 0x49, 0x27, 0x61, 0x4a, 0x27, 0x61, 0x4b, 0x27, 0x61, 0x4c,
    0x27, 0x61, 0x4d, 0x27, 0x61, 0x4e, 0x27, 0x61, 0x4f, 0x27, 0x61, 0x50,
    0x27, 0x61, 0x51, 0x27, 0x61, 0x52, 0x27, 0x61, 0x53, 0x27, 0x61, 0x54,
    0x27, 0x61, 0x55, 0x27, 0x61, 0x56, 0x27, 0x61, 0x57, 0x27, 0x61, 0x59,
    0x27, 0x61, 0x6a, 0x27, 0x61, 0x6b, 0x27, 0x61, 0x71, 0x27, 0x61, 0x76,
    0x27, 0x61, 0x77, 0x27, 0x61, 0x78, 0x27, 0x61, 0x79, 0x27, 0x61, 0x7a};
const uint8_t HuffDecoderCommon::table20_68_emit_[204] = {
    0x27, 0x63, 0x30, 0x27, 0x63, 0x31, 0x27, 0x63, 0x32, 0x27, 0x63, 0x61,
    0x27, 0x63, 0x63, 0x27, 0x63, 0x65, 0x27, 0x63, 0x69, 0x27, 0x63, 0x6f,
    0x27, 0x63, 0x73, 0x27, 0x63, 0x74, 0x27, 0x63, 0x20, 0x27, 0x63, 0x25,
    0x27, 0x63, 0x2d, 0x27, 0x63, 0x2e, 0x27, 0x63, 0x2f, 0x27, 0x63, 0x33,
    0x27, 0x63, 0x34, 0x27, 0x63, 0x35, 0x27, 0x63, 0x36, 0x27, 0x63, 0x37,
    0x27, 0x63, 0x38, 0x27, 0x63, 0x39, 0x27, 0x63, 0x3d, 0x27, 0x63, 0x41,
    0x27, 0x63, 0x5f, 0x27, 0x63, 0x62, 0x27, 0x63, 0x64, 0x27, 0x63, 0x66,
    0x27, 0x63, 0x67, 0x27, 0x63, 0x68, 0x27, 0x63, 0x6c, 0x27, 0x63, 0x6d,
    0x27, 0x63, 0x6e, 0x27, 0x63, 0x70, 0x27, 0x63, 0x72, 0x27, 0x63, 0x75,
    0x27, 0x63, 0x3a, 0x27, 0x63, 0x42, 0x27, 0x63, 0x43, 0x27, 0x63, 0x44,
    0x27, 0x63, 0x45, 0x27, 0x63, 0x46, 0x27, 0x63, 0x47, 0x27, 0x63, 0x48,
    0x27, 0x63, 0x49, 0x27, 0x63, 0x4a, 0x27, 0x63, 0x4b, 0x27, 0x63, 0x4c,
    0x27, 0x63, 0x4d, 0x27, 0x63, 0x4e, 0x27, 0x63, 0x4f, 0x27, 0x63, 0x50,
    0x27, 0x63, 0x51, 0x27, 0x63, 0x52, 0x27, 0x63, 0x53, 0x27, 0x63, 0x54,
    0x27, 0x63, 0x55, 0x27, 0x63, 0x56, 0x27, 0x63, 0x57, 0x27, 0x63, 0x59,
    0x27, 0x63, 0x6a, 0x27, 0x63, 0x6b, 0x27, 0x63, 0x71, 0x27, 0x63, 0x76,
    0x27, 0x63, 0x77, 0x27, 0x63, 0x78, 0x27, 0x63, 0x79, 0x27, 0x63, 0x7a};
const uint8_t HuffDecoderCommon::table20_69_emit_[204] = {
    0x27, 0x65, 0x30, 0x27, 0x65, 0x31, 0x27, 0x65, 0x32, 0x27, 0x65, 0x61,
    0x27, 0x65, 0x63, 0x27, 0x65, 0x65, 0x27, 0x65, 0x69, 0x27, 0x65, 0x6f,
    0x27, 0x65, 0x73, 0x27, 0x65, 0x74, 0x27, 0x65, 0x20, 0x27, 0x65, 0x25,
    0x27, 0x65, 0x2d, 0x27, 0x65, 0x2e, 0x27, 0x65, 0x2f, 0x27, 0x65, 0x33,
    0x27, 0x65, 0x34, 0x27, 0x65, 0x35, 0x27, 0x65, 0x36, 0x27, 0x65, 0x37,
    0x27, 0x65, 0x38, 0x27, 0x65, 0x39, 0x27, 0x65, 0x3d, 0x27, 0x65, 0x41,
    0x27, 0x65, 0x5f, 0x27, 0x65, 0x62, 0x27, 0x65, 0x64, 0x27, 0x65, 0x66,
    0x27, 0x65, 0x67, 0x27, 0x65, 0x68, 0x27, 0x65, 0x6c, 0x27, 0x65, 0x6d,
    0x27, 0x65, 0x6e, 0x27, 0x65, 0x70, 0x27, 0x65, 0x72, 0x27, 0x65, 0x75,
    0x27, 0x65, 0x3a, 0x27, 0x65, 0x42, 0x27, 0x65, 0x43, 0x27, 0x65, 0x44,
    0x27, 0x65, 0x45, 0x27, 0x65, 0x46, 0x27, 0x65, 0x47, 0x27, 0x65, 0x48,
    0x27, 0x65, 0x49, 0x27, 0x65, 0x4a, 0x27, 0x65, 0x4b, 0x27, 0x65, 0x4c,
    0x27, 0x65, 0x4d, 0x27, 0x65, 0x4e, 0x27, 0x65, 0x4f, 0x27, 0x65, 0x50,
    0x27, 0x65, 0x51, 0x27, 0x65, 0x52, 0x27, 0x65, 0x53, 0x27, 0x65, 0x54,
    0x27, 0x65, 0x55, 0x27, 0x65, 0x56, 0x27, 0x65, 0x57, 0x27, 0x65, 0x59,
    0x27, 0x65, 0x6a, 0x27, 0x65, 0x6b, 0x27, 0x65, 0x71, 0x27, 0x65, 0x76,
    0x27, 0x65, 0x77, 0x27, 0x65, 0x78, 0x27, 0x65, 0x79, 0x27, 0x65, 0x7a};
const uint8_t HuffDecoderCommon::table20_70_emit_[204] = {
    0x27, 0x69, 0x30, 0x27, 0x69, 0x31, 0x27, 0x69, 0x32, 0x27, 0x69, 0x61,
    0x27, 0x69, 0x63, 0x27, 0x69, 0x65, 0x27, 0x69, 0x69, 0x27, 0x69, 0x6f,
    0x27, 0x69, 0x73, 0x27, 0x69, 0x74, 0x27, 0x69, 0x20, 0x27, 0x69, 0x25,
    0x27, 0x69, 0x2d, 0x27, 0x69, 0x2e, 0x27, 0x69, 0x2f, 0x27, 0x69, 0x33,
    0x27, 0x69, 0x34, 0x27, 0x69, 0x35, 0x27, 0x69, 0x36, 0x27, 0x69, 0x37,
    0x27, 0x69, 0x38, 0x27, 0x69, 0x39, 0x27, 0x69, 0x3d, 0x27, 0x69, 0x41,
    0x27, 0x69, 0x5f, 0x27, 0x69, 0x62, 0x27, 0x69, 0x64, 0x27, 0x69, 0x66,
    0x27, 0x69, 0x67, 0x27, 0x69, 0x68, 0x27, 0x69, 0x6c, 0x27, 0x69, 0x6d,
    0x27, 0x69, 0x6e, 0x27, 0x69, 0x70, 0x27, 0x69, 0x72, 0x27, 0x69, 0x75,
    0x27, 0x69, 0x3a, 0x27, 0x69, 0x42, 0x27, 0x69, 0x43, 0x27, 0x69, 0x44,
    0x27, 0x69, 0x45, 0x27, 0x69, 0x46, 0x27, 0x69, 0x47, 0x27, 0x69, 0x48,
    0x27, 0x69, 0x49, 0x27, 0x69, 0x4a, 0x27, 0x69, 0x4b, 0x27, 0x69, 0x4c,
    0x27, 0x69, 0x4d, 0x27, 0x69, 0x4e, 0x27, 0x69, 0x4f, 0x27, 0x69, 0x50,
    0x27, 0x69, 0x51, 0x27, 0x69, 0x52, 0x27, 0x69, 0x53, 0x27, 0x69, 0x54,
    0x27, 0x69, 0x55, 0x27, 0x69, 0x56, 0x27, 0x69, 0x57, 0x27, 0x69, 0x59,
    0x27, 0x69, 0x6a, 0x27, 0x69, 0x6b, 0x27, 0x69, 0x71, 0x27, 0x69, 0x76,
    0x27, 0x69, 0x77, 0x27, 0x69, 0x78, 0x27, 0x69, 0x79, 0x27, 0x69, 0x7a};
const uint8_t HuffDecoderCommon::table20_71_emit_[204] = {
    0x27, 0x6f, 0x30, 0x27, 0x6f, 0x31, 0x27, 0x6f, 0x32, 0x27, 0x6f, 0x61,
    0x27, 0x6f, 0x63, 0x27, 0x6f, 0x65, 0x27, 0x6f, 0x69, 0x27, 0x6f, 0x6f,
    0x27, 0x6f, 0x73, 0x27, 0x6f, 0x74, 0x27, 0x6f, 0x20, 0x27, 0x6f, 0x25,
    0x27, 0x6f, 0x2d, 0x27, 0x6f, 0x2e, 0x27, 0x6f, 0x2f, 0x27, 0x6f, 0x33,
    0x27, 0x6f, 0x34, 0x27, 0x6f, 0x35, 0x27, 0x6f, 0x36, 0x27, 0x6f, 0x37,
    0x27, 0x6f, 0x38, 0x27, 0x6f, 0x39, 0x27, 0x6f, 0x3d, 0x27, 0x6f, 0x41,
    0x27, 0x6f, 0x5f, 0x27, 0x6f, 0x62, 0x27, 0x6f, 0x64, 0x27, 0x6f, 0x66,
    0x27, 0x6f, 0x67, 0x27, 0x6f, 0x68, 0x27, 0x6f, 0x6c, 0x27, 0x6f, 0x6d,
    0x27, 0x6f, 0x6e, 0x27, 0x6f, 0x70, 0x27, 0x6f, 0x72, 0x27, 0x6f, 0x75,
    0x27, 0x6f, 0x3a, 0x27, 0x6f, 0x42, 0x27, 0x6f, 0x43, 0x27, 0x6f, 0x44,
    0x27, 0x6f, 0x45, 0x27, 0x6f, 0x46, 0x27, 0x6f, 0x47, 0x27, 0x6f, 0x48,
    0x27, 0x6f, 0x49, 0x27, 0x6f, 0x4a, 0x27, 0x6f, 0x4b, 0x27, 0x6f, 0x4c,
    0x27, 0x6f, 0x4d, 0x27, 0x6f, 0x4e, 0x27, 0x6f, 0x4f, 0x27, 0x6f, 0x50,
    0x27, 0x6f, 0x51, 0x27, 0x6f, 0x52, 0x27, 0x6f, 0x53, 0x27, 0x6f, 0x54,
    0x27, 0x6f, 0x55, 0x27, 0x6f, 0x56, 0x27, 0x6f, 0x57, 0x27, 0x6f, 0x59,
    0x27, 0x6f, 0x6a, 0x27, 0x6f, 0x6b, 0x27, 0x6f, 0x71, 0x27, 0x6f, 0x76,
    0x27, 0x6f, 0x77, 0x27, 0x6f, 0x78, 0x27, 0x6f, 0x79, 0x27, 0x6f, 0x7a};
const uint8_t HuffDecoderCommon::table20_72_emit_[204] = {
    0x27, 0x73, 0x30, 0x27, 0x73, 0x31, 0x27, 0x73, 0x32, 0x27, 0x73, 0x61,
    0x27, 0x73, 0x63, 0x27, 0x73, 0x65, 0x27, 0x73, 0x69, 0x27, 0x73, 0x6f,
    0x27, 0x73, 0x73, 0x27, 0x73, 0x74, 0x27, 0x73, 0x20, 0x27, 0x73, 0x25,
    0x27, 0x73, 0x2d, 0x27, 0x73, 0x2e, 0x27, 0x73, 0x2f, 0x27, 0x73, 0x33,
    0x27, 0x73, 0x34, 0x27, 0x73, 0x35, 0x27, 0x73, 0x36, 0x27, 0x73, 0x37,
    0x27, 0x73, 0x38, 0x27, 0x73, 0x39, 0x27, 0x73, 0x3d, 0x27, 0x73, 0x41,
    0x27, 0x73, 0x5f, 0x27, 0x73, 0x62, 0x27, 0x73, 0x64, 0x27, 0x73, 0x66,
    0x27, 0x73, 0x67, 0x27, 0x73, 0x68, 0x27, 0x73, 0x6c, 0x27, 0x73, 0x6d,
    0x27, 0x73, 0x6e, 0x27, 0x73, 0x70, 0x27, 0x73, 0x72, 0x27, 0x73, 0x75,
    0x27, 0x73, 0x3a, 0x27, 0x73, 0x42, 0x27, 0x73, 0x43, 0x27, 0x73, 0x44,
    0x27, 0x73, 0x45, 0x27, 0x73, 0x46, 0x27, 0x73, 0x47, 0x27, 0x73, 0x48,
    0x27, 0x73, 0x49, 0x27, 0x73, 0x4a, 0x27, 0x73, 0x4b, 0x27, 0x73, 0x4c,
    0x27, 0x73, 0x4d, 0x27, 0x73, 0x4e, 0x27, 0x73, 0x4f, 0x27, 0x73, 0x50,
    0x27, 0x73, 0x51, 0x27, 0x73, 0x52, 0x27, 0x73, 0x53, 0x27, 0x73, 0x54,
    0x27, 0x73, 0x55, 0x27, 0x73, 0x56, 0x27, 0x73, 0x57, 0x27, 0x73, 0x59,
    0x27, 0x73, 0x6a, 0x27, 0x73, 0x6b, 0x27, 0x73, 0x71, 0x27, 0x73, 0x76,
    0x27, 0x73, 0x77, 0x27, 0x73, 0x78, 0x27, 0x73, 0x79, 0x27, 0x73, 0x7a};
const uint8_t HuffDecoderCommon::table20_73_emit_[204] = {
    0x27, 0x74, 0x30, 0x27, 0x74, 0x31, 0x27, 0x74, 0x32, 0x27, 0x74, 0x61,
    0x27, 0x74, 0x63, 0x27, 0x74, 0x65, 0x27, 0x74, 0x69, 0x27, 0x74, 0x6f,
    0x27, 0x74, 0x73, 0x27, 0x74, 0x74, 0x27, 0x74, 0x20, 0x27, 0x74, 0x25,
    0x27, 0x74, 0x2d, 0x27, 0x74, 0x2e, 0x27, 0x74, 0x2f, 0x27, 0x74, 0x33,
    0x27, 0x74, 0x34, 0x27, 0x74, 0x35, 0x27, 0x74, 0x36, 0x27, 0x74, 0x37,
    0x27, 0x74, 0x38, 0x27, 0x74, 0x39, 0x27, 0x74, 0x3d, 0x27, 0x74, 0x41,
    0x27, 0x74, 0x5f, 0x27, 0x74, 0x62, 0x27, 0x74, 0x64, 0x27, 0x74, 0x66,
    0x27, 0x74, 0x67, 0x27, 0x74, 0x68, 0x27, 0x74, 0x6c, 0x27, 0x74, 0x6d,
    0x27, 0x74, 0x6e, 0x27, 0x74, 0x70, 0x27, 0x74, 0x72, 0x27, 0x74, 0x75,
    0x27, 0x74, 0x3a, 0x27, 0x74, 0x42, 0x27, 0x74, 0x43, 0x27, 0x74, 0x44,
    0x27, 0x74, 0x45, 0x27, 0x74, 0x46, 0x27, 0x74, 0x47, 0x27, 0x74, 0x48,
    0x27, 0x74, 0x49, 0x27, 0x74, 0x4a, 0x27, 0x74, 0x4b, 0x27, 0x74, 0x4c,
    0x27, 0x74, 0x4d, 0x27, 0x74, 0x4e, 0x27, 0x74, 0x4f, 0x27, 0x74, 0x50,
    0x27, 0x74, 0x51, 0x27, 0x74, 0x52, 0x27, 0x74, 0x53, 0x27, 0x74, 0x54,
    0x27, 0x74, 0x55, 0x27, 0x74, 0x56, 0x27, 0x74, 0x57, 0x27, 0x74, 0x59,
    0x27, 0x74, 0x6a, 0x27, 0x74, 0x6b, 0x27, 0x74, 0x71, 0x27, 0x74, 0x76,
    0x27, 0x74, 0x77, 0x27, 0x74, 0x78, 0x27, 0x74, 0x79, 0x27, 0x74, 0x7a};
const uint8_t HuffDecoderCommon::table20_74_emit_[216] = {
    0x27, 0x20, 0x30, 0x27, 0x20, 0x31, 0x27, 0x20, 0x32, 0x27, 0x20, 0x61,
    0x27, 0x20, 0x63, 0x27, 0x20, 0x65, 0x27, 0x20, 0x69, 0x27, 0x20, 0x6f,
    0x27, 0x20, 0x73, 0x27, 0x20, 0x74, 0x27, 0x20, 0x20, 0x27, 0x20, 0x25,
    0x27, 0x20, 0x2d, 0x27, 0x20, 0x2e, 0x27, 0x20, 0x2f, 0x27, 0x20, 0x33,
    0x27, 0x20, 0x34, 0x27, 0x20, 0x35, 0x27, 0x20, 0x36, 0x27, 0x20, 0x37,
    0x27, 0x20, 0x38, 0x27, 0x20, 0x39, 0x27, 0x20, 0x3d, 0x27, 0x20, 0x41,
    0x27, 0x20, 0x5f, 0x27, 0x20, 0x62, 0x27, 0x20, 0x64, 0x27, 0x20, 0x66,
    0x27, 0x20, 0x67, 0x27, 0x20, 0x68, 0x27, 0x20, 0x6c, 0x27, 0x20, 0x6d,
    0x27, 0x20, 0x6e, 0x27, 0x20, 0x70, 0x27, 0x20, 0x72, 0x27, 0x20, 0x75,
    0x27, 0x25, 0x30, 0x27, 0x25, 0x31, 0x27, 0x25, 0x32, 0x27, 0x25, 0x61,
    0x27, 0x25, 0x63, 0x27, 0x25, 0x65, 0x27, 0x25, 0x69, 0x27, 0x25, 0x6f,
    0x27, 0x25, 0x73, 0x27, 0x25, 0x74, 0x27, 0x25, 0x20, 0x27, 0x25, 0x25,
    0x27, 0x25, 0x2d, 0x27, 0x25, 0x2e, 0x27, 0x25, 0x2f, 0x27, 0x25, 0x33,
    0x27, 0x25, 0x34, 0x27, 0x25, 0x35, 0x27, 0x25, 0x36, 0x27, 0x25, 0x37,
    0x27, 0x25, 0x38, 0x27, 0x25, 0x39, 0x27, 0x25, 0x3d, 0x27, 0x25, 0x41,
    0x27, 0x25, 0x5f, 0x27, 0x25, 0x62, 0x27, 0x25, 0x64, 0x27, 0x25, 0x66,
    0x27, 0x25, 0x67, 0x27, 0x25, 0x68, 0x27, 0x25, 0x6c, 0x27, 0x25, 0x6d,
    0x27, 0x25, 0x6e, 0x27, 0x25, 0x70, 0x27, 0x25, 0x72, 0x27, 0x25, 0x75};
const uint8_t HuffDecoderCommon::table20_75_emit_[216] = {
    0x27, 0x2d, 0x30, 0x27, 0x2d, 0x31, 0x27, 0x2d, 0x32, 0x27, 0x2d, 0x61,
    0x27, 0x2d, 0x63, 0x27, 0x2d, 0x65, 0x27, 0x2d, 0x69, 0x27, 0x2d, 0x6f,
    0x27, 0x2d, 0x73, 0x27, 0x2d, 0x74, 0x27, 0x2d, 0x20, 0x27, 0x2d, 0x25,
    0x27, 0x2d, 0x2d, 0x27, 0x2d, 0x2e, 0x27, 0x2d, 0x2f, 0x27, 0x2d, 0x33,
    0x27, 0x2d, 0x34, 0x27, 0x2d, 0x35, 0x27, 0x2d, 0x36, 0x27, 0x2d, 0x37,
    0x27, 0x2d, 0x38, 0x27, 0x2d, 0x39, 0x27, 0x2d, 0x3d, 0x27, 0x2d, 0x41,
    0x27, 0x2d, 0x5f, 0x27, 0x2d, 0x62, 0x27, 0x2d, 0x64, 0x27, 0x2d, 0x66,
    0x27, 0x2d, 0x67, 0x27, 0x2d, 0x68, 0x27, 0x2d, 0x6c, 0x27, 0x2d, 0x6d,
    0x27, 0x2d, 0x6e, 0x27, 0x2d, 0x70, 0x27, 0x2d, 0x72, 0x27, 0x2d, 0x75,
    0x27, 0x2e, 0x30, 0x27, 0x2e, 0x31, 0x27, 0x2e, 0x32, 0x27, 0x2e, 0x61,
    0x27, 0x2e, 0x63, 0x27, 0x2e, 0x65, 0x27, 0x2e, 0x69, 0x27, 0x2e, 0x6f,
    0x27, 0x2e, 0x73, 0x27, 0x2e, 0x74, 0x27, 0x2e, 0x20, 0x27, 0x2e, 0x25,
    0x27, 0x2e, 0x2d, 0x27, 0x2e, 0x2e, 0x27, 0x2e, 0x2f, 0x27, 0x2e, 0x33,
    0x27, 0x2e, 0x34, 0x27, 0x2e, 0x35, 0x27, 0x2e, 0x36, 0x27, 0x2e, 0x37,
    0x27, 0x2e, 0x38, 0x27, 0x2e, 0x39, 0x27, 0x2e, 0x3d, 0x27, 0x2e, 0x41,
    0x27, 0x2e, 0x5f, 0x27, 0x2e, 0x62, 0x27, 0x2e, 0x64, 0x27, 0x2e, 0x66,
    0x27, 0x2e, 0x67, 0x27, 0x2e, 0x68, 0x27, 0x2e, 0x6c, 0x27, 0x2e, 0x6d,
    0x27, 0x2e, 0x6e, 0x27, 0x2e, 0x70, 0x27, 0x2e, 0x72, 0x27, 0x2e, 0x75};
const uint8_t HuffDecoderCommon::table20_76_emit_[216] = {
    0x27, 0x2f, 0x30, 0x27, 0x2f, 0x31, 0x27, 0x2f, 0x32, 0x27, 0x2f, 0x61,
    0x27, 0x2f, 0x63, 0x27, 0x2f, 0x65, 0x27, 0x2f, 0x69, 0x27, 0x2f, 0x6f,
    0x27, 0x2f, 0x73, 0x27, 0x2f, 0x74, 0x27, 0x2f, 0x20, 0x27, 0x2f, 0x25,
    0x27, 0x2f, 0x2d, 0x27, 0x2f, 0x2e, 0x27, 0x2f, 0x2f, 0x27, 0x2f, 0x33,
    0x27, 0x2f, 0x34, 0x27, 0x2f, 0x35, 0x27, 0x2f, 0x36, 0x27, 0x2f, 0x37,
    0x27, 0x2f, 0x38, 0x27, 0x2f, 0x39, 0x27, 0x2f, 0x3d, 0x27, 0x2f, 0x41,
    0x27, 0x2f, 0x5f, 0x27, 0x2f, 0x62, 0x27, 0x2f, 0x64, 0x27, 0x2f, 0x66,
    0x27, 0x2f, 0x67, 0x27, 0x2f, 0x68, 0x27, 0x2f, 0x6c, 0x27, 0x2f, 0x6d,
    0x27, 0x2f, 0x6e, 0x27, 0x2f, 0x70, 0x27, 0x2f, 0x72, 0x27, 0x2f, 0x75,
    0x27, 0x33, 0x30, 0x27, 0x33, 0x31, 0x27, 0x33, 0x32, 0x27, 0x33, 0x61,
    0x27, 0x33, 0x63, 0x27, 0x33, 0x65, 0x27, 0x33, 0x69, 0x27, 0x33, 0x6f,
    0x27, 0x33, 0x73, 0x27, 0x33, 0x74, 0x27, 0x33, 0x20, 0x27, 0x33, 0x25,
    0x27, 0x33, 0x2d, 0x27, 0x33, 0x2e, 0x27, 0x33, 0x2f, 0x27, 0x33, 0x33,
    0x27, 0x33, 0x34, 0x27, 0x33, 0x35, 0x27, 0x33, 0x36, 0x27, 0x33, 0x37,
    0x27, 0x33, 0x38, 0x27, 0x33, 0x39, 0x27, 0x33, 0x3d, 0x27, 0x33, 0x41,
    0x27, 0x33, 0x5f, 0x27, 0x33, 0x62, 0x27, 0x33, 0x64, 0x27, 0x33, 0x66,
    0x27, 0x33, 0x67, 0x27, 0x33, 0x68, 0x27, 0x33, 0x6c, 0x27, 0x33, 0x6d,
    0x27, 0x33, 0x6e, 0x27, 0x33, 0x70, 0x27, 0x33, 0x72, 0x27, 0x33, 0x75};
const uint8_t HuffDecoderCommon::table20_77_emit_[216] = {
    0x27, 0x34, 0x30, 0x27, 0x34, 0x31, 0x27, 0x34, 0x32, 0x27, 0x34, 0x61,
    0x27, 0x34, 0x63, 0x27, 0x34, 0x65, 0x27, 0x34, 0x69, 0x27, 0x34, 0x6f,
    0x27, 0x34, 0x73, 0x27, 0x34, 0x74, 0x27, 0x34, 0x20, 0x27, 0x34, 0x25,
    0x27, 0x34, 0x2d, 0x27, 0x34, 0x2e, 0x27, 0x34, 0x2f, 0x27, 0x34, 0x33,
    0x27, 0x34, 0x34, 0x27, 0x34, 0x35, 0x27, 0x34, 0x36, 0x27, 0x34, 0x37,
    0x27, 0x34, 0x38, 0x27, 0x34, 0x39, 0x27, 0x34, 0x3d, 0x27, 0x34, 0x41,
    0x27, 0x34, 0x5f, 0x27, 0x34, 0x62, 0x27, 0x34, 0x64, 0x27, 0x34, 0x66,
    0x27, 0x34, 0x67, 0x27, 0x34, 0x68, 0x27, 0x34, 0x6c, 0x27, 0x34, 0x6d,
    0x27, 0x34, 0x6e, 0x27, 0x34, 0x70, 0x27, 0x34, 0x72, 0x27, 0x34, 0x75,
    0x27, 0x35, 0x30, 0x27, 0x35, 0x31, 0x27, 0x35, 0x32, 0x27, 0x35, 0x61,
    0x27, 0x35, 0x63, 0x27, 0x35, 0x65, 0x27, 0x35, 0x69, 0x27, 0x35, 0x6f,
    0x27, 0x35, 0x73, 0x27, 0x35, 0x74, 0x27, 0x35, 0x20, 0x27, 0x35, 0x25,
    0x27, 0x35, 0x2d, 0x27, 0x35, 0x2e, 0x27, 0x35, 0x2f, 0x27, 0x35, 0x33,
    0x27, 0x35, 0x34, 0x27, 0x35, 0x35, 0x27, 0x35, 0x36, 0x27, 0x35, 0x37,
    0x27, 0x35, 0x38, 0x27, 0x35, 0x39, 0x27, 0x35, 0x3d, 0x27, 0x35, 0x41,
    0x27, 0x35, 0x5f, 0x27, 0x35, 0x62, 0x27, 0x35, 0x64, 0x27, 0x35, 0x66,
    0x27, 0x35, 0x67, 0x27, 0x35, 0x68, 0x27, 0x35, 0x6c, 0x27, 0x35, 0x6d,
    0x27, 0x35, 0x6e, 0x27, 0x35, 0x70, 0x27, 0x35, 0x72, 0x27, 0x35, 0x75};
const uint8_t HuffDecoderCommon::table20_78_emit_[216] = {
    0x27, 0x36, 0x30, 0x27, 0x36, 0x31, 0x27, 0x36, 0x32, 0x27, 0x36, 0x61,
    0x27, 0x36, 0x63, 0x27, 0x36, 0x65, 0x27, 0x36, 0x69, 0x27, 0x36, 0x6f,
    0x27, 0x36, 0x73, 0x27, 0x36, 0x74, 0x27, 0x36, 0x20, 0x27, 0x36, 0x25,
    0x27, 0x36, 0x2d, 0x27, 0x36, 0x2e, 0x27, 0x36, 0x2f, 0x27, 0x36, 0x33,
    0x27, 0x36, 0x34, 0x27, 0x36, 0x35, 0x27, 0x36, 0x36, 0x27, 0x36, 0x37,
    0x27, 0x36, 0x38, 0x27, 0x36, 0x39, 0x27, 0x36, 0x3d, 0x27, 0x36, 0x41,
    0x27, 0x36, 0x5f, 0x27, 0x36, 0x62, 0x27, 0x36, 0x64, 0x27, 0x36, 0x66,
    0x27, 0x36, 0x67, 0x27, 0x36, 0x68, 0x27, 0x36, 0x6c, 0x27, 0x36, 0x6d,
    0x27, 0x36, 0x6e, 0x27, 0x36, 0x70, 0x27, 0x36, 0x72, 0x27, 0x36, 0x75,
    0x27, 0x37, 0x30, 0x27, 0x37, 0x31, 0x27, 0x37, 0x32, 0x27, 0x37, 0x61,
    0x27, 0x37, 0x63, 0x27, 0x37, 0x65, 0x27, 0x37, 0x69, 0x27, 0x37, 0x6f,
    0x27, 0x37, 0x73, 0x27, 0x37, 0x74, 0x27, 0x37, 0x20, 0x27, 0x37, 0x25,
    0x27, 0x37, 0x2d, 0x27, 0x37, 0x2e, 0x27, 0x37, 0x2f, 0x27, 0x37, 0x33,
    0x27, 0x37, 0x34, 0x27, 0x37, 0x35, 0x27, 0x37, 0x36, 0x27, 0x37, 0x37,
    0x27, 0x37, 0x38, 0x27, 0x37, 0x39, 0x27, 0x37, 0x3d, 0x27, 0x37, 0x41,
    0x27, 0x37, 0x5f, 0x27, 0x37, 0x62, 0x27, 0x37, 0x64, 0x27, 0x37, 0x66,
    0x27, 0x37, 0x67, 0x27, 0x37, 0x68, 0x27, 0x37, 0x6c, 0x27, 0x37, 0x6d,
    0x27, 0x37, 0x6e, 0x27, 0x37, 0x70, 0x27, 0x37, 0x72, 0x27, 0x37, 0x75};
const uint8_t HuffDecoderCommon::table20_79_emit_[216] = {
    0x27, 0x38, 0x30, 0x27, 0x38, 0x31, 0x27, 0x38, 0x32, 0x27, 0x38, 0x61,
    0x27, 0x38, 0x63, 0x27, 0x38, 0x65, 0x27, 0x38, 0x69, 0x27, 0x38, 0x6f,
    0x27, 0x38, 0x73, 0x27, 0x38, 0x74, 0x27, 0x38, 0x20, 0x27, 0x38, 0x25,
    0x27, 0x38, 0x2d, 0x27, 0x38, 0x2e, 0x27, 0x38, 0x2f, 0x27, 0x38, 0x33,
    0x27, 0x38, 0x34, 0x27, 0x38, 0x35, 0x27, 0x38, 0x36, 0x27, 0x38, 0x37,
    0x27, 0x38, 0x38, 0x27, 0x38, 0x39, 0x27, 0x38, 0x3d, 0x27, 0x38, 0x41,
    0x27, 0x38, 0x5f, 0x27, 0x38, 0x62, 0x27, 0x38, 0x64, 0x27, 0x38, 0x66,
    0x27, 0x38, 0x67, 0x27, 0x38, 0x68, 0x27, 0x38, 0x6c, 0x27, 0x38, 0x6d,
    0x27, 0x38, 0x6e, 0x27, 0x38, 0x70, 0x27, 0x38, 0x72, 0x27, 0x38, 0x75,
    0x27, 0x39, 0x30, 0x27, 0x39, 0x31, 0x27, 0x39, 0x32, 0x27, 0x39, 0x61,
    0x27, 0x39, 0x63, 0x27, 0x39, 0x65, 0x27, 0x39, 0x69, 0x27, 0x39, 0x6f,
    0x27, 0x39, 0x73, 0x27, 0x39, 0x74, 0x27, 0x39, 0x20, 0x27, 0x39, 0x25,
    0x27, 0x39, 0x2d, 0x27, 0x39, 0x2e, 0x27, 0x39, 0x2f, 0x27, 0x39, 0x33,
    0x27, 0x39, 0x34, 0x27, 0x39, 0x35, 0x27, 0x39, 0x36, 0x27, 0x39, 0x37,
    0x27, 0x39, 0x38, 0x27, 0x39, 0x39, 0x27, 0x39, 0x3d, 0x27, 0x39, 0x41,
    0x27, 0x39, 0x5f, 0x27, 0x39, 0x62, 0x27, 0x39, 0x64, 0x27, 0x39, 0x66,
    0x27, 0x39, 0x67, 0x27, 0x39, 0x68, 0x27, 0x39, 0x6c, 0x27, 0x39, 0x6d,
    0x27, 0x39, 0x6e, 0x27, 0x39, 0x70, 0x27, 0x39, 0x72, 0x27, 0x39, 0x75};
const uint8_t HuffDecoderCommon::table20_80_emit_[216] = {
    0x27, 0x3d, 0x30, 0x27, 0x3d, 0x31, 0x27, 0x3d, 0x32, 0x27, 0x3d, 0x61,
    0x27, 0x3d, 0x63, 0x27, 0x3d, 0x65, 0x27, 0x3d, 0x69, 0x27, 0x3d, 0x6f,
    0x27, 0x3d, 0x73, 0x27, 0x3d, 0x74, 0x27, 0x3d, 0x20, 0x27, 0x3d, 0x25,
    0x27, 0x3d, 0x2d, 0x27, 0x3d, 0x2e, 0x27, 0x3d, 0x2f, 0x27, 0x3d, 0x33,
    0x27, 0x3d, 0x34, 0x27, 0x3d, 0x35, 0x27, 0x3d, 0x36, 0x27, 0x3d, 0x37,
    0x27, 0x3d, 0x38, 0x27, 0x3d, 0x39, 0x27, 0x3d, 0x3d, 0x27, 0x3d, 0x41,
    0x27, 0x3d, 0x5f, 0x27, 0x3d, 0x62, 0x27, 0x3d, 0x64, 0x27, 0x3d, 0x66,
    0x27, 0x3d, 0x67, 0x27, 0x3d, 0x68, 0x27, 0x3d, 0x6c, 0x27, 0x3d, 0x6d,
    0x27, 0x3d, 0x6e, 0x27, 0x3d, 0x70, 0x27, 0x3d, 0x72, 0x27, 0x3d, 0x75,
    0x27, 0x41, 0x30, 0x27, 0x41, 0x31, 0x27, 0x41, 0x32, 0x27, 0x41, 0x61,
    0x27, 0x41, 0x63, 0x27, 0x41, 0x65, 0x27, 0x41, 0x69, 0x27, 0x41, 0x6f,
    0x27, 0x41, 0x73, 0x27, 0x41, 0x74, 0x27, 0x41, 0x20, 0x27, 0x41, 0x25,
    0x27, 0x41, 0x2d, 0x27, 0x41, 0x2e, 0x27, 0x41, 0x2f, 0x27, 0x41, 0x33,
    0x27, 0x41, 0x34, 0x27, 0x41, 0x35, 0x27, 0x41, 0x36, 0x27, 0x41, 0x37,
    0x27, 0x41, 0x38, 0x27, 0x41, 0x39, 0x27, 0x41, 0x3d, 0x27, 0x41, 0x41,
    0x27, 0x41, 0x5f, 0x27, 0x41, 0x62, 0x27, 0x41, 0x64, 0x27, 0x41, 0x66,
    0x27, 0x41, 0x67, 0x27, 0x41, 0x68, 0x27, 0x41, 0x6c, 0x27, 0x41, 0x6d,
    0x27, 0x41, 0x6e, 0x27, 0x41, 0x70, 0x27, 0x41, 0x72, 0x27, 0x41, 0x75};
const uint8_t HuffDecoderCommon::table20_81_emit_[216] = {
    0x27, 0x5f, 0x30, 0x27, 0x5f, 0x31, 0x27, 0x5f, 0x32, 0x27, 0x5f, 0x61,
    0x27, 0x5f, 0x63, 0x27, 0x5f, 0x65, 0x27, 0x5f, 0x69, 0x27, 0x5f, 0x6f,
    0x27, 0x5f, 0x73, 0x27, 0x5f, 0x74, 0x27, 0x5f, 0x20, 0x27, 0x5f, 0x25,
    0x27, 0x5f, 0x2d, 0x27, 0x5f, 0x2e, 0x27, 0x5f, 0x2f, 0x27, 0x5f, 0x33,
    0x27, 0x5f, 0x34, 0x27, 0x5f, 0x35, 0x27, 0x5f, 0x36, 0x27, 0x5f, 0x37,
    0x27, 0x5f, 0x38, 0x27, 0x5f, 0x39, 0x27, 0x5f, 0x3d, 0x27, 0x5f, 0x41,
    0x27, 0x5f, 0x5f, 0x27, 0x5f, 0x62, 0x27, 0x5f, 0x64, 0x27, 0x5f, 0x66,
    0x27, 0x5f, 0x67, 0x27, 0x5f, 0x68, 0x27, 0x5f, 0x6c, 0x27, 0x5f, 0x6d,
    0x27, 0x5f, 0x6e, 0x27, 0x5f, 0x70, 0x27, 0x5f, 0x72, 0x27, 0x5f, 0x75,
    0x27, 0x62, 0x30, 0x27, 0x62, 0x31, 0x27, 0x62, 0x32, 0x27, 0x62, 0x61,
    0x27, 0x62, 0x63, 0x27, 0x62, 0x65, 0x27, 0x62, 0x69, 0x27, 0x62, 0x6f,
    0x27, 0x62, 0x73, 0x27, 0x62, 0x74, 0x27, 0x62, 0x20, 0x27, 0x62, 0x25,
    0x27, 0x62, 0x2d, 0x27, 0x62, 0x2e, 0x27, 0x62, 0x2f, 0x27, 0x62, 0x33,
    0x27, 0x62, 0x34, 0x27, 0x62, 0x35, 0x27, 0x62, 0x36, 0x27, 0x62, 0x37,
    0x27, 0x62, 0x38, 0x27, 0x62, 0x39, 0x27, 0x62, 0x3d, 0x27, 0x62, 0x41,
    0x27, 0x62, 0x5f, 0x27, 0x62, 0x62, 0x27, 0x62, 0x64, 0x27, 0x62, 0x66,
    0x27, 0x62, 0x67, 0x27, 0x62, 0x68, 0x27, 0x62, 0x6c, 0x27, 0x62, 0x6d,
    0x27, 0x62, 0x6e, 0x27, 0x62, 0x70, 0x27, 0x62, 0x72, 0x27, 0x62, 0x75};
const uint8_t HuffDecoderCommon::table20_82_emit_[216] = {
    0x27, 0x64, 0x30, 0x27, 0x64, 0x31, 0x27, 0x64, 0x32, 0x27, 0x64, 0x61,
    0x27, 0x64, 0x63, 0x27, 0x64, 0x65, 0x27, 0x64, 0x69, 0x27, 0x64, 0x6f,
    0x27, 0x64, 0x73, 0x27, 0x64, 0x74, 0x27, 0x64, 0x20, 0x27, 0x64, 0x25,
    0x27, 0x64, 0x2d, 0x27, 0x64, 0x2e, 0x27, 0x64, 0x2f, 0x27, 0x64, 0x33,
    0x27, 0x64, 0x34, 0x27, 0x64, 0x35, 0x27, 0x64, 0x36, 0x27, 0x64, 0x37,
    0x27, 0x64, 0x38, 0x27, 0x64, 0x39, 0x27, 0x64, 0x3d, 0x27, 0x64, 0x41,
    0x27, 0x64, 0x5f, 0x27, 0x64, 0x62, 0x27, 0x64, 0x64, 0x27, 0x64, 0x66,
    0x27, 0x64, 0x67, 0x27, 0x64, 0x68, 0x27, 0x64, 0x6c, 0x27, 0x64, 0x6d,
    0x27, 0x64, 0x6e, 0x27, 0x64, 0x70, 0x27, 0x64, 0x72, 0x27, 0x64, 0x75,
    0x27, 0x66, 0x30, 0x27, 0x66, 0x31, 0x27, 0x66, 0x32, 0x27, 0x66, 0x61,
    0x27, 0x66, 0x63, 0x27, 0x66, 0x65, 0x27, 0x66, 0x69, 0x27, 0x66, 0x6f,
    0x27, 0x66, 0x73, 0x27, 0x66, 0x74, 0x27, 0x66, 0x20, 0x27, 0x66, 0x25,
    0x27, 0x66, 0x2d, 0x27, 0x66, 0x2e, 0x27, 0x66, 0x2f, 0x27, 0x66, 0x33,
    0x27, 0x66, 0x34, 0x27, 0x66, 0x35, 0x27, 0x66, 0x36, 0x27, 0x66, 0x37,
    0x27, 0x66, 0x38, 0x27, 0x66, 0x39, 0x27, 0x66, 0x3d, 0x27, 0x66, 0x41,
    0x27, 0x66, 0x5f, 0x27, 0x66, 0x62, 0x27, 0x66, 0x64, 0x27, 0x66, 0x66,
    0x27, 0x66, 0x67, 0x27, 0x66, 0x68, 0x27, 0x66, 0x6c, 0x27, 0x66, 0x6d,
    0x27, 0x66, 0x6e, 0x27, 0x66, 0x70, 0x27, 0x66, 0x72, 0x27, 0x66, 0x75};
const uint8_t HuffDecoderCommon::table20_83_emit_[216] = {
    0x27, 0x67, 0x30, 0x27, 0x67, 0x31, 0x27, 0x67, 0x32, 0x27, 0x67, 0x61,
    0x27, 0x67, 0x63, 0x27, 0x67, 0x65, 0x27, 0x67, 0x69, 0x27, 0x67, 0x6f,
    0x27, 0x67, 0x73, 0x27, 0x67, 0x74, 0x27, 0x67, 0x20, 0x27, 0x67, 0x25,
    0x27, 0x67, 0x2d, 0x27, 0x67, 0x2e, 0x27, 0x67, 0x2f, 0x27, 0x67, 0x33,
    0x27, 0x67, 0x34, 0x27, 0x67, 0x35, 0x27, 0x67, 0x36, 0x27, 0x67, 0x37,
    0x27, 0x67, 0x38, 0x27, 0x67, 0x39, 0x27, 0x67, 0x3d, 0x27, 0x67, 0x41,
    0x27, 0x67, 0x5f, 0x27, 0x67, 0x62, 0x27, 0x67, 0x64, 0x27, 0x67, 0x66,
    0x27, 0x67, 0x67, 0x27, 0x67, 0x68, 0x27, 0x67, 0x6c, 0x27, 0x67, 0x6d,
    0x27, 0x67, 0x6e, 0x27, 0x67, 0x70, 0x27, 0x67, 0x72, 0x27, 0x67, 0x75,
    0x27, 0x68, 0x30, 0x27, 0x68, 0x31, 0x27, 0x68, 0x32, 0x27, 0x68, 0x61,
    0x27, 0x68, 0x63, 0x27, 0x68, 0x65, 0x27, 0x68, 0x69, 0x27, 0x68, 0x6f,
    0x27, 0x68, 0x73, 0x27, 0x68, 0x74, 0x27, 0x68, 0x20, 0x27, 0x68, 0x25,
    0x27, 0x68, 0x2d, 0x27, 0x68, 0x2e, 0x27, 0x68, 0x2f, 0x27, 0x68, 0x33,
    0x27, 0x68, 0x34, 0x27, 0x68, 0x35, 0x27, 0x68, 0x36, 0x27, 0x68, 0x37,
    0x27, 0x68, 0x38, 0x27, 0x68, 0x39, 0x27, 0x68, 0x3d, 0x27, 0x68, 0x41,
    0x27, 0x68, 0x5f, 0x27, 0x68, 0x62, 0x27, 0x68, 0x64, 0x27, 0x68, 0x66,
    0x27, 0x68, 0x67, 0x27, 0x68, 0x68, 0x27, 0x68, 0x6c, 0x27, 0x68, 0x6d,
    0x27, 0x68, 0x6e, 0x27, 0x68, 0x70, 0x27, 0x68, 0x72, 0x27, 0x68, 0x75};
const uint8_t HuffDecoderCommon::table20_84_emit_[216] = {
    0x27, 0x6c, 0x30, 0x27, 0x6c, 0x31, 0x27, 0x6c, 0x32, 0x27, 0x6c, 0x61,
    0x27, 0x6c, 0x63, 0x27, 0x6c, 0x65, 0x27, 0x6c, 0x69, 0x27, 0x6c, 0x6f,
    0x27, 0x6c, 0x73, 0x27, 0x6c, 0x74, 0x27, 0x6c, 0x20, 0x27, 0x6c, 0x25,
    0x27, 0x6c, 0x2d, 0x27, 0x6c, 0x2e, 0x27, 0x6c, 0x2f, 0x27, 0x6c, 0x33,
    0x27, 0x6c, 0x34, 0x27, 0x6c, 0x35, 0x27, 0x6c, 0x36, 0x27, 0x6c, 0x37,
    0x27, 0x6c, 0x38, 0x27, 0x6c, 0x39, 0x27, 0x6c, 0x3d, 0x27, 0x6c, 0x41,
    0x27, 0x6c, 0x5f, 0x27, 0x6c, 0x62, 0x27, 0x6c, 0x64, 0x27, 0x6c, 0x66,
    0x27, 0x6c, 0x67, 0x27, 0x6c, 0x68, 0x27, 0x6c, 0x6c, 0x27, 0x6c, 0x6d,
    0x27, 0x6c, 0x6e, 0x27, 0x6c, 0x70, 0x27, 0x6c, 0x72, 0x27, 0x6c, 0x75,
    0x27, 0x6d, 0x30, 0x27, 0x6d, 0x31, 0x27, 0x6d, 0x32, 0x27, 0x6d, 0x61,
    0x27, 0x6d, 0x63, 0x27, 0x6d, 0x65, 0x27, 0x6d, 0x69, 0x27, 0x6d, 0x6f,
    0x27, 0x6d, 0x73, 0x27, 0x6d, 0x74, 0x27, 0x6d, 0x20, 0x27, 0x6d, 0x25,
    0x27, 0x6d, 0x2d, 0x27, 0x6d, 0x2e, 0x27, 0x6d, 0x2f, 0x27, 0x6d, 0x33,
    0x27, 0x6d, 0x34, 0x27, 0x6d, 0x35, 0x27, 0x6d, 0x36, 0x27, 0x6d, 0x37,
    0x27, 0x6d, 0x38, 0x27, 0x6d, 0x39, 0x27, 0x6d, 0x3d, 0x27, 0x6d, 0x41,
    0x27, 0x6d, 0x5f, 0x27, 0x6d, 0x62, 0x27, 0x6d, 0x64, 0x27, 0x6d, 0x66,
    0x27, 0x6d, 0x67, 0x27, 0x6d, 0x68, 0x27, 0x6d, 0x6c, 0x27, 0x6d, 0x6d,
    0x27, 0x6d, 0x6e, 0x27, 0x6d, 0x70, 0x27, 0x6d, 0x72, 0x27, 0x6d, 0x75};
const uint8_t HuffDecoderCommon::table20_85_emit_[216] = {
    0x27, 0x6e, 0x30, 0x27, 0x6e, 0x31, 0x27, 0x6e, 0x32, 0x27, 0x6e, 0x61,
    0x27, 0x6e, 0x63, 0x27, 0x6e, 0x65, 0x27, 0x6e, 0x69, 0x27, 0x6e, 0x6f,
    0x27, 0x6e, 0x73, 0x27, 0x6e, 0x74, 0x27, 0x6e, 0x20, 0x27, 0x6e, 0x25,
    0x27, 0x6e, 0x2d, 0x27, 0x6e, 0x2e, 0x27, 0x6e, 0x2f, 0x27, 0x6e, 0x33,
    0x27, 0x6e, 0x34, 0x27, 0x6e, 0x35, 0x27, 0x6e, 0x36, 0x27, 0x6e, 0x37,
    0x27, 0x6e, 0x38, 0x27, 0x6e, 0x39, 0x27, 0x6e, 0x3d, 0x27, 0x6e, 0x41,
    0x27, 0x6e, 0x5f, 0x27, 0x6e, 0x62, 0x27, 0x6e, 0x64, 0x27, 0x6e, 0x66,
    0x27, 0x6e, 0x67, 0x27, 0x6e, 0x68, 0x27, 0x6e, 0x6c, 0x27, 0x6e, 0x6d,
    0x27, 0x6e, 0x6e, 0x27, 0x6e, 0x70, 0x27, 0x6e, 0x72, 0x27, 0x6e, 0x75,
    0x27, 0x70, 0x30, 0x27, 0x70, 0x31, 0x27, 0x70, 0x32, 0x27, 0x70, 0x61,
    0x27, 0x70, 0x63, 0x27, 0x70, 0x65, 0x27, 0x70, 0x69, 0x27, 0x70, 0x6f,
    0x27, 0x70, 0x73, 0x27, 0x70, 0x74, 0x27, 0x70, 0x20, 0x27, 0x70, 0x25,
    0x27, 0x70, 0x2d, 0x27, 0x70, 0x2e, 0x27, 0x70, 0x2f, 0x27, 0x70, 0x33,
    0x27, 0x70, 0x34, 0x27, 0x70, 0x35, 0x27, 0x70, 0x36, 0x27, 0x70, 0x37,
    0x27, 0x70, 0x38, 0x27, 0x70, 0x39, 0x27, 0x70, 0x3d, 0x27, 0x70, 0x41,
    0x27, 0x70, 0x5f, 0x27, 0x70, 0x62, 0x27, 0x70, 0x64, 0x27, 0x70, 0x66,
    0x27, 0x70, 0x67, 0x27, 0x70, 0x68, 0x27, 0x70, 0x6c, 0x27, 0x70, 0x6d,
    0x27, 0x70, 0x6e, 0x27, 0x70, 0x70, 0x27, 0x70, 0x72, 0x27, 0x70, 0x75};
const uint8_t HuffDecoderCommon::table20_86_emit_[216] = {
    0x27, 0x72, 0x30, 0x27, 0x72, 0x31, 0x27, 0x72, 0x32, 0x27, 0x72, 0x61,
    0x27, 0x72, 0x63, 0x27, 0x72, 0x65, 0x27, 0x72, 0x69, 0x27, 0x72, 0x6f,
    0x27, 0x72, 0x73, 0x27, 0x72, 0x74, 0x27, 0x72, 0x20, 0x27, 0x72, 0x25,
    0x27, 0x72, 0x2d, 0x27, 0x72, 0x2e, 0x27, 0x72, 0x2f, 0x27, 0x72, 0x33,
    0x27, 0x72, 0x34, 0x27, 0x72, 0x35, 0x27, 0x72, 0x36, 0x27, 0x72, 0x37,
    0x27, 0x72, 0x38, 0x27, 0x72, 0x39, 0x27, 0x72, 0x3d, 0x27, 0x72, 0x41,
    0x27, 0x72, 0x5f, 0x27, 0x72, 0x62, 0x27, 0x72, 0x64, 0x27, 0x72, 0x66,
    0x27, 0x72, 0x67, 0x27, 0x72, 0x68, 0x27, 0x72, 0x6c, 0x27, 0x72, 0x6d,
    0x27, 0x72, 0x6e, 0x27, 0x72, 0x70, 0x27, 0x72, 0x72, 0x27, 0x72, 0x75,
    0x27, 0x75, 0x30, 0x27, 0x75, 0x31, 0x27, 0x75, 0x32, 0x27, 0x75, 0x61,
    0x27, 0x75, 0x63, 0x27, 0x75, 0x65, 0x27, 0x75, 0x69, 0x27, 0x75, 0x6f,
    0x27, 0x75, 0x73, 0x27, 0x75, 0x74, 0x27, 0x75, 0x20, 0x27, 0x75, 0x25,
    0x27, 0x75, 0x2d, 0x27, 0x75, 0x2e, 0x27, 0x75, 0x2f, 0x27, 0x75, 0x33,
    0x27, 0x75, 0x34, 0x27, 0x75, 0x35, 0x27, 0x75, 0x36, 0x27, 0x75, 0x37,
    0x27, 0x75, 0x38, 0x27, 0x75, 0x39, 0x27, 0x75, 0x3d, 0x27, 0x75, 0x41,
    0x27, 0x75, 0x5f, 0x27, 0x75, 0x62, 0x27, 0x75, 0x64, 0x27, 0x75, 0x66,
    0x27, 0x75, 0x67, 0x27, 0x75, 0x68, 0x27, 0x75, 0x6c, 0x27, 0x75, 0x6d,
    0x27, 0x75, 0x6e, 0x27, 0x75, 0x70, 0x27, 0x75, 0x72, 0x27, 0x75, 0x75};
const uint8_t HuffDecoderCommon::table20_87_emit_[120] = {
    0x27, 0x3a, 0x30, 0x27, 0x3a, 0x31, 0x27, 0x3a, 0x32, 0x27, 0x3a, 0x61,
    0x27, 0x3a, 0x63, 0x27, 0x3a, 0x65, 0x27, 0x3a, 0x69, 0x27, 0x3a, 0x6f,
    0x27, 0x3a, 0x73, 0x27, 0x3a, 0x74, 0x27, 0x42, 0x30, 0x27, 0x42, 0x31,
    0x27, 0x42, 0x32, 0x27, 0x42, 0x61, 0x27, 0x42, 0x63, 0x27, 0x42, 0x65,
    0x27, 0x42, 0x69, 0x27, 0x42, 0x6f, 0x27, 0x42, 0x73, 0x27, 0x42, 0x74,
    0x27, 0x43, 0x30, 0x27, 0x43, 0x31, 0x27, 0x43, 0x32, 0x27, 0x43, 0x61,
    0x27, 0x43, 0x63, 0x27, 0x43, 0x65, 0x27, 0x43, 0x69, 0x27, 0x43, 0x6f,
    0x27, 0x43, 0x73, 0x27, 0x43, 0x74, 0x27, 0x44, 0x30, 0x27, 0x44, 0x31,
    0x27, 0x44, 0x32, 0x27, 0x44, 0x61, 0x27, 0x44, 0x63, 0x27, 0x44, 0x65,
    0x27, 0x44, 0x69, 0x27, 0x44, 0x6f, 0x27, 0x44, 0x73, 0x27, 0x44, 0x74};
const uint8_t HuffDecoderCommon::table20_88_emit_[120] = {
    0x27, 0x45, 0x30, 0x27, 0x45, 0x31, 0x27, 0x45, 0x32, 0x27, 0x45, 0x61,
    0x27, 0x45, 0x63, 0x27, 0x45, 0x65, 0x27, 0x45, 0x69, 0x27, 0x45, 0x6f,
    0x27, 0x45, 0x73, 0x27, 0x45, 0x74, 0x27, 0x46, 0x30, 0x27, 0x46, 0x31,
    0x27, 0x46, 0x32, 0x27, 0x46, 0x61, 0x27, 0x46, 0x63, 0x27, 0x46, 0x65,
    0x27, 0x46, 0x69, 0x27, 0x46, 0x6f, 0x27, 0x46, 0x73, 0x27, 0x46, 0x74,
    0x27, 0x47, 0x30, 0x27, 0x47, 0x31, 0x27, 0x47, 0x32, 0x27, 0x47, 0x61,
    0x27, 0x47, 0x63, 0x27, 0x47, 0x65, 0x27, 0x47, 0x69, 0x27, 0x47, 0x6f,
    0x27, 0x47, 0x73, 0x27, 0x47, 0x74, 0x27, 0x48, 0x30, 0x27, 0x48, 0x31,
    0x27, 0x48, 0x32, 0x27, 0x48, 0x61, 0x27, 0x48, 0x63, 0x27, 0x48, 0x65,
    0x27, 0x48, 0x69, 0x27, 0x48, 0x6f, 0x27, 0x48, 0x73, 0x27, 0x48, 0x74};
const uint8_t HuffDecoderCommon::table20_89_emit_[120] = {
    0x27, 0x49, 0x30, 0x27, 0x49, 0x31, 0x27, 0x49, 0x32, 0x27, 0x49, 0x61,
    0x27, 0x49, 0x63, 0x27, 0x49, 0x65, 0x27, 0x49, 0x69, 0x27, 0x49, 0x6f,
    0x27, 0x49, 0x73, 0x27, 0x49, 0x74, 0x27, 0x4a, 0x30, 0x27, 0x4a, 0x31,
    0x27, 0x4a, 0x32, 0x27, 0x4a, 0x61, 0x27, 0x4a, 0x63, 0x27, 0x4a, 0x65,
    0x27, 0x4a, 0x69, 0x27, 0x4a, 0x6f, 0x27, 0x4a, 0x73, 0x27, 0x4a, 0x74,
    0x27, 0x4b, 0x30, 0x27, 0x4b, 0x31, 0x27, 0x4b, 0x32, 0x27, 0x4b, 0x61,
    0x27, 0x4b, 0x63, 0x27, 0x4b, 0x65, 0x27, 0x4b, 0x69, 0x27, 0x4b, 0x6f,
    0x27, 0x4b, 0x73, 0x27, 0x4b, 0x74, 0x27, 0x4c, 0x30, 0x27, 0x4c, 0x31,
    0x27, 0x4c, 0x32, 0x27, 0x4c, 0x61, 0x27, 0x4c, 0x63, 0x27, 0x4c, 0x65,
    0x27, 0x4c, 0x69, 0x27, 0x4c, 0x6f, 0x27, 0x4c, 0x73, 0x27, 0x4c, 0x74};
const uint8_t HuffDecoderCommon::table20_90_emit_[120] = {
    0x27, 0x4d, 0x30, 0x27, 0x4d, 0x31, 0x27, 0x4d, 0x32, 0x27, 0x4d, 0x61,
    0x27, 0x4d, 0x63, 0x27, 0x4d, 0x65, 0x27, 0x4d, 0x69, 0x27, 0x4d, 0x6f,
    0x27, 0x4d, 0x73, 0x27, 0x4d, 0x74, 0x27, 0x4e, 0x30, 0x27, 0x4e, 0x31,
    0x27, 0x4e, 0x32, 0x27, 0x4e, 0x61, 0x27, 0x4e, 0x63, 0x27, 0x4e, 0x65,
    0x27, 0x4e, 0x69, 0x27, 0x4e, 0x6f, 0x27, 0x4e, 0x73, 0x27, 0x4e, 0x74,
    0x27, 0x4f, 0x30, 0x27, 0x4f, 0x31, 0x27, 0x4f, 0x32, 0x27, 0x4f, 0x61,
    0x27, 0x4f, 0x63, 0x27, 0x4f, 0x65, 0x27, 0x4f, 0x69, 0x27, 0x4f, 0x6f,
    0x27, 0x4f, 0x73, 0x27, 0x4f, 0x74, 0x27, 0x50, 0x30, 0x27, 0x50, 0x31,
    0x27, 0x50, 0x32, 0x27, 0x50, 0x61, 0x27, 0x50, 0x63, 0x27, 0x50, 0x65,
    0x27, 0x50, 0x69, 0x27, 0x50, 0x6f, 0x27, 0x50, 0x73, 0x27, 0x50, 0x74};
const uint8_t HuffDecoderCommon::table20_91_emit_[120] = {
    0x27, 0x51, 0x30, 0x27, 0x51, 0x31, 0x27, 0x51, 0x32, 0x27, 0x51, 0x61,
    0x27, 0x51, 0x63, 0x27, 0x51, 0x65, 0x27, 0x51, 0x69, 0x27, 0x51, 0x6f,
    0x27, 0x51, 0x73, 0x27, 0x51, 0x74, 0x27, 0x52, 0x30, 0x27, 0x52, 0x31,
    0x27, 0x52, 0x32, 0x27, 0x52, 0x61, 0x27, 0x52, 0x63, 0x27, 0x52, 0x65,
    0x27, 0x52, 0x69, 0x27, 0x52, 0x6f, 0x27, 0x52, 0x73, 0x27, 0x52, 0x74,
    0x27, 0x53, 0x30, 0x27, 0x53, 0x31, 0x27, 0x53, 0x32, 0x27, 0x53, 0x61,
    0x27, 0x53, 0x63, 0x27, 0x53, 0x65, 0x27, 0x53, 0x69, 0x27, 0x53, 0x6f,
    0x27, 0x53, 0x73, 0x27, 0x53, 0x74, 0x27, 0x54, 0x30, 0x27, 0x54, 0x31,
    0x27, 0x54, 0x32, 0x27, 0x54, 0x61, 0x27, 0x54, 0x63, 0x27, 0x54, 0x65,
    0x27, 0x54, 0x69, 0x27, 0x54, 0x6f, 0x27, 0x54, 0x73, 0x27, 0x54, 0x74};
const uint8_t HuffDecoderCommon::table20_92_emit_[120] = {
    0x27, 0x55, 0x30, 0x27, 0x55, 0x31, 0x27, 0x55, 0x32, 0x27, 0x55, 0x61,
    0x27, 0x55, 0x63, 0x27, 0x55, 0x65, 0x27, 0x55, 0x69, 0x27, 0x55, 0x6f,
    0x27, 0x55, 0x73, 0x27, 0x55, 0x74, 0x27, 0x56, 0x30, 0x27, 0x56, 0x31,
    0x27, 0x56, 0x32, 0x27, 0x56, 0x61, 0x27, 0x56, 0x63, 0x27, 0x56, 0x65,
    0x27, 0x56, 0x69, 0x27, 0x56, 0x6f, 0x27, 0x56, 0x73, 0x27, 0x56, 0x74,
    0x27, 0x57, 0x30, 0x27, 0x57, 0x31, 0x27, 0x57, 0x32, 0x27, 0x57, 0x61,
    0x27, 0x57, 0x63, 0x27, 0x57, 0x65, 0x27, 0x57, 0x69, 0x27, 0x57, 0x6f,
    0x27, 0x57, 0x73, 0x27, 0x57, 0x74, 0x27, 0x59, 0x30, 0x27, 0x59, 0x31,
    0x27, 0x59, 0x32, 0x27, 0x59, 0x61, 0x27, 0x59, 0x63, 0x27, 0x59, 0x65,
    0x27, 0x59, 0x69, 0x27, 0x59, 0x6f, 0x27, 0x59, 0x73, 0x27, 0x59, 0x74};
const uint8_t HuffDecoderCommon::table20_93_emit_[120] = {
    0x27, 0x6a, 0x30, 0x27, 0x6a, 0x31, 0x27, 0x6a, 0x32, 0x27, 0x6a, 0x61,
    0x27, 0x6a, 0x63, 0x27, 0x6a, 0x65, 0x27, 0x6a, 0x69, 0x27, 0x6a, 0x6f,
    0x27, 0x6a, 0x73, 0x27, 0x6a, 0x74, 0x27, 0x6b, 0x30, 0x27, 0x6b, 0x31,
    0x27, 0x6b, 0x32, 0x27, 0x6b, 0x61, 0x27, 0x6b, 0x63, 0x27, 0x6b, 0x65,
    0x27, 0x6b, 0x69, 0x27, 0x6b, 0x6f, 0x27, 0x6b, 0x73, 0x27, 0x6b, 0x74,
    0x27, 0x71, 0x30, 0x27, 0x71, 0x31, 0x27, 0x71, 0x32, 0x27, 0x71, 0x61,
    0x27, 0x71, 0x63, 0x27, 0x71, 0x65, 0x27, 0x71, 0x69, 0x27, 0x71, 0x6f,
    0x27, 0x71, 0x73, 0x27, 0x71, 0x74, 0x27, 0x76, 0x30, 0x27, 0x76, 0x31,
    0x27, 0x76, 0x32, 0x27, 0x76, 0x61, 0x27, 0x76, 0x63, 0x27, 0x76, 0x65,
    0x27, 0x76, 0x69, 0x27, 0x76, 0x6f, 0x27, 0x76, 0x73, 0x27, 0x76, 0x74};
const uint8_t HuffDecoderCommon::table20_94_emit_[120] = {
    0x27, 0x77, 0x30, 0x27, 0x77, 0x31, 0x27, 0x77, 0x32, 0x27, 0x77, 0x61,
    0x27, 0x77, 0x63, 0x27, 0x77, 0x65, 0x27, 0x77, 0x69, 0x27, 0x77, 0x6f,
    0x27, 0x77, 0x73, 0x27, 0x77, 0x74, 0x27, 0x78, 0x30, 0x27, 0x78, 0x31,
    0x27, 0x78, 0x32, 0x27, 0x78, 0x61, 0x27, 0x78, 0x63, 0x27, 0x78, 0x65,
    0x27, 0x78, 0x69, 0x27, 0x78, 0x6f, 0x27, 0x78, 0x73, 0x27, 0x78, 0x74,
    0x27, 0x79, 0x30, 0x27, 0x79, 0x31, 0x27, 0x79, 0x32, 0x27, 0x79, 0x61,
    0x27, 0x79, 0x63, 0x27, 0x79, 0x65, 0x27, 0x79, 0x69, 0x27, 0x79, 0x6f,
    0x27, 0x79, 0x73, 0x27, 0x79, 0x74, 0x27, 0x7a, 0x30, 0x27, 0x7a, 0x31,
    0x27, 0x7a, 0x32, 0x27, 0x7a, 0x61, 0x27, 0x7a, 0x63, 0x27, 0x7a, 0x65,
    0x27, 0x7a, 0x69, 0x27, 0x7a, 0x6f, 0x27, 0x7a, 0x73, 0x27, 0x7a, 0x74};
const uint8_t HuffDecoderCommon::table20_95_emit_[31] = {
    0x27, 0x26, 0x27, 0x2a, 0x27, 0x2c, 0x27, 0x3b, 0x27, 0x58, 0x27,
    0x5a, 0x27, 0x21, 0x27, 0x22, 0x27, 0x28, 0x27, 0x29, 0x27, 0x3f,
    0x27, 0x27, 0x2b, 0x27, 0x7c, 0x27, 0x23, 0x27, 0x3e};
const uint16_t HuffDecoderCommon::table20_95_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0062, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000,
    0x00b2, 0x0000, 0x00ba, 0x0000, 0x00ca, 0x00da, 0x00ea, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table20_96_emit_[204] = {
    0x2b, 0x30, 0x30, 0x2b, 0x30, 0x31, 0x2b, 0x30, 0x32, 0x2b, 0x30, 0x61,
    0x2b, 0x30, 0x63, 0x2b, 0x30, 0x65, 0x2b, 0x30, 0x69, 0x2b, 0x30, 0x6f,
    0x2b, 0x30, 0x73, 0x2b, 0x30, 0x74, 0x2b, 0x30, 0x20, 0x2b, 0x30, 0x25,
    0x2b, 0x30, 0x2d, 0x2b, 0x30, 0x2e, 0x2b, 0x30, 0x2f, 0x2b, 0x30, 0x33,
    0x2b, 0x30, 0x34, 0x2b, 0x30, 0x35, 0x2b, 0x30, 0x36, 0x2b, 0x30, 0x37,
    0x2b, 0x30, 0x38, 0x2b, 0x30, 0x39, 0x2b, 0x30, 0x3d, 0x2b, 0x30, 0x41,
    0x2b, 0x30, 0x5f, 0x2b, 0x30, 0x62, 0x2b, 0x30, 0x64, 0x2b, 0x30, 0x66,
    0x2b, 0x30, 0x67, 0x2b, 0x30, 0x68, 0x2b, 0x30, 0x6c, 0x2b, 0x30, 0x6d,
    0x2b, 0x30, 0x6e, 0x2b, 0x30, 0x70, 0x2b, 0x30, 0x72, 0x2b, 0x30, 0x75,
    0x2b, 0x30, 0x3a, 0x2b, 0x30, 0x42, 0x2b, 0x30, 0x43, 0x2b, 0x30, 0x44,
    0x2b, 0x30, 0x45, 0x2b, 0x30, 0x46, 0x2b, 0x30, 0x47, 0x2b, 0x30, 0x48,
    0x2b, 0x30, 0x49, 0x2b, 0x30, 0x4a, 0x2b, 0x30, 0x4b, 0x2b, 0x30, 0x4c,
    0x2b, 0x30, 0x4d, 0x2b, 0x30, 0x4e, 0x2b, 0x30, 0x4f, 0x2b, 0x30, 0x50,
    0x2b, 0x30, 0x51, 0x2b, 0x30, 0x52, 0x2b, 0x30, 0x53, 0x2b, 0x30, 0x54,
    0x2b, 0x30, 0x55, 0x2b, 0x30, 0x56, 0x2b, 0x30, 0x57, 0x2b, 0x30, 0x59,
    0x2b, 0x30, 0x6a, 0x2b, 0x30, 0x6b, 0x2b, 0x30, 0x71, 0x2b, 0x30, 0x76,
    0x2b, 0x30, 0x77, 0x2b, 0x30, 0x78, 0x2b, 0x30, 0x79, 0x2b, 0x30, 0x7a};
const uint8_t HuffDecoderCommon::table20_97_emit_[204] = {
    0x2b, 0x31, 0x30, 0x2b, 0x31, 0x31, 0x2b, 0x31, 0x32, 0x2b, 0x31, 0x61,
    0x2b, 0x31, 0x63, 0x2b, 0x31, 0x65, 0x2b, 0x31, 0x69, 0x2b, 0x31, 0x6f,
    0x2b, 0x31, 0x73, 0x2b, 0x31, 0x74, 0x2b, 0x31, 0x20, 0x2b, 0x31, 0x25,
    0x2b, 0x31, 0x2d, 0x2b, 0x31, 0x2e, 0x2b, 0x31, 0x2f, 0x2b, 0x31, 0x33,
    0x2b, 0x31, 0x34, 0x2b, 0x31, 0x35, 0x2b, 0x31, 0x36, 0x2b, 0x31, 0x37,
    0x2b, 0x31, 0x38, 0x2b, 0x31, 0x39, 0x2b, 0x31, 0x3d, 0x2b, 0x31, 0x41,
    0x2b, 0x31, 0x5f, 0x2b, 0x31, 0x62, 0x2b, 0x31, 0x64, 0x2b, 0x31, 0x66,
    0x2b, 0x31, 0x67, 0x2b, 0x31, 0x68, 0x2b, 0x31, 0x6c, 0x2b, 0x31, 0x6d,
    0x2b, 0x31, 0x6e, 0x2b, 0x31, 0x70, 0x2b, 0x31, 0x72, 0x2b, 0x31, 0x75,
    0x2b, 0x31, 0x3a, 0x2b, 0x31, 0x42, 0x2b, 0x31, 0x43, 0x2b, 0x31, 0x44,
    0x2b, 0x31, 0x45, 0x2b, 0x31, 0x46, 0x2b, 0x31, 0x47, 0x2b, 0x31, 0x48,
    0x2b, 0x31, 0x49, 0x2b, 0x31, 0x4a, 0x2b, 0x31, 0x4b, 0x2b, 0x31, 0x4c,
    0x2b, 0x31, 0x4d, 0x2b, 0x31, 0x4e, 0x2b, 0x31, 0x4f, 0x2b, 0x31, 0x50,
    0x2b, 0x31, 0x51, 0x2b, 0x31, 0x52, 0x2b, 0x31, 0x53, 0x2b, 0x31, 0x54,
    0x2b, 0x31, 0x55, 0x2b, 0x31, 0x56, 0x2b, 0x31, 0x57, 0x2b, 0x31, 0x59,
    0x2b, 0x31, 0x6a, 0x2b, 0x31, 0x6b, 0x2b, 0x31, 0x71, 0x2b, 0x31, 0x76,
    0x2b, 0x31, 0x77, 0x2b, 0x31, 0x78, 0x2b, 0x31, 0x79, 0x2b, 0x31, 0x7a};
const uint8_t HuffDecoderCommon::table20_98_emit_[204] = {
    0x2b, 0x32, 0x30, 0x2b, 0x32, 0x31, 0x2b, 0x32, 0x32, 0x2b, 0x32, 0x61,
    0x2b, 0x32, 0x63, 0x2b, 0x32, 0x65, 0x2b, 0x32, 0x69, 0x2b, 0x32, 0x6f,
    0x2b, 0x32, 0x73, 0x2b, 0x32, 0x74, 0x2b, 0x32, 0x20, 0x2b, 0x32, 0x25,
    0x2b, 0x32, 0x2d, 0x2b, 0x32, 0x2e, 0x2b, 0x32, 0x2f, 0x2b, 0x32, 0x33,
    0x2b, 0x32, 0x34, 0x2b, 0x32, 0x35, 0x2b, 0x32, 0x36, 0x2b, 0x32, 0x37,
    0x2b, 0x32, 0x38, 0x2b, 0x32, 0x39, 0x2b, 0x32, 0x3d, 0x2b, 0x32, 0x41,
    0x2b, 0x32, 0x5f, 0x2b, 0x32, 0x62, 0x2b, 0x32, 0x64, 0x2b, 0x32, 0x66,
    0x2b, 0x32, 0x67, 0x2b, 0x32, 0x68, 0x2b, 0x32, 0x6c, 0x2b, 0x32, 0x6d,
    0x2b, 0x32, 0x6e, 0x2b, 0x32, 0x70, 0x2b, 0x32, 0x72, 0x2b, 0x32, 0x75,
    0x2b, 0x32, 0x3a, 0x2b, 0x32, 0x42, 0x2b, 0x32, 0x43, 0x2b, 0x32, 0x44,
    0x2b, 0x32, 0x45, 0x2b, 0x32, 0x46, 0x2b, 0x32, 0x47, 0x2b, 0x32, 0x48,
    0x2b, 0x32, 0x49, 0x2b, 0x32, 0x4a, 0x2b, 0x32, 0x4b, 0x2b, 0x32, 0x4c,
    0x2b, 0x32, 0x4d, 0x2b, 0x32, 0x4e, 0x2b, 0x32, 0x4f, 0x2b, 0x32, 0x50,
    0x2b, 0x32, 0x51, 0x2b, 0x32, 0x52, 0x2b, 0x32, 0x53, 0x2b, 0x32, 0x54,
    0x2b, 0x32, 0x55, 0x2b, 0x32, 0x56, 0x2b, 0x32, 0x57, 0x2b, 0x32, 0x59,
    0x2b, 0x32, 0x6a, 0x2b, 0x32, 0x6b, 0x2b, 0x32, 0x71, 0x2b, 0x32, 0x76,
    0x2b, 0x32, 0x77, 0x2b, 0x32, 0x78, 0x2b, 0x32, 0x79, 0x2b, 0x32, 0x7a};
const uint8_t HuffDecoderCommon::table20_99_emit_[204] = {
    0x2b, 0x61, 0x30, 0x2b, 0x61, 0x31, 0x2b, 0x61, 0x32, 0x2b, 0x61, 0x61,
    0x2b, 0x61, 0x63, 0x2b, 0x61, 0x65, 0x2b, 0x61, 0x69, 0x2b, 0x61, 0x6f,
    0x2b, 0x61, 0x73, 0x2b, 0x61, 0x74, 0x2b, 0x61, 0x20, 0x2b, 0x61, 0x25,
    0x2b, 0x61, 0x2d, 0x2b, 0x61, 0x2e, 0x2b, 0x61, 0x2f, 0x2b, 0x61, 0x33,
    0x2b, 0x61, 0x34, 0x2b, 0x61, 0x35, 0x2b, 0x61, 0x36, 0x2b, 0x61, 0x37,
    0x2b, 0x61, 0x38, 0x2b, 0x61, 0x39, 0x2b, 0x61, 0x3d, 0x2b, 0x61, 0x41,
    0x2b, 0x61, 0x5f, 0x2b, 0x61, 0x62, 0x2b, 0x61, 0x64, 0x2b, 0x61, 0x66,
    0x2b, 0x61, 0x67, 0x2b, 0x61, 0x68, 0x2b, 0x61, 0x6c, 0x2b, 0x61, 0x6d,
    0x2b, 0x61, 0x6e, 0x2b, 0x61, 0x70, 0x2b, 0x61, 0x72, 0x2b, 0x61, 0x75,
    0x2b, 0x61, 0x3a, 0x2b, 0x61, 0x42, 0x2b, 0x61, 0x43, 0x2b, 0x61, 0x44,
    0x2b, 0x61, 0x45, 0x2b, 0x61, 0x46, 0x2b, 0x61, 0x47, 0x2b, 0x61, 0x48,
    0x2b, 0x61, 0x49, 0x2b, 0x61, 0x4a, 0x2b, 0x61, 0x4b, 0x2b, 0x61, 0x4c,
    0x2b, 0x61, 0x4d, 0x2b, 0x61, 0x4e, 0x2b, 0x61, 0x4f, 0x2b, 0x61, 0x50,
    0x2b, 0x61, 0x51, 0x2b, 0x61, 0x52, 0x2b, 0x61, 0x53, 0x2b, 0x61, 0x54,
    0x2b, 0x61, 0x55, 0x2b, 0x61, 0x56, 0x2b, 0x61, 0x57, 0x2b, 0x61, 0x59,
    0x2b, 0x61, 0x6a, 0x2b, 0x61, 0x6b, 0x2b, 0x61, 0x71, 0x2b, 0x61, 0x76,
    0x2b, 0x61, 0x77, 0x2b, 0x61, 0x78, 0x2b, 0x61, 0x79, 0x2b, 0x61, 0x7a};
const uint8_t HuffDecoderCommon::table20_100_emit_[204] = {
    0x2b, 0x63, 0x30, 0x2b, 0x63, 0x31, 0x2b, 0x63, 0x32, 0x2b, 0x63, 0x61,
    0x2b, 0x63, 0x63, 0x2b, 0x63, 0x65, 0x2b, 0x63, 0x69, 0x2b, 0x63, 0x6f,
    0x2b, 0x63, 0x73, 0x2b, 0x63, 0x74, 0x2b, 0x63, 0x20, 0x2b, 0x63, 0x25,
    0x2b, 0x63, 0x2d, 0x2b, 0x63, 0x2e, 0x2b, 0x63, 0x2f, 0x2b, 0x63, 0x33,
    0x2b, 0x63, 0x34, 0x2b, 0x63, 0x35, 0x2b, 0x63, 0x36, 0x2b, 0x63, 0x37,
    0x2b, 0x63, 0x38, 0x2b, 0x63, 0x39, 0x2b, 0x63, 0x3d, 0x2b, 0x63, 0x41,
    0x2b, 0x63, 0x5f, 0x2b, 0x63, 0x62, 0x2b, 0x63, 0x64, 0x2b, 0x63, 0x66,
    0x2b, 0x63, 0x67, 0x2b, 0x63, 0x68, 0x2b, 0x63, 0x6c, 0x2b, 0x63, 0x6d,
    0x2b, 0x63, 0x6e, 0x2b, 0x63, 0x70, 0x2b, 0x63, 0x72, 0x2b, 0x63, 0x75,
    0x2b, 0x63, 0x3a, 0x2b, 0x63, 0x42, 0x2b, 0x63, 0x43, 0x2b, 0x63, 0x44,
    0x2b, 0x63, 0x45, 0x2b, 0x63, 0x46, 0x2b, 0x63, 0x47, 0x2b, 0x63, 0x48,
    0x2b, 0x63, 0x49, 0x2b, 0x63, 0x4a, 0x2b, 0x63, 0x4b, 0x2b, 0x63, 0x4c,
    0x2b, 0x63, 0x4d, 0x2b, 0x63, 0x4e, 0x2b, 0x63, 0x4f, 0x2b, 0x63, 0x50,
    0x2b, 0x63, 0x51, 0x2b, 0x63, 0x52, 0x2b, 0x63, 0x53, 0x2b, 0x63, 0x54,
    0x2b, 0x63, 0x55, 0x2b, 0x63, 0x56, 0x2b, 0x63, 0x57, 0x2b, 0x63, 0x59,
    0x2b, 0x63, 0x6a, 0x2b, 0x63, 0x6b, 0x2b, 0x63, 0x71, 0x2b, 0x63, 0x76,
    0x2b, 0x63, 0x77, 0x2b, 0x63, 0x78, 0x2b, 0x63, 0x79, 0x2b, 0x63, 0x7a};
const uint8_t HuffDecoderCommon::table20_101_emit_[204] = {
    0x2b, 0x65, 0x30, 0x2b, 0x65, 0x31, 0x2b, 0x65, 0x32, 0x2b, 0x65, 0x61,
    0x2b, 0x65, 0x63, 0x2b, 0x65, 0x65, 0x2b, 0x65, 0x69, 0x2b, 0x65, 0x6f,
    0x2b, 0x65, 0x73, 0x2b, 0x65, 0x74, 0x2b, 0x65, 0x20, 0x2b, 0x65, 0x25,
    0x2b, 0x65, 0x2d, 0x2b, 0x65, 0x2e, 0x2b, 0x65, 0x2f, 0x2b, 0x65, 0x33,
    0x2b, 0x65, 0x34, 0x2b, 0x65, 0x35, 0x2b, 0x65, 0x36, 0x2b, 0x65, 0x37,
    0x2b, 0x65, 0x38, 0x2b, 0x65, 0x39, 0x2b, 0x65, 0x3d, 0x2b, 0x65, 0x41,
    0x2b, 0x65, 0x5f, 0x2b, 0x65, 0x62, 0x2b, 0x65, 0x64, 0x2b, 0x65, 0x66,
    0x2b, 0x65, 0x67, 0x2b, 0x65, 0x68, 0x2b, 0x65, 0x6c, 0x2b, 0x65, 0x6d,
    0x2b, 0x65, 0x6e, 0x2b, 0x65, 0x70, 0x2b, 0x65, 0x72, 0x2b, 0x65, 0x75,
    0x2b, 0x65, 0x3a, 0x2b, 0x65, 0x42, 0x2b, 0x65, 0x43, 0x2b, 0x65, 0x44,
    0x2b, 0x65, 0x45, 0x2b, 0x65, 0x46, 0x2b, 0x65, 0x47, 0x2b, 0x65, 0x48,
    0x2b, 0x65, 0x49, 0x2b, 0x65, 0x4a, 0x2b, 0x65, 0x4b, 0x2b, 0x65, 0x4c,
    0x2b, 0x65, 0x4d, 0x2b, 0x65, 0x4e, 0x2b, 0x65, 0x4f, 0x2b, 0x65, 0x50,
    0x2b, 0x65, 0x51, 0x2b, 0x65, 0x52, 0x2b, 0x65, 0x53, 0x2b, 0x65, 0x54,
    0x2b, 0x65, 0x55, 0x2b, 0x65, 0x56, 0x2b, 0x65, 0x57, 0x2b, 0x65, 0x59,
    0x2b, 0x65, 0x6a, 0x2b, 0x65, 0x6b, 0x2b, 0x65, 0x71, 0x2b, 0x65, 0x76,
    0x2b, 0x65, 0x77, 0x2b, 0x65, 0x78, 0x2b, 0x65, 0x79, 0x2b, 0x65, 0x7a};
const uint8_t HuffDecoderCommon::table20_102_emit_[204] = {
    0x2b, 0x69, 0x30, 0x2b, 0x69, 0x31, 0x2b, 0x69, 0x32, 0x2b, 0x69, 0x61,
    0x2b, 0x69, 0x63, 0x2b, 0x69, 0x65, 0x2b, 0x69, 0x69, 0x2b, 0x69, 0x6f,
    0x2b, 0x69, 0x73, 0x2b, 0x69, 0x74, 0x2b, 0x69, 0x20, 0x2b, 0x69, 0x25,
    0x2b, 0x69, 0x2d, 0x2b, 0x69, 0x2e, 0x2b, 0x69, 0x2f, 0x2b, 0x69, 0x33,
    0x2b, 0x69, 0x34, 0x2b, 0x69, 0x35, 0x2b, 0x69, 0x36, 0x2b, 0x69, 0x37,
    0x2b, 0x69, 0x38, 0x2b, 0x69, 0x39, 0x2b, 0x69, 0x3d, 0x2b, 0x69, 0x41,
    0x2b, 0x69, 0x5f, 0x2b, 0x69, 0x62, 0x2b, 0x69, 0x64, 0x2b, 0x69, 0x66,
    0x2b, 0x69, 0x67, 0x2b, 0x69, 0x68, 0x2b, 0x69, 0x6c, 0x2b, 0x69, 0x6d,
    0x2b, 0x69, 0x6e, 0x2b, 0x69, 0x70, 0x2b, 0x69, 0x72, 0x2b, 0x69, 0x75,
    0x2b, 0x69, 0x3a, 0x2b, 0x69, 0x42, 0x2b, 0x69, 0x43, 0x2b, 0x69, 0x44,
    0x2b, 0x69, 0x45, 0x2b, 0x69, 0x46, 0x2b, 0x69, 0x47, 0x2b, 0x69, 0x48,
    0x2b, 0x69, 0x49, 0x2b, 0x69, 0x4a, 0x2b, 0x69, 0x4b, 0x2b, 0x69, 0x4c,
    0x2b, 0x69, 0x4d, 0x2b, 0x69, 0x4e, 0x2b, 0x69, 0x4f, 0x2b, 0x69, 0x50,
    0x2b, 0x69, 0x51, 0x2b, 0x69, 0x52, 0x2b, 0x69, 0x53, 0x2b, 0x69, 0x54,
    0x2b, 0x69, 0x55, 0x2b, 0x69, 0x56, 0x2b, 0x69, 0x57, 0x2b, 0x69, 0x59,
    0x2b, 0x69, 0x6a, 0x2b, 0x69, 0x6b, 0x2b, 0x69, 0x71, 0x2b, 0x69, 0x76,
    0x2b, 0x69, 0x77, 0x2b, 0x69, 0x78, 0x2b, 0x69, 0x79, 0x2b, 0x69, 0x7a};
const uint8_t HuffDecoderCommon::table20_103_emit_[204] = {
    0x2b, 0x6f, 0x30, 0x2b, 0x6f, 0x31, 0x2b, 0x6f, 0x32, 0x2b, 0x6f, 0x61,
    0x2b, 0x6f, 0x63, 0x2b, 0x6f, 0x65, 0x2b, 0x6f, 0x69, 0x2b, 0x6f, 0x6f,
    0x2b, 0x6f, 0x73, 0x2b, 0x6f, 0x74, 0x2b, 0x6f, 0x20, 0x2b, 0x6f, 0x25,
    0x2b, 0x6f, 0x2d, 0x2b, 0x6f, 0x2e, 0x2b, 0x6f, 0x2f, 0x2b, 0x6f, 0x33,
    0x2b, 0x6f, 0x34, 0x2b, 0x6f, 0x35, 0x2b, 0x6f, 0x36, 0x2b, 0x6f, 0x37,
    0x2b, 0x6f, 0x38, 0x2b, 0x6f, 0x39, 0x2b, 0x6f, 0x3d, 0x2b, 0x6f, 0x41,
    0x2b, 0x6f, 0x5f, 0x2b, 0x6f, 0x62, 0x2b, 0x6f, 0x64, 0x2b, 0x6f, 0x66,
    0x2b, 0x6f, 0x67, 0x2b, 0x6f, 0x68, 0x2b, 0x6f, 0x6c, 0x2b, 0x6f, 0x6d,
    0x2b, 0x6f, 0x6e, 0x2b, 0x6f, 0x70, 0x2b, 0x6f, 0x72, 0x2b, 0x6f, 0x75,
    0x2b, 0x6f, 0x3a, 0x2b, 0x6f, 0x42, 0x2b, 0x6f, 0x43, 0x2b, 0x6f, 0x44,
    0x2b, 0x6f, 0x45, 0x2b, 0x6f, 0x46, 0x2b, 0x6f, 0x47, 0x2b, 0x6f, 0x48,
    0x2b, 0x6f, 0x49, 0x2b, 0x6f, 0x4a, 0x2b, 0x6f, 0x4b, 0x2b, 0x6f, 0x4c,
    0x2b, 0x6f, 0x4d, 0x2b, 0x6f, 0x4e, 0x2b, 0x6f, 0x4f, 0x2b, 0x6f, 0x50,
    0x2b, 0x6f, 0x51, 0x2b, 0x6f, 0x52, 0x2b, 0x6f, 0x53, 0x2b, 0x6f, 0x54,
    0x2b, 0x6f, 0x55, 0x2b, 0x6f, 0x56, 0x2b, 0x6f, 0x57, 0x2b, 0x6f, 0x59,
    0x2b, 0x6f, 0x6a, 0x2b, 0x6f, 0x6b, 0x2b, 0x6f, 0x71, 0x2b, 0x6f, 0x76,
    0x2b, 0x6f, 0x77, 0x2b, 0x6f, 0x78, 0x2b, 0x6f, 0x79, 0x2b, 0x6f, 0x7a};
const uint8_t HuffDecoderCommon::table20_104_emit_[204] = {
    0x2b, 0x73, 0x30, 0x2b, 0x73, 0x31, 0x2b, 0x73, 0x32, 0x2b, 0x73, 0x61,
    0x2b, 0x73, 0x63, 0x2b, 0x73, 0x65, 0x2b, 0x73, 0x69, 0x2b, 0x73, 0x6f,
    0x2b, 0x73, 0x73, 0x2b, 0x73, 0x74, 0x2b, 0x73, 0x20, 0x2b, 0x73, 0x25,
    0x2b, 0x73, 0x2d, 0x2b, 0x73, 0x2e, 0x2b, 0x73, 0x2f, 0x2b, 0x73, 0x33,
    0x2b, 0x73, 0x34, 0x2b, 0x73, 0x35, 0x2b, 0x73, 0x36, 0x2b, 0x73, 0x37,
    0x2b, 0x73, 0x38, 0x2b, 0x73, 0x39, 0x2b, 0x73, 0x3d, 0x2b, 0x73, 0x41,
    0x2b, 0x73, 0x5f, 0x2b, 0x73, 0x62, 0x2b, 0x73, 0x64, 0x2b, 0x73, 0x66,
    0x2b, 0x73, 0x67, 0x2b, 0x73, 0x68, 0x2b, 0x73, 0x6c, 0x2b, 0x73, 0x6d,
    0x2b, 0x73, 0x6e, 0x2b, 0x73, 0x70, 0x2b, 0x73, 0x72, 0x2b, 0x73, 0x75,
    0x2b, 0x73, 0x3a, 0x2b, 0x73, 0x42, 0x2b, 0x73, 0x43, 0x2b, 0x73, 0x44,
    0x2b, 0x73, 0x45, 0x2b, 0x73, 0x46, 0x2b, 0x73, 0x47, 0x2b, 0x73, 0x48,
    0x2b, 0x73, 0x49, 0x2b, 0x73, 0x4a, 0x2b, 0x73, 0x4b, 0x2b, 0x73, 0x4c,
    0x2b, 0x73, 0x4d, 0x2b, 0x73, 0x4e, 0x2b, 0x73, 0x4f, 0x2b, 0x73, 0x50,
    0x2b, 0x73, 0x51, 0x2b, 0x73, 0x52, 0x2b, 0x73, 0x53, 0x2b, 0x73, 0x54,
    0x2b, 0x73, 0x55, 0x2b, 0x73, 0x56, 0x2b, 0x73, 0x57, 0x2b, 0x73, 0x59,
    0x2b, 0x73, 0x6a, 0x2b, 0x73, 0x6b, 0x2b, 0x73, 0x71, 0x2b, 0x73, 0x76,
    0x2b, 0x73, 0x77, 0x2b, 0x73, 0x78, 0x2b, 0x73, 0x79, 0x2b, 0x73, 0x7a};
const uint8_t HuffDecoderCommon::table20_105_emit_[204] = {
    0x2b, 0x74, 0x30, 0x2b, 0x74, 0x31, 0x2b, 0x74, 0x32, 0x2b, 0x74, 0x61,
    0x2b, 0x74, 0x63, 0x2b, 0x74, 0x65, 0x2b, 0x74, 0x69, 0x2b, 0x74, 0x6f,
    0x2b, 0x74, 0x73, 0x2b, 0x74, 0x74, 0x2b, 0x74, 0x20, 0x2b, 0x74, 0x25,
    0x2b, 0x74, 0x2d, 0x2b, 0x74, 0x2e, 0x2b, 0x74, 0x2f, 0x2b, 0x74, 0x33,
    0x2b, 0x74, 0x34, 0x2b, 0x74, 0x35, 0x2b, 0x74, 0x36, 0x2b, 0x74, 0x37,
    0x2b, 0x74, 0x38, 0x2b, 0x74, 0x39, 0x2b, 0x74, 0x3d, 0x2b, 0x74, 0x41,
    0x2b, 0x74, 0x5f, 0x2b, 0x74, 0x62, 0x2b, 0x74, 0x64, 0x2b, 0x74, 0x66,
    0x2b, 0x74, 0x67, 0x2b, 0x74, 0x68, 0x2b, 0x74, 0x6c, 0x2b, 0x74, 0x6d,
    0x2b, 0x74, 0x6e, 0x2b, 0x74, 0x70, 0x2b, 0x74, 0x72, 0x2b, 0x74, 0x75,
    0x2b, 0x74, 0x3a, 0x2b, 0x74, 0x42, 0x2b, 0x74, 0x43, 0x2b, 0x74, 0x44,
    0x2b, 0x74, 0x45, 0x2b, 0x74, 0x46, 0x2b, 0x74, 0x47, 0x2b, 0x74, 0x48,
    0x2b, 0x74, 0x49, 0x2b, 0x74, 0x4a, 0x2b, 0x74, 0x4b, 0x2b, 0x74, 0x4c,
    0x2b, 0x74, 0x4d, 0x2b, 0x74, 0x4e, 0x2b, 0x74, 0x4f, 0x2b, 0x74, 0x50,
    0x2b, 0x74, 0x51, 0x2b, 0x74, 0x52, 0x2b, 0x74, 0x53, 0x2b, 0x74, 0x54,
    0x2b, 0x74, 0x55, 0x2b, 0x74, 0x56, 0x2b, 0x74, 0x57, 0x2b, 0x74, 0x59,
    0x2b, 0x74, 0x6a, 0x2b, 0x74, 0x6b, 0x2b, 0x74, 0x71, 0x2b, 0x74, 0x76,
    0x2b, 0x74, 0x77, 0x2b, 0x74, 0x78, 0x2b, 0x74, 0x79, 0x2b, 0x74, 0x7a};
const uint8_t HuffDecoderCommon::table20_106_emit_[216] = {
    0x2b, 0x20, 0x30, 0x2b, 0x20, 0x31, 0x2b, 0x20, 0x32, 0x2b, 0x20, 0x61,
    0x2b, 0x20, 0x63, 0x2b, 0x20, 0x65, 0x2b, 0x20, 0x69, 0x2b, 0x20, 0x6f,
    0x2b, 0x20, 0x73, 0x2b, 0x20, 0x74, 0x2b, 0x20, 0x20, 0x2b, 0x20, 0x25,
    0x2b, 0x20, 0x2d, 0x2b, 0x20, 0x2e, 0x2b, 0x20, 0x2f, 0x2b, 0x20, 0x33,
    0x2b, 0x20, 0x34, 0x2b, 0x20, 0x35, 0x2b, 0x20, 0x36, 0x2b, 0x20, 0x37,
    0x2b, 0x20, 0x38, 0x2b, 0x20, 0x39, 0x2b, 0x20, 0x3d, 0x2b, 0x20, 0x41,
    0x2b, 0x20, 0x5f, 0x2b, 0x20, 0x62, 0x2b, 0x20, 0x64, 0x2b, 0x20, 0x66,
    0x2b, 0x20, 0x67, 0x2b, 0x20, 0x68, 0x2b, 0x20, 0x6c, 0x2b, 0x20, 0x6d,
    0x2b, 0x20, 0x6e, 0x2b, 0x20, 0x70, 0x2b, 0x20, 0x72, 0x2b, 0x20, 0x75,
    0x2b, 0x25, 0x30, 0x2b, 0x25, 0x31, 0x2b, 0x25, 0x32, 0x2b, 0x25, 0x61,
    0x2b, 0x25, 0x63, 0x2b, 0x25, 0x65, 0x2b, 0x25, 0x69, 0x2b, 0x25, 0x6f,
    0x2b, 0x25, 0x73, 0x2b, 0x25, 0x74, 0x2b, 0x25, 0x20, 0x2b, 0x25, 0x25,
    0x2b, 0x25, 0x2d, 0x2b, 0x25, 0x2e, 0x2b, 0x25, 0x2f, 0x2b, 0x25, 0x33,
    0x2b, 0x25, 0x34, 0x2b, 0x25, 0x35, 0x2b, 0x25, 0x36, 0x2b, 0x25, 0x37,
    0x2b, 0x25, 0x38, 0x2b, 0x25, 0x39, 0x2b, 0x25, 0x3d, 0x2b, 0x25, 0x41,
    0x2b, 0x25, 0x5f, 0x2b, 0x25, 0x62, 0x2b, 0x25, 0x64, 0x2b, 0x25, 0x66,
    0x2b, 0x25, 0x67, 0x2b, 0x25, 0x68, 0x2b, 0x25, 0x6c, 0x2b, 0x25, 0x6d,
    0x2b, 0x25, 0x6e, 0x2b, 0x25, 0x70, 0x2b, 0x25, 0x72, 0x2b, 0x25, 0x75};
const uint8_t HuffDecoderCommon::table20_107_emit_[216] = {
    0x2b, 0x2d, 0x30, 0x2b, 0x2d, 0x31, 0x2b, 0x2d, 0x32, 0x2b, 0x2d, 0x61,
    0x2b, 0x2d, 0x63, 0x2b, 0x2d, 0x65, 0x2b, 0x2d, 0x69, 0x2b, 0x2d, 0x6f,
    0x2b, 0x2d, 0x73, 0x2b, 0x2d, 0x74, 0x2b, 0x2d, 0x20, 0x2b, 0x2d, 0x25,
    0x2b, 0x2d, 0x2d, 0x2b, 0x2d, 0x2e, 0x2b, 0x2d, 0x2f, 0x2b, 0x2d, 0x33,
    0x2b, 0x2d, 0x34, 0x2b, 0x2d, 0x35, 0x2b, 0x2d, 0x36, 0x2b, 0x2d, 0x37,
    0x2b, 0x2d, 0x38, 0x2b, 0x2d, 0x39, 0x2b, 0x2d, 0x3d, 0x2b, 0x2d, 0x41,
    0x2b, 0x2d, 0x5f, 0x2b, 0x2d, 0x62, 0x2b, 0x2d, 0x64, 0x2b, 0x2d, 0x66,
    0x2b, 0x2d, 0x67, 0x2b, 0x2d, 0x68, 0x2b, 0x2d, 0x6c, 0x2b, 0x2d, 0x6d,
    0x2b, 0x2d, 0x6e, 0x2b, 0x2d, 0x70, 0x2b, 0x2d, 0x72, 0x2b, 0x2d, 0x75,
    0x2b, 0x2e, 0x30, 0x2b, 0x2e, 0x31, 0x2b, 0x2e, 0x32, 0x2b, 0x2e, 0x61,
    0x2b, 0x2e, 0x63, 0x2b, 0x2e, 0x65, 0x2b, 0x2e, 0x69, 0x2b, 0x2e, 0x6f,
    0x2b, 0x2e, 0x73, 0x2b, 0x2e, 0x74, 0x2b, 0x2e, 0x20, 0x2b, 0x2e, 0x25,
    0x2b, 0x2e, 0x2d, 0x2b, 0x2e, 0x2e, 0x2b, 0x2e, 0x2f, 0x2b, 0x2e, 0x33,
    0x2b, 0x2e, 0x34, 0x2b, 0x2e, 0x35, 0x2b, 0x2e, 0x36, 0x2b, 0x2e, 0x37,
    0x2b, 0x2e, 0x38, 0x2b, 0x2e, 0x39, 0x2b, 0x2e, 0x3d, 0x2b, 0x2e, 0x41,
    0x2b, 0x2e, 0x5f, 0x2b, 0x2e, 0x62, 0x2b, 0x2e, 0x64, 0x2b, 0x2e, 0x66,
    0x2b, 0x2e, 0x67, 0x2b, 0x2e, 0x68, 0x2b, 0x2e, 0x6c, 0x2b, 0x2e, 0x6d,
    0x2b, 0x2e, 0x6e, 0x2b, 0x2e, 0x70, 0x2b, 0x2e, 0x72, 0x2b, 0x2e, 0x75};
const uint8_t HuffDecoderCommon::table20_108_emit_[216] = {
    0x2b, 0x2f, 0x30, 0x2b, 0x2f, 0x31, 0x2b, 0x2f, 0x32, 0x2b, 0x2f, 0x61,
    0x2b, 0x2f, 0x63, 0x2b, 0x2f, 0x65, 0x2b, 0x2f, 0x69, 0x2b, 0x2f, 0x6f,
    0x2b, 0x2f, 0x73, 0x2b, 0x2f, 0x74, 0x2b, 0x2f, 0x20, 0x2b, 0x2f, 0x25,
    0x2b, 0x2f, 0x2d, 0x2b, 0x2f, 0x2e, 0x2b, 0x2f, 0x2f, 0x2b, 0x2f, 0x33,
    0x2b, 0x2f, 0x34, 0x2b, 0x2f, 0x35, 0x2b, 0x2f, 0x36, 0x2b, 0x2f, 0x37,
    0x2b, 0x2f, 0x38, 0x2b, 0x2f, 0x39, 0x2b, 0x2f, 0x3d, 0x2b, 0x2f, 0x41,
    0x2b, 0x2f, 0x5f, 0x2b, 0x2f, 0x62, 0x2b, 0x2f, 0x64, 0x2b, 0x2f, 0x66,
    0x2b, 0x2f, 0x67, 0x2b, 0x2f, 0x68, 0x2b, 0x2f, 0x6c, 0x2b, 0x2f, 0x6d,
    0x2b, 0x2f, 0x6e, 0x2b, 0x2f, 0x70, 0x2b, 0x2f, 0x72, 0x2b, 0x2f, 0x75,
    0x2b, 0x33, 0x30, 0x2b, 0x33, 0x31, 0x2b, 0x33, 0x32, 0x2b, 0x33, 0x61,
    0x2b, 0x33, 0x63, 0x2b, 0x33, 0x65, 0x2b, 0x33, 0x69, 0x2b, 0x33, 0x6f,
    0x2b, 0x33, 0x73, 0x2b, 0x33, 0x74, 0x2b, 0x33, 0x20, 0x2b, 0x33, 0x25,
    0x2b, 0x33, 0x2d, 0x2b, 0x33, 0x2e, 0x2b, 0x33, 0x2f, 0x2b, 0x33, 0x33,
    0x2b, 0x33, 0x34, 0x2b, 0x33, 0x35, 0x2b, 0x33, 0x36, 0x2b, 0x33, 0x37,
    0x2b, 0x33, 0x38, 0x2b, 0x33, 0x39, 0x2b, 0x33, 0x3d, 0x2b, 0x33, 0x41,
    0x2b, 0x33, 0x5f, 0x2b, 0x33, 0x62, 0x2b, 0x33, 0x64, 0x2b, 0x33, 0x66,
    0x2b, 0x33, 0x67, 0x2b, 0x33, 0x68, 0x2b, 0x33, 0x6c, 0x2b, 0x33, 0x6d,
    0x2b, 0x33, 0x6e, 0x2b, 0x33, 0x70, 0x2b, 0x33, 0x72, 0x2b, 0x33, 0x75};
const uint8_t HuffDecoderCommon::table20_109_emit_[216] = {
    0x2b, 0x34, 0x30, 0x2b, 0x34, 0x31, 0x2b, 0x34, 0x32, 0x2b, 0x34, 0x61,
    0x2b, 0x34, 0x63, 0x2b, 0x34, 0x65, 0x2b, 0x34, 0x69, 0x2b, 0x34, 0x6f,
    0x2b, 0x34, 0x73, 0x2b, 0x34, 0x74, 0x2b, 0x34, 0x20, 0x2b, 0x34, 0x25,
    0x2b, 0x34, 0x2d, 0x2b, 0x34, 0x2e, 0x2b, 0x34, 0x2f, 0x2b, 0x34, 0x33,
    0x2b, 0x34, 0x34, 0x2b, 0x34, 0x35, 0x2b, 0x34, 0x36, 0x2b, 0x34, 0x37,
    0x2b, 0x34, 0x38, 0x2b, 0x34, 0x39, 0x2b, 0x34, 0x3d, 0x2b, 0x34, 0x41,
    0x2b, 0x34, 0x5f, 0x2b, 0x34, 0x62, 0x2b, 0x34, 0x64, 0x2b, 0x34, 0x66,
    0x2b, 0x34, 0x67, 0x2b, 0x34, 0x68, 0x2b, 0x34, 0x6c, 0x2b, 0x34, 0x6d,
    0x2b, 0x34, 0x6e, 0x2b, 0x34, 0x70, 0x2b, 0x34, 0x72, 0x2b, 0x34, 0x75,
    0x2b, 0x35, 0x30, 0x2b, 0x35, 0x31, 0x2b, 0x35, 0x32, 0x2b, 0x35, 0x61,
    0x2b, 0x35, 0x63, 0x2b, 0x35, 0x65, 0x2b, 0x35, 0x69, 0x2b, 0x35, 0x6f,
    0x2b, 0x35, 0x73, 0x2b, 0x35, 0x74, 0x2b, 0x35, 0x20, 0x2b, 0x35, 0x25,
    0x2b, 0x35, 0x2d, 0x2b, 0x35, 0x2e, 0x2b, 0x35, 0x2f, 0x2b, 0x35, 0x33,
    0x2b, 0x35, 0x34, 0x2b, 0x35, 0x35, 0x2b, 0x35, 0x36, 0x2b, 0x35, 0x37,
    0x2b, 0x35, 0x38, 0x2b, 0x35, 0x39, 0x2b, 0x35, 0x3d, 0x2b, 0x35, 0x41,
    0x2b, 0x35, 0x5f, 0x2b, 0x35, 0x62, 0x2b, 0x35, 0x64, 0x2b, 0x35, 0x66,
    0x2b, 0x35, 0x67, 0x2b, 0x35, 0x68, 0x2b, 0x35, 0x6c, 0x2b, 0x35, 0x6d,
    0x2b, 0x35, 0x6e, 0x2b, 0x35, 0x70, 0x2b, 0x35, 0x72, 0x2b, 0x35, 0x75};
const uint8_t HuffDecoderCommon::table20_110_emit_[216] = {
    0x2b, 0x36, 0x30, 0x2b, 0x36, 0x31, 0x2b, 0x36, 0x32, 0x2b, 0x36, 0x61,
    0x2b, 0x36, 0x63, 0x2b, 0x36, 0x65, 0x2b, 0x36, 0x69, 0x2b, 0x36, 0x6f,
    0x2b, 0x36, 0x73, 0x2b, 0x36, 0x74, 0x2b, 0x36, 0x20, 0x2b, 0x36, 0x25,
    0x2b, 0x36, 0x2d, 0x2b, 0x36, 0x2e, 0x2b, 0x36, 0x2f, 0x2b, 0x36, 0x33,
    0x2b, 0x36, 0x34, 0x2b, 0x36, 0x35, 0x2b, 0x36, 0x36, 0x2b, 0x36, 0x37,
    0x2b, 0x36, 0x38, 0x2b, 0x36, 0x39, 0x2b, 0x36, 0x3d, 0x2b, 0x36, 0x41,
    0x2b, 0x36, 0x5f, 0x2b, 0x36, 0x62, 0x2b, 0x36, 0x64, 0x2b, 0x36, 0x66,
    0x2b, 0x36, 0x67, 0x2b, 0x36, 0x68, 0x2b, 0x36, 0x6c, 0x2b, 0x36, 0x6d,
    0x2b, 0x36, 0x6e, 0x2b, 0x36, 0x70, 0x2b, 0x36, 0x72, 0x2b, 0x36, 0x75,
    0x2b, 0x37, 0x30, 0x2b, 0x37, 0x31, 0x2b, 0x37, 0x32, 0x2b, 0x37, 0x61,
    0x2b, 0x37, 0x63, 0x2b, 0x37, 0x65, 0x2b, 0x37, 0x69, 0x2b, 0x37, 0x6f,
    0x2b, 0x37, 0x73, 0x2b, 0x37, 0x74, 0x2b, 0x37, 0x20, 0x2b, 0x37, 0x25,
    0x2b, 0x37, 0x2d, 0x2b, 0x37, 0x2e, 0x2b, 0x37, 0x2f, 0x2b, 0x37, 0x33,
    0x2b, 0x37, 0x34, 0x2b, 0x37, 0x35, 0x2b, 0x37, 0x36, 0x2b, 0x37, 0x37,
    0x2b, 0x37, 0x38, 0x2b, 0x37, 0x39, 0x2b, 0x37, 0x3d, 0x2b, 0x37, 0x41,
    0x2b, 0x37, 0x5f, 0x2b, 0x37, 0x62, 0x2b, 0x37, 0x64, 0x2b, 0x37, 0x66,
    0x2b, 0x37, 0x67, 0x2b, 0x37, 0x68, 0x2b, 0x37, 0x6c, 0x2b, 0x37, 0x6d,
    0x2b, 0x37, 0x6e, 0x2b, 0x37, 0x70, 0x2b, 0x37, 0x72, 0x2b, 0x37, 0x75};
const uint8_t HuffDecoderCommon::table20_111_emit_[216] = {
    0x2b, 0x38, 0x30, 0x2b, 0x38, 0x31, 0x2b, 0x38, 0x32, 0x2b, 0x38, 0x61,
    0x2b, 0x38, 0x63, 0x2b, 0x38, 0x65, 0x2b, 0x38, 0x69, 0x2b, 0x38, 0x6f,
    0x2b, 0x38, 0x73, 0x2b, 0x38, 0x74, 0x2b, 0x38, 0x20, 0x2b, 0x38, 0x25,
    0x2b, 0x38, 0x2d, 0x2b, 0x38, 0x2e, 0x2b, 0x38, 0x2f, 0x2b, 0x38, 0x33,
    0x2b, 0x38, 0x34, 0x2b, 0x38, 0x35, 0x2b, 0x38, 0x36, 0x2b, 0x38, 0x37,
    0x2b, 0x38, 0x38, 0x2b, 0x38, 0x39, 0x2b, 0x38, 0x3d, 0x2b, 0x38, 0x41,
    0x2b, 0x38, 0x5f, 0x2b, 0x38, 0x62, 0x2b, 0x38, 0x64, 0x2b, 0x38, 0x66,
    0x2b, 0x38, 0x67, 0x2b, 0x38, 0x68, 0x2b, 0x38, 0x6c, 0x2b, 0x38, 0x6d,
    0x2b, 0x38, 0x6e, 0x2b, 0x38, 0x70, 0x2b, 0x38, 0x72, 0x2b, 0x38, 0x75,
    0x2b, 0x39, 0x30, 0x2b, 0x39, 0x31, 0x2b, 0x39, 0x32, 0x2b, 0x39, 0x61,
    0x2b, 0x39, 0x63, 0x2b, 0x39, 0x65, 0x2b, 0x39, 0x69, 0x2b, 0x39, 0x6f,
    0x2b, 0x39, 0x73, 0x2b, 0x39, 0x74, 0x2b, 0x39, 0x20, 0x2b, 0x39, 0x25,
    0x2b, 0x39, 0x2d, 0x2b, 0x39, 0x2e, 0x2b, 0x39, 0x2f, 0x2b, 0x39, 0x33,
    0x2b, 0x39, 0x34, 0x2b, 0x39, 0x35, 0x2b, 0x39, 0x36, 0x2b, 0x39, 0x37,
    0x2b, 0x39, 0x38, 0x2b, 0x39, 0x39, 0x2b, 0x39, 0x3d, 0x2b, 0x39, 0x41,
    0x2b, 0x39, 0x5f, 0x2b, 0x39, 0x62, 0x2b, 0x39, 0x64, 0x2b, 0x39, 0x66,
    0x2b, 0x39, 0x67, 0x2b, 0x39, 0x68, 0x2b, 0x39, 0x6c, 0x2b, 0x39, 0x6d,
    0x2b, 0x39, 0x6e, 0x2b, 0x39, 0x70, 0x2b, 0x39, 0x72, 0x2b, 0x39, 0x75};
const uint8_t HuffDecoderCommon::table20_112_emit_[216] = {
    0x2b, 0x3d, 0x30, 0x2b, 0x3d, 0x31, 0x2b, 0x3d, 0x32, 0x2b, 0x3d, 0x61,
    0x2b, 0x3d, 0x63, 0x2b, 0x3d, 0x65, 0x2b, 0x3d, 0x69, 0x2b, 0x3d, 0x6f,
    0x2b, 0x3d, 0x73, 0x2b, 0x3d, 0x74, 0x2b, 0x3d, 0x20, 0x2b, 0x3d, 0x25,
    0x2b, 0x3d, 0x2d, 0x2b, 0x3d, 0x2e, 0x2b, 0x3d, 0x2f, 0x2b, 0x3d, 0x33,
    0x2b, 0x3d, 0x34, 0x2b, 0x3d, 0x35, 0x2b, 0x3d, 0x36, 0x2b, 0x3d, 0x37,
    0x2b, 0x3d, 0x38, 0x2b, 0x3d, 0x39, 0x2b, 0x3d, 0x3d, 0x2b, 0x3d, 0x41,
    0x2b, 0x3d, 0x5f, 0x2b, 0x3d, 0x62, 0x2b, 0x3d, 0x64, 0x2b, 0x3d, 0x66,
    0x2b, 0x3d, 0x67, 0x2b, 0x3d, 0x68, 0x2b, 0x3d, 0x6c, 0x2b, 0x3d, 0x6d,
    0x2b, 0x3d, 0x6e, 0x2b, 0x3d, 0x70, 0x2b, 0x3d, 0x72, 0x2b, 0x3d, 0x75,
    0x2b, 0x41, 0x30, 0x2b, 0x41, 0x31, 0x2b, 0x41, 0x32, 0x2b, 0x41, 0x61,
    0x2b, 0x41, 0x63, 0x2b, 0x41, 0x65, 0x2b, 0x41, 0x69, 0x2b, 0x41, 0x6f,
    0x2b, 0x41, 0x73, 0x2b, 0x41, 0x74, 0x2b, 0x41, 0x20, 0x2b, 0x41, 0x25,
    0x2b, 0x41, 0x2d, 0x2b, 0x41, 0x2e, 0x2b, 0x41, 0x2f, 0x2b, 0x41, 0x33,
    0x2b, 0x41, 0x34, 0x2b, 0x41, 0x35, 0x2b, 0x41, 0x36, 0x2b, 0x41, 0x37,
    0x2b, 0x41, 0x38, 0x2b, 0x41, 0x39, 0x2b, 0x41, 0x3d, 0x2b, 0x41, 0x41,
    0x2b, 0x41, 0x5f, 0x2b, 0x41, 0x62, 0x2b, 0x41, 0x64, 0x2b, 0x41, 0x66,
    0x2b, 0x41, 0x67, 0x2b, 0x41, 0x68, 0x2b, 0x41, 0x6c, 0x2b, 0x41, 0x6d,
    0x2b, 0x41, 0x6e, 0x2b, 0x41, 0x70, 0x2b, 0x41, 0x72, 0x2b, 0x41, 0x75};
const uint8_t HuffDecoderCommon::table20_113_emit_[216] = {
    0x2b, 0x5f, 0x30, 0x2b, 0x5f, 0x31, 0x2b, 0x5f, 0x32, 0x2b, 0x5f, 0x61,
    0x2b, 0x5f, 0x63, 0x2b, 0x5f, 0x65, 0x2b, 0x5f, 0x69, 0x2b, 0x5f, 0x6f,
    0x2b, 0x5f, 0x73, 0x2b, 0x5f, 0x74, 0x2b, 0x5f, 0x20, 0x2b, 0x5f, 0x25,
    0x2b, 0x5f, 0x2d, 0x2b, 0x5f, 0x2e, 0x2b, 0x5f, 0x2f, 0x2b, 0x5f, 0x33,
    0x2b, 0x5f, 0x34, 0x2b, 0x5f, 0x35, 0x2b, 0x5f, 0x36, 0x2b, 0x5f, 0x37,
    0x2b, 0x5f, 0x38, 0x2b, 0x5f, 0x39, 0x2b, 0x5f, 0x3d, 0x2b, 0x5f, 0x41,
    0x2b, 0x5f, 0x5f, 0x2b, 0x5f, 0x62, 0x2b, 0x5f, 0x64, 0x2b, 0x5f, 0x66,
    0x2b, 0x5f, 0x67, 0x2b, 0x5f, 0x68, 0x2b, 0x5f, 0x6c, 0x2b, 0x5f, 0x6d,
    0x2b, 0x5f, 0x6e, 0x2b, 0x5f, 0x70, 0x2b, 0x5f, 0x72, 0x2b, 0x5f, 0x75,
    0x2b, 0x62, 0x30, 0x2b, 0x62, 0x31, 0x2b, 0x62, 0x32, 0x2b, 0x62, 0x61,
    0x2b, 0x62, 0x63, 0x2b, 0x62, 0x65, 0x2b, 0x62, 0x69, 0x2b, 0x62, 0x6f,
    0x2b, 0x62, 0x73, 0x2b, 0x62, 0x74, 0x2b, 0x62, 0x20, 0x2b, 0x62, 0x25,
    0x2b, 0x62, 0x2d, 0x2b, 0x62, 0x2e, 0x2b, 0x62, 0x2f, 0x2b, 0x62, 0x33,
    0x2b, 0x62, 0x34, 0x2b, 0x62, 0x35, 0x2b, 0x62, 0x36, 0x2b, 0x62, 0x37,
    0x2b, 0x62, 0x38, 0x2b, 0x62, 0x39, 0x2b, 0x62, 0x3d, 0x2b, 0x62, 0x41,
    0x2b, 0x62, 0x5f, 0x2b, 0x62, 0x62, 0x2b, 0x62, 0x64, 0x2b, 0x62, 0x66,
    0x2b, 0x62, 0x67, 0x2b, 0x62, 0x68, 0x2b, 0x62, 0x6c, 0x2b, 0x62, 0x6d,
    0x2b, 0x62, 0x6e, 0x2b, 0x62, 0x70, 0x2b, 0x62, 0x72, 0x2b, 0x62, 0x75};
const uint8_t HuffDecoderCommon::table20_114_emit_[216] = {
    0x2b, 0x64, 0x30, 0x2b, 0x64, 0x31, 0x2b, 0x64, 0x32, 0x2b, 0x64, 0x61,
    0x2b, 0x64, 0x63, 0x2b, 0x64, 0x65, 0x2b, 0x64, 0x69, 0x2b, 0x64, 0x6f,
    0x2b, 0x64, 0x73, 0x2b, 0x64, 0x74, 0x2b, 0x64, 0x20, 0x2b, 0x64, 0x25,
    0x2b, 0x64, 0x2d, 0x2b, 0x64, 0x2e, 0x2b, 0x64, 0x2f, 0x2b, 0x64, 0x33,
    0x2b, 0x64, 0x34, 0x2b, 0x64, 0x35, 0x2b, 0x64, 0x36, 0x2b, 0x64, 0x37,
    0x2b, 0x64, 0x38, 0x2b, 0x64, 0x39, 0x2b, 0x64, 0x3d, 0x2b, 0x64, 0x41,
    0x2b, 0x64, 0x5f, 0x2b, 0x64, 0x62, 0x2b, 0x64, 0x64, 0x2b, 0x64, 0x66,
    0x2b, 0x64, 0x67, 0x2b, 0x64, 0x68, 0x2b, 0x64, 0x6c, 0x2b, 0x64, 0x6d,
    0x2b, 0x64, 0x6e, 0x2b, 0x64, 0x70, 0x2b, 0x64, 0x72, 0x2b, 0x64, 0x75,
    0x2b, 0x66, 0x30, 0x2b, 0x66, 0x31, 0x2b, 0x66, 0x32, 0x2b, 0x66, 0x61,
    0x2b, 0x66, 0x63, 0x2b, 0x66, 0x65, 0x2b, 0x66, 0x69, 0x2b, 0x66, 0x6f,
    0x2b, 0x66, 0x73, 0x2b, 0x66, 0x74, 0x2b, 0x66, 0x20, 0x2b, 0x66, 0x25,
    0x2b, 0x66, 0x2d, 0x2b, 0x66, 0x2e, 0x2b, 0x66, 0x2f, 0x2b, 0x66, 0x33,
    0x2b, 0x66, 0x34, 0x2b, 0x66, 0x35, 0x2b, 0x66, 0x36, 0x2b, 0x66, 0x37,
    0x2b, 0x66, 0x38, 0x2b, 0x66, 0x39, 0x2b, 0x66, 0x3d, 0x2b, 0x66, 0x41,
    0x2b, 0x66, 0x5f, 0x2b, 0x66, 0x62, 0x2b, 0x66, 0x64, 0x2b, 0x66, 0x66,
    0x2b, 0x66, 0x67, 0x2b, 0x66, 0x68, 0x2b, 0x66, 0x6c, 0x2b, 0x66, 0x6d,
    0x2b, 0x66, 0x6e, 0x2b, 0x66, 0x70, 0x2b, 0x66, 0x72, 0x2b, 0x66, 0x75};
const uint8_t HuffDecoderCommon::table20_115_emit_[216] = {
    0x2b, 0x67, 0x30, 0x2b, 0x67, 0x31, 0x2b, 0x67, 0x32, 0x2b, 0x67, 0x61,
    0x2b, 0x67, 0x63, 0x2b, 0x67, 0x65, 0x2b, 0x67, 0x69, 0x2b, 0x67, 0x6f,
    0x2b, 0x67, 0x73, 0x2b, 0x67, 0x74, 0x2b, 0x67, 0x20, 0x2b, 0x67, 0x25,
    0x2b, 0x67, 0x2d, 0x2b, 0x67, 0x2e, 0x2b, 0x67, 0x2f, 0x2b, 0x67, 0x33,
    0x2b, 0x67, 0x34, 0x2b, 0x67, 0x35, 0x2b, 0x67, 0x36, 0x2b, 0x67, 0x37,
    0x2b, 0x67, 0x38, 0x2b, 0x67, 0x39, 0x2b, 0x67, 0x3d, 0x2b, 0x67, 0x41,
    0x2b, 0x67, 0x5f, 0x2b, 0x67, 0x62, 0x2b, 0x67, 0x64, 0x2b, 0x67, 0x66,
    0x2b, 0x67, 0x67, 0x2b, 0x67, 0x68, 0x2b, 0x67, 0x6c, 0x2b, 0x67, 0x6d,
    0x2b, 0x67, 0x6e, 0x2b, 0x67, 0x70, 0x2b, 0x67, 0x72, 0x2b, 0x67, 0x75,
    0x2b, 0x68, 0x30, 0x2b, 0x68, 0x31, 0x2b, 0x68, 0x32, 0x2b, 0x68, 0x61,
    0x2b, 0x68, 0x63, 0x2b, 0x68, 0x65, 0x2b, 0x68, 0x69, 0x2b, 0x68, 0x6f,
    0x2b, 0x68, 0x73, 0x2b, 0x68, 0x74, 0x2b, 0x68, 0x20, 0x2b, 0x68, 0x25,
    0x2b, 0x68, 0x2d, 0x2b, 0x68, 0x2e, 0x2b, 0x68, 0x2f, 0x2b, 0x68, 0x33,
    0x2b, 0x68, 0x34, 0x2b, 0x68, 0x35, 0x2b, 0x68, 0x36, 0x2b, 0x68, 0x37,
    0x2b, 0x68, 0x38, 0x2b, 0x68, 0x39, 0x2b, 0x68, 0x3d, 0x2b, 0x68, 0x41,
    0x2b, 0x68, 0x5f, 0x2b, 0x68, 0x62, 0x2b, 0x68, 0x64, 0x2b, 0x68, 0x66,
    0x2b, 0x68, 0x67, 0x2b, 0x68, 0x68, 0x2b, 0x68, 0x6c, 0x2b, 0x68, 0x6d,
    0x2b, 0x68, 0x6e, 0x2b, 0x68, 0x70, 0x2b, 0x68, 0x72, 0x2b, 0x68, 0x75};
const uint8_t HuffDecoderCommon::table20_116_emit_[216] = {
    0x2b, 0x6c, 0x30, 0x2b, 0x6c, 0x31, 0x2b, 0x6c, 0x32, 0x2b, 0x6c, 0x61,
    0x2b, 0x6c, 0x63, 0x2b, 0x6c, 0x65, 0x2b, 0x6c, 0x69, 0x2b, 0x6c, 0x6f,
    0x2b, 0x6c, 0x73, 0x2b, 0x6c, 0x74, 0x2b, 0x6c, 0x20, 0x2b, 0x6c, 0x25,
    0x2b, 0x6c, 0x2d, 0x2b, 0x6c, 0x2e, 0x2b, 0x6c, 0x2f, 0x2b, 0x6c, 0x33,
    0x2b, 0x6c, 0x34, 0x2b, 0x6c, 0x35, 0x2b, 0x6c, 0x36, 0x2b, 0x6c, 0x37,
    0x2b, 0x6c, 0x38, 0x2b, 0x6c, 0x39, 0x2b, 0x6c, 0x3d, 0x2b, 0x6c, 0x41,
    0x2b, 0x6c, 0x5f, 0x2b, 0x6c, 0x62, 0x2b, 0x6c, 0x64, 0x2b, 0x6c, 0x66,
    0x2b, 0x6c, 0x67, 0x2b, 0x6c, 0x68, 0x2b, 0x6c, 0x6c, 0x2b, 0x6c, 0x6d,
    0x2b, 0x6c, 0x6e, 0x2b, 0x6c, 0x70, 0x2b, 0x6c, 0x72, 0x2b, 0x6c, 0x75,
    0x2b, 0x6d, 0x30, 0x2b, 0x6d, 0x31, 0x2b, 0x6d, 0x32, 0x2b, 0x6d, 0x61,
    0x2b, 0x6d, 0x63, 0x2b, 0x6d, 0x65, 0x2b, 0x6d, 0x69, 0x2b, 0x6d, 0x6f,
    0x2b, 0x6d, 0x73, 0x2b, 0x6d, 0x74, 0x2b, 0x6d, 0x20, 0x2b, 0x6d, 0x25,
    0x2b, 0x6d, 0x2d, 0x2b, 0x6d, 0x2e, 0x2b, 0x6d, 0x2f, 0x2b, 0x6d, 0x33,
    0x2b, 0x6d, 0x34, 0x2b, 0x6d, 0x35, 0x2b, 0x6d, 0x36, 0x2b, 0x6d, 0x37,
    0x2b, 0x6d, 0x38, 0x2b, 0x6d, 0x39, 0x2b, 0x6d, 0x3d, 0x2b, 0x6d, 0x41,
    0x2b, 0x6d, 0x5f, 0x2b, 0x6d, 0x62, 0x2b, 0x6d, 0x64, 0x2b, 0x6d, 0x66,
    0x2b, 0x6d, 0x67, 0x2b, 0x6d, 0x68, 0x2b, 0x6d, 0x6c, 0x2b, 0x6d, 0x6d,
    0x2b, 0x6d, 0x6e, 0x2b, 0x6d, 0x70, 0x2b, 0x6d, 0x72, 0x2b, 0x6d, 0x75};
const uint8_t HuffDecoderCommon::table20_117_emit_[216] = {
    0x2b, 0x6e, 0x30, 0x2b, 0x6e, 0x31, 0x2b, 0x6e, 0x32, 0x2b, 0x6e, 0x61,
    0x2b, 0x6e, 0x63, 0x2b, 0x6e, 0x65, 0x2b, 0x6e, 0x69, 0x2b, 0x6e, 0x6f,
    0x2b, 0x6e, 0x73, 0x2b, 0x6e, 0x74, 0x2b, 0x6e, 0x20, 0x2b, 0x6e, 0x25,
    0x2b, 0x6e, 0x2d, 0x2b, 0x6e, 0x2e, 0x2b, 0x6e, 0x2f, 0x2b, 0x6e, 0x33,
    0x2b, 0x6e, 0x34, 0x2b, 0x6e, 0x35, 0x2b, 0x6e, 0x36, 0x2b, 0x6e, 0x37,
    0x2b, 0x6e, 0x38, 0x2b, 0x6e, 0x39, 0x2b, 0x6e, 0x3d, 0x2b, 0x6e, 0x41,
    0x2b, 0x6e, 0x5f, 0x2b, 0x6e, 0x62, 0x2b, 0x6e, 0x64, 0x2b, 0x6e, 0x66,
    0x2b, 0x6e, 0x67, 0x2b, 0x6e, 0x68, 0x2b, 0x6e, 0x6c, 0x2b, 0x6e, 0x6d,
    0x2b, 0x6e, 0x6e, 0x2b, 0x6e, 0x70, 0x2b, 0x6e, 0x72, 0x2b, 0x6e, 0x75,
    0x2b, 0x70, 0x30, 0x2b, 0x70, 0x31, 0x2b, 0x70, 0x32, 0x2b, 0x70, 0x61,
    0x2b, 0x70, 0x63, 0x2b, 0x70, 0x65, 0x2b, 0x70, 0x69, 0x2b, 0x70, 0x6f,
    0x2b, 0x70, 0x73, 0x2b, 0x70, 0x74, 0x2b, 0x70, 0x20, 0x2b, 0x70, 0x25,
    0x2b, 0x70, 0x2d, 0x2b, 0x70, 0x2e, 0x2b, 0x70, 0x2f, 0x2b, 0x70, 0x33,
    0x2b, 0x70, 0x34, 0x2b, 0x70, 0x35, 0x2b, 0x70, 0x36, 0x2b, 0x70, 0x37,
    0x2b, 0x70, 0x38, 0x2b, 0x70, 0x39, 0x2b, 0x70, 0x3d, 0x2b, 0x70, 0x41,
    0x2b, 0x70, 0x5f, 0x2b, 0x70, 0x62, 0x2b, 0x70, 0x64, 0x2b, 0x70, 0x66,
    0x2b, 0x70, 0x67, 0x2b, 0x70, 0x68, 0x2b, 0x70, 0x6c, 0x2b, 0x70, 0x6d,
    0x2b, 0x70, 0x6e, 0x2b, 0x70, 0x70, 0x2b, 0x70, 0x72, 0x2b, 0x70, 0x75};
const uint8_t HuffDecoderCommon::table20_118_emit_[216] = {
    0x2b, 0x72, 0x30, 0x2b, 0x72, 0x31, 0x2b, 0x72, 0x32, 0x2b, 0x72, 0x61,
    0x2b, 0x72, 0x63, 0x2b, 0x72, 0x65, 0x2b, 0x72, 0x69, 0x2b, 0x72, 0x6f,
    0x2b, 0x72, 0x73, 0x2b, 0x72, 0x74, 0x2b, 0x72, 0x20, 0x2b, 0x72, 0x25,
    0x2b, 0x72, 0x2d, 0x2b, 0x72, 0x2e, 0x2b, 0x72, 0x2f, 0x2b, 0x72, 0x33,
    0x2b, 0x72, 0x34, 0x2b, 0x72, 0x35, 0x2b, 0x72, 0x36, 0x2b, 0x72, 0x37,
    0x2b, 0x72, 0x38, 0x2b, 0x72, 0x39, 0x2b, 0x72, 0x3d, 0x2b, 0x72, 0x41,
    0x2b, 0x72, 0x5f, 0x2b, 0x72, 0x62, 0x2b, 0x72, 0x64, 0x2b, 0x72, 0x66,
    0x2b, 0x72, 0x67, 0x2b, 0x72, 0x68, 0x2b, 0x72, 0x6c, 0x2b, 0x72, 0x6d,
    0x2b, 0x72, 0x6e, 0x2b, 0x72, 0x70, 0x2b, 0x72, 0x72, 0x2b, 0x72, 0x75,
    0x2b, 0x75, 0x30, 0x2b, 0x75, 0x31, 0x2b, 0x75, 0x32, 0x2b, 0x75, 0x61,
    0x2b, 0x75, 0x63, 0x2b, 0x75, 0x65, 0x2b, 0x75, 0x69, 0x2b, 0x75, 0x6f,
    0x2b, 0x75, 0x73, 0x2b, 0x75, 0x74, 0x2b, 0x75, 0x20, 0x2b, 0x75, 0x25,
    0x2b, 0x75, 0x2d, 0x2b, 0x75, 0x2e, 0x2b, 0x75, 0x2f, 0x2b, 0x75, 0x33,
    0x2b, 0x75, 0x34, 0x2b, 0x75, 0x35, 0x2b, 0x75, 0x36, 0x2b, 0x75, 0x37,
    0x2b, 0x75, 0x38, 0x2b, 0x75, 0x39, 0x2b, 0x75, 0x3d, 0x2b, 0x75, 0x41,
    0x2b, 0x75, 0x5f, 0x2b, 0x75, 0x62, 0x2b, 0x75, 0x64, 0x2b, 0x75, 0x66,
    0x2b, 0x75, 0x67, 0x2b, 0x75, 0x68, 0x2b, 0x75, 0x6c, 0x2b, 0x75, 0x6d,
    0x2b, 0x75, 0x6e, 0x2b, 0x75, 0x70, 0x2b, 0x75, 0x72, 0x2b, 0x75, 0x75};
const uint8_t HuffDecoderCommon::table20_119_emit_[120] = {
    0x2b, 0x3a, 0x30, 0x2b, 0x3a, 0x31, 0x2b, 0x3a, 0x32, 0x2b, 0x3a, 0x61,
    0x2b, 0x3a, 0x63, 0x2b, 0x3a, 0x65, 0x2b, 0x3a, 0x69, 0x2b, 0x3a, 0x6f,
    0x2b, 0x3a, 0x73, 0x2b, 0x3a, 0x74, 0x2b, 0x42, 0x30, 0x2b, 0x42, 0x31,
    0x2b, 0x42, 0x32, 0x2b, 0x42, 0x61, 0x2b, 0x42, 0x63, 0x2b, 0x42, 0x65,
    0x2b, 0x42, 0x69, 0x2b, 0x42, 0x6f, 0x2b, 0x42, 0x73, 0x2b, 0x42, 0x74,
    0x2b, 0x43, 0x30, 0x2b, 0x43, 0x31, 0x2b, 0x43, 0x32, 0x2b, 0x43, 0x61,
    0x2b, 0x43, 0x63, 0x2b, 0x43, 0x65, 0x2b, 0x43, 0x69, 0x2b, 0x43, 0x6f,
    0x2b, 0x43, 0x73, 0x2b, 0x43, 0x74, 0x2b, 0x44, 0x30, 0x2b, 0x44, 0x31,
    0x2b, 0x44, 0x32, 0x2b, 0x44, 0x61, 0x2b, 0x44, 0x63, 0x2b, 0x44, 0x65,
    0x2b, 0x44, 0x69, 0x2b, 0x44, 0x6f, 0x2b, 0x44, 0x73, 0x2b, 0x44, 0x74};
const uint8_t HuffDecoderCommon::table20_120_emit_[120] = {
    0x2b, 0x45, 0x30, 0x2b, 0x45, 0x31, 0x2b, 0x45, 0x32, 0x2b, 0x45, 0x61,
    0x2b, 0x45, 0x63, 0x2b, 0x45, 0x65, 0x2b, 0x45, 0x69, 0x2b, 0x45, 0x6f,
    0x2b, 0x45, 0x73, 0x2b, 0x45, 0x74, 0x2b, 0x46, 0x30, 0x2b, 0x46, 0x31,
    0x2b, 0x46, 0x32, 0x2b, 0x46, 0x61, 0x2b, 0x46, 0x63, 0x2b, 0x46, 0x65,
    0x2b, 0x46, 0x69, 0x2b, 0x46, 0x6f, 0x2b, 0x46, 0x73, 0x2b, 0x46, 0x74,
    0x2b, 0x47, 0x30, 0x2b, 0x47, 0x31, 0x2b, 0x47, 0x32, 0x2b, 0x47, 0x61,
    0x2b, 0x47, 0x63, 0x2b, 0x47, 0x65, 0x2b, 0x47, 0x69, 0x2b, 0x47, 0x6f,
    0x2b, 0x47, 0x73, 0x2b, 0x47, 0x74, 0x2b, 0x48, 0x30, 0x2b, 0x48, 0x31,
    0x2b, 0x48, 0x32, 0x2b, 0x48, 0x61, 0x2b, 0x48, 0x63, 0x2b, 0x48, 0x65,
    0x2b, 0x48, 0x69, 0x2b, 0x48, 0x6f, 0x2b, 0x48, 0x73, 0x2b, 0x48, 0x74};
const uint8_t HuffDecoderCommon::table20_121_emit_[120] = {
    0x2b, 0x49, 0x30, 0x2b, 0x49, 0x31, 0x2b, 0x49, 0x32, 0x2b, 0x49, 0x61,
    0x2b, 0x49, 0x63, 0x2b, 0x49, 0x65, 0x2b, 0x49, 0x69, 0x2b, 0x49, 0x6f,
    0x2b, 0x49, 0x73, 0x2b, 0x49, 0x74, 0x2b, 0x4a, 0x30, 0x2b, 0x4a, 0x31,
    0x2b, 0x4a, 0x32, 0x2b, 0x4a, 0x61, 0x2b, 0x4a, 0x63, 0x2b, 0x4a, 0x65,
    0x2b, 0x4a, 0x69, 0x2b, 0x4a, 0x6f, 0x2b, 0x4a, 0x73, 0x2b, 0x4a, 0x74,
    0x2b, 0x4b, 0x30, 0x2b, 0x4b, 0x31, 0x2b, 0x4b, 0x32, 0x2b, 0x4b, 0x61,
    0x2b, 0x4b, 0x63, 0x2b, 0x4b, 0x65, 0x2b, 0x4b, 0x69, 0x2b, 0x4b, 0x6f,
    0x2b, 0x4b, 0x73, 0x2b, 0x4b, 0x74, 0x2b, 0x4c, 0x30, 0x2b, 0x4c, 0x31,
    0x2b, 0x4c, 0x32, 0x2b, 0x4c, 0x61, 0x2b, 0x4c, 0x63, 0x2b, 0x4c, 0x65,
    0x2b, 0x4c, 0x69, 0x2b, 0x4c, 0x6f, 0x2b, 0x4c, 0x73, 0x2b, 0x4c, 0x74};
const uint8_t HuffDecoderCommon::table20_122_emit_[120] = {
    0x2b, 0x4d, 0x30, 0x2b, 0x4d, 0x31, 0x2b, 0x4d, 0x32, 0x2b, 0x4d, 0x61,
    0x2b, 0x4d, 0x63, 0x2b, 0x4d, 0x65, 0x2b, 0x4d, 0x69, 0x2b, 0x4d, 0x6f,
    0x2b, 0x4d, 0x73, 0x2b, 0x4d, 0x74, 0x2b, 0x4e, 0x30, 0x2b, 0x4e, 0x31,
    0x2b, 0x4e, 0x32, 0x2b, 0x4e, 0x61, 0x2b, 0x4e, 0x63, 0x2b, 0x4e, 0x65,
    0x2b, 0x4e, 0x69, 0x2b, 0x4e, 0x6f, 0x2b, 0x4e, 0x73, 0x2b, 0x4e, 0x74,
    0x2b, 0x4f, 0x30, 0x2b, 0x4f, 0x31, 0x2b, 0x4f, 0x32, 0x2b, 0x4f, 0x61,
    0x2b, 0x4f, 0x63, 0x2b, 0x4f, 0x65, 0x2b, 0x4f, 0x69, 0x2b, 0x4f, 0x6f,
    0x2b, 0x4f, 0x73, 0x2b, 0x4f, 0x74, 0x2b, 0x50, 0x30, 0x2b, 0x50, 0x31,
    0x2b, 0x50, 0x32, 0x2b, 0x50, 0x61, 0x2b, 0x50, 0x63, 0x2b, 0x50, 0x65,
    0x2b, 0x50, 0x69, 0x2b, 0x50, 0x6f, 0x2b, 0x50, 0x73, 0x2b, 0x50, 0x74};
const uint8_t HuffDecoderCommon::table20_123_emit_[120] = {
    0x2b, 0x51, 0x30, 0x2b, 0x51, 0x31, 0x2b, 0x51, 0x32, 0x2b, 0x51, 0x61,
    0x2b, 0x51, 0x63, 0x2b, 0x51, 0x65, 0x2b, 0x51, 0x69, 0x2b, 0x51, 0x6f,
    0x2b, 0x51, 0x73, 0x2b, 0x51, 0x74, 0x2b, 0x52, 0x30, 0x2b, 0x52, 0x31,
    0x2b, 0x52, 0x32, 0x2b, 0x52, 0x61, 0x2b, 0x52, 0x63, 0x2b, 0x52, 0x65,
    0x2b, 0x52, 0x69, 0x2b, 0x52, 0x6f, 0x2b, 0x52, 0x73, 0x2b, 0x52, 0x74,
    0x2b, 0x53, 0x30, 0x2b, 0x53, 0x31, 0x2b, 0x53, 0x32, 0x2b, 0x53, 0x61,
    0x2b, 0x53, 0x63, 0x2b, 0x53, 0x65, 0x2b, 0x53, 0x69, 0x2b, 0x53, 0x6f,
    0x2b, 0x53, 0x73, 0x2b, 0x53, 0x74, 0x2b, 0x54, 0x30, 0x2b, 0x54, 0x31,
    0x2b, 0x54, 0x32, 0x2b, 0x54, 0x61, 0x2b, 0x54, 0x63, 0x2b, 0x54, 0x65,
    0x2b, 0x54, 0x69, 0x2b, 0x54, 0x6f, 0x2b, 0x54, 0x73, 0x2b, 0x54, 0x74};
const uint8_t HuffDecoderCommon::table20_124_emit_[120] = {
    0x2b, 0x55, 0x30, 0x2b, 0x55, 0x31, 0x2b, 0x55, 0x32, 0x2b, 0x55, 0x61,
    0x2b, 0x55, 0x63, 0x2b, 0x55, 0x65, 0x2b, 0x55, 0x69, 0x2b, 0x55, 0x6f,
    0x2b, 0x55, 0x73, 0x2b, 0x55, 0x74, 0x2b, 0x56, 0x30, 0x2b, 0x56, 0x31,
    0x2b, 0x56, 0x32, 0x2b, 0x56, 0x61, 0x2b, 0x56, 0x63, 0x2b, 0x56, 0x65,
    0x2b, 0x56, 0x69, 0x2b, 0x56, 0x6f, 0x2b, 0x56, 0x73, 0x2b, 0x56, 0x74,
    0x2b, 0x57, 0x30, 0x2b, 0x57, 0x31, 0x2b, 0x57, 0x32, 0x2b, 0x57, 0x61,
    0x2b, 0x57, 0x63, 0x2b, 0x57, 0x65, 0x2b, 0x57, 0x69, 0x2b, 0x57, 0x6f,
    0x2b, 0x57, 0x73, 0x2b, 0x57, 0x74, 0x2b, 0x59, 0x30, 0x2b, 0x59, 0x31,
    0x2b, 0x59, 0x32, 0x2b, 0x59, 0x61, 0x2b, 0x59, 0x63, 0x2b, 0x59, 0x65,
    0x2b, 0x59, 0x69, 0x2b, 0x59, 0x6f, 0x2b, 0x59, 0x73, 0x2b, 0x59, 0x74};
const uint8_t HuffDecoderCommon::table20_125_emit_[120] = {
    0x2b, 0x6a, 0x30, 0x2b, 0x6a, 0x31, 0x2b, 0x6a, 0x32, 0x2b, 0x6a, 0x61,
    0x2b, 0x6a, 0x63, 0x2b, 0x6a, 0x65, 0x2b, 0x6a, 0x69, 0x2b, 0x6a, 0x6f,
    0x2b, 0x6a, 0x73, 0x2b, 0x6a, 0x74, 0x2b, 0x6b, 0x30, 0x2b, 0x6b, 0x31,
    0x2b, 0x6b, 0x32, 0x2b, 0x6b, 0x61, 0x2b, 0x6b, 0x63, 0x2b, 0x6b, 0x65,
    0x2b, 0x6b, 0x69, 0x2b, 0x6b, 0x6f, 0x2b, 0x6b, 0x73, 0x2b, 0x6b, 0x74,
    0x2b, 0x71, 0x30, 0x2b, 0x71, 0x31, 0x2b, 0x71, 0x32, 0x2b, 0x71, 0x61,
    0x2b, 0x71, 0x63, 0x2b, 0x71, 0x65, 0x2b, 0x71, 0x69, 0x2b, 0x71, 0x6f,
    0x2b, 0x71, 0x73, 0x2b, 0x71, 0x74, 0x2b, 0x76, 0x30, 0x2b, 0x76, 0x31,
    0x2b, 0x76, 0x32, 0x2b, 0x76, 0x61, 0x2b, 0x76, 0x63, 0x2b, 0x76, 0x65,
    0x2b, 0x76, 0x69, 0x2b, 0x76, 0x6f, 0x2b, 0x76, 0x73, 0x2b, 0x76, 0x74};
const uint8_t HuffDecoderCommon::table20_126_emit_[120] = {
    0x2b, 0x77, 0x30, 0x2b, 0x77, 0x31, 0x2b, 0x77, 0x32, 0x2b, 0x77, 0x61,
    0x2b, 0x77, 0x63, 0x2b, 0x77, 0x65, 0x2b, 0x77, 0x69, 0x2b, 0x77, 0x6f,
    0x2b, 0x77, 0x73, 0x2b, 0x77, 0x74, 0x2b, 0x78, 0x30, 0x2b, 0x78, 0x31,
    0x2b, 0x78, 0x32, 0x2b, 0x78, 0x61, 0x2b, 0x78, 0x63, 0x2b, 0x78, 0x65,
    0x2b, 0x78, 0x69, 0x2b, 0x78, 0x6f, 0x2b, 0x78, 0x73, 0x2b, 0x78, 0x74,
    0x2b, 0x79, 0x30, 0x2b, 0x79, 0x31, 0x2b, 0x79, 0x32, 0x2b, 0x79, 0x61,
    0x2b, 0x79, 0x63, 0x2b, 0x79, 0x65, 0x2b, 0x79, 0x69, 0x2b, 0x79, 0x6f,
    0x2b, 0x79, 0x73, 0x2b, 0x79, 0x74, 0x2b, 0x7a, 0x30, 0x2b, 0x7a, 0x31,
    0x2b, 0x7a, 0x32, 0x2b, 0x7a, 0x61, 0x2b, 0x7a, 0x63, 0x2b, 0x7a, 0x65,
    0x2b, 0x7a, 0x69, 0x2b, 0x7a, 0x6f, 0x2b, 0x7a, 0x73, 0x2b, 0x7a, 0x74};
const uint8_t HuffDecoderCommon::table20_127_emit_[31] = {
    0x2b, 0x26, 0x2b, 0x2a, 0x2b, 0x2c, 0x2b, 0x3b, 0x2b, 0x58, 0x2b,
    0x5a, 0x2b, 0x21, 0x2b, 0x22, 0x2b, 0x28, 0x2b, 0x29, 0x2b, 0x3f,
    0x2b, 0x27, 0x2b, 0x2b, 0x7c, 0x2b, 0x23, 0x2b, 0x3e};
const uint16_t HuffDecoderCommon::table20_127_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0062, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000,
    0x00b2, 0x0000, 0x00c2, 0x0000, 0x00ca, 0x00da, 0x00ea, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table20_128_emit_[204] = {
    0x7c, 0x30, 0x30, 0x7c, 0x30, 0x31, 0x7c, 0x30, 0x32, 0x7c, 0x30, 0x61,
    0x7c, 0x30, 0x63, 0x7c, 0x30, 0x65, 0x7c, 0x30, 0x69, 0x7c, 0x30, 0x6f,
    0x7c, 0x30, 0x73, 0x7c, 0x30, 0x74, 0x7c, 0x30, 0x20, 0x7c, 0x30, 0x25,
    0x7c, 0x30, 0x2d, 0x7c, 0x30, 0x2e, 0x7c, 0x30, 0x2f, 0x7c, 0x30, 0x33,
    0x7c, 0x30, 0x34, 0x7c, 0x30, 0x35, 0x7c, 0x30, 0x36, 0x7c, 0x30, 0x37,
    0x7c, 0x30, 0x38, 0x7c, 0x30, 0x39, 0x7c, 0x30, 0x3d, 0x7c, 0x30, 0x41,
    0x7c, 0x30, 0x5f, 0x7c, 0x30, 0x62, 0x7c, 0x30, 0x64, 0x7c, 0x30, 0x66,
    0x7c, 0x30, 0x67, 0x7c, 0x30, 0x68, 0x7c, 0x30, 0x6c, 0x7c, 0x30, 0x6d,
    0x7c, 0x30, 0x6e, 0x7c, 0x30, 0x70, 0x7c, 0x30, 0x72, 0x7c, 0x30, 0x75,
    0x7c, 0x30, 0x3a, 0x7c, 0x30, 0x42, 0x7c, 0x30, 0x43, 0x7c, 0x30, 0x44,
    0x7c, 0x30, 0x45, 0x7c, 0x30, 0x46, 0x7c, 0x30, 0x47, 0x7c, 0x30, 0x48,
    0x7c, 0x30, 0x49, 0x7c, 0x30, 0x4a, 0x7c, 0x30, 0x4b, 0x7c, 0x30, 0x4c,
    0x7c, 0x30, 0x4d, 0x7c, 0x30, 0x4e, 0x7c, 0x30, 0x4f, 0x7c, 0x30, 0x50,
    0x7c, 0x30, 0x51, 0x7c, 0x30, 0x52, 0x7c, 0x30, 0x53, 0x7c, 0x30, 0x54,
    0x7c, 0x30, 0x55, 0x7c, 0x30, 0x56, 0x7c, 0x30, 0x57, 0x7c, 0x30, 0x59,
    0x7c, 0x30, 0x6a, 0x7c, 0x30, 0x6b, 0x7c, 0x30, 0x71, 0x7c, 0x30, 0x76,
    0x7c, 0x30, 0x77, 0x7c, 0x30, 0x78, 0x7c, 0x30, 0x79, 0x7c, 0x30, 0x7a};
const uint8_t HuffDecoderCommon::table20_129_emit_[204] = {
    0x7c, 0x31, 0x30, 0x7c, 0x31, 0x31, 0x7c, 0x31, 0x32, 0x7c, 0x31, 0x61,
    0x7c, 0x31, 0x63, 0x7c, 0x31, 0x65, 0x7c, 0x31, 0x69, 0x7c, 0x31, 0x6f,
    0x7c, 0x31, 0x73, 0x7c, 0x31, 0x74, 0x7c, 0x31, 0x20, 0x7c, 0x31, 0x25,
    0x7c, 0x31, 0x2d, 0x7c, 0x31, 0x2e, 0x7c, 0x31, 0x2f, 0x7c, 0x31, 0x33,
    0x7c, 0x31, 0x34, 0x7c, 0x31, 0x35, 0x7c, 0x31, 0x36, 0x7c, 0x31, 0x37,
    0x7c, 0x31, 0x38, 0x7c, 0x31, 0x39, 0x7c, 0x31, 0x3d, 0x7c, 0x31, 0x41,
    0x7c, 0x31, 0x5f, 0x7c, 0x31, 0x62, 0x7c, 0x31, 0x64, 0x7c, 0x31, 0x66,
    0x7c, 0x31, 0x67, 0x7c, 0x31, 0x68, 0x7c, 0x31, 0x6c, 0x7c, 0x31, 0x6d,
    0x7c, 0x31, 0x6e, 0x7c, 0x31, 0x70, 0x7c, 0x31, 0x72, 0x7c, 0x31, 0x75,
    0x7c, 0x31, 0x3a, 0x7c, 0x31, 0x42, 0x7c, 0x31, 0x43, 0x7c, 0x31, 0x44,
    0x7c, 0x31, 0x45, 0x7c, 0x31, 0x46, 0x7c, 0x31, 0x47, 0x7c, 0x31, 0x48,
    0x7c, 0x31, 0x49, 0x7c, 0x31, 0x4a, 0x7c, 0x31, 0x4b, 0x7c, 0x31, 0x4c,
    0x7c, 0x31, 0x4d, 0x7c, 0x31, 0x4e, 0x7c, 0x31, 0x4f, 0x7c, 0x31, 0x50,
    0x7c, 0x31, 0x51, 0x7c, 0x31, 0x52, 0x7c, 0x31, 0x53, 0x7c, 0x31, 0x54,
    0x7c, 0x31, 0x55, 0x7c, 0x31, 0x56, 0x7c, 0x31, 0x57, 0x7c, 0x31, 0x59,
    0x7c, 0x31, 0x6a, 0x7c, 0x31, 0x6b, 0x7c, 0x31, 0x71, 0x7c, 0x31, 0x76,
    0x7c, 0x31, 0x77, 0x7c, 0x31, 0x78, 0x7c, 0x31, 0x79, 0x7c, 0x31, 0x7a};
const uint8_t HuffDecoderCommon::table20_130_emit_[204] = {
    0x7c, 0x32, 0x30, 0x7c, 0x32, 0x31, 0x7c, 0x32, 0x32, 0x7c, 0x32, 0x61,
    0x7c, 0x32, 0x63, 0x7c, 0x32, 0x65, 0x7c, 0x32, 0x69, 0x7c, 0x32, 0x6f,
    0x7c, 0x32, 0x73, 0x7c, 0x32, 0x74, 0x7c, 0x32, 0x20, 0x7c, 0x32, 0x25,
    0x7c, 0x32, 0x2d, 0x7c, 0x32, 0x2e, 0x7c, 0x32, 0x2f, 0x7c, 0x32, 0x33,
    0x7c, 0x32, 0x34, 0x7c, 0x32, 0x35, 0x7c, 0x32, 0x36, 0x7c, 0x32, 0x37,
    0x7c, 0x32, 0x38, 0x7c, 0x32, 0x39, 0x7c, 0x32, 0x3d, 0x7c, 0x32, 0x41,
    0x7c, 0x32, 0x5f, 0x7c, 0x32, 0x62, 0x7c, 0x32, 0x64, 0x7c, 0x32, 0x66,
    0x7c, 0x32, 0x67, 0x7c, 0x32, 0x68, 0x7c, 0x32, 0x6c, 0x7c, 0x32, 0x6d,
    0x7c, 0x32, 0x6e, 0x7c, 0x32, 0x70, 0x7c, 0x32, 0x72, 0x7c, 0x32, 0x75,
    0x7c, 0x32, 0x3a, 0x7c, 0x32, 0x42, 0x7c, 0x32, 0x43, 0x7c, 0x32, 0x44,
    0x7c, 0x32, 0x45, 0x7c, 0x32, 0x46, 0x7c, 0x32, 0x47, 0x7c, 0x32, 0x48,
    0x7c, 0x32, 0x49, 0x7c, 0x32, 0x4a, 0x7c, 0x32, 0x4b, 0x7c, 0x32, 0x4c,
    0x7c, 0x32, 0x4d, 0x7c, 0x32, 0x4e, 0x7c, 0x32, 0x4f, 0x7c, 0x32, 0x50,
    0x7c, 0x32, 0x51, 0x7c, 0x32, 0x52, 0x7c, 0x32, 0x53, 0x7c, 0x32, 0x54,
    0x7c, 0x32, 0x55, 0x7c, 0x32, 0x56, 0x7c, 0x32, 0x57, 0x7c, 0x32, 0x59,
    0x7c, 0x32, 0x6a, 0x7c, 0x32, 0x6b, 0x7c, 0x32, 0x71, 0x7c, 0x32, 0x76,
    0x7c, 0x32, 0x77, 0x7c, 0x32, 0x78, 0x7c, 0x32, 0x79, 0x7c, 0x32, 0x7a};
const uint8_t HuffDecoderCommon::table20_131_emit_[204] = {
    0x7c, 0x61, 0x30, 0x7c, 0x61, 0x31, 0x7c, 0x61, 0x32, 0x7c, 0x61, 0x61,
    0x7c, 0x61, 0x63, 0x7c, 0x61, 0x65, 0x7c, 0x61, 0x69, 0x7c, 0x61, 0x6f,
    0x7c, 0x61, 0x73, 0x7c, 0x61, 0x74, 0x7c, 0x61, 0x20, 0x7c, 0x61, 0x25,
    0x7c, 0x61, 0x2d, 0x7c, 0x61, 0x2e, 0x7c, 0x61, 0x2f, 0x7c, 0x61, 0x33,
    0x7c, 0x61, 0x34, 0x7c, 0x61, 0x35, 0x7c, 0x61, 0x36, 0x7c, 0x61, 0x37,
    0x7c, 0x61, 0x38, 0x7c, 0x61, 0x39, 0x7c, 0x61, 0x3d, 0x7c, 0x61, 0x41,
    0x7c, 0x61, 0x5f, 0x7c, 0x61, 0x62, 0x7c, 0x61, 0x64, 0x7c, 0x61, 0x66,
    0x7c, 0x61, 0x67, 0x7c, 0x61, 0x68, 0x7c, 0x61, 0x6c, 0x7c, 0x61, 0x6d,
    0x7c, 0x61, 0x6e, 0x7c, 0x61, 0x70, 0x7c, 0x61, 0x72, 0x7c, 0x61, 0x75,
    0x7c, 0x61, 0x3a, 0x7c, 0x61, 0x42, 0x7c, 0x61, 0x43, 0x7c, 0x61, 0x44,
    0x7c, 0x61, 0x45, 0x7c, 0x61, 0x46, 0x7c, 0x61, 0x47, 0x7c, 0x61, 0x48,
    0x7c, 0x61, 0x49, 0x7c, 0x61, 0x4a, 0x7c, 0x61, 0x4b, 0x7c, 0x61, 0x4c,
    0x7c, 0x61, 0x4d, 0x7c, 0x61, 0x4e, 0x7c, 0x61, 0x4f, 0x7c, 0x61, 0x50,
    0x7c, 0x61, 0x51, 0x7c, 0x61, 0x52, 0x7c, 0x61, 0x53, 0x7c, 0x61, 0x54,
    0x7c, 0x61, 0x55, 0x7c, 0x61, 0x56, 0x7c, 0x61, 0x57, 0x7c, 0x61, 0x59,
    0x7c, 0x61, 0x6a, 0x7c, 0x61, 0x6b, 0x7c, 0x61, 0x71, 0x7c, 0x61, 0x76,
    0x7c, 0x61, 0x77, 0x7c, 0x61, 0x78, 0x7c, 0x61, 0x79, 0x7c, 0x61, 0x7a};
const uint8_t HuffDecoderCommon::table20_132_emit_[204] = {
    0x7c, 0x63, 0x30, 0x7c, 0x63, 0x31, 0x7c, 0x63, 0x32, 0x7c, 0x63, 0x61,
    0x7c, 0x63, 0x63, 0x7c, 0x63, 0x65, 0x7c, 0x63, 0x69, 0x7c, 0x63, 0x6f,
    0x7c, 0x63, 0x73, 0x7c, 0x63, 0x74, 0x7c, 0x63, 0x20, 0x7c, 0x63, 0x25,
    0x7c, 0x63, 0x2d, 0x7c, 0x63, 0x2e, 0x7c, 0x63, 0x2f, 0x7c, 0x63, 0x33,
    0x7c, 0x63, 0x34, 0x7c, 0x63, 0x35, 0x7c, 0x63, 0x36, 0x7c, 0x63, 0x37,
    0x7c, 0x63, 0x38, 0x7c, 0x63, 0x39, 0x7c, 0x63, 0x3d, 0x7c, 0x63, 0x41,
    0x7c, 0x63, 0x5f, 0x7c, 0x63, 0x62, 0x7c, 0x63, 0x64, 0x7c, 0x63, 0x66,
    0x7c, 0x63, 0x67, 0x7c, 0x63, 0x68, 0x7c, 0x63, 0x6c, 0x7c, 0x63, 0x6d,
    0x7c, 0x63, 0x6e, 0x7c, 0x63, 0x70, 0x7c, 0x63, 0x72, 0x7c, 0x63, 0x75,
    0x7c, 0x63, 0x3a, 0x7c, 0x63, 0x42, 0x7c, 0x63, 0x43, 0x7c, 0x63, 0x44,
    0x7c, 0x63, 0x45, 0x7c, 0x63, 0x46, 0x7c, 0x63, 0x47, 0x7c, 0x63, 0x48,
    0x7c, 0x63, 0x49, 0x7c, 0x63, 0x4a, 0x7c, 0x63, 0x4b, 0x7c, 0x63, 0x4c,
    0x7c, 0x63, 0x4d, 0x7c, 0x63, 0x4e, 0x7c, 0x63, 0x4f, 0x7c, 0x63, 0x50,
    0x7c, 0x63, 0x51, 0x7c, 0x63, 0x52, 0x7c, 0x63, 0x53, 0x7c, 0x63, 0x54,
    0x7c, 0x63, 0x55, 0x7c, 0x63, 0x56, 0x7c, 0x63, 0x57, 0x7c, 0x63, 0x59,
    0x7c, 0x63, 0x6a, 0x7c, 0x63, 0x6b, 0x7c, 0x63, 0x71, 0x7c, 0x63, 0x76,
    0x7c, 0x63, 0x77, 0x7c, 0x63, 0x78, 0x7c, 0x63, 0x79, 0x7c, 0x63, 0x7a};
const uint8_t HuffDecoderCommon::table20_133_emit_[204] = {
    0x7c, 0x65, 0x30, 0x7c, 0x65, 0x31, 0x7c, 0x65, 0x32, 0x7c, 0x65, 0x61,
    0x7c, 0x65, 0x63, 0x7c, 0x65, 0x65, 0x7c, 0x65, 0x69, 0x7c, 0x65, 0x6f,
    0x7c, 0x65, 0x73, 0x7c, 0x65, 0x74, 0x7c, 0x65, 0x20, 0x7c, 0x65, 0x25,
    0x7c, 0x65, 0x2d, 0x7c, 0x65, 0x2e, 0x7c, 0x65, 0x2f, 0x7c, 0x65, 0x33,
    0x7c, 0x65, 0x34, 0x7c, 0x65, 0x35, 0x7c, 0x65, 0x36, 0x7c, 0x65, 0x37,
    0x7c, 0x65, 0x38, 0x7c, 0x65, 0x39, 0x7c, 0x65, 0x3d, 0x7c, 0x65, 0x41,
    0x7c, 0x65, 0x5f, 0x7c, 0x65, 0x62, 0x7c, 0x65, 0x64, 0x7c, 0x65, 0x66,
    0x7c, 0x65, 0x67, 0x7c, 0x65, 0x68, 0x7c, 0x65, 0x6c, 0x7c, 0x65, 0x6d,
    0x7c, 0x65, 0x6e, 0x7c, 0x65, 0x70, 0x7c, 0x65, 0x72, 0x7c, 0x65, 0x75,
    0x7c, 0x65, 0x3a, 0x7c, 0x65, 0x42, 0x7c, 0x65, 0x43, 0x7c, 0x65, 0x44,
    0x7c, 0x65, 0x45, 0x7c, 0x65, 0x46, 0x7c, 0x65, 0x47, 0x7c, 0x65, 0x48,
    0x7c, 0x65, 0x49, 0x7c, 0x65, 0x4a, 0x7c, 0x65, 0x4b, 0x7c, 0x65, 0x4c,
    0x7c, 0x65, 0x4d, 0x7c, 0x65, 0x4e, 0x7c, 0x65, 0x4f, 0x7c, 0x65, 0x50,
    0x7c, 0x65, 0x51, 0x7c, 0x65, 0x52, 0x7c, 0x65, 0x53, 0x7c, 0x65, 0x54,
    0x7c, 0x65, 0x55, 0x7c, 0x65, 0x56, 0x7c, 0x65, 0x57, 0x7c, 0x65, 0x59,
    0x7c, 0x65, 0x6a, 0x7c, 0x65, 0x6b, 0x7c, 0x65, 0x71, 0x7c, 0x65, 0x76,
    0x7c, 0x65, 0x77, 0x7c, 0x65, 0x78, 0x7c, 0x65, 0x79, 0x7c, 0x65, 0x7a};
const uint8_t HuffDecoderCommon::table20_134_emit_[204] = {
    0x7c, 0x69, 0x30, 0x7c, 0x69, 0x31, 0x7c, 0x69, 0x32, 0x7c, 0x69, 0x61,
    0x7c, 0x69, 0x63, 0x7c, 0x69, 0x65, 0x7c, 0x69, 0x69, 0x7c, 0x69, 0x6f,
    0x7c, 0x69, 0x73, 0x7c, 0x69, 0x74, 0x7c, 0x69, 0x20, 0x7c, 0x69, 0x25,
    0x7c, 0x69, 0x2d, 0x7c, 0x69, 0x2e, 0x7c, 0x69, 0x2f, 0x7c, 0x69, 0x33,
    0x7c, 0x69, 0x34, 0x7c, 0x69, 0x35, 0x7c, 0x69, 0x36, 0x7c, 0x69, 0x37,
    0x7c, 0x69, 0x38, 0x7c, 0x69, 0x39, 0x7c, 0x69, 0x3d, 0x7c, 0x69, 0x41,
    0x7c, 0x69, 0x5f, 0x7c, 0x69, 0x62, 0x7c, 0x69, 0x64, 0x7c, 0x69, 0x66,
    0x7c, 0x69, 0x67, 0x7c, 0x69, 0x68, 0x7c, 0x69, 0x6c, 0x7c, 0x69, 0x6d,
    0x7c, 0x69, 0x6e, 0x7c, 0x69, 0x70, 0x7c, 0x69, 0x72, 0x7c, 0x69, 0x75,
    0x7c, 0x69, 0x3a, 0x7c, 0x69, 0x42, 0x7c, 0x69, 0x43, 0x7c, 0x69, 0x44,
    0x7c, 0x69, 0x45, 0x7c, 0x69, 0x46, 0x7c, 0x69, 0x47, 0x7c, 0x69, 0x48,
    0x7c, 0x69, 0x49, 0x7c, 0x69, 0x4a, 0x7c, 0x69, 0x4b, 0x7c, 0x69, 0x4c,
    0x7c, 0x69, 0x4d, 0x7c, 0x69, 0x4e, 0x7c, 0x69, 0x4f, 0x7c, 0x69, 0x50,
    0x7c, 0x69, 0x51, 0x7c, 0x69, 0x52, 0x7c, 0x69, 0x53, 0x7c, 0x69, 0x54,
    0x7c, 0x69, 0x55, 0x7c, 0x69, 0x56, 0x7c, 0x69, 0x57, 0x7c, 0x69, 0x59,
    0x7c, 0x69, 0x6a, 0x7c, 0x69, 0x6b, 0x7c, 0x69, 0x71, 0x7c, 0x69, 0x76,
    0x7c, 0x69, 0x77, 0x7c, 0x69, 0x78, 0x7c, 0x69, 0x79, 0x7c, 0x69, 0x7a};
const uint8_t HuffDecoderCommon::table20_135_emit_[204] = {
    0x7c, 0x6f, 0x30, 0x7c, 0x6f, 0x31, 0x7c, 0x6f, 0x32, 0x7c, 0x6f, 0x61,
    0x7c, 0x6f, 0x63, 0x7c, 0x6f, 0x65, 0x7c, 0x6f, 0x69, 0x7c, 0x6f, 0x6f,
    0x7c, 0x6f, 0x73, 0x7c, 0x6f, 0x74, 0x7c, 0x6f, 0x20, 0x7c, 0x6f, 0x25,
    0x7c, 0x6f, 0x2d, 0x7c, 0x6f, 0x2e, 0x7c, 0x6f, 0x2f, 0x7c, 0x6f, 0x33,
    0x7c, 0x6f, 0x34, 0x7c, 0x6f, 0x35, 0x7c, 0x6f, 0x36, 0x7c, 0x6f, 0x37,
    0x7c, 0x6f, 0x38, 0x7c, 0x6f, 0x39, 0x7c, 0x6f, 0x3d, 0x7c, 0x6f, 0x41,
    0x7c, 0x6f, 0x5f, 0x7c, 0x6f, 0x62, 0x7c, 0x6f, 0x64, 0x7c, 0x6f, 0x66,
    0x7c, 0x6f, 0x67, 0x7c, 0x6f, 0x68, 0x7c, 0x6f, 0x6c, 0x7c, 0x6f, 0x6d,
    0x7c, 0x6f, 0x6e, 0x7c, 0x6f, 0x70, 0x7c, 0x6f, 0x72, 0x7c, 0x6f, 0x75,
    0x7c, 0x6f, 0x3a, 0x7c, 0x6f, 0x42, 0x7c, 0x6f, 0x43, 0x7c, 0x6f, 0x44,
    0x7c, 0x6f, 0x45, 0x7c, 0x6f, 0x46, 0x7c, 0x6f, 0x47, 0x7c, 0x6f, 0x48,
    0x7c, 0x6f, 0x49, 0x7c, 0x6f, 0x4a, 0x7c, 0x6f, 0x4b, 0x7c, 0x6f, 0x4c,
    0x7c, 0x6f, 0x4d, 0x7c, 0x6f, 0x4e, 0x7c, 0x6f, 0x4f, 0x7c, 0x6f, 0x50,
    0x7c, 0x6f, 0x51, 0x7c, 0x6f, 0x52, 0x7c, 0x6f, 0x53, 0x7c, 0x6f, 0x54,
    0x7c, 0x6f, 0x55, 0x7c, 0x6f, 0x56, 0x7c, 0x6f, 0x57, 0x7c, 0x6f, 0x59,
    0x7c, 0x6f, 0x6a, 0x7c, 0x6f, 0x6b, 0x7c, 0x6f, 0x71, 0x7c, 0x6f, 0x76,
    0x7c, 0x6f, 0x77, 0x7c, 0x6f, 0x78, 0x7c, 0x6f, 0x79, 0x7c, 0x6f, 0x7a};
const uint8_t HuffDecoderCommon::table20_136_emit_[204] = {
    0x7c, 0x73, 0x30, 0x7c, 0x73, 0x31, 0x7c, 0x73, 0x32, 0x7c, 0x73, 0x61,
    0x7c, 0x73, 0x63, 0x7c, 0x73, 0x65, 0x7c, 0x73, 0x69, 0x7c, 0x73, 0x6f,
    0x7c, 0x73, 0x73, 0x7c, 0x73, 0x74, 0x7c, 0x73, 0x20, 0x7c, 0x73, 0x25,
    0x7c, 0x73, 0x2d, 0x7c, 0x73, 0x2e, 0x7c, 0x73, 0x2f, 0x7c, 0x73, 0x33,
    0x7c, 0x73, 0x34, 0x7c, 0x73, 0x35, 0x7c, 0x73, 0x36, 0x7c, 0x73, 0x37,
    0x7c, 0x73, 0x38, 0x7c, 0x73, 0x39, 0x7c, 0x73, 0x3d, 0x7c, 0x73, 0x41,
    0x7c, 0x73, 0x5f, 0x7c, 0x73, 0x62, 0x7c, 0x73, 0x64, 0x7c, 0x73, 0x66,
    0x7c, 0x73, 0x67, 0x7c, 0x73, 0x68, 0x7c, 0x73, 0x6c, 0x7c, 0x73, 0x6d,
    0x7c, 0x73, 0x6e, 0x7c, 0x73, 0x70, 0x7c, 0x73, 0x72, 0x7c, 0x73, 0x75,
    0x7c, 0x73, 0x3a, 0x7c, 0x73, 0x42, 0x7c, 0x73, 0x43, 0x7c, 0x73, 0x44,
    0x7c, 0x73, 0x45, 0x7c, 0x73, 0x46, 0x7c, 0x73, 0x47, 0x7c, 0x73, 0x48,
    0x7c, 0x73, 0x49, 0x7c, 0x73, 0x4a, 0x7c, 0x73, 0x4b, 0x7c, 0x73, 0x4c,
    0x7c, 0x73, 0x4d, 0x7c, 0x73, 0x4e, 0x7c, 0x73, 0x4f, 0x7c, 0x73, 0x50,
    0x7c, 0x73, 0x51, 0x7c, 0x73, 0x52, 0x7c, 0x73, 0x53, 0x7c, 0x73, 0x54,
    0x7c, 0x73, 0x55, 0x7c, 0x73, 0x56, 0x7c, 0x73, 0x57, 0x7c, 0x73, 0x59,
    0x7c, 0x73, 0x6a, 0x7c, 0x73, 0x6b, 0x7c, 0x73, 0x71, 0x7c, 0x73, 0x76,
    0x7c, 0x73, 0x77, 0x7c, 0x73, 0x78, 0x7c, 0x73, 0x79, 0x7c, 0x73, 0x7a};
const uint8_t HuffDecoderCommon::table20_137_emit_[204] = {
    0x7c, 0x74, 0x30, 0x7c, 0x74, 0x31, 0x7c, 0x74, 0x32, 0x7c, 0x74, 0x61,
    0x7c, 0x74, 0x63, 0x7c, 0x74, 0x65, 0x7c, 0x74, 0x69, 0x7c, 0x74, 0x6f,
    0x7c, 0x74, 0x73, 0x7c, 0x74, 0x74, 0x7c, 0x74, 0x20, 0x7c, 0x74, 0x25,
    0x7c, 0x74, 0x2d, 0x7c, 0x74, 0x2e, 0x7c, 0x74, 0x2f, 0x7c, 0x74, 0x33,
    0x7c, 0x74, 0x34, 0x7c, 0x74, 0x35, 0x7c, 0x74, 0x36, 0x7c, 0x74, 0x37,
    0x7c, 0x74, 0x38, 0x7c, 0x74, 0x39, 0x7c, 0x74, 0x3d, 0x7c, 0x74, 0x41,
    0x7c, 0x74, 0x5f, 0x7c, 0x74, 0x62, 0x7c, 0x74, 0x64, 0x7c, 0x74, 0x66,
    0x7c, 0x74, 0x67, 0x7c, 0x74, 0x68, 0x7c, 0x74, 0x6c, 0x7c, 0x74, 0x6d,
    0x7c, 0x74, 0x6e, 0x7c, 0x74, 0x70, 0x7c, 0x74, 0x72, 0x7c, 0x74, 0x75,
    0x7c, 0x74, 0x3a, 0x7c, 0x74, 0x42, 0x7c, 0x74, 0x43, 0x7c, 0x74, 0x44,
    0x7c, 0x74, 0x45, 0x7c, 0x74, 0x46, 0x7c, 0x74, 0x47, 0x7c, 0x74, 0x48,
    0x7c, 0x74, 0x49, 0x7c, 0x74, 0x4a, 0x7c, 0x74, 0x4b, 0x7c, 0x74, 0x4c,
    0x7c, 0x74, 0x4d, 0x7c, 0x74, 0x4e, 0x7c, 0x74, 0x4f, 0x7c, 0x74, 0x50,
    0x7c, 0x74, 0x51, 0x7c, 0x74, 0x52, 0x7c, 0x74, 0x53, 0x7c, 0x74, 0x54,
    0x7c, 0x74, 0x55, 0x7c, 0x74, 0x56, 0x7c, 0x74, 0x57, 0x7c, 0x74, 0x59,
    0x7c, 0x74, 0x6a, 0x7c, 0x74, 0x6b, 0x7c, 0x74, 0x71, 0x7c, 0x74, 0x76,
    0x7c, 0x74, 0x77, 0x7c, 0x74, 0x78, 0x7c, 0x74, 0x79, 0x7c, 0x74, 0x7a};
const uint8_t HuffDecoderCommon::table20_138_emit_[216] = {
    0x7c, 0x20, 0x30, 0x7c, 0x20, 0x31, 0x7c, 0x20, 0x32, 0x7c, 0x20, 0x61,
    0x7c, 0x20, 0x63, 0x7c, 0x20, 0x65, 0x7c, 0x20, 0x69, 0x7c, 0x20, 0x6f,
    0x7c, 0x20, 0x73, 0x7c, 0x20, 0x74, 0x7c, 0x20, 0x20, 0x7c, 0x20, 0x25,
    0x7c, 0x20, 0x2d, 0x7c, 0x20, 0x2e, 0x7c, 0x20, 0x2f, 0x7c, 0x20, 0x33,
    0x7c, 0x20, 0x34, 0x7c, 0x20, 0x35, 0x7c, 0x20, 0x36, 0x7c, 0x20, 0x37,
    0x7c, 0x20, 0x38, 0x7c, 0x20, 0x39, 0x7c, 0x20, 0x3d, 0x7c, 0x20, 0x41,
    0x7c, 0x20, 0x5f, 0x7c, 0x20, 0x62, 0x7c, 0x20, 0x64, 0x7c, 0x20, 0x66,
    0x7c, 0x20, 0x67, 0x7c, 0x20, 0x68, 0x7c, 0x20, 0x6c, 0x7c, 0x20, 0x6d,
    0x7c, 0x20, 0x6e, 0x7c, 0x20, 0x70, 0x7c, 0x20, 0x72, 0x7c, 0x20, 0x75,
    0x7c, 0x25, 0x30, 0x7c, 0x25, 0x31, 0x7c, 0x25, 0x32, 0x7c, 0x25, 0x61,
    0x7c, 0x25, 0x63, 0x7c, 0x25, 0x65, 0x7c, 0x25, 0x69, 0x7c, 0x25, 0x6f,
    0x7c, 0x25, 0x73, 0x7c, 0x25, 0x74, 0x7c, 0x25, 0x20, 0x7c, 0x25, 0x25,
    0x7c, 0x25, 0x2d, 0x7c, 0x25, 0x2e, 0x7c, 0x25, 0x2f, 0x7c, 0x25, 0x33,
    0x7c, 0x25, 0x34, 0x7c, 0x25, 0x35, 0x7c, 0x25, 0x36, 0x7c, 0x25, 0x37,
    0x7c, 0x25, 0x38, 0x7c, 0x25, 0x39, 0x7c, 0x25, 0x3d, 0x7c, 0x25, 0x41,
    0x7c, 0x25, 0x5f, 0x7c, 0x25, 0x62, 0x7c, 0x25, 0x64, 0x7c, 0x25, 0x66,
    0x7c, 0x25, 0x67, 0x7c, 0x25, 0x68, 0x7c, 0x25, 0x6c, 0x7c, 0x25, 0x6d,
    0x7c, 0x25, 0x6e, 0x7c, 0x25, 0x70, 0x7c, 0x25, 0x72, 0x7c, 0x25, 0x75};
const uint8_t HuffDecoderCommon::table20_139_emit_[216] = {
    0x7c, 0x2d, 0x30, 0x7c, 0x2d, 0x31, 0x7c, 0x2d, 0x32, 0x7c, 0x2d, 0x61,
    0x7c, 0x2d, 0x63, 0x7c, 0x2d, 0x65, 0x7c, 0x2d, 0x69, 0x7c, 0x2d, 0x6f,
    0x7c, 0x2d, 0x73, 0x7c, 0x2d, 0x74, 0x7c, 0x2d, 0x20, 0x7c, 0x2d, 0x25,
    0x7c, 0x2d, 0x2d, 0x7c, 0x2d, 0x2e, 0x7c, 0x2d, 0x2f, 0x7c, 0x2d, 0x33,
    0x7c, 0x2d, 0x34, 0x7c, 0x2d, 0x35, 0x7c, 0x2d, 0x36, 0x7c, 0x2d, 0x37,
    0x7c, 0x2d, 0x38, 0x7c, 0x2d, 0x39, 0x7c, 0x2d, 0x3d, 0x7c, 0x2d, 0x41,
    0x7c, 0x2d, 0x5f, 0x7c, 0x2d, 0x62, 0x7c, 0x2d, 0x64, 0x7c, 0x2d, 0x66,
    0x7c, 0x2d, 0x67, 0x7c, 0x2d, 0x68, 0x7c, 0x2d, 0x6c, 0x7c, 0x2d, 0x6d,
    0x7c, 0x2d, 0x6e, 0x7c, 0x2d, 0x70, 0x7c, 0x2d, 0x72, 0x7c, 0x2d, 0x75,
    0x7c, 0x2e, 0x30, 0x7c, 0x2e, 0x31, 0x7c, 0x2e, 0x32, 0x7c, 0x2e, 0x61,
    0x7c, 0x2e, 0x63, 0x7c, 0x2e, 0x65, 0x7c, 0x2e, 0x69, 0x7c, 0x2e, 0x6f,
    0x7c, 0x2e, 0x73, 0x7c, 0x2e, 0x74, 0x7c, 0x2e, 0x20, 0x7c, 0x2e, 0x25,
    0x7c, 0x2e, 0x2d, 0x7c, 0x2e, 0x2e, 0x7c, 0x2e, 0x2f, 0x7c, 0x2e, 0x33,
    0x7c, 0x2e, 0x34, 0x7c, 0x2e, 0x35, 0x7c, 0x2e, 0x36, 0x7c, 0x2e, 0x37,
    0x7c, 0x2e, 0x38, 0x7c, 0x2e, 0x39, 0x7c, 0x2e, 0x3d, 0x7c, 0x2e, 0x41,
    0x7c, 0x2e, 0x5f, 0x7c, 0x2e, 0x62, 0x7c, 0x2e, 0x64, 0x7c, 0x2e, 0x66,
    0x7c, 0x2e, 0x67, 0x7c, 0x2e, 0x68, 0x7c, 0x2e, 0x6c, 0x7c, 0x2e, 0x6d,
    0x7c, 0x2e, 0x6e, 0x7c, 0x2e, 0x70, 0x7c, 0x2e, 0x72, 0x7c, 0x2e, 0x75};
const uint8_t HuffDecoderCommon::table20_140_emit_[216] = {
    0x7c, 0x2f, 0x30, 0x7c, 0x2f, 0x31, 0x7c, 0x2f, 0x32, 0x7c, 0x2f, 0x61,
    0x7c, 0x2f, 0x63, 0x7c, 0x2f, 0x65, 0x7c, 0x2f, 0x69, 0x7c, 0x2f, 0x6f,
    0x7c, 0x2f, 0x73, 0x7c, 0x2f, 0x74, 0x7c, 0x2f, 0x20, 0x7c, 0x2f, 0x25,
    0x7c, 0x2f, 0x2d, 0x7c, 0x2f, 0x2e, 0x7c, 0x2f, 0x2f, 0x7c, 0x2f, 0x33,
    0x7c, 0x2f, 0x34, 0x7c, 0x2f, 0x35, 0x7c, 0x2f, 0x36, 0x7c, 0x2f, 0x37,
    0x7c, 0x2f, 0x38, 0x7c, 0x2f, 0x39, 0x7c, 0x2f, 0x3d, 0x7c, 0x2f, 0x41,
    0x7c, 0x2f, 0x5f, 0x7c, 0x2f, 0x62, 0x7c, 0x2f, 0x64, 0x7c, 0x2f, 0x66,
    0x7c, 0x2f, 0x67, 0x7c, 0x2f, 0x68, 0x7c, 0x2f, 0x6c, 0x7c, 0x2f, 0x6d,
    0x7c, 0x2f, 0x6e, 0x7c, 0x2f, 0x70, 0x7c, 0x2f, 0x72, 0x7c, 0x2f, 0x75,
    0x7c, 0x33, 0x30, 0x7c, 0x33, 0x31, 0x7c, 0x33, 0x32, 0x7c, 0x33, 0x61,
    0x7c, 0x33, 0x63, 0x7c, 0x33, 0x65, 0x7c, 0x33, 0x69, 0x7c, 0x33, 0x6f,
    0x7c, 0x33, 0x73, 0x7c, 0x33, 0x74, 0x7c, 0x33, 0x20, 0x7c, 0x33, 0x25,
    0x7c, 0x33, 0x2d, 0x7c, 0x33, 0x2e, 0x7c, 0x33, 0x2f, 0x7c, 0x33, 0x33,
    0x7c, 0x33, 0x34, 0x7c, 0x33, 0x35, 0x7c, 0x33, 0x36, 0x7c, 0x33, 0x37,
    0x7c, 0x33, 0x38, 0x7c, 0x33, 0x39, 0x7c, 0x33, 0x3d, 0x7c, 0x33, 0x41,
    0x7c, 0x33, 0x5f, 0x7c, 0x33, 0x62, 0x7c, 0x33, 0x64, 0x7c, 0x33, 0x66,
    0x7c, 0x33, 0x67, 0x7c, 0x33, 0x68, 0x7c, 0x33, 0x6c, 0x7c, 0x33, 0x6d,
    0x7c, 0x33, 0x6e, 0x7c, 0x33, 0x70, 0x7c, 0x33, 0x72, 0x7c, 0x33, 0x75};
const uint8_t HuffDecoderCommon::table20_141_emit_[216] = {
    0x7c, 0x34, 0x30, 0x7c, 0x34, 0x31, 0x7c, 0x34, 0x32, 0x7c, 0x34, 0x61,
    0x7c, 0x34, 0x63, 0x7c, 0x34, 0x65, 0x7c, 0x34, 0x69, 0x7c, 0x34, 0x6f,
    0x7c, 0x34, 0x73, 0x7c, 0x34, 0x74, 0x7c, 0x34, 0x20, 0x7c, 0x34, 0x25,
    0x7c, 0x34, 0x2d, 0x7c, 0x34, 0x2e, 0x7c, 0x34, 0x2f, 0x7c, 0x34, 0x33,
    0x7c, 0x34, 0x34, 0x7c, 0x34, 0x35, 0x7c, 0x34, 0x36, 0x7c, 0x34, 0x37,
    0x7c, 0x34, 0x38, 0x7c, 0x34, 0x39, 0x7c, 0x34, 0x3d, 0x7c, 0x34, 0x41,
    0x7c, 0x34, 0x5f, 0x7c, 0x34, 0x62, 0x7c, 0x34, 0x64, 0x7c, 0x34, 0x66,
    0x7c, 0x34, 0x67, 0x7c, 0x34, 0x68, 0x7c, 0x34, 0x6c, 0x7c, 0x34, 0x6d,
    0x7c, 0x34, 0x6e, 0x7c, 0x34, 0x70, 0x7c, 0x34, 0x72, 0x7c, 0x34, 0x75,
    0x7c, 0x35, 0x30, 0x7c, 0x35, 0x31, 0x7c, 0x35, 0x32, 0x7c, 0x35, 0x61,
    0x7c, 0x35, 0x63, 0x7c, 0x35, 0x65, 0x7c, 0x35, 0x69, 0x7c, 0x35, 0x6f,
    0x7c, 0x35, 0x73, 0x7c, 0x35, 0x74, 0x7c, 0x35, 0x20, 0x7c, 0x35, 0x25,
    0x7c, 0x35, 0x2d, 0x7c, 0x35, 0x2e, 0x7c, 0x35, 0x2f, 0x7c, 0x35, 0x33,
    0x7c, 0x35, 0x34, 0x7c, 0x35, 0x35, 0x7c, 0x35, 0x36, 0x7c, 0x35, 0x37,
    0x7c, 0x35, 0x38, 0x7c, 0x35, 0x39, 0x7c, 0x35, 0x3d, 0x7c, 0x35, 0x41,
    0x7c, 0x35, 0x5f, 0x7c, 0x35, 0x62, 0x7c, 0x35, 0x64, 0x7c, 0x35, 0x66,
    0x7c, 0x35, 0x67, 0x7c, 0x35, 0x68, 0x7c, 0x35, 0x6c, 0x7c, 0x35, 0x6d,
    0x7c, 0x35, 0x6e, 0x7c, 0x35, 0x70, 0x7c, 0x35, 0x72, 0x7c, 0x35, 0x75};
const uint8_t HuffDecoderCommon::table20_142_emit_[216] = {
    0x7c, 0x36, 0x30, 0x7c, 0x36, 0x31, 0x7c, 0x36, 0x32, 0x7c, 0x36, 0x61,
    0x7c, 0x36, 0x63, 0x7c, 0x36, 0x65, 0x7c, 0x36, 0x69, 0x7c, 0x36, 0x6f,
    0x7c, 0x36, 0x73, 0x7c, 0x36, 0x74, 0x7c, 0x36, 0x20, 0x7c, 0x36, 0x25,
    0x7c, 0x36, 0x2d, 0x7c, 0x36, 0x2e, 0x7c, 0x36, 0x2f, 0x7c, 0x36, 0x33,
    0x7c, 0x36, 0x34, 0x7c, 0x36, 0x35, 0x7c, 0x36, 0x36, 0x7c, 0x36, 0x37,
    0x7c, 0x36, 0x38, 0x7c, 0x36, 0x39, 0x7c, 0x36, 0x3d, 0x7c, 0x36, 0x41,
    0x7c, 0x36, 0x5f, 0x7c, 0x36, 0x62, 0x7c, 0x36, 0x64, 0x7c, 0x36, 0x66,
    0x7c, 0x36, 0x67, 0x7c, 0x36, 0x68, 0x7c, 0x36, 0x6c, 0x7c, 0x36, 0x6d,
    0x7c, 0x36, 0x6e, 0x7c, 0x36, 0x70, 0x7c, 0x36, 0x72, 0x7c, 0x36, 0x75,
    0x7c, 0x37, 0x30, 0x7c, 0x37, 0x31, 0x7c, 0x37, 0x32, 0x7c, 0x37, 0x61,
    0x7c, 0x37, 0x63, 0x7c, 0x37, 0x65, 0x7c, 0x37, 0x69, 0x7c, 0x37, 0x6f,
    0x7c, 0x37, 0x73, 0x7c, 0x37, 0x74, 0x7c, 0x37, 0x20, 0x7c, 0x37, 0x25,
    0x7c, 0x37, 0x2d, 0x7c, 0x37, 0x2e, 0x7c, 0x37, 0x2f, 0x7c, 0x37, 0x33,
    0x7c, 0x37, 0x34, 0x7c, 0x37, 0x35, 0x7c, 0x37, 0x36, 0x7c, 0x37, 0x37,
    0x7c, 0x37, 0x38, 0x7c, 0x37, 0x39, 0x7c, 0x37, 0x3d, 0x7c, 0x37, 0x41,
    0x7c, 0x37, 0x5f, 0x7c, 0x37, 0x62, 0x7c, 0x37, 0x64, 0x7c, 0x37, 0x66,
    0x7c, 0x37, 0x67, 0x7c, 0x37, 0x68, 0x7c, 0x37, 0x6c, 0x7c, 0x37, 0x6d,
    0x7c, 0x37, 0x6e, 0x7c, 0x37, 0x70, 0x7c, 0x37, 0x72, 0x7c, 0x37, 0x75};
const uint8_t HuffDecoderCommon::table20_143_emit_[216] = {
    0x7c, 0x38, 0x30, 0x7c, 0x38, 0x31, 0x7c, 0x38, 0x32, 0x7c, 0x38, 0x61,
    0x7c, 0x38, 0x63, 0x7c, 0x38, 0x65, 0x7c, 0x38, 0x69, 0x7c, 0x38, 0x6f,
    0x7c, 0x38, 0x73, 0x7c, 0x38, 0x74, 0x7c, 0x38, 0x20, 0x7c, 0x38, 0x25,
    0x7c, 0x38, 0x2d, 0x7c, 0x38, 0x2e, 0x7c, 0x38, 0x2f, 0x7c, 0x38, 0x33,
    0x7c, 0x38, 0x34, 0x7c, 0x38, 0x35, 0x7c, 0x38, 0x36, 0x7c, 0x38, 0x37,
    0x7c, 0x38, 0x38, 0x7c, 0x38, 0x39, 0x7c, 0x38, 0x3d, 0x7c, 0x38, 0x41,
    0x7c, 0x38, 0x5f, 0x7c, 0x38, 0x62, 0x7c, 0x38, 0x64, 0x7c, 0x38, 0x66,
    0x7c, 0x38, 0x67, 0x7c, 0x38, 0x68, 0x7c, 0x38, 0x6c, 0x7c, 0x38, 0x6d,
    0x7c, 0x38, 0x6e, 0x7c, 0x38, 0x70, 0x7c, 0x38, 0x72, 0x7c, 0x38, 0x75,
    0x7c, 0x39, 0x30, 0x7c, 0x39, 0x31, 0x7c, 0x39, 0x32, 0x7c, 0x39, 0x61,
    0x7c, 0x39, 0x63, 0x7c, 0x39, 0x65, 0x7c, 0x39, 0x69, 0x7c, 0x39, 0x6f,
    0x7c, 0x39, 0x73, 0x7c, 0x39, 0x74, 0x7c, 0x39, 0x20, 0x7c, 0x39, 0x25,
    0x7c, 0x39, 0x2d, 0x7c, 0x39, 0x2e, 0x7c, 0x39, 0x2f, 0x7c, 0x39, 0x33,
    0x7c, 0x39, 0x34, 0x7c, 0x39, 0x35, 0x7c, 0x39, 0x36, 0x7c, 0x39, 0x37,
    0x7c, 0x39, 0x38, 0x7c, 0x39, 0x39, 0x7c, 0x39, 0x3d, 0x7c, 0x39, 0x41,
    0x7c, 0x39, 0x5f, 0x7c, 0x39, 0x62, 0x7c, 0x39, 0x64, 0x7c, 0x39, 0x66,
    0x7c, 0x39, 0x67, 0x7c, 0x39, 0x68, 0x7c, 0x39, 0x6c, 0x7c, 0x39, 0x6d,
    0x7c, 0x39, 0x6e, 0x7c, 0x39, 0x70, 0x7c, 0x39, 0x72, 0x7c, 0x39, 0x75};
const uint8_t HuffDecoderCommon::table20_144_emit_[216] = {
    0x7c, 0x3d, 0x30, 0x7c, 0x3d, 0x31, 0x7c, 0x3d, 0x32, 0x7c, 0x3d, 0x61,
    0x7c, 0x3d, 0x63, 0x7c, 0x3d, 0x65, 0x7c, 0x3d, 0x69, 0x7c, 0x3d, 0x6f,
    0x7c, 0x3d, 0x73, 0x7c, 0x3d, 0x74, 0x7c, 0x3d, 0x20, 0x7c, 0x3d, 0x25,
    0x7c, 0x3d, 0x2d, 0x7c, 0x3d, 0x2e, 0x7c, 0x3d, 0x2f, 0x7c, 0x3d, 0x33,
    0x7c, 0x3d, 0x34, 0x7c, 0x3d, 0x35, 0x7c, 0x3d, 0x36, 0x7c, 0x3d, 0x37,
    0x7c, 0x3d, 0x38, 0x7c, 0x3d, 0x39, 0x7c, 0x3d, 0x3d, 0x7c, 0x3d, 0x41,
    0x7c, 0x3d, 0x5f, 0x7c, 0x3d, 0x62, 0x7c, 0x3d, 0x64, 0x7c, 0x3d, 0x66,
    0x7c, 0x3d, 0x67, 0x7c, 0x3d, 0x68, 0x7c, 0x3d, 0x6c, 0x7c, 0x3d, 0x6d,
    0x7c, 0x3d, 0x6e, 0x7c, 0x3d, 0x70, 0x7c, 0x3d, 0x72, 0x7c, 0x3d, 0x75,
    0x7c, 0x41, 0x30, 0x7c, 0x41, 0x31, 0x7c, 0x41, 0x32, 0x7c, 0x41, 0x61,
    0x7c, 0x41, 0x63, 0x7c, 0x41, 0x65, 0x7c, 0x41, 0x69, 0x7c, 0x41, 0x6f,
    0x7c, 0x41, 0x73, 0x7c, 0x41, 0x74, 0x7c, 0x41, 0x20, 0x7c, 0x41, 0x25,
    0x7c, 0x41, 0x2d, 0x7c, 0x41, 0x2e, 0x7c, 0x41, 0x2f, 0x7c, 0x41, 0x33,
    0x7c, 0x41, 0x34, 0x7c, 0x41, 0x35, 0x7c, 0x41, 0x36, 0x7c, 0x41, 0x37,
    0x7c, 0x41, 0x38, 0x7c, 0x41, 0x39, 0x7c, 0x41, 0x3d, 0x7c, 0x41, 0x41,
    0x7c, 0x41, 0x5f, 0x7c, 0x41, 0x62, 0x7c, 0x41, 0x64, 0x7c, 0x41, 0x66,
    0x7c, 0x41, 0x67, 0x7c, 0x41, 0x68, 0x7c, 0x41, 0x6c, 0x7c, 0x41, 0x6d,
    0x7c, 0x41, 0x6e, 0x7c, 0x41, 0x70, 0x7c, 0x41, 0x72, 0x7c, 0x41, 0x75};
const uint8_t HuffDecoderCommon::table20_145_emit_[216] = {
    0x7c, 0x5f, 0x30, 0x7c, 0x5f, 0x31, 0x7c, 0x5f, 0x32, 0x7c, 0x5f, 0x61,
    0x7c, 0x5f, 0x63, 0x7c, 0x5f, 0x65, 0x7c, 0x5f, 0x69, 0x7c, 0x5f, 0x6f,
    0x7c, 0x5f, 0x73, 0x7c, 0x5f, 0x74, 0x7c, 0x5f, 0x20, 0x7c, 0x5f, 0x25,
    0x7c, 0x5f, 0x2d, 0x7c, 0x5f, 0x2e, 0x7c, 0x5f, 0x2f, 0x7c, 0x5f, 0x33,
    0x7c, 0x5f, 0x34, 0x7c, 0x5f, 0x35, 0x7c, 0x5f, 0x36, 0x7c, 0x5f, 0x37,
    0x7c, 0x5f, 0x38, 0x7c, 0x5f, 0x39, 0x7c, 0x5f, 0x3d, 0x7c, 0x5f, 0x41,
    0x7c, 0x5f, 0x5f, 0x7c, 0x5f, 0x62, 0x7c, 0x5f, 0x64, 0x7c, 0x5f, 0x66,
    0x7c, 0x5f, 0x67, 0x7c, 0x5f, 0x68, 0x7c, 0x5f, 0x6c, 0x7c, 0x5f, 0x6d,
    0x7c, 0x5f, 0x6e, 0x7c, 0x5f, 0x70, 0x7c, 0x5f, 0x72, 0x7c, 0x5f, 0x75,
    0x7c, 0x62, 0x30, 0x7c, 0x62, 0x31, 0x7c, 0x62, 0x32, 0x7c, 0x62, 0x61,
    0x7c, 0x62, 0x63, 0x7c, 0x62, 0x65, 0x7c, 0x62, 0x69, 0x7c, 0x62, 0x6f,
    0x7c, 0x62, 0x73, 0x7c, 0x62, 0x74, 0x7c, 0x62, 0x20, 0x7c, 0x62, 0x25,
    0x7c, 0x62, 0x2d, 0x7c, 0x62, 0x2e, 0x7c, 0x62, 0x2f, 0x7c, 0x62, 0x33,
    0x7c, 0x62, 0x34, 0x7c, 0x62, 0x35, 0x7c, 0x62, 0x36, 0x7c, 0x62, 0x37,
    0x7c, 0x62, 0x38, 0x7c, 0x62, 0x39, 0x7c, 0x62, 0x3d, 0x7c, 0x62, 0x41,
    0x7c, 0x62, 0x5f, 0x7c, 0x62, 0x62, 0x7c, 0x62, 0x64, 0x7c, 0x62, 0x66,
    0x7c, 0x62, 0x67, 0x7c, 0x62, 0x68, 0x7c, 0x62, 0x6c, 0x7c, 0x62, 0x6d,
    0x7c, 0x62, 0x6e, 0x7c, 0x62, 0x70, 0x7c, 0x62, 0x72, 0x7c, 0x62, 0x75};
const uint8_t HuffDecoderCommon::table20_146_emit_[216] = {
    0x7c, 0x64, 0x30, 0x7c, 0x64, 0x31, 0x7c, 0x64, 0x32, 0x7c, 0x64, 0x61,
    0x7c, 0x64, 0x63, 0x7c, 0x64, 0x65, 0x7c, 0x64, 0x69, 0x7c, 0x64, 0x6f,
    0x7c, 0x64, 0x73, 0x7c, 0x64, 0x74, 0x7c, 0x64, 0x20, 0x7c, 0x64, 0x25,
    0x7c, 0x64, 0x2d, 0x7c, 0x64, 0x2e, 0x7c, 0x64, 0x2f, 0x7c, 0x64, 0x33,
    0x7c, 0x64, 0x34, 0x7c, 0x64, 0x35, 0x7c, 0x64, 0x36, 0x7c, 0x64, 0x37,
    0x7c, 0x64, 0x38, 0x7c, 0x64, 0x39, 0x7c, 0x64, 0x3d, 0x7c, 0x64, 0x41,
    0x7c, 0x64, 0x5f, 0x7c, 0x64, 0x62, 0x7c, 0x64, 0x64, 0x7c, 0x64, 0x66,
    0x7c, 0x64, 0x67, 0x7c, 0x64, 0x68, 0x7c, 0x64, 0x6c, 0x7c, 0x64, 0x6d,
    0x7c, 0x64, 0x6e, 0x7c, 0x64, 0x70, 0x7c, 0x64, 0x72, 0x7c, 0x64, 0x75,
    0x7c, 0x66, 0x30, 0x7c, 0x66, 0x31, 0x7c, 0x66, 0x32, 0x7c, 0x66, 0x61,
    0x7c, 0x66, 0x63, 0x7c, 0x66, 0x65, 0x7c, 0x66, 0x69, 0x7c, 0x66, 0x6f,
    0x7c, 0x66, 0x73, 0x7c, 0x66, 0x74, 0x7c, 0x66, 0x20, 0x7c, 0x66, 0x25,
    0x7c, 0x66, 0x2d, 0x7c, 0x66, 0x2e, 0x7c, 0x66, 0x2f, 0x7c, 0x66, 0x33,
    0x7c, 0x66, 0x34, 0x7c, 0x66, 0x35, 0x7c, 0x66, 0x36, 0x7c, 0x66, 0x37,
    0x7c, 0x66, 0x38, 0x7c, 0x66, 0x39, 0x7c, 0x66, 0x3d, 0x7c, 0x66, 0x41,
    0x7c, 0x66, 0x5f, 0x7c, 0x66, 0x62, 0x7c, 0x66, 0x64, 0x7c, 0x66, 0x66,
    0x7c, 0x66, 0x67, 0x7c, 0x66, 0x68, 0x7c, 0x66, 0x6c, 0x7c, 0x66, 0x6d,
    0x7c, 0x66, 0x6e, 0x7c, 0x66, 0x70, 0x7c, 0x66, 0x72, 0x7c, 0x66, 0x75};
const uint8_t HuffDecoderCommon::table20_147_emit_[216] = {
    0x7c, 0x67, 0x30, 0x7c, 0x67, 0x31, 0x7c, 0x67, 0x32, 0x7c, 0x67, 0x61,
    0x7c, 0x67, 0x63, 0x7c, 0x67, 0x65, 0x7c, 0x67, 0x69, 0x7c, 0x67, 0x6f,
    0x7c, 0x67, 0x73, 0x7c, 0x67, 0x74, 0x7c, 0x67, 0x20, 0x7c, 0x67, 0x25,
    0x7c, 0x67, 0x2d, 0x7c, 0x67, 0x2e, 0x7c, 0x67, 0x2f, 0x7c, 0x67, 0x33,
    0x7c, 0x67, 0x34, 0x7c, 0x67, 0x35, 0x7c, 0x67, 0x36, 0x7c, 0x67, 0x37,
    0x7c, 0x67, 0x38, 0x7c, 0x67, 0x39, 0x7c, 0x67, 0x3d, 0x7c, 0x67, 0x41,
    0x7c, 0x67, 0x5f, 0x7c, 0x67, 0x62, 0x7c, 0x67, 0x64, 0x7c, 0x67, 0x66,
    0x7c, 0x67, 0x67, 0x7c, 0x67, 0x68, 0x7c, 0x67, 0x6c, 0x7c, 0x67, 0x6d,
    0x7c, 0x67, 0x6e, 0x7c, 0x67, 0x70, 0x7c, 0x67, 0x72, 0x7c, 0x67, 0x75,
    0x7c, 0x68, 0x30, 0x7c, 0x68, 0x31, 0x7c, 0x68, 0x32, 0x7c, 0x68, 0x61,
    0x7c, 0x68, 0x63, 0x7c, 0x68, 0x65, 0x7c, 0x68, 0x69, 0x7c, 0x68, 0x6f,
    0x7c, 0x68, 0x73, 0x7c, 0x68, 0x74, 0x7c, 0x68, 0x20, 0x7c, 0x68, 0x25,
    0x7c, 0x68, 0x2d, 0x7c, 0x68, 0x2e, 0x7c, 0x68, 0x2f, 0x7c, 0x68, 0x33,
    0x7c, 0x68, 0x34, 0x7c, 0x68, 0x35, 0x7c, 0x68, 0x36, 0x7c, 0x68, 0x37,
    0x7c, 0x68, 0x38, 0x7c, 0x68, 0x39, 0x7c, 0x68, 0x3d, 0x7c, 0x68, 0x41,
    0x7c, 0x68, 0x5f, 0x7c, 0x68, 0x62, 0x7c, 0x68, 0x64, 0x7c, 0x68, 0x66,
    0x7c, 0x68, 0x67, 0x7c, 0x68, 0x68, 0x7c, 0x68, 0x6c, 0x7c, 0x68, 0x6d,
    0x7c, 0x68, 0x6e, 0x7c, 0x68, 0x70, 0x7c, 0x68, 0x72, 0x7c, 0x68, 0x75};
const uint8_t HuffDecoderCommon::table20_148_emit_[216] = {
    0x7c, 0x6c, 0x30, 0x7c, 0x6c, 0x31, 0x7c, 0x6c, 0x32, 0x7c, 0x6c, 0x61,
    0x7c, 0x6c, 0x63, 0x7c, 0x6c, 0x65, 0x7c, 0x6c, 0x69, 0x7c, 0x6c, 0x6f,
    0x7c, 0x6c, 0x73, 0x7c, 0x6c, 0x74, 0x7c, 0x6c, 0x20, 0x7c, 0x6c, 0x25,
    0x7c, 0x6c, 0x2d, 0x7c, 0x6c, 0x2e, 0x7c, 0x6c, 0x2f, 0x7c, 0x6c, 0x33,
    0x7c, 0x6c, 0x34, 0x7c, 0x6c, 0x35, 0x7c, 0x6c, 0x36, 0x7c, 0x6c, 0x37,
    0x7c, 0x6c, 0x38, 0x7c, 0x6c, 0x39, 0x7c, 0x6c, 0x3d, 0x7c, 0x6c, 0x41,
    0x7c, 0x6c, 0x5f, 0x7c, 0x6c, 0x62, 0x7c, 0x6c, 0x64, 0x7c, 0x6c, 0x66,
    0x7c, 0x6c, 0x67, 0x7c, 0x6c, 0x68, 0x7c, 0x6c, 0x6c, 0x7c, 0x6c, 0x6d,
    0x7c, 0x6c, 0x6e, 0x7c, 0x6c, 0x70, 0x7c, 0x6c, 0x72, 0x7c, 0x6c, 0x75,
    0x7c, 0x6d, 0x30, 0x7c, 0x6d, 0x31, 0x7c, 0x6d, 0x32, 0x7c, 0x6d, 0x61,
    0x7c, 0x6d, 0x63, 0x7c, 0x6d, 0x65, 0x7c, 0x6d, 0x69, 0x7c, 0x6d, 0x6f,
    0x7c, 0x6d, 0x73, 0x7c, 0x6d, 0x74, 0x7c, 0x6d, 0x20, 0x7c, 0x6d, 0x25,
    0x7c, 0x6d, 0x2d, 0x7c, 0x6d, 0x2e, 0x7c, 0x6d, 0x2f, 0x7c, 0x6d, 0x33,
    0x7c, 0x6d, 0x34, 0x7c, 0x6d, 0x35, 0x7c, 0x6d, 0x36, 0x7c, 0x6d, 0x37,
    0x7c, 0x6d, 0x38, 0x7c, 0x6d, 0x39, 0x7c, 0x6d, 0x3d, 0x7c, 0x6d, 0x41,
    0x7c, 0x6d, 0x5f, 0x7c, 0x6d, 0x62, 0x7c, 0x6d, 0x64, 0x7c, 0x6d, 0x66,
    0x7c, 0x6d, 0x67, 0x7c, 0x6d, 0x68, 0x7c, 0x6d, 0x6c, 0x7c, 0x6d, 0x6d,
    0x7c, 0x6d, 0x6e, 0x7c, 0x6d, 0x70, 0x7c, 0x6d, 0x72, 0x7c, 0x6d, 0x75};
const uint8_t HuffDecoderCommon::table20_149_emit_[216] = {
    0x7c, 0x6e, 0x30, 0x7c, 0x6e, 0x31, 0x7c, 0x6e, 0x32, 0x7c, 0x6e, 0x61,
    0x7c, 0x6e, 0x63, 0x7c, 0x6e, 0x65, 0x7c, 0x6e, 0x69, 0x7c, 0x6e, 0x6f,
    0x7c, 0x6e, 0x73, 0x7c, 0x6e, 0x74, 0x7c, 0x6e, 0x20, 0x7c, 0x6e, 0x25,
    0x7c, 0x6e, 0x2d, 0x7c, 0x6e, 0x2e, 0x7c, 0x6e, 0x2f, 0x7c, 0x6e, 0x33,
    0x7c, 0x6e, 0x34, 0x7c, 0x6e, 0x35, 0x7c, 0x6e, 0x36, 0x7c, 0x6e, 0x37,
    0x7c, 0x6e, 0x38, 0x7c, 0x6e, 0x39, 0x7c, 0x6e, 0x3d, 0x7c, 0x6e, 0x41,
    0x7c, 0x6e, 0x5f, 0x7c, 0x6e, 0x62, 0x7c, 0x6e, 0x64, 0x7c, 0x6e, 0x66,
    0x7c, 0x6e, 0x67, 0x7c, 0x6e, 0x68, 0x7c, 0x6e, 0x6c, 0x7c, 0x6e, 0x6d,
    0x7c, 0x6e, 0x6e, 0x7c, 0x6e, 0x70, 0x7c, 0x6e, 0x72, 0x7c, 0x6e, 0x75,
    0x7c, 0x70, 0x30, 0x7c, 0x70, 0x31, 0x7c, 0x70, 0x32, 0x7c, 0x70, 0x61,
    0x7c, 0x70, 0x63, 0x7c, 0x70, 0x65, 0x7c, 0x70, 0x69, 0x7c, 0x70, 0x6f,
    0x7c, 0x70, 0x73, 0x7c, 0x70, 0x74, 0x7c, 0x70, 0x20, 0x7c, 0x70, 0x25,
    0x7c, 0x70, 0x2d, 0x7c, 0x70, 0x2e, 0x7c, 0x70, 0x2f, 0x7c, 0x70, 0x33,
    0x7c, 0x70, 0x34, 0x7c, 0x70, 0x35, 0x7c, 0x70, 0x36, 0x7c, 0x70, 0x37,
    0x7c, 0x70, 0x38, 0x7c, 0x70, 0x39, 0x7c, 0x70, 0x3d, 0x7c, 0x70, 0x41,
    0x7c, 0x70, 0x5f, 0x7c, 0x70, 0x62, 0x7c, 0x70, 0x64, 0x7c, 0x70, 0x66,
    0x7c, 0x70, 0x67, 0x7c, 0x70, 0x68, 0x7c, 0x70, 0x6c, 0x7c, 0x70, 0x6d,
    0x7c, 0x70, 0x6e, 0x7c, 0x70, 0x70, 0x7c, 0x70, 0x72, 0x7c, 0x70, 0x75};
const uint8_t HuffDecoderCommon::table20_150_emit_[216] = {
    0x7c, 0x72, 0x30, 0x7c, 0x72, 0x31, 0x7c, 0x72, 0x32, 0x7c, 0x72, 0x61,
    0x7c, 0x72, 0x63, 0x7c, 0x72, 0x65, 0x7c, 0x72, 0x69, 0x7c, 0x72, 0x6f,
    0x7c, 0x72, 0x73, 0x7c, 0x72, 0x74, 0x7c, 0x72, 0x20, 0x7c, 0x72, 0x25,
    0x7c, 0x72, 0x2d, 0x7c, 0x72, 0x2e, 0x7c, 0x72, 0x2f, 0x7c, 0x72, 0x33,
    0x7c, 0x72, 0x34, 0x7c, 0x72, 0x35, 0x7c, 0x72, 0x36, 0x7c, 0x72, 0x37,
    0x7c, 0x72, 0x38, 0x7c, 0x72, 0x39, 0x7c, 0x72, 0x3d, 0x7c, 0x72, 0x41,
    0x7c, 0x72, 0x5f, 0x7c, 0x72, 0x62, 0x7c, 0x72, 0x64, 0x7c, 0x72, 0x66,
    0x7c, 0x72, 0x67, 0x7c, 0x72, 0x68, 0x7c, 0x72, 0x6c, 0x7c, 0x72, 0x6d,
    0x7c, 0x72, 0x6e, 0x7c, 0x72, 0x70, 0x7c, 0x72, 0x72, 0x7c, 0x72, 0x75,
    0x7c, 0x75, 0x30, 0x7c, 0x75, 0x31, 0x7c, 0x75, 0x32, 0x7c, 0x75, 0x61,
    0x7c, 0x75, 0x63, 0x7c, 0x75, 0x65, 0x7c, 0x75, 0x69, 0x7c, 0x75, 0x6f,
    0x7c, 0x75, 0x73, 0x7c, 0x75, 0x74, 0x7c, 0x75, 0x20, 0x7c, 0x75, 0x25,
    0x7c, 0x75, 0x2d, 0x7c, 0x75, 0x2e, 0x7c, 0x75, 0x2f, 0x7c, 0x75, 0x33,
    0x7c, 0x75, 0x34, 0x7c, 0x75, 0x35, 0x7c, 0x75, 0x36, 0x7c, 0x75, 0x37,
    0x7c, 0x75, 0x38, 0x7c, 0x75, 0x39, 0x7c, 0x75, 0x3d, 0x7c, 0x75, 0x41,
    0x7c, 0x75, 0x5f, 0x7c, 0x75, 0x62, 0x7c, 0x75, 0x64, 0x7c, 0x75, 0x66,
    0x7c, 0x75, 0x67, 0x7c, 0x75, 0x68, 0x7c, 0x75, 0x6c, 0x7c, 0x75, 0x6d,
    0x7c, 0x75, 0x6e, 0x7c, 0x75, 0x70, 0x7c, 0x75, 0x72, 0x7c, 0x75, 0x75};
const uint8_t HuffDecoderCommon::table20_151_emit_[120] = {
    0x7c, 0x3a, 0x30, 0x7c, 0x3a, 0x31, 0x7c, 0x3a, 0x32, 0x7c, 0x3a, 0x61,
    0x7c, 0x3a, 0x63, 0x7c, 0x3a, 0x65, 0x7c, 0x3a, 0x69, 0x7c, 0x3a, 0x6f,
    0x7c, 0x3a, 0x73, 0x7c, 0x3a, 0x74, 0x7c, 0x42, 0x30, 0x7c, 0x42, 0x31,
    0x7c, 0x42, 0x32, 0x7c, 0x42, 0x61, 0x7c, 0x42, 0x63, 0x7c, 0x42, 0x65,
    0x7c, 0x42, 0x69, 0x7c, 0x42, 0x6f, 0x7c, 0x42, 0x73, 0x7c, 0x42, 0x74,
    0x7c, 0x43, 0x30, 0x7c, 0x43, 0x31, 0x7c, 0x43, 0x32, 0x7c, 0x43, 0x61,
    0x7c, 0x43, 0x63, 0x7c, 0x43, 0x65, 0x7c, 0x43, 0x69, 0x7c, 0x43, 0x6f,
    0x7c, 0x43, 0x73, 0x7c, 0x43, 0x74, 0x7c, 0x44, 0x30, 0x7c, 0x44, 0x31,
    0x7c, 0x44, 0x32, 0x7c, 0x44, 0x61, 0x7c, 0x44, 0x63, 0x7c, 0x44, 0x65,
    0x7c, 0x44, 0x69, 0x7c, 0x44, 0x6f, 0x7c, 0x44, 0x73, 0x7c, 0x44, 0x74};
const uint8_t HuffDecoderCommon::table20_152_emit_[120] = {
    0x7c, 0x45, 0x30, 0x7c, 0x45, 0x31, 0x7c, 0x45, 0x32, 0x7c, 0x45, 0x61,
    0x7c, 0x45, 0x63, 0x7c, 0x45, 0x65, 0x7c, 0x45, 0x69, 0x7c, 0x45, 0x6f,
    0x7c, 0x45, 0x73, 0x7c, 0x45, 0x74, 0x7c, 0x46, 0x30, 0x7c, 0x46, 0x31,
    0x7c, 0x46, 0x32, 0x7c, 0x46, 0x61, 0x7c, 0x46, 0x63, 0x7c, 0x46, 0x65,
    0x7c, 0x46, 0x69, 0x7c, 0x46, 0x6f, 0x7c, 0x46, 0x73, 0x7c, 0x46, 0x74,
    0x7c, 0x47, 0x30, 0x7c, 0x47, 0x31, 0x7c, 0x47, 0x32, 0x7c, 0x47, 0x61,
    0x7c, 0x47, 0x63, 0x7c, 0x47, 0x65, 0x7c, 0x47, 0x69, 0x7c, 0x47, 0x6f,
    0x7c, 0x47, 0x73, 0x7c, 0x47, 0x74, 0x7c, 0x48, 0x30, 0x7c, 0x48, 0x31,
    0x7c, 0x48, 0x32, 0x7c, 0x48, 0x61, 0x7c, 0x48, 0x63, 0x7c, 0x48, 0x65,
    0x7c, 0x48, 0x69, 0x7c, 0x48, 0x6f, 0x7c, 0x48, 0x73, 0x7c, 0x48, 0x74};
const uint8_t HuffDecoderCommon::table20_153_emit_[120] = {
    0x7c, 0x49, 0x30, 0x7c, 0x49, 0x31, 0x7c, 0x49, 0x32, 0x7c, 0x49, 0x61,
    0x7c, 0x49, 0x63, 0x7c, 0x49, 0x65, 0x7c, 0x49, 0x69, 0x7c, 0x49, 0x6f,
    0x7c, 0x49, 0x73, 0x7c, 0x49, 0x74, 0x7c, 0x4a, 0x30, 0x7c, 0x4a, 0x31,
    0x7c, 0x4a, 0x32, 0x7c, 0x4a, 0x61, 0x7c, 0x4a, 0x63, 0x7c, 0x4a, 0x65,
    0x7c, 0x4a, 0x69, 0x7c, 0x4a, 0x6f, 0x7c, 0x4a, 0x73, 0x7c, 0x4a, 0x74,
    0x7c, 0x4b, 0x30, 0x7c, 0x4b, 0x31, 0x7c, 0x4b, 0x32, 0x7c, 0x4b, 0x61,
    0x7c, 0x4b, 0x63, 0x7c, 0x4b, 0x65, 0x7c, 0x4b, 0x69, 0x7c, 0x4b, 0x6f,
    0x7c, 0x4b, 0x73, 0x7c, 0x4b, 0x74, 0x7c, 0x4c, 0x30, 0x7c, 0x4c, 0x31,
    0x7c, 0x4c, 0x32, 0x7c, 0x4c, 0x61, 0x7c, 0x4c, 0x63, 0x7c, 0x4c, 0x65,
    0x7c, 0x4c, 0x69, 0x7c, 0x4c, 0x6f, 0x7c, 0x4c, 0x73, 0x7c, 0x4c, 0x74};
const uint8_t HuffDecoderCommon::table20_154_emit_[120] = {
    0x7c, 0x4d, 0x30, 0x7c, 0x4d, 0x31, 0x7c, 0x4d, 0x32, 0x7c, 0x4d, 0x61,
    0x7c, 0x4d, 0x63, 0x7c, 0x4d, 0x65, 0x7c, 0x4d, 0x69, 0x7c, 0x4d, 0x6f,
    0x7c, 0x4d, 0x73, 0x7c, 0x4d, 0x74, 0x7c, 0x4e, 0x30, 0x7c, 0x4e, 0x31,
    0x7c, 0x4e, 0x32, 0x7c, 0x4e, 0x61, 0x7c, 0x4e, 0x63, 0x7c, 0x4e, 0x65,
    0x7c, 0x4e, 0x69, 0x7c, 0x4e, 0x6f, 0x7c, 0x4e, 0x73, 0x7c, 0x4e, 0x74,
    0x7c, 0x4f, 0x30, 0x7c, 0x4f, 0x31, 0x7c, 0x4f, 0x32, 0x7c, 0x4f, 0x61,
    0x7c, 0x4f, 0x63, 0x7c, 0x4f, 0x65, 0x7c, 0x4f, 0x69, 0x7c, 0x4f, 0x6f,
    0x7c, 0x4f, 0x73, 0x7c, 0x4f, 0x74, 0x7c, 0x50, 0x30, 0x7c, 0x50, 0x31,
    0x7c, 0x50, 0x32, 0x7c, 0x50, 0x61, 0x7c, 0x50, 0x63, 0x7c, 0x50, 0x65,
    0x7c, 0x50, 0x69, 0x7c, 0x50, 0x6f, 0x7c, 0x50, 0x73, 0x7c, 0x50, 0x74};
const uint8_t HuffDecoderCommon::table20_155_emit_[120] = {
    0x7c, 0x51, 0x30, 0x7c, 0x51, 0x31, 0x7c, 0x51, 0x32, 0x7c, 0x51, 0x61,
    0x7c, 0x51, 0x63, 0x7c, 0x51, 0x65, 0x7c, 0x51, 0x69, 0x7c, 0x51, 0x6f,
    0x7c, 0x51, 0x73, 0x7c, 0x51, 0x74, 0x7c, 0x52, 0x30, 0x7c, 0x52, 0x31,
    0x7c, 0x52, 0x32, 0x7c, 0x52, 0x61, 0x7c, 0x52, 0x63, 0x7c, 0x52, 0x65,
    0x7c, 0x52, 0x69, 0x7c, 0x52, 0x6f, 0x7c, 0x52, 0x73, 0x7c, 0x52, 0x74,
    0x7c, 0x53, 0x30, 0x7c, 0x53, 0x31, 0x7c, 0x53, 0x32, 0x7c, 0x53, 0x61,
    0x7c, 0x53, 0x63, 0x7c, 0x53, 0x65, 0x7c, 0x53, 0x69, 0x7c, 0x53, 0x6f,
    0x7c, 0x53, 0x73, 0x7c, 0x53, 0x74, 0x7c, 0x54, 0x30, 0x7c, 0x54, 0x31,
    0x7c, 0x54, 0x32, 0x7c, 0x54, 0x61, 0x7c, 0x54, 0x63, 0x7c, 0x54, 0x65,
    0x7c, 0x54, 0x69, 0x7c, 0x54, 0x6f, 0x7c, 0x54, 0x73, 0x7c, 0x54, 0x74};
const uint8_t HuffDecoderCommon::table20_156_emit_[120] = {
    0x7c, 0x55, 0x30, 0x7c, 0x55, 0x31, 0x7c, 0x55, 0x32, 0x7c, 0x55, 0x61,
    0x7c, 0x55, 0x63, 0x7c, 0x55, 0x65, 0x7c, 0x55, 0x69, 0x7c, 0x55, 0x6f,
    0x7c, 0x55, 0x73, 0x7c, 0x55, 0x74, 0x7c, 0x56, 0x30, 0x7c, 0x56, 0x31,
    0x7c, 0x56, 0x32, 0x7c, 0x56, 0x61, 0x7c, 0x56, 0x63, 0x7c, 0x56, 0x65,
    0x7c, 0x56, 0x69, 0x7c, 0x56, 0x6f, 0x7c, 0x56, 0x73, 0x7c, 0x56, 0x74,
    0x7c, 0x57, 0x30, 0x7c, 0x57, 0x31, 0x7c, 0x57, 0x32, 0x7c, 0x57, 0x61,
    0x7c, 0x57, 0x63, 0x7c, 0x57, 0x65, 0x7c, 0x57, 0x69, 0x7c, 0x57, 0x6f,
    0x7c, 0x57, 0x73, 0x7c, 0x57, 0x74, 0x7c, 0x59, 0x30, 0x7c, 0x59, 0x31,
    0x7c, 0x59, 0x32, 0x7c, 0x59, 0x61, 0x7c, 0x59, 0x63, 0x7c, 0x59, 0x65,
    0x7c, 0x59, 0x69, 0x7c, 0x59, 0x6f, 0x7c, 0x59, 0x73, 0x7c, 0x59, 0x74};
const uint8_t HuffDecoderCommon::table20_157_emit_[120] = {
    0x7c, 0x6a, 0x30, 0x7c, 0x6a, 0x31, 0x7c, 0x6a, 0x32, 0x7c, 0x6a, 0x61,
    0x7c, 0x6a, 0x63, 0x7c, 0x6a, 0x65, 0x7c, 0x6a, 0x69, 0x7c, 0x6a, 0x6f,
    0x7c, 0x6a, 0x73, 0x7c, 0x6a, 0x74, 0x7c, 0x6b, 0x30, 0x7c, 0x6b, 0x31,
    0x7c, 0x6b, 0x32, 0x7c, 0x6b, 0x61, 0x7c, 0x6b, 0x63, 0x7c, 0x6b, 0x65,
    0x7c, 0x6b, 0x69, 0x7c, 0x6b, 0x6f, 0x7c, 0x6b, 0x73, 0x7c, 0x6b, 0x74,
    0x7c, 0x71, 0x30, 0x7c, 0x71, 0x31, 0x7c, 0x71, 0x32, 0x7c, 0x71, 0x61,
    0x7c, 0x71, 0x63, 0x7c, 0x71, 0x65, 0x7c, 0x71, 0x69, 0x7c, 0x71, 0x6f,
    0x7c, 0x71, 0x73, 0x7c, 0x71, 0x74, 0x7c, 0x76, 0x30, 0x7c, 0x76, 0x31,
    0x7c, 0x76, 0x32, 0x7c, 0x76, 0x61, 0x7c, 0x76, 0x63, 0x7c, 0x76, 0x65,
    0x7c, 0x76, 0x69, 0x7c, 0x76, 0x6f, 0x7c, 0x76, 0x73, 0x7c, 0x76, 0x74};
const uint8_t HuffDecoderCommon::table20_158_emit_[120] = {
    0x7c, 0x77, 0x30, 0x7c, 0x77, 0x31, 0x7c, 0x77, 0x32, 0x7c, 0x77, 0x61,
    0x7c, 0x77, 0x63, 0x7c, 0x77, 0x65, 0x7c, 0x77, 0x69, 0x7c, 0x77, 0x6f,
    0x7c, 0x77, 0x73, 0x7c, 0x77, 0x74, 0x7c, 0x78, 0x30, 0x7c, 0x78, 0x31,
    0x7c, 0x78, 0x32, 0x7c, 0x78, 0x61, 0x7c, 0x78, 0x63, 0x7c, 0x78, 0x65,
    0x7c, 0x78, 0x69, 0x7c, 0x78, 0x6f, 0x7c, 0x78, 0x73, 0x7c, 0x78, 0x74,
    0x7c, 0x79, 0x30, 0x7c, 0x79, 0x31, 0x7c, 0x79, 0x32, 0x7c, 0x79, 0x61,
    0x7c, 0x79, 0x63, 0x7c, 0x79, 0x65, 0x7c, 0x79, 0x69, 0x7c, 0x79, 0x6f,
    0x7c, 0x79, 0x73, 0x7c, 0x79, 0x74, 0x7c, 0x7a, 0x30, 0x7c, 0x7a, 0x31,
    0x7c, 0x7a, 0x32, 0x7c, 0x7a, 0x61, 0x7c, 0x7a, 0x63, 0x7c, 0x7a, 0x65,
    0x7c, 0x7a, 0x69, 0x7c, 0x7a, 0x6f, 0x7c, 0x7a, 0x73, 0x7c, 0x7a, 0x74};
const uint8_t HuffDecoderCommon::table20_159_emit_[31] = {
    0x7c, 0x26, 0x7c, 0x2a, 0x7c, 0x2c, 0x7c, 0x3b, 0x7c, 0x58, 0x7c,
    0x5a, 0x7c, 0x21, 0x7c, 0x22, 0x7c, 0x28, 0x7c, 0x29, 0x7c, 0x3f,
    0x7c, 0x27, 0x7c, 0x2b, 0x7c, 0x7c, 0x23, 0x7c, 0x3e};
const uint16_t HuffDecoderCommon::table20_159_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0062, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000,
    0x00b2, 0x0000, 0x00c2, 0x0000, 0x00d2, 0x00da, 0x00ea, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table20_160_emit_[216] = {
    0x23, 0x30, 0x30, 0x23, 0x30, 0x31, 0x23, 0x30, 0x32, 0x23, 0x30, 0x61,
    0x23, 0x30, 0x63, 0x23, 0x30, 0x65, 0x23, 0x30, 0x69, 0x23, 0x30, 0x6f,
    0x23, 0x30, 0x73, 0x23, 0x30, 0x74, 0x23, 0x30, 0x20, 0x23, 0x30, 0x25,
    0x23, 0x30, 0x2d, 0x23, 0x30, 0x2e, 0x23, 0x30, 0x2f, 0x23, 0x30, 0x33,
    0x23, 0x30, 0x34, 0x23, 0x30, 0x35, 0x23, 0x30, 0x36, 0x23, 0x30, 0x37,
    0x23, 0x30, 0x38, 0x23, 0x30, 0x39, 0x23, 0x30, 0x3d, 0x23, 0x30, 0x41,
    0x23, 0x30, 0x5f, 0x23, 0x30, 0x62, 0x23, 0x30, 0x64, 0x23, 0x30, 0x66,
    0x23, 0x30, 0x67, 0x23, 0x30, 0x68, 0x23, 0x30, 0x6c, 0x23, 0x30, 0x6d,
    0x23, 0x30, 0x6e, 0x23, 0x30, 0x70, 0x23, 0x30, 0x72, 0x23, 0x30, 0x75,
    0x23, 0x31, 0x30, 0x23, 0x31, 0x31, 0x23, 0x31, 0x32, 0x23, 0x31, 0x61,
    0x23, 0x31, 0x63, 0x23, 0x31, 0x65, 0x23, 0x31, 0x69, 0x23, 0x31, 0x6f,
    0x23, 0x31, 0x73, 0x23, 0x31, 0x74, 0x23, 0x31, 0x20, 0x23, 0x31, 0x25,
    0x23, 0x31, 0x2d, 0x23, 0x31, 0x2e, 0x23, 0x31, 0x2f, 0x23, 0x31, 0x33,
    0x23, 0x31, 0x34, 0x23, 0x31, 0x35, 0x23, 0x31, 0x36, 0x23, 0x31, 0x37,
    0x23, 0x31, 0x38, 0x23, 0x31, 0x39, 0x23, 0x31, 0x3d, 0x23, 0x31, 0x41,
    0x23, 0x31, 0x5f, 0x23, 0x31, 0x62, 0x23, 0x31, 0x64, 0x23, 0x31, 0x66,
    0x23, 0x31, 0x67, 0x23, 0x31, 0x68, 0x23, 0x31, 0x6c, 0x23, 0x31, 0x6d,
    0x23, 0x31, 0x6e, 0x23, 0x31, 0x70, 0x23, 0x31, 0x72, 0x23, 0x31, 0x75};
const uint8_t HuffDecoderCommon::table20_161_emit_[216] = {
    0x23, 0x32, 0x30, 0x23, 0x32, 0x31, 0x23, 0x32, 0x32, 0x23, 0x32, 0x61,
    0x23, 0x32, 0x63, 0x23, 0x32, 0x65, 0x23, 0x32, 0x69, 0x23, 0x32, 0x6f,
    0x23, 0x32, 0x73, 0x23, 0x32, 0x74, 0x23, 0x32, 0x20, 0x23, 0x32, 0x25,
    0x23, 0x32, 0x2d, 0x23, 0x32, 0x2e, 0x23, 0x32, 0x2f, 0x23, 0x32, 0x33,
    0x23, 0x32, 0x34, 0x23, 0x32, 0x35, 0x23, 0x32, 0x36, 0x23, 0x32, 0x37,
    0x23, 0x32, 0x38, 0x23, 0x32, 0x39, 0x23, 0x32, 0x3d, 0x23, 0x32, 0x41,
    0x23, 0x32, 0x5f, 0x23, 0x32, 0x62, 0x23, 0x32, 0x64, 0x23, 0x32, 0x66,
    0x23, 0x32, 0x67, 0x23, 0x32, 0x68, 0x23, 0x32, 0x6c, 0x23, 0x32, 0x6d,
    0x23, 0x32, 0x6e, 0x23, 0x32, 0x70, 0x23, 0x32, 0x72, 0x23, 0x32, 0x75,
    0x23, 0x61, 0x30, 0x23, 0x61, 0x31, 0x23, 0x61, 0x32, 0x23, 0x61, 0x61,
    0x23, 0x61, 0x63, 0x23, 0x61, 0x65, 0x23, 0x61, 0x69, 0x23, 0x61, 0x6f,
    0x23, 0x61, 0x73, 0x23, 0x61, 0x74, 0x23, 0x61, 0x20, 0x23, 0x61, 0x25,
    0x23, 0x61, 0x2d, 0x23, 0x61, 0x2e, 0x23, 0x61, 0x2f, 0x23, 0x61, 0x33,
    0x23, 0x61, 0x34, 0x23, 0x61, 0x35, 0x23, 0x61, 0x36, 0x23, 0x61, 0x37,
    0x23, 0x61, 0x38, 0x23, 0x61, 0x39, 0x23, 0x61, 0x3d, 0x23, 0x61, 0x41,
    0x23, 0x61, 0x5f, 0x23, 0x61, 0x62, 0x23, 0x61, 0x64, 0x23, 0x61, 0x66,
    0x23, 0x61, 0x67, 0x23, 0x61, 0x68, 0x23, 0x61, 0x6c, 0x23, 0x61, 0x6d,
    0x23, 0x61, 0x6e, 0x23, 0x61, 0x70, 0x23, 0x61, 0x72, 0x23, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table20_162_emit_[216] = {
    0x23, 0x63, 0x30, 0x23, 0x63, 0x31, 0x23, 0x63, 0x32, 0x23, 0x63, 0x61,
    0x23, 0x63, 0x63, 0x23, 0x63, 0x65, 0x23, 0x63, 0x69, 0x23, 0x63, 0x6f,
    0x23, 0x63, 0x73, 0x23, 0x63, 0x74, 0x23, 0x63, 0x20, 0x23, 0x63, 0x25,
    0x23, 0x63, 0x2d, 0x23, 0x63, 0x2e, 0x23, 0x63, 0x2f, 0x23, 0x63, 0x33,
    0x23, 0x63, 0x34, 0x23, 0x63, 0x35, 0x23, 0x63, 0x36, 0x23, 0x63, 0x37,
    0x23, 0x63, 0x38, 0x23, 0x63, 0x39, 0x23, 0x63, 0x3d, 0x23, 0x63, 0x41,
    0x23, 0x63, 0x5f, 0x23, 0x63, 0x62, 0x23, 0x63, 0x64, 0x23, 0x63, 0x66,
    0x23, 0x63, 0x67, 0x23, 0x63, 0x68, 0x23, 0x63, 0x6c, 0x23, 0x63, 0x6d,
    0x23, 0x63, 0x6e, 0x23, 0x63, 0x70, 0x23, 0x63, 0x72, 0x23, 0x63, 0x75,
    0x23, 0x65, 0x30, 0x23, 0x65, 0x31, 0x23, 0x65, 0x32, 0x23, 0x65, 0x61,
    0x23, 0x65, 0x63, 0x23, 0x65, 0x65, 0x23, 0x65, 0x69, 0x23, 0x65, 0x6f,
    0x23, 0x65, 0x73, 0x23, 0x65, 0x74, 0x23, 0x65, 0x20, 0x23, 0x65, 0x25,
    0x23, 0x65, 0x2d, 0x23, 0x65, 0x2e, 0x23, 0x65, 0x2f, 0x23, 0x65, 0x33,
    0x23, 0x65, 0x34, 0x23, 0x65, 0x35, 0x23, 0x65, 0x36, 0x23, 0x65, 0x37,
    0x23, 0x65, 0x38, 0x23, 0x65, 0x39, 0x23, 0x65, 0x3d, 0x23, 0x65, 0x41,
    0x23, 0x65, 0x5f, 0x23, 0x65, 0x62, 0x23, 0x65, 0x64, 0x23, 0x65, 0x66,
    0x23, 0x65, 0x67, 0x23, 0x65, 0x68, 0x23, 0x65, 0x6c, 0x23, 0x65, 0x6d,
    0x23, 0x65, 0x6e, 0x23, 0x65, 0x70, 0x23, 0x65, 0x72, 0x23, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table20_163_emit_[216] = {
    0x23, 0x69, 0x30, 0x23, 0x69, 0x31, 0x23, 0x69, 0x32, 0x23, 0x69, 0x61,
    0x23, 0x69, 0x63, 0x23, 0x69, 0x65, 0x23, 0x69, 0x69, 0x23, 0x69, 0x6f,
    0x23, 0x69, 0x73, 0x23, 0x69, 0x74, 0x23, 0x69, 0x20, 0x23, 0x69, 0x25,
    0x23, 0x69, 0x2d, 0x23, 0x69, 0x2e, 0x23, 0x69, 0x2f, 0x23, 0x69, 0x33,
    0x23, 0x69, 0x34, 0x23, 0x69, 0x35, 0x23, 0x69, 0x36, 0x23, 0x69, 0x37,
    0x23, 0x69, 0x38, 0x23, 0x69, 0x39, 0x23, 0x69, 0x3d, 0x23, 0x69, 0x41,
    0x23, 0x69, 0x5f, 0x23, 0x69, 0x62, 0x23, 0x69, 0x64, 0x23, 0x69, 0x66,
    0x23, 0x69, 0x67, 0x23, 0x69, 0x68, 0x23, 0x69, 0x6c, 0x23, 0x69, 0x6d,
    0x23, 0x69, 0x6e, 0x23, 0x69, 0x70, 0x23, 0x69, 0x72, 0x23, 0x69, 0x75,
    0x23, 0x6f, 0x30, 0x23, 0x6f, 0x31, 0x23, 0x6f, 0x32, 0x23, 0x6f, 0x61,
    0x23, 0x6f, 0x63, 0x23, 0x6f, 0x65, 0x23, 0x6f, 0x69, 0x23, 0x6f, 0x6f,
    0x23, 0x6f, 0x73, 0x23, 0x6f, 0x74, 0x23, 0x6f, 0x20, 0x23, 0x6f, 0x25,
    0x23, 0x6f, 0x2d, 0x23, 0x6f, 0x2e, 0x23, 0x6f, 0x2f, 0x23, 0x6f, 0x33,
    0x23, 0x6f, 0x34, 0x23, 0x6f, 0x35, 0x23, 0x6f, 0x36, 0x23, 0x6f, 0x37,
    0x23, 0x6f, 0x38, 0x23, 0x6f, 0x39, 0x23, 0x6f, 0x3d, 0x23, 0x6f, 0x41,
    0x23, 0x6f, 0x5f, 0x23, 0x6f, 0x62, 0x23, 0x6f, 0x64, 0x23, 0x6f, 0x66,
    0x23, 0x6f, 0x67, 0x23, 0x6f, 0x68, 0x23, 0x6f, 0x6c, 0x23, 0x6f, 0x6d,
    0x23, 0x6f, 0x6e, 0x23, 0x6f, 0x70, 0x23, 0x6f, 0x72, 0x23, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table20_164_emit_[216] = {
    0x23, 0x73, 0x30, 0x23, 0x73, 0x31, 0x23, 0x73, 0x32, 0x23, 0x73, 0x61,
    0x23, 0x73, 0x63, 0x23, 0x73, 0x65, 0x23, 0x73, 0x69, 0x23, 0x73, 0x6f,
    0x23, 0x73, 0x73, 0x23, 0x73, 0x74, 0x23, 0x73, 0x20, 0x23, 0x73, 0x25,
    0x23, 0x73, 0x2d, 0x23, 0x73, 0x2e, 0x23, 0x73, 0x2f, 0x23, 0x73, 0x33,
    0x23, 0x73, 0x34, 0x23, 0x73, 0x35, 0x23, 0x73, 0x36, 0x23, 0x73, 0x37,
    0x23, 0x73, 0x38, 0x23, 0x73, 0x39, 0x23, 0x73, 0x3d, 0x23, 0x73, 0x41,
    0x23, 0x73, 0x5f, 0x23, 0x73, 0x62, 0x23, 0x73, 0x64, 0x23, 0x73, 0x66,
    0x23, 0x73, 0x67, 0x23, 0x73, 0x68, 0x23, 0x73, 0x6c, 0x23, 0x73, 0x6d,
    0x23, 0x73, 0x6e, 0x23, 0x73, 0x70, 0x23, 0x73, 0x72, 0x23, 0x73, 0x75,
    0x23, 0x74, 0x30, 0x23, 0x74, 0x31, 0x23, 0x74, 0x32, 0x23, 0x74, 0x61,
    0x23, 0x74, 0x63, 0x23, 0x74, 0x65, 0x23, 0x74, 0x69, 0x23, 0x74, 0x6f,
    0x23, 0x74, 0x73, 0x23, 0x74, 0x74, 0x23, 0x74, 0x20, 0x23, 0x74, 0x25,
    0x23, 0x74, 0x2d, 0x23, 0x74, 0x2e, 0x23, 0x74, 0x2f, 0x23, 0x74, 0x33,
    0x23, 0x74, 0x34, 0x23, 0x74, 0x35, 0x23, 0x74, 0x36, 0x23, 0x74, 0x37,
    0x23, 0x74, 0x38, 0x23, 0x74, 0x39, 0x23, 0x74, 0x3d, 0x23, 0x74, 0x41,
    0x23, 0x74, 0x5f, 0x23, 0x74, 0x62, 0x23, 0x74, 0x64, 0x23, 0x74, 0x66,
    0x23, 0x74, 0x67, 0x23, 0x74, 0x68, 0x23, 0x74, 0x6c, 0x23, 0x74, 0x6d,
    0x23, 0x74, 0x6e, 0x23, 0x74, 0x70, 0x23, 0x74, 0x72, 0x23, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table20_165_emit_[120] = {
    0x23, 0x20, 0x30, 0x23, 0x20, 0x31, 0x23, 0x20, 0x32, 0x23, 0x20, 0x61,
    0x23, 0x20, 0x63, 0x23, 0x20, 0x65, 0x23, 0x20, 0x69, 0x23, 0x20, 0x6f,
    0x23, 0x20, 0x73, 0x23, 0x20, 0x74, 0x23, 0x25, 0x30, 0x23, 0x25, 0x31,
    0x23, 0x25, 0x32, 0x23, 0x25, 0x61, 0x23, 0x25, 0x63, 0x23, 0x25, 0x65,
    0x23, 0x25, 0x69, 0x23, 0x25, 0x6f, 0x23, 0x25, 0x73, 0x23, 0x25, 0x74,
    0x23, 0x2d, 0x30, 0x23, 0x2d, 0x31, 0x23, 0x2d, 0x32, 0x23, 0x2d, 0x61,
    0x23, 0x2d, 0x63, 0x23, 0x2d, 0x65, 0x23, 0x2d, 0x69, 0x23, 0x2d, 0x6f,
    0x23, 0x2d, 0x73, 0x23, 0x2d, 0x74, 0x23, 0x2e, 0x30, 0x23, 0x2e, 0x31,
    0x23, 0x2e, 0x32, 0x23, 0x2e, 0x61, 0x23, 0x2e, 0x63, 0x23, 0x2e, 0x65,
    0x23, 0x2e, 0x69, 0x23, 0x2e, 0x6f, 0x23, 0x2e, 0x73, 0x23, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table20_166_emit_[120] = {
    0x23, 0x2f, 0x30, 0x23, 0x2f, 0x31, 0x23, 0x2f, 0x32, 0x23, 0x2f, 0x61,
    0x23, 0x2f, 0x63, 0x23, 0x2f, 0x65, 0x23, 0x2f, 0x69, 0x23, 0x2f, 0x6f,
    0x23, 0x2f, 0x73, 0x23, 0x2f, 0x74, 0x23, 0x33, 0x30, 0x23, 0x33, 0x31,
    0x23, 0x33, 0x32, 0x23, 0x33, 0x61, 0x23, 0x33, 0x63, 0x23, 0x33, 0x65,
    0x23, 0x33, 0x69, 0x23, 0x33, 0x6f, 0x23, 0x33, 0x73, 0x23, 0x33, 0x74,
    0x23, 0x34, 0x30, 0x23, 0x34, 0x31, 0x23, 0x34, 0x32, 0x23, 0x34, 0x61,
    0x23, 0x34, 0x63, 0x23, 0x34, 0x65, 0x23, 0x34, 0x69, 0x23, 0x34, 0x6f,
    0x23, 0x34, 0x73, 0x23, 0x34, 0x74, 0x23, 0x35, 0x30, 0x23, 0x35, 0x31,
    0x23, 0x35, 0x32, 0x23, 0x35, 0x61, 0x23, 0x35, 0x63, 0x23, 0x35, 0x65,
    0x23, 0x35, 0x69, 0x23, 0x35, 0x6f, 0x23, 0x35, 0x73, 0x23, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table20_167_emit_[120] = {
    0x23, 0x36, 0x30, 0x23, 0x36, 0x31, 0x23, 0x36, 0x32, 0x23, 0x36, 0x61,
    0x23, 0x36, 0x63, 0x23, 0x36, 0x65, 0x23, 0x36, 0x69, 0x23, 0x36, 0x6f,
    0x23, 0x36, 0x73, 0x23, 0x36, 0x74, 0x23, 0x37, 0x30, 0x23, 0x37, 0x31,
    0x23, 0x37, 0x32, 0x23, 0x37, 0x61, 0x23, 0x37, 0x63, 0x23, 0x37, 0x65,
    0x23, 0x37, 0x69, 0x23, 0x37, 0x6f, 0x23, 0x37, 0x73, 0x23, 0x37, 0x74,
    0x23, 0x38, 0x30, 0x23, 0x38, 0x31, 0x23, 0x38, 0x32, 0x23, 0x38, 0x61,
    0x23, 0x38, 0x63, 0x23, 0x38, 0x65, 0x23, 0x38, 0x69, 0x23, 0x38, 0x6f,
    0x23, 0x38, 0x73, 0x23, 0x38, 0x74, 0x23, 0x39, 0x30, 0x23, 0x39, 0x31,
    0x23, 0x39, 0x32, 0x23, 0x39, 0x61, 0x23, 0x39, 0x63, 0x23, 0x39, 0x65,
    0x23, 0x39, 0x69, 0x23, 0x39, 0x6f, 0x23, 0x39, 0x73, 0x23, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table20_168_emit_[120] = {
    0x23, 0x3d, 0x30, 0x23, 0x3d, 0x31, 0x23, 0x3d, 0x32, 0x23, 0x3d, 0x61,
    0x23, 0x3d, 0x63, 0x23, 0x3d, 0x65, 0x23, 0x3d, 0x69, 0x23, 0x3d, 0x6f,
    0x23, 0x3d, 0x73, 0x23, 0x3d, 0x74, 0x23, 0x41, 0x30, 0x23, 0x41, 0x31,
    0x23, 0x41, 0x32, 0x23, 0x41, 0x61, 0x23, 0x41, 0x63, 0x23, 0x41, 0x65,
    0x23, 0x41, 0x69, 0x23, 0x41, 0x6f, 0x23, 0x41, 0x73, 0x23, 0x41, 0x74,
    0x23, 0x5f, 0x30, 0x23, 0x5f, 0x31, 0x23, 0x5f, 0x32, 0x23, 0x5f, 0x61,
    0x23, 0x5f, 0x63, 0x23, 0x5f, 0x65, 0x23, 0x5f, 0x69, 0x23, 0x5f, 0x6f,
    0x23, 0x5f, 0x73, 0x23, 0x5f, 0x74, 0x23, 0x62, 0x30, 0x23, 0x62, 0x31,
    0x23, 0x62, 0x32, 0x23, 0x62, 0x61, 0x23, 0x62, 0x63, 0x23, 0x62, 0x65,
    0x23, 0x62, 0x69, 0x23, 0x62, 0x6f, 0x23, 0x62, 0x73, 0x23, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table20_169_emit_[120] = {
    0x23, 0x64, 0x30, 0x23, 0x64, 0x31, 0x23, 0x64, 0x32, 0x23, 0x64, 0x61,
    0x23, 0x64, 0x63, 0x23, 0x64, 0x65, 0x23, 0x64, 0x69, 0x23, 0x64, 0x6f,
    0x23, 0x64, 0x73, 0x23, 0x64, 0x74, 0x23, 0x66, 0x30, 0x23, 0x66, 0x31,
    0x23, 0x66, 0x32, 0x23, 0x66, 0x61, 0x23, 0x66, 0x63, 0x23, 0x66, 0x65,
    0x23, 0x66, 0x69, 0x23, 0x66, 0x6f, 0x23, 0x66, 0x73, 0x23, 0x66, 0x74,
    0x23, 0x67, 0x30, 0x23, 0x67, 0x31, 0x23, 0x67, 0x32, 0x23, 0x67, 0x61,
    0x23, 0x67, 0x63, 0x23, 0x67, 0x65, 0x23, 0x67, 0x69, 0x23, 0x67, 0x6f,
    0x23, 0x67, 0x73, 0x23, 0x67, 0x74, 0x23, 0x68, 0x30, 0x23, 0x68, 0x31,
    0x23, 0x68, 0x32, 0x23, 0x68, 0x61, 0x23, 0x68, 0x63, 0x23, 0x68, 0x65,
    0x23, 0x68, 0x69, 0x23, 0x68, 0x6f, 0x23, 0x68, 0x73, 0x23, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table20_170_emit_[120] = {
    0x23, 0x6c, 0x30, 0x23, 0x6c, 0x31, 0x23, 0x6c, 0x32, 0x23, 0x6c, 0x61,
    0x23, 0x6c, 0x63, 0x23, 0x6c, 0x65, 0x23, 0x6c, 0x69, 0x23, 0x6c, 0x6f,
    0x23, 0x6c, 0x73, 0x23, 0x6c, 0x74, 0x23, 0x6d, 0x30, 0x23, 0x6d, 0x31,
    0x23, 0x6d, 0x32, 0x23, 0x6d, 0x61, 0x23, 0x6d, 0x63, 0x23, 0x6d, 0x65,
    0x23, 0x6d, 0x69, 0x23, 0x6d, 0x6f, 0x23, 0x6d, 0x73, 0x23, 0x6d, 0x74,
    0x23, 0x6e, 0x30, 0x23, 0x6e, 0x31, 0x23, 0x6e, 0x32, 0x23, 0x6e, 0x61,
    0x23, 0x6e, 0x63, 0x23, 0x6e, 0x65, 0x23, 0x6e, 0x69, 0x23, 0x6e, 0x6f,
    0x23, 0x6e, 0x73, 0x23, 0x6e, 0x74, 0x23, 0x70, 0x30, 0x23, 0x70, 0x31,
    0x23, 0x70, 0x32, 0x23, 0x70, 0x61, 0x23, 0x70, 0x63, 0x23, 0x70, 0x65,
    0x23, 0x70, 0x69, 0x23, 0x70, 0x6f, 0x23, 0x70, 0x73, 0x23, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table20_171_emit_[68] = {
    0x23, 0x72, 0x30, 0x23, 0x72, 0x31, 0x23, 0x72, 0x32, 0x23, 0x72, 0x61,
    0x23, 0x72, 0x63, 0x23, 0x72, 0x65, 0x23, 0x72, 0x69, 0x23, 0x72, 0x6f,
    0x23, 0x72, 0x73, 0x23, 0x72, 0x74, 0x23, 0x75, 0x30, 0x23, 0x75, 0x31,
    0x23, 0x75, 0x32, 0x23, 0x75, 0x61, 0x23, 0x75, 0x63, 0x23, 0x75, 0x65,
    0x23, 0x75, 0x69, 0x23, 0x75, 0x6f, 0x23, 0x75, 0x73, 0x23, 0x75, 0x74,
    0x23, 0x3a, 0x23, 0x42, 0x23, 0x43, 0x23, 0x44};
const uint8_t HuffDecoderCommon::table20_172_emit_[16] = {
    0x23, 0x45, 0x23, 0x46, 0x23, 0x47, 0x23, 0x48,
    0x23, 0x49, 0x23, 0x4a, 0x23, 0x4b, 0x23, 0x4c};
const uint8_t HuffDecoderCommon::table20_173_emit_[16] = {
    0x23, 0x4d, 0x23, 0x4e, 0x23, 0x4f, 0x23, 0x50,
    0x23, 0x51, 0x23, 0x52, 0x23, 0x53, 0x23, 0x54};
const uint8_t HuffDecoderCommon::table20_174_emit_[16] = {
    0x23, 0x55, 0x23, 0x56, 0x23, 0x57, 0x23, 0x59,
    0x23, 0x6a, 0x23, 0x6b, 0x23, 0x71, 0x23, 0x76};
const uint8_t HuffDecoderCommon::table20_175_emit_[36] = {
    0x23, 0x77, 0x23, 0x78, 0x23, 0x79, 0x23, 0x7a, 0x23, 0x26, 0x23, 0x2a,
    0x23, 0x2c, 0x23, 0x3b, 0x23, 0x58, 0x23, 0x5a, 0x23, 0x21, 0x23, 0x22,
    0x23, 0x28, 0x23, 0x29, 0x23, 0x3f, 0x23, 0x27, 0x23, 0x2b, 0x23, 0x7c};
const uint8_t HuffDecoderCommon::table20_176_emit_[216] = {
    0x3e, 0x30, 0x30, 0x3e, 0x30, 0x31, 0x3e, 0x30, 0x32, 0x3e, 0x30, 0x61,
    0x3e, 0x30, 0x63, 0x3e, 0x30, 0x65, 0x3e, 0x30, 0x69, 0x3e, 0x30, 0x6f,
    0x3e, 0x30, 0x73, 0x3e, 0x30, 0x74, 0x3e, 0x30, 0x20, 0x3e, 0x30, 0x25,
    0x3e, 0x30, 0x2d, 0x3e, 0x30, 0x2e, 0x3e, 0x30, 0x2f, 0x3e, 0x30, 0x33,
    0x3e, 0x30, 0x34, 0x3e, 0x30, 0x35, 0x3e, 0x30, 0x36, 0x3e, 0x30, 0x37,
    0x3e, 0x30, 0x38, 0x3e, 0x30, 0x39, 0x3e, 0x30, 0x3d, 0x3e, 0x30, 0x41,
    0x3e, 0x30, 0x5f, 0x3e, 0x30, 0x62, 0x3e, 0x30, 0x64, 0x3e, 0x30, 0x66,
    0x3e, 0x30, 0x67, 0x3e, 0x30, 0x68, 0x3e, 0x30, 0x6c, 0x3e, 0x30, 0x6d,
    0x3e, 0x30, 0x6e, 0x3e, 0x30, 0x70, 0x3e, 0x30, 0x72, 0x3e, 0x30, 0x75,
    0x3e, 0x31, 0x30, 0x3e, 0x31, 0x31, 0x3e, 0x31, 0x32, 0x3e, 0x31, 0x61,
    0x3e, 0x31, 0x63, 0x3e, 0x31, 0x65, 0x3e, 0x31, 0x69, 0x3e, 0x31, 0x6f,
    0x3e, 0x31, 0x73, 0x3e, 0x31, 0x74, 0x3e, 0x31, 0x20, 0x3e, 0x31, 0x25,
    0x3e, 0x31, 0x2d, 0x3e, 0x31, 0x2e, 0x3e, 0x31, 0x2f, 0x3e, 0x31, 0x33,
    0x3e, 0x31, 0x34, 0x3e, 0x31, 0x35, 0x3e, 0x31, 0x36, 0x3e, 0x31, 0x37,
    0x3e, 0x31, 0x38, 0x3e, 0x31, 0x39, 0x3e, 0x31, 0x3d, 0x3e, 0x31, 0x41,
    0x3e, 0x31, 0x5f, 0x3e, 0x31, 0x62, 0x3e, 0x31, 0x64, 0x3e, 0x31, 0x66,
    0x3e, 0x31, 0x67, 0x3e, 0x31, 0x68, 0x3e, 0x31, 0x6c, 0x3e, 0x31, 0x6d,
    0x3e, 0x31, 0x6e, 0x3e, 0x31, 0x70, 0x3e, 0x31, 0x72, 0x3e, 0x31, 0x75};
const uint8_t HuffDecoderCommon::table20_177_emit_[216] = {
    0x3e, 0x32, 0x30, 0x3e, 0x32, 0x31, 0x3e, 0x32, 0x32, 0x3e, 0x32, 0x61,
    0x3e, 0x32, 0x63, 0x3e, 0x32, 0x65, 0x3e, 0x32, 0x69, 0x3e, 0x32, 0x6f,
    0x3e, 0x32, 0x73, 0x3e, 0x32, 0x74, 0x3e, 0x32, 0x20, 0x3e, 0x32, 0x25,
    0x3e, 0x32, 0x2d, 0x3e, 0x32, 0x2e, 0x3e, 0x32, 0x2f, 0x3e, 0x32, 0x33,
    0x3e, 0x32, 0x34, 0x3e, 0x32, 0x35, 0x3e, 0x32, 0x36, 0x3e, 0x32, 0x37,
    0x3e, 0x32, 0x38, 0x3e, 0x32, 0x39, 0x3e, 0x32, 0x3d, 0x3e, 0x32, 0x41,
    0x3e, 0x32, 0x5f, 0x3e, 0x32, 0x62, 0x3e, 0x32, 0x64, 0x3e, 0x32, 0x66,
    0x3e, 0x32, 0x67, 0x3e, 0x32, 0x68, 0x3e, 0x32, 0x6c, 0x3e, 0x32, 0x6d,
    0x3e, 0x32, 0x6e, 0x3e, 0x32, 0x70, 0x3e, 0x32, 0x72, 0x3e, 0x32, 0x75,
    0x3e, 0x61, 0x30, 0x3e, 0x61, 0x31, 0x3e, 0x61, 0x32, 0x3e, 0x61, 0x61,
    0x3e, 0x61, 0x63, 0x3e, 0x61, 0x65, 0x3e, 0x61, 0x69, 0x3e, 0x61, 0x6f,
    0x3e, 0x61, 0x73, 0x3e, 0x61, 0x74, 0x3e, 0x61, 0x20, 0x3e, 0x61, 0x25,
    0x3e, 0x61, 0x2d, 0x3e, 0x61, 0x2e, 0x3e, 0x61, 0x2f, 0x3e, 0x61, 0x33,
    0x3e, 0x61, 0x34, 0x3e, 0x61, 0x35, 0x3e, 0x61, 0x36, 0x3e, 0x61, 0x37,
    0x3e, 0x61, 0x38, 0x3e, 0x61, 0x39, 0x3e, 0x61, 0x3d, 0x3e, 0x61, 0x41,
    0x3e, 0x61, 0x5f, 0x3e, 0x61, 0x62, 0x3e, 0x61, 0x64, 0x3e, 0x61, 0x66,
    0x3e, 0x61, 0x67, 0x3e, 0x61, 0x68, 0x3e, 0x61, 0x6c, 0x3e, 0x61, 0x6d,
    0x3e, 0x61, 0x6e, 0x3e, 0x61, 0x70, 0x3e, 0x61, 0x72, 0x3e, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table20_178_emit_[216] = {
    0x3e, 0x63, 0x30, 0x3e, 0x63, 0x31, 0x3e, 0x63, 0x32, 0x3e, 0x63, 0x61,
    0x3e, 0x63, 0x63, 0x3e, 0x63, 0x65, 0x3e, 0x63, 0x69, 0x3e, 0x63, 0x6f,
    0x3e, 0x63, 0x73, 0x3e, 0x63, 0x74, 0x3e, 0x63, 0x20, 0x3e, 0x63, 0x25,
    0x3e, 0x63, 0x2d, 0x3e, 0x63, 0x2e, 0x3e, 0x63, 0x2f, 0x3e, 0x63, 0x33,
    0x3e, 0x63, 0x34, 0x3e, 0x63, 0x35, 0x3e, 0x63, 0x36, 0x3e, 0x63, 0x37,
    0x3e, 0x63, 0x38, 0x3e, 0x63, 0x39, 0x3e, 0x63, 0x3d, 0x3e, 0x63, 0x41,
    0x3e, 0x63, 0x5f, 0x3e, 0x63, 0x62, 0x3e, 0x63, 0x64, 0x3e, 0x63, 0x66,
    0x3e, 0x63, 0x67, 0x3e, 0x63, 0x68, 0x3e, 0x63, 0x6c, 0x3e, 0x63, 0x6d,
    0x3e, 0x63, 0x6e, 0x3e, 0x63, 0x70, 0x3e, 0x63, 0x72, 0x3e, 0x63, 0x75,
    0x3e, 0x65, 0x30, 0x3e, 0x65, 0x31, 0x3e, 0x65, 0x32, 0x3e, 0x65, 0x61,
    0x3e, 0x65, 0x63, 0x3e, 0x65, 0x65, 0x3e, 0x65, 0x69, 0x3e, 0x65, 0x6f,
    0x3e, 0x65, 0x73, 0x3e, 0x65, 0x74, 0x3e, 0x65, 0x20, 0x3e, 0x65, 0x25,
    0x3e, 0x65, 0x2d, 0x3e, 0x65, 0x2e, 0x3e, 0x65, 0x2f, 0x3e, 0x65, 0x33,
    0x3e, 0x65, 0x34, 0x3e, 0x65, 0x35, 0x3e, 0x65, 0x36, 0x3e, 0x65, 0x37,
    0x3e, 0x65, 0x38, 0x3e, 0x65, 0x39, 0x3e, 0x65, 0x3d, 0x3e, 0x65, 0x41,
    0x3e, 0x65, 0x5f, 0x3e, 0x65, 0x62, 0x3e, 0x65, 0x64, 0x3e, 0x65, 0x66,
    0x3e, 0x65, 0x67, 0x3e, 0x65, 0x68, 0x3e, 0x65, 0x6c, 0x3e, 0x65, 0x6d,
    0x3e, 0x65, 0x6e, 0x3e, 0x65, 0x70, 0x3e, 0x65, 0x72, 0x3e, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table20_179_emit_[216] = {
    0x3e, 0x69, 0x30, 0x3e, 0x69, 0x31, 0x3e, 0x69, 0x32, 0x3e, 0x69, 0x61,
    0x3e, 0x69, 0x63, 0x3e, 0x69, 0x65, 0x3e, 0x69, 0x69, 0x3e, 0x69, 0x6f,
    0x3e, 0x69, 0x73, 0x3e, 0x69, 0x74, 0x3e, 0x69, 0x20, 0x3e, 0x69, 0x25,
    0x3e, 0x69, 0x2d, 0x3e, 0x69, 0x2e, 0x3e, 0x69, 0x2f, 0x3e, 0x69, 0x33,
    0x3e, 0x69, 0x34, 0x3e, 0x69, 0x35, 0x3e, 0x69, 0x36, 0x3e, 0x69, 0x37,
    0x3e, 0x69, 0x38, 0x3e, 0x69, 0x39, 0x3e, 0x69, 0x3d, 0x3e, 0x69, 0x41,
    0x3e, 0x69, 0x5f, 0x3e, 0x69, 0x62, 0x3e, 0x69, 0x64, 0x3e, 0x69, 0x66,
    0x3e, 0x69, 0x67, 0x3e, 0x69, 0x68, 0x3e, 0x69, 0x6c, 0x3e, 0x69, 0x6d,
    0x3e, 0x69, 0x6e, 0x3e, 0x69, 0x70, 0x3e, 0x69, 0x72, 0x3e, 0x69, 0x75,
    0x3e, 0x6f, 0x30, 0x3e, 0x6f, 0x31, 0x3e, 0x6f, 0x32, 0x3e, 0x6f, 0x61,
    0x3e, 0x6f, 0x63, 0x3e, 0x6f, 0x65, 0x3e, 0x6f, 0x69, 0x3e, 0x6f, 0x6f,
    0x3e, 0x6f, 0x73, 0x3e, 0x6f, 0x74, 0x3e, 0x6f, 0x20, 0x3e, 0x6f, 0x25,
    0x3e, 0x6f, 0x2d, 0x3e, 0x6f, 0x2e, 0x3e, 0x6f, 0x2f, 0x3e, 0x6f, 0x33,
    0x3e, 0x6f, 0x34, 0x3e, 0x6f, 0x35, 0x3e, 0x6f, 0x36, 0x3e, 0x6f, 0x37,
    0x3e, 0x6f, 0x38, 0x3e, 0x6f, 0x39, 0x3e, 0x6f, 0x3d, 0x3e, 0x6f, 0x41,
    0x3e, 0x6f, 0x5f, 0x3e, 0x6f, 0x62, 0x3e, 0x6f, 0x64, 0x3e, 0x6f, 0x66,
    0x3e, 0x6f, 0x67, 0x3e, 0x6f, 0x68, 0x3e, 0x6f, 0x6c, 0x3e, 0x6f, 0x6d,
    0x3e, 0x6f, 0x6e, 0x3e, 0x6f, 0x70, 0x3e, 0x6f, 0x72, 0x3e, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table20_180_emit_[216] = {
    0x3e, 0x73, 0x30, 0x3e, 0x73, 0x31, 0x3e, 0x73, 0x32, 0x3e, 0x73, 0x61,
    0x3e, 0x73, 0x63, 0x3e, 0x73, 0x65, 0x3e, 0x73, 0x69, 0x3e, 0x73, 0x6f,
    0x3e, 0x73, 0x73, 0x3e, 0x73, 0x74, 0x3e, 0x73, 0x20, 0x3e, 0x73, 0x25,
    0x3e, 0x73, 0x2d, 0x3e, 0x73, 0x2e, 0x3e, 0x73, 0x2f, 0x3e, 0x73, 0x33,
    0x3e, 0x73, 0x34, 0x3e, 0x73, 0x35, 0x3e, 0x73, 0x36, 0x3e, 0x73, 0x37,
    0x3e, 0x73, 0x38, 0x3e, 0x73, 0x39, 0x3e, 0x73, 0x3d, 0x3e, 0x73, 0x41,
    0x3e, 0x73, 0x5f, 0x3e, 0x73, 0x62, 0x3e, 0x73, 0x64, 0x3e, 0x73, 0x66,
    0x3e, 0x73, 0x67, 0x3e, 0x73, 0x68, 0x3e, 0x73, 0x6c, 0x3e, 0x73, 0x6d,
    0x3e, 0x73, 0x6e, 0x3e, 0x73, 0x70, 0x3e, 0x73, 0x72, 0x3e, 0x73, 0x75,
    0x3e, 0x74, 0x30, 0x3e, 0x74, 0x31, 0x3e, 0x74, 0x32, 0x3e, 0x74, 0x61,
    0x3e, 0x74, 0x63, 0x3e, 0x74, 0x65, 0x3e, 0x74, 0x69, 0x3e, 0x74, 0x6f,
    0x3e, 0x74, 0x73, 0x3e, 0x74, 0x74, 0x3e, 0x74, 0x20, 0x3e, 0x74, 0x25,
    0x3e, 0x74, 0x2d, 0x3e, 0x74, 0x2e, 0x3e, 0x74, 0x2f, 0x3e, 0x74, 0x33,
    0x3e, 0x74, 0x34, 0x3e, 0x74, 0x35, 0x3e, 0x74, 0x36, 0x3e, 0x74, 0x37,
    0x3e, 0x74, 0x38, 0x3e, 0x74, 0x39, 0x3e, 0x74, 0x3d, 0x3e, 0x74, 0x41,
    0x3e, 0x74, 0x5f, 0x3e, 0x74, 0x62, 0x3e, 0x74, 0x64, 0x3e, 0x74, 0x66,
    0x3e, 0x74, 0x67, 0x3e, 0x74, 0x68, 0x3e, 0x74, 0x6c, 0x3e, 0x74, 0x6d,
    0x3e, 0x74, 0x6e, 0x3e, 0x74, 0x70, 0x3e, 0x74, 0x72, 0x3e, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table20_181_emit_[120] = {
    0x3e, 0x20, 0x30, 0x3e, 0x20, 0x31, 0x3e, 0x20, 0x32, 0x3e, 0x20, 0x61,
    0x3e, 0x20, 0x63, 0x3e, 0x20, 0x65, 0x3e, 0x20, 0x69, 0x3e, 0x20, 0x6f,
    0x3e, 0x20, 0x73, 0x3e, 0x20, 0x74, 0x3e, 0x25, 0x30, 0x3e, 0x25, 0x31,
    0x3e, 0x25, 0x32, 0x3e, 0x25, 0x61, 0x3e, 0x25, 0x63, 0x3e, 0x25, 0x65,
    0x3e, 0x25, 0x69, 0x3e, 0x25, 0x6f, 0x3e, 0x25, 0x73, 0x3e, 0x25, 0x74,
    0x3e, 0x2d, 0x30, 0x3e, 0x2d, 0x31, 0x3e, 0x2d, 0x32, 0x3e, 0x2d, 0x61,
    0x3e, 0x2d, 0x63, 0x3e, 0x2d, 0x65, 0x3e, 0x2d, 0x69, 0x3e, 0x2d, 0x6f,
    0x3e, 0x2d, 0x73, 0x3e, 0x2d, 0x74, 0x3e, 0x2e, 0x30, 0x3e, 0x2e, 0x31,
    0x3e, 0x2e, 0x32, 0x3e, 0x2e, 0x61, 0x3e, 0x2e, 0x63, 0x3e, 0x2e, 0x65,
    0x3e, 0x2e, 0x69, 0x3e, 0x2e, 0x6f, 0x3e, 0x2e, 0x73, 0x3e, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table20_182_emit_[120] = {
    0x3e, 0x2f, 0x30, 0x3e, 0x2f, 0x31, 0x3e, 0x2f, 0x32, 0x3e, 0x2f, 0x61,
    0x3e, 0x2f, 0x63, 0x3e, 0x2f, 0x65, 0x3e, 0x2f, 0x69, 0x3e, 0x2f, 0x6f,
    0x3e, 0x2f, 0x73, 0x3e, 0x2f, 0x74, 0x3e, 0x33, 0x30, 0x3e, 0x33, 0x31,
    0x3e, 0x33, 0x32, 0x3e, 0x33, 0x61, 0x3e, 0x33, 0x63, 0x3e, 0x33, 0x65,
    0x3e, 0x33, 0x69, 0x3e, 0x33, 0x6f, 0x3e, 0x33, 0x73, 0x3e, 0x33, 0x74,
    0x3e, 0x34, 0x30, 0x3e, 0x34, 0x31, 0x3e, 0x34, 0x32, 0x3e, 0x34, 0x61,
    0x3e, 0x34, 0x63, 0x3e, 0x34, 0x65, 0x3e, 0x34, 0x69, 0x3e, 0x34, 0x6f,
    0x3e, 0x34, 0x73, 0x3e, 0x34, 0x74, 0x3e, 0x35, 0x30, 0x3e, 0x35, 0x31,
    0x3e, 0x35, 0x32, 0x3e, 0x35, 0x61, 0x3e, 0x35, 0x63, 0x3e, 0x35, 0x65,
    0x3e, 0x35, 0x69, 0x3e, 0x35, 0x6f, 0x3e, 0x35, 0x73, 0x3e, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table20_183_emit_[120] = {
    0x3e, 0x36, 0x30, 0x3e, 0x36, 0x31, 0x3e, 0x36, 0x32, 0x3e, 0x36, 0x61,
    0x3e, 0x36, 0x63, 0x3e, 0x36, 0x65, 0x3e, 0x36, 0x69, 0x3e, 0x36, 0x6f,
    0x3e, 0x36, 0x73, 0x3e, 0x36, 0x74, 0x3e, 0x37, 0x30, 0x3e, 0x37, 0x31,
    0x3e, 0x37, 0x32, 0x3e, 0x37, 0x61, 0x3e, 0x37, 0x63, 0x3e, 0x37, 0x65,
    0x3e, 0x37, 0x69, 0x3e, 0x37, 0x6f, 0x3e, 0x37, 0x73, 0x3e, 0x37, 0x74,
    0x3e, 0x38, 0x30, 0x3e, 0x38, 0x31, 0x3e, 0x38, 0x32, 0x3e, 0x38, 0x61,
    0x3e, 0x38, 0x63, 0x3e, 0x38, 0x65, 0x3e, 0x38, 0x69, 0x3e, 0x38, 0x6f,
    0x3e, 0x38, 0x73, 0x3e, 0x38, 0x74, 0x3e, 0x39, 0x30, 0x3e, 0x39, 0x31,
    0x3e, 0x39, 0x32, 0x3e, 0x39, 0x61, 0x3e, 0x39, 0x63, 0x3e, 0x39, 0x65,
    0x3e, 0x39, 0x69, 0x3e, 0x39, 0x6f, 0x3e, 0x39, 0x73, 0x3e, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table20_184_emit_[120] = {
    0x3e, 0x3d, 0x30, 0x3e, 0x3d, 0x31, 0x3e, 0x3d, 0x32, 0x3e, 0x3d, 0x61,
    0x3e, 0x3d, 0x63, 0x3e, 0x3d, 0x65, 0x3e, 0x3d, 0x69, 0x3e, 0x3d, 0x6f,
    0x3e, 0x3d, 0x73, 0x3e, 0x3d, 0x74, 0x3e, 0x41, 0x30, 0x3e, 0x41, 0x31,
    0x3e, 0x41, 0x32, 0x3e, 0x41, 0x61, 0x3e, 0x41, 0x63, 0x3e, 0x41, 0x65,
    0x3e, 0x41, 0x69, 0x3e, 0x41, 0x6f, 0x3e, 0x41, 0x73, 0x3e, 0x41, 0x74,
    0x3e, 0x5f, 0x30, 0x3e, 0x5f, 0x31, 0x3e, 0x5f, 0x32, 0x3e, 0x5f, 0x61,
    0x3e, 0x5f, 0x63, 0x3e, 0x5f, 0x65, 0x3e, 0x5f, 0x69, 0x3e, 0x5f, 0x6f,
    0x3e, 0x5f, 0x73, 0x3e, 0x5f, 0x74, 0x3e, 0x62, 0x30, 0x3e, 0x62, 0x31,
    0x3e, 0x62, 0x32, 0x3e, 0x62, 0x61, 0x3e, 0x62, 0x63, 0x3e, 0x62, 0x65,
    0x3e, 0x62, 0x69, 0x3e, 0x62, 0x6f, 0x3e, 0x62, 0x73, 0x3e, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table20_185_emit_[120] = {
    0x3e, 0x64, 0x30, 0x3e, 0x64, 0x31, 0x3e, 0x64, 0x32, 0x3e, 0x64, 0x61,
    0x3e, 0x64, 0x63, 0x3e, 0x64, 0x65, 0x3e, 0x64, 0x69, 0x3e, 0x64, 0x6f,
    0x3e, 0x64, 0x73, 0x3e, 0x64, 0x74, 0x3e, 0x66, 0x30, 0x3e, 0x66, 0x31,
    0x3e, 0x66, 0x32, 0x3e, 0x66, 0x61, 0x3e, 0x66, 0x63, 0x3e, 0x66, 0x65,
    0x3e, 0x66, 0x69, 0x3e, 0x66, 0x6f, 0x3e, 0x66, 0x73, 0x3e, 0x66, 0x74,
    0x3e, 0x67, 0x30, 0x3e, 0x67, 0x31, 0x3e, 0x67, 0x32, 0x3e, 0x67, 0x61,
    0x3e, 0x67, 0x63, 0x3e, 0x67, 0x65, 0x3e, 0x67, 0x69, 0x3e, 0x67, 0x6f,
    0x3e, 0x67, 0x73, 0x3e, 0x67, 0x74, 0x3e, 0x68, 0x30, 0x3e, 0x68, 0x31,
    0x3e, 0x68, 0x32, 0x3e, 0x68, 0x61, 0x3e, 0x68, 0x63, 0x3e, 0x68, 0x65,
    0x3e, 0x68, 0x69, 0x3e, 0x68, 0x6f, 0x3e, 0x68, 0x73, 0x3e, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table20_186_emit_[120] = {
    0x3e, 0x6c, 0x30, 0x3e, 0x6c, 0x31, 0x3e, 0x6c, 0x32, 0x3e, 0x6c, 0x61,
    0x3e, 0x6c, 0x63, 0x3e, 0x6c, 0x65, 0x3e, 0x6c, 0x69, 0x3e, 0x6c, 0x6f,
    0x3e, 0x6c, 0x73, 0x3e, 0x6c, 0x74, 0x3e, 0x6d, 0x30, 0x3e, 0x6d, 0x31,
    0x3e, 0x6d, 0x32, 0x3e, 0x6d, 0x61, 0x3e, 0x6d, 0x63, 0x3e, 0x6d, 0x65,
    0x3e, 0x6d, 0x69, 0x3e, 0x6d, 0x6f, 0x3e, 0x6d, 0x73, 0x3e, 0x6d, 0x74,
    0x3e, 0x6e, 0x30, 0x3e, 0x6e, 0x31, 0x3e, 0x6e, 0x32, 0x3e, 0x6e, 0x61,
    0x3e, 0x6e, 0x63, 0x3e, 0x6e, 0x65, 0x3e, 0x6e, 0x69, 0x3e, 0x6e, 0x6f,
    0x3e, 0x6e, 0x73, 0x3e, 0x6e, 0x74, 0x3e, 0x70, 0x30, 0x3e, 0x70, 0x31,
    0x3e, 0x70, 0x32, 0x3e, 0x70, 0x61, 0x3e, 0x70, 0x63, 0x3e, 0x70, 0x65,
    0x3e, 0x70, 0x69, 0x3e, 0x70, 0x6f, 0x3e, 0x70, 0x73, 0x3e, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table20_187_emit_[68] = {
    0x3e, 0x72, 0x30, 0x3e, 0x72, 0x31, 0x3e, 0x72, 0x32, 0x3e, 0x72, 0x61,
    0x3e, 0x72, 0x63, 0x3e, 0x72, 0x65, 0x3e, 0x72, 0x69, 0x3e, 0x72, 0x6f,
    0x3e, 0x72, 0x73, 0x3e, 0x72, 0x74, 0x3e, 0x75, 0x30, 0x3e, 0x75, 0x31,
    0x3e, 0x75, 0x32, 0x3e, 0x75, 0x61, 0x3e, 0x75, 0x63, 0x3e, 0x75, 0x65,
    0x3e, 0x75, 0x69, 0x3e, 0x75, 0x6f, 0x3e, 0x75, 0x73, 0x3e, 0x75, 0x74,
    0x3e, 0x3a, 0x3e, 0x42, 0x3e, 0x43, 0x3e, 0x44};
const uint8_t HuffDecoderCommon::table20_188_emit_[16] = {
    0x3e, 0x45, 0x3e, 0x46, 0x3e, 0x47, 0x3e, 0x48,
    0x3e, 0x49, 0x3e, 0x4a, 0x3e, 0x4b, 0x3e, 0x4c};
const uint8_t HuffDecoderCommon::table20_189_emit_[16] = {
    0x3e, 0x4d, 0x3e, 0x4e, 0x3e, 0x4f, 0x3e, 0x50,
    0x3e, 0x51, 0x3e, 0x52, 0x3e, 0x53, 0x3e, 0x54};
const uint8_t HuffDecoderCommon::table20_190_emit_[16] = {
    0x3e, 0x55, 0x3e, 0x56, 0x3e, 0x57, 0x3e, 0x59,
    0x3e, 0x6a, 0x3e, 0x6b, 0x3e, 0x71, 0x3e, 0x76};
const uint8_t HuffDecoderCommon::table20_191_emit_[36] = {
    0x3e, 0x77, 0x3e, 0x78, 0x3e, 0x79, 0x3e, 0x7a, 0x3e, 0x26, 0x3e, 0x2a,
    0x3e, 0x2c, 0x3e, 0x3b, 0x3e, 0x58, 0x3e, 0x5a, 0x3e, 0x21, 0x3e, 0x22,
    0x3e, 0x28, 0x3e, 0x29, 0x3e, 0x3f, 0x3e, 0x27, 0x3e, 0x2b, 0x3e, 0x7c};
const uint8_t HuffDecoderCommon::table20_192_emit_[120] = {
    0x00, 0x30, 0x30, 0x00, 0x30, 0x31, 0x00, 0x30, 0x32, 0x00, 0x30, 0x61,
    0x00, 0x30, 0x63, 0x00, 0x30, 0x65, 0x00, 0x30, 0x69, 0x00, 0x30, 0x6f,
    0x00, 0x30, 0x73, 0x00, 0x30, 0x74, 0x00, 0x31, 0x30, 0x00, 0x31, 0x31,
    0x00, 0x31, 0x32, 0x00, 0x31, 0x61, 0x00, 0x31, 0x63, 0x00, 0x31, 0x65,
    0x00, 0x31, 0x69, 0x00, 0x31, 0x6f, 0x00, 0x31, 0x73, 0x00, 0x31, 0x74,
    0x00, 0x32, 0x30, 0x00, 0x32, 0x31, 0x00, 0x32, 0x32, 0x00, 0x32, 0x61,
    0x00, 0x32, 0x63, 0x00, 0x32, 0x65, 0x00, 0x32, 0x69, 0x00, 0x32, 0x6f,
    0x00, 0x32, 0x73, 0x00, 0x32, 0x74, 0x00, 0x61, 0x30, 0x00, 0x61, 0x31,
    0x00, 0x61, 0x32, 0x00, 0x61, 0x61, 0x00, 0x61, 0x63, 0x00, 0x61, 0x65,
    0x00, 0x61, 0x69, 0x00, 0x61, 0x6f, 0x00, 0x61, 0x73, 0x00, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table20_193_emit_[120] = {
    0x00, 0x63, 0x30, 0x00, 0x63, 0x31, 0x00, 0x63, 0x32, 0x00, 0x63, 0x61,
    0x00, 0x63, 0x63, 0x00, 0x63, 0x65, 0x00, 0x63, 0x69, 0x00, 0x63, 0x6f,
    0x00, 0x63, 0x73, 0x00, 0x63, 0x74, 0x00, 0x65, 0x30, 0x00, 0x65, 0x31,
    0x00, 0x65, 0x32, 0x00, 0x65, 0x61, 0x00, 0x65, 0x63, 0x00, 0x65, 0x65,
    0x00, 0x65, 0x69, 0x00, 0x65, 0x6f, 0x00, 0x65, 0x73, 0x00, 0x65, 0x74,
    0x00, 0x69, 0x30, 0x00, 0x69, 0x31, 0x00, 0x69, 0x32, 0x00, 0x69, 0x61,
    0x00, 0x69, 0x63, 0x00, 0x69, 0x65, 0x00, 0x69, 0x69, 0x00, 0x69, 0x6f,
    0x00, 0x69, 0x73, 0x00, 0x69, 0x74, 0x00, 0x6f, 0x30, 0x00, 0x6f, 0x31,
    0x00, 0x6f, 0x32, 0x00, 0x6f, 0x61, 0x00, 0x6f, 0x63, 0x00, 0x6f, 0x65,
    0x00, 0x6f, 0x69, 0x00, 0x6f, 0x6f, 0x00, 0x6f, 0x73, 0x00, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table20_194_emit_[68] = {
    0x00, 0x73, 0x30, 0x00, 0x73, 0x31, 0x00, 0x73, 0x32, 0x00, 0x73, 0x61,
    0x00, 0x73, 0x63, 0x00, 0x73, 0x65, 0x00, 0x73, 0x69, 0x00, 0x73, 0x6f,
    0x00, 0x73, 0x73, 0x00, 0x73, 0x74, 0x00, 0x74, 0x30, 0x00, 0x74, 0x31,
    0x00, 0x74, 0x32, 0x00, 0x74, 0x61, 0x00, 0x74, 0x63, 0x00, 0x74, 0x65,
    0x00, 0x74, 0x69, 0x00, 0x74, 0x6f, 0x00, 0x74, 0x73, 0x00, 0x74, 0x74,
    0x00, 0x20, 0x00, 0x25, 0x00, 0x2d, 0x00, 0x2e};
const uint8_t HuffDecoderCommon::table20_195_emit_[16] = {
    0x00, 0x2f, 0x00, 0x33, 0x00, 0x34, 0x00, 0x35,
    0x00, 0x36, 0x00, 0x37, 0x00, 0x38, 0x00, 0x39};
const uint8_t HuffDecoderCommon::table20_196_emit_[16] = {
    0x00, 0x3d, 0x00, 0x41, 0x00, 0x5f, 0x00, 0x62,
    0x00, 0x64, 0x00, 0x66, 0x00, 0x67, 0x00, 0x68};
const uint8_t HuffDecoderCommon::table20_197_emit_[20] = {
    0x00, 0x6c, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x70, 0x00, 0x72,
    0x00, 0x75, 0x00, 0x3a, 0x00, 0x42, 0x00, 0x43, 0x00, 0x44};
const uint8_t HuffDecoderCommon::table20_198_emit_[32] = {
    0x00, 0x45, 0x00, 0x46, 0x00, 0x47, 0x00, 0x48, 0x00, 0x49, 0x00,
    0x4a, 0x00, 0x4b, 0x00, 0x4c, 0x00, 0x4d, 0x00, 0x4e, 0x00, 0x4f,
    0x00, 0x50, 0x00, 0x51, 0x00, 0x52, 0x00, 0x53, 0x00, 0x54};
const uint8_t HuffDecoderCommon::table20_199_emit_[46] = {
    0x00, 0x55, 0x00, 0x56, 0x00, 0x57, 0x00, 0x59, 0x00, 0x6a, 0x00, 0x6b,
    0x00, 0x71, 0x00, 0x76, 0x00, 0x77, 0x00, 0x78, 0x00, 0x79, 0x00, 0x7a,
    0x00, 0x26, 0x00, 0x2a, 0x00, 0x2c, 0x00, 0x3b, 0x00, 0x58, 0x00, 0x5a,
    0x00, 0x21, 0x00, 0x22, 0x00, 0x28, 0x00, 0x29, 0x00, 0x3f};
const uint8_t HuffDecoderCommon::table20_200_emit_[120] = {
    0x24, 0x30, 0x30, 0x24, 0x30, 0x31, 0x24, 0x30, 0x32, 0x24, 0x30, 0x61,
    0x24, 0x30, 0x63, 0x24, 0x30, 0x65, 0x24, 0x30, 0x69, 0x24, 0x30, 0x6f,
    0x24, 0x30, 0x73, 0x24, 0x30, 0x74, 0x24, 0x31, 0x30, 0x24, 0x31, 0x31,
    0x24, 0x31, 0x32, 0x24, 0x31, 0x61, 0x24, 0x31, 0x63, 0x24, 0x31, 0x65,
    0x24, 0x31, 0x69, 0x24, 0x31, 0x6f, 0x24, 0x31, 0x73, 0x24, 0x31, 0x74,
    0x24, 0x32, 0x30, 0x24, 0x32, 0x31, 0x24, 0x32, 0x32, 0x24, 0x32, 0x61,
    0x24, 0x32, 0x63, 0x24, 0x32, 0x65, 0x24, 0x32, 0x69, 0x24, 0x32, 0x6f,
    0x24, 0x32, 0x73, 0x24, 0x32, 0x74, 0x24, 0x61, 0x30, 0x24, 0x61, 0x31,
    0x24, 0x61, 0x32, 0x24, 0x61, 0x61, 0x24, 0x61, 0x63, 0x24, 0x61, 0x65,
    0x24, 0x61, 0x69, 0x24, 0x61, 0x6f, 0x24, 0x61, 0x73, 0x24, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table20_201_emit_[120] = {
    0x24, 0x63, 0x30, 0x24, 0x63, 0x31, 0x24, 0x63, 0x32, 0x24, 0x63, 0x61,
    0x24, 0x63, 0x63, 0x24, 0x63, 0x65, 0x24, 0x63, 0x69, 0x24, 0x63, 0x6f,
    0x24, 0x63, 0x73, 0x24, 0x63, 0x74, 0x24, 0x65, 0x30, 0x24, 0x65, 0x31,
    0x24, 0x65, 0x32, 0x24, 0x65, 0x61, 0x24, 0x65, 0x63, 0x24, 0x65, 0x65,
    0x24, 0x65, 0x69, 0x24, 0x65, 0x6f, 0x24, 0x65, 0x73, 0x24, 0x65, 0x74,
    0x24, 0x69, 0x30, 0x24, 0x69, 0x31, 0x24, 0x69, 0x32, 0x24, 0x69, 0x61,
    0x24, 0x69, 0x63, 0x24, 0x69, 0x65, 0x24, 0x69, 0x69, 0x24, 0x69, 0x6f,
    0x24, 0x69, 0x73, 0x24, 0x69, 0x74, 0x24, 0x6f, 0x30, 0x24, 0x6f, 0x31,
    0x24, 0x6f, 0x32, 0x24, 0x6f, 0x61, 0x24, 0x6f, 0x63, 0x24, 0x6f, 0x65,
    0x24, 0x6f, 0x69, 0x24, 0x6f, 0x6f, 0x24, 0x6f, 0x73, 0x24, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table20_202_emit_[68] = {
    0x24, 0x73, 0x30, 0x24, 0x73, 0x31, 0x24, 0x73, 0x32, 0x24, 0x73, 0x61,
    0x24, 0x73, 0x63, 0x24, 0x73, 0x65, 0x24, 0x73, 0x69, 0x24, 0x73, 0x6f,
    0x24, 0x73, 0x73, 0x24, 0x73, 0x74, 0x24, 0x74, 0x30, 0x24, 0x74, 0x31,
    0x24, 0x74, 0x32, 0x24, 0x74, 0x61, 0x24, 0x74, 0x63, 0x24, 0x74, 0x65,
    0x24, 0x74, 0x69, 0x24, 0x74, 0x6f, 0x24, 0x74, 0x73, 0x24, 0x74, 0x74,
    0x24, 0x20, 0x24, 0x25, 0x24, 0x2d, 0x24, 0x2e};
const uint8_t HuffDecoderCommon::table20_203_emit_[16] = {
    0x24, 0x2f, 0x24, 0x33, 0x24, 0x34, 0x24, 0x35,
    0x24, 0x36, 0x24, 0x37, 0x24, 0x38, 0x24, 0x39};
const uint8_t HuffDecoderCommon::table20_204_emit_[16] = {
    0x24, 0x3d, 0x24, 0x41, 0x24, 0x5f, 0x24, 0x62,
    0x24, 0x64, 0x24, 0x66, 0x24, 0x67, 0x24, 0x68};
const uint8_t HuffDecoderCommon::table20_205_emit_[20] = {
    0x24, 0x6c, 0x24, 0x6d, 0x24, 0x6e, 0x24, 0x70, 0x24, 0x72,
    0x24, 0x75, 0x24, 0x3a, 0x24, 0x42, 0x24, 0x43, 0x24, 0x44};
const uint8_t HuffDecoderCommon::table20_206_emit_[32] = {
    0x24, 0x45, 0x24, 0x46, 0x24, 0x47, 0x24, 0x48, 0x24, 0x49, 0x24,
    0x4a, 0x24, 0x4b, 0x24, 0x4c, 0x24, 0x4d, 0x24, 0x4e, 0x24, 0x4f,
    0x24, 0x50, 0x24, 0x51, 0x24, 0x52, 0x24, 0x53, 0x24, 0x54};
const uint8_t HuffDecoderCommon::table20_207_emit_[46] = {
    0x24, 0x55, 0x24, 0x56, 0x24, 0x57, 0x24, 0x59, 0x24, 0x6a, 0x24, 0x6b,
    0x24, 0x71, 0x24, 0x76, 0x24, 0x77, 0x24, 0x78, 0x24, 0x79, 0x24, 0x7a,
    0x24, 0x26, 0x24, 0x2a, 0x24, 0x2c, 0x24, 0x3b, 0x24, 0x58, 0x24, 0x5a,
    0x24, 0x21, 0x24, 0x22, 0x24, 0x28, 0x24, 0x29, 0x24, 0x3f};
const uint8_t HuffDecoderCommon::table20_208_emit_[120] = {
    0x40, 0x30, 0x30, 0x40, 0x30, 0x31, 0x40, 0x30, 0x32, 0x40, 0x30, 0x61,
    0x40, 0x30, 0x63, 0x40, 0x30, 0x65, 0x40, 0x30, 0x69, 0x40, 0x30, 0x6f,
    0x40, 0x30, 0x73, 0x40, 0x30, 0x74, 0x40, 0x31, 0x30, 0x40, 0x31, 0x31,
    0x40, 0x31, 0x32, 0x40, 0x31, 0x61, 0x40, 0x31, 0x63, 0x40, 0x31, 0x65,
    0x40, 0x31, 0x69, 0x40, 0x31, 0x6f, 0x40, 0x31, 0x73, 0x40, 0x31, 0x74,
    0x40, 0x32, 0x30, 0x40, 0x32, 0x31, 0x40, 0x32, 0x32, 0x40, 0x32, 0x61,
    0x40, 0x32, 0x63, 0x40, 0x32, 0x65, 0x40, 0x32, 0x69, 0x40, 0x32, 0x6f,
    0x40, 0x32, 0x73, 0x40, 0x32, 0x74, 0x40, 0x61, 0x30, 0x40, 0x61, 0x31,
    0x40, 0x61, 0x32, 0x40, 0x61, 0x61, 0x40, 0x61, 0x63, 0x40, 0x61, 0x65,
    0x40, 0x61, 0x69, 0x40, 0x61, 0x6f, 0x40, 0x61, 0x73, 0x40, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table20_209_emit_[120] = {
    0x40, 0x63, 0x30, 0x40, 0x63, 0x31, 0x40, 0x63, 0x32, 0x40, 0x63, 0x61,
    0x40, 0x63, 0x63, 0x40, 0x63, 0x65, 0x40, 0x63, 0x69, 0x40, 0x63, 0x6f,
    0x40, 0x63, 0x73, 0x40, 0x63, 0x74, 0x40, 0x65, 0x30, 0x40, 0x65, 0x31,
    0x40, 0x65, 0x32, 0x40, 0x65, 0x61, 0x40, 0x65, 0x63, 0x40, 0x65, 0x65,
    0x40, 0x65, 0x69, 0x40, 0x65, 0x6f, 0x40, 0x65, 0x73, 0x40, 0x65, 0x74,
    0x40, 0x69, 0x30, 0x40, 0x69, 0x31, 0x40, 0x69, 0x32, 0x40, 0x69, 0x61,
    0x40, 0x69, 0x63, 0x40, 0x69, 0x65, 0x40, 0x69, 0x69, 0x40, 0x69, 0x6f,
    0x40, 0x69, 0x73, 0x40, 0x69, 0x74, 0x40, 0x6f, 0x30, 0x40, 0x6f, 0x31,
    0x40, 0x6f, 0x32, 0x40, 0x6f, 0x61, 0x40, 0x6f, 0x63, 0x40, 0x6f, 0x65,
    0x40, 0x6f, 0x69, 0x40, 0x6f, 0x6f, 0x40, 0x6f, 0x73, 0x40, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table20_210_emit_[68] = {
    0x40, 0x73, 0x30, 0x40, 0x73, 0x31, 0x40, 0x73, 0x32, 0x40, 0x73, 0x61,
    0x40, 0x73, 0x63, 0x40, 0x73, 0x65, 0x40, 0x73, 0x69, 0x40, 0x73, 0x6f,
    0x40, 0x73, 0x73, 0x40, 0x73, 0x74, 0x40, 0x74, 0x30, 0x40, 0x74, 0x31,
    0x40, 0x74, 0x32, 0x40, 0x74, 0x61, 0x40, 0x74, 0x63, 0x40, 0x74, 0x65,
    0x40, 0x74, 0x69, 0x40, 0x74, 0x6f, 0x40, 0x74, 0x73, 0x40, 0x74, 0x74,
    0x40, 0x20, 0x40, 0x25, 0x40, 0x2d, 0x40, 0x2e};
const uint8_t HuffDecoderCommon::table20_211_emit_[16] = {
    0x40, 0x2f, 0x40, 0x33, 0x40, 0x34, 0x40, 0x35,
    0x40, 0x36, 0x40, 0x37, 0x40, 0x38, 0x40, 0x39};
const uint8_t HuffDecoderCommon::table20_212_emit_[16] = {
    0x40, 0x3d, 0x40, 0x41, 0x40, 0x5f, 0x40, 0x62,
    0x40, 0x64, 0x40, 0x66, 0x40, 0x67, 0x40, 0x68};
const uint8_t HuffDecoderCommon::table20_213_emit_[20] = {
    0x40, 0x6c, 0x40, 0x6d, 0x40, 0x6e, 0x40, 0x70, 0x40, 0x72,
    0x40, 0x75, 0x40, 0x3a, 0x40, 0x42, 0x40, 0x43, 0x40, 0x44};
const uint8_t HuffDecoderCommon::table20_214_emit_[32] = {
    0x40, 0x45, 0x40, 0x46, 0x40, 0x47, 0x40, 0x48, 0x40, 0x49, 0x40,
    0x4a, 0x40, 0x4b, 0x40, 0x4c, 0x40, 0x4d, 0x40, 0x4e, 0x40, 0x4f,
    0x40, 0x50, 0x40, 0x51, 0x40, 0x52, 0x40, 0x53, 0x40, 0x54};
const uint8_t HuffDecoderCommon::table20_215_emit_[46] = {
    0x40, 0x55, 0x40, 0x56, 0x40, 0x57, 0x40, 0x59, 0x40, 0x6a, 0x40, 0x6b,
    0x40, 0x71, 0x40, 0x76, 0x40, 0x77, 0x40, 0x78, 0x40, 0x79, 0x40, 0x7a,
    0x40, 0x26, 0x40, 0x2a, 0x40, 0x2c, 0x40, 0x3b, 0x40, 0x58, 0x40, 0x5a,
    0x40, 0x21, 0x40, 0x22, 0x40, 0x28, 0x40, 0x29, 0x40, 0x3f};
const uint8_t HuffDecoderCommon::table20_216_emit_[120] = {
    0x5b, 0x30, 0x30, 0x5b, 0x30, 0x31, 0x5b, 0x30, 0x32, 0x5b, 0x30, 0x61,
    0x5b, 0x30, 0x63, 0x5b, 0x30, 0x65, 0x5b, 0x30, 0x69, 0x5b, 0x30, 0x6f,
    0x5b, 0x30, 0x73, 0x5b, 0x30, 0x74, 0x5b, 0x31, 0x30, 0x5b, 0x31, 0x31,
    0x5b, 0x31, 0x32, 0x5b, 0x31, 0x61, 0x5b, 0x31, 0x63, 0x5b, 0x31, 0x65,
    0x5b, 0x31, 0x69, 0x5b, 0x31, 0x6f, 0x5b, 0x31, 0x73, 0x5b, 0x31, 0x74,
    0x5b, 0x32, 0x30, 0x5b, 0x32, 0x31, 0x5b, 0x32, 0x32, 0x5b, 0x32, 0x61,
    0x5b, 0x32, 0x63, 0x5b, 0x32, 0x65, 0x5b, 0x32, 0x69, 0x5b, 0x32, 0x6f,
    0x5b, 0x32, 0x73, 0x5b, 0x32, 0x74, 0x5b, 0x61, 0x30, 0x5b, 0x61, 0x31,
    0x5b, 0x61, 0x32, 0x5b, 0x61, 0x61, 0x5b, 0x61, 0x63, 0x5b, 0x61, 0x65,
    0x5b, 0x61, 0x69, 0x5b, 0x61, 0x6f, 0x5b, 0x61, 0x73, 0x5b, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table20_217_emit_[120] = {
    0x5b, 0x63, 0x30, 0x5b, 0x63, 0x31, 0x5b, 0x63, 0x32, 0x5b, 0x63, 0x61,
    0x5b, 0x63, 0x63, 0x5b, 0x63, 0x65, 0x5b, 0x63, 0x69, 0x5b, 0x63, 0x6f,
    0x5b, 0x63, 0x73, 0x5b, 0x63, 0x74, 0x5b, 0x65, 0x30, 0x5b, 0x65, 0x31,
    0x5b, 0x65, 0x32, 0x5b, 0x65, 0x61, 0x5b, 0x65, 0x63, 0x5b, 0x65, 0x65,
    0x5b, 0x65, 0x69, 0x5b, 0x65, 0x6f, 0x5b, 0x65, 0x73, 0x5b, 0x65, 0x74,
    0x5b, 0x69, 0x30, 0x5b, 0x69, 0x31, 0x5b, 0x69, 0x32, 0x5b, 0x69, 0x61,
    0x5b, 0x69, 0x63, 0x5b, 0x69, 0x65, 0x5b, 0x69, 0x69, 0x5b, 0x69, 0x6f,
    0x5b, 0x69, 0x73, 0x5b, 0x69, 0x74, 0x5b, 0x6f, 0x30, 0x5b, 0x6f, 0x31,
    0x5b, 0x6f, 0x32, 0x5b, 0x6f, 0x61, 0x5b, 0x6f, 0x63, 0x5b, 0x6f, 0x65,
    0x5b, 0x6f, 0x69, 0x5b, 0x6f, 0x6f, 0x5b, 0x6f, 0x73, 0x5b, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table20_218_emit_[68] = {
    0x5b, 0x73, 0x30, 0x5b, 0x73, 0x31, 0x5b, 0x73, 0x32, 0x5b, 0x73, 0x61,
    0x5b, 0x73, 0x63, 0x5b, 0x73, 0x65, 0x5b, 0x73, 0x69, 0x5b, 0x73, 0x6f,
    0x5b, 0x73, 0x73, 0x5b, 0x73, 0x74, 0x5b, 0x74, 0x30, 0x5b, 0x74, 0x31,
    0x5b, 0x74, 0x32, 0x5b, 0x74, 0x61, 0x5b, 0x74, 0x63, 0x5b, 0x74, 0x65,
    0x5b, 0x74, 0x69, 0x5b, 0x74, 0x6f, 0x5b, 0x74, 0x73, 0x5b, 0x74, 0x74,
    0x5b, 0x20, 0x5b, 0x25, 0x5b, 0x2d, 0x5b, 0x2e};
const uint8_t HuffDecoderCommon::table20_219_emit_[16] = {
    0x5b, 0x2f, 0x5b, 0x33, 0x5b, 0x34, 0x5b, 0x35,
    0x5b, 0x36, 0x5b, 0x37, 0x5b, 0x38, 0x5b, 0x39};
const uint8_t HuffDecoderCommon::table20_220_emit_[16] = {
    0x5b, 0x3d, 0x5b, 0x41, 0x5b, 0x5f, 0x5b, 0x62,
    0x5b, 0x64, 0x5b, 0x66, 0x5b, 0x67, 0x5b, 0x68};
const uint8_t HuffDecoderCommon::table20_221_emit_[20] = {
    0x5b, 0x6c, 0x5b, 0x6d, 0x5b, 0x6e, 0x5b, 0x70, 0x5b, 0x72,
    0x5b, 0x75, 0x5b, 0x3a, 0x5b, 0x42, 0x5b, 0x43, 0x5b, 0x44};
const uint8_t HuffDecoderCommon::table20_222_emit_[32] = {
    0x5b, 0x45, 0x5b, 0x46, 0x5b, 0x47, 0x5b, 0x48, 0x5b, 0x49, 0x5b,
    0x4a, 0x5b, 0x4b, 0x5b, 0x4c, 0x5b, 0x4d, 0x5b, 0x4e, 0x5b, 0x4f,
    0x5b, 0x50, 0x5b, 0x51, 0x5b, 0x52, 0x5b, 0x53, 0x5b, 0x54};
const uint8_t HuffDecoderCommon::table20_223_emit_[46] = {
    0x5b, 0x55, 0x5b, 0x56, 0x5b, 0x57, 0x5b, 0x59, 0x5b, 0x6a, 0x5b, 0x6b,
    0x5b, 0x71, 0x5b, 0x76, 0x5b, 0x77, 0x5b, 0x78, 0x5b, 0x79, 0x5b, 0x7a,
    0x5b, 0x26, 0x5b, 0x2a, 0x5b, 0x2c, 0x5b, 0x3b, 0x5b, 0x58, 0x5b, 0x5a,
    0x5b, 0x21, 0x5b, 0x22, 0x5b, 0x28, 0x5b, 0x29, 0x5b, 0x3f};
const uint8_t HuffDecoderCommon::table20_224_emit_[120] = {
    0x5d, 0x30, 0x30, 0x5d, 0x30, 0x31, 0x5d, 0x30, 0x32, 0x5d, 0x30, 0x61,
    0x5d, 0x30, 0x63, 0x5d, 0x30, 0x65, 0x5d, 0x30, 0x69, 0x5d, 0x30, 0x6f,
    0x5d, 0x30, 0x73, 0x5d, 0x30, 0x74, 0x5d, 0x31, 0x30, 0x5d, 0x31, 0x31,
    0x5d, 0x31, 0x32, 0x5d, 0x31, 0x61, 0x5d, 0x31, 0x63, 0x5d, 0x31, 0x65,
    0x5d, 0x31, 0x69, 0x5d, 0x31, 0x6f, 0x5d, 0x31, 0x73, 0x5d, 0x31, 0x74,
    0x5d, 0x32, 0x30, 0x5d, 0x32, 0x31, 0x5d, 0x32, 0x32, 0x5d, 0x32, 0x61,
    0x5d, 0x32, 0x63, 0x5d, 0x32, 0x65, 0x5d, 0x32, 0x69, 0x5d, 0x32, 0x6f,
    0x5d, 0x32, 0x73, 0x5d, 0x32, 0x74, 0x5d, 0x61, 0x30, 0x5d, 0x61, 0x31,
    0x5d, 0x61, 0x32, 0x5d, 0x61, 0x61, 0x5d, 0x61, 0x63, 0x5d, 0x61, 0x65,
    0x5d, 0x61, 0x69, 0x5d, 0x61, 0x6f, 0x5d, 0x61, 0x73, 0x5d, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table20_225_emit_[120] = {
    0x5d, 0x63, 0x30, 0x5d, 0x63, 0x31, 0x5d, 0x63, 0x32, 0x5d, 0x63, 0x61,
    0x5d, 0x63, 0x63, 0x5d, 0x63, 0x65, 0x5d, 0x63, 0x69, 0x5d, 0x63, 0x6f,
    0x5d, 0x63, 0x73, 0x5d, 0x63, 0x74, 0x5d, 0x65, 0x30, 0x5d, 0x65, 0x31,
    0x5d, 0x65, 0x32, 0x5d, 0x65, 0x61, 0x5d, 0x65, 0x63, 0x5d, 0x65, 0x65,
    0x5d, 0x65, 0x69, 0x5d, 0x65, 0x6f, 0x5d, 0x65, 0x73, 0x5d, 0x65, 0x74,
    0x5d, 0x69, 0x30, 0x5d, 0x69, 0x31, 0x5d, 0x69, 0x32, 0x5d, 0x69, 0x61,
    0x5d, 0x69, 0x63, 0x5d, 0x69, 0x65, 0x5d, 0x69, 0x69, 0x5d, 0x69, 0x6f,
    0x5d, 0x69, 0x73, 0x5d, 0x69, 0x74, 0x5d, 0x6f, 0x30, 0x5d, 0x6f, 0x31,
    0x5d, 0x6f, 0x32, 0x5d, 0x6f, 0x61, 0x5d, 0x6f, 0x63, 0x5d, 0x6f, 0x65,
    0x5d, 0x6f, 0x69, 0x5d, 0x6f, 0x6f, 0x5d, 0x6f, 0x73, 0x5d, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table20_226_emit_[68] = {
    0x5d, 0x73, 0x30, 0x5d, 0x73, 0x31, 0x5d, 0x73, 0x32, 0x5d, 0x73, 0x61,
    0x5d, 0x73, 0x63, 0x5d, 0x73, 0x65, 0x5d, 0x73, 0x69, 0x5d, 0x73, 0x6f,
    0x5d, 0x73, 0x73, 0x5d, 0x73, 0x74, 0x5d, 0x74, 0x30, 0x5d, 0x74, 0x31,
    0x5d, 0x74, 0x32, 0x5d, 0x74, 0x61, 0x5d, 0x74, 0x63, 0x5d, 0x74, 0x65,
    0x5d, 0x74, 0x69, 0x5d, 0x74, 0x6f, 0x5d, 0x74, 0x73, 0x5d, 0x74, 0x74,
    0x5d, 0x20, 0x5d, 0x25, 0x5d, 0x2d, 0x5d, 0x2e};
const uint8_t HuffDecoderCommon::table20_227_emit_[16] = {
    0x5d, 0x2f, 0x5d, 0x33, 0x5d, 0x34, 0x5d, 0x35,
    0x5d, 0x36, 0x5d, 0x37, 0x5d, 0x38, 0x5d, 0x39};
const uint8_t HuffDecoderCommon::table20_228_emit_[16] = {
    0x5d, 0x3d, 0x5d, 0x41, 0x5d, 0x5f, 0x5d, 0x62,
    0x5d, 0x64, 0x5d, 0x66, 0x5d, 0x67, 0x5d, 0x68};
const uint8_t HuffDecoderCommon::table20_229_emit_[20] = {
    0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70, 0x5d, 0x72,
    0x5d, 0x75, 0x5d, 0x3a, 0x5d, 0x42, 0x5d, 0x43, 0x5d, 0x44};
const uint8_t HuffDecoderCommon::table20_230_emit_[32] = {
    0x5d, 0x45, 0x5d, 0x46, 0x5d, 0x47, 0x5d, 0x48, 0x5d, 0x49, 0x5d,
    0x4a, 0x5d, 0x4b, 0x5d, 0x4c, 0x5d, 0x4d, 0x5d, 0x4e, 0x5d, 0x4f,
    0x5d, 0x50, 0x5d, 0x51, 0x5d, 0x52, 0x5d, 0x53, 0x5d, 0x54};
const uint8_t HuffDecoderCommon::table20_231_emit_[46] = {
    0x5d, 0x55, 0x5d, 0x56, 0x5d, 0x57, 0x5d, 0x59, 0x5d, 0x6a, 0x5d, 0x6b,
    0x5d, 0x71, 0x5d, 0x76, 0x5d, 0x77, 0x5d, 0x78, 0x5d, 0x79, 0x5d, 0x7a,
    0x5d, 0x26, 0x5d, 0x2a, 0x5d, 0x2c, 0x5d, 0x3b, 0x5d, 0x58, 0x5d, 0x5a,
    0x5d, 0x21, 0x5d, 0x22, 0x5d, 0x28, 0x5d, 0x29, 0x5d, 0x3f};
const uint8_t HuffDecoderCommon::table20_232_emit_[120] = {
    0x7e, 0x30, 0x30, 0x7e, 0x30, 0x31, 0x7e, 0x30, 0x32, 0x7e, 0x30, 0x61,
    0x7e, 0x30, 0x63, 0x7e, 0x30, 0x65, 0x7e, 0x30, 0x69, 0x7e, 0x30, 0x6f,
    0x7e, 0x30, 0x73, 0x7e, 0x30, 0x74, 0x7e, 0x31, 0x30, 0x7e, 0x31, 0x31,
    0x7e, 0x31, 0x32, 0x7e, 0x31, 0x61, 0x7e, 0x31, 0x63, 0x7e, 0x31, 0x65,
    0x7e, 0x31, 0x69, 0x7e, 0x31, 0x6f, 0x7e, 0x31, 0x73, 0x7e, 0x31, 0x74,
    0x7e, 0x32, 0x30, 0x7e, 0x32, 0x31, 0x7e, 0x32, 0x32, 0x7e, 0x32, 0x61,
    0x7e, 0x32, 0x63, 0x7e, 0x32, 0x65, 0x7e, 0x32, 0x69, 0x7e, 0x32, 0x6f,
    0x7e, 0x32, 0x73, 0x7e, 0x32, 0x74, 0x7e, 0x61, 0x30, 0x7e, 0x61, 0x31,
    0x7e, 0x61, 0x32, 0x7e, 0x61, 0x61, 0x7e, 0x61, 0x63, 0x7e, 0x61, 0x65,
    0x7e, 0x61, 0x69, 0x7e, 0x61, 0x6f, 0x7e, 0x61, 0x73, 0x7e, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table20_233_emit_[120] = {
    0x7e, 0x63, 0x30, 0x7e, 0x63, 0x31, 0x7e, 0x63, 0x32, 0x7e, 0x63, 0x61,
    0x7e, 0x63, 0x63, 0x7e, 0x63, 0x65, 0x7e, 0x63, 0x69, 0x7e, 0x63, 0x6f,
    0x7e, 0x63, 0x73, 0x7e, 0x63, 0x74, 0x7e, 0x65, 0x30, 0x7e, 0x65, 0x31,
    0x7e, 0x65, 0x32, 0x7e, 0x65, 0x61, 0x7e, 0x65, 0x63, 0x7e, 0x65, 0x65,
    0x7e, 0x65, 0x69, 0x7e, 0x65, 0x6f, 0x7e, 0x65, 0x73, 0x7e, 0x65, 0x74,
    0x7e, 0x69, 0x30, 0x7e, 0x69, 0x31, 0x7e, 0x69, 0x32, 0x7e, 0x69, 0x61,
    0x7e, 0x69, 0x63, 0x7e, 0x69, 0x65, 0x7e, 0x69, 0x69, 0x7e, 0x69, 0x6f,
    0x7e, 0x69, 0x73, 0x7e, 0x69, 0x74, 0x7e, 0x6f, 0x30, 0x7e, 0x6f, 0x31,
    0x7e, 0x6f, 0x32, 0x7e, 0x6f, 0x61, 0x7e, 0x6f, 0x63, 0x7e, 0x6f, 0x65,
    0x7e, 0x6f, 0x69, 0x7e, 0x6f, 0x6f, 0x7e, 0x6f, 0x73, 0x7e, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table20_234_emit_[68] = {
    0x7e, 0x73, 0x30, 0x7e, 0x73, 0x31, 0x7e, 0x73, 0x32, 0x7e, 0x73, 0x61,
    0x7e, 0x73, 0x63, 0x7e, 0x73, 0x65, 0x7e, 0x73, 0x69, 0x7e, 0x73, 0x6f,
    0x7e, 0x73, 0x73, 0x7e, 0x73, 0x74, 0x7e, 0x74, 0x30, 0x7e, 0x74, 0x31,
    0x7e, 0x74, 0x32, 0x7e, 0x74, 0x61, 0x7e, 0x74, 0x63, 0x7e, 0x74, 0x65,
    0x7e, 0x74, 0x69, 0x7e, 0x74, 0x6f, 0x7e, 0x74, 0x73, 0x7e, 0x74, 0x74,
    0x7e, 0x20, 0x7e, 0x25, 0x7e, 0x2d, 0x7e, 0x2e};
const uint8_t HuffDecoderCommon::table20_235_emit_[16] = {
    0x7e, 0x2f, 0x7e, 0x33, 0x7e, 0x34, 0x7e, 0x35,
    0x7e, 0x36, 0x7e, 0x37, 0x7e, 0x38, 0x7e, 0x39};
const uint8_t HuffDecoderCommon::table20_236_emit_[16] = {
    0x7e, 0x3d, 0x7e, 0x41, 0x7e, 0x5f, 0x7e, 0x62,
    0x7e, 0x64, 0x7e, 0x66, 0x7e, 0x67, 0x7e, 0x68};
const uint8_t HuffDecoderCommon::table20_237_emit_[20] = {
    0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70, 0x7e, 0x72,
    0x7e, 0x75, 0x7e, 0x3a, 0x7e, 0x42, 0x7e, 0x43, 0x7e, 0x44};
const uint8_t HuffDecoderCommon::table20_238_emit_[32] = {
    0x7e, 0x45, 0x7e, 0x46, 0x7e, 0x47, 0x7e, 0x48, 0x7e, 0x49, 0x7e,
    0x4a, 0x7e, 0x4b, 0x7e, 0x4c, 0x7e, 0x4d, 0x7e, 0x4e, 0x7e, 0x4f,
    0x7e, 0x50, 0x7e, 0x51, 0x7e, 0x52, 0x7e, 0x53, 0x7e, 0x54};
const uint8_t HuffDecoderCommon::table20_239_emit_[46] = {
    0x7e, 0x55, 0x7e, 0x56, 0x7e, 0x57, 0x7e, 0x59, 0x7e, 0x6a, 0x7e, 0x6b,
    0x7e, 0x71, 0x7e, 0x76, 0x7e, 0x77, 0x7e, 0x78, 0x7e, 0x79, 0x7e, 0x7a,
    0x7e, 0x26, 0x7e, 0x2a, 0x7e, 0x2c, 0x7e, 0x3b, 0x7e, 0x58, 0x7e, 0x5a,
    0x7e, 0x21, 0x7e, 0x22, 0x7e, 0x28, 0x7e, 0x29, 0x7e, 0x3f};
const uint8_t HuffDecoderCommon::table20_240_emit_[16] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61,
    0x5e, 0x63, 0x5e, 0x65, 0x5e, 0x69, 0x5e, 0x6f};
const uint8_t HuffDecoderCommon::table20_241_emit_[28] = {
    0x5e, 0x73, 0x5e, 0x74, 0x5e, 0x20, 0x5e, 0x25, 0x5e, 0x2d,
    0x5e, 0x2e, 0x5e, 0x2f, 0x5e, 0x33, 0x5e, 0x34, 0x5e, 0x35,
    0x5e, 0x36, 0x5e, 0x37, 0x5e, 0x38, 0x5e, 0x39};
const uint8_t HuffDecoderCommon::table20_242_emit_[36] = {
    0x5e, 0x3d, 0x5e, 0x41, 0x5e, 0x5f, 0x5e, 0x62, 0x5e, 0x64, 0x5e, 0x66,
    0x5e, 0x67, 0x5e, 0x68, 0x5e, 0x6c, 0x5e, 0x6d, 0x5e, 0x6e, 0x5e, 0x70,
    0x5e, 0x72, 0x5e, 0x75, 0x5e, 0x3a, 0x5e, 0x42, 0x5e, 0x43, 0x5e, 0x44};
const uint8_t HuffDecoderCommon::table20_243_emit_[68] = {
    0x5e, 0x45, 0x5e, 0x46, 0x5e, 0x47, 0x5e, 0x48, 0x5e, 0x49, 0x5e, 0x4a,
    0x5e, 0x4b, 0x5e, 0x4c, 0x5e, 0x4d, 0x5e, 0x4e, 0x5e, 0x4f, 0x5e, 0x50,
    0x5e, 0x51, 0x5e, 0x52, 0x5e, 0x53, 0x5e, 0x54, 0x5e, 0x55, 0x5e, 0x56,
    0x5e, 0x57, 0x5e, 0x59, 0x5e, 0x6a, 0x5e, 0x6b, 0x5e, 0x71, 0x5e, 0x76,
    0x5e, 0x77, 0x5e, 0x78, 0x5e, 0x79, 0x5e, 0x7a, 0x5e, 0x26, 0x5e, 0x2a,
    0x5e, 0x2c, 0x5e, 0x3b, 0x5e, 0x58, 0x5e, 0x5a};
const uint8_t HuffDecoderCommon::table20_244_emit_[16] = {
    0x7d, 0x30, 0x7d, 0x31, 0x7d, 0x32, 0x7d, 0x61,
    0x7d, 0x63, 0x7d, 0x65, 0x7d, 0x69, 0x7d, 0x6f};
const uint8_t HuffDecoderCommon::table20_245_emit_[28] = {
    0x7d, 0x73, 0x7d, 0x74, 0x7d, 0x20, 0x7d, 0x25, 0x7d, 0x2d,
    0x7d, 0x2e, 0x7d, 0x2f, 0x7d, 0x33, 0x7d, 0x34, 0x7d, 0x35,
    0x7d, 0x36, 0x7d, 0x37, 0x7d, 0x38, 0x7d, 0x39};
const uint8_t HuffDecoderCommon::table20_246_emit_[36] = {
    0x7d, 0x3d, 0x7d, 0x41, 0x7d, 0x5f, 0x7d, 0x62, 0x7d, 0x64, 0x7d, 0x66,
    0x7d, 0x67, 0x7d, 0x68, 0x7d, 0x6c, 0x7d, 0x6d, 0x7d, 0x6e, 0x7d, 0x70,
    0x7d, 0x72, 0x7d, 0x75, 0x7d, 0x3a, 0x7d, 0x42, 0x7d, 0x43, 0x7d, 0x44};
const uint8_t HuffDecoderCommon::table20_247_emit_[68] = {
    0x7d, 0x45, 0x7d, 0x46, 0x7d, 0x47, 0x7d, 0x48, 0x7d, 0x49, 0x7d, 0x4a,
    0x7d, 0x4b, 0x7d, 0x4c, 0x7d, 0x4d, 0x7d, 0x4e, 0x7d, 0x4f, 0x7d, 0x50,
    0x7d, 0x51, 0x7d, 0x52, 0x7d, 0x53, 0x7d, 0x54, 0x7d, 0x55, 0x7d, 0x56,
    0x7d, 0x57, 0x7d, 0x59, 0x7d, 0x6a, 0x7d, 0x6b, 0x7d, 0x71, 0x7d, 0x76,
    0x7d, 0x77, 0x7d, 0x78, 0x7d, 0x79, 0x7d, 0x7a, 0x7d, 0x26, 0x7d, 0x2a,
    0x7d, 0x2c, 0x7d, 0x3b, 0x7d, 0x58, 0x7d, 0x5a};
const uint8_t HuffDecoderCommon::table20_248_emit_[44] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63, 0x3c,
    0x65, 0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74, 0x3c, 0x20,
    0x3c, 0x25, 0x3c, 0x2d, 0x3c, 0x2e, 0x3c, 0x2f, 0x3c, 0x33, 0x3c,
    0x34, 0x3c, 0x35, 0x3c, 0x36, 0x3c, 0x37, 0x3c, 0x38, 0x3c, 0x39};
const uint8_t HuffDecoderCommon::table20_249_emit_[104] = {
    0x3c, 0x3d, 0x3c, 0x41, 0x3c, 0x5f, 0x3c, 0x62, 0x3c, 0x64, 0x3c, 0x66,
    0x3c, 0x67, 0x3c, 0x68, 0x3c, 0x6c, 0x3c, 0x6d, 0x3c, 0x6e, 0x3c, 0x70,
    0x3c, 0x72, 0x3c, 0x75, 0x3c, 0x3a, 0x3c, 0x42, 0x3c, 0x43, 0x3c, 0x44,
    0x3c, 0x45, 0x3c, 0x46, 0x3c, 0x47, 0x3c, 0x48, 0x3c, 0x49, 0x3c, 0x4a,
    0x3c, 0x4b, 0x3c, 0x4c, 0x3c, 0x4d, 0x3c, 0x4e, 0x3c, 0x4f, 0x3c, 0x50,
    0x3c, 0x51, 0x3c, 0x52, 0x3c, 0x53, 0x3c, 0x54, 0x3c, 0x55, 0x3c, 0x56,
    0x3c, 0x57, 0x3c, 0x59, 0x3c, 0x6a, 0x3c, 0x6b, 0x3c, 0x71, 0x3c, 0x76,
    0x3c, 0x77, 0x3c, 0x78, 0x3c, 0x79, 0x3c, 0x7a, 0x3c, 0x26, 0x3c, 0x2a,
    0x3c, 0x2c, 0x3c, 0x3b, 0x3c, 0x58, 0x3c, 0x5a};
const uint8_t HuffDecoderCommon::table20_250_emit_[44] = {
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63, 0x60,
    0x65, 0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74, 0x60, 0x20,
    0x60, 0x25, 0x60, 0x2d, 0x60, 0x2e, 0x60, 0x2f, 0x60, 0x33, 0x60,
    0x34, 0x60, 0x35, 0x60, 0x36, 0x60, 0x37, 0x60, 0x38, 0x60, 0x39};
const uint8_t HuffDecoderCommon::table20_251_emit_[104] = {
    0x60, 0x3d, 0x60, 0x41, 0x60, 0x5f, 0x60, 0x62, 0x60, 0x64, 0x60, 0x66,
    0x60, 0x67, 0x60, 0x68, 0x60, 0x6c, 0x60, 0x6d, 0x60, 0x6e, 0x60, 0x70,
    0x60, 0x72, 0x60, 0x75, 0x60, 0x3a, 0x60, 0x42, 0x60, 0x43, 0x60, 0x44,
    0x60, 0x45, 0x60, 0x46, 0x60, 0x47, 0x60, 0x48, 0x60, 0x49, 0x60, 0x4a,
    0x60, 0x4b, 0x60, 0x4c, 0x60, 0x4d, 0x60, 0x4e, 0x60, 0x4f, 0x60, 0x50,
    0x60, 0x51, 0x60, 0x52, 0x60, 0x53, 0x60, 0x54, 0x60, 0x55, 0x60, 0x56,
    0x60, 0x57, 0x60, 0x59, 0x60, 0x6a, 0x60, 0x6b, 0x60, 0x71, 0x60, 0x76,
    0x60, 0x77, 0x60, 0x78, 0x60, 0x79, 0x60, 0x7a, 0x60, 0x26, 0x60, 0x2a,
    0x60, 0x2c, 0x60, 0x3b, 0x60, 0x58, 0x60, 0x5a};
const uint8_t HuffDecoderCommon::table20_252_emit_[44] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b,
    0x65, 0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x7b, 0x20,
    0x7b, 0x25, 0x7b, 0x2d, 0x7b, 0x2e, 0x7b, 0x2f, 0x7b, 0x33, 0x7b,
    0x34, 0x7b, 0x35, 0x7b, 0x36, 0x7b, 0x37, 0x7b, 0x38, 0x7b, 0x39};
const uint8_t HuffDecoderCommon::table20_253_emit_[104] = {
    0x7b, 0x3d, 0x7b, 0x41, 0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64, 0x7b, 0x66,
    0x7b, 0x67, 0x7b, 0x68, 0x7b, 0x6c, 0x7b, 0x6d, 0x7b, 0x6e, 0x7b, 0x70,
    0x7b, 0x72, 0x7b, 0x75, 0x7b, 0x3a, 0x7b, 0x42, 0x7b, 0x43, 0x7b, 0x44,
    0x7b, 0x45, 0x7b, 0x46, 0x7b, 0x47, 0x7b, 0x48, 0x7b, 0x49, 0x7b, 0x4a,
    0x7b, 0x4b, 0x7b, 0x4c, 0x7b, 0x4d, 0x7b, 0x4e, 0x7b, 0x4f, 0x7b, 0x50,
    0x7b, 0x51, 0x7b, 0x52, 0x7b, 0x53, 0x7b, 0x54, 0x7b, 0x55, 0x7b, 0x56,
    0x7b, 0x57, 0x7b, 0x59, 0x7b, 0x6a, 0x7b, 0x6b, 0x7b, 0x71, 0x7b, 0x76,
    0x7b, 0x77, 0x7b, 0x78, 0x7b, 0x79, 0x7b, 0x7a, 0x7b, 0x26, 0x7b, 0x2a,
    0x7b, 0x2c, 0x7b, 0x3b, 0x7b, 0x58, 0x7b, 0x5a};
const uint8_t HuffDecoderCommon::table20_254_emit_[15] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8,
    0xc2, 0xe0, 0xe2, 0x99, 0xa1, 0xa7, 0xac};
const uint16_t HuffDecoderCommon::table20_254_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x001b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0023, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x002b,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0033, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x003b, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0043, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x004b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0053, 0x0000, 0x0000, 0x0000, 0x005b, 0x0000,
    0x0000, 0x0000, 0x0063, 0x0000, 0x0000, 0x0000, 0x006b, 0x0000, 0x0000,
    0x0000, 0x0073};
const uint8_t HuffDecoderCommon::table20_255_emit_[64] = {
    0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84,
    0x85, 0x86, 0x88, 0x92, 0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa,
    0xad, 0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4,
    0xe8, 0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f, 0x93,
    0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8, 0xae,
    0xaf, 0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef};
const uint16_t HuffDecoderCommon::table20_255_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0003, 0x0000, 0x0000, 0x0000, 0x000b, 0x0000,
    0x0000, 0x0000, 0x0013, 0x0000, 0x0000, 0x0000, 0x001b, 0x0000, 0x0000,
    0x0000, 0x0023, 0x0000, 0x0000, 0x0000, 0x002b, 0x0000, 0x0000, 0x0000,
    0x0033, 0x0000, 0x0000, 0x0000, 0x003b, 0x0000, 0x0000, 0x0000, 0x0043,
    0x0000, 0x004b, 0x0000, 0x0053, 0x0000, 0x005b, 0x0000, 0x0063, 0x0000,
    0x006b, 0x0000, 0x0073, 0x0000, 0x007b, 0x0000, 0x0083, 0x0000, 0x008b,
    0x0000, 0x0093, 0x0000, 0x009b, 0x0000, 0x00a3, 0x0000, 0x00ab, 0x0000,
    0x00b3, 0x0000, 0x00bb, 0x0000, 0x00c3, 0x0000, 0x00cb, 0x0000, 0x00d3,
    0x0000, 0x00db, 0x0000, 0x00e3, 0x0000, 0x00eb, 0x0000, 0x00f3, 0x0000,
    0x00fb, 0x0000, 0x0103, 0x0000, 0x010b, 0x0000, 0x0113, 0x011b, 0x0123,
    0x012b, 0x0133, 0x013b, 0x0143, 0x014b, 0x0153, 0x015b, 0x0163, 0x016b,
    0x0173, 0x017b, 0x0183, 0x018b, 0x0193, 0x019b, 0x01a3, 0x01ab, 0x01b3,
    0x01bb, 0x01c3, 0x01cb, 0x01d3, 0x01db, 0x01e3, 0x01eb, 0x01f3, 0x01fb,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0004};
const uint8_t* const HuffDecoderCommon::table20_emit_[256] = {
    table20_0_emit_,   table20_1_emit_,   table20_2_emit_,   table20_3_emit_,
    table20_4_emit_,   table20_5_emit_,   table20_6_emit_,   table20_7_emit_,
    table20_8_emit_,   table20_9_emit_,   table20_10_emit_,  table20_11_emit_,
    table20_12_emit_,  table20_13_emit_,  table20_14_emit_,  table20_15_emit_,
    table20_16_emit_,  table20_17_emit_,  table20_18_emit_,  table20_19_emit_,
    table20_20_emit_,  table20_21_emit_,  table20_22_emit_,  table20_23_emit_,
    table20_24_emit_,  table20_25_emit_,  table20_26_emit_,  table20_27_emit_,
    table20_28_emit_,  table20_29_emit_,  table20_30_emit_,  table20_31_emit_,
    table20_32_emit_,  table20_33_emit_,  table20_34_emit_,  table20_35_emit_,
    table20_36_emit_,  table20_37_emit_,  table20_38_emit_,  table20_39_emit_,
    table20_40_emit_,  table20_41_emit_,  table20_42_emit_,  table20_43_emit_,
    table20_44_emit_,  table20_45_emit_,  table20_46_emit_,  table20_47_emit_,
    table20_48_emit_,  table20_49_emit_,  table20_50_emit_,  table20_51_emit_,
    table20_52_emit_,  table20_53_emit_,  table20_54_emit_,  table20_55_emit_,
    table20_56_emit_,  table20_57_emit_,  table20_58_emit_,  table20_59_emit_,
    table20_60_emit_,  table20_61_emit_,  table20_62_emit_,  table20_63_emit_,
    table20_64_emit_,  table20_65_emit_,  table20_66_emit_,  table20_67_emit_,
    table20_68_emit_,  table20_69_emit_,  table20_70_emit_,  table20_71_emit_,
    table20_72_emit_,  table20_73_emit_,  table20_74_emit_,  table20_75_emit_,
    table20_76_emit_,  table20_77_emit_,  table20_78_emit_,  table20_79_emit_,
    table20_80_emit_,  table20_81_emit_,  table20_82_emit_,  table20_83_emit_,
    table20_84_emit_,  table20_85_emit_,  table20_86_emit_,  table20_87_emit_,
    table20_88_emit_,  table20_89_emit_,  table20_90_emit_,  table20_91_emit_,
    table20_92_emit_,  table20_93_emit_,  table20_94_emit_,  table20_95_emit_,
    table20_96_emit_,  table20_97_emit_,  table20_98_emit_,  table20_99_emit_,
    table20_100_emit_, table20_101_emit_, table20_102_emit_, table20_103_emit_,
    table20_104_emit_, table20_105_emit_, table20_106_emit_, table20_107_emit_,
    table20_108_emit_, table20_109_emit_, table20_110_emit_, table20_111_emit_,
    table20_112_emit_, table20_113_emit_, table20_114_emit_, table20_115_emit_,
    table20_116_emit_, table20_117_emit_, table20_118_emit_, table20_119_emit_,
    table20_120_emit_, table20_121_emit_, table20_122_emit_, table20_123_emit_,
    table20_124_emit_, table20_125_emit_, table20_126_emit_, table20_127_emit_,
    table20_128_emit_, table20_129_emit_, table20_130_emit_, table20_131_emit_,
    table20_132_emit_, table20_133_emit_, table20_134_emit_, table20_135_emit_,
    table20_136_emit_, table20_137_emit_, table20_138_emit_, table20_139_emit_,
    table20_140_emit_, table20_141_emit_, table20_142_emit_, table20_143_emit_,
    table20_144_emit_, table20_145_emit_, table20_146_emit_, table20_147_emit_,
    table20_148_emit_, table20_149_emit_, table20_150_emit_, table20_151_emit_,
    table20_152_emit_, table20_153_emit_, table20_154_emit_, table20_155_emit_,
    table20_156_emit_, table20_157_emit_, table20_158_emit_, table20_159_emit_,
    table20_160_emit_, table20_161_emit_, table20_162_emit_, table20_163_emit_,
    table20_164_emit_, table20_165_emit_, table20_166_emit_, table20_167_emit_,
    table20_168_emit_, table20_169_emit_, table20_170_emit_, table20_171_emit_,
    table20_172_emit_, table20_173_emit_, table20_174_emit_, table20_175_emit_,
    table20_176_emit_, table20_177_emit_, table20_178_emit_, table20_179_emit_,
    table20_180_emit_, table20_181_emit_, table20_182_emit_, table20_183_emit_,
    table20_184_emit_, table20_185_emit_, table20_186_emit_, table20_187_emit_,
    table20_188_emit_, table20_189_emit_, table20_190_emit_, table20_191_emit_,
    table20_192_emit_, table20_193_emit_, table20_194_emit_, table20_195_emit_,
    table20_196_emit_, table20_197_emit_, table20_198_emit_, table20_199_emit_,
    table20_200_emit_, table20_201_emit_, table20_202_emit_, table20_203_emit_,
    table20_204_emit_, table20_205_emit_, table20_206_emit_, table20_207_emit_,
    table20_208_emit_, table20_209_emit_, table20_210_emit_, table20_211_emit_,
    table20_212_emit_, table20_213_emit_, table20_214_emit_, table20_215_emit_,
    table20_216_emit_, table20_217_emit_, table20_218_emit_, table20_219_emit_,
    table20_220_emit_, table20_221_emit_, table20_222_emit_, table20_223_emit_,
    table20_224_emit_, table20_225_emit_, table20_226_emit_, table20_227_emit_,
    table20_228_emit_, table20_229_emit_, table20_230_emit_, table20_231_emit_,
    table20_232_emit_, table20_233_emit_, table20_234_emit_, table20_235_emit_,
    table20_236_emit_, table20_237_emit_, table20_238_emit_, table20_239_emit_,
    table20_240_emit_, table20_241_emit_, table20_242_emit_, table20_243_emit_,
    table20_244_emit_, table20_245_emit_, table20_246_emit_, table20_247_emit_,
    table20_248_emit_, table20_249_emit_, table20_250_emit_, table20_251_emit_,
    table20_252_emit_, table20_253_emit_, table20_254_emit_, table20_255_emit_,
};
const uint16_t* const HuffDecoderCommon::table20_ops_[256] = {
    table20_0_ops_,   table20_1_ops_,   table20_0_ops_,   table20_1_ops_,
    table20_0_ops_,   table20_1_ops_,   table20_0_ops_,   table20_1_ops_,
    table20_0_ops_,   table20_1_ops_,   table20_0_ops_,   table20_1_ops_,
    table20_0_ops_,   table20_1_ops_,   table20_0_ops_,   table20_1_ops_,
    table20_0_ops_,   table20_1_ops_,   table20_0_ops_,   table20_1_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_23_ops_,  table20_63_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_23_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_23_ops_,  table19_23_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_23_ops_,  table20_95_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_23_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_23_ops_,  table19_23_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_23_ops_,  table20_127_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_0_ops_,   table19_0_ops_,
    table19_0_ops_,   table19_0_ops_,   table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_23_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_23_ops_,  table19_23_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_23_ops_,  table20_159_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_23_ops_,  table19_23_ops_,  table19_23_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_23_ops_,  table19_43_ops_,
    table19_44_ops_,  table19_44_ops_,  table19_44_ops_,  table19_79_ops_,
    table19_10_ops_,  table19_10_ops_,  table19_10_ops_,  table19_10_ops_,
    table19_10_ops_,  table19_23_ops_,  table19_23_ops_,  table19_23_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_23_ops_,  table19_43_ops_,
    table19_44_ops_,  table19_44_ops_,  table19_44_ops_,  table19_79_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_43_ops_,  table19_44_ops_,
    table19_44_ops_,  table19_85_ops_,  table19_86_ops_,  table19_87_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_43_ops_,  table19_44_ops_,
    table19_44_ops_,  table19_85_ops_,  table19_86_ops_,  table19_87_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_43_ops_,  table19_44_ops_,
    table19_44_ops_,  table19_85_ops_,  table19_86_ops_,  table19_87_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_43_ops_,  table19_44_ops_,
    table19_44_ops_,  table19_85_ops_,  table19_86_ops_,  table19_87_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_43_ops_,  table19_44_ops_,
    table19_44_ops_,  table19_85_ops_,  table19_86_ops_,  table19_87_ops_,
    table19_23_ops_,  table19_23_ops_,  table19_43_ops_,  table19_44_ops_,
    table19_44_ops_,  table19_85_ops_,  table19_86_ops_,  table19_87_ops_,
    table19_44_ops_,  table19_97_ops_,  table19_98_ops_,  table19_99_ops_,
    table19_44_ops_,  table19_97_ops_,  table19_98_ops_,  table19_99_ops_,
    table19_120_ops_, table19_121_ops_, table19_120_ops_, table19_121_ops_,
    table19_120_ops_, table19_121_ops_, table20_254_ops_, table20_255_ops_,
};
const uint8_t HuffDecoderCommon::table6_0_emit_[1] = {0x3f};
const uint16_t HuffDecoderCommon::table6_0_ops_[512] = {
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002};
const uint8_t HuffDecoderCommon::table6_32_emit_[1] = {0x27};
const uint16_t HuffDecoderCommon::table6_32_ops_[512] = {
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003};
const uint8_t HuffDecoderCommon::table6_48_emit_[1] = {0x2b};
const uint8_t HuffDecoderCommon::table6_64_emit_[1] = {0x7c};
const uint8_t HuffDecoderCommon::table6_80_emit_[1] = {0x23};
const uint16_t HuffDecoderCommon::table6_80_ops_[512] = {
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004};
const uint8_t HuffDecoderCommon::table6_88_emit_[1] = {0x3e};
const uint8_t HuffDecoderCommon::table6_96_emit_[1] = {0x00};
const uint16_t HuffDecoderCommon::table6_96_ops_[512] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005};
const uint8_t HuffDecoderCommon::table6_100_emit_[1] = {0x24};
const uint8_t HuffDecoderCommon::table6_104_emit_[1] = {0x40};
const uint8_t HuffDecoderCommon::table6_108_emit_[1] = {0x5b};
const uint8_t HuffDecoderCommon::table6_112_emit_[1] = {0x5d};
const uint8_t HuffDecoderCommon::table6_116_emit_[1] = {0x7e};
const uint8_t HuffDecoderCommon::table6_120_emit_[1] = {0x5e};
const uint16_t HuffDecoderCommon::table6_120_ops_[512] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006};
const uint8_t HuffDecoderCommon::table6_122_emit_[1] = {0x7d};
const uint8_t HuffDecoderCommon::table6_124_emit_[1] = {0x3c};
const uint16_t HuffDecoderCommon::table6_124_ops_[512] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007};
const uint8_t HuffDecoderCommon::table6_125_emit_[1] = {0x60};
const uint8_t HuffDecoderCommon::table6_126_emit_[1] = {0x7b};
const uint8_t HuffDecoderCommon::table6_127_emit_[91] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2, 0x99,
    0xa1, 0xa7, 0xac, 0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6,
    0x81, 0x84, 0x85, 0x86, 0x88, 0x92, 0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9,
    0xaa, 0xad, 0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4,
    0xe8, 0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f, 0x93, 0x95,
    0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8, 0xae, 0xaf, 0xb4,
    0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94,
    0x9f, 0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed};
const uint16_t HuffDecoderCommon::table6_127_ops_[512] = {
    0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b,
    0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b,
    0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x000b,
    0x000b, 0x000b, 0x000b, 0x000b, 0x000b, 0x020b, 0x020b, 0x020b, 0x020b,
    0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b,
    0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b,
    0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b,
    0x020b, 0x040b, 0x040b, 0x040b, 0x040b, 0x040b, 0x040b, 0x040b, 0x040b,
    0x040b, 0x040b, 0x040b, 0x040b, 0x040b, 0x040b, 0x040b, 0x040b, 0x040b,
    0x040b, 0x040b, 0x040b, 0x040b, 0x040b, 0x040b, 0x040b, 0x040b, 0x040b,
    0x040b, 0x040b, 0x040b, 0x040b, 0x040b, 0x040b, 0x060c, 0x060c, 0x060c,
    0x060c, 0x060c, 0x060c, 0x060c, 0x060c, 0x060c, 0x060c, 0x060c, 0x060c,
    0x060c, 0x060c, 0x060c, 0x060c, 0x080c, 0x080c, 0x080c, 0x080c, 0x080c,
    0x080c, 0x080c, 0x080c, 0x080c, 0x080c, 0x080c, 0x080c, 0x080c, 0x080c,
    0x080c, 0x080c, 0x0a0c, 0x0a0c, 0x0a0c, 0x0a0c, 0x0a0c, 0x0a0c, 0x0a0c,
    0x0a0c, 0x0a0c, 0x0a0c, 0x0a0c, 0x0a0c, 0x0a0c, 0x0a0c, 0x0a0c, 0x0a0c,
    0x0c0c, 0x0c0c, 0x0c0c, 0x0c0c, 0x0c0c, 0x0c0c, 0x0c0c, 0x0c0c, 0x0c0c,
    0x0c0c, 0x0c0c, 0x0c0c, 0x0c0c, 0x0c0c, 0x0c0c, 0x0c0c, 0x0e0c, 0x0e0c,
    0x0e0c, 0x0e0c, 0x0e0c, 0x0e0c, 0x0e0c, 0x0e0c, 0x0e0c, 0x0e0c, 0x0e0c,
    0x0e0c, 0x0e0c, 0x0e0c, 0x0e0c, 0x0e0c, 0x100c, 0x100c, 0x100c, 0x100c,
    0x100c, 0x100c, 0x100c, 0x100c, 0x100c, 0x100c, 0x100c, 0x100c, 0x100c,
    0x100c, 0x100c, 0x100c, 0x120c, 0x120c, 0x120c, 0x120c, 0x120c, 0x120c,
    0x120c, 0x120c, 0x120c, 0x120c, 0x120c, 0x120c, 0x120c, 0x120c, 0x120c,
    0x120c, 0x140c, 0x140c, 0x140c, 0x140c, 0x140c, 0x140c, 0x140c, 0x140c,
    0x140c, 0x140c, 0x140c, 0x140c, 0x140c, 0x140c, 0x140c, 0x140c, 0x160d,
    0x160d, 0x160d, 0x160d, 0x160d, 0x160d, 0x160d, 0x160d, 0x180d, 0x180d,
    0x180d, 0x180d, 0x180d, 0x180d, 0x180d, 0x180d, 0x1a0d, 0x1a0d, 0x1a0d,
    0x1a0d, 0x1a0d, 0x1a0d, 0x1a0d, 0x1a0d, 0x1c0d, 0x1c0d, 0x1c0d, 0x1c0d,
    0x1c0d, 0x1c0d, 0x1c0d, 0x1c0d, 0x1e0d, 0x1e0d, 0x1e0d, 0x1e0d, 0x1e0d,
    0x1e0d, 0x1e0d, 0x1e0d, 0x200d, 0x200d, 0x200d, 0x200d, 0x200d, 0x200d,
    0x200d, 0x200d, 0x220d, 0x220d, 0x220d, 0x220d, 0x220d, 0x220d, 0x220d,
    0x220d, 0x240d, 0x240d, 0x240d, 0x240d, 0x240d, 0x240d, 0x240d, 0x240d,
    0x260d, 0x260d, 0x260d, 0x260d, 0x260d, 0x260d, 0x260d, 0x260d, 0x280d,
    0x280d, 0x280d, 0x280d, 0x280d, 0x280d, 0x280d, 0x280d, 0x2a0d, 0x2a0d,
    0x2a0d, 0x2a0d, 0x2a0d, 0x2a0d, 0x2a0d, 0x2a0d, 0x2c0d, 0x2c0d, 0x2c0d,
    0x2c0d, 0x2c0d, 0x2c0d, 0x2c0d, 0x2c0d, 0x2e0d, 0x2e0d, 0x2e0d, 0x2e0d,
    0x2e0d, 0x2e0d, 0x2e0d, 0x2e0d, 0x300e, 0x300e, 0x300e, 0x300e, 0x320e,
    0x320e, 0x320e, 0x320e, 0x340e, 0x340e, 0x340e, 0x340e, 0x360e, 0x360e,
    0x360e, 0x360e, 0x380e, 0x380e, 0x380e, 0x380e, 0x3a0e, 0x3a0e, 0x3a0e,
    0x3a0e, 0x3c0e, 0x3c0e, 0x3c0e, 0x3c0e, 0x3e0e, 0x3e0e, 0x3e0e, 0x3e0e,
    0x400e, 0x400e, 0x400e, 0x400e, 0x420e, 0x420e, 0x420e, 0x420e, 0x440e,
    0x440e, 0x440e, 0x440e, 0x460e, 0x460e, 0x460e, 0x460e, 0x480e, 0x480e,
    0x480e, 0x480e, 0x4a0e, 0x4a0e, 0x4a0e, 0x4a0e, 0x4c0e, 0x4c0e, 0x4c0e,
    0x4c0e, 0x4e0e, 0x4e0e, 0x4e0e, 0x4e0e, 0x500e, 0x500e, 0x500e, 0x500e,
    0x520e, 0x520e, 0x520e, 0x520e, 0x540e, 0x540e, 0x540e, 0x540e, 0x560e,
    0x560e, 0x560e, 0x560e, 0x580e, 0x580e, 0x580e, 0x580e, 0x5a0e, 0x5a0e,
    0x5a0e, 0x5a0e, 0x5c0e, 0x5c0e, 0x5c0e, 0x5c0e, 0x5e0e, 0x5e0e, 0x5e0e,
    0x5e0e, 0x600e, 0x600e, 0x600e, 0x600e, 0x620e, 0x620e, 0x620e, 0x620e,
    0x640f, 0x640f, 0x660f, 0x660f, 0x680f, 0x680f, 0x6a0f, 0x6a0f, 0x6c0f,
    0x6c0f, 0x6e0f, 0x6e0f, 0x700f, 0x700f, 0x720f, 0x720f, 0x740f, 0x740f,
    0x760f, 0x760f, 0x780f, 0x780f, 0x7a0f, 0x7a0f, 0x7c0f, 0x7c0f, 0x7e0f,
    0x7e0f, 0x800f, 0x800f, 0x820f, 0x820f, 0x840f, 0x840f, 0x860f, 0x860f,
    0x880f, 0x880f, 0x8a0f, 0x8a0f, 0x8c0f, 0x8c0f, 0x8e0f, 0x8e0f, 0x900f,
    0x900f, 0x920f, 0x920f, 0x940f, 0x940f, 0x960f, 0x960f, 0x980f, 0x980f,
    0x9a0f, 0x9a0f, 0x9c0f, 0x9c0f, 0x9e10, 0xa010, 0xa210, 0xa410, 0xa610,
    0xa810, 0xaa10, 0xac10, 0xae10, 0xb010, 0xb210, 0xb410, 0x0030, 0x0050,
    0x0070, 0x0090, 0x00b0, 0x00d0, 0x00f0, 0x0110, 0x0130, 0x0150};
const uint8_t* const HuffDecoderCommon::table6_emit_[128] = {
    table6_0_emit_,   table6_0_emit_,   table6_0_emit_,   table6_0_emit_,
    table6_0_emit_,   table6_0_emit_,   table6_0_emit_,   table6_0_emit_,
    table6_0_emit_,   table6_0_emit_,   table6_0_emit_,   table6_0_emit_,
    table6_0_emit_,   table6_0_emit_,   table6_0_emit_,   table6_0_emit_,
    table6_0_emit_,   table6_0_emit_,   table6_0_emit_,   table6_0_emit_,
    table6_0_emit_,   table6_0_emit_,   table6_0_emit_,   table6_0_emit_,
    table6_0_emit_,   table6_0_emit_,   table6_0_emit_,   table6_0_emit_,
    table6_0_emit_,   table6_0_emit_,   table6_0_emit_,   table6_0_emit_,
    table6_32_emit_,  table6_32_emit_,  table6_32_emit_,  table6_32_emit_,
    table6_32_emit_,  table6_32_emit_,  table6_32_emit_,  table6_32_emit_,
    table6_32_emit_,  table6_32_emit_,  table6_32_emit_,  table6_32_emit_,
    table6_32_emit_,  table6_32_emit_,  table6_32_emit_,  table6_32_emit_,
    table6_48_emit_,  table6_48_emit_,  table6_48_emit_,  table6_48_emit_,
    table6_48_emit_,  table6_48_emit_,  table6_48_emit_,  table6_48_emit_,
    table6_48_emit_,  table6_48_emit_,  table6_48_emit_,  table6_48_emit_,
    table6_48_emit_,  table6_48_emit_,  table6_48_emit_,  table6_48_emit_,
    table6_64_emit_,  table6_64_emit_,  table6_64_emit_,  table6_64_emit_,
    table6_64_emit_,  table6_64_emit_,  table6_64_emit_,  table6_64_emit_,
    table6_64_emit_,  table6_64_emit_,  table6_64_emit_,  table6_64_emit_,
    table6_64_emit_,  table6_64_emit_,  table6_64_emit_,  table6_64_emit_,
    table6_80_emit_,  table6_80_emit_,  table6_80_emit_,  table6_80_emit_,
    table6_80_emit_,  table6_80_emit_,  table6_80_emit_,  table6_80_emit_,
    table6_88_emit_,  table6_88_emit_,  table6_88_emit_,  table6_88_emit_,
    table6_88_emit_,  table6_88_emit_,  table6_88_emit_,  table6_88_emit_,
    table6_96_emit_,  table6_96_emit_,  table6_96_emit_,  table6_96_emit_,
    table6_100_emit_, table6_100_emit_, table6_100_emit_, table6_100_emit_,
    table6_104_emit_, table6_104_emit_, table6_104_emit_, table6_104_emit_,
    table6_108_emit_, table6_108_emit_, table6_108_emit_, table6_108_emit_,
    table6_112_emit_, table6_112_emit_, table6_112_emit_, table6_112_emit_,
    table6_116_emit_, table6_116_emit_, table6_116_emit_, table6_116_emit_,
    table6_120_emit_, table6_120_emit_, table6_122_emit_, table6_122_emit_,
    table6_124_emit_, table6_125_emit_, table6_126_emit_, table6_127_emit_,
};
const uint16_t* const HuffDecoderCommon::table6_ops_[128] = {
    table6_0_ops_,   table6_0_ops_,   table6_0_ops_,   table6_0_ops_,
    table6_0_ops_,   table6_0_ops_,   table6_0_ops_,   table6_0_ops_,
    table6_0_ops_,   table6_0_ops_,   table6_0_ops_,   table6_0_ops_,
    table6_0_ops_,   table6_0_ops_,   table6_0_ops_,   table6_0_ops_,
    table6_0_ops_,   table6_0_ops_,   table6_0_ops_,   table6_0_ops_,
    table6_0_ops_,   table6_0_ops_,   table6_0_ops_,   table6_0_ops_,
    table6_0_ops_,   table6_0_ops_,   table6_0_ops_,   table6_0_ops_,
    table6_0_ops_,   table6_0_ops_,   table6_0_ops_,   table6_0_ops_,
    table6_32_ops_,  table6_32_ops_,  table6_32_ops_,  table6_32_ops_,
    table6_32_ops_,  table6_32_ops_,  table6_32_ops_,  table6_32_ops_,
    table6_32_ops_,  table6_32_ops_,  table6_32_ops_,  table6_32_ops_,
    table6_32_ops_,  table6_32_ops_,  table6_32_ops_,  table6_32_ops_,
    table6_32_ops_,  table6_32_ops_,  table6_32_ops_,  table6_32_ops_,
    table6_32_ops_,  table6_32_ops_,  table6_32_ops_,  table6_32_ops_,
    table6_32_ops_,  table6_32_ops_,  table6_32_ops_,  table6_32_ops_,
    table6_32_ops_,  table6_32_ops_,  table6_32_ops_,  table6_32_ops_,
    table6_32_ops_,  table6_32_ops_,  table6_32_ops_,  table6_32_ops_,
    table6_32_ops_,  table6_32_ops_,  table6_32_ops_,  table6_32_ops_,
    table6_32_ops_,  table6_32_ops_,  table6_32_ops_,  table6_32_ops_,
    table6_32_ops_,  table6_32_ops_,  table6_32_ops_,  table6_32_ops_,
    table6_80_ops_,  table6_80_ops_,  table6_80_ops_,  table6_80_ops_,
    table6_80_ops_,  table6_80_ops_,  table6_80_ops_,  table6_80_ops_,
    table6_80_ops_,  table6_80_ops_,  table6_80_ops_,  table6_80_ops_,
    table6_80_ops_,  table6_80_ops_,  table6_80_ops_,  table6_80_ops_,
    table6_96_ops_,  table6_96_ops_,  table6_96_ops_,  table6_96_ops_,
    table6_96_ops_,  table6_96_ops_,  table6_96_ops_,  table6_96_ops_,
    table6_96_ops_,  table6_96_ops_,  table6_96_ops_,  table6_96_ops_,
    table6_96_ops_,  table6_96_ops_,  table6_96_ops_,  table6_96_ops_,
    table6_96_ops_,  table6_96_ops_,  table6_96_ops_,  table6_96_ops_,
    table6_96_ops_,  table6_96_ops_,  table6_96_ops_,  table6_96_ops_,
    table6_120_ops_, table6_120_ops_, table6_120_ops_, table6_120_ops_,
    table6_124_ops_, table6_124_ops_, table6_124_ops_, table6_127_ops_,
};
const uint8_t HuffDecoderCommon::table26_0_emit_[8] = {0xd3, 0xd4, 0xd6, 0xdd,
                                                       0xde, 0xdf, 0xf1, 0xf4};
const uint8_t HuffDecoderCommon::table26_0_inner_[8] = {0x03, 0x07, 0x0b, 0x0f,
                                                        0x13, 0x17, 0x1b, 0x1f};
const uint8_t HuffDecoderCommon::table28_0_emit_[15] = {
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0x0b, 0x0c, 0x0e, 0x0f, 0x10, 0x11, 0x12};
const uint8_t HuffDecoderCommon::table28_0_inner_[15] = {
    0x03, 0x0c, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c,
    0x44, 0x4c, 0x54, 0x5c, 0x64, 0x6c, 0x74};
const uint8_t HuffDecoderCommon::table30_0_emit_[5] = {0xf2, 0xf3, 0xff, 0xcb,
                                                       0xcc};
const uint8_t HuffDecoderCommon::table30_0_inner_[5] = {0x02, 0x06, 0x0a, 0x0f,
                                                        0x13};
const uint8_t HuffDecoderCommon::table33_0_emit_[15] = {
    0x13, 0x14, 0x15, 0x17, 0x18, 0x19, 0x1a, 0x1b,
    0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint8_t HuffDecoderCommon::table33_0_inner_[16] = {
    0x00, 0x02, 0x04, 0x06, 0x08, 0x0a, 0x0c, 0x0e,
    0x10, 0x12, 0x14, 0x16, 0x18, 0x1a, 0x1c, 0x01};
const uint8_t HuffDecoderCommon::table34_0_ops_[32] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table32_0_emit_[8] = {0x13, 0x14, 0x15, 0x17,
                                                       0x18, 0x19, 0x1a, 0x1b};
const uint8_t HuffDecoderCommon::table32_0_ops_[32] = {
    0x04, 0x04, 0x04, 0x04, 0x14, 0x14, 0x14, 0x14, 0x24, 0x24, 0x24,
    0x24, 0x34, 0x34, 0x34, 0x34, 0x44, 0x44, 0x44, 0x44, 0x54, 0x54,
    0x54, 0x54, 0x64, 0x64, 0x64, 0x64, 0x74, 0x74, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table32_1_emit_[10] = {
    0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9, 0x0a, 0x0d, 0x16};
const uint8_t HuffDecoderCommon::table32_1_ops_[32] = {
    0x04, 0x04, 0x04, 0x04, 0x14, 0x14, 0x14, 0x14, 0x24, 0x24, 0x24,
    0x24, 0x34, 0x34, 0x34, 0x34, 0x44, 0x44, 0x44, 0x44, 0x54, 0x54,
    0x54, 0x54, 0x64, 0x64, 0x64, 0x64, 0x76, 0x86, 0x96, 0x0e};
const uint8_t* const HuffDecoderCommon::table32_emit_[2] = {
    table32_0_emit_,
    table32_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table32_ops_[2] = {
    table32_0_ops_,
    table32_1_ops_,
};
}  // namespace geometry_8_16_6
}  // namespace grpc_core
