// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#include "test/cpp/microbenchmarks/huffman_geometries/decode_huff_9_5_16.h"

#include <grpc/support/port_platform.h>
namespace grpc_core {
namespace geometry_9_5_16 {
const uint8_t HuffDecoderCommon::table2_0_emit_[10] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74};
const uint8_t HuffDecoderCommon::table2_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table3_0_emit_[36] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20, 0x25,
    0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3d, 0x41,
    0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70, 0x72, 0x75};
const uint8_t HuffDecoderCommon::table3_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x29, 0x2d,
    0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59,
    0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85,
    0x89, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table4_0_emit_[22] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20,
    0x25, 0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table4_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00,
    0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x25, 0x00, 0x29, 0x00, 0x2d,
    0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41, 0x00,
    0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table4_1_emit_[46] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70,
    0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a,
    0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
    0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table4_1_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49,
    0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75,
    0x79, 0x7d, 0x81, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1,
    0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table4_emit_[2] = {
    table4_0_emit_,
    table4_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table4_ops_[2] = {
    table4_0_ops_,
    table4_1_ops_,
};
const uint8_t HuffDecoderCommon::table5_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29,
    0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35,
    0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x41,
    0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4d,
    0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table5_1_emit_[52] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e,
    0x70, 0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78,
    0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint8_t HuffDecoderCommon::table5_1_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d,
    0x00, 0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55,
    0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x00, 0x65, 0x00, 0x69, 0x00, 0x6d,
    0x00, 0x71, 0x00, 0x75, 0x00, 0x79, 0x00, 0x7d, 0x00, 0x81, 0x00, 0x85,
    0x00, 0x89, 0x00, 0x8d, 0x00, 0x91, 0x00, 0x95, 0x00, 0x99, 0x00, 0x9d,
    0x00, 0xa1, 0x00, 0xa5, 0x00, 0xa9, 0x00, 0xad, 0x00, 0xb1, 0x00, 0xb5,
    0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table5_emit_[2] = {
    table4_0_emit_,
    table5_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table5_ops_[2] = {
    table5_0_ops_,
    table5_1_ops_,
};
const uint8_t HuffDecoderCommon::table1_0_emit_[2] = {0x30, 0x31};
const uint16_t HuffDecoderCommon::table1_0_ops_[32] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085,
    0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085};
const uint8_t HuffDecoderCommon::table1_1_emit_[2] = {0x32, 0x61};
const uint8_t HuffDecoderCommon::table1_2_emit_[2] = {0x63, 0x65};
const uint8_t HuffDecoderCommon::table1_3_emit_[2] = {0x69, 0x6f};
const uint8_t HuffDecoderCommon::table1_4_emit_[2] = {0x73, 0x74};
const uint8_t HuffDecoderCommon::table1_5_emit_[4] = {0x20, 0x25, 0x2d, 0x2e};
const uint16_t HuffDecoderCommon::table1_5_ops_[32] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086,
    0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
    0x0186, 0x0186, 0x0186, 0x0186, 0x0186, 0x0186, 0x0186, 0x0186};
const uint8_t HuffDecoderCommon::table1_6_emit_[4] = {0x2f, 0x33, 0x34, 0x35};
const uint8_t HuffDecoderCommon::table1_7_emit_[4] = {0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table1_8_emit_[4] = {0x3d, 0x41, 0x5f, 0x62};
const uint8_t HuffDecoderCommon::table1_9_emit_[4] = {0x64, 0x66, 0x67, 0x68};
const uint8_t HuffDecoderCommon::table1_10_emit_[4] = {0x6c, 0x6d, 0x6e, 0x70};
const uint8_t HuffDecoderCommon::table1_11_emit_[6] = {0x72, 0x75, 0x3a,
                                                       0x42, 0x43, 0x44};
const uint16_t HuffDecoderCommon::table1_11_ops_[32] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086,
    0x0107, 0x0107, 0x0107, 0x0107, 0x0187, 0x0187, 0x0187, 0x0187,
    0x0207, 0x0207, 0x0207, 0x0207, 0x0287, 0x0287, 0x0287, 0x0287};
const uint8_t HuffDecoderCommon::table1_12_emit_[8] = {0x45, 0x46, 0x47, 0x48,
                                                       0x49, 0x4a, 0x4b, 0x4c};
const uint16_t HuffDecoderCommon::table1_12_ops_[32] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0087, 0x0087, 0x0087, 0x0087,
    0x0107, 0x0107, 0x0107, 0x0107, 0x0187, 0x0187, 0x0187, 0x0187,
    0x0207, 0x0207, 0x0207, 0x0207, 0x0287, 0x0287, 0x0287, 0x0287,
    0x0307, 0x0307, 0x0307, 0x0307, 0x0387, 0x0387, 0x0387, 0x0387};
const uint8_t HuffDecoderCommon::table1_13_emit_[8] = {0x4d, 0x4e, 0x4f, 0x50,
                                                       0x51, 0x52, 0x53, 0x54};
const uint8_t HuffDecoderCommon::table1_14_emit_[8] = {0x55, 0x56, 0x57, 0x59,
                                                       0x6a, 0x6b, 0x71, 0x76};
const uint8_t HuffDecoderCommon::table1_15_emit_[10] = {
    0x77, 0x78, 0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint16_t HuffDecoderCommon::table1_15_ops_[32] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0087, 0x0087, 0x0087, 0x0087,
    0x0107, 0x0107, 0x0107, 0x0107, 0x0187, 0x0187, 0x0187, 0x0187,
    0x0208, 0x0208, 0x0288, 0x0288, 0x0308, 0x0308, 0x0388, 0x0388,
    0x0408, 0x0408, 0x0488, 0x0488, 0x0019, 0x0029, 0x0039, 0x0049};
const uint8_t* const HuffDecoderCommon::table1_emit_[16] = {
    table1_0_emit_,  table1_1_emit_,  table1_2_emit_,  table1_3_emit_,
    table1_4_emit_,  table1_5_emit_,  table1_6_emit_,  table1_7_emit_,
    table1_8_emit_,  table1_9_emit_,  table1_10_emit_, table1_11_emit_,
    table1_12_emit_, table1_13_emit_, table1_14_emit_, table1_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table1_ops_[16] = {
    table1_0_ops_,  table1_0_ops_,  table1_0_ops_,  table1_0_ops_,
    table1_0_ops_,  table1_5_ops_,  table1_5_ops_,  table1_5_ops_,
    table1_5_ops_,  table1_5_ops_,  table1_5_ops_,  table1_11_ops_,
    table1_12_ops_, table1_12_ops_, table1_12_ops_, table1_15_ops_,
};
const uint8_t HuffDecoderCommon::table12_0_inner_[5] = {0x00, 0x01, 0x05, 0x09,
                                                        0x02};
const uint8_t HuffDecoderCommon::table12_0_outer_[8] = {0, 1, 2, 3, 0, 0, 0, 4};
const uint8_t HuffDecoderCommon::table13_0_emit_[9] = {
    0x7c, 0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e};
const uint8_t HuffDecoderCommon::table13_0_inner_[11] = {
    0x00, 0x01, 0x05, 0x09, 0x0d, 0x11, 0x15, 0x19, 0x1d, 0x21, 0x02};
const uint8_t HuffDecoderCommon::table13_0_outer_[16] = {
    0, 0, 0, 1, 0, 2, 0, 3, 4, 5, 6, 7, 8, 9, 0, 10};
const uint8_t HuffDecoderCommon::table10_0_emit_[11] = {
    0x7c, 0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e, 0x5e, 0x7d};
const uint16_t HuffDecoderCommon::table10_0_inner_[13] = {
    0x0002, 0x0023, 0x0043, 0x0064, 0x0084, 0x00a4, 0x00c4,
    0x00e4, 0x0104, 0x0125, 0x0145, 0x000d, 0x0015};
const uint8_t HuffDecoderCommon::table10_0_outer_[32] = {
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2,  2,  2,
    3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 11, 12};
const uint8_t HuffDecoderCommon::table18_0_outer_[8] = {0, 0, 0, 1, 0, 0, 0, 2};
const uint8_t HuffDecoderCommon::table19_0_outer_[16] = {
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2};
const uint8_t HuffDecoderCommon::table20_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x09, 0x0d, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table21_0_emit_[31] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b,
    0x65, 0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x5c, 0xc3,
    0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2};
const uint8_t HuffDecoderCommon::table21_0_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01,
    0x52, 0x01, 0x56, 0x01, 0x5a, 0x5e, 0x62, 0x66, 0x6a, 0x6e, 0x72,
    0x76, 0x7a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03};
const uint8_t HuffDecoderCommon::table22_0_emit_[44] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b,
    0x65, 0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x7b, 0x20,
    0x7b, 0x25, 0x7b, 0x2d, 0x7b, 0x2e, 0x7b, 0x2f, 0x7b, 0x33, 0x7b,
    0x34, 0x7b, 0x35, 0x7b, 0x36, 0x7b, 0x37, 0x7b, 0x38, 0x7b, 0x39};
const uint8_t HuffDecoderCommon::table22_0_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0xa1, 0xa9};
const uint8_t HuffDecoderCommon::table22_1_emit_[28] = {
    0x7b, 0x3d, 0x7b, 0x41, 0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64,
    0x7b, 0x66, 0x7b, 0x67, 0x7b, 0x68, 0x7b, 0x6c, 0x7b, 0x6d,
    0x7b, 0x6e, 0x7b, 0x70, 0x7b, 0x72, 0x7b, 0x75};
const uint8_t HuffDecoderCommon::table22_1_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x61, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table22_2_emit_[15] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8,
    0xc2, 0xe0, 0xe2, 0x99, 0xa1, 0xa7, 0xac};
const uint8_t HuffDecoderCommon::table22_2_ops_[32] = {
    0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x0a, 0x00, 0x0e, 0x00, 0x12, 0x00, 0x16, 0x00, 0x1a, 0x00, 0x1e,
    0x00, 0x22, 0x00, 0x26, 0x00, 0x2a, 0x2e, 0x32, 0x36, 0x3a};
const uint8_t HuffDecoderCommon::table22_3_emit_[9] = {
    0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6};
const uint8_t HuffDecoderCommon::table22_3_ops_[32] = {
    0x02, 0x06, 0x0a, 0x0e, 0x12, 0x16, 0x1a, 0x1e, 0x22, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03};
const uint8_t* const HuffDecoderCommon::table22_emit_[4] = {
    table22_0_emit_,
    table22_1_emit_,
    table22_2_emit_,
    table22_3_emit_,
};
const uint8_t* const HuffDecoderCommon::table22_ops_[4] = {
    table22_0_ops_,
    table22_1_ops_,
    table22_2_ops_,
    table22_3_ops_,
};
const uint16_t HuffDecoderCommon::table23_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0051, 0x0000, 0x0059, 0x0000, 0x0061, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089,
    0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000, 0x00a9};
const uint8_t HuffDecoderCommon::table23_1_emit_[92] = {
    0x7b, 0x3d, 0x7b, 0x41, 0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64, 0x7b, 0x66,
    0x7b, 0x67, 0x7b, 0x68, 0x7b, 0x6c, 0x7b, 0x6d, 0x7b, 0x6e, 0x7b, 0x70,
    0x7b, 0x72, 0x7b, 0x75, 0x7b, 0x3a, 0x7b, 0x42, 0x7b, 0x43, 0x7b, 0x44,
    0x7b, 0x45, 0x7b, 0x46, 0x7b, 0x47, 0x7b, 0x48, 0x7b, 0x49, 0x7b, 0x4a,
    0x7b, 0x4b, 0x7b, 0x4c, 0x7b, 0x4d, 0x7b, 0x4e, 0x7b, 0x4f, 0x7b, 0x50,
    0x7b, 0x51, 0x7b, 0x52, 0x7b, 0x53, 0x7b, 0x54, 0x7b, 0x55, 0x7b, 0x56,
    0x7b, 0x57, 0x7b, 0x59, 0x7b, 0x6a, 0x7b, 0x6b, 0x7b, 0x71, 0x7b, 0x76,
    0x7b, 0x77, 0x7b, 0x78, 0x7b, 0x79, 0x7b, 0x7a};
const uint16_t HuffDecoderCommon::table23_1_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9,
    0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109,
    0x0111, 0x0119, 0x0121, 0x0129, 0x0131, 0x0139, 0x0141, 0x0149,
    0x0151, 0x0159, 0x0161, 0x0169, 0x0000, 0x0000, 0x0000, 0x0002};
const uint16_t HuffDecoderCommon::table23_2_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0016, 0x0000, 0x0000, 0x0000, 0x001a,
    0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0026, 0x0000, 0x0000, 0x0000, 0x002a,
    0x0000, 0x002e, 0x0000, 0x0032, 0x0000, 0x0036, 0x0000, 0x003a};
const uint8_t HuffDecoderCommon::table23_3_emit_[35] = {
    0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84, 0x85,
    0x86, 0x88, 0x92, 0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa, 0xad, 0xb2,
    0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8, 0xe9};
const uint16_t HuffDecoderCommon::table23_3_ops_[64] = {
    0x0000, 0x0002, 0x0000, 0x0006, 0x0000, 0x000a, 0x0000, 0x000e,
    0x0000, 0x0012, 0x0000, 0x0016, 0x0000, 0x001a, 0x0000, 0x001e,
    0x0000, 0x0022, 0x0026, 0x002a, 0x002e, 0x0032, 0x0036, 0x003a,
    0x003e, 0x0042, 0x0046, 0x004a, 0x004e, 0x0052, 0x0056, 0x005a,
    0x005e, 0x0062, 0x0066, 0x006a, 0x006e, 0x0072, 0x0076, 0x007a,
    0x007e, 0x0082, 0x0086, 0x008a, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table23_emit_[4] = {
    table22_0_emit_,
    table23_1_emit_,
    table22_2_emit_,
    table23_3_emit_,
};
const uint16_t* const HuffDecoderCommon::table23_ops_[4] = {
    table23_0_ops_,
    table23_1_ops_,
    table23_2_ops_,
    table23_3_ops_,
};
const uint16_t HuffDecoderCommon::table24_0_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0041,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0049, 0x0000,
    0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059, 0x0000, 0x0000,
    0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069, 0x0000, 0x0000, 0x0000,
    0x0071, 0x0000, 0x0000, 0x0000, 0x0079, 0x0000, 0x0000, 0x0000, 0x0081,
    0x0000, 0x0000, 0x0000, 0x0089, 0x0000, 0x0000, 0x0000, 0x0091, 0x0000,
    0x0000, 0x0000, 0x0099, 0x0000, 0x0000, 0x0000, 0x00a1, 0x0000, 0x0000,
    0x0000, 0x00a9};
const uint8_t HuffDecoderCommon::table24_1_emit_[104] = {
    0x7b, 0x3d, 0x7b, 0x41, 0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64, 0x7b, 0x66,
    0x7b, 0x67, 0x7b, 0x68, 0x7b, 0x6c, 0x7b, 0x6d, 0x7b, 0x6e, 0x7b, 0x70,
    0x7b, 0x72, 0x7b, 0x75, 0x7b, 0x3a, 0x7b, 0x42, 0x7b, 0x43, 0x7b, 0x44,
    0x7b, 0x45, 0x7b, 0x46, 0x7b, 0x47, 0x7b, 0x48, 0x7b, 0x49, 0x7b, 0x4a,
    0x7b, 0x4b, 0x7b, 0x4c, 0x7b, 0x4d, 0x7b, 0x4e, 0x7b, 0x4f, 0x7b, 0x50,
    0x7b, 0x51, 0x7b, 0x52, 0x7b, 0x53, 0x7b, 0x54, 0x7b, 0x55, 0x7b, 0x56,
    0x7b, 0x57, 0x7b, 0x59, 0x7b, 0x6a, 0x7b, 0x6b, 0x7b, 0x71, 0x7b, 0x76,
    0x7b, 0x77, 0x7b, 0x78, 0x7b, 0x79, 0x7b, 0x7a, 0x7b, 0x26, 0x7b, 0x2a,
    0x7b, 0x2c, 0x7b, 0x3b, 0x7b, 0x58, 0x7b, 0x5a};
const uint16_t HuffDecoderCommon::table24_1_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000,
    0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000,
    0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000,
    0x0031, 0x0000, 0x0000, 0x0000, 0x0039, 0x0000, 0x0000, 0x0000, 0x0041,
    0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0000, 0x0000, 0x0051, 0x0000,
    0x0000, 0x0000, 0x0059, 0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000,
    0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000,
    0x0089, 0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000, 0x00a9,
    0x0000, 0x00b1, 0x0000, 0x00b9, 0x0000, 0x00c1, 0x0000, 0x00c9, 0x0000,
    0x00d1, 0x0000, 0x00d9, 0x0000, 0x00e1, 0x0000, 0x00e9, 0x0000, 0x00f1,
    0x0000, 0x00f9, 0x0000, 0x0101, 0x0000, 0x0109, 0x0000, 0x0111, 0x0000,
    0x0119, 0x0000, 0x0121, 0x0000, 0x0129, 0x0000, 0x0131, 0x0000, 0x0139,
    0x0000, 0x0141, 0x0000, 0x0149, 0x0000, 0x0151, 0x0000, 0x0159, 0x0000,
    0x0161, 0x0000, 0x0169, 0x0171, 0x0179, 0x0181, 0x0189, 0x0191, 0x0199,
    0x0000, 0x0002};
const uint16_t HuffDecoderCommon::table24_2_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0012, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001a, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0026, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x002a, 0x0000, 0x0000, 0x0000, 0x002e, 0x0000,
    0x0000, 0x0000, 0x0032, 0x0000, 0x0000, 0x0000, 0x0036, 0x0000, 0x0000,
    0x0000, 0x003a};
const uint8_t HuffDecoderCommon::table24_3_emit_[64] = {
    0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84,
    0x85, 0x86, 0x88, 0x92, 0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa,
    0xad, 0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4,
    0xe8, 0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f, 0x93,
    0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8, 0xae,
    0xaf, 0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef};
const uint16_t HuffDecoderCommon::table24_3_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0006, 0x0000,
    0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x000e, 0x0000, 0x0000,
    0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0016, 0x0000, 0x0000, 0x0000,
    0x001a, 0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0026, 0x0000, 0x002a, 0x0000, 0x002e, 0x0000, 0x0032, 0x0000,
    0x0036, 0x0000, 0x003a, 0x0000, 0x003e, 0x0000, 0x0042, 0x0000, 0x0046,
    0x0000, 0x004a, 0x0000, 0x004e, 0x0000, 0x0052, 0x0000, 0x0056, 0x0000,
    0x005a, 0x0000, 0x005e, 0x0000, 0x0062, 0x0000, 0x0066, 0x0000, 0x006a,
    0x0000, 0x006e, 0x0000, 0x0072, 0x0000, 0x0076, 0x0000, 0x007a, 0x0000,
    0x007e, 0x0000, 0x0082, 0x0000, 0x0086, 0x0000, 0x008a, 0x008e, 0x0092,
    0x0096, 0x009a, 0x009e, 0x00a2, 0x00a6, 0x00aa, 0x00ae, 0x00b2, 0x00b6,
    0x00ba, 0x00be, 0x00c2, 0x00c6, 0x00ca, 0x00ce, 0x00d2, 0x00d6, 0x00da,
    0x00de, 0x00e2, 0x00e6, 0x00ea, 0x00ee, 0x00f2, 0x00f6, 0x00fa, 0x00fe,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table24_emit_[4] = {
    table22_0_emit_,
    table24_1_emit_,
    table22_2_emit_,
    table24_3_emit_,
};
const uint16_t* const HuffDecoderCommon::table24_ops_[4] = {
    table24_0_ops_,
    table24_1_ops_,
    table24_2_ops_,
    table24_3_ops_,
};
const uint8_t HuffDecoderCommon::table25_0_emit_[4] = {0x7b, 0x30, 0x7b, 0x31};
const uint8_t HuffDecoderCommon::table25_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09};
const uint8_t HuffDecoderCommon::table25_1_emit_[4] = {0x7b, 0x32, 0x7b, 0x61};
const uint8_t HuffDecoderCommon::table25_2_emit_[4] = {0x7b, 0x63, 0x7b, 0x65};
const uint8_t HuffDecoderCommon::table25_3_emit_[4] = {0x7b, 0x69, 0x7b, 0x6f};
const uint8_t HuffDecoderCommon::table25_4_emit_[4] = {0x7b, 0x73, 0x7b, 0x74};
const uint8_t HuffDecoderCommon::table25_5_emit_[8] = {0x7b, 0x20, 0x7b, 0x25,
                                                       0x7b, 0x2d, 0x7b, 0x2e};
const uint8_t HuffDecoderCommon::table25_5_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19};
const uint8_t HuffDecoderCommon::table25_6_emit_[8] = {0x7b, 0x2f, 0x7b, 0x33,
                                                       0x7b, 0x34, 0x7b, 0x35};
const uint8_t HuffDecoderCommon::table25_7_emit_[8] = {0x7b, 0x36, 0x7b, 0x37,
                                                       0x7b, 0x38, 0x7b, 0x39};
const uint8_t HuffDecoderCommon::table25_8_emit_[8] = {0x7b, 0x3d, 0x7b, 0x41,
                                                       0x7b, 0x5f, 0x7b, 0x62};
const uint8_t HuffDecoderCommon::table25_9_emit_[8] = {0x7b, 0x64, 0x7b, 0x66,
                                                       0x7b, 0x67, 0x7b, 0x68};
const uint8_t HuffDecoderCommon::table25_10_emit_[8] = {0x7b, 0x6c, 0x7b, 0x6d,
                                                        0x7b, 0x6e, 0x7b, 0x70};
const uint8_t HuffDecoderCommon::table25_11_emit_[12] = {
    0x7b, 0x72, 0x7b, 0x75, 0x7b, 0x3a, 0x7b, 0x42, 0x7b, 0x43, 0x7b, 0x44};
const uint8_t HuffDecoderCommon::table25_11_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x19, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x29};
const uint8_t HuffDecoderCommon::table25_12_emit_[16] = {
    0x7b, 0x45, 0x7b, 0x46, 0x7b, 0x47, 0x7b, 0x48,
    0x7b, 0x49, 0x7b, 0x4a, 0x7b, 0x4b, 0x7b, 0x4c};
const uint8_t HuffDecoderCommon::table25_12_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00,
    0x00, 0x29, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x39};
const uint8_t HuffDecoderCommon::table25_13_emit_[16] = {
    0x7b, 0x4d, 0x7b, 0x4e, 0x7b, 0x4f, 0x7b, 0x50,
    0x7b, 0x51, 0x7b, 0x52, 0x7b, 0x53, 0x7b, 0x54};
const uint8_t HuffDecoderCommon::table25_14_emit_[16] = {
    0x7b, 0x55, 0x7b, 0x56, 0x7b, 0x57, 0x7b, 0x59,
    0x7b, 0x6a, 0x7b, 0x6b, 0x7b, 0x71, 0x7b, 0x76};
const uint8_t HuffDecoderCommon::table25_15_emit_[20] = {
    0x7b, 0x77, 0x7b, 0x78, 0x7b, 0x79, 0x7b, 0x7a, 0x7b, 0x26,
    0x7b, 0x2a, 0x7b, 0x2c, 0x7b, 0x3b, 0x7b, 0x58, 0x7b, 0x5a};
const uint8_t HuffDecoderCommon::table25_15_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x21, 0x00, 0x29, 0x00, 0x31,
    0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table25_16_emit_[20] = {
    0x5c, 0x30, 0x5c, 0x31, 0x5c, 0x32, 0x5c, 0x61, 0x5c, 0x63,
    0x5c, 0x65, 0x5c, 0x69, 0x5c, 0x6f, 0x5c, 0x73, 0x5c, 0x74};
const uint8_t HuffDecoderCommon::table25_16_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table25_17_emit_[20] = {
    0xc3, 0x30, 0xc3, 0x31, 0xc3, 0x32, 0xc3, 0x61, 0xc3, 0x63,
    0xc3, 0x65, 0xc3, 0x69, 0xc3, 0x6f, 0xc3, 0x73, 0xc3, 0x74};
const uint8_t HuffDecoderCommon::table25_18_emit_[20] = {
    0xd0, 0x30, 0xd0, 0x31, 0xd0, 0x32, 0xd0, 0x61, 0xd0, 0x63,
    0xd0, 0x65, 0xd0, 0x69, 0xd0, 0x6f, 0xd0, 0x73, 0xd0, 0x74};
const uint8_t HuffDecoderCommon::table25_19_emit_[2] = {0x80, 0x82};
const uint8_t HuffDecoderCommon::table25_19_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06};
const uint8_t HuffDecoderCommon::table25_20_emit_[2] = {0x83, 0xa2};
const uint8_t HuffDecoderCommon::table25_21_emit_[2] = {0xb8, 0xc2};
const uint8_t HuffDecoderCommon::table25_22_emit_[2] = {0xe0, 0xe2};
const uint8_t HuffDecoderCommon::table25_23_emit_[4] = {0x99, 0xa1, 0xa7, 0xac};
const uint8_t HuffDecoderCommon::table25_23_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e};
const uint8_t HuffDecoderCommon::table25_24_emit_[4] = {0xb0, 0xb1, 0xb3, 0xd1};
const uint8_t HuffDecoderCommon::table25_25_emit_[4] = {0xd8, 0xd9, 0xe3, 0xe5};
const uint8_t HuffDecoderCommon::table25_26_emit_[7] = {0xe6, 0x81, 0x84, 0x85,
                                                        0x86, 0x88, 0x92};
const uint8_t HuffDecoderCommon::table25_26_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
    0x00, 0x12, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x1a};
const uint8_t HuffDecoderCommon::table25_27_emit_[8] = {0x9a, 0x9c, 0xa0, 0xa3,
                                                        0xa4, 0xa9, 0xaa, 0xad};
const uint8_t HuffDecoderCommon::table25_27_ops_[32] = {
    0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x0a, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00,
    0x00, 0x16, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x1e};
const uint8_t HuffDecoderCommon::table25_28_emit_[8] = {0xb2, 0xb5, 0xb9, 0xba,
                                                        0xbb, 0xbd, 0xbe, 0xc4};
const uint8_t HuffDecoderCommon::table25_29_emit_[12] = {
    0xc6, 0xe4, 0xe8, 0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f};
const uint8_t HuffDecoderCommon::table25_29_ops_[32] = {
    0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x0a, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x12, 0x00, 0x16, 0x00, 0x1a,
    0x00, 0x1e, 0x00, 0x22, 0x00, 0x26, 0x00, 0x2a, 0x00, 0x2e};
const uint8_t HuffDecoderCommon::table25_30_emit_[16] = {
    0x93, 0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e,
    0xa5, 0xa6, 0xa8, 0xae, 0xaf, 0xb4, 0xb6, 0xb7};
const uint8_t HuffDecoderCommon::table25_30_ops_[32] = {
    0x00, 0x02, 0x00, 0x06, 0x00, 0x0a, 0x00, 0x0e, 0x00, 0x12, 0x00,
    0x16, 0x00, 0x1a, 0x00, 0x1e, 0x00, 0x22, 0x00, 0x26, 0x00, 0x2a,
    0x00, 0x2e, 0x00, 0x32, 0x00, 0x36, 0x00, 0x3a, 0x00, 0x3e};
const uint8_t HuffDecoderCommon::table25_31_emit_[17] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91,
    0x94, 0x9f, 0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed};
const uint8_t HuffDecoderCommon::table25_31_ops_[32] = {
    0x00, 0x02, 0x00, 0x06, 0x00, 0x0a, 0x00, 0x0e, 0x00, 0x12, 0x16,
    0x1a, 0x1e, 0x22, 0x26, 0x2a, 0x2e, 0x32, 0x36, 0x3a, 0x3e, 0x42,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03};
const uint8_t* const HuffDecoderCommon::table25_emit_[32] = {
    table25_0_emit_,  table25_1_emit_,  table25_2_emit_,  table25_3_emit_,
    table25_4_emit_,  table25_5_emit_,  table25_6_emit_,  table25_7_emit_,
    table25_8_emit_,  table25_9_emit_,  table25_10_emit_, table25_11_emit_,
    table25_12_emit_, table25_13_emit_, table25_14_emit_, table25_15_emit_,
    table25_16_emit_, table25_17_emit_, table25_18_emit_, table25_19_emit_,
    table25_20_emit_, table25_21_emit_, table25_22_emit_, table25_23_emit_,
    table25_24_emit_, table25_25_emit_, table25_26_emit_, table25_27_emit_,
    table25_28_emit_, table25_29_emit_, table25_30_emit_, table25_31_emit_,
};
const uint8_t* const HuffDecoderCommon::table25_ops_[32] = {
    table25_0_ops_,  table25_0_ops_,  table25_0_ops_,  table25_0_ops_,
    table25_0_ops_,  table25_5_ops_,  table25_5_ops_,  table25_5_ops_,
    table25_5_ops_,  table25_5_ops_,  table25_5_ops_,  table25_11_ops_,
    table25_12_ops_, table25_12_ops_, table25_12_ops_, table25_15_ops_,
    table25_16_ops_, table25_16_ops_, table25_16_ops_, table25_19_ops_,
    table25_19_ops_, table25_19_ops_, table25_19_ops_, table25_23_ops_,
    table25_23_ops_, table25_23_ops_, table25_26_ops_, table25_27_ops_,
    table25_27_ops_, table25_29_ops_, table25_30_ops_, table25_31_ops_,
};
const uint8_t HuffDecoderCommon::table26_0_emit_[60] = {
    0x7b, 0x30, 0x30, 0x7b, 0x30, 0x31, 0x7b, 0x30, 0x32, 0x7b, 0x30, 0x61,
    0x7b, 0x30, 0x63, 0x7b, 0x30, 0x65, 0x7b, 0x30, 0x69, 0x7b, 0x30, 0x6f,
    0x7b, 0x30, 0x73, 0x7b, 0x30, 0x74, 0x7b, 0x31, 0x30, 0x7b, 0x31, 0x31,
    0x7b, 0x31, 0x32, 0x7b, 0x31, 0x61, 0x7b, 0x31, 0x63, 0x7b, 0x31, 0x65,
    0x7b, 0x31, 0x69, 0x7b, 0x31, 0x6f, 0x7b, 0x31, 0x73, 0x7b, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table26_0_ops_[64] = {
    0x0000, 0x0018, 0x0030, 0x0048, 0x0060, 0x0078, 0x0090, 0x00a8,
    0x00c0, 0x00d8, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x00f0, 0x0108, 0x0120, 0x0138, 0x0150, 0x0168, 0x0180, 0x0198,
    0x01b0, 0x01c8, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x00f2};
const uint8_t HuffDecoderCommon::table26_1_emit_[60] = {
    0x7b, 0x32, 0x30, 0x7b, 0x32, 0x31, 0x7b, 0x32, 0x32, 0x7b, 0x32, 0x61,
    0x7b, 0x32, 0x63, 0x7b, 0x32, 0x65, 0x7b, 0x32, 0x69, 0x7b, 0x32, 0x6f,
    0x7b, 0x32, 0x73, 0x7b, 0x32, 0x74, 0x7b, 0x61, 0x30, 0x7b, 0x61, 0x31,
    0x7b, 0x61, 0x32, 0x7b, 0x61, 0x61, 0x7b, 0x61, 0x63, 0x7b, 0x61, 0x65,
    0x7b, 0x61, 0x69, 0x7b, 0x61, 0x6f, 0x7b, 0x61, 0x73, 0x7b, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table26_2_emit_[60] = {
    0x7b, 0x63, 0x30, 0x7b, 0x63, 0x31, 0x7b, 0x63, 0x32, 0x7b, 0x63, 0x61,
    0x7b, 0x63, 0x63, 0x7b, 0x63, 0x65, 0x7b, 0x63, 0x69, 0x7b, 0x63, 0x6f,
    0x7b, 0x63, 0x73, 0x7b, 0x63, 0x74, 0x7b, 0x65, 0x30, 0x7b, 0x65, 0x31,
    0x7b, 0x65, 0x32, 0x7b, 0x65, 0x61, 0x7b, 0x65, 0x63, 0x7b, 0x65, 0x65,
    0x7b, 0x65, 0x69, 0x7b, 0x65, 0x6f, 0x7b, 0x65, 0x73, 0x7b, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table26_3_emit_[60] = {
    0x7b, 0x69, 0x30, 0x7b, 0x69, 0x31, 0x7b, 0x69, 0x32, 0x7b, 0x69, 0x61,
    0x7b, 0x69, 0x63, 0x7b, 0x69, 0x65, 0x7b, 0x69, 0x69, 0x7b, 0x69, 0x6f,
    0x7b, 0x69, 0x73, 0x7b, 0x69, 0x74, 0x7b, 0x6f, 0x30, 0x7b, 0x6f, 0x31,
    0x7b, 0x6f, 0x32, 0x7b, 0x6f, 0x61, 0x7b, 0x6f, 0x63, 0x7b, 0x6f, 0x65,
    0x7b, 0x6f, 0x69, 0x7b, 0x6f, 0x6f, 0x7b, 0x6f, 0x73, 0x7b, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table26_4_emit_[60] = {
    0x7b, 0x73, 0x30, 0x7b, 0x73, 0x31, 0x7b, 0x73, 0x32, 0x7b, 0x73, 0x61,
    0x7b, 0x73, 0x63, 0x7b, 0x73, 0x65, 0x7b, 0x73, 0x69, 0x7b, 0x73, 0x6f,
    0x7b, 0x73, 0x73, 0x7b, 0x73, 0x74, 0x7b, 0x74, 0x30, 0x7b, 0x74, 0x31,
    0x7b, 0x74, 0x32, 0x7b, 0x74, 0x61, 0x7b, 0x74, 0x63, 0x7b, 0x74, 0x65,
    0x7b, 0x74, 0x69, 0x7b, 0x74, 0x6f, 0x7b, 0x74, 0x73, 0x7b, 0x74, 0x74};
const uint16_t HuffDecoderCommon::table26_5_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032};
const uint16_t HuffDecoderCommon::table26_11_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0042,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0052};
const uint16_t HuffDecoderCommon::table26_12_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0042,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0062,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0072};
const uint8_t HuffDecoderCommon::table26_15_emit_[30] = {
    0x7b, 0x77, 0x7b, 0x78, 0x7b, 0x79, 0x7b, 0x7a, 0x7b, 0x26,
    0x7b, 0x2a, 0x7b, 0x2c, 0x7b, 0x3b, 0x7b, 0x58, 0x7b, 0x5a,
    0x7b, 0x21, 0x7b, 0x22, 0x7b, 0x28, 0x7b, 0x29, 0x7b, 0x3f};
const uint16_t HuffDecoderCommon::table26_15_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table26_16_emit_[72] = {
    0x5c, 0x30, 0x5c, 0x31, 0x5c, 0x32, 0x5c, 0x61, 0x5c, 0x63, 0x5c, 0x65,
    0x5c, 0x69, 0x5c, 0x6f, 0x5c, 0x73, 0x5c, 0x74, 0x5c, 0x20, 0x5c, 0x25,
    0x5c, 0x2d, 0x5c, 0x2e, 0x5c, 0x2f, 0x5c, 0x33, 0x5c, 0x34, 0x5c, 0x35,
    0x5c, 0x36, 0x5c, 0x37, 0x5c, 0x38, 0x5c, 0x39, 0x5c, 0x3d, 0x5c, 0x41,
    0x5c, 0x5f, 0x5c, 0x62, 0x5c, 0x64, 0x5c, 0x66, 0x5c, 0x67, 0x5c, 0x68,
    0x5c, 0x6c, 0x5c, 0x6d, 0x5c, 0x6e, 0x5c, 0x70, 0x5c, 0x72, 0x5c, 0x75};
const uint16_t HuffDecoderCommon::table26_16_ops_[64] = {
    0x0001, 0x0002, 0x0001, 0x0012, 0x0001, 0x0022, 0x0001, 0x0032,
    0x0001, 0x0042, 0x0001, 0x0052, 0x0001, 0x0062, 0x0001, 0x0072,
    0x0001, 0x0082, 0x0001, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2,
    0x00e2, 0x00f2, 0x0102, 0x0112, 0x0122, 0x0132, 0x0142, 0x0152,
    0x0162, 0x0172, 0x0182, 0x0192, 0x01a2, 0x01b2, 0x01c2, 0x01d2,
    0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222, 0x0232, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table26_17_emit_[72] = {
    0xc3, 0x30, 0xc3, 0x31, 0xc3, 0x32, 0xc3, 0x61, 0xc3, 0x63, 0xc3, 0x65,
    0xc3, 0x69, 0xc3, 0x6f, 0xc3, 0x73, 0xc3, 0x74, 0xc3, 0x20, 0xc3, 0x25,
    0xc3, 0x2d, 0xc3, 0x2e, 0xc3, 0x2f, 0xc3, 0x33, 0xc3, 0x34, 0xc3, 0x35,
    0xc3, 0x36, 0xc3, 0x37, 0xc3, 0x38, 0xc3, 0x39, 0xc3, 0x3d, 0xc3, 0x41,
    0xc3, 0x5f, 0xc3, 0x62, 0xc3, 0x64, 0xc3, 0x66, 0xc3, 0x67, 0xc3, 0x68,
    0xc3, 0x6c, 0xc3, 0x6d, 0xc3, 0x6e, 0xc3, 0x70, 0xc3, 0x72, 0xc3, 0x75};
const uint8_t HuffDecoderCommon::table26_18_emit_[72] = {
    0xd0, 0x30, 0xd0, 0x31, 0xd0, 0x32, 0xd0, 0x61, 0xd0, 0x63, 0xd0, 0x65,
    0xd0, 0x69, 0xd0, 0x6f, 0xd0, 0x73, 0xd0, 0x74, 0xd0, 0x20, 0xd0, 0x25,
    0xd0, 0x2d, 0xd0, 0x2e, 0xd0, 0x2f, 0xd0, 0x33, 0xd0, 0x34, 0xd0, 0x35,
    0xd0, 0x36, 0xd0, 0x37, 0xd0, 0x38, 0xd0, 0x39, 0xd0, 0x3d, 0xd0, 0x41,
    0xd0, 0x5f, 0xd0, 0x62, 0xd0, 0x64, 0xd0, 0x66, 0xd0, 0x67, 0xd0, 0x68,
    0xd0, 0x6c, 0xd0, 0x6d, 0xd0, 0x6e, 0xd0, 0x70, 0xd0, 0x72, 0xd0, 0x75};
const uint8_t HuffDecoderCommon::table26_19_emit_[40] = {
    0x80, 0x30, 0x80, 0x31, 0x80, 0x32, 0x80, 0x61, 0x80, 0x63,
    0x80, 0x65, 0x80, 0x69, 0x80, 0x6f, 0x80, 0x73, 0x80, 0x74,
    0x82, 0x30, 0x82, 0x31, 0x82, 0x32, 0x82, 0x61, 0x82, 0x63,
    0x82, 0x65, 0x82, 0x69, 0x82, 0x6f, 0x82, 0x73, 0x82, 0x74};
const uint16_t HuffDecoderCommon::table26_19_ops_[64] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102, 0x0112,
    0x0122, 0x0132, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x00a3};
const uint8_t HuffDecoderCommon::table26_20_emit_[40] = {
    0x83, 0x30, 0x83, 0x31, 0x83, 0x32, 0x83, 0x61, 0x83, 0x63,
    0x83, 0x65, 0x83, 0x69, 0x83, 0x6f, 0x83, 0x73, 0x83, 0x74,
    0xa2, 0x30, 0xa2, 0x31, 0xa2, 0x32, 0xa2, 0x61, 0xa2, 0x63,
    0xa2, 0x65, 0xa2, 0x69, 0xa2, 0x6f, 0xa2, 0x73, 0xa2, 0x74};
const uint8_t HuffDecoderCommon::table26_21_emit_[40] = {
    0xb8, 0x30, 0xb8, 0x31, 0xb8, 0x32, 0xb8, 0x61, 0xb8, 0x63,
    0xb8, 0x65, 0xb8, 0x69, 0xb8, 0x6f, 0xb8, 0x73, 0xb8, 0x74,
    0xc2, 0x30, 0xc2, 0x31, 0xc2, 0x32, 0xc2, 0x61, 0xc2, 0x63,
    0xc2, 0x65, 0xc2, 0x69, 0xc2, 0x6f, 0xc2, 0x73, 0xc2, 0x74};
const uint8_t HuffDecoderCommon::table26_22_emit_[40] = {
    0xe0, 0x30, 0xe0, 0x31, 0xe0, 0x32, 0xe0, 0x61, 0xe0, 0x63,
    0xe0, 0x65, 0xe0, 0x69, 0xe0, 0x6f, 0xe0, 0x73, 0xe0, 0x74,
    0xe2, 0x30, 0xe2, 0x31, 0xe2, 0x32, 0xe2, 0x61, 0xe2, 0x63,
    0xe2, 0x65, 0xe2, 0x69, 0xe2, 0x6f, 0xe2, 0x73, 0xe2, 0x74};
const uint16_t HuffDecoderCommon::table26_23_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0013,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x001b};
const uint16_t HuffDecoderCommon::table26_26_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0013,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x001b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0023,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x002b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0033};
const uint16_t HuffDecoderCommon::table26_27_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0013,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x001b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0023,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x002b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0033,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x003b};
const uint16_t HuffDecoderCommon::table26_29_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0013,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x001b,
    0x0001, 0x0001, 0x0001, 0x0023, 0x0001, 0x0001, 0x0001, 0x002b,
    0x0001, 0x0001, 0x0001, 0x0033, 0x0001, 0x0001, 0x0001, 0x003b,
    0x0001, 0x0001, 0x0001, 0x0043, 0x0001, 0x0001, 0x0001, 0x004b,
    0x0001, 0x0001, 0x0001, 0x0053, 0x0001, 0x0001, 0x0001, 0x005b};
const uint16_t HuffDecoderCommon::table26_30_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0003, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0013, 0x0001, 0x0001, 0x0001, 0x001b,
    0x0001, 0x0001, 0x0001, 0x0023, 0x0001, 0x0001, 0x0001, 0x002b,
    0x0001, 0x0001, 0x0001, 0x0033, 0x0001, 0x0001, 0x0001, 0x003b,
    0x0001, 0x0001, 0x0001, 0x0043, 0x0001, 0x0001, 0x0001, 0x004b,
    0x0001, 0x0001, 0x0001, 0x0053, 0x0001, 0x0001, 0x0001, 0x005b,
    0x0001, 0x0001, 0x0001, 0x0063, 0x0001, 0x0001, 0x0001, 0x006b,
    0x0001, 0x0001, 0x0001, 0x0073, 0x0001, 0x0001, 0x0001, 0x007b};
const uint8_t HuffDecoderCommon::table26_31_emit_[21] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f,
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb};
const uint16_t HuffDecoderCommon::table26_31_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0003, 0x0001, 0x0001, 0x0001, 0x000b,
    0x0001, 0x0001, 0x0001, 0x0013, 0x0001, 0x0001, 0x0001, 0x001b,
    0x0001, 0x0001, 0x0001, 0x0023, 0x0001, 0x002b, 0x0001, 0x0033,
    0x0001, 0x003b, 0x0001, 0x0043, 0x0001, 0x004b, 0x0001, 0x0053,
    0x0001, 0x005b, 0x0001, 0x0063, 0x0001, 0x006b, 0x0001, 0x0073,
    0x0001, 0x007b, 0x0001, 0x0083, 0x008b, 0x0093, 0x009b, 0x00a3,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0004};
const uint8_t* const HuffDecoderCommon::table26_emit_[32] = {
    table26_0_emit_,  table26_1_emit_,  table26_2_emit_,  table26_3_emit_,
    table26_4_emit_,  table25_5_emit_,  table25_6_emit_,  table25_7_emit_,
    table25_8_emit_,  table25_9_emit_,  table25_10_emit_, table25_11_emit_,
    table25_12_emit_, table25_13_emit_, table25_14_emit_, table26_15_emit_,
    table26_16_emit_, table26_17_emit_, table26_18_emit_, table26_19_emit_,
    table26_20_emit_, table26_21_emit_, table26_22_emit_, table25_23_emit_,
    table25_24_emit_, table25_25_emit_, table25_26_emit_, table25_27_emit_,
    table25_28_emit_, table25_29_emit_, table25_30_emit_, table26_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table26_ops_[32] = {
    table26_0_ops_,  table26_0_ops_,  table26_0_ops_,  table26_0_ops_,
    table26_0_ops_,  table26_5_ops_,  table26_5_ops_,  table26_5_ops_,
    table26_5_ops_,  table26_5_ops_,  table26_5_ops_,  table26_11_ops_,
    table26_12_ops_, table26_12_ops_, table26_12_ops_, table26_15_ops_,
    table26_16_ops_, table26_16_ops_, table26_16_ops_, table26_19_ops_,
    table26_19_ops_, table26_19_ops_, table26_19_ops_, table26_23_ops_,
    table26_23_ops_, table26_23_ops_, table26_26_ops_, table26_27_ops_,
    table26_27_ops_, table26_29_ops_, table26_30_ops_, table26_31_ops_,
};
const uint8_t HuffDecoderCommon::table27_0_emit_[108] = {
    0x7b, 0x30, 0x30, 0x7b, 0x30, 0x31, 0x7b, 0x30, 0x32, 0x7b, 0x30, 0x61,
    0x7b, 0x30, 0x63, 0x7b, 0x30, 0x65, 0x7b, 0x30, 0x69, 0x7b, 0x30, 0x6f,
    0x7b, 0x30, 0x73, 0x7b, 0x30, 0x74, 0x7b, 0x30, 0x20, 0x7b, 0x30, 0x25,
    0x7b, 0x30, 0x2d, 0x7b, 0x30, 0x2e, 0x7b, 0x30, 0x2f, 0x7b, 0x30, 0x33,
    0x7b, 0x30, 0x34, 0x7b, 0x30, 0x35, 0x7b, 0x30, 0x36, 0x7b, 0x30, 0x37,
    0x7b, 0x30, 0x38, 0x7b, 0x30, 0x39, 0x7b, 0x30, 0x3d, 0x7b, 0x30, 0x41,
    0x7b, 0x30, 0x5f, 0x7b, 0x30, 0x62, 0x7b, 0x30, 0x64, 0x7b, 0x30, 0x66,
    0x7b, 0x30, 0x67, 0x7b, 0x30, 0x68, 0x7b, 0x30, 0x6c, 0x7b, 0x30, 0x6d,
    0x7b, 0x30, 0x6e, 0x7b, 0x30, 0x70, 0x7b, 0x30, 0x72, 0x7b, 0x30, 0x75};
const uint16_t HuffDecoderCommon::table27_0_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0019, 0x0000, 0x0031, 0x0000, 0x0049,
    0x0000, 0x0061, 0x0000, 0x0079, 0x0000, 0x0091, 0x0000, 0x00a9,
    0x0000, 0x00c1, 0x0000, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139,
    0x0151, 0x0169, 0x0181, 0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9,
    0x0211, 0x0229, 0x0241, 0x0259, 0x0271, 0x0289, 0x02a1, 0x02b9,
    0x02d1, 0x02e9, 0x0301, 0x0319, 0x0331, 0x0349, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table27_1_emit_[108] = {
    0x7b, 0x31, 0x30, 0x7b, 0x31, 0x31, 0x7b, 0x31, 0x32, 0x7b, 0x31, 0x61,
    0x7b, 0x31, 0x63, 0x7b, 0x31, 0x65, 0x7b, 0x31, 0x69, 0x7b, 0x31, 0x6f,
    0x7b, 0x31, 0x73, 0x7b, 0x31, 0x74, 0x7b, 0x31, 0x20, 0x7b, 0x31, 0x25,
    0x7b, 0x31, 0x2d, 0x7b, 0x31, 0x2e, 0x7b, 0x31, 0x2f, 0x7b, 0x31, 0x33,
    0x7b, 0x31, 0x34, 0x7b, 0x31, 0x35, 0x7b, 0x31, 0x36, 0x7b, 0x31, 0x37,
    0x7b, 0x31, 0x38, 0x7b, 0x31, 0x39, 0x7b, 0x31, 0x3d, 0x7b, 0x31, 0x41,
    0x7b, 0x31, 0x5f, 0x7b, 0x31, 0x62, 0x7b, 0x31, 0x64, 0x7b, 0x31, 0x66,
    0x7b, 0x31, 0x67, 0x7b, 0x31, 0x68, 0x7b, 0x31, 0x6c, 0x7b, 0x31, 0x6d,
    0x7b, 0x31, 0x6e, 0x7b, 0x31, 0x70, 0x7b, 0x31, 0x72, 0x7b, 0x31, 0x75};
const uint8_t HuffDecoderCommon::table27_2_emit_[108] = {
    0x7b, 0x32, 0x30, 0x7b, 0x32, 0x31, 0x7b, 0x32, 0x32, 0x7b, 0x32, 0x61,
    0x7b, 0x32, 0x63, 0x7b, 0x32, 0x65, 0x7b, 0x32, 0x69, 0x7b, 0x32, 0x6f,
    0x7b, 0x32, 0x73, 0x7b, 0x32, 0x74, 0x7b, 0x32, 0x20, 0x7b, 0x32, 0x25,
    0x7b, 0x32, 0x2d, 0x7b, 0x32, 0x2e, 0x7b, 0x32, 0x2f, 0x7b, 0x32, 0x33,
    0x7b, 0x32, 0x34, 0x7b, 0x32, 0x35, 0x7b, 0x32, 0x36, 0x7b, 0x32, 0x37,
    0x7b, 0x32, 0x38, 0x7b, 0x32, 0x39, 0x7b, 0x32, 0x3d, 0x7b, 0x32, 0x41,
    0x7b, 0x32, 0x5f, 0x7b, 0x32, 0x62, 0x7b, 0x32, 0x64, 0x7b, 0x32, 0x66,
    0x7b, 0x32, 0x67, 0x7b, 0x32, 0x68, 0x7b, 0x32, 0x6c, 0x7b, 0x32, 0x6d,
    0x7b, 0x32, 0x6e, 0x7b, 0x32, 0x70, 0x7b, 0x32, 0x72, 0x7b, 0x32, 0x75};
const uint8_t HuffDecoderCommon::table27_3_emit_[108] = {
    0x7b, 0x61, 0x30, 0x7b, 0x61, 0x31, 0x7b, 0x61, 0x32, 0x7b, 0x61, 0x61,
    0x7b, 0x61, 0x63, 0x7b, 0x61, 0x65, 0x7b, 0x61, 0x69, 0x7b, 0x61, 0x6f,
    0x7b, 0x61, 0x73, 0x7b, 0x61, 0x74, 0x7b, 0x61, 0x20, 0x7b, 0x61, 0x25,
    0x7b, 0x61, 0x2d, 0x7b, 0x61, 0x2e, 0x7b, 0x61, 0x2f, 0x7b, 0x61, 0x33,
    0x7b, 0x61, 0x34, 0x7b, 0x61, 0x35, 0x7b, 0x61, 0x36, 0x7b, 0x61, 0x37,
    0x7b, 0x61, 0x38, 0x7b, 0x61, 0x39, 0x7b, 0x61, 0x3d, 0x7b, 0x61, 0x41,
    0x7b, 0x61, 0x5f, 0x7b, 0x61, 0x62, 0x7b, 0x61, 0x64, 0x7b, 0x61, 0x66,
    0x7b, 0x61, 0x67, 0x7b, 0x61, 0x68, 0x7b, 0x61, 0x6c, 0x7b, 0x61, 0x6d,
    0x7b, 0x61, 0x6e, 0x7b, 0x61, 0x70, 0x7b, 0x61, 0x72, 0x7b, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table27_4_emit_[108] = {
    0x7b, 0x63, 0x30, 0x7b, 0x63, 0x31, 0x7b, 0x63, 0x32, 0x7b, 0x63, 0x61,
    0x7b, 0x63, 0x63, 0x7b, 0x63, 0x65, 0x7b, 0x63, 0x69, 0x7b, 0x63, 0x6f,
    0x7b, 0x63, 0x73, 0x7b, 0x63, 0x74, 0x7b, 0x63, 0x20, 0x7b, 0x63, 0x25,
    0x7b, 0x63, 0x2d, 0x7b, 0x63, 0x2e, 0x7b, 0x63, 0x2f, 0x7b, 0x63, 0x33,
    0x7b, 0x63, 0x34, 0x7b, 0x63, 0x35, 0x7b, 0x63, 0x36, 0x7b, 0x63, 0x37,
    0x7b, 0x63, 0x38, 0x7b, 0x63, 0x39, 0x7b, 0x63, 0x3d, 0x7b, 0x63, 0x41,
    0x7b, 0x63, 0x5f, 0x7b, 0x63, 0x62, 0x7b, 0x63, 0x64, 0x7b, 0x63, 0x66,
    0x7b, 0x63, 0x67, 0x7b, 0x63, 0x68, 0x7b, 0x63, 0x6c, 0x7b, 0x63, 0x6d,
    0x7b, 0x63, 0x6e, 0x7b, 0x63, 0x70, 0x7b, 0x63, 0x72, 0x7b, 0x63, 0x75};
const uint8_t HuffDecoderCommon::table27_5_emit_[108] = {
    0x7b, 0x65, 0x30, 0x7b, 0x65, 0x31, 0x7b, 0x65, 0x32, 0x7b, 0x65, 0x61,
    0x7b, 0x65, 0x63, 0x7b, 0x65, 0x65, 0x7b, 0x65, 0x69, 0x7b, 0x65, 0x6f,
    0x7b, 0x65, 0x73, 0x7b, 0x65, 0x74, 0x7b, 0x65, 0x20, 0x7b, 0x65, 0x25,
    0x7b, 0x65, 0x2d, 0x7b, 0x65, 0x2e, 0x7b, 0x65, 0x2f, 0x7b, 0x65, 0x33,
    0x7b, 0x65, 0x34, 0x7b, 0x65, 0x35, 0x7b, 0x65, 0x36, 0x7b, 0x65, 0x37,
    0x7b, 0x65, 0x38, 0x7b, 0x65, 0x39, 0x7b, 0x65, 0x3d, 0x7b, 0x65, 0x41,
    0x7b, 0x65, 0x5f, 0x7b, 0x65, 0x62, 0x7b, 0x65, 0x64, 0x7b, 0x65, 0x66,
    0x7b, 0x65, 0x67, 0x7b, 0x65, 0x68, 0x7b, 0x65, 0x6c, 0x7b, 0x65, 0x6d,
    0x7b, 0x65, 0x6e, 0x7b, 0x65, 0x70, 0x7b, 0x65, 0x72, 0x7b, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table27_6_emit_[108] = {
    0x7b, 0x69, 0x30, 0x7b, 0x69, 0x31, 0x7b, 0x69, 0x32, 0x7b, 0x69, 0x61,
    0x7b, 0x69, 0x63, 0x7b, 0x69, 0x65, 0x7b, 0x69, 0x69, 0x7b, 0x69, 0x6f,
    0x7b, 0x69, 0x73, 0x7b, 0x69, 0x74, 0x7b, 0x69, 0x20, 0x7b, 0x69, 0x25,
    0x7b, 0x69, 0x2d, 0x7b, 0x69, 0x2e, 0x7b, 0x69, 0x2f, 0x7b, 0x69, 0x33,
    0x7b, 0x69, 0x34, 0x7b, 0x69, 0x35, 0x7b, 0x69, 0x36, 0x7b, 0x69, 0x37,
    0x7b, 0x69, 0x38, 0x7b, 0x69, 0x39, 0x7b, 0x69, 0x3d, 0x7b, 0x69, 0x41,
    0x7b, 0x69, 0x5f, 0x7b, 0x69, 0x62, 0x7b, 0x69, 0x64, 0x7b, 0x69, 0x66,
    0x7b, 0x69, 0x67, 0x7b, 0x69, 0x68, 0x7b, 0x69, 0x6c, 0x7b, 0x69, 0x6d,
    0x7b, 0x69, 0x6e, 0x7b, 0x69, 0x70, 0x7b, 0x69, 0x72, 0x7b, 0x69, 0x75};
const uint8_t HuffDecoderCommon::table27_7_emit_[108] = {
    0x7b, 0x6f, 0x30, 0x7b, 0x6f, 0x31, 0x7b, 0x6f, 0x32, 0x7b, 0x6f, 0x61,
    0x7b, 0x6f, 0x63, 0x7b, 0x6f, 0x65, 0x7b, 0x6f, 0x69, 0x7b, 0x6f, 0x6f,
    0x7b, 0x6f, 0x73, 0x7b, 0x6f, 0x74, 0x7b, 0x6f, 0x20, 0x7b, 0x6f, 0x25,
    0x7b, 0x6f, 0x2d, 0x7b, 0x6f, 0x2e, 0x7b, 0x6f, 0x2f, 0x7b, 0x6f, 0x33,
    0x7b, 0x6f, 0x34, 0x7b, 0x6f, 0x35, 0x7b, 0x6f, 0x36, 0x7b, 0x6f, 0x37,
    0x7b, 0x6f, 0x38, 0x7b, 0x6f, 0x39, 0x7b, 0x6f, 0x3d, 0x7b, 0x6f, 0x41,
    0x7b, 0x6f, 0x5f, 0x7b, 0x6f, 0x62, 0x7b, 0x6f, 0x64, 0x7b, 0x6f, 0x66,
    0x7b, 0x6f, 0x67, 0x7b, 0x6f, 0x68, 0x7b, 0x6f, 0x6c, 0x7b, 0x6f, 0x6d,
    0x7b, 0x6f, 0x6e, 0x7b, 0x6f, 0x70, 0x7b, 0x6f, 0x72, 0x7b, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table27_8_emit_[108] = {
    0x7b, 0x73, 0x30, 0x7b, 0x73, 0x31, 0x7b, 0x73, 0x32, 0x7b, 0x73, 0x61,
    0x7b, 0x73, 0x63, 0x7b, 0x73, 0x65, 0x7b, 0x73, 0x69, 0x7b, 0x73, 0x6f,
    0x7b, 0x73, 0x73, 0x7b, 0x73, 0x74, 0x7b, 0x73, 0x20, 0x7b, 0x73, 0x25,
    0x7b, 0x73, 0x2d, 0x7b, 0x73, 0x2e, 0x7b, 0x73, 0x2f, 0x7b, 0x73, 0x33,
    0x7b, 0x73, 0x34, 0x7b, 0x73, 0x35, 0x7b, 0x73, 0x36, 0x7b, 0x73, 0x37,
    0x7b, 0x73, 0x38, 0x7b, 0x73, 0x39, 0x7b, 0x73, 0x3d, 0x7b, 0x73, 0x41,
    0x7b, 0x73, 0x5f, 0x7b, 0x73, 0x62, 0x7b, 0x73, 0x64, 0x7b, 0x73, 0x66,
    0x7b, 0x73, 0x67, 0x7b, 0x73, 0x68, 0x7b, 0x73, 0x6c, 0x7b, 0x73, 0x6d,
    0x7b, 0x73, 0x6e, 0x7b, 0x73, 0x70, 0x7b, 0x73, 0x72, 0x7b, 0x73, 0x75};
const uint8_t HuffDecoderCommon::table27_9_emit_[108] = {
    0x7b, 0x74, 0x30, 0x7b, 0x74, 0x31, 0x7b, 0x74, 0x32, 0x7b, 0x74, 0x61,
    0x7b, 0x74, 0x63, 0x7b, 0x74, 0x65, 0x7b, 0x74, 0x69, 0x7b, 0x74, 0x6f,
    0x7b, 0x74, 0x73, 0x7b, 0x74, 0x74, 0x7b, 0x74, 0x20, 0x7b, 0x74, 0x25,
    0x7b, 0x74, 0x2d, 0x7b, 0x74, 0x2e, 0x7b, 0x74, 0x2f, 0x7b, 0x74, 0x33,
    0x7b, 0x74, 0x34, 0x7b, 0x74, 0x35, 0x7b, 0x74, 0x36, 0x7b, 0x74, 0x37,
    0x7b, 0x74, 0x38, 0x7b, 0x74, 0x39, 0x7b, 0x74, 0x3d, 0x7b, 0x74, 0x41,
    0x7b, 0x74, 0x5f, 0x7b, 0x74, 0x62, 0x7b, 0x74, 0x64, 0x7b, 0x74, 0x66,
    0x7b, 0x74, 0x67, 0x7b, 0x74, 0x68, 0x7b, 0x74, 0x6c, 0x7b, 0x74, 0x6d,
    0x7b, 0x74, 0x6e, 0x7b, 0x74, 0x70, 0x7b, 0x74, 0x72, 0x7b, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table27_10_emit_[60] = {
    0x7b, 0x20, 0x30, 0x7b, 0x20, 0x31, 0x7b, 0x20, 0x32, 0x7b, 0x20, 0x61,
    0x7b, 0x20, 0x63, 0x7b, 0x20, 0x65, 0x7b, 0x20, 0x69, 0x7b, 0x20, 0x6f,
    0x7b, 0x20, 0x73, 0x7b, 0x20, 0x74, 0x7b, 0x25, 0x30, 0x7b, 0x25, 0x31,
    0x7b, 0x25, 0x32, 0x7b, 0x25, 0x61, 0x7b, 0x25, 0x63, 0x7b, 0x25, 0x65,
    0x7b, 0x25, 0x69, 0x7b, 0x25, 0x6f, 0x7b, 0x25, 0x73, 0x7b, 0x25, 0x74};
const uint16_t HuffDecoderCommon::table27_10_ops_[64] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9,
    0x00c1, 0x00d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169, 0x0181, 0x0199,
    0x01b1, 0x01c9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f2};
const uint8_t HuffDecoderCommon::table27_11_emit_[60] = {
    0x7b, 0x2d, 0x30, 0x7b, 0x2d, 0x31, 0x7b, 0x2d, 0x32, 0x7b, 0x2d, 0x61,
    0x7b, 0x2d, 0x63, 0x7b, 0x2d, 0x65, 0x7b, 0x2d, 0x69, 0x7b, 0x2d, 0x6f,
    0x7b, 0x2d, 0x73, 0x7b, 0x2d, 0x74, 0x7b, 0x2e, 0x30, 0x7b, 0x2e, 0x31,
    0x7b, 0x2e, 0x32, 0x7b, 0x2e, 0x61, 0x7b, 0x2e, 0x63, 0x7b, 0x2e, 0x65,
    0x7b, 0x2e, 0x69, 0x7b, 0x2e, 0x6f, 0x7b, 0x2e, 0x73, 0x7b, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table27_12_emit_[60] = {
    0x7b, 0x2f, 0x30, 0x7b, 0x2f, 0x31, 0x7b, 0x2f, 0x32, 0x7b, 0x2f, 0x61,
    0x7b, 0x2f, 0x63, 0x7b, 0x2f, 0x65, 0x7b, 0x2f, 0x69, 0x7b, 0x2f, 0x6f,
    0x7b, 0x2f, 0x73, 0x7b, 0x2f, 0x74, 0x7b, 0x33, 0x30, 0x7b, 0x33, 0x31,
    0x7b, 0x33, 0x32, 0x7b, 0x33, 0x61, 0x7b, 0x33, 0x63, 0x7b, 0x33, 0x65,
    0x7b, 0x33, 0x69, 0x7b, 0x33, 0x6f, 0x7b, 0x33, 0x73, 0x7b, 0x33, 0x74};
const uint8_t HuffDecoderCommon::table27_13_emit_[60] = {
    0x7b, 0x34, 0x30, 0x7b, 0x34, 0x31, 0x7b, 0x34, 0x32, 0x7b, 0x34, 0x61,
    0x7b, 0x34, 0x63, 0x7b, 0x34, 0x65, 0x7b, 0x34, 0x69, 0x7b, 0x34, 0x6f,
    0x7b, 0x34, 0x73, 0x7b, 0x34, 0x74, 0x7b, 0x35, 0x30, 0x7b, 0x35, 0x31,
    0x7b, 0x35, 0x32, 0x7b, 0x35, 0x61, 0x7b, 0x35, 0x63, 0x7b, 0x35, 0x65,
    0x7b, 0x35, 0x69, 0x7b, 0x35, 0x6f, 0x7b, 0x35, 0x73, 0x7b, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table27_14_emit_[60] = {
    0x7b, 0x36, 0x30, 0x7b, 0x36, 0x31, 0x7b, 0x36, 0x32, 0x7b, 0x36, 0x61,
    0x7b, 0x36, 0x63, 0x7b, 0x36, 0x65, 0x7b, 0x36, 0x69, 0x7b, 0x36, 0x6f,
    0x7b, 0x36, 0x73, 0x7b, 0x36, 0x74, 0x7b, 0x37, 0x30, 0x7b, 0x37, 0x31,
    0x7b, 0x37, 0x32, 0x7b, 0x37, 0x61, 0x7b, 0x37, 0x63, 0x7b, 0x37, 0x65,
    0x7b, 0x37, 0x69, 0x7b, 0x37, 0x6f, 0x7b, 0x37, 0x73, 0x7b, 0x37, 0x74};
const uint8_t HuffDecoderCommon::table27_15_emit_[60] = {
    0x7b, 0x38, 0x30, 0x7b, 0x38, 0x31, 0x7b, 0x38, 0x32, 0x7b, 0x38, 0x61,
    0x7b, 0x38, 0x63, 0x7b, 0x38, 0x65, 0x7b, 0x38, 0x69, 0x7b, 0x38, 0x6f,
    0x7b, 0x38, 0x73, 0x7b, 0x38, 0x74, 0x7b, 0x39, 0x30, 0x7b, 0x39, 0x31,
    0x7b, 0x39, 0x32, 0x7b, 0x39, 0x61, 0x7b, 0x39, 0x63, 0x7b, 0x39, 0x65,
    0x7b, 0x39, 0x69, 0x7b, 0x39, 0x6f, 0x7b, 0x39, 0x73, 0x7b, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table27_16_emit_[60] = {
    0x7b, 0x3d, 0x30, 0x7b, 0x3d, 0x31, 0x7b, 0x3d, 0x32, 0x7b, 0x3d, 0x61,
    0x7b, 0x3d, 0x63, 0x7b, 0x3d, 0x65, 0x7b, 0x3d, 0x69, 0x7b, 0x3d, 0x6f,
    0x7b, 0x3d, 0x73, 0x7b, 0x3d, 0x74, 0x7b, 0x41, 0x30, 0x7b, 0x41, 0x31,
    0x7b, 0x41, 0x32, 0x7b, 0x41, 0x61, 0x7b, 0x41, 0x63, 0x7b, 0x41, 0x65,
    0x7b, 0x41, 0x69, 0x7b, 0x41, 0x6f, 0x7b, 0x41, 0x73, 0x7b, 0x41, 0x74};
const uint8_t HuffDecoderCommon::table27_17_emit_[60] = {
    0x7b, 0x5f, 0x30, 0x7b, 0x5f, 0x31, 0x7b, 0x5f, 0x32, 0x7b, 0x5f, 0x61,
    0x7b, 0x5f, 0x63, 0x7b, 0x5f, 0x65, 0x7b, 0x5f, 0x69, 0x7b, 0x5f, 0x6f,
    0x7b, 0x5f, 0x73, 0x7b, 0x5f, 0x74, 0x7b, 0x62, 0x30, 0x7b, 0x62, 0x31,
    0x7b, 0x62, 0x32, 0x7b, 0x62, 0x61, 0x7b, 0x62, 0x63, 0x7b, 0x62, 0x65,
    0x7b, 0x62, 0x69, 0x7b, 0x62, 0x6f, 0x7b, 0x62, 0x73, 0x7b, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table27_18_emit_[60] = {
    0x7b, 0x64, 0x30, 0x7b, 0x64, 0x31, 0x7b, 0x64, 0x32, 0x7b, 0x64, 0x61,
    0x7b, 0x64, 0x63, 0x7b, 0x64, 0x65, 0x7b, 0x64, 0x69, 0x7b, 0x64, 0x6f,
    0x7b, 0x64, 0x73, 0x7b, 0x64, 0x74, 0x7b, 0x66, 0x30, 0x7b, 0x66, 0x31,
    0x7b, 0x66, 0x32, 0x7b, 0x66, 0x61, 0x7b, 0x66, 0x63, 0x7b, 0x66, 0x65,
    0x7b, 0x66, 0x69, 0x7b, 0x66, 0x6f, 0x7b, 0x66, 0x73, 0x7b, 0x66, 0x74};
const uint8_t HuffDecoderCommon::table27_19_emit_[60] = {
    0x7b, 0x67, 0x30, 0x7b, 0x67, 0x31, 0x7b, 0x67, 0x32, 0x7b, 0x67, 0x61,
    0x7b, 0x67, 0x63, 0x7b, 0x67, 0x65, 0x7b, 0x67, 0x69, 0x7b, 0x67, 0x6f,
    0x7b, 0x67, 0x73, 0x7b, 0x67, 0x74, 0x7b, 0x68, 0x30, 0x7b, 0x68, 0x31,
    0x7b, 0x68, 0x32, 0x7b, 0x68, 0x61, 0x7b, 0x68, 0x63, 0x7b, 0x68, 0x65,
    0x7b, 0x68, 0x69, 0x7b, 0x68, 0x6f, 0x7b, 0x68, 0x73, 0x7b, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table27_20_emit_[60] = {
    0x7b, 0x6c, 0x30, 0x7b, 0x6c, 0x31, 0x7b, 0x6c, 0x32, 0x7b, 0x6c, 0x61,
    0x7b, 0x6c, 0x63, 0x7b, 0x6c, 0x65, 0x7b, 0x6c, 0x69, 0x7b, 0x6c, 0x6f,
    0x7b, 0x6c, 0x73, 0x7b, 0x6c, 0x74, 0x7b, 0x6d, 0x30, 0x7b, 0x6d, 0x31,
    0x7b, 0x6d, 0x32, 0x7b, 0x6d, 0x61, 0x7b, 0x6d, 0x63, 0x7b, 0x6d, 0x65,
    0x7b, 0x6d, 0x69, 0x7b, 0x6d, 0x6f, 0x7b, 0x6d, 0x73, 0x7b, 0x6d, 0x74};
const uint8_t HuffDecoderCommon::table27_21_emit_[60] = {
    0x7b, 0x6e, 0x30, 0x7b, 0x6e, 0x31, 0x7b, 0x6e, 0x32, 0x7b, 0x6e, 0x61,
    0x7b, 0x6e, 0x63, 0x7b, 0x6e, 0x65, 0x7b, 0x6e, 0x69, 0x7b, 0x6e, 0x6f,
    0x7b, 0x6e, 0x73, 0x7b, 0x6e, 0x74, 0x7b, 0x70, 0x30, 0x7b, 0x70, 0x31,
    0x7b, 0x70, 0x32, 0x7b, 0x70, 0x61, 0x7b, 0x70, 0x63, 0x7b, 0x70, 0x65,
    0x7b, 0x70, 0x69, 0x7b, 0x70, 0x6f, 0x7b, 0x70, 0x73, 0x7b, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table27_22_emit_[60] = {
    0x7b, 0x72, 0x30, 0x7b, 0x72, 0x31, 0x7b, 0x72, 0x32, 0x7b, 0x72, 0x61,
    0x7b, 0x72, 0x63, 0x7b, 0x72, 0x65, 0x7b, 0x72, 0x69, 0x7b, 0x72, 0x6f,
    0x7b, 0x72, 0x73, 0x7b, 0x72, 0x74, 0x7b, 0x75, 0x30, 0x7b, 0x75, 0x31,
    0x7b, 0x75, 0x32, 0x7b, 0x75, 0x61, 0x7b, 0x75, 0x63, 0x7b, 0x75, 0x65,
    0x7b, 0x75, 0x69, 0x7b, 0x75, 0x6f, 0x7b, 0x75, 0x73, 0x7b, 0x75, 0x74};
const uint8_t HuffDecoderCommon::table27_23_emit_[8] = {0x7b, 0x3a, 0x7b, 0x42,
                                                        0x7b, 0x43, 0x7b, 0x44};
const uint16_t HuffDecoderCommon::table27_23_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0032};
const uint8_t HuffDecoderCommon::table27_24_emit_[8] = {0x7b, 0x45, 0x7b, 0x46,
                                                        0x7b, 0x47, 0x7b, 0x48};
const uint8_t HuffDecoderCommon::table27_25_emit_[8] = {0x7b, 0x49, 0x7b, 0x4a,
                                                        0x7b, 0x4b, 0x7b, 0x4c};
const uint8_t HuffDecoderCommon::table27_26_emit_[8] = {0x7b, 0x4d, 0x7b, 0x4e,
                                                        0x7b, 0x4f, 0x7b, 0x50};
const uint8_t HuffDecoderCommon::table27_27_emit_[8] = {0x7b, 0x51, 0x7b, 0x52,
                                                        0x7b, 0x53, 0x7b, 0x54};
const uint8_t HuffDecoderCommon::table27_28_emit_[8] = {0x7b, 0x55, 0x7b, 0x56,
                                                        0x7b, 0x57, 0x7b, 0x59};
const uint8_t HuffDecoderCommon::table27_29_emit_[8] = {0x7b, 0x6a, 0x7b, 0x6b,
                                                        0x7b, 0x71, 0x7b, 0x76};
const uint8_t HuffDecoderCommon::table27_30_emit_[8] = {0x7b, 0x77, 0x7b, 0x78,
                                                        0x7b, 0x79, 0x7b, 0x7a};
const uint8_t HuffDecoderCommon::table27_31_emit_[28] = {
    0x7b, 0x26, 0x7b, 0x2a, 0x7b, 0x2c, 0x7b, 0x3b, 0x7b, 0x58,
    0x7b, 0x5a, 0x7b, 0x21, 0x7b, 0x22, 0x7b, 0x28, 0x7b, 0x29,
    0x7b, 0x3f, 0x7b, 0x27, 0x7b, 0x2b, 0x7b, 0x7c};
const uint16_t HuffDecoderCommon::table27_31_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0032,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052,
    0x0000, 0x0062, 0x0000, 0x0072, 0x0000, 0x0082, 0x0000, 0x0092,
    0x0000, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x0000, 0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table27_32_emit_[44] = {
    0x5c, 0x30, 0x5c, 0x31, 0x5c, 0x32, 0x5c, 0x61, 0x5c, 0x63, 0x5c,
    0x65, 0x5c, 0x69, 0x5c, 0x6f, 0x5c, 0x73, 0x5c, 0x74, 0x5c, 0x20,
    0x5c, 0x25, 0x5c, 0x2d, 0x5c, 0x2e, 0x5c, 0x2f, 0x5c, 0x33, 0x5c,
    0x34, 0x5c, 0x35, 0x5c, 0x36, 0x5c, 0x37, 0x5c, 0x38, 0x5c, 0x39};
const uint16_t HuffDecoderCommon::table27_32_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0032,
    0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052,
    0x0000, 0x0000, 0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0072,
    0x0000, 0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0092,
    0x0000, 0x00a2, 0x0000, 0x00b2, 0x0000, 0x00c2, 0x0000, 0x00d2,
    0x0000, 0x00e2, 0x0000, 0x00f2, 0x0000, 0x0102, 0x0000, 0x0112,
    0x0000, 0x0122, 0x0000, 0x0132, 0x0000, 0x0142, 0x0000, 0x0152};
const uint8_t HuffDecoderCommon::table27_33_emit_[92] = {
    0x5c, 0x3d, 0x5c, 0x41, 0x5c, 0x5f, 0x5c, 0x62, 0x5c, 0x64, 0x5c, 0x66,
    0x5c, 0x67, 0x5c, 0x68, 0x5c, 0x6c, 0x5c, 0x6d, 0x5c, 0x6e, 0x5c, 0x70,
    0x5c, 0x72, 0x5c, 0x75, 0x5c, 0x3a, 0x5c, 0x42, 0x5c, 0x43, 0x5c, 0x44,
    0x5c, 0x45, 0x5c, 0x46, 0x5c, 0x47, 0x5c, 0x48, 0x5c, 0x49, 0x5c, 0x4a,
    0x5c, 0x4b, 0x5c, 0x4c, 0x5c, 0x4d, 0x5c, 0x4e, 0x5c, 0x4f, 0x5c, 0x50,
    0x5c, 0x51, 0x5c, 0x52, 0x5c, 0x53, 0x5c, 0x54, 0x5c, 0x55, 0x5c, 0x56,
    0x5c, 0x57, 0x5c, 0x59, 0x5c, 0x6a, 0x5c, 0x6b, 0x5c, 0x71, 0x5c, 0x76,
    0x5c, 0x77, 0x5c, 0x78, 0x5c, 0x79, 0x5c, 0x7a};
const uint16_t HuffDecoderCommon::table27_33_ops_[64] = {
    0x0000, 0x0002, 0x0000, 0x0012, 0x0000, 0x0022, 0x0000, 0x0032,
    0x0000, 0x0042, 0x0000, 0x0052, 0x0000, 0x0062, 0x0000, 0x0072,
    0x0000, 0x0082, 0x0000, 0x0092, 0x0000, 0x00a2, 0x0000, 0x00b2,
    0x0000, 0x00c2, 0x0000, 0x00d2, 0x00e2, 0x00f2, 0x0102, 0x0112,
    0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212,
    0x0222, 0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292,
    0x02a2, 0x02b2, 0x02c2, 0x02d2, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table27_34_emit_[44] = {
    0xc3, 0x30, 0xc3, 0x31, 0xc3, 0x32, 0xc3, 0x61, 0xc3, 0x63, 0xc3,
    0x65, 0xc3, 0x69, 0xc3, 0x6f, 0xc3, 0x73, 0xc3, 0x74, 0xc3, 0x20,
    0xc3, 0x25, 0xc3, 0x2d, 0xc3, 0x2e, 0xc3, 0x2f, 0xc3, 0x33, 0xc3,
    0x34, 0xc3, 0x35, 0xc3, 0x36, 0xc3, 0x37, 0xc3, 0x38, 0xc3, 0x39};
const uint8_t HuffDecoderCommon::table27_35_emit_[92] = {
    0xc3, 0x3d, 0xc3, 0x41, 0xc3, 0x5f, 0xc3, 0x62, 0xc3, 0x64, 0xc3, 0x66,
    0xc3, 0x67, 0xc3, 0x68, 0xc3, 0x6c, 0xc3, 0x6d, 0xc3, 0x6e, 0xc3, 0x70,
    0xc3, 0x72, 0xc3, 0x75, 0xc3, 0x3a, 0xc3, 0x42, 0xc3, 0x43, 0xc3, 0x44,
    0xc3, 0x45, 0xc3, 0x46, 0xc3, 0x47, 0xc3, 0x48, 0xc3, 0x49, 0xc3, 0x4a,
    0xc3, 0x4b, 0xc3, 0x4c, 0xc3, 0x4d, 0xc3, 0x4e, 0xc3, 0x4f, 0xc3, 0x50,
    0xc3, 0x51, 0xc3, 0x52, 0xc3, 0x53, 0xc3, 0x54, 0xc3, 0x55, 0xc3, 0x56,
    0xc3, 0x57, 0xc3, 0x59, 0xc3, 0x6a, 0xc3, 0x6b, 0xc3, 0x71, 0xc3, 0x76,
    0xc3, 0x77, 0xc3, 0x78, 0xc3, 0x79, 0xc3, 0x7a};
const uint8_t HuffDecoderCommon::table27_36_emit_[44] = {
    0xd0, 0x30, 0xd0, 0x31, 0xd0, 0x32, 0xd0, 0x61, 0xd0, 0x63, 0xd0,
    0x65, 0xd0, 0x69, 0xd0, 0x6f, 0xd0, 0x73, 0xd0, 0x74, 0xd0, 0x20,
    0xd0, 0x25, 0xd0, 0x2d, 0xd0, 0x2e, 0xd0, 0x2f, 0xd0, 0x33, 0xd0,
    0x34, 0xd0, 0x35, 0xd0, 0x36, 0xd0, 0x37, 0xd0, 0x38, 0xd0, 0x39};
const uint8_t HuffDecoderCommon::table27_37_emit_[92] = {
    0xd0, 0x3d, 0xd0, 0x41, 0xd0, 0x5f, 0xd0, 0x62, 0xd0, 0x64, 0xd0, 0x66,
    0xd0, 0x67, 0xd0, 0x68, 0xd0, 0x6c, 0xd0, 0x6d, 0xd0, 0x6e, 0xd0, 0x70,
    0xd0, 0x72, 0xd0, 0x75, 0xd0, 0x3a, 0xd0, 0x42, 0xd0, 0x43, 0xd0, 0x44,
    0xd0, 0x45, 0xd0, 0x46, 0xd0, 0x47, 0xd0, 0x48, 0xd0, 0x49, 0xd0, 0x4a,
    0xd0, 0x4b, 0xd0, 0x4c, 0xd0, 0x4d, 0xd0, 0x4e, 0xd0, 0x4f, 0xd0, 0x50,
    0xd0, 0x51, 0xd0, 0x52, 0xd0, 0x53, 0xd0, 0x54, 0xd0, 0x55, 0xd0, 0x56,
    0xd0, 0x57, 0xd0, 0x59, 0xd0, 0x6a, 0xd0, 0x6b, 0xd0, 0x71, 0xd0, 0x76,
    0xd0, 0x77, 0xd0, 0x78, 0xd0, 0x79, 0xd0, 0x7a};
const uint8_t HuffDecoderCommon::table27_38_emit_[72] = {
    0x80, 0x30, 0x80, 0x31, 0x80, 0x32, 0x80, 0x61, 0x80, 0x63, 0x80, 0x65,
    0x80, 0x69, 0x80, 0x6f, 0x80, 0x73, 0x80, 0x74, 0x80, 0x20, 0x80, 0x25,
    0x80, 0x2d, 0x80, 0x2e, 0x80, 0x2f, 0x80, 0x33, 0x80, 0x34, 0x80, 0x35,
    0x80, 0x36, 0x80, 0x37, 0x80, 0x38, 0x80, 0x39, 0x80, 0x3d, 0x80, 0x41,
    0x80, 0x5f, 0x80, 0x62, 0x80, 0x64, 0x80, 0x66, 0x80, 0x67, 0x80, 0x68,
    0x80, 0x6c, 0x80, 0x6d, 0x80, 0x6e, 0x80, 0x70, 0x80, 0x72, 0x80, 0x75};
const uint16_t HuffDecoderCommon::table27_38_ops_[64] = {
    0x0000, 0x0002, 0x0000, 0x0012, 0x0000, 0x0022, 0x0000, 0x0032,
    0x0000, 0x0042, 0x0000, 0x0052, 0x0000, 0x0062, 0x0000, 0x0072,
    0x0000, 0x0082, 0x0000, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2,
    0x00e2, 0x00f2, 0x0102, 0x0112, 0x0122, 0x0132, 0x0142, 0x0152,
    0x0162, 0x0172, 0x0182, 0x0192, 0x01a2, 0x01b2, 0x01c2, 0x01d2,
    0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222, 0x0232, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table27_39_emit_[72] = {
    0x82, 0x30, 0x82, 0x31, 0x82, 0x32, 0x82, 0x61, 0x82, 0x63, 0x82, 0x65,
    0x82, 0x69, 0x82, 0x6f, 0x82, 0x73, 0x82, 0x74, 0x82, 0x20, 0x82, 0x25,
    0x82, 0x2d, 0x82, 0x2e, 0x82, 0x2f, 0x82, 0x33, 0x82, 0x34, 0x82, 0x35,
    0x82, 0x36, 0x82, 0x37, 0x82, 0x38, 0x82, 0x39, 0x82, 0x3d, 0x82, 0x41,
    0x82, 0x5f, 0x82, 0x62, 0x82, 0x64, 0x82, 0x66, 0x82, 0x67, 0x82, 0x68,
    0x82, 0x6c, 0x82, 0x6d, 0x82, 0x6e, 0x82, 0x70, 0x82, 0x72, 0x82, 0x75};
const uint8_t HuffDecoderCommon::table27_40_emit_[72] = {
    0x83, 0x30, 0x83, 0x31, 0x83, 0x32, 0x83, 0x61, 0x83, 0x63, 0x83, 0x65,
    0x83, 0x69, 0x83, 0x6f, 0x83, 0x73, 0x83, 0x74, 0x83, 0x20, 0x83, 0x25,
    0x83, 0x2d, 0x83, 0x2e, 0x83, 0x2f, 0x83, 0x33, 0x83, 0x34, 0x83, 0x35,
    0x83, 0x36, 0x83, 0x37, 0x83, 0x38, 0x83, 0x39, 0x83, 0x3d, 0x83, 0x41,
    0x83, 0x5f, 0x83, 0x62, 0x83, 0x64, 0x83, 0x66, 0x83, 0x67, 0x83, 0x68,
    0x83, 0x6c, 0x83, 0x6d, 0x83, 0x6e, 0x83, 0x70, 0x83, 0x72, 0x83, 0x75};
const uint8_t HuffDecoderCommon::table27_41_emit_[72] = {
    0xa2, 0x30, 0xa2, 0x31, 0xa2, 0x32, 0xa2, 0x61, 0xa2, 0x63, 0xa2, 0x65,
    0xa2, 0x69, 0xa2, 0x6f, 0xa2, 0x73, 0xa2, 0x74, 0xa2, 0x20, 0xa2, 0x25,
    0xa2, 0x2d, 0xa2, 0x2e, 0xa2, 0x2f, 0xa2, 0x33, 0xa2, 0x34, 0xa2, 0x35,
    0xa2, 0x36, 0xa2, 0x37, 0xa2, 0x38, 0xa2, 0x39, 0xa2, 0x3d, 0xa2, 0x41,
    0xa2, 0x5f, 0xa2, 0x62, 0xa2, 0x64, 0xa2, 0x66, 0xa2, 0x67, 0xa2, 0x68,
    0xa2, 0x6c, 0xa2, 0x6d, 0xa2, 0x6e, 0xa2, 0x70, 0xa2, 0x72, 0xa2, 0x75};
const uint8_t HuffDecoderCommon::table27_42_emit_[72] = {
    0xb8, 0x30, 0xb8, 0x31, 0xb8, 0x32, 0xb8, 0x61, 0xb8, 0x63, 0xb8, 0x65,
    0xb8, 0x69, 0xb8, 0x6f, 0xb8, 0x73, 0xb8, 0x74, 0xb8, 0x20, 0xb8, 0x25,
    0xb8, 0x2d, 0xb8, 0x2e, 0xb8, 0x2f, 0xb8, 0x33, 0xb8, 0x34, 0xb8, 0x35,
    0xb8, 0x36, 0xb8, 0x37, 0xb8, 0x38, 0xb8, 0x39, 0xb8, 0x3d, 0xb8, 0x41,
    0xb8, 0x5f, 0xb8, 0x62, 0xb8, 0x64, 0xb8, 0x66, 0xb8, 0x67, 0xb8, 0x68,
    0xb8, 0x6c, 0xb8, 0x6d, 0xb8, 0x6e, 0xb8, 0x70, 0xb8, 0x72, 0xb8, 0x75};
const uint8_t HuffDecoderCommon::table27_43_emit_[72] = {
    0xc2, 0x30, 0xc2, 0x31, 0xc2, 0x32, 0xc2, 0x61, 0xc2, 0x63, 0xc2, 0x65,
    0xc2, 0x69, 0xc2, 0x6f, 0xc2, 0x73, 0xc2, 0x74, 0xc2, 0x20, 0xc2, 0x25,
    0xc2, 0x2d, 0xc2, 0x2e, 0xc2, 0x2f, 0xc2, 0x33, 0xc2, 0x34, 0xc2, 0x35,
    0xc2, 0x36, 0xc2, 0x37, 0xc2, 0x38, 0xc2, 0x39, 0xc2, 0x3d, 0xc2, 0x41,
    0xc2, 0x5f, 0xc2, 0x62, 0xc2, 0x64, 0xc2, 0x66, 0xc2, 0x67, 0xc2, 0x68,
    0xc2, 0x6c, 0xc2, 0x6d, 0xc2, 0x6e, 0xc2, 0x70, 0xc2, 0x72, 0xc2, 0x75};
const uint8_t HuffDecoderCommon::table27_44_emit_[72] = {
    0xe0, 0x30, 0xe0, 0x31, 0xe0, 0x32, 0xe0, 0x61, 0xe0, 0x63, 0xe0, 0x65,
    0xe0, 0x69, 0xe0, 0x6f, 0xe0, 0x73, 0xe0, 0x74, 0xe0, 0x20, 0xe0, 0x25,
    0xe0, 0x2d, 0xe0, 0x2e, 0xe0, 0x2f, 0xe0, 0x33, 0xe0, 0x34, 0xe0, 0x35,
    0xe0, 0x36, 0xe0, 0x37, 0xe0, 0x38, 0xe0, 0x39, 0xe0, 0x3d, 0xe0, 0x41,
    0xe0, 0x5f, 0xe0, 0x62, 0xe0, 0x64, 0xe0, 0x66, 0xe0, 0x67, 0xe0, 0x68,
    0xe0, 0x6c, 0xe0, 0x6d, 0xe0, 0x6e, 0xe0, 0x70, 0xe0, 0x72, 0xe0, 0x75};
const uint8_t HuffDecoderCommon::table27_45_emit_[72] = {
    0xe2, 0x30, 0xe2, 0x31, 0xe2, 0x32, 0xe2, 0x61, 0xe2, 0x63, 0xe2, 0x65,
    0xe2, 0x69, 0xe2, 0x6f, 0xe2, 0x73, 0xe2, 0x74, 0xe2, 0x20, 0xe2, 0x25,
    0xe2, 0x2d, 0xe2, 0x2e, 0xe2, 0x2f, 0xe2, 0x33, 0xe2, 0x34, 0xe2, 0x35,
    0xe2, 0x36, 0xe2, 0x37, 0xe2, 0x38, 0xe2, 0x39, 0xe2, 0x3d, 0xe2, 0x41,
    0xe2, 0x5f, 0xe2, 0x62, 0xe2, 0x64, 0xe2, 0x66, 0xe2, 0x67, 0xe2, 0x68,
    0xe2, 0x6c, 0xe2, 0x6d, 0xe2, 0x6e, 0xe2, 0x70, 0xe2, 0x72, 0xe2, 0x75};
const uint8_t HuffDecoderCommon::table27_46_emit_[40] = {
    0x99, 0x30, 0x99, 0x31, 0x99, 0x32, 0x99, 0x61, 0x99, 0x63,
    0x99, 0x65, 0x99, 0x69, 0x99, 0x6f, 0x99, 0x73, 0x99, 0x74,
    0xa1, 0x30, 0xa1, 0x31, 0xa1, 0x32, 0xa1, 0x61, 0xa1, 0x63,
    0xa1, 0x65, 0xa1, 0x69, 0xa1, 0x6f, 0xa1, 0x73, 0xa1, 0x74};
const uint16_t HuffDecoderCommon::table27_46_ops_[64] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003,
    0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102, 0x0112,
    0x0122, 0x0132, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00a3};
const uint8_t HuffDecoderCommon::table27_47_emit_[40] = {
    0xa7, 0x30, 0xa7, 0x31, 0xa7, 0x32, 0xa7, 0x61, 0xa7, 0x63,
    0xa7, 0x65, 0xa7, 0x69, 0xa7, 0x6f, 0xa7, 0x73, 0xa7, 0x74,
    0xac, 0x30, 0xac, 0x31, 0xac, 0x32, 0xac, 0x61, 0xac, 0x63,
    0xac, 0x65, 0xac, 0x69, 0xac, 0x6f, 0xac, 0x73, 0xac, 0x74};
const uint8_t HuffDecoderCommon::table27_48_emit_[40] = {
    0xb0, 0x30, 0xb0, 0x31, 0xb0, 0x32, 0xb0, 0x61, 0xb0, 0x63,
    0xb0, 0x65, 0xb0, 0x69, 0xb0, 0x6f, 0xb0, 0x73, 0xb0, 0x74,
    0xb1, 0x30, 0xb1, 0x31, 0xb1, 0x32, 0xb1, 0x61, 0xb1, 0x63,
    0xb1, 0x65, 0xb1, 0x69, 0xb1, 0x6f, 0xb1, 0x73, 0xb1, 0x74};
const uint8_t HuffDecoderCommon::table27_49_emit_[40] = {
    0xb3, 0x30, 0xb3, 0x31, 0xb3, 0x32, 0xb3, 0x61, 0xb3, 0x63,
    0xb3, 0x65, 0xb3, 0x69, 0xb3, 0x6f, 0xb3, 0x73, 0xb3, 0x74,
    0xd1, 0x30, 0xd1, 0x31, 0xd1, 0x32, 0xd1, 0x61, 0xd1, 0x63,
    0xd1, 0x65, 0xd1, 0x69, 0xd1, 0x6f, 0xd1, 0x73, 0xd1, 0x74};
const uint8_t HuffDecoderCommon::table27_50_emit_[40] = {
    0xd8, 0x30, 0xd8, 0x31, 0xd8, 0x32, 0xd8, 0x61, 0xd8, 0x63,
    0xd8, 0x65, 0xd8, 0x69, 0xd8, 0x6f, 0xd8, 0x73, 0xd8, 0x74,
    0xd9, 0x30, 0xd9, 0x31, 0xd9, 0x32, 0xd9, 0x61, 0xd9, 0x63,
    0xd9, 0x65, 0xd9, 0x69, 0xd9, 0x6f, 0xd9, 0x73, 0xd9, 0x74};
const uint8_t HuffDecoderCommon::table27_51_emit_[40] = {
    0xe3, 0x30, 0xe3, 0x31, 0xe3, 0x32, 0xe3, 0x61, 0xe3, 0x63,
    0xe3, 0x65, 0xe3, 0x69, 0xe3, 0x6f, 0xe3, 0x73, 0xe3, 0x74,
    0xe5, 0x30, 0xe5, 0x31, 0xe5, 0x32, 0xe5, 0x61, 0xe5, 0x63,
    0xe5, 0x65, 0xe5, 0x69, 0xe5, 0x6f, 0xe5, 0x73, 0xe5, 0x74};
const uint8_t HuffDecoderCommon::table27_52_emit_[22] = {
    0xe6, 0x30, 0xe6, 0x31, 0xe6, 0x32, 0xe6, 0x61, 0xe6, 0x63, 0xe6,
    0x65, 0xe6, 0x69, 0xe6, 0x6f, 0xe6, 0x73, 0xe6, 0x74, 0x81, 0x84};
const uint16_t HuffDecoderCommon::table27_52_ops_[64] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00a3,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00ab};
const uint8_t HuffDecoderCommon::table27_53_emit_[4] = {0x85, 0x86, 0x88, 0x92};
const uint16_t HuffDecoderCommon::table27_53_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000b,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0013,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001b};
const uint8_t HuffDecoderCommon::table27_54_emit_[4] = {0x9a, 0x9c, 0xa0, 0xa3};
const uint8_t HuffDecoderCommon::table27_55_emit_[4] = {0xa4, 0xa9, 0xaa, 0xad};
const uint8_t HuffDecoderCommon::table27_56_emit_[4] = {0xb2, 0xb5, 0xb9, 0xba};
const uint8_t HuffDecoderCommon::table27_57_emit_[4] = {0xbb, 0xbd, 0xbe, 0xc4};
const uint8_t HuffDecoderCommon::table27_58_emit_[4] = {0xc6, 0xe4, 0xe8, 0xe9};
const uint8_t HuffDecoderCommon::table27_59_emit_[8] = {0x01, 0x87, 0x89, 0x8a,
                                                        0x8b, 0x8c, 0x8d, 0x8f};
const uint16_t HuffDecoderCommon::table27_59_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000b,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0013,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001b,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0023,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x002b,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0033,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x003b};
const uint8_t HuffDecoderCommon::table27_60_emit_[8] = {0x93, 0x95, 0x96, 0x97,
                                                        0x98, 0x9b, 0x9d, 0x9e};
const uint8_t HuffDecoderCommon::table27_61_emit_[8] = {0xa5, 0xa6, 0xa8, 0xae,
                                                        0xaf, 0xb4, 0xb6, 0xb7};
const uint8_t HuffDecoderCommon::table27_62_emit_[11] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f};
const uint16_t HuffDecoderCommon::table27_62_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000b,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0013,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001b,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0023,
    0x0000, 0x0000, 0x0000, 0x002b, 0x0000, 0x0000, 0x0000, 0x0033,
    0x0000, 0x0000, 0x0000, 0x003b, 0x0000, 0x0000, 0x0000, 0x0043,
    0x0000, 0x0000, 0x0000, 0x004b, 0x0000, 0x0000, 0x0000, 0x0053};
const uint8_t HuffDecoderCommon::table27_63_emit_[25] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea,
    0xeb, 0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5,
    0xda, 0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff};
const uint16_t HuffDecoderCommon::table27_63_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0003, 0x0000, 0x0000, 0x0000, 0x000b,
    0x0000, 0x0000, 0x0000, 0x0013, 0x0000, 0x0000, 0x0000, 0x001b,
    0x0000, 0x0000, 0x0000, 0x0023, 0x0000, 0x0000, 0x0000, 0x002b,
    0x0000, 0x0033, 0x0000, 0x003b, 0x0000, 0x0043, 0x0000, 0x004b,
    0x0053, 0x005b, 0x0063, 0x006b, 0x0073, 0x007b, 0x0083, 0x008b,
    0x0093, 0x009b, 0x00a3, 0x00ab, 0x00b3, 0x00bb, 0x00c3, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004};
const uint8_t* const HuffDecoderCommon::table27_emit_[64] = {
    table27_0_emit_,  table27_1_emit_,  table27_2_emit_,  table27_3_emit_,
    table27_4_emit_,  table27_5_emit_,  table27_6_emit_,  table27_7_emit_,
    table27_8_emit_,  table27_9_emit_,  table27_10_emit_, table27_11_emit_,
    table27_12_emit_, table27_13_emit_, table27_14_emit_, table27_15_emit_,
    table27_16_emit_, table27_17_emit_, table27_18_emit_, table27_19_emit_,
    table27_20_emit_, table27_21_emit_, table27_22_emit_, table27_23_emit_,
    table27_24_emit_, table27_25_emit_, table27_26_emit_, table27_27_emit_,
    table27_28_emit_, table27_29_emit_, table27_30_emit_, table27_31_emit_,
    table27_32_emit_, table27_33_emit_, table27_34_emit_, table27_35_emit_,
    table27_36_emit_, table27_37_emit_, table27_38_emit_, table27_39_emit_,
    table27_40_emit_, table27_41_emit_, table27_42_emit_, table27_43_emit_,
    table27_44_emit_, table27_45_emit_, table27_46_emit_, table27_47_emit_,
    table27_48_emit_, table27_49_emit_, table27_50_emit_, table27_51_emit_,
    table27_52_emit_, table27_53_emit_, table27_54_emit_, table27_55_emit_,
    table27_56_emit_, table27_57_emit_, table27_58_emit_, table27_59_emit_,
    table27_60_emit_, table27_61_emit_, table27_62_emit_, table27_63_emit_,
};
const uint16_t* const HuffDecoderCommon::table27_ops_[64] = {
    table27_0_ops_,  table27_0_ops_,  table27_0_ops_,  table27_0_ops_,
    table27_0_ops_,  table27_0_ops_,  table27_0_ops_,  table27_0_ops_,
    table27_0_ops_,  table27_0_ops_,  table27_10_ops_, table27_10_ops_,
    table27_10_ops_, table27_10_ops_, table27_10_ops_, table27_10_ops_,
    table27_10_ops_, table27_10_ops_, table27_10_ops_, table27_10_ops_,
    table27_10_ops_, table27_10_ops_, table27_10_ops_, table27_23_ops_,
    table27_23_ops_, table27_23_ops_, table27_23_ops_, table27_23_ops_,
    table27_23_ops_, table27_23_ops_, table27_23_ops_, table27_31_ops_,
    table27_32_ops_, table27_33_ops_, table27_32_ops_, table27_33_ops_,
    table27_32_ops_, table27_33_ops_, table27_38_ops_, table27_38_ops_,
    table27_38_ops_, table27_38_ops_, table27_38_ops_, table27_38_ops_,
    table27_38_ops_, table27_38_ops_, table27_46_ops_, table27_46_ops_,
    table27_46_ops_, table27_46_ops_, table27_46_ops_, table27_46_ops_,
    table27_52_ops_, table27_53_ops_, table27_53_ops_, table27_53_ops_,
    table27_53_ops_, table27_53_ops_, table27_53_ops_, table27_59_ops_,
    table27_59_ops_, table27_59_ops_, table27_62_ops_, table27_63_ops_,
};
const uint8_t HuffDecoderCommon::table28_0_emit_[204] = {
    0x7b, 0x30, 0x30, 0x7b, 0x30, 0x31, 0x7b, 0x30, 0x32, 0x7b, 0x30, 0x61,
    0x7b, 0x30, 0x63, 0x7b, 0x30, 0x65, 0x7b, 0x30, 0x69, 0x7b, 0x30, 0x6f,
    0x7b, 0x30, 0x73, 0x7b, 0x30, 0x74, 0x7b, 0x30, 0x20, 0x7b, 0x30, 0x25,
    0x7b, 0x30, 0x2d, 0x7b, 0x30, 0x2e, 0x7b, 0x30, 0x2f, 0x7b, 0x30, 0x33,
    0x7b, 0x30, 0x34, 0x7b, 0x30, 0x35, 0x7b, 0x30, 0x36, 0x7b, 0x30, 0x37,
    0x7b, 0x30, 0x38, 0x7b, 0x30, 0x39, 0x7b, 0x30, 0x3d, 0x7b, 0x30, 0x41,
    0x7b, 0x30, 0x5f, 0x7b, 0x30, 0x62, 0x7b, 0x30, 0x64, 0x7b, 0x30, 0x66,
    0x7b, 0x30, 0x67, 0x7b, 0x30, 0x68, 0x7b, 0x30, 0x6c, 0x7b, 0x30, 0x6d,
    0x7b, 0x30, 0x6e, 0x7b, 0x30, 0x70, 0x7b, 0x30, 0x72, 0x7b, 0x30, 0x75,
    0x7b, 0x30, 0x3a, 0x7b, 0x30, 0x42, 0x7b, 0x30, 0x43, 0x7b, 0x30, 0x44,
    0x7b, 0x30, 0x45, 0x7b, 0x30, 0x46, 0x7b, 0x30, 0x47, 0x7b, 0x30, 0x48,
    0x7b, 0x30, 0x49, 0x7b, 0x30, 0x4a, 0x7b, 0x30, 0x4b, 0x7b, 0x30, 0x4c,
    0x7b, 0x30, 0x4d, 0x7b, 0x30, 0x4e, 0x7b, 0x30, 0x4f, 0x7b, 0x30, 0x50,
    0x7b, 0x30, 0x51, 0x7b, 0x30, 0x52, 0x7b, 0x30, 0x53, 0x7b, 0x30, 0x54,
    0x7b, 0x30, 0x55, 0x7b, 0x30, 0x56, 0x7b, 0x30, 0x57, 0x7b, 0x30, 0x59,
    0x7b, 0x30, 0x6a, 0x7b, 0x30, 0x6b, 0x7b, 0x30, 0x71, 0x7b, 0x30, 0x76,
    0x7b, 0x30, 0x77, 0x7b, 0x30, 0x78, 0x7b, 0x30, 0x79, 0x7b, 0x30, 0x7a};
const uint16_t HuffDecoderCommon::table28_0_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000,
    0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0000,
    0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0079, 0x0000, 0x0000, 0x0000,
    0x0091, 0x0000, 0x0000, 0x0000, 0x00a9, 0x0000, 0x0000, 0x0000, 0x00c1,
    0x0000, 0x0000, 0x0000, 0x00d9, 0x0000, 0x00f1, 0x0000, 0x0109, 0x0000,
    0x0121, 0x0000, 0x0139, 0x0000, 0x0151, 0x0000, 0x0169, 0x0000, 0x0181,
    0x0000, 0x0199, 0x0000, 0x01b1, 0x0000, 0x01c9, 0x0000, 0x01e1, 0x0000,
    0x01f9, 0x0000, 0x0211, 0x0000, 0x0229, 0x0000, 0x0241, 0x0000, 0x0259,
    0x0000, 0x0271, 0x0000, 0x0289, 0x0000, 0x02a1, 0x0000, 0x02b9, 0x0000,
    0x02d1, 0x0000, 0x02e9, 0x0000, 0x0301, 0x0000, 0x0319, 0x0000, 0x0331,
    0x0000, 0x0349, 0x0361, 0x0379, 0x0391, 0x03a9, 0x03c1, 0x03d9, 0x03f1,
    0x0409, 0x0421, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9,
    0x04e1, 0x04f9, 0x0511, 0x0529, 0x0541, 0x0559, 0x0571, 0x0589, 0x05a1,
    0x05b9, 0x05d1, 0x05e9, 0x0601, 0x0619, 0x0631, 0x0649, 0x0000, 0x0000,
    0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table28_1_emit_[204] = {
    0x7b, 0x31, 0x30, 0x7b, 0x31, 0x31, 0x7b, 0x31, 0x32, 0x7b, 0x31, 0x61,
    0x7b, 0x31, 0x63, 0x7b, 0x31, 0x65, 0x7b, 0x31, 0x69, 0x7b, 0x31, 0x6f,
    0x7b, 0x31, 0x73, 0x7b, 0x31, 0x74, 0x7b, 0x31, 0x20, 0x7b, 0x31, 0x25,
    0x7b, 0x31, 0x2d, 0x7b, 0x31, 0x2e, 0x7b, 0x31, 0x2f, 0x7b, 0x31, 0x33,
    0x7b, 0x31, 0x34, 0x7b, 0x31, 0x35, 0x7b, 0x31, 0x36, 0x7b, 0x31, 0x37,
    0x7b, 0x31, 0x38, 0x7b, 0x31, 0x39, 0x7b, 0x31, 0x3d, 0x7b, 0x31, 0x41,
    0x7b, 0x31, 0x5f, 0x7b, 0x31, 0x62, 0x7b, 0x31, 0x64, 0x7b, 0x31, 0x66,
    0x7b, 0x31, 0x67, 0x7b, 0x31, 0x68, 0x7b, 0x31, 0x6c, 0x7b, 0x31, 0x6d,
    0x7b, 0x31, 0x6e, 0x7b, 0x31, 0x70, 0x7b, 0x31, 0x72, 0x7b, 0x31, 0x75,
    0x7b, 0x31, 0x3a, 0x7b, 0x31, 0x42, 0x7b, 0x31, 0x43, 0x7b, 0x31, 0x44,
    0x7b, 0x31, 0x45, 0x7b, 0x31, 0x46, 0x7b, 0x31, 0x47, 0x7b, 0x31, 0x48,
    0x7b, 0x31, 0x49, 0x7b, 0x31, 0x4a, 0x7b, 0x31, 0x4b, 0x7b, 0x31, 0x4c,
    0x7b, 0x31, 0x4d, 0x7b, 0x31, 0x4e, 0x7b, 0x31, 0x4f, 0x7b, 0x31, 0x50,
    0x7b, 0x31, 0x51, 0x7b, 0x31, 0x52, 0x7b, 0x31, 0x53, 0x7b, 0x31, 0x54,
    0x7b, 0x31, 0x55, 0x7b, 0x31, 0x56, 0x7b, 0x31, 0x57, 0x7b, 0x31, 0x59,
    0x7b, 0x31, 0x6a, 0x7b, 0x31, 0x6b, 0x7b, 0x31, 0x71, 0x7b, 0x31, 0x76,
    0x7b, 0x31, 0x77, 0x7b, 0x31, 0x78, 0x7b, 0x31, 0x79, 0x7b, 0x31, 0x7a};
const uint8_t HuffDecoderCommon::table28_2_emit_[204] = {
    0x7b, 0x32, 0x30, 0x7b, 0x32, 0x31, 0x7b, 0x32, 0x32, 0x7b, 0x32, 0x61,
    0x7b, 0x32, 0x63, 0x7b, 0x32, 0x65, 0x7b, 0x32, 0x69, 0x7b, 0x32, 0x6f,
    0x7b, 0x32, 0x73, 0x7b, 0x32, 0x74, 0x7b, 0x32, 0x20, 0x7b, 0x32, 0x25,
    0x7b, 0x32, 0x2d, 0x7b, 0x32, 0x2e, 0x7b, 0x32, 0x2f, 0x7b, 0x32, 0x33,
    0x7b, 0x32, 0x34, 0x7b, 0x32, 0x35, 0x7b, 0x32, 0x36, 0x7b, 0x32, 0x37,
    0x7b, 0x32, 0x38, 0x7b, 0x32, 0x39, 0x7b, 0x32, 0x3d, 0x7b, 0x32, 0x41,
    0x7b, 0x32, 0x5f, 0x7b, 0x32, 0x62, 0x7b, 0x32, 0x64, 0x7b, 0x32, 0x66,
    0x7b, 0x32, 0x67, 0x7b, 0x32, 0x68, 0x7b, 0x32, 0x6c, 0x7b, 0x32, 0x6d,
    0x7b, 0x32, 0x6e, 0x7b, 0x32, 0x70, 0x7b, 0x32, 0x72, 0x7b, 0x32, 0x75,
    0x7b, 0x32, 0x3a, 0x7b, 0x32, 0x42, 0x7b, 0x32, 0x43, 0x7b, 0x32, 0x44,
    0x7b, 0x32, 0x45, 0x7b, 0x32, 0x46, 0x7b, 0x32, 0x47, 0x7b, 0x32, 0x48,
    0x7b, 0x32, 0x49, 0x7b, 0x32, 0x4a, 0x7b, 0x32, 0x4b, 0x7b, 0x32, 0x4c,
    0x7b, 0x32, 0x4d, 0x7b, 0x32, 0x4e, 0x7b, 0x32, 0x4f, 0x7b, 0x32, 0x50,
    0x7b, 0x32, 0x51, 0x7b, 0x32, 0x52, 0x7b, 0x32, 0x53, 0x7b, 0x32, 0x54,
    0x7b, 0x32, 0x55, 0x7b, 0x32, 0x56, 0x7b, 0x32, 0x57, 0x7b, 0x32, 0x59,
    0x7b, 0x32, 0x6a, 0x7b, 0x32, 0x6b, 0x7b, 0x32, 0x71, 0x7b, 0x32, 0x76,
    0x7b, 0x32, 0x77, 0x7b, 0x32, 0x78, 0x7b, 0x32, 0x79, 0x7b, 0x32, 0x7a};
const uint8_t HuffDecoderCommon::table28_3_emit_[204] = {
    0x7b, 0x61, 0x30, 0x7b, 0x61, 0x31, 0x7b, 0x61, 0x32, 0x7b, 0x61, 0x61,
    0x7b, 0x61, 0x63, 0x7b, 0x61, 0x65, 0x7b, 0x61, 0x69, 0x7b, 0x61, 0x6f,
    0x7b, 0x61, 0x73, 0x7b, 0x61, 0x74, 0x7b, 0x61, 0x20, 0x7b, 0x61, 0x25,
    0x7b, 0x61, 0x2d, 0x7b, 0x61, 0x2e, 0x7b, 0x61, 0x2f, 0x7b, 0x61, 0x33,
    0x7b, 0x61, 0x34, 0x7b, 0x61, 0x35, 0x7b, 0x61, 0x36, 0x7b, 0x61, 0x37,
    0x7b, 0x61, 0x38, 0x7b, 0x61, 0x39, 0x7b, 0x61, 0x3d, 0x7b, 0x61, 0x41,
    0x7b, 0x61, 0x5f, 0x7b, 0x61, 0x62, 0x7b, 0x61, 0x64, 0x7b, 0x61, 0x66,
    0x7b, 0x61, 0x67, 0x7b, 0x61, 0x68, 0x7b, 0x61, 0x6c, 0x7b, 0x61, 0x6d,
    0x7b, 0x61, 0x6e, 0x7b, 0x61, 0x70, 0x7b, 0x61, 0x72, 0x7b, 0x61, 0x75,
    0x7b, 0x61, 0x3a, 0x7b, 0x61, 0x42, 0x7b, 0x61, 0x43, 0x7b, 0x61, 0x44,
    0x7b, 0x61, 0x45, 0x7b, 0x61, 0x46, 0x7b, 0x61, 0x47, 0x7b, 0x61, 0x48,
    0x7b, 0x61, 0x49, 0x7b, 0x61, 0x4a, 0x7b, 0x61, 0x4b, 0x7b, 0x61, 0x4c,
    0x7b, 0x61, 0x4d, 0x7b, 0x61, 0x4e, 0x7b, 0x61, 0x4f, 0x7b, 0x61, 0x50,
    0x7b, 0x61, 0x51, 0x7b, 0x61, 0x52, 0x7b, 0x61, 0x53, 0x7b, 0x61, 0x54,
    0x7b, 0x61, 0x55, 0x7b, 0x61, 0x56, 0x7b, 0x61, 0x57, 0x7b, 0x61, 0x59,
    0x7b, 0x61, 0x6a, 0x7b, 0x61, 0x6b, 0x7b, 0x61, 0x71, 0x7b, 0x61, 0x76,
    0x7b, 0x61, 0x77, 0x7b, 0x61, 0x78, 0x7b, 0x61, 0x79, 0x7b, 0x61, 0x7a};
const uint8_t HuffDecoderCommon::table28_4_emit_[204] = {
    0x7b, 0x63, 0x30, 0x7b, 0x63, 0x31, 0x7b, 0x63, 0x32, 0x7b, 0x63, 0x61,
    0x7b, 0x63, 0x63, 0x7b, 0x63, 0x65, 0x7b, 0x63, 0x69, 0x7b, 0x63, 0x6f,
    0x7b, 0x63, 0x73, 0x7b, 0x63, 0x74, 0x7b, 0x63, 0x20, 0x7b, 0x63, 0x25,
    0x7b, 0x63, 0x2d, 0x7b, 0x63, 0x2e, 0x7b, 0x63, 0x2f, 0x7b, 0x63, 0x33,
    0x7b, 0x63, 0x34, 0x7b, 0x63, 0x35, 0x7b, 0x63, 0x36, 0x7b, 0x63, 0x37,
    0x7b, 0x63, 0x38, 0x7b, 0x63, 0x39, 0x7b, 0x63, 0x3d, 0x7b, 0x63, 0x41,
    0x7b, 0x63, 0x5f, 0x7b, 0x63, 0x62, 0x7b, 0x63, 0x64, 0x7b, 0x63, 0x66,
    0x7b, 0x63, 0x67, 0x7b, 0x63, 0x68, 0x7b, 0x63, 0x6c, 0x7b, 0x63, 0x6d,
    0x7b, 0x63, 0x6e, 0x7b, 0x63, 0x70, 0x7b, 0x63, 0x72, 0x7b, 0x63, 0x75,
    0x7b, 0x63, 0x3a, 0x7b, 0x63, 0x42, 0x7b, 0x63, 0x43, 0x7b, 0x63, 0x44,
    0x7b, 0x63, 0x45, 0x7b, 0x63, 0x46, 0x7b, 0x63, 0x47, 0x7b, 0x63, 0x48,
    0x7b, 0x63, 0x49, 0x7b, 0x63, 0x4a, 0x7b, 0x63, 0x4b, 0x7b, 0x63, 0x4c,
    0x7b, 0x63, 0x4d, 0x7b, 0x63, 0x4e, 0x7b, 0x63, 0x4f, 0x7b, 0x63, 0x50,
    0x7b, 0x63, 0x51, 0x7b, 0x63, 0x52, 0x7b, 0x63, 0x53, 0x7b, 0x63, 0x54,
    0x7b, 0x63, 0x55, 0x7b, 0x63, 0x56, 0x7b, 0x63, 0x57, 0x7b, 0x63, 0x59,
    0x7b, 0x63, 0x6a, 0x7b, 0x63, 0x6b, 0x7b, 0x63, 0x71, 0x7b, 0x63, 0x76,
    0x7b, 0x63, 0x77, 0x7b, 0x63, 0x78, 0x7b, 0x63, 0x79, 0x7b, 0x63, 0x7a};
const uint8_t HuffDecoderCommon::table28_5_emit_[204] = {
    0x7b, 0x65, 0x30, 0x7b, 0x65, 0x31, 0x7b, 0x65, 0x32, 0x7b, 0x65, 0x61,
    0x7b, 0x65, 0x63, 0x7b, 0x65, 0x65, 0x7b, 0x65, 0x69, 0x7b, 0x65, 0x6f,
    0x7b, 0x65, 0x73, 0x7b, 0x65, 0x74, 0x7b, 0x65, 0x20, 0x7b, 0x65, 0x25,
    0x7b, 0x65, 0x2d, 0x7b, 0x65, 0x2e, 0x7b, 0x65, 0x2f, 0x7b, 0x65, 0x33,
    0x7b, 0x65, 0x34, 0x7b, 0x65, 0x35, 0x7b, 0x65, 0x36, 0x7b, 0x65, 0x37,
    0x7b, 0x65, 0x38, 0x7b, 0x65, 0x39, 0x7b, 0x65, 0x3d, 0x7b, 0x65, 0x41,
    0x7b, 0x65, 0x5f, 0x7b, 0x65, 0x62, 0x7b, 0x65, 0x64, 0x7b, 0x65, 0x66,
    0x7b, 0x65, 0x67, 0x7b, 0x65, 0x68, 0x7b, 0x65, 0x6c, 0x7b, 0x65, 0x6d,
    0x7b, 0x65, 0x6e, 0x7b, 0x65, 0x70, 0x7b, 0x65, 0x72, 0x7b, 0x65, 0x75,
    0x7b, 0x65, 0x3a, 0x7b, 0x65, 0x42, 0x7b, 0x65, 0x43, 0x7b, 0x65, 0x44,
    0x7b, 0x65, 0x45, 0x7b, 0x65, 0x46, 0x7b, 0x65, 0x47, 0x7b, 0x65, 0x48,
    0x7b, 0x65, 0x49, 0x7b, 0x65, 0x4a, 0x7b, 0x65, 0x4b, 0x7b, 0x65, 0x4c,
    0x7b, 0x65, 0x4d, 0x7b, 0x65, 0x4e, 0x7b, 0x65, 0x4f, 0x7b, 0x65, 0x50,
    0x7b, 0x65, 0x51, 0x7b, 0x65, 0x52, 0x7b, 0x65, 0x53, 0x7b, 0x65, 0x54,
    0x7b, 0x65, 0x55, 0x7b, 0x65, 0x56, 0x7b, 0x65, 0x57, 0x7b, 0x65, 0x59,
    0x7b, 0x65, 0x6a, 0x7b, 0x65, 0x6b, 0x7b, 0x65, 0x71, 0x7b, 0x65, 0x76,
    0x7b, 0x65, 0x77, 0x7b, 0x65, 0x78, 0x7b, 0x65, 0x79, 0x7b, 0x65, 0x7a};
const uint8_t HuffDecoderCommon::table28_6_emit_[204] = {
    0x7b, 0x69, 0x30, 0x7b, 0x69, 0x31, 0x7b, 0x69, 0x32, 0x7b, 0x69, 0x61,
    0x7b, 0x69, 0x63, 0x7b, 0x69, 0x65, 0x7b, 0x69, 0x69, 0x7b, 0x69, 0x6f,
    0x7b, 0x69, 0x73, 0x7b, 0x69, 0x74, 0x7b, 0x69, 0x20, 0x7b, 0x69, 0x25,
    0x7b, 0x69, 0x2d, 0x7b, 0x69, 0x2e, 0x7b, 0x69, 0x2f, 0x7b, 0x69, 0x33,
    0x7b, 0x69, 0x34, 0x7b, 0x69, 0x35, 0x7b, 0x69, 0x36, 0x7b, 0x69, 0x37,
    0x7b, 0x69, 0x38, 0x7b, 0x69, 0x39, 0x7b, 0x69, 0x3d, 0x7b, 0x69, 0x41,
    0x7b, 0x69, 0x5f, 0x7b, 0x69, 0x62, 0x7b, 0x69, 0x64, 0x7b, 0x69, 0x66,
    0x7b, 0x69, 0x67, 0x7b, 0x69, 0x68, 0x7b, 0x69, 0x6c, 0x7b, 0x69, 0x6d,
    0x7b, 0x69, 0x6e, 0x7b, 0x69, 0x70, 0x7b, 0x69, 0x72, 0x7b, 0x69, 0x75,
    0x7b, 0x69, 0x3a, 0x7b, 0x69, 0x42, 0x7b, 0x69, 0x43, 0x7b, 0x69, 0x44,
    0x7b, 0x69, 0x45, 0x7b, 0x69, 0x46, 0x7b, 0x69, 0x47, 0x7b, 0x69, 0x48,
    0x7b, 0x69, 0x49, 0x7b, 0x69, 0x4a, 0x7b, 0x69, 0x4b, 0x7b, 0x69, 0x4c,
    0x7b, 0x69, 0x4d, 0x7b, 0x69, 0x4e, 0x7b, 0x69, 0x4f, 0x7b, 0x69, 0x50,
    0x7b, 0x69, 0x51, 0x7b, 0x69, 0x52, 0x7b, 0x69, 0x53, 0x7b, 0x69, 0x54,
    0x7b, 0x69, 0x55, 0x7b, 0x69, 0x56, 0x7b, 0x69, 0x57, 0x7b, 0x69, 0x59,
    0x7b, 0x69, 0x6a, 0x7b, 0x69, 0x6b, 0x7b, 0x69, 0x71, 0x7b, 0x69, 0x76,
    0x7b, 0x69, 0x77, 0x7b, 0x69, 0x78, 0x7b, 0x69, 0x79, 0x7b, 0x69, 0x7a};
const uint8_t HuffDecoderCommon::table28_7_emit_[204] = {
    0x7b, 0x6f, 0x30, 0x7b, 0x6f, 0x31, 0x7b, 0x6f, 0x32, 0x7b, 0x6f, 0x61,
    0x7b, 0x6f, 0x63, 0x7b, 0x6f, 0x65, 0x7b, 0x6f, 0x69, 0x7b, 0x6f, 0x6f,
    0x7b, 0x6f, 0x73, 0x7b, 0x6f, 0x74, 0x7b, 0x6f, 0x20, 0x7b, 0x6f, 0x25,
    0x7b, 0x6f, 0x2d, 0x7b, 0x6f, 0x2e, 0x7b, 0x6f, 0x2f, 0x7b, 0x6f, 0x33,
    0x7b, 0x6f, 0x34, 0x7b, 0x6f, 0x35, 0x7b, 0x6f, 0x36, 0x7b, 0x6f, 0x37,
    0x7b, 0x6f, 0x38, 0x7b, 0x6f, 0x39, 0x7b, 0x6f, 0x3d, 0x7b, 0x6f, 0x41,
    0x7b, 0x6f, 0x5f, 0x7b, 0x6f, 0x62, 0x7b, 0x6f, 0x64, 0x7b, 0x6f, 0x66,
    0x7b, 0x6f, 0x67, 0x7b, 0x6f, 0x68, 0x7b, 0x6f, 0x6c, 0x7b, 0x6f, 0x6d,
    0x7b, 0x6f, 0x6e, 0x7b, 0x6f, 0x70, 0x7b, 0x6f, 0x72, 0x7b, 0x6f, 0x75,
    0x7b, 0x6f, 0x3a, 0x7b, 0x6f, 0x42, 0x7b, 0x6f, 0x43, 0x7b, 0x6f, 0x44,
    0x7b, 0x6f, 0x45, 0x7b, 0x6f, 0x46, 0x7b, 0x6f, 0x47, 0x7b, 0x6f, 0x48,
    0x7b, 0x6f, 0x49, 0x7b, 0x6f, 0x4a, 0x7b, 0x6f, 0x4b, 0x7b, 0x6f, 0x4c,
    0x7b, 0x6f, 0x4d, 0x7b, 0x6f, 0x4e, 0x7b, 0x6f, 0x4f, 0x7b, 0x6f, 0x50,
    0x7b, 0x6f, 0x51, 0x7b, 0x6f, 0x52, 0x7b, 0x6f, 0x53, 0x7b, 0x6f, 0x54,
    0x7b, 0x6f, 0x55, 0x7b, 0x6f, 0x56, 0x7b, 0x6f, 0x57, 0x7b, 0x6f, 0x59,
    0x7b, 0x6f, 0x6a, 0x7b, 0x6f, 0x6b, 0x7b, 0x6f, 0x71, 0x7b, 0x6f, 0x76,
    0x7b, 0x6f, 0x77, 0x7b, 0x6f, 0x78, 0x7b, 0x6f, 0x79, 0x7b, 0x6f, 0x7a};
const uint8_t HuffDecoderCommon::table28_8_emit_[204] = {
    0x7b, 0x73, 0x30, 0x7b, 0x73, 0x31, 0x7b, 0x73, 0x32, 0x7b, 0x73, 0x61,
    0x7b, 0x73, 0x63, 0x7b, 0x73, 0x65, 0x7b, 0x73, 0x69, 0x7b, 0x73, 0x6f,
    0x7b, 0x73, 0x73, 0x7b, 0x73, 0x74, 0x7b, 0x73, 0x20, 0x7b, 0x73, 0x25,
    0x7b, 0x73, 0x2d, 0x7b, 0x73, 0x2e, 0x7b, 0x73, 0x2f, 0x7b, 0x73, 0x33,
    0x7b, 0x73, 0x34, 0x7b, 0x73, 0x35, 0x7b, 0x73, 0x36, 0x7b, 0x73, 0x37,
    0x7b, 0x73, 0x38, 0x7b, 0x73, 0x39, 0x7b, 0x73, 0x3d, 0x7b, 0x73, 0x41,
    0x7b, 0x73, 0x5f, 0x7b, 0x73, 0x62, 0x7b, 0x73, 0x64, 0x7b, 0x73, 0x66,
    0x7b, 0x73, 0x67, 0x7b, 0x73, 0x68, 0x7b, 0x73, 0x6c, 0x7b, 0x73, 0x6d,
    0x7b, 0x73, 0x6e, 0x7b, 0x73, 0x70, 0x7b, 0x73, 0x72, 0x7b, 0x73, 0x75,
    0x7b, 0x73, 0x3a, 0x7b, 0x73, 0x42, 0x7b, 0x73, 0x43, 0x7b, 0x73, 0x44,
    0x7b, 0x73, 0x45, 0x7b, 0x73, 0x46, 0x7b, 0x73, 0x47, 0x7b, 0x73, 0x48,
    0x7b, 0x73, 0x49, 0x7b, 0x73, 0x4a, 0x7b, 0x73, 0x4b, 0x7b, 0x73, 0x4c,
    0x7b, 0x73, 0x4d, 0x7b, 0x73, 0x4e, 0x7b, 0x73, 0x4f, 0x7b, 0x73, 0x50,
    0x7b, 0x73, 0x51, 0x7b, 0x73, 0x52, 0x7b, 0x73, 0x53, 0x7b, 0x73, 0x54,
    0x7b, 0x73, 0x55, 0x7b, 0x73, 0x56, 0x7b, 0x73, 0x57, 0x7b, 0x73, 0x59,
    0x7b, 0x73, 0x6a, 0x7b, 0x73, 0x6b, 0x7b, 0x73, 0x71, 0x7b, 0x73, 0x76,
    0x7b, 0x73, 0x77, 0x7b, 0x73, 0x78, 0x7b, 0x73, 0x79, 0x7b, 0x73, 0x7a};
const uint8_t HuffDecoderCommon::table28_9_emit_[204] = {
    0x7b, 0x74, 0x30, 0x7b, 0x74, 0x31, 0x7b, 0x74, 0x32, 0x7b, 0x74, 0x61,
    0x7b, 0x74, 0x63, 0x7b, 0x74, 0x65, 0x7b, 0x74, 0x69, 0x7b, 0x74, 0x6f,
    0x7b, 0x74, 0x73, 0x7b, 0x74, 0x74, 0x7b, 0x74, 0x20, 0x7b, 0x74, 0x25,
    0x7b, 0x74, 0x2d, 0x7b, 0x74, 0x2e, 0x7b, 0x74, 0x2f, 0x7b, 0x74, 0x33,
    0x7b, 0x74, 0x34, 0x7b, 0x74, 0x35, 0x7b, 0x74, 0x36, 0x7b, 0x74, 0x37,
    0x7b, 0x74, 0x38, 0x7b, 0x74, 0x39, 0x7b, 0x74, 0x3d, 0x7b, 0x74, 0x41,
    0x7b, 0x74, 0x5f, 0x7b, 0x74, 0x62, 0x7b, 0x74, 0x64, 0x7b, 0x74, 0x66,
    0x7b, 0x74, 0x67, 0x7b, 0x74, 0x68, 0x7b, 0x74, 0x6c, 0x7b, 0x74, 0x6d,
    0x7b, 0x74, 0x6e, 0x7b, 0x74, 0x70, 0x7b, 0x74, 0x72, 0x7b, 0x74, 0x75,
    0x7b, 0x74, 0x3a, 0x7b, 0x74, 0x42, 0x7b, 0x74, 0x43, 0x7b, 0x74, 0x44,
    0x7b, 0x74, 0x45, 0x7b, 0x74, 0x46, 0x7b, 0x74, 0x47, 0x7b, 0x74, 0x48,
    0x7b, 0x74, 0x49, 0x7b, 0x74, 0x4a, 0x7b, 0x74, 0x4b, 0x7b, 0x74, 0x4c,
    0x7b, 0x74, 0x4d, 0x7b, 0x74, 0x4e, 0x7b, 0x74, 0x4f, 0x7b, 0x74, 0x50,
    0x7b, 0x74, 0x51, 0x7b, 0x74, 0x52, 0x7b, 0x74, 0x53, 0x7b, 0x74, 0x54,
    0x7b, 0x74, 0x55, 0x7b, 0x74, 0x56, 0x7b, 0x74, 0x57, 0x7b, 0x74, 0x59,
    0x7b, 0x74, 0x6a, 0x7b, 0x74, 0x6b, 0x7b, 0x74, 0x71, 0x7b, 0x74, 0x76,
    0x7b, 0x74, 0x77, 0x7b, 0x74, 0x78, 0x7b, 0x74, 0x79, 0x7b, 0x74, 0x7a};
const uint8_t HuffDecoderCommon::table28_10_emit_[216] = {
    0x7b, 0x20, 0x30, 0x7b, 0x20, 0x31, 0x7b, 0x20, 0x32, 0x7b, 0x20, 0x61,
    0x7b, 0x20, 0x63, 0x7b, 0x20, 0x65, 0x7b, 0x20, 0x69, 0x7b, 0x20, 0x6f,
    0x7b, 0x20, 0x73, 0x7b, 0x20, 0x74, 0x7b, 0x20, 0x20, 0x7b, 0x20, 0x25,
    0x7b, 0x20, 0x2d, 0x7b, 0x20, 0x2e, 0x7b, 0x20, 0x2f, 0x7b, 0x20, 0x33,
    0x7b, 0x20, 0x34, 0x7b, 0x20, 0x35, 0x7b, 0x20, 0x36, 0x7b, 0x20, 0x37,
    0x7b, 0x20, 0x38, 0x7b, 0x20, 0x39, 0x7b, 0x20, 0x3d, 0x7b, 0x20, 0x41,
    0x7b, 0x20, 0x5f, 0x7b, 0x20, 0x62, 0x7b, 0x20, 0x64, 0x7b, 0x20, 0x66,
    0x7b, 0x20, 0x67, 0x7b, 0x20, 0x68, 0x7b, 0x20, 0x6c, 0x7b, 0x20, 0x6d,
    0x7b, 0x20, 0x6e, 0x7b, 0x20, 0x70, 0x7b, 0x20, 0x72, 0x7b, 0x20, 0x75,
    0x7b, 0x25, 0x30, 0x7b, 0x25, 0x31, 0x7b, 0x25, 0x32, 0x7b, 0x25, 0x61,
    0x7b, 0x25, 0x63, 0x7b, 0x25, 0x65, 0x7b, 0x25, 0x69, 0x7b, 0x25, 0x6f,
    0x7b, 0x25, 0x73, 0x7b, 0x25, 0x74, 0x7b, 0x25, 0x20, 0x7b, 0x25, 0x25,
    0x7b, 0x25, 0x2d, 0x7b, 0x25, 0x2e, 0x7b, 0x25, 0x2f, 0x7b, 0x25, 0x33,
    0x7b, 0x25, 0x34, 0x7b, 0x25, 0x35, 0x7b, 0x25, 0x36, 0x7b, 0x25, 0x37,
    0x7b, 0x25, 0x38, 0x7b, 0x25, 0x39, 0x7b, 0x25, 0x3d, 0x7b, 0x25, 0x41,
    0x7b, 0x25, 0x5f, 0x7b, 0x25, 0x62, 0x7b, 0x25, 0x64, 0x7b, 0x25, 0x66,
    0x7b, 0x25, 0x67, 0x7b, 0x25, 0x68, 0x7b, 0x25, 0x6c, 0x7b, 0x25, 0x6d,
    0x7b, 0x25, 0x6e, 0x7b, 0x25, 0x70, 0x7b, 0x25, 0x72, 0x7b, 0x25, 0x75};
const uint16_t HuffDecoderCommon::table28_10_ops_[128] = {
    0x0000, 0x0001, 0x0000, 0x0019, 0x0000, 0x0031, 0x0000, 0x0049, 0x0000,
    0x0061, 0x0000, 0x0079, 0x0000, 0x0091, 0x0000, 0x00a9, 0x0000, 0x00c1,
    0x0000, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169, 0x0181,
    0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259,
    0x0271, 0x0289, 0x02a1, 0x02b9, 0x02d1, 0x02e9, 0x0301, 0x0319, 0x0331,
    0x0349, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0002, 0x0000, 0x0361, 0x0000, 0x0379, 0x0000, 0x0391, 0x0000, 0x03a9,
    0x0000, 0x03c1, 0x0000, 0x03d9, 0x0000, 0x03f1, 0x0000, 0x0409, 0x0000,
    0x0421, 0x0000, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9,
    0x04e1, 0x04f9, 0x0511, 0x0529, 0x0541, 0x0559, 0x0571, 0x0589, 0x05a1,
    0x05b9, 0x05d1, 0x05e9, 0x0601, 0x0619, 0x0631, 0x0649, 0x0661, 0x0679,
    0x0691, 0x06a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0362};
const uint8_t HuffDecoderCommon::table28_11_emit_[216] = {
    0x7b, 0x2d, 0x30, 0x7b, 0x2d, 0x31, 0x7b, 0x2d, 0x32, 0x7b, 0x2d, 0x61,
    0x7b, 0x2d, 0x63, 0x7b, 0x2d, 0x65, 0x7b, 0x2d, 0x69, 0x7b, 0x2d, 0x6f,
    0x7b, 0x2d, 0x73, 0x7b, 0x2d, 0x74, 0x7b, 0x2d, 0x20, 0x7b, 0x2d, 0x25,
    0x7b, 0x2d, 0x2d, 0x7b, 0x2d, 0x2e, 0x7b, 0x2d, 0x2f, 0x7b, 0x2d, 0x33,
    0x7b, 0x2d, 0x34, 0x7b, 0x2d, 0x35, 0x7b, 0x2d, 0x36, 0x7b, 0x2d, 0x37,
    0x7b, 0x2d, 0x38, 0x7b, 0x2d, 0x39, 0x7b, 0x2d, 0x3d, 0x7b, 0x2d, 0x41,
    0x7b, 0x2d, 0x5f, 0x7b, 0x2d, 0x62, 0x7b, 0x2d, 0x64, 0x7b, 0x2d, 0x66,
    0x7b, 0x2d, 0x67, 0x7b, 0x2d, 0x68, 0x7b, 0x2d, 0x6c, 0x7b, 0x2d, 0x6d,
    0x7b, 0x2d, 0x6e, 0x7b, 0x2d, 0x70, 0x7b, 0x2d, 0x72, 0x7b, 0x2d, 0x75,
    0x7b, 0x2e, 0x30, 0x7b, 0x2e, 0x31, 0x7b, 0x2e, 0x32, 0x7b, 0x2e, 0x61,
    0x7b, 0x2e, 0x63, 0x7b, 0x2e, 0x65, 0x7b, 0x2e, 0x69, 0x7b, 0x2e, 0x6f,
    0x7b, 0x2e, 0x73, 0x7b, 0x2e, 0x74, 0x7b, 0x2e, 0x20, 0x7b, 0x2e, 0x25,
    0x7b, 0x2e, 0x2d, 0x7b, 0x2e, 0x2e, 0x7b, 0x2e, 0x2f, 0x7b, 0x2e, 0x33,
    0x7b, 0x2e, 0x34, 0x7b, 0x2e, 0x35, 0x7b, 0x2e, 0x36, 0x7b, 0x2e, 0x37,
    0x7b, 0x2e, 0x38, 0x7b, 0x2e, 0x39, 0x7b, 0x2e, 0x3d, 0x7b, 0x2e, 0x41,
    0x7b, 0x2e, 0x5f, 0x7b, 0x2e, 0x62, 0x7b, 0x2e, 0x64, 0x7b, 0x2e, 0x66,
    0x7b, 0x2e, 0x67, 0x7b, 0x2e, 0x68, 0x7b, 0x2e, 0x6c, 0x7b, 0x2e, 0x6d,
    0x7b, 0x2e, 0x6e, 0x7b, 0x2e, 0x70, 0x7b, 0x2e, 0x72, 0x7b, 0x2e, 0x75};
const uint8_t HuffDecoderCommon::table28_12_emit_[216] = {
    0x7b, 0x2f, 0x30, 0x7b, 0x2f, 0x31, 0x7b, 0x2f, 0x32, 0x7b, 0x2f, 0x61,
    0x7b, 0x2f, 0x63, 0x7b, 0x2f, 0x65, 0x7b, 0x2f, 0x69, 0x7b, 0x2f, 0x6f,
    0x7b, 0x2f, 0x73, 0x7b, 0x2f, 0x74, 0x7b, 0x2f, 0x20, 0x7b, 0x2f, 0x25,
    0x7b, 0x2f, 0x2d, 0x7b, 0x2f, 0x2e, 0x7b, 0x2f, 0x2f, 0x7b, 0x2f, 0x33,
    0x7b, 0x2f, 0x34, 0x7b, 0x2f, 0x35, 0x7b, 0x2f, 0x36, 0x7b, 0x2f, 0x37,
    0x7b, 0x2f, 0x38, 0x7b, 0x2f, 0x39, 0x7b, 0x2f, 0x3d, 0x7b, 0x2f, 0x41,
    0x7b, 0x2f, 0x5f, 0x7b, 0x2f, 0x62, 0x7b, 0x2f, 0x64, 0x7b, 0x2f, 0x66,
    0x7b, 0x2f, 0x67, 0x7b, 0x2f, 0x68, 0x7b, 0x2f, 0x6c, 0x7b, 0x2f, 0x6d,
    0x7b, 0x2f, 0x6e, 0x7b, 0x2f, 0x70, 0x7b, 0x2f, 0x72, 0x7b, 0x2f, 0x75,
    0x7b, 0x33, 0x30, 0x7b, 0x33, 0x31, 0x7b, 0x33, 0x32, 0x7b, 0x33, 0x61,
    0x7b, 0x33, 0x63, 0x7b, 0x33, 0x65, 0x7b, 0x33, 0x69, 0x7b, 0x33, 0x6f,
    0x7b, 0x33, 0x73, 0x7b, 0x33, 0x74, 0x7b, 0x33, 0x20, 0x7b, 0x33, 0x25,
    0x7b, 0x33, 0x2d, 0x7b, 0x33, 0x2e, 0x7b, 0x33, 0x2f, 0x7b, 0x33, 0x33,
    0x7b, 0x33, 0x34, 0x7b, 0x33, 0x35, 0x7b, 0x33, 0x36, 0x7b, 0x33, 0x37,
    0x7b, 0x33, 0x38, 0x7b, 0x33, 0x39, 0x7b, 0x33, 0x3d, 0x7b, 0x33, 0x41,
    0x7b, 0x33, 0x5f, 0x7b, 0x33, 0x62, 0x7b, 0x33, 0x64, 0x7b, 0x33, 0x66,
    0x7b, 0x33, 0x67, 0x7b, 0x33, 0x68, 0x7b, 0x33, 0x6c, 0x7b, 0x33, 0x6d,
    0x7b, 0x33, 0x6e, 0x7b, 0x33, 0x70, 0x7b, 0x33, 0x72, 0x7b, 0x33, 0x75};
const uint8_t HuffDecoderCommon::table28_13_emit_[216] = {
    0x7b, 0x34, 0x30, 0x7b, 0x34, 0x31, 0x7b, 0x34, 0x32, 0x7b, 0x34, 0x61,
    0x7b, 0x34, 0x63, 0x7b, 0x34, 0x65, 0x7b, 0x34, 0x69, 0x7b, 0x34, 0x6f,
    0x7b, 0x34, 0x73, 0x7b, 0x34, 0x74, 0x7b, 0x34, 0x20, 0x7b, 0x34, 0x25,
    0x7b, 0x34, 0x2d, 0x7b, 0x34, 0x2e, 0x7b, 0x34, 0x2f, 0x7b, 0x34, 0x33,
    0x7b, 0x34, 0x34, 0x7b, 0x34, 0x35, 0x7b, 0x34, 0x36, 0x7b, 0x34, 0x37,
    0x7b, 0x34, 0x38, 0x7b, 0x34, 0x39, 0x7b, 0x34, 0x3d, 0x7b, 0x34, 0x41,
    0x7b, 0x34, 0x5f, 0x7b, 0x34, 0x62, 0x7b, 0x34, 0x64, 0x7b, 0x34, 0x66,
    0x7b, 0x34, 0x67, 0x7b, 0x34, 0x68, 0x7b, 0x34, 0x6c, 0x7b, 0x34, 0x6d,
    0x7b, 0x34, 0x6e, 0x7b, 0x34, 0x70, 0x7b, 0x34, 0x72, 0x7b, 0x34, 0x75,
    0x7b, 0x35, 0x30, 0x7b, 0x35, 0x31, 0x7b, 0x35, 0x32, 0x7b, 0x35, 0x61,
    0x7b, 0x35, 0x63, 0x7b, 0x35, 0x65, 0x7b, 0x35, 0x69, 0x7b, 0x35, 0x6f,
    0x7b, 0x35, 0x73, 0x7b, 0x35, 0x74, 0x7b, 0x35, 0x20, 0x7b, 0x35, 0x25,
    0x7b, 0x35, 0x2d, 0x7b, 0x35, 0x2e, 0x7b, 0x35, 0x2f, 0x7b, 0x35, 0x33,
    0x7b, 0x35, 0x34, 0x7b, 0x35, 0x35, 0x7b, 0x35, 0x36, 0x7b, 0x35, 0x37,
    0x7b, 0x35, 0x38, 0x7b, 0x35, 0x39, 0x7b, 0x35, 0x3d, 0x7b, 0x35, 0x41,
    0x7b, 0x35, 0x5f, 0x7b, 0x35, 0x62, 0x7b, 0x35, 0x64, 0x7b, 0x35, 0x66,
    0x7b, 0x35, 0x67, 0x7b, 0x35, 0x68, 0x7b, 0x35, 0x6c, 0x7b, 0x35, 0x6d,
    0x7b, 0x35, 0x6e, 0x7b, 0x35, 0x70, 0x7b, 0x35, 0x72, 0x7b, 0x35, 0x75};
const uint8_t HuffDecoderCommon::table28_14_emit_[216] = {
    0x7b, 0x36, 0x30, 0x7b, 0x36, 0x31, 0x7b, 0x36, 0x32, 0x7b, 0x36, 0x61,
    0x7b, 0x36, 0x63, 0x7b, 0x36, 0x65, 0x7b, 0x36, 0x69, 0x7b, 0x36, 0x6f,
    0x7b, 0x36, 0x73, 0x7b, 0x36, 0x74, 0x7b, 0x36, 0x20, 0x7b, 0x36, 0x25,
    0x7b, 0x36, 0x2d, 0x7b, 0x36, 0x2e, 0x7b, 0x36, 0x2f, 0x7b, 0x36, 0x33,
    0x7b, 0x36, 0x34, 0x7b, 0x36, 0x35, 0x7b, 0x36, 0x36, 0x7b, 0x36, 0x37,
    0x7b, 0x36, 0x38, 0x7b, 0x36, 0x39, 0x7b, 0x36, 0x3d, 0x7b, 0x36, 0x41,
    0x7b, 0x36, 0x5f, 0x7b, 0x36, 0x62, 0x7b, 0x36, 0x64, 0x7b, 0x36, 0x66,
    0x7b, 0x36, 0x67, 0x7b, 0x36, 0x68, 0x7b, 0x36, 0x6c, 0x7b, 0x36, 0x6d,
    0x7b, 0x36, 0x6e, 0x7b, 0x36, 0x70, 0x7b, 0x36, 0x72, 0x7b, 0x36, 0x75,
    0x7b, 0x37, 0x30, 0x7b, 0x37, 0x31, 0x7b, 0x37, 0x32, 0x7b, 0x37, 0x61,
    0x7b, 0x37, 0x63, 0x7b, 0x37, 0x65, 0x7b, 0x37, 0x69, 0x7b, 0x37, 0x6f,
    0x7b, 0x37, 0x73, 0x7b, 0x37, 0x74, 0x7b, 0x37, 0x20, 0x7b, 0x37, 0x25,
    0x7b, 0x37, 0x2d, 0x7b, 0x37, 0x2e, 0x7b, 0x37, 0x2f, 0x7b, 0x37, 0x33,
    0x7b, 0x37, 0x34, 0x7b, 0x37, 0x35, 0x7b, 0x37, 0x36, 0x7b, 0x37, 0x37,
    0x7b, 0x37, 0x38, 0x7b, 0x37, 0x39, 0x7b, 0x37, 0x3d, 0x7b, 0x37, 0x41,
    0x7b, 0x37, 0x5f, 0x7b, 0x37, 0x62, 0x7b, 0x37, 0x64, 0x7b, 0x37, 0x66,
    0x7b, 0x37, 0x67, 0x7b, 0x37, 0x68, 0x7b, 0x37, 0x6c, 0x7b, 0x37, 0x6d,
    0x7b, 0x37, 0x6e, 0x7b, 0x37, 0x70, 0x7b, 0x37, 0x72, 0x7b, 0x37, 0x75};
const uint8_t HuffDecoderCommon::table28_15_emit_[216] = {
    0x7b, 0x38, 0x30, 0x7b, 0x38, 0x31, 0x7b, 0x38, 0x32, 0x7b, 0x38, 0x61,
    0x7b, 0x38, 0x63, 0x7b, 0x38, 0x65, 0x7b, 0x38, 0x69, 0x7b, 0x38, 0x6f,
    0x7b, 0x38, 0x73, 0x7b, 0x38, 0x74, 0x7b, 0x38, 0x20, 0x7b, 0x38, 0x25,
    0x7b, 0x38, 0x2d, 0x7b, 0x38, 0x2e, 0x7b, 0x38, 0x2f, 0x7b, 0x38, 0x33,
    0x7b, 0x38, 0x34, 0x7b, 0x38, 0x35, 0x7b, 0x38, 0x36, 0x7b, 0x38, 0x37,
    0x7b, 0x38, 0x38, 0x7b, 0x38, 0x39, 0x7b, 0x38, 0x3d, 0x7b, 0x38, 0x41,
    0x7b, 0x38, 0x5f, 0x7b, 0x38, 0x62, 0x7b, 0x38, 0x64, 0x7b, 0x38, 0x66,
    0x7b, 0x38, 0x67, 0x7b, 0x38, 0x68, 0x7b, 0x38, 0x6c, 0x7b, 0x38, 0x6d,
    0x7b, 0x38, 0x6e, 0x7b, 0x38, 0x70, 0x7b, 0x38, 0x72, 0x7b, 0x38, 0x75,
    0x7b, 0x39, 0x30, 0x7b, 0x39, 0x31, 0x7b, 0x39, 0x32, 0x7b, 0x39, 0x61,
    0x7b, 0x39, 0x63, 0x7b, 0x39, 0x65, 0x7b, 0x39, 0x69, 0x7b, 0x39, 0x6f,
    0x7b, 0x39, 0x73, 0x7b, 0x39, 0x74, 0x7b, 0x39, 0x20, 0x7b, 0x39, 0x25,
    0x7b, 0x39, 0x2d, 0x7b, 0x39, 0x2e, 0x7b, 0x39, 0x2f, 0x7b, 0x39, 0x33,
    0x7b, 0x39, 0x34, 0x7b, 0x39, 0x35, 0x7b, 0x39, 0x36, 0x7b, 0x39, 0x37,
    0x7b, 0x39, 0x38, 0x7b, 0x39, 0x39, 0x7b, 0x39, 0x3d, 0x7b, 0x39, 0x41,
    0x7b, 0x39, 0x5f, 0x7b, 0x39, 0x62, 0x7b, 0x39, 0x64, 0x7b, 0x39, 0x66,
    0x7b, 0x39, 0x67, 0x7b, 0x39, 0x68, 0x7b, 0x39, 0x6c, 0x7b, 0x39, 0x6d,
    0x7b, 0x39, 0x6e, 0x7b, 0x39, 0x70, 0x7b, 0x39, 0x72, 0x7b, 0x39, 0x75};
const uint8_t HuffDecoderCommon::table28_16_emit_[216] = {
    0x7b, 0x3d, 0x30, 0x7b, 0x3d, 0x31, 0x7b, 0x3d, 0x32, 0x7b, 0x3d, 0x61,
    0x7b, 0x3d, 0x63, 0x7b, 0x3d, 0x65, 0x7b, 0x3d, 0x69, 0x7b, 0x3d, 0x6f,
    0x7b, 0x3d, 0x73, 0x7b, 0x3d, 0x74, 0x7b, 0x3d, 0x20, 0x7b, 0x3d, 0x25,
    0x7b, 0x3d, 0x2d, 0x7b, 0x3d, 0x2e, 0x7b, 0x3d, 0x2f, 0x7b, 0x3d, 0x33,
    0x7b, 0x3d, 0x34, 0x7b, 0x3d, 0x35, 0x7b, 0x3d, 0x36, 0x7b, 0x3d, 0x37,
    0x7b, 0x3d, 0x38, 0x7b, 0x3d, 0x39, 0x7b, 0x3d, 0x3d, 0x7b, 0x3d, 0x41,
    0x7b, 0x3d, 0x5f, 0x7b, 0x3d, 0x62, 0x7b, 0x3d, 0x64, 0x7b, 0x3d, 0x66,
    0x7b, 0x3d, 0x67, 0x7b, 0x3d, 0x68, 0x7b, 0x3d, 0x6c, 0x7b, 0x3d, 0x6d,
    0x7b, 0x3d, 0x6e, 0x7b, 0x3d, 0x70, 0x7b, 0x3d, 0x72, 0x7b, 0x3d, 0x75,
    0x7b, 0x41, 0x30, 0x7b, 0x41, 0x31, 0x7b, 0x41, 0x32, 0x7b, 0x41, 0x61,
    0x7b, 0x41, 0x63, 0x7b, 0x41, 0x65, 0x7b, 0x41, 0x69, 0x7b, 0x41, 0x6f,
    0x7b, 0x41, 0x73, 0x7b, 0x41, 0x74, 0x7b, 0x41, 0x20, 0x7b, 0x41, 0x25,
    0x7b, 0x41, 0x2d, 0x7b, 0x41, 0x2e, 0x7b, 0x41, 0x2f, 0x7b, 0x41, 0x33,
    0x7b, 0x41, 0x34, 0x7b, 0x41, 0x35, 0x7b, 0x41, 0x36, 0x7b, 0x41, 0x37,
    0x7b, 0x41, 0x38, 0x7b, 0x41, 0x39, 0x7b, 0x41, 0x3d, 0x7b, 0x41, 0x41,
    0x7b, 0x41, 0x5f, 0x7b, 0x41, 0x62, 0x7b, 0x41, 0x64, 0x7b, 0x41, 0x66,
    0x7b, 0x41, 0x67, 0x7b, 0x41, 0x68, 0x7b, 0x41, 0x6c, 0x7b, 0x41, 0x6d,
    0x7b, 0x41, 0x6e, 0x7b, 0x41, 0x70, 0x7b, 0x41, 0x72, 0x7b, 0x41, 0x75};
const uint8_t HuffDecoderCommon::table28_17_emit_[216] = {
    0x7b, 0x5f, 0x30, 0x7b, 0x5f, 0x31, 0x7b, 0x5f, 0x32, 0x7b, 0x5f, 0x61,
    0x7b, 0x5f, 0x63, 0x7b, 0x5f, 0x65, 0x7b, 0x5f, 0x69, 0x7b, 0x5f, 0x6f,
    0x7b, 0x5f, 0x73, 0x7b, 0x5f, 0x74, 0x7b, 0x5f, 0x20, 0x7b, 0x5f, 0x25,
    0x7b, 0x5f, 0x2d, 0x7b, 0x5f, 0x2e, 0x7b, 0x5f, 0x2f, 0x7b, 0x5f, 0x33,
    0x7b, 0x5f, 0x34, 0x7b, 0x5f, 0x35, 0x7b, 0x5f, 0x36, 0x7b, 0x5f, 0x37,
    0x7b, 0x5f, 0x38, 0x7b, 0x5f, 0x39, 0x7b, 0x5f, 0x3d, 0x7b, 0x5f, 0x41,
    0x7b, 0x5f, 0x5f, 0x7b, 0x5f, 0x62, 0x7b, 0x5f, 0x64, 0x7b, 0x5f, 0x66,
    0x7b, 0x5f, 0x67, 0x7b, 0x5f, 0x68, 0x7b, 0x5f, 0x6c, 0x7b, 0x5f, 0x6d,
    0x7b, 0x5f, 0x6e, 0x7b, 0x5f, 0x70, 0x7b, 0x5f, 0x72, 0x7b, 0x5f, 0x75,
    0x7b, 0x62, 0x30, 0x7b, 0x62, 0x31, 0x7b, 0x62, 0x32, 0x7b, 0x62, 0x61,
    0x7b, 0x62, 0x63, 0x7b, 0x62, 0x65, 0x7b, 0x62, 0x69, 0x7b, 0x62, 0x6f,
    0x7b, 0x62, 0x73, 0x7b, 0x62, 0x74, 0x7b, 0x62, 0x20, 0x7b, 0x62, 0x25,
    0x7b, 0x62, 0x2d, 0x7b, 0x62, 0x2e, 0x7b, 0x62, 0x2f, 0x7b, 0x62, 0x33,
    0x7b, 0x62, 0x34, 0x7b, 0x62, 0x35, 0x7b, 0x62, 0x36, 0x7b, 0x62, 0x37,
    0x7b, 0x62, 0x38, 0x7b, 0x62, 0x39, 0x7b, 0x62, 0x3d, 0x7b, 0x62, 0x41,
    0x7b, 0x62, 0x5f, 0x7b, 0x62, 0x62, 0x7b, 0x62, 0x64, 0x7b, 0x62, 0x66,
    0x7b, 0x62, 0x67, 0x7b, 0x62, 0x68, 0x7b, 0x62, 0x6c, 0x7b, 0x62, 0x6d,
    0x7b, 0x62, 0x6e, 0x7b, 0x62, 0x70, 0x7b, 0x62, 0x72, 0x7b, 0x62, 0x75};
const uint8_t HuffDecoderCommon::table28_18_emit_[216] = {
    0x7b, 0x64, 0x30, 0x7b, 0x64, 0x31, 0x7b, 0x64, 0x32, 0x7b, 0x64, 0x61,
    0x7b, 0x64, 0x63, 0x7b, 0x64, 0x65, 0x7b, 0x64, 0x69, 0x7b, 0x64, 0x6f,
    0x7b, 0x64, 0x73, 0x7b, 0x64, 0x74, 0x7b, 0x64, 0x20, 0x7b, 0x64, 0x25,
    0x7b, 0x64, 0x2d, 0x7b, 0x64, 0x2e, 0x7b, 0x64, 0x2f, 0x7b, 0x64, 0x33,
    0x7b, 0x64, 0x34, 0x7b, 0x64, 0x35, 0x7b, 0x64, 0x36, 0x7b, 0x64, 0x37,
    0x7b, 0x64, 0x38, 0x7b, 0x64, 0x39, 0x7b, 0x64, 0x3d, 0x7b, 0x64, 0x41,
    0x7b, 0x64, 0x5f, 0x7b, 0x64, 0x62, 0x7b, 0x64, 0x64, 0x7b, 0x64, 0x66,
    0x7b, 0x64, 0x67, 0x7b, 0x64, 0x68, 0x7b, 0x64, 0x6c, 0x7b, 0x64, 0x6d,
    0x7b, 0x64, 0x6e, 0x7b, 0x64, 0x70, 0x7b, 0x64, 0x72, 0x7b, 0x64, 0x75,
    0x7b, 0x66, 0x30, 0x7b, 0x66, 0x31, 0x7b, 0x66, 0x32, 0x7b, 0x66, 0x61,
    0x7b, 0x66, 0x63, 0x7b, 0x66, 0x65, 0x7b, 0x66, 0x69, 0x7b, 0x66, 0x6f,
    0x7b, 0x66, 0x73, 0x7b, 0x66, 0x74, 0x7b, 0x66, 0x20, 0x7b, 0x66, 0x25,
    0x7b, 0x66, 0x2d, 0x7b, 0x66, 0x2e, 0x7b, 0x66, 0x2f, 0x7b, 0x66, 0x33,
    0x7b, 0x66, 0x34, 0x7b, 0x66, 0x35, 0x7b, 0x66, 0x36, 0x7b, 0x66, 0x37,
    0x7b, 0x66, 0x38, 0x7b, 0x66, 0x39, 0x7b, 0x66, 0x3d, 0x7b, 0x66, 0x41,
    0x7b, 0x66, 0x5f, 0x7b, 0x66, 0x62, 0x7b, 0x66, 0x64, 0x7b, 0x66, 0x66,
    0x7b, 0x66, 0x67, 0x7b, 0x66, 0x68, 0x7b, 0x66, 0x6c, 0x7b, 0x66, 0x6d,
    0x7b, 0x66, 0x6e, 0x7b, 0x66, 0x70, 0x7b, 0x66, 0x72, 0x7b, 0x66, 0x75};
const uint8_t HuffDecoderCommon::table28_19_emit_[216] = {
    0x7b, 0x67, 0x30, 0x7b, 0x67, 0x31, 0x7b, 0x67, 0x32, 0x7b, 0x67, 0x61,
    0x7b, 0x67, 0x63, 0x7b, 0x67, 0x65, 0x7b, 0x67, 0x69, 0x7b, 0x67, 0x6f,
    0x7b, 0x67, 0x73, 0x7b, 0x67, 0x74, 0x7b, 0x67, 0x20, 0x7b, 0x67, 0x25,
    0x7b, 0x67, 0x2d, 0x7b, 0x67, 0x2e, 0x7b, 0x67, 0x2f, 0x7b, 0x67, 0x33,
    0x7b, 0x67, 0x34, 0x7b, 0x67, 0x35, 0x7b, 0x67, 0x36, 0x7b, 0x67, 0x37,
    0x7b, 0x67, 0x38, 0x7b, 0x67, 0x39, 0x7b, 0x67, 0x3d, 0x7b, 0x67, 0x41,
    0x7b, 0x67, 0x5f, 0x7b, 0x67, 0x62, 0x7b, 0x67, 0x64, 0x7b, 0x67, 0x66,
    0x7b, 0x67, 0x67, 0x7b, 0x67, 0x68, 0x7b, 0x67, 0x6c, 0x7b, 0x67, 0x6d,
    0x7b, 0x67, 0x6e, 0x7b, 0x67, 0x70, 0x7b, 0x67, 0x72, 0x7b, 0x67, 0x75,
    0x7b, 0x68, 0x30, 0x7b, 0x68, 0x31, 0x7b, 0x68, 0x32, 0x7b, 0x68, 0x61,
    0x7b, 0x68, 0x63, 0x7b, 0x68, 0x65, 0x7b, 0x68, 0x69, 0x7b, 0x68, 0x6f,
    0x7b, 0x68, 0x73, 0x7b, 0x68, 0x74, 0x7b, 0x68, 0x20, 0x7b, 0x68, 0x25,
    0x7b, 0x68, 0x2d, 0x7b, 0x68, 0x2e, 0x7b, 0x68, 0x2f, 0x7b, 0x68, 0x33,
    0x7b, 0x68, 0x34, 0x7b, 0x68, 0x35, 0x7b, 0x68, 0x36, 0x7b, 0x68, 0x37,
    0x7b, 0x68, 0x38, 0x7b, 0x68, 0x39, 0x7b, 0x68, 0x3d, 0x7b, 0x68, 0x41,
    0x7b, 0x68, 0x5f, 0x7b, 0x68, 0x62, 0x7b, 0x68, 0x64, 0x7b, 0x68, 0x66,
    0x7b, 0x68, 0x67, 0x7b, 0x68, 0x68, 0x7b, 0x68, 0x6c, 0x7b, 0x68, 0x6d,
    0x7b, 0x68, 0x6e, 0x7b, 0x68, 0x70, 0x7b, 0x68, 0x72, 0x7b, 0x68, 0x75};
const uint8_t HuffDecoderCommon::table28_20_emit_[216] = {
    0x7b, 0x6c, 0x30, 0x7b, 0x6c, 0x31, 0x7b, 0x6c, 0x32, 0x7b, 0x6c, 0x61,
    0x7b, 0x6c, 0x63, 0x7b, 0x6c, 0x65, 0x7b, 0x6c, 0x69, 0x7b, 0x6c, 0x6f,
    0x7b, 0x6c, 0x73, 0x7b, 0x6c, 0x74, 0x7b, 0x6c, 0x20, 0x7b, 0x6c, 0x25,
    0x7b, 0x6c, 0x2d, 0x7b, 0x6c, 0x2e, 0x7b, 0x6c, 0x2f, 0x7b, 0x6c, 0x33,
    0x7b, 0x6c, 0x34, 0x7b, 0x6c, 0x35, 0x7b, 0x6c, 0x36, 0x7b, 0x6c, 0x37,
    0x7b, 0x6c, 0x38, 0x7b, 0x6c, 0x39, 0x7b, 0x6c, 0x3d, 0x7b, 0x6c, 0x41,
    0x7b, 0x6c, 0x5f, 0x7b, 0x6c, 0x62, 0x7b, 0x6c, 0x64, 0x7b, 0x6c, 0x66,
    0x7b, 0x6c, 0x67, 0x7b, 0x6c, 0x68, 0x7b, 0x6c, 0x6c, 0x7b, 0x6c, 0x6d,
    0x7b, 0x6c, 0x6e, 0x7b, 0x6c, 0x70, 0x7b, 0x6c, 0x72, 0x7b, 0x6c, 0x75,
    0x7b, 0x6d, 0x30, 0x7b, 0x6d, 0x31, 0x7b, 0x6d, 0x32, 0x7b, 0x6d, 0x61,
    0x7b, 0x6d, 0x63, 0x7b, 0x6d, 0x65, 0x7b, 0x6d, 0x69, 0x7b, 0x6d, 0x6f,
    0x7b, 0x6d, 0x73, 0x7b, 0x6d, 0x74, 0x7b, 0x6d, 0x20, 0x7b, 0x6d, 0x25,
    0x7b, 0x6d, 0x2d, 0x7b, 0x6d, 0x2e, 0x7b, 0x6d, 0x2f, 0x7b, 0x6d, 0x33,
    0x7b, 0x6d, 0x34, 0x7b, 0x6d, 0x35, 0x7b, 0x6d, 0x36, 0x7b, 0x6d, 0x37,
    0x7b, 0x6d, 0x38, 0x7b, 0x6d, 0x39, 0x7b, 0x6d, 0x3d, 0x7b, 0x6d, 0x41,
    0x7b, 0x6d, 0x5f, 0x7b, 0x6d, 0x62, 0x7b, 0x6d, 0x64, 0x7b, 0x6d, 0x66,
    0x7b, 0x6d, 0x67, 0x7b, 0x6d, 0x68, 0x7b, 0x6d, 0x6c, 0x7b, 0x6d, 0x6d,
    0x7b, 0x6d, 0x6e, 0x7b, 0x6d, 0x70, 0x7b, 0x6d, 0x72, 0x7b, 0x6d, 0x75};
const uint8_t HuffDecoderCommon::table28_21_emit_[216] = {
    0x7b, 0x6e, 0x30, 0x7b, 0x6e, 0x31, 0x7b, 0x6e, 0x32, 0x7b, 0x6e, 0x61,
    0x7b, 0x6e, 0x63, 0x7b, 0x6e, 0x65, 0x7b, 0x6e, 0x69, 0x7b, 0x6e, 0x6f,
    0x7b, 0x6e, 0x73, 0x7b, 0x6e, 0x74, 0x7b, 0x6e, 0x20, 0x7b, 0x6e, 0x25,
    0x7b, 0x6e, 0x2d, 0x7b, 0x6e, 0x2e, 0x7b, 0x6e, 0x2f, 0x7b, 0x6e, 0x33,
    0x7b, 0x6e, 0x34, 0x7b, 0x6e, 0x35, 0x7b, 0x6e, 0x36, 0x7b, 0x6e, 0x37,
    0x7b, 0x6e, 0x38, 0x7b, 0x6e, 0x39, 0x7b, 0x6e, 0x3d, 0x7b, 0x6e, 0x41,
    0x7b, 0x6e, 0x5f, 0x7b, 0x6e, 0x62, 0x7b, 0x6e, 0x64, 0x7b, 0x6e, 0x66,
    0x7b, 0x6e, 0x67, 0x7b, 0x6e, 0x68, 0x7b, 0x6e, 0x6c, 0x7b, 0x6e, 0x6d,
    0x7b, 0x6e, 0x6e, 0x7b, 0x6e, 0x70, 0x7b, 0x6e, 0x72, 0x7b, 0x6e, 0x75,
    0x7b, 0x70, 0x30, 0x7b, 0x70, 0x31, 0x7b, 0x70, 0x32, 0x7b, 0x70, 0x61,
    0x7b, 0x70, 0x63, 0x7b, 0x70, 0x65, 0x7b, 0x70, 0x69, 0x7b, 0x70, 0x6f,
    0x7b, 0x70, 0x73, 0x7b, 0x70, 0x74, 0x7b, 0x70, 0x20, 0x7b, 0x70, 0x25,
    0x7b, 0x70, 0x2d, 0x7b, 0x70, 0x2e, 0x7b, 0x70, 0x2f, 0x7b, 0x70, 0x33,
    0x7b, 0x70, 0x34, 0x7b, 0x70, 0x35, 0x7b, 0x70, 0x36, 0x7b, 0x70, 0x37,
    0x7b, 0x70, 0x38, 0x7b, 0x70, 0x39, 0x7b, 0x70, 0x3d, 0x7b, 0x70, 0x41,
    0x7b, 0x70, 0x5f, 0x7b, 0x70, 0x62, 0x7b, 0x70, 0x64, 0x7b, 0x70, 0x66,
    0x7b, 0x70, 0x67, 0x7b, 0x70, 0x68, 0x7b, 0x70, 0x6c, 0x7b, 0x70, 0x6d,
    0x7b, 0x70, 0x6e, 0x7b, 0x70, 0x70, 0x7b, 0x70, 0x72, 0x7b, 0x70, 0x75};
const uint8_t HuffDecoderCommon::table28_22_emit_[216] = {
    0x7b, 0x72, 0x30, 0x7b, 0x72, 0x31, 0x7b, 0x72, 0x32, 0x7b, 0x72, 0x61,
    0x7b, 0x72, 0x63, 0x7b, 0x72, 0x65, 0x7b, 0x72, 0x69, 0x7b, 0x72, 0x6f,
    0x7b, 0x72, 0x73, 0x7b, 0x72, 0x74, 0x7b, 0x72, 0x20, 0x7b, 0x72, 0x25,
    0x7b, 0x72, 0x2d, 0x7b, 0x72, 0x2e, 0x7b, 0x72, 0x2f, 0x7b, 0x72, 0x33,
    0x7b, 0x72, 0x34, 0x7b, 0x72, 0x35, 0x7b, 0x72, 0x36, 0x7b, 0x72, 0x37,
    0x7b, 0x72, 0x38, 0x7b, 0x72, 0x39, 0x7b, 0x72, 0x3d, 0x7b, 0x72, 0x41,
    0x7b, 0x72, 0x5f, 0x7b, 0x72, 0x62, 0x7b, 0x72, 0x64, 0x7b, 0x72, 0x66,
    0x7b, 0x72, 0x67, 0x7b, 0x72, 0x68, 0x7b, 0x72, 0x6c, 0x7b, 0x72, 0x6d,
    0x7b, 0x72, 0x6e, 0x7b, 0x72, 0x70, 0x7b, 0x72, 0x72, 0x7b, 0x72, 0x75,
    0x7b, 0x75, 0x30, 0x7b, 0x75, 0x31, 0x7b, 0x75, 0x32, 0x7b, 0x75, 0x61,
    0x7b, 0x75, 0x63, 0x7b, 0x75, 0x65, 0x7b, 0x75, 0x69, 0x7b, 0x75, 0x6f,
    0x7b, 0x75, 0x73, 0x7b, 0x75, 0x74, 0x7b, 0x75, 0x20, 0x7b, 0x75, 0x25,
    0x7b, 0x75, 0x2d, 0x7b, 0x75, 0x2e, 0x7b, 0x75, 0x2f, 0x7b, 0x75, 0x33,
    0x7b, 0x75, 0x34, 0x7b, 0x75, 0x35, 0x7b, 0x75, 0x36, 0x7b, 0x75, 0x37,
    0x7b, 0x75, 0x38, 0x7b, 0x75, 0x39, 0x7b, 0x75, 0x3d, 0x7b, 0x75, 0x41,
    0x7b, 0x75, 0x5f, 0x7b, 0x75, 0x62, 0x7b, 0x75, 0x64, 0x7b, 0x75, 0x66,
    0x7b, 0x75, 0x67, 0x7b, 0x75, 0x68, 0x7b, 0x75, 0x6c, 0x7b, 0x75, 0x6d,
    0x7b, 0x75, 0x6e, 0x7b, 0x75, 0x70, 0x7b, 0x75, 0x72, 0x7b, 0x75, 0x75};
const uint8_t HuffDecoderCommon::table28_23_emit_[120] = {
    0x7b, 0x3a, 0x30, 0x7b, 0x3a, 0x31, 0x7b, 0x3a, 0x32, 0x7b, 0x3a, 0x61,
    0x7b, 0x3a, 0x63, 0x7b, 0x3a, 0x65, 0x7b, 0x3a, 0x69, 0x7b, 0x3a, 0x6f,
    0x7b, 0x3a, 0x73, 0x7b, 0x3a, 0x74, 0x7b, 0x42, 0x30, 0x7b, 0x42, 0x31,
    0x7b, 0x42, 0x32, 0x7b, 0x42, 0x61, 0x7b, 0x42, 0x63, 0x7b, 0x42, 0x65,
    0x7b, 0x42, 0x69, 0x7b, 0x42, 0x6f, 0x7b, 0x42, 0x73, 0x7b, 0x42, 0x74,
    0x7b, 0x43, 0x30, 0x7b, 0x43, 0x31, 0x7b, 0x43, 0x32, 0x7b, 0x43, 0x61,
    0x7b, 0x43, 0x63, 0x7b, 0x43, 0x65, 0x7b, 0x43, 0x69, 0x7b, 0x43, 0x6f,
    0x7b, 0x43, 0x73, 0x7b, 0x43, 0x74, 0x7b, 0x44, 0x30, 0x7b, 0x44, 0x31,
    0x7b, 0x44, 0x32, 0x7b, 0x44, 0x61, 0x7b, 0x44, 0x63, 0x7b, 0x44, 0x65,
    0x7b, 0x44, 0x69, 0x7b, 0x44, 0x6f, 0x7b, 0x44, 0x73, 0x7b, 0x44, 0x74};
const uint16_t HuffDecoderCommon::table28_23_ops_[128] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9, 0x00c1,
    0x00d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x00f1, 0x0109, 0x0121, 0x0139,
    0x0151, 0x0169, 0x0181, 0x0199, 0x01b1, 0x01c9, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x00f2, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259, 0x0271, 0x0289,
    0x02a1, 0x02b9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01e2, 0x02d1, 0x02e9, 0x0301,
    0x0319, 0x0331, 0x0349, 0x0361, 0x0379, 0x0391, 0x03a9, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x02d2};
const uint8_t HuffDecoderCommon::table28_24_emit_[120] = {
    0x7b, 0x45, 0x30, 0x7b, 0x45, 0x31, 0x7b, 0x45, 0x32, 0x7b, 0x45, 0x61,
    0x7b, 0x45, 0x63, 0x7b, 0x45, 0x65, 0x7b, 0x45, 0x69, 0x7b, 0x45, 0x6f,
    0x7b, 0x45, 0x73, 0x7b, 0x45, 0x74, 0x7b, 0x46, 0x30, 0x7b, 0x46, 0x31,
    0x7b, 0x46, 0x32, 0x7b, 0x46, 0x61, 0x7b, 0x46, 0x63, 0x7b, 0x46, 0x65,
    0x7b, 0x46, 0x69, 0x7b, 0x46, 0x6f, 0x7b, 0x46, 0x73, 0x7b, 0x46, 0x74,
    0x7b, 0x47, 0x30, 0x7b, 0x47, 0x31, 0x7b, 0x47, 0x32, 0x7b, 0x47, 0x61,
    0x7b, 0x47, 0x63, 0x7b, 0x47, 0x65, 0x7b, 0x47, 0x69, 0x7b, 0x47, 0x6f,
    0x7b, 0x47, 0x73, 0x7b, 0x47, 0x74, 0x7b, 0x48, 0x30, 0x7b, 0x48, 0x31,
    0x7b, 0x48, 0x32, 0x7b, 0x48, 0x61, 0x7b, 0x48, 0x63, 0x7b, 0x48, 0x65,
    0x7b, 0x48, 0x69, 0x7b, 0x48, 0x6f, 0x7b, 0x48, 0x73, 0x7b, 0x48, 0x74};
const uint8_t HuffDecoderCommon::table28_25_emit_[120] = {
    0x7b, 0x49, 0x30, 0x7b, 0x49, 0x31, 0x7b, 0x49, 0x32, 0x7b, 0x49, 0x61,
    0x7b, 0x49, 0x63, 0x7b, 0x49, 0x65, 0x7b, 0x49, 0x69, 0x7b, 0x49, 0x6f,
    0x7b, 0x49, 0x73, 0x7b, 0x49, 0x74, 0x7b, 0x4a, 0x30, 0x7b, 0x4a, 0x31,
    0x7b, 0x4a, 0x32, 0x7b, 0x4a, 0x61, 0x7b, 0x4a, 0x63, 0x7b, 0x4a, 0x65,
    0x7b, 0x4a, 0x69, 0x7b, 0x4a, 0x6f, 0x7b, 0x4a, 0x73, 0x7b, 0x4a, 0x74,
    0x7b, 0x4b, 0x30, 0x7b, 0x4b, 0x31, 0x7b, 0x4b, 0x32, 0x7b, 0x4b, 0x61,
    0x7b, 0x4b, 0x63, 0x7b, 0x4b, 0x65, 0x7b, 0x4b, 0x69, 0x7b, 0x4b, 0x6f,
    0x7b, 0x4b, 0x73, 0x7b, 0x4b, 0x74, 0x7b, 0x4c, 0x30, 0x7b, 0x4c, 0x31,
    0x7b, 0x4c, 0x32, 0x7b, 0x4c, 0x61, 0x7b, 0x4c, 0x63, 0x7b, 0x4c, 0x65,
    0x7b, 0x4c, 0x69, 0x7b, 0x4c, 0x6f, 0x7b, 0x4c, 0x73, 0x7b, 0x4c, 0x74};
const uint8_t HuffDecoderCommon::table28_26_emit_[120] = {
    0x7b, 0x4d, 0x30, 0x7b, 0x4d, 0x31, 0x7b, 0x4d, 0x32, 0x7b, 0x4d, 0x61,
    0x7b, 0x4d, 0x63, 0x7b, 0x4d, 0x65, 0x7b, 0x4d, 0x69, 0x7b, 0x4d, 0x6f,
    0x7b, 0x4d, 0x73, 0x7b, 0x4d, 0x74, 0x7b, 0x4e, 0x30, 0x7b, 0x4e, 0x31,
    0x7b, 0x4e, 0x32, 0x7b, 0x4e, 0x61, 0x7b, 0x4e, 0x63, 0x7b, 0x4e, 0x65,
    0x7b, 0x4e, 0x69, 0x7b, 0x4e, 0x6f, 0x7b, 0x4e, 0x73, 0x7b, 0x4e, 0x74,
    0x7b, 0x4f, 0x30, 0x7b, 0x4f, 0x31, 0x7b, 0x4f, 0x32, 0x7b, 0x4f, 0x61,
    0x7b, 0x4f, 0x63, 0x7b, 0x4f, 0x65, 0x7b, 0x4f, 0x69, 0x7b, 0x4f, 0x6f,
    0x7b, 0x4f, 0x73, 0x7b, 0x4f, 0x74, 0x7b, 0x50, 0x30, 0x7b, 0x50, 0x31,
    0x7b, 0x50, 0x32, 0x7b, 0x50, 0x61, 0x7b, 0x50, 0x63, 0x7b, 0x50, 0x65,
    0x7b, 0x50, 0x69, 0x7b, 0x50, 0x6f, 0x7b, 0x50, 0x73, 0x7b, 0x50, 0x74};
const uint8_t HuffDecoderCommon::table28_27_emit_[120] = {
    0x7b, 0x51, 0x30, 0x7b, 0x51, 0x31, 0x7b, 0x51, 0x32, 0x7b, 0x51, 0x61,
    0x7b, 0x51, 0x63, 0x7b, 0x51, 0x65, 0x7b, 0x51, 0x69, 0x7b, 0x51, 0x6f,
    0x7b, 0x51, 0x73, 0x7b, 0x51, 0x74, 0x7b, 0x52, 0x30, 0x7b, 0x52, 0x31,
    0x7b, 0x52, 0x32, 0x7b, 0x52, 0x61, 0x7b, 0x52, 0x63, 0x7b, 0x52, 0x65,
    0x7b, 0x52, 0x69, 0x7b, 0x52, 0x6f, 0x7b, 0x52, 0x73, 0x7b, 0x52, 0x74,
    0x7b, 0x53, 0x30, 0x7b, 0x53, 0x31, 0x7b, 0x53, 0x32, 0x7b, 0x53, 0x61,
    0x7b, 0x53, 0x63, 0x7b, 0x53, 0x65, 0x7b, 0x53, 0x69, 0x7b, 0x53, 0x6f,
    0x7b, 0x53, 0x73, 0x7b, 0x53, 0x74, 0x7b, 0x54, 0x30, 0x7b, 0x54, 0x31,
    0x7b, 0x54, 0x32, 0x7b, 0x54, 0x61, 0x7b, 0x54, 0x63, 0x7b, 0x54, 0x65,
    0x7b, 0x54, 0x69, 0x7b, 0x54, 0x6f, 0x7b, 0x54, 0x73, 0x7b, 0x54, 0x74};
const uint8_t HuffDecoderCommon::table28_28_emit_[120] = {
    0x7b, 0x55, 0x30, 0x7b, 0x55, 0x31, 0x7b, 0x55, 0x32, 0x7b, 0x55, 0x61,
    0x7b, 0x55, 0x63, 0x7b, 0x55, 0x65, 0x7b, 0x55, 0x69, 0x7b, 0x55, 0x6f,
    0x7b, 0x55, 0x73, 0x7b, 0x55, 0x74, 0x7b, 0x56, 0x30, 0x7b, 0x56, 0x31,
    0x7b, 0x56, 0x32, 0x7b, 0x56, 0x61, 0x7b, 0x56, 0x63, 0x7b, 0x56, 0x65,
    0x7b, 0x56, 0x69, 0x7b, 0x56, 0x6f, 0x7b, 0x56, 0x73, 0x7b, 0x56, 0x74,
    0x7b, 0x57, 0x30, 0x7b, 0x57, 0x31, 0x7b, 0x57, 0x32, 0x7b, 0x57, 0x61,
    0x7b, 0x57, 0x63, 0x7b, 0x57, 0x65, 0x7b, 0x57, 0x69, 0x7b, 0x57, 0x6f,
    0x7b, 0x57, 0x73, 0x7b, 0x57, 0x74, 0x7b, 0x59, 0x30, 0x7b, 0x59, 0x31,
    0x7b, 0x59, 0x32, 0x7b, 0x59, 0x61, 0x7b, 0x59, 0x63, 0x7b, 0x59, 0x65,
    0x7b, 0x59, 0x69, 0x7b, 0x59, 0x6f, 0x7b, 0x59, 0x73, 0x7b, 0x59, 0x74};
const uint8_t HuffDecoderCommon::table28_29_emit_[120] = {
    0x7b, 0x6a, 0x30, 0x7b, 0x6a, 0x31, 0x7b, 0x6a, 0x32, 0x7b, 0x6a, 0x61,
    0x7b, 0x6a, 0x63, 0x7b, 0x6a, 0x65, 0x7b, 0x6a, 0x69, 0x7b, 0x6a, 0x6f,
    0x7b, 0x6a, 0x73, 0x7b, 0x6a, 0x74, 0x7b, 0x6b, 0x30, 0x7b, 0x6b, 0x31,
    0x7b, 0x6b, 0x32, 0x7b, 0x6b, 0x61, 0x7b, 0x6b, 0x63, 0x7b, 0x6b, 0x65,
    0x7b, 0x6b, 0x69, 0x7b, 0x6b, 0x6f, 0x7b, 0x6b, 0x73, 0x7b, 0x6b, 0x74,
    0x7b, 0x71, 0x30, 0x7b, 0x71, 0x31, 0x7b, 0x71, 0x32, 0x7b, 0x71, 0x61,
    0x7b, 0x71, 0x63, 0x7b, 0x71, 0x65, 0x7b, 0x71, 0x69, 0x7b, 0x71, 0x6f,
    0x7b, 0x71, 0x73, 0x7b, 0x71, 0x74, 0x7b, 0x76, 0x30, 0x7b, 0x76, 0x31,
    0x7b, 0x76, 0x32, 0x7b, 0x76, 0x61, 0x7b, 0x76, 0x63, 0x7b, 0x76, 0x65,
    0x7b, 0x76, 0x69, 0x7b, 0x76, 0x6f, 0x7b, 0x76, 0x73, 0x7b, 0x76, 0x74};
const uint8_t HuffDecoderCommon::table28_30_emit_[120] = {
    0x7b, 0x77, 0x30, 0x7b, 0x77, 0x31, 0x7b, 0x77, 0x32, 0x7b, 0x77, 0x61,
    0x7b, 0x77, 0x63, 0x7b, 0x77, 0x65, 0x7b, 0x77, 0x69, 0x7b, 0x77, 0x6f,
    0x7b, 0x77, 0x73, 0x7b, 0x77, 0x74, 0x7b, 0x78, 0x30, 0x7b, 0x78, 0x31,
    0x7b, 0x78, 0x32, 0x7b, 0x78, 0x61, 0x7b, 0x78, 0x63, 0x7b, 0x78, 0x65,
    0x7b, 0x78, 0x69, 0x7b, 0x78, 0x6f, 0x7b, 0x78, 0x73, 0x7b, 0x78, 0x74,
    0x7b, 0x79, 0x30, 0x7b, 0x79, 0x31, 0x7b, 0x79, 0x32, 0x7b, 0x79, 0x61,
    0x7b, 0x79, 0x63, 0x7b, 0x79, 0x65, 0x7b, 0x79, 0x69, 0x7b, 0x79, 0x6f,
    0x7b, 0x79, 0x73, 0x7b, 0x79, 0x74, 0x7b, 0x7a, 0x30, 0x7b, 0x7a, 0x31,
    0x7b, 0x7a, 0x32, 0x7b, 0x7a, 0x61, 0x7b, 0x7a, 0x63, 0x7b, 0x7a, 0x65,
    0x7b, 0x7a, 0x69, 0x7b, 0x7a, 0x6f, 0x7b, 0x7a, 0x73, 0x7b, 0x7a, 0x74};
const uint8_t HuffDecoderCommon::table28_31_emit_[32] = {
    0x7b, 0x26, 0x7b, 0x2a, 0x7b, 0x2c, 0x7b, 0x3b, 0x7b, 0x58, 0x7b,
    0x5a, 0x7b, 0x21, 0x7b, 0x22, 0x7b, 0x28, 0x7b, 0x29, 0x7b, 0x3f,
    0x7b, 0x27, 0x7b, 0x2b, 0x7b, 0x7c, 0x7b, 0x23, 0x7b, 0x3e};
const uint16_t HuffDecoderCommon::table28_31_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0042, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0062, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000,
    0x00b2, 0x0000, 0x00c2, 0x0000, 0x00d2, 0x00e2, 0x00f2, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint16_t HuffDecoderCommon::table28_32_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0092, 0x0000,
    0x0000, 0x0000, 0x00a2, 0x0000, 0x0000, 0x0000, 0x00b2, 0x0000, 0x0000,
    0x0000, 0x00c2, 0x0000, 0x0000, 0x0000, 0x00d2, 0x0000, 0x0000, 0x0000,
    0x00e2, 0x0000, 0x0000, 0x0000, 0x00f2, 0x0000, 0x0000, 0x0000, 0x0102,
    0x0000, 0x0000, 0x0000, 0x0112, 0x0000, 0x0000, 0x0000, 0x0122, 0x0000,
    0x0000, 0x0000, 0x0132, 0x0000, 0x0000, 0x0000, 0x0142, 0x0000, 0x0000,
    0x0000, 0x0152};
const uint8_t HuffDecoderCommon::table28_33_emit_[104] = {
    0x5c, 0x3d, 0x5c, 0x41, 0x5c, 0x5f, 0x5c, 0x62, 0x5c, 0x64, 0x5c, 0x66,
    0x5c, 0x67, 0x5c, 0x68, 0x5c, 0x6c, 0x5c, 0x6d, 0x5c, 0x6e, 0x5c, 0x70,
    0x5c, 0x72, 0x5c, 0x75, 0x5c, 0x3a, 0x5c, 0x42, 0x5c, 0x43, 0x5c, 0x44,
    0x5c, 0x45, 0x5c, 0x46, 0x5c, 0x47, 0x5c, 0x48, 0x5c, 0x49, 0x5c, 0x4a,
    0x5c, 0x4b, 0x5c, 0x4c, 0x5c, 0x4d, 0x5c, 0x4e, 0x5c, 0x4f, 0x5c, 0x50,
    0x5c, 0x51, 0x5c, 0x52, 0x5c, 0x53, 0x5c, 0x54, 0x5c, 0x55, 0x5c, 0x56,
    0x5c, 0x57, 0x5c, 0x59, 0x5c, 0x6a, 0x5c, 0x6b, 0x5c, 0x71, 0x5c, 0x76,
    0x5c, 0x77, 0x5c, 0x78, 0x5c, 0x79, 0x5c, 0x7a, 0x5c, 0x26, 0x5c, 0x2a,
    0x5c, 0x2c, 0x5c, 0x3b, 0x5c, 0x58, 0x5c, 0x5a};
const uint16_t HuffDecoderCommon::table28_33_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000,
    0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0062, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000,
    0x0000, 0x0000, 0x00b2, 0x0000, 0x0000, 0x0000, 0x00c2, 0x0000, 0x0000,
    0x0000, 0x00d2, 0x0000, 0x00e2, 0x0000, 0x00f2, 0x0000, 0x0102, 0x0000,
    0x0112, 0x0000, 0x0122, 0x0000, 0x0132, 0x0000, 0x0142, 0x0000, 0x0152,
    0x0000, 0x0162, 0x0000, 0x0172, 0x0000, 0x0182, 0x0000, 0x0192, 0x0000,
    0x01a2, 0x0000, 0x01b2, 0x0000, 0x01c2, 0x0000, 0x01d2, 0x0000, 0x01e2,
    0x0000, 0x01f2, 0x0000, 0x0202, 0x0000, 0x0212, 0x0000, 0x0222, 0x0000,
    0x0232, 0x0000, 0x0242, 0x0000, 0x0252, 0x0000, 0x0262, 0x0000, 0x0272,
    0x0000, 0x0282, 0x0000, 0x0292, 0x0000, 0x02a2, 0x0000, 0x02b2, 0x0000,
    0x02c2, 0x0000, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table28_35_emit_[104] = {
    0xc3, 0x3d, 0xc3, 0x41, 0xc3, 0x5f, 0xc3, 0x62, 0xc3, 0x64, 0xc3, 0x66,
    0xc3, 0x67, 0xc3, 0x68, 0xc3, 0x6c, 0xc3, 0x6d, 0xc3, 0x6e, 0xc3, 0x70,
    0xc3, 0x72, 0xc3, 0x75, 0xc3, 0x3a, 0xc3, 0x42, 0xc3, 0x43, 0xc3, 0x44,
    0xc3, 0x45, 0xc3, 0x46, 0xc3, 0x47, 0xc3, 0x48, 0xc3, 0x49, 0xc3, 0x4a,
    0xc3, 0x4b, 0xc3, 0x4c, 0xc3, 0x4d, 0xc3, 0x4e, 0xc3, 0x4f, 0xc3, 0x50,
    0xc3, 0x51, 0xc3, 0x52, 0xc3, 0x53, 0xc3, 0x54, 0xc3, 0x55, 0xc3, 0x56,
    0xc3, 0x57, 0xc3, 0x59, 0xc3, 0x6a, 0xc3, 0x6b, 0xc3, 0x71, 0xc3, 0x76,
    0xc3, 0x77, 0xc3, 0x78, 0xc3, 0x79, 0xc3, 0x7a, 0xc3, 0x26, 0xc3, 0x2a,
    0xc3, 0x2c, 0xc3, 0x3b, 0xc3, 0x58, 0xc3, 0x5a};
const uint8_t HuffDecoderCommon::table28_37_emit_[104] = {
    0xd0, 0x3d, 0xd0, 0x41, 0xd0, 0x5f, 0xd0, 0x62, 0xd0, 0x64, 0xd0, 0x66,
    0xd0, 0x67, 0xd0, 0x68, 0xd0, 0x6c, 0xd0, 0x6d, 0xd0, 0x6e, 0xd0, 0x70,
    0xd0, 0x72, 0xd0, 0x75, 0xd0, 0x3a, 0xd0, 0x42, 0xd0, 0x43, 0xd0, 0x44,
    0xd0, 0x45, 0xd0, 0x46, 0xd0, 0x47, 0xd0, 0x48, 0xd0, 0x49, 0xd0, 0x4a,
    0xd0, 0x4b, 0xd0, 0x4c, 0xd0, 0x4d, 0xd0, 0x4e, 0xd0, 0x4f, 0xd0, 0x50,
    0xd0, 0x51, 0xd0, 0x52, 0xd0, 0x53, 0xd0, 0x54, 0xd0, 0x55, 0xd0, 0x56,
    0xd0, 0x57, 0xd0, 0x59, 0xd0, 0x6a, 0xd0, 0x6b, 0xd0, 0x71, 0xd0, 0x76,
    0xd0, 0x77, 0xd0, 0x78, 0xd0, 0x79, 0xd0, 0x7a, 0xd0, 0x26, 0xd0, 0x2a,
    0xd0, 0x2c, 0xd0, 0x3b, 0xd0, 0x58, 0xd0, 0x5a};
const uint8_t HuffDecoderCommon::table28_38_emit_[136] = {
    0x80, 0x30, 0x80, 0x31, 0x80, 0x32, 0x80, 0x61, 0x80, 0x63, 0x80, 0x65,
    0x80, 0x69, 0x80, 0x6f, 0x80, 0x73, 0x80, 0x74, 0x80, 0x20, 0x80, 0x25,
    0x80, 0x2d, 0x80, 0x2e, 0x80, 0x2f, 0x80, 0x33, 0x80, 0x34, 0x80, 0x35,
    0x80, 0x36, 0x80, 0x37, 0x80, 0x38, 0x80, 0x39, 0x80, 0x3d, 0x80, 0x41,
    0x80, 0x5f, 0x80, 0x62, 0x80, 0x64, 0x80, 0x66, 0x80, 0x67, 0x80, 0x68,
    0x80, 0x6c, 0x80, 0x6d, 0x80, 0x6e, 0x80, 0x70, 0x80, 0x72, 0x80, 0x75,
    0x80, 0x3a, 0x80, 0x42, 0x80, 0x43, 0x80, 0x44, 0x80, 0x45, 0x80, 0x46,
    0x80, 0x47, 0x80, 0x48, 0x80, 0x49, 0x80, 0x4a, 0x80, 0x4b, 0x80, 0x4c,
    0x80, 0x4d, 0x80, 0x4e, 0x80, 0x4f, 0x80, 0x50, 0x80, 0x51, 0x80, 0x52,
    0x80, 0x53, 0x80, 0x54, 0x80, 0x55, 0x80, 0x56, 0x80, 0x57, 0x80, 0x59,
    0x80, 0x6a, 0x80, 0x6b, 0x80, 0x71, 0x80, 0x76, 0x80, 0x77, 0x80, 0x78,
    0x80, 0x79, 0x80, 0x7a};
const uint16_t HuffDecoderCommon::table28_38_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0012, 0x0000,
    0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000,
    0x0000, 0x0042, 0x0000, 0x0000, 0x0000, 0x0052, 0x0000, 0x0000, 0x0000,
    0x0062, 0x0000, 0x0000, 0x0000, 0x0072, 0x0000, 0x0000, 0x0000, 0x0082,
    0x0000, 0x0000, 0x0000, 0x0092, 0x0000, 0x00a2, 0x0000, 0x00b2, 0x0000,
    0x00c2, 0x0000, 0x00d2, 0x0000, 0x00e2, 0x0000, 0x00f2, 0x0000, 0x0102,
    0x0000, 0x0112, 0x0000, 0x0122, 0x0000, 0x0132, 0x0000, 0x0142, 0x0000,
    0x0152, 0x0000, 0x0162, 0x0000, 0x0172, 0x0000, 0x0182, 0x0000, 0x0192,
    0x0000, 0x01a2, 0x0000, 0x01b2, 0x0000, 0x01c2, 0x0000, 0x01d2, 0x0000,
    0x01e2, 0x0000, 0x01f2, 0x0000, 0x0202, 0x0000, 0x0212, 0x0000, 0x0222,
    0x0000, 0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2,
    0x02b2, 0x02c2, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332,
    0x0342, 0x0352, 0x0362, 0x0372, 0x0382, 0x0392, 0x03a2, 0x03b2, 0x03c2,
    0x03d2, 0x03e2, 0x03f2, 0x0402, 0x0412, 0x0422, 0x0432, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint8_t HuffDecoderCommon::table28_39_emit_[136] = {
    0x82, 0x30, 0x82, 0x31, 0x82, 0x32, 0x82, 0x61, 0x82, 0x63, 0x82, 0x65,
    0x82, 0x69, 0x82, 0x6f, 0x82, 0x73, 0x82, 0x74, 0x82, 0x20, 0x82, 0x25,
    0x82, 0x2d, 0x82, 0x2e, 0x82, 0x2f, 0x82, 0x33, 0x82, 0x34, 0x82, 0x35,
    0x82, 0x36, 0x82, 0x37, 0x82, 0x38, 0x82, 0x39, 0x82, 0x3d, 0x82, 0x41,
    0x82, 0x5f, 0x82, 0x62, 0x82, 0x64, 0x82, 0x66, 0x82, 0x67, 0x82, 0x68,
    0x82, 0x6c, 0x82, 0x6d, 0x82, 0x6e, 0x82, 0x70, 0x82, 0x72, 0x82, 0x75,
    0x82, 0x3a, 0x82, 0x42, 0x82, 0x43, 0x82, 0x44, 0x82, 0x45, 0x82, 0x46,
    0x82, 0x47, 0x82, 0x48, 0x82, 0x49, 0x82, 0x4a, 0x82, 0x4b, 0x82, 0x4c,
    0x82, 0x4d, 0x82, 0x4e, 0x82, 0x4f, 0x82, 0x50, 0x82, 0x51, 0x82, 0x52,
    0x82, 0x53, 0x82, 0x54, 0x82, 0x55, 0x82, 0x56, 0x82, 0x57, 0x82, 0x59,
    0x82, 0x6a, 0x82, 0x6b, 0x82, 0x71, 0x82, 0x76, 0x82, 0x77, 0x82, 0x78,
    0x82, 0x79, 0x82, 0x7a};
const uint8_t HuffDecoderCommon::table28_40_emit_[136] = {
    0x83, 0x30, 0x83, 0x31, 0x83, 0x32, 0x83, 0x61, 0x83, 0x63, 0x83, 0x65,
    0x83, 0x69, 0x83, 0x6f, 0x83, 0x73, 0x83, 0x74, 0x83, 0x20, 0x83, 0x25,
    0x83, 0x2d, 0x83, 0x2e, 0x83, 0x2f, 0x83, 0x33, 0x83, 0x34, 0x83, 0x35,
    0x83, 0x36, 0x83, 0x37, 0x83, 0x38, 0x83, 0x39, 0x83, 0x3d, 0x83, 0x41,
    0x83, 0x5f, 0x83, 0x62, 0x83, 0x64, 0x83, 0x66, 0x83, 0x67, 0x83, 0x68,
    0x83, 0x6c, 0x83, 0x6d, 0x83, 0x6e, 0x83, 0x70, 0x83, 0x72, 0x83, 0x75,
    0x83, 0x3a, 0x83, 0x42, 0x83, 0x43, 0x83, 0x44, 0x83, 0x45, 0x83, 0x46,
    0x83, 0x47, 0x83, 0x48, 0x83, 0x49, 0x83, 0x4a, 0x83, 0x4b, 0x83, 0x4c,
    0x83, 0x4d, 0x83, 0x4e, 0x83, 0x4f, 0x83, 0x50, 0x83, 0x51, 0x83, 0x52,
    0x83, 0x53, 0x83, 0x54, 0x83, 0x55, 0x83, 0x56, 0x83, 0x57, 0x83, 0x59,
    0x83, 0x6a, 0x83, 0x6b, 0x83, 0x71, 0x83, 0x76, 0x83, 0x77, 0x83, 0x78,
    0x83, 0x79, 0x83, 0x7a};
const uint8_t HuffDecoderCommon::table28_41_emit_[136] = {
    0xa2, 0x30, 0xa2, 0x31, 0xa2, 0x32, 0xa2, 0x61, 0xa2, 0x63, 0xa2, 0x65,
    0xa2, 0x69, 0xa2, 0x6f, 0xa2, 0x73, 0xa2, 0x74, 0xa2, 0x20, 0xa2, 0x25,
    0xa2, 0x2d, 0xa2, 0x2e, 0xa2, 0x2f, 0xa2, 0x33, 0xa2, 0x34, 0xa2, 0x35,
    0xa2, 0x36, 0xa2, 0x37, 0xa2, 0x38, 0xa2, 0x39, 0xa2, 0x3d, 0xa2, 0x41,
    0xa2, 0x5f, 0xa2, 0x62, 0xa2, 0x64, 0xa2, 0x66, 0xa2, 0x67, 0xa2, 0x68,
    0xa2, 0x6c, 0xa2, 0x6d, 0xa2, 0x6e, 0xa2, 0x70, 0xa2, 0x72, 0xa2, 0x75,
    0xa2, 0x3a, 0xa2, 0x42, 0xa2, 0x43, 0xa2, 0x44, 0xa2, 0x45, 0xa2, 0x46,
    0xa2, 0x47, 0xa2, 0x48, 0xa2, 0x49, 0xa2, 0x4a, 0xa2, 0x4b, 0xa2, 0x4c,
    0xa2, 0x4d, 0xa2, 0x4e, 0xa2, 0x4f, 0xa2, 0x50, 0xa2, 0x51, 0xa2, 0x52,
    0xa2, 0x53, 0xa2, 0x54, 0xa2, 0x55, 0xa2, 0x56, 0xa2, 0x57, 0xa2, 0x59,
    0xa2, 0x6a, 0xa2, 0x6b, 0xa2, 0x71, 0xa2, 0x76, 0xa2, 0x77, 0xa2, 0x78,
    0xa2, 0x79, 0xa2, 0x7a};
const uint8_t HuffDecoderCommon::table28_42_emit_[136] = {
    0xb8, 0x30, 0xb8, 0x31, 0xb8, 0x32, 0xb8, 0x61, 0xb8, 0x63, 0xb8, 0x65,
    0xb8, 0x69, 0xb8, 0x6f, 0xb8, 0x73, 0xb8, 0x74, 0xb8, 0x20, 0xb8, 0x25,
    0xb8, 0x2d, 0xb8, 0x2e, 0xb8, 0x2f, 0xb8, 0x33, 0xb8, 0x34, 0xb8, 0x35,
    0xb8, 0x36, 0xb8, 0x37, 0xb8, 0x38, 0xb8, 0x39, 0xb8, 0x3d, 0xb8, 0x41,
    0xb8, 0x5f, 0xb8, 0x62, 0xb8, 0x64, 0xb8, 0x66, 0xb8, 0x67, 0xb8, 0x68,
    0xb8, 0x6c, 0xb8, 0x6d, 0xb8, 0x6e, 0xb8, 0x70, 0xb8, 0x72, 0xb8, 0x75,
    0xb8, 0x3a, 0xb8, 0x42, 0xb8, 0x43, 0xb8, 0x44, 0xb8, 0x45, 0xb8, 0x46,
    0xb8, 0x47, 0xb8, 0x48, 0xb8, 0x49, 0xb8, 0x4a, 0xb8, 0x4b, 0xb8, 0x4c,
    0xb8, 0x4d, 0xb8, 0x4e, 0xb8, 0x4f, 0xb8, 0x50, 0xb8, 0x51, 0xb8, 0x52,
    0xb8, 0x53, 0xb8, 0x54, 0xb8, 0x55, 0xb8, 0x56, 0xb8, 0x57, 0xb8, 0x59,
    0xb8, 0x6a, 0xb8, 0x6b, 0xb8, 0x71, 0xb8, 0x76, 0xb8, 0x77, 0xb8, 0x78,
    0xb8, 0x79, 0xb8, 0x7a};
const uint8_t HuffDecoderCommon::table28_43_emit_[136] = {
    0xc2, 0x30, 0xc2, 0x31, 0xc2, 0x32, 0xc2, 0x61, 0xc2, 0x63, 0xc2, 0x65,
    0xc2, 0x69, 0xc2, 0x6f, 0xc2, 0x73, 0xc2, 0x74, 0xc2, 0x20, 0xc2, 0x25,
    0xc2, 0x2d, 0xc2, 0x2e, 0xc2, 0x2f, 0xc2, 0x33, 0xc2, 0x34, 0xc2, 0x35,
    0xc2, 0x36, 0xc2, 0x37, 0xc2, 0x38, 0xc2, 0x39, 0xc2, 0x3d, 0xc2, 0x41,
    0xc2, 0x5f, 0xc2, 0x62, 0xc2, 0x64, 0xc2, 0x66, 0xc2, 0x67, 0xc2, 0x68,
    0xc2, 0x6c, 0xc2, 0x6d, 0xc2, 0x6e, 0xc2, 0x70, 0xc2, 0x72, 0xc2, 0x75,
    0xc2, 0x3a, 0xc2, 0x42, 0xc2, 0x43, 0xc2, 0x44, 0xc2, 0x45, 0xc2, 0x46,
    0xc2, 0x47, 0xc2, 0x48, 0xc2, 0x49, 0xc2, 0x4a, 0xc2, 0x4b, 0xc2, 0x4c,
    0xc2, 0x4d, 0xc2, 0x4e, 0xc2, 0x4f, 0xc2, 0x50, 0xc2, 0x51, 0xc2, 0x52,
    0xc2, 0x53, 0xc2, 0x54, 0xc2, 0x55, 0xc2, 0x56, 0xc2, 0x57, 0xc2, 0x59,
    0xc2, 0x6a, 0xc2, 0x6b, 0xc2, 0x71, 0xc2, 0x76, 0xc2, 0x77, 0xc2, 0x78,
    0xc2, 0x79, 0xc2, 0x7a};
const uint8_t HuffDecoderCommon::table28_44_emit_[136] = {
    0xe0, 0x30, 0xe0, 0x31, 0xe0, 0x32, 0xe0, 0x61, 0xe0, 0x63, 0xe0, 0x65,
    0xe0, 0x69, 0xe0, 0x6f, 0xe0, 0x73, 0xe0, 0x74, 0xe0, 0x20, 0xe0, 0x25,
    0xe0, 0x2d, 0xe0, 0x2e, 0xe0, 0x2f, 0xe0, 0x33, 0xe0, 0x34, 0xe0, 0x35,
    0xe0, 0x36, 0xe0, 0x37, 0xe0, 0x38, 0xe0, 0x39, 0xe0, 0x3d, 0xe0, 0x41,
    0xe0, 0x5f, 0xe0, 0x62, 0xe0, 0x64, 0xe0, 0x66, 0xe0, 0x67, 0xe0, 0x68,
    0xe0, 0x6c, 0xe0, 0x6d, 0xe0, 0x6e, 0xe0, 0x70, 0xe0, 0x72, 0xe0, 0x75,
    0xe0, 0x3a, 0xe0, 0x42, 0xe0, 0x43, 0xe0, 0x44, 0xe0, 0x45, 0xe0, 0x46,
    0xe0, 0x47, 0xe0, 0x48, 0xe0, 0x49, 0xe0, 0x4a, 0xe0, 0x4b, 0xe0, 0x4c,
    0xe0, 0x4d, 0xe0, 0x4e, 0xe0, 0x4f, 0xe0, 0x50, 0xe0, 0x51, 0xe0, 0x52,
    0xe0, 0x53, 0xe0, 0x54, 0xe0, 0x55, 0xe0, 0x56, 0xe0, 0x57, 0xe0, 0x59,
    0xe0, 0x6a, 0xe0, 0x6b, 0xe0, 0x71, 0xe0, 0x76, 0xe0, 0x77, 0xe0, 0x78,
    0xe0, 0x79, 0xe0, 0x7a};
const uint8_t HuffDecoderCommon::table28_45_emit_[136] = {
    0xe2, 0x30, 0xe2, 0x31, 0xe2, 0x32, 0xe2, 0x61, 0xe2, 0x63, 0xe2, 0x65,
    0xe2, 0x69, 0xe2, 0x6f, 0xe2, 0x73, 0xe2, 0x74, 0xe2, 0x20, 0xe2, 0x25,
    0xe2, 0x2d, 0xe2, 0x2e, 0xe2, 0x2f, 0xe2, 0x33, 0xe2, 0x34, 0xe2, 0x35,
    0xe2, 0x36, 0xe2, 0x37, 0xe2, 0x38, 0xe2, 0x39, 0xe2, 0x3d, 0xe2, 0x41,
    0xe2, 0x5f, 0xe2, 0x62, 0xe2, 0x64, 0xe2, 0x66, 0xe2, 0x67, 0xe2, 0x68,
    0xe2, 0x6c, 0xe2, 0x6d, 0xe2, 0x6e, 0xe2, 0x70, 0xe2, 0x72, 0xe2, 0x75,
    0xe2, 0x3a, 0xe2, 0x42, 0xe2, 0x43, 0xe2, 0x44, 0xe2, 0x45, 0xe2, 0x46,
    0xe2, 0x47, 0xe2, 0x48, 0xe2, 0x49, 0xe2, 0x4a, 0xe2, 0x4b, 0xe2, 0x4c,
    0xe2, 0x4d, 0xe2, 0x4e, 0xe2, 0x4f, 0xe2, 0x50, 0xe2, 0x51, 0xe2, 0x52,
    0xe2, 0x53, 0xe2, 0x54, 0xe2, 0x55, 0xe2, 0x56, 0xe2, 0x57, 0xe2, 0x59,
    0xe2, 0x6a, 0xe2, 0x6b, 0xe2, 0x71, 0xe2, 0x76, 0xe2, 0x77, 0xe2, 0x78,
    0xe2, 0x79, 0xe2, 0x7a};
const uint8_t HuffDecoderCommon::table28_46_emit_[144] = {
    0x99, 0x30, 0x99, 0x31, 0x99, 0x32, 0x99, 0x61, 0x99, 0x63, 0x99, 0x65,
    0x99, 0x69, 0x99, 0x6f, 0x99, 0x73, 0x99, 0x74, 0x99, 0x20, 0x99, 0x25,
    0x99, 0x2d, 0x99, 0x2e, 0x99, 0x2f, 0x99, 0x33, 0x99, 0x34, 0x99, 0x35,
    0x99, 0x36, 0x99, 0x37, 0x99, 0x38, 0x99, 0x39, 0x99, 0x3d, 0x99, 0x41,
    0x99, 0x5f, 0x99, 0x62, 0x99, 0x64, 0x99, 0x66, 0x99, 0x67, 0x99, 0x68,
    0x99, 0x6c, 0x99, 0x6d, 0x99, 0x6e, 0x99, 0x70, 0x99, 0x72, 0x99, 0x75,
    0xa1, 0x30, 0xa1, 0x31, 0xa1, 0x32, 0xa1, 0x61, 0xa1, 0x63, 0xa1, 0x65,
    0xa1, 0x69, 0xa1, 0x6f, 0xa1, 0x73, 0xa1, 0x74, 0xa1, 0x20, 0xa1, 0x25,
    0xa1, 0x2d, 0xa1, 0x2e, 0xa1, 0x2f, 0xa1, 0x33, 0xa1, 0x34, 0xa1, 0x35,
    0xa1, 0x36, 0xa1, 0x37, 0xa1, 0x38, 0xa1, 0x39, 0xa1, 0x3d, 0xa1, 0x41,
    0xa1, 0x5f, 0xa1, 0x62, 0xa1, 0x64, 0xa1, 0x66, 0xa1, 0x67, 0xa1, 0x68,
    0xa1, 0x6c, 0xa1, 0x6d, 0xa1, 0x6e, 0xa1, 0x70, 0xa1, 0x72, 0xa1, 0x75};
const uint16_t HuffDecoderCommon::table28_46_ops_[128] = {
    0x0000, 0x0002, 0x0000, 0x0012, 0x0000, 0x0022, 0x0000, 0x0032, 0x0000,
    0x0042, 0x0000, 0x0052, 0x0000, 0x0062, 0x0000, 0x0072, 0x0000, 0x0082,
    0x0000, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0003, 0x0000, 0x0242, 0x0000, 0x0252, 0x0000, 0x0262, 0x0000, 0x0272,
    0x0000, 0x0282, 0x0000, 0x0292, 0x0000, 0x02a2, 0x0000, 0x02b2, 0x0000,
    0x02c2, 0x0000, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332,
    0x0342, 0x0352, 0x0362, 0x0372, 0x0382, 0x0392, 0x03a2, 0x03b2, 0x03c2,
    0x03d2, 0x03e2, 0x03f2, 0x0402, 0x0412, 0x0422, 0x0432, 0x0442, 0x0452,
    0x0462, 0x0472, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0243};
const uint8_t HuffDecoderCommon::table28_47_emit_[144] = {
    0xa7, 0x30, 0xa7, 0x31, 0xa7, 0x32, 0xa7, 0x61, 0xa7, 0x63, 0xa7, 0x65,
    0xa7, 0x69, 0xa7, 0x6f, 0xa7, 0x73, 0xa7, 0x74, 0xa7, 0x20, 0xa7, 0x25,
    0xa7, 0x2d, 0xa7, 0x2e, 0xa7, 0x2f, 0xa7, 0x33, 0xa7, 0x34, 0xa7, 0x35,
    0xa7, 0x36, 0xa7, 0x37, 0xa7, 0x38, 0xa7, 0x39, 0xa7, 0x3d, 0xa7, 0x41,
    0xa7, 0x5f, 0xa7, 0x62, 0xa7, 0x64, 0xa7, 0x66, 0xa7, 0x67, 0xa7, 0x68,
    0xa7, 0x6c, 0xa7, 0x6d, 0xa7, 0x6e, 0xa7, 0x70, 0xa7, 0x72, 0xa7, 0x75,
    0xac, 0x30, 0xac, 0x31, 0xac, 0x32, 0xac, 0x61, 0xac, 0x63, 0xac, 0x65,
    0xac, 0x69, 0xac, 0x6f, 0xac, 0x73, 0xac, 0x74, 0xac, 0x20, 0xac, 0x25,
    0xac, 0x2d, 0xac, 0x2e, 0xac, 0x2f, 0xac, 0x33, 0xac, 0x34, 0xac, 0x35,
    0xac, 0x36, 0xac, 0x37, 0xac, 0x38, 0xac, 0x39, 0xac, 0x3d, 0xac, 0x41,
    0xac, 0x5f, 0xac, 0x62, 0xac, 0x64, 0xac, 0x66, 0xac, 0x67, 0xac, 0x68,
    0xac, 0x6c, 0xac, 0x6d, 0xac, 0x6e, 0xac, 0x70, 0xac, 0x72, 0xac, 0x75};
const uint8_t HuffDecoderCommon::table28_48_emit_[144] = {
    0xb0, 0x30, 0xb0, 0x31, 0xb0, 0x32, 0xb0, 0x61, 0xb0, 0x63, 0xb0, 0x65,
    0xb0, 0x69, 0xb0, 0x6f, 0xb0, 0x73, 0xb0, 0x74, 0xb0, 0x20, 0xb0, 0x25,
    0xb0, 0x2d, 0xb0, 0x2e, 0xb0, 0x2f, 0xb0, 0x33, 0xb0, 0x34, 0xb0, 0x35,
    0xb0, 0x36, 0xb0, 0x37, 0xb0, 0x38, 0xb0, 0x39, 0xb0, 0x3d, 0xb0, 0x41,
    0xb0, 0x5f, 0xb0, 0x62, 0xb0, 0x64, 0xb0, 0x66, 0xb0, 0x67, 0xb0, 0x68,
    0xb0, 0x6c, 0xb0, 0x6d, 0xb0, 0x6e, 0xb0, 0x70, 0xb0, 0x72, 0xb0, 0x75,
    0xb1, 0x30, 0xb1, 0x31, 0xb1, 0x32, 0xb1, 0x61, 0xb1, 0x63, 0xb1, 0x65,
    0xb1, 0x69, 0xb1, 0x6f, 0xb1, 0x73, 0xb1, 0x74, 0xb1, 0x20, 0xb1, 0x25,
    0xb1, 0x2d, 0xb1, 0x2e, 0xb1, 0x2f, 0xb1, 0x33, 0xb1, 0x34, 0xb1, 0x35,
    0xb1, 0x36, 0xb1, 0x37, 0xb1, 0x38, 0xb1, 0x39, 0xb1, 0x3d, 0xb1, 0x41,
    0xb1, 0x5f, 0xb1, 0x62, 0xb1, 0x64, 0xb1, 0x66, 0xb1, 0x67, 0xb1, 0x68,
    0xb1, 0x6c, 0xb1, 0x6d, 0xb1, 0x6e, 0xb1, 0x70, 0xb1, 0x72, 0xb1, 0x75};
const uint8_t HuffDecoderCommon::table28_49_emit_[144] = {
    0xb3, 0x30, 0xb3, 0x31, 0xb3, 0x32, 0xb3, 0x61, 0xb3, 0x63, 0xb3, 0x65,
    0xb3, 0x69, 0xb3, 0x6f, 0xb3, 0x73, 0xb3, 0x74, 0xb3, 0x20, 0xb3, 0x25,
    0xb3, 0x2d, 0xb3, 0x2e, 0xb3, 0x2f, 0xb3, 0x33, 0xb3, 0x34, 0xb3, 0x35,
    0xb3, 0x36, 0xb3, 0x37, 0xb3, 0x38, 0xb3, 0x39, 0xb3, 0x3d, 0xb3, 0x41,
    0xb3, 0x5f, 0xb3, 0x62, 0xb3, 0x64, 0xb3, 0x66, 0xb3, 0x67, 0xb3, 0x68,
    0xb3, 0x6c, 0xb3, 0x6d, 0xb3, 0x6e, 0xb3, 0x70, 0xb3, 0x72, 0xb3, 0x75,
    0xd1, 0x30, 0xd1, 0x31, 0xd1, 0x32, 0xd1, 0x61, 0xd1, 0x63, 0xd1, 0x65,
    0xd1, 0x69, 0xd1, 0x6f, 0xd1, 0x73, 0xd1, 0x74, 0xd1, 0x20, 0xd1, 0x25,
    0xd1, 0x2d, 0xd1, 0x2e, 0xd1, 0x2f, 0xd1, 0x33, 0xd1, 0x34, 0xd1, 0x35,
    0xd1, 0x36, 0xd1, 0x37, 0xd1, 0x38, 0xd1, 0x39, 0xd1, 0x3d, 0xd1, 0x41,
    0xd1, 0x5f, 0xd1, 0x62, 0xd1, 0x64, 0xd1, 0x66, 0xd1, 0x67, 0xd1, 0x68,
    0xd1, 0x6c, 0xd1, 0x6d, 0xd1, 0x6e, 0xd1, 0x70, 0xd1, 0x72, 0xd1, 0x75};
const uint8_t HuffDecoderCommon::table28_50_emit_[144] = {
    0xd8, 0x30, 0xd8, 0x31, 0xd8, 0x32, 0xd8, 0x61, 0xd8, 0x63, 0xd8, 0x65,
    0xd8, 0x69, 0xd8, 0x6f, 0xd8, 0x73, 0xd8, 0x74, 0xd8, 0x20, 0xd8, 0x25,
    0xd8, 0x2d, 0xd8, 0x2e, 0xd8, 0x2f, 0xd8, 0x33, 0xd8, 0x34, 0xd8, 0x35,
    0xd8, 0x36, 0xd8, 0x37, 0xd8, 0x38, 0xd8, 0x39, 0xd8, 0x3d, 0xd8, 0x41,
    0xd8, 0x5f, 0xd8, 0x62, 0xd8, 0x64, 0xd8, 0x66, 0xd8, 0x67, 0xd8, 0x68,
    0xd8, 0x6c, 0xd8, 0x6d, 0xd8, 0x6e, 0xd8, 0x70, 0xd8, 0x72, 0xd8, 0x75,
    0xd9, 0x30, 0xd9, 0x31, 0xd9, 0x32, 0xd9, 0x61, 0xd9, 0x63, 0xd9, 0x65,
    0xd9, 0x69, 0xd9, 0x6f, 0xd9, 0x73, 0xd9, 0x74, 0xd9, 0x20, 0xd9, 0x25,
    0xd9, 0x2d, 0xd9, 0x2e, 0xd9, 0x2f, 0xd9, 0x33, 0xd9, 0x34, 0xd9, 0x35,
    0xd9, 0x36, 0xd9, 0x37, 0xd9, 0x38, 0xd9, 0x39, 0xd9, 0x3d, 0xd9, 0x41,
    0xd9, 0x5f, 0xd9, 0x62, 0xd9, 0x64, 0xd9, 0x66, 0xd9, 0x67, 0xd9, 0x68,
    0xd9, 0x6c, 0xd9, 0x6d, 0xd9, 0x6e, 0xd9, 0x70, 0xd9, 0x72, 0xd9, 0x75};
const uint8_t HuffDecoderCommon::table28_51_emit_[144] = {
    0xe3, 0x30, 0xe3, 0x31, 0xe3, 0x32, 0xe3, 0x61, 0xe3, 0x63, 0xe3, 0x65,
    0xe3, 0x69, 0xe3, 0x6f, 0xe3, 0x73, 0xe3, 0x74, 0xe3, 0x20, 0xe3, 0x25,
    0xe3, 0x2d, 0xe3, 0x2e, 0xe3, 0x2f, 0xe3, 0x33, 0xe3, 0x34, 0xe3, 0x35,
    0xe3, 0x36, 0xe3, 0x37, 0xe3, 0x38, 0xe3, 0x39, 0xe3, 0x3d, 0xe3, 0x41,
    0xe3, 0x5f, 0xe3, 0x62, 0xe3, 0x64, 0xe3, 0x66, 0xe3, 0x67, 0xe3, 0x68,
    0xe3, 0x6c, 0xe3, 0x6d, 0xe3, 0x6e, 0xe3, 0x70, 0xe3, 0x72, 0xe3, 0x75,
    0xe5, 0x30, 0xe5, 0x31, 0xe5, 0x32, 0xe5, 0x61, 0xe5, 0x63, 0xe5, 0x65,
    0xe5, 0x69, 0xe5, 0x6f, 0xe5, 0x73, 0xe5, 0x74, 0xe5, 0x20, 0xe5, 0x25,
    0xe5, 0x2d, 0xe5, 0x2e, 0xe5, 0x2f, 0xe5, 0x33, 0xe5, 0x34, 0xe5, 0x35,
    0xe5, 0x36, 0xe5, 0x37, 0xe5, 0x38, 0xe5, 0x39, 0xe5, 0x3d, 0xe5, 0x41,
    0xe5, 0x5f, 0xe5, 0x62, 0xe5, 0x64, 0xe5, 0x66, 0xe5, 0x67, 0xe5, 0x68,
    0xe5, 0x6c, 0xe5, 0x6d, 0xe5, 0x6e, 0xe5, 0x70, 0xe5, 0x72, 0xe5, 0x75};
const uint8_t HuffDecoderCommon::table28_52_emit_[112] = {
    0xe6, 0x30, 0xe6, 0x31, 0xe6, 0x32, 0xe6, 0x61, 0xe6, 0x63, 0xe6, 0x65,
    0xe6, 0x69, 0xe6, 0x6f, 0xe6, 0x73, 0xe6, 0x74, 0xe6, 0x20, 0xe6, 0x25,
    0xe6, 0x2d, 0xe6, 0x2e, 0xe6, 0x2f, 0xe6, 0x33, 0xe6, 0x34, 0xe6, 0x35,
    0xe6, 0x36, 0xe6, 0x37, 0xe6, 0x38, 0xe6, 0x39, 0xe6, 0x3d, 0xe6, 0x41,
    0xe6, 0x5f, 0xe6, 0x62, 0xe6, 0x64, 0xe6, 0x66, 0xe6, 0x67, 0xe6, 0x68,
    0xe6, 0x6c, 0xe6, 0x6d, 0xe6, 0x6e, 0xe6, 0x70, 0xe6, 0x72, 0xe6, 0x75,
    0x81, 0x30, 0x81, 0x31, 0x81, 0x32, 0x81, 0x61, 0x81, 0x63, 0x81, 0x65,
    0x81, 0x69, 0x81, 0x6f, 0x81, 0x73, 0x81, 0x74, 0x84, 0x30, 0x84, 0x31,
    0x84, 0x32, 0x84, 0x61, 0x84, 0x63, 0x84, 0x65, 0x84, 0x69, 0x84, 0x6f,
    0x84, 0x73, 0x84, 0x74};
const uint16_t HuffDecoderCommon::table28_52_ops_[128] = {
    0x0000, 0x0002, 0x0000, 0x0012, 0x0000, 0x0022, 0x0000, 0x0032, 0x0000,
    0x0042, 0x0000, 0x0052, 0x0000, 0x0062, 0x0000, 0x0072, 0x0000, 0x0082,
    0x0000, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0003, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2, 0x02b2,
    0x02c2, 0x02d2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0243, 0x02e2, 0x02f2, 0x0302,
    0x0312, 0x0322, 0x0332, 0x0342, 0x0352, 0x0362, 0x0372, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x02e3};
const uint8_t HuffDecoderCommon::table28_53_emit_[80] = {
    0x85, 0x30, 0x85, 0x31, 0x85, 0x32, 0x85, 0x61, 0x85, 0x63, 0x85, 0x65,
    0x85, 0x69, 0x85, 0x6f, 0x85, 0x73, 0x85, 0x74, 0x86, 0x30, 0x86, 0x31,
    0x86, 0x32, 0x86, 0x61, 0x86, 0x63, 0x86, 0x65, 0x86, 0x69, 0x86, 0x6f,
    0x86, 0x73, 0x86, 0x74, 0x88, 0x30, 0x88, 0x31, 0x88, 0x32, 0x88, 0x61,
    0x88, 0x63, 0x88, 0x65, 0x88, 0x69, 0x88, 0x6f, 0x88, 0x73, 0x88, 0x74,
    0x92, 0x30, 0x92, 0x31, 0x92, 0x32, 0x92, 0x61, 0x92, 0x63, 0x92, 0x65,
    0x92, 0x69, 0x92, 0x6f, 0x92, 0x73, 0x92, 0x74};
const uint16_t HuffDecoderCommon::table28_53_ops_[128] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072, 0x0082,
    0x0092, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x00a2, 0x00b2, 0x00c2, 0x00d2,
    0x00e2, 0x00f2, 0x0102, 0x0112, 0x0122, 0x0132, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x00a3, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192, 0x01a2, 0x01b2,
    0x01c2, 0x01d2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0143, 0x01e2, 0x01f2, 0x0202,
    0x0212, 0x0222, 0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x01e3};
const uint8_t HuffDecoderCommon::table28_54_emit_[80] = {
    0x9a, 0x30, 0x9a, 0x31, 0x9a, 0x32, 0x9a, 0x61, 0x9a, 0x63, 0x9a, 0x65,
    0x9a, 0x69, 0x9a, 0x6f, 0x9a, 0x73, 0x9a, 0x74, 0x9c, 0x30, 0x9c, 0x31,
    0x9c, 0x32, 0x9c, 0x61, 0x9c, 0x63, 0x9c, 0x65, 0x9c, 0x69, 0x9c, 0x6f,
    0x9c, 0x73, 0x9c, 0x74, 0xa0, 0x30, 0xa0, 0x31, 0xa0, 0x32, 0xa0, 0x61,
    0xa0, 0x63, 0xa0, 0x65, 0xa0, 0x69, 0xa0, 0x6f, 0xa0, 0x73, 0xa0, 0x74,
    0xa3, 0x30, 0xa3, 0x31, 0xa3, 0x32, 0xa3, 0x61, 0xa3, 0x63, 0xa3, 0x65,
    0xa3, 0x69, 0xa3, 0x6f, 0xa3, 0x73, 0xa3, 0x74};
const uint8_t HuffDecoderCommon::table28_55_emit_[80] = {
    0xa4, 0x30, 0xa4, 0x31, 0xa4, 0x32, 0xa4, 0x61, 0xa4, 0x63, 0xa4, 0x65,
    0xa4, 0x69, 0xa4, 0x6f, 0xa4, 0x73, 0xa4, 0x74, 0xa9, 0x30, 0xa9, 0x31,
    0xa9, 0x32, 0xa9, 0x61, 0xa9, 0x63, 0xa9, 0x65, 0xa9, 0x69, 0xa9, 0x6f,
    0xa9, 0x73, 0xa9, 0x74, 0xaa, 0x30, 0xaa, 0x31, 0xaa, 0x32, 0xaa, 0x61,
    0xaa, 0x63, 0xaa, 0x65, 0xaa, 0x69, 0xaa, 0x6f, 0xaa, 0x73, 0xaa, 0x74,
    0xad, 0x30, 0xad, 0x31, 0xad, 0x32, 0xad, 0x61, 0xad, 0x63, 0xad, 0x65,
    0xad, 0x69, 0xad, 0x6f, 0xad, 0x73, 0xad, 0x74};
const uint8_t HuffDecoderCommon::table28_56_emit_[80] = {
    0xb2, 0x30, 0xb2, 0x31, 0xb2, 0x32, 0xb2, 0x61, 0xb2, 0x63, 0xb2, 0x65,
    0xb2, 0x69, 0xb2, 0x6f, 0xb2, 0x73, 0xb2, 0x74, 0xb5, 0x30, 0xb5, 0x31,
    0xb5, 0x32, 0xb5, 0x61, 0xb5, 0x63, 0xb5, 0x65, 0xb5, 0x69, 0xb5, 0x6f,
    0xb5, 0x73, 0xb5, 0x74, 0xb9, 0x30, 0xb9, 0x31, 0xb9, 0x32, 0xb9, 0x61,
    0xb9, 0x63, 0xb9, 0x65, 0xb9, 0x69, 0xb9, 0x6f, 0xb9, 0x73, 0xb9, 0x74,
    0xba, 0x30, 0xba, 0x31, 0xba, 0x32, 0xba, 0x61, 0xba, 0x63, 0xba, 0x65,
    0xba, 0x69, 0xba, 0x6f, 0xba, 0x73, 0xba, 0x74};
const uint8_t HuffDecoderCommon::table28_57_emit_[80] = {
    0xbb, 0x30, 0xbb, 0x31, 0xbb, 0x32, 0xbb, 0x61, 0xbb, 0x63, 0xbb, 0x65,
    0xbb, 0x69, 0xbb, 0x6f, 0xbb, 0x73, 0xbb, 0x74, 0xbd, 0x30, 0xbd, 0x31,
    0xbd, 0x32, 0xbd, 0x61, 0xbd, 0x63, 0xbd, 0x65, 0xbd, 0x69, 0xbd, 0x6f,
    0xbd, 0x73, 0xbd, 0x74, 0xbe, 0x30, 0xbe, 0x31, 0xbe, 0x32, 0xbe, 0x61,
    0xbe, 0x63, 0xbe, 0x65, 0xbe, 0x69, 0xbe, 0x6f, 0xbe, 0x73, 0xbe, 0x74,
    0xc4, 0x30, 0xc4, 0x31, 0xc4, 0x32, 0xc4, 0x61, 0xc4, 0x63, 0xc4, 0x65,
    0xc4, 0x69, 0xc4, 0x6f, 0xc4, 0x73, 0xc4, 0x74};
const uint8_t HuffDecoderCommon::table28_58_emit_[80] = {
    0xc6, 0x30, 0xc6, 0x31, 0xc6, 0x32, 0xc6, 0x61, 0xc6, 0x63, 0xc6, 0x65,
    0xc6, 0x69, 0xc6, 0x6f, 0xc6, 0x73, 0xc6, 0x74, 0xe4, 0x30, 0xe4, 0x31,
    0xe4, 0x32, 0xe4, 0x61, 0xe4, 0x63, 0xe4, 0x65, 0xe4, 0x69, 0xe4, 0x6f,
    0xe4, 0x73, 0xe4, 0x74, 0xe8, 0x30, 0xe8, 0x31, 0xe8, 0x32, 0xe8, 0x61,
    0xe8, 0x63, 0xe8, 0x65, 0xe8, 0x69, 0xe8, 0x6f, 0xe8, 0x73, 0xe8, 0x74,
    0xe9, 0x30, 0xe9, 0x31, 0xe9, 0x32, 0xe9, 0x61, 0xe9, 0x63, 0xe9, 0x65,
    0xe9, 0x69, 0xe9, 0x6f, 0xe9, 0x73, 0xe9, 0x74};
const uint16_t HuffDecoderCommon::table28_59_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x001b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0023, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x002b, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x003b};
const uint16_t HuffDecoderCommon::table28_62_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x001b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0023, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x002b, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0033, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x003b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x004b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0053};
const uint8_t HuffDecoderCommon::table28_63_emit_[44] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb, 0xc0,
    0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee, 0xf0,
    0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf,
    0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe};
const uint16_t HuffDecoderCommon::table28_63_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0013, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x001b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0023, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x002b, 0x0000, 0x0000, 0x0000, 0x0033, 0x0000, 0x0000,
    0x0000, 0x003b, 0x0000, 0x0000, 0x0000, 0x0043, 0x0000, 0x0000, 0x0000,
    0x004b, 0x0000, 0x0053, 0x0000, 0x005b, 0x0000, 0x0063, 0x0000, 0x006b,
    0x0000, 0x0073, 0x0000, 0x007b, 0x0000, 0x0083, 0x0000, 0x008b, 0x0000,
    0x0093, 0x0000, 0x009b, 0x0000, 0x00a3, 0x0000, 0x00ab, 0x0000, 0x00b3,
    0x0000, 0x00bb, 0x0000, 0x00c3, 0x00cb, 0x00d3, 0x00db, 0x00e3, 0x00eb,
    0x00f3, 0x00fb, 0x0103, 0x010b, 0x0113, 0x011b, 0x0123, 0x012b, 0x0133,
    0x013b, 0x0143, 0x014b, 0x0153, 0x015b, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0004};
const uint8_t* const HuffDecoderCommon::table28_emit_[64] = {
    table28_0_emit_,  table28_1_emit_,  table28_2_emit_,  table28_3_emit_,
    table28_4_emit_,  table28_5_emit_,  table28_6_emit_,  table28_7_emit_,
    table28_8_emit_,  table28_9_emit_,  table28_10_emit_, table28_11_emit_,
    table28_12_emit_, table28_13_emit_, table28_14_emit_, table28_15_emit_,
    table28_16_emit_, table28_17_emit_, table28_18_emit_, table28_19_emit_,
    table28_20_emit_, table28_21_emit_, table28_22_emit_, table28_23_emit_,
    table28_24_emit_, table28_25_emit_, table28_26_emit_, table28_27_emit_,
    table28_28_emit_, table28_29_emit_, table28_30_emit_, table28_31_emit_,
    table27_32_emit_, table28_33_emit_, table27_34_emit_, table28_35_emit_,
    table27_36_emit_, table28_37_emit_, table28_38_emit_, table28_39_emit_,
    table28_40_emit_, table28_41_emit_, table28_42_emit_, table28_43_emit_,
    table28_44_emit_, table28_45_emit_, table28_46_emit_, table28_47_emit_,
    table28_48_emit_, table28_49_emit_, table28_50_emit_, table28_51_emit_,
    table28_52_emit_, table28_53_emit_, table28_54_emit_, table28_55_emit_,
    table28_56_emit_, table28_57_emit_, table28_58_emit_, table27_59_emit_,
    table27_60_emit_, table27_61_emit_, table27_62_emit_, table28_63_emit_,
};
const uint16_t* const HuffDecoderCommon::table28_ops_[64] = {
    table28_0_ops_,  table28_0_ops_,  table28_0_ops_,  table28_0_ops_,
    table28_0_ops_,  table28_0_ops_,  table28_0_ops_,  table28_0_ops_,
    table28_0_ops_,  table28_0_ops_,  table28_10_ops_, table28_10_ops_,
    table28_10_ops_, table28_10_ops_, table28_10_ops_, table28_10_ops_,
    table28_10_ops_, table28_10_ops_, table28_10_ops_, table28_10_ops_,
    table28_10_ops_, table28_10_ops_, table28_10_ops_, table28_23_ops_,
    table28_23_ops_, table28_23_ops_, table28_23_ops_, table28_23_ops_,
    table28_23_ops_, table28_23_ops_, table28_23_ops_, table28_31_ops_,
    table28_32_ops_, table28_33_ops_, table28_32_ops_, table28_33_ops_,
    table28_32_ops_, table28_33_ops_, table28_38_ops_, table28_38_ops_,
    table28_38_ops_, table28_38_ops_, table28_38_ops_, table28_38_ops_,
    table28_38_ops_, table28_38_ops_, table28_46_ops_, table28_46_ops_,
    table28_46_ops_, table28_46_ops_, table28_46_ops_, table28_46_ops_,
    table28_52_ops_, table28_53_ops_, table28_53_ops_, table28_53_ops_,
    table28_53_ops_, table28_53_ops_, table28_53_ops_, table28_59_ops_,
    table28_59_ops_, table28_59_ops_, table28_62_ops_, table28_63_ops_,
};
const uint8_t HuffDecoderCommon::table29_0_emit_[66] = {
    0x7b, 0x30, 0x30, 0x7b, 0x30, 0x31, 0x7b, 0x30, 0x32, 0x7b, 0x30,
    0x61, 0x7b, 0x30, 0x63, 0x7b, 0x30, 0x65, 0x7b, 0x30, 0x69, 0x7b,
    0x30, 0x6f, 0x7b, 0x30, 0x73, 0x7b, 0x30, 0x74, 0x7b, 0x30, 0x20,
    0x7b, 0x30, 0x25, 0x7b, 0x30, 0x2d, 0x7b, 0x30, 0x2e, 0x7b, 0x30,
    0x2f, 0x7b, 0x30, 0x33, 0x7b, 0x30, 0x34, 0x7b, 0x30, 0x35, 0x7b,
    0x30, 0x36, 0x7b, 0x30, 0x37, 0x7b, 0x30, 0x38, 0x7b, 0x30, 0x39};
const uint16_t HuffDecoderCommon::table29_0_inner_[23] = {
    0x0000, 0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091,
    0x00a9, 0x00c1, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151,
    0x0169, 0x0181, 0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9};
const uint8_t HuffDecoderCommon::table29_0_outer_[128] = {
    0, 0,  0, 0,  0, 0,  0, 1,  0, 0,  0, 0,  0, 0,  0, 2,  0, 0,  0, 0,  0, 0,
    0, 3,  0, 0,  0, 0,  0, 0,  0, 4,  0, 0,  0, 0,  0, 0,  0, 5,  0, 0,  0, 0,
    0, 0,  0, 6,  0, 0,  0, 0,  0, 0,  0, 7,  0, 0,  0, 0,  0, 0,  0, 8,  0, 0,
    0, 0,  0, 0,  0, 9,  0, 0,  0, 0,  0, 0,  0, 10, 0, 0,  0, 11, 0, 0,  0, 12,
    0, 0,  0, 13, 0, 0,  0, 14, 0, 0,  0, 15, 0, 0,  0, 16, 0, 0,  0, 17, 0, 0,
    0, 18, 0, 0,  0, 19, 0, 0,  0, 20, 0, 0,  0, 21, 0, 0,  0, 22};
const uint8_t HuffDecoderCommon::table29_1_emit_[156] = {
    0x7b, 0x30, 0x3d, 0x7b, 0x30, 0x41, 0x7b, 0x30, 0x5f, 0x7b, 0x30, 0x62,
    0x7b, 0x30, 0x64, 0x7b, 0x30, 0x66, 0x7b, 0x30, 0x67, 0x7b, 0x30, 0x68,
    0x7b, 0x30, 0x6c, 0x7b, 0x30, 0x6d, 0x7b, 0x30, 0x6e, 0x7b, 0x30, 0x70,
    0x7b, 0x30, 0x72, 0x7b, 0x30, 0x75, 0x7b, 0x30, 0x3a, 0x7b, 0x30, 0x42,
    0x7b, 0x30, 0x43, 0x7b, 0x30, 0x44, 0x7b, 0x30, 0x45, 0x7b, 0x30, 0x46,
    0x7b, 0x30, 0x47, 0x7b, 0x30, 0x48, 0x7b, 0x30, 0x49, 0x7b, 0x30, 0x4a,
    0x7b, 0x30, 0x4b, 0x7b, 0x30, 0x4c, 0x7b, 0x30, 0x4d, 0x7b, 0x30, 0x4e,
    0x7b, 0x30, 0x4f, 0x7b, 0x30, 0x50, 0x7b, 0x30, 0x51, 0x7b, 0x30, 0x52,
    0x7b, 0x30, 0x53, 0x7b, 0x30, 0x54, 0x7b, 0x30, 0x55, 0x7b, 0x30, 0x56,
    0x7b, 0x30, 0x57, 0x7b, 0x30, 0x59, 0x7b, 0x30, 0x6a, 0x7b, 0x30, 0x6b,
    0x7b, 0x30, 0x71, 0x7b, 0x30, 0x76, 0x7b, 0x30, 0x77, 0x7b, 0x30, 0x78,
    0x7b, 0x30, 0x79, 0x7b, 0x30, 0x7a, 0x7b, 0x30, 0x26, 0x7b, 0x30, 0x2a,
    0x7b, 0x30, 0x2c, 0x7b, 0x30, 0x3b, 0x7b, 0x30, 0x58, 0x7b, 0x30, 0x5a};
const uint16_t HuffDecoderCommon::table29_1_inner_[54] = {
    0x0000, 0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9,
    0x00c1, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169, 0x0181,
    0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259,
    0x0271, 0x0289, 0x02a1, 0x02b9, 0x02d1, 0x02e9, 0x0301, 0x0319, 0x0331,
    0x0349, 0x0361, 0x0379, 0x0391, 0x03a9, 0x03c1, 0x03d9, 0x03f1, 0x0409,
    0x0421, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9, 0x0002};
const uint8_t HuffDecoderCommon::table29_1_outer_[128] = {
    0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,
    5,  0,  0,  0,  6,  0,  0,  0,  7,  0,  0,  0,  8,  0,  0,  0,  9,  0,  0,
    0,  10, 0,  0,  0,  11, 0,  0,  0,  12, 0,  0,  0,  13, 0,  0,  0,  14, 0,
    15, 0,  16, 0,  17, 0,  18, 0,  19, 0,  20, 0,  21, 0,  22, 0,  23, 0,  24,
    0,  25, 0,  26, 0,  27, 0,  28, 0,  29, 0,  30, 0,  31, 0,  32, 0,  33, 0,
    34, 0,  35, 0,  36, 0,  37, 0,  38, 0,  39, 0,  40, 0,  41, 0,  42, 0,  43,
    0,  44, 0,  45, 0,  46, 47, 48, 49, 50, 51, 52, 0,  53};
const uint8_t HuffDecoderCommon::table29_2_emit_[66] = {
    0x7b, 0x31, 0x30, 0x7b, 0x31, 0x31, 0x7b, 0x31, 0x32, 0x7b, 0x31,
    0x61, 0x7b, 0x31, 0x63, 0x7b, 0x31, 0x65, 0x7b, 0x31, 0x69, 0x7b,
    0x31, 0x6f, 0x7b, 0x31, 0x73, 0x7b, 0x31, 0x74, 0x7b, 0x31, 0x20,
    0x7b, 0x31, 0x25, 0x7b, 0x31, 0x2d, 0x7b, 0x31, 0x2e, 0x7b, 0x31,
    0x2f, 0x7b, 0x31, 0x33, 0x7b, 0x31, 0x34, 0x7b, 0x31, 0x35, 0x7b,
    0x31, 0x36, 0x7b, 0x31, 0x37, 0x7b, 0x31, 0x38, 0x7b, 0x31, 0x39};
const uint8_t HuffDecoderCommon::table29_3_emit_[156] = {
    0x7b, 0x31, 0x3d, 0x7b, 0x31, 0x41, 0x7b, 0x31, 0x5f, 0x7b, 0x31, 0x62,
    0x7b, 0x31, 0x64, 0x7b, 0x31, 0x66, 0x7b, 0x31, 0x67, 0x7b, 0x31, 0x68,
    0x7b, 0x31, 0x6c, 0x7b, 0x31, 0x6d, 0x7b, 0x31, 0x6e, 0x7b, 0x31, 0x70,
    0x7b, 0x31, 0x72, 0x7b, 0x31, 0x75, 0x7b, 0x31, 0x3a, 0x7b, 0x31, 0x42,
    0x7b, 0x31, 0x43, 0x7b, 0x31, 0x44, 0x7b, 0x31, 0x45, 0x7b, 0x31, 0x46,
    0x7b, 0x31, 0x47, 0x7b, 0x31, 0x48, 0x7b, 0x31, 0x49, 0x7b, 0x31, 0x4a,
    0x7b, 0x31, 0x4b, 0x7b, 0x31, 0x4c, 0x7b, 0x31, 0x4d, 0x7b, 0x31, 0x4e,
    0x7b, 0x31, 0x4f, 0x7b, 0x31, 0x50, 0x7b, 0x31, 0x51, 0x7b, 0x31, 0x52,
    0x7b, 0x31, 0x53, 0x7b, 0x31, 0x54, 0x7b, 0x31, 0x55, 0x7b, 0x31, 0x56,
    0x7b, 0x31, 0x57, 0x7b, 0x31, 0x59, 0x7b, 0x31, 0x6a, 0x7b, 0x31, 0x6b,
    0x7b, 0x31, 0x71, 0x7b, 0x31, 0x76, 0x7b, 0x31, 0x77, 0x7b, 0x31, 0x78,
    0x7b, 0x31, 0x79, 0x7b, 0x31, 0x7a, 0x7b, 0x31, 0x26, 0x7b, 0x31, 0x2a,
    0x7b, 0x31, 0x2c, 0x7b, 0x31, 0x3b, 0x7b, 0x31, 0x58, 0x7b, 0x31, 0x5a};
const uint8_t HuffDecoderCommon::table29_4_emit_[66] = {
    0x7b, 0x32, 0x30, 0x7b, 0x32, 0x31, 0x7b, 0x32, 0x32, 0x7b, 0x32,
    0x61, 0x7b, 0x32, 0x63, 0x7b, 0x32, 0x65, 0x7b, 0x32, 0x69, 0x7b,
    0x32, 0x6f, 0x7b, 0x32, 0x73, 0x7b, 0x32, 0x74, 0x7b, 0x32, 0x20,
    0x7b, 0x32, 0x25, 0x7b, 0x32, 0x2d, 0x7b, 0x32, 0x2e, 0x7b, 0x32,
    0x2f, 0x7b, 0x32, 0x33, 0x7b, 0x32, 0x34, 0x7b, 0x32, 0x35, 0x7b,
    0x32, 0x36, 0x7b, 0x32, 0x37, 0x7b, 0x32, 0x38, 0x7b, 0x32, 0x39};
const uint8_t HuffDecoderCommon::table29_5_emit_[156] = {
    0x7b, 0x32, 0x3d, 0x7b, 0x32, 0x41, 0x7b, 0x32, 0x5f, 0x7b, 0x32, 0x62,
    0x7b, 0x32, 0x64, 0x7b, 0x32, 0x66, 0x7b, 0x32, 0x67, 0x7b, 0x32, 0x68,
    0x7b, 0x32, 0x6c, 0x7b, 0x32, 0x6d, 0x7b, 0x32, 0x6e, 0x7b, 0x32, 0x70,
    0x7b, 0x32, 0x72, 0x7b, 0x32, 0x75, 0x7b, 0x32, 0x3a, 0x7b, 0x32, 0x42,
    0x7b, 0x32, 0x43, 0x7b, 0x32, 0x44, 0x7b, 0x32, 0x45, 0x7b, 0x32, 0x46,
    0x7b, 0x32, 0x47, 0x7b, 0x32, 0x48, 0x7b, 0x32, 0x49, 0x7b, 0x32, 0x4a,
    0x7b, 0x32, 0x4b, 0x7b, 0x32, 0x4c, 0x7b, 0x32, 0x4d, 0x7b, 0x32, 0x4e,
    0x7b, 0x32, 0x4f, 0x7b, 0x32, 0x50, 0x7b, 0x32, 0x51, 0x7b, 0x32, 0x52,
    0x7b, 0x32, 0x53, 0x7b, 0x32, 0x54, 0x7b, 0x32, 0x55, 0x7b, 0x32, 0x56,
    0x7b, 0x32, 0x57, 0x7b, 0x32, 0x59, 0x7b, 0x32, 0x6a, 0x7b, 0x32, 0x6b,
    0x7b, 0x32, 0x71, 0x7b, 0x32, 0x76, 0x7b, 0x32, 0x77, 0x7b, 0x32, 0x78,
    0x7b, 0x32, 0x79, 0x7b, 0x32, 0x7a, 0x7b, 0x32, 0x26, 0x7b, 0x32, 0x2a,
    0x7b, 0x32, 0x2c, 0x7b, 0x32, 0x3b, 0x7b, 0x32, 0x58, 0x7b, 0x32, 0x5a};
const uint8_t HuffDecoderCommon::table29_6_emit_[66] = {
    0x7b, 0x61, 0x30, 0x7b, 0x61, 0x31, 0x7b, 0x61, 0x32, 0x7b, 0x61,
    0x61, 0x7b, 0x61, 0x63, 0x7b, 0x61, 0x65, 0x7b, 0x61, 0x69, 0x7b,
    0x61, 0x6f, 0x7b, 0x61, 0x73, 0x7b, 0x61, 0x74, 0x7b, 0x61, 0x20,
    0x7b, 0x61, 0x25, 0x7b, 0x61, 0x2d, 0x7b, 0x61, 0x2e, 0x7b, 0x61,
    0x2f, 0x7b, 0x61, 0x33, 0x7b, 0x61, 0x34, 0x7b, 0x61, 0x35, 0x7b,
    0x61, 0x36, 0x7b, 0x61, 0x37, 0x7b, 0x61, 0x38, 0x7b, 0x61, 0x39};
const uint8_t HuffDecoderCommon::table29_7_emit_[156] = {
    0x7b, 0x61, 0x3d, 0x7b, 0x61, 0x41, 0x7b, 0x61, 0x5f, 0x7b, 0x61, 0x62,
    0x7b, 0x61, 0x64, 0x7b, 0x61, 0x66, 0x7b, 0x61, 0x67, 0x7b, 0x61, 0x68,
    0x7b, 0x61, 0x6c, 0x7b, 0x61, 0x6d, 0x7b, 0x61, 0x6e, 0x7b, 0x61, 0x70,
    0x7b, 0x61, 0x72, 0x7b, 0x61, 0x75, 0x7b, 0x61, 0x3a, 0x7b, 0x61, 0x42,
    0x7b, 0x61, 0x43, 0x7b, 0x61, 0x44, 0x7b, 0x61, 0x45, 0x7b, 0x61, 0x46,
    0x7b, 0x61, 0x47, 0x7b, 0x61, 0x48, 0x7b, 0x61, 0x49, 0x7b, 0x61, 0x4a,
    0x7b, 0x61, 0x4b, 0x7b, 0x61, 0x4c, 0x7b, 0x61, 0x4d, 0x7b, 0x61, 0x4e,
    0x7b, 0x61, 0x4f, 0x7b, 0x61, 0x50, 0x7b, 0x61, 0x51, 0x7b, 0x61, 0x52,
    0x7b, 0x61, 0x53, 0x7b, 0x61, 0x54, 0x7b, 0x61, 0x55, 0x7b, 0x61, 0x56,
    0x7b, 0x61, 0x57, 0x7b, 0x61, 0x59, 0x7b, 0x61, 0x6a, 0x7b, 0x61, 0x6b,
    0x7b, 0x61, 0x71, 0x7b, 0x61, 0x76, 0x7b, 0x61, 0x77, 0x7b, 0x61, 0x78,
    0x7b, 0x61, 0x79, 0x7b, 0x61, 0x7a, 0x7b, 0x61, 0x26, 0x7b, 0x61, 0x2a,
    0x7b, 0x61, 0x2c, 0x7b, 0x61, 0x3b, 0x7b, 0x61, 0x58, 0x7b, 0x61, 0x5a};
const uint8_t HuffDecoderCommon::table29_8_emit_[66] = {
    0x7b, 0x63, 0x30, 0x7b, 0x63, 0x31, 0x7b, 0x63, 0x32, 0x7b, 0x63,
    0x61, 0x7b, 0x63, 0x63, 0x7b, 0x63, 0x65, 0x7b, 0x63, 0x69, 0x7b,
    0x63, 0x6f, 0x7b, 0x63, 0x73, 0x7b, 0x63, 0x74, 0x7b, 0x63, 0x20,
    0x7b, 0x63, 0x25, 0x7b, 0x63, 0x2d, 0x7b, 0x63, 0x2e, 0x7b, 0x63,
    0x2f, 0x7b, 0x63, 0x33, 0x7b, 0x63, 0x34, 0x7b, 0x63, 0x35, 0x7b,
    0x63, 0x36, 0x7b, 0x63, 0x37, 0x7b, 0x63, 0x38, 0x7b, 0x63, 0x39};
const uint8_t HuffDecoderCommon::table29_9_emit_[156] = {
    0x7b, 0x63, 0x3d, 0x7b, 0x63, 0x41, 0x7b, 0x63, 0x5f, 0x7b, 0x63, 0x62,
    0x7b, 0x63, 0x64, 0x7b, 0x63, 0x66, 0x7b, 0x63, 0x67, 0x7b, 0x63, 0x68,
    0x7b, 0x63, 0x6c, 0x7b, 0x63, 0x6d, 0x7b, 0x63, 0x6e, 0x7b, 0x63, 0x70,
    0x7b, 0x63, 0x72, 0x7b, 0x63, 0x75, 0x7b, 0x63, 0x3a, 0x7b, 0x63, 0x42,
    0x7b, 0x63, 0x43, 0x7b, 0x63, 0x44, 0x7b, 0x63, 0x45, 0x7b, 0x63, 0x46,
    0x7b, 0x63, 0x47, 0x7b, 0x63, 0x48, 0x7b, 0x63, 0x49, 0x7b, 0x63, 0x4a,
    0x7b, 0x63, 0x4b, 0x7b, 0x63, 0x4c, 0x7b, 0x63, 0x4d, 0x7b, 0x63, 0x4e,
    0x7b, 0x63, 0x4f, 0x7b, 0x63, 0x50, 0x7b, 0x63, 0x51, 0x7b, 0x63, 0x52,
    0x7b, 0x63, 0x53, 0x7b, 0x63, 0x54, 0x7b, 0x63, 0x55, 0x7b, 0x63, 0x56,
    0x7b, 0x63, 0x57, 0x7b, 0x63, 0x59, 0x7b, 0x63, 0x6a, 0x7b, 0x63, 0x6b,
    0x7b, 0x63, 0x71, 0x7b, 0x63, 0x76, 0x7b, 0x63, 0x77, 0x7b, 0x63, 0x78,
    0x7b, 0x63, 0x79, 0x7b, 0x63, 0x7a, 0x7b, 0x63, 0x26, 0x7b, 0x63, 0x2a,
    0x7b, 0x63, 0x2c, 0x7b, 0x63, 0x3b, 0x7b, 0x63, 0x58, 0x7b, 0x63, 0x5a};
const uint8_t HuffDecoderCommon::table29_10_emit_[66] = {
    0x7b, 0x65, 0x30, 0x7b, 0x65, 0x31, 0x7b, 0x65, 0x32, 0x7b, 0x65,
    0x61, 0x7b, 0x65, 0x63, 0x7b, 0x65, 0x65, 0x7b, 0x65, 0x69, 0x7b,
    0x65, 0x6f, 0x7b, 0x65, 0x73, 0x7b, 0x65, 0x74, 0x7b, 0x65, 0x20,
    0x7b, 0x65, 0x25, 0x7b, 0x65, 0x2d, 0x7b, 0x65, 0x2e, 0x7b, 0x65,
    0x2f, 0x7b, 0x65, 0x33, 0x7b, 0x65, 0x34, 0x7b, 0x65, 0x35, 0x7b,
    0x65, 0x36, 0x7b, 0x65, 0x37, 0x7b, 0x65, 0x38, 0x7b, 0x65, 0x39};
const uint8_t HuffDecoderCommon::table29_11_emit_[156] = {
    0x7b, 0x65, 0x3d, 0x7b, 0x65, 0x41, 0x7b, 0x65, 0x5f, 0x7b, 0x65, 0x62,
    0x7b, 0x65, 0x64, 0x7b, 0x65, 0x66, 0x7b, 0x65, 0x67, 0x7b, 0x65, 0x68,
    0x7b, 0x65, 0x6c, 0x7b, 0x65, 0x6d, 0x7b, 0x65, 0x6e, 0x7b, 0x65, 0x70,
    0x7b, 0x65, 0x72, 0x7b, 0x65, 0x75, 0x7b, 0x65, 0x3a, 0x7b, 0x65, 0x42,
    0x7b, 0x65, 0x43, 0x7b, 0x65, 0x44, 0x7b, 0x65, 0x45, 0x7b, 0x65, 0x46,
    0x7b, 0x65, 0x47, 0x7b, 0x65, 0x48, 0x7b, 0x65, 0x49, 0x7b, 0x65, 0x4a,
    0x7b, 0x65, 0x4b, 0x7b, 0x65, 0x4c, 0x7b, 0x65, 0x4d, 0x7b, 0x65, 0x4e,
    0x7b, 0x65, 0x4f, 0x7b, 0x65, 0x50, 0x7b, 0x65, 0x51, 0x7b, 0x65, 0x52,
    0x7b, 0x65, 0x53, 0x7b, 0x65, 0x54, 0x7b, 0x65, 0x55, 0x7b, 0x65, 0x56,
    0x7b, 0x65, 0x57, 0x7b, 0x65, 0x59, 0x7b, 0x65, 0x6a, 0x7b, 0x65, 0x6b,
    0x7b, 0x65, 0x71, 0x7b, 0x65, 0x76, 0x7b, 0x65, 0x77, 0x7b, 0x65, 0x78,
    0x7b, 0x65, 0x79, 0x7b, 0x65, 0x7a, 0x7b, 0x65, 0x26, 0x7b, 0x65, 0x2a,
    0x7b, 0x65, 0x2c, 0x7b, 0x65, 0x3b, 0x7b, 0x65, 0x58, 0x7b, 0x65, 0x5a};
const uint8_t HuffDecoderCommon::table29_12_emit_[66] = {
    0x7b, 0x69, 0x30, 0x7b, 0x69, 0x31, 0x7b, 0x69, 0x32, 0x7b, 0x69,
    0x61, 0x7b, 0x69, 0x63, 0x7b, 0x69, 0x65, 0x7b, 0x69, 0x69, 0x7b,
    0x69, 0x6f, 0x7b, 0x69, 0x73, 0x7b, 0x69, 0x74, 0x7b, 0x69, 0x20,
    0x7b, 0x69, 0x25, 0x7b, 0x69, 0x2d, 0x7b, 0x69, 0x2e, 0x7b, 0x69,
    0x2f, 0x7b, 0x69, 0x33, 0x7b, 0x69, 0x34, 0x7b, 0x69, 0x35, 0x7b,
    0x69, 0x36, 0x7b, 0x69, 0x37, 0x7b, 0x69, 0x38, 0x7b, 0x69, 0x39};
const uint8_t HuffDecoderCommon::table29_13_emit_[156] = {
    0x7b, 0x69, 0x3d, 0x7b, 0x69, 0x41, 0x7b, 0x69, 0x5f, 0x7b, 0x69, 0x62,
    0x7b, 0x69, 0x64, 0x7b, 0x69, 0x66, 0x7b, 0x69, 0x67, 0x7b, 0x69, 0x68,
    0x7b, 0x69, 0x6c, 0x7b, 0x69, 0x6d, 0x7b, 0x69, 0x6e, 0x7b, 0x69, 0x70,
    0x7b, 0x69, 0x72, 0x7b, 0x69, 0x75, 0x7b, 0x69, 0x3a, 0x7b, 0x69, 0x42,
    0x7b, 0x69, 0x43, 0x7b, 0x69, 0x44, 0x7b, 0x69, 0x45, 0x7b, 0x69, 0x46,
    0x7b, 0x69, 0x47, 0x7b, 0x69, 0x48, 0x7b, 0x69, 0x49, 0x7b, 0x69, 0x4a,
    0x7b, 0x69, 0x4b, 0x7b, 0x69, 0x4c, 0x7b, 0x69, 0x4d, 0x7b, 0x69, 0x4e,
    0x7b, 0x69, 0x4f, 0x7b, 0x69, 0x50, 0x7b, 0x69, 0x51, 0x7b, 0x69, 0x52,
    0x7b, 0x69, 0x53, 0x7b, 0x69, 0x54, 0x7b, 0x69, 0x55, 0x7b, 0x69, 0x56,
    0x7b, 0x69, 0x57, 0x7b, 0x69, 0x59, 0x7b, 0x69, 0x6a, 0x7b, 0x69, 0x6b,
    0x7b, 0x69, 0x71, 0x7b, 0x69, 0x76, 0x7b, 0x69, 0x77, 0x7b, 0x69, 0x78,
    0x7b, 0x69, 0x79, 0x7b, 0x69, 0x7a, 0x7b, 0x69, 0x26, 0x7b, 0x69, 0x2a,
    0x7b, 0x69, 0x2c, 0x7b, 0x69, 0x3b, 0x7b, 0x69, 0x58, 0x7b, 0x69, 0x5a};
const uint8_t HuffDecoderCommon::table29_14_emit_[66] = {
    0x7b, 0x6f, 0x30, 0x7b, 0x6f, 0x31, 0x7b, 0x6f, 0x32, 0x7b, 0x6f,
    0x61, 0x7b, 0x6f, 0x63, 0x7b, 0x6f, 0x65, 0x7b, 0x6f, 0x69, 0x7b,
    0x6f, 0x6f, 0x7b, 0x6f, 0x73, 0x7b, 0x6f, 0x74, 0x7b, 0x6f, 0x20,
    0x7b, 0x6f, 0x25, 0x7b, 0x6f, 0x2d, 0x7b, 0x6f, 0x2e, 0x7b, 0x6f,
    0x2f, 0x7b, 0x6f, 0x33, 0x7b, 0x6f, 0x34, 0x7b, 0x6f, 0x35, 0x7b,
    0x6f, 0x36, 0x7b, 0x6f, 0x37, 0x7b, 0x6f, 0x38, 0x7b, 0x6f, 0x39};
const uint8_t HuffDecoderCommon::table29_15_emit_[156] = {
    0x7b, 0x6f, 0x3d, 0x7b, 0x6f, 0x41, 0x7b, 0x6f, 0x5f, 0x7b, 0x6f, 0x62,
    0x7b, 0x6f, 0x64, 0x7b, 0x6f, 0x66, 0x7b, 0x6f, 0x67, 0x7b, 0x6f, 0x68,
    0x7b, 0x6f, 0x6c, 0x7b, 0x6f, 0x6d, 0x7b, 0x6f, 0x6e, 0x7b, 0x6f, 0x70,
    0x7b, 0x6f, 0x72, 0x7b, 0x6f, 0x75, 0x7b, 0x6f, 0x3a, 0x7b, 0x6f, 0x42,
    0x7b, 0x6f, 0x43, 0x7b, 0x6f, 0x44, 0x7b, 0x6f, 0x45, 0x7b, 0x6f, 0x46,
    0x7b, 0x6f, 0x47, 0x7b, 0x6f, 0x48, 0x7b, 0x6f, 0x49, 0x7b, 0x6f, 0x4a,
    0x7b, 0x6f, 0x4b, 0x7b, 0x6f, 0x4c, 0x7b, 0x6f, 0x4d, 0x7b, 0x6f, 0x4e,
    0x7b, 0x6f, 0x4f, 0x7b, 0x6f, 0x50, 0x7b, 0x6f, 0x51, 0x7b, 0x6f, 0x52,
    0x7b, 0x6f, 0x53, 0x7b, 0x6f, 0x54, 0x7b, 0x6f, 0x55, 0x7b, 0x6f, 0x56,
    0x7b, 0x6f, 0x57, 0x7b, 0x6f, 0x59, 0x7b, 0x6f, 0x6a, 0x7b, 0x6f, 0x6b,
    0x7b, 0x6f, 0x71, 0x7b, 0x6f, 0x76, 0x7b, 0x6f, 0x77, 0x7b, 0x6f, 0x78,
    0x7b, 0x6f, 0x79, 0x7b, 0x6f, 0x7a, 0x7b, 0x6f, 0x26, 0x7b, 0x6f, 0x2a,
    0x7b, 0x6f, 0x2c, 0x7b, 0x6f, 0x3b, 0x7b, 0x6f, 0x58, 0x7b, 0x6f, 0x5a};
const uint8_t HuffDecoderCommon::table29_16_emit_[66] = {
    0x7b, 0x73, 0x30, 0x7b, 0x73, 0x31, 0x7b, 0x73, 0x32, 0x7b, 0x73,
    0x61, 0x7b, 0x73, 0x63, 0x7b, 0x73, 0x65, 0x7b, 0x73, 0x69, 0x7b,
    0x73, 0x6f, 0x7b, 0x73, 0x73, 0x7b, 0x73, 0x74, 0x7b, 0x73, 0x20,
    0x7b, 0x73, 0x25, 0x7b, 0x73, 0x2d, 0x7b, 0x73, 0x2e, 0x7b, 0x73,
    0x2f, 0x7b, 0x73, 0x33, 0x7b, 0x73, 0x34, 0x7b, 0x73, 0x35, 0x7b,
    0x73, 0x36, 0x7b, 0x73, 0x37, 0x7b, 0x73, 0x38, 0x7b, 0x73, 0x39};
const uint8_t HuffDecoderCommon::table29_17_emit_[156] = {
    0x7b, 0x73, 0x3d, 0x7b, 0x73, 0x41, 0x7b, 0x73, 0x5f, 0x7b, 0x73, 0x62,
    0x7b, 0x73, 0x64, 0x7b, 0x73, 0x66, 0x7b, 0x73, 0x67, 0x7b, 0x73, 0x68,
    0x7b, 0x73, 0x6c, 0x7b, 0x73, 0x6d, 0x7b, 0x73, 0x6e, 0x7b, 0x73, 0x70,
    0x7b, 0x73, 0x72, 0x7b, 0x73, 0x75, 0x7b, 0x73, 0x3a, 0x7b, 0x73, 0x42,
    0x7b, 0x73, 0x43, 0x7b, 0x73, 0x44, 0x7b, 0x73, 0x45, 0x7b, 0x73, 0x46,
    0x7b, 0x73, 0x47, 0x7b, 0x73, 0x48, 0x7b, 0x73, 0x49, 0x7b, 0x73, 0x4a,
    0x7b, 0x73, 0x4b, 0x7b, 0x73, 0x4c, 0x7b, 0x73, 0x4d, 0x7b, 0x73, 0x4e,
    0x7b, 0x73, 0x4f, 0x7b, 0x73, 0x50, 0x7b, 0x73, 0x51, 0x7b, 0x73, 0x52,
    0x7b, 0x73, 0x53, 0x7b, 0x73, 0x54, 0x7b, 0x73, 0x55, 0x7b, 0x73, 0x56,
    0x7b, 0x73, 0x57, 0x7b, 0x73, 0x59, 0x7b, 0x73, 0x6a, 0x7b, 0x73, 0x6b,
    0x7b, 0x73, 0x71, 0x7b, 0x73, 0x76, 0x7b, 0x73, 0x77, 0x7b, 0x73, 0x78,
    0x7b, 0x73, 0x79, 0x7b, 0x73, 0x7a, 0x7b, 0x73, 0x26, 0x7b, 0x73, 0x2a,
    0x7b, 0x73, 0x2c, 0x7b, 0x73, 0x3b, 0x7b, 0x73, 0x58, 0x7b, 0x73, 0x5a};
const uint8_t HuffDecoderCommon::table29_18_emit_[66] = {
    0x7b, 0x74, 0x30, 0x7b, 0x74, 0x31, 0x7b, 0x74, 0x32, 0x7b, 0x74,
    0x61, 0x7b, 0x74, 0x63, 0x7b, 0x74, 0x65, 0x7b, 0x74, 0x69, 0x7b,
    0x74, 0x6f, 0x7b, 0x74, 0x73, 0x7b, 0x74, 0x74, 0x7b, 0x74, 0x20,
    0x7b, 0x74, 0x25, 0x7b, 0x74, 0x2d, 0x7b, 0x74, 0x2e, 0x7b, 0x74,
    0x2f, 0x7b, 0x74, 0x33, 0x7b, 0x74, 0x34, 0x7b, 0x74, 0x35, 0x7b,
    0x74, 0x36, 0x7b, 0x74, 0x37, 0x7b, 0x74, 0x38, 0x7b, 0x74, 0x39};
const uint8_t HuffDecoderCommon::table29_19_emit_[156] = {
    0x7b, 0x74, 0x3d, 0x7b, 0x74, 0x41, 0x7b, 0x74, 0x5f, 0x7b, 0x74, 0x62,
    0x7b, 0x74, 0x64, 0x7b, 0x74, 0x66, 0x7b, 0x74, 0x67, 0x7b, 0x74, 0x68,
    0x7b, 0x74, 0x6c, 0x7b, 0x74, 0x6d, 0x7b, 0x74, 0x6e, 0x7b, 0x74, 0x70,
    0x7b, 0x74, 0x72, 0x7b, 0x74, 0x75, 0x7b, 0x74, 0x3a, 0x7b, 0x74, 0x42,
    0x7b, 0x74, 0x43, 0x7b, 0x74, 0x44, 0x7b, 0x74, 0x45, 0x7b, 0x74, 0x46,
    0x7b, 0x74, 0x47, 0x7b, 0x74, 0x48, 0x7b, 0x74, 0x49, 0x7b, 0x74, 0x4a,
    0x7b, 0x74, 0x4b, 0x7b, 0x74, 0x4c, 0x7b, 0x74, 0x4d, 0x7b, 0x74, 0x4e,
    0x7b, 0x74, 0x4f, 0x7b, 0x74, 0x50, 0x7b, 0x74, 0x51, 0x7b, 0x74, 0x52,
    0x7b, 0x74, 0x53, 0x7b, 0x74, 0x54, 0x7b, 0x74, 0x55, 0x7b, 0x74, 0x56,
    0x7b, 0x74, 0x57, 0x7b, 0x74, 0x59, 0x7b, 0x74, 0x6a, 0x7b, 0x74, 0x6b,
    0x7b, 0x74, 0x71, 0x7b, 0x74, 0x76, 0x7b, 0x74, 0x77, 0x7b, 0x74, 0x78,
    0x7b, 0x74, 0x79, 0x7b, 0x74, 0x7a, 0x7b, 0x74, 0x26, 0x7b, 0x74, 0x2a,
    0x7b, 0x74, 0x2c, 0x7b, 0x74, 0x3b, 0x7b, 0x74, 0x58, 0x7b, 0x74, 0x5a};
const uint8_t HuffDecoderCommon::table29_20_emit_[204] = {
    0x7b, 0x20, 0x30, 0x7b, 0x20, 0x31, 0x7b, 0x20, 0x32, 0x7b, 0x20, 0x61,
    0x7b, 0x20, 0x63, 0x7b, 0x20, 0x65, 0x7b, 0x20, 0x69, 0x7b, 0x20, 0x6f,
    0x7b, 0x20, 0x73, 0x7b, 0x20, 0x74, 0x7b, 0x20, 0x20, 0x7b, 0x20, 0x25,
    0x7b, 0x20, 0x2d, 0x7b, 0x20, 0x2e, 0x7b, 0x20, 0x2f, 0x7b, 0x20, 0x33,
    0x7b, 0x20, 0x34, 0x7b, 0x20, 0x35, 0x7b, 0x20, 0x36, 0x7b, 0x20, 0x37,
    0x7b, 0x20, 0x38, 0x7b, 0x20, 0x39, 0x7b, 0x20, 0x3d, 0x7b, 0x20, 0x41,
    0x7b, 0x20, 0x5f, 0x7b, 0x20, 0x62, 0x7b, 0x20, 0x64, 0x7b, 0x20, 0x66,
    0x7b, 0x20, 0x67, 0x7b, 0x20, 0x68, 0x7b, 0x20, 0x6c, 0x7b, 0x20, 0x6d,
    0x7b, 0x20, 0x6e, 0x7b, 0x20, 0x70, 0x7b, 0x20, 0x72, 0x7b, 0x20, 0x75,
    0x7b, 0x20, 0x3a, 0x7b, 0x20, 0x42, 0x7b, 0x20, 0x43, 0x7b, 0x20, 0x44,
    0x7b, 0x20, 0x45, 0x7b, 0x20, 0x46, 0x7b, 0x20, 0x47, 0x7b, 0x20, 0x48,
    0x7b, 0x20, 0x49, 0x7b, 0x20, 0x4a, 0x7b, 0x20, 0x4b, 0x7b, 0x20, 0x4c,
    0x7b, 0x20, 0x4d, 0x7b, 0x20, 0x4e, 0x7b, 0x20, 0x4f, 0x7b, 0x20, 0x50,
    0x7b, 0x20, 0x51, 0x7b, 0x20, 0x52, 0x7b, 0x20, 0x53, 0x7b, 0x20, 0x54,
    0x7b, 0x20, 0x55, 0x7b, 0x20, 0x56, 0x7b, 0x20, 0x57, 0x7b, 0x20, 0x59,
    0x7b, 0x20, 0x6a, 0x7b, 0x20, 0x6b, 0x7b, 0x20, 0x71, 0x7b, 0x20, 0x76,
    0x7b, 0x20, 0x77, 0x7b, 0x20, 0x78, 0x7b, 0x20, 0x79, 0x7b, 0x20, 0x7a};
const uint16_t HuffDecoderCommon::table29_20_inner_[70] = {
    0x0000, 0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9,
    0x00c1, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169, 0x0181,
    0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259,
    0x0271, 0x0289, 0x02a1, 0x02b9, 0x02d1, 0x02e9, 0x0301, 0x0319, 0x0331,
    0x0349, 0x0361, 0x0379, 0x0391, 0x03a9, 0x03c1, 0x03d9, 0x03f1, 0x0409,
    0x0421, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9, 0x04e1,
    0x04f9, 0x0511, 0x0529, 0x0541, 0x0559, 0x0571, 0x0589, 0x05a1, 0x05b9,
    0x05d1, 0x05e9, 0x0601, 0x0619, 0x0631, 0x0649, 0x0002};
const uint8_t HuffDecoderCommon::table29_20_outer_[128] = {
    0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,
    5,  0,  0,  0,  6,  0,  0,  0,  7,  0,  0,  0,  8,  0,  0,  0,  9,  0,  0,
    0,  10, 0,  11, 0,  12, 0,  13, 0,  14, 0,  15, 0,  16, 0,  17, 0,  18, 0,
    19, 0,  20, 0,  21, 0,  22, 0,  23, 0,  24, 0,  25, 0,  26, 0,  27, 0,  28,
    0,  29, 0,  30, 0,  31, 0,  32, 0,  33, 0,  34, 0,  35, 0,  36, 37, 38, 39,
    40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
    59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 0,  0,  0,  69};
const uint8_t HuffDecoderCommon::table29_21_emit_[204] = {
    0x7b, 0x25, 0x30, 0x7b, 0x25, 0x31, 0x7b, 0x25, 0x32, 0x7b, 0x25, 0x61,
    0x7b, 0x25, 0x63, 0x7b, 0x25, 0x65, 0x7b, 0x25, 0x69, 0x7b, 0x25, 0x6f,
    0x7b, 0x25, 0x73, 0x7b, 0x25, 0x74, 0x7b, 0x25, 0x20, 0x7b, 0x25, 0x25,
    0x7b, 0x25, 0x2d, 0x7b, 0x25, 0x2e, 0x7b, 0x25, 0x2f, 0x7b, 0x25, 0x33,
    0x7b, 0x25, 0x34, 0x7b, 0x25, 0x35, 0x7b, 0x25, 0x36, 0x7b, 0x25, 0x37,
    0x7b, 0x25, 0x38, 0x7b, 0x25, 0x39, 0x7b, 0x25, 0x3d, 0x7b, 0x25, 0x41,
    0x7b, 0x25, 0x5f, 0x7b, 0x25, 0x62, 0x7b, 0x25, 0x64, 0x7b, 0x25, 0x66,
    0x7b, 0x25, 0x67, 0x7b, 0x25, 0x68, 0x7b, 0x25, 0x6c, 0x7b, 0x25, 0x6d,
    0x7b, 0x25, 0x6e, 0x7b, 0x25, 0x70, 0x7b, 0x25, 0x72, 0x7b, 0x25, 0x75,
    0x7b, 0x25, 0x3a, 0x7b, 0x25, 0x42, 0x7b, 0x25, 0x43, 0x7b, 0x25, 0x44,
    0x7b, 0x25, 0x45, 0x7b, 0x25, 0x46, 0x7b, 0x25, 0x47, 0x7b, 0x25, 0x48,
    0x7b, 0x25, 0x49, 0x7b, 0x25, 0x4a, 0x7b, 0x25, 0x4b, 0x7b, 0x25, 0x4c,
    0x7b, 0x25, 0x4d, 0x7b, 0x25, 0x4e, 0x7b, 0x25, 0x4f, 0x7b, 0x25, 0x50,
    0x7b, 0x25, 0x51, 0x7b, 0x25, 0x52, 0x7b, 0x25, 0x53, 0x7b, 0x25, 0x54,
    0x7b, 0x25, 0x55, 0x7b, 0x25, 0x56, 0x7b, 0x25, 0x57, 0x7b, 0x25, 0x59,
    0x7b, 0x25, 0x6a, 0x7b, 0x25, 0x6b, 0x7b, 0x25, 0x71, 0x7b, 0x25, 0x76,
    0x7b, 0x25, 0x77, 0x7b, 0x25, 0x78, 0x7b, 0x25, 0x79, 0x7b, 0x25, 0x7a};
const uint8_t HuffDecoderCommon::table29_22_emit_[204] = {
    0x7b, 0x2d, 0x30, 0x7b, 0x2d, 0x31, 0x7b, 0x2d, 0x32, 0x7b, 0x2d, 0x61,
    0x7b, 0x2d, 0x63, 0x7b, 0x2d, 0x65, 0x7b, 0x2d, 0x69, 0x7b, 0x2d, 0x6f,
    0x7b, 0x2d, 0x73, 0x7b, 0x2d, 0x74, 0x7b, 0x2d, 0x20, 0x7b, 0x2d, 0x25,
    0x7b, 0x2d, 0x2d, 0x7b, 0x2d, 0x2e, 0x7b, 0x2d, 0x2f, 0x7b, 0x2d, 0x33,
    0x7b, 0x2d, 0x34, 0x7b, 0x2d, 0x35, 0x7b, 0x2d, 0x36, 0x7b, 0x2d, 0x37,
    0x7b, 0x2d, 0x38, 0x7b, 0x2d, 0x39, 0x7b, 0x2d, 0x3d, 0x7b, 0x2d, 0x41,
    0x7b, 0x2d, 0x5f, 0x7b, 0x2d, 0x62, 0x7b, 0x2d, 0x64, 0x7b, 0x2d, 0x66,
    0x7b, 0x2d, 0x67, 0x7b, 0x2d, 0x68, 0x7b, 0x2d, 0x6c, 0x7b, 0x2d, 0x6d,
    0x7b, 0x2d, 0x6e, 0x7b, 0x2d, 0x70, 0x7b, 0x2d, 0x72, 0x7b, 0x2d, 0x75,
    0x7b, 0x2d, 0x3a, 0x7b, 0x2d, 0x42, 0x7b, 0x2d, 0x43, 0x7b, 0x2d, 0x44,
    0x7b, 0x2d, 0x45, 0x7b, 0x2d, 0x46, 0x7b, 0x2d, 0x47, 0x7b, 0x2d, 0x48,
    0x7b, 0x2d, 0x49, 0x7b, 0x2d, 0x4a, 0x7b, 0x2d, 0x4b, 0x7b, 0x2d, 0x4c,
    0x7b, 0x2d, 0x4d, 0x7b, 0x2d, 0x4e, 0x7b, 0x2d, 0x4f, 0x7b, 0x2d, 0x50,
    0x7b, 0x2d, 0x51, 0x7b, 0x2d, 0x52, 0x7b, 0x2d, 0x53, 0x7b, 0x2d, 0x54,
    0x7b, 0x2d, 0x55, 0x7b, 0x2d, 0x56, 0x7b, 0x2d, 0x57, 0x7b, 0x2d, 0x59,
    0x7b, 0x2d, 0x6a, 0x7b, 0x2d, 0x6b, 0x7b, 0x2d, 0x71, 0x7b, 0x2d, 0x76,
    0x7b, 0x2d, 0x77, 0x7b, 0x2d, 0x78, 0x7b, 0x2d, 0x79, 0x7b, 0x2d, 0x7a};
const uint8_t HuffDecoderCommon::table29_23_emit_[204] = {
    0x7b, 0x2e, 0x30, 0x7b, 0x2e, 0x31, 0x7b, 0x2e, 0x32, 0x7b, 0x2e, 0x61,
    0x7b, 0x2e, 0x63, 0x7b, 0x2e, 0x65, 0x7b, 0x2e, 0x69, 0x7b, 0x2e, 0x6f,
    0x7b, 0x2e, 0x73, 0x7b, 0x2e, 0x74, 0x7b, 0x2e, 0x20, 0x7b, 0x2e, 0x25,
    0x7b, 0x2e, 0x2d, 0x7b, 0x2e, 0x2e, 0x7b, 0x2e, 0x2f, 0x7b, 0x2e, 0x33,
    0x7b, 0x2e, 0x34, 0x7b, 0x2e, 0x35, 0x7b, 0x2e, 0x36, 0x7b, 0x2e, 0x37,
    0x7b, 0x2e, 0x38, 0x7b, 0x2e, 0x39, 0x7b, 0x2e, 0x3d, 0x7b, 0x2e, 0x41,
    0x7b, 0x2e, 0x5f, 0x7b, 0x2e, 0x62, 0x7b, 0x2e, 0x64, 0x7b, 0x2e, 0x66,
    0x7b, 0x2e, 0x67, 0x7b, 0x2e, 0x68, 0x7b, 0x2e, 0x6c, 0x7b, 0x2e, 0x6d,
    0x7b, 0x2e, 0x6e, 0x7b, 0x2e, 0x70, 0x7b, 0x2e, 0x72, 0x7b, 0x2e, 0x75,
    0x7b, 0x2e, 0x3a, 0x7b, 0x2e, 0x42, 0x7b, 0x2e, 0x43, 0x7b, 0x2e, 0x44,
    0x7b, 0x2e, 0x45, 0x7b, 0x2e, 0x46, 0x7b, 0x2e, 0x47, 0x7b, 0x2e, 0x48,
    0x7b, 0x2e, 0x49, 0x7b, 0x2e, 0x4a, 0x7b, 0x2e, 0x4b, 0x7b, 0x2e, 0x4c,
    0x7b, 0x2e, 0x4d, 0x7b, 0x2e, 0x4e, 0x7b, 0x2e, 0x4f, 0x7b, 0x2e, 0x50,
    0x7b, 0x2e, 0x51, 0x7b, 0x2e, 0x52, 0x7b, 0x2e, 0x53, 0x7b, 0x2e, 0x54,
    0x7b, 0x2e, 0x55, 0x7b, 0x2e, 0x56, 0x7b, 0x2e, 0x57, 0x7b, 0x2e, 0x59,
    0x7b, 0x2e, 0x6a, 0x7b, 0x2e, 0x6b, 0x7b, 0x2e, 0x71, 0x7b, 0x2e, 0x76,
    0x7b, 0x2e, 0x77, 0x7b, 0x2e, 0x78, 0x7b, 0x2e, 0x79, 0x7b, 0x2e, 0x7a};
const uint8_t HuffDecoderCommon::table29_24_emit_[204] = {
    0x7b, 0x2f, 0x30, 0x7b, 0x2f, 0x31, 0x7b, 0x2f, 0x32, 0x7b, 0x2f, 0x61,
    0x7b, 0x2f, 0x63, 0x7b, 0x2f, 0x65, 0x7b, 0x2f, 0x69, 0x7b, 0x2f, 0x6f,
    0x7b, 0x2f, 0x73, 0x7b, 0x2f, 0x74, 0x7b, 0x2f, 0x20, 0x7b, 0x2f, 0x25,
    0x7b, 0x2f, 0x2d, 0x7b, 0x2f, 0x2e, 0x7b, 0x2f, 0x2f, 0x7b, 0x2f, 0x33,
    0x7b, 0x2f, 0x34, 0x7b, 0x2f, 0x35, 0x7b, 0x2f, 0x36, 0x7b, 0x2f, 0x37,
    0x7b, 0x2f, 0x38, 0x7b, 0x2f, 0x39, 0x7b, 0x2f, 0x3d, 0x7b, 0x2f, 0x41,
    0x7b, 0x2f, 0x5f, 0x7b, 0x2f, 0x62, 0x7b, 0x2f, 0x64, 0x7b, 0x2f, 0x66,
    0x7b, 0x2f, 0x67, 0x7b, 0x2f, 0x68, 0x7b, 0x2f, 0x6c, 0x7b, 0x2f, 0x6d,
    0x7b, 0x2f, 0x6e, 0x7b, 0x2f, 0x70, 0x7b, 0x2f, 0x72, 0x7b, 0x2f, 0x75,
    0x7b, 0x2f, 0x3a, 0x7b, 0x2f, 0x42, 0x7b, 0x2f, 0x43, 0x7b, 0x2f, 0x44,
    0x7b, 0x2f, 0x45, 0x7b, 0x2f, 0x46, 0x7b, 0x2f, 0x47, 0x7b, 0x2f, 0x48,
    0x7b, 0x2f, 0x49, 0x7b, 0x2f, 0x4a, 0x7b, 0x2f, 0x4b, 0x7b, 0x2f, 0x4c,
    0x7b, 0x2f, 0x4d, 0x7b, 0x2f, 0x4e, 0x7b, 0x2f, 0x4f, 0x7b, 0x2f, 0x50,
    0x7b, 0x2f, 0x51, 0x7b, 0x2f, 0x52, 0x7b, 0x2f, 0x53, 0x7b, 0x2f, 0x54,
    0x7b, 0x2f, 0x55, 0x7b, 0x2f, 0x56, 0x7b, 0x2f, 0x57, 0x7b, 0x2f, 0x59,
    0x7b, 0x2f, 0x6a, 0x7b, 0x2f, 0x6b, 0x7b, 0x2f, 0x71, 0x7b, 0x2f, 0x76,
    0x7b, 0x2f, 0x77, 0x7b, 0x2f, 0x78, 0x7b, 0x2f, 0x79, 0x7b, 0x2f, 0x7a};
const uint8_t HuffDecoderCommon::table29_25_emit_[204] = {
    0x7b, 0x33, 0x30, 0x7b, 0x33, 0x31, 0x7b, 0x33, 0x32, 0x7b, 0x33, 0x61,
    0x7b, 0x33, 0x63, 0x7b, 0x33, 0x65, 0x7b, 0x33, 0x69, 0x7b, 0x33, 0x6f,
    0x7b, 0x33, 0x73, 0x7b, 0x33, 0x74, 0x7b, 0x33, 0x20, 0x7b, 0x33, 0x25,
    0x7b, 0x33, 0x2d, 0x7b, 0x33, 0x2e, 0x7b, 0x33, 0x2f, 0x7b, 0x33, 0x33,
    0x7b, 0x33, 0x34, 0x7b, 0x33, 0x35, 0x7b, 0x33, 0x36, 0x7b, 0x33, 0x37,
    0x7b, 0x33, 0x38, 0x7b, 0x33, 0x39, 0x7b, 0x33, 0x3d, 0x7b, 0x33, 0x41,
    0x7b, 0x33, 0x5f, 0x7b, 0x33, 0x62, 0x7b, 0x33, 0x64, 0x7b, 0x33, 0x66,
    0x7b, 0x33, 0x67, 0x7b, 0x33, 0x68, 0x7b, 0x33, 0x6c, 0x7b, 0x33, 0x6d,
    0x7b, 0x33, 0x6e, 0x7b, 0x33, 0x70, 0x7b, 0x33, 0x72, 0x7b, 0x33, 0x75,
    0x7b, 0x33, 0x3a, 0x7b, 0x33, 0x42, 0x7b, 0x33, 0x43, 0x7b, 0x33, 0x44,
    0x7b, 0x33, 0x45, 0x7b, 0x33, 0x46, 0x7b, 0x33, 0x47, 0x7b, 0x33, 0x48,
    0x7b, 0x33, 0x49, 0x7b, 0x33, 0x4a, 0x7b, 0x33, 0x4b, 0x7b, 0x33, 0x4c,
    0x7b, 0x33, 0x4d, 0x7b, 0x33, 0x4e, 0x7b, 0x33, 0x4f, 0x7b, 0x33, 0x50,
    0x7b, 0x33, 0x51, 0x7b, 0x33, 0x52, 0x7b, 0x33, 0x53, 0x7b, 0x33, 0x54,
    0x7b, 0x33, 0x55, 0x7b, 0x33, 0x56, 0x7b, 0x33, 0x57, 0x7b, 0x33, 0x59,
    0x7b, 0x33, 0x6a, 0x7b, 0x33, 0x6b, 0x7b, 0x33, 0x71, 0x7b, 0x33, 0x76,
    0x7b, 0x33, 0x77, 0x7b, 0x33, 0x78, 0x7b, 0x33, 0x79, 0x7b, 0x33, 0x7a};
const uint8_t HuffDecoderCommon::table29_26_emit_[204] = {
    0x7b, 0x34, 0x30, 0x7b, 0x34, 0x31, 0x7b, 0x34, 0x32, 0x7b, 0x34, 0x61,
    0x7b, 0x34, 0x63, 0x7b, 0x34, 0x65, 0x7b, 0x34, 0x69, 0x7b, 0x34, 0x6f,
    0x7b, 0x34, 0x73, 0x7b, 0x34, 0x74, 0x7b, 0x34, 0x20, 0x7b, 0x34, 0x25,
    0x7b, 0x34, 0x2d, 0x7b, 0x34, 0x2e, 0x7b, 0x34, 0x2f, 0x7b, 0x34, 0x33,
    0x7b, 0x34, 0x34, 0x7b, 0x34, 0x35, 0x7b, 0x34, 0x36, 0x7b, 0x34, 0x37,
    0x7b, 0x34, 0x38, 0x7b, 0x34, 0x39, 0x7b, 0x34, 0x3d, 0x7b, 0x34, 0x41,
    0x7b, 0x34, 0x5f, 0x7b, 0x34, 0x62, 0x7b, 0x34, 0x64, 0x7b, 0x34, 0x66,
    0x7b, 0x34, 0x67, 0x7b, 0x34, 0x68, 0x7b, 0x34, 0x6c, 0x7b, 0x34, 0x6d,
    0x7b, 0x34, 0x6e, 0x7b, 0x34, 0x70, 0x7b, 0x34, 0x72, 0x7b, 0x34, 0x75,
    0x7b, 0x34, 0x3a, 0x7b, 0x34, 0x42, 0x7b, 0x34, 0x43, 0x7b, 0x34, 0x44,
    0x7b, 0x34, 0x45, 0x7b, 0x34, 0x46, 0x7b, 0x34, 0x47, 0x7b, 0x34, 0x48,
    0x7b, 0x34, 0x49, 0x7b, 0x34, 0x4a, 0x7b, 0x34, 0x4b, 0x7b, 0x34, 0x4c,
    0x7b, 0x34, 0x4d, 0x7b, 0x34, 0x4e, 0x7b, 0x34, 0x4f, 0x7b, 0x34, 0x50,
    0x7b, 0x34, 0x51, 0x7b, 0x34, 0x52, 0x7b, 0x34, 0x53, 0x7b, 0x34, 0x54,
    0x7b, 0x34, 0x55, 0x7b, 0x34, 0x56, 0x7b, 0x34, 0x57, 0x7b, 0x34, 0x59,
    0x7b, 0x34, 0x6a, 0x7b, 0x34, 0x6b, 0x7b, 0x34, 0x71, 0x7b, 0x34, 0x76,
    0x7b, 0x34, 0x77, 0x7b, 0x34, 0x78, 0x7b, 0x34, 0x79, 0x7b, 0x34, 0x7a};
const uint8_t HuffDecoderCommon::table29_27_emit_[204] = {
    0x7b, 0x35, 0x30, 0x7b, 0x35, 0x31, 0x7b, 0x35, 0x32, 0x7b, 0x35, 0x61,
    0x7b, 0x35, 0x63, 0x7b, 0x35, 0x65, 0x7b, 0x35, 0x69, 0x7b, 0x35, 0x6f,
    0x7b, 0x35, 0x73, 0x7b, 0x35, 0x74, 0x7b, 0x35, 0x20, 0x7b, 0x35, 0x25,
    0x7b, 0x35, 0x2d, 0x7b, 0x35, 0x2e, 0x7b, 0x35, 0x2f, 0x7b, 0x35, 0x33,
    0x7b, 0x35, 0x34, 0x7b, 0x35, 0x35, 0x7b, 0x35, 0x36, 0x7b, 0x35, 0x37,
    0x7b, 0x35, 0x38, 0x7b, 0x35, 0x39, 0x7b, 0x35, 0x3d, 0x7b, 0x35, 0x41,
    0x7b, 0x35, 0x5f, 0x7b, 0x35, 0x62, 0x7b, 0x35, 0x64, 0x7b, 0x35, 0x66,
    0x7b, 0x35, 0x67, 0x7b, 0x35, 0x68, 0x7b, 0x35, 0x6c, 0x7b, 0x35, 0x6d,
    0x7b, 0x35, 0x6e, 0x7b, 0x35, 0x70, 0x7b, 0x35, 0x72, 0x7b, 0x35, 0x75,
    0x7b, 0x35, 0x3a, 0x7b, 0x35, 0x42, 0x7b, 0x35, 0x43, 0x7b, 0x35, 0x44,
    0x7b, 0x35, 0x45, 0x7b, 0x35, 0x46, 0x7b, 0x35, 0x47, 0x7b, 0x35, 0x48,
    0x7b, 0x35, 0x49, 0x7b, 0x35, 0x4a, 0x7b, 0x35, 0x4b, 0x7b, 0x35, 0x4c,
    0x7b, 0x35, 0x4d, 0x7b, 0x35, 0x4e, 0x7b, 0x35, 0x4f, 0x7b, 0x35, 0x50,
    0x7b, 0x35, 0x51, 0x7b, 0x35, 0x52, 0x7b, 0x35, 0x53, 0x7b, 0x35, 0x54,
    0x7b, 0x35, 0x55, 0x7b, 0x35, 0x56, 0x7b, 0x35, 0x57, 0x7b, 0x35, 0x59,
    0x7b, 0x35, 0x6a, 0x7b, 0x35, 0x6b, 0x7b, 0x35, 0x71, 0x7b, 0x35, 0x76,
    0x7b, 0x35, 0x77, 0x7b, 0x35, 0x78, 0x7b, 0x35, 0x79, 0x7b, 0x35, 0x7a};
const uint8_t HuffDecoderCommon::table29_28_emit_[204] = {
    0x7b, 0x36, 0x30, 0x7b, 0x36, 0x31, 0x7b, 0x36, 0x32, 0x7b, 0x36, 0x61,
    0x7b, 0x36, 0x63, 0x7b, 0x36, 0x65, 0x7b, 0x36, 0x69, 0x7b, 0x36, 0x6f,
    0x7b, 0x36, 0x73, 0x7b, 0x36, 0x74, 0x7b, 0x36, 0x20, 0x7b, 0x36, 0x25,
    0x7b, 0x36, 0x2d, 0x7b, 0x36, 0x2e, 0x7b, 0x36, 0x2f, 0x7b, 0x36, 0x33,
    0x7b, 0x36, 0x34, 0x7b, 0x36, 0x35, 0x7b, 0x36, 0x36, 0x7b, 0x36, 0x37,
    0x7b, 0x36, 0x38, 0x7b, 0x36, 0x39, 0x7b, 0x36, 0x3d, 0x7b, 0x36, 0x41,
    0x7b, 0x36, 0x5f, 0x7b, 0x36, 0x62, 0x7b, 0x36, 0x64, 0x7b, 0x36, 0x66,
    0x7b, 0x36, 0x67, 0x7b, 0x36, 0x68, 0x7b, 0x36, 0x6c, 0x7b, 0x36, 0x6d,
    0x7b, 0x36, 0x6e, 0x7b, 0x36, 0x70, 0x7b, 0x36, 0x72, 0x7b, 0x36, 0x75,
    0x7b, 0x36, 0x3a, 0x7b, 0x36, 0x42, 0x7b, 0x36, 0x43, 0x7b, 0x36, 0x44,
    0x7b, 0x36, 0x45, 0x7b, 0x36, 0x46, 0x7b, 0x36, 0x47, 0x7b, 0x36, 0x48,
    0x7b, 0x36, 0x49, 0x7b, 0x36, 0x4a, 0x7b, 0x36, 0x4b, 0x7b, 0x36, 0x4c,
    0x7b, 0x36, 0x4d, 0x7b, 0x36, 0x4e, 0x7b, 0x36, 0x4f, 0x7b, 0x36, 0x50,
    0x7b, 0x36, 0x51, 0x7b, 0x36, 0x52, 0x7b, 0x36, 0x53, 0x7b, 0x36, 0x54,
    0x7b, 0x36, 0x55, 0x7b, 0x36, 0x56, 0x7b, 0x36, 0x57, 0x7b, 0x36, 0x59,
    0x7b, 0x36, 0x6a, 0x7b, 0x36, 0x6b, 0x7b, 0x36, 0x71, 0x7b, 0x36, 0x76,
    0x7b, 0x36, 0x77, 0x7b, 0x36, 0x78, 0x7b, 0x36, 0x79, 0x7b, 0x36, 0x7a};
const uint8_t HuffDecoderCommon::table29_29_emit_[204] = {
    0x7b, 0x37, 0x30, 0x7b, 0x37, 0x31, 0x7b, 0x37, 0x32, 0x7b, 0x37, 0x61,
    0x7b, 0x37, 0x63, 0x7b, 0x37, 0x65, 0x7b, 0x37, 0x69, 0x7b, 0x37, 0x6f,
    0x7b, 0x37, 0x73, 0x7b, 0x37, 0x74, 0x7b, 0x37, 0x20, 0x7b, 0x37, 0x25,
    0x7b, 0x37, 0x2d, 0x7b, 0x37, 0x2e, 0x7b, 0x37, 0x2f, 0x7b, 0x37, 0x33,
    0x7b, 0x37, 0x34, 0x7b, 0x37, 0x35, 0x7b, 0x37, 0x36, 0x7b, 0x37, 0x37,
    0x7b, 0x37, 0x38, 0x7b, 0x37, 0x39, 0x7b, 0x37, 0x3d, 0x7b, 0x37, 0x41,
    0x7b, 0x37, 0x5f, 0x7b, 0x37, 0x62, 0x7b, 0x37, 0x64, 0x7b, 0x37, 0x66,
    0x7b, 0x37, 0x67, 0x7b, 0x37, 0x68, 0x7b, 0x37, 0x6c, 0x7b, 0x37, 0x6d,
    0x7b, 0x37, 0x6e, 0x7b, 0x37, 0x70, 0x7b, 0x37, 0x72, 0x7b, 0x37, 0x75,
    0x7b, 0x37, 0x3a, 0x7b, 0x37, 0x42, 0x7b, 0x37, 0x43, 0x7b, 0x37, 0x44,
    0x7b, 0x37, 0x45, 0x7b, 0x37, 0x46, 0x7b, 0x37, 0x47, 0x7b, 0x37, 0x48,
    0x7b, 0x37, 0x49, 0x7b, 0x37, 0x4a, 0x7b, 0x37, 0x4b, 0x7b, 0x37, 0x4c,
    0x7b, 0x37, 0x4d, 0x7b, 0x37, 0x4e, 0x7b, 0x37, 0x4f, 0x7b, 0x37, 0x50,
    0x7b, 0x37, 0x51, 0x7b, 0x37, 0x52, 0x7b, 0x37, 0x53, 0x7b, 0x37, 0x54,
    0x7b, 0x37, 0x55, 0x7b, 0x37, 0x56, 0x7b, 0x37, 0x57, 0x7b, 0x37, 0x59,
    0x7b, 0x37, 0x6a, 0x7b, 0x37, 0x6b, 0x7b, 0x37, 0x71, 0x7b, 0x37, 0x76,
    0x7b, 0x37, 0x77, 0x7b, 0x37, 0x78, 0x7b, 0x37, 0x79, 0x7b, 0x37, 0x7a};
const uint8_t HuffDecoderCommon::table29_30_emit_[204] = {
    0x7b, 0x38, 0x30, 0x7b, 0x38, 0x31, 0x7b, 0x38, 0x32, 0x7b, 0x38, 0x61,
    0x7b, 0x38, 0x63, 0x7b, 0x38, 0x65, 0x7b, 0x38, 0x69, 0x7b, 0x38, 0x6f,
    0x7b, 0x38, 0x73, 0x7b, 0x38, 0x74, 0x7b, 0x38, 0x20, 0x7b, 0x38, 0x25,
    0x7b, 0x38, 0x2d, 0x7b, 0x38, 0x2e, 0x7b, 0x38, 0x2f, 0x7b, 0x38, 0x33,
    0x7b, 0x38, 0x34, 0x7b, 0x38, 0x35, 0x7b, 0x38, 0x36, 0x7b, 0x38, 0x37,
    0x7b, 0x38, 0x38, 0x7b, 0x38, 0x39, 0x7b, 0x38, 0x3d, 0x7b, 0x38, 0x41,
    0x7b, 0x38, 0x5f, 0x7b, 0x38, 0x62, 0x7b, 0x38, 0x64, 0x7b, 0x38, 0x66,
    0x7b, 0x38, 0x67, 0x7b, 0x38, 0x68, 0x7b, 0x38, 0x6c, 0x7b, 0x38, 0x6d,
    0x7b, 0x38, 0x6e, 0x7b, 0x38, 0x70, 0x7b, 0x38, 0x72, 0x7b, 0x38, 0x75,
    0x7b, 0x38, 0x3a, 0x7b, 0x38, 0x42, 0x7b, 0x38, 0x43, 0x7b, 0x38, 0x44,
    0x7b, 0x38, 0x45, 0x7b, 0x38, 0x46, 0x7b, 0x38, 0x47, 0x7b, 0x38, 0x48,
    0x7b, 0x38, 0x49, 0x7b, 0x38, 0x4a, 0x7b, 0x38, 0x4b, 0x7b, 0x38, 0x4c,
    0x7b, 0x38, 0x4d, 0x7b, 0x38, 0x4e, 0x7b, 0x38, 0x4f, 0x7b, 0x38, 0x50,
    0x7b, 0x38, 0x51, 0x7b, 0x38, 0x52, 0x7b, 0x38, 0x53, 0x7b, 0x38, 0x54,
    0x7b, 0x38, 0x55, 0x7b, 0x38, 0x56, 0x7b, 0x38, 0x57, 0x7b, 0x38, 0x59,
    0x7b, 0x38, 0x6a, 0x7b, 0x38, 0x6b, 0x7b, 0x38, 0x71, 0x7b, 0x38, 0x76,
    0x7b, 0x38, 0x77, 0x7b, 0x38, 0x78, 0x7b, 0x38, 0x79, 0x7b, 0x38, 0x7a};
const uint8_t HuffDecoderCommon::table29_31_emit_[204] = {
    0x7b, 0x39, 0x30, 0x7b, 0x39, 0x31, 0x7b, 0x39, 0x32, 0x7b, 0x39, 0x61,
    0x7b, 0x39, 0x63, 0x7b, 0x39, 0x65, 0x7b, 0x39, 0x69, 0x7b, 0x39, 0x6f,
    0x7b, 0x39, 0x73, 0x7b, 0x39, 0x74, 0x7b, 0x39, 0x20, 0x7b, 0x39, 0x25,
    0x7b, 0x39, 0x2d, 0x7b, 0x39, 0x2e, 0x7b, 0x39, 0x2f, 0x7b, 0x39, 0x33,
    0x7b, 0x39, 0x34, 0x7b, 0x39, 0x35, 0x7b, 0x39, 0x36, 0x7b, 0x39, 0x37,
    0x7b, 0x39, 0x38, 0x7b, 0x39, 0x39, 0x7b, 0x39, 0x3d, 0x7b, 0x39, 0x41,
    0x7b, 0x39, 0x5f, 0x7b, 0x39, 0x62, 0x7b, 0x39, 0x64, 0x7b, 0x39, 0x66,
    0x7b, 0x39, 0x67, 0x7b, 0x39, 0x68, 0x7b, 0x39, 0x6c, 0x7b, 0x39, 0x6d,
    0x7b, 0x39, 0x6e, 0x7b, 0x39, 0x70, 0x7b, 0x39, 0x72, 0x7b, 0x39, 0x75,
    0x7b, 0x39, 0x3a, 0x7b, 0x39, 0x42, 0x7b, 0x39, 0x43, 0x7b, 0x39, 0x44,
    0x7b, 0x39, 0x45, 0x7b, 0x39, 0x46, 0x7b, 0x39, 0x47, 0x7b, 0x39, 0x48,
    0x7b, 0x39, 0x49, 0x7b, 0x39, 0x4a, 0x7b, 0x39, 0x4b, 0x7b, 0x39, 0x4c,
    0x7b, 0x39, 0x4d, 0x7b, 0x39, 0x4e, 0x7b, 0x39, 0x4f, 0x7b, 0x39, 0x50,
    0x7b, 0x39, 0x51, 0x7b, 0x39, 0x52, 0x7b, 0x39, 0x53, 0x7b, 0x39, 0x54,
    0x7b, 0x39, 0x55, 0x7b, 0x39, 0x56, 0x7b, 0x39, 0x57, 0x7b, 0x39, 0x59,
    0x7b, 0x39, 0x6a, 0x7b, 0x39, 0x6b, 0x7b, 0x39, 0x71, 0x7b, 0x39, 0x76,
    0x7b, 0x39, 0x77, 0x7b, 0x39, 0x78, 0x7b, 0x39, 0x79, 0x7b, 0x39, 0x7a};
const uint8_t HuffDecoderCommon::table29_32_emit_[204] = {
    0x7b, 0x3d, 0x30, 0x7b, 0x3d, 0x31, 0x7b, 0x3d, 0x32, 0x7b, 0x3d, 0x61,
    0x7b, 0x3d, 0x63, 0x7b, 0x3d, 0x65, 0x7b, 0x3d, 0x69, 0x7b, 0x3d, 0x6f,
    0x7b, 0x3d, 0x73, 0x7b, 0x3d, 0x74, 0x7b, 0x3d, 0x20, 0x7b, 0x3d, 0x25,
    0x7b, 0x3d, 0x2d, 0x7b, 0x3d, 0x2e, 0x7b, 0x3d, 0x2f, 0x7b, 0x3d, 0x33,
    0x7b, 0x3d, 0x34, 0x7b, 0x3d, 0x35, 0x7b, 0x3d, 0x36, 0x7b, 0x3d, 0x37,
    0x7b, 0x3d, 0x38, 0x7b, 0x3d, 0x39, 0x7b, 0x3d, 0x3d, 0x7b, 0x3d, 0x41,
    0x7b, 0x3d, 0x5f, 0x7b, 0x3d, 0x62, 0x7b, 0x3d, 0x64, 0x7b, 0x3d, 0x66,
    0x7b, 0x3d, 0x67, 0x7b, 0x3d, 0x68, 0x7b, 0x3d, 0x6c, 0x7b, 0x3d, 0x6d,
    0x7b, 0x3d, 0x6e, 0x7b, 0x3d, 0x70, 0x7b, 0x3d, 0x72, 0x7b, 0x3d, 0x75,
    0x7b, 0x3d, 0x3a, 0x7b, 0x3d, 0x42, 0x7b, 0x3d, 0x43, 0x7b, 0x3d, 0x44,
    0x7b, 0x3d, 0x45, 0x7b, 0x3d, 0x46, 0x7b, 0x3d, 0x47, 0x7b, 0x3d, 0x48,
    0x7b, 0x3d, 0x49, 0x7b, 0x3d, 0x4a, 0x7b, 0x3d, 0x4b, 0x7b, 0x3d, 0x4c,
    0x7b, 0x3d, 0x4d, 0x7b, 0x3d, 0x4e, 0x7b, 0x3d, 0x4f, 0x7b, 0x3d, 0x50,
    0x7b, 0x3d, 0x51, 0x7b, 0x3d, 0x52, 0x7b, 0x3d, 0x53, 0x7b, 0x3d, 0x54,
    0x7b, 0x3d, 0x55, 0x7b, 0x3d, 0x56, 0x7b, 0x3d, 0x57, 0x7b, 0x3d, 0x59,
    0x7b, 0x3d, 0x6a, 0x7b, 0x3d, 0x6b, 0x7b, 0x3d, 0x71, 0x7b, 0x3d, 0x76,
    0x7b, 0x3d, 0x77, 0x7b, 0x3d, 0x78, 0x7b, 0x3d, 0x79, 0x7b, 0x3d, 0x7a};
const uint8_t HuffDecoderCommon::table29_33_emit_[204] = {
    0x7b, 0x41, 0x30, 0x7b, 0x41, 0x31, 0x7b, 0x41, 0x32, 0x7b, 0x41, 0x61,
    0x7b, 0x41, 0x63, 0x7b, 0x41, 0x65, 0x7b, 0x41, 0x69, 0x7b, 0x41, 0x6f,
    0x7b, 0x41, 0x73, 0x7b, 0x41, 0x74, 0x7b, 0x41, 0x20, 0x7b, 0x41, 0x25,
    0x7b, 0x41, 0x2d, 0x7b, 0x41, 0x2e, 0x7b, 0x41, 0x2f, 0x7b, 0x41, 0x33,
    0x7b, 0x41, 0x34, 0x7b, 0x41, 0x35, 0x7b, 0x41, 0x36, 0x7b, 0x41, 0x37,
    0x7b, 0x41, 0x38, 0x7b, 0x41, 0x39, 0x7b, 0x41, 0x3d, 0x7b, 0x41, 0x41,
    0x7b, 0x41, 0x5f, 0x7b, 0x41, 0x62, 0x7b, 0x41, 0x64, 0x7b, 0x41, 0x66,
    0x7b, 0x41, 0x67, 0x7b, 0x41, 0x68, 0x7b, 0x41, 0x6c, 0x7b, 0x41, 0x6d,
    0x7b, 0x41, 0x6e, 0x7b, 0x41, 0x70, 0x7b, 0x41, 0x72, 0x7b, 0x41, 0x75,
    0x7b, 0x41, 0x3a, 0x7b, 0x41, 0x42, 0x7b, 0x41, 0x43, 0x7b, 0x41, 0x44,
    0x7b, 0x41, 0x45, 0x7b, 0x41, 0x46, 0x7b, 0x41, 0x47, 0x7b, 0x41, 0x48,
    0x7b, 0x41, 0x49, 0x7b, 0x41, 0x4a, 0x7b, 0x41, 0x4b, 0x7b, 0x41, 0x4c,
    0x7b, 0x41, 0x4d, 0x7b, 0x41, 0x4e, 0x7b, 0x41, 0x4f, 0x7b, 0x41, 0x50,
    0x7b, 0x41, 0x51, 0x7b, 0x41, 0x52, 0x7b, 0x41, 0x53, 0x7b, 0x41, 0x54,
    0x7b, 0x41, 0x55, 0x7b, 0x41, 0x56, 0x7b, 0x41, 0x57, 0x7b, 0x41, 0x59,
    0x7b, 0x41, 0x6a, 0x7b, 0x41, 0x6b, 0x7b, 0x41, 0x71, 0x7b, 0x41, 0x76,
    0x7b, 0x41, 0x77, 0x7b, 0x41, 0x78, 0x7b, 0x41, 0x79, 0x7b, 0x41, 0x7a};
const uint8_t HuffDecoderCommon::table29_34_emit_[204] = {
    0x7b, 0x5f, 0x30, 0x7b, 0x5f, 0x31, 0x7b, 0x5f, 0x32, 0x7b, 0x5f, 0x61,
    0x7b, 0x5f, 0x63, 0x7b, 0x5f, 0x65, 0x7b, 0x5f, 0x69, 0x7b, 0x5f, 0x6f,
    0x7b, 0x5f, 0x73, 0x7b, 0x5f, 0x74, 0x7b, 0x5f, 0x20, 0x7b, 0x5f, 0x25,
    0x7b, 0x5f, 0x2d, 0x7b, 0x5f, 0x2e, 0x7b, 0x5f, 0x2f, 0x7b, 0x5f, 0x33,
    0x7b, 0x5f, 0x34, 0x7b, 0x5f, 0x35, 0x7b, 0x5f, 0x36, 0x7b, 0x5f, 0x37,
    0x7b, 0x5f, 0x38, 0x7b, 0x5f, 0x39, 0x7b, 0x5f, 0x3d, 0x7b, 0x5f, 0x41,
    0x7b, 0x5f, 0x5f, 0x7b, 0x5f, 0x62, 0x7b, 0x5f, 0x64, 0x7b, 0x5f, 0x66,
    0x7b, 0x5f, 0x67, 0x7b, 0x5f, 0x68, 0x7b, 0x5f, 0x6c, 0x7b, 0x5f, 0x6d,
    0x7b, 0x5f, 0x6e, 0x7b, 0x5f, 0x70, 0x7b, 0x5f, 0x72, 0x7b, 0x5f, 0x75,
    0x7b, 0x5f, 0x3a, 0x7b, 0x5f, 0x42, 0x7b, 0x5f, 0x43, 0x7b, 0x5f, 0x44,
    0x7b, 0x5f, 0x45, 0x7b, 0x5f, 0x46, 0x7b, 0x5f, 0x47, 0x7b, 0x5f, 0x48,
    0x7b, 0x5f, 0x49, 0x7b, 0x5f, 0x4a, 0x7b, 0x5f, 0x4b, 0x7b, 0x5f, 0x4c,
    0x7b, 0x5f, 0x4d, 0x7b, 0x5f, 0x4e, 0x7b, 0x5f, 0x4f, 0x7b, 0x5f, 0x50,
    0x7b, 0x5f, 0x51, 0x7b, 0x5f, 0x52, 0x7b, 0x5f, 0x53, 0x7b, 0x5f, 0x54,
    0x7b, 0x5f, 0x55, 0x7b, 0x5f, 0x56, 0x7b, 0x5f, 0x57, 0x7b, 0x5f, 0x59,
    0x7b, 0x5f, 0x6a, 0x7b, 0x5f, 0x6b, 0x7b, 0x5f, 0x71, 0x7b, 0x5f, 0x76,
    0x7b, 0x5f, 0x77, 0x7b, 0x5f, 0x78, 0x7b, 0x5f, 0x79, 0x7b, 0x5f, 0x7a};
const uint8_t HuffDecoderCommon::table29_35_emit_[204] = {
    0x7b, 0x62, 0x30, 0x7b, 0x62, 0x31, 0x7b, 0x62, 0x32, 0x7b, 0x62, 0x61,
    0x7b, 0x62, 0x63, 0x7b, 0x62, 0x65, 0x7b, 0x62, 0x69, 0x7b, 0x62, 0x6f,
    0x7b, 0x62, 0x73, 0x7b, 0x62, 0x74, 0x7b, 0x62, 0x20, 0x7b, 0x62, 0x25,
    0x7b, 0x62, 0x2d, 0x7b, 0x62, 0x2e, 0x7b, 0x62, 0x2f, 0x7b, 0x62, 0x33,
    0x7b, 0x62, 0x34, 0x7b, 0x62, 0x35, 0x7b, 0x62, 0x36, 0x7b, 0x62, 0x37,
    0x7b, 0x62, 0x38, 0x7b, 0x62, 0x39, 0x7b, 0x62, 0x3d, 0x7b, 0x62, 0x41,
    0x7b, 0x62, 0x5f, 0x7b, 0x62, 0x62, 0x7b, 0x62, 0x64, 0x7b, 0x62, 0x66,
    0x7b, 0x62, 0x67, 0x7b, 0x62, 0x68, 0x7b, 0x62, 0x6c, 0x7b, 0x62, 0x6d,
    0x7b, 0x62, 0x6e, 0x7b, 0x62, 0x70, 0x7b, 0x62, 0x72, 0x7b, 0x62, 0x75,
    0x7b, 0x62, 0x3a, 0x7b, 0x62, 0x42, 0x7b, 0x62, 0x43, 0x7b, 0x62, 0x44,
    0x7b, 0x62, 0x45, 0x7b, 0x62, 0x46, 0x7b, 0x62, 0x47, 0x7b, 0x62, 0x48,
    0x7b, 0x62, 0x49, 0x7b, 0x62, 0x4a, 0x7b, 0x62, 0x4b, 0x7b, 0x62, 0x4c,
    0x7b, 0x62, 0x4d, 0x7b, 0x62, 0x4e, 0x7b, 0x62, 0x4f, 0x7b, 0x62, 0x50,
    0x7b, 0x62, 0x51, 0x7b, 0x62, 0x52, 0x7b, 0x62, 0x53, 0x7b, 0x62, 0x54,
    0x7b, 0x62, 0x55, 0x7b, 0x62, 0x56, 0x7b, 0x62, 0x57, 0x7b, 0x62, 0x59,
    0x7b, 0x62, 0x6a, 0x7b, 0x62, 0x6b, 0x7b, 0x62, 0x71, 0x7b, 0x62, 0x76,
    0x7b, 0x62, 0x77, 0x7b, 0x62, 0x78, 0x7b, 0x62, 0x79, 0x7b, 0x62, 0x7a};
const uint8_t HuffDecoderCommon::table29_36_emit_[204] = {
    0x7b, 0x64, 0x30, 0x7b, 0x64, 0x31, 0x7b, 0x64, 0x32, 0x7b, 0x64, 0x61,
    0x7b, 0x64, 0x63, 0x7b, 0x64, 0x65, 0x7b, 0x64, 0x69, 0x7b, 0x64, 0x6f,
    0x7b, 0x64, 0x73, 0x7b, 0x64, 0x74, 0x7b, 0x64, 0x20, 0x7b, 0x64, 0x25,
    0x7b, 0x64, 0x2d, 0x7b, 0x64, 0x2e, 0x7b, 0x64, 0x2f, 0x7b, 0x64, 0x33,
    0x7b, 0x64, 0x34, 0x7b, 0x64, 0x35, 0x7b, 0x64, 0x36, 0x7b, 0x64, 0x37,
    0x7b, 0x64, 0x38, 0x7b, 0x64, 0x39, 0x7b, 0x64, 0x3d, 0x7b, 0x64, 0x41,
    0x7b, 0x64, 0x5f, 0x7b, 0x64, 0x62, 0x7b, 0x64, 0x64, 0x7b, 0x64, 0x66,
    0x7b, 0x64, 0x67, 0x7b, 0x64, 0x68, 0x7b, 0x64, 0x6c, 0x7b, 0x64, 0x6d,
    0x7b, 0x64, 0x6e, 0x7b, 0x64, 0x70, 0x7b, 0x64, 0x72, 0x7b, 0x64, 0x75,
    0x7b, 0x64, 0x3a, 0x7b, 0x64, 0x42, 0x7b, 0x64, 0x43, 0x7b, 0x64, 0x44,
    0x7b, 0x64, 0x45, 0x7b, 0x64, 0x46, 0x7b, 0x64, 0x47, 0x7b, 0x64, 0x48,
    0x7b, 0x64, 0x49, 0x7b, 0x64, 0x4a, 0x7b, 0x64, 0x4b, 0x7b, 0x64, 0x4c,
    0x7b, 0x64, 0x4d, 0x7b, 0x64, 0x4e, 0x7b, 0x64, 0x4f, 0x7b, 0x64, 0x50,
    0x7b, 0x64, 0x51, 0x7b, 0x64, 0x52, 0x7b, 0x64, 0x53, 0x7b, 0x64, 0x54,
    0x7b, 0x64, 0x55, 0x7b, 0x64, 0x56, 0x7b, 0x64, 0x57, 0x7b, 0x64, 0x59,
    0x7b, 0x64, 0x6a, 0x7b, 0x64, 0x6b, 0x7b, 0x64, 0x71, 0x7b, 0x64, 0x76,
    0x7b, 0x64, 0x77, 0x7b, 0x64, 0x78, 0x7b, 0x64, 0x79, 0x7b, 0x64, 0x7a};
const uint8_t HuffDecoderCommon::table29_37_emit_[204] = {
    0x7b, 0x66, 0x30, 0x7b, 0x66, 0x31, 0x7b, 0x66, 0x32, 0x7b, 0x66, 0x61,
    0x7b, 0x66, 0x63, 0x7b, 0x66, 0x65, 0x7b, 0x66, 0x69, 0x7b, 0x66, 0x6f,
    0x7b, 0x66, 0x73, 0x7b, 0x66, 0x74, 0x7b, 0x66, 0x20, 0x7b, 0x66, 0x25,
    0x7b, 0x66, 0x2d, 0x7b, 0x66, 0x2e, 0x7b, 0x66, 0x2f, 0x7b, 0x66, 0x33,
    0x7b, 0x66, 0x34, 0x7b, 0x66, 0x35, 0x7b, 0x66, 0x36, 0x7b, 0x66, 0x37,
    0x7b, 0x66, 0x38, 0x7b, 0x66, 0x39, 0x7b, 0x66, 0x3d, 0x7b, 0x66, 0x41,
    0x7b, 0x66, 0x5f, 0x7b, 0x66, 0x62, 0x7b, 0x66, 0x64, 0x7b, 0x66, 0x66,
    0x7b, 0x66, 0x67, 0x7b, 0x66, 0x68, 0x7b, 0x66, 0x6c, 0x7b, 0x66, 0x6d,
    0x7b, 0x66, 0x6e, 0x7b, 0x66, 0x70, 0x7b, 0x66, 0x72, 0x7b, 0x66, 0x75,
    0x7b, 0x66, 0x3a, 0x7b, 0x66, 0x42, 0x7b, 0x66, 0x43, 0x7b, 0x66, 0x44,
    0x7b, 0x66, 0x45, 0x7b, 0x66, 0x46, 0x7b, 0x66, 0x47, 0x7b, 0x66, 0x48,
    0x7b, 0x66, 0x49, 0x7b, 0x66, 0x4a, 0x7b, 0x66, 0x4b, 0x7b, 0x66, 0x4c,
    0x7b, 0x66, 0x4d, 0x7b, 0x66, 0x4e, 0x7b, 0x66, 0x4f, 0x7b, 0x66, 0x50,
    0x7b, 0x66, 0x51, 0x7b, 0x66, 0x52, 0x7b, 0x66, 0x53, 0x7b, 0x66, 0x54,
    0x7b, 0x66, 0x55, 0x7b, 0x66, 0x56, 0x7b, 0x66, 0x57, 0x7b, 0x66, 0x59,
    0x7b, 0x66, 0x6a, 0x7b, 0x66, 0x6b, 0x7b, 0x66, 0x71, 0x7b, 0x66, 0x76,
    0x7b, 0x66, 0x77, 0x7b, 0x66, 0x78, 0x7b, 0x66, 0x79, 0x7b, 0x66, 0x7a};
const uint8_t HuffDecoderCommon::table29_38_emit_[204] = {
    0x7b, 0x67, 0x30, 0x7b, 0x67, 0x31, 0x7b, 0x67, 0x32, 0x7b, 0x67, 0x61,
    0x7b, 0x67, 0x63, 0x7b, 0x67, 0x65, 0x7b, 0x67, 0x69, 0x7b, 0x67, 0x6f,
    0x7b, 0x67, 0x73, 0x7b, 0x67, 0x74, 0x7b, 0x67, 0x20, 0x7b, 0x67, 0x25,
    0x7b, 0x67, 0x2d, 0x7b, 0x67, 0x2e, 0x7b, 0x67, 0x2f, 0x7b, 0x67, 0x33,
    0x7b, 0x67, 0x34, 0x7b, 0x67, 0x35, 0x7b, 0x67, 0x36, 0x7b, 0x67, 0x37,
    0x7b, 0x67, 0x38, 0x7b, 0x67, 0x39, 0x7b, 0x67, 0x3d, 0x7b, 0x67, 0x41,
    0x7b, 0x67, 0x5f, 0x7b, 0x67, 0x62, 0x7b, 0x67, 0x64, 0x7b, 0x67, 0x66,
    0x7b, 0x67, 0x67, 0x7b, 0x67, 0x68, 0x7b, 0x67, 0x6c, 0x7b, 0x67, 0x6d,
    0x7b, 0x67, 0x6e, 0x7b, 0x67, 0x70, 0x7b, 0x67, 0x72, 0x7b, 0x67, 0x75,
    0x7b, 0x67, 0x3a, 0x7b, 0x67, 0x42, 0x7b, 0x67, 0x43, 0x7b, 0x67, 0x44,
    0x7b, 0x67, 0x45, 0x7b, 0x67, 0x46, 0x7b, 0x67, 0x47, 0x7b, 0x67, 0x48,
    0x7b, 0x67, 0x49, 0x7b, 0x67, 0x4a, 0x7b, 0x67, 0x4b, 0x7b, 0x67, 0x4c,
    0x7b, 0x67, 0x4d, 0x7b, 0x67, 0x4e, 0x7b, 0x67, 0x4f, 0x7b, 0x67, 0x50,
    0x7b, 0x67, 0x51, 0x7b, 0x67, 0x52, 0x7b, 0x67, 0x53, 0x7b, 0x67, 0x54,
    0x7b, 0x67, 0x55, 0x7b, 0x67, 0x56, 0x7b, 0x67, 0x57, 0x7b, 0x67, 0x59,
    0x7b, 0x67, 0x6a, 0x7b, 0x67, 0x6b, 0x7b, 0x67, 0x71, 0x7b, 0x67, 0x76,
    0x7b, 0x67, 0x77, 0x7b, 0x67, 0x78, 0x7b, 0x67, 0x79, 0x7b, 0x67, 0x7a};
const uint8_t HuffDecoderCommon::table29_39_emit_[204] = {
    0x7b, 0x68, 0x30, 0x7b, 0x68, 0x31, 0x7b, 0x68, 0x32, 0x7b, 0x68, 0x61,
    0x7b, 0x68, 0x63, 0x7b, 0x68, 0x65, 0x7b, 0x68, 0x69, 0x7b, 0x68, 0x6f,
    0x7b, 0x68, 0x73, 0x7b, 0x68, 0x74, 0x7b, 0x68, 0x20, 0x7b, 0x68, 0x25,
    0x7b, 0x68, 0x2d, 0x7b, 0x68, 0x2e, 0x7b, 0x68, 0x2f, 0x7b, 0x68, 0x33,
    0x7b, 0x68, 0x34, 0x7b, 0x68, 0x35, 0x7b, 0x68, 0x36, 0x7b, 0x68, 0x37,
    0x7b, 0x68, 0x38, 0x7b, 0x68, 0x39, 0x7b, 0x68, 0x3d, 0x7b, 0x68, 0x41,
    0x7b, 0x68, 0x5f, 0x7b, 0x68, 0x62, 0x7b, 0x68, 0x64, 0x7b, 0x68, 0x66,
    0x7b, 0x68, 0x67, 0x7b, 0x68, 0x68, 0x7b, 0x68, 0x6c, 0x7b, 0x68, 0x6d,
    0x7b, 0x68, 0x6e, 0x7b, 0x68, 0x70, 0x7b, 0x68, 0x72, 0x7b, 0x68, 0x75,
    0x7b, 0x68, 0x3a, 0x7b, 0x68, 0x42, 0x7b, 0x68, 0x43, 0x7b, 0x68, 0x44,
    0x7b, 0x68, 0x45, 0x7b, 0x68, 0x46, 0x7b, 0x68, 0x47, 0x7b, 0x68, 0x48,
    0x7b, 0x68, 0x49, 0x7b, 0x68, 0x4a, 0x7b, 0x68, 0x4b, 0x7b, 0x68, 0x4c,
    0x7b, 0x68, 0x4d, 0x7b, 0x68, 0x4e, 0x7b, 0x68, 0x4f, 0x7b, 0x68, 0x50,
    0x7b, 0x68, 0x51, 0x7b, 0x68, 0x52, 0x7b, 0x68, 0x53, 0x7b, 0x68, 0x54,
    0x7b, 0x68, 0x55, 0x7b, 0x68, 0x56, 0x7b, 0x68, 0x57, 0x7b, 0x68, 0x59,
    0x7b, 0x68, 0x6a, 0x7b, 0x68, 0x6b, 0x7b, 0x68, 0x71, 0x7b, 0x68, 0x76,
    0x7b, 0x68, 0x77, 0x7b, 0x68, 0x78, 0x7b, 0x68, 0x79, 0x7b, 0x68, 0x7a};
const uint8_t HuffDecoderCommon::table29_40_emit_[204] = {
    0x7b, 0x6c, 0x30, 0x7b, 0x6c, 0x31, 0x7b, 0x6c, 0x32, 0x7b, 0x6c, 0x61,
    0x7b, 0x6c, 0x63, 0x7b, 0x6c, 0x65, 0x7b, 0x6c, 0x69, 0x7b, 0x6c, 0x6f,
    0x7b, 0x6c, 0x73, 0x7b, 0x6c, 0x74, 0x7b, 0x6c, 0x20, 0x7b, 0x6c, 0x25,
    0x7b, 0x6c, 0x2d, 0x7b, 0x6c, 0x2e, 0x7b, 0x6c, 0x2f, 0x7b, 0x6c, 0x33,
    0x7b, 0x6c, 0x34, 0x7b, 0x6c, 0x35, 0x7b, 0x6c, 0x36, 0x7b, 0x6c, 0x37,
    0x7b, 0x6c, 0x38, 0x7b, 0x6c, 0x39, 0x7b, 0x6c, 0x3d, 0x7b, 0x6c, 0x41,
    0x7b, 0x6c, 0x5f, 0x7b, 0x6c, 0x62, 0x7b, 0x6c, 0x64, 0x7b, 0x6c, 0x66,
    0x7b, 0x6c, 0x67, 0x7b, 0x6c, 0x68, 0x7b, 0x6c, 0x6c, 0x7b, 0x6c, 0x6d,
    0x7b, 0x6c, 0x6e, 0x7b, 0x6c, 0x70, 0x7b, 0x6c, 0x72, 0x7b, 0x6c, 0x75,
    0x7b, 0x6c, 0x3a, 0x7b, 0x6c, 0x42, 0x7b, 0x6c, 0x43, 0x7b, 0x6c, 0x44,
    0x7b, 0x6c, 0x45, 0x7b, 0x6c, 0x46, 0x7b, 0x6c, 0x47, 0x7b, 0x6c, 0x48,
    0x7b, 0x6c, 0x49, 0x7b, 0x6c, 0x4a, 0x7b, 0x6c, 0x4b, 0x7b, 0x6c, 0x4c,
    0x7b, 0x6c, 0x4d, 0x7b, 0x6c, 0x4e, 0x7b, 0x6c, 0x4f, 0x7b, 0x6c, 0x50,
    0x7b, 0x6c, 0x51, 0x7b, 0x6c, 0x52, 0x7b, 0x6c, 0x53, 0x7b, 0x6c, 0x54,
    0x7b, 0x6c, 0x55, 0x7b, 0x6c, 0x56, 0x7b, 0x6c, 0x57, 0x7b, 0x6c, 0x59,
    0x7b, 0x6c, 0x6a, 0x7b, 0x6c, 0x6b, 0x7b, 0x6c, 0x71, 0x7b, 0x6c, 0x76,
    0x7b, 0x6c, 0x77, 0x7b, 0x6c, 0x78, 0x7b, 0x6c, 0x79, 0x7b, 0x6c, 0x7a};
const uint8_t HuffDecoderCommon::table29_41_emit_[204] = {
    0x7b, 0x6d, 0x30, 0x7b, 0x6d, 0x31, 0x7b, 0x6d, 0x32, 0x7b, 0x6d, 0x61,
    0x7b, 0x6d, 0x63, 0x7b, 0x6d, 0x65, 0x7b, 0x6d, 0x69, 0x7b, 0x6d, 0x6f,
    0x7b, 0x6d, 0x73, 0x7b, 0x6d, 0x74, 0x7b, 0x6d, 0x20, 0x7b, 0x6d, 0x25,
    0x7b, 0x6d, 0x2d, 0x7b, 0x6d, 0x2e, 0x7b, 0x6d, 0x2f, 0x7b, 0x6d, 0x33,
    0x7b, 0x6d, 0x34, 0x7b, 0x6d, 0x35, 0x7b, 0x6d, 0x36, 0x7b, 0x6d, 0x37,
    0x7b, 0x6d, 0x38, 0x7b, 0x6d, 0x39, 0x7b, 0x6d, 0x3d, 0x7b, 0x6d, 0x41,
    0x7b, 0x6d, 0x5f, 0x7b, 0x6d, 0x62, 0x7b, 0x6d, 0x64, 0x7b, 0x6d, 0x66,
    0x7b, 0x6d, 0x67, 0x7b, 0x6d, 0x68, 0x7b, 0x6d, 0x6c, 0x7b, 0x6d, 0x6d,
    0x7b, 0x6d, 0x6e, 0x7b, 0x6d, 0x70, 0x7b, 0x6d, 0x72, 0x7b, 0x6d, 0x75,
    0x7b, 0x6d, 0x3a, 0x7b, 0x6d, 0x42, 0x7b, 0x6d, 0x43, 0x7b, 0x6d, 0x44,
    0x7b, 0x6d, 0x45, 0x7b, 0x6d, 0x46, 0x7b, 0x6d, 0x47, 0x7b, 0x6d, 0x48,
    0x7b, 0x6d, 0x49, 0x7b, 0x6d, 0x4a, 0x7b, 0x6d, 0x4b, 0x7b, 0x6d, 0x4c,
    0x7b, 0x6d, 0x4d, 0x7b, 0x6d, 0x4e, 0x7b, 0x6d, 0x4f, 0x7b, 0x6d, 0x50,
    0x7b, 0x6d, 0x51, 0x7b, 0x6d, 0x52, 0x7b, 0x6d, 0x53, 0x7b, 0x6d, 0x54,
    0x7b, 0x6d, 0x55, 0x7b, 0x6d, 0x56, 0x7b, 0x6d, 0x57, 0x7b, 0x6d, 0x59,
    0x7b, 0x6d, 0x6a, 0x7b, 0x6d, 0x6b, 0x7b, 0x6d, 0x71, 0x7b, 0x6d, 0x76,
    0x7b, 0x6d, 0x77, 0x7b, 0x6d, 0x78, 0x7b, 0x6d, 0x79, 0x7b, 0x6d, 0x7a};
const uint8_t HuffDecoderCommon::table29_42_emit_[204] = {
    0x7b, 0x6e, 0x30, 0x7b, 0x6e, 0x31, 0x7b, 0x6e, 0x32, 0x7b, 0x6e, 0x61,
    0x7b, 0x6e, 0x63, 0x7b, 0x6e, 0x65, 0x7b, 0x6e, 0x69, 0x7b, 0x6e, 0x6f,
    0x7b, 0x6e, 0x73, 0x7b, 0x6e, 0x74, 0x7b, 0x6e, 0x20, 0x7b, 0x6e, 0x25,
    0x7b, 0x6e, 0x2d, 0x7b, 0x6e, 0x2e, 0x7b, 0x6e, 0x2f, 0x7b, 0x6e, 0x33,
    0x7b, 0x6e, 0x34, 0x7b, 0x6e, 0x35, 0x7b, 0x6e, 0x36, 0x7b, 0x6e, 0x37,
    0x7b, 0x6e, 0x38, 0x7b, 0x6e, 0x39, 0x7b, 0x6e, 0x3d, 0x7b, 0x6e, 0x41,
    0x7b, 0x6e, 0x5f, 0x7b, 0x6e, 0x62, 0x7b, 0x6e, 0x64, 0x7b, 0x6e, 0x66,
    0x7b, 0x6e, 0x67, 0x7b, 0x6e, 0x68, 0x7b, 0x6e, 0x6c, 0x7b, 0x6e, 0x6d,
    0x7b, 0x6e, 0x6e, 0x7b, 0x6e, 0x70, 0x7b, 0x6e, 0x72, 0x7b, 0x6e, 0x75,
    0x7b, 0x6e, 0x3a, 0x7b, 0x6e, 0x42, 0x7b, 0x6e, 0x43, 0x7b, 0x6e, 0x44,
    0x7b, 0x6e, 0x45, 0x7b, 0x6e, 0x46, 0x7b, 0x6e, 0x47, 0x7b, 0x6e, 0x48,
    0x7b, 0x6e, 0x49, 0x7b, 0x6e, 0x4a, 0x7b, 0x6e, 0x4b, 0x7b, 0x6e, 0x4c,
    0x7b, 0x6e, 0x4d, 0x7b, 0x6e, 0x4e, 0x7b, 0x6e, 0x4f, 0x7b, 0x6e, 0x50,
    0x7b, 0x6e, 0x51, 0x7b, 0x6e, 0x52, 0x7b, 0x6e, 0x53, 0x7b, 0x6e, 0x54,
    0x7b, 0x6e, 0x55, 0x7b, 0x6e, 0x56, 0x7b, 0x6e, 0x57, 0x7b, 0x6e, 0x59,
    0x7b, 0x6e, 0x6a, 0x7b, 0x6e, 0x6b, 0x7b, 0x6e, 0x71, 0x7b, 0x6e, 0x76,
    0x7b, 0x6e, 0x77, 0x7b, 0x6e, 0x78, 0x7b, 0x6e, 0x79, 0x7b, 0x6e, 0x7a};
const uint8_t HuffDecoderCommon::table29_43_emit_[204] = {
    0x7b, 0x70, 0x30, 0x7b, 0x70, 0x31, 0x7b, 0x70, 0x32, 0x7b, 0x70, 0x61,
    0x7b, 0x70, 0x63, 0x7b, 0x70, 0x65, 0x7b, 0x70, 0x69, 0x7b, 0x70, 0x6f,
    0x7b, 0x70, 0x73, 0x7b, 0x70, 0x74, 0x7b, 0x70, 0x20, 0x7b, 0x70, 0x25,
    0x7b, 0x70, 0x2d, 0x7b, 0x70, 0x2e, 0x7b, 0x70, 0x2f, 0x7b, 0x70, 0x33,
    0x7b, 0x70, 0x34, 0x7b, 0x70, 0x35, 0x7b, 0x70, 0x36, 0x7b, 0x70, 0x37,
    0x7b, 0x70, 0x38, 0x7b, 0x70, 0x39, 0x7b, 0x70, 0x3d, 0x7b, 0x70, 0x41,
    0x7b, 0x70, 0x5f, 0x7b, 0x70, 0x62, 0x7b, 0x70, 0x64, 0x7b, 0x70, 0x66,
    0x7b, 0x70, 0x67, 0x7b, 0x70, 0x68, 0x7b, 0x70, 0x6c, 0x7b, 0x70, 0x6d,
    0x7b, 0x70, 0x6e, 0x7b, 0x70, 0x70, 0x7b, 0x70, 0x72, 0x7b, 0x70, 0x75,
    0x7b, 0x70, 0x3a, 0x7b, 0x70, 0x42, 0x7b, 0x70, 0x43, 0x7b, 0x70, 0x44,
    0x7b, 0x70, 0x45, 0x7b, 0x70, 0x46, 0x7b, 0x70, 0x47, 0x7b, 0x70, 0x48,
    0x7b, 0x70, 0x49, 0x7b, 0x70, 0x4a, 0x7b, 0x70, 0x4b, 0x7b, 0x70, 0x4c,
    0x7b, 0x70, 0x4d, 0x7b, 0x70, 0x4e, 0x7b, 0x70, 0x4f, 0x7b, 0x70, 0x50,
    0x7b, 0x70, 0x51, 0x7b, 0x70, 0x52, 0x7b, 0x70, 0x53, 0x7b, 0x70, 0x54,
    0x7b, 0x70, 0x55, 0x7b, 0x70, 0x56, 0x7b, 0x70, 0x57, 0x7b, 0x70, 0x59,
    0x7b, 0x70, 0x6a, 0x7b, 0x70, 0x6b, 0x7b, 0x70, 0x71, 0x7b, 0x70, 0x76,
    0x7b, 0x70, 0x77, 0x7b, 0x70, 0x78, 0x7b, 0x70, 0x79, 0x7b, 0x70, 0x7a};
const uint8_t HuffDecoderCommon::table29_44_emit_[204] = {
    0x7b, 0x72, 0x30, 0x7b, 0x72, 0x31, 0x7b, 0x72, 0x32, 0x7b, 0x72, 0x61,
    0x7b, 0x72, 0x63, 0x7b, 0x72, 0x65, 0x7b, 0x72, 0x69, 0x7b, 0x72, 0x6f,
    0x7b, 0x72, 0x73, 0x7b, 0x72, 0x74, 0x7b, 0x72, 0x20, 0x7b, 0x72, 0x25,
    0x7b, 0x72, 0x2d, 0x7b, 0x72, 0x2e, 0x7b, 0x72, 0x2f, 0x7b, 0x72, 0x33,
    0x7b, 0x72, 0x34, 0x7b, 0x72, 0x35, 0x7b, 0x72, 0x36, 0x7b, 0x72, 0x37,
    0x7b, 0x72, 0x38, 0x7b, 0x72, 0x39, 0x7b, 0x72, 0x3d, 0x7b, 0x72, 0x41,
    0x7b, 0x72, 0x5f, 0x7b, 0x72, 0x62, 0x7b, 0x72, 0x64, 0x7b, 0x72, 0x66,
    0x7b, 0x72, 0x67, 0x7b, 0x72, 0x68, 0x7b, 0x72, 0x6c, 0x7b, 0x72, 0x6d,
    0x7b, 0x72, 0x6e, 0x7b, 0x72, 0x70, 0x7b, 0x72, 0x72, 0x7b, 0x72, 0x75,
    0x7b, 0x72, 0x3a, 0x7b, 0x72, 0x42, 0x7b, 0x72, 0x43, 0x7b, 0x72, 0x44,
    0x7b, 0x72, 0x45, 0x7b, 0x72, 0x46, 0x7b, 0x72, 0x47, 0x7b, 0x72, 0x48,
    0x7b, 0x72, 0x49, 0x7b, 0x72, 0x4a, 0x7b, 0x72, 0x4b, 0x7b, 0x72, 0x4c,
    0x7b, 0x72, 0x4d, 0x7b, 0x72, 0x4e, 0x7b, 0x72, 0x4f, 0x7b, 0x72, 0x50,
    0x7b, 0x72, 0x51, 0x7b, 0x72, 0x52, 0x7b, 0x72, 0x53, 0x7b, 0x72, 0x54,
    0x7b, 0x72, 0x55, 0x7b, 0x72, 0x56, 0x7b, 0x72, 0x57, 0x7b, 0x72, 0x59,
    0x7b, 0x72, 0x6a, 0x7b, 0x72, 0x6b, 0x7b, 0x72, 0x71, 0x7b, 0x72, 0x76,
    0x7b, 0x72, 0x77, 0x7b, 0x72, 0x78, 0x7b, 0x72, 0x79, 0x7b, 0x72, 0x7a};
const uint8_t HuffDecoderCommon::table29_45_emit_[204] = {
    0x7b, 0x75, 0x30, 0x7b, 0x75, 0x31, 0x7b, 0x75, 0x32, 0x7b, 0x75, 0x61,
    0x7b, 0x75, 0x63, 0x7b, 0x75, 0x65, 0x7b, 0x75, 0x69, 0x7b, 0x75, 0x6f,
    0x7b, 0x75, 0x73, 0x7b, 0x75, 0x74, 0x7b, 0x75, 0x20, 0x7b, 0x75, 0x25,
    0x7b, 0x75, 0x2d, 0x7b, 0x75, 0x2e, 0x7b, 0x75, 0x2f, 0x7b, 0x75, 0x33,
    0x7b, 0x75, 0x34, 0x7b, 0x75, 0x35, 0x7b, 0x75, 0x36, 0x7b, 0x75, 0x37,
    0x7b, 0x75, 0x38, 0x7b, 0x75, 0x39, 0x7b, 0x75, 0x3d, 0x7b, 0x75, 0x41,
    0x7b, 0x75, 0x5f, 0x7b, 0x75, 0x62, 0x7b, 0x75, 0x64, 0x7b, 0x75, 0x66,
    0x7b, 0x75, 0x67, 0x7b, 0x75, 0x68, 0x7b, 0x75, 0x6c, 0x7b, 0x75, 0x6d,
    0x7b, 0x75, 0x6e, 0x7b, 0x75, 0x70, 0x7b, 0x75, 0x72, 0x7b, 0x75, 0x75,
    0x7b, 0x75, 0x3a, 0x7b, 0x75, 0x42, 0x7b, 0x75, 0x43, 0x7b, 0x75, 0x44,
    0x7b, 0x75, 0x45, 0x7b, 0x75, 0x46, 0x7b, 0x75, 0x47, 0x7b, 0x75, 0x48,
    0x7b, 0x75, 0x49, 0x7b, 0x75, 0x4a, 0x7b, 0x75, 0x4b, 0x7b, 0x75, 0x4c,
    0x7b, 0x75, 0x4d, 0x7b, 0x75, 0x4e, 0x7b, 0x75, 0x4f, 0x7b, 0x75, 0x50,
    0x7b, 0x75, 0x51, 0x7b, 0x75, 0x52, 0x7b, 0x75, 0x53, 0x7b, 0x75, 0x54,
    0x7b, 0x75, 0x55, 0x7b, 0x75, 0x56, 0x7b, 0x75, 0x57, 0x7b, 0x75, 0x59,
    0x7b, 0x75, 0x6a, 0x7b, 0x75, 0x6b, 0x7b, 0x75, 0x71, 0x7b, 0x75, 0x76,
    0x7b, 0x75, 0x77, 0x7b, 0x75, 0x78, 0x7b, 0x75, 0x79, 0x7b, 0x75, 0x7a};
const uint8_t HuffDecoderCommon::table29_46_emit_[216] = {
    0x7b, 0x3a, 0x30, 0x7b, 0x3a, 0x31, 0x7b, 0x3a, 0x32, 0x7b, 0x3a, 0x61,
    0x7b, 0x3a, 0x63, 0x7b, 0x3a, 0x65, 0x7b, 0x3a, 0x69, 0x7b, 0x3a, 0x6f,
    0x7b, 0x3a, 0x73, 0x7b, 0x3a, 0x74, 0x7b, 0x3a, 0x20, 0x7b, 0x3a, 0x25,
    0x7b, 0x3a, 0x2d, 0x7b, 0x3a, 0x2e, 0x7b, 0x3a, 0x2f, 0x7b, 0x3a, 0x33,
    0x7b, 0x3a, 0x34, 0x7b, 0x3a, 0x35, 0x7b, 0x3a, 0x36, 0x7b, 0x3a, 0x37,
    0x7b, 0x3a, 0x38, 0x7b, 0x3a, 0x39, 0x7b, 0x3a, 0x3d, 0x7b, 0x3a, 0x41,
    0x7b, 0x3a, 0x5f, 0x7b, 0x3a, 0x62, 0x7b, 0x3a, 0x64, 0x7b, 0x3a, 0x66,
    0x7b, 0x3a, 0x67, 0x7b, 0x3a, 0x68, 0x7b, 0x3a, 0x6c, 0x7b, 0x3a, 0x6d,
    0x7b, 0x3a, 0x6e, 0x7b, 0x3a, 0x70, 0x7b, 0x3a, 0x72, 0x7b, 0x3a, 0x75,
    0x7b, 0x42, 0x30, 0x7b, 0x42, 0x31, 0x7b, 0x42, 0x32, 0x7b, 0x42, 0x61,
    0x7b, 0x42, 0x63, 0x7b, 0x42, 0x65, 0x7b, 0x42, 0x69, 0x7b, 0x42, 0x6f,
    0x7b, 0x42, 0x73, 0x7b, 0x42, 0x74, 0x7b, 0x42, 0x20, 0x7b, 0x42, 0x25,
    0x7b, 0x42, 0x2d, 0x7b, 0x42, 0x2e, 0x7b, 0x42, 0x2f, 0x7b, 0x42, 0x33,
    0x7b, 0x42, 0x34, 0x7b, 0x42, 0x35, 0x7b, 0x42, 0x36, 0x7b, 0x42, 0x37,
    0x7b, 0x42, 0x38, 0x7b, 0x42, 0x39, 0x7b, 0x42, 0x3d, 0x7b, 0x42, 0x41,
    0x7b, 0x42, 0x5f, 0x7b, 0x42, 0x62, 0x7b, 0x42, 0x64, 0x7b, 0x42, 0x66,
    0x7b, 0x42, 0x67, 0x7b, 0x42, 0x68, 0x7b, 0x42, 0x6c, 0x7b, 0x42, 0x6d,
    0x7b, 0x42, 0x6e, 0x7b, 0x42, 0x70, 0x7b, 0x42, 0x72, 0x7b, 0x42, 0x75};
const uint16_t HuffDecoderCommon::table29_46_inner_[75] = {
    0x0000, 0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9,
    0x00c1, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169, 0x0181,
    0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259,
    0x0271, 0x0289, 0x02a1, 0x02b9, 0x02d1, 0x02e9, 0x0301, 0x0319, 0x0331,
    0x0349, 0x0002, 0x0361, 0x0379, 0x0391, 0x03a9, 0x03c1, 0x03d9, 0x03f1,
    0x0409, 0x0421, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9,
    0x04e1, 0x04f9, 0x0511, 0x0529, 0x0541, 0x0559, 0x0571, 0x0589, 0x05a1,
    0x05b9, 0x05d1, 0x05e9, 0x0601, 0x0619, 0x0631, 0x0649, 0x0661, 0x0679,
    0x0691, 0x06a9, 0x0362};
const uint8_t HuffDecoderCommon::table29_46_outer_[128] = {
    0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,  0,  7,  0,  8,  0,  9,  0,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
    29, 30, 31, 32, 33, 34, 35, 36, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  37, 0,  38, 0,  39, 0,  40, 0,  41, 0,  42, 0,  43,
    0,  44, 0,  45, 0,  46, 0,  47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
    59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  74};
const uint8_t HuffDecoderCommon::table29_47_emit_[216] = {
    0x7b, 0x43, 0x30, 0x7b, 0x43, 0x31, 0x7b, 0x43, 0x32, 0x7b, 0x43, 0x61,
    0x7b, 0x43, 0x63, 0x7b, 0x43, 0x65, 0x7b, 0x43, 0x69, 0x7b, 0x43, 0x6f,
    0x7b, 0x43, 0x73, 0x7b, 0x43, 0x74, 0x7b, 0x43, 0x20, 0x7b, 0x43, 0x25,
    0x7b, 0x43, 0x2d, 0x7b, 0x43, 0x2e, 0x7b, 0x43, 0x2f, 0x7b, 0x43, 0x33,
    0x7b, 0x43, 0x34, 0x7b, 0x43, 0x35, 0x7b, 0x43, 0x36, 0x7b, 0x43, 0x37,
    0x7b, 0x43, 0x38, 0x7b, 0x43, 0x39, 0x7b, 0x43, 0x3d, 0x7b, 0x43, 0x41,
    0x7b, 0x43, 0x5f, 0x7b, 0x43, 0x62, 0x7b, 0x43, 0x64, 0x7b, 0x43, 0x66,
    0x7b, 0x43, 0x67, 0x7b, 0x43, 0x68, 0x7b, 0x43, 0x6c, 0x7b, 0x43, 0x6d,
    0x7b, 0x43, 0x6e, 0x7b, 0x43, 0x70, 0x7b, 0x43, 0x72, 0x7b, 0x43, 0x75,
    0x7b, 0x44, 0x30, 0x7b, 0x44, 0x31, 0x7b, 0x44, 0x32, 0x7b, 0x44, 0x61,
    0x7b, 0x44, 0x63, 0x7b, 0x44, 0x65, 0x7b, 0x44, 0x69, 0x7b, 0x44, 0x6f,
    0x7b, 0x44, 0x73, 0x7b, 0x44, 0x74, 0x7b, 0x44, 0x20, 0x7b, 0x44, 0x25,
    0x7b, 0x44, 0x2d, 0x7b, 0x44, 0x2e, 0x7b, 0x44, 0x2f, 0x7b, 0x44, 0x33,
    0x7b, 0x44, 0x34, 0x7b, 0x44, 0x35, 0x7b, 0x44, 0x36, 0x7b, 0x44, 0x37,
    0x7b, 0x44, 0x38, 0x7b, 0x44, 0x39, 0x7b, 0x44, 0x3d, 0x7b, 0x44, 0x41,
    0x7b, 0x44, 0x5f, 0x7b, 0x44, 0x62, 0x7b, 0x44, 0x64, 0x7b, 0x44, 0x66,
    0x7b, 0x44, 0x67, 0x7b, 0x44, 0x68, 0x7b, 0x44, 0x6c, 0x7b, 0x44, 0x6d,
    0x7b, 0x44, 0x6e, 0x7b, 0x44, 0x70, 0x7b, 0x44, 0x72, 0x7b, 0x44, 0x75};
const uint8_t HuffDecoderCommon::table29_48_emit_[216] = {
    0x7b, 0x45, 0x30, 0x7b, 0x45, 0x31, 0x7b, 0x45, 0x32, 0x7b, 0x45, 0x61,
    0x7b, 0x45, 0x63, 0x7b, 0x45, 0x65, 0x7b, 0x45, 0x69, 0x7b, 0x45, 0x6f,
    0x7b, 0x45, 0x73, 0x7b, 0x45, 0x74, 0x7b, 0x45, 0x20, 0x7b, 0x45, 0x25,
    0x7b, 0x45, 0x2d, 0x7b, 0x45, 0x2e, 0x7b, 0x45, 0x2f, 0x7b, 0x45, 0x33,
    0x7b, 0x45, 0x34, 0x7b, 0x45, 0x35, 0x7b, 0x45, 0x36, 0x7b, 0x45, 0x37,
    0x7b, 0x45, 0x38, 0x7b, 0x45, 0x39, 0x7b, 0x45, 0x3d, 0x7b, 0x45, 0x41,
    0x7b, 0x45, 0x5f, 0x7b, 0x45, 0x62, 0x7b, 0x45, 0x64, 0x7b, 0x45, 0x66,
    0x7b, 0x45, 0x67, 0x7b, 0x45, 0x68, 0x7b, 0x45, 0x6c, 0x7b, 0x45, 0x6d,
    0x7b, 0x45, 0x6e, 0x7b, 0x45, 0x70, 0x7b, 0x45, 0x72, 0x7b, 0x45, 0x75,
    0x7b, 0x46, 0x30, 0x7b, 0x46, 0x31, 0x7b, 0x46, 0x32, 0x7b, 0x46, 0x61,
    0x7b, 0x46, 0x63, 0x7b, 0x46, 0x65, 0x7b, 0x46, 0x69, 0x7b, 0x46, 0x6f,
    0x7b, 0x46, 0x73, 0x7b, 0x46, 0x74, 0x7b, 0x46, 0x20, 0x7b, 0x46, 0x25,
    0x7b, 0x46, 0x2d, 0x7b, 0x46, 0x2e, 0x7b, 0x46, 0x2f, 0x7b, 0x46, 0x33,
    0x7b, 0x46, 0x34, 0x7b, 0x46, 0x35, 0x7b, 0x46, 0x36, 0x7b, 0x46, 0x37,
    0x7b, 0x46, 0x38, 0x7b, 0x46, 0x39, 0x7b, 0x46, 0x3d, 0x7b, 0x46, 0x41,
    0x7b, 0x46, 0x5f, 0x7b, 0x46, 0x62, 0x7b, 0x46, 0x64, 0x7b, 0x46, 0x66,
    0x7b, 0x46, 0x67, 0x7b, 0x46, 0x68, 0x7b, 0x46, 0x6c, 0x7b, 0x46, 0x6d,
    0x7b, 0x46, 0x6e, 0x7b, 0x46, 0x70, 0x7b, 0x46, 0x72, 0x7b, 0x46, 0x75};
const uint8_t HuffDecoderCommon::table29_49_emit_[216] = {
    0x7b, 0x47, 0x30, 0x7b, 0x47, 0x31, 0x7b, 0x47, 0x32, 0x7b, 0x47, 0x61,
    0x7b, 0x47, 0x63, 0x7b, 0x47, 0x65, 0x7b, 0x47, 0x69, 0x7b, 0x47, 0x6f,
    0x7b, 0x47, 0x73, 0x7b, 0x47, 0x74, 0x7b, 0x47, 0x20, 0x7b, 0x47, 0x25,
    0x7b, 0x47, 0x2d, 0x7b, 0x47, 0x2e, 0x7b, 0x47, 0x2f, 0x7b, 0x47, 0x33,
    0x7b, 0x47, 0x34, 0x7b, 0x47, 0x35, 0x7b, 0x47, 0x36, 0x7b, 0x47, 0x37,
    0x7b, 0x47, 0x38, 0x7b, 0x47, 0x39, 0x7b, 0x47, 0x3d, 0x7b, 0x47, 0x41,
    0x7b, 0x47, 0x5f, 0x7b, 0x47, 0x62, 0x7b, 0x47, 0x64, 0x7b, 0x47, 0x66,
    0x7b, 0x47, 0x67, 0x7b, 0x47, 0x68, 0x7b, 0x47, 0x6c, 0x7b, 0x47, 0x6d,
    0x7b, 0x47, 0x6e, 0x7b, 0x47, 0x70, 0x7b, 0x47, 0x72, 0x7b, 0x47, 0x75,
    0x7b, 0x48, 0x30, 0x7b, 0x48, 0x31, 0x7b, 0x48, 0x32, 0x7b, 0x48, 0x61,
    0x7b, 0x48, 0x63, 0x7b, 0x48, 0x65, 0x7b, 0x48, 0x69, 0x7b, 0x48, 0x6f,
    0x7b, 0x48, 0x73, 0x7b, 0x48, 0x74, 0x7b, 0x48, 0x20, 0x7b, 0x48, 0x25,
    0x7b, 0x48, 0x2d, 0x7b, 0x48, 0x2e, 0x7b, 0x48, 0x2f, 0x7b, 0x48, 0x33,
    0x7b, 0x48, 0x34, 0x7b, 0x48, 0x35, 0x7b, 0x48, 0x36, 0x7b, 0x48, 0x37,
    0x7b, 0x48, 0x38, 0x7b, 0x48, 0x39, 0x7b, 0x48, 0x3d, 0x7b, 0x48, 0x41,
    0x7b, 0x48, 0x5f, 0x7b, 0x48, 0x62, 0x7b, 0x48, 0x64, 0x7b, 0x48, 0x66,
    0x7b, 0x48, 0x67, 0x7b, 0x48, 0x68, 0x7b, 0x48, 0x6c, 0x7b, 0x48, 0x6d,
    0x7b, 0x48, 0x6e, 0x7b, 0x48, 0x70, 0x7b, 0x48, 0x72, 0x7b, 0x48, 0x75};
const uint8_t HuffDecoderCommon::table29_50_emit_[216] = {
    0x7b, 0x49, 0x30, 0x7b, 0x49, 0x31, 0x7b, 0x49, 0x32, 0x7b, 0x49, 0x61,
    0x7b, 0x49, 0x63, 0x7b, 0x49, 0x65, 0x7b, 0x49, 0x69, 0x7b, 0x49, 0x6f,
    0x7b, 0x49, 0x73, 0x7b, 0x49, 0x74, 0x7b, 0x49, 0x20, 0x7b, 0x49, 0x25,
    0x7b, 0x49, 0x2d, 0x7b, 0x49, 0x2e, 0x7b, 0x49, 0x2f, 0x7b, 0x49, 0x33,
    0x7b, 0x49, 0x34, 0x7b, 0x49, 0x35, 0x7b, 0x49, 0x36, 0x7b, 0x49, 0x37,
    0x7b, 0x49, 0x38, 0x7b, 0x49, 0x39, 0x7b, 0x49, 0x3d, 0x7b, 0x49, 0x41,
    0x7b, 0x49, 0x5f, 0x7b, 0x49, 0x62, 0x7b, 0x49, 0x64, 0x7b, 0x49, 0x66,
    0x7b, 0x49, 0x67, 0x7b, 0x49, 0x68, 0x7b, 0x49, 0x6c, 0x7b, 0x49, 0x6d,
    0x7b, 0x49, 0x6e, 0x7b, 0x49, 0x70, 0x7b, 0x49, 0x72, 0x7b, 0x49, 0x75,
    0x7b, 0x4a, 0x30, 0x7b, 0x4a, 0x31, 0x7b, 0x4a, 0x32, 0x7b, 0x4a, 0x61,
    0x7b, 0x4a, 0x63, 0x7b, 0x4a, 0x65, 0x7b, 0x4a, 0x69, 0x7b, 0x4a, 0x6f,
    0x7b, 0x4a, 0x73, 0x7b, 0x4a, 0x74, 0x7b, 0x4a, 0x20, 0x7b, 0x4a, 0x25,
    0x7b, 0x4a, 0x2d, 0x7b, 0x4a, 0x2e, 0x7b, 0x4a, 0x2f, 0x7b, 0x4a, 0x33,
    0x7b, 0x4a, 0x34, 0x7b, 0x4a, 0x35, 0x7b, 0x4a, 0x36, 0x7b, 0x4a, 0x37,
    0x7b, 0x4a, 0x38, 0x7b, 0x4a, 0x39, 0x7b, 0x4a, 0x3d, 0x7b, 0x4a, 0x41,
    0x7b, 0x4a, 0x5f, 0x7b, 0x4a, 0x62, 0x7b, 0x4a, 0x64, 0x7b, 0x4a, 0x66,
    0x7b, 0x4a, 0x67, 0x7b, 0x4a, 0x68, 0x7b, 0x4a, 0x6c, 0x7b, 0x4a, 0x6d,
    0x7b, 0x4a, 0x6e, 0x7b, 0x4a, 0x70, 0x7b, 0x4a, 0x72, 0x7b, 0x4a, 0x75};
const uint8_t HuffDecoderCommon::table29_51_emit_[216] = {
    0x7b, 0x4b, 0x30, 0x7b, 0x4b, 0x31, 0x7b, 0x4b, 0x32, 0x7b, 0x4b, 0x61,
    0x7b, 0x4b, 0x63, 0x7b, 0x4b, 0x65, 0x7b, 0x4b, 0x69, 0x7b, 0x4b, 0x6f,
    0x7b, 0x4b, 0x73, 0x7b, 0x4b, 0x74, 0x7b, 0x4b, 0x20, 0x7b, 0x4b, 0x25,
    0x7b, 0x4b, 0x2d, 0x7b, 0x4b, 0x2e, 0x7b, 0x4b, 0x2f, 0x7b, 0x4b, 0x33,
    0x7b, 0x4b, 0x34, 0x7b, 0x4b, 0x35, 0x7b, 0x4b, 0x36, 0x7b, 0x4b, 0x37,
    0x7b, 0x4b, 0x38, 0x7b, 0x4b, 0x39, 0x7b, 0x4b, 0x3d, 0x7b, 0x4b, 0x41,
    0x7b, 0x4b, 0x5f, 0x7b, 0x4b, 0x62, 0x7b, 0x4b, 0x64, 0x7b, 0x4b, 0x66,
    0x7b, 0x4b, 0x67, 0x7b, 0x4b, 0x68, 0x7b, 0x4b, 0x6c, 0x7b, 0x4b, 0x6d,
    0x7b, 0x4b, 0x6e, 0x7b, 0x4b, 0x70, 0x7b, 0x4b, 0x72, 0x7b, 0x4b, 0x75,
    0x7b, 0x4c, 0x30, 0x7b, 0x4c, 0x31, 0x7b, 0x4c, 0x32, 0x7b, 0x4c, 0x61,
    0x7b, 0x4c, 0x63, 0x7b, 0x4c, 0x65, 0x7b, 0x4c, 0x69, 0x7b, 0x4c, 0x6f,
    0x7b, 0x4c, 0x73, 0x7b, 0x4c, 0x74, 0x7b, 0x4c, 0x20, 0x7b, 0x4c, 0x25,
    0x7b, 0x4c, 0x2d, 0x7b, 0x4c, 0x2e, 0x7b, 0x4c, 0x2f, 0x7b, 0x4c, 0x33,
    0x7b, 0x4c, 0x34, 0x7b, 0x4c, 0x35, 0x7b, 0x4c, 0x36, 0x7b, 0x4c, 0x37,
    0x7b, 0x4c, 0x38, 0x7b, 0x4c, 0x39, 0x7b, 0x4c, 0x3d, 0x7b, 0x4c, 0x41,
    0x7b, 0x4c, 0x5f, 0x7b, 0x4c, 0x62, 0x7b, 0x4c, 0x64, 0x7b, 0x4c, 0x66,
    0x7b, 0x4c, 0x67, 0x7b, 0x4c, 0x68, 0x7b, 0x4c, 0x6c, 0x7b, 0x4c, 0x6d,
    0x7b, 0x4c, 0x6e, 0x7b, 0x4c, 0x70, 0x7b, 0x4c, 0x72, 0x7b, 0x4c, 0x75};
const uint8_t HuffDecoderCommon::table29_52_emit_[216] = {
    0x7b, 0x4d, 0x30, 0x7b, 0x4d, 0x31, 0x7b, 0x4d, 0x32, 0x7b, 0x4d, 0x61,
    0x7b, 0x4d, 0x63, 0x7b, 0x4d, 0x65, 0x7b, 0x4d, 0x69, 0x7b, 0x4d, 0x6f,
    0x7b, 0x4d, 0x73, 0x7b, 0x4d, 0x74, 0x7b, 0x4d, 0x20, 0x7b, 0x4d, 0x25,
    0x7b, 0x4d, 0x2d, 0x7b, 0x4d, 0x2e, 0x7b, 0x4d, 0x2f, 0x7b, 0x4d, 0x33,
    0x7b, 0x4d, 0x34, 0x7b, 0x4d, 0x35, 0x7b, 0x4d, 0x36, 0x7b, 0x4d, 0x37,
    0x7b, 0x4d, 0x38, 0x7b, 0x4d, 0x39, 0x7b, 0x4d, 0x3d, 0x7b, 0x4d, 0x41,
    0x7b, 0x4d, 0x5f, 0x7b, 0x4d, 0x62, 0x7b, 0x4d, 0x64, 0x7b, 0x4d, 0x66,
    0x7b, 0x4d, 0x67, 0x7b, 0x4d, 0x68, 0x7b, 0x4d, 0x6c, 0x7b, 0x4d, 0x6d,
    0x7b, 0x4d, 0x6e, 0x7b, 0x4d, 0x70, 0x7b, 0x4d, 0x72, 0x7b, 0x4d, 0x75,
    0x7b, 0x4e, 0x30, 0x7b, 0x4e, 0x31, 0x7b, 0x4e, 0x32, 0x7b, 0x4e, 0x61,
    0x7b, 0x4e, 0x63, 0x7b, 0x4e, 0x65, 0x7b, 0x4e, 0x69, 0x7b, 0x4e, 0x6f,
    0x7b, 0x4e, 0x73, 0x7b, 0x4e, 0x74, 0x7b, 0x4e, 0x20, 0x7b, 0x4e, 0x25,
    0x7b, 0x4e, 0x2d, 0x7b, 0x4e, 0x2e, 0x7b, 0x4e, 0x2f, 0x7b, 0x4e, 0x33,
    0x7b, 0x4e, 0x34, 0x7b, 0x4e, 0x35, 0x7b, 0x4e, 0x36, 0x7b, 0x4e, 0x37,
    0x7b, 0x4e, 0x38, 0x7b, 0x4e, 0x39, 0x7b, 0x4e, 0x3d, 0x7b, 0x4e, 0x41,
    0x7b, 0x4e, 0x5f, 0x7b, 0x4e, 0x62, 0x7b, 0x4e, 0x64, 0x7b, 0x4e, 0x66,
    0x7b, 0x4e, 0x67, 0x7b, 0x4e, 0x68, 0x7b, 0x4e, 0x6c, 0x7b, 0x4e, 0x6d,
    0x7b, 0x4e, 0x6e, 0x7b, 0x4e, 0x70, 0x7b, 0x4e, 0x72, 0x7b, 0x4e, 0x75};
const uint8_t HuffDecoderCommon::table29_53_emit_[216] = {
    0x7b, 0x4f, 0x30, 0x7b, 0x4f, 0x31, 0x7b, 0x4f, 0x32, 0x7b, 0x4f, 0x61,
    0x7b, 0x4f, 0x63, 0x7b, 0x4f, 0x65, 0x7b, 0x4f, 0x69, 0x7b, 0x4f, 0x6f,
    0x7b, 0x4f, 0x73, 0x7b, 0x4f, 0x74, 0x7b, 0x4f, 0x20, 0x7b, 0x4f, 0x25,
    0x7b, 0x4f, 0x2d, 0x7b, 0x4f, 0x2e, 0x7b, 0x4f, 0x2f, 0x7b, 0x4f, 0x33,
    0x7b, 0x4f, 0x34, 0x7b, 0x4f, 0x35, 0x7b, 0x4f, 0x36, 0x7b, 0x4f, 0x37,
    0x7b, 0x4f, 0x38, 0x7b, 0x4f, 0x39, 0x7b, 0x4f, 0x3d, 0x7b, 0x4f, 0x41,
    0x7b, 0x4f, 0x5f, 0x7b, 0x4f, 0x62, 0x7b, 0x4f, 0x64, 0x7b, 0x4f, 0x66,
    0x7b, 0x4f, 0x67, 0x7b, 0x4f, 0x68, 0x7b, 0x4f, 0x6c, 0x7b, 0x4f, 0x6d,
    0x7b, 0x4f, 0x6e, 0x7b, 0x4f, 0x70, 0x7b, 0x4f, 0x72, 0x7b, 0x4f, 0x75,
    0x7b, 0x50, 0x30, 0x7b, 0x50, 0x31, 0x7b, 0x50, 0x32, 0x7b, 0x50, 0x61,
    0x7b, 0x50, 0x63, 0x7b, 0x50, 0x65, 0x7b, 0x50, 0x69, 0x7b, 0x50, 0x6f,
    0x7b, 0x50, 0x73, 0x7b, 0x50, 0x74, 0x7b, 0x50, 0x20, 0x7b, 0x50, 0x25,
    0x7b, 0x50, 0x2d, 0x7b, 0x50, 0x2e, 0x7b, 0x50, 0x2f, 0x7b, 0x50, 0x33,
    0x7b, 0x50, 0x34, 0x7b, 0x50, 0x35, 0x7b, 0x50, 0x36, 0x7b, 0x50, 0x37,
    0x7b, 0x50, 0x38, 0x7b, 0x50, 0x39, 0x7b, 0x50, 0x3d, 0x7b, 0x50, 0x41,
    0x7b, 0x50, 0x5f, 0x7b, 0x50, 0x62, 0x7b, 0x50, 0x64, 0x7b, 0x50, 0x66,
    0x7b, 0x50, 0x67, 0x7b, 0x50, 0x68, 0x7b, 0x50, 0x6c, 0x7b, 0x50, 0x6d,
    0x7b, 0x50, 0x6e, 0x7b, 0x50, 0x70, 0x7b, 0x50, 0x72, 0x7b, 0x50, 0x75};
const uint8_t HuffDecoderCommon::table29_54_emit_[216] = {
    0x7b, 0x51, 0x30, 0x7b, 0x51, 0x31, 0x7b, 0x51, 0x32, 0x7b, 0x51, 0x61,
    0x7b, 0x51, 0x63, 0x7b, 0x51, 0x65, 0x7b, 0x51, 0x69, 0x7b, 0x51, 0x6f,
    0x7b, 0x51, 0x73, 0x7b, 0x51, 0x74, 0x7b, 0x51, 0x20, 0x7b, 0x51, 0x25,
    0x7b, 0x51, 0x2d, 0x7b, 0x51, 0x2e, 0x7b, 0x51, 0x2f, 0x7b, 0x51, 0x33,
    0x7b, 0x51, 0x34, 0x7b, 0x51, 0x35, 0x7b, 0x51, 0x36, 0x7b, 0x51, 0x37,
    0x7b, 0x51, 0x38, 0x7b, 0x51, 0x39, 0x7b, 0x51, 0x3d, 0x7b, 0x51, 0x41,
    0x7b, 0x51, 0x5f, 0x7b, 0x51, 0x62, 0x7b, 0x51, 0x64, 0x7b, 0x51, 0x66,
    0x7b, 0x51, 0x67, 0x7b, 0x51, 0x68, 0x7b, 0x51, 0x6c, 0x7b, 0x51, 0x6d,
    0x7b, 0x51, 0x6e, 0x7b, 0x51, 0x70, 0x7b, 0x51, 0x72, 0x7b, 0x51, 0x75,
    0x7b, 0x52, 0x30, 0x7b, 0x52, 0x31, 0x7b, 0x52, 0x32, 0x7b, 0x52, 0x61,
    0x7b, 0x52, 0x63, 0x7b, 0x52, 0x65, 0x7b, 0x52, 0x69, 0x7b, 0x52, 0x6f,
    0x7b, 0x52, 0x73, 0x7b, 0x52, 0x74, 0x7b, 0x52, 0x20, 0x7b, 0x52, 0x25,
    0x7b, 0x52, 0x2d, 0x7b, 0x52, 0x2e, 0x7b, 0x52, 0x2f, 0x7b, 0x52, 0x33,
    0x7b, 0x52, 0x34, 0x7b, 0x52, 0x35, 0x7b, 0x52, 0x36, 0x7b, 0x52, 0x37,
    0x7b, 0x52, 0x38, 0x7b, 0x52, 0x39, 0x7b, 0x52, 0x3d, 0x7b, 0x52, 0x41,
    0x7b, 0x52, 0x5f, 0x7b, 0x52, 0x62, 0x7b, 0x52, 0x64, 0x7b, 0x52, 0x66,
    0x7b, 0x52, 0x67, 0x7b, 0x52, 0x68, 0x7b, 0x52, 0x6c, 0x7b, 0x52, 0x6d,
    0x7b, 0x52, 0x6e, 0x7b, 0x52, 0x70, 0x7b, 0x52, 0x72, 0x7b, 0x52, 0x75};
const uint8_t HuffDecoderCommon::table29_55_emit_[216] = {
    0x7b, 0x53, 0x30, 0x7b, 0x53, 0x31, 0x7b, 0x53, 0x32, 0x7b, 0x53, 0x61,
    0x7b, 0x53, 0x63, 0x7b, 0x53, 0x65, 0x7b, 0x53, 0x69, 0x7b, 0x53, 0x6f,
    0x7b, 0x53, 0x73, 0x7b, 0x53, 0x74, 0x7b, 0x53, 0x20, 0x7b, 0x53, 0x25,
    0x7b, 0x53, 0x2d, 0x7b, 0x53, 0x2e, 0x7b, 0x53, 0x2f, 0x7b, 0x53, 0x33,
    0x7b, 0x53, 0x34, 0x7b, 0x53, 0x35, 0x7b, 0x53, 0x36, 0x7b, 0x53, 0x37,
    0x7b, 0x53, 0x38, 0x7b, 0x53, 0x39, 0x7b, 0x53, 0x3d, 0x7b, 0x53, 0x41,
    0x7b, 0x53, 0x5f, 0x7b, 0x53, 0x62, 0x7b, 0x53, 0x64, 0x7b, 0x53, 0x66,
    0x7b, 0x53, 0x67, 0x7b, 0x53, 0x68, 0x7b, 0x53, 0x6c, 0x7b, 0x53, 0x6d,
    0x7b, 0x53, 0x6e, 0x7b, 0x53, 0x70, 0x7b, 0x53, 0x72, 0x7b, 0x53, 0x75,
    0x7b, 0x54, 0x30, 0x7b, 0x54, 0x31, 0x7b, 0x54, 0x32, 0x7b, 0x54, 0x61,
    0x7b, 0x54, 0x63, 0x7b, 0x54, 0x65, 0x7b, 0x54, 0x69, 0x7b, 0x54, 0x6f,
    0x7b, 0x54, 0x73, 0x7b, 0x54, 0x74, 0x7b, 0x54, 0x20, 0x7b, 0x54, 0x25,
    0x7b, 0x54, 0x2d, 0x7b, 0x54, 0x2e, 0x7b, 0x54, 0x2f, 0x7b, 0x54, 0x33,
    0x7b, 0x54, 0x34, 0x7b, 0x54, 0x35, 0x7b, 0x54, 0x36, 0x7b, 0x54, 0x37,
    0x7b, 0x54, 0x38, 0x7b, 0x54, 0x39, 0x7b, 0x54, 0x3d, 0x7b, 0x54, 0x41,
    0x7b, 0x54, 0x5f, 0x7b, 0x54, 0x62, 0x7b, 0x54, 0x64, 0x7b, 0x54, 0x66,
    0x7b, 0x54, 0x67, 0x7b, 0x54, 0x68, 0x7b, 0x54, 0x6c, 0x7b, 0x54, 0x6d,
    0x7b, 0x54, 0x6e, 0x7b, 0x54, 0x70, 0x7b, 0x54, 0x72, 0x7b, 0x54, 0x75};
const uint8_t HuffDecoderCommon::table29_56_emit_[216] = {
    0x7b, 0x55, 0x30, 0x7b, 0x55, 0x31, 0x7b, 0x55, 0x32, 0x7b, 0x55, 0x61,
    0x7b, 0x55, 0x63, 0x7b, 0x55, 0x65, 0x7b, 0x55, 0x69, 0x7b, 0x55, 0x6f,
    0x7b, 0x55, 0x73, 0x7b, 0x55, 0x74, 0x7b, 0x55, 0x20, 0x7b, 0x55, 0x25,
    0x7b, 0x55, 0x2d, 0x7b, 0x55, 0x2e, 0x7b, 0x55, 0x2f, 0x7b, 0x55, 0x33,
    0x7b, 0x55, 0x34, 0x7b, 0x55, 0x35, 0x7b, 0x55, 0x36, 0x7b, 0x55, 0x37,
    0x7b, 0x55, 0x38, 0x7b, 0x55, 0x39, 0x7b, 0x55, 0x3d, 0x7b, 0x55, 0x41,
    0x7b, 0x55, 0x5f, 0x7b, 0x55, 0x62, 0x7b, 0x55, 0x64, 0x7b, 0x55, 0x66,
    0x7b, 0x55, 0x67, 0x7b, 0x55, 0x68, 0x7b, 0x55, 0x6c, 0x7b, 0x55, 0x6d,
    0x7b, 0x55, 0x6e, 0x7b, 0x55, 0x70, 0x7b, 0x55, 0x72, 0x7b, 0x55, 0x75,
    0x7b, 0x56, 0x30, 0x7b, 0x56, 0x31, 0x7b, 0x56, 0x32, 0x7b, 0x56, 0x61,
    0x7b, 0x56, 0x63, 0x7b, 0x56, 0x65, 0x7b, 0x56, 0x69, 0x7b, 0x56, 0x6f,
    0x7b, 0x56, 0x73, 0x7b, 0x56, 0x74, 0x7b, 0x56, 0x20, 0x7b, 0x56, 0x25,
    0x7b, 0x56, 0x2d, 0x7b, 0x56, 0x2e, 0x7b, 0x56, 0x2f, 0x7b, 0x56, 0x33,
    0x7b, 0x56, 0x34, 0x7b, 0x56, 0x35, 0x7b, 0x56, 0x36, 0x7b, 0x56, 0x37,
    0x7b, 0x56, 0x38, 0x7b, 0x56, 0x39, 0x7b, 0x56, 0x3d, 0x7b, 0x56, 0x41,
    0x7b, 0x56, 0x5f, 0x7b, 0x56, 0x62, 0x7b, 0x56, 0x64, 0x7b, 0x56, 0x66,
    0x7b, 0x56, 0x67, 0x7b, 0x56, 0x68, 0x7b, 0x56, 0x6c, 0x7b, 0x56, 0x6d,
    0x7b, 0x56, 0x6e, 0x7b, 0x56, 0x70, 0x7b, 0x56, 0x72, 0x7b, 0x56, 0x75};
const uint8_t HuffDecoderCommon::table29_57_emit_[216] = {
    0x7b, 0x57, 0x30, 0x7b, 0x57, 0x31, 0x7b, 0x57, 0x32, 0x7b, 0x57, 0x61,
    0x7b, 0x57, 0x63, 0x7b, 0x57, 0x65, 0x7b, 0x57, 0x69, 0x7b, 0x57, 0x6f,
    0x7b, 0x57, 0x73, 0x7b, 0x57, 0x74, 0x7b, 0x57, 0x20, 0x7b, 0x57, 0x25,
    0x7b, 0x57, 0x2d, 0x7b, 0x57, 0x2e, 0x7b, 0x57, 0x2f, 0x7b, 0x57, 0x33,
    0x7b, 0x57, 0x34, 0x7b, 0x57, 0x35, 0x7b, 0x57, 0x36, 0x7b, 0x57, 0x37,
    0x7b, 0x57, 0x38, 0x7b, 0x57, 0x39, 0x7b, 0x57, 0x3d, 0x7b, 0x57, 0x41,
    0x7b, 0x57, 0x5f, 0x7b, 0x57, 0x62, 0x7b, 0x57, 0x64, 0x7b, 0x57, 0x66,
    0x7b, 0x57, 0x67, 0x7b, 0x57, 0x68, 0x7b, 0x57, 0x6c, 0x7b, 0x57, 0x6d,
    0x7b, 0x57, 0x6e, 0x7b, 0x57, 0x70, 0x7b, 0x57, 0x72, 0x7b, 0x57, 0x75,
    0x7b, 0x59, 0x30, 0x7b, 0x59, 0x31, 0x7b, 0x59, 0x32, 0x7b, 0x59, 0x61,
    0x7b, 0x59, 0x63, 0x7b, 0x59, 0x65, 0x7b, 0x59, 0x69, 0x7b, 0x59, 0x6f,
    0x7b, 0x59, 0x73, 0x7b, 0x59, 0x74, 0x7b, 0x59, 0x20, 0x7b, 0x59, 0x25,
    0x7b, 0x59, 0x2d, 0x7b, 0x59, 0x2e, 0x7b, 0x59, 0x2f, 0x7b, 0x59, 0x33,
    0x7b, 0x59, 0x34, 0x7b, 0x59, 0x35, 0x7b, 0x59, 0x36, 0x7b, 0x59, 0x37,
    0x7b, 0x59, 0x38, 0x7b, 0x59, 0x39, 0x7b, 0x59, 0x3d, 0x7b, 0x59, 0x41,
    0x7b, 0x59, 0x5f, 0x7b, 0x59, 0x62, 0x7b, 0x59, 0x64, 0x7b, 0x59, 0x66,
    0x7b, 0x59, 0x67, 0x7b, 0x59, 0x68, 0x7b, 0x59, 0x6c, 0x7b, 0x59, 0x6d,
    0x7b, 0x59, 0x6e, 0x7b, 0x59, 0x70, 0x7b, 0x59, 0x72, 0x7b, 0x59, 0x75};
const uint8_t HuffDecoderCommon::table29_58_emit_[216] = {
    0x7b, 0x6a, 0x30, 0x7b, 0x6a, 0x31, 0x7b, 0x6a, 0x32, 0x7b, 0x6a, 0x61,
    0x7b, 0x6a, 0x63, 0x7b, 0x6a, 0x65, 0x7b, 0x6a, 0x69, 0x7b, 0x6a, 0x6f,
    0x7b, 0x6a, 0x73, 0x7b, 0x6a, 0x74, 0x7b, 0x6a, 0x20, 0x7b, 0x6a, 0x25,
    0x7b, 0x6a, 0x2d, 0x7b, 0x6a, 0x2e, 0x7b, 0x6a, 0x2f, 0x7b, 0x6a, 0x33,
    0x7b, 0x6a, 0x34, 0x7b, 0x6a, 0x35, 0x7b, 0x6a, 0x36, 0x7b, 0x6a, 0x37,
    0x7b, 0x6a, 0x38, 0x7b, 0x6a, 0x39, 0x7b, 0x6a, 0x3d, 0x7b, 0x6a, 0x41,
    0x7b, 0x6a, 0x5f, 0x7b, 0x6a, 0x62, 0x7b, 0x6a, 0x64, 0x7b, 0x6a, 0x66,
    0x7b, 0x6a, 0x67, 0x7b, 0x6a, 0x68, 0x7b, 0x6a, 0x6c, 0x7b, 0x6a, 0x6d,
    0x7b, 0x6a, 0x6e, 0x7b, 0x6a, 0x70, 0x7b, 0x6a, 0x72, 0x7b, 0x6a, 0x75,
    0x7b, 0x6b, 0x30, 0x7b, 0x6b, 0x31, 0x7b, 0x6b, 0x32, 0x7b, 0x6b, 0x61,
    0x7b, 0x6b, 0x63, 0x7b, 0x6b, 0x65, 0x7b, 0x6b, 0x69, 0x7b, 0x6b, 0x6f,
    0x7b, 0x6b, 0x73, 0x7b, 0x6b, 0x74, 0x7b, 0x6b, 0x20, 0x7b, 0x6b, 0x25,
    0x7b, 0x6b, 0x2d, 0x7b, 0x6b, 0x2e, 0x7b, 0x6b, 0x2f, 0x7b, 0x6b, 0x33,
    0x7b, 0x6b, 0x34, 0x7b, 0x6b, 0x35, 0x7b, 0x6b, 0x36, 0x7b, 0x6b, 0x37,
    0x7b, 0x6b, 0x38, 0x7b, 0x6b, 0x39, 0x7b, 0x6b, 0x3d, 0x7b, 0x6b, 0x41,
    0x7b, 0x6b, 0x5f, 0x7b, 0x6b, 0x62, 0x7b, 0x6b, 0x64, 0x7b, 0x6b, 0x66,
    0x7b, 0x6b, 0x67, 0x7b, 0x6b, 0x68, 0x7b, 0x6b, 0x6c, 0x7b, 0x6b, 0x6d,
    0x7b, 0x6b, 0x6e, 0x7b, 0x6b, 0x70, 0x7b, 0x6b, 0x72, 0x7b, 0x6b, 0x75};
const uint8_t HuffDecoderCommon::table29_59_emit_[216] = {
    0x7b, 0x71, 0x30, 0x7b, 0x71, 0x31, 0x7b, 0x71, 0x32, 0x7b, 0x71, 0x61,
    0x7b, 0x71, 0x63, 0x7b, 0x71, 0x65, 0x7b, 0x71, 0x69, 0x7b, 0x71, 0x6f,
    0x7b, 0x71, 0x73, 0x7b, 0x71, 0x74, 0x7b, 0x71, 0x20, 0x7b, 0x71, 0x25,
    0x7b, 0x71, 0x2d, 0x7b, 0x71, 0x2e, 0x7b, 0x71, 0x2f, 0x7b, 0x71, 0x33,
    0x7b, 0x71, 0x34, 0x7b, 0x71, 0x35, 0x7b, 0x71, 0x36, 0x7b, 0x71, 0x37,
    0x7b, 0x71, 0x38, 0x7b, 0x71, 0x39, 0x7b, 0x71, 0x3d, 0x7b, 0x71, 0x41,
    0x7b, 0x71, 0x5f, 0x7b, 0x71, 0x62, 0x7b, 0x71, 0x64, 0x7b, 0x71, 0x66,
    0x7b, 0x71, 0x67, 0x7b, 0x71, 0x68, 0x7b, 0x71, 0x6c, 0x7b, 0x71, 0x6d,
    0x7b, 0x71, 0x6e, 0x7b, 0x71, 0x70, 0x7b, 0x71, 0x72, 0x7b, 0x71, 0x75,
    0x7b, 0x76, 0x30, 0x7b, 0x76, 0x31, 0x7b, 0x76, 0x32, 0x7b, 0x76, 0x61,
    0x7b, 0x76, 0x63, 0x7b, 0x76, 0x65, 0x7b, 0x76, 0x69, 0x7b, 0x76, 0x6f,
    0x7b, 0x76, 0x73, 0x7b, 0x76, 0x74, 0x7b, 0x76, 0x20, 0x7b, 0x76, 0x25,
    0x7b, 0x76, 0x2d, 0x7b, 0x76, 0x2e, 0x7b, 0x76, 0x2f, 0x7b, 0x76, 0x33,
    0x7b, 0x76, 0x34, 0x7b, 0x76, 0x35, 0x7b, 0x76, 0x36, 0x7b, 0x76, 0x37,
    0x7b, 0x76, 0x38, 0x7b, 0x76, 0x39, 0x7b, 0x76, 0x3d, 0x7b, 0x76, 0x41,
    0x7b, 0x76, 0x5f, 0x7b, 0x76, 0x62, 0x7b, 0x76, 0x64, 0x7b, 0x76, 0x66,
    0x7b, 0x76, 0x67, 0x7b, 0x76, 0x68, 0x7b, 0x76, 0x6c, 0x7b, 0x76, 0x6d,
    0x7b, 0x76, 0x6e, 0x7b, 0x76, 0x70, 0x7b, 0x76, 0x72, 0x7b, 0x76, 0x75};
const uint8_t HuffDecoderCommon::table29_60_emit_[216] = {
    0x7b, 0x77, 0x30, 0x7b, 0x77, 0x31, 0x7b, 0x77, 0x32, 0x7b, 0x77, 0x61,
    0x7b, 0x77, 0x63, 0x7b, 0x77, 0x65, 0x7b, 0x77, 0x69, 0x7b, 0x77, 0x6f,
    0x7b, 0x77, 0x73, 0x7b, 0x77, 0x74, 0x7b, 0x77, 0x20, 0x7b, 0x77, 0x25,
    0x7b, 0x77, 0x2d, 0x7b, 0x77, 0x2e, 0x7b, 0x77, 0x2f, 0x7b, 0x77, 0x33,
    0x7b, 0x77, 0x34, 0x7b, 0x77, 0x35, 0x7b, 0x77, 0x36, 0x7b, 0x77, 0x37,
    0x7b, 0x77, 0x38, 0x7b, 0x77, 0x39, 0x7b, 0x77, 0x3d, 0x7b, 0x77, 0x41,
    0x7b, 0x77, 0x5f, 0x7b, 0x77, 0x62, 0x7b, 0x77, 0x64, 0x7b, 0x77, 0x66,
    0x7b, 0x77, 0x67, 0x7b, 0x77, 0x68, 0x7b, 0x77, 0x6c, 0x7b, 0x77, 0x6d,
    0x7b, 0x77, 0x6e, 0x7b, 0x77, 0x70, 0x7b, 0x77, 0x72, 0x7b, 0x77, 0x75,
    0x7b, 0x78, 0x30, 0x7b, 0x78, 0x31, 0x7b, 0x78, 0x32, 0x7b, 0x78, 0x61,
    0x7b, 0x78, 0x63, 0x7b, 0x78, 0x65, 0x7b, 0x78, 0x69, 0x7b, 0x78, 0x6f,
    0x7b, 0x78, 0x73, 0x7b, 0x78, 0x74, 0x7b, 0x78, 0x20, 0x7b, 0x78, 0x25,
    0x7b, 0x78, 0x2d, 0x7b, 0x78, 0x2e, 0x7b, 0x78, 0x2f, 0x7b, 0x78, 0x33,
    0x7b, 0x78, 0x34, 0x7b, 0x78, 0x35, 0x7b, 0x78, 0x36, 0x7b, 0x78, 0x37,
    0x7b, 0x78, 0x38, 0x7b, 0x78, 0x39, 0x7b, 0x78, 0x3d, 0x7b, 0x78, 0x41,
    0x7b, 0x78, 0x5f, 0x7b, 0x78, 0x62, 0x7b, 0x78, 0x64, 0x7b, 0x78, 0x66,
    0x7b, 0x78, 0x67, 0x7b, 0x78, 0x68, 0x7b, 0x78, 0x6c, 0x7b, 0x78, 0x6d,
    0x7b, 0x78, 0x6e, 0x7b, 0x78, 0x70, 0x7b, 0x78, 0x72, 0x7b, 0x78, 0x75};
const uint8_t HuffDecoderCommon::table29_61_emit_[216] = {
    0x7b, 0x79, 0x30, 0x7b, 0x79, 0x31, 0x7b, 0x79, 0x32, 0x7b, 0x79, 0x61,
    0x7b, 0x79, 0x63, 0x7b, 0x79, 0x65, 0x7b, 0x79, 0x69, 0x7b, 0x79, 0x6f,
    0x7b, 0x79, 0x73, 0x7b, 0x79, 0x74, 0x7b, 0x79, 0x20, 0x7b, 0x79, 0x25,
    0x7b, 0x79, 0x2d, 0x7b, 0x79, 0x2e, 0x7b, 0x79, 0x2f, 0x7b, 0x79, 0x33,
    0x7b, 0x79, 0x34, 0x7b, 0x79, 0x35, 0x7b, 0x79, 0x36, 0x7b, 0x79, 0x37,
    0x7b, 0x79, 0x38, 0x7b, 0x79, 0x39, 0x7b, 0x79, 0x3d, 0x7b, 0x79, 0x41,
    0x7b, 0x79, 0x5f, 0x7b, 0x79, 0x62, 0x7b, 0x79, 0x64, 0x7b, 0x79, 0x66,
    0x7b, 0x79, 0x67, 0x7b, 0x79, 0x68, 0x7b, 0x79, 0x6c, 0x7b, 0x79, 0x6d,
    0x7b, 0x79, 0x6e, 0x7b, 0x79, 0x70, 0x7b, 0x79, 0x72, 0x7b, 0x79, 0x75,
    0x7b, 0x7a, 0x30, 0x7b, 0x7a, 0x31, 0x7b, 0x7a, 0x32, 0x7b, 0x7a, 0x61,
    0x7b, 0x7a, 0x63, 0x7b, 0x7a, 0x65, 0x7b, 0x7a, 0x69, 0x7b, 0x7a, 0x6f,
    0x7b, 0x7a, 0x73, 0x7b, 0x7a, 0x74, 0x7b, 0x7a, 0x20, 0x7b, 0x7a, 0x25,
    0x7b, 0x7a, 0x2d, 0x7b, 0x7a, 0x2e, 0x7b, 0x7a, 0x2f, 0x7b, 0x7a, 0x33,
    0x7b, 0x7a, 0x34, 0x7b, 0x7a, 0x35, 0x7b, 0x7a, 0x36, 0x7b, 0x7a, 0x37,
    0x7b, 0x7a, 0x38, 0x7b, 0x7a, 0x39, 0x7b, 0x7a, 0x3d, 0x7b, 0x7a, 0x41,
    0x7b, 0x7a, 0x5f, 0x7b, 0x7a, 0x62, 0x7b, 0x7a, 0x64, 0x7b, 0x7a, 0x66,
    0x7b, 0x7a, 0x67, 0x7b, 0x7a, 0x68, 0x7b, 0x7a, 0x6c, 0x7b, 0x7a, 0x6d,
    0x7b, 0x7a, 0x6e, 0x7b, 0x7a, 0x70, 0x7b, 0x7a, 0x72, 0x7b, 0x7a, 0x75};
const uint8_t HuffDecoderCommon::table29_62_emit_[120] = {
    0x7b, 0x26, 0x30, 0x7b, 0x26, 0x31, 0x7b, 0x26, 0x32, 0x7b, 0x26, 0x61,
    0x7b, 0x26, 0x63, 0x7b, 0x26, 0x65, 0x7b, 0x26, 0x69, 0x7b, 0x26, 0x6f,
    0x7b, 0x26, 0x73, 0x7b, 0x26, 0x74, 0x7b, 0x2a, 0x30, 0x7b, 0x2a, 0x31,
    0x7b, 0x2a, 0x32, 0x7b, 0x2a, 0x61, 0x7b, 0x2a, 0x63, 0x7b, 0x2a, 0x65,
    0x7b, 0x2a, 0x69, 0x7b, 0x2a, 0x6f, 0x7b, 0x2a, 0x73, 0x7b, 0x2a, 0x74,
    0x7b, 0x2c, 0x30, 0x7b, 0x2c, 0x31, 0x7b, 0x2c, 0x32, 0x7b, 0x2c, 0x61,
    0x7b, 0x2c, 0x63, 0x7b, 0x2c, 0x65, 0x7b, 0x2c, 0x69, 0x7b, 0x2c, 0x6f,
    0x7b, 0x2c, 0x73, 0x7b, 0x2c, 0x74, 0x7b, 0x3b, 0x30, 0x7b, 0x3b, 0x31,
    0x7b, 0x3b, 0x32, 0x7b, 0x3b, 0x61, 0x7b, 0x3b, 0x63, 0x7b, 0x3b, 0x65,
    0x7b, 0x3b, 0x69, 0x7b, 0x3b, 0x6f, 0x7b, 0x3b, 0x73, 0x7b, 0x3b, 0x74};
const uint16_t HuffDecoderCommon::table29_62_inner_[45] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9, 0x00c1,
    0x00d9, 0x0000, 0x0002, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169,
    0x0181, 0x0199, 0x01b1, 0x01c9, 0x00f2, 0x01e1, 0x01f9, 0x0211, 0x0229,
    0x0241, 0x0259, 0x0271, 0x0289, 0x02a1, 0x02b9, 0x01e2, 0x02d1, 0x02e9,
    0x0301, 0x0319, 0x0331, 0x0349, 0x0361, 0x0379, 0x0391, 0x03a9, 0x02d2};
const uint8_t HuffDecoderCommon::table29_62_outer_[128] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 12, 13, 14, 15, 16, 17,
    18, 19, 20, 21, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 44};
const uint8_t HuffDecoderCommon::table29_63_emit_[92] = {
    0x7b, 0x58, 0x30, 0x7b, 0x58, 0x31, 0x7b, 0x58, 0x32, 0x7b, 0x58, 0x61,
    0x7b, 0x58, 0x63, 0x7b, 0x58, 0x65, 0x7b, 0x58, 0x69, 0x7b, 0x58, 0x6f,
    0x7b, 0x58, 0x73, 0x7b, 0x58, 0x74, 0x7b, 0x5a, 0x30, 0x7b, 0x5a, 0x31,
    0x7b, 0x5a, 0x32, 0x7b, 0x5a, 0x61, 0x7b, 0x5a, 0x63, 0x7b, 0x5a, 0x65,
    0x7b, 0x5a, 0x69, 0x7b, 0x5a, 0x6f, 0x7b, 0x5a, 0x73, 0x7b, 0x5a, 0x74,
    0x7b, 0x21, 0x7b, 0x22, 0x7b, 0x28, 0x7b, 0x29, 0x7b, 0x3f, 0x7b, 0x27,
    0x7b, 0x2b, 0x7b, 0x7c, 0x7b, 0x23, 0x7b, 0x3e, 0x7b, 0x00, 0x7b, 0x24,
    0x7b, 0x40, 0x7b, 0x5b, 0x7b, 0x5d, 0x7b, 0x7e};
const uint16_t HuffDecoderCommon::table29_63_inner_[40] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9,
    0x00c1, 0x00d9, 0x0000, 0x0002, 0x00f1, 0x0109, 0x0121, 0x0139,
    0x0151, 0x0169, 0x0181, 0x0199, 0x01b1, 0x01c9, 0x00f2, 0x01e2,
    0x01f2, 0x0202, 0x0212, 0x0222, 0x0232, 0x0242, 0x0252, 0x0262,
    0x0272, 0x0282, 0x0292, 0x02a2, 0x02b2, 0x02c2, 0x02d2, 0x0003};
const uint8_t HuffDecoderCommon::table29_63_outer_[128] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 12, 13, 14, 15, 16, 17,
    18, 19, 20, 21, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 22, 10, 10, 10, 10, 10, 10, 10, 23, 10, 10, 10, 10,
    10, 10, 10, 24, 10, 10, 10, 10, 10, 10, 10, 25, 10, 10, 10, 10, 10, 10, 10,
    26, 10, 10, 10, 10, 10, 10, 10, 27, 10, 10, 10, 28, 10, 10, 10, 29, 10, 10,
    10, 30, 10, 31, 10, 32, 33, 34, 35, 36, 37, 38, 10, 39};
const uint8_t HuffDecoderCommon::table29_64_emit_[16] = {
    0x5c, 0x30, 0x5c, 0x31, 0x5c, 0x32, 0x5c, 0x61,
    0x5c, 0x63, 0x5c, 0x65, 0x5c, 0x69, 0x5c, 0x6f};
const uint16_t HuffDecoderCommon::table29_64_inner_[9] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072};
const uint8_t HuffDecoderCommon::table29_64_outer_[128] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8};
const uint8_t HuffDecoderCommon::table29_65_emit_[28] = {
    0x5c, 0x73, 0x5c, 0x74, 0x5c, 0x20, 0x5c, 0x25, 0x5c, 0x2d,
    0x5c, 0x2e, 0x5c, 0x2f, 0x5c, 0x33, 0x5c, 0x34, 0x5c, 0x35,
    0x5c, 0x36, 0x5c, 0x37, 0x5c, 0x38, 0x5c, 0x39};
const uint16_t HuffDecoderCommon::table29_65_inner_[15] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062,
    0x0072, 0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2};
const uint8_t HuffDecoderCommon::table29_65_outer_[128] = {
    0, 0,  0, 0, 0, 0, 0, 0,  0, 0,  0, 0, 0, 0, 0, 1,  0, 0, 0, 0, 0, 0,
    0, 0,  0, 0, 0, 0, 0, 0,  0, 2,  0, 0, 0, 0, 0, 0,  0, 3, 0, 0, 0, 0,
    0, 0,  0, 4, 0, 0, 0, 0,  0, 0,  0, 5, 0, 0, 0, 0,  0, 0, 0, 6, 0, 0,
    0, 0,  0, 0, 0, 7, 0, 0,  0, 0,  0, 0, 0, 8, 0, 0,  0, 0, 0, 0, 0, 9,
    0, 0,  0, 0, 0, 0, 0, 10, 0, 0,  0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0,
    0, 12, 0, 0, 0, 0, 0, 0,  0, 13, 0, 0, 0, 0, 0, 0,  0, 14};
const uint8_t HuffDecoderCommon::table29_66_emit_[36] = {
    0x5c, 0x3d, 0x5c, 0x41, 0x5c, 0x5f, 0x5c, 0x62, 0x5c, 0x64, 0x5c, 0x66,
    0x5c, 0x67, 0x5c, 0x68, 0x5c, 0x6c, 0x5c, 0x6d, 0x5c, 0x6e, 0x5c, 0x70,
    0x5c, 0x72, 0x5c, 0x75, 0x5c, 0x3a, 0x5c, 0x42, 0x5c, 0x43, 0x5c, 0x44};
const uint16_t HuffDecoderCommon::table29_66_inner_[19] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052,
    0x0062, 0x0072, 0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2,
    0x00d2, 0x00e2, 0x00f2, 0x0102, 0x0112};
const uint8_t HuffDecoderCommon::table29_66_outer_[128] = {
    0, 0,  0, 0, 0, 0,  0, 1,  0, 0,  0, 0, 0, 0,  0, 2,  0, 0, 0, 0, 0, 0,
    0, 3,  0, 0, 0, 0,  0, 0,  0, 4,  0, 0, 0, 0,  0, 0,  0, 5, 0, 0, 0, 0,
    0, 0,  0, 6, 0, 0,  0, 0,  0, 0,  0, 7, 0, 0,  0, 0,  0, 0, 0, 8, 0, 0,
    0, 0,  0, 0, 0, 9,  0, 0,  0, 0,  0, 0, 0, 10, 0, 0,  0, 0, 0, 0, 0, 11,
    0, 0,  0, 0, 0, 0,  0, 12, 0, 0,  0, 0, 0, 0,  0, 13, 0, 0, 0, 0, 0, 0,
    0, 14, 0, 0, 0, 15, 0, 0,  0, 16, 0, 0, 0, 17, 0, 0,  0, 18};
const uint8_t HuffDecoderCommon::table29_67_emit_[68] = {
    0x5c, 0x45, 0x5c, 0x46, 0x5c, 0x47, 0x5c, 0x48, 0x5c, 0x49, 0x5c, 0x4a,
    0x5c, 0x4b, 0x5c, 0x4c, 0x5c, 0x4d, 0x5c, 0x4e, 0x5c, 0x4f, 0x5c, 0x50,
    0x5c, 0x51, 0x5c, 0x52, 0x5c, 0x53, 0x5c, 0x54, 0x5c, 0x55, 0x5c, 0x56,
    0x5c, 0x57, 0x5c, 0x59, 0x5c, 0x6a, 0x5c, 0x6b, 0x5c, 0x71, 0x5c, 0x76,
    0x5c, 0x77, 0x5c, 0x78, 0x5c, 0x79, 0x5c, 0x7a, 0x5c, 0x26, 0x5c, 0x2a,
    0x5c, 0x2c, 0x5c, 0x3b, 0x5c, 0x58, 0x5c, 0x5a};
const uint16_t HuffDecoderCommon::table29_67_inner_[36] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0003};
const uint8_t HuffDecoderCommon::table29_67_outer_[128] = {
    0, 0,  0, 1,  0, 0,  0, 2,  0, 0,  0, 3,  0, 0,  0, 4,  0, 0,  0, 5,  0, 0,
    0, 6,  0, 0,  0, 7,  0, 0,  0, 8,  0, 0,  0, 9,  0, 0,  0, 10, 0, 0,  0, 11,
    0, 0,  0, 12, 0, 0,  0, 13, 0, 0,  0, 14, 0, 0,  0, 15, 0, 0,  0, 16, 0, 0,
    0, 17, 0, 0,  0, 18, 0, 0,  0, 19, 0, 0,  0, 20, 0, 0,  0, 21, 0, 0,  0, 22,
    0, 0,  0, 23, 0, 0,  0, 24, 0, 0,  0, 25, 0, 0,  0, 26, 0, 0,  0, 27, 0, 0,
    0, 28, 0, 29, 0, 30, 0, 31, 0, 32, 0, 33, 0, 34, 0, 0,  0, 35};
const uint8_t HuffDecoderCommon::table29_68_emit_[16] = {
    0xc3, 0x30, 0xc3, 0x31, 0xc3, 0x32, 0xc3, 0x61,
    0xc3, 0x63, 0xc3, 0x65, 0xc3, 0x69, 0xc3, 0x6f};
const uint8_t HuffDecoderCommon::table29_69_emit_[28] = {
    0xc3, 0x73, 0xc3, 0x74, 0xc3, 0x20, 0xc3, 0x25, 0xc3, 0x2d,
    0xc3, 0x2e, 0xc3, 0x2f, 0xc3, 0x33, 0xc3, 0x34, 0xc3, 0x35,
    0xc3, 0x36, 0xc3, 0x37, 0xc3, 0x38, 0xc3, 0x39};
const uint8_t HuffDecoderCommon::table29_70_emit_[36] = {
    0xc3, 0x3d, 0xc3, 0x41, 0xc3, 0x5f, 0xc3, 0x62, 0xc3, 0x64, 0xc3, 0x66,
    0xc3, 0x67, 0xc3, 0x68, 0xc3, 0x6c, 0xc3, 0x6d, 0xc3, 0x6e, 0xc3, 0x70,
    0xc3, 0x72, 0xc3, 0x75, 0xc3, 0x3a, 0xc3, 0x42, 0xc3, 0x43, 0xc3, 0x44};
const uint8_t HuffDecoderCommon::table29_71_emit_[68] = {
    0xc3, 0x45, 0xc3, 0x46, 0xc3, 0x47, 0xc3, 0x48, 0xc3, 0x49, 0xc3, 0x4a,
    0xc3, 0x4b, 0xc3, 0x4c, 0xc3, 0x4d, 0xc3, 0x4e, 0xc3, 0x4f, 0xc3, 0x50,
    0xc3, 0x51, 0xc3, 0x52, 0xc3, 0x53, 0xc3, 0x54, 0xc3, 0x55, 0xc3, 0x56,
    0xc3, 0x57, 0xc3, 0x59, 0xc3, 0x6a, 0xc3, 0x6b, 0xc3, 0x71, 0xc3, 0x76,
    0xc3, 0x77, 0xc3, 0x78, 0xc3, 0x79, 0xc3, 0x7a, 0xc3, 0x26, 0xc3, 0x2a,
    0xc3, 0x2c, 0xc3, 0x3b, 0xc3, 0x58, 0xc3, 0x5a};
const uint8_t HuffDecoderCommon::table29_72_emit_[16] = {
    0xd0, 0x30, 0xd0, 0x31, 0xd0, 0x32, 0xd0, 0x61,
    0xd0, 0x63, 0xd0, 0x65, 0xd0, 0x69, 0xd0, 0x6f};
const uint8_t HuffDecoderCommon::table29_73_emit_[28] = {
    0xd0, 0x73, 0xd0, 0x74, 0xd0, 0x20, 0xd0, 0x25, 0xd0, 0x2d,
    0xd0, 0x2e, 0xd0, 0x2f, 0xd0, 0x33, 0xd0, 0x34, 0xd0, 0x35,
    0xd0, 0x36, 0xd0, 0x37, 0xd0, 0x38, 0xd0, 0x39};
const uint8_t HuffDecoderCommon::table29_74_emit_[36] = {
    0xd0, 0x3d, 0xd0, 0x41, 0xd0, 0x5f, 0xd0, 0x62, 0xd0, 0x64, 0xd0, 0x66,
    0xd0, 0x67, 0xd0, 0x68, 0xd0, 0x6c, 0xd0, 0x6d, 0xd0, 0x6e, 0xd0, 0x70,
    0xd0, 0x72, 0xd0, 0x75, 0xd0, 0x3a, 0xd0, 0x42, 0xd0, 0x43, 0xd0, 0x44};
const uint8_t HuffDecoderCommon::table29_75_emit_[68] = {
    0xd0, 0x45, 0xd0, 0x46, 0xd0, 0x47, 0xd0, 0x48, 0xd0, 0x49, 0xd0, 0x4a,
    0xd0, 0x4b, 0xd0, 0x4c, 0xd0, 0x4d, 0xd0, 0x4e, 0xd0, 0x4f, 0xd0, 0x50,
    0xd0, 0x51, 0xd0, 0x52, 0xd0, 0x53, 0xd0, 0x54, 0xd0, 0x55, 0xd0, 0x56,
    0xd0, 0x57, 0xd0, 0x59, 0xd0, 0x6a, 0xd0, 0x6b, 0xd0, 0x71, 0xd0, 0x76,
    0xd0, 0x77, 0xd0, 0x78, 0xd0, 0x79, 0xd0, 0x7a, 0xd0, 0x26, 0xd0, 0x2a,
    0xd0, 0x2c, 0xd0, 0x3b, 0xd0, 0x58, 0xd0, 0x5a};
const uint8_t HuffDecoderCommon::table29_76_emit_[44] = {
    0x80, 0x30, 0x80, 0x31, 0x80, 0x32, 0x80, 0x61, 0x80, 0x63, 0x80,
    0x65, 0x80, 0x69, 0x80, 0x6f, 0x80, 0x73, 0x80, 0x74, 0x80, 0x20,
    0x80, 0x25, 0x80, 0x2d, 0x80, 0x2e, 0x80, 0x2f, 0x80, 0x33, 0x80,
    0x34, 0x80, 0x35, 0x80, 0x36, 0x80, 0x37, 0x80, 0x38, 0x80, 0x39};
const uint16_t HuffDecoderCommon::table29_76_inner_[23] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062,
    0x0072, 0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2,
    0x00f2, 0x0102, 0x0112, 0x0122, 0x0132, 0x0142, 0x0152};
const uint8_t HuffDecoderCommon::table29_77_emit_[104] = {
    0x80, 0x3d, 0x80, 0x41, 0x80, 0x5f, 0x80, 0x62, 0x80, 0x64, 0x80, 0x66,
    0x80, 0x67, 0x80, 0x68, 0x80, 0x6c, 0x80, 0x6d, 0x80, 0x6e, 0x80, 0x70,
    0x80, 0x72, 0x80, 0x75, 0x80, 0x3a, 0x80, 0x42, 0x80, 0x43, 0x80, 0x44,
    0x80, 0x45, 0x80, 0x46, 0x80, 0x47, 0x80, 0x48, 0x80, 0x49, 0x80, 0x4a,
    0x80, 0x4b, 0x80, 0x4c, 0x80, 0x4d, 0x80, 0x4e, 0x80, 0x4f, 0x80, 0x50,
    0x80, 0x51, 0x80, 0x52, 0x80, 0x53, 0x80, 0x54, 0x80, 0x55, 0x80, 0x56,
    0x80, 0x57, 0x80, 0x59, 0x80, 0x6a, 0x80, 0x6b, 0x80, 0x71, 0x80, 0x76,
    0x80, 0x77, 0x80, 0x78, 0x80, 0x79, 0x80, 0x7a, 0x80, 0x26, 0x80, 0x2a,
    0x80, 0x2c, 0x80, 0x3b, 0x80, 0x58, 0x80, 0x5a};
const uint16_t HuffDecoderCommon::table29_77_inner_[54] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2, 0x02b2,
    0x02c2, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332, 0x0003};
const uint8_t HuffDecoderCommon::table29_78_emit_[44] = {
    0x82, 0x30, 0x82, 0x31, 0x82, 0x32, 0x82, 0x61, 0x82, 0x63, 0x82,
    0x65, 0x82, 0x69, 0x82, 0x6f, 0x82, 0x73, 0x82, 0x74, 0x82, 0x20,
    0x82, 0x25, 0x82, 0x2d, 0x82, 0x2e, 0x82, 0x2f, 0x82, 0x33, 0x82,
    0x34, 0x82, 0x35, 0x82, 0x36, 0x82, 0x37, 0x82, 0x38, 0x82, 0x39};
const uint8_t HuffDecoderCommon::table29_79_emit_[104] = {
    0x82, 0x3d, 0x82, 0x41, 0x82, 0x5f, 0x82, 0x62, 0x82, 0x64, 0x82, 0x66,
    0x82, 0x67, 0x82, 0x68, 0x82, 0x6c, 0x82, 0x6d, 0x82, 0x6e, 0x82, 0x70,
    0x82, 0x72, 0x82, 0x75, 0x82, 0x3a, 0x82, 0x42, 0x82, 0x43, 0x82, 0x44,
    0x82, 0x45, 0x82, 0x46, 0x82, 0x47, 0x82, 0x48, 0x82, 0x49, 0x82, 0x4a,
    0x82, 0x4b, 0x82, 0x4c, 0x82, 0x4d, 0x82, 0x4e, 0x82, 0x4f, 0x82, 0x50,
    0x82, 0x51, 0x82, 0x52, 0x82, 0x53, 0x82, 0x54, 0x82, 0x55, 0x82, 0x56,
    0x82, 0x57, 0x82, 0x59, 0x82, 0x6a, 0x82, 0x6b, 0x82, 0x71, 0x82, 0x76,
    0x82, 0x77, 0x82, 0x78, 0x82, 0x79, 0x82, 0x7a, 0x82, 0x26, 0x82, 0x2a,
    0x82, 0x2c, 0x82, 0x3b, 0x82, 0x58, 0x82, 0x5a};
const uint8_t HuffDecoderCommon::table29_80_emit_[44] = {
    0x83, 0x30, 0x83, 0x31, 0x83, 0x32, 0x83, 0x61, 0x83, 0x63, 0x83,
    0x65, 0x83, 0x69, 0x83, 0x6f, 0x83, 0x73, 0x83, 0x74, 0x83, 0x20,
    0x83, 0x25, 0x83, 0x2d, 0x83, 0x2e, 0x83, 0x2f, 0x83, 0x33, 0x83,
    0x34, 0x83, 0x35, 0x83, 0x36, 0x83, 0x37, 0x83, 0x38, 0x83, 0x39};
const uint8_t HuffDecoderCommon::table29_81_emit_[104] = {
    0x83, 0x3d, 0x83, 0x41, 0x83, 0x5f, 0x83, 0x62, 0x83, 0x64, 0x83, 0x66,
    0x83, 0x67, 0x83, 0x68, 0x83, 0x6c, 0x83, 0x6d, 0x83, 0x6e, 0x83, 0x70,
    0x83, 0x72, 0x83, 0x75, 0x83, 0x3a, 0x83, 0x42, 0x83, 0x43, 0x83, 0x44,
    0x83, 0x45, 0x83, 0x46, 0x83, 0x47, 0x83, 0x48, 0x83, 0x49, 0x83, 0x4a,
    0x83, 0x4b, 0x83, 0x4c, 0x83, 0x4d, 0x83, 0x4e, 0x83, 0x4f, 0x83, 0x50,
    0x83, 0x51, 0x83, 0x52, 0x83, 0x53, 0x83, 0x54, 0x83, 0x55, 0x83, 0x56,
    0x83, 0x57, 0x83, 0x59, 0x83, 0x6a, 0x83, 0x6b, 0x83, 0x71, 0x83, 0x76,
    0x83, 0x77, 0x83, 0x78, 0x83, 0x79, 0x83, 0x7a, 0x83, 0x26, 0x83, 0x2a,
    0x83, 0x2c, 0x83, 0x3b, 0x83, 0x58, 0x83, 0x5a};
const uint8_t HuffDecoderCommon::table29_82_emit_[44] = {
    0xa2, 0x30, 0xa2, 0x31, 0xa2, 0x32, 0xa2, 0x61, 0xa2, 0x63, 0xa2,
    0x65, 0xa2, 0x69, 0xa2, 0x6f, 0xa2, 0x73, 0xa2, 0x74, 0xa2, 0x20,
    0xa2, 0x25, 0xa2, 0x2d, 0xa2, 0x2e, 0xa2, 0x2f, 0xa2, 0x33, 0xa2,
    0x34, 0xa2, 0x35, 0xa2, 0x36, 0xa2, 0x37, 0xa2, 0x38, 0xa2, 0x39};
const uint8_t HuffDecoderCommon::table29_83_emit_[104] = {
    0xa2, 0x3d, 0xa2, 0x41, 0xa2, 0x5f, 0xa2, 0x62, 0xa2, 0x64, 0xa2, 0x66,
    0xa2, 0x67, 0xa2, 0x68, 0xa2, 0x6c, 0xa2, 0x6d, 0xa2, 0x6e, 0xa2, 0x70,
    0xa2, 0x72, 0xa2, 0x75, 0xa2, 0x3a, 0xa2, 0x42, 0xa2, 0x43, 0xa2, 0x44,
    0xa2, 0x45, 0xa2, 0x46, 0xa2, 0x47, 0xa2, 0x48, 0xa2, 0x49, 0xa2, 0x4a,
    0xa2, 0x4b, 0xa2, 0x4c, 0xa2, 0x4d, 0xa2, 0x4e, 0xa2, 0x4f, 0xa2, 0x50,
    0xa2, 0x51, 0xa2, 0x52, 0xa2, 0x53, 0xa2, 0x54, 0xa2, 0x55, 0xa2, 0x56,
    0xa2, 0x57, 0xa2, 0x59, 0xa2, 0x6a, 0xa2, 0x6b, 0xa2, 0x71, 0xa2, 0x76,
    0xa2, 0x77, 0xa2, 0x78, 0xa2, 0x79, 0xa2, 0x7a, 0xa2, 0x26, 0xa2, 0x2a,
    0xa2, 0x2c, 0xa2, 0x3b, 0xa2, 0x58, 0xa2, 0x5a};
const uint8_t HuffDecoderCommon::table29_84_emit_[44] = {
    0xb8, 0x30, 0xb8, 0x31, 0xb8, 0x32, 0xb8, 0x61, 0xb8, 0x63, 0xb8,
    0x65, 0xb8, 0x69, 0xb8, 0x6f, 0xb8, 0x73, 0xb8, 0x74, 0xb8, 0x20,
    0xb8, 0x25, 0xb8, 0x2d, 0xb8, 0x2e, 0xb8, 0x2f, 0xb8, 0x33, 0xb8,
    0x34, 0xb8, 0x35, 0xb8, 0x36, 0xb8, 0x37, 0xb8, 0x38, 0xb8, 0x39};
const uint8_t HuffDecoderCommon::table29_85_emit_[104] = {
    0xb8, 0x3d, 0xb8, 0x41, 0xb8, 0x5f, 0xb8, 0x62, 0xb8, 0x64, 0xb8, 0x66,
    0xb8, 0x67, 0xb8, 0x68, 0xb8, 0x6c, 0xb8, 0x6d, 0xb8, 0x6e, 0xb8, 0x70,
    0xb8, 0x72, 0xb8, 0x75, 0xb8, 0x3a, 0xb8, 0x42, 0xb8, 0x43, 0xb8, 0x44,
    0xb8, 0x45, 0xb8, 0x46, 0xb8, 0x47, 0xb8, 0x48, 0xb8, 0x49, 0xb8, 0x4a,
    0xb8, 0x4b, 0xb8, 0x4c, 0xb8, 0x4d, 0xb8, 0x4e, 0xb8, 0x4f, 0xb8, 0x50,
    0xb8, 0x51, 0xb8, 0x52, 0xb8, 0x53, 0xb8, 0x54, 0xb8, 0x55, 0xb8, 0x56,
    0xb8, 0x57, 0xb8, 0x59, 0xb8, 0x6a, 0xb8, 0x6b, 0xb8, 0x71, 0xb8, 0x76,
    0xb8, 0x77, 0xb8, 0x78, 0xb8, 0x79, 0xb8, 0x7a, 0xb8, 0x26, 0xb8, 0x2a,
    0xb8, 0x2c, 0xb8, 0x3b, 0xb8, 0x58, 0xb8, 0x5a};
const uint8_t HuffDecoderCommon::table29_86_emit_[44] = {
    0xc2, 0x30, 0xc2, 0x31, 0xc2, 0x32, 0xc2, 0x61, 0xc2, 0x63, 0xc2,
    0x65, 0xc2, 0x69, 0xc2, 0x6f, 0xc2, 0x73, 0xc2, 0x74, 0xc2, 0x20,
    0xc2, 0x25, 0xc2, 0x2d, 0xc2, 0x2e, 0xc2, 0x2f, 0xc2, 0x33, 0xc2,
    0x34, 0xc2, 0x35, 0xc2, 0x36, 0xc2, 0x37, 0xc2, 0x38, 0xc2, 0x39};
const uint8_t HuffDecoderCommon::table29_87_emit_[104] = {
    0xc2, 0x3d, 0xc2, 0x41, 0xc2, 0x5f, 0xc2, 0x62, 0xc2, 0x64, 0xc2, 0x66,
    0xc2, 0x67, 0xc2, 0x68, 0xc2, 0x6c, 0xc2, 0x6d, 0xc2, 0x6e, 0xc2, 0x70,
    0xc2, 0x72, 0xc2, 0x75, 0xc2, 0x3a, 0xc2, 0x42, 0xc2, 0x43, 0xc2, 0x44,
    0xc2, 0x45, 0xc2, 0x46, 0xc2, 0x47, 0xc2, 0x48, 0xc2, 0x49, 0xc2, 0x4a,
    0xc2, 0x4b, 0xc2, 0x4c, 0xc2, 0x4d, 0xc2, 0x4e, 0xc2, 0x4f, 0xc2, 0x50,
    0xc2, 0x51, 0xc2, 0x52, 0xc2, 0x53, 0xc2, 0x54, 0xc2, 0x55, 0xc2, 0x56,
    0xc2, 0x57, 0xc2, 0x59, 0xc2, 0x6a, 0xc2, 0x6b, 0xc2, 0x71, 0xc2, 0x76,
    0xc2, 0x77, 0xc2, 0x78, 0xc2, 0x79, 0xc2, 0x7a, 0xc2, 0x26, 0xc2, 0x2a,
    0xc2, 0x2c, 0xc2, 0x3b, 0xc2, 0x58, 0xc2, 0x5a};
const uint8_t HuffDecoderCommon::table29_88_emit_[44] = {
    0xe0, 0x30, 0xe0, 0x31, 0xe0, 0x32, 0xe0, 0x61, 0xe0, 0x63, 0xe0,
    0x65, 0xe0, 0x69, 0xe0, 0x6f, 0xe0, 0x73, 0xe0, 0x74, 0xe0, 0x20,
    0xe0, 0x25, 0xe0, 0x2d, 0xe0, 0x2e, 0xe0, 0x2f, 0xe0, 0x33, 0xe0,
    0x34, 0xe0, 0x35, 0xe0, 0x36, 0xe0, 0x37, 0xe0, 0x38, 0xe0, 0x39};
const uint8_t HuffDecoderCommon::table29_89_emit_[104] = {
    0xe0, 0x3d, 0xe0, 0x41, 0xe0, 0x5f, 0xe0, 0x62, 0xe0, 0x64, 0xe0, 0x66,
    0xe0, 0x67, 0xe0, 0x68, 0xe0, 0x6c, 0xe0, 0x6d, 0xe0, 0x6e, 0xe0, 0x70,
    0xe0, 0x72, 0xe0, 0x75, 0xe0, 0x3a, 0xe0, 0x42, 0xe0, 0x43, 0xe0, 0x44,
    0xe0, 0x45, 0xe0, 0x46, 0xe0, 0x47, 0xe0, 0x48, 0xe0, 0x49, 0xe0, 0x4a,
    0xe0, 0x4b, 0xe0, 0x4c, 0xe0, 0x4d, 0xe0, 0x4e, 0xe0, 0x4f, 0xe0, 0x50,
    0xe0, 0x51, 0xe0, 0x52, 0xe0, 0x53, 0xe0, 0x54, 0xe0, 0x55, 0xe0, 0x56,
    0xe0, 0x57, 0xe0, 0x59, 0xe0, 0x6a, 0xe0, 0x6b, 0xe0, 0x71, 0xe0, 0x76,
    0xe0, 0x77, 0xe0, 0x78, 0xe0, 0x79, 0xe0, 0x7a, 0xe0, 0x26, 0xe0, 0x2a,
    0xe0, 0x2c, 0xe0, 0x3b, 0xe0, 0x58, 0xe0, 0x5a};
const uint8_t HuffDecoderCommon::table29_90_emit_[44] = {
    0xe2, 0x30, 0xe2, 0x31, 0xe2, 0x32, 0xe2, 0x61, 0xe2, 0x63, 0xe2,
    0x65, 0xe2, 0x69, 0xe2, 0x6f, 0xe2, 0x73, 0xe2, 0x74, 0xe2, 0x20,
    0xe2, 0x25, 0xe2, 0x2d, 0xe2, 0x2e, 0xe2, 0x2f, 0xe2, 0x33, 0xe2,
    0x34, 0xe2, 0x35, 0xe2, 0x36, 0xe2, 0x37, 0xe2, 0x38, 0xe2, 0x39};
const uint8_t HuffDecoderCommon::table29_91_emit_[104] = {
    0xe2, 0x3d, 0xe2, 0x41, 0xe2, 0x5f, 0xe2, 0x62, 0xe2, 0x64, 0xe2, 0x66,
    0xe2, 0x67, 0xe2, 0x68, 0xe2, 0x6c, 0xe2, 0x6d, 0xe2, 0x6e, 0xe2, 0x70,
    0xe2, 0x72, 0xe2, 0x75, 0xe2, 0x3a, 0xe2, 0x42, 0xe2, 0x43, 0xe2, 0x44,
    0xe2, 0x45, 0xe2, 0x46, 0xe2, 0x47, 0xe2, 0x48, 0xe2, 0x49, 0xe2, 0x4a,
    0xe2, 0x4b, 0xe2, 0x4c, 0xe2, 0x4d, 0xe2, 0x4e, 0xe2, 0x4f, 0xe2, 0x50,
    0xe2, 0x51, 0xe2, 0x52, 0xe2, 0x53, 0xe2, 0x54, 0xe2, 0x55, 0xe2, 0x56,
    0xe2, 0x57, 0xe2, 0x59, 0xe2, 0x6a, 0xe2, 0x6b, 0xe2, 0x71, 0xe2, 0x76,
    0xe2, 0x77, 0xe2, 0x78, 0xe2, 0x79, 0xe2, 0x7a, 0xe2, 0x26, 0xe2, 0x2a,
    0xe2, 0x2c, 0xe2, 0x3b, 0xe2, 0x58, 0xe2, 0x5a};
const uint8_t HuffDecoderCommon::table29_92_emit_[136] = {
    0x99, 0x30, 0x99, 0x31, 0x99, 0x32, 0x99, 0x61, 0x99, 0x63, 0x99, 0x65,
    0x99, 0x69, 0x99, 0x6f, 0x99, 0x73, 0x99, 0x74, 0x99, 0x20, 0x99, 0x25,
    0x99, 0x2d, 0x99, 0x2e, 0x99, 0x2f, 0x99, 0x33, 0x99, 0x34, 0x99, 0x35,
    0x99, 0x36, 0x99, 0x37, 0x99, 0x38, 0x99, 0x39, 0x99, 0x3d, 0x99, 0x41,
    0x99, 0x5f, 0x99, 0x62, 0x99, 0x64, 0x99, 0x66, 0x99, 0x67, 0x99, 0x68,
    0x99, 0x6c, 0x99, 0x6d, 0x99, 0x6e, 0x99, 0x70, 0x99, 0x72, 0x99, 0x75,
    0x99, 0x3a, 0x99, 0x42, 0x99, 0x43, 0x99, 0x44, 0x99, 0x45, 0x99, 0x46,
    0x99, 0x47, 0x99, 0x48, 0x99, 0x49, 0x99, 0x4a, 0x99, 0x4b, 0x99, 0x4c,
    0x99, 0x4d, 0x99, 0x4e, 0x99, 0x4f, 0x99, 0x50, 0x99, 0x51, 0x99, 0x52,
    0x99, 0x53, 0x99, 0x54, 0x99, 0x55, 0x99, 0x56, 0x99, 0x57, 0x99, 0x59,
    0x99, 0x6a, 0x99, 0x6b, 0x99, 0x71, 0x99, 0x76, 0x99, 0x77, 0x99, 0x78,
    0x99, 0x79, 0x99, 0x7a};
const uint16_t HuffDecoderCommon::table29_92_inner_[70] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2, 0x02b2,
    0x02c2, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332, 0x0342,
    0x0352, 0x0362, 0x0372, 0x0382, 0x0392, 0x03a2, 0x03b2, 0x03c2, 0x03d2,
    0x03e2, 0x03f2, 0x0402, 0x0412, 0x0422, 0x0432, 0x0003};
const uint8_t HuffDecoderCommon::table29_93_emit_[136] = {
    0xa1, 0x30, 0xa1, 0x31, 0xa1, 0x32, 0xa1, 0x61, 0xa1, 0x63, 0xa1, 0x65,
    0xa1, 0x69, 0xa1, 0x6f, 0xa1, 0x73, 0xa1, 0x74, 0xa1, 0x20, 0xa1, 0x25,
    0xa1, 0x2d, 0xa1, 0x2e, 0xa1, 0x2f, 0xa1, 0x33, 0xa1, 0x34, 0xa1, 0x35,
    0xa1, 0x36, 0xa1, 0x37, 0xa1, 0x38, 0xa1, 0x39, 0xa1, 0x3d, 0xa1, 0x41,
    0xa1, 0x5f, 0xa1, 0x62, 0xa1, 0x64, 0xa1, 0x66, 0xa1, 0x67, 0xa1, 0x68,
    0xa1, 0x6c, 0xa1, 0x6d, 0xa1, 0x6e, 0xa1, 0x70, 0xa1, 0x72, 0xa1, 0x75,
    0xa1, 0x3a, 0xa1, 0x42, 0xa1, 0x43, 0xa1, 0x44, 0xa1, 0x45, 0xa1, 0x46,
    0xa1, 0x47, 0xa1, 0x48, 0xa1, 0x49, 0xa1, 0x4a, 0xa1, 0x4b, 0xa1, 0x4c,
    0xa1, 0x4d, 0xa1, 0x4e, 0xa1, 0x4f, 0xa1, 0x50, 0xa1, 0x51, 0xa1, 0x52,
    0xa1, 0x53, 0xa1, 0x54, 0xa1, 0x55, 0xa1, 0x56, 0xa1, 0x57, 0xa1, 0x59,
    0xa1, 0x6a, 0xa1, 0x6b, 0xa1, 0x71, 0xa1, 0x76, 0xa1, 0x77, 0xa1, 0x78,
    0xa1, 0x79, 0xa1, 0x7a};
const uint8_t HuffDecoderCommon::table29_94_emit_[136] = {
    0xa7, 0x30, 0xa7, 0x31, 0xa7, 0x32, 0xa7, 0x61, 0xa7, 0x63, 0xa7, 0x65,
    0xa7, 0x69, 0xa7, 0x6f, 0xa7, 0x73, 0xa7, 0x74, 0xa7, 0x20, 0xa7, 0x25,
    0xa7, 0x2d, 0xa7, 0x2e, 0xa7, 0x2f, 0xa7, 0x33, 0xa7, 0x34, 0xa7, 0x35,
    0xa7, 0x36, 0xa7, 0x37, 0xa7, 0x38, 0xa7, 0x39, 0xa7, 0x3d, 0xa7, 0x41,
    0xa7, 0x5f, 0xa7, 0x62, 0xa7, 0x64, 0xa7, 0x66, 0xa7, 0x67, 0xa7, 0x68,
    0xa7, 0x6c, 0xa7, 0x6d, 0xa7, 0x6e, 0xa7, 0x70, 0xa7, 0x72, 0xa7, 0x75,
    0xa7, 0x3a, 0xa7, 0x42, 0xa7, 0x43, 0xa7, 0x44, 0xa7, 0x45, 0xa7, 0x46,
    0xa7, 0x47, 0xa7, 0x48, 0xa7, 0x49, 0xa7, 0x4a, 0xa7, 0x4b, 0xa7, 0x4c,
    0xa7, 0x4d, 0xa7, 0x4e, 0xa7, 0x4f, 0xa7, 0x50, 0xa7, 0x51, 0xa7, 0x52,
    0xa7, 0x53, 0xa7, 0x54, 0xa7, 0x55, 0xa7, 0x56, 0xa7, 0x57, 0xa7, 0x59,
    0xa7, 0x6a, 0xa7, 0x6b, 0xa7, 0x71, 0xa7, 0x76, 0xa7, 0x77, 0xa7, 0x78,
    0xa7, 0x79, 0xa7, 0x7a};
const uint8_t HuffDecoderCommon::table29_95_emit_[136] = {
    0xac, 0x30, 0xac, 0x31, 0xac, 0x32, 0xac, 0x61, 0xac, 0x63, 0xac, 0x65,
    0xac, 0x69, 0xac, 0x6f, 0xac, 0x73, 0xac, 0x74, 0xac, 0x20, 0xac, 0x25,
    0xac, 0x2d, 0xac, 0x2e, 0xac, 0x2f, 0xac, 0x33, 0xac, 0x34, 0xac, 0x35,
    0xac, 0x36, 0xac, 0x37, 0xac, 0x38, 0xac, 0x39, 0xac, 0x3d, 0xac, 0x41,
    0xac, 0x5f, 0xac, 0x62, 0xac, 0x64, 0xac, 0x66, 0xac, 0x67, 0xac, 0x68,
    0xac, 0x6c, 0xac, 0x6d, 0xac, 0x6e, 0xac, 0x70, 0xac, 0x72, 0xac, 0x75,
    0xac, 0x3a, 0xac, 0x42, 0xac, 0x43, 0xac, 0x44, 0xac, 0x45, 0xac, 0x46,
    0xac, 0x47, 0xac, 0x48, 0xac, 0x49, 0xac, 0x4a, 0xac, 0x4b, 0xac, 0x4c,
    0xac, 0x4d, 0xac, 0x4e, 0xac, 0x4f, 0xac, 0x50, 0xac, 0x51, 0xac, 0x52,
    0xac, 0x53, 0xac, 0x54, 0xac, 0x55, 0xac, 0x56, 0xac, 0x57, 0xac, 0x59,
    0xac, 0x6a, 0xac, 0x6b, 0xac, 0x71, 0xac, 0x76, 0xac, 0x77, 0xac, 0x78,
    0xac, 0x79, 0xac, 0x7a};
const uint8_t HuffDecoderCommon::table29_96_emit_[136] = {
    0xb0, 0x30, 0xb0, 0x31, 0xb0, 0x32, 0xb0, 0x61, 0xb0, 0x63, 0xb0, 0x65,
    0xb0, 0x69, 0xb0, 0x6f, 0xb0, 0x73, 0xb0, 0x74, 0xb0, 0x20, 0xb0, 0x25,
    0xb0, 0x2d, 0xb0, 0x2e, 0xb0, 0x2f, 0xb0, 0x33, 0xb0, 0x34, 0xb0, 0x35,
    0xb0, 0x36, 0xb0, 0x37, 0xb0, 0x38, 0xb0, 0x39, 0xb0, 0x3d, 0xb0, 0x41,
    0xb0, 0x5f, 0xb0, 0x62, 0xb0, 0x64, 0xb0, 0x66, 0xb0, 0x67, 0xb0, 0x68,
    0xb0, 0x6c, 0xb0, 0x6d, 0xb0, 0x6e, 0xb0, 0x70, 0xb0, 0x72, 0xb0, 0x75,
    0xb0, 0x3a, 0xb0, 0x42, 0xb0, 0x43, 0xb0, 0x44, 0xb0, 0x45, 0xb0, 0x46,
    0xb0, 0x47, 0xb0, 0x48, 0xb0, 0x49, 0xb0, 0x4a, 0xb0, 0x4b, 0xb0, 0x4c,
    0xb0, 0x4d, 0xb0, 0x4e, 0xb0, 0x4f, 0xb0, 0x50, 0xb0, 0x51, 0xb0, 0x52,
    0xb0, 0x53, 0xb0, 0x54, 0xb0, 0x55, 0xb0, 0x56, 0xb0, 0x57, 0xb0, 0x59,
    0xb0, 0x6a, 0xb0, 0x6b, 0xb0, 0x71, 0xb0, 0x76, 0xb0, 0x77, 0xb0, 0x78,
    0xb0, 0x79, 0xb0, 0x7a};
const uint8_t HuffDecoderCommon::table29_97_emit_[136] = {
    0xb1, 0x30, 0xb1, 0x31, 0xb1, 0x32, 0xb1, 0x61, 0xb1, 0x63, 0xb1, 0x65,
    0xb1, 0x69, 0xb1, 0x6f, 0xb1, 0x73, 0xb1, 0x74, 0xb1, 0x20, 0xb1, 0x25,
    0xb1, 0x2d, 0xb1, 0x2e, 0xb1, 0x2f, 0xb1, 0x33, 0xb1, 0x34, 0xb1, 0x35,
    0xb1, 0x36, 0xb1, 0x37, 0xb1, 0x38, 0xb1, 0x39, 0xb1, 0x3d, 0xb1, 0x41,
    0xb1, 0x5f, 0xb1, 0x62, 0xb1, 0x64, 0xb1, 0x66, 0xb1, 0x67, 0xb1, 0x68,
    0xb1, 0x6c, 0xb1, 0x6d, 0xb1, 0x6e, 0xb1, 0x70, 0xb1, 0x72, 0xb1, 0x75,
    0xb1, 0x3a, 0xb1, 0x42, 0xb1, 0x43, 0xb1, 0x44, 0xb1, 0x45, 0xb1, 0x46,
    0xb1, 0x47, 0xb1, 0x48, 0xb1, 0x49, 0xb1, 0x4a, 0xb1, 0x4b, 0xb1, 0x4c,
    0xb1, 0x4d, 0xb1, 0x4e, 0xb1, 0x4f, 0xb1, 0x50, 0xb1, 0x51, 0xb1, 0x52,
    0xb1, 0x53, 0xb1, 0x54, 0xb1, 0x55, 0xb1, 0x56, 0xb1, 0x57, 0xb1, 0x59,
    0xb1, 0x6a, 0xb1, 0x6b, 0xb1, 0x71, 0xb1, 0x76, 0xb1, 0x77, 0xb1, 0x78,
    0xb1, 0x79, 0xb1, 0x7a};
const uint8_t HuffDecoderCommon::table29_98_emit_[136] = {
    0xb3, 0x30, 0xb3, 0x31, 0xb3, 0x32, 0xb3, 0x61, 0xb3, 0x63, 0xb3, 0x65,
    0xb3, 0x69, 0xb3, 0x6f, 0xb3, 0x73, 0xb3, 0x74, 0xb3, 0x20, 0xb3, 0x25,
    0xb3, 0x2d, 0xb3, 0x2e, 0xb3, 0x2f, 0xb3, 0x33, 0xb3, 0x34, 0xb3, 0x35,
    0xb3, 0x36, 0xb3, 0x37, 0xb3, 0x38, 0xb3, 0x39, 0xb3, 0x3d, 0xb3, 0x41,
    0xb3, 0x5f, 0xb3, 0x62, 0xb3, 0x64, 0xb3, 0x66, 0xb3, 0x67, 0xb3, 0x68,
    0xb3, 0x6c, 0xb3, 0x6d, 0xb3, 0x6e, 0xb3, 0x70, 0xb3, 0x72, 0xb3, 0x75,
    0xb3, 0x3a, 0xb3, 0x42, 0xb3, 0x43, 0xb3, 0x44, 0xb3, 0x45, 0xb3, 0x46,
    0xb3, 0x47, 0xb3, 0x48, 0xb3, 0x49, 0xb3, 0x4a, 0xb3, 0x4b, 0xb3, 0x4c,
    0xb3, 0x4d, 0xb3, 0x4e, 0xb3, 0x4f, 0xb3, 0x50, 0xb3, 0x51, 0xb3, 0x52,
    0xb3, 0x53, 0xb3, 0x54, 0xb3, 0x55, 0xb3, 0x56, 0xb3, 0x57, 0xb3, 0x59,
    0xb3, 0x6a, 0xb3, 0x6b, 0xb3, 0x71, 0xb3, 0x76, 0xb3, 0x77, 0xb3, 0x78,
    0xb3, 0x79, 0xb3, 0x7a};
const uint8_t HuffDecoderCommon::table29_99_emit_[136] = {
    0xd1, 0x30, 0xd1, 0x31, 0xd1, 0x32, 0xd1, 0x61, 0xd1, 0x63, 0xd1, 0x65,
    0xd1, 0x69, 0xd1, 0x6f, 0xd1, 0x73, 0xd1, 0x74, 0xd1, 0x20, 0xd1, 0x25,
    0xd1, 0x2d, 0xd1, 0x2e, 0xd1, 0x2f, 0xd1, 0x33, 0xd1, 0x34, 0xd1, 0x35,
    0xd1, 0x36, 0xd1, 0x37, 0xd1, 0x38, 0xd1, 0x39, 0xd1, 0x3d, 0xd1, 0x41,
    0xd1, 0x5f, 0xd1, 0x62, 0xd1, 0x64, 0xd1, 0x66, 0xd1, 0x67, 0xd1, 0x68,
    0xd1, 0x6c, 0xd1, 0x6d, 0xd1, 0x6e, 0xd1, 0x70, 0xd1, 0x72, 0xd1, 0x75,
    0xd1, 0x3a, 0xd1, 0x42, 0xd1, 0x43, 0xd1, 0x44, 0xd1, 0x45, 0xd1, 0x46,
    0xd1, 0x47, 0xd1, 0x48, 0xd1, 0x49, 0xd1, 0x4a, 0xd1, 0x4b, 0xd1, 0x4c,
    0xd1, 0x4d, 0xd1, 0x4e, 0xd1, 0x4f, 0xd1, 0x50, 0xd1, 0x51, 0xd1, 0x52,
    0xd1, 0x53, 0xd1, 0x54, 0xd1, 0x55, 0xd1, 0x56, 0xd1, 0x57, 0xd1, 0x59,
    0xd1, 0x6a, 0xd1, 0x6b, 0xd1, 0x71, 0xd1, 0x76, 0xd1, 0x77, 0xd1, 0x78,
    0xd1, 0x79, 0xd1, 0x7a};
const uint8_t HuffDecoderCommon::table29_100_emit_[136] = {
    0xd8, 0x30, 0xd8, 0x31, 0xd8, 0x32, 0xd8, 0x61, 0xd8, 0x63, 0xd8, 0x65,
    0xd8, 0x69, 0xd8, 0x6f, 0xd8, 0x73, 0xd8, 0x74, 0xd8, 0x20, 0xd8, 0x25,
    0xd8, 0x2d, 0xd8, 0x2e, 0xd8, 0x2f, 0xd8, 0x33, 0xd8, 0x34, 0xd8, 0x35,
    0xd8, 0x36, 0xd8, 0x37, 0xd8, 0x38, 0xd8, 0x39, 0xd8, 0x3d, 0xd8, 0x41,
    0xd8, 0x5f, 0xd8, 0x62, 0xd8, 0x64, 0xd8, 0x66, 0xd8, 0x67, 0xd8, 0x68,
    0xd8, 0x6c, 0xd8, 0x6d, 0xd8, 0x6e, 0xd8, 0x70, 0xd8, 0x72, 0xd8, 0x75,
    0xd8, 0x3a, 0xd8, 0x42, 0xd8, 0x43, 0xd8, 0x44, 0xd8, 0x45, 0xd8, 0x46,
    0xd8, 0x47, 0xd8, 0x48, 0xd8, 0x49, 0xd8, 0x4a, 0xd8, 0x4b, 0xd8, 0x4c,
    0xd8, 0x4d, 0xd8, 0x4e, 0xd8, 0x4f, 0xd8, 0x50, 0xd8, 0x51, 0xd8, 0x52,
    0xd8, 0x53, 0xd8, 0x54, 0xd8, 0x55, 0xd8, 0x56, 0xd8, 0x57, 0xd8, 0x59,
    0xd8, 0x6a, 0xd8, 0x6b, 0xd8, 0x71, 0xd8, 0x76, 0xd8, 0x77, 0xd8, 0x78,
    0xd8, 0x79, 0xd8, 0x7a};
const uint8_t HuffDecoderCommon::table29_101_emit_[136] = {
    0xd9, 0x30, 0xd9, 0x31, 0xd9, 0x32, 0xd9, 0x61, 0xd9, 0x63, 0xd9, 0x65,
    0xd9, 0x69, 0xd9, 0x6f, 0xd9, 0x73, 0xd9, 0x74, 0xd9, 0x20, 0xd9, 0x25,
    0xd9, 0x2d, 0xd9, 0x2e, 0xd9, 0x2f, 0xd9, 0x33, 0xd9, 0x34, 0xd9, 0x35,
    0xd9, 0x36, 0xd9, 0x37, 0xd9, 0x38, 0xd9, 0x39, 0xd9, 0x3d, 0xd9, 0x41,
    0xd9, 0x5f, 0xd9, 0x62, 0xd9, 0x64, 0xd9, 0x66, 0xd9, 0x67, 0xd9, 0x68,
    0xd9, 0x6c, 0xd9, 0x6d, 0xd9, 0x6e, 0xd9, 0x70, 0xd9, 0x72, 0xd9, 0x75,
    0xd9, 0x3a, 0xd9, 0x42, 0xd9, 0x43, 0xd9, 0x44, 0xd9, 0x45, 0xd9, 0x46,
    0xd9, 0x47, 0xd9, 0x48, 0xd9, 0x49, 0xd9, 0x4a, 0xd9, 0x4b, 0xd9, 0x4c,
    0xd9, 0x4d, 0xd9, 0x4e, 0xd9, 0x4f, 0xd9, 0x50, 0xd9, 0x51, 0xd9, 0x52,
    0xd9, 0x53, 0xd9, 0x54, 0xd9, 0x55, 0xd9, 0x56, 0xd9, 0x57, 0xd9, 0x59,
    0xd9, 0x6a, 0xd9, 0x6b, 0xd9, 0x71, 0xd9, 0x76, 0xd9, 0x77, 0xd9, 0x78,
    0xd9, 0x79, 0xd9, 0x7a};
const uint8_t HuffDecoderCommon::table29_102_emit_[136] = {
    0xe3, 0x30, 0xe3, 0x31, 0xe3, 0x32, 0xe3, 0x61, 0xe3, 0x63, 0xe3, 0x65,
    0xe3, 0x69, 0xe3, 0x6f, 0xe3, 0x73, 0xe3, 0x74, 0xe3, 0x20, 0xe3, 0x25,
    0xe3, 0x2d, 0xe3, 0x2e, 0xe3, 0x2f, 0xe3, 0x33, 0xe3, 0x34, 0xe3, 0x35,
    0xe3, 0x36, 0xe3, 0x37, 0xe3, 0x38, 0xe3, 0x39, 0xe3, 0x3d, 0xe3, 0x41,
    0xe3, 0x5f, 0xe3, 0x62, 0xe3, 0x64, 0xe3, 0x66, 0xe3, 0x67, 0xe3, 0x68,
    0xe3, 0x6c, 0xe3, 0x6d, 0xe3, 0x6e, 0xe3, 0x70, 0xe3, 0x72, 0xe3, 0x75,
    0xe3, 0x3a, 0xe3, 0x42, 0xe3, 0x43, 0xe3, 0x44, 0xe3, 0x45, 0xe3, 0x46,
    0xe3, 0x47, 0xe3, 0x48, 0xe3, 0x49, 0xe3, 0x4a, 0xe3, 0x4b, 0xe3, 0x4c,
    0xe3, 0x4d, 0xe3, 0x4e, 0xe3, 0x4f, 0xe3, 0x50, 0xe3, 0x51, 0xe3, 0x52,
    0xe3, 0x53, 0xe3, 0x54, 0xe3, 0x55, 0xe3, 0x56, 0xe3, 0x57, 0xe3, 0x59,
    0xe3, 0x6a, 0xe3, 0x6b, 0xe3, 0x71, 0xe3, 0x76, 0xe3, 0x77, 0xe3, 0x78,
    0xe3, 0x79, 0xe3, 0x7a};
const uint8_t HuffDecoderCommon::table29_103_emit_[136] = {
    0xe5, 0x30, 0xe5, 0x31, 0xe5, 0x32, 0xe5, 0x61, 0xe5, 0x63, 0xe5, 0x65,
    0xe5, 0x69, 0xe5, 0x6f, 0xe5, 0x73, 0xe5, 0x74, 0xe5, 0x20, 0xe5, 0x25,
    0xe5, 0x2d, 0xe5, 0x2e, 0xe5, 0x2f, 0xe5, 0x33, 0xe5, 0x34, 0xe5, 0x35,
    0xe5, 0x36, 0xe5, 0x37, 0xe5, 0x38, 0xe5, 0x39, 0xe5, 0x3d, 0xe5, 0x41,
    0xe5, 0x5f, 0xe5, 0x62, 0xe5, 0x64, 0xe5, 0x66, 0xe5, 0x67, 0xe5, 0x68,
    0xe5, 0x6c, 0xe5, 0x6d, 0xe5, 0x6e, 0xe5, 0x70, 0xe5, 0x72, 0xe5, 0x75,
    0xe5, 0x3a, 0xe5, 0x42, 0xe5, 0x43, 0xe5, 0x44, 0xe5, 0x45, 0xe5, 0x46,
    0xe5, 0x47, 0xe5, 0x48, 0xe5, 0x49, 0xe5, 0x4a, 0xe5, 0x4b, 0xe5, 0x4c,
    0xe5, 0x4d, 0xe5, 0x4e, 0xe5, 0x4f, 0xe5, 0x50, 0xe5, 0x51, 0xe5, 0x52,
    0xe5, 0x53, 0xe5, 0x54, 0xe5, 0x55, 0xe5, 0x56, 0xe5, 0x57, 0xe5, 0x59,
    0xe5, 0x6a, 0xe5, 0x6b, 0xe5, 0x71, 0xe5, 0x76, 0xe5, 0x77, 0xe5, 0x78,
    0xe5, 0x79, 0xe5, 0x7a};
const uint8_t HuffDecoderCommon::table29_104_emit_[136] = {
    0xe6, 0x30, 0xe6, 0x31, 0xe6, 0x32, 0xe6, 0x61, 0xe6, 0x63, 0xe6, 0x65,
    0xe6, 0x69, 0xe6, 0x6f, 0xe6, 0x73, 0xe6, 0x74, 0xe6, 0x20, 0xe6, 0x25,
    0xe6, 0x2d, 0xe6, 0x2e, 0xe6, 0x2f, 0xe6, 0x33, 0xe6, 0x34, 0xe6, 0x35,
    0xe6, 0x36, 0xe6, 0x37, 0xe6, 0x38, 0xe6, 0x39, 0xe6, 0x3d, 0xe6, 0x41,
    0xe6, 0x5f, 0xe6, 0x62, 0xe6, 0x64, 0xe6, 0x66, 0xe6, 0x67, 0xe6, 0x68,
    0xe6, 0x6c, 0xe6, 0x6d, 0xe6, 0x6e, 0xe6, 0x70, 0xe6, 0x72, 0xe6, 0x75,
    0xe6, 0x3a, 0xe6, 0x42, 0xe6, 0x43, 0xe6, 0x44, 0xe6, 0x45, 0xe6, 0x46,
    0xe6, 0x47, 0xe6, 0x48, 0xe6, 0x49, 0xe6, 0x4a, 0xe6, 0x4b, 0xe6, 0x4c,
    0xe6, 0x4d, 0xe6, 0x4e, 0xe6, 0x4f, 0xe6, 0x50, 0xe6, 0x51, 0xe6, 0x52,
    0xe6, 0x53, 0xe6, 0x54, 0xe6, 0x55, 0xe6, 0x56, 0xe6, 0x57, 0xe6, 0x59,
    0xe6, 0x6a, 0xe6, 0x6b, 0xe6, 0x71, 0xe6, 0x76, 0xe6, 0x77, 0xe6, 0x78,
    0xe6, 0x79, 0xe6, 0x7a};
const uint8_t HuffDecoderCommon::table29_105_emit_[144] = {
    0x81, 0x30, 0x81, 0x31, 0x81, 0x32, 0x81, 0x61, 0x81, 0x63, 0x81, 0x65,
    0x81, 0x69, 0x81, 0x6f, 0x81, 0x73, 0x81, 0x74, 0x81, 0x20, 0x81, 0x25,
    0x81, 0x2d, 0x81, 0x2e, 0x81, 0x2f, 0x81, 0x33, 0x81, 0x34, 0x81, 0x35,
    0x81, 0x36, 0x81, 0x37, 0x81, 0x38, 0x81, 0x39, 0x81, 0x3d, 0x81, 0x41,
    0x81, 0x5f, 0x81, 0x62, 0x81, 0x64, 0x81, 0x66, 0x81, 0x67, 0x81, 0x68,
    0x81, 0x6c, 0x81, 0x6d, 0x81, 0x6e, 0x81, 0x70, 0x81, 0x72, 0x81, 0x75,
    0x84, 0x30, 0x84, 0x31, 0x84, 0x32, 0x84, 0x61, 0x84, 0x63, 0x84, 0x65,
    0x84, 0x69, 0x84, 0x6f, 0x84, 0x73, 0x84, 0x74, 0x84, 0x20, 0x84, 0x25,
    0x84, 0x2d, 0x84, 0x2e, 0x84, 0x2f, 0x84, 0x33, 0x84, 0x34, 0x84, 0x35,
    0x84, 0x36, 0x84, 0x37, 0x84, 0x38, 0x84, 0x39, 0x84, 0x3d, 0x84, 0x41,
    0x84, 0x5f, 0x84, 0x62, 0x84, 0x64, 0x84, 0x66, 0x84, 0x67, 0x84, 0x68,
    0x84, 0x6c, 0x84, 0x6d, 0x84, 0x6e, 0x84, 0x70, 0x84, 0x72, 0x84, 0x75};
const uint16_t HuffDecoderCommon::table29_105_inner_[75] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0003, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2,
    0x02b2, 0x02c2, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332,
    0x0342, 0x0352, 0x0362, 0x0372, 0x0382, 0x0392, 0x03a2, 0x03b2, 0x03c2,
    0x03d2, 0x03e2, 0x03f2, 0x0402, 0x0412, 0x0422, 0x0432, 0x0442, 0x0452,
    0x0462, 0x0472, 0x0243};
const uint8_t HuffDecoderCommon::table29_106_emit_[144] = {
    0x85, 0x30, 0x85, 0x31, 0x85, 0x32, 0x85, 0x61, 0x85, 0x63, 0x85, 0x65,
    0x85, 0x69, 0x85, 0x6f, 0x85, 0x73, 0x85, 0x74, 0x85, 0x20, 0x85, 0x25,
    0x85, 0x2d, 0x85, 0x2e, 0x85, 0x2f, 0x85, 0x33, 0x85, 0x34, 0x85, 0x35,
    0x85, 0x36, 0x85, 0x37, 0x85, 0x38, 0x85, 0x39, 0x85, 0x3d, 0x85, 0x41,
    0x85, 0x5f, 0x85, 0x62, 0x85, 0x64, 0x85, 0x66, 0x85, 0x67, 0x85, 0x68,
    0x85, 0x6c, 0x85, 0x6d, 0x85, 0x6e, 0x85, 0x70, 0x85, 0x72, 0x85, 0x75,
    0x86, 0x30, 0x86, 0x31, 0x86, 0x32, 0x86, 0x61, 0x86, 0x63, 0x86, 0x65,
    0x86, 0x69, 0x86, 0x6f, 0x86, 0x73, 0x86, 0x74, 0x86, 0x20, 0x86, 0x25,
    0x86, 0x2d, 0x86, 0x2e, 0x86, 0x2f, 0x86, 0x33, 0x86, 0x34, 0x86, 0x35,
    0x86, 0x36, 0x86, 0x37, 0x86, 0x38, 0x86, 0x39, 0x86, 0x3d, 0x86, 0x41,
    0x86, 0x5f, 0x86, 0x62, 0x86, 0x64, 0x86, 0x66, 0x86, 0x67, 0x86, 0x68,
    0x86, 0x6c, 0x86, 0x6d, 0x86, 0x6e, 0x86, 0x70, 0x86, 0x72, 0x86, 0x75};
const uint8_t HuffDecoderCommon::table29_107_emit_[144] = {
    0x88, 0x30, 0x88, 0x31, 0x88, 0x32, 0x88, 0x61, 0x88, 0x63, 0x88, 0x65,
    0x88, 0x69, 0x88, 0x6f, 0x88, 0x73, 0x88, 0x74, 0x88, 0x20, 0x88, 0x25,
    0x88, 0x2d, 0x88, 0x2e, 0x88, 0x2f, 0x88, 0x33, 0x88, 0x34, 0x88, 0x35,
    0x88, 0x36, 0x88, 0x37, 0x88, 0x38, 0x88, 0x39, 0x88, 0x3d, 0x88, 0x41,
    0x88, 0x5f, 0x88, 0x62, 0x88, 0x64, 0x88, 0x66, 0x88, 0x67, 0x88, 0x68,
    0x88, 0x6c, 0x88, 0x6d, 0x88, 0x6e, 0x88, 0x70, 0x88, 0x72, 0x88, 0x75,
    0x92, 0x30, 0x92, 0x31, 0x92, 0x32, 0x92, 0x61, 0x92, 0x63, 0x92, 0x65,
    0x92, 0x69, 0x92, 0x6f, 0x92, 0x73, 0x92, 0x74, 0x92, 0x20, 0x92, 0x25,
    0x92, 0x2d, 0x92, 0x2e, 0x92, 0x2f, 0x92, 0x33, 0x92, 0x34, 0x92, 0x35,
    0x92, 0x36, 0x92, 0x37, 0x92, 0x38, 0x92, 0x39, 0x92, 0x3d, 0x92, 0x41,
    0x92, 0x5f, 0x92, 0x62, 0x92, 0x64, 0x92, 0x66, 0x92, 0x67, 0x92, 0x68,
    0x92, 0x6c, 0x92, 0x6d, 0x92, 0x6e, 0x92, 0x70, 0x92, 0x72, 0x92, 0x75};
const uint8_t HuffDecoderCommon::table29_108_emit_[144] = {
    0x9a, 0x30, 0x9a, 0x31, 0x9a, 0x32, 0x9a, 0x61, 0x9a, 0x63, 0x9a, 0x65,
    0x9a, 0x69, 0x9a, 0x6f, 0x9a, 0x73, 0x9a, 0x74, 0x9a, 0x20, 0x9a, 0x25,
    0x9a, 0x2d, 0x9a, 0x2e, 0x9a, 0x2f, 0x9a, 0x33, 0x9a, 0x34, 0x9a, 0x35,
    0x9a, 0x36, 0x9a, 0x37, 0x9a, 0x38, 0x9a, 0x39, 0x9a, 0x3d, 0x9a, 0x41,
    0x9a, 0x5f, 0x9a, 0x62, 0x9a, 0x64, 0x9a, 0x66, 0x9a, 0x67, 0x9a, 0x68,
    0x9a, 0x6c, 0x9a, 0x6d, 0x9a, 0x6e, 0x9a, 0x70, 0x9a, 0x72, 0x9a, 0x75,
    0x9c, 0x30, 0x9c, 0x31, 0x9c, 0x32, 0x9c, 0x61, 0x9c, 0x63, 0x9c, 0x65,
    0x9c, 0x69, 0x9c, 0x6f, 0x9c, 0x73, 0x9c, 0x74, 0x9c, 0x20, 0x9c, 0x25,
    0x9c, 0x2d, 0x9c, 0x2e, 0x9c, 0x2f, 0x9c, 0x33, 0x9c, 0x34, 0x9c, 0x35,
    0x9c, 0x36, 0x9c, 0x37, 0x9c, 0x38, 0x9c, 0x39, 0x9c, 0x3d, 0x9c, 0x41,
    0x9c, 0x5f, 0x9c, 0x62, 0x9c, 0x64, 0x9c, 0x66, 0x9c, 0x67, 0x9c, 0x68,
    0x9c, 0x6c, 0x9c, 0x6d, 0x9c, 0x6e, 0x9c, 0x70, 0x9c, 0x72, 0x9c, 0x75};
const uint8_t HuffDecoderCommon::table29_109_emit_[144] = {
    0xa0, 0x30, 0xa0, 0x31, 0xa0, 0x32, 0xa0, 0x61, 0xa0, 0x63, 0xa0, 0x65,
    0xa0, 0x69, 0xa0, 0x6f, 0xa0, 0x73, 0xa0, 0x74, 0xa0, 0x20, 0xa0, 0x25,
    0xa0, 0x2d, 0xa0, 0x2e, 0xa0, 0x2f, 0xa0, 0x33, 0xa0, 0x34, 0xa0, 0x35,
    0xa0, 0x36, 0xa0, 0x37, 0xa0, 0x38, 0xa0, 0x39, 0xa0, 0x3d, 0xa0, 0x41,
    0xa0, 0x5f, 0xa0, 0x62, 0xa0, 0x64, 0xa0, 0x66, 0xa0, 0x67, 0xa0, 0x68,
    0xa0, 0x6c, 0xa0, 0x6d, 0xa0, 0x6e, 0xa0, 0x70, 0xa0, 0x72, 0xa0, 0x75,
    0xa3, 0x30, 0xa3, 0x31, 0xa3, 0x32, 0xa3, 0x61, 0xa3, 0x63, 0xa3, 0x65,
    0xa3, 0x69, 0xa3, 0x6f, 0xa3, 0x73, 0xa3, 0x74, 0xa3, 0x20, 0xa3, 0x25,
    0xa3, 0x2d, 0xa3, 0x2e, 0xa3, 0x2f, 0xa3, 0x33, 0xa3, 0x34, 0xa3, 0x35,
    0xa3, 0x36, 0xa3, 0x37, 0xa3, 0x38, 0xa3, 0x39, 0xa3, 0x3d, 0xa3, 0x41,
    0xa3, 0x5f, 0xa3, 0x62, 0xa3, 0x64, 0xa3, 0x66, 0xa3, 0x67, 0xa3, 0x68,
    0xa3, 0x6c, 0xa3, 0x6d, 0xa3, 0x6e, 0xa3, 0x70, 0xa3, 0x72, 0xa3, 0x75};
const uint8_t HuffDecoderCommon::table29_110_emit_[144] = {
    0xa4, 0x30, 0xa4, 0x31, 0xa4, 0x32, 0xa4, 0x61, 0xa4, 0x63, 0xa4, 0x65,
    0xa4, 0x69, 0xa4, 0x6f, 0xa4, 0x73, 0xa4, 0x74, 0xa4, 0x20, 0xa4, 0x25,
    0xa4, 0x2d, 0xa4, 0x2e, 0xa4, 0x2f, 0xa4, 0x33, 0xa4, 0x34, 0xa4, 0x35,
    0xa4, 0x36, 0xa4, 0x37, 0xa4, 0x38, 0xa4, 0x39, 0xa4, 0x3d, 0xa4, 0x41,
    0xa4, 0x5f, 0xa4, 0x62, 0xa4, 0x64, 0xa4, 0x66, 0xa4, 0x67, 0xa4, 0x68,
    0xa4, 0x6c, 0xa4, 0x6d, 0xa4, 0x6e, 0xa4, 0x70, 0xa4, 0x72, 0xa4, 0x75,
    0xa9, 0x30, 0xa9, 0x31, 0xa9, 0x32, 0xa9, 0x61, 0xa9, 0x63, 0xa9, 0x65,
    0xa9, 0x69, 0xa9, 0x6f, 0xa9, 0x73, 0xa9, 0x74, 0xa9, 0x20, 0xa9, 0x25,
    0xa9, 0x2d, 0xa9, 0x2e, 0xa9, 0x2f, 0xa9, 0x33, 0xa9, 0x34, 0xa9, 0x35,
    0xa9, 0x36, 0xa9, 0x37, 0xa9, 0x38, 0xa9, 0x39, 0xa9, 0x3d, 0xa9, 0x41,
    0xa9, 0x5f, 0xa9, 0x62, 0xa9, 0x64, 0xa9, 0x66, 0xa9, 0x67, 0xa9, 0x68,
    0xa9, 0x6c, 0xa9, 0x6d, 0xa9, 0x6e, 0xa9, 0x70, 0xa9, 0x72, 0xa9, 0x75};
const uint8_t HuffDecoderCommon::table29_111_emit_[144] = {
    0xaa, 0x30, 0xaa, 0x31, 0xaa, 0x32, 0xaa, 0x61, 0xaa, 0x63, 0xaa, 0x65,
    0xaa, 0x69, 0xaa, 0x6f, 0xaa, 0x73, 0xaa, 0x74, 0xaa, 0x20, 0xaa, 0x25,
    0xaa, 0x2d, 0xaa, 0x2e, 0xaa, 0x2f, 0xaa, 0x33, 0xaa, 0x34, 0xaa, 0x35,
    0xaa, 0x36, 0xaa, 0x37, 0xaa, 0x38, 0xaa, 0x39, 0xaa, 0x3d, 0xaa, 0x41,
    0xaa, 0x5f, 0xaa, 0x62, 0xaa, 0x64, 0xaa, 0x66, 0xaa, 0x67, 0xaa, 0x68,
    0xaa, 0x6c, 0xaa, 0x6d, 0xaa, 0x6e, 0xaa, 0x70, 0xaa, 0x72, 0xaa, 0x75,
    0xad, 0x30, 0xad, 0x31, 0xad, 0x32, 0xad, 0x61, 0xad, 0x63, 0xad, 0x65,
    0xad, 0x69, 0xad, 0x6f, 0xad, 0x73, 0xad, 0x74, 0xad, 0x20, 0xad, 0x25,
    0xad, 0x2d, 0xad, 0x2e, 0xad, 0x2f, 0xad, 0x33, 0xad, 0x34, 0xad, 0x35,
    0xad, 0x36, 0xad, 0x37, 0xad, 0x38, 0xad, 0x39, 0xad, 0x3d, 0xad, 0x41,
    0xad, 0x5f, 0xad, 0x62, 0xad, 0x64, 0xad, 0x66, 0xad, 0x67, 0xad, 0x68,
    0xad, 0x6c, 0xad, 0x6d, 0xad, 0x6e, 0xad, 0x70, 0xad, 0x72, 0xad, 0x75};
const uint8_t HuffDecoderCommon::table29_112_emit_[144] = {
    0xb2, 0x30, 0xb2, 0x31, 0xb2, 0x32, 0xb2, 0x61, 0xb2, 0x63, 0xb2, 0x65,
    0xb2, 0x69, 0xb2, 0x6f, 0xb2, 0x73, 0xb2, 0x74, 0xb2, 0x20, 0xb2, 0x25,
    0xb2, 0x2d, 0xb2, 0x2e, 0xb2, 0x2f, 0xb2, 0x33, 0xb2, 0x34, 0xb2, 0x35,
    0xb2, 0x36, 0xb2, 0x37, 0xb2, 0x38, 0xb2, 0x39, 0xb2, 0x3d, 0xb2, 0x41,
    0xb2, 0x5f, 0xb2, 0x62, 0xb2, 0x64, 0xb2, 0x66, 0xb2, 0x67, 0xb2, 0x68,
    0xb2, 0x6c, 0xb2, 0x6d, 0xb2, 0x6e, 0xb2, 0x70, 0xb2, 0x72, 0xb2, 0x75,
    0xb5, 0x30, 0xb5, 0x31, 0xb5, 0x32, 0xb5, 0x61, 0xb5, 0x63, 0xb5, 0x65,
    0xb5, 0x69, 0xb5, 0x6f, 0xb5, 0x73, 0xb5, 0x74, 0xb5, 0x20, 0xb5, 0x25,
    0xb5, 0x2d, 0xb5, 0x2e, 0xb5, 0x2f, 0xb5, 0x33, 0xb5, 0x34, 0xb5, 0x35,
    0xb5, 0x36, 0xb5, 0x37, 0xb5, 0x38, 0xb5, 0x39, 0xb5, 0x3d, 0xb5, 0x41,
    0xb5, 0x5f, 0xb5, 0x62, 0xb5, 0x64, 0xb5, 0x66, 0xb5, 0x67, 0xb5, 0x68,
    0xb5, 0x6c, 0xb5, 0x6d, 0xb5, 0x6e, 0xb5, 0x70, 0xb5, 0x72, 0xb5, 0x75};
const uint8_t HuffDecoderCommon::table29_113_emit_[144] = {
    0xb9, 0x30, 0xb9, 0x31, 0xb9, 0x32, 0xb9, 0x61, 0xb9, 0x63, 0xb9, 0x65,
    0xb9, 0x69, 0xb9, 0x6f, 0xb9, 0x73, 0xb9, 0x74, 0xb9, 0x20, 0xb9, 0x25,
    0xb9, 0x2d, 0xb9, 0x2e, 0xb9, 0x2f, 0xb9, 0x33, 0xb9, 0x34, 0xb9, 0x35,
    0xb9, 0x36, 0xb9, 0x37, 0xb9, 0x38, 0xb9, 0x39, 0xb9, 0x3d, 0xb9, 0x41,
    0xb9, 0x5f, 0xb9, 0x62, 0xb9, 0x64, 0xb9, 0x66, 0xb9, 0x67, 0xb9, 0x68,
    0xb9, 0x6c, 0xb9, 0x6d, 0xb9, 0x6e, 0xb9, 0x70, 0xb9, 0x72, 0xb9, 0x75,
    0xba, 0x30, 0xba, 0x31, 0xba, 0x32, 0xba, 0x61, 0xba, 0x63, 0xba, 0x65,
    0xba, 0x69, 0xba, 0x6f, 0xba, 0x73, 0xba, 0x74, 0xba, 0x20, 0xba, 0x25,
    0xba, 0x2d, 0xba, 0x2e, 0xba, 0x2f, 0xba, 0x33, 0xba, 0x34, 0xba, 0x35,
    0xba, 0x36, 0xba, 0x37, 0xba, 0x38, 0xba, 0x39, 0xba, 0x3d, 0xba, 0x41,
    0xba, 0x5f, 0xba, 0x62, 0xba, 0x64, 0xba, 0x66, 0xba, 0x67, 0xba, 0x68,
    0xba, 0x6c, 0xba, 0x6d, 0xba, 0x6e, 0xba, 0x70, 0xba, 0x72, 0xba, 0x75};
const uint8_t HuffDecoderCommon::table29_114_emit_[144] = {
    0xbb, 0x30, 0xbb, 0x31, 0xbb, 0x32, 0xbb, 0x61, 0xbb, 0x63, 0xbb, 0x65,
    0xbb, 0x69, 0xbb, 0x6f, 0xbb, 0x73, 0xbb, 0x74, 0xbb, 0x20, 0xbb, 0x25,
    0xbb, 0x2d, 0xbb, 0x2e, 0xbb, 0x2f, 0xbb, 0x33, 0xbb, 0x34, 0xbb, 0x35,
    0xbb, 0x36, 0xbb, 0x37, 0xbb, 0x38, 0xbb, 0x39, 0xbb, 0x3d, 0xbb, 0x41,
    0xbb, 0x5f, 0xbb, 0x62, 0xbb, 0x64, 0xbb, 0x66, 0xbb, 0x67, 0xbb, 0x68,
    0xbb, 0x6c, 0xbb, 0x6d, 0xbb, 0x6e, 0xbb, 0x70, 0xbb, 0x72, 0xbb, 0x75,
    0xbd, 0x30, 0xbd, 0x31, 0xbd, 0x32, 0xbd, 0x61, 0xbd, 0x63, 0xbd, 0x65,
    0xbd, 0x69, 0xbd, 0x6f, 0xbd, 0x73, 0xbd, 0x74, 0xbd, 0x20, 0xbd, 0x25,
    0xbd, 0x2d, 0xbd, 0x2e, 0xbd, 0x2f, 0xbd, 0x33, 0xbd, 0x34, 0xbd, 0x35,
    0xbd, 0x36, 0xbd, 0x37, 0xbd, 0x38, 0xbd, 0x39, 0xbd, 0x3d, 0xbd, 0x41,
    0xbd, 0x5f, 0xbd, 0x62, 0xbd, 0x64, 0xbd, 0x66, 0xbd, 0x67, 0xbd, 0x68,
    0xbd, 0x6c, 0xbd, 0x6d, 0xbd, 0x6e, 0xbd, 0x70, 0xbd, 0x72, 0xbd, 0x75};
const uint8_t HuffDecoderCommon::table29_115_emit_[144] = {
    0xbe, 0x30, 0xbe, 0x31, 0xbe, 0x32, 0xbe, 0x61, 0xbe, 0x63, 0xbe, 0x65,
    0xbe, 0x69, 0xbe, 0x6f, 0xbe, 0x73, 0xbe, 0x74, 0xbe, 0x20, 0xbe, 0x25,
    0xbe, 0x2d, 0xbe, 0x2e, 0xbe, 0x2f, 0xbe, 0x33, 0xbe, 0x34, 0xbe, 0x35,
    0xbe, 0x36, 0xbe, 0x37, 0xbe, 0x38, 0xbe, 0x39, 0xbe, 0x3d, 0xbe, 0x41,
    0xbe, 0x5f, 0xbe, 0x62, 0xbe, 0x64, 0xbe, 0x66, 0xbe, 0x67, 0xbe, 0x68,
    0xbe, 0x6c, 0xbe, 0x6d, 0xbe, 0x6e, 0xbe, 0x70, 0xbe, 0x72, 0xbe, 0x75,
    0xc4, 0x30, 0xc4, 0x31, 0xc4, 0x32, 0xc4, 0x61, 0xc4, 0x63, 0xc4, 0x65,
    0xc4, 0x69, 0xc4, 0x6f, 0xc4, 0x73, 0xc4, 0x74, 0xc4, 0x20, 0xc4, 0x25,
    0xc4, 0x2d, 0xc4, 0x2e, 0xc4, 0x2f, 0xc4, 0x33, 0xc4, 0x34, 0xc4, 0x35,
    0xc4, 0x36, 0xc4, 0x37, 0xc4, 0x38, 0xc4, 0x39, 0xc4, 0x3d, 0xc4, 0x41,
    0xc4, 0x5f, 0xc4, 0x62, 0xc4, 0x64, 0xc4, 0x66, 0xc4, 0x67, 0xc4, 0x68,
    0xc4, 0x6c, 0xc4, 0x6d, 0xc4, 0x6e, 0xc4, 0x70, 0xc4, 0x72, 0xc4, 0x75};
const uint8_t HuffDecoderCommon::table29_116_emit_[144] = {
    0xc6, 0x30, 0xc6, 0x31, 0xc6, 0x32, 0xc6, 0x61, 0xc6, 0x63, 0xc6, 0x65,
    0xc6, 0x69, 0xc6, 0x6f, 0xc6, 0x73, 0xc6, 0x74, 0xc6, 0x20, 0xc6, 0x25,
    0xc6, 0x2d, 0xc6, 0x2e, 0xc6, 0x2f, 0xc6, 0x33, 0xc6, 0x34, 0xc6, 0x35,
    0xc6, 0x36, 0xc6, 0x37, 0xc6, 0x38, 0xc6, 0x39, 0xc6, 0x3d, 0xc6, 0x41,
    0xc6, 0x5f, 0xc6, 0x62, 0xc6, 0x64, 0xc6, 0x66, 0xc6, 0x67, 0xc6, 0x68,
    0xc6, 0x6c, 0xc6, 0x6d, 0xc6, 0x6e, 0xc6, 0x70, 0xc6, 0x72, 0xc6, 0x75,
    0xe4, 0x30, 0xe4, 0x31, 0xe4, 0x32, 0xe4, 0x61, 0xe4, 0x63, 0xe4, 0x65,
    0xe4, 0x69, 0xe4, 0x6f, 0xe4, 0x73, 0xe4, 0x74, 0xe4, 0x20, 0xe4, 0x25,
    0xe4, 0x2d, 0xe4, 0x2e, 0xe4, 0x2f, 0xe4, 0x33, 0xe4, 0x34, 0xe4, 0x35,
    0xe4, 0x36, 0xe4, 0x37, 0xe4, 0x38, 0xe4, 0x39, 0xe4, 0x3d, 0xe4, 0x41,
    0xe4, 0x5f, 0xe4, 0x62, 0xe4, 0x64, 0xe4, 0x66, 0xe4, 0x67, 0xe4, 0x68,
    0xe4, 0x6c, 0xe4, 0x6d, 0xe4, 0x6e, 0xe4, 0x70, 0xe4, 0x72, 0xe4, 0x75};
const uint8_t HuffDecoderCommon::table29_117_emit_[144] = {
    0xe8, 0x30, 0xe8, 0x31, 0xe8, 0x32, 0xe8, 0x61, 0xe8, 0x63, 0xe8, 0x65,
    0xe8, 0x69, 0xe8, 0x6f, 0xe8, 0x73, 0xe8, 0x74, 0xe8, 0x20, 0xe8, 0x25,
    0xe8, 0x2d, 0xe8, 0x2e, 0xe8, 0x2f, 0xe8, 0x33, 0xe8, 0x34, 0xe8, 0x35,
    0xe8, 0x36, 0xe8, 0x37, 0xe8, 0x38, 0xe8, 0x39, 0xe8, 0x3d, 0xe8, 0x41,
    0xe8, 0x5f, 0xe8, 0x62, 0xe8, 0x64, 0xe8, 0x66, 0xe8, 0x67, 0xe8, 0x68,
    0xe8, 0x6c, 0xe8, 0x6d, 0xe8, 0x6e, 0xe8, 0x70, 0xe8, 0x72, 0xe8, 0x75,
    0xe9, 0x30, 0xe9, 0x31, 0xe9, 0x32, 0xe9, 0x61, 0xe9, 0x63, 0xe9, 0x65,
    0xe9, 0x69, 0xe9, 0x6f, 0xe9, 0x73, 0xe9, 0x74, 0xe9, 0x20, 0xe9, 0x25,
    0xe9, 0x2d, 0xe9, 0x2e, 0xe9, 0x2f, 0xe9, 0x33, 0xe9, 0x34, 0xe9, 0x35,
    0xe9, 0x36, 0xe9, 0x37, 0xe9, 0x38, 0xe9, 0x39, 0xe9, 0x3d, 0xe9, 0x41,
    0xe9, 0x5f, 0xe9, 0x62, 0xe9, 0x64, 0xe9, 0x66, 0xe9, 0x67, 0xe9, 0x68,
    0xe9, 0x6c, 0xe9, 0x6d, 0xe9, 0x6e, 0xe9, 0x70, 0xe9, 0x72, 0xe9, 0x75};
const uint8_t HuffDecoderCommon::table29_118_emit_[80] = {
    0x01, 0x30, 0x01, 0x31, 0x01, 0x32, 0x01, 0x61, 0x01, 0x63, 0x01, 0x65,
    0x01, 0x69, 0x01, 0x6f, 0x01, 0x73, 0x01, 0x74, 0x87, 0x30, 0x87, 0x31,
    0x87, 0x32, 0x87, 0x61, 0x87, 0x63, 0x87, 0x65, 0x87, 0x69, 0x87, 0x6f,
    0x87, 0x73, 0x87, 0x74, 0x89, 0x30, 0x89, 0x31, 0x89, 0x32, 0x89, 0x61,
    0x89, 0x63, 0x89, 0x65, 0x89, 0x69, 0x89, 0x6f, 0x89, 0x73, 0x89, 0x74,
    0x8a, 0x30, 0x8a, 0x31, 0x8a, 0x32, 0x8a, 0x61, 0x8a, 0x63, 0x8a, 0x65,
    0x8a, 0x69, 0x8a, 0x6f, 0x8a, 0x73, 0x8a, 0x74};
const uint16_t HuffDecoderCommon::table29_118_inner_[45] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072, 0x0082,
    0x0092, 0x0000, 0x0003, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2,
    0x0102, 0x0112, 0x0122, 0x0132, 0x00a3, 0x0142, 0x0152, 0x0162, 0x0172,
    0x0182, 0x0192, 0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x0143, 0x01e2, 0x01f2,
    0x0202, 0x0212, 0x0222, 0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x01e3};
const uint8_t HuffDecoderCommon::table29_119_emit_[80] = {
    0x8b, 0x30, 0x8b, 0x31, 0x8b, 0x32, 0x8b, 0x61, 0x8b, 0x63, 0x8b, 0x65,
    0x8b, 0x69, 0x8b, 0x6f, 0x8b, 0x73, 0x8b, 0x74, 0x8c, 0x30, 0x8c, 0x31,
    0x8c, 0x32, 0x8c, 0x61, 0x8c, 0x63, 0x8c, 0x65, 0x8c, 0x69, 0x8c, 0x6f,
    0x8c, 0x73, 0x8c, 0x74, 0x8d, 0x30, 0x8d, 0x31, 0x8d, 0x32, 0x8d, 0x61,
    0x8d, 0x63, 0x8d, 0x65, 0x8d, 0x69, 0x8d, 0x6f, 0x8d, 0x73, 0x8d, 0x74,
    0x8f, 0x30, 0x8f, 0x31, 0x8f, 0x32, 0x8f, 0x61, 0x8f, 0x63, 0x8f, 0x65,
    0x8f, 0x69, 0x8f, 0x6f, 0x8f, 0x73, 0x8f, 0x74};
const uint8_t HuffDecoderCommon::table29_120_emit_[80] = {
    0x93, 0x30, 0x93, 0x31, 0x93, 0x32, 0x93, 0x61, 0x93, 0x63, 0x93, 0x65,
    0x93, 0x69, 0x93, 0x6f, 0x93, 0x73, 0x93, 0x74, 0x95, 0x30, 0x95, 0x31,
    0x95, 0x32, 0x95, 0x61, 0x95, 0x63, 0x95, 0x65, 0x95, 0x69, 0x95, 0x6f,
    0x95, 0x73, 0x95, 0x74, 0x96, 0x30, 0x96, 0x31, 0x96, 0x32, 0x96, 0x61,
    0x96, 0x63, 0x96, 0x65, 0x96, 0x69, 0x96, 0x6f, 0x96, 0x73, 0x96, 0x74,
    0x97, 0x30, 0x97, 0x31, 0x97, 0x32, 0x97, 0x61, 0x97, 0x63, 0x97, 0x65,
    0x97, 0x69, 0x97, 0x6f, 0x97, 0x73, 0x97, 0x74};
const uint8_t HuffDecoderCommon::table29_121_emit_[80] = {
    0x98, 0x30, 0x98, 0x31, 0x98, 0x32, 0x98, 0x61, 0x98, 0x63, 0x98, 0x65,
    0x98, 0x69, 0x98, 0x6f, 0x98, 0x73, 0x98, 0x74, 0x9b, 0x30, 0x9b, 0x31,
    0x9b, 0x32, 0x9b, 0x61, 0x9b, 0x63, 0x9b, 0x65, 0x9b, 0x69, 0x9b, 0x6f,
    0x9b, 0x73, 0x9b, 0x74, 0x9d, 0x30, 0x9d, 0x31, 0x9d, 0x32, 0x9d, 0x61,
    0x9d, 0x63, 0x9d, 0x65, 0x9d, 0x69, 0x9d, 0x6f, 0x9d, 0x73, 0x9d, 0x74,
    0x9e, 0x30, 0x9e, 0x31, 0x9e, 0x32, 0x9e, 0x61, 0x9e, 0x63, 0x9e, 0x65,
    0x9e, 0x69, 0x9e, 0x6f, 0x9e, 0x73, 0x9e, 0x74};
const uint8_t HuffDecoderCommon::table29_122_emit_[80] = {
    0xa5, 0x30, 0xa5, 0x31, 0xa5, 0x32, 0xa5, 0x61, 0xa5, 0x63, 0xa5, 0x65,
    0xa5, 0x69, 0xa5, 0x6f, 0xa5, 0x73, 0xa5, 0x74, 0xa6, 0x30, 0xa6, 0x31,
    0xa6, 0x32, 0xa6, 0x61, 0xa6, 0x63, 0xa6, 0x65, 0xa6, 0x69, 0xa6, 0x6f,
    0xa6, 0x73, 0xa6, 0x74, 0xa8, 0x30, 0xa8, 0x31, 0xa8, 0x32, 0xa8, 0x61,
    0xa8, 0x63, 0xa8, 0x65, 0xa8, 0x69, 0xa8, 0x6f, 0xa8, 0x73, 0xa8, 0x74,
    0xae, 0x30, 0xae, 0x31, 0xae, 0x32, 0xae, 0x61, 0xae, 0x63, 0xae, 0x65,
    0xae, 0x69, 0xae, 0x6f, 0xae, 0x73, 0xae, 0x74};
const uint8_t HuffDecoderCommon::table29_123_emit_[80] = {
    0xaf, 0x30, 0xaf, 0x31, 0xaf, 0x32, 0xaf, 0x61, 0xaf, 0x63, 0xaf, 0x65,
    0xaf, 0x69, 0xaf, 0x6f, 0xaf, 0x73, 0xaf, 0x74, 0xb4, 0x30, 0xb4, 0x31,
    0xb4, 0x32, 0xb4, 0x61, 0xb4, 0x63, 0xb4, 0x65, 0xb4, 0x69, 0xb4, 0x6f,
    0xb4, 0x73, 0xb4, 0x74, 0xb6, 0x30, 0xb6, 0x31, 0xb6, 0x32, 0xb6, 0x61,
    0xb6, 0x63, 0xb6, 0x65, 0xb6, 0x69, 0xb6, 0x6f, 0xb6, 0x73, 0xb6, 0x74,
    0xb7, 0x30, 0xb7, 0x31, 0xb7, 0x32, 0xb7, 0x61, 0xb7, 0x63, 0xb7, 0x65,
    0xb7, 0x69, 0xb7, 0x6f, 0xb7, 0x73, 0xb7, 0x74};
const uint8_t HuffDecoderCommon::table29_124_emit_[80] = {
    0xbc, 0x30, 0xbc, 0x31, 0xbc, 0x32, 0xbc, 0x61, 0xbc, 0x63, 0xbc, 0x65,
    0xbc, 0x69, 0xbc, 0x6f, 0xbc, 0x73, 0xbc, 0x74, 0xbf, 0x30, 0xbf, 0x31,
    0xbf, 0x32, 0xbf, 0x61, 0xbf, 0x63, 0xbf, 0x65, 0xbf, 0x69, 0xbf, 0x6f,
    0xbf, 0x73, 0xbf, 0x74, 0xc5, 0x30, 0xc5, 0x31, 0xc5, 0x32, 0xc5, 0x61,
    0xc5, 0x63, 0xc5, 0x65, 0xc5, 0x69, 0xc5, 0x6f, 0xc5, 0x73, 0xc5, 0x74,
    0xe7, 0x30, 0xe7, 0x31, 0xe7, 0x32, 0xe7, 0x61, 0xe7, 0x63, 0xe7, 0x65,
    0xe7, 0x69, 0xe7, 0x6f, 0xe7, 0x73, 0xe7, 0x74};
const uint8_t HuffDecoderCommon::table29_125_emit_[26] = {
    0xef, 0x30, 0xef, 0x31, 0xef, 0x32, 0xef, 0x61, 0xef,
    0x63, 0xef, 0x65, 0xef, 0x69, 0xef, 0x6f, 0xef, 0x73,
    0xef, 0x74, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f};
const uint16_t HuffDecoderCommon::table29_125_inner_[18] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072, 0x0082,
    0x0092, 0x0000, 0x0003, 0x00a3, 0x00ab, 0x00b3, 0x00bb, 0x00c3, 0x00cb};
const uint8_t HuffDecoderCommon::table29_125_outer_[128] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 13, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 14, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    15, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 16, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 17};
const uint8_t HuffDecoderCommon::table29_126_emit_[10] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb};
const uint16_t HuffDecoderCommon::table29_126_inner_[11] = {
    0x0000, 0x0003, 0x000b, 0x0013, 0x001b, 0x0023,
    0x002b, 0x0033, 0x003b, 0x0043, 0x004b};
const uint8_t HuffDecoderCommon::table29_126_outer_[128] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0,
    0, 8, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 10};
const uint8_t HuffDecoderCommon::table29_127_emit_[63] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee,
    0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde,
    0xdf, 0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd,
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0b, 0x0c, 0x0e,
    0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18, 0x19, 0x1a,
    0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint16_t HuffDecoderCommon::table29_127_inner_[65] = {
    0x0000, 0x0003, 0x000b, 0x0013, 0x001b, 0x0023, 0x002b, 0x0033, 0x003b,
    0x0043, 0x004b, 0x0053, 0x005b, 0x0063, 0x006b, 0x0073, 0x007b, 0x0083,
    0x008b, 0x0093, 0x009b, 0x00a3, 0x00ab, 0x00b3, 0x00bb, 0x00c3, 0x00cb,
    0x00d3, 0x00db, 0x00e3, 0x00eb, 0x00f3, 0x00fb, 0x0103, 0x010b, 0x0113,
    0x011b, 0x0123, 0x012b, 0x0133, 0x013b, 0x0143, 0x014b, 0x0153, 0x015b,
    0x0163, 0x016b, 0x0173, 0x017b, 0x0183, 0x018b, 0x0193, 0x019b, 0x01a3,
    0x01ab, 0x01b3, 0x01bb, 0x01c3, 0x01cb, 0x01d3, 0x01db, 0x01e3, 0x01eb,
    0x01f3, 0x0004};
const uint8_t HuffDecoderCommon::table29_127_outer_[128] = {
    0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,
    5,  0,  0,  0,  6,  0,  0,  0,  7,  0,  0,  0,  8,  0,  0,  0,  9,  0,  0,
    0,  10, 0,  0,  0,  11, 0,  0,  0,  12, 0,  0,  0,  13, 0,  0,  0,  14, 0,
    0,  0,  15, 0,  16, 0,  17, 0,  18, 0,  19, 0,  20, 0,  21, 0,  22, 0,  23,
    0,  24, 0,  25, 0,  26, 0,  27, 0,  28, 0,  29, 0,  30, 0,  31, 0,  32, 0,
    33, 0,  34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
    51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64};
const uint8_t* const HuffDecoderCommon::table29_emit_[128] = {
    table29_0_emit_,   table29_1_emit_,   table29_2_emit_,   table29_3_emit_,
    table29_4_emit_,   table29_5_emit_,   table29_6_emit_,   table29_7_emit_,
    table29_8_emit_,   table29_9_emit_,   table29_10_emit_,  table29_11_emit_,
    table29_12_emit_,  table29_13_emit_,  table29_14_emit_,  table29_15_emit_,
    table29_16_emit_,  table29_17_emit_,  table29_18_emit_,  table29_19_emit_,
    table29_20_emit_,  table29_21_emit_,  table29_22_emit_,  table29_23_emit_,
    table29_24_emit_,  table29_25_emit_,  table29_26_emit_,  table29_27_emit_,
    table29_28_emit_,  table29_29_emit_,  table29_30_emit_,  table29_31_emit_,
    table29_32_emit_,  table29_33_emit_,  table29_34_emit_,  table29_35_emit_,
    table29_36_emit_,  table29_37_emit_,  table29_38_emit_,  table29_39_emit_,
    table29_40_emit_,  table29_41_emit_,  table29_42_emit_,  table29_43_emit_,
    table29_44_emit_,  table29_45_emit_,  table29_46_emit_,  table29_47_emit_,
    table29_48_emit_,  table29_49_emit_,  table29_50_emit_,  table29_51_emit_,
    table29_52_emit_,  table29_53_emit_,  table29_54_emit_,  table29_55_emit_,
    table29_56_emit_,  table29_57_emit_,  table29_58_emit_,  table29_59_emit_,
    table29_60_emit_,  table29_61_emit_,  table29_62_emit_,  table29_63_emit_,
    table29_64_emit_,  table29_65_emit_,  table29_66_emit_,  table29_67_emit_,
    table29_68_emit_,  table29_69_emit_,  table29_70_emit_,  table29_71_emit_,
    table29_72_emit_,  table29_73_emit_,  table29_74_emit_,  table29_75_emit_,
    table29_76_emit_,  table29_77_emit_,  table29_78_emit_,  table29_79_emit_,
    table29_80_emit_,  table29_81_emit_,  table29_82_emit_,  table29_83_emit_,
    table29_84_emit_,  table29_85_emit_,  table29_86_emit_,  table29_87_emit_,
    table29_88_emit_,  table29_89_emit_,  table29_90_emit_,  table29_91_emit_,
    table29_92_emit_,  table29_93_emit_,  table29_94_emit_,  table29_95_emit_,
    table29_96_emit_,  table29_97_emit_,  table29_98_emit_,  table29_99_emit_,
    table29_100_emit_, table29_101_emit_, table29_102_emit_, table29_103_emit_,
    table29_104_emit_, table29_105_emit_, table29_106_emit_, table29_107_emit_,
    table29_108_emit_, table29_109_emit_, table29_110_emit_, table29_111_emit_,
    table29_112_emit_, table29_113_emit_, table29_114_emit_, table29_115_emit_,
    table29_116_emit_, table29_117_emit_, table29_118_emit_, table29_119_emit_,
    table29_120_emit_, table29_121_emit_, table29_122_emit_, table29_123_emit_,
    table29_124_emit_, table29_125_emit_, table29_126_emit_, table29_127_emit_,
};
const uint16_t* const HuffDecoderCommon::table29_inner_[128] = {
    table29_0_inner_,   table29_1_inner_,   table29_0_inner_,
    table29_1_inner_,   table29_0_inner_,   table29_1_inner_,
    table29_0_inner_,   table29_1_inner_,   table29_0_inner_,
    table29_1_inner_,   table29_0_inner_,   table29_1_inner_,
    table29_0_inner_,   table29_1_inner_,   table29_0_inner_,
    table29_1_inner_,   table29_0_inner_,   table29_1_inner_,
    table29_0_inner_,   table29_1_inner_,   table29_20_inner_,
    table29_20_inner_,  table29_20_inner_,  table29_20_inner_,
    table29_20_inner_,  table29_20_inner_,  table29_20_inner_,
    table29_20_inner_,  table29_20_inner_,  table29_20_inner_,
    table29_20_inner_,  table29_20_inner_,  table29_20_inner_,
    table29_20_inner_,  table29_20_inner_,  table29_20_inner_,
    table29_20_inner_,  table29_20_inner_,  table29_20_inner_,
    table29_20_inner_,  table29_20_inner_,  table29_20_inner_,
    table29_20_inner_,  table29_20_inner_,  table29_20_inner_,
    table29_20_inner_,  table29_46_inner_,  table29_46_inner_,
    table29_46_inner_,  table29_46_inner_,  table29_46_inner_,
    table29_46_inner_,  table29_46_inner_,  table29_46_inner_,
    table29_46_inner_,  table29_46_inner_,  table29_46_inner_,
    table29_46_inner_,  table29_46_inner_,  table29_46_inner_,
    table29_46_inner_,  table29_46_inner_,  table29_62_inner_,
    table29_63_inner_,  table29_64_inner_,  table29_65_inner_,
    table29_66_inner_,  table29_67_inner_,  table29_64_inner_,
    table29_65_inner_,  table29_66_inner_,  table29_67_inner_,
    table29_64_inner_,  table29_65_inner_,  table29_66_inner_,
    table29_67_inner_,  table29_76_inner_,  table29_77_inner_,
    table29_76_inner_,  table29_77_inner_,  table29_76_inner_,
    table29_77_inner_,  table29_76_inner_,  table29_77_inner_,
    table29_76_inner_,  table29_77_inner_,  table29_76_inner_,
    table29_77_inner_,  table29_76_inner_,  table29_77_inner_,
    table29_76_inner_,  table29_77_inner_,  table29_92_inner_,
    table29_92_inner_,  table29_92_inner_,  table29_92_inner_,
    table29_92_inner_,  table29_92_inner_,  table29_92_inner_,
    table29_92_inner_,  table29_92_inner_,  table29_92_inner_,
    table29_92_inner_,  table29_92_inner_,  table29_92_inner_,
    table29_105_inner_, table29_105_inner_, table29_105_inner_,
    table29_105_inner_, table29_105_inner_, table29_105_inner_,
    table29_105_inner_, table29_105_inner_, table29_105_inner_,
    table29_105_inner_, table29_105_inner_, table29_105_inner_,
    table29_105_inner_, table29_118_inner_, table29_118_inner_,
    table29_118_inner_, table29_118_inner_, table29_118_inner_,
    table29_118_inner_, table29_118_inner_, table29_125_inner_,
    table29_126_inner_, table29_127_inner_,
};
const uint8_t* const HuffDecoderCommon::table29_outer_[128] = {
    table29_0_outer_,   table29_1_outer_,   table29_0_outer_,
    table29_1_outer_,   table29_0_outer_,   table29_1_outer_,
    table29_0_outer_,   table29_1_outer_,   table29_0_outer_,
    table29_1_outer_,   table29_0_outer_,   table29_1_outer_,
    table29_0_outer_,   table29_1_outer_,   table29_0_outer_,
    table29_1_outer_,   table29_0_outer_,   table29_1_outer_,
    table29_0_outer_,   table29_1_outer_,   table29_20_outer_,
    table29_20_outer_,  table29_20_outer_,  table29_20_outer_,
    table29_20_outer_,  table29_20_outer_,  table29_20_outer_,
    table29_20_outer_,  table29_20_outer_,  table29_20_outer_,
    table29_20_outer_,  table29_20_outer_,  table29_20_outer_,
    table29_20_outer_,  table29_20_outer_,  table29_20_outer_,
    table29_20_outer_,  table29_20_outer_,  table29_20_outer_,
    table29_20_outer_,  table29_20_outer_,  table29_20_outer_,
    table29_20_outer_,  table29_20_outer_,  table29_20_outer_,
    table29_20_outer_,  table29_46_outer_,  table29_46_outer_,
    table29_46_outer_,  table29_46_outer_,  table29_46_outer_,
    table29_46_outer_,  table29_46_outer_,  table29_46_outer_,
    table29_46_outer_,  table29_46_outer_,  table29_46_outer_,
    table29_46_outer_,  table29_46_outer_,  table29_46_outer_,
    table29_46_outer_,  table29_46_outer_,  table29_62_outer_,
    table29_63_outer_,  table29_64_outer_,  table29_65_outer_,
    table29_66_outer_,  table29_67_outer_,  table29_64_outer_,
    table29_65_outer_,  table29_66_outer_,  table29_67_outer_,
    table29_64_outer_,  table29_65_outer_,  table29_66_outer_,
    table29_67_outer_,  table29_0_outer_,   table29_1_outer_,
    table29_0_outer_,   table29_1_outer_,   table29_0_outer_,
    table29_1_outer_,   table29_0_outer_,   table29_1_outer_,
    table29_0_outer_,   table29_1_outer_,   table29_0_outer_,
    table29_1_outer_,   table29_0_outer_,   table29_1_outer_,
    table29_0_outer_,   table29_1_outer_,   table29_20_outer_,
    table29_20_outer_,  table29_20_outer_,  table29_20_outer_,
    table29_20_outer_,  table29_20_outer_,  table29_20_outer_,
    table29_20_outer_,  table29_20_outer_,  table29_20_outer_,
    table29_20_outer_,  table29_20_outer_,  table29_20_outer_,
    table29_46_outer_,  table29_46_outer_,  table29_46_outer_,
    table29_46_outer_,  table29_46_outer_,  table29_46_outer_,
    table29_46_outer_,  table29_46_outer_,  table29_46_outer_,
    table29_46_outer_,  table29_46_outer_,  table29_46_outer_,
    table29_46_outer_,  table29_62_outer_,  table29_62_outer_,
    table29_62_outer_,  table29_62_outer_,  table29_62_outer_,
    table29_62_outer_,  table29_62_outer_,  table29_125_outer_,
    table29_126_outer_, table29_127_outer_,
};
const uint8_t HuffDecoderCommon::table30_0_outer_[256] = {
    0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 1,  0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 3,
    0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 4,  0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 5,  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 6,
    0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 7,  0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 8,  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 9,
    0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 11,
    0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 0, 0, 0, 14,
    0, 0, 0, 0, 0, 0, 0, 15, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 17,
    0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 19, 0, 0, 0, 0, 0, 0, 0, 20,
    0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 22};
const uint8_t HuffDecoderCommon::table30_1_outer_[256] = {
    0, 0,  0, 0,  0, 0,  0, 1,  0, 0,  0, 0,  0, 0,  0, 2,  0, 0,  0, 0,  0, 0,
    0, 3,  0, 0,  0, 0,  0, 0,  0, 4,  0, 0,  0, 0,  0, 0,  0, 5,  0, 0,  0, 0,
    0, 0,  0, 6,  0, 0,  0, 0,  0, 0,  0, 7,  0, 0,  0, 0,  0, 0,  0, 8,  0, 0,
    0, 0,  0, 0,  0, 9,  0, 0,  0, 0,  0, 0,  0, 10, 0, 0,  0, 0,  0, 0,  0, 11,
    0, 0,  0, 0,  0, 0,  0, 12, 0, 0,  0, 0,  0, 0,  0, 13, 0, 0,  0, 0,  0, 0,
    0, 14, 0, 0,  0, 15, 0, 0,  0, 16, 0, 0,  0, 17, 0, 0,  0, 18, 0, 0,  0, 19,
    0, 0,  0, 20, 0, 0,  0, 21, 0, 0,  0, 22, 0, 0,  0, 23, 0, 0,  0, 24, 0, 0,
    0, 25, 0, 0,  0, 26, 0, 0,  0, 27, 0, 0,  0, 28, 0, 0,  0, 29, 0, 0,  0, 30,
    0, 0,  0, 31, 0, 0,  0, 32, 0, 0,  0, 33, 0, 0,  0, 34, 0, 0,  0, 35, 0, 0,
    0, 36, 0, 0,  0, 37, 0, 0,  0, 38, 0, 0,  0, 39, 0, 0,  0, 40, 0, 0,  0, 41,
    0, 0,  0, 42, 0, 0,  0, 43, 0, 0,  0, 44, 0, 0,  0, 45, 0, 0,  0, 46, 0, 47,
    0, 48, 0, 49, 0, 50, 0, 51, 0, 52, 0, 0,  0, 53};
const uint8_t HuffDecoderCommon::table30_20_emit_[222] = {
    0x7b, 0x20, 0x30, 0x7b, 0x20, 0x31, 0x7b, 0x20, 0x32, 0x7b, 0x20, 0x61,
    0x7b, 0x20, 0x63, 0x7b, 0x20, 0x65, 0x7b, 0x20, 0x69, 0x7b, 0x20, 0x6f,
    0x7b, 0x20, 0x73, 0x7b, 0x20, 0x74, 0x7b, 0x20, 0x20, 0x7b, 0x20, 0x25,
    0x7b, 0x20, 0x2d, 0x7b, 0x20, 0x2e, 0x7b, 0x20, 0x2f, 0x7b, 0x20, 0x33,
    0x7b, 0x20, 0x34, 0x7b, 0x20, 0x35, 0x7b, 0x20, 0x36, 0x7b, 0x20, 0x37,
    0x7b, 0x20, 0x38, 0x7b, 0x20, 0x39, 0x7b, 0x20, 0x3d, 0x7b, 0x20, 0x41,
    0x7b, 0x20, 0x5f, 0x7b, 0x20, 0x62, 0x7b, 0x20, 0x64, 0x7b, 0x20, 0x66,
    0x7b, 0x20, 0x67, 0x7b, 0x20, 0x68, 0x7b, 0x20, 0x6c, 0x7b, 0x20, 0x6d,
    0x7b, 0x20, 0x6e, 0x7b, 0x20, 0x70, 0x7b, 0x20, 0x72, 0x7b, 0x20, 0x75,
    0x7b, 0x20, 0x3a, 0x7b, 0x20, 0x42, 0x7b, 0x20, 0x43, 0x7b, 0x20, 0x44,
    0x7b, 0x20, 0x45, 0x7b, 0x20, 0x46, 0x7b, 0x20, 0x47, 0x7b, 0x20, 0x48,
    0x7b, 0x20, 0x49, 0x7b, 0x20, 0x4a, 0x7b, 0x20, 0x4b, 0x7b, 0x20, 0x4c,
    0x7b, 0x20, 0x4d, 0x7b, 0x20, 0x4e, 0x7b, 0x20, 0x4f, 0x7b, 0x20, 0x50,
    0x7b, 0x20, 0x51, 0x7b, 0x20, 0x52, 0x7b, 0x20, 0x53, 0x7b, 0x20, 0x54,
    0x7b, 0x20, 0x55, 0x7b, 0x20, 0x56, 0x7b, 0x20, 0x57, 0x7b, 0x20, 0x59,
    0x7b, 0x20, 0x6a, 0x7b, 0x20, 0x6b, 0x7b, 0x20, 0x71, 0x7b, 0x20, 0x76,
    0x7b, 0x20, 0x77, 0x7b, 0x20, 0x78, 0x7b, 0x20, 0x79, 0x7b, 0x20, 0x7a,
    0x7b, 0x20, 0x26, 0x7b, 0x20, 0x2a, 0x7b, 0x20, 0x2c, 0x7b, 0x20, 0x3b,
    0x7b, 0x20, 0x58, 0x7b, 0x20, 0x5a};
const uint16_t HuffDecoderCommon::table30_20_inner_[76] = {
    0x0000, 0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9,
    0x00c1, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169, 0x0181,
    0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259,
    0x0271, 0x0289, 0x02a1, 0x02b9, 0x02d1, 0x02e9, 0x0301, 0x0319, 0x0331,
    0x0349, 0x0361, 0x0379, 0x0391, 0x03a9, 0x03c1, 0x03d9, 0x03f1, 0x0409,
    0x0421, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9, 0x04e1,
    0x04f9, 0x0511, 0x0529, 0x0541, 0x0559, 0x0571, 0x0589, 0x05a1, 0x05b9,
    0x05d1, 0x05e9, 0x0601, 0x0619, 0x0631, 0x0649, 0x0661, 0x0679, 0x0691,
    0x06a9, 0x06c1, 0x06d9, 0x0002};
const uint8_t HuffDecoderCommon::table30_20_outer_[256] = {
    0, 0,  0, 0,  0, 0,  0, 1,  0,  0,  0,  0,  0,  0,  0, 2,  0, 0,  0, 0,
    0, 0,  0, 3,  0, 0,  0, 0,  0,  0,  0,  4,  0,  0,  0, 0,  0, 0,  0, 5,
    0, 0,  0, 0,  0, 0,  0, 6,  0,  0,  0,  0,  0,  0,  0, 7,  0, 0,  0, 0,
    0, 0,  0, 8,  0, 0,  0, 0,  0,  0,  0,  9,  0,  0,  0, 0,  0, 0,  0, 10,
    0, 0,  0, 11, 0, 0,  0, 12, 0,  0,  0,  13, 0,  0,  0, 14, 0, 0,  0, 15,
    0, 0,  0, 16, 0, 0,  0, 17, 0,  0,  0,  18, 0,  0,  0, 19, 0, 0,  0, 20,
    0, 0,  0, 21, 0, 0,  0, 22, 0,  0,  0,  23, 0,  0,  0, 24, 0, 0,  0, 25,
    0, 0,  0, 26, 0, 0,  0, 27, 0,  0,  0,  28, 0,  0,  0, 29, 0, 0,  0, 30,
    0, 0,  0, 31, 0, 0,  0, 32, 0,  0,  0,  33, 0,  0,  0, 34, 0, 0,  0, 35,
    0, 0,  0, 36, 0, 37, 0, 38, 0,  39, 0,  40, 0,  41, 0, 42, 0, 43, 0, 44,
    0, 45, 0, 46, 0, 47, 0, 48, 0,  49, 0,  50, 0,  51, 0, 52, 0, 53, 0, 54,
    0, 55, 0, 56, 0, 57, 0, 58, 0,  59, 0,  60, 0,  61, 0, 62, 0, 63, 0, 64,
    0, 65, 0, 66, 0, 67, 0, 68, 69, 70, 71, 72, 73, 74, 0, 75};
const uint8_t HuffDecoderCommon::table30_21_emit_[222] = {
    0x7b, 0x25, 0x30, 0x7b, 0x25, 0x31, 0x7b, 0x25, 0x32, 0x7b, 0x25, 0x61,
    0x7b, 0x25, 0x63, 0x7b, 0x25, 0x65, 0x7b, 0x25, 0x69, 0x7b, 0x25, 0x6f,
    0x7b, 0x25, 0x73, 0x7b, 0x25, 0x74, 0x7b, 0x25, 0x20, 0x7b, 0x25, 0x25,
    0x7b, 0x25, 0x2d, 0x7b, 0x25, 0x2e, 0x7b, 0x25, 0x2f, 0x7b, 0x25, 0x33,
    0x7b, 0x25, 0x34, 0x7b, 0x25, 0x35, 0x7b, 0x25, 0x36, 0x7b, 0x25, 0x37,
    0x7b, 0x25, 0x38, 0x7b, 0x25, 0x39, 0x7b, 0x25, 0x3d, 0x7b, 0x25, 0x41,
    0x7b, 0x25, 0x5f, 0x7b, 0x25, 0x62, 0x7b, 0x25, 0x64, 0x7b, 0x25, 0x66,
    0x7b, 0x25, 0x67, 0x7b, 0x25, 0x68, 0x7b, 0x25, 0x6c, 0x7b, 0x25, 0x6d,
    0x7b, 0x25, 0x6e, 0x7b, 0x25, 0x70, 0x7b, 0x25, 0x72, 0x7b, 0x25, 0x75,
    0x7b, 0x25, 0x3a, 0x7b, 0x25, 0x42, 0x7b, 0x25, 0x43, 0x7b, 0x25, 0x44,
    0x7b, 0x25, 0x45, 0x7b, 0x25, 0x46, 0x7b, 0x25, 0x47, 0x7b, 0x25, 0x48,
    0x7b, 0x25, 0x49, 0x7b, 0x25, 0x4a, 0x7b, 0x25, 0x4b, 0x7b, 0x25, 0x4c,
    0x7b, 0x25, 0x4d, 0x7b, 0x25, 0x4e, 0x7b, 0x25, 0x4f, 0x7b, 0x25, 0x50,
    0x7b, 0x25, 0x51, 0x7b, 0x25, 0x52, 0x7b, 0x25, 0x53, 0x7b, 0x25, 0x54,
    0x7b, 0x25, 0x55, 0x7b, 0x25, 0x56, 0x7b, 0x25, 0x57, 0x7b, 0x25, 0x59,
    0x7b, 0x25, 0x6a, 0x7b, 0x25, 0x6b, 0x7b, 0x25, 0x71, 0x7b, 0x25, 0x76,
    0x7b, 0x25, 0x77, 0x7b, 0x25, 0x78, 0x7b, 0x25, 0x79, 0x7b, 0x25, 0x7a,
    0x7b, 0x25, 0x26, 0x7b, 0x25, 0x2a, 0x7b, 0x25, 0x2c, 0x7b, 0x25, 0x3b,
    0x7b, 0x25, 0x58, 0x7b, 0x25, 0x5a};
const uint8_t HuffDecoderCommon::table30_22_emit_[222] = {
    0x7b, 0x2d, 0x30, 0x7b, 0x2d, 0x31, 0x7b, 0x2d, 0x32, 0x7b, 0x2d, 0x61,
    0x7b, 0x2d, 0x63, 0x7b, 0x2d, 0x65, 0x7b, 0x2d, 0x69, 0x7b, 0x2d, 0x6f,
    0x7b, 0x2d, 0x73, 0x7b, 0x2d, 0x74, 0x7b, 0x2d, 0x20, 0x7b, 0x2d, 0x25,
    0x7b, 0x2d, 0x2d, 0x7b, 0x2d, 0x2e, 0x7b, 0x2d, 0x2f, 0x7b, 0x2d, 0x33,
    0x7b, 0x2d, 0x34, 0x7b, 0x2d, 0x35, 0x7b, 0x2d, 0x36, 0x7b, 0x2d, 0x37,
    0x7b, 0x2d, 0x38, 0x7b, 0x2d, 0x39, 0x7b, 0x2d, 0x3d, 0x7b, 0x2d, 0x41,
    0x7b, 0x2d, 0x5f, 0x7b, 0x2d, 0x62, 0x7b, 0x2d, 0x64, 0x7b, 0x2d, 0x66,
    0x7b, 0x2d, 0x67, 0x7b, 0x2d, 0x68, 0x7b, 0x2d, 0x6c, 0x7b, 0x2d, 0x6d,
    0x7b, 0x2d, 0x6e, 0x7b, 0x2d, 0x70, 0x7b, 0x2d, 0x72, 0x7b, 0x2d, 0x75,
    0x7b, 0x2d, 0x3a, 0x7b, 0x2d, 0x42, 0x7b, 0x2d, 0x43, 0x7b, 0x2d, 0x44,
    0x7b, 0x2d, 0x45, 0x7b, 0x2d, 0x46, 0x7b, 0x2d, 0x47, 0x7b, 0x2d, 0x48,
    0x7b, 0x2d, 0x49, 0x7b, 0x2d, 0x4a, 0x7b, 0x2d, 0x4b, 0x7b, 0x2d, 0x4c,
    0x7b, 0x2d, 0x4d, 0x7b, 0x2d, 0x4e, 0x7b, 0x2d, 0x4f, 0x7b, 0x2d, 0x50,
    0x7b, 0x2d, 0x51, 0x7b, 0x2d, 0x52, 0x7b, 0x2d, 0x53, 0x7b, 0x2d, 0x54,
    0x7b, 0x2d, 0x55, 0x7b, 0x2d, 0x56, 0x7b, 0x2d, 0x57, 0x7b, 0x2d, 0x59,
    0x7b, 0x2d, 0x6a, 0x7b, 0x2d, 0x6b, 0x7b, 0x2d, 0x71, 0x7b, 0x2d, 0x76,
    0x7b, 0x2d, 0x77, 0x7b, 0x2d, 0x78, 0x7b, 0x2d, 0x79, 0x7b, 0x2d, 0x7a,
    0x7b, 0x2d, 0x26, 0x7b, 0x2d, 0x2a, 0x7b, 0x2d, 0x2c, 0x7b, 0x2d, 0x3b,
    0x7b, 0x2d, 0x58, 0x7b, 0x2d, 0x5a};
const uint8_t HuffDecoderCommon::table30_23_emit_[222] = {
    0x7b, 0x2e, 0x30, 0x7b, 0x2e, 0x31, 0x7b, 0x2e, 0x32, 0x7b, 0x2e, 0x61,
    0x7b, 0x2e, 0x63, 0x7b, 0x2e, 0x65, 0x7b, 0x2e, 0x69, 0x7b, 0x2e, 0x6f,
    0x7b, 0x2e, 0x73, 0x7b, 0x2e, 0x74, 0x7b, 0x2e, 0x20, 0x7b, 0x2e, 0x25,
    0x7b, 0x2e, 0x2d, 0x7b, 0x2e, 0x2e, 0x7b, 0x2e, 0x2f, 0x7b, 0x2e, 0x33,
    0x7b, 0x2e, 0x34, 0x7b, 0x2e, 0x35, 0x7b, 0x2e, 0x36, 0x7b, 0x2e, 0x37,
    0x7b, 0x2e, 0x38, 0x7b, 0x2e, 0x39, 0x7b, 0x2e, 0x3d, 0x7b, 0x2e, 0x41,
    0x7b, 0x2e, 0x5f, 0x7b, 0x2e, 0x62, 0x7b, 0x2e, 0x64, 0x7b, 0x2e, 0x66,
    0x7b, 0x2e, 0x67, 0x7b, 0x2e, 0x68, 0x7b, 0x2e, 0x6c, 0x7b, 0x2e, 0x6d,
    0x7b, 0x2e, 0x6e, 0x7b, 0x2e, 0x70, 0x7b, 0x2e, 0x72, 0x7b, 0x2e, 0x75,
    0x7b, 0x2e, 0x3a, 0x7b, 0x2e, 0x42, 0x7b, 0x2e, 0x43, 0x7b, 0x2e, 0x44,
    0x7b, 0x2e, 0x45, 0x7b, 0x2e, 0x46, 0x7b, 0x2e, 0x47, 0x7b, 0x2e, 0x48,
    0x7b, 0x2e, 0x49, 0x7b, 0x2e, 0x4a, 0x7b, 0x2e, 0x4b, 0x7b, 0x2e, 0x4c,
    0x7b, 0x2e, 0x4d, 0x7b, 0x2e, 0x4e, 0x7b, 0x2e, 0x4f, 0x7b, 0x2e, 0x50,
    0x7b, 0x2e, 0x51, 0x7b, 0x2e, 0x52, 0x7b, 0x2e, 0x53, 0x7b, 0x2e, 0x54,
    0x7b, 0x2e, 0x55, 0x7b, 0x2e, 0x56, 0x7b, 0x2e, 0x57, 0x7b, 0x2e, 0x59,
    0x7b, 0x2e, 0x6a, 0x7b, 0x2e, 0x6b, 0x7b, 0x2e, 0x71, 0x7b, 0x2e, 0x76,
    0x7b, 0x2e, 0x77, 0x7b, 0x2e, 0x78, 0x7b, 0x2e, 0x79, 0x7b, 0x2e, 0x7a,
    0x7b, 0x2e, 0x26, 0x7b, 0x2e, 0x2a, 0x7b, 0x2e, 0x2c, 0x7b, 0x2e, 0x3b,
    0x7b, 0x2e, 0x58, 0x7b, 0x2e, 0x5a};
const uint8_t HuffDecoderCommon::table30_24_emit_[222] = {
    0x7b, 0x2f, 0x30, 0x7b, 0x2f, 0x31, 0x7b, 0x2f, 0x32, 0x7b, 0x2f, 0x61,
    0x7b, 0x2f, 0x63, 0x7b, 0x2f, 0x65, 0x7b, 0x2f, 0x69, 0x7b, 0x2f, 0x6f,
    0x7b, 0x2f, 0x73, 0x7b, 0x2f, 0x74, 0x7b, 0x2f, 0x20, 0x7b, 0x2f, 0x25,
    0x7b, 0x2f, 0x2d, 0x7b, 0x2f, 0x2e, 0x7b, 0x2f, 0x2f, 0x7b, 0x2f, 0x33,
    0x7b, 0x2f, 0x34, 0x7b, 0x2f, 0x35, 0x7b, 0x2f, 0x36, 0x7b, 0x2f, 0x37,
    0x7b, 0x2f, 0x38, 0x7b, 0x2f, 0x39, 0x7b, 0x2f, 0x3d, 0x7b, 0x2f, 0x41,
    0x7b, 0x2f, 0x5f, 0x7b, 0x2f, 0x62, 0x7b, 0x2f, 0x64, 0x7b, 0x2f, 0x66,
    0x7b, 0x2f, 0x67, 0x7b, 0x2f, 0x68, 0x7b, 0x2f, 0x6c, 0x7b, 0x2f, 0x6d,
    0x7b, 0x2f, 0x6e, 0x7b, 0x2f, 0x70, 0x7b, 0x2f, 0x72, 0x7b, 0x2f, 0x75,
    0x7b, 0x2f, 0x3a, 0x7b, 0x2f, 0x42, 0x7b, 0x2f, 0x43, 0x7b, 0x2f, 0x44,
    0x7b, 0x2f, 0x45, 0x7b, 0x2f, 0x46, 0x7b, 0x2f, 0x47, 0x7b, 0x2f, 0x48,
    0x7b, 0x2f, 0x49, 0x7b, 0x2f, 0x4a, 0x7b, 0x2f, 0x4b, 0x7b, 0x2f, 0x4c,
    0x7b, 0x2f, 0x4d, 0x7b, 0x2f, 0x4e, 0x7b, 0x2f, 0x4f, 0x7b, 0x2f, 0x50,
    0x7b, 0x2f, 0x51, 0x7b, 0x2f, 0x52, 0x7b, 0x2f, 0x53, 0x7b, 0x2f, 0x54,
    0x7b, 0x2f, 0x55, 0x7b, 0x2f, 0x56, 0x7b, 0x2f, 0x57, 0x7b, 0x2f, 0x59,
    0x7b, 0x2f, 0x6a, 0x7b, 0x2f, 0x6b, 0x7b, 0x2f, 0x71, 0x7b, 0x2f, 0x76,
    0x7b, 0x2f, 0x77, 0x7b, 0x2f, 0x78, 0x7b, 0x2f, 0x79, 0x7b, 0x2f, 0x7a,
    0x7b, 0x2f, 0x26, 0x7b, 0x2f, 0x2a, 0x7b, 0x2f, 0x2c, 0x7b, 0x2f, 0x3b,
    0x7b, 0x2f, 0x58, 0x7b, 0x2f, 0x5a};
const uint8_t HuffDecoderCommon::table30_25_emit_[222] = {
    0x7b, 0x33, 0x30, 0x7b, 0x33, 0x31, 0x7b, 0x33, 0x32, 0x7b, 0x33, 0x61,
    0x7b, 0x33, 0x63, 0x7b, 0x33, 0x65, 0x7b, 0x33, 0x69, 0x7b, 0x33, 0x6f,
    0x7b, 0x33, 0x73, 0x7b, 0x33, 0x74, 0x7b, 0x33, 0x20, 0x7b, 0x33, 0x25,
    0x7b, 0x33, 0x2d, 0x7b, 0x33, 0x2e, 0x7b, 0x33, 0x2f, 0x7b, 0x33, 0x33,
    0x7b, 0x33, 0x34, 0x7b, 0x33, 0x35, 0x7b, 0x33, 0x36, 0x7b, 0x33, 0x37,
    0x7b, 0x33, 0x38, 0x7b, 0x33, 0x39, 0x7b, 0x33, 0x3d, 0x7b, 0x33, 0x41,
    0x7b, 0x33, 0x5f, 0x7b, 0x33, 0x62, 0x7b, 0x33, 0x64, 0x7b, 0x33, 0x66,
    0x7b, 0x33, 0x67, 0x7b, 0x33, 0x68, 0x7b, 0x33, 0x6c, 0x7b, 0x33, 0x6d,
    0x7b, 0x33, 0x6e, 0x7b, 0x33, 0x70, 0x7b, 0x33, 0x72, 0x7b, 0x33, 0x75,
    0x7b, 0x33, 0x3a, 0x7b, 0x33, 0x42, 0x7b, 0x33, 0x43, 0x7b, 0x33, 0x44,
    0x7b, 0x33, 0x45, 0x7b, 0x33, 0x46, 0x7b, 0x33, 0x47, 0x7b, 0x33, 0x48,
    0x7b, 0x33, 0x49, 0x7b, 0x33, 0x4a, 0x7b, 0x33, 0x4b, 0x7b, 0x33, 0x4c,
    0x7b, 0x33, 0x4d, 0x7b, 0x33, 0x4e, 0x7b, 0x33, 0x4f, 0x7b, 0x33, 0x50,
    0x7b, 0x33, 0x51, 0x7b, 0x33, 0x52, 0x7b, 0x33, 0x53, 0x7b, 0x33, 0x54,
    0x7b, 0x33, 0x55, 0x7b, 0x33, 0x56, 0x7b, 0x33, 0x57, 0x7b, 0x33, 0x59,
    0x7b, 0x33, 0x6a, 0x7b, 0x33, 0x6b, 0x7b, 0x33, 0x71, 0x7b, 0x33, 0x76,
    0x7b, 0x33, 0x77, 0x7b, 0x33, 0x78, 0x7b, 0x33, 0x79, 0x7b, 0x33, 0x7a,
    0x7b, 0x33, 0x26, 0x7b, 0x33, 0x2a, 0x7b, 0x33, 0x2c, 0x7b, 0x33, 0x3b,
    0x7b, 0x33, 0x58, 0x7b, 0x33, 0x5a};
const uint8_t HuffDecoderCommon::table30_26_emit_[222] = {
    0x7b, 0x34, 0x30, 0x7b, 0x34, 0x31, 0x7b, 0x34, 0x32, 0x7b, 0x34, 0x61,
    0x7b, 0x34, 0x63, 0x7b, 0x34, 0x65, 0x7b, 0x34, 0x69, 0x7b, 0x34, 0x6f,
    0x7b, 0x34, 0x73, 0x7b, 0x34, 0x74, 0x7b, 0x34, 0x20, 0x7b, 0x34, 0x25,
    0x7b, 0x34, 0x2d, 0x7b, 0x34, 0x2e, 0x7b, 0x34, 0x2f, 0x7b, 0x34, 0x33,
    0x7b, 0x34, 0x34, 0x7b, 0x34, 0x35, 0x7b, 0x34, 0x36, 0x7b, 0x34, 0x37,
    0x7b, 0x34, 0x38, 0x7b, 0x34, 0x39, 0x7b, 0x34, 0x3d, 0x7b, 0x34, 0x41,
    0x7b, 0x34, 0x5f, 0x7b, 0x34, 0x62, 0x7b, 0x34, 0x64, 0x7b, 0x34, 0x66,
    0x7b, 0x34, 0x67, 0x7b, 0x34, 0x68, 0x7b, 0x34, 0x6c, 0x7b, 0x34, 0x6d,
    0x7b, 0x34, 0x6e, 0x7b, 0x34, 0x70, 0x7b, 0x34, 0x72, 0x7b, 0x34, 0x75,
    0x7b, 0x34, 0x3a, 0x7b, 0x34, 0x42, 0x7b, 0x34, 0x43, 0x7b, 0x34, 0x44,
    0x7b, 0x34, 0x45, 0x7b, 0x34, 0x46, 0x7b, 0x34, 0x47, 0x7b, 0x34, 0x48,
    0x7b, 0x34, 0x49, 0x7b, 0x34, 0x4a, 0x7b, 0x34, 0x4b, 0x7b, 0x34, 0x4c,
    0x7b, 0x34, 0x4d, 0x7b, 0x34, 0x4e, 0x7b, 0x34, 0x4f, 0x7b, 0x34, 0x50,
    0x7b, 0x34, 0x51, 0x7b, 0x34, 0x52, 0x7b, 0x34, 0x53, 0x7b, 0x34, 0x54,
    0x7b, 0x34, 0x55, 0x7b, 0x34, 0x56, 0x7b, 0x34, 0x57, 0x7b, 0x34, 0x59,
    0x7b, 0x34, 0x6a, 0x7b, 0x34, 0x6b, 0x7b, 0x34, 0x71, 0x7b, 0x34, 0x76,
    0x7b, 0x34, 0x77, 0x7b, 0x34, 0x78, 0x7b, 0x34, 0x79, 0x7b, 0x34, 0x7a,
    0x7b, 0x34, 0x26, 0x7b, 0x34, 0x2a, 0x7b, 0x34, 0x2c, 0x7b, 0x34, 0x3b,
    0x7b, 0x34, 0x58, 0x7b, 0x34, 0x5a};
const uint8_t HuffDecoderCommon::table30_27_emit_[222] = {
    0x7b, 0x35, 0x30, 0x7b, 0x35, 0x31, 0x7b, 0x35, 0x32, 0x7b, 0x35, 0x61,
    0x7b, 0x35, 0x63, 0x7b, 0x35, 0x65, 0x7b, 0x35, 0x69, 0x7b, 0x35, 0x6f,
    0x7b, 0x35, 0x73, 0x7b, 0x35, 0x74, 0x7b, 0x35, 0x20, 0x7b, 0x35, 0x25,
    0x7b, 0x35, 0x2d, 0x7b, 0x35, 0x2e, 0x7b, 0x35, 0x2f, 0x7b, 0x35, 0x33,
    0x7b, 0x35, 0x34, 0x7b, 0x35, 0x35, 0x7b, 0x35, 0x36, 0x7b, 0x35, 0x37,
    0x7b, 0x35, 0x38, 0x7b, 0x35, 0x39, 0x7b, 0x35, 0x3d, 0x7b, 0x35, 0x41,
    0x7b, 0x35, 0x5f, 0x7b, 0x35, 0x62, 0x7b, 0x35, 0x64, 0x7b, 0x35, 0x66,
    0x7b, 0x35, 0x67, 0x7b, 0x35, 0x68, 0x7b, 0x35, 0x6c, 0x7b, 0x35, 0x6d,
    0x7b, 0x35, 0x6e, 0x7b, 0x35, 0x70, 0x7b, 0x35, 0x72, 0x7b, 0x35, 0x75,
    0x7b, 0x35, 0x3a, 0x7b, 0x35, 0x42, 0x7b, 0x35, 0x43, 0x7b, 0x35, 0x44,
    0x7b, 0x35, 0x45, 0x7b, 0x35, 0x46, 0x7b, 0x35, 0x47, 0x7b, 0x35, 0x48,
    0x7b, 0x35, 0x49, 0x7b, 0x35, 0x4a, 0x7b, 0x35, 0x4b, 0x7b, 0x35, 0x4c,
    0x7b, 0x35, 0x4d, 0x7b, 0x35, 0x4e, 0x7b, 0x35, 0x4f, 0x7b, 0x35, 0x50,
    0x7b, 0x35, 0x51, 0x7b, 0x35, 0x52, 0x7b, 0x35, 0x53, 0x7b, 0x35, 0x54,
    0x7b, 0x35, 0x55, 0x7b, 0x35, 0x56, 0x7b, 0x35, 0x57, 0x7b, 0x35, 0x59,
    0x7b, 0x35, 0x6a, 0x7b, 0x35, 0x6b, 0x7b, 0x35, 0x71, 0x7b, 0x35, 0x76,
    0x7b, 0x35, 0x77, 0x7b, 0x35, 0x78, 0x7b, 0x35, 0x79, 0x7b, 0x35, 0x7a,
    0x7b, 0x35, 0x26, 0x7b, 0x35, 0x2a, 0x7b, 0x35, 0x2c, 0x7b, 0x35, 0x3b,
    0x7b, 0x35, 0x58, 0x7b, 0x35, 0x5a};
const uint8_t HuffDecoderCommon::table30_28_emit_[222] = {
    0x7b, 0x36, 0x30, 0x7b, 0x36, 0x31, 0x7b, 0x36, 0x32, 0x7b, 0x36, 0x61,
    0x7b, 0x36, 0x63, 0x7b, 0x36, 0x65, 0x7b, 0x36, 0x69, 0x7b, 0x36, 0x6f,
    0x7b, 0x36, 0x73, 0x7b, 0x36, 0x74, 0x7b, 0x36, 0x20, 0x7b, 0x36, 0x25,
    0x7b, 0x36, 0x2d, 0x7b, 0x36, 0x2e, 0x7b, 0x36, 0x2f, 0x7b, 0x36, 0x33,
    0x7b, 0x36, 0x34, 0x7b, 0x36, 0x35, 0x7b, 0x36, 0x36, 0x7b, 0x36, 0x37,
    0x7b, 0x36, 0x38, 0x7b, 0x36, 0x39, 0x7b, 0x36, 0x3d, 0x7b, 0x36, 0x41,
    0x7b, 0x36, 0x5f, 0x7b, 0x36, 0x62, 0x7b, 0x36, 0x64, 0x7b, 0x36, 0x66,
    0x7b, 0x36, 0x67, 0x7b, 0x36, 0x68, 0x7b, 0x36, 0x6c, 0x7b, 0x36, 0x6d,
    0x7b, 0x36, 0x6e, 0x7b, 0x36, 0x70, 0x7b, 0x36, 0x72, 0x7b, 0x36, 0x75,
    0x7b, 0x36, 0x3a, 0x7b, 0x36, 0x42, 0x7b, 0x36, 0x43, 0x7b, 0x36, 0x44,
    0x7b, 0x36, 0x45, 0x7b, 0x36, 0x46, 0x7b, 0x36, 0x47, 0x7b, 0x36, 0x48,
    0x7b, 0x36, 0x49, 0x7b, 0x36, 0x4a, 0x7b, 0x36, 0x4b, 0x7b, 0x36, 0x4c,
    0x7b, 0x36, 0x4d, 0x7b, 0x36, 0x4e, 0x7b, 0x36, 0x4f, 0x7b, 0x36, 0x50,
    0x7b, 0x36, 0x51, 0x7b, 0x36, 0x52, 0x7b, 0x36, 0x53, 0x7b, 0x36, 0x54,
    0x7b, 0x36, 0x55, 0x7b, 0x36, 0x56, 0x7b, 0x36, 0x57, 0x7b, 0x36, 0x59,
    0x7b, 0x36, 0x6a, 0x7b, 0x36, 0x6b, 0x7b, 0x36, 0x71, 0x7b, 0x36, 0x76,
    0x7b, 0x36, 0x77, 0x7b, 0x36, 0x78, 0x7b, 0x36, 0x79, 0x7b, 0x36, 0x7a,
    0x7b, 0x36, 0x26, 0x7b, 0x36, 0x2a, 0x7b, 0x36, 0x2c, 0x7b, 0x36, 0x3b,
    0x7b, 0x36, 0x58, 0x7b, 0x36, 0x5a};
const uint8_t HuffDecoderCommon::table30_29_emit_[222] = {
    0x7b, 0x37, 0x30, 0x7b, 0x37, 0x31, 0x7b, 0x37, 0x32, 0x7b, 0x37, 0x61,
    0x7b, 0x37, 0x63, 0x7b, 0x37, 0x65, 0x7b, 0x37, 0x69, 0x7b, 0x37, 0x6f,
    0x7b, 0x37, 0x73, 0x7b, 0x37, 0x74, 0x7b, 0x37, 0x20, 0x7b, 0x37, 0x25,
    0x7b, 0x37, 0x2d, 0x7b, 0x37, 0x2e, 0x7b, 0x37, 0x2f, 0x7b, 0x37, 0x33,
    0x7b, 0x37, 0x34, 0x7b, 0x37, 0x35, 0x7b, 0x37, 0x36, 0x7b, 0x37, 0x37,
    0x7b, 0x37, 0x38, 0x7b, 0x37, 0x39, 0x7b, 0x37, 0x3d, 0x7b, 0x37, 0x41,
    0x7b, 0x37, 0x5f, 0x7b, 0x37, 0x62, 0x7b, 0x37, 0x64, 0x7b, 0x37, 0x66,
    0x7b, 0x37, 0x67, 0x7b, 0x37, 0x68, 0x7b, 0x37, 0x6c, 0x7b, 0x37, 0x6d,
    0x7b, 0x37, 0x6e, 0x7b, 0x37, 0x70, 0x7b, 0x37, 0x72, 0x7b, 0x37, 0x75,
    0x7b, 0x37, 0x3a, 0x7b, 0x37, 0x42, 0x7b, 0x37, 0x43, 0x7b, 0x37, 0x44,
    0x7b, 0x37, 0x45, 0x7b, 0x37, 0x46, 0x7b, 0x37, 0x47, 0x7b, 0x37, 0x48,
    0x7b, 0x37, 0x49, 0x7b, 0x37, 0x4a, 0x7b, 0x37, 0x4b, 0x7b, 0x37, 0x4c,
    0x7b, 0x37, 0x4d, 0x7b, 0x37, 0x4e, 0x7b, 0x37, 0x4f, 0x7b, 0x37, 0x50,
    0x7b, 0x37, 0x51, 0x7b, 0x37, 0x52, 0x7b, 0x37, 0x53, 0x7b, 0x37, 0x54,
    0x7b, 0x37, 0x55, 0x7b, 0x37, 0x56, 0x7b, 0x37, 0x57, 0x7b, 0x37, 0x59,
    0x7b, 0x37, 0x6a, 0x7b, 0x37, 0x6b, 0x7b, 0x37, 0x71, 0x7b, 0x37, 0x76,
    0x7b, 0x37, 0x77, 0x7b, 0x37, 0x78, 0x7b, 0x37, 0x79, 0x7b, 0x37, 0x7a,
    0x7b, 0x37, 0x26, 0x7b, 0x37, 0x2a, 0x7b, 0x37, 0x2c, 0x7b, 0x37, 0x3b,
    0x7b, 0x37, 0x58, 0x7b, 0x37, 0x5a};
const uint8_t HuffDecoderCommon::table30_30_emit_[222] = {
    0x7b, 0x38, 0x30, 0x7b, 0x38, 0x31, 0x7b, 0x38, 0x32, 0x7b, 0x38, 0x61,
    0x7b, 0x38, 0x63, 0x7b, 0x38, 0x65, 0x7b, 0x38, 0x69, 0x7b, 0x38, 0x6f,
    0x7b, 0x38, 0x73, 0x7b, 0x38, 0x74, 0x7b, 0x38, 0x20, 0x7b, 0x38, 0x25,
    0x7b, 0x38, 0x2d, 0x7b, 0x38, 0x2e, 0x7b, 0x38, 0x2f, 0x7b, 0x38, 0x33,
    0x7b, 0x38, 0x34, 0x7b, 0x38, 0x35, 0x7b, 0x38, 0x36, 0x7b, 0x38, 0x37,
    0x7b, 0x38, 0x38, 0x7b, 0x38, 0x39, 0x7b, 0x38, 0x3d, 0x7b, 0x38, 0x41,
    0x7b, 0x38, 0x5f, 0x7b, 0x38, 0x62, 0x7b, 0x38, 0x64, 0x7b, 0x38, 0x66,
    0x7b, 0x38, 0x67, 0x7b, 0x38, 0x68, 0x7b, 0x38, 0x6c, 0x7b, 0x38, 0x6d,
    0x7b, 0x38, 0x6e, 0x7b, 0x38, 0x70, 0x7b, 0x38, 0x72, 0x7b, 0x38, 0x75,
    0x7b, 0x38, 0x3a, 0x7b, 0x38, 0x42, 0x7b, 0x38, 0x43, 0x7b, 0x38, 0x44,
    0x7b, 0x38, 0x45, 0x7b, 0x38, 0x46, 0x7b, 0x38, 0x47, 0x7b, 0x38, 0x48,
    0x7b, 0x38, 0x49, 0x7b, 0x38, 0x4a, 0x7b, 0x38, 0x4b, 0x7b, 0x38, 0x4c,
    0x7b, 0x38, 0x4d, 0x7b, 0x38, 0x4e, 0x7b, 0x38, 0x4f, 0x7b, 0x38, 0x50,
    0x7b, 0x38, 0x51, 0x7b, 0x38, 0x52, 0x7b, 0x38, 0x53, 0x7b, 0x38, 0x54,
    0x7b, 0x38, 0x55, 0x7b, 0x38, 0x56, 0x7b, 0x38, 0x57, 0x7b, 0x38, 0x59,
    0x7b, 0x38, 0x6a, 0x7b, 0x38, 0x6b, 0x7b, 0x38, 0x71, 0x7b, 0x38, 0x76,
    0x7b, 0x38, 0x77, 0x7b, 0x38, 0x78, 0x7b, 0x38, 0x79, 0x7b, 0x38, 0x7a,
    0x7b, 0x38, 0x26, 0x7b, 0x38, 0x2a, 0x7b, 0x38, 0x2c, 0x7b, 0x38, 0x3b,
    0x7b, 0x38, 0x58, 0x7b, 0x38, 0x5a};
const uint8_t HuffDecoderCommon::table30_31_emit_[222] = {
    0x7b, 0x39, 0x30, 0x7b, 0x39, 0x31, 0x7b, 0x39, 0x32, 0x7b, 0x39, 0x61,
    0x7b, 0x39, 0x63, 0x7b, 0x39, 0x65, 0x7b, 0x39, 0x69, 0x7b, 0x39, 0x6f,
    0x7b, 0x39, 0x73, 0x7b, 0x39, 0x74, 0x7b, 0x39, 0x20, 0x7b, 0x39, 0x25,
    0x7b, 0x39, 0x2d, 0x7b, 0x39, 0x2e, 0x7b, 0x39, 0x2f, 0x7b, 0x39, 0x33,
    0x7b, 0x39, 0x34, 0x7b, 0x39, 0x35, 0x7b, 0x39, 0x36, 0x7b, 0x39, 0x37,
    0x7b, 0x39, 0x38, 0x7b, 0x39, 0x39, 0x7b, 0x39, 0x3d, 0x7b, 0x39, 0x41,
    0x7b, 0x39, 0x5f, 0x7b, 0x39, 0x62, 0x7b, 0x39, 0x64, 0x7b, 0x39, 0x66,
    0x7b, 0x39, 0x67, 0x7b, 0x39, 0x68, 0x7b, 0x39, 0x6c, 0x7b, 0x39, 0x6d,
    0x7b, 0x39, 0x6e, 0x7b, 0x39, 0x70, 0x7b, 0x39, 0x72, 0x7b, 0x39, 0x75,
    0x7b, 0x39, 0x3a, 0x7b, 0x39, 0x42, 0x7b, 0x39, 0x43, 0x7b, 0x39, 0x44,
    0x7b, 0x39, 0x45, 0x7b, 0x39, 0x46, 0x7b, 0x39, 0x47, 0x7b, 0x39, 0x48,
    0x7b, 0x39, 0x49, 0x7b, 0x39, 0x4a, 0x7b, 0x39, 0x4b, 0x7b, 0x39, 0x4c,
    0x7b, 0x39, 0x4d, 0x7b, 0x39, 0x4e, 0x7b, 0x39, 0x4f, 0x7b, 0x39, 0x50,
    0x7b, 0x39, 0x51, 0x7b, 0x39, 0x52, 0x7b, 0x39, 0x53, 0x7b, 0x39, 0x54,
    0x7b, 0x39, 0x55, 0x7b, 0x39, 0x56, 0x7b, 0x39, 0x57, 0x7b, 0x39, 0x59,
    0x7b, 0x39, 0x6a, 0x7b, 0x39, 0x6b, 0x7b, 0x39, 0x71, 0x7b, 0x39, 0x76,
    0x7b, 0x39, 0x77, 0x7b, 0x39, 0x78, 0x7b, 0x39, 0x79, 0x7b, 0x39, 0x7a,
    0x7b, 0x39, 0x26, 0x7b, 0x39, 0x2a, 0x7b, 0x39, 0x2c, 0x7b, 0x39, 0x3b,
    0x7b, 0x39, 0x58, 0x7b, 0x39, 0x5a};
const uint8_t HuffDecoderCommon::table30_32_emit_[222] = {
    0x7b, 0x3d, 0x30, 0x7b, 0x3d, 0x31, 0x7b, 0x3d, 0x32, 0x7b, 0x3d, 0x61,
    0x7b, 0x3d, 0x63, 0x7b, 0x3d, 0x65, 0x7b, 0x3d, 0x69, 0x7b, 0x3d, 0x6f,
    0x7b, 0x3d, 0x73, 0x7b, 0x3d, 0x74, 0x7b, 0x3d, 0x20, 0x7b, 0x3d, 0x25,
    0x7b, 0x3d, 0x2d, 0x7b, 0x3d, 0x2e, 0x7b, 0x3d, 0x2f, 0x7b, 0x3d, 0x33,
    0x7b, 0x3d, 0x34, 0x7b, 0x3d, 0x35, 0x7b, 0x3d, 0x36, 0x7b, 0x3d, 0x37,
    0x7b, 0x3d, 0x38, 0x7b, 0x3d, 0x39, 0x7b, 0x3d, 0x3d, 0x7b, 0x3d, 0x41,
    0x7b, 0x3d, 0x5f, 0x7b, 0x3d, 0x62, 0x7b, 0x3d, 0x64, 0x7b, 0x3d, 0x66,
    0x7b, 0x3d, 0x67, 0x7b, 0x3d, 0x68, 0x7b, 0x3d, 0x6c, 0x7b, 0x3d, 0x6d,
    0x7b, 0x3d, 0x6e, 0x7b, 0x3d, 0x70, 0x7b, 0x3d, 0x72, 0x7b, 0x3d, 0x75,
    0x7b, 0x3d, 0x3a, 0x7b, 0x3d, 0x42, 0x7b, 0x3d, 0x43, 0x7b, 0x3d, 0x44,
    0x7b, 0x3d, 0x45, 0x7b, 0x3d, 0x46, 0x7b, 0x3d, 0x47, 0x7b, 0x3d, 0x48,
    0x7b, 0x3d, 0x49, 0x7b, 0x3d, 0x4a, 0x7b, 0x3d, 0x4b, 0x7b, 0x3d, 0x4c,
    0x7b, 0x3d, 0x4d, 0x7b, 0x3d, 0x4e, 0x7b, 0x3d, 0x4f, 0x7b, 0x3d, 0x50,
    0x7b, 0x3d, 0x51, 0x7b, 0x3d, 0x52, 0x7b, 0x3d, 0x53, 0x7b, 0x3d, 0x54,
    0x7b, 0x3d, 0x55, 0x7b, 0x3d, 0x56, 0x7b, 0x3d, 0x57, 0x7b, 0x3d, 0x59,
    0x7b, 0x3d, 0x6a, 0x7b, 0x3d, 0x6b, 0x7b, 0x3d, 0x71, 0x7b, 0x3d, 0x76,
    0x7b, 0x3d, 0x77, 0x7b, 0x3d, 0x78, 0x7b, 0x3d, 0x79, 0x7b, 0x3d, 0x7a,
    0x7b, 0x3d, 0x26, 0x7b, 0x3d, 0x2a, 0x7b, 0x3d, 0x2c, 0x7b, 0x3d, 0x3b,
    0x7b, 0x3d, 0x58, 0x7b, 0x3d, 0x5a};
const uint8_t HuffDecoderCommon::table30_33_emit_[222] = {
    0x7b, 0x41, 0x30, 0x7b, 0x41, 0x31, 0x7b, 0x41, 0x32, 0x7b, 0x41, 0x61,
    0x7b, 0x41, 0x63, 0x7b, 0x41, 0x65, 0x7b, 0x41, 0x69, 0x7b, 0x41, 0x6f,
    0x7b, 0x41, 0x73, 0x7b, 0x41, 0x74, 0x7b, 0x41, 0x20, 0x7b, 0x41, 0x25,
    0x7b, 0x41, 0x2d, 0x7b, 0x41, 0x2e, 0x7b, 0x41, 0x2f, 0x7b, 0x41, 0x33,
    0x7b, 0x41, 0x34, 0x7b, 0x41, 0x35, 0x7b, 0x41, 0x36, 0x7b, 0x41, 0x37,
    0x7b, 0x41, 0x38, 0x7b, 0x41, 0x39, 0x7b, 0x41, 0x3d, 0x7b, 0x41, 0x41,
    0x7b, 0x41, 0x5f, 0x7b, 0x41, 0x62, 0x7b, 0x41, 0x64, 0x7b, 0x41, 0x66,
    0x7b, 0x41, 0x67, 0x7b, 0x41, 0x68, 0x7b, 0x41, 0x6c, 0x7b, 0x41, 0x6d,
    0x7b, 0x41, 0x6e, 0x7b, 0x41, 0x70, 0x7b, 0x41, 0x72, 0x7b, 0x41, 0x75,
    0x7b, 0x41, 0x3a, 0x7b, 0x41, 0x42, 0x7b, 0x41, 0x43, 0x7b, 0x41, 0x44,
    0x7b, 0x41, 0x45, 0x7b, 0x41, 0x46, 0x7b, 0x41, 0x47, 0x7b, 0x41, 0x48,
    0x7b, 0x41, 0x49, 0x7b, 0x41, 0x4a, 0x7b, 0x41, 0x4b, 0x7b, 0x41, 0x4c,
    0x7b, 0x41, 0x4d, 0x7b, 0x41, 0x4e, 0x7b, 0x41, 0x4f, 0x7b, 0x41, 0x50,
    0x7b, 0x41, 0x51, 0x7b, 0x41, 0x52, 0x7b, 0x41, 0x53, 0x7b, 0x41, 0x54,
    0x7b, 0x41, 0x55, 0x7b, 0x41, 0x56, 0x7b, 0x41, 0x57, 0x7b, 0x41, 0x59,
    0x7b, 0x41, 0x6a, 0x7b, 0x41, 0x6b, 0x7b, 0x41, 0x71, 0x7b, 0x41, 0x76,
    0x7b, 0x41, 0x77, 0x7b, 0x41, 0x78, 0x7b, 0x41, 0x79, 0x7b, 0x41, 0x7a,
    0x7b, 0x41, 0x26, 0x7b, 0x41, 0x2a, 0x7b, 0x41, 0x2c, 0x7b, 0x41, 0x3b,
    0x7b, 0x41, 0x58, 0x7b, 0x41, 0x5a};
const uint8_t HuffDecoderCommon::table30_34_emit_[222] = {
    0x7b, 0x5f, 0x30, 0x7b, 0x5f, 0x31, 0x7b, 0x5f, 0x32, 0x7b, 0x5f, 0x61,
    0x7b, 0x5f, 0x63, 0x7b, 0x5f, 0x65, 0x7b, 0x5f, 0x69, 0x7b, 0x5f, 0x6f,
    0x7b, 0x5f, 0x73, 0x7b, 0x5f, 0x74, 0x7b, 0x5f, 0x20, 0x7b, 0x5f, 0x25,
    0x7b, 0x5f, 0x2d, 0x7b, 0x5f, 0x2e, 0x7b, 0x5f, 0x2f, 0x7b, 0x5f, 0x33,
    0x7b, 0x5f, 0x34, 0x7b, 0x5f, 0x35, 0x7b, 0x5f, 0x36, 0x7b, 0x5f, 0x37,
    0x7b, 0x5f, 0x38, 0x7b, 0x5f, 0x39, 0x7b, 0x5f, 0x3d, 0x7b, 0x5f, 0x41,
    0x7b, 0x5f, 0x5f, 0x7b, 0x5f, 0x62, 0x7b, 0x5f, 0x64, 0x7b, 0x5f, 0x66,
    0x7b, 0x5f, 0x67, 0x7b, 0x5f, 0x68, 0x7b, 0x5f, 0x6c, 0x7b, 0x5f, 0x6d,
    0x7b, 0x5f, 0x6e, 0x7b, 0x5f, 0x70, 0x7b, 0x5f, 0x72, 0x7b, 0x5f, 0x75,
    0x7b, 0x5f, 0x3a, 0x7b, 0x5f, 0x42, 0x7b, 0x5f, 0x43, 0x7b, 0x5f, 0x44,
    0x7b, 0x5f, 0x45, 0x7b, 0x5f, 0x46, 0x7b, 0x5f, 0x47, 0x7b, 0x5f, 0x48,
    0x7b, 0x5f, 0x49, 0x7b, 0x5f, 0x4a, 0x7b, 0x5f, 0x4b, 0x7b, 0x5f, 0x4c,
    0x7b, 0x5f, 0x4d, 0x7b, 0x5f, 0x4e, 0x7b, 0x5f, 0x4f, 0x7b, 0x5f, 0x50,
    0x7b, 0x5f, 0x51, 0x7b, 0x5f, 0x52, 0x7b, 0x5f, 0x53, 0x7b, 0x5f, 0x54,
    0x7b, 0x5f, 0x55, 0x7b, 0x5f, 0x56, 0x7b, 0x5f, 0x57, 0x7b, 0x5f, 0x59,
    0x7b, 0x5f, 0x6a, 0x7b, 0x5f, 0x6b, 0x7b, 0x5f, 0x71, 0x7b, 0x5f, 0x76,
    0x7b, 0x5f, 0x77, 0x7b, 0x5f, 0x78, 0x7b, 0x5f, 0x79, 0x7b, 0x5f, 0x7a,
    0x7b, 0x5f, 0x26, 0x7b, 0x5f, 0x2a, 0x7b, 0x5f, 0x2c, 0x7b, 0x5f, 0x3b,
    0x7b, 0x5f, 0x58, 0x7b, 0x5f, 0x5a};
const uint8_t HuffDecoderCommon::table30_35_emit_[222] = {
    0x7b, 0x62, 0x30, 0x7b, 0x62, 0x31, 0x7b, 0x62, 0x32, 0x7b, 0x62, 0x61,
    0x7b, 0x62, 0x63, 0x7b, 0x62, 0x65, 0x7b, 0x62, 0x69, 0x7b, 0x62, 0x6f,
    0x7b, 0x62, 0x73, 0x7b, 0x62, 0x74, 0x7b, 0x62, 0x20, 0x7b, 0x62, 0x25,
    0x7b, 0x62, 0x2d, 0x7b, 0x62, 0x2e, 0x7b, 0x62, 0x2f, 0x7b, 0x62, 0x33,
    0x7b, 0x62, 0x34, 0x7b, 0x62, 0x35, 0x7b, 0x62, 0x36, 0x7b, 0x62, 0x37,
    0x7b, 0x62, 0x38, 0x7b, 0x62, 0x39, 0x7b, 0x62, 0x3d, 0x7b, 0x62, 0x41,
    0x7b, 0x62, 0x5f, 0x7b, 0x62, 0x62, 0x7b, 0x62, 0x64, 0x7b, 0x62, 0x66,
    0x7b, 0x62, 0x67, 0x7b, 0x62, 0x68, 0x7b, 0x62, 0x6c, 0x7b, 0x62, 0x6d,
    0x7b, 0x62, 0x6e, 0x7b, 0x62, 0x70, 0x7b, 0x62, 0x72, 0x7b, 0x62, 0x75,
    0x7b, 0x62, 0x3a, 0x7b, 0x62, 0x42, 0x7b, 0x62, 0x43, 0x7b, 0x62, 0x44,
    0x7b, 0x62, 0x45, 0x7b, 0x62, 0x46, 0x7b, 0x62, 0x47, 0x7b, 0x62, 0x48,
    0x7b, 0x62, 0x49, 0x7b, 0x62, 0x4a, 0x7b, 0x62, 0x4b, 0x7b, 0x62, 0x4c,
    0x7b, 0x62, 0x4d, 0x7b, 0x62, 0x4e, 0x7b, 0x62, 0x4f, 0x7b, 0x62, 0x50,
    0x7b, 0x62, 0x51, 0x7b, 0x62, 0x52, 0x7b, 0x62, 0x53, 0x7b, 0x62, 0x54,
    0x7b, 0x62, 0x55, 0x7b, 0x62, 0x56, 0x7b, 0x62, 0x57, 0x7b, 0x62, 0x59,
    0x7b, 0x62, 0x6a, 0x7b, 0x62, 0x6b, 0x7b, 0x62, 0x71, 0x7b, 0x62, 0x76,
    0x7b, 0x62, 0x77, 0x7b, 0x62, 0x78, 0x7b, 0x62, 0x79, 0x7b, 0x62, 0x7a,
    0x7b, 0x62, 0x26, 0x7b, 0x62, 0x2a, 0x7b, 0x62, 0x2c, 0x7b, 0x62, 0x3b,
    0x7b, 0x62, 0x58, 0x7b, 0x62, 0x5a};
const uint8_t HuffDecoderCommon::table30_36_emit_[222] = {
    0x7b, 0x64, 0x30, 0x7b, 0x64, 0x31, 0x7b, 0x64, 0x32, 0x7b, 0x64, 0x61,
    0x7b, 0x64, 0x63, 0x7b, 0x64, 0x65, 0x7b, 0x64, 0x69, 0x7b, 0x64, 0x6f,
    0x7b, 0x64, 0x73, 0x7b, 0x64, 0x74, 0x7b, 0x64, 0x20, 0x7b, 0x64, 0x25,
    0x7b, 0x64, 0x2d, 0x7b, 0x64, 0x2e, 0x7b, 0x64, 0x2f, 0x7b, 0x64, 0x33,
    0x7b, 0x64, 0x34, 0x7b, 0x64, 0x35, 0x7b, 0x64, 0x36, 0x7b, 0x64, 0x37,
    0x7b, 0x64, 0x38, 0x7b, 0x64, 0x39, 0x7b, 0x64, 0x3d, 0x7b, 0x64, 0x41,
    0x7b, 0x64, 0x5f, 0x7b, 0x64, 0x62, 0x7b, 0x64, 0x64, 0x7b, 0x64, 0x66,
    0x7b, 0x64, 0x67, 0x7b, 0x64, 0x68, 0x7b, 0x64, 0x6c, 0x7b, 0x64, 0x6d,
    0x7b, 0x64, 0x6e, 0x7b, 0x64, 0x70, 0x7b, 0x64, 0x72, 0x7b, 0x64, 0x75,
    0x7b, 0x64, 0x3a, 0x7b, 0x64, 0x42, 0x7b, 0x64, 0x43, 0x7b, 0x64, 0x44,
    0x7b, 0x64, 0x45, 0x7b, 0x64, 0x46, 0x7b, 0x64, 0x47, 0x7b, 0x64, 0x48,
    0x7b, 0x64, 0x49, 0x7b, 0x64, 0x4a, 0x7b, 0x64, 0x4b, 0x7b, 0x64, 0x4c,
    0x7b, 0x64, 0x4d, 0x7b, 0x64, 0x4e, 0x7b, 0x64, 0x4f, 0x7b, 0x64, 0x50,
    0x7b, 0x64, 0x51, 0x7b, 0x64, 0x52, 0x7b, 0x64, 0x53, 0x7b, 0x64, 0x54,
    0x7b, 0x64, 0x55, 0x7b, 0x64, 0x56, 0x7b, 0x64, 0x57, 0x7b, 0x64, 0x59,
    0x7b, 0x64, 0x6a, 0x7b, 0x64, 0x6b, 0x7b, 0x64, 0x71, 0x7b, 0x64, 0x76,
    0x7b, 0x64, 0x77, 0x7b, 0x64, 0x78, 0x7b, 0x64, 0x79, 0x7b, 0x64, 0x7a,
    0x7b, 0x64, 0x26, 0x7b, 0x64, 0x2a, 0x7b, 0x64, 0x2c, 0x7b, 0x64, 0x3b,
    0x7b, 0x64, 0x58, 0x7b, 0x64, 0x5a};
const uint8_t HuffDecoderCommon::table30_37_emit_[222] = {
    0x7b, 0x66, 0x30, 0x7b, 0x66, 0x31, 0x7b, 0x66, 0x32, 0x7b, 0x66, 0x61,
    0x7b, 0x66, 0x63, 0x7b, 0x66, 0x65, 0x7b, 0x66, 0x69, 0x7b, 0x66, 0x6f,
    0x7b, 0x66, 0x73, 0x7b, 0x66, 0x74, 0x7b, 0x66, 0x20, 0x7b, 0x66, 0x25,
    0x7b, 0x66, 0x2d, 0x7b, 0x66, 0x2e, 0x7b, 0x66, 0x2f, 0x7b, 0x66, 0x33,
    0x7b, 0x66, 0x34, 0x7b, 0x66, 0x35, 0x7b, 0x66, 0x36, 0x7b, 0x66, 0x37,
    0x7b, 0x66, 0x38, 0x7b, 0x66, 0x39, 0x7b, 0x66, 0x3d, 0x7b, 0x66, 0x41,
    0x7b, 0x66, 0x5f, 0x7b, 0x66, 0x62, 0x7b, 0x66, 0x64, 0x7b, 0x66, 0x66,
    0x7b, 0x66, 0x67, 0x7b, 0x66, 0x68, 0x7b, 0x66, 0x6c, 0x7b, 0x66, 0x6d,
    0x7b, 0x66, 0x6e, 0x7b, 0x66, 0x70, 0x7b, 0x66, 0x72, 0x7b, 0x66, 0x75,
    0x7b, 0x66, 0x3a, 0x7b, 0x66, 0x42, 0x7b, 0x66, 0x43, 0x7b, 0x66, 0x44,
    0x7b, 0x66, 0x45, 0x7b, 0x66, 0x46, 0x7b, 0x66, 0x47, 0x7b, 0x66, 0x48,
    0x7b, 0x66, 0x49, 0x7b, 0x66, 0x4a, 0x7b, 0x66, 0x4b, 0x7b, 0x66, 0x4c,
    0x7b, 0x66, 0x4d, 0x7b, 0x66, 0x4e, 0x7b, 0x66, 0x4f, 0x7b, 0x66, 0x50,
    0x7b, 0x66, 0x51, 0x7b, 0x66, 0x52, 0x7b, 0x66, 0x53, 0x7b, 0x66, 0x54,
    0x7b, 0x66, 0x55, 0x7b, 0x66, 0x56, 0x7b, 0x66, 0x57, 0x7b, 0x66, 0x59,
    0x7b, 0x66, 0x6a, 0x7b, 0x66, 0x6b, 0x7b, 0x66, 0x71, 0x7b, 0x66, 0x76,
    0x7b, 0x66, 0x77, 0x7b, 0x66, 0x78, 0x7b, 0x66, 0x79, 0x7b, 0x66, 0x7a,
    0x7b, 0x66, 0x26, 0x7b, 0x66, 0x2a, 0x7b, 0x66, 0x2c, 0x7b, 0x66, 0x3b,
    0x7b, 0x66, 0x58, 0x7b, 0x66, 0x5a};
const uint8_t HuffDecoderCommon::table30_38_emit_[222] = {
    0x7b, 0x67, 0x30, 0x7b, 0x67, 0x31, 0x7b, 0x67, 0x32, 0x7b, 0x67, 0x61,
    0x7b, 0x67, 0x63, 0x7b, 0x67, 0x65, 0x7b, 0x67, 0x69, 0x7b, 0x67, 0x6f,
    0x7b, 0x67, 0x73, 0x7b, 0x67, 0x74, 0x7b, 0x67, 0x20, 0x7b, 0x67, 0x25,
    0x7b, 0x67, 0x2d, 0x7b, 0x67, 0x2e, 0x7b, 0x67, 0x2f, 0x7b, 0x67, 0x33,
    0x7b, 0x67, 0x34, 0x7b, 0x67, 0x35, 0x7b, 0x67, 0x36, 0x7b, 0x67, 0x37,
    0x7b, 0x67, 0x38, 0x7b, 0x67, 0x39, 0x7b, 0x67, 0x3d, 0x7b, 0x67, 0x41,
    0x7b, 0x67, 0x5f, 0x7b, 0x67, 0x62, 0x7b, 0x67, 0x64, 0x7b, 0x67, 0x66,
    0x7b, 0x67, 0x67, 0x7b, 0x67, 0x68, 0x7b, 0x67, 0x6c, 0x7b, 0x67, 0x6d,
    0x7b, 0x67, 0x6e, 0x7b, 0x67, 0x70, 0x7b, 0x67, 0x72, 0x7b, 0x67, 0x75,
    0x7b, 0x67, 0x3a, 0x7b, 0x67, 0x42, 0x7b, 0x67, 0x43, 0x7b, 0x67, 0x44,
    0x7b, 0x67, 0x45, 0x7b, 0x67, 0x46, 0x7b, 0x67, 0x47, 0x7b, 0x67, 0x48,
    0x7b, 0x67, 0x49, 0x7b, 0x67, 0x4a, 0x7b, 0x67, 0x4b, 0x7b, 0x67, 0x4c,
    0x7b, 0x67, 0x4d, 0x7b, 0x67, 0x4e, 0x7b, 0x67, 0x4f, 0x7b, 0x67, 0x50,
    0x7b, 0x67, 0x51, 0x7b, 0x67, 0x52, 0x7b, 0x67, 0x53, 0x7b, 0x67, 0x54,
    0x7b, 0x67, 0x55, 0x7b, 0x67, 0x56, 0x7b, 0x67, 0x57, 0x7b, 0x67, 0x59,
    0x7b, 0x67, 0x6a, 0x7b, 0x67, 0x6b, 0x7b, 0x67, 0x71, 0x7b, 0x67, 0x76,
    0x7b, 0x67, 0x77, 0x7b, 0x67, 0x78, 0x7b, 0x67, 0x79, 0x7b, 0x67, 0x7a,
    0x7b, 0x67, 0x26, 0x7b, 0x67, 0x2a, 0x7b, 0x67, 0x2c, 0x7b, 0x67, 0x3b,
    0x7b, 0x67, 0x58, 0x7b, 0x67, 0x5a};
const uint8_t HuffDecoderCommon::table30_39_emit_[222] = {
    0x7b, 0x68, 0x30, 0x7b, 0x68, 0x31, 0x7b, 0x68, 0x32, 0x7b, 0x68, 0x61,
    0x7b, 0x68, 0x63, 0x7b, 0x68, 0x65, 0x7b, 0x68, 0x69, 0x7b, 0x68, 0x6f,
    0x7b, 0x68, 0x73, 0x7b, 0x68, 0x74, 0x7b, 0x68, 0x20, 0x7b, 0x68, 0x25,
    0x7b, 0x68, 0x2d, 0x7b, 0x68, 0x2e, 0x7b, 0x68, 0x2f, 0x7b, 0x68, 0x33,
    0x7b, 0x68, 0x34, 0x7b, 0x68, 0x35, 0x7b, 0x68, 0x36, 0x7b, 0x68, 0x37,
    0x7b, 0x68, 0x38, 0x7b, 0x68, 0x39, 0x7b, 0x68, 0x3d, 0x7b, 0x68, 0x41,
    0x7b, 0x68, 0x5f, 0x7b, 0x68, 0x62, 0x7b, 0x68, 0x64, 0x7b, 0x68, 0x66,
    0x7b, 0x68, 0x67, 0x7b, 0x68, 0x68, 0x7b, 0x68, 0x6c, 0x7b, 0x68, 0x6d,
    0x7b, 0x68, 0x6e, 0x7b, 0x68, 0x70, 0x7b, 0x68, 0x72, 0x7b, 0x68, 0x75,
    0x7b, 0x68, 0x3a, 0x7b, 0x68, 0x42, 0x7b, 0x68, 0x43, 0x7b, 0x68, 0x44,
    0x7b, 0x68, 0x45, 0x7b, 0x68, 0x46, 0x7b, 0x68, 0x47, 0x7b, 0x68, 0x48,
    0x7b, 0x68, 0x49, 0x7b, 0x68, 0x4a, 0x7b, 0x68, 0x4b, 0x7b, 0x68, 0x4c,
    0x7b, 0x68, 0x4d, 0x7b, 0x68, 0x4e, 0x7b, 0x68, 0x4f, 0x7b, 0x68, 0x50,
    0x7b, 0x68, 0x51, 0x7b, 0x68, 0x52, 0x7b, 0x68, 0x53, 0x7b, 0x68, 0x54,
    0x7b, 0x68, 0x55, 0x7b, 0x68, 0x56, 0x7b, 0x68, 0x57, 0x7b, 0x68, 0x59,
    0x7b, 0x68, 0x6a, 0x7b, 0x68, 0x6b, 0x7b, 0x68, 0x71, 0x7b, 0x68, 0x76,
    0x7b, 0x68, 0x77, 0x7b, 0x68, 0x78, 0x7b, 0x68, 0x79, 0x7b, 0x68, 0x7a,
    0x7b, 0x68, 0x26, 0x7b, 0x68, 0x2a, 0x7b, 0x68, 0x2c, 0x7b, 0x68, 0x3b,
    0x7b, 0x68, 0x58, 0x7b, 0x68, 0x5a};
const uint8_t HuffDecoderCommon::table30_40_emit_[222] = {
    0x7b, 0x6c, 0x30, 0x7b, 0x6c, 0x31, 0x7b, 0x6c, 0x32, 0x7b, 0x6c, 0x61,
    0x7b, 0x6c, 0x63, 0x7b, 0x6c, 0x65, 0x7b, 0x6c, 0x69, 0x7b, 0x6c, 0x6f,
    0x7b, 0x6c, 0x73, 0x7b, 0x6c, 0x74, 0x7b, 0x6c, 0x20, 0x7b, 0x6c, 0x25,
    0x7b, 0x6c, 0x2d, 0x7b, 0x6c, 0x2e, 0x7b, 0x6c, 0x2f, 0x7b, 0x6c, 0x33,
    0x7b, 0x6c, 0x34, 0x7b, 0x6c, 0x35, 0x7b, 0x6c, 0x36, 0x7b, 0x6c, 0x37,
    0x7b, 0x6c, 0x38, 0x7b, 0x6c, 0x39, 0x7b, 0x6c, 0x3d, 0x7b, 0x6c, 0x41,
    0x7b, 0x6c, 0x5f, 0x7b, 0x6c, 0x62, 0x7b, 0x6c, 0x64, 0x7b, 0x6c, 0x66,
    0x7b, 0x6c, 0x67, 0x7b, 0x6c, 0x68, 0x7b, 0x6c, 0x6c, 0x7b, 0x6c, 0x6d,
    0x7b, 0x6c, 0x6e, 0x7b, 0x6c, 0x70, 0x7b, 0x6c, 0x72, 0x7b, 0x6c, 0x75,
    0x7b, 0x6c, 0x3a, 0x7b, 0x6c, 0x42, 0x7b, 0x6c, 0x43, 0x7b, 0x6c, 0x44,
    0x7b, 0x6c, 0x45, 0x7b, 0x6c, 0x46, 0x7b, 0x6c, 0x47, 0x7b, 0x6c, 0x48,
    0x7b, 0x6c, 0x49, 0x7b, 0x6c, 0x4a, 0x7b, 0x6c, 0x4b, 0x7b, 0x6c, 0x4c,
    0x7b, 0x6c, 0x4d, 0x7b, 0x6c, 0x4e, 0x7b, 0x6c, 0x4f, 0x7b, 0x6c, 0x50,
    0x7b, 0x6c, 0x51, 0x7b, 0x6c, 0x52, 0x7b, 0x6c, 0x53, 0x7b, 0x6c, 0x54,
    0x7b, 0x6c, 0x55, 0x7b, 0x6c, 0x56, 0x7b, 0x6c, 0x57, 0x7b, 0x6c, 0x59,
    0x7b, 0x6c, 0x6a, 0x7b, 0x6c, 0x6b, 0x7b, 0x6c, 0x71, 0x7b, 0x6c, 0x76,
    0x7b, 0x6c, 0x77, 0x7b, 0x6c, 0x78, 0x7b, 0x6c, 0x79, 0x7b, 0x6c, 0x7a,
    0x7b, 0x6c, 0x26, 0x7b, 0x6c, 0x2a, 0x7b, 0x6c, 0x2c, 0x7b, 0x6c, 0x3b,
    0x7b, 0x6c, 0x58, 0x7b, 0x6c, 0x5a};
const uint8_t HuffDecoderCommon::table30_41_emit_[222] = {
    0x7b, 0x6d, 0x30, 0x7b, 0x6d, 0x31, 0x7b, 0x6d, 0x32, 0x7b, 0x6d, 0x61,
    0x7b, 0x6d, 0x63, 0x7b, 0x6d, 0x65, 0x7b, 0x6d, 0x69, 0x7b, 0x6d, 0x6f,
    0x7b, 0x6d, 0x73, 0x7b, 0x6d, 0x74, 0x7b, 0x6d, 0x20, 0x7b, 0x6d, 0x25,
    0x7b, 0x6d, 0x2d, 0x7b, 0x6d, 0x2e, 0x7b, 0x6d, 0x2f, 0x7b, 0x6d, 0x33,
    0x7b, 0x6d, 0x34, 0x7b, 0x6d, 0x35, 0x7b, 0x6d, 0x36, 0x7b, 0x6d, 0x37,
    0x7b, 0x6d, 0x38, 0x7b, 0x6d, 0x39, 0x7b, 0x6d, 0x3d, 0x7b, 0x6d, 0x41,
    0x7b, 0x6d, 0x5f, 0x7b, 0x6d, 0x62, 0x7b, 0x6d, 0x64, 0x7b, 0x6d, 0x66,
    0x7b, 0x6d, 0x67, 0x7b, 0x6d, 0x68, 0x7b, 0x6d, 0x6c, 0x7b, 0x6d, 0x6d,
    0x7b, 0x6d, 0x6e, 0x7b, 0x6d, 0x70, 0x7b, 0x6d, 0x72, 0x7b, 0x6d, 0x75,
    0x7b, 0x6d, 0x3a, 0x7b, 0x6d, 0x42, 0x7b, 0x6d, 0x43, 0x7b, 0x6d, 0x44,
    0x7b, 0x6d, 0x45, 0x7b, 0x6d, 0x46, 0x7b, 0x6d, 0x47, 0x7b, 0x6d, 0x48,
    0x7b, 0x6d, 0x49, 0x7b, 0x6d, 0x4a, 0x7b, 0x6d, 0x4b, 0x7b, 0x6d, 0x4c,
    0x7b, 0x6d, 0x4d, 0x7b, 0x6d, 0x4e, 0x7b, 0x6d, 0x4f, 0x7b, 0x6d, 0x50,
    0x7b, 0x6d, 0x51, 0x7b, 0x6d, 0x52, 0x7b, 0x6d, 0x53, 0x7b, 0x6d, 0x54,
    0x7b, 0x6d, 0x55, 0x7b, 0x6d, 0x56, 0x7b, 0x6d, 0x57, 0x7b, 0x6d, 0x59,
    0x7b, 0x6d, 0x6a, 0x7b, 0x6d, 0x6b, 0x7b, 0x6d, 0x71, 0x7b, 0x6d, 0x76,
    0x7b, 0x6d, 0x77, 0x7b, 0x6d, 0x78, 0x7b, 0x6d, 0x79, 0x7b, 0x6d, 0x7a,
    0x7b, 0x6d, 0x26, 0x7b, 0x6d, 0x2a, 0x7b, 0x6d, 0x2c, 0x7b, 0x6d, 0x3b,
    0x7b, 0x6d, 0x58, 0x7b, 0x6d, 0x5a};
const uint8_t HuffDecoderCommon::table30_42_emit_[222] = {
    0x7b, 0x6e, 0x30, 0x7b, 0x6e, 0x31, 0x7b, 0x6e, 0x32, 0x7b, 0x6e, 0x61,
    0x7b, 0x6e, 0x63, 0x7b, 0x6e, 0x65, 0x7b, 0x6e, 0x69, 0x7b, 0x6e, 0x6f,
    0x7b, 0x6e, 0x73, 0x7b, 0x6e, 0x74, 0x7b, 0x6e, 0x20, 0x7b, 0x6e, 0x25,
    0x7b, 0x6e, 0x2d, 0x7b, 0x6e, 0x2e, 0x7b, 0x6e, 0x2f, 0x7b, 0x6e, 0x33,
    0x7b, 0x6e, 0x34, 0x7b, 0x6e, 0x35, 0x7b, 0x6e, 0x36, 0x7b, 0x6e, 0x37,
    0x7b, 0x6e, 0x38, 0x7b, 0x6e, 0x39, 0x7b, 0x6e, 0x3d, 0x7b, 0x6e, 0x41,
    0x7b, 0x6e, 0x5f, 0x7b, 0x6e, 0x62, 0x7b, 0x6e, 0x64, 0x7b, 0x6e, 0x66,
    0x7b, 0x6e, 0x67, 0x7b, 0x6e, 0x68, 0x7b, 0x6e, 0x6c, 0x7b, 0x6e, 0x6d,
    0x7b, 0x6e, 0x6e, 0x7b, 0x6e, 0x70, 0x7b, 0x6e, 0x72, 0x7b, 0x6e, 0x75,
    0x7b, 0x6e, 0x3a, 0x7b, 0x6e, 0x42, 0x7b, 0x6e, 0x43, 0x7b, 0x6e, 0x44,
    0x7b, 0x6e, 0x45, 0x7b, 0x6e, 0x46, 0x7b, 0x6e, 0x47, 0x7b, 0x6e, 0x48,
    0x7b, 0x6e, 0x49, 0x7b, 0x6e, 0x4a, 0x7b, 0x6e, 0x4b, 0x7b, 0x6e, 0x4c,
    0x7b, 0x6e, 0x4d, 0x7b, 0x6e, 0x4e, 0x7b, 0x6e, 0x4f, 0x7b, 0x6e, 0x50,
    0x7b, 0x6e, 0x51, 0x7b, 0x6e, 0x52, 0x7b, 0x6e, 0x53, 0x7b, 0x6e, 0x54,
    0x7b, 0x6e, 0x55, 0x7b, 0x6e, 0x56, 0x7b, 0x6e, 0x57, 0x7b, 0x6e, 0x59,
    0x7b, 0x6e, 0x6a, 0x7b, 0x6e, 0x6b, 0x7b, 0x6e, 0x71, 0x7b, 0x6e, 0x76,
    0x7b, 0x6e, 0x77, 0x7b, 0x6e, 0x78, 0x7b, 0x6e, 0x79, 0x7b, 0x6e, 0x7a,
    0x7b, 0x6e, 0x26, 0x7b, 0x6e, 0x2a, 0x7b, 0x6e, 0x2c, 0x7b, 0x6e, 0x3b,
    0x7b, 0x6e, 0x58, 0x7b, 0x6e, 0x5a};
const uint8_t HuffDecoderCommon::table30_43_emit_[222] = {
    0x7b, 0x70, 0x30, 0x7b, 0x70, 0x31, 0x7b, 0x70, 0x32, 0x7b, 0x70, 0x61,
    0x7b, 0x70, 0x63, 0x7b, 0x70, 0x65, 0x7b, 0x70, 0x69, 0x7b, 0x70, 0x6f,
    0x7b, 0x70, 0x73, 0x7b, 0x70, 0x74, 0x7b, 0x70, 0x20, 0x7b, 0x70, 0x25,
    0x7b, 0x70, 0x2d, 0x7b, 0x70, 0x2e, 0x7b, 0x70, 0x2f, 0x7b, 0x70, 0x33,
    0x7b, 0x70, 0x34, 0x7b, 0x70, 0x35, 0x7b, 0x70, 0x36, 0x7b, 0x70, 0x37,
    0x7b, 0x70, 0x38, 0x7b, 0x70, 0x39, 0x7b, 0x70, 0x3d, 0x7b, 0x70, 0x41,
    0x7b, 0x70, 0x5f, 0x7b, 0x70, 0x62, 0x7b, 0x70, 0x64, 0x7b, 0x70, 0x66,
    0x7b, 0x70, 0x67, 0x7b, 0x70, 0x68, 0x7b, 0x70, 0x6c, 0x7b, 0x70, 0x6d,
    0x7b, 0x70, 0x6e, 0x7b, 0x70, 0x70, 0x7b, 0x70, 0x72, 0x7b, 0x70, 0x75,
    0x7b, 0x70, 0x3a, 0x7b, 0x70, 0x42, 0x7b, 0x70, 0x43, 0x7b, 0x70, 0x44,
    0x7b, 0x70, 0x45, 0x7b, 0x70, 0x46, 0x7b, 0x70, 0x47, 0x7b, 0x70, 0x48,
    0x7b, 0x70, 0x49, 0x7b, 0x70, 0x4a, 0x7b, 0x70, 0x4b, 0x7b, 0x70, 0x4c,
    0x7b, 0x70, 0x4d, 0x7b, 0x70, 0x4e, 0x7b, 0x70, 0x4f, 0x7b, 0x70, 0x50,
    0x7b, 0x70, 0x51, 0x7b, 0x70, 0x52, 0x7b, 0x70, 0x53, 0x7b, 0x70, 0x54,
    0x7b, 0x70, 0x55, 0x7b, 0x70, 0x56, 0x7b, 0x70, 0x57, 0x7b, 0x70, 0x59,
    0x7b, 0x70, 0x6a, 0x7b, 0x70, 0x6b, 0x7b, 0x70, 0x71, 0x7b, 0x70, 0x76,
    0x7b, 0x70, 0x77, 0x7b, 0x70, 0x78, 0x7b, 0x70, 0x79, 0x7b, 0x70, 0x7a,
    0x7b, 0x70, 0x26, 0x7b, 0x70, 0x2a, 0x7b, 0x70, 0x2c, 0x7b, 0x70, 0x3b,
    0x7b, 0x70, 0x58, 0x7b, 0x70, 0x5a};
const uint8_t HuffDecoderCommon::table30_44_emit_[222] = {
    0x7b, 0x72, 0x30, 0x7b, 0x72, 0x31, 0x7b, 0x72, 0x32, 0x7b, 0x72, 0x61,
    0x7b, 0x72, 0x63, 0x7b, 0x72, 0x65, 0x7b, 0x72, 0x69, 0x7b, 0x72, 0x6f,
    0x7b, 0x72, 0x73, 0x7b, 0x72, 0x74, 0x7b, 0x72, 0x20, 0x7b, 0x72, 0x25,
    0x7b, 0x72, 0x2d, 0x7b, 0x72, 0x2e, 0x7b, 0x72, 0x2f, 0x7b, 0x72, 0x33,
    0x7b, 0x72, 0x34, 0x7b, 0x72, 0x35, 0x7b, 0x72, 0x36, 0x7b, 0x72, 0x37,
    0x7b, 0x72, 0x38, 0x7b, 0x72, 0x39, 0x7b, 0x72, 0x3d, 0x7b, 0x72, 0x41,
    0x7b, 0x72, 0x5f, 0x7b, 0x72, 0x62, 0x7b, 0x72, 0x64, 0x7b, 0x72, 0x66,
    0x7b, 0x72, 0x67, 0x7b, 0x72, 0x68, 0x7b, 0x72, 0x6c, 0x7b, 0x72, 0x6d,
    0x7b, 0x72, 0x6e, 0x7b, 0x72, 0x70, 0x7b, 0x72, 0x72, 0x7b, 0x72, 0x75,
    0x7b, 0x72, 0x3a, 0x7b, 0x72, 0x42, 0x7b, 0x72, 0x43, 0x7b, 0x72, 0x44,
    0x7b, 0x72, 0x45, 0x7b, 0x72, 0x46, 0x7b, 0x72, 0x47, 0x7b, 0x72, 0x48,
    0x7b, 0x72, 0x49, 0x7b, 0x72, 0x4a, 0x7b, 0x72, 0x4b, 0x7b, 0x72, 0x4c,
    0x7b, 0x72, 0x4d, 0x7b, 0x72, 0x4e, 0x7b, 0x72, 0x4f, 0x7b, 0x72, 0x50,
    0x7b, 0x72, 0x51, 0x7b, 0x72, 0x52, 0x7b, 0x72, 0x53, 0x7b, 0x72, 0x54,
    0x7b, 0x72, 0x55, 0x7b, 0x72, 0x56, 0x7b, 0x72, 0x57, 0x7b, 0x72, 0x59,
    0x7b, 0x72, 0x6a, 0x7b, 0x72, 0x6b, 0x7b, 0x72, 0x71, 0x7b, 0x72, 0x76,
    0x7b, 0x72, 0x77, 0x7b, 0x72, 0x78, 0x7b, 0x72, 0x79, 0x7b, 0x72, 0x7a,
    0x7b, 0x72, 0x26, 0x7b, 0x72, 0x2a, 0x7b, 0x72, 0x2c, 0x7b, 0x72, 0x3b,
    0x7b, 0x72, 0x58, 0x7b, 0x72, 0x5a};
const uint8_t HuffDecoderCommon::table30_45_emit_[222] = {
    0x7b, 0x75, 0x30, 0x7b, 0x75, 0x31, 0x7b, 0x75, 0x32, 0x7b, 0x75, 0x61,
    0x7b, 0x75, 0x63, 0x7b, 0x75, 0x65, 0x7b, 0x75, 0x69, 0x7b, 0x75, 0x6f,
    0x7b, 0x75, 0x73, 0x7b, 0x75, 0x74, 0x7b, 0x75, 0x20, 0x7b, 0x75, 0x25,
    0x7b, 0x75, 0x2d, 0x7b, 0x75, 0x2e, 0x7b, 0x75, 0x2f, 0x7b, 0x75, 0x33,
    0x7b, 0x75, 0x34, 0x7b, 0x75, 0x35, 0x7b, 0x75, 0x36, 0x7b, 0x75, 0x37,
    0x7b, 0x75, 0x38, 0x7b, 0x75, 0x39, 0x7b, 0x75, 0x3d, 0x7b, 0x75, 0x41,
    0x7b, 0x75, 0x5f, 0x7b, 0x75, 0x62, 0x7b, 0x75, 0x64, 0x7b, 0x75, 0x66,
    0x7b, 0x75, 0x67, 0x7b, 0x75, 0x68, 0x7b, 0x75, 0x6c, 0x7b, 0x75, 0x6d,
    0x7b, 0x75, 0x6e, 0x7b, 0x75, 0x70, 0x7b, 0x75, 0x72, 0x7b, 0x75, 0x75,
    0x7b, 0x75, 0x3a, 0x7b, 0x75, 0x42, 0x7b, 0x75, 0x43, 0x7b, 0x75, 0x44,
    0x7b, 0x75, 0x45, 0x7b, 0x75, 0x46, 0x7b, 0x75, 0x47, 0x7b, 0x75, 0x48,
    0x7b, 0x75, 0x49, 0x7b, 0x75, 0x4a, 0x7b, 0x75, 0x4b, 0x7b, 0x75, 0x4c,
    0x7b, 0x75, 0x4d, 0x7b, 0x75, 0x4e, 0x7b, 0x75, 0x4f, 0x7b, 0x75, 0x50,
    0x7b, 0x75, 0x51, 0x7b, 0x75, 0x52, 0x7b, 0x75, 0x53, 0x7b, 0x75, 0x54,
    0x7b, 0x75, 0x55, 0x7b, 0x75, 0x56, 0x7b, 0x75, 0x57, 0x7b, 0x75, 0x59,
    0x7b, 0x75, 0x6a, 0x7b, 0x75, 0x6b, 0x7b, 0x75, 0x71, 0x7b, 0x75, 0x76,
    0x7b, 0x75, 0x77, 0x7b, 0x75, 0x78, 0x7b, 0x75, 0x79, 0x7b, 0x75, 0x7a,
    0x7b, 0x75, 0x26, 0x7b, 0x75, 0x2a, 0x7b, 0x75, 0x2c, 0x7b, 0x75, 0x3b,
    0x7b, 0x75, 0x58, 0x7b, 0x75, 0x5a};
const uint8_t HuffDecoderCommon::table30_46_emit_[408] = {
    0x7b, 0x3a, 0x30, 0x7b, 0x3a, 0x31, 0x7b, 0x3a, 0x32, 0x7b, 0x3a, 0x61,
    0x7b, 0x3a, 0x63, 0x7b, 0x3a, 0x65, 0x7b, 0x3a, 0x69, 0x7b, 0x3a, 0x6f,
    0x7b, 0x3a, 0x73, 0x7b, 0x3a, 0x74, 0x7b, 0x3a, 0x20, 0x7b, 0x3a, 0x25,
    0x7b, 0x3a, 0x2d, 0x7b, 0x3a, 0x2e, 0x7b, 0x3a, 0x2f, 0x7b, 0x3a, 0x33,
    0x7b, 0x3a, 0x34, 0x7b, 0x3a, 0x35, 0x7b, 0x3a, 0x36, 0x7b, 0x3a, 0x37,
    0x7b, 0x3a, 0x38, 0x7b, 0x3a, 0x39, 0x7b, 0x3a, 0x3d, 0x7b, 0x3a, 0x41,
    0x7b, 0x3a, 0x5f, 0x7b, 0x3a, 0x62, 0x7b, 0x3a, 0x64, 0x7b, 0x3a, 0x66,
    0x7b, 0x3a, 0x67, 0x7b, 0x3a, 0x68, 0x7b, 0x3a, 0x6c, 0x7b, 0x3a, 0x6d,
    0x7b, 0x3a, 0x6e, 0x7b, 0x3a, 0x70, 0x7b, 0x3a, 0x72, 0x7b, 0x3a, 0x75,
    0x7b, 0x3a, 0x3a, 0x7b, 0x3a, 0x42, 0x7b, 0x3a, 0x43, 0x7b, 0x3a, 0x44,
    0x7b, 0x3a, 0x45, 0x7b, 0x3a, 0x46, 0x7b, 0x3a, 0x47, 0x7b, 0x3a, 0x48,
    0x7b, 0x3a, 0x49, 0x7b, 0x3a, 0x4a, 0x7b, 0x3a, 0x4b, 0x7b, 0x3a, 0x4c,
    0x7b, 0x3a, 0x4d, 0x7b, 0x3a, 0x4e, 0x7b, 0x3a, 0x4f, 0x7b, 0x3a, 0x50,
    0x7b, 0x3a, 0x51, 0x7b, 0x3a, 0x52, 0x7b, 0x3a, 0x53, 0x7b, 0x3a, 0x54,
    0x7b, 0x3a, 0x55, 0x7b, 0x3a, 0x56, 0x7b, 0x3a, 0x57, 0x7b, 0x3a, 0x59,
    0x7b, 0x3a, 0x6a, 0x7b, 0x3a, 0x6b, 0x7b, 0x3a, 0x71, 0x7b, 0x3a, 0x76,
    0x7b, 0x3a, 0x77, 0x7b, 0x3a, 0x78, 0x7b, 0x3a, 0x79, 0x7b, 0x3a, 0x7a,
    0x7b, 0x42, 0x30, 0x7b, 0x42, 0x31, 0x7b, 0x42, 0x32, 0x7b, 0x42, 0x61,
    0x7b, 0x42, 0x63, 0x7b, 0x42, 0x65, 0x7b, 0x42, 0x69, 0x7b, 0x42, 0x6f,
    0x7b, 0x42, 0x73, 0x7b, 0x42, 0x74, 0x7b, 0x42, 0x20, 0x7b, 0x42, 0x25,
    0x7b, 0x42, 0x2d, 0x7b, 0x42, 0x2e, 0x7b, 0x42, 0x2f, 0x7b, 0x42, 0x33,
    0x7b, 0x42, 0x34, 0x7b, 0x42, 0x35, 0x7b, 0x42, 0x36, 0x7b, 0x42, 0x37,
    0x7b, 0x42, 0x38, 0x7b, 0x42, 0x39, 0x7b, 0x42, 0x3d, 0x7b, 0x42, 0x41,
    0x7b, 0x42, 0x5f, 0x7b, 0x42, 0x62, 0x7b, 0x42, 0x64, 0x7b, 0x42, 0x66,
    0x7b, 0x42, 0x67, 0x7b, 0x42, 0x68, 0x7b, 0x42, 0x6c, 0x7b, 0x42, 0x6d,
    0x7b, 0x42, 0x6e, 0x7b, 0x42, 0x70, 0x7b, 0x42, 0x72, 0x7b, 0x42, 0x75,
    0x7b, 0x42, 0x3a, 0x7b, 0x42, 0x42, 0x7b, 0x42, 0x43, 0x7b, 0x42, 0x44,
    0x7b, 0x42, 0x45, 0x7b, 0x42, 0x46, 0x7b, 0x42, 0x47, 0x7b, 0x42, 0x48,
    0x7b, 0x42, 0x49, 0x7b, 0x42, 0x4a, 0x7b, 0x42, 0x4b, 0x7b, 0x42, 0x4c,
    0x7b, 0x42, 0x4d, 0x7b, 0x42, 0x4e, 0x7b, 0x42, 0x4f, 0x7b, 0x42, 0x50,
    0x7b, 0x42, 0x51, 0x7b, 0x42, 0x52, 0x7b, 0x42, 0x53, 0x7b, 0x42, 0x54,
    0x7b, 0x42, 0x55, 0x7b, 0x42, 0x56, 0x7b, 0x42, 0x57, 0x7b, 0x42, 0x59,
    0x7b, 0x42, 0x6a, 0x7b, 0x42, 0x6b, 0x7b, 0x42, 0x71, 0x7b, 0x42, 0x76,
    0x7b, 0x42, 0x77, 0x7b, 0x42, 0x78, 0x7b, 0x42, 0x79, 0x7b, 0x42, 0x7a};
const uint16_t HuffDecoderCommon::table30_46_inner_[139] = {
    0x0000, 0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9,
    0x00c1, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169, 0x0181,
    0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259,
    0x0271, 0x0289, 0x02a1, 0x02b9, 0x02d1, 0x02e9, 0x0301, 0x0319, 0x0331,
    0x0349, 0x0361, 0x0379, 0x0391, 0x03a9, 0x03c1, 0x03d9, 0x03f1, 0x0409,
    0x0421, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9, 0x04e1,
    0x04f9, 0x0511, 0x0529, 0x0541, 0x0559, 0x0571, 0x0589, 0x05a1, 0x05b9,
    0x05d1, 0x05e9, 0x0601, 0x0619, 0x0631, 0x0649, 0x0002, 0x0661, 0x0679,
    0x0691, 0x06a9, 0x06c1, 0x06d9, 0x06f1, 0x0709, 0x0721, 0x0739, 0x0751,
    0x0769, 0x0781, 0x0799, 0x07b1, 0x07c9, 0x07e1, 0x07f9, 0x0811, 0x0829,
    0x0841, 0x0859, 0x0871, 0x0889, 0x08a1, 0x08b9, 0x08d1, 0x08e9, 0x0901,
    0x0919, 0x0931, 0x0949, 0x0961, 0x0979, 0x0991, 0x09a9, 0x09c1, 0x09d9,
    0x09f1, 0x0a09, 0x0a21, 0x0a39, 0x0a51, 0x0a69, 0x0a81, 0x0a99, 0x0ab1,
    0x0ac9, 0x0ae1, 0x0af9, 0x0b11, 0x0b29, 0x0b41, 0x0b59, 0x0b71, 0x0b89,
    0x0ba1, 0x0bb9, 0x0bd1, 0x0be9, 0x0c01, 0x0c19, 0x0c31, 0x0c49, 0x0c61,
    0x0c79, 0x0c91, 0x0ca9, 0x0662};
const uint8_t HuffDecoderCommon::table30_46_outer_[256] = {
    0,   0,   0,   1,   0,   0,   0,   2,   0,   0,   0,   3,   0,   0,   0,
    4,   0,   0,   0,   5,   0,   0,   0,   6,   0,   0,   0,   7,   0,   0,
    0,   8,   0,   0,   0,   9,   0,   0,   0,   10,  0,   11,  0,   12,  0,
    13,  0,   14,  0,   15,  0,   16,  0,   17,  0,   18,  0,   19,  0,   20,
    0,   21,  0,   22,  0,   23,  0,   24,  0,   25,  0,   26,  0,   27,  0,
    28,  0,   29,  0,   30,  0,   31,  0,   32,  0,   33,  0,   34,  0,   35,
    0,   36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,  48,  49,
    50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,
    65,  66,  67,  68,  0,   0,   0,   69,  0,   0,   0,   70,  0,   0,   0,
    71,  0,   0,   0,   72,  0,   0,   0,   73,  0,   0,   0,   74,  0,   0,
    0,   75,  0,   0,   0,   76,  0,   0,   0,   77,  0,   0,   0,   78,  0,
    0,   0,   79,  0,   80,  0,   81,  0,   82,  0,   83,  0,   84,  0,   85,
    0,   86,  0,   87,  0,   88,  0,   89,  0,   90,  0,   91,  0,   92,  0,
    93,  0,   94,  0,   95,  0,   96,  0,   97,  0,   98,  0,   99,  0,   100,
    0,   101, 0,   102, 0,   103, 0,   104, 0,   105, 106, 107, 108, 109, 110,
    111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125,
    126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 0,   0,   0,
    138};
const uint8_t HuffDecoderCommon::table30_47_emit_[408] = {
    0x7b, 0x43, 0x30, 0x7b, 0x43, 0x31, 0x7b, 0x43, 0x32, 0x7b, 0x43, 0x61,
    0x7b, 0x43, 0x63, 0x7b, 0x43, 0x65, 0x7b, 0x43, 0x69, 0x7b, 0x43, 0x6f,
    0x7b, 0x43, 0x73, 0x7b, 0x43, 0x74, 0x7b, 0x43, 0x20, 0x7b, 0x43, 0x25,
    0x7b, 0x43, 0x2d, 0x7b, 0x43, 0x2e, 0x7b, 0x43, 0x2f, 0x7b, 0x43, 0x33,
    0x7b, 0x43, 0x34, 0x7b, 0x43, 0x35, 0x7b, 0x43, 0x36, 0x7b, 0x43, 0x37,
    0x7b, 0x43, 0x38, 0x7b, 0x43, 0x39, 0x7b, 0x43, 0x3d, 0x7b, 0x43, 0x41,
    0x7b, 0x43, 0x5f, 0x7b, 0x43, 0x62, 0x7b, 0x43, 0x64, 0x7b, 0x43, 0x66,
    0x7b, 0x43, 0x67, 0x7b, 0x43, 0x68, 0x7b, 0x43, 0x6c, 0x7b, 0x43, 0x6d,
    0x7b, 0x43, 0x6e, 0x7b, 0x43, 0x70, 0x7b, 0x43, 0x72, 0x7b, 0x43, 0x75,
    0x7b, 0x43, 0x3a, 0x7b, 0x43, 0x42, 0x7b, 0x43, 0x43, 0x7b, 0x43, 0x44,
    0x7b, 0x43, 0x45, 0x7b, 0x43, 0x46, 0x7b, 0x43, 0x47, 0x7b, 0x43, 0x48,
    0x7b, 0x43, 0x49, 0x7b, 0x43, 0x4a, 0x7b, 0x43, 0x4b, 0x7b, 0x43, 0x4c,
    0x7b, 0x43, 0x4d, 0x7b, 0x43, 0x4e, 0x7b, 0x43, 0x4f, 0x7b, 0x43, 0x50,
    0x7b, 0x43, 0x51, 0x7b, 0x43, 0x52, 0x7b, 0x43, 0x53, 0x7b, 0x43, 0x54,
    0x7b, 0x43, 0x55, 0x7b, 0x43, 0x56, 0x7b, 0x43, 0x57, 0x7b, 0x43, 0x59,
    0x7b, 0x43, 0x6a, 0x7b, 0x43, 0x6b, 0x7b, 0x43, 0x71, 0x7b, 0x43, 0x76,
    0x7b, 0x43, 0x77, 0x7b, 0x43, 0x78, 0x7b, 0x43, 0x79, 0x7b, 0x43, 0x7a,
    0x7b, 0x44, 0x30, 0x7b, 0x44, 0x31, 0x7b, 0x44, 0x32, 0x7b, 0x44, 0x61,
    0x7b, 0x44, 0x63, 0x7b, 0x44, 0x65, 0x7b, 0x44, 0x69, 0x7b, 0x44, 0x6f,
    0x7b, 0x44, 0x73, 0x7b, 0x44, 0x74, 0x7b, 0x44, 0x20, 0x7b, 0x44, 0x25,
    0x7b, 0x44, 0x2d, 0x7b, 0x44, 0x2e, 0x7b, 0x44, 0x2f, 0x7b, 0x44, 0x33,
    0x7b, 0x44, 0x34, 0x7b, 0x44, 0x35, 0x7b, 0x44, 0x36, 0x7b, 0x44, 0x37,
    0x7b, 0x44, 0x38, 0x7b, 0x44, 0x39, 0x7b, 0x44, 0x3d, 0x7b, 0x44, 0x41,
    0x7b, 0x44, 0x5f, 0x7b, 0x44, 0x62, 0x7b, 0x44, 0x64, 0x7b, 0x44, 0x66,
    0x7b, 0x44, 0x67, 0x7b, 0x44, 0x68, 0x7b, 0x44, 0x6c, 0x7b, 0x44, 0x6d,
    0x7b, 0x44, 0x6e, 0x7b, 0x44, 0x70, 0x7b, 0x44, 0x72, 0x7b, 0x44, 0x75,
    0x7b, 0x44, 0x3a, 0x7b, 0x44, 0x42, 0x7b, 0x44, 0x43, 0x7b, 0x44, 0x44,
    0x7b, 0x44, 0x45, 0x7b, 0x44, 0x46, 0x7b, 0x44, 0x47, 0x7b, 0x44, 0x48,
    0x7b, 0x44, 0x49, 0x7b, 0x44, 0x4a, 0x7b, 0x44, 0x4b, 0x7b, 0x44, 0x4c,
    0x7b, 0x44, 0x4d, 0x7b, 0x44, 0x4e, 0x7b, 0x44, 0x4f, 0x7b, 0x44, 0x50,
    0x7b, 0x44, 0x51, 0x7b, 0x44, 0x52, 0x7b, 0x44, 0x53, 0x7b, 0x44, 0x54,
    0x7b, 0x44, 0x55, 0x7b, 0x44, 0x56, 0x7b, 0x44, 0x57, 0x7b, 0x44, 0x59,
    0x7b, 0x44, 0x6a, 0x7b, 0x44, 0x6b, 0x7b, 0x44, 0x71, 0x7b, 0x44, 0x76,
    0x7b, 0x44, 0x77, 0x7b, 0x44, 0x78, 0x7b, 0x44, 0x79, 0x7b, 0x44, 0x7a};
const uint8_t HuffDecoderCommon::table30_48_emit_[408] = {
    0x7b, 0x45, 0x30, 0x7b, 0x45, 0x31, 0x7b, 0x45, 0x32, 0x7b, 0x45, 0x61,
    0x7b, 0x45, 0x63, 0x7b, 0x45, 0x65, 0x7b, 0x45, 0x69, 0x7b, 0x45, 0x6f,
    0x7b, 0x45, 0x73, 0x7b, 0x45, 0x74, 0x7b, 0x45, 0x20, 0x7b, 0x45, 0x25,
    0x7b, 0x45, 0x2d, 0x7b, 0x45, 0x2e, 0x7b, 0x45, 0x2f, 0x7b, 0x45, 0x33,
    0x7b, 0x45, 0x34, 0x7b, 0x45, 0x35, 0x7b, 0x45, 0x36, 0x7b, 0x45, 0x37,
    0x7b, 0x45, 0x38, 0x7b, 0x45, 0x39, 0x7b, 0x45, 0x3d, 0x7b, 0x45, 0x41,
    0x7b, 0x45, 0x5f, 0x7b, 0x45, 0x62, 0x7b, 0x45, 0x64, 0x7b, 0x45, 0x66,
    0x7b, 0x45, 0x67, 0x7b, 0x45, 0x68, 0x7b, 0x45, 0x6c, 0x7b, 0x45, 0x6d,
    0x7b, 0x45, 0x6e, 0x7b, 0x45, 0x70, 0x7b, 0x45, 0x72, 0x7b, 0x45, 0x75,
    0x7b, 0x45, 0x3a, 0x7b, 0x45, 0x42, 0x7b, 0x45, 0x43, 0x7b, 0x45, 0x44,
    0x7b, 0x45, 0x45, 0x7b, 0x45, 0x46, 0x7b, 0x45, 0x47, 0x7b, 0x45, 0x48,
    0x7b, 0x45, 0x49, 0x7b, 0x45, 0x4a, 0x7b, 0x45, 0x4b, 0x7b, 0x45, 0x4c,
    0x7b, 0x45, 0x4d, 0x7b, 0x45, 0x4e, 0x7b, 0x45, 0x4f, 0x7b, 0x45, 0x50,
    0x7b, 0x45, 0x51, 0x7b, 0x45, 0x52, 0x7b, 0x45, 0x53, 0x7b, 0x45, 0x54,
    0x7b, 0x45, 0x55, 0x7b, 0x45, 0x56, 0x7b, 0x45, 0x57, 0x7b, 0x45, 0x59,
    0x7b, 0x45, 0x6a, 0x7b, 0x45, 0x6b, 0x7b, 0x45, 0x71, 0x7b, 0x45, 0x76,
    0x7b, 0x45, 0x77, 0x7b, 0x45, 0x78, 0x7b, 0x45, 0x79, 0x7b, 0x45, 0x7a,
    0x7b, 0x46, 0x30, 0x7b, 0x46, 0x31, 0x7b, 0x46, 0x32, 0x7b, 0x46, 0x61,
    0x7b, 0x46, 0x63, 0x7b, 0x46, 0x65, 0x7b, 0x46, 0x69, 0x7b, 0x46, 0x6f,
    0x7b, 0x46, 0x73, 0x7b, 0x46, 0x74, 0x7b, 0x46, 0x20, 0x7b, 0x46, 0x25,
    0x7b, 0x46, 0x2d, 0x7b, 0x46, 0x2e, 0x7b, 0x46, 0x2f, 0x7b, 0x46, 0x33,
    0x7b, 0x46, 0x34, 0x7b, 0x46, 0x35, 0x7b, 0x46, 0x36, 0x7b, 0x46, 0x37,
    0x7b, 0x46, 0x38, 0x7b, 0x46, 0x39, 0x7b, 0x46, 0x3d, 0x7b, 0x46, 0x41,
    0x7b, 0x46, 0x5f, 0x7b, 0x46, 0x62, 0x7b, 0x46, 0x64, 0x7b, 0x46, 0x66,
    0x7b, 0x46, 0x67, 0x7b, 0x46, 0x68, 0x7b, 0x46, 0x6c, 0x7b, 0x46, 0x6d,
    0x7b, 0x46, 0x6e, 0x7b, 0x46, 0x70, 0x7b, 0x46, 0x72, 0x7b, 0x46, 0x75,
    0x7b, 0x46, 0x3a, 0x7b, 0x46, 0x42, 0x7b, 0x46, 0x43, 0x7b, 0x46, 0x44,
    0x7b, 0x46, 0x45, 0x7b, 0x46, 0x46, 0x7b, 0x46, 0x47, 0x7b, 0x46, 0x48,
    0x7b, 0x46, 0x49, 0x7b, 0x46, 0x4a, 0x7b, 0x46, 0x4b, 0x7b, 0x46, 0x4c,
    0x7b, 0x46, 0x4d, 0x7b, 0x46, 0x4e, 0x7b, 0x46, 0x4f, 0x7b, 0x46, 0x50,
    0x7b, 0x46, 0x51, 0x7b, 0x46, 0x52, 0x7b, 0x46, 0x53, 0x7b, 0x46, 0x54,
    0x7b, 0x46, 0x55, 0x7b, 0x46, 0x56, 0x7b, 0x46, 0x57, 0x7b, 0x46, 0x59,
    0x7b, 0x46, 0x6a, 0x7b, 0x46, 0x6b, 0x7b, 0x46, 0x71, 0x7b, 0x46, 0x76,
    0x7b, 0x46, 0x77, 0x7b, 0x46, 0x78, 0x7b, 0x46, 0x79, 0x7b, 0x46, 0x7a};
const uint8_t HuffDecoderCommon::table30_49_emit_[408] = {
    0x7b, 0x47, 0x30, 0x7b, 0x47, 0x31, 0x7b, 0x47, 0x32, 0x7b, 0x47, 0x61,
    0x7b, 0x47, 0x63, 0x7b, 0x47, 0x65, 0x7b, 0x47, 0x69, 0x7b, 0x47, 0x6f,
    0x7b, 0x47, 0x73, 0x7b, 0x47, 0x74, 0x7b, 0x47, 0x20, 0x7b, 0x47, 0x25,
    0x7b, 0x47, 0x2d, 0x7b, 0x47, 0x2e, 0x7b, 0x47, 0x2f, 0x7b, 0x47, 0x33,
    0x7b, 0x47, 0x34, 0x7b, 0x47, 0x35, 0x7b, 0x47, 0x36, 0x7b, 0x47, 0x37,
    0x7b, 0x47, 0x38, 0x7b, 0x47, 0x39, 0x7b, 0x47, 0x3d, 0x7b, 0x47, 0x41,
    0x7b, 0x47, 0x5f, 0x7b, 0x47, 0x62, 0x7b, 0x47, 0x64, 0x7b, 0x47, 0x66,
    0x7b, 0x47, 0x67, 0x7b, 0x47, 0x68, 0x7b, 0x47, 0x6c, 0x7b, 0x47, 0x6d,
    0x7b, 0x47, 0x6e, 0x7b, 0x47, 0x70, 0x7b, 0x47, 0x72, 0x7b, 0x47, 0x75,
    0x7b, 0x47, 0x3a, 0x7b, 0x47, 0x42, 0x7b, 0x47, 0x43, 0x7b, 0x47, 0x44,
    0x7b, 0x47, 0x45, 0x7b, 0x47, 0x46, 0x7b, 0x47, 0x47, 0x7b, 0x47, 0x48,
    0x7b, 0x47, 0x49, 0x7b, 0x47, 0x4a, 0x7b, 0x47, 0x4b, 0x7b, 0x47, 0x4c,
    0x7b, 0x47, 0x4d, 0x7b, 0x47, 0x4e, 0x7b, 0x47, 0x4f, 0x7b, 0x47, 0x50,
    0x7b, 0x47, 0x51, 0x7b, 0x47, 0x52, 0x7b, 0x47, 0x53, 0x7b, 0x47, 0x54,
    0x7b, 0x47, 0x55, 0x7b, 0x47, 0x56, 0x7b, 0x47, 0x57, 0x7b, 0x47, 0x59,
    0x7b, 0x47, 0x6a, 0x7b, 0x47, 0x6b, 0x7b, 0x47, 0x71, 0x7b, 0x47, 0x76,
    0x7b, 0x47, 0x77, 0x7b, 0x47, 0x78, 0x7b, 0x47, 0x79, 0x7b, 0x47, 0x7a,
    0x7b, 0x48, 0x30, 0x7b, 0x48, 0x31, 0x7b, 0x48, 0x32, 0x7b, 0x48, 0x61,
    0x7b, 0x48, 0x63, 0x7b, 0x48, 0x65, 0x7b, 0x48, 0x69, 0x7b, 0x48, 0x6f,
    0x7b, 0x48, 0x73, 0x7b, 0x48, 0x74, 0x7b, 0x48, 0x20, 0x7b, 0x48, 0x25,
    0x7b, 0x48, 0x2d, 0x7b, 0x48, 0x2e, 0x7b, 0x48, 0x2f, 0x7b, 0x48, 0x33,
    0x7b, 0x48, 0x34, 0x7b, 0x48, 0x35, 0x7b, 0x48, 0x36, 0x7b, 0x48, 0x37,
    0x7b, 0x48, 0x38, 0x7b, 0x48, 0x39, 0x7b, 0x48, 0x3d, 0x7b, 0x48, 0x41,
    0x7b, 0x48, 0x5f, 0x7b, 0x48, 0x62, 0x7b, 0x48, 0x64, 0x7b, 0x48, 0x66,
    0x7b, 0x48, 0x67, 0x7b, 0x48, 0x68, 0x7b, 0x48, 0x6c, 0x7b, 0x48, 0x6d,
    0x7b, 0x48, 0x6e, 0x7b, 0x48, 0x70, 0x7b, 0x48, 0x72, 0x7b, 0x48, 0x75,
    0x7b, 0x48, 0x3a, 0x7b, 0x48, 0x42, 0x7b, 0x48, 0x43, 0x7b, 0x48, 0x44,
    0x7b, 0x48, 0x45, 0x7b, 0x48, 0x46, 0x7b, 0x48, 0x47, 0x7b, 0x48, 0x48,
    0x7b, 0x48, 0x49, 0x7b, 0x48, 0x4a, 0x7b, 0x48, 0x4b, 0x7b, 0x48, 0x4c,
    0x7b, 0x48, 0x4d, 0x7b, 0x48, 0x4e, 0x7b, 0x48, 0x4f, 0x7b, 0x48, 0x50,
    0x7b, 0x48, 0x51, 0x7b, 0x48, 0x52, 0x7b, 0x48, 0x53, 0x7b, 0x48, 0x54,
    0x7b, 0x48, 0x55, 0x7b, 0x48, 0x56, 0x7b, 0x48, 0x57, 0x7b, 0x48, 0x59,
    0x7b, 0x48, 0x6a, 0x7b, 0x48, 0x6b, 0x7b, 0x48, 0x71, 0x7b, 0x48, 0x76,
    0x7b, 0x48, 0x77, 0x7b, 0x48, 0x78, 0x7b, 0x48, 0x79, 0x7b, 0x48, 0x7a};
const uint8_t HuffDecoderCommon::table30_50_emit_[408] = {
    0x7b, 0x49, 0x30, 0x7b, 0x49, 0x31, 0x7b, 0x49, 0x32, 0x7b, 0x49, 0x61,
    0x7b, 0x49, 0x63, 0x7b, 0x49, 0x65, 0x7b, 0x49, 0x69, 0x7b, 0x49, 0x6f,
    0x7b, 0x49, 0x73, 0x7b, 0x49, 0x74, 0x7b, 0x49, 0x20, 0x7b, 0x49, 0x25,
    0x7b, 0x49, 0x2d, 0x7b, 0x49, 0x2e, 0x7b, 0x49, 0x2f, 0x7b, 0x49, 0x33,
    0x7b, 0x49, 0x34, 0x7b, 0x49, 0x35, 0x7b, 0x49, 0x36, 0x7b, 0x49, 0x37,
    0x7b, 0x49, 0x38, 0x7b, 0x49, 0x39, 0x7b, 0x49, 0x3d, 0x7b, 0x49, 0x41,
    0x7b, 0x49, 0x5f, 0x7b, 0x49, 0x62, 0x7b, 0x49, 0x64, 0x7b, 0x49, 0x66,
    0x7b, 0x49, 0x67, 0x7b, 0x49, 0x68, 0x7b, 0x49, 0x6c, 0x7b, 0x49, 0x6d,
    0x7b, 0x49, 0x6e, 0x7b, 0x49, 0x70, 0x7b, 0x49, 0x72, 0x7b, 0x49, 0x75,
    0x7b, 0x49, 0x3a, 0x7b, 0x49, 0x42, 0x7b, 0x49, 0x43, 0x7b, 0x49, 0x44,
    0x7b, 0x49, 0x45, 0x7b, 0x49, 0x46, 0x7b, 0x49, 0x47, 0x7b, 0x49, 0x48,
    0x7b, 0x49, 0x49, 0x7b, 0x49, 0x4a, 0x7b, 0x49, 0x4b, 0x7b, 0x49, 0x4c,
    0x7b, 0x49, 0x4d, 0x7b, 0x49, 0x4e, 0x7b, 0x49, 0x4f, 0x7b, 0x49, 0x50,
    0x7b, 0x49, 0x51, 0x7b, 0x49, 0x52, 0x7b, 0x49, 0x53, 0x7b, 0x49, 0x54,
    0x7b, 0x49, 0x55, 0x7b, 0x49, 0x56, 0x7b, 0x49, 0x57, 0x7b, 0x49, 0x59,
    0x7b, 0x49, 0x6a, 0x7b, 0x49, 0x6b, 0x7b, 0x49, 0x71, 0x7b, 0x49, 0x76,
    0x7b, 0x49, 0x77, 0x7b, 0x49, 0x78, 0x7b, 0x49, 0x79, 0x7b, 0x49, 0x7a,
    0x7b, 0x4a, 0x30, 0x7b, 0x4a, 0x31, 0x7b, 0x4a, 0x32, 0x7b, 0x4a, 0x61,
    0x7b, 0x4a, 0x63, 0x7b, 0x4a, 0x65, 0x7b, 0x4a, 0x69, 0x7b, 0x4a, 0x6f,
    0x7b, 0x4a, 0x73, 0x7b, 0x4a, 0x74, 0x7b, 0x4a, 0x20, 0x7b, 0x4a, 0x25,
    0x7b, 0x4a, 0x2d, 0x7b, 0x4a, 0x2e, 0x7b, 0x4a, 0x2f, 0x7b, 0x4a, 0x33,
    0x7b, 0x4a, 0x34, 0x7b, 0x4a, 0x35, 0x7b, 0x4a, 0x36, 0x7b, 0x4a, 0x37,
    0x7b, 0x4a, 0x38, 0x7b, 0x4a, 0x39, 0x7b, 0x4a, 0x3d, 0x7b, 0x4a, 0x41,
    0x7b, 0x4a, 0x5f, 0x7b, 0x4a, 0x62, 0x7b, 0x4a, 0x64, 0x7b, 0x4a, 0x66,
    0x7b, 0x4a, 0x67, 0x7b, 0x4a, 0x68, 0x7b, 0x4a, 0x6c, 0x7b, 0x4a, 0x6d,
    0x7b, 0x4a, 0x6e, 0x7b, 0x4a, 0x70, 0x7b, 0x4a, 0x72, 0x7b, 0x4a, 0x75,
    0x7b, 0x4a, 0x3a, 0x7b, 0x4a, 0x42, 0x7b, 0x4a, 0x43, 0x7b, 0x4a, 0x44,
    0x7b, 0x4a, 0x45, 0x7b, 0x4a, 0x46, 0x7b, 0x4a, 0x47, 0x7b, 0x4a, 0x48,
    0x7b, 0x4a, 0x49, 0x7b, 0x4a, 0x4a, 0x7b, 0x4a, 0x4b, 0x7b, 0x4a, 0x4c,
    0x7b, 0x4a, 0x4d, 0x7b, 0x4a, 0x4e, 0x7b, 0x4a, 0x4f, 0x7b, 0x4a, 0x50,
    0x7b, 0x4a, 0x51, 0x7b, 0x4a, 0x52, 0x7b, 0x4a, 0x53, 0x7b, 0x4a, 0x54,
    0x7b, 0x4a, 0x55, 0x7b, 0x4a, 0x56, 0x7b, 0x4a, 0x57, 0x7b, 0x4a, 0x59,
    0x7b, 0x4a, 0x6a, 0x7b, 0x4a, 0x6b, 0x7b, 0x4a, 0x71, 0x7b, 0x4a, 0x76,
    0x7b, 0x4a, 0x77, 0x7b, 0x4a, 0x78, 0x7b, 0x4a, 0x79, 0x7b, 0x4a, 0x7a};
const uint8_t HuffDecoderCommon::table30_51_emit_[408] = {
    0x7b, 0x4b, 0x30, 0x7b, 0x4b, 0x31, 0x7b, 0x4b, 0x32, 0x7b, 0x4b, 0x61,
    0x7b, 0x4b, 0x63, 0x7b, 0x4b, 0x65, 0x7b, 0x4b, 0x69, 0x7b, 0x4b, 0x6f,
    0x7b, 0x4b, 0x73, 0x7b, 0x4b, 0x74, 0x7b, 0x4b, 0x20, 0x7b, 0x4b, 0x25,
    0x7b, 0x4b, 0x2d, 0x7b, 0x4b, 0x2e, 0x7b, 0x4b, 0x2f, 0x7b, 0x4b, 0x33,
    0x7b, 0x4b, 0x34, 0x7b, 0x4b, 0x35, 0x7b, 0x4b, 0x36, 0x7b, 0x4b, 0x37,
    0x7b, 0x4b, 0x38, 0x7b, 0x4b, 0x39, 0x7b, 0x4b, 0x3d, 0x7b, 0x4b, 0x41,
    0x7b, 0x4b, 0x5f, 0x7b, 0x4b, 0x62, 0x7b, 0x4b, 0x64, 0x7b, 0x4b, 0x66,
    0x7b, 0x4b, 0x67, 0x7b, 0x4b, 0x68, 0x7b, 0x4b, 0x6c, 0x7b, 0x4b, 0x6d,
    0x7b, 0x4b, 0x6e, 0x7b, 0x4b, 0x70, 0x7b, 0x4b, 0x72, 0x7b, 0x4b, 0x75,
    0x7b, 0x4b, 0x3a, 0x7b, 0x4b, 0x42, 0x7b, 0x4b, 0x43, 0x7b, 0x4b, 0x44,
    0x7b, 0x4b, 0x45, 0x7b, 0x4b, 0x46, 0x7b, 0x4b, 0x47, 0x7b, 0x4b, 0x48,
    0x7b, 0x4b, 0x49, 0x7b, 0x4b, 0x4a, 0x7b, 0x4b, 0x4b, 0x7b, 0x4b, 0x4c,
    0x7b, 0x4b, 0x4d, 0x7b, 0x4b, 0x4e, 0x7b, 0x4b, 0x4f, 0x7b, 0x4b, 0x50,
    0x7b, 0x4b, 0x51, 0x7b, 0x4b, 0x52, 0x7b, 0x4b, 0x53, 0x7b, 0x4b, 0x54,
    0x7b, 0x4b, 0x55, 0x7b, 0x4b, 0x56, 0x7b, 0x4b, 0x57, 0x7b, 0x4b, 0x59,
    0x7b, 0x4b, 0x6a, 0x7b, 0x4b, 0x6b, 0x7b, 0x4b, 0x71, 0x7b, 0x4b, 0x76,
    0x7b, 0x4b, 0x77, 0x7b, 0x4b, 0x78, 0x7b, 0x4b, 0x79, 0x7b, 0x4b, 0x7a,
    0x7b, 0x4c, 0x30, 0x7b, 0x4c, 0x31, 0x7b, 0x4c, 0x32, 0x7b, 0x4c, 0x61,
    0x7b, 0x4c, 0x63, 0x7b, 0x4c, 0x65, 0x7b, 0x4c, 0x69, 0x7b, 0x4c, 0x6f,
    0x7b, 0x4c, 0x73, 0x7b, 0x4c, 0x74, 0x7b, 0x4c, 0x20, 0x7b, 0x4c, 0x25,
    0x7b, 0x4c, 0x2d, 0x7b, 0x4c, 0x2e, 0x7b, 0x4c, 0x2f, 0x7b, 0x4c, 0x33,
    0x7b, 0x4c, 0x34, 0x7b, 0x4c, 0x35, 0x7b, 0x4c, 0x36, 0x7b, 0x4c, 0x37,
    0x7b, 0x4c, 0x38, 0x7b, 0x4c, 0x39, 0x7b, 0x4c, 0x3d, 0x7b, 0x4c, 0x41,
    0x7b, 0x4c, 0x5f, 0x7b, 0x4c, 0x62, 0x7b, 0x4c, 0x64, 0x7b, 0x4c, 0x66,
    0x7b, 0x4c, 0x67, 0x7b, 0x4c, 0x68, 0x7b, 0x4c, 0x6c, 0x7b, 0x4c, 0x6d,
    0x7b, 0x4c, 0x6e, 0x7b, 0x4c, 0x70, 0x7b, 0x4c, 0x72, 0x7b, 0x4c, 0x75,
    0x7b, 0x4c, 0x3a, 0x7b, 0x4c, 0x42, 0x7b, 0x4c, 0x43, 0x7b, 0x4c, 0x44,
    0x7b, 0x4c, 0x45, 0x7b, 0x4c, 0x46, 0x7b, 0x4c, 0x47, 0x7b, 0x4c, 0x48,
    0x7b, 0x4c, 0x49, 0x7b, 0x4c, 0x4a, 0x7b, 0x4c, 0x4b, 0x7b, 0x4c, 0x4c,
    0x7b, 0x4c, 0x4d, 0x7b, 0x4c, 0x4e, 0x7b, 0x4c, 0x4f, 0x7b, 0x4c, 0x50,
    0x7b, 0x4c, 0x51, 0x7b, 0x4c, 0x52, 0x7b, 0x4c, 0x53, 0x7b, 0x4c, 0x54,
    0x7b, 0x4c, 0x55, 0x7b, 0x4c, 0x56, 0x7b, 0x4c, 0x57, 0x7b, 0x4c, 0x59,
    0x7b, 0x4c, 0x6a, 0x7b, 0x4c, 0x6b, 0x7b, 0x4c, 0x71, 0x7b, 0x4c, 0x76,
    0x7b, 0x4c, 0x77, 0x7b, 0x4c, 0x78, 0x7b, 0x4c, 0x79, 0x7b, 0x4c, 0x7a};
const uint8_t HuffDecoderCommon::table30_52_emit_[408] = {
    0x7b, 0x4d, 0x30, 0x7b, 0x4d, 0x31, 0x7b, 0x4d, 0x32, 0x7b, 0x4d, 0x61,
    0x7b, 0x4d, 0x63, 0x7b, 0x4d, 0x65, 0x7b, 0x4d, 0x69, 0x7b, 0x4d, 0x6f,
    0x7b, 0x4d, 0x73, 0x7b, 0x4d, 0x74, 0x7b, 0x4d, 0x20, 0x7b, 0x4d, 0x25,
    0x7b, 0x4d, 0x2d, 0x7b, 0x4d, 0x2e, 0x7b, 0x4d, 0x2f, 0x7b, 0x4d, 0x33,
    0x7b, 0x4d, 0x34, 0x7b, 0x4d, 0x35, 0x7b, 0x4d, 0x36, 0x7b, 0x4d, 0x37,
    0x7b, 0x4d, 0x38, 0x7b, 0x4d, 0x39, 0x7b, 0x4d, 0x3d, 0x7b, 0x4d, 0x41,
    0x7b, 0x4d, 0x5f, 0x7b, 0x4d, 0x62, 0x7b, 0x4d, 0x64, 0x7b, 0x4d, 0x66,
    0x7b, 0x4d, 0x67, 0x7b, 0x4d, 0x68, 0x7b, 0x4d, 0x6c, 0x7b, 0x4d, 0x6d,
    0x7b, 0x4d, 0x6e, 0x7b, 0x4d, 0x70, 0x7b, 0x4d, 0x72, 0x7b, 0x4d, 0x75,
    0x7b, 0x4d, 0x3a, 0x7b, 0x4d, 0x42, 0x7b, 0x4d, 0x43, 0x7b, 0x4d, 0x44,
    0x7b, 0x4d, 0x45, 0x7b, 0x4d, 0x46, 0x7b, 0x4d, 0x47, 0x7b, 0x4d, 0x48,
    0x7b, 0x4d, 0x49, 0x7b, 0x4d, 0x4a, 0x7b, 0x4d, 0x4b, 0x7b, 0x4d, 0x4c,
    0x7b, 0x4d, 0x4d, 0x7b, 0x4d, 0x4e, 0x7b, 0x4d, 0x4f, 0x7b, 0x4d, 0x50,
    0x7b, 0x4d, 0x51, 0x7b, 0x4d, 0x52, 0x7b, 0x4d, 0x53, 0x7b, 0x4d, 0x54,
    0x7b, 0x4d, 0x55, 0x7b, 0x4d, 0x56, 0x7b, 0x4d, 0x57, 0x7b, 0x4d, 0x59,
    0x7b, 0x4d, 0x6a, 0x7b, 0x4d, 0x6b, 0x7b, 0x4d, 0x71, 0x7b, 0x4d, 0x76,
    0x7b, 0x4d, 0x77, 0x7b, 0x4d, 0x78, 0x7b, 0x4d, 0x79, 0x7b, 0x4d, 0x7a,
    0x7b, 0x4e, 0x30, 0x7b, 0x4e, 0x31, 0x7b, 0x4e, 0x32, 0x7b, 0x4e, 0x61,
    0x7b, 0x4e, 0x63, 0x7b, 0x4e, 0x65, 0x7b, 0x4e, 0x69, 0x7b, 0x4e, 0x6f,
    0x7b, 0x4e, 0x73, 0x7b, 0x4e, 0x74, 0x7b, 0x4e, 0x20, 0x7b, 0x4e, 0x25,
    0x7b, 0x4e, 0x2d, 0x7b, 0x4e, 0x2e, 0x7b, 0x4e, 0x2f, 0x7b, 0x4e, 0x33,
    0x7b, 0x4e, 0x34, 0x7b, 0x4e, 0x35, 0x7b, 0x4e, 0x36, 0x7b, 0x4e, 0x37,
    0x7b, 0x4e, 0x38, 0x7b, 0x4e, 0x39, 0x7b, 0x4e, 0x3d, 0x7b, 0x4e, 0x41,
    0x7b, 0x4e, 0x5f, 0x7b, 0x4e, 0x62, 0x7b, 0x4e, 0x64, 0x7b, 0x4e, 0x66,
    0x7b, 0x4e, 0x67, 0x7b, 0x4e, 0x68, 0x7b, 0x4e, 0x6c, 0x7b, 0x4e, 0x6d,
    0x7b, 0x4e, 0x6e, 0x7b, 0x4e, 0x70, 0x7b, 0x4e, 0x72, 0x7b, 0x4e, 0x75,
    0x7b, 0x4e, 0x3a, 0x7b, 0x4e, 0x42, 0x7b, 0x4e, 0x43, 0x7b, 0x4e, 0x44,
    0x7b, 0x4e, 0x45, 0x7b, 0x4e, 0x46, 0x7b, 0x4e, 0x47, 0x7b, 0x4e, 0x48,
    0x7b, 0x4e, 0x49, 0x7b, 0x4e, 0x4a, 0x7b, 0x4e, 0x4b, 0x7b, 0x4e, 0x4c,
    0x7b, 0x4e, 0x4d, 0x7b, 0x4e, 0x4e, 0x7b, 0x4e, 0x4f, 0x7b, 0x4e, 0x50,
    0x7b, 0x4e, 0x51, 0x7b, 0x4e, 0x52, 0x7b, 0x4e, 0x53, 0x7b, 0x4e, 0x54,
    0x7b, 0x4e, 0x55, 0x7b, 0x4e, 0x56, 0x7b, 0x4e, 0x57, 0x7b, 0x4e, 0x59,
    0x7b, 0x4e, 0x6a, 0x7b, 0x4e, 0x6b, 0x7b, 0x4e, 0x71, 0x7b, 0x4e, 0x76,
    0x7b, 0x4e, 0x77, 0x7b, 0x4e, 0x78, 0x7b, 0x4e, 0x79, 0x7b, 0x4e, 0x7a};
const uint8_t HuffDecoderCommon::table30_53_emit_[408] = {
    0x7b, 0x4f, 0x30, 0x7b, 0x4f, 0x31, 0x7b, 0x4f, 0x32, 0x7b, 0x4f, 0x61,
    0x7b, 0x4f, 0x63, 0x7b, 0x4f, 0x65, 0x7b, 0x4f, 0x69, 0x7b, 0x4f, 0x6f,
    0x7b, 0x4f, 0x73, 0x7b, 0x4f, 0x74, 0x7b, 0x4f, 0x20, 0x7b, 0x4f, 0x25,
    0x7b, 0x4f, 0x2d, 0x7b, 0x4f, 0x2e, 0x7b, 0x4f, 0x2f, 0x7b, 0x4f, 0x33,
    0x7b, 0x4f, 0x34, 0x7b, 0x4f, 0x35, 0x7b, 0x4f, 0x36, 0x7b, 0x4f, 0x37,
    0x7b, 0x4f, 0x38, 0x7b, 0x4f, 0x39, 0x7b, 0x4f, 0x3d, 0x7b, 0x4f, 0x41,
    0x7b, 0x4f, 0x5f, 0x7b, 0x4f, 0x62, 0x7b, 0x4f, 0x64, 0x7b, 0x4f, 0x66,
    0x7b, 0x4f, 0x67, 0x7b, 0x4f, 0x68, 0x7b, 0x4f, 0x6c, 0x7b, 0x4f, 0x6d,
    0x7b, 0x4f, 0x6e, 0x7b, 0x4f, 0x70, 0x7b, 0x4f, 0x72, 0x7b, 0x4f, 0x75,
    0x7b, 0x4f, 0x3a, 0x7b, 0x4f, 0x42, 0x7b, 0x4f, 0x43, 0x7b, 0x4f, 0x44,
    0x7b, 0x4f, 0x45, 0x7b, 0x4f, 0x46, 0x7b, 0x4f, 0x47, 0x7b, 0x4f, 0x48,
    0x7b, 0x4f, 0x49, 0x7b, 0x4f, 0x4a, 0x7b, 0x4f, 0x4b, 0x7b, 0x4f, 0x4c,
    0x7b, 0x4f, 0x4d, 0x7b, 0x4f, 0x4e, 0x7b, 0x4f, 0x4f, 0x7b, 0x4f, 0x50,
    0x7b, 0x4f, 0x51, 0x7b, 0x4f, 0x52, 0x7b, 0x4f, 0x53, 0x7b, 0x4f, 0x54,
    0x7b, 0x4f, 0x55, 0x7b, 0x4f, 0x56, 0x7b, 0x4f, 0x57, 0x7b, 0x4f, 0x59,
    0x7b, 0x4f, 0x6a, 0x7b, 0x4f, 0x6b, 0x7b, 0x4f, 0x71, 0x7b, 0x4f, 0x76,
    0x7b, 0x4f, 0x77, 0x7b, 0x4f, 0x78, 0x7b, 0x4f, 0x79, 0x7b, 0x4f, 0x7a,
    0x7b, 0x50, 0x30, 0x7b, 0x50, 0x31, 0x7b, 0x50, 0x32, 0x7b, 0x50, 0x61,
    0x7b, 0x50, 0x63, 0x7b, 0x50, 0x65, 0x7b, 0x50, 0x69, 0x7b, 0x50, 0x6f,
    0x7b, 0x50, 0x73, 0x7b, 0x50, 0x74, 0x7b, 0x50, 0x20, 0x7b, 0x50, 0x25,
    0x7b, 0x50, 0x2d, 0x7b, 0x50, 0x2e, 0x7b, 0x50, 0x2f, 0x7b, 0x50, 0x33,
    0x7b, 0x50, 0x34, 0x7b, 0x50, 0x35, 0x7b, 0x50, 0x36, 0x7b, 0x50, 0x37,
    0x7b, 0x50, 0x38, 0x7b, 0x50, 0x39, 0x7b, 0x50, 0x3d, 0x7b, 0x50, 0x41,
    0x7b, 0x50, 0x5f, 0x7b, 0x50, 0x62, 0x7b, 0x50, 0x64, 0x7b, 0x50, 0x66,
    0x7b, 0x50, 0x67, 0x7b, 0x50, 0x68, 0x7b, 0x50, 0x6c, 0x7b, 0x50, 0x6d,
    0x7b, 0x50, 0x6e, 0x7b, 0x50, 0x70, 0x7b, 0x50, 0x72, 0x7b, 0x50, 0x75,
    0x7b, 0x50, 0x3a, 0x7b, 0x50, 0x42, 0x7b, 0x50, 0x43, 0x7b, 0x50, 0x44,
    0x7b, 0x50, 0x45, 0x7b, 0x50, 0x46, 0x7b, 0x50, 0x47, 0x7b, 0x50, 0x48,
    0x7b, 0x50, 0x49, 0x7b, 0x50, 0x4a, 0x7b, 0x50, 0x4b, 0x7b, 0x50, 0x4c,
    0x7b, 0x50, 0x4d, 0x7b, 0x50, 0x4e, 0x7b, 0x50, 0x4f, 0x7b, 0x50, 0x50,
    0x7b, 0x50, 0x51, 0x7b, 0x50, 0x52, 0x7b, 0x50, 0x53, 0x7b, 0x50, 0x54,
    0x7b, 0x50, 0x55, 0x7b, 0x50, 0x56, 0x7b, 0x50, 0x57, 0x7b, 0x50, 0x59,
    0x7b, 0x50, 0x6a, 0x7b, 0x50, 0x6b, 0x7b, 0x50, 0x71, 0x7b, 0x50, 0x76,
    0x7b, 0x50, 0x77, 0x7b, 0x50, 0x78, 0x7b, 0x50, 0x79, 0x7b, 0x50, 0x7a};
const uint8_t HuffDecoderCommon::table30_54_emit_[408] = {
    0x7b, 0x51, 0x30, 0x7b, 0x51, 0x31, 0x7b, 0x51, 0x32, 0x7b, 0x51, 0x61,
    0x7b, 0x51, 0x63, 0x7b, 0x51, 0x65, 0x7b, 0x51, 0x69, 0x7b, 0x51, 0x6f,
    0x7b, 0x51, 0x73, 0x7b, 0x51, 0x74, 0x7b, 0x51, 0x20, 0x7b, 0x51, 0x25,
    0x7b, 0x51, 0x2d, 0x7b, 0x51, 0x2e, 0x7b, 0x51, 0x2f, 0x7b, 0x51, 0x33,
    0x7b, 0x51, 0x34, 0x7b, 0x51, 0x35, 0x7b, 0x51, 0x36, 0x7b, 0x51, 0x37,
    0x7b, 0x51, 0x38, 0x7b, 0x51, 0x39, 0x7b, 0x51, 0x3d, 0x7b, 0x51, 0x41,
    0x7b, 0x51, 0x5f, 0x7b, 0x51, 0x62, 0x7b, 0x51, 0x64, 0x7b, 0x51, 0x66,
    0x7b, 0x51, 0x67, 0x7b, 0x51, 0x68, 0x7b, 0x51, 0x6c, 0x7b, 0x51, 0x6d,
    0x7b, 0x51, 0x6e, 0x7b, 0x51, 0x70, 0x7b, 0x51, 0x72, 0x7b, 0x51, 0x75,
    0x7b, 0x51, 0x3a, 0x7b, 0x51, 0x42, 0x7b, 0x51, 0x43, 0x7b, 0x51, 0x44,
    0x7b, 0x51, 0x45, 0x7b, 0x51, 0x46, 0x7b, 0x51, 0x47, 0x7b, 0x51, 0x48,
    0x7b, 0x51, 0x49, 0x7b, 0x51, 0x4a, 0x7b, 0x51, 0x4b, 0x7b, 0x51, 0x4c,
    0x7b, 0x51, 0x4d, 0x7b, 0x51, 0x4e, 0x7b, 0x51, 0x4f, 0x7b, 0x51, 0x50,
    0x7b, 0x51, 0x51, 0x7b, 0x51, 0x52, 0x7b, 0x51, 0x53, 0x7b, 0x51, 0x54,
    0x7b, 0x51, 0x55, 0x7b, 0x51, 0x56, 0x7b, 0x51, 0x57, 0x7b, 0x51, 0x59,
    0x7b, 0x51, 0x6a, 0x7b, 0x51, 0x6b, 0x7b, 0x51, 0x71, 0x7b, 0x51, 0x76,
    0x7b, 0x51, 0x77, 0x7b, 0x51, 0x78, 0x7b, 0x51, 0x79, 0x7b, 0x51, 0x7a,
    0x7b, 0x52, 0x30, 0x7b, 0x52, 0x31, 0x7b, 0x52, 0x32, 0x7b, 0x52, 0x61,
    0x7b, 0x52, 0x63, 0x7b, 0x52, 0x65, 0x7b, 0x52, 0x69, 0x7b, 0x52, 0x6f,
    0x7b, 0x52, 0x73, 0x7b, 0x52, 0x74, 0x7b, 0x52, 0x20, 0x7b, 0x52, 0x25,
    0x7b, 0x52, 0x2d, 0x7b, 0x52, 0x2e, 0x7b, 0x52, 0x2f, 0x7b, 0x52, 0x33,
    0x7b, 0x52, 0x34, 0x7b, 0x52, 0x35, 0x7b, 0x52, 0x36, 0x7b, 0x52, 0x37,
    0x7b, 0x52, 0x38, 0x7b, 0x52, 0x39, 0x7b, 0x52, 0x3d, 0x7b, 0x52, 0x41,
    0x7b, 0x52, 0x5f, 0x7b, 0x52, 0x62, 0x7b, 0x52, 0x64, 0x7b, 0x52, 0x66,
    0x7b, 0x52, 0x67, 0x7b, 0x52, 0x68, 0x7b, 0x52, 0x6c, 0x7b, 0x52, 0x6d,
    0x7b, 0x52, 0x6e, 0x7b, 0x52, 0x70, 0x7b, 0x52, 0x72, 0x7b, 0x52, 0x75,
    0x7b, 0x52, 0x3a, 0x7b, 0x52, 0x42, 0x7b, 0x52, 0x43, 0x7b, 0x52, 0x44,
    0x7b, 0x52, 0x45, 0x7b, 0x52, 0x46, 0x7b, 0x52, 0x47, 0x7b, 0x52, 0x48,
    0x7b, 0x52, 0x49, 0x7b, 0x52, 0x4a, 0x7b, 0x52, 0x4b, 0x7b, 0x52, 0x4c,
    0x7b, 0x52, 0x4d, 0x7b, 0x52, 0x4e, 0x7b, 0x52, 0x4f, 0x7b, 0x52, 0x50,
    0x7b, 0x52, 0x51, 0x7b, 0x52, 0x52, 0x7b, 0x52, 0x53, 0x7b, 0x52, 0x54,
    0x7b, 0x52, 0x55, 0x7b, 0x52, 0x56, 0x7b, 0x52, 0x57, 0x7b, 0x52, 0x59,
    0x7b, 0x52, 0x6a, 0x7b, 0x52, 0x6b, 0x7b, 0x52, 0x71, 0x7b, 0x52, 0x76,
    0x7b, 0x52, 0x77, 0x7b, 0x52, 0x78, 0x7b, 0x52, 0x79, 0x7b, 0x52, 0x7a};
const uint8_t HuffDecoderCommon::table30_55_emit_[408] = {
    0x7b, 0x53, 0x30, 0x7b, 0x53, 0x31, 0x7b, 0x53, 0x32, 0x7b, 0x53, 0x61,
    0x7b, 0x53, 0x63, 0x7b, 0x53, 0x65, 0x7b, 0x53, 0x69, 0x7b, 0x53, 0x6f,
    0x7b, 0x53, 0x73, 0x7b, 0x53, 0x74, 0x7b, 0x53, 0x20, 0x7b, 0x53, 0x25,
    0x7b, 0x53, 0x2d, 0x7b, 0x53, 0x2e, 0x7b, 0x53, 0x2f, 0x7b, 0x53, 0x33,
    0x7b, 0x53, 0x34, 0x7b, 0x53, 0x35, 0x7b, 0x53, 0x36, 0x7b, 0x53, 0x37,
    0x7b, 0x53, 0x38, 0x7b, 0x53, 0x39, 0x7b, 0x53, 0x3d, 0x7b, 0x53, 0x41,
    0x7b, 0x53, 0x5f, 0x7b, 0x53, 0x62, 0x7b, 0x53, 0x64, 0x7b, 0x53, 0x66,
    0x7b, 0x53, 0x67, 0x7b, 0x53, 0x68, 0x7b, 0x53, 0x6c, 0x7b, 0x53, 0x6d,
    0x7b, 0x53, 0x6e, 0x7b, 0x53, 0x70, 0x7b, 0x53, 0x72, 0x7b, 0x53, 0x75,
    0x7b, 0x53, 0x3a, 0x7b, 0x53, 0x42, 0x7b, 0x53, 0x43, 0x7b, 0x53, 0x44,
    0x7b, 0x53, 0x45, 0x7b, 0x53, 0x46, 0x7b, 0x53, 0x47, 0x7b, 0x53, 0x48,
    0x7b, 0x53, 0x49, 0x7b, 0x53, 0x4a, 0x7b, 0x53, 0x4b, 0x7b, 0x53, 0x4c,
    0x7b, 0x53, 0x4d, 0x7b, 0x53, 0x4e, 0x7b, 0x53, 0x4f, 0x7b, 0x53, 0x50,
    0x7b, 0x53, 0x51, 0x7b, 0x53, 0x52, 0x7b, 0x53, 0x53, 0x7b, 0x53, 0x54,
    0x7b, 0x53, 0x55, 0x7b, 0x53, 0x56, 0x7b, 0x53, 0x57, 0x7b, 0x53, 0x59,
    0x7b, 0x53, 0x6a, 0x7b, 0x53, 0x6b, 0x7b, 0x53, 0x71, 0x7b, 0x53, 0x76,
    0x7b, 0x53, 0x77, 0x7b, 0x53, 0x78, 0x7b, 0x53, 0x79, 0x7b, 0x53, 0x7a,
    0x7b, 0x54, 0x30, 0x7b, 0x54, 0x31, 0x7b, 0x54, 0x32, 0x7b, 0x54, 0x61,
    0x7b, 0x54, 0x63, 0x7b, 0x54, 0x65, 0x7b, 0x54, 0x69, 0x7b, 0x54, 0x6f,
    0x7b, 0x54, 0x73, 0x7b, 0x54, 0x74, 0x7b, 0x54, 0x20, 0x7b, 0x54, 0x25,
    0x7b, 0x54, 0x2d, 0x7b, 0x54, 0x2e, 0x7b, 0x54, 0x2f, 0x7b, 0x54, 0x33,
    0x7b, 0x54, 0x34, 0x7b, 0x54, 0x35, 0x7b, 0x54, 0x36, 0x7b, 0x54, 0x37,
    0x7b, 0x54, 0x38, 0x7b, 0x54, 0x39, 0x7b, 0x54, 0x3d, 0x7b, 0x54, 0x41,
    0x7b, 0x54, 0x5f, 0x7b, 0x54, 0x62, 0x7b, 0x54, 0x64, 0x7b, 0x54, 0x66,
    0x7b, 0x54, 0x67, 0x7b, 0x54, 0x68, 0x7b, 0x54, 0x6c, 0x7b, 0x54, 0x6d,
    0x7b, 0x54, 0x6e, 0x7b, 0x54, 0x70, 0x7b, 0x54, 0x72, 0x7b, 0x54, 0x75,
    0x7b, 0x54, 0x3a, 0x7b, 0x54, 0x42, 0x7b, 0x54, 0x43, 0x7b, 0x54, 0x44,
    0x7b, 0x54, 0x45, 0x7b, 0x54, 0x46, 0x7b, 0x54, 0x47, 0x7b, 0x54, 0x48,
    0x7b, 0x54, 0x49, 0x7b, 0x54, 0x4a, 0x7b, 0x54, 0x4b, 0x7b, 0x54, 0x4c,
    0x7b, 0x54, 0x4d, 0x7b, 0x54, 0x4e, 0x7b, 0x54, 0x4f, 0x7b, 0x54, 0x50,
    0x7b, 0x54, 0x51, 0x7b, 0x54, 0x52, 0x7b, 0x54, 0x53, 0x7b, 0x54, 0x54,
    0x7b, 0x54, 0x55, 0x7b, 0x54, 0x56, 0x7b, 0x54, 0x57, 0x7b, 0x54, 0x59,
    0x7b, 0x54, 0x6a, 0x7b, 0x54, 0x6b, 0x7b, 0x54, 0x71, 0x7b, 0x54, 0x76,
    0x7b, 0x54, 0x77, 0x7b, 0x54, 0x78, 0x7b, 0x54, 0x79, 0x7b, 0x54, 0x7a};
const uint8_t HuffDecoderCommon::table30_56_emit_[408] = {
    0x7b, 0x55, 0x30, 0x7b, 0x55, 0x31, 0x7b, 0x55, 0x32, 0x7b, 0x55, 0x61,
    0x7b, 0x55, 0x63, 0x7b, 0x55, 0x65, 0x7b, 0x55, 0x69, 0x7b, 0x55, 0x6f,
    0x7b, 0x55, 0x73, 0x7b, 0x55, 0x74, 0x7b, 0x55, 0x20, 0x7b, 0x55, 0x25,
    0x7b, 0x55, 0x2d, 0x7b, 0x55, 0x2e, 0x7b, 0x55, 0x2f, 0x7b, 0x55, 0x33,
    0x7b, 0x55, 0x34, 0x7b, 0x55, 0x35, 0x7b, 0x55, 0x36, 0x7b, 0x55, 0x37,
    0x7b, 0x55, 0x38, 0x7b, 0x55, 0x39, 0x7b, 0x55, 0x3d, 0x7b, 0x55, 0x41,
    0x7b, 0x55, 0x5f, 0x7b, 0x55, 0x62, 0x7b, 0x55, 0x64, 0x7b, 0x55, 0x66,
    0x7b, 0x55, 0x67, 0x7b, 0x55, 0x68, 0x7b, 0x55, 0x6c, 0x7b, 0x55, 0x6d,
    0x7b, 0x55, 0x6e, 0x7b, 0x55, 0x70, 0x7b, 0x55, 0x72, 0x7b, 0x55, 0x75,
    0x7b, 0x55, 0x3a, 0x7b, 0x55, 0x42, 0x7b, 0x55, 0x43, 0x7b, 0x55, 0x44,
    0x7b, 0x55, 0x45, 0x7b, 0x55, 0x46, 0x7b, 0x55, 0x47, 0x7b, 0x55, 0x48,
    0x7b, 0x55, 0x49, 0x7b, 0x55, 0x4a, 0x7b, 0x55, 0x4b, 0x7b, 0x55, 0x4c,
    0x7b, 0x55, 0x4d, 0x7b, 0x55, 0x4e, 0x7b, 0x55, 0x4f, 0x7b, 0x55, 0x50,
    0x7b, 0x55, 0x51, 0x7b, 0x55, 0x52, 0x7b, 0x55, 0x53, 0x7b, 0x55, 0x54,
    0x7b, 0x55, 0x55, 0x7b, 0x55, 0x56, 0x7b, 0x55, 0x57, 0x7b, 0x55, 0x59,
    0x7b, 0x55, 0x6a, 0x7b, 0x55, 0x6b, 0x7b, 0x55, 0x71, 0x7b, 0x55, 0x76,
    0x7b, 0x55, 0x77, 0x7b, 0x55, 0x78, 0x7b, 0x55, 0x79, 0x7b, 0x55, 0x7a,
    0x7b, 0x56, 0x30, 0x7b, 0x56, 0x31, 0x7b, 0x56, 0x32, 0x7b, 0x56, 0x61,
    0x7b, 0x56, 0x63, 0x7b, 0x56, 0x65, 0x7b, 0x56, 0x69, 0x7b, 0x56, 0x6f,
    0x7b, 0x56, 0x73, 0x7b, 0x56, 0x74, 0x7b, 0x56, 0x20, 0x7b, 0x56, 0x25,
    0x7b, 0x56, 0x2d, 0x7b, 0x56, 0x2e, 0x7b, 0x56, 0x2f, 0x7b, 0x56, 0x33,
    0x7b, 0x56, 0x34, 0x7b, 0x56, 0x35, 0x7b, 0x56, 0x36, 0x7b, 0x56, 0x37,
    0x7b, 0x56, 0x38, 0x7b, 0x56, 0x39, 0x7b, 0x56, 0x3d, 0x7b, 0x56, 0x41,
    0x7b, 0x56, 0x5f, 0x7b, 0x56, 0x62, 0x7b, 0x56, 0x64, 0x7b, 0x56, 0x66,
    0x7b, 0x56, 0x67, 0x7b, 0x56, 0x68, 0x7b, 0x56, 0x6c, 0x7b, 0x56, 0x6d,
    0x7b, 0x56, 0x6e, 0x7b, 0x56, 0x70, 0x7b, 0x56, 0x72, 0x7b, 0x56, 0x75,
    0x7b, 0x56, 0x3a, 0x7b, 0x56, 0x42, 0x7b, 0x56, 0x43, 0x7b, 0x56, 0x44,
    0x7b, 0x56, 0x45, 0x7b, 0x56, 0x46, 0x7b, 0x56, 0x47, 0x7b, 0x56, 0x48,
    0x7b, 0x56, 0x49, 0x7b, 0x56, 0x4a, 0x7b, 0x56, 0x4b, 0x7b, 0x56, 0x4c,
    0x7b, 0x56, 0x4d, 0x7b, 0x56, 0x4e, 0x7b, 0x56, 0x4f, 0x7b, 0x56, 0x50,
    0x7b, 0x56, 0x51, 0x7b, 0x56, 0x52, 0x7b, 0x56, 0x53, 0x7b, 0x56, 0x54,
    0x7b, 0x56, 0x55, 0x7b, 0x56, 0x56, 0x7b, 0x56, 0x57, 0x7b, 0x56, 0x59,
    0x7b, 0x56, 0x6a, 0x7b, 0x56, 0x6b, 0x7b, 0x56, 0x71, 0x7b, 0x56, 0x76,
    0x7b, 0x56, 0x77, 0x7b, 0x56, 0x78, 0x7b, 0x56, 0x79, 0x7b, 0x56, 0x7a};
const uint8_t HuffDecoderCommon::table30_57_emit_[408] = {
    0x7b, 0x57, 0x30, 0x7b, 0x57, 0x31, 0x7b, 0x57, 0x32, 0x7b, 0x57, 0x61,
    0x7b, 0x57, 0x63, 0x7b, 0x57, 0x65, 0x7b, 0x57, 0x69, 0x7b, 0x57, 0x6f,
    0x7b, 0x57, 0x73, 0x7b, 0x57, 0x74, 0x7b, 0x57, 0x20, 0x7b, 0x57, 0x25,
    0x7b, 0x57, 0x2d, 0x7b, 0x57, 0x2e, 0x7b, 0x57, 0x2f, 0x7b, 0x57, 0x33,
    0x7b, 0x57, 0x34, 0x7b, 0x57, 0x35, 0x7b, 0x57, 0x36, 0x7b, 0x57, 0x37,
    0x7b, 0x57, 0x38, 0x7b, 0x57, 0x39, 0x7b, 0x57, 0x3d, 0x7b, 0x57, 0x41,
    0x7b, 0x57, 0x5f, 0x7b, 0x57, 0x62, 0x7b, 0x57, 0x64, 0x7b, 0x57, 0x66,
    0x7b, 0x57, 0x67, 0x7b, 0x57, 0x68, 0x7b, 0x57, 0x6c, 0x7b, 0x57, 0x6d,
    0x7b, 0x57, 0x6e, 0x7b, 0x57, 0x70, 0x7b, 0x57, 0x72, 0x7b, 0x57, 0x75,
    0x7b, 0x57, 0x3a, 0x7b, 0x57, 0x42, 0x7b, 0x57, 0x43, 0x7b, 0x57, 0x44,
    0x7b, 0x57, 0x45, 0x7b, 0x57, 0x46, 0x7b, 0x57, 0x47, 0x7b, 0x57, 0x48,
    0x7b, 0x57, 0x49, 0x7b, 0x57, 0x4a, 0x7b, 0x57, 0x4b, 0x7b, 0x57, 0x4c,
    0x7b, 0x57, 0x4d, 0x7b, 0x57, 0x4e, 0x7b, 0x57, 0x4f, 0x7b, 0x57, 0x50,
    0x7b, 0x57, 0x51, 0x7b, 0x57, 0x52, 0x7b, 0x57, 0x53, 0x7b, 0x57, 0x54,
    0x7b, 0x57, 0x55, 0x7b, 0x57, 0x56, 0x7b, 0x57, 0x57, 0x7b, 0x57, 0x59,
    0x7b, 0x57, 0x6a, 0x7b, 0x57, 0x6b, 0x7b, 0x57, 0x71, 0x7b, 0x57, 0x76,
    0x7b, 0x57, 0x77, 0x7b, 0x57, 0x78, 0x7b, 0x57, 0x79, 0x7b, 0x57, 0x7a,
    0x7b, 0x59, 0x30, 0x7b, 0x59, 0x31, 0x7b, 0x59, 0x32, 0x7b, 0x59, 0x61,
    0x7b, 0x59, 0x63, 0x7b, 0x59, 0x65, 0x7b, 0x59, 0x69, 0x7b, 0x59, 0x6f,
    0x7b, 0x59, 0x73, 0x7b, 0x59, 0x74, 0x7b, 0x59, 0x20, 0x7b, 0x59, 0x25,
    0x7b, 0x59, 0x2d, 0x7b, 0x59, 0x2e, 0x7b, 0x59, 0x2f, 0x7b, 0x59, 0x33,
    0x7b, 0x59, 0x34, 0x7b, 0x59, 0x35, 0x7b, 0x59, 0x36, 0x7b, 0x59, 0x37,
    0x7b, 0x59, 0x38, 0x7b, 0x59, 0x39, 0x7b, 0x59, 0x3d, 0x7b, 0x59, 0x41,
    0x7b, 0x59, 0x5f, 0x7b, 0x59, 0x62, 0x7b, 0x59, 0x64, 0x7b, 0x59, 0x66,
    0x7b, 0x59, 0x67, 0x7b, 0x59, 0x68, 0x7b, 0x59, 0x6c, 0x7b, 0x59, 0x6d,
    0x7b, 0x59, 0x6e, 0x7b, 0x59, 0x70, 0x7b, 0x59, 0x72, 0x7b, 0x59, 0x75,
    0x7b, 0x59, 0x3a, 0x7b, 0x59, 0x42, 0x7b, 0x59, 0x43, 0x7b, 0x59, 0x44,
    0x7b, 0x59, 0x45, 0x7b, 0x59, 0x46, 0x7b, 0x59, 0x47, 0x7b, 0x59, 0x48,
    0x7b, 0x59, 0x49, 0x7b, 0x59, 0x4a, 0x7b, 0x59, 0x4b, 0x7b, 0x59, 0x4c,
    0x7b, 0x59, 0x4d, 0x7b, 0x59, 0x4e, 0x7b, 0x59, 0x4f, 0x7b, 0x59, 0x50,
    0x7b, 0x59, 0x51, 0x7b, 0x59, 0x52, 0x7b, 0x59, 0x53, 0x7b, 0x59, 0x54,
    0x7b, 0x59, 0x55, 0x7b, 0x59, 0x56, 0x7b, 0x59, 0x57, 0x7b, 0x59, 0x59,
    0x7b, 0x59, 0x6a, 0x7b, 0x59, 0x6b, 0x7b, 0x59, 0x71, 0x7b, 0x59, 0x76,
    0x7b, 0x59, 0x77, 0x7b, 0x59, 0x78, 0x7b, 0x59, 0x79, 0x7b, 0x59, 0x7a};
const uint8_t HuffDecoderCommon::table30_58_emit_[408] = {
    0x7b, 0x6a, 0x30, 0x7b, 0x6a, 0x31, 0x7b, 0x6a, 0x32, 0x7b, 0x6a, 0x61,
    0x7b, 0x6a, 0x63, 0x7b, 0x6a, 0x65, 0x7b, 0x6a, 0x69, 0x7b, 0x6a, 0x6f,
    0x7b, 0x6a, 0x73, 0x7b, 0x6a, 0x74, 0x7b, 0x6a, 0x20, 0x7b, 0x6a, 0x25,
    0x7b, 0x6a, 0x2d, 0x7b, 0x6a, 0x2e, 0x7b, 0x6a, 0x2f, 0x7b, 0x6a, 0x33,
    0x7b, 0x6a, 0x34, 0x7b, 0x6a, 0x35, 0x7b, 0x6a, 0x36, 0x7b, 0x6a, 0x37,
    0x7b, 0x6a, 0x38, 0x7b, 0x6a, 0x39, 0x7b, 0x6a, 0x3d, 0x7b, 0x6a, 0x41,
    0x7b, 0x6a, 0x5f, 0x7b, 0x6a, 0x62, 0x7b, 0x6a, 0x64, 0x7b, 0x6a, 0x66,
    0x7b, 0x6a, 0x67, 0x7b, 0x6a, 0x68, 0x7b, 0x6a, 0x6c, 0x7b, 0x6a, 0x6d,
    0x7b, 0x6a, 0x6e, 0x7b, 0x6a, 0x70, 0x7b, 0x6a, 0x72, 0x7b, 0x6a, 0x75,
    0x7b, 0x6a, 0x3a, 0x7b, 0x6a, 0x42, 0x7b, 0x6a, 0x43, 0x7b, 0x6a, 0x44,
    0x7b, 0x6a, 0x45, 0x7b, 0x6a, 0x46, 0x7b, 0x6a, 0x47, 0x7b, 0x6a, 0x48,
    0x7b, 0x6a, 0x49, 0x7b, 0x6a, 0x4a, 0x7b, 0x6a, 0x4b, 0x7b, 0x6a, 0x4c,
    0x7b, 0x6a, 0x4d, 0x7b, 0x6a, 0x4e, 0x7b, 0x6a, 0x4f, 0x7b, 0x6a, 0x50,
    0x7b, 0x6a, 0x51, 0x7b, 0x6a, 0x52, 0x7b, 0x6a, 0x53, 0x7b, 0x6a, 0x54,
    0x7b, 0x6a, 0x55, 0x7b, 0x6a, 0x56, 0x7b, 0x6a, 0x57, 0x7b, 0x6a, 0x59,
    0x7b, 0x6a, 0x6a, 0x7b, 0x6a, 0x6b, 0x7b, 0x6a, 0x71, 0x7b, 0x6a, 0x76,
    0x7b, 0x6a, 0x77, 0x7b, 0x6a, 0x78, 0x7b, 0x6a, 0x79, 0x7b, 0x6a, 0x7a,
    0x7b, 0x6b, 0x30, 0x7b, 0x6b, 0x31, 0x7b, 0x6b, 0x32, 0x7b, 0x6b, 0x61,
    0x7b, 0x6b, 0x63, 0x7b, 0x6b, 0x65, 0x7b, 0x6b, 0x69, 0x7b, 0x6b, 0x6f,
    0x7b, 0x6b, 0x73, 0x7b, 0x6b, 0x74, 0x7b, 0x6b, 0x20, 0x7b, 0x6b, 0x25,
    0x7b, 0x6b, 0x2d, 0x7b, 0x6b, 0x2e, 0x7b, 0x6b, 0x2f, 0x7b, 0x6b, 0x33,
    0x7b, 0x6b, 0x34, 0x7b, 0x6b, 0x35, 0x7b, 0x6b, 0x36, 0x7b, 0x6b, 0x37,
    0x7b, 0x6b, 0x38, 0x7b, 0x6b, 0x39, 0x7b, 0x6b, 0x3d, 0x7b, 0x6b, 0x41,
    0x7b, 0x6b, 0x5f, 0x7b, 0x6b, 0x62, 0x7b, 0x6b, 0x64, 0x7b, 0x6b, 0x66,
    0x7b, 0x6b, 0x67, 0x7b, 0x6b, 0x68, 0x7b, 0x6b, 0x6c, 0x7b, 0x6b, 0x6d,
    0x7b, 0x6b, 0x6e, 0x7b, 0x6b, 0x70, 0x7b, 0x6b, 0x72, 0x7b, 0x6b, 0x75,
    0x7b, 0x6b, 0x3a, 0x7b, 0x6b, 0x42, 0x7b, 0x6b, 0x43, 0x7b, 0x6b, 0x44,
    0x7b, 0x6b, 0x45, 0x7b, 0x6b, 0x46, 0x7b, 0x6b, 0x47, 0x7b, 0x6b, 0x48,
    0x7b, 0x6b, 0x49, 0x7b, 0x6b, 0x4a, 0x7b, 0x6b, 0x4b, 0x7b, 0x6b, 0x4c,
    0x7b, 0x6b, 0x4d, 0x7b, 0x6b, 0x4e, 0x7b, 0x6b, 0x4f, 0x7b, 0x6b, 0x50,
    0x7b, 0x6b, 0x51, 0x7b, 0x6b, 0x52, 0x7b, 0x6b, 0x53, 0x7b, 0x6b, 0x54,
    0x7b, 0x6b, 0x55, 0x7b, 0x6b, 0x56, 0x7b, 0x6b, 0x57, 0x7b, 0x6b, 0x59,
    0x7b, 0x6b, 0x6a, 0x7b, 0x6b, 0x6b, 0x7b, 0x6b, 0x71, 0x7b, 0x6b, 0x76,
    0x7b, 0x6b, 0x77, 0x7b, 0x6b, 0x78, 0x7b, 0x6b, 0x79, 0x7b, 0x6b, 0x7a};
const uint8_t HuffDecoderCommon::table30_59_emit_[408] = {
    0x7b, 0x71, 0x30, 0x7b, 0x71, 0x31, 0x7b, 0x71, 0x32, 0x7b, 0x71, 0x61,
    0x7b, 0x71, 0x63, 0x7b, 0x71, 0x65, 0x7b, 0x71, 0x69, 0x7b, 0x71, 0x6f,
    0x7b, 0x71, 0x73, 0x7b, 0x71, 0x74, 0x7b, 0x71, 0x20, 0x7b, 0x71, 0x25,
    0x7b, 0x71, 0x2d, 0x7b, 0x71, 0x2e, 0x7b, 0x71, 0x2f, 0x7b, 0x71, 0x33,
    0x7b, 0x71, 0x34, 0x7b, 0x71, 0x35, 0x7b, 0x71, 0x36, 0x7b, 0x71, 0x37,
    0x7b, 0x71, 0x38, 0x7b, 0x71, 0x39, 0x7b, 0x71, 0x3d, 0x7b, 0x71, 0x41,
    0x7b, 0x71, 0x5f, 0x7b, 0x71, 0x62, 0x7b, 0x71, 0x64, 0x7b, 0x71, 0x66,
    0x7b, 0x71, 0x67, 0x7b, 0x71, 0x68, 0x7b, 0x71, 0x6c, 0x7b, 0x71, 0x6d,
    0x7b, 0x71, 0x6e, 0x7b, 0x71, 0x70, 0x7b, 0x71, 0x72, 0x7b, 0x71, 0x75,
    0x7b, 0x71, 0x3a, 0x7b, 0x71, 0x42, 0x7b, 0x71, 0x43, 0x7b, 0x71, 0x44,
    0x7b, 0x71, 0x45, 0x7b, 0x71, 0x46, 0x7b, 0x71, 0x47, 0x7b, 0x71, 0x48,
    0x7b, 0x71, 0x49, 0x7b, 0x71, 0x4a, 0x7b, 0x71, 0x4b, 0x7b, 0x71, 0x4c,
    0x7b, 0x71, 0x4d, 0x7b, 0x71, 0x4e, 0x7b, 0x71, 0x4f, 0x7b, 0x71, 0x50,
    0x7b, 0x71, 0x51, 0x7b, 0x71, 0x52, 0x7b, 0x71, 0x53, 0x7b, 0x71, 0x54,
    0x7b, 0x71, 0x55, 0x7b, 0x71, 0x56, 0x7b, 0x71, 0x57, 0x7b, 0x71, 0x59,
    0x7b, 0x71, 0x6a, 0x7b, 0x71, 0x6b, 0x7b, 0x71, 0x71, 0x7b, 0x71, 0x76,
    0x7b, 0x71, 0x77, 0x7b, 0x71, 0x78, 0x7b, 0x71, 0x79, 0x7b, 0x71, 0x7a,
    0x7b, 0x76, 0x30, 0x7b, 0x76, 0x31, 0x7b, 0x76, 0x32, 0x7b, 0x76, 0x61,
    0x7b, 0x76, 0x63, 0x7b, 0x76, 0x65, 0x7b, 0x76, 0x69, 0x7b, 0x76, 0x6f,
    0x7b, 0x76, 0x73, 0x7b, 0x76, 0x74, 0x7b, 0x76, 0x20, 0x7b, 0x76, 0x25,
    0x7b, 0x76, 0x2d, 0x7b, 0x76, 0x2e, 0x7b, 0x76, 0x2f, 0x7b, 0x76, 0x33,
    0x7b, 0x76, 0x34, 0x7b, 0x76, 0x35, 0x7b, 0x76, 0x36, 0x7b, 0x76, 0x37,
    0x7b, 0x76, 0x38, 0x7b, 0x76, 0x39, 0x7b, 0x76, 0x3d, 0x7b, 0x76, 0x41,
    0x7b, 0x76, 0x5f, 0x7b, 0x76, 0x62, 0x7b, 0x76, 0x64, 0x7b, 0x76, 0x66,
    0x7b, 0x76, 0x67, 0x7b, 0x76, 0x68, 0x7b, 0x76, 0x6c, 0x7b, 0x76, 0x6d,
    0x7b, 0x76, 0x6e, 0x7b, 0x76, 0x70, 0x7b, 0x76, 0x72, 0x7b, 0x76, 0x75,
    0x7b, 0x76, 0x3a, 0x7b, 0x76, 0x42, 0x7b, 0x76, 0x43, 0x7b, 0x76, 0x44,
    0x7b, 0x76, 0x45, 0x7b, 0x76, 0x46, 0x7b, 0x76, 0x47, 0x7b, 0x76, 0x48,
    0x7b, 0x76, 0x49, 0x7b, 0x76, 0x4a, 0x7b, 0x76, 0x4b, 0x7b, 0x76, 0x4c,
    0x7b, 0x76, 0x4d, 0x7b, 0x76, 0x4e, 0x7b, 0x76, 0x4f, 0x7b, 0x76, 0x50,
    0x7b, 0x76, 0x51, 0x7b, 0x76, 0x52, 0x7b, 0x76, 0x53, 0x7b, 0x76, 0x54,
    0x7b, 0x76, 0x55, 0x7b, 0x76, 0x56, 0x7b, 0x76, 0x57, 0x7b, 0x76, 0x59,
    0x7b, 0x76, 0x6a, 0x7b, 0x76, 0x6b, 0x7b, 0x76, 0x71, 0x7b, 0x76, 0x76,
    0x7b, 0x76, 0x77, 0x7b, 0x76, 0x78, 0x7b, 0x76, 0x79, 0x7b, 0x76, 0x7a};
const uint8_t HuffDecoderCommon::table30_60_emit_[408] = {
    0x7b, 0x77, 0x30, 0x7b, 0x77, 0x31, 0x7b, 0x77, 0x32, 0x7b, 0x77, 0x61,
    0x7b, 0x77, 0x63, 0x7b, 0x77, 0x65, 0x7b, 0x77, 0x69, 0x7b, 0x77, 0x6f,
    0x7b, 0x77, 0x73, 0x7b, 0x77, 0x74, 0x7b, 0x77, 0x20, 0x7b, 0x77, 0x25,
    0x7b, 0x77, 0x2d, 0x7b, 0x77, 0x2e, 0x7b, 0x77, 0x2f, 0x7b, 0x77, 0x33,
    0x7b, 0x77, 0x34, 0x7b, 0x77, 0x35, 0x7b, 0x77, 0x36, 0x7b, 0x77, 0x37,
    0x7b, 0x77, 0x38, 0x7b, 0x77, 0x39, 0x7b, 0x77, 0x3d, 0x7b, 0x77, 0x41,
    0x7b, 0x77, 0x5f, 0x7b, 0x77, 0x62, 0x7b, 0x77, 0x64, 0x7b, 0x77, 0x66,
    0x7b, 0x77, 0x67, 0x7b, 0x77, 0x68, 0x7b, 0x77, 0x6c, 0x7b, 0x77, 0x6d,
    0x7b, 0x77, 0x6e, 0x7b, 0x77, 0x70, 0x7b, 0x77, 0x72, 0x7b, 0x77, 0x75,
    0x7b, 0x77, 0x3a, 0x7b, 0x77, 0x42, 0x7b, 0x77, 0x43, 0x7b, 0x77, 0x44,
    0x7b, 0x77, 0x45, 0x7b, 0x77, 0x46, 0x7b, 0x77, 0x47, 0x7b, 0x77, 0x48,
    0x7b, 0x77, 0x49, 0x7b, 0x77, 0x4a, 0x7b, 0x77, 0x4b, 0x7b, 0x77, 0x4c,
    0x7b, 0x77, 0x4d, 0x7b, 0x77, 0x4e, 0x7b, 0x77, 0x4f, 0x7b, 0x77, 0x50,
    0x7b, 0x77, 0x51, 0x7b, 0x77, 0x52, 0x7b, 0x77, 0x53, 0x7b, 0x77, 0x54,
    0x7b, 0x77, 0x55, 0x7b, 0x77, 0x56, 0x7b, 0x77, 0x57, 0x7b, 0x77, 0x59,
    0x7b, 0x77, 0x6a, 0x7b, 0x77, 0x6b, 0x7b, 0x77, 0x71, 0x7b, 0x77, 0x76,
    0x7b, 0x77, 0x77, 0x7b, 0x77, 0x78, 0x7b, 0x77, 0x79, 0x7b, 0x77, 0x7a,
    0x7b, 0x78, 0x30, 0x7b, 0x78, 0x31, 0x7b, 0x78, 0x32, 0x7b, 0x78, 0x61,
    0x7b, 0x78, 0x63, 0x7b, 0x78, 0x65, 0x7b, 0x78, 0x69, 0x7b, 0x78, 0x6f,
    0x7b, 0x78, 0x73, 0x7b, 0x78, 0x74, 0x7b, 0x78, 0x20, 0x7b, 0x78, 0x25,
    0x7b, 0x78, 0x2d, 0x7b, 0x78, 0x2e, 0x7b, 0x78, 0x2f, 0x7b, 0x78, 0x33,
    0x7b, 0x78, 0x34, 0x7b, 0x78, 0x35, 0x7b, 0x78, 0x36, 0x7b, 0x78, 0x37,
    0x7b, 0x78, 0x38, 0x7b, 0x78, 0x39, 0x7b, 0x78, 0x3d, 0x7b, 0x78, 0x41,
    0x7b, 0x78, 0x5f, 0x7b, 0x78, 0x62, 0x7b, 0x78, 0x64, 0x7b, 0x78, 0x66,
    0x7b, 0x78, 0x67, 0x7b, 0x78, 0x68, 0x7b, 0x78, 0x6c, 0x7b, 0x78, 0x6d,
    0x7b, 0x78, 0x6e, 0x7b, 0x78, 0x70, 0x7b, 0x78, 0x72, 0x7b, 0x78, 0x75,
    0x7b, 0x78, 0x3a, 0x7b, 0x78, 0x42, 0x7b, 0x78, 0x43, 0x7b, 0x78, 0x44,
    0x7b, 0x78, 0x45, 0x7b, 0x78, 0x46, 0x7b, 0x78, 0x47, 0x7b, 0x78, 0x48,
    0x7b, 0x78, 0x49, 0x7b, 0x78, 0x4a, 0x7b, 0x78, 0x4b, 0x7b, 0x78, 0x4c,
    0x7b, 0x78, 0x4d, 0x7b, 0x78, 0x4e, 0x7b, 0x78, 0x4f, 0x7b, 0x78, 0x50,
    0x7b, 0x78, 0x51, 0x7b, 0x78, 0x52, 0x7b, 0x78, 0x53, 0x7b, 0x78, 0x54,
    0x7b, 0x78, 0x55, 0x7b, 0x78, 0x56, 0x7b, 0x78, 0x57, 0x7b, 0x78, 0x59,
    0x7b, 0x78, 0x6a, 0x7b, 0x78, 0x6b, 0x7b, 0x78, 0x71, 0x7b, 0x78, 0x76,
    0x7b, 0x78, 0x77, 0x7b, 0x78, 0x78, 0x7b, 0x78, 0x79, 0x7b, 0x78, 0x7a};
const uint8_t HuffDecoderCommon::table30_61_emit_[408] = {
    0x7b, 0x79, 0x30, 0x7b, 0x79, 0x31, 0x7b, 0x79, 0x32, 0x7b, 0x79, 0x61,
    0x7b, 0x79, 0x63, 0x7b, 0x79, 0x65, 0x7b, 0x79, 0x69, 0x7b, 0x79, 0x6f,
    0x7b, 0x79, 0x73, 0x7b, 0x79, 0x74, 0x7b, 0x79, 0x20, 0x7b, 0x79, 0x25,
    0x7b, 0x79, 0x2d, 0x7b, 0x79, 0x2e, 0x7b, 0x79, 0x2f, 0x7b, 0x79, 0x33,
    0x7b, 0x79, 0x34, 0x7b, 0x79, 0x35, 0x7b, 0x79, 0x36, 0x7b, 0x79, 0x37,
    0x7b, 0x79, 0x38, 0x7b, 0x79, 0x39, 0x7b, 0x79, 0x3d, 0x7b, 0x79, 0x41,
    0x7b, 0x79, 0x5f, 0x7b, 0x79, 0x62, 0x7b, 0x79, 0x64, 0x7b, 0x79, 0x66,
    0x7b, 0x79, 0x67, 0x7b, 0x79, 0x68, 0x7b, 0x79, 0x6c, 0x7b, 0x79, 0x6d,
    0x7b, 0x79, 0x6e, 0x7b, 0x79, 0x70, 0x7b, 0x79, 0x72, 0x7b, 0x79, 0x75,
    0x7b, 0x79, 0x3a, 0x7b, 0x79, 0x42, 0x7b, 0x79, 0x43, 0x7b, 0x79, 0x44,
    0x7b, 0x79, 0x45, 0x7b, 0x79, 0x46, 0x7b, 0x79, 0x47, 0x7b, 0x79, 0x48,
    0x7b, 0x79, 0x49, 0x7b, 0x79, 0x4a, 0x7b, 0x79, 0x4b, 0x7b, 0x79, 0x4c,
    0x7b, 0x79, 0x4d, 0x7b, 0x79, 0x4e, 0x7b, 0x79, 0x4f, 0x7b, 0x79, 0x50,
    0x7b, 0x79, 0x51, 0x7b, 0x79, 0x52, 0x7b, 0x79, 0x53, 0x7b, 0x79, 0x54,
    0x7b, 0x79, 0x55, 0x7b, 0x79, 0x56, 0x7b, 0x79, 0x57, 0x7b, 0x79, 0x59,
    0x7b, 0x79, 0x6a, 0x7b, 0x79, 0x6b, 0x7b, 0x79, 0x71, 0x7b, 0x79, 0x76,
    0x7b, 0x79, 0x77, 0x7b, 0x79, 0x78, 0x7b, 0x79, 0x79, 0x7b, 0x79, 0x7a,
    0x7b, 0x7a, 0x30, 0x7b, 0x7a, 0x31, 0x7b, 0x7a, 0x32, 0x7b, 0x7a, 0x61,
    0x7b, 0x7a, 0x63, 0x7b, 0x7a, 0x65, 0x7b, 0x7a, 0x69, 0x7b, 0x7a, 0x6f,
    0x7b, 0x7a, 0x73, 0x7b, 0x7a, 0x74, 0x7b, 0x7a, 0x20, 0x7b, 0x7a, 0x25,
    0x7b, 0x7a, 0x2d, 0x7b, 0x7a, 0x2e, 0x7b, 0x7a, 0x2f, 0x7b, 0x7a, 0x33,
    0x7b, 0x7a, 0x34, 0x7b, 0x7a, 0x35, 0x7b, 0x7a, 0x36, 0x7b, 0x7a, 0x37,
    0x7b, 0x7a, 0x38, 0x7b, 0x7a, 0x39, 0x7b, 0x7a, 0x3d, 0x7b, 0x7a, 0x41,
    0x7b, 0x7a, 0x5f, 0x7b, 0x7a, 0x62, 0x7b, 0x7a, 0x64, 0x7b, 0x7a, 0x66,
    0x7b, 0x7a, 0x67, 0x7b, 0x7a, 0x68, 0x7b, 0x7a, 0x6c, 0x7b, 0x7a, 0x6d,
    0x7b, 0x7a, 0x6e, 0x7b, 0x7a, 0x70, 0x7b, 0x7a, 0x72, 0x7b, 0x7a, 0x75,
    0x7b, 0x7a, 0x3a, 0x7b, 0x7a, 0x42, 0x7b, 0x7a, 0x43, 0x7b, 0x7a, 0x44,
    0x7b, 0x7a, 0x45, 0x7b, 0x7a, 0x46, 0x7b, 0x7a, 0x47, 0x7b, 0x7a, 0x48,
    0x7b, 0x7a, 0x49, 0x7b, 0x7a, 0x4a, 0x7b, 0x7a, 0x4b, 0x7b, 0x7a, 0x4c,
    0x7b, 0x7a, 0x4d, 0x7b, 0x7a, 0x4e, 0x7b, 0x7a, 0x4f, 0x7b, 0x7a, 0x50,
    0x7b, 0x7a, 0x51, 0x7b, 0x7a, 0x52, 0x7b, 0x7a, 0x53, 0x7b, 0x7a, 0x54,
    0x7b, 0x7a, 0x55, 0x7b, 0x7a, 0x56, 0x7b, 0x7a, 0x57, 0x7b, 0x7a, 0x59,
    0x7b, 0x7a, 0x6a, 0x7b, 0x7a, 0x6b, 0x7b, 0x7a, 0x71, 0x7b, 0x7a, 0x76,
    0x7b, 0x7a, 0x77, 0x7b, 0x7a, 0x78, 0x7b, 0x7a, 0x79, 0x7b, 0x7a, 0x7a};
const uint8_t HuffDecoderCommon::table30_62_emit_[432] = {
    0x7b, 0x26, 0x30, 0x7b, 0x26, 0x31, 0x7b, 0x26, 0x32, 0x7b, 0x26, 0x61,
    0x7b, 0x26, 0x63, 0x7b, 0x26, 0x65, 0x7b, 0x26, 0x69, 0x7b, 0x26, 0x6f,
    0x7b, 0x26, 0x73, 0x7b, 0x26, 0x74, 0x7b, 0x26, 0x20, 0x7b, 0x26, 0x25,
    0x7b, 0x26, 0x2d, 0x7b, 0x26, 0x2e, 0x7b, 0x26, 0x2f, 0x7b, 0x26, 0x33,
    0x7b, 0x26, 0x34, 0x7b, 0x26, 0x35, 0x7b, 0x26, 0x36, 0x7b, 0x26, 0x37,
    0x7b, 0x26, 0x38, 0x7b, 0x26, 0x39, 0x7b, 0x26, 0x3d, 0x7b, 0x26, 0x41,
    0x7b, 0x26, 0x5f, 0x7b, 0x26, 0x62, 0x7b, 0x26, 0x64, 0x7b, 0x26, 0x66,
    0x7b, 0x26, 0x67, 0x7b, 0x26, 0x68, 0x7b, 0x26, 0x6c, 0x7b, 0x26, 0x6d,
    0x7b, 0x26, 0x6e, 0x7b, 0x26, 0x70, 0x7b, 0x26, 0x72, 0x7b, 0x26, 0x75,
    0x7b, 0x2a, 0x30, 0x7b, 0x2a, 0x31, 0x7b, 0x2a, 0x32, 0x7b, 0x2a, 0x61,
    0x7b, 0x2a, 0x63, 0x7b, 0x2a, 0x65, 0x7b, 0x2a, 0x69, 0x7b, 0x2a, 0x6f,
    0x7b, 0x2a, 0x73, 0x7b, 0x2a, 0x74, 0x7b, 0x2a, 0x20, 0x7b, 0x2a, 0x25,
    0x7b, 0x2a, 0x2d, 0x7b, 0x2a, 0x2e, 0x7b, 0x2a, 0x2f, 0x7b, 0x2a, 0x33,
    0x7b, 0x2a, 0x34, 0x7b, 0x2a, 0x35, 0x7b, 0x2a, 0x36, 0x7b, 0x2a, 0x37,
    0x7b, 0x2a, 0x38, 0x7b, 0x2a, 0x39, 0x7b, 0x2a, 0x3d, 0x7b, 0x2a, 0x41,
    0x7b, 0x2a, 0x5f, 0x7b, 0x2a, 0x62, 0x7b, 0x2a, 0x64, 0x7b, 0x2a, 0x66,
    0x7b, 0x2a, 0x67, 0x7b, 0x2a, 0x68, 0x7b, 0x2a, 0x6c, 0x7b, 0x2a, 0x6d,
    0x7b, 0x2a, 0x6e, 0x7b, 0x2a, 0x70, 0x7b, 0x2a, 0x72, 0x7b, 0x2a, 0x75,
    0x7b, 0x2c, 0x30, 0x7b, 0x2c, 0x31, 0x7b, 0x2c, 0x32, 0x7b, 0x2c, 0x61,
    0x7b, 0x2c, 0x63, 0x7b, 0x2c, 0x65, 0x7b, 0x2c, 0x69, 0x7b, 0x2c, 0x6f,
    0x7b, 0x2c, 0x73, 0x7b, 0x2c, 0x74, 0x7b, 0x2c, 0x20, 0x7b, 0x2c, 0x25,
    0x7b, 0x2c, 0x2d, 0x7b, 0x2c, 0x2e, 0x7b, 0x2c, 0x2f, 0x7b, 0x2c, 0x33,
    0x7b, 0x2c, 0x34, 0x7b, 0x2c, 0x35, 0x7b, 0x2c, 0x36, 0x7b, 0x2c, 0x37,
    0x7b, 0x2c, 0x38, 0x7b, 0x2c, 0x39, 0x7b, 0x2c, 0x3d, 0x7b, 0x2c, 0x41,
    0x7b, 0x2c, 0x5f, 0x7b, 0x2c, 0x62, 0x7b, 0x2c, 0x64, 0x7b, 0x2c, 0x66,
    0x7b, 0x2c, 0x67, 0x7b, 0x2c, 0x68, 0x7b, 0x2c, 0x6c, 0x7b, 0x2c, 0x6d,
    0x7b, 0x2c, 0x6e, 0x7b, 0x2c, 0x70, 0x7b, 0x2c, 0x72, 0x7b, 0x2c, 0x75,
    0x7b, 0x3b, 0x30, 0x7b, 0x3b, 0x31, 0x7b, 0x3b, 0x32, 0x7b, 0x3b, 0x61,
    0x7b, 0x3b, 0x63, 0x7b, 0x3b, 0x65, 0x7b, 0x3b, 0x69, 0x7b, 0x3b, 0x6f,
    0x7b, 0x3b, 0x73, 0x7b, 0x3b, 0x74, 0x7b, 0x3b, 0x20, 0x7b, 0x3b, 0x25,
    0x7b, 0x3b, 0x2d, 0x7b, 0x3b, 0x2e, 0x7b, 0x3b, 0x2f, 0x7b, 0x3b, 0x33,
    0x7b, 0x3b, 0x34, 0x7b, 0x3b, 0x35, 0x7b, 0x3b, 0x36, 0x7b, 0x3b, 0x37,
    0x7b, 0x3b, 0x38, 0x7b, 0x3b, 0x39, 0x7b, 0x3b, 0x3d, 0x7b, 0x3b, 0x41,
    0x7b, 0x3b, 0x5f, 0x7b, 0x3b, 0x62, 0x7b, 0x3b, 0x64, 0x7b, 0x3b, 0x66,
    0x7b, 0x3b, 0x67, 0x7b, 0x3b, 0x68, 0x7b, 0x3b, 0x6c, 0x7b, 0x3b, 0x6d,
    0x7b, 0x3b, 0x6e, 0x7b, 0x3b, 0x70, 0x7b, 0x3b, 0x72, 0x7b, 0x3b, 0x75};
const uint16_t HuffDecoderCommon::table30_62_inner_[149] = {
    0x0000, 0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9,
    0x00c1, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169, 0x0181,
    0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259,
    0x0271, 0x0289, 0x02a1, 0x02b9, 0x02d1, 0x02e9, 0x0301, 0x0319, 0x0331,
    0x0349, 0x0002, 0x0361, 0x0379, 0x0391, 0x03a9, 0x03c1, 0x03d9, 0x03f1,
    0x0409, 0x0421, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9,
    0x04e1, 0x04f9, 0x0511, 0x0529, 0x0541, 0x0559, 0x0571, 0x0589, 0x05a1,
    0x05b9, 0x05d1, 0x05e9, 0x0601, 0x0619, 0x0631, 0x0649, 0x0661, 0x0679,
    0x0691, 0x06a9, 0x0362, 0x06c1, 0x06d9, 0x06f1, 0x0709, 0x0721, 0x0739,
    0x0751, 0x0769, 0x0781, 0x0799, 0x07b1, 0x07c9, 0x07e1, 0x07f9, 0x0811,
    0x0829, 0x0841, 0x0859, 0x0871, 0x0889, 0x08a1, 0x08b9, 0x08d1, 0x08e9,
    0x0901, 0x0919, 0x0931, 0x0949, 0x0961, 0x0979, 0x0991, 0x09a9, 0x09c1,
    0x09d9, 0x09f1, 0x0a09, 0x06c2, 0x0a21, 0x0a39, 0x0a51, 0x0a69, 0x0a81,
    0x0a99, 0x0ab1, 0x0ac9, 0x0ae1, 0x0af9, 0x0b11, 0x0b29, 0x0b41, 0x0b59,
    0x0b71, 0x0b89, 0x0ba1, 0x0bb9, 0x0bd1, 0x0be9, 0x0c01, 0x0c19, 0x0c31,
    0x0c49, 0x0c61, 0x0c79, 0x0c91, 0x0ca9, 0x0cc1, 0x0cd9, 0x0cf1, 0x0d09,
    0x0d21, 0x0d39, 0x0d51, 0x0d69, 0x0a22};
const uint8_t HuffDecoderCommon::table30_62_outer_[256] = {
    0,   1,   0,   2,   0,   3,   0,   4,   0,   5,   0,   6,   0,   7,   0,
    8,   0,   9,   0,   10,  11,  12,  13,  14,  15,  16,  17,  18,  19,  20,
    21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,  32,  33,  34,  35,
    36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   37,  0,   38,  0,   39,  0,   40,  0,   41,  0,   42,  0,
    43,  0,   44,  0,   45,  0,   46,  0,   47,  48,  49,  50,  51,  52,  53,
    54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  67,  68,
    69,  70,  71,  72,  73,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   74,  0,   75,  0,   76,  0,   77,  0,
    78,  0,   79,  0,   80,  0,   81,  0,   82,  0,   83,  0,   84,  85,  86,
    87,  88,  89,  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101,
    102, 103, 104, 105, 106, 107, 108, 109, 110, 0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 0,   112, 0,
    113, 0,   114, 0,   115, 0,   116, 0,   117, 0,   118, 0,   119, 0,   120,
    0,   121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
    135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    148};
const uint8_t HuffDecoderCommon::table30_63_emit_[252] = {
    0x7b, 0x58, 0x30, 0x7b, 0x58, 0x31, 0x7b, 0x58, 0x32, 0x7b, 0x58, 0x61,
    0x7b, 0x58, 0x63, 0x7b, 0x58, 0x65, 0x7b, 0x58, 0x69, 0x7b, 0x58, 0x6f,
    0x7b, 0x58, 0x73, 0x7b, 0x58, 0x74, 0x7b, 0x58, 0x20, 0x7b, 0x58, 0x25,
    0x7b, 0x58, 0x2d, 0x7b, 0x58, 0x2e, 0x7b, 0x58, 0x2f, 0x7b, 0x58, 0x33,
    0x7b, 0x58, 0x34, 0x7b, 0x58, 0x35, 0x7b, 0x58, 0x36, 0x7b, 0x58, 0x37,
    0x7b, 0x58, 0x38, 0x7b, 0x58, 0x39, 0x7b, 0x58, 0x3d, 0x7b, 0x58, 0x41,
    0x7b, 0x58, 0x5f, 0x7b, 0x58, 0x62, 0x7b, 0x58, 0x64, 0x7b, 0x58, 0x66,
    0x7b, 0x58, 0x67, 0x7b, 0x58, 0x68, 0x7b, 0x58, 0x6c, 0x7b, 0x58, 0x6d,
    0x7b, 0x58, 0x6e, 0x7b, 0x58, 0x70, 0x7b, 0x58, 0x72, 0x7b, 0x58, 0x75,
    0x7b, 0x5a, 0x30, 0x7b, 0x5a, 0x31, 0x7b, 0x5a, 0x32, 0x7b, 0x5a, 0x61,
    0x7b, 0x5a, 0x63, 0x7b, 0x5a, 0x65, 0x7b, 0x5a, 0x69, 0x7b, 0x5a, 0x6f,
    0x7b, 0x5a, 0x73, 0x7b, 0x5a, 0x74, 0x7b, 0x5a, 0x20, 0x7b, 0x5a, 0x25,
    0x7b, 0x5a, 0x2d, 0x7b, 0x5a, 0x2e, 0x7b, 0x5a, 0x2f, 0x7b, 0x5a, 0x33,
    0x7b, 0x5a, 0x34, 0x7b, 0x5a, 0x35, 0x7b, 0x5a, 0x36, 0x7b, 0x5a, 0x37,
    0x7b, 0x5a, 0x38, 0x7b, 0x5a, 0x39, 0x7b, 0x5a, 0x3d, 0x7b, 0x5a, 0x41,
    0x7b, 0x5a, 0x5f, 0x7b, 0x5a, 0x62, 0x7b, 0x5a, 0x64, 0x7b, 0x5a, 0x66,
    0x7b, 0x5a, 0x67, 0x7b, 0x5a, 0x68, 0x7b, 0x5a, 0x6c, 0x7b, 0x5a, 0x6d,
    0x7b, 0x5a, 0x6e, 0x7b, 0x5a, 0x70, 0x7b, 0x5a, 0x72, 0x7b, 0x5a, 0x75,
    0x7b, 0x21, 0x7b, 0x22, 0x7b, 0x28, 0x7b, 0x29, 0x7b, 0x3f, 0x7b, 0x27,
    0x7b, 0x2b, 0x7b, 0x7c, 0x7b, 0x23, 0x7b, 0x3e, 0x7b, 0x00, 0x7b, 0x24,
    0x7b, 0x40, 0x7b, 0x5b, 0x7b, 0x5d, 0x7b, 0x7e, 0x7b, 0x5e, 0x7b, 0x7d};
const uint16_t HuffDecoderCommon::table30_63_inner_[94] = {
    0x0000, 0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9,
    0x00c1, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169, 0x0181,
    0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259,
    0x0271, 0x0289, 0x02a1, 0x02b9, 0x02d1, 0x02e9, 0x0301, 0x0319, 0x0331,
    0x0349, 0x0002, 0x0361, 0x0379, 0x0391, 0x03a9, 0x03c1, 0x03d9, 0x03f1,
    0x0409, 0x0421, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9,
    0x04e1, 0x04f9, 0x0511, 0x0529, 0x0541, 0x0559, 0x0571, 0x0589, 0x05a1,
    0x05b9, 0x05d1, 0x05e9, 0x0601, 0x0619, 0x0631, 0x0649, 0x0661, 0x0679,
    0x0691, 0x06a9, 0x0362, 0x06c2, 0x06d2, 0x06e2, 0x06f2, 0x0702, 0x0712,
    0x0722, 0x0732, 0x0742, 0x0752, 0x0762, 0x0772, 0x0782, 0x0792, 0x07a2,
    0x07b2, 0x07c2, 0x07d2, 0x0003};
const uint8_t HuffDecoderCommon::table30_63_outer_[256] = {
    0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,  0,  7,  0,  8,  0,  9,  0,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
    29, 30, 31, 32, 33, 34, 35, 36, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  37, 0,  38, 0,  39, 0,  40, 0,  41, 0,  42, 0,  43,
    0,  44, 0,  45, 0,  46, 0,  47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
    59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  74, 0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  75, 0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  76, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  77, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  78, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  79, 0,
    0,  0,  0,  0,  0,  0,  80, 0,  0,  0,  0,  0,  0,  0,  81, 0,  0,  0,  0,
    0,  0,  0,  82, 0,  0,  0,  83, 0,  0,  0,  84, 0,  85, 0,  86, 0,  87, 0,
    88, 0,  89, 0,  90, 91, 92, 0,  93};
const uint8_t HuffDecoderCommon::table30_64_emit_[240] = {
    0x5c, 0x30, 0x30, 0x5c, 0x30, 0x31, 0x5c, 0x30, 0x32, 0x5c, 0x30, 0x61,
    0x5c, 0x30, 0x63, 0x5c, 0x30, 0x65, 0x5c, 0x30, 0x69, 0x5c, 0x30, 0x6f,
    0x5c, 0x30, 0x73, 0x5c, 0x30, 0x74, 0x5c, 0x31, 0x30, 0x5c, 0x31, 0x31,
    0x5c, 0x31, 0x32, 0x5c, 0x31, 0x61, 0x5c, 0x31, 0x63, 0x5c, 0x31, 0x65,
    0x5c, 0x31, 0x69, 0x5c, 0x31, 0x6f, 0x5c, 0x31, 0x73, 0x5c, 0x31, 0x74,
    0x5c, 0x32, 0x30, 0x5c, 0x32, 0x31, 0x5c, 0x32, 0x32, 0x5c, 0x32, 0x61,
    0x5c, 0x32, 0x63, 0x5c, 0x32, 0x65, 0x5c, 0x32, 0x69, 0x5c, 0x32, 0x6f,
    0x5c, 0x32, 0x73, 0x5c, 0x32, 0x74, 0x5c, 0x61, 0x30, 0x5c, 0x61, 0x31,
    0x5c, 0x61, 0x32, 0x5c, 0x61, 0x61, 0x5c, 0x61, 0x63, 0x5c, 0x61, 0x65,
    0x5c, 0x61, 0x69, 0x5c, 0x61, 0x6f, 0x5c, 0x61, 0x73, 0x5c, 0x61, 0x74,
    0x5c, 0x63, 0x30, 0x5c, 0x63, 0x31, 0x5c, 0x63, 0x32, 0x5c, 0x63, 0x61,
    0x5c, 0x63, 0x63, 0x5c, 0x63, 0x65, 0x5c, 0x63, 0x69, 0x5c, 0x63, 0x6f,
    0x5c, 0x63, 0x73, 0x5c, 0x63, 0x74, 0x5c, 0x65, 0x30, 0x5c, 0x65, 0x31,
    0x5c, 0x65, 0x32, 0x5c, 0x65, 0x61, 0x5c, 0x65, 0x63, 0x5c, 0x65, 0x65,
    0x5c, 0x65, 0x69, 0x5c, 0x65, 0x6f, 0x5c, 0x65, 0x73, 0x5c, 0x65, 0x74,
    0x5c, 0x69, 0x30, 0x5c, 0x69, 0x31, 0x5c, 0x69, 0x32, 0x5c, 0x69, 0x61,
    0x5c, 0x69, 0x63, 0x5c, 0x69, 0x65, 0x5c, 0x69, 0x69, 0x5c, 0x69, 0x6f,
    0x5c, 0x69, 0x73, 0x5c, 0x69, 0x74, 0x5c, 0x6f, 0x30, 0x5c, 0x6f, 0x31,
    0x5c, 0x6f, 0x32, 0x5c, 0x6f, 0x61, 0x5c, 0x6f, 0x63, 0x5c, 0x6f, 0x65,
    0x5c, 0x6f, 0x69, 0x5c, 0x6f, 0x6f, 0x5c, 0x6f, 0x73, 0x5c, 0x6f, 0x74};
const uint16_t HuffDecoderCommon::table30_64_inner_[89] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9, 0x00c1,
    0x00d9, 0x0000, 0x0002, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169,
    0x0181, 0x0199, 0x01b1, 0x01c9, 0x00f2, 0x01e1, 0x01f9, 0x0211, 0x0229,
    0x0241, 0x0259, 0x0271, 0x0289, 0x02a1, 0x02b9, 0x01e2, 0x02d1, 0x02e9,
    0x0301, 0x0319, 0x0331, 0x0349, 0x0361, 0x0379, 0x0391, 0x03a9, 0x02d2,
    0x03c1, 0x03d9, 0x03f1, 0x0409, 0x0421, 0x0439, 0x0451, 0x0469, 0x0481,
    0x0499, 0x03c2, 0x04b1, 0x04c9, 0x04e1, 0x04f9, 0x0511, 0x0529, 0x0541,
    0x0559, 0x0571, 0x0589, 0x04b2, 0x05a1, 0x05b9, 0x05d1, 0x05e9, 0x0601,
    0x0619, 0x0631, 0x0649, 0x0661, 0x0679, 0x05a2, 0x0691, 0x06a9, 0x06c1,
    0x06d9, 0x06f1, 0x0709, 0x0721, 0x0739, 0x0751, 0x0769, 0x0692};
const uint8_t HuffDecoderCommon::table30_64_outer_[256] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 12, 13, 14, 15, 16, 17,
    18, 19, 20, 21, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 44, 45, 46, 47, 48, 49,
    50, 51, 52, 53, 54, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 77, 78, 79, 80, 81,
    82, 83, 84, 85, 86, 87, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 88};
const uint8_t HuffDecoderCommon::table30_65_emit_[84] = {
    0x5c, 0x73, 0x30, 0x5c, 0x73, 0x31, 0x5c, 0x73, 0x32, 0x5c, 0x73, 0x61,
    0x5c, 0x73, 0x63, 0x5c, 0x73, 0x65, 0x5c, 0x73, 0x69, 0x5c, 0x73, 0x6f,
    0x5c, 0x73, 0x73, 0x5c, 0x73, 0x74, 0x5c, 0x74, 0x30, 0x5c, 0x74, 0x31,
    0x5c, 0x74, 0x32, 0x5c, 0x74, 0x61, 0x5c, 0x74, 0x63, 0x5c, 0x74, 0x65,
    0x5c, 0x74, 0x69, 0x5c, 0x74, 0x6f, 0x5c, 0x74, 0x73, 0x5c, 0x74, 0x74,
    0x5c, 0x20, 0x5c, 0x25, 0x5c, 0x2d, 0x5c, 0x2e, 0x5c, 0x2f, 0x5c, 0x33,
    0x5c, 0x34, 0x5c, 0x35, 0x5c, 0x36, 0x5c, 0x37, 0x5c, 0x38, 0x5c, 0x39};
const uint16_t HuffDecoderCommon::table30_65_inner_[35] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9, 0x00c1,
    0x00d9, 0x0000, 0x0002, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169,
    0x0181, 0x0199, 0x01b1, 0x01c9, 0x00f2, 0x01e2, 0x01f2, 0x0202, 0x0212,
    0x0222, 0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292};
const uint8_t HuffDecoderCommon::table30_65_outer_[256] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 12, 13, 14, 15, 16, 17,
    18, 19, 20, 21, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 22, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 23, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    24, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 25, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 26, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 27, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 28, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 29, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 30, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 31, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 32, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 33, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 34};
const uint8_t HuffDecoderCommon::table30_66_outer_[256] = {
    0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 1,  0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 3,
    0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 4,  0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 5,  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 6,
    0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 7,  0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 8,  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 9,
    0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 12,
    0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 15, 0, 0, 0, 0, 0, 0, 0, 16,
    0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 18};
const uint8_t HuffDecoderCommon::table30_67_emit_[78] = {
    0x5c, 0x45, 0x5c, 0x46, 0x5c, 0x47, 0x5c, 0x48, 0x5c, 0x49, 0x5c, 0x4a,
    0x5c, 0x4b, 0x5c, 0x4c, 0x5c, 0x4d, 0x5c, 0x4e, 0x5c, 0x4f, 0x5c, 0x50,
    0x5c, 0x51, 0x5c, 0x52, 0x5c, 0x53, 0x5c, 0x54, 0x5c, 0x55, 0x5c, 0x56,
    0x5c, 0x57, 0x5c, 0x59, 0x5c, 0x6a, 0x5c, 0x6b, 0x5c, 0x71, 0x5c, 0x76,
    0x5c, 0x77, 0x5c, 0x78, 0x5c, 0x79, 0x5c, 0x7a, 0x5c, 0x26, 0x5c, 0x2a,
    0x5c, 0x2c, 0x5c, 0x3b, 0x5c, 0x58, 0x5c, 0x5a, 0x5c, 0x21, 0x5c, 0x22,
    0x5c, 0x28, 0x5c, 0x29, 0x5c, 0x3f};
const uint16_t HuffDecoderCommon::table30_67_inner_[41] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0242, 0x0252, 0x0262, 0x0003};
const uint8_t HuffDecoderCommon::table30_67_outer_[256] = {
    0, 0, 0, 0,  0, 0, 0, 1,  0,  0,  0,  0,  0,  0, 0, 2,  0, 0, 0, 0,
    0, 0, 0, 3,  0, 0, 0, 0,  0,  0,  0,  4,  0,  0, 0, 0,  0, 0, 0, 5,
    0, 0, 0, 0,  0, 0, 0, 6,  0,  0,  0,  0,  0,  0, 0, 7,  0, 0, 0, 0,
    0, 0, 0, 8,  0, 0, 0, 0,  0,  0,  0,  9,  0,  0, 0, 0,  0, 0, 0, 10,
    0, 0, 0, 0,  0, 0, 0, 11, 0,  0,  0,  0,  0,  0, 0, 12, 0, 0, 0, 0,
    0, 0, 0, 13, 0, 0, 0, 0,  0,  0,  0,  14, 0,  0, 0, 0,  0, 0, 0, 15,
    0, 0, 0, 0,  0, 0, 0, 16, 0,  0,  0,  0,  0,  0, 0, 17, 0, 0, 0, 0,
    0, 0, 0, 18, 0, 0, 0, 0,  0,  0,  0,  19, 0,  0, 0, 0,  0, 0, 0, 20,
    0, 0, 0, 0,  0, 0, 0, 21, 0,  0,  0,  0,  0,  0, 0, 22, 0, 0, 0, 0,
    0, 0, 0, 23, 0, 0, 0, 0,  0,  0,  0,  24, 0,  0, 0, 0,  0, 0, 0, 25,
    0, 0, 0, 0,  0, 0, 0, 26, 0,  0,  0,  0,  0,  0, 0, 27, 0, 0, 0, 0,
    0, 0, 0, 28, 0, 0, 0, 29, 0,  0,  0,  30, 0,  0, 0, 31, 0, 0, 0, 32,
    0, 0, 0, 33, 0, 0, 0, 34, 35, 36, 37, 38, 39, 0, 0, 40};
const uint8_t HuffDecoderCommon::table30_68_emit_[240] = {
    0xc3, 0x30, 0x30, 0xc3, 0x30, 0x31, 0xc3, 0x30, 0x32, 0xc3, 0x30, 0x61,
    0xc3, 0x30, 0x63, 0xc3, 0x30, 0x65, 0xc3, 0x30, 0x69, 0xc3, 0x30, 0x6f,
    0xc3, 0x30, 0x73, 0xc3, 0x30, 0x74, 0xc3, 0x31, 0x30, 0xc3, 0x31, 0x31,
    0xc3, 0x31, 0x32, 0xc3, 0x31, 0x61, 0xc3, 0x31, 0x63, 0xc3, 0x31, 0x65,
    0xc3, 0x31, 0x69, 0xc3, 0x31, 0x6f, 0xc3, 0x31, 0x73, 0xc3, 0x31, 0x74,
    0xc3, 0x32, 0x30, 0xc3, 0x32, 0x31, 0xc3, 0x32, 0x32, 0xc3, 0x32, 0x61,
    0xc3, 0x32, 0x63, 0xc3, 0x32, 0x65, 0xc3, 0x32, 0x69, 0xc3, 0x32, 0x6f,
    0xc3, 0x32, 0x73, 0xc3, 0x32, 0x74, 0xc3, 0x61, 0x30, 0xc3, 0x61, 0x31,
    0xc3, 0x61, 0x32, 0xc3, 0x61, 0x61, 0xc3, 0x61, 0x63, 0xc3, 0x61, 0x65,
    0xc3, 0x61, 0x69, 0xc3, 0x61, 0x6f, 0xc3, 0x61, 0x73, 0xc3, 0x61, 0x74,
    0xc3, 0x63, 0x30, 0xc3, 0x63, 0x31, 0xc3, 0x63, 0x32, 0xc3, 0x63, 0x61,
    0xc3, 0x63, 0x63, 0xc3, 0x63, 0x65, 0xc3, 0x63, 0x69, 0xc3, 0x63, 0x6f,
    0xc3, 0x63, 0x73, 0xc3, 0x63, 0x74, 0xc3, 0x65, 0x30, 0xc3, 0x65, 0x31,
    0xc3, 0x65, 0x32, 0xc3, 0x65, 0x61, 0xc3, 0x65, 0x63, 0xc3, 0x65, 0x65,
    0xc3, 0x65, 0x69, 0xc3, 0x65, 0x6f, 0xc3, 0x65, 0x73, 0xc3, 0x65, 0x74,
    0xc3, 0x69, 0x30, 0xc3, 0x69, 0x31, 0xc3, 0x69, 0x32, 0xc3, 0x69, 0x61,
    0xc3, 0x69, 0x63, 0xc3, 0x69, 0x65, 0xc3, 0x69, 0x69, 0xc3, 0x69, 0x6f,
    0xc3, 0x69, 0x73, 0xc3, 0x69, 0x74, 0xc3, 0x6f, 0x30, 0xc3, 0x6f, 0x31,
    0xc3, 0x6f, 0x32, 0xc3, 0x6f, 0x61, 0xc3, 0x6f, 0x63, 0xc3, 0x6f, 0x65,
    0xc3, 0x6f, 0x69, 0xc3, 0x6f, 0x6f, 0xc3, 0x6f, 0x73, 0xc3, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table30_69_emit_[84] = {
    0xc3, 0x73, 0x30, 0xc3, 0x73, 0x31, 0xc3, 0x73, 0x32, 0xc3, 0x73, 0x61,
    0xc3, 0x73, 0x63, 0xc3, 0x73, 0x65, 0xc3, 0x73, 0x69, 0xc3, 0x73, 0x6f,
    0xc3, 0x73, 0x73, 0xc3, 0x73, 0x74, 0xc3, 0x74, 0x30, 0xc3, 0x74, 0x31,
    0xc3, 0x74, 0x32, 0xc3, 0x74, 0x61, 0xc3, 0x74, 0x63, 0xc3, 0x74, 0x65,
    0xc3, 0x74, 0x69, 0xc3, 0x74, 0x6f, 0xc3, 0x74, 0x73, 0xc3, 0x74, 0x74,
    0xc3, 0x20, 0xc3, 0x25, 0xc3, 0x2d, 0xc3, 0x2e, 0xc3, 0x2f, 0xc3, 0x33,
    0xc3, 0x34, 0xc3, 0x35, 0xc3, 0x36, 0xc3, 0x37, 0xc3, 0x38, 0xc3, 0x39};
const uint8_t HuffDecoderCommon::table30_71_emit_[78] = {
    0xc3, 0x45, 0xc3, 0x46, 0xc3, 0x47, 0xc3, 0x48, 0xc3, 0x49, 0xc3, 0x4a,
    0xc3, 0x4b, 0xc3, 0x4c, 0xc3, 0x4d, 0xc3, 0x4e, 0xc3, 0x4f, 0xc3, 0x50,
    0xc3, 0x51, 0xc3, 0x52, 0xc3, 0x53, 0xc3, 0x54, 0xc3, 0x55, 0xc3, 0x56,
    0xc3, 0x57, 0xc3, 0x59, 0xc3, 0x6a, 0xc3, 0x6b, 0xc3, 0x71, 0xc3, 0x76,
    0xc3, 0x77, 0xc3, 0x78, 0xc3, 0x79, 0xc3, 0x7a, 0xc3, 0x26, 0xc3, 0x2a,
    0xc3, 0x2c, 0xc3, 0x3b, 0xc3, 0x58, 0xc3, 0x5a, 0xc3, 0x21, 0xc3, 0x22,
    0xc3, 0x28, 0xc3, 0x29, 0xc3, 0x3f};
const uint8_t HuffDecoderCommon::table30_72_emit_[240] = {
    0xd0, 0x30, 0x30, 0xd0, 0x30, 0x31, 0xd0, 0x30, 0x32, 0xd0, 0x30, 0x61,
    0xd0, 0x30, 0x63, 0xd0, 0x30, 0x65, 0xd0, 0x30, 0x69, 0xd0, 0x30, 0x6f,
    0xd0, 0x30, 0x73, 0xd0, 0x30, 0x74, 0xd0, 0x31, 0x30, 0xd0, 0x31, 0x31,
    0xd0, 0x31, 0x32, 0xd0, 0x31, 0x61, 0xd0, 0x31, 0x63, 0xd0, 0x31, 0x65,
    0xd0, 0x31, 0x69, 0xd0, 0x31, 0x6f, 0xd0, 0x31, 0x73, 0xd0, 0x31, 0x74,
    0xd0, 0x32, 0x30, 0xd0, 0x32, 0x31, 0xd0, 0x32, 0x32, 0xd0, 0x32, 0x61,
    0xd0, 0x32, 0x63, 0xd0, 0x32, 0x65, 0xd0, 0x32, 0x69, 0xd0, 0x32, 0x6f,
    0xd0, 0x32, 0x73, 0xd0, 0x32, 0x74, 0xd0, 0x61, 0x30, 0xd0, 0x61, 0x31,
    0xd0, 0x61, 0x32, 0xd0, 0x61, 0x61, 0xd0, 0x61, 0x63, 0xd0, 0x61, 0x65,
    0xd0, 0x61, 0x69, 0xd0, 0x61, 0x6f, 0xd0, 0x61, 0x73, 0xd0, 0x61, 0x74,
    0xd0, 0x63, 0x30, 0xd0, 0x63, 0x31, 0xd0, 0x63, 0x32, 0xd0, 0x63, 0x61,
    0xd0, 0x63, 0x63, 0xd0, 0x63, 0x65, 0xd0, 0x63, 0x69, 0xd0, 0x63, 0x6f,
    0xd0, 0x63, 0x73, 0xd0, 0x63, 0x74, 0xd0, 0x65, 0x30, 0xd0, 0x65, 0x31,
    0xd0, 0x65, 0x32, 0xd0, 0x65, 0x61, 0xd0, 0x65, 0x63, 0xd0, 0x65, 0x65,
    0xd0, 0x65, 0x69, 0xd0, 0x65, 0x6f, 0xd0, 0x65, 0x73, 0xd0, 0x65, 0x74,
    0xd0, 0x69, 0x30, 0xd0, 0x69, 0x31, 0xd0, 0x69, 0x32, 0xd0, 0x69, 0x61,
    0xd0, 0x69, 0x63, 0xd0, 0x69, 0x65, 0xd0, 0x69, 0x69, 0xd0, 0x69, 0x6f,
    0xd0, 0x69, 0x73, 0xd0, 0x69, 0x74, 0xd0, 0x6f, 0x30, 0xd0, 0x6f, 0x31,
    0xd0, 0x6f, 0x32, 0xd0, 0x6f, 0x61, 0xd0, 0x6f, 0x63, 0xd0, 0x6f, 0x65,
    0xd0, 0x6f, 0x69, 0xd0, 0x6f, 0x6f, 0xd0, 0x6f, 0x73, 0xd0, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table30_73_emit_[84] = {
    0xd0, 0x73, 0x30, 0xd0, 0x73, 0x31, 0xd0, 0x73, 0x32, 0xd0, 0x73, 0x61,
    0xd0, 0x73, 0x63, 0xd0, 0x73, 0x65, 0xd0, 0x73, 0x69, 0xd0, 0x73, 0x6f,
    0xd0, 0x73, 0x73, 0xd0, 0x73, 0x74, 0xd0, 0x74, 0x30, 0xd0, 0x74, 0x31,
    0xd0, 0x74, 0x32, 0xd0, 0x74, 0x61, 0xd0, 0x74, 0x63, 0xd0, 0x74, 0x65,
    0xd0, 0x74, 0x69, 0xd0, 0x74, 0x6f, 0xd0, 0x74, 0x73, 0xd0, 0x74, 0x74,
    0xd0, 0x20, 0xd0, 0x25, 0xd0, 0x2d, 0xd0, 0x2e, 0xd0, 0x2f, 0xd0, 0x33,
    0xd0, 0x34, 0xd0, 0x35, 0xd0, 0x36, 0xd0, 0x37, 0xd0, 0x38, 0xd0, 0x39};
const uint8_t HuffDecoderCommon::table30_75_emit_[78] = {
    0xd0, 0x45, 0xd0, 0x46, 0xd0, 0x47, 0xd0, 0x48, 0xd0, 0x49, 0xd0, 0x4a,
    0xd0, 0x4b, 0xd0, 0x4c, 0xd0, 0x4d, 0xd0, 0x4e, 0xd0, 0x4f, 0xd0, 0x50,
    0xd0, 0x51, 0xd0, 0x52, 0xd0, 0x53, 0xd0, 0x54, 0xd0, 0x55, 0xd0, 0x56,
    0xd0, 0x57, 0xd0, 0x59, 0xd0, 0x6a, 0xd0, 0x6b, 0xd0, 0x71, 0xd0, 0x76,
    0xd0, 0x77, 0xd0, 0x78, 0xd0, 0x79, 0xd0, 0x7a, 0xd0, 0x26, 0xd0, 0x2a,
    0xd0, 0x2c, 0xd0, 0x3b, 0xd0, 0x58, 0xd0, 0x5a, 0xd0, 0x21, 0xd0, 0x22,
    0xd0, 0x28, 0xd0, 0x29, 0xd0, 0x3f};
const uint8_t HuffDecoderCommon::table30_92_emit_[148] = {
    0x99, 0x30, 0x99, 0x31, 0x99, 0x32, 0x99, 0x61, 0x99, 0x63, 0x99, 0x65,
    0x99, 0x69, 0x99, 0x6f, 0x99, 0x73, 0x99, 0x74, 0x99, 0x20, 0x99, 0x25,
    0x99, 0x2d, 0x99, 0x2e, 0x99, 0x2f, 0x99, 0x33, 0x99, 0x34, 0x99, 0x35,
    0x99, 0x36, 0x99, 0x37, 0x99, 0x38, 0x99, 0x39, 0x99, 0x3d, 0x99, 0x41,
    0x99, 0x5f, 0x99, 0x62, 0x99, 0x64, 0x99, 0x66, 0x99, 0x67, 0x99, 0x68,
    0x99, 0x6c, 0x99, 0x6d, 0x99, 0x6e, 0x99, 0x70, 0x99, 0x72, 0x99, 0x75,
    0x99, 0x3a, 0x99, 0x42, 0x99, 0x43, 0x99, 0x44, 0x99, 0x45, 0x99, 0x46,
    0x99, 0x47, 0x99, 0x48, 0x99, 0x49, 0x99, 0x4a, 0x99, 0x4b, 0x99, 0x4c,
    0x99, 0x4d, 0x99, 0x4e, 0x99, 0x4f, 0x99, 0x50, 0x99, 0x51, 0x99, 0x52,
    0x99, 0x53, 0x99, 0x54, 0x99, 0x55, 0x99, 0x56, 0x99, 0x57, 0x99, 0x59,
    0x99, 0x6a, 0x99, 0x6b, 0x99, 0x71, 0x99, 0x76, 0x99, 0x77, 0x99, 0x78,
    0x99, 0x79, 0x99, 0x7a, 0x99, 0x26, 0x99, 0x2a, 0x99, 0x2c, 0x99, 0x3b,
    0x99, 0x58, 0x99, 0x5a};
const uint16_t HuffDecoderCommon::table30_92_inner_[76] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2, 0x02b2,
    0x02c2, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332, 0x0342,
    0x0352, 0x0362, 0x0372, 0x0382, 0x0392, 0x03a2, 0x03b2, 0x03c2, 0x03d2,
    0x03e2, 0x03f2, 0x0402, 0x0412, 0x0422, 0x0432, 0x0442, 0x0452, 0x0462,
    0x0472, 0x0482, 0x0492, 0x0003};
const uint8_t HuffDecoderCommon::table30_93_emit_[148] = {
    0xa1, 0x30, 0xa1, 0x31, 0xa1, 0x32, 0xa1, 0x61, 0xa1, 0x63, 0xa1, 0x65,
    0xa1, 0x69, 0xa1, 0x6f, 0xa1, 0x73, 0xa1, 0x74, 0xa1, 0x20, 0xa1, 0x25,
    0xa1, 0x2d, 0xa1, 0x2e, 0xa1, 0x2f, 0xa1, 0x33, 0xa1, 0x34, 0xa1, 0x35,
    0xa1, 0x36, 0xa1, 0x37, 0xa1, 0x38, 0xa1, 0x39, 0xa1, 0x3d, 0xa1, 0x41,
    0xa1, 0x5f, 0xa1, 0x62, 0xa1, 0x64, 0xa1, 0x66, 0xa1, 0x67, 0xa1, 0x68,
    0xa1, 0x6c, 0xa1, 0x6d, 0xa1, 0x6e, 0xa1, 0x70, 0xa1, 0x72, 0xa1, 0x75,
    0xa1, 0x3a, 0xa1, 0x42, 0xa1, 0x43, 0xa1, 0x44, 0xa1, 0x45, 0xa1, 0x46,
    0xa1, 0x47, 0xa1, 0x48, 0xa1, 0x49, 0xa1, 0x4a, 0xa1, 0x4b, 0xa1, 0x4c,
    0xa1, 0x4d, 0xa1, 0x4e, 0xa1, 0x4f, 0xa1, 0x50, 0xa1, 0x51, 0xa1, 0x52,
    0xa1, 0x53, 0xa1, 0x54, 0xa1, 0x55, 0xa1, 0x56, 0xa1, 0x57, 0xa1, 0x59,
    0xa1, 0x6a, 0xa1, 0x6b, 0xa1, 0x71, 0xa1, 0x76, 0xa1, 0x77, 0xa1, 0x78,
    0xa1, 0x79, 0xa1, 0x7a, 0xa1, 0x26, 0xa1, 0x2a, 0xa1, 0x2c, 0xa1, 0x3b,
    0xa1, 0x58, 0xa1, 0x5a};
const uint8_t HuffDecoderCommon::table30_94_emit_[148] = {
    0xa7, 0x30, 0xa7, 0x31, 0xa7, 0x32, 0xa7, 0x61, 0xa7, 0x63, 0xa7, 0x65,
    0xa7, 0x69, 0xa7, 0x6f, 0xa7, 0x73, 0xa7, 0x74, 0xa7, 0x20, 0xa7, 0x25,
    0xa7, 0x2d, 0xa7, 0x2e, 0xa7, 0x2f, 0xa7, 0x33, 0xa7, 0x34, 0xa7, 0x35,
    0xa7, 0x36, 0xa7, 0x37, 0xa7, 0x38, 0xa7, 0x39, 0xa7, 0x3d, 0xa7, 0x41,
    0xa7, 0x5f, 0xa7, 0x62, 0xa7, 0x64, 0xa7, 0x66, 0xa7, 0x67, 0xa7, 0x68,
    0xa7, 0x6c, 0xa7, 0x6d, 0xa7, 0x6e, 0xa7, 0x70, 0xa7, 0x72, 0xa7, 0x75,
    0xa7, 0x3a, 0xa7, 0x42, 0xa7, 0x43, 0xa7, 0x44, 0xa7, 0x45, 0xa7, 0x46,
    0xa7, 0x47, 0xa7, 0x48, 0xa7, 0x49, 0xa7, 0x4a, 0xa7, 0x4b, 0xa7, 0x4c,
    0xa7, 0x4d, 0xa7, 0x4e, 0xa7, 0x4f, 0xa7, 0x50, 0xa7, 0x51, 0xa7, 0x52,
    0xa7, 0x53, 0xa7, 0x54, 0xa7, 0x55, 0xa7, 0x56, 0xa7, 0x57, 0xa7, 0x59,
    0xa7, 0x6a, 0xa7, 0x6b, 0xa7, 0x71, 0xa7, 0x76, 0xa7, 0x77, 0xa7, 0x78,
    0xa7, 0x79, 0xa7, 0x7a, 0xa7, 0x26, 0xa7, 0x2a, 0xa7, 0x2c, 0xa7, 0x3b,
    0xa7, 0x58, 0xa7, 0x5a};
const uint8_t HuffDecoderCommon::table30_95_emit_[148] = {
    0xac, 0x30, 0xac, 0x31, 0xac, 0x32, 0xac, 0x61, 0xac, 0x63, 0xac, 0x65,
    0xac, 0x69, 0xac, 0x6f, 0xac, 0x73, 0xac, 0x74, 0xac, 0x20, 0xac, 0x25,
    0xac, 0x2d, 0xac, 0x2e, 0xac, 0x2f, 0xac, 0x33, 0xac, 0x34, 0xac, 0x35,
    0xac, 0x36, 0xac, 0x37, 0xac, 0x38, 0xac, 0x39, 0xac, 0x3d, 0xac, 0x41,
    0xac, 0x5f, 0xac, 0x62, 0xac, 0x64, 0xac, 0x66, 0xac, 0x67, 0xac, 0x68,
    0xac, 0x6c, 0xac, 0x6d, 0xac, 0x6e, 0xac, 0x70, 0xac, 0x72, 0xac, 0x75,
    0xac, 0x3a, 0xac, 0x42, 0xac, 0x43, 0xac, 0x44, 0xac, 0x45, 0xac, 0x46,
    0xac, 0x47, 0xac, 0x48, 0xac, 0x49, 0xac, 0x4a, 0xac, 0x4b, 0xac, 0x4c,
    0xac, 0x4d, 0xac, 0x4e, 0xac, 0x4f, 0xac, 0x50, 0xac, 0x51, 0xac, 0x52,
    0xac, 0x53, 0xac, 0x54, 0xac, 0x55, 0xac, 0x56, 0xac, 0x57, 0xac, 0x59,
    0xac, 0x6a, 0xac, 0x6b, 0xac, 0x71, 0xac, 0x76, 0xac, 0x77, 0xac, 0x78,
    0xac, 0x79, 0xac, 0x7a, 0xac, 0x26, 0xac, 0x2a, 0xac, 0x2c, 0xac, 0x3b,
    0xac, 0x58, 0xac, 0x5a};
const uint8_t HuffDecoderCommon::table30_96_emit_[148] = {
    0xb0, 0x30, 0xb0, 0x31, 0xb0, 0x32, 0xb0, 0x61, 0xb0, 0x63, 0xb0, 0x65,
    0xb0, 0x69, 0xb0, 0x6f, 0xb0, 0x73, 0xb0, 0x74, 0xb0, 0x20, 0xb0, 0x25,
    0xb0, 0x2d, 0xb0, 0x2e, 0xb0, 0x2f, 0xb0, 0x33, 0xb0, 0x34, 0xb0, 0x35,
    0xb0, 0x36, 0xb0, 0x37, 0xb0, 0x38, 0xb0, 0x39, 0xb0, 0x3d, 0xb0, 0x41,
    0xb0, 0x5f, 0xb0, 0x62, 0xb0, 0x64, 0xb0, 0x66, 0xb0, 0x67, 0xb0, 0x68,
    0xb0, 0x6c, 0xb0, 0x6d, 0xb0, 0x6e, 0xb0, 0x70, 0xb0, 0x72, 0xb0, 0x75,
    0xb0, 0x3a, 0xb0, 0x42, 0xb0, 0x43, 0xb0, 0x44, 0xb0, 0x45, 0xb0, 0x46,
    0xb0, 0x47, 0xb0, 0x48, 0xb0, 0x49, 0xb0, 0x4a, 0xb0, 0x4b, 0xb0, 0x4c,
    0xb0, 0x4d, 0xb0, 0x4e, 0xb0, 0x4f, 0xb0, 0x50, 0xb0, 0x51, 0xb0, 0x52,
    0xb0, 0x53, 0xb0, 0x54, 0xb0, 0x55, 0xb0, 0x56, 0xb0, 0x57, 0xb0, 0x59,
    0xb0, 0x6a, 0xb0, 0x6b, 0xb0, 0x71, 0xb0, 0x76, 0xb0, 0x77, 0xb0, 0x78,
    0xb0, 0x79, 0xb0, 0x7a, 0xb0, 0x26, 0xb0, 0x2a, 0xb0, 0x2c, 0xb0, 0x3b,
    0xb0, 0x58, 0xb0, 0x5a};
const uint8_t HuffDecoderCommon::table30_97_emit_[148] = {
    0xb1, 0x30, 0xb1, 0x31, 0xb1, 0x32, 0xb1, 0x61, 0xb1, 0x63, 0xb1, 0x65,
    0xb1, 0x69, 0xb1, 0x6f, 0xb1, 0x73, 0xb1, 0x74, 0xb1, 0x20, 0xb1, 0x25,
    0xb1, 0x2d, 0xb1, 0x2e, 0xb1, 0x2f, 0xb1, 0x33, 0xb1, 0x34, 0xb1, 0x35,
    0xb1, 0x36, 0xb1, 0x37, 0xb1, 0x38, 0xb1, 0x39, 0xb1, 0x3d, 0xb1, 0x41,
    0xb1, 0x5f, 0xb1, 0x62, 0xb1, 0x64, 0xb1, 0x66, 0xb1, 0x67, 0xb1, 0x68,
    0xb1, 0x6c, 0xb1, 0x6d, 0xb1, 0x6e, 0xb1, 0x70, 0xb1, 0x72, 0xb1, 0x75,
    0xb1, 0x3a, 0xb1, 0x42, 0xb1, 0x43, 0xb1, 0x44, 0xb1, 0x45, 0xb1, 0x46,
    0xb1, 0x47, 0xb1, 0x48, 0xb1, 0x49, 0xb1, 0x4a, 0xb1, 0x4b, 0xb1, 0x4c,
    0xb1, 0x4d, 0xb1, 0x4e, 0xb1, 0x4f, 0xb1, 0x50, 0xb1, 0x51, 0xb1, 0x52,
    0xb1, 0x53, 0xb1, 0x54, 0xb1, 0x55, 0xb1, 0x56, 0xb1, 0x57, 0xb1, 0x59,
    0xb1, 0x6a, 0xb1, 0x6b, 0xb1, 0x71, 0xb1, 0x76, 0xb1, 0x77, 0xb1, 0x78,
    0xb1, 0x79, 0xb1, 0x7a, 0xb1, 0x26, 0xb1, 0x2a, 0xb1, 0x2c, 0xb1, 0x3b,
    0xb1, 0x58, 0xb1, 0x5a};
const uint8_t HuffDecoderCommon::table30_98_emit_[148] = {
    0xb3, 0x30, 0xb3, 0x31, 0xb3, 0x32, 0xb3, 0x61, 0xb3, 0x63, 0xb3, 0x65,
    0xb3, 0x69, 0xb3, 0x6f, 0xb3, 0x73, 0xb3, 0x74, 0xb3, 0x20, 0xb3, 0x25,
    0xb3, 0x2d, 0xb3, 0x2e, 0xb3, 0x2f, 0xb3, 0x33, 0xb3, 0x34, 0xb3, 0x35,
    0xb3, 0x36, 0xb3, 0x37, 0xb3, 0x38, 0xb3, 0x39, 0xb3, 0x3d, 0xb3, 0x41,
    0xb3, 0x5f, 0xb3, 0x62, 0xb3, 0x64, 0xb3, 0x66, 0xb3, 0x67, 0xb3, 0x68,
    0xb3, 0x6c, 0xb3, 0x6d, 0xb3, 0x6e, 0xb3, 0x70, 0xb3, 0x72, 0xb3, 0x75,
    0xb3, 0x3a, 0xb3, 0x42, 0xb3, 0x43, 0xb3, 0x44, 0xb3, 0x45, 0xb3, 0x46,
    0xb3, 0x47, 0xb3, 0x48, 0xb3, 0x49, 0xb3, 0x4a, 0xb3, 0x4b, 0xb3, 0x4c,
    0xb3, 0x4d, 0xb3, 0x4e, 0xb3, 0x4f, 0xb3, 0x50, 0xb3, 0x51, 0xb3, 0x52,
    0xb3, 0x53, 0xb3, 0x54, 0xb3, 0x55, 0xb3, 0x56, 0xb3, 0x57, 0xb3, 0x59,
    0xb3, 0x6a, 0xb3, 0x6b, 0xb3, 0x71, 0xb3, 0x76, 0xb3, 0x77, 0xb3, 0x78,
    0xb3, 0x79, 0xb3, 0x7a, 0xb3, 0x26, 0xb3, 0x2a, 0xb3, 0x2c, 0xb3, 0x3b,
    0xb3, 0x58, 0xb3, 0x5a};
const uint8_t HuffDecoderCommon::table30_99_emit_[148] = {
    0xd1, 0x30, 0xd1, 0x31, 0xd1, 0x32, 0xd1, 0x61, 0xd1, 0x63, 0xd1, 0x65,
    0xd1, 0x69, 0xd1, 0x6f, 0xd1, 0x73, 0xd1, 0x74, 0xd1, 0x20, 0xd1, 0x25,
    0xd1, 0x2d, 0xd1, 0x2e, 0xd1, 0x2f, 0xd1, 0x33, 0xd1, 0x34, 0xd1, 0x35,
    0xd1, 0x36, 0xd1, 0x37, 0xd1, 0x38, 0xd1, 0x39, 0xd1, 0x3d, 0xd1, 0x41,
    0xd1, 0x5f, 0xd1, 0x62, 0xd1, 0x64, 0xd1, 0x66, 0xd1, 0x67, 0xd1, 0x68,
    0xd1, 0x6c, 0xd1, 0x6d, 0xd1, 0x6e, 0xd1, 0x70, 0xd1, 0x72, 0xd1, 0x75,
    0xd1, 0x3a, 0xd1, 0x42, 0xd1, 0x43, 0xd1, 0x44, 0xd1, 0x45, 0xd1, 0x46,
    0xd1, 0x47, 0xd1, 0x48, 0xd1, 0x49, 0xd1, 0x4a, 0xd1, 0x4b, 0xd1, 0x4c,
    0xd1, 0x4d, 0xd1, 0x4e, 0xd1, 0x4f, 0xd1, 0x50, 0xd1, 0x51, 0xd1, 0x52,
    0xd1, 0x53, 0xd1, 0x54, 0xd1, 0x55, 0xd1, 0x56, 0xd1, 0x57, 0xd1, 0x59,
    0xd1, 0x6a, 0xd1, 0x6b, 0xd1, 0x71, 0xd1, 0x76, 0xd1, 0x77, 0xd1, 0x78,
    0xd1, 0x79, 0xd1, 0x7a, 0xd1, 0x26, 0xd1, 0x2a, 0xd1, 0x2c, 0xd1, 0x3b,
    0xd1, 0x58, 0xd1, 0x5a};
const uint8_t HuffDecoderCommon::table30_100_emit_[148] = {
    0xd8, 0x30, 0xd8, 0x31, 0xd8, 0x32, 0xd8, 0x61, 0xd8, 0x63, 0xd8, 0x65,
    0xd8, 0x69, 0xd8, 0x6f, 0xd8, 0x73, 0xd8, 0x74, 0xd8, 0x20, 0xd8, 0x25,
    0xd8, 0x2d, 0xd8, 0x2e, 0xd8, 0x2f, 0xd8, 0x33, 0xd8, 0x34, 0xd8, 0x35,
    0xd8, 0x36, 0xd8, 0x37, 0xd8, 0x38, 0xd8, 0x39, 0xd8, 0x3d, 0xd8, 0x41,
    0xd8, 0x5f, 0xd8, 0x62, 0xd8, 0x64, 0xd8, 0x66, 0xd8, 0x67, 0xd8, 0x68,
    0xd8, 0x6c, 0xd8, 0x6d, 0xd8, 0x6e, 0xd8, 0x70, 0xd8, 0x72, 0xd8, 0x75,
    0xd8, 0x3a, 0xd8, 0x42, 0xd8, 0x43, 0xd8, 0x44, 0xd8, 0x45, 0xd8, 0x46,
    0xd8, 0x47, 0xd8, 0x48, 0xd8, 0x49, 0xd8, 0x4a, 0xd8, 0x4b, 0xd8, 0x4c,
    0xd8, 0x4d, 0xd8, 0x4e, 0xd8, 0x4f, 0xd8, 0x50, 0xd8, 0x51, 0xd8, 0x52,
    0xd8, 0x53, 0xd8, 0x54, 0xd8, 0x55, 0xd8, 0x56, 0xd8, 0x57, 0xd8, 0x59,
    0xd8, 0x6a, 0xd8, 0x6b, 0xd8, 0x71, 0xd8, 0x76, 0xd8, 0x77, 0xd8, 0x78,
    0xd8, 0x79, 0xd8, 0x7a, 0xd8, 0x26, 0xd8, 0x2a, 0xd8, 0x2c, 0xd8, 0x3b,
    0xd8, 0x58, 0xd8, 0x5a};
const uint8_t HuffDecoderCommon::table30_101_emit_[148] = {
    0xd9, 0x30, 0xd9, 0x31, 0xd9, 0x32, 0xd9, 0x61, 0xd9, 0x63, 0xd9, 0x65,
    0xd9, 0x69, 0xd9, 0x6f, 0xd9, 0x73, 0xd9, 0x74, 0xd9, 0x20, 0xd9, 0x25,
    0xd9, 0x2d, 0xd9, 0x2e, 0xd9, 0x2f, 0xd9, 0x33, 0xd9, 0x34, 0xd9, 0x35,
    0xd9, 0x36, 0xd9, 0x37, 0xd9, 0x38, 0xd9, 0x39, 0xd9, 0x3d, 0xd9, 0x41,
    0xd9, 0x5f, 0xd9, 0x62, 0xd9, 0x64, 0xd9, 0x66, 0xd9, 0x67, 0xd9, 0x68,
    0xd9, 0x6c, 0xd9, 0x6d, 0xd9, 0x6e, 0xd9, 0x70, 0xd9, 0x72, 0xd9, 0x75,
    0xd9, 0x3a, 0xd9, 0x42, 0xd9, 0x43, 0xd9, 0x44, 0xd9, 0x45, 0xd9, 0x46,
    0xd9, 0x47, 0xd9, 0x48, 0xd9, 0x49, 0xd9, 0x4a, 0xd9, 0x4b, 0xd9, 0x4c,
    0xd9, 0x4d, 0xd9, 0x4e, 0xd9, 0x4f, 0xd9, 0x50, 0xd9, 0x51, 0xd9, 0x52,
    0xd9, 0x53, 0xd9, 0x54, 0xd9, 0x55, 0xd9, 0x56, 0xd9, 0x57, 0xd9, 0x59,
    0xd9, 0x6a, 0xd9, 0x6b, 0xd9, 0x71, 0xd9, 0x76, 0xd9, 0x77, 0xd9, 0x78,
    0xd9, 0x79, 0xd9, 0x7a, 0xd9, 0x26, 0xd9, 0x2a, 0xd9, 0x2c, 0xd9, 0x3b,
    0xd9, 0x58, 0xd9, 0x5a};
const uint8_t HuffDecoderCommon::table30_102_emit_[148] = {
    0xe3, 0x30, 0xe3, 0x31, 0xe3, 0x32, 0xe3, 0x61, 0xe3, 0x63, 0xe3, 0x65,
    0xe3, 0x69, 0xe3, 0x6f, 0xe3, 0x73, 0xe3, 0x74, 0xe3, 0x20, 0xe3, 0x25,
    0xe3, 0x2d, 0xe3, 0x2e, 0xe3, 0x2f, 0xe3, 0x33, 0xe3, 0x34, 0xe3, 0x35,
    0xe3, 0x36, 0xe3, 0x37, 0xe3, 0x38, 0xe3, 0x39, 0xe3, 0x3d, 0xe3, 0x41,
    0xe3, 0x5f, 0xe3, 0x62, 0xe3, 0x64, 0xe3, 0x66, 0xe3, 0x67, 0xe3, 0x68,
    0xe3, 0x6c, 0xe3, 0x6d, 0xe3, 0x6e, 0xe3, 0x70, 0xe3, 0x72, 0xe3, 0x75,
    0xe3, 0x3a, 0xe3, 0x42, 0xe3, 0x43, 0xe3, 0x44, 0xe3, 0x45, 0xe3, 0x46,
    0xe3, 0x47, 0xe3, 0x48, 0xe3, 0x49, 0xe3, 0x4a, 0xe3, 0x4b, 0xe3, 0x4c,
    0xe3, 0x4d, 0xe3, 0x4e, 0xe3, 0x4f, 0xe3, 0x50, 0xe3, 0x51, 0xe3, 0x52,
    0xe3, 0x53, 0xe3, 0x54, 0xe3, 0x55, 0xe3, 0x56, 0xe3, 0x57, 0xe3, 0x59,
    0xe3, 0x6a, 0xe3, 0x6b, 0xe3, 0x71, 0xe3, 0x76, 0xe3, 0x77, 0xe3, 0x78,
    0xe3, 0x79, 0xe3, 0x7a, 0xe3, 0x26, 0xe3, 0x2a, 0xe3, 0x2c, 0xe3, 0x3b,
    0xe3, 0x58, 0xe3, 0x5a};
const uint8_t HuffDecoderCommon::table30_103_emit_[148] = {
    0xe5, 0x30, 0xe5, 0x31, 0xe5, 0x32, 0xe5, 0x61, 0xe5, 0x63, 0xe5, 0x65,
    0xe5, 0x69, 0xe5, 0x6f, 0xe5, 0x73, 0xe5, 0x74, 0xe5, 0x20, 0xe5, 0x25,
    0xe5, 0x2d, 0xe5, 0x2e, 0xe5, 0x2f, 0xe5, 0x33, 0xe5, 0x34, 0xe5, 0x35,
    0xe5, 0x36, 0xe5, 0x37, 0xe5, 0x38, 0xe5, 0x39, 0xe5, 0x3d, 0xe5, 0x41,
    0xe5, 0x5f, 0xe5, 0x62, 0xe5, 0x64, 0xe5, 0x66, 0xe5, 0x67, 0xe5, 0x68,
    0xe5, 0x6c, 0xe5, 0x6d, 0xe5, 0x6e, 0xe5, 0x70, 0xe5, 0x72, 0xe5, 0x75,
    0xe5, 0x3a, 0xe5, 0x42, 0xe5, 0x43, 0xe5, 0x44, 0xe5, 0x45, 0xe5, 0x46,
    0xe5, 0x47, 0xe5, 0x48, 0xe5, 0x49, 0xe5, 0x4a, 0xe5, 0x4b, 0xe5, 0x4c,
    0xe5, 0x4d, 0xe5, 0x4e, 0xe5, 0x4f, 0xe5, 0x50, 0xe5, 0x51, 0xe5, 0x52,
    0xe5, 0x53, 0xe5, 0x54, 0xe5, 0x55, 0xe5, 0x56, 0xe5, 0x57, 0xe5, 0x59,
    0xe5, 0x6a, 0xe5, 0x6b, 0xe5, 0x71, 0xe5, 0x76, 0xe5, 0x77, 0xe5, 0x78,
    0xe5, 0x79, 0xe5, 0x7a, 0xe5, 0x26, 0xe5, 0x2a, 0xe5, 0x2c, 0xe5, 0x3b,
    0xe5, 0x58, 0xe5, 0x5a};
const uint8_t HuffDecoderCommon::table30_104_emit_[148] = {
    0xe6, 0x30, 0xe6, 0x31, 0xe6, 0x32, 0xe6, 0x61, 0xe6, 0x63, 0xe6, 0x65,
    0xe6, 0x69, 0xe6, 0x6f, 0xe6, 0x73, 0xe6, 0x74, 0xe6, 0x20, 0xe6, 0x25,
    0xe6, 0x2d, 0xe6, 0x2e, 0xe6, 0x2f, 0xe6, 0x33, 0xe6, 0x34, 0xe6, 0x35,
    0xe6, 0x36, 0xe6, 0x37, 0xe6, 0x38, 0xe6, 0x39, 0xe6, 0x3d, 0xe6, 0x41,
    0xe6, 0x5f, 0xe6, 0x62, 0xe6, 0x64, 0xe6, 0x66, 0xe6, 0x67, 0xe6, 0x68,
    0xe6, 0x6c, 0xe6, 0x6d, 0xe6, 0x6e, 0xe6, 0x70, 0xe6, 0x72, 0xe6, 0x75,
    0xe6, 0x3a, 0xe6, 0x42, 0xe6, 0x43, 0xe6, 0x44, 0xe6, 0x45, 0xe6, 0x46,
    0xe6, 0x47, 0xe6, 0x48, 0xe6, 0x49, 0xe6, 0x4a, 0xe6, 0x4b, 0xe6, 0x4c,
    0xe6, 0x4d, 0xe6, 0x4e, 0xe6, 0x4f, 0xe6, 0x50, 0xe6, 0x51, 0xe6, 0x52,
    0xe6, 0x53, 0xe6, 0x54, 0xe6, 0x55, 0xe6, 0x56, 0xe6, 0x57, 0xe6, 0x59,
    0xe6, 0x6a, 0xe6, 0x6b, 0xe6, 0x71, 0xe6, 0x76, 0xe6, 0x77, 0xe6, 0x78,
    0xe6, 0x79, 0xe6, 0x7a, 0xe6, 0x26, 0xe6, 0x2a, 0xe6, 0x2c, 0xe6, 0x3b,
    0xe6, 0x58, 0xe6, 0x5a};
const uint8_t HuffDecoderCommon::table30_105_emit_[272] = {
    0x81, 0x30, 0x81, 0x31, 0x81, 0x32, 0x81, 0x61, 0x81, 0x63, 0x81, 0x65,
    0x81, 0x69, 0x81, 0x6f, 0x81, 0x73, 0x81, 0x74, 0x81, 0x20, 0x81, 0x25,
    0x81, 0x2d, 0x81, 0x2e, 0x81, 0x2f, 0x81, 0x33, 0x81, 0x34, 0x81, 0x35,
    0x81, 0x36, 0x81, 0x37, 0x81, 0x38, 0x81, 0x39, 0x81, 0x3d, 0x81, 0x41,
    0x81, 0x5f, 0x81, 0x62, 0x81, 0x64, 0x81, 0x66, 0x81, 0x67, 0x81, 0x68,
    0x81, 0x6c, 0x81, 0x6d, 0x81, 0x6e, 0x81, 0x70, 0x81, 0x72, 0x81, 0x75,
    0x81, 0x3a, 0x81, 0x42, 0x81, 0x43, 0x81, 0x44, 0x81, 0x45, 0x81, 0x46,
    0x81, 0x47, 0x81, 0x48, 0x81, 0x49, 0x81, 0x4a, 0x81, 0x4b, 0x81, 0x4c,
    0x81, 0x4d, 0x81, 0x4e, 0x81, 0x4f, 0x81, 0x50, 0x81, 0x51, 0x81, 0x52,
    0x81, 0x53, 0x81, 0x54, 0x81, 0x55, 0x81, 0x56, 0x81, 0x57, 0x81, 0x59,
    0x81, 0x6a, 0x81, 0x6b, 0x81, 0x71, 0x81, 0x76, 0x81, 0x77, 0x81, 0x78,
    0x81, 0x79, 0x81, 0x7a, 0x84, 0x30, 0x84, 0x31, 0x84, 0x32, 0x84, 0x61,
    0x84, 0x63, 0x84, 0x65, 0x84, 0x69, 0x84, 0x6f, 0x84, 0x73, 0x84, 0x74,
    0x84, 0x20, 0x84, 0x25, 0x84, 0x2d, 0x84, 0x2e, 0x84, 0x2f, 0x84, 0x33,
    0x84, 0x34, 0x84, 0x35, 0x84, 0x36, 0x84, 0x37, 0x84, 0x38, 0x84, 0x39,
    0x84, 0x3d, 0x84, 0x41, 0x84, 0x5f, 0x84, 0x62, 0x84, 0x64, 0x84, 0x66,
    0x84, 0x67, 0x84, 0x68, 0x84, 0x6c, 0x84, 0x6d, 0x84, 0x6e, 0x84, 0x70,
    0x84, 0x72, 0x84, 0x75, 0x84, 0x3a, 0x84, 0x42, 0x84, 0x43, 0x84, 0x44,
    0x84, 0x45, 0x84, 0x46, 0x84, 0x47, 0x84, 0x48, 0x84, 0x49, 0x84, 0x4a,
    0x84, 0x4b, 0x84, 0x4c, 0x84, 0x4d, 0x84, 0x4e, 0x84, 0x4f, 0x84, 0x50,
    0x84, 0x51, 0x84, 0x52, 0x84, 0x53, 0x84, 0x54, 0x84, 0x55, 0x84, 0x56,
    0x84, 0x57, 0x84, 0x59, 0x84, 0x6a, 0x84, 0x6b, 0x84, 0x71, 0x84, 0x76,
    0x84, 0x77, 0x84, 0x78, 0x84, 0x79, 0x84, 0x7a};
const uint16_t HuffDecoderCommon::table30_105_inner_[139] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2, 0x02b2,
    0x02c2, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332, 0x0342,
    0x0352, 0x0362, 0x0372, 0x0382, 0x0392, 0x03a2, 0x03b2, 0x03c2, 0x03d2,
    0x03e2, 0x03f2, 0x0402, 0x0412, 0x0422, 0x0432, 0x0003, 0x0442, 0x0452,
    0x0462, 0x0472, 0x0482, 0x0492, 0x04a2, 0x04b2, 0x04c2, 0x04d2, 0x04e2,
    0x04f2, 0x0502, 0x0512, 0x0522, 0x0532, 0x0542, 0x0552, 0x0562, 0x0572,
    0x0582, 0x0592, 0x05a2, 0x05b2, 0x05c2, 0x05d2, 0x05e2, 0x05f2, 0x0602,
    0x0612, 0x0622, 0x0632, 0x0642, 0x0652, 0x0662, 0x0672, 0x0682, 0x0692,
    0x06a2, 0x06b2, 0x06c2, 0x06d2, 0x06e2, 0x06f2, 0x0702, 0x0712, 0x0722,
    0x0732, 0x0742, 0x0752, 0x0762, 0x0772, 0x0782, 0x0792, 0x07a2, 0x07b2,
    0x07c2, 0x07d2, 0x07e2, 0x07f2, 0x0802, 0x0812, 0x0822, 0x0832, 0x0842,
    0x0852, 0x0862, 0x0872, 0x0443};
const uint8_t HuffDecoderCommon::table30_106_emit_[272] = {
    0x85, 0x30, 0x85, 0x31, 0x85, 0x32, 0x85, 0x61, 0x85, 0x63, 0x85, 0x65,
    0x85, 0x69, 0x85, 0x6f, 0x85, 0x73, 0x85, 0x74, 0x85, 0x20, 0x85, 0x25,
    0x85, 0x2d, 0x85, 0x2e, 0x85, 0x2f, 0x85, 0x33, 0x85, 0x34, 0x85, 0x35,
    0x85, 0x36, 0x85, 0x37, 0x85, 0x38, 0x85, 0x39, 0x85, 0x3d, 0x85, 0x41,
    0x85, 0x5f, 0x85, 0x62, 0x85, 0x64, 0x85, 0x66, 0x85, 0x67, 0x85, 0x68,
    0x85, 0x6c, 0x85, 0x6d, 0x85, 0x6e, 0x85, 0x70, 0x85, 0x72, 0x85, 0x75,
    0x85, 0x3a, 0x85, 0x42, 0x85, 0x43, 0x85, 0x44, 0x85, 0x45, 0x85, 0x46,
    0x85, 0x47, 0x85, 0x48, 0x85, 0x49, 0x85, 0x4a, 0x85, 0x4b, 0x85, 0x4c,
    0x85, 0x4d, 0x85, 0x4e, 0x85, 0x4f, 0x85, 0x50, 0x85, 0x51, 0x85, 0x52,
    0x85, 0x53, 0x85, 0x54, 0x85, 0x55, 0x85, 0x56, 0x85, 0x57, 0x85, 0x59,
    0x85, 0x6a, 0x85, 0x6b, 0x85, 0x71, 0x85, 0x76, 0x85, 0x77, 0x85, 0x78,
    0x85, 0x79, 0x85, 0x7a, 0x86, 0x30, 0x86, 0x31, 0x86, 0x32, 0x86, 0x61,
    0x86, 0x63, 0x86, 0x65, 0x86, 0x69, 0x86, 0x6f, 0x86, 0x73, 0x86, 0x74,
    0x86, 0x20, 0x86, 0x25, 0x86, 0x2d, 0x86, 0x2e, 0x86, 0x2f, 0x86, 0x33,
    0x86, 0x34, 0x86, 0x35, 0x86, 0x36, 0x86, 0x37, 0x86, 0x38, 0x86, 0x39,
    0x86, 0x3d, 0x86, 0x41, 0x86, 0x5f, 0x86, 0x62, 0x86, 0x64, 0x86, 0x66,
    0x86, 0x67, 0x86, 0x68, 0x86, 0x6c, 0x86, 0x6d, 0x86, 0x6e, 0x86, 0x70,
    0x86, 0x72, 0x86, 0x75, 0x86, 0x3a, 0x86, 0x42, 0x86, 0x43, 0x86, 0x44,
    0x86, 0x45, 0x86, 0x46, 0x86, 0x47, 0x86, 0x48, 0x86, 0x49, 0x86, 0x4a,
    0x86, 0x4b, 0x86, 0x4c, 0x86, 0x4d, 0x86, 0x4e, 0x86, 0x4f, 0x86, 0x50,
    0x86, 0x51, 0x86, 0x52, 0x86, 0x53, 0x86, 0x54, 0x86, 0x55, 0x86, 0x56,
    0x86, 0x57, 0x86, 0x59, 0x86, 0x6a, 0x86, 0x6b, 0x86, 0x71, 0x86, 0x76,
    0x86, 0x77, 0x86, 0x78, 0x86, 0x79, 0x86, 0x7a};
const uint8_t HuffDecoderCommon::table30_107_emit_[272] = {
    0x88, 0x30, 0x88, 0x31, 0x88, 0x32, 0x88, 0x61, 0x88, 0x63, 0x88, 0x65,
    0x88, 0x69, 0x88, 0x6f, 0x88, 0x73, 0x88, 0x74, 0x88, 0x20, 0x88, 0x25,
    0x88, 0x2d, 0x88, 0x2e, 0x88, 0x2f, 0x88, 0x33, 0x88, 0x34, 0x88, 0x35,
    0x88, 0x36, 0x88, 0x37, 0x88, 0x38, 0x88, 0x39, 0x88, 0x3d, 0x88, 0x41,
    0x88, 0x5f, 0x88, 0x62, 0x88, 0x64, 0x88, 0x66, 0x88, 0x67, 0x88, 0x68,
    0x88, 0x6c, 0x88, 0x6d, 0x88, 0x6e, 0x88, 0x70, 0x88, 0x72, 0x88, 0x75,
    0x88, 0x3a, 0x88, 0x42, 0x88, 0x43, 0x88, 0x44, 0x88, 0x45, 0x88, 0x46,
    0x88, 0x47, 0x88, 0x48, 0x88, 0x49, 0x88, 0x4a, 0x88, 0x4b, 0x88, 0x4c,
    0x88, 0x4d, 0x88, 0x4e, 0x88, 0x4f, 0x88, 0x50, 0x88, 0x51, 0x88, 0x52,
    0x88, 0x53, 0x88, 0x54, 0x88, 0x55, 0x88, 0x56, 0x88, 0x57, 0x88, 0x59,
    0x88, 0x6a, 0x88, 0x6b, 0x88, 0x71, 0x88, 0x76, 0x88, 0x77, 0x88, 0x78,
    0x88, 0x79, 0x88, 0x7a, 0x92, 0x30, 0x92, 0x31, 0x92, 0x32, 0x92, 0x61,
    0x92, 0x63, 0x92, 0x65, 0x92, 0x69, 0x92, 0x6f, 0x92, 0x73, 0x92, 0x74,
    0x92, 0x20, 0x92, 0x25, 0x92, 0x2d, 0x92, 0x2e, 0x92, 0x2f, 0x92, 0x33,
    0x92, 0x34, 0x92, 0x35, 0x92, 0x36, 0x92, 0x37, 0x92, 0x38, 0x92, 0x39,
    0x92, 0x3d, 0x92, 0x41, 0x92, 0x5f, 0x92, 0x62, 0x92, 0x64, 0x92, 0x66,
    0x92, 0x67, 0x92, 0x68, 0x92, 0x6c, 0x92, 0x6d, 0x92, 0x6e, 0x92, 0x70,
    0x92, 0x72, 0x92, 0x75, 0x92, 0x3a, 0x92, 0x42, 0x92, 0x43, 0x92, 0x44,
    0x92, 0x45, 0x92, 0x46, 0x92, 0x47, 0x92, 0x48, 0x92, 0x49, 0x92, 0x4a,
    0x92, 0x4b, 0x92, 0x4c, 0x92, 0x4d, 0x92, 0x4e, 0x92, 0x4f, 0x92, 0x50,
    0x92, 0x51, 0x92, 0x52, 0x92, 0x53, 0x92, 0x54, 0x92, 0x55, 0x92, 0x56,
    0x92, 0x57, 0x92, 0x59, 0x92, 0x6a, 0x92, 0x6b, 0x92, 0x71, 0x92, 0x76,
    0x92, 0x77, 0x92, 0x78, 0x92, 0x79, 0x92, 0x7a};
const uint8_t HuffDecoderCommon::table30_108_emit_[272] = {
    0x9a, 0x30, 0x9a, 0x31, 0x9a, 0x32, 0x9a, 0x61, 0x9a, 0x63, 0x9a, 0x65,
    0x9a, 0x69, 0x9a, 0x6f, 0x9a, 0x73, 0x9a, 0x74, 0x9a, 0x20, 0x9a, 0x25,
    0x9a, 0x2d, 0x9a, 0x2e, 0x9a, 0x2f, 0x9a, 0x33, 0x9a, 0x34, 0x9a, 0x35,
    0x9a, 0x36, 0x9a, 0x37, 0x9a, 0x38, 0x9a, 0x39, 0x9a, 0x3d, 0x9a, 0x41,
    0x9a, 0x5f, 0x9a, 0x62, 0x9a, 0x64, 0x9a, 0x66, 0x9a, 0x67, 0x9a, 0x68,
    0x9a, 0x6c, 0x9a, 0x6d, 0x9a, 0x6e, 0x9a, 0x70, 0x9a, 0x72, 0x9a, 0x75,
    0x9a, 0x3a, 0x9a, 0x42, 0x9a, 0x43, 0x9a, 0x44, 0x9a, 0x45, 0x9a, 0x46,
    0x9a, 0x47, 0x9a, 0x48, 0x9a, 0x49, 0x9a, 0x4a, 0x9a, 0x4b, 0x9a, 0x4c,
    0x9a, 0x4d, 0x9a, 0x4e, 0x9a, 0x4f, 0x9a, 0x50, 0x9a, 0x51, 0x9a, 0x52,
    0x9a, 0x53, 0x9a, 0x54, 0x9a, 0x55, 0x9a, 0x56, 0x9a, 0x57, 0x9a, 0x59,
    0x9a, 0x6a, 0x9a, 0x6b, 0x9a, 0x71, 0x9a, 0x76, 0x9a, 0x77, 0x9a, 0x78,
    0x9a, 0x79, 0x9a, 0x7a, 0x9c, 0x30, 0x9c, 0x31, 0x9c, 0x32, 0x9c, 0x61,
    0x9c, 0x63, 0x9c, 0x65, 0x9c, 0x69, 0x9c, 0x6f, 0x9c, 0x73, 0x9c, 0x74,
    0x9c, 0x20, 0x9c, 0x25, 0x9c, 0x2d, 0x9c, 0x2e, 0x9c, 0x2f, 0x9c, 0x33,
    0x9c, 0x34, 0x9c, 0x35, 0x9c, 0x36, 0x9c, 0x37, 0x9c, 0x38, 0x9c, 0x39,
    0x9c, 0x3d, 0x9c, 0x41, 0x9c, 0x5f, 0x9c, 0x62, 0x9c, 0x64, 0x9c, 0x66,
    0x9c, 0x67, 0x9c, 0x68, 0x9c, 0x6c, 0x9c, 0x6d, 0x9c, 0x6e, 0x9c, 0x70,
    0x9c, 0x72, 0x9c, 0x75, 0x9c, 0x3a, 0x9c, 0x42, 0x9c, 0x43, 0x9c, 0x44,
    0x9c, 0x45, 0x9c, 0x46, 0x9c, 0x47, 0x9c, 0x48, 0x9c, 0x49, 0x9c, 0x4a,
    0x9c, 0x4b, 0x9c, 0x4c, 0x9c, 0x4d, 0x9c, 0x4e, 0x9c, 0x4f, 0x9c, 0x50,
    0x9c, 0x51, 0x9c, 0x52, 0x9c, 0x53, 0x9c, 0x54, 0x9c, 0x55, 0x9c, 0x56,
    0x9c, 0x57, 0x9c, 0x59, 0x9c, 0x6a, 0x9c, 0x6b, 0x9c, 0x71, 0x9c, 0x76,
    0x9c, 0x77, 0x9c, 0x78, 0x9c, 0x79, 0x9c, 0x7a};
const uint8_t HuffDecoderCommon::table30_109_emit_[272] = {
    0xa0, 0x30, 0xa0, 0x31, 0xa0, 0x32, 0xa0, 0x61, 0xa0, 0x63, 0xa0, 0x65,
    0xa0, 0x69, 0xa0, 0x6f, 0xa0, 0x73, 0xa0, 0x74, 0xa0, 0x20, 0xa0, 0x25,
    0xa0, 0x2d, 0xa0, 0x2e, 0xa0, 0x2f, 0xa0, 0x33, 0xa0, 0x34, 0xa0, 0x35,
    0xa0, 0x36, 0xa0, 0x37, 0xa0, 0x38, 0xa0, 0x39, 0xa0, 0x3d, 0xa0, 0x41,
    0xa0, 0x5f, 0xa0, 0x62, 0xa0, 0x64, 0xa0, 0x66, 0xa0, 0x67, 0xa0, 0x68,
    0xa0, 0x6c, 0xa0, 0x6d, 0xa0, 0x6e, 0xa0, 0x70, 0xa0, 0x72, 0xa0, 0x75,
    0xa0, 0x3a, 0xa0, 0x42, 0xa0, 0x43, 0xa0, 0x44, 0xa0, 0x45, 0xa0, 0x46,
    0xa0, 0x47, 0xa0, 0x48, 0xa0, 0x49, 0xa0, 0x4a, 0xa0, 0x4b, 0xa0, 0x4c,
    0xa0, 0x4d, 0xa0, 0x4e, 0xa0, 0x4f, 0xa0, 0x50, 0xa0, 0x51, 0xa0, 0x52,
    0xa0, 0x53, 0xa0, 0x54, 0xa0, 0x55, 0xa0, 0x56, 0xa0, 0x57, 0xa0, 0x59,
    0xa0, 0x6a, 0xa0, 0x6b, 0xa0, 0x71, 0xa0, 0x76, 0xa0, 0x77, 0xa0, 0x78,
    0xa0, 0x79, 0xa0, 0x7a, 0xa3, 0x30, 0xa3, 0x31, 0xa3, 0x32, 0xa3, 0x61,
    0xa3, 0x63, 0xa3, 0x65, 0xa3, 0x69, 0xa3, 0x6f, 0xa3, 0x73, 0xa3, 0x74,
    0xa3, 0x20, 0xa3, 0x25, 0xa3, 0x2d, 0xa3, 0x2e, 0xa3, 0x2f, 0xa3, 0x33,
    0xa3, 0x34, 0xa3, 0x35, 0xa3, 0x36, 0xa3, 0x37, 0xa3, 0x38, 0xa3, 0x39,
    0xa3, 0x3d, 0xa3, 0x41, 0xa3, 0x5f, 0xa3, 0x62, 0xa3, 0x64, 0xa3, 0x66,
    0xa3, 0x67, 0xa3, 0x68, 0xa3, 0x6c, 0xa3, 0x6d, 0xa3, 0x6e, 0xa3, 0x70,
    0xa3, 0x72, 0xa3, 0x75, 0xa3, 0x3a, 0xa3, 0x42, 0xa3, 0x43, 0xa3, 0x44,
    0xa3, 0x45, 0xa3, 0x46, 0xa3, 0x47, 0xa3, 0x48, 0xa3, 0x49, 0xa3, 0x4a,
    0xa3, 0x4b, 0xa3, 0x4c, 0xa3, 0x4d, 0xa3, 0x4e, 0xa3, 0x4f, 0xa3, 0x50,
    0xa3, 0x51, 0xa3, 0x52, 0xa3, 0x53, 0xa3, 0x54, 0xa3, 0x55, 0xa3, 0x56,
    0xa3, 0x57, 0xa3, 0x59, 0xa3, 0x6a, 0xa3, 0x6b, 0xa3, 0x71, 0xa3, 0x76,
    0xa3, 0x77, 0xa3, 0x78, 0xa3, 0x79, 0xa3, 0x7a};
const uint8_t HuffDecoderCommon::table30_110_emit_[272] = {
    0xa4, 0x30, 0xa4, 0x31, 0xa4, 0x32, 0xa4, 0x61, 0xa4, 0x63, 0xa4, 0x65,
    0xa4, 0x69, 0xa4, 0x6f, 0xa4, 0x73, 0xa4, 0x74, 0xa4, 0x20, 0xa4, 0x25,
    0xa4, 0x2d, 0xa4, 0x2e, 0xa4, 0x2f, 0xa4, 0x33, 0xa4, 0x34, 0xa4, 0x35,
    0xa4, 0x36, 0xa4, 0x37, 0xa4, 0x38, 0xa4, 0x39, 0xa4, 0x3d, 0xa4, 0x41,
    0xa4, 0x5f, 0xa4, 0x62, 0xa4, 0x64, 0xa4, 0x66, 0xa4, 0x67, 0xa4, 0x68,
    0xa4, 0x6c, 0xa4, 0x6d, 0xa4, 0x6e, 0xa4, 0x70, 0xa4, 0x72, 0xa4, 0x75,
    0xa4, 0x3a, 0xa4, 0x42, 0xa4, 0x43, 0xa4, 0x44, 0xa4, 0x45, 0xa4, 0x46,
    0xa4, 0x47, 0xa4, 0x48, 0xa4, 0x49, 0xa4, 0x4a, 0xa4, 0x4b, 0xa4, 0x4c,
    0xa4, 0x4d, 0xa4, 0x4e, 0xa4, 0x4f, 0xa4, 0x50, 0xa4, 0x51, 0xa4, 0x52,
    0xa4, 0x53, 0xa4, 0x54, 0xa4, 0x55, 0xa4, 0x56, 0xa4, 0x57, 0xa4, 0x59,
    0xa4, 0x6a, 0xa4, 0x6b, 0xa4, 0x71, 0xa4, 0x76, 0xa4, 0x77, 0xa4, 0x78,
    0xa4, 0x79, 0xa4, 0x7a, 0xa9, 0x30, 0xa9, 0x31, 0xa9, 0x32, 0xa9, 0x61,
    0xa9, 0x63, 0xa9, 0x65, 0xa9, 0x69, 0xa9, 0x6f, 0xa9, 0x73, 0xa9, 0x74,
    0xa9, 0x20, 0xa9, 0x25, 0xa9, 0x2d, 0xa9, 0x2e, 0xa9, 0x2f, 0xa9, 0x33,
    0xa9, 0x34, 0xa9, 0x35, 0xa9, 0x36, 0xa9, 0x37, 0xa9, 0x38, 0xa9, 0x39,
    0xa9, 0x3d, 0xa9, 0x41, 0xa9, 0x5f, 0xa9, 0x62, 0xa9, 0x64, 0xa9, 0x66,
    0xa9, 0x67, 0xa9, 0x68, 0xa9, 0x6c, 0xa9, 0x6d, 0xa9, 0x6e, 0xa9, 0x70,
    0xa9, 0x72, 0xa9, 0x75, 0xa9, 0x3a, 0xa9, 0x42, 0xa9, 0x43, 0xa9, 0x44,
    0xa9, 0x45, 0xa9, 0x46, 0xa9, 0x47, 0xa9, 0x48, 0xa9, 0x49, 0xa9, 0x4a,
    0xa9, 0x4b, 0xa9, 0x4c, 0xa9, 0x4d, 0xa9, 0x4e, 0xa9, 0x4f, 0xa9, 0x50,
    0xa9, 0x51, 0xa9, 0x52, 0xa9, 0x53, 0xa9, 0x54, 0xa9, 0x55, 0xa9, 0x56,
    0xa9, 0x57, 0xa9, 0x59, 0xa9, 0x6a, 0xa9, 0x6b, 0xa9, 0x71, 0xa9, 0x76,
    0xa9, 0x77, 0xa9, 0x78, 0xa9, 0x79, 0xa9, 0x7a};
const uint8_t HuffDecoderCommon::table30_111_emit_[272] = {
    0xaa, 0x30, 0xaa, 0x31, 0xaa, 0x32, 0xaa, 0x61, 0xaa, 0x63, 0xaa, 0x65,
    0xaa, 0x69, 0xaa, 0x6f, 0xaa, 0x73, 0xaa, 0x74, 0xaa, 0x20, 0xaa, 0x25,
    0xaa, 0x2d, 0xaa, 0x2e, 0xaa, 0x2f, 0xaa, 0x33, 0xaa, 0x34, 0xaa, 0x35,
    0xaa, 0x36, 0xaa, 0x37, 0xaa, 0x38, 0xaa, 0x39, 0xaa, 0x3d, 0xaa, 0x41,
    0xaa, 0x5f, 0xaa, 0x62, 0xaa, 0x64, 0xaa, 0x66, 0xaa, 0x67, 0xaa, 0x68,
    0xaa, 0x6c, 0xaa, 0x6d, 0xaa, 0x6e, 0xaa, 0x70, 0xaa, 0x72, 0xaa, 0x75,
    0xaa, 0x3a, 0xaa, 0x42, 0xaa, 0x43, 0xaa, 0x44, 0xaa, 0x45, 0xaa, 0x46,
    0xaa, 0x47, 0xaa, 0x48, 0xaa, 0x49, 0xaa, 0x4a, 0xaa, 0x4b, 0xaa, 0x4c,
    0xaa, 0x4d, 0xaa, 0x4e, 0xaa, 0x4f, 0xaa, 0x50, 0xaa, 0x51, 0xaa, 0x52,
    0xaa, 0x53, 0xaa, 0x54, 0xaa, 0x55, 0xaa, 0x56, 0xaa, 0x57, 0xaa, 0x59,
    0xaa, 0x6a, 0xaa, 0x6b, 0xaa, 0x71, 0xaa, 0x76, 0xaa, 0x77, 0xaa, 0x78,
    0xaa, 0x79, 0xaa, 0x7a, 0xad, 0x30, 0xad, 0x31, 0xad, 0x32, 0xad, 0x61,
    0xad, 0x63, 0xad, 0x65, 0xad, 0x69, 0xad, 0x6f, 0xad, 0x73, 0xad, 0x74,
    0xad, 0x20, 0xad, 0x25, 0xad, 0x2d, 0xad, 0x2e, 0xad, 0x2f, 0xad, 0x33,
    0xad, 0x34, 0xad, 0x35, 0xad, 0x36, 0xad, 0x37, 0xad, 0x38, 0xad, 0x39,
    0xad, 0x3d, 0xad, 0x41, 0xad, 0x5f, 0xad, 0x62, 0xad, 0x64, 0xad, 0x66,
    0xad, 0x67, 0xad, 0x68, 0xad, 0x6c, 0xad, 0x6d, 0xad, 0x6e, 0xad, 0x70,
    0xad, 0x72, 0xad, 0x75, 0xad, 0x3a, 0xad, 0x42, 0xad, 0x43, 0xad, 0x44,
    0xad, 0x45, 0xad, 0x46, 0xad, 0x47, 0xad, 0x48, 0xad, 0x49, 0xad, 0x4a,
    0xad, 0x4b, 0xad, 0x4c, 0xad, 0x4d, 0xad, 0x4e, 0xad, 0x4f, 0xad, 0x50,
    0xad, 0x51, 0xad, 0x52, 0xad, 0x53, 0xad, 0x54, 0xad, 0x55, 0xad, 0x56,
    0xad, 0x57, 0xad, 0x59, 0xad, 0x6a, 0xad, 0x6b, 0xad, 0x71, 0xad, 0x76,
    0xad, 0x77, 0xad, 0x78, 0xad, 0x79, 0xad, 0x7a};
const uint8_t HuffDecoderCommon::table30_112_emit_[272] = {
    0xb2, 0x30, 0xb2, 0x31, 0xb2, 0x32, 0xb2, 0x61, 0xb2, 0x63, 0xb2, 0x65,
    0xb2, 0x69, 0xb2, 0x6f, 0xb2, 0x73, 0xb2, 0x74, 0xb2, 0x20, 0xb2, 0x25,
    0xb2, 0x2d, 0xb2, 0x2e, 0xb2, 0x2f, 0xb2, 0x33, 0xb2, 0x34, 0xb2, 0x35,
    0xb2, 0x36, 0xb2, 0x37, 0xb2, 0x38, 0xb2, 0x39, 0xb2, 0x3d, 0xb2, 0x41,
    0xb2, 0x5f, 0xb2, 0x62, 0xb2, 0x64, 0xb2, 0x66, 0xb2, 0x67, 0xb2, 0x68,
    0xb2, 0x6c, 0xb2, 0x6d, 0xb2, 0x6e, 0xb2, 0x70, 0xb2, 0x72, 0xb2, 0x75,
    0xb2, 0x3a, 0xb2, 0x42, 0xb2, 0x43, 0xb2, 0x44, 0xb2, 0x45, 0xb2, 0x46,
    0xb2, 0x47, 0xb2, 0x48, 0xb2, 0x49, 0xb2, 0x4a, 0xb2, 0x4b, 0xb2, 0x4c,
    0xb2, 0x4d, 0xb2, 0x4e, 0xb2, 0x4f, 0xb2, 0x50, 0xb2, 0x51, 0xb2, 0x52,
    0xb2, 0x53, 0xb2, 0x54, 0xb2, 0x55, 0xb2, 0x56, 0xb2, 0x57, 0xb2, 0x59,
    0xb2, 0x6a, 0xb2, 0x6b, 0xb2, 0x71, 0xb2, 0x76, 0xb2, 0x77, 0xb2, 0x78,
    0xb2, 0x79, 0xb2, 0x7a, 0xb5, 0x30, 0xb5, 0x31, 0xb5, 0x32, 0xb5, 0x61,
    0xb5, 0x63, 0xb5, 0x65, 0xb5, 0x69, 0xb5, 0x6f, 0xb5, 0x73, 0xb5, 0x74,
    0xb5, 0x20, 0xb5, 0x25, 0xb5, 0x2d, 0xb5, 0x2e, 0xb5, 0x2f, 0xb5, 0x33,
    0xb5, 0x34, 0xb5, 0x35, 0xb5, 0x36, 0xb5, 0x37, 0xb5, 0x38, 0xb5, 0x39,
    0xb5, 0x3d, 0xb5, 0x41, 0xb5, 0x5f, 0xb5, 0x62, 0xb5, 0x64, 0xb5, 0x66,
    0xb5, 0x67, 0xb5, 0x68, 0xb5, 0x6c, 0xb5, 0x6d, 0xb5, 0x6e, 0xb5, 0x70,
    0xb5, 0x72, 0xb5, 0x75, 0xb5, 0x3a, 0xb5, 0x42, 0xb5, 0x43, 0xb5, 0x44,
    0xb5, 0x45, 0xb5, 0x46, 0xb5, 0x47, 0xb5, 0x48, 0xb5, 0x49, 0xb5, 0x4a,
    0xb5, 0x4b, 0xb5, 0x4c, 0xb5, 0x4d, 0xb5, 0x4e, 0xb5, 0x4f, 0xb5, 0x50,
    0xb5, 0x51, 0xb5, 0x52, 0xb5, 0x53, 0xb5, 0x54, 0xb5, 0x55, 0xb5, 0x56,
    0xb5, 0x57, 0xb5, 0x59, 0xb5, 0x6a, 0xb5, 0x6b, 0xb5, 0x71, 0xb5, 0x76,
    0xb5, 0x77, 0xb5, 0x78, 0xb5, 0x79, 0xb5, 0x7a};
const uint8_t HuffDecoderCommon::table30_113_emit_[272] = {
    0xb9, 0x30, 0xb9, 0x31, 0xb9, 0x32, 0xb9, 0x61, 0xb9, 0x63, 0xb9, 0x65,
    0xb9, 0x69, 0xb9, 0x6f, 0xb9, 0x73, 0xb9, 0x74, 0xb9, 0x20, 0xb9, 0x25,
    0xb9, 0x2d, 0xb9, 0x2e, 0xb9, 0x2f, 0xb9, 0x33, 0xb9, 0x34, 0xb9, 0x35,
    0xb9, 0x36, 0xb9, 0x37, 0xb9, 0x38, 0xb9, 0x39, 0xb9, 0x3d, 0xb9, 0x41,
    0xb9, 0x5f, 0xb9, 0x62, 0xb9, 0x64, 0xb9, 0x66, 0xb9, 0x67, 0xb9, 0x68,
    0xb9, 0x6c, 0xb9, 0x6d, 0xb9, 0x6e, 0xb9, 0x70, 0xb9, 0x72, 0xb9, 0x75,
    0xb9, 0x3a, 0xb9, 0x42, 0xb9, 0x43, 0xb9, 0x44, 0xb9, 0x45, 0xb9, 0x46,
    0xb9, 0x47, 0xb9, 0x48, 0xb9, 0x49, 0xb9, 0x4a, 0xb9, 0x4b, 0xb9, 0x4c,
    0xb9, 0x4d, 0xb9, 0x4e, 0xb9, 0x4f, 0xb9, 0x50, 0xb9, 0x51, 0xb9, 0x52,
    0xb9, 0x53, 0xb9, 0x54, 0xb9, 0x55, 0xb9, 0x56, 0xb9, 0x57, 0xb9, 0x59,
    0xb9, 0x6a, 0xb9, 0x6b, 0xb9, 0x71, 0xb9, 0x76, 0xb9, 0x77, 0xb9, 0x78,
    0xb9, 0x79, 0xb9, 0x7a, 0xba, 0x30, 0xba, 0x31, 0xba, 0x32, 0xba, 0x61,
    0xba, 0x63, 0xba, 0x65, 0xba, 0x69, 0xba, 0x6f, 0xba, 0x73, 0xba, 0x74,
    0xba, 0x20, 0xba, 0x25, 0xba, 0x2d, 0xba, 0x2e, 0xba, 0x2f, 0xba, 0x33,
    0xba, 0x34, 0xba, 0x35, 0xba, 0x36, 0xba, 0x37, 0xba, 0x38, 0xba, 0x39,
    0xba, 0x3d, 0xba, 0x41, 0xba, 0x5f, 0xba, 0x62, 0xba, 0x64, 0xba, 0x66,
    0xba, 0x67, 0xba, 0x68, 0xba, 0x6c, 0xba, 0x6d, 0xba, 0x6e, 0xba, 0x70,
    0xba, 0x72, 0xba, 0x75, 0xba, 0x3a, 0xba, 0x42, 0xba, 0x43, 0xba, 0x44,
    0xba, 0x45, 0xba, 0x46, 0xba, 0x47, 0xba, 0x48, 0xba, 0x49, 0xba, 0x4a,
    0xba, 0x4b, 0xba, 0x4c, 0xba, 0x4d, 0xba, 0x4e, 0xba, 0x4f, 0xba, 0x50,
    0xba, 0x51, 0xba, 0x52, 0xba, 0x53, 0xba, 0x54, 0xba, 0x55, 0xba, 0x56,
    0xba, 0x57, 0xba, 0x59, 0xba, 0x6a, 0xba, 0x6b, 0xba, 0x71, 0xba, 0x76,
    0xba, 0x77, 0xba, 0x78, 0xba, 0x79, 0xba, 0x7a};
const uint8_t HuffDecoderCommon::table30_114_emit_[272] = {
    0xbb, 0x30, 0xbb, 0x31, 0xbb, 0x32, 0xbb, 0x61, 0xbb, 0x63, 0xbb, 0x65,
    0xbb, 0x69, 0xbb, 0x6f, 0xbb, 0x73, 0xbb, 0x74, 0xbb, 0x20, 0xbb, 0x25,
    0xbb, 0x2d, 0xbb, 0x2e, 0xbb, 0x2f, 0xbb, 0x33, 0xbb, 0x34, 0xbb, 0x35,
    0xbb, 0x36, 0xbb, 0x37, 0xbb, 0x38, 0xbb, 0x39, 0xbb, 0x3d, 0xbb, 0x41,
    0xbb, 0x5f, 0xbb, 0x62, 0xbb, 0x64, 0xbb, 0x66, 0xbb, 0x67, 0xbb, 0x68,
    0xbb, 0x6c, 0xbb, 0x6d, 0xbb, 0x6e, 0xbb, 0x70, 0xbb, 0x72, 0xbb, 0x75,
    0xbb, 0x3a, 0xbb, 0x42, 0xbb, 0x43, 0xbb, 0x44, 0xbb, 0x45, 0xbb, 0x46,
    0xbb, 0x47, 0xbb, 0x48, 0xbb, 0x49, 0xbb, 0x4a, 0xbb, 0x4b, 0xbb, 0x4c,
    0xbb, 0x4d, 0xbb, 0x4e, 0xbb, 0x4f, 0xbb, 0x50, 0xbb, 0x51, 0xbb, 0x52,
    0xbb, 0x53, 0xbb, 0x54, 0xbb, 0x55, 0xbb, 0x56, 0xbb, 0x57, 0xbb, 0x59,
    0xbb, 0x6a, 0xbb, 0x6b, 0xbb, 0x71, 0xbb, 0x76, 0xbb, 0x77, 0xbb, 0x78,
    0xbb, 0x79, 0xbb, 0x7a, 0xbd, 0x30, 0xbd, 0x31, 0xbd, 0x32, 0xbd, 0x61,
    0xbd, 0x63, 0xbd, 0x65, 0xbd, 0x69, 0xbd, 0x6f, 0xbd, 0x73, 0xbd, 0x74,
    0xbd, 0x20, 0xbd, 0x25, 0xbd, 0x2d, 0xbd, 0x2e, 0xbd, 0x2f, 0xbd, 0x33,
    0xbd, 0x34, 0xbd, 0x35, 0xbd, 0x36, 0xbd, 0x37, 0xbd, 0x38, 0xbd, 0x39,
    0xbd, 0x3d, 0xbd, 0x41, 0xbd, 0x5f, 0xbd, 0x62, 0xbd, 0x64, 0xbd, 0x66,
    0xbd, 0x67, 0xbd, 0x68, 0xbd, 0x6c, 0xbd, 0x6d, 0xbd, 0x6e, 0xbd, 0x70,
    0xbd, 0x72, 0xbd, 0x75, 0xbd, 0x3a, 0xbd, 0x42, 0xbd, 0x43, 0xbd, 0x44,
    0xbd, 0x45, 0xbd, 0x46, 0xbd, 0x47, 0xbd, 0x48, 0xbd, 0x49, 0xbd, 0x4a,
    0xbd, 0x4b, 0xbd, 0x4c, 0xbd, 0x4d, 0xbd, 0x4e, 0xbd, 0x4f, 0xbd, 0x50,
    0xbd, 0x51, 0xbd, 0x52, 0xbd, 0x53, 0xbd, 0x54, 0xbd, 0x55, 0xbd, 0x56,
    0xbd, 0x57, 0xbd, 0x59, 0xbd, 0x6a, 0xbd, 0x6b, 0xbd, 0x71, 0xbd, 0x76,
    0xbd, 0x77, 0xbd, 0x78, 0xbd, 0x79, 0xbd, 0x7a};
const uint8_t HuffDecoderCommon::table30_115_emit_[272] = {
    0xbe, 0x30, 0xbe, 0x31, 0xbe, 0x32, 0xbe, 0x61, 0xbe, 0x63, 0xbe, 0x65,
    0xbe, 0x69, 0xbe, 0x6f, 0xbe, 0x73, 0xbe, 0x74, 0xbe, 0x20, 0xbe, 0x25,
    0xbe, 0x2d, 0xbe, 0x2e, 0xbe, 0x2f, 0xbe, 0x33, 0xbe, 0x34, 0xbe, 0x35,
    0xbe, 0x36, 0xbe, 0x37, 0xbe, 0x38, 0xbe, 0x39, 0xbe, 0x3d, 0xbe, 0x41,
    0xbe, 0x5f, 0xbe, 0x62, 0xbe, 0x64, 0xbe, 0x66, 0xbe, 0x67, 0xbe, 0x68,
    0xbe, 0x6c, 0xbe, 0x6d, 0xbe, 0x6e, 0xbe, 0x70, 0xbe, 0x72, 0xbe, 0x75,
    0xbe, 0x3a, 0xbe, 0x42, 0xbe, 0x43, 0xbe, 0x44, 0xbe, 0x45, 0xbe, 0x46,
    0xbe, 0x47, 0xbe, 0x48, 0xbe, 0x49, 0xbe, 0x4a, 0xbe, 0x4b, 0xbe, 0x4c,
    0xbe, 0x4d, 0xbe, 0x4e, 0xbe, 0x4f, 0xbe, 0x50, 0xbe, 0x51, 0xbe, 0x52,
    0xbe, 0x53, 0xbe, 0x54, 0xbe, 0x55, 0xbe, 0x56, 0xbe, 0x57, 0xbe, 0x59,
    0xbe, 0x6a, 0xbe, 0x6b, 0xbe, 0x71, 0xbe, 0x76, 0xbe, 0x77, 0xbe, 0x78,
    0xbe, 0x79, 0xbe, 0x7a, 0xc4, 0x30, 0xc4, 0x31, 0xc4, 0x32, 0xc4, 0x61,
    0xc4, 0x63, 0xc4, 0x65, 0xc4, 0x69, 0xc4, 0x6f, 0xc4, 0x73, 0xc4, 0x74,
    0xc4, 0x20, 0xc4, 0x25, 0xc4, 0x2d, 0xc4, 0x2e, 0xc4, 0x2f, 0xc4, 0x33,
    0xc4, 0x34, 0xc4, 0x35, 0xc4, 0x36, 0xc4, 0x37, 0xc4, 0x38, 0xc4, 0x39,
    0xc4, 0x3d, 0xc4, 0x41, 0xc4, 0x5f, 0xc4, 0x62, 0xc4, 0x64, 0xc4, 0x66,
    0xc4, 0x67, 0xc4, 0x68, 0xc4, 0x6c, 0xc4, 0x6d, 0xc4, 0x6e, 0xc4, 0x70,
    0xc4, 0x72, 0xc4, 0x75, 0xc4, 0x3a, 0xc4, 0x42, 0xc4, 0x43, 0xc4, 0x44,
    0xc4, 0x45, 0xc4, 0x46, 0xc4, 0x47, 0xc4, 0x48, 0xc4, 0x49, 0xc4, 0x4a,
    0xc4, 0x4b, 0xc4, 0x4c, 0xc4, 0x4d, 0xc4, 0x4e, 0xc4, 0x4f, 0xc4, 0x50,
    0xc4, 0x51, 0xc4, 0x52, 0xc4, 0x53, 0xc4, 0x54, 0xc4, 0x55, 0xc4, 0x56,
    0xc4, 0x57, 0xc4, 0x59, 0xc4, 0x6a, 0xc4, 0x6b, 0xc4, 0x71, 0xc4, 0x76,
    0xc4, 0x77, 0xc4, 0x78, 0xc4, 0x79, 0xc4, 0x7a};
const uint8_t HuffDecoderCommon::table30_116_emit_[272] = {
    0xc6, 0x30, 0xc6, 0x31, 0xc6, 0x32, 0xc6, 0x61, 0xc6, 0x63, 0xc6, 0x65,
    0xc6, 0x69, 0xc6, 0x6f, 0xc6, 0x73, 0xc6, 0x74, 0xc6, 0x20, 0xc6, 0x25,
    0xc6, 0x2d, 0xc6, 0x2e, 0xc6, 0x2f, 0xc6, 0x33, 0xc6, 0x34, 0xc6, 0x35,
    0xc6, 0x36, 0xc6, 0x37, 0xc6, 0x38, 0xc6, 0x39, 0xc6, 0x3d, 0xc6, 0x41,
    0xc6, 0x5f, 0xc6, 0x62, 0xc6, 0x64, 0xc6, 0x66, 0xc6, 0x67, 0xc6, 0x68,
    0xc6, 0x6c, 0xc6, 0x6d, 0xc6, 0x6e, 0xc6, 0x70, 0xc6, 0x72, 0xc6, 0x75,
    0xc6, 0x3a, 0xc6, 0x42, 0xc6, 0x43, 0xc6, 0x44, 0xc6, 0x45, 0xc6, 0x46,
    0xc6, 0x47, 0xc6, 0x48, 0xc6, 0x49, 0xc6, 0x4a, 0xc6, 0x4b, 0xc6, 0x4c,
    0xc6, 0x4d, 0xc6, 0x4e, 0xc6, 0x4f, 0xc6, 0x50, 0xc6, 0x51, 0xc6, 0x52,
    0xc6, 0x53, 0xc6, 0x54, 0xc6, 0x55, 0xc6, 0x56, 0xc6, 0x57, 0xc6, 0x59,
    0xc6, 0x6a, 0xc6, 0x6b, 0xc6, 0x71, 0xc6, 0x76, 0xc6, 0x77, 0xc6, 0x78,
    0xc6, 0x79, 0xc6, 0x7a, 0xe4, 0x30, 0xe4, 0x31, 0xe4, 0x32, 0xe4, 0x61,
    0xe4, 0x63, 0xe4, 0x65, 0xe4, 0x69, 0xe4, 0x6f, 0xe4, 0x73, 0xe4, 0x74,
    0xe4, 0x20, 0xe4, 0x25, 0xe4, 0x2d, 0xe4, 0x2e, 0xe4, 0x2f, 0xe4, 0x33,
    0xe4, 0x34, 0xe4, 0x35, 0xe4, 0x36, 0xe4, 0x37, 0xe4, 0x38, 0xe4, 0x39,
    0xe4, 0x3d, 0xe4, 0x41, 0xe4, 0x5f, 0xe4, 0x62, 0xe4, 0x64, 0xe4, 0x66,
    0xe4, 0x67, 0xe4, 0x68, 0xe4, 0x6c, 0xe4, 0x6d, 0xe4, 0x6e, 0xe4, 0x70,
    0xe4, 0x72, 0xe4, 0x75, 0xe4, 0x3a, 0xe4, 0x42, 0xe4, 0x43, 0xe4, 0x44,
    0xe4, 0x45, 0xe4, 0x46, 0xe4, 0x47, 0xe4, 0x48, 0xe4, 0x49, 0xe4, 0x4a,
    0xe4, 0x4b, 0xe4, 0x4c, 0xe4, 0x4d, 0xe4, 0x4e, 0xe4, 0x4f, 0xe4, 0x50,
    0xe4, 0x51, 0xe4, 0x52, 0xe4, 0x53, 0xe4, 0x54, 0xe4, 0x55, 0xe4, 0x56,
    0xe4, 0x57, 0xe4, 0x59, 0xe4, 0x6a, 0xe4, 0x6b, 0xe4, 0x71, 0xe4, 0x76,
    0xe4, 0x77, 0xe4, 0x78, 0xe4, 0x79, 0xe4, 0x7a};
const uint8_t HuffDecoderCommon::table30_117_emit_[272] = {
    0xe8, 0x30, 0xe8, 0x31, 0xe8, 0x32, 0xe8, 0x61, 0xe8, 0x63, 0xe8, 0x65,
    0xe8, 0x69, 0xe8, 0x6f, 0xe8, 0x73, 0xe8, 0x74, 0xe8, 0x20, 0xe8, 0x25,
    0xe8, 0x2d, 0xe8, 0x2e, 0xe8, 0x2f, 0xe8, 0x33, 0xe8, 0x34, 0xe8, 0x35,
    0xe8, 0x36, 0xe8, 0x37, 0xe8, 0x38, 0xe8, 0x39, 0xe8, 0x3d, 0xe8, 0x41,
    0xe8, 0x5f, 0xe8, 0x62, 0xe8, 0x64, 0xe8, 0x66, 0xe8, 0x67, 0xe8, 0x68,
    0xe8, 0x6c, 0xe8, 0x6d, 0xe8, 0x6e, 0xe8, 0x70, 0xe8, 0x72, 0xe8, 0x75,
    0xe8, 0x3a, 0xe8, 0x42, 0xe8, 0x43, 0xe8, 0x44, 0xe8, 0x45, 0xe8, 0x46,
    0xe8, 0x47, 0xe8, 0x48, 0xe8, 0x49, 0xe8, 0x4a, 0xe8, 0x4b, 0xe8, 0x4c,
    0xe8, 0x4d, 0xe8, 0x4e, 0xe8, 0x4f, 0xe8, 0x50, 0xe8, 0x51, 0xe8, 0x52,
    0xe8, 0x53, 0xe8, 0x54, 0xe8, 0x55, 0xe8, 0x56, 0xe8, 0x57, 0xe8, 0x59,
    0xe8, 0x6a, 0xe8, 0x6b, 0xe8, 0x71, 0xe8, 0x76, 0xe8, 0x77, 0xe8, 0x78,
    0xe8, 0x79, 0xe8, 0x7a, 0xe9, 0x30, 0xe9, 0x31, 0xe9, 0x32, 0xe9, 0x61,
    0xe9, 0x63, 0xe9, 0x65, 0xe9, 0x69, 0xe9, 0x6f, 0xe9, 0x73, 0xe9, 0x74,
    0xe9, 0x20, 0xe9, 0x25, 0xe9, 0x2d, 0xe9, 0x2e, 0xe9, 0x2f, 0xe9, 0x33,
    0xe9, 0x34, 0xe9, 0x35, 0xe9, 0x36, 0xe9, 0x37, 0xe9, 0x38, 0xe9, 0x39,
    0xe9, 0x3d, 0xe9, 0x41, 0xe9, 0x5f, 0xe9, 0x62, 0xe9, 0x64, 0xe9, 0x66,
    0xe9, 0x67, 0xe9, 0x68, 0xe9, 0x6c, 0xe9, 0x6d, 0xe9, 0x6e, 0xe9, 0x70,
    0xe9, 0x72, 0xe9, 0x75, 0xe9, 0x3a, 0xe9, 0x42, 0xe9, 0x43, 0xe9, 0x44,
    0xe9, 0x45, 0xe9, 0x46, 0xe9, 0x47, 0xe9, 0x48, 0xe9, 0x49, 0xe9, 0x4a,
    0xe9, 0x4b, 0xe9, 0x4c, 0xe9, 0x4d, 0xe9, 0x4e, 0xe9, 0x4f, 0xe9, 0x50,
    0xe9, 0x51, 0xe9, 0x52, 0xe9, 0x53, 0xe9, 0x54, 0xe9, 0x55, 0xe9, 0x56,
    0xe9, 0x57, 0xe9, 0x59, 0xe9, 0x6a, 0xe9, 0x6b, 0xe9, 0x71, 0xe9, 0x76,
    0xe9, 0x77, 0xe9, 0x78, 0xe9, 0x79, 0xe9, 0x7a};
const uint8_t HuffDecoderCommon::table30_118_emit_[288] = {
    0x01, 0x30, 0x01, 0x31, 0x01, 0x32, 0x01, 0x61, 0x01, 0x63, 0x01, 0x65,
    0x01, 0x69, 0x01, 0x6f, 0x01, 0x73, 0x01, 0x74, 0x01, 0x20, 0x01, 0x25,
    0x01, 0x2d, 0x01, 0x2e, 0x01, 0x2f, 0x01, 0x33, 0x01, 0x34, 0x01, 0x35,
    0x01, 0x36, 0x01, 0x37, 0x01, 0x38, 0x01, 0x39, 0x01, 0x3d, 0x01, 0x41,
    0x01, 0x5f, 0x01, 0x62, 0x01, 0x64, 0x01, 0x66, 0x01, 0x67, 0x01, 0x68,
    0x01, 0x6c, 0x01, 0x6d, 0x01, 0x6e, 0x01, 0x70, 0x01, 0x72, 0x01, 0x75,
    0x87, 0x30, 0x87, 0x31, 0x87, 0x32, 0x87, 0x61, 0x87, 0x63, 0x87, 0x65,
    0x87, 0x69, 0x87, 0x6f, 0x87, 0x73, 0x87, 0x74, 0x87, 0x20, 0x87, 0x25,
    0x87, 0x2d, 0x87, 0x2e, 0x87, 0x2f, 0x87, 0x33, 0x87, 0x34, 0x87, 0x35,
    0x87, 0x36, 0x87, 0x37, 0x87, 0x38, 0x87, 0x39, 0x87, 0x3d, 0x87, 0x41,
    0x87, 0x5f, 0x87, 0x62, 0x87, 0x64, 0x87, 0x66, 0x87, 0x67, 0x87, 0x68,
    0x87, 0x6c, 0x87, 0x6d, 0x87, 0x6e, 0x87, 0x70, 0x87, 0x72, 0x87, 0x75,
    0x89, 0x30, 0x89, 0x31, 0x89, 0x32, 0x89, 0x61, 0x89, 0x63, 0x89, 0x65,
    0x89, 0x69, 0x89, 0x6f, 0x89, 0x73, 0x89, 0x74, 0x89, 0x20, 0x89, 0x25,
    0x89, 0x2d, 0x89, 0x2e, 0x89, 0x2f, 0x89, 0x33, 0x89, 0x34, 0x89, 0x35,
    0x89, 0x36, 0x89, 0x37, 0x89, 0x38, 0x89, 0x39, 0x89, 0x3d, 0x89, 0x41,
    0x89, 0x5f, 0x89, 0x62, 0x89, 0x64, 0x89, 0x66, 0x89, 0x67, 0x89, 0x68,
    0x89, 0x6c, 0x89, 0x6d, 0x89, 0x6e, 0x89, 0x70, 0x89, 0x72, 0x89, 0x75,
    0x8a, 0x30, 0x8a, 0x31, 0x8a, 0x32, 0x8a, 0x61, 0x8a, 0x63, 0x8a, 0x65,
    0x8a, 0x69, 0x8a, 0x6f, 0x8a, 0x73, 0x8a, 0x74, 0x8a, 0x20, 0x8a, 0x25,
    0x8a, 0x2d, 0x8a, 0x2e, 0x8a, 0x2f, 0x8a, 0x33, 0x8a, 0x34, 0x8a, 0x35,
    0x8a, 0x36, 0x8a, 0x37, 0x8a, 0x38, 0x8a, 0x39, 0x8a, 0x3d, 0x8a, 0x41,
    0x8a, 0x5f, 0x8a, 0x62, 0x8a, 0x64, 0x8a, 0x66, 0x8a, 0x67, 0x8a, 0x68,
    0x8a, 0x6c, 0x8a, 0x6d, 0x8a, 0x6e, 0x8a, 0x70, 0x8a, 0x72, 0x8a, 0x75};
const uint16_t HuffDecoderCommon::table30_118_inner_[149] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0003, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2,
    0x02b2, 0x02c2, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332,
    0x0342, 0x0352, 0x0362, 0x0372, 0x0382, 0x0392, 0x03a2, 0x03b2, 0x03c2,
    0x03d2, 0x03e2, 0x03f2, 0x0402, 0x0412, 0x0422, 0x0432, 0x0442, 0x0452,
    0x0462, 0x0472, 0x0243, 0x0482, 0x0492, 0x04a2, 0x04b2, 0x04c2, 0x04d2,
    0x04e2, 0x04f2, 0x0502, 0x0512, 0x0522, 0x0532, 0x0542, 0x0552, 0x0562,
    0x0572, 0x0582, 0x0592, 0x05a2, 0x05b2, 0x05c2, 0x05d2, 0x05e2, 0x05f2,
    0x0602, 0x0612, 0x0622, 0x0632, 0x0642, 0x0652, 0x0662, 0x0672, 0x0682,
    0x0692, 0x06a2, 0x06b2, 0x0483, 0x06c2, 0x06d2, 0x06e2, 0x06f2, 0x0702,
    0x0712, 0x0722, 0x0732, 0x0742, 0x0752, 0x0762, 0x0772, 0x0782, 0x0792,
    0x07a2, 0x07b2, 0x07c2, 0x07d2, 0x07e2, 0x07f2, 0x0802, 0x0812, 0x0822,
    0x0832, 0x0842, 0x0852, 0x0862, 0x0872, 0x0882, 0x0892, 0x08a2, 0x08b2,
    0x08c2, 0x08d2, 0x08e2, 0x08f2, 0x06c3};
const uint8_t HuffDecoderCommon::table30_119_emit_[288] = {
    0x8b, 0x30, 0x8b, 0x31, 0x8b, 0x32, 0x8b, 0x61, 0x8b, 0x63, 0x8b, 0x65,
    0x8b, 0x69, 0x8b, 0x6f, 0x8b, 0x73, 0x8b, 0x74, 0x8b, 0x20, 0x8b, 0x25,
    0x8b, 0x2d, 0x8b, 0x2e, 0x8b, 0x2f, 0x8b, 0x33, 0x8b, 0x34, 0x8b, 0x35,
    0x8b, 0x36, 0x8b, 0x37, 0x8b, 0x38, 0x8b, 0x39, 0x8b, 0x3d, 0x8b, 0x41,
    0x8b, 0x5f, 0x8b, 0x62, 0x8b, 0x64, 0x8b, 0x66, 0x8b, 0x67, 0x8b, 0x68,
    0x8b, 0x6c, 0x8b, 0x6d, 0x8b, 0x6e, 0x8b, 0x70, 0x8b, 0x72, 0x8b, 0x75,
    0x8c, 0x30, 0x8c, 0x31, 0x8c, 0x32, 0x8c, 0x61, 0x8c, 0x63, 0x8c, 0x65,
    0x8c, 0x69, 0x8c, 0x6f, 0x8c, 0x73, 0x8c, 0x74, 0x8c, 0x20, 0x8c, 0x25,
    0x8c, 0x2d, 0x8c, 0x2e, 0x8c, 0x2f, 0x8c, 0x33, 0x8c, 0x34, 0x8c, 0x35,
    0x8c, 0x36, 0x8c, 0x37, 0x8c, 0x38, 0x8c, 0x39, 0x8c, 0x3d, 0x8c, 0x41,
    0x8c, 0x5f, 0x8c, 0x62, 0x8c, 0x64, 0x8c, 0x66, 0x8c, 0x67, 0x8c, 0x68,
    0x8c, 0x6c, 0x8c, 0x6d, 0x8c, 0x6e, 0x8c, 0x70, 0x8c, 0x72, 0x8c, 0x75,
    0x8d, 0x30, 0x8d, 0x31, 0x8d, 0x32, 0x8d, 0x61, 0x8d, 0x63, 0x8d, 0x65,
    0x8d, 0x69, 0x8d, 0x6f, 0x8d, 0x73, 0x8d, 0x74, 0x8d, 0x20, 0x8d, 0x25,
    0x8d, 0x2d, 0x8d, 0x2e, 0x8d, 0x2f, 0x8d, 0x33, 0x8d, 0x34, 0x8d, 0x35,
    0x8d, 0x36, 0x8d, 0x37, 0x8d, 0x38, 0x8d, 0x39, 0x8d, 0x3d, 0x8d, 0x41,
    0x8d, 0x5f, 0x8d, 0x62, 0x8d, 0x64, 0x8d, 0x66, 0x8d, 0x67, 0x8d, 0x68,
    0x8d, 0x6c, 0x8d, 0x6d, 0x8d, 0x6e, 0x8d, 0x70, 0x8d, 0x72, 0x8d, 0x75,
    0x8f, 0x30, 0x8f, 0x31, 0x8f, 0x32, 0x8f, 0x61, 0x8f, 0x63, 0x8f, 0x65,
    0x8f, 0x69, 0x8f, 0x6f, 0x8f, 0x73, 0x8f, 0x74, 0x8f, 0x20, 0x8f, 0x25,
    0x8f, 0x2d, 0x8f, 0x2e, 0x8f, 0x2f, 0x8f, 0x33, 0x8f, 0x34, 0x8f, 0x35,
    0x8f, 0x36, 0x8f, 0x37, 0x8f, 0x38, 0x8f, 0x39, 0x8f, 0x3d, 0x8f, 0x41,
    0x8f, 0x5f, 0x8f, 0x62, 0x8f, 0x64, 0x8f, 0x66, 0x8f, 0x67, 0x8f, 0x68,
    0x8f, 0x6c, 0x8f, 0x6d, 0x8f, 0x6e, 0x8f, 0x70, 0x8f, 0x72, 0x8f, 0x75};
const uint8_t HuffDecoderCommon::table30_120_emit_[288] = {
    0x93, 0x30, 0x93, 0x31, 0x93, 0x32, 0x93, 0x61, 0x93, 0x63, 0x93, 0x65,
    0x93, 0x69, 0x93, 0x6f, 0x93, 0x73, 0x93, 0x74, 0x93, 0x20, 0x93, 0x25,
    0x93, 0x2d, 0x93, 0x2e, 0x93, 0x2f, 0x93, 0x33, 0x93, 0x34, 0x93, 0x35,
    0x93, 0x36, 0x93, 0x37, 0x93, 0x38, 0x93, 0x39, 0x93, 0x3d, 0x93, 0x41,
    0x93, 0x5f, 0x93, 0x62, 0x93, 0x64, 0x93, 0x66, 0x93, 0x67, 0x93, 0x68,
    0x93, 0x6c, 0x93, 0x6d, 0x93, 0x6e, 0x93, 0x70, 0x93, 0x72, 0x93, 0x75,
    0x95, 0x30, 0x95, 0x31, 0x95, 0x32, 0x95, 0x61, 0x95, 0x63, 0x95, 0x65,
    0x95, 0x69, 0x95, 0x6f, 0x95, 0x73, 0x95, 0x74, 0x95, 0x20, 0x95, 0x25,
    0x95, 0x2d, 0x95, 0x2e, 0x95, 0x2f, 0x95, 0x33, 0x95, 0x34, 0x95, 0x35,
    0x95, 0x36, 0x95, 0x37, 0x95, 0x38, 0x95, 0x39, 0x95, 0x3d, 0x95, 0x41,
    0x95, 0x5f, 0x95, 0x62, 0x95, 0x64, 0x95, 0x66, 0x95, 0x67, 0x95, 0x68,
    0x95, 0x6c, 0x95, 0x6d, 0x95, 0x6e, 0x95, 0x70, 0x95, 0x72, 0x95, 0x75,
    0x96, 0x30, 0x96, 0x31, 0x96, 0x32, 0x96, 0x61, 0x96, 0x63, 0x96, 0x65,
    0x96, 0x69, 0x96, 0x6f, 0x96, 0x73, 0x96, 0x74, 0x96, 0x20, 0x96, 0x25,
    0x96, 0x2d, 0x96, 0x2e, 0x96, 0x2f, 0x96, 0x33, 0x96, 0x34, 0x96, 0x35,
    0x96, 0x36, 0x96, 0x37, 0x96, 0x38, 0x96, 0x39, 0x96, 0x3d, 0x96, 0x41,
    0x96, 0x5f, 0x96, 0x62, 0x96, 0x64, 0x96, 0x66, 0x96, 0x67, 0x96, 0x68,
    0x96, 0x6c, 0x96, 0x6d, 0x96, 0x6e, 0x96, 0x70, 0x96, 0x72, 0x96, 0x75,
    0x97, 0x30, 0x97, 0x31, 0x97, 0x32, 0x97, 0x61, 0x97, 0x63, 0x97, 0x65,
    0x97, 0x69, 0x97, 0x6f, 0x97, 0x73, 0x97, 0x74, 0x97, 0x20, 0x97, 0x25,
    0x97, 0x2d, 0x97, 0x2e, 0x97, 0x2f, 0x97, 0x33, 0x97, 0x34, 0x97, 0x35,
    0x97, 0x36, 0x97, 0x37, 0x97, 0x38, 0x97, 0x39, 0x97, 0x3d, 0x97, 0x41,
    0x97, 0x5f, 0x97, 0x62, 0x97, 0x64, 0x97, 0x66, 0x97, 0x67, 0x97, 0x68,
    0x97, 0x6c, 0x97, 0x6d, 0x97, 0x6e, 0x97, 0x70, 0x97, 0x72, 0x97, 0x75};
const uint8_t HuffDecoderCommon::table30_121_emit_[288] = {
    0x98, 0x30, 0x98, 0x31, 0x98, 0x32, 0x98, 0x61, 0x98, 0x63, 0x98, 0x65,
    0x98, 0x69, 0x98, 0x6f, 0x98, 0x73, 0x98, 0x74, 0x98, 0x20, 0x98, 0x25,
    0x98, 0x2d, 0x98, 0x2e, 0x98, 0x2f, 0x98, 0x33, 0x98, 0x34, 0x98, 0x35,
    0x98, 0x36, 0x98, 0x37, 0x98, 0x38, 0x98, 0x39, 0x98, 0x3d, 0x98, 0x41,
    0x98, 0x5f, 0x98, 0x62, 0x98, 0x64, 0x98, 0x66, 0x98, 0x67, 0x98, 0x68,
    0x98, 0x6c, 0x98, 0x6d, 0x98, 0x6e, 0x98, 0x70, 0x98, 0x72, 0x98, 0x75,
    0x9b, 0x30, 0x9b, 0x31, 0x9b, 0x32, 0x9b, 0x61, 0x9b, 0x63, 0x9b, 0x65,
    0x9b, 0x69, 0x9b, 0x6f, 0x9b, 0x73, 0x9b, 0x74, 0x9b, 0x20, 0x9b, 0x25,
    0x9b, 0x2d, 0x9b, 0x2e, 0x9b, 0x2f, 0x9b, 0x33, 0x9b, 0x34, 0x9b, 0x35,
    0x9b, 0x36, 0x9b, 0x37, 0x9b, 0x38, 0x9b, 0x39, 0x9b, 0x3d, 0x9b, 0x41,
    0x9b, 0x5f, 0x9b, 0x62, 0x9b, 0x64, 0x9b, 0x66, 0x9b, 0x67, 0x9b, 0x68,
    0x9b, 0x6c, 0x9b, 0x6d, 0x9b, 0x6e, 0x9b, 0x70, 0x9b, 0x72, 0x9b, 0x75,
    0x9d, 0x30, 0x9d, 0x31, 0x9d, 0x32, 0x9d, 0x61, 0x9d, 0x63, 0x9d, 0x65,
    0x9d, 0x69, 0x9d, 0x6f, 0x9d, 0x73, 0x9d, 0x74, 0x9d, 0x20, 0x9d, 0x25,
    0x9d, 0x2d, 0x9d, 0x2e, 0x9d, 0x2f, 0x9d, 0x33, 0x9d, 0x34, 0x9d, 0x35,
    0x9d, 0x36, 0x9d, 0x37, 0x9d, 0x38, 0x9d, 0x39, 0x9d, 0x3d, 0x9d, 0x41,
    0x9d, 0x5f, 0x9d, 0x62, 0x9d, 0x64, 0x9d, 0x66, 0x9d, 0x67, 0x9d, 0x68,
    0x9d, 0x6c, 0x9d, 0x6d, 0x9d, 0x6e, 0x9d, 0x70, 0x9d, 0x72, 0x9d, 0x75,
    0x9e, 0x30, 0x9e, 0x31, 0x9e, 0x32, 0x9e, 0x61, 0x9e, 0x63, 0x9e, 0x65,
    0x9e, 0x69, 0x9e, 0x6f, 0x9e, 0x73, 0x9e, 0x74, 0x9e, 0x20, 0x9e, 0x25,
    0x9e, 0x2d, 0x9e, 0x2e, 0x9e, 0x2f, 0x9e, 0x33, 0x9e, 0x34, 0x9e, 0x35,
    0x9e, 0x36, 0x9e, 0x37, 0x9e, 0x38, 0x9e, 0x39, 0x9e, 0x3d, 0x9e, 0x41,
    0x9e, 0x5f, 0x9e, 0x62, 0x9e, 0x64, 0x9e, 0x66, 0x9e, 0x67, 0x9e, 0x68,
    0x9e, 0x6c, 0x9e, 0x6d, 0x9e, 0x6e, 0x9e, 0x70, 0x9e, 0x72, 0x9e, 0x75};
const uint8_t HuffDecoderCommon::table30_122_emit_[288] = {
    0xa5, 0x30, 0xa5, 0x31, 0xa5, 0x32, 0xa5, 0x61, 0xa5, 0x63, 0xa5, 0x65,
    0xa5, 0x69, 0xa5, 0x6f, 0xa5, 0x73, 0xa5, 0x74, 0xa5, 0x20, 0xa5, 0x25,
    0xa5, 0x2d, 0xa5, 0x2e, 0xa5, 0x2f, 0xa5, 0x33, 0xa5, 0x34, 0xa5, 0x35,
    0xa5, 0x36, 0xa5, 0x37, 0xa5, 0x38, 0xa5, 0x39, 0xa5, 0x3d, 0xa5, 0x41,
    0xa5, 0x5f, 0xa5, 0x62, 0xa5, 0x64, 0xa5, 0x66, 0xa5, 0x67, 0xa5, 0x68,
    0xa5, 0x6c, 0xa5, 0x6d, 0xa5, 0x6e, 0xa5, 0x70, 0xa5, 0x72, 0xa5, 0x75,
    0xa6, 0x30, 0xa6, 0x31, 0xa6, 0x32, 0xa6, 0x61, 0xa6, 0x63, 0xa6, 0x65,
    0xa6, 0x69, 0xa6, 0x6f, 0xa6, 0x73, 0xa6, 0x74, 0xa6, 0x20, 0xa6, 0x25,
    0xa6, 0x2d, 0xa6, 0x2e, 0xa6, 0x2f, 0xa6, 0x33, 0xa6, 0x34, 0xa6, 0x35,
    0xa6, 0x36, 0xa6, 0x37, 0xa6, 0x38, 0xa6, 0x39, 0xa6, 0x3d, 0xa6, 0x41,
    0xa6, 0x5f, 0xa6, 0x62, 0xa6, 0x64, 0xa6, 0x66, 0xa6, 0x67, 0xa6, 0x68,
    0xa6, 0x6c, 0xa6, 0x6d, 0xa6, 0x6e, 0xa6, 0x70, 0xa6, 0x72, 0xa6, 0x75,
    0xa8, 0x30, 0xa8, 0x31, 0xa8, 0x32, 0xa8, 0x61, 0xa8, 0x63, 0xa8, 0x65,
    0xa8, 0x69, 0xa8, 0x6f, 0xa8, 0x73, 0xa8, 0x74, 0xa8, 0x20, 0xa8, 0x25,
    0xa8, 0x2d, 0xa8, 0x2e, 0xa8, 0x2f, 0xa8, 0x33, 0xa8, 0x34, 0xa8, 0x35,
    0xa8, 0x36, 0xa8, 0x37, 0xa8, 0x38, 0xa8, 0x39, 0xa8, 0x3d, 0xa8, 0x41,
    0xa8, 0x5f, 0xa8, 0x62, 0xa8, 0x64, 0xa8, 0x66, 0xa8, 0x67, 0xa8, 0x68,
    0xa8, 0x6c, 0xa8, 0x6d, 0xa8, 0x6e, 0xa8, 0x70, 0xa8, 0x72, 0xa8, 0x75,
    0xae, 0x30, 0xae, 0x31, 0xae, 0x32, 0xae, 0x61, 0xae, 0x63, 0xae, 0x65,
    0xae, 0x69, 0xae, 0x6f, 0xae, 0x73, 0xae, 0x74, 0xae, 0x20, 0xae, 0x25,
    0xae, 0x2d, 0xae, 0x2e, 0xae, 0x2f, 0xae, 0x33, 0xae, 0x34, 0xae, 0x35,
    0xae, 0x36, 0xae, 0x37, 0xae, 0x38, 0xae, 0x39, 0xae, 0x3d, 0xae, 0x41,
    0xae, 0x5f, 0xae, 0x62, 0xae, 0x64, 0xae, 0x66, 0xae, 0x67, 0xae, 0x68,
    0xae, 0x6c, 0xae, 0x6d, 0xae, 0x6e, 0xae, 0x70, 0xae, 0x72, 0xae, 0x75};
const uint8_t HuffDecoderCommon::table30_123_emit_[288] = {
    0xaf, 0x30, 0xaf, 0x31, 0xaf, 0x32, 0xaf, 0x61, 0xaf, 0x63, 0xaf, 0x65,
    0xaf, 0x69, 0xaf, 0x6f, 0xaf, 0x73, 0xaf, 0x74, 0xaf, 0x20, 0xaf, 0x25,
    0xaf, 0x2d, 0xaf, 0x2e, 0xaf, 0x2f, 0xaf, 0x33, 0xaf, 0x34, 0xaf, 0x35,
    0xaf, 0x36, 0xaf, 0x37, 0xaf, 0x38, 0xaf, 0x39, 0xaf, 0x3d, 0xaf, 0x41,
    0xaf, 0x5f, 0xaf, 0x62, 0xaf, 0x64, 0xaf, 0x66, 0xaf, 0x67, 0xaf, 0x68,
    0xaf, 0x6c, 0xaf, 0x6d, 0xaf, 0x6e, 0xaf, 0x70, 0xaf, 0x72, 0xaf, 0x75,
    0xb4, 0x30, 0xb4, 0x31, 0xb4, 0x32, 0xb4, 0x61, 0xb4, 0x63, 0xb4, 0x65,
    0xb4, 0x69, 0xb4, 0x6f, 0xb4, 0x73, 0xb4, 0x74, 0xb4, 0x20, 0xb4, 0x25,
    0xb4, 0x2d, 0xb4, 0x2e, 0xb4, 0x2f, 0xb4, 0x33, 0xb4, 0x34, 0xb4, 0x35,
    0xb4, 0x36, 0xb4, 0x37, 0xb4, 0x38, 0xb4, 0x39, 0xb4, 0x3d, 0xb4, 0x41,
    0xb4, 0x5f, 0xb4, 0x62, 0xb4, 0x64, 0xb4, 0x66, 0xb4, 0x67, 0xb4, 0x68,
    0xb4, 0x6c, 0xb4, 0x6d, 0xb4, 0x6e, 0xb4, 0x70, 0xb4, 0x72, 0xb4, 0x75,
    0xb6, 0x30, 0xb6, 0x31, 0xb6, 0x32, 0xb6, 0x61, 0xb6, 0x63, 0xb6, 0x65,
    0xb6, 0x69, 0xb6, 0x6f, 0xb6, 0x73, 0xb6, 0x74, 0xb6, 0x20, 0xb6, 0x25,
    0xb6, 0x2d, 0xb6, 0x2e, 0xb6, 0x2f, 0xb6, 0x33, 0xb6, 0x34, 0xb6, 0x35,
    0xb6, 0x36, 0xb6, 0x37, 0xb6, 0x38, 0xb6, 0x39, 0xb6, 0x3d, 0xb6, 0x41,
    0xb6, 0x5f, 0xb6, 0x62, 0xb6, 0x64, 0xb6, 0x66, 0xb6, 0x67, 0xb6, 0x68,
    0xb6, 0x6c, 0xb6, 0x6d, 0xb6, 0x6e, 0xb6, 0x70, 0xb6, 0x72, 0xb6, 0x75,
    0xb7, 0x30, 0xb7, 0x31, 0xb7, 0x32, 0xb7, 0x61, 0xb7, 0x63, 0xb7, 0x65,
    0xb7, 0x69, 0xb7, 0x6f, 0xb7, 0x73, 0xb7, 0x74, 0xb7, 0x20, 0xb7, 0x25,
    0xb7, 0x2d, 0xb7, 0x2e, 0xb7, 0x2f, 0xb7, 0x33, 0xb7, 0x34, 0xb7, 0x35,
    0xb7, 0x36, 0xb7, 0x37, 0xb7, 0x38, 0xb7, 0x39, 0xb7, 0x3d, 0xb7, 0x41,
    0xb7, 0x5f, 0xb7, 0x62, 0xb7, 0x64, 0xb7, 0x66, 0xb7, 0x67, 0xb7, 0x68,
    0xb7, 0x6c, 0xb7, 0x6d, 0xb7, 0x6e, 0xb7, 0x70, 0xb7, 0x72, 0xb7, 0x75};
const uint8_t HuffDecoderCommon::table30_124_emit_[288] = {
    0xbc, 0x30, 0xbc, 0x31, 0xbc, 0x32, 0xbc, 0x61, 0xbc, 0x63, 0xbc, 0x65,
    0xbc, 0x69, 0xbc, 0x6f, 0xbc, 0x73, 0xbc, 0x74, 0xbc, 0x20, 0xbc, 0x25,
    0xbc, 0x2d, 0xbc, 0x2e, 0xbc, 0x2f, 0xbc, 0x33, 0xbc, 0x34, 0xbc, 0x35,
    0xbc, 0x36, 0xbc, 0x37, 0xbc, 0x38, 0xbc, 0x39, 0xbc, 0x3d, 0xbc, 0x41,
    0xbc, 0x5f, 0xbc, 0x62, 0xbc, 0x64, 0xbc, 0x66, 0xbc, 0x67, 0xbc, 0x68,
    0xbc, 0x6c, 0xbc, 0x6d, 0xbc, 0x6e, 0xbc, 0x70, 0xbc, 0x72, 0xbc, 0x75,
    0xbf, 0x30, 0xbf, 0x31, 0xbf, 0x32, 0xbf, 0x61, 0xbf, 0x63, 0xbf, 0x65,
    0xbf, 0x69, 0xbf, 0x6f, 0xbf, 0x73, 0xbf, 0x74, 0xbf, 0x20, 0xbf, 0x25,
    0xbf, 0x2d, 0xbf, 0x2e, 0xbf, 0x2f, 0xbf, 0x33, 0xbf, 0x34, 0xbf, 0x35,
    0xbf, 0x36, 0xbf, 0x37, 0xbf, 0x38, 0xbf, 0x39, 0xbf, 0x3d, 0xbf, 0x41,
    0xbf, 0x5f, 0xbf, 0x62, 0xbf, 0x64, 0xbf, 0x66, 0xbf, 0x67, 0xbf, 0x68,
    0xbf, 0x6c, 0xbf, 0x6d, 0xbf, 0x6e, 0xbf, 0x70, 0xbf, 0x72, 0xbf, 0x75,
    0xc5, 0x30, 0xc5, 0x31, 0xc5, 0x32, 0xc5, 0x61, 0xc5, 0x63, 0xc5, 0x65,
    0xc5, 0x69, 0xc5, 0x6f, 0xc5, 0x73, 0xc5, 0x74, 0xc5, 0x20, 0xc5, 0x25,
    0xc5, 0x2d, 0xc5, 0x2e, 0xc5, 0x2f, 0xc5, 0x33, 0xc5, 0x34, 0xc5, 0x35,
    0xc5, 0x36, 0xc5, 0x37, 0xc5, 0x38, 0xc5, 0x39, 0xc5, 0x3d, 0xc5, 0x41,
    0xc5, 0x5f, 0xc5, 0x62, 0xc5, 0x64, 0xc5, 0x66, 0xc5, 0x67, 0xc5, 0x68,
    0xc5, 0x6c, 0xc5, 0x6d, 0xc5, 0x6e, 0xc5, 0x70, 0xc5, 0x72, 0xc5, 0x75,
    0xe7, 0x30, 0xe7, 0x31, 0xe7, 0x32, 0xe7, 0x61, 0xe7, 0x63, 0xe7, 0x65,
    0xe7, 0x69, 0xe7, 0x6f, 0xe7, 0x73, 0xe7, 0x74, 0xe7, 0x20, 0xe7, 0x25,
    0xe7, 0x2d, 0xe7, 0x2e, 0xe7, 0x2f, 0xe7, 0x33, 0xe7, 0x34, 0xe7, 0x35,
    0xe7, 0x36, 0xe7, 0x37, 0xe7, 0x38, 0xe7, 0x39, 0xe7, 0x3d, 0xe7, 0x41,
    0xe7, 0x5f, 0xe7, 0x62, 0xe7, 0x64, 0xe7, 0x66, 0xe7, 0x67, 0xe7, 0x68,
    0xe7, 0x6c, 0xe7, 0x6d, 0xe7, 0x6e, 0xe7, 0x70, 0xe7, 0x72, 0xe7, 0x75};
const uint8_t HuffDecoderCommon::table30_125_emit_[192] = {
    0xef, 0x30, 0xef, 0x31, 0xef, 0x32, 0xef, 0x61, 0xef, 0x63, 0xef, 0x65,
    0xef, 0x69, 0xef, 0x6f, 0xef, 0x73, 0xef, 0x74, 0xef, 0x20, 0xef, 0x25,
    0xef, 0x2d, 0xef, 0x2e, 0xef, 0x2f, 0xef, 0x33, 0xef, 0x34, 0xef, 0x35,
    0xef, 0x36, 0xef, 0x37, 0xef, 0x38, 0xef, 0x39, 0xef, 0x3d, 0xef, 0x41,
    0xef, 0x5f, 0xef, 0x62, 0xef, 0x64, 0xef, 0x66, 0xef, 0x67, 0xef, 0x68,
    0xef, 0x6c, 0xef, 0x6d, 0xef, 0x6e, 0xef, 0x70, 0xef, 0x72, 0xef, 0x75,
    0x09, 0x30, 0x09, 0x31, 0x09, 0x32, 0x09, 0x61, 0x09, 0x63, 0x09, 0x65,
    0x09, 0x69, 0x09, 0x6f, 0x09, 0x73, 0x09, 0x74, 0x8e, 0x30, 0x8e, 0x31,
    0x8e, 0x32, 0x8e, 0x61, 0x8e, 0x63, 0x8e, 0x65, 0x8e, 0x69, 0x8e, 0x6f,
    0x8e, 0x73, 0x8e, 0x74, 0x90, 0x30, 0x90, 0x31, 0x90, 0x32, 0x90, 0x61,
    0x90, 0x63, 0x90, 0x65, 0x90, 0x69, 0x90, 0x6f, 0x90, 0x73, 0x90, 0x74,
    0x91, 0x30, 0x91, 0x31, 0x91, 0x32, 0x91, 0x61, 0x91, 0x63, 0x91, 0x65,
    0x91, 0x69, 0x91, 0x6f, 0x91, 0x73, 0x91, 0x74, 0x94, 0x30, 0x94, 0x31,
    0x94, 0x32, 0x94, 0x61, 0x94, 0x63, 0x94, 0x65, 0x94, 0x69, 0x94, 0x6f,
    0x94, 0x73, 0x94, 0x74, 0x9f, 0x30, 0x9f, 0x31, 0x9f, 0x32, 0x9f, 0x61,
    0x9f, 0x63, 0x9f, 0x65, 0x9f, 0x69, 0x9f, 0x6f, 0x9f, 0x73, 0x9f, 0x74};
const uint16_t HuffDecoderCommon::table30_125_inner_[104] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0003, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2,
    0x02b2, 0x02c2, 0x02d2, 0x0243, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322,
    0x0332, 0x0342, 0x0352, 0x0362, 0x0372, 0x02e3, 0x0382, 0x0392, 0x03a2,
    0x03b2, 0x03c2, 0x03d2, 0x03e2, 0x03f2, 0x0402, 0x0412, 0x0383, 0x0422,
    0x0432, 0x0442, 0x0452, 0x0462, 0x0472, 0x0482, 0x0492, 0x04a2, 0x04b2,
    0x0423, 0x04c2, 0x04d2, 0x04e2, 0x04f2, 0x0502, 0x0512, 0x0522, 0x0532,
    0x0542, 0x0552, 0x04c3, 0x0562, 0x0572, 0x0582, 0x0592, 0x05a2, 0x05b2,
    0x05c2, 0x05d2, 0x05e2, 0x05f2, 0x0563};
const uint8_t HuffDecoderCommon::table30_125_outer_[256] = {
    0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,  0,  7,  0,  8,   0,   9,
    0,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,  25,  26,
    27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 0,  0,  0,  0,  0,  0,   0,   0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  37, 38, 39, 40, 41, 42, 43,  44,  45,
    46, 47, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,
    0,  0,  0,  0,  0,  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58,  0,   0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,
    0,  59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 0,  0,  0,  0,   0,   0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  70,  71,  72,
    73, 74, 75, 76, 77, 78, 79, 80, 0,  0,  0,  0,  0,  0,  0,  0,   0,   0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  81, 82, 83, 84, 85,  86,  87,
    88, 89, 90, 91, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,
    0,  0,  0,  0,  0,  0,  0,  92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,
    0,  0,  0,  103};
const uint8_t HuffDecoderCommon::table30_126_emit_[124] = {
    0xab, 0x30, 0xab, 0x31, 0xab, 0x32, 0xab, 0x61, 0xab, 0x63, 0xab, 0x65,
    0xab, 0x69, 0xab, 0x6f, 0xab, 0x73, 0xab, 0x74, 0xce, 0x30, 0xce, 0x31,
    0xce, 0x32, 0xce, 0x61, 0xce, 0x63, 0xce, 0x65, 0xce, 0x69, 0xce, 0x6f,
    0xce, 0x73, 0xce, 0x74, 0xd7, 0x30, 0xd7, 0x31, 0xd7, 0x32, 0xd7, 0x61,
    0xd7, 0x63, 0xd7, 0x65, 0xd7, 0x69, 0xd7, 0x6f, 0xd7, 0x73, 0xd7, 0x74,
    0xe1, 0x30, 0xe1, 0x31, 0xe1, 0x32, 0xe1, 0x61, 0xe1, 0x63, 0xe1, 0x65,
    0xe1, 0x69, 0xe1, 0x6f, 0xe1, 0x73, 0xe1, 0x74, 0xec, 0x30, 0xec, 0x31,
    0xec, 0x32, 0xec, 0x61, 0xec, 0x63, 0xec, 0x65, 0xec, 0x69, 0xec, 0x6f,
    0xec, 0x73, 0xec, 0x74, 0xed, 0x30, 0xed, 0x31, 0xed, 0x32, 0xed, 0x61,
    0xed, 0x63, 0xed, 0x65, 0xed, 0x69, 0xed, 0x6f, 0xed, 0x73, 0xed, 0x74,
    0xc7, 0xcf, 0xea, 0xeb};
const uint16_t HuffDecoderCommon::table30_126_inner_[71] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072, 0x0082,
    0x0092, 0x0000, 0x0003, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2,
    0x0102, 0x0112, 0x0122, 0x0132, 0x00a3, 0x0142, 0x0152, 0x0162, 0x0172,
    0x0182, 0x0192, 0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x0143, 0x01e2, 0x01f2,
    0x0202, 0x0212, 0x0222, 0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x01e3,
    0x0282, 0x0292, 0x02a2, 0x02b2, 0x02c2, 0x02d2, 0x02e2, 0x02f2, 0x0302,
    0x0312, 0x0283, 0x0322, 0x0332, 0x0342, 0x0352, 0x0362, 0x0372, 0x0382,
    0x0392, 0x03a2, 0x03b2, 0x0323, 0x03c3, 0x03cb, 0x03d3, 0x03db};
const uint8_t HuffDecoderCommon::table30_126_outer_[256] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 12, 13, 14, 15, 16, 17,
    18, 19, 20, 21, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 44, 45, 46, 47, 48, 49,
    50, 51, 52, 53, 54, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 66, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 67, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 68, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 69, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 70};
const uint8_t HuffDecoderCommon::table30_127_outer_[256] = {
    0, 0,  0, 0,  0, 0,  0, 1,  0, 0,  0, 0,  0, 0,  0, 2,  0, 0,  0, 0,  0, 0,
    0, 3,  0, 0,  0, 0,  0, 0,  0, 4,  0, 0,  0, 0,  0, 0,  0, 5,  0, 0,  0, 0,
    0, 0,  0, 6,  0, 0,  0, 0,  0, 0,  0, 7,  0, 0,  0, 0,  0, 0,  0, 8,  0, 0,
    0, 0,  0, 0,  0, 9,  0, 0,  0, 0,  0, 0,  0, 10, 0, 0,  0, 0,  0, 0,  0, 11,
    0, 0,  0, 0,  0, 0,  0, 12, 0, 0,  0, 0,  0, 0,  0, 13, 0, 0,  0, 0,  0, 0,
    0, 14, 0, 0,  0, 0,  0, 0,  0, 15, 0, 0,  0, 16, 0, 0,  0, 17, 0, 0,  0, 18,
    0, 0,  0, 19, 0, 0,  0, 20, 0, 0,  0, 21, 0, 0,  0, 22, 0, 0,  0, 23, 0, 0,
    0, 24, 0, 0,  0, 25, 0, 0,  0, 26, 0, 0,  0, 27, 0, 0,  0, 28, 0, 0,  0, 29,
    0, 0,  0, 30, 0, 0,  0, 31, 0, 0,  0, 32, 0, 0,  0, 33, 0, 0,  0, 34, 0, 35,
    0, 36, 0, 37, 0, 38, 0, 39, 0, 40, 0, 41, 0, 42, 0, 43, 0, 44, 0, 45, 0, 46,
    0, 47, 0, 48, 0, 49, 0, 50, 0, 51, 0, 52, 0, 53, 0, 54, 0, 55, 0, 56, 0, 57,
    0, 58, 0, 59, 0, 60, 0, 61, 0, 62, 0, 63, 0, 64};
const uint8_t* const HuffDecoderCommon::table30_emit_[128] = {
    table29_0_emit_,   table29_1_emit_,   table29_2_emit_,   table29_3_emit_,
    table29_4_emit_,   table29_5_emit_,   table29_6_emit_,   table29_7_emit_,
    table29_8_emit_,   table29_9_emit_,   table29_10_emit_,  table29_11_emit_,
    table29_12_emit_,  table29_13_emit_,  table29_14_emit_,  table29_15_emit_,
    table29_16_emit_,  table29_17_emit_,  table29_18_emit_,  table29_19_emit_,
    table30_20_emit_,  table30_21_emit_,  table30_22_emit_,  table30_23_emit_,
    table30_24_emit_,  table30_25_emit_,  table30_26_emit_,  table30_27_emit_,
    table30_28_emit_,  table30_29_emit_,  table30_30_emit_,  table30_31_emit_,
    table30_32_emit_,  table30_33_emit_,  table30_34_emit_,  table30_35_emit_,
    table30_36_emit_,  table30_37_emit_,  table30_38_emit_,  table30_39_emit_,
    table30_40_emit_,  table30_41_emit_,  table30_42_emit_,  table30_43_emit_,
    table30_44_emit_,  table30_45_emit_,  table30_46_emit_,  table30_47_emit_,
    table30_48_emit_,  table30_49_emit_,  table30_50_emit_,  table30_51_emit_,
    table30_52_emit_,  table30_53_emit_,  table30_54_emit_,  table30_55_emit_,
    table30_56_emit_,  table30_57_emit_,  table30_58_emit_,  table30_59_emit_,
    table30_60_emit_,  table30_61_emit_,  table30_62_emit_,  table30_63_emit_,
    table30_64_emit_,  table30_65_emit_,  table29_66_emit_,  table30_67_emit_,
    table30_68_emit_,  table30_69_emit_,  table29_70_emit_,  table30_71_emit_,
    table30_72_emit_,  table30_73_emit_,  table29_74_emit_,  table30_75_emit_,
    table29_76_emit_,  table29_77_emit_,  table29_78_emit_,  table29_79_emit_,
    table29_80_emit_,  table29_81_emit_,  table29_82_emit_,  table29_83_emit_,
    table29_84_emit_,  table29_85_emit_,  table29_86_emit_,  table29_87_emit_,
    table29_88_emit_,  table29_89_emit_,  table29_90_emit_,  table29_91_emit_,
    table30_92_emit_,  table30_93_emit_,  table30_94_emit_,  table30_95_emit_,
    table30_96_emit_,  table30_97_emit_,  table30_98_emit_,  table30_99_emit_,
    table30_100_emit_, table30_101_emit_, table30_102_emit_, table30_103_emit_,
    table30_104_emit_, table30_105_emit_, table30_106_emit_, table30_107_emit_,
    table30_108_emit_, table30_109_emit_, table30_110_emit_, table30_111_emit_,
    table30_112_emit_, table30_113_emit_, table30_114_emit_, table30_115_emit_,
    table30_116_emit_, table30_117_emit_, table30_118_emit_, table30_119_emit_,
    table30_120_emit_, table30_121_emit_, table30_122_emit_, table30_123_emit_,
    table30_124_emit_, table30_125_emit_, table30_126_emit_, table29_127_emit_,
};
const uint16_t* const HuffDecoderCommon::table30_inner_[128] = {
    table29_0_inner_,   table29_1_inner_,   table29_0_inner_,
    table29_1_inner_,   table29_0_inner_,   table29_1_inner_,
    table29_0_inner_,   table29_1_inner_,   table29_0_inner_,
    table29_1_inner_,   table29_0_inner_,   table29_1_inner_,
    table29_0_inner_,   table29_1_inner_,   table29_0_inner_,
    table29_1_inner_,   table29_0_inner_,   table29_1_inner_,
    table29_0_inner_,   table29_1_inner_,   table30_20_inner_,
    table30_20_inner_,  table30_20_inner_,  table30_20_inner_,
    table30_20_inner_,  table30_20_inner_,  table30_20_inner_,
    table30_20_inner_,  table30_20_inner_,  table30_20_inner_,
    table30_20_inner_,  table30_20_inner_,  table30_20_inner_,
    table30_20_inner_,  table30_20_inner_,  table30_20_inner_,
    table30_20_inner_,  table30_20_inner_,  table30_20_inner_,
    table30_20_inner_,  table30_20_inner_,  table30_20_inner_,
    table30_20_inner_,  table30_20_inner_,  table30_20_inner_,
    table30_20_inner_,  table30_46_inner_,  table30_46_inner_,
    table30_46_inner_,  table30_46_inner_,  table30_46_inner_,
    table30_46_inner_,  table30_46_inner_,  table30_46_inner_,
    table30_46_inner_,  table30_46_inner_,  table30_46_inner_,
    table30_46_inner_,  table30_46_inner_,  table30_46_inner_,
    table30_46_inner_,  table30_46_inner_,  table30_62_inner_,
    table30_63_inner_,  table30_64_inner_,  table30_65_inner_,
    table29_66_inner_,  table30_67_inner_,  table30_64_inner_,
    table30_65_inner_,  table29_66_inner_,  table30_67_inner_,
    table30_64_inner_,  table30_65_inner_,  table29_66_inner_,
    table30_67_inner_,  table29_76_inner_,  table29_77_inner_,
    table29_76_inner_,  table29_77_inner_,  table29_76_inner_,
    table29_77_inner_,  table29_76_inner_,  table29_77_inner_,
    table29_76_inner_,  table29_77_inner_,  table29_76_inner_,
    table29_77_inner_,  table29_76_inner_,  table29_77_inner_,
    table29_76_inner_,  table29_77_inner_,  table30_92_inner_,
    table30_92_inner_,  table30_92_inner_,  table30_92_inner_,
    table30_92_inner_,  table30_92_inner_,  table30_92_inner_,
    table30_92_inner_,  table30_92_inner_,  table30_92_inner_,
    table30_92_inner_,  table30_92_inner_,  table30_92_inner_,
    table30_105_inner_, table30_105_inner_, table30_105_inner_,
    table30_105_inner_, table30_105_inner_, table30_105_inner_,
    table30_105_inner_, table30_105_inner_, table30_105_inner_,
    table30_105_inner_, table30_105_inner_, table30_105_inner_,
    table30_105_inner_, table30_118_inner_, table30_118_inner_,
    table30_118_inner_, table30_118_inner_, table30_118_inner_,
    table30_118_inner_, table30_118_inner_, table30_125_inner_,
    table30_126_inner_, table29_127_inner_,
};
const uint8_t* const HuffDecoderCommon::table30_outer_[128] = {
    table30_0_outer_,   table30_1_outer_,   table30_0_outer_,
    table30_1_outer_,   table30_0_outer_,   table30_1_outer_,
    table30_0_outer_,   table30_1_outer_,   table30_0_outer_,
    table30_1_outer_,   table30_0_outer_,   table30_1_outer_,
    table30_0_outer_,   table30_1_outer_,   table30_0_outer_,
    table30_1_outer_,   table30_0_outer_,   table30_1_outer_,
    table30_0_outer_,   table30_1_outer_,   table30_20_outer_,
    table30_20_outer_,  table30_20_outer_,  table30_20_outer_,
    table30_20_outer_,  table30_20_outer_,  table30_20_outer_,
    table30_20_outer_,  table30_20_outer_,  table30_20_outer_,
    table30_20_outer_,  table30_20_outer_,  table30_20_outer_,
    table30_20_outer_,  table30_20_outer_,  table30_20_outer_,
    table30_20_outer_,  table30_20_outer_,  table30_20_outer_,
    table30_20_outer_,  table30_20_outer_,  table30_20_outer_,
    table30_20_outer_,  table30_20_outer_,  table30_20_outer_,
    table30_20_outer_,  table30_46_outer_,  table30_46_outer_,
    table30_46_outer_,  table30_46_outer_,  table30_46_outer_,
    table30_46_outer_,  table30_46_outer_,  table30_46_outer_,
    table30_46_outer_,  table30_46_outer_,  table30_46_outer_,
    table30_46_outer_,  table30_46_outer_,  table30_46_outer_,
    table30_46_outer_,  table30_46_outer_,  table30_62_outer_,
    table30_63_outer_,  table30_64_outer_,  table30_65_outer_,
    table30_66_outer_,  table30_67_outer_,  table30_64_outer_,
    table30_65_outer_,  table30_66_outer_,  table30_67_outer_,
    table30_64_outer_,  table30_65_outer_,  table30_66_outer_,
    table30_67_outer_,  table30_0_outer_,   table30_1_outer_,
    table30_0_outer_,   table30_1_outer_,   table30_0_outer_,
    table30_1_outer_,   table30_0_outer_,   table30_1_outer_,
    table30_0_outer_,   table30_1_outer_,   table30_0_outer_,
    table30_1_outer_,   table30_0_outer_,   table30_1_outer_,
    table30_0_outer_,   table30_1_outer_,   table30_20_outer_,
    table30_20_outer_,  table30_20_outer_,  table30_20_outer_,
    table30_20_outer_,  table30_20_outer_,  table30_20_outer_,
    table30_20_outer_,  table30_20_outer_,  table30_20_outer_,
    table30_20_outer_,  table30_20_outer_,  table30_20_outer_,
    table30_46_outer_,  table30_46_outer_,  table30_46_outer_,
    table30_46_outer_,  table30_46_outer_,  table30_46_outer_,
    table30_46_outer_,  table30_46_outer_,  table30_46_outer_,
    table30_46_outer_,  table30_46_outer_,  table30_46_outer_,
    table30_46_outer_,  table30_62_outer_,  table30_62_outer_,
    table30_62_outer_,  table30_62_outer_,  table30_62_outer_,
    table30_62_outer_,  table30_62_outer_,  table30_125_outer_,
    table30_126_outer_, table30_127_outer_,
};
const uint8_t HuffDecoderCommon::table15_0_emit_[1] = {0x7b};
const uint16_t HuffDecoderCommon::table15_0_ops_[512] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001};
const uint8_t HuffDecoderCommon::table15_64_emit_[1] = {0x5c};
const uint16_t HuffDecoderCommon::table15_64_ops_[512] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005};
const uint8_t HuffDecoderCommon::table15_68_emit_[1] = {0xc3};
const uint8_t HuffDecoderCommon::table15_72_emit_[1] = {0xd0};
const uint8_t HuffDecoderCommon::table15_76_emit_[1] = {0x80};
const uint16_t HuffDecoderCommon::table15_76_ops_[512] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006};
const uint8_t HuffDecoderCommon::table15_78_emit_[1] = {0x82};
const uint8_t HuffDecoderCommon::table15_80_emit_[1] = {0x83};
const uint8_t HuffDecoderCommon::table15_82_emit_[1] = {0xa2};
const uint8_t HuffDecoderCommon::table15_84_emit_[1] = {0xb8};
const uint8_t HuffDecoderCommon::table15_86_emit_[1] = {0xc2};
const uint8_t HuffDecoderCommon::table15_88_emit_[1] = {0xe0};
const uint8_t HuffDecoderCommon::table15_90_emit_[1] = {0xe2};
const uint8_t HuffDecoderCommon::table15_92_emit_[1] = {0x99};
const uint16_t HuffDecoderCommon::table15_92_ops_[512] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007};
const uint8_t HuffDecoderCommon::table15_93_emit_[1] = {0xa1};
const uint8_t HuffDecoderCommon::table15_94_emit_[1] = {0xa7};
const uint8_t HuffDecoderCommon::table15_95_emit_[1] = {0xac};
const uint8_t HuffDecoderCommon::table15_96_emit_[1] = {0xb0};
const uint8_t HuffDecoderCommon::table15_97_emit_[1] = {0xb1};
const uint8_t HuffDecoderCommon::table15_98_emit_[1] = {0xb3};
const uint8_t HuffDecoderCommon::table15_99_emit_[1] = {0xd1};
const uint8_t HuffDecoderCommon::table15_100_emit_[1] = {0xd8};
const uint8_t HuffDecoderCommon::table15_101_emit_[1] = {0xd9};
const uint8_t HuffDecoderCommon::table15_102_emit_[1] = {0xe3};
const uint8_t HuffDecoderCommon::table15_103_emit_[1] = {0xe5};
const uint8_t HuffDecoderCommon::table15_104_emit_[1] = {0xe6};
const uint8_t HuffDecoderCommon::table15_105_emit_[2] = {0x81, 0x84};
const uint16_t HuffDecoderCommon::table15_105_ops_[512] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048};
const uint8_t HuffDecoderCommon::table15_106_emit_[2] = {0x85, 0x86};
const uint8_t HuffDecoderCommon::table15_107_emit_[2] = {0x88, 0x92};
const uint8_t HuffDecoderCommon::table15_108_emit_[2] = {0x9a, 0x9c};
const uint8_t HuffDecoderCommon::table15_109_emit_[2] = {0xa0, 0xa3};
const uint8_t HuffDecoderCommon::table15_110_emit_[2] = {0xa4, 0xa9};
const uint8_t HuffDecoderCommon::table15_111_emit_[2] = {0xaa, 0xad};
const uint8_t HuffDecoderCommon::table15_112_emit_[2] = {0xb2, 0xb5};
const uint8_t HuffDecoderCommon::table15_113_emit_[2] = {0xb9, 0xba};
const uint8_t HuffDecoderCommon::table15_114_emit_[2] = {0xbb, 0xbd};
const uint8_t HuffDecoderCommon::table15_115_emit_[2] = {0xbe, 0xc4};
const uint8_t HuffDecoderCommon::table15_116_emit_[2] = {0xc6, 0xe4};
const uint8_t HuffDecoderCommon::table15_117_emit_[2] = {0xe8, 0xe9};
const uint8_t HuffDecoderCommon::table15_118_emit_[4] = {0x01, 0x87, 0x89,
                                                         0x8a};
const uint16_t HuffDecoderCommon::table15_118_ops_[512] = {
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9};
const uint8_t HuffDecoderCommon::table15_119_emit_[4] = {0x8b, 0x8c, 0x8d,
                                                         0x8f};
const uint8_t HuffDecoderCommon::table15_120_emit_[4] = {0x93, 0x95, 0x96,
                                                         0x97};
const uint8_t HuffDecoderCommon::table15_121_emit_[4] = {0x98, 0x9b, 0x9d,
                                                         0x9e};
const uint8_t HuffDecoderCommon::table15_122_emit_[4] = {0xa5, 0xa6, 0xa8,
                                                         0xae};
const uint8_t HuffDecoderCommon::table15_123_emit_[4] = {0xaf, 0xb4, 0xb6,
                                                         0xb7};
const uint8_t HuffDecoderCommon::table15_124_emit_[4] = {0xbc, 0xbf, 0xc5,
                                                         0xe7};
const uint8_t HuffDecoderCommon::table15_125_emit_[7] = {0xef, 0x09, 0x8e, 0x90,
                                                         0x91, 0x94, 0x9f};
const uint16_t HuffDecoderCommon::table15_125_ops_[512] = {
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x018a, 0x018a,
    0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a,
    0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a,
    0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a,
    0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a,
    0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a,
    0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a,
    0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a};
const uint16_t HuffDecoderCommon::table15_126_ops_[512] = {
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
    0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
    0x000a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
    0x004a, 0x004a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
    0x008a, 0x008a, 0x008a, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x014a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x018b, 0x018b, 0x018b,
    0x018b, 0x018b, 0x018b, 0x018b, 0x018b, 0x018b, 0x018b, 0x018b, 0x018b,
    0x018b, 0x018b, 0x018b, 0x018b, 0x018b, 0x018b, 0x018b, 0x018b, 0x018b,
    0x018b, 0x018b, 0x018b, 0x018b, 0x018b, 0x018b, 0x018b, 0x018b, 0x018b,
    0x018b, 0x018b, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb,
    0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb,
    0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb,
    0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x020b, 0x020b,
    0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b,
    0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b,
    0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b, 0x020b,
    0x020b, 0x020b, 0x020b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b,
    0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b,
    0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b,
    0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b, 0x024b};
const uint8_t HuffDecoderCommon::table15_127_emit_[66] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee,
    0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde,
    0xdf, 0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd,
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0b, 0x0c, 0x0e,
    0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18, 0x19, 0x1a,
    0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9, 0x0a, 0x0d, 0x16};
const uint16_t HuffDecoderCommon::table15_127_ops_[512] = {
    0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
    0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x004c, 0x004c,
    0x004c, 0x004c, 0x004c, 0x004c, 0x004c, 0x004c, 0x004c, 0x004c, 0x004c,
    0x004c, 0x004c, 0x004c, 0x004c, 0x004c, 0x008c, 0x008c, 0x008c, 0x008c,
    0x008c, 0x008c, 0x008c, 0x008c, 0x008c, 0x008c, 0x008c, 0x008c, 0x008c,
    0x008c, 0x008c, 0x008c, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc,
    0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc,
    0x00cc, 0x010c, 0x010c, 0x010c, 0x010c, 0x010c, 0x010c, 0x010c, 0x010c,
    0x010c, 0x010c, 0x010c, 0x010c, 0x010c, 0x010c, 0x010c, 0x010c, 0x014c,
    0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x014c,
    0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x018c, 0x018c, 0x018c,
    0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c,
    0x018c, 0x018c, 0x018c, 0x018c, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc,
    0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc,
    0x01cc, 0x01cc, 0x020c, 0x020c, 0x020c, 0x020c, 0x020c, 0x020c, 0x020c,
    0x020c, 0x020c, 0x020c, 0x020c, 0x020c, 0x020c, 0x020c, 0x020c, 0x020c,
    0x024c, 0x024c, 0x024c, 0x024c, 0x024c, 0x024c, 0x024c, 0x024c, 0x024c,
    0x024c, 0x024c, 0x024c, 0x024c, 0x024c, 0x024c, 0x024c, 0x028c, 0x028c,
    0x028c, 0x028c, 0x028c, 0x028c, 0x028c, 0x028c, 0x028c, 0x028c, 0x028c,
    0x028c, 0x028c, 0x028c, 0x028c, 0x028c, 0x02cc, 0x02cc, 0x02cc, 0x02cc,
    0x02cc, 0x02cc, 0x02cc, 0x02cc, 0x02cc, 0x02cc, 0x02cc, 0x02cc, 0x02cc,
    0x02cc, 0x02cc, 0x02cc, 0x030c, 0x030c, 0x030c, 0x030c, 0x030c, 0x030c,
    0x030c, 0x030c, 0x030c, 0x030c, 0x030c, 0x030c, 0x030c, 0x030c, 0x030c,
    0x030c, 0x034c, 0x034c, 0x034c, 0x034c, 0x034c, 0x034c, 0x034c, 0x034c,
    0x034c, 0x034c, 0x034c, 0x034c, 0x034c, 0x034c, 0x034c, 0x034c, 0x038c,
    0x038c, 0x038c, 0x038c, 0x038c, 0x038c, 0x038c, 0x038c, 0x038c, 0x038c,
    0x038c, 0x038c, 0x038c, 0x038c, 0x038c, 0x038c, 0x03cd, 0x03cd, 0x03cd,
    0x03cd, 0x03cd, 0x03cd, 0x03cd, 0x03cd, 0x040d, 0x040d, 0x040d, 0x040d,
    0x040d, 0x040d, 0x040d, 0x040d, 0x044d, 0x044d, 0x044d, 0x044d, 0x044d,
    0x044d, 0x044d, 0x044d, 0x048d, 0x048d, 0x048d, 0x048d, 0x048d, 0x048d,
    0x048d, 0x048d, 0x04cd, 0x04cd, 0x04cd, 0x04cd, 0x04cd, 0x04cd, 0x04cd,
    0x04cd, 0x050d, 0x050d, 0x050d, 0x050d, 0x050d, 0x050d, 0x050d, 0x050d,
    0x054d, 0x054d, 0x054d, 0x054d, 0x054d, 0x054d, 0x054d, 0x054d, 0x058d,
    0x058d, 0x058d, 0x058d, 0x058d, 0x058d, 0x058d, 0x058d, 0x05cd, 0x05cd,
    0x05cd, 0x05cd, 0x05cd, 0x05cd, 0x05cd, 0x05cd, 0x060d, 0x060d, 0x060d,
    0x060d, 0x060d, 0x060d, 0x060d, 0x060d, 0x064d, 0x064d, 0x064d, 0x064d,
    0x064d, 0x064d, 0x064d, 0x064d, 0x068d, 0x068d, 0x068d, 0x068d, 0x068d,
    0x068d, 0x068d, 0x068d, 0x06cd, 0x06cd, 0x06cd, 0x06cd, 0x06cd, 0x06cd,
    0x06cd, 0x06cd, 0x070d, 0x070d, 0x070d, 0x070d, 0x070d, 0x070d, 0x070d,
    0x070d, 0x074d, 0x074d, 0x074d, 0x074d, 0x074d, 0x074d, 0x074d, 0x074d,
    0x078d, 0x078d, 0x078d, 0x078d, 0x078d, 0x078d, 0x078d, 0x078d, 0x07cd,
    0x07cd, 0x07cd, 0x07cd, 0x07cd, 0x07cd, 0x07cd, 0x07cd, 0x080d, 0x080d,
    0x080d, 0x080d, 0x080d, 0x080d, 0x080d, 0x080d, 0x084d, 0x084d, 0x084d,
    0x084d, 0x084d, 0x084d, 0x084d, 0x084d, 0x088e, 0x088e, 0x088e, 0x088e,
    0x08ce, 0x08ce, 0x08ce, 0x08ce, 0x090e, 0x090e, 0x090e, 0x090e, 0x094e,
    0x094e, 0x094e, 0x094e, 0x098e, 0x098e, 0x098e, 0x098e, 0x09ce, 0x09ce,
    0x09ce, 0x09ce, 0x0a0e, 0x0a0e, 0x0a0e, 0x0a0e, 0x0a4e, 0x0a4e, 0x0a4e,
    0x0a4e, 0x0a8e, 0x0a8e, 0x0a8e, 0x0a8e, 0x0ace, 0x0ace, 0x0ace, 0x0ace,
    0x0b0e, 0x0b0e, 0x0b0e, 0x0b0e, 0x0b4e, 0x0b4e, 0x0b4e, 0x0b4e, 0x0b8e,
    0x0b8e, 0x0b8e, 0x0b8e, 0x0bce, 0x0bce, 0x0bce, 0x0bce, 0x0c0e, 0x0c0e,
    0x0c0e, 0x0c0e, 0x0c4e, 0x0c4e, 0x0c4e, 0x0c4e, 0x0c8e, 0x0c8e, 0x0c8e,
    0x0c8e, 0x0cce, 0x0cce, 0x0cce, 0x0cce, 0x0d0e, 0x0d0e, 0x0d0e, 0x0d0e,
    0x0d4e, 0x0d4e, 0x0d4e, 0x0d4e, 0x0d8e, 0x0d8e, 0x0d8e, 0x0d8e, 0x0dce,
    0x0dce, 0x0dce, 0x0dce, 0x0e0e, 0x0e0e, 0x0e0e, 0x0e0e, 0x0e4e, 0x0e4e,
    0x0e4e, 0x0e4e, 0x0e8e, 0x0e8e, 0x0e8e, 0x0e8e, 0x0ece, 0x0ece, 0x0ece,
    0x0ece, 0x0f0e, 0x0f0e, 0x0f0e, 0x0f0e, 0x0f4e, 0x0f4e, 0x0f4e, 0x0f4e,
    0x0f8e, 0x0f8e, 0x0f8e, 0x0f8e, 0x0fd0, 0x1010, 0x1050, 0x0030};
const uint8_t* const HuffDecoderCommon::table15_emit_[128] = {
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_0_emit_,   table15_0_emit_,   table15_0_emit_,   table15_0_emit_,
    table15_64_emit_,  table15_64_emit_,  table15_64_emit_,  table15_64_emit_,
    table15_68_emit_,  table15_68_emit_,  table15_68_emit_,  table15_68_emit_,
    table15_72_emit_,  table15_72_emit_,  table15_72_emit_,  table15_72_emit_,
    table15_76_emit_,  table15_76_emit_,  table15_78_emit_,  table15_78_emit_,
    table15_80_emit_,  table15_80_emit_,  table15_82_emit_,  table15_82_emit_,
    table15_84_emit_,  table15_84_emit_,  table15_86_emit_,  table15_86_emit_,
    table15_88_emit_,  table15_88_emit_,  table15_90_emit_,  table15_90_emit_,
    table15_92_emit_,  table15_93_emit_,  table15_94_emit_,  table15_95_emit_,
    table15_96_emit_,  table15_97_emit_,  table15_98_emit_,  table15_99_emit_,
    table15_100_emit_, table15_101_emit_, table15_102_emit_, table15_103_emit_,
    table15_104_emit_, table15_105_emit_, table15_106_emit_, table15_107_emit_,
    table15_108_emit_, table15_109_emit_, table15_110_emit_, table15_111_emit_,
    table15_112_emit_, table15_113_emit_, table15_114_emit_, table15_115_emit_,
    table15_116_emit_, table15_117_emit_, table15_118_emit_, table15_119_emit_,
    table15_120_emit_, table15_121_emit_, table15_122_emit_, table15_123_emit_,
    table15_124_emit_, table15_125_emit_, table29_126_emit_, table15_127_emit_,
};
const uint16_t* const HuffDecoderCommon::table15_ops_[128] = {
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_0_ops_,   table15_0_ops_,   table15_0_ops_,   table15_0_ops_,
    table15_64_ops_,  table15_64_ops_,  table15_64_ops_,  table15_64_ops_,
    table15_64_ops_,  table15_64_ops_,  table15_64_ops_,  table15_64_ops_,
    table15_64_ops_,  table15_64_ops_,  table15_64_ops_,  table15_64_ops_,
    table15_76_ops_,  table15_76_ops_,  table15_76_ops_,  table15_76_ops_,
    table15_76_ops_,  table15_76_ops_,  table15_76_ops_,  table15_76_ops_,
    table15_76_ops_,  table15_76_ops_,  table15_76_ops_,  table15_76_ops_,
    table15_76_ops_,  table15_76_ops_,  table15_76_ops_,  table15_76_ops_,
    table15_92_ops_,  table15_92_ops_,  table15_92_ops_,  table15_92_ops_,
    table15_92_ops_,  table15_92_ops_,  table15_92_ops_,  table15_92_ops_,
    table15_92_ops_,  table15_92_ops_,  table15_92_ops_,  table15_92_ops_,
    table15_92_ops_,  table15_105_ops_, table15_105_ops_, table15_105_ops_,
    table15_105_ops_, table15_105_ops_, table15_105_ops_, table15_105_ops_,
    table15_105_ops_, table15_105_ops_, table15_105_ops_, table15_105_ops_,
    table15_105_ops_, table15_105_ops_, table15_118_ops_, table15_118_ops_,
    table15_118_ops_, table15_118_ops_, table15_118_ops_, table15_118_ops_,
    table15_118_ops_, table15_125_ops_, table15_126_ops_, table15_127_ops_,
};
}  // namespace geometry_9_5_16
}  // namespace grpc_core
