# Linking with the HELICS Library

Once HELICS is built or installed it needs to be integrated into a project.

## Language bindings

If the project is in Python, Matlab, Java, C#, Octave, or Julia, the language binding specific to that language is the best bet.

## C based project

The C based shared library is the way to go. Either link with libhelics.lib/so/dylib and add the include helics.h or link the CMake target HELICS\::helics.

## C\++98 or C\++03 or C\++11 of C\++14

Then linking with the C shared library and using the C++98 header only wrapper is the most appropriate choice. The CMake target HELICS\::helicsCpp98 can be used if using CMake.

## C\++17

If you are using C\++17 and can install or generate the C\++ shared library and make sure they are built with identical compilations configurations it is possible to link with the C++ shared library generated by HELICS. This can provide a richer interface and potentially slightly faster interaction.
This can be done in a couple ways. If the project is CMake based then HELICS will install a configuration file that generates the targets for the HELICS\::helicscpp library with the appropriate information for linking, this is the simplest approach. Unlike the C shared library, the C++ shared library requires the importing program to have the same compilation libraries since the library does not export std library symbols, or other symbols defined solely in header files, so those must have the same interpretation inside and out of the library for this to work. If some of the extensions available in the helics\::apps are needed then the HELICS\::helicscpp-apps target is also appropriate.

If you are not using CMake then link against the libhelicscpp.lib/so/dylib as appropriate for the operating system and include the headers directory. Also advisable (though not strictly necessary is to define HELICS_SHARED_LIBRARY as part of the compilation before including some headers). The apps library is `libhelicscpp-apps.lib/so/dylib` and the corresponding dll/so/dylib should be installed on the system path, or in the same directory for Windows, or added to the RPATH of the binary you're compiling on other (non-Windows) operating systems.

If you are using CMake and building HELICS as part of the project and want to use static libraries or use the apps library as a static library then HELICS supports building as a CMake subproject and linking the targets HELICS\::apps or HELICS::application-api.

## Troubleshooting shared library errors on Windows

If you encounter an error along the lines of `DLL load failed: The specified module could not be found` when attempting to use the C shared library, it is likely a required system dependency is missing. You can determine which DLL it is unable to find using a tool like <https://github.com/lucasg/Dependencies> to show which dependencies were not found when attempting to open the helics C shared library DLL. It is fine if it shows it can't find `WS2_32.dll`, but all other DLLs should be found.
The most likely to be missing is `vcruntime140_1.dll`, which can be fixed by downloading the latest Visual C++ Redistributable from <https://support.microsoft.com/en-us/help/2977003/the-latest-supported-visual-c-downloads> and installing it.

## Summary

- For Python(2,3), Java, Matlab, C#, Octave, Julia - use the defined interface
- For C use the C shared library
- For most C++ use the C\++98 Wrapper to the C shared library
- For C\++17 in common build configurations use the C shared library or the C++ shared library from the installers or build it yourself to ensure library compatibility.
- For specific C++ applications desiring static builds and using CMake, use HELICS as a subproject in CMake (the main use is some helics extensions, but other applications can use it as well)
- For specific C++ applications with particular build considerations or flags use HELICS as a subproject and link the static or shared C++ Libraries.

- For other languages - work with swig or use the foreign language capabilities of the language to import the C shared library.
