/*
Copyright (c) 2017-2024,
Battelle Memorial Institute; Lawrence Livermore National Security, LLC; Alliance for Sustainable
Energy, LLC.  See the top-level NOTICE for additional details. All rights reserved.
SPDX-License-Identifier: BSD-3-Clause
*/

#include <gtest/gtest.h>
/** these test cases test out the value converters
 */
#include "ctestFixtures.hpp"

TEST(prop_tests, intprops)
{
    EXPECT_EQ(helicsGetPropertyIndex("max_iterations"), HELICS_PROPERTY_INT_MAX_ITERATIONS);
    EXPECT_EQ(helicsGetPropertyIndex("MAX_ITERATIONS"), HELICS_PROPERTY_INT_MAX_ITERATIONS);
    EXPECT_EQ(helicsGetPropertyIndex("INT_MAX_ITERATIONS"), HELICS_PROPERTY_INT_MAX_ITERATIONS);

    EXPECT_EQ(helicsGetPropertyIndex("log_level"), HELICS_PROPERTY_INT_LOG_LEVEL);
    EXPECT_EQ(helicsGetPropertyIndex("LOG_LEVEL"), HELICS_PROPERTY_INT_LOG_LEVEL);
    EXPECT_EQ(helicsGetPropertyIndex("INT_LOG_LEVEL"), HELICS_PROPERTY_INT_LOG_LEVEL);

    EXPECT_EQ(helicsGetPropertyIndex("file_log_level"), HELICS_PROPERTY_INT_FILE_LOG_LEVEL);
    EXPECT_EQ(helicsGetPropertyIndex("FILE_LOG_LEVEL"), HELICS_PROPERTY_INT_FILE_LOG_LEVEL);
    EXPECT_EQ(helicsGetPropertyIndex("INT_FILE_LOG_LEVEL"), HELICS_PROPERTY_INT_FILE_LOG_LEVEL);

    EXPECT_EQ(helicsGetPropertyIndex("console_log_level"), HELICS_PROPERTY_INT_CONSOLE_LOG_LEVEL);
    EXPECT_EQ(helicsGetPropertyIndex("CONSOLE_LOG_LEVEL"), HELICS_PROPERTY_INT_CONSOLE_LOG_LEVEL);
    EXPECT_EQ(helicsGetPropertyIndex("INT_CONSOLE_LOG_LEVEL"),
              HELICS_PROPERTY_INT_CONSOLE_LOG_LEVEL);
}

TEST(prop_tests, timeprops)
{
    EXPECT_EQ(helicsGetPropertyIndex("DELTA"), HELICS_PROPERTY_TIME_DELTA);
    EXPECT_EQ(helicsGetPropertyIndex("TIME_DELTA"), HELICS_PROPERTY_TIME_DELTA);
    EXPECT_EQ(helicsGetPropertyIndex("timedelta"), HELICS_PROPERTY_TIME_DELTA);

    EXPECT_EQ(helicsGetPropertyIndex("PERIOD"), HELICS_PROPERTY_TIME_PERIOD);
    EXPECT_EQ(helicsGetPropertyIndex("TIME_PERIOD"), HELICS_PROPERTY_TIME_PERIOD);
    EXPECT_EQ(helicsGetPropertyIndex("timeperiod"), HELICS_PROPERTY_TIME_PERIOD);

    EXPECT_EQ(helicsGetPropertyIndex("OFFSET"), HELICS_PROPERTY_TIME_OFFSET);
    EXPECT_EQ(helicsGetPropertyIndex("TIME_OFFSET"), HELICS_PROPERTY_TIME_OFFSET);
    EXPECT_EQ(helicsGetPropertyIndex("timeoffset"), HELICS_PROPERTY_TIME_OFFSET);

    EXPECT_EQ(helicsGetPropertyIndex("RT_LAG"), HELICS_PROPERTY_TIME_RT_LAG);
    EXPECT_EQ(helicsGetPropertyIndex("TIME_RT_LAG"), HELICS_PROPERTY_TIME_RT_LAG);
    EXPECT_EQ(helicsGetPropertyIndex("rtlag"), HELICS_PROPERTY_TIME_RT_LAG);

    EXPECT_EQ(helicsGetPropertyIndex("RT_LEAD"), HELICS_PROPERTY_TIME_RT_LEAD);
    EXPECT_EQ(helicsGetPropertyIndex("TIME_RT_LEAD"), HELICS_PROPERTY_TIME_RT_LEAD);
    EXPECT_EQ(helicsGetPropertyIndex("rtlead"), HELICS_PROPERTY_TIME_RT_LEAD);

    EXPECT_EQ(helicsGetPropertyIndex("RT_TOLERANCE"), HELICS_PROPERTY_TIME_RT_TOLERANCE);
    EXPECT_EQ(helicsGetPropertyIndex("TIME_RT_TOLERANCE"), HELICS_PROPERTY_TIME_RT_TOLERANCE);
    EXPECT_EQ(helicsGetPropertyIndex("rttolerance"), HELICS_PROPERTY_TIME_RT_TOLERANCE);

    EXPECT_EQ(helicsGetPropertyIndex("input_delay"), HELICS_PROPERTY_TIME_INPUT_DELAY);
    EXPECT_EQ(helicsGetPropertyIndex("TIME_INPUT_DELAY"), HELICS_PROPERTY_TIME_INPUT_DELAY);
    EXPECT_EQ(helicsGetPropertyIndex("INPUT_DELAY"), HELICS_PROPERTY_TIME_INPUT_DELAY);

    EXPECT_EQ(helicsGetPropertyIndex("output_delay"), HELICS_PROPERTY_TIME_OUTPUT_DELAY);
    EXPECT_EQ(helicsGetPropertyIndex("TIME_OUTPUT_DELAY"), HELICS_PROPERTY_TIME_OUTPUT_DELAY);
    EXPECT_EQ(helicsGetPropertyIndex("OUTPUT_DELAY"), HELICS_PROPERTY_TIME_OUTPUT_DELAY);
}

TEST(prop_tests, flagprops)
{
    EXPECT_EQ(helicsGetFlagIndex("OBSERVER"), HELICS_FLAG_OBSERVER);
    EXPECT_EQ(helicsGetFlagIndex("UNINTERRUPTIBLE"), HELICS_FLAG_UNINTERRUPTIBLE);
    EXPECT_EQ(helicsGetFlagIndex("INTERRUPTIBLE"), HELICS_FLAG_INTERRUPTIBLE);
    EXPECT_EQ(helicsGetFlagIndex("DELAY_INIT_ENTRY"), HELICS_FLAG_DELAY_INIT_ENTRY);
    EXPECT_EQ(helicsGetFlagIndex("ENABLE_INIT_ENTRY"), HELICS_FLAG_ENABLE_INIT_ENTRY);
    EXPECT_EQ(helicsGetFlagIndex("IGNORE_TIME_MISMATCH_WARNINGS"),
              HELICS_FLAG_IGNORE_TIME_MISMATCH_WARNINGS);
    EXPECT_EQ(helicsGetFlagIndex("SOURCE_ONLY"), HELICS_FLAG_SOURCE_ONLY);
    EXPECT_EQ(helicsGetFlagIndex("ONLY_TRANSMIT_ON_CHANGE"), HELICS_FLAG_ONLY_TRANSMIT_ON_CHANGE);
    EXPECT_EQ(helicsGetFlagIndex("ONLY_UPDATE_ON_CHANGE"), HELICS_FLAG_ONLY_UPDATE_ON_CHANGE);
    EXPECT_EQ(helicsGetFlagIndex("WAIT_FOR_CURRENT_TIME_UPDATE"),
              HELICS_FLAG_WAIT_FOR_CURRENT_TIME_UPDATE);
    EXPECT_EQ(helicsGetFlagIndex("RESTRICTIVE_TIME_POLICY"), HELICS_FLAG_RESTRICTIVE_TIME_POLICY);
    EXPECT_EQ(helicsGetFlagIndex("ROLLBACK"), HELICS_FLAG_ROLLBACK);
    EXPECT_EQ(helicsGetFlagIndex("FORWARD_COMPUTE"), HELICS_FLAG_FORWARD_COMPUTE);
    EXPECT_EQ(helicsGetFlagIndex("REALTIME"), HELICS_FLAG_REALTIME);
    EXPECT_EQ(helicsGetFlagIndex("SINGLE_THREAD_FEDERATE"), HELICS_FLAG_SINGLE_THREAD_FEDERATE);
    EXPECT_EQ(helicsGetFlagIndex("SLOW_RESPONDING"), HELICS_FLAG_SLOW_RESPONDING);
    EXPECT_EQ(helicsGetFlagIndex("TERMINATE_ON_ERROR"), HELICS_FLAG_TERMINATE_ON_ERROR);
    EXPECT_EQ(helicsGetFlagIndex("STRICT_CONFIG_CHECKING"), HELICS_FLAG_STRICT_CONFIG_CHECKING);
    EXPECT_EQ(helicsGetFlagIndex("FORCE_LOGGING_FLUSH"), HELICS_FLAG_FORCE_LOGGING_FLUSH);
    EXPECT_EQ(helicsGetFlagIndex("DUMPLOG"), HELICS_FLAG_DUMPLOG);
    EXPECT_EQ(helicsGetFlagIndex("LOCAL_PROFILING_CAPTURE"), HELICS_FLAG_LOCAL_PROFILING_CAPTURE);
    EXPECT_EQ(helicsGetFlagIndex("PROFILING"), HELICS_FLAG_PROFILING);
    EXPECT_EQ(helicsGetFlagIndex("PROFILING_MARKER"), HELICS_FLAG_PROFILING_MARKER);
    EXPECT_EQ(helicsGetFlagIndex("USE_JSON_SERIALIZATION"), HELICS_FLAG_USE_JSON_SERIALIZATION);
}
