///////////////////////////////////////////////////////////////////////////////
//                                                         
// SigTest.cc
// -------------
// signal handler class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 1996 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////



// #include <iostream.h>

#include "../src/Exception.h"
#include "../src/Chain.h"
#include "../src/SigHandler.h"
#include "../src/Process.h"

#include <unistd.h>
#include <stdlib.h>

int numCheck = 3;
int checkCount;

class MySig : public SigHandler
{
  
public:

    MySig() : SigHandler() {
	
   
	init();
	install(SIGINT);
	// install(SIGPIPE);
   	
    };
    
    void sigCatch(int sig) {
	
	try {
	    install(SIGINT);
	    // install(SIGPIPE);
	    
	    cout << "ok " << checkCount << " - catched signal " << sig << endl;
	    checkCount++;
	    
	    return;
	}
	catch ( Exception e)
	{
	    Chain msg;
	    e.pop(msg);
	    cout << "not ok " << checkCount << " - " << msg << endl;
	    checkCount++;
	}
	
    };
	    
private:
    
};


int main(int argc, char **argv)
{


    checkCount=1;
    
    try
    {
	
	cout << "1.." << numCheck << endl;

	MySig s1;
		
	int i=0;
	while (checkCount <= numCheck ) // s1.isTerminated() == false)
	{
	    	    
	    i++;
	    sleep(1);

#ifdef HAVE_MINGW
	    cout << "ok " << checkCount << " - signal test ignored " << endl;
	    checkCount++;
#else	    
	    Process p;
	    p.kill(SIGINT);
#endif	    
	}

	
      
    }
    catch (Exception e)
    {
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;

}

