///////////////////////////////////////////////////////////////////////////////
//                                                         
// SleeperTest.cc
// -------------
// sleeper class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2017 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/Sleeper.h"

#include <stdlib.h>
#include <unistd.h>

int main(int argc, char **argv)
{

    int numCheck = 4;
    int checkCount = 1;
    
    try
    {

	cout << "1.." << numCheck << endl;
	
	Sleeper::secSleep(1);	
	cout << "ok " << checkCount << " - Sleep 1sec " << endl;
	checkCount++;

	Sleeper::milliSleep(100);
	cout << "ok " << checkCount << " - Sleep 100msec " << endl;
	checkCount++;

	Sleeper::microSleep(1000);
	cout << "ok " << checkCount << " - Sleep 1000usec " << endl;
	checkCount++;

	Sleeper::nanoSleep(1000);	
	cout << "ok " << checkCount << " - Sleep 1000nsec " << endl;
	checkCount++;

    }
    catch (Exception e)
    {
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;

}

