///////////////////////////////////////////////////////////////////////////////
//                                                         
// Host.cc
// -------
// Host class implementation
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: Host
//
// Description: Hostname utility class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#ifdef HAVE_MINGW
#include <winsock2.h>
static boolean wsaCalled = false;
#endif

// SYSTEM INCLUDES
#include <unistd.h>

// BASE INCLUDES
#include "Exception.h"
#include "Chain.h"

#include "Host.h"

#define MAX_HOSTNAMELEN 100

Host::Host()
{
#ifdef HAVE_MINGW
    if ( wsaCalled == false )
    {
	WSADATA wsa;
	long rc;
	rc = WSAStartup(MAKEWORD(2,0), &wsa);
	wsaCalled = true;
    }
#endif
}

Host::~Host()
{
}

Chain Host::getName() const
{
    char buf[MAX_HOSTNAMELEN];

    if ( ::gethostname(buf, MAX_HOSTNAMELEN) == -1 )
	throw Exception(EXLOC, "gethostname system error");
    
    return Chain(buf);
}
