/* Generated by re2c 3.1 on Wed Jan 31 00:27:35 2024 */
#line 1 "parser/tokenizer.re"
#include <limits>

#include <lfortran/parser/parser_exception.h>
#include <lfortran/parser/tokenizer.h>
#include <lfortran/parser/parser.tab.hh>
#include <libasr/bigint.h>

namespace LCompilers::LFortran {

void Tokenizer::set_string(const std::string &str)
{
    // The input string must be NULL terminated, otherwise the tokenizer will
    // not detect the end of string. After C++11, the std::string is guaranteed
    // to end with \0, but we check this here just in case.
    LCOMPILERS_ASSERT(str[str.size()] == '\0');
    cur = (unsigned char *)(&str[0]);
    string_start = cur;
    cur_line = cur;
    line_num = 1;
}

template<int base>
bool adddgt(uint64_t &u, uint64_t d)
{
    if (u > (std::numeric_limits<uint64_t>::max() - d) / base) {
        return false;
    }
    u = u * base + d;
    return true;
}

bool lex_dec(const unsigned char *s, const unsigned char *e, uint64_t &u)
{
    for (u = 0; s < e; ++s) {
        if (!adddgt<10>(u, *s - 0x30u)) {
            return false;
        }
    }
    return true;
}

// Tokenizes integer of the kind 1234_ikind into `u` and `suffix`
// s ... the start of the integer
// e ... the character after the end
bool lex_int(const unsigned char *s, const unsigned char *e, uint64_t &u,
    Str &suffix)
{
    for (u = 0; s < e; ++s) {
        if (*s == '_') {
            s++;
            suffix.p = (char*) s;
            suffix.n = e-s;
            return true;
        } else if (!adddgt<10>(u, *s - 0x30u)) {
            return false;
        }
    }
    suffix.p = nullptr;
    suffix.n = 0;
    return true;
}

void lex_int_large(Allocator &al, const unsigned char *s,
    const unsigned char *e, BigInt::BigInt &u, Str &suffix)
{
    uint64_t ui;
    if (lex_int(s, e, ui, suffix)) {
        if (ui <= BigInt::MAX_SMALL_INT) {
            u.from_smallint(ui);
            return;
        }
    }
    const unsigned char *start = s;
    for (; s < e; ++s) {
        if (*s == '_') {
            s++;
            suffix.p = (char*) s;
            suffix.n = e-s;

            Str num;
            num.p = (char*)start;
            num.n = s-start-1;
            u.from_largeint(al, num);
            return;
        }
    }
    suffix.p = nullptr;
    suffix.n = 0;
    Str num;
    num.p = (char*)start;
    num.n = e-start;
    u.from_largeint(al, num);
}

uint64_t parse_int(const unsigned char *s)
{
    while (*s == ' ') s++;
    uint64_t u;
    for (u = 0; ; ++s) {
        if (*s >= '0' && *s <= '9') {
            if (!adddgt<10>(u, *s - 0x30u)) {
                return false;
            }
        } else {
            return u;
        }
    }
}

#define KW(x) token(yylval.string); RET(KW_##x);
#define RET(x) token_loc(loc); last_token=yytokentype::x; return yytokentype::x;
#define WARN_REL(x) add_rel_warning(diagnostics, fixed_form, yytokentype::TK_##x);

void Tokenizer::add_rel_warning(diag::Diagnostics &diagnostics, bool fixed_form, int rel_token) const {
    if (!fixed_form) {
        static const std::map<int, std::pair<std::string, std::string>> m = {
            {yytokentype::TK_EQ, {"==", ".eq."}},
            {yytokentype::TK_NE, {"/=", ".ne."}},
            {yytokentype::TK_LT, {"<",  ".lt."}},
            {yytokentype::TK_GT, {">",  ".gt."}},
            {yytokentype::TK_LE, {"<=", ".le."}},
            {yytokentype::TK_GE, {">=", ".ge."}},
        };
        const std::string rel_new = m.at(rel_token).first;
        const std::string rel_old = m.at(rel_token).second;
        Location loc;
        token_loc(loc);
        diagnostics.tokenizer_style_label(
            "Use '" + rel_new + "' instead of '" + rel_old + "'",
            {loc},
            "help: write this as '" + rel_new + "'");
    }
}

int Tokenizer::lex(Allocator &al, YYSTYPE &yylval, Location &loc, diag::Diagnostics &diagnostics)
{
    if (enddo_state == 1) {
        enddo_state = 2;
        KW(END_DO)
    } else if (enddo_state == 2) {
        enddo_insert_count--;
        if (enddo_insert_count > 0) {
            enddo_state = 1;
        } else {
            enddo_state = 0;
            token_loc(loc); line_num++; cur_line=cur;
            last_token = yytokentype::TK_NEWLINE;
        }
        return yytokentype::TK_NEWLINE;
    }
    for (;;) {
        tok = cur;

        /*
        Re2c has excellent documentation at:

        https://re2c.org/manual/manual_c.html

        The first paragraph there explains the basics:

        * If multiple rules match, the longest match takes precedence
        * If multiple rules match the same string, the earlier rule takes
          precedence
        * Default rule `*` should always be defined, it has the lowest priority
          regardless of its place and matches any code unit
        * We use the "Sentinel character" method for end of input:
            * The end of the input text is denoted with a null character \x00
            * Thus the null character cannot be part of the input otherwise
            * There is one rule to match \x00 to end the parser
            * No other rule is allowed to match \x00, otherwise the re2c block
              would parse past the end of the string and segfaults
            * A special case of the previous point are negated character
              ranges, such as [^"\x00], where one must include \x00 in it to
              ensure this rule does not match \x00 (all other rules simply do
              not mention \x00)
            * See the "Handling the end of input" section in the re2c
              documentation for more info

        The re2c block interacts with the rest of the code via just one pointer
        variable `cur`. On entering the re2c block, the `cur` variable must
        point to the first character of the token to be tokenized by the block.
        The re2c block below then executes on its own until a rule is matched:
        the action in {} is then executed. In that action `cur` points to the
        first character of the next token.

        Before the re2c block we save the current `cur` into `tok`, so that we
        can use `tok` and `cur` in the action in {} to extract the token that
        corresponds to the rule that got matched:

        * `tok` points to the first character of the token
        * `cur-1` points to the last character of the token
        * `cur` points to the first character of the next token
        * `cur-tok` is the length of the token

        In the action, we do one of:

        * call `continue` which executes another cycle in the for loop (which
          will parse the next token); we use this to skip a token
        * call `return` which returns from this function; we return a token
        * throw an exception (terminates the tokenizer)

        In the first two cases, `cur` points to first character of the next
        token, which becomes `tok` at the next iteration of the loop (either
        right away after `continue` or after the `lex` function is called again
        after `return`).

        See the manual for more details.
        */


        // These two variables are needed by the re2c block below internally,
        // initialization is not needed. One can think of them as local
        // variables of the re2c block.
        unsigned char *mar, *ctxmar;
        
#line 219 "parser/tokenizer.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		/* table 1 .. 8: 0 */
		  0,   2,   2,   2,   2,   2,   2,   2, 
		  2,   3,   3,   3,   2,   3,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  3,   2,   2,   2,   2,   2,   2,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		242, 242, 210, 210, 210, 210, 210, 210, 
		146, 146,   2,   2,   2,   2,   2,   2, 
		  2, 150, 150, 150, 150, 150, 150,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,   2,   2,   2,   2,  26, 
		  2, 150, 150, 150, 150, 150, 150,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		/* table 9 .. 13: 256 */
		  0, 192, 192, 192, 192, 192, 192, 192, 
		192, 200, 128, 200, 192, 200, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		200, 192,  64, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		240, 240, 240, 240, 240, 240, 240, 240, 
		240, 240, 192, 192, 192, 192, 192, 192, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 192, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
	};
	yych = *cur;
	if (yybm[256+yych] & 8) {
		goto yy4;
	}
	switch (yych) {
		case 0x00: goto yy1;
		case '\t':
		case '\n': goto yy5;
		case ' ':
		case '!': goto yy6;
		case '"': goto yy7;
		case '#': goto yy8;
		case '%': goto yy9;
		case '&': goto yy10;
		case '\'': goto yy11;
		case '(': goto yy12;
		case ')': goto yy13;
		case '*': goto yy14;
		case '+': goto yy15;
		case ',': goto yy16;
		case '-': goto yy17;
		case '.': goto yy18;
		case '/': goto yy19;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy20;
		case ':': goto yy22;
		case ';': goto yy23;
		case '<': goto yy24;
		case '=': goto yy25;
		case '>': goto yy27;
		case 'A':
		case 'a': goto yy28;
		case 'B':
		case 'b': goto yy30;
		case 'C':
		case 'c': goto yy31;
		case 'D':
		case 'd': goto yy32;
		case 'E':
		case 'e': goto yy33;
		case 'F':
		case 'f': goto yy34;
		case 'G':
		case 'g': goto yy35;
		case 'H':
		case 'J':
		case 'X':
		case 'Y':
		case '_':
		case 'h':
		case 'j':
		case 'x':
		case 'y': goto yy36;
		case 'I':
		case 'i': goto yy38;
		case 'K':
		case 'k': goto yy39;
		case 'L':
		case 'l': goto yy40;
		case 'M':
		case 'm': goto yy41;
		case 'N':
		case 'n': goto yy42;
		case 'O':
		case 'o': goto yy43;
		case 'P':
		case 'p': goto yy44;
		case 'Q':
		case 'q': goto yy45;
		case 'R':
		case 'r': goto yy46;
		case 'S':
		case 's': goto yy47;
		case 'T':
		case 't': goto yy48;
		case 'U':
		case 'u': goto yy49;
		case 'V':
		case 'v': goto yy50;
		case 'W':
		case 'w': goto yy51;
		case 'Z':
		case 'z': goto yy52;
		case '[': goto yy53;
		case ']': goto yy55;
		case '{': goto yy56;
		case '|': goto yy57;
		case '}': goto yy58;
		default: goto yy2;
	}
yy1:
	++cur;
#line 249 "parser/tokenizer.re"
	{ RET(END_OF_FILE); }
#line 393 "parser/tokenizer.cpp"
yy2:
	++cur;
yy3:
#line 240 "parser/tokenizer.re"
	{ token_loc(loc);
                std::string t = token();
                throw parser_local::TokenizerError(diag::Diagnostic(
                    "Token '" + t + "' is not recognized",
                    diag::Level::Error, diag::Stage::Tokenizer, {
                        diag::Label("token not recognized", {loc})
                    })
                );
            }
#line 407 "parser/tokenizer.cpp"
yy4:
	yych = *++cur;
	if (yybm[256+yych] & 8) {
		goto yy4;
	}
#line 250 "parser/tokenizer.re"
	{ continue; }
#line 415 "parser/tokenizer.cpp"
yy5:
	++cur;
#line 506 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    enddo_newline_process = false;
                    enddo_state = 1;
                    return yytokentype::TK_NEWLINE;
                } else {
                    enddo_newline_process = false;
                    enddo_insert_count = 0;
                    token_loc(loc); line_num++; cur_line=cur;
                    last_token = yytokentype::TK_NEWLINE;
                    return yytokentype::TK_NEWLINE;
                }
            }
#line 432 "parser/tokenizer.cpp"
yy6:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	if (yych == 'L') goto yy63;
	goto yy60;
yy7:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy65;
yy8:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy68;
yy9:
	++cur;
#line 541 "parser/tokenizer.re"
	{ RET(TK_PERCENT) }
#line 453 "parser/tokenizer.cpp"
yy10:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy3;
		if (yych <= '\v') goto yy70;
		goto yy3;
	} else {
		if (yych <= '\r') goto yy70;
		if (yych <= 0x1F) goto yy3;
		if (yych <= '!') goto yy70;
		goto yy3;
	}
yy11:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy75;
yy12:
	yych = *++cur;
	if (yych == '/') {
		ctxmar = cur;
		goto yy77;
	}
#line 521 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 480 "parser/tokenizer.cpp"
yy13:
	++cur;
#line 529 "parser/tokenizer.re"
	{ RET(TK_RPAREN) }
#line 485 "parser/tokenizer.cpp"
yy14:
	yych = *++cur;
	if (yych == '*') goto yy78;
#line 543 "parser/tokenizer.re"
	{ RET(TK_STAR) }
#line 491 "parser/tokenizer.cpp"
yy15:
	++cur;
#line 535 "parser/tokenizer.re"
	{ RET(TK_PLUS) }
#line 496 "parser/tokenizer.cpp"
yy16:
	++cur;
#line 542 "parser/tokenizer.re"
	{ RET(TK_COMMA) }
#line 501 "parser/tokenizer.cpp"
yy17:
	++cur;
#line 536 "parser/tokenizer.re"
	{ RET(TK_MINUS) }
#line 506 "parser/tokenizer.cpp"
yy18:
	yyaccept = 0;
	yych = *(mar = ++cur);
	switch (yych) {
		case '.': goto yy79;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy80;
		case 'A':
		case 'a': goto yy83;
		case 'B':
		case 'C':
		case 'D':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'Y':
		case 'Z':
		case 'b':
		case 'c':
		case 'd':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'y':
		case 'z': goto yy84;
		case 'E':
		case 'e': goto yy86;
		case 'F':
		case 'f': goto yy87;
		case 'G':
		case 'g': goto yy88;
		case 'L':
		case 'l': goto yy89;
		case 'N':
		case 'n': goto yy90;
		case 'O':
		case 'o': goto yy91;
		case 'T':
		case 't': goto yy92;
		case 'X':
		case 'x': goto yy93;
		default: goto yy3;
	}
yy19:
	yych = *++cur;
	if (yych <= '.') {
		if (yych == ')') goto yy94;
	} else {
		if (yych <= '/') goto yy95;
		if (yych == '=') goto yy96;
	}
#line 540 "parser/tokenizer.re"
	{ RET(TK_SLASH) }
#line 586 "parser/tokenizer.cpp"
yy20:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yybm[256+yych] & 16) {
		goto yy20;
	}
	if (yych <= ' ') {
		if (yych <= '\v') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy97;
			}
			if (yych >= '\v') {
				ctxmar = cur;
				goto yy97;
			}
		} else {
			if (yych == '\r') {
				ctxmar = cur;
				goto yy97;
			}
			if (yych >= ' ') {
				ctxmar = cur;
				goto yy97;
			}
		}
	} else {
		if (yych <= 'E') {
			if (yych == '.') {
				ctxmar = cur;
				goto yy98;
			}
			if (yych >= 'D') goto yy99;
		} else {
			if (yych <= '_') {
				if (yych >= '_') goto yy100;
			} else {
				if (yych <= 'c') goto yy21;
				if (yych <= 'e') goto yy99;
			}
		}
	}
yy21:
#line 628 "parser/tokenizer.re"
	{
                lex_int_large(al, tok, cur,
                    yylval.int_suffix.int_n,
                    yylval.int_suffix.int_kind);
                RET(TK_INTEGER)
            }
#line 637 "parser/tokenizer.cpp"
yy22:
	yych = *++cur;
	if (yych == ':') goto yy101;
#line 538 "parser/tokenizer.re"
	{ RET(TK_COLON) }
#line 643 "parser/tokenizer.cpp"
yy23:
	++cur;
#line 539 "parser/tokenizer.re"
	{ RET(TK_SEMICOLON) }
#line 648 "parser/tokenizer.cpp"
yy24:
	yych = *++cur;
	if (yych == '=') goto yy102;
#line 560 "parser/tokenizer.re"
	{ RET(TK_LT) }
#line 654 "parser/tokenizer.cpp"
yy25:
	yych = *++cur;
	if (yych <= '<') goto yy26;
	if (yych <= '=') goto yy103;
	if (yych <= '>') goto yy104;
yy26:
#line 537 "parser/tokenizer.re"
	{ RET(TK_EQUAL) }
#line 663 "parser/tokenizer.cpp"
yy27:
	yych = *++cur;
	if (yych == '=') goto yy105;
#line 566 "parser/tokenizer.re"
	{ RET(TK_GT) }
#line 669 "parser/tokenizer.cpp"
yy28:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'K') {
			if (yych == 'B') goto yy106;
			goto yy37;
		} else {
			if (yych <= 'L') goto yy107;
			if (yych <= 'R') goto yy37;
			goto yy108;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'b') goto yy106;
			goto yy37;
		} else {
			if (yych <= 'l') goto yy107;
			if (yych == 's') goto yy108;
			goto yy37;
		}
	}
yy29:
#line 678 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_NAME) }
#line 694 "parser/tokenizer.cpp"
yy30:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'I') {
		if (yych <= '\'') {
			if (yych == '"') goto yy110;
			if (yych <= '&') goto yy37;
			goto yy111;
		} else {
			if (yych == 'A') goto yy112;
			if (yych <= 'H') goto yy37;
			goto yy113;
		}
	} else {
		if (yych <= 'a') {
			if (yych == 'L') goto yy114;
			if (yych <= '`') goto yy37;
			goto yy112;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy37;
				goto yy113;
			} else {
				if (yych == 'l') goto yy114;
				goto yy37;
			}
		}
	}
yy31:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy115;
		case 'H':
		case 'h': goto yy116;
		case 'L':
		case 'l': goto yy117;
		case 'O':
		case 'o': goto yy118;
		case 'R':
		case 'r': goto yy119;
		case 'Y':
		case 'y': goto yy120;
		default: goto yy37;
	}
yy32:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych <= 'E') {
			if (yych == 'A') goto yy121;
			if (yych <= 'D') goto yy37;
			goto yy122;
		} else {
			if (yych == 'I') goto yy123;
			if (yych <= 'N') goto yy37;
			goto yy124;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'a') goto yy121;
			if (yych <= 'd') goto yy37;
			goto yy122;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy37;
				goto yy123;
			} else {
				if (yych == 'o') goto yy124;
				goto yy37;
			}
		}
	}
yy33:
	yych = *++cur;
	switch (yych) {
		case 'L':
		case 'l': goto yy126;
		case 'N':
		case 'n': goto yy127;
		case 'Q':
		case 'q': goto yy128;
		case 'R':
		case 'r': goto yy129;
		case 'V':
		case 'v': goto yy130;
		case 'X':
		case 'x': goto yy131;
		default: goto yy37;
	}
yy34:
	yych = *++cur;
	switch (yych) {
		case 'I':
		case 'i': goto yy132;
		case 'L':
		case 'l': goto yy133;
		case 'O':
		case 'o': goto yy134;
		case 'U':
		case 'u': goto yy135;
		default: goto yy37;
	}
yy35:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy136;
		if (yych <= 'N') goto yy37;
		goto yy137;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy136;
		} else {
			if (yych == 'o') goto yy137;
			goto yy37;
		}
	}
yy36:
	yych = *++cur;
yy37:
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
	goto yy29;
yy38:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'L') {
			if (yych == 'F') goto yy139;
			goto yy37;
		} else {
			if (yych <= 'M') goto yy140;
			if (yych <= 'N') goto yy141;
			if (yych <= 'R') goto yy37;
			goto yy143;
		}
	} else {
		if (yych <= 'm') {
			if (yych == 'f') goto yy139;
			if (yych <= 'l') goto yy37;
			goto yy140;
		} else {
			if (yych <= 'n') goto yy141;
			if (yych == 's') goto yy143;
			goto yy37;
		}
	}
yy39:
	yych = *++cur;
	if (yych == 'I') goto yy144;
	if (yych == 'i') goto yy144;
	goto yy37;
yy40:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy145;
		if (yych <= 'N') goto yy37;
		goto yy146;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy145;
		} else {
			if (yych == 'o') goto yy146;
			goto yy37;
		}
	}
yy41:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy147;
		if (yych <= 'N') goto yy37;
		goto yy148;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy147;
		} else {
			if (yych == 'o') goto yy148;
			goto yy37;
		}
	}
yy42:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'E') {
			if (yych == 'A') goto yy149;
			if (yych <= 'D') goto yy37;
			goto yy150;
		} else {
			if (yych == 'O') goto yy151;
			if (yych <= 'T') goto yy37;
			goto yy152;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'a') goto yy149;
			if (yych <= 'd') goto yy37;
			goto yy150;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy37;
				goto yy151;
			} else {
				if (yych == 'u') goto yy152;
				goto yy37;
			}
		}
	}
yy43:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'P') {
		if (yych <= '\'') {
			if (yych == '"') goto yy153;
			if (yych <= '&') goto yy37;
			goto yy154;
		} else {
			if (yych == 'N') goto yy155;
			if (yych <= 'O') goto yy37;
			goto yy156;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'U') goto yy157;
			if (yych <= 'm') goto yy37;
			goto yy155;
		} else {
			if (yych <= 'p') {
				if (yych <= 'o') goto yy37;
				goto yy156;
			} else {
				if (yych == 'u') goto yy157;
				goto yy37;
			}
		}
	}
yy44:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'O') {
			if (yych == 'A') goto yy158;
			if (yych <= 'N') goto yy37;
			goto yy159;
		} else {
			if (yych == 'R') goto yy160;
			if (yych <= 'T') goto yy37;
			goto yy161;
		}
	} else {
		if (yych <= 'o') {
			if (yych == 'a') goto yy158;
			if (yych <= 'n') goto yy37;
			goto yy159;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy37;
				goto yy160;
			} else {
				if (yych == 'u') goto yy161;
				goto yy37;
			}
		}
	}
yy45:
	yych = *++cur;
	if (yych == 'U') goto yy162;
	if (yych == 'u') goto yy162;
	goto yy37;
yy46:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy163;
		if (yych <= 'D') goto yy37;
		goto yy164;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy163;
		} else {
			if (yych == 'e') goto yy164;
			goto yy37;
		}
	}
yy47:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy165;
		case 'E':
		case 'e': goto yy166;
		case 'H':
		case 'h': goto yy167;
		case 'O':
		case 'o': goto yy168;
		case 'T':
		case 't': goto yy169;
		case 'U':
		case 'u': goto yy170;
		case 'Y':
		case 'y': goto yy171;
		default: goto yy37;
	}
yy48:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy172;
		case 'E':
		case 'e': goto yy173;
		case 'H':
		case 'h': goto yy174;
		case 'O':
		case 'o': goto yy175;
		case 'Y':
		case 'y': goto yy176;
		default: goto yy37;
	}
yy49:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'N') goto yy177;
		if (yych <= 'R') goto yy37;
		goto yy178;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy177;
		} else {
			if (yych == 's') goto yy178;
			goto yy37;
		}
	}
yy50:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy179;
		if (yych <= 'N') goto yy37;
		goto yy180;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy179;
		} else {
			if (yych == 'o') goto yy180;
			goto yy37;
		}
	}
yy51:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych <= 'G') {
			if (yych == 'A') goto yy181;
			goto yy37;
		} else {
			if (yych <= 'H') goto yy182;
			if (yych <= 'Q') goto yy37;
			goto yy183;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'a') goto yy181;
			goto yy37;
		} else {
			if (yych <= 'h') goto yy182;
			if (yych == 'r') goto yy183;
			goto yy37;
		}
	}
yy52:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy184;
	if (yych == '\'') goto yy185;
	goto yy37;
yy53:
	++cur;
yy54:
#line 530 "parser/tokenizer.re"
	{ RET(TK_LBRACKET) }
#line 1076 "parser/tokenizer.cpp"
yy55:
	++cur;
#line 531 "parser/tokenizer.re"
	{ RET(TK_RBRACKET) }
#line 1081 "parser/tokenizer.cpp"
yy56:
	++cur;
#line 532 "parser/tokenizer.re"
	{ RET(TK_LBRACE) }
#line 1086 "parser/tokenizer.cpp"
yy57:
	++cur;
#line 544 "parser/tokenizer.re"
	{ RET(TK_VBAR) }
#line 1091 "parser/tokenizer.cpp"
yy58:
	++cur;
#line 533 "parser/tokenizer.re"
	{ RET(TK_RBRACE) }
#line 1096 "parser/tokenizer.cpp"
yy59:
	yych = *++cur;
yy60:
	if (yybm[256+yych] & 64) {
		goto yy59;
	}
	if (yych >= 0x01) goto yy62;
yy61:
	cur = mar;
	if (yyaccept <= 7) {
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy3;
				} else {
					goto yy21;
				}
			} else {
				if (yyaccept == 2) {
					goto yy29;
				} else {
					goto yy66;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy72;
				} else {
					goto yy76;
				}
			} else {
				if (yyaccept == 6) {
					goto yy54;
				} else {
					goto yy82;
				}
			}
		}
	} else {
		if (yyaccept <= 11) {
			if (yyaccept <= 9) {
				if (yyaccept == 8) {
					goto yy125;
				} else {
					goto yy142;
				}
			} else {
				if (yyaccept == 10) {
					goto yy244;
				} else {
					goto yy643;
				}
			}
		} else {
			if (yyaccept <= 13) {
				if (yyaccept == 12) {
					goto yy771;
				} else {
					goto yy922;
				}
			} else {
				goto yy991;
			}
		}
	}
yy62:
	++cur;
#line 658 "parser/tokenizer.re"
	{
                line_num++; cur_line=cur;
                token(yylval.string);
                yylval.string.n--;
                token_loc(loc);
                if (last_token == yytokentype::TK_NEWLINE) {
                    return yytokentype::TK_COMMENT;
                } else {
                    last_token=yytokentype::TK_NEWLINE;
                    return yytokentype::TK_EOLCOMMENT;
                }
            }
#line 1178 "parser/tokenizer.cpp"
yy63:
	yych = *++cur;
	if (yych == 'F') goto yy186;
	goto yy60;
yy64:
	yych = *++cur;
yy65:
	if (yybm[256+yych] & 128) {
		goto yy64;
	}
	if (yych <= 0x00) goto yy61;
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy64;
yy66:
#line 674 "parser/tokenizer.re"
	{ token_str(al, yylval.string, '"'); RET(TK_STRING) }
#line 1196 "parser/tokenizer.cpp"
yy67:
	yych = *++cur;
yy68:
	if (yych <= 0x00) goto yy61;
	if (yych != '\n') goto yy67;
	++cur;
#line 672 "parser/tokenizer.re"
	{ line_num++; cur_line=cur; continue; }
#line 1205 "parser/tokenizer.cpp"
yy69:
	yych = *++cur;
yy70:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy69;
		} else {
			if (yych <= '\n') goto yy71;
			if (yych <= '\v') goto yy69;
			goto yy61;
		}
	} else {
		if (yych <= 0x1F) {
			if (yych <= '\r') goto yy69;
			goto yy61;
		} else {
			if (yych <= ' ') goto yy69;
			if (yych <= '!') goto yy73;
			goto yy61;
		}
	}
yy71:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 1) {
		goto yy71;
	}
	if (yych <= 0x1F) goto yy72;
	if (yych <= '!') goto yy73;
	if (yych == '&') goto yy187;
yy72:
#line 642 "parser/tokenizer.re"
	{
                line_num++; cur_line=cur; continue;
            }
#line 1242 "parser/tokenizer.cpp"
yy73:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy71;
	goto yy73;
yy74:
	yych = *++cur;
yy75:
	if (yybm[0+yych] & 2) {
		goto yy74;
	}
	if (yych <= 0x00) goto yy61;
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy74;
yy76:
#line 675 "parser/tokenizer.re"
	{ token_str(al, yylval.string, '\''); RET(TK_STRING) }
#line 1261 "parser/tokenizer.cpp"
yy77:
	yyaccept = 6;
	yych = *(mar = ++cur);
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy188;
			goto yy54;
		} else {
			if (yych == '\f') goto yy54;
			if (yych <= '\r') goto yy188;
			goto yy54;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ' ') goto yy188;
			if (yych == ')') goto yy189;
			goto yy54;
		} else {
			if (yych <= '/') goto yy190;
			if (yych == '=') goto yy191;
			goto yy54;
		}
	}
yy78:
	++cur;
#line 549 "parser/tokenizer.re"
	{ RET(TK_POW) }
#line 1289 "parser/tokenizer.cpp"
yy79:
	++cur;
#line 547 "parser/tokenizer.re"
	{ RET(TK_DBL_DOT) }
#line 1294 "parser/tokenizer.cpp"
yy80:
	yyaccept = 7;
	yych = *(mar = ++cur);
yy81:
	if (yych <= 'E') {
		if (yych <= '/') goto yy82;
		if (yych <= '9') goto yy80;
		if (yych >= 'D') goto yy99;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto yy192;
		} else {
			if (yych <= 'c') goto yy82;
			if (yych <= 'e') goto yy99;
		}
	}
yy82:
#line 599 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_REAL) }
#line 1314 "parser/tokenizer.cpp"
yy83:
	yych = *++cur;
	if (yych == 'N') goto yy194;
	if (yych == 'n') goto yy194;
	goto yy85;
yy84:
	yych = *++cur;
yy85:
	if (yybm[0+yych] & 4) {
		goto yy84;
	}
	if (yych == '.') goto yy193;
	goto yy61;
yy86:
	yych = *++cur;
	if (yych == 'Q') goto yy195;
	if (yych == 'q') goto yy195;
	goto yy85;
yy87:
	yych = *++cur;
	if (yych == 'A') goto yy196;
	if (yych == 'a') goto yy196;
	goto yy85;
yy88:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy197;
		if (yych <= 'S') goto yy85;
		goto yy198;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy85;
			goto yy197;
		} else {
			if (yych == 't') goto yy198;
			goto yy85;
		}
	}
yy89:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy199;
		if (yych <= 'S') goto yy85;
		goto yy200;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy85;
			goto yy199;
		} else {
			if (yych == 't') goto yy200;
			goto yy85;
		}
	}
yy90:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy201;
		if (yych <= 'N') goto yy85;
		goto yy202;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy85;
			goto yy201;
		} else {
			if (yych == 'o') goto yy202;
			goto yy85;
		}
	}
yy91:
	yych = *++cur;
	if (yych == 'R') goto yy203;
	if (yych == 'r') goto yy203;
	goto yy85;
yy92:
	yych = *++cur;
	if (yych == 'R') goto yy204;
	if (yych == 'r') goto yy204;
	goto yy85;
yy93:
	yych = *++cur;
	if (yych == 'O') goto yy205;
	if (yych == 'o') goto yy205;
	goto yy85;
yy94:
	++cur;
#line 534 "parser/tokenizer.re"
	{ RET(TK_RBRACKET_OLD) }
#line 1402 "parser/tokenizer.cpp"
yy95:
	++cur;
#line 550 "parser/tokenizer.re"
	{ RET(TK_CONCAT) }
#line 1407 "parser/tokenizer.cpp"
yy96:
	++cur;
#line 557 "parser/tokenizer.re"
	{ RET(TK_NE) }
#line 1412 "parser/tokenizer.cpp"
yy97:
	yych = *++cur;
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy97;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			if (yych <= '\r') goto yy97;
			goto yy61;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy97;
			if (yych <= '@') goto yy61;
			if (yych <= 'Z') goto yy206;
			goto yy61;
		} else {
			if (yych == '`') goto yy61;
			if (yych <= 'z') goto yy206;
			goto yy61;
		}
	}
yy98:
	yyaccept = 7;
	yych = *(mar = ++cur);
	if (yych <= 'Z') {
		if (yych <= '@') goto yy81;
		if (yych <= 'C') goto yy207;
		if (yych <= 'E') goto yy209;
		goto yy207;
	} else {
		if (yych <= 'c') {
			if (yych <= '`') goto yy81;
			goto yy207;
		} else {
			if (yych <= 'e') goto yy209;
			if (yych <= 'z') goto yy207;
			goto yy81;
		}
	}
yy99:
	yych = *++cur;
	if (yych <= ',') {
		if (yych == '+') goto yy210;
		goto yy61;
	} else {
		if (yych <= '-') goto yy210;
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy211;
		goto yy61;
	}
yy100:
	yych = *++cur;
	if (yych <= '9') {
		if (yych <= '&') {
			if (yych == '"') goto yy64;
			goto yy61;
		} else {
			if (yych <= '\'') goto yy74;
			if (yych <= '/') goto yy61;
			goto yy212;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy61;
			if (yych <= 'Z') goto yy213;
			goto yy61;
		} else {
			if (yych == '`') goto yy61;
			if (yych <= 'z') goto yy213;
			goto yy61;
		}
	}
yy101:
	++cur;
#line 548 "parser/tokenizer.re"
	{ RET(TK_DBL_COLON) }
#line 1491 "parser/tokenizer.cpp"
yy102:
	++cur;
#line 563 "parser/tokenizer.re"
	{ RET(TK_LE) }
#line 1496 "parser/tokenizer.cpp"
yy103:
	++cur;
#line 554 "parser/tokenizer.re"
	{ RET(TK_EQ) }
#line 1501 "parser/tokenizer.cpp"
yy104:
	++cur;
#line 551 "parser/tokenizer.re"
	{ RET(TK_ARROW) }
#line 1506 "parser/tokenizer.cpp"
yy105:
	++cur;
#line 569 "parser/tokenizer.re"
	{ RET(TK_GE) }
#line 1511 "parser/tokenizer.cpp"
yy106:
	yych = *++cur;
	if (yych == 'S') goto yy214;
	if (yych == 's') goto yy214;
	goto yy37;
yy107:
	yych = *++cur;
	if (yych == 'L') goto yy215;
	if (yych == 'l') goto yy215;
	goto yy37;
yy108:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'S') goto yy217;
		if (yych <= 'X') goto yy37;
		goto yy218;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy37;
			goto yy217;
		} else {
			if (yych == 'y') goto yy218;
			goto yy37;
		}
	}
yy109:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych <= '&') {
		if (yych == '"') goto yy64;
		goto yy29;
	} else {
		if (yych <= '\'') goto yy74;
		if (yych == '_') goto yy109;
		goto yy29;
	}
yy110:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy219;
	}
	goto yy61;
yy111:
	yych = *++cur;
	if (yych <= '/') goto yy61;
	if (yych <= '1') goto yy220;
	goto yy61;
yy112:
	yych = *++cur;
	if (yych == 'C') goto yy221;
	if (yych == 'c') goto yy221;
	goto yy37;
yy113:
	yych = *++cur;
	if (yych == 'N') goto yy222;
	if (yych == 'n') goto yy222;
	goto yy37;
yy114:
	yych = *++cur;
	if (yych == 'O') goto yy223;
	if (yych == 'o') goto yy223;
	goto yy37;
yy115:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'L') goto yy224;
		if (yych <= 'R') goto yy37;
		goto yy225;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy224;
		} else {
			if (yych == 's') goto yy225;
			goto yy37;
		}
	}
yy116:
	yych = *++cur;
	if (yych == 'A') goto yy226;
	if (yych == 'a') goto yy226;
	goto yy37;
yy117:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy227;
		if (yych <= 'N') goto yy37;
		goto yy228;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy227;
		} else {
			if (yych == 'o') goto yy228;
			goto yy37;
		}
	}
yy118:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy37;
			goto yy229;
		} else {
			if (yych <= 'L') goto yy37;
			if (yych <= 'M') goto yy230;
			goto yy231;
		}
	} else {
		if (yych <= 'l') {
			if (yych == 'd') goto yy229;
			goto yy37;
		} else {
			if (yych <= 'm') goto yy230;
			if (yych <= 'n') goto yy231;
			goto yy37;
		}
	}
yy119:
	yych = *++cur;
	if (yych == 'I') goto yy232;
	if (yych == 'i') goto yy232;
	goto yy37;
yy120:
	yych = *++cur;
	if (yych == 'C') goto yy233;
	if (yych == 'c') goto yy233;
	goto yy37;
yy121:
	yych = *++cur;
	if (yych == 'T') goto yy234;
	if (yych == 't') goto yy234;
	goto yy37;
yy122:
	yych = *++cur;
	if (yych <= 'F') {
		if (yych == 'A') goto yy235;
		if (yych <= 'E') goto yy37;
		goto yy236;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy235;
		} else {
			if (yych == 'f') goto yy236;
			goto yy37;
		}
	}
yy123:
	yych = *++cur;
	if (yych == 'M') goto yy237;
	if (yych == 'm') goto yy237;
	goto yy37;
yy124:
	yyaccept = 8;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= '@') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych >= '\t') {
					ctxmar = cur;
					goto yy238;
				}
			} else {
				if (yych == '\v') {
					ctxmar = cur;
					goto yy238;
				}
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') {
					ctxmar = cur;
					goto yy238;
				}
				if (yych >= ' ') {
					ctxmar = cur;
					goto yy238;
				}
			} else {
				if (yych <= '/') goto yy125;
				if (yych <= '9') goto yy36;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'V') {
				if (yych == 'U') goto yy239;
				goto yy36;
			} else {
				if (yych <= 'W') goto yy240;
				if (yych <= 'Z') goto yy36;
			}
		} else {
			if (yych <= 'v') {
				if (yych == 'u') goto yy239;
				goto yy36;
			} else {
				if (yych <= 'w') goto yy240;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy125:
#line 292 "parser/tokenizer.re"
	{ KW(DO) }
#line 1724 "parser/tokenizer.cpp"
yy126:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'E') goto yy241;
		if (yych <= 'R') goto yy37;
		goto yy242;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy241;
		} else {
			if (yych == 's') goto yy242;
			goto yy37;
		}
	}
yy127:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy37;
			goto yy243;
		} else {
			if (yych <= 'S') goto yy37;
			if (yych <= 'T') goto yy245;
			goto yy246;
		}
	} else {
		if (yych <= 's') {
			if (yych == 'd') goto yy243;
			goto yy37;
		} else {
			if (yych <= 't') goto yy245;
			if (yych <= 'u') goto yy246;
			goto yy37;
		}
	}
yy128:
	yych = *++cur;
	if (yych == 'U') goto yy247;
	if (yych == 'u') goto yy247;
	goto yy37;
yy129:
	yych = *++cur;
	if (yych == 'R') goto yy248;
	if (yych == 'r') goto yy248;
	goto yy37;
yy130:
	yych = *++cur;
	if (yych == 'E') goto yy249;
	if (yych == 'e') goto yy249;
	goto yy37;
yy131:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'I') goto yy250;
		if (yych <= 'S') goto yy37;
		goto yy251;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy250;
		} else {
			if (yych == 't') goto yy251;
			goto yy37;
		}
	}
yy132:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'L') goto yy252;
		if (yych <= 'M') goto yy37;
		goto yy253;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy252;
		} else {
			if (yych == 'n') goto yy253;
			goto yy37;
		}
	}
yy133:
	yych = *++cur;
	if (yych == 'U') goto yy254;
	if (yych == 'u') goto yy254;
	goto yy37;
yy134:
	yych = *++cur;
	if (yych == 'R') goto yy255;
	if (yych == 'r') goto yy255;
	goto yy37;
yy135:
	yych = *++cur;
	if (yych == 'N') goto yy256;
	if (yych == 'n') goto yy256;
	goto yy37;
yy136:
	yych = *++cur;
	if (yych == 'N') goto yy257;
	if (yych == 'n') goto yy257;
	goto yy37;
yy137:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy138;
			if (yych <= 'S') goto yy36;
			goto yy258;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy258;
			if (yych <= 'z') goto yy36;
		}
	}
yy138:
#line 409 "parser/tokenizer.re"
	{ KW(GO) }
#line 1851 "parser/tokenizer.cpp"
yy139:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 411 "parser/tokenizer.re"
	{ KW(IF) }
#line 1860 "parser/tokenizer.cpp"
yy140:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'A') goto yy259;
		if (yych <= 'O') goto yy37;
		goto yy260;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy259;
		} else {
			if (yych == 'p') goto yy260;
			goto yy37;
		}
	}
yy141:
	yyaccept = 9;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'P') {
		if (yych <= ' ') {
			if (yych <= '\v') {
				if (yych == '\t') goto yy261;
				if (yych >= '\v') goto yy261;
			} else {
				if (yych == '\r') goto yy261;
				if (yych >= ' ') goto yy261;
			}
		} else {
			if (yych <= 'B') {
				if (yych <= '/') goto yy142;
				if (yych <= '9') goto yy36;
				if (yych >= 'A') goto yy36;
			} else {
				if (yych <= 'C') goto yy262;
				if (yych == 'O') goto yy263;
				goto yy36;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'T') {
				if (yych <= 'Q') goto yy264;
				if (yych <= 'R') goto yy36;
				if (yych <= 'S') goto yy265;
				goto yy266;
			} else {
				if (yych <= 'Z') goto yy36;
				if (yych <= '`') goto yy142;
				if (yych <= 'b') goto yy36;
				goto yy262;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy263;
				if (yych <= 'p') goto yy36;
				goto yy264;
			} else {
				if (yych <= 's') {
					if (yych <= 'r') goto yy36;
					goto yy265;
				} else {
					if (yych <= 't') goto yy266;
					if (yych <= 'z') goto yy36;
				}
			}
		}
	}
yy142:
#line 416 "parser/tokenizer.re"
	{ KW(IN) }
#line 1934 "parser/tokenizer.cpp"
yy143:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 426 "parser/tokenizer.re"
	{ KW(IS) }
#line 1943 "parser/tokenizer.cpp"
yy144:
	yych = *++cur;
	if (yych == 'N') goto yy267;
	if (yych == 'n') goto yy267;
	goto yy37;
yy145:
	yych = *++cur;
	if (yych == 'N') goto yy268;
	if (yych == 'n') goto yy268;
	goto yy37;
yy146:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy269;
		if (yych <= 'F') goto yy37;
		goto yy270;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy269;
		} else {
			if (yych == 'g') goto yy270;
			goto yy37;
		}
	}
yy147:
	yych = *++cur;
	if (yych == 'M') goto yy271;
	if (yych == 'm') goto yy271;
	goto yy37;
yy148:
	yych = *++cur;
	if (yych <= 'L') {
		if (yych == 'D') goto yy272;
		if (yych <= 'K') goto yy37;
		goto yy273;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy37;
			goto yy272;
		} else {
			if (yych == 'l') goto yy273;
			goto yy37;
		}
	}
yy149:
	yych = *++cur;
	if (yych == 'M') goto yy274;
	if (yych == 'm') goto yy274;
	goto yy37;
yy150:
	yych = *++cur;
	if (yych == 'W') goto yy275;
	if (yych == 'w') goto yy275;
	goto yy37;
yy151:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'N') goto yy276;
		if (yych <= 'O') goto yy37;
		goto yy277;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy276;
		} else {
			if (yych == 'p') goto yy277;
			goto yy37;
		}
	}
yy152:
	yych = *++cur;
	if (yych == 'L') goto yy278;
	if (yych == 'l') goto yy278;
	goto yy37;
yy153:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy279;
	}
	goto yy61;
yy154:
	yych = *++cur;
	if (yych <= '/') goto yy61;
	if (yych <= '7') goto yy280;
	goto yy61;
yy155:
	yych = *++cur;
	if (yych == 'L') goto yy281;
	if (yych == 'l') goto yy281;
	goto yy37;
yy156:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy282;
		if (yych <= 'S') goto yy37;
		goto yy283;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy282;
		} else {
			if (yych == 't') goto yy283;
			goto yy37;
		}
	}
yy157:
	yych = *++cur;
	if (yych == 'T') goto yy284;
	if (yych == 't') goto yy284;
	goto yy37;
yy158:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'Q') goto yy37;
		if (yych <= 'R') goto yy285;
		goto yy286;
	} else {
		if (yych <= 'q') goto yy37;
		if (yych <= 'r') goto yy285;
		if (yych <= 's') goto yy286;
		goto yy37;
	}
yy159:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'I') goto yy287;
		if (yych <= 'R') goto yy37;
		goto yy288;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy287;
		} else {
			if (yych == 's') goto yy288;
			goto yy37;
		}
	}
yy160:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'E') goto yy289;
			goto yy37;
		} else {
			if (yych <= 'I') goto yy290;
			if (yych <= 'N') goto yy37;
			goto yy291;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'e') goto yy289;
			goto yy37;
		} else {
			if (yych <= 'i') goto yy290;
			if (yych == 'o') goto yy291;
			goto yy37;
		}
	}
yy161:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'B') goto yy292;
		if (yych <= 'Q') goto yy37;
		goto yy293;
	} else {
		if (yych <= 'b') {
			if (yych <= 'a') goto yy37;
			goto yy292;
		} else {
			if (yych == 'r') goto yy293;
			goto yy37;
		}
	}
yy162:
	yych = *++cur;
	if (yych == 'I') goto yy294;
	if (yych == 'i') goto yy294;
	goto yy37;
yy163:
	yych = *++cur;
	if (yych == 'N') goto yy295;
	if (yych == 'n') goto yy295;
	goto yy37;
yy164:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy296;
		case 'C':
		case 'c': goto yy297;
		case 'D':
		case 'd': goto yy298;
		case 'Q':
		case 'q': goto yy299;
		case 'S':
		case 's': goto yy300;
		case 'T':
		case 't': goto yy301;
		case 'W':
		case 'w': goto yy302;
		default: goto yy37;
	}
yy165:
	yych = *++cur;
	if (yych == 'V') goto yy303;
	if (yych == 'v') goto yy303;
	goto yy37;
yy166:
	yych = *++cur;
	if (yych <= 'Q') {
		if (yych == 'L') goto yy304;
		if (yych <= 'P') goto yy37;
		goto yy305;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy304;
		} else {
			if (yych == 'q') goto yy305;
			goto yy37;
		}
	}
yy167:
	yych = *++cur;
	if (yych == 'A') goto yy306;
	if (yych == 'a') goto yy306;
	goto yy37;
yy168:
	yych = *++cur;
	if (yych == 'U') goto yy307;
	if (yych == 'u') goto yy307;
	goto yy37;
yy169:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy308;
		if (yych <= 'N') goto yy37;
		goto yy309;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy308;
		} else {
			if (yych == 'o') goto yy309;
			goto yy37;
		}
	}
yy170:
	yych = *++cur;
	if (yych == 'B') goto yy310;
	if (yych == 'b') goto yy310;
	goto yy37;
yy171:
	yych = *++cur;
	if (yych == 'N') goto yy311;
	if (yych == 'n') goto yy311;
	goto yy37;
yy172:
	yych = *++cur;
	if (yych == 'R') goto yy312;
	if (yych == 'r') goto yy312;
	goto yy37;
yy173:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych == 'A') goto yy313;
		if (yych <= 'L') goto yy37;
		goto yy314;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy313;
		} else {
			if (yych == 'm') goto yy314;
			goto yy37;
		}
	}
yy174:
	yych = *++cur;
	if (yych == 'E') goto yy315;
	if (yych == 'e') goto yy315;
	goto yy37;
yy175:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 494 "parser/tokenizer.re"
	{ KW(TO) }
#line 2235 "parser/tokenizer.cpp"
yy176:
	yych = *++cur;
	if (yych == 'P') goto yy316;
	if (yych == 'p') goto yy316;
	goto yy37;
yy177:
	yych = *++cur;
	if (yych == 'F') goto yy317;
	if (yych == 'f') goto yy317;
	goto yy37;
yy178:
	yych = *++cur;
	if (yych == 'E') goto yy318;
	if (yych == 'e') goto yy318;
	goto yy37;
yy179:
	yych = *++cur;
	if (yych == 'L') goto yy319;
	if (yych == 'l') goto yy319;
	goto yy37;
yy180:
	yych = *++cur;
	if (yych == 'L') goto yy320;
	if (yych == 'l') goto yy320;
	goto yy37;
yy181:
	yych = *++cur;
	if (yych == 'I') goto yy321;
	if (yych == 'i') goto yy321;
	goto yy37;
yy182:
	yych = *++cur;
	if (yych <= 'I') {
		if (yych == 'E') goto yy322;
		if (yych <= 'H') goto yy37;
		goto yy323;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy322;
		} else {
			if (yych == 'i') goto yy323;
			goto yy37;
		}
	}
yy183:
	yych = *++cur;
	if (yych == 'I') goto yy324;
	if (yych == 'i') goto yy324;
	goto yy37;
yy184:
	yych = *++cur;
	if (yych == '"') goto yy61;
	goto yy326;
yy185:
	yych = *++cur;
	if (yych == '\'') goto yy61;
	goto yy328;
yy186:
	yych = *++cur;
	if (yych == '$') goto yy329;
	goto yy60;
yy187:
	++cur;
	goto yy72;
yy188:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy188;
		} else {
			if (yych == '\v') goto yy188;
			goto yy61;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy188;
			if (yych <= 0x1F) goto yy61;
			goto yy188;
		} else {
			if (yych == ')') goto yy330;
			goto yy61;
		}
	}
yy189:
	++cur;
	cur -= 2;
#line 523 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 2326 "parser/tokenizer.cpp"
yy190:
	yych = *++cur;
	if (yych == ')') goto yy333;
	goto yy332;
yy191:
	++cur;
	cur -= 2;
#line 522 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 2336 "parser/tokenizer.cpp"
yy192:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy334;
		if (yych <= '@') goto yy61;
		goto yy335;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy61;
			goto yy335;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy335;
			goto yy61;
		}
	}
yy193:
	++cur;
#line 677 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_DEF_OP) }
#line 2358 "parser/tokenizer.cpp"
yy194:
	yych = *++cur;
	if (yych == 'D') goto yy336;
	if (yych == 'd') goto yy336;
	goto yy85;
yy195:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == '.') goto yy337;
		goto yy85;
	} else {
		if (yych <= 'V') goto yy338;
		if (yych == 'v') goto yy338;
		goto yy85;
	}
yy196:
	yych = *++cur;
	if (yych == 'L') goto yy339;
	if (yych == 'l') goto yy339;
	goto yy85;
yy197:
	yych = *++cur;
	if (yych == '.') goto yy340;
	goto yy85;
yy198:
	yych = *++cur;
	if (yych == '.') goto yy341;
	goto yy85;
yy199:
	yych = *++cur;
	if (yych == '.') goto yy342;
	goto yy85;
yy200:
	yych = *++cur;
	if (yych == '.') goto yy343;
	goto yy85;
yy201:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == '.') goto yy344;
		goto yy85;
	} else {
		if (yych <= 'Q') goto yy345;
		if (yych == 'q') goto yy345;
		goto yy85;
	}
yy202:
	yych = *++cur;
	if (yych == 'T') goto yy346;
	if (yych == 't') goto yy346;
	goto yy85;
yy203:
	yych = *++cur;
	if (yych == '.') goto yy347;
	goto yy85;
yy204:
	yych = *++cur;
	if (yych == 'U') goto yy348;
	if (yych == 'u') goto yy348;
	goto yy85;
yy205:
	yych = *++cur;
	if (yych == 'R') goto yy349;
	if (yych == 'r') goto yy349;
	goto yy85;
yy206:
	yych = *++cur;
	if (yybm[0+yych] & 16) {
		goto yy206;
	}
	cur = ctxmar;
#line 600 "parser/tokenizer.re"
	{
                if (last_token == yytokentype::TK_NEWLINE) {
                    uint64_t u;
                    if (lex_int(tok, cur, u, yylval.int_suffix.int_kind)) {
                            yylval.n = u;
                            if (enddo_label_stack[enddo_label_stack.size()-1] == u) {
                                while (enddo_label_stack[enddo_label_stack.size()-1] == u) {
                                    enddo_label_stack.pop_back();
                                    enddo_insert_count++;
                                }
                                enddo_newline_process = true;
                            } else {
                                enddo_newline_process = false;
                            }
                            RET(TK_LABEL)
                    } else {
                        token_loc(loc);
                        std::string t = token();
                        throw LFortran::parser_local::TokenizerError("Integer '" + t + "' too large",
                            loc);
                    }
                } else {
                    lex_int_large(al, tok, cur,
                        yylval.int_suffix.int_n,
                        yylval.int_suffix.int_kind);
                    RET(TK_INTEGER)
                }
            }
#line 2459 "parser/tokenizer.cpp"
yy207:
	yych = *++cur;
yy208:
	if (yych <= '@') {
		if (yych == '.') goto yy350;
		goto yy61;
	} else {
		if (yych <= 'Z') goto yy207;
		if (yych <= '`') goto yy61;
		if (yych <= 'z') goto yy207;
		goto yy61;
	}
yy209:
	yych = *++cur;
	if (yych <= ',') {
		if (yych != '+') goto yy208;
	} else {
		if (yych <= '-') goto yy210;
		if (yych <= '/') goto yy208;
		if (yych <= '9') goto yy211;
		goto yy208;
	}
yy210:
	yych = *++cur;
	if (yych <= '/') goto yy61;
	if (yych >= ':') goto yy61;
yy211:
	yyaccept = 7;
	yych = *(mar = ++cur);
	if (yych <= '/') goto yy82;
	if (yych <= '9') goto yy211;
	if (yych == '_') goto yy192;
	goto yy82;
yy212:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy97;
			}
			goto yy21;
		} else {
			if (yych == '\f') goto yy21;
			ctxmar = cur;
			goto yy97;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') {
				ctxmar = cur;
				goto yy97;
			}
			goto yy21;
		} else {
			if (yych <= '.') {
				ctxmar = cur;
				goto yy351;
			}
			if (yych <= '/') goto yy21;
			if (yych <= '9') goto yy212;
			goto yy21;
		}
	}
yy213:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '-') {
		if (yych <= '\v') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy97;
			}
			if (yych <= '\n') goto yy21;
			ctxmar = cur;
			goto yy97;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy21;
				ctxmar = cur;
				goto yy97;
			} else {
				if (yych == ' ') {
					ctxmar = cur;
					goto yy97;
				}
				goto yy21;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych <= '.') {
					ctxmar = cur;
					goto yy351;
				}
				goto yy21;
			} else {
				if (yych <= '9') goto yy213;
				if (yych <= '@') goto yy21;
				goto yy213;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy21;
				goto yy213;
			} else {
				if (yych <= '`') goto yy21;
				if (yych <= 'z') goto yy213;
				goto yy21;
			}
		}
	}
yy214:
	yych = *++cur;
	if (yych == 'T') goto yy352;
	if (yych == 't') goto yy352;
	goto yy37;
yy215:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy216;
			if (yych <= 'N') goto yy36;
			goto yy353;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'o') goto yy353;
			if (yych <= 'z') goto yy36;
		}
	}
yy216:
#line 254 "parser/tokenizer.re"
	{ KW(ALL) }
#line 2604 "parser/tokenizer.cpp"
yy217:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'I') goto yy354;
		if (yych <= 'N') goto yy37;
		goto yy355;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy354;
		} else {
			if (yych == 'o') goto yy355;
			goto yy37;
		}
	}
yy218:
	yych = *++cur;
	if (yych == 'N') goto yy356;
	if (yych == 'n') goto yy356;
	goto yy37;
yy219:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy219;
	}
	if (yych == '"') goto yy357;
	goto yy61;
yy220:
	yych = *++cur;
	if (yych == '\'') goto yy358;
	if (yych <= '/') goto yy61;
	if (yych <= '1') goto yy220;
	goto yy61;
yy221:
	yych = *++cur;
	if (yych == 'K') goto yy359;
	if (yych == 'k') goto yy359;
	goto yy37;
yy222:
	yych = *++cur;
	if (yych == 'D') goto yy360;
	if (yych == 'd') goto yy360;
	goto yy37;
yy223:
	yych = *++cur;
	if (yych == 'C') goto yy361;
	if (yych == 'c') goto yy361;
	goto yy37;
yy224:
	yych = *++cur;
	if (yych == 'L') goto yy362;
	if (yych == 'l') goto yy362;
	goto yy37;
yy225:
	yych = *++cur;
	if (yych == 'E') goto yy363;
	if (yych == 'e') goto yy363;
	goto yy37;
yy226:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy364;
		if (yych <= 'Q') goto yy37;
		goto yy365;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy364;
		} else {
			if (yych == 'r') goto yy365;
			goto yy37;
		}
	}
yy227:
	yych = *++cur;
	if (yych == 'S') goto yy366;
	if (yych == 's') goto yy366;
	goto yy37;
yy228:
	yych = *++cur;
	if (yych == 'S') goto yy367;
	if (yych == 's') goto yy367;
	goto yy37;
yy229:
	yych = *++cur;
	if (yych == 'I') goto yy368;
	if (yych == 'i') goto yy368;
	goto yy37;
yy230:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'M') goto yy369;
		if (yych <= 'O') goto yy37;
		goto yy370;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy369;
		} else {
			if (yych == 'p') goto yy370;
			goto yy37;
		}
	}
yy231:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'C') goto yy371;
		if (yych <= 'S') goto yy37;
		goto yy372;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy371;
		} else {
			if (yych == 't') goto yy372;
			goto yy37;
		}
	}
yy232:
	yych = *++cur;
	if (yych == 'T') goto yy373;
	if (yych == 't') goto yy373;
	goto yy37;
yy233:
	yych = *++cur;
	if (yych == 'L') goto yy374;
	if (yych == 'l') goto yy374;
	goto yy37;
yy234:
	yych = *++cur;
	if (yych == 'A') goto yy375;
	if (yych == 'a') goto yy375;
	goto yy37;
yy235:
	yych = *++cur;
	if (yych == 'L') goto yy376;
	if (yych == 'l') goto yy376;
	goto yy37;
yy236:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy377;
		if (yych <= 'D') goto yy37;
		goto yy378;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy377;
		} else {
			if (yych == 'e') goto yy378;
			goto yy37;
		}
	}
yy237:
	yych = *++cur;
	if (yych == 'E') goto yy379;
	if (yych == 'e') goto yy379;
	goto yy37;
yy238:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy238;
		} else {
			if (yych == '\v') goto yy238;
			goto yy61;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy238;
			if (yych <= 0x1F) goto yy61;
			goto yy238;
		} else {
			if (yych <= '/') goto yy61;
			if (yych <= '9') goto yy380;
			goto yy61;
		}
	}
yy239:
	yych = *++cur;
	if (yych == 'B') goto yy382;
	if (yych == 'b') goto yy382;
	goto yy37;
yy240:
	yych = *++cur;
	if (yych == 'H') goto yy383;
	if (yych == 'h') goto yy383;
	goto yy37;
yy241:
	yych = *++cur;
	if (yych == 'M') goto yy384;
	if (yych == 'm') goto yy384;
	goto yy37;
yy242:
	yych = *++cur;
	if (yych == 'E') goto yy385;
	if (yych == 'e') goto yy385;
	goto yy37;
yy243:
	yyaccept = 10;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	switch (yych) {
		case '\t':
		case '\v':
		case '\r': goto yy387;
		case ' ': goto yy389;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'N':
		case 'O':
		case 'Q':
		case 'R':
		case 'U':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'y':
		case 'z': goto yy36;
		case 'A':
		case 'a': goto yy390;
		case 'B':
		case 'b': goto yy391;
		case 'C':
		case 'c': goto yy392;
		case 'D':
		case 'd': goto yy393;
		case 'E':
		case 'e': goto yy394;
		case 'F':
		case 'f': goto yy395;
		case 'I':
		case 'i': goto yy396;
		case 'M':
		case 'm': goto yy397;
		case 'P':
		case 'p': goto yy398;
		case 'S':
		case 's': goto yy399;
		case 'T':
		case 't': goto yy400;
		case 'W':
		case 'w': goto yy401;
		default: goto yy244;
	}
yy244:
#line 302 "parser/tokenizer.re"
	{ KW(END) }
#line 2882 "parser/tokenizer.cpp"
yy245:
	yych = *++cur;
	if (yych == 'R') goto yy402;
	if (yych == 'r') goto yy402;
	goto yy37;
yy246:
	yych = *++cur;
	if (yych == 'M') goto yy403;
	if (yych == 'm') goto yy403;
	goto yy37;
yy247:
	yych = *++cur;
	if (yych == 'I') goto yy405;
	if (yych == 'i') goto yy405;
	goto yy37;
yy248:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'M') goto yy406;
		if (yych <= 'N') goto yy37;
		goto yy407;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy406;
		} else {
			if (yych == 'o') goto yy407;
			goto yy37;
		}
	}
yy249:
	yych = *++cur;
	if (yych == 'N') goto yy408;
	if (yych == 'n') goto yy408;
	goto yy37;
yy250:
	yych = *++cur;
	if (yych == 'T') goto yy409;
	if (yych == 't') goto yy409;
	goto yy37;
yy251:
	yych = *++cur;
	if (yych == 'E') goto yy410;
	if (yych == 'e') goto yy410;
	goto yy37;
yy252:
	yych = *++cur;
	if (yych == 'E') goto yy411;
	if (yych == 'e') goto yy411;
	goto yy37;
yy253:
	yych = *++cur;
	if (yych == 'A') goto yy412;
	if (yych == 'a') goto yy412;
	goto yy37;
yy254:
	yych = *++cur;
	if (yych == 'S') goto yy413;
	if (yych == 's') goto yy413;
	goto yy37;
yy255:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych == 'A') goto yy414;
		if (yych <= 'L') goto yy37;
		goto yy415;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy414;
		} else {
			if (yych == 'm') goto yy415;
			goto yy37;
		}
	}
yy256:
	yych = *++cur;
	if (yych == 'C') goto yy417;
	if (yych == 'c') goto yy417;
	goto yy37;
yy257:
	yych = *++cur;
	if (yych == 'E') goto yy418;
	if (yych == 'e') goto yy418;
	goto yy37;
yy258:
	yych = *++cur;
	if (yych == 'O') goto yy419;
	if (yych == 'o') goto yy419;
	goto yy37;
yy259:
	yych = *++cur;
	if (yych == 'G') goto yy420;
	if (yych == 'g') goto yy420;
	goto yy37;
yy260:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'L') goto yy421;
			goto yy37;
		} else {
			if (yych <= 'O') goto yy422;
			if (yych <= 'T') goto yy37;
			goto yy423;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'l') goto yy421;
			goto yy37;
		} else {
			if (yych <= 'o') goto yy422;
			if (yych == 'u') goto yy423;
			goto yy37;
		}
	}
yy261:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy261;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			goto yy261;
		}
	} else {
		if (yych <= 'N') {
			if (yych == ' ') goto yy261;
			goto yy61;
		} else {
			if (yych <= 'O') goto yy424;
			if (yych == 'o') goto yy424;
			goto yy61;
		}
	}
yy262:
	yych = *++cur;
	if (yych == 'L') goto yy425;
	if (yych == 'l') goto yy425;
	goto yy37;
yy263:
	yych = *++cur;
	if (yych == 'U') goto yy426;
	if (yych == 'u') goto yy426;
	goto yy37;
yy264:
	yych = *++cur;
	if (yych == 'U') goto yy427;
	if (yych == 'u') goto yy427;
	goto yy37;
yy265:
	yych = *++cur;
	if (yych == 'T') goto yy428;
	if (yych == 't') goto yy428;
	goto yy37;
yy266:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'E') goto yy429;
		if (yych <= 'Q') goto yy37;
		goto yy430;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy429;
		} else {
			if (yych == 'r') goto yy430;
			goto yy37;
		}
	}
yy267:
	yych = *++cur;
	if (yych == 'D') goto yy431;
	if (yych == 'd') goto yy431;
	goto yy37;
yy268:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 428 "parser/tokenizer.re"
	{ KW(LEN) }
#line 3067 "parser/tokenizer.cpp"
yy269:
	yych = *++cur;
	if (yych == 'A') goto yy432;
	if (yych == 'a') goto yy432;
	goto yy37;
yy270:
	yych = *++cur;
	if (yych == 'I') goto yy433;
	if (yych == 'i') goto yy433;
	goto yy37;
yy271:
	yych = *++cur;
	if (yych == 'O') goto yy434;
	if (yych == 'o') goto yy434;
	goto yy37;
yy272:
	yych = *++cur;
	if (yych == 'U') goto yy435;
	if (yych == 'u') goto yy435;
	goto yy37;
yy273:
	yych = *++cur;
	if (yych == 'D') goto yy436;
	if (yych == 'd') goto yy436;
	goto yy37;
yy274:
	yych = *++cur;
	if (yych == 'E') goto yy437;
	if (yych == 'e') goto yy437;
	goto yy37;
yy275:
	yych = *++cur;
	if (yych == '_') goto yy439;
	goto yy37;
yy276:
	yych = *++cur;
	if (yych <= '^') {
		if (yych == 'E') goto yy440;
		goto yy37;
	} else {
		if (yych <= '_') goto yy441;
		if (yych == 'e') goto yy440;
		goto yy37;
	}
yy277:
	yych = *++cur;
	if (yych == 'A') goto yy442;
	if (yych == 'a') goto yy442;
	goto yy37;
yy278:
	yych = *++cur;
	if (yych == 'L') goto yy443;
	if (yych == 'l') goto yy443;
	goto yy37;
yy279:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy279;
	}
	if (yych == '"') goto yy444;
	goto yy61;
yy280:
	yych = *++cur;
	if (yych == '\'') goto yy445;
	if (yych <= '/') goto yy61;
	if (yych <= '7') goto yy280;
	goto yy61;
yy281:
	yych = *++cur;
	if (yych == 'Y') goto yy446;
	if (yych == 'y') goto yy446;
	goto yy37;
yy282:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy447;
		if (yych <= 'Q') goto yy37;
		goto yy448;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy447;
		} else {
			if (yych == 'r') goto yy448;
			goto yy37;
		}
	}
yy283:
	yych = *++cur;
	if (yych == 'I') goto yy449;
	if (yych == 'i') goto yy449;
	goto yy37;
yy284:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 448 "parser/tokenizer.re"
	{ KW(OUT) }
#line 3168 "parser/tokenizer.cpp"
yy285:
	yych = *++cur;
	if (yych == 'A') goto yy450;
	if (yych == 'a') goto yy450;
	goto yy37;
yy286:
	yych = *++cur;
	if (yych == 'S') goto yy451;
	if (yych == 's') goto yy451;
	goto yy37;
yy287:
	yych = *++cur;
	if (yych == 'N') goto yy452;
	if (yych == 'n') goto yy452;
	goto yy37;
yy288:
	yych = *++cur;
	if (yych == 'T') goto yy453;
	if (yych == 't') goto yy453;
	goto yy37;
yy289:
	yych = *++cur;
	if (yych == 'C') goto yy454;
	if (yych == 'c') goto yy454;
	goto yy37;
yy290:
	yych = *++cur;
	if (yych <= 'V') {
		if (yych == 'N') goto yy455;
		if (yych <= 'U') goto yy37;
		goto yy456;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy455;
		} else {
			if (yych == 'v') goto yy456;
			goto yy37;
		}
	}
yy291:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych <= 'F') {
			if (yych == 'C') goto yy457;
			goto yy37;
		} else {
			if (yych <= 'G') goto yy458;
			if (yych <= 'S') goto yy37;
			goto yy459;
		}
	} else {
		if (yych <= 'f') {
			if (yych == 'c') goto yy457;
			goto yy37;
		} else {
			if (yych <= 'g') goto yy458;
			if (yych == 't') goto yy459;
			goto yy37;
		}
	}
yy292:
	yych = *++cur;
	if (yych == 'L') goto yy460;
	if (yych == 'l') goto yy460;
	goto yy37;
yy293:
	yych = *++cur;
	if (yych == 'E') goto yy461;
	if (yych == 'e') goto yy461;
	goto yy37;
yy294:
	yych = *++cur;
	if (yych == 'E') goto yy462;
	if (yych == 'e') goto yy462;
	goto yy37;
yy295:
	yych = *++cur;
	if (yych == 'K') goto yy463;
	if (yych == 'k') goto yy463;
	goto yy37;
yy296:
	yych = *++cur;
	if (yych <= 'L') {
		if (yych == 'D') goto yy464;
		if (yych <= 'K') goto yy37;
		goto yy465;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy37;
			goto yy464;
		} else {
			if (yych == 'l') goto yy465;
			goto yy37;
		}
	}
yy297:
	yych = *++cur;
	if (yych == 'U') goto yy466;
	if (yych == 'u') goto yy466;
	goto yy37;
yy298:
	yych = *++cur;
	if (yych == 'U') goto yy467;
	if (yych == 'u') goto yy467;
	goto yy37;
yy299:
	yych = *++cur;
	if (yych == 'U') goto yy468;
	if (yych == 'u') goto yy468;
	goto yy37;
yy300:
	yych = *++cur;
	if (yych == 'U') goto yy469;
	if (yych == 'u') goto yy469;
	goto yy37;
yy301:
	yych = *++cur;
	if (yych == 'U') goto yy470;
	if (yych == 'u') goto yy470;
	goto yy37;
yy302:
	yych = *++cur;
	if (yych == 'I') goto yy471;
	if (yych == 'i') goto yy471;
	goto yy37;
yy303:
	yych = *++cur;
	if (yych == 'E') goto yy472;
	if (yych == 'e') goto yy472;
	goto yy37;
yy304:
	yych = *++cur;
	if (yych == 'E') goto yy473;
	if (yych == 'e') goto yy473;
	goto yy37;
yy305:
	yych = *++cur;
	if (yych == 'U') goto yy474;
	if (yych == 'u') goto yy474;
	goto yy37;
yy306:
	yych = *++cur;
	if (yych == 'R') goto yy475;
	if (yych == 'r') goto yy475;
	goto yy37;
yy307:
	yych = *++cur;
	if (yych == 'R') goto yy476;
	if (yych == 'r') goto yy476;
	goto yy37;
yy308:
	yych = *++cur;
	if (yych == 'T') goto yy477;
	if (yych == 't') goto yy477;
	goto yy37;
yy309:
	yych = *++cur;
	if (yych == 'P') goto yy478;
	if (yych == 'p') goto yy478;
	goto yy37;
yy310:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy479;
		if (yych <= 'Q') goto yy37;
		goto yy480;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy479;
		} else {
			if (yych == 'r') goto yy480;
			goto yy37;
		}
	}
yy311:
	yych = *++cur;
	if (yych == 'C') goto yy481;
	if (yych == 'c') goto yy481;
	goto yy37;
yy312:
	yych = *++cur;
	if (yych == 'G') goto yy483;
	if (yych == 'g') goto yy483;
	goto yy37;
yy313:
	yych = *++cur;
	if (yych == 'M') goto yy484;
	if (yych == 'm') goto yy484;
	goto yy37;
yy314:
	yych = *++cur;
	if (yych == 'P') goto yy485;
	if (yych == 'p') goto yy485;
	goto yy37;
yy315:
	yych = *++cur;
	if (yych == 'N') goto yy486;
	if (yych == 'n') goto yy486;
	goto yy37;
yy316:
	yych = *++cur;
	if (yych == 'E') goto yy487;
	if (yych == 'e') goto yy487;
	goto yy37;
yy317:
	yych = *++cur;
	if (yych == 'O') goto yy488;
	if (yych == 'o') goto yy488;
	goto yy37;
yy318:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 497 "parser/tokenizer.re"
	{ KW(USE) }
#line 3388 "parser/tokenizer.cpp"
yy319:
	yych = *++cur;
	if (yych == 'U') goto yy489;
	if (yych == 'u') goto yy489;
	goto yy37;
yy320:
	yych = *++cur;
	if (yych == 'A') goto yy490;
	if (yych == 'a') goto yy490;
	goto yy37;
yy321:
	yych = *++cur;
	if (yych == 'T') goto yy491;
	if (yych == 't') goto yy491;
	goto yy37;
yy322:
	yych = *++cur;
	if (yych == 'R') goto yy492;
	if (yych == 'r') goto yy492;
	goto yy37;
yy323:
	yych = *++cur;
	if (yych == 'L') goto yy493;
	if (yych == 'l') goto yy493;
	goto yy37;
yy324:
	yych = *++cur;
	if (yych == 'T') goto yy494;
	if (yych == 't') goto yy494;
	goto yy37;
yy325:
	yych = *++cur;
yy326:
	if (yybm[0+yych] & 128) {
		goto yy325;
	}
	if (yych == '"') goto yy495;
	goto yy61;
yy327:
	yych = *++cur;
yy328:
	if (yych <= '9') {
		if (yych == '\'') goto yy496;
		if (yych <= '/') goto yy61;
		goto yy327;
	} else {
		if (yych <= 'F') {
			if (yych <= '@') goto yy61;
			goto yy327;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'f') goto yy327;
			goto yy61;
		}
	}
yy329:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy497;
	goto yy329;
yy330:
	++cur;
	cur = ctxmar;
#line 525 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 3454 "parser/tokenizer.cpp"
yy331:
	yych = *++cur;
yy332:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy331;
		} else {
			if (yych == '\v') goto yy331;
			goto yy61;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy331;
			if (yych <= 0x1F) goto yy61;
			goto yy331;
		} else {
			if (yych == ')') goto yy498;
			goto yy61;
		}
	}
yy333:
	++cur;
	cur -= 3;
#line 528 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 3481 "parser/tokenizer.cpp"
yy334:
	yych = *++cur;
	if (yych <= '/') goto yy82;
	if (yych <= '9') goto yy334;
	goto yy82;
yy335:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy82;
		if (yych <= '9') goto yy335;
		if (yych <= '@') goto yy82;
		goto yy335;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy82;
			goto yy335;
		} else {
			if (yych <= '`') goto yy82;
			if (yych <= 'z') goto yy335;
			goto yy82;
		}
	}
yy336:
	yych = *++cur;
	if (yych == '.') goto yy499;
	goto yy85;
yy337:
	++cur;
#line 555 "parser/tokenizer.re"
	{ WARN_REL(EQ) RET(TK_EQ) }
#line 3512 "parser/tokenizer.cpp"
yy338:
	yych = *++cur;
	if (yych == '.') goto yy500;
	goto yy85;
yy339:
	yych = *++cur;
	if (yych == 'S') goto yy501;
	if (yych == 's') goto yy501;
	goto yy85;
yy340:
	++cur;
#line 570 "parser/tokenizer.re"
	{ WARN_REL(GE) RET(TK_GE) }
#line 3526 "parser/tokenizer.cpp"
yy341:
	++cur;
#line 567 "parser/tokenizer.re"
	{ WARN_REL(GT) RET(TK_GT) }
#line 3531 "parser/tokenizer.cpp"
yy342:
	++cur;
#line 564 "parser/tokenizer.re"
	{ WARN_REL(LE) RET(TK_LE) }
#line 3536 "parser/tokenizer.cpp"
yy343:
	++cur;
#line 561 "parser/tokenizer.re"
	{ WARN_REL(LT) RET(TK_LT) }
#line 3541 "parser/tokenizer.cpp"
yy344:
	++cur;
#line 558 "parser/tokenizer.re"
	{ WARN_REL(NE) RET(TK_NE) }
#line 3546 "parser/tokenizer.cpp"
yy345:
	yych = *++cur;
	if (yych == 'V') goto yy502;
	if (yych == 'v') goto yy502;
	goto yy85;
yy346:
	yych = *++cur;
	if (yych == '.') goto yy503;
	goto yy85;
yy347:
	++cur;
#line 576 "parser/tokenizer.re"
	{ RET(TK_OR) }
#line 3560 "parser/tokenizer.cpp"
yy348:
	yych = *++cur;
	if (yych == 'E') goto yy504;
	if (yych == 'e') goto yy504;
	goto yy85;
yy349:
	yych = *++cur;
	if (yych == '.') goto yy505;
	goto yy85;
yy350:
	++cur;
	cur = ctxmar;
#line 591 "parser/tokenizer.re"
	{
                lex_int_large(al, tok, cur,
                    yylval.int_suffix.int_n,
                    yylval.int_suffix.int_kind);
                RET(TK_INTEGER)
            }
#line 3580 "parser/tokenizer.cpp"
yy351:
	yych = *++cur;
	if (yych == '.') goto yy61;
	goto yy208;
yy352:
	yych = *++cur;
	if (yych == 'R') goto yy506;
	if (yych == 'r') goto yy506;
	goto yy37;
yy353:
	yych = *++cur;
	if (yych == 'C') goto yy507;
	if (yych == 'c') goto yy507;
	goto yy37;
yy354:
	yych = *++cur;
	if (yych == 'G') goto yy508;
	if (yych == 'g') goto yy508;
	goto yy37;
yy355:
	yych = *++cur;
	if (yych == 'C') goto yy509;
	if (yych == 'c') goto yy509;
	goto yy37;
yy356:
	yych = *++cur;
	if (yych == 'C') goto yy510;
	if (yych == 'c') goto yy510;
	goto yy37;
yy357:
	++cur;
#line 635 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 3614 "parser/tokenizer.cpp"
yy358:
	++cur;
#line 636 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 3619 "parser/tokenizer.cpp"
yy359:
	yych = *++cur;
	if (yych == 'S') goto yy511;
	if (yych == 's') goto yy511;
	goto yy37;
yy360:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 262 "parser/tokenizer.re"
	{ KW(BIND) }
#line 3633 "parser/tokenizer.cpp"
yy361:
	yych = *++cur;
	if (yych == 'K') goto yy512;
	if (yych == 'k') goto yy512;
	goto yy37;
yy362:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 264 "parser/tokenizer.re"
	{ KW(CALL) }
#line 3647 "parser/tokenizer.cpp"
yy363:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 265 "parser/tokenizer.re"
	{ KW(CASE) }
#line 3656 "parser/tokenizer.cpp"
yy364:
	yych = *++cur;
	if (yych == 'G') goto yy513;
	if (yych == 'g') goto yy513;
	goto yy37;
yy365:
	yych = *++cur;
	if (yych == 'A') goto yy514;
	if (yych == 'a') goto yy514;
	goto yy37;
yy366:
	yych = *++cur;
	if (yych == 'S') goto yy515;
	if (yych == 's') goto yy515;
	goto yy37;
yy367:
	yych = *++cur;
	if (yych == 'E') goto yy516;
	if (yych == 'e') goto yy516;
	goto yy37;
yy368:
	yych = *++cur;
	if (yych == 'M') goto yy517;
	if (yych == 'm') goto yy517;
	goto yy37;
yy369:
	yych = *++cur;
	if (yych == 'O') goto yy518;
	if (yych == 'o') goto yy518;
	goto yy37;
yy370:
	yych = *++cur;
	if (yych == 'L') goto yy519;
	if (yych == 'l') goto yy519;
	goto yy37;
yy371:
	yych = *++cur;
	if (yych == 'U') goto yy520;
	if (yych == 'u') goto yy520;
	goto yy37;
yy372:
	yych = *++cur;
	if (yych <= 'I') {
		if (yych == 'A') goto yy521;
		if (yych <= 'H') goto yy37;
		goto yy522;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy521;
		} else {
			if (yych == 'i') goto yy522;
			goto yy37;
		}
	}
yy373:
	yych = *++cur;
	if (yych == 'I') goto yy523;
	if (yych == 'i') goto yy523;
	goto yy37;
yy374:
	yych = *++cur;
	if (yych == 'E') goto yy524;
	if (yych == 'e') goto yy524;
	goto yy37;
yy375:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 280 "parser/tokenizer.re"
	{ KW(DATA) }
#line 3730 "parser/tokenizer.cpp"
yy376:
	yych = *++cur;
	if (yych == 'L') goto yy525;
	if (yych == 'l') goto yy525;
	goto yy37;
yy377:
	yych = *++cur;
	if (yych == 'U') goto yy526;
	if (yych == 'u') goto yy526;
	goto yy37;
yy378:
	yych = *++cur;
	if (yych == 'R') goto yy527;
	if (yych == 'r') goto yy527;
	goto yy37;
yy379:
	yych = *++cur;
	if (yych == 'N') goto yy528;
	if (yych == 'n') goto yy528;
	goto yy37;
yy380:
	yych = *++cur;
	if (yych <= '/') goto yy381;
	if (yych <= '9') goto yy380;
yy381:
	cur = ctxmar;
#line 285 "parser/tokenizer.re"
	{
                // This is a label do statement, we have to match the
                // corresponding continue base "end do".
                uint64_t n = parse_int(cur);
                enddo_label_stack.push_back(n);
                KW(DO);
            }
#line 3765 "parser/tokenizer.cpp"
yy382:
	yych = *++cur;
	if (yych == 'L') goto yy529;
	if (yych == 'l') goto yy529;
	goto yy37;
yy383:
	yych = *++cur;
	if (yych == 'I') goto yy530;
	if (yych == 'i') goto yy530;
	goto yy37;
yy384:
	yych = *++cur;
	if (yych == 'E') goto yy531;
	if (yych == 'e') goto yy531;
	goto yy37;
yy385:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'W') {
		if (yych <= '@') {
			if (yych <= '/') goto yy386;
			if (yych <= '9') goto yy36;
		} else {
			if (yych == 'I') goto yy532;
			if (yych <= 'V') goto yy36;
			goto yy533;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy36;
			if (yych <= '`') goto yy386;
			if (yych <= 'h') goto yy36;
			goto yy532;
		} else {
			if (yych == 'w') goto yy533;
			if (yych <= 'z') goto yy36;
		}
	}
yy386:
#line 298 "parser/tokenizer.re"
	{ KW(ELSE) }
#line 3809 "parser/tokenizer.cpp"
yy387:
	yych = *++cur;
yy388:
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy387;
		case 'A':
		case 'a': goto yy534;
		case 'B':
		case 'b': goto yy535;
		case 'C':
		case 'c': goto yy536;
		case 'D':
		case 'd': goto yy537;
		case 'E':
		case 'e': goto yy538;
		case 'F':
		case 'f': goto yy539;
		case 'I':
		case 'i': goto yy540;
		case 'M':
		case 'm': goto yy541;
		case 'P':
		case 'p': goto yy542;
		case 'S':
		case 's': goto yy543;
		case 'T':
		case 't': goto yy544;
		case 'W':
		case 'w': goto yy545;
		default: goto yy61;
	}
yy389:
	yych = *++cur;
	if (yych == 'F') goto yy546;
	if (yych == 'f') goto yy546;
	goto yy388;
yy390:
	yych = *++cur;
	if (yych == 'S') goto yy547;
	if (yych == 's') goto yy547;
	goto yy37;
yy391:
	yych = *++cur;
	if (yych == 'L') goto yy548;
	if (yych == 'l') goto yy548;
	goto yy37;
yy392:
	yych = *++cur;
	if (yych == 'R') goto yy549;
	if (yych == 'r') goto yy549;
	goto yy37;
yy393:
	yych = *++cur;
	if (yych == 'O') goto yy550;
	if (yych == 'o') goto yy550;
	goto yy37;
yy394:
	yych = *++cur;
	if (yych == 'N') goto yy551;
	if (yych == 'n') goto yy551;
	goto yy37;
yy395:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy552;
			goto yy37;
		} else {
			if (yych <= 'O') goto yy553;
			if (yych <= 'T') goto yy37;
			goto yy554;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy552;
			goto yy37;
		} else {
			if (yych <= 'o') goto yy553;
			if (yych == 'u') goto yy554;
			goto yy37;
		}
	}
yy396:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'F') goto yy555;
		if (yych <= 'M') goto yy37;
		goto yy556;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy37;
			goto yy555;
		} else {
			if (yych == 'n') goto yy556;
			goto yy37;
		}
	}
yy397:
	yych = *++cur;
	if (yych == 'O') goto yy557;
	if (yych == 'o') goto yy557;
	goto yy37;
yy398:
	yych = *++cur;
	if (yych == 'R') goto yy558;
	if (yych == 'r') goto yy558;
	goto yy37;
yy399:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'E') goto yy559;
		if (yych <= 'T') goto yy37;
		goto yy560;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy559;
		} else {
			if (yych == 'u') goto yy560;
			goto yy37;
		}
	}
yy400:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'E') goto yy561;
		if (yych <= 'X') goto yy37;
		goto yy562;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy561;
		} else {
			if (yych == 'y') goto yy562;
			goto yy37;
		}
	}
yy401:
	yych = *++cur;
	if (yych == 'H') goto yy563;
	if (yych == 'h') goto yy563;
	goto yy37;
yy402:
	yych = *++cur;
	if (yych == 'Y') goto yy564;
	if (yych == 'y') goto yy564;
	goto yy37;
yy403:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'E') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy404;
			if (yych <= 'D') goto yy36;
			goto yy565;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'e') goto yy565;
			if (yych <= 'z') goto yy36;
		}
	}
yy404:
#line 379 "parser/tokenizer.re"
	{ KW(ENUM) }
#line 3985 "parser/tokenizer.cpp"
yy405:
	yych = *++cur;
	if (yych == 'V') goto yy566;
	if (yych == 'v') goto yy566;
	goto yy37;
yy406:
	yych = *++cur;
	if (yych == 'S') goto yy567;
	if (yych == 's') goto yy567;
	goto yy37;
yy407:
	yych = *++cur;
	if (yych == 'R') goto yy568;
	if (yych == 'r') goto yy568;
	goto yy37;
yy408:
	yych = *++cur;
	if (yych == 'T') goto yy569;
	if (yych == 't') goto yy569;
	goto yy37;
yy409:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 385 "parser/tokenizer.re"
	{ KW(EXIT) }
#line 4014 "parser/tokenizer.cpp"
yy410:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy570;
		if (yych <= 'Q') goto yy37;
		goto yy571;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy570;
		} else {
			if (yych == 'r') goto yy571;
			goto yy37;
		}
	}
yy411:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 388 "parser/tokenizer.re"
	{ KW(FILE) }
#line 4038 "parser/tokenizer.cpp"
yy412:
	yych = *++cur;
	if (yych == 'L') goto yy572;
	if (yych == 'l') goto yy572;
	goto yy37;
yy413:
	yych = *++cur;
	if (yych == 'H') goto yy573;
	if (yych == 'h') goto yy573;
	goto yy37;
yy414:
	yych = *++cur;
	if (yych == 'L') goto yy574;
	if (yych == 'l') goto yy574;
	goto yy37;
yy415:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'T') {
		if (yych <= '@') {
			if (yych <= '/') goto yy416;
			if (yych <= '9') goto yy36;
		} else {
			if (yych <= 'A') goto yy575;
			if (yych <= 'S') goto yy36;
			goto yy576;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy575;
		} else {
			if (yych == 't') goto yy576;
			if (yych <= 'z') goto yy36;
		}
	}
yy416:
#line 405 "parser/tokenizer.re"
	{ KW(FORM) }
#line 4080 "parser/tokenizer.cpp"
yy417:
	yych = *++cur;
	if (yych == 'T') goto yy577;
	if (yych == 't') goto yy577;
	goto yy37;
yy418:
	yych = *++cur;
	if (yych == 'R') goto yy578;
	if (yych == 'r') goto yy578;
	goto yy37;
yy419:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 410 "parser/tokenizer.re"
	{ KW(GOTO) }
#line 4099 "parser/tokenizer.cpp"
yy420:
	yych = *++cur;
	if (yych == 'E') goto yy579;
	if (yych == 'e') goto yy579;
	goto yy37;
yy421:
	yych = *++cur;
	if (yych == 'I') goto yy580;
	if (yych == 'i') goto yy580;
	goto yy37;
yy422:
	yych = *++cur;
	if (yych == 'R') goto yy581;
	if (yych == 'r') goto yy581;
	goto yy37;
yy423:
	yych = *++cur;
	if (yych == 'R') goto yy582;
	if (yych == 'r') goto yy582;
	goto yy37;
yy424:
	yych = *++cur;
	if (yych == 'U') goto yy583;
	if (yych == 'u') goto yy583;
	goto yy61;
yy425:
	yych = *++cur;
	if (yych == 'U') goto yy584;
	if (yych == 'u') goto yy584;
	goto yy37;
yy426:
	yych = *++cur;
	if (yych == 'T') goto yy585;
	if (yych == 't') goto yy585;
	goto yy37;
yy427:
	yych = *++cur;
	if (yych == 'I') goto yy586;
	if (yych == 'i') goto yy586;
	goto yy37;
yy428:
	yych = *++cur;
	if (yych == 'A') goto yy587;
	if (yych == 'a') goto yy587;
	goto yy37;
yy429:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych <= 'M') {
			if (yych == 'G') goto yy588;
			goto yy37;
		} else {
			if (yych <= 'N') goto yy589;
			if (yych <= 'Q') goto yy37;
			goto yy590;
		}
	} else {
		if (yych <= 'm') {
			if (yych == 'g') goto yy588;
			goto yy37;
		} else {
			if (yych <= 'n') goto yy589;
			if (yych == 'r') goto yy590;
			goto yy37;
		}
	}
yy430:
	yych = *++cur;
	if (yych == 'I') goto yy591;
	if (yych == 'i') goto yy591;
	goto yy37;
yy431:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 427 "parser/tokenizer.re"
	{ KW(KIND) }
#line 4179 "parser/tokenizer.cpp"
yy432:
	yych = *++cur;
	if (yych == 'L') goto yy592;
	if (yych == 'l') goto yy592;
	goto yy37;
yy433:
	yych = *++cur;
	if (yych == 'C') goto yy593;
	if (yych == 'c') goto yy593;
	goto yy37;
yy434:
	yych = *++cur;
	if (yych == 'R') goto yy594;
	if (yych == 'r') goto yy594;
	goto yy37;
yy435:
	yych = *++cur;
	if (yych == 'L') goto yy595;
	if (yych == 'l') goto yy595;
	goto yy37;
yy436:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 434 "parser/tokenizer.re"
	{ KW(MOLD) }
#line 4208 "parser/tokenizer.cpp"
yy437:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'L') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy438;
			if (yych <= 'K') goto yy36;
			goto yy596;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'l') goto yy596;
			if (yych <= 'z') goto yy36;
		}
	}
yy438:
#line 435 "parser/tokenizer.re"
	{ KW(NAME) }
#line 4234 "parser/tokenizer.cpp"
yy439:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy64;
		if (yych <= '&') goto yy37;
		goto yy74;
	} else {
		if (yych <= 'I') {
			if (yych <= 'H') goto yy37;
			goto yy597;
		} else {
			if (yych == 'i') goto yy597;
			goto yy37;
		}
	}
yy440:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 442 "parser/tokenizer.re"
	{ KW(NONE) }
#line 4259 "parser/tokenizer.cpp"
yy441:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'O') {
		if (yych <= '\'') {
			if (yych == '"') goto yy64;
			if (yych <= '&') goto yy37;
			goto yy74;
		} else {
			if (yych == 'I') goto yy598;
			if (yych <= 'N') goto yy37;
			goto yy599;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'R') goto yy600;
			if (yych <= 'h') goto yy37;
			goto yy598;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy37;
				goto yy599;
			} else {
				if (yych == 'r') goto yy600;
				goto yy37;
			}
		}
	}
yy442:
	yych = *++cur;
	if (yych == 'S') goto yy601;
	if (yych == 's') goto yy601;
	goto yy37;
yy443:
	yych = *++cur;
	if (yych == 'I') goto yy602;
	if (yych == 'i') goto yy602;
	goto yy37;
yy444:
	++cur;
#line 637 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4302 "parser/tokenizer.cpp"
yy445:
	++cur;
#line 638 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4307 "parser/tokenizer.cpp"
yy446:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 444 "parser/tokenizer.re"
	{ KW(ONLY) }
#line 4316 "parser/tokenizer.cpp"
yy447:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 445 "parser/tokenizer.re"
	{ KW(OPEN) }
#line 4325 "parser/tokenizer.cpp"
yy448:
	yych = *++cur;
	if (yych == 'A') goto yy603;
	if (yych == 'a') goto yy603;
	goto yy37;
yy449:
	yych = *++cur;
	if (yych == 'O') goto yy604;
	if (yych == 'o') goto yy604;
	goto yy37;
yy450:
	yych = *++cur;
	if (yych == 'M') goto yy605;
	if (yych == 'm') goto yy605;
	goto yy37;
yy451:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 450 "parser/tokenizer.re"
	{ KW(PASS) }
#line 4349 "parser/tokenizer.cpp"
yy452:
	yych = *++cur;
	if (yych == 'T') goto yy606;
	if (yych == 't') goto yy606;
	goto yy37;
yy453:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 452 "parser/tokenizer.re"
	{ KW(POST) }
#line 4363 "parser/tokenizer.cpp"
yy454:
	yych = *++cur;
	if (yych == 'I') goto yy607;
	if (yych == 'i') goto yy607;
	goto yy37;
yy455:
	yych = *++cur;
	if (yych == 'T') goto yy608;
	if (yych == 't') goto yy608;
	goto yy37;
yy456:
	yych = *++cur;
	if (yych == 'A') goto yy609;
	if (yych == 'a') goto yy609;
	goto yy37;
yy457:
	yych = *++cur;
	if (yych == 'E') goto yy610;
	if (yych == 'e') goto yy610;
	goto yy37;
yy458:
	yych = *++cur;
	if (yych == 'R') goto yy611;
	if (yych == 'r') goto yy611;
	goto yy37;
yy459:
	yych = *++cur;
	if (yych == 'E') goto yy612;
	if (yych == 'e') goto yy612;
	goto yy37;
yy460:
	yych = *++cur;
	if (yych == 'I') goto yy613;
	if (yych == 'i') goto yy613;
	goto yy37;
yy461:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 460 "parser/tokenizer.re"
	{ KW(PURE) }
#line 4407 "parser/tokenizer.cpp"
yy462:
	yych = *++cur;
	if (yych == 'T') goto yy614;
	if (yych == 't') goto yy614;
	goto yy37;
yy463:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 462 "parser/tokenizer.re"
	{ KW(RANK) }
#line 4421 "parser/tokenizer.cpp"
yy464:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 463 "parser/tokenizer.re"
	{ KW(READ) }
#line 4430 "parser/tokenizer.cpp"
yy465:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 464 "parser/tokenizer.re"
	{KW(REAL) }
#line 4439 "parser/tokenizer.cpp"
yy466:
	yych = *++cur;
	if (yych == 'R') goto yy615;
	if (yych == 'r') goto yy615;
	goto yy37;
yy467:
	yych = *++cur;
	if (yych == 'C') goto yy616;
	if (yych == 'c') goto yy616;
	goto yy37;
yy468:
	yych = *++cur;
	if (yych == 'I') goto yy617;
	if (yych == 'i') goto yy617;
	goto yy37;
yy469:
	yych = *++cur;
	if (yych == 'L') goto yy618;
	if (yych == 'l') goto yy618;
	goto yy37;
yy470:
	yych = *++cur;
	if (yych == 'R') goto yy619;
	if (yych == 'r') goto yy619;
	goto yy37;
yy471:
	yych = *++cur;
	if (yych == 'N') goto yy620;
	if (yych == 'n') goto yy620;
	goto yy37;
yy472:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 472 "parser/tokenizer.re"
	{ KW(SAVE) }
#line 4478 "parser/tokenizer.cpp"
yy473:
	yych = *++cur;
	if (yych == 'C') goto yy621;
	if (yych == 'c') goto yy621;
	goto yy37;
yy474:
	yych = *++cur;
	if (yych == 'E') goto yy622;
	if (yych == 'e') goto yy622;
	goto yy37;
yy475:
	yych = *++cur;
	if (yych == 'E') goto yy623;
	if (yych == 'e') goto yy623;
	goto yy37;
yy476:
	yych = *++cur;
	if (yych == 'C') goto yy624;
	if (yych == 'c') goto yy624;
	goto yy37;
yy477:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 480 "parser/tokenizer.re"
	{ KW(STAT) }
#line 4507 "parser/tokenizer.cpp"
yy478:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 481 "parser/tokenizer.re"
	{ KW(STOP) }
#line 4516 "parser/tokenizer.cpp"
yy479:
	yych = *++cur;
	if (yych == 'O') goto yy625;
	if (yych == 'o') goto yy625;
	goto yy37;
yy480:
	yych = *++cur;
	if (yych == 'O') goto yy626;
	if (yych == 'o') goto yy626;
	goto yy37;
yy481:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'T') {
		if (yych <= 'H') {
			if (yych <= '9') {
				if (yych >= '0') goto yy36;
			} else {
				if (yych <= '@') goto yy482;
				if (yych <= 'A') goto yy627;
				goto yy36;
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'I') goto yy628;
				goto yy36;
			} else {
				if (yych <= 'M') goto yy629;
				if (yych <= 'S') goto yy36;
				goto yy630;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy36;
			} else {
				if (yych <= 'a') goto yy627;
				if (yych <= 'h') goto yy36;
				goto yy628;
			}
		} else {
			if (yych <= 's') {
				if (yych == 'm') goto yy629;
				goto yy36;
			} else {
				if (yych <= 't') goto yy630;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy482:
#line 484 "parser/tokenizer.re"
	{ KW(SYNC) }
#line 4573 "parser/tokenizer.cpp"
yy483:
	yych = *++cur;
	if (yych == 'E') goto yy631;
	if (yych == 'e') goto yy631;
	goto yy37;
yy484:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy632;
#line 490 "parser/tokenizer.re"
	{ KW(TEAM) }
#line 4587 "parser/tokenizer.cpp"
yy485:
	yych = *++cur;
	if (yych == 'L') goto yy633;
	if (yych == 'l') goto yy633;
	goto yy37;
yy486:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 493 "parser/tokenizer.re"
	{ KW(THEN) }
#line 4601 "parser/tokenizer.cpp"
yy487:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 495 "parser/tokenizer.re"
	{ KW(TYPE) }
#line 4610 "parser/tokenizer.cpp"
yy488:
	yych = *++cur;
	if (yych == 'R') goto yy634;
	if (yych == 'r') goto yy634;
	goto yy37;
yy489:
	yych = *++cur;
	if (yych == 'E') goto yy635;
	if (yych == 'e') goto yy635;
	goto yy37;
yy490:
	yych = *++cur;
	if (yych == 'T') goto yy636;
	if (yych == 't') goto yy636;
	goto yy37;
yy491:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 500 "parser/tokenizer.re"
	{ KW(WAIT) }
#line 4634 "parser/tokenizer.cpp"
yy492:
	yych = *++cur;
	if (yych == 'E') goto yy637;
	if (yych == 'e') goto yy637;
	goto yy37;
yy493:
	yych = *++cur;
	if (yych == 'E') goto yy638;
	if (yych == 'e') goto yy638;
	goto yy37;
yy494:
	yych = *++cur;
	if (yych == 'E') goto yy639;
	if (yych == 'e') goto yy639;
	goto yy37;
yy495:
	++cur;
#line 639 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4654 "parser/tokenizer.cpp"
yy496:
	++cur;
#line 640 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4659 "parser/tokenizer.cpp"
yy497:
	++cur;
	cur -= 1;
#line 646 "parser/tokenizer.re"
	{
                line_num++; cur_line=cur;
                token(yylval.string);
                token_loc(loc);
                if (last_token == yytokentype::TK_NEWLINE) {
                    return yytokentype::TK_PRAGMA;
                } else {
                    last_token=yytokentype::TK_NEWLINE;
                    return yytokentype::TK_EOLCOMMENT;
                }
            }
#line 4675 "parser/tokenizer.cpp"
yy498:
	++cur;
	cur = ctxmar;
#line 527 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 4681 "parser/tokenizer.cpp"
yy499:
	++cur;
#line 575 "parser/tokenizer.re"
	{ RET(TK_AND) }
#line 4686 "parser/tokenizer.cpp"
yy500:
	++cur;
#line 578 "parser/tokenizer.re"
	{ RET(TK_EQV) }
#line 4691 "parser/tokenizer.cpp"
yy501:
	yych = *++cur;
	if (yych == 'E') goto yy640;
	if (yych == 'e') goto yy640;
	goto yy85;
yy502:
	yych = *++cur;
	if (yych == '.') goto yy641;
	goto yy85;
yy503:
	++cur;
#line 574 "parser/tokenizer.re"
	{ RET(TK_NOT) }
#line 4705 "parser/tokenizer.cpp"
yy504:
	yych = *++cur;
	if (yych == '.') goto yy642;
	goto yy85;
yy505:
	++cur;
#line 577 "parser/tokenizer.re"
	{ RET(TK_XOR) }
#line 4714 "parser/tokenizer.cpp"
yy506:
	yych = *++cur;
	if (yych == 'A') goto yy644;
	if (yych == 'a') goto yy644;
	goto yy37;
yy507:
	yych = *++cur;
	if (yych == 'A') goto yy645;
	if (yych == 'a') goto yy645;
	goto yy37;
yy508:
	yych = *++cur;
	if (yych == 'N') goto yy646;
	if (yych == 'n') goto yy646;
	goto yy37;
yy509:
	yych = *++cur;
	if (yych == 'I') goto yy648;
	if (yych == 'i') goto yy648;
	goto yy37;
yy510:
	yych = *++cur;
	if (yych == 'H') goto yy649;
	if (yych == 'h') goto yy649;
	goto yy37;
yy511:
	yych = *++cur;
	if (yych == 'P') goto yy650;
	if (yych == 'p') goto yy650;
	goto yy37;
yy512:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 263 "parser/tokenizer.re"
	{ KW(BLOCK) }
#line 4753 "parser/tokenizer.cpp"
yy513:
	yych = *++cur;
	if (yych == 'E') goto yy651;
	if (yych == 'e') goto yy651;
	goto yy37;
yy514:
	yych = *++cur;
	if (yych == 'C') goto yy653;
	if (yych == 'c') goto yy653;
	goto yy37;
yy515:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 269 "parser/tokenizer.re"
	{ KW(CLASS) }
#line 4772 "parser/tokenizer.cpp"
yy516:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 270 "parser/tokenizer.re"
	{ KW(CLOSE) }
#line 4781 "parser/tokenizer.cpp"
yy517:
	yych = *++cur;
	if (yych == 'E') goto yy654;
	if (yych == 'e') goto yy654;
	goto yy37;
yy518:
	yych = *++cur;
	if (yych == 'N') goto yy655;
	if (yych == 'n') goto yy655;
	goto yy37;
yy519:
	yych = *++cur;
	if (yych == 'E') goto yy656;
	if (yych == 'e') goto yy656;
	goto yy37;
yy520:
	yych = *++cur;
	if (yych == 'R') goto yy657;
	if (yych == 'r') goto yy657;
	goto yy37;
yy521:
	yych = *++cur;
	if (yych == 'I') goto yy658;
	if (yych == 'i') goto yy658;
	goto yy37;
yy522:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'G') goto yy659;
		if (yych <= 'M') goto yy37;
		goto yy660;
	} else {
		if (yych <= 'g') {
			if (yych <= 'f') goto yy37;
			goto yy659;
		} else {
			if (yych == 'n') goto yy660;
			goto yy37;
		}
	}
yy523:
	yych = *++cur;
	if (yych == 'C') goto yy661;
	if (yych == 'c') goto yy661;
	goto yy37;
yy524:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 279 "parser/tokenizer.re"
	{ KW(CYCLE) }
#line 4835 "parser/tokenizer.cpp"
yy525:
	yych = *++cur;
	if (yych == 'O') goto yy662;
	if (yych == 'o') goto yy662;
	goto yy37;
yy526:
	yych = *++cur;
	if (yych == 'L') goto yy663;
	if (yych == 'l') goto yy663;
	goto yy37;
yy527:
	yych = *++cur;
	if (yych == 'R') goto yy664;
	if (yych == 'r') goto yy664;
	goto yy37;
yy528:
	yych = *++cur;
	if (yych == 'S') goto yy665;
	if (yych == 's') goto yy665;
	goto yy37;
yy529:
	yych = *++cur;
	if (yych == 'E') goto yy666;
	if (yych == 'e') goto yy666;
	goto yy37;
yy530:
	yych = *++cur;
	if (yych == 'L') goto yy668;
	if (yych == 'l') goto yy668;
	goto yy37;
yy531:
	yych = *++cur;
	if (yych == 'N') goto yy669;
	if (yych == 'n') goto yy669;
	goto yy37;
yy532:
	yych = *++cur;
	if (yych == 'F') goto yy670;
	if (yych == 'f') goto yy670;
	goto yy37;
yy533:
	yych = *++cur;
	if (yych == 'H') goto yy671;
	if (yych == 'h') goto yy671;
	goto yy37;
yy534:
	yych = *++cur;
	if (yych == 'S') goto yy672;
	if (yych == 's') goto yy672;
	goto yy61;
yy535:
	yych = *++cur;
	if (yych == 'L') goto yy673;
	if (yych == 'l') goto yy673;
	goto yy61;
yy536:
	yych = *++cur;
	if (yych == 'R') goto yy674;
	if (yych == 'r') goto yy674;
	goto yy61;
yy537:
	yych = *++cur;
	if (yych == 'O') goto yy675;
	if (yych == 'o') goto yy675;
	goto yy61;
yy538:
	yych = *++cur;
	if (yych == 'N') goto yy676;
	if (yych == 'n') goto yy676;
	goto yy61;
yy539:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'O') goto yy677;
		if (yych <= 'T') goto yy61;
		goto yy678;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy61;
			goto yy677;
		} else {
			if (yych == 'u') goto yy678;
			goto yy61;
		}
	}
yy540:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'F') goto yy679;
		if (yych <= 'M') goto yy61;
		goto yy680;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy61;
			goto yy679;
		} else {
			if (yych == 'n') goto yy680;
			goto yy61;
		}
	}
yy541:
	yych = *++cur;
	if (yych == 'O') goto yy681;
	if (yych == 'o') goto yy681;
	goto yy61;
yy542:
	yych = *++cur;
	if (yych == 'R') goto yy682;
	if (yych == 'r') goto yy682;
	goto yy61;
yy543:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'E') goto yy683;
		if (yych <= 'T') goto yy61;
		goto yy684;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy61;
			goto yy683;
		} else {
			if (yych == 'u') goto yy684;
			goto yy61;
		}
	}
yy544:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'E') goto yy685;
		if (yych <= 'X') goto yy61;
		goto yy686;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy61;
			goto yy685;
		} else {
			if (yych == 'y') goto yy686;
			goto yy61;
		}
	}
yy545:
	yych = *++cur;
	if (yych == 'H') goto yy687;
	if (yych == 'h') goto yy687;
	goto yy61;
yy546:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy688;
			goto yy61;
		} else {
			if (yych <= 'O') goto yy677;
			if (yych <= 'T') goto yy61;
			goto yy678;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy688;
			goto yy61;
		} else {
			if (yych <= 'o') goto yy677;
			if (yych == 'u') goto yy678;
			goto yy61;
		}
	}
yy547:
	yych = *++cur;
	if (yych == 'S') goto yy689;
	if (yych == 's') goto yy689;
	goto yy37;
yy548:
	yych = *++cur;
	if (yych == 'O') goto yy690;
	if (yych == 'o') goto yy690;
	goto yy37;
yy549:
	yych = *++cur;
	if (yych == 'I') goto yy691;
	if (yych == 'i') goto yy691;
	goto yy37;
yy550:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 364 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    KW(CONTINUE)
                } else {
                    KW(ENDDO)
                }
            }
#line 5031 "parser/tokenizer.cpp"
yy551:
	yych = *++cur;
	if (yych == 'U') goto yy692;
	if (yych == 'u') goto yy692;
	goto yy37;
yy552:
	yych = *++cur;
	if (yych == 'L') goto yy693;
	if (yych == 'l') goto yy693;
	goto yy37;
yy553:
	yych = *++cur;
	if (yych == 'R') goto yy694;
	if (yych == 'r') goto yy694;
	goto yy37;
yy554:
	yych = *++cur;
	if (yych == 'N') goto yy695;
	if (yych == 'n') goto yy695;
	goto yy37;
yy555:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 349 "parser/tokenizer.re"
	{ KW(ENDIF) }
#line 5060 "parser/tokenizer.cpp"
yy556:
	yych = *++cur;
	if (yych == 'T') goto yy696;
	if (yych == 't') goto yy696;
	goto yy37;
yy557:
	yych = *++cur;
	if (yych == 'D') goto yy697;
	if (yych == 'd') goto yy697;
	goto yy37;
yy558:
	yych = *++cur;
	if (yych == 'O') goto yy698;
	if (yych == 'o') goto yy698;
	goto yy37;
yy559:
	yych = *++cur;
	if (yych == 'L') goto yy699;
	if (yych == 'l') goto yy699;
	goto yy37;
yy560:
	yych = *++cur;
	if (yych == 'B') goto yy700;
	if (yych == 'b') goto yy700;
	goto yy37;
yy561:
	yych = *++cur;
	if (yych == 'A') goto yy701;
	if (yych == 'a') goto yy701;
	goto yy37;
yy562:
	yych = *++cur;
	if (yych == 'P') goto yy702;
	if (yych == 'p') goto yy702;
	goto yy37;
yy563:
	yych = *++cur;
	if (yych == 'E') goto yy703;
	if (yych == 'e') goto yy703;
	goto yy37;
yy564:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 378 "parser/tokenizer.re"
	{ KW(ENTRY) }
#line 5109 "parser/tokenizer.cpp"
yy565:
	yych = *++cur;
	if (yych == 'R') goto yy704;
	if (yych == 'r') goto yy704;
	goto yy37;
yy566:
	yych = *++cur;
	if (yych == 'A') goto yy705;
	if (yych == 'a') goto yy705;
	goto yy37;
yy567:
	yych = *++cur;
	if (yych == 'G') goto yy706;
	if (yych == 'g') goto yy706;
	goto yy37;
yy568:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 383 "parser/tokenizer.re"
	{ KW(ERROR) }
#line 5133 "parser/tokenizer.cpp"
yy569:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 384 "parser/tokenizer.re"
	{ KW(EVENT) }
#line 5142 "parser/tokenizer.cpp"
yy570:
	yych = *++cur;
	if (yych == 'D') goto yy707;
	if (yych == 'd') goto yy707;
	goto yy37;
yy571:
	yych = *++cur;
	if (yych == 'N') goto yy708;
	if (yych == 'n') goto yy708;
	goto yy37;
yy572:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 389 "parser/tokenizer.re"
	{ KW(FINAL) }
#line 5161 "parser/tokenizer.cpp"
yy573:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 390 "parser/tokenizer.re"
	{ KW(FLUSH) }
#line 5170 "parser/tokenizer.cpp"
yy574:
	yych = *++cur;
	if (yych == 'L') goto yy709;
	if (yych == 'l') goto yy709;
	goto yy37;
yy575:
	yych = *++cur;
	if (yych == 'T') goto yy710;
	if (yych == 't') goto yy710;
	goto yy37;
yy576:
	yych = *++cur;
	if (yych == 'E') goto yy712;
	if (yych == 'e') goto yy712;
	goto yy37;
yy577:
	yych = *++cur;
	if (yych == 'I') goto yy713;
	if (yych == 'i') goto yy713;
	goto yy37;
yy578:
	yych = *++cur;
	if (yych == 'I') goto yy714;
	if (yych == 'i') goto yy714;
	goto yy37;
yy579:
	yych = *++cur;
	if (yych == 'S') goto yy715;
	if (yych == 's') goto yy715;
	goto yy37;
yy580:
	yych = *++cur;
	if (yych == 'C') goto yy716;
	if (yych == 'c') goto yy716;
	goto yy37;
yy581:
	yych = *++cur;
	if (yych == 'T') goto yy717;
	if (yych == 't') goto yy717;
	goto yy37;
yy582:
	yych = *++cur;
	if (yych == 'E') goto yy718;
	if (yych == 'e') goto yy718;
	goto yy37;
yy583:
	yych = *++cur;
	if (yych == 'T') goto yy719;
	if (yych == 't') goto yy719;
	goto yy61;
yy584:
	yych = *++cur;
	if (yych == 'D') goto yy720;
	if (yych == 'd') goto yy720;
	goto yy37;
yy585:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 418 "parser/tokenizer.re"
	{ KW(INOUT) }
#line 5234 "parser/tokenizer.cpp"
yy586:
	yych = *++cur;
	if (yych == 'R') goto yy721;
	if (yych == 'r') goto yy721;
	goto yy37;
yy587:
	yych = *++cur;
	if (yych == 'N') goto yy722;
	if (yych == 'n') goto yy722;
	goto yy37;
yy588:
	yych = *++cur;
	if (yych == 'E') goto yy723;
	if (yych == 'e') goto yy723;
	goto yy37;
yy589:
	yych = *++cur;
	if (yych == 'T') goto yy724;
	if (yych == 't') goto yy724;
	goto yy37;
yy590:
	yych = *++cur;
	if (yych == 'F') goto yy725;
	if (yych == 'f') goto yy725;
	goto yy37;
yy591:
	yych = *++cur;
	if (yych == 'N') goto yy726;
	if (yych == 'n') goto yy726;
	goto yy37;
yy592:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy727;
#line 429 "parser/tokenizer.re"
	{ KW(LOCAL) }
#line 5273 "parser/tokenizer.cpp"
yy593:
	yych = *++cur;
	if (yych == 'A') goto yy728;
	if (yych == 'a') goto yy728;
	goto yy37;
yy594:
	yych = *++cur;
	if (yych == 'Y') goto yy729;
	if (yych == 'y') goto yy729;
	goto yy37;
yy595:
	yych = *++cur;
	if (yych == 'E') goto yy730;
	if (yych == 'e') goto yy730;
	goto yy37;
yy596:
	yych = *++cur;
	if (yych == 'I') goto yy731;
	if (yych == 'i') goto yy731;
	goto yy37;
yy597:
	yych = *++cur;
	if (yych == 'N') goto yy732;
	if (yych == 'n') goto yy732;
	goto yy37;
yy598:
	yych = *++cur;
	if (yych == 'N') goto yy733;
	if (yych == 'n') goto yy733;
	goto yy37;
yy599:
	yych = *++cur;
	if (yych == 'V') goto yy734;
	if (yych == 'v') goto yy734;
	goto yy37;
yy600:
	yych = *++cur;
	if (yych == 'E') goto yy735;
	if (yych == 'e') goto yy735;
	goto yy37;
yy601:
	yych = *++cur;
	if (yych == 'S') goto yy736;
	if (yych == 's') goto yy736;
	goto yy37;
yy602:
	yych = *++cur;
	if (yych == 'F') goto yy737;
	if (yych == 'f') goto yy737;
	goto yy37;
yy603:
	yych = *++cur;
	if (yych == 'T') goto yy738;
	if (yych == 't') goto yy738;
	goto yy37;
yy604:
	yych = *++cur;
	if (yych == 'N') goto yy739;
	if (yych == 'n') goto yy739;
	goto yy37;
yy605:
	yych = *++cur;
	if (yych == 'E') goto yy740;
	if (yych == 'e') goto yy740;
	goto yy37;
yy606:
	yych = *++cur;
	if (yych == 'E') goto yy741;
	if (yych == 'e') goto yy741;
	goto yy37;
yy607:
	yych = *++cur;
	if (yych == 'S') goto yy742;
	if (yych == 's') goto yy742;
	goto yy37;
yy608:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 454 "parser/tokenizer.re"
	{ KW(PRINT) }
#line 5357 "parser/tokenizer.cpp"
yy609:
	yych = *++cur;
	if (yych == 'T') goto yy743;
	if (yych == 't') goto yy743;
	goto yy37;
yy610:
	yych = *++cur;
	if (yych == 'D') goto yy744;
	if (yych == 'd') goto yy744;
	goto yy37;
yy611:
	yych = *++cur;
	if (yych == 'A') goto yy745;
	if (yych == 'a') goto yy745;
	goto yy37;
yy612:
	yych = *++cur;
	if (yych == 'C') goto yy746;
	if (yych == 'c') goto yy746;
	goto yy37;
yy613:
	yych = *++cur;
	if (yych == 'C') goto yy747;
	if (yych == 'c') goto yy747;
	goto yy37;
yy614:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 461 "parser/tokenizer.re"
	{ KW(QUIET) }
#line 5391 "parser/tokenizer.cpp"
yy615:
	yych = *++cur;
	if (yych == 'S') goto yy748;
	if (yych == 's') goto yy748;
	goto yy37;
yy616:
	yych = *++cur;
	if (yych == 'E') goto yy749;
	if (yych == 'e') goto yy749;
	goto yy37;
yy617:
	yych = *++cur;
	if (yych == 'R') goto yy750;
	if (yych == 'r') goto yy750;
	goto yy37;
yy618:
	yych = *++cur;
	if (yych == 'T') goto yy751;
	if (yych == 't') goto yy751;
	goto yy37;
yy619:
	yych = *++cur;
	if (yych == 'N') goto yy752;
	if (yych == 'n') goto yy752;
	goto yy37;
yy620:
	yych = *++cur;
	if (yych == 'D') goto yy753;
	if (yych == 'd') goto yy753;
	goto yy37;
yy621:
	yych = *++cur;
	if (yych == 'T') goto yy754;
	if (yych == 't') goto yy754;
	goto yy37;
yy622:
	yych = *++cur;
	if (yych == 'N') goto yy756;
	if (yych == 'n') goto yy756;
	goto yy37;
yy623:
	yych = *++cur;
	if (yych == 'D') goto yy757;
	if (yych == 'd') goto yy757;
	goto yy37;
yy624:
	yych = *++cur;
	if (yych == 'E') goto yy758;
	if (yych == 'e') goto yy758;
	goto yy37;
yy625:
	yych = *++cur;
	if (yych == 'D') goto yy759;
	if (yych == 'd') goto yy759;
	goto yy37;
yy626:
	yych = *++cur;
	if (yych == 'U') goto yy760;
	if (yych == 'u') goto yy760;
	goto yy37;
yy627:
	yych = *++cur;
	if (yych == 'L') goto yy761;
	if (yych == 'l') goto yy761;
	goto yy37;
yy628:
	yych = *++cur;
	if (yych == 'M') goto yy762;
	if (yych == 'm') goto yy762;
	goto yy37;
yy629:
	yych = *++cur;
	if (yych == 'E') goto yy763;
	if (yych == 'e') goto yy763;
	goto yy37;
yy630:
	yych = *++cur;
	if (yych == 'E') goto yy764;
	if (yych == 'e') goto yy764;
	goto yy37;
yy631:
	yych = *++cur;
	if (yych == 'T') goto yy765;
	if (yych == 't') goto yy765;
	goto yy37;
yy632:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy64;
		if (yych <= '&') goto yy37;
		goto yy74;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy37;
			goto yy766;
		} else {
			if (yych == 'n') goto yy766;
			goto yy37;
		}
	}
yy633:
	yych = *++cur;
	if (yych == 'A') goto yy767;
	if (yych == 'a') goto yy767;
	goto yy37;
yy634:
	yych = *++cur;
	if (yych == 'M') goto yy768;
	if (yych == 'm') goto yy768;
	goto yy37;
yy635:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 498 "parser/tokenizer.re"
	{ KW(VALUE) }
#line 5511 "parser/tokenizer.cpp"
yy636:
	yych = *++cur;
	if (yych == 'I') goto yy769;
	if (yych == 'i') goto yy769;
	goto yy37;
yy637:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 501 "parser/tokenizer.re"
	{ KW(WHERE) }
#line 5525 "parser/tokenizer.cpp"
yy638:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 502 "parser/tokenizer.re"
	{ KW(WHILE) }
#line 5534 "parser/tokenizer.cpp"
yy639:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 503 "parser/tokenizer.re"
	{ KW(WRITE) }
#line 5543 "parser/tokenizer.cpp"
yy640:
	yych = *++cur;
	if (yych == '.') goto yy770;
	goto yy85;
yy641:
	++cur;
#line 579 "parser/tokenizer.re"
	{ RET(TK_NEQV) }
#line 5552 "parser/tokenizer.cpp"
yy642:
	yyaccept = 11;
	yych = *(mar = ++cur);
	if (yych == '_') goto yy772;
yy643:
#line 583 "parser/tokenizer.re"
	{ RET(TK_TRUE) }
#line 5560 "parser/tokenizer.cpp"
yy644:
	yych = *++cur;
	if (yych == 'C') goto yy773;
	if (yych == 'c') goto yy773;
	goto yy37;
yy645:
	yych = *++cur;
	if (yych == 'T') goto yy774;
	if (yych == 't') goto yy774;
	goto yy37;
yy646:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'M') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy647;
			if (yych <= 'L') goto yy36;
			goto yy775;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'm') goto yy775;
			if (yych <= 'z') goto yy36;
		}
	}
yy647:
#line 257 "parser/tokenizer.re"
	{ KW(ASSIGN) }
#line 5596 "parser/tokenizer.cpp"
yy648:
	yych = *++cur;
	if (yych == 'A') goto yy776;
	if (yych == 'a') goto yy776;
	goto yy37;
yy649:
	yych = *++cur;
	if (yych == 'R') goto yy777;
	if (yych == 'r') goto yy777;
	goto yy37;
yy650:
	yych = *++cur;
	if (yych == 'A') goto yy778;
	if (yych == 'a') goto yy778;
	goto yy37;
yy651:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy652;
			if (yych <= 'S') goto yy36;
			goto yy779;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy779;
			if (yych <= 'z') goto yy36;
		}
	}
yy652:
#line 266 "parser/tokenizer.re"
	{ KW(CHANGE) }
#line 5637 "parser/tokenizer.cpp"
yy653:
	yych = *++cur;
	if (yych == 'T') goto yy780;
	if (yych == 't') goto yy780;
	goto yy37;
yy654:
	yych = *++cur;
	if (yych == 'N') goto yy781;
	if (yych == 'n') goto yy781;
	goto yy37;
yy655:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 272 "parser/tokenizer.re"
	{ KW(COMMON) }
#line 5656 "parser/tokenizer.cpp"
yy656:
	yych = *++cur;
	if (yych == 'X') goto yy782;
	if (yych == 'x') goto yy782;
	goto yy37;
yy657:
	yych = *++cur;
	if (yych == 'R') goto yy783;
	if (yych == 'r') goto yy783;
	goto yy37;
yy658:
	yych = *++cur;
	if (yych == 'N') goto yy784;
	if (yych == 'n') goto yy784;
	goto yy37;
yy659:
	yych = *++cur;
	if (yych == 'U') goto yy785;
	if (yych == 'u') goto yy785;
	goto yy37;
yy660:
	yych = *++cur;
	if (yych == 'U') goto yy786;
	if (yych == 'u') goto yy786;
	goto yy37;
yy661:
	yych = *++cur;
	if (yych == 'A') goto yy787;
	if (yych == 'a') goto yy787;
	goto yy37;
yy662:
	yych = *++cur;
	if (yych == 'C') goto yy788;
	if (yych == 'c') goto yy788;
	goto yy37;
yy663:
	yych = *++cur;
	if (yych == 'T') goto yy789;
	if (yych == 't') goto yy789;
	goto yy37;
yy664:
	yych = *++cur;
	if (yych == 'E') goto yy790;
	if (yych == 'e') goto yy790;
	goto yy37;
yy665:
	yych = *++cur;
	if (yych == 'I') goto yy791;
	if (yych == 'i') goto yy791;
	goto yy37;
yy666:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'P') {
		if (yych <= '@') {
			if (yych <= '/') goto yy667;
			if (yych <= '9') goto yy36;
		} else {
			if (yych == 'C') goto yy792;
			if (yych <= 'O') goto yy36;
			goto yy793;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy36;
			if (yych <= '`') goto yy667;
			if (yych <= 'b') goto yy36;
			goto yy792;
		} else {
			if (yych == 'p') goto yy793;
			if (yych <= 'z') goto yy36;
		}
	}
yy667:
#line 294 "parser/tokenizer.re"
	{ KW(DOUBLE) }
#line 5735 "parser/tokenizer.cpp"
yy668:
	yych = *++cur;
	if (yych == 'E') goto yy794;
	if (yych == 'e') goto yy794;
	goto yy37;
yy669:
	yych = *++cur;
	if (yych == 'T') goto yy795;
	if (yych == 't') goto yy795;
	goto yy37;
yy670:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 299 "parser/tokenizer.re"
	{ KW(ELSEIF) }
#line 5754 "parser/tokenizer.cpp"
yy671:
	yych = *++cur;
	if (yych == 'E') goto yy796;
	if (yych == 'e') goto yy796;
	goto yy37;
yy672:
	yych = *++cur;
	if (yych == 'S') goto yy797;
	if (yych == 's') goto yy797;
	goto yy61;
yy673:
	yych = *++cur;
	if (yych == 'O') goto yy798;
	if (yych == 'o') goto yy798;
	goto yy61;
yy674:
	yych = *++cur;
	if (yych == 'I') goto yy799;
	if (yych == 'i') goto yy799;
	goto yy61;
yy675:
	++cur;
#line 357 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    KW(CONTINUE)
                } else {
                    KW(END_DO)
                }
            }
#line 5785 "parser/tokenizer.cpp"
yy676:
	yych = *++cur;
	if (yych == 'U') goto yy800;
	if (yych == 'u') goto yy800;
	goto yy61;
yy677:
	yych = *++cur;
	if (yych == 'R') goto yy801;
	if (yych == 'r') goto yy801;
	goto yy61;
yy678:
	yych = *++cur;
	if (yych == 'N') goto yy802;
	if (yych == 'n') goto yy802;
	goto yy61;
yy679:
	++cur;
#line 348 "parser/tokenizer.re"
	{ KW(END_IF) }
#line 5805 "parser/tokenizer.cpp"
yy680:
	yych = *++cur;
	if (yych == 'T') goto yy803;
	if (yych == 't') goto yy803;
	goto yy61;
yy681:
	yych = *++cur;
	if (yych == 'D') goto yy804;
	if (yych == 'd') goto yy804;
	goto yy61;
yy682:
	yych = *++cur;
	if (yych == 'O') goto yy805;
	if (yych == 'o') goto yy805;
	goto yy61;
yy683:
	yych = *++cur;
	if (yych == 'L') goto yy806;
	if (yych == 'l') goto yy806;
	goto yy61;
yy684:
	yych = *++cur;
	if (yych == 'B') goto yy807;
	if (yych == 'b') goto yy807;
	goto yy61;
yy685:
	yych = *++cur;
	if (yych == 'A') goto yy808;
	if (yych == 'a') goto yy808;
	goto yy61;
yy686:
	yych = *++cur;
	if (yych == 'P') goto yy809;
	if (yych == 'p') goto yy809;
	goto yy61;
yy687:
	yych = *++cur;
	if (yych == 'E') goto yy810;
	if (yych == 'e') goto yy810;
	goto yy61;
yy688:
	yych = *++cur;
	if (yych == 'L') goto yy811;
	if (yych == 'l') goto yy811;
	goto yy61;
yy689:
	yych = *++cur;
	if (yych == 'O') goto yy812;
	if (yych == 'o') goto yy812;
	goto yy37;
yy690:
	yych = *++cur;
	if (yych == 'C') goto yy813;
	if (yych == 'c') goto yy813;
	goto yy37;
yy691:
	yych = *++cur;
	if (yych == 'T') goto yy814;
	if (yych == 't') goto yy814;
	goto yy37;
yy692:
	yych = *++cur;
	if (yych == 'M') goto yy815;
	if (yych == 'm') goto yy815;
	goto yy37;
yy693:
	yych = *++cur;
	if (yych == 'E') goto yy816;
	if (yych == 'e') goto yy816;
	goto yy37;
yy694:
	yych = *++cur;
	if (yych == 'A') goto yy817;
	if (yych == 'a') goto yy817;
	goto yy37;
yy695:
	yych = *++cur;
	if (yych == 'C') goto yy818;
	if (yych == 'c') goto yy818;
	goto yy37;
yy696:
	yych = *++cur;
	if (yych == 'E') goto yy819;
	if (yych == 'e') goto yy819;
	goto yy37;
yy697:
	yych = *++cur;
	if (yych == 'U') goto yy820;
	if (yych == 'u') goto yy820;
	goto yy37;
yy698:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy821;
		if (yych <= 'F') goto yy37;
		goto yy822;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy821;
		} else {
			if (yych == 'g') goto yy822;
			goto yy37;
		}
	}
yy699:
	yych = *++cur;
	if (yych == 'E') goto yy823;
	if (yych == 'e') goto yy823;
	goto yy37;
yy700:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy824;
		if (yych <= 'Q') goto yy37;
		goto yy825;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy824;
		} else {
			if (yych == 'r') goto yy825;
			goto yy37;
		}
	}
yy701:
	yych = *++cur;
	if (yych == 'M') goto yy826;
	if (yych == 'm') goto yy826;
	goto yy37;
yy702:
	yych = *++cur;
	if (yych == 'E') goto yy827;
	if (yych == 'e') goto yy827;
	goto yy37;
yy703:
	yych = *++cur;
	if (yych == 'R') goto yy828;
	if (yych == 'r') goto yy828;
	goto yy37;
yy704:
	yych = *++cur;
	if (yych == 'A') goto yy829;
	if (yych == 'a') goto yy829;
	goto yy37;
yy705:
	yych = *++cur;
	if (yych == 'L') goto yy830;
	if (yych == 'l') goto yy830;
	goto yy37;
yy706:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 382 "parser/tokenizer.re"
	{ KW(ERRMSG) }
#line 5964 "parser/tokenizer.cpp"
yy707:
	yych = *++cur;
	if (yych == 'S') goto yy831;
	if (yych == 's') goto yy831;
	goto yy37;
yy708:
	yych = *++cur;
	if (yych == 'A') goto yy832;
	if (yych == 'a') goto yy832;
	goto yy37;
yy709:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 391 "parser/tokenizer.re"
	{ KW(FORALL) }
#line 5983 "parser/tokenizer.cpp"
yy710:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy711;
			if (yych <= 'S') goto yy36;
			goto yy833;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy833;
			if (yych <= 'z') goto yy36;
		}
	}
yy711:
#line 392 "parser/tokenizer.re"
	{
                if (last_token == yytokentype::TK_LABEL) {
                    unsigned char *start;
                    lex_format(cur, loc, start);
                    yylval.string.p = (char*) start;
                    yylval.string.n = cur-start-1;
                    RET(TK_FORMAT)
                } else {
                    token(yylval.string);
                    RET(TK_NAME)
                }
            }
#line 6020 "parser/tokenizer.cpp"
yy712:
	yych = *++cur;
	if (yych == 'A') goto yy834;
	if (yych == 'a') goto yy834;
	goto yy37;
yy713:
	yych = *++cur;
	if (yych == 'O') goto yy835;
	if (yych == 'o') goto yy835;
	goto yy37;
yy714:
	yych = *++cur;
	if (yych == 'C') goto yy836;
	if (yych == 'c') goto yy836;
	goto yy37;
yy715:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 412 "parser/tokenizer.re"
	{ KW(IMAGES) }
#line 6044 "parser/tokenizer.cpp"
yy716:
	yych = *++cur;
	if (yych == 'I') goto yy837;
	if (yych == 'i') goto yy837;
	goto yy37;
yy717:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 414 "parser/tokenizer.re"
	{ KW(IMPORT) }
#line 6058 "parser/tokenizer.cpp"
yy718:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 415 "parser/tokenizer.re"
	{ KW(IMPURE) }
#line 6067 "parser/tokenizer.cpp"
yy719:
	++cur;
#line 419 "parser/tokenizer.re"
	{ KW(IN_OUT) }
#line 6072 "parser/tokenizer.cpp"
yy720:
	yych = *++cur;
	if (yych == 'E') goto yy838;
	if (yych == 'e') goto yy838;
	goto yy37;
yy721:
	yych = *++cur;
	if (yych == 'E') goto yy839;
	if (yych == 'e') goto yy839;
	goto yy37;
yy722:
	yych = *++cur;
	if (yych == 'T') goto yy840;
	if (yych == 't') goto yy840;
	goto yy37;
yy723:
	yych = *++cur;
	if (yych == 'R') goto yy841;
	if (yych == 'r') goto yy841;
	goto yy37;
yy724:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 423 "parser/tokenizer.re"
	{ KW(INTENT) }
#line 6101 "parser/tokenizer.cpp"
yy725:
	yych = *++cur;
	if (yych == 'A') goto yy842;
	if (yych == 'a') goto yy842;
	goto yy37;
yy726:
	yych = *++cur;
	if (yych == 'S') goto yy843;
	if (yych == 's') goto yy843;
	goto yy37;
yy727:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy64;
		if (yych <= '&') goto yy37;
		goto yy74;
	} else {
		if (yych <= 'I') {
			if (yych <= 'H') goto yy37;
			goto yy844;
		} else {
			if (yych == 'i') goto yy844;
			goto yy37;
		}
	}
yy728:
	yych = *++cur;
	if (yych == 'L') goto yy845;
	if (yych == 'l') goto yy845;
	goto yy37;
yy729:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 432 "parser/tokenizer.re"
	{ KW(MEMORY) }
#line 6141 "parser/tokenizer.cpp"
yy730:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 433 "parser/tokenizer.re"
	{ KW(MODULE) }
#line 6150 "parser/tokenizer.cpp"
yy731:
	yych = *++cur;
	if (yych == 'S') goto yy846;
	if (yych == 's') goto yy846;
	goto yy37;
yy732:
	yych = *++cur;
	if (yych == 'D') goto yy847;
	if (yych == 'd') goto yy847;
	goto yy37;
yy733:
	yych = *++cur;
	if (yych == 'T') goto yy848;
	if (yych == 't') goto yy848;
	goto yy37;
yy734:
	yych = *++cur;
	if (yych == 'E') goto yy849;
	if (yych == 'e') goto yy849;
	goto yy37;
yy735:
	yych = *++cur;
	if (yych == 'C') goto yy850;
	if (yych == 'c') goto yy850;
	goto yy37;
yy736:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 438 "parser/tokenizer.re"
	{ KW(NOPASS) }
#line 6184 "parser/tokenizer.cpp"
yy737:
	yych = *++cur;
	if (yych == 'Y') goto yy851;
	if (yych == 'y') goto yy851;
	goto yy37;
yy738:
	yych = *++cur;
	if (yych == 'O') goto yy852;
	if (yych == 'o') goto yy852;
	goto yy37;
yy739:
	yych = *++cur;
	if (yych == 'A') goto yy853;
	if (yych == 'a') goto yy853;
	goto yy37;
yy740:
	yych = *++cur;
	if (yych == 'T') goto yy854;
	if (yych == 't') goto yy854;
	goto yy37;
yy741:
	yych = *++cur;
	if (yych == 'R') goto yy855;
	if (yych == 'r') goto yy855;
	goto yy37;
yy742:
	yych = *++cur;
	if (yych == 'I') goto yy856;
	if (yych == 'i') goto yy856;
	goto yy37;
yy743:
	yych = *++cur;
	if (yych == 'E') goto yy857;
	if (yych == 'e') goto yy857;
	goto yy37;
yy744:
	yych = *++cur;
	if (yych == 'U') goto yy858;
	if (yych == 'u') goto yy858;
	goto yy37;
yy745:
	yych = *++cur;
	if (yych == 'M') goto yy859;
	if (yych == 'm') goto yy859;
	goto yy37;
yy746:
	yych = *++cur;
	if (yych == 'T') goto yy860;
	if (yych == 't') goto yy860;
	goto yy37;
yy747:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 459 "parser/tokenizer.re"
	{ KW(PUBLIC) }
#line 6243 "parser/tokenizer.cpp"
yy748:
	yych = *++cur;
	if (yych == 'I') goto yy861;
	if (yych == 'i') goto yy861;
	goto yy37;
yy749:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 466 "parser/tokenizer.re"
	{ KW(REDUCE) }
#line 6257 "parser/tokenizer.cpp"
yy750:
	yych = *++cur;
	if (yych == 'E') goto yy862;
	if (yych == 'e') goto yy862;
	goto yy37;
yy751:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 469 "parser/tokenizer.re"
	{ KW(RESULT) }
#line 6271 "parser/tokenizer.cpp"
yy752:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 470 "parser/tokenizer.re"
	{ KW(RETURN) }
#line 6280 "parser/tokenizer.cpp"
yy753:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 471 "parser/tokenizer.re"
	{ KW(REWIND) }
#line 6289 "parser/tokenizer.cpp"
yy754:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'T') {
		if (yych <= 'B') {
			if (yych <= '/') goto yy755;
			if (yych <= '9') goto yy36;
			if (yych >= 'A') goto yy36;
		} else {
			if (yych <= 'Q') {
				if (yych <= 'C') goto yy864;
				goto yy36;
			} else {
				if (yych <= 'R') goto yy865;
				if (yych <= 'S') goto yy36;
				goto yy866;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy36;
			} else {
				if (yych == 'c') goto yy864;
				goto yy36;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'r') goto yy865;
				goto yy36;
			} else {
				if (yych <= 't') goto yy866;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy755:
#line 473 "parser/tokenizer.re"
	{ KW(SELECT) }
#line 6331 "parser/tokenizer.cpp"
yy756:
	yych = *++cur;
	if (yych == 'C') goto yy867;
	if (yych == 'c') goto yy867;
	goto yy37;
yy757:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 478 "parser/tokenizer.re"
	{ KW(SHARED) }
#line 6345 "parser/tokenizer.cpp"
yy758:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 479 "parser/tokenizer.re"
	{ KW(SOURCE) }
#line 6354 "parser/tokenizer.cpp"
yy759:
	yych = *++cur;
	if (yych == 'U') goto yy868;
	if (yych == 'u') goto yy868;
	goto yy37;
yy760:
	yych = *++cur;
	if (yych == 'T') goto yy869;
	if (yych == 't') goto yy869;
	goto yy37;
yy761:
	yych = *++cur;
	if (yych == 'L') goto yy870;
	if (yych == 'l') goto yy870;
	goto yy37;
yy762:
	yych = *++cur;
	if (yych == 'A') goto yy871;
	if (yych == 'a') goto yy871;
	goto yy37;
yy763:
	yych = *++cur;
	if (yych == 'M') goto yy872;
	if (yych == 'm') goto yy872;
	goto yy37;
yy764:
	yych = *++cur;
	if (yych == 'A') goto yy873;
	if (yych == 'a') goto yy873;
	goto yy37;
yy765:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 489 "parser/tokenizer.re"
	{ KW(TARGET) }
#line 6393 "parser/tokenizer.cpp"
yy766:
	yych = *++cur;
	if (yych == 'U') goto yy874;
	if (yych == 'u') goto yy874;
	goto yy37;
yy767:
	yych = *++cur;
	if (yych == 'T') goto yy875;
	if (yych == 't') goto yy875;
	goto yy37;
yy768:
	yych = *++cur;
	if (yych == 'A') goto yy876;
	if (yych == 'a') goto yy876;
	goto yy37;
yy769:
	yych = *++cur;
	if (yych == 'L') goto yy877;
	if (yych == 'l') goto yy877;
	goto yy37;
yy770:
	yyaccept = 12;
	yych = *(mar = ++cur);
	if (yych == '_') goto yy878;
yy771:
#line 584 "parser/tokenizer.re"
	{ RET(TK_FALSE) }
#line 6421 "parser/tokenizer.cpp"
yy772:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy879;
		if (yych <= '@') goto yy61;
		goto yy880;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy61;
			goto yy880;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy880;
			goto yy61;
		}
	}
yy773:
	yych = *++cur;
	if (yych == 'T') goto yy881;
	if (yych == 't') goto yy881;
	goto yy37;
yy774:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy882;
		if (yych <= 'D') goto yy37;
		goto yy883;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy882;
		} else {
			if (yych == 'e') goto yy883;
			goto yy37;
		}
	}
yy775:
	yych = *++cur;
	if (yych == 'E') goto yy884;
	if (yych == 'e') goto yy884;
	goto yy37;
yy776:
	yych = *++cur;
	if (yych == 'T') goto yy885;
	if (yych == 't') goto yy885;
	goto yy37;
yy777:
	yych = *++cur;
	if (yych == 'O') goto yy886;
	if (yych == 'o') goto yy886;
	goto yy37;
yy778:
	yych = *++cur;
	if (yych == 'C') goto yy887;
	if (yych == 'c') goto yy887;
	goto yy37;
yy779:
	yych = *++cur;
	if (yych == 'E') goto yy888;
	if (yych == 'e') goto yy888;
	goto yy37;
yy780:
	yych = *++cur;
	if (yych == 'E') goto yy889;
	if (yych == 'e') goto yy889;
	goto yy37;
yy781:
	yych = *++cur;
	if (yych == 'S') goto yy890;
	if (yych == 's') goto yy890;
	goto yy37;
yy782:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 273 "parser/tokenizer.re"
	{ KW(COMPLEX) }
#line 6502 "parser/tokenizer.cpp"
yy783:
	yych = *++cur;
	if (yych == 'E') goto yy891;
	if (yych == 'e') goto yy891;
	goto yy37;
yy784:
	yych = *++cur;
	if (yych == 'S') goto yy892;
	if (yych == 's') goto yy892;
	goto yy37;
yy785:
	yych = *++cur;
	if (yych == 'O') goto yy893;
	if (yych == 'o') goto yy893;
	goto yy37;
yy786:
	yych = *++cur;
	if (yych == 'E') goto yy894;
	if (yych == 'e') goto yy894;
	goto yy37;
yy787:
	yych = *++cur;
	if (yych == 'L') goto yy895;
	if (yych == 'l') goto yy895;
	goto yy37;
yy788:
	yych = *++cur;
	if (yych == 'A') goto yy896;
	if (yych == 'a') goto yy896;
	goto yy37;
yy789:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 282 "parser/tokenizer.re"
	{ KW(DEFAULT) }
#line 6541 "parser/tokenizer.cpp"
yy790:
	yych = *++cur;
	if (yych == 'D') goto yy897;
	if (yych == 'd') goto yy897;
	goto yy37;
yy791:
	yych = *++cur;
	if (yych == 'O') goto yy898;
	if (yych == 'o') goto yy898;
	goto yy37;
yy792:
	yych = *++cur;
	if (yych == 'O') goto yy899;
	if (yych == 'o') goto yy899;
	goto yy37;
yy793:
	yych = *++cur;
	if (yych == 'R') goto yy900;
	if (yych == 'r') goto yy900;
	goto yy37;
yy794:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 293 "parser/tokenizer.re"
	{ KW(DOWHILE) }
#line 6570 "parser/tokenizer.cpp"
yy795:
	yych = *++cur;
	if (yych == 'A') goto yy901;
	if (yych == 'a') goto yy901;
	goto yy37;
yy796:
	yych = *++cur;
	if (yych == 'R') goto yy902;
	if (yych == 'r') goto yy902;
	goto yy37;
yy797:
	yych = *++cur;
	if (yych == 'O') goto yy903;
	if (yych == 'o') goto yy903;
	goto yy61;
yy798:
	yych = *++cur;
	if (yych == 'C') goto yy904;
	if (yych == 'c') goto yy904;
	goto yy61;
yy799:
	yych = *++cur;
	if (yych == 'T') goto yy905;
	if (yych == 't') goto yy905;
	goto yy61;
yy800:
	yych = *++cur;
	if (yych == 'M') goto yy906;
	if (yych == 'm') goto yy906;
	goto yy61;
yy801:
	yych = *++cur;
	if (yych == 'A') goto yy907;
	if (yych == 'a') goto yy907;
	goto yy61;
yy802:
	yych = *++cur;
	if (yych == 'C') goto yy908;
	if (yych == 'c') goto yy908;
	goto yy61;
yy803:
	yych = *++cur;
	if (yych == 'E') goto yy909;
	if (yych == 'e') goto yy909;
	goto yy61;
yy804:
	yych = *++cur;
	if (yych == 'U') goto yy910;
	if (yych == 'u') goto yy910;
	goto yy61;
yy805:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy911;
		if (yych <= 'F') goto yy61;
		goto yy912;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy61;
			goto yy911;
		} else {
			if (yych == 'g') goto yy912;
			goto yy61;
		}
	}
yy806:
	yych = *++cur;
	if (yych == 'E') goto yy913;
	if (yych == 'e') goto yy913;
	goto yy61;
yy807:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy914;
		if (yych <= 'Q') goto yy61;
		goto yy915;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy61;
			goto yy914;
		} else {
			if (yych == 'r') goto yy915;
			goto yy61;
		}
	}
yy808:
	yych = *++cur;
	if (yych == 'M') goto yy916;
	if (yych == 'm') goto yy916;
	goto yy61;
yy809:
	yych = *++cur;
	if (yych == 'E') goto yy917;
	if (yych == 'e') goto yy917;
	goto yy61;
yy810:
	yych = *++cur;
	if (yych == 'R') goto yy918;
	if (yych == 'r') goto yy918;
	goto yy61;
yy811:
	yych = *++cur;
	if (yych == 'E') goto yy919;
	if (yych == 'e') goto yy919;
	goto yy61;
yy812:
	yych = *++cur;
	if (yych == 'C') goto yy920;
	if (yych == 'c') goto yy920;
	goto yy37;
yy813:
	yych = *++cur;
	if (yych == 'K') goto yy921;
	if (yych == 'k') goto yy921;
	goto yy37;
yy814:
	yych = *++cur;
	if (yych == 'I') goto yy923;
	if (yych == 'i') goto yy923;
	goto yy37;
yy815:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 331 "parser/tokenizer.re"
	{ KW(ENDENUM) }
#line 6699 "parser/tokenizer.cpp"
yy816:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 376 "parser/tokenizer.re"
	{ KW(ENDFILE) }
#line 6708 "parser/tokenizer.cpp"
yy817:
	yych = *++cur;
	if (yych == 'L') goto yy924;
	if (yych == 'l') goto yy924;
	goto yy37;
yy818:
	yych = *++cur;
	if (yych == 'T') goto yy925;
	if (yych == 't') goto yy925;
	goto yy37;
yy819:
	yych = *++cur;
	if (yych == 'R') goto yy926;
	if (yych == 'r') goto yy926;
	goto yy37;
yy820:
	yych = *++cur;
	if (yych == 'L') goto yy927;
	if (yych == 'l') goto yy927;
	goto yy37;
yy821:
	yych = *++cur;
	if (yych == 'E') goto yy928;
	if (yych == 'e') goto yy928;
	goto yy37;
yy822:
	yych = *++cur;
	if (yych == 'R') goto yy929;
	if (yych == 'r') goto yy929;
	goto yy37;
yy823:
	yych = *++cur;
	if (yych == 'C') goto yy930;
	if (yych == 'c') goto yy930;
	goto yy37;
yy824:
	yych = *++cur;
	if (yych == 'O') goto yy931;
	if (yych == 'o') goto yy931;
	goto yy37;
yy825:
	yych = *++cur;
	if (yych == 'O') goto yy932;
	if (yych == 'o') goto yy932;
	goto yy37;
yy826:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 343 "parser/tokenizer.re"
	{ KW(ENDTEAM) }
#line 6762 "parser/tokenizer.cpp"
yy827:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 355 "parser/tokenizer.re"
	{ KW(ENDTYPE) }
#line 6771 "parser/tokenizer.cpp"
yy828:
	yych = *++cur;
	if (yych == 'E') goto yy933;
	if (yych == 'e') goto yy933;
	goto yy37;
yy829:
	yych = *++cur;
	if (yych == 'T') goto yy934;
	if (yych == 't') goto yy934;
	goto yy37;
yy830:
	yych = *++cur;
	if (yych == 'E') goto yy935;
	if (yych == 'e') goto yy935;
	goto yy37;
yy831:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 386 "parser/tokenizer.re"
	{ KW(EXTENDS) }
#line 6795 "parser/tokenizer.cpp"
yy832:
	yych = *++cur;
	if (yych == 'L') goto yy936;
	if (yych == 'l') goto yy936;
	goto yy37;
yy833:
	yych = *++cur;
	if (yych == 'E') goto yy937;
	if (yych == 'e') goto yy937;
	goto yy37;
yy834:
	yych = *++cur;
	if (yych == 'M') goto yy938;
	if (yych == 'm') goto yy938;
	goto yy37;
yy835:
	yych = *++cur;
	if (yych == 'N') goto yy939;
	if (yych == 'n') goto yy939;
	goto yy37;
yy836:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 408 "parser/tokenizer.re"
	{ KW(GENERIC) }
#line 6824 "parser/tokenizer.cpp"
yy837:
	yych = *++cur;
	if (yych == 'T') goto yy940;
	if (yych == 't') goto yy940;
	goto yy37;
yy838:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 417 "parser/tokenizer.re"
	{ KW(INCLUDE) }
#line 6838 "parser/tokenizer.cpp"
yy839:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 420 "parser/tokenizer.re"
	{ KW(INQUIRE) }
#line 6847 "parser/tokenizer.cpp"
yy840:
	yych = *++cur;
	if (yych == 'I') goto yy941;
	if (yych == 'i') goto yy941;
	goto yy37;
yy841:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 422 "parser/tokenizer.re"
	{ KW(INTEGER) }
#line 6861 "parser/tokenizer.cpp"
yy842:
	yych = *++cur;
	if (yych == 'C') goto yy942;
	if (yych == 'c') goto yy942;
	goto yy37;
yy843:
	yych = *++cur;
	if (yych == 'I') goto yy943;
	if (yych == 'i') goto yy943;
	goto yy37;
yy844:
	yych = *++cur;
	if (yych == 'N') goto yy944;
	if (yych == 'n') goto yy944;
	goto yy37;
yy845:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 431 "parser/tokenizer.re"
	{ KW(LOGICAL) }
#line 6885 "parser/tokenizer.cpp"
yy846:
	yych = *++cur;
	if (yych == 'T') goto yy945;
	if (yych == 't') goto yy945;
	goto yy37;
yy847:
	yych = *++cur;
	if (yych == 'E') goto yy946;
	if (yych == 'e') goto yy946;
	goto yy37;
yy848:
	yych = *++cur;
	if (yych == 'R') goto yy947;
	if (yych == 'r') goto yy947;
	goto yy37;
yy849:
	yych = *++cur;
	if (yych == 'R') goto yy948;
	if (yych == 'r') goto yy948;
	goto yy37;
yy850:
	yych = *++cur;
	if (yych == 'U') goto yy949;
	if (yych == 'u') goto yy949;
	goto yy37;
yy851:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 443 "parser/tokenizer.re"
	{ KW(NULLIFY) }
#line 6919 "parser/tokenizer.cpp"
yy852:
	yych = *++cur;
	if (yych == 'R') goto yy950;
	if (yych == 'r') goto yy950;
	goto yy37;
yy853:
	yych = *++cur;
	if (yych == 'L') goto yy951;
	if (yych == 'l') goto yy951;
	goto yy37;
yy854:
	yych = *++cur;
	if (yych == 'E') goto yy952;
	if (yych == 'e') goto yy952;
	goto yy37;
yy855:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 451 "parser/tokenizer.re"
	{ KW(POINTER) }
#line 6943 "parser/tokenizer.cpp"
yy856:
	yych = *++cur;
	if (yych == 'O') goto yy953;
	if (yych == 'o') goto yy953;
	goto yy37;
yy857:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 455 "parser/tokenizer.re"
	{ KW(PRIVATE) }
#line 6957 "parser/tokenizer.cpp"
yy858:
	yych = *++cur;
	if (yych == 'R') goto yy954;
	if (yych == 'r') goto yy954;
	goto yy37;
yy859:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 457 "parser/tokenizer.re"
	{ KW(PROGRAM) }
#line 6971 "parser/tokenizer.cpp"
yy860:
	yych = *++cur;
	if (yych == 'E') goto yy955;
	if (yych == 'e') goto yy955;
	goto yy37;
yy861:
	yych = *++cur;
	if (yych == 'V') goto yy956;
	if (yych == 'v') goto yy956;
	goto yy37;
yy862:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= 'M') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy863;
			if (yych <= 'L') goto yy36;
			goto yy957;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'm') goto yy957;
			if (yych <= 'z') goto yy36;
		}
	}
yy863:
#line 468 "parser/tokenizer.re"
	{ KW(REQUIRE) }
#line 7007 "parser/tokenizer.cpp"
yy864:
	yych = *++cur;
	if (yych == 'A') goto yy958;
	if (yych == 'a') goto yy958;
	goto yy37;
yy865:
	yych = *++cur;
	if (yych == 'A') goto yy959;
	if (yych == 'a') goto yy959;
	goto yy37;
yy866:
	yych = *++cur;
	if (yych == 'Y') goto yy960;
	if (yych == 'y') goto yy960;
	goto yy37;
yy867:
	yych = *++cur;
	if (yych == 'E') goto yy961;
	if (yych == 'e') goto yy961;
	goto yy37;
yy868:
	yych = *++cur;
	if (yych == 'L') goto yy962;
	if (yych == 'l') goto yy962;
	goto yy37;
yy869:
	yych = *++cur;
	if (yych == 'I') goto yy963;
	if (yych == 'i') goto yy963;
	goto yy37;
yy870:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 485 "parser/tokenizer.re"
	{ KW(SYNC_ALL) }
#line 7046 "parser/tokenizer.cpp"
yy871:
	yych = *++cur;
	if (yych == 'G') goto yy964;
	if (yych == 'g') goto yy964;
	goto yy37;
yy872:
	yych = *++cur;
	if (yych == 'O') goto yy965;
	if (yych == 'o') goto yy965;
	goto yy37;
yy873:
	yych = *++cur;
	if (yych == 'M') goto yy966;
	if (yych == 'm') goto yy966;
	goto yy37;
yy874:
	yych = *++cur;
	if (yych == 'M') goto yy967;
	if (yych == 'm') goto yy967;
	goto yy37;
yy875:
	yych = *++cur;
	if (yych == 'E') goto yy968;
	if (yych == 'e') goto yy968;
	goto yy37;
yy876:
	yych = *++cur;
	if (yych == 'T') goto yy969;
	if (yych == 't') goto yy969;
	goto yy37;
yy877:
	yych = *++cur;
	if (yych == 'E') goto yy970;
	if (yych == 'e') goto yy970;
	goto yy37;
yy878:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy971;
		if (yych <= '@') goto yy61;
		goto yy972;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy61;
			goto yy972;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy972;
			goto yy61;
		}
	}
yy879:
	yych = *++cur;
	if (yych <= '/') goto yy643;
	if (yych <= '9') goto yy879;
	goto yy643;
yy880:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy643;
		if (yych <= '9') goto yy880;
		if (yych <= '@') goto yy643;
		goto yy880;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy643;
			goto yy880;
		} else {
			if (yych <= '`') goto yy643;
			if (yych <= 'z') goto yy880;
			goto yy643;
		}
	}
yy881:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 253 "parser/tokenizer.re"
	{ KW(ABSTRACT) }
#line 7129 "parser/tokenizer.cpp"
yy882:
	yych = *++cur;
	if (yych == 'B') goto yy973;
	if (yych == 'b') goto yy973;
	goto yy37;
yy883:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 256 "parser/tokenizer.re"
	{ KW(ALLOCATE) }
#line 7143 "parser/tokenizer.cpp"
yy884:
	yych = *++cur;
	if (yych == 'N') goto yy974;
	if (yych == 'n') goto yy974;
	goto yy37;
yy885:
	yych = *++cur;
	if (yych == 'E') goto yy975;
	if (yych == 'e') goto yy975;
	goto yy37;
yy886:
	yych = *++cur;
	if (yych == 'N') goto yy976;
	if (yych == 'n') goto yy976;
	goto yy37;
yy887:
	yych = *++cur;
	if (yych == 'E') goto yy977;
	if (yych == 'e') goto yy977;
	goto yy37;
yy888:
	yych = *++cur;
	if (yych == 'A') goto yy978;
	if (yych == 'a') goto yy978;
	goto yy37;
yy889:
	yych = *++cur;
	if (yych == 'R') goto yy979;
	if (yych == 'r') goto yy979;
	goto yy37;
yy890:
	yych = *++cur;
	if (yych == 'I') goto yy980;
	if (yych == 'i') goto yy980;
	goto yy37;
yy891:
	yych = *++cur;
	if (yych == 'N') goto yy981;
	if (yych == 'n') goto yy981;
	goto yy37;
yy892:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 275 "parser/tokenizer.re"
	{ KW(CONTAINS) }
#line 7192 "parser/tokenizer.cpp"
yy893:
	yych = *++cur;
	if (yych == 'U') goto yy982;
	if (yych == 'u') goto yy982;
	goto yy37;
yy894:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 277 "parser/tokenizer.re"
	{ KW(CONTINUE) }
#line 7206 "parser/tokenizer.cpp"
yy895:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 278 "parser/tokenizer.re"
	{ KW(CRITICAL) }
#line 7215 "parser/tokenizer.cpp"
yy896:
	yych = *++cur;
	if (yych == 'T') goto yy983;
	if (yych == 't') goto yy983;
	goto yy37;
yy897:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 283 "parser/tokenizer.re"
	{ KW(DEFERRED) }
#line 7229 "parser/tokenizer.cpp"
yy898:
	yych = *++cur;
	if (yych == 'N') goto yy984;
	if (yych == 'n') goto yy984;
	goto yy37;
yy899:
	yych = *++cur;
	if (yych == 'M') goto yy985;
	if (yych == 'm') goto yy985;
	goto yy37;
yy900:
	yych = *++cur;
	if (yych == 'E') goto yy986;
	if (yych == 'e') goto yy986;
	goto yy37;
yy901:
	yych = *++cur;
	if (yych == 'L') goto yy987;
	if (yych == 'l') goto yy987;
	goto yy37;
yy902:
	yych = *++cur;
	if (yych == 'E') goto yy988;
	if (yych == 'e') goto yy988;
	goto yy37;
yy903:
	yych = *++cur;
	if (yych == 'C') goto yy989;
	if (yych == 'c') goto yy989;
	goto yy61;
yy904:
	yych = *++cur;
	if (yych == 'K') goto yy990;
	if (yych == 'k') goto yy990;
	goto yy61;
yy905:
	yych = *++cur;
	if (yych == 'I') goto yy992;
	if (yych == 'i') goto yy992;
	goto yy61;
yy906:
	++cur;
#line 330 "parser/tokenizer.re"
	{ KW(END_ENUM) }
#line 7274 "parser/tokenizer.cpp"
yy907:
	yych = *++cur;
	if (yych == 'L') goto yy993;
	if (yych == 'l') goto yy993;
	goto yy61;
yy908:
	yych = *++cur;
	if (yych == 'T') goto yy994;
	if (yych == 't') goto yy994;
	goto yy61;
yy909:
	yych = *++cur;
	if (yych == 'R') goto yy995;
	if (yych == 'r') goto yy995;
	goto yy61;
yy910:
	yych = *++cur;
	if (yych == 'L') goto yy996;
	if (yych == 'l') goto yy996;
	goto yy61;
yy911:
	yych = *++cur;
	if (yych == 'E') goto yy997;
	if (yych == 'e') goto yy997;
	goto yy61;
yy912:
	yych = *++cur;
	if (yych == 'R') goto yy998;
	if (yych == 'r') goto yy998;
	goto yy61;
yy913:
	yych = *++cur;
	if (yych == 'C') goto yy999;
	if (yych == 'c') goto yy999;
	goto yy61;
yy914:
	yych = *++cur;
	if (yych == 'O') goto yy1000;
	if (yych == 'o') goto yy1000;
	goto yy61;
yy915:
	yych = *++cur;
	if (yych == 'O') goto yy1001;
	if (yych == 'o') goto yy1001;
	goto yy61;
yy916:
	++cur;
#line 342 "parser/tokenizer.re"
	{ KW(END_TEAM) }
#line 7324 "parser/tokenizer.cpp"
yy917:
	++cur;
#line 354 "parser/tokenizer.re"
	{ KW(END_TYPE) }
#line 7329 "parser/tokenizer.cpp"
yy918:
	yych = *++cur;
	if (yych == 'E') goto yy1002;
	if (yych == 'e') goto yy1002;
	goto yy61;
yy919:
	++cur;
#line 375 "parser/tokenizer.re"
	{ KW(END_FILE) }
#line 7339 "parser/tokenizer.cpp"
yy920:
	yych = *++cur;
	if (yych == 'I') goto yy1003;
	if (yych == 'i') goto yy1003;
	goto yy37;
yy921:
	yyaccept = 13;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy109;
	}
	if (yych <= '/') {
		if (yych <= '\v') {
			if (yych == '\t') goto yy1004;
			if (yych >= '\v') goto yy1004;
		} else {
			if (yych <= '\r') {
				if (yych >= '\r') goto yy1004;
			} else {
				if (yych == ' ') goto yy1004;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy36;
			} else {
				if (yych == 'D') goto yy1005;
				goto yy36;
			}
		} else {
			if (yych <= 'c') {
				if (yych >= 'a') goto yy36;
			} else {
				if (yych <= 'd') goto yy1005;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy922:
#line 314 "parser/tokenizer.re"
	{ KW(ENDBLOCK) }
#line 7382 "parser/tokenizer.cpp"
yy923:
	yych = *++cur;
	if (yych == 'C') goto yy1006;
	if (yych == 'c') goto yy1006;
	goto yy37;
yy924:
	yych = *++cur;
	if (yych == 'L') goto yy1007;
	if (yych == 'l') goto yy1007;
	goto yy37;
yy925:
	yych = *++cur;
	if (yych == 'I') goto yy1008;
	if (yych == 'i') goto yy1008;
	goto yy37;
yy926:
	yych = *++cur;
	if (yych == 'F') goto yy1009;
	if (yych == 'f') goto yy1009;
	goto yy37;
yy927:
	yych = *++cur;
	if (yych == 'E') goto yy1010;
	if (yych == 'e') goto yy1010;
	goto yy37;
yy928:
	yych = *++cur;
	if (yych == 'D') goto yy1011;
	if (yych == 'd') goto yy1011;
	goto yy37;
yy929:
	yych = *++cur;
	if (yych == 'A') goto yy1012;
	if (yych == 'a') goto yy1012;
	goto yy37;
yy930:
	yych = *++cur;
	if (yych == 'T') goto yy1013;
	if (yych == 't') goto yy1013;
	goto yy37;
yy931:
	yych = *++cur;
	if (yych == 'D') goto yy1014;
	if (yych == 'd') goto yy1014;
	goto yy37;
yy932:
	yych = *++cur;
	if (yych == 'U') goto yy1015;
	if (yych == 'u') goto yy1015;
	goto yy37;
yy933:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 373 "parser/tokenizer.re"
	{ KW(ENDWHERE) }
#line 7441 "parser/tokenizer.cpp"
yy934:
	yych = *++cur;
	if (yych == 'O') goto yy1016;
	if (yych == 'o') goto yy1016;
	goto yy37;
yy935:
	yych = *++cur;
	if (yych == 'N') goto yy1017;
	if (yych == 'n') goto yy1017;
	goto yy37;
yy936:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 387 "parser/tokenizer.re"
	{ KW(EXTERNAL) }
#line 7460 "parser/tokenizer.cpp"
yy937:
	yych = *++cur;
	if (yych == 'D') goto yy1018;
	if (yych == 'd') goto yy1018;
	goto yy37;
yy938:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 406 "parser/tokenizer.re"
	{ KW(FORM_TEAM) }
#line 7474 "parser/tokenizer.cpp"
yy939:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 407 "parser/tokenizer.re"
	{ KW(FUNCTION) }
#line 7483 "parser/tokenizer.cpp"
yy940:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 413 "parser/tokenizer.re"
	{ KW(IMPLICIT) }
#line 7492 "parser/tokenizer.cpp"
yy941:
	yych = *++cur;
	if (yych == 'A') goto yy1019;
	if (yych == 'a') goto yy1019;
	goto yy37;
yy942:
	yych = *++cur;
	if (yych == 'E') goto yy1020;
	if (yych == 'e') goto yy1020;
	goto yy37;
yy943:
	yych = *++cur;
	if (yych == 'C') goto yy1021;
	if (yych == 'c') goto yy1021;
	goto yy37;
yy944:
	yych = *++cur;
	if (yych == 'I') goto yy1022;
	if (yych == 'i') goto yy1022;
	goto yy37;
yy945:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 436 "parser/tokenizer.re"
	{ KW(NAMELIST) }
#line 7521 "parser/tokenizer.cpp"
yy946:
	yych = *++cur;
	if (yych == 'X') goto yy1023;
	if (yych == 'x') goto yy1023;
	goto yy37;
yy947:
	yych = *++cur;
	if (yych == 'I') goto yy1024;
	if (yych == 'i') goto yy1024;
	goto yy37;
yy948:
	yych = *++cur;
	if (yych == 'R') goto yy1025;
	if (yych == 'r') goto yy1025;
	goto yy37;
yy949:
	yych = *++cur;
	if (yych == 'R') goto yy1026;
	if (yych == 'r') goto yy1026;
	goto yy37;
yy950:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 446 "parser/tokenizer.re"
	{ KW(OPERATOR) }
#line 7550 "parser/tokenizer.cpp"
yy951:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 447 "parser/tokenizer.re"
	{ KW(OPTIONAL) }
#line 7559 "parser/tokenizer.cpp"
yy952:
	yych = *++cur;
	if (yych == 'R') goto yy1027;
	if (yych == 'r') goto yy1027;
	goto yy37;
yy953:
	yych = *++cur;
	if (yych == 'N') goto yy1028;
	if (yych == 'n') goto yy1028;
	goto yy37;
yy954:
	yych = *++cur;
	if (yych == 'E') goto yy1029;
	if (yych == 'e') goto yy1029;
	goto yy37;
yy955:
	yych = *++cur;
	if (yych == 'D') goto yy1030;
	if (yych == 'd') goto yy1030;
	goto yy37;
yy956:
	yych = *++cur;
	if (yych == 'E') goto yy1031;
	if (yych == 'e') goto yy1031;
	goto yy37;
yy957:
	yych = *++cur;
	if (yych == 'E') goto yy1032;
	if (yych == 'e') goto yy1032;
	goto yy37;
yy958:
	yych = *++cur;
	if (yych == 'S') goto yy1033;
	if (yych == 's') goto yy1033;
	goto yy37;
yy959:
	yych = *++cur;
	if (yych == 'N') goto yy1034;
	if (yych == 'n') goto yy1034;
	goto yy37;
yy960:
	yych = *++cur;
	if (yych == 'P') goto yy1035;
	if (yych == 'p') goto yy1035;
	goto yy37;
yy961:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 477 "parser/tokenizer.re"
	{ KW(SEQUENCE) }
#line 7613 "parser/tokenizer.cpp"
yy962:
	yych = *++cur;
	if (yych == 'E') goto yy1036;
	if (yych == 'e') goto yy1036;
	goto yy37;
yy963:
	yych = *++cur;
	if (yych == 'N') goto yy1037;
	if (yych == 'n') goto yy1037;
	goto yy37;
yy964:
	yych = *++cur;
	if (yych == 'E') goto yy1038;
	if (yych == 'e') goto yy1038;
	goto yy37;
yy965:
	yych = *++cur;
	if (yych == 'R') goto yy1039;
	if (yych == 'r') goto yy1039;
	goto yy37;
yy966:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 488 "parser/tokenizer.re"
	{ KW(SYNC_TEAM) }
#line 7642 "parser/tokenizer.cpp"
yy967:
	yych = *++cur;
	if (yych == 'B') goto yy1040;
	if (yych == 'b') goto yy1040;
	goto yy37;
yy968:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 492 "parser/tokenizer.re"
	{ KW(TEMPLATE) }
#line 7656 "parser/tokenizer.cpp"
yy969:
	yych = *++cur;
	if (yych == 'T') goto yy1041;
	if (yych == 't') goto yy1041;
	goto yy37;
yy970:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 499 "parser/tokenizer.re"
	{ KW(VOLATILE) }
#line 7670 "parser/tokenizer.cpp"
yy971:
	yych = *++cur;
	if (yych <= '/') goto yy771;
	if (yych <= '9') goto yy971;
	goto yy771;
yy972:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy771;
		if (yych <= '9') goto yy972;
		if (yych <= '@') goto yy771;
		goto yy972;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy771;
			goto yy972;
		} else {
			if (yych <= '`') goto yy771;
			if (yych <= 'z') goto yy972;
			goto yy771;
		}
	}
yy973:
	yych = *++cur;
	if (yych == 'L') goto yy1042;
	if (yych == 'l') goto yy1042;
	goto yy37;
yy974:
	yych = *++cur;
	if (yych == 'T') goto yy1043;
	if (yych == 't') goto yy1043;
	goto yy37;
yy975:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 259 "parser/tokenizer.re"
	{ KW(ASSOCIATE) }
#line 7711 "parser/tokenizer.cpp"
yy976:
	yych = *++cur;
	if (yych == 'O') goto yy1044;
	if (yych == 'o') goto yy1044;
	goto yy37;
yy977:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 261 "parser/tokenizer.re"
	{ KW(BACKSPACE) }
#line 7725 "parser/tokenizer.cpp"
yy978:
	yych = *++cur;
	if (yych == 'M') goto yy1045;
	if (yych == 'm') goto yy1045;
	goto yy37;
yy979:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 268 "parser/tokenizer.re"
	{ KW(CHARACTER) }
#line 7739 "parser/tokenizer.cpp"
yy980:
	yych = *++cur;
	if (yych == 'O') goto yy1046;
	if (yych == 'o') goto yy1046;
	goto yy37;
yy981:
	yych = *++cur;
	if (yych == 'T') goto yy1047;
	if (yych == 't') goto yy1047;
	goto yy37;
yy982:
	yych = *++cur;
	if (yych == 'S') goto yy1048;
	if (yych == 's') goto yy1048;
	goto yy37;
yy983:
	yych = *++cur;
	if (yych == 'E') goto yy1049;
	if (yych == 'e') goto yy1049;
	goto yy37;
yy984:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 284 "parser/tokenizer.re"
	{ KW(DIMENSION) }
#line 7768 "parser/tokenizer.cpp"
yy985:
	yych = *++cur;
	if (yych == 'P') goto yy1050;
	if (yych == 'p') goto yy1050;
	goto yy37;
yy986:
	yych = *++cur;
	if (yych == 'C') goto yy1051;
	if (yych == 'c') goto yy1051;
	goto yy37;
yy987:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 297 "parser/tokenizer.re"
	{ KW(ELEMENTAL) }
#line 7787 "parser/tokenizer.cpp"
yy988:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 300 "parser/tokenizer.re"
	{ KW(ELSEWHERE) }
#line 7796 "parser/tokenizer.cpp"
yy989:
	yych = *++cur;
	if (yych == 'I') goto yy1052;
	if (yych == 'i') goto yy1052;
	goto yy61;
yy990:
	yyaccept = 14;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1053;
		} else {
			if (yych != '\f') goto yy1053;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1053;
		} else {
			if (yych <= 'D') goto yy1054;
			if (yych == 'd') goto yy1054;
		}
	}
yy991:
#line 313 "parser/tokenizer.re"
	{ KW(END_BLOCK) }
#line 7822 "parser/tokenizer.cpp"
yy992:
	yych = *++cur;
	if (yych == 'C') goto yy1055;
	if (yych == 'c') goto yy1055;
	goto yy61;
yy993:
	yych = *++cur;
	if (yych == 'L') goto yy1056;
	if (yych == 'l') goto yy1056;
	goto yy61;
yy994:
	yych = *++cur;
	if (yych == 'I') goto yy1057;
	if (yych == 'i') goto yy1057;
	goto yy61;
yy995:
	yych = *++cur;
	if (yych == 'F') goto yy1058;
	if (yych == 'f') goto yy1058;
	goto yy61;
yy996:
	yych = *++cur;
	if (yych == 'E') goto yy1059;
	if (yych == 'e') goto yy1059;
	goto yy61;
yy997:
	yych = *++cur;
	if (yych == 'D') goto yy1060;
	if (yych == 'd') goto yy1060;
	goto yy61;
yy998:
	yych = *++cur;
	if (yych == 'A') goto yy1061;
	if (yych == 'a') goto yy1061;
	goto yy61;
yy999:
	yych = *++cur;
	if (yych == 'T') goto yy1062;
	if (yych == 't') goto yy1062;
	goto yy61;
yy1000:
	yych = *++cur;
	if (yych == 'D') goto yy1063;
	if (yych == 'd') goto yy1063;
	goto yy61;
yy1001:
	yych = *++cur;
	if (yych == 'U') goto yy1064;
	if (yych == 'u') goto yy1064;
	goto yy61;
yy1002:
	++cur;
#line 372 "parser/tokenizer.re"
	{ KW(END_WHERE) }
#line 7877 "parser/tokenizer.cpp"
yy1003:
	yych = *++cur;
	if (yych == 'A') goto yy1065;
	if (yych == 'a') goto yy1065;
	goto yy37;
yy1004:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1004;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			goto yy1004;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1004;
			goto yy61;
		} else {
			if (yych <= 'D') goto yy1066;
			if (yych == 'd') goto yy1066;
			goto yy61;
		}
	}
yy1005:
	yych = *++cur;
	if (yych == 'A') goto yy1067;
	if (yych == 'a') goto yy1067;
	goto yy37;
yy1006:
	yych = *++cur;
	if (yych == 'A') goto yy1068;
	if (yych == 'a') goto yy1068;
	goto yy37;
yy1007:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 346 "parser/tokenizer.re"
	{ KW(ENDFORALL) }
#line 7921 "parser/tokenizer.cpp"
yy1008:
	yych = *++cur;
	if (yych == 'O') goto yy1069;
	if (yych == 'o') goto yy1069;
	goto yy37;
yy1009:
	yych = *++cur;
	if (yych == 'A') goto yy1070;
	if (yych == 'a') goto yy1070;
	goto yy37;
yy1010:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 308 "parser/tokenizer.re"
	{ KW(ENDMODULE) }
#line 7940 "parser/tokenizer.cpp"
yy1011:
	yych = *++cur;
	if (yych == 'U') goto yy1071;
	if (yych == 'u') goto yy1071;
	goto yy37;
yy1012:
	yych = *++cur;
	if (yych == 'M') goto yy1072;
	if (yych == 'm') goto yy1072;
	goto yy37;
yy1013:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 334 "parser/tokenizer.re"
	{ KW(ENDSELECT) }
#line 7959 "parser/tokenizer.cpp"
yy1014:
	yych = *++cur;
	if (yych == 'U') goto yy1073;
	if (yych == 'u') goto yy1073;
	goto yy37;
yy1015:
	yych = *++cur;
	if (yych == 'T') goto yy1074;
	if (yych == 't') goto yy1074;
	goto yy37;
yy1016:
	yych = *++cur;
	if (yych == 'R') goto yy1075;
	if (yych == 'r') goto yy1075;
	goto yy37;
yy1017:
	yych = *++cur;
	if (yych == 'C') goto yy1076;
	if (yych == 'c') goto yy1076;
	goto yy37;
yy1018:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 404 "parser/tokenizer.re"
	{ KW(FORMATTED) }
#line 7988 "parser/tokenizer.cpp"
yy1019:
	yych = *++cur;
	if (yych == 'T') goto yy1077;
	if (yych == 't') goto yy1077;
	goto yy37;
yy1020:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 424 "parser/tokenizer.re"
	{ KW(INTERFACE) }
#line 8002 "parser/tokenizer.cpp"
yy1021:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 425 "parser/tokenizer.re"
	{ KW(INTRINSIC) }
#line 8011 "parser/tokenizer.cpp"
yy1022:
	yych = *++cur;
	if (yych == 'T') goto yy1078;
	if (yych == 't') goto yy1078;
	goto yy37;
yy1023:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 437 "parser/tokenizer.re"
	{ KW(NEW_INDEX) }
#line 8025 "parser/tokenizer.cpp"
yy1024:
	yych = *++cur;
	if (yych == 'N') goto yy1079;
	if (yych == 'n') goto yy1079;
	goto yy37;
yy1025:
	yych = *++cur;
	if (yych == 'I') goto yy1080;
	if (yych == 'i') goto yy1080;
	goto yy37;
yy1026:
	yych = *++cur;
	if (yych == 'S') goto yy1081;
	if (yych == 's') goto yy1081;
	goto yy37;
yy1027:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 449 "parser/tokenizer.re"
	{ KW(PARAMETER) }
#line 8049 "parser/tokenizer.cpp"
yy1028:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 453 "parser/tokenizer.re"
	{ KW(PRECISION) }
#line 8058 "parser/tokenizer.cpp"
yy1029:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 456 "parser/tokenizer.re"
	{ KW(PROCEDURE) }
#line 8067 "parser/tokenizer.cpp"
yy1030:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 458 "parser/tokenizer.re"
	{ KW(PROTECTED) }
#line 8076 "parser/tokenizer.cpp"
yy1031:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 465 "parser/tokenizer.re"
	{ KW(RECURSIVE) }
#line 8085 "parser/tokenizer.cpp"
yy1032:
	yych = *++cur;
	if (yych == 'N') goto yy1082;
	if (yych == 'n') goto yy1082;
	goto yy37;
yy1033:
	yych = *++cur;
	if (yych == 'E') goto yy1083;
	if (yych == 'e') goto yy1083;
	goto yy37;
yy1034:
	yych = *++cur;
	if (yych == 'K') goto yy1084;
	if (yych == 'k') goto yy1084;
	goto yy37;
yy1035:
	yych = *++cur;
	if (yych == 'E') goto yy1085;
	if (yych == 'e') goto yy1085;
	goto yy37;
yy1036:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 482 "parser/tokenizer.re"
	{ KW(SUBMODULE) }
#line 8114 "parser/tokenizer.cpp"
yy1037:
	yych = *++cur;
	if (yych == 'E') goto yy1086;
	if (yych == 'e') goto yy1086;
	goto yy37;
yy1038:
	yych = *++cur;
	if (yych == 'S') goto yy1087;
	if (yych == 's') goto yy1087;
	goto yy37;
yy1039:
	yych = *++cur;
	if (yych == 'Y') goto yy1088;
	if (yych == 'y') goto yy1088;
	goto yy37;
yy1040:
	yych = *++cur;
	if (yych == 'E') goto yy1089;
	if (yych == 'e') goto yy1089;
	goto yy37;
yy1041:
	yych = *++cur;
	if (yych == 'E') goto yy1090;
	if (yych == 'e') goto yy1090;
	goto yy37;
yy1042:
	yych = *++cur;
	if (yych == 'E') goto yy1091;
	if (yych == 'e') goto yy1091;
	goto yy37;
yy1043:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 258 "parser/tokenizer.re"
	{ KW(ASSIGNMENT) }
#line 8153 "parser/tokenizer.cpp"
yy1044:
	yych = *++cur;
	if (yych == 'U') goto yy1092;
	if (yych == 'u') goto yy1092;
	goto yy37;
yy1045:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 267 "parser/tokenizer.re"
	{ KW(CHANGE_TEAM) }
#line 8167 "parser/tokenizer.cpp"
yy1046:
	yych = *++cur;
	if (yych == 'N') goto yy1093;
	if (yych == 'n') goto yy1093;
	goto yy37;
yy1047:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 274 "parser/tokenizer.re"
	{ KW(CONCURRENT) }
#line 8181 "parser/tokenizer.cpp"
yy1048:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 276 "parser/tokenizer.re"
	{ KW(CONTIGUOUS) }
#line 8190 "parser/tokenizer.cpp"
yy1049:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 281 "parser/tokenizer.re"
	{ KW(DEALLOCATE) }
#line 8199 "parser/tokenizer.cpp"
yy1050:
	yych = *++cur;
	if (yych == 'L') goto yy1094;
	if (yych == 'l') goto yy1094;
	goto yy37;
yy1051:
	yych = *++cur;
	if (yych == 'I') goto yy1095;
	if (yych == 'i') goto yy1095;
	goto yy37;
yy1052:
	yych = *++cur;
	if (yych == 'A') goto yy1096;
	if (yych == 'a') goto yy1096;
	goto yy61;
yy1053:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1053;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			goto yy1053;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1053;
			goto yy61;
		} else {
			if (yych <= 'D') goto yy1097;
			if (yych == 'd') goto yy1097;
			goto yy61;
		}
	}
yy1054:
	yych = *++cur;
	if (yych == 'A') goto yy1098;
	if (yych == 'a') goto yy1098;
	goto yy61;
yy1055:
	yych = *++cur;
	if (yych == 'A') goto yy1099;
	if (yych == 'a') goto yy1099;
	goto yy61;
yy1056:
	++cur;
#line 345 "parser/tokenizer.re"
	{ KW(END_FORALL) }
#line 8249 "parser/tokenizer.cpp"
yy1057:
	yych = *++cur;
	if (yych == 'O') goto yy1100;
	if (yych == 'o') goto yy1100;
	goto yy61;
yy1058:
	yych = *++cur;
	if (yych == 'A') goto yy1101;
	if (yych == 'a') goto yy1101;
	goto yy61;
yy1059:
	++cur;
#line 307 "parser/tokenizer.re"
	{ KW(END_MODULE) }
#line 8264 "parser/tokenizer.cpp"
yy1060:
	yych = *++cur;
	if (yych == 'U') goto yy1102;
	if (yych == 'u') goto yy1102;
	goto yy61;
yy1061:
	yych = *++cur;
	if (yych == 'M') goto yy1103;
	if (yych == 'm') goto yy1103;
	goto yy61;
yy1062:
	++cur;
#line 333 "parser/tokenizer.re"
	{ KW(END_SELECT) }
#line 8279 "parser/tokenizer.cpp"
yy1063:
	yych = *++cur;
	if (yych == 'U') goto yy1104;
	if (yych == 'u') goto yy1104;
	goto yy61;
yy1064:
	yych = *++cur;
	if (yych == 'T') goto yy1105;
	if (yych == 't') goto yy1105;
	goto yy61;
yy1065:
	yych = *++cur;
	if (yych == 'T') goto yy1106;
	if (yych == 't') goto yy1106;
	goto yy37;
yy1066:
	yych = *++cur;
	if (yych == 'A') goto yy1107;
	if (yych == 'a') goto yy1107;
	goto yy61;
yy1067:
	yych = *++cur;
	if (yych == 'T') goto yy1108;
	if (yych == 't') goto yy1108;
	goto yy37;
yy1068:
	yych = *++cur;
	if (yych == 'L') goto yy1109;
	if (yych == 'l') goto yy1109;
	goto yy37;
yy1069:
	yych = *++cur;
	if (yych == 'N') goto yy1110;
	if (yych == 'n') goto yy1110;
	goto yy37;
yy1070:
	yych = *++cur;
	if (yych == 'C') goto yy1111;
	if (yych == 'c') goto yy1111;
	goto yy37;
yy1071:
	yych = *++cur;
	if (yych == 'R') goto yy1112;
	if (yych == 'r') goto yy1112;
	goto yy37;
yy1072:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 305 "parser/tokenizer.re"
	{ KW(ENDPROGRAM) }
#line 8333 "parser/tokenizer.cpp"
yy1073:
	yych = *++cur;
	if (yych == 'L') goto yy1113;
	if (yych == 'l') goto yy1113;
	goto yy37;
yy1074:
	yych = *++cur;
	if (yych == 'I') goto yy1114;
	if (yych == 'i') goto yy1114;
	goto yy37;
yy1075:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 380 "parser/tokenizer.re"
	{ KW(ENUMERATOR) }
#line 8352 "parser/tokenizer.cpp"
yy1076:
	yych = *++cur;
	if (yych == 'E') goto yy1115;
	if (yych == 'e') goto yy1115;
	goto yy37;
yy1077:
	yych = *++cur;
	if (yych == 'E') goto yy1116;
	if (yych == 'e') goto yy1116;
	goto yy37;
yy1078:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 430 "parser/tokenizer.re"
	{ KW(LOCAL_INIT) }
#line 8371 "parser/tokenizer.cpp"
yy1079:
	yych = *++cur;
	if (yych == 'S') goto yy1117;
	if (yych == 's') goto yy1117;
	goto yy37;
yy1080:
	yych = *++cur;
	if (yych == 'D') goto yy1118;
	if (yych == 'd') goto yy1118;
	goto yy37;
yy1081:
	yych = *++cur;
	if (yych == 'I') goto yy1119;
	if (yych == 'i') goto yy1119;
	goto yy37;
yy1082:
	yych = *++cur;
	if (yych == 'T') goto yy1120;
	if (yych == 't') goto yy1120;
	goto yy37;
yy1083:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 474 "parser/tokenizer.re"
	{ KW(SELECT_CASE) }
#line 8400 "parser/tokenizer.cpp"
yy1084:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 475 "parser/tokenizer.re"
	{ KW(SELECT_RANK) }
#line 8409 "parser/tokenizer.cpp"
yy1085:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 476 "parser/tokenizer.re"
	{ KW(SELECT_TYPE) }
#line 8418 "parser/tokenizer.cpp"
yy1086:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 483 "parser/tokenizer.re"
	{ KW(SUBROUTINE) }
#line 8427 "parser/tokenizer.cpp"
yy1087:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 486 "parser/tokenizer.re"
	{ KW(SYNC_IMAGES) }
#line 8436 "parser/tokenizer.cpp"
yy1088:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 487 "parser/tokenizer.re"
	{ KW(SYNC_MEMORY) }
#line 8445 "parser/tokenizer.cpp"
yy1089:
	yych = *++cur;
	if (yych == 'R') goto yy1121;
	if (yych == 'r') goto yy1121;
	goto yy37;
yy1090:
	yych = *++cur;
	if (yych == 'D') goto yy1122;
	if (yych == 'd') goto yy1122;
	goto yy37;
yy1091:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 255 "parser/tokenizer.re"
	{ KW(ALLOCATABLE) }
#line 8464 "parser/tokenizer.cpp"
yy1092:
	yych = *++cur;
	if (yych == 'S') goto yy1123;
	if (yych == 's') goto yy1123;
	goto yy37;
yy1093:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 271 "parser/tokenizer.re"
	{ KW(CODIMENSION) }
#line 8478 "parser/tokenizer.cpp"
yy1094:
	yych = *++cur;
	if (yych == 'E') goto yy1124;
	if (yych == 'e') goto yy1124;
	goto yy37;
yy1095:
	yych = *++cur;
	if (yych == 'S') goto yy1125;
	if (yych == 's') goto yy1125;
	goto yy37;
yy1096:
	yych = *++cur;
	if (yych == 'T') goto yy1126;
	if (yych == 't') goto yy1126;
	goto yy61;
yy1097:
	yych = *++cur;
	if (yych == 'A') goto yy1127;
	if (yych == 'a') goto yy1127;
	goto yy61;
yy1098:
	yych = *++cur;
	if (yych == 'T') goto yy1128;
	if (yych == 't') goto yy1128;
	goto yy61;
yy1099:
	yych = *++cur;
	if (yych == 'L') goto yy1129;
	if (yych == 'l') goto yy1129;
	goto yy61;
yy1100:
	yych = *++cur;
	if (yych == 'N') goto yy1130;
	if (yych == 'n') goto yy1130;
	goto yy61;
yy1101:
	yych = *++cur;
	if (yych == 'C') goto yy1131;
	if (yych == 'c') goto yy1131;
	goto yy61;
yy1102:
	yych = *++cur;
	if (yych == 'R') goto yy1132;
	if (yych == 'r') goto yy1132;
	goto yy61;
yy1103:
	++cur;
#line 304 "parser/tokenizer.re"
	{ KW(END_PROGRAM) }
#line 8528 "parser/tokenizer.cpp"
yy1104:
	yych = *++cur;
	if (yych == 'L') goto yy1133;
	if (yych == 'l') goto yy1133;
	goto yy61;
yy1105:
	yych = *++cur;
	if (yych == 'I') goto yy1134;
	if (yych == 'i') goto yy1134;
	goto yy61;
yy1106:
	yych = *++cur;
	if (yych == 'E') goto yy1135;
	if (yych == 'e') goto yy1135;
	goto yy37;
yy1107:
	yych = *++cur;
	if (yych == 'T') goto yy1136;
	if (yych == 't') goto yy1136;
	goto yy61;
yy1108:
	yych = *++cur;
	if (yych == 'A') goto yy1137;
	if (yych == 'a') goto yy1137;
	goto yy37;
yy1109:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 340 "parser/tokenizer.re"
	{ KW(ENDCRITICAL) }
#line 8562 "parser/tokenizer.cpp"
yy1110:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 325 "parser/tokenizer.re"
	{ KW(ENDFUNCTION) }
#line 8571 "parser/tokenizer.cpp"
yy1111:
	yych = *++cur;
	if (yych == 'E') goto yy1138;
	if (yych == 'e') goto yy1138;
	goto yy37;
yy1112:
	yych = *++cur;
	if (yych == 'E') goto yy1139;
	if (yych == 'e') goto yy1139;
	goto yy37;
yy1113:
	yych = *++cur;
	if (yych == 'E') goto yy1140;
	if (yych == 'e') goto yy1140;
	goto yy37;
yy1114:
	yych = *++cur;
	if (yych == 'N') goto yy1141;
	if (yych == 'n') goto yy1141;
	goto yy37;
yy1115:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 381 "parser/tokenizer.re"
	{ KW(EQUIVALENCE) }
#line 8600 "parser/tokenizer.cpp"
yy1116:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 421 "parser/tokenizer.re"
	{ KW(INSTANTIATE) }
#line 8609 "parser/tokenizer.cpp"
yy1117:
	yych = *++cur;
	if (yych == 'I') goto yy1142;
	if (yych == 'i') goto yy1142;
	goto yy37;
yy1118:
	yych = *++cur;
	if (yych == 'A') goto yy1143;
	if (yych == 'a') goto yy1143;
	goto yy37;
yy1119:
	yych = *++cur;
	if (yych == 'V') goto yy1144;
	if (yych == 'v') goto yy1144;
	goto yy37;
yy1120:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 467 "parser/tokenizer.re"
	{ KW(REQUIREMENT) }
#line 8633 "parser/tokenizer.cpp"
yy1121:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 491 "parser/tokenizer.re"
	{ KW(TEAM_NUMBER) }
#line 8642 "parser/tokenizer.cpp"
yy1122:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 496 "parser/tokenizer.re"
	{ KW(UNFORMATTED) }
#line 8651 "parser/tokenizer.cpp"
yy1123:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 260 "parser/tokenizer.re"
	{ KW(ASYNCHRONOUS) }
#line 8660 "parser/tokenizer.cpp"
yy1124:
	yych = *++cur;
	if (yych == 'X') goto yy1145;
	if (yych == 'x') goto yy1145;
	goto yy37;
yy1125:
	yych = *++cur;
	if (yych == 'I') goto yy1146;
	if (yych == 'i') goto yy1146;
	goto yy37;
yy1126:
	yych = *++cur;
	if (yych == 'E') goto yy1147;
	if (yych == 'e') goto yy1147;
	goto yy61;
yy1127:
	yych = *++cur;
	if (yych == 'T') goto yy1148;
	if (yych == 't') goto yy1148;
	goto yy61;
yy1128:
	yych = *++cur;
	if (yych == 'A') goto yy1149;
	if (yych == 'a') goto yy1149;
	goto yy61;
yy1129:
	++cur;
#line 339 "parser/tokenizer.re"
	{ KW(END_CRITICAL) }
#line 8690 "parser/tokenizer.cpp"
yy1130:
	++cur;
#line 324 "parser/tokenizer.re"
	{ KW(END_FUNCTION) }
#line 8695 "parser/tokenizer.cpp"
yy1131:
	yych = *++cur;
	if (yych == 'E') goto yy1150;
	if (yych == 'e') goto yy1150;
	goto yy61;
yy1132:
	yych = *++cur;
	if (yych == 'E') goto yy1151;
	if (yych == 'e') goto yy1151;
	goto yy61;
yy1133:
	yych = *++cur;
	if (yych == 'E') goto yy1152;
	if (yych == 'e') goto yy1152;
	goto yy61;
yy1134:
	yych = *++cur;
	if (yych == 'N') goto yy1153;
	if (yych == 'n') goto yy1153;
	goto yy61;
yy1135:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 337 "parser/tokenizer.re"
	{ KW(ENDASSOCIATE) }
#line 8724 "parser/tokenizer.cpp"
yy1136:
	yych = *++cur;
	if (yych == 'A') goto yy1154;
	if (yych == 'a') goto yy1154;
	goto yy61;
yy1137:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 319 "parser/tokenizer.re"
	{ KW(ENDBLOCKDATA) }
#line 8738 "parser/tokenizer.cpp"
yy1138:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 352 "parser/tokenizer.re"
	{ KW(ENDINTERFACE) }
#line 8747 "parser/tokenizer.cpp"
yy1139:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 328 "parser/tokenizer.re"
	{ KW(ENDPROCEDURE) }
#line 8756 "parser/tokenizer.cpp"
yy1140:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 311 "parser/tokenizer.re"
	{ KW(ENDSUBMODULE) }
#line 8765 "parser/tokenizer.cpp"
yy1141:
	yych = *++cur;
	if (yych == 'E') goto yy1155;
	if (yych == 'e') goto yy1155;
	goto yy37;
yy1142:
	yych = *++cur;
	if (yych == 'C') goto yy1156;
	if (yych == 'c') goto yy1156;
	goto yy37;
yy1143:
	yych = *++cur;
	if (yych == 'B') goto yy1157;
	if (yych == 'b') goto yy1157;
	goto yy37;
yy1144:
	yych = *++cur;
	if (yych == 'E') goto yy1158;
	if (yych == 'e') goto yy1158;
	goto yy37;
yy1145:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 296 "parser/tokenizer.re"
	{ KW(DOUBLE_COMPLEX) }
#line 8794 "parser/tokenizer.cpp"
yy1146:
	yych = *++cur;
	if (yych == 'O') goto yy1159;
	if (yych == 'o') goto yy1159;
	goto yy37;
yy1147:
	++cur;
#line 336 "parser/tokenizer.re"
	{ KW(END_ASSOCIATE) }
#line 8804 "parser/tokenizer.cpp"
yy1148:
	yych = *++cur;
	if (yych == 'A') goto yy1160;
	if (yych == 'a') goto yy1160;
	goto yy61;
yy1149:
	++cur;
#line 318 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 8814 "parser/tokenizer.cpp"
yy1150:
	++cur;
#line 351 "parser/tokenizer.re"
	{ KW(END_INTERFACE) }
#line 8819 "parser/tokenizer.cpp"
yy1151:
	++cur;
#line 327 "parser/tokenizer.re"
	{ KW(END_PROCEDURE) }
#line 8824 "parser/tokenizer.cpp"
yy1152:
	++cur;
#line 310 "parser/tokenizer.re"
	{ KW(END_SUBMODULE) }
#line 8829 "parser/tokenizer.cpp"
yy1153:
	yych = *++cur;
	if (yych == 'E') goto yy1161;
	if (yych == 'e') goto yy1161;
	goto yy61;
yy1154:
	++cur;
#line 317 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 8839 "parser/tokenizer.cpp"
yy1155:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 322 "parser/tokenizer.re"
	{ KW(ENDSUBROUTINE) }
#line 8848 "parser/tokenizer.cpp"
yy1156:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 439 "parser/tokenizer.re"
	{ KW(NON_INTRINSIC) }
#line 8857 "parser/tokenizer.cpp"
yy1157:
	yych = *++cur;
	if (yych == 'L') goto yy1162;
	if (yych == 'l') goto yy1162;
	goto yy37;
yy1158:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 441 "parser/tokenizer.re"
	{ KW(NON_RECURSIVE) }
#line 8871 "parser/tokenizer.cpp"
yy1159:
	yych = *++cur;
	if (yych == 'N') goto yy1163;
	if (yych == 'n') goto yy1163;
	goto yy37;
yy1160:
	++cur;
#line 316 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 8881 "parser/tokenizer.cpp"
yy1161:
	++cur;
#line 321 "parser/tokenizer.re"
	{ KW(END_SUBROUTINE) }
#line 8886 "parser/tokenizer.cpp"
yy1162:
	yych = *++cur;
	if (yych == 'E') goto yy1164;
	if (yych == 'e') goto yy1164;
	goto yy37;
yy1163:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 295 "parser/tokenizer.re"
	{ KW(DOUBLE_PRECISION) }
#line 8900 "parser/tokenizer.cpp"
yy1164:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy109;
#line 440 "parser/tokenizer.re"
	{ KW(NON_OVERRIDABLE) }
#line 8909 "parser/tokenizer.cpp"
}
#line 679 "parser/tokenizer.re"

    }
}

std::string token(unsigned char *tok, unsigned char* cur)
{
    return std::string((char *)tok, cur - tok);
}

void token_loc(Location &loc)
{
    loc.first = 1;
    loc.last = 1;
}

void lex_format(unsigned char *&cur, Location &loc,
        unsigned char *&start) {
    int num_paren = 0;
    for (;;) {
        unsigned char *tok = cur;
        unsigned char *mar;
        
#line 8934 "parser/tokenizer.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0, 208, 208, 208, 208, 208, 208, 208, 
		208, 244, 176, 244, 208, 244, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		244, 208, 192, 208, 208, 208, 208,  80, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		216, 216, 216, 216, 216, 216, 216, 216, 
		216, 216, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
	};
	yych = *cur;
	if (yybm[0+yych] & 4) {
		goto yy1169;
	}
	switch (yych) {
		case 0x00: goto yy1166;
		case '"': goto yy1170;
		case '&': goto yy1171;
		case '\'': goto yy1172;
		case '(': goto yy1173;
		case ')': goto yy1174;
		case '*': goto yy1175;
		case ',': goto yy1176;
		case '-': goto yy1177;
		case '/':
		case ':': goto yy1178;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1180;
		case 'A':
		case 'a': goto yy1181;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1183;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1184;
		case 'E':
		case 'e': goto yy1185;
		case 'G':
		case 'g': goto yy1186;
		case 'L':
		case 'l': goto yy1187;
		case 'P':
		case 'p': goto yy1188;
		case 'T':
		case 't': goto yy1189;
		case 'X':
		case 'x': goto yy1190;
		default: goto yy1167;
	}
yy1166:
	++cur;
#line 772 "parser/tokenizer.re"
	{
                token_loc(loc);
                std::string t = token(tok, cur);
                throw LFortran::parser_local::TokenizerError(
                    "End of file not expected in `format` statement '" + t + "'", loc);
            }
#line 9035 "parser/tokenizer.cpp"
yy1167:
	++cur;
yy1168:
#line 738 "parser/tokenizer.re"
	{
                token_loc(loc);
                std::string t = token(tok, cur);
                throw LFortran::parser_local::TokenizerError("Token '" + t
                    + "' is not recognized in `format` statement", loc);
            }
#line 9046 "parser/tokenizer.cpp"
yy1169:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy1169;
	}
#line 778 "parser/tokenizer.re"
	{ continue; }
#line 9054 "parser/tokenizer.cpp"
yy1170:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy1168;
	goto yy1192;
yy1171:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy1168;
		if (yych <= '\v') goto yy1197;
		goto yy1168;
	} else {
		if (yych <= '\r') goto yy1197;
		if (yych <= 0x1F) goto yy1168;
		if (yych <= '!') goto yy1197;
		goto yy1168;
	}
yy1172:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy1168;
	goto yy1202;
yy1173:
	++cur;
#line 744 "parser/tokenizer.re"
	{
                if (num_paren == 0) {
                    num_paren++;
                    start = cur;
                    continue;
                } else {
                    cur--;
                    unsigned char *tmp;
                    lex_format(cur, loc, tmp);
                    continue;
                }
            }
#line 9093 "parser/tokenizer.cpp"
yy1174:
	++cur;
#line 768 "parser/tokenizer.re"
	{
                LCOMPILERS_ASSERT(num_paren == 1);
                return;
            }
#line 9101 "parser/tokenizer.cpp"
yy1175:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1168;
			goto yy1204;
		} else {
			if (yych == '\v') goto yy1204;
			goto yy1168;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1204;
			if (yych <= 0x1F) goto yy1168;
			goto yy1204;
		} else {
			if (yych == '(') goto yy1205;
			goto yy1168;
		}
	}
yy1176:
	++cur;
#line 779 "parser/tokenizer.re"
	{ continue; }
#line 9127 "parser/tokenizer.cpp"
yy1177:
	++cur;
#line 783 "parser/tokenizer.re"
	{ continue; }
#line 9132 "parser/tokenizer.cpp"
yy1178:
	++cur;
yy1179:
#line 785 "parser/tokenizer.re"
	{ continue; }
#line 9138 "parser/tokenizer.cpp"
yy1180:
	yyaccept = 0;
	yych = *(mar = ++cur);
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ':
		case '(':
		case '/':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'I':
		case 'L':
		case 'O':
		case 'P':
		case 'X':
		case 'Z':
		case 'a':
		case 'b':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'i':
		case 'l':
		case 'o':
		case 'p':
		case 'x':
		case 'z': goto yy1209;
		default: goto yy1168;
	}
yy1181:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy1181;
	}
yy1182:
#line 784 "parser/tokenizer.re"
	{ continue; }
#line 9193 "parser/tokenizer.cpp"
yy1183:
	yych = *++cur;
	if (yych <= '/') goto yy1168;
	if (yych <= '9') goto yy1215;
	goto yy1168;
yy1184:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '/') goto yy1168;
	if (yych <= '9') goto yy1216;
	goto yy1168;
yy1185:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 'W') {
		if (yych <= 'M') {
			if (yych <= '/') goto yy1168;
			if (yych <= '9') goto yy1217;
			goto yy1168;
		} else {
			if (yych <= 'N') goto yy1218;
			if (yych == 'S') goto yy1218;
			goto yy1168;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'X') goto yy1218;
			if (yych == 'n') goto yy1218;
			goto yy1168;
		} else {
			if (yych <= 's') goto yy1218;
			if (yych == 'x') goto yy1218;
			goto yy1168;
		}
	}
yy1186:
	yych = *++cur;
	if (yych <= '/') goto yy1168;
	if (yych <= '9') goto yy1219;
	goto yy1168;
yy1187:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy1181;
	}
	goto yy1168;
yy1188:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 'D') goto yy1182;
	if (yych <= 'F') goto yy1211;
	if (yych <= 'd') goto yy1182;
	if (yych <= 'f') goto yy1211;
	goto yy1182;
yy1189:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 'Q') {
		if (yych <= '9') {
			if (yych <= '/') goto yy1168;
			goto yy1220;
		} else {
			if (yych == 'L') goto yy1221;
			goto yy1168;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'R') goto yy1221;
			if (yych <= 'k') goto yy1168;
			goto yy1221;
		} else {
			if (yych == 'r') goto yy1221;
			goto yy1168;
		}
	}
yy1190:
	++cur;
	goto yy1182;
yy1191:
	yych = *++cur;
yy1192:
	if (yybm[0+yych] & 16) {
		goto yy1191;
	}
	if (yych >= 0x01) goto yy1194;
yy1193:
	cur = mar;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy1168;
			} else {
				goto yy1182;
			}
		} else {
			goto yy1195;
		}
	} else {
		if (yyaccept == 3) {
			goto yy1199;
		} else {
			goto yy1203;
		}
	}
yy1194:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy1191;
yy1195:
#line 781 "parser/tokenizer.re"
	{ continue; }
#line 9305 "parser/tokenizer.cpp"
yy1196:
	yych = *++cur;
yy1197:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1193;
			goto yy1196;
		} else {
			if (yych <= '\n') goto yy1198;
			if (yych <= '\v') goto yy1196;
			goto yy1193;
		}
	} else {
		if (yych <= 0x1F) {
			if (yych <= '\r') goto yy1196;
			goto yy1193;
		} else {
			if (yych <= ' ') goto yy1196;
			if (yych <= '!') goto yy1200;
			goto yy1193;
		}
	}
yy1198:
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 32) {
		goto yy1198;
	}
	if (yych <= 0x1F) goto yy1199;
	if (yych <= '!') goto yy1200;
	if (yych == '&') goto yy1222;
yy1199:
#line 780 "parser/tokenizer.re"
	{ continue; }
#line 9340 "parser/tokenizer.cpp"
yy1200:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy1200;
	}
	if (yych <= 0x00) goto yy1193;
	goto yy1198;
yy1201:
	yych = *++cur;
yy1202:
	if (yybm[0+yych] & 128) {
		goto yy1201;
	}
	if (yych <= 0x00) goto yy1193;
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy1201;
yy1203:
#line 782 "parser/tokenizer.re"
	{ continue; }
#line 9361 "parser/tokenizer.cpp"
yy1204:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1193;
			goto yy1204;
		} else {
			if (yych == '\v') goto yy1204;
			goto yy1193;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1204;
			if (yych <= 0x1F) goto yy1193;
			goto yy1204;
		} else {
			if (yych != '(') goto yy1193;
		}
	}
yy1205:
	++cur;
#line 762 "parser/tokenizer.re"
	{
                cur--;
                unsigned char *tmp;
                lex_format(cur, loc, tmp);
                continue;
            }
#line 9390 "parser/tokenizer.cpp"
yy1206:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1193;
			goto yy1206;
		} else {
			if (yych == '\v') goto yy1206;
			goto yy1193;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1206;
			if (yych <= 0x1F) goto yy1193;
			goto yy1206;
		} else {
			if (yych != '(') goto yy1193;
		}
	}
yy1207:
	++cur;
#line 756 "parser/tokenizer.re"
	{
                cur--;
                unsigned char *tmp;
                lex_format(cur, loc, tmp);
                continue;
            }
#line 9419 "parser/tokenizer.cpp"
yy1208:
	yych = *++cur;
yy1209:
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy1206;
		case '(': goto yy1207;
		case '/': goto yy1178;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1208;
		case 'A':
		case 'a': goto yy1181;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1210;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1211;
		case 'E':
		case 'e': goto yy1212;
		case 'G':
		case 'g': goto yy1213;
		case 'L':
		case 'l': goto yy1214;
		case 'P':
		case 'p': goto yy1188;
		case 'X':
		case 'x': goto yy1190;
		default: goto yy1193;
	}
yy1210:
	yych = *++cur;
	if (yych <= '/') goto yy1193;
	if (yych <= '9') goto yy1215;
	goto yy1193;
yy1211:
	yych = *++cur;
	if (yych <= '/') goto yy1193;
	if (yych <= '9') goto yy1216;
	goto yy1193;
yy1212:
	yych = *++cur;
	if (yych <= 'W') {
		if (yych <= 'M') {
			if (yych <= '/') goto yy1193;
			if (yych <= '9') goto yy1217;
			goto yy1193;
		} else {
			if (yych <= 'N') goto yy1218;
			if (yych == 'S') goto yy1218;
			goto yy1193;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'X') goto yy1218;
			if (yych == 'n') goto yy1218;
			goto yy1193;
		} else {
			if (yych <= 's') goto yy1218;
			if (yych == 'x') goto yy1218;
			goto yy1193;
		}
	}
yy1213:
	yych = *++cur;
	if (yych <= '/') goto yy1193;
	if (yych <= '9') goto yy1219;
	goto yy1193;
yy1214:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy1181;
	}
	goto yy1193;
yy1215:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == '.') goto yy1214;
	if (yych <= '/') goto yy1182;
	if (yych <= '9') goto yy1215;
	goto yy1182;
yy1216:
	yych = *++cur;
	if (yych == '.') goto yy1214;
	if (yych <= '/') goto yy1193;
	if (yych <= '9') goto yy1216;
	goto yy1193;
yy1217:
	yych = *++cur;
	if (yych == '.') goto yy1223;
	if (yych <= '/') goto yy1193;
	if (yych <= '9') goto yy1217;
	goto yy1193;
yy1218:
	yych = *++cur;
	if (yych <= '/') goto yy1193;
	if (yych <= '9') goto yy1217;
	goto yy1193;
yy1219:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == '.') goto yy1223;
	if (yych <= '/') goto yy1182;
	if (yych <= '9') goto yy1219;
	goto yy1182;
yy1220:
	yych = *++cur;
	if (yych <= '/') goto yy1179;
	if (yych <= '9') goto yy1220;
	goto yy1179;
yy1221:
	yych = *++cur;
	if (yych <= '/') goto yy1193;
	if (yych <= '9') goto yy1220;
	goto yy1193;
yy1222:
	++cur;
	goto yy1199;
yy1223:
	yych = *++cur;
	if (yych <= '/') goto yy1193;
	if (yych >= ':') goto yy1193;
yy1224:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 'D') {
		if (yych <= '/') goto yy1182;
		if (yych <= '9') goto yy1224;
		goto yy1182;
	} else {
		if (yych <= 'E') goto yy1214;
		if (yych == 'e') goto yy1214;
		goto yy1182;
	}
}
#line 786 "parser/tokenizer.re"

    }
}

} // namespace LCompilers::LFortran
