#pragma once

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>
#include <libasr/asr_base_visitor.h>


namespace LCompilers::ASR {
/******************************************************************************/
// Deserialization Visitor base class

template <class StructType>
class DeserializationBaseVisitor : public BaseVisitor<StructType>
{
private:
    StructType& self() { return static_cast<StructType&>(*this); }
public:
    Allocator &al;
    bool load_symtab_id;
    uint32_t offset = 0;
    std::map<uint64_t,SymbolTable*> id_symtab_map;
    DeserializationBaseVisitor(Allocator &al, bool load_symtab_id, uint32_t offset) : al{al}, load_symtab_id{load_symtab_id}, offset{offset} {}
    asr_t* deserialize_node() {
        uint8_t t = self().read_int8();
        ASR::asrType ty = static_cast<ASR::asrType>(t);
        switch (ty) {
            case (ASR::asrType::unit) : return self().deserialize_unit();
            case (ASR::asrType::symbol) : return self().deserialize_symbol();
            case (ASR::asrType::stmt) : return self().deserialize_stmt();
            case (ASR::asrType::expr) : return self().deserialize_expr();
            case (ASR::asrType::ttype) : return self().deserialize_ttype();
            case (ASR::asrType::attribute) : return self().deserialize_attribute();
            case (ASR::asrType::tbind) : return self().deserialize_tbind();
            case (ASR::asrType::case_stmt) : return self().deserialize_case_stmt();
            case (ASR::asrType::type_stmt) : return self().deserialize_type_stmt();
            case (ASR::asrType::require_instantiation) : return self().deserialize_require_instantiation();
            default : throw LCompilersException("Unknown type in deserialize_node()");
        }
        throw LCompilersException("Switch statement above was not exhaustive.");
    }
    asr_t* deserialize_TranslationUnit() {
        size_t n_items; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_symtab_counter) == id_symtab_map.end());
        SymbolTable *m_symtab = al.make_new<SymbolTable>(nullptr);
        if (load_symtab_id) m_symtab->counter = m_symtab_counter;
        id_symtab_map[m_symtab_counter] = m_symtab;
        {
            size_t n = self().read_int64();
            for (size_t i=0; i<n; i++) {
                std::string name = self().read_string();
                symbol_t *sym = down_cast<symbol_t>(deserialize_symbol());
                self().symtab_insert_symbol(*m_symtab, name, sym);
            }
        }
        n_items = self().read_int64();
        Vec<asr_t*> v_items;
        v_items.reserve(al, n_items);
        for (size_t i=0; i<n_items; i++) {
            v_items.push_back(al, self().deserialize_node());
        }
        return ASR::make_TranslationUnit_t(al, loc, m_symtab, v_items.p, v_items.n);
    }
    asr_t* deserialize_unit() {
        uint8_t t = self().read_int8();
        ASR::unitType ty = static_cast<ASR::unitType>(t);
        switch (ty) {
            case (ASR::unitType::TranslationUnit) : return self().deserialize_TranslationUnit();
            default : throw LCompilersException("Unknown type in deserialize_unit()");
        }
        throw LCompilersException("Switch statement above was not exhaustive.");
    }
    asr_t* deserialize_Program() {
        size_t n_dependencies; // Sequence
        size_t n_body; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_symtab_counter) == id_symtab_map.end());
        SymbolTable *m_symtab = al.make_new<SymbolTable>(nullptr);
        if (load_symtab_id) m_symtab->counter = m_symtab_counter;
        id_symtab_map[m_symtab_counter] = m_symtab;
        {
            size_t n = self().read_int64();
            for (size_t i=0; i<n; i++) {
                std::string name = self().read_string();
                symbol_t *sym = down_cast<symbol_t>(deserialize_symbol());
                self().symtab_insert_symbol(*m_symtab, name, sym);
            }
        }
        char *m_name;
        m_name = self().read_cstring();
        n_dependencies = self().read_int64();
        Vec<char*> v_dependencies;
        v_dependencies.reserve(al, n_dependencies);
        for (size_t i=0; i<n_dependencies; i++) {
            v_dependencies.push_back(al, self().read_cstring());
        }
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        Location* m_start_name;
        m_start_name = al.make_new<Location>();
        m_start_name->first = self().read_int64();
        m_start_name->last = self().read_int64();
        Location* m_end_name;
        m_end_name = al.make_new<Location>();
        m_end_name->first = self().read_int64();
        m_end_name->last = self().read_int64();
        return ASR::make_Program_t(al, loc, m_symtab, m_name, v_dependencies.p, v_dependencies.n, v_body.p, v_body.n, m_start_name, m_end_name);
    }
    asr_t* deserialize_Module() {
        size_t n_dependencies; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_symtab_counter) == id_symtab_map.end());
        SymbolTable *m_symtab = al.make_new<SymbolTable>(nullptr);
        if (load_symtab_id) m_symtab->counter = m_symtab_counter;
        id_symtab_map[m_symtab_counter] = m_symtab;
        {
            size_t n = self().read_int64();
            for (size_t i=0; i<n; i++) {
                std::string name = self().read_string();
                symbol_t *sym = down_cast<symbol_t>(deserialize_symbol());
                self().symtab_insert_symbol(*m_symtab, name, sym);
            }
        }
        char *m_name;
        m_name = self().read_cstring();
        n_dependencies = self().read_int64();
        Vec<char*> v_dependencies;
        v_dependencies.reserve(al, n_dependencies);
        for (size_t i=0; i<n_dependencies; i++) {
            v_dependencies.push_back(al, self().read_cstring());
        }
        bool m_loaded_from_mod = self().read_bool();
        bool m_intrinsic = self().read_bool();
        Location* m_start_name;
        m_start_name = al.make_new<Location>();
        m_start_name->first = self().read_int64();
        m_start_name->last = self().read_int64();
        Location* m_end_name;
        m_end_name = al.make_new<Location>();
        m_end_name->first = self().read_int64();
        m_end_name->last = self().read_int64();
        return ASR::make_Module_t(al, loc, m_symtab, m_name, v_dependencies.p, v_dependencies.n, m_loaded_from_mod, m_intrinsic, m_start_name, m_end_name);
    }
    asr_t* deserialize_Function() {
        size_t n_dependencies; // Sequence
        size_t n_args; // Sequence
        size_t n_body; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_symtab_counter) == id_symtab_map.end());
        SymbolTable *m_symtab = al.make_new<SymbolTable>(nullptr);
        if (load_symtab_id) m_symtab->counter = m_symtab_counter;
        id_symtab_map[m_symtab_counter] = m_symtab;
        {
            size_t n = self().read_int64();
            for (size_t i=0; i<n; i++) {
                std::string name = self().read_string();
                symbol_t *sym = down_cast<symbol_t>(deserialize_symbol());
                self().symtab_insert_symbol(*m_symtab, name, sym);
            }
        }
        char *m_name;
        m_name = self().read_cstring();
        ASR::ttype_t *m_function_signature;
        m_function_signature = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        n_dependencies = self().read_int64();
        Vec<char*> v_dependencies;
        v_dependencies.reserve(al, n_dependencies);
        for (size_t i=0; i<n_dependencies; i++) {
            v_dependencies.push_back(al, self().read_cstring());
        }
        n_args = self().read_int64();
        Vec<expr_t*> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        ASR::expr_t *m_return_var;
        if (self().read_bool()) {
        m_return_var = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_return_var = nullptr;
        }
        ASR::accessType m_access = self().deserialize_access();
        bool m_deterministic = self().read_bool();
        bool m_side_effect_free = self().read_bool();
        char *m_module_file;
        bool m_module_file_present = self().read_bool();
        if (m_module_file_present) {
        m_module_file = self().read_cstring();
        } else {
        m_module_file = nullptr;
        }
        Location* m_start_name;
        m_start_name = al.make_new<Location>();
        m_start_name->first = self().read_int64();
        m_start_name->last = self().read_int64();
        Location* m_end_name;
        m_end_name = al.make_new<Location>();
        m_end_name->first = self().read_int64();
        m_end_name->last = self().read_int64();
        return ASR::make_Function_t(al, loc, m_symtab, m_name, m_function_signature, v_dependencies.p, v_dependencies.n, v_args.p, v_args.n, v_body.p, v_body.n, m_return_var, m_access, m_deterministic, m_side_effect_free, m_module_file, m_start_name, m_end_name);
    }
    asr_t* deserialize_GenericProcedure() {
        size_t n_procs; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_parent_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_parent_symtab_counter) != id_symtab_map.end());
        SymbolTable *m_parent_symtab = id_symtab_map[m_parent_symtab_counter];
        char *m_name;
        m_name = self().read_cstring();
        n_procs = self().read_int64();
        Vec<symbol_t*> v_procs;
        v_procs.reserve(al, n_procs);
        for (size_t i=0; i<n_procs; i++) {
            v_procs.push_back(al, self().read_symbol());
        }
        ASR::accessType m_access = self().deserialize_access();
        return ASR::make_GenericProcedure_t(al, loc, m_parent_symtab, m_name, v_procs.p, v_procs.n, m_access);
    }
    asr_t* deserialize_CustomOperator() {
        size_t n_procs; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_parent_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_parent_symtab_counter) != id_symtab_map.end());
        SymbolTable *m_parent_symtab = id_symtab_map[m_parent_symtab_counter];
        char *m_name;
        m_name = self().read_cstring();
        n_procs = self().read_int64();
        Vec<symbol_t*> v_procs;
        v_procs.reserve(al, n_procs);
        for (size_t i=0; i<n_procs; i++) {
            v_procs.push_back(al, self().read_symbol());
        }
        ASR::accessType m_access = self().deserialize_access();
        return ASR::make_CustomOperator_t(al, loc, m_parent_symtab, m_name, v_procs.p, v_procs.n, m_access);
    }
    asr_t* deserialize_ExternalSymbol() {
        size_t n_scope_names; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_parent_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_parent_symtab_counter) != id_symtab_map.end());
        SymbolTable *m_parent_symtab = id_symtab_map[m_parent_symtab_counter];
        char *m_name;
        m_name = self().read_cstring();
        ASR::symbol_t *m_external;
        // We skip the symbol for ExternalSymbol
        m_external = nullptr;
        char *m_module_name;
        m_module_name = self().read_cstring();
        n_scope_names = self().read_int64();
        Vec<char*> v_scope_names;
        v_scope_names.reserve(al, n_scope_names);
        for (size_t i=0; i<n_scope_names; i++) {
            v_scope_names.push_back(al, self().read_cstring());
        }
        char *m_original_name;
        m_original_name = self().read_cstring();
        ASR::accessType m_access = self().deserialize_access();
        return ASR::make_ExternalSymbol_t(al, loc, m_parent_symtab, m_name, m_external, m_module_name, v_scope_names.p, v_scope_names.n, m_original_name, m_access);
    }
    asr_t* deserialize_Struct() {
        size_t n_dependencies; // Sequence
        size_t n_members; // Sequence
        size_t n_member_functions; // Sequence
        size_t n_initializers; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_symtab_counter) == id_symtab_map.end());
        SymbolTable *m_symtab = al.make_new<SymbolTable>(nullptr);
        if (load_symtab_id) m_symtab->counter = m_symtab_counter;
        id_symtab_map[m_symtab_counter] = m_symtab;
        {
            size_t n = self().read_int64();
            for (size_t i=0; i<n; i++) {
                std::string name = self().read_string();
                symbol_t *sym = down_cast<symbol_t>(deserialize_symbol());
                self().symtab_insert_symbol(*m_symtab, name, sym);
            }
        }
        char *m_name;
        m_name = self().read_cstring();
        n_dependencies = self().read_int64();
        Vec<char*> v_dependencies;
        v_dependencies.reserve(al, n_dependencies);
        for (size_t i=0; i<n_dependencies; i++) {
            v_dependencies.push_back(al, self().read_cstring());
        }
        n_members = self().read_int64();
        Vec<char*> v_members;
        v_members.reserve(al, n_members);
        for (size_t i=0; i<n_members; i++) {
            v_members.push_back(al, self().read_cstring());
        }
        n_member_functions = self().read_int64();
        Vec<char*> v_member_functions;
        v_member_functions.reserve(al, n_member_functions);
        for (size_t i=0; i<n_member_functions; i++) {
            v_member_functions.push_back(al, self().read_cstring());
        }
        ASR::abiType m_abi = self().deserialize_abi();
        ASR::accessType m_access = self().deserialize_access();
        bool m_is_packed = self().read_bool();
        bool m_is_abstract = self().read_bool();
        n_initializers = self().read_int64();
        Vec<call_arg_t> v_initializers;
        v_initializers.reserve(al, n_initializers);
        for (size_t i=0; i<n_initializers; i++) {
            v_initializers.push_back(al, self().deserialize_call_arg());
        }
        ASR::expr_t *m_alignment;
        if (self().read_bool()) {
        m_alignment = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_alignment = nullptr;
        }
        ASR::symbol_t *m_parent;
        if (self().read_bool()) {
        m_parent = self().read_symbol();
        } else {
        m_parent = nullptr;
        }
        return ASR::make_Struct_t(al, loc, m_symtab, m_name, v_dependencies.p, v_dependencies.n, v_members.p, v_members.n, v_member_functions.p, v_member_functions.n, m_abi, m_access, m_is_packed, m_is_abstract, v_initializers.p, v_initializers.n, m_alignment, m_parent);
    }
    asr_t* deserialize_Enum() {
        size_t n_dependencies; // Sequence
        size_t n_members; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_symtab_counter) == id_symtab_map.end());
        SymbolTable *m_symtab = al.make_new<SymbolTable>(nullptr);
        if (load_symtab_id) m_symtab->counter = m_symtab_counter;
        id_symtab_map[m_symtab_counter] = m_symtab;
        {
            size_t n = self().read_int64();
            for (size_t i=0; i<n; i++) {
                std::string name = self().read_string();
                symbol_t *sym = down_cast<symbol_t>(deserialize_symbol());
                self().symtab_insert_symbol(*m_symtab, name, sym);
            }
        }
        char *m_name;
        m_name = self().read_cstring();
        n_dependencies = self().read_int64();
        Vec<char*> v_dependencies;
        v_dependencies.reserve(al, n_dependencies);
        for (size_t i=0; i<n_dependencies; i++) {
            v_dependencies.push_back(al, self().read_cstring());
        }
        n_members = self().read_int64();
        Vec<char*> v_members;
        v_members.reserve(al, n_members);
        for (size_t i=0; i<n_members; i++) {
            v_members.push_back(al, self().read_cstring());
        }
        ASR::abiType m_abi = self().deserialize_abi();
        ASR::accessType m_access = self().deserialize_access();
        ASR::enumtypeType m_enum_value_type = self().deserialize_enumtype();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::symbol_t *m_parent;
        if (self().read_bool()) {
        m_parent = self().read_symbol();
        } else {
        m_parent = nullptr;
        }
        return ASR::make_Enum_t(al, loc, m_symtab, m_name, v_dependencies.p, v_dependencies.n, v_members.p, v_members.n, m_abi, m_access, m_enum_value_type, m_type, m_parent);
    }
    asr_t* deserialize_Union() {
        size_t n_dependencies; // Sequence
        size_t n_members; // Sequence
        size_t n_initializers; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_symtab_counter) == id_symtab_map.end());
        SymbolTable *m_symtab = al.make_new<SymbolTable>(nullptr);
        if (load_symtab_id) m_symtab->counter = m_symtab_counter;
        id_symtab_map[m_symtab_counter] = m_symtab;
        {
            size_t n = self().read_int64();
            for (size_t i=0; i<n; i++) {
                std::string name = self().read_string();
                symbol_t *sym = down_cast<symbol_t>(deserialize_symbol());
                self().symtab_insert_symbol(*m_symtab, name, sym);
            }
        }
        char *m_name;
        m_name = self().read_cstring();
        n_dependencies = self().read_int64();
        Vec<char*> v_dependencies;
        v_dependencies.reserve(al, n_dependencies);
        for (size_t i=0; i<n_dependencies; i++) {
            v_dependencies.push_back(al, self().read_cstring());
        }
        n_members = self().read_int64();
        Vec<char*> v_members;
        v_members.reserve(al, n_members);
        for (size_t i=0; i<n_members; i++) {
            v_members.push_back(al, self().read_cstring());
        }
        ASR::abiType m_abi = self().deserialize_abi();
        ASR::accessType m_access = self().deserialize_access();
        n_initializers = self().read_int64();
        Vec<call_arg_t> v_initializers;
        v_initializers.reserve(al, n_initializers);
        for (size_t i=0; i<n_initializers; i++) {
            v_initializers.push_back(al, self().deserialize_call_arg());
        }
        ASR::symbol_t *m_parent;
        if (self().read_bool()) {
        m_parent = self().read_symbol();
        } else {
        m_parent = nullptr;
        }
        return ASR::make_Union_t(al, loc, m_symtab, m_name, v_dependencies.p, v_dependencies.n, v_members.p, v_members.n, m_abi, m_access, v_initializers.p, v_initializers.n, m_parent);
    }
    asr_t* deserialize_Variable() {
        size_t n_dependencies; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_parent_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_parent_symtab_counter) != id_symtab_map.end());
        SymbolTable *m_parent_symtab = id_symtab_map[m_parent_symtab_counter];
        char *m_name;
        m_name = self().read_cstring();
        n_dependencies = self().read_int64();
        Vec<char*> v_dependencies;
        v_dependencies.reserve(al, n_dependencies);
        for (size_t i=0; i<n_dependencies; i++) {
            v_dependencies.push_back(al, self().read_cstring());
        }
        ASR::intentType m_intent = self().deserialize_intent();
        ASR::expr_t *m_symbolic_value;
        if (self().read_bool()) {
        m_symbolic_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_symbolic_value = nullptr;
        }
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        ASR::storage_typeType m_storage = self().deserialize_storage_type();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::symbol_t *m_type_declaration;
        if (self().read_bool()) {
        m_type_declaration = self().read_symbol();
        } else {
        m_type_declaration = nullptr;
        }
        ASR::abiType m_abi = self().deserialize_abi();
        ASR::accessType m_access = self().deserialize_access();
        ASR::presenceType m_presence = self().deserialize_presence();
        bool m_value_attr = self().read_bool();
        bool m_target_attr = self().read_bool();
        bool m_contiguous_attr = self().read_bool();
        char *m_bindc_name;
        bool m_bindc_name_present = self().read_bool();
        if (m_bindc_name_present) {
        m_bindc_name = self().read_cstring();
        } else {
        m_bindc_name = nullptr;
        }
        return ASR::make_Variable_t(al, loc, m_parent_symtab, m_name, v_dependencies.p, v_dependencies.n, m_intent, m_symbolic_value, m_value, m_storage, m_type, m_type_declaration, m_abi, m_access, m_presence, m_value_attr, m_target_attr, m_contiguous_attr, m_bindc_name);
    }
    asr_t* deserialize_Class() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_symtab_counter) == id_symtab_map.end());
        SymbolTable *m_symtab = al.make_new<SymbolTable>(nullptr);
        if (load_symtab_id) m_symtab->counter = m_symtab_counter;
        id_symtab_map[m_symtab_counter] = m_symtab;
        {
            size_t n = self().read_int64();
            for (size_t i=0; i<n; i++) {
                std::string name = self().read_string();
                symbol_t *sym = down_cast<symbol_t>(deserialize_symbol());
                self().symtab_insert_symbol(*m_symtab, name, sym);
            }
        }
        char *m_name;
        m_name = self().read_cstring();
        ASR::abiType m_abi = self().deserialize_abi();
        ASR::accessType m_access = self().deserialize_access();
        return ASR::make_Class_t(al, loc, m_symtab, m_name, m_abi, m_access);
    }
    asr_t* deserialize_ClassProcedure() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_parent_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_parent_symtab_counter) != id_symtab_map.end());
        SymbolTable *m_parent_symtab = id_symtab_map[m_parent_symtab_counter];
        char *m_name;
        m_name = self().read_cstring();
        char *m_self_argument;
        bool m_self_argument_present = self().read_bool();
        if (m_self_argument_present) {
        m_self_argument = self().read_cstring();
        } else {
        m_self_argument = nullptr;
        }
        char *m_proc_name;
        m_proc_name = self().read_cstring();
        ASR::symbol_t *m_proc;
        m_proc = self().read_symbol();
        ASR::abiType m_abi = self().deserialize_abi();
        bool m_is_deferred = self().read_bool();
        bool m_is_nopass = self().read_bool();
        return ASR::make_ClassProcedure_t(al, loc, m_parent_symtab, m_name, m_self_argument, m_proc_name, m_proc, m_abi, m_is_deferred, m_is_nopass);
    }
    asr_t* deserialize_AssociateBlock() {
        size_t n_body; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_symtab_counter) == id_symtab_map.end());
        SymbolTable *m_symtab = al.make_new<SymbolTable>(nullptr);
        if (load_symtab_id) m_symtab->counter = m_symtab_counter;
        id_symtab_map[m_symtab_counter] = m_symtab;
        {
            size_t n = self().read_int64();
            for (size_t i=0; i<n; i++) {
                std::string name = self().read_string();
                symbol_t *sym = down_cast<symbol_t>(deserialize_symbol());
                self().symtab_insert_symbol(*m_symtab, name, sym);
            }
        }
        char *m_name;
        m_name = self().read_cstring();
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        return ASR::make_AssociateBlock_t(al, loc, m_symtab, m_name, v_body.p, v_body.n);
    }
    asr_t* deserialize_Block() {
        size_t n_body; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_symtab_counter) == id_symtab_map.end());
        SymbolTable *m_symtab = al.make_new<SymbolTable>(nullptr);
        if (load_symtab_id) m_symtab->counter = m_symtab_counter;
        id_symtab_map[m_symtab_counter] = m_symtab;
        {
            size_t n = self().read_int64();
            for (size_t i=0; i<n; i++) {
                std::string name = self().read_string();
                symbol_t *sym = down_cast<symbol_t>(deserialize_symbol());
                self().symtab_insert_symbol(*m_symtab, name, sym);
            }
        }
        char *m_name;
        m_name = self().read_cstring();
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        return ASR::make_Block_t(al, loc, m_symtab, m_name, v_body.p, v_body.n);
    }
    asr_t* deserialize_Requirement() {
        size_t n_args; // Sequence
        size_t n_requires; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_symtab_counter) == id_symtab_map.end());
        SymbolTable *m_symtab = al.make_new<SymbolTable>(nullptr);
        if (load_symtab_id) m_symtab->counter = m_symtab_counter;
        id_symtab_map[m_symtab_counter] = m_symtab;
        {
            size_t n = self().read_int64();
            for (size_t i=0; i<n; i++) {
                std::string name = self().read_string();
                symbol_t *sym = down_cast<symbol_t>(deserialize_symbol());
                self().symtab_insert_symbol(*m_symtab, name, sym);
            }
        }
        char *m_name;
        m_name = self().read_cstring();
        n_args = self().read_int64();
        Vec<char*> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, self().read_cstring());
        }
        n_requires = self().read_int64();
        Vec<require_instantiation_t*> v_requires;
        v_requires.reserve(al, n_requires);
        for (size_t i=0; i<n_requires; i++) {
            v_requires.push_back(al, ASR::down_cast<ASR::require_instantiation_t>(self().deserialize_require_instantiation()));
        }
        return ASR::make_Requirement_t(al, loc, m_symtab, m_name, v_args.p, v_args.n, v_requires.p, v_requires.n);
    }
    asr_t* deserialize_Template() {
        size_t n_args; // Sequence
        size_t n_requires; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        uint64_t m_symtab_counter = self().read_int64();
        LCOMPILERS_ASSERT(id_symtab_map.find(m_symtab_counter) == id_symtab_map.end());
        SymbolTable *m_symtab = al.make_new<SymbolTable>(nullptr);
        if (load_symtab_id) m_symtab->counter = m_symtab_counter;
        id_symtab_map[m_symtab_counter] = m_symtab;
        {
            size_t n = self().read_int64();
            for (size_t i=0; i<n; i++) {
                std::string name = self().read_string();
                symbol_t *sym = down_cast<symbol_t>(deserialize_symbol());
                self().symtab_insert_symbol(*m_symtab, name, sym);
            }
        }
        char *m_name;
        m_name = self().read_cstring();
        n_args = self().read_int64();
        Vec<char*> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, self().read_cstring());
        }
        n_requires = self().read_int64();
        Vec<require_instantiation_t*> v_requires;
        v_requires.reserve(al, n_requires);
        for (size_t i=0; i<n_requires; i++) {
            v_requires.push_back(al, ASR::down_cast<ASR::require_instantiation_t>(self().deserialize_require_instantiation()));
        }
        return ASR::make_Template_t(al, loc, m_symtab, m_name, v_args.p, v_args.n, v_requires.p, v_requires.n);
    }
    asr_t* deserialize_symbol() {
        uint8_t t = self().read_int8();
        ASR::symbolType ty = static_cast<ASR::symbolType>(t);
        switch (ty) {
            case (ASR::symbolType::Program) : return self().deserialize_Program();
            case (ASR::symbolType::Module) : return self().deserialize_Module();
            case (ASR::symbolType::Function) : return self().deserialize_Function();
            case (ASR::symbolType::GenericProcedure) : return self().deserialize_GenericProcedure();
            case (ASR::symbolType::CustomOperator) : return self().deserialize_CustomOperator();
            case (ASR::symbolType::ExternalSymbol) : return self().deserialize_ExternalSymbol();
            case (ASR::symbolType::Struct) : return self().deserialize_Struct();
            case (ASR::symbolType::Enum) : return self().deserialize_Enum();
            case (ASR::symbolType::Union) : return self().deserialize_Union();
            case (ASR::symbolType::Variable) : return self().deserialize_Variable();
            case (ASR::symbolType::Class) : return self().deserialize_Class();
            case (ASR::symbolType::ClassProcedure) : return self().deserialize_ClassProcedure();
            case (ASR::symbolType::AssociateBlock) : return self().deserialize_AssociateBlock();
            case (ASR::symbolType::Block) : return self().deserialize_Block();
            case (ASR::symbolType::Requirement) : return self().deserialize_Requirement();
            case (ASR::symbolType::Template) : return self().deserialize_Template();
            default : throw LCompilersException("Unknown type in deserialize_symbol()");
        }
        throw LCompilersException("Switch statement above was not exhaustive.");
    }
    asr_t* deserialize_Allocate() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_args = self().read_int64();
        Vec<alloc_arg_t> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, self().deserialize_alloc_arg());
        }
        ASR::expr_t *m_stat;
        if (self().read_bool()) {
        m_stat = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_stat = nullptr;
        }
        ASR::expr_t *m_errmsg;
        if (self().read_bool()) {
        m_errmsg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_errmsg = nullptr;
        }
        ASR::expr_t *m_source;
        if (self().read_bool()) {
        m_source = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_source = nullptr;
        }
        return ASR::make_Allocate_t(al, loc, v_args.p, v_args.n, m_stat, m_errmsg, m_source);
    }
    asr_t* deserialize_ReAlloc() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_args = self().read_int64();
        Vec<alloc_arg_t> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, self().deserialize_alloc_arg());
        }
        return ASR::make_ReAlloc_t(al, loc, v_args.p, v_args.n);
    }
    asr_t* deserialize_Assign() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_label = self().read_int64();
        char *m_variable;
        m_variable = self().read_cstring();
        return ASR::make_Assign_t(al, loc, m_label, m_variable);
    }
    asr_t* deserialize_Assignment() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_target;
        m_target = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_value;
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::stmt_t *m_overloaded;
        if (self().read_bool()) {
        m_overloaded = ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt());
        } else {
        m_overloaded = nullptr;
        }
        bool m_realloc_lhs = self().read_bool();
        return ASR::make_Assignment_t(al, loc, m_target, m_value, m_overloaded, m_realloc_lhs);
    }
    asr_t* deserialize_Associate() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_target;
        m_target = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_value;
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_Associate_t(al, loc, m_target, m_value);
    }
    asr_t* deserialize_Cycle() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        char *m_stmt_name;
        bool m_stmt_name_present = self().read_bool();
        if (m_stmt_name_present) {
        m_stmt_name = self().read_cstring();
        } else {
        m_stmt_name = nullptr;
        }
        return ASR::make_Cycle_t(al, loc, m_stmt_name);
    }
    asr_t* deserialize_ExplicitDeallocate() {
        size_t n_vars; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_vars = self().read_int64();
        Vec<expr_t*> v_vars;
        v_vars.reserve(al, n_vars);
        for (size_t i=0; i<n_vars; i++) {
            v_vars.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        return ASR::make_ExplicitDeallocate_t(al, loc, v_vars.p, v_vars.n);
    }
    asr_t* deserialize_ImplicitDeallocate() {
        size_t n_vars; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_vars = self().read_int64();
        Vec<expr_t*> v_vars;
        v_vars.reserve(al, n_vars);
        for (size_t i=0; i<n_vars; i++) {
            v_vars.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        return ASR::make_ImplicitDeallocate_t(al, loc, v_vars.p, v_vars.n);
    }
    asr_t* deserialize_DoConcurrentLoop() {
        size_t n_head; // Sequence
        size_t n_shared; // Sequence
        size_t n_local; // Sequence
        size_t n_reduction; // Sequence
        size_t n_body; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_head = self().read_int64();
        Vec<do_loop_head_t> v_head;
        v_head.reserve(al, n_head);
        for (size_t i=0; i<n_head; i++) {
            v_head.push_back(al, self().deserialize_do_loop_head());
        }
        n_shared = self().read_int64();
        Vec<expr_t*> v_shared;
        v_shared.reserve(al, n_shared);
        for (size_t i=0; i<n_shared; i++) {
            v_shared.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        n_local = self().read_int64();
        Vec<expr_t*> v_local;
        v_local.reserve(al, n_local);
        for (size_t i=0; i<n_local; i++) {
            v_local.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        n_reduction = self().read_int64();
        Vec<reduction_expr_t> v_reduction;
        v_reduction.reserve(al, n_reduction);
        for (size_t i=0; i<n_reduction; i++) {
            v_reduction.push_back(al, self().deserialize_reduction_expr());
        }
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        return ASR::make_DoConcurrentLoop_t(al, loc, v_head.p, v_head.n, v_shared.p, v_shared.n, v_local.p, v_local.n, v_reduction.p, v_reduction.n, v_body.p, v_body.n);
    }
    asr_t* deserialize_DoLoop() {
        size_t n_body; // Sequence
        size_t n_orelse; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        char *m_name;
        bool m_name_present = self().read_bool();
        if (m_name_present) {
        m_name = self().read_cstring();
        } else {
        m_name = nullptr;
        }
        ASR::do_loop_head_t m_head = self().deserialize_do_loop_head();
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        n_orelse = self().read_int64();
        Vec<stmt_t*> v_orelse;
        v_orelse.reserve(al, n_orelse);
        for (size_t i=0; i<n_orelse; i++) {
            v_orelse.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        return ASR::make_DoLoop_t(al, loc, m_name, m_head, v_body.p, v_body.n, v_orelse.p, v_orelse.n);
    }
    asr_t* deserialize_ErrorStop() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_code;
        if (self().read_bool()) {
        m_code = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_code = nullptr;
        }
        return ASR::make_ErrorStop_t(al, loc, m_code);
    }
    asr_t* deserialize_Exit() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        char *m_stmt_name;
        bool m_stmt_name_present = self().read_bool();
        if (m_stmt_name_present) {
        m_stmt_name = self().read_cstring();
        } else {
        m_stmt_name = nullptr;
        }
        return ASR::make_Exit_t(al, loc, m_stmt_name);
    }
    asr_t* deserialize_ForAllSingle() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::do_loop_head_t m_head = self().deserialize_do_loop_head();
        ASR::stmt_t *m_assign_stmt;
        m_assign_stmt = ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt());
        return ASR::make_ForAllSingle_t(al, loc, m_head, m_assign_stmt);
    }
    asr_t* deserialize_ForEach() {
        size_t n_body; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_var;
        m_var = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_container;
        m_container = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        return ASR::make_ForEach_t(al, loc, m_var, m_container, v_body.p, v_body.n);
    }
    asr_t* deserialize_GoTo() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_target_id = self().read_int64();
        char *m_name;
        m_name = self().read_cstring();
        return ASR::make_GoTo_t(al, loc, m_target_id, m_name);
    }
    asr_t* deserialize_GoToTarget() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_id = self().read_int64();
        char *m_name;
        m_name = self().read_cstring();
        return ASR::make_GoToTarget_t(al, loc, m_id, m_name);
    }
    asr_t* deserialize_If() {
        size_t n_body; // Sequence
        size_t n_orelse; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_test;
        m_test = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        n_orelse = self().read_int64();
        Vec<stmt_t*> v_orelse;
        v_orelse.reserve(al, n_orelse);
        for (size_t i=0; i<n_orelse; i++) {
            v_orelse.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        return ASR::make_If_t(al, loc, m_test, v_body.p, v_body.n, v_orelse.p, v_orelse.n);
    }
    asr_t* deserialize_IfArithmetic() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_test;
        m_test = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        int64_t m_lt_label = self().read_int64();
        int64_t m_eq_label = self().read_int64();
        int64_t m_gt_label = self().read_int64();
        return ASR::make_IfArithmetic_t(al, loc, m_test, m_lt_label, m_eq_label, m_gt_label);
    }
    asr_t* deserialize_Print() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_text;
        m_text = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_Print_t(al, loc, m_text);
    }
    asr_t* deserialize_FileOpen() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_label = self().read_int64();
        ASR::expr_t *m_newunit;
        if (self().read_bool()) {
        m_newunit = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_newunit = nullptr;
        }
        ASR::expr_t *m_filename;
        if (self().read_bool()) {
        m_filename = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_filename = nullptr;
        }
        ASR::expr_t *m_status;
        if (self().read_bool()) {
        m_status = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_status = nullptr;
        }
        ASR::expr_t *m_form;
        if (self().read_bool()) {
        m_form = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_form = nullptr;
        }
        ASR::expr_t *m_access;
        if (self().read_bool()) {
        m_access = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_access = nullptr;
        }
        ASR::expr_t *m_iostat;
        if (self().read_bool()) {
        m_iostat = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iostat = nullptr;
        }
        ASR::expr_t *m_iomsg;
        if (self().read_bool()) {
        m_iomsg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iomsg = nullptr;
        }
        return ASR::make_FileOpen_t(al, loc, m_label, m_newunit, m_filename, m_status, m_form, m_access, m_iostat, m_iomsg);
    }
    asr_t* deserialize_FileClose() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_label = self().read_int64();
        ASR::expr_t *m_unit;
        if (self().read_bool()) {
        m_unit = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_unit = nullptr;
        }
        ASR::expr_t *m_iostat;
        if (self().read_bool()) {
        m_iostat = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iostat = nullptr;
        }
        ASR::expr_t *m_iomsg;
        if (self().read_bool()) {
        m_iomsg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iomsg = nullptr;
        }
        ASR::expr_t *m_err;
        if (self().read_bool()) {
        m_err = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_err = nullptr;
        }
        ASR::expr_t *m_status;
        if (self().read_bool()) {
        m_status = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_status = nullptr;
        }
        return ASR::make_FileClose_t(al, loc, m_label, m_unit, m_iostat, m_iomsg, m_err, m_status);
    }
    asr_t* deserialize_FileRead() {
        size_t n_values; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_label = self().read_int64();
        ASR::expr_t *m_unit;
        if (self().read_bool()) {
        m_unit = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_unit = nullptr;
        }
        ASR::expr_t *m_fmt;
        if (self().read_bool()) {
        m_fmt = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_fmt = nullptr;
        }
        ASR::expr_t *m_iomsg;
        if (self().read_bool()) {
        m_iomsg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iomsg = nullptr;
        }
        ASR::expr_t *m_iostat;
        if (self().read_bool()) {
        m_iostat = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iostat = nullptr;
        }
        ASR::expr_t *m_advance;
        if (self().read_bool()) {
        m_advance = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_advance = nullptr;
        }
        ASR::expr_t *m_size;
        if (self().read_bool()) {
        m_size = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_size = nullptr;
        }
        ASR::expr_t *m_id;
        if (self().read_bool()) {
        m_id = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_id = nullptr;
        }
        n_values = self().read_int64();
        Vec<expr_t*> v_values;
        v_values.reserve(al, n_values);
        for (size_t i=0; i<n_values; i++) {
            v_values.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        ASR::stmt_t *m_overloaded;
        if (self().read_bool()) {
        m_overloaded = ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt());
        } else {
        m_overloaded = nullptr;
        }
        bool m_is_formatted = self().read_bool();
        return ASR::make_FileRead_t(al, loc, m_label, m_unit, m_fmt, m_iomsg, m_iostat, m_advance, m_size, m_id, v_values.p, v_values.n, m_overloaded, m_is_formatted);
    }
    asr_t* deserialize_FileBackspace() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_label = self().read_int64();
        ASR::expr_t *m_unit;
        if (self().read_bool()) {
        m_unit = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_unit = nullptr;
        }
        ASR::expr_t *m_iostat;
        if (self().read_bool()) {
        m_iostat = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iostat = nullptr;
        }
        ASR::expr_t *m_err;
        if (self().read_bool()) {
        m_err = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_err = nullptr;
        }
        return ASR::make_FileBackspace_t(al, loc, m_label, m_unit, m_iostat, m_err);
    }
    asr_t* deserialize_FileRewind() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_label = self().read_int64();
        ASR::expr_t *m_unit;
        if (self().read_bool()) {
        m_unit = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_unit = nullptr;
        }
        ASR::expr_t *m_iostat;
        if (self().read_bool()) {
        m_iostat = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iostat = nullptr;
        }
        ASR::expr_t *m_err;
        if (self().read_bool()) {
        m_err = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_err = nullptr;
        }
        return ASR::make_FileRewind_t(al, loc, m_label, m_unit, m_iostat, m_err);
    }
    asr_t* deserialize_FileInquire() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_label = self().read_int64();
        ASR::expr_t *m_unit;
        if (self().read_bool()) {
        m_unit = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_unit = nullptr;
        }
        ASR::expr_t *m_file;
        if (self().read_bool()) {
        m_file = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_file = nullptr;
        }
        ASR::expr_t *m_iostat;
        if (self().read_bool()) {
        m_iostat = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iostat = nullptr;
        }
        ASR::expr_t *m_err;
        if (self().read_bool()) {
        m_err = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_err = nullptr;
        }
        ASR::expr_t *m_exist;
        if (self().read_bool()) {
        m_exist = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_exist = nullptr;
        }
        ASR::expr_t *m_opened;
        if (self().read_bool()) {
        m_opened = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_opened = nullptr;
        }
        ASR::expr_t *m_number;
        if (self().read_bool()) {
        m_number = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_number = nullptr;
        }
        ASR::expr_t *m_named;
        if (self().read_bool()) {
        m_named = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_named = nullptr;
        }
        ASR::expr_t *m_name;
        if (self().read_bool()) {
        m_name = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_name = nullptr;
        }
        ASR::expr_t *m_access;
        if (self().read_bool()) {
        m_access = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_access = nullptr;
        }
        ASR::expr_t *m_sequential;
        if (self().read_bool()) {
        m_sequential = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_sequential = nullptr;
        }
        ASR::expr_t *m_direct;
        if (self().read_bool()) {
        m_direct = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_direct = nullptr;
        }
        ASR::expr_t *m_form;
        if (self().read_bool()) {
        m_form = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_form = nullptr;
        }
        ASR::expr_t *m_formatted;
        if (self().read_bool()) {
        m_formatted = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_formatted = nullptr;
        }
        ASR::expr_t *m_unformatted;
        if (self().read_bool()) {
        m_unformatted = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_unformatted = nullptr;
        }
        ASR::expr_t *m_recl;
        if (self().read_bool()) {
        m_recl = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_recl = nullptr;
        }
        ASR::expr_t *m_nextrec;
        if (self().read_bool()) {
        m_nextrec = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_nextrec = nullptr;
        }
        ASR::expr_t *m_blank;
        if (self().read_bool()) {
        m_blank = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_blank = nullptr;
        }
        ASR::expr_t *m_position;
        if (self().read_bool()) {
        m_position = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_position = nullptr;
        }
        ASR::expr_t *m_action;
        if (self().read_bool()) {
        m_action = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_action = nullptr;
        }
        ASR::expr_t *m_read;
        if (self().read_bool()) {
        m_read = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_read = nullptr;
        }
        ASR::expr_t *m_write;
        if (self().read_bool()) {
        m_write = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_write = nullptr;
        }
        ASR::expr_t *m_readwrite;
        if (self().read_bool()) {
        m_readwrite = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_readwrite = nullptr;
        }
        ASR::expr_t *m_delim;
        if (self().read_bool()) {
        m_delim = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_delim = nullptr;
        }
        ASR::expr_t *m_pad;
        if (self().read_bool()) {
        m_pad = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_pad = nullptr;
        }
        ASR::expr_t *m_flen;
        if (self().read_bool()) {
        m_flen = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_flen = nullptr;
        }
        ASR::expr_t *m_blocksize;
        if (self().read_bool()) {
        m_blocksize = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_blocksize = nullptr;
        }
        ASR::expr_t *m_convert;
        if (self().read_bool()) {
        m_convert = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_convert = nullptr;
        }
        ASR::expr_t *m_carriagecontrol;
        if (self().read_bool()) {
        m_carriagecontrol = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_carriagecontrol = nullptr;
        }
        ASR::expr_t *m_size;
        if (self().read_bool()) {
        m_size = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_size = nullptr;
        }
        ASR::expr_t *m_pos;
        if (self().read_bool()) {
        m_pos = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_pos = nullptr;
        }
        ASR::expr_t *m_iolength;
        if (self().read_bool()) {
        m_iolength = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iolength = nullptr;
        }
        return ASR::make_FileInquire_t(al, loc, m_label, m_unit, m_file, m_iostat, m_err, m_exist, m_opened, m_number, m_named, m_name, m_access, m_sequential, m_direct, m_form, m_formatted, m_unformatted, m_recl, m_nextrec, m_blank, m_position, m_action, m_read, m_write, m_readwrite, m_delim, m_pad, m_flen, m_blocksize, m_convert, m_carriagecontrol, m_size, m_pos, m_iolength);
    }
    asr_t* deserialize_FileWrite() {
        size_t n_values; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_label = self().read_int64();
        ASR::expr_t *m_unit;
        if (self().read_bool()) {
        m_unit = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_unit = nullptr;
        }
        ASR::expr_t *m_iomsg;
        if (self().read_bool()) {
        m_iomsg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iomsg = nullptr;
        }
        ASR::expr_t *m_iostat;
        if (self().read_bool()) {
        m_iostat = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iostat = nullptr;
        }
        ASR::expr_t *m_id;
        if (self().read_bool()) {
        m_id = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_id = nullptr;
        }
        n_values = self().read_int64();
        Vec<expr_t*> v_values;
        v_values.reserve(al, n_values);
        for (size_t i=0; i<n_values; i++) {
            v_values.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        ASR::expr_t *m_separator;
        if (self().read_bool()) {
        m_separator = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_separator = nullptr;
        }
        ASR::expr_t *m_end;
        if (self().read_bool()) {
        m_end = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_end = nullptr;
        }
        ASR::stmt_t *m_overloaded;
        if (self().read_bool()) {
        m_overloaded = ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt());
        } else {
        m_overloaded = nullptr;
        }
        bool m_is_formatted = self().read_bool();
        return ASR::make_FileWrite_t(al, loc, m_label, m_unit, m_iomsg, m_iostat, m_id, v_values.p, v_values.n, m_separator, m_end, m_overloaded, m_is_formatted);
    }
    asr_t* deserialize_Return() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        return ASR::make_Return_t(al, loc);
    }
    asr_t* deserialize_Select() {
        size_t n_body; // Sequence
        size_t n_default; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_test;
        m_test = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        n_body = self().read_int64();
        Vec<case_stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::case_stmt_t>(self().deserialize_case_stmt()));
        }
        n_default = self().read_int64();
        Vec<stmt_t*> v_default;
        v_default.reserve(al, n_default);
        for (size_t i=0; i<n_default; i++) {
            v_default.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        bool m_enable_fall_through = self().read_bool();
        return ASR::make_Select_t(al, loc, m_test, v_body.p, v_body.n, v_default.p, v_default.n, m_enable_fall_through);
    }
    asr_t* deserialize_Stop() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_code;
        if (self().read_bool()) {
        m_code = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_code = nullptr;
        }
        return ASR::make_Stop_t(al, loc, m_code);
    }
    asr_t* deserialize_Assert() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_test;
        m_test = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_msg;
        if (self().read_bool()) {
        m_msg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_msg = nullptr;
        }
        return ASR::make_Assert_t(al, loc, m_test, m_msg);
    }
    asr_t* deserialize_SubroutineCall() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::symbol_t *m_name;
        m_name = self().read_symbol();
        ASR::symbol_t *m_original_name;
        if (self().read_bool()) {
        m_original_name = self().read_symbol();
        } else {
        m_original_name = nullptr;
        }
        n_args = self().read_int64();
        Vec<call_arg_t> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, self().deserialize_call_arg());
        }
        ASR::expr_t *m_dt;
        if (self().read_bool()) {
        m_dt = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_dt = nullptr;
        }
        return ASR::make_SubroutineCall_t(al, loc, m_name, m_original_name, v_args.p, v_args.n, m_dt);
    }
    asr_t* deserialize_IntrinsicImpureSubroutine() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_sub_intrinsic_id = self().read_int64();
        n_args = self().read_int64();
        Vec<expr_t*> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        int64_t m_overload_id = self().read_int64();
        return ASR::make_IntrinsicImpureSubroutine_t(al, loc, m_sub_intrinsic_id, v_args.p, v_args.n, m_overload_id);
    }
    asr_t* deserialize_Where() {
        size_t n_body; // Sequence
        size_t n_orelse; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_test;
        m_test = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        n_orelse = self().read_int64();
        Vec<stmt_t*> v_orelse;
        v_orelse.reserve(al, n_orelse);
        for (size_t i=0; i<n_orelse; i++) {
            v_orelse.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        return ASR::make_Where_t(al, loc, m_test, v_body.p, v_body.n, v_orelse.p, v_orelse.n);
    }
    asr_t* deserialize_WhileLoop() {
        size_t n_body; // Sequence
        size_t n_orelse; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        char *m_name;
        bool m_name_present = self().read_bool();
        if (m_name_present) {
        m_name = self().read_cstring();
        } else {
        m_name = nullptr;
        }
        ASR::expr_t *m_test;
        m_test = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        n_orelse = self().read_int64();
        Vec<stmt_t*> v_orelse;
        v_orelse.reserve(al, n_orelse);
        for (size_t i=0; i<n_orelse; i++) {
            v_orelse.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        return ASR::make_WhileLoop_t(al, loc, m_name, m_test, v_body.p, v_body.n, v_orelse.p, v_orelse.n);
    }
    asr_t* deserialize_Nullify() {
        size_t n_vars; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_vars = self().read_int64();
        Vec<expr_t*> v_vars;
        v_vars.reserve(al, n_vars);
        for (size_t i=0; i<n_vars; i++) {
            v_vars.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        return ASR::make_Nullify_t(al, loc, v_vars.p, v_vars.n);
    }
    asr_t* deserialize_Flush() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_label = self().read_int64();
        ASR::expr_t *m_unit;
        m_unit = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_err;
        if (self().read_bool()) {
        m_err = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_err = nullptr;
        }
        ASR::expr_t *m_iomsg;
        if (self().read_bool()) {
        m_iomsg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iomsg = nullptr;
        }
        ASR::expr_t *m_iostat;
        if (self().read_bool()) {
        m_iostat = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_iostat = nullptr;
        }
        return ASR::make_Flush_t(al, loc, m_label, m_unit, m_err, m_iomsg, m_iostat);
    }
    asr_t* deserialize_ListAppend() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_ele;
        m_ele = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_ListAppend_t(al, loc, m_a, m_ele);
    }
    asr_t* deserialize_AssociateBlockCall() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::symbol_t *m_m;
        m_m = self().read_symbol();
        return ASR::make_AssociateBlockCall_t(al, loc, m_m);
    }
    asr_t* deserialize_SelectType() {
        size_t n_body; // Sequence
        size_t n_default; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_selector;
        m_selector = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        n_body = self().read_int64();
        Vec<type_stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::type_stmt_t>(self().deserialize_type_stmt()));
        }
        n_default = self().read_int64();
        Vec<stmt_t*> v_default;
        v_default.reserve(al, n_default);
        for (size_t i=0; i<n_default; i++) {
            v_default.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        return ASR::make_SelectType_t(al, loc, m_selector, v_body.p, v_body.n, v_default.p, v_default.n);
    }
    asr_t* deserialize_CPtrToPointer() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_cptr;
        m_cptr = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_ptr;
        m_ptr = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_shape;
        if (self().read_bool()) {
        m_shape = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_shape = nullptr;
        }
        ASR::expr_t *m_lower_bounds;
        if (self().read_bool()) {
        m_lower_bounds = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_lower_bounds = nullptr;
        }
        return ASR::make_CPtrToPointer_t(al, loc, m_cptr, m_ptr, m_shape, m_lower_bounds);
    }
    asr_t* deserialize_BlockCall() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_label = self().read_int64();
        ASR::symbol_t *m_m;
        m_m = self().read_symbol();
        return ASR::make_BlockCall_t(al, loc, m_label, m_m);
    }
    asr_t* deserialize_SetInsert() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_ele;
        m_ele = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_SetInsert_t(al, loc, m_a, m_ele);
    }
    asr_t* deserialize_SetRemove() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_ele;
        m_ele = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_SetRemove_t(al, loc, m_a, m_ele);
    }
    asr_t* deserialize_ListInsert() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_pos;
        m_pos = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_ele;
        m_ele = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_ListInsert_t(al, loc, m_a, m_pos, m_ele);
    }
    asr_t* deserialize_ListRemove() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_ele;
        m_ele = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_ListRemove_t(al, loc, m_a, m_ele);
    }
    asr_t* deserialize_ListClear() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_ListClear_t(al, loc, m_a);
    }
    asr_t* deserialize_DictInsert() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_key;
        m_key = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_value;
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_DictInsert_t(al, loc, m_a, m_key, m_value);
    }
    asr_t* deserialize_DictClear() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_DictClear_t(al, loc, m_a);
    }
    asr_t* deserialize_SetClear() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_SetClear_t(al, loc, m_a);
    }
    asr_t* deserialize_Expr() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_expression;
        m_expression = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_Expr_t(al, loc, m_expression);
    }
    asr_t* deserialize_stmt() {
        uint8_t t = self().read_int8();
        ASR::stmtType ty = static_cast<ASR::stmtType>(t);
        switch (ty) {
            case (ASR::stmtType::Allocate) : return self().deserialize_Allocate();
            case (ASR::stmtType::ReAlloc) : return self().deserialize_ReAlloc();
            case (ASR::stmtType::Assign) : return self().deserialize_Assign();
            case (ASR::stmtType::Assignment) : return self().deserialize_Assignment();
            case (ASR::stmtType::Associate) : return self().deserialize_Associate();
            case (ASR::stmtType::Cycle) : return self().deserialize_Cycle();
            case (ASR::stmtType::ExplicitDeallocate) : return self().deserialize_ExplicitDeallocate();
            case (ASR::stmtType::ImplicitDeallocate) : return self().deserialize_ImplicitDeallocate();
            case (ASR::stmtType::DoConcurrentLoop) : return self().deserialize_DoConcurrentLoop();
            case (ASR::stmtType::DoLoop) : return self().deserialize_DoLoop();
            case (ASR::stmtType::ErrorStop) : return self().deserialize_ErrorStop();
            case (ASR::stmtType::Exit) : return self().deserialize_Exit();
            case (ASR::stmtType::ForAllSingle) : return self().deserialize_ForAllSingle();
            case (ASR::stmtType::ForEach) : return self().deserialize_ForEach();
            case (ASR::stmtType::GoTo) : return self().deserialize_GoTo();
            case (ASR::stmtType::GoToTarget) : return self().deserialize_GoToTarget();
            case (ASR::stmtType::If) : return self().deserialize_If();
            case (ASR::stmtType::IfArithmetic) : return self().deserialize_IfArithmetic();
            case (ASR::stmtType::Print) : return self().deserialize_Print();
            case (ASR::stmtType::FileOpen) : return self().deserialize_FileOpen();
            case (ASR::stmtType::FileClose) : return self().deserialize_FileClose();
            case (ASR::stmtType::FileRead) : return self().deserialize_FileRead();
            case (ASR::stmtType::FileBackspace) : return self().deserialize_FileBackspace();
            case (ASR::stmtType::FileRewind) : return self().deserialize_FileRewind();
            case (ASR::stmtType::FileInquire) : return self().deserialize_FileInquire();
            case (ASR::stmtType::FileWrite) : return self().deserialize_FileWrite();
            case (ASR::stmtType::Return) : return self().deserialize_Return();
            case (ASR::stmtType::Select) : return self().deserialize_Select();
            case (ASR::stmtType::Stop) : return self().deserialize_Stop();
            case (ASR::stmtType::Assert) : return self().deserialize_Assert();
            case (ASR::stmtType::SubroutineCall) : return self().deserialize_SubroutineCall();
            case (ASR::stmtType::IntrinsicImpureSubroutine) : return self().deserialize_IntrinsicImpureSubroutine();
            case (ASR::stmtType::Where) : return self().deserialize_Where();
            case (ASR::stmtType::WhileLoop) : return self().deserialize_WhileLoop();
            case (ASR::stmtType::Nullify) : return self().deserialize_Nullify();
            case (ASR::stmtType::Flush) : return self().deserialize_Flush();
            case (ASR::stmtType::ListAppend) : return self().deserialize_ListAppend();
            case (ASR::stmtType::AssociateBlockCall) : return self().deserialize_AssociateBlockCall();
            case (ASR::stmtType::SelectType) : return self().deserialize_SelectType();
            case (ASR::stmtType::CPtrToPointer) : return self().deserialize_CPtrToPointer();
            case (ASR::stmtType::BlockCall) : return self().deserialize_BlockCall();
            case (ASR::stmtType::SetInsert) : return self().deserialize_SetInsert();
            case (ASR::stmtType::SetRemove) : return self().deserialize_SetRemove();
            case (ASR::stmtType::ListInsert) : return self().deserialize_ListInsert();
            case (ASR::stmtType::ListRemove) : return self().deserialize_ListRemove();
            case (ASR::stmtType::ListClear) : return self().deserialize_ListClear();
            case (ASR::stmtType::DictInsert) : return self().deserialize_DictInsert();
            case (ASR::stmtType::DictClear) : return self().deserialize_DictClear();
            case (ASR::stmtType::SetClear) : return self().deserialize_SetClear();
            case (ASR::stmtType::Expr) : return self().deserialize_Expr();
            default : throw LCompilersException("Unknown type in deserialize_stmt()");
        }
        throw LCompilersException("Switch statement above was not exhaustive.");
    }
    asr_t* deserialize_IfExp() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_test;
        m_test = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_body;
        m_body = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_orelse;
        m_orelse = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_IfExp_t(al, loc, m_test, m_body, m_orelse, m_type, m_value);
    }
    asr_t* deserialize_ComplexConstructor() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_re;
        m_re = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_im;
        m_im = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ComplexConstructor_t(al, loc, m_re, m_im, m_type, m_value);
    }
    asr_t* deserialize_NamedExpr() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_target;
        m_target = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_value;
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_NamedExpr_t(al, loc, m_target, m_value, m_type);
    }
    asr_t* deserialize_FunctionCall() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::symbol_t *m_name;
        m_name = self().read_symbol();
        ASR::symbol_t *m_original_name;
        if (self().read_bool()) {
        m_original_name = self().read_symbol();
        } else {
        m_original_name = nullptr;
        }
        n_args = self().read_int64();
        Vec<call_arg_t> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, self().deserialize_call_arg());
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        ASR::expr_t *m_dt;
        if (self().read_bool()) {
        m_dt = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_dt = nullptr;
        }
        return ASR::make_FunctionCall_t(al, loc, m_name, m_original_name, v_args.p, v_args.n, m_type, m_value, m_dt);
    }
    asr_t* deserialize_IntrinsicElementalFunction() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_intrinsic_id = self().read_int64();
        n_args = self().read_int64();
        Vec<expr_t*> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        int64_t m_overload_id = self().read_int64();
        ASR::ttype_t *m_type;
        if (self().read_bool()) {
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        } else {
        m_type = nullptr;
        }
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_IntrinsicElementalFunction_t(al, loc, m_intrinsic_id, v_args.p, v_args.n, m_overload_id, m_type, m_value);
    }
    asr_t* deserialize_IntrinsicArrayFunction() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_arr_intrinsic_id = self().read_int64();
        n_args = self().read_int64();
        Vec<expr_t*> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        int64_t m_overload_id = self().read_int64();
        ASR::ttype_t *m_type;
        if (self().read_bool()) {
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        } else {
        m_type = nullptr;
        }
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_IntrinsicArrayFunction_t(al, loc, m_arr_intrinsic_id, v_args.p, v_args.n, m_overload_id, m_type, m_value);
    }
    asr_t* deserialize_IntrinsicImpureFunction() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_impure_intrinsic_id = self().read_int64();
        n_args = self().read_int64();
        Vec<expr_t*> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        int64_t m_overload_id = self().read_int64();
        ASR::ttype_t *m_type;
        if (self().read_bool()) {
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        } else {
        m_type = nullptr;
        }
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_IntrinsicImpureFunction_t(al, loc, m_impure_intrinsic_id, v_args.p, v_args.n, m_overload_id, m_type, m_value);
    }
    asr_t* deserialize_TypeInquiry() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_inquiry_id = self().read_int64();
        ASR::ttype_t *m_arg_type;
        m_arg_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_arg;
        if (self().read_bool()) {
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_arg = nullptr;
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_TypeInquiry_t(al, loc, m_inquiry_id, m_arg_type, m_arg, m_type, m_value);
    }
    asr_t* deserialize_StructConstructor() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::symbol_t *m_dt_sym;
        m_dt_sym = self().read_symbol();
        n_args = self().read_int64();
        Vec<call_arg_t> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, self().deserialize_call_arg());
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StructConstructor_t(al, loc, m_dt_sym, v_args.p, v_args.n, m_type, m_value);
    }
    asr_t* deserialize_StructConstant() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::symbol_t *m_dt_sym;
        m_dt_sym = self().read_symbol();
        n_args = self().read_int64();
        Vec<call_arg_t> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, self().deserialize_call_arg());
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_StructConstant_t(al, loc, m_dt_sym, v_args.p, v_args.n, m_type);
    }
    asr_t* deserialize_EnumConstructor() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::symbol_t *m_dt_sym;
        m_dt_sym = self().read_symbol();
        n_args = self().read_int64();
        Vec<expr_t*> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_EnumConstructor_t(al, loc, m_dt_sym, v_args.p, v_args.n, m_type, m_value);
    }
    asr_t* deserialize_UnionConstructor() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::symbol_t *m_dt_sym;
        m_dt_sym = self().read_symbol();
        n_args = self().read_int64();
        Vec<expr_t*> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_UnionConstructor_t(al, loc, m_dt_sym, v_args.p, v_args.n, m_type, m_value);
    }
    asr_t* deserialize_ImpliedDoLoop() {
        size_t n_values; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_values = self().read_int64();
        Vec<expr_t*> v_values;
        v_values.reserve(al, n_values);
        for (size_t i=0; i<n_values; i++) {
            v_values.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        ASR::expr_t *m_var;
        m_var = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_start;
        m_start = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_end;
        m_end = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_increment;
        if (self().read_bool()) {
        m_increment = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_increment = nullptr;
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ImpliedDoLoop_t(al, loc, v_values.p, v_values.n, m_var, m_start, m_end, m_increment, m_type, m_value);
    }
    asr_t* deserialize_IntegerConstant() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_n = self().read_int64();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::integerbozType m_intboz_type = self().deserialize_integerboz();
        return ASR::make_IntegerConstant_t(al, loc, m_n, m_type, m_intboz_type);
    }
    asr_t* deserialize_IntegerBitNot() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_IntegerBitNot_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_IntegerUnaryMinus() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_IntegerUnaryMinus_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_IntegerCompare() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::cmpopType m_op = self().deserialize_cmpop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_IntegerCompare_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_IntegerBinOp() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::binopType m_op = self().deserialize_binop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_IntegerBinOp_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_UnsignedIntegerConstant() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_n = self().read_int64();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_UnsignedIntegerConstant_t(al, loc, m_n, m_type);
    }
    asr_t* deserialize_UnsignedIntegerUnaryMinus() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_UnsignedIntegerUnaryMinus_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_UnsignedIntegerBitNot() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_UnsignedIntegerBitNot_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_UnsignedIntegerCompare() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::cmpopType m_op = self().deserialize_cmpop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_UnsignedIntegerCompare_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_UnsignedIntegerBinOp() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::binopType m_op = self().deserialize_binop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_UnsignedIntegerBinOp_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_RealConstant() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        double m_r = self().read_float64();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_RealConstant_t(al, loc, m_r, m_type);
    }
    asr_t* deserialize_RealUnaryMinus() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_RealUnaryMinus_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_RealCompare() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::cmpopType m_op = self().deserialize_cmpop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_RealCompare_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_RealBinOp() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::binopType m_op = self().deserialize_binop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_RealBinOp_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_RealCopySign() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_target;
        m_target = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_source;
        m_source = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_RealCopySign_t(al, loc, m_target, m_source, m_type, m_value);
    }
    asr_t* deserialize_ComplexConstant() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        double m_re = self().read_float64();
        double m_im = self().read_float64();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_ComplexConstant_t(al, loc, m_re, m_im, m_type);
    }
    asr_t* deserialize_ComplexUnaryMinus() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ComplexUnaryMinus_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_ComplexCompare() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::cmpopType m_op = self().deserialize_cmpop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ComplexCompare_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_ComplexBinOp() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::binopType m_op = self().deserialize_binop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ComplexBinOp_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_LogicalConstant() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        bool m_value = self().read_bool();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_LogicalConstant_t(al, loc, m_value, m_type);
    }
    asr_t* deserialize_LogicalNot() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_LogicalNot_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_LogicalCompare() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::cmpopType m_op = self().deserialize_cmpop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_LogicalCompare_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_LogicalBinOp() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::logicalbinopType m_op = self().deserialize_logicalbinop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_LogicalBinOp_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_ListConstant() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_args = self().read_int64();
        Vec<expr_t*> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_ListConstant_t(al, loc, v_args.p, v_args.n, m_type);
    }
    asr_t* deserialize_ListLen() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ListLen_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_ListConcat() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ListConcat_t(al, loc, m_left, m_right, m_type, m_value);
    }
    asr_t* deserialize_ListCompare() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::cmpopType m_op = self().deserialize_cmpop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ListCompare_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_ListCount() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_ele;
        m_ele = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ListCount_t(al, loc, m_arg, m_ele, m_type, m_value);
    }
    asr_t* deserialize_ListContains() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ListContains_t(al, loc, m_left, m_right, m_type, m_value);
    }
    asr_t* deserialize_SetConstant() {
        size_t n_elements; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_elements = self().read_int64();
        Vec<expr_t*> v_elements;
        v_elements.reserve(al, n_elements);
        for (size_t i=0; i<n_elements; i++) {
            v_elements.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_SetConstant_t(al, loc, v_elements.p, v_elements.n, m_type);
    }
    asr_t* deserialize_SetLen() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_SetLen_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_TupleConstant() {
        size_t n_elements; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_elements = self().read_int64();
        Vec<expr_t*> v_elements;
        v_elements.reserve(al, n_elements);
        for (size_t i=0; i<n_elements; i++) {
            v_elements.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_TupleConstant_t(al, loc, v_elements.p, v_elements.n, m_type);
    }
    asr_t* deserialize_TupleLen() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_TupleLen_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_TupleCompare() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::cmpopType m_op = self().deserialize_cmpop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_TupleCompare_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_TupleConcat() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_TupleConcat_t(al, loc, m_left, m_right, m_type, m_value);
    }
    asr_t* deserialize_TupleContains() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_TupleContains_t(al, loc, m_left, m_right, m_type, m_value);
    }
    asr_t* deserialize_StringConstant() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        char *m_s;
        m_s = self().read_cstring();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_StringConstant_t(al, loc, m_s, m_type);
    }
    asr_t* deserialize_StringConcat() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StringConcat_t(al, loc, m_left, m_right, m_type, m_value);
    }
    asr_t* deserialize_StringRepeat() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StringRepeat_t(al, loc, m_left, m_right, m_type, m_value);
    }
    asr_t* deserialize_StringLen() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StringLen_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_StringItem() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_idx;
        m_idx = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StringItem_t(al, loc, m_arg, m_idx, m_type, m_value);
    }
    asr_t* deserialize_StringSection() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_start;
        if (self().read_bool()) {
        m_start = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_start = nullptr;
        }
        ASR::expr_t *m_end;
        if (self().read_bool()) {
        m_end = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_end = nullptr;
        }
        ASR::expr_t *m_step;
        if (self().read_bool()) {
        m_step = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_step = nullptr;
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StringSection_t(al, loc, m_arg, m_start, m_end, m_step, m_type, m_value);
    }
    asr_t* deserialize_StringCompare() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::cmpopType m_op = self().deserialize_cmpop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StringCompare_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_StringContains() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_substr;
        m_substr = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_str;
        m_str = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StringContains_t(al, loc, m_substr, m_str, m_type, m_value);
    }
    asr_t* deserialize_StringOrd() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StringOrd_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_StringChr() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StringChr_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_StringFormat() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_fmt;
        if (self().read_bool()) {
        m_fmt = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_fmt = nullptr;
        }
        n_args = self().read_int64();
        Vec<expr_t*> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        ASR::string_format_kindType m_kind = self().deserialize_string_format_kind();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StringFormat_t(al, loc, m_fmt, v_args.p, v_args.n, m_kind, m_type, m_value);
    }
    asr_t* deserialize_StringPhysicalCast() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::string_physical_typeType m_old = self().deserialize_string_physical_type();
        ASR::string_physical_typeType m_new = self().deserialize_string_physical_type();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StringPhysicalCast_t(al, loc, m_arg, m_old, m_new, m_type, m_value);
    }
    asr_t* deserialize_CPtrCompare() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::cmpopType m_op = self().deserialize_cmpop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_CPtrCompare_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_SymbolicCompare() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::cmpopType m_op = self().deserialize_cmpop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_SymbolicCompare_t(al, loc, m_left, m_op, m_right, m_type, m_value);
    }
    asr_t* deserialize_DictConstant() {
        size_t n_keys; // Sequence
        size_t n_values; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_keys = self().read_int64();
        Vec<expr_t*> v_keys;
        v_keys.reserve(al, n_keys);
        for (size_t i=0; i<n_keys; i++) {
            v_keys.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        n_values = self().read_int64();
        Vec<expr_t*> v_values;
        v_values.reserve(al, n_values);
        for (size_t i=0; i<n_values; i++) {
            v_values.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_DictConstant_t(al, loc, v_keys.p, v_keys.n, v_values.p, v_values.n, m_type);
    }
    asr_t* deserialize_DictLen() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_DictLen_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_Var() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::symbol_t *m_v;
        m_v = self().read_symbol();
        return ASR::make_Var_t(al, loc, m_v);
    }
    asr_t* deserialize_FunctionParam() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_param_number = self().read_int64();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_FunctionParam_t(al, loc, m_param_number, m_type, m_value);
    }
    asr_t* deserialize_ArrayConstructor() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_args = self().read_int64();
        Vec<expr_t*> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        ASR::arraystorageType m_storage_format = self().deserialize_arraystorage();
        return ASR::make_ArrayConstructor_t(al, loc, v_args.p, v_args.n, m_type, m_value, m_storage_format);
    }
    asr_t* deserialize_ArrayConstant() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_n_data = self().read_int64();
        void *m_data = self().read_void(m_n_data);
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::arraystorageType m_storage_format = self().deserialize_arraystorage();
        return ASR::make_ArrayConstant_t(al, loc, m_n_data, m_data, m_type, m_storage_format);
    }
    asr_t* deserialize_ArrayItem() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_v;
        m_v = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        n_args = self().read_int64();
        Vec<array_index_t> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, self().deserialize_array_index());
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::arraystorageType m_storage_format = self().deserialize_arraystorage();
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ArrayItem_t(al, loc, m_v, v_args.p, v_args.n, m_type, m_storage_format, m_value);
    }
    asr_t* deserialize_ArraySection() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_v;
        m_v = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        n_args = self().read_int64();
        Vec<array_index_t> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, self().deserialize_array_index());
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ArraySection_t(al, loc, m_v, v_args.p, v_args.n, m_type, m_value);
    }
    asr_t* deserialize_ArraySize() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_v;
        m_v = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_dim;
        if (self().read_bool()) {
        m_dim = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_dim = nullptr;
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ArraySize_t(al, loc, m_v, m_dim, m_type, m_value);
    }
    asr_t* deserialize_ArrayBound() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_v;
        m_v = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_dim;
        if (self().read_bool()) {
        m_dim = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_dim = nullptr;
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::arrayboundType m_bound = self().deserialize_arraybound();
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ArrayBound_t(al, loc, m_v, m_dim, m_type, m_bound, m_value);
    }
    asr_t* deserialize_ArrayTranspose() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_matrix;
        m_matrix = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ArrayTranspose_t(al, loc, m_matrix, m_type, m_value);
    }
    asr_t* deserialize_ArrayPack() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_array;
        m_array = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_mask;
        m_mask = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_vector;
        if (self().read_bool()) {
        m_vector = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_vector = nullptr;
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ArrayPack_t(al, loc, m_array, m_mask, m_vector, m_type, m_value);
    }
    asr_t* deserialize_ArrayReshape() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_array;
        m_array = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_shape;
        m_shape = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ArrayReshape_t(al, loc, m_array, m_shape, m_type, m_value);
    }
    asr_t* deserialize_ArrayBroadcast() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_array;
        m_array = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_shape;
        m_shape = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ArrayBroadcast_t(al, loc, m_array, m_shape, m_type, m_value);
    }
    asr_t* deserialize_BitCast() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_source;
        m_source = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_mold;
        m_mold = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_size;
        if (self().read_bool()) {
        m_size = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_size = nullptr;
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_BitCast_t(al, loc, m_source, m_mold, m_size, m_type, m_value);
    }
    asr_t* deserialize_StructInstanceMember() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_v;
        m_v = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::symbol_t *m_m;
        m_m = self().read_symbol();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StructInstanceMember_t(al, loc, m_v, m_m, m_type, m_value);
    }
    asr_t* deserialize_StructStaticMember() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_v;
        m_v = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::symbol_t *m_m;
        m_m = self().read_symbol();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_StructStaticMember_t(al, loc, m_v, m_m, m_type, m_value);
    }
    asr_t* deserialize_EnumStaticMember() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_v;
        m_v = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::symbol_t *m_m;
        m_m = self().read_symbol();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_EnumStaticMember_t(al, loc, m_v, m_m, m_type, m_value);
    }
    asr_t* deserialize_UnionInstanceMember() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_v;
        m_v = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::symbol_t *m_m;
        m_m = self().read_symbol();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_UnionInstanceMember_t(al, loc, m_v, m_m, m_type, m_value);
    }
    asr_t* deserialize_EnumName() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_v;
        m_v = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_enum_type;
        m_enum_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_EnumName_t(al, loc, m_v, m_enum_type, m_type, m_value);
    }
    asr_t* deserialize_EnumValue() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_v;
        m_v = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_enum_type;
        m_enum_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_EnumValue_t(al, loc, m_v, m_enum_type, m_type, m_value);
    }
    asr_t* deserialize_OverloadedCompare() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::cmpopType m_op = self().deserialize_cmpop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        ASR::expr_t *m_overloaded;
        m_overloaded = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_OverloadedCompare_t(al, loc, m_left, m_op, m_right, m_type, m_value, m_overloaded);
    }
    asr_t* deserialize_OverloadedBinOp() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::binopType m_op = self().deserialize_binop();
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        ASR::expr_t *m_overloaded;
        m_overloaded = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_OverloadedBinOp_t(al, loc, m_left, m_op, m_right, m_type, m_value, m_overloaded);
    }
    asr_t* deserialize_OverloadedUnaryMinus() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        ASR::expr_t *m_overloaded;
        m_overloaded = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_OverloadedUnaryMinus_t(al, loc, m_arg, m_type, m_value, m_overloaded);
    }
    asr_t* deserialize_OverloadedStringConcat() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        ASR::expr_t *m_overloaded;
        m_overloaded = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        return ASR::make_OverloadedStringConcat_t(al, loc, m_left, m_right, m_type, m_value, m_overloaded);
    }
    asr_t* deserialize_Cast() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::cast_kindType m_kind = self().deserialize_cast_kind();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_Cast_t(al, loc, m_arg, m_kind, m_type, m_value);
    }
    asr_t* deserialize_ArrayPhysicalCast() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::array_physical_typeType m_old = self().deserialize_array_physical_type();
        ASR::array_physical_typeType m_new = self().deserialize_array_physical_type();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ArrayPhysicalCast_t(al, loc, m_arg, m_old, m_new, m_type, m_value);
    }
    asr_t* deserialize_ComplexRe() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ComplexRe_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_ComplexIm() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ComplexIm_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_DictItem() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_key;
        m_key = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_default;
        if (self().read_bool()) {
        m_default = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_default = nullptr;
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_DictItem_t(al, loc, m_a, m_key, m_default, m_type, m_value);
    }
    asr_t* deserialize_CLoc() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_CLoc_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_PointerToCPtr() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_PointerToCPtr_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_GetPointer() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_GetPointer_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_ListItem() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_pos;
        m_pos = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ListItem_t(al, loc, m_a, m_pos, m_type, m_value);
    }
    asr_t* deserialize_TupleItem() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_pos;
        m_pos = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_TupleItem_t(al, loc, m_a, m_pos, m_type, m_value);
    }
    asr_t* deserialize_ListSection() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::array_index_t m_section = self().deserialize_array_index();
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ListSection_t(al, loc, m_a, m_section, m_type, m_value);
    }
    asr_t* deserialize_ListRepeat() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ListRepeat_t(al, loc, m_left, m_right, m_type, m_value);
    }
    asr_t* deserialize_DictPop() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_key;
        m_key = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_DictPop_t(al, loc, m_a, m_key, m_type, m_value);
    }
    asr_t* deserialize_SetPop() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_SetPop_t(al, loc, m_a, m_type, m_value);
    }
    asr_t* deserialize_SetContains() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_SetContains_t(al, loc, m_left, m_right, m_type, m_value);
    }
    asr_t* deserialize_DictContains() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_left;
        m_left = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_right;
        m_right = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_DictContains_t(al, loc, m_left, m_right, m_type, m_value);
    }
    asr_t* deserialize_IntegerBitLen() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_a;
        m_a = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_IntegerBitLen_t(al, loc, m_a, m_type, m_value);
    }
    asr_t* deserialize_Ichar() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_Ichar_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_Iachar() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_Iachar_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_SizeOfType() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::ttype_t *m_arg;
        m_arg = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_SizeOfType_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_PointerNullConstant() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_PointerNullConstant_t(al, loc, m_type);
    }
    asr_t* deserialize_PointerAssociated() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_ptr;
        m_ptr = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::expr_t *m_tgt;
        if (self().read_bool()) {
        m_tgt = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_tgt = nullptr;
        }
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_PointerAssociated_t(al, loc, m_ptr, m_tgt, m_type, m_value);
    }
    asr_t* deserialize_RealSqrt() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_arg;
        m_arg = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_RealSqrt_t(al, loc, m_arg, m_type, m_value);
    }
    asr_t* deserialize_ArrayIsContiguous() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_array;
        m_array = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::expr_t *m_value;
        if (self().read_bool()) {
        m_value = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_value = nullptr;
        }
        return ASR::make_ArrayIsContiguous_t(al, loc, m_array, m_type, m_value);
    }
    asr_t* deserialize_expr() {
        uint8_t t = self().read_int8();
        ASR::exprType ty = static_cast<ASR::exprType>(t);
        switch (ty) {
            case (ASR::exprType::IfExp) : return self().deserialize_IfExp();
            case (ASR::exprType::ComplexConstructor) : return self().deserialize_ComplexConstructor();
            case (ASR::exprType::NamedExpr) : return self().deserialize_NamedExpr();
            case (ASR::exprType::FunctionCall) : return self().deserialize_FunctionCall();
            case (ASR::exprType::IntrinsicElementalFunction) : return self().deserialize_IntrinsicElementalFunction();
            case (ASR::exprType::IntrinsicArrayFunction) : return self().deserialize_IntrinsicArrayFunction();
            case (ASR::exprType::IntrinsicImpureFunction) : return self().deserialize_IntrinsicImpureFunction();
            case (ASR::exprType::TypeInquiry) : return self().deserialize_TypeInquiry();
            case (ASR::exprType::StructConstructor) : return self().deserialize_StructConstructor();
            case (ASR::exprType::StructConstant) : return self().deserialize_StructConstant();
            case (ASR::exprType::EnumConstructor) : return self().deserialize_EnumConstructor();
            case (ASR::exprType::UnionConstructor) : return self().deserialize_UnionConstructor();
            case (ASR::exprType::ImpliedDoLoop) : return self().deserialize_ImpliedDoLoop();
            case (ASR::exprType::IntegerConstant) : return self().deserialize_IntegerConstant();
            case (ASR::exprType::IntegerBitNot) : return self().deserialize_IntegerBitNot();
            case (ASR::exprType::IntegerUnaryMinus) : return self().deserialize_IntegerUnaryMinus();
            case (ASR::exprType::IntegerCompare) : return self().deserialize_IntegerCompare();
            case (ASR::exprType::IntegerBinOp) : return self().deserialize_IntegerBinOp();
            case (ASR::exprType::UnsignedIntegerConstant) : return self().deserialize_UnsignedIntegerConstant();
            case (ASR::exprType::UnsignedIntegerUnaryMinus) : return self().deserialize_UnsignedIntegerUnaryMinus();
            case (ASR::exprType::UnsignedIntegerBitNot) : return self().deserialize_UnsignedIntegerBitNot();
            case (ASR::exprType::UnsignedIntegerCompare) : return self().deserialize_UnsignedIntegerCompare();
            case (ASR::exprType::UnsignedIntegerBinOp) : return self().deserialize_UnsignedIntegerBinOp();
            case (ASR::exprType::RealConstant) : return self().deserialize_RealConstant();
            case (ASR::exprType::RealUnaryMinus) : return self().deserialize_RealUnaryMinus();
            case (ASR::exprType::RealCompare) : return self().deserialize_RealCompare();
            case (ASR::exprType::RealBinOp) : return self().deserialize_RealBinOp();
            case (ASR::exprType::RealCopySign) : return self().deserialize_RealCopySign();
            case (ASR::exprType::ComplexConstant) : return self().deserialize_ComplexConstant();
            case (ASR::exprType::ComplexUnaryMinus) : return self().deserialize_ComplexUnaryMinus();
            case (ASR::exprType::ComplexCompare) : return self().deserialize_ComplexCompare();
            case (ASR::exprType::ComplexBinOp) : return self().deserialize_ComplexBinOp();
            case (ASR::exprType::LogicalConstant) : return self().deserialize_LogicalConstant();
            case (ASR::exprType::LogicalNot) : return self().deserialize_LogicalNot();
            case (ASR::exprType::LogicalCompare) : return self().deserialize_LogicalCompare();
            case (ASR::exprType::LogicalBinOp) : return self().deserialize_LogicalBinOp();
            case (ASR::exprType::ListConstant) : return self().deserialize_ListConstant();
            case (ASR::exprType::ListLen) : return self().deserialize_ListLen();
            case (ASR::exprType::ListConcat) : return self().deserialize_ListConcat();
            case (ASR::exprType::ListCompare) : return self().deserialize_ListCompare();
            case (ASR::exprType::ListCount) : return self().deserialize_ListCount();
            case (ASR::exprType::ListContains) : return self().deserialize_ListContains();
            case (ASR::exprType::SetConstant) : return self().deserialize_SetConstant();
            case (ASR::exprType::SetLen) : return self().deserialize_SetLen();
            case (ASR::exprType::TupleConstant) : return self().deserialize_TupleConstant();
            case (ASR::exprType::TupleLen) : return self().deserialize_TupleLen();
            case (ASR::exprType::TupleCompare) : return self().deserialize_TupleCompare();
            case (ASR::exprType::TupleConcat) : return self().deserialize_TupleConcat();
            case (ASR::exprType::TupleContains) : return self().deserialize_TupleContains();
            case (ASR::exprType::StringConstant) : return self().deserialize_StringConstant();
            case (ASR::exprType::StringConcat) : return self().deserialize_StringConcat();
            case (ASR::exprType::StringRepeat) : return self().deserialize_StringRepeat();
            case (ASR::exprType::StringLen) : return self().deserialize_StringLen();
            case (ASR::exprType::StringItem) : return self().deserialize_StringItem();
            case (ASR::exprType::StringSection) : return self().deserialize_StringSection();
            case (ASR::exprType::StringCompare) : return self().deserialize_StringCompare();
            case (ASR::exprType::StringContains) : return self().deserialize_StringContains();
            case (ASR::exprType::StringOrd) : return self().deserialize_StringOrd();
            case (ASR::exprType::StringChr) : return self().deserialize_StringChr();
            case (ASR::exprType::StringFormat) : return self().deserialize_StringFormat();
            case (ASR::exprType::StringPhysicalCast) : return self().deserialize_StringPhysicalCast();
            case (ASR::exprType::CPtrCompare) : return self().deserialize_CPtrCompare();
            case (ASR::exprType::SymbolicCompare) : return self().deserialize_SymbolicCompare();
            case (ASR::exprType::DictConstant) : return self().deserialize_DictConstant();
            case (ASR::exprType::DictLen) : return self().deserialize_DictLen();
            case (ASR::exprType::Var) : return self().deserialize_Var();
            case (ASR::exprType::FunctionParam) : return self().deserialize_FunctionParam();
            case (ASR::exprType::ArrayConstructor) : return self().deserialize_ArrayConstructor();
            case (ASR::exprType::ArrayConstant) : return self().deserialize_ArrayConstant();
            case (ASR::exprType::ArrayItem) : return self().deserialize_ArrayItem();
            case (ASR::exprType::ArraySection) : return self().deserialize_ArraySection();
            case (ASR::exprType::ArraySize) : return self().deserialize_ArraySize();
            case (ASR::exprType::ArrayBound) : return self().deserialize_ArrayBound();
            case (ASR::exprType::ArrayTranspose) : return self().deserialize_ArrayTranspose();
            case (ASR::exprType::ArrayPack) : return self().deserialize_ArrayPack();
            case (ASR::exprType::ArrayReshape) : return self().deserialize_ArrayReshape();
            case (ASR::exprType::ArrayBroadcast) : return self().deserialize_ArrayBroadcast();
            case (ASR::exprType::BitCast) : return self().deserialize_BitCast();
            case (ASR::exprType::StructInstanceMember) : return self().deserialize_StructInstanceMember();
            case (ASR::exprType::StructStaticMember) : return self().deserialize_StructStaticMember();
            case (ASR::exprType::EnumStaticMember) : return self().deserialize_EnumStaticMember();
            case (ASR::exprType::UnionInstanceMember) : return self().deserialize_UnionInstanceMember();
            case (ASR::exprType::EnumName) : return self().deserialize_EnumName();
            case (ASR::exprType::EnumValue) : return self().deserialize_EnumValue();
            case (ASR::exprType::OverloadedCompare) : return self().deserialize_OverloadedCompare();
            case (ASR::exprType::OverloadedBinOp) : return self().deserialize_OverloadedBinOp();
            case (ASR::exprType::OverloadedUnaryMinus) : return self().deserialize_OverloadedUnaryMinus();
            case (ASR::exprType::OverloadedStringConcat) : return self().deserialize_OverloadedStringConcat();
            case (ASR::exprType::Cast) : return self().deserialize_Cast();
            case (ASR::exprType::ArrayPhysicalCast) : return self().deserialize_ArrayPhysicalCast();
            case (ASR::exprType::ComplexRe) : return self().deserialize_ComplexRe();
            case (ASR::exprType::ComplexIm) : return self().deserialize_ComplexIm();
            case (ASR::exprType::DictItem) : return self().deserialize_DictItem();
            case (ASR::exprType::CLoc) : return self().deserialize_CLoc();
            case (ASR::exprType::PointerToCPtr) : return self().deserialize_PointerToCPtr();
            case (ASR::exprType::GetPointer) : return self().deserialize_GetPointer();
            case (ASR::exprType::ListItem) : return self().deserialize_ListItem();
            case (ASR::exprType::TupleItem) : return self().deserialize_TupleItem();
            case (ASR::exprType::ListSection) : return self().deserialize_ListSection();
            case (ASR::exprType::ListRepeat) : return self().deserialize_ListRepeat();
            case (ASR::exprType::DictPop) : return self().deserialize_DictPop();
            case (ASR::exprType::SetPop) : return self().deserialize_SetPop();
            case (ASR::exprType::SetContains) : return self().deserialize_SetContains();
            case (ASR::exprType::DictContains) : return self().deserialize_DictContains();
            case (ASR::exprType::IntegerBitLen) : return self().deserialize_IntegerBitLen();
            case (ASR::exprType::Ichar) : return self().deserialize_Ichar();
            case (ASR::exprType::Iachar) : return self().deserialize_Iachar();
            case (ASR::exprType::SizeOfType) : return self().deserialize_SizeOfType();
            case (ASR::exprType::PointerNullConstant) : return self().deserialize_PointerNullConstant();
            case (ASR::exprType::PointerAssociated) : return self().deserialize_PointerAssociated();
            case (ASR::exprType::RealSqrt) : return self().deserialize_RealSqrt();
            case (ASR::exprType::ArrayIsContiguous) : return self().deserialize_ArrayIsContiguous();
            default : throw LCompilersException("Unknown type in deserialize_expr()");
        }
        throw LCompilersException("Switch statement above was not exhaustive.");
    }
    asr_t* deserialize_Integer() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_kind = self().read_int64();
        return ASR::make_Integer_t(al, loc, m_kind);
    }
    asr_t* deserialize_UnsignedInteger() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_kind = self().read_int64();
        return ASR::make_UnsignedInteger_t(al, loc, m_kind);
    }
    asr_t* deserialize_Real() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_kind = self().read_int64();
        return ASR::make_Real_t(al, loc, m_kind);
    }
    asr_t* deserialize_Complex() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_kind = self().read_int64();
        return ASR::make_Complex_t(al, loc, m_kind);
    }
    asr_t* deserialize_String() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_kind = self().read_int64();
        int64_t m_len = self().read_int64();
        ASR::expr_t *m_len_expr;
        if (self().read_bool()) {
        m_len_expr = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_len_expr = nullptr;
        }
        ASR::string_physical_typeType m_physical_type = self().deserialize_string_physical_type();
        return ASR::make_String_t(al, loc, m_kind, m_len, m_len_expr, m_physical_type);
    }
    asr_t* deserialize_Logical() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        int64_t m_kind = self().read_int64();
        return ASR::make_Logical_t(al, loc, m_kind);
    }
    asr_t* deserialize_Set() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_Set_t(al, loc, m_type);
    }
    asr_t* deserialize_List() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_List_t(al, loc, m_type);
    }
    asr_t* deserialize_Tuple() {
        size_t n_type; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_type = self().read_int64();
        Vec<ttype_t*> v_type;
        v_type.reserve(al, n_type);
        for (size_t i=0; i<n_type; i++) {
            v_type.push_back(al, ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype()));
        }
        return ASR::make_Tuple_t(al, loc, v_type.p, v_type.n);
    }
    asr_t* deserialize_StructType() {
        size_t n_data_member_types; // Sequence
        size_t n_member_function_types; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_data_member_types = self().read_int64();
        Vec<ttype_t*> v_data_member_types;
        v_data_member_types.reserve(al, n_data_member_types);
        for (size_t i=0; i<n_data_member_types; i++) {
            v_data_member_types.push_back(al, ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype()));
        }
        n_member_function_types = self().read_int64();
        Vec<ttype_t*> v_member_function_types;
        v_member_function_types.reserve(al, n_member_function_types);
        for (size_t i=0; i<n_member_function_types; i++) {
            v_member_function_types.push_back(al, ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype()));
        }
        bool m_is_cstruct = self().read_bool();
        ASR::symbol_t *m_derived_type;
        m_derived_type = self().read_symbol();
        return ASR::make_StructType_t(al, loc, v_data_member_types.p, v_data_member_types.n, v_member_function_types.p, v_member_function_types.n, m_is_cstruct, m_derived_type);
    }
    asr_t* deserialize_EnumType() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::symbol_t *m_enum_type;
        m_enum_type = self().read_symbol();
        return ASR::make_EnumType_t(al, loc, m_enum_type);
    }
    asr_t* deserialize_UnionType() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::symbol_t *m_union_type;
        m_union_type = self().read_symbol();
        return ASR::make_UnionType_t(al, loc, m_union_type);
    }
    asr_t* deserialize_ClassType() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::symbol_t *m_class_type;
        m_class_type = self().read_symbol();
        return ASR::make_ClassType_t(al, loc, m_class_type);
    }
    asr_t* deserialize_Dict() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::ttype_t *m_key_type;
        m_key_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        ASR::ttype_t *m_value_type;
        m_value_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_Dict_t(al, loc, m_key_type, m_value_type);
    }
    asr_t* deserialize_Pointer() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_Pointer_t(al, loc, m_type);
    }
    asr_t* deserialize_Allocatable() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        return ASR::make_Allocatable_t(al, loc, m_type);
    }
    asr_t* deserialize_CPtr() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        return ASR::make_CPtr_t(al, loc);
    }
    asr_t* deserialize_SymbolicExpression() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        return ASR::make_SymbolicExpression_t(al, loc);
    }
    asr_t* deserialize_TypeParameter() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        char *m_param;
        m_param = self().read_cstring();
        return ASR::make_TypeParameter_t(al, loc, m_param);
    }
    asr_t* deserialize_Array() {
        size_t n_dims; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        n_dims = self().read_int64();
        Vec<dimension_t> v_dims;
        v_dims.reserve(al, n_dims);
        for (size_t i=0; i<n_dims; i++) {
            v_dims.push_back(al, self().deserialize_dimension());
        }
        ASR::array_physical_typeType m_physical_type = self().deserialize_array_physical_type();
        return ASR::make_Array_t(al, loc, m_type, v_dims.p, v_dims.n, m_physical_type);
    }
    asr_t* deserialize_FunctionType() {
        size_t n_arg_types; // Sequence
        size_t n_restrictions; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_arg_types = self().read_int64();
        Vec<ttype_t*> v_arg_types;
        v_arg_types.reserve(al, n_arg_types);
        for (size_t i=0; i<n_arg_types; i++) {
            v_arg_types.push_back(al, ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype()));
        }
        ASR::ttype_t *m_return_var_type;
        if (self().read_bool()) {
        m_return_var_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        } else {
        m_return_var_type = nullptr;
        }
        ASR::abiType m_abi = self().deserialize_abi();
        ASR::deftypeType m_deftype = self().deserialize_deftype();
        char *m_bindc_name;
        bool m_bindc_name_present = self().read_bool();
        if (m_bindc_name_present) {
        m_bindc_name = self().read_cstring();
        } else {
        m_bindc_name = nullptr;
        }
        bool m_elemental = self().read_bool();
        bool m_pure = self().read_bool();
        bool m_module = self().read_bool();
        bool m_inline = self().read_bool();
        bool m_static = self().read_bool();
        n_restrictions = self().read_int64();
        Vec<symbol_t*> v_restrictions;
        v_restrictions.reserve(al, n_restrictions);
        for (size_t i=0; i<n_restrictions; i++) {
            v_restrictions.push_back(al, self().read_symbol());
        }
        bool m_is_restriction = self().read_bool();
        return ASR::make_FunctionType_t(al, loc, v_arg_types.p, v_arg_types.n, m_return_var_type, m_abi, m_deftype, m_bindc_name, m_elemental, m_pure, m_module, m_inline, m_static, v_restrictions.p, v_restrictions.n, m_is_restriction);
    }
    asr_t* deserialize_ttype() {
        uint8_t t = self().read_int8();
        ASR::ttypeType ty = static_cast<ASR::ttypeType>(t);
        switch (ty) {
            case (ASR::ttypeType::Integer) : return self().deserialize_Integer();
            case (ASR::ttypeType::UnsignedInteger) : return self().deserialize_UnsignedInteger();
            case (ASR::ttypeType::Real) : return self().deserialize_Real();
            case (ASR::ttypeType::Complex) : return self().deserialize_Complex();
            case (ASR::ttypeType::String) : return self().deserialize_String();
            case (ASR::ttypeType::Logical) : return self().deserialize_Logical();
            case (ASR::ttypeType::Set) : return self().deserialize_Set();
            case (ASR::ttypeType::List) : return self().deserialize_List();
            case (ASR::ttypeType::Tuple) : return self().deserialize_Tuple();
            case (ASR::ttypeType::StructType) : return self().deserialize_StructType();
            case (ASR::ttypeType::EnumType) : return self().deserialize_EnumType();
            case (ASR::ttypeType::UnionType) : return self().deserialize_UnionType();
            case (ASR::ttypeType::ClassType) : return self().deserialize_ClassType();
            case (ASR::ttypeType::Dict) : return self().deserialize_Dict();
            case (ASR::ttypeType::Pointer) : return self().deserialize_Pointer();
            case (ASR::ttypeType::Allocatable) : return self().deserialize_Allocatable();
            case (ASR::ttypeType::CPtr) : return self().deserialize_CPtr();
            case (ASR::ttypeType::SymbolicExpression) : return self().deserialize_SymbolicExpression();
            case (ASR::ttypeType::TypeParameter) : return self().deserialize_TypeParameter();
            case (ASR::ttypeType::Array) : return self().deserialize_Array();
            case (ASR::ttypeType::FunctionType) : return self().deserialize_FunctionType();
            default : throw LCompilersException("Unknown type in deserialize_ttype()");
        }
        throw LCompilersException("Switch statement above was not exhaustive.");
    }
    cast_kindType deserialize_cast_kind() {
        uint8_t t = self().read_int8();
        cast_kindType ty = static_cast<cast_kindType>(t);
        return ty;
    }
    storage_typeType deserialize_storage_type() {
        uint8_t t = self().read_int8();
        storage_typeType ty = static_cast<storage_typeType>(t);
        return ty;
    }
    accessType deserialize_access() {
        uint8_t t = self().read_int8();
        accessType ty = static_cast<accessType>(t);
        return ty;
    }
    intentType deserialize_intent() {
        uint8_t t = self().read_int8();
        intentType ty = static_cast<intentType>(t);
        return ty;
    }
    deftypeType deserialize_deftype() {
        uint8_t t = self().read_int8();
        deftypeType ty = static_cast<deftypeType>(t);
        return ty;
    }
    presenceType deserialize_presence() {
        uint8_t t = self().read_int8();
        presenceType ty = static_cast<presenceType>(t);
        return ty;
    }
    abiType deserialize_abi() {
        uint8_t t = self().read_int8();
        abiType ty = static_cast<abiType>(t);
        return ty;
    }
    dimension_t deserialize_dimension() {
        dimension_t x;
        {
            bool present=self().read_bool();
            if (present) {
                x.m_start = down_cast<expr_t>(deserialize_expr());
            } else {
                x.m_start = nullptr;
            }
        }
        {
            bool present=self().read_bool();
            if (present) {
                x.m_length = down_cast<expr_t>(deserialize_expr());
            } else {
                x.m_length = nullptr;
            }
        }
        return x;
    }
    alloc_arg_t deserialize_alloc_arg() {
        alloc_arg_t x;
        {
                x.m_a = down_cast<expr_t>(deserialize_expr());
        }
        {
            uint64_t n = self().read_int64();
            Vec<dimension_t> v;
            v.reserve(al, n);
            for (uint64_t i=0; i<n; i++) {
                v.push_back(al, self().deserialize_dimension());
            }
            x.m_dims = v.p;
            x.n_dims = v.n;
        }
        {
            bool present=self().read_bool();
            if (present) {
                x.m_len_expr = down_cast<expr_t>(deserialize_expr());
            } else {
                x.m_len_expr = nullptr;
            }
        }
        {
            bool present=self().read_bool();
            if (present) {
                x.m_type = down_cast<ttype_t>(deserialize_ttype());
            } else {
                x.m_type = nullptr;
            }
        }
        return x;
    }
    asr_t* deserialize_Attribute() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        char *m_name;
        m_name = self().read_cstring();
        n_args = self().read_int64();
        Vec<attribute_arg_t> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, self().deserialize_attribute_arg());
        }
        return ASR::make_Attribute_t(al, loc, m_name, v_args.p, v_args.n);
    }
    asr_t* deserialize_attribute() {
        uint8_t t = self().read_int8();
        ASR::attributeType ty = static_cast<ASR::attributeType>(t);
        switch (ty) {
            case (ASR::attributeType::Attribute) : return self().deserialize_Attribute();
            default : throw LCompilersException("Unknown type in deserialize_attribute()");
        }
        throw LCompilersException("Switch statement above was not exhaustive.");
    }
    attribute_arg_t deserialize_attribute_arg() {
        attribute_arg_t x;
        {
                x.m_arg = self().read_cstring();
        }
        return x;
    }
    call_arg_t deserialize_call_arg() {
        call_arg_t x;
        {
            bool present=self().read_bool();
            if (present) {
                x.m_value = down_cast<expr_t>(deserialize_expr());
            } else {
                x.m_value = nullptr;
            }
        }
        return x;
    }
    reduction_expr_t deserialize_reduction_expr() {
        reduction_expr_t x;
        {
                x.m_op = deserialize_reduction_op();
        }
        {
                x.m_arg = down_cast<expr_t>(deserialize_expr());
        }
        return x;
    }
    asr_t* deserialize_Bind() {
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        char *m_lang;
        m_lang = self().read_cstring();
        char *m_name;
        m_name = self().read_cstring();
        return ASR::make_Bind_t(al, loc, m_lang, m_name);
    }
    asr_t* deserialize_tbind() {
        uint8_t t = self().read_int8();
        ASR::tbindType ty = static_cast<ASR::tbindType>(t);
        switch (ty) {
            case (ASR::tbindType::Bind) : return self().deserialize_Bind();
            default : throw LCompilersException("Unknown type in deserialize_tbind()");
        }
        throw LCompilersException("Switch statement above was not exhaustive.");
    }
    array_index_t deserialize_array_index() {
        array_index_t x;
        {
            bool present=self().read_bool();
            if (present) {
                x.m_left = down_cast<expr_t>(deserialize_expr());
            } else {
                x.m_left = nullptr;
            }
        }
        {
            bool present=self().read_bool();
            if (present) {
                x.m_right = down_cast<expr_t>(deserialize_expr());
            } else {
                x.m_right = nullptr;
            }
        }
        {
            bool present=self().read_bool();
            if (present) {
                x.m_step = down_cast<expr_t>(deserialize_expr());
            } else {
                x.m_step = nullptr;
            }
        }
        return x;
    }
    do_loop_head_t deserialize_do_loop_head() {
        do_loop_head_t x;
        {
            bool present=self().read_bool();
            if (present) {
                x.m_v = down_cast<expr_t>(deserialize_expr());
            } else {
                x.m_v = nullptr;
            }
        }
        {
            bool present=self().read_bool();
            if (present) {
                x.m_start = down_cast<expr_t>(deserialize_expr());
            } else {
                x.m_start = nullptr;
            }
        }
        {
            bool present=self().read_bool();
            if (present) {
                x.m_end = down_cast<expr_t>(deserialize_expr());
            } else {
                x.m_end = nullptr;
            }
        }
        {
            bool present=self().read_bool();
            if (present) {
                x.m_increment = down_cast<expr_t>(deserialize_expr());
            } else {
                x.m_increment = nullptr;
            }
        }
        return x;
    }
    asr_t* deserialize_CaseStmt() {
        size_t n_test; // Sequence
        size_t n_body; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        n_test = self().read_int64();
        Vec<expr_t*> v_test;
        v_test.reserve(al, n_test);
        for (size_t i=0; i<n_test; i++) {
            v_test.push_back(al, ASR::down_cast<ASR::expr_t>(self().deserialize_expr()));
        }
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        bool m_fall_through = self().read_bool();
        return ASR::make_CaseStmt_t(al, loc, v_test.p, v_test.n, v_body.p, v_body.n, m_fall_through);
    }
    asr_t* deserialize_CaseStmt_Range() {
        size_t n_body; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::expr_t *m_start;
        if (self().read_bool()) {
        m_start = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_start = nullptr;
        }
        ASR::expr_t *m_end;
        if (self().read_bool()) {
        m_end = ASR::down_cast<ASR::expr_t>(self().deserialize_expr());
        } else {
        m_end = nullptr;
        }
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        return ASR::make_CaseStmt_Range_t(al, loc, m_start, m_end, v_body.p, v_body.n);
    }
    asr_t* deserialize_case_stmt() {
        uint8_t t = self().read_int8();
        ASR::case_stmtType ty = static_cast<ASR::case_stmtType>(t);
        switch (ty) {
            case (ASR::case_stmtType::CaseStmt) : return self().deserialize_CaseStmt();
            case (ASR::case_stmtType::CaseStmt_Range) : return self().deserialize_CaseStmt_Range();
            default : throw LCompilersException("Unknown type in deserialize_case_stmt()");
        }
        throw LCompilersException("Switch statement above was not exhaustive.");
    }
    asr_t* deserialize_TypeStmtName() {
        size_t n_body; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::symbol_t *m_sym;
        m_sym = self().read_symbol();
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        return ASR::make_TypeStmtName_t(al, loc, m_sym, v_body.p, v_body.n);
    }
    asr_t* deserialize_ClassStmt() {
        size_t n_body; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::symbol_t *m_sym;
        m_sym = self().read_symbol();
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        return ASR::make_ClassStmt_t(al, loc, m_sym, v_body.p, v_body.n);
    }
    asr_t* deserialize_TypeStmtType() {
        size_t n_body; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        ASR::ttype_t *m_type;
        m_type = ASR::down_cast<ASR::ttype_t>(self().deserialize_ttype());
        n_body = self().read_int64();
        Vec<stmt_t*> v_body;
        v_body.reserve(al, n_body);
        for (size_t i=0; i<n_body; i++) {
            v_body.push_back(al, ASR::down_cast<ASR::stmt_t>(self().deserialize_stmt()));
        }
        return ASR::make_TypeStmtType_t(al, loc, m_type, v_body.p, v_body.n);
    }
    asr_t* deserialize_type_stmt() {
        uint8_t t = self().read_int8();
        ASR::type_stmtType ty = static_cast<ASR::type_stmtType>(t);
        switch (ty) {
            case (ASR::type_stmtType::TypeStmtName) : return self().deserialize_TypeStmtName();
            case (ASR::type_stmtType::ClassStmt) : return self().deserialize_ClassStmt();
            case (ASR::type_stmtType::TypeStmtType) : return self().deserialize_TypeStmtType();
            default : throw LCompilersException("Unknown type in deserialize_type_stmt()");
        }
        throw LCompilersException("Switch statement above was not exhaustive.");
    }
    enumtypeType deserialize_enumtype() {
        uint8_t t = self().read_int8();
        enumtypeType ty = static_cast<enumtypeType>(t);
        return ty;
    }
    asr_t* deserialize_Require() {
        size_t n_args; // Sequence
        Location loc;
        loc.first = self().read_int64() + offset;
        loc.last = self().read_int64() + offset;
        char *m_name;
        m_name = self().read_cstring();
        n_args = self().read_int64();
        Vec<char*> v_args;
        v_args.reserve(al, n_args);
        for (size_t i=0; i<n_args; i++) {
            v_args.push_back(al, self().read_cstring());
        }
        return ASR::make_Require_t(al, loc, m_name, v_args.p, v_args.n);
    }
    asr_t* deserialize_require_instantiation() {
        uint8_t t = self().read_int8();
        ASR::require_instantiationType ty = static_cast<ASR::require_instantiationType>(t);
        switch (ty) {
            case (ASR::require_instantiationType::Require) : return self().deserialize_Require();
            default : throw LCompilersException("Unknown type in deserialize_require_instantiation()");
        }
        throw LCompilersException("Switch statement above was not exhaustive.");
    }
    array_physical_typeType deserialize_array_physical_type() {
        uint8_t t = self().read_int8();
        array_physical_typeType ty = static_cast<array_physical_typeType>(t);
        return ty;
    }
    string_physical_typeType deserialize_string_physical_type() {
        uint8_t t = self().read_int8();
        string_physical_typeType ty = static_cast<string_physical_typeType>(t);
        return ty;
    }
    binopType deserialize_binop() {
        uint8_t t = self().read_int8();
        binopType ty = static_cast<binopType>(t);
        return ty;
    }
    reduction_opType deserialize_reduction_op() {
        uint8_t t = self().read_int8();
        reduction_opType ty = static_cast<reduction_opType>(t);
        return ty;
    }
    logicalbinopType deserialize_logicalbinop() {
        uint8_t t = self().read_int8();
        logicalbinopType ty = static_cast<logicalbinopType>(t);
        return ty;
    }
    cmpopType deserialize_cmpop() {
        uint8_t t = self().read_int8();
        cmpopType ty = static_cast<cmpopType>(t);
        return ty;
    }
    integerbozType deserialize_integerboz() {
        uint8_t t = self().read_int8();
        integerbozType ty = static_cast<integerbozType>(t);
        return ty;
    }
    arrayboundType deserialize_arraybound() {
        uint8_t t = self().read_int8();
        arrayboundType ty = static_cast<arrayboundType>(t);
        return ty;
    }
    arraystorageType deserialize_arraystorage() {
        uint8_t t = self().read_int8();
        arraystorageType ty = static_cast<arraystorageType>(t);
        return ty;
    }
    string_format_kindType deserialize_string_format_kind() {
        uint8_t t = self().read_int8();
        string_format_kindType ty = static_cast<string_format_kindType>(t);
        return ty;
    }
};


}
