/* Generated by re2c 3.1 on Wed Jan 14 05:28:50 2026 */
#line 1 "parser/tokenizer.re"
#include <limits>

#include <lfortran/parser/parser_exception.h>
#include <lfortran/parser/tokenizer.h>
#include <lfortran/parser/parser.tab.hh>
#include <libasr/bigint.h>

using LCompilers::diag::Level;
using LCompilers::diag::Stage;
using LCompilers::diag::Label;
using LCompilers::diag::Diagnostic;

namespace LCompilers::LFortran {

void Tokenizer::set_string(const std::string &str)
{
    // The input string must be NULL terminated, otherwise the tokenizer will
    // not detect the end of string. After C++11, the std::string is guaranteed
    // to end with \0, but we check this here just in case.
    LCOMPILERS_ASSERT(str[str.size()] == '\0');
    cur = (unsigned char *)(&str[0]);
    string_start = cur;
    cur_line = cur;
    line_num = 1;
}

template<int base>
bool adddgt(uint64_t &u, uint64_t d)
{
    if (u > (std::numeric_limits<uint64_t>::max() - d) / base) {
        return false;
    }
    u = u * base + d;
    return true;
}

bool lex_dec(const unsigned char *s, const unsigned char *e, uint64_t &u)
{
    for (u = 0; s < e; ++s) {
        if (!adddgt<10>(u, *s - 0x30u)) {
            return false;
        }
    }
    return true;
}

// Tokenizes integer of the kind 1234_ikind into `u` and `suffix`
// s ... the start of the integer
// e ... the character after the end
bool lex_int(const unsigned char *s, const unsigned char *e, uint64_t &u,
    Str &suffix)
{
    for (u = 0; s < e; ++s) {
        if (*s == '_') {
            s++;
            suffix.p = (char*) s;
            suffix.n = e-s;
            return true;
        } else if (!adddgt<10>(u, *s - 0x30u)) {
            return false;
        }
    }
    suffix.p = nullptr;
    suffix.n = 0;
    return true;
}

void lex_int_large(Allocator &al, const unsigned char *s,
    const unsigned char *e, BigInt::BigInt &u, Str &suffix)
{
    uint64_t ui;
    if (lex_int(s, e, ui, suffix)) {
        if (ui <= BigInt::MAX_SMALL_INT) {
            u.from_smallint(ui);
            return;
        }
    }
    const unsigned char *start = s;
    for (; s < e; ++s) {
        if (*s == '_') {
            s++;
            suffix.p = (char*) s;
            suffix.n = e-s;

            Str num;
            num.p = (char*)start;
            num.n = s-start-1;
            u.from_largeint(al, num);
            return;
        }
    }
    suffix.p = nullptr;
    suffix.n = 0;
    Str num;
    num.p = (char*)start;
    num.n = e-start;
    u.from_largeint(al, num);
}

uint64_t parse_int(const unsigned char *s)
{
    while (*s == ' ') s++;
    uint64_t u;
    for (u = 0; ; ++s) {
        if (*s >= '0' && *s <= '9') {
            if (!adddgt<10>(u, *s - 0x30u)) {
                return false;
            }
        } else {
            return u;
        }
    }
}

#define KW(x) token(yylval.string); RET(KW_##x);
#define RET(x) token_loc(loc); last_token=yytokentype::x; return yytokentype::x;
#define WARN_REL(x) add_rel_warning(diagnostics, fixed_form, yytokentype::TK_##x);

#define TK_TRIVIA(X) {                              \
    line_num++; cur_line=cur;                       \
    token(yylval.string);                           \
    token_loc(loc);                                 \
    if (last_token == yytokentype::TK_NEWLINE) {    \
        return yytokentype::X;                      \
    } else {                                        \
        last_token=yytokentype::TK_NEWLINE;         \
        return yytokentype::TK_EOLCOMMENT;          \
    }                                               \
}

void Tokenizer::add_rel_warning(diag::Diagnostics &diagnostics, bool fixed_form, int rel_token) const {
    if (!fixed_form) {
        static const std::map<int, std::pair<std::string, std::string>> m = {
            {yytokentype::TK_EQ, {"==", ".eq."}},
            {yytokentype::TK_NE, {"/=", ".ne."}},
            {yytokentype::TK_LT, {"<",  ".lt."}},
            {yytokentype::TK_GT, {">",  ".gt."}},
            {yytokentype::TK_LE, {"<=", ".le."}},
            {yytokentype::TK_GE, {">=", ".ge."}},
        };
        const std::string rel_new = m.at(rel_token).first;
        const std::string rel_old = m.at(rel_token).second;
        Location loc;
        token_loc(loc);
        diagnostics.tokenizer_style_label(
            "Use '" + rel_new + "' instead of '" + rel_old + "'",
            {loc},
            "help: write this as '" + rel_new + "'");
    }
}

int Tokenizer::lex(Allocator &al, YYSTYPE &yylval, Location &loc, diag::Diagnostics &diagnostics, bool continue_compilation)
{
    if (enddo_state == 1) {
        enddo_state = 2;
        KW(END_DO)
    } else if (enddo_state == 2) {
        enddo_insert_count--;
        if (enddo_insert_count > 0) {
            enddo_state = 1;
        } else {
            enddo_state = 0;
            token_loc(loc); line_num++; cur_line=cur;
            last_token = yytokentype::TK_NEWLINE;
        }
        return yytokentype::TK_NEWLINE;
    }
    for (;;) {
        tok = cur;

        /*
        Re2c has excellent documentation at:

        https://re2c.org/manual/manual_c.html

        The first paragraph there explains the basics:

        * If multiple rules match, the longest match takes precedence
        * If multiple rules match the same string, the earlier rule takes
          precedence
        * Default rule `*` should always be defined, it has the lowest priority
          regardless of its place and matches any code unit
        * We use the "Sentinel character" method for end of input:
            * The end of the input text is denoted with a null character \x00
            * Thus the null character cannot be part of the input otherwise
            * There is one rule to match \x00 to end the parser
            * No other rule is allowed to match \x00, otherwise the re2c block
              would parse past the end of the string and segfaults
            * A special case of the previous point are negated character
              ranges, such as [^"\x00], where one must include \x00 in it to
              ensure this rule does not match \x00 (all other rules simply do
              not mention \x00)
            * See the "Handling the end of input" section in the re2c
              documentation for more info

        The re2c block interacts with the rest of the code via just one pointer
        variable `cur`. On entering the re2c block, the `cur` variable must
        point to the first character of the token to be tokenized by the block.
        The re2c block below then executes on its own until a rule is matched:
        the action in {} is then executed. In that action `cur` points to the
        first character of the next token.

        Before the re2c block we save the current `cur` into `tok`, so that we
        can use `tok` and `cur` in the action in {} to extract the token that
        corresponds to the rule that got matched:

        * `tok` points to the first character of the token
        * `cur-1` points to the last character of the token
        * `cur` points to the first character of the next token
        * `cur-tok` is the length of the token

        In the action, we do one of:

        * call `continue` which executes another cycle in the for loop (which
          will parse the next token); we use this to skip a token
        * call `return` which returns from this function; we return a token
        * throw an exception (terminates the tokenizer)

        In the first two cases, `cur` points to first character of the next
        token, which becomes `tok` at the next iteration of the loop (either
        right away after `continue` or after the `lex` function is called again
        after `return`).

        See the manual for more details.
        */


        // These two variables are needed by the re2c block below internally,
        // initialization is not needed. One can think of them as local
        // variables of the re2c block.
        unsigned char *mar, *ctxmar;
        
#line 236 "parser/tokenizer.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		/* table 1 .. 8: 0 */
		  0,   2,   2,   2,   2,   2,   2,   2, 
		  2,   3,   3,   3,   2,   3,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  3,   2,   2,   2,   2,   2,   2,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		242, 242, 210, 210, 210, 210, 210, 210, 
		146, 146,   2,   2,   2,   2,   2,   2, 
		  2, 150, 150, 150, 150, 150, 150,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,   2,   2,   2,   2,  26, 
		  2, 150, 150, 150, 150, 150, 150,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		/* table 9 .. 13: 256 */
		  0, 192, 192, 192, 192, 192, 192, 192, 
		192, 200, 128, 200, 192, 200, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		200, 192,  64, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		240, 240, 240, 240, 240, 240, 240, 240, 
		240, 240, 192, 192, 192, 192, 192, 192, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 192, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
	};
	yych = *cur;
	if (yybm[256+yych] & 8) {
		goto yy4;
	}
	switch (yych) {
		case 0x00: goto yy1;
		case '\t':
		case '\n': goto yy5;
		case ' ':
		case '!': goto yy6;
		case '"': goto yy7;
		case '#': goto yy8;
		case '%': goto yy9;
		case '&': goto yy10;
		case '\'': goto yy11;
		case '(': goto yy12;
		case ')': goto yy13;
		case '*': goto yy14;
		case '+': goto yy15;
		case ',': goto yy16;
		case '-': goto yy17;
		case '.': goto yy18;
		case '/': goto yy19;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy20;
		case ':': goto yy22;
		case ';': goto yy23;
		case '<': goto yy24;
		case '=': goto yy25;
		case '>': goto yy27;
		case 'A':
		case 'a': goto yy28;
		case 'B':
		case 'b': goto yy30;
		case 'C':
		case 'c': goto yy31;
		case 'D':
		case 'd': goto yy32;
		case 'E':
		case 'e': goto yy33;
		case 'F':
		case 'f': goto yy34;
		case 'G':
		case 'g': goto yy35;
		case 'H':
		case 'J':
		case 'X':
		case 'Y':
		case 'h':
		case 'j':
		case 'x':
		case 'y': goto yy36;
		case 'I':
		case 'i': goto yy38;
		case 'K':
		case 'k': goto yy39;
		case 'L':
		case 'l': goto yy40;
		case 'M':
		case 'm': goto yy41;
		case 'N':
		case 'n': goto yy42;
		case 'O':
		case 'o': goto yy43;
		case 'P':
		case 'p': goto yy44;
		case 'Q':
		case 'q': goto yy45;
		case 'R':
		case 'r': goto yy46;
		case 'S':
		case 's': goto yy47;
		case 'T':
		case 't': goto yy48;
		case 'U':
		case 'u': goto yy49;
		case 'V':
		case 'v': goto yy50;
		case 'W':
		case 'w': goto yy51;
		case 'Z':
		case 'z': goto yy52;
		case '[': goto yy53;
		case ']': goto yy55;
		case '_': goto yy56;
		case '{': goto yy57;
		case '|': goto yy58;
		case '}': goto yy59;
		default: goto yy2;
	}
yy1:
	++cur;
#line 275 "parser/tokenizer.re"
	{ RET(END_OF_FILE); }
#line 410 "parser/tokenizer.cpp"
yy2:
	++cur;
yy3:
#line 261 "parser/tokenizer.re"
	{ token_loc(loc);
                std::string t = token();
                diagnostics.add(diag::Diagnostic(
                        "Token '" + t + "' is not recognized",
                        diag::Level::Error, diag::Stage::Tokenizer, {
                        diag::Label("token not recognized", {loc})
                    }));

                if(!continue_compilation) {
                    throw parser_local::TokenizerAbort();
                } else {
                    continue;
                }
            }
#line 429 "parser/tokenizer.cpp"
yy4:
	yych = *++cur;
	if (yybm[256+yych] & 8) {
		goto yy4;
	}
#line 276 "parser/tokenizer.re"
	{ continue; }
#line 437 "parser/tokenizer.cpp"
yy5:
	++cur;
#line 539 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    enddo_newline_process = false;
                    enddo_state = 1;
                    return yytokentype::TK_NEWLINE;
                } else {
                    enddo_newline_process = false;
                    enddo_insert_count = 0;
                    token_loc(loc); line_num++; cur_line=cur;
                    last_token = yytokentype::TK_NEWLINE;
                    return yytokentype::TK_NEWLINE;
                }
            }
#line 454 "parser/tokenizer.cpp"
yy6:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '$') {
		if (yych <= 0x00) goto yy3;
		if (yych <= '#') goto yy61;
		goto yy64;
	} else {
		if (yych == 'L') goto yy65;
		goto yy61;
	}
yy7:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy67;
yy8:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy72;
yy9:
	++cur;
#line 574 "parser/tokenizer.re"
	{ RET(TK_PERCENT) }
#line 480 "parser/tokenizer.cpp"
yy10:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy3;
		if (yych <= '\v') goto yy79;
		goto yy3;
	} else {
		if (yych <= '\r') goto yy79;
		if (yych <= 0x1F) goto yy3;
		if (yych <= '!') goto yy79;
		goto yy3;
	}
yy11:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy84;
yy12:
	yych = *++cur;
	if (yych == '/') {
		ctxmar = cur;
		goto yy86;
	}
#line 554 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 507 "parser/tokenizer.cpp"
yy13:
	++cur;
#line 562 "parser/tokenizer.re"
	{ RET(TK_RPAREN) }
#line 512 "parser/tokenizer.cpp"
yy14:
	yych = *++cur;
	if (yych == '*') goto yy87;
#line 576 "parser/tokenizer.re"
	{ RET(TK_STAR) }
#line 518 "parser/tokenizer.cpp"
yy15:
	++cur;
#line 568 "parser/tokenizer.re"
	{ RET(TK_PLUS) }
#line 523 "parser/tokenizer.cpp"
yy16:
	++cur;
#line 575 "parser/tokenizer.re"
	{ RET(TK_COMMA) }
#line 528 "parser/tokenizer.cpp"
yy17:
	++cur;
#line 569 "parser/tokenizer.re"
	{ RET(TK_MINUS) }
#line 533 "parser/tokenizer.cpp"
yy18:
	yyaccept = 0;
	yych = *(mar = ++cur);
	switch (yych) {
		case '.': goto yy88;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy89;
		case 'A':
		case 'a': goto yy92;
		case 'B':
		case 'C':
		case 'D':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'Y':
		case 'Z':
		case 'b':
		case 'c':
		case 'd':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'y':
		case 'z': goto yy93;
		case 'E':
		case 'e': goto yy95;
		case 'F':
		case 'f': goto yy96;
		case 'G':
		case 'g': goto yy97;
		case 'L':
		case 'l': goto yy98;
		case 'N':
		case 'n': goto yy99;
		case 'O':
		case 'o': goto yy100;
		case 'T':
		case 't': goto yy101;
		case 'X':
		case 'x': goto yy102;
		default: goto yy3;
	}
yy19:
	yych = *++cur;
	if (yych <= '.') {
		if (yych == ')') goto yy103;
	} else {
		if (yych <= '/') goto yy104;
		if (yych == '=') goto yy105;
	}
#line 573 "parser/tokenizer.re"
	{ RET(TK_SLASH) }
#line 613 "parser/tokenizer.cpp"
yy20:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yybm[256+yych] & 16) {
		goto yy20;
	}
	if (yych <= ' ') {
		if (yych <= '\v') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy106;
			}
			if (yych >= '\v') {
				ctxmar = cur;
				goto yy106;
			}
		} else {
			if (yych == '\r') {
				ctxmar = cur;
				goto yy106;
			}
			if (yych >= ' ') {
				ctxmar = cur;
				goto yy106;
			}
		}
	} else {
		if (yych <= 'E') {
			if (yych == '.') {
				ctxmar = cur;
				goto yy107;
			}
			if (yych >= 'D') goto yy108;
		} else {
			if (yych <= '_') {
				if (yych >= '_') goto yy109;
			} else {
				if (yych <= 'c') goto yy21;
				if (yych <= 'e') goto yy108;
			}
		}
	}
yy21:
#line 665 "parser/tokenizer.re"
	{
                lex_int_large(al, tok, cur,
                    yylval.int_suffix.int_n,
                    yylval.int_suffix.int_kind);
                RET(TK_INTEGER)
            }
#line 664 "parser/tokenizer.cpp"
yy22:
	yych = *++cur;
	if (yych == ':') goto yy110;
#line 571 "parser/tokenizer.re"
	{ RET(TK_COLON) }
#line 670 "parser/tokenizer.cpp"
yy23:
	++cur;
#line 572 "parser/tokenizer.re"
	{ RET(TK_SEMICOLON) }
#line 675 "parser/tokenizer.cpp"
yy24:
	yych = *++cur;
	if (yych == '=') goto yy111;
#line 593 "parser/tokenizer.re"
	{ RET(TK_LT) }
#line 681 "parser/tokenizer.cpp"
yy25:
	yych = *++cur;
	if (yych <= '<') goto yy26;
	if (yych <= '=') goto yy112;
	if (yych <= '>') goto yy113;
yy26:
#line 570 "parser/tokenizer.re"
	{ RET(TK_EQUAL) }
#line 690 "parser/tokenizer.cpp"
yy27:
	yych = *++cur;
	if (yych == '=') goto yy114;
#line 599 "parser/tokenizer.re"
	{ RET(TK_GT) }
#line 696 "parser/tokenizer.cpp"
yy28:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'K') {
			if (yych == 'B') goto yy115;
			goto yy37;
		} else {
			if (yych <= 'L') goto yy116;
			if (yych <= 'R') goto yy37;
			goto yy117;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'b') goto yy115;
			goto yy37;
		} else {
			if (yych <= 'l') goto yy116;
			if (yych == 's') goto yy117;
			goto yy37;
		}
	}
yy29:
#line 766 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_NAME) }
#line 721 "parser/tokenizer.cpp"
yy30:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'I') {
		if (yych <= '\'') {
			if (yych == '"') goto yy119;
			if (yych <= '&') goto yy37;
			goto yy120;
		} else {
			if (yych == 'A') goto yy121;
			if (yych <= 'H') goto yy37;
			goto yy122;
		}
	} else {
		if (yych <= 'a') {
			if (yych == 'L') goto yy123;
			if (yych <= '`') goto yy37;
			goto yy121;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy37;
				goto yy122;
			} else {
				if (yych == 'l') goto yy123;
				goto yy37;
			}
		}
	}
yy31:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy124;
		case 'H':
		case 'h': goto yy125;
		case 'L':
		case 'l': goto yy126;
		case 'O':
		case 'o': goto yy127;
		case 'R':
		case 'r': goto yy128;
		case 'Y':
		case 'y': goto yy129;
		default: goto yy37;
	}
yy32:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych <= 'E') {
			if (yych == 'A') goto yy130;
			if (yych <= 'D') goto yy37;
			goto yy131;
		} else {
			if (yych == 'I') goto yy132;
			if (yych <= 'N') goto yy37;
			goto yy133;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'a') goto yy130;
			if (yych <= 'd') goto yy37;
			goto yy131;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy37;
				goto yy132;
			} else {
				if (yych == 'o') goto yy133;
				goto yy37;
			}
		}
	}
yy33:
	yych = *++cur;
	switch (yych) {
		case 'L':
		case 'l': goto yy135;
		case 'N':
		case 'n': goto yy136;
		case 'Q':
		case 'q': goto yy137;
		case 'R':
		case 'r': goto yy138;
		case 'V':
		case 'v': goto yy139;
		case 'X':
		case 'x': goto yy140;
		default: goto yy37;
	}
yy34:
	yych = *++cur;
	switch (yych) {
		case 'I':
		case 'i': goto yy141;
		case 'L':
		case 'l': goto yy142;
		case 'O':
		case 'o': goto yy143;
		case 'U':
		case 'u': goto yy144;
		default: goto yy37;
	}
yy35:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy145;
		if (yych <= 'N') goto yy37;
		goto yy146;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy145;
		} else {
			if (yych == 'o') goto yy146;
			goto yy37;
		}
	}
yy36:
	yych = *++cur;
yy37:
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
	goto yy29;
yy38:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'L') {
			if (yych == 'F') goto yy148;
			goto yy37;
		} else {
			if (yych <= 'M') goto yy149;
			if (yych <= 'N') goto yy150;
			if (yych <= 'R') goto yy37;
			goto yy152;
		}
	} else {
		if (yych <= 'm') {
			if (yych == 'f') goto yy148;
			if (yych <= 'l') goto yy37;
			goto yy149;
		} else {
			if (yych <= 'n') goto yy150;
			if (yych == 's') goto yy152;
			goto yy37;
		}
	}
yy39:
	yych = *++cur;
	if (yych == 'I') goto yy153;
	if (yych == 'i') goto yy153;
	goto yy37;
yy40:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy154;
		if (yych <= 'N') goto yy37;
		goto yy155;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy154;
		} else {
			if (yych == 'o') goto yy155;
			goto yy37;
		}
	}
yy41:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy156;
		if (yych <= 'N') goto yy37;
		goto yy157;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy156;
		} else {
			if (yych == 'o') goto yy157;
			goto yy37;
		}
	}
yy42:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'E') {
			if (yych == 'A') goto yy158;
			if (yych <= 'D') goto yy37;
			goto yy159;
		} else {
			if (yych == 'O') goto yy160;
			if (yych <= 'T') goto yy37;
			goto yy161;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'a') goto yy158;
			if (yych <= 'd') goto yy37;
			goto yy159;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy37;
				goto yy160;
			} else {
				if (yych == 'u') goto yy161;
				goto yy37;
			}
		}
	}
yy43:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'P') {
		if (yych <= '\'') {
			if (yych == '"') goto yy162;
			if (yych <= '&') goto yy37;
			goto yy163;
		} else {
			if (yych == 'N') goto yy164;
			if (yych <= 'O') goto yy37;
			goto yy165;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'U') goto yy166;
			if (yych <= 'm') goto yy37;
			goto yy164;
		} else {
			if (yych <= 'p') {
				if (yych <= 'o') goto yy37;
				goto yy165;
			} else {
				if (yych == 'u') goto yy166;
				goto yy37;
			}
		}
	}
yy44:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'O') {
			if (yych == 'A') goto yy167;
			if (yych <= 'N') goto yy37;
			goto yy168;
		} else {
			if (yych == 'R') goto yy169;
			if (yych <= 'T') goto yy37;
			goto yy170;
		}
	} else {
		if (yych <= 'o') {
			if (yych == 'a') goto yy167;
			if (yych <= 'n') goto yy37;
			goto yy168;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy37;
				goto yy169;
			} else {
				if (yych == 'u') goto yy170;
				goto yy37;
			}
		}
	}
yy45:
	yych = *++cur;
	if (yych == 'U') goto yy171;
	if (yych == 'u') goto yy171;
	goto yy37;
yy46:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy172;
		if (yych <= 'D') goto yy37;
		goto yy173;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy172;
		} else {
			if (yych == 'e') goto yy173;
			goto yy37;
		}
	}
yy47:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy174;
		case 'E':
		case 'e': goto yy175;
		case 'H':
		case 'h': goto yy176;
		case 'O':
		case 'o': goto yy177;
		case 'T':
		case 't': goto yy178;
		case 'U':
		case 'u': goto yy179;
		case 'Y':
		case 'y': goto yy180;
		default: goto yy37;
	}
yy48:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy181;
		case 'E':
		case 'e': goto yy182;
		case 'H':
		case 'h': goto yy183;
		case 'O':
		case 'o': goto yy184;
		case 'Y':
		case 'y': goto yy185;
		default: goto yy37;
	}
yy49:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'N') goto yy186;
		if (yych <= 'R') goto yy37;
		goto yy187;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy186;
		} else {
			if (yych == 's') goto yy187;
			goto yy37;
		}
	}
yy50:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy188;
		if (yych <= 'N') goto yy37;
		goto yy189;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy188;
		} else {
			if (yych == 'o') goto yy189;
			goto yy37;
		}
	}
yy51:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych <= 'G') {
			if (yych == 'A') goto yy190;
			goto yy37;
		} else {
			if (yych <= 'H') goto yy191;
			if (yych <= 'Q') goto yy37;
			goto yy192;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'a') goto yy190;
			goto yy37;
		} else {
			if (yych <= 'h') goto yy191;
			if (yych == 'r') goto yy192;
			goto yy37;
		}
	}
yy52:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy193;
	if (yych == '\'') goto yy194;
	goto yy37;
yy53:
	++cur;
yy54:
#line 563 "parser/tokenizer.re"
	{ RET(TK_LBRACKET) }
#line 1103 "parser/tokenizer.cpp"
yy55:
	++cur;
#line 564 "parser/tokenizer.re"
	{ RET(TK_RBRACKET) }
#line 1108 "parser/tokenizer.cpp"
yy56:
	yych = *++cur;
	if (yych == 'L') goto yy195;
	if (yych == 'l') goto yy195;
	goto yy37;
yy57:
	++cur;
#line 565 "parser/tokenizer.re"
	{ RET(TK_LBRACE) }
#line 1118 "parser/tokenizer.cpp"
yy58:
	++cur;
#line 577 "parser/tokenizer.re"
	{ RET(TK_VBAR) }
#line 1123 "parser/tokenizer.cpp"
yy59:
	++cur;
#line 566 "parser/tokenizer.re"
	{ RET(TK_RBRACE) }
#line 1128 "parser/tokenizer.cpp"
yy60:
	yych = *++cur;
yy61:
	if (yybm[256+yych] & 64) {
		goto yy60;
	}
	if (yych >= 0x01) goto yy63;
yy62:
	cur = mar;
	if (yyaccept <= 7) {
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy3;
				} else {
					goto yy21;
				}
			} else {
				if (yyaccept == 2) {
					goto yy29;
				} else {
					goto yy68;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy81;
				} else {
					goto yy85;
				}
			} else {
				if (yyaccept == 6) {
					goto yy54;
				} else {
					goto yy91;
				}
			}
		}
	} else {
		if (yyaccept <= 11) {
			if (yyaccept <= 9) {
				if (yyaccept == 8) {
					goto yy134;
				} else {
					goto yy151;
				}
			} else {
				if (yyaccept == 10) {
					goto yy261;
				} else {
					goto yy691;
				}
			}
		} else {
			if (yyaccept <= 13) {
				if (yyaccept == 12) {
					goto yy828;
				} else {
					goto yy986;
				}
			} else {
				goto yy1059;
			}
		}
	}
yy63:
	++cur;
#line 697 "parser/tokenizer.re"
	{
                line_num++; cur_line=cur;
                token(yylval.string);
                yylval.string.n--;
                token_loc(loc);
                if (last_token == yytokentype::TK_NEWLINE) {
                    return yytokentype::TK_COMMENT;
                } else {
                    last_token=yytokentype::TK_NEWLINE;
                    return yytokentype::TK_EOLCOMMENT;
                }
            }
#line 1210 "parser/tokenizer.cpp"
yy64:
	yych = *++cur;
	if (yych == 'O') goto yy196;
	if (yych == 'o') goto yy196;
	goto yy61;
yy65:
	yych = *++cur;
	if (yych == 'F') goto yy197;
	goto yy61;
yy66:
	yych = *++cur;
yy67:
	if (yybm[256+yych] & 128) {
		goto yy66;
	}
	if (yych <= 0x00) goto yy62;
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy66;
yy68:
#line 762 "parser/tokenizer.re"
	{ lex_string(al, yylval.str_prefix, '"'); RET(TK_STRING) }
#line 1233 "parser/tokenizer.cpp"
yy69:
	yych = *++cur;
yy70:
	if (yych <= 0x00) goto yy62;
	if (yych == '\n') goto yy73;
	goto yy69;
yy71:
	yych = *++cur;
yy72:
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy62;
			if (yych <= 0x08) goto yy69;
			if (yych <= '\t') goto yy71;
		} else {
			if (yych == '\f') goto yy69;
			if (yych <= '\r') goto yy71;
			goto yy69;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= ' ') goto yy71;
			if (yych <= 'c') goto yy69;
			if (yych <= 'd') goto yy74;
			goto yy75;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy69;
				goto yy76;
			} else {
				if (yych == 'l') goto yy77;
				goto yy69;
			}
		}
	}
yy73:
	++cur;
#line 754 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "Unsupported macro", {loc},
                    "Ignored");
                line_num++; cur_line=cur; continue;
            }
#line 1279 "parser/tokenizer.cpp"
yy74:
	yych = *++cur;
	if (yych == 'e') goto yy198;
	goto yy70;
yy75:
	yych = *++cur;
	if (yych == 'l') goto yy199;
	if (yych == 'n') goto yy200;
	goto yy70;
yy76:
	yych = *++cur;
	if (yych == 'f') goto yy201;
	if (yych == 'n') goto yy202;
	goto yy70;
yy77:
	yych = *++cur;
	if (yych == 'i') goto yy203;
	goto yy70;
yy78:
	yych = *++cur;
yy79:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy62;
			goto yy78;
		} else {
			if (yych <= '\n') goto yy80;
			if (yych <= '\v') goto yy78;
			goto yy62;
		}
	} else {
		if (yych <= 0x1F) {
			if (yych <= '\r') goto yy78;
			goto yy62;
		} else {
			if (yych <= ' ') goto yy78;
			if (yych <= '!') goto yy82;
			goto yy62;
		}
	}
yy80:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 1) {
		goto yy80;
	}
	if (yych <= 0x1F) goto yy81;
	if (yych <= '!') goto yy82;
	if (yych == '&') goto yy204;
yy81:
#line 679 "parser/tokenizer.re"
	{
                line_num++; cur_line=cur; continue;
            }
#line 1334 "parser/tokenizer.cpp"
yy82:
	yych = *++cur;
	if (yych <= 0x00) goto yy62;
	if (yych == '\n') goto yy80;
	goto yy82;
yy83:
	yych = *++cur;
yy84:
	if (yybm[0+yych] & 2) {
		goto yy83;
	}
	if (yych <= 0x00) goto yy62;
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy83;
yy85:
#line 763 "parser/tokenizer.re"
	{ lex_string(al, yylval.str_prefix, '\''); RET(TK_STRING) }
#line 1353 "parser/tokenizer.cpp"
yy86:
	yyaccept = 6;
	yych = *(mar = ++cur);
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy205;
			goto yy54;
		} else {
			if (yych == '\f') goto yy54;
			if (yych <= '\r') goto yy205;
			goto yy54;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ' ') goto yy205;
			if (yych == ')') goto yy206;
			goto yy54;
		} else {
			if (yych <= '/') goto yy207;
			if (yych == '=') goto yy208;
			goto yy54;
		}
	}
yy87:
	++cur;
#line 582 "parser/tokenizer.re"
	{ RET(TK_POW) }
#line 1381 "parser/tokenizer.cpp"
yy88:
	++cur;
#line 580 "parser/tokenizer.re"
	{ RET(TK_DBL_DOT) }
#line 1386 "parser/tokenizer.cpp"
yy89:
	yyaccept = 7;
	yych = *(mar = ++cur);
yy90:
	if (yych <= 'E') {
		if (yych <= '/') goto yy91;
		if (yych <= '9') goto yy89;
		if (yych >= 'D') goto yy108;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto yy209;
		} else {
			if (yych <= 'c') goto yy91;
			if (yych <= 'e') goto yy108;
		}
	}
yy91:
#line 632 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_REAL) }
#line 1406 "parser/tokenizer.cpp"
yy92:
	yych = *++cur;
	if (yych == 'N') goto yy211;
	if (yych == 'n') goto yy211;
	goto yy94;
yy93:
	yych = *++cur;
yy94:
	if (yybm[0+yych] & 4) {
		goto yy93;
	}
	if (yych == '.') goto yy210;
	goto yy62;
yy95:
	yych = *++cur;
	if (yych == 'Q') goto yy212;
	if (yych == 'q') goto yy212;
	goto yy94;
yy96:
	yych = *++cur;
	if (yych == 'A') goto yy213;
	if (yych == 'a') goto yy213;
	goto yy94;
yy97:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy214;
		if (yych <= 'S') goto yy94;
		goto yy215;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy94;
			goto yy214;
		} else {
			if (yych == 't') goto yy215;
			goto yy94;
		}
	}
yy98:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy216;
		if (yych <= 'S') goto yy94;
		goto yy217;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy94;
			goto yy216;
		} else {
			if (yych == 't') goto yy217;
			goto yy94;
		}
	}
yy99:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy218;
		if (yych <= 'N') goto yy94;
		goto yy219;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy94;
			goto yy218;
		} else {
			if (yych == 'o') goto yy219;
			goto yy94;
		}
	}
yy100:
	yych = *++cur;
	if (yych == 'R') goto yy220;
	if (yych == 'r') goto yy220;
	goto yy94;
yy101:
	yych = *++cur;
	if (yych == 'R') goto yy221;
	if (yych == 'r') goto yy221;
	goto yy94;
yy102:
	yych = *++cur;
	if (yych == 'O') goto yy222;
	if (yych == 'o') goto yy222;
	goto yy94;
yy103:
	++cur;
#line 567 "parser/tokenizer.re"
	{ RET(TK_RBRACKET_OLD) }
#line 1494 "parser/tokenizer.cpp"
yy104:
	++cur;
#line 583 "parser/tokenizer.re"
	{ RET(TK_CONCAT) }
#line 1499 "parser/tokenizer.cpp"
yy105:
	++cur;
#line 590 "parser/tokenizer.re"
	{ RET(TK_NE) }
#line 1504 "parser/tokenizer.cpp"
yy106:
	yych = *++cur;
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy106;
			goto yy62;
		} else {
			if (yych == '\f') goto yy62;
			if (yych <= '\r') goto yy106;
			goto yy62;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy106;
			if (yych <= '@') goto yy62;
			if (yych <= 'Z') goto yy223;
			goto yy62;
		} else {
			if (yych == '`') goto yy62;
			if (yych <= 'z') goto yy223;
			goto yy62;
		}
	}
yy107:
	yyaccept = 7;
	yych = *(mar = ++cur);
	if (yych <= 'Z') {
		if (yych <= '@') goto yy90;
		if (yych <= 'C') goto yy224;
		if (yych <= 'E') goto yy226;
		goto yy224;
	} else {
		if (yych <= 'c') {
			if (yych <= '`') goto yy90;
			goto yy224;
		} else {
			if (yych <= 'e') goto yy226;
			if (yych <= 'z') goto yy224;
			goto yy90;
		}
	}
yy108:
	yych = *++cur;
	if (yych <= ',') {
		if (yych == '+') goto yy227;
		goto yy62;
	} else {
		if (yych <= '-') goto yy227;
		if (yych <= '/') goto yy62;
		if (yych <= '9') goto yy228;
		goto yy62;
	}
yy109:
	yych = *++cur;
	if (yych <= '9') {
		if (yych <= '&') {
			if (yych == '"') goto yy66;
			goto yy62;
		} else {
			if (yych <= '\'') goto yy83;
			if (yych <= '/') goto yy62;
			goto yy229;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy62;
			if (yych <= 'Z') goto yy230;
			goto yy62;
		} else {
			if (yych == '`') goto yy62;
			if (yych <= 'z') goto yy230;
			goto yy62;
		}
	}
yy110:
	++cur;
#line 581 "parser/tokenizer.re"
	{ RET(TK_DBL_COLON) }
#line 1583 "parser/tokenizer.cpp"
yy111:
	++cur;
#line 596 "parser/tokenizer.re"
	{ RET(TK_LE) }
#line 1588 "parser/tokenizer.cpp"
yy112:
	++cur;
#line 587 "parser/tokenizer.re"
	{ RET(TK_EQ) }
#line 1593 "parser/tokenizer.cpp"
yy113:
	++cur;
#line 584 "parser/tokenizer.re"
	{ RET(TK_ARROW) }
#line 1598 "parser/tokenizer.cpp"
yy114:
	++cur;
#line 602 "parser/tokenizer.re"
	{ RET(TK_GE) }
#line 1603 "parser/tokenizer.cpp"
yy115:
	yych = *++cur;
	if (yych == 'S') goto yy231;
	if (yych == 's') goto yy231;
	goto yy37;
yy116:
	yych = *++cur;
	if (yych == 'L') goto yy232;
	if (yych == 'l') goto yy232;
	goto yy37;
yy117:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'S') goto yy234;
		if (yych <= 'X') goto yy37;
		goto yy235;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy37;
			goto yy234;
		} else {
			if (yych == 'y') goto yy235;
			goto yy37;
		}
	}
yy118:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych <= '&') {
		if (yych == '"') goto yy66;
		goto yy29;
	} else {
		if (yych <= '\'') goto yy83;
		if (yych == '_') goto yy118;
		goto yy29;
	}
yy119:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy236;
	}
	goto yy62;
yy120:
	yych = *++cur;
	if (yych <= '/') goto yy62;
	if (yych <= '1') goto yy237;
	goto yy62;
yy121:
	yych = *++cur;
	if (yych == 'C') goto yy238;
	if (yych == 'c') goto yy238;
	goto yy37;
yy122:
	yych = *++cur;
	if (yych == 'N') goto yy239;
	if (yych == 'n') goto yy239;
	goto yy37;
yy123:
	yych = *++cur;
	if (yych == 'O') goto yy240;
	if (yych == 'o') goto yy240;
	goto yy37;
yy124:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'L') goto yy241;
		if (yych <= 'R') goto yy37;
		goto yy242;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy241;
		} else {
			if (yych == 's') goto yy242;
			goto yy37;
		}
	}
yy125:
	yych = *++cur;
	if (yych == 'A') goto yy243;
	if (yych == 'a') goto yy243;
	goto yy37;
yy126:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy244;
		if (yych <= 'N') goto yy37;
		goto yy245;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy244;
		} else {
			if (yych == 'o') goto yy245;
			goto yy37;
		}
	}
yy127:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy37;
			goto yy246;
		} else {
			if (yych <= 'L') goto yy37;
			if (yych <= 'M') goto yy247;
			goto yy248;
		}
	} else {
		if (yych <= 'l') {
			if (yych == 'd') goto yy246;
			goto yy37;
		} else {
			if (yych <= 'm') goto yy247;
			if (yych <= 'n') goto yy248;
			goto yy37;
		}
	}
yy128:
	yych = *++cur;
	if (yych == 'I') goto yy249;
	if (yych == 'i') goto yy249;
	goto yy37;
yy129:
	yych = *++cur;
	if (yych == 'C') goto yy250;
	if (yych == 'c') goto yy250;
	goto yy37;
yy130:
	yych = *++cur;
	if (yych == 'T') goto yy251;
	if (yych == 't') goto yy251;
	goto yy37;
yy131:
	yych = *++cur;
	if (yych <= 'F') {
		if (yych == 'A') goto yy252;
		if (yych <= 'E') goto yy37;
		goto yy253;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy252;
		} else {
			if (yych == 'f') goto yy253;
			goto yy37;
		}
	}
yy132:
	yych = *++cur;
	if (yych == 'M') goto yy254;
	if (yych == 'm') goto yy254;
	goto yy37;
yy133:
	yyaccept = 8;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= '@') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych >= '\t') {
					ctxmar = cur;
					goto yy255;
				}
			} else {
				if (yych == '\v') {
					ctxmar = cur;
					goto yy255;
				}
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') {
					ctxmar = cur;
					goto yy255;
				}
				if (yych >= ' ') {
					ctxmar = cur;
					goto yy255;
				}
			} else {
				if (yych <= '/') goto yy134;
				if (yych <= '9') goto yy36;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'V') {
				if (yych == 'U') goto yy256;
				goto yy36;
			} else {
				if (yych <= 'W') goto yy257;
				if (yych <= 'Z') goto yy36;
			}
		} else {
			if (yych <= 'v') {
				if (yych == 'u') goto yy256;
				goto yy36;
			} else {
				if (yych <= 'w') goto yy257;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy134:
#line 318 "parser/tokenizer.re"
	{ KW(DO) }
#line 1816 "parser/tokenizer.cpp"
yy135:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'E') goto yy258;
		if (yych <= 'R') goto yy37;
		goto yy259;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy258;
		} else {
			if (yych == 's') goto yy259;
			goto yy37;
		}
	}
yy136:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy37;
			goto yy260;
		} else {
			if (yych <= 'S') goto yy37;
			if (yych <= 'T') goto yy262;
			goto yy263;
		}
	} else {
		if (yych <= 's') {
			if (yych == 'd') goto yy260;
			goto yy37;
		} else {
			if (yych <= 't') goto yy262;
			if (yych <= 'u') goto yy263;
			goto yy37;
		}
	}
yy137:
	yych = *++cur;
	if (yych == 'U') goto yy264;
	if (yych == 'u') goto yy264;
	goto yy37;
yy138:
	yych = *++cur;
	if (yych == 'R') goto yy265;
	if (yych == 'r') goto yy265;
	goto yy37;
yy139:
	yych = *++cur;
	if (yych == 'E') goto yy266;
	if (yych == 'e') goto yy266;
	goto yy37;
yy140:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'I') goto yy267;
		if (yych <= 'S') goto yy37;
		goto yy268;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy267;
		} else {
			if (yych == 't') goto yy268;
			goto yy37;
		}
	}
yy141:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'L') goto yy269;
		if (yych <= 'M') goto yy37;
		goto yy270;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy269;
		} else {
			if (yych == 'n') goto yy270;
			goto yy37;
		}
	}
yy142:
	yych = *++cur;
	if (yych == 'U') goto yy271;
	if (yych == 'u') goto yy271;
	goto yy37;
yy143:
	yych = *++cur;
	if (yych == 'R') goto yy272;
	if (yych == 'r') goto yy272;
	goto yy37;
yy144:
	yych = *++cur;
	if (yych == 'N') goto yy273;
	if (yych == 'n') goto yy273;
	goto yy37;
yy145:
	yych = *++cur;
	if (yych == 'N') goto yy274;
	if (yych == 'n') goto yy274;
	goto yy37;
yy146:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy147;
			if (yych <= 'S') goto yy36;
			goto yy275;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy275;
			if (yych <= 'z') goto yy36;
		}
	}
yy147:
#line 435 "parser/tokenizer.re"
	{ KW(GO) }
#line 1943 "parser/tokenizer.cpp"
yy148:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 437 "parser/tokenizer.re"
	{ KW(IF) }
#line 1952 "parser/tokenizer.cpp"
yy149:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'A') goto yy276;
		if (yych <= 'O') goto yy37;
		goto yy277;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy276;
		} else {
			if (yych == 'p') goto yy277;
			goto yy37;
		}
	}
yy150:
	yyaccept = 9;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'P') {
		if (yych <= ' ') {
			if (yych <= '\v') {
				if (yych == '\t') goto yy278;
				if (yych >= '\v') goto yy278;
			} else {
				if (yych == '\r') goto yy278;
				if (yych >= ' ') goto yy278;
			}
		} else {
			if (yych <= 'B') {
				if (yych <= '/') goto yy151;
				if (yych <= '9') goto yy36;
				if (yych >= 'A') goto yy36;
			} else {
				if (yych <= 'C') goto yy279;
				if (yych == 'O') goto yy280;
				goto yy36;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'T') {
				if (yych <= 'Q') goto yy281;
				if (yych <= 'R') goto yy36;
				if (yych <= 'S') goto yy282;
				goto yy283;
			} else {
				if (yych <= 'Z') goto yy36;
				if (yych <= '`') goto yy151;
				if (yych <= 'b') goto yy36;
				goto yy279;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy280;
				if (yych <= 'p') goto yy36;
				goto yy281;
			} else {
				if (yych <= 's') {
					if (yych <= 'r') goto yy36;
					goto yy282;
				} else {
					if (yych <= 't') goto yy283;
					if (yych <= 'z') goto yy36;
				}
			}
		}
	}
yy151:
#line 442 "parser/tokenizer.re"
	{ KW(IN) }
#line 2026 "parser/tokenizer.cpp"
yy152:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 452 "parser/tokenizer.re"
	{ KW(IS) }
#line 2035 "parser/tokenizer.cpp"
yy153:
	yych = *++cur;
	if (yych == 'N') goto yy284;
	if (yych == 'n') goto yy284;
	goto yy37;
yy154:
	yych = *++cur;
	if (yych == 'N') goto yy285;
	if (yych == 'n') goto yy285;
	goto yy37;
yy155:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy286;
		if (yych <= 'F') goto yy37;
		goto yy287;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy286;
		} else {
			if (yych == 'g') goto yy287;
			goto yy37;
		}
	}
yy156:
	yych = *++cur;
	if (yych == 'M') goto yy288;
	if (yych == 'm') goto yy288;
	goto yy37;
yy157:
	yych = *++cur;
	if (yych <= 'L') {
		if (yych == 'D') goto yy289;
		if (yych <= 'K') goto yy37;
		goto yy290;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy37;
			goto yy289;
		} else {
			if (yych == 'l') goto yy290;
			goto yy37;
		}
	}
yy158:
	yych = *++cur;
	if (yych == 'M') goto yy291;
	if (yych == 'm') goto yy291;
	goto yy37;
yy159:
	yych = *++cur;
	if (yych == 'W') goto yy292;
	if (yych == 'w') goto yy292;
	goto yy37;
yy160:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'N') goto yy293;
		if (yych <= 'O') goto yy37;
		goto yy294;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy293;
		} else {
			if (yych == 'p') goto yy294;
			goto yy37;
		}
	}
yy161:
	yych = *++cur;
	if (yych == 'L') goto yy295;
	if (yych == 'l') goto yy295;
	goto yy37;
yy162:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy296;
	}
	goto yy62;
yy163:
	yych = *++cur;
	if (yych <= '/') goto yy62;
	if (yych <= '7') goto yy297;
	goto yy62;
yy164:
	yych = *++cur;
	if (yych == 'L') goto yy298;
	if (yych == 'l') goto yy298;
	goto yy37;
yy165:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy299;
		if (yych <= 'S') goto yy37;
		goto yy300;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy299;
		} else {
			if (yych == 't') goto yy300;
			goto yy37;
		}
	}
yy166:
	yych = *++cur;
	if (yych == 'T') goto yy301;
	if (yych == 't') goto yy301;
	goto yy37;
yy167:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'Q') goto yy37;
		if (yych <= 'R') goto yy302;
		goto yy303;
	} else {
		if (yych <= 'q') goto yy37;
		if (yych <= 'r') goto yy302;
		if (yych <= 's') goto yy303;
		goto yy37;
	}
yy168:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'I') goto yy304;
		if (yych <= 'R') goto yy37;
		goto yy305;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy304;
		} else {
			if (yych == 's') goto yy305;
			goto yy37;
		}
	}
yy169:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'E') goto yy306;
			goto yy37;
		} else {
			if (yych <= 'I') goto yy307;
			if (yych <= 'N') goto yy37;
			goto yy308;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'e') goto yy306;
			goto yy37;
		} else {
			if (yych <= 'i') goto yy307;
			if (yych == 'o') goto yy308;
			goto yy37;
		}
	}
yy170:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'B') goto yy309;
		if (yych <= 'Q') goto yy37;
		goto yy310;
	} else {
		if (yych <= 'b') {
			if (yych <= 'a') goto yy37;
			goto yy309;
		} else {
			if (yych == 'r') goto yy310;
			goto yy37;
		}
	}
yy171:
	yych = *++cur;
	if (yych == 'I') goto yy311;
	if (yych == 'i') goto yy311;
	goto yy37;
yy172:
	yych = *++cur;
	if (yych == 'N') goto yy312;
	if (yych == 'n') goto yy312;
	goto yy37;
yy173:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy313;
		case 'C':
		case 'c': goto yy314;
		case 'D':
		case 'd': goto yy315;
		case 'Q':
		case 'q': goto yy316;
		case 'S':
		case 's': goto yy317;
		case 'T':
		case 't': goto yy318;
		case 'W':
		case 'w': goto yy319;
		default: goto yy37;
	}
yy174:
	yych = *++cur;
	if (yych == 'V') goto yy320;
	if (yych == 'v') goto yy320;
	goto yy37;
yy175:
	yych = *++cur;
	if (yych <= 'Q') {
		if (yych == 'L') goto yy321;
		if (yych <= 'P') goto yy37;
		goto yy322;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy321;
		} else {
			if (yych == 'q') goto yy322;
			goto yy37;
		}
	}
yy176:
	yych = *++cur;
	if (yych == 'A') goto yy323;
	if (yych == 'a') goto yy323;
	goto yy37;
yy177:
	yych = *++cur;
	if (yych == 'U') goto yy324;
	if (yych == 'u') goto yy324;
	goto yy37;
yy178:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy325;
		if (yych <= 'N') goto yy37;
		goto yy326;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy325;
		} else {
			if (yych == 'o') goto yy326;
			goto yy37;
		}
	}
yy179:
	yych = *++cur;
	if (yych == 'B') goto yy327;
	if (yych == 'b') goto yy327;
	goto yy37;
yy180:
	yych = *++cur;
	if (yych == 'N') goto yy328;
	if (yych == 'n') goto yy328;
	goto yy37;
yy181:
	yych = *++cur;
	if (yych == 'R') goto yy329;
	if (yych == 'r') goto yy329;
	goto yy37;
yy182:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych == 'A') goto yy330;
		if (yych <= 'L') goto yy37;
		goto yy331;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy330;
		} else {
			if (yych == 'm') goto yy331;
			goto yy37;
		}
	}
yy183:
	yych = *++cur;
	if (yych == 'E') goto yy332;
	if (yych == 'e') goto yy332;
	goto yy37;
yy184:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 520 "parser/tokenizer.re"
	{ KW(TO) }
#line 2327 "parser/tokenizer.cpp"
yy185:
	yych = *++cur;
	if (yych == 'P') goto yy333;
	if (yych == 'p') goto yy333;
	goto yy37;
yy186:
	yych = *++cur;
	if (yych == 'F') goto yy334;
	if (yych == 'f') goto yy334;
	goto yy37;
yy187:
	yych = *++cur;
	if (yych == 'E') goto yy335;
	if (yych == 'e') goto yy335;
	goto yy37;
yy188:
	yych = *++cur;
	if (yych == 'L') goto yy336;
	if (yych == 'l') goto yy336;
	goto yy37;
yy189:
	yych = *++cur;
	if (yych == 'L') goto yy337;
	if (yych == 'l') goto yy337;
	goto yy37;
yy190:
	yych = *++cur;
	if (yych == 'I') goto yy338;
	if (yych == 'i') goto yy338;
	goto yy37;
yy191:
	yych = *++cur;
	if (yych <= 'I') {
		if (yych == 'E') goto yy339;
		if (yych <= 'H') goto yy37;
		goto yy340;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy339;
		} else {
			if (yych == 'i') goto yy340;
			goto yy37;
		}
	}
yy192:
	yych = *++cur;
	if (yych == 'I') goto yy341;
	if (yych == 'i') goto yy341;
	goto yy37;
yy193:
	yych = *++cur;
	if (yych == '"') goto yy62;
	goto yy343;
yy194:
	yych = *++cur;
	if (yych == '\'') goto yy62;
	goto yy345;
yy195:
	yych = *++cur;
	if (yych == 'F') goto yy346;
	if (yych == 'f') goto yy346;
	goto yy37;
yy196:
	yych = *++cur;
	if (yych == 'M') goto yy347;
	if (yych == 'm') goto yy347;
	goto yy61;
yy197:
	yych = *++cur;
	if (yych == '$') goto yy348;
	goto yy61;
yy198:
	yych = *++cur;
	if (yych == 'f') goto yy349;
	goto yy70;
yy199:
	yych = *++cur;
	if (yych == 'i') goto yy350;
	if (yych == 's') goto yy351;
	goto yy70;
yy200:
	yych = *++cur;
	if (yych == 'd') goto yy352;
	goto yy70;
yy201:
	yych = *++cur;
	if (yych == 'd') goto yy353;
	goto yy70;
yy202:
	yych = *++cur;
	if (yych == 'c') goto yy354;
	goto yy70;
yy203:
	yych = *++cur;
	if (yych == 'n') goto yy355;
	goto yy70;
yy204:
	++cur;
	goto yy81;
yy205:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy62;
			goto yy205;
		} else {
			if (yych == '\v') goto yy205;
			goto yy62;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy205;
			if (yych <= 0x1F) goto yy62;
			goto yy205;
		} else {
			if (yych == ')') goto yy356;
			goto yy62;
		}
	}
yy206:
	++cur;
	cur -= 2;
#line 556 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 2453 "parser/tokenizer.cpp"
yy207:
	yych = *++cur;
	if (yych == ')') goto yy359;
	goto yy358;
yy208:
	++cur;
	cur -= 2;
#line 555 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 2463 "parser/tokenizer.cpp"
yy209:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy62;
		if (yych <= '9') goto yy360;
		if (yych <= '@') goto yy62;
		goto yy361;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy62;
			goto yy361;
		} else {
			if (yych <= '`') goto yy62;
			if (yych <= 'z') goto yy361;
			goto yy62;
		}
	}
yy210:
	++cur;
#line 765 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_DEF_OP) }
#line 2485 "parser/tokenizer.cpp"
yy211:
	yych = *++cur;
	if (yych == 'D') goto yy362;
	if (yych == 'd') goto yy362;
	goto yy94;
yy212:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == '.') goto yy363;
		goto yy94;
	} else {
		if (yych <= 'V') goto yy364;
		if (yych == 'v') goto yy364;
		goto yy94;
	}
yy213:
	yych = *++cur;
	if (yych == 'L') goto yy365;
	if (yych == 'l') goto yy365;
	goto yy94;
yy214:
	yych = *++cur;
	if (yych == '.') goto yy366;
	goto yy94;
yy215:
	yych = *++cur;
	if (yych == '.') goto yy367;
	goto yy94;
yy216:
	yych = *++cur;
	if (yych == '.') goto yy368;
	goto yy94;
yy217:
	yych = *++cur;
	if (yych == '.') goto yy369;
	goto yy94;
yy218:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == '.') goto yy370;
		goto yy94;
	} else {
		if (yych <= 'Q') goto yy371;
		if (yych == 'q') goto yy371;
		goto yy94;
	}
yy219:
	yych = *++cur;
	if (yych == 'T') goto yy372;
	if (yych == 't') goto yy372;
	goto yy94;
yy220:
	yych = *++cur;
	if (yych == '.') goto yy373;
	goto yy94;
yy221:
	yych = *++cur;
	if (yych == 'U') goto yy374;
	if (yych == 'u') goto yy374;
	goto yy94;
yy222:
	yych = *++cur;
	if (yych == 'R') goto yy375;
	if (yych == 'r') goto yy375;
	goto yy94;
yy223:
	yych = *++cur;
	if (yybm[0+yych] & 16) {
		goto yy223;
	}
	cur = ctxmar;
#line 633 "parser/tokenizer.re"
	{
                if (last_token == yytokentype::TK_NEWLINE) {
                    uint64_t u;
                    if (lex_int(tok, cur, u, yylval.int_suffix.int_kind)) {
                            yylval.n = u;
                            if (enddo_label_stack[enddo_label_stack.size()-1] == u) {
                                while (enddo_label_stack[enddo_label_stack.size()-1] == u) {
                                    enddo_label_stack.pop_back();
                                    enddo_insert_count++;
                                }
                                enddo_newline_process = true;
                            } else {
                                enddo_newline_process = false;
                            }
                            RET(TK_LABEL)
                    } else {
                        token_loc(loc);
                        std::string t = token();
                        diagnostics.add(diag::Diagnostic(
                            "Integer '" + t + "' too large",
                            diag::Level::Error, diag::Stage::Tokenizer, {
                            diag::Label("", {loc})}
                        ));
                        throw parser_local::TokenizerAbort();
                    }
                } else {
                    lex_int_large(al, tok, cur,
                        yylval.int_suffix.int_n,
                        yylval.int_suffix.int_kind);
                    RET(TK_INTEGER)
                }
            }
#line 2590 "parser/tokenizer.cpp"
yy224:
	yych = *++cur;
yy225:
	if (yych <= '@') {
		if (yych == '.') goto yy376;
		goto yy62;
	} else {
		if (yych <= 'Z') goto yy224;
		if (yych <= '`') goto yy62;
		if (yych <= 'z') goto yy224;
		goto yy62;
	}
yy226:
	yych = *++cur;
	if (yych <= ',') {
		if (yych != '+') goto yy225;
	} else {
		if (yych <= '-') goto yy227;
		if (yych <= '/') goto yy225;
		if (yych <= '9') goto yy228;
		goto yy225;
	}
yy227:
	yych = *++cur;
	if (yych <= '/') goto yy62;
	if (yych >= ':') goto yy62;
yy228:
	yyaccept = 7;
	yych = *(mar = ++cur);
	if (yych <= '/') goto yy91;
	if (yych <= '9') goto yy228;
	if (yych == '_') goto yy209;
	goto yy91;
yy229:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy106;
			}
			goto yy21;
		} else {
			if (yych == '\f') goto yy21;
			ctxmar = cur;
			goto yy106;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') {
				ctxmar = cur;
				goto yy106;
			}
			goto yy21;
		} else {
			if (yych <= '.') {
				ctxmar = cur;
				goto yy377;
			}
			if (yych <= '/') goto yy21;
			if (yych <= '9') goto yy229;
			goto yy21;
		}
	}
yy230:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '-') {
		if (yych <= '\v') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy106;
			}
			if (yych <= '\n') goto yy21;
			ctxmar = cur;
			goto yy106;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy21;
				ctxmar = cur;
				goto yy106;
			} else {
				if (yych == ' ') {
					ctxmar = cur;
					goto yy106;
				}
				goto yy21;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych <= '.') {
					ctxmar = cur;
					goto yy377;
				}
				goto yy21;
			} else {
				if (yych <= '9') goto yy230;
				if (yych <= '@') goto yy21;
				goto yy230;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy21;
				goto yy230;
			} else {
				if (yych <= '`') goto yy21;
				if (yych <= 'z') goto yy230;
				goto yy21;
			}
		}
	}
yy231:
	yych = *++cur;
	if (yych == 'T') goto yy378;
	if (yych == 't') goto yy378;
	goto yy37;
yy232:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy233;
			if (yych <= 'N') goto yy36;
			goto yy379;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'o') goto yy379;
			if (yych <= 'z') goto yy36;
		}
	}
yy233:
#line 280 "parser/tokenizer.re"
	{ KW(ALL) }
#line 2735 "parser/tokenizer.cpp"
yy234:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'I') goto yy380;
		if (yych <= 'N') goto yy37;
		goto yy381;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy380;
		} else {
			if (yych == 'o') goto yy381;
			goto yy37;
		}
	}
yy235:
	yych = *++cur;
	if (yych == 'N') goto yy382;
	if (yych == 'n') goto yy382;
	goto yy37;
yy236:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy236;
	}
	if (yych == '"') goto yy383;
	goto yy62;
yy237:
	yych = *++cur;
	if (yych == '\'') goto yy384;
	if (yych <= '/') goto yy62;
	if (yych <= '1') goto yy237;
	goto yy62;
yy238:
	yych = *++cur;
	if (yych == 'K') goto yy385;
	if (yych == 'k') goto yy385;
	goto yy37;
yy239:
	yych = *++cur;
	if (yych == 'D') goto yy386;
	if (yych == 'd') goto yy386;
	goto yy37;
yy240:
	yych = *++cur;
	if (yych == 'C') goto yy387;
	if (yych == 'c') goto yy387;
	goto yy37;
yy241:
	yych = *++cur;
	if (yych == 'L') goto yy388;
	if (yych == 'l') goto yy388;
	goto yy37;
yy242:
	yych = *++cur;
	if (yych == 'E') goto yy389;
	if (yych == 'e') goto yy389;
	goto yy37;
yy243:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy390;
		if (yych <= 'Q') goto yy37;
		goto yy391;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy390;
		} else {
			if (yych == 'r') goto yy391;
			goto yy37;
		}
	}
yy244:
	yych = *++cur;
	if (yych == 'S') goto yy392;
	if (yych == 's') goto yy392;
	goto yy37;
yy245:
	yych = *++cur;
	if (yych == 'S') goto yy393;
	if (yych == 's') goto yy393;
	goto yy37;
yy246:
	yych = *++cur;
	if (yych == 'I') goto yy394;
	if (yych == 'i') goto yy394;
	goto yy37;
yy247:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'M') goto yy395;
		if (yych <= 'O') goto yy37;
		goto yy396;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy395;
		} else {
			if (yych == 'p') goto yy396;
			goto yy37;
		}
	}
yy248:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'C') goto yy397;
		if (yych <= 'S') goto yy37;
		goto yy398;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy397;
		} else {
			if (yych == 't') goto yy398;
			goto yy37;
		}
	}
yy249:
	yych = *++cur;
	if (yych == 'T') goto yy399;
	if (yych == 't') goto yy399;
	goto yy37;
yy250:
	yych = *++cur;
	if (yych == 'L') goto yy400;
	if (yych == 'l') goto yy400;
	goto yy37;
yy251:
	yych = *++cur;
	if (yych == 'A') goto yy401;
	if (yych == 'a') goto yy401;
	goto yy37;
yy252:
	yych = *++cur;
	if (yych == 'L') goto yy402;
	if (yych == 'l') goto yy402;
	goto yy37;
yy253:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy403;
		if (yych <= 'D') goto yy37;
		goto yy404;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy403;
		} else {
			if (yych == 'e') goto yy404;
			goto yy37;
		}
	}
yy254:
	yych = *++cur;
	if (yych == 'E') goto yy405;
	if (yych == 'e') goto yy405;
	goto yy37;
yy255:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy62;
			goto yy255;
		} else {
			if (yych == '\v') goto yy255;
			goto yy62;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy255;
			if (yych <= 0x1F) goto yy62;
			goto yy255;
		} else {
			if (yych <= '/') goto yy62;
			if (yych <= '9') goto yy406;
			goto yy62;
		}
	}
yy256:
	yych = *++cur;
	if (yych == 'B') goto yy408;
	if (yych == 'b') goto yy408;
	goto yy37;
yy257:
	yych = *++cur;
	if (yych == 'H') goto yy409;
	if (yych == 'h') goto yy409;
	goto yy37;
yy258:
	yych = *++cur;
	if (yych == 'M') goto yy410;
	if (yych == 'm') goto yy410;
	goto yy37;
yy259:
	yych = *++cur;
	if (yych == 'E') goto yy411;
	if (yych == 'e') goto yy411;
	goto yy37;
yy260:
	yyaccept = 10;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	switch (yych) {
		case '\t':
		case '\v':
		case '\r': goto yy413;
		case ' ': goto yy415;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'N':
		case 'O':
		case 'Q':
		case 'R':
		case 'U':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'y':
		case 'z': goto yy36;
		case 'A':
		case 'a': goto yy416;
		case 'B':
		case 'b': goto yy417;
		case 'C':
		case 'c': goto yy418;
		case 'D':
		case 'd': goto yy419;
		case 'E':
		case 'e': goto yy420;
		case 'F':
		case 'f': goto yy421;
		case 'I':
		case 'i': goto yy422;
		case 'M':
		case 'm': goto yy423;
		case 'P':
		case 'p': goto yy424;
		case 'S':
		case 's': goto yy425;
		case 'T':
		case 't': goto yy426;
		case 'W':
		case 'w': goto yy427;
		default: goto yy261;
	}
yy261:
#line 328 "parser/tokenizer.re"
	{ KW(END) }
#line 3013 "parser/tokenizer.cpp"
yy262:
	yych = *++cur;
	if (yych == 'R') goto yy428;
	if (yych == 'r') goto yy428;
	goto yy37;
yy263:
	yych = *++cur;
	if (yych == 'M') goto yy429;
	if (yych == 'm') goto yy429;
	goto yy37;
yy264:
	yych = *++cur;
	if (yych == 'I') goto yy431;
	if (yych == 'i') goto yy431;
	goto yy37;
yy265:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'M') goto yy432;
		if (yych <= 'N') goto yy37;
		goto yy433;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy432;
		} else {
			if (yych == 'o') goto yy433;
			goto yy37;
		}
	}
yy266:
	yych = *++cur;
	if (yych == 'N') goto yy434;
	if (yych == 'n') goto yy434;
	goto yy37;
yy267:
	yych = *++cur;
	if (yych == 'T') goto yy435;
	if (yych == 't') goto yy435;
	goto yy37;
yy268:
	yych = *++cur;
	if (yych == 'E') goto yy436;
	if (yych == 'e') goto yy436;
	goto yy37;
yy269:
	yych = *++cur;
	if (yych == 'E') goto yy437;
	if (yych == 'e') goto yy437;
	goto yy37;
yy270:
	yych = *++cur;
	if (yych == 'A') goto yy438;
	if (yych == 'a') goto yy438;
	goto yy37;
yy271:
	yych = *++cur;
	if (yych == 'S') goto yy439;
	if (yych == 's') goto yy439;
	goto yy37;
yy272:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych == 'A') goto yy440;
		if (yych <= 'L') goto yy37;
		goto yy441;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy440;
		} else {
			if (yych == 'm') goto yy441;
			goto yy37;
		}
	}
yy273:
	yych = *++cur;
	if (yych == 'C') goto yy443;
	if (yych == 'c') goto yy443;
	goto yy37;
yy274:
	yych = *++cur;
	if (yych == 'E') goto yy444;
	if (yych == 'e') goto yy444;
	goto yy37;
yy275:
	yych = *++cur;
	if (yych == 'O') goto yy445;
	if (yych == 'o') goto yy445;
	goto yy37;
yy276:
	yych = *++cur;
	if (yych == 'G') goto yy446;
	if (yych == 'g') goto yy446;
	goto yy37;
yy277:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'L') goto yy447;
			goto yy37;
		} else {
			if (yych <= 'O') goto yy448;
			if (yych <= 'T') goto yy37;
			goto yy449;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'l') goto yy447;
			goto yy37;
		} else {
			if (yych <= 'o') goto yy448;
			if (yych == 'u') goto yy449;
			goto yy37;
		}
	}
yy278:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy278;
			goto yy62;
		} else {
			if (yych == '\f') goto yy62;
			goto yy278;
		}
	} else {
		if (yych <= 'N') {
			if (yych == ' ') goto yy278;
			goto yy62;
		} else {
			if (yych <= 'O') goto yy450;
			if (yych == 'o') goto yy450;
			goto yy62;
		}
	}
yy279:
	yych = *++cur;
	if (yych == 'L') goto yy451;
	if (yych == 'l') goto yy451;
	goto yy37;
yy280:
	yych = *++cur;
	if (yych == 'U') goto yy452;
	if (yych == 'u') goto yy452;
	goto yy37;
yy281:
	yych = *++cur;
	if (yych == 'U') goto yy453;
	if (yych == 'u') goto yy453;
	goto yy37;
yy282:
	yych = *++cur;
	if (yych == 'T') goto yy454;
	if (yych == 't') goto yy454;
	goto yy37;
yy283:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'E') goto yy455;
		if (yych <= 'Q') goto yy37;
		goto yy456;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy455;
		} else {
			if (yych == 'r') goto yy456;
			goto yy37;
		}
	}
yy284:
	yych = *++cur;
	if (yych == 'D') goto yy457;
	if (yych == 'd') goto yy457;
	goto yy37;
yy285:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 454 "parser/tokenizer.re"
	{ KW(LEN) }
#line 3198 "parser/tokenizer.cpp"
yy286:
	yych = *++cur;
	if (yych == 'A') goto yy458;
	if (yych == 'a') goto yy458;
	goto yy37;
yy287:
	yych = *++cur;
	if (yych == 'I') goto yy459;
	if (yych == 'i') goto yy459;
	goto yy37;
yy288:
	yych = *++cur;
	if (yych == 'O') goto yy460;
	if (yych == 'o') goto yy460;
	goto yy37;
yy289:
	yych = *++cur;
	if (yych == 'U') goto yy461;
	if (yych == 'u') goto yy461;
	goto yy37;
yy290:
	yych = *++cur;
	if (yych == 'D') goto yy462;
	if (yych == 'd') goto yy462;
	goto yy37;
yy291:
	yych = *++cur;
	if (yych == 'E') goto yy463;
	if (yych == 'e') goto yy463;
	goto yy37;
yy292:
	yych = *++cur;
	if (yych == '_') goto yy465;
	goto yy37;
yy293:
	yych = *++cur;
	if (yych <= '^') {
		if (yych == 'E') goto yy466;
		goto yy37;
	} else {
		if (yych <= '_') goto yy467;
		if (yych == 'e') goto yy466;
		goto yy37;
	}
yy294:
	yych = *++cur;
	if (yych == 'A') goto yy468;
	if (yych == 'a') goto yy468;
	goto yy37;
yy295:
	yych = *++cur;
	if (yych == 'L') goto yy469;
	if (yych == 'l') goto yy469;
	goto yy37;
yy296:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy296;
	}
	if (yych == '"') goto yy470;
	goto yy62;
yy297:
	yych = *++cur;
	if (yych == '\'') goto yy471;
	if (yych <= '/') goto yy62;
	if (yych <= '7') goto yy297;
	goto yy62;
yy298:
	yych = *++cur;
	if (yych == 'Y') goto yy472;
	if (yych == 'y') goto yy472;
	goto yy37;
yy299:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy473;
		if (yych <= 'Q') goto yy37;
		goto yy474;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy473;
		} else {
			if (yych == 'r') goto yy474;
			goto yy37;
		}
	}
yy300:
	yych = *++cur;
	if (yych == 'I') goto yy475;
	if (yych == 'i') goto yy475;
	goto yy37;
yy301:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 474 "parser/tokenizer.re"
	{ KW(OUT) }
#line 3299 "parser/tokenizer.cpp"
yy302:
	yych = *++cur;
	if (yych == 'A') goto yy476;
	if (yych == 'a') goto yy476;
	goto yy37;
yy303:
	yych = *++cur;
	if (yych == 'S') goto yy477;
	if (yych == 's') goto yy477;
	goto yy37;
yy304:
	yych = *++cur;
	if (yych == 'N') goto yy478;
	if (yych == 'n') goto yy478;
	goto yy37;
yy305:
	yych = *++cur;
	if (yych == 'T') goto yy479;
	if (yych == 't') goto yy479;
	goto yy37;
yy306:
	yych = *++cur;
	if (yych == 'C') goto yy480;
	if (yych == 'c') goto yy480;
	goto yy37;
yy307:
	yych = *++cur;
	if (yych <= 'V') {
		if (yych == 'N') goto yy481;
		if (yych <= 'U') goto yy37;
		goto yy482;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy481;
		} else {
			if (yych == 'v') goto yy482;
			goto yy37;
		}
	}
yy308:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych <= 'F') {
			if (yych == 'C') goto yy483;
			goto yy37;
		} else {
			if (yych <= 'G') goto yy484;
			if (yych <= 'S') goto yy37;
			goto yy485;
		}
	} else {
		if (yych <= 'f') {
			if (yych == 'c') goto yy483;
			goto yy37;
		} else {
			if (yych <= 'g') goto yy484;
			if (yych == 't') goto yy485;
			goto yy37;
		}
	}
yy309:
	yych = *++cur;
	if (yych == 'L') goto yy486;
	if (yych == 'l') goto yy486;
	goto yy37;
yy310:
	yych = *++cur;
	if (yych == 'E') goto yy487;
	if (yych == 'e') goto yy487;
	goto yy37;
yy311:
	yych = *++cur;
	if (yych == 'E') goto yy488;
	if (yych == 'e') goto yy488;
	goto yy37;
yy312:
	yych = *++cur;
	if (yych == 'K') goto yy489;
	if (yych == 'k') goto yy489;
	goto yy37;
yy313:
	yych = *++cur;
	if (yych <= 'L') {
		if (yych == 'D') goto yy490;
		if (yych <= 'K') goto yy37;
		goto yy491;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy37;
			goto yy490;
		} else {
			if (yych == 'l') goto yy491;
			goto yy37;
		}
	}
yy314:
	yych = *++cur;
	if (yych == 'U') goto yy492;
	if (yych == 'u') goto yy492;
	goto yy37;
yy315:
	yych = *++cur;
	if (yych == 'U') goto yy493;
	if (yych == 'u') goto yy493;
	goto yy37;
yy316:
	yych = *++cur;
	if (yych == 'U') goto yy494;
	if (yych == 'u') goto yy494;
	goto yy37;
yy317:
	yych = *++cur;
	if (yych == 'U') goto yy495;
	if (yych == 'u') goto yy495;
	goto yy37;
yy318:
	yych = *++cur;
	if (yych == 'U') goto yy496;
	if (yych == 'u') goto yy496;
	goto yy37;
yy319:
	yych = *++cur;
	if (yych == 'I') goto yy497;
	if (yych == 'i') goto yy497;
	goto yy37;
yy320:
	yych = *++cur;
	if (yych == 'E') goto yy498;
	if (yych == 'e') goto yy498;
	goto yy37;
yy321:
	yych = *++cur;
	if (yych == 'E') goto yy499;
	if (yych == 'e') goto yy499;
	goto yy37;
yy322:
	yych = *++cur;
	if (yych == 'U') goto yy500;
	if (yych == 'u') goto yy500;
	goto yy37;
yy323:
	yych = *++cur;
	if (yych == 'R') goto yy501;
	if (yych == 'r') goto yy501;
	goto yy37;
yy324:
	yych = *++cur;
	if (yych == 'R') goto yy502;
	if (yych == 'r') goto yy502;
	goto yy37;
yy325:
	yych = *++cur;
	if (yych == 'T') goto yy503;
	if (yych == 't') goto yy503;
	goto yy37;
yy326:
	yych = *++cur;
	if (yych == 'P') goto yy504;
	if (yych == 'p') goto yy504;
	goto yy37;
yy327:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy505;
		if (yych <= 'Q') goto yy37;
		goto yy506;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy505;
		} else {
			if (yych == 'r') goto yy506;
			goto yy37;
		}
	}
yy328:
	yych = *++cur;
	if (yych == 'C') goto yy507;
	if (yych == 'c') goto yy507;
	goto yy37;
yy329:
	yych = *++cur;
	if (yych == 'G') goto yy509;
	if (yych == 'g') goto yy509;
	goto yy37;
yy330:
	yych = *++cur;
	if (yych == 'M') goto yy510;
	if (yych == 'm') goto yy510;
	goto yy37;
yy331:
	yych = *++cur;
	if (yych == 'P') goto yy511;
	if (yych == 'p') goto yy511;
	goto yy37;
yy332:
	yych = *++cur;
	if (yych == 'N') goto yy512;
	if (yych == 'n') goto yy512;
	goto yy37;
yy333:
	yych = *++cur;
	if (yych == 'E') goto yy513;
	if (yych == 'e') goto yy513;
	goto yy37;
yy334:
	yych = *++cur;
	if (yych == 'O') goto yy514;
	if (yych == 'o') goto yy514;
	goto yy37;
yy335:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 523 "parser/tokenizer.re"
	{ KW(USE) }
#line 3519 "parser/tokenizer.cpp"
yy336:
	yych = *++cur;
	if (yych == 'U') goto yy515;
	if (yych == 'u') goto yy515;
	goto yy37;
yy337:
	yych = *++cur;
	if (yych == 'A') goto yy516;
	if (yych == 'a') goto yy516;
	goto yy37;
yy338:
	yych = *++cur;
	if (yych == 'T') goto yy517;
	if (yych == 't') goto yy517;
	goto yy37;
yy339:
	yych = *++cur;
	if (yych == 'R') goto yy518;
	if (yych == 'r') goto yy518;
	goto yy37;
yy340:
	yych = *++cur;
	if (yych == 'L') goto yy519;
	if (yych == 'l') goto yy519;
	goto yy37;
yy341:
	yych = *++cur;
	if (yych == 'T') goto yy520;
	if (yych == 't') goto yy520;
	goto yy37;
yy342:
	yych = *++cur;
yy343:
	if (yybm[0+yych] & 128) {
		goto yy342;
	}
	if (yych == '"') goto yy521;
	goto yy62;
yy344:
	yych = *++cur;
yy345:
	if (yych <= '9') {
		if (yych == '\'') goto yy522;
		if (yych <= '/') goto yy62;
		goto yy344;
	} else {
		if (yych <= 'F') {
			if (yych <= '@') goto yy62;
			goto yy344;
		} else {
			if (yych <= '`') goto yy62;
			if (yych <= 'f') goto yy344;
			goto yy62;
		}
	}
yy346:
	yych = *++cur;
	if (yych == 'O') goto yy523;
	if (yych == 'o') goto yy523;
	goto yy37;
yy347:
	yych = *++cur;
	if (yych == 'P') goto yy524;
	if (yych == 'p') goto yy524;
	goto yy61;
yy348:
	yych = *++cur;
	if (yych <= 0x00) goto yy62;
	if (yych == '\n') goto yy525;
	goto yy348;
yy349:
	yych = *++cur;
	if (yych == 'i') goto yy526;
	goto yy70;
yy350:
	yych = *++cur;
	if (yych == 'f') goto yy527;
	goto yy70;
yy351:
	yych = *++cur;
	if (yych == 'e') goto yy528;
	goto yy70;
yy352:
	yych = *++cur;
	if (yych == 'i') goto yy529;
	goto yy70;
yy353:
	yych = *++cur;
	if (yych == 'e') goto yy530;
	goto yy70;
yy354:
	yych = *++cur;
	if (yych == 'l') goto yy531;
	goto yy70;
yy355:
	yych = *++cur;
	if (yych == 'e') goto yy532;
	goto yy70;
yy356:
	++cur;
	cur = ctxmar;
#line 558 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 3623 "parser/tokenizer.cpp"
yy357:
	yych = *++cur;
yy358:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy62;
			goto yy357;
		} else {
			if (yych == '\v') goto yy357;
			goto yy62;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy357;
			if (yych <= 0x1F) goto yy62;
			goto yy357;
		} else {
			if (yych == ')') goto yy533;
			goto yy62;
		}
	}
yy359:
	++cur;
	cur -= 3;
#line 561 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 3650 "parser/tokenizer.cpp"
yy360:
	yych = *++cur;
	if (yych <= '/') goto yy91;
	if (yych <= '9') goto yy360;
	goto yy91;
yy361:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy91;
		if (yych <= '9') goto yy361;
		if (yych <= '@') goto yy91;
		goto yy361;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy91;
			goto yy361;
		} else {
			if (yych <= '`') goto yy91;
			if (yych <= 'z') goto yy361;
			goto yy91;
		}
	}
yy362:
	yych = *++cur;
	if (yych == '.') goto yy534;
	goto yy94;
yy363:
	++cur;
#line 588 "parser/tokenizer.re"
	{ WARN_REL(EQ) RET(TK_EQ) }
#line 3681 "parser/tokenizer.cpp"
yy364:
	yych = *++cur;
	if (yych == '.') goto yy535;
	goto yy94;
yy365:
	yych = *++cur;
	if (yych == 'S') goto yy536;
	if (yych == 's') goto yy536;
	goto yy94;
yy366:
	++cur;
#line 603 "parser/tokenizer.re"
	{ WARN_REL(GE) RET(TK_GE) }
#line 3695 "parser/tokenizer.cpp"
yy367:
	++cur;
#line 600 "parser/tokenizer.re"
	{ WARN_REL(GT) RET(TK_GT) }
#line 3700 "parser/tokenizer.cpp"
yy368:
	++cur;
#line 597 "parser/tokenizer.re"
	{ WARN_REL(LE) RET(TK_LE) }
#line 3705 "parser/tokenizer.cpp"
yy369:
	++cur;
#line 594 "parser/tokenizer.re"
	{ WARN_REL(LT) RET(TK_LT) }
#line 3710 "parser/tokenizer.cpp"
yy370:
	++cur;
#line 591 "parser/tokenizer.re"
	{ WARN_REL(NE) RET(TK_NE) }
#line 3715 "parser/tokenizer.cpp"
yy371:
	yych = *++cur;
	if (yych == 'V') goto yy537;
	if (yych == 'v') goto yy537;
	goto yy94;
yy372:
	yych = *++cur;
	if (yych == '.') goto yy538;
	goto yy94;
yy373:
	++cur;
#line 609 "parser/tokenizer.re"
	{ RET(TK_OR) }
#line 3729 "parser/tokenizer.cpp"
yy374:
	yych = *++cur;
	if (yych == 'E') goto yy539;
	if (yych == 'e') goto yy539;
	goto yy94;
yy375:
	yych = *++cur;
	if (yych == '.') goto yy540;
	goto yy94;
yy376:
	++cur;
	cur = ctxmar;
#line 624 "parser/tokenizer.re"
	{
                lex_int_large(al, tok, cur,
                    yylval.int_suffix.int_n,
                    yylval.int_suffix.int_kind);
                RET(TK_INTEGER)
            }
#line 3749 "parser/tokenizer.cpp"
yy377:
	yych = *++cur;
	if (yych == '.') goto yy62;
	goto yy225;
yy378:
	yych = *++cur;
	if (yych == 'R') goto yy541;
	if (yych == 'r') goto yy541;
	goto yy37;
yy379:
	yych = *++cur;
	if (yych == 'C') goto yy542;
	if (yych == 'c') goto yy542;
	goto yy37;
yy380:
	yych = *++cur;
	if (yych == 'G') goto yy543;
	if (yych == 'g') goto yy543;
	goto yy37;
yy381:
	yych = *++cur;
	if (yych == 'C') goto yy544;
	if (yych == 'c') goto yy544;
	goto yy37;
yy382:
	yych = *++cur;
	if (yych == 'C') goto yy545;
	if (yych == 'c') goto yy545;
	goto yy37;
yy383:
	++cur;
#line 672 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 3783 "parser/tokenizer.cpp"
yy384:
	++cur;
#line 673 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 3788 "parser/tokenizer.cpp"
yy385:
	yych = *++cur;
	if (yych == 'S') goto yy546;
	if (yych == 's') goto yy546;
	goto yy37;
yy386:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 288 "parser/tokenizer.re"
	{ KW(BIND) }
#line 3802 "parser/tokenizer.cpp"
yy387:
	yych = *++cur;
	if (yych == 'K') goto yy547;
	if (yych == 'k') goto yy547;
	goto yy37;
yy388:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 290 "parser/tokenizer.re"
	{ KW(CALL) }
#line 3816 "parser/tokenizer.cpp"
yy389:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 291 "parser/tokenizer.re"
	{ KW(CASE) }
#line 3825 "parser/tokenizer.cpp"
yy390:
	yych = *++cur;
	if (yych == 'G') goto yy548;
	if (yych == 'g') goto yy548;
	goto yy37;
yy391:
	yych = *++cur;
	if (yych == 'A') goto yy549;
	if (yych == 'a') goto yy549;
	goto yy37;
yy392:
	yych = *++cur;
	if (yych == 'S') goto yy550;
	if (yych == 's') goto yy550;
	goto yy37;
yy393:
	yych = *++cur;
	if (yych == 'E') goto yy551;
	if (yych == 'e') goto yy551;
	goto yy37;
yy394:
	yych = *++cur;
	if (yych == 'M') goto yy552;
	if (yych == 'm') goto yy552;
	goto yy37;
yy395:
	yych = *++cur;
	if (yych == 'O') goto yy553;
	if (yych == 'o') goto yy553;
	goto yy37;
yy396:
	yych = *++cur;
	if (yych == 'L') goto yy554;
	if (yych == 'l') goto yy554;
	goto yy37;
yy397:
	yych = *++cur;
	if (yych == 'U') goto yy555;
	if (yych == 'u') goto yy555;
	goto yy37;
yy398:
	yych = *++cur;
	if (yych <= 'I') {
		if (yych == 'A') goto yy556;
		if (yych <= 'H') goto yy37;
		goto yy557;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy556;
		} else {
			if (yych == 'i') goto yy557;
			goto yy37;
		}
	}
yy399:
	yych = *++cur;
	if (yych == 'I') goto yy558;
	if (yych == 'i') goto yy558;
	goto yy37;
yy400:
	yych = *++cur;
	if (yych == 'E') goto yy559;
	if (yych == 'e') goto yy559;
	goto yy37;
yy401:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 306 "parser/tokenizer.re"
	{ KW(DATA) }
#line 3899 "parser/tokenizer.cpp"
yy402:
	yych = *++cur;
	if (yych == 'L') goto yy560;
	if (yych == 'l') goto yy560;
	goto yy37;
yy403:
	yych = *++cur;
	if (yych == 'U') goto yy561;
	if (yych == 'u') goto yy561;
	goto yy37;
yy404:
	yych = *++cur;
	if (yych == 'R') goto yy562;
	if (yych == 'r') goto yy562;
	goto yy37;
yy405:
	yych = *++cur;
	if (yych == 'N') goto yy563;
	if (yych == 'n') goto yy563;
	goto yy37;
yy406:
	yych = *++cur;
	if (yych <= '/') goto yy407;
	if (yych <= '9') goto yy406;
yy407:
	cur = ctxmar;
#line 311 "parser/tokenizer.re"
	{
                // This is a label do statement, we have to match the
                // corresponding continue base "end do".
                uint64_t n = parse_int(cur);
                enddo_label_stack.push_back(n);
                KW(DO);
            }
#line 3934 "parser/tokenizer.cpp"
yy408:
	yych = *++cur;
	if (yych == 'L') goto yy564;
	if (yych == 'l') goto yy564;
	goto yy37;
yy409:
	yych = *++cur;
	if (yych == 'I') goto yy565;
	if (yych == 'i') goto yy565;
	goto yy37;
yy410:
	yych = *++cur;
	if (yych == 'E') goto yy566;
	if (yych == 'e') goto yy566;
	goto yy37;
yy411:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'W') {
		if (yych <= '@') {
			if (yych <= '/') goto yy412;
			if (yych <= '9') goto yy36;
		} else {
			if (yych == 'I') goto yy567;
			if (yych <= 'V') goto yy36;
			goto yy568;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy36;
			if (yych <= '`') goto yy412;
			if (yych <= 'h') goto yy36;
			goto yy567;
		} else {
			if (yych == 'w') goto yy568;
			if (yych <= 'z') goto yy36;
		}
	}
yy412:
#line 324 "parser/tokenizer.re"
	{ KW(ELSE) }
#line 3978 "parser/tokenizer.cpp"
yy413:
	yych = *++cur;
yy414:
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy413;
		case 'A':
		case 'a': goto yy569;
		case 'B':
		case 'b': goto yy570;
		case 'C':
		case 'c': goto yy571;
		case 'D':
		case 'd': goto yy572;
		case 'E':
		case 'e': goto yy573;
		case 'F':
		case 'f': goto yy574;
		case 'I':
		case 'i': goto yy575;
		case 'M':
		case 'm': goto yy576;
		case 'P':
		case 'p': goto yy577;
		case 'S':
		case 's': goto yy578;
		case 'T':
		case 't': goto yy579;
		case 'W':
		case 'w': goto yy580;
		case '_': goto yy581;
		default: goto yy62;
	}
yy415:
	yych = *++cur;
	if (yych == 'F') goto yy582;
	if (yych == 'f') goto yy582;
	goto yy414;
yy416:
	yych = *++cur;
	if (yych == 'S') goto yy583;
	if (yych == 's') goto yy583;
	goto yy37;
yy417:
	yych = *++cur;
	if (yych == 'L') goto yy584;
	if (yych == 'l') goto yy584;
	goto yy37;
yy418:
	yych = *++cur;
	if (yych == 'R') goto yy585;
	if (yych == 'r') goto yy585;
	goto yy37;
yy419:
	yych = *++cur;
	if (yych == 'O') goto yy586;
	if (yych == 'o') goto yy586;
	goto yy37;
yy420:
	yych = *++cur;
	if (yych == 'N') goto yy587;
	if (yych == 'n') goto yy587;
	goto yy37;
yy421:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy588;
			goto yy37;
		} else {
			if (yych <= 'O') goto yy589;
			if (yych <= 'T') goto yy37;
			goto yy590;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy588;
			goto yy37;
		} else {
			if (yych <= 'o') goto yy589;
			if (yych == 'u') goto yy590;
			goto yy37;
		}
	}
yy422:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'F') goto yy591;
		if (yych <= 'M') goto yy37;
		goto yy592;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy37;
			goto yy591;
		} else {
			if (yych == 'n') goto yy592;
			goto yy37;
		}
	}
yy423:
	yych = *++cur;
	if (yych == 'O') goto yy593;
	if (yych == 'o') goto yy593;
	goto yy37;
yy424:
	yych = *++cur;
	if (yych == 'R') goto yy594;
	if (yych == 'r') goto yy594;
	goto yy37;
yy425:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'E') goto yy595;
		if (yych <= 'T') goto yy37;
		goto yy596;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy595;
		} else {
			if (yych == 'u') goto yy596;
			goto yy37;
		}
	}
yy426:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'E') goto yy597;
		if (yych <= 'X') goto yy37;
		goto yy598;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy597;
		} else {
			if (yych == 'y') goto yy598;
			goto yy37;
		}
	}
yy427:
	yych = *++cur;
	if (yych == 'H') goto yy599;
	if (yych == 'h') goto yy599;
	goto yy37;
yy428:
	yych = *++cur;
	if (yych == 'Y') goto yy600;
	if (yych == 'y') goto yy600;
	goto yy37;
yy429:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'E') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy430;
			if (yych <= 'D') goto yy36;
			goto yy601;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'e') goto yy601;
			if (yych <= 'z') goto yy36;
		}
	}
yy430:
#line 405 "parser/tokenizer.re"
	{ KW(ENUM) }
#line 4155 "parser/tokenizer.cpp"
yy431:
	yych = *++cur;
	if (yych == 'V') goto yy602;
	if (yych == 'v') goto yy602;
	goto yy37;
yy432:
	yych = *++cur;
	if (yych == 'S') goto yy603;
	if (yych == 's') goto yy603;
	goto yy37;
yy433:
	yych = *++cur;
	if (yych == 'R') goto yy604;
	if (yych == 'r') goto yy604;
	goto yy37;
yy434:
	yych = *++cur;
	if (yych == 'T') goto yy605;
	if (yych == 't') goto yy605;
	goto yy37;
yy435:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 411 "parser/tokenizer.re"
	{ KW(EXIT) }
#line 4184 "parser/tokenizer.cpp"
yy436:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy606;
		if (yych <= 'Q') goto yy37;
		goto yy607;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy606;
		} else {
			if (yych == 'r') goto yy607;
			goto yy37;
		}
	}
yy437:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 414 "parser/tokenizer.re"
	{ KW(FILE) }
#line 4208 "parser/tokenizer.cpp"
yy438:
	yych = *++cur;
	if (yych == 'L') goto yy608;
	if (yych == 'l') goto yy608;
	goto yy37;
yy439:
	yych = *++cur;
	if (yych == 'H') goto yy609;
	if (yych == 'h') goto yy609;
	goto yy37;
yy440:
	yych = *++cur;
	if (yych == 'L') goto yy610;
	if (yych == 'l') goto yy610;
	goto yy37;
yy441:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'T') {
		if (yych <= '@') {
			if (yych <= '/') goto yy442;
			if (yych <= '9') goto yy36;
		} else {
			if (yych <= 'A') goto yy611;
			if (yych <= 'S') goto yy36;
			goto yy612;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy611;
		} else {
			if (yych == 't') goto yy612;
			if (yych <= 'z') goto yy36;
		}
	}
yy442:
#line 431 "parser/tokenizer.re"
	{ KW(FORM) }
#line 4250 "parser/tokenizer.cpp"
yy443:
	yych = *++cur;
	if (yych == 'T') goto yy613;
	if (yych == 't') goto yy613;
	goto yy37;
yy444:
	yych = *++cur;
	if (yych == 'R') goto yy614;
	if (yych == 'r') goto yy614;
	goto yy37;
yy445:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 436 "parser/tokenizer.re"
	{ KW(GOTO) }
#line 4269 "parser/tokenizer.cpp"
yy446:
	yych = *++cur;
	if (yych == 'E') goto yy615;
	if (yych == 'e') goto yy615;
	goto yy37;
yy447:
	yych = *++cur;
	if (yych == 'I') goto yy616;
	if (yych == 'i') goto yy616;
	goto yy37;
yy448:
	yych = *++cur;
	if (yych == 'R') goto yy617;
	if (yych == 'r') goto yy617;
	goto yy37;
yy449:
	yych = *++cur;
	if (yych == 'R') goto yy618;
	if (yych == 'r') goto yy618;
	goto yy37;
yy450:
	yych = *++cur;
	if (yych == 'U') goto yy619;
	if (yych == 'u') goto yy619;
	goto yy62;
yy451:
	yych = *++cur;
	if (yych == 'U') goto yy620;
	if (yych == 'u') goto yy620;
	goto yy37;
yy452:
	yych = *++cur;
	if (yych == 'T') goto yy621;
	if (yych == 't') goto yy621;
	goto yy37;
yy453:
	yych = *++cur;
	if (yych == 'I') goto yy622;
	if (yych == 'i') goto yy622;
	goto yy37;
yy454:
	yych = *++cur;
	if (yych == 'A') goto yy623;
	if (yych == 'a') goto yy623;
	goto yy37;
yy455:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych <= 'M') {
			if (yych == 'G') goto yy624;
			goto yy37;
		} else {
			if (yych <= 'N') goto yy625;
			if (yych <= 'Q') goto yy37;
			goto yy626;
		}
	} else {
		if (yych <= 'm') {
			if (yych == 'g') goto yy624;
			goto yy37;
		} else {
			if (yych <= 'n') goto yy625;
			if (yych == 'r') goto yy626;
			goto yy37;
		}
	}
yy456:
	yych = *++cur;
	if (yych == 'I') goto yy627;
	if (yych == 'i') goto yy627;
	goto yy37;
yy457:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 453 "parser/tokenizer.re"
	{ KW(KIND) }
#line 4349 "parser/tokenizer.cpp"
yy458:
	yych = *++cur;
	if (yych == 'L') goto yy628;
	if (yych == 'l') goto yy628;
	goto yy37;
yy459:
	yych = *++cur;
	if (yych == 'C') goto yy629;
	if (yych == 'c') goto yy629;
	goto yy37;
yy460:
	yych = *++cur;
	if (yych == 'R') goto yy630;
	if (yych == 'r') goto yy630;
	goto yy37;
yy461:
	yych = *++cur;
	if (yych == 'L') goto yy631;
	if (yych == 'l') goto yy631;
	goto yy37;
yy462:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 460 "parser/tokenizer.re"
	{ KW(MOLD) }
#line 4378 "parser/tokenizer.cpp"
yy463:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'L') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy464;
			if (yych <= 'K') goto yy36;
			goto yy632;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'l') goto yy632;
			if (yych <= 'z') goto yy36;
		}
	}
yy464:
#line 461 "parser/tokenizer.re"
	{ KW(NAME) }
#line 4404 "parser/tokenizer.cpp"
yy465:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy66;
		if (yych <= '&') goto yy37;
		goto yy83;
	} else {
		if (yych <= 'I') {
			if (yych <= 'H') goto yy37;
			goto yy633;
		} else {
			if (yych == 'i') goto yy633;
			goto yy37;
		}
	}
yy466:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 468 "parser/tokenizer.re"
	{ KW(NONE) }
#line 4429 "parser/tokenizer.cpp"
yy467:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'O') {
		if (yych <= '\'') {
			if (yych == '"') goto yy66;
			if (yych <= '&') goto yy37;
			goto yy83;
		} else {
			if (yych == 'I') goto yy634;
			if (yych <= 'N') goto yy37;
			goto yy635;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'R') goto yy636;
			if (yych <= 'h') goto yy37;
			goto yy634;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy37;
				goto yy635;
			} else {
				if (yych == 'r') goto yy636;
				goto yy37;
			}
		}
	}
yy468:
	yych = *++cur;
	if (yych == 'S') goto yy637;
	if (yych == 's') goto yy637;
	goto yy37;
yy469:
	yych = *++cur;
	if (yych == 'I') goto yy638;
	if (yych == 'i') goto yy638;
	goto yy37;
yy470:
	++cur;
#line 674 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4472 "parser/tokenizer.cpp"
yy471:
	++cur;
#line 675 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4477 "parser/tokenizer.cpp"
yy472:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 470 "parser/tokenizer.re"
	{ KW(ONLY) }
#line 4486 "parser/tokenizer.cpp"
yy473:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 471 "parser/tokenizer.re"
	{ KW(OPEN) }
#line 4495 "parser/tokenizer.cpp"
yy474:
	yych = *++cur;
	if (yych == 'A') goto yy639;
	if (yych == 'a') goto yy639;
	goto yy37;
yy475:
	yych = *++cur;
	if (yych == 'O') goto yy640;
	if (yych == 'o') goto yy640;
	goto yy37;
yy476:
	yych = *++cur;
	if (yych == 'M') goto yy641;
	if (yych == 'm') goto yy641;
	goto yy37;
yy477:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 476 "parser/tokenizer.re"
	{ KW(PASS) }
#line 4519 "parser/tokenizer.cpp"
yy478:
	yych = *++cur;
	if (yych == 'T') goto yy642;
	if (yych == 't') goto yy642;
	goto yy37;
yy479:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 478 "parser/tokenizer.re"
	{ KW(POST) }
#line 4533 "parser/tokenizer.cpp"
yy480:
	yych = *++cur;
	if (yych == 'I') goto yy643;
	if (yych == 'i') goto yy643;
	goto yy37;
yy481:
	yych = *++cur;
	if (yych == 'T') goto yy644;
	if (yych == 't') goto yy644;
	goto yy37;
yy482:
	yych = *++cur;
	if (yych == 'A') goto yy645;
	if (yych == 'a') goto yy645;
	goto yy37;
yy483:
	yych = *++cur;
	if (yych == 'E') goto yy646;
	if (yych == 'e') goto yy646;
	goto yy37;
yy484:
	yych = *++cur;
	if (yych == 'R') goto yy647;
	if (yych == 'r') goto yy647;
	goto yy37;
yy485:
	yych = *++cur;
	if (yych == 'E') goto yy648;
	if (yych == 'e') goto yy648;
	goto yy37;
yy486:
	yych = *++cur;
	if (yych == 'I') goto yy649;
	if (yych == 'i') goto yy649;
	goto yy37;
yy487:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 486 "parser/tokenizer.re"
	{ KW(PURE) }
#line 4577 "parser/tokenizer.cpp"
yy488:
	yych = *++cur;
	if (yych == 'T') goto yy650;
	if (yych == 't') goto yy650;
	goto yy37;
yy489:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 488 "parser/tokenizer.re"
	{ KW(RANK) }
#line 4591 "parser/tokenizer.cpp"
yy490:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 489 "parser/tokenizer.re"
	{ KW(READ) }
#line 4600 "parser/tokenizer.cpp"
yy491:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 490 "parser/tokenizer.re"
	{KW(REAL) }
#line 4609 "parser/tokenizer.cpp"
yy492:
	yych = *++cur;
	if (yych == 'R') goto yy651;
	if (yych == 'r') goto yy651;
	goto yy37;
yy493:
	yych = *++cur;
	if (yych == 'C') goto yy652;
	if (yych == 'c') goto yy652;
	goto yy37;
yy494:
	yych = *++cur;
	if (yych == 'I') goto yy653;
	if (yych == 'i') goto yy653;
	goto yy37;
yy495:
	yych = *++cur;
	if (yych == 'L') goto yy654;
	if (yych == 'l') goto yy654;
	goto yy37;
yy496:
	yych = *++cur;
	if (yych == 'R') goto yy655;
	if (yych == 'r') goto yy655;
	goto yy37;
yy497:
	yych = *++cur;
	if (yych == 'N') goto yy656;
	if (yych == 'n') goto yy656;
	goto yy37;
yy498:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 498 "parser/tokenizer.re"
	{ KW(SAVE) }
#line 4648 "parser/tokenizer.cpp"
yy499:
	yych = *++cur;
	if (yych == 'C') goto yy657;
	if (yych == 'c') goto yy657;
	goto yy37;
yy500:
	yych = *++cur;
	if (yych == 'E') goto yy658;
	if (yych == 'e') goto yy658;
	goto yy37;
yy501:
	yych = *++cur;
	if (yych == 'E') goto yy659;
	if (yych == 'e') goto yy659;
	goto yy37;
yy502:
	yych = *++cur;
	if (yych == 'C') goto yy660;
	if (yych == 'c') goto yy660;
	goto yy37;
yy503:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 506 "parser/tokenizer.re"
	{ KW(STAT) }
#line 4677 "parser/tokenizer.cpp"
yy504:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 507 "parser/tokenizer.re"
	{ KW(STOP) }
#line 4686 "parser/tokenizer.cpp"
yy505:
	yych = *++cur;
	if (yych == 'O') goto yy661;
	if (yych == 'o') goto yy661;
	goto yy37;
yy506:
	yych = *++cur;
	if (yych == 'O') goto yy662;
	if (yych == 'o') goto yy662;
	goto yy37;
yy507:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'T') {
		if (yych <= 'H') {
			if (yych <= '9') {
				if (yych >= '0') goto yy36;
			} else {
				if (yych <= '@') goto yy508;
				if (yych <= 'A') goto yy663;
				goto yy36;
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'I') goto yy664;
				goto yy36;
			} else {
				if (yych <= 'M') goto yy665;
				if (yych <= 'S') goto yy36;
				goto yy666;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy36;
			} else {
				if (yych <= 'a') goto yy663;
				if (yych <= 'h') goto yy36;
				goto yy664;
			}
		} else {
			if (yych <= 's') {
				if (yych == 'm') goto yy665;
				goto yy36;
			} else {
				if (yych <= 't') goto yy666;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy508:
#line 510 "parser/tokenizer.re"
	{ KW(SYNC) }
#line 4743 "parser/tokenizer.cpp"
yy509:
	yych = *++cur;
	if (yych == 'E') goto yy667;
	if (yych == 'e') goto yy667;
	goto yy37;
yy510:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy668;
#line 516 "parser/tokenizer.re"
	{ KW(TEAM) }
#line 4757 "parser/tokenizer.cpp"
yy511:
	yych = *++cur;
	if (yych == 'L') goto yy669;
	if (yych == 'l') goto yy669;
	goto yy37;
yy512:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 519 "parser/tokenizer.re"
	{ KW(THEN) }
#line 4771 "parser/tokenizer.cpp"
yy513:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 521 "parser/tokenizer.re"
	{ KW(TYPE) }
#line 4780 "parser/tokenizer.cpp"
yy514:
	yych = *++cur;
	if (yych == 'R') goto yy670;
	if (yych == 'r') goto yy670;
	goto yy37;
yy515:
	yych = *++cur;
	if (yych == 'E') goto yy671;
	if (yych == 'e') goto yy671;
	goto yy37;
yy516:
	yych = *++cur;
	if (yych == 'T') goto yy672;
	if (yych == 't') goto yy672;
	goto yy37;
yy517:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 526 "parser/tokenizer.re"
	{ KW(WAIT) }
#line 4804 "parser/tokenizer.cpp"
yy518:
	yych = *++cur;
	if (yych == 'E') goto yy673;
	if (yych == 'e') goto yy673;
	goto yy37;
yy519:
	yych = *++cur;
	if (yych == 'E') goto yy674;
	if (yych == 'e') goto yy674;
	goto yy37;
yy520:
	yych = *++cur;
	if (yych == 'E') goto yy675;
	if (yych == 'e') goto yy675;
	goto yy37;
yy521:
	++cur;
#line 676 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4824 "parser/tokenizer.cpp"
yy522:
	++cur;
#line 677 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4829 "parser/tokenizer.cpp"
yy523:
	yych = *++cur;
	if (yych == 'R') goto yy676;
	if (yych == 'r') goto yy676;
	goto yy37;
yy524:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy679;
		if (yych <= '\n') goto yy678;
		goto yy679;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy678;
			goto yy679;
		} else {
			if (yych == ' ') goto yy679;
			goto yy678;
		}
	}
yy525:
	++cur;
	cur -= 1;
#line 695 "parser/tokenizer.re"
	{ TK_TRIVIA(TK_PRAGMA_DECL) }
#line 4855 "parser/tokenizer.cpp"
yy526:
	yych = *++cur;
	if (yych == 'n') goto yy681;
	goto yy70;
yy527:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy682;
		if (yych <= '\n') goto yy70;
		goto yy682;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy70;
			goto yy682;
		} else {
			if (yych == ' ') goto yy682;
			goto yy70;
		}
	}
yy528:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy62;
			goto yy69;
		} else {
			if (yych == '\n') goto yy683;
			goto yy528;
		}
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy69;
			goto yy528;
		} else {
			if (yych == ' ') goto yy528;
			goto yy69;
		}
	}
yy529:
	yych = *++cur;
	if (yych == 'f') goto yy684;
	goto yy70;
yy530:
	yych = *++cur;
	if (yych == 'f') goto yy685;
	goto yy70;
yy531:
	yych = *++cur;
	if (yych == 'u') goto yy686;
	goto yy70;
yy532:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy687;
		if (yych <= '\n') goto yy70;
		goto yy687;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy70;
			goto yy687;
		} else {
			if (yych == ' ') goto yy687;
			goto yy70;
		}
	}
yy533:
	++cur;
	cur = ctxmar;
#line 560 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 4926 "parser/tokenizer.cpp"
yy534:
	++cur;
#line 608 "parser/tokenizer.re"
	{ RET(TK_AND) }
#line 4931 "parser/tokenizer.cpp"
yy535:
	++cur;
#line 611 "parser/tokenizer.re"
	{ RET(TK_EQV) }
#line 4936 "parser/tokenizer.cpp"
yy536:
	yych = *++cur;
	if (yych == 'E') goto yy688;
	if (yych == 'e') goto yy688;
	goto yy94;
yy537:
	yych = *++cur;
	if (yych == '.') goto yy689;
	goto yy94;
yy538:
	++cur;
#line 607 "parser/tokenizer.re"
	{ RET(TK_NOT) }
#line 4950 "parser/tokenizer.cpp"
yy539:
	yych = *++cur;
	if (yych == '.') goto yy690;
	goto yy94;
yy540:
	++cur;
#line 610 "parser/tokenizer.re"
	{ RET(TK_XOR) }
#line 4959 "parser/tokenizer.cpp"
yy541:
	yych = *++cur;
	if (yych == 'A') goto yy692;
	if (yych == 'a') goto yy692;
	goto yy37;
yy542:
	yych = *++cur;
	if (yych == 'A') goto yy693;
	if (yych == 'a') goto yy693;
	goto yy37;
yy543:
	yych = *++cur;
	if (yych == 'N') goto yy694;
	if (yych == 'n') goto yy694;
	goto yy37;
yy544:
	yych = *++cur;
	if (yych == 'I') goto yy696;
	if (yych == 'i') goto yy696;
	goto yy37;
yy545:
	yych = *++cur;
	if (yych == 'H') goto yy697;
	if (yych == 'h') goto yy697;
	goto yy37;
yy546:
	yych = *++cur;
	if (yych == 'P') goto yy698;
	if (yych == 'p') goto yy698;
	goto yy37;
yy547:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 289 "parser/tokenizer.re"
	{ KW(BLOCK) }
#line 4998 "parser/tokenizer.cpp"
yy548:
	yych = *++cur;
	if (yych == 'E') goto yy699;
	if (yych == 'e') goto yy699;
	goto yy37;
yy549:
	yych = *++cur;
	if (yych == 'C') goto yy701;
	if (yych == 'c') goto yy701;
	goto yy37;
yy550:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 295 "parser/tokenizer.re"
	{ KW(CLASS) }
#line 5017 "parser/tokenizer.cpp"
yy551:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 296 "parser/tokenizer.re"
	{ KW(CLOSE) }
#line 5026 "parser/tokenizer.cpp"
yy552:
	yych = *++cur;
	if (yych == 'E') goto yy702;
	if (yych == 'e') goto yy702;
	goto yy37;
yy553:
	yych = *++cur;
	if (yych == 'N') goto yy703;
	if (yych == 'n') goto yy703;
	goto yy37;
yy554:
	yych = *++cur;
	if (yych == 'E') goto yy704;
	if (yych == 'e') goto yy704;
	goto yy37;
yy555:
	yych = *++cur;
	if (yych == 'R') goto yy705;
	if (yych == 'r') goto yy705;
	goto yy37;
yy556:
	yych = *++cur;
	if (yych == 'I') goto yy706;
	if (yych == 'i') goto yy706;
	goto yy37;
yy557:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'G') goto yy707;
		if (yych <= 'M') goto yy37;
		goto yy708;
	} else {
		if (yych <= 'g') {
			if (yych <= 'f') goto yy37;
			goto yy707;
		} else {
			if (yych == 'n') goto yy708;
			goto yy37;
		}
	}
yy558:
	yych = *++cur;
	if (yych == 'C') goto yy709;
	if (yych == 'c') goto yy709;
	goto yy37;
yy559:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 305 "parser/tokenizer.re"
	{ KW(CYCLE) }
#line 5080 "parser/tokenizer.cpp"
yy560:
	yych = *++cur;
	if (yych == 'O') goto yy710;
	if (yych == 'o') goto yy710;
	goto yy37;
yy561:
	yych = *++cur;
	if (yych == 'L') goto yy711;
	if (yych == 'l') goto yy711;
	goto yy37;
yy562:
	yych = *++cur;
	if (yych == 'R') goto yy712;
	if (yych == 'r') goto yy712;
	goto yy37;
yy563:
	yych = *++cur;
	if (yych == 'S') goto yy713;
	if (yych == 's') goto yy713;
	goto yy37;
yy564:
	yych = *++cur;
	if (yych == 'E') goto yy714;
	if (yych == 'e') goto yy714;
	goto yy37;
yy565:
	yych = *++cur;
	if (yych == 'L') goto yy716;
	if (yych == 'l') goto yy716;
	goto yy37;
yy566:
	yych = *++cur;
	if (yych == 'N') goto yy717;
	if (yych == 'n') goto yy717;
	goto yy37;
yy567:
	yych = *++cur;
	if (yych == 'F') goto yy718;
	if (yych == 'f') goto yy718;
	goto yy37;
yy568:
	yych = *++cur;
	if (yych == 'H') goto yy719;
	if (yych == 'h') goto yy719;
	goto yy37;
yy569:
	yych = *++cur;
	if (yych == 'S') goto yy720;
	if (yych == 's') goto yy720;
	goto yy62;
yy570:
	yych = *++cur;
	if (yych == 'L') goto yy721;
	if (yych == 'l') goto yy721;
	goto yy62;
yy571:
	yych = *++cur;
	if (yych == 'R') goto yy722;
	if (yych == 'r') goto yy722;
	goto yy62;
yy572:
	yych = *++cur;
	if (yych == 'O') goto yy723;
	if (yych == 'o') goto yy723;
	goto yy62;
yy573:
	yych = *++cur;
	if (yych == 'N') goto yy724;
	if (yych == 'n') goto yy724;
	goto yy62;
yy574:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'O') goto yy725;
		if (yych <= 'T') goto yy62;
		goto yy726;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy62;
			goto yy725;
		} else {
			if (yych == 'u') goto yy726;
			goto yy62;
		}
	}
yy575:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'F') goto yy727;
		if (yych <= 'M') goto yy62;
		goto yy728;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy62;
			goto yy727;
		} else {
			if (yych == 'n') goto yy728;
			goto yy62;
		}
	}
yy576:
	yych = *++cur;
	if (yych == 'O') goto yy729;
	if (yych == 'o') goto yy729;
	goto yy62;
yy577:
	yych = *++cur;
	if (yych == 'R') goto yy730;
	if (yych == 'r') goto yy730;
	goto yy62;
yy578:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'E') goto yy731;
		if (yych <= 'T') goto yy62;
		goto yy732;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy62;
			goto yy731;
		} else {
			if (yych == 'u') goto yy732;
			goto yy62;
		}
	}
yy579:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'E') goto yy733;
		if (yych <= 'X') goto yy62;
		goto yy734;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy62;
			goto yy733;
		} else {
			if (yych == 'y') goto yy734;
			goto yy62;
		}
	}
yy580:
	yych = *++cur;
	if (yych == 'H') goto yy735;
	if (yych == 'h') goto yy735;
	goto yy62;
yy581:
	yych = *++cur;
	if (yych == 'L') goto yy736;
	if (yych == 'l') goto yy736;
	goto yy62;
yy582:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy737;
			goto yy62;
		} else {
			if (yych <= 'O') goto yy725;
			if (yych <= 'T') goto yy62;
			goto yy726;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy737;
			goto yy62;
		} else {
			if (yych <= 'o') goto yy725;
			if (yych == 'u') goto yy726;
			goto yy62;
		}
	}
yy583:
	yych = *++cur;
	if (yych == 'S') goto yy738;
	if (yych == 's') goto yy738;
	goto yy37;
yy584:
	yych = *++cur;
	if (yych == 'O') goto yy739;
	if (yych == 'o') goto yy739;
	goto yy37;
yy585:
	yych = *++cur;
	if (yych == 'I') goto yy740;
	if (yych == 'i') goto yy740;
	goto yy37;
yy586:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 390 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    KW(CONTINUE)
                } else {
                    KW(ENDDO)
                }
            }
#line 5281 "parser/tokenizer.cpp"
yy587:
	yych = *++cur;
	if (yych == 'U') goto yy741;
	if (yych == 'u') goto yy741;
	goto yy37;
yy588:
	yych = *++cur;
	if (yych == 'L') goto yy742;
	if (yych == 'l') goto yy742;
	goto yy37;
yy589:
	yych = *++cur;
	if (yych == 'R') goto yy743;
	if (yych == 'r') goto yy743;
	goto yy37;
yy590:
	yych = *++cur;
	if (yych == 'N') goto yy744;
	if (yych == 'n') goto yy744;
	goto yy37;
yy591:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 375 "parser/tokenizer.re"
	{ KW(ENDIF) }
#line 5310 "parser/tokenizer.cpp"
yy592:
	yych = *++cur;
	if (yych == 'T') goto yy745;
	if (yych == 't') goto yy745;
	goto yy37;
yy593:
	yych = *++cur;
	if (yych == 'D') goto yy746;
	if (yych == 'd') goto yy746;
	goto yy37;
yy594:
	yych = *++cur;
	if (yych == 'O') goto yy747;
	if (yych == 'o') goto yy747;
	goto yy37;
yy595:
	yych = *++cur;
	if (yych == 'L') goto yy748;
	if (yych == 'l') goto yy748;
	goto yy37;
yy596:
	yych = *++cur;
	if (yych == 'B') goto yy749;
	if (yych == 'b') goto yy749;
	goto yy37;
yy597:
	yych = *++cur;
	if (yych == 'A') goto yy750;
	if (yych == 'a') goto yy750;
	goto yy37;
yy598:
	yych = *++cur;
	if (yych == 'P') goto yy751;
	if (yych == 'p') goto yy751;
	goto yy37;
yy599:
	yych = *++cur;
	if (yych == 'E') goto yy752;
	if (yych == 'e') goto yy752;
	goto yy37;
yy600:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 404 "parser/tokenizer.re"
	{ KW(ENTRY) }
#line 5359 "parser/tokenizer.cpp"
yy601:
	yych = *++cur;
	if (yych == 'R') goto yy753;
	if (yych == 'r') goto yy753;
	goto yy37;
yy602:
	yych = *++cur;
	if (yych == 'A') goto yy754;
	if (yych == 'a') goto yy754;
	goto yy37;
yy603:
	yych = *++cur;
	if (yych == 'G') goto yy755;
	if (yych == 'g') goto yy755;
	goto yy37;
yy604:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 409 "parser/tokenizer.re"
	{ KW(ERROR) }
#line 5383 "parser/tokenizer.cpp"
yy605:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 410 "parser/tokenizer.re"
	{ KW(EVENT) }
#line 5392 "parser/tokenizer.cpp"
yy606:
	yych = *++cur;
	if (yych == 'D') goto yy756;
	if (yych == 'd') goto yy756;
	goto yy37;
yy607:
	yych = *++cur;
	if (yych == 'N') goto yy757;
	if (yych == 'n') goto yy757;
	goto yy37;
yy608:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 415 "parser/tokenizer.re"
	{ KW(FINAL) }
#line 5411 "parser/tokenizer.cpp"
yy609:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 416 "parser/tokenizer.re"
	{ KW(FLUSH) }
#line 5420 "parser/tokenizer.cpp"
yy610:
	yych = *++cur;
	if (yych == 'L') goto yy758;
	if (yych == 'l') goto yy758;
	goto yy37;
yy611:
	yych = *++cur;
	if (yych == 'T') goto yy759;
	if (yych == 't') goto yy759;
	goto yy37;
yy612:
	yych = *++cur;
	if (yych == 'E') goto yy761;
	if (yych == 'e') goto yy761;
	goto yy37;
yy613:
	yych = *++cur;
	if (yych == 'I') goto yy762;
	if (yych == 'i') goto yy762;
	goto yy37;
yy614:
	yych = *++cur;
	if (yych == 'I') goto yy763;
	if (yych == 'i') goto yy763;
	goto yy37;
yy615:
	yych = *++cur;
	if (yych == 'S') goto yy764;
	if (yych == 's') goto yy764;
	goto yy37;
yy616:
	yych = *++cur;
	if (yych == 'C') goto yy765;
	if (yych == 'c') goto yy765;
	goto yy37;
yy617:
	yych = *++cur;
	if (yych == 'T') goto yy766;
	if (yych == 't') goto yy766;
	goto yy37;
yy618:
	yych = *++cur;
	if (yych == 'E') goto yy767;
	if (yych == 'e') goto yy767;
	goto yy37;
yy619:
	yych = *++cur;
	if (yych == 'T') goto yy768;
	if (yych == 't') goto yy768;
	goto yy62;
yy620:
	yych = *++cur;
	if (yych == 'D') goto yy769;
	if (yych == 'd') goto yy769;
	goto yy37;
yy621:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 444 "parser/tokenizer.re"
	{ KW(INOUT) }
#line 5484 "parser/tokenizer.cpp"
yy622:
	yych = *++cur;
	if (yych == 'R') goto yy770;
	if (yych == 'r') goto yy770;
	goto yy37;
yy623:
	yych = *++cur;
	if (yych == 'N') goto yy771;
	if (yych == 'n') goto yy771;
	goto yy37;
yy624:
	yych = *++cur;
	if (yych == 'E') goto yy772;
	if (yych == 'e') goto yy772;
	goto yy37;
yy625:
	yych = *++cur;
	if (yych == 'T') goto yy773;
	if (yych == 't') goto yy773;
	goto yy37;
yy626:
	yych = *++cur;
	if (yych == 'F') goto yy774;
	if (yych == 'f') goto yy774;
	goto yy37;
yy627:
	yych = *++cur;
	if (yych == 'N') goto yy775;
	if (yych == 'n') goto yy775;
	goto yy37;
yy628:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy776;
#line 455 "parser/tokenizer.re"
	{ KW(LOCAL) }
#line 5523 "parser/tokenizer.cpp"
yy629:
	yych = *++cur;
	if (yych == 'A') goto yy777;
	if (yych == 'a') goto yy777;
	goto yy37;
yy630:
	yych = *++cur;
	if (yych == 'Y') goto yy778;
	if (yych == 'y') goto yy778;
	goto yy37;
yy631:
	yych = *++cur;
	if (yych == 'E') goto yy779;
	if (yych == 'e') goto yy779;
	goto yy37;
yy632:
	yych = *++cur;
	if (yych == 'I') goto yy780;
	if (yych == 'i') goto yy780;
	goto yy37;
yy633:
	yych = *++cur;
	if (yych == 'N') goto yy781;
	if (yych == 'n') goto yy781;
	goto yy37;
yy634:
	yych = *++cur;
	if (yych == 'N') goto yy782;
	if (yych == 'n') goto yy782;
	goto yy37;
yy635:
	yych = *++cur;
	if (yych == 'V') goto yy783;
	if (yych == 'v') goto yy783;
	goto yy37;
yy636:
	yych = *++cur;
	if (yych == 'E') goto yy784;
	if (yych == 'e') goto yy784;
	goto yy37;
yy637:
	yych = *++cur;
	if (yych == 'S') goto yy785;
	if (yych == 's') goto yy785;
	goto yy37;
yy638:
	yych = *++cur;
	if (yych == 'F') goto yy786;
	if (yych == 'f') goto yy786;
	goto yy37;
yy639:
	yych = *++cur;
	if (yych == 'T') goto yy787;
	if (yych == 't') goto yy787;
	goto yy37;
yy640:
	yych = *++cur;
	if (yych == 'N') goto yy788;
	if (yych == 'n') goto yy788;
	goto yy37;
yy641:
	yych = *++cur;
	if (yych == 'E') goto yy789;
	if (yych == 'e') goto yy789;
	goto yy37;
yy642:
	yych = *++cur;
	if (yych == 'E') goto yy790;
	if (yych == 'e') goto yy790;
	goto yy37;
yy643:
	yych = *++cur;
	if (yych == 'S') goto yy791;
	if (yych == 's') goto yy791;
	goto yy37;
yy644:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 480 "parser/tokenizer.re"
	{ KW(PRINT) }
#line 5607 "parser/tokenizer.cpp"
yy645:
	yych = *++cur;
	if (yych == 'T') goto yy792;
	if (yych == 't') goto yy792;
	goto yy37;
yy646:
	yych = *++cur;
	if (yych == 'D') goto yy793;
	if (yych == 'd') goto yy793;
	goto yy37;
yy647:
	yych = *++cur;
	if (yych == 'A') goto yy794;
	if (yych == 'a') goto yy794;
	goto yy37;
yy648:
	yych = *++cur;
	if (yych == 'C') goto yy795;
	if (yych == 'c') goto yy795;
	goto yy37;
yy649:
	yych = *++cur;
	if (yych == 'C') goto yy796;
	if (yych == 'c') goto yy796;
	goto yy37;
yy650:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 487 "parser/tokenizer.re"
	{ KW(QUIET) }
#line 5641 "parser/tokenizer.cpp"
yy651:
	yych = *++cur;
	if (yych == 'S') goto yy797;
	if (yych == 's') goto yy797;
	goto yy37;
yy652:
	yych = *++cur;
	if (yych == 'E') goto yy798;
	if (yych == 'e') goto yy798;
	goto yy37;
yy653:
	yych = *++cur;
	if (yych == 'R') goto yy799;
	if (yych == 'r') goto yy799;
	goto yy37;
yy654:
	yych = *++cur;
	if (yych == 'T') goto yy800;
	if (yych == 't') goto yy800;
	goto yy37;
yy655:
	yych = *++cur;
	if (yych == 'N') goto yy801;
	if (yych == 'n') goto yy801;
	goto yy37;
yy656:
	yych = *++cur;
	if (yych == 'D') goto yy802;
	if (yych == 'd') goto yy802;
	goto yy37;
yy657:
	yych = *++cur;
	if (yych == 'T') goto yy803;
	if (yych == 't') goto yy803;
	goto yy37;
yy658:
	yych = *++cur;
	if (yych == 'N') goto yy805;
	if (yych == 'n') goto yy805;
	goto yy37;
yy659:
	yych = *++cur;
	if (yych == 'D') goto yy806;
	if (yych == 'd') goto yy806;
	goto yy37;
yy660:
	yych = *++cur;
	if (yych == 'E') goto yy807;
	if (yych == 'e') goto yy807;
	goto yy37;
yy661:
	yych = *++cur;
	if (yych == 'D') goto yy808;
	if (yych == 'd') goto yy808;
	goto yy37;
yy662:
	yych = *++cur;
	if (yych == 'U') goto yy809;
	if (yych == 'u') goto yy809;
	goto yy37;
yy663:
	yych = *++cur;
	if (yych == 'L') goto yy810;
	if (yych == 'l') goto yy810;
	goto yy37;
yy664:
	yych = *++cur;
	if (yych == 'M') goto yy811;
	if (yych == 'm') goto yy811;
	goto yy37;
yy665:
	yych = *++cur;
	if (yych == 'E') goto yy812;
	if (yych == 'e') goto yy812;
	goto yy37;
yy666:
	yych = *++cur;
	if (yych == 'E') goto yy813;
	if (yych == 'e') goto yy813;
	goto yy37;
yy667:
	yych = *++cur;
	if (yych == 'T') goto yy814;
	if (yych == 't') goto yy814;
	goto yy37;
yy668:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy66;
		if (yych <= '&') goto yy37;
		goto yy83;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy37;
			goto yy815;
		} else {
			if (yych == 'n') goto yy815;
			goto yy37;
		}
	}
yy669:
	yych = *++cur;
	if (yych == 'A') goto yy816;
	if (yych == 'a') goto yy816;
	goto yy37;
yy670:
	yych = *++cur;
	if (yych == 'M') goto yy817;
	if (yych == 'm') goto yy817;
	goto yy37;
yy671:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 524 "parser/tokenizer.re"
	{ KW(VALUE) }
#line 5761 "parser/tokenizer.cpp"
yy672:
	yych = *++cur;
	if (yych == 'I') goto yy818;
	if (yych == 'i') goto yy818;
	goto yy37;
yy673:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 527 "parser/tokenizer.re"
	{ KW(WHERE) }
#line 5775 "parser/tokenizer.cpp"
yy674:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 528 "parser/tokenizer.re"
	{ KW(WHILE) }
#line 5784 "parser/tokenizer.cpp"
yy675:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 529 "parser/tokenizer.re"
	{ KW(WRITE) }
#line 5793 "parser/tokenizer.cpp"
yy676:
	yych = *++cur;
	if (yych == 'T') goto yy819;
	if (yych == 't') goto yy819;
	goto yy37;
yy677:
	yych = *++cur;
yy678:
	if (yych <= 0x00) goto yy62;
	if (yych == '\n') goto yy680;
	goto yy677;
yy679:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy62;
			if (yych <= 0x08) goto yy677;
			goto yy679;
		} else {
			if (yych <= '\n') goto yy680;
			if (yych == '\f') goto yy677;
			goto yy679;
		}
	} else {
		if (yych <= 'D') {
			if (yych == ' ') goto yy679;
			goto yy677;
		} else {
			if (yych <= 'E') goto yy820;
			if (yych == 'e') goto yy820;
			goto yy677;
		}
	}
yy680:
	++cur;
	cur -= 1;
#line 689 "parser/tokenizer.re"
	{
                if (!openmp_enabled) {
                    TK_TRIVIA(TK_COMMENT)
                }
                TK_TRIVIA(TK_OMP)
            }
#line 5837 "parser/tokenizer.cpp"
yy681:
	yych = *++cur;
	if (yych == 'e') goto yy821;
	goto yy70;
yy682:
	yych = *++cur;
	if (yych <= 0x00) goto yy62;
	if (yych == '\n') goto yy822;
	goto yy682;
yy683:
	++cur;
#line 725 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#else ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 5857 "parser/tokenizer.cpp"
yy684:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy62;
			goto yy69;
		} else {
			if (yych == '\n') goto yy823;
			goto yy684;
		}
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy69;
			goto yy684;
		} else {
			if (yych == ' ') goto yy684;
			goto yy69;
		}
	}
yy685:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy824;
		if (yych <= '\n') goto yy70;
		goto yy824;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy70;
			goto yy824;
		} else {
			if (yych == ' ') goto yy824;
			goto yy70;
		}
	}
yy686:
	yych = *++cur;
	if (yych == 'd') goto yy825;
	goto yy70;
yy687:
	yych = *++cur;
	if (yych <= 0x00) goto yy62;
	if (yych == '\n') goto yy826;
	goto yy687;
yy688:
	yych = *++cur;
	if (yych == '.') goto yy827;
	goto yy94;
yy689:
	++cur;
#line 612 "parser/tokenizer.re"
	{ RET(TK_NEQV) }
#line 5909 "parser/tokenizer.cpp"
yy690:
	yyaccept = 11;
	yych = *(mar = ++cur);
	if (yych == '_') goto yy829;
yy691:
#line 616 "parser/tokenizer.re"
	{ RET(TK_TRUE) }
#line 5917 "parser/tokenizer.cpp"
yy692:
	yych = *++cur;
	if (yych == 'C') goto yy830;
	if (yych == 'c') goto yy830;
	goto yy37;
yy693:
	yych = *++cur;
	if (yych == 'T') goto yy831;
	if (yych == 't') goto yy831;
	goto yy37;
yy694:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'M') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy695;
			if (yych <= 'L') goto yy36;
			goto yy832;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'm') goto yy832;
			if (yych <= 'z') goto yy36;
		}
	}
yy695:
#line 283 "parser/tokenizer.re"
	{ KW(ASSIGN) }
#line 5953 "parser/tokenizer.cpp"
yy696:
	yych = *++cur;
	if (yych == 'A') goto yy833;
	if (yych == 'a') goto yy833;
	goto yy37;
yy697:
	yych = *++cur;
	if (yych == 'R') goto yy834;
	if (yych == 'r') goto yy834;
	goto yy37;
yy698:
	yych = *++cur;
	if (yych == 'A') goto yy835;
	if (yych == 'a') goto yy835;
	goto yy37;
yy699:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy700;
			if (yych <= 'S') goto yy36;
			goto yy836;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy836;
			if (yych <= 'z') goto yy36;
		}
	}
yy700:
#line 292 "parser/tokenizer.re"
	{ KW(CHANGE) }
#line 5994 "parser/tokenizer.cpp"
yy701:
	yych = *++cur;
	if (yych == 'T') goto yy837;
	if (yych == 't') goto yy837;
	goto yy37;
yy702:
	yych = *++cur;
	if (yych == 'N') goto yy838;
	if (yych == 'n') goto yy838;
	goto yy37;
yy703:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 298 "parser/tokenizer.re"
	{ KW(COMMON) }
#line 6013 "parser/tokenizer.cpp"
yy704:
	yych = *++cur;
	if (yych == 'X') goto yy839;
	if (yych == 'x') goto yy839;
	goto yy37;
yy705:
	yych = *++cur;
	if (yych == 'R') goto yy840;
	if (yych == 'r') goto yy840;
	goto yy37;
yy706:
	yych = *++cur;
	if (yych == 'N') goto yy841;
	if (yych == 'n') goto yy841;
	goto yy37;
yy707:
	yych = *++cur;
	if (yych == 'U') goto yy842;
	if (yych == 'u') goto yy842;
	goto yy37;
yy708:
	yych = *++cur;
	if (yych == 'U') goto yy843;
	if (yych == 'u') goto yy843;
	goto yy37;
yy709:
	yych = *++cur;
	if (yych == 'A') goto yy844;
	if (yych == 'a') goto yy844;
	goto yy37;
yy710:
	yych = *++cur;
	if (yych == 'C') goto yy845;
	if (yych == 'c') goto yy845;
	goto yy37;
yy711:
	yych = *++cur;
	if (yych == 'T') goto yy846;
	if (yych == 't') goto yy846;
	goto yy37;
yy712:
	yych = *++cur;
	if (yych == 'E') goto yy847;
	if (yych == 'e') goto yy847;
	goto yy37;
yy713:
	yych = *++cur;
	if (yych == 'I') goto yy848;
	if (yych == 'i') goto yy848;
	goto yy37;
yy714:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'P') {
		if (yych <= '@') {
			if (yych <= '/') goto yy715;
			if (yych <= '9') goto yy36;
		} else {
			if (yych == 'C') goto yy849;
			if (yych <= 'O') goto yy36;
			goto yy850;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy36;
			if (yych <= '`') goto yy715;
			if (yych <= 'b') goto yy36;
			goto yy849;
		} else {
			if (yych == 'p') goto yy850;
			if (yych <= 'z') goto yy36;
		}
	}
yy715:
#line 320 "parser/tokenizer.re"
	{ KW(DOUBLE) }
#line 6092 "parser/tokenizer.cpp"
yy716:
	yych = *++cur;
	if (yych == 'E') goto yy851;
	if (yych == 'e') goto yy851;
	goto yy37;
yy717:
	yych = *++cur;
	if (yych == 'T') goto yy852;
	if (yych == 't') goto yy852;
	goto yy37;
yy718:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 325 "parser/tokenizer.re"
	{ KW(ELSEIF) }
#line 6111 "parser/tokenizer.cpp"
yy719:
	yych = *++cur;
	if (yych == 'E') goto yy853;
	if (yych == 'e') goto yy853;
	goto yy37;
yy720:
	yych = *++cur;
	if (yych == 'S') goto yy854;
	if (yych == 's') goto yy854;
	goto yy62;
yy721:
	yych = *++cur;
	if (yych == 'O') goto yy855;
	if (yych == 'o') goto yy855;
	goto yy62;
yy722:
	yych = *++cur;
	if (yych == 'I') goto yy856;
	if (yych == 'i') goto yy856;
	goto yy62;
yy723:
	++cur;
#line 383 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    KW(CONTINUE)
                } else {
                    KW(END_DO)
                }
            }
#line 6142 "parser/tokenizer.cpp"
yy724:
	yych = *++cur;
	if (yych == 'U') goto yy857;
	if (yych == 'u') goto yy857;
	goto yy62;
yy725:
	yych = *++cur;
	if (yych == 'R') goto yy858;
	if (yych == 'r') goto yy858;
	goto yy62;
yy726:
	yych = *++cur;
	if (yych == 'N') goto yy859;
	if (yych == 'n') goto yy859;
	goto yy62;
yy727:
	++cur;
#line 374 "parser/tokenizer.re"
	{ KW(END_IF) }
#line 6162 "parser/tokenizer.cpp"
yy728:
	yych = *++cur;
	if (yych == 'T') goto yy860;
	if (yych == 't') goto yy860;
	goto yy62;
yy729:
	yych = *++cur;
	if (yych == 'D') goto yy861;
	if (yych == 'd') goto yy861;
	goto yy62;
yy730:
	yych = *++cur;
	if (yych == 'O') goto yy862;
	if (yych == 'o') goto yy862;
	goto yy62;
yy731:
	yych = *++cur;
	if (yych == 'L') goto yy863;
	if (yych == 'l') goto yy863;
	goto yy62;
yy732:
	yych = *++cur;
	if (yych == 'B') goto yy864;
	if (yych == 'b') goto yy864;
	goto yy62;
yy733:
	yych = *++cur;
	if (yych == 'A') goto yy865;
	if (yych == 'a') goto yy865;
	goto yy62;
yy734:
	yych = *++cur;
	if (yych == 'P') goto yy866;
	if (yych == 'p') goto yy866;
	goto yy62;
yy735:
	yych = *++cur;
	if (yych == 'E') goto yy867;
	if (yych == 'e') goto yy867;
	goto yy62;
yy736:
	yych = *++cur;
	if (yych == 'F') goto yy868;
	if (yych == 'f') goto yy868;
	goto yy62;
yy737:
	yych = *++cur;
	if (yych == 'L') goto yy869;
	if (yych == 'l') goto yy869;
	goto yy62;
yy738:
	yych = *++cur;
	if (yych == 'O') goto yy870;
	if (yych == 'o') goto yy870;
	goto yy37;
yy739:
	yych = *++cur;
	if (yych == 'C') goto yy871;
	if (yych == 'c') goto yy871;
	goto yy37;
yy740:
	yych = *++cur;
	if (yych == 'T') goto yy872;
	if (yych == 't') goto yy872;
	goto yy37;
yy741:
	yych = *++cur;
	if (yych == 'M') goto yy873;
	if (yych == 'm') goto yy873;
	goto yy37;
yy742:
	yych = *++cur;
	if (yych == 'E') goto yy874;
	if (yych == 'e') goto yy874;
	goto yy37;
yy743:
	yych = *++cur;
	if (yych == 'A') goto yy875;
	if (yych == 'a') goto yy875;
	goto yy37;
yy744:
	yych = *++cur;
	if (yych == 'C') goto yy876;
	if (yych == 'c') goto yy876;
	goto yy37;
yy745:
	yych = *++cur;
	if (yych == 'E') goto yy877;
	if (yych == 'e') goto yy877;
	goto yy37;
yy746:
	yych = *++cur;
	if (yych == 'U') goto yy878;
	if (yych == 'u') goto yy878;
	goto yy37;
yy747:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy879;
		if (yych <= 'F') goto yy37;
		goto yy880;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy879;
		} else {
			if (yych == 'g') goto yy880;
			goto yy37;
		}
	}
yy748:
	yych = *++cur;
	if (yych == 'E') goto yy881;
	if (yych == 'e') goto yy881;
	goto yy37;
yy749:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy882;
		if (yych <= 'Q') goto yy37;
		goto yy883;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy882;
		} else {
			if (yych == 'r') goto yy883;
			goto yy37;
		}
	}
yy750:
	yych = *++cur;
	if (yych == 'M') goto yy884;
	if (yych == 'm') goto yy884;
	goto yy37;
yy751:
	yych = *++cur;
	if (yych == 'E') goto yy885;
	if (yych == 'e') goto yy885;
	goto yy37;
yy752:
	yych = *++cur;
	if (yych == 'R') goto yy886;
	if (yych == 'r') goto yy886;
	goto yy37;
yy753:
	yych = *++cur;
	if (yych == 'A') goto yy887;
	if (yych == 'a') goto yy887;
	goto yy37;
yy754:
	yych = *++cur;
	if (yych == 'L') goto yy888;
	if (yych == 'l') goto yy888;
	goto yy37;
yy755:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 408 "parser/tokenizer.re"
	{ KW(ERRMSG) }
#line 6326 "parser/tokenizer.cpp"
yy756:
	yych = *++cur;
	if (yych == 'S') goto yy889;
	if (yych == 's') goto yy889;
	goto yy37;
yy757:
	yych = *++cur;
	if (yych == 'A') goto yy890;
	if (yych == 'a') goto yy890;
	goto yy37;
yy758:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 417 "parser/tokenizer.re"
	{ KW(FORALL) }
#line 6345 "parser/tokenizer.cpp"
yy759:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy760;
			if (yych <= 'S') goto yy36;
			goto yy891;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy891;
			if (yych <= 'z') goto yy36;
		}
	}
yy760:
#line 418 "parser/tokenizer.re"
	{
                if (last_token == yytokentype::TK_LABEL) {
                    unsigned char *start;
                    lex_format(cur, loc, start, diagnostics, continue_compilation, this->string_start);
                    yylval.string.p = (char*) start;
                    yylval.string.n = cur-start-1;
                    RET(TK_FORMAT)
                } else {
                    token(yylval.string);
                    RET(TK_NAME)
                }
            }
#line 6382 "parser/tokenizer.cpp"
yy761:
	yych = *++cur;
	if (yych == 'A') goto yy892;
	if (yych == 'a') goto yy892;
	goto yy37;
yy762:
	yych = *++cur;
	if (yych == 'O') goto yy893;
	if (yych == 'o') goto yy893;
	goto yy37;
yy763:
	yych = *++cur;
	if (yych == 'C') goto yy894;
	if (yych == 'c') goto yy894;
	goto yy37;
yy764:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 438 "parser/tokenizer.re"
	{ KW(IMAGES) }
#line 6406 "parser/tokenizer.cpp"
yy765:
	yych = *++cur;
	if (yych == 'I') goto yy895;
	if (yych == 'i') goto yy895;
	goto yy37;
yy766:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 440 "parser/tokenizer.re"
	{ KW(IMPORT) }
#line 6420 "parser/tokenizer.cpp"
yy767:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 441 "parser/tokenizer.re"
	{ KW(IMPURE) }
#line 6429 "parser/tokenizer.cpp"
yy768:
	++cur;
#line 445 "parser/tokenizer.re"
	{ KW(IN_OUT) }
#line 6434 "parser/tokenizer.cpp"
yy769:
	yych = *++cur;
	if (yych == 'E') goto yy896;
	if (yych == 'e') goto yy896;
	goto yy37;
yy770:
	yych = *++cur;
	if (yych == 'E') goto yy897;
	if (yych == 'e') goto yy897;
	goto yy37;
yy771:
	yych = *++cur;
	if (yych == 'T') goto yy898;
	if (yych == 't') goto yy898;
	goto yy37;
yy772:
	yych = *++cur;
	if (yych == 'R') goto yy899;
	if (yych == 'r') goto yy899;
	goto yy37;
yy773:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 449 "parser/tokenizer.re"
	{ KW(INTENT) }
#line 6463 "parser/tokenizer.cpp"
yy774:
	yych = *++cur;
	if (yych == 'A') goto yy900;
	if (yych == 'a') goto yy900;
	goto yy37;
yy775:
	yych = *++cur;
	if (yych == 'S') goto yy901;
	if (yych == 's') goto yy901;
	goto yy37;
yy776:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy66;
		if (yych <= '&') goto yy37;
		goto yy83;
	} else {
		if (yych <= 'I') {
			if (yych <= 'H') goto yy37;
			goto yy902;
		} else {
			if (yych == 'i') goto yy902;
			goto yy37;
		}
	}
yy777:
	yych = *++cur;
	if (yych == 'L') goto yy903;
	if (yych == 'l') goto yy903;
	goto yy37;
yy778:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 458 "parser/tokenizer.re"
	{ KW(MEMORY) }
#line 6503 "parser/tokenizer.cpp"
yy779:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 459 "parser/tokenizer.re"
	{ KW(MODULE) }
#line 6512 "parser/tokenizer.cpp"
yy780:
	yych = *++cur;
	if (yych == 'S') goto yy904;
	if (yych == 's') goto yy904;
	goto yy37;
yy781:
	yych = *++cur;
	if (yych == 'D') goto yy905;
	if (yych == 'd') goto yy905;
	goto yy37;
yy782:
	yych = *++cur;
	if (yych == 'T') goto yy906;
	if (yych == 't') goto yy906;
	goto yy37;
yy783:
	yych = *++cur;
	if (yych == 'E') goto yy907;
	if (yych == 'e') goto yy907;
	goto yy37;
yy784:
	yych = *++cur;
	if (yych == 'C') goto yy908;
	if (yych == 'c') goto yy908;
	goto yy37;
yy785:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 464 "parser/tokenizer.re"
	{ KW(NOPASS) }
#line 6546 "parser/tokenizer.cpp"
yy786:
	yych = *++cur;
	if (yych == 'Y') goto yy909;
	if (yych == 'y') goto yy909;
	goto yy37;
yy787:
	yych = *++cur;
	if (yych == 'O') goto yy910;
	if (yych == 'o') goto yy910;
	goto yy37;
yy788:
	yych = *++cur;
	if (yych == 'A') goto yy911;
	if (yych == 'a') goto yy911;
	goto yy37;
yy789:
	yych = *++cur;
	if (yych == 'T') goto yy912;
	if (yych == 't') goto yy912;
	goto yy37;
yy790:
	yych = *++cur;
	if (yych == 'R') goto yy913;
	if (yych == 'r') goto yy913;
	goto yy37;
yy791:
	yych = *++cur;
	if (yych == 'I') goto yy914;
	if (yych == 'i') goto yy914;
	goto yy37;
yy792:
	yych = *++cur;
	if (yych == 'E') goto yy915;
	if (yych == 'e') goto yy915;
	goto yy37;
yy793:
	yych = *++cur;
	if (yych == 'U') goto yy916;
	if (yych == 'u') goto yy916;
	goto yy37;
yy794:
	yych = *++cur;
	if (yych == 'M') goto yy917;
	if (yych == 'm') goto yy917;
	goto yy37;
yy795:
	yych = *++cur;
	if (yych == 'T') goto yy918;
	if (yych == 't') goto yy918;
	goto yy37;
yy796:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 485 "parser/tokenizer.re"
	{ KW(PUBLIC) }
#line 6605 "parser/tokenizer.cpp"
yy797:
	yych = *++cur;
	if (yych == 'I') goto yy919;
	if (yych == 'i') goto yy919;
	goto yy37;
yy798:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 492 "parser/tokenizer.re"
	{ KW(REDUCE) }
#line 6619 "parser/tokenizer.cpp"
yy799:
	yych = *++cur;
	if (yych == 'E') goto yy920;
	if (yych == 'e') goto yy920;
	goto yy37;
yy800:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 495 "parser/tokenizer.re"
	{ KW(RESULT) }
#line 6633 "parser/tokenizer.cpp"
yy801:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 496 "parser/tokenizer.re"
	{ KW(RETURN) }
#line 6642 "parser/tokenizer.cpp"
yy802:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 497 "parser/tokenizer.re"
	{ KW(REWIND) }
#line 6651 "parser/tokenizer.cpp"
yy803:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'T') {
		if (yych <= 'B') {
			if (yych <= '/') goto yy804;
			if (yych <= '9') goto yy36;
			if (yych >= 'A') goto yy36;
		} else {
			if (yych <= 'Q') {
				if (yych <= 'C') goto yy922;
				goto yy36;
			} else {
				if (yych <= 'R') goto yy923;
				if (yych <= 'S') goto yy36;
				goto yy924;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy36;
			} else {
				if (yych == 'c') goto yy922;
				goto yy36;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'r') goto yy923;
				goto yy36;
			} else {
				if (yych <= 't') goto yy924;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy804:
#line 499 "parser/tokenizer.re"
	{ KW(SELECT) }
#line 6693 "parser/tokenizer.cpp"
yy805:
	yych = *++cur;
	if (yych == 'C') goto yy925;
	if (yych == 'c') goto yy925;
	goto yy37;
yy806:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 504 "parser/tokenizer.re"
	{ KW(SHARED) }
#line 6707 "parser/tokenizer.cpp"
yy807:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 505 "parser/tokenizer.re"
	{ KW(SOURCE) }
#line 6716 "parser/tokenizer.cpp"
yy808:
	yych = *++cur;
	if (yych == 'U') goto yy926;
	if (yych == 'u') goto yy926;
	goto yy37;
yy809:
	yych = *++cur;
	if (yych == 'T') goto yy927;
	if (yych == 't') goto yy927;
	goto yy37;
yy810:
	yych = *++cur;
	if (yych == 'L') goto yy928;
	if (yych == 'l') goto yy928;
	goto yy37;
yy811:
	yych = *++cur;
	if (yych == 'A') goto yy929;
	if (yych == 'a') goto yy929;
	goto yy37;
yy812:
	yych = *++cur;
	if (yych == 'M') goto yy930;
	if (yych == 'm') goto yy930;
	goto yy37;
yy813:
	yych = *++cur;
	if (yych == 'A') goto yy931;
	if (yych == 'a') goto yy931;
	goto yy37;
yy814:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 515 "parser/tokenizer.re"
	{ KW(TARGET) }
#line 6755 "parser/tokenizer.cpp"
yy815:
	yych = *++cur;
	if (yych == 'U') goto yy932;
	if (yych == 'u') goto yy932;
	goto yy37;
yy816:
	yych = *++cur;
	if (yych == 'T') goto yy933;
	if (yych == 't') goto yy933;
	goto yy37;
yy817:
	yych = *++cur;
	if (yych == 'A') goto yy934;
	if (yych == 'a') goto yy934;
	goto yy37;
yy818:
	yych = *++cur;
	if (yych == 'L') goto yy935;
	if (yych == 'l') goto yy935;
	goto yy37;
yy819:
	yych = *++cur;
	if (yych == 'R') goto yy936;
	if (yych == 'r') goto yy936;
	goto yy37;
yy820:
	yych = *++cur;
	if (yych == 'N') goto yy937;
	if (yych == 'n') goto yy937;
	goto yy678;
yy821:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy938;
		if (yych <= '\n') goto yy70;
		goto yy938;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy70;
			goto yy938;
		} else {
			if (yych == ' ') goto yy938;
			goto yy70;
		}
	}
yy822:
	++cur;
#line 718 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#elif ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 6811 "parser/tokenizer.cpp"
yy823:
	++cur;
#line 732 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#endif ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 6822 "parser/tokenizer.cpp"
yy824:
	yych = *++cur;
	if (yych <= 0x00) goto yy62;
	if (yych == '\n') goto yy939;
	goto yy824;
yy825:
	yych = *++cur;
	if (yych == 'e') goto yy940;
	goto yy70;
yy826:
	++cur;
#line 710 "parser/tokenizer.re"
	{ line_num++; cur_line=cur; continue; }
#line 6836 "parser/tokenizer.cpp"
yy827:
	yyaccept = 12;
	yych = *(mar = ++cur);
	if (yych == '_') goto yy941;
yy828:
#line 617 "parser/tokenizer.re"
	{ RET(TK_FALSE) }
#line 6844 "parser/tokenizer.cpp"
yy829:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy62;
		if (yych <= '9') goto yy942;
		if (yych <= '@') goto yy62;
		goto yy943;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy62;
			goto yy943;
		} else {
			if (yych <= '`') goto yy62;
			if (yych <= 'z') goto yy943;
			goto yy62;
		}
	}
yy830:
	yych = *++cur;
	if (yych == 'T') goto yy944;
	if (yych == 't') goto yy944;
	goto yy37;
yy831:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy945;
		if (yych <= 'D') goto yy37;
		goto yy946;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy945;
		} else {
			if (yych == 'e') goto yy946;
			goto yy37;
		}
	}
yy832:
	yych = *++cur;
	if (yych == 'E') goto yy947;
	if (yych == 'e') goto yy947;
	goto yy37;
yy833:
	yych = *++cur;
	if (yych == 'T') goto yy948;
	if (yych == 't') goto yy948;
	goto yy37;
yy834:
	yych = *++cur;
	if (yych == 'O') goto yy949;
	if (yych == 'o') goto yy949;
	goto yy37;
yy835:
	yych = *++cur;
	if (yych == 'C') goto yy950;
	if (yych == 'c') goto yy950;
	goto yy37;
yy836:
	yych = *++cur;
	if (yych == 'E') goto yy951;
	if (yych == 'e') goto yy951;
	goto yy37;
yy837:
	yych = *++cur;
	if (yych == 'E') goto yy952;
	if (yych == 'e') goto yy952;
	goto yy37;
yy838:
	yych = *++cur;
	if (yych == 'S') goto yy953;
	if (yych == 's') goto yy953;
	goto yy37;
yy839:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 299 "parser/tokenizer.re"
	{ KW(COMPLEX) }
#line 6925 "parser/tokenizer.cpp"
yy840:
	yych = *++cur;
	if (yych == 'E') goto yy954;
	if (yych == 'e') goto yy954;
	goto yy37;
yy841:
	yych = *++cur;
	if (yych == 'S') goto yy955;
	if (yych == 's') goto yy955;
	goto yy37;
yy842:
	yych = *++cur;
	if (yych == 'O') goto yy956;
	if (yych == 'o') goto yy956;
	goto yy37;
yy843:
	yych = *++cur;
	if (yych == 'E') goto yy957;
	if (yych == 'e') goto yy957;
	goto yy37;
yy844:
	yych = *++cur;
	if (yych == 'L') goto yy958;
	if (yych == 'l') goto yy958;
	goto yy37;
yy845:
	yych = *++cur;
	if (yych == 'A') goto yy959;
	if (yych == 'a') goto yy959;
	goto yy37;
yy846:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 308 "parser/tokenizer.re"
	{ KW(DEFAULT) }
#line 6964 "parser/tokenizer.cpp"
yy847:
	yych = *++cur;
	if (yych == 'D') goto yy960;
	if (yych == 'd') goto yy960;
	goto yy37;
yy848:
	yych = *++cur;
	if (yych == 'O') goto yy961;
	if (yych == 'o') goto yy961;
	goto yy37;
yy849:
	yych = *++cur;
	if (yych == 'O') goto yy962;
	if (yych == 'o') goto yy962;
	goto yy37;
yy850:
	yych = *++cur;
	if (yych == 'R') goto yy963;
	if (yych == 'r') goto yy963;
	goto yy37;
yy851:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 319 "parser/tokenizer.re"
	{ KW(DOWHILE) }
#line 6993 "parser/tokenizer.cpp"
yy852:
	yych = *++cur;
	if (yych == 'A') goto yy964;
	if (yych == 'a') goto yy964;
	goto yy37;
yy853:
	yych = *++cur;
	if (yych == 'R') goto yy965;
	if (yych == 'r') goto yy965;
	goto yy37;
yy854:
	yych = *++cur;
	if (yych == 'O') goto yy966;
	if (yych == 'o') goto yy966;
	goto yy62;
yy855:
	yych = *++cur;
	if (yych == 'C') goto yy967;
	if (yych == 'c') goto yy967;
	goto yy62;
yy856:
	yych = *++cur;
	if (yych == 'T') goto yy968;
	if (yych == 't') goto yy968;
	goto yy62;
yy857:
	yych = *++cur;
	if (yych == 'M') goto yy969;
	if (yych == 'm') goto yy969;
	goto yy62;
yy858:
	yych = *++cur;
	if (yych == 'A') goto yy970;
	if (yych == 'a') goto yy970;
	goto yy62;
yy859:
	yych = *++cur;
	if (yych == 'C') goto yy971;
	if (yych == 'c') goto yy971;
	goto yy62;
yy860:
	yych = *++cur;
	if (yych == 'E') goto yy972;
	if (yych == 'e') goto yy972;
	goto yy62;
yy861:
	yych = *++cur;
	if (yych == 'U') goto yy973;
	if (yych == 'u') goto yy973;
	goto yy62;
yy862:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy974;
		if (yych <= 'F') goto yy62;
		goto yy975;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy62;
			goto yy974;
		} else {
			if (yych == 'g') goto yy975;
			goto yy62;
		}
	}
yy863:
	yych = *++cur;
	if (yych == 'E') goto yy976;
	if (yych == 'e') goto yy976;
	goto yy62;
yy864:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy977;
		if (yych <= 'Q') goto yy62;
		goto yy978;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy62;
			goto yy977;
		} else {
			if (yych == 'r') goto yy978;
			goto yy62;
		}
	}
yy865:
	yych = *++cur;
	if (yych == 'M') goto yy979;
	if (yych == 'm') goto yy979;
	goto yy62;
yy866:
	yych = *++cur;
	if (yych == 'E') goto yy980;
	if (yych == 'e') goto yy980;
	goto yy62;
yy867:
	yych = *++cur;
	if (yych == 'R') goto yy981;
	if (yych == 'r') goto yy981;
	goto yy62;
yy868:
	yych = *++cur;
	if (yych == 'O') goto yy982;
	if (yych == 'o') goto yy982;
	goto yy62;
yy869:
	yych = *++cur;
	if (yych == 'E') goto yy983;
	if (yych == 'e') goto yy983;
	goto yy62;
yy870:
	yych = *++cur;
	if (yych == 'C') goto yy984;
	if (yych == 'c') goto yy984;
	goto yy37;
yy871:
	yych = *++cur;
	if (yych == 'K') goto yy985;
	if (yych == 'k') goto yy985;
	goto yy37;
yy872:
	yych = *++cur;
	if (yych == 'I') goto yy987;
	if (yych == 'i') goto yy987;
	goto yy37;
yy873:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 357 "parser/tokenizer.re"
	{ KW(ENDENUM) }
#line 7127 "parser/tokenizer.cpp"
yy874:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 402 "parser/tokenizer.re"
	{ KW(ENDFILE) }
#line 7136 "parser/tokenizer.cpp"
yy875:
	yych = *++cur;
	if (yych == 'L') goto yy988;
	if (yych == 'l') goto yy988;
	goto yy37;
yy876:
	yych = *++cur;
	if (yych == 'T') goto yy989;
	if (yych == 't') goto yy989;
	goto yy37;
yy877:
	yych = *++cur;
	if (yych == 'R') goto yy990;
	if (yych == 'r') goto yy990;
	goto yy37;
yy878:
	yych = *++cur;
	if (yych == 'L') goto yy991;
	if (yych == 'l') goto yy991;
	goto yy37;
yy879:
	yych = *++cur;
	if (yych == 'E') goto yy992;
	if (yych == 'e') goto yy992;
	goto yy37;
yy880:
	yych = *++cur;
	if (yych == 'R') goto yy993;
	if (yych == 'r') goto yy993;
	goto yy37;
yy881:
	yych = *++cur;
	if (yych == 'C') goto yy994;
	if (yych == 'c') goto yy994;
	goto yy37;
yy882:
	yych = *++cur;
	if (yych == 'O') goto yy995;
	if (yych == 'o') goto yy995;
	goto yy37;
yy883:
	yych = *++cur;
	if (yych == 'O') goto yy996;
	if (yych == 'o') goto yy996;
	goto yy37;
yy884:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 369 "parser/tokenizer.re"
	{ KW(ENDTEAM) }
#line 7190 "parser/tokenizer.cpp"
yy885:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 381 "parser/tokenizer.re"
	{ KW(ENDTYPE) }
#line 7199 "parser/tokenizer.cpp"
yy886:
	yych = *++cur;
	if (yych == 'E') goto yy997;
	if (yych == 'e') goto yy997;
	goto yy37;
yy887:
	yych = *++cur;
	if (yych == 'T') goto yy998;
	if (yych == 't') goto yy998;
	goto yy37;
yy888:
	yych = *++cur;
	if (yych == 'E') goto yy999;
	if (yych == 'e') goto yy999;
	goto yy37;
yy889:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 412 "parser/tokenizer.re"
	{ KW(EXTENDS) }
#line 7223 "parser/tokenizer.cpp"
yy890:
	yych = *++cur;
	if (yych == 'L') goto yy1000;
	if (yych == 'l') goto yy1000;
	goto yy37;
yy891:
	yych = *++cur;
	if (yych == 'E') goto yy1001;
	if (yych == 'e') goto yy1001;
	goto yy37;
yy892:
	yych = *++cur;
	if (yych == 'M') goto yy1002;
	if (yych == 'm') goto yy1002;
	goto yy37;
yy893:
	yych = *++cur;
	if (yych == 'N') goto yy1003;
	if (yych == 'n') goto yy1003;
	goto yy37;
yy894:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 434 "parser/tokenizer.re"
	{ KW(GENERIC) }
#line 7252 "parser/tokenizer.cpp"
yy895:
	yych = *++cur;
	if (yych == 'T') goto yy1004;
	if (yych == 't') goto yy1004;
	goto yy37;
yy896:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 443 "parser/tokenizer.re"
	{ KW(INCLUDE) }
#line 7266 "parser/tokenizer.cpp"
yy897:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 446 "parser/tokenizer.re"
	{ KW(INQUIRE) }
#line 7275 "parser/tokenizer.cpp"
yy898:
	yych = *++cur;
	if (yych == 'I') goto yy1005;
	if (yych == 'i') goto yy1005;
	goto yy37;
yy899:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 448 "parser/tokenizer.re"
	{ KW(INTEGER) }
#line 7289 "parser/tokenizer.cpp"
yy900:
	yych = *++cur;
	if (yych == 'C') goto yy1006;
	if (yych == 'c') goto yy1006;
	goto yy37;
yy901:
	yych = *++cur;
	if (yych == 'I') goto yy1007;
	if (yych == 'i') goto yy1007;
	goto yy37;
yy902:
	yych = *++cur;
	if (yych == 'N') goto yy1008;
	if (yych == 'n') goto yy1008;
	goto yy37;
yy903:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 457 "parser/tokenizer.re"
	{ KW(LOGICAL) }
#line 7313 "parser/tokenizer.cpp"
yy904:
	yych = *++cur;
	if (yych == 'T') goto yy1009;
	if (yych == 't') goto yy1009;
	goto yy37;
yy905:
	yych = *++cur;
	if (yych == 'E') goto yy1010;
	if (yych == 'e') goto yy1010;
	goto yy37;
yy906:
	yych = *++cur;
	if (yych == 'R') goto yy1011;
	if (yych == 'r') goto yy1011;
	goto yy37;
yy907:
	yych = *++cur;
	if (yych == 'R') goto yy1012;
	if (yych == 'r') goto yy1012;
	goto yy37;
yy908:
	yych = *++cur;
	if (yych == 'U') goto yy1013;
	if (yych == 'u') goto yy1013;
	goto yy37;
yy909:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 469 "parser/tokenizer.re"
	{ KW(NULLIFY) }
#line 7347 "parser/tokenizer.cpp"
yy910:
	yych = *++cur;
	if (yych == 'R') goto yy1014;
	if (yych == 'r') goto yy1014;
	goto yy37;
yy911:
	yych = *++cur;
	if (yych == 'L') goto yy1015;
	if (yych == 'l') goto yy1015;
	goto yy37;
yy912:
	yych = *++cur;
	if (yych == 'E') goto yy1016;
	if (yych == 'e') goto yy1016;
	goto yy37;
yy913:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 477 "parser/tokenizer.re"
	{ KW(POINTER) }
#line 7371 "parser/tokenizer.cpp"
yy914:
	yych = *++cur;
	if (yych == 'O') goto yy1017;
	if (yych == 'o') goto yy1017;
	goto yy37;
yy915:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 481 "parser/tokenizer.re"
	{ KW(PRIVATE) }
#line 7385 "parser/tokenizer.cpp"
yy916:
	yych = *++cur;
	if (yych == 'R') goto yy1018;
	if (yych == 'r') goto yy1018;
	goto yy37;
yy917:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 483 "parser/tokenizer.re"
	{ KW(PROGRAM) }
#line 7399 "parser/tokenizer.cpp"
yy918:
	yych = *++cur;
	if (yych == 'E') goto yy1019;
	if (yych == 'e') goto yy1019;
	goto yy37;
yy919:
	yych = *++cur;
	if (yych == 'V') goto yy1020;
	if (yych == 'v') goto yy1020;
	goto yy37;
yy920:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= 'M') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy921;
			if (yych <= 'L') goto yy36;
			goto yy1021;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'm') goto yy1021;
			if (yych <= 'z') goto yy36;
		}
	}
yy921:
#line 494 "parser/tokenizer.re"
	{ KW(REQUIRE) }
#line 7435 "parser/tokenizer.cpp"
yy922:
	yych = *++cur;
	if (yych == 'A') goto yy1022;
	if (yych == 'a') goto yy1022;
	goto yy37;
yy923:
	yych = *++cur;
	if (yych == 'A') goto yy1023;
	if (yych == 'a') goto yy1023;
	goto yy37;
yy924:
	yych = *++cur;
	if (yych == 'Y') goto yy1024;
	if (yych == 'y') goto yy1024;
	goto yy37;
yy925:
	yych = *++cur;
	if (yych == 'E') goto yy1025;
	if (yych == 'e') goto yy1025;
	goto yy37;
yy926:
	yych = *++cur;
	if (yych == 'L') goto yy1026;
	if (yych == 'l') goto yy1026;
	goto yy37;
yy927:
	yych = *++cur;
	if (yych == 'I') goto yy1027;
	if (yych == 'i') goto yy1027;
	goto yy37;
yy928:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 511 "parser/tokenizer.re"
	{ KW(SYNC_ALL) }
#line 7474 "parser/tokenizer.cpp"
yy929:
	yych = *++cur;
	if (yych == 'G') goto yy1028;
	if (yych == 'g') goto yy1028;
	goto yy37;
yy930:
	yych = *++cur;
	if (yych == 'O') goto yy1029;
	if (yych == 'o') goto yy1029;
	goto yy37;
yy931:
	yych = *++cur;
	if (yych == 'M') goto yy1030;
	if (yych == 'm') goto yy1030;
	goto yy37;
yy932:
	yych = *++cur;
	if (yych == 'M') goto yy1031;
	if (yych == 'm') goto yy1031;
	goto yy37;
yy933:
	yych = *++cur;
	if (yych == 'E') goto yy1032;
	if (yych == 'e') goto yy1032;
	goto yy37;
yy934:
	yych = *++cur;
	if (yych == 'T') goto yy1033;
	if (yych == 't') goto yy1033;
	goto yy37;
yy935:
	yych = *++cur;
	if (yych == 'E') goto yy1034;
	if (yych == 'e') goto yy1034;
	goto yy37;
yy936:
	yych = *++cur;
	if (yych == 'A') goto yy1035;
	if (yych == 'a') goto yy1035;
	goto yy37;
yy937:
	yych = *++cur;
	if (yych == 'D') goto yy1036;
	if (yych == 'd') goto yy1036;
	goto yy678;
yy938:
	yych = *++cur;
	if (yych <= 0x00) goto yy62;
	if (yych == '\n') goto yy1037;
	goto yy938;
yy939:
	++cur;
#line 711 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#ifdef ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 7535 "parser/tokenizer.cpp"
yy940:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy1038;
		if (yych <= '\n') goto yy70;
		goto yy1038;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy70;
			goto yy1038;
		} else {
			if (yych == ' ') goto yy1038;
			goto yy70;
		}
	}
yy941:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy62;
		if (yych <= '9') goto yy1039;
		if (yych <= '@') goto yy62;
		goto yy1040;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy62;
			goto yy1040;
		} else {
			if (yych <= '`') goto yy62;
			if (yych <= 'z') goto yy1040;
			goto yy62;
		}
	}
yy942:
	yych = *++cur;
	if (yych <= '/') goto yy691;
	if (yych <= '9') goto yy942;
	goto yy691;
yy943:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy691;
		if (yych <= '9') goto yy943;
		if (yych <= '@') goto yy691;
		goto yy943;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy691;
			goto yy943;
		} else {
			if (yych <= '`') goto yy691;
			if (yych <= 'z') goto yy943;
			goto yy691;
		}
	}
yy944:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 279 "parser/tokenizer.re"
	{ KW(ABSTRACT) }
#line 7598 "parser/tokenizer.cpp"
yy945:
	yych = *++cur;
	if (yych == 'B') goto yy1041;
	if (yych == 'b') goto yy1041;
	goto yy37;
yy946:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 282 "parser/tokenizer.re"
	{ KW(ALLOCATE) }
#line 7612 "parser/tokenizer.cpp"
yy947:
	yych = *++cur;
	if (yych == 'N') goto yy1042;
	if (yych == 'n') goto yy1042;
	goto yy37;
yy948:
	yych = *++cur;
	if (yych == 'E') goto yy1043;
	if (yych == 'e') goto yy1043;
	goto yy37;
yy949:
	yych = *++cur;
	if (yych == 'N') goto yy1044;
	if (yych == 'n') goto yy1044;
	goto yy37;
yy950:
	yych = *++cur;
	if (yych == 'E') goto yy1045;
	if (yych == 'e') goto yy1045;
	goto yy37;
yy951:
	yych = *++cur;
	if (yych == 'A') goto yy1046;
	if (yych == 'a') goto yy1046;
	goto yy37;
yy952:
	yych = *++cur;
	if (yych == 'R') goto yy1047;
	if (yych == 'r') goto yy1047;
	goto yy37;
yy953:
	yych = *++cur;
	if (yych == 'I') goto yy1048;
	if (yych == 'i') goto yy1048;
	goto yy37;
yy954:
	yych = *++cur;
	if (yych == 'N') goto yy1049;
	if (yych == 'n') goto yy1049;
	goto yy37;
yy955:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 301 "parser/tokenizer.re"
	{ KW(CONTAINS) }
#line 7661 "parser/tokenizer.cpp"
yy956:
	yych = *++cur;
	if (yych == 'U') goto yy1050;
	if (yych == 'u') goto yy1050;
	goto yy37;
yy957:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 303 "parser/tokenizer.re"
	{ KW(CONTINUE) }
#line 7675 "parser/tokenizer.cpp"
yy958:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 304 "parser/tokenizer.re"
	{ KW(CRITICAL) }
#line 7684 "parser/tokenizer.cpp"
yy959:
	yych = *++cur;
	if (yych == 'T') goto yy1051;
	if (yych == 't') goto yy1051;
	goto yy37;
yy960:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 309 "parser/tokenizer.re"
	{ KW(DEFERRED) }
#line 7698 "parser/tokenizer.cpp"
yy961:
	yych = *++cur;
	if (yych == 'N') goto yy1052;
	if (yych == 'n') goto yy1052;
	goto yy37;
yy962:
	yych = *++cur;
	if (yych == 'M') goto yy1053;
	if (yych == 'm') goto yy1053;
	goto yy37;
yy963:
	yych = *++cur;
	if (yych == 'E') goto yy1054;
	if (yych == 'e') goto yy1054;
	goto yy37;
yy964:
	yych = *++cur;
	if (yych == 'L') goto yy1055;
	if (yych == 'l') goto yy1055;
	goto yy37;
yy965:
	yych = *++cur;
	if (yych == 'E') goto yy1056;
	if (yych == 'e') goto yy1056;
	goto yy37;
yy966:
	yych = *++cur;
	if (yych == 'C') goto yy1057;
	if (yych == 'c') goto yy1057;
	goto yy62;
yy967:
	yych = *++cur;
	if (yych == 'K') goto yy1058;
	if (yych == 'k') goto yy1058;
	goto yy62;
yy968:
	yych = *++cur;
	if (yych == 'I') goto yy1060;
	if (yych == 'i') goto yy1060;
	goto yy62;
yy969:
	++cur;
#line 356 "parser/tokenizer.re"
	{ KW(END_ENUM) }
#line 7743 "parser/tokenizer.cpp"
yy970:
	yych = *++cur;
	if (yych == 'L') goto yy1061;
	if (yych == 'l') goto yy1061;
	goto yy62;
yy971:
	yych = *++cur;
	if (yych == 'T') goto yy1062;
	if (yych == 't') goto yy1062;
	goto yy62;
yy972:
	yych = *++cur;
	if (yych == 'R') goto yy1063;
	if (yych == 'r') goto yy1063;
	goto yy62;
yy973:
	yych = *++cur;
	if (yych == 'L') goto yy1064;
	if (yych == 'l') goto yy1064;
	goto yy62;
yy974:
	yych = *++cur;
	if (yych == 'E') goto yy1065;
	if (yych == 'e') goto yy1065;
	goto yy62;
yy975:
	yych = *++cur;
	if (yych == 'R') goto yy1066;
	if (yych == 'r') goto yy1066;
	goto yy62;
yy976:
	yych = *++cur;
	if (yych == 'C') goto yy1067;
	if (yych == 'c') goto yy1067;
	goto yy62;
yy977:
	yych = *++cur;
	if (yych == 'O') goto yy1068;
	if (yych == 'o') goto yy1068;
	goto yy62;
yy978:
	yych = *++cur;
	if (yych == 'O') goto yy1069;
	if (yych == 'o') goto yy1069;
	goto yy62;
yy979:
	++cur;
#line 368 "parser/tokenizer.re"
	{ KW(END_TEAM) }
#line 7793 "parser/tokenizer.cpp"
yy980:
	++cur;
#line 380 "parser/tokenizer.re"
	{ KW(END_TYPE) }
#line 7798 "parser/tokenizer.cpp"
yy981:
	yych = *++cur;
	if (yych == 'E') goto yy1070;
	if (yych == 'e') goto yy1070;
	goto yy62;
yy982:
	yych = *++cur;
	if (yych == 'R') goto yy1071;
	if (yych == 'r') goto yy1071;
	goto yy62;
yy983:
	++cur;
#line 401 "parser/tokenizer.re"
	{ KW(END_FILE) }
#line 7813 "parser/tokenizer.cpp"
yy984:
	yych = *++cur;
	if (yych == 'I') goto yy1072;
	if (yych == 'i') goto yy1072;
	goto yy37;
yy985:
	yyaccept = 13;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy118;
	}
	if (yych <= '/') {
		if (yych <= '\v') {
			if (yych == '\t') goto yy1073;
			if (yych >= '\v') goto yy1073;
		} else {
			if (yych <= '\r') {
				if (yych >= '\r') goto yy1073;
			} else {
				if (yych == ' ') goto yy1073;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy36;
			} else {
				if (yych == 'D') goto yy1074;
				goto yy36;
			}
		} else {
			if (yych <= 'c') {
				if (yych >= 'a') goto yy36;
			} else {
				if (yych <= 'd') goto yy1074;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy986:
#line 340 "parser/tokenizer.re"
	{ KW(ENDBLOCK) }
#line 7856 "parser/tokenizer.cpp"
yy987:
	yych = *++cur;
	if (yych == 'C') goto yy1075;
	if (yych == 'c') goto yy1075;
	goto yy37;
yy988:
	yych = *++cur;
	if (yych == 'L') goto yy1076;
	if (yych == 'l') goto yy1076;
	goto yy37;
yy989:
	yych = *++cur;
	if (yych == 'I') goto yy1077;
	if (yych == 'i') goto yy1077;
	goto yy37;
yy990:
	yych = *++cur;
	if (yych == 'F') goto yy1078;
	if (yych == 'f') goto yy1078;
	goto yy37;
yy991:
	yych = *++cur;
	if (yych == 'E') goto yy1079;
	if (yych == 'e') goto yy1079;
	goto yy37;
yy992:
	yych = *++cur;
	if (yych == 'D') goto yy1080;
	if (yych == 'd') goto yy1080;
	goto yy37;
yy993:
	yych = *++cur;
	if (yych == 'A') goto yy1081;
	if (yych == 'a') goto yy1081;
	goto yy37;
yy994:
	yych = *++cur;
	if (yych == 'T') goto yy1082;
	if (yych == 't') goto yy1082;
	goto yy37;
yy995:
	yych = *++cur;
	if (yych == 'D') goto yy1083;
	if (yych == 'd') goto yy1083;
	goto yy37;
yy996:
	yych = *++cur;
	if (yych == 'U') goto yy1084;
	if (yych == 'u') goto yy1084;
	goto yy37;
yy997:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 399 "parser/tokenizer.re"
	{ KW(ENDWHERE) }
#line 7915 "parser/tokenizer.cpp"
yy998:
	yych = *++cur;
	if (yych == 'O') goto yy1085;
	if (yych == 'o') goto yy1085;
	goto yy37;
yy999:
	yych = *++cur;
	if (yych == 'N') goto yy1086;
	if (yych == 'n') goto yy1086;
	goto yy37;
yy1000:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 413 "parser/tokenizer.re"
	{ KW(EXTERNAL) }
#line 7934 "parser/tokenizer.cpp"
yy1001:
	yych = *++cur;
	if (yych == 'D') goto yy1087;
	if (yych == 'd') goto yy1087;
	goto yy37;
yy1002:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 432 "parser/tokenizer.re"
	{ KW(FORM_TEAM) }
#line 7948 "parser/tokenizer.cpp"
yy1003:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 433 "parser/tokenizer.re"
	{ KW(FUNCTION) }
#line 7957 "parser/tokenizer.cpp"
yy1004:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 439 "parser/tokenizer.re"
	{ KW(IMPLICIT) }
#line 7966 "parser/tokenizer.cpp"
yy1005:
	yych = *++cur;
	if (yych == 'A') goto yy1088;
	if (yych == 'a') goto yy1088;
	goto yy37;
yy1006:
	yych = *++cur;
	if (yych == 'E') goto yy1089;
	if (yych == 'e') goto yy1089;
	goto yy37;
yy1007:
	yych = *++cur;
	if (yych == 'C') goto yy1090;
	if (yych == 'c') goto yy1090;
	goto yy37;
yy1008:
	yych = *++cur;
	if (yych == 'I') goto yy1091;
	if (yych == 'i') goto yy1091;
	goto yy37;
yy1009:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 462 "parser/tokenizer.re"
	{ KW(NAMELIST) }
#line 7995 "parser/tokenizer.cpp"
yy1010:
	yych = *++cur;
	if (yych == 'X') goto yy1092;
	if (yych == 'x') goto yy1092;
	goto yy37;
yy1011:
	yych = *++cur;
	if (yych == 'I') goto yy1093;
	if (yych == 'i') goto yy1093;
	goto yy37;
yy1012:
	yych = *++cur;
	if (yych == 'R') goto yy1094;
	if (yych == 'r') goto yy1094;
	goto yy37;
yy1013:
	yych = *++cur;
	if (yych == 'R') goto yy1095;
	if (yych == 'r') goto yy1095;
	goto yy37;
yy1014:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 472 "parser/tokenizer.re"
	{ KW(OPERATOR) }
#line 8024 "parser/tokenizer.cpp"
yy1015:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 473 "parser/tokenizer.re"
	{ KW(OPTIONAL) }
#line 8033 "parser/tokenizer.cpp"
yy1016:
	yych = *++cur;
	if (yych == 'R') goto yy1096;
	if (yych == 'r') goto yy1096;
	goto yy37;
yy1017:
	yych = *++cur;
	if (yych == 'N') goto yy1097;
	if (yych == 'n') goto yy1097;
	goto yy37;
yy1018:
	yych = *++cur;
	if (yych == 'E') goto yy1098;
	if (yych == 'e') goto yy1098;
	goto yy37;
yy1019:
	yych = *++cur;
	if (yych == 'D') goto yy1099;
	if (yych == 'd') goto yy1099;
	goto yy37;
yy1020:
	yych = *++cur;
	if (yych == 'E') goto yy1100;
	if (yych == 'e') goto yy1100;
	goto yy37;
yy1021:
	yych = *++cur;
	if (yych == 'E') goto yy1101;
	if (yych == 'e') goto yy1101;
	goto yy37;
yy1022:
	yych = *++cur;
	if (yych == 'S') goto yy1102;
	if (yych == 's') goto yy1102;
	goto yy37;
yy1023:
	yych = *++cur;
	if (yych == 'N') goto yy1103;
	if (yych == 'n') goto yy1103;
	goto yy37;
yy1024:
	yych = *++cur;
	if (yych == 'P') goto yy1104;
	if (yych == 'p') goto yy1104;
	goto yy37;
yy1025:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 503 "parser/tokenizer.re"
	{ KW(SEQUENCE) }
#line 8087 "parser/tokenizer.cpp"
yy1026:
	yych = *++cur;
	if (yych == 'E') goto yy1105;
	if (yych == 'e') goto yy1105;
	goto yy37;
yy1027:
	yych = *++cur;
	if (yych == 'N') goto yy1106;
	if (yych == 'n') goto yy1106;
	goto yy37;
yy1028:
	yych = *++cur;
	if (yych == 'E') goto yy1107;
	if (yych == 'e') goto yy1107;
	goto yy37;
yy1029:
	yych = *++cur;
	if (yych == 'R') goto yy1108;
	if (yych == 'r') goto yy1108;
	goto yy37;
yy1030:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 514 "parser/tokenizer.re"
	{ KW(SYNC_TEAM) }
#line 8116 "parser/tokenizer.cpp"
yy1031:
	yych = *++cur;
	if (yych == 'B') goto yy1109;
	if (yych == 'b') goto yy1109;
	goto yy37;
yy1032:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 518 "parser/tokenizer.re"
	{ KW(TEMPLATE) }
#line 8130 "parser/tokenizer.cpp"
yy1033:
	yych = *++cur;
	if (yych == 'T') goto yy1110;
	if (yych == 't') goto yy1110;
	goto yy37;
yy1034:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 525 "parser/tokenizer.re"
	{ KW(VOLATILE) }
#line 8144 "parser/tokenizer.cpp"
yy1035:
	yych = *++cur;
	if (yych == 'N') goto yy1111;
	if (yych == 'n') goto yy1111;
	goto yy37;
yy1036:
	yych = *++cur;
	if (yych <= 0x00) goto yy62;
	if (yych == '\n') goto yy1112;
	goto yy1036;
yy1037:
	++cur;
#line 739 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#define ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 8165 "parser/tokenizer.cpp"
yy1038:
	yych = *++cur;
	if (yych <= 0x00) goto yy62;
	if (yych == '\n') goto yy1113;
	goto yy1038;
yy1039:
	yych = *++cur;
	if (yych <= '/') goto yy828;
	if (yych <= '9') goto yy1039;
	goto yy828;
yy1040:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy828;
		if (yych <= '9') goto yy1040;
		if (yych <= '@') goto yy828;
		goto yy1040;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy828;
			goto yy1040;
		} else {
			if (yych <= '`') goto yy828;
			if (yych <= 'z') goto yy1040;
			goto yy828;
		}
	}
yy1041:
	yych = *++cur;
	if (yych == 'L') goto yy1114;
	if (yych == 'l') goto yy1114;
	goto yy37;
yy1042:
	yych = *++cur;
	if (yych == 'T') goto yy1115;
	if (yych == 't') goto yy1115;
	goto yy37;
yy1043:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 285 "parser/tokenizer.re"
	{ KW(ASSOCIATE) }
#line 8211 "parser/tokenizer.cpp"
yy1044:
	yych = *++cur;
	if (yych == 'O') goto yy1116;
	if (yych == 'o') goto yy1116;
	goto yy37;
yy1045:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 287 "parser/tokenizer.re"
	{ KW(BACKSPACE) }
#line 8225 "parser/tokenizer.cpp"
yy1046:
	yych = *++cur;
	if (yych == 'M') goto yy1117;
	if (yych == 'm') goto yy1117;
	goto yy37;
yy1047:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 294 "parser/tokenizer.re"
	{ KW(CHARACTER) }
#line 8239 "parser/tokenizer.cpp"
yy1048:
	yych = *++cur;
	if (yych == 'O') goto yy1118;
	if (yych == 'o') goto yy1118;
	goto yy37;
yy1049:
	yych = *++cur;
	if (yych == 'T') goto yy1119;
	if (yych == 't') goto yy1119;
	goto yy37;
yy1050:
	yych = *++cur;
	if (yych == 'S') goto yy1120;
	if (yych == 's') goto yy1120;
	goto yy37;
yy1051:
	yych = *++cur;
	if (yych == 'E') goto yy1121;
	if (yych == 'e') goto yy1121;
	goto yy37;
yy1052:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 310 "parser/tokenizer.re"
	{ KW(DIMENSION) }
#line 8268 "parser/tokenizer.cpp"
yy1053:
	yych = *++cur;
	if (yych == 'P') goto yy1122;
	if (yych == 'p') goto yy1122;
	goto yy37;
yy1054:
	yych = *++cur;
	if (yych == 'C') goto yy1123;
	if (yych == 'c') goto yy1123;
	goto yy37;
yy1055:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 323 "parser/tokenizer.re"
	{ KW(ELEMENTAL) }
#line 8287 "parser/tokenizer.cpp"
yy1056:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 326 "parser/tokenizer.re"
	{ KW(ELSEWHERE) }
#line 8296 "parser/tokenizer.cpp"
yy1057:
	yych = *++cur;
	if (yych == 'I') goto yy1124;
	if (yych == 'i') goto yy1124;
	goto yy62;
yy1058:
	yyaccept = 14;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1125;
		} else {
			if (yych != '\f') goto yy1125;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1125;
		} else {
			if (yych <= 'D') goto yy1126;
			if (yych == 'd') goto yy1126;
		}
	}
yy1059:
#line 339 "parser/tokenizer.re"
	{ KW(END_BLOCK) }
#line 8322 "parser/tokenizer.cpp"
yy1060:
	yych = *++cur;
	if (yych == 'C') goto yy1127;
	if (yych == 'c') goto yy1127;
	goto yy62;
yy1061:
	yych = *++cur;
	if (yych == 'L') goto yy1128;
	if (yych == 'l') goto yy1128;
	goto yy62;
yy1062:
	yych = *++cur;
	if (yych == 'I') goto yy1129;
	if (yych == 'i') goto yy1129;
	goto yy62;
yy1063:
	yych = *++cur;
	if (yych == 'F') goto yy1130;
	if (yych == 'f') goto yy1130;
	goto yy62;
yy1064:
	yych = *++cur;
	if (yych == 'E') goto yy1131;
	if (yych == 'e') goto yy1131;
	goto yy62;
yy1065:
	yych = *++cur;
	if (yych == 'D') goto yy1132;
	if (yych == 'd') goto yy1132;
	goto yy62;
yy1066:
	yych = *++cur;
	if (yych == 'A') goto yy1133;
	if (yych == 'a') goto yy1133;
	goto yy62;
yy1067:
	yych = *++cur;
	if (yych == 'T') goto yy1134;
	if (yych == 't') goto yy1134;
	goto yy62;
yy1068:
	yych = *++cur;
	if (yych == 'D') goto yy1135;
	if (yych == 'd') goto yy1135;
	goto yy62;
yy1069:
	yych = *++cur;
	if (yych == 'U') goto yy1136;
	if (yych == 'u') goto yy1136;
	goto yy62;
yy1070:
	++cur;
#line 398 "parser/tokenizer.re"
	{ KW(END_WHERE) }
#line 8377 "parser/tokenizer.cpp"
yy1071:
	yych = *++cur;
	if (yych == 'T') goto yy1137;
	if (yych == 't') goto yy1137;
	goto yy62;
yy1072:
	yych = *++cur;
	if (yych == 'A') goto yy1138;
	if (yych == 'a') goto yy1138;
	goto yy37;
yy1073:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1073;
			goto yy62;
		} else {
			if (yych == '\f') goto yy62;
			goto yy1073;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1073;
			goto yy62;
		} else {
			if (yych <= 'D') goto yy1139;
			if (yych == 'd') goto yy1139;
			goto yy62;
		}
	}
yy1074:
	yych = *++cur;
	if (yych == 'A') goto yy1140;
	if (yych == 'a') goto yy1140;
	goto yy37;
yy1075:
	yych = *++cur;
	if (yych == 'A') goto yy1141;
	if (yych == 'a') goto yy1141;
	goto yy37;
yy1076:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 372 "parser/tokenizer.re"
	{ KW(ENDFORALL) }
#line 8426 "parser/tokenizer.cpp"
yy1077:
	yych = *++cur;
	if (yych == 'O') goto yy1142;
	if (yych == 'o') goto yy1142;
	goto yy37;
yy1078:
	yych = *++cur;
	if (yych == 'A') goto yy1143;
	if (yych == 'a') goto yy1143;
	goto yy37;
yy1079:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 334 "parser/tokenizer.re"
	{ KW(ENDMODULE) }
#line 8445 "parser/tokenizer.cpp"
yy1080:
	yych = *++cur;
	if (yych == 'U') goto yy1144;
	if (yych == 'u') goto yy1144;
	goto yy37;
yy1081:
	yych = *++cur;
	if (yych == 'M') goto yy1145;
	if (yych == 'm') goto yy1145;
	goto yy37;
yy1082:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 360 "parser/tokenizer.re"
	{ KW(ENDSELECT) }
#line 8464 "parser/tokenizer.cpp"
yy1083:
	yych = *++cur;
	if (yych == 'U') goto yy1146;
	if (yych == 'u') goto yy1146;
	goto yy37;
yy1084:
	yych = *++cur;
	if (yych == 'T') goto yy1147;
	if (yych == 't') goto yy1147;
	goto yy37;
yy1085:
	yych = *++cur;
	if (yych == 'R') goto yy1148;
	if (yych == 'r') goto yy1148;
	goto yy37;
yy1086:
	yych = *++cur;
	if (yych == 'C') goto yy1149;
	if (yych == 'c') goto yy1149;
	goto yy37;
yy1087:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 430 "parser/tokenizer.re"
	{ KW(FORMATTED) }
#line 8493 "parser/tokenizer.cpp"
yy1088:
	yych = *++cur;
	if (yych == 'T') goto yy1150;
	if (yych == 't') goto yy1150;
	goto yy37;
yy1089:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 450 "parser/tokenizer.re"
	{ KW(INTERFACE) }
#line 8507 "parser/tokenizer.cpp"
yy1090:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 451 "parser/tokenizer.re"
	{ KW(INTRINSIC) }
#line 8516 "parser/tokenizer.cpp"
yy1091:
	yych = *++cur;
	if (yych == 'T') goto yy1151;
	if (yych == 't') goto yy1151;
	goto yy37;
yy1092:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 463 "parser/tokenizer.re"
	{ KW(NEW_INDEX) }
#line 8530 "parser/tokenizer.cpp"
yy1093:
	yych = *++cur;
	if (yych == 'N') goto yy1152;
	if (yych == 'n') goto yy1152;
	goto yy37;
yy1094:
	yych = *++cur;
	if (yych == 'I') goto yy1153;
	if (yych == 'i') goto yy1153;
	goto yy37;
yy1095:
	yych = *++cur;
	if (yych == 'S') goto yy1154;
	if (yych == 's') goto yy1154;
	goto yy37;
yy1096:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 475 "parser/tokenizer.re"
	{ KW(PARAMETER) }
#line 8554 "parser/tokenizer.cpp"
yy1097:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 479 "parser/tokenizer.re"
	{ KW(PRECISION) }
#line 8563 "parser/tokenizer.cpp"
yy1098:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 482 "parser/tokenizer.re"
	{ KW(PROCEDURE) }
#line 8572 "parser/tokenizer.cpp"
yy1099:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 484 "parser/tokenizer.re"
	{ KW(PROTECTED) }
#line 8581 "parser/tokenizer.cpp"
yy1100:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 491 "parser/tokenizer.re"
	{ KW(RECURSIVE) }
#line 8590 "parser/tokenizer.cpp"
yy1101:
	yych = *++cur;
	if (yych == 'N') goto yy1155;
	if (yych == 'n') goto yy1155;
	goto yy37;
yy1102:
	yych = *++cur;
	if (yych == 'E') goto yy1156;
	if (yych == 'e') goto yy1156;
	goto yy37;
yy1103:
	yych = *++cur;
	if (yych == 'K') goto yy1157;
	if (yych == 'k') goto yy1157;
	goto yy37;
yy1104:
	yych = *++cur;
	if (yych == 'E') goto yy1158;
	if (yych == 'e') goto yy1158;
	goto yy37;
yy1105:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 508 "parser/tokenizer.re"
	{ KW(SUBMODULE) }
#line 8619 "parser/tokenizer.cpp"
yy1106:
	yych = *++cur;
	if (yych == 'E') goto yy1159;
	if (yych == 'e') goto yy1159;
	goto yy37;
yy1107:
	yych = *++cur;
	if (yych == 'S') goto yy1160;
	if (yych == 's') goto yy1160;
	goto yy37;
yy1108:
	yych = *++cur;
	if (yych == 'Y') goto yy1161;
	if (yych == 'y') goto yy1161;
	goto yy37;
yy1109:
	yych = *++cur;
	if (yych == 'E') goto yy1162;
	if (yych == 'e') goto yy1162;
	goto yy37;
yy1110:
	yych = *++cur;
	if (yych == 'E') goto yy1163;
	if (yych == 'e') goto yy1163;
	goto yy37;
yy1111:
	yych = *++cur;
	if (yych == '_') goto yy1164;
	goto yy37;
yy1112:
	++cur;
	cur -= 1;
#line 683 "parser/tokenizer.re"
	{
                if (!openmp_enabled) {
                    TK_TRIVIA(TK_COMMENT)
                }
                TK_TRIVIA(TK_OMP_END)
            }
#line 8659 "parser/tokenizer.cpp"
yy1113:
	++cur;
#line 746 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#include ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 8670 "parser/tokenizer.cpp"
yy1114:
	yych = *++cur;
	if (yych == 'E') goto yy1165;
	if (yych == 'e') goto yy1165;
	goto yy37;
yy1115:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 284 "parser/tokenizer.re"
	{ KW(ASSIGNMENT) }
#line 8684 "parser/tokenizer.cpp"
yy1116:
	yych = *++cur;
	if (yych == 'U') goto yy1166;
	if (yych == 'u') goto yy1166;
	goto yy37;
yy1117:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 293 "parser/tokenizer.re"
	{ KW(CHANGE_TEAM) }
#line 8698 "parser/tokenizer.cpp"
yy1118:
	yych = *++cur;
	if (yych == 'N') goto yy1167;
	if (yych == 'n') goto yy1167;
	goto yy37;
yy1119:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 300 "parser/tokenizer.re"
	{ KW(CONCURRENT) }
#line 8712 "parser/tokenizer.cpp"
yy1120:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 302 "parser/tokenizer.re"
	{ KW(CONTIGUOUS) }
#line 8721 "parser/tokenizer.cpp"
yy1121:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 307 "parser/tokenizer.re"
	{ KW(DEALLOCATE) }
#line 8730 "parser/tokenizer.cpp"
yy1122:
	yych = *++cur;
	if (yych == 'L') goto yy1168;
	if (yych == 'l') goto yy1168;
	goto yy37;
yy1123:
	yych = *++cur;
	if (yych == 'I') goto yy1169;
	if (yych == 'i') goto yy1169;
	goto yy37;
yy1124:
	yych = *++cur;
	if (yych == 'A') goto yy1170;
	if (yych == 'a') goto yy1170;
	goto yy62;
yy1125:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1125;
			goto yy62;
		} else {
			if (yych == '\f') goto yy62;
			goto yy1125;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1125;
			goto yy62;
		} else {
			if (yych <= 'D') goto yy1171;
			if (yych == 'd') goto yy1171;
			goto yy62;
		}
	}
yy1126:
	yych = *++cur;
	if (yych == 'A') goto yy1172;
	if (yych == 'a') goto yy1172;
	goto yy62;
yy1127:
	yych = *++cur;
	if (yych == 'A') goto yy1173;
	if (yych == 'a') goto yy1173;
	goto yy62;
yy1128:
	++cur;
#line 371 "parser/tokenizer.re"
	{ KW(END_FORALL) }
#line 8780 "parser/tokenizer.cpp"
yy1129:
	yych = *++cur;
	if (yych == 'O') goto yy1174;
	if (yych == 'o') goto yy1174;
	goto yy62;
yy1130:
	yych = *++cur;
	if (yych == 'A') goto yy1175;
	if (yych == 'a') goto yy1175;
	goto yy62;
yy1131:
	++cur;
#line 333 "parser/tokenizer.re"
	{ KW(END_MODULE) }
#line 8795 "parser/tokenizer.cpp"
yy1132:
	yych = *++cur;
	if (yych == 'U') goto yy1176;
	if (yych == 'u') goto yy1176;
	goto yy62;
yy1133:
	yych = *++cur;
	if (yych == 'M') goto yy1177;
	if (yych == 'm') goto yy1177;
	goto yy62;
yy1134:
	++cur;
#line 359 "parser/tokenizer.re"
	{ KW(END_SELECT) }
#line 8810 "parser/tokenizer.cpp"
yy1135:
	yych = *++cur;
	if (yych == 'U') goto yy1178;
	if (yych == 'u') goto yy1178;
	goto yy62;
yy1136:
	yych = *++cur;
	if (yych == 'T') goto yy1179;
	if (yych == 't') goto yy1179;
	goto yy62;
yy1137:
	yych = *++cur;
	if (yych == 'R') goto yy1180;
	if (yych == 'r') goto yy1180;
	goto yy62;
yy1138:
	yych = *++cur;
	if (yych == 'T') goto yy1181;
	if (yych == 't') goto yy1181;
	goto yy37;
yy1139:
	yych = *++cur;
	if (yych == 'A') goto yy1182;
	if (yych == 'a') goto yy1182;
	goto yy62;
yy1140:
	yych = *++cur;
	if (yych == 'T') goto yy1183;
	if (yych == 't') goto yy1183;
	goto yy37;
yy1141:
	yych = *++cur;
	if (yych == 'L') goto yy1184;
	if (yych == 'l') goto yy1184;
	goto yy37;
yy1142:
	yych = *++cur;
	if (yych == 'N') goto yy1185;
	if (yych == 'n') goto yy1185;
	goto yy37;
yy1143:
	yych = *++cur;
	if (yych == 'C') goto yy1186;
	if (yych == 'c') goto yy1186;
	goto yy37;
yy1144:
	yych = *++cur;
	if (yych == 'R') goto yy1187;
	if (yych == 'r') goto yy1187;
	goto yy37;
yy1145:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 331 "parser/tokenizer.re"
	{ KW(ENDPROGRAM) }
#line 8869 "parser/tokenizer.cpp"
yy1146:
	yych = *++cur;
	if (yych == 'L') goto yy1188;
	if (yych == 'l') goto yy1188;
	goto yy37;
yy1147:
	yych = *++cur;
	if (yych == 'I') goto yy1189;
	if (yych == 'i') goto yy1189;
	goto yy37;
yy1148:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 406 "parser/tokenizer.re"
	{ KW(ENUMERATOR) }
#line 8888 "parser/tokenizer.cpp"
yy1149:
	yych = *++cur;
	if (yych == 'E') goto yy1190;
	if (yych == 'e') goto yy1190;
	goto yy37;
yy1150:
	yych = *++cur;
	if (yych == 'E') goto yy1191;
	if (yych == 'e') goto yy1191;
	goto yy37;
yy1151:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 456 "parser/tokenizer.re"
	{ KW(LOCAL_INIT) }
#line 8907 "parser/tokenizer.cpp"
yy1152:
	yych = *++cur;
	if (yych == 'S') goto yy1192;
	if (yych == 's') goto yy1192;
	goto yy37;
yy1153:
	yych = *++cur;
	if (yych == 'D') goto yy1193;
	if (yych == 'd') goto yy1193;
	goto yy37;
yy1154:
	yych = *++cur;
	if (yych == 'I') goto yy1194;
	if (yych == 'i') goto yy1194;
	goto yy37;
yy1155:
	yych = *++cur;
	if (yych == 'T') goto yy1195;
	if (yych == 't') goto yy1195;
	goto yy37;
yy1156:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 500 "parser/tokenizer.re"
	{ KW(SELECT_CASE) }
#line 8936 "parser/tokenizer.cpp"
yy1157:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 501 "parser/tokenizer.re"
	{ KW(SELECT_RANK) }
#line 8945 "parser/tokenizer.cpp"
yy1158:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 502 "parser/tokenizer.re"
	{ KW(SELECT_TYPE) }
#line 8954 "parser/tokenizer.cpp"
yy1159:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 509 "parser/tokenizer.re"
	{ KW(SUBROUTINE) }
#line 8963 "parser/tokenizer.cpp"
yy1160:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 512 "parser/tokenizer.re"
	{ KW(SYNC_IMAGES) }
#line 8972 "parser/tokenizer.cpp"
yy1161:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 513 "parser/tokenizer.re"
	{ KW(SYNC_MEMORY) }
#line 8981 "parser/tokenizer.cpp"
yy1162:
	yych = *++cur;
	if (yych == 'R') goto yy1196;
	if (yych == 'r') goto yy1196;
	goto yy37;
yy1163:
	yych = *++cur;
	if (yych == 'D') goto yy1197;
	if (yych == 'd') goto yy1197;
	goto yy37;
yy1164:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'S') {
		if (yych <= 'C') {
			if (yych <= '"') {
				if (yych <= '!') goto yy37;
				goto yy66;
			} else {
				if (yych == '\'') goto yy83;
				goto yy37;
			}
		} else {
			if (yych <= 'K') {
				if (yych <= 'D') goto yy1198;
				goto yy37;
			} else {
				if (yych <= 'L') goto yy1199;
				if (yych <= 'R') goto yy37;
				goto yy1200;
			}
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'U') {
				if (yych <= 'T') goto yy1201;
				goto yy1202;
			} else {
				if (yych == 'd') goto yy1198;
				goto yy37;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'l') goto yy1199;
				if (yych <= 'r') goto yy37;
				goto yy1200;
			} else {
				if (yych <= 't') goto yy1201;
				if (yych <= 'u') goto yy1202;
				goto yy37;
			}
		}
	}
yy1165:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 281 "parser/tokenizer.re"
	{ KW(ALLOCATABLE) }
#line 9043 "parser/tokenizer.cpp"
yy1166:
	yych = *++cur;
	if (yych == 'S') goto yy1203;
	if (yych == 's') goto yy1203;
	goto yy37;
yy1167:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 297 "parser/tokenizer.re"
	{ KW(CODIMENSION) }
#line 9057 "parser/tokenizer.cpp"
yy1168:
	yych = *++cur;
	if (yych == 'E') goto yy1204;
	if (yych == 'e') goto yy1204;
	goto yy37;
yy1169:
	yych = *++cur;
	if (yych == 'S') goto yy1205;
	if (yych == 's') goto yy1205;
	goto yy37;
yy1170:
	yych = *++cur;
	if (yych == 'T') goto yy1206;
	if (yych == 't') goto yy1206;
	goto yy62;
yy1171:
	yych = *++cur;
	if (yych == 'A') goto yy1207;
	if (yych == 'a') goto yy1207;
	goto yy62;
yy1172:
	yych = *++cur;
	if (yych == 'T') goto yy1208;
	if (yych == 't') goto yy1208;
	goto yy62;
yy1173:
	yych = *++cur;
	if (yych == 'L') goto yy1209;
	if (yych == 'l') goto yy1209;
	goto yy62;
yy1174:
	yych = *++cur;
	if (yych == 'N') goto yy1210;
	if (yych == 'n') goto yy1210;
	goto yy62;
yy1175:
	yych = *++cur;
	if (yych == 'C') goto yy1211;
	if (yych == 'c') goto yy1211;
	goto yy62;
yy1176:
	yych = *++cur;
	if (yych == 'R') goto yy1212;
	if (yych == 'r') goto yy1212;
	goto yy62;
yy1177:
	++cur;
#line 330 "parser/tokenizer.re"
	{ KW(END_PROGRAM) }
#line 9107 "parser/tokenizer.cpp"
yy1178:
	yych = *++cur;
	if (yych == 'L') goto yy1213;
	if (yych == 'l') goto yy1213;
	goto yy62;
yy1179:
	yych = *++cur;
	if (yych == 'I') goto yy1214;
	if (yych == 'i') goto yy1214;
	goto yy62;
yy1180:
	yych = *++cur;
	if (yych == 'A') goto yy1215;
	if (yych == 'a') goto yy1215;
	goto yy62;
yy1181:
	yych = *++cur;
	if (yych == 'E') goto yy1216;
	if (yych == 'e') goto yy1216;
	goto yy37;
yy1182:
	yych = *++cur;
	if (yych == 'T') goto yy1217;
	if (yych == 't') goto yy1217;
	goto yy62;
yy1183:
	yych = *++cur;
	if (yych == 'A') goto yy1218;
	if (yych == 'a') goto yy1218;
	goto yy37;
yy1184:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 366 "parser/tokenizer.re"
	{ KW(ENDCRITICAL) }
#line 9146 "parser/tokenizer.cpp"
yy1185:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 351 "parser/tokenizer.re"
	{ KW(ENDFUNCTION) }
#line 9155 "parser/tokenizer.cpp"
yy1186:
	yych = *++cur;
	if (yych == 'E') goto yy1219;
	if (yych == 'e') goto yy1219;
	goto yy37;
yy1187:
	yych = *++cur;
	if (yych == 'E') goto yy1220;
	if (yych == 'e') goto yy1220;
	goto yy37;
yy1188:
	yych = *++cur;
	if (yych == 'E') goto yy1221;
	if (yych == 'e') goto yy1221;
	goto yy37;
yy1189:
	yych = *++cur;
	if (yych == 'N') goto yy1222;
	if (yych == 'n') goto yy1222;
	goto yy37;
yy1190:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 407 "parser/tokenizer.re"
	{ KW(EQUIVALENCE) }
#line 9184 "parser/tokenizer.cpp"
yy1191:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 447 "parser/tokenizer.re"
	{ KW(INSTANTIATE) }
#line 9193 "parser/tokenizer.cpp"
yy1192:
	yych = *++cur;
	if (yych == 'I') goto yy1223;
	if (yych == 'i') goto yy1223;
	goto yy37;
yy1193:
	yych = *++cur;
	if (yych == 'A') goto yy1224;
	if (yych == 'a') goto yy1224;
	goto yy37;
yy1194:
	yych = *++cur;
	if (yych == 'V') goto yy1225;
	if (yych == 'v') goto yy1225;
	goto yy37;
yy1195:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 493 "parser/tokenizer.re"
	{ KW(REQUIREMENT) }
#line 9217 "parser/tokenizer.cpp"
yy1196:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 517 "parser/tokenizer.re"
	{ KW(TEAM_NUMBER) }
#line 9226 "parser/tokenizer.cpp"
yy1197:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 522 "parser/tokenizer.re"
	{ KW(UNFORMATTED) }
#line 9235 "parser/tokenizer.cpp"
yy1198:
	yych = *++cur;
	if (yych == 'I') goto yy1226;
	if (yych == 'i') goto yy1226;
	goto yy37;
yy1199:
	yych = *++cur;
	if (yych == 'I') goto yy1227;
	if (yych == 'i') goto yy1227;
	goto yy37;
yy1200:
	yych = *++cur;
	if (yych == 'E') goto yy1228;
	if (yych == 'e') goto yy1228;
	goto yy37;
yy1201:
	yych = *++cur;
	if (yych == 'U') goto yy1229;
	if (yych == 'u') goto yy1229;
	goto yy37;
yy1202:
	yych = *++cur;
	if (yych == 'N') goto yy1230;
	if (yych == 'n') goto yy1230;
	goto yy37;
yy1203:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 286 "parser/tokenizer.re"
	{ KW(ASYNCHRONOUS) }
#line 9269 "parser/tokenizer.cpp"
yy1204:
	yych = *++cur;
	if (yych == 'X') goto yy1231;
	if (yych == 'x') goto yy1231;
	goto yy37;
yy1205:
	yych = *++cur;
	if (yych == 'I') goto yy1232;
	if (yych == 'i') goto yy1232;
	goto yy37;
yy1206:
	yych = *++cur;
	if (yych == 'E') goto yy1233;
	if (yych == 'e') goto yy1233;
	goto yy62;
yy1207:
	yych = *++cur;
	if (yych == 'T') goto yy1234;
	if (yych == 't') goto yy1234;
	goto yy62;
yy1208:
	yych = *++cur;
	if (yych == 'A') goto yy1235;
	if (yych == 'a') goto yy1235;
	goto yy62;
yy1209:
	++cur;
#line 365 "parser/tokenizer.re"
	{ KW(END_CRITICAL) }
#line 9299 "parser/tokenizer.cpp"
yy1210:
	++cur;
#line 350 "parser/tokenizer.re"
	{ KW(END_FUNCTION) }
#line 9304 "parser/tokenizer.cpp"
yy1211:
	yych = *++cur;
	if (yych == 'E') goto yy1236;
	if (yych == 'e') goto yy1236;
	goto yy62;
yy1212:
	yych = *++cur;
	if (yych == 'E') goto yy1237;
	if (yych == 'e') goto yy1237;
	goto yy62;
yy1213:
	yych = *++cur;
	if (yych == 'E') goto yy1238;
	if (yych == 'e') goto yy1238;
	goto yy62;
yy1214:
	yych = *++cur;
	if (yych == 'N') goto yy1239;
	if (yych == 'n') goto yy1239;
	goto yy62;
yy1215:
	yych = *++cur;
	if (yych == 'N') goto yy1240;
	if (yych == 'n') goto yy1240;
	goto yy62;
yy1216:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 363 "parser/tokenizer.re"
	{ KW(ENDASSOCIATE) }
#line 9338 "parser/tokenizer.cpp"
yy1217:
	yych = *++cur;
	if (yych == 'A') goto yy1241;
	if (yych == 'a') goto yy1241;
	goto yy62;
yy1218:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 345 "parser/tokenizer.re"
	{ KW(ENDBLOCKDATA) }
#line 9352 "parser/tokenizer.cpp"
yy1219:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 378 "parser/tokenizer.re"
	{ KW(ENDINTERFACE) }
#line 9361 "parser/tokenizer.cpp"
yy1220:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 354 "parser/tokenizer.re"
	{ KW(ENDPROCEDURE) }
#line 9370 "parser/tokenizer.cpp"
yy1221:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 337 "parser/tokenizer.re"
	{ KW(ENDSUBMODULE) }
#line 9379 "parser/tokenizer.cpp"
yy1222:
	yych = *++cur;
	if (yych == 'E') goto yy1242;
	if (yych == 'e') goto yy1242;
	goto yy37;
yy1223:
	yych = *++cur;
	if (yych == 'C') goto yy1243;
	if (yych == 'c') goto yy1243;
	goto yy37;
yy1224:
	yych = *++cur;
	if (yych == 'B') goto yy1244;
	if (yych == 'b') goto yy1244;
	goto yy37;
yy1225:
	yych = *++cur;
	if (yych == 'E') goto yy1245;
	if (yych == 'e') goto yy1245;
	goto yy37;
yy1226:
	yych = *++cur;
	if (yych == 'C') goto yy1246;
	if (yych == 'c') goto yy1246;
	goto yy37;
yy1227:
	yych = *++cur;
	if (yych == 'S') goto yy1247;
	if (yych == 's') goto yy1247;
	goto yy37;
yy1228:
	yych = *++cur;
	if (yych == 'T') goto yy1248;
	if (yych == 't') goto yy1248;
	goto yy37;
yy1229:
	yych = *++cur;
	if (yych == 'P') goto yy1249;
	if (yych == 'p') goto yy1249;
	goto yy37;
yy1230:
	yych = *++cur;
	if (yych == 'I') goto yy1250;
	if (yych == 'i') goto yy1250;
	goto yy37;
yy1231:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 322 "parser/tokenizer.re"
	{ KW(DOUBLE_COMPLEX) }
#line 9433 "parser/tokenizer.cpp"
yy1232:
	yych = *++cur;
	if (yych == 'O') goto yy1251;
	if (yych == 'o') goto yy1251;
	goto yy37;
yy1233:
	++cur;
#line 362 "parser/tokenizer.re"
	{ KW(END_ASSOCIATE) }
#line 9443 "parser/tokenizer.cpp"
yy1234:
	yych = *++cur;
	if (yych == 'A') goto yy1252;
	if (yych == 'a') goto yy1252;
	goto yy62;
yy1235:
	++cur;
#line 344 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 9453 "parser/tokenizer.cpp"
yy1236:
	++cur;
#line 377 "parser/tokenizer.re"
	{ KW(END_INTERFACE) }
#line 9458 "parser/tokenizer.cpp"
yy1237:
	++cur;
#line 353 "parser/tokenizer.re"
	{ KW(END_PROCEDURE) }
#line 9463 "parser/tokenizer.cpp"
yy1238:
	++cur;
#line 336 "parser/tokenizer.re"
	{ KW(END_SUBMODULE) }
#line 9468 "parser/tokenizer.cpp"
yy1239:
	yych = *++cur;
	if (yych == 'E') goto yy1253;
	if (yych == 'e') goto yy1253;
	goto yy62;
yy1240:
	yych = *++cur;
	if (yych == '_') goto yy1254;
	goto yy62;
yy1241:
	++cur;
#line 343 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 9482 "parser/tokenizer.cpp"
yy1242:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 348 "parser/tokenizer.re"
	{ KW(ENDSUBROUTINE) }
#line 9491 "parser/tokenizer.cpp"
yy1243:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 465 "parser/tokenizer.re"
	{ KW(NON_INTRINSIC) }
#line 9500 "parser/tokenizer.cpp"
yy1244:
	yych = *++cur;
	if (yych == 'L') goto yy1255;
	if (yych == 'l') goto yy1255;
	goto yy37;
yy1245:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 467 "parser/tokenizer.re"
	{ KW(NON_RECURSIVE) }
#line 9514 "parser/tokenizer.cpp"
yy1246:
	yych = *++cur;
	if (yych == 'T') goto yy1256;
	if (yych == 't') goto yy1256;
	goto yy37;
yy1247:
	yych = *++cur;
	if (yych == 'T') goto yy1257;
	if (yych == 't') goto yy1257;
	goto yy37;
yy1248:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 531 "parser/tokenizer.re"
	{ KW(SET) }
#line 9533 "parser/tokenizer.cpp"
yy1249:
	yych = *++cur;
	if (yych == 'L') goto yy1258;
	if (yych == 'l') goto yy1258;
	goto yy37;
yy1250:
	yych = *++cur;
	if (yych == 'O') goto yy1259;
	if (yych == 'o') goto yy1259;
	goto yy37;
yy1251:
	yych = *++cur;
	if (yych == 'N') goto yy1260;
	if (yych == 'n') goto yy1260;
	goto yy37;
yy1252:
	++cur;
#line 342 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 9553 "parser/tokenizer.cpp"
yy1253:
	++cur;
#line 347 "parser/tokenizer.re"
	{ KW(END_SUBROUTINE) }
#line 9558 "parser/tokenizer.cpp"
yy1254:
	yych = *++cur;
	if (yych == 'U') goto yy1261;
	if (yych == 'u') goto yy1261;
	goto yy62;
yy1255:
	yych = *++cur;
	if (yych == 'E') goto yy1262;
	if (yych == 'e') goto yy1262;
	goto yy37;
yy1256:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 532 "parser/tokenizer.re"
	{ KW(DICT) }
#line 9577 "parser/tokenizer.cpp"
yy1257:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 530 "parser/tokenizer.re"
	{ KW(LIST) }
#line 9586 "parser/tokenizer.cpp"
yy1258:
	yych = *++cur;
	if (yych == 'E') goto yy1263;
	if (yych == 'e') goto yy1263;
	goto yy37;
yy1259:
	yych = *++cur;
	if (yych == 'N') goto yy1264;
	if (yych == 'n') goto yy1264;
	goto yy37;
yy1260:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 321 "parser/tokenizer.re"
	{ KW(DOUBLE_PRECISION) }
#line 9605 "parser/tokenizer.cpp"
yy1261:
	yych = *++cur;
	if (yych == 'N') goto yy1265;
	if (yych == 'n') goto yy1265;
	goto yy62;
yy1262:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 466 "parser/tokenizer.re"
	{ KW(NON_OVERRIDABLE) }
#line 9619 "parser/tokenizer.cpp"
yy1263:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 533 "parser/tokenizer.re"
	{ KW(TUPLE) }
#line 9628 "parser/tokenizer.cpp"
yy1264:
	yych = *++cur;
	if (yych == '_') goto yy1266;
	goto yy37;
yy1265:
	yych = *++cur;
	if (yych == 'I') goto yy1267;
	if (yych == 'i') goto yy1267;
	goto yy62;
yy1266:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy66;
		if (yych <= '&') goto yy37;
		goto yy83;
	} else {
		if (yych <= 'T') {
			if (yych <= 'S') goto yy37;
			goto yy1268;
		} else {
			if (yych == 't') goto yy1268;
			goto yy37;
		}
	}
yy1267:
	yych = *++cur;
	if (yych == 'O') goto yy1269;
	if (yych == 'o') goto yy1269;
	goto yy62;
yy1268:
	yych = *++cur;
	if (yych == 'Y') goto yy1270;
	if (yych == 'y') goto yy1270;
	goto yy37;
yy1269:
	yych = *++cur;
	if (yych == 'N') goto yy1271;
	if (yych == 'n') goto yy1271;
	goto yy62;
yy1270:
	yych = *++cur;
	if (yych == 'P') goto yy1272;
	if (yych == 'p') goto yy1272;
	goto yy37;
yy1271:
	yych = *++cur;
	if (yych == '_') goto yy1273;
	goto yy62;
yy1272:
	yych = *++cur;
	if (yych == 'E') goto yy1274;
	if (yych == 'e') goto yy1274;
	goto yy37;
yy1273:
	yych = *++cur;
	if (yych == 'T') goto yy1275;
	if (yych == 't') goto yy1275;
	goto yy62;
yy1274:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy118;
#line 534 "parser/tokenizer.re"
	{ KW(UNION_TYPE) }
#line 9696 "parser/tokenizer.cpp"
yy1275:
	yych = *++cur;
	if (yych == 'Y') goto yy1276;
	if (yych != 'y') goto yy62;
yy1276:
	yych = *++cur;
	if (yych == 'P') goto yy1277;
	if (yych != 'p') goto yy62;
yy1277:
	yych = *++cur;
	if (yych == 'E') goto yy1278;
	if (yych != 'e') goto yy62;
yy1278:
	++cur;
#line 536 "parser/tokenizer.re"
	{ KW(END_UNION_TYPE) }
#line 9713 "parser/tokenizer.cpp"
}
#line 767 "parser/tokenizer.re"

    }
}

std::string token(unsigned char *tok, unsigned char* cur)
{
    return std::string((char *)tok, cur - tok);
}

void token_loc(Location &loc, unsigned char *cur, unsigned char *tok, unsigned char *string_start)
{
    loc.first = tok-string_start;
    loc.last = cur-string_start-1;
}

void lex_format(unsigned char *&cur, Location &loc,
        unsigned char *&start, diag::Diagnostics &diagnostics, bool continue_compilation, unsigned char *&string_start) {
    int num_paren = 0;
    for (;;) {
        unsigned char *tok = cur;
        unsigned char *mar;
        
#line 9738 "parser/tokenizer.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,  52,  52,  52,  52,  52,  52,  52, 
		 52, 190,  44, 190,  52, 190,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		190,  52,  48,  52,  52,  52,  52,  20, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		244, 244, 244, 244, 244, 244, 244, 244, 
		244, 244,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
	};
	yych = *cur;
	if (yybm[0+yych] & 2) {
		goto yy1283;
	}
	switch (yych) {
		case 0x00: goto yy1280;
		case '"': goto yy1285;
		case '&': goto yy1286;
		case '\'': goto yy1287;
		case '(': goto yy1288;
		case ')': goto yy1289;
		case '*': goto yy1290;
		case '+':
		case '-': goto yy1291;
		case ',': goto yy1292;
		case '/':
		case ':': goto yy1293;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1295;
		case 'A':
		case 'a': goto yy1296;
		case 'B':
		case 'b': goto yy1298;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1299;
		case 'E':
		case 'e': goto yy1300;
		case 'G':
		case 'g': goto yy1301;
		case 'I':
		case 'O':
		case 'Z':
		case 'i':
		case 'o':
		case 'z': goto yy1302;
		case 'L':
		case 'l': goto yy1303;
		case 'P':
		case 'p': goto yy1304;
		case 'R':
		case 'r': goto yy1305;
		case 'S':
		case 's': goto yy1306;
		case 'T':
		case 't': goto yy1307;
		case 'X':
		case 'x': goto yy1308;
		default: goto yy1281;
	}
yy1280:
	++cur;
#line 884 "parser/tokenizer.re"
	{
                token_loc(loc, cur, tok, string_start);
                std::string t = token(tok, cur);
                diagnostics.add(diag::Diagnostic(
                    "End of file not expected in `format` statement '" + t + "'",
                    diag::Level::Error, diag::Stage::Tokenizer, {
                    diag::Label("", {loc})}
                ));
                if(!continue_compilation) {
                    throw parser_local::TokenizerAbort();
                } else {
                    continue;
                }
            }
#line 9852 "parser/tokenizer.cpp"
yy1281:
	++cur;
yy1282:
#line 842 "parser/tokenizer.re"
	{
                token_loc(loc, cur, tok, string_start);
                std::string t = token(tok, cur);
                diagnostics.add(diag::Diagnostic(
                    "Token '" + t + "' is not recognized in `format` statement",
                    diag::Level::Error, diag::Stage::Tokenizer, {
                    diag::Label("", {loc})}
                ));
                if(!continue_compilation) {
                    throw parser_local::TokenizerAbort();
                } else {
                    continue;
                }
            }
#line 9871 "parser/tokenizer.cpp"
yy1283:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 2) {
		goto yy1283;
	}
	switch (yych) {
		case 'A':
		case 'a': goto yy1296;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1309;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1311;
		case 'E':
		case 'e': goto yy1312;
		case 'G':
		case 'g': goto yy1313;
		case 'L':
		case 'l': goto yy1314;
		case 'P':
		case 'p': goto yy1304;
		case 'X':
		case 'x': goto yy1308;
		default: goto yy1284;
	}
yy1284:
#line 898 "parser/tokenizer.re"
	{ continue; }
#line 9908 "parser/tokenizer.cpp"
yy1285:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy1282;
	goto yy1316;
yy1286:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy1282;
		if (yych <= '\v') goto yy1319;
		goto yy1282;
	} else {
		if (yych <= '\r') goto yy1319;
		if (yych <= 0x1F) goto yy1282;
		if (yych <= '!') goto yy1319;
		goto yy1282;
	}
yy1287:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy1282;
	goto yy1324;
yy1288:
	++cur;
#line 856 "parser/tokenizer.re"
	{
                if (num_paren == 0) {
                    num_paren++;
                    start = cur;
                    continue;
                } else {
                    cur--;
                    unsigned char *tmp;
                    lex_format(cur, loc, tmp, diagnostics, continue_compilation, string_start);
                    continue;
                }
            }
#line 9947 "parser/tokenizer.cpp"
yy1289:
	++cur;
#line 880 "parser/tokenizer.re"
	{
                LCOMPILERS_ASSERT(num_paren == 1);
                return;
            }
#line 9955 "parser/tokenizer.cpp"
yy1290:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1282;
			goto yy1326;
		} else {
			if (yych == '\v') goto yy1326;
			goto yy1282;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1326;
			if (yych <= 0x1F) goto yy1282;
			goto yy1326;
		} else {
			if (yych == '(') goto yy1327;
			goto yy1282;
		}
	}
yy1291:
	++cur;
#line 903 "parser/tokenizer.re"
	{ continue; }
#line 9981 "parser/tokenizer.cpp"
yy1292:
	++cur;
#line 899 "parser/tokenizer.re"
	{ continue; }
#line 9986 "parser/tokenizer.cpp"
yy1293:
	++cur;
yy1294:
#line 905 "parser/tokenizer.re"
	{ continue; }
#line 9992 "parser/tokenizer.cpp"
yy1295:
	yyaccept = 1;
	yych = *(mar = ++cur);
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ':
		case '(':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'I':
		case 'L':
		case 'O':
		case 'P':
		case 'X':
		case 'Z':
		case 'a':
		case 'b':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'i':
		case 'l':
		case 'o':
		case 'p':
		case 'x':
		case 'z': goto yy1329;
		case '/': goto yy1293;
		default: goto yy1282;
	}
yy1296:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych >= '\t') goto yy1296;
		} else {
			if (yych == '\v') goto yy1296;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1296;
			if (yych >= ' ') goto yy1296;
		} else {
			if (yych <= '/') goto yy1297;
			if (yych <= '9') goto yy1332;
		}
	}
yy1297:
#line 904 "parser/tokenizer.re"
	{ continue; }
#line 10059 "parser/tokenizer.cpp"
yy1298:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '/') {
		if (yych <= '\v') {
			if (yych == '\t') goto yy1333;
			if (yych <= '\n') goto yy1282;
			goto yy1333;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy1282;
				goto yy1333;
			} else {
				if (yych == ' ') goto yy1333;
				goto yy1282;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') {
				if (yych <= '9') goto yy1334;
				goto yy1282;
			} else {
				if (yych <= 'N') goto yy1293;
				if (yych <= 'Y') goto yy1282;
				goto yy1293;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy1282;
				goto yy1293;
			} else {
				if (yych == 'z') goto yy1293;
				goto yy1282;
			}
		}
	}
yy1299:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1282;
			goto yy1311;
		} else {
			if (yych == '\v') goto yy1311;
			goto yy1282;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1311;
			if (yych <= 0x1F) goto yy1282;
			goto yy1311;
		} else {
			if (yych <= '/') goto yy1282;
			if (yych <= '9') goto yy1335;
			goto yy1282;
		}
	}
yy1300:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 'M') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy1282;
				goto yy1312;
			} else {
				if (yych == '\v') goto yy1312;
				goto yy1282;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy1312;
				if (yych <= 0x1F) goto yy1282;
				goto yy1312;
			} else {
				if (yych <= '/') goto yy1282;
				if (yych <= '9') goto yy1336;
				goto yy1282;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'S') {
				if (yych <= 'N') goto yy1337;
				if (yych <= 'R') goto yy1282;
				goto yy1337;
			} else {
				if (yych == 'X') goto yy1337;
				goto yy1282;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'n') goto yy1337;
				if (yych <= 'r') goto yy1282;
				goto yy1337;
			} else {
				if (yych == 'x') goto yy1337;
				goto yy1282;
			}
		}
	}
yy1301:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1282;
			goto yy1313;
		} else {
			if (yych == '\v') goto yy1313;
			goto yy1282;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1313;
			if (yych <= 0x1F) goto yy1282;
			goto yy1313;
		} else {
			if (yych <= '/') goto yy1282;
			if (yych <= '9') goto yy1338;
			goto yy1282;
		}
	}
yy1302:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1282;
			goto yy1309;
		} else {
			if (yych == '\v') goto yy1309;
			goto yy1282;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1309;
			if (yych <= 0x1F) goto yy1282;
			goto yy1309;
		} else {
			if (yych <= '/') goto yy1282;
			if (yych <= '9') goto yy1334;
			goto yy1282;
		}
	}
yy1303:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1282;
			goto yy1314;
		} else {
			if (yych == '\v') goto yy1314;
			goto yy1282;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1314;
			if (yych <= 0x1F) goto yy1282;
			goto yy1314;
		} else {
			if (yych <= '/') goto yy1282;
			if (yych <= '9') goto yy1332;
			goto yy1282;
		}
	}
yy1304:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1340;
			goto yy1297;
		} else {
			if (yych == '\f') goto yy1297;
			goto yy1340;
		}
	} else {
		if (yych <= 'D') {
			if (yych == ' ') goto yy1340;
			goto yy1297;
		} else {
			if (yych <= 'F') goto yy1340;
			if (yych <= 'd') goto yy1297;
			if (yych <= 'f') goto yy1340;
			goto yy1297;
		}
	}
yy1305:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 'N') {
		if (yych <= '\r') {
			if (yych <= '\n') {
				if (yych == '\t') goto yy1341;
				goto yy1282;
			} else {
				if (yych == '\f') goto yy1282;
				goto yy1341;
			}
		} else {
			if (yych <= 'C') {
				if (yych == ' ') goto yy1341;
				goto yy1282;
			} else {
				if (yych <= 'D') goto yy1293;
				if (yych <= 'M') goto yy1282;
				goto yy1293;
			}
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Y') {
				if (yych == 'U') goto yy1293;
				goto yy1282;
			} else {
				if (yych <= 'Z') goto yy1293;
				if (yych <= 'c') goto yy1282;
				goto yy1293;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'n') goto yy1293;
				goto yy1282;
			} else {
				if (yych <= 'u') goto yy1293;
				if (yych == 'z') goto yy1293;
				goto yy1282;
			}
		}
	}
yy1306:
	yych = *++cur;
	if (yych <= ' ') {
		if (yych <= '\v') {
			if (yych == '\t') goto yy1306;
			if (yych <= '\n') goto yy1294;
			goto yy1306;
		} else {
			if (yych == '\r') goto yy1306;
			if (yych <= 0x1F) goto yy1294;
			goto yy1306;
		}
	} else {
		if (yych <= 'S') {
			if (yych == 'P') goto yy1293;
			if (yych <= 'R') goto yy1294;
			goto yy1293;
		} else {
			if (yych <= 'p') {
				if (yych <= 'o') goto yy1294;
				goto yy1293;
			} else {
				if (yych == 's') goto yy1293;
				goto yy1294;
			}
		}
	}
yy1307:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '/') {
		if (yych <= '\v') {
			if (yych == '\t') goto yy1342;
			if (yych <= '\n') goto yy1282;
			goto yy1342;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy1282;
				goto yy1342;
			} else {
				if (yych == ' ') goto yy1342;
				goto yy1282;
			}
		}
	} else {
		if (yych <= 'R') {
			if (yych <= 'K') {
				if (yych <= '9') goto yy1343;
				goto yy1282;
			} else {
				if (yych <= 'L') goto yy1344;
				if (yych <= 'Q') goto yy1282;
				goto yy1344;
			}
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy1282;
				goto yy1344;
			} else {
				if (yych == 'r') goto yy1344;
				goto yy1282;
			}
		}
	}
yy1308:
	++cur;
	goto yy1297;
yy1309:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych >= '\t') goto yy1309;
		} else {
			if (yych == '\v') goto yy1309;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1309;
			if (yych >= ' ') goto yy1309;
		} else {
			if (yych <= '/') goto yy1310;
			if (yych <= '9') goto yy1334;
		}
	}
yy1310:
	cur = mar;
	if (yyaccept <= 3) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy1284;
			} else {
				goto yy1282;
			}
		} else {
			if (yyaccept == 2) {
				goto yy1297;
			} else {
				goto yy1317;
			}
		}
	} else {
		if (yyaccept <= 5) {
			if (yyaccept == 4) {
				goto yy1321;
			} else {
				goto yy1325;
			}
		} else {
			goto yy1294;
		}
	}
yy1311:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1310;
			goto yy1311;
		} else {
			if (yych == '\v') goto yy1311;
			goto yy1310;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1311;
			if (yych <= 0x1F) goto yy1310;
			goto yy1311;
		} else {
			if (yych <= '/') goto yy1310;
			if (yych <= '9') goto yy1335;
			goto yy1310;
		}
	}
yy1312:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy1310;
				goto yy1312;
			} else {
				if (yych == '\v') goto yy1312;
				goto yy1310;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy1312;
				if (yych <= 0x1F) goto yy1310;
				goto yy1312;
			} else {
				if (yych <= '/') goto yy1310;
				if (yych <= '9') goto yy1336;
				goto yy1310;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'S') {
				if (yych <= 'N') goto yy1337;
				if (yych <= 'R') goto yy1310;
				goto yy1337;
			} else {
				if (yych == 'X') goto yy1337;
				goto yy1310;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'n') goto yy1337;
				if (yych <= 'r') goto yy1310;
				goto yy1337;
			} else {
				if (yych == 'x') goto yy1337;
				goto yy1310;
			}
		}
	}
yy1313:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1310;
			goto yy1313;
		} else {
			if (yych == '\v') goto yy1313;
			goto yy1310;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1313;
			if (yych <= 0x1F) goto yy1310;
			goto yy1313;
		} else {
			if (yych <= '/') goto yy1310;
			if (yych <= '9') goto yy1338;
			goto yy1310;
		}
	}
yy1314:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1310;
			goto yy1314;
		} else {
			if (yych == '\v') goto yy1314;
			goto yy1310;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1314;
			if (yych <= 0x1F) goto yy1310;
			goto yy1314;
		} else {
			if (yych <= '/') goto yy1310;
			if (yych <= '9') goto yy1332;
			goto yy1310;
		}
	}
yy1315:
	yych = *++cur;
yy1316:
	if (yybm[0+yych] & 4) {
		goto yy1315;
	}
	if (yych <= 0x00) goto yy1310;
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy1315;
yy1317:
#line 901 "parser/tokenizer.re"
	{ continue; }
#line 10524 "parser/tokenizer.cpp"
yy1318:
	yych = *++cur;
yy1319:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1310;
			goto yy1318;
		} else {
			if (yych <= '\n') goto yy1320;
			if (yych <= '\v') goto yy1318;
			goto yy1310;
		}
	} else {
		if (yych <= 0x1F) {
			if (yych <= '\r') goto yy1318;
			goto yy1310;
		} else {
			if (yych <= ' ') goto yy1318;
			if (yych <= '!') goto yy1322;
			goto yy1310;
		}
	}
yy1320:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy1320;
	}
	if (yych <= 0x1F) goto yy1321;
	if (yych <= '!') goto yy1322;
	if (yych == '&') goto yy1345;
yy1321:
#line 900 "parser/tokenizer.re"
	{ continue; }
#line 10559 "parser/tokenizer.cpp"
yy1322:
	yych = *++cur;
	if (yybm[0+yych] & 16) {
		goto yy1322;
	}
	if (yych <= 0x00) goto yy1310;
	goto yy1320;
yy1323:
	yych = *++cur;
yy1324:
	if (yybm[0+yych] & 32) {
		goto yy1323;
	}
	if (yych <= 0x00) goto yy1310;
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy1323;
yy1325:
#line 902 "parser/tokenizer.re"
	{ continue; }
#line 10580 "parser/tokenizer.cpp"
yy1326:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1310;
			goto yy1326;
		} else {
			if (yych == '\v') goto yy1326;
			goto yy1310;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1326;
			if (yych <= 0x1F) goto yy1310;
			goto yy1326;
		} else {
			if (yych != '(') goto yy1310;
		}
	}
yy1327:
	++cur;
#line 874 "parser/tokenizer.re"
	{
                cur--;
                unsigned char *tmp;
                lex_format(cur, loc, tmp, diagnostics, continue_compilation, string_start);
                continue;
            }
#line 10609 "parser/tokenizer.cpp"
yy1328:
	yych = *++cur;
yy1329:
	if (yybm[0+yych] & 64) {
		goto yy1331;
	}
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy1328;
		case '(': goto yy1330;
		case 'A':
		case 'a': goto yy1296;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1309;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1311;
		case 'E':
		case 'e': goto yy1312;
		case 'G':
		case 'g': goto yy1313;
		case 'L':
		case 'l': goto yy1314;
		case 'P':
		case 'p': goto yy1304;
		case 'X':
		case 'x': goto yy1308;
		default: goto yy1310;
	}
yy1330:
	++cur;
#line 868 "parser/tokenizer.re"
	{
                cur--;
                unsigned char *tmp;
                lex_format(cur, loc, tmp, diagnostics, continue_compilation, string_start);
                continue;
            }
#line 10657 "parser/tokenizer.cpp"
yy1331:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy1331;
	}
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy1328;
		case '(': goto yy1330;
		case '/': goto yy1293;
		case 'A':
		case 'a': goto yy1296;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1309;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1311;
		case 'E':
		case 'e': goto yy1312;
		case 'G':
		case 'g': goto yy1313;
		case 'L':
		case 'l': goto yy1314;
		case 'P':
		case 'p': goto yy1304;
		case 'X':
		case 'x': goto yy1308;
		default: goto yy1310;
	}
yy1332:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1297;
			goto yy1314;
		} else {
			if (yych == '\v') goto yy1314;
			goto yy1297;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1314;
			if (yych <= 0x1F) goto yy1297;
			goto yy1314;
		} else {
			if (yych <= '/') goto yy1297;
			if (yych <= '9') goto yy1332;
			goto yy1297;
		}
	}
yy1333:
	yych = *++cur;
	if (yych <= '/') {
		if (yych <= '\v') {
			if (yych == '\t') goto yy1333;
			if (yych <= '\n') goto yy1310;
			goto yy1333;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy1310;
				goto yy1333;
			} else {
				if (yych == ' ') goto yy1333;
				goto yy1310;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') {
				if (yych >= ':') goto yy1310;
			} else {
				if (yych <= 'N') goto yy1293;
				if (yych <= 'Y') goto yy1310;
				goto yy1293;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy1310;
				goto yy1293;
			} else {
				if (yych == 'z') goto yy1293;
				goto yy1310;
			}
		}
	}
yy1334:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 128) {
		goto yy1334;
	}
	if (yych == '.') goto yy1314;
	goto yy1297;
yy1335:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1335;
			goto yy1310;
		} else {
			if (yych == '\f') goto yy1310;
			goto yy1335;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') goto yy1335;
			goto yy1310;
		} else {
			if (yych <= '.') goto yy1314;
			if (yych <= '/') goto yy1310;
			if (yych <= '9') goto yy1335;
			goto yy1310;
		}
	}
yy1336:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1336;
			goto yy1310;
		} else {
			if (yych == '\f') goto yy1310;
			goto yy1336;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') goto yy1336;
			goto yy1310;
		} else {
			if (yych <= '.') goto yy1346;
			if (yych <= '/') goto yy1310;
			if (yych <= '9') goto yy1336;
			goto yy1310;
		}
	}
yy1337:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1310;
			goto yy1337;
		} else {
			if (yych == '\v') goto yy1337;
			goto yy1310;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1337;
			if (yych <= 0x1F) goto yy1310;
			goto yy1337;
		} else {
			if (yych <= '/') goto yy1310;
			if (yych <= '9') goto yy1336;
			goto yy1310;
		}
	}
yy1338:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1338;
			goto yy1297;
		} else {
			if (yych == '\f') goto yy1297;
			goto yy1338;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') goto yy1338;
			goto yy1297;
		} else {
			if (yych <= '.') goto yy1346;
			if (yych <= '/') goto yy1297;
			if (yych <= '9') goto yy1338;
			goto yy1297;
		}
	}
yy1339:
	yych = *++cur;
yy1340:
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1339;
			goto yy1310;
		} else {
			if (yych == '\f') goto yy1310;
			if (yych <= '\r') goto yy1339;
			goto yy1310;
		}
	} else {
		if (yych <= 'F') {
			if (yych <= ' ') goto yy1339;
			if (yych <= 'D') goto yy1310;
			if (yych <= 'E') goto yy1337;
			goto yy1311;
		} else {
			if (yych <= 'd') goto yy1310;
			if (yych <= 'e') goto yy1337;
			if (yych <= 'f') goto yy1311;
			goto yy1310;
		}
	}
yy1341:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych <= '\r') {
			if (yych <= '\n') {
				if (yych == '\t') goto yy1341;
				goto yy1310;
			} else {
				if (yych == '\f') goto yy1310;
				goto yy1341;
			}
		} else {
			if (yych <= 'C') {
				if (yych == ' ') goto yy1341;
				goto yy1310;
			} else {
				if (yych <= 'D') goto yy1293;
				if (yych <= 'M') goto yy1310;
				goto yy1293;
			}
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Y') {
				if (yych == 'U') goto yy1293;
				goto yy1310;
			} else {
				if (yych <= 'Z') goto yy1293;
				if (yych <= 'c') goto yy1310;
				goto yy1293;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'n') goto yy1293;
				goto yy1310;
			} else {
				if (yych <= 'u') goto yy1293;
				if (yych == 'z') goto yy1293;
				goto yy1310;
			}
		}
	}
yy1342:
	yych = *++cur;
	if (yych <= '/') {
		if (yych <= '\v') {
			if (yych == '\t') goto yy1342;
			if (yych <= '\n') goto yy1310;
			goto yy1342;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy1310;
				goto yy1342;
			} else {
				if (yych == ' ') goto yy1342;
				goto yy1310;
			}
		}
	} else {
		if (yych <= 'R') {
			if (yych <= 'K') {
				if (yych >= ':') goto yy1310;
			} else {
				if (yych <= 'L') goto yy1344;
				if (yych <= 'Q') goto yy1310;
				goto yy1344;
			}
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy1310;
				goto yy1344;
			} else {
				if (yych == 'r') goto yy1344;
				goto yy1310;
			}
		}
	}
yy1343:
	yyaccept = 6;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1294;
		} else {
			if (yych != '\v') goto yy1294;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1344;
			if (yych <= 0x1F) goto yy1294;
		} else {
			if (yych <= '/') goto yy1294;
			if (yych <= '9') goto yy1343;
			goto yy1294;
		}
	}
yy1344:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1310;
			goto yy1344;
		} else {
			if (yych == '\v') goto yy1344;
			goto yy1310;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1344;
			if (yych <= 0x1F) goto yy1310;
			goto yy1344;
		} else {
			if (yych <= '/') goto yy1310;
			if (yych <= '9') goto yy1343;
			goto yy1310;
		}
	}
yy1345:
	++cur;
	goto yy1321;
yy1346:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1310;
			goto yy1346;
		} else {
			if (yych == '\v') goto yy1346;
			goto yy1310;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1346;
			if (yych <= 0x1F) goto yy1310;
			goto yy1346;
		} else {
			if (yych <= '/') goto yy1310;
			if (yych >= ':') goto yy1310;
		}
	}
yy1347:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1347;
			goto yy1297;
		} else {
			if (yych == '\f') goto yy1297;
			if (yych <= '\r') goto yy1347;
			goto yy1297;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= ' ') goto yy1347;
			if (yych <= '/') goto yy1297;
			if (yych <= '9') goto yy1347;
			goto yy1297;
		} else {
			if (yych <= 'E') goto yy1314;
			if (yych == 'e') goto yy1314;
			goto yy1297;
		}
	}
}
#line 906 "parser/tokenizer.re"

    }
}

} // namespace LCompilers::LFortran
