/*
 * Copyright (C) 2021 magicxqq <xqq@xqq.im>. All rights reserved.
 *
 * This file is part of libaribcaption.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef ARIBCAPTION_B24_GAIJI_TABLE_HPP
#define ARIBCAPTION_B24_GAIJI_TABLE_HPP

#include <cstdint>

namespace aribcaption {

// ARIB Additional symbols using Unicode 5.2
inline constexpr uint32_t kAdditionalSymbolsTable_Unicode[] = {
    0x3402, 0x20158, 0x4efd, 0x4eff, 0x4f9a, 0x4fc9, 0x509c, 0x511e,
    0x51bc, 0x351f, 0x5307, 0x5361, 0x536c, 0x8a79, 0x20bb7, 0x544d,
    0x5496, 0x549c, 0x54a9, 0x550e, 0x554a, 0x5672, 0x56e4, 0x5733,
    0x5734, 0xfa10, 0x5880, 0x59e4, 0x5a23, 0x5a55, 0x5bec, 0xfa11,
    0x37e2, 0x5eac, 0x5f34, 0x5f45, 0x5fb7, 0x6017, 0xfa6b, 0x6130,
    0x6624, 0x66c8, 0x66d9, 0x66fa, 0x66fb, 0x6852, 0x9fc4, 0x6911,
    0x693b, 0x6a45, 0x6a91, 0x6adb, 0x233cc, 0x233fe, 0x235c4, 0x6bf1,
    0x6ce0, 0x6d2e, 0xfa45, 0x6dbf, 0x6dca, 0x6df8, 0xfa46, 0x6f5e,
    0x6ff9, 0x7064, 0xfa6c, 0x242ee, 0x7147, 0x71c1, 0x7200, 0x739f,
    0x73a8, 0x73c9, 0x73d6, 0x741b, 0x7421, 0xfa4a, 0x7426, 0x742a,
    0x742c, 0x7439, 0x744b, 0x3eda, 0x7575, 0x7581, 0x7772, 0x4093,
    0x78c8, 0x78e0, 0x7947, 0x79ae, 0x9fc6, 0x4103, 0x9fc5, 0x79da,
    0x7a1e, 0x7b7f, 0x7c31, 0x4264, 0x7d8b, 0x7fa1, 0x8118, 0x813a,
    0xfa6d, 0x82ae, 0x845b, 0x84dc, 0x84ec, 0x8559, 0x85ce, 0x8755,
    0x87ec, 0x880b, 0x88f5, 0x89d2, 0x8af6, 0x8dce, 0x8fbb, 0x8ff6,
    0x90dd, 0x9127, 0x912d, 0x91b2, 0x9233, 0x9288, 0x9321, 0x9348,
    0x9592, 0x96de, 0x9903, 0x9940, 0x9ad9, 0x9bd6, 0x9dd7, 0x9eb4,
    0x9eb5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x26cc, 0x26cd,
    0x2757, 0x26cf, 0x26d0, 0x26d1, 0xfffd, 0x26d2, 0x26d5, 0x26d3,
    0x26d4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x1f17f, 0x1f18a, 0xfffd,
    0xfffd, 0x26d6, 0x26d7, 0x26d8, 0x26d9, 0x26da, 0x26db, 0x26dc,
    0x26dd, 0x26de, 0x26df, 0x26e0, 0x26e1, 0x2b55, 0x3248, 0x3249,
    0x324a, 0x324b, 0x324c, 0x324d, 0x324e, 0x324f, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x2491, 0x2492, 0x2493, 0x1f14a, 0x1f14c, 0x1f13f,
    0x1f146, 0x1f14b, 0x1f210, 0x1f211, 0x1f212, 0x1f213, 0x1f142, 0x1f214,
    0x1f215, 0x1f216, 0x1f14d, 0x1f131, 0x1f13d, 0x2b1b, 0x2b24, 0x1f217,
    0x1f218, 0x1f219, 0x1f21a, 0x1f21b, 0x26bf, 0x1f21c, 0x1f21d, 0x1f21e,
    0x1f21f, 0x1f220, 0x1f221, 0x1f222, 0x1f223, 0x1f224, 0x1f225, 0x1f14e,
    0x3299, 0x1f200, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x26e3, 0x2b56, 0x2b57, 0x2b58,
    0x2b59, 0x2613, 0x328b, 0x3012, 0x26e8, 0x3246, 0x3245, 0x26e9,
    0x0fd6, 0x26ea, 0x26eb, 0x26ec, 0x2668, 0x26ed, 0x26ee, 0x26ef,
    0x2693, 0x2708, 0x26f0, 0x26f1, 0x26f2, 0x26f3, 0x26f4, 0x26f5,
    0x1f157, 0x24b9, 0x24c8, 0x26f6, 0x1f15f, 0x1f18b, 0x1f18d, 0x1f18c,
    0x1f179, 0x26f7, 0x26f8, 0x26f9, 0x26fa, 0x1f17b, 0x260e, 0x26fb,
    0x26fc, 0x26fd, 0x26fe, 0x1f17c, 0x26ff, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x27a1, 0x2b05, 0x2b06, 0x2b07, 0x2b2f, 0x2b2e,
    0x5e74, 0x6708, 0x65e5, 0x5186, 0x33a1, 0x33a5, 0x339d, 0x33a0,
    0x33a4, 0x1f100, 0x2488, 0x2489, 0x248a, 0x248b, 0x248c, 0x248d,
    0x248e, 0x248f, 0x2490, 0x6c0f, 0x526f, 0x5143, 0x6545, 0x524d,
    0x65b0, 0x1f101, 0x1f102, 0x1f103, 0x1f104, 0x1f105, 0x1f106, 0x1f107,
    0x1f108, 0x1f109, 0x1f10a, 0x3233, 0x3236, 0x3232, 0x3231, 0x3239,
    0x3244, 0x25b6, 0x25c0, 0x3016, 0x3017, 0x27d0, 0x00b2, 0x00b3,
    0x1f12d, 0xe2a5, 0xe2a6, 0xe2a7, 0xe2a8, 0xe2a9, 0xe2aa, 0xe2ab,
    0xe2ac, 0xe2ad, 0xe2ae, 0xe2af, 0xe2b0, 0xe2b1, 0xe2b2, 0xe2b3,
    0xe2b4, 0xe2b5, 0xe2b6, 0xe2b7, 0xe2b8, 0xe2b9, 0xe2ba, 0xe2bb,
    0xe2bc, 0xe2bd, 0xe2be, 0xe2bf, 0xe2c0, 0xe2c1, 0xe2c2, 0x1f12c,
    0x1f12b, 0x3247, 0x1f190, 0x1f226, 0x213b, 0xfffd, 0xfffd, 0xfffd,
    0x322a, 0x322b, 0x322c, 0x322d, 0x322e, 0x322f, 0x3230, 0x3237,
    0x337e, 0x337d, 0x337c, 0x337b, 0x2116, 0x2121, 0x3036, 0x26be,
    0x1f240, 0x1f241, 0x1f242, 0x1f243, 0x1f244, 0x1f245, 0x1f246, 0x1f247,
    0x1f248, 0x1f12a, 0x1f227, 0x1f228, 0x1f229, 0x1f214, 0x1f22a, 0x1f22b,
    0x1f22c, 0x1f22d, 0x1f22e, 0x1f22f, 0x1f230, 0x1f231, 0x2113, 0x338f,
    0x3390, 0x33ca, 0x339e, 0x33a2, 0x3371, 0xfffd, 0xfffd, 0x00bd,
    0x2189, 0x2153, 0x2154, 0x00bc, 0x00be, 0x2155, 0x2156, 0x2157,
    0x2158, 0x2159, 0x215a, 0x2150, 0x215b, 0x2151, 0x2152, 0x2600,
    0x2601, 0x2602, 0x26c4, 0x2616, 0x2617, 0x26c9, 0x26ca, 0x2666,
    0x2665, 0x2663, 0x2660, 0x26cb, 0x2a00, 0x203c, 0x2049, 0x26c5,
    0x2614, 0x26c6, 0x2603, 0x26c7, 0x26a1, 0x26c8, 0xfffd, 0x269e,
    0x269f, 0x266c, 0x260e, 0xfffd, 0xfffd, 0xfffd, 0x2160, 0x2161,
    0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167, 0x2168, 0x2169,
    0x216a, 0x216b, 0x2470, 0x2471, 0x2472, 0x2473, 0x2474, 0x2475,
    0x2476, 0x2477, 0x2478, 0x2479, 0x247a, 0x247b, 0x247c, 0x247d,
    0x247e, 0x247f, 0x3251, 0x3252, 0x3253, 0x3254, 0x1f110, 0x1f111,
    0x1f112, 0x1f113, 0x1f114, 0x1f115, 0x1f116, 0x1f117, 0x1f118, 0x1f119,
    0x1f11a, 0x1f11b, 0x1f11c, 0x1f11d, 0x1f11e, 0x1f11f, 0x1f120, 0x1f121,
    0x1f122, 0x1f123, 0x1f124, 0x1f125, 0x1f126, 0x1f127, 0x1f128, 0x1f129,
    0x3255, 0x3256, 0x3257, 0x3258, 0x3259, 0x325a, 0x2460, 0x2461,
    0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467, 0x2468, 0x2469,
    0x246a, 0x246b, 0x246c, 0x246d, 0x246e, 0x246f, 0x2776, 0x2777,
    0x2778, 0x2779, 0x277a, 0x277b, 0x277c, 0x277d, 0x277e, 0x277f,
    0x24eb, 0x24ec, 0x325b, 0xfffd
};

// ARIB Additional symbols using Private Use Area (PUA) in BMP
inline constexpr uint32_t kAdditionalSymbolsTable_PUA[] = {
    0x3402, 0xe081, 0x4efd, 0x4eff, 0x4f9a, 0x4fc9, 0x509c, 0x511e,
    0x51bc, 0x351f, 0x5307, 0x5361, 0x536c, 0x8a79, 0xe084, 0x544d,
    0x5496, 0x549c, 0x54a9, 0x550e, 0x554a, 0x5672, 0x56e4, 0x5733,
    0x5734, 0xfa10, 0x5880, 0x59e4, 0x5a23, 0x5a55, 0x5bec, 0xfa11,
    0x37e2, 0x5eac, 0x5f34, 0x5f45, 0x5fb7, 0x6017, 0xfa6b, 0x6130,
    0x6624, 0x66c8, 0x66d9, 0x66fa, 0x66fb, 0x6852, 0x9fc4, 0x6911,
    0x693b, 0x6a45, 0x6a91, 0x6adb, 0xe08a, 0xe08b, 0xe08c, 0x6bf1,
    0x6ce0, 0x6d2e, 0xfa45, 0x6dbf, 0x6dca, 0x6df8, 0xfa46, 0x6f5e,
    0x6ff9, 0x7064, 0xfa6c, 0xe08e, 0x7147, 0x71c1, 0x7200, 0x739f,
    0x73a8, 0x73c9, 0x73d6, 0x741b, 0x7421, 0xfa4a, 0x7426, 0x742a,
    0x742c, 0x7439, 0x744b, 0x3eda, 0x7575, 0x7581, 0x7772, 0x4093,
    0x78c8, 0x78e0, 0x7947, 0x79ae, 0x9fc6, 0x4103, 0x9fc5, 0x79da,
    0x7a1e, 0x7b7f, 0x7c31, 0x4264, 0x7d8b, 0x7fa1, 0x8118, 0x813a,
    0xfa6d, 0x82ae, 0x845b, 0x84dc, 0x84ec, 0x8559, 0x85ce, 0x8755,
    0x87ec, 0x880b, 0x88f5, 0x89d2, 0x8af6, 0x8dce, 0x8fbb, 0x8ff6,
    0x90dd, 0x9127, 0x912d, 0x91b2, 0x9233, 0x9288, 0x9321, 0x9348,
    0x9592, 0x96de, 0x9903, 0x9940, 0x9ad9, 0x9bd6, 0x9dd7, 0x9eb4,
    0x9eb5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x26cc, 0x26cd,
    0x2757, 0x26cf, 0x26d0, 0x26d1, 0xfffd, 0x26d2, 0x26d5, 0x26d3,
    0x26d4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0d8, 0xe0d9, 0xfffd,
    0xfffd, 0x26d6, 0x26d7, 0x26d8, 0x26d9, 0x26da, 0x26db, 0x26dc,
    0x26dd, 0x26de, 0x26df, 0x26e0, 0x26e1, 0x2b55, 0x3248, 0x3249,
    0x324a, 0x324b, 0x324c, 0x324d, 0x324e, 0x324f, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x2491, 0x2492, 0x2493, 0xe0f8, 0xe0f9, 0xe0fa,
    0xe0fb, 0xe0fc, 0xe0fd, 0xe0fe, 0xe0ff, 0xe180, 0xe181, 0xe182,
    0xe183, 0xe184, 0xe185, 0xe186, 0xe187, 0x2b1b, 0x2b24, 0xe18a,
    0xe18b, 0xe18c, 0xe18d, 0xe18e, 0x26bf, 0xe190, 0xe191, 0xe192,
    0xe193, 0xe194, 0xe195, 0xe196, 0xe197, 0xe198, 0xe199, 0xe19a,
    0x3299, 0xe19c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x26e3, 0x2b56, 0x2b57, 0x2b58,
    0x2b59, 0x2613, 0x328b, 0x3012, 0x26e8, 0x3246, 0x3245, 0x26e9,
    0x0fd6, 0x26ea, 0x26eb, 0x26ec, 0x2668, 0x26ed, 0x26ee, 0x26ef,
    0x2693, 0x2708, 0x26f0, 0x26f1, 0x26f2, 0x26f3, 0x26f4, 0x26f5,
    0xe1c3, 0x24b9, 0x24c8, 0x26f6, 0xe1c7, 0xe1c8, 0xe1c9, 0xe1ca,
    0xe1cb, 0x26f7, 0x26f8, 0x26f9, 0x26fa, 0xe1d0, 0x260e, 0x26fb,
    0x26fc, 0x26fd, 0x26fe, 0xe1d6, 0x26ff, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x27a1, 0x2b05, 0x2b06, 0x2b07, 0x2b2f, 0x2b2e,
    0x5e74, 0x6708, 0x65e5, 0x5186, 0x33a1, 0x33a5, 0x339d, 0x33a0,
    0x33a4, 0xe28f, 0x2488, 0x2489, 0x248a, 0x248b, 0x248c, 0x248d,
    0x248e, 0x248f, 0x2490, 0xe290, 0xe291, 0xe292, 0xe293, 0xe294,
    0xe295, 0xe296, 0xe297, 0xe298, 0xe299, 0xe29a, 0xe29b, 0xe29c,
    0xe29d, 0xe29e, 0xe29f, 0x3233, 0x3236, 0x3232, 0x3231, 0x3239,
    0x3244, 0x25b6, 0x25c0, 0x3016, 0x3017, 0x27d0, 0x00b2, 0x00b3,
    0xe2a4, 0xe2a5, 0xe2a6, 0xe2a7, 0xe2a8, 0xe2a9, 0xe2aa, 0xe2ab,
    0xe2ac, 0xe2ad, 0xe2ae, 0xe2af, 0xe2b0, 0xe2b1, 0xe2b2, 0xe2b3,
    0xe2b4, 0xe2b5, 0xe2b6, 0xe2b7, 0xe2b8, 0xe2b9, 0xe2ba, 0xe2bb,
    0xe2bc, 0xe2bd, 0xe2be, 0xe2bf, 0xe2c0, 0xe2c1, 0xe2c2, 0xe2c3,
    0xe2c6, 0x3247, 0xe2c4, 0xe2c5, 0x213b, 0xfffd, 0xfffd, 0xfffd,
    0x322a, 0x322b, 0x322c, 0x322d, 0x322e, 0x322f, 0x3230, 0x3237,
    0x337e, 0x337d, 0x337c, 0x337b, 0x2116, 0x2121, 0x3036, 0x26be,
    0xe2cd, 0xe2ce, 0xe2cf, 0xe2d0, 0xe2d1, 0xe2d2, 0xe2d3, 0xe2d4,
    0xe2d5, 0xe2d6, 0xe2d7, 0xe2d8, 0xe2d9, 0xe2da, 0xe2db, 0xe2dc,
    0xe2dd, 0xe2de, 0xe2df, 0xe2e0, 0xe2e1, 0xe2e2, 0x2113, 0x338f,
    0x3390, 0x33ca, 0x339e, 0x33a2, 0x3371, 0xfffd, 0xfffd, 0x00bd,
    0x2189, 0x2153, 0x2154, 0x00bc, 0x00be, 0x2155, 0x2156, 0x2157,
    0x2158, 0x2159, 0x215a, 0x2150, 0x215b, 0x2151, 0x2152, 0x2600,
    0x2601, 0x2602, 0x26c4, 0x2616, 0x2617, 0x26c9, 0x26ca, 0x2666,
    0x2665, 0x2663, 0x2660, 0x26cb, 0x2a00, 0x203c, 0x2049, 0x26c5,
    0x2614, 0x26c6, 0x2603, 0x26c7, 0x26a1, 0x26c8, 0xfffd, 0x269e,
    0x269f, 0x266c, 0x260e, 0xfffd, 0xfffd, 0xfffd, 0x2160, 0x2161,
    0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167, 0x2168, 0x2169,
    0x216a, 0x216b, 0x2470, 0x2471, 0x2472, 0x2473, 0x2474, 0x2475,
    0x2476, 0x2477, 0x2478, 0x2479, 0x247a, 0x247b, 0x247c, 0x247d,
    0x247e, 0x247f, 0x3251, 0x3252, 0x3253, 0x3254, 0xe383, 0xe384,
    0xe385, 0xe386, 0xe387, 0xe388, 0xe389, 0xe38a, 0xe38b, 0xe38c,
    0xe38d, 0xe38e, 0xe38f, 0xe390, 0xe391, 0xe392, 0xe393, 0xe394,
    0xe395, 0xe396, 0xe397, 0xe398, 0xe399, 0xe39a, 0xe39b, 0xe39c,
    0x3255, 0x3256, 0x3257, 0x3258, 0x3259, 0x325a, 0x2460, 0x2461,
    0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467, 0x2468, 0x2469,
    0x246a, 0x246b, 0x246c, 0x246d, 0x246e, 0x246f, 0x2776, 0x2777,
    0x2778, 0x2779, 0x277a, 0x277b, 0x277c, 0x277d, 0x277e, 0x277f,
    0x24eb, 0x24ec, 0x325b, 0xfffd
};

}  // namespace aribcaption

#endif  // ARIBCAPTION_B24_GAIJI_TABLE_HPP
