; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O3 -mtriple=powerpc64le-linux-gnu < %s | FileCheck --check-prefix=PC64LE %s
; RUN: llc -O3 -mtriple=powerpc64le-linux-gnu -mcpu=pwr9 < %s | FileCheck --check-prefix=PC64LE9 %s

define <1 x float> @constrained_vector_fdiv_v1f32(<1 x float> %x, <1 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_fdiv_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xsdivsp 1, 1, 2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fdiv_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xsdivsp 1, 1, 2
; PC64LE9-NEXT:    blr
entry:
  %div = call <1 x float> @llvm.experimental.constrained.fdiv.v1f32(
           <1 x float> %x,
           <1 x float> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <1 x float> %div
}

define <2 x double> @constrained_vector_fdiv_v2f64(<2 x double> %x, <2 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_fdiv_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvdivdp 34, 34, 35
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fdiv_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvdivdp 34, 34, 35
; PC64LE9-NEXT:    blr
entry:
  %div = call <2 x double> @llvm.experimental.constrained.fdiv.v2f64(
           <2 x double> %x,
           <2 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <2 x double> %div
}

define <3 x float> @constrained_vector_fdiv_v3f32(<3 x float> %x, <3 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_fdiv_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 35
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    addis 3, 2, .LCPI2_0@toc@ha
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xxsldwi 2, 35, 35, 3
; PC64LE-NEXT:    xxsldwi 3, 34, 34, 3
; PC64LE-NEXT:    addi 3, 3, .LCPI2_0@toc@l
; PC64LE-NEXT:    xxsldwi 5, 34, 34, 1
; PC64LE-NEXT:    xxsldwi 4, 35, 35, 1
; PC64LE-NEXT:    xsdivsp 0, 1, 0
; PC64LE-NEXT:    xscvspdpn 1, 2
; PC64LE-NEXT:    xscvspdpn 2, 3
; PC64LE-NEXT:    xsdivsp 1, 2, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xxmrghw 34, 0, 1
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xscvspdpn 1, 5
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvspdpn 0, 4
; PC64LE-NEXT:    xsdivsp 0, 1, 0
; PC64LE-NEXT:    xscvdpspn 36, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fdiv_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 35, 35, 1
; PC64LE9-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE9-NEXT:    addis 3, 2, .LCPI2_0@toc@ha
; PC64LE9-NEXT:    addi 3, 3, .LCPI2_0@toc@l
; PC64LE9-NEXT:    xxswapd 2, 34
; PC64LE9-NEXT:    xxsldwi 3, 34, 34, 3
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xscvspdpn 3, 3
; PC64LE9-NEXT:    xsdivsp 0, 1, 0
; PC64LE9-NEXT:    xxswapd 1, 35
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xsdivsp 1, 2, 1
; PC64LE9-NEXT:    xxsldwi 2, 35, 35, 3
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xsdivsp 2, 3, 2
; PC64LE9-NEXT:    xscvdpspn 34, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xscvdpspn 2, 2
; PC64LE9-NEXT:    xxmrghw 35, 1, 2
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    blr
entry:
  %div = call <3 x float> @llvm.experimental.constrained.fdiv.v3f32(
           <3 x float> %x,
           <3 x float> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <3 x float> %div
}

define <3 x double> @constrained_vector_fdiv_v3f64(<3 x double> %x, <3 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_fdiv_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    # kill: def $f5 killed $f5 def $vsl5
; PC64LE-NEXT:    # kill: def $f4 killed $f4 def $vsl4
; PC64LE-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 0, 5, 4
; PC64LE-NEXT:    xxmrghd 1, 2, 1
; PC64LE-NEXT:    xsdivdp 3, 3, 6
; PC64LE-NEXT:    xvdivdp 2, 1, 0
; PC64LE-NEXT:    xxswapd 1, 2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fdiv_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    # kill: def $f5 killed $f5 def $vsl5
; PC64LE9-NEXT:    # kill: def $f4 killed $f4 def $vsl4
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 0, 5, 4
; PC64LE9-NEXT:    xxmrghd 1, 2, 1
; PC64LE9-NEXT:    xsdivdp 3, 3, 6
; PC64LE9-NEXT:    xvdivdp 2, 1, 0
; PC64LE9-NEXT:    xxswapd 1, 2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    blr
entry:
  %div = call <3 x double> @llvm.experimental.constrained.fdiv.v3f64(
           <3 x double> %x,
           <3 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <3 x double> %div
}

define <4 x double> @constrained_vector_fdiv_v4f64(<4 x double> %x, <4 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_fdiv_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvdivdp 35, 35, 37
; PC64LE-NEXT:    xvdivdp 34, 34, 36
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fdiv_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvdivdp 35, 35, 37
; PC64LE9-NEXT:    xvdivdp 34, 34, 36
; PC64LE9-NEXT:    blr
entry:
  %div = call <4 x double> @llvm.experimental.constrained.fdiv.v4f64(
           <4 x double> %x,
           <4 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <4 x double> %div
}

define <1 x float> @constrained_vector_frem_v1f32(<1 x float> %x, <1 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_frem_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -32(1)
; PC64LE-NEXT:    std 0, 48(1)
; PC64LE-NEXT:    bl fmodf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    addi 1, 1, 32
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_frem_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -32(1)
; PC64LE9-NEXT:    std 0, 48(1)
; PC64LE9-NEXT:    bl fmodf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    addi 1, 1, 32
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %rem = call <1 x float> @llvm.experimental.constrained.frem.v1f32(
           <1 x float> %x,
           <1 x float> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <1 x float> %rem
}

define <2 x double> @constrained_vector_frem_v2f64(<2 x double> %x, <2 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_frem_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stxvd2x 61, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    xxlor 1, 62, 62
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    bl fmod
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 62
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    xxswapd 2, 63
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    bl fmod
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 34, 61, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 61, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_frem_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stxv 62, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 64(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscpsgndp 1, 62, 62
; PC64LE9-NEXT:    stxv 61, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    bl fmod
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 62
; PC64LE9-NEXT:    xxswapd 2, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    bl fmod
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 34, 61, 1
; PC64LE9-NEXT:    lxv 63, 64(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 61, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %rem = call <2 x double> @llvm.experimental.constrained.frem.v2f64(
           <2 x double> %x,
           <2 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <2 x double> %rem
}

define <3 x float> @constrained_vector_frem_v3f32(<3 x float> %x, <3 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_frem_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    xxsldwi 2, 35, 35, 1
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stfd 30, 80(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 88(1) # 8-byte Folded Spill
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    xscvspdpn 2, 2
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    bl fmodf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxswapd 0, 62
; PC64LE-NEXT:    xxswapd 2, 63
; PC64LE-NEXT:    fmr 31, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    xscvspdpn 2, 2
; PC64LE-NEXT:    bl fmodf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxsldwi 0, 62, 62, 3
; PC64LE-NEXT:    xxsldwi 2, 63, 63, 3
; PC64LE-NEXT:    fmr 30, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    xscvspdpn 2, 2
; PC64LE-NEXT:    bl fmodf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xscvdpspn 0, 1
; PC64LE-NEXT:    xscvdpspn 1, 30
; PC64LE-NEXT:    addis 3, 2, .LCPI7_0@toc@ha
; PC64LE-NEXT:    lfd 30, 80(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xscvdpspn 36, 31
; PC64LE-NEXT:    lfd 31, 88(1) # 8-byte Folded Reload
; PC64LE-NEXT:    addi 3, 3, .LCPI7_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_frem_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 62, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    xxsldwi 0, 35, 35, 1
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscvspdpn 2, 0
; PC64LE9-NEXT:    bl fmodf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxswapd 0, 62
; PC64LE9-NEXT:    fmr 31, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    xxswapd 0, 63
; PC64LE9-NEXT:    xscvspdpn 2, 0
; PC64LE9-NEXT:    bl fmodf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxsldwi 0, 62, 62, 3
; PC64LE9-NEXT:    fmr 30, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE9-NEXT:    xscvspdpn 2, 0
; PC64LE9-NEXT:    bl fmodf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscvdpspn 0, 1
; PC64LE9-NEXT:    xscvdpspn 1, 30
; PC64LE9-NEXT:    addis 3, 2, .LCPI7_0@toc@ha
; PC64LE9-NEXT:    xscvdpspn 34, 31
; PC64LE9-NEXT:    lxv 63, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 3, 3, .LCPI7_0@toc@l
; PC64LE9-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %rem = call <3 x float> @llvm.experimental.constrained.frem.v3f32(
           <3 x float> %x,
           <3 x float> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <3 x float> %rem
}

define <3 x double> @constrained_vector_frem_v3f64(<3 x double> %x, <3 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_frem_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stfd 28, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 28, 2
; PC64LE-NEXT:    fmr 2, 4
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    stfd 29, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 30, 80(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 30, 5
; PC64LE-NEXT:    stfd 31, 88(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    fmr 31, 6
; PC64LE-NEXT:    fmr 29, 3
; PC64LE-NEXT:    bl fmod
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 63, 1, 1
; PC64LE-NEXT:    fmr 1, 28
; PC64LE-NEXT:    fmr 2, 30
; PC64LE-NEXT:    bl fmod
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 63, 1, 63
; PC64LE-NEXT:    fmr 1, 29
; PC64LE-NEXT:    fmr 2, 31
; PC64LE-NEXT:    bl fmod
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    fmr 3, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    lfd 31, 88(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    lfd 30, 80(1) # 8-byte Folded Reload
; PC64LE-NEXT:    lfd 29, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    lfd 28, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_frem_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stfd 28, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    fmr 28, 2
; PC64LE9-NEXT:    fmr 2, 4
; PC64LE9-NEXT:    stfd 29, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    fmr 31, 6
; PC64LE9-NEXT:    fmr 30, 5
; PC64LE9-NEXT:    fmr 29, 3
; PC64LE9-NEXT:    bl fmod
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 63, 1, 1
; PC64LE9-NEXT:    fmr 1, 28
; PC64LE9-NEXT:    fmr 2, 30
; PC64LE9-NEXT:    bl fmod
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 63, 1, 63
; PC64LE9-NEXT:    fmr 1, 29
; PC64LE9-NEXT:    fmr 2, 31
; PC64LE9-NEXT:    bl fmod
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    fmr 3, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    lfd 29, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    lfd 28, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %rem = call <3 x double> @llvm.experimental.constrained.frem.v3f64(
           <3 x double> %x,
           <3 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <3 x double> %rem
}

define <4 x double> @constrained_vector_frem_v4f64(<4 x double> %x, <4 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_frem_v4f64:
; PC64LE:       # %bb.0:
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -128(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 144(1)
; PC64LE-NEXT:    stxvd2x 59, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 60, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    vmr 28, 2
; PC64LE-NEXT:    stxvd2x 61, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 96
; PC64LE-NEXT:    xxlor 1, 60, 60
; PC64LE-NEXT:    vmr 29, 3
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 30, 4
; PC64LE-NEXT:    li 3, 112
; PC64LE-NEXT:    xxlor 2, 62, 62
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 5
; PC64LE-NEXT:    bl fmod
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 59, 1, 1
; PC64LE-NEXT:    xxswapd 1, 60
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    xxswapd 2, 62
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    bl fmod
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 62, 59, 1
; PC64LE-NEXT:    xxlor 1, 61, 61
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    bl fmod
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 60, 1, 1
; PC64LE-NEXT:    xxswapd 1, 61
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    xxswapd 2, 63
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    bl fmod
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 112
; PC64LE-NEXT:    vmr 2, 30
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 35, 60, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 96
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    lxvd2x 61, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 60, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 59, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 128
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_frem_v4f64:
; PC64LE9:       # %bb.0:
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -112(1)
; PC64LE9-NEXT:    std 0, 128(1)
; PC64LE9-NEXT:    stxv 60, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 62, 80(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 30, 4
; PC64LE9-NEXT:    xscpsgndp 2, 62, 62
; PC64LE9-NEXT:    vmr 28, 2
; PC64LE9-NEXT:    xscpsgndp 1, 60, 60
; PC64LE9-NEXT:    stxv 59, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 61, 64(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 96(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 5
; PC64LE9-NEXT:    vmr 29, 3
; PC64LE9-NEXT:    bl fmod
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 59, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 60
; PC64LE9-NEXT:    xxswapd 2, 62
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    bl fmod
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 62, 59, 1
; PC64LE9-NEXT:    xscpsgndp 1, 61, 61
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    bl fmod
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 60, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 61
; PC64LE9-NEXT:    xxswapd 2, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    bl fmod
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 35, 60, 1
; PC64LE9-NEXT:    vmr 2, 30
; PC64LE9-NEXT:    lxv 63, 96(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 80(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 61, 64(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 60, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 59, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 112
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
  %rem = call <4 x double> @llvm.experimental.constrained.frem.v4f64(
           <4 x double> %x,
           <4 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <4 x double> %rem
}

define <1 x float> @constrained_vector_fmul_v1f32(<1 x float> %x, <1 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_fmul_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xsmulsp 1, 1, 2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fmul_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xsmulsp 1, 1, 2
; PC64LE9-NEXT:    blr
entry:
  %mul = call <1 x float> @llvm.experimental.constrained.fmul.v1f32(
           <1 x float> %x,
           <1 x float> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <1 x float> %mul
}

define <2 x double> @constrained_vector_fmul_v2f64(<2 x double> %x, <2 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_fmul_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvmuldp 34, 34, 35
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fmul_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvmuldp 34, 34, 35
; PC64LE9-NEXT:    blr
entry:
  %mul = call <2 x double> @llvm.experimental.constrained.fmul.v2f64(
           <2 x double> %x,
           <2 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <2 x double> %mul
}

define <3 x float> @constrained_vector_fmul_v3f32(<3 x float> %x, <3 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_fmul_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 35
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    addis 3, 2, .LCPI12_0@toc@ha
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xxsldwi 2, 35, 35, 3
; PC64LE-NEXT:    xxsldwi 3, 34, 34, 3
; PC64LE-NEXT:    addi 3, 3, .LCPI12_0@toc@l
; PC64LE-NEXT:    xxsldwi 5, 34, 34, 1
; PC64LE-NEXT:    xxsldwi 4, 35, 35, 1
; PC64LE-NEXT:    xsmulsp 0, 1, 0
; PC64LE-NEXT:    xscvspdpn 1, 2
; PC64LE-NEXT:    xscvspdpn 2, 3
; PC64LE-NEXT:    xsmulsp 1, 2, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xxmrghw 34, 0, 1
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xscvspdpn 1, 5
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvspdpn 0, 4
; PC64LE-NEXT:    xsmulsp 0, 1, 0
; PC64LE-NEXT:    xscvdpspn 36, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fmul_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 35, 35, 1
; PC64LE9-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE9-NEXT:    addis 3, 2, .LCPI12_0@toc@ha
; PC64LE9-NEXT:    addi 3, 3, .LCPI12_0@toc@l
; PC64LE9-NEXT:    xxswapd 2, 34
; PC64LE9-NEXT:    xxsldwi 3, 34, 34, 3
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xscvspdpn 3, 3
; PC64LE9-NEXT:    xsmulsp 0, 1, 0
; PC64LE9-NEXT:    xxswapd 1, 35
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xsmulsp 1, 2, 1
; PC64LE9-NEXT:    xxsldwi 2, 35, 35, 3
; PC64LE9-NEXT:    xscvdpspn 34, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xsmulsp 2, 3, 2
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xscvdpspn 2, 2
; PC64LE9-NEXT:    xxmrghw 35, 1, 2
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    blr
entry:
  %mul = call <3 x float> @llvm.experimental.constrained.fmul.v3f32(
           <3 x float> %x,
           <3 x float> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <3 x float> %mul
}

define <3 x double> @constrained_vector_fmul_v3f64(<3 x double> %x, <3 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_fmul_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    # kill: def $f5 killed $f5 def $vsl5
; PC64LE-NEXT:    # kill: def $f4 killed $f4 def $vsl4
; PC64LE-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 0, 5, 4
; PC64LE-NEXT:    xxmrghd 1, 2, 1
; PC64LE-NEXT:    xsmuldp 3, 3, 6
; PC64LE-NEXT:    xvmuldp 2, 1, 0
; PC64LE-NEXT:    xxswapd 1, 2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fmul_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    # kill: def $f5 killed $f5 def $vsl5
; PC64LE9-NEXT:    # kill: def $f4 killed $f4 def $vsl4
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 0, 5, 4
; PC64LE9-NEXT:    xxmrghd 1, 2, 1
; PC64LE9-NEXT:    xsmuldp 3, 3, 6
; PC64LE9-NEXT:    xvmuldp 2, 1, 0
; PC64LE9-NEXT:    xxswapd 1, 2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    blr
entry:
  %mul = call <3 x double> @llvm.experimental.constrained.fmul.v3f64(
           <3 x double> %x,
           <3 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <3 x double> %mul
}

define <4 x double> @constrained_vector_fmul_v4f64(<4 x double> %x, <4 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_fmul_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvmuldp 35, 35, 37
; PC64LE-NEXT:    xvmuldp 34, 34, 36
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fmul_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvmuldp 35, 35, 37
; PC64LE9-NEXT:    xvmuldp 34, 34, 36
; PC64LE9-NEXT:    blr
entry:
  %mul = call <4 x double> @llvm.experimental.constrained.fmul.v4f64(
           <4 x double> %x,
           <4 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <4 x double> %mul
}

define <1 x float> @constrained_vector_fadd_v1f32(<1 x float> %x, <1 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_fadd_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xsaddsp 1, 1, 2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fadd_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xsaddsp 1, 1, 2
; PC64LE9-NEXT:    blr
entry:
  %add = call <1 x float> @llvm.experimental.constrained.fadd.v1f32(
           <1 x float> %x,
           <1 x float> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <1 x float> %add
}

define <2 x double> @constrained_vector_fadd_v2f64(<2 x double> %x, <2 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_fadd_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvadddp 34, 34, 35
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fadd_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvadddp 34, 34, 35
; PC64LE9-NEXT:    blr
entry:
  %add = call <2 x double> @llvm.experimental.constrained.fadd.v2f64(
           <2 x double> %x,
           <2 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <2 x double> %add
}

define <3 x float> @constrained_vector_fadd_v3f32(<3 x float> %x, <3 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_fadd_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 35
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    addis 3, 2, .LCPI17_0@toc@ha
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xxsldwi 2, 35, 35, 3
; PC64LE-NEXT:    xxsldwi 3, 34, 34, 3
; PC64LE-NEXT:    addi 3, 3, .LCPI17_0@toc@l
; PC64LE-NEXT:    xxsldwi 5, 34, 34, 1
; PC64LE-NEXT:    xxsldwi 4, 35, 35, 1
; PC64LE-NEXT:    xsaddsp 0, 1, 0
; PC64LE-NEXT:    xscvspdpn 1, 2
; PC64LE-NEXT:    xscvspdpn 2, 3
; PC64LE-NEXT:    xsaddsp 1, 2, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xxmrghw 34, 0, 1
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xscvspdpn 1, 5
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvspdpn 0, 4
; PC64LE-NEXT:    xsaddsp 0, 1, 0
; PC64LE-NEXT:    xscvdpspn 36, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fadd_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 35, 35, 1
; PC64LE9-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE9-NEXT:    addis 3, 2, .LCPI17_0@toc@ha
; PC64LE9-NEXT:    addi 3, 3, .LCPI17_0@toc@l
; PC64LE9-NEXT:    xxswapd 2, 34
; PC64LE9-NEXT:    xxsldwi 3, 34, 34, 3
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xscvspdpn 3, 3
; PC64LE9-NEXT:    xsaddsp 0, 1, 0
; PC64LE9-NEXT:    xxswapd 1, 35
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xsaddsp 1, 2, 1
; PC64LE9-NEXT:    xxsldwi 2, 35, 35, 3
; PC64LE9-NEXT:    xscvdpspn 34, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xsaddsp 2, 3, 2
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xscvdpspn 2, 2
; PC64LE9-NEXT:    xxmrghw 35, 1, 2
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    blr
entry:
  %add = call <3 x float> @llvm.experimental.constrained.fadd.v3f32(
           <3 x float> %x,
           <3 x float> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <3 x float> %add
}

define <3 x double> @constrained_vector_fadd_v3f64(<3 x double> %x, <3 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_fadd_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    # kill: def $f5 killed $f5 def $vsl5
; PC64LE-NEXT:    # kill: def $f4 killed $f4 def $vsl4
; PC64LE-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 0, 5, 4
; PC64LE-NEXT:    xxmrghd 1, 2, 1
; PC64LE-NEXT:    xsadddp 3, 3, 6
; PC64LE-NEXT:    xvadddp 2, 1, 0
; PC64LE-NEXT:    xxswapd 1, 2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fadd_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    # kill: def $f5 killed $f5 def $vsl5
; PC64LE9-NEXT:    # kill: def $f4 killed $f4 def $vsl4
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 0, 5, 4
; PC64LE9-NEXT:    xxmrghd 1, 2, 1
; PC64LE9-NEXT:    xsadddp 3, 3, 6
; PC64LE9-NEXT:    xvadddp 2, 1, 0
; PC64LE9-NEXT:    xxswapd 1, 2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    blr
entry:
  %add = call <3 x double> @llvm.experimental.constrained.fadd.v3f64(
           <3 x double> %x,
           <3 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <3 x double> %add
}

define <4 x double> @constrained_vector_fadd_v4f64(<4 x double> %x, <4 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_fadd_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvadddp 35, 35, 37
; PC64LE-NEXT:    xvadddp 34, 34, 36
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fadd_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvadddp 35, 35, 37
; PC64LE9-NEXT:    xvadddp 34, 34, 36
; PC64LE9-NEXT:    blr
entry:
  %add = call <4 x double> @llvm.experimental.constrained.fadd.v4f64(
           <4 x double> %x,
           <4 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <4 x double> %add
}

define <1 x float> @constrained_vector_fsub_v1f32(<1 x float> %x, <1 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_fsub_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xssubsp 1, 1, 2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fsub_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xssubsp 1, 1, 2
; PC64LE9-NEXT:    blr
entry:
  %sub = call <1 x float> @llvm.experimental.constrained.fsub.v1f32(
           <1 x float> %x,
           <1 x float> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <1 x float> %sub
}

define <2 x double> @constrained_vector_fsub_v2f64(<2 x double> %x, <2 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_fsub_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvsubdp 34, 34, 35
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fsub_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvsubdp 34, 34, 35
; PC64LE9-NEXT:    blr
entry:
  %sub = call <2 x double> @llvm.experimental.constrained.fsub.v2f64(
           <2 x double> %x,
           <2 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <2 x double> %sub
}

define <3 x float> @constrained_vector_fsub_v3f32(<3 x float> %x, <3 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_fsub_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 35
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    addis 3, 2, .LCPI22_0@toc@ha
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xxsldwi 2, 35, 35, 3
; PC64LE-NEXT:    xxsldwi 3, 34, 34, 3
; PC64LE-NEXT:    addi 3, 3, .LCPI22_0@toc@l
; PC64LE-NEXT:    xxsldwi 5, 34, 34, 1
; PC64LE-NEXT:    xxsldwi 4, 35, 35, 1
; PC64LE-NEXT:    xssubsp 0, 1, 0
; PC64LE-NEXT:    xscvspdpn 1, 2
; PC64LE-NEXT:    xscvspdpn 2, 3
; PC64LE-NEXT:    xssubsp 1, 2, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xxmrghw 34, 0, 1
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xscvspdpn 1, 5
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvspdpn 0, 4
; PC64LE-NEXT:    xssubsp 0, 1, 0
; PC64LE-NEXT:    xscvdpspn 36, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fsub_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 35, 35, 1
; PC64LE9-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE9-NEXT:    addis 3, 2, .LCPI22_0@toc@ha
; PC64LE9-NEXT:    addi 3, 3, .LCPI22_0@toc@l
; PC64LE9-NEXT:    xxswapd 2, 34
; PC64LE9-NEXT:    xxsldwi 3, 34, 34, 3
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xscvspdpn 3, 3
; PC64LE9-NEXT:    xssubsp 0, 1, 0
; PC64LE9-NEXT:    xxswapd 1, 35
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xssubsp 1, 2, 1
; PC64LE9-NEXT:    xxsldwi 2, 35, 35, 3
; PC64LE9-NEXT:    xscvdpspn 34, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xssubsp 2, 3, 2
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xscvdpspn 2, 2
; PC64LE9-NEXT:    xxmrghw 35, 1, 2
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    blr
entry:
  %sub = call <3 x float> @llvm.experimental.constrained.fsub.v3f32(
           <3 x float> %x,
           <3 x float> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <3 x float> %sub
}

define <3 x double> @constrained_vector_fsub_v3f64(<3 x double> %x, <3 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_fsub_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    # kill: def $f5 killed $f5 def $vsl5
; PC64LE-NEXT:    # kill: def $f4 killed $f4 def $vsl4
; PC64LE-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 0, 5, 4
; PC64LE-NEXT:    xxmrghd 1, 2, 1
; PC64LE-NEXT:    xssubdp 3, 3, 6
; PC64LE-NEXT:    xvsubdp 2, 1, 0
; PC64LE-NEXT:    xxswapd 1, 2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fsub_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    # kill: def $f5 killed $f5 def $vsl5
; PC64LE9-NEXT:    # kill: def $f4 killed $f4 def $vsl4
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 0, 5, 4
; PC64LE9-NEXT:    xxmrghd 1, 2, 1
; PC64LE9-NEXT:    xssubdp 3, 3, 6
; PC64LE9-NEXT:    xvsubdp 2, 1, 0
; PC64LE9-NEXT:    xxswapd 1, 2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    blr
entry:
  %sub = call <3 x double> @llvm.experimental.constrained.fsub.v3f64(
           <3 x double> %x,
           <3 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <3 x double> %sub
}

define <4 x double> @constrained_vector_fsub_v4f64(<4 x double> %x, <4 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_fsub_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvsubdp 35, 35, 37
; PC64LE-NEXT:    xvsubdp 34, 34, 36
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fsub_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvsubdp 35, 35, 37
; PC64LE9-NEXT:    xvsubdp 34, 34, 36
; PC64LE9-NEXT:    blr
entry:
  %sub = call <4 x double> @llvm.experimental.constrained.fsub.v4f64(
           <4 x double> %x,
           <4 x double> %y,
           metadata !"round.dynamic",
           metadata !"fpexcept.strict") #1
  ret <4 x double> %sub
}

define <1 x float> @constrained_vector_sqrt_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_sqrt_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xssqrtsp 1, 1
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sqrt_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xssqrtsp 1, 1
; PC64LE9-NEXT:    blr
entry:
  %sqrt = call <1 x float> @llvm.experimental.constrained.sqrt.v1f32(
                              <1 x float> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <1 x float> %sqrt
}

define <2 x double> @constrained_vector_sqrt_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_sqrt_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvsqrtdp 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sqrt_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvsqrtdp 34, 34
; PC64LE9-NEXT:    blr
entry:
  %sqrt = call <2 x double> @llvm.experimental.constrained.sqrt.v2f64(
                              <2 x double> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <2 x double> %sqrt
}

define <3 x float> @constrained_vector_sqrt_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_sqrt_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 3
; PC64LE-NEXT:    addis 3, 2, .LCPI27_0@toc@ha
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    addi 3, 3, .LCPI27_0@toc@l
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    xssqrtsp 0, 0
; PC64LE-NEXT:    xssqrtsp 1, 1
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xxmrghw 34, 0, 1
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvspdpn 0, 2
; PC64LE-NEXT:    xssqrtsp 0, 0
; PC64LE-NEXT:    xscvdpspn 36, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sqrt_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xxsldwi 2, 34, 34, 3
; PC64LE9-NEXT:    addis 3, 2, .LCPI27_0@toc@ha
; PC64LE9-NEXT:    addi 3, 3, .LCPI27_0@toc@l
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xssqrtsp 1, 1
; PC64LE9-NEXT:    xssqrtsp 2, 2
; PC64LE9-NEXT:    xssqrtsp 0, 0
; PC64LE9-NEXT:    xscvdpspn 2, 2
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xscvdpspn 34, 0
; PC64LE9-NEXT:    xxmrghw 35, 1, 2
; PC64LE9-NEXT:    lxv 1, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 1
; PC64LE9-NEXT:    blr
entry:
  %sqrt = call <3 x float> @llvm.experimental.constrained.sqrt.v3f32(
                              <3 x float> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %sqrt
}

define <3 x double> @constrained_vector_sqrt_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_sqrt_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 0, 2, 1
; PC64LE-NEXT:    xssqrtdp 3, 3
; PC64LE-NEXT:    xvsqrtdp 2, 0
; PC64LE-NEXT:    xxswapd 1, 2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sqrt_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 0, 2, 1
; PC64LE9-NEXT:    xssqrtdp 3, 3
; PC64LE9-NEXT:    xvsqrtdp 2, 0
; PC64LE9-NEXT:    xxswapd 1, 2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    blr
entry:
  %sqrt = call <3 x double> @llvm.experimental.constrained.sqrt.v3f64(
                          <3 x double> %x,
                          metadata !"round.dynamic",
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %sqrt
}

define <4 x double> @constrained_vector_sqrt_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_sqrt_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvsqrtdp 35, 35
; PC64LE-NEXT:    xvsqrtdp 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sqrt_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvsqrtdp 35, 35
; PC64LE9-NEXT:    xvsqrtdp 34, 34
; PC64LE9-NEXT:    blr
 entry:
  %sqrt = call <4 x double> @llvm.experimental.constrained.sqrt.v4f64(
                              <4 x double> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <4 x double> %sqrt
}

define <1 x float> @constrained_vector_pow_v1f32(<1 x float> %x, <1 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_pow_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -32(1)
; PC64LE-NEXT:    std 0, 48(1)
; PC64LE-NEXT:    bl powf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    addi 1, 1, 32
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_pow_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -32(1)
; PC64LE9-NEXT:    std 0, 48(1)
; PC64LE9-NEXT:    bl powf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    addi 1, 1, 32
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %pow = call <1 x float> @llvm.experimental.constrained.pow.v1f32(
                             <1 x float> %x,
                             <1 x float> %y,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <1 x float> %pow
}

define <2 x double> @constrained_vector_pow_v2f64(<2 x double> %x, <2 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_pow_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stxvd2x 61, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    xxlor 1, 62, 62
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    bl pow
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 62
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    xxswapd 2, 63
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    bl pow
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 34, 61, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 61, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_pow_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stxv 62, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 64(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscpsgndp 1, 62, 62
; PC64LE9-NEXT:    stxv 61, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    bl pow
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 62
; PC64LE9-NEXT:    xxswapd 2, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    bl pow
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 34, 61, 1
; PC64LE9-NEXT:    lxv 63, 64(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 61, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %pow = call <2 x double> @llvm.experimental.constrained.pow.v2f64(
                             <2 x double> %x,
                             <2 x double> %y,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <2 x double> %pow
}

define <3 x float> @constrained_vector_pow_v3f32(<3 x float> %x, <3 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_pow_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    xxsldwi 2, 35, 35, 1
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stfd 30, 80(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 88(1) # 8-byte Folded Spill
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    xscvspdpn 2, 2
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    bl powf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxswapd 0, 62
; PC64LE-NEXT:    xxswapd 2, 63
; PC64LE-NEXT:    fmr 31, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    xscvspdpn 2, 2
; PC64LE-NEXT:    bl powf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxsldwi 0, 62, 62, 3
; PC64LE-NEXT:    xxsldwi 2, 63, 63, 3
; PC64LE-NEXT:    fmr 30, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    xscvspdpn 2, 2
; PC64LE-NEXT:    bl powf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xscvdpspn 0, 1
; PC64LE-NEXT:    xscvdpspn 1, 30
; PC64LE-NEXT:    addis 3, 2, .LCPI32_0@toc@ha
; PC64LE-NEXT:    lfd 30, 80(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xscvdpspn 36, 31
; PC64LE-NEXT:    lfd 31, 88(1) # 8-byte Folded Reload
; PC64LE-NEXT:    addi 3, 3, .LCPI32_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_pow_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 62, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    xxsldwi 0, 35, 35, 1
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscvspdpn 2, 0
; PC64LE9-NEXT:    bl powf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxswapd 0, 62
; PC64LE9-NEXT:    fmr 31, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    xxswapd 0, 63
; PC64LE9-NEXT:    xscvspdpn 2, 0
; PC64LE9-NEXT:    bl powf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxsldwi 0, 62, 62, 3
; PC64LE9-NEXT:    fmr 30, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE9-NEXT:    xscvspdpn 2, 0
; PC64LE9-NEXT:    bl powf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscvdpspn 0, 1
; PC64LE9-NEXT:    xscvdpspn 1, 30
; PC64LE9-NEXT:    addis 3, 2, .LCPI32_0@toc@ha
; PC64LE9-NEXT:    xscvdpspn 34, 31
; PC64LE9-NEXT:    lxv 63, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 3, 3, .LCPI32_0@toc@l
; PC64LE9-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %pow = call <3 x float> @llvm.experimental.constrained.pow.v3f32(
                             <3 x float> %x,
                             <3 x float> %y,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <3 x float> %pow
}

define <3 x double> @constrained_vector_pow_v3f64(<3 x double> %x, <3 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_pow_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stfd 28, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 28, 2
; PC64LE-NEXT:    fmr 2, 4
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    stfd 29, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 30, 80(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 30, 5
; PC64LE-NEXT:    stfd 31, 88(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    fmr 31, 6
; PC64LE-NEXT:    fmr 29, 3
; PC64LE-NEXT:    bl pow
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 63, 1, 1
; PC64LE-NEXT:    fmr 1, 28
; PC64LE-NEXT:    fmr 2, 30
; PC64LE-NEXT:    bl pow
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 63, 1, 63
; PC64LE-NEXT:    fmr 1, 29
; PC64LE-NEXT:    fmr 2, 31
; PC64LE-NEXT:    bl pow
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    fmr 3, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    lfd 31, 88(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    lfd 30, 80(1) # 8-byte Folded Reload
; PC64LE-NEXT:    lfd 29, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    lfd 28, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_pow_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stfd 28, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    fmr 28, 2
; PC64LE9-NEXT:    fmr 2, 4
; PC64LE9-NEXT:    stfd 29, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    fmr 31, 6
; PC64LE9-NEXT:    fmr 30, 5
; PC64LE9-NEXT:    fmr 29, 3
; PC64LE9-NEXT:    bl pow
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 63, 1, 1
; PC64LE9-NEXT:    fmr 1, 28
; PC64LE9-NEXT:    fmr 2, 30
; PC64LE9-NEXT:    bl pow
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 63, 1, 63
; PC64LE9-NEXT:    fmr 1, 29
; PC64LE9-NEXT:    fmr 2, 31
; PC64LE9-NEXT:    bl pow
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    fmr 3, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    lfd 29, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    lfd 28, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %pow = call <3 x double> @llvm.experimental.constrained.pow.v3f64(
                          <3 x double> %x,
                          <3 x double> %y,
                          metadata !"round.dynamic",
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %pow
}

define <4 x double> @constrained_vector_pow_v4f64(<4 x double> %x, <4 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_pow_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -128(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 144(1)
; PC64LE-NEXT:    stxvd2x 59, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 60, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    vmr 28, 2
; PC64LE-NEXT:    stxvd2x 61, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 96
; PC64LE-NEXT:    xxlor 1, 60, 60
; PC64LE-NEXT:    vmr 29, 3
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 30, 4
; PC64LE-NEXT:    li 3, 112
; PC64LE-NEXT:    xxlor 2, 62, 62
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 5
; PC64LE-NEXT:    bl pow
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 59, 1, 1
; PC64LE-NEXT:    xxswapd 1, 60
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    xxswapd 2, 62
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    bl pow
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 62, 59, 1
; PC64LE-NEXT:    xxlor 1, 61, 61
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    bl pow
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 60, 1, 1
; PC64LE-NEXT:    xxswapd 1, 61
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    xxswapd 2, 63
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    bl pow
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 112
; PC64LE-NEXT:    vmr 2, 30
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 35, 60, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 96
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    lxvd2x 61, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 60, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 59, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 128
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_pow_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -112(1)
; PC64LE9-NEXT:    std 0, 128(1)
; PC64LE9-NEXT:    stxv 60, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 62, 80(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 30, 4
; PC64LE9-NEXT:    xscpsgndp 2, 62, 62
; PC64LE9-NEXT:    vmr 28, 2
; PC64LE9-NEXT:    xscpsgndp 1, 60, 60
; PC64LE9-NEXT:    stxv 59, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 61, 64(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 96(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 5
; PC64LE9-NEXT:    vmr 29, 3
; PC64LE9-NEXT:    bl pow
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 59, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 60
; PC64LE9-NEXT:    xxswapd 2, 62
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    bl pow
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 62, 59, 1
; PC64LE9-NEXT:    xscpsgndp 1, 61, 61
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    bl pow
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 60, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 61
; PC64LE9-NEXT:    xxswapd 2, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    bl pow
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 35, 60, 1
; PC64LE9-NEXT:    vmr 2, 30
; PC64LE9-NEXT:    lxv 63, 96(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 80(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 61, 64(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 60, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 59, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 112
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %pow = call <4 x double> @llvm.experimental.constrained.pow.v4f64(
                             <4 x double> %x,
                             <4 x double> %y,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <4 x double> %pow
}

define <1 x float> @constrained_vector_powi_v1f32(<1 x float> %x, i32 %y) #0 {
; PC64LE-LABEL: constrained_vector_powi_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -32(1)
; PC64LE-NEXT:    clrldi 4, 4, 32
; PC64LE-NEXT:    std 0, 48(1)
; PC64LE-NEXT:    bl __powisf2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    addi 1, 1, 32
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_powi_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -32(1)
; PC64LE9-NEXT:    clrldi 4, 4, 32
; PC64LE9-NEXT:    std 0, 48(1)
; PC64LE9-NEXT:    bl __powisf2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    addi 1, 1, 32
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %powi = call <1 x float> @llvm.experimental.constrained.powi.v1f32(
                              <1 x float> %x,
                              i32 %y,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <1 x float> %powi
}

define <2 x double> @constrained_vector_powi_v2f64(<2 x double> %x, i32 %y) #0 {
; PC64LE-LABEL: constrained_vector_powi_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    std 30, 80(1) # 8-byte Folded Spill
; PC64LE-NEXT:    clrldi 30, 5, 32
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    mr 4, 30
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl __powidf2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    mr 4, 30
; PC64LE-NEXT:    xxlor 62, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl __powidf2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 34, 62, 1
; PC64LE-NEXT:    ld 30, 80(1) # 8-byte Folded Reload
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_powi_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    std 30, 64(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    clrldi 30, 5, 32
; PC64LE9-NEXT:    stxv 62, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    mr 4, 30
; PC64LE9-NEXT:    bl __powidf2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    mr 4, 30
; PC64LE9-NEXT:    xscpsgndp 62, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl __powidf2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 34, 62, 1
; PC64LE9-NEXT:    lxv 63, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    ld 30, 64(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %powi = call <2 x double> @llvm.experimental.constrained.powi.v2f64(
                              <2 x double> %x,
                              i32 %y,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <2 x double> %powi
}

define <3 x float> @constrained_vector_powi_v3f32(<3 x float> %x, i32 %y) #0 {
;
;
; PC64LE-LABEL: constrained_vector_powi_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    std 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    clrldi 30, 5, 32
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    stfd 30, 80(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 88(1) # 8-byte Folded Spill
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    mr 4, 30
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    bl __powisf2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxswapd 0, 63
; PC64LE-NEXT:    fmr 31, 1
; PC64LE-NEXT:    mr 4, 30
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl __powisf2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE-NEXT:    fmr 30, 1
; PC64LE-NEXT:    mr 4, 30
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl __powisf2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xscvdpspn 0, 1
; PC64LE-NEXT:    xscvdpspn 1, 30
; PC64LE-NEXT:    addis 3, 2, .LCPI37_0@toc@ha
; PC64LE-NEXT:    lfd 30, 80(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xscvdpspn 36, 31
; PC64LE-NEXT:    lfd 31, 88(1) # 8-byte Folded Reload
; PC64LE-NEXT:    ld 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    addi 3, 3, .LCPI37_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_powi_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    std 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    clrldi 30, 5, 32
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    mr 4, 30
; PC64LE9-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl __powisf2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxswapd 0, 63
; PC64LE9-NEXT:    fmr 31, 1
; PC64LE9-NEXT:    mr 4, 30
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl __powisf2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE9-NEXT:    fmr 30, 1
; PC64LE9-NEXT:    mr 4, 30
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl __powisf2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscvdpspn 0, 1
; PC64LE9-NEXT:    xscvdpspn 1, 30
; PC64LE9-NEXT:    addis 3, 2, .LCPI37_0@toc@ha
; PC64LE9-NEXT:    xscvdpspn 34, 31
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    ld 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 3, 3, .LCPI37_0@toc@l
; PC64LE9-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %powi = call <3 x float> @llvm.experimental.constrained.powi.v3f32(
                              <3 x float> %x,
                              i32 %y,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %powi
}

define <3 x double> @constrained_vector_powi_v3f64(<3 x double> %x, i32 %y) #0 {
; PC64LE-LABEL: constrained_vector_powi_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    std 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    clrldi 30, 6, 32
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    stfd 30, 80(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 88(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 31, 3
; PC64LE-NEXT:    fmr 30, 2
; PC64LE-NEXT:    mr 4, 30
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    bl __powidf2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 63, 1, 1
; PC64LE-NEXT:    fmr 1, 30
; PC64LE-NEXT:    mr 4, 30
; PC64LE-NEXT:    bl __powidf2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 63, 1, 63
; PC64LE-NEXT:    fmr 1, 31
; PC64LE-NEXT:    mr 4, 30
; PC64LE-NEXT:    bl __powidf2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    fmr 3, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    lfd 31, 88(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    lfd 30, 80(1) # 8-byte Folded Reload
; PC64LE-NEXT:    ld 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_powi_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    std 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    clrldi 30, 6, 32
; PC64LE9-NEXT:    mr 4, 30
; PC64LE9-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    fmr 31, 3
; PC64LE9-NEXT:    fmr 30, 2
; PC64LE9-NEXT:    bl __powidf2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 63, 1, 1
; PC64LE9-NEXT:    fmr 1, 30
; PC64LE9-NEXT:    mr 4, 30
; PC64LE9-NEXT:    bl __powidf2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 63, 1, 63
; PC64LE9-NEXT:    fmr 1, 31
; PC64LE9-NEXT:    mr 4, 30
; PC64LE9-NEXT:    bl __powidf2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    fmr 3, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    ld 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %powi = call <3 x double> @llvm.experimental.constrained.powi.v3f64(
                          <3 x double> %x,
                          i32 %y,
                          metadata !"round.dynamic",
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %powi
}

define <4 x double> @constrained_vector_powi_v4f64(<4 x double> %x, i32 %y) #0 {
; PC64LE-LABEL: constrained_vector_powi_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -112(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 128(1)
; PC64LE-NEXT:    std 30, 96(1) # 8-byte Folded Spill
; PC64LE-NEXT:    clrldi 30, 7, 32
; PC64LE-NEXT:    stxvd2x 61, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    mr 4, 30
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    xxlor 1, 62, 62
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    bl __powidf2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    mr 4, 30
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 62
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl __powidf2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 62, 61, 1
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    mr 4, 30
; PC64LE-NEXT:    bl __powidf2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    mr 4, 30
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl __powidf2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    vmr 2, 30
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 35, 61, 1
; PC64LE-NEXT:    ld 30, 96(1) # 8-byte Folded Reload
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 61, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 112
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_powi_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -96(1)
; PC64LE9-NEXT:    std 0, 112(1)
; PC64LE9-NEXT:    std 30, 80(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 62, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    clrldi 30, 7, 32
; PC64LE9-NEXT:    stxv 61, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    xscpsgndp 1, 62, 62
; PC64LE9-NEXT:    mr 4, 30
; PC64LE9-NEXT:    stxv 63, 64(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    bl __powidf2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    mr 4, 30
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 62
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl __powidf2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 62, 61, 1
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    mr 4, 30
; PC64LE9-NEXT:    bl __powidf2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    mr 4, 30
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl __powidf2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 35, 61, 1
; PC64LE9-NEXT:    vmr 2, 30
; PC64LE9-NEXT:    lxv 63, 64(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 61, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    ld 30, 80(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 96
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %powi = call <4 x double> @llvm.experimental.constrained.powi.v4f64(
                              <4 x double> %x,
                              i32 %y,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <4 x double> %powi
}

define <1 x float> @constrained_vector_sin_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_sin_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -32(1)
; PC64LE-NEXT:    std 0, 48(1)
; PC64LE-NEXT:    bl sinf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    addi 1, 1, 32
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sin_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -32(1)
; PC64LE9-NEXT:    std 0, 48(1)
; PC64LE9-NEXT:    bl sinf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    addi 1, 1, 32
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %sin = call <1 x float> @llvm.experimental.constrained.sin.v1f32(
                             <1 x float> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <1 x float> %sin
}

define <2 x double> @constrained_vector_sin_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_sin_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl sin
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 62, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl sin
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 34, 62, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sin_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stxv 63, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    stxv 62, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    bl sin
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 62, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl sin
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 34, 62, 1
; PC64LE9-NEXT:    lxv 63, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %sin = call <2 x double> @llvm.experimental.constrained.sin.v2f64(
                             <2 x double> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <2 x double> %sin
}

define <3 x float> @constrained_vector_sin_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_sin_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    bl sinf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxswapd 0, 63
; PC64LE-NEXT:    fmr 31, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl sinf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE-NEXT:    fmr 30, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl sinf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xscvdpspn 0, 1
; PC64LE-NEXT:    xscvdpspn 1, 30
; PC64LE-NEXT:    addis 3, 2, .LCPI42_0@toc@ha
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xscvdpspn 36, 31
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    addi 3, 3, .LCPI42_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sin_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl sinf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxswapd 0, 63
; PC64LE9-NEXT:    fmr 31, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl sinf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE9-NEXT:    fmr 30, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl sinf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscvdpspn 0, 1
; PC64LE9-NEXT:    xscvdpspn 1, 30
; PC64LE9-NEXT:    addis 3, 2, .LCPI42_0@toc@ha
; PC64LE9-NEXT:    xscvdpspn 34, 31
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 3, 3, .LCPI42_0@toc@l
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %sin = call <3 x float> @llvm.experimental.constrained.sin.v3f32(
                              <3 x float> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %sin
}

define <3 x double> @constrained_vector_sin_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_sin_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 30, 2
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 31, 3
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    bl sin
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 63, 1, 1
; PC64LE-NEXT:    fmr 1, 30
; PC64LE-NEXT:    bl sin
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 63, 1, 63
; PC64LE-NEXT:    fmr 1, 31
; PC64LE-NEXT:    bl sin
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    fmr 3, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sin_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    fmr 31, 3
; PC64LE9-NEXT:    fmr 30, 2
; PC64LE9-NEXT:    bl sin
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 63, 1, 1
; PC64LE9-NEXT:    fmr 1, 30
; PC64LE9-NEXT:    bl sin
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 63, 1, 63
; PC64LE9-NEXT:    fmr 1, 31
; PC64LE9-NEXT:    bl sin
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    fmr 3, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %sin = call <3 x double> @llvm.experimental.constrained.sin.v3f64(
                          <3 x double> %x,
                          metadata !"round.dynamic",
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %sin
}

define <4 x double> @constrained_vector_sin_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_sin_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stxvd2x 61, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    xxlor 1, 62, 62
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    bl sin
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 62
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl sin
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 62, 61, 1
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl sin
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl sin
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    vmr 2, 30
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 35, 61, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 61, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sin_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stxv 62, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscpsgndp 1, 62, 62
; PC64LE9-NEXT:    stxv 61, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 64(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    bl sin
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 62
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl sin
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 62, 61, 1
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    bl sin
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl sin
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 35, 61, 1
; PC64LE9-NEXT:    vmr 2, 30
; PC64LE9-NEXT:    lxv 63, 64(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 61, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %sin = call <4 x double> @llvm.experimental.constrained.sin.v4f64(
                             <4 x double> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <4 x double> %sin
}

define <1 x float> @constrained_vector_cos_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_cos_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -32(1)
; PC64LE-NEXT:    std 0, 48(1)
; PC64LE-NEXT:    bl cosf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    addi 1, 1, 32
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_cos_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -32(1)
; PC64LE9-NEXT:    std 0, 48(1)
; PC64LE9-NEXT:    bl cosf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    addi 1, 1, 32
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %cos = call <1 x float> @llvm.experimental.constrained.cos.v1f32(
                             <1 x float> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <1 x float> %cos
}

define <2 x double> @constrained_vector_cos_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_cos_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl cos
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 62, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl cos
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 34, 62, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_cos_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stxv 63, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    stxv 62, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    bl cos
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 62, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl cos
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 34, 62, 1
; PC64LE9-NEXT:    lxv 63, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %cos = call <2 x double> @llvm.experimental.constrained.cos.v2f64(
                             <2 x double> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <2 x double> %cos
}

define <3 x float> @constrained_vector_cos_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_cos_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    bl cosf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxswapd 0, 63
; PC64LE-NEXT:    fmr 31, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl cosf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE-NEXT:    fmr 30, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl cosf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xscvdpspn 0, 1
; PC64LE-NEXT:    xscvdpspn 1, 30
; PC64LE-NEXT:    addis 3, 2, .LCPI47_0@toc@ha
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xscvdpspn 36, 31
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    addi 3, 3, .LCPI47_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_cos_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl cosf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxswapd 0, 63
; PC64LE9-NEXT:    fmr 31, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl cosf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE9-NEXT:    fmr 30, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl cosf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscvdpspn 0, 1
; PC64LE9-NEXT:    xscvdpspn 1, 30
; PC64LE9-NEXT:    addis 3, 2, .LCPI47_0@toc@ha
; PC64LE9-NEXT:    xscvdpspn 34, 31
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 3, 3, .LCPI47_0@toc@l
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %cos = call <3 x float> @llvm.experimental.constrained.cos.v3f32(
                              <3 x float> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %cos
}

define <3 x double> @constrained_vector_cos_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_cos_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 30, 2
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 31, 3
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    bl cos
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 63, 1, 1
; PC64LE-NEXT:    fmr 1, 30
; PC64LE-NEXT:    bl cos
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 63, 1, 63
; PC64LE-NEXT:    fmr 1, 31
; PC64LE-NEXT:    bl cos
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    fmr 3, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_cos_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    fmr 31, 3
; PC64LE9-NEXT:    fmr 30, 2
; PC64LE9-NEXT:    bl cos
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 63, 1, 1
; PC64LE9-NEXT:    fmr 1, 30
; PC64LE9-NEXT:    bl cos
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 63, 1, 63
; PC64LE9-NEXT:    fmr 1, 31
; PC64LE9-NEXT:    bl cos
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    fmr 3, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %cos = call <3 x double> @llvm.experimental.constrained.cos.v3f64(
                          <3 x double> %x,
                          metadata !"round.dynamic",
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %cos
}

define <4 x double> @constrained_vector_cos_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_cos_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stxvd2x 61, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    xxlor 1, 62, 62
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    bl cos
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 62
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl cos
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 62, 61, 1
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl cos
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl cos
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    vmr 2, 30
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 35, 61, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 61, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_cos_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stxv 62, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscpsgndp 1, 62, 62
; PC64LE9-NEXT:    stxv 61, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 64(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    bl cos
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 62
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl cos
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 62, 61, 1
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    bl cos
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl cos
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 35, 61, 1
; PC64LE9-NEXT:    vmr 2, 30
; PC64LE9-NEXT:    lxv 63, 64(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 61, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %cos = call <4 x double> @llvm.experimental.constrained.cos.v4f64(
                             <4 x double> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <4 x double> %cos
}

define <1 x float> @constrained_vector_exp_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_exp_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -32(1)
; PC64LE-NEXT:    std 0, 48(1)
; PC64LE-NEXT:    bl expf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    addi 1, 1, 32
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_exp_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -32(1)
; PC64LE9-NEXT:    std 0, 48(1)
; PC64LE9-NEXT:    bl expf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    addi 1, 1, 32
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %exp = call <1 x float> @llvm.experimental.constrained.exp.v1f32(
                             <1 x float> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <1 x float> %exp
}

define <2 x double> @constrained_vector_exp_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_exp_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl exp
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 62, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl exp
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 34, 62, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_exp_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stxv 63, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    stxv 62, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    bl exp
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 62, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl exp
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 34, 62, 1
; PC64LE9-NEXT:    lxv 63, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %exp = call <2 x double> @llvm.experimental.constrained.exp.v2f64(
                             <2 x double> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <2 x double> %exp
}

define <3 x float> @constrained_vector_exp_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_exp_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    bl expf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxswapd 0, 63
; PC64LE-NEXT:    fmr 31, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl expf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE-NEXT:    fmr 30, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl expf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xscvdpspn 0, 1
; PC64LE-NEXT:    xscvdpspn 1, 30
; PC64LE-NEXT:    addis 3, 2, .LCPI52_0@toc@ha
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xscvdpspn 36, 31
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    addi 3, 3, .LCPI52_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_exp_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl expf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxswapd 0, 63
; PC64LE9-NEXT:    fmr 31, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl expf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE9-NEXT:    fmr 30, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl expf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscvdpspn 0, 1
; PC64LE9-NEXT:    xscvdpspn 1, 30
; PC64LE9-NEXT:    addis 3, 2, .LCPI52_0@toc@ha
; PC64LE9-NEXT:    xscvdpspn 34, 31
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 3, 3, .LCPI52_0@toc@l
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %exp = call <3 x float> @llvm.experimental.constrained.exp.v3f32(
                              <3 x float> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %exp
}

define <3 x double> @constrained_vector_exp_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_exp_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 30, 2
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 31, 3
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    bl exp
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 63, 1, 1
; PC64LE-NEXT:    fmr 1, 30
; PC64LE-NEXT:    bl exp
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 63, 1, 63
; PC64LE-NEXT:    fmr 1, 31
; PC64LE-NEXT:    bl exp
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    fmr 3, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_exp_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    fmr 31, 3
; PC64LE9-NEXT:    fmr 30, 2
; PC64LE9-NEXT:    bl exp
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 63, 1, 1
; PC64LE9-NEXT:    fmr 1, 30
; PC64LE9-NEXT:    bl exp
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 63, 1, 63
; PC64LE9-NEXT:    fmr 1, 31
; PC64LE9-NEXT:    bl exp
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    fmr 3, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %exp = call <3 x double> @llvm.experimental.constrained.exp.v3f64(
                          <3 x double> %x,
                          metadata !"round.dynamic",
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %exp
}

define <4 x double> @constrained_vector_exp_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_exp_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stxvd2x 61, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    xxlor 1, 62, 62
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    bl exp
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 62
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl exp
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 62, 61, 1
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl exp
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl exp
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    vmr 2, 30
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 35, 61, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 61, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_exp_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stxv 62, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscpsgndp 1, 62, 62
; PC64LE9-NEXT:    stxv 61, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 64(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    bl exp
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 62
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl exp
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 62, 61, 1
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    bl exp
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl exp
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 35, 61, 1
; PC64LE9-NEXT:    vmr 2, 30
; PC64LE9-NEXT:    lxv 63, 64(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 61, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %exp = call <4 x double> @llvm.experimental.constrained.exp.v4f64(
                             <4 x double> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <4 x double> %exp
}

define <1 x float> @constrained_vector_exp2_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_exp2_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -32(1)
; PC64LE-NEXT:    std 0, 48(1)
; PC64LE-NEXT:    bl exp2f
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    addi 1, 1, 32
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_exp2_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -32(1)
; PC64LE9-NEXT:    std 0, 48(1)
; PC64LE9-NEXT:    bl exp2f
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    addi 1, 1, 32
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %exp2 = call <1 x float> @llvm.experimental.constrained.exp2.v1f32(
                             <1 x float> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <1 x float> %exp2
}

define <2 x double> @constrained_vector_exp2_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_exp2_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl exp2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 62, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl exp2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 34, 62, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_exp2_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stxv 63, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    stxv 62, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    bl exp2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 62, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl exp2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 34, 62, 1
; PC64LE9-NEXT:    lxv 63, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %exp2 = call <2 x double> @llvm.experimental.constrained.exp2.v2f64(
                              <2 x double> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <2 x double> %exp2
}

define <3 x float> @constrained_vector_exp2_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_exp2_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    bl exp2f
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxswapd 0, 63
; PC64LE-NEXT:    fmr 31, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl exp2f
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE-NEXT:    fmr 30, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl exp2f
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xscvdpspn 0, 1
; PC64LE-NEXT:    xscvdpspn 1, 30
; PC64LE-NEXT:    addis 3, 2, .LCPI57_0@toc@ha
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xscvdpspn 36, 31
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    addi 3, 3, .LCPI57_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_exp2_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl exp2f
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxswapd 0, 63
; PC64LE9-NEXT:    fmr 31, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl exp2f
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE9-NEXT:    fmr 30, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl exp2f
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscvdpspn 0, 1
; PC64LE9-NEXT:    xscvdpspn 1, 30
; PC64LE9-NEXT:    addis 3, 2, .LCPI57_0@toc@ha
; PC64LE9-NEXT:    xscvdpspn 34, 31
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 3, 3, .LCPI57_0@toc@l
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %exp2 = call <3 x float> @llvm.experimental.constrained.exp2.v3f32(
                              <3 x float> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %exp2
}

define <3 x double> @constrained_vector_exp2_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_exp2_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 30, 2
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 31, 3
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    bl exp2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 63, 1, 1
; PC64LE-NEXT:    fmr 1, 30
; PC64LE-NEXT:    bl exp2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 63, 1, 63
; PC64LE-NEXT:    fmr 1, 31
; PC64LE-NEXT:    bl exp2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    fmr 3, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_exp2_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    fmr 31, 3
; PC64LE9-NEXT:    fmr 30, 2
; PC64LE9-NEXT:    bl exp2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 63, 1, 1
; PC64LE9-NEXT:    fmr 1, 30
; PC64LE9-NEXT:    bl exp2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 63, 1, 63
; PC64LE9-NEXT:    fmr 1, 31
; PC64LE9-NEXT:    bl exp2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    fmr 3, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %exp2 = call <3 x double> @llvm.experimental.constrained.exp2.v3f64(
                          <3 x double> %x,
                          metadata !"round.dynamic",
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %exp2
}

define <4 x double> @constrained_vector_exp2_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_exp2_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stxvd2x 61, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    xxlor 1, 62, 62
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    bl exp2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 62
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl exp2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 62, 61, 1
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl exp2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl exp2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    vmr 2, 30
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 35, 61, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 61, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_exp2_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stxv 62, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscpsgndp 1, 62, 62
; PC64LE9-NEXT:    stxv 61, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 64(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    bl exp2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 62
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl exp2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 62, 61, 1
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    bl exp2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl exp2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 35, 61, 1
; PC64LE9-NEXT:    vmr 2, 30
; PC64LE9-NEXT:    lxv 63, 64(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 61, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %exp2 = call <4 x double> @llvm.experimental.constrained.exp2.v4f64(
                              <4 x double> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <4 x double> %exp2
}

define <1 x float> @constrained_vector_log_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_log_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -32(1)
; PC64LE-NEXT:    std 0, 48(1)
; PC64LE-NEXT:    bl logf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    addi 1, 1, 32
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -32(1)
; PC64LE9-NEXT:    std 0, 48(1)
; PC64LE9-NEXT:    bl logf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    addi 1, 1, 32
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log = call <1 x float> @llvm.experimental.constrained.log.v1f32(
                             <1 x float> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <1 x float> %log
}

define <2 x double> @constrained_vector_log_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_log_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl log
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 62, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl log
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 34, 62, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stxv 63, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    stxv 62, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    bl log
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 62, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl log
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 34, 62, 1
; PC64LE9-NEXT:    lxv 63, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log = call <2 x double> @llvm.experimental.constrained.log.v2f64(
                             <2 x double> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <2 x double> %log
}

define <3 x float> @constrained_vector_log_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_log_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    bl logf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxswapd 0, 63
; PC64LE-NEXT:    fmr 31, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl logf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE-NEXT:    fmr 30, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl logf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xscvdpspn 0, 1
; PC64LE-NEXT:    xscvdpspn 1, 30
; PC64LE-NEXT:    addis 3, 2, .LCPI62_0@toc@ha
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xscvdpspn 36, 31
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    addi 3, 3, .LCPI62_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl logf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxswapd 0, 63
; PC64LE9-NEXT:    fmr 31, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl logf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE9-NEXT:    fmr 30, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl logf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscvdpspn 0, 1
; PC64LE9-NEXT:    xscvdpspn 1, 30
; PC64LE9-NEXT:    addis 3, 2, .LCPI62_0@toc@ha
; PC64LE9-NEXT:    xscvdpspn 34, 31
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 3, 3, .LCPI62_0@toc@l
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log = call <3 x float> @llvm.experimental.constrained.log.v3f32(
                              <3 x float> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %log
}

define <3 x double> @constrained_vector_log_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_log_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 30, 2
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 31, 3
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    bl log
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 63, 1, 1
; PC64LE-NEXT:    fmr 1, 30
; PC64LE-NEXT:    bl log
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 63, 1, 63
; PC64LE-NEXT:    fmr 1, 31
; PC64LE-NEXT:    bl log
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    fmr 3, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    fmr 31, 3
; PC64LE9-NEXT:    fmr 30, 2
; PC64LE9-NEXT:    bl log
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 63, 1, 1
; PC64LE9-NEXT:    fmr 1, 30
; PC64LE9-NEXT:    bl log
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 63, 1, 63
; PC64LE9-NEXT:    fmr 1, 31
; PC64LE9-NEXT:    bl log
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    fmr 3, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log = call <3 x double> @llvm.experimental.constrained.log.v3f64(
                          <3 x double> %x,
                          metadata !"round.dynamic",
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %log
}

define <4 x double> @constrained_vector_log_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_log_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stxvd2x 61, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    xxlor 1, 62, 62
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    bl log
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 62
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl log
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 62, 61, 1
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl log
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl log
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    vmr 2, 30
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 35, 61, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 61, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stxv 62, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscpsgndp 1, 62, 62
; PC64LE9-NEXT:    stxv 61, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 64(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    bl log
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 62
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl log
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 62, 61, 1
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    bl log
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl log
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 35, 61, 1
; PC64LE9-NEXT:    vmr 2, 30
; PC64LE9-NEXT:    lxv 63, 64(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 61, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log = call <4 x double> @llvm.experimental.constrained.log.v4f64(
                             <4 x double> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <4 x double> %log
}

define <1 x float> @constrained_vector_log10_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_log10_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -32(1)
; PC64LE-NEXT:    std 0, 48(1)
; PC64LE-NEXT:    bl log10f
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    addi 1, 1, 32
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log10_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -32(1)
; PC64LE9-NEXT:    std 0, 48(1)
; PC64LE9-NEXT:    bl log10f
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    addi 1, 1, 32
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log10 = call <1 x float> @llvm.experimental.constrained.log10.v1f32(
                             <1 x float> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <1 x float> %log10
}

define <2 x double> @constrained_vector_log10_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_log10_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl log10
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 62, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl log10
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 34, 62, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log10_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stxv 63, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    stxv 62, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    bl log10
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 62, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl log10
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 34, 62, 1
; PC64LE9-NEXT:    lxv 63, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log10 = call <2 x double> @llvm.experimental.constrained.log10.v2f64(
                               <2 x double> %x,
                               metadata !"round.dynamic",
                               metadata !"fpexcept.strict") #1
  ret <2 x double> %log10
}

define <3 x float> @constrained_vector_log10_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_log10_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    bl log10f
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxswapd 0, 63
; PC64LE-NEXT:    fmr 31, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl log10f
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE-NEXT:    fmr 30, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl log10f
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xscvdpspn 0, 1
; PC64LE-NEXT:    xscvdpspn 1, 30
; PC64LE-NEXT:    addis 3, 2, .LCPI67_0@toc@ha
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xscvdpspn 36, 31
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    addi 3, 3, .LCPI67_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log10_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl log10f
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxswapd 0, 63
; PC64LE9-NEXT:    fmr 31, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl log10f
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE9-NEXT:    fmr 30, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl log10f
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscvdpspn 0, 1
; PC64LE9-NEXT:    xscvdpspn 1, 30
; PC64LE9-NEXT:    addis 3, 2, .LCPI67_0@toc@ha
; PC64LE9-NEXT:    xscvdpspn 34, 31
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 3, 3, .LCPI67_0@toc@l
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log10 = call <3 x float> @llvm.experimental.constrained.log10.v3f32(
                              <3 x float> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %log10
}

define <3 x double> @constrained_vector_log10_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_log10_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 30, 2
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 31, 3
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    bl log10
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 63, 1, 1
; PC64LE-NEXT:    fmr 1, 30
; PC64LE-NEXT:    bl log10
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 63, 1, 63
; PC64LE-NEXT:    fmr 1, 31
; PC64LE-NEXT:    bl log10
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    fmr 3, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log10_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    fmr 31, 3
; PC64LE9-NEXT:    fmr 30, 2
; PC64LE9-NEXT:    bl log10
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 63, 1, 1
; PC64LE9-NEXT:    fmr 1, 30
; PC64LE9-NEXT:    bl log10
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 63, 1, 63
; PC64LE9-NEXT:    fmr 1, 31
; PC64LE9-NEXT:    bl log10
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    fmr 3, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log10 = call <3 x double> @llvm.experimental.constrained.log10.v3f64(
                          <3 x double> %x,
                          metadata !"round.dynamic",
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %log10
}

define <4 x double> @constrained_vector_log10_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_log10_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stxvd2x 61, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    xxlor 1, 62, 62
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    bl log10
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 62
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl log10
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 62, 61, 1
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl log10
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl log10
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    vmr 2, 30
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 35, 61, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 61, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log10_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stxv 62, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscpsgndp 1, 62, 62
; PC64LE9-NEXT:    stxv 61, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 64(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    bl log10
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 62
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl log10
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 62, 61, 1
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    bl log10
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl log10
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 35, 61, 1
; PC64LE9-NEXT:    vmr 2, 30
; PC64LE9-NEXT:    lxv 63, 64(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 61, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log10 = call <4 x double> @llvm.experimental.constrained.log10.v4f64(
                               <4 x double> %x,
                               metadata !"round.dynamic",
                               metadata !"fpexcept.strict") #1
  ret <4 x double> %log10
}

define <1 x float> @constrained_vector_log2_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_log2_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -32(1)
; PC64LE-NEXT:    std 0, 48(1)
; PC64LE-NEXT:    bl log2f
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    addi 1, 1, 32
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log2_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -32(1)
; PC64LE9-NEXT:    std 0, 48(1)
; PC64LE9-NEXT:    bl log2f
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    addi 1, 1, 32
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log2 = call <1 x float> @llvm.experimental.constrained.log2.v1f32(
                             <1 x float> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <1 x float> %log2
}

define <2 x double> @constrained_vector_log2_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_log2_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl log2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 62, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl log2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 34, 62, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log2_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stxv 63, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    stxv 62, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    bl log2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 62, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl log2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 34, 62, 1
; PC64LE9-NEXT:    lxv 63, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log2 = call <2 x double> @llvm.experimental.constrained.log2.v2f64(
                              <2 x double> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <2 x double> %log2
}

define <3 x float> @constrained_vector_log2_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_log2_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    bl log2f
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxswapd 0, 63
; PC64LE-NEXT:    fmr 31, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl log2f
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE-NEXT:    fmr 30, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl log2f
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xscvdpspn 0, 1
; PC64LE-NEXT:    xscvdpspn 1, 30
; PC64LE-NEXT:    addis 3, 2, .LCPI72_0@toc@ha
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xscvdpspn 36, 31
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    addi 3, 3, .LCPI72_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log2_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl log2f
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxswapd 0, 63
; PC64LE9-NEXT:    fmr 31, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl log2f
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE9-NEXT:    fmr 30, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl log2f
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscvdpspn 0, 1
; PC64LE9-NEXT:    xscvdpspn 1, 30
; PC64LE9-NEXT:    addis 3, 2, .LCPI72_0@toc@ha
; PC64LE9-NEXT:    xscvdpspn 34, 31
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 3, 3, .LCPI72_0@toc@l
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log2 = call <3 x float> @llvm.experimental.constrained.log2.v3f32(
                              <3 x float> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %log2
}

define <3 x double> @constrained_vector_log2_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_log2_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 30, 2
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 31, 3
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    bl log2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 63, 1, 1
; PC64LE-NEXT:    fmr 1, 30
; PC64LE-NEXT:    bl log2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 63, 1, 63
; PC64LE-NEXT:    fmr 1, 31
; PC64LE-NEXT:    bl log2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    fmr 3, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log2_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    fmr 31, 3
; PC64LE9-NEXT:    fmr 30, 2
; PC64LE9-NEXT:    bl log2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 63, 1, 1
; PC64LE9-NEXT:    fmr 1, 30
; PC64LE9-NEXT:    bl log2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 63, 1, 63
; PC64LE9-NEXT:    fmr 1, 31
; PC64LE9-NEXT:    bl log2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    fmr 3, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log2 = call <3 x double> @llvm.experimental.constrained.log2.v3f64(
                          <3 x double> %x,
                          metadata !"round.dynamic",
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %log2
}

define <4 x double> @constrained_vector_log2_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_log2_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stxvd2x 61, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    xxlor 1, 62, 62
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    bl log2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 62
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl log2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 62, 61, 1
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl log2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl log2
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    vmr 2, 30
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 35, 61, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 61, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_log2_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stxv 62, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscpsgndp 1, 62, 62
; PC64LE9-NEXT:    stxv 61, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 64(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    bl log2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 62
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl log2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 62, 61, 1
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    bl log2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl log2
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 35, 61, 1
; PC64LE9-NEXT:    vmr 2, 30
; PC64LE9-NEXT:    lxv 63, 64(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 61, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %log2 = call <4 x double> @llvm.experimental.constrained.log2.v4f64(
                              <4 x double> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <4 x double> %log2
}

define <1 x float> @constrained_vector_rint_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_rint_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xsrdpic 1, 1
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_rint_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xsrdpic 1, 1
; PC64LE9-NEXT:    blr
entry:
  %rint = call <1 x float> @llvm.experimental.constrained.rint.v1f32(
                             <1 x float> %x,
                             metadata !"round.dynamic",
                             metadata !"fpexcept.strict") #1
  ret <1 x float> %rint
}

define <2 x double> @constrained_vector_rint_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_rint_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvrdpic 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_rint_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvrdpic 34, 34
; PC64LE9-NEXT:    blr
entry:
  %rint = call <2 x double> @llvm.experimental.constrained.rint.v2f64(
                        <2 x double> %x,
                        metadata !"round.dynamic",
                        metadata !"fpexcept.strict") #1
  ret <2 x double> %rint
}

define <3 x float> @constrained_vector_rint_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_rint_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 3
; PC64LE-NEXT:    addis 3, 2, .LCPI77_0@toc@ha
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    addi 3, 3, .LCPI77_0@toc@l
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    xsrdpic 0, 0
; PC64LE-NEXT:    xsrdpic 1, 1
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xxmrghw 34, 0, 1
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvspdpn 0, 2
; PC64LE-NEXT:    xsrdpic 0, 0
; PC64LE-NEXT:    xscvdpspn 36, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_rint_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xxsldwi 2, 34, 34, 3
; PC64LE9-NEXT:    addis 3, 2, .LCPI77_0@toc@ha
; PC64LE9-NEXT:    addi 3, 3, .LCPI77_0@toc@l
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xsrdpic 1, 1
; PC64LE9-NEXT:    xsrdpic 2, 2
; PC64LE9-NEXT:    xsrdpic 0, 0
; PC64LE9-NEXT:    xscvdpspn 2, 2
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xscvdpspn 34, 0
; PC64LE9-NEXT:    xxmrghw 35, 1, 2
; PC64LE9-NEXT:    lxv 1, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 1
; PC64LE9-NEXT:    blr
 entry:
  %rint = call <3 x float> @llvm.experimental.constrained.rint.v3f32(
                              <3 x float> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %rint
}

define <3 x double> @constrained_vector_rint_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_rint_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 0, 2, 1
; PC64LE-NEXT:    xsrdpic 3, 3
; PC64LE-NEXT:    xvrdpic 2, 0
; PC64LE-NEXT:    xxswapd 1, 2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_rint_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 0, 2, 1
; PC64LE9-NEXT:    xsrdpic 3, 3
; PC64LE9-NEXT:    xvrdpic 2, 0
; PC64LE9-NEXT:    xxswapd 1, 2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    blr
entry:
  %rint = call <3 x double> @llvm.experimental.constrained.rint.v3f64(
                          <3 x double> %x,
                          metadata !"round.dynamic",
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %rint
}

define <4 x double> @constrained_vector_rint_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_rint_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvrdpic 35, 35
; PC64LE-NEXT:    xvrdpic 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_rint_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvrdpic 35, 35
; PC64LE9-NEXT:    xvrdpic 34, 34
; PC64LE9-NEXT:    blr
entry:
  %rint = call <4 x double> @llvm.experimental.constrained.rint.v4f64(
                        <4 x double> %x,
                        metadata !"round.dynamic",
                        metadata !"fpexcept.strict") #1
  ret <4 x double> %rint
}

define <1 x float> @constrained_vector_nearbyint_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_nearbyint_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -32(1)
; PC64LE-NEXT:    std 0, 48(1)
; PC64LE-NEXT:    bl nearbyintf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    addi 1, 1, 32
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_nearbyint_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -32(1)
; PC64LE9-NEXT:    std 0, 48(1)
; PC64LE9-NEXT:    bl nearbyintf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    addi 1, 1, 32
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %nearby = call <1 x float> @llvm.experimental.constrained.nearbyint.v1f32(
                               <1 x float> %x,
                               metadata !"round.dynamic",
                               metadata !"fpexcept.strict") #1
  ret <1 x float> %nearby
}

define <2 x double> @constrained_vector_nearbyint_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_nearbyint_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl nearbyint
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 62, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl nearbyint
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 34, 62, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_nearbyint_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stxv 63, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    stxv 62, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    bl nearbyint
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 62, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl nearbyint
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 34, 62, 1
; PC64LE9-NEXT:    lxv 63, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %nearby = call <2 x double> @llvm.experimental.constrained.nearbyint.v2f64(
                                <2 x double> %x,
                                metadata !"round.dynamic",
                                metadata !"fpexcept.strict") #1
  ret <2 x double> %nearby
}

define <3 x float> @constrained_vector_nearbyint_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_nearbyint_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 2
; PC64LE-NEXT:    bl nearbyintf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxswapd 0, 63
; PC64LE-NEXT:    fmr 31, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl nearbyintf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE-NEXT:    fmr 30, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    bl nearbyintf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xscvdpspn 0, 1
; PC64LE-NEXT:    xscvdpspn 1, 30
; PC64LE-NEXT:    addis 3, 2, .LCPI82_0@toc@ha
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xscvdpspn 36, 31
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    addi 3, 3, .LCPI82_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_nearbyint_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 2
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl nearbyintf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxswapd 0, 63
; PC64LE9-NEXT:    fmr 31, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl nearbyintf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE9-NEXT:    fmr 30, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    bl nearbyintf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscvdpspn 0, 1
; PC64LE9-NEXT:    xscvdpspn 1, 30
; PC64LE9-NEXT:    addis 3, 2, .LCPI82_0@toc@ha
; PC64LE9-NEXT:    xscvdpspn 34, 31
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 3, 3, .LCPI82_0@toc@l
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %nearby = call <3 x float> @llvm.experimental.constrained.nearbyint.v3f32(
                              <3 x float> %x,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %nearby
}

define <3 x double> @constrained_vector_nearby_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_nearby_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -80(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 96(1)
; PC64LE-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 30, 2
; PC64LE-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE-NEXT:    fmr 31, 3
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    bl nearbyint
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 63, 1, 1
; PC64LE-NEXT:    fmr 1, 30
; PC64LE-NEXT:    bl nearbyint
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 63, 1, 63
; PC64LE-NEXT:    fmr 1, 31
; PC64LE-NEXT:    bl nearbyint
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    fmr 3, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 80
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_nearby_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -64(1)
; PC64LE9-NEXT:    std 0, 80(1)
; PC64LE9-NEXT:    stfd 30, 48(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 56(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    fmr 31, 3
; PC64LE9-NEXT:    fmr 30, 2
; PC64LE9-NEXT:    bl nearbyint
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 63, 1, 1
; PC64LE9-NEXT:    fmr 1, 30
; PC64LE9-NEXT:    bl nearbyint
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 63, 1, 63
; PC64LE9-NEXT:    fmr 1, 31
; PC64LE9-NEXT:    bl nearbyint
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    fmr 3, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 56(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    lfd 30, 48(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 64
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %nearby = call <3 x double> @llvm.experimental.constrained.nearbyint.v3f64(
                          <3 x double> %x,
                          metadata !"round.dynamic",
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %nearby
}

define <4 x double> @constrained_vector_nearbyint_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_nearbyint_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stxvd2x 61, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    xxlor 1, 62, 62
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    bl nearbyint
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 62
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl nearbyint
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 62, 61, 1
; PC64LE-NEXT:    xxlor 1, 63, 63
; PC64LE-NEXT:    bl nearbyint
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxlor 61, 1, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    bl nearbyint
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 80
; PC64LE-NEXT:    vmr 2, 30
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 35, 61, 1
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 61, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_nearbyint_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stxv 62, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscpsgndp 1, 62, 62
; PC64LE9-NEXT:    stxv 61, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 64(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    bl nearbyint
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 62
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl nearbyint
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 62, 61, 1
; PC64LE9-NEXT:    xscpsgndp 1, 63, 63
; PC64LE9-NEXT:    bl nearbyint
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscpsgndp 61, 1, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    bl nearbyint
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 35, 61, 1
; PC64LE9-NEXT:    vmr 2, 30
; PC64LE9-NEXT:    lxv 63, 64(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 61, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %nearby = call <4 x double> @llvm.experimental.constrained.nearbyint.v4f64(
                                <4 x double> %x,
                                metadata !"round.dynamic",
                                metadata !"fpexcept.strict") #1
  ret <4 x double> %nearby
}

define <1 x float> @constrained_vector_maxnum_v1f32(<1 x float> %x, <1 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_maxnum_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -32(1)
; PC64LE-NEXT:    std 0, 48(1)
; PC64LE-NEXT:    bl fmaxf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    addi 1, 1, 32
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_maxnum_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -32(1)
; PC64LE9-NEXT:    std 0, 48(1)
; PC64LE9-NEXT:    bl fmaxf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    addi 1, 1, 32
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %max = call <1 x float> @llvm.experimental.constrained.maxnum.v1f32(
                               <1 x float> %x, <1 x float> %y,
                               metadata !"fpexcept.strict") #1
  ret <1 x float> %max
}

define <2 x double> @constrained_vector_maxnum_v2f64(<2 x double> %x, <2 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_maxnum_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvmaxdp 34, 34, 35
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_maxnum_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvmaxdp 34, 34, 35
; PC64LE9-NEXT:    blr
entry:
  %max = call <2 x double> @llvm.experimental.constrained.maxnum.v2f64(
                                <2 x double> %x,
                                <2 x double> %y,
                                metadata !"fpexcept.strict") #1
  ret <2 x double> %max
}

define <3 x float> @constrained_vector_maxnum_v3f32(<3 x float> %x, <3 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_maxnum_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    xxsldwi 2, 35, 35, 1
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stfd 30, 80(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 88(1) # 8-byte Folded Spill
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    xscvspdpn 2, 2
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    bl fmaxf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxswapd 0, 62
; PC64LE-NEXT:    xxswapd 2, 63
; PC64LE-NEXT:    fmr 31, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    xscvspdpn 2, 2
; PC64LE-NEXT:    bl fmaxf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxsldwi 0, 62, 62, 3
; PC64LE-NEXT:    xxsldwi 2, 63, 63, 3
; PC64LE-NEXT:    fmr 30, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    xscvspdpn 2, 2
; PC64LE-NEXT:    bl fmaxf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xscvdpspn 0, 1
; PC64LE-NEXT:    xscvdpspn 1, 30
; PC64LE-NEXT:    addis 3, 2, .LCPI87_0@toc@ha
; PC64LE-NEXT:    lfd 30, 80(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xscvdpspn 36, 31
; PC64LE-NEXT:    lfd 31, 88(1) # 8-byte Folded Reload
; PC64LE-NEXT:    addi 3, 3, .LCPI87_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_maxnum_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 62, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    xxsldwi 0, 35, 35, 1
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscvspdpn 2, 0
; PC64LE9-NEXT:    bl fmaxf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxswapd 0, 62
; PC64LE9-NEXT:    fmr 31, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    xxswapd 0, 63
; PC64LE9-NEXT:    xscvspdpn 2, 0
; PC64LE9-NEXT:    bl fmaxf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxsldwi 0, 62, 62, 3
; PC64LE9-NEXT:    fmr 30, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE9-NEXT:    xscvspdpn 2, 0
; PC64LE9-NEXT:    bl fmaxf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscvdpspn 0, 1
; PC64LE9-NEXT:    xscvdpspn 1, 30
; PC64LE9-NEXT:    addis 3, 2, .LCPI87_0@toc@ha
; PC64LE9-NEXT:    xscvdpspn 34, 31
; PC64LE9-NEXT:    lxv 63, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 3, 3, .LCPI87_0@toc@l
; PC64LE9-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %max = call <3 x float> @llvm.experimental.constrained.maxnum.v3f32(
                              <3 x float> %x,
                              <3 x float> %y,
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %max
}

define <3 x double> @constrained_vector_max_v3f64(<3 x double> %x, <3 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_max_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -64(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    # kill: def $f5 killed $f5 def $vsl5
; PC64LE-NEXT:    # kill: def $f4 killed $f4 def $vsl4
; PC64LE-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 0, 5, 4
; PC64LE-NEXT:    xxmrghd 1, 2, 1
; PC64LE-NEXT:    std 0, 80(1)
; PC64LE-NEXT:    fmr 2, 6
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    xvmaxdp 63, 1, 0
; PC64LE-NEXT:    fmr 1, 3
; PC64LE-NEXT:    bl fmax
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    fmr 3, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 64
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_max_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -48(1)
; PC64LE9-NEXT:    # kill: def $f5 killed $f5 def $vsl5
; PC64LE9-NEXT:    # kill: def $f4 killed $f4 def $vsl4
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 0, 5, 4
; PC64LE9-NEXT:    xxmrghd 1, 2, 1
; PC64LE9-NEXT:    std 0, 64(1)
; PC64LE9-NEXT:    fmr 2, 6
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    xvmaxdp 63, 1, 0
; PC64LE9-NEXT:    fmr 1, 3
; PC64LE9-NEXT:    bl fmax
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    fmr 3, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    addi 1, 1, 48
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %max = call <3 x double> @llvm.experimental.constrained.maxnum.v3f64(
                          <3 x double> %x,
                          <3 x double> %y,
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %max
}

define <4 x double> @constrained_vector_maxnum_v4f64(<4 x double> %x, <4 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_maxnum_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvmaxdp 34, 34, 36
; PC64LE-NEXT:    xvmaxdp 35, 35, 37
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_maxnum_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvmaxdp 34, 34, 36
; PC64LE9-NEXT:    xvmaxdp 35, 35, 37
; PC64LE9-NEXT:    blr
entry:
  %max = call <4 x double> @llvm.experimental.constrained.maxnum.v4f64(
                                <4 x double> %x,
                                <4 x double> %y,
                                metadata !"fpexcept.strict") #1
  ret <4 x double> %max
}

define <1 x float> @constrained_vector_minnum_v1f32(<1 x float> %x, <1 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_minnum_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -32(1)
; PC64LE-NEXT:    std 0, 48(1)
; PC64LE-NEXT:    bl fminf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    addi 1, 1, 32
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_minnum_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -32(1)
; PC64LE9-NEXT:    std 0, 48(1)
; PC64LE9-NEXT:    bl fminf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    addi 1, 1, 32
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
 entry:
  %min = call <1 x float> @llvm.experimental.constrained.minnum.v1f32(
                               <1 x float> %x, <1 x float> %y,
                               metadata !"fpexcept.strict") #1
  ret <1 x float> %min
}

define <2 x double> @constrained_vector_minnum_v2f64(<2 x double> %x, <2 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_minnum_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvmindp 34, 34, 35
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_minnum_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvmindp 34, 34, 35
; PC64LE9-NEXT:    blr
entry:
  %min = call <2 x double> @llvm.experimental.constrained.minnum.v2f64(
                                <2 x double> %x,
                                <2 x double> %y,
                                metadata !"fpexcept.strict") #1
  ret <2 x double> %min
}

define <3 x float> @constrained_vector_minnum_v3f32(<3 x float> %x, <3 x float> %y) #0 {
; PC64LE-LABEL: constrained_vector_minnum_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -96(1)
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    xxsldwi 2, 35, 35, 1
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    std 0, 112(1)
; PC64LE-NEXT:    stfd 30, 80(1) # 8-byte Folded Spill
; PC64LE-NEXT:    stfd 31, 88(1) # 8-byte Folded Spill
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    xscvspdpn 2, 2
; PC64LE-NEXT:    stxvd2x 62, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    vmr 30, 2
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    vmr 31, 3
; PC64LE-NEXT:    bl fminf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxswapd 0, 62
; PC64LE-NEXT:    xxswapd 2, 63
; PC64LE-NEXT:    fmr 31, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    xscvspdpn 2, 2
; PC64LE-NEXT:    bl fminf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xxsldwi 0, 62, 62, 3
; PC64LE-NEXT:    xxsldwi 2, 63, 63, 3
; PC64LE-NEXT:    fmr 30, 1
; PC64LE-NEXT:    xscvspdpn 1, 0
; PC64LE-NEXT:    xscvspdpn 2, 2
; PC64LE-NEXT:    bl fminf
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    xscvdpspn 0, 1
; PC64LE-NEXT:    xscvdpspn 1, 30
; PC64LE-NEXT:    addis 3, 2, .LCPI92_0@toc@ha
; PC64LE-NEXT:    lfd 30, 80(1) # 8-byte Folded Reload
; PC64LE-NEXT:    xscvdpspn 36, 31
; PC64LE-NEXT:    lfd 31, 88(1) # 8-byte Folded Reload
; PC64LE-NEXT:    addi 3, 3, .LCPI92_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    li 3, 64
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    lxvd2x 62, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    addi 1, 1, 96
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_minnum_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -80(1)
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    std 0, 96(1)
; PC64LE9-NEXT:    stfd 30, 64(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 62, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    stfd 31, 72(1) # 8-byte Folded Spill
; PC64LE9-NEXT:    stxv 63, 48(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    xxsldwi 0, 35, 35, 1
; PC64LE9-NEXT:    vmr 31, 3
; PC64LE9-NEXT:    vmr 30, 2
; PC64LE9-NEXT:    xscvspdpn 2, 0
; PC64LE9-NEXT:    bl fminf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxswapd 0, 62
; PC64LE9-NEXT:    fmr 31, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    xxswapd 0, 63
; PC64LE9-NEXT:    xscvspdpn 2, 0
; PC64LE9-NEXT:    bl fminf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xxsldwi 0, 62, 62, 3
; PC64LE9-NEXT:    fmr 30, 1
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    xxsldwi 0, 63, 63, 3
; PC64LE9-NEXT:    xscvspdpn 2, 0
; PC64LE9-NEXT:    bl fminf
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    xscvdpspn 0, 1
; PC64LE9-NEXT:    xscvdpspn 1, 30
; PC64LE9-NEXT:    addis 3, 2, .LCPI92_0@toc@ha
; PC64LE9-NEXT:    xscvdpspn 34, 31
; PC64LE9-NEXT:    lxv 63, 48(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lxv 62, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    lfd 31, 72(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    addi 3, 3, .LCPI92_0@toc@l
; PC64LE9-NEXT:    lfd 30, 64(1) # 8-byte Folded Reload
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    addi 1, 1, 80
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
  %min = call <3 x float> @llvm.experimental.constrained.minnum.v3f32(
                              <3 x float> %x,
                              <3 x float> %y,
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %min
}

define <3 x double> @constrained_vector_min_v3f64(<3 x double> %x, <3 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_min_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mflr 0
; PC64LE-NEXT:    stdu 1, -64(1)
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    # kill: def $f5 killed $f5 def $vsl5
; PC64LE-NEXT:    # kill: def $f4 killed $f4 def $vsl4
; PC64LE-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 0, 5, 4
; PC64LE-NEXT:    xxmrghd 1, 2, 1
; PC64LE-NEXT:    std 0, 80(1)
; PC64LE-NEXT:    fmr 2, 6
; PC64LE-NEXT:    stxvd2x 63, 1, 3 # 16-byte Folded Spill
; PC64LE-NEXT:    xvmindp 63, 1, 0
; PC64LE-NEXT:    fmr 1, 3
; PC64LE-NEXT:    bl fmin
; PC64LE-NEXT:    nop
; PC64LE-NEXT:    li 3, 48
; PC64LE-NEXT:    fmr 3, 1
; PC64LE-NEXT:    xxswapd 1, 63
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    xxlor 2, 63, 63
; PC64LE-NEXT:    lxvd2x 63, 1, 3 # 16-byte Folded Reload
; PC64LE-NEXT:    addi 1, 1, 64
; PC64LE-NEXT:    ld 0, 16(1)
; PC64LE-NEXT:    mtlr 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_min_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mflr 0
; PC64LE9-NEXT:    stdu 1, -48(1)
; PC64LE9-NEXT:    # kill: def $f5 killed $f5 def $vsl5
; PC64LE9-NEXT:    # kill: def $f4 killed $f4 def $vsl4
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 0, 5, 4
; PC64LE9-NEXT:    xxmrghd 1, 2, 1
; PC64LE9-NEXT:    std 0, 64(1)
; PC64LE9-NEXT:    fmr 2, 6
; PC64LE9-NEXT:    stxv 63, 32(1) # 16-byte Folded Spill
; PC64LE9-NEXT:    xvmindp 63, 1, 0
; PC64LE9-NEXT:    fmr 1, 3
; PC64LE9-NEXT:    bl fmin
; PC64LE9-NEXT:    nop
; PC64LE9-NEXT:    fmr 3, 1
; PC64LE9-NEXT:    xxswapd 1, 63
; PC64LE9-NEXT:    xscpsgndp 2, 63, 63
; PC64LE9-NEXT:    lxv 63, 32(1) # 16-byte Folded Reload
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    addi 1, 1, 48
; PC64LE9-NEXT:    ld 0, 16(1)
; PC64LE9-NEXT:    mtlr 0
; PC64LE9-NEXT:    blr
entry:
 %min = call <3 x double> @llvm.experimental.constrained.minnum.v3f64(
                          <3 x double> %x,
                          <3 x double> %y,
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %min
}

define <4 x double> @constrained_vector_minnum_v4f64(<4 x double> %x, <4 x double> %y) #0 {
; PC64LE-LABEL: constrained_vector_minnum_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvmindp 34, 34, 36
; PC64LE-NEXT:    xvmindp 35, 35, 37
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_minnum_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvmindp 34, 34, 36
; PC64LE9-NEXT:    xvmindp 35, 35, 37
; PC64LE9-NEXT:    blr
entry:
  %min = call <4 x double> @llvm.experimental.constrained.minnum.v4f64(
                                <4 x double> %x,
                                <4 x double> %y,
                                metadata !"fpexcept.strict") #1
  ret <4 x double> %min
}

define <1 x i32> @constrained_vector_fptosi_v1i32_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v1i32_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpsxws 0, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v1i32_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpsxws 0, 1
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x i32> @llvm.experimental.constrained.fptosi.v1i32.v1f32(
                               <1 x float> %x,
                               metadata !"fpexcept.strict") #0
  ret <1 x i32> %result
}

define <2 x i32> @constrained_vector_fptosi_v2i32_v2f32(<2 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v2i32_v2f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xscvdpsxws 0, 0
; PC64LE-NEXT:    xscvdpsxws 1, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwz 1, 3
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v2i32_v2f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvdpsxws 0, 0
; PC64LE9-NEXT:    xscvdpsxws 1, 1
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    mffprwz 3, 1
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    xxmrghw 34, 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f32(
                                <2 x float> %x,
                                metadata !"fpexcept.strict") #0
  ret <2 x i32> %result
}

define <3 x i32> @constrained_vector_fptosi_v3i32_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v3i32_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    xscvdpsxws 0, 0
; PC64LE-NEXT:    xscvdpsxws 1, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwz 1, 3
; PC64LE-NEXT:    addis 3, 2, .LCPI97_0@toc@ha
; PC64LE-NEXT:    addi 3, 3, .LCPI97_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvspdpn 0, 2
; PC64LE-NEXT:    xscvdpsxws 0, 0
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtvsrwz 36, 3
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v3i32_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvdpsxws 0, 0
; PC64LE9-NEXT:    xscvdpsxws 1, 1
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    mffprwz 3, 1
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    addis 3, 2, .LCPI97_0@toc@ha
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE9-NEXT:    addi 3, 3, .LCPI97_0@toc@l
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvdpsxws 1, 1
; PC64LE9-NEXT:    mffprwz 3, 1
; PC64LE9-NEXT:    mtvsrwz 34, 3
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x i32> @llvm.experimental.constrained.fptosi.v3i32.v3f32(
                                <3 x float> %x,
                                metadata !"fpexcept.strict") #0
  ret <3 x i32> %result
}

define <4 x i32> @constrained_vector_fptosi_v4i32_v4f32(<4 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v4i32_v4f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvcvspsxws 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v4i32_v4f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvcvspsxws 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f32(
                                <4 x float> %x,
                                metadata !"fpexcept.strict") #0
  ret <4 x i32> %result
}

define <1 x i64> @constrained_vector_fptosi_v1i64_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v1i64_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpsxds 0, 1
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v1i64_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpsxds 0, 1
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x i64> @llvm.experimental.constrained.fptosi.v1i64.v1f32(
                               <1 x float> %x,
                               metadata !"fpexcept.strict") #0
  ret <1 x i64> %result
}

define <2 x i64> @constrained_vector_fptosi_v2i64_v2f32(<2 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v2i64_v2f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xscvdpsxds 0, 0
; PC64LE-NEXT:    xscvdpsxds 1, 1
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    mffprd 3, 1
; PC64LE-NEXT:    mtfprd 1, 3
; PC64LE-NEXT:    xxmrghd 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v2i64_v2f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpsxds 0, 0
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    xxswapd 0, 34
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpsxds 0, 0
; PC64LE9-NEXT:    mffprd 4, 0
; PC64LE9-NEXT:    mtvsrdd 34, 4, 3
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f32(
                                <2 x float> %x,
                                metadata !"fpexcept.strict") #0
  ret <2 x i64> %result
}

define <3 x i64> @constrained_vector_fptosi_v3i64_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v3i64_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    xscvdpsxds 0, 0
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    xscvspdpn 0, 1
; PC64LE-NEXT:    xscvdpsxds 0, 0
; PC64LE-NEXT:    mffprd 4, 0
; PC64LE-NEXT:    xscvspdpn 0, 2
; PC64LE-NEXT:    xscvdpsxds 0, 0
; PC64LE-NEXT:    mffprd 5, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v3i64_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpsxds 0, 0
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    xxswapd 0, 34
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpsxds 0, 0
; PC64LE9-NEXT:    mffprd 4, 0
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpsxds 0, 0
; PC64LE9-NEXT:    mffprd 5, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x i64> @llvm.experimental.constrained.fptosi.v3i64.v3f32(
                                <3 x float> %x,
                                metadata !"fpexcept.strict") #0
  ret <3 x i64> %result
}

define <4 x i64> @constrained_vector_fptosi_v4i64_v4f32(<4 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v4i64_v4f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    xscvdpsxds 0, 0
; PC64LE-NEXT:    xscvdpsxds 1, 1
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    mffprd 3, 1
; PC64LE-NEXT:    mtfprd 1, 3
; PC64LE-NEXT:    xxmrghd 36, 1, 0
; PC64LE-NEXT:    xscvspdpn 0, 34
; PC64LE-NEXT:    xscvspdpn 1, 2
; PC64LE-NEXT:    vmr 2, 4
; PC64LE-NEXT:    xscvdpsxds 0, 0
; PC64LE-NEXT:    xscvdpsxds 1, 1
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    mffprd 3, 1
; PC64LE-NEXT:    mtfprd 1, 3
; PC64LE-NEXT:    xxmrghd 35, 0, 1
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v4i64_v4f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpsxds 0, 0
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    xxswapd 0, 34
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpsxds 0, 0
; PC64LE9-NEXT:    mffprd 4, 0
; PC64LE9-NEXT:    xscvspdpn 0, 34
; PC64LE9-NEXT:    mtvsrdd 36, 4, 3
; PC64LE9-NEXT:    xscvdpsxds 0, 0
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    vmr 2, 4
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpsxds 0, 0
; PC64LE9-NEXT:    mffprd 4, 0
; PC64LE9-NEXT:    mtvsrdd 35, 3, 4
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f32(
                                <4 x float> %x,
                                metadata !"fpexcept.strict") #0
  ret <4 x i64> %result
}

define <1 x i32> @constrained_vector_fptosi_v1i32_v1f64(<1 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v1i32_v1f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpsxws 0, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v1i32_v1f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpsxws 0, 1
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x i32> @llvm.experimental.constrained.fptosi.v1i32.v1f64(
                               <1 x double> %x,
                               metadata !"fpexcept.strict") #0
  ret <1 x i32> %result
}


define <2 x i32> @constrained_vector_fptosi_v2i32_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v2i32_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpsxws 1, 34
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xscvdpsxws 0, 0
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwz 1, 3
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v2i32_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xscvdpsxws 0, 34
; PC64LE9-NEXT:    xscvdpsxws 1, 1
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    mffprwz 3, 1
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    xxmrghw 34, 0, 1
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f64(
                                <2 x double> %x,
                                metadata !"fpexcept.strict") #0
  ret <2 x i32> %result
}

define <3 x i32> @constrained_vector_fptosi_v3i32_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v3i32_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpsxws 0, 1
; PC64LE-NEXT:    xscvdpsxws 1, 2
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwz 1, 3
; PC64LE-NEXT:    addis 3, 2, .LCPI105_0@toc@ha
; PC64LE-NEXT:    addi 3, 3, .LCPI105_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvdpsxws 0, 3
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtvsrwz 36, 3
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v3i32_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpsxws 0, 1
; PC64LE9-NEXT:    xscvdpsxws 1, 2
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    mffprwz 3, 1
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    addis 3, 2, .LCPI105_0@toc@ha
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    xscvdpsxws 1, 3
; PC64LE9-NEXT:    addi 3, 3, .LCPI105_0@toc@l
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    mffprwz 3, 1
; PC64LE9-NEXT:    mtvsrwz 34, 3
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x i32> @llvm.experimental.constrained.fptosi.v3i32.v3f64(
                                <3 x double> %x,
                                metadata !"fpexcept.strict") #0
  ret <3 x i32> %result
}

define <4 x i32> @constrained_vector_fptosi_v4i32_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v4i32_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xscvdpsxws 2, 34
; PC64LE-NEXT:    xxswapd 1, 35
; PC64LE-NEXT:    xscvdpsxws 0, 0
; PC64LE-NEXT:    xscvdpsxws 1, 1
; PC64LE-NEXT:    mffprwz 3, 2
; PC64LE-NEXT:    xscvdpsxws 2, 35
; PC64LE-NEXT:    mffprwz 4, 0
; PC64LE-NEXT:    rldimi 4, 3, 32, 0
; PC64LE-NEXT:    mffprwz 3, 2
; PC64LE-NEXT:    mtfprd 0, 4
; PC64LE-NEXT:    mffprwz 4, 1
; PC64LE-NEXT:    rldimi 4, 3, 32, 0
; PC64LE-NEXT:    mtfprd 1, 4
; PC64LE-NEXT:    xxmrghd 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v4i32_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpsxws 0, 34
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    xxswapd 0, 34
; PC64LE9-NEXT:    xscvdpsxws 0, 0
; PC64LE9-NEXT:    mffprwz 4, 0
; PC64LE9-NEXT:    xscvdpsxws 0, 35
; PC64LE9-NEXT:    rldimi 4, 3, 32, 0
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    xxswapd 0, 35
; PC64LE9-NEXT:    xscvdpsxws 0, 0
; PC64LE9-NEXT:    mffprwz 5, 0
; PC64LE9-NEXT:    rldimi 5, 3, 32, 0
; PC64LE9-NEXT:    mtvsrdd 34, 5, 4
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f64(
                                <4 x double> %x,
                                metadata !"fpexcept.strict") #0
  ret <4 x i32> %result
}

define <1 x i64> @constrained_vector_fptosi_v1i64_v1f64(<1 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v1i64_v1f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpsxds 0, 1
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v1i64_v1f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpsxds 0, 1
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x i64> @llvm.experimental.constrained.fptosi.v1i64.v1f64(
                               <1 x double> %x,
                               metadata !"fpexcept.strict") #0
  ret <1 x i64> %result
}

define <2 x i64> @constrained_vector_fptosi_v2i64_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v2i64_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvcvdpsxds 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v2i64_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvcvdpsxds 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f64(
                                <2 x double> %x,
                                metadata !"fpexcept.strict") #0
  ret <2 x i64> %result
}

define <3 x i64> @constrained_vector_fptosi_v3i64_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v3i64_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpsxds 0, 1
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    xscvdpsxds 0, 2
; PC64LE-NEXT:    mffprd 4, 0
; PC64LE-NEXT:    xscvdpsxds 0, 3
; PC64LE-NEXT:    mffprd 5, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v3i64_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpsxds 0, 1
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    xscvdpsxds 0, 2
; PC64LE9-NEXT:    mffprd 4, 0
; PC64LE9-NEXT:    xscvdpsxds 0, 3
; PC64LE9-NEXT:    mffprd 5, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x i64> @llvm.experimental.constrained.fptosi.v3i64.v3f64(
                                <3 x double> %x,
                                metadata !"fpexcept.strict") #0
  ret <3 x i64> %result
}

define <4 x i64> @constrained_vector_fptosi_v4i64_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptosi_v4i64_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvcvdpsxds 35, 35
; PC64LE-NEXT:    xvcvdpsxds 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptosi_v4i64_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvcvdpsxds 35, 35
; PC64LE9-NEXT:    xvcvdpsxds 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f64(
                                <4 x double> %x,
                                metadata !"fpexcept.strict") #0
  ret <4 x i64> %result
}

define <1 x i32> @constrained_vector_fptoui_v1i32_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v1i32_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpuxws 0, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v1i32_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpuxws 0, 1
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x i32> @llvm.experimental.constrained.fptoui.v1i32.v1f32(
                               <1 x float> %x,
                               metadata !"fpexcept.strict") #0
  ret <1 x i32> %result
}

define <2 x i32> @constrained_vector_fptoui_v2i32_v2f32(<2 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v2i32_v2f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xscvdpuxws 0, 0
; PC64LE-NEXT:    xscvdpuxws 1, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwz 1, 3
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v2i32_v2f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvdpuxws 0, 0
; PC64LE9-NEXT:    xscvdpuxws 1, 1
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    mffprwz 3, 1
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    xxmrghw 34, 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f32(
                                <2 x float> %x,
                                metadata !"fpexcept.strict") #0
  ret <2 x i32> %result
}

define <3 x i32> @constrained_vector_fptoui_v3i32_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v3i32_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    xscvdpuxws 0, 0
; PC64LE-NEXT:    xscvdpuxws 1, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwz 1, 3
; PC64LE-NEXT:    addis 3, 2, .LCPI113_0@toc@ha
; PC64LE-NEXT:    addi 3, 3, .LCPI113_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvspdpn 0, 2
; PC64LE-NEXT:    xscvdpuxws 0, 0
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtvsrwz 36, 3
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v3i32_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvdpuxws 0, 0
; PC64LE9-NEXT:    xscvdpuxws 1, 1
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    mffprwz 3, 1
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    addis 3, 2, .LCPI113_0@toc@ha
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE9-NEXT:    addi 3, 3, .LCPI113_0@toc@l
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvdpuxws 1, 1
; PC64LE9-NEXT:    mffprwz 3, 1
; PC64LE9-NEXT:    mtvsrwz 34, 3
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x i32> @llvm.experimental.constrained.fptoui.v3i32.v3f32(
                                <3 x float> %x,
                                metadata !"fpexcept.strict") #0
  ret <3 x i32> %result
}

define <4 x i32> @constrained_vector_fptoui_v4i32_v4f32(<4 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v4i32_v4f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvcvspuxws 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v4i32_v4f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvcvspuxws 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f32(
                                <4 x float> %x,
                                metadata !"fpexcept.strict") #0
  ret <4 x i32> %result
}

define <1 x i64> @constrained_vector_fptoui_v1i64_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v1i64_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpuxds 0, 1
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v1i64_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpuxds 0, 1
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x i64> @llvm.experimental.constrained.fptoui.v1i64.v1f32(
                               <1 x float> %x,
                               metadata !"fpexcept.strict") #0
  ret <1 x i64> %result
}

define <2 x i64> @constrained_vector_fptoui_v2i64_v2f32(<2 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v2i64_v2f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xscvdpuxds 0, 0
; PC64LE-NEXT:    xscvdpuxds 1, 1
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    mffprd 3, 1
; PC64LE-NEXT:    mtfprd 1, 3
; PC64LE-NEXT:    xxmrghd 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v2i64_v2f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpuxds 0, 0
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    xxswapd 0, 34
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpuxds 0, 0
; PC64LE9-NEXT:    mffprd 4, 0
; PC64LE9-NEXT:    mtvsrdd 34, 4, 3
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f32(
                                <2 x float> %x,
                                metadata !"fpexcept.strict") #0
  ret <2 x i64> %result
}

define <3 x i64> @constrained_vector_fptoui_v3i64_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v3i64_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    xscvdpuxds 0, 0
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    xscvspdpn 0, 1
; PC64LE-NEXT:    xscvdpuxds 0, 0
; PC64LE-NEXT:    mffprd 4, 0
; PC64LE-NEXT:    xscvspdpn 0, 2
; PC64LE-NEXT:    xscvdpuxds 0, 0
; PC64LE-NEXT:    mffprd 5, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v3i64_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpuxds 0, 0
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    xxswapd 0, 34
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpuxds 0, 0
; PC64LE9-NEXT:    mffprd 4, 0
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpuxds 0, 0
; PC64LE9-NEXT:    mffprd 5, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x i64> @llvm.experimental.constrained.fptoui.v3i64.v3f32(
                                <3 x float> %x,
                                metadata !"fpexcept.strict") #0
  ret <3 x i64> %result
}

define <4 x i64> @constrained_vector_fptoui_v4i64_v4f32(<4 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v4i64_v4f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    xscvdpuxds 0, 0
; PC64LE-NEXT:    xscvdpuxds 1, 1
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    mffprd 3, 1
; PC64LE-NEXT:    mtfprd 1, 3
; PC64LE-NEXT:    xxmrghd 36, 1, 0
; PC64LE-NEXT:    xscvspdpn 0, 34
; PC64LE-NEXT:    xscvspdpn 1, 2
; PC64LE-NEXT:    vmr 2, 4
; PC64LE-NEXT:    xscvdpuxds 0, 0
; PC64LE-NEXT:    xscvdpuxds 1, 1
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    mffprd 3, 1
; PC64LE-NEXT:    mtfprd 1, 3
; PC64LE-NEXT:    xxmrghd 35, 0, 1
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v4i64_v4f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpuxds 0, 0
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    xxswapd 0, 34
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpuxds 0, 0
; PC64LE9-NEXT:    mffprd 4, 0
; PC64LE9-NEXT:    xscvspdpn 0, 34
; PC64LE9-NEXT:    mtvsrdd 36, 4, 3
; PC64LE9-NEXT:    xscvdpuxds 0, 0
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    vmr 2, 4
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvdpuxds 0, 0
; PC64LE9-NEXT:    mffprd 4, 0
; PC64LE9-NEXT:    mtvsrdd 35, 3, 4
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f32(
                                <4 x float> %x,
                                metadata !"fpexcept.strict") #0
  ret <4 x i64> %result
}

define <1 x i32> @constrained_vector_fptoui_v1i32_v1f64(<1 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v1i32_v1f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpuxws 0, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v1i32_v1f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpuxws 0, 1
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x i32> @llvm.experimental.constrained.fptoui.v1i32.v1f64(
                               <1 x double> %x,
                               metadata !"fpexcept.strict") #0
  ret <1 x i32> %result
}

define <2 x i32> @constrained_vector_fptoui_v2i32_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v2i32_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpuxws 1, 34
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xscvdpuxws 0, 0
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwz 1, 3
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v2i32_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xscvdpuxws 0, 34
; PC64LE9-NEXT:    xscvdpuxws 1, 1
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    mffprwz 3, 1
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    xxmrghw 34, 0, 1
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f64(
                                <2 x double> %x,
                                metadata !"fpexcept.strict") #0
  ret <2 x i32> %result
}

define <3 x i32> @constrained_vector_fptoui_v3i32_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v3i32_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpuxws 0, 1
; PC64LE-NEXT:    xscvdpuxws 1, 2
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwz 1, 3
; PC64LE-NEXT:    addis 3, 2, .LCPI121_0@toc@ha
; PC64LE-NEXT:    addi 3, 3, .LCPI121_0@toc@l
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvdpuxws 0, 3
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtvsrwz 36, 3
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v3i32_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpuxws 0, 1
; PC64LE9-NEXT:    xscvdpuxws 1, 2
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    mffprwz 3, 1
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    addis 3, 2, .LCPI121_0@toc@ha
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    xscvdpuxws 1, 3
; PC64LE9-NEXT:    addi 3, 3, .LCPI121_0@toc@l
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    mffprwz 3, 1
; PC64LE9-NEXT:    mtvsrwz 34, 3
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x i32> @llvm.experimental.constrained.fptoui.v3i32.v3f64(
                                <3 x double> %x,
                                metadata !"fpexcept.strict") #0
  ret <3 x i32> %result
}

define <4 x i32> @constrained_vector_fptoui_v4i32_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v4i32_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xscvdpuxws 2, 34
; PC64LE-NEXT:    xxswapd 1, 35
; PC64LE-NEXT:    xscvdpuxws 0, 0
; PC64LE-NEXT:    xscvdpuxws 1, 1
; PC64LE-NEXT:    mffprwz 3, 2
; PC64LE-NEXT:    xscvdpuxws 2, 35
; PC64LE-NEXT:    mffprwz 4, 0
; PC64LE-NEXT:    rldimi 4, 3, 32, 0
; PC64LE-NEXT:    mffprwz 3, 2
; PC64LE-NEXT:    mtfprd 0, 4
; PC64LE-NEXT:    mffprwz 4, 1
; PC64LE-NEXT:    rldimi 4, 3, 32, 0
; PC64LE-NEXT:    mtfprd 1, 4
; PC64LE-NEXT:    xxmrghd 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v4i32_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpuxws 0, 34
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    xxswapd 0, 34
; PC64LE9-NEXT:    xscvdpuxws 0, 0
; PC64LE9-NEXT:    mffprwz 4, 0
; PC64LE9-NEXT:    xscvdpuxws 0, 35
; PC64LE9-NEXT:    rldimi 4, 3, 32, 0
; PC64LE9-NEXT:    mffprwz 3, 0
; PC64LE9-NEXT:    xxswapd 0, 35
; PC64LE9-NEXT:    xscvdpuxws 0, 0
; PC64LE9-NEXT:    mffprwz 5, 0
; PC64LE9-NEXT:    rldimi 5, 3, 32, 0
; PC64LE9-NEXT:    mtvsrdd 34, 5, 4
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f64(
                                <4 x double> %x,
                                metadata !"fpexcept.strict") #0
  ret <4 x i32> %result
}

define <1 x i64> @constrained_vector_fptoui_v1i64_v1f64(<1 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v1i64_v1f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpuxds 0, 1
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v1i64_v1f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpuxds 0, 1
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x i64> @llvm.experimental.constrained.fptoui.v1i64.v1f64(
                               <1 x double> %x,
                               metadata !"fpexcept.strict") #0
  ret <1 x i64> %result
}

define <2 x i64> @constrained_vector_fptoui_v2i64_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v2i64_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvcvdpuxds 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v2i64_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvcvdpuxds 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f64(
                                <2 x double> %x,
                                metadata !"fpexcept.strict") #0
  ret <2 x i64> %result
}

define <3 x i64> @constrained_vector_fptoui_v3i64_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v3i64_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xscvdpuxds 0, 1
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    xscvdpuxds 0, 2
; PC64LE-NEXT:    mffprd 4, 0
; PC64LE-NEXT:    xscvdpuxds 0, 3
; PC64LE-NEXT:    mffprd 5, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v3i64_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xscvdpuxds 0, 1
; PC64LE9-NEXT:    mffprd 3, 0
; PC64LE9-NEXT:    xscvdpuxds 0, 2
; PC64LE9-NEXT:    mffprd 4, 0
; PC64LE9-NEXT:    xscvdpuxds 0, 3
; PC64LE9-NEXT:    mffprd 5, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x i64> @llvm.experimental.constrained.fptoui.v3i64.v3f64(
                                <3 x double> %x,
                                metadata !"fpexcept.strict") #0
  ret <3 x i64> %result
}

define <4 x i64> @constrained_vector_fptoui_v4i64_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptoui_v4i64_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvcvdpuxds 35, 35
; PC64LE-NEXT:    xvcvdpuxds 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptoui_v4i64_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvcvdpuxds 35, 35
; PC64LE9-NEXT:    xvcvdpuxds 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f64(
                                <4 x double> %x,
                                metadata !"fpexcept.strict") #0
  ret <4 x i64> %result
}

define <1 x float> @constrained_vector_fptrunc_v1f64(<1 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptrunc_v1f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xsrsp 1, 1
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptrunc_v1f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xsrsp 1, 1
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x float> @llvm.experimental.constrained.fptrunc.v1f32.v1f64(
                                <1 x double> %x,
                                metadata !"round.dynamic",
                                metadata !"fpexcept.strict") #1
  ret <1 x float> %result
}

define <2 x float> @constrained_vector_fptrunc_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptrunc_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xsrsp 1, 34
; PC64LE-NEXT:    xsrsp 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptrunc_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xsrsp 0, 34
; PC64LE9-NEXT:    xsrsp 1, 1
; PC64LE9-NEXT:    xscvdpspn 0, 0
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xxmrghw 34, 0, 1
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x float> @llvm.experimental.constrained.fptrunc.v2f32.v2f64(
                                <2 x double> %x,
                                metadata !"round.dynamic",
                                metadata !"fpexcept.strict") #1
  ret <2 x float> %result
}

define <3 x float> @constrained_vector_fptrunc_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptrunc_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xsrsp 0, 1
; PC64LE-NEXT:    xsrsp 1, 2
; PC64LE-NEXT:    addis 3, 2, .LCPI129_0@toc@ha
; PC64LE-NEXT:    addi 3, 3, .LCPI129_0@toc@l
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xsrsp 0, 3
; PC64LE-NEXT:    xscvdpspn 36, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptrunc_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xsrsp 0, 1
; PC64LE9-NEXT:    xsrsp 1, 2
; PC64LE9-NEXT:    addis 3, 2, .LCPI129_0@toc@ha
; PC64LE9-NEXT:    addi 3, 3, .LCPI129_0@toc@l
; PC64LE9-NEXT:    xscvdpspn 0, 0
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    xsrsp 1, 3
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xscvdpspn 34, 1
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x float> @llvm.experimental.constrained.fptrunc.v3f32.v3f64(
                                <3 x double> %x,
                                metadata !"round.dynamic",
                                metadata !"fpexcept.strict") #1
  ret <3 x float> %result
}

define <4 x float> @constrained_vector_fptrunc_v4f64(<4 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_fptrunc_v4f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxmrgld 0, 35, 34
; PC64LE-NEXT:    xxmrghd 1, 35, 34
; PC64LE-NEXT:    xvcvdpsp 34, 0
; PC64LE-NEXT:    xvcvdpsp 35, 1
; PC64LE-NEXT:    vmrgew 2, 3, 2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fptrunc_v4f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxmrgld 0, 35, 34
; PC64LE9-NEXT:    xvcvdpsp 36, 0
; PC64LE9-NEXT:    xxmrghd 0, 35, 34
; PC64LE9-NEXT:    xvcvdpsp 34, 0
; PC64LE9-NEXT:    vmrgew 2, 2, 4
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x float> @llvm.experimental.constrained.fptrunc.v4f32.v4f64(
                                <4 x double> %x,
                                metadata !"round.dynamic",
                                metadata !"fpexcept.strict") #1
  ret <4 x float> %result
}

define <1 x double> @constrained_vector_fpext_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fpext_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fpext_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x double> @llvm.experimental.constrained.fpext.v1f64.v1f32(
                                <1 x float> %x,
                                metadata !"fpexcept.strict") #1
  ret <1 x double> %result
}

define <2 x double> @constrained_vector_fpext_v2f32(<2 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fpext_v2f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xxmrghd 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fpext_v2f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xxmrghd 34, 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x double> @llvm.experimental.constrained.fpext.v2f64.v2f32(
                                <2 x float> %x,
                                metadata !"fpexcept.strict") #1
  ret <2 x double> %result
}

define <3 x double> @constrained_vector_fpext_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fpext_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    xscvspdpn 3, 0
; PC64LE-NEXT:    xxsldwi 4, 34, 34, 3
; PC64LE-NEXT:    xscvspdpn 2, 1
; PC64LE-NEXT:    xscvspdpn 1, 4
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fpext_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    xscvspdpn 3, 0
; PC64LE9-NEXT:    xxswapd 0, 34
; PC64LE9-NEXT:    xscvspdpn 2, 0
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE9-NEXT:    xscvspdpn 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x double> @llvm.experimental.constrained.fpext.v3f64.v3f32(
                                <3 x float> %x,
                                metadata !"fpexcept.strict") #1
  ret <3 x double> %result
}

define <4 x double> @constrained_vector_fpext_v4f32(<4 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_fpext_v4f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE-NEXT:    xxswapd 1, 34
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    xscvspdpn 2, 2
; PC64LE-NEXT:    xxmrghd 0, 1, 0
; PC64LE-NEXT:    xscvspdpn 1, 34
; PC64LE-NEXT:    xxlor 34, 0, 0
; PC64LE-NEXT:    xxmrghd 35, 1, 2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_fpext_v4f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 3
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xxmrghd 0, 1, 0
; PC64LE9-NEXT:    xscvspdpn 1, 34
; PC64LE9-NEXT:    xxmrghd 35, 1, 2
; PC64LE9-NEXT:    xxlor 34, 0, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x double> @llvm.experimental.constrained.fpext.v4f64.v4f32(
                                <4 x float> %x,
                                metadata !"fpexcept.strict") #1
  ret <4 x double> %result
}

define <1 x float> @constrained_vector_ceil_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_ceil_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xsrdpip 1, 1
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_ceil_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xsrdpip 1, 1
; PC64LE9-NEXT:    blr
entry:
  %ceil = call <1 x float> @llvm.experimental.constrained.ceil.v1f32(
                               <1 x float> %x,
                               metadata !"fpexcept.strict") #1
  ret <1 x float> %ceil
}

define <2 x double> @constrained_vector_ceil_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_ceil_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvrdpip 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_ceil_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvrdpip 34, 34
; PC64LE9-NEXT:    blr
entry:
  %ceil = call <2 x double> @llvm.experimental.constrained.ceil.v2f64(
                                <2 x double> %x,
                                metadata !"fpexcept.strict") #1
  ret <2 x double> %ceil
}

define <3 x float> @constrained_vector_ceil_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_ceil_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 3
; PC64LE-NEXT:    addis 3, 2, .LCPI137_0@toc@ha
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    addi 3, 3, .LCPI137_0@toc@l
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    xsrdpip 0, 0
; PC64LE-NEXT:    xsrdpip 1, 1
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xxmrghw 34, 0, 1
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvspdpn 0, 2
; PC64LE-NEXT:    xsrdpip 0, 0
; PC64LE-NEXT:    xscvdpspn 36, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_ceil_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xxsldwi 2, 34, 34, 3
; PC64LE9-NEXT:    addis 3, 2, .LCPI137_0@toc@ha
; PC64LE9-NEXT:    addi 3, 3, .LCPI137_0@toc@l
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xsrdpip 1, 1
; PC64LE9-NEXT:    xsrdpip 2, 2
; PC64LE9-NEXT:    xsrdpip 0, 0
; PC64LE9-NEXT:    xscvdpspn 2, 2
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xscvdpspn 34, 0
; PC64LE9-NEXT:    xxmrghw 35, 1, 2
; PC64LE9-NEXT:    lxv 1, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 1
; PC64LE9-NEXT:    blr
entry:
  %ceil = call <3 x float> @llvm.experimental.constrained.ceil.v3f32(
                              <3 x float> %x,
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %ceil
}

define <3 x double> @constrained_vector_ceil_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_ceil_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 0, 2, 1
; PC64LE-NEXT:    xsrdpip 3, 3
; PC64LE-NEXT:    xvrdpip 2, 0
; PC64LE-NEXT:    xxswapd 1, 2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_ceil_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 0, 2, 1
; PC64LE9-NEXT:    xsrdpip 3, 3
; PC64LE9-NEXT:    xvrdpip 2, 0
; PC64LE9-NEXT:    xxswapd 1, 2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    blr
entry:
  %ceil = call <3 x double> @llvm.experimental.constrained.ceil.v3f64(
                          <3 x double> %x,
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %ceil
}

define <1 x float> @constrained_vector_floor_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_floor_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xsrdpim 1, 1
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_floor_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xsrdpim 1, 1
; PC64LE9-NEXT:    blr
entry:
  %floor = call <1 x float> @llvm.experimental.constrained.floor.v1f32(
                               <1 x float> %x,
                               metadata !"fpexcept.strict") #1
  ret <1 x float> %floor
}


define <2 x double> @constrained_vector_floor_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_floor_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvrdpim 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_floor_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvrdpim 34, 34
; PC64LE9-NEXT:    blr
entry:
  %floor = call <2 x double> @llvm.experimental.constrained.floor.v2f64(
                                <2 x double> %x,
                                metadata !"fpexcept.strict") #1
  ret <2 x double> %floor
}

define <3 x float> @constrained_vector_floor_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_floor_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 3
; PC64LE-NEXT:    addis 3, 2, .LCPI141_0@toc@ha
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    addi 3, 3, .LCPI141_0@toc@l
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    xsrdpim 0, 0
; PC64LE-NEXT:    xsrdpim 1, 1
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xxmrghw 34, 0, 1
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvspdpn 0, 2
; PC64LE-NEXT:    xsrdpim 0, 0
; PC64LE-NEXT:    xscvdpspn 36, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_floor_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xxsldwi 2, 34, 34, 3
; PC64LE9-NEXT:    addis 3, 2, .LCPI141_0@toc@ha
; PC64LE9-NEXT:    addi 3, 3, .LCPI141_0@toc@l
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xsrdpim 1, 1
; PC64LE9-NEXT:    xsrdpim 2, 2
; PC64LE9-NEXT:    xsrdpim 0, 0
; PC64LE9-NEXT:    xscvdpspn 2, 2
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xscvdpspn 34, 0
; PC64LE9-NEXT:    xxmrghw 35, 1, 2
; PC64LE9-NEXT:    lxv 1, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 1
; PC64LE9-NEXT:    blr
entry:
  %floor = call <3 x float> @llvm.experimental.constrained.floor.v3f32(
                              <3 x float> %x,
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %floor
}

define <3 x double> @constrained_vector_floor_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_floor_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 0, 2, 1
; PC64LE-NEXT:    xsrdpim 3, 3
; PC64LE-NEXT:    xvrdpim 2, 0
; PC64LE-NEXT:    xxswapd 1, 2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_floor_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 0, 2, 1
; PC64LE9-NEXT:    xsrdpim 3, 3
; PC64LE9-NEXT:    xvrdpim 2, 0
; PC64LE9-NEXT:    xxswapd 1, 2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    blr
entry:
  %floor = call <3 x double> @llvm.experimental.constrained.floor.v3f64(
                          <3 x double> %x,
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %floor
}

define <1 x float> @constrained_vector_round_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_round_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xsrdpi 1, 1
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_round_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xsrdpi 1, 1
; PC64LE9-NEXT:    blr
entry:
  %round = call <1 x float> @llvm.experimental.constrained.round.v1f32(
                               <1 x float> %x,
                               metadata !"fpexcept.strict") #1
  ret <1 x float> %round
}

define <2 x double> @constrained_vector_round_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_round_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvrdpi 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_round_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvrdpi 34, 34
; PC64LE9-NEXT:    blr
entry:
  %round = call <2 x double> @llvm.experimental.constrained.round.v2f64(
                                <2 x double> %x,
                                metadata !"fpexcept.strict") #1
  ret <2 x double> %round
}

define <3 x float> @constrained_vector_round_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_round_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 3
; PC64LE-NEXT:    addis 3, 2, .LCPI145_0@toc@ha
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    addi 3, 3, .LCPI145_0@toc@l
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    xsrdpi 0, 0
; PC64LE-NEXT:    xsrdpi 1, 1
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xxmrghw 34, 0, 1
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvspdpn 0, 2
; PC64LE-NEXT:    xsrdpi 0, 0
; PC64LE-NEXT:    xscvdpspn 36, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_round_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xxsldwi 2, 34, 34, 3
; PC64LE9-NEXT:    addis 3, 2, .LCPI145_0@toc@ha
; PC64LE9-NEXT:    addi 3, 3, .LCPI145_0@toc@l
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xsrdpi 1, 1
; PC64LE9-NEXT:    xsrdpi 2, 2
; PC64LE9-NEXT:    xsrdpi 0, 0
; PC64LE9-NEXT:    xscvdpspn 2, 2
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xscvdpspn 34, 0
; PC64LE9-NEXT:    xxmrghw 35, 1, 2
; PC64LE9-NEXT:    lxv 1, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 1
; PC64LE9-NEXT:    blr
entry:
  %round = call <3 x float> @llvm.experimental.constrained.round.v3f32(
                              <3 x float> %x,
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %round
}


define <3 x double> @constrained_vector_round_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_round_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 0, 2, 1
; PC64LE-NEXT:    xsrdpi 3, 3
; PC64LE-NEXT:    xvrdpi 2, 0
; PC64LE-NEXT:    xxswapd 1, 2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_round_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 0, 2, 1
; PC64LE9-NEXT:    xsrdpi 3, 3
; PC64LE9-NEXT:    xvrdpi 2, 0
; PC64LE9-NEXT:    xxswapd 1, 2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    blr
entry:
  %round = call <3 x double> @llvm.experimental.constrained.round.v3f64(
                          <3 x double> %x,
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %round
}

define <1 x float> @constrained_vector_trunc_v1f32(<1 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_trunc_v1f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xsrdpiz 1, 1
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_trunc_v1f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xsrdpiz 1, 1
; PC64LE9-NEXT:    blr
entry:
  %trunc = call <1 x float> @llvm.experimental.constrained.trunc.v1f32(
                               <1 x float> %x,
                               metadata !"fpexcept.strict") #1
  ret <1 x float> %trunc
}

define <2 x double> @constrained_vector_trunc_v2f64(<2 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_trunc_v2f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvrdpiz 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_trunc_v2f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvrdpiz 34, 34
; PC64LE9-NEXT:    blr
entry:
  %trunc = call <2 x double> @llvm.experimental.constrained.trunc.v2f64(
                                <2 x double> %x,
                                metadata !"fpexcept.strict") #1
  ret <2 x double> %trunc
}

define <3 x float> @constrained_vector_trunc_v3f32(<3 x float> %x) #0 {
; PC64LE-LABEL: constrained_vector_trunc_v3f32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 3
; PC64LE-NEXT:    addis 3, 2, .LCPI149_0@toc@ha
; PC64LE-NEXT:    xscvspdpn 0, 0
; PC64LE-NEXT:    xscvspdpn 1, 1
; PC64LE-NEXT:    addi 3, 3, .LCPI149_0@toc@l
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    xsrdpiz 0, 0
; PC64LE-NEXT:    xsrdpiz 1, 1
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xxmrghw 34, 0, 1
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    xscvspdpn 0, 2
; PC64LE-NEXT:    xsrdpiz 0, 0
; PC64LE-NEXT:    xscvdpspn 36, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_trunc_v3f32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxswapd 1, 34
; PC64LE9-NEXT:    xxsldwi 2, 34, 34, 3
; PC64LE9-NEXT:    addis 3, 2, .LCPI149_0@toc@ha
; PC64LE9-NEXT:    addi 3, 3, .LCPI149_0@toc@l
; PC64LE9-NEXT:    xxsldwi 0, 34, 34, 1
; PC64LE9-NEXT:    xscvspdpn 1, 1
; PC64LE9-NEXT:    xscvspdpn 2, 2
; PC64LE9-NEXT:    xscvspdpn 0, 0
; PC64LE9-NEXT:    xsrdpiz 1, 1
; PC64LE9-NEXT:    xsrdpiz 2, 2
; PC64LE9-NEXT:    xsrdpiz 0, 0
; PC64LE9-NEXT:    xscvdpspn 2, 2
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xscvdpspn 34, 0
; PC64LE9-NEXT:    xxmrghw 35, 1, 2
; PC64LE9-NEXT:    lxv 1, 0(3)
; PC64LE9-NEXT:    xxperm 34, 35, 1
; PC64LE9-NEXT:    blr
entry:
  %trunc = call <3 x float> @llvm.experimental.constrained.trunc.v3f32(
                              <3 x float> %x,
                              metadata !"fpexcept.strict") #1
  ret <3 x float> %trunc
}

define <3 x double> @constrained_vector_trunc_v3f64(<3 x double> %x) #0 {
; PC64LE-LABEL: constrained_vector_trunc_v3f64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE-NEXT:    xxmrghd 0, 2, 1
; PC64LE-NEXT:    xsrdpiz 3, 3
; PC64LE-NEXT:    xvrdpiz 2, 0
; PC64LE-NEXT:    xxswapd 1, 2
; PC64LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_trunc_v3f64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 def $vsl2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 def $vsl1
; PC64LE9-NEXT:    xxmrghd 0, 2, 1
; PC64LE9-NEXT:    xsrdpiz 3, 3
; PC64LE9-NEXT:    xvrdpiz 2, 0
; PC64LE9-NEXT:    xxswapd 1, 2
; PC64LE9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; PC64LE9-NEXT:    # kill: def $f2 killed $f2 killed $vsl2
; PC64LE9-NEXT:    blr
entry:
  %trunc = call <3 x double> @llvm.experimental.constrained.trunc.v3f64(
                          <3 x double> %x,
                          metadata !"fpexcept.strict") #1
  ret <3 x double> %trunc
}

define <1 x double> @constrained_vector_sitofp_v1f64_v1i32(<1 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v1f64_v1i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mtfprwa 0, 3
; PC64LE-NEXT:    xscvsxddp 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v1f64_v1i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mtfprwa 0, 3
; PC64LE9-NEXT:    xscvsxddp 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x double>
           @llvm.experimental.constrained.sitofp.v1f64.v1i32(<1 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <1 x double> %result
}

define <1 x float> @constrained_vector_sitofp_v1f32_v1i32(<1 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v1f32_v1i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mtfprwa 0, 3
; PC64LE-NEXT:    xscvsxdsp 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v1f32_v1i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mtfprwa 0, 3
; PC64LE9-NEXT:    xscvsxdsp 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x float>
           @llvm.experimental.constrained.sitofp.v1f32.v1i32(<1 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <1 x float> %result
}

define <1 x double> @constrained_vector_sitofp_v1f64_v1i64(<1 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v1f64_v1i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    xscvsxddp 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v1f64_v1i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    xscvsxddp 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x double>
           @llvm.experimental.constrained.sitofp.v1f64.v1i64(<1 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <1 x double> %result
}

define <1 x float> @constrained_vector_sitofp_v1f32_v1i64(<1 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v1f32_v1i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    xscvsxdsp 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v1f32_v1i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    xscvsxdsp 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x float>
           @llvm.experimental.constrained.sitofp.v1f32.v1i64(<1 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <1 x float> %result
}

define <2 x double> @constrained_vector_sitofp_v2f64_v2i16(<2 x i16> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v2f64_v2i16:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    addis 3, 2, .LCPI155_0@toc@ha
; PC64LE-NEXT:    addi 3, 3, .LCPI155_0@toc@l
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    addis 3, 2, .LCPI155_1@toc@ha
; PC64LE-NEXT:    addi 3, 3, .LCPI155_1@toc@l
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 2, 2, 3
; PC64LE-NEXT:    lxvd2x 35, 0, 3
; PC64LE-NEXT:    vsld 2, 2, 3
; PC64LE-NEXT:    vsrad 2, 2, 3
; PC64LE-NEXT:    xvcvsxddp 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v2f64_v2i16:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    addis 3, 2, .LCPI155_0@toc@ha
; PC64LE9-NEXT:    addi 3, 3, .LCPI155_0@toc@l
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 34, 0
; PC64LE9-NEXT:    vextsh2d 2, 2
; PC64LE9-NEXT:    xvcvsxddp 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x double>
           @llvm.experimental.constrained.sitofp.v2f64.v2i16(<2 x i16> %x,
                                                metadata !"round.dynamic",
                                                metadata !"fpexcept.strict") #0
  ret <2 x double> %result
}

define <2 x double> @constrained_vector_sitofp_v2f64_v2i32(<2 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v2f64_v2i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwa 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwa 1, 3
; PC64LE-NEXT:    xscvsxddp 0, 0
; PC64LE-NEXT:    xscvsxddp 1, 1
; PC64LE-NEXT:    xxmrghd 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v2f64_v2i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    li 3, 0
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    mtfprwa 0, 3
; PC64LE9-NEXT:    li 3, 4
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    xscvsxddp 0, 0
; PC64LE9-NEXT:    mtfprwa 1, 3
; PC64LE9-NEXT:    xscvsxddp 1, 1
; PC64LE9-NEXT:    xxmrghd 34, 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x double>
           @llvm.experimental.constrained.sitofp.v2f64.v2i32(<2 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <2 x double> %result
}

define <2 x float> @constrained_vector_sitofp_v2f32_v2i32(<2 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v2f32_v2i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwa 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwa 1, 3
; PC64LE-NEXT:    xscvsxdsp 0, 0
; PC64LE-NEXT:    xscvsxdsp 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v2f32_v2i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    li 3, 0
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    mtfprwa 0, 3
; PC64LE9-NEXT:    li 3, 4
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    xscvsxdsp 0, 0
; PC64LE9-NEXT:    mtfprwa 1, 3
; PC64LE9-NEXT:    xscvsxdsp 1, 1
; PC64LE9-NEXT:    xscvdpspn 0, 0
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xxmrghw 34, 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x float>
           @llvm.experimental.constrained.sitofp.v2f32.v2i32(<2 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <2 x float> %result
}

define <2 x double> @constrained_vector_sitofp_v2f64_v2i64(<2 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v2f64_v2i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvcvsxddp 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v2f64_v2i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvcvsxddp 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x double>
           @llvm.experimental.constrained.sitofp.v2f64.v2i64(<2 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <2 x double> %result
}

define <2 x float> @constrained_vector_sitofp_v2f32_v2i64(<2 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v2f32_v2i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mfvsrd 3, 34
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    mtfprd 1, 3
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    xscvsxdsp 1, 1
; PC64LE-NEXT:    xscvsxdsp 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v2f32_v2i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mfvsrld 3, 34
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    mfvsrd 3, 34
; PC64LE9-NEXT:    mtfprd 1, 3
; PC64LE9-NEXT:    xscvsxdsp 0, 0
; PC64LE9-NEXT:    xscvsxdsp 1, 1
; PC64LE9-NEXT:    xscvdpspn 0, 0
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xxmrghw 34, 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x float>
           @llvm.experimental.constrained.sitofp.v2f32.v2i64(<2 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <2 x float> %result
}

define <3 x double> @constrained_vector_sitofp_v3f64_v3i32(<3 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v3f64_v3i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwa 0, 3
; PC64LE-NEXT:    mffprwz 3, 2
; PC64LE-NEXT:    xscvsxddp 1, 0
; PC64LE-NEXT:    mtfprwa 0, 3
; PC64LE-NEXT:    mfvsrwz 3, 34
; PC64LE-NEXT:    xscvsxddp 2, 0
; PC64LE-NEXT:    mtfprwa 0, 3
; PC64LE-NEXT:    xscvsxddp 3, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v3f64_v3i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    li 3, 0
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    mtfprwa 0, 3
; PC64LE9-NEXT:    li 3, 4
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    xscvsxddp 1, 0
; PC64LE9-NEXT:    mtfprwa 0, 3
; PC64LE9-NEXT:    mfvsrwz 3, 34
; PC64LE9-NEXT:    xscvsxddp 2, 0
; PC64LE9-NEXT:    mtfprwa 0, 3
; PC64LE9-NEXT:    xscvsxddp 3, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x double>
           @llvm.experimental.constrained.sitofp.v3f64.v3i32(<3 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <3 x double> %result
}

define <3 x float> @constrained_vector_sitofp_v3f32_v3i32(<3 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v3f32_v3i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwa 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwa 1, 3
; PC64LE-NEXT:    xscvsxdsp 0, 0
; PC64LE-NEXT:    addis 3, 2, .LCPI161_0@toc@ha
; PC64LE-NEXT:    addi 3, 3, .LCPI161_0@toc@l
; PC64LE-NEXT:    xscvsxdsp 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xxmrghw 35, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    mfvsrwz 3, 34
; PC64LE-NEXT:    xxswapd 36, 0
; PC64LE-NEXT:    mtfprwa 0, 3
; PC64LE-NEXT:    xscvsxdsp 0, 0
; PC64LE-NEXT:    xscvdpspn 34, 0
; PC64LE-NEXT:    vperm 2, 2, 3, 4
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v3f32_v3i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    li 3, 0
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    mtfprwa 0, 3
; PC64LE9-NEXT:    li 3, 4
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    xscvsxdsp 0, 0
; PC64LE9-NEXT:    mtfprwa 1, 3
; PC64LE9-NEXT:    addis 3, 2, .LCPI161_0@toc@ha
; PC64LE9-NEXT:    xscvsxdsp 1, 1
; PC64LE9-NEXT:    addi 3, 3, .LCPI161_0@toc@l
; PC64LE9-NEXT:    xscvdpspn 0, 0
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    mfvsrwz 3, 34
; PC64LE9-NEXT:    mtfprwa 1, 3
; PC64LE9-NEXT:    xscvsxdsp 1, 1
; PC64LE9-NEXT:    xscvdpspn 34, 1
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x float>
           @llvm.experimental.constrained.sitofp.v3f32.v3i32(<3 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <3 x float> %result
}

define <3 x double> @constrained_vector_sitofp_v3f64_v3i64(<3 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v3f64_v3i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    xscvsxddp 1, 0
; PC64LE-NEXT:    mtfprd 0, 4
; PC64LE-NEXT:    xscvsxddp 2, 0
; PC64LE-NEXT:    mtfprd 0, 5
; PC64LE-NEXT:    xscvsxddp 3, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v3f64_v3i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    xscvsxddp 1, 0
; PC64LE9-NEXT:    mtfprd 0, 4
; PC64LE9-NEXT:    xscvsxddp 2, 0
; PC64LE9-NEXT:    mtfprd 0, 5
; PC64LE9-NEXT:    xscvsxddp 3, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x double>
           @llvm.experimental.constrained.sitofp.v3f64.v3i64(<3 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <3 x double> %result
}

define <3 x float> @constrained_vector_sitofp_v3f32_v3i64(<3 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v3f32_v3i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    mtfprd 1, 4
; PC64LE-NEXT:    addis 3, 2, .LCPI163_0@toc@ha
; PC64LE-NEXT:    addi 3, 3, .LCPI163_0@toc@l
; PC64LE-NEXT:    xscvsxdsp 0, 0
; PC64LE-NEXT:    xscvsxdsp 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    mtfprd 0, 5
; PC64LE-NEXT:    xscvsxdsp 0, 0
; PC64LE-NEXT:    xscvdpspn 36, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v3f32_v3i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    mtfprd 1, 4
; PC64LE9-NEXT:    addis 3, 2, .LCPI163_0@toc@ha
; PC64LE9-NEXT:    xscvsxdsp 0, 0
; PC64LE9-NEXT:    xscvsxdsp 1, 1
; PC64LE9-NEXT:    addi 3, 3, .LCPI163_0@toc@l
; PC64LE9-NEXT:    xscvdpspn 0, 0
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    mtfprd 1, 5
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xscvsxdsp 1, 1
; PC64LE9-NEXT:    xscvdpspn 34, 1
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x float>
           @llvm.experimental.constrained.sitofp.v3f32.v3i64(<3 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <3 x float> %result
}

define <4 x double> @constrained_vector_sitofp_v4f64_v4i32(<4 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v4f64_v4i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 3
; PC64LE-NEXT:    mtfprwa 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwa 1, 3
; PC64LE-NEXT:    xscvsxddp 0, 0
; PC64LE-NEXT:    mfvsrwz 3, 34
; PC64LE-NEXT:    xscvsxddp 1, 1
; PC64LE-NEXT:    xxmrghd 0, 1, 0
; PC64LE-NEXT:    mtfprwa 1, 3
; PC64LE-NEXT:    mffprwz 3, 2
; PC64LE-NEXT:    xxlor 34, 0, 0
; PC64LE-NEXT:    mtfprwa 2, 3
; PC64LE-NEXT:    xscvsxddp 1, 1
; PC64LE-NEXT:    xscvsxddp 2, 2
; PC64LE-NEXT:    xxmrghd 35, 2, 1
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v4f64_v4i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    li 3, 0
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    mtfprwa 0, 3
; PC64LE9-NEXT:    li 3, 4
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    xscvsxddp 0, 0
; PC64LE9-NEXT:    mtfprwa 1, 3
; PC64LE9-NEXT:    li 3, 12
; PC64LE9-NEXT:    xscvsxddp 1, 1
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    xxmrghd 0, 1, 0
; PC64LE9-NEXT:    mtfprwa 1, 3
; PC64LE9-NEXT:    mfvsrwz 3, 34
; PC64LE9-NEXT:    mtfprwa 2, 3
; PC64LE9-NEXT:    xscvsxddp 1, 1
; PC64LE9-NEXT:    xscvsxddp 2, 2
; PC64LE9-NEXT:    xxlor 34, 0, 0
; PC64LE9-NEXT:    xxmrghd 35, 1, 2
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x double>
           @llvm.experimental.constrained.sitofp.v4f64.v4i32(<4 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <4 x double> %result
}

define <4 x float> @constrained_vector_sitofp_v4f32_v4i16(<4 x i16> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v4f32_v4i16:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    vspltisw 3, 8
; PC64LE-NEXT:    vmrglh 2, 2, 2
; PC64LE-NEXT:    vadduwm 3, 3, 3
; PC64LE-NEXT:    vslw 2, 2, 3
; PC64LE-NEXT:    vsraw 2, 2, 3
; PC64LE-NEXT:    xvcvsxwsp 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v4f32_v4i16:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    vmrglh 2, 2, 2
; PC64LE9-NEXT:    vextsh2w 2, 2
; PC64LE9-NEXT:    xvcvsxwsp 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x float>
         @llvm.experimental.constrained.sitofp.v4f32.v4i16(<4 x i16> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <4 x float> %result
}

define <4 x float> @constrained_vector_sitofp_v4f32_v4i32(<4 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v4f32_v4i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvcvsxwsp 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v4f32_v4i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvcvsxwsp 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x float>
           @llvm.experimental.constrained.sitofp.v4f32.v4i32(<4 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <4 x float> %result
}

define <4 x double> @constrained_vector_sitofp_v4f64_v4i64(<4 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v4f64_v4i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvcvsxddp 35, 35
; PC64LE-NEXT:    xvcvsxddp 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v4f64_v4i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvcvsxddp 35, 35
; PC64LE9-NEXT:    xvcvsxddp 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x double>
           @llvm.experimental.constrained.sitofp.v4f64.v4i64(<4 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <4 x double> %result
}

define <4 x float> @constrained_vector_sitofp_v4f32_v4i64(<4 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_sitofp_v4f32_v4i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mfvsrd 3, 34
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxswapd 1, 35
; PC64LE-NEXT:    mtfprd 2, 3
; PC64LE-NEXT:    mfvsrd 3, 35
; PC64LE-NEXT:    mtfprd 3, 3
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    xscvsxdsp 2, 2
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    mffprd 3, 1
; PC64LE-NEXT:    xscvsxdsp 3, 3
; PC64LE-NEXT:    mtfprd 1, 3
; PC64LE-NEXT:    xscvsxdsp 0, 0
; PC64LE-NEXT:    xscvsxdsp 1, 1
; PC64LE-NEXT:    xxmrghd 2, 3, 2
; PC64LE-NEXT:    xvcvdpsp 34, 2
; PC64LE-NEXT:    xxmrghd 0, 1, 0
; PC64LE-NEXT:    xvcvdpsp 35, 0
; PC64LE-NEXT:    vmrgew 2, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_sitofp_v4f32_v4i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mfvsrld 3, 34
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    mfvsrld 3, 35
; PC64LE9-NEXT:    xscvsxdsp 0, 0
; PC64LE9-NEXT:    mtfprd 1, 3
; PC64LE9-NEXT:    mfvsrd 3, 34
; PC64LE9-NEXT:    xscvsxdsp 1, 1
; PC64LE9-NEXT:    xxmrghd 0, 1, 0
; PC64LE9-NEXT:    xvcvdpsp 36, 0
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    mfvsrd 3, 35
; PC64LE9-NEXT:    mtfprd 1, 3
; PC64LE9-NEXT:    xscvsxdsp 0, 0
; PC64LE9-NEXT:    xscvsxdsp 1, 1
; PC64LE9-NEXT:    xxmrghd 0, 1, 0
; PC64LE9-NEXT:    xvcvdpsp 34, 0
; PC64LE9-NEXT:    vmrgew 2, 2, 4
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x float>
           @llvm.experimental.constrained.sitofp.v4f32.v4i64(<4 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <4 x float> %result
}

define <1 x double> @constrained_vector_uitofp_v1f64_v1i32(<1 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v1f64_v1i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    xscvuxddp 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v1f64_v1i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    xscvuxddp 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x double>
           @llvm.experimental.constrained.uitofp.v1f64.v1i32(<1 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <1 x double> %result
}

define <1 x float> @constrained_vector_uitofp_v1f32_v1i32(<1 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v1f32_v1i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    xscvuxdsp 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v1f32_v1i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    xscvuxdsp 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x float>
           @llvm.experimental.constrained.uitofp.v1f32.v1i32(<1 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <1 x float> %result
}

define <1 x double> @constrained_vector_uitofp_v1f64_v1i64(<1 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v1f64_v1i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    xscvuxddp 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v1f64_v1i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    xscvuxddp 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x double>
           @llvm.experimental.constrained.uitofp.v1f64.v1i64(<1 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <1 x double> %result
}

define <1 x float> @constrained_vector_uitofp_v1f32_v1i64(<1 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v1f32_v1i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    xscvuxdsp 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v1f32_v1i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    xscvuxdsp 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <1 x float>
           @llvm.experimental.constrained.uitofp.v1f32.v1i64(<1 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <1 x float> %result
}

define <2 x double> @constrained_vector_uitofp_v2f64_v2i16(<2 x i16> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v2f64_v2i16:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    addis 3, 2, .LCPI173_0@toc@ha
; PC64LE-NEXT:    xxlxor 36, 36, 36
; PC64LE-NEXT:    addi 3, 3, .LCPI173_0@toc@l
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    xvcvuxddp 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v2f64_v2i16:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    addis 3, 2, .LCPI173_0@toc@ha
; PC64LE9-NEXT:    xxlxor 1, 1, 1
; PC64LE9-NEXT:    addi 3, 3, .LCPI173_0@toc@l
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xxperm 34, 1, 0
; PC64LE9-NEXT:    xvcvuxddp 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x double>
           @llvm.experimental.constrained.uitofp.v2f64.v2i16(<2 x i16> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <2 x double> %result
}

define <2 x double> @constrained_vector_uitofp_v2f64_v2i32(<2 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v2f64_v2i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwz 1, 3
; PC64LE-NEXT:    xscvuxddp 0, 0
; PC64LE-NEXT:    xscvuxddp 1, 1
; PC64LE-NEXT:    xxmrghd 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v2f64_v2i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    li 3, 0
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    li 3, 4
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    xscvuxddp 0, 0
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    xscvuxddp 1, 1
; PC64LE9-NEXT:    xxmrghd 34, 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x double>
           @llvm.experimental.constrained.uitofp.v2f64.v2i32(<2 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <2 x double> %result
}

define <2 x float> @constrained_vector_uitofp_v2f32_v2i32(<2 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v2f32_v2i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwz 1, 3
; PC64LE-NEXT:    xscvuxdsp 0, 0
; PC64LE-NEXT:    xscvuxdsp 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v2f32_v2i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    li 3, 0
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    li 3, 4
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    xscvuxdsp 0, 0
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    xscvuxdsp 1, 1
; PC64LE9-NEXT:    xscvdpspn 0, 0
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xxmrghw 34, 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x float>
           @llvm.experimental.constrained.uitofp.v2f32.v2i32(<2 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <2 x float> %result
}

define <2 x double> @constrained_vector_uitofp_v2f64_v2i64(<2 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v2f64_v2i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvcvuxddp 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v2f64_v2i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvcvuxddp 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x double>
           @llvm.experimental.constrained.uitofp.v2f64.v2i64(<2 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <2 x double> %result
}

define <2 x float> @constrained_vector_uitofp_v2f32_v2i64(<2 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v2f32_v2i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mfvsrd 3, 34
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    mtfprd 1, 3
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    xscvuxdsp 1, 1
; PC64LE-NEXT:    xscvuxdsp 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v2f32_v2i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mfvsrld 3, 34
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    mfvsrd 3, 34
; PC64LE9-NEXT:    mtfprd 1, 3
; PC64LE9-NEXT:    xscvuxdsp 0, 0
; PC64LE9-NEXT:    xscvuxdsp 1, 1
; PC64LE9-NEXT:    xscvdpspn 0, 0
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xxmrghw 34, 1, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <2 x float>
           @llvm.experimental.constrained.uitofp.v2f32.v2i64(<2 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <2 x float> %result
}

define <3 x double> @constrained_vector_uitofp_v3f64_v3i32(<3 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v3f64_v3i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    mffprwz 3, 2
; PC64LE-NEXT:    xscvuxddp 1, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    mfvsrwz 3, 34
; PC64LE-NEXT:    xscvuxddp 2, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    xscvuxddp 3, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v3f64_v3i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    li 3, 0
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    li 3, 4
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    xscvuxddp 1, 0
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    mfvsrwz 3, 34
; PC64LE9-NEXT:    xscvuxddp 2, 0
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    xscvuxddp 3, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x double>
           @llvm.experimental.constrained.uitofp.v3f64.v3i32(<3 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <3 x double> %result
}

define <3 x float> @constrained_vector_uitofp_v3f32_v3i32(<3 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v3f32_v3i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwz 1, 3
; PC64LE-NEXT:    xscvuxdsp 0, 0
; PC64LE-NEXT:    addis 3, 2, .LCPI179_0@toc@ha
; PC64LE-NEXT:    addi 3, 3, .LCPI179_0@toc@l
; PC64LE-NEXT:    xscvuxdsp 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xxmrghw 35, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    mfvsrwz 3, 34
; PC64LE-NEXT:    xxswapd 36, 0
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    xscvuxdsp 0, 0
; PC64LE-NEXT:    xscvdpspn 34, 0
; PC64LE-NEXT:    vperm 2, 2, 3, 4
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v3f32_v3i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    li 3, 0
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    li 3, 4
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    xscvuxdsp 0, 0
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    addis 3, 2, .LCPI179_0@toc@ha
; PC64LE9-NEXT:    xscvuxdsp 1, 1
; PC64LE9-NEXT:    addi 3, 3, .LCPI179_0@toc@l
; PC64LE9-NEXT:    xscvdpspn 0, 0
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    mfvsrwz 3, 34
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    xscvuxdsp 1, 1
; PC64LE9-NEXT:    xscvdpspn 34, 1
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x float>
           @llvm.experimental.constrained.uitofp.v3f32.v3i32(<3 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <3 x float> %result
}

define <3 x double> @constrained_vector_uitofp_v3f64_v3i64(<3 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v3f64_v3i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    xscvuxddp 1, 0
; PC64LE-NEXT:    mtfprd 0, 4
; PC64LE-NEXT:    xscvuxddp 2, 0
; PC64LE-NEXT:    mtfprd 0, 5
; PC64LE-NEXT:    xscvuxddp 3, 0
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v3f64_v3i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    xscvuxddp 1, 0
; PC64LE9-NEXT:    mtfprd 0, 4
; PC64LE9-NEXT:    xscvuxddp 2, 0
; PC64LE9-NEXT:    mtfprd 0, 5
; PC64LE9-NEXT:    xscvuxddp 3, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x double>
           @llvm.experimental.constrained.uitofp.v3f64.v3i64(<3 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <3 x double> %result
}

define <3 x float> @constrained_vector_uitofp_v3f32_v3i64(<3 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v3f32_v3i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    mtfprd 1, 4
; PC64LE-NEXT:    addis 3, 2, .LCPI181_0@toc@ha
; PC64LE-NEXT:    addi 3, 3, .LCPI181_0@toc@l
; PC64LE-NEXT:    xscvuxdsp 0, 0
; PC64LE-NEXT:    xscvuxdsp 1, 1
; PC64LE-NEXT:    xscvdpspn 0, 0
; PC64LE-NEXT:    xscvdpspn 1, 1
; PC64LE-NEXT:    xxmrghw 34, 1, 0
; PC64LE-NEXT:    lxvd2x 0, 0, 3
; PC64LE-NEXT:    xxswapd 35, 0
; PC64LE-NEXT:    mtfprd 0, 5
; PC64LE-NEXT:    xscvuxdsp 0, 0
; PC64LE-NEXT:    xscvdpspn 36, 0
; PC64LE-NEXT:    vperm 2, 4, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v3f32_v3i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    mtfprd 1, 4
; PC64LE9-NEXT:    addis 3, 2, .LCPI181_0@toc@ha
; PC64LE9-NEXT:    xscvuxdsp 0, 0
; PC64LE9-NEXT:    xscvuxdsp 1, 1
; PC64LE9-NEXT:    addi 3, 3, .LCPI181_0@toc@l
; PC64LE9-NEXT:    xscvdpspn 0, 0
; PC64LE9-NEXT:    xscvdpspn 1, 1
; PC64LE9-NEXT:    xxmrghw 35, 1, 0
; PC64LE9-NEXT:    mtfprd 1, 5
; PC64LE9-NEXT:    lxv 0, 0(3)
; PC64LE9-NEXT:    xscvuxdsp 1, 1
; PC64LE9-NEXT:    xscvdpspn 34, 1
; PC64LE9-NEXT:    xxperm 34, 35, 0
; PC64LE9-NEXT:    blr
entry:
  %result = call <3 x float>
           @llvm.experimental.constrained.uitofp.v3f32.v3i64(<3 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <3 x float> %result
}

define <4 x double> @constrained_vector_uitofp_v4f64_v4i32(<4 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v4f64_v4i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxsldwi 1, 34, 34, 1
; PC64LE-NEXT:    mffprwz 3, 0
; PC64LE-NEXT:    xxsldwi 2, 34, 34, 3
; PC64LE-NEXT:    mtfprwz 0, 3
; PC64LE-NEXT:    mffprwz 3, 1
; PC64LE-NEXT:    mtfprwz 1, 3
; PC64LE-NEXT:    xscvuxddp 0, 0
; PC64LE-NEXT:    mfvsrwz 3, 34
; PC64LE-NEXT:    xscvuxddp 1, 1
; PC64LE-NEXT:    xxmrghd 0, 1, 0
; PC64LE-NEXT:    mtfprwz 1, 3
; PC64LE-NEXT:    mffprwz 3, 2
; PC64LE-NEXT:    xxlor 34, 0, 0
; PC64LE-NEXT:    mtfprwz 2, 3
; PC64LE-NEXT:    xscvuxddp 1, 1
; PC64LE-NEXT:    xscvuxddp 2, 2
; PC64LE-NEXT:    xxmrghd 35, 2, 1
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v4f64_v4i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    li 3, 0
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    mtfprwz 0, 3
; PC64LE9-NEXT:    li 3, 4
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    xscvuxddp 0, 0
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    li 3, 12
; PC64LE9-NEXT:    xscvuxddp 1, 1
; PC64LE9-NEXT:    vextuwrx 3, 3, 2
; PC64LE9-NEXT:    xxmrghd 0, 1, 0
; PC64LE9-NEXT:    mtfprwz 1, 3
; PC64LE9-NEXT:    mfvsrwz 3, 34
; PC64LE9-NEXT:    mtfprwz 2, 3
; PC64LE9-NEXT:    xscvuxddp 1, 1
; PC64LE9-NEXT:    xscvuxddp 2, 2
; PC64LE9-NEXT:    xxlor 34, 0, 0
; PC64LE9-NEXT:    xxmrghd 35, 1, 2
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x double>
           @llvm.experimental.constrained.uitofp.v4f64.v4i32(<4 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <4 x double> %result
}

define <4 x float> @constrained_vector_uitofp_v4f32_v4i16(<4 x i16> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v4f32_v4i16:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xxlxor 35, 35, 35
; PC64LE-NEXT:    vmrglh 2, 3, 2
; PC64LE-NEXT:    xvcvuxwsp 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v4f32_v4i16:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xxlxor 35, 35, 35
; PC64LE9-NEXT:    vmrglh 2, 3, 2
; PC64LE9-NEXT:    xvcvuxwsp 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x float>
         @llvm.experimental.constrained.uitofp.v4f32.v4i16(<4 x i16> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <4 x float> %result
}

define <4 x float> @constrained_vector_uitofp_v4f32_v4i32(<4 x i32> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v4f32_v4i32:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvcvuxwsp 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v4f32_v4i32:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvcvuxwsp 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x float>
           @llvm.experimental.constrained.uitofp.v4f32.v4i32(<4 x i32> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <4 x float> %result
}

define <4 x double> @constrained_vector_uitofp_v4f64_v4i64(<4 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v4f64_v4i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    xvcvuxddp 35, 35
; PC64LE-NEXT:    xvcvuxddp 34, 34
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v4f64_v4i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    xvcvuxddp 35, 35
; PC64LE9-NEXT:    xvcvuxddp 34, 34
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x double>
           @llvm.experimental.constrained.uitofp.v4f64.v4i64(<4 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <4 x double> %result
}

define <4 x float> @constrained_vector_uitofp_v4f32_v4i64(<4 x i64> %x) #0 {
; PC64LE-LABEL: constrained_vector_uitofp_v4f32_v4i64:
; PC64LE:       # %bb.0: # %entry
; PC64LE-NEXT:    mfvsrd 3, 34
; PC64LE-NEXT:    xxswapd 0, 34
; PC64LE-NEXT:    xxswapd 1, 35
; PC64LE-NEXT:    mtfprd 2, 3
; PC64LE-NEXT:    mfvsrd 3, 35
; PC64LE-NEXT:    mtfprd 3, 3
; PC64LE-NEXT:    mffprd 3, 0
; PC64LE-NEXT:    xscvuxdsp 2, 2
; PC64LE-NEXT:    mtfprd 0, 3
; PC64LE-NEXT:    mffprd 3, 1
; PC64LE-NEXT:    xscvuxdsp 3, 3
; PC64LE-NEXT:    mtfprd 1, 3
; PC64LE-NEXT:    xscvuxdsp 0, 0
; PC64LE-NEXT:    xscvuxdsp 1, 1
; PC64LE-NEXT:    xxmrghd 2, 3, 2
; PC64LE-NEXT:    xvcvdpsp 34, 2
; PC64LE-NEXT:    xxmrghd 0, 1, 0
; PC64LE-NEXT:    xvcvdpsp 35, 0
; PC64LE-NEXT:    vmrgew 2, 2, 3
; PC64LE-NEXT:    blr
;
; PC64LE9-LABEL: constrained_vector_uitofp_v4f32_v4i64:
; PC64LE9:       # %bb.0: # %entry
; PC64LE9-NEXT:    mfvsrld 3, 34
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    mfvsrld 3, 35
; PC64LE9-NEXT:    xscvuxdsp 0, 0
; PC64LE9-NEXT:    mtfprd 1, 3
; PC64LE9-NEXT:    mfvsrd 3, 34
; PC64LE9-NEXT:    xscvuxdsp 1, 1
; PC64LE9-NEXT:    xxmrghd 0, 1, 0
; PC64LE9-NEXT:    xvcvdpsp 36, 0
; PC64LE9-NEXT:    mtfprd 0, 3
; PC64LE9-NEXT:    mfvsrd 3, 35
; PC64LE9-NEXT:    mtfprd 1, 3
; PC64LE9-NEXT:    xscvuxdsp 0, 0
; PC64LE9-NEXT:    xscvuxdsp 1, 1
; PC64LE9-NEXT:    xxmrghd 0, 1, 0
; PC64LE9-NEXT:    xvcvdpsp 34, 0
; PC64LE9-NEXT:    vmrgew 2, 2, 4
; PC64LE9-NEXT:    blr
entry:
  %result = call <4 x float>
           @llvm.experimental.constrained.uitofp.v4f32.v4i64(<4 x i64> %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret <4 x float> %result
}

attributes #0 = { nounwind strictfp noimplicitfloat }
attributes #1 = { strictfp }

; Single width declarations
declare <2 x double> @llvm.experimental.constrained.fadd.v2f64(<2 x double>, <2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.fsub.v2f64(<2 x double>, <2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.fmul.v2f64(<2 x double>, <2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.fdiv.v2f64(<2 x double>, <2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.frem.v2f64(<2 x double>, <2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.sqrt.v2f64(<2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.pow.v2f64(<2 x double>, <2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.powi.v2f64(<2 x double>, i32, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.sin.v2f64(<2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.cos.v2f64(<2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.exp.v2f64(<2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.exp2.v2f64(<2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.log.v2f64(<2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.log10.v2f64(<2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.log2.v2f64(<2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.rint.v2f64(<2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.nearbyint.v2f64(<2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.maxnum.v2f64(<2 x double>, <2 x double>, metadata)
declare <2 x double> @llvm.experimental.constrained.minnum.v2f64(<2 x double>, <2 x double>, metadata)
declare <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f32(<2 x float>, metadata)
declare <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f32(<2 x float>, metadata)
declare <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f64(<2 x double>, metadata)
declare <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f64(<2 x double>, metadata)
declare <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f32(<2 x float>, metadata)
declare <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f32(<2 x float>, metadata)
declare <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f64(<2 x double>, metadata)
declare <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f64(<2 x double>, metadata)
declare <2 x float> @llvm.experimental.constrained.fptrunc.v2f32.v2f64(<2 x double>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.fpext.v2f64.v2f32(<2 x float>, metadata)
declare <2 x double> @llvm.experimental.constrained.ceil.v2f64(<2 x double>, metadata)
declare <2 x double> @llvm.experimental.constrained.floor.v2f64(<2 x double>, metadata)
declare <2 x double> @llvm.experimental.constrained.round.v2f64(<2 x double>, metadata)
declare <2 x double> @llvm.experimental.constrained.trunc.v2f64(<2 x double>, metadata)
declare <2 x double> @llvm.experimental.constrained.uitofp.v2f64.v2i16(<2 x i16>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.sitofp.v2f64.v2i16(<2 x i16>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.sitofp.v2f64.v2i32(<2 x i32>, metadata, metadata)
declare <2 x float> @llvm.experimental.constrained.sitofp.v2f32.v2i32(<2 x i32>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.sitofp.v2f64.v2i64(<2 x i64>, metadata, metadata)
declare <2 x float> @llvm.experimental.constrained.sitofp.v2f32.v2i64(<2 x i64>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.uitofp.v2f64.v2i32(<2 x i32>, metadata, metadata)
declare <2 x float> @llvm.experimental.constrained.uitofp.v2f32.v2i32(<2 x i32>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.uitofp.v2f64.v2i64(<2 x i64>, metadata, metadata)
declare <2 x float> @llvm.experimental.constrained.uitofp.v2f32.v2i64(<2 x i64>, metadata, metadata)

; Scalar width declarations
declare <1 x float> @llvm.experimental.constrained.fadd.v1f32(<1 x float>, <1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.fsub.v1f32(<1 x float>, <1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.fmul.v1f32(<1 x float>, <1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.fdiv.v1f32(<1 x float>, <1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.frem.v1f32(<1 x float>, <1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.sqrt.v1f32(<1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.pow.v1f32(<1 x float>, <1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.powi.v1f32(<1 x float>, i32, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.sin.v1f32(<1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.cos.v1f32(<1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.exp.v1f32(<1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.exp2.v1f32(<1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.log.v1f32(<1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.log10.v1f32(<1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.log2.v1f32(<1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.rint.v1f32(<1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.nearbyint.v1f32(<1 x float>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.maxnum.v1f32(<1 x float>, <1 x float>, metadata)
declare <1 x float> @llvm.experimental.constrained.minnum.v1f32(<1 x float>, <1 x float>, metadata)
declare <1 x i32> @llvm.experimental.constrained.fptosi.v1i32.v1f32(<1 x float>, metadata)
declare <1 x i64> @llvm.experimental.constrained.fptosi.v1i64.v1f32(<1 x float>, metadata)
declare <1 x i32> @llvm.experimental.constrained.fptosi.v1i32.v1f64(<1 x double>, metadata)
declare <1 x i64> @llvm.experimental.constrained.fptosi.v1i64.v1f64(<1 x double>, metadata)
declare <1 x i32> @llvm.experimental.constrained.fptoui.v1i32.v1f32(<1 x float>, metadata)
declare <1 x i64> @llvm.experimental.constrained.fptoui.v1i64.v1f32(<1 x float>, metadata)
declare <1 x i32> @llvm.experimental.constrained.fptoui.v1i32.v1f64(<1 x double>, metadata)
declare <1 x i64> @llvm.experimental.constrained.fptoui.v1i64.v1f64(<1 x double>, metadata)
declare <1 x float> @llvm.experimental.constrained.fptrunc.v1f32.v1f64(<1 x double>, metadata, metadata)
declare <1 x double> @llvm.experimental.constrained.fpext.v1f64.v1f32(<1 x float>, metadata)
declare <1 x float> @llvm.experimental.constrained.ceil.v1f32(<1 x float>, metadata)
declare <1 x float> @llvm.experimental.constrained.floor.v1f32(<1 x float>, metadata)
declare <1 x float> @llvm.experimental.constrained.round.v1f32(<1 x float>, metadata)
declare <1 x float> @llvm.experimental.constrained.trunc.v1f32(<1 x float>, metadata)
declare <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i32(<1 x i32>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.sitofp.v1f32.v1i32(<1 x i32>, metadata, metadata)
declare <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i64(<1 x i64>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.sitofp.v1f32.v1i64(<1 x i64>, metadata, metadata)
declare <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i32(<1 x i32>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.uitofp.v1f32.v1i32(<1 x i32>, metadata, metadata)
declare <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i64(<1 x i64>, metadata, metadata)
declare <1 x float> @llvm.experimental.constrained.uitofp.v1f32.v1i64(<1 x i64>, metadata, metadata)

; Illegal width declarations
declare <3 x float> @llvm.experimental.constrained.fadd.v3f32(<3 x float>, <3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.fadd.v3f64(<3 x double>, <3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.fsub.v3f32(<3 x float>, <3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.fsub.v3f64(<3 x double>, <3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.fmul.v3f32(<3 x float>, <3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.fmul.v3f64(<3 x double>, <3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.fdiv.v3f32(<3 x float>, <3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.fdiv.v3f64(<3 x double>, <3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.frem.v3f32(<3 x float>, <3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.frem.v3f64(<3 x double>, <3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.sqrt.v3f32(<3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.sqrt.v3f64(<3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.pow.v3f32(<3 x float>, <3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.pow.v3f64(<3 x double>, <3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.powi.v3f32(<3 x float>, i32, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.powi.v3f64(<3 x double>, i32, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.sin.v3f32(<3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.sin.v3f64(<3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.cos.v3f32(<3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.cos.v3f64(<3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.exp.v3f32(<3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.exp.v3f64(<3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.exp2.v3f32(<3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.exp2.v3f64(<3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.log.v3f32(<3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.log.v3f64(<3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.log10.v3f32(<3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.log10.v3f64(<3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.log2.v3f32(<3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.log2.v3f64(<3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.rint.v3f32(<3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.rint.v3f64(<3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.nearbyint.v3f32(<3 x float>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.nearbyint.v3f64(<3 x double>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.maxnum.v3f32(<3 x float>, <3 x float>, metadata)
declare <3 x double> @llvm.experimental.constrained.maxnum.v3f64(<3 x double>, <3 x double>, metadata)
declare <3 x float> @llvm.experimental.constrained.minnum.v3f32(<3 x float>, <3 x float>, metadata)
declare <3 x double> @llvm.experimental.constrained.minnum.v3f64(<3 x double>, <3 x double>, metadata)
declare <3 x i32> @llvm.experimental.constrained.fptosi.v3i32.v3f32(<3 x float>, metadata)
declare <3 x i64> @llvm.experimental.constrained.fptosi.v3i64.v3f32(<3 x float>, metadata)
declare <3 x i32> @llvm.experimental.constrained.fptosi.v3i32.v3f64(<3 x double>, metadata)
declare <3 x i64> @llvm.experimental.constrained.fptosi.v3i64.v3f64(<3 x double>, metadata)
declare <3 x i32> @llvm.experimental.constrained.fptoui.v3i32.v3f32(<3 x float>, metadata)
declare <3 x i64> @llvm.experimental.constrained.fptoui.v3i64.v3f32(<3 x float>, metadata)
declare <3 x i32> @llvm.experimental.constrained.fptoui.v3i32.v3f64(<3 x double>, metadata)
declare <3 x i64> @llvm.experimental.constrained.fptoui.v3i64.v3f64(<3 x double>, metadata)
declare <3 x float> @llvm.experimental.constrained.fptrunc.v3f32.v3f64(<3 x double>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.fpext.v3f64.v3f32(<3 x float>, metadata)
declare <3 x float> @llvm.experimental.constrained.ceil.v3f32(<3 x float>, metadata)
declare <3 x double> @llvm.experimental.constrained.ceil.v3f64(<3 x double>, metadata)
declare <3 x float> @llvm.experimental.constrained.floor.v3f32(<3 x float>, metadata)
declare <3 x double> @llvm.experimental.constrained.floor.v3f64(<3 x double>, metadata)
declare <3 x float> @llvm.experimental.constrained.round.v3f32(<3 x float>, metadata)
declare <3 x double> @llvm.experimental.constrained.round.v3f64(<3 x double>, metadata)
declare <3 x float> @llvm.experimental.constrained.trunc.v3f32(<3 x float>, metadata)
declare <3 x double> @llvm.experimental.constrained.trunc.v3f64(<3 x double>, metadata)
declare <3 x double> @llvm.experimental.constrained.sitofp.v3f64.v3i32(<3 x i32>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.sitofp.v3f32.v3i32(<3 x i32>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.sitofp.v3f64.v3i64(<3 x i64>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.sitofp.v3f32.v3i64(<3 x i64>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.uitofp.v3f64.v3i32(<3 x i32>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.uitofp.v3f32.v3i32(<3 x i32>, metadata, metadata)
declare <3 x double> @llvm.experimental.constrained.uitofp.v3f64.v3i64(<3 x i64>, metadata, metadata)
declare <3 x float> @llvm.experimental.constrained.uitofp.v3f32.v3i64(<3 x i64>, metadata, metadata)

; Double width declarations
declare <4 x double> @llvm.experimental.constrained.fadd.v4f64(<4 x double>, <4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.fsub.v4f64(<4 x double>, <4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.fmul.v4f64(<4 x double>, <4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.fdiv.v4f64(<4 x double>, <4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.frem.v4f64(<4 x double>, <4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.sqrt.v4f64(<4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.pow.v4f64(<4 x double>, <4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.powi.v4f64(<4 x double>, i32, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.sin.v4f64(<4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.cos.v4f64(<4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.exp.v4f64(<4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.exp2.v4f64(<4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.log.v4f64(<4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.log10.v4f64(<4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.log2.v4f64(<4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.rint.v4f64(<4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.nearbyint.v4f64(<4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.maxnum.v4f64(<4 x double>, <4 x double>, metadata)
declare <4 x double> @llvm.experimental.constrained.minnum.v4f64(<4 x double>, <4 x double>, metadata)
declare <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f32(<4 x float>, metadata)
declare <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f32(<4 x float>, metadata)
declare <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f64(<4 x double>, metadata)
declare <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f64(<4 x double>, metadata)
declare <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f32(<4 x float>, metadata)
declare <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f32(<4 x float>, metadata)
declare <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f64(<4 x double>, metadata)
declare <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f64(<4 x double>, metadata)
declare <4 x float> @llvm.experimental.constrained.fptrunc.v4f32.v4f64(<4 x double>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.fpext.v4f64.v4f32(<4 x float>, metadata)
declare <4 x double> @llvm.experimental.constrained.ceil.v4f64(<4 x double>, metadata)
declare <4 x double> @llvm.experimental.constrained.floor.v4f64(<4 x double>, metadata)
declare <4 x double> @llvm.experimental.constrained.round.v4f64(<4 x double>, metadata)
declare <4 x double> @llvm.experimental.constrained.trunc.v4f64(<4 x double>, metadata)
declare <4 x float> @llvm.experimental.constrained.sitofp.v4f32.v4i16(<4 x i16>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.sitofp.v4f64.v4i32(<4 x i32>, metadata, metadata)
declare <4 x float> @llvm.experimental.constrained.sitofp.v4f32.v4i32(<4 x i32>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.sitofp.v4f64.v4i64(<4 x i64>, metadata, metadata)
declare <4 x float> @llvm.experimental.constrained.sitofp.v4f32.v4i64(<4 x i64>, metadata, metadata)
declare <4 x float> @llvm.experimental.constrained.uitofp.v4f32.v4i16(<4 x i16>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.uitofp.v4f64.v4i32(<4 x i32>, metadata, metadata)
declare <4 x float> @llvm.experimental.constrained.uitofp.v4f32.v4i32(<4 x i32>, metadata, metadata)
declare <4 x double> @llvm.experimental.constrained.uitofp.v4f64.v4i64(<4 x i64>, metadata, metadata)
declare <4 x float> @llvm.experimental.constrained.uitofp.v4f32.v4i64(<4 x i64>, metadata, metadata)
