; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; FIXME(ndesaulniers): get this test to pass with -verify-machineinstrs
; enabled. https://github.com/llvm/llvm-project/issues/60827
; RUN: llc -mtriple=i386-linux-gnu %s -o - -stop-after=finalize-isel \
; RUN:   -verify-machineinstrs=0 -start-before=x86-isel | FileCheck %s

define i8 @emulator_cmpxchg_emulated() {
  ; CHECK-LABEL: name: emulator_cmpxchg_emulated
  ; CHECK: bb.0.entry:
  ; CHECK-NEXT:   successors: %bb.1(0x80000000), %bb.2(0x00000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[MOV32rm:%[0-9]+]]:gr32 = MOV32rm $noreg, 1, $noreg, 0, $noreg :: (load (s32) from `ptr null`, align 8)
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:gr32_norex2 = COPY [[MOV32rm]]
  ; CHECK-NEXT:   INLINEASM_BR &"", 16 /* maystore attdialect */, 2359306 /* regdef:GR32 */, def %2, 2686986 /* regdef:GR32_NOREX2 */, def %3, 2147549193 /* reguse tiedto:$1 */, [[COPY]](tied-def 5), 13 /* imm */, %bb.2
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:gr32 = COPY $eflags
  ; CHECK-NEXT:   $eflags = COPY [[COPY1]]
  ; CHECK-NEXT:   [[SETCCr:%[0-9]+]]:gr8 = SETCCr 4, implicit $eflags
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:gr32 = COPY %3
  ; CHECK-NEXT:   JMP_1 %bb.1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.1.asm.fallthrough:
  ; CHECK-NEXT:   $al = COPY [[SETCCr]]
  ; CHECK-NEXT:   RET 0, $al
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.2.efaultu64.split (machine-block-address-taken, inlineasm-br-indirect-target):
  ; CHECK-NEXT:   [[SETCCr1:%[0-9]+]]:gr8 = SETCCr 4, implicit $eflags
  ; CHECK-NEXT:   $al = COPY [[SETCCr1]]
  ; CHECK-NEXT:   RET 0, $al
entry:
  %0 = load i32, ptr null, align 8
  %1 = callbr { i8, i32 } asm "", "={@ccz},=r,1,!i"(i32 %0)
          to label %asm.fallthrough [label %efaultu64.split]

asm.fallthrough:
  %asmresult = extractvalue { i8, i32 } %1, 0
  %asmresult1 = extractvalue { i8, i32 } %1, 1
  ret i8 %asmresult

efaultu64.split:
  %2 = call { i8, i32 } @llvm.callbr.landingpad.sl_i8i32s({ i8, i32 } %1)
  %asmresult2 = extractvalue { i8, i32 } %2, 0
  %asmresult3 = extractvalue { i8, i32 } %2, 1
  ret i8 %asmresult2
}

; Same test but return second value
define i32 @emulator_cmpxchg_emulated2() {
  ; CHECK-LABEL: name: emulator_cmpxchg_emulated2
  ; CHECK: bb.0.entry:
  ; CHECK-NEXT:   successors: %bb.1(0x80000000), %bb.2(0x00000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[MOV32rm:%[0-9]+]]:gr32 = MOV32rm $noreg, 1, $noreg, 0, $noreg :: (load (s32) from `ptr null`, align 8)
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:gr32_norex2 = COPY [[MOV32rm]]
  ; CHECK-NEXT:   INLINEASM_BR &"", 16 /* maystore attdialect */, 2359306 /* regdef:GR32 */, def %2, 2686986 /* regdef:GR32_NOREX2 */, def %3, 2147549193 /* reguse tiedto:$1 */, [[COPY]](tied-def 5), 13 /* imm */, %bb.2
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:gr32 = COPY $eflags
  ; CHECK-NEXT:   $eflags = COPY [[COPY1]]
  ; CHECK-NEXT:   [[SETCCr:%[0-9]+]]:gr8 = SETCCr 4, implicit $eflags
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:gr32 = COPY %3
  ; CHECK-NEXT:   JMP_1 %bb.1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.1.asm.fallthrough:
  ; CHECK-NEXT:   $eax = COPY [[COPY2]]
  ; CHECK-NEXT:   RET 0, $eax
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.2.efaultu64.split (machine-block-address-taken, inlineasm-br-indirect-target):
  ; CHECK-NEXT:   $eax = COPY %3
  ; CHECK-NEXT:   RET 0, $eax
entry:
  %0 = load i32, ptr null, align 8
  %1 = callbr { i8, i32 } asm "", "={@ccz},=r,1,!i"(i32 %0)
          to label %asm.fallthrough [label %efaultu64.split]

asm.fallthrough:
  %asmresult = extractvalue { i8, i32 } %1, 0
  %asmresult1 = extractvalue { i8, i32 } %1, 1
  ret i32 %asmresult1

efaultu64.split:
  %2 = call { i8, i32 } @llvm.callbr.landingpad.sl_i8i32s({ i8, i32 } %1)
  %asmresult2 = extractvalue { i8, i32 } %2, 0
  %asmresult3 = extractvalue { i8, i32 } %2, 1
  ret i32 %asmresult3
}

define i64 @multireg() {
  ; CHECK-LABEL: name: multireg
  ; CHECK: bb.0.entry:
  ; CHECK-NEXT:   successors: %bb.1(0x80000000), %bb.2(0x00000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   INLINEASM_BR &"", 0 /* attdialect */, 18 /* regdef */, implicit-def $eax, implicit-def $edx, 13 /* imm */, %bb.2
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:gr32 = COPY $eax
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:gr32 = COPY $edx
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:gr32 = COPY [[COPY1]]
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:gr32 = COPY [[COPY]]
  ; CHECK-NEXT:   JMP_1 %bb.1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.1.ft:
  ; CHECK-NEXT:   $eax = COPY [[COPY3]]
  ; CHECK-NEXT:   $edx = COPY [[COPY2]]
  ; CHECK-NEXT:   RET 0, $eax, $edx
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.2.split (machine-block-address-taken, inlineasm-br-indirect-target):
  ; CHECK-NEXT:   liveins: $eax, $edx
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:gr32 = COPY $eax
  ; CHECK-NEXT:   [[COPY5:%[0-9]+]]:gr32 = COPY $edx
  ; CHECK-NEXT:   $eax = COPY [[COPY4]]
  ; CHECK-NEXT:   $edx = COPY [[COPY5]]
  ; CHECK-NEXT:   RET 0, $eax, $edx
entry:
  %0 = callbr i64 asm "", "=A,!i"() to label %ft [label %split]
ft:
  ret i64 %0
split:
  %1 = call i64 @llvm.callbr.landingpad.i64(i64 %0)
  ret i64 %1
}
declare i64 @llvm.callbr.landingpad.i64(i64)
declare { i8, i32 } @llvm.callbr.landingpad.sl_i8i32s({ i8, i32 })
