; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=hawaii -mattr=+flat-for-global < %s | FileCheck -enable-var-scope --check-prefixes=SI,SI-SAFE %s
; RUN: llc -enable-no-signed-zeros-fp-math -mtriple=amdgcn -mcpu=hawaii -mattr=+flat-for-global < %s | FileCheck -enable-var-scope --check-prefixes=SI,SI-NSZ %s

; RUN: llc -mtriple=amdgcn -mcpu=fiji < %s | FileCheck -enable-var-scope --check-prefixes=VI,VI-SAFE %s
; RUN: llc -enable-no-signed-zeros-fp-math -mtriple=amdgcn -mcpu=fiji < %s | FileCheck -enable-var-scope --check-prefixes=VI,VI-NSZ %s

; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 < %s | FileCheck -enable-var-scope --check-prefixes=GFX11,GFX11-SAFE %s
; RUN: llc -enable-no-signed-zeros-fp-math -mtriple=amdgcn -mcpu=gfx1100 < %s | FileCheck -enable-var-scope --check-prefixes=GFX11,GFX11-NSZ %s

; --------------------------------------------------------------------------------
; fadd tests
; --------------------------------------------------------------------------------

define half @v_fneg_add_f16(half %a, half %b) #0 {
; SI-SAFE-LABEL: v_fneg_add_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_add_f32_e32 v0, v0, v1
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_add_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_sub_f32_e32 v0, v0, v1
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_add_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_add_f16_e32 v0, v0, v1
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_add_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_sub_f16_e64 v0, -v0, v1
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_add_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_add_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_sub_f16_e64 v0, -v0, v1
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %add = fadd half %a, %b
  %fneg = fneg half %add
  ret half %fneg
}

define { half, half } @v_fneg_add_store_use_add_f16(half %a, half %b) #0 {
; SI-LABEL: v_fneg_add_store_use_add_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v1, v0, v1
; SI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_add_store_use_add_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_f16_e32 v1, v0, v1
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_add_store_use_add_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_f16_e32 v1, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x8000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %add = fadd half %a, %b
  %fneg = fneg half %add
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %add, 1
  ret { half, half } %insert.1
}

define { half, half } @v_fneg_add_multi_use_add_f16(half %a, half %b) #0 {
; SI-SAFE-LABEL: v_fneg_add_multi_use_add_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_add_f32_e32 v1, v0, v1
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; SI-SAFE-NEXT:    v_mul_f32_e32 v1, 4.0, v1
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_add_multi_use_add_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e64 v0, -v0
; SI-NSZ-NEXT:    v_sub_f32_e32 v0, v0, v1
; SI-NSZ-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_add_multi_use_add_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_add_f16_e32 v1, v0, v1
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v1
; VI-SAFE-NEXT:    v_mul_f16_e32 v1, 4.0, v1
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_add_multi_use_add_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_sub_f16_e64 v0, -v0, v1
; VI-NSZ-NEXT:    v_mul_f16_e32 v1, -4.0, v0
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_add_multi_use_add_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_add_f16_e32 v1, v0, v1
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v1
; GFX11-SAFE-NEXT:    v_mul_f16_e32 v1, 4.0, v1
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_add_multi_use_add_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_sub_f16_e64 v0, -v0, v1
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_mul_f16_e32 v1, -4.0, v0
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %add = fadd half %a, %b
  %fneg = fneg half %add
  %use1 = fmul half %add, 4.0

  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %use1, 1
  ret { half, half } %insert.1
}

define half @v_fneg_add_fneg_x_f16(half %a, half %b) #0 {
; SI-SAFE-LABEL: v_fneg_add_fneg_x_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_sub_f32_e32 v0, v1, v0
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_add_fneg_x_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_sub_f32_e32 v0, v0, v1
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_add_fneg_x_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_sub_f16_e32 v0, v1, v0
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_add_fneg_x_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_sub_f16_e32 v0, v0, v1
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_add_fneg_x_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_sub_f16_e32 v0, v1, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_add_fneg_x_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_sub_f16_e32 v0, v0, v1
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %add = fadd half %fneg.a, %b
  %fneg = fneg half %add
  ret half %fneg
}

define half @v_fneg_add_x_fneg_f16(half %a, half %b) #0 {
; SI-SAFE-LABEL: v_fneg_add_x_fneg_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_sub_f32_e32 v0, v0, v1
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_add_x_fneg_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_sub_f32_e32 v0, v1, v0
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_add_x_fneg_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_sub_f16_e32 v0, v0, v1
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_add_x_fneg_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_sub_f16_e32 v0, v1, v0
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_add_x_fneg_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_sub_f16_e32 v0, v0, v1
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_add_x_fneg_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_sub_f16_e32 v0, v1, v0
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.b = fneg half %b
  %add = fadd half %a, %fneg.b
  %fneg = fneg half %add
  ret half %fneg
}

define half @v_fneg_add_fneg_fneg_f16(half %a, half %b) #0 {
; SI-SAFE-LABEL: v_fneg_add_fneg_fneg_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_sub_f32_e32 v0, v0, v1
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_add_fneg_fneg_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_add_f32_e32 v0, v0, v1
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_add_fneg_fneg_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_sub_f16_e64 v0, -v0, v1
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_add_fneg_fneg_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_add_f16_e32 v0, v0, v1
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_add_fneg_fneg_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_sub_f16_e64 v0, -v0, v1
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_add_fneg_fneg_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %fneg.b = fneg half %b
  %add = fadd half %fneg.a, %fneg.b
  %fneg = fneg half %add
  ret half %fneg
}

define { half, half } @v_fneg_add_store_use_fneg_x_f16(half %a, half %b) #0 {
; SI-SAFE-LABEL: v_fneg_add_store_use_fneg_x_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v3, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e64 v1, -v0
; SI-SAFE-NEXT:    v_sub_f32_e32 v0, v3, v2
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_add_store_use_fneg_x_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e64 v1, -v0
; SI-NSZ-NEXT:    v_sub_f32_e32 v0, v3, v2
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_add_store_use_fneg_x_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_xor_b32_e32 v2, 0x8000, v0
; VI-SAFE-NEXT:    v_sub_f16_e32 v0, v1, v0
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    v_mov_b32_e32 v1, v2
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_add_store_use_fneg_x_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_xor_b32_e32 v2, 0x8000, v0
; VI-NSZ-NEXT:    v_sub_f16_e32 v0, v0, v1
; VI-NSZ-NEXT:    v_mov_b32_e32 v1, v2
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_add_store_use_fneg_x_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_sub_f16_e32 v1, v1, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v2, 0x8000, v1
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v1, 0x8000, v0
; GFX11-SAFE-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_add_store_use_fneg_x_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_sub_f16_e32 v2, v0, v1
; GFX11-NSZ-NEXT:    v_xor_b32_e32 v1, 0x8000, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NSZ-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %add = fadd half %fneg.a, %b
  %fneg = fneg half %add
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %fneg.a, 1
  ret { half, half } %insert.1
}

define { half, half } @v_fneg_add_multi_use_fneg_x_f16(half %a, half %b, half %c) #0 {
; SI-SAFE-LABEL: v_fneg_add_multi_use_fneg_x_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e64 v4, -v0
; SI-SAFE-NEXT:    v_sub_f32_e32 v0, v1, v3
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    v_mul_f32_e32 v1, v4, v2
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_add_multi_use_fneg_x_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e64 v4, -v0
; SI-NSZ-NEXT:    v_sub_f32_e32 v0, v3, v1
; SI-NSZ-NEXT:    v_mul_f32_e32 v1, v4, v2
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_add_multi_use_fneg_x_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_sub_f16_e32 v1, v1, v0
; VI-SAFE-NEXT:    v_xor_b32_e32 v3, 0x8000, v1
; VI-SAFE-NEXT:    v_mul_f16_e64 v1, -v0, v2
; VI-SAFE-NEXT:    v_mov_b32_e32 v0, v3
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_add_multi_use_fneg_x_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_sub_f16_e32 v3, v0, v1
; VI-NSZ-NEXT:    v_mul_f16_e64 v1, -v0, v2
; VI-NSZ-NEXT:    v_mov_b32_e32 v0, v3
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_add_multi_use_fneg_x_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_sub_f16_e32 v1, v1, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v3, 0x8000, v1
; GFX11-SAFE-NEXT:    v_mul_f16_e64 v1, -v0, v2
; GFX11-SAFE-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_add_multi_use_fneg_x_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_sub_f16_e32 v3, v0, v1
; GFX11-NSZ-NEXT:    v_mul_f16_e64 v1, -v0, v2
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NSZ-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %add = fadd half %fneg.a, %b
  %fneg = fneg half %add
  %use1 = fmul half %fneg.a, %c

  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %use1, 1
  ret { half, half } %insert.1
}

; This one asserted with -enable-no-signed-zeros-fp-math
define amdgpu_ps half @fneg_fadd_0_f16(half inreg %tmp2, half inreg %tmp6, <4 x i32> %arg) #0 {
; SI-SAFE-LABEL: fneg_fadd_0_f16:
; SI-SAFE:       ; %bb.0: ; %.entry
; SI-SAFE-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, s1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, s0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_div_scale_f32 v2, s[0:1], v0, v0, 1.0
; SI-SAFE-NEXT:    v_rcp_f32_e32 v3, v2
; SI-SAFE-NEXT:    v_div_scale_f32 v4, vcc, 1.0, v0, 1.0
; SI-SAFE-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; SI-SAFE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; SI-SAFE-NEXT:    v_fma_f32 v3, v5, v3, v3
; SI-SAFE-NEXT:    v_mul_f32_e32 v5, v4, v3
; SI-SAFE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; SI-SAFE-NEXT:    v_fma_f32 v5, v6, v3, v5
; SI-SAFE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; SI-SAFE-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; SI-SAFE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; SI-SAFE-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; SI-SAFE-NEXT:    v_mad_f32 v0, v0, 0, 0
; SI-SAFE-NEXT:    v_cmp_nlt_f32_e32 vcc, v0, v1
; SI-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v1, vcc
; SI-SAFE-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; SI-SAFE-NEXT:    v_cmp_nlt_f32_e32 vcc, 0, v0
; SI-SAFE-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; SI-SAFE-NEXT:    ; return to shader part epilog
;
; SI-NSZ-LABEL: fneg_fadd_0_f16:
; SI-NSZ:       ; %bb.0: ; %.entry
; SI-NSZ-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, s1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, s0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_div_scale_f32 v2, s[0:1], v0, v0, 1.0
; SI-NSZ-NEXT:    v_rcp_f32_e32 v3, v2
; SI-NSZ-NEXT:    v_div_scale_f32 v4, vcc, 1.0, v0, 1.0
; SI-NSZ-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; SI-NSZ-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; SI-NSZ-NEXT:    v_fma_f32 v3, v5, v3, v3
; SI-NSZ-NEXT:    v_mul_f32_e32 v5, v4, v3
; SI-NSZ-NEXT:    v_fma_f32 v6, -v2, v5, v4
; SI-NSZ-NEXT:    v_fma_f32 v5, v6, v3, v5
; SI-NSZ-NEXT:    v_fma_f32 v2, -v2, v5, v4
; SI-NSZ-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; SI-NSZ-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; SI-NSZ-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; SI-NSZ-NEXT:    v_mul_f32_e32 v0, 0x80000000, v0
; SI-NSZ-NEXT:    v_cmp_nlt_f32_e64 vcc, -v0, v1
; SI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; SI-NSZ-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; SI-NSZ-NEXT:    v_cmp_nlt_f32_e32 vcc, 0, v0
; SI-NSZ-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; SI-NSZ-NEXT:    ; return to shader part epilog
;
; VI-SAFE-LABEL: fneg_fadd_0_f16:
; VI-SAFE:       ; %bb.0: ; %.entry
; VI-SAFE-NEXT:    v_rcp_f16_e32 v0, s1
; VI-SAFE-NEXT:    v_mov_b32_e32 v1, s0
; VI-SAFE-NEXT:    v_mul_f16_e32 v0, 0, v0
; VI-SAFE-NEXT:    v_add_f16_e32 v0, 0, v0
; VI-SAFE-NEXT:    v_xor_b32_e32 v2, 0x8000, v0
; VI-SAFE-NEXT:    v_cmp_ngt_f16_e32 vcc, s0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-SAFE-NEXT:    v_mov_b32_e32 v1, 0x7e00
; VI-SAFE-NEXT:    v_cmp_nlt_f16_e32 vcc, 0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; VI-SAFE-NEXT:    ; return to shader part epilog
;
; VI-NSZ-LABEL: fneg_fadd_0_f16:
; VI-NSZ:       ; %bb.0: ; %.entry
; VI-NSZ-NEXT:    v_rcp_f16_e32 v0, s1
; VI-NSZ-NEXT:    v_mov_b32_e32 v1, s0
; VI-NSZ-NEXT:    v_mul_f16_e32 v0, 0x8000, v0
; VI-NSZ-NEXT:    v_cmp_nlt_f16_e64 vcc, -v0, s0
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; VI-NSZ-NEXT:    v_mov_b32_e32 v1, 0x7e00
; VI-NSZ-NEXT:    v_cmp_nlt_f16_e32 vcc, 0, v0
; VI-NSZ-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; VI-NSZ-NEXT:    ; return to shader part epilog
;
; GFX11-SAFE-LABEL: fneg_fadd_0_f16:
; GFX11-SAFE:       ; %bb.0: ; %.entry
; GFX11-SAFE-NEXT:    v_rcp_f16_e32 v0, s1
; GFX11-SAFE-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-SAFE-NEXT:    v_mul_f16_e32 v0, 0, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_add_f16_e32 v0, 0, v0
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v1, 0x8000, v0
; GFX11-SAFE-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, s0, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_cndmask_b32_e64 v0, v1, s0, vcc_lo
; GFX11-SAFE-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, 0, v0
; GFX11-SAFE-NEXT:    v_cndmask_b32_e64 v0, 0x7e00, 0, vcc_lo
; GFX11-SAFE-NEXT:    ; return to shader part epilog
;
; GFX11-NSZ-LABEL: fneg_fadd_0_f16:
; GFX11-NSZ:       ; %bb.0: ; %.entry
; GFX11-NSZ-NEXT:    v_rcp_f16_e32 v0, s1
; GFX11-NSZ-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NSZ-NEXT:    v_mul_f16_e32 v0, 0x8000, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_cmp_nlt_f16_e64 s1, -v0, s0
; GFX11-NSZ-NEXT:    v_cndmask_b32_e64 v0, v0, s0, s1
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, 0, v0
; GFX11-NSZ-NEXT:    v_cndmask_b32_e64 v0, 0x7e00, 0, vcc_lo
; GFX11-NSZ-NEXT:    ; return to shader part epilog
.entry:
  %tmp7 = fdiv half 1.000000e+00, %tmp6
  %tmp8 = fmul half 0.000000e+00, %tmp7
  %tmp9 = fmul reassoc nnan arcp contract half 0.000000e+00, %tmp8
  %.i188 = fadd half %tmp9, 0.000000e+00
  %tmp10 = fcmp uge half %.i188, %tmp2
  %tmp11 = fneg half %.i188
  %.i092 = select i1 %tmp10, half %tmp2, half %tmp11
  %tmp12 = fcmp ule half %.i092, 0.000000e+00
  %.i198 = select i1 %tmp12, half 0.000000e+00, half 0x7FF8000000000000
  ret half %.i198
}

; This is a workaround because -enable-no-signed-zeros-fp-math does not set up
; function attribute unsafe-fp-math automatically. Combine with the previous test
; when that is done.
define amdgpu_ps half @fneg_fadd_0_nsz_f16(half inreg %tmp2, half inreg %tmp6, <4 x i32> %arg) #2 {
; SI-SAFE-LABEL: fneg_fadd_0_nsz_f16:
; SI-SAFE:       ; %bb.0: ; %.entry
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, s0
; SI-SAFE-NEXT:    s_brev_b32 s0, 1
; SI-SAFE-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_min_legacy_f32_e32 v0, 0, v0
; SI-SAFE-NEXT:    v_cmp_ngt_f32_e32 vcc, s0, v0
; SI-SAFE-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; SI-SAFE-NEXT:    ; return to shader part epilog
;
; SI-NSZ-LABEL: fneg_fadd_0_nsz_f16:
; SI-NSZ:       ; %bb.0: ; %.entry
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, s1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, s0
; SI-NSZ-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_rcp_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_mul_f32_e32 v0, 0x80000000, v0
; SI-NSZ-NEXT:    v_cmp_nlt_f32_e64 vcc, -v0, v1
; SI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; SI-NSZ-NEXT:    v_cmp_nlt_f32_e32 vcc, 0, v0
; SI-NSZ-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; SI-NSZ-NEXT:    ; return to shader part epilog
;
; VI-SAFE-LABEL: fneg_fadd_0_nsz_f16:
; VI-SAFE:       ; %bb.0: ; %.entry
; VI-SAFE-NEXT:    v_mov_b32_e32 v0, 0x8000
; VI-SAFE-NEXT:    v_mov_b32_e32 v1, s0
; VI-SAFE-NEXT:    v_cmp_ngt_f16_e64 vcc, s0, 0
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; VI-SAFE-NEXT:    v_mov_b32_e32 v1, 0x7e00
; VI-SAFE-NEXT:    v_cmp_nlt_f16_e32 vcc, 0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; VI-SAFE-NEXT:    ; return to shader part epilog
;
; VI-NSZ-LABEL: fneg_fadd_0_nsz_f16:
; VI-NSZ:       ; %bb.0: ; %.entry
; VI-NSZ-NEXT:    v_rcp_f16_e32 v0, s1
; VI-NSZ-NEXT:    v_mov_b32_e32 v1, s0
; VI-NSZ-NEXT:    v_mul_f16_e32 v0, 0x8000, v0
; VI-NSZ-NEXT:    v_cmp_nlt_f16_e64 vcc, -v0, s0
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; VI-NSZ-NEXT:    v_mov_b32_e32 v1, 0x7e00
; VI-NSZ-NEXT:    v_cmp_nlt_f16_e32 vcc, 0, v0
; VI-NSZ-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; VI-NSZ-NEXT:    ; return to shader part epilog
;
; GFX11-SAFE-LABEL: fneg_fadd_0_nsz_f16:
; GFX11-SAFE:       ; %bb.0: ; %.entry
; GFX11-SAFE-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-SAFE-NEXT:    v_cmp_ngt_f16_e64 vcc_lo, s0, 0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_cndmask_b32_e32 v0, 0x8000, v0, vcc_lo
; GFX11-SAFE-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, 0, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SAFE-NEXT:    v_cndmask_b32_e64 v0, 0x7e00, 0, vcc_lo
; GFX11-SAFE-NEXT:    ; return to shader part epilog
;
; GFX11-NSZ-LABEL: fneg_fadd_0_nsz_f16:
; GFX11-NSZ:       ; %bb.0: ; %.entry
; GFX11-NSZ-NEXT:    v_rcp_f16_e32 v0, s1
; GFX11-NSZ-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NSZ-NEXT:    v_mul_f16_e32 v0, 0x8000, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_cmp_nlt_f16_e64 s1, -v0, s0
; GFX11-NSZ-NEXT:    v_cndmask_b32_e64 v0, v0, s0, s1
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, 0, v0
; GFX11-NSZ-NEXT:    v_cndmask_b32_e64 v0, 0x7e00, 0, vcc_lo
; GFX11-NSZ-NEXT:    ; return to shader part epilog
.entry:
  %tmp7 = fdiv afn half 1.000000e+00, %tmp6
  %tmp8 = fmul half 0.000000e+00, %tmp7
  %tmp9 = fmul reassoc nnan arcp contract half 0.000000e+00, %tmp8
  %.i188 = fadd half %tmp9, 0.000000e+00
  %tmp10 = fcmp uge half %.i188, %tmp2
  %tmp11 = fneg half %.i188
  %.i092 = select i1 %tmp10, half %tmp2, half %tmp11
  %tmp12 = fcmp ule half %.i092, 0.000000e+00
  %.i198 = select i1 %tmp12, half 0.000000e+00, half 0x7FF8000000000000
  ret half %.i198
}

; --------------------------------------------------------------------------------
; fmul tests
; --------------------------------------------------------------------------------

define half @v_fneg_mul_f16(half %a, half %b) #0 {
; SI-LABEL: v_fneg_mul_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e64 v1, -v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_mul_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e64 v0, v0, -v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_mul_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e64 v0, v0, -v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %a, %b
  %fneg = fneg half %mul
  ret half %fneg
}

define { half, half } @v_fneg_mul_store_use_mul_f16(half %a, half %b) #0 {
; SI-LABEL: v_fneg_mul_store_use_mul_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v1, v0, v1
; SI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_mul_store_use_mul_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e32 v1, v0, v1
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_mul_store_use_mul_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e32 v1, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x8000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %a, %b
  %fneg = fneg half %mul
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %mul, 1
  ret { half, half } %insert.1
}

define { half, half } @v_fneg_mul_multi_use_mul_f16(half %a, half %b) #0 {
; SI-LABEL: v_fneg_mul_multi_use_mul_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e64 v1, -v1
; SI-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_mul_multi_use_mul_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e64 v0, v0, -v1
; VI-NEXT:    v_mul_f16_e32 v1, -4.0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_mul_multi_use_mul_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e64 v0, v0, -v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f16_e32 v1, -4.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %a, %b
  %fneg = fneg half %mul
  %use1 = fmul half %mul, 4.0
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %use1, 1
  ret { half, half } %insert.1
}

define half @v_fneg_mul_fneg_x_f16(half %a, half %b) #0 {
; SI-LABEL: v_fneg_mul_fneg_x_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_mul_fneg_x_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_mul_fneg_x_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %mul = fmul half %fneg.a, %b
  %fneg = fneg half %mul
  ret half %fneg
}

define half @v_fneg_mul_x_fneg_f16(half %a, half %b) #0 {
; SI-LABEL: v_fneg_mul_x_fneg_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_mul_x_fneg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_mul_x_fneg_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg.b = fneg half %b
  %mul = fmul half %a, %fneg.b
  %fneg = fneg half %mul
  ret half %fneg
}

define half @v_fneg_mul_fneg_fneg_f16(half %a, half %b) #0 {
; SI-LABEL: v_fneg_mul_fneg_fneg_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e64 v1, -v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_mul_fneg_fneg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e64 v0, v0, -v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_mul_fneg_fneg_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e64 v0, v0, -v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %fneg.b = fneg half %b
  %mul = fmul half %fneg.a, %fneg.b
  %fneg = fneg half %mul
  ret half %fneg
}

define { half, half } @v_fneg_mul_store_use_fneg_x_f16(half %a, half %b) #0 {
; SI-LABEL: v_fneg_mul_store_use_fneg_x_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_cvt_f32_f16_e64 v1, -v0
; SI-NEXT:    v_mul_f32_e32 v0, v3, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_mul_store_use_fneg_x_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v2, 0x8000, v0
; VI-NEXT:    v_mul_f16_e32 v0, v0, v1
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_mul_store_use_fneg_x_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e32 v2, v0, v1
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x8000, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %mul = fmul half %fneg.a, %b
  %fneg = fneg half %mul
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %fneg.a, 1
  ret { half, half } %insert.1
}

define { half, half } @v_fneg_mul_multi_use_fneg_x_f16(half %a, half %b, half %c) #0 {
; SI-LABEL: v_fneg_mul_multi_use_fneg_x_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_cvt_f32_f16_e64 v4, -v0
; SI-NEXT:    v_mul_f32_e32 v0, v3, v1
; SI-NEXT:    v_mul_f32_e32 v1, v4, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_mul_multi_use_fneg_x_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e32 v3, v0, v1
; VI-NEXT:    v_mul_f16_e64 v1, -v0, v2
; VI-NEXT:    v_mov_b32_e32 v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_mul_multi_use_fneg_x_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e32 v3, v0, v1
; GFX11-NEXT:    v_mul_f16_e64 v1, -v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %mul = fmul half %fneg.a, %b
  %fneg = fneg half %mul
  %use1 = fmul half %fneg.a, %c
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %use1, 1
  ret { half, half } %insert.1
}

; --------------------------------------------------------------------------------
; fminnum tests
; --------------------------------------------------------------------------------

define half @v_fneg_minnum_f16_ieee(half %a, half %b) #0 {
; SI-LABEL: v_fneg_minnum_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v1, -v1
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_max_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_minnum_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v1, -v1, -v1
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v0
; VI-NEXT:    v_max_f16_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_minnum_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v1, -v1, -v1
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half %a, half %b)
  %fneg = fneg half %min
  ret half %fneg
}

define half @v_fneg_minnum_f16_no_ieee(half %a, half %b) #4 {
; SI-LABEL: v_fneg_minnum_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v1, -v1
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_max_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_minnum_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_minnum_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half %a, half %b)
  %fneg = fneg half %min
  ret half %fneg
}

define half @v_fneg_self_minnum_f16_ieee(half %a) #0 {
; SI-LABEL: v_fneg_self_minnum_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_self_minnum_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_self_minnum_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half %a, half %a)
  %min.fneg = fneg half %min
  ret half %min.fneg
}

define half @v_fneg_self_minnum_f16_no_ieee(half %a) #4 {
; SI-LABEL: v_fneg_self_minnum_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_self_minnum_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_self_minnum_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half %a, half %a)
  %min.fneg = fneg half %min
  ret half %min.fneg
}

define half @v_fneg_posk_minnum_f16_ieee(half %a) #0 {
; SI-LABEL: v_fneg_posk_minnum_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_max_f32_e32 v0, -4.0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_posk_minnum_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v0
; VI-NEXT:    v_max_f16_e32 v0, -4.0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_posk_minnum_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, -4.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half 4.0, half %a)
  %fneg = fneg half %min
  ret half %fneg
}

define half @v_fneg_posk_minnum_f16_no_ieee(half %a) #4 {
; SI-LABEL: v_fneg_posk_minnum_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_max_f32_e32 v0, -4.0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_posk_minnum_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, -4.0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_posk_minnum_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -4.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half 4.0, half %a)
  %fneg = fneg half %min
  ret half %fneg
}

define half @v_fneg_negk_minnum_f16_ieee(half %a) #0 {
; SI-LABEL: v_fneg_negk_minnum_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_max_f32_e32 v0, 4.0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_negk_minnum_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v0
; VI-NEXT:    v_max_f16_e32 v0, 4.0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_negk_minnum_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, 4.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half -4.0, half %a)
  %fneg = fneg half %min
  ret half %fneg
}

define half @v_fneg_negk_minnum_f16_no_ieee(half %a) #4 {
; SI-LABEL: v_fneg_negk_minnum_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_max_f32_e32 v0, 4.0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_negk_minnum_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, 4.0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_negk_minnum_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, 4.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half -4.0, half %a)
  %fneg = fneg half %min
  ret half %fneg
}

define half @v_fneg_0_minnum_f16(half %a) #0 {
; SI-LABEL: v_fneg_0_minnum_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_min_f32_e32 v0, 0, v0
; SI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_0_minnum_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_min_f16_e32 v0, 0, v0
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_0_minnum_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f16_e32 v0, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call nnan half @llvm.minnum.f16(half 0.0, half %a)
  %fneg = fneg half %min
  ret half %fneg
}

define half @v_fneg_neg0_minnum_f16_ieee(half %a) #0 {
; SI-LABEL: v_fneg_neg0_minnum_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_max_f32_e32 v0, 0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_neg0_minnum_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v0
; VI-NEXT:    v_max_f16_e32 v0, 0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_neg0_minnum_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, 0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half -0.0, half %a)
  %fneg = fneg half %min
  ret half %fneg
}

define half @v_fneg_inv2pi_minnum_f16(half %a) #0 {
; SI-LABEL: v_fneg_inv2pi_minnum_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_max_f32_e32 v0, 0xbe230000, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_inv2pi_minnum_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e32 v0, v0, v0
; VI-NEXT:    v_min_f16_e32 v0, 0.15915494, v0
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_inv2pi_minnum_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_min_f16_e32 v0, 0.15915494, v0
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half 0xH3118, half %a)
  %fneg = fneg half %min
  ret half %fneg
}

define half @v_fneg_neg_inv2pi_minnum_f16(half %a) #0 {
; SI-LABEL: v_fneg_neg_inv2pi_minnum_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_max_f32_e32 v0, 0xbe230000, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_neg_inv2pi_minnum_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e32 v0, v0, v0
; VI-NEXT:    v_min_f16_e32 v0, 0.15915494, v0
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_neg_inv2pi_minnum_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_min_f16_e32 v0, 0.15915494, v0
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half 0xH3118, half %a)
  %fneg = fneg half %min
  ret half %fneg
}

define half @v_fneg_neg0_minnum_f16_no_ieee(half %a) #4 {
; SI-LABEL: v_fneg_neg0_minnum_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_max_f32_e32 v0, 0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_neg0_minnum_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, 0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_neg0_minnum_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, 0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half -0.0, half %a)
  %fneg = fneg half %min
  ret half %fneg
}

define half @v_fneg_0_minnum_foldable_use_f16_ieee(half %a, half %b) #0 {
; SI-LABEL: v_fneg_0_minnum_foldable_use_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_min_f32_e32 v0, 0, v0
; SI-NEXT:    v_mul_f32_e64 v0, -v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_0_minnum_foldable_use_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e32 v0, v0, v0
; VI-NEXT:    v_min_f16_e32 v0, 0, v0
; VI-NEXT:    v_mul_f16_e64 v0, -v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_0_minnum_foldable_use_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_min_f16_e32 v0, 0, v0
; GFX11-NEXT:    v_mul_f16_e64 v0, -v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half 0.0, half %a)
  %fneg = fneg half %min
  %mul = fmul half %fneg, %b
  ret half %mul
}

define half @v_fneg_inv2pi_minnum_foldable_use_f16(half %a, half %b) #0 {
; SI-LABEL: v_fneg_inv2pi_minnum_foldable_use_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_max_f32_e32 v0, 0xbe230000, v0
; SI-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_inv2pi_minnum_foldable_use_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e32 v0, v0, v0
; VI-NEXT:    v_min_f16_e32 v0, 0.15915494, v0
; VI-NEXT:    v_mul_f16_e64 v0, -v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_inv2pi_minnum_foldable_use_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_min_f16_e32 v0, 0.15915494, v0
; GFX11-NEXT:    v_mul_f16_e64 v0, -v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half 0xH3118, half %a)
  %fneg = fneg half %min
  %mul = fmul half %fneg, %b
  ret half %mul
}

define half @v_fneg_0_minnum_foldable_use_f16_no_ieee(half %a, half %b) #4 {
; SI-LABEL: v_fneg_0_minnum_foldable_use_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_min_f32_e32 v0, 0, v0
; SI-NEXT:    v_mul_f32_e64 v0, -v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_0_minnum_foldable_use_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_min_f16_e32 v0, 0, v0
; VI-NEXT:    v_mul_f16_e64 v0, -v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_0_minnum_foldable_use_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f16_e32 v0, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f16_e64 v0, -v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half 0.0, half %a)
  %fneg = fneg half %min
  %mul = fmul half %fneg, %b
  ret half %mul
}

define { half, half } @v_fneg_minnum_multi_use_minnum_f16_ieee(half %a, half %b) #0 {
; SI-LABEL: v_fneg_minnum_multi_use_minnum_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e64 v1, -v1
; SI-NEXT:    v_cvt_f32_f16_e64 v0, -v0
; SI-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_max_f32_e32 v0, v0, v1
; SI-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_minnum_multi_use_minnum_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v1, -v1, -v1
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v0
; VI-NEXT:    v_max_f16_e32 v0, v0, v1
; VI-NEXT:    v_mul_f16_e32 v1, -4.0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_minnum_multi_use_minnum_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v1, -v1, -v1
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    v_mul_f16_e32 v1, -4.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half %a, half %b)
  %fneg = fneg half %min
  %use1 = fmul half %min, 4.0
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %use1, 1
  ret { half, half } %insert.1
}

define <2 x half> @v_fneg_minnum_multi_use_minnum_f16_no_ieee(half %a, half %b) #4 {
; SI-LABEL: v_fneg_minnum_multi_use_minnum_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e64 v1, -v1
; SI-NEXT:    v_cvt_f32_f16_e64 v0, -v0
; SI-NEXT:    v_max_f32_e32 v0, v0, v1
; SI-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_minnum_multi_use_minnum_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v1
; VI-NEXT:    v_mov_b32_e32 v1, 0xc400
; VI-NEXT:    v_mul_f16_sdwa v1, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_minnum_multi_use_minnum_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f16_e32 v1, 4.0, v0
; GFX11-NEXT:    v_pack_b32_f16 v0, -v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half %a, half %b)
  %fneg = fneg half %min
  %use1 = fmul half %min, 4.0
  %ins0 = insertelement <2 x half> undef, half %fneg, i32 0
  %ins1 = insertelement <2 x half> %ins0, half %use1, i32 1
  ret <2 x half> %ins1
}

; --------------------------------------------------------------------------------
; fmaxnum tests
; --------------------------------------------------------------------------------

define half @v_fneg_maxnum_f16_ieee(half %a, half %b) #0 {
; SI-LABEL: v_fneg_maxnum_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v1, -v1
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_min_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_maxnum_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v1, -v1, -v1
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v0
; VI-NEXT:    v_min_f16_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_maxnum_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v1, -v1, -v1
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_min_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half %a, half %b)
  %fneg = fneg half %max
  ret half %fneg
}

define half @v_fneg_maxnum_f16_no_ieee(half %a, half %b) #4 {
; SI-LABEL: v_fneg_maxnum_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v1, -v1
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_min_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_maxnum_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_min_f16_e64 v0, -v0, -v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_maxnum_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f16_e64 v0, -v0, -v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half %a, half %b)
  %fneg = fneg half %max
  ret half %fneg
}

define half @v_fneg_self_maxnum_f16_ieee(half %a) #0 {
; SI-LABEL: v_fneg_self_maxnum_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_self_maxnum_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_self_maxnum_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half %a, half %a)
  %max.fneg = fneg half %max
  ret half %max.fneg
}

define half @v_fneg_self_maxnum_f16_no_ieee(half %a) #4 {
; SI-LABEL: v_fneg_self_maxnum_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_self_maxnum_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_self_maxnum_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half %a, half %a)
  %max.fneg = fneg half %max
  ret half %max.fneg
}

define half @v_fneg_posk_maxnum_f16_ieee(half %a) #0 {
; SI-LABEL: v_fneg_posk_maxnum_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_min_f32_e32 v0, -4.0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_posk_maxnum_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v0
; VI-NEXT:    v_min_f16_e32 v0, -4.0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_posk_maxnum_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_min_f16_e32 v0, -4.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half 4.0, half %a)
  %fneg = fneg half %max
  ret half %fneg
}

define half @v_fneg_posk_maxnum_f16_no_ieee(half %a) #4 {
; SI-LABEL: v_fneg_posk_maxnum_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_min_f32_e32 v0, -4.0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_posk_maxnum_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_min_f16_e64 v0, -v0, -4.0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_posk_maxnum_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f16_e64 v0, -v0, -4.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half 4.0, half %a)
  %fneg = fneg half %max
  ret half %fneg
}

define half @v_fneg_negk_maxnum_f16_ieee(half %a) #0 {
; SI-LABEL: v_fneg_negk_maxnum_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_min_f32_e32 v0, 4.0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_negk_maxnum_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v0
; VI-NEXT:    v_min_f16_e32 v0, 4.0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_negk_maxnum_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_min_f16_e32 v0, 4.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half -4.0, half %a)
  %fneg = fneg half %max
  ret half %fneg
}

define half @v_fneg_negk_maxnum_f16_no_ieee(half %a) #4 {
; SI-LABEL: v_fneg_negk_maxnum_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_min_f32_e32 v0, 4.0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_negk_maxnum_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_min_f16_e64 v0, -v0, 4.0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_negk_maxnum_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f16_e64 v0, -v0, 4.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half -4.0, half %a)
  %fneg = fneg half %max
  ret half %fneg
}

define half @v_fneg_0_maxnum_f16(half %a) #0 {
; SI-LABEL: v_fneg_0_maxnum_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_max_f32_e32 v0, 0, v0
; SI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_0_maxnum_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e32 v0, 0, v0
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_0_maxnum_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call nnan half @llvm.maxnum.f16(half 0.0, half %a)
  %fneg = fneg half %max
  ret half %fneg
}

define half @v_fneg_neg0_maxnum_f16_ieee(half %a) #0 {
; SI-LABEL: v_fneg_neg0_maxnum_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_min_f32_e32 v0, 0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_neg0_maxnum_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v0
; VI-NEXT:    v_min_f16_e32 v0, 0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_neg0_maxnum_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_min_f16_e32 v0, 0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half -0.0, half %a)
  %fneg = fneg half %max
  ret half %fneg
}

define half @v_fneg_neg0_maxnum_f16_no_ieee(half %a) #4 {
; SI-LABEL: v_fneg_neg0_maxnum_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_min_f32_e32 v0, 0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_neg0_maxnum_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_min_f16_e64 v0, -v0, 0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_neg0_maxnum_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f16_e64 v0, -v0, 0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half -0.0, half %a)
  %fneg = fneg half %max
  ret half %fneg
}

define half @v_fneg_0_maxnum_foldable_use_f16_ieee(half %a, half %b) #0 {
; SI-LABEL: v_fneg_0_maxnum_foldable_use_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_max_f32_e32 v0, 0, v0
; SI-NEXT:    v_mul_f32_e64 v0, -v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_0_maxnum_foldable_use_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e32 v0, v0, v0
; VI-NEXT:    v_max_f16_e32 v0, 0, v0
; VI-NEXT:    v_mul_f16_e64 v0, -v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_0_maxnum_foldable_use_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, 0, v0
; GFX11-NEXT:    v_mul_f16_e64 v0, -v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half 0.0, half %a)
  %fneg = fneg half %max
  %mul = fmul half %fneg, %b
  ret half %mul
}

define half @v_fneg_0_maxnum_foldable_use_f16_no_ieee(half %a, half %b) #4 {
; SI-LABEL: v_fneg_0_maxnum_foldable_use_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_max_f32_e32 v0, 0, v0
; SI-NEXT:    v_mul_f32_e64 v0, -v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_0_maxnum_foldable_use_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e32 v0, 0, v0
; VI-NEXT:    v_mul_f16_e64 v0, -v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_0_maxnum_foldable_use_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f16_e64 v0, -v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half 0.0, half %a)
  %fneg = fneg half %max
  %mul = fmul half %fneg, %b
  ret half %mul
}

define { half, half } @v_fneg_maxnum_multi_use_maxnum_f16_ieee(half %a, half %b) #0 {
; SI-LABEL: v_fneg_maxnum_multi_use_maxnum_f16_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e64 v1, -v1
; SI-NEXT:    v_cvt_f32_f16_e64 v0, -v0
; SI-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_min_f32_e32 v0, v0, v1
; SI-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_maxnum_multi_use_maxnum_f16_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v1, -v1, -v1
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v0
; VI-NEXT:    v_min_f16_e32 v0, v0, v1
; VI-NEXT:    v_mul_f16_e32 v1, -4.0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_maxnum_multi_use_maxnum_f16_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v1, -v1, -v1
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_min_f16_e32 v0, v0, v1
; GFX11-NEXT:    v_mul_f16_e32 v1, -4.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half %a, half %b)
  %fneg = fneg half %max
  %use1 = fmul half %max, 4.0
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %use1, 1
  ret { half, half } %insert.1
}

define <2 x half> @v_fneg_maxnum_multi_use_maxnum_f16_no_ieee(half %a, half %b) #4 {
; SI-LABEL: v_fneg_maxnum_multi_use_maxnum_f16_no_ieee:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e64 v1, -v1
; SI-NEXT:    v_cvt_f32_f16_e64 v0, -v0
; SI-NEXT:    v_min_f32_e32 v0, v0, v1
; SI-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_maxnum_multi_use_maxnum_f16_no_ieee:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_min_f16_e64 v0, -v0, -v1
; VI-NEXT:    v_mov_b32_e32 v1, 0xc400
; VI-NEXT:    v_mul_f16_sdwa v1, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_maxnum_multi_use_maxnum_f16_no_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f16_e32 v1, 4.0, v0
; GFX11-NEXT:    v_pack_b32_f16 v0, -v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %max = call half @llvm.maxnum.f16(half %a, half %b)
  %fneg = fneg half %max
  %use1 = fmul half %max, 4.0
  %ins0 = insertelement <2 x half> undef, half %fneg, i32 0
  %ins1 = insertelement <2 x half> %ins0, half %use1, i32 1
  ret <2 x half> %ins1
}

; --------------------------------------------------------------------------------
; fma tests
; --------------------------------------------------------------------------------

define half @v_fneg_fma_f16(half %a, half %b, half %c) #0 {
; SI-SAFE-LABEL: v_fneg_fma_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_fma_f32 v0, v0, v1, v2
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_fma_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_fma_f32 v0, v0, -v1, -v2
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_fma_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_fma_f16 v0, v0, v1, v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_fma_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_fma_f16 v0, v0, -v1, -v2
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_fma_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fmac_f16_e32 v2, v0, v1
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v2
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_fma_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v0, v0, -v1, -v2
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fma = call half @llvm.fma.f16(half %a, half %b, half %c)
  %fneg = fneg half %fma
  ret half %fneg
}

define { half, half } @v_fneg_fma_store_use_fma_f16(half %a, half %b, half %c) #0 {
; SI-LABEL: v_fneg_fma_store_use_fma_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_fma_f32 v1, v0, v1, v2
; SI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_fma_store_use_fma_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_fma_f16 v1, v0, v1, v2
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_fma_store_use_fma_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_fma_f16 v1, v0, v1, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x8000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fma = call half @llvm.fma.f16(half %a, half %b, half %c)
  %fneg = fneg half %fma
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %fma, 1
  ret { half, half } %insert.1
}

define { half, half } @v_fneg_fma_multi_use_fma_f16(half %a, half %b, half %c) #0 {
; SI-SAFE-LABEL: v_fneg_fma_multi_use_fma_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_fma_f32 v1, v0, v1, v2
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; SI-SAFE-NEXT:    v_mul_f32_e32 v1, 4.0, v1
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_fma_multi_use_fma_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_fma_f32 v0, v0, -v1, -v2
; SI-NSZ-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_fma_multi_use_fma_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_fma_f16 v1, v0, v1, v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v1
; VI-SAFE-NEXT:    v_mul_f16_e32 v1, 4.0, v1
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_fma_multi_use_fma_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_fma_f16 v0, v0, -v1, -v2
; VI-NSZ-NEXT:    v_mul_f16_e32 v1, -4.0, v0
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_fma_multi_use_fma_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fmac_f16_e32 v2, v0, v1
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v2
; GFX11-SAFE-NEXT:    v_mul_f16_e32 v1, 4.0, v2
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_fma_multi_use_fma_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v0, v0, -v1, -v2
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_mul_f16_e32 v1, -4.0, v0
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fma = call half @llvm.fma.f16(half %a, half %b, half %c)
  %fneg = fneg half %fma
  %use1 = fmul half %fma, 4.0
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %use1, 1
  ret { half, half } %insert.1
}

define half @v_fneg_fma_fneg_x_y_f16(half %a, half %b, half %c) #0 {
; SI-SAFE-LABEL: v_fneg_fma_fneg_x_y_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_fma_f32 v0, -v0, v1, v2
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_fma_fneg_x_y_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_fma_f32 v0, v0, v1, -v2
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_fma_fneg_x_y_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_fma_f16 v0, -v0, v1, v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_fma_fneg_x_y_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_fma_f16 v0, v0, v1, -v2
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_fma_fneg_x_y_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fma_f16 v0, -v0, v1, v2
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_fma_fneg_x_y_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v0, v0, v1, -v2
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %fma = call half @llvm.fma.f16(half %fneg.a, half %b, half %c)
  %fneg = fneg half %fma
  ret half %fneg
}

define half @v_fneg_fma_x_fneg_y_f16(half %a, half %b, half %c) #0 {
; SI-SAFE-LABEL: v_fneg_fma_x_fneg_y_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_fma_f32 v0, v0, -v1, v2
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_fma_x_fneg_y_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_fma_f32 v0, v0, v1, -v2
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_fma_x_fneg_y_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_fma_f16 v0, v0, -v1, v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_fma_x_fneg_y_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_fma_f16 v0, v0, v1, -v2
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_fma_x_fneg_y_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fma_f16 v0, v0, -v1, v2
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_fma_x_fneg_y_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v0, v0, v1, -v2
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.b = fneg half %b
  %fma = call half @llvm.fma.f16(half %a, half %fneg.b, half %c)
  %fneg = fneg half %fma
  ret half %fneg
}

define half @v_fneg_fma_fneg_fneg_y_f16(half %a, half %b, half %c) #0 {
; SI-SAFE-LABEL: v_fneg_fma_fneg_fneg_y_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_fma_f32 v0, v0, v1, v2
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_fma_fneg_fneg_y_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_fma_f32 v0, v0, -v1, -v2
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_fma_fneg_fneg_y_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_fma_f16 v0, v0, v1, v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_fma_fneg_fneg_y_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_fma_f16 v0, v0, -v1, -v2
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_fma_fneg_fneg_y_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fmac_f16_e32 v2, v0, v1
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v2
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_fma_fneg_fneg_y_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v0, v0, -v1, -v2
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %fneg.b = fneg half %b
  %fma = call half @llvm.fma.f16(half %fneg.a, half %fneg.b, half %c)
  %fneg = fneg half %fma
  ret half %fneg
}

define half @v_fneg_fma_fneg_x_fneg_f16(half %a, half %b, half %c) #0 {
; SI-SAFE-LABEL: v_fneg_fma_fneg_x_fneg_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_fma_f32 v0, -v0, v1, -v2
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_fma_fneg_x_fneg_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_fma_f32 v0, v0, v1, v2
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_fma_fneg_x_fneg_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_fma_f16 v0, -v0, v1, -v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_fma_fneg_x_fneg_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_fma_f16 v0, v0, v1, v2
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_fma_fneg_x_fneg_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fma_f16 v0, -v0, v1, -v2
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_fma_fneg_x_fneg_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v0, v0, v1, v2
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %fneg.c = fneg half %c
  %fma = call half @llvm.fma.f16(half %fneg.a, half %b, half %fneg.c)
  %fneg = fneg half %fma
  ret half %fneg
}

define half @v_fneg_fma_x_y_fneg_f16(half %a, half %b, half %c) #0 {
; SI-SAFE-LABEL: v_fneg_fma_x_y_fneg_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_fma_f32 v0, v0, v1, -v2
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_fma_x_y_fneg_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_fma_f32 v0, v0, -v1, v2
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_fma_x_y_fneg_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_fma_f16 v0, v0, v1, -v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_fma_x_y_fneg_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_fma_f16 v0, v0, -v1, v2
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_fma_x_y_fneg_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fma_f16 v0, v0, v1, -v2
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_fma_x_y_fneg_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v0, v0, -v1, v2
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.c = fneg half %c
  %fma = call half @llvm.fma.f16(half %a, half %b, half %fneg.c)
  %fneg = fneg half %fma
  ret half %fneg
}

define { half, half } @v_fneg_fma_store_use_fneg_x_y_f16(half %a, half %b, half %c) #0 {
; SI-SAFE-LABEL: v_fneg_fma_store_use_fneg_x_y_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e64 v3, -v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v4, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-SAFE-NEXT:    v_xor_b32_e32 v1, 0x80000000, v0
; SI-SAFE-NEXT:    v_fma_f32 v0, v3, v4, v2
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_fma_store_use_fneg_x_y_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v3, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v4, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e64 v1, -v0
; SI-NSZ-NEXT:    v_fma_f32 v0, v4, v3, -v2
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_fma_store_use_fneg_x_y_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_xor_b32_e32 v3, 0x8000, v0
; VI-SAFE-NEXT:    v_fma_f16 v0, -v0, v1, v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    v_mov_b32_e32 v1, v3
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_fma_store_use_fneg_x_y_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_xor_b32_e32 v3, 0x8000, v0
; VI-NSZ-NEXT:    v_fma_f16 v0, v0, v1, -v2
; VI-NSZ-NEXT:    v_mov_b32_e32 v1, v3
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_fma_store_use_fneg_x_y_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fma_f16 v1, -v0, v1, v2
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v2, 0x8000, v1
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v1, 0x8000, v0
; GFX11-SAFE-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_fma_store_use_fneg_x_y_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v2, v0, v1, -v2
; GFX11-NSZ-NEXT:    v_xor_b32_e32 v1, 0x8000, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NSZ-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %fma = call half @llvm.fma.f16(half %fneg.a, half %b, half %c)
  %fneg = fneg half %fma
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %fneg.a, 1
  ret { half, half } %insert.1
}

define { half, half } @v_fneg_fma_multi_use_fneg_x_y_f16(half %a, half %b, half %c, half %d) #0 {
; SI-SAFE-LABEL: v_fneg_fma_multi_use_fneg_x_y_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v4, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-SAFE-NEXT:    v_fma_f32 v0, v4, v1, v2
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    v_mul_f32_e32 v1, v4, v3
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_fma_multi_use_fneg_x_y_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v4, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e64 v5, -v0
; SI-NSZ-NEXT:    v_fma_f32 v0, v4, v1, -v2
; SI-NSZ-NEXT:    v_mul_f32_e32 v1, v5, v3
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_fma_multi_use_fneg_x_y_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_fma_f16 v1, -v0, v1, v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v2, 0x8000, v1
; VI-SAFE-NEXT:    v_mul_f16_e64 v1, -v0, v3
; VI-SAFE-NEXT:    v_mov_b32_e32 v0, v2
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_fma_multi_use_fneg_x_y_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_fma_f16 v2, v0, v1, -v2
; VI-NSZ-NEXT:    v_mul_f16_e64 v1, -v0, v3
; VI-NSZ-NEXT:    v_mov_b32_e32 v0, v2
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_fma_multi_use_fneg_x_y_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fma_f16 v1, -v0, v1, v2
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v2, 0x8000, v1
; GFX11-SAFE-NEXT:    v_mul_f16_e64 v1, -v0, v3
; GFX11-SAFE-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_fma_multi_use_fneg_x_y_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v2, v0, v1, -v2
; GFX11-NSZ-NEXT:    v_mul_f16_e64 v1, -v0, v3
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NSZ-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %fma = call half @llvm.fma.f16(half %fneg.a, half %b, half %c)
  %fneg = fneg half %fma
  %use1 = fmul half %fneg.a, %d
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %use1, 1
  ret { half, half } %insert.1
}

; --------------------------------------------------------------------------------
; fmad tests
; --------------------------------------------------------------------------------

define half @v_fneg_fmad_f16(half %a, half %b, half %c) #0 {
; SI-SAFE-LABEL: v_fneg_fmad_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_mac_f32_e32 v2, v0, v1
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v2
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_fmad_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f16_f32_e64 v1, -v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_mad_f32 v0, v0, v1, -v2
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_fmad_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_fma_f16 v0, v0, v1, v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_fmad_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_fma_f16 v0, v0, -v1, -v2
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_fmad_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fmac_f16_e32 v2, v0, v1
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v2
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_fmad_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v0, v0, -v1, -v2
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fma = call half @llvm.fmuladd.f16(half %a, half %b, half %c)
  %fneg = fneg half %fma
  ret half %fneg
}

define <4 x half> @v_fneg_fmad_v4f32(<4 x half> %a, <4 x half> %b, <4 x half> %c) #0 {
; SI-SAFE-LABEL: v_fneg_fmad_v4f32:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_mac_f32_e32 v11, v3, v7
; SI-SAFE-NEXT:    v_mac_f32_e32 v10, v2, v6
; SI-SAFE-NEXT:    v_mac_f32_e32 v9, v1, v5
; SI-SAFE-NEXT:    v_mac_f32_e32 v8, v0, v4
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v8
; SI-SAFE-NEXT:    v_xor_b32_e32 v1, 0x80000000, v9
; SI-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80000000, v10
; SI-SAFE-NEXT:    v_xor_b32_e32 v3, 0x80000000, v11
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_fmad_v4f32:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e64 v4, -v4
; SI-NSZ-NEXT:    v_cvt_f32_f16_e64 v5, -v5
; SI-NSZ-NEXT:    v_cvt_f32_f16_e64 v6, -v6
; SI-NSZ-NEXT:    v_cvt_f32_f16_e64 v7, -v7
; SI-NSZ-NEXT:    v_mad_f32 v0, v0, v4, -v8
; SI-NSZ-NEXT:    v_mad_f32 v1, v1, v5, -v9
; SI-NSZ-NEXT:    v_mad_f32 v2, v2, v6, -v10
; SI-NSZ-NEXT:    v_mad_f32 v3, v3, v7, -v11
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_fmad_v4f32:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v6, 16, v5
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; VI-SAFE-NEXT:    v_fma_f16 v6, v8, v7, v6
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v9, 16, v0
; VI-SAFE-NEXT:    v_fma_f16 v7, v9, v8, v7
; VI-SAFE-NEXT:    v_fma_f16 v0, v0, v2, v4
; VI-SAFE-NEXT:    v_lshlrev_b32_e32 v2, 16, v7
; VI-SAFE-NEXT:    v_fma_f16 v1, v1, v3, v5
; VI-SAFE-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-SAFE-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; VI-SAFE-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; VI-SAFE-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_fmad_v4f32:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_lshrrev_b32_e32 v6, 16, v5
; VI-NSZ-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; VI-NSZ-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; VI-NSZ-NEXT:    v_fma_f16 v6, v8, -v7, -v6
; VI-NSZ-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; VI-NSZ-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; VI-NSZ-NEXT:    v_lshrrev_b32_e32 v9, 16, v0
; VI-NSZ-NEXT:    v_fma_f16 v7, v9, -v8, -v7
; VI-NSZ-NEXT:    v_fma_f16 v0, v0, -v2, -v4
; VI-NSZ-NEXT:    v_lshlrev_b32_e32 v2, 16, v7
; VI-NSZ-NEXT:    v_fma_f16 v1, v1, -v3, -v5
; VI-NSZ-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NSZ-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; VI-NSZ-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_fmad_v4f32:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_pk_fma_f16 v0, v0, v2, v4
; GFX11-SAFE-NEXT:    v_pk_fma_f16 v1, v1, v3, v5
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_fmad_v4f32:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_pk_fma_f16 v0, v0, v2, v4 neg_lo:[0,1,1] neg_hi:[0,1,1]
; GFX11-NSZ-NEXT:    v_pk_fma_f16 v1, v1, v3, v5 neg_lo:[0,1,1] neg_hi:[0,1,1]
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fma = call <4 x half> @llvm.fmuladd.v4f16(<4 x half> %a, <4 x half> %b, <4 x half> %c)
  %fneg = fneg <4 x half> %fma
  ret <4 x half> %fneg
}

define { half, half } @v_fneg_fmad_multi_use_fmad_f16(half %a, half %b, half %c) #0 {
; SI-SAFE-LABEL: v_fneg_fmad_multi_use_fmad_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_mac_f32_e32 v2, v0, v1
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v2
; SI-SAFE-NEXT:    v_mul_f32_e32 v1, 4.0, v2
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_fmad_multi_use_fmad_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e64 v1, -v1
; SI-NSZ-NEXT:    v_mad_f32 v0, v0, v1, -v2
; SI-NSZ-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_fmad_multi_use_fmad_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_fma_f16 v1, v0, v1, v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v1
; VI-SAFE-NEXT:    v_mul_f16_e32 v1, 4.0, v1
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_fmad_multi_use_fmad_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_fma_f16 v0, v0, -v1, -v2
; VI-NSZ-NEXT:    v_mul_f16_e32 v1, -4.0, v0
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_fmad_multi_use_fmad_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fmac_f16_e32 v2, v0, v1
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v2
; GFX11-SAFE-NEXT:    v_mul_f16_e32 v1, 4.0, v2
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_fmad_multi_use_fmad_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v0, v0, -v1, -v2
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_mul_f16_e32 v1, -4.0, v0
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fma = call half @llvm.fmuladd.f16(half %a, half %b, half %c)
  %fneg = fneg half %fma
  %use1 = fmul half %fma, 4.0
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %use1, 1
  ret { half, half } %insert.1
}

; --------------------------------------------------------------------------------
; fp_extend tests
; --------------------------------------------------------------------------------

define double @v_fneg_fp_extend_f16_to_f64(half %a) #0 {
; SI-LABEL: v_fneg_fp_extend_f16_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f64_f32_e64 v[0:1], -v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_fp_extend_f16_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_fp_extend_f16_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fpext = fpext half %a to double
  %fneg = fneg double %fpext
  ret double %fneg
}

define double @v_fneg_fp_extend_fneg_f16_to_f64(half %a) #0 {
; SI-LABEL: v_fneg_fp_extend_fneg_f16_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_fp_extend_fneg_f16_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_fp_extend_fneg_f16_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %fpext = fpext half %fneg.a to double
  %fneg = fneg double %fpext
  ret double %fneg
}

define { double, half } @v_fneg_fp_extend_store_use_fneg_f16_to_f64(half %a) #0 {
; SI-LABEL: v_fneg_fp_extend_store_use_fneg_f16_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    v_cvt_f64_f32_e32 v[0:1], v2
; SI-NEXT:    v_xor_b32_e32 v2, 0x80000000, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_fp_extend_store_use_fneg_f16_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v2
; VI-NEXT:    v_xor_b32_e32 v2, 0x8000, v2
; VI-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_fp_extend_store_use_fneg_f16_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cvt_f32_f16_e32 v0, v2
; GFX11-NEXT:    v_xor_b32_e32 v2, 0x8000, v2
; GFX11-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %fpext = fpext half %fneg.a to double
  %fneg = fneg double %fpext
  %insert.0 = insertvalue { double, half } poison, double %fneg, 0
  %insert.1 = insertvalue { double, half } %insert.0, half %fneg.a, 1
  ret { double, half } %insert.1
}

define { double, double } @v_fneg_multi_use_fp_extend_fneg_f16_to_f64(half %a) #0 {
; SI-LABEL: v_fneg_multi_use_fp_extend_fneg_f16_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f64_f32_e32 v[2:3], v0
; SI-NEXT:    v_xor_b32_e32 v1, 0x80000000, v3
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_multi_use_fp_extend_fneg_f16_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f64_f32_e32 v[2:3], v0
; VI-NEXT:    v_xor_b32_e32 v1, 0x80000000, v3
; VI-NEXT:    v_mov_b32_e32 v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_multi_use_fp_extend_fneg_f16_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f64_f32_e32 v[2:3], v0
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80000000, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fpext = fpext half %a to double
  %fneg = fneg double %fpext
  %insert.0 = insertvalue { double, double } poison, double %fneg, 0
  %insert.1 = insertvalue { double, double } %insert.0, double %fpext, 1
  ret { double, double } %insert.1
}

define { double, double } @v_fneg_multi_foldable_use_fp_extend_fneg_f16_to_f64(half %a) #0 {
; SI-LABEL: v_fneg_multi_foldable_use_fp_extend_fneg_f16_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; SI-NEXT:    v_xor_b32_e32 v4, 0x80000000, v1
; SI-NEXT:    v_mul_f64 v[2:3], v[0:1], 4.0
; SI-NEXT:    v_mov_b32_e32 v1, v4
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_multi_foldable_use_fp_extend_fneg_f16_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; VI-NEXT:    v_mul_f64 v[2:3], v[0:1], 4.0
; VI-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_multi_foldable_use_fp_extend_fneg_f16_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; GFX11-NEXT:    v_mul_f64 v[2:3], v[0:1], 4.0
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fpext = fpext half %a to double
  %fneg = fneg double %fpext
  %mul = fmul double %fpext, 4.0
  %insert.0 = insertvalue { double, double } poison, double %fneg, 0
  %insert.1 = insertvalue { double, double } %insert.0, double %mul, 1
  ret { double, double } %insert.1
}

define { float, float } @v_fneg_multi_use_fp_extend_fneg_f16_to_f32(half %a) #0 {
; SI-LABEL: v_fneg_multi_use_fp_extend_fneg_f16_to_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, v0
; SI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_multi_use_fp_extend_fneg_f16_to_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; VI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_multi_use_fp_extend_fneg_f16_to_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fpext = fpext half %a to float
  %fneg = fneg float %fpext
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %fpext, 1
  ret { float, float } %insert.1
}

; --------------------------------------------------------------------------------
; fp_round tests
; --------------------------------------------------------------------------------

define half @v_fneg_fp_round_f64_to_f16(double %a) #0 {
; SI-LABEL: v_fneg_fp_round_f64_to_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; SI-NEXT:    v_and_b32_e32 v2, 0x1ff, v1
; SI-NEXT:    v_or_b32_e32 v0, v2, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; SI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; SI-NEXT:    v_and_b32_e32 v2, 0xffe, v2
; SI-NEXT:    v_bfe_u32 v3, v1, 20, 11
; SI-NEXT:    s_movk_i32 s4, 0x3f1
; SI-NEXT:    v_or_b32_e32 v0, v2, v0
; SI-NEXT:    v_sub_i32_e32 v4, vcc, s4, v3
; SI-NEXT:    v_or_b32_e32 v2, 0x1000, v0
; SI-NEXT:    v_med3_i32 v4, v4, 0, 13
; SI-NEXT:    v_lshrrev_b32_e32 v5, v4, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, v4, v5
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, v4, v2
; SI-NEXT:    s_movk_i32 s4, 0xfc10
; SI-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-NEXT:    v_add_i32_e32 v3, vcc, s4, v3
; SI-NEXT:    v_lshlrev_b32_e32 v4, 12, v3
; SI-NEXT:    v_or_b32_e32 v2, v5, v2
; SI-NEXT:    v_or_b32_e32 v4, v0, v4
; SI-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v3
; SI-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-NEXT:    v_and_b32_e32 v4, 7, v2
; SI-NEXT:    v_cmp_lt_i32_e32 vcc, 5, v4
; SI-NEXT:    v_cmp_eq_u32_e64 s[4:5], 3, v4
; SI-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; SI-NEXT:    s_or_b64 vcc, s[4:5], vcc
; SI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; SI-NEXT:    v_mov_b32_e32 v4, 0x7c00
; SI-NEXT:    v_cmp_gt_i32_e32 vcc, 31, v3
; SI-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; SI-NEXT:    v_lshlrev_b32_e32 v0, 9, v0
; SI-NEXT:    s_movk_i32 s4, 0x40f
; SI-NEXT:    v_or_b32_e32 v0, 0x7c00, v0
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v3
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-NEXT:    v_and_b32_e32 v1, 0x8000, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_fp_round_f64_to_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; VI-NEXT:    v_and_b32_e32 v2, 0x1ff, v1
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-NEXT:    v_and_b32_e32 v2, 0xffe, v2
; VI-NEXT:    v_bfe_u32 v3, v1, 20, 11
; VI-NEXT:    s_movk_i32 s4, 0x3f1
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:    v_sub_u32_e32 v4, vcc, s4, v3
; VI-NEXT:    v_or_b32_e32 v2, 0x1000, v0
; VI-NEXT:    v_med3_i32 v4, v4, 0, 13
; VI-NEXT:    v_lshrrev_b32_e32 v5, v4, v2
; VI-NEXT:    v_lshlrev_b32_e32 v4, v4, v5
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, v4, v2
; VI-NEXT:    s_movk_i32 s4, 0xfc10
; VI-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-NEXT:    v_add_u32_e32 v3, vcc, s4, v3
; VI-NEXT:    v_lshlrev_b32_e32 v4, 12, v3
; VI-NEXT:    v_or_b32_e32 v2, v5, v2
; VI-NEXT:    v_or_b32_e32 v4, v0, v4
; VI-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v3
; VI-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; VI-NEXT:    v_and_b32_e32 v4, 7, v2
; VI-NEXT:    v_cmp_lt_i32_e32 vcc, 5, v4
; VI-NEXT:    v_cmp_eq_u32_e64 s[4:5], 3, v4
; VI-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; VI-NEXT:    s_or_b64 vcc, s[4:5], vcc
; VI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v4, 0x7c00
; VI-NEXT:    v_cmp_gt_i32_e32 vcc, 31, v3
; VI-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v0, 9, v0
; VI-NEXT:    s_movk_i32 s4, 0x40f
; VI-NEXT:    v_or_b32_e32 v0, 0x7c00, v0
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v3
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v2, 0x8000
; VI-NEXT:    v_and_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_fp_round_f64_to_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_and_or_b32 v0, 0x1ff, v1, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX11-NEXT:    v_bfe_u32 v3, v1, 20, 11
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_sub_nc_u32_e32 v4, 0x3f1, v3
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    v_and_or_b32 v0, 0xffe, v2, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_med3_i32 v2, v4, 0, 13
; GFX11-NEXT:    v_or_b32_e32 v4, 0x1000, v0
; GFX11-NEXT:    v_cmp_ne_u32_e64 s1, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v2, v4
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, v2, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, v2, v4
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX11-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0xfffffc10, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshl_or_b32 v4, v3, 12, v0
; GFX11-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 1, v3
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s1
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshl_or_b32 v0, v0, 9, 0x7c00
; GFX11-NEXT:    v_and_b32_e32 v4, 7, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 5, v4
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 3, v4
; GFX11-NEXT:    s_or_b32 vcc_lo, s0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, 0, v2, vcc_lo
; GFX11-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 31, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v2, 0x7c00, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0x40f, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX11-NEXT:    v_and_or_b32 v0, 0x8000, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fpround = fptrunc double %a to half
  %fneg = fneg half %fpround
  ret half %fneg
}

define half @v_fneg_fp_round_fneg_f64_to_f16(double %a) #0 {
; SI-LABEL: v_fneg_fp_round_fneg_f64_to_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0x1ff, v1
; SI-NEXT:    v_or_b32_e32 v0, v2, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; SI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; SI-NEXT:    v_and_b32_e32 v2, 0xffe, v2
; SI-NEXT:    v_bfe_u32 v3, v1, 20, 11
; SI-NEXT:    v_or_b32_e32 v0, v2, v0
; SI-NEXT:    v_sub_i32_e32 v4, vcc, 0x3f1, v3
; SI-NEXT:    v_or_b32_e32 v2, 0x1000, v0
; SI-NEXT:    v_med3_i32 v4, v4, 0, 13
; SI-NEXT:    v_lshrrev_b32_e32 v5, v4, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, v4, v5
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, v4, v2
; SI-NEXT:    s_movk_i32 s4, 0xfc10
; SI-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-NEXT:    v_add_i32_e32 v3, vcc, s4, v3
; SI-NEXT:    v_lshlrev_b32_e32 v4, 12, v3
; SI-NEXT:    v_or_b32_e32 v2, v5, v2
; SI-NEXT:    v_or_b32_e32 v4, v0, v4
; SI-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v3
; SI-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-NEXT:    v_and_b32_e32 v4, 7, v2
; SI-NEXT:    v_cmp_lt_i32_e32 vcc, 5, v4
; SI-NEXT:    v_cmp_eq_u32_e64 s[4:5], 3, v4
; SI-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; SI-NEXT:    s_or_b64 vcc, s[4:5], vcc
; SI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; SI-NEXT:    v_mov_b32_e32 v4, 0x7c00
; SI-NEXT:    v_cmp_gt_i32_e32 vcc, 31, v3
; SI-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; SI-NEXT:    v_lshlrev_b32_e32 v0, 9, v0
; SI-NEXT:    s_movk_i32 s4, 0x40f
; SI-NEXT:    v_or_b32_e32 v0, 0x7c00, v0
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v3
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-NEXT:    v_and_b32_e32 v1, 0x8000, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_fp_round_fneg_f64_to_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x1ff, v1
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-NEXT:    v_and_b32_e32 v2, 0xffe, v2
; VI-NEXT:    v_bfe_u32 v3, v1, 20, 11
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:    v_sub_u32_e32 v4, vcc, 0x3f1, v3
; VI-NEXT:    v_or_b32_e32 v2, 0x1000, v0
; VI-NEXT:    v_med3_i32 v4, v4, 0, 13
; VI-NEXT:    v_lshrrev_b32_e32 v5, v4, v2
; VI-NEXT:    v_lshlrev_b32_e32 v4, v4, v5
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, v4, v2
; VI-NEXT:    s_movk_i32 s4, 0xfc10
; VI-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-NEXT:    v_add_u32_e32 v3, vcc, s4, v3
; VI-NEXT:    v_lshlrev_b32_e32 v4, 12, v3
; VI-NEXT:    v_or_b32_e32 v2, v5, v2
; VI-NEXT:    v_or_b32_e32 v4, v0, v4
; VI-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v3
; VI-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; VI-NEXT:    v_and_b32_e32 v4, 7, v2
; VI-NEXT:    v_cmp_lt_i32_e32 vcc, 5, v4
; VI-NEXT:    v_cmp_eq_u32_e64 s[4:5], 3, v4
; VI-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; VI-NEXT:    s_or_b64 vcc, s[4:5], vcc
; VI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v4, 0x7c00
; VI-NEXT:    v_cmp_gt_i32_e32 vcc, 31, v3
; VI-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v0, 9, v0
; VI-NEXT:    s_movk_i32 s4, 0x40f
; VI-NEXT:    v_or_b32_e32 v0, 0x7c00, v0
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v3
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v2, 0x8000
; VI-NEXT:    v_and_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_fp_round_fneg_f64_to_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_or_b32 v0, 0x1ff, v1, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX11-NEXT:    v_bfe_u32 v3, v1, 20, 11
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_sub_nc_u32_e32 v4, 0x3f1, v3
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_or_b32 v0, 0xffe, v2, v0
; GFX11-NEXT:    v_med3_i32 v2, v4, 0, 13
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_or_b32_e32 v4, 0x1000, v0
; GFX11-NEXT:    v_cmp_ne_u32_e64 s1, 0, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v2, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, v2, v5
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, v2, v4
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0xfffffc10, v3
; GFX11-NEXT:    v_lshl_or_b32 v4, v3, 12, v0
; GFX11-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 1, v3
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX11-NEXT:    v_lshl_or_b32 v0, v0, 9, 0x7c00
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_and_b32_e32 v4, 7, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; GFX11-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 5, v4
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 3, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    s_or_b32 vcc_lo, s0, vcc_lo
; GFX11-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, 0, v2, vcc_lo
; GFX11-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 31, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, 0x7c00, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0x40f, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v0, 0x8000, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg double %a
  %fpround = fptrunc double %fneg.a to half
  %fneg = fneg half %fpround
  ret half %fneg
}

define { half, double } @v_fneg_fp_round_store_use_fneg_f64_to_f16(double %a) #0 {
; SI-LABEL: v_fneg_fp_round_store_use_fneg_f64_to_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0x1ff, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v3
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; SI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; SI-NEXT:    v_and_b32_e32 v2, 0xffe, v2
; SI-NEXT:    v_bfe_u32 v4, v1, 20, 11
; SI-NEXT:    s_movk_i32 s4, 0x3f1
; SI-NEXT:    v_or_b32_e32 v0, v2, v0
; SI-NEXT:    v_sub_i32_e32 v5, vcc, s4, v4
; SI-NEXT:    v_or_b32_e32 v2, 0x1000, v0
; SI-NEXT:    v_med3_i32 v5, v5, 0, 13
; SI-NEXT:    v_lshrrev_b32_e32 v6, v5, v2
; SI-NEXT:    v_lshlrev_b32_e32 v5, v5, v6
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, v5, v2
; SI-NEXT:    s_movk_i32 s4, 0xfc10
; SI-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, s4, v4
; SI-NEXT:    v_lshlrev_b32_e32 v5, 12, v4
; SI-NEXT:    v_or_b32_e32 v2, v6, v2
; SI-NEXT:    v_or_b32_e32 v5, v0, v5
; SI-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v4
; SI-NEXT:    v_cndmask_b32_e32 v2, v5, v2, vcc
; SI-NEXT:    v_and_b32_e32 v5, 7, v2
; SI-NEXT:    v_cmp_lt_i32_e32 vcc, 5, v5
; SI-NEXT:    v_cmp_eq_u32_e64 s[4:5], 3, v5
; SI-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; SI-NEXT:    s_or_b64 vcc, s[4:5], vcc
; SI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; SI-NEXT:    v_mov_b32_e32 v5, 0x7c00
; SI-NEXT:    v_cmp_gt_i32_e32 vcc, 31, v4
; SI-NEXT:    v_cndmask_b32_e32 v2, v5, v2, vcc
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; SI-NEXT:    v_lshlrev_b32_e32 v0, 9, v0
; SI-NEXT:    s_movk_i32 s4, 0x40f
; SI-NEXT:    v_or_b32_e32 v0, 0x7c00, v0
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v4
; SI-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0x8000, v2
; SI-NEXT:    v_or_b32_e32 v0, v2, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_xor_b32_e32 v2, 0x80000000, v1
; SI-NEXT:    v_mov_b32_e32 v1, v3
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_fp_round_store_use_fneg_f64_to_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, v0
; VI-NEXT:    v_and_b32_e32 v0, 0x1ff, v1
; VI-NEXT:    v_or_b32_e32 v0, v0, v3
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_lshrrev_b32_e32 v4, 8, v1
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-NEXT:    v_and_b32_e32 v4, 0xffe, v4
; VI-NEXT:    v_bfe_u32 v5, v1, 20, 11
; VI-NEXT:    s_movk_i32 s4, 0x3f1
; VI-NEXT:    v_or_b32_e32 v0, v4, v0
; VI-NEXT:    v_sub_u32_e32 v6, vcc, s4, v5
; VI-NEXT:    v_or_b32_e32 v4, 0x1000, v0
; VI-NEXT:    v_med3_i32 v6, v6, 0, 13
; VI-NEXT:    v_lshrrev_b32_e32 v7, v6, v4
; VI-NEXT:    v_lshlrev_b32_e32 v6, v6, v7
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, v6, v4
; VI-NEXT:    s_movk_i32 s4, 0xfc10
; VI-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; VI-NEXT:    v_add_u32_e32 v5, vcc, s4, v5
; VI-NEXT:    v_lshlrev_b32_e32 v6, 12, v5
; VI-NEXT:    v_or_b32_e32 v4, v7, v4
; VI-NEXT:    v_or_b32_e32 v6, v0, v6
; VI-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v5
; VI-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; VI-NEXT:    v_and_b32_e32 v6, 7, v4
; VI-NEXT:    v_cmp_lt_i32_e32 vcc, 5, v6
; VI-NEXT:    v_cmp_eq_u32_e64 s[4:5], 3, v6
; VI-NEXT:    v_lshrrev_b32_e32 v4, 2, v4
; VI-NEXT:    s_or_b64 vcc, s[4:5], vcc
; VI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; VI-NEXT:    v_mov_b32_e32 v6, 0x7c00
; VI-NEXT:    v_cmp_gt_i32_e32 vcc, 31, v5
; VI-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v0, 9, v0
; VI-NEXT:    s_movk_i32 s4, 0x40f
; VI-NEXT:    v_or_b32_e32 v0, 0x7c00, v0
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v5
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v4, 0x8000
; VI-NEXT:    v_xor_b32_e32 v2, 0x80000000, v1
; VI-NEXT:    v_and_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    v_mov_b32_e32 v1, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_fp_round_store_use_fneg_f64_to_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_or_b32 v2, 0x1ff, v1, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 8, v1
; GFX11-NEXT:    v_bfe_u32 v4, v1, 20, 11
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-NEXT:    v_sub_nc_u32_e32 v5, 0x3f1, v4
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_or_b32 v2, 0xffe, v3, v2
; GFX11-NEXT:    v_med3_i32 v3, v5, 0, 13
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_or_b32_e32 v5, 0x1000, v2
; GFX11-NEXT:    v_cmp_ne_u32_e64 s1, 0, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v3, v6
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, v3, v5
; GFX11-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_or_b32_e32 v3, v6, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0xfffffc10, v4
; GFX11-NEXT:    v_lshl_or_b32 v5, v4, 12, v2
; GFX11-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 1, v4
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc_lo
; GFX11-NEXT:    v_lshl_or_b32 v2, v2, 9, 0x7c00
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_and_b32_e32 v5, 7, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 2, v3
; GFX11-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 5, v5
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 3, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-NEXT:    s_or_b32 vcc_lo, s0, vcc_lo
; GFX11-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, 0, v3, vcc_lo
; GFX11-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 31, v4
; GFX11-NEXT:    v_cndmask_b32_e32 v3, 0x7c00, v3, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0x40f, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc_lo
; GFX11-NEXT:    v_and_or_b32 v3, 0x8000, v5, v2
; GFX11-NEXT:    v_xor_b32_e32 v2, 0x80000000, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_dual_mov_b32 v1, v0 :: v_dual_mov_b32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg double %a
  %fpround = fptrunc double %fneg.a to half
  %fneg = fneg half %fpround
  %insert.0 = insertvalue { half, double } poison, half %fneg, 0
  %insert.1 = insertvalue { half, double } %insert.0, double %fneg.a, 1
  ret { half, double } %insert.1
}

define { half, double } @v_fneg_fp_round_multi_use_fneg_f64_to_f16(double %a, double %c) #0 {
; SI-LABEL: v_fneg_fp_round_multi_use_fneg_f64_to_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_and_b32_e32 v4, 0x1ff, v1
; SI-NEXT:    v_or_b32_e32 v4, v4, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; SI-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; SI-NEXT:    v_and_b32_e32 v5, 0xffe, v5
; SI-NEXT:    v_bfe_u32 v6, v1, 20, 11
; SI-NEXT:    s_movk_i32 s4, 0x3f1
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    v_sub_i32_e32 v7, vcc, s4, v6
; SI-NEXT:    v_or_b32_e32 v5, 0x1000, v4
; SI-NEXT:    v_med3_i32 v7, v7, 0, 13
; SI-NEXT:    v_lshrrev_b32_e32 v8, v7, v5
; SI-NEXT:    v_lshlrev_b32_e32 v7, v7, v8
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, v7, v5
; SI-NEXT:    s_movk_i32 s4, 0xfc10
; SI-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, s4, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 12, v6
; SI-NEXT:    v_or_b32_e32 v5, v8, v5
; SI-NEXT:    v_or_b32_e32 v7, v4, v7
; SI-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v6
; SI-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; SI-NEXT:    v_and_b32_e32 v7, 7, v5
; SI-NEXT:    v_cmp_lt_i32_e32 vcc, 5, v7
; SI-NEXT:    v_cmp_eq_u32_e64 s[4:5], 3, v7
; SI-NEXT:    v_lshrrev_b32_e32 v5, 2, v5
; SI-NEXT:    s_or_b64 vcc, s[4:5], vcc
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_mov_b32_e32 v7, 0x7c00
; SI-NEXT:    v_cmp_gt_i32_e32 vcc, 31, v6
; SI-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; SI-NEXT:    v_lshlrev_b32_e32 v4, 9, v4
; SI-NEXT:    s_movk_i32 s4, 0x40f
; SI-NEXT:    v_or_b32_e32 v4, 0x7c00, v4
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v6
; SI-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; SI-NEXT:    v_and_b32_e32 v5, 0x8000, v5
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_mul_f64 v[1:2], -v[0:1], v[2:3]
; SI-NEXT:    v_mov_b32_e32 v0, v4
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_fp_round_multi_use_fneg_f64_to_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v4, 0x1ff, v1
; VI-NEXT:    v_or_b32_e32 v4, v4, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; VI-NEXT:    v_and_b32_e32 v5, 0xffe, v5
; VI-NEXT:    v_bfe_u32 v6, v1, 20, 11
; VI-NEXT:    s_movk_i32 s4, 0x3f1
; VI-NEXT:    v_or_b32_e32 v4, v5, v4
; VI-NEXT:    v_sub_u32_e32 v7, vcc, s4, v6
; VI-NEXT:    v_or_b32_e32 v5, 0x1000, v4
; VI-NEXT:    v_med3_i32 v7, v7, 0, 13
; VI-NEXT:    v_lshrrev_b32_e32 v8, v7, v5
; VI-NEXT:    v_lshlrev_b32_e32 v7, v7, v8
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, v7, v5
; VI-NEXT:    s_movk_i32 s4, 0xfc10
; VI-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, s4, v6
; VI-NEXT:    v_lshlrev_b32_e32 v7, 12, v6
; VI-NEXT:    v_or_b32_e32 v5, v8, v5
; VI-NEXT:    v_or_b32_e32 v7, v4, v7
; VI-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v6
; VI-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; VI-NEXT:    v_and_b32_e32 v7, 7, v5
; VI-NEXT:    v_cmp_lt_i32_e32 vcc, 5, v7
; VI-NEXT:    v_cmp_eq_u32_e64 s[4:5], 3, v7
; VI-NEXT:    v_lshrrev_b32_e32 v5, 2, v5
; VI-NEXT:    s_or_b64 vcc, s[4:5], vcc
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_mul_f64 v[2:3], -v[0:1], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v7, 0x7c00
; VI-NEXT:    v_cmp_gt_i32_e32 vcc, 31, v6
; VI-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; VI-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v4, 9, v4
; VI-NEXT:    s_movk_i32 s4, 0x40f
; VI-NEXT:    v_or_b32_e32 v4, 0x7c00, v4
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v6
; VI-NEXT:    v_cndmask_b32_e32 v0, v5, v4, vcc
; VI-NEXT:    v_mov_b32_e32 v4, 0x8000
; VI-NEXT:    v_and_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    v_mov_b32_e32 v2, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_fp_round_multi_use_fneg_f64_to_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_or_b32 v4, 0x1ff, v1, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX11-NEXT:    v_bfe_u32 v6, v1, 20, 11
; GFX11-NEXT:    v_mul_f64 v[2:3], -v[0:1], v[2:3]
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_sub_nc_u32_e32 v7, 0x3f1, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0xfffffc10, v6
; GFX11-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc_lo
; GFX11-NEXT:    v_and_or_b32 v4, 0xffe, v5, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_med3_i32 v5, v7, 0, 13
; GFX11-NEXT:    v_or_b32_e32 v7, 0x1000, v4
; GFX11-NEXT:    v_cmp_ne_u32_e64 s1, 0, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v8, v5, v7
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v5, v8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, v5, v7
; GFX11-NEXT:    v_lshl_or_b32 v7, v6, 12, v4
; GFX11-NEXT:    v_cndmask_b32_e64 v4, 0, 1, s1
; GFX11-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc_lo
; GFX11-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 1, v6
; GFX11-NEXT:    v_lshl_or_b32 v4, v4, 9, 0x7c00
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_or_b32_e32 v5, v8, v5
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v7, v5, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_and_b32_e32 v5, 7, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 5, v5
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    s_or_b32 vcc_lo, s0, vcc_lo
; GFX11-NEXT:    v_add_co_ci_u32_e32 v0, vcc_lo, 0, v0, vcc_lo
; GFX11-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 31, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7c00, v0, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0x40f, v6
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v0, 0x8000, v1, v0
; GFX11-NEXT:    v_dual_mov_b32 v1, v2 :: v_dual_mov_b32 v2, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg double %a
  %fpround = fptrunc double %fneg.a to half
  %fneg = fneg half %fpround
  %use1 = fmul double %fneg.a, %c
  %insert.0 = insertvalue { half, double } poison, half %fneg, 0
  %insert.1 = insertvalue { half, double } %insert.0, double %use1, 1
  ret { half, double } %insert.1
}

define { half, half } @v_fneg_multi_use_fp_round_fneg_f64_to_f16(double %a) #0 {
; SI-LABEL: v_fneg_multi_use_fp_round_fneg_f64_to_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0x1ff, v1
; SI-NEXT:    v_or_b32_e32 v0, v2, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; SI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; SI-NEXT:    v_and_b32_e32 v2, 0xffe, v2
; SI-NEXT:    v_bfe_u32 v3, v1, 20, 11
; SI-NEXT:    v_or_b32_e32 v0, v2, v0
; SI-NEXT:    v_sub_i32_e32 v4, vcc, 0x3f1, v3
; SI-NEXT:    v_or_b32_e32 v2, 0x1000, v0
; SI-NEXT:    v_med3_i32 v4, v4, 0, 13
; SI-NEXT:    v_lshrrev_b32_e32 v5, v4, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, v4, v5
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, v4, v2
; SI-NEXT:    s_movk_i32 s4, 0xfc10
; SI-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-NEXT:    v_add_i32_e32 v3, vcc, s4, v3
; SI-NEXT:    v_lshlrev_b32_e32 v4, 12, v3
; SI-NEXT:    v_or_b32_e32 v2, v5, v2
; SI-NEXT:    v_or_b32_e32 v4, v0, v4
; SI-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v3
; SI-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-NEXT:    v_and_b32_e32 v4, 7, v2
; SI-NEXT:    v_cmp_lt_i32_e32 vcc, 5, v4
; SI-NEXT:    v_cmp_eq_u32_e64 s[4:5], 3, v4
; SI-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; SI-NEXT:    s_or_b64 vcc, s[4:5], vcc
; SI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; SI-NEXT:    v_mov_b32_e32 v4, 0x7c00
; SI-NEXT:    v_cmp_gt_i32_e32 vcc, 31, v3
; SI-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; SI-NEXT:    v_lshlrev_b32_e32 v0, 9, v0
; SI-NEXT:    s_movk_i32 s4, 0x40f
; SI-NEXT:    v_or_b32_e32 v0, 0x7c00, v0
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v3
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-NEXT:    v_and_b32_e32 v1, 0x8000, v1
; SI-NEXT:    v_or_b32_e32 v1, v1, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v1
; SI-NEXT:    v_cvt_f32_f16_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_multi_use_fp_round_fneg_f64_to_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x1ff, v1
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-NEXT:    v_and_b32_e32 v2, 0xffe, v2
; VI-NEXT:    v_bfe_u32 v3, v1, 20, 11
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:    v_sub_u32_e32 v4, vcc, 0x3f1, v3
; VI-NEXT:    v_or_b32_e32 v2, 0x1000, v0
; VI-NEXT:    v_med3_i32 v4, v4, 0, 13
; VI-NEXT:    v_lshrrev_b32_e32 v5, v4, v2
; VI-NEXT:    v_lshlrev_b32_e32 v4, v4, v5
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, v4, v2
; VI-NEXT:    s_movk_i32 s4, 0xfc10
; VI-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-NEXT:    v_add_u32_e32 v3, vcc, s4, v3
; VI-NEXT:    v_lshlrev_b32_e32 v4, 12, v3
; VI-NEXT:    v_or_b32_e32 v2, v5, v2
; VI-NEXT:    v_or_b32_e32 v4, v0, v4
; VI-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v3
; VI-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; VI-NEXT:    v_and_b32_e32 v4, 7, v2
; VI-NEXT:    v_cmp_lt_i32_e32 vcc, 5, v4
; VI-NEXT:    v_cmp_eq_u32_e64 s[4:5], 3, v4
; VI-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; VI-NEXT:    s_or_b64 vcc, s[4:5], vcc
; VI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v4, 0x7c00
; VI-NEXT:    v_cmp_gt_i32_e32 vcc, 31, v3
; VI-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v0, 9, v0
; VI-NEXT:    s_movk_i32 s4, 0x40f
; VI-NEXT:    v_or_b32_e32 v0, 0x7c00, v0
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v3
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v2, 0x8000
; VI-NEXT:    v_and_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v0
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_multi_use_fp_round_fneg_f64_to_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_or_b32 v0, 0x1ff, v1, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX11-NEXT:    v_bfe_u32 v3, v1, 20, 11
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_sub_nc_u32_e32 v4, 0x3f1, v3
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_or_b32 v0, 0xffe, v2, v0
; GFX11-NEXT:    v_med3_i32 v2, v4, 0, 13
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_or_b32_e32 v4, 0x1000, v0
; GFX11-NEXT:    v_cmp_ne_u32_e64 s1, 0, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v2, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, v2, v5
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, v2, v4
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0xfffffc10, v3
; GFX11-NEXT:    v_lshl_or_b32 v4, v3, 12, v0
; GFX11-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 1, v3
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX11-NEXT:    v_lshl_or_b32 v0, v0, 9, 0x7c00
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_and_b32_e32 v4, 7, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; GFX11-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 5, v4
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 3, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    s_or_b32 vcc_lo, s0, vcc_lo
; GFX11-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, 0, v2, vcc_lo
; GFX11-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 31, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, 0x7c00, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0x40f, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v1, 0x8000, v1, v0
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x8000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fpround = fptrunc double %a to half
  %fneg = fneg half %fpround
  %insert.0 = insertvalue { half, half } poison, half %fneg, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %fpround, 1
  ret { half, half } %insert.1
}

; --------------------------------------------------------------------------------
; ftrunc tests
; --------------------------------------------------------------------------------

define half @v_fneg_trunc_f16(half %a) #0 {
; SI-LABEL: v_fneg_trunc_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_trunc_f32_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_trunc_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_trunc_f16_e64 v0, -v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_trunc_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_trunc_f16_e64 v0, -v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %trunc = call half @llvm.trunc.f16(half %a)
  %fneg = fneg half %trunc
  ret half %fneg
}

; --------------------------------------------------------------------------------
; fround tests
; --------------------------------------------------------------------------------

define half @v_fneg_round_f16(half %a) #0 {
; SI-SAFE-LABEL: v_fneg_round_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_trunc_f32_e32 v1, v0
; SI-SAFE-NEXT:    v_sub_f32_e32 v2, v0, v1
; SI-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], |v2|, 0.5
; SI-SAFE-NEXT:    v_cndmask_b32_e64 v2, 0, 1.0, s[4:5]
; SI-SAFE-NEXT:    s_brev_b32 s4, -2
; SI-SAFE-NEXT:    v_bfi_b32 v0, s4, v2, v0
; SI-SAFE-NEXT:    v_add_f32_e32 v0, v1, v0
; SI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_round_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_trunc_f32_e32 v1, v0
; SI-NSZ-NEXT:    v_sub_f32_e32 v2, v0, v1
; SI-NSZ-NEXT:    v_cmp_ge_f32_e64 s[4:5], |v2|, 0.5
; SI-NSZ-NEXT:    v_cndmask_b32_e64 v2, 0, 1.0, s[4:5]
; SI-NSZ-NEXT:    s_brev_b32 s4, -2
; SI-NSZ-NEXT:    v_bfi_b32 v0, s4, v2, v0
; SI-NSZ-NEXT:    v_sub_f32_e64 v0, -v1, v0
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_round_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_trunc_f16_e32 v1, v0
; VI-SAFE-NEXT:    v_sub_f16_e32 v2, v0, v1
; VI-SAFE-NEXT:    v_mov_b32_e32 v3, 0x3c00
; VI-SAFE-NEXT:    v_cmp_ge_f16_e64 vcc, |v2|, 0.5
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v2, 0, v3, vcc
; VI-SAFE-NEXT:    s_movk_i32 s4, 0x7fff
; VI-SAFE-NEXT:    v_bfi_b32 v0, s4, v2, v0
; VI-SAFE-NEXT:    v_add_f16_e32 v0, v1, v0
; VI-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_round_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_trunc_f16_e32 v1, v0
; VI-NSZ-NEXT:    v_sub_f16_e32 v2, v0, v1
; VI-NSZ-NEXT:    v_mov_b32_e32 v3, 0x3c00
; VI-NSZ-NEXT:    v_cmp_ge_f16_e64 vcc, |v2|, 0.5
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v2, 0, v3, vcc
; VI-NSZ-NEXT:    s_movk_i32 s4, 0x7fff
; VI-NSZ-NEXT:    v_bfi_b32 v0, s4, v2, v0
; VI-NSZ-NEXT:    v_sub_f16_e64 v0, -v1, v0
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: v_fneg_round_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_trunc_f16_e32 v1, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_sub_f16_e32 v2, v0, v1
; GFX11-SAFE-NEXT:    v_cmp_ge_f16_e64 s0, |v2|, 0.5
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_cndmask_b32_e64 v2, 0, 0x3c00, s0
; GFX11-SAFE-NEXT:    v_bfi_b32 v0, 0x7fff, v2, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_add_f16_e32 v0, v1, v0
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: v_fneg_round_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_trunc_f16_e32 v1, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_sub_f16_e32 v2, v0, v1
; GFX11-NSZ-NEXT:    v_cmp_ge_f16_e64 s0, |v2|, 0.5
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_cndmask_b32_e64 v2, 0, 0x3c00, s0
; GFX11-NSZ-NEXT:    v_bfi_b32 v0, 0x7fff, v2, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_sub_f16_e64 v0, -v1, v0
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %round = call half @llvm.round.f16(half %a)
  %fneg = fneg half %round
  ret half %fneg
}

; --------------------------------------------------------------------------------
; rint tests
; --------------------------------------------------------------------------------

define half @v_fneg_rint_f16(half %a) #0 {
; SI-LABEL: v_fneg_rint_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_rndne_f32_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_rint_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_rndne_f16_e64 v0, -v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_rint_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_rndne_f16_e64 v0, -v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %rint = call half @llvm.rint.f16(half %a)
  %fneg = fneg half %rint
  ret half %fneg
}

; --------------------------------------------------------------------------------
; nearbyint tests
; --------------------------------------------------------------------------------

define half @v_fneg_nearbyint_f16(half %a) #0 {
; SI-LABEL: v_fneg_nearbyint_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_rndne_f32_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_nearbyint_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_rndne_f16_e64 v0, -v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_nearbyint_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_rndne_f16_e64 v0, -v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %nearbyint = call half @llvm.nearbyint.f16(half %a)
  %fneg = fneg half %nearbyint
  ret half %fneg
}

; --------------------------------------------------------------------------------
; sin tests
; --------------------------------------------------------------------------------

define half @v_fneg_sin_f16(half %a) #0 {
; SI-LABEL: v_fneg_sin_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, 0x3e22f983, v0
; SI-NEXT:    v_fract_f32_e32 v0, v0
; SI-NEXT:    v_sin_f32_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_sin_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e32 v0, 0xb118, v0
; VI-NEXT:    v_fract_f16_e32 v0, v0
; VI-NEXT:    v_sin_f16_e32 v0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_sin_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e32 v0, 0xb118, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_sin_f16_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %sin = call half @llvm.sin.f16(half %a)
  %fneg = fneg half %sin
  ret half %fneg
}

; --------------------------------------------------------------------------------
; fcanonicalize tests
; --------------------------------------------------------------------------------

define half @v_fneg_canonicalize_f16(half %a) #0 {
; SI-LABEL: v_fneg_canonicalize_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_canonicalize_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_canonicalize_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %trunc = call half @llvm.canonicalize.f16(half %a)
  %fneg = fneg half %trunc
  ret half %fneg
}

; --------------------------------------------------------------------------------
; CopyToReg tests
; --------------------------------------------------------------------------------

define void @v_fneg_copytoreg_f16(ptr addrspace(1) %out, half %a, half %b, half %c, i32 %d) #0 {
; SI-LABEL: v_fneg_copytoreg_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_and_b32_e32 v6, 0x3ff, v31
; SI-NEXT:    v_lshlrev_b32_e32 v6, 1, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, v0, v6
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:    v_mul_f32_e32 v2, v2, v3
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_cbranch_execz .LBB81_2
; SI-NEXT:  ; %bb.1: ; %if
; SI-NEXT:    v_cvt_f16_f32_e64 v3, -v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_mul_f32_e32 v3, v3, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    flat_store_short v[0:1], v3
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:  .LBB81_2: ; %endif
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    flat_store_short v[0:1], v2
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_copytoreg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v6, 0x3ff, v31
; VI-NEXT:    v_lshlrev_b32_e32 v6, 1, v6
; VI-NEXT:    v_add_u32_e32 v0, vcc, v0, v6
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_mul_f16_e32 v2, v2, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_cbranch_execz .LBB81_2
; VI-NEXT:  ; %bb.1: ; %if
; VI-NEXT:    v_mul_f16_e64 v3, -v2, v4
; VI-NEXT:    flat_store_short v[0:1], v3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:  .LBB81_2: ; %endif
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_copytoreg_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v6, 0x3ff, v31
; GFX11-NEXT:    v_mul_f16_e32 v2, v2, v3
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v6, 1, v6
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v6
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    v_cmpx_eq_u32_e32 0, v5
; GFX11-NEXT:    s_cbranch_execz .LBB81_2
; GFX11-NEXT:  ; %bb.1: ; %if
; GFX11-NEXT:    v_mul_f16_e64 v3, -v2, v4
; GFX11-NEXT:    global_store_b16 v[0:1], v3, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:  .LBB81_2: ; %endif
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    global_store_b16 v[0:1], v2, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %out.gep = getelementptr inbounds half, ptr addrspace(1) %out, i64 %tid.ext
  %mul = fmul half %a, %b
  %fneg = fneg half %mul
  %cmp0 = icmp eq i32 %d, 0
  br i1 %cmp0, label %if, label %endif

if:
  %mul1 = fmul half %fneg, %c
  store volatile half %mul1, ptr addrspace(1) %out.gep
  br label %endif

endif:
  store volatile half %mul, ptr addrspace(1) %out.gep
  ret void
}

; --------------------------------------------------------------------------------
; inlineasm tests
; --------------------------------------------------------------------------------

; Can't fold into use, so should fold into source
define half @v_fneg_inlineasm_f16(half %a, half %b, half %c, i32 %d) #0 {
; SI-LABEL: v_fneg_inlineasm_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e64 v1, -v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v0
; SI-NEXT:    ;;#ASMSTART
; SI-NEXT:    ; use v1
; SI-NEXT:    ;;#ASMEND
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_inlineasm_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e64 v0, v0, -v1
; VI-NEXT:    ;;#ASMSTART
; VI-NEXT:    ; use v0
; VI-NEXT:    ;;#ASMEND
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_inlineasm_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e64 v0, v0, -v1
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; use v0
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %a, %b
  %fneg = fneg half %mul
  call void asm sideeffect "; use $0", "v"(half %fneg) #0
  ret half %fneg
}

; --------------------------------------------------------------------------------
; inlineasm tests
; --------------------------------------------------------------------------------

; Can't fold into use, so should fold into source
define half @v_fneg_inlineasm_multi_use_src_f16(ptr addrspace(1) %out, half %a, half %b, half %c, i32 %d) #0 {
; SI-LABEL: v_fneg_inlineasm_multi_use_src_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; SI-NEXT:    v_cvt_f16_f32_e64 v1, -v3
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e64 v1, -v1
; SI-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-NEXT:    v_cvt_f16_f32_e64 v1, -v0
; SI-NEXT:    ;;#ASMSTART
; SI-NEXT:    ; use v1
; SI-NEXT:    ;;#ASMEND
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_inlineasm_multi_use_src_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e32 v0, v2, v3
; VI-NEXT:    v_xor_b32_e32 v1, 0x8000, v0
; VI-NEXT:    ;;#ASMSTART
; VI-NEXT:    ; use v1
; VI-NEXT:    ;;#ASMEND
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_inlineasm_multi_use_src_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e32 v0, v2, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x8000, v0
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; use v1
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %out.gep = getelementptr inbounds half, ptr addrspace(1) %out, i64 %tid.ext
  %mul = fmul half %a, %b
  %fneg = fneg half %mul
  call void asm sideeffect "; use $0", "v"(half %fneg) #0
  ret half %mul
}

; --------------------------------------------------------------------------------
; code size regression tests
; --------------------------------------------------------------------------------

; There are multiple users of the fneg that must use a VOP3
; instruction, so there is no penalty
define { half, half } @multiuse_fneg_2_vop3_users_f16(half %a, half %b, half %c) #0 {
; SI-LABEL: multiuse_fneg_2_vop3_users_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_fma_f32 v0, -v3, v1, v2
; SI-NEXT:    v_fma_f32 v1, -v3, v2, 2.0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: multiuse_fneg_2_vop3_users_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_fma_f16 v3, -v0, v1, v2
; VI-NEXT:    v_fma_f16 v1, -v0, v2, 2.0
; VI-NEXT:    v_mov_b32_e32 v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: multiuse_fneg_2_vop3_users_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_fma_f16 v3, -v0, v1, v2
; GFX11-NEXT:    v_fma_f16 v1, -v0, v2, 2.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %fma0 = call half @llvm.fma.f16(half %fneg.a, half %b, half %c)
  %fma1 = call half @llvm.fma.f16(half %fneg.a, half %c, half 2.0)
  %insert.0 = insertvalue { half, half } poison, half %fma0, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %fma1, 1
  ret { half, half } %insert.1
}

; There are multiple users, but both require using a larger encoding
; for the modifier.
define { half, half } @multiuse_fneg_2_vop2_users_f16(half %a, half %b, half %c) #0 {
; SI-LABEL: multiuse_fneg_2_vop2_users_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_mul_f32_e32 v0, v3, v1
; SI-NEXT:    v_mul_f32_e32 v1, v3, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: multiuse_fneg_2_vop2_users_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e64 v3, -v0, v1
; VI-NEXT:    v_mul_f16_e64 v1, -v0, v2
; VI-NEXT:    v_mov_b32_e32 v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: multiuse_fneg_2_vop2_users_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e64 v3, -v0, v1
; GFX11-NEXT:    v_mul_f16_e64 v1, -v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg half %a
  %mul0 = fmul half %fneg.a, %b
  %mul1 = fmul half %fneg.a, %c
  %insert.0 = insertvalue { half, half } poison, half %mul0, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %mul1, 1
  ret { half, half } %insert.1
}

; One user is VOP3 so has no cost to folding the modifier, the other does.
define { half, half } @multiuse_fneg_vop2_vop3_users_f16(ptr addrspace(1) %out, half %a, half %b, half %c) #0 {
; SI-LABEL: multiuse_fneg_vop2_vop3_users_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v3
; SI-NEXT:    v_cvt_f16_f32_e64 v1, -v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_fma_f32 v0, v1, v0, 2.0
; SI-NEXT:    v_mul_f32_e32 v1, v1, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: multiuse_fneg_vop2_vop3_users_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_fma_f16 v0, -v2, v3, 2.0
; VI-NEXT:    v_mul_f16_e64 v1, -v2, v4
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: multiuse_fneg_vop2_vop3_users_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_fma_f16 v0, -v2, v3, 2.0
; GFX11-NEXT:    v_mul_f16_e64 v1, -v2, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %out.gep = getelementptr inbounds half, ptr addrspace(1) %out, i64 %tid.ext

  %fneg.a = fneg half %a
  %fma0 = call half @llvm.fma.f16(half %fneg.a, half %b, half 2.0)
  %mul1 = fmul half %fneg.a, %c

  %insert.0 = insertvalue { half, half } poison, half %fma0, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %mul1, 1
  ret { half, half } %insert.1
}

; The use of the fneg requires a code size increase, but folding into
; the source does not
define { half, half } @free_fold_src_code_size_cost_use_f16(ptr addrspace(1) %out, half %a, half %b, half %c, half %d) #0 {
; SI-SAFE-LABEL: free_fold_src_code_size_cost_use_f16:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v0, v3
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v2
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v4
; SI-SAFE-NEXT:    v_cvt_f16_f32_e32 v3, v5
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-SAFE-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-SAFE-NEXT:    v_fma_f32 v1, v1, v0, 2.0
; SI-SAFE-NEXT:    v_mul_f32_e64 v0, -v1, v2
; SI-SAFE-NEXT:    v_mul_f32_e64 v1, -v1, v3
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: free_fold_src_code_size_cost_use_f16:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v0, v3
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v2
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v4
; SI-NSZ-NEXT:    v_cvt_f16_f32_e32 v3, v5
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NSZ-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NSZ-NEXT:    v_fma_f32 v1, v1, -v0, -2.0
; SI-NSZ-NEXT:    v_mul_f32_e32 v0, v1, v2
; SI-NSZ-NEXT:    v_mul_f32_e32 v1, v1, v3
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: free_fold_src_code_size_cost_use_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_fma_f16 v1, v2, v3, 2.0
; VI-SAFE-NEXT:    v_mul_f16_e64 v0, -v1, v4
; VI-SAFE-NEXT:    v_mul_f16_e64 v1, -v1, v5
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: free_fold_src_code_size_cost_use_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_fma_f16 v1, v2, -v3, -2.0
; VI-NSZ-NEXT:    v_mul_f16_e32 v0, v1, v4
; VI-NSZ-NEXT:    v_mul_f16_e32 v1, v1, v5
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: free_fold_src_code_size_cost_use_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fma_f16 v1, v2, v3, 2.0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_mul_f16_e64 v0, -v1, v4
; GFX11-SAFE-NEXT:    v_mul_f16_e64 v1, -v1, v5
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: free_fold_src_code_size_cost_use_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v1, v2, -v3, -2.0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_mul_f16_e32 v0, v1, v4
; GFX11-NSZ-NEXT:    v_mul_f16_e32 v1, v1, v5
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %out.gep = getelementptr inbounds half, ptr addrspace(1) %out, i64 %tid.ext

  %fma0 = call half @llvm.fma.f16(half %a, half %b, half 2.0)
  %fneg.fma0 = fneg half %fma0
  %mul1 = fmul half %fneg.fma0, %c
  %mul2 = fmul half %fneg.fma0, %d

  %insert.0 = insertvalue { half, half } poison, half %mul1, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %mul2, 1
  ret { half, half } %insert.1
}

; %trunc.a has one fneg use, but it requires a code size increase and
; %the fneg can instead be folded for free into the fma.
define half @one_use_cost_to_fold_into_src_f16(ptr addrspace(1) %out, half %a, half %b, half %c, half %d) #0 {
; SI-LABEL: one_use_cost_to_fold_into_src_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_trunc_f32_e32 v1, v1
; SI-NEXT:    v_fma_f32 v0, -v1, v2, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: one_use_cost_to_fold_into_src_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_trunc_f16_e32 v0, v2
; VI-NEXT:    v_fma_f16 v0, -v0, v3, v4
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: one_use_cost_to_fold_into_src_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_trunc_f16_e32 v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_fma_f16 v0, -v0, v3, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %out.gep = getelementptr inbounds half, ptr addrspace(1) %out, i64 %tid.ext

  %trunc.a = call half @llvm.trunc.f16(half %a)
  %trunc.fneg.a = fneg half %trunc.a
  %fma0 = call half @llvm.fma.f16(half %trunc.fneg.a, half %b, half %c)
  ret half %fma0
}

define { half, half } @multi_use_cost_to_fold_into_src(ptr addrspace(1) %out, half %a, half %b, half %c, half %d) #0 {
; SI-LABEL: multi_use_cost_to_fold_into_src:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_trunc_f32_e32 v1, v1
; SI-NEXT:    v_fma_f32 v0, -v1, v2, v0
; SI-NEXT:    v_mul_f32_e32 v1, v1, v3
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: multi_use_cost_to_fold_into_src:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_trunc_f16_e32 v1, v2
; VI-NEXT:    v_fma_f16 v0, -v1, v3, v4
; VI-NEXT:    v_mul_f16_e32 v1, v1, v5
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: multi_use_cost_to_fold_into_src:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_trunc_f16_e32 v1, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_fma_f16 v0, -v1, v3, v4
; GFX11-NEXT:    v_mul_f16_e32 v1, v1, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %out.gep = getelementptr inbounds half, ptr addrspace(1) %out, i64 %tid.ext
  %trunc.a = call half @llvm.trunc.f16(half %a)
  %trunc.fneg.a = fneg half %trunc.a
  %fma0 = call half @llvm.fma.f16(half %trunc.fneg.a, half %b, half %c)
  %mul1 = fmul half %trunc.a, %d
  %insert.0 = insertvalue { half, half } poison, half %fma0, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %mul1, 1
  ret { half, half } %insert.1
}

; The AMDGPU combine to pull fneg into the FMA operands was being
; undone by the generic combine to pull the fneg out of the fma if
; !isFNegFree. We were reporting false for v2f32 even though it will
; be split into f32 where it will be free.
define <2 x half> @fneg_fma_fneg_dagcombine_loop(<2 x half> %arg, <2 x half> %arg1, <2 x half> %arg2) #0 {
; SI-LABEL: fneg_fma_fneg_dagcombine_loop:
; SI:       ; %bb.0: ; %bb
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; SI-NEXT:    v_or_b32_e32 v6, v4, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_xor_b32_e32 v6, 0x80008000, v6
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    s_brev_b32 s4, 1
; SI-NEXT:    v_fma_f32 v3, v3, v7, s4
; SI-NEXT:    v_fma_f32 v2, v2, v6, s4
; SI-NEXT:    v_sub_f32_e32 v1, v3, v1
; SI-NEXT:    v_sub_f32_e32 v0, v2, v0
; SI-NEXT:    v_mul_f32_e32 v0, v0, v4
; SI-NEXT:    v_mul_f32_e32 v1, v1, v5
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: fneg_fma_fneg_dagcombine_loop:
; VI:       ; %bb.0: ; %bb
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, 0x8000
; VI-NEXT:    v_fma_f16 v3, v1, -v2, s4
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; VI-NEXT:    v_fma_f16 v1, v1, -v4, s4
; VI-NEXT:    v_sub_f16_e32 v3, v3, v0
; VI-NEXT:    v_sub_f16_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_mul_f16_sdwa v0, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_mul_f16_e32 v1, v3, v2
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_fma_fneg_dagcombine_loop:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_fma_f16 v1, v1, v2, 0x8000 op_sel_hi:[1,1,0] neg_lo:[0,1,0] neg_hi:[0,1,0]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v1, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    v_pk_mul_f16 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
bb:
  %i3 = call fast <2 x half> @llvm.fma.v2f16(<2 x half> %arg1, <2 x half> %arg2, <2 x half> zeroinitializer)
  %i4 = fadd fast <2 x half> %i3, %arg
  %i5 = fneg <2 x half> %i4
  %i6 = fmul fast <2 x half> %i5, %arg2
  ret <2 x half> %i6
}

; This expects denormal flushing, so can't turn this fmul into fneg
; TODO: Keeping this as fmul saves encoding size
define half @nnan_fmul_neg1_to_fneg(half %x, half %y) #0 {
; SI-LABEL: nnan_fmul_neg1_to_fneg:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: nnan_fmul_neg1_to_fneg:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e64 v0, -v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: nnan_fmul_neg1_to_fneg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e64 v0, -v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, -1.0
  %add = fmul nnan half %mul, %y
  ret half %add
}

; It's legal to turn this fmul into an fneg since denormals are
; preserved and we know an snan can't happen from the flag.
define half @denormal_fmul_neg1_to_fneg(half %x, half %y) {
; SI-LABEL: denormal_fmul_neg1_to_fneg:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: denormal_fmul_neg1_to_fneg:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e64 v0, -v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: denormal_fmul_neg1_to_fneg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e64 v0, -v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul nnan half %x, -1.0
  %add = fmul half %mul, %y
  ret half %add
}

; know the source can't be an snan
define half @denorm_snan_fmul_neg1_to_fneg(half %x, half %y) {
; SI-LABEL: denorm_snan_fmul_neg1_to_fneg:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v0
; SI-NEXT:    v_cvt_f32_f16_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_mul_f32_e32 v0, v2, v0
; SI-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: denorm_snan_fmul_neg1_to_fneg:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e64 v0, v0, -v0
; VI-NEXT:    v_mul_f16_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: denorm_snan_fmul_neg1_to_fneg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e64 v0, v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %canonical = fmul half %x, %x
  %mul = fmul half %canonical, -1.0
  %add = fmul half %mul, %y
  ret half %add
}

define half @flush_snan_fmul_neg1_to_fneg(half %x, half %y) #0 {
; SI-LABEL: flush_snan_fmul_neg1_to_fneg:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: flush_snan_fmul_neg1_to_fneg:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v0
; VI-NEXT:    v_mul_f16_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flush_snan_fmul_neg1_to_fneg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %quiet = call half @llvm.canonicalize.f16(half %x)
  %mul = fmul half %quiet, -1.0
  %add = fmul half %mul, %y
  ret half %add
}

define half @fadd_select_fneg_fneg_f16(i32 %arg0, half %x, half %y, half %z) {
; SI-LABEL: fadd_select_fneg_fneg_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; SI-NEXT:    v_sub_f32_e32 v0, v3, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: fadd_select_fneg_fneg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fadd_select_fneg_fneg_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_sub_f16_e32 v0, v3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %arg0, 0
  %neg.x = fneg half %x
  %neg.y  = fneg half %y
  %select = select i1 %cmp, half %neg.x, half %neg.y
  %add = fadd half %select, %z
  ret half %add
}

; FIXME: Terrible code for SI
define <2 x half> @fadd_select_fneg_fneg_v2f16(i32 %arg0, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; SI-LABEL: fadd_select_fneg_fneg_v2f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v6
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_sub_f32_e32 v0, v4, v0
; SI-NEXT:    v_sub_f32_e32 v1, v3, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: fadd_select_fneg_fneg_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v3, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fadd_select_fneg_fneg_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v3, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %arg0, 0
  %neg.x = fneg <2 x half> %x
  %neg.y = fneg <2 x half> %y
  %select = select i1 %cmp, <2 x half> %neg.x, <2 x half> %neg.y
  %add = fadd <2 x half> %select, %z
  ret <2 x half> %add
}

declare i32 @llvm.amdgcn.workitem.id.x() #1
declare half @llvm.sin.f16(half) #1
declare half @llvm.trunc.f16(half) #1
declare half @llvm.round.f16(half) #1
declare half @llvm.rint.f16(half) #1
declare half @llvm.nearbyint.f16(half) #1
declare half @llvm.roundeven.f16(half) #1
declare half @llvm.canonicalize.f16(half) #1
declare half @llvm.minnum.f16(half, half) #1
declare half @llvm.maxnum.f16(half, half) #1
declare half @llvm.fma.f16(half, half, half) #1
declare <2 x half> @llvm.fma.v2f16(<2 x half>, <2 x half>, <2 x half>)
declare half @llvm.fmuladd.f16(half, half, half) #1
declare <4 x half> @llvm.fmuladd.v4f16(<4 x half>, <4 x half>, <4 x half>) #1

attributes #0 = { nounwind "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
attributes #1 = { nounwind readnone }
attributes #2 = { nounwind "unsafe-fp-math"="true" }
attributes #3 = { nounwind "no-signed-zeros-fp-math"="true" }
attributes #4 = { nounwind "amdgpu-ieee"="false" "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
