; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=riscv32 -mattr=+zhinx -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=ZHINX32 %s
; RUN: llc -mtriple=riscv64 -mattr=+zhinx -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=ZHINX64 %s
; RUN: llc -mtriple=riscv32 -mattr=+zfinx -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=ZFINX32 %s
; RUN: llc -mtriple=riscv64 -mattr=+zfinx -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=ZFINX64 %s
; RUN: llc -mtriple=riscv32 -mattr=+zdinx -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=ZDINX32 %s
; RUN: llc -mtriple=riscv64 -mattr=+zdinx -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=ZDINX64 %s

define half @caller_half(half %x) nounwind {
; ZHINX32-LABEL: caller_half:
; ZHINX32:       # %bb.0: # %entry
; ZHINX32-NEXT:    tail h
;
; ZHINX64-LABEL: caller_half:
; ZHINX64:       # %bb.0: # %entry
; ZHINX64-NEXT:    tail h
;
; ZFINX32-LABEL: caller_half:
; ZFINX32:       # %bb.0: # %entry
; ZFINX32-NEXT:    lui a1, 1048560
; ZFINX32-NEXT:    or a0, a0, a1
; ZFINX32-NEXT:    tail h
;
; ZFINX64-LABEL: caller_half:
; ZFINX64:       # %bb.0: # %entry
; ZFINX64-NEXT:    lui a1, 1048560
; ZFINX64-NEXT:    or a0, a0, a1
; ZFINX64-NEXT:    tail h
;
; ZDINX32-LABEL: caller_half:
; ZDINX32:       # %bb.0: # %entry
; ZDINX32-NEXT:    lui a1, 1048560
; ZDINX32-NEXT:    or a0, a0, a1
; ZDINX32-NEXT:    tail h
;
; ZDINX64-LABEL: caller_half:
; ZDINX64:       # %bb.0: # %entry
; ZDINX64-NEXT:    lui a1, 1048560
; ZDINX64-NEXT:    or a0, a0, a1
; ZDINX64-NEXT:    tail h
entry:
  %0 = tail call fastcc half @h(half %x)
  ret half %0
}

define internal fastcc half @h(half %x) nounwind {
; ZHINX32-LABEL: h:
; ZHINX32:       # %bb.0:
; ZHINX32-NEXT:    ret
;
; ZHINX64-LABEL: h:
; ZHINX64:       # %bb.0:
; ZHINX64-NEXT:    ret
;
; ZFINX32-LABEL: h:
; ZFINX32:       # %bb.0:
; ZFINX32-NEXT:    lui a1, 1048560
; ZFINX32-NEXT:    or a0, a0, a1
; ZFINX32-NEXT:    ret
;
; ZFINX64-LABEL: h:
; ZFINX64:       # %bb.0:
; ZFINX64-NEXT:    lui a1, 1048560
; ZFINX64-NEXT:    or a0, a0, a1
; ZFINX64-NEXT:    ret
;
; ZDINX32-LABEL: h:
; ZDINX32:       # %bb.0:
; ZDINX32-NEXT:    lui a1, 1048560
; ZDINX32-NEXT:    or a0, a0, a1
; ZDINX32-NEXT:    ret
;
; ZDINX64-LABEL: h:
; ZDINX64:       # %bb.0:
; ZDINX64-NEXT:    lui a1, 1048560
; ZDINX64-NEXT:    or a0, a0, a1
; ZDINX64-NEXT:    ret
  ret half %x
}

define float @caller_float(float %x) nounwind {
; ZHINX32-LABEL: caller_float:
; ZHINX32:       # %bb.0: # %entry
; ZHINX32-NEXT:    tail f
;
; ZHINX64-LABEL: caller_float:
; ZHINX64:       # %bb.0: # %entry
; ZHINX64-NEXT:    tail f
;
; ZFINX32-LABEL: caller_float:
; ZFINX32:       # %bb.0: # %entry
; ZFINX32-NEXT:    tail f
;
; ZFINX64-LABEL: caller_float:
; ZFINX64:       # %bb.0: # %entry
; ZFINX64-NEXT:    tail f
;
; ZDINX32-LABEL: caller_float:
; ZDINX32:       # %bb.0: # %entry
; ZDINX32-NEXT:    tail f
;
; ZDINX64-LABEL: caller_float:
; ZDINX64:       # %bb.0: # %entry
; ZDINX64-NEXT:    tail f
entry:
  %0 = tail call fastcc float @f(float %x)
  ret float %0
}

define internal fastcc float @f(float %x) nounwind {
; ZHINX32-LABEL: f:
; ZHINX32:       # %bb.0: # %entry
; ZHINX32-NEXT:    ret
;
; ZHINX64-LABEL: f:
; ZHINX64:       # %bb.0: # %entry
; ZHINX64-NEXT:    ret
;
; ZFINX32-LABEL: f:
; ZFINX32:       # %bb.0: # %entry
; ZFINX32-NEXT:    ret
;
; ZFINX64-LABEL: f:
; ZFINX64:       # %bb.0: # %entry
; ZFINX64-NEXT:    ret
;
; ZDINX32-LABEL: f:
; ZDINX32:       # %bb.0: # %entry
; ZDINX32-NEXT:    ret
;
; ZDINX64-LABEL: f:
; ZDINX64:       # %bb.0: # %entry
; ZDINX64-NEXT:    ret
entry:
  ret float %x
}

define double @caller_double(double %x) nounwind {
; ZHINX32-LABEL: caller_double:
; ZHINX32:       # %bb.0: # %entry
; ZHINX32-NEXT:    tail d
;
; ZHINX64-LABEL: caller_double:
; ZHINX64:       # %bb.0: # %entry
; ZHINX64-NEXT:    tail d
;
; ZFINX32-LABEL: caller_double:
; ZFINX32:       # %bb.0: # %entry
; ZFINX32-NEXT:    tail d
;
; ZFINX64-LABEL: caller_double:
; ZFINX64:       # %bb.0: # %entry
; ZFINX64-NEXT:    tail d
;
; ZDINX32-LABEL: caller_double:
; ZDINX32:       # %bb.0: # %entry
; ZDINX32-NEXT:    addi sp, sp, -32
; ZDINX32-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw a0, 16(sp)
; ZDINX32-NEXT:    sw a1, 20(sp)
; ZDINX32-NEXT:    lw a0, 16(sp)
; ZDINX32-NEXT:    lw a1, 20(sp)
; ZDINX32-NEXT:    sw a0, 0(sp)
; ZDINX32-NEXT:    sw a1, 4(sp)
; ZDINX32-NEXT:    call d
; ZDINX32-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    addi sp, sp, 32
; ZDINX32-NEXT:    ret
;
; ZDINX64-LABEL: caller_double:
; ZDINX64:       # %bb.0: # %entry
; ZDINX64-NEXT:    tail d
entry:
  %0 = tail call fastcc double @d(double %x)
  ret double %0
}

define internal fastcc double @d(double %x) nounwind {
; ZHINX32-LABEL: d:
; ZHINX32:       # %bb.0: # %entry
; ZHINX32-NEXT:    ret
;
; ZHINX64-LABEL: d:
; ZHINX64:       # %bb.0: # %entry
; ZHINX64-NEXT:    ret
;
; ZFINX32-LABEL: d:
; ZFINX32:       # %bb.0: # %entry
; ZFINX32-NEXT:    ret
;
; ZFINX64-LABEL: d:
; ZFINX64:       # %bb.0: # %entry
; ZFINX64-NEXT:    ret
;
; ZDINX32-LABEL: d:
; ZDINX32:       # %bb.0: # %entry
; ZDINX32-NEXT:    addi sp, sp, -16
; ZDINX32-NEXT:    lw a0, 16(sp)
; ZDINX32-NEXT:    lw a1, 20(sp)
; ZDINX32-NEXT:    sw a0, 8(sp)
; ZDINX32-NEXT:    sw a1, 12(sp)
; ZDINX32-NEXT:    lw a0, 8(sp)
; ZDINX32-NEXT:    lw a1, 12(sp)
; ZDINX32-NEXT:    addi sp, sp, 16
; ZDINX32-NEXT:    ret
;
; ZDINX64-LABEL: d:
; ZDINX64:       # %bb.0: # %entry
; ZDINX64-NEXT:    ret
entry:
  ret double %x
}

define fastcc half @callee_half_32(<32 x half> %A) nounwind {
; ZHINX32-LABEL: callee_half_32:
; ZHINX32:       # %bb.0:
; ZHINX32-NEXT:    ret
;
; ZHINX64-LABEL: callee_half_32:
; ZHINX64:       # %bb.0:
; ZHINX64-NEXT:    ret
;
; ZFINX32-LABEL: callee_half_32:
; ZFINX32:       # %bb.0:
; ZFINX32-NEXT:    lui a1, 1048560
; ZFINX32-NEXT:    or a0, a0, a1
; ZFINX32-NEXT:    ret
;
; ZFINX64-LABEL: callee_half_32:
; ZFINX64:       # %bb.0:
; ZFINX64-NEXT:    lui a1, 1048560
; ZFINX64-NEXT:    or a0, a0, a1
; ZFINX64-NEXT:    ret
;
; ZDINX32-LABEL: callee_half_32:
; ZDINX32:       # %bb.0:
; ZDINX32-NEXT:    lui a1, 1048560
; ZDINX32-NEXT:    or a0, a0, a1
; ZDINX32-NEXT:    ret
;
; ZDINX64-LABEL: callee_half_32:
; ZDINX64:       # %bb.0:
; ZDINX64-NEXT:    lui a1, 1048560
; ZDINX64-NEXT:    or a0, a0, a1
; ZDINX64-NEXT:    ret
	%B = extractelement <32 x half> %A, i32 0
	ret half %B
}

define half @caller_half_32(<32 x half> %A) nounwind {
; ZHINX32-LABEL: caller_half_32:
; ZHINX32:       # %bb.0:
; ZHINX32-NEXT:    addi sp, sp, -112
; ZHINX32-NEXT:    sw ra, 108(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s0, 104(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s1, 100(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s2, 96(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s3, 92(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s4, 88(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s5, 84(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s6, 80(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s7, 76(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s8, 72(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s9, 68(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s10, 64(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s11, 60(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    lh t0, 112(sp)
; ZHINX32-NEXT:    sw t0, 56(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    lh t0, 116(sp)
; ZHINX32-NEXT:    sw t0, 52(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    lh t0, 120(sp)
; ZHINX32-NEXT:    sw t0, 48(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    lh t0, 124(sp)
; ZHINX32-NEXT:    sw t0, 44(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    lh t6, 128(sp)
; ZHINX32-NEXT:    lh t5, 132(sp)
; ZHINX32-NEXT:    lh t4, 136(sp)
; ZHINX32-NEXT:    lh s0, 140(sp)
; ZHINX32-NEXT:    lh s1, 144(sp)
; ZHINX32-NEXT:    lh s2, 148(sp)
; ZHINX32-NEXT:    lh s3, 152(sp)
; ZHINX32-NEXT:    lh s4, 156(sp)
; ZHINX32-NEXT:    lh s5, 160(sp)
; ZHINX32-NEXT:    lh s6, 164(sp)
; ZHINX32-NEXT:    lh s7, 168(sp)
; ZHINX32-NEXT:    lh s8, 172(sp)
; ZHINX32-NEXT:    lh s9, 176(sp)
; ZHINX32-NEXT:    lh s10, 180(sp)
; ZHINX32-NEXT:    lh s11, 184(sp)
; ZHINX32-NEXT:    lh ra, 188(sp)
; ZHINX32-NEXT:    lh t3, 192(sp)
; ZHINX32-NEXT:    lh t2, 196(sp)
; ZHINX32-NEXT:    lh t1, 200(sp)
; ZHINX32-NEXT:    lh t0, 204(sp)
; ZHINX32-NEXT:    sh t0, 36(sp)
; ZHINX32-NEXT:    sh t1, 34(sp)
; ZHINX32-NEXT:    sh t2, 32(sp)
; ZHINX32-NEXT:    sh t3, 30(sp)
; ZHINX32-NEXT:    sh ra, 28(sp)
; ZHINX32-NEXT:    sh s11, 26(sp)
; ZHINX32-NEXT:    sh s10, 24(sp)
; ZHINX32-NEXT:    sh s9, 22(sp)
; ZHINX32-NEXT:    sh s8, 20(sp)
; ZHINX32-NEXT:    sh s7, 18(sp)
; ZHINX32-NEXT:    sh s6, 16(sp)
; ZHINX32-NEXT:    sh s5, 14(sp)
; ZHINX32-NEXT:    sh s4, 12(sp)
; ZHINX32-NEXT:    sh s3, 10(sp)
; ZHINX32-NEXT:    sh s2, 8(sp)
; ZHINX32-NEXT:    sh s1, 6(sp)
; ZHINX32-NEXT:    sh s0, 4(sp)
; ZHINX32-NEXT:    sh t4, 2(sp)
; ZHINX32-NEXT:    sh t5, 0(sp)
; ZHINX32-NEXT:    lw t2, 56(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw t3, 52(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw t4, 48(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw t5, 44(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    call callee_half_32
; ZHINX32-NEXT:    lw ra, 108(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s0, 104(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s1, 100(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s2, 96(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s3, 92(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s4, 88(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s5, 84(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s6, 80(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s7, 76(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s8, 72(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s9, 68(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s10, 64(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s11, 60(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    addi sp, sp, 112
; ZHINX32-NEXT:    ret
;
; ZHINX64-LABEL: caller_half_32:
; ZHINX64:       # %bb.0:
; ZHINX64-NEXT:    addi sp, sp, -176
; ZHINX64-NEXT:    sd ra, 168(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s0, 160(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s1, 152(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s2, 144(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s3, 136(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s4, 128(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s5, 120(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s6, 112(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s7, 104(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s8, 96(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s9, 88(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s10, 80(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s11, 72(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    lh t0, 176(sp)
; ZHINX64-NEXT:    sd t0, 64(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    lh t0, 184(sp)
; ZHINX64-NEXT:    sd t0, 56(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    lh t0, 192(sp)
; ZHINX64-NEXT:    sd t0, 48(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    lh t0, 200(sp)
; ZHINX64-NEXT:    sd t0, 40(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    lh t6, 208(sp)
; ZHINX64-NEXT:    lh t5, 216(sp)
; ZHINX64-NEXT:    lh t4, 224(sp)
; ZHINX64-NEXT:    lh s0, 232(sp)
; ZHINX64-NEXT:    lh s1, 240(sp)
; ZHINX64-NEXT:    lh s2, 248(sp)
; ZHINX64-NEXT:    lh s3, 256(sp)
; ZHINX64-NEXT:    lh s4, 264(sp)
; ZHINX64-NEXT:    lh s5, 272(sp)
; ZHINX64-NEXT:    lh s6, 280(sp)
; ZHINX64-NEXT:    lh s7, 288(sp)
; ZHINX64-NEXT:    lh s8, 296(sp)
; ZHINX64-NEXT:    lh s9, 304(sp)
; ZHINX64-NEXT:    lh s10, 312(sp)
; ZHINX64-NEXT:    lh s11, 320(sp)
; ZHINX64-NEXT:    lh ra, 328(sp)
; ZHINX64-NEXT:    lh t3, 336(sp)
; ZHINX64-NEXT:    lh t2, 344(sp)
; ZHINX64-NEXT:    lh t1, 352(sp)
; ZHINX64-NEXT:    lh t0, 360(sp)
; ZHINX64-NEXT:    sh t0, 36(sp)
; ZHINX64-NEXT:    sh t1, 34(sp)
; ZHINX64-NEXT:    sh t2, 32(sp)
; ZHINX64-NEXT:    sh t3, 30(sp)
; ZHINX64-NEXT:    sh ra, 28(sp)
; ZHINX64-NEXT:    sh s11, 26(sp)
; ZHINX64-NEXT:    sh s10, 24(sp)
; ZHINX64-NEXT:    sh s9, 22(sp)
; ZHINX64-NEXT:    sh s8, 20(sp)
; ZHINX64-NEXT:    sh s7, 18(sp)
; ZHINX64-NEXT:    sh s6, 16(sp)
; ZHINX64-NEXT:    sh s5, 14(sp)
; ZHINX64-NEXT:    sh s4, 12(sp)
; ZHINX64-NEXT:    sh s3, 10(sp)
; ZHINX64-NEXT:    sh s2, 8(sp)
; ZHINX64-NEXT:    sh s1, 6(sp)
; ZHINX64-NEXT:    sh s0, 4(sp)
; ZHINX64-NEXT:    sh t4, 2(sp)
; ZHINX64-NEXT:    sh t5, 0(sp)
; ZHINX64-NEXT:    ld t2, 64(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld t3, 56(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld t4, 48(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld t5, 40(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    call callee_half_32
; ZHINX64-NEXT:    ld ra, 168(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s0, 160(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s1, 152(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s2, 144(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s3, 136(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s4, 128(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s5, 120(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s6, 112(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s7, 104(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s8, 96(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s9, 88(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s10, 80(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s11, 72(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    addi sp, sp, 176
; ZHINX64-NEXT:    ret
;
; ZFINX32-LABEL: caller_half_32:
; ZFINX32:       # %bb.0:
; ZFINX32-NEXT:    addi sp, sp, -144
; ZFINX32-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    lw t0, 0(a0)
; ZFINX32-NEXT:    lw a1, 4(a0)
; ZFINX32-NEXT:    sw a1, 88(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    lw a1, 8(a0)
; ZFINX32-NEXT:    sw a1, 84(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    lw a1, 12(a0)
; ZFINX32-NEXT:    sw a1, 80(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    lw a1, 16(a0)
; ZFINX32-NEXT:    sw a1, 76(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    lw a5, 20(a0)
; ZFINX32-NEXT:    lw a6, 24(a0)
; ZFINX32-NEXT:    lw a7, 28(a0)
; ZFINX32-NEXT:    lw t2, 32(a0)
; ZFINX32-NEXT:    lw t3, 36(a0)
; ZFINX32-NEXT:    lw t4, 40(a0)
; ZFINX32-NEXT:    lw t5, 44(a0)
; ZFINX32-NEXT:    lw t6, 48(a0)
; ZFINX32-NEXT:    lw t1, 52(a0)
; ZFINX32-NEXT:    lw s0, 56(a0)
; ZFINX32-NEXT:    lw s1, 60(a0)
; ZFINX32-NEXT:    lw s2, 64(a0)
; ZFINX32-NEXT:    lw s3, 68(a0)
; ZFINX32-NEXT:    lw s4, 72(a0)
; ZFINX32-NEXT:    lw s5, 76(a0)
; ZFINX32-NEXT:    lw s6, 80(a0)
; ZFINX32-NEXT:    lw s7, 84(a0)
; ZFINX32-NEXT:    lw s8, 88(a0)
; ZFINX32-NEXT:    lw s9, 92(a0)
; ZFINX32-NEXT:    lw s10, 96(a0)
; ZFINX32-NEXT:    lw s11, 100(a0)
; ZFINX32-NEXT:    lw ra, 104(a0)
; ZFINX32-NEXT:    lw a4, 108(a0)
; ZFINX32-NEXT:    lw a3, 112(a0)
; ZFINX32-NEXT:    lw a2, 116(a0)
; ZFINX32-NEXT:    lw a1, 120(a0)
; ZFINX32-NEXT:    lw a0, 124(a0)
; ZFINX32-NEXT:    sw a0, 72(sp)
; ZFINX32-NEXT:    sw a1, 68(sp)
; ZFINX32-NEXT:    sw a2, 64(sp)
; ZFINX32-NEXT:    sw a3, 60(sp)
; ZFINX32-NEXT:    sw a4, 56(sp)
; ZFINX32-NEXT:    sw ra, 52(sp)
; ZFINX32-NEXT:    sw s11, 48(sp)
; ZFINX32-NEXT:    sw s10, 44(sp)
; ZFINX32-NEXT:    sw s9, 40(sp)
; ZFINX32-NEXT:    sw s8, 36(sp)
; ZFINX32-NEXT:    sw s7, 32(sp)
; ZFINX32-NEXT:    sw s6, 28(sp)
; ZFINX32-NEXT:    sw s5, 24(sp)
; ZFINX32-NEXT:    sw s4, 20(sp)
; ZFINX32-NEXT:    sw s3, 16(sp)
; ZFINX32-NEXT:    sw s2, 12(sp)
; ZFINX32-NEXT:    sw s1, 8(sp)
; ZFINX32-NEXT:    sw s0, 4(sp)
; ZFINX32-NEXT:    sw t1, 0(sp)
; ZFINX32-NEXT:    mv a0, t0
; ZFINX32-NEXT:    lw a1, 88(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw a2, 84(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw a3, 80(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw a4, 76(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    call callee_half_32
; ZFINX32-NEXT:    lui a1, 1048560
; ZFINX32-NEXT:    or a0, a0, a1
; ZFINX32-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    addi sp, sp, 144
; ZFINX32-NEXT:    ret
;
; ZFINX64-LABEL: caller_half_32:
; ZFINX64:       # %bb.0:
; ZFINX64-NEXT:    addi sp, sp, -288
; ZFINX64-NEXT:    sd ra, 280(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s0, 272(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s1, 264(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s2, 256(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s3, 248(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s4, 240(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s5, 232(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s6, 224(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s7, 216(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s8, 208(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s9, 200(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s10, 192(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s11, 184(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    ld t0, 0(a0)
; ZFINX64-NEXT:    ld a1, 8(a0)
; ZFINX64-NEXT:    sd a1, 176(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    ld a1, 16(a0)
; ZFINX64-NEXT:    sd a1, 168(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    ld a1, 24(a0)
; ZFINX64-NEXT:    sd a1, 160(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    ld a1, 32(a0)
; ZFINX64-NEXT:    sd a1, 152(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    ld a5, 40(a0)
; ZFINX64-NEXT:    ld a6, 48(a0)
; ZFINX64-NEXT:    ld a7, 56(a0)
; ZFINX64-NEXT:    ld t2, 64(a0)
; ZFINX64-NEXT:    ld t3, 72(a0)
; ZFINX64-NEXT:    ld t4, 80(a0)
; ZFINX64-NEXT:    ld t5, 88(a0)
; ZFINX64-NEXT:    ld t6, 96(a0)
; ZFINX64-NEXT:    ld t1, 104(a0)
; ZFINX64-NEXT:    ld s0, 112(a0)
; ZFINX64-NEXT:    ld s1, 120(a0)
; ZFINX64-NEXT:    ld s2, 128(a0)
; ZFINX64-NEXT:    ld s3, 136(a0)
; ZFINX64-NEXT:    ld s4, 144(a0)
; ZFINX64-NEXT:    ld s5, 152(a0)
; ZFINX64-NEXT:    ld s6, 160(a0)
; ZFINX64-NEXT:    ld s7, 168(a0)
; ZFINX64-NEXT:    ld s8, 176(a0)
; ZFINX64-NEXT:    ld s9, 184(a0)
; ZFINX64-NEXT:    ld s10, 192(a0)
; ZFINX64-NEXT:    ld s11, 200(a0)
; ZFINX64-NEXT:    ld ra, 208(a0)
; ZFINX64-NEXT:    ld a4, 216(a0)
; ZFINX64-NEXT:    ld a3, 224(a0)
; ZFINX64-NEXT:    ld a2, 232(a0)
; ZFINX64-NEXT:    ld a1, 240(a0)
; ZFINX64-NEXT:    ld a0, 248(a0)
; ZFINX64-NEXT:    sd a0, 144(sp)
; ZFINX64-NEXT:    sd a1, 136(sp)
; ZFINX64-NEXT:    sd a2, 128(sp)
; ZFINX64-NEXT:    sd a3, 120(sp)
; ZFINX64-NEXT:    sd a4, 112(sp)
; ZFINX64-NEXT:    sd ra, 104(sp)
; ZFINX64-NEXT:    sd s11, 96(sp)
; ZFINX64-NEXT:    sd s10, 88(sp)
; ZFINX64-NEXT:    sd s9, 80(sp)
; ZFINX64-NEXT:    sd s8, 72(sp)
; ZFINX64-NEXT:    sd s7, 64(sp)
; ZFINX64-NEXT:    sd s6, 56(sp)
; ZFINX64-NEXT:    sd s5, 48(sp)
; ZFINX64-NEXT:    sd s4, 40(sp)
; ZFINX64-NEXT:    sd s3, 32(sp)
; ZFINX64-NEXT:    sd s2, 24(sp)
; ZFINX64-NEXT:    sd s1, 16(sp)
; ZFINX64-NEXT:    sd s0, 8(sp)
; ZFINX64-NEXT:    sd t1, 0(sp)
; ZFINX64-NEXT:    mv a0, t0
; ZFINX64-NEXT:    ld a1, 176(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld a2, 168(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld a3, 160(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld a4, 152(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    call callee_half_32
; ZFINX64-NEXT:    lui a1, 1048560
; ZFINX64-NEXT:    or a0, a0, a1
; ZFINX64-NEXT:    ld ra, 280(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s0, 272(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s1, 264(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s2, 256(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s3, 248(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s4, 240(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s5, 232(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s6, 224(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s7, 216(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s8, 208(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s9, 200(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s10, 192(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s11, 184(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    addi sp, sp, 288
; ZFINX64-NEXT:    ret
;
; ZDINX32-LABEL: caller_half_32:
; ZDINX32:       # %bb.0:
; ZDINX32-NEXT:    addi sp, sp, -144
; ZDINX32-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    lw t0, 0(a0)
; ZDINX32-NEXT:    lw a1, 4(a0)
; ZDINX32-NEXT:    sw a1, 88(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    lw a1, 8(a0)
; ZDINX32-NEXT:    sw a1, 84(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    lw a1, 12(a0)
; ZDINX32-NEXT:    sw a1, 80(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    lw a1, 16(a0)
; ZDINX32-NEXT:    sw a1, 76(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    lw a5, 20(a0)
; ZDINX32-NEXT:    lw a6, 24(a0)
; ZDINX32-NEXT:    lw a7, 28(a0)
; ZDINX32-NEXT:    lw t2, 32(a0)
; ZDINX32-NEXT:    lw t3, 36(a0)
; ZDINX32-NEXT:    lw t4, 40(a0)
; ZDINX32-NEXT:    lw t5, 44(a0)
; ZDINX32-NEXT:    lw t6, 48(a0)
; ZDINX32-NEXT:    lw t1, 52(a0)
; ZDINX32-NEXT:    lw s0, 56(a0)
; ZDINX32-NEXT:    lw s1, 60(a0)
; ZDINX32-NEXT:    lw s2, 64(a0)
; ZDINX32-NEXT:    lw s3, 68(a0)
; ZDINX32-NEXT:    lw s4, 72(a0)
; ZDINX32-NEXT:    lw s5, 76(a0)
; ZDINX32-NEXT:    lw s6, 80(a0)
; ZDINX32-NEXT:    lw s7, 84(a0)
; ZDINX32-NEXT:    lw s8, 88(a0)
; ZDINX32-NEXT:    lw s9, 92(a0)
; ZDINX32-NEXT:    lw s10, 96(a0)
; ZDINX32-NEXT:    lw s11, 100(a0)
; ZDINX32-NEXT:    lw ra, 104(a0)
; ZDINX32-NEXT:    lw a4, 108(a0)
; ZDINX32-NEXT:    lw a3, 112(a0)
; ZDINX32-NEXT:    lw a2, 116(a0)
; ZDINX32-NEXT:    lw a1, 120(a0)
; ZDINX32-NEXT:    lw a0, 124(a0)
; ZDINX32-NEXT:    sw a0, 72(sp)
; ZDINX32-NEXT:    sw a1, 68(sp)
; ZDINX32-NEXT:    sw a2, 64(sp)
; ZDINX32-NEXT:    sw a3, 60(sp)
; ZDINX32-NEXT:    sw a4, 56(sp)
; ZDINX32-NEXT:    sw ra, 52(sp)
; ZDINX32-NEXT:    sw s11, 48(sp)
; ZDINX32-NEXT:    sw s10, 44(sp)
; ZDINX32-NEXT:    sw s9, 40(sp)
; ZDINX32-NEXT:    sw s8, 36(sp)
; ZDINX32-NEXT:    sw s7, 32(sp)
; ZDINX32-NEXT:    sw s6, 28(sp)
; ZDINX32-NEXT:    sw s5, 24(sp)
; ZDINX32-NEXT:    sw s4, 20(sp)
; ZDINX32-NEXT:    sw s3, 16(sp)
; ZDINX32-NEXT:    sw s2, 12(sp)
; ZDINX32-NEXT:    sw s1, 8(sp)
; ZDINX32-NEXT:    sw s0, 4(sp)
; ZDINX32-NEXT:    sw t1, 0(sp)
; ZDINX32-NEXT:    mv a0, t0
; ZDINX32-NEXT:    lw a1, 88(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw a2, 84(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw a3, 80(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw a4, 76(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    call callee_half_32
; ZDINX32-NEXT:    lui a1, 1048560
; ZDINX32-NEXT:    or a0, a0, a1
; ZDINX32-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    addi sp, sp, 144
; ZDINX32-NEXT:    ret
;
; ZDINX64-LABEL: caller_half_32:
; ZDINX64:       # %bb.0:
; ZDINX64-NEXT:    addi sp, sp, -288
; ZDINX64-NEXT:    sd ra, 280(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s0, 272(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s1, 264(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s2, 256(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s3, 248(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s4, 240(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s5, 232(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s6, 224(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s7, 216(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s8, 208(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s9, 200(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s10, 192(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s11, 184(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    ld t0, 0(a0)
; ZDINX64-NEXT:    ld a1, 8(a0)
; ZDINX64-NEXT:    sd a1, 176(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    ld a1, 16(a0)
; ZDINX64-NEXT:    sd a1, 168(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    ld a1, 24(a0)
; ZDINX64-NEXT:    sd a1, 160(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    ld a1, 32(a0)
; ZDINX64-NEXT:    sd a1, 152(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    ld a5, 40(a0)
; ZDINX64-NEXT:    ld a6, 48(a0)
; ZDINX64-NEXT:    ld a7, 56(a0)
; ZDINX64-NEXT:    ld t2, 64(a0)
; ZDINX64-NEXT:    ld t3, 72(a0)
; ZDINX64-NEXT:    ld t4, 80(a0)
; ZDINX64-NEXT:    ld t5, 88(a0)
; ZDINX64-NEXT:    ld t6, 96(a0)
; ZDINX64-NEXT:    ld t1, 104(a0)
; ZDINX64-NEXT:    ld s0, 112(a0)
; ZDINX64-NEXT:    ld s1, 120(a0)
; ZDINX64-NEXT:    ld s2, 128(a0)
; ZDINX64-NEXT:    ld s3, 136(a0)
; ZDINX64-NEXT:    ld s4, 144(a0)
; ZDINX64-NEXT:    ld s5, 152(a0)
; ZDINX64-NEXT:    ld s6, 160(a0)
; ZDINX64-NEXT:    ld s7, 168(a0)
; ZDINX64-NEXT:    ld s8, 176(a0)
; ZDINX64-NEXT:    ld s9, 184(a0)
; ZDINX64-NEXT:    ld s10, 192(a0)
; ZDINX64-NEXT:    ld s11, 200(a0)
; ZDINX64-NEXT:    ld ra, 208(a0)
; ZDINX64-NEXT:    ld a4, 216(a0)
; ZDINX64-NEXT:    ld a3, 224(a0)
; ZDINX64-NEXT:    ld a2, 232(a0)
; ZDINX64-NEXT:    ld a1, 240(a0)
; ZDINX64-NEXT:    ld a0, 248(a0)
; ZDINX64-NEXT:    sd a0, 144(sp)
; ZDINX64-NEXT:    sd a1, 136(sp)
; ZDINX64-NEXT:    sd a2, 128(sp)
; ZDINX64-NEXT:    sd a3, 120(sp)
; ZDINX64-NEXT:    sd a4, 112(sp)
; ZDINX64-NEXT:    sd ra, 104(sp)
; ZDINX64-NEXT:    sd s11, 96(sp)
; ZDINX64-NEXT:    sd s10, 88(sp)
; ZDINX64-NEXT:    sd s9, 80(sp)
; ZDINX64-NEXT:    sd s8, 72(sp)
; ZDINX64-NEXT:    sd s7, 64(sp)
; ZDINX64-NEXT:    sd s6, 56(sp)
; ZDINX64-NEXT:    sd s5, 48(sp)
; ZDINX64-NEXT:    sd s4, 40(sp)
; ZDINX64-NEXT:    sd s3, 32(sp)
; ZDINX64-NEXT:    sd s2, 24(sp)
; ZDINX64-NEXT:    sd s1, 16(sp)
; ZDINX64-NEXT:    sd s0, 8(sp)
; ZDINX64-NEXT:    sd t1, 0(sp)
; ZDINX64-NEXT:    mv a0, t0
; ZDINX64-NEXT:    ld a1, 176(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld a2, 168(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld a3, 160(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld a4, 152(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    call callee_half_32
; ZDINX64-NEXT:    lui a1, 1048560
; ZDINX64-NEXT:    or a0, a0, a1
; ZDINX64-NEXT:    ld ra, 280(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s0, 272(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s1, 264(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s2, 256(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s3, 248(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s4, 240(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s5, 232(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s6, 224(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s7, 216(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s8, 208(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s9, 200(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s10, 192(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s11, 184(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    addi sp, sp, 288
; ZDINX64-NEXT:    ret
	%C = call fastcc half @callee_half_32(<32 x half> %A)
	ret half %C
}

define fastcc float @callee_float_32(<32 x float> %A) nounwind {
; ZHINX32-LABEL: callee_float_32:
; ZHINX32:       # %bb.0:
; ZHINX32-NEXT:    ret
;
; ZHINX64-LABEL: callee_float_32:
; ZHINX64:       # %bb.0:
; ZHINX64-NEXT:    ret
;
; ZFINX32-LABEL: callee_float_32:
; ZFINX32:       # %bb.0:
; ZFINX32-NEXT:    ret
;
; ZFINX64-LABEL: callee_float_32:
; ZFINX64:       # %bb.0:
; ZFINX64-NEXT:    ret
;
; ZDINX32-LABEL: callee_float_32:
; ZDINX32:       # %bb.0:
; ZDINX32-NEXT:    ret
;
; ZDINX64-LABEL: callee_float_32:
; ZDINX64:       # %bb.0:
; ZDINX64-NEXT:    ret
	%B = extractelement <32 x float> %A, i32 0
	ret float %B
}

define float @caller_float_32(<32 x float> %A) nounwind {
; ZHINX32-LABEL: caller_float_32:
; ZHINX32:       # %bb.0:
; ZHINX32-NEXT:    addi sp, sp, -144
; ZHINX32-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    lw t0, 144(sp)
; ZHINX32-NEXT:    sw t0, 88(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    lw t0, 148(sp)
; ZHINX32-NEXT:    sw t0, 84(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    lw t0, 152(sp)
; ZHINX32-NEXT:    sw t0, 80(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    lw t0, 156(sp)
; ZHINX32-NEXT:    sw t0, 76(sp) # 4-byte Folded Spill
; ZHINX32-NEXT:    lw t6, 160(sp)
; ZHINX32-NEXT:    lw t5, 164(sp)
; ZHINX32-NEXT:    lw t4, 168(sp)
; ZHINX32-NEXT:    lw s0, 172(sp)
; ZHINX32-NEXT:    lw s1, 176(sp)
; ZHINX32-NEXT:    lw s2, 180(sp)
; ZHINX32-NEXT:    lw s3, 184(sp)
; ZHINX32-NEXT:    lw s4, 188(sp)
; ZHINX32-NEXT:    lw s5, 192(sp)
; ZHINX32-NEXT:    lw s6, 196(sp)
; ZHINX32-NEXT:    lw s7, 200(sp)
; ZHINX32-NEXT:    lw s8, 204(sp)
; ZHINX32-NEXT:    lw s9, 208(sp)
; ZHINX32-NEXT:    lw s10, 212(sp)
; ZHINX32-NEXT:    lw s11, 216(sp)
; ZHINX32-NEXT:    lw ra, 220(sp)
; ZHINX32-NEXT:    lw t3, 224(sp)
; ZHINX32-NEXT:    lw t2, 228(sp)
; ZHINX32-NEXT:    lw t1, 232(sp)
; ZHINX32-NEXT:    lw t0, 236(sp)
; ZHINX32-NEXT:    sw t0, 72(sp)
; ZHINX32-NEXT:    sw t1, 68(sp)
; ZHINX32-NEXT:    sw t2, 64(sp)
; ZHINX32-NEXT:    sw t3, 60(sp)
; ZHINX32-NEXT:    sw ra, 56(sp)
; ZHINX32-NEXT:    sw s11, 52(sp)
; ZHINX32-NEXT:    sw s10, 48(sp)
; ZHINX32-NEXT:    sw s9, 44(sp)
; ZHINX32-NEXT:    sw s8, 40(sp)
; ZHINX32-NEXT:    sw s7, 36(sp)
; ZHINX32-NEXT:    sw s6, 32(sp)
; ZHINX32-NEXT:    sw s5, 28(sp)
; ZHINX32-NEXT:    sw s4, 24(sp)
; ZHINX32-NEXT:    sw s3, 20(sp)
; ZHINX32-NEXT:    sw s2, 16(sp)
; ZHINX32-NEXT:    sw s1, 12(sp)
; ZHINX32-NEXT:    sw s0, 8(sp)
; ZHINX32-NEXT:    sw t4, 4(sp)
; ZHINX32-NEXT:    sw t5, 0(sp)
; ZHINX32-NEXT:    lw t2, 88(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw t3, 84(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw t4, 80(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw t5, 76(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    call callee_float_32
; ZHINX32-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; ZHINX32-NEXT:    addi sp, sp, 144
; ZHINX32-NEXT:    ret
;
; ZHINX64-LABEL: caller_float_32:
; ZHINX64:       # %bb.0:
; ZHINX64-NEXT:    addi sp, sp, -224
; ZHINX64-NEXT:    sd ra, 216(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s0, 208(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s1, 200(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s2, 192(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s3, 184(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s4, 176(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s5, 168(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s6, 160(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s7, 152(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s8, 144(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s9, 136(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s10, 128(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    sd s11, 120(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    lw t0, 224(sp)
; ZHINX64-NEXT:    sd t0, 112(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    lw t0, 232(sp)
; ZHINX64-NEXT:    sd t0, 104(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    lw t0, 240(sp)
; ZHINX64-NEXT:    sd t0, 96(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    lw t0, 248(sp)
; ZHINX64-NEXT:    sd t0, 88(sp) # 8-byte Folded Spill
; ZHINX64-NEXT:    lw t6, 256(sp)
; ZHINX64-NEXT:    lw t5, 264(sp)
; ZHINX64-NEXT:    lw t4, 272(sp)
; ZHINX64-NEXT:    lw s0, 280(sp)
; ZHINX64-NEXT:    lw s1, 288(sp)
; ZHINX64-NEXT:    lw s2, 296(sp)
; ZHINX64-NEXT:    lw s3, 304(sp)
; ZHINX64-NEXT:    lw s4, 312(sp)
; ZHINX64-NEXT:    lw s5, 320(sp)
; ZHINX64-NEXT:    lw s6, 328(sp)
; ZHINX64-NEXT:    lw s7, 336(sp)
; ZHINX64-NEXT:    lw s8, 344(sp)
; ZHINX64-NEXT:    lw s9, 352(sp)
; ZHINX64-NEXT:    lw s10, 360(sp)
; ZHINX64-NEXT:    lw s11, 368(sp)
; ZHINX64-NEXT:    lw ra, 376(sp)
; ZHINX64-NEXT:    lw t3, 384(sp)
; ZHINX64-NEXT:    lw t2, 392(sp)
; ZHINX64-NEXT:    lw t1, 400(sp)
; ZHINX64-NEXT:    lw t0, 408(sp)
; ZHINX64-NEXT:    sw t0, 72(sp)
; ZHINX64-NEXT:    sw t1, 68(sp)
; ZHINX64-NEXT:    sw t2, 64(sp)
; ZHINX64-NEXT:    sw t3, 60(sp)
; ZHINX64-NEXT:    sw ra, 56(sp)
; ZHINX64-NEXT:    sw s11, 52(sp)
; ZHINX64-NEXT:    sw s10, 48(sp)
; ZHINX64-NEXT:    sw s9, 44(sp)
; ZHINX64-NEXT:    sw s8, 40(sp)
; ZHINX64-NEXT:    sw s7, 36(sp)
; ZHINX64-NEXT:    sw s6, 32(sp)
; ZHINX64-NEXT:    sw s5, 28(sp)
; ZHINX64-NEXT:    sw s4, 24(sp)
; ZHINX64-NEXT:    sw s3, 20(sp)
; ZHINX64-NEXT:    sw s2, 16(sp)
; ZHINX64-NEXT:    sw s1, 12(sp)
; ZHINX64-NEXT:    sw s0, 8(sp)
; ZHINX64-NEXT:    sw t4, 4(sp)
; ZHINX64-NEXT:    sw t5, 0(sp)
; ZHINX64-NEXT:    ld t2, 112(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld t3, 104(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld t4, 96(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld t5, 88(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    call callee_float_32
; ZHINX64-NEXT:    ld ra, 216(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s0, 208(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s1, 200(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s2, 192(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s3, 184(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s4, 176(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s5, 168(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s6, 160(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s7, 152(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s8, 144(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s9, 136(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s10, 128(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    ld s11, 120(sp) # 8-byte Folded Reload
; ZHINX64-NEXT:    addi sp, sp, 224
; ZHINX64-NEXT:    ret
;
; ZFINX32-LABEL: caller_float_32:
; ZFINX32:       # %bb.0:
; ZFINX32-NEXT:    addi sp, sp, -144
; ZFINX32-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    lw t0, 144(sp)
; ZFINX32-NEXT:    sw t0, 88(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    lw t0, 148(sp)
; ZFINX32-NEXT:    sw t0, 84(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    lw t0, 152(sp)
; ZFINX32-NEXT:    sw t0, 80(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    lw t0, 156(sp)
; ZFINX32-NEXT:    sw t0, 76(sp) # 4-byte Folded Spill
; ZFINX32-NEXT:    lw t6, 160(sp)
; ZFINX32-NEXT:    lw t5, 164(sp)
; ZFINX32-NEXT:    lw t4, 168(sp)
; ZFINX32-NEXT:    lw s0, 172(sp)
; ZFINX32-NEXT:    lw s1, 176(sp)
; ZFINX32-NEXT:    lw s2, 180(sp)
; ZFINX32-NEXT:    lw s3, 184(sp)
; ZFINX32-NEXT:    lw s4, 188(sp)
; ZFINX32-NEXT:    lw s5, 192(sp)
; ZFINX32-NEXT:    lw s6, 196(sp)
; ZFINX32-NEXT:    lw s7, 200(sp)
; ZFINX32-NEXT:    lw s8, 204(sp)
; ZFINX32-NEXT:    lw s9, 208(sp)
; ZFINX32-NEXT:    lw s10, 212(sp)
; ZFINX32-NEXT:    lw s11, 216(sp)
; ZFINX32-NEXT:    lw ra, 220(sp)
; ZFINX32-NEXT:    lw t3, 224(sp)
; ZFINX32-NEXT:    lw t2, 228(sp)
; ZFINX32-NEXT:    lw t1, 232(sp)
; ZFINX32-NEXT:    lw t0, 236(sp)
; ZFINX32-NEXT:    sw t0, 72(sp)
; ZFINX32-NEXT:    sw t1, 68(sp)
; ZFINX32-NEXT:    sw t2, 64(sp)
; ZFINX32-NEXT:    sw t3, 60(sp)
; ZFINX32-NEXT:    sw ra, 56(sp)
; ZFINX32-NEXT:    sw s11, 52(sp)
; ZFINX32-NEXT:    sw s10, 48(sp)
; ZFINX32-NEXT:    sw s9, 44(sp)
; ZFINX32-NEXT:    sw s8, 40(sp)
; ZFINX32-NEXT:    sw s7, 36(sp)
; ZFINX32-NEXT:    sw s6, 32(sp)
; ZFINX32-NEXT:    sw s5, 28(sp)
; ZFINX32-NEXT:    sw s4, 24(sp)
; ZFINX32-NEXT:    sw s3, 20(sp)
; ZFINX32-NEXT:    sw s2, 16(sp)
; ZFINX32-NEXT:    sw s1, 12(sp)
; ZFINX32-NEXT:    sw s0, 8(sp)
; ZFINX32-NEXT:    sw t4, 4(sp)
; ZFINX32-NEXT:    sw t5, 0(sp)
; ZFINX32-NEXT:    lw t2, 88(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw t3, 84(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw t4, 80(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw t5, 76(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    call callee_float_32
; ZFINX32-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; ZFINX32-NEXT:    addi sp, sp, 144
; ZFINX32-NEXT:    ret
;
; ZFINX64-LABEL: caller_float_32:
; ZFINX64:       # %bb.0:
; ZFINX64-NEXT:    addi sp, sp, -224
; ZFINX64-NEXT:    sd ra, 216(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s0, 208(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s1, 200(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s2, 192(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s3, 184(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s4, 176(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s5, 168(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s6, 160(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s7, 152(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s8, 144(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s9, 136(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s10, 128(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    sd s11, 120(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    lw t0, 224(sp)
; ZFINX64-NEXT:    sd t0, 112(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    lw t0, 232(sp)
; ZFINX64-NEXT:    sd t0, 104(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    lw t0, 240(sp)
; ZFINX64-NEXT:    sd t0, 96(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    lw t0, 248(sp)
; ZFINX64-NEXT:    sd t0, 88(sp) # 8-byte Folded Spill
; ZFINX64-NEXT:    lw t6, 256(sp)
; ZFINX64-NEXT:    lw t5, 264(sp)
; ZFINX64-NEXT:    lw t4, 272(sp)
; ZFINX64-NEXT:    lw s0, 280(sp)
; ZFINX64-NEXT:    lw s1, 288(sp)
; ZFINX64-NEXT:    lw s2, 296(sp)
; ZFINX64-NEXT:    lw s3, 304(sp)
; ZFINX64-NEXT:    lw s4, 312(sp)
; ZFINX64-NEXT:    lw s5, 320(sp)
; ZFINX64-NEXT:    lw s6, 328(sp)
; ZFINX64-NEXT:    lw s7, 336(sp)
; ZFINX64-NEXT:    lw s8, 344(sp)
; ZFINX64-NEXT:    lw s9, 352(sp)
; ZFINX64-NEXT:    lw s10, 360(sp)
; ZFINX64-NEXT:    lw s11, 368(sp)
; ZFINX64-NEXT:    lw ra, 376(sp)
; ZFINX64-NEXT:    lw t3, 384(sp)
; ZFINX64-NEXT:    lw t2, 392(sp)
; ZFINX64-NEXT:    lw t1, 400(sp)
; ZFINX64-NEXT:    lw t0, 408(sp)
; ZFINX64-NEXT:    sw t0, 72(sp)
; ZFINX64-NEXT:    sw t1, 68(sp)
; ZFINX64-NEXT:    sw t2, 64(sp)
; ZFINX64-NEXT:    sw t3, 60(sp)
; ZFINX64-NEXT:    sw ra, 56(sp)
; ZFINX64-NEXT:    sw s11, 52(sp)
; ZFINX64-NEXT:    sw s10, 48(sp)
; ZFINX64-NEXT:    sw s9, 44(sp)
; ZFINX64-NEXT:    sw s8, 40(sp)
; ZFINX64-NEXT:    sw s7, 36(sp)
; ZFINX64-NEXT:    sw s6, 32(sp)
; ZFINX64-NEXT:    sw s5, 28(sp)
; ZFINX64-NEXT:    sw s4, 24(sp)
; ZFINX64-NEXT:    sw s3, 20(sp)
; ZFINX64-NEXT:    sw s2, 16(sp)
; ZFINX64-NEXT:    sw s1, 12(sp)
; ZFINX64-NEXT:    sw s0, 8(sp)
; ZFINX64-NEXT:    sw t4, 4(sp)
; ZFINX64-NEXT:    sw t5, 0(sp)
; ZFINX64-NEXT:    ld t2, 112(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld t3, 104(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld t4, 96(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld t5, 88(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    call callee_float_32
; ZFINX64-NEXT:    ld ra, 216(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s0, 208(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s1, 200(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s2, 192(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s3, 184(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s4, 176(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s5, 168(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s6, 160(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s7, 152(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s8, 144(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s9, 136(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s10, 128(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    ld s11, 120(sp) # 8-byte Folded Reload
; ZFINX64-NEXT:    addi sp, sp, 224
; ZFINX64-NEXT:    ret
;
; ZDINX32-LABEL: caller_float_32:
; ZDINX32:       # %bb.0:
; ZDINX32-NEXT:    addi sp, sp, -144
; ZDINX32-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    lw t0, 144(sp)
; ZDINX32-NEXT:    sw t0, 88(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    lw t0, 148(sp)
; ZDINX32-NEXT:    sw t0, 84(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    lw t0, 152(sp)
; ZDINX32-NEXT:    sw t0, 80(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    lw t0, 156(sp)
; ZDINX32-NEXT:    sw t0, 76(sp) # 4-byte Folded Spill
; ZDINX32-NEXT:    lw t6, 160(sp)
; ZDINX32-NEXT:    lw t5, 164(sp)
; ZDINX32-NEXT:    lw t4, 168(sp)
; ZDINX32-NEXT:    lw s0, 172(sp)
; ZDINX32-NEXT:    lw s1, 176(sp)
; ZDINX32-NEXT:    lw s2, 180(sp)
; ZDINX32-NEXT:    lw s3, 184(sp)
; ZDINX32-NEXT:    lw s4, 188(sp)
; ZDINX32-NEXT:    lw s5, 192(sp)
; ZDINX32-NEXT:    lw s6, 196(sp)
; ZDINX32-NEXT:    lw s7, 200(sp)
; ZDINX32-NEXT:    lw s8, 204(sp)
; ZDINX32-NEXT:    lw s9, 208(sp)
; ZDINX32-NEXT:    lw s10, 212(sp)
; ZDINX32-NEXT:    lw s11, 216(sp)
; ZDINX32-NEXT:    lw ra, 220(sp)
; ZDINX32-NEXT:    lw t3, 224(sp)
; ZDINX32-NEXT:    lw t2, 228(sp)
; ZDINX32-NEXT:    lw t1, 232(sp)
; ZDINX32-NEXT:    lw t0, 236(sp)
; ZDINX32-NEXT:    sw t0, 72(sp)
; ZDINX32-NEXT:    sw t1, 68(sp)
; ZDINX32-NEXT:    sw t2, 64(sp)
; ZDINX32-NEXT:    sw t3, 60(sp)
; ZDINX32-NEXT:    sw ra, 56(sp)
; ZDINX32-NEXT:    sw s11, 52(sp)
; ZDINX32-NEXT:    sw s10, 48(sp)
; ZDINX32-NEXT:    sw s9, 44(sp)
; ZDINX32-NEXT:    sw s8, 40(sp)
; ZDINX32-NEXT:    sw s7, 36(sp)
; ZDINX32-NEXT:    sw s6, 32(sp)
; ZDINX32-NEXT:    sw s5, 28(sp)
; ZDINX32-NEXT:    sw s4, 24(sp)
; ZDINX32-NEXT:    sw s3, 20(sp)
; ZDINX32-NEXT:    sw s2, 16(sp)
; ZDINX32-NEXT:    sw s1, 12(sp)
; ZDINX32-NEXT:    sw s0, 8(sp)
; ZDINX32-NEXT:    sw t4, 4(sp)
; ZDINX32-NEXT:    sw t5, 0(sp)
; ZDINX32-NEXT:    lw t2, 88(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw t3, 84(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw t4, 80(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw t5, 76(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    call callee_float_32
; ZDINX32-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; ZDINX32-NEXT:    addi sp, sp, 144
; ZDINX32-NEXT:    ret
;
; ZDINX64-LABEL: caller_float_32:
; ZDINX64:       # %bb.0:
; ZDINX64-NEXT:    addi sp, sp, -224
; ZDINX64-NEXT:    sd ra, 216(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s0, 208(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s1, 200(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s2, 192(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s3, 184(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s4, 176(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s5, 168(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s6, 160(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s7, 152(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s8, 144(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s9, 136(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s10, 128(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    sd s11, 120(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    lw t0, 224(sp)
; ZDINX64-NEXT:    sd t0, 112(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    lw t0, 232(sp)
; ZDINX64-NEXT:    sd t0, 104(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    lw t0, 240(sp)
; ZDINX64-NEXT:    sd t0, 96(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    lw t0, 248(sp)
; ZDINX64-NEXT:    sd t0, 88(sp) # 8-byte Folded Spill
; ZDINX64-NEXT:    lw t6, 256(sp)
; ZDINX64-NEXT:    lw t5, 264(sp)
; ZDINX64-NEXT:    lw t4, 272(sp)
; ZDINX64-NEXT:    lw s0, 280(sp)
; ZDINX64-NEXT:    lw s1, 288(sp)
; ZDINX64-NEXT:    lw s2, 296(sp)
; ZDINX64-NEXT:    lw s3, 304(sp)
; ZDINX64-NEXT:    lw s4, 312(sp)
; ZDINX64-NEXT:    lw s5, 320(sp)
; ZDINX64-NEXT:    lw s6, 328(sp)
; ZDINX64-NEXT:    lw s7, 336(sp)
; ZDINX64-NEXT:    lw s8, 344(sp)
; ZDINX64-NEXT:    lw s9, 352(sp)
; ZDINX64-NEXT:    lw s10, 360(sp)
; ZDINX64-NEXT:    lw s11, 368(sp)
; ZDINX64-NEXT:    lw ra, 376(sp)
; ZDINX64-NEXT:    lw t3, 384(sp)
; ZDINX64-NEXT:    lw t2, 392(sp)
; ZDINX64-NEXT:    lw t1, 400(sp)
; ZDINX64-NEXT:    lw t0, 408(sp)
; ZDINX64-NEXT:    sw t0, 72(sp)
; ZDINX64-NEXT:    sw t1, 68(sp)
; ZDINX64-NEXT:    sw t2, 64(sp)
; ZDINX64-NEXT:    sw t3, 60(sp)
; ZDINX64-NEXT:    sw ra, 56(sp)
; ZDINX64-NEXT:    sw s11, 52(sp)
; ZDINX64-NEXT:    sw s10, 48(sp)
; ZDINX64-NEXT:    sw s9, 44(sp)
; ZDINX64-NEXT:    sw s8, 40(sp)
; ZDINX64-NEXT:    sw s7, 36(sp)
; ZDINX64-NEXT:    sw s6, 32(sp)
; ZDINX64-NEXT:    sw s5, 28(sp)
; ZDINX64-NEXT:    sw s4, 24(sp)
; ZDINX64-NEXT:    sw s3, 20(sp)
; ZDINX64-NEXT:    sw s2, 16(sp)
; ZDINX64-NEXT:    sw s1, 12(sp)
; ZDINX64-NEXT:    sw s0, 8(sp)
; ZDINX64-NEXT:    sw t4, 4(sp)
; ZDINX64-NEXT:    sw t5, 0(sp)
; ZDINX64-NEXT:    ld t2, 112(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld t3, 104(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld t4, 96(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld t5, 88(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    call callee_float_32
; ZDINX64-NEXT:    ld ra, 216(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s0, 208(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s1, 200(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s2, 192(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s3, 184(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s4, 176(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s5, 168(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s6, 160(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s7, 152(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s8, 144(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s9, 136(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s10, 128(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    ld s11, 120(sp) # 8-byte Folded Reload
; ZDINX64-NEXT:    addi sp, sp, 224
; ZDINX64-NEXT:    ret
	%C = call fastcc float @callee_float_32(<32 x float> %A)
	ret float %C
}

define fastcc double @callee_double_32(<32 x double> %A) nounwind {
; ZHINX32-LABEL: callee_double_32:
; ZHINX32:       # %bb.0:
; ZHINX32-NEXT:    ret
;
; ZHINX64-LABEL: callee_double_32:
; ZHINX64:       # %bb.0:
; ZHINX64-NEXT:    ret
;
; ZFINX32-LABEL: callee_double_32:
; ZFINX32:       # %bb.0:
; ZFINX32-NEXT:    ret
;
; ZFINX64-LABEL: callee_double_32:
; ZFINX64:       # %bb.0:
; ZFINX64-NEXT:    ret
;
; ZDINX32-LABEL: callee_double_32:
; ZDINX32:       # %bb.0:
; ZDINX32-NEXT:    addi sp, sp, -16
; ZDINX32-NEXT:    lw a0, 16(sp)
; ZDINX32-NEXT:    lw a1, 20(sp)
; ZDINX32-NEXT:    sw a0, 8(sp)
; ZDINX32-NEXT:    sw a1, 12(sp)
; ZDINX32-NEXT:    lw a0, 8(sp)
; ZDINX32-NEXT:    lw a1, 12(sp)
; ZDINX32-NEXT:    addi sp, sp, 16
; ZDINX32-NEXT:    ret
;
; ZDINX64-LABEL: callee_double_32:
; ZDINX64:       # %bb.0:
; ZDINX64-NEXT:    ret
	%B = extractelement <32 x double> %A, i32 0
	ret double %B
}
