// RUN: llvm-mc -triple=amdgcn -mcpu=tonga -show-encoding %s | FileCheck %s

v_cmp_class_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x20,0x7c]

v_cmp_class_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x20,0x7c]

v_cmp_class_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x20,0x7c]

v_cmp_class_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x20,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_class_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x20,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_class_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x21,0x7c]

v_cmpx_class_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x22,0x7c]

v_cmpx_class_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x22,0x7c]

v_cmpx_class_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x22,0x7c]

v_cmpx_class_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x22,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_class_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x22,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_class_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x23,0x7c]

v_cmp_class_f64 vcc, v[1:2], v2
// CHECK: [0x01,0x05,0x24,0x7c]

v_cmp_class_f64 vcc, v[254:255], v2
// CHECK: [0xfe,0x05,0x24,0x7c]

v_cmp_class_f64 vcc, s[2:3], v2
// CHECK: [0x02,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, s[4:5], v2
// CHECK: [0x04,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, s[100:101], v2
// CHECK: [0x64,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, flat_scratch, v2
// CHECK: [0x66,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, vcc, v2
// CHECK: [0x6a,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, tba, v2
// CHECK: [0x6c,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, tma, v2
// CHECK: [0x6e,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, ttmp[10:11], v2
// CHECK: [0x7a,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, exec, v2
// CHECK: [0x7e,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, 0, v2
// CHECK: [0x80,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, -1, v2
// CHECK: [0xc1,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x24,0x7c]

v_cmp_class_f64 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x24,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_class_f64 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x24,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_class_f64 vcc, v[1:2], v255
// CHECK: [0x01,0xff,0x25,0x7c]

v_cmpx_class_f64 vcc, v[1:2], v2
// CHECK: [0x01,0x05,0x26,0x7c]

v_cmpx_class_f64 vcc, v[254:255], v2
// CHECK: [0xfe,0x05,0x26,0x7c]

v_cmpx_class_f64 vcc, s[2:3], v2
// CHECK: [0x02,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, s[4:5], v2
// CHECK: [0x04,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, s[100:101], v2
// CHECK: [0x64,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, flat_scratch, v2
// CHECK: [0x66,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, vcc, v2
// CHECK: [0x6a,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, tba, v2
// CHECK: [0x6c,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, tma, v2
// CHECK: [0x6e,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, ttmp[10:11], v2
// CHECK: [0x7a,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, exec, v2
// CHECK: [0x7e,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, 0, v2
// CHECK: [0x80,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, -1, v2
// CHECK: [0xc1,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x26,0x7c]

v_cmpx_class_f64 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x26,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_class_f64 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x26,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_class_f64 vcc, v[1:2], v255
// CHECK: [0x01,0xff,0x27,0x7c]

v_cmp_class_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x28,0x7c]

v_cmp_class_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x28,0x7c]

v_cmp_class_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x28,0x7c]

v_cmp_class_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x28,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_class_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x28,0x7c,0x56,0x34,0x00,0x00]

v_cmp_class_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x29,0x7c]

v_cmpx_class_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x2a,0x7c]

v_cmpx_class_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x2a,0x7c]

v_cmpx_class_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x2a,0x7c]

v_cmpx_class_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x2a,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_class_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x2a,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_class_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x2b,0x7c]

v_cmp_f_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x40,0x7c]

v_cmp_f_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x40,0x7c]

v_cmp_f_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x40,0x7c]

v_cmp_f_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x40,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_f_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x40,0x7c,0x56,0x34,0x00,0x00]

v_cmp_f_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x41,0x7c]

v_cmp_lt_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x42,0x7c]

v_cmp_lt_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x42,0x7c]

v_cmp_lt_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x42,0x7c]

v_cmp_lt_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x42,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_lt_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x42,0x7c,0x56,0x34,0x00,0x00]

v_cmp_lt_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x43,0x7c]

v_cmp_eq_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x44,0x7c]

v_cmp_eq_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x44,0x7c]

v_cmp_eq_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x44,0x7c]

v_cmp_eq_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x44,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_eq_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x44,0x7c,0x56,0x34,0x00,0x00]

v_cmp_eq_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x45,0x7c]

v_cmp_le_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x46,0x7c]

v_cmp_le_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x46,0x7c]

v_cmp_le_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x46,0x7c]

v_cmp_le_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x46,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_le_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x46,0x7c,0x56,0x34,0x00,0x00]

v_cmp_le_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x47,0x7c]

v_cmp_gt_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x48,0x7c]

v_cmp_gt_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x48,0x7c]

v_cmp_gt_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x48,0x7c]

v_cmp_gt_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x48,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_gt_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x48,0x7c,0x56,0x34,0x00,0x00]

v_cmp_gt_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x49,0x7c]

v_cmp_lg_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x4a,0x7c]

v_cmp_lg_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x4a,0x7c]

v_cmp_lg_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x4a,0x7c]

v_cmp_lg_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x4a,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_lg_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x4a,0x7c,0x56,0x34,0x00,0x00]

v_cmp_lg_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x4b,0x7c]

v_cmp_ge_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x4c,0x7c]

v_cmp_ge_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x4c,0x7c]

v_cmp_ge_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x4c,0x7c]

v_cmp_ge_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x4c,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_ge_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x4c,0x7c,0x56,0x34,0x00,0x00]

v_cmp_ge_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x4d,0x7c]

v_cmp_o_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x4e,0x7c]

v_cmp_o_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x4e,0x7c]

v_cmp_o_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x4e,0x7c]

v_cmp_o_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x4e,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_o_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x4e,0x7c,0x56,0x34,0x00,0x00]

v_cmp_o_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x4f,0x7c]

v_cmp_u_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x50,0x7c]

v_cmp_u_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x50,0x7c]

v_cmp_u_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x50,0x7c]

v_cmp_u_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x50,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_u_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x50,0x7c,0x56,0x34,0x00,0x00]

v_cmp_u_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x51,0x7c]

v_cmp_nge_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x52,0x7c]

v_cmp_nge_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x52,0x7c]

v_cmp_nge_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x52,0x7c]

v_cmp_nge_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x52,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_nge_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x52,0x7c,0x56,0x34,0x00,0x00]

v_cmp_nge_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x53,0x7c]

v_cmp_nlg_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x54,0x7c]

v_cmp_nlg_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x54,0x7c]

v_cmp_nlg_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x54,0x7c]

v_cmp_nlg_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x54,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_nlg_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x54,0x7c,0x56,0x34,0x00,0x00]

v_cmp_nlg_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x55,0x7c]

v_cmp_ngt_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x56,0x7c]

v_cmp_ngt_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x56,0x7c]

v_cmp_ngt_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x56,0x7c]

v_cmp_ngt_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x56,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_ngt_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x56,0x7c,0x56,0x34,0x00,0x00]

v_cmp_ngt_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x57,0x7c]

v_cmp_nle_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x58,0x7c]

v_cmp_nle_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x58,0x7c]

v_cmp_nle_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x58,0x7c]

v_cmp_nle_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x58,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_nle_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x58,0x7c,0x56,0x34,0x00,0x00]

v_cmp_nle_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x59,0x7c]

v_cmp_neq_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x5a,0x7c]

v_cmp_neq_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x5a,0x7c]

v_cmp_neq_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x5a,0x7c]

v_cmp_neq_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x5a,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_neq_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x5a,0x7c,0x56,0x34,0x00,0x00]

v_cmp_neq_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x5b,0x7c]

v_cmp_nlt_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x5c,0x7c]

v_cmp_nlt_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x5c,0x7c]

v_cmp_nlt_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x5c,0x7c]

v_cmp_nlt_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x5c,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_nlt_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x5c,0x7c,0x56,0x34,0x00,0x00]

v_cmp_nlt_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x5d,0x7c]

v_cmp_tru_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x5e,0x7c]

v_cmp_tru_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x5e,0x7c]

v_cmp_tru_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x5e,0x7c]

v_cmp_tru_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x5e,0x7c,0x0b,0xfe,0x00,0x00]

v_cmp_tru_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x5e,0x7c,0x56,0x34,0x00,0x00]

v_cmp_tru_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x5f,0x7c]

v_cmpx_f_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x60,0x7c]

v_cmpx_f_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x60,0x7c]

v_cmpx_f_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x60,0x7c]

v_cmpx_f_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x60,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_f_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x60,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_f_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x61,0x7c]

v_cmpx_lt_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x62,0x7c]

v_cmpx_lt_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x62,0x7c]

v_cmpx_lt_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x62,0x7c]

v_cmpx_lt_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x62,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_lt_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x62,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_lt_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x63,0x7c]

v_cmpx_eq_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x64,0x7c]

v_cmpx_eq_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x64,0x7c]

v_cmpx_eq_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x64,0x7c]

v_cmpx_eq_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x64,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_eq_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x64,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_eq_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x65,0x7c]

v_cmpx_le_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x66,0x7c]

v_cmpx_le_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x66,0x7c]

v_cmpx_le_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x66,0x7c]

v_cmpx_le_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x66,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_le_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x66,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_le_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x67,0x7c]

v_cmpx_gt_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x68,0x7c]

v_cmpx_gt_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x68,0x7c]

v_cmpx_gt_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x68,0x7c]

v_cmpx_gt_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x68,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_gt_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x68,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_gt_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x69,0x7c]

v_cmpx_lg_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x6a,0x7c]

v_cmpx_lg_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x6a,0x7c]

v_cmpx_lg_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x6a,0x7c]

v_cmpx_lg_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x6a,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_lg_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x6a,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_lg_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x6b,0x7c]

v_cmpx_ge_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x6c,0x7c]

v_cmpx_ge_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x6c,0x7c]

v_cmpx_ge_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x6c,0x7c]

v_cmpx_ge_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x6c,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_ge_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x6c,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_ge_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x6d,0x7c]

v_cmpx_o_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x6e,0x7c]

v_cmpx_o_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x6e,0x7c]

v_cmpx_o_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x6e,0x7c]

v_cmpx_o_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x6e,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_o_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x6e,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_o_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x6f,0x7c]

v_cmpx_u_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x70,0x7c]

v_cmpx_u_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x70,0x7c]

v_cmpx_u_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x70,0x7c]

v_cmpx_u_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x70,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_u_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x70,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_u_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x71,0x7c]

v_cmpx_nge_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x72,0x7c]

v_cmpx_nge_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x72,0x7c]

v_cmpx_nge_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x72,0x7c]

v_cmpx_nge_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x72,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_nge_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x72,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_nge_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x73,0x7c]

v_cmpx_nlg_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x74,0x7c]

v_cmpx_nlg_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x74,0x7c]

v_cmpx_nlg_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x74,0x7c]

v_cmpx_nlg_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x74,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_nlg_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x74,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_nlg_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x75,0x7c]

v_cmpx_ngt_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x76,0x7c]

v_cmpx_ngt_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x76,0x7c]

v_cmpx_ngt_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x76,0x7c]

v_cmpx_ngt_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x76,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_ngt_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x76,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_ngt_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x77,0x7c]

v_cmpx_nle_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x78,0x7c]

v_cmpx_nle_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x78,0x7c]

v_cmpx_nle_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x78,0x7c]

v_cmpx_nle_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x78,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_nle_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x78,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_nle_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x79,0x7c]

v_cmpx_neq_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x7a,0x7c]

v_cmpx_neq_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x7a,0x7c]

v_cmpx_neq_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x7a,0x7c]

v_cmpx_neq_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x7a,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_neq_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x7a,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_neq_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x7b,0x7c]

v_cmpx_nlt_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x7c,0x7c]

v_cmpx_nlt_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x7c,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_nlt_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x7c,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_nlt_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x7d,0x7c]

v_cmpx_tru_f16 vcc, v1, v2
// CHECK: [0x01,0x05,0x7e,0x7c]

v_cmpx_tru_f16 vcc, v255, v2
// CHECK: [0xff,0x05,0x7e,0x7c]

v_cmpx_tru_f16 vcc, s1, v2
// CHECK: [0x01,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, s101, v2
// CHECK: [0x65,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, 0, v2
// CHECK: [0x80,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x7e,0x7c]

v_cmpx_tru_f16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x7e,0x7c,0x0b,0xfe,0x00,0x00]

v_cmpx_tru_f16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x7e,0x7c,0x56,0x34,0x00,0x00]

v_cmpx_tru_f16 vcc, v1, v255
// CHECK: [0x01,0xff,0x7f,0x7c]

v_cmp_f_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x80,0x7c]

v_cmp_f_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x80,0x7c]

v_cmp_f_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x80,0x7c]

v_cmp_f_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x80,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_f_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x80,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_f_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x81,0x7c]

v_cmp_lt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x82,0x7c]

v_cmp_lt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x82,0x7c]

v_cmp_lt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x82,0x7c]

v_cmp_lt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x82,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_lt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x82,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_lt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x83,0x7c]

v_cmp_eq_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x84,0x7c]

v_cmp_eq_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x84,0x7c]

v_cmp_eq_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x84,0x7c]

v_cmp_eq_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x84,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_eq_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x84,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_eq_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x85,0x7c]

v_cmp_le_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x86,0x7c]

v_cmp_le_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x86,0x7c]

v_cmp_le_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x86,0x7c]

v_cmp_le_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x86,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_le_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x86,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_le_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x87,0x7c]

v_cmp_gt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x88,0x7c]

v_cmp_gt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x88,0x7c]

v_cmp_gt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x88,0x7c]

v_cmp_gt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x88,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_gt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x88,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_gt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x89,0x7c]

v_cmp_lg_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x8a,0x7c]

v_cmp_lg_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x8a,0x7c]

v_cmp_lg_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x8a,0x7c]

v_cmp_lg_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x8a,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_lg_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x8a,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_lg_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x8b,0x7c]

v_cmp_ge_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x8c,0x7c]

v_cmp_ge_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x8c,0x7c]

v_cmp_ge_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x8c,0x7c]

v_cmp_ge_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x8c,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_ge_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x8c,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_ge_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x8d,0x7c]

v_cmp_o_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x8e,0x7c]

v_cmp_o_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x8e,0x7c]

v_cmp_o_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x8e,0x7c]

v_cmp_o_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x8e,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_o_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x8e,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_o_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x8f,0x7c]

v_cmp_u_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x90,0x7c]

v_cmp_u_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x90,0x7c]

v_cmp_u_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x90,0x7c]

v_cmp_u_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x90,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_u_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x90,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_u_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x91,0x7c]

v_cmp_nge_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x92,0x7c]

v_cmp_nge_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x92,0x7c]

v_cmp_nge_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x92,0x7c]

v_cmp_nge_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x92,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nge_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x92,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nge_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x93,0x7c]

v_cmp_nlg_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x94,0x7c]

v_cmp_nlg_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x94,0x7c]

v_cmp_nlg_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x94,0x7c]

v_cmp_nlg_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x94,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nlg_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x94,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nlg_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x95,0x7c]

v_cmp_ngt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x96,0x7c]

v_cmp_ngt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x96,0x7c]

v_cmp_ngt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x96,0x7c]

v_cmp_ngt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x96,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_ngt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x96,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_ngt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x97,0x7c]

v_cmp_nle_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x98,0x7c]

v_cmp_nle_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x98,0x7c]

v_cmp_nle_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x98,0x7c]

v_cmp_nle_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x98,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nle_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x98,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nle_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x99,0x7c]

v_cmp_neq_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x9a,0x7c]

v_cmp_neq_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x9a,0x7c]

v_cmp_neq_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x9a,0x7c]

v_cmp_neq_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x9a,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_neq_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x9a,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_neq_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x9b,0x7c]

v_cmp_nlt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x9c,0x7c]

v_cmp_nlt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x9c,0x7c]

v_cmp_nlt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x9c,0x7c]

v_cmp_nlt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x9c,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nlt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x9c,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nlt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x9d,0x7c]

v_cmp_tru_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x9e,0x7c]

v_cmp_tru_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x9e,0x7c]

v_cmp_tru_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x9e,0x7c]

v_cmp_tru_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x9e,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_tru_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x9e,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_tru_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x9f,0x7c]

v_cmpx_f_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa0,0x7c]

v_cmpx_f_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa0,0x7c]

v_cmpx_f_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa0,0x7c]

v_cmpx_f_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa0,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_f_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa0,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_f_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa1,0x7c]

v_cmpx_lt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa2,0x7c]

v_cmpx_lt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa2,0x7c]

v_cmpx_lt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa2,0x7c]

v_cmpx_lt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa2,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_lt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa2,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_lt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa3,0x7c]

v_cmpx_eq_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa4,0x7c]

v_cmpx_eq_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa4,0x7c]

v_cmpx_eq_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa4,0x7c]

v_cmpx_eq_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa4,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_eq_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa4,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_eq_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa5,0x7c]

v_cmpx_le_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa6,0x7c]

v_cmpx_le_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa6,0x7c]

v_cmpx_le_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa6,0x7c]

v_cmpx_le_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa6,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_le_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa6,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_le_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa7,0x7c]

v_cmpx_gt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa8,0x7c]

v_cmpx_gt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa8,0x7c]

v_cmpx_gt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa8,0x7c]

v_cmpx_gt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa8,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_gt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa8,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_gt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa9,0x7c]

v_cmpx_lg_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xaa,0x7c]

v_cmpx_lg_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xaa,0x7c]

v_cmpx_lg_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xaa,0x7c]

v_cmpx_lg_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xaa,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_lg_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xaa,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_lg_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xab,0x7c]

v_cmpx_ge_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xac,0x7c]

v_cmpx_ge_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xac,0x7c]

v_cmpx_ge_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xac,0x7c]

v_cmpx_ge_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xac,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_ge_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xac,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_ge_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xad,0x7c]

v_cmpx_o_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xae,0x7c]

v_cmpx_o_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xae,0x7c]

v_cmpx_o_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xae,0x7c]

v_cmpx_o_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xae,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_o_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xae,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_o_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xaf,0x7c]

v_cmpx_u_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb0,0x7c]

v_cmpx_u_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb0,0x7c]

v_cmpx_u_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb0,0x7c]

v_cmpx_u_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb0,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_u_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb0,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_u_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb1,0x7c]

v_cmpx_nge_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb2,0x7c]

v_cmpx_nge_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb2,0x7c]

v_cmpx_nge_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb2,0x7c]

v_cmpx_nge_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb2,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nge_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb2,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nge_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb3,0x7c]

v_cmpx_nlg_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb4,0x7c]

v_cmpx_nlg_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb4,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nlg_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb4,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nlg_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb5,0x7c]

v_cmpx_ngt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb6,0x7c]

v_cmpx_ngt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb6,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_ngt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb6,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_ngt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb7,0x7c]

v_cmpx_nle_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb8,0x7c]

v_cmpx_nle_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb8,0x7c]

v_cmpx_nle_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb8,0x7c]

v_cmpx_nle_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb8,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nle_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb8,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nle_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb9,0x7c]

v_cmpx_neq_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xba,0x7c]

v_cmpx_neq_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xba,0x7c]

v_cmpx_neq_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xba,0x7c]

v_cmpx_neq_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xba,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_neq_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xba,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_neq_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xbb,0x7c]

v_cmpx_nlt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xbc,0x7c]

v_cmpx_nlt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xbc,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nlt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xbc,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nlt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xbd,0x7c]

v_cmpx_tru_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xbe,0x7c]

v_cmpx_tru_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xbe,0x7c]

v_cmpx_tru_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, s101, v2
// CHECK: [0x65,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xbe,0x7c]

v_cmpx_tru_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xbe,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_tru_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xbe,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_tru_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xbf,0x7c]

v_cmp_f_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc0,0x7c]

v_cmp_f_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc0,0x7c]

v_cmp_f_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc0,0x7c]

v_cmp_f_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc0,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_f_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc0,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_f_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc1,0x7c]

v_cmp_lt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc2,0x7c]

v_cmp_lt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc2,0x7c]

v_cmp_lt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc2,0x7c]

v_cmp_lt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc2,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_lt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc2,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_lt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc3,0x7c]

v_cmp_eq_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc4,0x7c]

v_cmp_eq_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc4,0x7c]

v_cmp_eq_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc4,0x7c]

v_cmp_eq_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc4,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_eq_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc4,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_eq_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc5,0x7c]

v_cmp_le_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc6,0x7c]

v_cmp_le_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc6,0x7c]

v_cmp_le_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc6,0x7c]

v_cmp_le_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc6,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_le_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc6,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_le_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc7,0x7c]

v_cmp_gt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc8,0x7c]

v_cmp_gt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc8,0x7c]

v_cmp_gt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc8,0x7c]

v_cmp_gt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc8,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_gt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc8,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_gt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc9,0x7c]

v_cmp_lg_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xca,0x7c]

v_cmp_lg_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xca,0x7c]

v_cmp_lg_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xca,0x7c]

v_cmp_lg_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xca,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_lg_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xca,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_lg_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xcb,0x7c]

v_cmp_ge_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xcc,0x7c]

v_cmp_ge_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xcc,0x7c]

v_cmp_ge_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xcc,0x7c]

v_cmp_ge_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xcc,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_ge_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xcc,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_ge_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xcd,0x7c]

v_cmp_o_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xce,0x7c]

v_cmp_o_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xce,0x7c]

v_cmp_o_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xce,0x7c]

v_cmp_o_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xce,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_o_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xce,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_o_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xcf,0x7c]

v_cmp_u_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd0,0x7c]

v_cmp_u_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd0,0x7c]

v_cmp_u_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd0,0x7c]

v_cmp_u_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd0,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_u_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd0,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_u_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd1,0x7c]

v_cmp_nge_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd2,0x7c]

v_cmp_nge_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd2,0x7c]

v_cmp_nge_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd2,0x7c]

v_cmp_nge_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd2,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nge_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd2,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nge_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd3,0x7c]

v_cmp_nlg_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd4,0x7c]

v_cmp_nlg_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd4,0x7c]

v_cmp_nlg_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd4,0x7c]

v_cmp_nlg_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd4,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nlg_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd4,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nlg_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd5,0x7c]

v_cmp_ngt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd6,0x7c]

v_cmp_ngt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd6,0x7c]

v_cmp_ngt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd6,0x7c]

v_cmp_ngt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd6,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_ngt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd6,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_ngt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd7,0x7c]

v_cmp_nle_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd8,0x7c]

v_cmp_nle_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd8,0x7c]

v_cmp_nle_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd8,0x7c]

v_cmp_nle_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd8,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nle_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd8,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nle_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd9,0x7c]

v_cmp_neq_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xda,0x7c]

v_cmp_neq_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xda,0x7c]

v_cmp_neq_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xda,0x7c]

v_cmp_neq_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xda,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_neq_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xda,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_neq_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xdb,0x7c]

v_cmp_nlt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xdc,0x7c]

v_cmp_nlt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xdc,0x7c]

v_cmp_nlt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xdc,0x7c]

v_cmp_nlt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xdc,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nlt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xdc,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nlt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xdd,0x7c]

v_cmp_tru_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xde,0x7c]

v_cmp_tru_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xde,0x7c]

v_cmp_tru_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xde,0x7c]

v_cmp_tru_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xde,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_tru_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xde,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_tru_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xdf,0x7c]

v_cmpx_f_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe0,0x7c]

v_cmpx_f_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe0,0x7c]

v_cmpx_f_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe0,0x7c]

v_cmpx_f_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe0,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_f_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe0,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_f_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe1,0x7c]

v_cmpx_lt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe2,0x7c]

v_cmpx_lt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe2,0x7c]

v_cmpx_lt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe2,0x7c]

v_cmpx_lt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe2,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_lt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe2,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_lt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe3,0x7c]

v_cmpx_eq_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe4,0x7c]

v_cmpx_eq_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe4,0x7c]

v_cmpx_eq_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe4,0x7c]

v_cmpx_eq_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe4,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_eq_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe4,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_eq_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe5,0x7c]

v_cmpx_le_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe6,0x7c]

v_cmpx_le_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe6,0x7c]

v_cmpx_le_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe6,0x7c]

v_cmpx_le_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe6,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_le_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe6,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_le_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe7,0x7c]

v_cmpx_gt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe8,0x7c]

v_cmpx_gt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe8,0x7c]

v_cmpx_gt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe8,0x7c]

v_cmpx_gt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe8,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_gt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe8,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_gt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe9,0x7c]

v_cmpx_lg_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xea,0x7c]

v_cmpx_lg_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xea,0x7c]

v_cmpx_lg_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xea,0x7c]

v_cmpx_lg_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xea,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_lg_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xea,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_lg_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xeb,0x7c]

v_cmpx_ge_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xec,0x7c]

v_cmpx_ge_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xec,0x7c]

v_cmpx_ge_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xec,0x7c]

v_cmpx_ge_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xec,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_ge_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xec,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_ge_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xed,0x7c]

v_cmpx_o_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xee,0x7c]

v_cmpx_o_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xee,0x7c]

v_cmpx_o_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xee,0x7c]

v_cmpx_o_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xee,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_o_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xee,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_o_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xef,0x7c]

v_cmpx_u_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf0,0x7c]

v_cmpx_u_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf0,0x7c]

v_cmpx_u_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf0,0x7c]

v_cmpx_u_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf0,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_u_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf0,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_u_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf1,0x7c]

v_cmpx_nge_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf2,0x7c]

v_cmpx_nge_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf2,0x7c]

v_cmpx_nge_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf2,0x7c]

v_cmpx_nge_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf2,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nge_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf2,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nge_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf3,0x7c]

v_cmpx_nlg_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf4,0x7c]

v_cmpx_nlg_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf4,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nlg_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf4,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nlg_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf5,0x7c]

v_cmpx_ngt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf6,0x7c]

v_cmpx_ngt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf6,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_ngt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf6,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_ngt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf7,0x7c]

v_cmpx_nle_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf8,0x7c]

v_cmpx_nle_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf8,0x7c]

v_cmpx_nle_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf8,0x7c]

v_cmpx_nle_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf8,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nle_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf8,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nle_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf9,0x7c]

v_cmpx_neq_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xfa,0x7c]

v_cmpx_neq_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xfa,0x7c]

v_cmpx_neq_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xfa,0x7c]

v_cmpx_neq_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xfa,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_neq_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xfa,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_neq_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xfb,0x7c]

v_cmpx_nlt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xfc,0x7c]

v_cmpx_nlt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xfc,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nlt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xfc,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nlt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xfd,0x7c]

v_cmpx_tru_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xfe,0x7c]

v_cmpx_tru_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xfe,0x7c]

v_cmpx_tru_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xfe,0x7c]

v_cmpx_tru_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xfe,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_tru_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xfe,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_tru_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xff,0x7c]

v_cmp_f_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x40,0x7d]

v_cmp_f_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x40,0x7d]

v_cmp_f_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x40,0x7d,0x00,0x38,0x00,0x00]

v_cmp_f_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x40,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_f_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x40,0x7d]

v_cmp_f_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x40,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_f_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x40,0x7d,0x56,0x34,0x00,0x00]

v_cmp_f_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x41,0x7d]

v_cmp_lt_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x42,0x7d]

v_cmp_lt_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x42,0x7d]

v_cmp_lt_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x42,0x7d,0x00,0x38,0x00,0x00]

v_cmp_lt_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x42,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_lt_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x42,0x7d]

v_cmp_lt_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x42,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_lt_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x42,0x7d,0x56,0x34,0x00,0x00]

v_cmp_lt_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x43,0x7d]

v_cmp_eq_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x44,0x7d]

v_cmp_eq_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x44,0x7d]

v_cmp_eq_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x44,0x7d,0x00,0x38,0x00,0x00]

v_cmp_eq_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x44,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_eq_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x44,0x7d]

v_cmp_eq_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x44,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_eq_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x44,0x7d,0x56,0x34,0x00,0x00]

v_cmp_eq_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x45,0x7d]

v_cmp_le_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x46,0x7d]

v_cmp_le_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x46,0x7d]

v_cmp_le_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x46,0x7d,0x00,0x38,0x00,0x00]

v_cmp_le_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x46,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_le_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x46,0x7d]

v_cmp_le_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x46,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_le_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x46,0x7d,0x56,0x34,0x00,0x00]

v_cmp_le_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x47,0x7d]

v_cmp_gt_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x48,0x7d]

v_cmp_gt_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x48,0x7d]

v_cmp_gt_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x48,0x7d,0x00,0x38,0x00,0x00]

v_cmp_gt_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x48,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_gt_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x48,0x7d]

v_cmp_gt_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x48,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_gt_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x48,0x7d,0x56,0x34,0x00,0x00]

v_cmp_gt_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x49,0x7d]

v_cmp_ne_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x4a,0x7d]

v_cmp_ne_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x4a,0x7d]

v_cmp_ne_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x4a,0x7d,0x00,0x38,0x00,0x00]

v_cmp_ne_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x4a,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_ne_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x4a,0x7d]

v_cmp_ne_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x4a,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_ne_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x4a,0x7d,0x56,0x34,0x00,0x00]

v_cmp_ne_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x4b,0x7d]

v_cmp_ge_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x4c,0x7d]

v_cmp_ge_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x4c,0x7d]

v_cmp_ge_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x4c,0x7d,0x00,0x38,0x00,0x00]

v_cmp_ge_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x4c,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_ge_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x4c,0x7d]

v_cmp_ge_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x4c,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_ge_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x4c,0x7d,0x56,0x34,0x00,0x00]

v_cmp_ge_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x4d,0x7d]

v_cmp_t_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x4e,0x7d]

v_cmp_t_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x4e,0x7d]

v_cmp_t_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x4e,0x7d,0x00,0x38,0x00,0x00]

v_cmp_t_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x4e,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_t_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x4e,0x7d]

v_cmp_t_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x4e,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_t_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x4e,0x7d,0x56,0x34,0x00,0x00]

v_cmp_t_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x4f,0x7d]

v_cmp_f_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x50,0x7d]

v_cmp_f_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x50,0x7d]

v_cmp_f_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x50,0x7d,0x00,0x38,0x00,0x00]

v_cmp_f_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x50,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_f_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x50,0x7d]

v_cmp_f_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x50,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_f_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x50,0x7d,0x56,0x34,0x00,0x00]

v_cmp_f_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x51,0x7d]

v_cmp_lt_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x52,0x7d]

v_cmp_lt_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x52,0x7d]

v_cmp_lt_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x52,0x7d,0x00,0x38,0x00,0x00]

v_cmp_lt_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x52,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_lt_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x52,0x7d]

v_cmp_lt_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x52,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_lt_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x52,0x7d,0x56,0x34,0x00,0x00]

v_cmp_lt_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x53,0x7d]

v_cmp_eq_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x54,0x7d]

v_cmp_eq_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x54,0x7d]

v_cmp_eq_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x54,0x7d,0x00,0x38,0x00,0x00]

v_cmp_eq_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x54,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_eq_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x54,0x7d]

v_cmp_eq_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x54,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_eq_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x54,0x7d,0x56,0x34,0x00,0x00]

v_cmp_eq_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x55,0x7d]

v_cmp_le_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x56,0x7d]

v_cmp_le_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x56,0x7d]

v_cmp_le_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x56,0x7d,0x00,0x38,0x00,0x00]

v_cmp_le_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x56,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_le_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x56,0x7d]

v_cmp_le_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x56,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_le_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x56,0x7d,0x56,0x34,0x00,0x00]

v_cmp_le_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x57,0x7d]

v_cmp_gt_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x58,0x7d]

v_cmp_gt_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x58,0x7d]

v_cmp_gt_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x58,0x7d,0x00,0x38,0x00,0x00]

v_cmp_gt_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x58,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_gt_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x58,0x7d]

v_cmp_gt_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x58,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_gt_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x58,0x7d,0x56,0x34,0x00,0x00]

v_cmp_gt_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x59,0x7d]

v_cmp_ne_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x5a,0x7d]

v_cmp_ne_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x5a,0x7d]

v_cmp_ne_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x5a,0x7d,0x00,0x38,0x00,0x00]

v_cmp_ne_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x5a,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_ne_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x5a,0x7d]

v_cmp_ne_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x5a,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_ne_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x5a,0x7d,0x56,0x34,0x00,0x00]

v_cmp_ne_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x5b,0x7d]

v_cmp_ge_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x5c,0x7d]

v_cmp_ge_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x5c,0x7d]

v_cmp_ge_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x5c,0x7d,0x00,0x38,0x00,0x00]

v_cmp_ge_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x5c,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_ge_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x5c,0x7d]

v_cmp_ge_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x5c,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_ge_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x5c,0x7d,0x56,0x34,0x00,0x00]

v_cmp_ge_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x5d,0x7d]

v_cmp_t_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x5e,0x7d]

v_cmp_t_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x5e,0x7d]

v_cmp_t_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x5e,0x7d,0x00,0x38,0x00,0x00]

v_cmp_t_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x5e,0x7d,0x00,0xc4,0x00,0x00]

v_cmp_t_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x5e,0x7d]

v_cmp_t_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x5e,0x7d,0x0b,0xfe,0x00,0x00]

v_cmp_t_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x5e,0x7d,0x56,0x34,0x00,0x00]

v_cmp_t_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x5f,0x7d]

v_cmpx_f_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x60,0x7d]

v_cmpx_f_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x60,0x7d]

v_cmpx_f_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x60,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_f_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x60,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_f_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x60,0x7d]

v_cmpx_f_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x60,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_f_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x60,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_f_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x61,0x7d]

v_cmpx_lt_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x62,0x7d]

v_cmpx_lt_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x62,0x7d]

v_cmpx_lt_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x62,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_lt_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x62,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_lt_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x62,0x7d]

v_cmpx_lt_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x62,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_lt_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x62,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_lt_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x63,0x7d]

v_cmpx_eq_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x64,0x7d]

v_cmpx_eq_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x64,0x7d]

v_cmpx_eq_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x64,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_eq_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x64,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_eq_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x64,0x7d]

v_cmpx_eq_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x64,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_eq_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x64,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_eq_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x65,0x7d]

v_cmpx_le_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x66,0x7d]

v_cmpx_le_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x66,0x7d]

v_cmpx_le_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x66,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_le_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x66,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_le_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x66,0x7d]

v_cmpx_le_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x66,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_le_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x66,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_le_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x67,0x7d]

v_cmpx_gt_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x68,0x7d]

v_cmpx_gt_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x68,0x7d]

v_cmpx_gt_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x68,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_gt_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x68,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_gt_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x68,0x7d]

v_cmpx_gt_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x68,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_gt_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x68,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_gt_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x69,0x7d]

v_cmpx_ne_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x6a,0x7d]

v_cmpx_ne_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x6a,0x7d]

v_cmpx_ne_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x6a,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_ne_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x6a,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_ne_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x6a,0x7d]

v_cmpx_ne_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x6a,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_ne_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x6a,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_ne_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x6b,0x7d]

v_cmpx_ge_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x6c,0x7d]

v_cmpx_ge_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x6c,0x7d]

v_cmpx_ge_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x6c,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_ge_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x6c,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_ge_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x6c,0x7d]

v_cmpx_ge_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x6c,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_ge_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x6c,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_ge_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x6d,0x7d]

v_cmpx_t_i16 vcc, v1, v2
// CHECK: [0x01,0x05,0x6e,0x7d]

v_cmpx_t_i16 vcc, v255, v2
// CHECK: [0xff,0x05,0x6e,0x7d]

v_cmpx_t_i16 vcc, s1, v2
// CHECK: [0x01,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, s101, v2
// CHECK: [0x65,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, 0, v2
// CHECK: [0x80,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x6e,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_t_i16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x6e,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_t_i16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x6e,0x7d]

v_cmpx_t_i16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x6e,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_t_i16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x6e,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_t_i16 vcc, v1, v255
// CHECK: [0x01,0xff,0x6f,0x7d]

v_cmpx_f_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x70,0x7d]

v_cmpx_f_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x70,0x7d]

v_cmpx_f_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x70,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_f_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x70,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_f_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x70,0x7d]

v_cmpx_f_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x70,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_f_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x70,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_f_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x71,0x7d]

v_cmpx_lt_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x72,0x7d]

v_cmpx_lt_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x72,0x7d]

v_cmpx_lt_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x72,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_lt_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x72,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_lt_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x72,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_lt_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x72,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_lt_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x73,0x7d]

v_cmpx_eq_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x74,0x7d]

v_cmpx_eq_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x74,0x7d]

v_cmpx_eq_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x74,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_eq_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x74,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_eq_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x74,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_eq_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x74,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_eq_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x75,0x7d]

v_cmpx_le_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x76,0x7d]

v_cmpx_le_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x76,0x7d]

v_cmpx_le_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x76,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_le_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x76,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_le_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x76,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_le_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x76,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_le_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x77,0x7d]

v_cmpx_gt_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x78,0x7d]

v_cmpx_gt_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x78,0x7d]

v_cmpx_gt_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x78,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_gt_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x78,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_gt_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x78,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_gt_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x78,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_gt_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x79,0x7d]

v_cmpx_ne_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x7a,0x7d]

v_cmpx_ne_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x7a,0x7d]

v_cmpx_ne_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x7a,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_ne_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x7a,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_ne_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x7a,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_ne_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x7a,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_ne_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x7b,0x7d]

v_cmpx_ge_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x7c,0x7d]

v_cmpx_ge_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x7c,0x7d]

v_cmpx_ge_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x7c,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_ge_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x7c,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_ge_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x7c,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_ge_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x7c,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_ge_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x7d,0x7d]

v_cmpx_t_u16 vcc, v1, v2
// CHECK: [0x01,0x05,0x7e,0x7d]

v_cmpx_t_u16 vcc, v255, v2
// CHECK: [0xff,0x05,0x7e,0x7d]

v_cmpx_t_u16 vcc, s1, v2
// CHECK: [0x01,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, s101, v2
// CHECK: [0x65,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, m0, v2
// CHECK: [0x7c,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, 0, v2
// CHECK: [0x80,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, -1, v2
// CHECK: [0xc1,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, 0.5, v2
// CHECK: [0xff,0x04,0x7e,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_t_u16 vcc, -4.0, v2
// CHECK: [0xff,0x04,0x7e,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_t_u16 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x7e,0x7d]

v_cmpx_t_u16 vcc, 0xfe0b, v2
// CHECK: [0xff,0x04,0x7e,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_t_u16 vcc, 0x3456, v2
// CHECK: [0xff,0x04,0x7e,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_t_u16 vcc, v1, v255
// CHECK: [0x01,0xff,0x7f,0x7d]

v_cmp_f_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x80,0x7d]

v_cmp_f_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x80,0x7d]

v_cmp_f_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x80,0x7d]

v_cmp_f_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x80,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_f_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x80,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_f_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x81,0x7d]

v_cmp_lt_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x82,0x7d]

v_cmp_lt_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x82,0x7d]

v_cmp_lt_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x82,0x7d]

v_cmp_lt_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x82,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_lt_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x82,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_lt_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x83,0x7d]

v_cmp_eq_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x84,0x7d]

v_cmp_eq_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x84,0x7d]

v_cmp_eq_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x84,0x7d]

v_cmp_eq_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x84,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_eq_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x84,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_eq_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x85,0x7d]

v_cmp_le_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x86,0x7d]

v_cmp_le_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x86,0x7d]

v_cmp_le_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x86,0x7d]

v_cmp_le_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x86,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_le_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x86,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_le_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x87,0x7d]

v_cmp_gt_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x88,0x7d]

v_cmp_gt_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x88,0x7d]

v_cmp_gt_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x88,0x7d]

v_cmp_gt_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x88,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_gt_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x88,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_gt_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x89,0x7d]

v_cmp_ne_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x8a,0x7d]

v_cmp_ne_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x8a,0x7d]

v_cmp_ne_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x8a,0x7d]

v_cmp_ne_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x8a,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ne_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x8a,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ne_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x8b,0x7d]

v_cmp_ge_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x8c,0x7d]

v_cmp_ge_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x8c,0x7d]

v_cmp_ge_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x8c,0x7d]

v_cmp_ge_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x8c,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ge_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x8c,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ge_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x8d,0x7d]

v_cmp_t_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x8e,0x7d]

v_cmp_t_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x8e,0x7d]

v_cmp_t_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x8e,0x7d]

v_cmp_t_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x8e,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_t_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x8e,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_t_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x8f,0x7d]

v_cmp_f_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x90,0x7d]

v_cmp_f_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x90,0x7d]

v_cmp_f_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x90,0x7d]

v_cmp_f_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x90,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_f_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x90,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_f_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x91,0x7d]

v_cmp_lt_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x92,0x7d]

v_cmp_lt_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x92,0x7d]

v_cmp_lt_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x92,0x7d]

v_cmp_lt_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x92,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_lt_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x92,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_lt_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x93,0x7d]

v_cmp_eq_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x94,0x7d]

v_cmp_eq_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x94,0x7d]

v_cmp_eq_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x94,0x7d]

v_cmp_eq_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x94,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_eq_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x94,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_eq_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x95,0x7d]

v_cmp_le_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x96,0x7d]

v_cmp_le_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x96,0x7d]

v_cmp_le_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x96,0x7d]

v_cmp_le_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x96,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_le_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x96,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_le_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x97,0x7d]

v_cmp_gt_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x98,0x7d]

v_cmp_gt_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x98,0x7d]

v_cmp_gt_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x98,0x7d]

v_cmp_gt_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x98,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_gt_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x98,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_gt_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x99,0x7d]

v_cmp_ne_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x9a,0x7d]

v_cmp_ne_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x9a,0x7d]

v_cmp_ne_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x9a,0x7d]

v_cmp_ne_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x9a,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ne_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x9a,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ne_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x9b,0x7d]

v_cmp_ge_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x9c,0x7d]

v_cmp_ge_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x9c,0x7d]

v_cmp_ge_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x9c,0x7d]

v_cmp_ge_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x9c,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ge_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x9c,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ge_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x9d,0x7d]

v_cmp_t_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x9e,0x7d]

v_cmp_t_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x9e,0x7d]

v_cmp_t_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x9e,0x7d]

v_cmp_t_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x9e,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_t_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x9e,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_t_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x9f,0x7d]

v_cmpx_f_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa0,0x7d]

v_cmpx_f_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa0,0x7d]

v_cmpx_f_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa0,0x7d]

v_cmpx_f_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa0,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_f_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa0,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_f_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa1,0x7d]

v_cmpx_lt_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa2,0x7d]

v_cmpx_lt_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa2,0x7d]

v_cmpx_lt_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa2,0x7d]

v_cmpx_lt_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa2,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_lt_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa2,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_lt_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa3,0x7d]

v_cmpx_eq_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa4,0x7d]

v_cmpx_eq_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa4,0x7d]

v_cmpx_eq_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa4,0x7d]

v_cmpx_eq_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa4,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_eq_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa4,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_eq_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa5,0x7d]

v_cmpx_le_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa6,0x7d]

v_cmpx_le_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa6,0x7d]

v_cmpx_le_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa6,0x7d]

v_cmpx_le_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa6,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_le_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa6,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_le_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa7,0x7d]

v_cmpx_gt_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa8,0x7d]

v_cmpx_gt_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa8,0x7d]

v_cmpx_gt_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa8,0x7d]

v_cmpx_gt_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa8,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_gt_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa8,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_gt_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa9,0x7d]

v_cmpx_ne_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0xaa,0x7d]

v_cmpx_ne_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0xaa,0x7d]

v_cmpx_ne_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xaa,0x7d]

v_cmpx_ne_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xaa,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ne_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xaa,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ne_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0xab,0x7d]

v_cmpx_ge_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0xac,0x7d]

v_cmpx_ge_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0xac,0x7d]

v_cmpx_ge_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xac,0x7d]

v_cmpx_ge_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xac,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ge_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xac,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ge_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0xad,0x7d]

v_cmpx_t_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0xae,0x7d]

v_cmpx_t_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0xae,0x7d]

v_cmpx_t_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, s101, v2
// CHECK: [0x65,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xae,0x7d]

v_cmpx_t_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xae,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_t_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xae,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_t_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0xaf,0x7d]

v_cmpx_f_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb0,0x7d]

v_cmpx_f_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb0,0x7d]

v_cmpx_f_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb0,0x7d]

v_cmpx_f_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb0,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_f_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb0,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_f_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb1,0x7d]

v_cmpx_lt_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb2,0x7d]

v_cmpx_lt_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb2,0x7d]

v_cmpx_lt_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb2,0x7d]

v_cmpx_lt_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb2,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_lt_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb2,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_lt_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb3,0x7d]

v_cmpx_eq_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb4,0x7d]

v_cmpx_eq_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb4,0x7d]

v_cmpx_eq_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb4,0x7d]

v_cmpx_eq_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb4,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_eq_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb4,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_eq_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb5,0x7d]

v_cmpx_le_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb6,0x7d]

v_cmpx_le_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb6,0x7d]

v_cmpx_le_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb6,0x7d]

v_cmpx_le_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb6,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_le_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb6,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_le_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb7,0x7d]

v_cmpx_gt_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb8,0x7d]

v_cmpx_gt_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb8,0x7d]

v_cmpx_gt_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb8,0x7d]

v_cmpx_gt_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb8,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_gt_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb8,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_gt_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb9,0x7d]

v_cmpx_ne_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xba,0x7d]

v_cmpx_ne_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xba,0x7d]

v_cmpx_ne_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xba,0x7d]

v_cmpx_ne_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xba,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ne_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xba,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ne_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xbb,0x7d]

v_cmpx_ge_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xbc,0x7d]

v_cmpx_ge_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xbc,0x7d]

v_cmpx_ge_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xbc,0x7d]

v_cmpx_ge_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xbc,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ge_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xbc,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ge_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xbd,0x7d]

v_cmpx_t_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xbe,0x7d]

v_cmpx_t_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xbe,0x7d]

v_cmpx_t_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, s101, v2
// CHECK: [0x65,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xbe,0x7d]

v_cmpx_t_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xbe,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_t_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xbe,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_t_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xbf,0x7d]

v_cmp_f_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc0,0x7d]

v_cmp_f_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc0,0x7d]

v_cmp_f_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc0,0x7d]

v_cmp_f_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc0,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_f_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc0,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_f_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc1,0x7d]

v_cmp_lt_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc2,0x7d]

v_cmp_lt_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc2,0x7d]

v_cmp_lt_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc2,0x7d]

v_cmp_lt_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc2,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_lt_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc2,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_lt_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc3,0x7d]

v_cmp_eq_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc4,0x7d]

v_cmp_eq_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc4,0x7d]

v_cmp_eq_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc4,0x7d]

v_cmp_eq_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc4,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_eq_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc4,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_eq_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc5,0x7d]

v_cmp_le_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc6,0x7d]

v_cmp_le_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc6,0x7d]

v_cmp_le_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc6,0x7d]

v_cmp_le_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc6,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_le_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc6,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_le_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc7,0x7d]

v_cmp_gt_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc8,0x7d]

v_cmp_gt_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc8,0x7d]

v_cmp_gt_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc8,0x7d]

v_cmp_gt_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc8,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_gt_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc8,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_gt_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc9,0x7d]

v_cmp_ne_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xca,0x7d]

v_cmp_ne_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xca,0x7d]

v_cmp_ne_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xca,0x7d]

v_cmp_ne_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xca,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ne_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xca,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ne_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xcb,0x7d]

v_cmp_ge_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xcc,0x7d]

v_cmp_ge_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xcc,0x7d]

v_cmp_ge_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xcc,0x7d]

v_cmp_ge_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xcc,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ge_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xcc,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ge_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xcd,0x7d]

v_cmp_t_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xce,0x7d]

v_cmp_t_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xce,0x7d]

v_cmp_t_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xce,0x7d]

v_cmp_t_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xce,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_t_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xce,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_t_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xcf,0x7d]

v_cmp_f_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd0,0x7d]

v_cmp_f_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd0,0x7d]

v_cmp_f_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd0,0x7d]

v_cmp_f_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd0,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_f_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd0,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_f_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd1,0x7d]

v_cmp_lt_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd2,0x7d]

v_cmp_lt_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd2,0x7d]

v_cmp_lt_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd2,0x7d]

v_cmp_lt_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd2,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_lt_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd2,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_lt_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd3,0x7d]

v_cmp_eq_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd4,0x7d]

v_cmp_eq_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd4,0x7d]

v_cmp_eq_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd4,0x7d]

v_cmp_eq_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd4,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_eq_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd4,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_eq_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd5,0x7d]

v_cmp_le_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd6,0x7d]

v_cmp_le_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd6,0x7d]

v_cmp_le_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd6,0x7d]

v_cmp_le_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd6,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_le_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd6,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_le_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd7,0x7d]

v_cmp_gt_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd8,0x7d]

v_cmp_gt_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd8,0x7d]

v_cmp_gt_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd8,0x7d]

v_cmp_gt_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd8,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_gt_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd8,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_gt_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd9,0x7d]

v_cmp_ne_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xda,0x7d]

v_cmp_ne_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xda,0x7d]

v_cmp_ne_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xda,0x7d]

v_cmp_ne_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xda,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ne_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xda,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ne_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xdb,0x7d]

v_cmp_ge_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xdc,0x7d]

v_cmp_ge_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xdc,0x7d]

v_cmp_ge_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xdc,0x7d]

v_cmp_ge_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xdc,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ge_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xdc,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ge_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xdd,0x7d]

v_cmp_t_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xde,0x7d]

v_cmp_t_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xde,0x7d]

v_cmp_t_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xde,0x7d]

v_cmp_t_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xde,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_t_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xde,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_t_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xdf,0x7d]

v_cmpx_f_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe0,0x7d]

v_cmpx_f_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe0,0x7d]

v_cmpx_f_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe0,0x7d]

v_cmpx_f_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe0,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_f_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe0,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_f_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe1,0x7d]

v_cmpx_lt_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe2,0x7d]

v_cmpx_lt_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe2,0x7d]

v_cmpx_lt_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe2,0x7d]

v_cmpx_lt_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe2,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_lt_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe2,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_lt_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe3,0x7d]

v_cmpx_eq_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe4,0x7d]

v_cmpx_eq_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe4,0x7d]

v_cmpx_eq_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe4,0x7d]

v_cmpx_eq_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe4,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_eq_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe4,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_eq_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe5,0x7d]

v_cmpx_le_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe6,0x7d]

v_cmpx_le_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe6,0x7d]

v_cmpx_le_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe6,0x7d]

v_cmpx_le_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe6,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_le_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe6,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_le_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe7,0x7d]

v_cmpx_gt_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe8,0x7d]

v_cmpx_gt_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe8,0x7d]

v_cmpx_gt_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe8,0x7d]

v_cmpx_gt_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe8,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_gt_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe8,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_gt_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe9,0x7d]

v_cmpx_ne_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xea,0x7d]

v_cmpx_ne_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xea,0x7d]

v_cmpx_ne_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xea,0x7d]

v_cmpx_ne_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xea,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ne_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xea,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ne_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xeb,0x7d]

v_cmpx_ge_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xec,0x7d]

v_cmpx_ge_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xec,0x7d]

v_cmpx_ge_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xec,0x7d]

v_cmpx_ge_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xec,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ge_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xec,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ge_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xed,0x7d]

v_cmpx_t_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xee,0x7d]

v_cmpx_t_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xee,0x7d]

v_cmpx_t_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xee,0x7d]

v_cmpx_t_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xee,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_t_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xee,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_t_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xef,0x7d]

v_cmpx_f_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf0,0x7d]

v_cmpx_f_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf0,0x7d]

v_cmpx_f_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf0,0x7d]

v_cmpx_f_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf0,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_f_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf0,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_f_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf1,0x7d]

v_cmpx_lt_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf2,0x7d]

v_cmpx_lt_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf2,0x7d]

v_cmpx_lt_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf2,0x7d]

v_cmpx_lt_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf2,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_lt_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf2,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_lt_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf3,0x7d]

v_cmpx_eq_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf4,0x7d]

v_cmpx_eq_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf4,0x7d]

v_cmpx_eq_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf4,0x7d]

v_cmpx_eq_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf4,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_eq_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf4,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_eq_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf5,0x7d]

v_cmpx_le_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf6,0x7d]

v_cmpx_le_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf6,0x7d]

v_cmpx_le_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf6,0x7d]

v_cmpx_le_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf6,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_le_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf6,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_le_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf7,0x7d]

v_cmpx_gt_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf8,0x7d]

v_cmpx_gt_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf8,0x7d]

v_cmpx_gt_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf8,0x7d]

v_cmpx_gt_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf8,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_gt_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf8,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_gt_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf9,0x7d]

v_cmpx_ne_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xfa,0x7d]

v_cmpx_ne_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xfa,0x7d]

v_cmpx_ne_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xfa,0x7d]

v_cmpx_ne_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xfa,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ne_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xfa,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ne_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xfb,0x7d]

v_cmpx_ge_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xfc,0x7d]

v_cmpx_ge_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xfc,0x7d]

v_cmpx_ge_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xfc,0x7d]

v_cmpx_ge_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xfc,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ge_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xfc,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ge_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xfd,0x7d]

v_cmpx_t_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xfe,0x7d]

v_cmpx_t_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xfe,0x7d]

v_cmpx_t_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, s[100:101], v[2:3]
// CHECK: [0x64,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x66,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xfe,0x7d]

v_cmpx_t_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xfe,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_t_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xfe,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_t_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xff,0x7d]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x06]

v_cmp_class_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x20,0x7c,0xff,0x00,0x06,0x06]

v_cmp_class_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x21,0x7c,0x01,0x00,0x06,0x06]

v_cmp_class_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x06]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x00,0x06]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x01,0x06]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x02,0x06]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x03,0x06]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x04,0x06]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x05,0x06]

v_cmp_class_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x16,0x06]

v_cmp_class_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x26,0x06]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x06]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x00]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x01]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x02]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x03]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x04]

v_cmp_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x05]

v_cmp_class_f32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x0e]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_class_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x22,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_class_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x23,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_class_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_class_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_class_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_class_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_class_f32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x0e]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x06]

v_cmp_class_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x28,0x7c,0xff,0x00,0x06,0x06]

v_cmp_class_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x29,0x7c,0x01,0x00,0x06,0x06]

v_cmp_class_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x06]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x00,0x06]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x01,0x06]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x02,0x06]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x03,0x06]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x04,0x06]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x05,0x06]

v_cmp_class_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x16,0x06]

v_cmp_class_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x26,0x06]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x06]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x00]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x01]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x02]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x03]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x04]

v_cmp_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x05]

v_cmp_class_f16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x0e]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_class_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x2a,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_class_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x2b,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_class_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_class_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_class_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_class_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_class_f16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x0e]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x06,0x06]

v_cmp_f_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0xff,0x00,0x06,0x06]

v_cmp_f_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x41,0x7c,0x01,0x00,0x06,0x06]

v_cmp_f_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x20,0x06,0x06]

v_cmp_f_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x06,0x06]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x00,0x06]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x01,0x06]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x02,0x06]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x03,0x06]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x04,0x06]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x05,0x06]

v_cmp_f_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x16,0x06]

v_cmp_f_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x26,0x06]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x06,0x06]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x06,0x00]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x06,0x01]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x06,0x02]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x06,0x03]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x06,0x04]

v_cmp_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x06,0x05]

v_cmp_f_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x06,0x16]

v_cmp_f_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7c,0x01,0x00,0x06,0x26]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lt_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0xff,0x00,0x06,0x06]

v_cmp_lt_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x43,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lt_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x20,0x06,0x06]

v_cmp_lt_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x00,0x06]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x01,0x06]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x02,0x06]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x03,0x06]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x04,0x06]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x05,0x06]

v_cmp_lt_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x16,0x06]

v_cmp_lt_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x26,0x06]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x06,0x00]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x06,0x01]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x06,0x02]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x06,0x03]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x06,0x04]

v_cmp_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x06,0x05]

v_cmp_lt_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x06,0x16]

v_cmp_lt_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7c,0x01,0x00,0x06,0x26]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x06,0x06]

v_cmp_eq_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0xff,0x00,0x06,0x06]

v_cmp_eq_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x45,0x7c,0x01,0x00,0x06,0x06]

v_cmp_eq_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x20,0x06,0x06]

v_cmp_eq_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x06,0x06]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x00,0x06]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x01,0x06]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x02,0x06]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x03,0x06]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x04,0x06]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x05,0x06]

v_cmp_eq_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x16,0x06]

v_cmp_eq_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x26,0x06]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x06,0x06]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x06,0x00]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x06,0x01]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x06,0x02]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x06,0x03]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x06,0x04]

v_cmp_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x06,0x05]

v_cmp_eq_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x06,0x16]

v_cmp_eq_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7c,0x01,0x00,0x06,0x26]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x06,0x06]

v_cmp_le_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0xff,0x00,0x06,0x06]

v_cmp_le_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x47,0x7c,0x01,0x00,0x06,0x06]

v_cmp_le_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x20,0x06,0x06]

v_cmp_le_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x06,0x06]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x00,0x06]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x01,0x06]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x02,0x06]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x03,0x06]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x04,0x06]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x05,0x06]

v_cmp_le_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x16,0x06]

v_cmp_le_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x26,0x06]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x06,0x06]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x06,0x00]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x06,0x01]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x06,0x02]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x06,0x03]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x06,0x04]

v_cmp_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x06,0x05]

v_cmp_le_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x06,0x16]

v_cmp_le_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7c,0x01,0x00,0x06,0x26]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x06,0x06]

v_cmp_gt_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0xff,0x00,0x06,0x06]

v_cmp_gt_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x49,0x7c,0x01,0x00,0x06,0x06]

v_cmp_gt_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x20,0x06,0x06]

v_cmp_gt_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x06,0x06]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x00,0x06]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x01,0x06]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x02,0x06]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x03,0x06]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x04,0x06]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x05,0x06]

v_cmp_gt_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x16,0x06]

v_cmp_gt_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x26,0x06]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x06,0x06]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x06,0x00]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x06,0x01]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x06,0x02]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x06,0x03]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x06,0x04]

v_cmp_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x06,0x05]

v_cmp_gt_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x06,0x16]

v_cmp_gt_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7c,0x01,0x00,0x06,0x26]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lg_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0xff,0x00,0x06,0x06]

v_cmp_lg_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x4b,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lg_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x20,0x06,0x06]

v_cmp_lg_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x00,0x06]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x01,0x06]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x02,0x06]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x03,0x06]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x04,0x06]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x05,0x06]

v_cmp_lg_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x16,0x06]

v_cmp_lg_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x26,0x06]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x06,0x00]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x06,0x01]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x06,0x02]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x06,0x03]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x06,0x04]

v_cmp_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x06,0x05]

v_cmp_lg_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x06,0x16]

v_cmp_lg_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7c,0x01,0x00,0x06,0x26]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ge_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0xff,0x00,0x06,0x06]

v_cmp_ge_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x4d,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ge_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x20,0x06,0x06]

v_cmp_ge_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x00,0x06]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x01,0x06]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x02,0x06]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x03,0x06]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x04,0x06]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x05,0x06]

v_cmp_ge_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x16,0x06]

v_cmp_ge_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x26,0x06]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x06,0x00]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x06,0x01]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x06,0x02]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x06,0x03]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x06,0x04]

v_cmp_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x06,0x05]

v_cmp_ge_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x06,0x16]

v_cmp_ge_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7c,0x01,0x00,0x06,0x26]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x06,0x06]

v_cmp_o_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0xff,0x00,0x06,0x06]

v_cmp_o_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x4f,0x7c,0x01,0x00,0x06,0x06]

v_cmp_o_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x20,0x06,0x06]

v_cmp_o_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x06,0x06]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x00,0x06]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x01,0x06]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x02,0x06]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x03,0x06]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x04,0x06]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x05,0x06]

v_cmp_o_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x16,0x06]

v_cmp_o_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x26,0x06]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x06,0x06]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x06,0x00]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x06,0x01]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x06,0x02]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x06,0x03]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x06,0x04]

v_cmp_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x06,0x05]

v_cmp_o_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x06,0x16]

v_cmp_o_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7c,0x01,0x00,0x06,0x26]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x06,0x06]

v_cmp_u_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0xff,0x00,0x06,0x06]

v_cmp_u_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x51,0x7c,0x01,0x00,0x06,0x06]

v_cmp_u_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x20,0x06,0x06]

v_cmp_u_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x06,0x06]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x00,0x06]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x01,0x06]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x02,0x06]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x03,0x06]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x04,0x06]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x05,0x06]

v_cmp_u_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x16,0x06]

v_cmp_u_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x26,0x06]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x06,0x06]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x06,0x00]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x06,0x01]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x06,0x02]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x06,0x03]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x06,0x04]

v_cmp_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x06,0x05]

v_cmp_u_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x06,0x16]

v_cmp_u_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7c,0x01,0x00,0x06,0x26]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nge_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0xff,0x00,0x06,0x06]

v_cmp_nge_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x53,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nge_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x20,0x06,0x06]

v_cmp_nge_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x00,0x06]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x01,0x06]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x02,0x06]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x03,0x06]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x04,0x06]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x05,0x06]

v_cmp_nge_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x16,0x06]

v_cmp_nge_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x26,0x06]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x06,0x00]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x06,0x01]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x06,0x02]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x06,0x03]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x06,0x04]

v_cmp_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x06,0x05]

v_cmp_nge_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x06,0x16]

v_cmp_nge_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7c,0x01,0x00,0x06,0x26]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlg_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0xff,0x00,0x06,0x06]

v_cmp_nlg_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x55,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlg_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x20,0x06,0x06]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x00,0x06]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x01,0x06]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x02,0x06]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x03,0x06]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x04,0x06]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x05,0x06]

v_cmp_nlg_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x16,0x06]

v_cmp_nlg_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x26,0x06]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x06,0x00]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x06,0x01]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x06,0x02]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x06,0x03]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x06,0x04]

v_cmp_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x06,0x05]

v_cmp_nlg_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x06,0x16]

v_cmp_nlg_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7c,0x01,0x00,0x06,0x26]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ngt_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0xff,0x00,0x06,0x06]

v_cmp_ngt_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x57,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ngt_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x20,0x06,0x06]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x00,0x06]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x01,0x06]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x02,0x06]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x03,0x06]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x04,0x06]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x05,0x06]

v_cmp_ngt_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x16,0x06]

v_cmp_ngt_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x26,0x06]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x06,0x00]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x06,0x01]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x06,0x02]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x06,0x03]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x06,0x04]

v_cmp_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x06,0x05]

v_cmp_ngt_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x06,0x16]

v_cmp_ngt_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7c,0x01,0x00,0x06,0x26]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nle_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0xff,0x00,0x06,0x06]

v_cmp_nle_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x59,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nle_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x20,0x06,0x06]

v_cmp_nle_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x00,0x06]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x01,0x06]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x02,0x06]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x03,0x06]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x04,0x06]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x05,0x06]

v_cmp_nle_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x16,0x06]

v_cmp_nle_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x26,0x06]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x06,0x00]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x06,0x01]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x06,0x02]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x06,0x03]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x06,0x04]

v_cmp_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x06,0x05]

v_cmp_nle_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x06,0x16]

v_cmp_nle_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7c,0x01,0x00,0x06,0x26]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x06,0x06]

v_cmp_neq_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0xff,0x00,0x06,0x06]

v_cmp_neq_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x5b,0x7c,0x01,0x00,0x06,0x06]

v_cmp_neq_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x20,0x06,0x06]

v_cmp_neq_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x06,0x06]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x00,0x06]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x01,0x06]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x02,0x06]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x03,0x06]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x04,0x06]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x05,0x06]

v_cmp_neq_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x16,0x06]

v_cmp_neq_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x26,0x06]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x06,0x06]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x06,0x00]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x06,0x01]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x06,0x02]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x06,0x03]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x06,0x04]

v_cmp_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x06,0x05]

v_cmp_neq_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x06,0x16]

v_cmp_neq_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7c,0x01,0x00,0x06,0x26]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlt_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0xff,0x00,0x06,0x06]

v_cmp_nlt_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x5d,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlt_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x20,0x06,0x06]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x00,0x06]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x01,0x06]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x02,0x06]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x03,0x06]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x04,0x06]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x05,0x06]

v_cmp_nlt_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x16,0x06]

v_cmp_nlt_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x26,0x06]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x06,0x00]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x06,0x01]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x06,0x02]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x06,0x03]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x06,0x04]

v_cmp_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x06,0x05]

v_cmp_nlt_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x06,0x16]

v_cmp_nlt_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7c,0x01,0x00,0x06,0x26]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x06,0x06]

v_cmp_tru_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0xff,0x00,0x06,0x06]

v_cmp_tru_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x5f,0x7c,0x01,0x00,0x06,0x06]

v_cmp_tru_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x20,0x06,0x06]

v_cmp_tru_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x06,0x06]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x00,0x06]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x01,0x06]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x02,0x06]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x03,0x06]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x04,0x06]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x05,0x06]

v_cmp_tru_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x16,0x06]

v_cmp_tru_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x26,0x06]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x06,0x06]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x06,0x00]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x06,0x01]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x06,0x02]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x06,0x03]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x06,0x04]

v_cmp_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x06,0x05]

v_cmp_tru_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x06,0x16]

v_cmp_tru_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_f_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_f_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x61,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_f_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_f_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_f_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_f_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_f_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_f_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_f_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lt_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_lt_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x63,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lt_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_lt_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_lt_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_lt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_lt_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_lt_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_eq_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_eq_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x65,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_eq_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_eq_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_eq_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_eq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_eq_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_eq_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_le_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_le_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x67,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_le_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_le_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_le_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_le_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_le_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_le_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_le_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_gt_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_gt_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x69,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_gt_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_gt_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_gt_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_gt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_gt_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_gt_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lg_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_lg_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x6b,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lg_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_lg_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_lg_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_lg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_lg_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_lg_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ge_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_ge_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x6d,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ge_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_ge_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_ge_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_ge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_ge_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_ge_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_o_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_o_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x6f,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_o_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_o_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_o_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_o_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_o_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_o_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_o_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_u_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_u_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x71,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_u_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_u_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_u_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_u_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_u_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_u_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_u_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nge_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_nge_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x73,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nge_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_nge_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_nge_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_nge_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_nge_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_nge_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlg_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_nlg_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x75,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_nlg_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_nlg_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_nlg_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_nlg_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_nlg_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ngt_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_ngt_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x77,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_ngt_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_ngt_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_ngt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_ngt_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_ngt_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nle_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_nle_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x79,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nle_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_nle_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_nle_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_nle_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_nle_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_nle_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_neq_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_neq_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x7b,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_neq_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_neq_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_neq_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_neq_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_neq_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_neq_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlt_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_nlt_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x7d,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_nlt_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_nlt_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_nlt_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_nlt_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_nlt_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_tru_f16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_tru_f16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x7f,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_tru_f16_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_tru_f16_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_tru_f16_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_tru_f16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_tru_f16_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_tru_f16_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7c,0x01,0x00,0x06,0x26]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x06,0x06]

v_cmp_f_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0xff,0x00,0x06,0x06]

v_cmp_f_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x81,0x7c,0x01,0x00,0x06,0x06]

v_cmp_f_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x20,0x06,0x06]

v_cmp_f_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x06,0x06]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x00,0x06]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x01,0x06]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x02,0x06]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x03,0x06]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x04,0x06]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x05,0x06]

v_cmp_f_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x16,0x06]

v_cmp_f_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x26,0x06]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x06,0x06]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x06,0x00]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x06,0x01]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x06,0x02]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x06,0x03]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x06,0x04]

v_cmp_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x06,0x05]

v_cmp_f_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x06,0x16]

v_cmp_f_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7c,0x01,0x00,0x06,0x26]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lt_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0xff,0x00,0x06,0x06]

v_cmp_lt_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x83,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lt_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x20,0x06,0x06]

v_cmp_lt_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x00,0x06]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x01,0x06]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x02,0x06]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x03,0x06]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x04,0x06]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x05,0x06]

v_cmp_lt_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x16,0x06]

v_cmp_lt_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x26,0x06]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x06,0x00]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x06,0x01]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x06,0x02]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x06,0x03]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x06,0x04]

v_cmp_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x06,0x05]

v_cmp_lt_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x06,0x16]

v_cmp_lt_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7c,0x01,0x00,0x06,0x26]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x06,0x06]

v_cmp_eq_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0xff,0x00,0x06,0x06]

v_cmp_eq_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x85,0x7c,0x01,0x00,0x06,0x06]

v_cmp_eq_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x20,0x06,0x06]

v_cmp_eq_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x06,0x06]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x00,0x06]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x01,0x06]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x02,0x06]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x03,0x06]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x04,0x06]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x05,0x06]

v_cmp_eq_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x16,0x06]

v_cmp_eq_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x26,0x06]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x06,0x06]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x06,0x00]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x06,0x01]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x06,0x02]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x06,0x03]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x06,0x04]

v_cmp_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x06,0x05]

v_cmp_eq_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x06,0x16]

v_cmp_eq_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7c,0x01,0x00,0x06,0x26]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x06,0x06]

v_cmp_le_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0xff,0x00,0x06,0x06]

v_cmp_le_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x87,0x7c,0x01,0x00,0x06,0x06]

v_cmp_le_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x20,0x06,0x06]

v_cmp_le_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x06,0x06]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x00,0x06]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x01,0x06]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x02,0x06]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x03,0x06]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x04,0x06]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x05,0x06]

v_cmp_le_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x16,0x06]

v_cmp_le_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x26,0x06]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x06,0x06]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x06,0x00]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x06,0x01]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x06,0x02]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x06,0x03]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x06,0x04]

v_cmp_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x06,0x05]

v_cmp_le_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x06,0x16]

v_cmp_le_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7c,0x01,0x00,0x06,0x26]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x06,0x06]

v_cmp_gt_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0xff,0x00,0x06,0x06]

v_cmp_gt_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x89,0x7c,0x01,0x00,0x06,0x06]

v_cmp_gt_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x20,0x06,0x06]

v_cmp_gt_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x06,0x06]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x00,0x06]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x01,0x06]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x02,0x06]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x03,0x06]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x04,0x06]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x05,0x06]

v_cmp_gt_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x16,0x06]

v_cmp_gt_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x26,0x06]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x06,0x06]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x06,0x00]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x06,0x01]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x06,0x02]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x06,0x03]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x06,0x04]

v_cmp_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x06,0x05]

v_cmp_gt_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x06,0x16]

v_cmp_gt_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7c,0x01,0x00,0x06,0x26]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lg_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0xff,0x00,0x06,0x06]

v_cmp_lg_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x8b,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lg_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x20,0x06,0x06]

v_cmp_lg_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x00,0x06]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x01,0x06]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x02,0x06]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x03,0x06]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x04,0x06]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x05,0x06]

v_cmp_lg_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x16,0x06]

v_cmp_lg_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x26,0x06]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x06,0x06]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x06,0x00]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x06,0x01]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x06,0x02]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x06,0x03]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x06,0x04]

v_cmp_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x06,0x05]

v_cmp_lg_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x06,0x16]

v_cmp_lg_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7c,0x01,0x00,0x06,0x26]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ge_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0xff,0x00,0x06,0x06]

v_cmp_ge_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x8d,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ge_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x20,0x06,0x06]

v_cmp_ge_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x00,0x06]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x01,0x06]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x02,0x06]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x03,0x06]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x04,0x06]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x05,0x06]

v_cmp_ge_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x16,0x06]

v_cmp_ge_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x26,0x06]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x06,0x00]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x06,0x01]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x06,0x02]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x06,0x03]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x06,0x04]

v_cmp_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x06,0x05]

v_cmp_ge_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x06,0x16]

v_cmp_ge_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7c,0x01,0x00,0x06,0x26]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x06,0x06]

v_cmp_o_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0xff,0x00,0x06,0x06]

v_cmp_o_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x8f,0x7c,0x01,0x00,0x06,0x06]

v_cmp_o_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x20,0x06,0x06]

v_cmp_o_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x06,0x06]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x00,0x06]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x01,0x06]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x02,0x06]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x03,0x06]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x04,0x06]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x05,0x06]

v_cmp_o_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x16,0x06]

v_cmp_o_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x26,0x06]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x06,0x06]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x06,0x00]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x06,0x01]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x06,0x02]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x06,0x03]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x06,0x04]

v_cmp_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x06,0x05]

v_cmp_o_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x06,0x16]

v_cmp_o_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7c,0x01,0x00,0x06,0x26]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x06,0x06]

v_cmp_u_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0xff,0x00,0x06,0x06]

v_cmp_u_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x91,0x7c,0x01,0x00,0x06,0x06]

v_cmp_u_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x20,0x06,0x06]

v_cmp_u_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x06,0x06]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x00,0x06]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x01,0x06]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x02,0x06]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x03,0x06]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x04,0x06]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x05,0x06]

v_cmp_u_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x16,0x06]

v_cmp_u_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x26,0x06]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x06,0x06]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x06,0x00]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x06,0x01]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x06,0x02]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x06,0x03]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x06,0x04]

v_cmp_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x06,0x05]

v_cmp_u_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x06,0x16]

v_cmp_u_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7c,0x01,0x00,0x06,0x26]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nge_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0xff,0x00,0x06,0x06]

v_cmp_nge_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x93,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nge_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x20,0x06,0x06]

v_cmp_nge_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x00,0x06]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x01,0x06]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x02,0x06]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x03,0x06]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x04,0x06]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x05,0x06]

v_cmp_nge_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x16,0x06]

v_cmp_nge_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x26,0x06]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x06,0x00]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x06,0x01]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x06,0x02]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x06,0x03]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x06,0x04]

v_cmp_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x06,0x05]

v_cmp_nge_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x06,0x16]

v_cmp_nge_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7c,0x01,0x00,0x06,0x26]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlg_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0xff,0x00,0x06,0x06]

v_cmp_nlg_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x95,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlg_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x20,0x06,0x06]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x00,0x06]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x01,0x06]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x02,0x06]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x03,0x06]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x04,0x06]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x05,0x06]

v_cmp_nlg_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x16,0x06]

v_cmp_nlg_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x26,0x06]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x06,0x00]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x06,0x01]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x06,0x02]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x06,0x03]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x06,0x04]

v_cmp_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x06,0x05]

v_cmp_nlg_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x06,0x16]

v_cmp_nlg_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7c,0x01,0x00,0x06,0x26]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ngt_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0xff,0x00,0x06,0x06]

v_cmp_ngt_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x97,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ngt_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x20,0x06,0x06]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x00,0x06]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x01,0x06]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x02,0x06]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x03,0x06]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x04,0x06]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x05,0x06]

v_cmp_ngt_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x16,0x06]

v_cmp_ngt_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x26,0x06]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x06,0x06]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x06,0x00]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x06,0x01]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x06,0x02]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x06,0x03]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x06,0x04]

v_cmp_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x06,0x05]

v_cmp_ngt_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x06,0x16]

v_cmp_ngt_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7c,0x01,0x00,0x06,0x26]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nle_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0xff,0x00,0x06,0x06]

v_cmp_nle_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x99,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nle_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x20,0x06,0x06]

v_cmp_nle_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x00,0x06]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x01,0x06]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x02,0x06]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x03,0x06]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x04,0x06]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x05,0x06]

v_cmp_nle_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x16,0x06]

v_cmp_nle_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x26,0x06]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x06,0x00]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x06,0x01]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x06,0x02]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x06,0x03]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x06,0x04]

v_cmp_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x06,0x05]

v_cmp_nle_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x06,0x16]

v_cmp_nle_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7c,0x01,0x00,0x06,0x26]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x06,0x06]

v_cmp_neq_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0xff,0x00,0x06,0x06]

v_cmp_neq_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x9b,0x7c,0x01,0x00,0x06,0x06]

v_cmp_neq_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x20,0x06,0x06]

v_cmp_neq_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x06,0x06]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x00,0x06]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x01,0x06]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x02,0x06]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x03,0x06]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x04,0x06]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x05,0x06]

v_cmp_neq_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x16,0x06]

v_cmp_neq_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x26,0x06]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x06,0x06]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x06,0x00]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x06,0x01]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x06,0x02]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x06,0x03]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x06,0x04]

v_cmp_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x06,0x05]

v_cmp_neq_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x06,0x16]

v_cmp_neq_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7c,0x01,0x00,0x06,0x26]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlt_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0xff,0x00,0x06,0x06]

v_cmp_nlt_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x9d,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlt_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x20,0x06,0x06]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x00,0x06]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x01,0x06]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x02,0x06]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x03,0x06]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x04,0x06]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x05,0x06]

v_cmp_nlt_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x16,0x06]

v_cmp_nlt_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x26,0x06]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x06,0x06]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x06,0x00]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x06,0x01]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x06,0x02]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x06,0x03]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x06,0x04]

v_cmp_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x06,0x05]

v_cmp_nlt_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x06,0x16]

v_cmp_nlt_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7c,0x01,0x00,0x06,0x26]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x06,0x06]

v_cmp_tru_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0xff,0x00,0x06,0x06]

v_cmp_tru_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x9f,0x7c,0x01,0x00,0x06,0x06]

v_cmp_tru_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x20,0x06,0x06]

v_cmp_tru_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x06,0x06]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x00,0x06]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x01,0x06]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x02,0x06]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x03,0x06]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x04,0x06]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x05,0x06]

v_cmp_tru_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x16,0x06]

v_cmp_tru_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x26,0x06]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x06,0x06]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x06,0x00]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x06,0x01]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x06,0x02]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x06,0x03]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x06,0x04]

v_cmp_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x06,0x05]

v_cmp_tru_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x06,0x16]

v_cmp_tru_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_f_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_f_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xa1,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_f_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_f_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_f_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_f_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_f_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_f_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_f_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lt_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_lt_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xa3,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lt_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_lt_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_lt_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_lt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_lt_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_lt_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_eq_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_eq_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xa5,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_eq_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_eq_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_eq_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_eq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_eq_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_eq_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_le_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_le_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xa7,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_le_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_le_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_le_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_le_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_le_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_le_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_le_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_gt_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_gt_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xa9,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_gt_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_gt_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_gt_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_gt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_gt_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_gt_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lg_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_lg_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xab,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lg_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_lg_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_lg_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_lg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_lg_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_lg_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ge_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_ge_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xad,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ge_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_ge_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_ge_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_ge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_ge_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_ge_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_o_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_o_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xaf,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_o_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_o_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_o_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_o_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_o_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_o_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_o_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_u_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_u_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xb1,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_u_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_u_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_u_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_u_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_u_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_u_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_u_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nge_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_nge_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xb3,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nge_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_nge_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_nge_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_nge_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_nge_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_nge_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlg_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_nlg_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xb5,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_nlg_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_nlg_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_nlg_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_nlg_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_nlg_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ngt_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_ngt_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xb7,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_ngt_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_ngt_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_ngt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_ngt_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_ngt_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nle_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_nle_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xb9,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nle_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_nle_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_nle_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_nle_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_nle_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_nle_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_neq_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_neq_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xbb,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_neq_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_neq_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_neq_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_neq_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_neq_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_neq_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlt_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_nlt_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xbd,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_nlt_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_nlt_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_nlt_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_nlt_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_nlt_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_tru_f32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_tru_f32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xbf,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_tru_f32_sdwa vcc, v1, v2 clamp src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x20,0x06,0x06]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_tru_f32_sdwa vcc, -v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_tru_f32_sdwa vcc, |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_tru_f32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_tru_f32_sdwa vcc, v1, -v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_tru_f32_sdwa vcc, v1, |v2| src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7c,0x01,0x00,0x06,0x26]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7d,0xff,0x00,0x06,0x06]

v_cmp_f_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x41,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x00,0x06]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x01,0x06]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x02,0x06]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x03,0x06]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x04,0x06]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x05,0x06]

v_cmp_f_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x06,0x00]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x06,0x01]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x06,0x02]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x06,0x03]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x06,0x04]

v_cmp_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x06,0x05]

v_cmp_f_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x40,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7d,0xff,0x00,0x06,0x06]

v_cmp_lt_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x43,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x00,0x06]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x01,0x06]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x02,0x06]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x03,0x06]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x04,0x06]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x05,0x06]

v_cmp_lt_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x06,0x00]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x06,0x01]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x06,0x02]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x06,0x03]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x06,0x04]

v_cmp_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x06,0x05]

v_cmp_lt_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x42,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7d,0xff,0x00,0x06,0x06]

v_cmp_eq_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x45,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x00,0x06]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x01,0x06]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x02,0x06]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x03,0x06]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x04,0x06]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x05,0x06]

v_cmp_eq_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x06,0x00]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x06,0x01]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x06,0x02]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x06,0x03]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x06,0x04]

v_cmp_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x06,0x05]

v_cmp_eq_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x44,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7d,0xff,0x00,0x06,0x06]

v_cmp_le_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x47,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x00,0x06]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x01,0x06]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x02,0x06]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x03,0x06]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x04,0x06]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x05,0x06]

v_cmp_le_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x06,0x00]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x06,0x01]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x06,0x02]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x06,0x03]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x06,0x04]

v_cmp_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x06,0x05]

v_cmp_le_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x46,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7d,0xff,0x00,0x06,0x06]

v_cmp_gt_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x49,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x00,0x06]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x01,0x06]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x02,0x06]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x03,0x06]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x04,0x06]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x05,0x06]

v_cmp_gt_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x06,0x00]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x06,0x01]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x06,0x02]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x06,0x03]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x06,0x04]

v_cmp_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x06,0x05]

v_cmp_gt_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x48,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7d,0xff,0x00,0x06,0x06]

v_cmp_ne_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x4b,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x00,0x06]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x01,0x06]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x02,0x06]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x03,0x06]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x04,0x06]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x05,0x06]

v_cmp_ne_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x06,0x00]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x06,0x01]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x06,0x02]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x06,0x03]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x06,0x04]

v_cmp_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x06,0x05]

v_cmp_ne_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4a,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7d,0xff,0x00,0x06,0x06]

v_cmp_ge_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x4d,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x00,0x06]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x01,0x06]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x02,0x06]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x03,0x06]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x04,0x06]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x05,0x06]

v_cmp_ge_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x06,0x00]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x06,0x01]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x06,0x02]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x06,0x03]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x06,0x04]

v_cmp_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x06,0x05]

v_cmp_ge_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4c,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7d,0xff,0x00,0x06,0x06]

v_cmp_t_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x4f,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x00,0x06]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x01,0x06]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x02,0x06]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x03,0x06]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x04,0x06]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x05,0x06]

v_cmp_t_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x06,0x00]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x06,0x01]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x06,0x02]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x06,0x03]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x06,0x04]

v_cmp_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x06,0x05]

v_cmp_t_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x4e,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7d,0xff,0x00,0x06,0x06]

v_cmp_f_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x51,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x00,0x06]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x01,0x06]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x02,0x06]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x03,0x06]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x04,0x06]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x05,0x06]

v_cmp_f_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x06,0x00]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x06,0x01]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x06,0x02]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x06,0x03]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x06,0x04]

v_cmp_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x06,0x05]

v_cmp_f_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x50,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7d,0xff,0x00,0x06,0x06]

v_cmp_lt_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x53,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x00,0x06]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x01,0x06]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x02,0x06]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x03,0x06]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x04,0x06]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x05,0x06]

v_cmp_lt_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x06,0x00]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x06,0x01]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x06,0x02]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x06,0x03]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x06,0x04]

v_cmp_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x06,0x05]

v_cmp_lt_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x52,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7d,0xff,0x00,0x06,0x06]

v_cmp_eq_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x55,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x00,0x06]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x01,0x06]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x02,0x06]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x03,0x06]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x04,0x06]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x05,0x06]

v_cmp_eq_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x06,0x00]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x06,0x01]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x06,0x02]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x06,0x03]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x06,0x04]

v_cmp_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x06,0x05]

v_cmp_eq_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x54,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7d,0xff,0x00,0x06,0x06]

v_cmp_le_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x57,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x00,0x06]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x01,0x06]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x02,0x06]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x03,0x06]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x04,0x06]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x05,0x06]

v_cmp_le_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x06,0x00]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x06,0x01]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x06,0x02]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x06,0x03]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x06,0x04]

v_cmp_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x06,0x05]

v_cmp_le_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x56,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7d,0xff,0x00,0x06,0x06]

v_cmp_gt_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x59,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x00,0x06]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x01,0x06]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x02,0x06]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x03,0x06]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x04,0x06]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x05,0x06]

v_cmp_gt_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x06,0x00]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x06,0x01]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x06,0x02]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x06,0x03]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x06,0x04]

v_cmp_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x06,0x05]

v_cmp_gt_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x58,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7d,0xff,0x00,0x06,0x06]

v_cmp_ne_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x5b,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x00,0x06]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x01,0x06]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x02,0x06]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x03,0x06]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x04,0x06]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x05,0x06]

v_cmp_ne_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x06,0x00]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x06,0x01]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x06,0x02]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x06,0x03]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x06,0x04]

v_cmp_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x06,0x05]

v_cmp_ne_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5a,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7d,0xff,0x00,0x06,0x06]

v_cmp_ge_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x5d,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x00,0x06]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x01,0x06]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x02,0x06]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x03,0x06]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x04,0x06]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x05,0x06]

v_cmp_ge_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x06,0x00]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x06,0x01]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x06,0x02]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x06,0x03]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x06,0x04]

v_cmp_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x06,0x05]

v_cmp_ge_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5c,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7d,0xff,0x00,0x06,0x06]

v_cmp_t_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x5f,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x00,0x06]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x01,0x06]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x02,0x06]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x03,0x06]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x04,0x06]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x05,0x06]

v_cmp_t_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x06,0x00]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x06,0x01]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x06,0x02]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x06,0x03]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x06,0x04]

v_cmp_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x06,0x05]

v_cmp_t_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x5e,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_f_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x61,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_f_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_f_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_f_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x60,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_lt_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x63,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_lt_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_lt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_lt_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x62,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_eq_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x65,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_eq_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_eq_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_eq_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x64,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_le_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x67,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_le_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_le_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_le_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x66,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_gt_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x69,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_gt_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_gt_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_gt_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x68,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ne_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x6b,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ne_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ne_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ne_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6a,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ge_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x6d,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ge_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ge_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ge_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6c,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_i16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_t_i16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x6f,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_i16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_t_i16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_t_i16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_t_i16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x6e,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_f_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x71,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_f_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_f_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_f_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x70,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_lt_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x73,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_lt_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_lt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_lt_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_eq_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x75,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_eq_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_eq_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_eq_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_le_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x77,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_le_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_le_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_le_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_gt_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x79,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_gt_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_gt_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_gt_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ne_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x7b,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ne_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ne_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ne_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ge_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x7d,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ge_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ge_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ge_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_u16_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_t_u16_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x7f,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_u16_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_t_u16_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_t_u16_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_t_u16_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x7e,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7d,0xff,0x00,0x06,0x06]

v_cmp_f_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x81,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x00,0x06]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x01,0x06]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x02,0x06]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x03,0x06]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x04,0x06]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x05,0x06]

v_cmp_f_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x06,0x00]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x06,0x01]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x06,0x02]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x06,0x03]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x06,0x04]

v_cmp_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x06,0x05]

v_cmp_f_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x80,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7d,0xff,0x00,0x06,0x06]

v_cmp_lt_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x83,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x00,0x06]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x01,0x06]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x02,0x06]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x03,0x06]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x04,0x06]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x05,0x06]

v_cmp_lt_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x06,0x00]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x06,0x01]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x06,0x02]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x06,0x03]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x06,0x04]

v_cmp_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x06,0x05]

v_cmp_lt_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x82,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7d,0xff,0x00,0x06,0x06]

v_cmp_eq_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x85,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x00,0x06]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x01,0x06]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x02,0x06]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x03,0x06]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x04,0x06]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x05,0x06]

v_cmp_eq_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x06,0x00]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x06,0x01]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x06,0x02]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x06,0x03]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x06,0x04]

v_cmp_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x06,0x05]

v_cmp_eq_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x84,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7d,0xff,0x00,0x06,0x06]

v_cmp_le_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x87,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x00,0x06]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x01,0x06]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x02,0x06]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x03,0x06]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x04,0x06]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x05,0x06]

v_cmp_le_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x06,0x00]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x06,0x01]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x06,0x02]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x06,0x03]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x06,0x04]

v_cmp_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x06,0x05]

v_cmp_le_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x86,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7d,0xff,0x00,0x06,0x06]

v_cmp_gt_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x89,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x00,0x06]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x01,0x06]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x02,0x06]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x03,0x06]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x04,0x06]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x05,0x06]

v_cmp_gt_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x06,0x00]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x06,0x01]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x06,0x02]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x06,0x03]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x06,0x04]

v_cmp_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x06,0x05]

v_cmp_gt_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x88,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7d,0xff,0x00,0x06,0x06]

v_cmp_ne_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x8b,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x00,0x06]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x01,0x06]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x02,0x06]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x03,0x06]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x04,0x06]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x05,0x06]

v_cmp_ne_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x06,0x00]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x06,0x01]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x06,0x02]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x06,0x03]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x06,0x04]

v_cmp_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x06,0x05]

v_cmp_ne_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8a,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7d,0xff,0x00,0x06,0x06]

v_cmp_ge_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x8d,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x00,0x06]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x01,0x06]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x02,0x06]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x03,0x06]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x04,0x06]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x05,0x06]

v_cmp_ge_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x06,0x00]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x06,0x01]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x06,0x02]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x06,0x03]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x06,0x04]

v_cmp_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x06,0x05]

v_cmp_ge_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8c,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7d,0xff,0x00,0x06,0x06]

v_cmp_t_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x8f,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x00,0x06]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x01,0x06]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x02,0x06]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x03,0x06]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x04,0x06]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x05,0x06]

v_cmp_t_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x06,0x00]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x06,0x01]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x06,0x02]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x06,0x03]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x06,0x04]

v_cmp_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x06,0x05]

v_cmp_t_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x8e,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7d,0xff,0x00,0x06,0x06]

v_cmp_f_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x91,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x00,0x06]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x01,0x06]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x02,0x06]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x03,0x06]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x04,0x06]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x05,0x06]

v_cmp_f_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x06,0x06]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x06,0x00]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x06,0x01]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x06,0x02]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x06,0x03]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x06,0x04]

v_cmp_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x06,0x05]

v_cmp_f_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x90,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7d,0xff,0x00,0x06,0x06]

v_cmp_lt_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x93,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x00,0x06]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x01,0x06]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x02,0x06]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x03,0x06]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x04,0x06]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x05,0x06]

v_cmp_lt_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x06,0x06]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x06,0x00]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x06,0x01]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x06,0x02]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x06,0x03]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x06,0x04]

v_cmp_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x06,0x05]

v_cmp_lt_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x92,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7d,0xff,0x00,0x06,0x06]

v_cmp_eq_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x95,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x00,0x06]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x01,0x06]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x02,0x06]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x03,0x06]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x04,0x06]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x05,0x06]

v_cmp_eq_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x06,0x06]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x06,0x00]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x06,0x01]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x06,0x02]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x06,0x03]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x06,0x04]

v_cmp_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x06,0x05]

v_cmp_eq_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x94,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7d,0xff,0x00,0x06,0x06]

v_cmp_le_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x97,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x00,0x06]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x01,0x06]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x02,0x06]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x03,0x06]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x04,0x06]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x05,0x06]

v_cmp_le_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x06,0x06]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x06,0x00]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x06,0x01]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x06,0x02]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x06,0x03]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x06,0x04]

v_cmp_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x06,0x05]

v_cmp_le_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x96,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7d,0xff,0x00,0x06,0x06]

v_cmp_gt_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x99,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x00,0x06]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x01,0x06]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x02,0x06]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x03,0x06]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x04,0x06]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x05,0x06]

v_cmp_gt_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x06,0x06]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x06,0x00]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x06,0x01]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x06,0x02]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x06,0x03]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x06,0x04]

v_cmp_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x06,0x05]

v_cmp_gt_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x98,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7d,0xff,0x00,0x06,0x06]

v_cmp_ne_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x9b,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x00,0x06]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x01,0x06]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x02,0x06]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x03,0x06]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x04,0x06]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x05,0x06]

v_cmp_ne_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x06,0x00]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x06,0x01]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x06,0x02]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x06,0x03]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x06,0x04]

v_cmp_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x06,0x05]

v_cmp_ne_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9a,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7d,0xff,0x00,0x06,0x06]

v_cmp_ge_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x9d,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x00,0x06]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x01,0x06]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x02,0x06]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x03,0x06]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x04,0x06]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x05,0x06]

v_cmp_ge_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x06,0x06]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x06,0x00]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x06,0x01]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x06,0x02]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x06,0x03]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x06,0x04]

v_cmp_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x06,0x05]

v_cmp_ge_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9c,0x7d,0x01,0x00,0x06,0x0e]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7d,0xff,0x00,0x06,0x06]

v_cmp_t_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x9f,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x00,0x06]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x01,0x06]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x02,0x06]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x03,0x06]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x04,0x06]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x05,0x06]

v_cmp_t_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x0e,0x06]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x06,0x06]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x06,0x00]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x06,0x01]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x06,0x02]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x06,0x03]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x06,0x04]

v_cmp_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x06,0x05]

v_cmp_t_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x9e,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_f_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xa1,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_f_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_f_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_f_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_lt_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xa3,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_lt_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_lt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_lt_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_eq_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xa5,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_eq_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_eq_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_eq_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_le_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xa7,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_le_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_le_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_le_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_gt_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xa9,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_gt_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_gt_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_gt_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ne_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xab,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ne_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ne_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ne_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ge_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xad,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ge_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ge_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ge_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_i32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_t_i32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xaf,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_i32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_t_i32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_t_i32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_t_i32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_f_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xb1,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_f_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_f_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_f_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_lt_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xb3,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_lt_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_lt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_lt_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_eq_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xb5,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_eq_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_eq_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_eq_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_le_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xb7,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_le_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_le_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_le_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_gt_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xb9,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_gt_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_gt_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_gt_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ne_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xbb,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ne_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ne_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ne_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ge_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xbd,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ge_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ge_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ge_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_u32_sdwa vcc, v255, v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_t_u32_sdwa vcc, v1, v255 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0xbf,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_u32_sdwa vcc, v1, v2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_t_u32_sdwa vcc, sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_t_u32_sdwa vcc, v1, v2 src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_t_u32_sdwa vcc, v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x0e]
