; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32I %s
; RUN: llc -mtriple=riscv32 -mattr=+a -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV32IA,RV32IA-WMO %s
; RUN: llc -mtriple=riscv32 -mattr=+a,+experimental-ztso -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV32IA,RV32IA-TSO %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I %s
; RUN: llc -mtriple=riscv64 -mattr=+a -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV64IA,RV64IA-WMO %s
; RUN: llc -mtriple=riscv64 -mattr=+a,+experimental-ztso -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV64IA,RV64IA-TSO %s

define i8 @atomicrmw_xchg_i8_monotonic(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a3, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB0_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB0_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a3, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB0_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB0_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_xchg_i8_acquire(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_i8_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV32IA-WMO-NEXT:    mv a5, a1
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB1_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_i8_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    mv a5, a1
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB1_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i8_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV64IA-WMO-NEXT:    mv a5, a1
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB1_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i8_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    mv a5, a1
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB1_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_xchg_i8_release(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_i8_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a4, (a2)
; RV32IA-WMO-NEXT:    mv a5, a1
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB2_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_i8_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    mv a5, a1
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB2_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i8_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a4, (a2)
; RV64IA-WMO-NEXT:    mv a5, a1
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB2_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i8_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    mv a5, a1
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB2_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_xchg_i8_acq_rel(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_i8_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV32IA-WMO-NEXT:    mv a5, a1
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB3_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_i8_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    mv a5, a1
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB3_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i8_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV64IA-WMO-NEXT:    mv a5, a1
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB3_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i8_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    mv a5, a1
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB3_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_xchg_i8_seq_cst(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a3, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a4, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB4_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a3, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a4, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB4_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 %b seq_cst
  ret i8 %1
}

; Ensure the following 'atomicrmw xchg a, {0,-1}` cases are lowered to an
; amoand or amoor with appropriate mask.

define i8 @atomicrmw_xchg_0_i8_monotonic(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_0_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_0_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a1, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a2, 255
; RV32IA-NEXT:    sll a2, a2, a0
; RV32IA-NEXT:    not a2, a2
; RV32IA-NEXT:    amoand.w a1, a2, (a1)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_0_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_0_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a1, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a2, 255
; RV64IA-NEXT:    sllw a2, a2, a0
; RV64IA-NEXT:    not a2, a2
; RV64IA-NEXT:    amoand.w a1, a2, (a1)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 0 monotonic
  ret i8 %1
}

define i8 @atomicrmw_xchg_0_i8_acquire(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_0_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_0_i8_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a2, 255
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    not a2, a2
; RV32IA-WMO-NEXT:    amoand.w.aq a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_0_i8_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a2, 255
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    not a2, a2
; RV32IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_0_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_0_i8_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a2, 255
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    not a2, a2
; RV64IA-WMO-NEXT:    amoand.w.aq a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_0_i8_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a2, 255
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    not a2, a2
; RV64IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 0 acquire
  ret i8 %1
}

define i8 @atomicrmw_xchg_0_i8_release(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_0_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_0_i8_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a2, 255
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    not a2, a2
; RV32IA-WMO-NEXT:    amoand.w.rl a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_0_i8_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a2, 255
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    not a2, a2
; RV32IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_0_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_0_i8_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a2, 255
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    not a2, a2
; RV64IA-WMO-NEXT:    amoand.w.rl a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_0_i8_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a2, 255
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    not a2, a2
; RV64IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 0 release
  ret i8 %1
}

define i8 @atomicrmw_xchg_0_i8_acq_rel(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_0_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_0_i8_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a2, 255
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    not a2, a2
; RV32IA-WMO-NEXT:    amoand.w.aqrl a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_0_i8_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a2, 255
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    not a2, a2
; RV32IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_0_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_0_i8_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a2, 255
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    not a2, a2
; RV64IA-WMO-NEXT:    amoand.w.aqrl a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_0_i8_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a2, 255
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    not a2, a2
; RV64IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 0 acq_rel
  ret i8 %1
}

define i8 @atomicrmw_xchg_0_i8_seq_cst(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_0_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_0_i8_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a2, 255
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    not a2, a2
; RV32IA-WMO-NEXT:    amoand.w.aqrl a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_0_i8_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a2, 255
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    not a2, a2
; RV32IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_0_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_0_i8_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a2, 255
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    not a2, a2
; RV64IA-WMO-NEXT:    amoand.w.aqrl a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_0_i8_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a2, 255
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    not a2, a2
; RV64IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 0 seq_cst
  ret i8 %1
}

define i8 @atomicrmw_xchg_minus_1_i8_monotonic(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_minus_1_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a1, 255
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_minus_1_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a1, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a2, 255
; RV32IA-NEXT:    sll a2, a2, a0
; RV32IA-NEXT:    amoor.w a1, a2, (a1)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_minus_1_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a1, 255
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_minus_1_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a1, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a2, 255
; RV64IA-NEXT:    sllw a2, a2, a0
; RV64IA-NEXT:    amoor.w a1, a2, (a1)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 -1 monotonic
  ret i8 %1
}

define i8 @atomicrmw_xchg_minus_1_i8_acquire(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_minus_1_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a1, 255
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_minus_1_i8_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a2, 255
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    amoor.w.aq a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_minus_1_i8_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a2, 255
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_minus_1_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a1, 255
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_minus_1_i8_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a2, 255
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    amoor.w.aq a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_minus_1_i8_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a2, 255
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 -1 acquire
  ret i8 %1
}

define i8 @atomicrmw_xchg_minus_1_i8_release(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_minus_1_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a1, 255
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_minus_1_i8_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a2, 255
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    amoor.w.rl a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_minus_1_i8_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a2, 255
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_minus_1_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a1, 255
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_minus_1_i8_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a2, 255
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    amoor.w.rl a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_minus_1_i8_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a2, 255
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 -1 release
  ret i8 %1
}

define i8 @atomicrmw_xchg_minus_1_i8_acq_rel(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_minus_1_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a1, 255
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_minus_1_i8_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a2, 255
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    amoor.w.aqrl a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_minus_1_i8_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a2, 255
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_minus_1_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a1, 255
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_minus_1_i8_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a2, 255
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    amoor.w.aqrl a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_minus_1_i8_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a2, 255
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 -1 acq_rel
  ret i8 %1
}

define i8 @atomicrmw_xchg_minus_1_i8_seq_cst(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_minus_1_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a1, 255
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_minus_1_i8_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a2, 255
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    amoor.w.aqrl a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_minus_1_i8_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a2, 255
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_minus_1_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a1, 255
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_minus_1_i8_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a2, 255
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    amoor.w.aqrl a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_minus_1_i8_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a2, 255
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 -1 seq_cst
  ret i8 %1
}

define i8 @atomicrmw_add_i8_monotonic(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_add_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a3, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB15_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    add a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB15_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_add_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a3, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB15_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    add a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB15_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add ptr %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_add_i8_acquire(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_add_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_add_i8_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV32IA-WMO-NEXT:    add a5, a4, a1
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB16_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_add_i8_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    add a5, a4, a1
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB16_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_add_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i8_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV64IA-WMO-NEXT:    add a5, a4, a1
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB16_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i8_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    add a5, a4, a1
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB16_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_add_i8_release(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_add_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_add_i8_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB17_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a4, (a2)
; RV32IA-WMO-NEXT:    add a5, a4, a1
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB17_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_add_i8_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB17_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    add a5, a4, a1
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB17_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_add_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i8_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB17_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a4, (a2)
; RV64IA-WMO-NEXT:    add a5, a4, a1
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB17_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i8_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB17_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    add a5, a4, a1
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB17_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_add_i8_acq_rel(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_add_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_add_i8_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB18_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV32IA-WMO-NEXT:    add a5, a4, a1
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB18_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_add_i8_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB18_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    add a5, a4, a1
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB18_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_add_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i8_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB18_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV64IA-WMO-NEXT:    add a5, a4, a1
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB18_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i8_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB18_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    add a5, a4, a1
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB18_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_add_i8_seq_cst(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_add_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a3, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB19_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a4, (a2)
; RV32IA-NEXT:    add a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB19_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_add_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a3, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB19_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a4, (a2)
; RV64IA-NEXT:    add a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB19_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_sub_i8_monotonic(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_sub_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a3, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB20_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    sub a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB20_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_sub_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a3, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB20_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    sub a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB20_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_sub_i8_acquire(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_sub_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_sub_i8_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV32IA-WMO-NEXT:    sub a5, a4, a1
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB21_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_sub_i8_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    sub a5, a4, a1
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB21_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_sub_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i8_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV64IA-WMO-NEXT:    sub a5, a4, a1
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB21_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i8_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    sub a5, a4, a1
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB21_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_sub_i8_release(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_sub_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_sub_i8_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a4, (a2)
; RV32IA-WMO-NEXT:    sub a5, a4, a1
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB22_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_sub_i8_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    sub a5, a4, a1
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB22_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_sub_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i8_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a4, (a2)
; RV64IA-WMO-NEXT:    sub a5, a4, a1
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB22_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i8_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    sub a5, a4, a1
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB22_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_sub_i8_acq_rel(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_sub_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_sub_i8_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB23_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV32IA-WMO-NEXT:    sub a5, a4, a1
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB23_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_sub_i8_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB23_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    sub a5, a4, a1
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB23_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_sub_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i8_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB23_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV64IA-WMO-NEXT:    sub a5, a4, a1
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB23_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i8_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB23_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    sub a5, a4, a1
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB23_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_sub_i8_seq_cst(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_sub_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a3, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB24_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a4, (a2)
; RV32IA-NEXT:    sub a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB24_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_sub_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a3, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB24_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a4, (a2)
; RV64IA-NEXT:    sub a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB24_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_and_i8_monotonic(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_and_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a3, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    not a3, a3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    or a1, a3, a1
; RV32IA-NEXT:    amoand.w a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_and_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a3, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    or a1, a3, a1
; RV64IA-NEXT:    amoand.w a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw and ptr %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_and_i8_acquire(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_and_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_and_i8_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    not a3, a3
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    or a1, a3, a1
; RV32IA-WMO-NEXT:    amoand.w.aq a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_and_i8_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    not a3, a3
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    or a1, a3, a1
; RV32IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_and_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i8_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    not a3, a3
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    or a1, a3, a1
; RV64IA-WMO-NEXT:    amoand.w.aq a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i8_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    not a3, a3
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    or a1, a3, a1
; RV64IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_and_i8_release(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_and_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_and_i8_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    not a3, a3
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    or a1, a3, a1
; RV32IA-WMO-NEXT:    amoand.w.rl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_and_i8_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    not a3, a3
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    or a1, a3, a1
; RV32IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_and_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i8_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    not a3, a3
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    or a1, a3, a1
; RV64IA-WMO-NEXT:    amoand.w.rl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i8_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    not a3, a3
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    or a1, a3, a1
; RV64IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_and_i8_acq_rel(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_and_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_and_i8_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    not a3, a3
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    or a1, a3, a1
; RV32IA-WMO-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_and_i8_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    not a3, a3
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    or a1, a3, a1
; RV32IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_and_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i8_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    not a3, a3
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    or a1, a3, a1
; RV64IA-WMO-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i8_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    not a3, a3
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    or a1, a3, a1
; RV64IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_and_i8_seq_cst(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_and_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_and_i8_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    not a3, a3
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    or a1, a3, a1
; RV32IA-WMO-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_and_i8_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    not a3, a3
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    or a1, a3, a1
; RV32IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_and_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i8_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    not a3, a3
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    or a1, a3, a1
; RV64IA-WMO-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i8_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    not a3, a3
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    or a1, a3, a1
; RV64IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_nand_i8_monotonic(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_nand_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a3, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB30_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    and a5, a4, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB30_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_nand_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a3, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB30_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    and a5, a4, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB30_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_nand_i8_acquire(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_nand_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_nand_i8_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB31_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV32IA-WMO-NEXT:    and a5, a4, a1
; RV32IA-WMO-NEXT:    not a5, a5
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB31_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_nand_i8_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB31_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    and a5, a4, a1
; RV32IA-TSO-NEXT:    not a5, a5
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB31_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_nand_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_nand_i8_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB31_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV64IA-WMO-NEXT:    and a5, a4, a1
; RV64IA-WMO-NEXT:    not a5, a5
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB31_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_nand_i8_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB31_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    and a5, a4, a1
; RV64IA-TSO-NEXT:    not a5, a5
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB31_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_nand_i8_release(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_nand_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_nand_i8_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB32_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a4, (a2)
; RV32IA-WMO-NEXT:    and a5, a4, a1
; RV32IA-WMO-NEXT:    not a5, a5
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB32_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_nand_i8_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB32_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    and a5, a4, a1
; RV32IA-TSO-NEXT:    not a5, a5
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB32_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_nand_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_nand_i8_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB32_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a4, (a2)
; RV64IA-WMO-NEXT:    and a5, a4, a1
; RV64IA-WMO-NEXT:    not a5, a5
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB32_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_nand_i8_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB32_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    and a5, a4, a1
; RV64IA-TSO-NEXT:    not a5, a5
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB32_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_nand_i8_acq_rel(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_nand_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_nand_i8_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB33_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV32IA-WMO-NEXT:    and a5, a4, a1
; RV32IA-WMO-NEXT:    not a5, a5
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB33_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_nand_i8_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB33_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    and a5, a4, a1
; RV32IA-TSO-NEXT:    not a5, a5
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB33_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_nand_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_nand_i8_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB33_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV64IA-WMO-NEXT:    and a5, a4, a1
; RV64IA-WMO-NEXT:    not a5, a5
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB33_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_nand_i8_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB33_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    and a5, a4, a1
; RV64IA-TSO-NEXT:    not a5, a5
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB33_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_nand_i8_seq_cst(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_nand_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a3, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB34_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a4, (a2)
; RV32IA-NEXT:    and a5, a4, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB34_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_nand_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a3, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB34_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a4, (a2)
; RV64IA-NEXT:    and a5, a4, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB34_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_or_i8_monotonic(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_or_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoor.w a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_or_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoor.w a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw or ptr %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_or_i8_acquire(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_or_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_or_i8_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoor.w.aq a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_or_i8_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_or_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i8_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoor.w.aq a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i8_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_or_i8_release(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_or_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_or_i8_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoor.w.rl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_or_i8_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_or_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i8_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoor.w.rl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i8_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_or_i8_acq_rel(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_or_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_or_i8_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_or_i8_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_or_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i8_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i8_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_or_i8_seq_cst(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_or_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_or_i8_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_or_i8_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_or_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i8_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i8_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_xor_i8_monotonic(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_xor_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoxor.w a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_xor_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoxor.w a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_xor_i8_acquire(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_xor_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xor_i8_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoxor.w.aq a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xor_i8_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_xor_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i8_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoxor.w.aq a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i8_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_xor_i8_release(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_xor_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xor_i8_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoxor.w.rl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xor_i8_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_xor_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i8_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoxor.w.rl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i8_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_xor_i8_acq_rel(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_xor_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xor_i8_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xor_i8_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_xor_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i8_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i8_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_xor_i8_seq_cst(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_xor_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xor_i8_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xor_i8_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_xor_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i8_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i8_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_max_i8_monotonic(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s2, a0, 24
; RV32I-NEXT:    j .LBB45_2
; RV32I-NEXT:  .LBB45_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB45_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB45_4
; RV32I-NEXT:  .LBB45_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s2, a0, .LBB45_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB45_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB45_1
; RV32I-NEXT:  .LBB45_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    li a4, 255
; RV32IA-NEXT:    sll a4, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    xori a3, a3, 24
; RV32IA-NEXT:  .LBB45_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a5, (a2)
; RV32IA-NEXT:    and a7, a5, a4
; RV32IA-NEXT:    mv a6, a5
; RV32IA-NEXT:    sll a7, a7, a3
; RV32IA-NEXT:    sra a7, a7, a3
; RV32IA-NEXT:    bge a7, a1, .LBB45_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB45_1 Depth=1
; RV32IA-NEXT:    xor a6, a5, a1
; RV32IA-NEXT:    and a6, a6, a4
; RV32IA-NEXT:    xor a6, a5, a6
; RV32IA-NEXT:  .LBB45_3: # in Loop: Header=BB45_1 Depth=1
; RV32IA-NEXT:    sc.w a6, a6, (a2)
; RV32IA-NEXT:    bnez a6, .LBB45_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s2, a0, 56
; RV64I-NEXT:    j .LBB45_2
; RV64I-NEXT:  .LBB45_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB45_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB45_4
; RV64I-NEXT:  .LBB45_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a0, .LBB45_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB45_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB45_1
; RV64I-NEXT:  .LBB45_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    li a4, 255
; RV64IA-NEXT:    sllw a4, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    xori a3, a3, 56
; RV64IA-NEXT:  .LBB45_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a5, (a2)
; RV64IA-NEXT:    and a7, a5, a4
; RV64IA-NEXT:    mv a6, a5
; RV64IA-NEXT:    sll a7, a7, a3
; RV64IA-NEXT:    sra a7, a7, a3
; RV64IA-NEXT:    bge a7, a1, .LBB45_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB45_1 Depth=1
; RV64IA-NEXT:    xor a6, a5, a1
; RV64IA-NEXT:    and a6, a6, a4
; RV64IA-NEXT:    xor a6, a5, a6
; RV64IA-NEXT:  .LBB45_3: # in Loop: Header=BB45_1 Depth=1
; RV64IA-NEXT:    sc.w a6, a6, (a2)
; RV64IA-NEXT:    bnez a6, .LBB45_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max ptr %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_max_i8_acquire(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s2, a0, 24
; RV32I-NEXT:    j .LBB46_2
; RV32I-NEXT:  .LBB46_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB46_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB46_4
; RV32I-NEXT:  .LBB46_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s2, a0, .LBB46_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB46_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB46_1
; RV32I-NEXT:  .LBB46_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_max_i8_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a3, a0, 24
; RV32IA-WMO-NEXT:    li a4, 255
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    slli a1, a1, 24
; RV32IA-WMO-NEXT:    srai a1, a1, 24
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    xori a3, a3, 24
; RV32IA-WMO-NEXT:  .LBB46_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a5, (a2)
; RV32IA-WMO-NEXT:    and a7, a5, a4
; RV32IA-WMO-NEXT:    mv a6, a5
; RV32IA-WMO-NEXT:    sll a7, a7, a3
; RV32IA-WMO-NEXT:    sra a7, a7, a3
; RV32IA-WMO-NEXT:    bge a7, a1, .LBB46_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB46_1 Depth=1
; RV32IA-WMO-NEXT:    xor a6, a5, a1
; RV32IA-WMO-NEXT:    and a6, a6, a4
; RV32IA-WMO-NEXT:    xor a6, a5, a6
; RV32IA-WMO-NEXT:  .LBB46_3: # in Loop: Header=BB46_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-WMO-NEXT:    bnez a6, .LBB46_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a5, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_max_i8_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a3, a0, 24
; RV32IA-TSO-NEXT:    li a4, 255
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    slli a1, a1, 24
; RV32IA-TSO-NEXT:    srai a1, a1, 24
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    xori a3, a3, 24
; RV32IA-TSO-NEXT:  .LBB46_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a5, (a2)
; RV32IA-TSO-NEXT:    and a7, a5, a4
; RV32IA-TSO-NEXT:    mv a6, a5
; RV32IA-TSO-NEXT:    sll a7, a7, a3
; RV32IA-TSO-NEXT:    sra a7, a7, a3
; RV32IA-TSO-NEXT:    bge a7, a1, .LBB46_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB46_1 Depth=1
; RV32IA-TSO-NEXT:    xor a6, a5, a1
; RV32IA-TSO-NEXT:    and a6, a6, a4
; RV32IA-TSO-NEXT:    xor a6, a5, a6
; RV32IA-TSO-NEXT:  .LBB46_3: # in Loop: Header=BB46_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-TSO-NEXT:    bnez a6, .LBB46_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a5, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s2, a0, 56
; RV64I-NEXT:    j .LBB46_2
; RV64I-NEXT:  .LBB46_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB46_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB46_4
; RV64I-NEXT:  .LBB46_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a0, .LBB46_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB46_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB46_1
; RV64I-NEXT:  .LBB46_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i8_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a3, a0, 24
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    slli a1, a1, 56
; RV64IA-WMO-NEXT:    srai a1, a1, 56
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    xori a3, a3, 56
; RV64IA-WMO-NEXT:  .LBB46_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a5, (a2)
; RV64IA-WMO-NEXT:    and a7, a5, a4
; RV64IA-WMO-NEXT:    mv a6, a5
; RV64IA-WMO-NEXT:    sll a7, a7, a3
; RV64IA-WMO-NEXT:    sra a7, a7, a3
; RV64IA-WMO-NEXT:    bge a7, a1, .LBB46_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB46_1 Depth=1
; RV64IA-WMO-NEXT:    xor a6, a5, a1
; RV64IA-WMO-NEXT:    and a6, a6, a4
; RV64IA-WMO-NEXT:    xor a6, a5, a6
; RV64IA-WMO-NEXT:  .LBB46_3: # in Loop: Header=BB46_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-WMO-NEXT:    bnez a6, .LBB46_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a5, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i8_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a3, a0, 24
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    slli a1, a1, 56
; RV64IA-TSO-NEXT:    srai a1, a1, 56
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    xori a3, a3, 56
; RV64IA-TSO-NEXT:  .LBB46_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a5, (a2)
; RV64IA-TSO-NEXT:    and a7, a5, a4
; RV64IA-TSO-NEXT:    mv a6, a5
; RV64IA-TSO-NEXT:    sll a7, a7, a3
; RV64IA-TSO-NEXT:    sra a7, a7, a3
; RV64IA-TSO-NEXT:    bge a7, a1, .LBB46_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB46_1 Depth=1
; RV64IA-TSO-NEXT:    xor a6, a5, a1
; RV64IA-TSO-NEXT:    and a6, a6, a4
; RV64IA-TSO-NEXT:    xor a6, a5, a6
; RV64IA-TSO-NEXT:  .LBB46_3: # in Loop: Header=BB46_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-TSO-NEXT:    bnez a6, .LBB46_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a5, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_max_i8_release(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s2, a0, 24
; RV32I-NEXT:    j .LBB47_2
; RV32I-NEXT:  .LBB47_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB47_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB47_4
; RV32I-NEXT:  .LBB47_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s2, a0, .LBB47_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB47_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB47_1
; RV32I-NEXT:  .LBB47_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_max_i8_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a3, a0, 24
; RV32IA-WMO-NEXT:    li a4, 255
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    slli a1, a1, 24
; RV32IA-WMO-NEXT:    srai a1, a1, 24
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    xori a3, a3, 24
; RV32IA-WMO-NEXT:  .LBB47_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a5, (a2)
; RV32IA-WMO-NEXT:    and a7, a5, a4
; RV32IA-WMO-NEXT:    mv a6, a5
; RV32IA-WMO-NEXT:    sll a7, a7, a3
; RV32IA-WMO-NEXT:    sra a7, a7, a3
; RV32IA-WMO-NEXT:    bge a7, a1, .LBB47_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB47_1 Depth=1
; RV32IA-WMO-NEXT:    xor a6, a5, a1
; RV32IA-WMO-NEXT:    and a6, a6, a4
; RV32IA-WMO-NEXT:    xor a6, a5, a6
; RV32IA-WMO-NEXT:  .LBB47_3: # in Loop: Header=BB47_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV32IA-WMO-NEXT:    bnez a6, .LBB47_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a5, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_max_i8_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a3, a0, 24
; RV32IA-TSO-NEXT:    li a4, 255
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    slli a1, a1, 24
; RV32IA-TSO-NEXT:    srai a1, a1, 24
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    xori a3, a3, 24
; RV32IA-TSO-NEXT:  .LBB47_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a5, (a2)
; RV32IA-TSO-NEXT:    and a7, a5, a4
; RV32IA-TSO-NEXT:    mv a6, a5
; RV32IA-TSO-NEXT:    sll a7, a7, a3
; RV32IA-TSO-NEXT:    sra a7, a7, a3
; RV32IA-TSO-NEXT:    bge a7, a1, .LBB47_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB47_1 Depth=1
; RV32IA-TSO-NEXT:    xor a6, a5, a1
; RV32IA-TSO-NEXT:    and a6, a6, a4
; RV32IA-TSO-NEXT:    xor a6, a5, a6
; RV32IA-TSO-NEXT:  .LBB47_3: # in Loop: Header=BB47_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-TSO-NEXT:    bnez a6, .LBB47_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a5, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s2, a0, 56
; RV64I-NEXT:    j .LBB47_2
; RV64I-NEXT:  .LBB47_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB47_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB47_4
; RV64I-NEXT:  .LBB47_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a0, .LBB47_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB47_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB47_1
; RV64I-NEXT:  .LBB47_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i8_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a3, a0, 24
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    slli a1, a1, 56
; RV64IA-WMO-NEXT:    srai a1, a1, 56
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    xori a3, a3, 56
; RV64IA-WMO-NEXT:  .LBB47_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a5, (a2)
; RV64IA-WMO-NEXT:    and a7, a5, a4
; RV64IA-WMO-NEXT:    mv a6, a5
; RV64IA-WMO-NEXT:    sll a7, a7, a3
; RV64IA-WMO-NEXT:    sra a7, a7, a3
; RV64IA-WMO-NEXT:    bge a7, a1, .LBB47_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB47_1 Depth=1
; RV64IA-WMO-NEXT:    xor a6, a5, a1
; RV64IA-WMO-NEXT:    and a6, a6, a4
; RV64IA-WMO-NEXT:    xor a6, a5, a6
; RV64IA-WMO-NEXT:  .LBB47_3: # in Loop: Header=BB47_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV64IA-WMO-NEXT:    bnez a6, .LBB47_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a5, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i8_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a3, a0, 24
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    slli a1, a1, 56
; RV64IA-TSO-NEXT:    srai a1, a1, 56
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    xori a3, a3, 56
; RV64IA-TSO-NEXT:  .LBB47_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a5, (a2)
; RV64IA-TSO-NEXT:    and a7, a5, a4
; RV64IA-TSO-NEXT:    mv a6, a5
; RV64IA-TSO-NEXT:    sll a7, a7, a3
; RV64IA-TSO-NEXT:    sra a7, a7, a3
; RV64IA-TSO-NEXT:    bge a7, a1, .LBB47_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB47_1 Depth=1
; RV64IA-TSO-NEXT:    xor a6, a5, a1
; RV64IA-TSO-NEXT:    and a6, a6, a4
; RV64IA-TSO-NEXT:    xor a6, a5, a6
; RV64IA-TSO-NEXT:  .LBB47_3: # in Loop: Header=BB47_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-TSO-NEXT:    bnez a6, .LBB47_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a5, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_max_i8_acq_rel(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s2, a0, 24
; RV32I-NEXT:    j .LBB48_2
; RV32I-NEXT:  .LBB48_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB48_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB48_4
; RV32I-NEXT:  .LBB48_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s2, a0, .LBB48_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB48_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB48_1
; RV32I-NEXT:  .LBB48_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_max_i8_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a3, a0, 24
; RV32IA-WMO-NEXT:    li a4, 255
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    slli a1, a1, 24
; RV32IA-WMO-NEXT:    srai a1, a1, 24
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    xori a3, a3, 24
; RV32IA-WMO-NEXT:  .LBB48_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a5, (a2)
; RV32IA-WMO-NEXT:    and a7, a5, a4
; RV32IA-WMO-NEXT:    mv a6, a5
; RV32IA-WMO-NEXT:    sll a7, a7, a3
; RV32IA-WMO-NEXT:    sra a7, a7, a3
; RV32IA-WMO-NEXT:    bge a7, a1, .LBB48_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB48_1 Depth=1
; RV32IA-WMO-NEXT:    xor a6, a5, a1
; RV32IA-WMO-NEXT:    and a6, a6, a4
; RV32IA-WMO-NEXT:    xor a6, a5, a6
; RV32IA-WMO-NEXT:  .LBB48_3: # in Loop: Header=BB48_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV32IA-WMO-NEXT:    bnez a6, .LBB48_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a5, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_max_i8_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a3, a0, 24
; RV32IA-TSO-NEXT:    li a4, 255
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    slli a1, a1, 24
; RV32IA-TSO-NEXT:    srai a1, a1, 24
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    xori a3, a3, 24
; RV32IA-TSO-NEXT:  .LBB48_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a5, (a2)
; RV32IA-TSO-NEXT:    and a7, a5, a4
; RV32IA-TSO-NEXT:    mv a6, a5
; RV32IA-TSO-NEXT:    sll a7, a7, a3
; RV32IA-TSO-NEXT:    sra a7, a7, a3
; RV32IA-TSO-NEXT:    bge a7, a1, .LBB48_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB48_1 Depth=1
; RV32IA-TSO-NEXT:    xor a6, a5, a1
; RV32IA-TSO-NEXT:    and a6, a6, a4
; RV32IA-TSO-NEXT:    xor a6, a5, a6
; RV32IA-TSO-NEXT:  .LBB48_3: # in Loop: Header=BB48_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-TSO-NEXT:    bnez a6, .LBB48_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a5, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s2, a0, 56
; RV64I-NEXT:    j .LBB48_2
; RV64I-NEXT:  .LBB48_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB48_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB48_4
; RV64I-NEXT:  .LBB48_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a0, .LBB48_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB48_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB48_1
; RV64I-NEXT:  .LBB48_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i8_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a3, a0, 24
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    slli a1, a1, 56
; RV64IA-WMO-NEXT:    srai a1, a1, 56
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    xori a3, a3, 56
; RV64IA-WMO-NEXT:  .LBB48_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a5, (a2)
; RV64IA-WMO-NEXT:    and a7, a5, a4
; RV64IA-WMO-NEXT:    mv a6, a5
; RV64IA-WMO-NEXT:    sll a7, a7, a3
; RV64IA-WMO-NEXT:    sra a7, a7, a3
; RV64IA-WMO-NEXT:    bge a7, a1, .LBB48_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB48_1 Depth=1
; RV64IA-WMO-NEXT:    xor a6, a5, a1
; RV64IA-WMO-NEXT:    and a6, a6, a4
; RV64IA-WMO-NEXT:    xor a6, a5, a6
; RV64IA-WMO-NEXT:  .LBB48_3: # in Loop: Header=BB48_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV64IA-WMO-NEXT:    bnez a6, .LBB48_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a5, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i8_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a3, a0, 24
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    slli a1, a1, 56
; RV64IA-TSO-NEXT:    srai a1, a1, 56
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    xori a3, a3, 56
; RV64IA-TSO-NEXT:  .LBB48_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a5, (a2)
; RV64IA-TSO-NEXT:    and a7, a5, a4
; RV64IA-TSO-NEXT:    mv a6, a5
; RV64IA-TSO-NEXT:    sll a7, a7, a3
; RV64IA-TSO-NEXT:    sra a7, a7, a3
; RV64IA-TSO-NEXT:    bge a7, a1, .LBB48_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB48_1 Depth=1
; RV64IA-TSO-NEXT:    xor a6, a5, a1
; RV64IA-TSO-NEXT:    and a6, a6, a4
; RV64IA-TSO-NEXT:    xor a6, a5, a6
; RV64IA-TSO-NEXT:  .LBB48_3: # in Loop: Header=BB48_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-TSO-NEXT:    bnez a6, .LBB48_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a5, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_max_i8_seq_cst(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s2, a0, 24
; RV32I-NEXT:    j .LBB49_2
; RV32I-NEXT:  .LBB49_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB49_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB49_4
; RV32I-NEXT:  .LBB49_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s2, a0, .LBB49_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB49_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB49_1
; RV32I-NEXT:  .LBB49_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    li a4, 255
; RV32IA-NEXT:    sll a4, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    xori a3, a3, 24
; RV32IA-NEXT:  .LBB49_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a5, (a2)
; RV32IA-NEXT:    and a7, a5, a4
; RV32IA-NEXT:    mv a6, a5
; RV32IA-NEXT:    sll a7, a7, a3
; RV32IA-NEXT:    sra a7, a7, a3
; RV32IA-NEXT:    bge a7, a1, .LBB49_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB49_1 Depth=1
; RV32IA-NEXT:    xor a6, a5, a1
; RV32IA-NEXT:    and a6, a6, a4
; RV32IA-NEXT:    xor a6, a5, a6
; RV32IA-NEXT:  .LBB49_3: # in Loop: Header=BB49_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a6, a6, (a2)
; RV32IA-NEXT:    bnez a6, .LBB49_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s2, a0, 56
; RV64I-NEXT:    j .LBB49_2
; RV64I-NEXT:  .LBB49_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB49_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB49_4
; RV64I-NEXT:  .LBB49_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a0, .LBB49_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB49_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB49_1
; RV64I-NEXT:  .LBB49_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    li a4, 255
; RV64IA-NEXT:    sllw a4, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    xori a3, a3, 56
; RV64IA-NEXT:  .LBB49_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a5, (a2)
; RV64IA-NEXT:    and a7, a5, a4
; RV64IA-NEXT:    mv a6, a5
; RV64IA-NEXT:    sll a7, a7, a3
; RV64IA-NEXT:    sra a7, a7, a3
; RV64IA-NEXT:    bge a7, a1, .LBB49_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB49_1 Depth=1
; RV64IA-NEXT:    xor a6, a5, a1
; RV64IA-NEXT:    and a6, a6, a4
; RV64IA-NEXT:    xor a6, a5, a6
; RV64IA-NEXT:  .LBB49_3: # in Loop: Header=BB49_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a6, a6, (a2)
; RV64IA-NEXT:    bnez a6, .LBB49_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_min_i8_monotonic(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s2, a0, 24
; RV32I-NEXT:    j .LBB50_2
; RV32I-NEXT:  .LBB50_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB50_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB50_4
; RV32I-NEXT:  .LBB50_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s2, a0, .LBB50_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB50_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB50_1
; RV32I-NEXT:  .LBB50_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    li a4, 255
; RV32IA-NEXT:    sll a4, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    xori a3, a3, 24
; RV32IA-NEXT:  .LBB50_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a5, (a2)
; RV32IA-NEXT:    and a7, a5, a4
; RV32IA-NEXT:    mv a6, a5
; RV32IA-NEXT:    sll a7, a7, a3
; RV32IA-NEXT:    sra a7, a7, a3
; RV32IA-NEXT:    bge a1, a7, .LBB50_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB50_1 Depth=1
; RV32IA-NEXT:    xor a6, a5, a1
; RV32IA-NEXT:    and a6, a6, a4
; RV32IA-NEXT:    xor a6, a5, a6
; RV32IA-NEXT:  .LBB50_3: # in Loop: Header=BB50_1 Depth=1
; RV32IA-NEXT:    sc.w a6, a6, (a2)
; RV32IA-NEXT:    bnez a6, .LBB50_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s2, a0, 56
; RV64I-NEXT:    j .LBB50_2
; RV64I-NEXT:  .LBB50_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB50_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB50_4
; RV64I-NEXT:  .LBB50_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a0, .LBB50_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB50_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB50_1
; RV64I-NEXT:  .LBB50_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    li a4, 255
; RV64IA-NEXT:    sllw a4, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    xori a3, a3, 56
; RV64IA-NEXT:  .LBB50_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a5, (a2)
; RV64IA-NEXT:    and a7, a5, a4
; RV64IA-NEXT:    mv a6, a5
; RV64IA-NEXT:    sll a7, a7, a3
; RV64IA-NEXT:    sra a7, a7, a3
; RV64IA-NEXT:    bge a1, a7, .LBB50_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB50_1 Depth=1
; RV64IA-NEXT:    xor a6, a5, a1
; RV64IA-NEXT:    and a6, a6, a4
; RV64IA-NEXT:    xor a6, a5, a6
; RV64IA-NEXT:  .LBB50_3: # in Loop: Header=BB50_1 Depth=1
; RV64IA-NEXT:    sc.w a6, a6, (a2)
; RV64IA-NEXT:    bnez a6, .LBB50_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min ptr %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_min_i8_acquire(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s2, a0, 24
; RV32I-NEXT:    j .LBB51_2
; RV32I-NEXT:  .LBB51_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB51_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB51_4
; RV32I-NEXT:  .LBB51_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s2, a0, .LBB51_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB51_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB51_1
; RV32I-NEXT:  .LBB51_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_min_i8_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a3, a0, 24
; RV32IA-WMO-NEXT:    li a4, 255
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    slli a1, a1, 24
; RV32IA-WMO-NEXT:    srai a1, a1, 24
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    xori a3, a3, 24
; RV32IA-WMO-NEXT:  .LBB51_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a5, (a2)
; RV32IA-WMO-NEXT:    and a7, a5, a4
; RV32IA-WMO-NEXT:    mv a6, a5
; RV32IA-WMO-NEXT:    sll a7, a7, a3
; RV32IA-WMO-NEXT:    sra a7, a7, a3
; RV32IA-WMO-NEXT:    bge a1, a7, .LBB51_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB51_1 Depth=1
; RV32IA-WMO-NEXT:    xor a6, a5, a1
; RV32IA-WMO-NEXT:    and a6, a6, a4
; RV32IA-WMO-NEXT:    xor a6, a5, a6
; RV32IA-WMO-NEXT:  .LBB51_3: # in Loop: Header=BB51_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-WMO-NEXT:    bnez a6, .LBB51_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a5, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_min_i8_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a3, a0, 24
; RV32IA-TSO-NEXT:    li a4, 255
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    slli a1, a1, 24
; RV32IA-TSO-NEXT:    srai a1, a1, 24
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    xori a3, a3, 24
; RV32IA-TSO-NEXT:  .LBB51_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a5, (a2)
; RV32IA-TSO-NEXT:    and a7, a5, a4
; RV32IA-TSO-NEXT:    mv a6, a5
; RV32IA-TSO-NEXT:    sll a7, a7, a3
; RV32IA-TSO-NEXT:    sra a7, a7, a3
; RV32IA-TSO-NEXT:    bge a1, a7, .LBB51_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB51_1 Depth=1
; RV32IA-TSO-NEXT:    xor a6, a5, a1
; RV32IA-TSO-NEXT:    and a6, a6, a4
; RV32IA-TSO-NEXT:    xor a6, a5, a6
; RV32IA-TSO-NEXT:  .LBB51_3: # in Loop: Header=BB51_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-TSO-NEXT:    bnez a6, .LBB51_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a5, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s2, a0, 56
; RV64I-NEXT:    j .LBB51_2
; RV64I-NEXT:  .LBB51_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB51_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB51_4
; RV64I-NEXT:  .LBB51_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a0, .LBB51_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB51_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB51_1
; RV64I-NEXT:  .LBB51_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i8_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a3, a0, 24
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    slli a1, a1, 56
; RV64IA-WMO-NEXT:    srai a1, a1, 56
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    xori a3, a3, 56
; RV64IA-WMO-NEXT:  .LBB51_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a5, (a2)
; RV64IA-WMO-NEXT:    and a7, a5, a4
; RV64IA-WMO-NEXT:    mv a6, a5
; RV64IA-WMO-NEXT:    sll a7, a7, a3
; RV64IA-WMO-NEXT:    sra a7, a7, a3
; RV64IA-WMO-NEXT:    bge a1, a7, .LBB51_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB51_1 Depth=1
; RV64IA-WMO-NEXT:    xor a6, a5, a1
; RV64IA-WMO-NEXT:    and a6, a6, a4
; RV64IA-WMO-NEXT:    xor a6, a5, a6
; RV64IA-WMO-NEXT:  .LBB51_3: # in Loop: Header=BB51_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-WMO-NEXT:    bnez a6, .LBB51_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a5, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i8_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a3, a0, 24
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    slli a1, a1, 56
; RV64IA-TSO-NEXT:    srai a1, a1, 56
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    xori a3, a3, 56
; RV64IA-TSO-NEXT:  .LBB51_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a5, (a2)
; RV64IA-TSO-NEXT:    and a7, a5, a4
; RV64IA-TSO-NEXT:    mv a6, a5
; RV64IA-TSO-NEXT:    sll a7, a7, a3
; RV64IA-TSO-NEXT:    sra a7, a7, a3
; RV64IA-TSO-NEXT:    bge a1, a7, .LBB51_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB51_1 Depth=1
; RV64IA-TSO-NEXT:    xor a6, a5, a1
; RV64IA-TSO-NEXT:    and a6, a6, a4
; RV64IA-TSO-NEXT:    xor a6, a5, a6
; RV64IA-TSO-NEXT:  .LBB51_3: # in Loop: Header=BB51_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-TSO-NEXT:    bnez a6, .LBB51_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a5, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_min_i8_release(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s2, a0, 24
; RV32I-NEXT:    j .LBB52_2
; RV32I-NEXT:  .LBB52_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB52_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB52_4
; RV32I-NEXT:  .LBB52_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s2, a0, .LBB52_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB52_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB52_1
; RV32I-NEXT:  .LBB52_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_min_i8_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a3, a0, 24
; RV32IA-WMO-NEXT:    li a4, 255
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    slli a1, a1, 24
; RV32IA-WMO-NEXT:    srai a1, a1, 24
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    xori a3, a3, 24
; RV32IA-WMO-NEXT:  .LBB52_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a5, (a2)
; RV32IA-WMO-NEXT:    and a7, a5, a4
; RV32IA-WMO-NEXT:    mv a6, a5
; RV32IA-WMO-NEXT:    sll a7, a7, a3
; RV32IA-WMO-NEXT:    sra a7, a7, a3
; RV32IA-WMO-NEXT:    bge a1, a7, .LBB52_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB52_1 Depth=1
; RV32IA-WMO-NEXT:    xor a6, a5, a1
; RV32IA-WMO-NEXT:    and a6, a6, a4
; RV32IA-WMO-NEXT:    xor a6, a5, a6
; RV32IA-WMO-NEXT:  .LBB52_3: # in Loop: Header=BB52_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV32IA-WMO-NEXT:    bnez a6, .LBB52_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a5, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_min_i8_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a3, a0, 24
; RV32IA-TSO-NEXT:    li a4, 255
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    slli a1, a1, 24
; RV32IA-TSO-NEXT:    srai a1, a1, 24
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    xori a3, a3, 24
; RV32IA-TSO-NEXT:  .LBB52_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a5, (a2)
; RV32IA-TSO-NEXT:    and a7, a5, a4
; RV32IA-TSO-NEXT:    mv a6, a5
; RV32IA-TSO-NEXT:    sll a7, a7, a3
; RV32IA-TSO-NEXT:    sra a7, a7, a3
; RV32IA-TSO-NEXT:    bge a1, a7, .LBB52_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB52_1 Depth=1
; RV32IA-TSO-NEXT:    xor a6, a5, a1
; RV32IA-TSO-NEXT:    and a6, a6, a4
; RV32IA-TSO-NEXT:    xor a6, a5, a6
; RV32IA-TSO-NEXT:  .LBB52_3: # in Loop: Header=BB52_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-TSO-NEXT:    bnez a6, .LBB52_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a5, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s2, a0, 56
; RV64I-NEXT:    j .LBB52_2
; RV64I-NEXT:  .LBB52_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB52_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB52_4
; RV64I-NEXT:  .LBB52_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a0, .LBB52_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB52_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB52_1
; RV64I-NEXT:  .LBB52_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i8_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a3, a0, 24
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    slli a1, a1, 56
; RV64IA-WMO-NEXT:    srai a1, a1, 56
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    xori a3, a3, 56
; RV64IA-WMO-NEXT:  .LBB52_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a5, (a2)
; RV64IA-WMO-NEXT:    and a7, a5, a4
; RV64IA-WMO-NEXT:    mv a6, a5
; RV64IA-WMO-NEXT:    sll a7, a7, a3
; RV64IA-WMO-NEXT:    sra a7, a7, a3
; RV64IA-WMO-NEXT:    bge a1, a7, .LBB52_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB52_1 Depth=1
; RV64IA-WMO-NEXT:    xor a6, a5, a1
; RV64IA-WMO-NEXT:    and a6, a6, a4
; RV64IA-WMO-NEXT:    xor a6, a5, a6
; RV64IA-WMO-NEXT:  .LBB52_3: # in Loop: Header=BB52_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV64IA-WMO-NEXT:    bnez a6, .LBB52_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a5, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i8_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a3, a0, 24
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    slli a1, a1, 56
; RV64IA-TSO-NEXT:    srai a1, a1, 56
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    xori a3, a3, 56
; RV64IA-TSO-NEXT:  .LBB52_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a5, (a2)
; RV64IA-TSO-NEXT:    and a7, a5, a4
; RV64IA-TSO-NEXT:    mv a6, a5
; RV64IA-TSO-NEXT:    sll a7, a7, a3
; RV64IA-TSO-NEXT:    sra a7, a7, a3
; RV64IA-TSO-NEXT:    bge a1, a7, .LBB52_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB52_1 Depth=1
; RV64IA-TSO-NEXT:    xor a6, a5, a1
; RV64IA-TSO-NEXT:    and a6, a6, a4
; RV64IA-TSO-NEXT:    xor a6, a5, a6
; RV64IA-TSO-NEXT:  .LBB52_3: # in Loop: Header=BB52_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-TSO-NEXT:    bnez a6, .LBB52_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a5, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_min_i8_acq_rel(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s2, a0, 24
; RV32I-NEXT:    j .LBB53_2
; RV32I-NEXT:  .LBB53_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB53_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB53_4
; RV32I-NEXT:  .LBB53_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s2, a0, .LBB53_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB53_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB53_1
; RV32I-NEXT:  .LBB53_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_min_i8_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a3, a0, 24
; RV32IA-WMO-NEXT:    li a4, 255
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    slli a1, a1, 24
; RV32IA-WMO-NEXT:    srai a1, a1, 24
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    xori a3, a3, 24
; RV32IA-WMO-NEXT:  .LBB53_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a5, (a2)
; RV32IA-WMO-NEXT:    and a7, a5, a4
; RV32IA-WMO-NEXT:    mv a6, a5
; RV32IA-WMO-NEXT:    sll a7, a7, a3
; RV32IA-WMO-NEXT:    sra a7, a7, a3
; RV32IA-WMO-NEXT:    bge a1, a7, .LBB53_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB53_1 Depth=1
; RV32IA-WMO-NEXT:    xor a6, a5, a1
; RV32IA-WMO-NEXT:    and a6, a6, a4
; RV32IA-WMO-NEXT:    xor a6, a5, a6
; RV32IA-WMO-NEXT:  .LBB53_3: # in Loop: Header=BB53_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV32IA-WMO-NEXT:    bnez a6, .LBB53_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a5, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_min_i8_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a3, a0, 24
; RV32IA-TSO-NEXT:    li a4, 255
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    slli a1, a1, 24
; RV32IA-TSO-NEXT:    srai a1, a1, 24
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    xori a3, a3, 24
; RV32IA-TSO-NEXT:  .LBB53_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a5, (a2)
; RV32IA-TSO-NEXT:    and a7, a5, a4
; RV32IA-TSO-NEXT:    mv a6, a5
; RV32IA-TSO-NEXT:    sll a7, a7, a3
; RV32IA-TSO-NEXT:    sra a7, a7, a3
; RV32IA-TSO-NEXT:    bge a1, a7, .LBB53_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB53_1 Depth=1
; RV32IA-TSO-NEXT:    xor a6, a5, a1
; RV32IA-TSO-NEXT:    and a6, a6, a4
; RV32IA-TSO-NEXT:    xor a6, a5, a6
; RV32IA-TSO-NEXT:  .LBB53_3: # in Loop: Header=BB53_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-TSO-NEXT:    bnez a6, .LBB53_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a5, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s2, a0, 56
; RV64I-NEXT:    j .LBB53_2
; RV64I-NEXT:  .LBB53_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB53_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB53_4
; RV64I-NEXT:  .LBB53_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a0, .LBB53_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB53_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB53_1
; RV64I-NEXT:  .LBB53_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i8_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a3, a0, 24
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    slli a1, a1, 56
; RV64IA-WMO-NEXT:    srai a1, a1, 56
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    xori a3, a3, 56
; RV64IA-WMO-NEXT:  .LBB53_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a5, (a2)
; RV64IA-WMO-NEXT:    and a7, a5, a4
; RV64IA-WMO-NEXT:    mv a6, a5
; RV64IA-WMO-NEXT:    sll a7, a7, a3
; RV64IA-WMO-NEXT:    sra a7, a7, a3
; RV64IA-WMO-NEXT:    bge a1, a7, .LBB53_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB53_1 Depth=1
; RV64IA-WMO-NEXT:    xor a6, a5, a1
; RV64IA-WMO-NEXT:    and a6, a6, a4
; RV64IA-WMO-NEXT:    xor a6, a5, a6
; RV64IA-WMO-NEXT:  .LBB53_3: # in Loop: Header=BB53_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV64IA-WMO-NEXT:    bnez a6, .LBB53_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a5, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i8_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a3, a0, 24
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    slli a1, a1, 56
; RV64IA-TSO-NEXT:    srai a1, a1, 56
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    xori a3, a3, 56
; RV64IA-TSO-NEXT:  .LBB53_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a5, (a2)
; RV64IA-TSO-NEXT:    and a7, a5, a4
; RV64IA-TSO-NEXT:    mv a6, a5
; RV64IA-TSO-NEXT:    sll a7, a7, a3
; RV64IA-TSO-NEXT:    sra a7, a7, a3
; RV64IA-TSO-NEXT:    bge a1, a7, .LBB53_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB53_1 Depth=1
; RV64IA-TSO-NEXT:    xor a6, a5, a1
; RV64IA-TSO-NEXT:    and a6, a6, a4
; RV64IA-TSO-NEXT:    xor a6, a5, a6
; RV64IA-TSO-NEXT:  .LBB53_3: # in Loop: Header=BB53_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-TSO-NEXT:    bnez a6, .LBB53_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a5, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_min_i8_seq_cst(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s2, a0, 24
; RV32I-NEXT:    j .LBB54_2
; RV32I-NEXT:  .LBB54_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB54_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB54_4
; RV32I-NEXT:  .LBB54_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s2, a0, .LBB54_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB54_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB54_1
; RV32I-NEXT:  .LBB54_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    li a4, 255
; RV32IA-NEXT:    sll a4, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    xori a3, a3, 24
; RV32IA-NEXT:  .LBB54_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a5, (a2)
; RV32IA-NEXT:    and a7, a5, a4
; RV32IA-NEXT:    mv a6, a5
; RV32IA-NEXT:    sll a7, a7, a3
; RV32IA-NEXT:    sra a7, a7, a3
; RV32IA-NEXT:    bge a1, a7, .LBB54_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB54_1 Depth=1
; RV32IA-NEXT:    xor a6, a5, a1
; RV32IA-NEXT:    and a6, a6, a4
; RV32IA-NEXT:    xor a6, a5, a6
; RV32IA-NEXT:  .LBB54_3: # in Loop: Header=BB54_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a6, a6, (a2)
; RV32IA-NEXT:    bnez a6, .LBB54_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s2, a0, 56
; RV64I-NEXT:    j .LBB54_2
; RV64I-NEXT:  .LBB54_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB54_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB54_4
; RV64I-NEXT:  .LBB54_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a0, .LBB54_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB54_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB54_1
; RV64I-NEXT:  .LBB54_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    li a4, 255
; RV64IA-NEXT:    sllw a4, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    xori a3, a3, 56
; RV64IA-NEXT:  .LBB54_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a5, (a2)
; RV64IA-NEXT:    and a7, a5, a4
; RV64IA-NEXT:    mv a6, a5
; RV64IA-NEXT:    sll a7, a7, a3
; RV64IA-NEXT:    sra a7, a7, a3
; RV64IA-NEXT:    bge a1, a7, .LBB54_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB54_1 Depth=1
; RV64IA-NEXT:    xor a6, a5, a1
; RV64IA-NEXT:    and a6, a6, a4
; RV64IA-NEXT:    xor a6, a5, a6
; RV64IA-NEXT:  .LBB54_3: # in Loop: Header=BB54_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a6, a6, (a2)
; RV64IA-NEXT:    bnez a6, .LBB54_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_umax_i8_monotonic(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    andi s2, a1, 255
; RV32I-NEXT:    j .LBB55_2
; RV32I-NEXT:  .LBB55_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB55_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB55_4
; RV32I-NEXT:  .LBB55_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s2, a0, .LBB55_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB55_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB55_1
; RV32I-NEXT:  .LBB55_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a3, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB55_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    and a6, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a6, a1, .LBB55_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB55_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB55_3: # in Loop: Header=BB55_1 Depth=1
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB55_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    andi s2, a1, 255
; RV64I-NEXT:    j .LBB55_2
; RV64I-NEXT:  .LBB55_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB55_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB55_4
; RV64I-NEXT:  .LBB55_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s2, a0, .LBB55_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB55_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB55_1
; RV64I-NEXT:  .LBB55_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a3, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB55_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    and a6, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a6, a1, .LBB55_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB55_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB55_3: # in Loop: Header=BB55_1 Depth=1
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB55_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_umax_i8_acquire(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    andi s2, a1, 255
; RV32I-NEXT:    j .LBB56_2
; RV32I-NEXT:  .LBB56_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB56_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB56_4
; RV32I-NEXT:  .LBB56_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s2, a0, .LBB56_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB56_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB56_1
; RV32I-NEXT:  .LBB56_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umax_i8_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB56_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV32IA-WMO-NEXT:    and a6, a4, a3
; RV32IA-WMO-NEXT:    mv a5, a4
; RV32IA-WMO-NEXT:    bgeu a6, a1, .LBB56_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB56_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a4, a1
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:  .LBB56_3: # in Loop: Header=BB56_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB56_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umax_i8_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB56_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    and a6, a4, a3
; RV32IA-TSO-NEXT:    mv a5, a4
; RV32IA-TSO-NEXT:    bgeu a6, a1, .LBB56_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB56_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a4, a1
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:  .LBB56_3: # in Loop: Header=BB56_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB56_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    andi s2, a1, 255
; RV64I-NEXT:    j .LBB56_2
; RV64I-NEXT:  .LBB56_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB56_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB56_4
; RV64I-NEXT:  .LBB56_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s2, a0, .LBB56_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB56_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB56_1
; RV64I-NEXT:  .LBB56_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i8_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB56_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV64IA-WMO-NEXT:    and a6, a4, a3
; RV64IA-WMO-NEXT:    mv a5, a4
; RV64IA-WMO-NEXT:    bgeu a6, a1, .LBB56_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB56_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a4, a1
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:  .LBB56_3: # in Loop: Header=BB56_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB56_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i8_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB56_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    and a6, a4, a3
; RV64IA-TSO-NEXT:    mv a5, a4
; RV64IA-TSO-NEXT:    bgeu a6, a1, .LBB56_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB56_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a4, a1
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:  .LBB56_3: # in Loop: Header=BB56_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB56_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_umax_i8_release(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    andi s2, a1, 255
; RV32I-NEXT:    j .LBB57_2
; RV32I-NEXT:  .LBB57_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB57_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB57_4
; RV32I-NEXT:  .LBB57_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s2, a0, .LBB57_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB57_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB57_1
; RV32I-NEXT:  .LBB57_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umax_i8_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB57_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a4, (a2)
; RV32IA-WMO-NEXT:    and a6, a4, a3
; RV32IA-WMO-NEXT:    mv a5, a4
; RV32IA-WMO-NEXT:    bgeu a6, a1, .LBB57_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB57_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a4, a1
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:  .LBB57_3: # in Loop: Header=BB57_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB57_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umax_i8_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB57_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    and a6, a4, a3
; RV32IA-TSO-NEXT:    mv a5, a4
; RV32IA-TSO-NEXT:    bgeu a6, a1, .LBB57_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB57_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a4, a1
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:  .LBB57_3: # in Loop: Header=BB57_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB57_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    andi s2, a1, 255
; RV64I-NEXT:    j .LBB57_2
; RV64I-NEXT:  .LBB57_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB57_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB57_4
; RV64I-NEXT:  .LBB57_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s2, a0, .LBB57_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB57_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB57_1
; RV64I-NEXT:  .LBB57_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i8_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB57_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a4, (a2)
; RV64IA-WMO-NEXT:    and a6, a4, a3
; RV64IA-WMO-NEXT:    mv a5, a4
; RV64IA-WMO-NEXT:    bgeu a6, a1, .LBB57_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB57_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a4, a1
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:  .LBB57_3: # in Loop: Header=BB57_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB57_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i8_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB57_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    and a6, a4, a3
; RV64IA-TSO-NEXT:    mv a5, a4
; RV64IA-TSO-NEXT:    bgeu a6, a1, .LBB57_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB57_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a4, a1
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:  .LBB57_3: # in Loop: Header=BB57_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB57_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_umax_i8_acq_rel(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    andi s2, a1, 255
; RV32I-NEXT:    j .LBB58_2
; RV32I-NEXT:  .LBB58_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB58_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB58_4
; RV32I-NEXT:  .LBB58_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s2, a0, .LBB58_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB58_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB58_1
; RV32I-NEXT:  .LBB58_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umax_i8_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB58_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV32IA-WMO-NEXT:    and a6, a4, a3
; RV32IA-WMO-NEXT:    mv a5, a4
; RV32IA-WMO-NEXT:    bgeu a6, a1, .LBB58_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB58_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a4, a1
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:  .LBB58_3: # in Loop: Header=BB58_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB58_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umax_i8_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB58_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    and a6, a4, a3
; RV32IA-TSO-NEXT:    mv a5, a4
; RV32IA-TSO-NEXT:    bgeu a6, a1, .LBB58_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB58_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a4, a1
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:  .LBB58_3: # in Loop: Header=BB58_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB58_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    andi s2, a1, 255
; RV64I-NEXT:    j .LBB58_2
; RV64I-NEXT:  .LBB58_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB58_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB58_4
; RV64I-NEXT:  .LBB58_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s2, a0, .LBB58_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB58_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB58_1
; RV64I-NEXT:  .LBB58_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i8_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB58_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV64IA-WMO-NEXT:    and a6, a4, a3
; RV64IA-WMO-NEXT:    mv a5, a4
; RV64IA-WMO-NEXT:    bgeu a6, a1, .LBB58_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB58_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a4, a1
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:  .LBB58_3: # in Loop: Header=BB58_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB58_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i8_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB58_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    and a6, a4, a3
; RV64IA-TSO-NEXT:    mv a5, a4
; RV64IA-TSO-NEXT:    bgeu a6, a1, .LBB58_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB58_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a4, a1
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:  .LBB58_3: # in Loop: Header=BB58_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB58_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_umax_i8_seq_cst(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    andi s2, a1, 255
; RV32I-NEXT:    j .LBB59_2
; RV32I-NEXT:  .LBB59_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB59_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB59_4
; RV32I-NEXT:  .LBB59_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s2, a0, .LBB59_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB59_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB59_1
; RV32I-NEXT:  .LBB59_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a3, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB59_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a4, (a2)
; RV32IA-NEXT:    and a6, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a6, a1, .LBB59_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB59_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB59_3: # in Loop: Header=BB59_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB59_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    andi s2, a1, 255
; RV64I-NEXT:    j .LBB59_2
; RV64I-NEXT:  .LBB59_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB59_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB59_4
; RV64I-NEXT:  .LBB59_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s2, a0, .LBB59_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB59_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB59_1
; RV64I-NEXT:  .LBB59_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a3, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB59_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a4, (a2)
; RV64IA-NEXT:    and a6, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a6, a1, .LBB59_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB59_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB59_3: # in Loop: Header=BB59_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB59_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_umin_i8_monotonic(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    andi s2, a1, 255
; RV32I-NEXT:    j .LBB60_2
; RV32I-NEXT:  .LBB60_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB60_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB60_4
; RV32I-NEXT:  .LBB60_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s2, a0, .LBB60_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB60_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB60_1
; RV32I-NEXT:  .LBB60_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a3, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB60_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    and a6, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a1, a6, .LBB60_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB60_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB60_3: # in Loop: Header=BB60_1 Depth=1
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB60_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    andi s2, a1, 255
; RV64I-NEXT:    j .LBB60_2
; RV64I-NEXT:  .LBB60_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB60_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB60_4
; RV64I-NEXT:  .LBB60_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s2, a0, .LBB60_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB60_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB60_1
; RV64I-NEXT:  .LBB60_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a3, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB60_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    and a6, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a1, a6, .LBB60_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB60_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB60_3: # in Loop: Header=BB60_1 Depth=1
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB60_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_umin_i8_acquire(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    andi s2, a1, 255
; RV32I-NEXT:    j .LBB61_2
; RV32I-NEXT:  .LBB61_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB61_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB61_4
; RV32I-NEXT:  .LBB61_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s2, a0, .LBB61_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB61_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB61_1
; RV32I-NEXT:  .LBB61_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umin_i8_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB61_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV32IA-WMO-NEXT:    and a6, a4, a3
; RV32IA-WMO-NEXT:    mv a5, a4
; RV32IA-WMO-NEXT:    bgeu a1, a6, .LBB61_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB61_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a4, a1
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:  .LBB61_3: # in Loop: Header=BB61_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB61_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umin_i8_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB61_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    and a6, a4, a3
; RV32IA-TSO-NEXT:    mv a5, a4
; RV32IA-TSO-NEXT:    bgeu a1, a6, .LBB61_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB61_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a4, a1
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:  .LBB61_3: # in Loop: Header=BB61_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB61_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    andi s2, a1, 255
; RV64I-NEXT:    j .LBB61_2
; RV64I-NEXT:  .LBB61_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB61_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB61_4
; RV64I-NEXT:  .LBB61_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s2, a0, .LBB61_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB61_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB61_1
; RV64I-NEXT:  .LBB61_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i8_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB61_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV64IA-WMO-NEXT:    and a6, a4, a3
; RV64IA-WMO-NEXT:    mv a5, a4
; RV64IA-WMO-NEXT:    bgeu a1, a6, .LBB61_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB61_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a4, a1
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:  .LBB61_3: # in Loop: Header=BB61_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB61_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i8_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB61_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    and a6, a4, a3
; RV64IA-TSO-NEXT:    mv a5, a4
; RV64IA-TSO-NEXT:    bgeu a1, a6, .LBB61_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB61_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a4, a1
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:  .LBB61_3: # in Loop: Header=BB61_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB61_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_umin_i8_release(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    andi s2, a1, 255
; RV32I-NEXT:    j .LBB62_2
; RV32I-NEXT:  .LBB62_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB62_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB62_4
; RV32I-NEXT:  .LBB62_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s2, a0, .LBB62_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB62_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB62_1
; RV32I-NEXT:  .LBB62_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umin_i8_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB62_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a4, (a2)
; RV32IA-WMO-NEXT:    and a6, a4, a3
; RV32IA-WMO-NEXT:    mv a5, a4
; RV32IA-WMO-NEXT:    bgeu a1, a6, .LBB62_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB62_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a4, a1
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:  .LBB62_3: # in Loop: Header=BB62_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB62_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umin_i8_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB62_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    and a6, a4, a3
; RV32IA-TSO-NEXT:    mv a5, a4
; RV32IA-TSO-NEXT:    bgeu a1, a6, .LBB62_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB62_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a4, a1
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:  .LBB62_3: # in Loop: Header=BB62_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB62_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    andi s2, a1, 255
; RV64I-NEXT:    j .LBB62_2
; RV64I-NEXT:  .LBB62_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB62_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB62_4
; RV64I-NEXT:  .LBB62_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s2, a0, .LBB62_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB62_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB62_1
; RV64I-NEXT:  .LBB62_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i8_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB62_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a4, (a2)
; RV64IA-WMO-NEXT:    and a6, a4, a3
; RV64IA-WMO-NEXT:    mv a5, a4
; RV64IA-WMO-NEXT:    bgeu a1, a6, .LBB62_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB62_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a4, a1
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:  .LBB62_3: # in Loop: Header=BB62_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB62_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i8_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB62_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    and a6, a4, a3
; RV64IA-TSO-NEXT:    mv a5, a4
; RV64IA-TSO-NEXT:    bgeu a1, a6, .LBB62_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB62_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a4, a1
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:  .LBB62_3: # in Loop: Header=BB62_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB62_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_umin_i8_acq_rel(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    andi s2, a1, 255
; RV32I-NEXT:    j .LBB63_2
; RV32I-NEXT:  .LBB63_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB63_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB63_4
; RV32I-NEXT:  .LBB63_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s2, a0, .LBB63_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB63_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB63_1
; RV32I-NEXT:  .LBB63_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umin_i8_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a3, 255
; RV32IA-WMO-NEXT:    sll a3, a3, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB63_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV32IA-WMO-NEXT:    and a6, a4, a3
; RV32IA-WMO-NEXT:    mv a5, a4
; RV32IA-WMO-NEXT:    bgeu a1, a6, .LBB63_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB63_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a4, a1
; RV32IA-WMO-NEXT:    and a5, a5, a3
; RV32IA-WMO-NEXT:    xor a5, a4, a5
; RV32IA-WMO-NEXT:  .LBB63_3: # in Loop: Header=BB63_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB63_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a4, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umin_i8_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a3, 255
; RV32IA-TSO-NEXT:    sll a3, a3, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB63_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a4, (a2)
; RV32IA-TSO-NEXT:    and a6, a4, a3
; RV32IA-TSO-NEXT:    mv a5, a4
; RV32IA-TSO-NEXT:    bgeu a1, a6, .LBB63_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB63_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a4, a1
; RV32IA-TSO-NEXT:    and a5, a5, a3
; RV32IA-TSO-NEXT:    xor a5, a4, a5
; RV32IA-TSO-NEXT:  .LBB63_3: # in Loop: Header=BB63_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB63_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a4, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    andi s2, a1, 255
; RV64I-NEXT:    j .LBB63_2
; RV64I-NEXT:  .LBB63_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB63_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB63_4
; RV64I-NEXT:  .LBB63_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s2, a0, .LBB63_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB63_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB63_1
; RV64I-NEXT:  .LBB63_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i8_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a3, 255
; RV64IA-WMO-NEXT:    sllw a3, a3, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB63_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a4, (a2)
; RV64IA-WMO-NEXT:    and a6, a4, a3
; RV64IA-WMO-NEXT:    mv a5, a4
; RV64IA-WMO-NEXT:    bgeu a1, a6, .LBB63_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB63_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a4, a1
; RV64IA-WMO-NEXT:    and a5, a5, a3
; RV64IA-WMO-NEXT:    xor a5, a4, a5
; RV64IA-WMO-NEXT:  .LBB63_3: # in Loop: Header=BB63_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB63_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a4, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i8_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a3, 255
; RV64IA-TSO-NEXT:    sllw a3, a3, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB63_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a4, (a2)
; RV64IA-TSO-NEXT:    and a6, a4, a3
; RV64IA-TSO-NEXT:    mv a5, a4
; RV64IA-TSO-NEXT:    bgeu a1, a6, .LBB63_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB63_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a4, a1
; RV64IA-TSO-NEXT:    and a5, a5, a3
; RV64IA-TSO-NEXT:    xor a5, a4, a5
; RV64IA-TSO-NEXT:  .LBB63_3: # in Loop: Header=BB63_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB63_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a4, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_umin_i8_seq_cst(ptr %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    andi s2, a1, 255
; RV32I-NEXT:    j .LBB64_2
; RV32I-NEXT:  .LBB64_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB64_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lbu a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB64_4
; RV32I-NEXT:  .LBB64_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s2, a0, .LBB64_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB64_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB64_1
; RV32I-NEXT:  .LBB64_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a3, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB64_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a4, (a2)
; RV32IA-NEXT:    and a6, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a1, a6, .LBB64_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB64_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB64_3: # in Loop: Header=BB64_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB64_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    andi s2, a1, 255
; RV64I-NEXT:    j .LBB64_2
; RV64I-NEXT:  .LBB64_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB64_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    lbu a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB64_4
; RV64I-NEXT:  .LBB64_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s2, a0, .LBB64_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB64_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB64_1
; RV64I-NEXT:  .LBB64_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    li a3, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB64_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a4, (a2)
; RV64IA-NEXT:    and a6, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a1, a6, .LBB64_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB64_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB64_3: # in Loop: Header=BB64_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB64_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i16 @atomicrmw_xchg_i16_monotonic(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB65_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB65_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addi a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB65_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB65_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_xchg_i16_acquire(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_i16_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB66_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    mv a5, a1
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB66_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_i16_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB66_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    mv a5, a1
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB66_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i16_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB66_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    mv a5, a1
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB66_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i16_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB66_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    mv a5, a1
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB66_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_xchg_i16_release(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_i16_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB67_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a3, (a2)
; RV32IA-WMO-NEXT:    mv a5, a1
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB67_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_i16_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB67_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    mv a5, a1
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB67_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i16_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB67_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a3, (a2)
; RV64IA-WMO-NEXT:    mv a5, a1
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB67_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i16_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB67_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    mv a5, a1
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB67_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_xchg_i16_acq_rel(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_i16_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB68_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    mv a5, a1
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB68_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_i16_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB68_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    mv a5, a1
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB68_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i16_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB68_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    mv a5, a1
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB68_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i16_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB68_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    mv a5, a1
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB68_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_xchg_i16_seq_cst(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB69_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB69_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addi a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB69_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB69_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 %b seq_cst
  ret i16 %1
}

; Ensure the following 'atomicrmw xchg a, {0,-1}` cases are lowered to an
; amoand or amoor with appropriate mask.

define i16 @atomicrmw_xchg_0_i16_monotonic(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_0_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_0_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a1, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a2, 16
; RV32IA-NEXT:    addi a2, a2, -1
; RV32IA-NEXT:    sll a2, a2, a0
; RV32IA-NEXT:    not a2, a2
; RV32IA-NEXT:    amoand.w a1, a2, (a1)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_0_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_0_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a1, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a2, 16
; RV64IA-NEXT:    addi a2, a2, -1
; RV64IA-NEXT:    sllw a2, a2, a0
; RV64IA-NEXT:    not a2, a2
; RV64IA-NEXT:    amoand.w a1, a2, (a1)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 0 monotonic
  ret i16 %1
}

define i16 @atomicrmw_xchg_0_i16_acquire(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_0_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_0_i16_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a2, 16
; RV32IA-WMO-NEXT:    addi a2, a2, -1
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    not a2, a2
; RV32IA-WMO-NEXT:    amoand.w.aq a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_0_i16_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a2, 16
; RV32IA-TSO-NEXT:    addi a2, a2, -1
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    not a2, a2
; RV32IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_0_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_0_i16_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a2, 16
; RV64IA-WMO-NEXT:    addi a2, a2, -1
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    not a2, a2
; RV64IA-WMO-NEXT:    amoand.w.aq a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_0_i16_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a2, 16
; RV64IA-TSO-NEXT:    addi a2, a2, -1
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    not a2, a2
; RV64IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 0 acquire
  ret i16 %1
}

define i16 @atomicrmw_xchg_0_i16_release(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_0_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_0_i16_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a2, 16
; RV32IA-WMO-NEXT:    addi a2, a2, -1
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    not a2, a2
; RV32IA-WMO-NEXT:    amoand.w.rl a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_0_i16_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a2, 16
; RV32IA-TSO-NEXT:    addi a2, a2, -1
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    not a2, a2
; RV32IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_0_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_0_i16_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a2, 16
; RV64IA-WMO-NEXT:    addi a2, a2, -1
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    not a2, a2
; RV64IA-WMO-NEXT:    amoand.w.rl a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_0_i16_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a2, 16
; RV64IA-TSO-NEXT:    addi a2, a2, -1
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    not a2, a2
; RV64IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 0 release
  ret i16 %1
}

define i16 @atomicrmw_xchg_0_i16_acq_rel(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_0_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_0_i16_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a2, 16
; RV32IA-WMO-NEXT:    addi a2, a2, -1
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    not a2, a2
; RV32IA-WMO-NEXT:    amoand.w.aqrl a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_0_i16_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a2, 16
; RV32IA-TSO-NEXT:    addi a2, a2, -1
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    not a2, a2
; RV32IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_0_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_0_i16_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a2, 16
; RV64IA-WMO-NEXT:    addi a2, a2, -1
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    not a2, a2
; RV64IA-WMO-NEXT:    amoand.w.aqrl a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_0_i16_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a2, 16
; RV64IA-TSO-NEXT:    addi a2, a2, -1
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    not a2, a2
; RV64IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 0 acq_rel
  ret i16 %1
}

define i16 @atomicrmw_xchg_0_i16_seq_cst(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_0_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_0_i16_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a2, 16
; RV32IA-WMO-NEXT:    addi a2, a2, -1
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    not a2, a2
; RV32IA-WMO-NEXT:    amoand.w.aqrl a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_0_i16_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a2, 16
; RV32IA-TSO-NEXT:    addi a2, a2, -1
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    not a2, a2
; RV32IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_0_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_0_i16_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a2, 16
; RV64IA-WMO-NEXT:    addi a2, a2, -1
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    not a2, a2
; RV64IA-WMO-NEXT:    amoand.w.aqrl a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_0_i16_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a2, 16
; RV64IA-TSO-NEXT:    addi a2, a2, -1
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    not a2, a2
; RV64IA-TSO-NEXT:    amoand.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 0 seq_cst
  ret i16 %1
}

define i16 @atomicrmw_xchg_minus_1_i16_monotonic(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_minus_1_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_minus_1_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a1, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a2, 16
; RV32IA-NEXT:    addi a2, a2, -1
; RV32IA-NEXT:    sll a2, a2, a0
; RV32IA-NEXT:    amoor.w a1, a2, (a1)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_minus_1_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_minus_1_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a1, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a2, 16
; RV64IA-NEXT:    addi a2, a2, -1
; RV64IA-NEXT:    sllw a2, a2, a0
; RV64IA-NEXT:    amoor.w a1, a2, (a1)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 -1 monotonic
  ret i16 %1
}

define i16 @atomicrmw_xchg_minus_1_i16_acquire(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_minus_1_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_minus_1_i16_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a2, 16
; RV32IA-WMO-NEXT:    addi a2, a2, -1
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    amoor.w.aq a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_minus_1_i16_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a2, 16
; RV32IA-TSO-NEXT:    addi a2, a2, -1
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_minus_1_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_minus_1_i16_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a2, 16
; RV64IA-WMO-NEXT:    addi a2, a2, -1
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    amoor.w.aq a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_minus_1_i16_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a2, 16
; RV64IA-TSO-NEXT:    addi a2, a2, -1
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 -1 acquire
  ret i16 %1
}

define i16 @atomicrmw_xchg_minus_1_i16_release(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_minus_1_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_minus_1_i16_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a2, 16
; RV32IA-WMO-NEXT:    addi a2, a2, -1
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    amoor.w.rl a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_minus_1_i16_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a2, 16
; RV32IA-TSO-NEXT:    addi a2, a2, -1
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_minus_1_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_minus_1_i16_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a2, 16
; RV64IA-WMO-NEXT:    addi a2, a2, -1
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    amoor.w.rl a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_minus_1_i16_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a2, 16
; RV64IA-TSO-NEXT:    addi a2, a2, -1
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 -1 release
  ret i16 %1
}

define i16 @atomicrmw_xchg_minus_1_i16_acq_rel(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_minus_1_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_minus_1_i16_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a2, 16
; RV32IA-WMO-NEXT:    addi a2, a2, -1
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    amoor.w.aqrl a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_minus_1_i16_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a2, 16
; RV32IA-TSO-NEXT:    addi a2, a2, -1
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_minus_1_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_minus_1_i16_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a2, 16
; RV64IA-WMO-NEXT:    addi a2, a2, -1
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    amoor.w.aqrl a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_minus_1_i16_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a2, 16
; RV64IA-TSO-NEXT:    addi a2, a2, -1
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 -1 acq_rel
  ret i16 %1
}

define i16 @atomicrmw_xchg_minus_1_i16_seq_cst(ptr %a) nounwind {
; RV32I-LABEL: atomicrmw_xchg_minus_1_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_minus_1_i16_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a1, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a2, 16
; RV32IA-WMO-NEXT:    addi a2, a2, -1
; RV32IA-WMO-NEXT:    sll a2, a2, a0
; RV32IA-WMO-NEXT:    amoor.w.aqrl a1, a2, (a1)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_minus_1_i16_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a1, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a2, 16
; RV32IA-TSO-NEXT:    addi a2, a2, -1
; RV32IA-TSO-NEXT:    sll a2, a2, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_minus_1_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_minus_1_i16_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a1, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a2, 16
; RV64IA-WMO-NEXT:    addi a2, a2, -1
; RV64IA-WMO-NEXT:    sllw a2, a2, a0
; RV64IA-WMO-NEXT:    amoor.w.aqrl a1, a2, (a1)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_minus_1_i16_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a1, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a2, 16
; RV64IA-TSO-NEXT:    addi a2, a2, -1
; RV64IA-TSO-NEXT:    sllw a2, a2, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a2, (a1)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 -1 seq_cst
  ret i16 %1
}

define i16 @atomicrmw_add_i16_monotonic(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_add_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB80_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    add a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB80_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_add_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addi a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB80_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    add a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB80_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add ptr %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_add_i16_acquire(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_add_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_add_i16_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB81_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    add a5, a3, a1
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB81_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_add_i16_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB81_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    add a5, a3, a1
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB81_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_add_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i16_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB81_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    add a5, a3, a1
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB81_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i16_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB81_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    add a5, a3, a1
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB81_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_add_i16_release(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_add_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_add_i16_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB82_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a3, (a2)
; RV32IA-WMO-NEXT:    add a5, a3, a1
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB82_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_add_i16_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB82_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    add a5, a3, a1
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB82_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_add_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i16_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB82_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a3, (a2)
; RV64IA-WMO-NEXT:    add a5, a3, a1
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB82_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i16_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB82_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    add a5, a3, a1
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB82_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_add_i16_acq_rel(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_add_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_add_i16_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB83_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    add a5, a3, a1
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB83_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_add_i16_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB83_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    add a5, a3, a1
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB83_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_add_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i16_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB83_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    add a5, a3, a1
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB83_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i16_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB83_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    add a5, a3, a1
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB83_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_add_i16_seq_cst(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_add_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB84_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a2)
; RV32IA-NEXT:    add a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB84_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_add_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addi a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB84_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a2)
; RV64IA-NEXT:    add a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB84_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_sub_i16_monotonic(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_sub_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB85_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    sub a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB85_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_sub_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addi a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB85_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    sub a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB85_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_sub_i16_acquire(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_sub_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_sub_i16_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB86_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    sub a5, a3, a1
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB86_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_sub_i16_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB86_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    sub a5, a3, a1
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB86_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_sub_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i16_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB86_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    sub a5, a3, a1
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB86_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i16_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB86_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    sub a5, a3, a1
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB86_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_sub_i16_release(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_sub_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_sub_i16_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB87_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a3, (a2)
; RV32IA-WMO-NEXT:    sub a5, a3, a1
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB87_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_sub_i16_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB87_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    sub a5, a3, a1
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB87_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_sub_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i16_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB87_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a3, (a2)
; RV64IA-WMO-NEXT:    sub a5, a3, a1
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB87_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i16_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB87_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    sub a5, a3, a1
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB87_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_sub_i16_acq_rel(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_sub_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_sub_i16_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB88_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    sub a5, a3, a1
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB88_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_sub_i16_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB88_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    sub a5, a3, a1
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB88_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_sub_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i16_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB88_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    sub a5, a3, a1
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB88_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i16_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB88_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    sub a5, a3, a1
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB88_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_sub_i16_seq_cst(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_sub_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB89_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a2)
; RV32IA-NEXT:    sub a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB89_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_sub_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addi a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB89_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a2)
; RV64IA-NEXT:    sub a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB89_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_and_i16_monotonic(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_and_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    not a4, a4
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    or a1, a4, a1
; RV32IA-NEXT:    amoand.w a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_and_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addi a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    not a4, a4
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    or a1, a4, a1
; RV64IA-NEXT:    amoand.w a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw and ptr %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_and_i16_acquire(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_and_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_and_i16_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    not a4, a4
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    or a1, a4, a1
; RV32IA-WMO-NEXT:    amoand.w.aq a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_and_i16_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    not a4, a4
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    or a1, a4, a1
; RV32IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_and_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i16_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    not a4, a4
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    or a1, a4, a1
; RV64IA-WMO-NEXT:    amoand.w.aq a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i16_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    not a4, a4
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    or a1, a4, a1
; RV64IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_and_i16_release(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_and_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_and_i16_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    not a4, a4
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    or a1, a4, a1
; RV32IA-WMO-NEXT:    amoand.w.rl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_and_i16_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    not a4, a4
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    or a1, a4, a1
; RV32IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_and_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i16_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    not a4, a4
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    or a1, a4, a1
; RV64IA-WMO-NEXT:    amoand.w.rl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i16_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    not a4, a4
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    or a1, a4, a1
; RV64IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_and_i16_acq_rel(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_and_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_and_i16_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    not a4, a4
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    or a1, a4, a1
; RV32IA-WMO-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_and_i16_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    not a4, a4
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    or a1, a4, a1
; RV32IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_and_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i16_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    not a4, a4
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    or a1, a4, a1
; RV64IA-WMO-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i16_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    not a4, a4
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    or a1, a4, a1
; RV64IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_and_i16_seq_cst(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_and_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_and_i16_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    not a4, a4
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    or a1, a4, a1
; RV32IA-WMO-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_and_i16_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    not a4, a4
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    or a1, a4, a1
; RV32IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_and_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i16_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    not a4, a4
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    or a1, a4, a1
; RV64IA-WMO-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i16_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    not a4, a4
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    or a1, a4, a1
; RV64IA-TSO-NEXT:    amoand.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_nand_i16_monotonic(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_nand_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB95_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    and a5, a3, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB95_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_nand_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addi a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB95_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    and a5, a3, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB95_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_nand_i16_acquire(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_nand_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_nand_i16_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB96_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    and a5, a3, a1
; RV32IA-WMO-NEXT:    not a5, a5
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB96_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_nand_i16_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB96_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a5, a3, a1
; RV32IA-TSO-NEXT:    not a5, a5
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB96_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_nand_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_nand_i16_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB96_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    and a5, a3, a1
; RV64IA-WMO-NEXT:    not a5, a5
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB96_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_nand_i16_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB96_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a5, a3, a1
; RV64IA-TSO-NEXT:    not a5, a5
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB96_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_nand_i16_release(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_nand_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_nand_i16_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB97_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a3, (a2)
; RV32IA-WMO-NEXT:    and a5, a3, a1
; RV32IA-WMO-NEXT:    not a5, a5
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB97_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_nand_i16_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB97_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a5, a3, a1
; RV32IA-TSO-NEXT:    not a5, a5
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB97_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_nand_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_nand_i16_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB97_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a3, (a2)
; RV64IA-WMO-NEXT:    and a5, a3, a1
; RV64IA-WMO-NEXT:    not a5, a5
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB97_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_nand_i16_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB97_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a5, a3, a1
; RV64IA-TSO-NEXT:    not a5, a5
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB97_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_nand_i16_acq_rel(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_nand_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_nand_i16_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB98_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    and a5, a3, a1
; RV32IA-WMO-NEXT:    not a5, a5
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB98_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_nand_i16_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB98_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a5, a3, a1
; RV32IA-TSO-NEXT:    not a5, a5
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB98_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_nand_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_nand_i16_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB98_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    and a5, a3, a1
; RV64IA-WMO-NEXT:    not a5, a5
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB98_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_nand_i16_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB98_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a5, a3, a1
; RV64IA-TSO-NEXT:    not a5, a5
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB98_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_nand_i16_seq_cst(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_nand_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB99_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a2)
; RV32IA-NEXT:    and a5, a3, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB99_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_nand_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addi a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB99_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a2)
; RV64IA-NEXT:    and a5, a3, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB99_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_or_i16_monotonic(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_or_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srli a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoor.w a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_or_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srli a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoor.w a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw or ptr %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_or_i16_acquire(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_or_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_or_i16_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srli a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoor.w.aq a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_or_i16_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srli a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_or_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i16_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srli a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoor.w.aq a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i16_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srli a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_or_i16_release(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_or_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_or_i16_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srli a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoor.w.rl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_or_i16_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srli a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_or_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i16_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srli a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoor.w.rl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i16_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srli a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_or_i16_acq_rel(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_or_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_or_i16_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srli a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_or_i16_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srli a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_or_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i16_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srli a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i16_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srli a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_or_i16_seq_cst(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_or_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_or_i16_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srli a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_or_i16_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srli a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_or_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i16_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srli a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i16_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srli a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_xor_i16_monotonic(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_xor_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srli a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoxor.w a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_xor_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srli a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoxor.w a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_xor_i16_acquire(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_xor_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xor_i16_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srli a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoxor.w.aq a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xor_i16_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srli a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_xor_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i16_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srli a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoxor.w.aq a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i16_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srli a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_xor_i16_release(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_xor_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xor_i16_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srli a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoxor.w.rl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xor_i16_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srli a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_xor_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i16_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srli a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoxor.w.rl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i16_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srli a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_xor_i16_acq_rel(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_xor_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xor_i16_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srli a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xor_i16_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srli a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_xor_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i16_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srli a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i16_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srli a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_xor_i16_seq_cst(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_xor_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xor_i16_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srli a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV32IA-WMO-NEXT:    srl a0, a1, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xor_i16_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srli a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV32IA-TSO-NEXT:    srl a0, a1, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_xor_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i16_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srli a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV64IA-WMO-NEXT:    srlw a0, a1, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i16_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srli a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    amoxor.w a1, a1, (a2)
; RV64IA-TSO-NEXT:    srlw a0, a1, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_max_i16_monotonic(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s2, a0, 16
; RV32I-NEXT:    j .LBB110_2
; RV32I-NEXT:  .LBB110_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB110_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB110_4
; RV32I-NEXT:  .LBB110_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s2, a0, .LBB110_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB110_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB110_1
; RV32I-NEXT:  .LBB110_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a4, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    li a5, 16
; RV32IA-NEXT:    sub a5, a5, a3
; RV32IA-NEXT:  .LBB110_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    and a7, a3, a4
; RV32IA-NEXT:    mv a6, a3
; RV32IA-NEXT:    sll a7, a7, a5
; RV32IA-NEXT:    sra a7, a7, a5
; RV32IA-NEXT:    bge a7, a1, .LBB110_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB110_1 Depth=1
; RV32IA-NEXT:    xor a6, a3, a1
; RV32IA-NEXT:    and a6, a6, a4
; RV32IA-NEXT:    xor a6, a3, a6
; RV32IA-NEXT:  .LBB110_3: # in Loop: Header=BB110_1 Depth=1
; RV32IA-NEXT:    sc.w a6, a6, (a2)
; RV32IA-NEXT:    bnez a6, .LBB110_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s2, a0, 48
; RV64I-NEXT:    j .LBB110_2
; RV64I-NEXT:  .LBB110_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB110_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB110_4
; RV64I-NEXT:  .LBB110_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a0, .LBB110_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB110_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB110_1
; RV64I-NEXT:  .LBB110_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addi a4, a4, -1
; RV64IA-NEXT:    sllw a4, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    li a5, 48
; RV64IA-NEXT:    sub a5, a5, a3
; RV64IA-NEXT:  .LBB110_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    and a7, a3, a4
; RV64IA-NEXT:    mv a6, a3
; RV64IA-NEXT:    sll a7, a7, a5
; RV64IA-NEXT:    sra a7, a7, a5
; RV64IA-NEXT:    bge a7, a1, .LBB110_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB110_1 Depth=1
; RV64IA-NEXT:    xor a6, a3, a1
; RV64IA-NEXT:    and a6, a6, a4
; RV64IA-NEXT:    xor a6, a3, a6
; RV64IA-NEXT:  .LBB110_3: # in Loop: Header=BB110_1 Depth=1
; RV64IA-NEXT:    sc.w a6, a6, (a2)
; RV64IA-NEXT:    bnez a6, .LBB110_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max ptr %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_max_i16_acquire(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s2, a0, 16
; RV32I-NEXT:    j .LBB111_2
; RV32I-NEXT:  .LBB111_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB111_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB111_4
; RV32I-NEXT:  .LBB111_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s2, a0, .LBB111_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB111_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB111_1
; RV32I-NEXT:  .LBB111_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_max_i16_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a3, a0, 24
; RV32IA-WMO-NEXT:    lui a4, 16
; RV32IA-WMO-NEXT:    addi a4, a4, -1
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srai a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    li a5, 16
; RV32IA-WMO-NEXT:    sub a5, a5, a3
; RV32IA-WMO-NEXT:  .LBB111_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    and a7, a3, a4
; RV32IA-WMO-NEXT:    mv a6, a3
; RV32IA-WMO-NEXT:    sll a7, a7, a5
; RV32IA-WMO-NEXT:    sra a7, a7, a5
; RV32IA-WMO-NEXT:    bge a7, a1, .LBB111_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB111_1 Depth=1
; RV32IA-WMO-NEXT:    xor a6, a3, a1
; RV32IA-WMO-NEXT:    and a6, a6, a4
; RV32IA-WMO-NEXT:    xor a6, a3, a6
; RV32IA-WMO-NEXT:  .LBB111_3: # in Loop: Header=BB111_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-WMO-NEXT:    bnez a6, .LBB111_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_max_i16_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a3, a0, 24
; RV32IA-TSO-NEXT:    lui a4, 16
; RV32IA-TSO-NEXT:    addi a4, a4, -1
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srai a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    li a5, 16
; RV32IA-TSO-NEXT:    sub a5, a5, a3
; RV32IA-TSO-NEXT:  .LBB111_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a7, a3, a4
; RV32IA-TSO-NEXT:    mv a6, a3
; RV32IA-TSO-NEXT:    sll a7, a7, a5
; RV32IA-TSO-NEXT:    sra a7, a7, a5
; RV32IA-TSO-NEXT:    bge a7, a1, .LBB111_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB111_1 Depth=1
; RV32IA-TSO-NEXT:    xor a6, a3, a1
; RV32IA-TSO-NEXT:    and a6, a6, a4
; RV32IA-TSO-NEXT:    xor a6, a3, a6
; RV32IA-TSO-NEXT:  .LBB111_3: # in Loop: Header=BB111_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-TSO-NEXT:    bnez a6, .LBB111_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s2, a0, 48
; RV64I-NEXT:    j .LBB111_2
; RV64I-NEXT:  .LBB111_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB111_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB111_4
; RV64I-NEXT:  .LBB111_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a0, .LBB111_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB111_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB111_1
; RV64I-NEXT:  .LBB111_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i16_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a3, a0, 24
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srai a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    li a5, 48
; RV64IA-WMO-NEXT:    sub a5, a5, a3
; RV64IA-WMO-NEXT:  .LBB111_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    and a7, a3, a4
; RV64IA-WMO-NEXT:    mv a6, a3
; RV64IA-WMO-NEXT:    sll a7, a7, a5
; RV64IA-WMO-NEXT:    sra a7, a7, a5
; RV64IA-WMO-NEXT:    bge a7, a1, .LBB111_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB111_1 Depth=1
; RV64IA-WMO-NEXT:    xor a6, a3, a1
; RV64IA-WMO-NEXT:    and a6, a6, a4
; RV64IA-WMO-NEXT:    xor a6, a3, a6
; RV64IA-WMO-NEXT:  .LBB111_3: # in Loop: Header=BB111_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-WMO-NEXT:    bnez a6, .LBB111_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i16_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a3, a0, 24
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srai a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    li a5, 48
; RV64IA-TSO-NEXT:    sub a5, a5, a3
; RV64IA-TSO-NEXT:  .LBB111_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a7, a3, a4
; RV64IA-TSO-NEXT:    mv a6, a3
; RV64IA-TSO-NEXT:    sll a7, a7, a5
; RV64IA-TSO-NEXT:    sra a7, a7, a5
; RV64IA-TSO-NEXT:    bge a7, a1, .LBB111_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB111_1 Depth=1
; RV64IA-TSO-NEXT:    xor a6, a3, a1
; RV64IA-TSO-NEXT:    and a6, a6, a4
; RV64IA-TSO-NEXT:    xor a6, a3, a6
; RV64IA-TSO-NEXT:  .LBB111_3: # in Loop: Header=BB111_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-TSO-NEXT:    bnez a6, .LBB111_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_max_i16_release(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s2, a0, 16
; RV32I-NEXT:    j .LBB112_2
; RV32I-NEXT:  .LBB112_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB112_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB112_4
; RV32I-NEXT:  .LBB112_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s2, a0, .LBB112_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB112_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB112_1
; RV32I-NEXT:  .LBB112_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_max_i16_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a3, a0, 24
; RV32IA-WMO-NEXT:    lui a4, 16
; RV32IA-WMO-NEXT:    addi a4, a4, -1
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srai a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    li a5, 16
; RV32IA-WMO-NEXT:    sub a5, a5, a3
; RV32IA-WMO-NEXT:  .LBB112_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a3, (a2)
; RV32IA-WMO-NEXT:    and a7, a3, a4
; RV32IA-WMO-NEXT:    mv a6, a3
; RV32IA-WMO-NEXT:    sll a7, a7, a5
; RV32IA-WMO-NEXT:    sra a7, a7, a5
; RV32IA-WMO-NEXT:    bge a7, a1, .LBB112_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB112_1 Depth=1
; RV32IA-WMO-NEXT:    xor a6, a3, a1
; RV32IA-WMO-NEXT:    and a6, a6, a4
; RV32IA-WMO-NEXT:    xor a6, a3, a6
; RV32IA-WMO-NEXT:  .LBB112_3: # in Loop: Header=BB112_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV32IA-WMO-NEXT:    bnez a6, .LBB112_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_max_i16_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a3, a0, 24
; RV32IA-TSO-NEXT:    lui a4, 16
; RV32IA-TSO-NEXT:    addi a4, a4, -1
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srai a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    li a5, 16
; RV32IA-TSO-NEXT:    sub a5, a5, a3
; RV32IA-TSO-NEXT:  .LBB112_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a7, a3, a4
; RV32IA-TSO-NEXT:    mv a6, a3
; RV32IA-TSO-NEXT:    sll a7, a7, a5
; RV32IA-TSO-NEXT:    sra a7, a7, a5
; RV32IA-TSO-NEXT:    bge a7, a1, .LBB112_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB112_1 Depth=1
; RV32IA-TSO-NEXT:    xor a6, a3, a1
; RV32IA-TSO-NEXT:    and a6, a6, a4
; RV32IA-TSO-NEXT:    xor a6, a3, a6
; RV32IA-TSO-NEXT:  .LBB112_3: # in Loop: Header=BB112_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-TSO-NEXT:    bnez a6, .LBB112_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s2, a0, 48
; RV64I-NEXT:    j .LBB112_2
; RV64I-NEXT:  .LBB112_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB112_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB112_4
; RV64I-NEXT:  .LBB112_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a0, .LBB112_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB112_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB112_1
; RV64I-NEXT:  .LBB112_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i16_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a3, a0, 24
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srai a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    li a5, 48
; RV64IA-WMO-NEXT:    sub a5, a5, a3
; RV64IA-WMO-NEXT:  .LBB112_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a3, (a2)
; RV64IA-WMO-NEXT:    and a7, a3, a4
; RV64IA-WMO-NEXT:    mv a6, a3
; RV64IA-WMO-NEXT:    sll a7, a7, a5
; RV64IA-WMO-NEXT:    sra a7, a7, a5
; RV64IA-WMO-NEXT:    bge a7, a1, .LBB112_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB112_1 Depth=1
; RV64IA-WMO-NEXT:    xor a6, a3, a1
; RV64IA-WMO-NEXT:    and a6, a6, a4
; RV64IA-WMO-NEXT:    xor a6, a3, a6
; RV64IA-WMO-NEXT:  .LBB112_3: # in Loop: Header=BB112_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV64IA-WMO-NEXT:    bnez a6, .LBB112_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i16_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a3, a0, 24
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srai a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    li a5, 48
; RV64IA-TSO-NEXT:    sub a5, a5, a3
; RV64IA-TSO-NEXT:  .LBB112_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a7, a3, a4
; RV64IA-TSO-NEXT:    mv a6, a3
; RV64IA-TSO-NEXT:    sll a7, a7, a5
; RV64IA-TSO-NEXT:    sra a7, a7, a5
; RV64IA-TSO-NEXT:    bge a7, a1, .LBB112_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB112_1 Depth=1
; RV64IA-TSO-NEXT:    xor a6, a3, a1
; RV64IA-TSO-NEXT:    and a6, a6, a4
; RV64IA-TSO-NEXT:    xor a6, a3, a6
; RV64IA-TSO-NEXT:  .LBB112_3: # in Loop: Header=BB112_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-TSO-NEXT:    bnez a6, .LBB112_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_max_i16_acq_rel(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s2, a0, 16
; RV32I-NEXT:    j .LBB113_2
; RV32I-NEXT:  .LBB113_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB113_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB113_4
; RV32I-NEXT:  .LBB113_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s2, a0, .LBB113_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB113_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB113_1
; RV32I-NEXT:  .LBB113_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_max_i16_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a3, a0, 24
; RV32IA-WMO-NEXT:    lui a4, 16
; RV32IA-WMO-NEXT:    addi a4, a4, -1
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srai a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    li a5, 16
; RV32IA-WMO-NEXT:    sub a5, a5, a3
; RV32IA-WMO-NEXT:  .LBB113_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    and a7, a3, a4
; RV32IA-WMO-NEXT:    mv a6, a3
; RV32IA-WMO-NEXT:    sll a7, a7, a5
; RV32IA-WMO-NEXT:    sra a7, a7, a5
; RV32IA-WMO-NEXT:    bge a7, a1, .LBB113_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB113_1 Depth=1
; RV32IA-WMO-NEXT:    xor a6, a3, a1
; RV32IA-WMO-NEXT:    and a6, a6, a4
; RV32IA-WMO-NEXT:    xor a6, a3, a6
; RV32IA-WMO-NEXT:  .LBB113_3: # in Loop: Header=BB113_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV32IA-WMO-NEXT:    bnez a6, .LBB113_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_max_i16_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a3, a0, 24
; RV32IA-TSO-NEXT:    lui a4, 16
; RV32IA-TSO-NEXT:    addi a4, a4, -1
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srai a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    li a5, 16
; RV32IA-TSO-NEXT:    sub a5, a5, a3
; RV32IA-TSO-NEXT:  .LBB113_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a7, a3, a4
; RV32IA-TSO-NEXT:    mv a6, a3
; RV32IA-TSO-NEXT:    sll a7, a7, a5
; RV32IA-TSO-NEXT:    sra a7, a7, a5
; RV32IA-TSO-NEXT:    bge a7, a1, .LBB113_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB113_1 Depth=1
; RV32IA-TSO-NEXT:    xor a6, a3, a1
; RV32IA-TSO-NEXT:    and a6, a6, a4
; RV32IA-TSO-NEXT:    xor a6, a3, a6
; RV32IA-TSO-NEXT:  .LBB113_3: # in Loop: Header=BB113_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-TSO-NEXT:    bnez a6, .LBB113_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s2, a0, 48
; RV64I-NEXT:    j .LBB113_2
; RV64I-NEXT:  .LBB113_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB113_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB113_4
; RV64I-NEXT:  .LBB113_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a0, .LBB113_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB113_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB113_1
; RV64I-NEXT:  .LBB113_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i16_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a3, a0, 24
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srai a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    li a5, 48
; RV64IA-WMO-NEXT:    sub a5, a5, a3
; RV64IA-WMO-NEXT:  .LBB113_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    and a7, a3, a4
; RV64IA-WMO-NEXT:    mv a6, a3
; RV64IA-WMO-NEXT:    sll a7, a7, a5
; RV64IA-WMO-NEXT:    sra a7, a7, a5
; RV64IA-WMO-NEXT:    bge a7, a1, .LBB113_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB113_1 Depth=1
; RV64IA-WMO-NEXT:    xor a6, a3, a1
; RV64IA-WMO-NEXT:    and a6, a6, a4
; RV64IA-WMO-NEXT:    xor a6, a3, a6
; RV64IA-WMO-NEXT:  .LBB113_3: # in Loop: Header=BB113_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV64IA-WMO-NEXT:    bnez a6, .LBB113_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i16_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a3, a0, 24
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srai a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    li a5, 48
; RV64IA-TSO-NEXT:    sub a5, a5, a3
; RV64IA-TSO-NEXT:  .LBB113_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a7, a3, a4
; RV64IA-TSO-NEXT:    mv a6, a3
; RV64IA-TSO-NEXT:    sll a7, a7, a5
; RV64IA-TSO-NEXT:    sra a7, a7, a5
; RV64IA-TSO-NEXT:    bge a7, a1, .LBB113_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB113_1 Depth=1
; RV64IA-TSO-NEXT:    xor a6, a3, a1
; RV64IA-TSO-NEXT:    and a6, a6, a4
; RV64IA-TSO-NEXT:    xor a6, a3, a6
; RV64IA-TSO-NEXT:  .LBB113_3: # in Loop: Header=BB113_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-TSO-NEXT:    bnez a6, .LBB113_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_max_i16_seq_cst(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s2, a0, 16
; RV32I-NEXT:    j .LBB114_2
; RV32I-NEXT:  .LBB114_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB114_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB114_4
; RV32I-NEXT:  .LBB114_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s2, a0, .LBB114_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB114_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB114_1
; RV32I-NEXT:  .LBB114_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a4, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    li a5, 16
; RV32IA-NEXT:    sub a5, a5, a3
; RV32IA-NEXT:  .LBB114_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a2)
; RV32IA-NEXT:    and a7, a3, a4
; RV32IA-NEXT:    mv a6, a3
; RV32IA-NEXT:    sll a7, a7, a5
; RV32IA-NEXT:    sra a7, a7, a5
; RV32IA-NEXT:    bge a7, a1, .LBB114_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB114_1 Depth=1
; RV32IA-NEXT:    xor a6, a3, a1
; RV32IA-NEXT:    and a6, a6, a4
; RV32IA-NEXT:    xor a6, a3, a6
; RV32IA-NEXT:  .LBB114_3: # in Loop: Header=BB114_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a6, a6, (a2)
; RV32IA-NEXT:    bnez a6, .LBB114_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s2, a0, 48
; RV64I-NEXT:    j .LBB114_2
; RV64I-NEXT:  .LBB114_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB114_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB114_4
; RV64I-NEXT:  .LBB114_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a0, .LBB114_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB114_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB114_1
; RV64I-NEXT:  .LBB114_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addi a4, a4, -1
; RV64IA-NEXT:    sllw a4, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    li a5, 48
; RV64IA-NEXT:    sub a5, a5, a3
; RV64IA-NEXT:  .LBB114_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a2)
; RV64IA-NEXT:    and a7, a3, a4
; RV64IA-NEXT:    mv a6, a3
; RV64IA-NEXT:    sll a7, a7, a5
; RV64IA-NEXT:    sra a7, a7, a5
; RV64IA-NEXT:    bge a7, a1, .LBB114_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB114_1 Depth=1
; RV64IA-NEXT:    xor a6, a3, a1
; RV64IA-NEXT:    and a6, a6, a4
; RV64IA-NEXT:    xor a6, a3, a6
; RV64IA-NEXT:  .LBB114_3: # in Loop: Header=BB114_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a6, a6, (a2)
; RV64IA-NEXT:    bnez a6, .LBB114_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_min_i16_monotonic(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s2, a0, 16
; RV32I-NEXT:    j .LBB115_2
; RV32I-NEXT:  .LBB115_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB115_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB115_4
; RV32I-NEXT:  .LBB115_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s2, a0, .LBB115_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB115_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB115_1
; RV32I-NEXT:  .LBB115_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a4, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    li a5, 16
; RV32IA-NEXT:    sub a5, a5, a3
; RV32IA-NEXT:  .LBB115_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    and a7, a3, a4
; RV32IA-NEXT:    mv a6, a3
; RV32IA-NEXT:    sll a7, a7, a5
; RV32IA-NEXT:    sra a7, a7, a5
; RV32IA-NEXT:    bge a1, a7, .LBB115_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB115_1 Depth=1
; RV32IA-NEXT:    xor a6, a3, a1
; RV32IA-NEXT:    and a6, a6, a4
; RV32IA-NEXT:    xor a6, a3, a6
; RV32IA-NEXT:  .LBB115_3: # in Loop: Header=BB115_1 Depth=1
; RV32IA-NEXT:    sc.w a6, a6, (a2)
; RV32IA-NEXT:    bnez a6, .LBB115_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s2, a0, 48
; RV64I-NEXT:    j .LBB115_2
; RV64I-NEXT:  .LBB115_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB115_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB115_4
; RV64I-NEXT:  .LBB115_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a0, .LBB115_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB115_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB115_1
; RV64I-NEXT:  .LBB115_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addi a4, a4, -1
; RV64IA-NEXT:    sllw a4, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    li a5, 48
; RV64IA-NEXT:    sub a5, a5, a3
; RV64IA-NEXT:  .LBB115_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    and a7, a3, a4
; RV64IA-NEXT:    mv a6, a3
; RV64IA-NEXT:    sll a7, a7, a5
; RV64IA-NEXT:    sra a7, a7, a5
; RV64IA-NEXT:    bge a1, a7, .LBB115_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB115_1 Depth=1
; RV64IA-NEXT:    xor a6, a3, a1
; RV64IA-NEXT:    and a6, a6, a4
; RV64IA-NEXT:    xor a6, a3, a6
; RV64IA-NEXT:  .LBB115_3: # in Loop: Header=BB115_1 Depth=1
; RV64IA-NEXT:    sc.w a6, a6, (a2)
; RV64IA-NEXT:    bnez a6, .LBB115_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min ptr %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_min_i16_acquire(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s2, a0, 16
; RV32I-NEXT:    j .LBB116_2
; RV32I-NEXT:  .LBB116_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB116_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB116_4
; RV32I-NEXT:  .LBB116_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s2, a0, .LBB116_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB116_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB116_1
; RV32I-NEXT:  .LBB116_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_min_i16_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a3, a0, 24
; RV32IA-WMO-NEXT:    lui a4, 16
; RV32IA-WMO-NEXT:    addi a4, a4, -1
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srai a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    li a5, 16
; RV32IA-WMO-NEXT:    sub a5, a5, a3
; RV32IA-WMO-NEXT:  .LBB116_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    and a7, a3, a4
; RV32IA-WMO-NEXT:    mv a6, a3
; RV32IA-WMO-NEXT:    sll a7, a7, a5
; RV32IA-WMO-NEXT:    sra a7, a7, a5
; RV32IA-WMO-NEXT:    bge a1, a7, .LBB116_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB116_1 Depth=1
; RV32IA-WMO-NEXT:    xor a6, a3, a1
; RV32IA-WMO-NEXT:    and a6, a6, a4
; RV32IA-WMO-NEXT:    xor a6, a3, a6
; RV32IA-WMO-NEXT:  .LBB116_3: # in Loop: Header=BB116_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-WMO-NEXT:    bnez a6, .LBB116_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_min_i16_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a3, a0, 24
; RV32IA-TSO-NEXT:    lui a4, 16
; RV32IA-TSO-NEXT:    addi a4, a4, -1
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srai a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    li a5, 16
; RV32IA-TSO-NEXT:    sub a5, a5, a3
; RV32IA-TSO-NEXT:  .LBB116_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a7, a3, a4
; RV32IA-TSO-NEXT:    mv a6, a3
; RV32IA-TSO-NEXT:    sll a7, a7, a5
; RV32IA-TSO-NEXT:    sra a7, a7, a5
; RV32IA-TSO-NEXT:    bge a1, a7, .LBB116_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB116_1 Depth=1
; RV32IA-TSO-NEXT:    xor a6, a3, a1
; RV32IA-TSO-NEXT:    and a6, a6, a4
; RV32IA-TSO-NEXT:    xor a6, a3, a6
; RV32IA-TSO-NEXT:  .LBB116_3: # in Loop: Header=BB116_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-TSO-NEXT:    bnez a6, .LBB116_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s2, a0, 48
; RV64I-NEXT:    j .LBB116_2
; RV64I-NEXT:  .LBB116_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB116_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB116_4
; RV64I-NEXT:  .LBB116_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a0, .LBB116_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB116_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB116_1
; RV64I-NEXT:  .LBB116_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i16_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a3, a0, 24
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srai a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    li a5, 48
; RV64IA-WMO-NEXT:    sub a5, a5, a3
; RV64IA-WMO-NEXT:  .LBB116_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    and a7, a3, a4
; RV64IA-WMO-NEXT:    mv a6, a3
; RV64IA-WMO-NEXT:    sll a7, a7, a5
; RV64IA-WMO-NEXT:    sra a7, a7, a5
; RV64IA-WMO-NEXT:    bge a1, a7, .LBB116_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB116_1 Depth=1
; RV64IA-WMO-NEXT:    xor a6, a3, a1
; RV64IA-WMO-NEXT:    and a6, a6, a4
; RV64IA-WMO-NEXT:    xor a6, a3, a6
; RV64IA-WMO-NEXT:  .LBB116_3: # in Loop: Header=BB116_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-WMO-NEXT:    bnez a6, .LBB116_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i16_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a3, a0, 24
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srai a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    li a5, 48
; RV64IA-TSO-NEXT:    sub a5, a5, a3
; RV64IA-TSO-NEXT:  .LBB116_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a7, a3, a4
; RV64IA-TSO-NEXT:    mv a6, a3
; RV64IA-TSO-NEXT:    sll a7, a7, a5
; RV64IA-TSO-NEXT:    sra a7, a7, a5
; RV64IA-TSO-NEXT:    bge a1, a7, .LBB116_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB116_1 Depth=1
; RV64IA-TSO-NEXT:    xor a6, a3, a1
; RV64IA-TSO-NEXT:    and a6, a6, a4
; RV64IA-TSO-NEXT:    xor a6, a3, a6
; RV64IA-TSO-NEXT:  .LBB116_3: # in Loop: Header=BB116_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-TSO-NEXT:    bnez a6, .LBB116_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_min_i16_release(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s2, a0, 16
; RV32I-NEXT:    j .LBB117_2
; RV32I-NEXT:  .LBB117_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB117_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB117_4
; RV32I-NEXT:  .LBB117_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s2, a0, .LBB117_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB117_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB117_1
; RV32I-NEXT:  .LBB117_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_min_i16_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a3, a0, 24
; RV32IA-WMO-NEXT:    lui a4, 16
; RV32IA-WMO-NEXT:    addi a4, a4, -1
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srai a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    li a5, 16
; RV32IA-WMO-NEXT:    sub a5, a5, a3
; RV32IA-WMO-NEXT:  .LBB117_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a3, (a2)
; RV32IA-WMO-NEXT:    and a7, a3, a4
; RV32IA-WMO-NEXT:    mv a6, a3
; RV32IA-WMO-NEXT:    sll a7, a7, a5
; RV32IA-WMO-NEXT:    sra a7, a7, a5
; RV32IA-WMO-NEXT:    bge a1, a7, .LBB117_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB117_1 Depth=1
; RV32IA-WMO-NEXT:    xor a6, a3, a1
; RV32IA-WMO-NEXT:    and a6, a6, a4
; RV32IA-WMO-NEXT:    xor a6, a3, a6
; RV32IA-WMO-NEXT:  .LBB117_3: # in Loop: Header=BB117_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV32IA-WMO-NEXT:    bnez a6, .LBB117_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_min_i16_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a3, a0, 24
; RV32IA-TSO-NEXT:    lui a4, 16
; RV32IA-TSO-NEXT:    addi a4, a4, -1
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srai a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    li a5, 16
; RV32IA-TSO-NEXT:    sub a5, a5, a3
; RV32IA-TSO-NEXT:  .LBB117_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a7, a3, a4
; RV32IA-TSO-NEXT:    mv a6, a3
; RV32IA-TSO-NEXT:    sll a7, a7, a5
; RV32IA-TSO-NEXT:    sra a7, a7, a5
; RV32IA-TSO-NEXT:    bge a1, a7, .LBB117_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB117_1 Depth=1
; RV32IA-TSO-NEXT:    xor a6, a3, a1
; RV32IA-TSO-NEXT:    and a6, a6, a4
; RV32IA-TSO-NEXT:    xor a6, a3, a6
; RV32IA-TSO-NEXT:  .LBB117_3: # in Loop: Header=BB117_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-TSO-NEXT:    bnez a6, .LBB117_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s2, a0, 48
; RV64I-NEXT:    j .LBB117_2
; RV64I-NEXT:  .LBB117_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB117_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB117_4
; RV64I-NEXT:  .LBB117_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a0, .LBB117_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB117_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB117_1
; RV64I-NEXT:  .LBB117_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i16_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a3, a0, 24
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srai a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    li a5, 48
; RV64IA-WMO-NEXT:    sub a5, a5, a3
; RV64IA-WMO-NEXT:  .LBB117_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a3, (a2)
; RV64IA-WMO-NEXT:    and a7, a3, a4
; RV64IA-WMO-NEXT:    mv a6, a3
; RV64IA-WMO-NEXT:    sll a7, a7, a5
; RV64IA-WMO-NEXT:    sra a7, a7, a5
; RV64IA-WMO-NEXT:    bge a1, a7, .LBB117_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB117_1 Depth=1
; RV64IA-WMO-NEXT:    xor a6, a3, a1
; RV64IA-WMO-NEXT:    and a6, a6, a4
; RV64IA-WMO-NEXT:    xor a6, a3, a6
; RV64IA-WMO-NEXT:  .LBB117_3: # in Loop: Header=BB117_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV64IA-WMO-NEXT:    bnez a6, .LBB117_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i16_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a3, a0, 24
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srai a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    li a5, 48
; RV64IA-TSO-NEXT:    sub a5, a5, a3
; RV64IA-TSO-NEXT:  .LBB117_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a7, a3, a4
; RV64IA-TSO-NEXT:    mv a6, a3
; RV64IA-TSO-NEXT:    sll a7, a7, a5
; RV64IA-TSO-NEXT:    sra a7, a7, a5
; RV64IA-TSO-NEXT:    bge a1, a7, .LBB117_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB117_1 Depth=1
; RV64IA-TSO-NEXT:    xor a6, a3, a1
; RV64IA-TSO-NEXT:    and a6, a6, a4
; RV64IA-TSO-NEXT:    xor a6, a3, a6
; RV64IA-TSO-NEXT:  .LBB117_3: # in Loop: Header=BB117_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-TSO-NEXT:    bnez a6, .LBB117_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_min_i16_acq_rel(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s2, a0, 16
; RV32I-NEXT:    j .LBB118_2
; RV32I-NEXT:  .LBB118_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB118_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB118_4
; RV32I-NEXT:  .LBB118_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s2, a0, .LBB118_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB118_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB118_1
; RV32I-NEXT:  .LBB118_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_min_i16_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    andi a3, a0, 24
; RV32IA-WMO-NEXT:    lui a4, 16
; RV32IA-WMO-NEXT:    addi a4, a4, -1
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    slli a1, a1, 16
; RV32IA-WMO-NEXT:    srai a1, a1, 16
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    li a5, 16
; RV32IA-WMO-NEXT:    sub a5, a5, a3
; RV32IA-WMO-NEXT:  .LBB118_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    and a7, a3, a4
; RV32IA-WMO-NEXT:    mv a6, a3
; RV32IA-WMO-NEXT:    sll a7, a7, a5
; RV32IA-WMO-NEXT:    sra a7, a7, a5
; RV32IA-WMO-NEXT:    bge a1, a7, .LBB118_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB118_1 Depth=1
; RV32IA-WMO-NEXT:    xor a6, a3, a1
; RV32IA-WMO-NEXT:    and a6, a6, a4
; RV32IA-WMO-NEXT:    xor a6, a3, a6
; RV32IA-WMO-NEXT:  .LBB118_3: # in Loop: Header=BB118_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV32IA-WMO-NEXT:    bnez a6, .LBB118_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_min_i16_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    andi a3, a0, 24
; RV32IA-TSO-NEXT:    lui a4, 16
; RV32IA-TSO-NEXT:    addi a4, a4, -1
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    slli a1, a1, 16
; RV32IA-TSO-NEXT:    srai a1, a1, 16
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    li a5, 16
; RV32IA-TSO-NEXT:    sub a5, a5, a3
; RV32IA-TSO-NEXT:  .LBB118_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a7, a3, a4
; RV32IA-TSO-NEXT:    mv a6, a3
; RV32IA-TSO-NEXT:    sll a7, a7, a5
; RV32IA-TSO-NEXT:    sra a7, a7, a5
; RV32IA-TSO-NEXT:    bge a1, a7, .LBB118_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB118_1 Depth=1
; RV32IA-TSO-NEXT:    xor a6, a3, a1
; RV32IA-TSO-NEXT:    and a6, a6, a4
; RV32IA-TSO-NEXT:    xor a6, a3, a6
; RV32IA-TSO-NEXT:  .LBB118_3: # in Loop: Header=BB118_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV32IA-TSO-NEXT:    bnez a6, .LBB118_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s2, a0, 48
; RV64I-NEXT:    j .LBB118_2
; RV64I-NEXT:  .LBB118_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB118_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB118_4
; RV64I-NEXT:  .LBB118_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a0, .LBB118_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB118_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB118_1
; RV64I-NEXT:  .LBB118_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i16_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    andi a3, a0, 24
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    slli a1, a1, 48
; RV64IA-WMO-NEXT:    srai a1, a1, 48
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    li a5, 48
; RV64IA-WMO-NEXT:    sub a5, a5, a3
; RV64IA-WMO-NEXT:  .LBB118_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    and a7, a3, a4
; RV64IA-WMO-NEXT:    mv a6, a3
; RV64IA-WMO-NEXT:    sll a7, a7, a5
; RV64IA-WMO-NEXT:    sra a7, a7, a5
; RV64IA-WMO-NEXT:    bge a1, a7, .LBB118_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB118_1 Depth=1
; RV64IA-WMO-NEXT:    xor a6, a3, a1
; RV64IA-WMO-NEXT:    and a6, a6, a4
; RV64IA-WMO-NEXT:    xor a6, a3, a6
; RV64IA-WMO-NEXT:  .LBB118_3: # in Loop: Header=BB118_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a6, a6, (a2)
; RV64IA-WMO-NEXT:    bnez a6, .LBB118_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i16_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    andi a3, a0, 24
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    slli a1, a1, 48
; RV64IA-TSO-NEXT:    srai a1, a1, 48
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    li a5, 48
; RV64IA-TSO-NEXT:    sub a5, a5, a3
; RV64IA-TSO-NEXT:  .LBB118_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a7, a3, a4
; RV64IA-TSO-NEXT:    mv a6, a3
; RV64IA-TSO-NEXT:    sll a7, a7, a5
; RV64IA-TSO-NEXT:    sra a7, a7, a5
; RV64IA-TSO-NEXT:    bge a1, a7, .LBB118_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB118_1 Depth=1
; RV64IA-TSO-NEXT:    xor a6, a3, a1
; RV64IA-TSO-NEXT:    and a6, a6, a4
; RV64IA-TSO-NEXT:    xor a6, a3, a6
; RV64IA-TSO-NEXT:  .LBB118_3: # in Loop: Header=BB118_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a6, a6, (a2)
; RV64IA-TSO-NEXT:    bnez a6, .LBB118_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_min_i16_seq_cst(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s2, a0, 16
; RV32I-NEXT:    j .LBB119_2
; RV32I-NEXT:  .LBB119_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB119_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB119_4
; RV32I-NEXT:  .LBB119_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s2, a0, .LBB119_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB119_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB119_1
; RV32I-NEXT:  .LBB119_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a4, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    li a5, 16
; RV32IA-NEXT:    sub a5, a5, a3
; RV32IA-NEXT:  .LBB119_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a2)
; RV32IA-NEXT:    and a7, a3, a4
; RV32IA-NEXT:    mv a6, a3
; RV32IA-NEXT:    sll a7, a7, a5
; RV32IA-NEXT:    sra a7, a7, a5
; RV32IA-NEXT:    bge a1, a7, .LBB119_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB119_1 Depth=1
; RV32IA-NEXT:    xor a6, a3, a1
; RV32IA-NEXT:    and a6, a6, a4
; RV32IA-NEXT:    xor a6, a3, a6
; RV32IA-NEXT:  .LBB119_3: # in Loop: Header=BB119_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a6, a6, (a2)
; RV32IA-NEXT:    bnez a6, .LBB119_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s2, a0, 48
; RV64I-NEXT:    j .LBB119_2
; RV64I-NEXT:  .LBB119_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB119_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB119_4
; RV64I-NEXT:  .LBB119_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a0, .LBB119_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB119_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB119_1
; RV64I-NEXT:  .LBB119_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addi a4, a4, -1
; RV64IA-NEXT:    sllw a4, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    li a5, 48
; RV64IA-NEXT:    sub a5, a5, a3
; RV64IA-NEXT:  .LBB119_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a2)
; RV64IA-NEXT:    and a7, a3, a4
; RV64IA-NEXT:    mv a6, a3
; RV64IA-NEXT:    sll a7, a7, a5
; RV64IA-NEXT:    sra a7, a7, a5
; RV64IA-NEXT:    bge a1, a7, .LBB119_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB119_1 Depth=1
; RV64IA-NEXT:    xor a6, a3, a1
; RV64IA-NEXT:    and a6, a6, a4
; RV64IA-NEXT:    xor a6, a3, a6
; RV64IA-NEXT:  .LBB119_3: # in Loop: Header=BB119_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a6, a6, (a2)
; RV64IA-NEXT:    bnez a6, .LBB119_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_umax_i16_monotonic(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui s2, 16
; RV32I-NEXT:    addi s2, s2, -1
; RV32I-NEXT:    and s3, s0, s2
; RV32I-NEXT:    j .LBB120_2
; RV32I-NEXT:  .LBB120_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB120_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB120_4
; RV32I-NEXT:  .LBB120_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s2
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bltu s3, a0, .LBB120_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB120_2 Depth=1
; RV32I-NEXT:    mv a2, s0
; RV32I-NEXT:    j .LBB120_1
; RV32I-NEXT:  .LBB120_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB120_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    and a6, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a6, a1, .LBB120_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB120_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB120_3: # in Loop: Header=BB120_1 Depth=1
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB120_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui s2, 16
; RV64I-NEXT:    addiw s2, s2, -1
; RV64I-NEXT:    and s3, s0, s2
; RV64I-NEXT:    j .LBB120_2
; RV64I-NEXT:  .LBB120_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB120_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB120_4
; RV64I-NEXT:  .LBB120_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s2
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bltu s3, a0, .LBB120_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB120_2 Depth=1
; RV64I-NEXT:    mv a2, s0
; RV64I-NEXT:    j .LBB120_1
; RV64I-NEXT:  .LBB120_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addi a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB120_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    and a6, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a6, a1, .LBB120_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB120_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB120_3: # in Loop: Header=BB120_1 Depth=1
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB120_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_umax_i16_acquire(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui s2, 16
; RV32I-NEXT:    addi s2, s2, -1
; RV32I-NEXT:    and s3, s0, s2
; RV32I-NEXT:    j .LBB121_2
; RV32I-NEXT:  .LBB121_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB121_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB121_4
; RV32I-NEXT:  .LBB121_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s2
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bltu s3, a0, .LBB121_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB121_2 Depth=1
; RV32I-NEXT:    mv a2, s0
; RV32I-NEXT:    j .LBB121_1
; RV32I-NEXT:  .LBB121_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umax_i16_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB121_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    and a6, a3, a4
; RV32IA-WMO-NEXT:    mv a5, a3
; RV32IA-WMO-NEXT:    bgeu a6, a1, .LBB121_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB121_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a3, a1
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:  .LBB121_3: # in Loop: Header=BB121_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB121_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umax_i16_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB121_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a6, a3, a4
; RV32IA-TSO-NEXT:    mv a5, a3
; RV32IA-TSO-NEXT:    bgeu a6, a1, .LBB121_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB121_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a3, a1
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:  .LBB121_3: # in Loop: Header=BB121_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB121_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui s2, 16
; RV64I-NEXT:    addiw s2, s2, -1
; RV64I-NEXT:    and s3, s0, s2
; RV64I-NEXT:    j .LBB121_2
; RV64I-NEXT:  .LBB121_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB121_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB121_4
; RV64I-NEXT:  .LBB121_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s2
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bltu s3, a0, .LBB121_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB121_2 Depth=1
; RV64I-NEXT:    mv a2, s0
; RV64I-NEXT:    j .LBB121_1
; RV64I-NEXT:  .LBB121_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i16_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB121_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    and a6, a3, a4
; RV64IA-WMO-NEXT:    mv a5, a3
; RV64IA-WMO-NEXT:    bgeu a6, a1, .LBB121_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB121_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a3, a1
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:  .LBB121_3: # in Loop: Header=BB121_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB121_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i16_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB121_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a6, a3, a4
; RV64IA-TSO-NEXT:    mv a5, a3
; RV64IA-TSO-NEXT:    bgeu a6, a1, .LBB121_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB121_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a3, a1
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:  .LBB121_3: # in Loop: Header=BB121_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB121_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_umax_i16_release(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui s2, 16
; RV32I-NEXT:    addi s2, s2, -1
; RV32I-NEXT:    and s3, s0, s2
; RV32I-NEXT:    j .LBB122_2
; RV32I-NEXT:  .LBB122_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB122_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB122_4
; RV32I-NEXT:  .LBB122_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s2
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bltu s3, a0, .LBB122_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB122_2 Depth=1
; RV32I-NEXT:    mv a2, s0
; RV32I-NEXT:    j .LBB122_1
; RV32I-NEXT:  .LBB122_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umax_i16_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB122_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a3, (a2)
; RV32IA-WMO-NEXT:    and a6, a3, a4
; RV32IA-WMO-NEXT:    mv a5, a3
; RV32IA-WMO-NEXT:    bgeu a6, a1, .LBB122_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB122_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a3, a1
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:  .LBB122_3: # in Loop: Header=BB122_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB122_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umax_i16_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB122_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a6, a3, a4
; RV32IA-TSO-NEXT:    mv a5, a3
; RV32IA-TSO-NEXT:    bgeu a6, a1, .LBB122_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB122_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a3, a1
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:  .LBB122_3: # in Loop: Header=BB122_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB122_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui s2, 16
; RV64I-NEXT:    addiw s2, s2, -1
; RV64I-NEXT:    and s3, s0, s2
; RV64I-NEXT:    j .LBB122_2
; RV64I-NEXT:  .LBB122_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB122_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB122_4
; RV64I-NEXT:  .LBB122_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s2
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bltu s3, a0, .LBB122_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB122_2 Depth=1
; RV64I-NEXT:    mv a2, s0
; RV64I-NEXT:    j .LBB122_1
; RV64I-NEXT:  .LBB122_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i16_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB122_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a3, (a2)
; RV64IA-WMO-NEXT:    and a6, a3, a4
; RV64IA-WMO-NEXT:    mv a5, a3
; RV64IA-WMO-NEXT:    bgeu a6, a1, .LBB122_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB122_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a3, a1
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:  .LBB122_3: # in Loop: Header=BB122_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB122_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i16_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB122_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a6, a3, a4
; RV64IA-TSO-NEXT:    mv a5, a3
; RV64IA-TSO-NEXT:    bgeu a6, a1, .LBB122_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB122_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a3, a1
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:  .LBB122_3: # in Loop: Header=BB122_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB122_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_umax_i16_acq_rel(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui s2, 16
; RV32I-NEXT:    addi s2, s2, -1
; RV32I-NEXT:    and s3, s0, s2
; RV32I-NEXT:    j .LBB123_2
; RV32I-NEXT:  .LBB123_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB123_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB123_4
; RV32I-NEXT:  .LBB123_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s2
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bltu s3, a0, .LBB123_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB123_2 Depth=1
; RV32I-NEXT:    mv a2, s0
; RV32I-NEXT:    j .LBB123_1
; RV32I-NEXT:  .LBB123_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umax_i16_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB123_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    and a6, a3, a4
; RV32IA-WMO-NEXT:    mv a5, a3
; RV32IA-WMO-NEXT:    bgeu a6, a1, .LBB123_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB123_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a3, a1
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:  .LBB123_3: # in Loop: Header=BB123_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB123_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umax_i16_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB123_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a6, a3, a4
; RV32IA-TSO-NEXT:    mv a5, a3
; RV32IA-TSO-NEXT:    bgeu a6, a1, .LBB123_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB123_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a3, a1
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:  .LBB123_3: # in Loop: Header=BB123_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB123_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui s2, 16
; RV64I-NEXT:    addiw s2, s2, -1
; RV64I-NEXT:    and s3, s0, s2
; RV64I-NEXT:    j .LBB123_2
; RV64I-NEXT:  .LBB123_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB123_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB123_4
; RV64I-NEXT:  .LBB123_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s2
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bltu s3, a0, .LBB123_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB123_2 Depth=1
; RV64I-NEXT:    mv a2, s0
; RV64I-NEXT:    j .LBB123_1
; RV64I-NEXT:  .LBB123_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i16_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB123_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    and a6, a3, a4
; RV64IA-WMO-NEXT:    mv a5, a3
; RV64IA-WMO-NEXT:    bgeu a6, a1, .LBB123_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB123_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a3, a1
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:  .LBB123_3: # in Loop: Header=BB123_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB123_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i16_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB123_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a6, a3, a4
; RV64IA-TSO-NEXT:    mv a5, a3
; RV64IA-TSO-NEXT:    bgeu a6, a1, .LBB123_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB123_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a3, a1
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:  .LBB123_3: # in Loop: Header=BB123_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB123_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_umax_i16_seq_cst(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui s2, 16
; RV32I-NEXT:    addi s2, s2, -1
; RV32I-NEXT:    and s3, s0, s2
; RV32I-NEXT:    j .LBB124_2
; RV32I-NEXT:  .LBB124_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB124_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB124_4
; RV32I-NEXT:  .LBB124_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s2
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bltu s3, a0, .LBB124_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB124_2 Depth=1
; RV32I-NEXT:    mv a2, s0
; RV32I-NEXT:    j .LBB124_1
; RV32I-NEXT:  .LBB124_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB124_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a2)
; RV32IA-NEXT:    and a6, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a6, a1, .LBB124_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB124_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB124_3: # in Loop: Header=BB124_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB124_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui s2, 16
; RV64I-NEXT:    addiw s2, s2, -1
; RV64I-NEXT:    and s3, s0, s2
; RV64I-NEXT:    j .LBB124_2
; RV64I-NEXT:  .LBB124_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB124_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB124_4
; RV64I-NEXT:  .LBB124_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s2
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bltu s3, a0, .LBB124_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB124_2 Depth=1
; RV64I-NEXT:    mv a2, s0
; RV64I-NEXT:    j .LBB124_1
; RV64I-NEXT:  .LBB124_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addi a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB124_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a2)
; RV64IA-NEXT:    and a6, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a6, a1, .LBB124_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB124_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB124_3: # in Loop: Header=BB124_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB124_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_umin_i16_monotonic(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui s2, 16
; RV32I-NEXT:    addi s2, s2, -1
; RV32I-NEXT:    and s3, s0, s2
; RV32I-NEXT:    j .LBB125_2
; RV32I-NEXT:  .LBB125_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB125_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB125_4
; RV32I-NEXT:  .LBB125_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s2
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bgeu s3, a0, .LBB125_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB125_2 Depth=1
; RV32I-NEXT:    mv a2, s0
; RV32I-NEXT:    j .LBB125_1
; RV32I-NEXT:  .LBB125_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB125_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    and a6, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a1, a6, .LBB125_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB125_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB125_3: # in Loop: Header=BB125_1 Depth=1
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB125_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui s2, 16
; RV64I-NEXT:    addiw s2, s2, -1
; RV64I-NEXT:    and s3, s0, s2
; RV64I-NEXT:    j .LBB125_2
; RV64I-NEXT:  .LBB125_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB125_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB125_4
; RV64I-NEXT:  .LBB125_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s2
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bgeu s3, a0, .LBB125_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB125_2 Depth=1
; RV64I-NEXT:    mv a2, s0
; RV64I-NEXT:    j .LBB125_1
; RV64I-NEXT:  .LBB125_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addi a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB125_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    and a6, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a1, a6, .LBB125_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB125_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB125_3: # in Loop: Header=BB125_1 Depth=1
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB125_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_umin_i16_acquire(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui s2, 16
; RV32I-NEXT:    addi s2, s2, -1
; RV32I-NEXT:    and s3, s0, s2
; RV32I-NEXT:    j .LBB126_2
; RV32I-NEXT:  .LBB126_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB126_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB126_4
; RV32I-NEXT:  .LBB126_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s2
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bgeu s3, a0, .LBB126_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB126_2 Depth=1
; RV32I-NEXT:    mv a2, s0
; RV32I-NEXT:    j .LBB126_1
; RV32I-NEXT:  .LBB126_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umin_i16_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB126_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    and a6, a3, a4
; RV32IA-WMO-NEXT:    mv a5, a3
; RV32IA-WMO-NEXT:    bgeu a1, a6, .LBB126_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB126_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a3, a1
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:  .LBB126_3: # in Loop: Header=BB126_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB126_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umin_i16_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB126_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a6, a3, a4
; RV32IA-TSO-NEXT:    mv a5, a3
; RV32IA-TSO-NEXT:    bgeu a1, a6, .LBB126_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB126_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a3, a1
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:  .LBB126_3: # in Loop: Header=BB126_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB126_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui s2, 16
; RV64I-NEXT:    addiw s2, s2, -1
; RV64I-NEXT:    and s3, s0, s2
; RV64I-NEXT:    j .LBB126_2
; RV64I-NEXT:  .LBB126_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB126_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB126_4
; RV64I-NEXT:  .LBB126_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s2
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bgeu s3, a0, .LBB126_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB126_2 Depth=1
; RV64I-NEXT:    mv a2, s0
; RV64I-NEXT:    j .LBB126_1
; RV64I-NEXT:  .LBB126_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i16_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB126_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    and a6, a3, a4
; RV64IA-WMO-NEXT:    mv a5, a3
; RV64IA-WMO-NEXT:    bgeu a1, a6, .LBB126_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB126_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a3, a1
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:  .LBB126_3: # in Loop: Header=BB126_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB126_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i16_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB126_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a6, a3, a4
; RV64IA-TSO-NEXT:    mv a5, a3
; RV64IA-TSO-NEXT:    bgeu a1, a6, .LBB126_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB126_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a3, a1
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:  .LBB126_3: # in Loop: Header=BB126_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB126_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_umin_i16_release(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui s2, 16
; RV32I-NEXT:    addi s2, s2, -1
; RV32I-NEXT:    and s3, s0, s2
; RV32I-NEXT:    j .LBB127_2
; RV32I-NEXT:  .LBB127_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB127_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB127_4
; RV32I-NEXT:  .LBB127_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s2
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bgeu s3, a0, .LBB127_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB127_2 Depth=1
; RV32I-NEXT:    mv a2, s0
; RV32I-NEXT:    j .LBB127_1
; RV32I-NEXT:  .LBB127_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umin_i16_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB127_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a3, (a2)
; RV32IA-WMO-NEXT:    and a6, a3, a4
; RV32IA-WMO-NEXT:    mv a5, a3
; RV32IA-WMO-NEXT:    bgeu a1, a6, .LBB127_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB127_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a3, a1
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:  .LBB127_3: # in Loop: Header=BB127_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB127_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umin_i16_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB127_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a6, a3, a4
; RV32IA-TSO-NEXT:    mv a5, a3
; RV32IA-TSO-NEXT:    bgeu a1, a6, .LBB127_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB127_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a3, a1
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:  .LBB127_3: # in Loop: Header=BB127_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB127_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui s2, 16
; RV64I-NEXT:    addiw s2, s2, -1
; RV64I-NEXT:    and s3, s0, s2
; RV64I-NEXT:    j .LBB127_2
; RV64I-NEXT:  .LBB127_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB127_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB127_4
; RV64I-NEXT:  .LBB127_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s2
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bgeu s3, a0, .LBB127_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB127_2 Depth=1
; RV64I-NEXT:    mv a2, s0
; RV64I-NEXT:    j .LBB127_1
; RV64I-NEXT:  .LBB127_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i16_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB127_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a3, (a2)
; RV64IA-WMO-NEXT:    and a6, a3, a4
; RV64IA-WMO-NEXT:    mv a5, a3
; RV64IA-WMO-NEXT:    bgeu a1, a6, .LBB127_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB127_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a3, a1
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:  .LBB127_3: # in Loop: Header=BB127_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB127_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i16_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB127_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a6, a3, a4
; RV64IA-TSO-NEXT:    mv a5, a3
; RV64IA-TSO-NEXT:    bgeu a1, a6, .LBB127_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB127_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a3, a1
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:  .LBB127_3: # in Loop: Header=BB127_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB127_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_umin_i16_acq_rel(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui s2, 16
; RV32I-NEXT:    addi s2, s2, -1
; RV32I-NEXT:    and s3, s0, s2
; RV32I-NEXT:    j .LBB128_2
; RV32I-NEXT:  .LBB128_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB128_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB128_4
; RV32I-NEXT:  .LBB128_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s2
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bgeu s3, a0, .LBB128_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB128_2 Depth=1
; RV32I-NEXT:    mv a2, s0
; RV32I-NEXT:    j .LBB128_1
; RV32I-NEXT:  .LBB128_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umin_i16_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a2, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a3, 16
; RV32IA-WMO-NEXT:    addi a3, a3, -1
; RV32IA-WMO-NEXT:    sll a4, a3, a0
; RV32IA-WMO-NEXT:    and a1, a1, a3
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:  .LBB128_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV32IA-WMO-NEXT:    and a6, a3, a4
; RV32IA-WMO-NEXT:    mv a5, a3
; RV32IA-WMO-NEXT:    bgeu a1, a6, .LBB128_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB128_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a3, a1
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a3, a5
; RV32IA-WMO-NEXT:  .LBB128_3: # in Loop: Header=BB128_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-WMO-NEXT:    bnez a5, .LBB128_1
; RV32IA-WMO-NEXT:  # %bb.4:
; RV32IA-WMO-NEXT:    srl a0, a3, a0
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umin_i16_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a2, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a3, 16
; RV32IA-TSO-NEXT:    addi a3, a3, -1
; RV32IA-TSO-NEXT:    sll a4, a3, a0
; RV32IA-TSO-NEXT:    and a1, a1, a3
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:  .LBB128_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a2)
; RV32IA-TSO-NEXT:    and a6, a3, a4
; RV32IA-TSO-NEXT:    mv a5, a3
; RV32IA-TSO-NEXT:    bgeu a1, a6, .LBB128_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB128_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a3, a1
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a3, a5
; RV32IA-TSO-NEXT:  .LBB128_3: # in Loop: Header=BB128_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV32IA-TSO-NEXT:    bnez a5, .LBB128_1
; RV32IA-TSO-NEXT:  # %bb.4:
; RV32IA-TSO-NEXT:    srl a0, a3, a0
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui s2, 16
; RV64I-NEXT:    addiw s2, s2, -1
; RV64I-NEXT:    and s3, s0, s2
; RV64I-NEXT:    j .LBB128_2
; RV64I-NEXT:  .LBB128_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB128_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB128_4
; RV64I-NEXT:  .LBB128_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s2
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bgeu s3, a0, .LBB128_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB128_2 Depth=1
; RV64I-NEXT:    mv a2, s0
; RV64I-NEXT:    j .LBB128_1
; RV64I-NEXT:  .LBB128_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i16_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a2, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a3, 16
; RV64IA-WMO-NEXT:    addi a3, a3, -1
; RV64IA-WMO-NEXT:    sllw a4, a3, a0
; RV64IA-WMO-NEXT:    and a1, a1, a3
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:  .LBB128_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a2)
; RV64IA-WMO-NEXT:    and a6, a3, a4
; RV64IA-WMO-NEXT:    mv a5, a3
; RV64IA-WMO-NEXT:    bgeu a1, a6, .LBB128_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB128_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a3, a1
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a3, a5
; RV64IA-WMO-NEXT:  .LBB128_3: # in Loop: Header=BB128_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-WMO-NEXT:    bnez a5, .LBB128_1
; RV64IA-WMO-NEXT:  # %bb.4:
; RV64IA-WMO-NEXT:    srlw a0, a3, a0
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i16_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a2, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a3, 16
; RV64IA-TSO-NEXT:    addi a3, a3, -1
; RV64IA-TSO-NEXT:    sllw a4, a3, a0
; RV64IA-TSO-NEXT:    and a1, a1, a3
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:  .LBB128_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a2)
; RV64IA-TSO-NEXT:    and a6, a3, a4
; RV64IA-TSO-NEXT:    mv a5, a3
; RV64IA-TSO-NEXT:    bgeu a1, a6, .LBB128_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB128_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a3, a1
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a3, a5
; RV64IA-TSO-NEXT:  .LBB128_3: # in Loop: Header=BB128_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a2)
; RV64IA-TSO-NEXT:    bnez a5, .LBB128_1
; RV64IA-TSO-NEXT:  # %bb.4:
; RV64IA-TSO-NEXT:    srlw a0, a3, a0
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_umin_i16_seq_cst(ptr %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui s2, 16
; RV32I-NEXT:    addi s2, s2, -1
; RV32I-NEXT:    and s3, s0, s2
; RV32I-NEXT:    j .LBB129_2
; RV32I-NEXT:  .LBB129_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB129_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB129_4
; RV32I-NEXT:  .LBB129_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s2
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bgeu s3, a0, .LBB129_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB129_2 Depth=1
; RV32I-NEXT:    mv a2, s0
; RV32I-NEXT:    j .LBB129_1
; RV32I-NEXT:  .LBB129_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB129_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a2)
; RV32IA-NEXT:    and a6, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a1, a6, .LBB129_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB129_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB129_3: # in Loop: Header=BB129_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB129_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui s2, 16
; RV64I-NEXT:    addiw s2, s2, -1
; RV64I-NEXT:    and s3, s0, s2
; RV64I-NEXT:    j .LBB129_2
; RV64I-NEXT:  .LBB129_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB129_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB129_4
; RV64I-NEXT:  .LBB129_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s2
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bgeu s3, a0, .LBB129_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB129_2 Depth=1
; RV64I-NEXT:    mv a2, s0
; RV64I-NEXT:    j .LBB129_1
; RV64I-NEXT:  .LBB129_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addi a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB129_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a2)
; RV64IA-NEXT:    and a6, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a1, a6, .LBB129_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB129_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB129_3: # in Loop: Header=BB129_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB129_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i32 @atomicrmw_xchg_i32_monotonic(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoswap.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoswap.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_xchg_i32_acquire(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_i32_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoswap.w.aq a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_i32_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoswap.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i32_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoswap.w.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i32_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoswap.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_xchg_i32_release(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_i32_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoswap.w.rl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_i32_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoswap.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i32_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoswap.w.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i32_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoswap.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_xchg_i32_acq_rel(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_i32_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoswap.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_i32_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoswap.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i32_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoswap.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i32_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoswap.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_xchg_i32_seq_cst(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xchg_i32_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoswap.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xchg_i32_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoswap.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i32_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoswap.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i32_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoswap.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_add_i32_monotonic(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_add_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoadd.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_add_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoadd.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw add ptr %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_add_i32_acquire(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_add_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_add_i32_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoadd.w.aq a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_add_i32_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_add_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i32_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoadd.w.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i32_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_add_i32_release(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_add_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_add_i32_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoadd.w.rl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_add_i32_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_add_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i32_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoadd.w.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i32_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_add_i32_acq_rel(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_add_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_add_i32_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_add_i32_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_add_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i32_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i32_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_add_i32_seq_cst(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_add_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_add_i32_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_add_i32_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_add_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i32_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i32_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_sub_i32_monotonic(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_sub_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    neg a1, a1
; RV32IA-NEXT:    amoadd.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_sub_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    neg a1, a1
; RV64IA-NEXT:    amoadd.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_sub_i32_acquire(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_sub_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_sub_i32_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    neg a1, a1
; RV32IA-WMO-NEXT:    amoadd.w.aq a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_sub_i32_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    neg a1, a1
; RV32IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_sub_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i32_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    neg a1, a1
; RV64IA-WMO-NEXT:    amoadd.w.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i32_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    neg a1, a1
; RV64IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_sub_i32_release(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_sub_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_sub_i32_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    neg a1, a1
; RV32IA-WMO-NEXT:    amoadd.w.rl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_sub_i32_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    neg a1, a1
; RV32IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_sub_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i32_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    neg a1, a1
; RV64IA-WMO-NEXT:    amoadd.w.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i32_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    neg a1, a1
; RV64IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_sub_i32_acq_rel(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_sub_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_sub_i32_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    neg a1, a1
; RV32IA-WMO-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_sub_i32_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    neg a1, a1
; RV32IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_sub_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i32_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    neg a1, a1
; RV64IA-WMO-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i32_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    neg a1, a1
; RV64IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_sub_i32_seq_cst(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_sub_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_sub_i32_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    neg a1, a1
; RV32IA-WMO-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_sub_i32_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    neg a1, a1
; RV32IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_sub_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i32_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    neg a1, a1
; RV64IA-WMO-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i32_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    neg a1, a1
; RV64IA-TSO-NEXT:    amoadd.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_and_i32_monotonic(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_and_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoand.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_and_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoand.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw and ptr %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_and_i32_acquire(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_and_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_and_i32_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoand.w.aq a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_and_i32_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoand.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_and_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i32_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoand.w.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i32_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoand.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_and_i32_release(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_and_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_and_i32_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoand.w.rl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_and_i32_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoand.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_and_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i32_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoand.w.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i32_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoand.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_and_i32_acq_rel(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_and_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_and_i32_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoand.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_and_i32_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoand.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_and_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i32_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoand.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i32_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoand.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_and_i32_seq_cst(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_and_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_and_i32_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoand.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_and_i32_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoand.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_and_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i32_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoand.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i32_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoand.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_nand_i32_monotonic(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_nand_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:  .LBB150_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a2, (a0)
; RV32IA-NEXT:    and a3, a2, a1
; RV32IA-NEXT:    not a3, a3
; RV32IA-NEXT:    sc.w a3, a3, (a0)
; RV32IA-NEXT:    bnez a3, .LBB150_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    mv a0, a2
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_nand_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB150_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.w a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB150_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_nand_i32_acquire(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_nand_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_nand_i32_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:  .LBB151_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a2, (a0)
; RV32IA-WMO-NEXT:    and a3, a2, a1
; RV32IA-WMO-NEXT:    not a3, a3
; RV32IA-WMO-NEXT:    sc.w a3, a3, (a0)
; RV32IA-WMO-NEXT:    bnez a3, .LBB151_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    mv a0, a2
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_nand_i32_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:  .LBB151_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a0)
; RV32IA-TSO-NEXT:    and a3, a2, a1
; RV32IA-TSO-NEXT:    not a3, a3
; RV32IA-TSO-NEXT:    sc.w a3, a3, (a0)
; RV32IA-TSO-NEXT:    bnez a3, .LBB151_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    mv a0, a2
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_nand_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_nand_i32_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB151_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a2, (a0)
; RV64IA-WMO-NEXT:    and a3, a2, a1
; RV64IA-WMO-NEXT:    not a3, a3
; RV64IA-WMO-NEXT:    sc.w a3, a3, (a0)
; RV64IA-WMO-NEXT:    bnez a3, .LBB151_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    mv a0, a2
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_nand_i32_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB151_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a0)
; RV64IA-TSO-NEXT:    and a3, a2, a1
; RV64IA-TSO-NEXT:    not a3, a3
; RV64IA-TSO-NEXT:    sc.w a3, a3, (a0)
; RV64IA-TSO-NEXT:    bnez a3, .LBB151_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    mv a0, a2
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_nand_i32_release(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_nand_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_nand_i32_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:  .LBB152_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a2, (a0)
; RV32IA-WMO-NEXT:    and a3, a2, a1
; RV32IA-WMO-NEXT:    not a3, a3
; RV32IA-WMO-NEXT:    sc.w.rl a3, a3, (a0)
; RV32IA-WMO-NEXT:    bnez a3, .LBB152_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    mv a0, a2
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_nand_i32_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:  .LBB152_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a0)
; RV32IA-TSO-NEXT:    and a3, a2, a1
; RV32IA-TSO-NEXT:    not a3, a3
; RV32IA-TSO-NEXT:    sc.w a3, a3, (a0)
; RV32IA-TSO-NEXT:    bnez a3, .LBB152_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    mv a0, a2
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_nand_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_nand_i32_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB152_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a2, (a0)
; RV64IA-WMO-NEXT:    and a3, a2, a1
; RV64IA-WMO-NEXT:    not a3, a3
; RV64IA-WMO-NEXT:    sc.w.rl a3, a3, (a0)
; RV64IA-WMO-NEXT:    bnez a3, .LBB152_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    mv a0, a2
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_nand_i32_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB152_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a0)
; RV64IA-TSO-NEXT:    and a3, a2, a1
; RV64IA-TSO-NEXT:    not a3, a3
; RV64IA-TSO-NEXT:    sc.w a3, a3, (a0)
; RV64IA-TSO-NEXT:    bnez a3, .LBB152_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    mv a0, a2
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_nand_i32_acq_rel(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_nand_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_nand_i32_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:  .LBB153_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a2, (a0)
; RV32IA-WMO-NEXT:    and a3, a2, a1
; RV32IA-WMO-NEXT:    not a3, a3
; RV32IA-WMO-NEXT:    sc.w.rl a3, a3, (a0)
; RV32IA-WMO-NEXT:    bnez a3, .LBB153_1
; RV32IA-WMO-NEXT:  # %bb.2:
; RV32IA-WMO-NEXT:    mv a0, a2
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_nand_i32_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:  .LBB153_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a0)
; RV32IA-TSO-NEXT:    and a3, a2, a1
; RV32IA-TSO-NEXT:    not a3, a3
; RV32IA-TSO-NEXT:    sc.w a3, a3, (a0)
; RV32IA-TSO-NEXT:    bnez a3, .LBB153_1
; RV32IA-TSO-NEXT:  # %bb.2:
; RV32IA-TSO-NEXT:    mv a0, a2
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_nand_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_nand_i32_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB153_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a2, (a0)
; RV64IA-WMO-NEXT:    and a3, a2, a1
; RV64IA-WMO-NEXT:    not a3, a3
; RV64IA-WMO-NEXT:    sc.w.rl a3, a3, (a0)
; RV64IA-WMO-NEXT:    bnez a3, .LBB153_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    mv a0, a2
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_nand_i32_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB153_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a0)
; RV64IA-TSO-NEXT:    and a3, a2, a1
; RV64IA-TSO-NEXT:    not a3, a3
; RV64IA-TSO-NEXT:    sc.w a3, a3, (a0)
; RV64IA-TSO-NEXT:    bnez a3, .LBB153_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    mv a0, a2
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_nand_i32_seq_cst(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_nand_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i32_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:  .LBB154_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a2, (a0)
; RV32IA-NEXT:    and a3, a2, a1
; RV32IA-NEXT:    not a3, a3
; RV32IA-NEXT:    sc.w.rl a3, a3, (a0)
; RV32IA-NEXT:    bnez a3, .LBB154_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    mv a0, a2
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_nand_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i32_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB154_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.w.rl a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB154_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_or_i32_monotonic(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_or_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoor.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_or_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoor.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw or ptr %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_or_i32_acquire(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_or_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_or_i32_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoor.w.aq a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_or_i32_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoor.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_or_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i32_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoor.w.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i32_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoor.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_or_i32_release(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_or_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_or_i32_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoor.w.rl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_or_i32_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoor.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_or_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i32_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoor.w.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i32_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoor.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_or_i32_acq_rel(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_or_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_or_i32_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoor.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_or_i32_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoor.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_or_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i32_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoor.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i32_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoor.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_or_i32_seq_cst(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_or_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_or_i32_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoor.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_or_i32_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoor.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_or_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i32_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoor.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i32_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoor.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_xor_i32_monotonic(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __atomic_fetch_xor_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoxor.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_xor_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoxor.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_xor_i32_acquire(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 2
; RV32I-NEXT:    call __atomic_fetch_xor_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xor_i32_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoxor.w.aq a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xor_i32_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoxor.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_xor_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i32_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoxor.w.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i32_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoxor.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_xor_i32_release(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 3
; RV32I-NEXT:    call __atomic_fetch_xor_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xor_i32_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoxor.w.rl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xor_i32_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoxor.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_xor_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i32_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoxor.w.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i32_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoxor.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_xor_i32_acq_rel(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 4
; RV32I-NEXT:    call __atomic_fetch_xor_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xor_i32_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoxor.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xor_i32_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoxor.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_xor_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i32_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoxor.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i32_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoxor.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_xor_i32_seq_cst(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a2, 5
; RV32I-NEXT:    call __atomic_fetch_xor_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_xor_i32_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amoxor.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_xor_i32_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amoxor.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_xor_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i32_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoxor.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i32_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoxor.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_max_i32_monotonic(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB165_2
; RV32I-NEXT:  .LBB165_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB165_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB165_4
; RV32I-NEXT:  .LBB165_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a3, .LBB165_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB165_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB165_1
; RV32I-NEXT:  .LBB165_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomax.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB165_2
; RV64I-NEXT:  .LBB165_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB165_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB165_4
; RV64I-NEXT:  .LBB165_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a3, .LBB165_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB165_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB165_1
; RV64I-NEXT:  .LBB165_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomax.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw max ptr %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_max_i32_acquire(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB166_2
; RV32I-NEXT:  .LBB166_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB166_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB166_4
; RV32I-NEXT:  .LBB166_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a3, .LBB166_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB166_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB166_1
; RV32I-NEXT:  .LBB166_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_max_i32_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amomax.w.aq a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_max_i32_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amomax.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB166_2
; RV64I-NEXT:  .LBB166_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB166_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB166_4
; RV64I-NEXT:  .LBB166_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a3, .LBB166_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB166_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB166_1
; RV64I-NEXT:  .LBB166_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i32_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomax.w.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i32_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomax.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_max_i32_release(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB167_2
; RV32I-NEXT:  .LBB167_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB167_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB167_4
; RV32I-NEXT:  .LBB167_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a3, .LBB167_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB167_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB167_1
; RV32I-NEXT:  .LBB167_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_max_i32_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amomax.w.rl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_max_i32_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amomax.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB167_2
; RV64I-NEXT:  .LBB167_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB167_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB167_4
; RV64I-NEXT:  .LBB167_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a3, .LBB167_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB167_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB167_1
; RV64I-NEXT:  .LBB167_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i32_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomax.w.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i32_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomax.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_max_i32_acq_rel(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB168_2
; RV32I-NEXT:  .LBB168_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB168_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB168_4
; RV32I-NEXT:  .LBB168_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a3, .LBB168_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB168_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB168_1
; RV32I-NEXT:  .LBB168_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_max_i32_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amomax.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_max_i32_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amomax.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB168_2
; RV64I-NEXT:  .LBB168_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB168_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB168_4
; RV64I-NEXT:  .LBB168_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a3, .LBB168_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB168_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB168_1
; RV64I-NEXT:  .LBB168_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i32_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomax.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i32_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomax.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_max_i32_seq_cst(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB169_2
; RV32I-NEXT:  .LBB169_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB169_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB169_4
; RV32I-NEXT:  .LBB169_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a3, .LBB169_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB169_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB169_1
; RV32I-NEXT:  .LBB169_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_max_i32_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amomax.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_max_i32_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amomax.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB169_2
; RV64I-NEXT:  .LBB169_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB169_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB169_4
; RV64I-NEXT:  .LBB169_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s2, a3, .LBB169_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB169_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB169_1
; RV64I-NEXT:  .LBB169_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i32_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomax.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i32_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomax.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_min_i32_monotonic(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB170_2
; RV32I-NEXT:  .LBB170_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB170_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB170_4
; RV32I-NEXT:  .LBB170_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a3, .LBB170_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB170_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB170_1
; RV32I-NEXT:  .LBB170_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomin.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB170_2
; RV64I-NEXT:  .LBB170_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB170_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB170_4
; RV64I-NEXT:  .LBB170_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a3, .LBB170_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB170_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB170_1
; RV64I-NEXT:  .LBB170_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomin.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw min ptr %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_min_i32_acquire(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB171_2
; RV32I-NEXT:  .LBB171_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB171_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB171_4
; RV32I-NEXT:  .LBB171_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a3, .LBB171_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB171_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB171_1
; RV32I-NEXT:  .LBB171_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_min_i32_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amomin.w.aq a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_min_i32_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amomin.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB171_2
; RV64I-NEXT:  .LBB171_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB171_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB171_4
; RV64I-NEXT:  .LBB171_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a3, .LBB171_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB171_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB171_1
; RV64I-NEXT:  .LBB171_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i32_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomin.w.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i32_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomin.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_min_i32_release(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB172_2
; RV32I-NEXT:  .LBB172_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB172_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB172_4
; RV32I-NEXT:  .LBB172_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a3, .LBB172_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB172_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB172_1
; RV32I-NEXT:  .LBB172_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_min_i32_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amomin.w.rl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_min_i32_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amomin.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB172_2
; RV64I-NEXT:  .LBB172_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB172_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB172_4
; RV64I-NEXT:  .LBB172_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a3, .LBB172_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB172_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB172_1
; RV64I-NEXT:  .LBB172_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i32_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomin.w.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i32_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomin.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_min_i32_acq_rel(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB173_2
; RV32I-NEXT:  .LBB173_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB173_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB173_4
; RV32I-NEXT:  .LBB173_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a3, .LBB173_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB173_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB173_1
; RV32I-NEXT:  .LBB173_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_min_i32_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amomin.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_min_i32_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amomin.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB173_2
; RV64I-NEXT:  .LBB173_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB173_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB173_4
; RV64I-NEXT:  .LBB173_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a3, .LBB173_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB173_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB173_1
; RV64I-NEXT:  .LBB173_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i32_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomin.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i32_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomin.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_min_i32_seq_cst(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB174_2
; RV32I-NEXT:  .LBB174_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB174_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB174_4
; RV32I-NEXT:  .LBB174_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a3, .LBB174_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB174_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB174_1
; RV32I-NEXT:  .LBB174_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_min_i32_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amomin.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_min_i32_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amomin.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB174_2
; RV64I-NEXT:  .LBB174_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB174_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB174_4
; RV64I-NEXT:  .LBB174_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s2, a3, .LBB174_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB174_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB174_1
; RV64I-NEXT:  .LBB174_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i32_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomin.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i32_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomin.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_umax_i32_monotonic(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB175_2
; RV32I-NEXT:  .LBB175_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB175_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB175_4
; RV32I-NEXT:  .LBB175_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a3, .LBB175_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB175_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB175_1
; RV32I-NEXT:  .LBB175_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomaxu.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB175_2
; RV64I-NEXT:  .LBB175_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB175_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB175_4
; RV64I-NEXT:  .LBB175_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s2, a3, .LBB175_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB175_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB175_1
; RV64I-NEXT:  .LBB175_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomaxu.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_umax_i32_acquire(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB176_2
; RV32I-NEXT:  .LBB176_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB176_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB176_4
; RV32I-NEXT:  .LBB176_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a3, .LBB176_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB176_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB176_1
; RV32I-NEXT:  .LBB176_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umax_i32_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amomaxu.w.aq a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umax_i32_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amomaxu.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB176_2
; RV64I-NEXT:  .LBB176_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB176_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB176_4
; RV64I-NEXT:  .LBB176_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s2, a3, .LBB176_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB176_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB176_1
; RV64I-NEXT:  .LBB176_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i32_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomaxu.w.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i32_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomaxu.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_umax_i32_release(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB177_2
; RV32I-NEXT:  .LBB177_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB177_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB177_4
; RV32I-NEXT:  .LBB177_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a3, .LBB177_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB177_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB177_1
; RV32I-NEXT:  .LBB177_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umax_i32_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amomaxu.w.rl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umax_i32_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amomaxu.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB177_2
; RV64I-NEXT:  .LBB177_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB177_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB177_4
; RV64I-NEXT:  .LBB177_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s2, a3, .LBB177_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB177_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB177_1
; RV64I-NEXT:  .LBB177_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i32_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomaxu.w.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i32_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomaxu.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_umax_i32_acq_rel(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB178_2
; RV32I-NEXT:  .LBB178_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB178_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB178_4
; RV32I-NEXT:  .LBB178_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a3, .LBB178_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB178_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB178_1
; RV32I-NEXT:  .LBB178_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umax_i32_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amomaxu.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umax_i32_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amomaxu.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB178_2
; RV64I-NEXT:  .LBB178_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB178_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB178_4
; RV64I-NEXT:  .LBB178_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s2, a3, .LBB178_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB178_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB178_1
; RV64I-NEXT:  .LBB178_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i32_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomaxu.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i32_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomaxu.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_umax_i32_seq_cst(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB179_2
; RV32I-NEXT:  .LBB179_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB179_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB179_4
; RV32I-NEXT:  .LBB179_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a3, .LBB179_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB179_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB179_1
; RV32I-NEXT:  .LBB179_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umax_i32_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amomaxu.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umax_i32_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amomaxu.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB179_2
; RV64I-NEXT:  .LBB179_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB179_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB179_4
; RV64I-NEXT:  .LBB179_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s2, a3, .LBB179_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB179_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB179_1
; RV64I-NEXT:  .LBB179_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i32_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomaxu.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i32_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomaxu.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_umin_i32_monotonic(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB180_2
; RV32I-NEXT:  .LBB180_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB180_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB180_4
; RV32I-NEXT:  .LBB180_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a3, .LBB180_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB180_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB180_1
; RV32I-NEXT:  .LBB180_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amominu.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB180_2
; RV64I-NEXT:  .LBB180_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB180_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB180_4
; RV64I-NEXT:  .LBB180_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s2, a3, .LBB180_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB180_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB180_1
; RV64I-NEXT:  .LBB180_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amominu.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_umin_i32_acquire(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB181_2
; RV32I-NEXT:  .LBB181_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB181_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB181_4
; RV32I-NEXT:  .LBB181_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a3, .LBB181_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB181_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB181_1
; RV32I-NEXT:  .LBB181_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umin_i32_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amominu.w.aq a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umin_i32_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amominu.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB181_2
; RV64I-NEXT:  .LBB181_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB181_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB181_4
; RV64I-NEXT:  .LBB181_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s2, a3, .LBB181_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB181_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB181_1
; RV64I-NEXT:  .LBB181_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i32_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amominu.w.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i32_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amominu.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_umin_i32_release(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB182_2
; RV32I-NEXT:  .LBB182_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB182_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB182_4
; RV32I-NEXT:  .LBB182_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a3, .LBB182_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB182_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB182_1
; RV32I-NEXT:  .LBB182_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umin_i32_release:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amominu.w.rl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umin_i32_release:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amominu.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB182_2
; RV64I-NEXT:  .LBB182_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB182_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB182_4
; RV64I-NEXT:  .LBB182_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s2, a3, .LBB182_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB182_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB182_1
; RV64I-NEXT:  .LBB182_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i32_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amominu.w.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i32_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amominu.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_umin_i32_acq_rel(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB183_2
; RV32I-NEXT:  .LBB183_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB183_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB183_4
; RV32I-NEXT:  .LBB183_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a3, .LBB183_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB183_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB183_1
; RV32I-NEXT:  .LBB183_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umin_i32_acq_rel:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amominu.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umin_i32_acq_rel:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amominu.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB183_2
; RV64I-NEXT:  .LBB183_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB183_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB183_4
; RV64I-NEXT:  .LBB183_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s2, a3, .LBB183_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB183_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB183_1
; RV64I-NEXT:  .LBB183_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i32_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amominu.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i32_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amominu.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_umin_i32_seq_cst(ptr %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB184_2
; RV32I-NEXT:  .LBB184_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB184_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB184_4
; RV32I-NEXT:  .LBB184_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a3, .LBB184_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB184_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB184_1
; RV32I-NEXT:  .LBB184_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: atomicrmw_umin_i32_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    amominu.w.aqrl a0, a1, (a0)
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-TSO-LABEL: atomicrmw_umin_i32_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    amominu.w a0, a1, (a0)
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lw a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    sext.w s2, a1
; RV64I-NEXT:    j .LBB184_2
; RV64I-NEXT:  .LBB184_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB184_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB184_4
; RV64I-NEXT:  .LBB184_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s2, a3, .LBB184_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB184_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB184_1
; RV64I-NEXT:  .LBB184_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i32_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amominu.w.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i32_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amominu.w a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i64 @atomicrmw_xchg_i64_monotonic(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    call __atomic_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 0
; RV32IA-NEXT:    call __atomic_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoswap.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_xchg_i64_acquire(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    call __atomic_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 2
; RV32IA-NEXT:    call __atomic_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i64_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoswap.d.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i64_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoswap.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_xchg_i64_release(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    call __atomic_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 3
; RV32IA-NEXT:    call __atomic_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i64_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoswap.d.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i64_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoswap.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_xchg_i64_acq_rel(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    call __atomic_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 4
; RV32IA-NEXT:    call __atomic_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i64_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoswap.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i64_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoswap.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_xchg_i64_seq_cst(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    call __atomic_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 5
; RV32IA-NEXT:    call __atomic_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xchg_i64_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoswap.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xchg_i64_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoswap.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_add_i64_monotonic(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    call __atomic_fetch_add_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 0
; RV32IA-NEXT:    call __atomic_fetch_add_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_add_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoadd.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw add ptr %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_add_i64_acquire(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    call __atomic_fetch_add_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 2
; RV32IA-NEXT:    call __atomic_fetch_add_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_add_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i64_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoadd.d.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i64_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoadd.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_add_i64_release(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    call __atomic_fetch_add_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 3
; RV32IA-NEXT:    call __atomic_fetch_add_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_add_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i64_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoadd.d.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i64_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoadd.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_add_i64_acq_rel(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    call __atomic_fetch_add_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 4
; RV32IA-NEXT:    call __atomic_fetch_add_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_add_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i64_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoadd.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i64_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoadd.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_add_i64_seq_cst(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    call __atomic_fetch_add_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 5
; RV32IA-NEXT:    call __atomic_fetch_add_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_add_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_add_i64_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoadd.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_add_i64_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoadd.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw add ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_sub_i64_monotonic(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    call __atomic_fetch_sub_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 0
; RV32IA-NEXT:    call __atomic_fetch_sub_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_sub_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    neg a1, a1
; RV64IA-NEXT:    amoadd.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_sub_i64_acquire(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    call __atomic_fetch_sub_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 2
; RV32IA-NEXT:    call __atomic_fetch_sub_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_sub_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i64_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    neg a1, a1
; RV64IA-WMO-NEXT:    amoadd.d.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i64_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    neg a1, a1
; RV64IA-TSO-NEXT:    amoadd.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_sub_i64_release(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    call __atomic_fetch_sub_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 3
; RV32IA-NEXT:    call __atomic_fetch_sub_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_sub_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i64_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    neg a1, a1
; RV64IA-WMO-NEXT:    amoadd.d.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i64_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    neg a1, a1
; RV64IA-TSO-NEXT:    amoadd.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_sub_i64_acq_rel(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    call __atomic_fetch_sub_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 4
; RV32IA-NEXT:    call __atomic_fetch_sub_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_sub_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i64_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    neg a1, a1
; RV64IA-WMO-NEXT:    amoadd.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i64_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    neg a1, a1
; RV64IA-TSO-NEXT:    amoadd.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_sub_i64_seq_cst(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    call __atomic_fetch_sub_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 5
; RV32IA-NEXT:    call __atomic_fetch_sub_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_sub_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_sub_i64_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    neg a1, a1
; RV64IA-WMO-NEXT:    amoadd.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_sub_i64_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    neg a1, a1
; RV64IA-TSO-NEXT:    amoadd.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_and_i64_monotonic(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    call __atomic_fetch_and_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 0
; RV32IA-NEXT:    call __atomic_fetch_and_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_and_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoand.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw and ptr %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_and_i64_acquire(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    call __atomic_fetch_and_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 2
; RV32IA-NEXT:    call __atomic_fetch_and_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_and_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i64_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoand.d.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i64_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoand.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_and_i64_release(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    call __atomic_fetch_and_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 3
; RV32IA-NEXT:    call __atomic_fetch_and_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_and_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i64_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoand.d.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i64_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoand.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_and_i64_acq_rel(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    call __atomic_fetch_and_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 4
; RV32IA-NEXT:    call __atomic_fetch_and_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_and_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i64_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoand.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i64_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoand.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_and_i64_seq_cst(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    call __atomic_fetch_and_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 5
; RV32IA-NEXT:    call __atomic_fetch_and_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_and_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_and_i64_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoand.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_and_i64_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoand.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw and ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_nand_i64_monotonic(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    call __atomic_fetch_nand_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 0
; RV32IA-NEXT:    call __atomic_fetch_nand_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_nand_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB205_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.d a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.d a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB205_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_nand_i64_acquire(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    call __atomic_fetch_nand_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 2
; RV32IA-NEXT:    call __atomic_fetch_nand_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_nand_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_nand_i64_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB206_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.d.aq a2, (a0)
; RV64IA-WMO-NEXT:    and a3, a2, a1
; RV64IA-WMO-NEXT:    not a3, a3
; RV64IA-WMO-NEXT:    sc.d a3, a3, (a0)
; RV64IA-WMO-NEXT:    bnez a3, .LBB206_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    mv a0, a2
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_nand_i64_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB206_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.d a2, (a0)
; RV64IA-TSO-NEXT:    and a3, a2, a1
; RV64IA-TSO-NEXT:    not a3, a3
; RV64IA-TSO-NEXT:    sc.d a3, a3, (a0)
; RV64IA-TSO-NEXT:    bnez a3, .LBB206_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    mv a0, a2
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_nand_i64_release(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    call __atomic_fetch_nand_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 3
; RV32IA-NEXT:    call __atomic_fetch_nand_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_nand_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_nand_i64_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB207_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.d a2, (a0)
; RV64IA-WMO-NEXT:    and a3, a2, a1
; RV64IA-WMO-NEXT:    not a3, a3
; RV64IA-WMO-NEXT:    sc.d.rl a3, a3, (a0)
; RV64IA-WMO-NEXT:    bnez a3, .LBB207_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    mv a0, a2
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_nand_i64_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB207_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.d a2, (a0)
; RV64IA-TSO-NEXT:    and a3, a2, a1
; RV64IA-TSO-NEXT:    not a3, a3
; RV64IA-TSO-NEXT:    sc.d a3, a3, (a0)
; RV64IA-TSO-NEXT:    bnez a3, .LBB207_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    mv a0, a2
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_nand_i64_acq_rel(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    call __atomic_fetch_nand_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 4
; RV32IA-NEXT:    call __atomic_fetch_nand_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_nand_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_nand_i64_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB208_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.d.aq a2, (a0)
; RV64IA-WMO-NEXT:    and a3, a2, a1
; RV64IA-WMO-NEXT:    not a3, a3
; RV64IA-WMO-NEXT:    sc.d.rl a3, a3, (a0)
; RV64IA-WMO-NEXT:    bnez a3, .LBB208_1
; RV64IA-WMO-NEXT:  # %bb.2:
; RV64IA-WMO-NEXT:    mv a0, a2
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_nand_i64_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB208_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.d a2, (a0)
; RV64IA-TSO-NEXT:    and a3, a2, a1
; RV64IA-TSO-NEXT:    not a3, a3
; RV64IA-TSO-NEXT:    sc.d a3, a3, (a0)
; RV64IA-TSO-NEXT:    bnez a3, .LBB208_1
; RV64IA-TSO-NEXT:  # %bb.2:
; RV64IA-TSO-NEXT:    mv a0, a2
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_nand_i64_seq_cst(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    call __atomic_fetch_nand_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 5
; RV32IA-NEXT:    call __atomic_fetch_nand_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_nand_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i64_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB209_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.d.aqrl a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.d.rl a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB209_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_or_i64_monotonic(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    call __atomic_fetch_or_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 0
; RV32IA-NEXT:    call __atomic_fetch_or_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_or_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoor.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw or ptr %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_or_i64_acquire(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    call __atomic_fetch_or_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 2
; RV32IA-NEXT:    call __atomic_fetch_or_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_or_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i64_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoor.d.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i64_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoor.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_or_i64_release(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    call __atomic_fetch_or_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 3
; RV32IA-NEXT:    call __atomic_fetch_or_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_or_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i64_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoor.d.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i64_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoor.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_or_i64_acq_rel(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    call __atomic_fetch_or_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 4
; RV32IA-NEXT:    call __atomic_fetch_or_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_or_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i64_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoor.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i64_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoor.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_or_i64_seq_cst(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    call __atomic_fetch_or_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 5
; RV32IA-NEXT:    call __atomic_fetch_or_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_or_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_or_i64_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoor.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_or_i64_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoor.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw or ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_xor_i64_monotonic(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    call __atomic_fetch_xor_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 0
; RV32IA-NEXT:    call __atomic_fetch_xor_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 0
; RV64I-NEXT:    call __atomic_fetch_xor_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoxor.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_xor_i64_acquire(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    call __atomic_fetch_xor_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 2
; RV32IA-NEXT:    call __atomic_fetch_xor_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 2
; RV64I-NEXT:    call __atomic_fetch_xor_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i64_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoxor.d.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i64_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoxor.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_xor_i64_release(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    call __atomic_fetch_xor_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 3
; RV32IA-NEXT:    call __atomic_fetch_xor_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    call __atomic_fetch_xor_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i64_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoxor.d.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i64_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoxor.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_xor_i64_acq_rel(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    call __atomic_fetch_xor_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 4
; RV32IA-NEXT:    call __atomic_fetch_xor_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 4
; RV64I-NEXT:    call __atomic_fetch_xor_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i64_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoxor.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i64_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoxor.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_xor_i64_seq_cst(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    call __atomic_fetch_xor_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    li a3, 5
; RV32IA-NEXT:    call __atomic_fetch_xor_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li a2, 5
; RV64I-NEXT:    call __atomic_fetch_xor_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_xor_i64_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amoxor.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_xor_i64_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amoxor.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_max_i64_monotonic(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB220_2
; RV32I-NEXT:  .LBB220_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB220_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB220_7
; RV32I-NEXT:  .LBB220_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB220_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB220_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB220_5
; RV32I-NEXT:  .LBB220_4: # in Loop: Header=BB220_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB220_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB220_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB220_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB220_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB220_1
; RV32I-NEXT:  .LBB220_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB220_2
; RV32IA-NEXT:  .LBB220_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB220_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    li a4, 0
; RV32IA-NEXT:    li a5, 0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB220_7
; RV32IA-NEXT:  .LBB220_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB220_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB220_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB220_5
; RV32IA-NEXT:  .LBB220_4: # in Loop: Header=BB220_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB220_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB220_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB220_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB220_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB220_1
; RV32IA-NEXT:  .LBB220_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB220_2
; RV64I-NEXT:  .LBB220_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB220_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB220_4
; RV64I-NEXT:  .LBB220_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a3, .LBB220_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB220_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB220_1
; RV64I-NEXT:  .LBB220_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomax.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw max ptr %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_max_i64_acquire(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB221_2
; RV32I-NEXT:  .LBB221_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB221_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    li a5, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB221_7
; RV32I-NEXT:  .LBB221_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB221_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB221_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB221_5
; RV32I-NEXT:  .LBB221_4: # in Loop: Header=BB221_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB221_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB221_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB221_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB221_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB221_1
; RV32I-NEXT:  .LBB221_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB221_2
; RV32IA-NEXT:  .LBB221_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB221_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 2
; RV32IA-NEXT:    li a5, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB221_7
; RV32IA-NEXT:  .LBB221_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB221_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB221_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB221_5
; RV32IA-NEXT:  .LBB221_4: # in Loop: Header=BB221_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB221_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB221_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB221_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB221_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB221_1
; RV32IA-NEXT:  .LBB221_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB221_2
; RV64I-NEXT:  .LBB221_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB221_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB221_4
; RV64I-NEXT:  .LBB221_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a3, .LBB221_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB221_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB221_1
; RV64I-NEXT:  .LBB221_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i64_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomax.d.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i64_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomax.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_max_i64_release(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB222_2
; RV32I-NEXT:  .LBB222_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB222_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB222_7
; RV32I-NEXT:  .LBB222_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB222_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB222_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB222_5
; RV32I-NEXT:  .LBB222_4: # in Loop: Header=BB222_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB222_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB222_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB222_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB222_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB222_1
; RV32I-NEXT:  .LBB222_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB222_2
; RV32IA-NEXT:  .LBB222_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB222_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 3
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    li a5, 0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB222_7
; RV32IA-NEXT:  .LBB222_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB222_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB222_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB222_5
; RV32IA-NEXT:  .LBB222_4: # in Loop: Header=BB222_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB222_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB222_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB222_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB222_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB222_1
; RV32IA-NEXT:  .LBB222_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB222_2
; RV64I-NEXT:  .LBB222_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB222_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB222_4
; RV64I-NEXT:  .LBB222_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a3, .LBB222_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB222_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB222_1
; RV64I-NEXT:  .LBB222_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i64_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomax.d.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i64_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomax.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_max_i64_acq_rel(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB223_2
; RV32I-NEXT:  .LBB223_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB223_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 4
; RV32I-NEXT:    li a5, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB223_7
; RV32I-NEXT:  .LBB223_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB223_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB223_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB223_5
; RV32I-NEXT:  .LBB223_4: # in Loop: Header=BB223_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB223_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB223_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB223_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB223_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB223_1
; RV32I-NEXT:  .LBB223_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB223_2
; RV32IA-NEXT:  .LBB223_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB223_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 4
; RV32IA-NEXT:    li a5, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB223_7
; RV32IA-NEXT:  .LBB223_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB223_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB223_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB223_5
; RV32IA-NEXT:  .LBB223_4: # in Loop: Header=BB223_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB223_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB223_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB223_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB223_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB223_1
; RV32IA-NEXT:  .LBB223_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB223_2
; RV64I-NEXT:  .LBB223_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB223_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB223_4
; RV64I-NEXT:  .LBB223_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a3, .LBB223_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB223_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB223_1
; RV64I-NEXT:  .LBB223_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i64_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomax.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i64_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomax.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_max_i64_seq_cst(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB224_2
; RV32I-NEXT:  .LBB224_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB224_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    li a5, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB224_7
; RV32I-NEXT:  .LBB224_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB224_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB224_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB224_5
; RV32I-NEXT:  .LBB224_4: # in Loop: Header=BB224_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB224_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB224_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB224_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB224_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB224_1
; RV32I-NEXT:  .LBB224_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB224_2
; RV32IA-NEXT:  .LBB224_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB224_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 5
; RV32IA-NEXT:    li a5, 5
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB224_7
; RV32IA-NEXT:  .LBB224_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB224_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB224_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB224_5
; RV32IA-NEXT:  .LBB224_4: # in Loop: Header=BB224_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB224_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB224_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB224_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB224_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB224_1
; RV32IA-NEXT:  .LBB224_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB224_2
; RV64I-NEXT:  .LBB224_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB224_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB224_4
; RV64I-NEXT:  .LBB224_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a3, .LBB224_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB224_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB224_1
; RV64I-NEXT:  .LBB224_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_max_i64_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomax.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_max_i64_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomax.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw max ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_min_i64_monotonic(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB225_2
; RV32I-NEXT:  .LBB225_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB225_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB225_7
; RV32I-NEXT:  .LBB225_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB225_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB225_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB225_5
; RV32I-NEXT:  .LBB225_4: # in Loop: Header=BB225_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB225_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB225_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    beqz a0, .LBB225_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB225_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB225_1
; RV32I-NEXT:  .LBB225_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB225_2
; RV32IA-NEXT:  .LBB225_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB225_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    li a4, 0
; RV32IA-NEXT:    li a5, 0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB225_7
; RV32IA-NEXT:  .LBB225_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB225_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB225_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB225_5
; RV32IA-NEXT:  .LBB225_4: # in Loop: Header=BB225_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB225_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB225_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    beqz a0, .LBB225_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB225_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB225_1
; RV32IA-NEXT:  .LBB225_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB225_2
; RV64I-NEXT:  .LBB225_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB225_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB225_4
; RV64I-NEXT:  .LBB225_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a3, .LBB225_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB225_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB225_1
; RV64I-NEXT:  .LBB225_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomin.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw min ptr %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_min_i64_acquire(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB226_2
; RV32I-NEXT:  .LBB226_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB226_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    li a5, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB226_7
; RV32I-NEXT:  .LBB226_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB226_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB226_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB226_5
; RV32I-NEXT:  .LBB226_4: # in Loop: Header=BB226_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB226_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB226_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    beqz a0, .LBB226_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB226_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB226_1
; RV32I-NEXT:  .LBB226_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB226_2
; RV32IA-NEXT:  .LBB226_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB226_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 2
; RV32IA-NEXT:    li a5, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB226_7
; RV32IA-NEXT:  .LBB226_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB226_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB226_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB226_5
; RV32IA-NEXT:  .LBB226_4: # in Loop: Header=BB226_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB226_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB226_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    beqz a0, .LBB226_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB226_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB226_1
; RV32IA-NEXT:  .LBB226_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB226_2
; RV64I-NEXT:  .LBB226_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB226_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB226_4
; RV64I-NEXT:  .LBB226_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a3, .LBB226_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB226_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB226_1
; RV64I-NEXT:  .LBB226_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i64_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomin.d.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i64_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomin.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_min_i64_release(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB227_2
; RV32I-NEXT:  .LBB227_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB227_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB227_7
; RV32I-NEXT:  .LBB227_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB227_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB227_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB227_5
; RV32I-NEXT:  .LBB227_4: # in Loop: Header=BB227_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB227_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB227_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    beqz a0, .LBB227_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB227_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB227_1
; RV32I-NEXT:  .LBB227_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB227_2
; RV32IA-NEXT:  .LBB227_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB227_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 3
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    li a5, 0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB227_7
; RV32IA-NEXT:  .LBB227_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB227_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB227_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB227_5
; RV32IA-NEXT:  .LBB227_4: # in Loop: Header=BB227_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB227_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB227_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    beqz a0, .LBB227_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB227_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB227_1
; RV32IA-NEXT:  .LBB227_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB227_2
; RV64I-NEXT:  .LBB227_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB227_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB227_4
; RV64I-NEXT:  .LBB227_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a3, .LBB227_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB227_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB227_1
; RV64I-NEXT:  .LBB227_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i64_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomin.d.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i64_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomin.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_min_i64_acq_rel(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB228_2
; RV32I-NEXT:  .LBB228_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB228_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 4
; RV32I-NEXT:    li a5, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB228_7
; RV32I-NEXT:  .LBB228_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB228_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB228_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB228_5
; RV32I-NEXT:  .LBB228_4: # in Loop: Header=BB228_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB228_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB228_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    beqz a0, .LBB228_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB228_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB228_1
; RV32I-NEXT:  .LBB228_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB228_2
; RV32IA-NEXT:  .LBB228_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB228_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 4
; RV32IA-NEXT:    li a5, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB228_7
; RV32IA-NEXT:  .LBB228_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB228_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB228_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB228_5
; RV32IA-NEXT:  .LBB228_4: # in Loop: Header=BB228_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB228_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB228_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    beqz a0, .LBB228_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB228_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB228_1
; RV32IA-NEXT:  .LBB228_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB228_2
; RV64I-NEXT:  .LBB228_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB228_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB228_4
; RV64I-NEXT:  .LBB228_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a3, .LBB228_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB228_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB228_1
; RV64I-NEXT:  .LBB228_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i64_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomin.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i64_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomin.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_min_i64_seq_cst(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB229_2
; RV32I-NEXT:  .LBB229_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB229_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    li a5, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB229_7
; RV32I-NEXT:  .LBB229_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB229_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB229_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB229_5
; RV32I-NEXT:  .LBB229_4: # in Loop: Header=BB229_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB229_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB229_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    beqz a0, .LBB229_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB229_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB229_1
; RV32I-NEXT:  .LBB229_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB229_2
; RV32IA-NEXT:  .LBB229_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB229_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 5
; RV32IA-NEXT:    li a5, 5
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB229_7
; RV32IA-NEXT:  .LBB229_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB229_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB229_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB229_5
; RV32IA-NEXT:  .LBB229_4: # in Loop: Header=BB229_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB229_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB229_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    beqz a0, .LBB229_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB229_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB229_1
; RV32IA-NEXT:  .LBB229_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB229_2
; RV64I-NEXT:  .LBB229_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB229_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB229_4
; RV64I-NEXT:  .LBB229_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a3, .LBB229_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB229_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB229_1
; RV64I-NEXT:  .LBB229_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_min_i64_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomin.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_min_i64_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomin.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw min ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_umax_i64_monotonic(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB230_2
; RV32I-NEXT:  .LBB230_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB230_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB230_7
; RV32I-NEXT:  .LBB230_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB230_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB230_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB230_5
; RV32I-NEXT:  .LBB230_4: # in Loop: Header=BB230_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB230_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB230_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB230_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB230_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB230_1
; RV32I-NEXT:  .LBB230_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB230_2
; RV32IA-NEXT:  .LBB230_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB230_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    li a4, 0
; RV32IA-NEXT:    li a5, 0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB230_7
; RV32IA-NEXT:  .LBB230_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB230_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB230_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB230_5
; RV32IA-NEXT:  .LBB230_4: # in Loop: Header=BB230_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB230_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB230_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB230_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB230_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB230_1
; RV32IA-NEXT:  .LBB230_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB230_2
; RV64I-NEXT:  .LBB230_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB230_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB230_4
; RV64I-NEXT:  .LBB230_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a3, .LBB230_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB230_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB230_1
; RV64I-NEXT:  .LBB230_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomaxu.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_umax_i64_acquire(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB231_2
; RV32I-NEXT:  .LBB231_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB231_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    li a5, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB231_7
; RV32I-NEXT:  .LBB231_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB231_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB231_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB231_5
; RV32I-NEXT:  .LBB231_4: # in Loop: Header=BB231_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB231_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB231_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB231_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB231_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB231_1
; RV32I-NEXT:  .LBB231_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB231_2
; RV32IA-NEXT:  .LBB231_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB231_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 2
; RV32IA-NEXT:    li a5, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB231_7
; RV32IA-NEXT:  .LBB231_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB231_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB231_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB231_5
; RV32IA-NEXT:  .LBB231_4: # in Loop: Header=BB231_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB231_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB231_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB231_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB231_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB231_1
; RV32IA-NEXT:  .LBB231_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB231_2
; RV64I-NEXT:  .LBB231_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB231_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB231_4
; RV64I-NEXT:  .LBB231_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a3, .LBB231_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB231_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB231_1
; RV64I-NEXT:  .LBB231_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i64_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomaxu.d.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i64_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomaxu.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_umax_i64_release(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB232_2
; RV32I-NEXT:  .LBB232_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB232_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB232_7
; RV32I-NEXT:  .LBB232_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB232_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB232_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB232_5
; RV32I-NEXT:  .LBB232_4: # in Loop: Header=BB232_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB232_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB232_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB232_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB232_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB232_1
; RV32I-NEXT:  .LBB232_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB232_2
; RV32IA-NEXT:  .LBB232_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB232_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 3
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    li a5, 0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB232_7
; RV32IA-NEXT:  .LBB232_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB232_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB232_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB232_5
; RV32IA-NEXT:  .LBB232_4: # in Loop: Header=BB232_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB232_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB232_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB232_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB232_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB232_1
; RV32IA-NEXT:  .LBB232_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB232_2
; RV64I-NEXT:  .LBB232_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB232_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB232_4
; RV64I-NEXT:  .LBB232_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a3, .LBB232_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB232_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB232_1
; RV64I-NEXT:  .LBB232_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i64_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomaxu.d.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i64_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomaxu.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_umax_i64_acq_rel(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB233_2
; RV32I-NEXT:  .LBB233_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB233_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 4
; RV32I-NEXT:    li a5, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB233_7
; RV32I-NEXT:  .LBB233_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB233_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB233_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB233_5
; RV32I-NEXT:  .LBB233_4: # in Loop: Header=BB233_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB233_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB233_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB233_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB233_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB233_1
; RV32I-NEXT:  .LBB233_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB233_2
; RV32IA-NEXT:  .LBB233_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB233_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 4
; RV32IA-NEXT:    li a5, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB233_7
; RV32IA-NEXT:  .LBB233_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB233_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB233_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB233_5
; RV32IA-NEXT:  .LBB233_4: # in Loop: Header=BB233_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB233_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB233_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB233_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB233_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB233_1
; RV32IA-NEXT:  .LBB233_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB233_2
; RV64I-NEXT:  .LBB233_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB233_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB233_4
; RV64I-NEXT:  .LBB233_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a3, .LBB233_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB233_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB233_1
; RV64I-NEXT:  .LBB233_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i64_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomaxu.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i64_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomaxu.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_umax_i64_seq_cst(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB234_2
; RV32I-NEXT:  .LBB234_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB234_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    li a5, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB234_7
; RV32I-NEXT:  .LBB234_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB234_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB234_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB234_5
; RV32I-NEXT:  .LBB234_4: # in Loop: Header=BB234_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB234_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB234_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB234_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB234_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB234_1
; RV32I-NEXT:  .LBB234_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB234_2
; RV32IA-NEXT:  .LBB234_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB234_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 5
; RV32IA-NEXT:    li a5, 5
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB234_7
; RV32IA-NEXT:  .LBB234_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB234_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB234_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB234_5
; RV32IA-NEXT:  .LBB234_4: # in Loop: Header=BB234_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB234_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB234_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB234_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB234_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB234_1
; RV32IA-NEXT:  .LBB234_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB234_2
; RV64I-NEXT:  .LBB234_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB234_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB234_4
; RV64I-NEXT:  .LBB234_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a3, .LBB234_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB234_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB234_1
; RV64I-NEXT:  .LBB234_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umax_i64_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amomaxu.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umax_i64_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amomaxu.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umax ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_umin_i64_monotonic(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB235_2
; RV32I-NEXT:  .LBB235_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB235_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB235_7
; RV32I-NEXT:  .LBB235_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB235_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB235_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB235_5
; RV32I-NEXT:  .LBB235_4: # in Loop: Header=BB235_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB235_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB235_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    beqz a0, .LBB235_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB235_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB235_1
; RV32I-NEXT:  .LBB235_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB235_2
; RV32IA-NEXT:  .LBB235_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB235_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    li a4, 0
; RV32IA-NEXT:    li a5, 0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB235_7
; RV32IA-NEXT:  .LBB235_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB235_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB235_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB235_5
; RV32IA-NEXT:  .LBB235_4: # in Loop: Header=BB235_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB235_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB235_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    beqz a0, .LBB235_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB235_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB235_1
; RV32IA-NEXT:  .LBB235_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB235_2
; RV64I-NEXT:  .LBB235_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB235_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB235_4
; RV64I-NEXT:  .LBB235_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a3, .LBB235_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB235_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB235_1
; RV64I-NEXT:  .LBB235_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amominu.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_umin_i64_acquire(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB236_2
; RV32I-NEXT:  .LBB236_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB236_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    li a5, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB236_7
; RV32I-NEXT:  .LBB236_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB236_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB236_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB236_5
; RV32I-NEXT:  .LBB236_4: # in Loop: Header=BB236_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB236_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB236_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    beqz a0, .LBB236_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB236_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB236_1
; RV32I-NEXT:  .LBB236_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB236_2
; RV32IA-NEXT:  .LBB236_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB236_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 2
; RV32IA-NEXT:    li a5, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB236_7
; RV32IA-NEXT:  .LBB236_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB236_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB236_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB236_5
; RV32IA-NEXT:  .LBB236_4: # in Loop: Header=BB236_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB236_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB236_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    beqz a0, .LBB236_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB236_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB236_1
; RV32IA-NEXT:  .LBB236_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB236_2
; RV64I-NEXT:  .LBB236_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB236_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB236_4
; RV64I-NEXT:  .LBB236_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a3, .LBB236_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB236_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB236_1
; RV64I-NEXT:  .LBB236_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i64_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amominu.d.aq a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i64_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amominu.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_umin_i64_release(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB237_2
; RV32I-NEXT:  .LBB237_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB237_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB237_7
; RV32I-NEXT:  .LBB237_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB237_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB237_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB237_5
; RV32I-NEXT:  .LBB237_4: # in Loop: Header=BB237_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB237_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB237_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    beqz a0, .LBB237_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB237_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB237_1
; RV32I-NEXT:  .LBB237_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB237_2
; RV32IA-NEXT:  .LBB237_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB237_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 3
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    li a5, 0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB237_7
; RV32IA-NEXT:  .LBB237_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB237_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB237_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB237_5
; RV32IA-NEXT:  .LBB237_4: # in Loop: Header=BB237_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB237_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB237_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    beqz a0, .LBB237_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB237_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB237_1
; RV32IA-NEXT:  .LBB237_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB237_2
; RV64I-NEXT:  .LBB237_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB237_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB237_4
; RV64I-NEXT:  .LBB237_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a3, .LBB237_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB237_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB237_1
; RV64I-NEXT:  .LBB237_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i64_release:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amominu.d.rl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i64_release:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amominu.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_umin_i64_acq_rel(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB238_2
; RV32I-NEXT:  .LBB238_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB238_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 4
; RV32I-NEXT:    li a5, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB238_7
; RV32I-NEXT:  .LBB238_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB238_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB238_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB238_5
; RV32I-NEXT:  .LBB238_4: # in Loop: Header=BB238_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB238_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB238_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    beqz a0, .LBB238_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB238_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB238_1
; RV32I-NEXT:  .LBB238_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB238_2
; RV32IA-NEXT:  .LBB238_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB238_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 4
; RV32IA-NEXT:    li a5, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB238_7
; RV32IA-NEXT:  .LBB238_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB238_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB238_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB238_5
; RV32IA-NEXT:  .LBB238_4: # in Loop: Header=BB238_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB238_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB238_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    beqz a0, .LBB238_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB238_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB238_1
; RV32IA-NEXT:  .LBB238_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB238_2
; RV64I-NEXT:  .LBB238_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB238_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB238_4
; RV64I-NEXT:  .LBB238_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a3, .LBB238_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB238_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB238_1
; RV64I-NEXT:  .LBB238_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i64_acq_rel:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amominu.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i64_acq_rel:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amominu.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_umin_i64_seq_cst(ptr %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB239_2
; RV32I-NEXT:  .LBB239_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB239_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    li a5, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB239_7
; RV32I-NEXT:  .LBB239_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB239_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB239_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB239_5
; RV32I-NEXT:  .LBB239_4: # in Loop: Header=BB239_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB239_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB239_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    beqz a0, .LBB239_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB239_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB239_1
; RV32I-NEXT:  .LBB239_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB239_2
; RV32IA-NEXT:  .LBB239_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB239_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    li a4, 5
; RV32IA-NEXT:    li a5, 5
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB239_7
; RV32IA-NEXT:  .LBB239_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB239_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB239_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB239_5
; RV32IA-NEXT:  .LBB239_4: # in Loop: Header=BB239_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB239_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB239_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    beqz a0, .LBB239_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB239_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB239_1
; RV32IA-NEXT:  .LBB239_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB239_2
; RV64I-NEXT:  .LBB239_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB239_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB239_4
; RV64I-NEXT:  .LBB239_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a3, .LBB239_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB239_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB239_1
; RV64I-NEXT:  .LBB239_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: atomicrmw_umin_i64_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    amominu.d.aqrl a0, a1, (a0)
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-TSO-LABEL: atomicrmw_umin_i64_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    amominu.d a0, a1, (a0)
; RV64IA-TSO-NEXT:    ret
  %1 = atomicrmw umin ptr %a, i64 %b seq_cst
  ret i64 %1
}
