; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX6 %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX8 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11 %s
; RUN: llc -mtriple=r600 -mcpu=cypress -verify-machineinstrs < %s | FileCheck -check-prefixes=CYPRESS %s
; RUN: llc -mtriple=r600 -mcpu=cayman -verify-machineinstrs < %s | FileCheck -check-prefixes=CAYMAN %s

declare float @llvm.convert.from.fp16.f32(i16) nounwind readnone

define amdgpu_kernel void @test_convert_fp16_to_fp32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) nounwind {
; GFX6-LABEL: test_convert_fp16_to_fp32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: test_convert_fp16_to_fp32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    s_mov_b32 s10, s6
; GFX8-NEXT:    s_mov_b32 s11, s7
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; GFX8-NEXT:    s_mov_b32 s4, s0
; GFX8-NEXT:    s_mov_b32 s5, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX11-LABEL: test_convert_fp16_to_fp32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s10, s6
; GFX11-NEXT:    s_mov_b32 s11, s7
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s2
; GFX11-NEXT:    s_mov_b32 s9, s3
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    buffer_load_u16 v0, off, s[8:11], 0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; CYPRESS-LABEL: test_convert_fp16_to_fp32:
; CYPRESS:       ; %bb.0:
; CYPRESS-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; CYPRESS-NEXT:    TEX 0 @6
; CYPRESS-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; CYPRESS-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; CYPRESS-NEXT:    CF_END
; CYPRESS-NEXT:    PAD
; CYPRESS-NEXT:    Fetch clause starting at 6:
; CYPRESS-NEXT:     VTX_READ_16 T0.X, T0.X, 0, #1
; CYPRESS-NEXT:    ALU clause starting at 8:
; CYPRESS-NEXT:     MOV * T0.X, KC0[2].Z,
; CYPRESS-NEXT:    ALU clause starting at 9:
; CYPRESS-NEXT:     FLT16_TO_FLT32 T0.X, T0.X,
; CYPRESS-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; CYPRESS-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; CAYMAN-LABEL: test_convert_fp16_to_fp32:
; CAYMAN:       ; %bb.0:
; CAYMAN-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; CAYMAN-NEXT:    TEX 0 @6
; CAYMAN-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; CAYMAN-NEXT:    MEM_RAT_CACHELESS STORE_DWORD T0.X, T1.X
; CAYMAN-NEXT:    CF_END
; CAYMAN-NEXT:    PAD
; CAYMAN-NEXT:    Fetch clause starting at 6:
; CAYMAN-NEXT:     VTX_READ_16 T0.X, T0.X, 0, #1
; CAYMAN-NEXT:    ALU clause starting at 8:
; CAYMAN-NEXT:     MOV * T0.X, KC0[2].Z,
; CAYMAN-NEXT:    ALU clause starting at 9:
; CAYMAN-NEXT:     FLT16_TO_FLT32 * T0.X, T0.X,
; CAYMAN-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; CAYMAN-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %val = load i16, ptr addrspace(1) %in, align 2
  %cvt = call float @llvm.convert.from.fp16.f32(i16 %val) nounwind readnone
  store float %cvt, ptr addrspace(1) %out, align 4
  ret void
}
