; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s

define void @buildvector_v16i8_splat(ptr %dst, i8 %a0) nounwind {
; CHECK-LABEL: buildvector_v16i8_splat:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vreplgr2vr.b $vr0, $a1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %insert = insertelement <16 x i8> undef, i8 %a0, i8 0
  %splat = shufflevector <16 x i8> %insert, <16 x i8> undef, <16 x i32> zeroinitializer
  store <16 x i8> %splat, ptr %dst
  ret void
}

define void @buildvector_v8i16_splat(ptr %dst, i16 %a0) nounwind {
; CHECK-LABEL: buildvector_v8i16_splat:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vreplgr2vr.h $vr0, $a1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %insert = insertelement <8 x i16> undef, i16 %a0, i8 0
  %splat = shufflevector <8 x i16> %insert, <8 x i16> undef, <8 x i32> zeroinitializer
  store <8 x i16> %splat, ptr %dst
  ret void
}

define void @buildvector_v4i32_splat(ptr %dst, i32 %a0) nounwind {
; CHECK-LABEL: buildvector_v4i32_splat:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vreplgr2vr.w $vr0, $a1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %insert = insertelement <4 x i32> undef, i32 %a0, i8 0
  %splat = shufflevector <4 x i32> %insert, <4 x i32> undef, <4 x i32> zeroinitializer
  store <4 x i32> %splat, ptr %dst
  ret void
}

define void @buildvector_v2i64_splat(ptr %dst, i64 %a0) nounwind {
; CHECK-LABEL: buildvector_v2i64_splat:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vreplgr2vr.d $vr0, $a1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %insert = insertelement <2 x i64> undef, i64 %a0, i8 0
  %splat = shufflevector <2 x i64> %insert, <2 x i64> undef, <2 x i32> zeroinitializer
  store <2 x i64> %splat, ptr %dst
  ret void
}

define void @buildvector_v4f32_splat(ptr %dst, float %a0) nounwind {
; CHECK-LABEL: buildvector_v4f32_splat:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $f0 killed $f0 def $vr0
; CHECK-NEXT:    vreplvei.w $vr0, $vr0, 0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %insert = insertelement <4 x float> undef, float %a0, i8 0
  %splat = shufflevector <4 x float> %insert, <4 x float> undef, <4 x i32> zeroinitializer
  store <4 x float> %splat, ptr %dst
  ret void
}

define void @buildvector_v2f64_splat(ptr %dst, double %a0) nounwind {
; CHECK-LABEL: buildvector_v2f64_splat:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $f0_64 killed $f0_64 def $vr0
; CHECK-NEXT:    vreplvei.d $vr0, $vr0, 0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %insert = insertelement <2 x double> undef, double %a0, i8 0
  %splat = shufflevector <2 x double> %insert, <2 x double> undef, <2 x i32> zeroinitializer
  store <2 x double> %splat, ptr %dst
  ret void
}

define void @buildvector_v16i8_const_splat(ptr %dst) nounwind {
; CHECK-LABEL: buildvector_v16i8_const_splat:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vrepli.b $vr0, 1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  store <16 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>, ptr %dst
  ret void
}

define void @buildvector_v8i16_const_splat(ptr %dst) nounwind {
; CHECK-LABEL: buildvector_v8i16_const_splat:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vrepli.h $vr0, 1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  store <8 x i16> <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>, ptr %dst
  ret void
}

define void @buildvector_v4i32_const_splat(ptr %dst) nounwind {
; CHECK-LABEL: buildvector_v4i32_const_splat:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vrepli.w $vr0, 1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  store <4 x i32> <i32 1, i32 1, i32 1, i32 1>, ptr %dst
  ret void
}

define void @buildvector_v2i64_const_splat(ptr %dst) nounwind {
; CHECK-LABEL: buildvector_v2i64_const_splat:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vrepli.d $vr0, 1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  store <2 x i64> <i64 1, i64 1>, ptr %dst
  ret void
}

define void @buildvector_v2f32_const_splat(ptr %dst) nounwind {
; CHECK-LABEL: buildvector_v2f32_const_splat:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lu12i.w $a1, 260096
; CHECK-NEXT:    vreplgr2vr.w $vr0, $a1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  store <4 x float> <float 1.0, float 1.0, float 1.0, float 1.0>, ptr %dst
  ret void
}

define void @buildvector_v2f64_const_splat(ptr %dst) nounwind {
; CHECK-LABEL: buildvector_v2f64_const_splat:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lu52i.d $a1, $zero, 1023
; CHECK-NEXT:    vreplgr2vr.d $vr0, $a1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  store <2 x double> <double 1.0, double 1.0>, ptr %dst
  ret void
}

define void @buildvector_v16i8_const(ptr %dst) nounwind {
; CHECK-LABEL: buildvector_v16i8_const:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pcalau12i $a1, %pc_hi20(.LCPI12_0)
; CHECK-NEXT:    addi.d $a1, $a1, %pc_lo12(.LCPI12_0)
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  store <16 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15>, ptr %dst
  ret void
}

define void @buildvector_v8i16_const(ptr %dst) nounwind {
; CHECK-LABEL: buildvector_v8i16_const:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pcalau12i $a1, %pc_hi20(.LCPI13_0)
; CHECK-NEXT:    addi.d $a1, $a1, %pc_lo12(.LCPI13_0)
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  store <8 x i16> <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7>, ptr %dst
  ret void
}

define void @buildvector_v4i32_const(ptr %dst) nounwind {
; CHECK-LABEL: buildvector_v4i32_const:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pcalau12i $a1, %pc_hi20(.LCPI14_0)
; CHECK-NEXT:    addi.d $a1, $a1, %pc_lo12(.LCPI14_0)
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  store <4 x i32> <i32 0, i32 1, i32 2, i32 3>, ptr %dst
  ret void
}

define void @buildvector_v2i64_const(ptr %dst) nounwind {
; CHECK-LABEL: buildvector_v2i64_const:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pcalau12i $a1, %pc_hi20(.LCPI15_0)
; CHECK-NEXT:    addi.d $a1, $a1, %pc_lo12(.LCPI15_0)
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  store <2 x i64> <i64 0, i64 1>, ptr %dst
  ret void
}

define void @buildvector_v2f32_const(ptr %dst) nounwind {
; CHECK-LABEL: buildvector_v2f32_const:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pcalau12i $a1, %pc_hi20(.LCPI16_0)
; CHECK-NEXT:    addi.d $a1, $a1, %pc_lo12(.LCPI16_0)
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  store <4 x float> <float 0.0, float 1.0, float 2.0, float 3.0>, ptr %dst
  ret void
}

define void @buildvector_v2f64_const(ptr %dst) nounwind {
; CHECK-LABEL: buildvector_v2f64_const:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pcalau12i $a1, %pc_hi20(.LCPI17_0)
; CHECK-NEXT:    addi.d $a1, $a1, %pc_lo12(.LCPI17_0)
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  store <2 x double> <double 0.0, double 1.0>, ptr %dst
  ret void
}

define void @buildvector_v16i8(ptr %dst, i8 %a0, i8 %a1, i8 %a2, i8 %a3, i8 %a4, i8 %a5, i8 %a6, i8 %a7, i8 %a8, i8 %a9, i8 %a10, i8 %a11, i8 %a12, i8 %a13, i8 %a14, i8 %a15) nounwind {
; CHECK-LABEL: buildvector_v16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.b $t0, $sp, 64
; CHECK-NEXT:    ld.b $t1, $sp, 56
; CHECK-NEXT:    ld.b $t2, $sp, 48
; CHECK-NEXT:    ld.b $t3, $sp, 40
; CHECK-NEXT:    ld.b $t4, $sp, 32
; CHECK-NEXT:    ld.b $t5, $sp, 24
; CHECK-NEXT:    ld.b $t6, $sp, 16
; CHECK-NEXT:    ld.b $t7, $sp, 8
; CHECK-NEXT:    ld.b $t8, $sp, 0
; CHECK-NEXT:    vinsgr2vr.b $vr0, $a1, 0
; CHECK-NEXT:    vinsgr2vr.b $vr0, $a2, 1
; CHECK-NEXT:    vinsgr2vr.b $vr0, $a3, 2
; CHECK-NEXT:    vinsgr2vr.b $vr0, $a4, 3
; CHECK-NEXT:    vinsgr2vr.b $vr0, $a5, 4
; CHECK-NEXT:    vinsgr2vr.b $vr0, $a6, 5
; CHECK-NEXT:    vinsgr2vr.b $vr0, $a7, 6
; CHECK-NEXT:    vinsgr2vr.b $vr0, $t8, 7
; CHECK-NEXT:    vinsgr2vr.b $vr0, $t7, 8
; CHECK-NEXT:    vinsgr2vr.b $vr0, $t6, 9
; CHECK-NEXT:    vinsgr2vr.b $vr0, $t5, 10
; CHECK-NEXT:    vinsgr2vr.b $vr0, $t4, 11
; CHECK-NEXT:    vinsgr2vr.b $vr0, $t3, 12
; CHECK-NEXT:    vinsgr2vr.b $vr0, $t2, 13
; CHECK-NEXT:    vinsgr2vr.b $vr0, $t1, 14
; CHECK-NEXT:    vinsgr2vr.b $vr0, $t0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %ins0  = insertelement <16 x i8> undef,  i8 %a0,  i32 0
  %ins1  = insertelement <16 x i8> %ins0,  i8 %a1,  i32 1
  %ins2  = insertelement <16 x i8> %ins1,  i8 %a2,  i32 2
  %ins3  = insertelement <16 x i8> %ins2,  i8 %a3,  i32 3
  %ins4  = insertelement <16 x i8> %ins3,  i8 %a4,  i32 4
  %ins5  = insertelement <16 x i8> %ins4,  i8 %a5,  i32 5
  %ins6  = insertelement <16 x i8> %ins5,  i8 %a6,  i32 6
  %ins7  = insertelement <16 x i8> %ins6,  i8 %a7,  i32 7
  %ins8  = insertelement <16 x i8> %ins7,  i8 %a8,  i32 8
  %ins9  = insertelement <16 x i8> %ins8,  i8 %a9,  i32 9
  %ins10 = insertelement <16 x i8> %ins9,  i8 %a10, i32 10
  %ins11 = insertelement <16 x i8> %ins10, i8 %a11, i32 11
  %ins12 = insertelement <16 x i8> %ins11, i8 %a12, i32 12
  %ins13 = insertelement <16 x i8> %ins12, i8 %a13, i32 13
  %ins14 = insertelement <16 x i8> %ins13, i8 %a14, i32 14
  %ins15 = insertelement <16 x i8> %ins14, i8 %a15, i32 15
  store <16 x i8> %ins15, ptr %dst
  ret void
}

define void @buildvector_v8i16(ptr %dst, i16 %a0, i16 %a1, i16 %a2, i16 %a3, i16 %a4, i16 %a5, i16 %a6, i16 %a7) nounwind {
; CHECK-LABEL: buildvector_v8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.h $t0, $sp, 0
; CHECK-NEXT:    vinsgr2vr.h $vr0, $a1, 0
; CHECK-NEXT:    vinsgr2vr.h $vr0, $a2, 1
; CHECK-NEXT:    vinsgr2vr.h $vr0, $a3, 2
; CHECK-NEXT:    vinsgr2vr.h $vr0, $a4, 3
; CHECK-NEXT:    vinsgr2vr.h $vr0, $a5, 4
; CHECK-NEXT:    vinsgr2vr.h $vr0, $a6, 5
; CHECK-NEXT:    vinsgr2vr.h $vr0, $a7, 6
; CHECK-NEXT:    vinsgr2vr.h $vr0, $t0, 7
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %ins0 = insertelement <8 x i16> undef, i16 %a0, i32 0
  %ins1 = insertelement <8 x i16> %ins0, i16 %a1, i32 1
  %ins2 = insertelement <8 x i16> %ins1, i16 %a2, i32 2
  %ins3 = insertelement <8 x i16> %ins2, i16 %a3, i32 3
  %ins4 = insertelement <8 x i16> %ins3, i16 %a4, i32 4
  %ins5 = insertelement <8 x i16> %ins4, i16 %a5, i32 5
  %ins6 = insertelement <8 x i16> %ins5, i16 %a6, i32 6
  %ins7 = insertelement <8 x i16> %ins6, i16 %a7, i32 7
  store <8 x i16> %ins7, ptr %dst
  ret void
}

define void @buildvector_v4i32(ptr %dst, i32 %a0, i32 %a1, i32 %a2, i32 %a3) nounwind {
; CHECK-LABEL: buildvector_v4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a1, 0
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a2, 1
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a3, 2
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a4, 3
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %ins0 = insertelement <4 x i32> undef, i32 %a0, i32 0
  %ins1 = insertelement <4 x i32> %ins0, i32 %a1, i32 1
  %ins2 = insertelement <4 x i32> %ins1, i32 %a2, i32 2
  %ins3 = insertelement <4 x i32> %ins2, i32 %a3, i32 3
  store <4 x i32> %ins3, ptr %dst
  ret void
}

define void @buildvector_v2i64(ptr %dst, i64 %a0, i64 %a1) nounwind {
; CHECK-LABEL: buildvector_v2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a1, 0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a2, 1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %ins0 = insertelement <2 x i64> undef, i64 %a0, i32 0
  %ins1 = insertelement <2 x i64> %ins0, i64 %a1, i32 1
  store <2 x i64> %ins1, ptr %dst
  ret void
}

define void @buildvector_v4f32(ptr %dst, float %a0, float %a1, float %a2, float %a3) nounwind {
; CHECK-LABEL: buildvector_v4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movfr2gr.s $a1, $fa0
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a1, 0
; CHECK-NEXT:    movfr2gr.s $a1, $fa1
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a1, 1
; CHECK-NEXT:    movfr2gr.s $a1, $fa2
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a1, 2
; CHECK-NEXT:    movfr2gr.s $a1, $fa3
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a1, 3
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %ins0 = insertelement <4 x float> undef, float %a0, i32 0
  %ins1 = insertelement <4 x float> %ins0, float %a1, i32 1
  %ins2 = insertelement <4 x float> %ins1, float %a2, i32 2
  %ins3 = insertelement <4 x float> %ins2, float %a3, i32 3
  store <4 x float> %ins3, ptr %dst
  ret void
}

define void @buildvector_v2f64(ptr %dst, double %a0, double %a1) nounwind {
; CHECK-LABEL: buildvector_v2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movfr2gr.d $a1, $fa0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a1, 0
; CHECK-NEXT:    movfr2gr.d $a1, $fa1
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a1, 1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %ins0 = insertelement <2 x double> undef, double %a0, i32 0
  %ins1 = insertelement <2 x double> %ins0, double %a1, i32 1
  store <2 x double> %ins1, ptr %dst
  ret void
}

;; BUILD_VECTOR through stack.
;; If `isShuffleMaskLegal` returns true, it will lead to an infinite loop.
define void @extract1_i32_zext_insert0_i64_undef(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: extract1_i32_zext_insert0_i64_undef:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vpickve2gr.w $a0, $vr0, 1
; CHECK-NEXT:    bstrpick.d $a0, $a0, 31, 0
; CHECK-NEXT:    st.d $a0, $sp, 0
; CHECK-NEXT:    vld $vr0, $sp, 0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %v = load volatile <4 x i32>, ptr %src
  %e = extractelement <4 x i32> %v, i32 1
  %z = zext i32 %e to i64
  %r = insertelement <2 x i64> undef, i64 %z, i32 0
  store <2 x i64> %r, ptr %dst
  ret void
}
