; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mtriple=loongarch64 | FileCheck %s --check-prefixes=CHECK
; RUN: llc < %s --mtriple=loongarch64 --loongarch-disable-sextw-removal | \
; RUN:   FileCheck %s --check-prefix=NORMV

define void @test1(i32 signext %arg, i32 signext %arg1) nounwind {
; CHECK-LABEL: test1:
; CHECK:       # %bb.0: # %bb
; CHECK-NEXT:    addi.d $sp, $sp, -32
; CHECK-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $fp, $sp, 16 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $s0, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    move $fp, $a1
; CHECK-NEXT:    sra.w $s0, $a0, $a1
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB0_1: # %bb2
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    move $a0, $s0
; CHECK-NEXT:    bl %plt(bar)
; CHECK-NEXT:    sll.w $s0, $s0, $fp
; CHECK-NEXT:    bnez $a0, .LBB0_1
; CHECK-NEXT:  # %bb.2: # %bb7
; CHECK-NEXT:    ld.d $s0, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $fp, $sp, 16 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 32
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test1:
; NORMV:       # %bb.0: # %bb
; NORMV-NEXT:    addi.d $sp, $sp, -32
; NORMV-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $fp, $sp, 16 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $s0, $sp, 8 # 8-byte Folded Spill
; NORMV-NEXT:    move $fp, $a1
; NORMV-NEXT:    sra.w $s0, $a0, $a1
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB0_1: # %bb2
; NORMV-NEXT:    # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    addi.w $a0, $s0, 0
; NORMV-NEXT:    bl %plt(bar)
; NORMV-NEXT:    sll.w $s0, $s0, $fp
; NORMV-NEXT:    bnez $a0, .LBB0_1
; NORMV-NEXT:  # %bb.2: # %bb7
; NORMV-NEXT:    ld.d $s0, $sp, 8 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $fp, $sp, 16 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; NORMV-NEXT:    addi.d $sp, $sp, 32
; NORMV-NEXT:    ret
bb:
  %i = ashr i32 %arg, %arg1
  br label %bb2

bb2:                                              ; preds = %bb2, %bb
  %i3 = phi i32 [ %i, %bb ], [ %i5, %bb2 ]
  %i4 = tail call signext i32 @bar(i32 signext %i3)
  %i5 = shl i32 %i3, %arg1
  %i6 = icmp eq i32 %i4, 0
  br i1 %i6, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  ret void
}

declare signext i32 @bar(i32 signext)

define signext i32 @test2(ptr %p, i32 signext %b) nounwind {
; CHECK-LABEL: test2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.w $a0, $a0, 0
; CHECK-NEXT:    ori $a2, $zero, 1
; CHECK-NEXT:    sll.w $a1, $a2, $a1
; CHECK-NEXT:    andn $a0, $a0, $a1
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test2:
; NORMV:       # %bb.0:
; NORMV-NEXT:    ld.w $a0, $a0, 0
; NORMV-NEXT:    ori $a2, $zero, 1
; NORMV-NEXT:    sll.w $a1, $a2, $a1
; NORMV-NEXT:    andn $a0, $a0, $a1
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    ret
  %a = load i32, ptr %p
  %shl = shl i32 1, %b
  %neg = xor i32 %shl, -1
  %and1 = and i32 %neg, %a
  ret i32 %and1
}

define signext i32 @test3(ptr %p, i32 signext %b) nounwind {
; CHECK-LABEL: test3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.w $a0, $a0, 0
; CHECK-NEXT:    ori $a2, $zero, 1
; CHECK-NEXT:    sll.w $a1, $a2, $a1
; CHECK-NEXT:    orn $a0, $a0, $a1
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test3:
; NORMV:       # %bb.0:
; NORMV-NEXT:    ld.w $a0, $a0, 0
; NORMV-NEXT:    ori $a2, $zero, 1
; NORMV-NEXT:    sll.w $a1, $a2, $a1
; NORMV-NEXT:    orn $a0, $a0, $a1
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    ret
  %a = load i32, ptr %p
  %shl = shl i32 1, %b
  %neg = xor i32 %shl, -1
  %and1 = or i32 %neg, %a
  ret i32 %and1
}

define signext i32 @test4(ptr %p, i32 signext %b) nounwind {
; CHECK-LABEL: test4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.w $a0, $a0, 0
; CHECK-NEXT:    ori $a2, $zero, 1
; CHECK-NEXT:    sll.w $a1, $a2, $a1
; CHECK-NEXT:    xor $a0, $a1, $a0
; CHECK-NEXT:    nor $a0, $a0, $zero
; CHECK-NEXT:    addi.w $a0, $a0, 0
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test4:
; NORMV:       # %bb.0:
; NORMV-NEXT:    ld.w $a0, $a0, 0
; NORMV-NEXT:    ori $a2, $zero, 1
; NORMV-NEXT:    sll.w $a1, $a2, $a1
; NORMV-NEXT:    xor $a0, $a1, $a0
; NORMV-NEXT:    nor $a0, $a0, $zero
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    ret
  %a = load i32, ptr %p
  %shl = shl i32 1, %b
  %neg = xor i32 %shl, -1
  %and1 = xor i32 %neg, %a
  ret i32 %and1
}

define void @test5(i32 signext %arg, i32 signext %arg1) nounwind {
; CHECK-LABEL: test5:
; CHECK:       # %bb.0: # %bb
; CHECK-NEXT:    addi.d $sp, $sp, -48
; CHECK-NEXT:    st.d $ra, $sp, 40 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $fp, $sp, 32 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $s0, $sp, 24 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $s1, $sp, 16 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $s2, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    sra.w $a1, $a0, $a1
; CHECK-NEXT:    lu12i.w $a0, 349525
; CHECK-NEXT:    ori $fp, $a0, 1365
; CHECK-NEXT:    lu12i.w $a0, 209715
; CHECK-NEXT:    ori $s0, $a0, 819
; CHECK-NEXT:    lu12i.w $a0, 61680
; CHECK-NEXT:    ori $s1, $a0, 3855
; CHECK-NEXT:    lu12i.w $a0, 4112
; CHECK-NEXT:    ori $s2, $a0, 257
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB4_1: # %bb2
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    addi.w $a0, $a1, 0
; CHECK-NEXT:    bl %plt(bar)
; CHECK-NEXT:    srli.d $a1, $a0, 1
; CHECK-NEXT:    and $a1, $a1, $fp
; CHECK-NEXT:    sub.d $a1, $a0, $a1
; CHECK-NEXT:    and $a2, $a1, $s0
; CHECK-NEXT:    srli.d $a1, $a1, 2
; CHECK-NEXT:    and $a1, $a1, $s0
; CHECK-NEXT:    add.d $a1, $a2, $a1
; CHECK-NEXT:    srli.d $a2, $a1, 4
; CHECK-NEXT:    add.d $a1, $a1, $a2
; CHECK-NEXT:    and $a1, $a1, $s1
; CHECK-NEXT:    mul.d $a1, $a1, $s2
; CHECK-NEXT:    bstrpick.d $a1, $a1, 31, 24
; CHECK-NEXT:    bnez $a0, .LBB4_1
; CHECK-NEXT:  # %bb.2: # %bb7
; CHECK-NEXT:    ld.d $s2, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $s1, $sp, 16 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $s0, $sp, 24 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $fp, $sp, 32 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $ra, $sp, 40 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 48
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test5:
; NORMV:       # %bb.0: # %bb
; NORMV-NEXT:    addi.d $sp, $sp, -48
; NORMV-NEXT:    st.d $ra, $sp, 40 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $fp, $sp, 32 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $s0, $sp, 24 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $s1, $sp, 16 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $s2, $sp, 8 # 8-byte Folded Spill
; NORMV-NEXT:    sra.w $a1, $a0, $a1
; NORMV-NEXT:    lu12i.w $a0, 349525
; NORMV-NEXT:    ori $fp, $a0, 1365
; NORMV-NEXT:    lu12i.w $a0, 209715
; NORMV-NEXT:    ori $s0, $a0, 819
; NORMV-NEXT:    lu12i.w $a0, 61680
; NORMV-NEXT:    ori $s1, $a0, 3855
; NORMV-NEXT:    lu12i.w $a0, 4112
; NORMV-NEXT:    ori $s2, $a0, 257
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB4_1: # %bb2
; NORMV-NEXT:    # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    addi.w $a0, $a1, 0
; NORMV-NEXT:    bl %plt(bar)
; NORMV-NEXT:    srli.d $a1, $a0, 1
; NORMV-NEXT:    and $a1, $a1, $fp
; NORMV-NEXT:    sub.d $a1, $a0, $a1
; NORMV-NEXT:    and $a2, $a1, $s0
; NORMV-NEXT:    srli.d $a1, $a1, 2
; NORMV-NEXT:    and $a1, $a1, $s0
; NORMV-NEXT:    add.d $a1, $a2, $a1
; NORMV-NEXT:    srli.d $a2, $a1, 4
; NORMV-NEXT:    add.d $a1, $a1, $a2
; NORMV-NEXT:    and $a1, $a1, $s1
; NORMV-NEXT:    mul.d $a1, $a1, $s2
; NORMV-NEXT:    bstrpick.d $a1, $a1, 31, 24
; NORMV-NEXT:    bnez $a0, .LBB4_1
; NORMV-NEXT:  # %bb.2: # %bb7
; NORMV-NEXT:    ld.d $s2, $sp, 8 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $s1, $sp, 16 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $s0, $sp, 24 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $fp, $sp, 32 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $ra, $sp, 40 # 8-byte Folded Reload
; NORMV-NEXT:    addi.d $sp, $sp, 48
; NORMV-NEXT:    ret
bb:
  %i = ashr i32 %arg, %arg1
  br label %bb2

bb2:                                              ; preds = %bb2, %bb
  %i3 = phi i32 [ %i, %bb ], [ %i5, %bb2 ]
  %i4 = tail call signext i32 @bar(i32 signext %i3)
  %i5 = tail call i32 @llvm.ctpop.i32(i32 %i4)
  %i6 = icmp eq i32 %i4, 0
  br i1 %i6, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  ret void
}

declare i32 @llvm.ctpop.i32(i32)

define void @test6(i32 signext %arg, i32 signext %arg1) nounwind {
; CHECK-LABEL: test6:
; CHECK:       # %bb.0: # %bb
; CHECK-NEXT:    addi.d $sp, $sp, -32
; CHECK-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $fp, $sp, 16 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $s0, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    sra.w $fp, $a0, $a1
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB5_1: # %bb2
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    addi.w $a0, $fp, 0
; CHECK-NEXT:    bl %plt(baz)
; CHECK-NEXT:    move $s0, $a0
; CHECK-NEXT:    bl %plt(__fixsfsi)
; CHECK-NEXT:    move $fp, $a0
; CHECK-NEXT:    move $a0, $s0
; CHECK-NEXT:    move $a1, $zero
; CHECK-NEXT:    bl %plt(__nesf2)
; CHECK-NEXT:    bnez $a0, .LBB5_1
; CHECK-NEXT:  # %bb.2: # %bb7
; CHECK-NEXT:    ld.d $s0, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $fp, $sp, 16 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 32
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test6:
; NORMV:       # %bb.0: # %bb
; NORMV-NEXT:    addi.d $sp, $sp, -32
; NORMV-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $fp, $sp, 16 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $s0, $sp, 8 # 8-byte Folded Spill
; NORMV-NEXT:    sra.w $fp, $a0, $a1
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB5_1: # %bb2
; NORMV-NEXT:    # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    addi.w $a0, $fp, 0
; NORMV-NEXT:    bl %plt(baz)
; NORMV-NEXT:    move $s0, $a0
; NORMV-NEXT:    bl %plt(__fixsfsi)
; NORMV-NEXT:    move $fp, $a0
; NORMV-NEXT:    move $a0, $s0
; NORMV-NEXT:    move $a1, $zero
; NORMV-NEXT:    bl %plt(__nesf2)
; NORMV-NEXT:    bnez $a0, .LBB5_1
; NORMV-NEXT:  # %bb.2: # %bb7
; NORMV-NEXT:    ld.d $s0, $sp, 8 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $fp, $sp, 16 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; NORMV-NEXT:    addi.d $sp, $sp, 32
; NORMV-NEXT:    ret
bb:
  %i = ashr i32 %arg, %arg1
  br label %bb2

bb2:                                              ; preds = %bb2, %bb
  %i3 = phi i32 [ %i, %bb ], [ %i5, %bb2 ]
  %i4 = tail call float @baz(i32 signext %i3)
  %i5 = fptosi float %i4 to i32
  %i6 = fcmp oeq float %i4, zeroinitializer
  br i1 %i6, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  ret void
}
declare float @baz(i32 signext %i3)

define void @test7(i32 signext %arg, i32 signext %arg1) nounwind {
; CHECK-LABEL: test7:
; CHECK:       # %bb.0: # %bb
; CHECK-NEXT:    addi.d $sp, $sp, -48
; CHECK-NEXT:    st.d $ra, $sp, 40 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $fp, $sp, 32 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $s0, $sp, 24 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $s1, $sp, 16 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $s2, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    sra.w $a0, $a0, $a1
; CHECK-NEXT:    lu12i.w $a1, 349525
; CHECK-NEXT:    ori $a1, $a1, 1365
; CHECK-NEXT:    lu32i.d $a1, 349525
; CHECK-NEXT:    lu52i.d $fp, $a1, 1365
; CHECK-NEXT:    lu12i.w $a1, 209715
; CHECK-NEXT:    ori $a1, $a1, 819
; CHECK-NEXT:    lu32i.d $a1, 209715
; CHECK-NEXT:    lu52i.d $s0, $a1, 819
; CHECK-NEXT:    lu12i.w $a1, 61680
; CHECK-NEXT:    ori $a1, $a1, 3855
; CHECK-NEXT:    lu32i.d $a1, -61681
; CHECK-NEXT:    lu52i.d $s1, $a1, 240
; CHECK-NEXT:    lu12i.w $a1, 4112
; CHECK-NEXT:    ori $a1, $a1, 257
; CHECK-NEXT:    lu32i.d $a1, 65793
; CHECK-NEXT:    lu52i.d $s2, $a1, 16
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB6_1: # %bb2
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    bl %plt(foo)
; CHECK-NEXT:    srli.d $a1, $a0, 1
; CHECK-NEXT:    and $a1, $a1, $fp
; CHECK-NEXT:    sub.d $a0, $a0, $a1
; CHECK-NEXT:    and $a1, $a0, $s0
; CHECK-NEXT:    srli.d $a0, $a0, 2
; CHECK-NEXT:    and $a0, $a0, $s0
; CHECK-NEXT:    add.d $a0, $a1, $a0
; CHECK-NEXT:    srli.d $a1, $a0, 4
; CHECK-NEXT:    add.d $a0, $a0, $a1
; CHECK-NEXT:    and $a0, $a0, $s1
; CHECK-NEXT:    mul.d $a0, $a0, $s2
; CHECK-NEXT:    srli.d $a0, $a0, 56
; CHECK-NEXT:    bnez $a0, .LBB6_1
; CHECK-NEXT:  # %bb.2: # %bb7
; CHECK-NEXT:    ld.d $s2, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $s1, $sp, 16 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $s0, $sp, 24 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $fp, $sp, 32 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $ra, $sp, 40 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 48
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test7:
; NORMV:       # %bb.0: # %bb
; NORMV-NEXT:    addi.d $sp, $sp, -48
; NORMV-NEXT:    st.d $ra, $sp, 40 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $fp, $sp, 32 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $s0, $sp, 24 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $s1, $sp, 16 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $s2, $sp, 8 # 8-byte Folded Spill
; NORMV-NEXT:    sra.w $a0, $a0, $a1
; NORMV-NEXT:    lu12i.w $a1, 349525
; NORMV-NEXT:    ori $a1, $a1, 1365
; NORMV-NEXT:    lu32i.d $a1, 349525
; NORMV-NEXT:    lu52i.d $fp, $a1, 1365
; NORMV-NEXT:    lu12i.w $a1, 209715
; NORMV-NEXT:    ori $a1, $a1, 819
; NORMV-NEXT:    lu32i.d $a1, 209715
; NORMV-NEXT:    lu52i.d $s0, $a1, 819
; NORMV-NEXT:    lu12i.w $a1, 61680
; NORMV-NEXT:    ori $a1, $a1, 3855
; NORMV-NEXT:    lu32i.d $a1, -61681
; NORMV-NEXT:    lu52i.d $s1, $a1, 240
; NORMV-NEXT:    lu12i.w $a1, 4112
; NORMV-NEXT:    ori $a1, $a1, 257
; NORMV-NEXT:    lu32i.d $a1, 65793
; NORMV-NEXT:    lu52i.d $s2, $a1, 16
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB6_1: # %bb2
; NORMV-NEXT:    # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    bl %plt(foo)
; NORMV-NEXT:    srli.d $a1, $a0, 1
; NORMV-NEXT:    and $a1, $a1, $fp
; NORMV-NEXT:    sub.d $a0, $a0, $a1
; NORMV-NEXT:    and $a1, $a0, $s0
; NORMV-NEXT:    srli.d $a0, $a0, 2
; NORMV-NEXT:    and $a0, $a0, $s0
; NORMV-NEXT:    add.d $a0, $a1, $a0
; NORMV-NEXT:    srli.d $a1, $a0, 4
; NORMV-NEXT:    add.d $a0, $a0, $a1
; NORMV-NEXT:    and $a0, $a0, $s1
; NORMV-NEXT:    mul.d $a0, $a0, $s2
; NORMV-NEXT:    srli.d $a0, $a0, 56
; NORMV-NEXT:    bnez $a0, .LBB6_1
; NORMV-NEXT:  # %bb.2: # %bb7
; NORMV-NEXT:    ld.d $s2, $sp, 8 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $s1, $sp, 16 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $s0, $sp, 24 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $fp, $sp, 32 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $ra, $sp, 40 # 8-byte Folded Reload
; NORMV-NEXT:    addi.d $sp, $sp, 48
; NORMV-NEXT:    ret
bb:
  %i = ashr i32 %arg, %arg1
  br label %bb2

bb2:                                              ; preds = %bb2, %bb
  %i3 = phi i32 [ %i, %bb ], [ %i6, %bb2 ]
  %i4 = tail call signext i64 @foo(i32 signext %i3)
  %i5 = tail call i64 @llvm.ctpop.i64(i64 %i4)
  %i6 = trunc i64 %i5 to i32
  %i7 = icmp eq i32 %i6, 0
  br i1 %i7, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  ret void
}

declare i64 @llvm.ctpop.i64(i64)

define void @test8(i32 signext %arg, i32 signext %arg1) nounwind {
; CHECK-LABEL: test8:
; CHECK:       # %bb.0: # %bb
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; CHECK-NEXT:    sra.w $a0, $a0, $a1
; CHECK-NEXT:    addi.w $fp, $zero, -256
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB7_1: # %bb2
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    addi.w $a0, $a0, 0
; CHECK-NEXT:    bl %plt(foo)
; CHECK-NEXT:    or $a0, $a0, $fp
; CHECK-NEXT:    bnez $a0, .LBB7_1
; CHECK-NEXT:  # %bb.2: # %bb7
; CHECK-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test8:
; NORMV:       # %bb.0: # %bb
; NORMV-NEXT:    addi.d $sp, $sp, -16
; NORMV-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; NORMV-NEXT:    sra.w $a0, $a0, $a1
; NORMV-NEXT:    addi.w $fp, $zero, -256
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB7_1: # %bb2
; NORMV-NEXT:    # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    bl %plt(foo)
; NORMV-NEXT:    or $a0, $a0, $fp
; NORMV-NEXT:    bnez $a0, .LBB7_1
; NORMV-NEXT:  # %bb.2: # %bb7
; NORMV-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; NORMV-NEXT:    addi.d $sp, $sp, 16
; NORMV-NEXT:    ret
bb:
  %i = ashr i32 %arg, %arg1
  br label %bb2

bb2:                                              ; preds = %bb2, %bb
  %i3 = phi i32 [ %i, %bb ], [ %i6, %bb2 ]
  %i4 = tail call signext i64 @foo(i32 signext %i3)
  %i5 = or i64 %i4, -256
  %i6 = trunc i64 %i5 to i32
  %i7 = icmp eq i32 %i6, 0
  br i1 %i7, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  ret void
}

declare i64 @foo(i32 signext)

define void @test9(i32 signext %arg, i32 signext %arg1) nounwind {
; CHECK-LABEL: test9:
; CHECK:       # %bb.0: # %bb
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; CHECK-NEXT:    sra.w $a0, $a0, $a1
; CHECK-NEXT:    ori $fp, $zero, 254
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB8_1: # %bb2
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    bl %plt(bar)
; CHECK-NEXT:    move $a1, $a0
; CHECK-NEXT:    slti $a0, $a0, 255
; CHECK-NEXT:    blt $fp, $a1, .LBB8_1
; CHECK-NEXT:  # %bb.2: # %bb7
; CHECK-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test9:
; NORMV:       # %bb.0: # %bb
; NORMV-NEXT:    addi.d $sp, $sp, -16
; NORMV-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; NORMV-NEXT:    sra.w $a1, $a0, $a1
; NORMV-NEXT:    ori $fp, $zero, 254
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB8_1: # %bb2
; NORMV-NEXT:    # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    addi.w $a0, $a1, 0
; NORMV-NEXT:    bl %plt(bar)
; NORMV-NEXT:    slti $a1, $a0, 255
; NORMV-NEXT:    blt $fp, $a0, .LBB8_1
; NORMV-NEXT:  # %bb.2: # %bb7
; NORMV-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; NORMV-NEXT:    addi.d $sp, $sp, 16
; NORMV-NEXT:    ret
bb:
  %i = ashr i32 %arg, %arg1
  br label %bb2

bb2:                                              ; preds = %bb2, %bb
  %i3 = phi i32 [ %i, %bb ], [ %i7, %bb2 ]
  %i4 = tail call signext i32 @bar(i32 signext %i3)
  %i5 = icmp slt i32 %i4, 255
  %i6 = sext i1 %i5 to i32
  %i7 = sub i32 0, %i6
  br i1 %i5, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  ret void
}

define void @test10(i32 signext %arg, i32 signext %arg1) nounwind {
; CHECK-LABEL: test10:
; CHECK:       # %bb.0: # %bb
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; CHECK-NEXT:    sra.w $fp, $a0, $a1
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB9_1: # %bb2
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    addi.w $a0, $fp, 0
; CHECK-NEXT:    bl %plt(baz)
; CHECK-NEXT:    move $fp, $a0
; CHECK-NEXT:    move $a1, $zero
; CHECK-NEXT:    bl %plt(__nesf2)
; CHECK-NEXT:    bnez $a0, .LBB9_1
; CHECK-NEXT:  # %bb.2: # %bb7
; CHECK-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test10:
; NORMV:       # %bb.0: # %bb
; NORMV-NEXT:    addi.d $sp, $sp, -16
; NORMV-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; NORMV-NEXT:    sra.w $fp, $a0, $a1
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB9_1: # %bb2
; NORMV-NEXT:    # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    addi.w $a0, $fp, 0
; NORMV-NEXT:    bl %plt(baz)
; NORMV-NEXT:    move $fp, $a0
; NORMV-NEXT:    move $a1, $zero
; NORMV-NEXT:    bl %plt(__nesf2)
; NORMV-NEXT:    bnez $a0, .LBB9_1
; NORMV-NEXT:  # %bb.2: # %bb7
; NORMV-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; NORMV-NEXT:    addi.d $sp, $sp, 16
; NORMV-NEXT:    ret
bb:
  %i = ashr i32 %arg, %arg1
  br label %bb2

bb2:                                              ; preds = %bb2, %bb
  %i3 = phi i32 [ %i, %bb ], [ %i5, %bb2 ]
  %i4 = tail call float @baz(i32 signext %i3)
  %i5 = bitcast float %i4 to i32
  %i6 = fcmp oeq float %i4, zeroinitializer
  br i1 %i6, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  ret void
}

define signext i32 @test11(i64 %arg1, i64 %arg2, i64 %arg3)  {
; CHECK-LABEL: test11:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $a2, $a2, -1
; CHECK-NEXT:    ori $a3, $zero, 256
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB10_1: # %bb2
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    andi $a0, $a0, 1234
; CHECK-NEXT:    addi.d $a2, $a2, 1
; CHECK-NEXT:    add.w $a0, $a0, $a1
; CHECK-NEXT:    bltu $a2, $a3, .LBB10_1
; CHECK-NEXT:  # %bb.2: # %bb7
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test11:
; NORMV:       # %bb.0: # %entry
; NORMV-NEXT:    addi.d $a2, $a2, -1
; NORMV-NEXT:    ori $a3, $zero, 256
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB10_1: # %bb2
; NORMV-NEXT:    # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    andi $a0, $a0, 1234
; NORMV-NEXT:    addi.d $a2, $a2, 1
; NORMV-NEXT:    add.d $a0, $a0, $a1
; NORMV-NEXT:    bltu $a2, $a3, .LBB10_1
; NORMV-NEXT:  # %bb.2: # %bb7
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    ret
entry:
  br label %bb2

bb2:                                              ; preds = %bb2, %entry
  %i1 = phi i64 [ %arg1, %entry ], [ %i5, %bb2 ]
  %i2 = phi i64 [ %arg3, %entry ], [ %i3, %bb2 ]
  %i3 = add i64 %i2, 1
  %i4 = and i64 %i1, 1234
  %i5 = add i64 %i4, %arg2
  %i6 = icmp ugt i64 %i2, 255
  br i1 %i6, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  %i7 = trunc i64 %i5 to i32
  ret i32 %i7
}

define signext i32 @test12(i64 %arg1, i64 %arg2, i64 %arg3)  {
; CHECK-LABEL: test12:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $a3, $a2, -1
; CHECK-NEXT:    ori $a4, $zero, 256
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB11_1: # %bb2
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    xor $a0, $a0, $a1
; CHECK-NEXT:    mul.w $a2, $a0, $a1
; CHECK-NEXT:    add.w $a0, $a0, $a2
; CHECK-NEXT:    and $a2, $a2, $a0
; CHECK-NEXT:    addi.d $a3, $a3, 1
; CHECK-NEXT:    add.d $a0, $a2, $a1
; CHECK-NEXT:    bltu $a3, $a4, .LBB11_1
; CHECK-NEXT:  # %bb.2: # %bb7
; CHECK-NEXT:    move $a0, $a2
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test12:
; NORMV:       # %bb.0: # %entry
; NORMV-NEXT:    addi.d $a2, $a2, -1
; NORMV-NEXT:    ori $a3, $zero, 256
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB11_1: # %bb2
; NORMV-NEXT:    # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    xor $a0, $a0, $a1
; NORMV-NEXT:    mul.d $a4, $a0, $a1
; NORMV-NEXT:    add.d $a0, $a0, $a4
; NORMV-NEXT:    and $a4, $a4, $a0
; NORMV-NEXT:    addi.d $a2, $a2, 1
; NORMV-NEXT:    add.d $a0, $a4, $a1
; NORMV-NEXT:    bltu $a2, $a3, .LBB11_1
; NORMV-NEXT:  # %bb.2: # %bb7
; NORMV-NEXT:    addi.w $a0, $a4, 0
; NORMV-NEXT:    ret
entry:
  br label %bb2

bb2:                                              ; preds = %bb2, %entry
  %i1 = phi i64 [ %arg1, %entry ], [ %i6, %bb2 ]
  %i2 = phi i64 [ %arg3, %entry ], [ %i3, %bb2 ]
  %i3 = add i64 %i2, 1
  %i4 = xor i64 %i1, %arg2
  %i5 = mul i64 %i4, %arg2
  %i9 = add i64 %i4, %i5
  %i8 = and i64 %i5, %i9
  %i6 = add i64 %i8, %arg2
  %i7 = icmp ugt i64 %i2, 255
  br i1 %i7, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  %r = trunc i64 %i8 to i32
  ret i32 %r
}

define signext i32 @test13(i64 %arg1, i64 %arg2, i64 %arg3)  {
; CHECK-LABEL: test13:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $a2, $a2, -1
; CHECK-NEXT:    ori $a3, $zero, 256
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB12_1: # %bb2
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    div.d $a0, $a0, $a1
; CHECK-NEXT:    addi.d $a2, $a2, 1
; CHECK-NEXT:    add.d $a0, $a0, $a1
; CHECK-NEXT:    bltu $a2, $a3, .LBB12_1
; CHECK-NEXT:  # %bb.2: # %bb7
; CHECK-NEXT:    addi.w $a0, $a0, 0
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test13:
; NORMV:       # %bb.0: # %entry
; NORMV-NEXT:    addi.d $a2, $a2, -1
; NORMV-NEXT:    ori $a3, $zero, 256
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB12_1: # %bb2
; NORMV-NEXT:    # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    div.d $a0, $a0, $a1
; NORMV-NEXT:    addi.d $a2, $a2, 1
; NORMV-NEXT:    add.d $a0, $a0, $a1
; NORMV-NEXT:    bltu $a2, $a3, .LBB12_1
; NORMV-NEXT:  # %bb.2: # %bb7
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    ret
entry:
  br label %bb2

bb2:                                              ; preds = %bb2, %entry
  %i1 = phi i64 [ %arg1, %entry ], [ %i5, %bb2 ]
  %i2 = phi i64 [ %arg3, %entry ], [ %i3, %bb2 ]
  %i3 = add i64 %i2, 1
  %i4 = sdiv i64 %i1, %arg2
  %i5 = add i64 %i4, %arg2
  %i6 = icmp ugt i64 %i2, 255
  br i1 %i6, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  %i8 = trunc i64 %i5 to i32
  ret i32 %i8
}


define signext i32 @test14(i32 signext %0, i32 signext %1) {
; CHECK-LABEL: test14:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ori $a2, $zero, 2
; CHECK-NEXT:    blt $a1, $a2, .LBB13_4
; CHECK-NEXT:  # %bb.1: # %.preheader
; CHECK-NEXT:    ori $a3, $zero, 1
; CHECK-NEXT:    addi.w $a2, $zero, -1
; CHECK-NEXT:    ori $a4, $zero, 1000
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB13_2: # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    blt $a4, $a0, .LBB13_5
; CHECK-NEXT:  # %bb.3: # in Loop: Header=BB13_2 Depth=1
; CHECK-NEXT:    add.w $a0, $a3, $a0
; CHECK-NEXT:    addi.w $a3, $a3, 1
; CHECK-NEXT:    blt $a3, $a1, .LBB13_2
; CHECK-NEXT:  .LBB13_4:
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB13_5:
; CHECK-NEXT:    move $a0, $a2
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test14:
; NORMV:       # %bb.0:
; NORMV-NEXT:    ori $a2, $zero, 2
; NORMV-NEXT:    blt $a1, $a2, .LBB13_4
; NORMV-NEXT:  # %bb.1: # %.preheader
; NORMV-NEXT:    ori $a3, $zero, 1
; NORMV-NEXT:    addi.w $a2, $zero, -1
; NORMV-NEXT:    ori $a4, $zero, 1000
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB13_2: # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    addi.w $a5, $a0, 0
; NORMV-NEXT:    blt $a4, $a5, .LBB13_5
; NORMV-NEXT:  # %bb.3: # in Loop: Header=BB13_2 Depth=1
; NORMV-NEXT:    add.d $a0, $a3, $a0
; NORMV-NEXT:    addi.d $a3, $a3, 1
; NORMV-NEXT:    addi.w $a3, $a3, 0
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    blt $a3, $a1, .LBB13_2
; NORMV-NEXT:  .LBB13_4:
; NORMV-NEXT:    ret
; NORMV-NEXT:  .LBB13_5:
; NORMV-NEXT:    move $a0, $a2
; NORMV-NEXT:    ret
  %3 = icmp sgt i32 %1, 1
  br i1 %3, label %4, label %12

4:                                                ; preds = %2, %8
  %5 = phi i32 [ %10, %8 ], [ 1, %2 ]
  %6 = phi i32 [ %9, %8 ], [ %0, %2 ]
  %7 = icmp sgt i32 %6, 1000
  br i1 %7, label %12, label %8

8:                                                ; preds = %4
  %9 = add nsw i32 %5, %6
  %10 = add nuw nsw i32 %5, 1
  %11 = icmp slt i32 %10, %1
  br i1 %11, label %4, label %12

12:                                               ; preds = %8, %4, %2
  %13 = phi i32 [ %0, %2 ], [ -1, %4 ], [ %9, %8 ]
  ret i32 %13
}

define signext i32 @test14b(i32 %0, i32 signext %1) {
; CHECK-LABEL: test14b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ori $a2, $zero, 2
; CHECK-NEXT:    blt $a1, $a2, .LBB14_4
; CHECK-NEXT:  # %bb.1: # %.preheader
; CHECK-NEXT:    ori $a2, $zero, 1
; CHECK-NEXT:    ori $a3, $zero, 1000
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB14_2: # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    addi.w $a4, $a0, 0
; CHECK-NEXT:    blt $a3, $a4, .LBB14_5
; CHECK-NEXT:  # %bb.3: # in Loop: Header=BB14_2 Depth=1
; CHECK-NEXT:    add.d $a0, $a2, $a0
; CHECK-NEXT:    addi.w $a2, $a2, 1
; CHECK-NEXT:    blt $a2, $a1, .LBB14_2
; CHECK-NEXT:  .LBB14_4:
; CHECK-NEXT:    addi.w $a0, $a0, 0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB14_5:
; CHECK-NEXT:    addi.d $a0, $zero, -1
; CHECK-NEXT:    addi.w $a0, $a0, 0
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test14b:
; NORMV:       # %bb.0:
; NORMV-NEXT:    ori $a2, $zero, 2
; NORMV-NEXT:    blt $a1, $a2, .LBB14_4
; NORMV-NEXT:  # %bb.1: # %.preheader
; NORMV-NEXT:    ori $a2, $zero, 1
; NORMV-NEXT:    ori $a3, $zero, 1000
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB14_2: # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    addi.w $a4, $a0, 0
; NORMV-NEXT:    blt $a3, $a4, .LBB14_5
; NORMV-NEXT:  # %bb.3: # in Loop: Header=BB14_2 Depth=1
; NORMV-NEXT:    add.d $a0, $a2, $a0
; NORMV-NEXT:    addi.d $a2, $a2, 1
; NORMV-NEXT:    addi.w $a2, $a2, 0
; NORMV-NEXT:    addi.d $a0, $a0, 0
; NORMV-NEXT:    blt $a2, $a1, .LBB14_2
; NORMV-NEXT:  .LBB14_4:
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    ret
; NORMV-NEXT:  .LBB14_5:
; NORMV-NEXT:    addi.d $a0, $zero, -1
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    ret
  %3 = icmp sgt i32 %1, 1
  br i1 %3, label %4, label %12

4:                                                ; preds = %2, %8
  %5 = phi i32 [ %10, %8 ], [ 1, %2 ]
  %6 = phi i32 [ %9, %8 ], [ %0, %2 ]
  %7 = icmp sgt i32 %6, 1000
  br i1 %7, label %12, label %8

8:                                                ; preds = %4
  %9 = add nsw i32 %5, %6
  %10 = add nuw nsw i32 %5, 1
  %11 = icmp slt i32 %10, %1
  br i1 %11, label %4, label %12

12:                                               ; preds = %8, %4, %2
  %13 = phi i32 [ %0, %2 ], [ -1, %4 ], [ %9, %8 ]
  ret i32 %13
}

define signext i32 @test14c(i32 zeroext %0, i32 signext %1) {
; CHECK-LABEL: test14c:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ori $a2, $zero, 2
; CHECK-NEXT:    blt $a1, $a2, .LBB15_4
; CHECK-NEXT:  # %bb.1: # %.preheader
; CHECK-NEXT:    ori $a2, $zero, 1
; CHECK-NEXT:    ori $a3, $zero, 1000
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB15_2: # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    addi.w $a4, $a0, 0
; CHECK-NEXT:    blt $a3, $a4, .LBB15_5
; CHECK-NEXT:  # %bb.3: # in Loop: Header=BB15_2 Depth=1
; CHECK-NEXT:    add.d $a0, $a2, $a0
; CHECK-NEXT:    addi.w $a2, $a2, 1
; CHECK-NEXT:    blt $a2, $a1, .LBB15_2
; CHECK-NEXT:  .LBB15_4:
; CHECK-NEXT:    addi.w $a0, $a0, 0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB15_5:
; CHECK-NEXT:    addi.d $a0, $zero, -1
; CHECK-NEXT:    addi.w $a0, $a0, 0
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test14c:
; NORMV:       # %bb.0:
; NORMV-NEXT:    ori $a2, $zero, 2
; NORMV-NEXT:    blt $a1, $a2, .LBB15_4
; NORMV-NEXT:  # %bb.1: # %.preheader
; NORMV-NEXT:    ori $a2, $zero, 1
; NORMV-NEXT:    ori $a3, $zero, 1000
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB15_2: # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    addi.w $a4, $a0, 0
; NORMV-NEXT:    blt $a3, $a4, .LBB15_5
; NORMV-NEXT:  # %bb.3: # in Loop: Header=BB15_2 Depth=1
; NORMV-NEXT:    add.d $a0, $a2, $a0
; NORMV-NEXT:    addi.d $a2, $a2, 1
; NORMV-NEXT:    addi.w $a2, $a2, 0
; NORMV-NEXT:    addi.d $a0, $a0, 0
; NORMV-NEXT:    blt $a2, $a1, .LBB15_2
; NORMV-NEXT:  .LBB15_4:
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    ret
; NORMV-NEXT:  .LBB15_5:
; NORMV-NEXT:    addi.d $a0, $zero, -1
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    ret
  %3 = icmp sgt i32 %1, 1
  br i1 %3, label %4, label %12

4:                                                ; preds = %2, %8
  %5 = phi i32 [ %10, %8 ], [ 1, %2 ]
  %6 = phi i32 [ %9, %8 ], [ %0, %2 ]
  %7 = icmp sgt i32 %6, 1000
  br i1 %7, label %12, label %8

8:                                                ; preds = %4
  %9 = add nsw i32 %5, %6
  %10 = add nuw nsw i32 %5, 1
  %11 = icmp slt i32 %10, %1
  br i1 %11, label %4, label %12

12:                                               ; preds = %8, %4, %2
  %13 = phi i32 [ %0, %2 ], [ -1, %4 ], [ %9, %8 ]
  ret i32 %13
}

define signext i32 @test14d(i31 zeroext %0, i32 signext %1) {
; CHECK-LABEL: test14d:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ori $a2, $zero, 2
; CHECK-NEXT:    blt $a1, $a2, .LBB16_4
; CHECK-NEXT:  # %bb.1: # %.preheader
; CHECK-NEXT:    ori $a3, $zero, 1
; CHECK-NEXT:    addi.w $a2, $zero, -1
; CHECK-NEXT:    ori $a4, $zero, 1000
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB16_2: # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    blt $a4, $a0, .LBB16_5
; CHECK-NEXT:  # %bb.3: # in Loop: Header=BB16_2 Depth=1
; CHECK-NEXT:    add.w $a0, $a3, $a0
; CHECK-NEXT:    addi.w $a3, $a3, 1
; CHECK-NEXT:    blt $a3, $a1, .LBB16_2
; CHECK-NEXT:  .LBB16_4:
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB16_5:
; CHECK-NEXT:    move $a0, $a2
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test14d:
; NORMV:       # %bb.0:
; NORMV-NEXT:    ori $a2, $zero, 2
; NORMV-NEXT:    blt $a1, $a2, .LBB16_4
; NORMV-NEXT:  # %bb.1: # %.preheader
; NORMV-NEXT:    ori $a3, $zero, 1
; NORMV-NEXT:    addi.w $a2, $zero, -1
; NORMV-NEXT:    ori $a4, $zero, 1000
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB16_2: # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    addi.w $a5, $a0, 0
; NORMV-NEXT:    blt $a4, $a5, .LBB16_5
; NORMV-NEXT:  # %bb.3: # in Loop: Header=BB16_2 Depth=1
; NORMV-NEXT:    add.d $a0, $a3, $a0
; NORMV-NEXT:    addi.d $a3, $a3, 1
; NORMV-NEXT:    addi.w $a3, $a3, 0
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    blt $a3, $a1, .LBB16_2
; NORMV-NEXT:  .LBB16_4:
; NORMV-NEXT:    ret
; NORMV-NEXT:  .LBB16_5:
; NORMV-NEXT:    move $a0, $a2
; NORMV-NEXT:    ret
  %zext = zext i31 %0 to i32
  %3 = icmp sgt i32 %1, 1
  br i1 %3, label %4, label %12

4:                                                ; preds = %2, %8
  %5 = phi i32 [ %10, %8 ], [ 1, %2 ]
  %6 = phi i32 [ %9, %8 ], [ %zext, %2 ]
  %7 = icmp sgt i32 %6, 1000
  br i1 %7, label %12, label %8

8:                                                ; preds = %4
  %9 = add nsw i32 %5, %6
  %10 = add nuw nsw i32 %5, 1
  %11 = icmp slt i32 %10, %1
  br i1 %11, label %4, label %12

12:                                               ; preds = %8, %4, %2
  %13 = phi i32 [ %zext, %2 ], [ -1, %4 ], [ %9, %8 ]
  ret i32 %13
}

define signext i32 @test15(i64 %arg1, i64 %arg2, i64 %arg3, ptr %arg4)  {
; CHECK-LABEL: test15:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $a2, $a2, -1
; CHECK-NEXT:    ori $a4, $zero, 256
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB17_1: # %bb2
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    andi $a0, $a0, 1234
; CHECK-NEXT:    add.w $a0, $a0, $a1
; CHECK-NEXT:    addi.d $a2, $a2, 1
; CHECK-NEXT:    st.w $a0, $a3, 0
; CHECK-NEXT:    bltu $a2, $a4, .LBB17_1
; CHECK-NEXT:  # %bb.2: # %bb7
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test15:
; NORMV:       # %bb.0: # %entry
; NORMV-NEXT:    addi.d $a2, $a2, -1
; NORMV-NEXT:    ori $a4, $zero, 256
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB17_1: # %bb2
; NORMV-NEXT:    # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    andi $a0, $a0, 1234
; NORMV-NEXT:    add.d $a0, $a0, $a1
; NORMV-NEXT:    addi.d $a2, $a2, 1
; NORMV-NEXT:    st.w $a0, $a3, 0
; NORMV-NEXT:    bltu $a2, $a4, .LBB17_1
; NORMV-NEXT:  # %bb.2: # %bb7
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    ret
entry:
  br label %bb2

bb2:                                              ; preds = %bb2, %entry
  %i1 = phi i64 [ %arg1, %entry ], [ %i5, %bb2 ]
  %i2 = phi i64 [ %arg3, %entry ], [ %i3, %bb2 ]
  %i3 = add i64 %i2, 1
  %i4 = and i64 %i1, 1234
  %i5 = add i64 %i4, %arg2
  %i8 = trunc i64 %i5 to i32
  store i32 %i8, ptr %arg4
  %i6 = icmp ugt i64 %i2, 255
  br i1 %i6, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  %i7 = trunc i64 %i5 to i32
  ret i32 %i7
}

define signext i32 @bug(i32 signext %x) {
; CHECK-LABEL: bug:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    beqz $a0, .LBB18_2
; CHECK-NEXT:  # %bb.1: # %if.end
; CHECK-NEXT:    bstrpick.d $a1, $a0, 31, 16
; CHECK-NEXT:    sltui $a1, $a1, 1
; CHECK-NEXT:    slli.d $a2, $a0, 16
; CHECK-NEXT:    masknez $a0, $a0, $a1
; CHECK-NEXT:    maskeqz $a2, $a2, $a1
; CHECK-NEXT:    or $a0, $a2, $a0
; CHECK-NEXT:    ori $a2, $zero, 32
; CHECK-NEXT:    masknez $a2, $a2, $a1
; CHECK-NEXT:    ori $a3, $zero, 16
; CHECK-NEXT:    maskeqz $a1, $a3, $a1
; CHECK-NEXT:    or $a1, $a1, $a2
; CHECK-NEXT:    bstrpick.d $a2, $a0, 31, 24
; CHECK-NEXT:    sltui $a2, $a2, 1
; CHECK-NEXT:    slli.d $a3, $a0, 8
; CHECK-NEXT:    addi.d $a4, $a1, -8
; CHECK-NEXT:    masknez $a0, $a0, $a2
; CHECK-NEXT:    maskeqz $a3, $a3, $a2
; CHECK-NEXT:    or $a0, $a3, $a0
; CHECK-NEXT:    masknez $a1, $a1, $a2
; CHECK-NEXT:    maskeqz $a2, $a4, $a2
; CHECK-NEXT:    or $a1, $a2, $a1
; CHECK-NEXT:    bstrpick.d $a2, $a0, 31, 28
; CHECK-NEXT:    sltui $a2, $a2, 1
; CHECK-NEXT:    slli.d $a3, $a0, 4
; CHECK-NEXT:    addi.d $a4, $a1, -4
; CHECK-NEXT:    masknez $a0, $a0, $a2
; CHECK-NEXT:    maskeqz $a3, $a3, $a2
; CHECK-NEXT:    or $a0, $a3, $a0
; CHECK-NEXT:    masknez $a1, $a1, $a2
; CHECK-NEXT:    maskeqz $a2, $a4, $a2
; CHECK-NEXT:    or $a1, $a2, $a1
; CHECK-NEXT:    bstrpick.d $a2, $a0, 31, 30
; CHECK-NEXT:    sltui $a2, $a2, 1
; CHECK-NEXT:    slli.d $a3, $a0, 2
; CHECK-NEXT:    addi.d $a4, $a1, -2
; CHECK-NEXT:    masknez $a0, $a0, $a2
; CHECK-NEXT:    maskeqz $a3, $a3, $a2
; CHECK-NEXT:    or $a0, $a3, $a0
; CHECK-NEXT:    addi.w $a0, $a0, 0
; CHECK-NEXT:    masknez $a1, $a1, $a2
; CHECK-NEXT:    maskeqz $a2, $a4, $a2
; CHECK-NEXT:    or $a1, $a2, $a1
; CHECK-NEXT:    nor $a0, $a0, $zero
; CHECK-NEXT:    srli.d $a0, $a0, 31
; CHECK-NEXT:    add.w $a0, $a1, $a0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB18_2:
; CHECK-NEXT:    move $a0, $zero
; CHECK-NEXT:    ret
;
; NORMV-LABEL: bug:
; NORMV:       # %bb.0: # %entry
; NORMV-NEXT:    beqz $a0, .LBB18_2
; NORMV-NEXT:  # %bb.1: # %if.end
; NORMV-NEXT:    bstrpick.d $a1, $a0, 31, 16
; NORMV-NEXT:    sltui $a1, $a1, 1
; NORMV-NEXT:    slli.d $a2, $a0, 16
; NORMV-NEXT:    masknez $a0, $a0, $a1
; NORMV-NEXT:    maskeqz $a2, $a2, $a1
; NORMV-NEXT:    or $a0, $a2, $a0
; NORMV-NEXT:    ori $a2, $zero, 32
; NORMV-NEXT:    masknez $a2, $a2, $a1
; NORMV-NEXT:    ori $a3, $zero, 16
; NORMV-NEXT:    maskeqz $a1, $a3, $a1
; NORMV-NEXT:    or $a1, $a1, $a2
; NORMV-NEXT:    bstrpick.d $a2, $a0, 31, 24
; NORMV-NEXT:    sltui $a2, $a2, 1
; NORMV-NEXT:    slli.d $a3, $a0, 8
; NORMV-NEXT:    addi.d $a4, $a1, -8
; NORMV-NEXT:    masknez $a0, $a0, $a2
; NORMV-NEXT:    maskeqz $a3, $a3, $a2
; NORMV-NEXT:    or $a0, $a3, $a0
; NORMV-NEXT:    masknez $a1, $a1, $a2
; NORMV-NEXT:    maskeqz $a2, $a4, $a2
; NORMV-NEXT:    or $a1, $a2, $a1
; NORMV-NEXT:    bstrpick.d $a2, $a0, 31, 28
; NORMV-NEXT:    sltui $a2, $a2, 1
; NORMV-NEXT:    slli.d $a3, $a0, 4
; NORMV-NEXT:    addi.d $a4, $a1, -4
; NORMV-NEXT:    masknez $a0, $a0, $a2
; NORMV-NEXT:    maskeqz $a3, $a3, $a2
; NORMV-NEXT:    or $a0, $a3, $a0
; NORMV-NEXT:    masknez $a1, $a1, $a2
; NORMV-NEXT:    maskeqz $a2, $a4, $a2
; NORMV-NEXT:    or $a1, $a2, $a1
; NORMV-NEXT:    bstrpick.d $a2, $a0, 31, 30
; NORMV-NEXT:    sltui $a2, $a2, 1
; NORMV-NEXT:    slli.d $a3, $a0, 2
; NORMV-NEXT:    addi.d $a4, $a1, -2
; NORMV-NEXT:    masknez $a0, $a0, $a2
; NORMV-NEXT:    maskeqz $a3, $a3, $a2
; NORMV-NEXT:    or $a0, $a3, $a0
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    masknez $a1, $a1, $a2
; NORMV-NEXT:    maskeqz $a2, $a4, $a2
; NORMV-NEXT:    or $a1, $a2, $a1
; NORMV-NEXT:    nor $a0, $a0, $zero
; NORMV-NEXT:    srli.d $a0, $a0, 31
; NORMV-NEXT:    add.d $a0, $a1, $a0
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    ret
; NORMV-NEXT:  .LBB18_2:
; NORMV-NEXT:    move $a0, $zero
; NORMV-NEXT:    ret
entry:
  %tobool.not = icmp eq i32 %x, 0
  br i1 %tobool.not, label %cleanup, label %if.end

if.end:                                           ; preds = %entry
  %tobool1.not = icmp ult i32 %x, 65536
  %shl = shl i32 %x, 16
  %spec.select = select i1 %tobool1.not, i32 %shl, i32 %x
  %spec.select43 = select i1 %tobool1.not, i32 16, i32 32
  %tobool5.not = icmp ult i32 %spec.select, 16777216
  %shl7 = shl i32 %spec.select, 8
  %sub8 = add nsw i32 %spec.select43, -8
  %x.addr.1 = select i1 %tobool5.not, i32 %shl7, i32 %spec.select
  %r.1 = select i1 %tobool5.not, i32 %sub8, i32 %spec.select43
  %tobool11.not = icmp ult i32 %x.addr.1, 268435456
  %shl13 = shl i32 %x.addr.1, 4
  %sub14 = add nsw i32 %r.1, -4
  %x.addr.2 = select i1 %tobool11.not, i32 %shl13, i32 %x.addr.1
  %r.2 = select i1 %tobool11.not, i32 %sub14, i32 %r.1
  %tobool17.not = icmp ult i32 %x.addr.2, 1073741824
  %shl19 = shl i32 %x.addr.2, 2
  %sub20 = add nsw i32 %r.2, -2
  %x.addr.3 = select i1 %tobool17.not, i32 %shl19, i32 %x.addr.2
  %r.3 = select i1 %tobool17.not, i32 %sub20, i32 %r.2
  %x.addr.3.lobit = ashr i32 %x.addr.3, 31
  %x.addr.3.lobit.not = xor i32 %x.addr.3.lobit, -1
  %r.4 = add nsw i32 %r.3, %x.addr.3.lobit.not
  br label %cleanup

cleanup:                                          ; preds = %entry, %if.end
  %retval.0 = phi i32 [ %r.4, %if.end ], [ 0, %entry ]
  ret i32 %retval.0
}

define void @test16(i32 signext %arg, i32 signext %arg1) nounwind {
; CHECK-LABEL: test16:
; CHECK:       # %bb.0: # %bb
; CHECK-NEXT:    addi.d $sp, $sp, -32
; CHECK-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $fp, $sp, 16 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $s0, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    move $fp, $a1
; CHECK-NEXT:    bl %plt(bar)
; CHECK-NEXT:    move $s0, $a0
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB19_1: # %bb2
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    move $a0, $s0
; CHECK-NEXT:    bl %plt(bar)
; CHECK-NEXT:    sll.w $s0, $s0, $fp
; CHECK-NEXT:    bnez $a0, .LBB19_1
; CHECK-NEXT:  # %bb.2: # %bb7
; CHECK-NEXT:    ld.d $s0, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $fp, $sp, 16 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 32
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test16:
; NORMV:       # %bb.0: # %bb
; NORMV-NEXT:    addi.d $sp, $sp, -32
; NORMV-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $fp, $sp, 16 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $s0, $sp, 8 # 8-byte Folded Spill
; NORMV-NEXT:    move $fp, $a1
; NORMV-NEXT:    bl %plt(bar)
; NORMV-NEXT:    move $s0, $a0
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB19_1: # %bb2
; NORMV-NEXT:    # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    addi.w $a0, $s0, 0
; NORMV-NEXT:    bl %plt(bar)
; NORMV-NEXT:    sll.w $s0, $s0, $fp
; NORMV-NEXT:    bnez $a0, .LBB19_1
; NORMV-NEXT:  # %bb.2: # %bb7
; NORMV-NEXT:    ld.d $s0, $sp, 8 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $fp, $sp, 16 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; NORMV-NEXT:    addi.d $sp, $sp, 32
; NORMV-NEXT:    ret
bb:
  %i = call signext i32 @bar(i32 signext %arg)
  br label %bb2

bb2:                                              ; preds = %bb2, %bb
  %i3 = phi i32 [ %i, %bb ], [ %i5, %bb2 ]
  %i4 = tail call signext i32 @bar(i32 signext %i3)
  %i5 = shl i32 %i3, %arg1
  %i6 = icmp eq i32 %i4, 0
  br i1 %i6, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  ret void
}

define void @test17(i32 signext %arg, i32 signext %arg1) nounwind {
; CHECK-LABEL: test17:
; CHECK:       # %bb.0: # %bb
; CHECK-NEXT:    addi.d $sp, $sp, -32
; CHECK-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $fp, $sp, 16 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $s0, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    move $fp, $a1
; CHECK-NEXT:    bl %plt(bat)
; CHECK-NEXT:    move $s0, $a0
; CHECK-NEXT:    .p2align 4, , 16
; CHECK-NEXT:  .LBB20_1: # %bb2
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    move $a0, $s0
; CHECK-NEXT:    bl %plt(bar)
; CHECK-NEXT:    sll.w $s0, $s0, $fp
; CHECK-NEXT:    bnez $a0, .LBB20_1
; CHECK-NEXT:  # %bb.2: # %bb7
; CHECK-NEXT:    ld.d $s0, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $fp, $sp, 16 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 32
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test17:
; NORMV:       # %bb.0: # %bb
; NORMV-NEXT:    addi.d $sp, $sp, -32
; NORMV-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $fp, $sp, 16 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $s0, $sp, 8 # 8-byte Folded Spill
; NORMV-NEXT:    move $fp, $a1
; NORMV-NEXT:    bl %plt(bat)
; NORMV-NEXT:    move $s0, $a0
; NORMV-NEXT:    .p2align 4, , 16
; NORMV-NEXT:  .LBB20_1: # %bb2
; NORMV-NEXT:    # =>This Inner Loop Header: Depth=1
; NORMV-NEXT:    addi.w $a0, $s0, 0
; NORMV-NEXT:    bl %plt(bar)
; NORMV-NEXT:    sll.w $s0, $s0, $fp
; NORMV-NEXT:    bnez $a0, .LBB20_1
; NORMV-NEXT:  # %bb.2: # %bb7
; NORMV-NEXT:    ld.d $s0, $sp, 8 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $fp, $sp, 16 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; NORMV-NEXT:    addi.d $sp, $sp, 32
; NORMV-NEXT:    ret
bb:
  %i = call zeroext i16 @bat(i32 signext %arg)
  %zext = zext i16 %i to i32
  br label %bb2

bb2:                                              ; preds = %bb2, %bb
  %i3 = phi i32 [ %zext, %bb ], [ %i5, %bb2 ]
  %i4 = tail call signext i32 @bar(i32 signext %i3)
  %i5 = shl i32 %i3, %arg1
  %i6 = icmp eq i32 %i4, 0
  br i1 %i6, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  ret void
}
declare zeroext i16 @bat(i32 signext)

define signext i32 @sextw_sh2add(i1 zeroext %0, ptr %1, i32 signext %2, i32 signext %3, i32 signext %4) {
; CHECK-LABEL: sextw_sh2add:
; CHECK:       # %bb.0:
; CHECK-NEXT:    alsl.w $a2, $a2, $a3, 2
; CHECK-NEXT:    beqz $a0, .LBB21_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    st.w $a2, $a1, 0
; CHECK-NEXT:  .LBB21_2:
; CHECK-NEXT:    add.w $a0, $a2, $a4
; CHECK-NEXT:    ret
;
; NORMV-LABEL: sextw_sh2add:
; NORMV:       # %bb.0:
; NORMV-NEXT:    alsl.w $a2, $a2, $a3, 2
; NORMV-NEXT:    beqz $a0, .LBB21_2
; NORMV-NEXT:  # %bb.1:
; NORMV-NEXT:    st.w $a2, $a1, 0
; NORMV-NEXT:  .LBB21_2:
; NORMV-NEXT:    add.d $a0, $a2, $a4
; NORMV-NEXT:    addi.w $a0, $a0, 0
; NORMV-NEXT:    ret
  %6 = shl i32 %2, 2
  %7 = add i32 %6, %3
  br i1 %0, label %8, label %9

8:                                                ; preds = %5
  store i32 %7, ptr %1, align 4
  br label %9

9:                                                ; preds = %5, %8
  %10 = add i32 %7, %4
  ret i32 %10
}

define signext i32 @test19(i64 %arg, i1 zeroext %c1, i1 zeroext %c2, ptr %p) nounwind {
; CHECK-LABEL: test19:
; CHECK:       # %bb.0: # %bb
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; CHECK-NEXT:    ori $a0, $zero, 35
; CHECK-NEXT:    lu32i.d $a0, 1
; CHECK-NEXT:    maskeqz $fp, $a0, $a1
; CHECK-NEXT:    st.d $fp, $a3, 0
; CHECK-NEXT:    beqz $a2, .LBB22_2
; CHECK-NEXT:  # %bb.1: # %bb2
; CHECK-NEXT:    move $a0, $zero
; CHECK-NEXT:    bl %plt(bar)
; CHECK-NEXT:    move $fp, $a0
; CHECK-NEXT:  .LBB22_2: # %bb7
; CHECK-NEXT:    bl %plt(side_effect)
; CHECK-NEXT:    addi.w $a0, $fp, 0
; CHECK-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
;
; NORMV-LABEL: test19:
; NORMV:       # %bb.0: # %bb
; NORMV-NEXT:    addi.d $sp, $sp, -16
; NORMV-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; NORMV-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; NORMV-NEXT:    ori $a0, $zero, 35
; NORMV-NEXT:    lu32i.d $a0, 1
; NORMV-NEXT:    maskeqz $fp, $a0, $a1
; NORMV-NEXT:    st.d $fp, $a3, 0
; NORMV-NEXT:    beqz $a2, .LBB22_2
; NORMV-NEXT:  # %bb.1: # %bb2
; NORMV-NEXT:    move $a0, $zero
; NORMV-NEXT:    bl %plt(bar)
; NORMV-NEXT:    move $fp, $a0
; NORMV-NEXT:  .LBB22_2: # %bb7
; NORMV-NEXT:    bl %plt(side_effect)
; NORMV-NEXT:    addi.w $a0, $fp, 0
; NORMV-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; NORMV-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; NORMV-NEXT:    addi.d $sp, $sp, 16
; NORMV-NEXT:    ret
bb:
  %sel = select i1 %c1, i64 4294967331, i64 0
  store i64 %sel, ptr %p, align 8
  br i1 %c2, label %bb2, label %bb7

bb2:                                              ; preds = %bb2, %bb
  %i4 = call signext i32 @bar(i32 0)
  %i4.sext = sext i32 %i4 to i64
  br label %bb7

bb7:                                              ; preds = %bb2
  %phi = phi i64 [ %sel, %bb ], [ %i4.sext, %bb2 ]
  %trunc = trunc i64 %phi to i32
  call void @side_effect()
  ret i32 %trunc
}

 declare void @side_effect(i64)
