; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.2,+gfni | FileCheck %s --check-prefixes=GFNISSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX1OR2,GFNIAVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX1OR2,GFNIAVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX512,GFNIAVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX512,GFNIAVX512BW

;
; 128 Bit Vector Rotates
;

define <16 x i8> @var_rotl_v16i8(<16 x i8> %a, <16 x i8> %amt) nounwind {
; GFNISSE-LABEL: var_rotl_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    movdqa %xmm0, %xmm1
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; GFNISSE-NEXT:    por %xmm0, %xmm3
; GFNISSE-NEXT:    psllw $5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; GFNISSE-NEXT:    por %xmm0, %xmm3
; GFNISSE-NEXT:    paddb %xmm2, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm3
; GFNISSE-NEXT:    paddb %xmm1, %xmm3
; GFNISSE-NEXT:    por %xmm0, %xmm3
; GFNISSE-NEXT:    paddb %xmm2, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: var_rotl_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm3
; GFNIAVX1OR2-NEXT:    vpor %xmm2, %xmm3, %xmm2
; GFNIAVX1OR2-NEXT:    vpsllw $5, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm3
; GFNIAVX1OR2-NEXT:    vpor %xmm2, %xmm3, %xmm2
; GFNIAVX1OR2-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; GFNIAVX1OR2-NEXT:    vpaddb %xmm0, %xmm0, %xmm3
; GFNIAVX1OR2-NEXT:    vpor %xmm2, %xmm3, %xmm2
; GFNIAVX1OR2-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_rotl_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpslld $8, %zmm0, %zmm2
; GFNIAVX512VL-NEXT:    vpord %zmm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm1
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsllvd %zmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpsrld $8, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; GFNIAVX512VL-NEXT:    vzeroupper
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_rotl_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm1
; GFNIAVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm1[8],xmm2[8],xmm1[9],xmm2[9],xmm1[10],xmm2[10],xmm1[11],xmm2[11],xmm1[12],xmm2[12],xmm1[13],xmm2[13],xmm1[14],xmm2[14],xmm1[15],xmm2[15]
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX512BW-NEXT:    vpsllvw %xmm2, %xmm3, %xmm2
; GFNIAVX512BW-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; GFNIAVX512BW-NEXT:    vpsllvw %xmm1, %xmm0, %xmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX512BW-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <16 x i8> @llvm.fshl.v16i8(<16 x i8> %a, <16 x i8> %a, <16 x i8> %amt)
  ret <16 x i8> %res
}
define <16 x i8> @var_rotr_v16i8(<16 x i8> %a, <16 x i8> %amt) nounwind {
; GFNISSE-LABEL: var_rotr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; GFNISSE-NEXT:    movdqa %xmm2, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; GFNISSE-NEXT:    por %xmm0, %xmm3
; GFNISSE-NEXT:    pxor %xmm0, %xmm0
; GFNISSE-NEXT:    psubb %xmm1, %xmm0
; GFNISSE-NEXT:    psllw $5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm1
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; GFNISSE-NEXT:    por %xmm1, %xmm3
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm1
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm3
; GFNISSE-NEXT:    paddb %xmm2, %xmm3
; GFNISSE-NEXT:    por %xmm1, %xmm3
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: var_rotr_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm3
; GFNIAVX1OR2-NEXT:    vpor %xmm2, %xmm3, %xmm2
; GFNIAVX1OR2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; GFNIAVX1OR2-NEXT:    vpsubb %xmm1, %xmm3, %xmm1
; GFNIAVX1OR2-NEXT:    vpsllw $5, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm3
; GFNIAVX1OR2-NEXT:    vpor %xmm2, %xmm3, %xmm2
; GFNIAVX1OR2-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; GFNIAVX1OR2-NEXT:    vpaddb %xmm0, %xmm0, %xmm3
; GFNIAVX1OR2-NEXT:    vpor %xmm2, %xmm3, %xmm2
; GFNIAVX1OR2-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_rotr_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpslld $8, %zmm0, %zmm2
; GFNIAVX512VL-NEXT:    vpord %zmm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm1
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; GFNIAVX512VL-NEXT:    vzeroupper
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_rotr_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm1
; GFNIAVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm1[8],xmm2[8],xmm1[9],xmm2[9],xmm1[10],xmm2[10],xmm1[11],xmm2[11],xmm1[12],xmm2[12],xmm1[13],xmm2[13],xmm1[14],xmm2[14],xmm1[15],xmm2[15]
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX512BW-NEXT:    vpsrlvw %xmm2, %xmm3, %xmm2
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; GFNIAVX512BW-NEXT:    vpsrlvw %xmm1, %xmm0, %xmm0
; GFNIAVX512BW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %res = call <16 x i8> @llvm.fshr.v16i8(<16 x i8> %a, <16 x i8> %a, <16 x i8> %amt)
  ret <16 x i8> %res
}

define <16 x i8> @splatvar_rotl_v16i8(<16 x i8> %a, <16 x i8> %amt) nounwind {
; GFNISSE-LABEL: splatvar_rotl_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; GFNISSE-NEXT:    psllw %xmm1, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psllw %xmm1, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX-LABEL: splatvar_rotl_v16i8:
; GFNIAVX:       # %bb.0:
; GFNIAVX-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX-NEXT:    vpsllw %xmm1, %xmm2, %xmm2
; GFNIAVX-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; GFNIAVX-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX-NEXT:    retq
  %splat = shufflevector <16 x i8> %amt, <16 x i8> undef, <16 x i32> zeroinitializer
  %res = call <16 x i8> @llvm.fshl.v16i8(<16 x i8> %a, <16 x i8> %a, <16 x i8> %splat)
  ret <16 x i8> %res
}

define <16 x i8> @splatvar_rotr_v16i8(<16 x i8> %a, <16 x i8> %amt) nounwind {
; GFNISSE-LABEL: splatvar_rotr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; GFNISSE-NEXT:    psrlw %xmm1, %xmm2
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; GFNISSE-NEXT:    pand %xmm3, %xmm2
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psrlw %xmm1, %xmm0
; GFNISSE-NEXT:    pand %xmm3, %xmm0
; GFNISSE-NEXT:    packuswb %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_rotr_v16i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; GFNIAVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_rotr_v16i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpbroadcastw {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; GFNIAVX2-NEXT:    vpand %xmm3, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_rotr_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; GFNIAVX512VL-NEXT:    vpand %xmm3, %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    vpand %xmm3, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_rotr_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX512BW-NEXT:    vinserti128 $1, %xmm0, %ymm2, %ymm0
; GFNIAVX512BW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX512BW-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <16 x i8> %amt, <16 x i8> undef, <16 x i32> zeroinitializer
  %res = call <16 x i8> @llvm.fshr.v16i8(<16 x i8> %a, <16 x i8> %a, <16 x i8> %splat)
  ret <16 x i8> %res
}

define <16 x i8> @constant_rotl_v16i8(<16 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_rotl_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm1
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNISSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1 # [1,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 # [1,2,4,8,16,32,64,128]
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: constant_rotl_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1OR2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1 # [1,128,64,32,16,8,4,2]
; GFNIAVX1OR2-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1OR2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [1,2,4,8,16,32,64,128]
; GFNIAVX1OR2-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_rotl_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1 # [1,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [1,2,4,8,16,32,64,128]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_rotl_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX512BW-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX512BW-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <16 x i8> @llvm.fshl.v16i8(<16 x i8> %a, <16 x i8> %a, <16 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <16 x i8> %res
}

define <16 x i8> @constant_rotr_v16i8(<16 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_rotr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm1
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNISSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1 # [1,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 # [1,2,4,8,16,32,64,128]
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: constant_rotr_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1OR2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1 # [1,128,64,32,16,8,4,2]
; GFNIAVX1OR2-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1OR2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [1,2,4,8,16,32,64,128]
; GFNIAVX1OR2-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_rotr_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1 # [1,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [1,2,4,8,16,32,64,128]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_rotr_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX512BW-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX512BW-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <16 x i8> @llvm.fshl.v16i8(<16 x i8> %a, <16 x i8> %a, <16 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <16 x i8> %res
}

define <16 x i8> @splatconstant_rotl_v16i8(<16 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_rotl_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: splatconstant_rotl_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_rotl_v16i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; GFNIAVX512-NEXT:    retq
  %res = call <16 x i8> @llvm.fshl.v16i8(<16 x i8> %a, <16 x i8> %a, <16 x i8> <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>)
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.fshl.v16i8(<16 x i8>, <16 x i8>, <16 x i8>)

define <16 x i8> @splatconstant_rotr_v16i8(<16 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_rotr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: splatconstant_rotr_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_rotr_v16i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; GFNIAVX512-NEXT:    retq
  %res = call <16 x i8> @llvm.fshr.v16i8(<16 x i8> %a, <16 x i8> %a, <16 x i8> <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>)
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.fshr.v16i8(<16 x i8>, <16 x i8>, <16 x i8>)

;
; 256 Bit Vector Rotates
;

define <32 x i8> @var_rotl_v32i8(<32 x i8> %a, <32 x i8> %amt) nounwind {
; GFNISSE-LABEL: var_rotl_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm2, %xmm4
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm5 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm5, %xmm0
; GFNISSE-NEXT:    pmovsxdq {{.*#+}} xmm6 = [16909320,16909320]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm7
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm6, %xmm7
; GFNISSE-NEXT:    por %xmm0, %xmm7
; GFNISSE-NEXT:    psllw $5, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm7, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm7 = [0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm7, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm8 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm9
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm9
; GFNISSE-NEXT:    por %xmm0, %xmm9
; GFNISSE-NEXT:    paddb %xmm4, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm9, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm9 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm0
; GFNISSE-NEXT:    movdqa %xmm2, %xmm10
; GFNISSE-NEXT:    paddb %xmm2, %xmm10
; GFNISSE-NEXT:    por %xmm0, %xmm10
; GFNISSE-NEXT:    paddb %xmm4, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm10, %xmm2
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm5, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm4
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm6, %xmm4
; GFNISSE-NEXT:    por %xmm0, %xmm4
; GFNISSE-NEXT:    psllw $5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm7, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm4
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm4
; GFNISSE-NEXT:    por %xmm0, %xmm4
; GFNISSE-NEXT:    paddb %xmm3, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm4
; GFNISSE-NEXT:    paddb %xmm1, %xmm4
; GFNISSE-NEXT:    por %xmm0, %xmm4
; GFNISSE-NEXT:    paddb %xmm3, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_rotl_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm3 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX1-NEXT:    # xmm3 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm3, %xmm2, %xmm4
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm5 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX1-NEXT:    # xmm5 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm2, %xmm6
; GFNIAVX1-NEXT:    vpor %xmm4, %xmm6, %xmm4
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm6
; GFNIAVX1-NEXT:    vpsllw $5, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpblendvb %xmm6, %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64]
; GFNIAVX1-NEXT:    # xmm4 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm2, %xmm7
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm8 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX1-NEXT:    # xmm8 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm2, %xmm9
; GFNIAVX1-NEXT:    vpor %xmm7, %xmm9, %xmm7
; GFNIAVX1-NEXT:    vpaddb %xmm6, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpblendvb %xmm6, %xmm7, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm7 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNIAVX1-NEXT:    # xmm7 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm2, %xmm9
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm10
; GFNIAVX1-NEXT:    vpor %xmm9, %xmm10, %xmm9
; GFNIAVX1-NEXT:    vpaddb %xmm6, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpblendvb %xmm6, %xmm9, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm3, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm0, %xmm5
; GFNIAVX1-NEXT:    vpor %xmm3, %xmm5, %xmm3
; GFNIAVX1-NEXT:    vpsllw $5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm0, %xmm4
; GFNIAVX1-NEXT:    vpor %xmm3, %xmm4, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm4
; GFNIAVX1-NEXT:    vpor %xmm3, %xmm4, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_rotl_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm3
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm3, %ymm2
; GFNIAVX2-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm3
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm3, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm3
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm3, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_rotl_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpor %ymm2, %ymm3, %ymm2
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpor %ymm2, %ymm3, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpor %ymm2, %ymm3, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_rotl_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %ymm1
; GFNIAVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15],ymm1[24],ymm2[24],ymm1[25],ymm2[25],ymm1[26],ymm2[26],ymm1[27],ymm2[27],ymm1[28],ymm2[28],ymm1[29],ymm2[29],ymm1[30],ymm2[30],ymm1[31],ymm2[31]
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512BW-NEXT:    vpsllvw %ymm3, %ymm4, %ymm3
; GFNIAVX512BW-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[16],ymm2[16],ymm1[17],ymm2[17],ymm1[18],ymm2[18],ymm1[19],ymm2[19],ymm1[20],ymm2[20],ymm1[21],ymm2[21],ymm1[22],ymm2[22],ymm1[23],ymm2[23]
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512BW-NEXT:    vpsllvw %ymm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <32 x i8> @llvm.fshl.v32i8(<32 x i8> %a, <32 x i8> %a, <32 x i8> %amt)
  ret <32 x i8> %res
}
define <32 x i8> @var_rotr_v32i8(<32 x i8> %a, <32 x i8> %amt) nounwind {
; GFNISSE-LABEL: var_rotr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm5
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm6 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm6, %xmm0
; GFNISSE-NEXT:    pmovsxdq {{.*#+}} xmm7 = [16909320,16909320]
; GFNISSE-NEXT:    movdqa %xmm5, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm7, %xmm8
; GFNISSE-NEXT:    por %xmm0, %xmm8
; GFNISSE-NEXT:    pxor %xmm4, %xmm4
; GFNISSE-NEXT:    pxor %xmm0, %xmm0
; GFNISSE-NEXT:    psubb %xmm2, %xmm0
; GFNISSE-NEXT:    psllw $5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm5
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm2 = [0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64]
; GFNISSE-NEXT:    movdqa %xmm5, %xmm9
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm2, %xmm9
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm8 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNISSE-NEXT:    movdqa %xmm5, %xmm10
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm10
; GFNISSE-NEXT:    por %xmm9, %xmm10
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm10, %xmm5
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm9 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNISSE-NEXT:    movdqa %xmm5, %xmm10
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm10
; GFNISSE-NEXT:    movdqa %xmm5, %xmm11
; GFNISSE-NEXT:    paddb %xmm5, %xmm11
; GFNISSE-NEXT:    por %xmm10, %xmm11
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm11, %xmm5
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm6, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm6
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm7, %xmm6
; GFNISSE-NEXT:    por %xmm0, %xmm6
; GFNISSE-NEXT:    psubb %xmm3, %xmm4
; GFNISSE-NEXT:    psllw $5, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm2, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm2
; GFNISSE-NEXT:    por %xmm0, %xmm2
; GFNISSE-NEXT:    paddb %xmm4, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    paddb %xmm1, %xmm2
; GFNISSE-NEXT:    por %xmm0, %xmm2
; GFNISSE-NEXT:    paddb %xmm4, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_rotr_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm3 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX1-NEXT:    # xmm3 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm3, %xmm2, %xmm4
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm5 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX1-NEXT:    # xmm5 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm2, %xmm6
; GFNIAVX1-NEXT:    vpor %xmm4, %xmm6, %xmm4
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm6
; GFNIAVX1-NEXT:    vpxor %xmm7, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpsubb %xmm6, %xmm7, %xmm6
; GFNIAVX1-NEXT:    vpsllw $5, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpblendvb %xmm6, %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64]
; GFNIAVX1-NEXT:    # xmm4 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm2, %xmm8
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm9 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX1-NEXT:    # xmm9 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm9, %xmm2, %xmm10
; GFNIAVX1-NEXT:    vpor %xmm8, %xmm10, %xmm8
; GFNIAVX1-NEXT:    vpaddb %xmm6, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpblendvb %xmm6, %xmm8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm8 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNIAVX1-NEXT:    # xmm8 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm2, %xmm10
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm11
; GFNIAVX1-NEXT:    vpor %xmm10, %xmm11, %xmm10
; GFNIAVX1-NEXT:    vpaddb %xmm6, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpblendvb %xmm6, %xmm10, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm3, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm0, %xmm5
; GFNIAVX1-NEXT:    vpor %xmm3, %xmm5, %xmm3
; GFNIAVX1-NEXT:    vpsubb %xmm1, %xmm7, %xmm1
; GFNIAVX1-NEXT:    vpsllw $5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm9, %xmm0, %xmm4
; GFNIAVX1-NEXT:    vpor %xmm3, %xmm4, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm4
; GFNIAVX1-NEXT:    vpor %xmm3, %xmm4, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_rotr_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm3
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm3, %ymm2
; GFNIAVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; GFNIAVX2-NEXT:    vpsubb %ymm1, %ymm3, %ymm1
; GFNIAVX2-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm3
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm3, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm3
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm3, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_rotr_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpor %ymm2, %ymm3, %ymm2
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpor %ymm2, %ymm3, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpor %ymm2, %ymm3, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_rotr_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %ymm1
; GFNIAVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15],ymm1[24],ymm2[24],ymm1[25],ymm2[25],ymm1[26],ymm2[26],ymm1[27],ymm2[27],ymm1[28],ymm2[28],ymm1[29],ymm2[29],ymm1[30],ymm2[30],ymm1[31],ymm2[31]
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512BW-NEXT:    vpsrlvw %ymm3, %ymm4, %ymm3
; GFNIAVX512BW-NEXT:    vpbroadcastw {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX512BW-NEXT:    vpand %ymm4, %ymm3, %ymm3
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[16],ymm2[16],ymm1[17],ymm2[17],ymm1[18],ymm2[18],ymm1[19],ymm2[19],ymm1[20],ymm2[20],ymm1[21],ymm2[21],ymm1[22],ymm2[22],ymm1[23],ymm2[23]
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512BW-NEXT:    vpsrlvw %ymm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpand %ymm4, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <32 x i8> @llvm.fshr.v32i8(<32 x i8> %a, <32 x i8> %a, <32 x i8> %amt)
  ret <32 x i8> %res
}

define <32 x i8> @splatvar_rotl_v32i8(<32 x i8> %a, <32 x i8> %amt) nounwind {
; GFNISSE-LABEL: splatvar_rotl_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; GFNISSE-NEXT:    movdqa %xmm0, %xmm3
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm0[8],xmm3[9],xmm0[9],xmm3[10],xmm0[10],xmm3[11],xmm0[11],xmm3[12],xmm0[12],xmm3[13],xmm0[13],xmm3[14],xmm0[14],xmm3[15],xmm0[15]
; GFNISSE-NEXT:    psllw %xmm2, %xmm3
; GFNISSE-NEXT:    psrlw $8, %xmm3
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psllw %xmm2, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm3, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm3
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; GFNISSE-NEXT:    psllw %xmm2, %xmm3
; GFNISSE-NEXT:    psrlw $8, %xmm3
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psllw %xmm2, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm3, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_rotl_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsllw %xmm1, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsllw %xmm1, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsllw %xmm1, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_rotl_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX2-NEXT:    vpsllw %xmm1, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatvar_rotl_v32i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX512-NEXT:    vpsllw %xmm1, %ymm2, %ymm2
; GFNIAVX512-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; GFNIAVX512-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX512-NEXT:    retq
  %splat = shufflevector <32 x i8> %amt, <32 x i8> undef, <32 x i32> zeroinitializer
  %res = call <32 x i8> @llvm.fshl.v32i8(<32 x i8> %a, <32 x i8> %a, <32 x i8> %splat)
  ret <32 x i8> %res
}

define <32 x i8> @splatvar_rotr_v32i8(<32 x i8> %a, <32 x i8> %amt) nounwind {
; GFNISSE-LABEL: splatvar_rotr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; GFNISSE-NEXT:    movdqa %xmm0, %xmm3
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm0[8],xmm3[9],xmm0[9],xmm3[10],xmm0[10],xmm3[11],xmm0[11],xmm3[12],xmm0[12],xmm3[13],xmm0[13],xmm3[14],xmm0[14],xmm3[15],xmm0[15]
; GFNISSE-NEXT:    psrlw %xmm2, %xmm3
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; GFNISSE-NEXT:    pand %xmm4, %xmm3
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psrlw %xmm2, %xmm0
; GFNISSE-NEXT:    pand %xmm4, %xmm0
; GFNISSE-NEXT:    packuswb %xmm3, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm3
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; GFNISSE-NEXT:    psrlw %xmm2, %xmm3
; GFNISSE-NEXT:    pand %xmm4, %xmm3
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psrlw %xmm2, %xmm1
; GFNISSE-NEXT:    pand %xmm4, %xmm1
; GFNISSE-NEXT:    packuswb %xmm3, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_rotr_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_rotr_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpand %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_rotr_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpand %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_rotr_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512BW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX512BW-NEXT:    vpsrlw %xmm1, %ymm2, %ymm2
; GFNIAVX512BW-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX512BW-NEXT:    vpand %ymm3, %ymm2, %ymm2
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512BW-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpand %ymm3, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <32 x i8> %amt, <32 x i8> undef, <32 x i32> zeroinitializer
  %res = call <32 x i8> @llvm.fshr.v32i8(<32 x i8> %a, <32 x i8> %a, <32 x i8> %splat)
  ret <32 x i8> %res
}

define <32 x i8> @constant_rotl_v32i8(<32 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_rotl_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm3 = [1,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    pmullw %xmm3, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm4 = [1,2,4,8,16,32,64,128]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm2, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm1[8],xmm2[9],xmm1[9],xmm2[10],xmm1[10],xmm2[11],xmm1[11],xmm2[12],xmm1[12],xmm2[13],xmm1[13],xmm2[14],xmm1[14],xmm2[15],xmm1[15]
; GFNISSE-NEXT:    pmullw %xmm3, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm2, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_rotl_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm3 = [1,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm4 = [1,2,4,8,16,32,64,128]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm2, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_rotl_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm1 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_rotl_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm1 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_rotl_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} ymm1 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; GFNIAVX512BW-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <32 x i8> @llvm.fshl.v32i8(<32 x i8> %a, <32 x i8> %a, <32 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <32 x i8> %res
}

define <32 x i8> @constant_rotr_v32i8(<32 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_rotr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm3 = [1,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    pmullw %xmm3, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm4 = [1,2,4,8,16,32,64,128]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm2, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm1[8],xmm2[9],xmm1[9],xmm2[10],xmm1[10],xmm2[11],xmm1[11],xmm2[12],xmm1[12],xmm2[13],xmm1[13],xmm2[14],xmm1[14],xmm2[15],xmm1[15]
; GFNISSE-NEXT:    pmullw %xmm3, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm2, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_rotr_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm3 = [1,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm4 = [1,2,4,8,16,32,64,128]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm2, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_rotr_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm1 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_rotr_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm1 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_rotr_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} ymm1 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; GFNIAVX512BW-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <32 x i8> @llvm.fshl.v32i8(<32 x i8> %a, <32 x i8> %a, <32 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <32 x i8> %res
}

define <32 x i8> @splatconstant_rotl_v32i8(<32 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_rotl_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm2 = [8,4,2,1,128,64,32,16,8,4,2,1,128,64,32,16]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm2, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm2, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: splatconstant_rotl_v32i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_rotl_v32i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; GFNIAVX512-NEXT:    retq
  %res = call <32 x i8> @llvm.fshl.v32i8(<32 x i8> %a, <32 x i8> %a, <32 x i8> <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>)
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.fshl.v32i8(<32 x i8>, <32 x i8>, <32 x i8>)

define <32 x i8> @splatconstant_rotr_v32i8(<32 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_rotr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm2 = [32,16,8,4,2,1,128,64,32,16,8,4,2,1,128,64]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm2, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm2, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: splatconstant_rotr_v32i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_rotr_v32i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; GFNIAVX512-NEXT:    retq
  %res = call <32 x i8> @llvm.fshr.v32i8(<32 x i8> %a, <32 x i8> %a, <32 x i8> <i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6>)
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.fshr.v32i8(<32 x i8>, <32 x i8>, <32 x i8>)

;
; 512 Bit Vector Rotates
;

define <64 x i8> @var_rotl_v64i8(<64 x i8> %a, <64 x i8> %amt) nounwind {
; GFNISSE-LABEL: var_rotl_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm4, %xmm8
; GFNISSE-NEXT:    movdqa %xmm0, %xmm4
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm9 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm0
; GFNISSE-NEXT:    pmovsxdq {{.*#+}} xmm10 = [16909320,16909320]
; GFNISSE-NEXT:    movdqa %xmm4, %xmm11
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm11
; GFNISSE-NEXT:    por %xmm0, %xmm11
; GFNISSE-NEXT:    psllw $5, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm11, %xmm4
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm11 = [0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64]
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm12 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNISSE-NEXT:    movdqa %xmm4, %xmm13
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm12, %xmm13
; GFNISSE-NEXT:    por %xmm0, %xmm13
; GFNISSE-NEXT:    paddb %xmm8, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm13, %xmm4
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm13 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm13, %xmm0
; GFNISSE-NEXT:    movdqa %xmm4, %xmm14
; GFNISSE-NEXT:    paddb %xmm4, %xmm14
; GFNISSE-NEXT:    por %xmm0, %xmm14
; GFNISSE-NEXT:    paddb %xmm8, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm14, %xmm4
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm8
; GFNISSE-NEXT:    por %xmm0, %xmm8
; GFNISSE-NEXT:    psllw $5, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm12, %xmm8
; GFNISSE-NEXT:    por %xmm0, %xmm8
; GFNISSE-NEXT:    paddb %xmm5, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm13, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm8
; GFNISSE-NEXT:    paddb %xmm1, %xmm8
; GFNISSE-NEXT:    por %xmm0, %xmm8
; GFNISSE-NEXT:    paddb %xmm5, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm0
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm5
; GFNISSE-NEXT:    por %xmm0, %xmm5
; GFNISSE-NEXT:    psllw $5, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm0
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm12, %xmm5
; GFNISSE-NEXT:    por %xmm0, %xmm5
; GFNISSE-NEXT:    paddb %xmm6, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm13, %xmm0
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    paddb %xmm2, %xmm5
; GFNISSE-NEXT:    por %xmm0, %xmm5
; GFNISSE-NEXT:    paddb %xmm6, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm0
; GFNISSE-NEXT:    movdqa %xmm3, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm5
; GFNISSE-NEXT:    por %xmm0, %xmm5
; GFNISSE-NEXT:    psllw $5, %xmm7
; GFNISSE-NEXT:    movdqa %xmm7, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm0
; GFNISSE-NEXT:    movdqa %xmm3, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm12, %xmm5
; GFNISSE-NEXT:    por %xmm0, %xmm5
; GFNISSE-NEXT:    paddb %xmm7, %xmm7
; GFNISSE-NEXT:    movdqa %xmm7, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm13, %xmm0
; GFNISSE-NEXT:    movdqa %xmm3, %xmm5
; GFNISSE-NEXT:    paddb %xmm3, %xmm5
; GFNISSE-NEXT:    por %xmm0, %xmm5
; GFNISSE-NEXT:    paddb %xmm7, %xmm7
; GFNISSE-NEXT:    movdqa %xmm7, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_rotl_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX1-NEXT:    # xmm4 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm6, %xmm7
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm5 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX1-NEXT:    # xmm5 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm6, %xmm8
; GFNIAVX1-NEXT:    vpor %xmm7, %xmm8, %xmm7
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm8
; GFNIAVX1-NEXT:    vpsllw $5, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vpblendvb %xmm8, %xmm7, %xmm6, %xmm9
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm6 = [0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64]
; GFNIAVX1-NEXT:    # xmm6 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm9, %xmm10
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm7 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX1-NEXT:    # xmm7 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm9, %xmm11
; GFNIAVX1-NEXT:    vpor %xmm10, %xmm11, %xmm10
; GFNIAVX1-NEXT:    vpaddb %xmm8, %xmm8, %xmm11
; GFNIAVX1-NEXT:    vpblendvb %xmm11, %xmm10, %xmm9, %xmm9
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm8 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNIAVX1-NEXT:    # xmm8 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm9, %xmm10
; GFNIAVX1-NEXT:    vpaddb %xmm9, %xmm9, %xmm12
; GFNIAVX1-NEXT:    vpor %xmm10, %xmm12, %xmm10
; GFNIAVX1-NEXT:    vpaddb %xmm11, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vpblendvb %xmm11, %xmm10, %xmm9, %xmm9
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm0, %xmm10
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm0, %xmm11
; GFNIAVX1-NEXT:    vpor %xmm10, %xmm11, %xmm10
; GFNIAVX1-NEXT:    vpsllw $5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm10, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm0, %xmm10
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm0, %xmm11
; GFNIAVX1-NEXT:    vpor %xmm10, %xmm11, %xmm10
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm10, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm0, %xmm10
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm11
; GFNIAVX1-NEXT:    vpor %xmm10, %xmm11, %xmm10
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm10, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm2, %xmm9
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm2, %xmm10
; GFNIAVX1-NEXT:    vpor %xmm9, %xmm10, %xmm9
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm3, %xmm10
; GFNIAVX1-NEXT:    vpsllw $5, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vpblendvb %xmm10, %xmm9, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm2, %xmm9
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm2, %xmm11
; GFNIAVX1-NEXT:    vpor %xmm9, %xmm11, %xmm9
; GFNIAVX1-NEXT:    vpaddb %xmm10, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vpblendvb %xmm10, %xmm9, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm2, %xmm9
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm11
; GFNIAVX1-NEXT:    vpor %xmm9, %xmm11, %xmm9
; GFNIAVX1-NEXT:    vpaddb %xmm10, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vpblendvb %xmm10, %xmm9, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm1, %xmm5
; GFNIAVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; GFNIAVX1-NEXT:    vpsllw $5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm1, %xmm5
; GFNIAVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm5
; GFNIAVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_rotl_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm0, %ymm5
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm0, %ymm7
; GFNIAVX2-NEXT:    vpor %ymm5, %ymm7, %ymm5
; GFNIAVX2-NEXT:    vpsllw $5, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm5, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm0, %ymm7
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm8 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm8, %ymm0, %ymm9
; GFNIAVX2-NEXT:    vpor %ymm7, %ymm9, %ymm7
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm7, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm7 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm7, %ymm0, %ymm9
; GFNIAVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm10
; GFNIAVX2-NEXT:    vpor %ymm9, %ymm10, %ymm9
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm9, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm1, %ymm4
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm4, %ymm2
; GFNIAVX2-NEXT:    vpsllw $5, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm8, %ymm1, %ymm4
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm4, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm7, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm4
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm4, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_rotl_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm3, %ymm2, %ymm4
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm2, %ymm6
; GFNIAVX512VL-NEXT:    vpor %ymm4, %ymm6, %ymm4
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm6
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm6, %ymm6
; GFNIAVX512VL-NEXT:    vpblendvb %ymm6, %ymm4, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm2, %ymm7
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm8 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm8, %ymm2, %ymm9
; GFNIAVX512VL-NEXT:    vpor %ymm7, %ymm9, %ymm7
; GFNIAVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; GFNIAVX512VL-NEXT:    vpblendvb %ymm6, %ymm7, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm7 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm7, %ymm2, %ymm9
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm10
; GFNIAVX512VL-NEXT:    vpor %ymm9, %ymm10, %ymm9
; GFNIAVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; GFNIAVX512VL-NEXT:    vpblendvb %ymm6, %ymm9, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm3, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm0, %ymm5
; GFNIAVX512VL-NEXT:    vpor %ymm3, %ymm5, %ymm3
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm8, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpor %ymm3, %ymm4, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm7, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpor %ymm3, %ymm4, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_rotl_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[12],zmm2[12],zmm1[13],zmm2[13],zmm1[14],zmm2[14],zmm1[15],zmm2[15],zmm1[24],zmm2[24],zmm1[25],zmm2[25],zmm1[26],zmm2[26],zmm1[27],zmm2[27],zmm1[28],zmm2[28],zmm1[29],zmm2[29],zmm1[30],zmm2[30],zmm1[31],zmm2[31],zmm1[40],zmm2[40],zmm1[41],zmm2[41],zmm1[42],zmm2[42],zmm1[43],zmm2[43],zmm1[44],zmm2[44],zmm1[45],zmm2[45],zmm1[46],zmm2[46],zmm1[47],zmm2[47],zmm1[56],zmm2[56],zmm1[57],zmm2[57],zmm1[58],zmm2[58],zmm1[59],zmm2[59],zmm1[60],zmm2[60],zmm1[61],zmm2[61],zmm1[62],zmm2[62],zmm1[63],zmm2[63]
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm4 = zmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63]
; GFNIAVX512BW-NEXT:    vpsllvw %zmm3, %zmm4, %zmm3
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm3, %zmm3
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[16],zmm2[16],zmm1[17],zmm2[17],zmm1[18],zmm2[18],zmm1[19],zmm2[19],zmm1[20],zmm2[20],zmm1[21],zmm2[21],zmm1[22],zmm2[22],zmm1[23],zmm2[23],zmm1[32],zmm2[32],zmm1[33],zmm2[33],zmm1[34],zmm2[34],zmm1[35],zmm2[35],zmm1[36],zmm2[36],zmm1[37],zmm2[37],zmm1[38],zmm2[38],zmm1[39],zmm2[39],zmm1[48],zmm2[48],zmm1[49],zmm2[49],zmm1[50],zmm2[50],zmm1[51],zmm2[51],zmm1[52],zmm2[52],zmm1[53],zmm2[53],zmm1[54],zmm2[54],zmm1[55],zmm2[55]
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55]
; GFNIAVX512BW-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm3, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %a, <64 x i8> %a, <64 x i8> %amt)
  ret <64 x i8> %res
}
define <64 x i8> @var_rotr_v64i8(<64 x i8> %a, <64 x i8> %amt) nounwind {
; GFNISSE-LABEL: var_rotr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm9
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm10 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm0
; GFNISSE-NEXT:    pmovsxdq {{.*#+}} xmm11 = [16909320,16909320]
; GFNISSE-NEXT:    movdqa %xmm9, %xmm12
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm12
; GFNISSE-NEXT:    por %xmm0, %xmm12
; GFNISSE-NEXT:    pxor %xmm8, %xmm8
; GFNISSE-NEXT:    pxor %xmm0, %xmm0
; GFNISSE-NEXT:    psubb %xmm4, %xmm0
; GFNISSE-NEXT:    psllw $5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm12, %xmm9
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm4 = [0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64]
; GFNISSE-NEXT:    movdqa %xmm9, %xmm13
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm13
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm12 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNISSE-NEXT:    movdqa %xmm9, %xmm14
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm12, %xmm14
; GFNISSE-NEXT:    por %xmm13, %xmm14
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm14, %xmm9
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm13 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNISSE-NEXT:    movdqa %xmm9, %xmm14
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm13, %xmm14
; GFNISSE-NEXT:    movdqa %xmm9, %xmm15
; GFNISSE-NEXT:    paddb %xmm9, %xmm15
; GFNISSE-NEXT:    por %xmm14, %xmm15
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm15, %xmm9
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm14
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm14
; GFNISSE-NEXT:    por %xmm0, %xmm14
; GFNISSE-NEXT:    pxor %xmm0, %xmm0
; GFNISSE-NEXT:    psubb %xmm5, %xmm0
; GFNISSE-NEXT:    psllw $5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm14, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm5
; GFNISSE-NEXT:    movdqa %xmm1, %xmm14
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm12, %xmm14
; GFNISSE-NEXT:    por %xmm5, %xmm14
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm14, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm13, %xmm5
; GFNISSE-NEXT:    movdqa %xmm1, %xmm14
; GFNISSE-NEXT:    paddb %xmm1, %xmm14
; GFNISSE-NEXT:    por %xmm5, %xmm14
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm14, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm0
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm5
; GFNISSE-NEXT:    por %xmm0, %xmm5
; GFNISSE-NEXT:    pxor %xmm0, %xmm0
; GFNISSE-NEXT:    psubb %xmm6, %xmm0
; GFNISSE-NEXT:    psllw $5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm5
; GFNISSE-NEXT:    movdqa %xmm2, %xmm6
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm12, %xmm6
; GFNISSE-NEXT:    por %xmm5, %xmm6
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm13, %xmm5
; GFNISSE-NEXT:    movdqa %xmm2, %xmm6
; GFNISSE-NEXT:    paddb %xmm2, %xmm6
; GFNISSE-NEXT:    por %xmm5, %xmm6
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm0
; GFNISSE-NEXT:    movdqa %xmm3, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm5
; GFNISSE-NEXT:    por %xmm0, %xmm5
; GFNISSE-NEXT:    psubb %xmm7, %xmm8
; GFNISSE-NEXT:    psllw $5, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm0
; GFNISSE-NEXT:    movdqa %xmm3, %xmm4
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm12, %xmm4
; GFNISSE-NEXT:    por %xmm0, %xmm4
; GFNISSE-NEXT:    paddb %xmm8, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm13, %xmm0
; GFNISSE-NEXT:    movdqa %xmm3, %xmm4
; GFNISSE-NEXT:    paddb %xmm3, %xmm4
; GFNISSE-NEXT:    por %xmm0, %xmm4
; GFNISSE-NEXT:    paddb %xmm8, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm3
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_rotr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm7
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX1-NEXT:    # xmm4 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm7, %xmm6
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm5 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX1-NEXT:    # xmm5 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm7, %xmm8
; GFNIAVX1-NEXT:    vpor %xmm6, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm9
; GFNIAVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsubb %xmm9, %xmm6, %xmm9
; GFNIAVX1-NEXT:    vpsllw $5, %xmm9, %xmm9
; GFNIAVX1-NEXT:    vpblendvb %xmm9, %xmm8, %xmm7, %xmm10
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm7 = [0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64]
; GFNIAVX1-NEXT:    # xmm7 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm10, %xmm11
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm8 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX1-NEXT:    # xmm8 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm10, %xmm12
; GFNIAVX1-NEXT:    vpor %xmm11, %xmm12, %xmm11
; GFNIAVX1-NEXT:    vpaddb %xmm9, %xmm9, %xmm12
; GFNIAVX1-NEXT:    vpblendvb %xmm12, %xmm11, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm9 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNIAVX1-NEXT:    # xmm9 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm9, %xmm10, %xmm11
; GFNIAVX1-NEXT:    vpaddb %xmm10, %xmm10, %xmm13
; GFNIAVX1-NEXT:    vpor %xmm11, %xmm13, %xmm11
; GFNIAVX1-NEXT:    vpaddb %xmm12, %xmm12, %xmm12
; GFNIAVX1-NEXT:    vpblendvb %xmm12, %xmm11, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm0, %xmm11
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm0, %xmm12
; GFNIAVX1-NEXT:    vpor %xmm11, %xmm12, %xmm11
; GFNIAVX1-NEXT:    vpsubb %xmm2, %xmm6, %xmm2
; GFNIAVX1-NEXT:    vpsllw $5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm11, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm0, %xmm11
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm0, %xmm12
; GFNIAVX1-NEXT:    vpor %xmm11, %xmm12, %xmm11
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm11, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm9, %xmm0, %xmm11
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm12
; GFNIAVX1-NEXT:    vpor %xmm11, %xmm12, %xmm11
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm11, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm2, %xmm10
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm2, %xmm11
; GFNIAVX1-NEXT:    vpor %xmm10, %xmm11, %xmm10
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm3, %xmm11
; GFNIAVX1-NEXT:    vpsubb %xmm11, %xmm6, %xmm11
; GFNIAVX1-NEXT:    vpsllw $5, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vpblendvb %xmm11, %xmm10, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm2, %xmm10
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm2, %xmm12
; GFNIAVX1-NEXT:    vpor %xmm10, %xmm12, %xmm10
; GFNIAVX1-NEXT:    vpaddb %xmm11, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vpblendvb %xmm11, %xmm10, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm9, %xmm2, %xmm10
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm12
; GFNIAVX1-NEXT:    vpor %xmm10, %xmm12, %xmm10
; GFNIAVX1-NEXT:    vpaddb %xmm11, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vpblendvb %xmm11, %xmm10, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm1, %xmm5
; GFNIAVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; GFNIAVX1-NEXT:    vpsubb %xmm3, %xmm6, %xmm3
; GFNIAVX1-NEXT:    vpsllw $5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm1, %xmm5
; GFNIAVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm9, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm5
; GFNIAVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_rotr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm0, %ymm5
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm0, %ymm7
; GFNIAVX2-NEXT:    vpor %ymm5, %ymm7, %ymm5
; GFNIAVX2-NEXT:    vpxor %xmm7, %xmm7, %xmm7
; GFNIAVX2-NEXT:    vpsubb %ymm2, %ymm7, %ymm2
; GFNIAVX2-NEXT:    vpsllw $5, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm5, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm0, %ymm8
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm9 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm9, %ymm0, %ymm10
; GFNIAVX2-NEXT:    vpor %ymm8, %ymm10, %ymm8
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm8 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm8, %ymm0, %ymm10
; GFNIAVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm11
; GFNIAVX2-NEXT:    vpor %ymm10, %ymm11, %ymm10
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm10, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm1, %ymm4
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm4, %ymm2
; GFNIAVX2-NEXT:    vpsubb %ymm3, %ymm7, %ymm3
; GFNIAVX2-NEXT:    vpsllw $5, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm9, %ymm1, %ymm4
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm4, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm8, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm4
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm4, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_rotr_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm3, %ymm2, %ymm4
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm2, %ymm6
; GFNIAVX512VL-NEXT:    vpor %ymm4, %ymm6, %ymm4
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm6
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm6, %ymm6
; GFNIAVX512VL-NEXT:    vpblendvb %ymm6, %ymm4, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm2, %ymm7
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm8 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm8, %ymm2, %ymm9
; GFNIAVX512VL-NEXT:    vpor %ymm7, %ymm9, %ymm7
; GFNIAVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; GFNIAVX512VL-NEXT:    vpblendvb %ymm6, %ymm7, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm7 = [1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm7, %ymm2, %ymm9
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm10 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm10, %ymm2, %ymm11
; GFNIAVX512VL-NEXT:    vpor %ymm9, %ymm11, %ymm9
; GFNIAVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; GFNIAVX512VL-NEXT:    vpblendvb %ymm6, %ymm9, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm3, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm0, %ymm5
; GFNIAVX512VL-NEXT:    vpor %ymm3, %ymm5, %ymm3
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm8, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpor %ymm3, %ymm4, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm7, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm10, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpor %ymm3, %ymm4, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_rotr_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[12],zmm2[12],zmm1[13],zmm2[13],zmm1[14],zmm2[14],zmm1[15],zmm2[15],zmm1[24],zmm2[24],zmm1[25],zmm2[25],zmm1[26],zmm2[26],zmm1[27],zmm2[27],zmm1[28],zmm2[28],zmm1[29],zmm2[29],zmm1[30],zmm2[30],zmm1[31],zmm2[31],zmm1[40],zmm2[40],zmm1[41],zmm2[41],zmm1[42],zmm2[42],zmm1[43],zmm2[43],zmm1[44],zmm2[44],zmm1[45],zmm2[45],zmm1[46],zmm2[46],zmm1[47],zmm2[47],zmm1[56],zmm2[56],zmm1[57],zmm2[57],zmm1[58],zmm2[58],zmm1[59],zmm2[59],zmm1[60],zmm2[60],zmm1[61],zmm2[61],zmm1[62],zmm2[62],zmm1[63],zmm2[63]
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm4 = zmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63]
; GFNIAVX512BW-NEXT:    vpsrlvw %zmm3, %zmm4, %zmm3
; GFNIAVX512BW-NEXT:    vpbroadcastw {{.*#+}} zmm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX512BW-NEXT:    vpandq %zmm4, %zmm3, %zmm3
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[16],zmm2[16],zmm1[17],zmm2[17],zmm1[18],zmm2[18],zmm1[19],zmm2[19],zmm1[20],zmm2[20],zmm1[21],zmm2[21],zmm1[22],zmm2[22],zmm1[23],zmm2[23],zmm1[32],zmm2[32],zmm1[33],zmm2[33],zmm1[34],zmm2[34],zmm1[35],zmm2[35],zmm1[36],zmm2[36],zmm1[37],zmm2[37],zmm1[38],zmm2[38],zmm1[39],zmm2[39],zmm1[48],zmm2[48],zmm1[49],zmm2[49],zmm1[50],zmm2[50],zmm1[51],zmm2[51],zmm1[52],zmm2[52],zmm1[53],zmm2[53],zmm1[54],zmm2[54],zmm1[55],zmm2[55]
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55]
; GFNIAVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpandq %zmm4, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm3, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <64 x i8> @llvm.fshr.v64i8(<64 x i8> %a, <64 x i8> %a, <64 x i8> %amt)
  ret <64 x i8> %res
}

define <64 x i8> @splatvar_rotl_v64i8(<64 x i8> %a, <64 x i8> %amt) nounwind {
; GFNISSE-LABEL: splatvar_rotl_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4
; GFNISSE-NEXT:    movdqa %xmm0, %xmm5
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; GFNISSE-NEXT:    psllw %xmm4, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psllw %xmm4, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm5, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm5
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm1[8],xmm5[9],xmm1[9],xmm5[10],xmm1[10],xmm5[11],xmm1[11],xmm5[12],xmm1[12],xmm5[13],xmm1[13],xmm5[14],xmm1[14],xmm5[15],xmm1[15]
; GFNISSE-NEXT:    psllw %xmm4, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psllw %xmm4, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm5, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm2[8],xmm5[9],xmm2[9],xmm5[10],xmm2[10],xmm5[11],xmm2[11],xmm5[12],xmm2[12],xmm5[13],xmm2[13],xmm5[14],xmm2[14],xmm5[15],xmm2[15]
; GFNISSE-NEXT:    psllw %xmm4, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psllw %xmm4, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    packuswb %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm5
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm3[8],xmm5[9],xmm3[9],xmm5[10],xmm3[10],xmm5[11],xmm3[11],xmm5[12],xmm3[12],xmm5[13],xmm3[13],xmm5[14],xmm3[14],xmm5[15],xmm3[15]
; GFNISSE-NEXT:    psllw %xmm4, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psllw %xmm4, %xmm3
; GFNISSE-NEXT:    psrlw $8, %xmm3
; GFNISSE-NEXT:    packuswb %xmm5, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_rotl_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_rotl_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsllw %xmm2, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpsllw %xmm2, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpsllw %xmm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_rotl_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpsllw %xmm1, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpsllw %xmm1, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpackuswb %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpsllw %xmm1, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_rotl_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm2 = zmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63]
; GFNIAVX512BW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX512BW-NEXT:    vpsllw %xmm1, %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55]
; GFNIAVX512BW-NEXT:    vpsllw %xmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm2, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <64 x i8> %amt, <64 x i8> undef, <64 x i32> zeroinitializer
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %a, <64 x i8> %a, <64 x i8> %splat)
  ret <64 x i8> %res
}

define <64 x i8> @splatvar_rotr_v64i8(<64 x i8> %a, <64 x i8> %amt) nounwind {
; GFNISSE-LABEL: splatvar_rotr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4
; GFNISSE-NEXT:    movdqa %xmm0, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; GFNISSE-NEXT:    psrlw %xmm4, %xmm6
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; GFNISSE-NEXT:    pand %xmm5, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psrlw %xmm4, %xmm0
; GFNISSE-NEXT:    pand %xmm5, %xmm0
; GFNISSE-NEXT:    packuswb %xmm6, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm1[8],xmm6[9],xmm1[9],xmm6[10],xmm1[10],xmm6[11],xmm1[11],xmm6[12],xmm1[12],xmm6[13],xmm1[13],xmm6[14],xmm1[14],xmm6[15],xmm1[15]
; GFNISSE-NEXT:    psrlw %xmm4, %xmm6
; GFNISSE-NEXT:    pand %xmm5, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psrlw %xmm4, %xmm1
; GFNISSE-NEXT:    pand %xmm5, %xmm1
; GFNISSE-NEXT:    packuswb %xmm6, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm2[8],xmm6[9],xmm2[9],xmm6[10],xmm2[10],xmm6[11],xmm2[11],xmm6[12],xmm2[12],xmm6[13],xmm2[13],xmm6[14],xmm2[14],xmm6[15],xmm2[15]
; GFNISSE-NEXT:    psrlw %xmm4, %xmm6
; GFNISSE-NEXT:    pand %xmm5, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psrlw %xmm4, %xmm2
; GFNISSE-NEXT:    pand %xmm5, %xmm2
; GFNISSE-NEXT:    packuswb %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm3[8],xmm6[9],xmm3[9],xmm6[10],xmm3[10],xmm6[11],xmm3[11],xmm6[12],xmm3[12],xmm6[13],xmm3[13],xmm6[14],xmm3[14],xmm6[15],xmm3[15]
; GFNISSE-NEXT:    psrlw %xmm4, %xmm6
; GFNISSE-NEXT:    pand %xmm5, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psrlw %xmm4, %xmm3
; GFNISSE-NEXT:    pand %xmm5, %xmm3
; GFNISSE-NEXT:    packuswb %xmm6, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_rotr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_rotr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpbroadcastw {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX2-NEXT:    vpand %ymm4, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpand %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpand %ymm4, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpand %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_rotr_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX512VL-NEXT:    vpand %ymm4, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpand %ymm4, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpackuswb %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpand %ymm4, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpand %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_rotr_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm2 = zmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63]
; GFNIAVX512BW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX512BW-NEXT:    vpsrlw %xmm1, %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpbroadcastw {{.*#+}} zmm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX512BW-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55]
; GFNIAVX512BW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpandq %zmm3, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm2, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <64 x i8> %amt, <64 x i8> undef, <64 x i32> zeroinitializer
  %res = call <64 x i8> @llvm.fshr.v64i8(<64 x i8> %a, <64 x i8> %a, <64 x i8> %splat)
  ret <64 x i8> %res
}

define <64 x i8> @constant_rotl_v64i8(<64 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_rotl_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm4 = [1,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm5 = [1,2,4,8,16,32,64,128]
; GFNISSE-NEXT:    pmullw %xmm5, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm6, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm1[8],xmm6[9],xmm1[9],xmm6[10],xmm1[10],xmm6[11],xmm1[11],xmm6[12],xmm1[12],xmm6[13],xmm1[13],xmm6[14],xmm1[14],xmm6[15],xmm1[15]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmullw %xmm5, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm6, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm2[8],xmm6[9],xmm2[9],xmm6[10],xmm2[10],xmm6[11],xmm2[11],xmm6[12],xmm2[12],xmm6[13],xmm2[13],xmm6[14],xmm2[14],xmm6[15],xmm2[15]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmullw %xmm5, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    packuswb %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm3[8],xmm6[9],xmm3[9],xmm6[10],xmm3[10],xmm6[11],xmm3[11],xmm6[12],xmm3[12],xmm6[13],xmm3[13],xmm6[14],xmm3[14],xmm6[15],xmm3[15]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmullw %xmm5, %xmm3
; GFNISSE-NEXT:    psrlw $8, %xmm3
; GFNISSE-NEXT:    packuswb %xmm6, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_rotl_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm4 = [1,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm5 = [1,2,4,8,16,32,64,128]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_rotl_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX2-NEXT:    # ymm4 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmullw %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpmullw %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_rotl_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    # ymm3 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX512VL-NEXT:    # ymm4 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmullw %ymm4, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpackuswb %ymm2, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpmullw %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_rotl_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm1 = zmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %a, <64 x i8> %a, <64 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <64 x i8> %res
}

define <64 x i8> @constant_rotr_v64i8(<64 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_rotr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm4 = [1,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm5 = [1,2,4,8,16,32,64,128]
; GFNISSE-NEXT:    pmullw %xmm5, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm6, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm1[8],xmm6[9],xmm1[9],xmm6[10],xmm1[10],xmm6[11],xmm1[11],xmm6[12],xmm1[12],xmm6[13],xmm1[13],xmm6[14],xmm1[14],xmm6[15],xmm1[15]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmullw %xmm5, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm6, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm2[8],xmm6[9],xmm2[9],xmm6[10],xmm2[10],xmm6[11],xmm2[11],xmm6[12],xmm2[12],xmm6[13],xmm2[13],xmm6[14],xmm2[14],xmm6[15],xmm2[15]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmullw %xmm5, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    packuswb %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm3[8],xmm6[9],xmm3[9],xmm6[10],xmm3[10],xmm6[11],xmm3[11],xmm6[12],xmm3[12],xmm6[13],xmm3[13],xmm6[14],xmm3[14],xmm6[15],xmm3[15]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pmullw %xmm5, %xmm3
; GFNISSE-NEXT:    psrlw $8, %xmm3
; GFNISSE-NEXT:    packuswb %xmm6, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_rotr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm4 = [1,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm5 = [1,2,4,8,16,32,64,128]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_rotr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX2-NEXT:    # ymm4 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmullw %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpmullw %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_rotr_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    # ymm3 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX512VL-NEXT:    # ymm4 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmullw %ymm4, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpackuswb %ymm2, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpmullw %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_rotr_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm1 = zmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %a, <64 x i8> %a, <64 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <64 x i8> %res
}

define <64 x i8> @splatconstant_rotl_v64i8(<64 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_rotl_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm4 = [64,32,16,8,4,2,1,128,64,32,16,8,4,2,1,128]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm1
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatconstant_rotl_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [64,32,16,8,4,2,1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2,1,128]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatconstant_rotl_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [64,32,16,8,4,2,1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2,1,128]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_rotl_v64i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; GFNIAVX512-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %a, <64 x i8> %a, <64 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>)
  ret <64 x i8> %res
}
declare <64 x i8> @llvm.fshl.v64i8(<64 x i8>, <64 x i8>, <64 x i8>)

define <64 x i8> @splatconstant_rotr_v64i8(<64 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_rotr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm4 = [2,1,128,64,32,16,8,4,2,1,128,64,32,16,8,4]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm1
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatconstant_rotr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [2,1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2,1,128,64,32,16,8,4]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatconstant_rotr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [2,1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2,1,128,64,32,16,8,4]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_rotr_v64i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; GFNIAVX512-NEXT:    retq
  %res = call <64 x i8> @llvm.fshr.v64i8(<64 x i8> %a, <64 x i8> %a, <64 x i8> <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>)
  ret <64 x i8> %res
}
declare <64 x i8> @llvm.fshr.v64i8(<64 x i8>, <64 x i8>, <64 x i8>)
