// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1200 -show-encoding %s | FileCheck --check-prefix=GFX12 %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1200 -show-encoding %s 2>&1 | FileCheck --check-prefixes=GFX12-ERR --implicit-check-not=error: %s

buffer_load_b32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_b32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_b32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_b32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_b32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_b32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b32 v5, off, s[8:11], s3 offset:8388607 lds
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b64 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b64 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b64 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b64 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b64 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b64 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b64 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b64 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b64 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b64 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_b64 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_b64 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b96 v[253:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0xfd,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b96 v[5:7], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b96 v[5:7], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b96 v[5:7], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b96 v[5:7], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b96 v[5:7], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b96 v[5:7], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b96 v[5:7], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b96 v[5:7], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b96 v[5:7], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_b96 v[5:7], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_b96 v[5:7], off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b128 v[252:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0xfc,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b128 v[5:8], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b128 v[5:8], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b128 v[5:8], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b128 v[5:8], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b128 v[5:8], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b128 v[5:8], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b128 v[5:8], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b128 v[5:8], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_b128 v[5:8], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_b128 v[5:8], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_b128 v[5:8], off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_b16 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_b16 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_b16 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_b16 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_b16 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_b16 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_b16 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_b16 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_b16 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_b16 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_d16_b16 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_d16_b16 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_x v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_x v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_x v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_x v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_x v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_x v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_x v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_x v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_x v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_x v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_x v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_x v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xy v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xy v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xy v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xy v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xy v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xy v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_xy v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_xy v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_xy v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_xy v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xy v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xy v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyz v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyz v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyz v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_xyz v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_xyz v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_xyz v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_xyz v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyz v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyzw v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyzw v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyzw v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_format_xyzw v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyzw v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_b16 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_b16 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_b16 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_b16 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_b16 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_b16 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_b16 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_b16 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_b16 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_b16 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_b16 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_format_x v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_format_x v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_format_x v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_format_x v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x09,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_format_x v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x09,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_format_x v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_format_x v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_format_x v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_format_x v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_format_x v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_format_x v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_i8 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_i8 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_i8 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_i8 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_i8 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_i8 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_i8 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_i8 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_i8 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_i8 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_i8 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_u8 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_u8 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_u8 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_u8 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_u8 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_u8 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_u8 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_u8 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_u8 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_hi_u8 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_u8 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_i8 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_i8 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_i8 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_i8 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_i8 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_i8 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_i8 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_i8 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_i8 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_i8 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_d16_i8 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_d16_i8 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_u8 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_u8 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_u8 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_u8 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_u8 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_u8 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_u8 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_u8 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_u8 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_d16_u8 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_d16_u8 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_d16_u8 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_x v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_x v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x00,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_x v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x00,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_x v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x00,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_x v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_x v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_x v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_x v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_x v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_x v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_x v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x00,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_format_x v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x00,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_format_x v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_x v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_x v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_format_x v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_x v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_x v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_x v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_x v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x00,0x00,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_x v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x00,0x00,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xy v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x00,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xy v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x00,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xy v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x00,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xy v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xy v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xy v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_xy v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_xy v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_xy v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_xy v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x00,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_format_xy v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x00,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_format_xy v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x00,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x40,0x00,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xy v[5:7], off, s[8:11], s3 offset:8388607 glc slc dlc tfe
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyz v[253:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x00,0xc4,0xfd,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyz v[5:7], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x00,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyz v[5:7], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x00,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyz v[5:7], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyz v[5:7], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyz v[5:7], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_xyz v[5:7], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_xyz v[5:7], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_xyz v[5:7], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_xyz v[5:7], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x00,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_format_xyz v[5:7], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x00,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_format_xyz v[5:7], off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x00,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x80,0x00,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyzw v[252:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x00,0xc4,0xfc,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyzw v[5:8], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x00,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyzw v[5:8], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x00,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyzw v[5:8], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyzw v[5:8], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyzw v[5:8], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_xyzw v[5:8], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_xyzw v[5:8], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_xyzw v[5:8], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_format_xyzw v[5:8], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x00,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_format_xyzw v[5:8], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x00,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x00,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x00,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0xc0,0x00,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i8 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i8 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i8 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i8 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i8 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i8 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i8 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_i8 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_i8 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_i8 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_i8 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_i8 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_i8 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_i8 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_i8 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_i8 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_i8 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_i8 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_i8 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_i8 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i8 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i16 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i16 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i16 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i16 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i16 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i16 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i16 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_i16 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_i16 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_i16 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_i16 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_i16 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_i16 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_i16 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_i16 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_i16 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_i16 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_i16 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_i16 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_i16 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_i16 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u8 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u8 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u8 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u8 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u8 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u8 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u8 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_u8 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_u8 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_u8 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_u8 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_u8 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_u8 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_u8 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_u8 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_u8 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_u8 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_u8 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_u8 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_u8 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u8 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u16 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u16 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u16 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u16 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u16 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u16 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u16 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_u16 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_u16 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_u16 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_load_u16 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_u16 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_u16 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_u16 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_u16 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_u16 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_u16 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_u16 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_u16 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_u16 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_load_u16 v5, off, s[8:11], s3 offset:8388607 th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b8 v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b8 v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b8 v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b8 v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b8 v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b8 v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b8 v1, off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b8 v1, off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b8 v1, off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b8 v1, off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b8 v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_b8 v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_b8 v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_b8 v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_b8 v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_b8 v1, off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b8 v1, off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b8 v1, off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b8 v1, off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b8 v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b8 v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b16 v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b16 v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b16 v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b16 v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b16 v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b16 v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b16 v1, off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b16 v1, off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b16 v1, off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b16 v1, off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b16 v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_b16 v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_b16 v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_b16 v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_b16 v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_b16 v1, off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b16 v1, off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b16 v1, off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b16 v1, off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b16 v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b16 v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b32 v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b32 v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b32 v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b32 v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b32 v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b32 v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b32 v1, off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b32 v1, off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b32 v1, off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b32 v1, off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b32 v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_b32 v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_b32 v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_b32 v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_b32 v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_b32 v1, off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b32 v1, off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b32 v1, off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b32 v1, off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b32 v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b32 v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b64 v[254:255], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0xfe,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b64 v[1:2], off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b64 v[1:2], off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b64 v[1:2], off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b64 v[1:2], off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b64 v[1:2], off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b64 v[1:2], off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b64 v[1:2], off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b64 v[1:2], off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b64 v[1:2], v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_b64 v[1:2], v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_b64 v[1:2], off, s[12:15], s4
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b96 v[253:255], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0xfd,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b96 v[1:3], off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b96 v[1:3], off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b96 v[1:3], off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b96 v[1:3], off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b96 v[1:3], off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b96 v[1:3], off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b96 v[1:3], off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b96 v[1:3], off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b96 v[1:3], v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_b96 v[1:3], v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_b96 v[1:3], off, s[12:15], s4
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b128 v[252:255], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0xfc,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b128 v[1:4], off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b128 v[1:4], off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b128 v[1:4], off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b128 v[1:4], off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b128 v[1:4], off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b128 v[1:4], off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b128 v[1:4], off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b128 v[1:4], off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_b128 v[1:4], v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_b128 v[1:4], v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_b128 v[1:4], off, s[12:15], s4
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_x v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_x v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_x v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_x v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_x v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_x v1, off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_x v1, off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_x v1, off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_x v1, off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_x v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_x v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_x v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xy v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xy v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xy v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xy v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xy v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xy v1, off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_xy v1, off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_xy v1, off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_xy v1, off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_xy v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xy v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xy v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyz v[254:255], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0xfe,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyz v[1:2], off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyz v[1:2], off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_xyz v[1:2], off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_xyz v[1:2], off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_xyz v[1:2], off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_xyz v[1:2], v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyz v[1:2], v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyzw v[254:255], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0xfe,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyzw v[1:2], off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyzw v[1:2], off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_format_xyzw v[1:2], v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyzw v[1:2], v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b8 v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b8 v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b8 v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b8 v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b8 v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b8 v1, off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_hi_b8 v1, off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_hi_b8 v1, off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_hi_b8 v1, off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_hi_b8 v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b8 v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b16 v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b16 v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b16 v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b16 v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b16 v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b16 v1, off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_hi_b16 v1, off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_hi_b16 v1, off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_hi_b16 v1, off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_hi_b16 v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b16 v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_format_x v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_format_x v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_format_x v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_format_x v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_format_x v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_format_x v1, off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_hi_format_x v1, off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_hi_format_x v1, off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_hi_format_x v1, off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_d16_hi_format_x v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_format_x v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_x v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_x v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x01,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_x v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x01,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_x v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x01,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_x v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_x v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_x v1, off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_x v1, off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_x v1, off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_x v1, off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_x v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x00,0x01,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_format_x v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x00,0x01,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_format_x v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x00,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_x v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x00,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_x v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x00,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_format_x v1, off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_x v1, off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_x v1, off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_x v1, off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_x v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0x00,0x01,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_x v1, off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0x00,0x01,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xy v[254:255], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x01,0xc4,0xfe,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xy v[1:2], off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x01,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xy v[1:2], off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x01,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xy v[1:2], off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xy v[1:2], off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xy v[1:2], off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_xy v[1:2], off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_xy v[1:2], off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_xy v[1:2], off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_xy v[1:2], v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x40,0x01,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_format_xy v[1:2], v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x40,0x01,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_format_xy v[1:2], off, s[12:15], s4
// GFX12: encoding: [0x04,0x40,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x40,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x40,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0x40,0x01,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0x40,0x01,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyz v[253:255], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x01,0xc4,0xfd,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyz v[1:3], off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x01,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyz v[1:3], off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x01,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyz v[1:3], off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyz v[1:3], off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyz v[1:3], off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_xyz v[1:3], off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_xyz v[1:3], off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_xyz v[1:3], off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_xyz v[1:3], v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x80,0x01,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_format_xyz v[1:3], v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x80,0x01,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_format_xyz v[1:3], off, s[12:15], s4
// GFX12: encoding: [0x04,0x80,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x80,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x80,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0x80,0x01,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0x80,0x01,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyzw v[252:255], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x01,0xc4,0xfc,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyzw v[1:4], off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x01,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyzw v[1:4], off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x01,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyzw v[1:4], off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyzw v[1:4], off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyzw v[1:4], off, s[12:15], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_xyzw v[1:4], off, s[12:15], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_xyzw v[1:4], off, s[12:15], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_xyzw v[1:4], off, s[12:15], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_store_format_xyzw v[1:4], v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x01,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_format_xyzw v[1:4], v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x01,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4
// GFX12: encoding: [0x04,0xc0,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0xc0,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0xc0,0x01,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:8388607 th:TH_STORE_NT_HT scope:SCOPE_DEV
// GFX12: encoding: [0x04,0xc0,0x01,0xc4,0x01,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:8388607 th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x04,0xc0,0x01,0xc4,0x01,0x18,0xbc,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_f16 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x16,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_f16 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x16,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_f16 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x16,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_f16 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x16,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_f16 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x16,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_f16 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x16,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_f16 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x16,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_f16 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x16,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_f16 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x16,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_pk_add_f16 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x16,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_pk_add_f16 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x16,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_pk_add_f16 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x16,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_f16 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x40,0x16,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_f16 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x16,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_f16 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_pk_add_f16 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_pk_add_f16 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_pk_add_f16 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_pk_add_f16 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_pk_add_f16 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_pk_add_f16 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_pk_add_f16 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_pk_add_bf16 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x16,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_bf16 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x16,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_bf16 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x16,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_bf16 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x16,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_bf16 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x16,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_bf16 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x16,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_bf16 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x16,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_bf16 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x16,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_bf16 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x16,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_pk_add_bf16 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x16,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_pk_add_bf16 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x16,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_pk_add_bf16 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x16,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_bf16 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x80,0x16,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_bf16 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x16,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_pk_add_bf16 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_pk_add_bf16 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_pk_add_bf16 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_pk_add_bf16 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_pk_add_bf16 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_pk_add_bf16 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_pk_add_bf16 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_pk_add_bf16 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x15,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_f32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x15,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_f32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x15,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_f32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x15,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_f32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x15,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_f32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x15,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_f32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_add_f32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_add_f32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_add_f32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_add_f32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x15,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_add_f32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x15,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_add_f32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x15,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x15,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x15,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x15,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x80,0x15,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x15,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:8388607 glc slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_add_u32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_add_u32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_add_u32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_add_u32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u64 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u64 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u64 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u64 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u64 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_add_u64 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_add_u64 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_add_u64 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_add_u64 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u64 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_and_b32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_and_b32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_and_b32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_and_b32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b64 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b64 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b64 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b64 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b64 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_and_b64 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_and_b64 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_and_b64 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_and_b64 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b64 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b32 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b32 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b32 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_cmpswap_b32 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b32 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b64 v[252:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0xfc,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b64 v[5:8], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b64 v[5:8], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_cmpswap_b64 v[5:8], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b64 v[5:8], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v255, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0xff,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v255, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0xff,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v255, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0xff,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v255, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[12:15], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x18,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[12:15], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x18,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[12:15], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x18,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[12:15], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[96:99], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0xc0,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[96:99], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0xc0,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[96:99], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0xc0,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[96:99], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s101 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x65,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s101 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x65,0xc0,0x0d,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s101 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x65,0xc0,0x0d,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s101 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], m0 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7d,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], m0 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x7d,0xc0,0x0d,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], m0 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x7d,0xc0,0x0d,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], m0 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], 0 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], 0 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], 0 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], 0 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], -1 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], -1 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], -1 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], -1 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], 0.5 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], 0.5 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], 0.5 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], 0.5 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], -4.0 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], -4.0 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], -4.0 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], -4.0 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, v0, s[8:11], s3 idxen offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, v0, s[8:11], s3 idxen offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x94,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, v0, s[8:11], s3 idxen offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0xe8,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, v0, s[8:11], s3 idxen offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, v0, s[8:11], s3 offen offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, v0, s[8:11], s3 offen offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x94,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, v0, s[8:11], s3 offen offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0xe8,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, v0, s[8:11], s3 offen offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x94,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0xe8,0x00,0x00,0x00,0x00,0x00

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:0 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:0 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x94,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:0 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0xe8,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:0 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:7 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:7 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x94,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:7 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0xe8,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:7 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:8388607 glc slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:8388607 glc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_clamp_u32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cond_sub_u32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cond_sub_u32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x14,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cond_sub_u32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x14,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cond_sub_u32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x14,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cond_sub_u32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cond_sub_u32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cond_sub_u32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cond_sub_u32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cond_sub_u32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cond_sub_u32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cond_sub_u32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x14,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_cond_sub_u32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x14,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_cond_sub_u32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_cond_sub_u32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_cond_sub_u32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_cond_sub_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x14,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cond_sub_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x00,0x14,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cond_sub_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x00,0x14,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cond_sub_u32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cond_sub_u32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cond_sub_u32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_cond_sub_u32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_dec_u32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_dec_u32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_dec_u32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_dec_u32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u64 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u64 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u64 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_dec_u64 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_dec_u64 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_dec_u64 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_dec_u64 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u64 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_inc_u32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_inc_u32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_inc_u32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_inc_u32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u64 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u64 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u64 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_inc_u64 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_inc_u64 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_inc_u64 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_inc_u64 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u64 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_num_f32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_num_f32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_num_f32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_num_f32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_num_f32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_num_f32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_num_f32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_num_f32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_num_f32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_num_f32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_num_f32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_max_num_f32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_max_num_f32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_max_num_f32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_max_num_f32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_max_num_f32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_num_f32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_num_f32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_num_f32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_num_f32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_num_f32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_num_f32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_i32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_i32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_i32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_i32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i64 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i64 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i64 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i64 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i64 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_i64 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_i64 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_i64 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_i64 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i64 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_u32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_u32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_u32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_u32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u64 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u64 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u64 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u64 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u64 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_u64 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_u64 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_u64 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_max_u64 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u64 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_num_f32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_num_f32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_num_f32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_num_f32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_num_f32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_num_f32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_num_f32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_num_f32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_num_f32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_num_f32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_num_f32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_min_num_f32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_min_num_f32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_min_num_f32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_min_num_f32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_min_num_f32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_num_f32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_num_f32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_num_f32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_num_f32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_num_f32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_num_f32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_i32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_i32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_i32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_i32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i64 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i64 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i64 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i64 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i64 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_i64 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_i64 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_i64 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_i64 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i64 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_u32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_u32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_u32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_u32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u64 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u64 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u64 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u64 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u64 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_u64 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_u64 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_u64 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_min_u64 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u64 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_or_b32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_or_b32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_or_b32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_or_b32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b64 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b64 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b64 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b64 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b64 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_or_b64 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_or_b64 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_or_b64 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_or_b64 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b64 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_sub_u32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_sub_u32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_sub_u32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_sub_u32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u64 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u64 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u64 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_sub_u64 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_sub_u64 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_sub_u64 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_sub_u64 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u64 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_swap_b32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_swap_b32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_swap_b32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_swap_b32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b64 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b64 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b64 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_swap_b64 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_swap_b64 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_swap_b64 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_swap_b64 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b64 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b32 v5, off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_xor_b32 v5, off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_xor_b32 v5, off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_xor_b32 v5, off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_xor_b32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b64 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b64 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b64 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], 0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_xor_b64 v[5:6], off, s[8:11], -1 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_xor_b64 v[5:6], off, s[8:11], 0.5 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_xor_b64 v[5:6], off, s[8:11], -4.0 offset:8388607
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

buffer_atomic_xor_b64 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b64 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RT_RETURN scope:SCOPE_SE
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x94,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_CASCADE_NT scope:SCOPE_DEV
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0xe8,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:8388607 glc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:8388607 slc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:8388607 dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:8388607 glc slc dlc
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction
